(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10456,        419]*)
(*NotebookOutlinePosition[     11231,        447]*)
(*  CellTagsIndexPosition[     11187,        443]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title",
  TextAlignment->Center],

Cell[TextData[{
  "The example programs and packages in ",
  StyleBox["AddOns/ExtraPackages/ProgrammingInMathematica", "Input"],
  " accompany the book"
}], "Text"],

Cell[TextData[{
  "Roman E. Maeder: Programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd ed., Addison-Wesley, 1996\nISBN 0-201-85449-X."
}], "Text",
  CellMargins->{{50, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left],

Cell[TextData[{
  "The third edition covers ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", Versions 3 and 4, and has been expanded considerably over the first and \
second editions."
}], "Text"],

Cell[TextData[{
  "For more information, visit the book's WWW site at ",
  ButtonBox["http://www.wolfram.com/Maeder/ProgInMath/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/Maeder/ProgInMath/"], None},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell[CellGroupData[{

Cell["The Files in ProgrammingInMathematica", "Section",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
These programs are not maintained by Wolfram Research, Inc., and \
Wolfram Research technical support will not answer questions about these \
programs.\
\>", "Text"],

Cell["Packages (Files with a .m extension)", "Subsection"],

Cell[TextData[{
  "Except for the iterated function systems example (Chapter 12), the \
packages are not documented on line. They are fully described in the book ",
  StyleBox["Programming in Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["Notebooks", "Subsection"],

Cell[TextData[{
  ButtonBox["BookPictures.nb",
    ButtonData:>{
      FrontEnd`FileName[ 
      {$TopDirectory, "AddOns", "ExtraPackages", "ProgrammingInMathematica"}, 
        "BookPictures.nb", CharacterEncoding -> "ISO8859-1"], None},
    ButtonStyle->"Hyperlink"],
  " contains the code and graphics of all chapter-opener pictures."
}], "Text"],

Cell[TextData[{
  ButtonBox["ChaosGame.nb",
    ButtonData:>{
      FrontEnd`FileName[ 
      {$TopDirectory, "AddOns", "ExtraPackages", "ProgrammingInMathematica"}, 
        "ChaosGame.nb", CharacterEncoding -> "ISO8859-1"], None},
    ButtonStyle->"Hyperlink"],
  " is a package in notebook form. The package ",
  StyleBox["ChaosGame.m", "Input"],
  " is updated automatically everytime the notebook is saved."
}], "Text"],

Cell[TextData[{
  ButtonBox["NotebookDemo.nb",
    ButtonData:>{
      FrontEnd`FileName[ 
      {$TopDirectory, "AddOns", "ExtraPackages", "ProgrammingInMathematica"}, 
        "NotebookDemo.nb", CharacterEncoding -> "ISO8859-1"], None},
    ButtonStyle->"Hyperlink"],
  " contains examples of frontend programming."
}], "Text"],

Cell[TextData[{
  ButtonBox["Template.nb",
    ButtonData:>{
      FrontEnd`FileName[ 
      {$TopDirectory, "AddOns", "ExtraPackages", "ProgrammingInMathematica"}, 
        "Template.nb", CharacterEncoding -> "ISO8859-1"], None},
    ButtonStyle->"Hyperlink"],
  " is a template for notebooks and packages."
}], "Text"],

Cell["Documentation Directory", "Subsection"],

Cell[TextData[{
  "The notebooks and the ",
  StyleBox["BrowserCategories.m", "Input"],
  " file in ",
  StyleBox["Documentation/English", "Input"],
  " are part of the on-line help for ",
  StyleBox["Programming in Mathematica",
    FontSlant->"Italic"],
  ".  The entry \"Programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\" should appear under the topic ",
  StyleBox["AddOns",
    FontSlant->"Italic"],
  ", subtopic ",
  StyleBox["Extras",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Programming in Mathematica",
    FontSlant->"Italic"],
  " Table of Contents"
}], "Section",
  ShowGroupOpenCloseIcon->True],

Cell["Preface", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell[CellGroupData[{

Cell["About This Book", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\tChapter Overview
\tAbout the Examples
\tNotation and Terminology
\tElectronic Resources
\tTeaching Mathematica Programming\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 1 Introduction", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t1.1 From Calculations to Programs
\t1.2 Basic Ingredients of a Package
\t1.3 A Second Function in the Package
\t1.4 Options
\t1.5 Defaults for Positional Arguments
\t1.6 Parameter Type Checking\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 2 Packages", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t2.1 Contexts
\t2.2 Packages that Use Other Packages
\t2.3 Protection of Symbols in a Package
\t2.4 Package Framework and Documentation
\t2.5 Loading Packages
\t2.6 Large Projects\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 3 Defaults and Options", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t3.1 Default Values
\t3.2 Options for Your Functions
\t3.3 Setting Options of Several Commands\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 4 Functional and Procedural Programming", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t4.1 Procedures and Local Variables
\t4.2 Loops
\t4.3 Structured Iteration
\t4.4 Iterated Function Application
\t4.5 Map and Apply
\t4.6 Application: The Platonic Solids
\t4.7 Operations on Lists and Matrices\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 5 Evaluation", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t5.1 Evaluation of the Body of a Rule
\t5.2 Pure Functions
\t5.3 Nonstandard Evaluation
\t5.4 Nonlocal Flow of Control
\t5.5 Definitions
\t5.6 Advanced Topic: Scopes of Names\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 6 Transformation Rules", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t6.1 Simplification Rules and Normal Forms
\t6.2 Application: Trigonometric Simplifications
\t6.3 Globally Defined Rules
\t6.4 Pattern Matching for Rules
\t6.5 Traversing Expressions\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 7 Numerical Computations", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t7.1 Numbers
\t7.2 Numerical Evaluation
\t7.3 Numeric Quantities
\t7.4 Application: Differential Equations\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 8 Interaction with Built-In Rules", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t8.1 Modifying the Main Evaluation Loop
\t8.2 User-Defined Rules Take Precedence
\t8.3 Modifying System Function
\t8.4 Advanced Topic: A New Mathematical Function\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell[" 9 Input and Output", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t9.1 Input and Output Formatting
\t9.2 Input from Files and Programs
\t9.3 Running \\@Om \\ Unattended
\t9.4 Session Logging
\t9.5 Advanced Topic: Typesetting Mathematics\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10 Graphics Programming", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t10.1 Graphics Packages
\t10.2 Animated Graphics
\t10.3 The Chapter Pictures\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell["11 Notebooks", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t11.1 Packages and Notebooks
\t11.2 The Structure of Notebooks
\t11.3 Frontend Programming\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell["12 Application: Iterated Function Systems", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\t12.1 Affine Maps
\t12.2 Iterated Function Systems
\t12.3 Examples of Invariant Sets
\t12.4 Documentation: Help Notebooks and Manuals\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix A Exercises", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\tA.1 Programming Exercises
\tA.2 Solutions\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix B Bibliography", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\tB.1 Background Information and Further Reading
\tB.2 References\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Index", "Subsection",
  ShowGroupOpenCloseIcon->True],

Cell["\<\
\tPrograms
\tSubjects and Names
\
\>", "Text",
  ShowGroupOpenCloseIcon->True]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{691, 788},
WindowMargins->{{54, Automatic}, {41, Automatic}},
ShowCellTags->True,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 125, 5, 110, "Title"],
Cell[1867, 58, 164, 4, 25, "Text"],
Cell[2034, 64, 255, 7, 48, "Text"],
Cell[2292, 73, 207, 6, 24, "Text"],
Cell[2502, 81, 253, 6, 24, "Text"],

Cell[CellGroupData[{
Cell[2780, 91, 88, 1, 60, "Section"],
Cell[2871, 94, 175, 4, 40, "Text"],
Cell[3049, 100, 58, 0, 43, "Subsection"],
Cell[3110, 102, 249, 6, 40, "Text"],
Cell[3362, 110, 31, 0, 43, "Subsection"],
Cell[3396, 112, 349, 8, 24, "Text"],
Cell[3748, 122, 424, 10, 41, "Text"],
Cell[4175, 134, 329, 8, 24, "Text"],
Cell[4507, 144, 320, 8, 24, "Text"],
Cell[4830, 154, 45, 0, 43, "Subsection"],
Cell[4878, 156, 511, 18, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5426, 179, 152, 5, 60, "Section"],
Cell[5581, 186, 61, 1, 43, "Subsection"],

Cell[CellGroupData[{
Cell[5667, 191, 69, 1, 43, "Subsection"],
Cell[5739, 194, 180, 7, 120, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[5956, 206, 69, 1, 43, "Subsection"],
Cell[6028, 209, 251, 8, 144, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6316, 222, 65, 1, 43, "Subsection"],
Cell[6384, 225, 236, 8, 144, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6657, 238, 77, 1, 43, "Subsection"],
Cell[6737, 241, 151, 5, 72, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6925, 251, 94, 1, 43, "Subsection"],
Cell[7022, 254, 265, 9, 168, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7324, 268, 67, 1, 43, "Subsection"],
Cell[7394, 271, 231, 8, 144, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7662, 284, 77, 1, 43, "Subsection"],
Cell[7742, 287, 239, 7, 120, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8018, 299, 79, 1, 43, "Subsection"],
Cell[8100, 302, 163, 6, 96, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8300, 313, 88, 1, 43, "Subsection"],
Cell[8391, 316, 219, 6, 96, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8647, 327, 73, 1, 43, "Subsection"],
Cell[8723, 330, 227, 7, 120, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8987, 342, 77, 1, 43, "Subsection"],
Cell[9067, 345, 133, 5, 72, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[9237, 355, 66, 1, 43, "Subsection"],
Cell[9306, 358, 147, 5, 72, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[9490, 368, 95, 1, 43, "Subsection"],
Cell[9588, 371, 190, 6, 96, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[9815, 382, 74, 1, 43, "Subsection"],
Cell[9892, 385, 99, 4, 48, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[10028, 394, 77, 1, 43, "Subsection"],
Cell[10108, 397, 121, 4, 48, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[10266, 406, 59, 1, 43, "Subsection"],
Cell[10328, 409, 88, 5, 72, "Text"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

