(**************** Content-type: application/mathematica ****************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11610,        520]*)
(*NotebookOutlinePosition[     12460,        549]*)
(*  CellTagsIndexPosition[     12416,        545]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Package Template", "Title",
  TextAlignment->Center],

Cell["by Roman E. Maeder", "Subsubtitle",
  TextAlignment->Center],

Cell["\<\
This notebook is a template for package and notebook development.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell["Reference", "Section"],

Cell[CellGroupData[{

Cell["Title", "Subsubsection"],

Cell[TextData[StyleBox["Package template",
  FontSlant->"Italic"]], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Author", "Subsubsection"],

Cell["Roman E. Maeder", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summary", "Subsubsection"],

Cell["\<\
This notebook is a template for package and notebook development.\
\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copyright", "Subsubsection"],

Cell[TextData[{
  "\[Copyright] Copyright 2000, ",
  StyleBox["your name or institution",
    FontSlant->"Italic"],
  ".\n\nPermission is granted to distribute this file for any purpose except \
for inclusion in commercial software or program collections. This copyright \
notice must remain intact.."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Version", "Subsubsection"],

Cell["1.0", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version"
}], "Subsubsection"],

Cell["3.0", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["History", "Subsubsection"],

Cell[TextData[{
  "Version 1.0 for ",
  StyleBox["Programming in ",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd edition."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Keywords", "Subsubsection"],

Cell["programming, notebooks, packages, template", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Source", "Subsubsection"],

Cell[TextData[{
  "Maeder, R. ",
  StyleBox["Programming in ",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd ed. Addison-Wesley, 1996."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Warnings", "Subsubsection"],

Cell[TextData[StyleBox["description of global effects, incompatibilities",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  "Note: all cells marked as \"InitializationCell\" will be written to the \
Auto-Save package. This package can then be read in programs that use it with \
",
  StyleBox["Needs[\"Template`\"]", "Input"],
  ". Cells not intended to belong to the package should not have this \
property."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limitation", "Subsubsection"],

Cell[TextData[StyleBox["special cases not handled, known problems",
  FontSlant->"Italic"]], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Discussion", "Subsubsection"],

Cell[TextData[StyleBox["description of algorithm, information for experts",
  FontSlant->"Italic"]], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Requirements", "Subsubsection"],

Cell[TextData[StyleBox["Context`Package`",
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Setup", "Section"],

Cell["\<\
This section contains commands needed to load the corresponding \
package. It may be omitted for notebooks that are used only to generate an \
auto-save package.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Development", "Subsubsection",
  Background->GrayLevel[0.499992]],

Cell["\<\
The path on your system may be different from the path used for the \
final package. For convenience, you can put the development path here. Delete \
this subsection before distributing this notebook.\
\>", "Text"],

Cell[TextData[{
  "SetDirectory[\"",
  StyleBox["development directory",
    FontSlant->"Italic"],
  "\"]"
}], "Input",
  Background->GrayLevel[0.499992]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Search Path", "Subsubsection"],

Cell["\<\
Make sure that the directory containing the packages is either the \
current directory\
\>", "Text"],

Cell[TextData[{
  "SetDirectory[\"",
  StyleBox["full path name",
    FontSlant->"Italic"],
  "\"]"
}], "Input"],

Cell["or is on the search path", "Text"],

Cell[TextData[{
  "AppendTo[$Path, \"",
  StyleBox["full path name",
    FontSlant->"Italic"],
  "\"]"
}], "Input"],

Cell["\<\
Note: the two input cells above have been made un-evaluatable \
because you first have to enter the correct path name for your system before \
you can evaluate one of them (make the one you chose evaluatable to do so).\
\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Read in the Package", "Subsubsection"],

Cell[TextData[{
  "The code is contained in the package ",
  StyleBox["Template",
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[".m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", which is simply read in here."
}], "Text"],

Cell[TextData[{
  "Needs[\"",
  StyleBox["Template",
    FontSlant->"Italic"],
  "`\"]"
}], "Input"],

Cell["Standard packages needed for the examples:", "Text"],

Cell["Needs[\"Graphics`Animation`\"]", "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interface", "Section",
  InitializationCell->True],

Cell["\<\
This part declares the publicly visible functions, options, and \
values.\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Set up the package context, including public imports", "Subsection",
  InitializationCell->True],

Cell["\<\
BeginPackage[\"ProgrammingInMathematica`Template`\",
\t\"ProgrammingInMathematica`Package1`\", \
\"ProgrammingInMathematica`Package2`\"]\
\>", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Usage messages for the exported functions and the context \
itself\
\>", "Subsection",
  InitializationCell->True],

Cell["\<\
Template::usage = \"Template.m is a package that does \
nothing.\"\
\>", "Input",
  InitializationCell->True],

Cell["Function1::usage = \"Function1[n] does nothing.\"", "Input",
  InitializationCell->True],

Cell["\<\
Function2::usage = \"Function2[n, (m:17)] does even more nothing.\"\
\
\>", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error messages for the exported objects", "Subsection",
  InitializationCell->True],

Cell["\<\
Template::badarg = \"You twit, you called `1` with argument \
`2`!\"\
\>", "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation", "Section",
  InitializationCell->True],

Cell["\<\
This part contains the actual definitions and any auxiliary \
functions that should not be visible outside.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Begin the private context (implementation part)", "Subsection",
  InitializationCell->True],

Cell["Begin[\"`Private`\"]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Read in any hidden imports", "Subsection",
  InitializationCell->True],

Cell["Needs[\"ProgrammingInMathematica`Package3`\"]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Unprotect any system functions for which definitions will be made\
\
\>", "Subsection",
  InitializationCell->True],

Cell["protected = Unprotect[ Sin, Cos ]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Definition of auxiliary functions and local (static) \
variables\
\>", "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Aux[]", "Input"]], "Subsubsection",
  InitializationCell->True],

Cell["Aux[f_] := Do[something]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["staticvar", "Input"]], "Subsubsection",
  InitializationCell->True],

Cell["staticvar = 0", "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of the exported functions", "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Function1[]", "Input"]], "Subsubsection",
  InitializationCell->True],

Cell["Function1[n_] := n", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Function2[]", "Input"]], "Subsubsection",
  InitializationCell->True],

Cell["\<\
Function2[n_, m_:17] := n m /; n < 5 || Message[Template::badarg, \
Function2, n]\
\>", "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definitions for system functions", "Subsection",
  InitializationCell->True],

Cell["Sin/: Sin[x_]^2 := 1 - Cos[x]^2", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Restore protection of system symbols", "Subsection",
  InitializationCell->True],

Cell["Protect[ Evaluate[protected] ]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["End the private context", "Subsection",
  InitializationCell->True],

Cell["End[ ]", "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Epilog", "Section",
  InitializationCell->True],

Cell["This section protects exported symbols and ends the package.", "Text"],

Cell[CellGroupData[{

Cell["Protect exported symbol", "Subsection",
  InitializationCell->True],

Cell["Protect[ Function1, Function2 ]", "Input",
  InitializationCell->True],

Cell["Alternative: protect all exported symbols", "Text",
  InitializationCell->True],

Cell["Protect[Evaluate[$Context <> \"*\"]]", "Input",
  Evaluatable->False,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["End the package context", "Subsection",
  InitializationCell->True],

Cell["EndPackage[ ]", "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples, Tests", "Section"],

Cell[TextData[StyleBox["Examples, tests for the use of the package can go \
here.",
  FontSlant->"Italic"]], "Text"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1152}, {0, 864}},
AutoGeneratedPackage->Automatic,
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 266}, {Automatic, 124}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 58, 1, 117, "Title"],
Cell[1800, 54, 66, 1, 53, "Subsubtitle"],
Cell[1869, 57, 91, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[1985, 64, 28, 0, 60, "Section"],

Cell[CellGroupData[{
Cell[2038, 68, 30, 0, 42, "Subsubsection"],
Cell[2071, 70, 75, 1, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2183, 76, 31, 0, 42, "Subsubsection"],
Cell[2217, 78, 31, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2285, 83, 32, 0, 42, "Subsubsection"],
Cell[2320, 85, 91, 3, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2448, 93, 34, 0, 42, "Subsubsection"],
Cell[2485, 95, 313, 7, 86, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2835, 107, 41, 0, 42, "Subsubsection"],
Cell[2879, 109, 19, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2935, 114, 101, 4, 70, "Subsubsection"],
Cell[3039, 120, 19, 0, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3095, 125, 32, 0, 42, "Subsubsection"],
Cell[3130, 127, 176, 7, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3343, 139, 33, 0, 42, "Subsubsection"],
Cell[3379, 141, 58, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3474, 146, 31, 0, 42, "Subsubsection"],
Cell[3508, 148, 188, 7, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3733, 160, 33, 0, 42, "Subsubsection"],
Cell[3769, 162, 107, 1, 32, "Text"],
Cell[3879, 165, 315, 7, 68, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4231, 177, 35, 0, 42, "Subsubsection"],
Cell[4269, 179, 100, 1, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4406, 185, 35, 0, 42, "Subsubsection"],
Cell[4444, 187, 108, 1, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4589, 193, 37, 0, 42, "Subsubsection"],
Cell[4629, 195, 122, 3, 32, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[4800, 204, 24, 0, 40, "Section"],
Cell[4827, 206, 185, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[5037, 214, 71, 1, 70, "Subsubsection"],
Cell[5111, 217, 224, 4, 70, "Text"],
Cell[5338, 223, 154, 6, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5529, 234, 36, 0, 70, "Subsubsection"],
Cell[5568, 236, 110, 3, 70, "Text"],
Cell[5681, 241, 112, 5, 70, "Input"],
Cell[5796, 248, 40, 0, 70, "Text"],
Cell[5839, 250, 115, 5, 70, "Input"],
Cell[5957, 257, 244, 5, 70, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6238, 267, 44, 0, 70, "Subsubsection"],
Cell[6285, 269, 275, 10, 70, "Text"],
Cell[6563, 281, 100, 5, 70, "Input"],
Cell[6666, 288, 58, 0, 70, "Text"],
Cell[6727, 290, 47, 0, 70, "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[6823, 296, 56, 1, 40, "Section",
  InitializationCell->True],
Cell[6882, 299, 125, 4, 70, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7032, 307, 102, 1, 70, "Subsection",
  InitializationCell->True],
Cell[7137, 310, 189, 5, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7363, 320, 124, 4, 70, "Subsection",
  InitializationCell->True],
Cell[7490, 326, 119, 4, 70, "Input",
  InitializationCell->True],
Cell[7612, 332, 94, 1, 70, "Input",
  InitializationCell->True],
Cell[7709, 335, 122, 4, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7868, 344, 89, 1, 70, "Subsection",
  InitializationCell->True],
Cell[7960, 347, 121, 4, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[8130, 357, 61, 1, 40, "Section",
  InitializationCell->True],
Cell[8194, 360, 131, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[8350, 367, 97, 1, 70, "Subsection",
  InitializationCell->True],
Cell[8450, 370, 65, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8552, 376, 76, 1, 70, "Subsection",
  InitializationCell->True],
Cell[8631, 379, 90, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8758, 385, 125, 4, 70, "Subsection",
  InitializationCell->True],
Cell[8886, 391, 78, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9001, 397, 122, 4, 70, "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[9148, 405, 87, 1, 70, "Subsubsection",
  InitializationCell->True],
Cell[9238, 408, 69, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9344, 414, 91, 1, 70, "Subsubsection",
  InitializationCell->True],
Cell[9438, 417, 58, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9545, 424, 86, 1, 70, "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[9656, 429, 93, 1, 70, "Subsubsection",
  InitializationCell->True],
Cell[9752, 432, 63, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9852, 438, 93, 1, 70, "Subsubsection",
  InitializationCell->True],
Cell[9948, 441, 134, 4, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10131, 451, 82, 1, 70, "Subsection",
  InitializationCell->True],
Cell[10216, 454, 76, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10329, 460, 86, 1, 70, "Subsection",
  InitializationCell->True],
Cell[10418, 463, 75, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10530, 469, 73, 1, 70, "Subsection",
  InitializationCell->True],
Cell[10606, 472, 51, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[10706, 479, 53, 1, 40, "Section",
  InitializationCell->True],
Cell[10762, 482, 76, 0, 70, "Text"],

Cell[CellGroupData[{
Cell[10863, 486, 73, 1, 70, "Subsection",
  InitializationCell->True],
Cell[10939, 489, 76, 1, 70, "Input",
  InitializationCell->True],
Cell[11018, 492, 85, 1, 70, "Text",
  InitializationCell->True],
Cell[11106, 495, 103, 2, 70, "Input",
  Evaluatable->False,
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11246, 502, 73, 1, 70, "Subsection",
  InitializationCell->True],
Cell[11322, 505, 58, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[11429, 512, 34, 0, 40, "Section"],
Cell[11466, 514, 116, 2, 70, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

