(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8554,        289]*)
(*NotebookOutlinePosition[     12775,        414]*)
(*  CellTagsIndexPosition[     12044,        388]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "This is the browser index file for the Notation package documentation. It \
is for the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0"
}], "Text"],

Cell["Extra Utilities: Notation", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[TextData[{
  "Notation Package,\n        documentation of,  ",
  ButtonBox["Notation Package",
    ButtonData:>{"Notation Documentation", "Notation Documentation"},
    ButtonStyle->"AddOnsLink"],
  "\n        ",
  ButtonBox["Notation",
    ButtonData:>{"Notation:Definition:Notation"},
    ButtonStyle->"AddOnsLink"],
  " \n        ",
  ButtonBox["Symbolize",
    ButtonData:>{"Notation:Definition:Symbolize"},
    ButtonStyle->"AddOnsLink"],
  " \n        ",
  ButtonBox["InfixNotation",
    ButtonData:>{"Notation:Definition:InfixNotation"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Notation Package"],

Cell[TextData[{
  "Notations, creating new, ",
  ButtonBox["Notation",
    ButtonData:>{"Notation:Definition:Notation"},
    ButtonStyle->"AddOnsLink"],
  "\n        entering of, ",
  ButtonBox["entering",
    ButtonData:>{"Notation:Documentation:Entering Notations"},
    ButtonStyle->"AddOnsLink"],
  "\n        options of, ",
  ButtonBox["options",
    ButtonData:>{"Notation Documentation", "Notation:Documentation:Options"},
    ButtonStyle->"AddOnsLink"],
  "\n        advanced features of, ",
  ButtonBox["Notation Package",
    ButtonData:>{"Notation Documentation", 
      "Notation:Documentation:Advanced Features"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{"Notation", "Notations"}],

Cell[TextData[{
  StyleBox["Notation", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:Notation"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->{"Notation", "Notations"}],

Cell[TextData[{
  "Symbolizations, creating new, ",
  ButtonBox["Symbolize",
    ButtonData:>{"Notation:Definition:Symbolize"},
    ButtonStyle->"AddOnsLink"],
  "\n        entering of, ",
  ButtonBox["entering",
    ButtonData:>{"Notation:Documentation:Entering Notations"},
    ButtonStyle->"AddOnsLink"],
  "\n        options of, ",
  ButtonBox["options",
    ButtonData:>{"Notation Documentation", "Notation:Documentation:Options"},
    ButtonStyle->"AddOnsLink"],
  "\n        advanced features of, ",
  ButtonBox["Notation Package",
    ButtonData:>{"Notation Documentation", 
      "Notation:Documentation:Advanced Features"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{"Symbolize", "Symbolizations"}],

Cell[TextData[{
  "Symbols, creating from composite structures, ",
  ButtonBox["Symbolize",
    ButtonData:>{"Notation:Definition:Symbolize"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Symbols"],

Cell[TextData[{
  StyleBox["Symbolize", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:Symbolize"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->{"Symbolize", "Symbolizations"}],

Cell[TextData[{
  "Infix notations, creating new, ",
  ButtonBox["InfixNotation",
    ButtonData:>{"Notation:Definition:InfixNotation"},
    ButtonStyle->"AddOnsLink"],
  "\n        entering of, ",
  ButtonBox["entering",
    ButtonData:>{"Notation:Documentation:Entering Notations"},
    ButtonStyle->"AddOnsLink"],
  "\n        options of, ",
  ButtonBox["options",
    ButtonData:>{"Notation Documentation", "Notation:Documentation:Options"},
    ButtonStyle->"AddOnsLink"],
  "\n        advanced features of, ",
  ButtonBox["Notation Package",
    ButtonData:>{"Notation Documentation", 
      "Notation:Documentation:Advanced Features"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{"InfixNotation", "InfixNotations"}],

Cell[TextData[{
  "Infix operators, creating from composite structures, ",
  ButtonBox["InfixNotation",
    ButtonData:>{"Notation:Definition:InfixNotation"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{"Infix notation", "Infix operators"}],

Cell[TextData[{
  StyleBox["InfixNotation", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:InfixNotation"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"InfixNotation"],

Cell[TextData[{
  StyleBox["ClearNotations", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:ClearNotations"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"ClearNotations"],

Cell[TextData[{
  StyleBox["Action", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:Action"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->"Action"],

Cell[TextData[{
  StyleBox["WorkingForm", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:WorkingForm"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WorkingForm"],

Cell[TextData[{
  StyleBox["AutoLoadNotationPalette", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:AutoLoadNotationPalette"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AutoLoadNotationPalette"],

Cell[TextData[{
  "Precedence, of composite structures, ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Documentation:Precedence"},
    ButtonStyle->"AddOnsLink"],
  "\n        changing precedences of, using ",
  ButtonBox["SyntaxForm",
    ButtonData:>{"Notation Documentation", 
      "Notation:Documentation:SyntaxForm"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Precedence"],

Cell[TextData[{
  "Notation Package,\n        use of, ",
  ButtonBox["TagBoxes",
    ButtonData:>{"Notation Documentation", 
      "Notation:Documentation:TagBoxes"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TagBox"],

Cell[TextData[{
  "Notation Package,\n        use of, ",
  ButtonBox["SyntaxForm",
    ButtonData:>{"Notation Documentation", 
      "Notation:Documentation:SyntaxForm"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SyntaxForm"],

Cell[TextData[{
  StyleBox["NotationBoxTag", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:NotationBoxTag"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NotationBoxTag"],

Cell[TextData[{
  StyleBox["NotationPatternTag", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:NotationPatternTag"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NotationPatternTag"],

Cell[TextData[{
  StyleBox["NotationMadeBoxesTag", "MR"],
  ", ",
  ButtonBox["Utilities`Notation`",
    ButtonData:>{"Notation:Definition:NotationMadeBoxesTag"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NotationMadeBoxesTag"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 1024}, {0, 748}},
ScreenStyleEnvironment->"AllBrackets",
WindowSize->{582, 525},
WindowMargins->{{37, Automatic}, {Automatic, 21}},
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1969, 60, 83, 1, 41, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "Notation Package"->{
    Cell[2055, 63, 632, 19, 74, "Index",
      CellTags->"Notation Package"]},
  "Notation"->{
    Cell[2690, 84, 709, 19, 60, "Index",
      CellTags->{"Notation", "Notations"}],
    Cell[3402, 105, 228, 8, 15, "Index",
      CellTags->{"Notation", "Notations"}]},
  "Notations"->{
    Cell[2690, 84, 709, 19, 60, "Index",
      CellTags->{"Notation", "Notations"}],
    Cell[3402, 105, 228, 8, 15, "Index",
      CellTags->{"Notation", "Notations"}]},
  "Symbolize"->{
    Cell[3633, 115, 722, 19, 60, "Index",
      CellTags->{"Symbolize", "Symbolizations"}],
    Cell[4570, 144, 236, 8, 15, "Index",
      CellTags->{"Symbolize", "Symbolizations"}]},
  "Symbolizations"->{
    Cell[3633, 115, 722, 19, 60, "Index",
      CellTags->{"Symbolize", "Symbolizations"}],
    Cell[4570, 144, 236, 8, 15, "Index",
      CellTags->{"Symbolize", "Symbolizations"}]},
  "Symbols"->{
    Cell[4358, 136, 209, 6, 15, "Index",
      CellTags->"Symbols"]},
  "InfixNotation"->{
    Cell[4809, 154, 735, 19, 60, "Index",
      CellTags->{"InfixNotation", "InfixNotations"}],
    Cell[5803, 183, 228, 8, 15, "Index",
      CellTags->"InfixNotation"]},
  "InfixNotations"->{
    Cell[4809, 154, 735, 19, 60, "Index",
      CellTags->{"InfixNotation", "InfixNotations"}]},
  "Infix notation"->{
    Cell[5547, 175, 253, 6, 15, "Index",
      CellTags->{"Infix notation", "Infix operators"}]},
  "Infix operators"->{
    Cell[5547, 175, 253, 6, 15, "Index",
      CellTags->{"Infix notation", "Infix operators"}]},
  "ClearNotations"->{
    Cell[6034, 193, 231, 8, 15, "Index",
      CellTags->"ClearNotations"]},
  "Action"->{
    Cell[6268, 203, 207, 8, 15, "Index",
      CellTags->"Action"]},
  "WorkingForm"->{
    Cell[6478, 213, 215, 7, 15, "Index",
      CellTags->"WorkingForm"]},
  "AutoLoadNotationPalette"->{
    Cell[6696, 222, 251, 7, 15, "Index",
      CellTags->"AutoLoadNotationPalette"]},
  "Precedence"->{
    Cell[6950, 231, 411, 11, 30, "Index",
      CellTags->"Precedence"]},
  "TagBox"->{
    Cell[7364, 244, 232, 7, 29, "Index",
      CellTags->"TagBox"]},
  "SyntaxForm"->{
    Cell[7599, 253, 240, 7, 41, "Index",
      CellTags->"SyntaxForm"]},
  "NotationBoxTag"->{
    Cell[7842, 262, 224, 7, 27, "Index",
      CellTags->"NotationBoxTag"]},
  "NotationPatternTag"->{
    Cell[8069, 271, 236, 7, 27, "Index",
      CellTags->"NotationPatternTag"]},
  "NotationMadeBoxesTag"->{
    Cell[8308, 280, 242, 7, 27, "Index",
      CellTags->"NotationMadeBoxesTag"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 9435, 311},
  {"Notation Package", 9545, 314},
  {"Notation", 9640, 317},
  {"Notations", 9828, 322},
  {"Symbolize", 10016, 327},
  {"Symbolizations", 10222, 332},
  {"Symbols", 10421, 337},
  {"InfixNotation", 10512, 340},
  {"InfixNotations", 10706, 345},
  {"Infix notation", 10825, 348},
  {"Infix operators", 10946, 351},
  {"ClearNotations", 11066, 354},
  {"Action", 11157, 357},
  {"WorkingForm", 11245, 360},
  {"AutoLoadNotationPalette", 11350, 363},
  {"Precedence", 11454, 366},
  {"TagBox", 11542, 369},
  {"SyntaxForm", 11629, 372},
  {"NotationBoxTag", 11724, 375},
  {"NotationPatternTag", 11827, 378},
  {"NotationMadeBoxesTag", 11936, 381}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 249, 9, 40, "Text"],
Cell[1969, 60, 83, 1, 41, "IndexSection",
  CellTags->"MasterIndexHeading"],
Cell[2055, 63, 632, 19, 74, "Index",
  CellTags->"Notation Package"],
Cell[2690, 84, 709, 19, 60, "Index",
  CellTags->{"Notation", "Notations"}],
Cell[3402, 105, 228, 8, 15, "Index",
  CellTags->{"Notation", "Notations"}],
Cell[3633, 115, 722, 19, 60, "Index",
  CellTags->{"Symbolize", "Symbolizations"}],
Cell[4358, 136, 209, 6, 15, "Index",
  CellTags->"Symbols"],
Cell[4570, 144, 236, 8, 15, "Index",
  CellTags->{"Symbolize", "Symbolizations"}],
Cell[4809, 154, 735, 19, 60, "Index",
  CellTags->{"InfixNotation", "InfixNotations"}],
Cell[5547, 175, 253, 6, 15, "Index",
  CellTags->{"Infix notation", "Infix operators"}],
Cell[5803, 183, 228, 8, 15, "Index",
  CellTags->"InfixNotation"],
Cell[6034, 193, 231, 8, 15, "Index",
  CellTags->"ClearNotations"],
Cell[6268, 203, 207, 8, 15, "Index",
  CellTags->"Action"],
Cell[6478, 213, 215, 7, 15, "Index",
  CellTags->"WorkingForm"],
Cell[6696, 222, 251, 7, 15, "Index",
  CellTags->"AutoLoadNotationPalette"],
Cell[6950, 231, 411, 11, 30, "Index",
  CellTags->"Precedence"],
Cell[7364, 244, 232, 7, 29, "Index",
  CellTags->"TagBox"],
Cell[7599, 253, 240, 7, 41, "Index",
  CellTags->"SyntaxForm"],
Cell[7842, 262, 224, 7, 27, "Index",
  CellTags->"NotationBoxTag"],
Cell[8069, 271, 236, 7, 27, "Index",
  CellTags->"NotationPatternTag"],
Cell[8308, 280, 242, 7, 27, "Index",
  CellTags->"NotationMadeBoxesTag"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

