(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    163069,       5069]*)
(*NotebookOutlinePosition[    277952,       8440]*)
(*  CellTagsIndexPosition[    275723,       8384]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["", "Section",
  CellMargins->{{0, 0}, {0, 0}},
  CellElementSpacings->{"CellMinHeight"->1,
  "ClosedCellHeight"->1,
  "GroupIconTopMargin"->1},
  CellGroupingRules->"SectionGrouping",
  FontSize->9],

Cell["\<\
These cells are here with the correct cell tags so they can copied \
when the help browser loads just a subsection of the documentation. This \
means the titles can always be open.\
\>", "Text"],

Cell["Notation, Symbolize and InfixNotation", "Subsection",
  CellTags->"Notation:S1"],

Cell["Notation", "Subsubsection",
  CellTags->"Notation:S1.1"],

Cell["Symbolize", "Subsubsection",
  CellTags->"Notation:S1.2"],

Cell["Infix Notation", "Subsubsection",
  CellTags->"Notation:S1.3"],

Cell["Entering Notations", "Subsubsection",
  CellTags->"Notation:S1.4"],

Cell["Precedence of Operators in Notations", "Subsection",
  CellTags->"Notation:S2"],

Cell["How Precedence is determined", "Subsubsection",
  CellTags->"Notation:S2.1"],

Cell["Parentheses in Notations", "Subsubsection",
  CellTags->"Notation:S2.2"],

Cell["Changing Precedences in Notations", "Subsubsection",
  CellTags->"Notation:S2.3"],

Cell["Options and Auxiliary Functions", "Subsection",
  CellTags->"Notation:S3"],

Cell[TextData[{
  "The option ",
  StyleBox["Action", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.1"],

Cell[TextData[{
  "The option ",
  StyleBox["WorkingForm", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.2"],

Cell[TextData[{
  "The option",
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["AutoLoadNotationPalette", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.3"],

Cell[TextData[{
  "The function ",
  StyleBox["ClearNotations[]", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S3.4"],

Cell["Complex Patterns and Advanced Features", "Subsection",
  CellTags->"Notation:S4"],

Cell["Note: This section is intended for advanced users.", "Subsubsection",
  CellTags->{
  "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
    "Notation:S4.6"}],

Cell["Tag boxes", "Subsubsection",
  CellTags->"Notation:S4.2"],

Cell[TextData[{
  "The tag ",
  StyleBox["NotationBoxTag", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.3"],

Cell[TextData[{
  "Complex Patterns and the tag ",
  StyleBox["NotationPatternTag", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.4"],

Cell[TextData[{
  "The tag ",
  StyleBox["NotationMadeBoxesTag", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.5"],

Cell[TextData[{
  "Changing precedences and the ",
  StyleBox["TagBox", "RM"],
  " option ",
  StyleBox["SyntaxForm", "RM"]
}], "Subsubsection",
  CellTags->"Notation:S4.6"],

Cell["Advice and Suggested Guidelines", "Subsection",
  CellTags->"Notation:S5"],

Cell["Build up notations in stages", "Subsubsection",
  CellTags->"Notation:S5.1"],

Cell["Don't alter too much", "Subsubsection",
  CellTags->"Notation:S5.2"],

Cell["Follow existing conventions where possible", "Subsubsection",
  CellTags->"Notation:S5.3"],

Cell["Parse without evaluation where possible", "Subsubsection",
  CellTags->"Notation:S5.4"],

Cell["\<\
Internal and External representations which are structurally \
different\
\>", "Subsubsection",
  CellTags->"Notation:S5.5"],

Cell["Updates and Expanded Documentation", "Subsubsection",
  CellTags->"Notation:S5.6"],

Cell["Jason Harris, November 1997.", "Subsubsection",
  CellTags->"Notation:S5.7"]
}, Closed]],

Cell[CellGroupData[{

Cell["Utilities`Notation`", "Section",
  CellGroupingRules->"SectionGrouping"],

Cell[TextData[{
  "The ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package allows you to extend ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " so it understands and functions correctly with new typeset notations.  \
The package ",
  StyleBox["Notation.m", "MR"],
  " consists of three main utility functions: ",
  StyleBox["Symbolize,", "MR"],
  " ",
  StyleBox["Notation", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  ". ",
  StyleBox["Symbolize", "MR"],
  " forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to treat composite box structures internally as single symbols.  ",
  StyleBox["Notation", "MR"],
  " forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to treat classes of composite box structures internally as a class of \
full-form expressions. ",
  StyleBox["InfixNotation", "MR"],
  " forces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to treat a composite expression as an infix operator."
}], "Text"],

Cell[TextData[{
  "Without the definitions provided in this package, it is necessary to \
define new notations by constructing explicit ",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules. These rules have to be written in terms of full box structures \
that are generally long and visually unintuitive. Also, in creating a new \
notation, there are several nontrivial programming issues that must be taken \
into consideration. Hence, in the interests of readability and ease of use, \
it is desirable to be able to introduce new notations easily, intuitively, \
and graphically. The ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package provides this functionality."
}], "Text"],

Cell[TextData[{
  "You should be aware that in this version of the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package, unlike some previous versions, all notations must be entered \
through the notation palette or through input aliases. (See ",
  ButtonBox["EnteringNotations",
    ButtonData:>{"Notation:Documentation:Entering Notations", 
      "Must use palette"},
    ButtonStyle->"AddOnsLink"],
  ".) Also this version of the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package automatically adds the new notation styles into the current style \
sheet, as well as generating an updated notebook if necessary."
}], "Text"],

Cell[CellGroupData[{

Cell["Notation, Symbolize and InfixNotation", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["Notation", "SubsubsectionIcon",
  CellTags->"Notation:S1"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                  "external", " ", "\[DoubleLongLeftRightArrow]", " ", 
                    "internal"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"set", " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "parsed", " ", "to"}], " "}]
                    ,
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", "and", " "}],
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "formatted", " ", "as"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                  "external", " ", "\[DoubleLongRightArrow]", " ", "internal"}
                    ],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"set", " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "parsed", " ", "to"}], " "}]
                    ,
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                  "external", " ", "\[DoubleLongLeftArrow]", " ", "internal"}]
                    ,
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"set", " "}],
                  SingleLetterItalics->False], 
                StyleBox["internal",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"to", " ", "be", " ", "formatted", " ", "as"}], 
                    " "}],
                  SingleLetterItalics->False], 
                StyleBox["external",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Notation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["notation",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{"define", " ", "a", " ", "notation"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["notation",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"with", " ", "the", " ", "options"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RemoveNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["notation",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{"remove", " ", "the", " ", "notation"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["notation",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],

Cell["Syntax of notation declarations.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  StyleBox["Notation", "MR"],
  " takes both an external representation and an internal representation as \
arguments.  ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " translates any input matching the external representation into the \
corresponding internal representation and, reciprocally, formats any \
expression matching the internal representation into the corresponding \
external representation.  In this context, representation means a composite \
structure made up of boxes representing some \"notation\"."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell["This loads the package. ", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"<<", "Utilities`Notation`"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "The following declares a new notation for ",
  StyleBox["gplus", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"x_", " ", 
              SubscriptBox["\[CirclePlus]", "n_"], " ", "y_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"gplus", "[", 
              RowBox[{"x_", ",", "y_", ",", "n_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "Any input matching  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x_", " ", 
          RowBox[{
            SubscriptBox["\[CirclePlus]", "n_"], " ", "y_"}]}], 
        TraditionalForm]]],
  " is now interpreted as ",
  StyleBox["gplus[x,y,n]", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"a", " ", 
        SubscriptBox["\[CirclePlus]", 
          RowBox[{"n", "+", "m"}]], " ", "b"}], " ", "//", " ", "FullForm"}]
      ], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"gplus", "[", 
          RowBox[{"a", ",", "b", ",", 
            RowBox[{"Plus", "[", 
              RowBox[{"m", ",", "n"}], "]"}]}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],

Cell[TextData[{
  "Any ",
  StyleBox["gplus", "MR"],
  " expression is now formatted in the new notation."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"gplus", "[", 
      RowBox[{"\[Alpha]", ",", " ", "\[Beta]", ",", " ", "\[CapitalGamma]"}], 
      "]"}]], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"\[Alpha]", " ", 
        SubscriptBox["\[CirclePlus]", "\[CapitalGamma]"], " ", "\[Beta]"}], 
      " "}]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],

Cell[TextData[{
  "Notations defined using ",
  Cell[BoxData[
      FormBox["\[DoubleLongLeftRightArrow]", TraditionalForm]]],
  " in their definition both parse and format expressions according to the \
given notation. However, you can restrict the notation to only parsing or \
only formatting by using ",
  Cell[BoxData[
      FormBox["\[DoubleLongRightArrow]", TraditionalForm]]],
  " or ",
  Cell[BoxData[
      FormBox["\[DoubleLongLeftArrow]", TraditionalForm]]],
  " respectively, instead of ",
  Cell[BoxData[
      FormBox["\[DoubleLongLeftRightArrow]", TraditionalForm]]],
  " in your notation statements."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "This defines a notation for the parsing of a hypothetical ",
  StyleBox["DomainIntegral", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
            RowBox[{"f_", " ", 
              RowBox[{"\[CapitalDifferentialD]", "x_"}]}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"DomainIntegral", "[", 
            RowBox[{"f_", ",", "x_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  StyleBox["DomainIntegrals", "MR"],
  " are now parsable."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
      RowBox[{
        RowBox[{
          RowBox[{"\[Delta]", "'"}], "[", "x", "]"}], 
        RowBox[{"\[CapitalDifferentialD]", "x"}]}]}]], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"DomainIntegral", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["\[Delta]", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], ",", "x"}], "]"}]], 
  "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],

Cell[TextData[{
  "The following defines an output format for ",
  StyleBox["Derivative", "MR"],
  " objects that looks more like that of traditional mathematics."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[{
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          FractionBox[
            RowBox[{"\[PartialD]", 
              RowBox[{"f_", "[", "x_", "]"}]}], 
            RowBox[{"\[PartialD]", "x_"}]],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", 
        " ", 
        TagBox[
          RowBox[{
            RowBox[{
              RowBox[{"Derivative", "[", "1", "]"}], "[", "f_", "]"}], "[", 
            "x_", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", "n_"], 
              RowBox[{"f_", "[", "x_", "]"}]}], 
            RowBox[{"\[PartialD]", 
              SuperscriptBox["x_", "n_"]}]],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", 
        " ", 
        TagBox[
          RowBox[{
            RowBox[{
              RowBox[{"Derivative", "[", "n_", "]"}], "[", "f_", "]"}], "[", 
            "x_", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]}], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell["\<\
Derivatives are now formatted according to the new derivative \
notation.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SubscriptBox["\[CapitalGamma]", "\[Alpha]"], "'"}], "[", "t", "]"}
          ], ",", " ", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{"z", "+", "r"}], ")"}], "'"}], "'"}], "[", "q", "]"}]}
        ], "}"}]], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        FractionBox[
          RowBox[{"\[PartialD]", 
            RowBox[{
              SubscriptBox["\[CapitalGamma]", "\[Alpha]"], "[", "t", "]"}]}]
            , 
          RowBox[{"\[PartialD]", "t"}]], ",", 
        FractionBox[
          RowBox[{
            SuperscriptBox["\[PartialD]", "2"], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{"r", "+", "z"}], ")"}], "[", "q", "]"}]}], 
          RowBox[{"\[PartialD]", 
            SuperscriptBox["q", "2"]}]]}], "}"}]], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],

Cell["\<\
To allow the previous output to be used as input you can define an \
interpretation of partial derivatives.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[{
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", "f_"}], 
              RowBox[{"\[PartialD]", "x_"}]], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"D", "[", 
            RowBox[{"f_", ",", "x_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            FractionBox[
              RowBox[{
                SuperscriptBox["\[PartialD]", "n_"], "f_"}], 
              RowBox[{"\[PartialD]", 
                SuperscriptBox["x_", "n_"]}]], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"D", "[", 
            RowBox[{"f_", ",", 
              RowBox[{"{", 
                RowBox[{"x_", ",", "n_"}], "}"}]}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]}], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell["You can now use these new notations for derivatives.", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    FractionBox[
      RowBox[{"\[PartialD]", 
        RowBox[{"(", 
          RowBox[{
            SuperscriptBox["y", "2"], "+", 
            RowBox[{"2", "y"}], "+", " ", 
            RowBox[{"Sin", "[", "y", "]"}], "+", 
            RowBox[{"f", "[", "y", "]"}]}], ")"}]}], 
      RowBox[{"\[PartialD]", "y"}]]], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"2", "+", 
      RowBox[{"2", " ", "y"}], "+", 
      RowBox[{"Cos", "[", "y", "]"}], "+", 
      FractionBox[
        RowBox[{"\[PartialD]", 
          RowBox[{"f", "[", "y", "]"}]}], 
        RowBox[{"\[PartialD]", "y"}]]}]], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],

Cell["\<\
You should define your notations in such a way that they both parse \
and format,  since users will generally expect this functionality.\
\>", 
  "Text",
  Background->GrayLevel[1],
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[TextData[{
  "The following notation both formats and parses arrows overscripted by ",
  StyleBox["Apply", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"a_", " ", 
              OverscriptBox["\[LongRightArrow]", 
                RowBox[{" ", "Apply", " "}]], " ", "b_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{"MyApply", "[", 
            RowBox[{"a_", ",", "b_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell["\<\
Simple rules like linearity can now be entered in a visually \
intuitive way.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"a_", " ", 
        OverscriptBox["\[LongRightArrow]", 
          RowBox[{" ", "Apply", " "}]], " ", 
        RowBox[{"(", 
          RowBox[{"b_", " ", "+", " ", "c_"}], ")"}]}], " ", ":=", " ", 
      RowBox[{
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", "b"}], " ", "+", " ", 
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", "c"}]}]}]], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a", 
      OverscriptBox["\[LongRightArrow]", 
        RowBox[{" ", "Apply", " "}]], 
      RowBox[{"(", 
        RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "+", " ", 
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", "2"], 
              RowBox[{"f", "[", "x", "]"}]}], 
            RowBox[{"\[PartialD]", 
              SuperscriptBox["x", "2"]}]]}], ")"}]}]], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], " "}], "+", 
      RowBox[{
        RowBox[{"a", " ", 
          OverscriptBox["\[LongRightArrow]", 
            RowBox[{" ", "Apply", " "}]], " ", 
          FractionBox[
            RowBox[{
              SuperscriptBox["\[PartialD]", "2"], 
              RowBox[{"f", "[", "x", "]"}]}], 
            RowBox[{"\[PartialD]", 
              SuperscriptBox["x", "2"]}]]}], " "}]}]], "Output",
  CellLabel->"Out[15]=",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],

Cell[TextData[{
  "You may at first feel that having underscores on both sides of a ",
  StyleBox["Notation", "MR"],
  " statement is somewhat unsettling.  However, notational transformations \
usually work in both directions, therefore having underscores on both sides \
of a notation statement is natural, and soon becomes intuitive."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolize", "SubsubsectionIcon",
  CellTags->"Notation:S1"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Symbolize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["compositeBoxes",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["compositeBoxes",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"as", " ", "a", " ", "symbol"}]}],
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Symbolize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["compositeBoxes",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["compositeBoxes",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{
                    "as", " ", "a", " ", "symbol", " ", "with", " ", "the", 
                      " ", "options"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RemoveSymbolize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["compositeBoxes",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{
                    "remove", " ", "the", " ", "treatment", " ", "of"}], " "}]
                    ,
                  SingleLetterItalics->False], 
                StyleBox["compositeBoxes",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"as", " ", "a", " ", "symbol"}]}],
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize"}],

Cell["Syntax of symbolization declarations.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[TextData[{
  StyleBox["Symbolize", "MR"],
  " is used to treat a class of composite boxes internally as symbols. It is \
sometimes necessary and desirable to be able to symbolize composite objects; \
for example, to be able to attach rules to a composite object, it must be \
treated as a symbol."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell["\<\
This declares that the composite object \[ScriptCapitalD]\[ScriptO]\
\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD] should be treated as a \
symbol.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", 
      TagBox[
        TagBox[
          StyleBox[
            RowBox[{
            "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]", "\[PartialD]"}],
            ZeroWidthTimes->True],
          DomainD],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "]"}]], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[TextData[{
  "The package has created a ",
  StyleBox["FullForm", "MR"],
  " name for the composite symbol \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD]."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      TagBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True],
        DomainD], 
      StyleBox[
        RowBox[{
          StyleBox["/",
            ZeroWidthTimes->True], "/"}]], "FullForm"}]], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
PartialD",
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[17]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.2"}]
}, Open  ]],

Cell["\<\
You can now attach rules to the composite symbol \[ScriptCapitalD]\
\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD].\
\>", 
  "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    RowBox[{
      TagBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True],
        DomainD], "/:", 
      RowBox[{
        SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
        RowBox[{
          RowBox[{
            TagBox[
              StyleBox[
                RowBox[{
                "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]", "\[PartialD]"}],
                ZeroWidthTimes->True],
              DomainD], "[", 
            RowBox[{"f_", ",", "x_"}], "]"}], 
          RowBox[{"\[CapitalDifferentialD]", "x_"}]}]}], " ", ":=", " ", "f"}]
      ], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[TextData[{
  "The above rule for \[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\
\[ScriptI]\[ScriptN]\[PartialD] is now tried before the rules of ",
  StyleBox["DomainIntegrals", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
      RowBox[{
        RowBox[{
          TagBox[
            StyleBox[
              RowBox[{
              "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]", "\[PartialD]"}],
              ZeroWidthTimes->True],
            DomainD], " ", "[", 
          RowBox[{
            RowBox[{"\[Delta]", "[", "x", "]"}], ",", "x"}], "]"}], 
        RowBox[{"\[CapitalDifferentialD]", "x"}]}]}]], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    RowBox[{"\[Delta]", "[", "x", "]"}]], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"Notation:S1", "Notation:S1.2"}]
}, Open  ]],

Cell[TextData[{
  StyleBox["Symbolize", "MR"],
  " also symbolizes classes of expressions, for example, to symbolize all \
objects subscripted by ",
  StyleBox["Rule", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", 
      TagBox[
        SubscriptBox["expr_", "Rule"],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "]"}]], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[TextData[{
  "Anything subscripted by ",
  StyleBox["Rule", "MR"],
  " is now treated as a symbol."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["MyDistribute", "Rule"], " ", "//", "FullForm"}]], "Input",\

  CellLabel->"In[21]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    TagBox[
      StyleBox["MyDistribute\[UnderBracket]Subscript\[UnderBracket]Rule",
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[21]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.2"}]
}, Open  ]],

Cell[TextData[{
  "You can use symbolized box structures as pattern variables in definitions. \
This lets you create formulas in a more familiar notation. However, you must \
use pattern expressions of the form ",
  StyleBox["CompositePatternVariable",
    FontSlant->"Italic"],
  " : ",
  StyleBox["PatternContent",
    FontSlant->"Italic"],
  " otherwise ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " may interpret the pattern expression as ",
  StyleBox["CompositePatternVariable",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox["\[Star]", TraditionalForm]]],
  " ",
  StyleBox["PatternContent",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell["\<\
This defines the transmission coefficient for an incident wave \
packet on a potential step under certain conditions.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", 
      TagBox[
        SubscriptBox["k", "_"],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "]"}]], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"transmissionCoefficient", "[", 
        RowBox[{
          RowBox[{
            SubscriptBox["k", "1"], ":", "_"}], ",", 
          RowBox[{
            SubscriptBox["k", "2"], " ", ":", "_"}]}], "]"}], ":=", " ", 
      RowBox[{"1", "-", 
        FractionBox[
          RowBox[{"4", " ", 
            SubscriptBox["k", "1"], 
            SubscriptBox["k", "2"]}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{
                SubscriptBox["k", "1"], "+", 
                SubscriptBox["k", "2"]}], ")"}], "2"]]}]}]], "Input",
  CellLabel->"In[23]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Infix Notation", "SubsubsectionIcon",
  CellTags->"Notation:S1"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["InfixNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["infixOp",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["prefixHead",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["infixOp",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{
                    "as", " ", "an", " ", "infix", " ", "operator", " ", 
                      "representing", " ", "the", " ", "function"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["prefixHead",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["InfixNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["infixOp",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["prefixHead",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{"treat", " "}],
                  SingleLetterItalics->False], 
                StyleBox["infixOp",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{
                    "as", " ", "an", " ", "infix", " ", "operator", " ", 
                      "representing", " ", "the", " ", "function"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["prefixHead",
                  FontSlant->"Italic"], 
                StyleBox[
                  RowBox[{" ", 
                    RowBox[{"with", " ", "the", " ", "options"}], " "}],
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RemoveInfixNotation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["infixOp",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["prefixHead",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[
                  RowBox[{
                    RowBox[{
                    "remove", " ", "the", " ", "composite", " ", "infix", 
                      " ", "operator"}], "  "}],
                  SingleLetterItalics->False], 
                StyleBox["infixOp",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.4, 0.6},
  ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S1", "Notation:S1.3", "Notation:Definition:Notation"}],

Cell["Syntax of infix notation declarations.", "Caption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[TextData[{
  StyleBox["InfixNotation", "MR"],
  " is used to treat a composite box structure as an infix operator.  ",
  StyleBox["InfixNotation", "MR"],
  " requires both a composite box object which will represent the infix \
operator and a symbol which will be the full form head of the expression. A \
simple parallel of this duality in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is that the infix notation ",
  StyleBox["+", "MR"],
  " has the full form head ",
  StyleBox["Plus", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[TextData[{
  "This declares that the composite object ",
  Cell[BoxData[
      SubscriptBox["+", 
        RowBox[{"{", "}"}]]]],
  " should act as the infix form of ",
  StyleBox["Join", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[BoxData[
    RowBox[{"InfixNotation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox["+", 
            RowBox[{"{", "}"}]],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", 
        TagBox["Join",
          Identity]}], "]"}]], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], " ", 
      SubscriptBox["+", 
        RowBox[{"{", "}"}]], " ", 
      RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], " ", 
      SubscriptBox["+", 
        RowBox[{"{", "}"}]], " ", 
      RowBox[{"{", 
        RowBox[{"e", ",", "f"}], "}"}]}]], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]
      ], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Open  ]],

Cell[TextData[{
  "The infix notation ",
  Cell[BoxData[
      SubscriptBox["+", 
        RowBox[{"{", "}"}]]]],
  " both parses input and formats output."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"HoldForm", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], " ", 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], " ", 
        RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}], " ", 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], " ", 
        RowBox[{"{", 
          RowBox[{"e", ",", "f"}], "}"}]}], "]"}]], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[BoxData[
    TagBox[
      RowBox[{
        RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], 
        RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}], 
        SubscriptBox["+", 
          RowBox[{"{", "}"}]], 
        RowBox[{"{", 
          RowBox[{"e", ",", "f"}], "}"}]}],
      HoldForm]], "Output",
  CellLabel->"Out[25]=",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Open  ]],

Cell[TextData[{
  "An advantage of using ",
  StyleBox["InfixNotation", "MR"],
  " over that of using ",
  StyleBox["Notation", "MR"],
  " to define an infix operator is that ",
  StyleBox["InfixNotation", "MR"],
  " parses an expression into a flat internal form without evaluation. \
Although this is a subtle difference, it is an important one (see ",
  ButtonBox["ring operations",
    ButtonData:>{"Notation Documentation", "Ring Operations"},
    ButtonStyle->"AddOnsLink"],
  " and ",
  ButtonBox["parsing without evaluation",
    ButtonData:>{"Notation Documentation", "Parse without evaluation"},
    ButtonStyle->"AddOnsLink"],
  ".)"
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[TextData[{
  StyleBox["InfixNotation", "MR"],
  " parses input to a flat expression."
}], "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FullForm", " ", "[", 
      RowBox[{"Hold", "[", 
        RowBox[{"a", " ", 
          SubscriptBox["+", 
            RowBox[{"{", "}"}]], " ", "b", " ", 
          SubscriptBox["+", 
            RowBox[{"{", "}"}]], " ", "c", " ", 
          SubscriptBox["+", 
            RowBox[{"{", "}"}]], " ", "d"}], "]"}], "]"}]], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Hold", "[", 
          RowBox[{"Join", "[", 
            RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[26]//FullForm=",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["InfixNotation",
    FontFamily->"Courier"],
  " can be compared to using the infix form of functions ~",
  Cell[BoxData[
      FormBox["\[ScriptF]", TraditionalForm]]],
  "~ (cf. The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Book  ",
  ButtonBox["2.1.3)",
    ButtonData:>{"2.1.3", "3.3"},
    ButtonStyle->"MainBookLink"]
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Entering Notations", "SubsubsectionIcon",
  CellTags->"Notation:S1"],

Cell[TextData[{
  "When defining your own notations it is ",
  StyleBox["critically",
    FontSlant->"Italic"],
  " important to use the ",
  ButtonBox["notation templates",
    ButtonData:>{
      FrontEnd`ToFileName[ {$TopDirectory, "AddOns", "ExtraPackages", 
        "Utilities", "NotationPalette.nb"}], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"Show Palette"],
  ". The notation templates are contained in the notation palette shown \
below."
}], "Text",
  CellTags->{
  "Must use palette", "Notation:Documentation:Entering Notations", 
    "Notation:S1", "Notation:S1.4"}],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]note\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]note>\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]note<\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Symbolize", "[", 
              TagBox["\[SelectionPlaceholder]",
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], "]"}],
            ButtonNote->"\[EscapeKey]symb\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"InfixNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}]
                , "]"}],
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]infixnote\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"AddInputAlias", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}]
                , "]"}],
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]addia\[EscapeKey]"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"Full", " ", "Notation", " ", "Palette"}],
              FontFamily->"Helvetica",
              FontColor->GrayLevel[1]],
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`NotebookClose[ 
                  FrontEnd`ButtonNotebook[ ]], 
                FrontEnd`NotebookOpen[ 
                  FrontEnd`ToFileName[ 
                  {$TopDirectory, "AddOns", "ExtraPackages", "Utilities", 
                    "FullNotationPalette.nb"}]]}]&),
            ButtonStyle->None,
            Background->RGBColor[0.100008, 0.100008, 0.4],
            ButtonNote->"Switch to FullNotationPalette"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\[Placeholder]"]]], "Input",
  Editable->False,
  Active->True,
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell[TextData[{
  "The reason for this restriction is that the templates pasted into a \
notebook contain essential tag boxes embedded in the correct way. These \
embedded tag boxes allow ",
  StyleBox["Notation", "MR"],
  " , ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " to properly group and parse the new notation being defined. Further, they \
allow these functions to get the styling information of the new notation so \
that the output is formatted with the same spacing, sizes, adjustments, etc. \
as the input."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell["A blank notation template looks like the following.", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox["\[Placeholder]",
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox["\[Placeholder]",
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell[TextData[{
  "Advanced note: You can circumvent using the notation palette by wrapping \
the corresponding literal box structures in a ",
  ButtonBox["NotationBoxTag[]",
    ButtonData:>{"Notation:Definition:NotationBoxTag", 
      "The tag NotationBoxTag"},
    ButtonStyle->"AddOnsLink"],
  "."
}], "Caption",
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " it is possible to create input aliases for any notation or expression you \
want.  The normal interface to these input aliases is rather cumbersome and \
so the notation package contains the function ",
  StyleBox["AddInputAlias", "MR"],
  " to facilitate adding input aliases to the current notebook.  Each of the \
common templates has an alias associated with it for easy entry. For instance \
typing \[EscapeKey]",
  StyleBox["notation", "SR"],
  "\[EscapeKey] in an input cell will enter the notation template ",
  Cell[BoxData[
      StyleBox[
        RowBox[{"Notation", "[", 
          RowBox[{
            TagBox["\[Placeholder]",
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftRightArrow]", " ", 
            TagBox["\[Placeholder]",
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], "]"}],
        "Input"]]],
  StyleBox[".", "Input"]
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell["\<\
Add an input alias for apply statements to the current \
notebook.\
\>", "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell[BoxData[
    RowBox[{"AddInputAlias", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"\[Placeholder]", " ", 
              OverscriptBox["\[LongRightArrow]", 
                RowBox[{" ", "Apply", " "}]], " ", "\[Placeholder]"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", "\"\<apply\>\""}], "]"}]], 
  "Input",
  CellLabel->"In[27]:=",
  CellTags->{"Notation:S1", "Notation:S1.4"}],

Cell[TextData[{
  "Now that we have created this alias we can enter \"apply\" templates by \
simply typing \[EscapeKey]",
  StyleBox["apply", "SR"],
  "\[EscapeKey]."
}], "Text",
  CellTags->{"Notation:S1", "Notation:S1.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Precedence of Operators in Notations", "SubsectionIcon"],

Cell[CellGroupData[{

Cell["How Precedence is determined", "SubsubsectionIcon",
  CellTags->"Notation:S2"],

Cell[TextData[{
  "The precedence of any new notation or operator is determined by examining \
the components from which it is constructed. For instance, ",
  Cell[BoxData[
      SubscriptBox["+", "\[ScriptCapitalR]"]]],
  "  is grouped according to the precedence of +, the operator ",
  Cell[BoxData[
      SubscriptBox["\[CirclePlus]", "n"]]],
  "is grouped according to the precedence of ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[CirclePlus]", "\[Null]"], TraditionalForm]]],
  ", and the mapping ",
  Cell[BoxData[
      OverscriptBox["\[LongRightArrow]", 
        RowBox[{"  ", "myApply", "  "}]]]],
  " is grouped according to the precedence of \[LongRightArrow]. Generally \
the grouping behavior of positioning boxes is determined by the \"base \
element\". For instance, the expression ",
  StyleBox["SubscriptBox[", "MR"],
  StyleBox["symb",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["sub",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " is grouped according to ",
  StyleBox["symb",
    FontSlant->"Italic"],
  ". But for some other structural boxes the grouping behavior of surrounding \
elements is not affected by the behavior of the contents of the box. The \
precedence of compound objects is determined according to the following \
table"
}], "Text",
  CellTags->{
  "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"type", " ", "of", " ", "box"}],
              FontSlant->"Italic"], 
            StyleBox["behavior",
              FontSlant->"Italic"]},
          {
            StyleBox[
              RowBox[{
              "AdjustmentBox", ",", " ", "ErrorBox", ",", " ", "StyleBox", 
                ",", " ", "SubscriptBox", ",", " ", "SuperscriptBox", ",", 
                " ", "SubsuperscriptBox", ",", " ", "UnderscriptBox", ",", 
                "OverscriptBox", ",", " ", "UnderoverscriptBox", ",", " ", 
                "TagBox"}],
              "MR"], 
            StyleBox[
              RowBox[{
                RowBox[{
                "These", " ", "box", " ", "structures", " ", "do", " ", 
                  "not", " ", "isolate", " ", "their", " ", "contents", " ", 
                  "from", " ", "the", " ", "outside"}], ";", " ", 
                RowBox[{
                "the", " ", "contents", " ", "of", " ", "these", " ", 
                  "boxes", " ", "can", " ", "affect", " ", "the", " ", 
                  "grouping", " ", "of", " ", "surrounding", " ", "elements"}]
                  }],
              SingleLetterItalics->False]},
          {
            StyleBox[
              RowBox[{
              "ButtonBox", ",", " ", "FormBox", ",", " ", "FractionBox", ",", 
                "FrameBox", ",", " ", "GridBox", ",", " \t", 
                "InterpretationBox", ",", " ", "RowBox", ",", " ", 
                "RadicalBox", ",", " ", "SqrtBox"}],
              "MR"], 
            StyleBox[
              RowBox[{
                RowBox[{
                "These", " ", "box", " ", "structures", " ", "isolate", " ", 
                  "their", " ", "contents", " ", "from", " ", "the", " ", 
                  "outside"}], ";", " ", 
                RowBox[{
                "the", " ", "contents", " ", "of", " ", "these", " ", 
                  "boxes", " ", "do", " ", "not", " ", "affect", " ", "the", 
                  " ", "grouping", " ", "of", " ", "surrounding", " ", 
                  "elements"}]}],
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->1.8,
  ColumnWidths->0.5,
  RowLines->{True, False}},
  CellTags->{"List of Boxes", "Notation:S2", "Notation:S2.1"}],

Cell["The standard boxes and their relationship to precedence.", "Caption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[TextData[{
  "The design decision of making the precedence of new compound operators \
correspond to their constituents makes intuitive sense and generally leads to \
notations that are consistent. For instance, consider a possible notation for \
addition and multiplication over a ring ",
  Cell[BoxData[
      RowBox[{"\[LeftAngleBracket]", 
        RowBox[{"\[ScriptCapitalR]", ",", 
          RowBox[{
            SubscriptBox["+", "\[ScriptCapitalR]"], 
            RowBox[{",", 
              SubscriptBox["*", "\[ScriptCapitalR]"]}]}]}], 
        "\[RightAngleBracket]"}]]],
  "."
}], "Text",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell["\<\
This defines a notation for ring addition and ring \
multiplication.\
\>", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[{
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{"a_", " ", 
            SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b_"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], "  ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingPlus", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"a_", " ", 
              SubscriptBox["*", "\[ScriptCapitalR]"], " ", "b_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingTimes", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]}], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"Ring Operations", "Notation:S2", "Notation:S2.1"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " now can parse and format expressions containing ring additions and \
multiplications."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"x", " ", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
      RowBox[{"y", " ", 
        SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}]}]], "Input",
  CellLabel->"In[30]:=",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[
    RowBox[{"x", " ", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
      RowBox[{
        RowBox[{"y", " ", 
          SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}], " "}]}]], 
  "Output",
  CellLabel->"Out[30]=",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FullForm", " ", "@", " ", "%"}]], "Input",
  CellLabel->"In[31]:=",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"RingPlus", "[", 
          RowBox[{"x", ",", 
            RowBox[{"RingTimes", "[", 
              RowBox[{"y", ",", "z"}], "]"}]}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[31]//FullForm=",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],

Cell[TextData[{
  "The ring multiplication operator ",
  Cell[BoxData[
      SubscriptBox["*", "\[ScriptCapitalR]"]]],
  " has a higher precedence than the ring addition operator ",
  Cell[BoxData[
      SubscriptBox["+", "\[ScriptCapitalR]"]]],
  " because ",
  StyleBox["*", "Input"],
  " has a higher precedence than ",
  StyleBox["+", "Input"],
  " . Moreover, the notation is automatically set up to parenthesize the \
expression appropriately to maintain the correct structure."
}], "Text",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell["\<\
The output has the correct formatting, styling, spacing, and \
parenthesization.\
\>", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"RingTimes", "[", 
          RowBox[{
            RowBox[{"RingPlus", "[", 
              RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}],
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Input",
  CellLabel->"In[32]:=",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"(", 
          RowBox[{"x", " ", 
            SubscriptBox["+", "\[ScriptCapitalR]"], " ", "y"}], ")"}], " ", 
        SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}], " "}]], "Output",
  CellLabel->"Out[32]=",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],

Cell["\<\
However the above notation for ring addition and ring \
multiplication is still somewhat limited.\
\>", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"RingPlus", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
  CellLabel->"In[33]:=",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[
    RowBox[{"RingPlus", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
  CellLabel->"Out[33]=",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],

Cell[TextData[{
  "The above ",
  StyleBox["Notation", "MR"],
  " statement can be removed and an ",
  StyleBox["InfixNotation", "MR"],
  " can be used instead."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[{
    RowBox[{"RemoveNotation", "[", 
      RowBox[{
        TagBox[
          RowBox[{"a_", " ", 
            SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b_"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], "  ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingPlus", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"RemoveNotation", "[", 
      RowBox[{
        TagBox[
          RowBox[{
            RowBox[{"a_", " ", 
              SubscriptBox["*", "\[ScriptCapitalR]"], " ", "b_"}], " "}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{" ", 
            RowBox[{"RingTimes", "[", 
              RowBox[{"a_", ",", "b_"}], "]"}]}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}], "\n", 
    RowBox[{"InfixNotation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox["+", "\[ScriptCapitalR]"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", 
        TagBox["RingPlus",
          Identity]}], "]"}], "\n", 
    RowBox[{"InfixNotation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox["*", "\[ScriptCapitalR]"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], ",", 
        TagBox["RingTimes",
          Identity]}], "]"}]}], "Input",
  CellLabel->"In[34]:=",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[TextData[{
  "Now ",
  Cell[BoxData[
      SubscriptBox["+", "\[ScriptCapitalR]"]]],
  " and ",
  Cell[BoxData[
      SubscriptBox["*", "\[ScriptCapitalR]"]]],
  " act as true infix operators for ",
  StyleBox["RingPlus", "MR"],
  " and ",
  StyleBox["RingTimes", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"a", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", "c", 
      SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
      RowBox[{"d", " ", 
        SubscriptBox["*", "\[ScriptCapitalR]"], " ", "e"}]}]], "Input",
  CellLabel->"In[38]:=",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[BoxData[
    RowBox[{"a", 
      SubscriptBox["+", "\[ScriptCapitalR]"], "b", 
      SubscriptBox["+", "\[ScriptCapitalR]"], "c", 
      SubscriptBox["+", "\[ScriptCapitalR]"], 
      RowBox[{"d", 
        SubscriptBox["*", "\[ScriptCapitalR]"], "e"}]}]], "Output",
  CellLabel->"Out[38]=",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Parentheses in Notations", "SubsubsectionIcon",
  CellTags->"Notation:S2"],

Cell[TextData[{
  "It is important to point out that bracketing expressions by using ",
  StyleBox["{}", "MR"],
  ",",
  StyleBox["()", "MR"],
  ",",
  StyleBox["\[LeftAngleBracket]\[RightAngleBracket]", "MR"],
  ",",
  StyleBox["[]", "MR"],
  ",",
  StyleBox["|", "MR"],
  " or other braces in a notation not only changes the grouping of the \
notation but requires the brackets to be literally present in the input \
expression."
}], "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses"}],

Cell["The following defines a notation that uses parentheses.", "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          SubscriptBox[
            RowBox[{"(", "expr___", ")"}], "\[DoubleStruckCapitalS]"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{"Semantic", "[", "expr___", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[39]:=",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox[
        RowBox[{"(", 
          RowBox[{"a", ",", "b", ",", "c"}], ")"}], 
        "\[DoubleStruckCapitalS]"], "//", "FullForm"}]], "Input",
  CellLabel->"In[40]:=",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Semantic", "[", 
          RowBox[{"a", ",", "b", ",", "c"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[40]//FullForm=",
  CellTags->{"Notation:S2", "Notation:S2.2"}]
}, Open  ]],

Cell[TextData[{
  "Without parentheses input is not recognized as a ",
  StyleBox["Semantic", "MR"],
  " wrapper."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["H", "\[DoubleStruckCapitalS]"], " ", "//", "FullForm"}]], 
  "Input",
  CellLabel->"In[41]:=",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Subscript", "[", 
          RowBox[{"H", ",", "\[DoubleStruckCapitalS]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[41]//FullForm=",
  CellTags->{"Notation:S2", "Notation:S2.2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing Precedences in Notations", "SubsubsectionIcon",
  CellTags->"Notation:S2"],

Cell[TextData[{
  "You can isolate the elements around an operator or expression by \
surrounding the operator or expression with a box structure that isolates its \
contents (cf. the ",
  ButtonBox["table above",
    ButtonData:>{"Notation:Documentation:Precedence", "List of Boxes"},
    ButtonStyle->"AddOnsLink"],
  "). The box structure typically used to do this encapsulation / isolation \
is the ",
  ButtonBox["TagBox",
    ButtonData:>"TagBox",
    ButtonStyle->"RefGuideLink",
    ButtonSource->ButtonData],
  ". Furthermore it is possible to change the precedence of an operator \
through the use of the ",
  StyleBox["TagBox", "MR"],
  " option ",
  ButtonBox["SyntaxForm",
    ButtonData:>{"Notation Documentation", 
      "Changing precedences and the option SyntaxForm"},
    ButtonStyle->"AddOnsLink"],
  ". More will be said on this later in the section ",
  StyleBox["Complex Patterns and Advanced Features",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.3", 
    "Notation:Documentation:Changing Precedences"}],

Cell[TextData[{
  "The underlying box structure of \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD] has an embedded ",
  StyleBox["TagBox", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ToBoxes", " ", "@", " ", 
      TagBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True],
        DomainD]}]], "Input",
  CellLabel->"In[42]:=",
  CellTags->{"Notation:S2", "Notation:S2.3"}],

Cell[BoxData[
    RowBox[{"TagBox", "[", 
      RowBox[{
        RowBox[{"StyleBox", "[", 
          RowBox[{
            RowBox[{"RowBox", "[", 
              RowBox[{"{", 
                RowBox[{
                "\<\"\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]\"\>", ",", "\<\"\[PartialD]\"\>"}], "}"}], "]"}], ",", 
            RowBox[{"ZeroWidthTimes", "\[Rule]", "True"}]}], "]"}], ",", 
        "DomainD"}], "]"}]], "Output",
  CellLabel->"Out[42]=",
  CellTags->{"Notation:S2", "Notation:S2.3"}]
}, Open  ]],

Cell[TextData[{
  "The embedded ",
  StyleBox["TagBox", "MR"],
  " in ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
          "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
", "\[PartialD]"}],
          ZeroWidthTimes->True], TraditionalForm]]],
  " is necessary for several reasons: to contain the ",
  StyleBox["StyleBox", "MR"],
  " asserting ",
  StyleBox["ZeroWidthTimes", "MR"],
  ", to suppress the natural prefix operator grouping of ",
  Cell[BoxData[
      FormBox["\[PartialD]", TraditionalForm]]],
  ", and to allow the parsing and formatting rules to act on an encapsulated \
unit."
}], "Text",
  CellTags->{"Notation:S2", "Notation:S2.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Options and Auxiliary Functions", "SubsectionIcon"],

Cell[TextData[{
  StyleBox["Notation", "MR"],
  " , ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " have several options that modify their behavior. These notation functions \
all take the options ",
  StyleBox["WorkingForm", "MR"],
  " and ",
  StyleBox["Action", "MR"],
  ". In addition the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package has a local option ",
  StyleBox["AutoLoadNotationPalette", "MR"],
  " which affects the loading of the palette. Finally, the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package has a function which clears all notations, symbolizations, and \
infix notations defined so far."
}], "Text",
  CellTags->{"Notation:Documentation:Options", "Notation:S3"}],

Cell[CellGroupData[{

Cell[TextData[{
  "The option ",
  StyleBox["Action", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"option", " ", "name"}],
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"possible", " ", "values"}],
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["Action",
              "MR"], 
            StyleBox["CreateNotationRules",
              "MR"], 
            StyleBox[
              RowBox[{
              "notations", " ", "are", " ", "entered", " ", "into", " ", 
                "the", " ", "system"}],
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["RemoveNotationRules",
              "MR"], 
            StyleBox[
              RowBox[{
              "notations", " ", "are", " ", "removed", " ", "from", " ", 
                "the", " ", "system"}],
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["PrintNotationRules",
              "MR"], 
            StyleBox[
              RowBox[{
              "cells", " ", "containing", " ", "the", " ", "rules", " ", 
                "defining", " ", "the", " ", "given", " ", "notation", " ", 
                "are", " ", "pasted", " ", "into", " ", "the", " ", 
                "current", " ", "notebook"}],
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{RowLines->{True, False}},
  CellTags->{"Notation:Definition:Action", "Notation:S3", "Notation:S3.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Action", "MR"],
  " option and  its possible values."
}], "Caption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " option ",
  StyleBox["Action", "MR"],
  " determines what a notation statement does with the rules it generates. \
The default value of the ",
  StyleBox["Action", "MR"],
  " option is ",
  StyleBox["CreateNotationRules", "MR"],
  ", which causes the generated notation rules to be entered into the \
system."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell["\<\
This creates a notation for pure functions more in keeping with \
that of traditional mathematics.\
\>", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        RowBox[{
          TagBox[
            RowBox[{" ", 
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"x_", " ", 
                    StyleBox["\[RightTeeArrow]",
                      SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"], " ", 
          "\[DoubleLongLeftRightArrow]", " ", 
          TagBox[
            RowBox[{"Function", "[", 
              RowBox[{"x_", ",", "body_"}], "]"}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"]}], " ", ",", "\n", "\t    ", 
        RowBox[{"Action", " ", "\[Rule]", " ", "CreateNotationRules"}]}], "]"}
      ]], "Input",
  CellLabel->"In[43]:=",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell["Pure functions now use this new notation.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
        RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Input",
  CellLabel->"In[44]:=",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[BoxData[
    RowBox[{" ", 
      SubscriptBox[
        RowBox[{"(", 
          RowBox[{"x", " ", 
            StyleBox["\[RightTeeArrow]",
              SpanMinSize->1], " ", 
            RowBox[{
              SuperscriptBox["x", "2"], "+", "1"}]}], ")"}], "&"], " "}]], 
  "Output",
  CellLabel->"Out[44]=",
  CellTags->{"Notation:S3", "Notation:S3.1"}]
}, Open  ]],

Cell[TextData[{
  "If the ",
  StyleBox["Action", "MR"],
  " option is set to ",
  StyleBox["RemoveNotationRules", "MR"],
  ", then the notation rules are removed from the system. Using the option \
value ",
  StyleBox["RemoveNotationRules", "MR"],
  " in a notation statement is equivalent to using the appropriate ",
  StyleBox["RemoveNotation", "MR"],
  ", ",
  StyleBox["RemoveSymbolize", "MR"],
  " or ",
  StyleBox["RemoveInfixNotation", "MR"],
  " statement."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell["This removes the above notation from the system.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        RowBox[{
          TagBox[
            RowBox[{" ", 
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"x_", " ", 
                    StyleBox["\[RightTeeArrow]",
                      SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"], " ", 
          "\[DoubleLongLeftRightArrow]", " ", 
          TagBox[
            RowBox[{"Function", "[", 
              RowBox[{"x_", ",", "body_"}], "]"}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"]}], " ", ",", "\n", "\t    ", 
        RowBox[{"Action", " ", "\[Rule]", " ", "RemoveNotationRules"}]}], "]"}
      ]], "Input",
  CellLabel->"In[45]:=",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell["Now the special notation for functions is no longer defined.", 
  "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
        RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Input",
  CellLabel->"In[46]:=",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[BoxData[
    RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
        RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]}], "]"}]], "Output",
  CellLabel->"Out[46]=",
  CellTags->{"Notation:S3", "Notation:S3.1"}]
}, Open  ]],

Cell[TextData[{
  "By setting the option ",
  StyleBox["Action", "MR"],
  " to ",
  StyleBox["PrintNotationRules", "MR"],
  ", you can view the rules generated by a notation statement. Examining the \
",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules is often useful to give you an idea of the underlying box \
structures that are used in your notation statement."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[TextData[{
  "This prints the ",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules corresponding to the given ",
  StyleBox["Notation", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        RowBox[{
          TagBox[
            RowBox[{" ", 
              SubscriptBox[
                RowBox[{"(", 
                  RowBox[{"x_", " ", 
                    StyleBox["\[RightTeeArrow]",
                      SpanMinSize->1], " ", "body_"}], ")"}], "&"], " "}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"], " ", 
          "\[DoubleLongLeftRightArrow]", " ", 
          TagBox[
            RowBox[{"Function", "[", 
              RowBox[{"x_", ",", "body_"}], "]"}],
            NotationBoxTag,
            TagStyle->"NotationTemplateStyle"]}], " ", ",", "\n", "\t    ", 
        RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], "]"}]
      ], "Input",
  CellLabel->"In[47]:=",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeExpression", "[", 
        RowBox[{
          RowBox[{"SubscriptBox", "[", 
            RowBox[{
              RowBox[{"RowBox", "[", 
                RowBox[{"{", 
                  RowBox[{"\"\<(\>\"", ",", 
                    RowBox[{"RowBox", "[", 
                      RowBox[{"{", 
                        RowBox[{
                        "x_", ",", "\"\<\[RightTeeArrow]\>\"", ",", "body_"}]
                          , "}"}], "]"}], ",", "\"\<)\>\""}], "}"}], "]"}], 
              ",", "\"\<&\>\""}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
      RowBox[{"MakeExpression", "[", 
        RowBox[{
          RowBox[{"RowBox", "[", 
            RowBox[{"{", 
              RowBox[{"\"\<Function\>\"", ",", "\"\<[\>\"", ",", 
                RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                    RowBox[{"x", ",", "\"\<,\>\"", ",", "body"}], "}"}], "]"}]
                  , ",", "\"\<]\>\""}], "}"}], "]"}], ",", "StandardForm"}], 
        "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeBoxes", "[", 
        RowBox[{
          RowBox[{"Function", "[", 
            RowBox[{"x_", ",", "body_"}], "]"}], ",", "StandardForm"}], "]"}]
        , ":=", 
      RowBox[{"RowBox", "[", 
        RowBox[{"{", 
          RowBox[{"\"\< \>\"", ",", 
            RowBox[{"SubscriptBox", "[", 
              RowBox[{
                RowBox[{"RowBox", "[", 
                  RowBox[{"{", 
                    RowBox[{"\"\<(\>\"", ",", 
                      RowBox[{"RowBox", "[", 
                        RowBox[{"{", 
                          RowBox[{
                            RowBox[{"Parenthesize", "[", 
                              RowBox[{
                              "x", ",", "StandardForm", ",", "RightTeeArrow"}]
                                , "]"}], ",", "\"\< \>\"", ",", 
                            RowBox[{"StyleBox", "[", 
                              RowBox[{"\"\<\[RightTeeArrow]\>\"", ",", 
                                RowBox[{"SpanMinSize", "\[Rule]", "1.`"}]}], 
                              "]"}], ",", "\"\< \>\"", ",", 
                            RowBox[{"Parenthesize", "[", 
                              RowBox[{
                              "body", ",", "StandardForm", ",", 
                                "RightTeeArrow"}], "]"}]}], "}"}], "]"}], 
                      ",", "\"\<)\>\""}], "}"}], "]"}], ",", "\"\<&\>\""}], 
              "]"}], ",", "\"\< \>\""}], "}"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S3", "Notation:S3.1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The option ",
  StyleBox["WorkingForm", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              RowBox[{"option", " ", "name"}],
              "Text",
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"possible", " ", "values"}],
              "Text",
              FontSlant->"Italic"], 
            StyleBox["effect",
              "Text",
              FontSlant->"Italic"]},
          {
            StyleBox["WorkingForm",
              "MR"], 
            StyleBox["StandardFrom",
              "MR"], 
            RowBox[{
              StyleBox["notations",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["symbolizations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["infix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["defined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["StandardForm",
                  "MR"]}]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["TraditionalForm",
              "MR"], 
            RowBox[{
              StyleBox["notations",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["symbolizations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["infix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["defined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["TraditionalForm",
                  "MR"]}]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              "MR"], 
            RowBox[{
              StyleBox["notations",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["symbolizations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["infix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["defined",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["DefaultOutputFormatType",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.25, 0.55},
  RowLines->{True, False}},
  CellTags->{
  "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2"}],

Cell[TextData[{
  "The ",
  StyleBox["WorkingForm", "MR"],
  " option and some of  its possible values."
}], "Caption",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[TextData[{
  "The option ",
  StyleBox["WorkingForm", "MR"],
  " specifies the ",
  StyleBox["form",
    FontSlant->"Italic"],
  " or ",
  StyleBox["environment",
    FontSlant->"Italic"],
  " the ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  " or ",
  StyleBox["InfixNotation", "MR"],
  " statement is generated in. The typical values of ",
  StyleBox["WorkingForm", "MR"],
  " are ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  "; any notations created would only apply in ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  " (respectively). However, ",
  StyleBox["WorkingForm", "MR"],
  " can be set to any form you define, for instance ",
  StyleBox["LogicForm", "MR"],
  ", ",
  StyleBox["PhysicsForm", "MR"],
  " etc."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[TextData[{
  "When the option ",
  StyleBox["WorkingForm", "MR"],
  " is set to ",
  StyleBox["Automatic", "MR"],
  " the ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  " or ",
  StyleBox["InfixNotation", "MR"],
  " statement will be created in the ",
  StyleBox["DefaultOutputFormatType", "MR"],
  ". This form is show in the menu item ",
  StyleBox["Default Output Format Type",
    FontFamily->"Helvetica"],
  " under the menu ",
  StyleBox["Cell",
    FontFamily->"Helvetica"],
  "."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[TextData[{
  "This creates ",
  StyleBox["TraditionalForm", "MR"],
  " notations for the vector calculus functions ",
  StyleBox["Div", "MR"],
  ", ",
  StyleBox["Curl", "MR"],
  " and the wrapper ",
  StyleBox["Vector", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[BoxData[{
    FormBox[
      RowBox[{"Notation", "[", " ", 
        RowBox[{
          RowBox[{
            TagBox[
              RowBox[{"\[Del]", 
                RowBox[{".", "a_"}]}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], "  ", 
            "\[DoubleLongLeftRightArrow]", "  ", 
            TagBox[
              RowBox[{"Div", "[", "a_", "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], " ", ",", 
          RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
        "]"}], TraditionalForm], "\n", 
    FormBox[
      FormBox[
        RowBox[{"Notation", "[", " ", 
          RowBox[{
            RowBox[{
              TagBox[
                RowBox[{"\[Del]", 
                  RowBox[{"\[Cross]", " ", "a__"}]}],
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], "  ", 
              "\[DoubleLongLeftRightArrow]", "  ", 
              TagBox[
                RowBox[{"Curl", "[", "a__", "]"}],
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"]}], " ", ",", 
            RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
            , "]"}],
        "TraditionalForm"], TraditionalForm], "\n", 
    FormBox[
      RowBox[{"Notation", "[", "  ", 
        RowBox[{
          RowBox[{
            TagBox[
              OverscriptBox["a_", "\[RightVector]"],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], "  ", 
            "\[DoubleLongLeftRightArrow]", "  ", 
            TagBox[
              RowBox[{"Vector", "[", "a_", "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], " ", ",", 
          RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
        "]"}], TraditionalForm]}], "Input",
  CellLabel->"In[48]:=",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell["These notations behave as expected.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{"\[Cross]", " ", 
            OverscriptBox["a", "\[RightVector]"]}]}], " ", "//", 
        "TraditionalForm"}], TraditionalForm]], "Input",
  CellLabel->"In[51]:=",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Del]", 
        RowBox[{"\[Cross]", " ", 
          OverscriptBox["a", "\[RightVector]"]}]}], TraditionalForm]], 
  "Output",
  CellLabel->"Out[51]//TraditionalForm=",
  CellTags->{"Notation:S3", "Notation:S3.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"FullForm", " ", "@", " ", "%"}]], "Input",
  CellLabel->"In[52]:=",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Curl", "[", 
          RowBox[{"Vector", "[", "a", "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[52]//FullForm=",
  CellTags->{"Notation:S3", "Notation:S3.2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{".", 
            RowBox[{"\[Del]", 
              RowBox[{"\[Cross]", " ", 
                OverscriptBox["a", "\[RightVector]"], "\[Cross]", 
                OverscriptBox["b", "\[RightVector]"]}]}]}]}], " ", "+", " ", 
        RowBox[{"\[Del]", 
          RowBox[{".", 
            RowBox[{"(", 
              RowBox[{
                OverscriptBox["a", "\[RightVector]"], "+", 
                OverscriptBox["b", "\[RightVector]"]}], ")"}]}]}]}], 
      TraditionalForm]], "Input",
  CellLabel->"In[53]:=",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"Div", "[", 
        RowBox[{"Curl", "[", 
          RowBox[{
            RowBox[{"Vector", "[", "a", "]"}], "\[Cross]", 
            RowBox[{"Vector", "[", "b", "]"}]}], "]"}], "]"}], "+", 
      RowBox[{"Div", "[", 
        RowBox[{
          RowBox[{"Vector", "[", "a", "]"}], "+", 
          RowBox[{"Vector", "[", "b", "]"}]}], "]"}]}]], "Output",
  CellLabel->"Out[53]=",
  CellTags->{"Notation:S3", "Notation:S3.2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The option ",
  StyleBox["AutoLoadNotationPalette", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              "Text",
              FontSlant->"Italic"], 
            StyleBox[
              RowBox[{"possible", " ", "values"}],
              "Text",
              FontSlant->"Italic"], 
            StyleBox["effect",
              "Text",
              FontSlant->"Italic"]},
          {
            StyleBox["AutoLoadNotationPalette",
              "MR"], 
            StyleBox[
              RowBox[{
                StyleBox["True",
                  "MR"], 
                StyleBox[
                  RowBox[{",", " "}],
                  SingleLetterItalics->False], 
                StyleBox["undefined",
                  FontSlant->"Italic"]}],
              "Text"], 
            RowBox[{
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["notation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["palette",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["will",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loaded",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Notation",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["package",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loads",
                SingleLetterItalics->False]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              "MR"], 
            RowBox[{
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["notation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["palette",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["will",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["not",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loaded",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Notation",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["package",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["loads",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.29, 0.27, 0.44},
  RowLines->{True, False}},
  CellTags->{"Notation:S3", "Notation:S3.3"}],

Cell["The option AutoLoadNotationPalette and its behavior.", "Caption",
  CellTags->{"Notation:S3", "Notation:S3.3"}],

Cell[TextData[{
  "If you are designing a package you may want to hide the ",
  ButtonBox["notation palette",
    ButtonData:>{
      FrontEnd`ToFileName[ 
      {$TopDirectory, "AddOns", "ExtraPackages", "Utilities", 
        "NotationPalette.nb"}], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"Show Palette"],
  " when the user loads the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package so as not to confuse them. You can set the boolean variable ",
  StyleBox["AutoLoadNotationPalette", "MR"],
  " inside your package to achieve this. If ",
  StyleBox["AutoLoadNotationPalette", "MR"],
  " has been set to ",
  StyleBox["False", "MR"],
  " then the notation palette will not be loaded when the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package is loaded. If the value is undefined or ",
  StyleBox["True", "MR"],
  ", the notation palette will be loaded when the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package loads. In input form the statement would look like the \
following."
}], "text",
  CellTags->{"Notation:S3", "Notation:S3.3"}],

Cell[TextData[{
  "Statement forcing the notation palette not to load when the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package loads."
}], "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.3"}],

Cell[BoxData[
    RowBox[{
    "Utilities`Notation`AutoLoadNotationPalette", " ", "=", " ", "False"}]], 
  "Input",
  Evaluatable->False,
  CellTags->{"Notation:S3", "Notation:S3.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The function ",
  StyleBox["ClearNotations[]", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S3"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                RowBox[{"ClearNotations", 
                  StyleBox["[",
                    "MR"], 
                  StyleBox["]",
                    "MR"]}],
                "TraditionalForm"],
              "MR"], 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{"ClearNotations", "[", "]"}],
                  "MR"], " ", 
                StyleBox[
                  RowBox[{"c", 
                    StyleBox["lears",
                      SingleLetterItalics->False]}]], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["notations",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                "symbolizations", " ", "and", " ", "infix", " ", "notations"}]
                  ,
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.29, 0.71},
  ColumnAlignments->{Right, Left}},
  CellTags->{"Notation:S3", "Notation:S3.4"}],

Cell["Syntax of clear notations.", "Caption",
  CellTags->{"Notation:S3", "Notation:S3.4"}],

Cell[TextData[{
  "If you would like to re-enter a set of notations or would like to make a \
\"clean start\" you can use the ",
  StyleBox["ClearNotations[]", "MR"],
  " command to erase all notations, symbolizations and infix notations \
present in the system. Using ",
  StyleBox["ClearNotations[]", "MR"],
  " should not affect other packages or definitions you have made to ",
  StyleBox["MakeExpression", "MR"],
  " or ",
  StyleBox["MakeBoxes", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S3", "Notation:S3.4"}],

Cell["Wipe all notations, symbolizations and infix notations.", "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.4"}],

Cell[BoxData[
    RowBox[{"ClearNotations", "[", "]"}]], "Input",
  CellLabel->"In[54]:=",
  CellTags->{"Notation:S3", "Notation:S3.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Complex Patterns and Advanced Features", "SubsectionIcon"],

Cell["This section is intended for advanced users.", "Subsubsection",
  CellGroupingRules->"NormalGrouping",
  CellTags->{"Notation:S4.1", "Notation:S4"}],

Cell[TextData[{
  "Due to the complex inner workings of the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package it is helpful to outline some of the more advanced features and \
structures of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end and how they relate to the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package. The following sections give a small overview of the \
functionality of tag boxes the specific tags used by the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package and the tag box option SyntaxForm."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.1", "Notation:Documentation:Advanced Features"}],

Cell[TextData[{
  "The reader should be familiar with the concepts in section ",
  ButtonBox["2.8 Textual Input and Output",
    ButtonData:>{"2.8", None},
    ButtonStyle->"MainBookLink"],
  " and moreover understand the following sections: ",
  ButtonBox["2.8.3 The Representation of Textual Forms",
    ButtonData:>{"2.8.3", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.8.4 The Interpretation of Textual Forms",
    ButtonData:>{"2.8.4", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.8.10 Representing Textual Forms by Boxes",
    ButtonData:>{"2.8.10", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.8.12 String Representation of Boxes",
    ButtonData:>{"2.8.12", None},
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["2.8.13 Converting between Strings, Boxes, and Expressions",
    ButtonData:>{"2.8.13", None},
    ButtonStyle->"MainBookLink"],
  ", and ",
  ButtonBox["2.8.17 Advanced Topic: Low-Level Input and Output Rules",
    ButtonData:>{"2.8.17", None},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Tag boxes", "SubsubsectionIcon",
  CellTags->"Notation:S4"],

Cell[TextData[{
  "A ",
  StyleBox["TagBox", "MR"],
  " is a box structure just like",
  Cell[BoxData[
      RowBox[{" ", 
        ButtonBox["RowBox",
          ButtonData:>"RowBox",
          ButtonStyle->"RefGuideLink",
          ButtonSource->ButtonData]}]]],
  ", ",
  ButtonBox["SubscriptBox",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["GridBox",
    ButtonStyle->"RefGuideLink"],
  ". It is used to change the structure of an expression or indicate a \
grouping or interpretation of a subexpression at an underlying level. To \
illustrate tag boxes consider the following input which contains an embedded \
",
  StyleBox["TagBox", "MR"],
  "."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes"}],

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      foo]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[TextData[{
  "All ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input and output is made up of box structures at a low level. When ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " receives input, these box structures are parsed into internal \
expressions, which can be thought of as full form expressions. Internal \
evaluation then takes place, and finally the internal structures are \
transformed back into box structures for displaying in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end.We can reveal how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sees this input at a low level by using the ",
  StyleBox["Show Expression",
    FontFamily->"Helvetica"],
  " command under the ",
  StyleBox["Format",
    FontFamily->"Helvetica"],
  " menu."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[TextData[{
  "Here is the underlying representation of the expression above in terms of \
boxes, displayed using the ",
  StyleBox["Show Expression", "SR"],
  " menu item located under the ",
  StyleBox["Format", "SR"],
  " menu. "
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[RawData["\<\
Cell[BoxData[
    TagBox[
      SuperscriptBox[\"x\", \"2\"],
      foo]], \"Input\"]\
\>"], "Input",
  Editable->False,
  Evaluatable->False,
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[TextData[{
  "The above expression contains a subexpression ",
  StyleBox["TagBox[SuperscriptBox[\"x\", \"2\"],foo]]", "MR"],
  ". It is important to note that this box expression as normally viewed in \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks visually like ",
  Cell[BoxData[
      TagBox[
        SuperscriptBox["x", "2"],
        foo]]],
  " even though it has an embedded ",
  StyleBox["TagBox", "MR"],
  ". Information contained in the tag is visually hidden from the user. When \
an expression containing a ",
  StyleBox["TagBox", "MR"],
  " is input into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the default interpretation of the subexpression surrounded by the ",
  StyleBox["TagBox", "MR"],
  " is to wrap the ",
  StyleBox["TagBox", "MR"],
  " name around the parsed subexpression, in this case to wrap foo around \
x^2."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[TextData[{
  "The embedded ",
  StyleBox["TagBox", "MR"],
  " tag ",
  StyleBox["foo", "MR"],
  " has no special parsing behavior associated with it."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      foo]], "Input",
  CellLabel->"In[55]:=",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[BoxData[
    RowBox[{"foo", "[", 
      SuperscriptBox["x", "2"], "]"}]], "Output",
  CellLabel->"Out[55]=",
  CellTags->{"Notation:S4", "Notation:S4.2"}]
}, Open  ]],

Cell[TextData[{
  "However you can define your own rules for the way specific tag boxes are \
parsed. For instance by using the low level function ",
  StyleBox["MakeExpression", "MR"],
  " we can change how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will parse expressions containing ",
  StyleBox["TagBoxes", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[TextData[{
  "By defining a new rule for ",
  StyleBox["MakeExpression", "MR"],
  " we can change how ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will parse expressions containing a ",
  StyleBox["TagBox", "MR"],
  " with the tag ",
  StyleBox["literalBoxes", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"MakeExpression", "[", 
        RowBox[{
          RowBox[{"TagBox", "[", 
            RowBox[{"expr_", ",", "literalBoxes"}], "]"}], ",", "form_"}], 
        "]"}], ":=", 
      RowBox[{"HoldComplete", "[", "expr", "]"}]}]], "Input",
  CellLabel->"In[56]:=",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[TextData[{
  "The embedded ",
  StyleBox["TagBox", "MR"],
  " tag ",
  StyleBox["literalBoxes", "MR"],
  " now has the special parsing behavior associated with it to just return \
the boxes."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    TagBox[
      SuperscriptBox["x", "2"],
      literalBoxes]], "Input",
  CellLabel->"In[57]:=",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[BoxData[
    RowBox[{"SuperscriptBox", "[", 
      RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]], "Output",
  CellLabel->"Out[57]=",
  CellTags->{"Notation:S4", "Notation:S4.2"}]
}, Open  ]],

Cell[TextData[{
  "Knowing that special behaviors can be set up for specific tags we can now \
examine the tags defined by the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package. The ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package defines three tags that have special behaviors: ",
  StyleBox["NotationBoxTag", "MR"],
  ", ",
  StyleBox["NotationPatternTag", "MR"],
  ", and ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The tag ",
  StyleBox["NotationBoxTag", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S4"],

Cell[TextData[{
  StyleBox["NotationBoxTag", "MR"],
  " is a tag used by the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package to grab box structures before they can be parsed by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". In fact ",
  StyleBox["NotationBoxTag", "MR"],
  " acts rather like the tag ",
  StyleBox["literalBoxes", "MR"],
  " defined above. All ",
  StyleBox["Notation", "MR"],
  " , ",
  StyleBox["Symbolize", "MR"],
  " and ",
  StyleBox["InfixNotation", "MR"],
  " templates on the ",
  ButtonBox["notation palette",
    ButtonData:>{
      FrontEnd`ToFileName[ {$TopDirectory, "AddOns", "ExtraPackages", 
        "Utilities", "NotationPalette.nb"}], None},
    ButtonStyle->"Hyperlink",
    ButtonNote->"Show Palette"],
  " contain tag boxes with an embedded ",
  StyleBox["NotationBoxTag", "MR"],
  ". The embedded ",
  StyleBox["TagBox", "MR"],
  " ensures that the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package can obtain the correct parsing information and retain the proper \
styling and grouping information."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag"}],

Cell[TextData[{
  "An expression containing an embedded ",
  StyleBox["NotationBoxTag", "MR"],
  " tag."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      TagBox[
        SuperscriptBox["x", "2"],
        NotationBoxTag,
        TagStyle->"NotationTemplateStyle"], "//", "FullForm"}]], "Input",
  CellLabel->"In[58]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"NotationBoxTag", "[", 
          RowBox[{"SuperscriptBox", "[", 
            RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[58]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.3"}]
}, Open  ]],

Cell[TextData[{
  "We can avoid using notation templates if we wrap raw box structures with a \
",
  StyleBox["NotationBoxTag", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[BoxData[
    RowBox[{"Symbolize", "[", " ", 
      RowBox[{"NotationBoxTag", " ", "[", " ", 
        RowBox[{"SubscriptBox", "[", 
          RowBox[{"\"\<fub\>\"", ",", "\"\<_\>\""}], "]"}], " ", "]"}], " ", 
      "]"}]], "Input",
  CellLabel->"In[59]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SubscriptBox["fub", "1"], "//", "FullForm"}]], "Input",
  CellLabel->"In[60]:=",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[BoxData[
    TagBox[
      StyleBox["fub\[UnderBracket]Subscript\[UnderBracket]1",
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[60]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Complex Patterns and the tag ",
  StyleBox["NotationPatternTag", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S4"],

Cell[TextData[{
  "For normal purposes it is usually sufficient that the patterns present in \
",
  StyleBox["Notation", "MR"],
  " and ",
  StyleBox["Symbolize", "MR"],
  " statements are simple patterns. However, it is sometimes necessary or \
desirable to use more complicated patterns in notations. For example, a \
notation might only be valid when a certain pattern is a number. To allow \
more complex patterns you can embed a ",
  StyleBox["NotationPatternTag", "MR"],
  " tag box inside a notation statement. It is critical that any notation you \
define which uses a complex pattern has an embedded ",
  StyleBox["NotationPatternTag", "MR"],
  ", otherwise the pattern will be treated as a verbatim expression and not \
function as a pattern.  The notation palette has a button labeled \
InsertPatternWrapper which will embed a ",
  StyleBox["NotationPatternTag", "MR"],
  " around the selection, as well as tint the background of the selection to \
indicate that a complex pattern is present."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["TraditionalForm", "MR"],
  " notation that only functions with numbers."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[BoxData[
    FormBox[
      RowBox[{"Notation", "[", 
        RowBox[{
          RowBox[{
            TagBox[
              SubscriptBox["\[CapitalGamma]", 
                TagBox[
                  RowBox[{"a_", "?", "StringNumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"]],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftRightArrow]", " ", 
            TagBox[
              RowBox[{"foo", "[", 
                TagBox[
                  RowBox[{"a_", "?", "NumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"], "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], ",", " ", 
          RowBox[{"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
        "]"}], TraditionalForm]], "Input",
  CellLabel->"In[61]:=",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell["\<\
It must also be pointed out that the pattern matching on the \
external representation is performed on the box structures, so usually you \
will have to make small transformations to convert box structures into normal \
expressions. Pattern matching on the internal representation follows \
conventional pattern matching.\
\>", "Text",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell["\<\
This defines a function analogous to NumericQ that operates on box \
structures.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"StringNumericQ", " ", "[", " ", "any___", "]"}], " ", ":=", 
      " ", 
      RowBox[{"NumericQ", " ", "[", " ", 
        RowBox[{"ToExpression", " ", "[", " ", "any", "]"}], "]"}]}]], "Input",\

  CellLabel->"In[62]:=",
  CellTags->{
  "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4"}],

Cell["\<\
Now only input which matches the above pattern will be interpreted \
as a foo object.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{
        SubscriptBox["\[CapitalGamma]", "\[Pi]"], " ", "+", 
        SubscriptBox["\[CapitalGamma]", "h"]}], TraditionalForm]], "Input",
  CellLabel->"In[63]:=",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"foo", "[", "\[Pi]", "]"}], "+", 
      SubscriptBox["\[CapitalGamma]", "h"]}]], "Output",
  CellLabel->"Out[63]=",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Open  ]],

Cell["\<\
Reciprocally only foo objects with numerical arguments will be \
formatted using the notation.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"foo", "[", "\[Pi]", "]"}], "+", 
        RowBox[{"foo", "[", "h", "]"}]}], " ", "//", "TraditionalForm"}]], 
  "Input",
  CellLabel->"In[64]:=",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"foo", 
          RowBox[{"(", "h", ")"}]}], "+", 
        SubscriptBox["\[CapitalGamma]", "\[Pi]"]}], TraditionalForm]], 
  "Output",
  CellLabel->"Out[64]//TraditionalForm=",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Open  ]],

Cell[TextData[{
  "You should be careful to avoid unwanted evaluation through testing \
functions when parsing expressions (see ",
  ButtonBox["parsing without evaluation",
    ButtonData:>{"Notation Documentation", "Parse without evaluation"},
    ButtonStyle->"AddOnsLink"],
  ".)"
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[TextData[{
  "We can examine the form of the rules created by using the option ",
  StyleBox["Action", "MR"],
  " \[Rule] ",
  StyleBox["PrintNotationRules", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{"Notation", "[", 
        RowBox[{
          RowBox[{
            TagBox[
              SubscriptBox["\[CapitalGamma]", 
                TagBox[
                  RowBox[{"a_", "?", "StringNumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"]],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftRightArrow]", " ", 
            TagBox[
              RowBox[{"foo", "[", 
                TagBox[
                  RowBox[{"a_", "?", "NumericQ"}],
                  NotationPatternTag,
                  TagStyle->"NotationPatternWrapperStyle"], "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], ",", " ", 
          RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
        "]"}], TraditionalForm]], "Input",
  CellLabel->"In[65]:=",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeExpression", "[", 
        RowBox[{
          RowBox[{"SubscriptBox", "[", 
            RowBox[{"\"\<\[CapitalGamma]\>\"", ",", 
              RowBox[{"a_", "?", "StringNumericQ"}]}], "]"}], ",", 
          "StandardForm"}], "]"}], ":=", 
      RowBox[{"MakeExpression", "[", 
        RowBox[{
          RowBox[{"RowBox", "[", 
            RowBox[{"{", 
              RowBox[{
              "\"\<foo\>\"", ",", "\"\<[\>\"", ",", "a", ",", "\"\<]\>\""}], 
              "}"}], "]"}], ",", "StandardForm"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeBoxes", "[", 
        RowBox[{
          RowBox[{"foo", "[", 
            RowBox[{"a_", "?", "NumericQ"}], "]"}], ",", "StandardForm"}], 
        "]"}], ":=", 
      RowBox[{"SubscriptBox", "[", 
        RowBox[{"\"\<\[CapitalGamma]\>\"", ",", 
          RowBox[{
          "Utilities`Notation`Private`makeEvaluatedRowBoxOfBoxes", "[", 
            RowBox[{
              RowBox[{"{", "a", "}"}], ",", "StandardForm", ",", "None"}], 
            "]"}]}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Open  ]],

Cell[TextData[{
  "We can see that the patterns ",
  StyleBox["a_?StringNumericQ", "MR"],
  " and ",
  StyleBox["a_?NumericQ", "MR"],
  " do not appear literally since they were surrounded by a ",
  StyleBox["NotationPatternTag", "MR"],
  " in the notation statement."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The tag ",
  StyleBox["NotationMadeBoxesTag", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S4"],

Cell[TextData[{
  "The tag ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  " is intended for advanced users. It is used to indicate that box \
processing and formatting has already been done and that the Notation package \
should not perform any processing. Typically you would use this tag for \
surrounding your own functions that return expressions that have already been \
turned into boxes or parsed into expressions. To illustrate the tag ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  " we can examine a notation statement that might be part of a number of \
statements used to create a notation for Tensors."
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.5", "Notation:Definition:NotationMadeBoxesTag"}],

Cell[TextData[{
  "An example notation for formatting tensors containing the tag ",
  StyleBox["NotationMadeBoxesTag", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{" ", 
      RowBox[{"Notation", "[", 
        RowBox[{
          RowBox[{
            TagBox[
              TagBox[
                RowBox[{
                  StyleBox["\[CapitalGamma]_",
                    FontWeight->"Bold"], 
                  TagBox[
                    RowBox[{"createGridBox", "[", "inds_", "]"}],
                    NotationMadeBoxesTag,
                    TagStyle->"NotationMadeBoxesWrapperStyle"]}],
                Tensor],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"], " ", 
            "\[DoubleLongLeftArrow]", " ", 
            TagBox[
              RowBox[{"Tensor", "[", 
                RowBox[{"\[CapitalGamma]_", ",", 
                  TagBox[
                    RowBox[{"inds_", "?", "validIndiciesQ"}],
                    NotationPatternTag,
                    TagStyle->"NotationPatternWrapperStyle"]}], "]"}],
              NotationBoxTag,
              TagStyle->"NotationTemplateStyle"]}], ",", 
          RowBox[{"Action", " ", "\[Rule]", " ", "PrintNotationRules"}]}], 
        "]"}]}]], "Input",
  CellLabel->"In[66]:=",
  CellTags->{"Notation:S4", "Notation:S4.5"}],

Cell[BoxData[
    RowBox[{
      RowBox[{"NotationMakeBoxes", "[", 
        RowBox[{
          RowBox[{"Tensor", "[", 
            RowBox[{"\[CapitalGamma]_", ",", 
              RowBox[{"inds_", "?", "validIndiciesQ"}]}], "]"}], ",", 
          "StandardForm"}], "]"}], ":=", 
      RowBox[{"TagBox", "[", 
        RowBox[{
          RowBox[{"RowBox", "[", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"StyleBox", "[", 
                  RowBox[{
                    RowBox[{"MakeBoxes", "[", 
                      RowBox[{"\[CapitalGamma]", ",", "StandardForm"}], "]"}]
                      , ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}]
                  , ",", 
                RowBox[{"createGridBox", "[", "inds", "]"}]}], "}"}], "]"}], 
          ",", "Tensor"}], "]"}]}]], "Output",
  ShowStringCharacters->True,
  CellTags->{"Notation:S4", "Notation:S4.5"}]
}, Open  ]],

Cell[TextData[{
  "We can see from the internal definition returned that there is no further \
processing of the expression ",
  StyleBox["createGridBox[inds]", "MR"],
  ", i.e. it is not surrounded by a ",
  StyleBox["MakeBoxes[...,StandardForm]", "MR"],
  "."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Changing precedences and the ",
  StyleBox["TagBox", "RM"],
  " option ",
  StyleBox["SyntaxForm", "RM"]
}], "SubsubsectionIcon",
  CellTags->"Notation:S4"],

Cell[TextData[{
  "Using the option ",
  StyleBox["SyntaxForm", "MR"],
  " you can change the precedence of an expression containing a ",
  StyleBox["TagBox", "MR"],
  ". A tag box containing a ",
  StyleBox["SyntaxForm", "MR"],
  " option will look like ",
  StyleBox["TagBox[", "MR"],
  " ",
  StyleBox["box structure",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["SyntaxForm", "MR"],
  " \[Rule] ",
  StyleBox["string",
    FontSlant->"Italic"],
  StyleBox["],", "MR"],
  " where ",
  StyleBox["string",
    FontSlant->"Italic"],
  " is a string indicating the operator on which the precedence of the tag \
box is modeled. The following examples illustrate the ",
  StyleBox["SyntaxForm", "MR"],
  " option . "
}], "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.6", 
    "Changing precedences and the option SyntaxForm", 
    "Notation:Documentation:SyntaxForm"}],

Cell["\<\
An expression which uses the arrow \[LongLeftRightArrow] with \
standard precedences.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"a", "+", 
        RowBox[{"b", " ", "\[LongLeftRightArrow]", " ", "c"}]}], "//", 
      "FullForm"}]], "Input",
  CellLabel->"In[67]:=",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Plus", "[", 
          RowBox[{"a", ",", 
            RowBox[{"LongLeftRightArrow", "[", 
              RowBox[{"b", ",", "c"}], "]"}]}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[67]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.6"}]
}, Open  ]],

Cell["\<\
We can define a new notation for a composite arrow \
\[LongLeftRightArrow] surrounded by a TagBox that has the SyntaxForm option \
set to a low precedence.\
\>", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          RowBox[{"a_", " ", 
            TagBox["\[LongLeftRightArrow]",
              Identity,
              SyntaxForm->","], "b_"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", 
        " ", 
        TagBox[
          RowBox[{"LongLeftRightArrow", "[", 
            RowBox[{"a_", ",", "b_"}], "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[68]:=",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell["This new composite arrow has a low precedence.", "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"(", " ", 
        RowBox[{
          RowBox[{"a", " ", "+", " ", "b"}], " ", 
          TagBox["\[LongLeftRightArrow]",
            Identity,
            SyntaxForm->","], "c"}], ")"}], "//", "FullForm"}]], "Input",
  CellLabel->"In[69]:=",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"LongLeftRightArrow", "[", 
          RowBox[{
            RowBox[{"Plus", "[", 
              RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[69]//FullForm=",
  CellTags->{"Notation:S4", "Notation:S4.6"}]
}, Open  ]],

Cell["\<\
We can illustrate the underlying groupings of the expressions above \
in the following table.\
\>", "Text",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[BoxData[
    FormBox[
      StyleBox[GridBox[{
            {
              StyleBox[
                RowBox[{
                "visual", " ", "form", " ", "of", " ", "expression"}],
                FontSlant->"Italic"], 
              StyleBox["grouping",
                FontSlant->"Italic"], 
              StyleBox[
                RowBox[{"box", " ", "form", " ", "of", " ", "expression"}],
                FontSlant->"Italic"]},
            {
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox["+",
                      "MR"], 
                    StyleBox["b",
                      SingleLetterItalics->False], " ", 
                    StyleBox["\[LongLeftRightArrow]",
                      SingleLetterItalics->False], " ", 
                    StyleBox["c",
                      SingleLetterItalics->False]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox["+",
                      SingleLetterItalics->False], 
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    StyleBox["b",
                      SingleLetterItalics->False], " ", 
                    StyleBox["\[LongLeftRightArrow]",
                      SingleLetterItalics->False], " ", 
                    StyleBox["c",
                      SingleLetterItalics->False], 
                    StyleBox[")",
                      SingleLetterItalics->False]}],
                  "StandardForm"],
                "Text"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Cell",
                      SingleLetterItalics->False], "[", 
                    RowBox[{
                      StyleBox["BoxData",
                        SingleLetterItalics->False], 
                      StyleBox["[",
                        SingleLetterItalics->False], 
                      RowBox[{
                        StyleBox["RowBox",
                          SingleLetterItalics->False], 
                        StyleBox["[",
                          SingleLetterItalics->False], 
                        RowBox[{
                          RowBox[{
                            StyleBox["{",
                              SingleLetterItalics->False], 
                            RowBox[{"\"\<a\>\"", 
                              StyleBox[
                                RowBox[{",", " "}],
                                SingleLetterItalics->False], "\"\<+\>\"", 
                              StyleBox[
                                RowBox[{",", " ", "\n"}],
                                SingleLetterItalics->False], 
                              StyleBox["      ",
                                SingleLetterItalics->False], 
                              StyleBox["RowBox",
                                SingleLetterItalics->False], 
                              StyleBox[
                                RowBox[{"[", "{"}],
                                SingleLetterItalics->False], "\"\<b\>\"", 
                              StyleBox[
                                RowBox[{",", " "}],
                                SingleLetterItalics->False], "\"\< \>\"", 
                              StyleBox[
                                RowBox[{",", " "}],
                                SingleLetterItalics->False], 
                              "\"\<\[LongLeftRightArrow]\>\"", 
                              StyleBox[
                                RowBox[{",", " "}],
                                SingleLetterItalics->False], "\"\< \>\"", 
                              StyleBox[
                                RowBox[{",", " "}],
                                SingleLetterItalics->False], "\"\<c\>\"", 
                              StyleBox[
                                RowBox[{
                                  RowBox[{
                                    RowBox[{
                                      RowBox[{
                                        RowBox[{
                                        RowBox[{"}", "]"}], "}"}], "]"}], "]"}
                                      ], ","}], " "}],
                                SingleLetterItalics->False], "\"\<Input\>\""}]
                              }], "]"}]}]}]}],
                  "StandardForm"],
                "Text"]},
            {
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox["+",
                      "MR"], 
                    StyleBox["b",
                      SingleLetterItalics->False], 
                    StyleBox["  ",
                      SingleLetterItalics->False], 
                    TagBox["\[LongLeftRightArrow]",
                      Identity], " ", 
                    StyleBox["c",
                      SingleLetterItalics->False]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox[
                      RowBox[{"(", 
                        RowBox[{"a", "+", "b"}], ")"}],
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    TagBox["\[LongLeftRightArrow]",
                      Identity,
                      SyntaxForm->","], " ", 
                    StyleBox["c",
                      SingleLetterItalics->False]}],
                  "StandardForm"],
                "Text"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Cell",
                      SingleLetterItalics->False], "[", 
                    RowBox[{
                      StyleBox["BoxData",
                        SingleLetterItalics->False], 
                      StyleBox["[",
                        SingleLetterItalics->False], 
                      RowBox[{
                        StyleBox["RowBox",
                          SingleLetterItalics->False], 
                        StyleBox["[",
                          SingleLetterItalics->False], 
                        RowBox[{
                          StyleBox["{",
                            SingleLetterItalics->False], 
                          RowBox[{
                            StyleBox["RowBox",
                              SingleLetterItalics->False], 
                            StyleBox["[",
                              SingleLetterItalics->False], 
                            RowBox[{
                              RowBox[{
                                StyleBox["{",
                                  SingleLetterItalics->False], 
                                RowBox[{
                                  RowBox[{"\"\<a\>\"", 
                                    StyleBox[
                                      RowBox[{",", " "}],
                                      SingleLetterItalics->False], 
                                    "\"\<+\>\"", 
                                    StyleBox[
                                      RowBox[{",", " "}],
                                      SingleLetterItalics->False], 
                                    "\"\<b\>\"", 
                                    StyleBox[
                                      RowBox[{
                                        RowBox[{
                                        RowBox[{"}", "]"}], ","}], " "}],
                                      SingleLetterItalics->False], 
                                    "\"\<  \>\"", 
                                    StyleBox[
                                      RowBox[{",", " ", "\n"}],
                                      SingleLetterItalics->False], 
                                    StyleBox["      ",
                                      SingleLetterItalics->False], 
                                    RowBox[{
                                      StyleBox["TagBox",
                                        SingleLetterItalics->False], "[", 
                                      RowBox[{
                                      "\"\<\[LongLeftRightArrow]\>\"", 
                                        StyleBox[",",
                                        SingleLetterItalics->False], 
                                        StyleBox["Identity",
                                        SingleLetterItalics->False], 
                                        StyleBox[",",
                                        SingleLetterItalics->False], 
                                        RowBox[{
                                        StyleBox["SyntaxForm",
                                        SingleLetterItalics->False], " ", 
                                        StyleBox["->",
                                        SingleLetterItalics->False], " ", 
                                        "\"\<,\>\""}]}], 
                                      StyleBox["]",
                                        SingleLetterItalics->False]}]}], 
                                  StyleBox[",",
                                    SingleLetterItalics->False], 
                                  StyleBox[" ",
                                    SingleLetterItalics->False], "\n", 
                                  "            ", 
                                  RowBox[{"\"\< \>\"", 
                                    StyleBox[
                                      RowBox[{",", " "}],
                                      SingleLetterItalics->False], 
                                    "\"\<c\>\"", 
                                    StyleBox[
                                      RowBox[{
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"}", "]"}], "]"}], ","}], " "}
                                        ],
                                      SingleLetterItalics->False], 
                                    "\"\<Input\>\""}]}]}], "]"}]}]}]}]}]}],
                  "StandardForm"],
                "Text"]}
            }]], NotebookDefault]], "OptionBox3Col",
  GeneratedCell->True,
  AutoStyleOptions->{"UnmatchedBracketStyle"->None},
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.2, 0.14, 0.66},
  RowLines->{True, False}},
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell["\<\
A table illustrating the precedences and grouping of expressions \
with and without precedence changing tag boxes.\
\>", "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[TextData[{
  "The ",
  StyleBox["SyntaxForm", "MR"],
  " option value can be any operator string valid in ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " that is, any operator contained in the ",
  StyleBox["UnicodeCharacters.tr", "MR"],
  " file. The ",
  StyleBox["SyntaxForm", "MR"],
  " value can also include symbols before and after the operator to indicate \
whether the precedence is that of a prefix operator, an infix operator, or a \
postfix operator. Some typical values for the ",
  StyleBox["SyntaxForm", "MR"],
  " option are given in the table below."
}], "Text",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["SyntaxForm",
                "MR"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["value",
                FontSlant->"Italic"]}], 
            StyleBox[
              RowBox[{"precedence", " ", "behavior"}],
              FontSlant->"Italic"]},
          {
            StyleBox[
              FormBox["\"\<*\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["times",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<a\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<a+b\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["infix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["plus",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<\[ForAll]\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<\[Integral]\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integrate",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\<\[Union] a\>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["prefix",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["union",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["\"\< \>\"",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[
                RowBox[{"G", 
                  StyleBox["roup",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["white",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["space",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.3, 0.7},
  ColumnAlignments->{Left},
  RowLines->{True, False}},
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[TextData[{
  "Typical ",
  StyleBox["SyntaxForm", "MR"],
  " values and their associated precedence behaviors."
}], "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Advice and Suggested Guidelines", "SubsectionIcon"],

Cell[TextData[{
  "The following are some issues and considerations to be aware of when using \
the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package and/or designing notations."
}], "Text",
  CellTags->{"Notation:S5", "Notation:Documentation:Guidelines"}],

Cell[CellGroupData[{

Cell["Build up notations in stages", "SubsubsectionIcon",
  CellTags->"Notation:S5"],

Cell[TextData[{
  "It is intrinsically difficult to debug something you cannot see; \
therefore, it is best to build up notations, seeing if something works or \
where a mistake has been made. It is harder to find errors if you enter a \
whole complex notation before testing it. Many notational problems will \
usually be revealed by examining the full form of an expression or its \
internal structure via ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"\[CommandKey]", "-", "\[ShiftKey]", "-"}]}], 
        TraditionalForm]]],
  "e."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Don't alter too much", "SubsubsectionIcon",
  CellTags->"Notation:S5"],

Cell[TextData[{
  "You should try not to alter too much. For example, changing commas to \
vertical separators is strongly discouraged. The more notational oddities \
present in the system, the higher the chance that one notation will adversely \
interact with another giving unexpected results. Some parsers have mechanisms \
to detect conflicts in a given grammar but the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " package does not."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Follow existing conventions where possible", "SubsubsectionIcon",
  CellTags->"Notation:S5"],

Cell[TextData[{
  "Where possible, you should follow standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conventions or follow the conventions of a given field. Inventing your \
own individual nonstandard notation is discouraged since such notations are \
necessarily unrecognizable to other users. Even if a notation has an \
historical origin and is not as intuitive as other possible notations the \
author could invent, it is usually better, where possible, to use the \
historical notation. Admittedly, however, it is sometimes difficult to \
resolve the inconsistencies present in a certain notation with the desire to \
have a uniform notation."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Parse without evaluation where possible", "SubsubsectionIcon",
  CellTags->"Notation:S5"],

Cell["\<\
When designing notations it is desirable to be able to parse an expression to \
its correct full form without evaluation. This is not always possible for \
complex notations where there is no direct correspondence between an external \
form and an internal form. However, for the cases when it is possible there \
should be no side effects from evaluation.\
\>", "Text",
  CellTags->{"Notation:S5", "Notation:S5.4", "Parse without evaluation"}],

Cell["\<\
The following notation does not depend on evaluation in order to \
behave correctly.\
\>", "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[BoxData[
    RowBox[{"Notation", "[", 
      RowBox[{
        TagBox[
          OverscriptBox["\[ScriptCapitalH]_", "^"],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"], " ", 
        "\[DoubleLongLeftRightArrow]", " ", 
        TagBox[
          RowBox[{"Operator", "[", "\[ScriptCapitalH]_", "]"}],
          NotationBoxTag,
          TagStyle->"NotationTemplateStyle"]}], "]"}]], "Input",
  CellLabel->"In[70]:=",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Hold", "[", 
        OverscriptBox["L", "^"], "]"}], "//", "FullForm"}]], "Input",
  CellLabel->"In[71]:=",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"Hold", "[", 
          RowBox[{"Operator", "[", "L", "]"}], "]"}],
        ShowStringCharacters->True],
      FullForm]], "Output",
  CellLabel->"Out[71]//FullForm=",
  CellTags->{"Notation:S5", "Notation:S5.4"}]
}, Open  ]],

Cell[TextData[{
  "A common instance of unwanted evaluation comes from testing functions used \
in ",
  ButtonBox["complex pattern matching",
    ButtonData:>{"Notation:Definition:NotationPatternTag", 
      "Complex Patterns"},
    ButtonStyle->"AddOnsLink"],
  ". If possible you should design testing functions to hold their \
arguments."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[TextData[{
  "The notation defined using the testing function ",
  ButtonBox["StringNumericQ",
    ButtonData:>{"Notation:Documentation:SyntaxForm", 
      "Complex Patterns:testing function"},
    ButtonStyle->"AddOnsLink"],
  " evaluates its arguments, which can lead to unpredictable results."
}], "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{"Hold", "[", 
        SubscriptBox["\[CapitalGamma]", 
          RowBox[{"Print", "[", "\"\<Oops...\>\"", "]"}]], "]"}], 
      TraditionalForm]], "Input",
  CellLabel->"In[72]:=",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[BoxData["\<\"Oops...\"\>"], "Print",
  CellLabel->"From In[72]:="],

Cell[BoxData[
    RowBox[{"Hold", "[", 
      SubscriptBox["\[CapitalGamma]", 
        RowBox[{"Print", "[", "\<\"Oops...\"\>", "]"}]], "]"}]], "Output",
  CellLabel->"Out[72]=",
  CellTags->{"Notation:S5", "Notation:S5.4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Internal and External representations which are structurally \
different\
\>", "SubsubsectionIcon",
  CellTags->"Notation:S5"],

Cell[TextData[{
  "In cases when a conventional notation does not easily equate to an \
internal form in ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " it is suggested that you have the notation take the conventional form to \
the internal ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " name appended by \"",
  StyleBox["Typeset", "MR"],
  "\". For example the ",
  StyleBox["MeijerG", "MR"],
  " function should have the ",
  StyleBox["TraditionalForm", "MR"]
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          SubsuperscriptBox["G", 
            RowBox[{"p", ",", "\[MediumSpace]", "q"}], 
            RowBox[{"m", ",", "\[MediumSpace]", "n"}]], "(", 
          RowBox[{"\[Xi]", "\[VerticalSeparator]", GridBox[{
                {
                  RowBox[{
                    SubscriptBox["a", "1"], ",", "...", 
                    RowBox[{",", 
                      SubscriptBox["a", "p"]}]}]},
                {
                  RowBox[{
                    SubscriptBox["b", "1"], ",", "...", 
                    RowBox[{",", 
                      SubscriptBox["b", "q"]}]}]}
                }]}], ")"}], " ", " "}], TraditionalForm]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[TextData[{
  "But the ",
  StyleBox["FullForm", "MR"],
  " of the ",
  StyleBox["MeijerG", "MR"],
  " function in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has the following form."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[BoxData[
    RowBox[{
      StyleBox["MeijerG",
        "MR"], 
      StyleBox["[",
        "MR"], 
      RowBox[{
        RowBox[{
          StyleBox["{",
            "MR"], 
          RowBox[{
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["a", "1"],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["a", "n"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}], 
            StyleBox[",",
              "MR"], 
            StyleBox[" ",
              "MR"], 
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["a", 
                    RowBox[{"n", "+", "1"}]],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["a", "p"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}]}], 
          StyleBox["}",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", 
        RowBox[{
          StyleBox["{",
            "MR"], 
          RowBox[{
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["b", "1"],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["b", "m"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}], 
            StyleBox[",",
              "MR"], 
            StyleBox[" ",
              "MR"], 
            RowBox[{
              StyleBox["{",
                "MR"], 
              RowBox[{
                FormBox[
                  SubscriptBox["b", 
                    RowBox[{"m", "+", "1"}]],
                  "TraditionalForm"], ",", "\[Ellipsis]", " ", ",", " ", 
                FormBox[
                  SubscriptBox["b", "q"],
                  "TraditionalForm"]}], 
              StyleBox["}",
                "MR"]}]}], 
          StyleBox["}",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", 
        FormBox["\[Xi]",
          "TraditionalForm"]}], 
      StyleBox["]",
        "MR"]}]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[TextData[{
  "Therefore it is necessary to verify that the ",
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox["q", TraditionalForm]]],
  " are numbers having the right values before it is even ",
  StyleBox["possible",
    FontSlant->"Italic"],
  " to construct the internal form of the ",
  StyleBox["MeijerG", "MR"],
  " function. It is not possible to convert from the conventional form to the \
internal form ",
  StyleBox["without",
    FontSlant->"Italic"],
  " evaluation."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[TextData[{
  "Therefore, in this case, we should take the traditional ",
  StyleBox["MeijerG", "MR"],
  " box structure to a ",
  StyleBox["MeijerGTypeset[{{", "MR"],
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  ",",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox["},{", "MR"],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox["q", TraditionalForm]]],
  StyleBox["}},{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["a", "1"], TraditionalForm]]],
  StyleBox[",", "MR"],
  "...",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["a", "p"], TraditionalForm]]],
  StyleBox["},{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["b", "1"], TraditionalForm]]],
  StyleBox[",", "MR"],
  "...",
  StyleBox[",", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox["b", "q"], TraditionalForm]]],
  StyleBox["}}]", "MR"],
  ". Then evaluation takes this to the internal ",
  StyleBox["MeijerG", "MR"],
  " function once it is has been established that it is possible to construct \
it."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[TextData[{
  "Another possible case of this is taking a ",
  StyleBox["tensor",
    FontSlant->"Italic"],
  " defined using a ",
  StyleBox["GridBox", "MR"],
  " to the expression ",
  StyleBox["TensorTypeset", "MR"],
  ". Then evaluation takes this to an internal form ",
  StyleBox["Tensor", "MR"],
  ", provided that the structure is valid, that is, the tensor does not have \
a contravariant and covariant index in the same column, etc."
}], "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],

Cell[BoxData[
    StyleBox[GridBox[{
          {" ", 
            StyleBox["Boxes",
              FontWeight->"Bold"], " "},
          {
            StyleBox["MakeBoxes",
              "MR"], 
            RowBox[{"\[UpArrow]", "\[DownArrow]"}], 
            StyleBox["MakeExpression",
              "MR"]},
          {" ", 
            StyleBox["Typeset",
              FontWeight->"Bold"], " "},
          {
            StyleBox["Formatting",
              "TI",
              FontSlant->"Italic"], 
            RowBox[{"\[UpArrow]", "\[DownArrow]"}], 
            StyleBox["Evaluation",
              "TI",
              FontSlant->"Italic"]},
          {" ", 
            StyleBox["FullForm",
              FontWeight->"Bold"], " "}
          },
        ColumnSpacings->0,
        ColumnAlignments->{Right, Center, Left}],
      SpanMinSize->4]], "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5"}]
}, Closed]],

Cell["Jason Harris (jasonh@wolfram.com), April 2003.", "SubsubsectionIcon",
  CellTags->{"Notation:S5", "Notation:S5.6"}]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1280}, {22, 1020}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Working",
WindowSize->{983, 819},
WindowMargins->{{3, Automatic}, {Automatic, 5}},
Visible->True,
PrintingCopies->1,
PrintingPageRange->{2, Automatic},
PrivateNotebookOptions->{"ShortBoxForm"->False},
InputAliases->{
  "pattwrap"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswrap"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"], "apply"->RowBox[ {
        RowBox[ {"\[Placeholder]", " ", 
          OverscriptBox[ "\[LongRightArrow]", 
            RowBox[ {" ", "Apply", " "}]], " ", "\[Placeholder]"}], " "}], 
    "notation"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftRightArrow]", " ",
           
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation>"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongRightArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "notation<"->RowBox[ {"Notation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], " ", "\[DoubleLongLeftArrow]", " ", 
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"]}], "]"}], 
    "symb"->RowBox[ {"Symbolize", "[", 
        TagBox[ 
        "\[Placeholder]", NotationBoxTag, TagStyle -> 
          "NotationTemplateStyle"], "]"}], 
    "infixnotation"->RowBox[ {"InfixNotation", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "addia"->RowBox[ {"AddInputAlias", "[", 
        RowBox[ {
          TagBox[ 
          "\[Placeholder]", NotationBoxTag, TagStyle -> 
            "NotationTemplateStyle"], ",", "\[Placeholder]"}], "]"}], 
    "pattwraper"->TagBox[ 
      "\[Placeholder]", NotationPatternTag, TagStyle -> 
        "NotationPatternWrapperStyle"], 
    "madeboxeswraper"->TagBox[ 
      "\[Placeholder]", NotationMadeBoxesTag, TagStyle -> 
        "NotationMadeBoxesWrapperStyle"]},
SpellingDictionaries->{"CorrectWords"->{
  "typset", "gplus", 
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
    "foo"}},
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions for On-line Help", "Subtitle"],
  
  Cell["\<\
These styles are carefully tuned for all aspects of the online \
help. It's recommended that they remain unchanged.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Subsubsection"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ShowCellBracket->False,
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Brackets"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Subsubsection"],
  
  Cell["\<\
  The options defined for the style below will be used at the \
Notebook level.  \
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1997\[Hyphen]2000 Wolfram Research, Inc. All \
rights reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1997\[Hyphen]2000 Wolfram Research, Inc. All \
rights reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True},
    CellLabelAutoDelete->False,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Headings", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Chapter"],
    CellMargins->{{10, 4}, {4, 24}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontWeight->"Bold"],
  
  Cell[StyleData["Chapter", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->22]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{10, 4}, {12, 18}},
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellFrameLabelMargins->6,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionColor"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.297993, 0, 0.454994]],
  
  Cell[StyleData["SubsubsectionColor", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->8},
    CellGroupingRules->{"SectionGrouping", 50},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellDingbat->"\[FilledSquare]",
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {0, 8}},
    CellElementSpacings->{"ClosedGroupTopMargin"->4},
    CellGroupingRules->{"SectionGrouping", 60},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Text", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CompactText"],
    CellMargins->{{10, 4}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["CompactText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Compact12Text"],
    CellMargins->{{10, 4}, {0, 8}},
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None],
  
  Cell[StyleData["Compact12Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextSans"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["TextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedText"],
    CellMargins->{{20, 4}, {0, 8}},
    ParagraphSpacing->{0, 8},
    ParagraphIndent->-15,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedText", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote"],
    CellMargins->{{35, 4}, {0, 4}},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndentedText"],
    CellMargins->{{20, 4}, {0, 6}},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["IndentedText", "Printout"],
    CellMargins->{{12, 0}, {0, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{19, 62}, {0, 14}},
    PageBreakBelow->False,
    CellFrameLabelMargins->4,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{9, 0}, {0, 14}},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{10, 4}, {0, 8}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"SmallText",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    TextJustification->1,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Input/Output", "Subsubsection"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.    \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->True,
    CellMargins->{{46, 4}, {3, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->StandardForm],
  
  Cell[StyleData["Output", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Printout"],
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultFormatTypeForOutput,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["Graphics", "Printout"],
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->7,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Name"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Name", "Printout"],
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlinks", "Subsubsection"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks. The others point to the various sections of the help \
browser. These styles will modify individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None",
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLinkMR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLinkMR", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Subsubsection"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["JT"],
    StyleMenuListing->None,
    FontFamily->"JFontText"],
  
  Cell[StyleData["JS"],
    StyleMenuListing->None,
    FontFamily->"JFontSans"],
  
  Cell[StyleData["JSB"],
    StyleMenuListing->None,
    FontFamily->"JFontSansBold"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["M4"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Math4",
    CharacterEncoding->"Math4"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1", "Printout"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1MR", "Printout"],
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->{0.31, 0.62}}],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->0.31}],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->{0.13, 0.33, 0.13, 0.33}}],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->0.194}],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBox"],
    CellFrame->0.5,
    CellMargins->{{37, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ItemizedNoteBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{11, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 0}},
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 4}, {0, 0}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{11, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{11, 4}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    CellMargins->{{10, Inherited}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    CellMargins->{{35, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{10, Inherited}, {0, 8}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    CellMargins->{{10, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Caption"],
    CellMargins->{{10, 4}, {0, 3}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["Caption", "Printout"],
    CellMargins->{{2, 0}, {0, 3}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InlineOutput", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    ScriptLevel->0,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True},
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    CellMargins->{{34, Inherited}, {Inherited, 10}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayMath"],
    CellMargins->{{42, 10}, {7, 7}},
    Evaluatable->False,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input"],
  
  Cell[StyleData["DisplayMath", "Printout"],
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{42, 10}, {7, 7}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{34, 55}, {0, 10}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EquationNumber"],
    LineSpacing->{1.83, 0}],
  
  Cell[StyleData["EquationNumber", "Printout"],
    LineSpacing->{1.7, 0}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellMargins->{{16, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{8, Inherited}, {Inherited, 10}},
    FontSize->9.5]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Unique Help Browser Styles", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    CellMargins->{{10, 4}, {1, 10}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Command"],
    CellMargins->{{10, 4}, {0, 14}},
    CounterIncrements->"Section",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Command", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CharacterName"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 4}},
    CellFrameMargins->4,
    StyleMenuListing->None],
  
  Cell[StyleData["CharacterName", "Printout"],
    CellMargins->{{2, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 4}},
    CellFrameMargins->5,
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NotesList"],
    CellMargins->{{20, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Printout"],
    CellMargins->{{12, 0}, {2, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{11, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    StyleMenuListing->None,
    FontSize->13,
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleText"],
    ShowCellBracket->True,
    CellMargins->{{20, 40}, {0, 18}},
    ParagraphSpacing->{0, 6},
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleText", "Printout"],
    CellMargins->{{2, 80}, {0, 8}},
    PageBreakBelow->False,
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSubsection"],
    ShowCellBracket->True,
    CellMargins->{{20, 4}, {0, 16}},
    CellGroupingRules->{"SectionGrouping", 80},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSubsection", "Printout"],
    CellMargins->{{12, 0}, {0, 16}},
    PageBreakBelow->False,
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LineHead"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{10, 4}, {8, 18}},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["LineHead", "Printout"],
    CellMargins->{{2, 0}, {8, 18}},
    PageBreakBelow->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushInput"],
    CellMargins->{{10, 4}, {1, 4}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["FlushInput", "Printout"],
    CellMargins->{{2, 0}, {1, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushOutput"],
    CellMargins->{{10, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->StandardForm,
    StyleMenuListing->None],
  
  Cell[StyleData["FlushOutput", "Printout"],
    CellMargins->{{2, Inherited}, {Inherited, Inherited}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DialogItem"],
    CellDingbat->"\[EmptyDiamond]",
    CellMargins->{{20, 4}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["DialogItem", "Printout"],
    CellMargins->{{12, 0}, {0, 12}},
    PageBreakBelow->False,
    FontSize->8]
  }, Closed]],
  
  Cell[StyleData["GroupDivider"],
    CellMargins->{{10, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->{"TitleGrouping", 0},
    StyleMenuListing->None],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Highlight"],
    CellMargins->{{10, 4}, {0, 18}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Highlight", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    LineSpacing->{1, 3}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserNotes"],
    CellFrame->{{2, 0}, {0, 0.25}},
    CellMargins->{{10, 4}, {0, 4}},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["UserNotes", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MoreInfo"],
    CellMargins->{{10, 4}, {0, 4}},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.700008, 0.4, 0.100008]],
  
  Cell[StyleData["MoreInfo", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserTips"],
    CellFrame->{{2, 0}, {0, 0.25}},
    CellMargins->{{10, 4}, {0, 4}},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.2, 0.500008, 0.700008]],
  
  Cell[StyleData["UserTips", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    LineSpacing->{1, 3},
    FontSize->8,
    Background->GrayLevel[0.700008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Theorem"],
    CellFrame->{{4, 0}, {0, 0}},
    CellMargins->{{12, 62}, {0, 14}},
    CellFrameMargins->4,
    CellFrameColor->RGBColor[0, 0, 0.8],
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Theorem", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    CellFrameMargins->3,
    CellFrameColor->GrayLevel[0.8],
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellFrame->{{2, 0}, {0, 0}},
    CellMargins->{{36, 10}, {7, 7}},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CellFrameColor->RGBColor[0, 0.2, 1],
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 8},
    FontSlant->"Italic"],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{32, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Contents and Index", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsTitle"],
    CellMargins->{{10, 4}, {0, 18}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsTitle", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsSection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{20, 4}, {3, 18}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsSection", "Printout"],
    CellMargins->{{12, 0}, {3, 18}},
    PageBreakBelow->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{20, 4}, {5, 20}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["IndexSection", "Printout"],
    CellMargins->{{12, 0}, {5, 20}},
    PageBreakBelow->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Contents"],
    CellMargins->{{21, 4}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Contents", "Printout"],
    CellMargins->{{13, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index"],
    CellMargins->{{21, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["Index", "Printout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSubentry"],
    CellMargins->{{36, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["IndexSubentry", "Printout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Horizontal Lines", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Line1"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-16, 9}},
    StyleMenuListing->None,
    FontSize->2],
  
  Cell[StyleData["Line1", "Printout"],
    CellMargins->{{2, 0}, {-16, 9}}]
  }, Closed]],
  
  Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramTop"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{10, 4}, {-18, 18}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramTop", "Printout"],
    CellMargins->{{2, 0}, {-18, 18}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramBottom"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{10, 4}, {-10, -2}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramBottom", "Printout"],
    CellMargins->{{2, 0}, {-10, -2}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SessionLabel"],
    CellFrame->{{0.5, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-4, 18}},
    LineSpacing->{1, -3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SessionLabel", "Printout"],
    CellMargins->{{2, 0}, {-4, 18}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Page Headers and Footers", "Subsubsection"],
  
  Cell[StyleData["PageHeader"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Bold"],
  
  Cell[StyleData["PageFooter"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notation Package Styles", "Subsubsection",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell["\<\
The cells below define certain styles needed by the Notation \
package. These styles serve to make visible otherwise invisible \
tagboxes.\
\>", "Text",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationTemplateStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 1, 0.850004],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationPatternWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.900008, 0.979995],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationMadeBoxesWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[0.900008, 0.889998, 1],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Notation:S1"->{
    Cell[2190, 67, 86, 1, 36, "Subsection",
      CellTags->"Notation:S1"],
    Cell[7769, 268, 64, 1, 24, "SubsubsectionIcon",
      CellTags->"Notation:S1"],
    Cell[7836, 271, 5231, 155, 124, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[13070, 428, 97, 1, 17, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[13170, 431, 603, 12, 59, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[13776, 445, 93, 1, 31, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[13872, 448, 136, 3, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[14011, 453, 161, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[14175, 460, 616, 17, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[14794, 479, 346, 12, 30, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15165, 495, 255, 7, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15423, 504, 345, 10, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15783, 517, 171, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15979, 526, 212, 5, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[16194, 533, 229, 6, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[16438, 542, 675, 17, 36, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[17116, 561, 186, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[17305, 568, 633, 17, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[17941, 587, 140, 4, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18106, 595, 304, 8, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18413, 605, 288, 8, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18716, 616, 228, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18947, 623, 1317, 38, 80, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[20267, 663, 150, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[20442, 671, 447, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[20892, 687, 632, 18, 41, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[21539, 708, 184, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[21726, 714, 1244, 36, 80, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[22973, 752, 121, 1, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[23119, 757, 410, 11, 46, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[23532, 770, 334, 9, 38, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[23881, 782, 237, 6, 22, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[24121, 790, 189, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[24313, 797, 623, 17, 34, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[24939, 816, 154, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[25096, 822, 607, 15, 32, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[25728, 841, 515, 14, 44, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[26246, 857, 669, 18, 39, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[26930, 878, 394, 7, 37, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[27361, 890, 65, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S1"],
    Cell[27429, 893, 2782, 83, 78, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize"}],
    Cell[30214, 978, 102, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[30319, 981, 360, 7, 37, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[30682, 990, 230, 5, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[30915, 997, 428, 13, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[31346, 1012, 259, 6, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[31630, 1022, 424, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[32057, 1038, 276, 8, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[32348, 1049, 210, 5, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[32561, 1056, 804, 24, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[33368, 1082, 262, 6, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[33655, 1092, 575, 16, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34233, 1110, 136, 3, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34384, 1116, 245, 7, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34632, 1125, 253, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34888, 1134, 169, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[35082, 1143, 178, 5, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[35263, 1150, 245, 6, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[35523, 1159, 717, 23, 54, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[36243, 1184, 194, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[36440, 1190, 246, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[37349, 1222, 70, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S1"],
    Cell[37422, 1225, 3550, 104, 78, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation"}],
    Cell[40975, 1331, 103, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[41081, 1334, 577, 15, 54, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[41661, 1351, 269, 9, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[41933, 1362, 353, 11, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[42311, 1377, 421, 13, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[42735, 1392, 198, 5, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[42948, 1400, 220, 7, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[43193, 1411, 480, 14, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[43676, 1427, 453, 15, 22, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[44144, 1445, 702, 18, 38, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[44849, 1465, 155, 4, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[45029, 1473, 428, 11, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[45460, 1486, 320, 9, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[45795, 1498, 444, 15, 24, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[46276, 1518, 74, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S1"],
    Cell[46353, 1521, 590, 16, 24, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4"}],
    Cell[46946, 1539, 3413, 87, 138, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[50362, 1628, 616, 14, 56, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[50981, 1644, 120, 1, 30, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[51104, 1647, 406, 11, 26, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[51513, 1660, 362, 9, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[51878, 1671, 1084, 27, 57, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[52965, 1700, 143, 4, 30, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[53111, 1706, 457, 12, 34, "Input",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[53571, 1720, 224, 6, 24, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4"}]},
  "Notation:S1.1"->{
    Cell[2279, 70, 62, 1, 34, "Subsubsection",
      CellTags->"Notation:S1.1"],
    Cell[7836, 271, 5231, 155, 124, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[13070, 428, 97, 1, 17, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[13170, 431, 603, 12, 59, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[13776, 445, 93, 1, 31, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[13872, 448, 136, 3, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[14011, 453, 161, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[14175, 460, 616, 17, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[14794, 479, 346, 12, 30, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15165, 495, 255, 7, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15423, 504, 345, 10, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15783, 517, 171, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[15979, 526, 212, 5, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[16194, 533, 229, 6, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[16438, 542, 675, 17, 36, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[17116, 561, 186, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[17305, 568, 633, 17, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[17941, 587, 140, 4, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18106, 595, 304, 8, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18413, 605, 288, 8, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18716, 616, 228, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[18947, 623, 1317, 38, 80, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[20267, 663, 150, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[20442, 671, 447, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[20892, 687, 632, 18, 41, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[21539, 708, 184, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[21726, 714, 1244, 36, 80, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[22973, 752, 121, 1, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[23119, 757, 410, 11, 46, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[23532, 770, 334, 9, 38, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[23881, 782, 237, 6, 22, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[24121, 790, 189, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[24313, 797, 623, 17, 34, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[24939, 816, 154, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[25096, 822, 607, 15, 32, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[25728, 841, 515, 14, 44, "Input",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[26246, 857, 669, 18, 39, "Output",
      CellTags->{"Notation:S1", "Notation:S1.1"}],
    Cell[26930, 878, 394, 7, 37, "Text",
      CellTags->{"Notation:S1", "Notation:S1.1"}]},
  "Notation:S1.2"->{
    Cell[2344, 73, 63, 1, 34, "Subsubsection",
      CellTags->"Notation:S1.2"],
    Cell[27429, 893, 2782, 83, 78, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize"}],
    Cell[30214, 978, 102, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[30319, 981, 360, 7, 37, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[30682, 990, 230, 5, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[30915, 997, 428, 13, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[31346, 1012, 259, 6, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[31630, 1022, 424, 14, 26, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[32057, 1038, 276, 8, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[32348, 1049, 210, 5, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[32561, 1056, 804, 24, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[33368, 1082, 262, 6, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[33655, 1092, 575, 16, 41, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34233, 1110, 136, 3, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34384, 1116, 245, 7, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34632, 1125, 253, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[34888, 1134, 169, 5, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[35082, 1143, 178, 5, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[35263, 1150, 245, 6, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[35523, 1159, 717, 23, 54, "Text",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[36243, 1184, 194, 4, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.2"}],
    Cell[36440, 1190, 246, 7, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.2"}]},
  "Notation:S1.3"->{
    Cell[2410, 76, 68, 1, 34, "Subsubsection",
      CellTags->"Notation:S1.3"],
    Cell[37422, 1225, 3550, 104, 78, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation"}],
    Cell[40975, 1331, 103, 1, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[41081, 1334, 577, 15, 54, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[41661, 1351, 269, 9, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[41933, 1362, 353, 11, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[42311, 1377, 421, 13, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[42735, 1392, 198, 5, 20, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[42948, 1400, 220, 7, 28, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[43193, 1411, 480, 14, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[43676, 1427, 453, 15, 22, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[44144, 1445, 702, 18, 38, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[44849, 1465, 155, 4, 29, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[45029, 1473, 428, 11, 27, "Input",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[45460, 1486, 320, 9, 32, "Output",
      CellTags->{"Notation:S1", "Notation:S1.3"}],
    Cell[45795, 1498, 444, 15, 24, "Text",
      CellTags->{"Notation:S1", "Notation:S1.3"}]},
  "Notation:S1.4"->{
    Cell[2481, 79, 72, 1, 34, "Subsubsection",
      CellTags->"Notation:S1.4"],
    Cell[46353, 1521, 590, 16, 24, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4"}],
    Cell[46946, 1539, 3413, 87, 138, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[50362, 1628, 616, 14, 56, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[50981, 1644, 120, 1, 30, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[51104, 1647, 406, 11, 26, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[51513, 1660, 362, 9, 15, "Caption",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[51878, 1671, 1084, 27, 57, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[52965, 1700, 143, 4, 30, "MathCaption",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[53111, 1706, 457, 12, 34, "Input",
      CellTags->{"Notation:S1", "Notation:S1.4"}],
    Cell[53571, 1720, 224, 6, 24, "Text",
      CellTags->{"Notation:S1", "Notation:S1.4"}]},
  "Notation:S2"->{
    Cell[2556, 82, 85, 1, 36, "Subsection",
      CellTags->"Notation:S2"],
    Cell[53931, 1736, 84, 1, 24, "SubsubsectionIcon",
      CellTags->"Notation:S2"],
    Cell[54018, 1739, 1404, 36, 77, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1"}],
    Cell[55425, 1777, 2371, 53, 132, "DefinitionBox",
      CellTags->{"List of Boxes", "Notation:S2", "Notation:S2.1"}],
    Cell[57799, 1832, 121, 1, 15, "Caption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[57923, 1835, 650, 15, 40, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[58576, 1852, 145, 4, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[58724, 1858, 1130, 31, 42, "Input",
      CellTags->{"Ring Operations", "Notation:S2", "Notation:S2.1"}],
    Cell[59857, 1891, 223, 6, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60105, 1901, 256, 6, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60364, 1909, 286, 8, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60687, 1922, 140, 3, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60830, 1927, 344, 10, 33, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[61189, 1940, 542, 14, 41, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[61734, 1956, 157, 4, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[61916, 1964, 360, 11, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62279, 1977, 318, 8, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62612, 1988, 174, 4, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62811, 1996, 172, 4, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62986, 2002, 173, 4, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[63174, 2009, 226, 7, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[63403, 2018, 1640, 47, 74, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[65046, 2067, 346, 13, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[65417, 2084, 365, 8, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[65785, 2094, 341, 8, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[66175, 2108, 80, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S2"],
    Cell[66258, 2111, 530, 16, 37, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses"}],
    Cell[66791, 2129, 124, 1, 28, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[66918, 2132, 523, 14, 27, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[67466, 2150, 258, 7, 27, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[67727, 2159, 273, 8, 32, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68015, 2170, 179, 5, 29, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68219, 2179, 187, 5, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68409, 2186, 286, 8, 32, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68744, 2200, 89, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S2"],
    Cell[68836, 2203, 1071, 28, 59, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences"}],
    Cell[69910, 2233, 249, 6, 31, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.3"}],
    Cell[70184, 2243, 337, 10, 28, "Input",
      CellTags->{"Notation:S2", "Notation:S2.3"}],
    Cell[70524, 2255, 529, 13, 23, "Output",
      CellTags->{"Notation:S2", "Notation:S2.3"}],
    Cell[71068, 2271, 701, 21, 42, "Text",
      CellTags->{"Notation:S2", "Notation:S2.3"}]},
  "Notation:S2.1"->{
    Cell[2644, 85, 82, 1, 34, "Subsubsection",
      CellTags->"Notation:S2.1"],
    Cell[54018, 1739, 1404, 36, 77, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1"}],
    Cell[55425, 1777, 2371, 53, 132, "DefinitionBox",
      CellTags->{"List of Boxes", "Notation:S2", "Notation:S2.1"}],
    Cell[57799, 1832, 121, 1, 15, "Caption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[57923, 1835, 650, 15, 40, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[58576, 1852, 145, 4, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[58724, 1858, 1130, 31, 42, "Input",
      CellTags->{"Ring Operations", "Notation:S2", "Notation:S2.1"}],
    Cell[59857, 1891, 223, 6, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60105, 1901, 256, 6, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60364, 1909, 286, 8, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60687, 1922, 140, 3, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[60830, 1927, 344, 10, 33, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[61189, 1940, 542, 14, 41, "Text",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[61734, 1956, 157, 4, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[61916, 1964, 360, 11, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62279, 1977, 318, 8, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62612, 1988, 174, 4, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62811, 1996, 172, 4, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[62986, 2002, 173, 4, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[63174, 2009, 226, 7, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[63403, 2018, 1640, 47, 74, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[65046, 2067, 346, 13, 30, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[65417, 2084, 365, 8, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.1"}],
    Cell[65785, 2094, 341, 8, 21, "Output",
      CellTags->{"Notation:S2", "Notation:S2.1"}]},
  "Notation:S2.2"->{
    Cell[2729, 88, 78, 1, 34, "Subsubsection",
      CellTags->"Notation:S2.2"],
    Cell[66258, 2111, 530, 16, 37, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses"}],
    Cell[66791, 2129, 124, 1, 28, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[66918, 2132, 523, 14, 27, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[67466, 2150, 258, 7, 27, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[67727, 2159, 273, 8, 32, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68015, 2170, 179, 5, 29, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68219, 2179, 187, 5, 26, "Input",
      CellTags->{"Notation:S2", "Notation:S2.2"}],
    Cell[68409, 2186, 286, 8, 32, "Output",
      CellTags->{"Notation:S2", "Notation:S2.2"}]},
  "Notation:S2.3"->{
    Cell[2810, 91, 87, 1, 34, "Subsubsection",
      CellTags->"Notation:S2.3"],
    Cell[68836, 2203, 1071, 28, 59, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences"}],
    Cell[69910, 2233, 249, 6, 31, "MathCaption",
      CellTags->{"Notation:S2", "Notation:S2.3"}],
    Cell[70184, 2243, 337, 10, 28, "Input",
      CellTags->{"Notation:S2", "Notation:S2.3"}],
    Cell[70524, 2255, 529, 13, 23, "Output",
      CellTags->{"Notation:S2", "Notation:S2.3"}],
    Cell[71068, 2271, 701, 21, 42, "Text",
      CellTags->{"Notation:S2", "Notation:S2.3"}]},
  "Notation:S3"->{
    Cell[2900, 94, 80, 1, 36, "Subsection",
      CellTags->"Notation:S3"],
    Cell[71878, 2300, 755, 22, 53, "Text",
      CellTags->{"Notation:Documentation:Options", "Notation:S3"}],
    Cell[72658, 2326, 111, 4, 24, "SubsubsectionIcon",
      CellTags->"Notation:S3"],
    Cell[72772, 2332, 1690, 45, 112, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1"}],
    Cell[74465, 2379, 152, 5, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[74620, 2386, 512, 17, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[75135, 2405, 175, 4, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[75313, 2411, 849, 22, 42, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76165, 2435, 110, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76300, 2440, 223, 6, 30, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76526, 2448, 360, 11, 24, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76901, 2462, 524, 16, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[77428, 2480, 117, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[77548, 2483, 849, 22, 42, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[78400, 2507, 132, 2, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[78557, 2513, 223, 6, 30, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[78783, 2521, 224, 6, 22, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[79022, 2530, 463, 13, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[79488, 2545, 256, 9, 29, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[79769, 2558, 848, 22, 42, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[80620, 2582, 1123, 26, 50, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[81746, 2610, 1571, 33, 50, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[83366, 2649, 116, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S3"],
    Cell[83485, 2655, 5614, 151, 112, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2"}],
    Cell[89102, 2808, 165, 5, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[89270, 2815, 890, 33, 54, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[90163, 2850, 577, 21, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[90743, 2873, 303, 11, 29, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[91049, 2886, 1943, 51, 65, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[92995, 2939, 104, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93124, 2944, 298, 8, 29, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93425, 2954, 257, 7, 35, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93719, 2966, 140, 3, 26, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93862, 2971, 269, 8, 32, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[94168, 2984, 643, 17, 32, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[94814, 3003, 464, 12, 20, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[95327, 3021, 128, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S3"],
    Cell[95458, 3027, 4567, 127, 94, "DefinitionBox3Col",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[100028, 3156, 117, 1, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[100148, 3159, 1094, 29, 69, "text",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[101245, 3190, 215, 6, 30, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[101463, 3198, 183, 5, 26, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[101683, 3208, 123, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S3"],
    Cell[101809, 3214, 1468, 41, 39, "DefinitionBox",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[103280, 3257, 91, 1, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[103374, 3260, 522, 13, 53, "Text",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[103899, 3275, 124, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[104026, 3278, 136, 3, 26, "Input",
      CellTags->{"Notation:S3", "Notation:S3.4"}]},
  "Notation:S3.1"->{
    Cell[2983, 97, 109, 4, 34, "Subsubsection",
      CellTags->"Notation:S3.1"],
    Cell[72772, 2332, 1690, 45, 112, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1"}],
    Cell[74465, 2379, 152, 5, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[74620, 2386, 512, 17, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[75135, 2405, 175, 4, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[75313, 2411, 849, 22, 42, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76165, 2435, 110, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76300, 2440, 223, 6, 30, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76526, 2448, 360, 11, 24, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[76901, 2462, 524, 16, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[77428, 2480, 117, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[77548, 2483, 849, 22, 42, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[78400, 2507, 132, 2, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[78557, 2513, 223, 6, 30, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[78783, 2521, 224, 6, 22, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[79022, 2530, 463, 13, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[79488, 2545, 256, 9, 29, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[79769, 2558, 848, 22, 42, "Input",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[80620, 2582, 1123, 26, 50, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}],
    Cell[81746, 2610, 1571, 33, 50, "Output",
      CellTags->{"Notation:S3", "Notation:S3.1"}]},
  "Notation:S3.2"->{
    Cell[3095, 103, 114, 4, 34, "Subsubsection",
      CellTags->"Notation:S3.2"],
    Cell[83485, 2655, 5614, 151, 112, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2"}],
    Cell[89102, 2808, 165, 5, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[89270, 2815, 890, 33, 54, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[90163, 2850, 577, 21, 38, "Text",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[90743, 2873, 303, 11, 29, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[91049, 2886, 1943, 51, 65, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[92995, 2939, 104, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93124, 2944, 298, 8, 29, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93425, 2954, 257, 7, 35, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93719, 2966, 140, 3, 26, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[93862, 2971, 269, 8, 32, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[94168, 2984, 643, 17, 32, "Input",
      CellTags->{"Notation:S3", "Notation:S3.2"}],
    Cell[94814, 3003, 464, 12, 20, "Output",
      CellTags->{"Notation:S3", "Notation:S3.2"}]},
  "Notation:S3.3"->{
    Cell[3212, 109, 167, 6, 34, "Subsubsection",
      CellTags->"Notation:S3.3"],
    Cell[95458, 3027, 4567, 127, 94, "DefinitionBox3Col",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[100028, 3156, 117, 1, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[100148, 3159, 1094, 29, 69, "text",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[101245, 3190, 215, 6, 30, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.3"}],
    Cell[101463, 3198, 183, 5, 26, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S3", "Notation:S3.3"}]},
  "Notation:S3.4"->{
    Cell[3382, 117, 121, 4, 34, "Subsubsection",
      CellTags->"Notation:S3.4"],
    Cell[101809, 3214, 1468, 41, 39, "DefinitionBox",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[103280, 3257, 91, 1, 15, "Caption",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[103374, 3260, 522, 13, 53, "Text",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[103899, 3275, 124, 1, 28, "MathCaption",
      CellTags->{"Notation:S3", "Notation:S3.4"}],
    Cell[104026, 3278, 136, 3, 26, "Input",
      CellTags->{"Notation:S3", "Notation:S3.4"}]},
  "Notation:S4"->{
    Cell[3506, 123, 87, 1, 36, "Subsection",
      CellTags->"Notation:S4"],
    Cell[104278, 3289, 154, 2, 34, "Subsubsection",
      CellGroupingRules->"NormalGrouping",
      CellTags->{"Notation:S4.1", "Notation:S4"}],
    Cell[104435, 3293, 684, 18, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features"}],
    Cell[106228, 3347, 65, 1, 24, "SubsubsectionIcon",
      CellTags->"Notation:S4"],
    Cell[106296, 3350, 757, 24, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes"}],
    Cell[107056, 3376, 147, 5, 28, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[107206, 3383, 873, 24, 56, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[108082, 3409, 301, 8, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[108595, 3429, 937, 27, 56, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[109535, 3458, 220, 7, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[109780, 3469, 150, 5, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[109933, 3476, 159, 4, 23, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[110107, 3483, 397, 11, 40, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[110507, 3496, 357, 12, 46, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[110867, 3510, 346, 9, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111216, 3521, 261, 8, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111502, 3533, 159, 5, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111664, 3540, 185, 4, 21, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111864, 3547, 512, 16, 40, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[112413, 3568, 116, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S4"],
    Cell[112532, 3574, 1183, 36, 56, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", 
        "Notation:Documentation:NotationBoxTag"}],
    Cell[113718, 3612, 169, 5, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[113912, 3621, 243, 7, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[114158, 3630, 336, 9, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[114509, 3642, 205, 6, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[114717, 3650, 307, 7, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[115049, 3661, 159, 4, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[115211, 3667, 233, 6, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[115493, 3679, 141, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S4"],
    Cell[115637, 3685, 1107, 22, 96, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag"}],
    Cell[116747, 3709, 186, 5, 29, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[116936, 3716, 996, 25, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[117935, 3743, 391, 7, 36, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[118329, 3752, 157, 4, 28, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[118489, 3758, 349, 9, 26, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4"}],
    Cell[118841, 3769, 162, 4, 28, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119028, 3777, 249, 6, 27, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119280, 3785, 202, 5, 20, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119497, 3793, 171, 4, 28, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119693, 3801, 249, 7, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119945, 3810, 280, 8, 32, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[120240, 3821, 341, 8, 23, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[120584, 3831, 240, 7, 29, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[120849, 3842, 994, 25, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[121846, 3869, 655, 16, 35, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[122504, 3887, 604, 15, 35, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[123123, 3905, 326, 9, 37, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[123486, 3919, 122, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S4"],
    Cell[123611, 3925, 720, 13, 66, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag"}],
    Cell[124334, 3940, 196, 5, 29, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[124555, 3949, 1179, 30, 42, "Input",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[125737, 3981, 937, 23, 35, "Output",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[126689, 4007, 319, 8, 38, "Text",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[127045, 4020, 175, 6, 20, "SubsubsectionIcon",
      CellTags->"Notation:S4"],
    Cell[127223, 4028, 968, 34, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm"}],
    Cell[128194, 4064, 162, 4, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[128381, 4072, 224, 6, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[128608, 4080, 349, 10, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[128972, 4093, 232, 5, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[129207, 4100, 601, 17, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[129811, 4119, 115, 1, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[129951, 4124, 328, 9, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[130282, 4135, 349, 10, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[130646, 4148, 163, 4, 24, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[130812, 4154, 10803, 233, 107, "OptionBox3Col",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[141618, 4389, 187, 4, 15, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[141808, 4395, 642, 16, 56, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[142453, 4413, 6920, 200, 184, "DefinitionBox",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[149376, 4615, 177, 5, 15, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6"}]},
  "Notation:S4.2"->{
    Cell[3596, 126, 182, 3, 34, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[3781, 131, 63, 1, 34, "Subsubsection",
      CellTags->"Notation:S4.2"],
    Cell[106296, 3350, 757, 24, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes"}],
    Cell[107056, 3376, 147, 5, 28, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[107206, 3383, 873, 24, 56, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[108082, 3409, 301, 8, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[108595, 3429, 937, 27, 56, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[109535, 3458, 220, 7, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[109780, 3469, 150, 5, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[109933, 3476, 159, 4, 23, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[110107, 3483, 397, 11, 40, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[110507, 3496, 357, 12, 46, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[110867, 3510, 346, 9, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111216, 3521, 261, 8, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111502, 3533, 159, 5, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111664, 3540, 185, 4, 21, "Output",
      CellTags->{"Notation:S4", "Notation:S4.2"}],
    Cell[111864, 3547, 512, 16, 40, "Text",
      CellTags->{"Notation:S4", "Notation:S4.2"}]},
  "Notation:S4.3"->{
    Cell[3596, 126, 182, 3, 34, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[3847, 134, 114, 4, 34, "Subsubsection",
      CellTags->"Notation:S4.3"],
    Cell[112532, 3574, 1183, 36, 56, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", 
        "Notation:Documentation:NotationBoxTag"}],
    Cell[113718, 3612, 169, 5, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[113912, 3621, 243, 7, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[114158, 3630, 336, 9, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[114509, 3642, 205, 6, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[114717, 3650, 307, 7, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[115049, 3661, 159, 4, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.3"}],
    Cell[115211, 3667, 233, 6, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.3"}]},
  "Notation:S4.4"->{
    Cell[3596, 126, 182, 3, 34, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[3964, 140, 139, 4, 34, "Subsubsection",
      CellTags->"Notation:S4.4"],
    Cell[115637, 3685, 1107, 22, 96, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag"}],
    Cell[116747, 3709, 186, 5, 29, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[116936, 3716, 996, 25, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[117935, 3743, 391, 7, 36, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[118329, 3752, 157, 4, 28, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[118489, 3758, 349, 9, 26, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4"}],
    Cell[118841, 3769, 162, 4, 28, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119028, 3777, 249, 6, 27, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119280, 3785, 202, 5, 20, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119497, 3793, 171, 4, 28, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119693, 3801, 249, 7, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[119945, 3810, 280, 8, 32, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[120240, 3821, 341, 8, 23, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[120584, 3831, 240, 7, 29, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[120849, 3842, 994, 25, 28, "Input",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[121846, 3869, 655, 16, 35, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[122504, 3887, 604, 15, 35, "Output",
      CellTags->{"Notation:S4", "Notation:S4.4"}],
    Cell[123123, 3905, 326, 9, 37, "Text",
      CellTags->{"Notation:S4", "Notation:S4.4"}]},
  "Notation:S4.5"->{
    Cell[3596, 126, 182, 3, 34, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[4106, 146, 120, 4, 34, "Subsubsection",
      CellTags->"Notation:S4.5"],
    Cell[123611, 3925, 720, 13, 66, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag"}],
    Cell[124334, 3940, 196, 5, 29, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[124555, 3949, 1179, 30, 42, "Input",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[125737, 3981, 937, 23, 35, "Output",
      CellTags->{"Notation:S4", "Notation:S4.5"}],
    Cell[126689, 4007, 319, 8, 38, "Text",
      CellTags->{"Notation:S4", "Notation:S4.5"}]},
  "Notation:S4.6"->{
    Cell[3596, 126, 182, 3, 34, "Subsubsection",
      CellTags->{
      "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
        "Notation:S4.6"}],
    Cell[4229, 152, 173, 6, 34, "Subsubsection",
      CellTags->"Notation:S4.6"],
    Cell[127223, 4028, 968, 34, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm"}],
    Cell[128194, 4064, 162, 4, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[128381, 4072, 224, 6, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[128608, 4080, 349, 10, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[128972, 4093, 232, 5, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[129207, 4100, 601, 17, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[129811, 4119, 115, 1, 30, "MathCaption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[129951, 4124, 328, 9, 26, "Input",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[130282, 4135, 349, 10, 33, "Output",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[130646, 4148, 163, 4, 24, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[130812, 4154, 10803, 233, 107, "OptionBox3Col",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[141618, 4389, 187, 4, 15, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[141808, 4395, 642, 16, 56, "Text",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[142453, 4413, 6920, 200, 184, "DefinitionBox",
      CellTags->{"Notation:S4", "Notation:S4.6"}],
    Cell[149376, 4615, 177, 5, 15, "Caption",
      CellTags->{"Notation:S4", "Notation:S4.6"}]},
  "Notation:S5"->{
    Cell[4405, 160, 80, 1, 36, "Subsection",
      CellTags->"Notation:S5"],
    Cell[149662, 4628, 270, 7, 24, "Text",
      CellTags->{"Notation:S5", "Notation:Documentation:Guidelines"}],
    Cell[149957, 4639, 84, 1, 24, "SubsubsectionIcon",
      CellTags->"Notation:S5"],
    Cell[150044, 4642, 621, 14, 50, "Text",
      CellTags->{"Notation:S5", "Notation:S5.1"}],
    Cell[150702, 4661, 76, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S5"],
    Cell[150781, 4664, 506, 10, 52, "Text",
      CellTags->{"Notation:S5", "Notation:S5.2"}],
    Cell[151324, 4679, 98, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S5"],
    Cell[151425, 4682, 726, 13, 56, "Text",
      CellTags->{"Notation:S5", "Notation:S5.3"}],
    Cell[152188, 4700, 95, 1, 20, "SubsubsectionIcon",
      CellTags->"Notation:S5"],
    Cell[152286, 4703, 454, 7, 59, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4", "Parse without evaluation"}],
    
    Cell[152743, 4712, 161, 4, 31, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[152907, 4718, 491, 13, 30, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[153423, 4735, 195, 5, 29, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[153621, 4742, 271, 8, 37, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[153907, 4753, 399, 10, 42, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[154309, 4765, 366, 8, 31, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[154700, 4777, 267, 7, 30, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[155044, 4789, 224, 5, 25, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[155317, 4800, 136, 4, 20, "SubsubsectionIcon",
      CellTags->"Notation:S5"],
    Cell[155456, 4806, 543, 16, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[156002, 4824, 786, 20, 44, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[156791, 4846, 260, 10, 24, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[157054, 4858, 2508, 86, 27, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[159565, 4946, 714, 24, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[160282, 4972, 1187, 42, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[161472, 5016, 504, 13, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[161979, 5031, 926, 30, 146, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[162920, 5064, 121, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "Notation:S5.6"}]},
  "Notation:S5.1"->{
    Cell[4488, 163, 82, 1, 34, "Subsubsection",
      CellTags->"Notation:S5.1"],
    Cell[150044, 4642, 621, 14, 50, "Text",
      CellTags->{"Notation:S5", "Notation:S5.1"}]},
  "Notation:S5.2"->{
    Cell[4573, 166, 74, 1, 34, "Subsubsection",
      CellTags->"Notation:S5.2"],
    Cell[150781, 4664, 506, 10, 52, "Text",
      CellTags->{"Notation:S5", "Notation:S5.2"}]},
  "Notation:S5.3"->{
    Cell[4650, 169, 96, 1, 34, "Subsubsection",
      CellTags->"Notation:S5.3"],
    Cell[151425, 4682, 726, 13, 56, "Text",
      CellTags->{"Notation:S5", "Notation:S5.3"}]},
  "Notation:S5.4"->{
    Cell[4749, 172, 93, 1, 34, "Subsubsection",
      CellTags->"Notation:S5.4"],
    Cell[152286, 4703, 454, 7, 59, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4", "Parse without evaluation"}],
    
    Cell[152743, 4712, 161, 4, 31, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[152907, 4718, 491, 13, 30, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[153423, 4735, 195, 5, 29, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[153621, 4742, 271, 8, 37, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[153907, 4753, 399, 10, 42, "Text",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[154309, 4765, 366, 8, 31, "MathCaption",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[154700, 4777, 267, 7, 30, "Input",
      CellTags->{"Notation:S5", "Notation:S5.4"}],
    Cell[155044, 4789, 224, 5, 25, "Output",
      CellTags->{"Notation:S5", "Notation:S5.4"}]},
  "Notation:S5.5"->{
    Cell[4845, 175, 134, 4, 34, "Subsubsection",
      CellTags->"Notation:S5.5"],
    Cell[155456, 4806, 543, 16, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[156002, 4824, 786, 20, 44, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[156791, 4846, 260, 10, 24, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[157054, 4858, 2508, 86, 27, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[159565, 4946, 714, 24, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[160282, 4972, 1187, 42, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[161472, 5016, 504, 13, 40, "Text",
      CellTags->{"Notation:S5", "Notation:S5.5"}],
    Cell[161979, 5031, 926, 30, 146, "Input",
      Evaluatable->False,
      CellTags->{"Notation:S5", "Notation:S5.5"}]},
  "Notation:S5.6"->{
    Cell[4982, 181, 88, 1, 34, "Subsubsection",
      CellTags->"Notation:S5.6"],
    Cell[162920, 5064, 121, 1, 20, "SubsubsectionIcon",
      CellTags->{"Notation:S5", "Notation:S5.6"}]},
  "Notation:S5.7"->{
    Cell[5073, 184, 82, 1, 34, "Subsubsection",
      CellTags->"Notation:S5.7"]},
  "Notation:Definition:Notation"->{
    Cell[7836, 271, 5231, 155, 124, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
    Cell[37422, 1225, 3550, 104, 78, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation"}]},
  "Notation:Definition:Symbolize"->{
    Cell[27429, 893, 2782, 83, 78, "DefinitionBox",
      CellTags->{
      "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize"}]},
  "Must use palette"->{
    Cell[46353, 1521, 590, 16, 24, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4"}]},
  "Notation:Documentation:Entering Notations"->{
    Cell[46353, 1521, 590, 16, 24, "Text",
      CellTags->{
      "Must use palette", "Notation:Documentation:Entering Notations", 
        "Notation:S1", "Notation:S1.4"}]},
  "Notation:Documentation:Precedence"->{
    Cell[54018, 1739, 1404, 36, 77, "Text",
      CellTags->{
      "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1"}]},
  "List of Boxes"->{
    Cell[55425, 1777, 2371, 53, 132, "DefinitionBox",
      CellTags->{"List of Boxes", "Notation:S2", "Notation:S2.1"}]},
  "Ring Operations"->{
    Cell[58724, 1858, 1130, 31, 42, "Input",
      CellTags->{"Ring Operations", "Notation:S2", "Notation:S2.1"}]},
  "Notation:Documentation:Parentheses"->{
    Cell[66258, 2111, 530, 16, 37, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.2", 
        "Notation:Documentation:Parentheses"}]},
  "Notation:Documentation:Changing Precedences"->{
    Cell[68836, 2203, 1071, 28, 59, "Text",
      CellTags->{
      "Notation:S2", "Notation:S2.3", 
        "Notation:Documentation:Changing Precedences"}]},
  "Notation:Documentation:Options"->{
    Cell[71878, 2300, 755, 22, 53, "Text",
      CellTags->{"Notation:Documentation:Options", "Notation:S3"}]},
  "Notation:Definition:Action"->{
    Cell[72772, 2332, 1690, 45, 112, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:Action", "Notation:S3", "Notation:S3.1"}]},
  "Notation:Definition:WorkingForm"->{
    Cell[83485, 2655, 5614, 151, 112, "DefinitionBox3Col",
      CellTags->{
      "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2"}]},
  "Notation:S4.1"->{
    Cell[104278, 3289, 154, 2, 34, "Subsubsection",
      CellGroupingRules->"NormalGrouping",
      CellTags->{"Notation:S4.1", "Notation:S4"}],
    Cell[104435, 3293, 684, 18, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features"}]},
  "Notation:Documentation:Advanced Features"->{
    Cell[104435, 3293, 684, 18, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.1", 
        "Notation:Documentation:Advanced Features"}]},
  "Notation:Documentation:TagBoxes"->{
    Cell[106296, 3350, 757, 24, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes"}]},
  "Notation:Documentation:NotationBoxTag"->{
    Cell[112532, 3574, 1183, 36, 56, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.3", 
        "Notation:Documentation:NotationBoxTag"}]},
  "Notation:Definition:NotationPatternTag"->{
    Cell[115637, 3685, 1107, 22, 96, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.4", 
        "Notation:Definition:NotationPatternTag"}]},
  "Complex Patterns:testing function"->{
    Cell[118489, 3758, 349, 9, 26, "Input",
      CellTags->{
      "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4"}]},
  "Notation:Definition:NotationMadeBoxesTag"->{
    Cell[123611, 3925, 720, 13, 66, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.5", 
        "Notation:Definition:NotationMadeBoxesTag"}]},
  "Changing precedences and the option SyntaxForm"->{
    Cell[127223, 4028, 968, 34, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm"}]},
  "Notation:Documentation:SyntaxForm"->{
    Cell[127223, 4028, 968, 34, 40, "Text",
      CellTags->{
      "Notation:S4", "Notation:S4.6", 
        "Changing precedences and the option SyntaxForm", 
        "Notation:Documentation:SyntaxForm"}]},
  "Notation:Documentation:Guidelines"->{
    Cell[149662, 4628, 270, 7, 24, "Text",
      CellTags->{"Notation:S5", "Notation:Documentation:Guidelines"}]},
  "Parse without evaluation"->{
    Cell[152286, 4703, 454, 7, 59, "Text",
      CellTags->{
      "Notation:S5", "Notation:S5.4", "Parse without evaluation"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Notation:S1", 215892, 7084},
  {"Notation:S1.1", 224562, 7268},
  {"Notation:S1.2", 228247, 7346},
  {"Notation:S1.3", 230419, 7392},
  {"Notation:S1.4", 232010, 7426},
  {"Notation:S2", 233203, 7453},
  {"Notation:S2.1", 237218, 7538},
  {"Notation:S2.2", 239625, 7588},
  {"Notation:S2.3", 240540, 7608},
  {"Notation:S3", 241184, 7623},
  {"Notation:S3.1", 245942, 7723},
  {"Notation:S3.2", 247928, 7765},
  {"Notation:S3.3", 249335, 7795},
  {"Notation:S3.4", 249964, 7809},
  {"Notation:S4", 250559, 7822},
  {"Notation:S4.2", 257730, 7976},
  {"Notation:S4.3", 259523, 8015},
  {"Notation:S4.4", 260629, 8040},
  {"Notation:S4.5", 262751, 8086},
  {"Notation:S4.6", 263569, 8105},
  {"Notation:S5", 265429, 8145},
  {"Notation:S5.1", 268216, 8206},
  {"Notation:S5.2", 268415, 8211},
  {"Notation:S5.3", 268614, 8216},
  {"Notation:S5.4", 268813, 8221},
  {"Notation:S5.5", 269819, 8243},
  {"Notation:S5.6", 270768, 8265},
  {"Notation:S5.7", 270979, 8270},
  {"Notation:Definition:Notation", 271098, 8273},
  {"Notation:Definition:Symbolize", 271423, 8280},
  {"Must use palette", 271591, 8284},
  {"Notation:Documentation:Entering Notations", 271816, 8289},
  {"Notation:Documentation:Precedence", 272033, 8294},
  {"List of Boxes", 272194, 8298},
  {"Ring Operations", 272340, 8301},
  {"Notation:Documentation:Parentheses", 272498, 8304},
  {"Notation:Documentation:Changing Precedences", 272698, 8309},
  {"Notation:Documentation:Options", 272895, 8314},
  {"Notation:Definition:Action", 273041, 8317},
  {"Notation:Definition:WorkingForm", 273227, 8321},
  {"Notation:S4.1", 273401, 8325},
  {"Notation:Documentation:Advanced Features", 273751, 8333},
  {"Notation:Documentation:TagBoxes", 273946, 8338},
  {"Notation:Documentation:NotationBoxTag", 274129, 8342},
  {"Notation:Definition:NotationPatternTag", 274329, 8347},
  {"Complex Patterns:testing function", 274525, 8352},
  {"Notation:Definition:NotationMadeBoxesTag", 274713, 8356},
  {"Changing precedences and the option SyntaxForm", 274923, 8361},
  {"Notation:Documentation:SyntaxForm", 275172, 8367},
  {"Notation:Documentation:Guidelines", 275421, 8373},
  {"Parse without evaluation", 275568, 8376}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 204, 6, 13, "Section",
  CellGroupingRules->"SectionGrouping"],
Cell[1983, 61, 204, 4, 36, "Text"],
Cell[2190, 67, 86, 1, 36, "Subsection",
  CellTags->"Notation:S1"],
Cell[2279, 70, 62, 1, 34, "Subsubsection",
  CellTags->"Notation:S1.1"],
Cell[2344, 73, 63, 1, 34, "Subsubsection",
  CellTags->"Notation:S1.2"],
Cell[2410, 76, 68, 1, 34, "Subsubsection",
  CellTags->"Notation:S1.3"],
Cell[2481, 79, 72, 1, 34, "Subsubsection",
  CellTags->"Notation:S1.4"],
Cell[2556, 82, 85, 1, 36, "Subsection",
  CellTags->"Notation:S2"],
Cell[2644, 85, 82, 1, 34, "Subsubsection",
  CellTags->"Notation:S2.1"],
Cell[2729, 88, 78, 1, 34, "Subsubsection",
  CellTags->"Notation:S2.2"],
Cell[2810, 91, 87, 1, 34, "Subsubsection",
  CellTags->"Notation:S2.3"],
Cell[2900, 94, 80, 1, 36, "Subsection",
  CellTags->"Notation:S3"],
Cell[2983, 97, 109, 4, 34, "Subsubsection",
  CellTags->"Notation:S3.1"],
Cell[3095, 103, 114, 4, 34, "Subsubsection",
  CellTags->"Notation:S3.2"],
Cell[3212, 109, 167, 6, 34, "Subsubsection",
  CellTags->"Notation:S3.3"],
Cell[3382, 117, 121, 4, 34, "Subsubsection",
  CellTags->"Notation:S3.4"],
Cell[3506, 123, 87, 1, 36, "Subsection",
  CellTags->"Notation:S4"],
Cell[3596, 126, 182, 3, 34, "Subsubsection",
  CellTags->{
  "Notation:S4.2", "Notation:S4.3", "Notation:S4.4", "Notation:S4.5", 
    "Notation:S4.6"}],
Cell[3781, 131, 63, 1, 34, "Subsubsection",
  CellTags->"Notation:S4.2"],
Cell[3847, 134, 114, 4, 34, "Subsubsection",
  CellTags->"Notation:S4.3"],
Cell[3964, 140, 139, 4, 34, "Subsubsection",
  CellTags->"Notation:S4.4"],
Cell[4106, 146, 120, 4, 34, "Subsubsection",
  CellTags->"Notation:S4.5"],
Cell[4229, 152, 173, 6, 34, "Subsubsection",
  CellTags->"Notation:S4.6"],
Cell[4405, 160, 80, 1, 36, "Subsection",
  CellTags->"Notation:S5"],
Cell[4488, 163, 82, 1, 34, "Subsubsection",
  CellTags->"Notation:S5.1"],
Cell[4573, 166, 74, 1, 34, "Subsubsection",
  CellTags->"Notation:S5.2"],
Cell[4650, 169, 96, 1, 34, "Subsubsection",
  CellTags->"Notation:S5.3"],
Cell[4749, 172, 93, 1, 34, "Subsubsection",
  CellTags->"Notation:S5.4"],
Cell[4845, 175, 134, 4, 34, "Subsubsection",
  CellTags->"Notation:S5.5"],
Cell[4982, 181, 88, 1, 34, "Subsubsection",
  CellTags->"Notation:S5.6"],
Cell[5073, 184, 82, 1, 34, "Subsubsection",
  CellTags->"Notation:S5.7"]
}, Closed]],

Cell[CellGroupData[{
Cell[5192, 190, 78, 1, 38, "Section",
  CellGroupingRules->"SectionGrouping"],
Cell[5273, 193, 997, 33, 56, "Text"],
Cell[6273, 228, 729, 15, 56, "Text"],
Cell[7005, 245, 651, 15, 40, "Text"],

Cell[CellGroupData[{
Cell[7681, 264, 63, 0, 36, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[7769, 268, 64, 1, 24, "SubsubsectionIcon",
  CellTags->"Notation:S1"],
Cell[7836, 271, 5231, 155, 124, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.1", "Notation:Definition:Notation"}],
Cell[13070, 428, 97, 1, 17, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[13170, 431, 603, 12, 59, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[13776, 445, 93, 1, 31, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[13872, 448, 136, 3, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[14011, 453, 161, 5, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[14175, 460, 616, 17, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[14794, 479, 346, 12, 30, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{
Cell[15165, 495, 255, 7, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[15423, 504, 345, 10, 32, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],
Cell[15783, 517, 171, 5, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{
Cell[15979, 526, 212, 5, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[16194, 533, 229, 6, 20, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],
Cell[16438, 542, 675, 17, 36, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[17116, 561, 186, 5, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[17305, 568, 633, 17, 41, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[17941, 587, 140, 4, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{
Cell[18106, 595, 304, 8, 41, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[18413, 605, 288, 8, 20, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],
Cell[18716, 616, 228, 5, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[18947, 623, 1317, 38, 80, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[20267, 663, 150, 4, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{
Cell[20442, 671, 447, 14, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[20892, 687, 632, 18, 41, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],
Cell[21539, 708, 184, 4, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[21726, 714, 1244, 36, 80, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[22973, 752, 121, 1, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{
Cell[23119, 757, 410, 11, 46, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[23532, 770, 334, 9, 38, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],
Cell[23881, 782, 237, 6, 22, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[24121, 790, 189, 5, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[24313, 797, 623, 17, 34, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[24939, 816, 154, 4, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[25096, 822, 607, 15, 32, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],

Cell[CellGroupData[{
Cell[25728, 841, 515, 14, 44, "Input",
  CellTags->{"Notation:S1", "Notation:S1.1"}],
Cell[26246, 857, 669, 18, 39, "Output",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Open  ]],
Cell[26930, 878, 394, 7, 37, "Text",
  CellTags->{"Notation:S1", "Notation:S1.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[27361, 890, 65, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S1"],
Cell[27429, 893, 2782, 83, 78, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.2", "Notation:Definition:Symbolize"}],
Cell[30214, 978, 102, 1, 15, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[30319, 981, 360, 7, 37, "Text",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[30682, 990, 230, 5, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[30915, 997, 428, 13, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[31346, 1012, 259, 6, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[CellGroupData[{
Cell[31630, 1022, 424, 14, 26, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[32057, 1038, 276, 8, 32, "Output",
  CellTags->{"Notation:S1", "Notation:S1.2"}]
}, Open  ]],
Cell[32348, 1049, 210, 5, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[32561, 1056, 804, 24, 41, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[33368, 1082, 262, 6, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[CellGroupData[{
Cell[33655, 1092, 575, 16, 41, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[34233, 1110, 136, 3, 20, "Output",
  CellTags->{"Notation:S1", "Notation:S1.2"}]
}, Open  ]],
Cell[34384, 1116, 245, 7, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[34632, 1125, 253, 7, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[34888, 1134, 169, 5, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],

Cell[CellGroupData[{
Cell[35082, 1143, 178, 5, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[35263, 1150, 245, 6, 32, "Output",
  CellTags->{"Notation:S1", "Notation:S1.2"}]
}, Open  ]],
Cell[35523, 1159, 717, 23, 54, "Text",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[36243, 1184, 194, 4, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[36440, 1190, 246, 7, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.2"}],
Cell[36689, 1199, 623, 18, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[37349, 1222, 70, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S1"],
Cell[37422, 1225, 3550, 104, 78, "DefinitionBox",
  CellTags->{
  "Notation:S1", "Notation:S1.3", "Notation:Definition:Notation"}],
Cell[40975, 1331, 103, 1, 15, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[41081, 1334, 577, 15, 54, "Text",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[41661, 1351, 269, 9, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[41933, 1362, 353, 11, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[CellGroupData[{
Cell[42311, 1377, 421, 13, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[42735, 1392, 198, 5, 20, "Output",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Open  ]],
Cell[42948, 1400, 220, 7, 28, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[CellGroupData[{
Cell[43193, 1411, 480, 14, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[43676, 1427, 453, 15, 22, "Output",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Open  ]],
Cell[44144, 1445, 702, 18, 38, "Text",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[44849, 1465, 155, 4, 29, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.3"}],

Cell[CellGroupData[{
Cell[45029, 1473, 428, 11, 27, "Input",
  CellTags->{"Notation:S1", "Notation:S1.3"}],
Cell[45460, 1486, 320, 9, 32, "Output",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Open  ]],
Cell[45795, 1498, 444, 15, 24, "Text",
  CellTags->{"Notation:S1", "Notation:S1.3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[46276, 1518, 74, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S1"],
Cell[46353, 1521, 590, 16, 24, "Text",
  CellTags->{
  "Must use palette", "Notation:Documentation:Entering Notations", 
    "Notation:S1", "Notation:S1.4"}],
Cell[46946, 1539, 3413, 87, 138, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[50362, 1628, 616, 14, 56, "Text",
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[50981, 1644, 120, 1, 30, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[51104, 1647, 406, 11, 26, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[51513, 1660, 362, 9, 15, "Caption",
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[51878, 1671, 1084, 27, 57, "Text",
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[52965, 1700, 143, 4, 30, "MathCaption",
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[53111, 1706, 457, 12, 34, "Input",
  CellTags->{"Notation:S1", "Notation:S1.4"}],
Cell[53571, 1720, 224, 6, 24, "Text",
  CellTags->{"Notation:S1", "Notation:S1.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[53844, 1732, 62, 0, 26, "SubsectionIcon"],

Cell[CellGroupData[{
Cell[53931, 1736, 84, 1, 24, "SubsubsectionIcon",
  CellTags->"Notation:S2"],
Cell[54018, 1739, 1404, 36, 77, "Text",
  CellTags->{
  "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1"}],
Cell[55425, 1777, 2371, 53, 132, "DefinitionBox",
  CellTags->{"List of Boxes", "Notation:S2", "Notation:S2.1"}],
Cell[57799, 1832, 121, 1, 15, "Caption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[57923, 1835, 650, 15, 40, "Text",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[58576, 1852, 145, 4, 30, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[58724, 1858, 1130, 31, 42, "Input",
  CellTags->{"Ring Operations", "Notation:S2", "Notation:S2.1"}],
Cell[59857, 1891, 223, 6, 30, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{
Cell[60105, 1901, 256, 6, 26, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[60364, 1909, 286, 8, 21, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[60687, 1922, 140, 3, 26, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[60830, 1927, 344, 10, 33, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],
Cell[61189, 1940, 542, 14, 41, "Text",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[61734, 1956, 157, 4, 30, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{
Cell[61916, 1964, 360, 11, 26, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[62279, 1977, 318, 8, 21, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],
Cell[62612, 1988, 174, 4, 30, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{
Cell[62811, 1996, 172, 4, 26, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[62986, 2002, 173, 4, 21, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]],
Cell[63174, 2009, 226, 7, 30, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[63403, 2018, 1640, 47, 74, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[65046, 2067, 346, 13, 30, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.1"}],

Cell[CellGroupData[{
Cell[65417, 2084, 365, 8, 26, "Input",
  CellTags->{"Notation:S2", "Notation:S2.1"}],
Cell[65785, 2094, 341, 8, 21, "Output",
  CellTags->{"Notation:S2", "Notation:S2.1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[66175, 2108, 80, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S2"],
Cell[66258, 2111, 530, 16, 37, "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses"}],
Cell[66791, 2129, 124, 1, 28, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2"}],
Cell[66918, 2132, 523, 14, 27, "Input",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[CellGroupData[{
Cell[67466, 2150, 258, 7, 27, "Input",
  CellTags->{"Notation:S2", "Notation:S2.2"}],
Cell[67727, 2159, 273, 8, 32, "Output",
  CellTags->{"Notation:S2", "Notation:S2.2"}]
}, Open  ]],
Cell[68015, 2170, 179, 5, 29, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.2"}],

Cell[CellGroupData[{
Cell[68219, 2179, 187, 5, 26, "Input",
  CellTags->{"Notation:S2", "Notation:S2.2"}],
Cell[68409, 2186, 286, 8, 32, "Output",
  CellTags->{"Notation:S2", "Notation:S2.2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[68744, 2200, 89, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S2"],
Cell[68836, 2203, 1071, 28, 59, "Text",
  CellTags->{
  "Notation:S2", "Notation:S2.3", 
    "Notation:Documentation:Changing Precedences"}],
Cell[69910, 2233, 249, 6, 31, "MathCaption",
  CellTags->{"Notation:S2", "Notation:S2.3"}],

Cell[CellGroupData[{
Cell[70184, 2243, 337, 10, 28, "Input",
  CellTags->{"Notation:S2", "Notation:S2.3"}],
Cell[70524, 2255, 529, 13, 23, "Output",
  CellTags->{"Notation:S2", "Notation:S2.3"}]
}, Open  ]],
Cell[71068, 2271, 701, 21, 42, "Text",
  CellTags->{"Notation:S2", "Notation:S2.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[71818, 2298, 57, 0, 26, "SubsectionIcon"],
Cell[71878, 2300, 755, 22, 53, "Text",
  CellTags->{"Notation:Documentation:Options", "Notation:S3"}],

Cell[CellGroupData[{
Cell[72658, 2326, 111, 4, 24, "SubsubsectionIcon",
  CellTags->"Notation:S3"],
Cell[72772, 2332, 1690, 45, 112, "DefinitionBox3Col",
  CellTags->{"Notation:Definition:Action", "Notation:S3", "Notation:S3.1"}],
Cell[74465, 2379, 152, 5, 15, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[74620, 2386, 512, 17, 38, "Text",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[75135, 2405, 175, 4, 28, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[75313, 2411, 849, 22, 42, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[76165, 2435, 110, 1, 28, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[CellGroupData[{
Cell[76300, 2440, 223, 6, 30, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[76526, 2448, 360, 11, 24, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1"}]
}, Open  ]],
Cell[76901, 2462, 524, 16, 38, "Text",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[77428, 2480, 117, 1, 28, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[77548, 2483, 849, 22, 42, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[78400, 2507, 132, 2, 28, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[CellGroupData[{
Cell[78557, 2513, 223, 6, 30, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[78783, 2521, 224, 6, 22, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1"}]
}, Open  ]],
Cell[79022, 2530, 463, 13, 38, "Text",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[79488, 2545, 256, 9, 29, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.1"}],

Cell[CellGroupData[{
Cell[79769, 2558, 848, 22, 42, "Input",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[80620, 2582, 1123, 26, 50, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1"}],
Cell[81746, 2610, 1571, 33, 50, "Output",
  CellTags->{"Notation:S3", "Notation:S3.1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[83366, 2649, 116, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S3"],
Cell[83485, 2655, 5614, 151, 112, "DefinitionBox3Col",
  CellTags->{
  "Notation:Definition:WorkingForm", "Notation:S3", "Notation:S3.2"}],
Cell[89102, 2808, 165, 5, 15, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[89270, 2815, 890, 33, 54, "Text",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[90163, 2850, 577, 21, 38, "Text",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[90743, 2873, 303, 11, 29, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[91049, 2886, 1943, 51, 65, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[92995, 2939, 104, 1, 28, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.2"}],

Cell[CellGroupData[{
Cell[93124, 2944, 298, 8, 29, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[93425, 2954, 257, 7, 35, "Output",
  CellTags->{"Notation:S3", "Notation:S3.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[93719, 2966, 140, 3, 26, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[93862, 2971, 269, 8, 32, "Output",
  CellTags->{"Notation:S3", "Notation:S3.2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[94168, 2984, 643, 17, 32, "Input",
  CellTags->{"Notation:S3", "Notation:S3.2"}],
Cell[94814, 3003, 464, 12, 20, "Output",
  CellTags->{"Notation:S3", "Notation:S3.2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[95327, 3021, 128, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S3"],
Cell[95458, 3027, 4567, 127, 94, "DefinitionBox3Col",
  CellTags->{"Notation:S3", "Notation:S3.3"}],
Cell[100028, 3156, 117, 1, 15, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.3"}],
Cell[100148, 3159, 1094, 29, 69, "text",
  CellTags->{"Notation:S3", "Notation:S3.3"}],
Cell[101245, 3190, 215, 6, 30, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.3"}],
Cell[101463, 3198, 183, 5, 26, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S3", "Notation:S3.3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[101683, 3208, 123, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S3"],
Cell[101809, 3214, 1468, 41, 39, "DefinitionBox",
  CellTags->{"Notation:S3", "Notation:S3.4"}],
Cell[103280, 3257, 91, 1, 15, "Caption",
  CellTags->{"Notation:S3", "Notation:S3.4"}],
Cell[103374, 3260, 522, 13, 53, "Text",
  CellTags->{"Notation:S3", "Notation:S3.4"}],
Cell[103899, 3275, 124, 1, 28, "MathCaption",
  CellTags->{"Notation:S3", "Notation:S3.4"}],
Cell[104026, 3278, 136, 3, 26, "Input",
  CellTags->{"Notation:S3", "Notation:S3.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[104211, 3287, 64, 0, 26, "SubsectionIcon"],
Cell[104278, 3289, 154, 2, 34, "Subsubsection",
  CellGroupingRules->"NormalGrouping",
  CellTags->{"Notation:S4.1", "Notation:S4"}],
Cell[104435, 3293, 684, 18, 40, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.1", 
    "Notation:Documentation:Advanced Features"}],
Cell[105122, 3313, 1081, 30, 56, "Text"],

Cell[CellGroupData[{
Cell[106228, 3347, 65, 1, 24, "SubsubsectionIcon",
  CellTags->"Notation:S4"],
Cell[106296, 3350, 757, 24, 40, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.2", "Notation:Documentation:TagBoxes"}],
Cell[107056, 3376, 147, 5, 28, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[107206, 3383, 873, 24, 56, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[108082, 3409, 301, 8, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[108386, 3419, 206, 8, 25, "Input"],
Cell[108595, 3429, 937, 27, 56, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[109535, 3458, 220, 7, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[CellGroupData[{
Cell[109780, 3469, 150, 5, 28, "Input",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[109933, 3476, 159, 4, 23, "Output",
  CellTags->{"Notation:S4", "Notation:S4.2"}]
}, Open  ]],
Cell[110107, 3483, 397, 11, 40, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[110507, 3496, 357, 12, 46, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[110867, 3510, 346, 9, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[111216, 3521, 261, 8, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.2"}],

Cell[CellGroupData[{
Cell[111502, 3533, 159, 5, 28, "Input",
  CellTags->{"Notation:S4", "Notation:S4.2"}],
Cell[111664, 3540, 185, 4, 21, "Output",
  CellTags->{"Notation:S4", "Notation:S4.2"}]
}, Open  ]],
Cell[111864, 3547, 512, 16, 40, "Text",
  CellTags->{"Notation:S4", "Notation:S4.2"}]
}, Closed]],

Cell[CellGroupData[{
Cell[112413, 3568, 116, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S4"],
Cell[112532, 3574, 1183, 36, 56, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.3", "Notation:Documentation:NotationBoxTag"}],
Cell[113718, 3612, 169, 5, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[CellGroupData[{
Cell[113912, 3621, 243, 7, 28, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[114158, 3630, 336, 9, 33, "Output",
  CellTags->{"Notation:S4", "Notation:S4.3"}]
}, Open  ]],
Cell[114509, 3642, 205, 6, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[114717, 3650, 307, 7, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],

Cell[CellGroupData[{
Cell[115049, 3661, 159, 4, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.3"}],
Cell[115211, 3667, 233, 6, 33, "Output",
  CellTags->{"Notation:S4", "Notation:S4.3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[115493, 3679, 141, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S4"],
Cell[115637, 3685, 1107, 22, 96, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.4", "Notation:Definition:NotationPatternTag"}],
Cell[116747, 3709, 186, 5, 29, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[116936, 3716, 996, 25, 28, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[117935, 3743, 391, 7, 36, "Text",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[118329, 3752, 157, 4, 28, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[118489, 3758, 349, 9, 26, "Input",
  CellTags->{
  "Complex Patterns:testing function", "Notation:S4", "Notation:S4.4"}],
Cell[118841, 3769, 162, 4, 28, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[CellGroupData[{
Cell[119028, 3777, 249, 6, 27, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[119280, 3785, 202, 5, 20, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Open  ]],
Cell[119497, 3793, 171, 4, 28, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[CellGroupData[{
Cell[119693, 3801, 249, 7, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[119945, 3810, 280, 8, 32, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Open  ]],
Cell[120240, 3821, 341, 8, 23, "Text",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[120584, 3831, 240, 7, 29, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.4"}],

Cell[CellGroupData[{
Cell[120849, 3842, 994, 25, 28, "Input",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[121846, 3869, 655, 16, 35, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4"}],
Cell[122504, 3887, 604, 15, 35, "Output",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Open  ]],
Cell[123123, 3905, 326, 9, 37, "Text",
  CellTags->{"Notation:S4", "Notation:S4.4"}]
}, Closed]],

Cell[CellGroupData[{
Cell[123486, 3919, 122, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S4"],
Cell[123611, 3925, 720, 13, 66, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.5", 
    "Notation:Definition:NotationMadeBoxesTag"}],
Cell[124334, 3940, 196, 5, 29, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.5"}],

Cell[CellGroupData[{
Cell[124555, 3949, 1179, 30, 42, "Input",
  CellTags->{"Notation:S4", "Notation:S4.5"}],
Cell[125737, 3981, 937, 23, 35, "Output",
  CellTags->{"Notation:S4", "Notation:S4.5"}]
}, Open  ]],
Cell[126689, 4007, 319, 8, 38, "Text",
  CellTags->{"Notation:S4", "Notation:S4.5"}]
}, Closed]],

Cell[CellGroupData[{
Cell[127045, 4020, 175, 6, 20, "SubsubsectionIcon",
  CellTags->"Notation:S4"],
Cell[127223, 4028, 968, 34, 40, "Text",
  CellTags->{
  "Notation:S4", "Notation:S4.6", 
    "Changing precedences and the option SyntaxForm", 
    "Notation:Documentation:SyntaxForm"}],
Cell[128194, 4064, 162, 4, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[CellGroupData[{
Cell[128381, 4072, 224, 6, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[128608, 4080, 349, 10, 33, "Output",
  CellTags->{"Notation:S4", "Notation:S4.6"}]
}, Open  ]],
Cell[128972, 4093, 232, 5, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[129207, 4100, 601, 17, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[129811, 4119, 115, 1, 30, "MathCaption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],

Cell[CellGroupData[{
Cell[129951, 4124, 328, 9, 26, "Input",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[130282, 4135, 349, 10, 33, "Output",
  CellTags->{"Notation:S4", "Notation:S4.6"}]
}, Open  ]],
Cell[130646, 4148, 163, 4, 24, "Text",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[130812, 4154, 10803, 233, 107, "OptionBox3Col",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[141618, 4389, 187, 4, 15, "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[141808, 4395, 642, 16, 56, "Text",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[142453, 4413, 6920, 200, 184, "DefinitionBox",
  CellTags->{"Notation:S4", "Notation:S4.6"}],
Cell[149376, 4615, 177, 5, 15, "Caption",
  CellTags->{"Notation:S4", "Notation:S4.6"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[149602, 4626, 57, 0, 26, "SubsectionIcon"],
Cell[149662, 4628, 270, 7, 24, "Text",
  CellTags->{"Notation:S5", "Notation:Documentation:Guidelines"}],

Cell[CellGroupData[{
Cell[149957, 4639, 84, 1, 24, "SubsubsectionIcon",
  CellTags->"Notation:S5"],
Cell[150044, 4642, 621, 14, 50, "Text",
  CellTags->{"Notation:S5", "Notation:S5.1"}]
}, Closed]],

Cell[CellGroupData[{
Cell[150702, 4661, 76, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S5"],
Cell[150781, 4664, 506, 10, 52, "Text",
  CellTags->{"Notation:S5", "Notation:S5.2"}]
}, Closed]],

Cell[CellGroupData[{
Cell[151324, 4679, 98, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S5"],
Cell[151425, 4682, 726, 13, 56, "Text",
  CellTags->{"Notation:S5", "Notation:S5.3"}]
}, Closed]],

Cell[CellGroupData[{
Cell[152188, 4700, 95, 1, 20, "SubsubsectionIcon",
  CellTags->"Notation:S5"],
Cell[152286, 4703, 454, 7, 59, "Text",
  CellTags->{"Notation:S5", "Notation:S5.4", "Parse without evaluation"}],
Cell[152743, 4712, 161, 4, 31, "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4"}],
Cell[152907, 4718, 491, 13, 30, "Input",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[CellGroupData[{
Cell[153423, 4735, 195, 5, 29, "Input",
  CellTags->{"Notation:S5", "Notation:S5.4"}],
Cell[153621, 4742, 271, 8, 37, "Output",
  CellTags->{"Notation:S5", "Notation:S5.4"}]
}, Open  ]],
Cell[153907, 4753, 399, 10, 42, "Text",
  CellTags->{"Notation:S5", "Notation:S5.4"}],
Cell[154309, 4765, 366, 8, 31, "MathCaption",
  CellTags->{"Notation:S5", "Notation:S5.4"}],

Cell[CellGroupData[{
Cell[154700, 4777, 267, 7, 30, "Input",
  CellTags->{"Notation:S5", "Notation:S5.4"}],
Cell[154970, 4786, 71, 1, 23, "Print"],
Cell[155044, 4789, 224, 5, 25, "Output",
  CellTags->{"Notation:S5", "Notation:S5.4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[155317, 4800, 136, 4, 20, "SubsubsectionIcon",
  CellTags->"Notation:S5"],
Cell[155456, 4806, 543, 16, 40, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[156002, 4824, 786, 20, 44, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[156791, 4846, 260, 10, 24, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[157054, 4858, 2508, 86, 27, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[159565, 4946, 714, 24, 40, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[160282, 4972, 1187, 42, 40, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[161472, 5016, 504, 13, 40, "Text",
  CellTags->{"Notation:S5", "Notation:S5.5"}],
Cell[161979, 5031, 926, 30, 146, "Input",
  Evaluatable->False,
  CellTags->{"Notation:S5", "Notation:S5.5"}]
}, Closed]],
Cell[162920, 5064, 121, 1, 20, "SubsubsectionIcon",
  CellTags->{"Notation:S5", "Notation:S5.6"}]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

