(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    382472,       8827]*)
(*NotebookOutlinePosition[    426575,      10321]*)
(*  CellTagsIndexPosition[    426531,      10317]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Notation.m\n",
  StyleBox["A package for defining new notations",
    FontWeight->"Plain"]
}], "Title"],

Cell[TextData[StyleBox["\[Copyright]1996-2003 Jason Harris",
  FontWeight->"Plain"]], "Subsubtitle",
  PageWidth->WindowWidth,
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],

Cell["Notation Source Code", "Text",
  PageWidth->WindowWidth,
  ShowClosedCellArea->True,
  CellMargins->{{12, Inherited}, {20, 40}},
  PageBreakAbove->True,
  PageBreakBelow->False,
  CellFrameLabels->{{Inherited, None}, {None, None}},
  FontFamily->"Helvetica",
  FontSize->30,
  FontWeight->"Bold",
  FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell["Package Beginnings", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["Package Begin", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(BeginPackage\ [\ "\<Utilities`Notation`\>"\ ];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(Unprotect\ @\ \ "\<Utilities`Notation`*\>";\)\), \
"\[IndentingNewLine]", 
    \(\(ClearAll\  @@ \ 
        Complement[
          Names\ @\ "\<Utilities`Notation`*\>", \
{"\<AutoLoadNotationPalette\>", "\<AutoUpdateNotationStyleSheet\>", \
"\<$NotationDebug\>"}];\)\), "\[IndentingNewLine]", 
    \(\(ClearAll\ @\ "\<Utilities`Notation`Private`*\>";\)\)}], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  "Print a release number for the ",
  StyleBox["Notation", "MR"],
  " package."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(If[
        Utilities`Notation`$NotationDebug, \[IndentingNewLine]CellPrint\ @\ 
          Cell[TextData\ @\ 
              StyleBox["\<Notation Release 1.4.3.2 March 15, 2001\>", \
"\<Message\>", FontWeight \[Rule] "\<Bold\>"], "\<Output\>"]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(If[$VersionNumber \[LessEqual] 3.9999, \ 
      CellPrint\ @\ 
        Cell[TextData[
            StyleBox["\<You are using an older version of Mathematica than \
this version of the Notation package was designed for. Please obtain an \
earlier version of the Notation package from Wolfram Research.\>", \ \
"\<Message\>", FontWeight -> "\<Bold\>"]], \ "\<Output\>"]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Force the symbol '",
  StyleBox["Notation", "MR"],
  "' to be in the context ",
  StyleBox["Utilities`Notation`", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(Utilities`Notation`Notation;\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Post Begin", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(Begin\ @\ "\<`Private`\>";\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Cache the input notebook", "NumberedSubsubsubtitle"],

Cell["\<\
Cache the input notebook because it can change during the loading \
of this package.\
\>", "Text"],

Cell[BoxData[
    \(\(\[ScriptI]\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]\  = \ 
        InputNotebook[];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["friendlyOff", "MR"],
  " and ",
  StyleBox["friendlyOn", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["friendlyOff", "MR"],
  " will turn off a message. ",
  StyleBox["friendlyOn", "MR"],
  " will turn that message on only if it was on before the ",
  StyleBox["friendlyOff", "MR"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(SetAttributes[{friendlyOff, \ friendlyOn, \ messageStatus}, 
        HoldAll];\)\), "\[IndentingNewLine]", 
    \(\(messageStatus\ @\ 
          MessageName[\[ScriptF]\[ScriptU]\[ScriptN]\[ScriptC]_, \[ScriptM]\
\[ScriptE]\[ScriptS]\[ScriptG]_String]\  := \[IndentingNewLine]If[\ 
          Head\ [\ 
              MessageName[\[ScriptF]\[ScriptU]\[ScriptN]\[ScriptC], \
\[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]]\  /. 
                Messages\ @\ \[ScriptF]\[ScriptU]\[ScriptN]\[ScriptC]]\ \  \
=!= \ $Off, $On, $Off, $Off];\)\), "\[IndentingNewLine]", 
    \(\(friendlyOff\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]_MessageName\ \
 := \ \((mesgWasOn\ @\ \(Hold\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]\)\ \
 = \ \((messageStatus\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]\  =!= \ \
$Off)\); Off\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG];)\);\)\), "\
\[IndentingNewLine]", 
    \(\(friendlyOn\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]_MessageName\ \
\  := \ If[
          mesgWasOn\ @\ \(Hold\ @\ \
\[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]\), \ 
          On\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]; 
          mesgWasOn\ @\ \(Hold\ @\ \[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG]\)\
\  = \ False;];\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["silentEvaluate", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["silentEvaluate", "MR"],
  " will evaluate an expression, but report NO error messages, I.e. it will \
silently evaluate an expression giving a result."
}], "Text"],

Cell[BoxData[{
    \(\(SetAttributes[silentEvaluate, HoldAll];\)\), "\[IndentingNewLine]", 
    \(\(silentEvaluate\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_\  := 
        Block[{Message}, 
          SetAttributes[Message, 
            HoldFirst]; \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]];\)\)}], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Remove the Notation symbol from the system context.", \
"Text"]], "NumberedSubsubsubtitle"],

Cell[TextData[StyleBox["WRI still has not got around to removing the Notation \
symbol from the system context. It is not being used for anything. Remove it \
from the system.", "Text"]], "Text"],

Cell[BoxData[{
    \(\(silentEvaluate\ @\ \(Unprotect\ @\ "\<System`Notation\>"\);\)\), "\
\[IndentingNewLine]", 
    \(\(silentEvaluate\ @\ \(Remove\ @\ "\<System`Notation\>"\);\)\)}], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Hanlde overloaded symbols", "Text"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[StyleBox["If any of the vital symbols used by Notation are \
being used in the global context then warn the user and remove them from the \
global context.", "Text"]], "Text"],

Cell[BoxData[
    \(\(notationsPublicFunctions = \[IndentingNewLine]\(("\<Global`\>"\  <> \ \
# &)\)\  /@ {\[IndentingNewLine]"\<Action\>", "\<ClearNotations\>", \
"\<CreateNotationRules\>", "\<InfixNotation\>", "\<NotationBoxTag\>", \
"\<NotationPatternTag\>", "\<PrintNotationRules\>", \
"\<RemoveInfixNotation\>", "\<RemoveNotation\>", "\<RemoveNotationRules\>", "\
\<RemoveSymbolize\>", "\<Notation\>", "\<Symbolize\>", \
"\<SymbolizeRootName\>", "\<WorkingForm\>"};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::gshadw\  = \ "\<The symbol '`1`' has been used in the \
global context. The Notation package needs the full use of the symbol '`1`' \
and has therefore removed this symbol from the global context.\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(With[{overideNames = 
          Intersection[Names\ @\ "\<Global`*\>"\ , 
            notationsPublicFunctions]}, \[IndentingNewLine]If[
        overideNames =!= {}, \[IndentingNewLine]\(\((Message[
                Notation::gshadw, #])\) &\)\  /@ \ \(\((StringDrop[#, 
                  7] &)\) /@ \ 
            overideNames\); \[IndentingNewLine]Unprotect\  /@ \ 
          overideNames; \[IndentingNewLine]ClearAll\  /@ \ 
          overideNames; \[IndentingNewLine]Remove\  /@ \ 
          overideNames;]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["$NewVersion", "Text"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["$NewVersion is a boolean variable representing a new version of \
the Notation package suitable for ", "Text"],
  StyleBox["Mathematica", "Text",
    FontSlant->"Italic"],
  StyleBox[" 4.0 and grater.", "Text"]
}], "Text"],

Cell[BoxData[
    \(\($NewVersion\  = \ \(($VersionNumber > 3.1)\);\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["End \"`Private`\"", "MR"]], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(End[];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Usage Statements", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(Symbolize::usage\  = \n\t"\<Symbolize[\[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]] forces any box structure matching \[ScriptB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS] to be treated internally as a single symbol \
anywhere it appears in an input expression.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True],

Cell[BoxData[
    \(\(RemoveSymbolize::usage\  = \n\t\
"\<RemoveSymbolize[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]] \
removes the symbolization of \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS].\>";\)\)], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True],

Cell[BoxData[
    \(\(SymbolizeRootName::usage\  := \n\t"\<SymbolizeRootName is an option \
for Symbolize specifying the name to be used internally for the symbolized \
boxes.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(InfixNotation::usage\  = \n\t"\<InfixNotation[\[ScriptI]\[ScriptN]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP], \[ScriptP]\
\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\
\[ScriptA]\[ScriptD]] forces the box structure \[ScriptI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP] to be treated as an infix \
operator representing the function \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] in input \
and output.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(RemoveInfixNotation::usage\  = \n\t"\<RemoveInfixNotation[\[ScriptI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP], \
\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\
\[ScriptE]\[ScriptA]\[ScriptD]] removes the infix operator \[ScriptI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP]\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::usage\  = \n"\<Notation[\[ScriptCapitalE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] \[DoubleLongLeftRightArrow] \
\[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalE]\[ScriptX]\[ScriptP]\[ScriptR]] parses any input \
box structure \[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS] internally as \[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\[ScriptX]\[ScriptP]\
\[ScriptR], and formats any expression matching \[ScriptCapitalI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\
\[ScriptX]\[ScriptP]\[ScriptR] as \[ScriptCapitalE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS] in output. To restrict Notation to only \
parsing, use Notation[\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS] \[DoubleLongRightArrow] \[ScriptCapitalI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\
\[ScriptX]\[ScriptP]\[ScriptR]], and to restrict Notation to only formatting, \
use Notation[\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS] \[DoubleLongLeftArrow] \[ScriptCapitalI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\[ScriptX]\
\[ScriptP]\[ScriptR]].\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(RemoveNotation::usage\  = \n"\<RemoveNotation[\[ScriptCapitalE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] \
\[DoubleLongLeftRightArrow] \[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\[ScriptX]\[ScriptP]\
\[ScriptR]] removes the notation \[ScriptCapitalE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM] \[DoubleLongLeftRightArrow] \[ScriptCapitalI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]. To remove only the parsing, use \
RemoveNotation[\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS] \[DoubleLongRightArrow] \[ScriptCapitalI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\[ScriptX]\
\[ScriptP]\[ScriptR]], and to remove only the formatting, use RemoveNotation[\
\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] \
\[DoubleLongLeftArrow] \[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\[ScriptX]\[ScriptP]\
\[ScriptR]].\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NotationBoxTag::usage\t = \n"\<NotationBoxTag is a TagBox tag that is \
embedded in Notation, Symbolize and InfixNotation statements.  The embedded \
TagBox ensures correct parsing and retention of proper styling and grouping \
information.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NotationPatternTag::usage\t = \n"\<NotationPatternTag is a TagBox tag \
which can be embedded in Notation, Symbolize and InfixNotation statements. \
When used, this tag indicates that the expression inside of the \
NotationPatternTag structure represents a complex pattern and not a box \
structure. It will still be processed by MakeBoxes or \
MakeExpression.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NotationMadeBoxesTag::usage\t = \n"\<NotationMadeBoxesTag is a TagBox \
tag which can be embedded in Notation, Symbolize and InfixNotation \
statements. When used, this tag indicates that the expression inside of the \
NotationMadeBoxesTag structure represents a made box expression or literal \
expression. It will not be processed by MakeBoxes.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(ClearNotations::usage\  = \n"\<ClearNotations[] will remove all \
\"notations\" , \"symbolizations\" and \"infix notations\". It does not \
destroy any rules for MakeExpression and MakeBoxes. This function will reset \
the notation handling to a pristine state.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(WorkingForm::usage\  = \n\t"\<WorkingForm is an option of Notation, \
Symbolize and InfixNotation, which specifies which form the notation will be \
defined in. Possible forms include StandardForm, TraditionalForm, user \
defined forms, and Automatic which defaults to the default output format \
type.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Action::usage\  = \n\t"\<Action is an option of Notation, Symbolize \
and InfixNotation. It defines what action will be performed with the given \
notation statement. The possible values are CreateNotationRules, \
PrintNotationRules and RemoveNotationRules\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(CreateNotationRules::usage\  = \n\t"\<CreateNotationRules is a \
possible value for the option Action which is used in Notation, Symbolize and \
InfixNotation. If the option Action is set to CreateNotationRules, then a \
notation statement will enter the given notation into the system.\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(RemoveNotationRules::usage\  = \n\t"\<RemoveNotationRules is a \
possible value for the option Action which is used in Notation, Symbolize and \
InfixNotation. If the option Action is set to RemoveNotationRules, then a \
notation statement will remove the given notation from the system.\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(PrintNotationRules::usage\  = \n\t"\<PrintNotationRules is a possible \
value for the option Action which is used in Notation, Symbolize and \
InfixNotation. If the option Action is set to PrintNotationRules, then a \
notation statement will print out a cell containing the rules defining the \
given notation.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AutoLoadNotationPalette::usage\  = \n\t"\<AutoLoadNotationPalette is \
a boolean variable. If False then the Notation palette will not be loaded \
when the Notation package is loaded. If the value is undefined or True the \
Notation palette will be loaded when the Notation package loads. Other \
package designers can set this variable outside of the Notation package \
through a statement similar to Utilities`Notation`AutoLoadNotationPalette = \
False.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NotationMakeExpression::usage\  = \n\t"\<NotationMakeExpression is a \
private version of MakeExpression. The Notation package uses \
NotationMakeExpression in an attempt to minimally interfere with other \
functions that use MakeExpression.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(NotationMakeBoxes::usage\  = \n\t"\<NotationMakeBoxes is a private \
version of MakeBoxes. The Notation package uses NotationMakeBoxes in an \
attempt to minimally interfere with other functions that use MakeBoxes.\>";\)\
\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AutoUpdateNotationStyleSheet::usage\  = \n\t\
"\<AutoUpdateNotationStyleSheet is a boolean variable. If False then the \
current notebook style sheet will not be updated to the latest styles when \
the Notation package is loaded. If the value is undefined or True the style \
sheet will be updated when the Notation package loads. Other package \
designers can set this variable outside of the Notation package by \
Utilities`Notation`AutoUpdateNotationStyleSheet = False.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(UpdateNotationsInNotebook::usage\  = \n\t\
"\<UpdateNotationsInNotebook[] is a function that will update all Notations, \
InfixNotations, and Symbolizations in your current notebook to visually \
conform to the styles made available with the latest release of Mathematica. \
Note: UpdateNotationsInNotebook only changes visual styles and Notebooks with \
old notation templates will still function correctly. This function \
intensively uses front end memory for large notebooks, so you may need to \
increase this if the command fails at first. UpdateNotationsInNotebook[\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]] will update the notations in the notebook \[ScriptN]\[ScriptO]\
\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK].\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(UpdateNotebookStyles::usage\  = \n\t"\<UpdateNotebookStyles[] is a \
function that will add the styles the notation package defines to your \
current notebook. These styles are desirable since they change the visual \
appearance of notation statements. It will also add the input aliases the \
Notation package uses. Note: however your notebooks will still run without \
the addition of these styles.
		UpdateNotebookStyles[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]] will update the style sheet of the notebook \
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK].\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::usage\  = \n\t"\<AddInputAlias[\[ScriptF]\[ScriptU]\
\[ScriptL]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS],\
\[ScriptS]\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]] adds the alias \[EscapeKey]\[ScriptS]\[ScriptH]\
\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[EscapeKey] for \[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] to the aliases in the curret \
notebook. AddInputAlias[\[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS],\[ScriptS]\[ScriptH]\
\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM],\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]] adds the alias to the notebook \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK].\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(ActiveInputAliases::usage\  = \n\t"\<ActiveInputAliases[] returns a \
list of all active aliases in the current notebook. ActiveInputAliases[\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]] returns a list of all active aliases in the notebook \[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK].\>";\)\
\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\($NotationVersion::usage\  = \n\t"\<$NotationVersion is a string that \
represents the version of the Notation package you are running.\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\($NotationVersion = "\<1.4.3.3 for all platforms running Mathematica \
4.1 and 4.2(March 15, 2002)\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell["Error Message Declarations", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["Options for  Notation, Symbolize and InfixNotation", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Define the options for ",
  StyleBox["Notation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(\(\ \)\(Options\ @\ 
          Notation\  = \ {\[IndentingNewLine]WorkingForm\  \[Rule] \ 
            Automatic, \[IndentingNewLine]Action\  \[Rule] \ 
            CreateNotationRules};\)\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Define the options for ",
  StyleBox["Symbolize", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(Options\ @\ 
          Symbolize\  = \ {\[IndentingNewLine]WorkingForm\  \[Rule] \ 
            Automatic, \[IndentingNewLine]Action\  \[Rule] \ 
            CreateNotationRules, \[IndentingNewLine]SymbolizeRootName\  \
\[Rule] \ "\<\>"};\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Define the options for ",
  StyleBox["InfixNotation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(Options\ @\ 
          InfixNotation\  = \ {\[IndentingNewLine]WorkingForm\  \[Rule] \ 
            Automatic, \[IndentingNewLine]Action\  \[Rule] \ 
            CreateNotationRules};\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Begin Private", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(Begin\ @\ "\<`Private`\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["adjustedOptions", "NumberedSubsubtitle"],

Cell["\<\
By profiling, I can confirm that this is taking a substantial \
amount of time to run.\
\>", "JasonComment"],

Cell[TextData[{
  StyleBox["adjustedOptions", "MR"],
  " returns the normal options for a function but substitutes on the fly ",
  StyleBox["WorkingForm", "MR"],
  " \[Rule] ",
  StyleBox["Automatic", "MR"],
  " to WorkingForm \[Rule] ",
  StyleBox["Default Output FormatType", "MR",
    FontSlant->"Italic"],
  ". Cache the result since ",
  StyleBox["AbsoluteOptions", "MR"],
  " takes so long to execute."
}], "Text"],

Cell[BoxData[
    \(adjustedOptions\ @\ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_\  := \ \
\(adjustedOptions\ @\ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\  = \
\[IndentingNewLine]Options\ @\ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\  /. \
\((HoldPattern\ @\ \((Rule | RuleDelayed)\)[WorkingForm, 
                  Automatic])\)\  \[Rule] \[IndentingNewLine]\((\ 
              WorkingForm\  \[RuleDelayed] "\<Output\>" \
/. \[IndentingNewLine]\((CommonDefaultFormatTypes\  /. \ 
                    AbsoluteOptions[$FrontEnd, \ 
                      CommonDefaultFormatTypes])\))\)\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General Error Handling", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["General error routines", "NumberedSubsubtitle"],

Cell[TextData[{
  "Here are some basic functions which the error handling routines use. \n",
  StyleBox["heldLength", "MR"],
  " just gives the length of an expression without evaluating anything.\n",
  StyleBox["isNot", "MR"],
  " will return ",
  StyleBox["True", "MR"],
  " for anything that does not match the pattern.\n",
  StyleBox["headIsNot", "MR"],
  " will return ",
  StyleBox["True", "MR"],
  " for anything whose head does not match the pattern"
}], "Text"],

Cell[BoxData[{
    \(\(SetAttributes[{heldLength, headIsNot, isNot}, 
        HoldAll];\)\), "\[IndentingNewLine]", 
    \(\(heldLength\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_\ \  := \ 
        Length\ @\ \(Unevaluated\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\);\)\), "\[IndentingNewLine]", 
    \(\(isNot\ @\ \
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]_\ \ \ \
\ \  := \ Function[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \[Not] MatchQ[
              Unevaluated\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]], \ 
          HoldAll];\)\), "\[IndentingNewLine]", 
    \(\(headIsNot\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]_\  := \ 
        Function[\[ScriptT]\[ScriptE]\[ScriptS]\[ScriptT]\[ScriptCapitalH]\
\[ScriptE]\[ScriptA]\[ScriptD], \[Not] MatchQ[
              Head\ @\ \(Unevaluated\ @\ \[ScriptT]\[ScriptE]\[ScriptS]\
\[ScriptT]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]\), \[ScriptP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]], \ 
          HoldAll];\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(General::badarg\  = "\<`1` expected at position `2` in `3`\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(characterQ\ @\ \[ScriptA]_String\  := \ 
        StringLength\ @\ \[ScriptA]\  == \ 1;\)\), "\[IndentingNewLine]", 
    \(\(characterQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]___\ \
\  := \ False;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Frames shaded  by depth", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["structuralBoxes", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["structuralBoxes", "Input"],
  " matches boxes which are structural in nature and affect the parsing of \
expressions."
}], "Text"],

Cell[BoxData[
    \(\(structuralBoxes\  = \((\[IndentingNewLine]FractionBox\  | \
\[IndentingNewLine]GridBox\  | \[IndentingNewLine]InterpretationBox\  | \
\[IndentingNewLine]RadicalBox\  | \[IndentingNewLine]RowBox\  | \
\[IndentingNewLine]SqrtBox\  | \[IndentingNewLine]SubscriptBox\  | \
\[IndentingNewLine]SuperscriptBox\  | \[IndentingNewLine]SubsuperscriptBox\  \
| \[IndentingNewLine]TagBox\  | \[IndentingNewLine]UnderscriptBox\  | \
\[IndentingNewLine]OverscriptBox\  | \
\[IndentingNewLine]UnderoverscriptBox)\);\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["colorizeStructuralBoxes", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["colorizeStructuralBoxes", "MR"],
  " will shade the background of a box structure according to its structure. \
In this way the user can visually observe the structure of an expression."
}], "Text"],

Cell[BoxData[{
    \(\(\(colorizeStructuralBoxes[\((\[ScriptA] : \ 
              structuralBoxes)\)[\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]__], \
\[ScriptD]\[ScriptE]\[ScriptP]\[ScriptT]\[ScriptH]_] := \[IndentingNewLine]\(\
\(StyleBox[#, \ Background \[Rule] 
                  Hue[0, 1 - 
                      E\^\(\(-0.1579\)\ \[ScriptD]\[ScriptE]\[ScriptP]\
\[ScriptT]\[ScriptH]\), 1], \ 
                FontColor \[Rule] 
                  Hue[0, 1 - 
                      E\^\(\(-0.1579\)\ \[ScriptD]\[ScriptE]\[ScriptP]\
\[ScriptT]\[ScriptH]\), 1]] &\)\ @\[IndentingNewLine]\(FrameBox\ @\ 
              StyleBox[#, \ 
                FontColor \[Rule] 
                  RGBColor[0, 0, 
                    0]]\) &\)\ @\[IndentingNewLine]\((\[ScriptA]\  @@ \ \
\((\(colorizeStructuralBoxes[#, \[ScriptD]\[ScriptE]\[ScriptP]\[ScriptT]\
\[ScriptH] + 
                      1] &\)\  /@ \ \
{\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]})\))\)\)\(\n\)
    \)\), "\n", 
    \(\(colorizeStructuralBoxes[\[ScriptA]_[\[ScriptA]\[ScriptR]\[ScriptG]\
\[ScriptS]__], \[ScriptD]\[ScriptE]\[ScriptP]\[ScriptT]\[ScriptH]_]\ \  := \ \
\[ScriptA]\  @@ \ \((\(colorizeStructuralBoxes[#, \[ScriptD]\[ScriptE]\
\[ScriptP]\[ScriptT]\[ScriptH]] &\)\  /@ \ {\[ScriptA]\[ScriptR]\[ScriptG]\
\[ScriptS]})\);\)\), "\[IndentingNewLine]", 
    \(colorizeStructuralBoxes[\[ScriptA]_, \ \ \ \ \ \ \[ScriptD]\[ScriptE]\
\[ScriptP]\[ScriptT]\[ScriptH]_]\ \  := \ \[ScriptA]\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["parsableQ", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["parsableQ", "MR"],
  " will determine whether a given box structure or string is parsable under \
the given working form. If it isn't, it will report the error message given \
by the first non-parsable object and return ",
  StyleBox["False", "MR"],
  ". ",
  StyleBox["silentParsableQ", "MR"],
  " performs exactly the same function, but will not report ANY error \
messages."
}], "Text"],

Cell[BoxData[{
    \(\(parsableQ\ @\ "\<,\>"\ \ \ \  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(parsableQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR]_\  := \[IndentingNewLine]Head\ @\ 
            ToExpression[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR], \ WorkingForm /. adjustedOptions\ @\ Notation, \ 
              HoldComplete]\  === \ 
          HoldComplete;\)\), "\[IndentingNewLine]", 
    \(\(parsableQ\ [\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] := \ \
\[IndentingNewLine]Head\ @\ 
            ToExpression[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR], \ \(WorkingForm\  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]}\)\  /. adjustedOptions\ @\ Notation, \ HoldComplete]\  === \ 
          HoldComplete;\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(notParsableQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR]___\  := \[Not] \ 
          parsableQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR];\)\), "\[IndentingNewLine]", 
    \(\(silentNotParsableQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptX]\[ScriptP]\[ScriptR]___\  := \[Not] silentEvaluate\ @\ \(parsableQ\ \
@\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\);\)\
\), "\[IndentingNewLine]", 
    \(\(silentParsableQ\ @\ \
\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]___\  \
:= \ silentEvaluate\ @\ \ \(parsableQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\);\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["silentCheck", "NumberedSubsubtitle"],

Cell["\<\
Silently checking a message to see if it fails is not trivial. The \
following code, which accomplishes this, was originally written by Todd \
Gayley and modified by Robby Villegas.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(Attributes\ @\ SilentCheck\  = \ HoldAll;\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(SilentCheck[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_, \ \[ScriptF]\
\[ScriptA]\[ScriptI]\[ScriptL]\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_]\  \
:= \[IndentingNewLine]Module[{\[ScriptR]\[ScriptE]\[ScriptT]\[ScriptU]\
\[ScriptR]\[ScriptN]\[ScriptCapitalV]\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE]}\
, \[IndentingNewLine]Unprotect\ @\ 
          Message; \[IndentingNewLine]HoldPattern[\[ScriptM]\[ScriptE]\
\[ScriptS]\[ScriptG] : Message[___]]\  := 
          Block[{$Messages\  = \ {}\ }, \ \[ScriptM]\[ScriptE]\[ScriptS]\
\[ScriptG]]\  /; \ $Messages\  =!= \ {}; \[IndentingNewLine]\[ScriptR]\
\[ScriptE]\[ScriptT]\[ScriptU]\[ScriptR]\[ScriptN]\[ScriptCapitalV]\[ScriptA]\
\[ScriptL]\[ScriptU]\[ScriptE]\  = \ 
          Check[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \[ScriptF]\
\[ScriptA]\[ScriptI]\[ScriptL]\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]]; \
\[IndentingNewLine]HoldPattern[\[ScriptM]\[ScriptE]\[ScriptS]\[ScriptG] : 
              Message[___]]\  =. ; \[IndentingNewLine]Protect\ @\ 
          Message; \
\[IndentingNewLine]\[ScriptR]\[ScriptE]\[ScriptT]\[ScriptU]\[ScriptR]\
\[ScriptN]\[ScriptCapitalV]\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE]\
\[IndentingNewLine]]\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Form Handling", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["Define notation's versions of MakeExpression and MakeBoxes", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NotationMakeExpression", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  "We Create ",
  StyleBox["NotationMakeExpression", "MR"],
  " so the Notation package minimally interferes with ",
  StyleBox["MakeExpression", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(MakeExpression[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_] := \[IndentingNewLine]With[{\
\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] = 
              NotationMakeExpression[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]]}, \[IndentingNewLine]\
\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] /; 
            Head\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\  === \ 
              HoldComplete];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NotationMakeBoxes", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "We Create ",
  StyleBox["NotationMakeBoxes", "MR"],
  " so the Notation package minimally interferes with ",
  StyleBox["MakeBoxes", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(SetAttributes[NotationMakeBoxes, HoldAllComplete];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(MakeBoxes[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_, \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM]_] := \[IndentingNewLine]With[{\[ScriptB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] = 
              NotationMakeBoxes[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]]}, \[IndentingNewLine]\[ScriptB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] /; 
            Head\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  \
=!= \ NotationMakeBoxes];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NotationBoxTag", "NumberedSubsubtitle"],

Cell[TextData[{
  "These define how ",
  StyleBox["NotationBoxTag", "MR"],
  " is handled both in input and output. Basically it is just a ",
  StyleBox["TagBox", "MR"],
  " wrapper that is ",
  "invisible",
  ". It is used to allow ",
  StyleBox["Notation", "MR"],
  " and ",
  StyleBox["Symbolize", "MR"],
  " to grab style information, etc."
}], "Text"],

Cell[BoxData[
    \(\(NotationMakeExpression[
          TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ 
            NotationBoxTag, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___], \ \
\[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_\
]\  := \ HoldComplete\ @\ \(NotationBoxTag\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(If[$NewVersion, \[IndentingNewLine]NotationMakeBoxes[
            HoldPattern[
                NotationBoxTag]\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]__, \ \[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]_] := \[IndentingNewLine]TagBox[\[ScriptB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], NotationBoxTag, 
            TagStyle \[Rule] "\<NotationTemplateStyle\>"], \
\[IndentingNewLine]NotationMakeBoxes[
            HoldPattern[
                NotationBoxTag]\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]__, \ \[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]_] := \ 
          TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], 
            NotationBoxTag]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[NotationBoxTag, HoldAll];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["stripNotationBoxTag", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["stripNotationBoxTag", "MR"],
  " will remove any ",
  StyleBox["NotationBoxTag", "MR"],
  " found in the box expression. ",
  StyleBox["NotationBoxTag", "MR"],
  " is used to allow ",
  StyleBox["Notation", "MR"],
  " to grab boxes before the style information and other things are stripped \
out."
}], "Text"],

Cell[BoxData[
    \(stripNotationBoxTag\ @\ \[ScriptA]\[ScriptN]\[ScriptY]_\  := \ \
\[ScriptA]\[ScriptN]\[ScriptY]\  //. \ 
        HoldPattern[
              NotationBoxTag]\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
\  \[RuleDelayed] \ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\)], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["identityForm for output", "NumberedSubsubtitle"],

Cell[TextData[{
  "Boxes wrapped with this wrapper will appear as ",
  StyleBox["DisplayForm", "MR"],
  " would show them, i.e. ",
  StyleBox["identityForm[SuperscriptBox[\"x\",\"2\"]]", "MR"],
  " would appear as ",
  Cell[BoxData[
      StyleBox[\(x\^2\),
        "MR"]]],
  "."
}], "Text"],

Cell[BoxData[
    \(identityForm /: \ 
      NotationMakeBoxes[
        identityForm\ @\ \[ScriptA]\[ScriptN]\[ScriptY]___, \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM]_] := \ \[ScriptA]\[ScriptN]\[ScriptY]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(SetAttributes[identityForm, HoldAll]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Character Utility Functions", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["whiteSpaceQ", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["whiteSpaceQ", "MR"],
  " tests to see if the given string can be considered white space."
}], "Text"],

Cell[BoxData[
    \(whiteSpaceQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]_String\  := \n\t\ \ DeleteCases[
          Characters\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG], \n\t\ \ \ \((\ "\<\t\>"\  | \ "\<\n\>"\  | \ "\< \>"\ \  | \ "\<\
\[InvisibleSpace]\>"\  | \ "\<\[VeryThinSpace]\>"\  | \ "\<\[ThinSpace]\>"\  \
| \ "\<\[MediumSpace]\>"\  | \ "\<\[ThickSpace]\>"\  | \ "\<\
\[NegativeVeryThinSpace]\>"\  | \ "\<\[NegativeThinSpace]\>"\  | "\<\
\[IndentingNewLine]\>" | \ \n\t\t\t\ \ \ "\<\[NegativeMediumSpace]\>"\  | \ "\
\<\[NegativeThickSpace]\>"\  | \ "\<\n\>"\  | \ "\<\[NoBreak]\>"\  | \ "\<\
\[NonBreakingSpace]\>"\  | \ "\<\[Continuation]\>"\  | \ "\<\[SpaceIndicator]\
\>"\  | \ "\<\[RoundSpaceIndicator]\>"\ \  | \ "\<\[AlignmentMarker]\>"\  | \ \
"\<\>" | "\<\[LineSeparator]\>" | "\<\[ParagraphSeparator]\>" | "\<\d\>")\)]\ \
 === \ {}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(whiteSpaceQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]___\  \
:= \ False\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["notWhiteSpaceQ", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["notWhiteSpaceQ", "MR"],
  " tests to see if the given string is not considered white space."
}], "Text"],

Cell[BoxData[
    \(notWhiteSpaceQ\ @\ \[ScriptA]\[ScriptN]\[ScriptY]_\  := \ 
      Not\ @\ \(whiteSpaceQ\ @\ \[ScriptA]\[ScriptN]\[ScriptY]\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Define ",
  StyleBox["setInternalCharacterInformation", "MR"]
}], "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["internalCharacterInformation", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  "This creates the ",
  StyleBox["internalCharacterInformation", "MR"],
  " function which gives information on the complete list of characters from \
the UnicodeCharacters.tr file. These are needed since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not currently have functions for testing things like ",
  StyleBox["OperatorQ", "MR"],
  ", ",
  StyleBox["PrefixQ", "MR"],
  ", etc."
}], "Text"],

Cell[BoxData[
    \(\(setInternalCharacterInformation\ @{\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptO]\[ScriptD]\[ScriptE]_, \[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalC]\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\
\[ScriptT]\[ScriptE]\[ScriptR]_, \[ScriptS]\[ScriptH]\[ScriptO]\[ScriptR]\
\[ScriptT]\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptS]_, \[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\
\[ScriptY]_, \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalP]\[ScriptR]\
\[ScriptE]\[ScriptC]\[ScriptE]\[ScriptD]\[ScriptE]\[ScriptN]\[ScriptC]\
\[ScriptE]_, \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalG]\[ScriptR]\
\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\[ScriptN]\[ScriptG]_, \[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalR]\[ScriptI]\[ScriptG]\[ScriptH]\[ScriptT]\
\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\[ScriptN]\[ScriptG]_\
, \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalL]\[ScriptE]\[ScriptF]\
\[ScriptT]\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\[ScriptN]\
\[ScriptG]_, \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]___}\  \
:= \[IndentingNewLine]\((internalCharacterInformation[
              ToExpression\ ["\<\"\>"\  <> \ \[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\
\[ScriptE]\[ScriptR]\  <> \ "\<\"\>"]]\  = \[IndentingNewLine]{\[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptO]\[ScriptD]\[ScriptE], \
\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\
\[ScriptT]\[ScriptY], \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalP]\
\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptE]\[ScriptD]\[ScriptE]\[ScriptN]\
\[ScriptC]\[ScriptE], \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalG]\
\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\[ScriptN]\[ScriptG], \
\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalR]\[ScriptI]\[ScriptG]\[ScriptH]\
\[ScriptT]\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\[ScriptN]\
\[ScriptG], \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalL]\[ScriptE]\
\[ScriptF]\[ScriptT]\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\
\[ScriptN]\[ScriptG], 
              StringDrop[
                StringDrop[\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\
\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptE]\
\[ScriptR], 2], \(-1\)]})\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(setInternalCharacterInformation\ @\ {\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptO]\[ScriptD]\[ScriptE]_, \[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalC]\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\
\[ScriptT]\[ScriptE]\[ScriptR]_, \[ScriptS]\[ScriptH]\[ScriptO]\[ScriptR]\
\[ScriptT]\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptS]_, \[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\
\[ScriptY]_}\  := \[IndentingNewLine]\((internalCharacterInformation[
              ToExpression\ ["\<\"\>"\  <> \ \[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\
\[ScriptE]\[ScriptR]\  <> \ "\<\"\>"]]\  = {\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptO]\[ScriptD]\[ScriptE], \[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\[ScriptY],\
 StringDrop[
                StringDrop[\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\
\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptE]\
\[ScriptR], 2], \(-1\)]})\);\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["setInternalCharacterInformation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The first argument of ",
  StyleBox["setInternalCharacterInformation", "MR"],
  " must be a list."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          setInternalCharacterInformation[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]_?\((headIsNot[
                  List])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[setInternalCharacterInformation::list, 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 
            1];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["setInternalCharacterInformation", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        setInternalCharacterInformation[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[setInternalCharacterInformation::argx, 
              HoldForm\ @\ 
                setInternalCharacterInformation, \[ScriptN]\[ScriptU]\
\[ScriptM], 1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Load internalCharacterInformation", "NumberedSubsubtitle"],

Cell[TextData[{
  "This creates the ",
  StyleBox["internalCharacterInformation", "MR"],
  " table which gives information on the complete list of characters from the \
UnicodeCharacters.tr file."
}], "Text"],

Cell[CellGroupData[{

Cell["Missing file UnicodeCharacters.tr.", "NumberedSubsubsubtitle"],

Cell[TextData[{
  "In some installed versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the file UnicodeCharacters.tr is missing.  If so report this error."
}], "Text"],

Cell[BoxData[
    \(\(unicodeCharacters::missing\  = \ "\<It appears that the file \
'UnicodeCharacters.tr' has not been included in your installation of \
Mathematica. The file 'UnicodeCharacters.tr' is necessary for Notation to \
determine the precedences of characters. Unfortunately Notation will not run \
without this file. This sometimes occurs in installations inside WRI.\>"\ \ ;\
\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(If[
        FileNames["\<UnicodeCharacters.tr\>", 
            ToFileName\ @\ {$TopDirectory, \ "\<SystemFiles\>", \ "\<FrontEnd\
\>", \ "\<TextResources\>"}] == {}, 
        Message[unicodeCharacters::missing]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Missing characters in UnicodeCharacters.tr.", "NumberedSubsubsubtitle"],

Cell["\<\
Warning: there are some characters which are not properly \
incoreperated into UnicodeCharacters.tr.\
\>", "Text"],

Cell[BoxData[
    \(\(silentEvaluate\ @\ 
        Union[setInternalCharacterInformation\  \
/@ \[IndentingNewLine]ReadList[
              ToFileName[{$TopDirectory, \ "\<SystemFiles\>", \ \
"\<FrontEnd\>", \ "\<TextResources\>"}, \ "\<UnicodeCharacters.tr\>"], \
\[IndentingNewLine]Word, \[IndentingNewLine]RecordLists\ \ \ \ \ \ \  \[Rule] \
\ \ True, \[IndentingNewLine]WordSeparators\ \ \ \  \[Rule] \ \ \
{FromCharacterCode@\ 
                    9}, \[IndentingNewLine]RecordSeparators\ \  \[Rule] \ \ \
{FromCharacterCode\ @\ 13, FromCharacterCode\ @\ 10}]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Adds standard characters to ",
  StyleBox["internalCharacterInformation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "This adds the uppercase letters, lowercase letters, and digits to ",
  StyleBox["internalCharacterInformation", "MR"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(Table[
        internalCharacterInformation[
            FromCharacterCode\ @\ i]\  = \[IndentingNewLine]{ToString@
              i, "\<Letter\>", "\<Raw\>" <> FromCharacterCode@i}, {i, 65, 
          90}];\)\), "\n", 
    \(\(Table[
        internalCharacterInformation[
            FromCharacterCode\ @\ i]\  = \[IndentingNewLine]{ToString@
              i, "\<Letter\>", "\<Raw\>" <> FromCharacterCode@i}, {i, 97, 
          122}];\)\), "\n", 
    \(\(Table[
        internalCharacterInformation[
            FromCharacterCode\ @\ i]\  = \[IndentingNewLine]{ToString@
              i, "\<Digit\>", "\<Raw\>" <> FromCharacterCode@i}, {i, 48, 
          57}];\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Define characterInformation", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["characterInformation", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["characterInformation", "MR"],
  " returns the information available on a character. "
}], "Text"],

Cell[BoxData[{
    \(\(\(characterInformation\ @\ \
\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]_String?
            characterQ\  := \ \[IndentingNewLine]characterInformationAux\ @\ \
\(internalCharacterInformation\ @\ \
\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]\);\)\(\n\)
    \)\), "\n", 
    \(\(\(characterInformation[\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]_\
String, \[ScriptF]\[ScriptI]\[ScriptE]\[ScriptL]\[ScriptD]_Symbol] := \ \
\[ScriptF]\[ScriptI]\[ScriptE]\[ScriptL]\[ScriptD]\  /. 
          characterInformation[\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]];\)\(\
\n\)
    \)\), "\n", 
    \(\(\(characterInformationAux\ @\ {\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptO]\[ScriptD]\[ScriptE]_, \[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\[ScriptY]_\
, \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\
\[ScriptC]\[ScriptE]\[ScriptD]\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE]_, \
\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalG]\[ScriptR]\[ScriptO]\[ScriptU]\
\[ScriptP]\[ScriptI]\[ScriptN]\[ScriptG]_, \[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalR]\[ScriptI]\[ScriptG]\[ScriptH]\[ScriptT]\[ScriptCapitalS]\
\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\[ScriptN]\[ScriptG]_, \[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalL]\[ScriptE]\[ScriptF]\[ScriptT]\
\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\[ScriptN]\[ScriptG]_\
, \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptH]\[ScriptA]\
\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptCapitalF]\
\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]_\
}\  := \[IndentingNewLine]{\[IndentingNewLine]CharacterCode\ \ \ \ \ \ \ \ \ \
\  \[Rule] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptO]\
\[ScriptD]\[ScriptE], \[IndentingNewLine]CharacterFixity\ \ \ \ \ \ \ \  \
\[Rule] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\
\[ScriptI]\[ScriptT]\[ScriptY], \[IndentingNewLine]CharacterPrecedence\ \ \ \ \
 \[Rule] \ \
\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptC]\
\[ScriptE]\[ScriptD]\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE], \
\[IndentingNewLine]CharacterGrouping\ \ \ \ \ \  \[Rule] \ \[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalG]\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\
\[ScriptI]\[ScriptN]\[ScriptG], \[IndentingNewLine]CharacterRightSpacing\  \
\[Rule] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalR]\[ScriptI]\[ScriptG]\
\[ScriptH]\[ScriptT]\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\
\[ScriptN]\[ScriptG], \[IndentingNewLine]CharacterLeftSpacing\ \  \[Rule] \ \
\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalL]\[ScriptE]\[ScriptF]\[ScriptT]\
\[ScriptCapitalS]\[ScriptP]\[ScriptA]\[ScriptC]\[ScriptI]\[ScriptN]\[ScriptG],\
 \[IndentingNewLine]CharacterFullName\ \ \ \ \ \  \[Rule] \ \[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptH]\[ScriptA]\[ScriptR]\[ScriptA]\
\[ScriptC]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptCapitalF]\[ScriptU]\[ScriptL]\
\[ScriptL]\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]};\)\(\n\)
    \)\), "\n", 
    \(\(characterInformationAux\ @\ {\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptCapitalC]\[ScriptO]\[ScriptD]\[ScriptE]_, \[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\[ScriptY]_\
, \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptH]\[ScriptA]\
\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptCapitalF]\
\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]_\
}\  := \[IndentingNewLine]{\[IndentingNewLine]CharacterCode\ \ \ \ \ \ \ \ \ \
\  \[Rule] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptO]\
\[ScriptD]\[ScriptE], \[IndentingNewLine]CharacterFixity\ \ \ \ \ \ \ \  \
\[Rule] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\
\[ScriptI]\[ScriptT]\[ScriptY], \[IndentingNewLine]CharacterFullName\ \ \ \ \ \
\  \[Rule] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalC]\[ScriptH]\
\[ScriptA]\[ScriptR]\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptCapitalF]\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalN]\[ScriptA]\
\[ScriptM]\[ScriptE]};\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["characterInformation", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The first argument of ",
  StyleBox["characterInformation", "MR"],
  " must be a string."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          characterInformation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalS]\
\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_?\((headIsNot[
                  String])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[characterInformation::string, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The second argument of ",
  StyleBox["characterInformation", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          characterInformation[_, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            characterInformation::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 2];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["characterInformation", "MR"],
  " expects one or two arguments."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          characterInformation[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]\((\[ScriptN]\[ScriptU]\
\[ScriptM]\  < \ 1\  \[Or] \ \[ScriptN]\[ScriptU]\[ScriptM]\  > 
                    2)\)\  \[And] \ \ Message[characterInformation::argt, 
                HoldForm\ @\ characterInformation, 
                heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR], 1, 2]];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Box and Character Querying Functions", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["\<\
definition of isolatingBoxes and nonIsolatingBoxes and \
mutableIsolatingBoxes\
\>", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["isolatingBoxes", "MR"],
  " are the box structures that isolate the grouping nature and precedence \
nature of the internals of the box."
}], "Text"],

Cell[BoxData[
    \(\(isolatingBoxes\  = \ \((\ 
          ButtonBox\  | \ FormBox\  | \ FractionBox\  | \ FrameBox\  | \ 
            GridBox\ \  | \ RowBox\  | RadicalBox\  | \ 
            SqrtBox\ \ )\);\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["nonIsolatingBoxes", "MR"],
  " are the box structures that do not isolate the grouping nature and \
precedence nature of the internals of the box."
}], "Text"],

Cell[BoxData[
    \(\(nonIsolatingBoxes\  = \((\ \ AdjustmentBox\  | \ ErrorBox\  | \ 
            StyleBox\  | \ SubscriptBox\  | \ SuperscriptBox\  | 
            SubsuperscriptBox\  | \ UnderscriptBox\  | \ OverscriptBox\  | \ 
            UnderoverscriptBox)\);\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["mutableIsolatingBoxes", "MR"],
  " are the box structures that possibly change the grouping nature and \
precedence nature of the internals of the box."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["mutableIsolatingBoxes",
          "MR"], " ", "=", \((TagBox\  | InterpretationBox)\)}], 
      ";"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"allTheBoxes", " ", "=", " ", 
        RowBox[{"Flatten", "[", 
          RowBox[{
          "nonIsolatingBoxes", " ", "|", " ", "isolatingBoxes", " ", "|", " ",
             
            StyleBox["mutableIsolatingBoxes",
              "MR"]}], 
          StyleBox["]",
            "MR"]}]}], ";"}]], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["boxStructureQ", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["boxStructureQ", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["boxStructureQ", "MR"],
  " tests an expression to see if its head is a known box."
}], "Text"],

Cell[BoxData[{\(boxStructureQ\ @\ \(nonIsolatingBoxes\ @\ \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]___\) := \ 
        True;\), "\[IndentingNewLine]", \(boxStructureQ\ @\ \(isolatingBoxes\ \
@\ \[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]___\) := \ 
        True;\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        RowBox[{"boxStructureQ", " ", "@", " ", 
          RowBox[{
            StyleBox["mutableIsolatingBoxes",
              "MR\.7f"], " ", "@", " ", 
            "\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]___"}]}], ":=", " ", 
        "True"}], 
      ";"}], "\[IndentingNewLine]", \(boxStructureQ\ @\ _ := \ 
        False;\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["boxStructureQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["boxStructureQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          boxStructureQ[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\
\  \[NotEqual] \ 1\  \[And] \ 
              Message[boxStructureQ::argx, 
                HoldForm\ @\ boxStructureQ, \[ScriptN]\[ScriptU]\[ScriptM], 
                1]];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["nonIsolatingBoxStructureQ", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["nonIsolatingBoxStructureQ", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["nonIsolatingBoxStructureQ", "MR"],
  " will give ",
  StyleBox["True", "MR"],
  " if the box structure does not isolate the grouping nature and precedence \
nature of the internals of the box."
}], "Text"],

Cell[BoxData[{
    \(\(nonIsolatingBoxStructureQ\ @\ \(nonIsolatingBoxes\ @\ \[ScriptA]\
\[ScriptR]\[ScriptG]\[ScriptS]___\) := \ True;\)\), "\[IndentingNewLine]", 
    \(nonIsolatingBoxStructureQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]_\  := \ False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["nonIsolatingBoxStructureQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["nonIsolatingBoxStructureQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        nonIsolatingBoxStructureQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[nonIsolatingBoxStructureQ::argx, 
              HoldForm\ @\ 
                nonIsolatingBoxStructureQ, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["mutableIsolatingBoxStructureQ", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["mutableIsolatingBoxStructureQ", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["mutableIsolatingBoxStructureQ", "MR"],
  " will give ",
  StyleBox["True", "MR"],
  " if the box structure does not isolate the grouping nature and precedence \
nature of the internals of the box."
}], "Text"],

Cell[BoxData[{
    \(\(mutableIsolatingBoxStructureQ\ @\ \(mutableIsolatingBoxes\ @\ \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]___\) := \ 
        True;\)\), "\[IndentingNewLine]", 
    \(mutableIsolatingBoxStructureQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptR]_\  := \ False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["mutableIsolatingBoxStructureQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["mutableIsolatingBoxStructureQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        mutableIsolatingBoxStructureQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[mutableIsolatingBoxStructureQ::argx, 
              HoldForm\ @\ 
                mutableIsolatingBoxStructureQ, \
\[ScriptN]\[ScriptU]\[ScriptM], 1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["effectiveBoxes", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["effectiveBoxes", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["effectiveBoxes", "MR"],
  " will give the string internal to the given box structure according to how \
the boxes \"act\". \nE.g. ",
  StyleBox["SubscriptBox[\"+\",\"R\"]", "Input"],
  " will \"act\" like ",
  StyleBox["\"+\"", "Input"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]_String\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  := \ \[ScriptS]\
\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG];\)\), \
"\[IndentingNewLine]", 
    \(\(effectiveBoxes\ @\ 
          nonIsolatingBoxes[\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptK]\[ScriptE]_, ___]\  := \ 
        effectiveBoxes\ @\ \[ScriptA]\[ScriptC]\[ScriptT]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptK]\[ScriptE];\)\), "\[IndentingNewLine]", 
    \(\(effectiveBoxes\ @\ 
          mutableIsolatingBoxes[___, 
            SyntaxForm\  \[Rule] \ \[ScriptA]\[ScriptC]\[ScriptT]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptK]\[ScriptE]_, ___]\  := \ 
        effectiveBoxes\ @\ \[ScriptA]\[ScriptC]\[ScriptT]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptK]\[ScriptE];\)\), "\[IndentingNewLine]", 
    \(\(effectiveBoxes\ @\ 
          mutableIsolatingBoxes[\[ScriptA]\[ScriptC]\[ScriptT]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptK]\[ScriptE]_, ___] := \ 
        effectiveBoxes\ @\ \[ScriptA]\[ScriptC]\[ScriptT]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptK]\[ScriptE];\)\), "\[IndentingNewLine]", 
    \(\(effectiveBoxes\ @\ 
          isolatingBoxes\ \ \ [___]\ \ \ \ \ \ \ \  := \ "\<GenericSymbol\>";\
\)\), "\[IndentingNewLine]", 
    \(effectiveBoxes\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]_ \
:= \ "\<GenericSymbol\>"\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["effectiveBoxes", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The first argument of ",
  StyleBox["effectiveBoxes", "MR"],
  " must be a box structure."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          effectiveBoxes[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalA]\
\[ScriptR]\[ScriptG]_?\((isNot[_?
                    boxStructureQ])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[effectiveBoxes::badarg, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(effectiveBoxes::badarg\  = "\<Box structure or String expected at \
position `1` in `2`\>";\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["effectiveBoxes", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        effectiveBoxes[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[effectiveBoxes::argx, 
              HoldForm\ @\ effectiveBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["prefixOperatorQ", "NumberedSubsubtitle"],

Cell[TextData[{
  "This boolean function determines if the given expression is normally \
treated as a ",
  StyleBox["PrefixOperator", "MR"],
  ".",
  "\n",
  "If the expression is a box structure, then look inside the structure to \
see how it acts."
}], "Text"],

Cell[BoxData[{
    \(\(prefixOperatorQ\ @\ \
\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]_?
            nonIsolatingBoxStructureQ\  := \ 
        prefixOperatorQ\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ \
\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]_?
            mutableIsolatingBoxStructureQ\  := \ 
        prefixOperatorQ\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\)}], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["prefixOperatorQ", "MR"],
  ": exceptions"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(prefixOperatorQ\ @\ "\<\[PartialD]\>"\ \ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[Integral]\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[ContourIntegral]\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[CounterClockwiseContourIntegral]\>"\ \ \  = \
\ True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[ClockwiseContourIntegral]\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[DoubleContourIntegral]\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[Sum]\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ "\<\[Product]\>"\ \ \  = \ True;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["prefixOperatorQ", "MR"],
  ": the general case"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(prefixOperatorQ\ @\ "\<!\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorQ\ @\ \[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]_?
            characterQ\  := \ \(("\<Prefix\>"\  == \ 
            characterInformation\ [\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR], 
              CharacterFixity]\ )\);\)\), "\[IndentingNewLine]", 
    \(prefixOperatorQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]_\
\  := \ False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["prefixOperatorQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["prefixOperatorQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        prefixOperatorQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[prefixOperatorQ::argx, 
              HoldForm\ @\ prefixOperatorQ, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["infixOperatorQ", "NumberedSubsubtitle"],

Cell[TextData[{
  "This boolean function determines if the given expression could normally be \
treated as an ",
  StyleBox["InfixOperator", "MR"],
  ".",
  "\n",
  "If the expression is a box structure, then look inside the structure to \
see how it acts."
}], "Text"],

Cell[BoxData[{
    \(\(infixOperatorQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\
\[ScriptT]_?nonIsolatingBoxStructureQ\  := \ 
        infixOperatorQ\ @\ \(effectiveBoxes\ @\ \
\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\), "\
\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\
\[ScriptT]_?mutableIsolatingBoxStructureQ\  := \ 
        infixOperatorQ\ @\ \(effectiveBoxes\ @\ \
\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\)}], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["infixOperatorQ", "MR"],
  ": exceptions"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(infixOperatorQ\ @\ "\<+\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<*\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<^\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<.\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<-\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<->\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<:>\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<=\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<:=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<^=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<^:=\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<+=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<-=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<*=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\</=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\</.\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<//.\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<//\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\</;\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\</\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<:\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<;\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<<=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<<\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<>\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<>=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<==\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<===\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<!\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<!=\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<=!=\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<&&\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<||\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<?\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<@@\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<@\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\</@\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<||\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(infixOperatorQ\ @\ "\<|\>"\ \ \  = \ True;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["infixOperatorQ", "MR"],
  ":  the general case"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(infixOperatorQ\ @\ \[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]_?
            characterQ\  := \ \(("\<Infix\>"\  == \ 
            characterInformation\ [\ \
\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR], \ 
              CharacterFixity])\);\)\), "\[IndentingNewLine]", 
    \(infixOperatorQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]_\ \
\ \ \ \ \  := \ False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["infixOperatorQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["infixOperatorQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        infixOperatorQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[infixOperatorQ::argx, 
              HoldForm\ @\ infixOperatorQ, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["postfixOperatorQ", "NumberedSubsubtitle"],

Cell[TextData[{
  "This boolean function determines if the given string could normally be \
treated as a ",
  StyleBox["PostfixOperator", "MR"],
  ".",
  "\n",
  "If the expression is a box structure, then look inside the structure to \
see how it acts."
}], "Text"],

Cell[BoxData[{
    \(\(postfixOperatorQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\
\[ScriptC]\[ScriptT]_?nonIsolatingBoxStructureQ\  := \ 
        postfixOperatorQ\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\
\[ScriptC]\[ScriptT]_?mutableIsolatingBoxStructureQ\  := \ 
        postfixOperatorQ\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\)}], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["postfixOperatorQ", "MR"],
  ": exceptions"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(postfixOperatorQ\ @\ "\<;\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<&\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<!!\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<!\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<'\>"\ \ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<--\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<++\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<=.\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<..\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ "\<...\>"\  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]_\  = \ False;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["postfixOperatorQ", "MR"],
  ":  the general case"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(postfixOperatorQ\ @\ \[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]_?
            characterQ\  := \ \(("\<Postfix\>"\  == \ 
            characterInformation\ [\[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR], \
\ CharacterFixity])\);\)\), "\[IndentingNewLine]", 
    \(\(postfixOperatorQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]_\ \  := \ False;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["postfixOperatorQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["postfixOperatorQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        postfixOperatorQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[postfixOperatorQ::argx, 
              HoldForm\ @\ postfixOperatorQ, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["operatorQ", "NumberedSubsubtitle"],

Cell[TextData[{
  "This boolean function determines if the given string is normally treated \
as an ",
  StyleBox["Operator", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(operatorQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\  \
:= \ prefixOperatorQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  \
\[Or] \ infixOperatorQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\  \[Or] \ 
        postfixOperatorQ\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]\)\(\ \)\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["operatorQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["operatorQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        operatorQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[operatorQ::argx, 
              HoldForm\ @\ operatorQ, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["delimiterQ", "NumberedSubsubtitle"],

Cell[TextData[{
  "This boolean function determines if the given string could normally be \
treated as a ",
  StyleBox["Delimiter", "MR"],
  ".",
  "\n",
  "If the expression is a box structure, then look inside the structure to \
see how it acts."
}], "Text"],

Cell[BoxData[{
    \(\(delimiterQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\
\[ScriptT]_?nonIsolatingBoxStructureQ\  := \ 
        delimiterQ\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptU]\[ScriptC]\[ScriptT]\);\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\[ScriptC]\
\[ScriptT]_?mutableIsolatingBoxStructureQ\  := \ 
        delimiterQ\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptU]\[ScriptC]\[ScriptT]\);\)\)}], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["delimiterQ", "MR"],
  ": exceptions"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(delimiterQ\ @\ "\<\[InvisibleComma]\>"\ \  = \ 
        True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<,\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<[\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<]\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<(\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<)\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<{\>"\  = \ True;\)\), "\[IndentingNewLine]", 
    \(\(delimiterQ\ @\ "\<}\>"\  = \ True;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["delimiterQ", "MR"],
  ":  the general case"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(delimiterQ\ @\ \[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR]_?
            characterQ\  := \[IndentingNewLine]With[{\ \[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\[ScriptY]\
\  = \ \ characterInformation\ [\ \[ScriptC]\[ScriptH]\[ScriptA]\[ScriptR], \ 
                CharacterFixity]}, \[IndentingNewLine]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\[ScriptY]\
\  == \ "\<Open\>"\  \[Or] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalF]\
\[ScriptI]\[ScriptX]\[ScriptI]\[ScriptT]\[ScriptY]\  == \ "\<InfixOpen\>"\  \
\[Or] \ \[ScriptT]\[ScriptH]\[ScriptE]\[ScriptCapitalF]\[ScriptI]\[ScriptX]\
\[ScriptI]\[ScriptT]\[ScriptY]\  == \ "\<Close\>"];\)\), \
"\[IndentingNewLine]", 
    \(delimiterQ\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]_\  \
:= \ False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["postfixOperatorQ", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["delimiterQ", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        delimiterQ[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[delimiterQ::argx, 
              HoldForm\ @\ delimiterQ, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["TokenToSymbol Functions", "NumberedSubsubtitle"],

Cell[TextData[{
  "These functions will take an operator string token that is not an \
exception and give the operator symbol that this token parses to.\nThe ",
  StyleBox["Check", "MR"],
  " is in case the symbol is not ",
  "recognized",
  ", in which case the precedence is reported as '",
  StyleBox["Times", "MR"],
  "'."
}], "Text"],

Cell[BoxData[
    \(\(infixOperatorTokenToSymbol\ @\ \[ScriptI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]_String \
:= \[IndentingNewLine]silentEvaluate\ @\ \[IndentingNewLine]Check[\ 
            Module[{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] = 
                  ToHeldExpression["\<a\>"\  <> \ \[ScriptI]\[ScriptN]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]\  <> \ "\<b\>"]}, \
\[IndentingNewLine]If[
                Depth\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\  == 
                  3, \ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[LeftDoubleBracket]1, 0\[RightDoubleBracket], Times]], Times];\)\)], "Input",\

  InitializationCell->True],

Cell[BoxData[{
    \(\(prefixOperatorTokenToSymbol\ @\ "\<\[PartialD]\>"\ \ \ \  = \ 
        D;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorTokenToSymbol\ @\ "\<\[Integral]\>"\ \ \  = \ 
        Integrate;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorTokenToSymbol\ @\ "\<\[ContourIntegral]\>"\ \ \  = \ 
        Integrate;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorTokenToSymbol\ @\ "\<\[CounterClockwiseContourIntegral]\
\>"\ \ \  = \ Integrate;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorTokenToSymbol\ @\ "\<\[ClockwiseContourIntegral]\>"\ \ \
\  = \ Integrate;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorTokenToSymbol\ @\ "\<\[DoubleContourIntegral]\>"\ \ \  \
= \ Integrate;\)\), "\[IndentingNewLine]", 
    \(\(prefixOperatorTokenToSymbol\ @\ \[ScriptP]\[ScriptR]\[ScriptE]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP]_String \
:= \[IndentingNewLine]silentEvaluate\ @\[IndentingNewLine]Check[\ 
            Module[{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] = 
                  ToHeldExpression[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP]\  <> \ "\<b\>"]}, \
\[IndentingNewLine]If[
                Depth\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\  == 
                  3, \ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[LeftDoubleBracket]1, 0\[RightDoubleBracket], Times]], Times];\)\)}], "Input",\

  InitializationCell->True],

Cell[BoxData[{
    \(\(postfixOperatorTokenToSymbol\ @\ "\<'\>"\  = \ 
        Derivative;\)\), "\[IndentingNewLine]", 
    \(postfixOperatorTokenToSymbol\ @\ \[ScriptP]\[ScriptO]\[ScriptS]\
\[ScriptT]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalO]\[ScriptP]_String \
:= \[IndentingNewLine]silentEvaluate\ @\[IndentingNewLine]Check[\ 
          Module[{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] = 
                ToHeldExpression["\<b\>"\  <> \ \
\[ScriptP]\[ScriptO]\[ScriptS]\[ScriptT]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptCapitalO]\[ScriptP]]}, \[IndentingNewLine]If[
              Depth\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\  == 
                3, \ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[LeftDoubleBracket]1, 0\[RightDoubleBracket], Times]], Times]\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Error checking for Token to Symbol Functions", "NumberedSubsubtitle"],

Cell[TextData[{
  "The first argument of ",
  StyleBox["infixOperatorTokenToSymbol", "MR"],
  " must be a String."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          infixOperatorTokenToSymbol[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_?\((\
headIsNot[String])\), ___] := \ $Failed /; \[IndentingNewLine]Message[
            infixOperatorTokenToSymbol::string, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The first argument of ",
  StyleBox["prefixOperatorTokenToSymbol", "MR"],
  " must be a String."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          prefixOperatorTokenToSymbol[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_?\((\
headIsNot[String])\), ___]\ \  := \ $Failed /; \[IndentingNewLine]Message[
            prefixOperatorTokenToSymbol::string, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The first argument of ",
  StyleBox["postfixOperatorTokenToSymbol", "MR"],
  " must be a String."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          postfixOperatorTokenToSymbol[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_?\((\
headIsNot[String])\), ___]\ \  := \ $Failed /; \[IndentingNewLine]Message[
            postfixOperatorTokenToSymbol::string, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["infixOperatorTokenToSymbol", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        infixOperatorTokenToSymbol[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[infixOperatorTokenToSymbol::argx, 
              HoldForm\ @\ 
                infixOperatorTokenToSymbol, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["prefixOperatorTokenToSymbol", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        prefixOperatorTokenToSymbol[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[prefixOperatorTokenToSymbol::argx, 
              HoldForm\ @\ 
                prefixOperatorTokenToSymbol, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["postfixOperatorTokenToSymbol", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        postfixOperatorTokenToSymbol[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[postfixOperatorTokenToSymbol::argx, 
              HoldForm\ @\ 
                postfixOperatorTokenToSymbol, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["effectiveOperator", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["effectiveOperator", "MR"],
  " gives the effective operator by which output boxes need to be grouped."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["effectiveOperator ", "MR"],
  ":  exceptions"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(effectiveOperator\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptU]\
\[ScriptC]\[ScriptT]_?boxStructureQ\  := \ 
        effectiveOperator\ @\ \(effectiveBoxes\ @\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptU]\[ScriptC]\[ScriptT]\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(effectiveOperator\ @\ "\<\[PartialD]\>"\ \ \  = \ \ D;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(effectiveOperator\ @\ "\<\[Integral]\>"\ \  = \ 
        Integrate;\)\), "\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ "\<\[ContourIntegral]\>"\ \  = \ 
        Integrate;\)\), "\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ "\<\[ClockwiseContourIntegral]\>"\ \  = \ 
        Integrate;\)\), "\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ "\<\[CounterClockwiseContourIntegral]\>"\ \  = \
\ Integrate;\)\), "\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ "\<\[ClockwiseContourIntegral]\>"\ \  = \ 
        Integrate;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["effectiveOperator ", "MR"],
  ": the general case"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(effectiveOperator\ @\ \[ScriptO]\[ScriptP]_?prefixOperatorQ\ \  := \ 
        prefixOperatorTokenToSymbol\ @\ \[ScriptO]\[ScriptP];\)\), "\
\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ \[ScriptO]\[ScriptP]_?infixOperatorQ\ \ \  := \ 
        infixOperatorTokenToSymbol\ @\ \[ScriptO]\[ScriptP];\)\), "\
\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ \[ScriptO]\[ScriptP]_?postfixOperatorQ\  := \ 
        postfixOperatorTokenToSymbol\ @\ \[ScriptO]\[ScriptP];\)\), "\
\[IndentingNewLine]", 
    \(\(effectiveOperator\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]_\  := \ Times;\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["effectiveOperator", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["effectiveOperator", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        effectiveOperator[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[effectiveOperator::argx, 
              HoldForm\ @\ effectiveOperator, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Utility Functions", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["\<\
myHold,   releaseMyHold,  flattenAllMyHold &  \
toMyHeldExpression\
\>", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["myHold", "MR"],
  " and ",
  StyleBox["releaseMyHold", "MR"],
  " are exactly the same as the standard ",
  StyleBox["Hold", "MR"],
  " and ",
  StyleBox["releaseHold", "MR"],
  ", except they appear in a different context so they will not stomp on \
other uses of ",
  StyleBox["Hold", "MR"],
  " or held expressions."
}], "Text"],

Cell[BoxData[
    \(\(SetAttributes\ [\ {myHold, releaseMyHold}, 
        HoldAllComplete];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(releaseMyHold\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]___\ \  := 
        Evaluate\  @@ \ \((HoldComplete\ [\ \[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]\ ]\  //. \ 
              myHold\ @\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM]___\  \
\[Rule] \ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM])\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(flattenAllMyHold\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_\  := \ 
        myHold\  @@ \ \ \((HoldComplete\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]\  //. \ 
              myHold\ @\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM]___\  \
\[Rule] \ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM])\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(toMyHeldExpression\ @\ \[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]___\  \
:= \ myHold\  @@ \ 
          MakeExpression\ @\ \[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS];\)\)], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["removePatternsAndBlanks", "NumberedSubsubtitle"],

Cell["\<\
This removes all pattern wrappers, optional wrappers, pattern tests \
and conditions, leaving just a pattern variable if possible.\
\>", "Text"],

Cell[BoxData[
    \(removePatternsAndBlanks\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_ := 
      Evaluate\  @@ \ \((myHold\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] \
//. \[IndentingNewLine]{\[IndentingNewLine]\((\[ScriptH]\[ScriptO]\[ScriptL]\
\[ScriptD]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                      Optional)\)\ \ \ \ \ \ [\[ScriptA]_, ___] \[Rule] \
\[ScriptA], \[IndentingNewLine]\((\[ScriptH]\[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                      Pattern)\)\ \ \ \ \ \ \ \ \ [\[ScriptA]_, ___] \[Rule] \
\[ScriptA], \[IndentingNewLine]\((\[ScriptH]\[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                      PatternTest)\)[\[ScriptA]_, ___] \[Rule] \[ScriptA], \
\[IndentingNewLine]\((\[ScriptH]\[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                      Condition)\)\ \ \ \ [\[ScriptA]_, ___] \[Rule] \
\[ScriptA]})\)\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["removePatternsAndBlanks", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["removePatternsAndBlanks", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        removePatternsAndBlanks[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[removePatternsAndBlanks::argx, 
              HoldForm\ @\ 
                removePatternsAndBlanks, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["convertPatterns", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["convertPatterns", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["convertPatterns", "MR"],
  " will remove all ",
  StyleBox["PatternTests", "MR"],
  ", ",
  StyleBox["Conditions", "MR"],
  " and ",
  StyleBox["Optionals", "MR"],
  ", as well as ",
  StyleBox["Heads", "MR"],
  ", leaving just named Patterns. It is useful for putting an expression into \
a form upon which further manipulations of the pattern variables may be \
performed."
}], "Text"],

Cell[BoxData[
    \(convertPatterns\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_ \
:= \[IndentingNewLine]myHold\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR] //. \
{\[IndentingNewLine]\((\[ScriptH]\[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                  Optional)\)\ \ \ [\[ScriptA]_, ___]\ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \  \[Rule] \ \[ScriptA], \[IndentingNewLine]\((\[ScriptH]\[ScriptO]\
\[ScriptL]\[ScriptD]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                  Pattern)\)\ \ \ \ [\[ScriptA]_, _Blank]\ \ \ \ \ \ \ \ \ \ \
\ \ \  \[Rule] \ 
            singleBlank\ @\ \[ScriptA], \[IndentingNewLine]\((\[ScriptH]\
\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] \
: Pattern)\)\ \ \ \ [\[ScriptA]_, _BlankSequence]\ \ \ \ \  \[Rule] \ 
            doubleBlank\ @\ \[ScriptA], \[IndentingNewLine]\((\[ScriptH]\
\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] \
: Pattern)\)\ \ \ \ [\[ScriptA]_, _BlankNullSequence]\  \[Rule] \ 
            tripleBlank\ @\ \[ScriptA], \[IndentingNewLine]\((\[ScriptH]\
\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] \
: Pattern)\)\ \ \ \ [\[ScriptA]_, _]\  \[Rule] \ 
            complexPattern\ @\ \[ScriptA], \[IndentingNewLine]\((\[ScriptH]\
\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] \
: PatternTest)\)[\[ScriptA]_, ___]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  \[Rule] \ \
\[ScriptA], \[IndentingNewLine]\((\[ScriptH]\[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD] : 
                  Condition)\)\ \ [\[ScriptA]_, ___]\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \  \[Rule] \ \[ScriptA], \[IndentingNewLine]_Blank\ \ \ \ \ \ \ \ \ \ \ \ \
\  \[Rule] \ 
            singleBlank[], \[IndentingNewLine]_BlankSequence\ \ \ \ \  \
\[Rule] \ doubleBlank[], \[IndentingNewLine]_BlankNullSequence\  \[Rule] \ 
            tripleBlank[]}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[{singleBlank, doubleBlank, tripleBlank, 
          complexPattern}, HoldAll];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["convertPatterns", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["convertPatterns", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        convertPatterns[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[convertPatterns::argx, 
              HoldForm\ @\ convertPatterns, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["cleanBoxes & tidyBoxes", "NumberedSubsubtitle"],

Cell[TextData[{
  "These two functions just clean up box structures by flattening single ",
  StyleBox["RowBoxes", "MR"],
  ", removing nested ",
  StyleBox["RowBoxes", "MR"],
  " and removing white space, where applicable."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["cleanBoxes", "MR"]], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(cleanBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\  \
:= \ \[IndentingNewLine]Identity\  @@ \ 
        StripBoxes\ [\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] //. {\
\[IndentingNewLine]RowBox\ @\ {\[ScriptS]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptL]\[ScriptE]_} \[RuleDelayed] \ \ \[ScriptS]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptL]\[ScriptE], \[IndentingNewLine]RowBox\ @\ {RowBox\ @\ {\
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]___}} \[RuleDelayed] \ \ RowBox\ @\ {\
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]}}]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["tidyBoxes", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(tidyBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\  \
:= \[IndentingNewLine]\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] //. \
{\[IndentingNewLine]RowBox\ @\ {RowBox\ @\ {\[ScriptA]\[ScriptR]\[ScriptG]\
\[ScriptS]___}}\ \  \[RuleDelayed] \ \ RowBox\ @\ {\[ScriptA]\[ScriptR]\
\[ScriptG]\[ScriptS]}, \[IndentingNewLine]RowBox\ @\ {\[ScriptL]___, 
                RowBox\ @\ \
{\[ScriptS]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptL]\[ScriptE]_}, \
\[ScriptR]___}\  \[RuleDelayed] \ \ RowBox\ @\ {\[ScriptL], \[ScriptS]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptL]\[ScriptE], \[ScriptR]}\ }\)], "Input",\

  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["cleanBoxes", "MR"],
  " and ",
  StyleBox["tidyBoxes", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["cleanBoxes", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        cleanBoxes[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[cleanBoxes::argx, 
              HoldForm\ @\ cleanBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["tidyBoxes", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        tidyBoxes[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[tidyBoxes::argx, 
              HoldForm\ @\ tidyBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["stripStylingBoxes", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["StripStylingBoxes", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["StripStylingBoxes", "MR"],
  " will remove any ",
  StyleBox["styleBoxes", "MR"],
  ", ",
  StyleBox["AdjustmentBoxes", "MR"],
  " or ",
  StyleBox["FrameBoxes", "MR"],
  " from an expressions"
}], "Text"],

Cell[BoxData[{
    \(\(SetAttributes[stripStylingBoxes, 
        HoldAll];\)\), "\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ 
          StyleBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \
\[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\[ScriptS]___] := \ 
        stripStylingBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS];\)\), "\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ 
          AdjustmentBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \
\[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\[ScriptS]___] := \ 
        stripStylingBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS];\)\), "\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ 
          FrameBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \
\[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\[ScriptS]___] := \ 
        stripStylingBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS];\)\), "\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ \(TagBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]___\)\  := \ 
        TagBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS];\)\), "\
\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ \(RowBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]___\)\  := \ 
        RowBox\ [\ 
          stripStylingBoxes\  /@ \ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]];\)\), "\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ \(\[ScriptA]_\ @\ \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]__\)\  /; \ 
          boxStructureQ[\ \[ScriptA]\ @\ \[ScriptA]\[ScriptR]\[ScriptG]\
\[ScriptS]]\ \  := \ \[ScriptA]\  @@ \ \((stripStylingBoxes\  /@ \ \
{\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]})\);\)\), "\[IndentingNewLine]", 
    \(\(stripStylingBoxes\ @\ {\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]__} \
:= \ stripStylingBoxes\  /@ \ \
{\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]};\)\), "\[IndentingNewLine]", 
    \(stripStylingBoxes\ @\ \[ScriptA]_\  := \ \[ScriptA]\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["stripStylingBoxes", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["stripStylingBoxes", "MR"],
  " expects only one argument."
}], "Text"],

Cell[BoxData[
    \(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
        stripStylingBoxes[___]\ \  := \ 
      With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]}, \ $Failed\  \
/; \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \[NotEqual] \ 
              1\  \[And] \ 
            Message[stripStylingBoxes::argx, 
              HoldForm\ @\ stripStylingBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
              1]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["padList", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["padList", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["padList", "MR"],
  " will insert a padding element, ",
  StyleBox["padElement",
    FontSlant->"Italic"],
  ", between all adjacent members of a list. This is useful for inserting, \
say, commas or infix operators, etc."
}], "Text"],

Cell[BoxData[
    \(\(padList[\[ScriptL]\[ScriptI]\[ScriptS]\[ScriptT]_List, \[ScriptP]\
\[ScriptA]\[ScriptD]\[ScriptCapitalE]\[ScriptL]\[ScriptE]\[ScriptM]\[ScriptE]\
\[ScriptN]\[ScriptT]_] := \ \(Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \
\(Thread\ \ @\ {\[ScriptL]\[ScriptI]\[ScriptS]\[ScriptT], \ \[ScriptP]\
\[ScriptA]\[ScriptD]\[ScriptCapitalE]\[ScriptL]\[ScriptE]\[ScriptM]\[ScriptE]\
\[ScriptN]\[ScriptT]}\)\);\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["padList", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The first argument of ",
  StyleBox["padList", "MR"],
  " must be a list."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          padList[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalL]\[ScriptI]\
\[ScriptS]\[ScriptT]_?\((headIsNot[
                  List])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[padList::list, 
            HoldForm@\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 
            1];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["padList", "MR"],
  " expects two arguments."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          padList[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[\[ScriptN]\[ScriptU]\
\[ScriptM]\  == \ 1\ , \ 
              Message[padList::argr, HoldForm\ @\ padList, 
                2], \ \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \
\[NotEqual] \ 2\ \ , \ 
              Message[padList::argrx, 
                HoldForm\ @\ padList, \[ScriptN]\[ScriptU]\[ScriptM], 
                2], \[IndentingNewLine]True, \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
False]];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Fix Insane Behaviour of FullForm", "NumberedSubsubtitle"],

Cell[TextData[{
  "Unfortunately, the following code is needed to circumvent the behaviour of \
",
  StyleBox["FullForm", "MR"],
  ". This behaviour was changed in the final Beta 3 of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 and has persisted since."
}], "Text"],

Cell[BoxData[{
    \(\(wasProtected\  = Unprotect\ @\ FullForm;\)\), "\n", 
    \(\(FullForm /: \[IndentingNewLine]TagBox[
          StyleBox[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_, \
\[IndentingNewLine]Verbatim[\ 
              ShowSpecialCharacters \[Rule] 
                False], \[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]__], 
          FullForm] := \[IndentingNewLine]TagBox[
          StyleBox[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \[ScriptR]\
\[ScriptE]\[ScriptS]\[ScriptT]], FullForm];\)\), "\[IndentingNewLine]", 
    \(\(Protect\ @\ \(Evaluate\ @\ wasProtected\);\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pattern Conversions, Handling, and Testing", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["boxedStringPatternsToPatterns", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["boxedStringPatternsToPatterns", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["boxedStringPatternsToPatterns", "MR"],
  " will take an expression consisting of boxes and convert all patterns \
present in the boxes\[LongDash]patterns that are currently still unparsed \
strings and not yet expressions\[LongDash]and convert them to the \
corresponding patterned expressions, leaving the other boxes alone."
}], "Text"],

Cell[BoxData[
    \(boxedStringPatternsToPatterns[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]Module[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \ \ \ \ \ \ \ \ \
\ \ \  = \ \(WorkingForm\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Notation}, \[IndentingNewLine]stripStylingBoxes\  @@ \ \
\[IndentingNewLine]{\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\  //. {\[IndentingNewLine]HoldPattern[
                      NotationBoxTag]\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_\  \[RuleDelayed] \ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS],\
 \[IndentingNewLine]TagBox[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, 
                    NotationPatternTag, ___]\  \[RuleDelayed] \ \ \
toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]], \[IndentingNewLine]TagBox[\[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, 
                    NotationMadeBoxesTag, ___]\  \[RuleDelayed] \ \ \
toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]], \[IndentingNewLine]\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG]_String\  /; \ 
                    StringMatchQ[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG], "\<*_\>"]\ \  \[RuleDelayed] \ 
                  ToExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["boxedStringPatternsToPatterns", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The second argument and beyond of ",
  StyleBox["boxedStringPatternsToPatterns", "MR"],
  " must be Options."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          boxedStringPatternsToPatterns[_, ___, \
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]_?\((isNot[_?
                    OptionQ])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[boxedStringPatternsToPatterns::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["patternToGeneralQ", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["patternToGeneralQ", "MR"],
  " test to see if a pattern is to general to be used in a Symbolization or \
Notation ",
  "statement",
  "."
}], "Text"],

Cell[BoxData[
    \(\(SetAttributes[patternToGeneralQ, HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(patternToGeneralQ\ @\ \((Blank | BlankNull | BlankSequence | 
                BlankNullSequence)\)[___]\  := \ \ True;\)\), "\
\[IndentingNewLine]", 
    \(\(patternToGeneralQ\ @\ \(HoldPattern[
              Pattern]\)[_, \
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptCapitalC]\[ScriptO]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptN]\[ScriptT]_\
]\  := \ \ patternToGeneralQ\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptN]\[ScriptT];\)\), "\[IndentingNewLine]", 
    \(\(patternToGeneralQ\ @\ 
          myHold[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptN]\
\[ScriptT]___] := 
        patternToGeneralQ\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptN]\[ScriptT];\)\), "\[IndentingNewLine]", 
    \(patternToGeneralQ\ @\ ___\  := \ False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["makeHeldSequenceOfBoxes and makeHeldRowBoxOfBoxes", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["makeHeldSequenceOfBoxes", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  " inserts commas (i.e. \"",
  StyleBox[",", "MR"],
  "\" ) between every boxed expression in the sequence of boxes given to ",
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  ".  ",
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  " holds its arguments."
}], "Text"],

Cell[BoxData[
    \(\(SetAttributes[{makeHeldSequenceOfBoxes, 
          makeHeldRowBoxOfBoxes}, {HoldAllComplete}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(makeHeldSequenceOfBoxes\ [\ {}, \ \ \ \ \ \ \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ None\ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        Sequence[];\)\), "\[IndentingNewLine]", 
    \(\(makeHeldSequenceOfBoxes\ [\ \
{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_}\ , \ \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ None\ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        MakeBoxes\ \ \ [\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\ ];\)\), "\[IndentingNewLine]", 
    \(\(makeHeldSequenceOfBoxes\ [\ \
{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_}\ , \ \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]_Symbol\ ]\ \ \  := \ 
        Parenthesize[\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]\ ];\)\), \
"\[IndentingNewLine]", 
    \(\(makeHeldSequenceOfBoxes\ [\ \
{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ 
          None]\ \ \  := \[IndentingNewLine]\(Sequence\  @@ \ 
              Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
                Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                    MakeBoxes[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], {HoldAll}]\  /@ \ 
                  Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, \
"\<,\>"}\)\);\)\n\t\t\t\), "\n", 
    \(\(makeHeldSequenceOfBoxes\ [\ \
{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]_Symbol\ ]\ \ \  \
:= \[IndentingNewLine]\(Sequence\  @@ \ 
              Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
                Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                    Parenthesize[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \
\ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\
\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]], {HoldAll}]\  /@ \ 
                  Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, \
"\<,\>"}\)\);\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["makeHeldRowBoxOfBoxes", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  " inserts commas (i.e. \"",
  StyleBox[",", "MR"],
  "\" ) between every boxed expression in the sequence of boxes given to ",
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  "; in addition it returns the result wrapped in a RowBox.   ",
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  " holds its arguments."
}], "Text"],

Cell[BoxData[{
    \(\(makeHeldRowBoxOfBoxes\ [\ {}, \ \ \ \ \ \ \ \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ None\ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        RowBox\ @\ {};\)\), "\[IndentingNewLine]", 
    \(\(makeHeldRowBoxOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_}\
\ , \ \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ 
          None\ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        MakeBoxes\ \ \ [\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\ ];\)\), "\[IndentingNewLine]", 
    \(\(makeHeldRowBoxOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_}\
\ , \ \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ \[ScriptP]\
\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptS]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]_\
Symbol\ ]\ \ \  := \ 
        Parenthesize[\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]\ ];\)\), \
"\[IndentingNewLine]", 
    \(\(makeHeldRowBoxOfBoxes\ [\ \
{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ 
          None]\ \ \  := \[IndentingNewLine]\(RowBox\ @\ 
              Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
                Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                    MakeBoxes[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], {HoldAll}]\  /@ \ 
                  Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, \
"\<,\>"}\)\);\)\n\t\t\t\), "\n", 
    \(\(makeHeldRowBoxOfBoxes\ [\ \
{\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]_Symbol\ ]\ \ \  \
:= \[IndentingNewLine]\(RowBox\ @\ 
              Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
                Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                    Parenthesize[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \
\ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\
\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]], {HoldAll}]\  /@ \ 
                  Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, \
"\<,\>"}\)\);\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["makeEvaluatedSequenceOfBoxes and makeEvaluatedRowBoxOfBoxes", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["makeEvaluatedSequenceOfBoxes", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  " inserts commas (i.e. \",\" ) between every boxed expression in the \
sequence of boxes given to ",
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  ".  ",
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  " evaluates its arguments."
}], "Text"],

Cell[BoxData[{
    \(\(makeEvaluatedSequenceOfBoxes\ [\ {}, \ \ \ \ \ \ \ \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ 
          None\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        Sequence[];\)\), "\[IndentingNewLine]", 
    \(\(makeEvaluatedSequenceOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]_}\ , \ \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ 
          None\ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        MakeBoxes\ \ \ [\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\ ];\)\), "\[IndentingNewLine]", 
    \(\(makeEvaluatedSequenceOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]_}\ , \ \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ \
\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\
\[ScriptY]_Symbol\ ]\ \ \  := \ 
        Parenthesize[\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]\ ];\)\), \
"\[IndentingNewLine]", 
    \(\(\(makeEvaluatedSequenceOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ 
        None]\ \ \  := \[IndentingNewLine]\(Sequence\  @@ \ 
            Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
              Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                  MakeBoxes[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], {HoldAll}]\  /@ \ 
                Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, "\
\<,\>"}\)\)\)\(\n\)
    \)\t\t\t\), "\n", 
    \(makeEvaluatedSequenceOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ \
\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\
\[ScriptY]_Symbol\ ]\ \ \  := \[IndentingNewLine]\(Sequence\  @@ \ 
            Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
              Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                  Parenthesize[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\
\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]], {HoldAll}]\  /@ \ 
                Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, "\
\<,\>"}\)\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  " inserts commas (i.e. \",\" ) between every boxed expression in the \
sequence of boxes given to ",
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  "; in addition it returns the result wrapped in a RowBox.   ",
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  " evaluates its arguments."
}], "Text"],

Cell[BoxData[{
    \(\(makeEvaluatedRowBoxOfBoxes\ [\ {}, \ \ \ \ \ \ \ \[ScriptF]\[ScriptO]\
\[ScriptR]\[ScriptM]_Symbol, \ 
          None\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        RowBox\ @\ {};\)\), "\n", 
    \(\(makeEvaluatedRowBoxOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]_}\ , \ \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ 
          None\ \ \ \ \ \ \ \ \ \ \ \ \ \ ]\ \ \  := \ 
        MakeBoxes\ \ \ [\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\ ];\)\), "\n", 
    \(\(makeEvaluatedRowBoxOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]_}\ , \ \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ \
\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\
\[ScriptY]_Symbol\ ]\ \ \  := \ 
        Parenthesize[\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]\ ];\)\), "\n", 
    \(\(makeEvaluatedRowBoxOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ 
          None]\ \ \  := \[IndentingNewLine]\(RowBox\ @\ 
              Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
                Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                    MakeBoxes[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], {HoldAll}]\  /@ \ 
                  Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, \
"\<,\>"}\)\);\)\n\t\t\t\), "\n", 
    \(\(makeEvaluatedRowBoxOfBoxes\ [\ {\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]___}\ , \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]_Symbol, \ \
\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptS]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\
\[ScriptY]_Symbol\ ]\ \ \  := \[IndentingNewLine]\(RowBox\ @\ 
              Drop[#, \(-1\)]\  &\)\ \ @\ \ \(Flatten\ \ @\ \ \(Thread\ \ @\
\[IndentingNewLine]{\ 
                Function[\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \ 
                    Parenthesize[\ \[ScriptT]\[ScriptE]\[ScriptR]\[ScriptM], \
\ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptS]\[ScriptI]\
\[ScriptZ]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptY]], {HoldAll}]\  /@ \ 
                  Unevaluated\ @\ {\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]}, \
"\<,\>"}\)\);\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Error checking for makeHeldSequenceOfBoxes", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  " expects three arguments."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldSequenceOfBoxes[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[\[ScriptN]\[ScriptU]\
\[ScriptM]\  == \ 1\ , \ 
              Message[makeHeldSequenceOfBoxes::argr, \ 
                HoldForm\ @\ makeHeldSequenceOfBoxes, 
                3], \ \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \
\[NotEqual] \ 3\ \ , \ 
              Message[makeHeldSequenceOfBoxes::argrx, 
                HoldForm\ @\ 
                  makeHeldSequenceOfBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
                3], \[IndentingNewLine]True, \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
False]];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 1st argument of ",
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  " must be a list."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldSequenceOfBoxes[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]_?\((headIsNot[
                  List])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[makeHeldSequenceOfBoxes::list, 
            HoldForm@\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 
            1];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 2nd argument of ",
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldSequenceOfBoxes[_, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeHeldSequenceOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 2];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 3rd argument of ",
  StyleBox["makeHeldSequenceOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldSequenceOfBoxes[_, _, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeHeldSequenceOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 3];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Error checking for makeHeldRowBoxOfBoxes", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  " expects three arguments."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldRowBoxOfBoxes[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[\[ScriptN]\[ScriptU]\
\[ScriptM]\  == \ 1\ , \ 
              Message[makeHeldRowBoxOfBoxes::argr, \ 
                HoldForm\ @\ makeHeldRowBoxOfBoxes, 
                3], \ \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \
\[NotEqual] \ 3\ \ , \ 
              Message[makeHeldRowBoxOfBoxes::argrx, 
                HoldForm\ @\ 
                  makeHeldRowBoxOfBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
                3], \[IndentingNewLine]True, \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
False]];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 1st argument of ",
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  " must be a list."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldRowBoxOfBoxes[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]_?\((headIsNot[
                  List])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[makeHeldRowBoxOfBoxes::list, 
            HoldForm@\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 
            1];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 2nd argument of ",
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldRowBoxOfBoxes[_, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeHeldRowBoxOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 2];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 3rd argument of ",
  StyleBox["makeHeldRowBoxOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeHeldRowBoxOfBoxes[_, _, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeHeldRowBoxOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 3];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Error checking for makeEvaluatedSequenceOfBoxes", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  " expects 3 arguments."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedSequenceOfBoxes[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[\[ScriptN]\[ScriptU]\
\[ScriptM]\  == \ 1\ , \ 
              Message[makeEvaluatedSequenceOfBoxes::argr, \ 
                HoldForm\ @\ makeEvaluatedSequenceOfBoxes, 
                3], \ \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \
\[NotEqual] \ 3\ \ , \ 
              Message[makeEvaluatedSequenceOfBoxes::argrx, 
                HoldForm\ @\ 
                  makeEvaluatedSequenceOfBoxes, \
\[ScriptN]\[ScriptU]\[ScriptM], 
                3], \[IndentingNewLine]True, \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
False]];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 1st argument of ",
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  " must be a list."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedSequenceOfBoxes[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]_?\((headIsNot[
                  List])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[makeEvaluatedSequenceOfBoxes::list, 
            HoldForm@\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 
            1];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 2nd argument of ",
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedSequenceOfBoxes[_, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeEvaluatedSequenceOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 2];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 3rd argument of ",
  StyleBox["makeEvaluatedSequenceOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedSequenceOfBoxes[_, _, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeEvaluatedSequenceOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 3];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Error checking for makeEvaluatedRowBoxOfBoxes", "NumberedSubsubtitle"],

Cell[TextData[{
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  " expects three arguments."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedRowBoxOfBoxes[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[\[ScriptN]\[ScriptU]\
\[ScriptM]\  == \ 1\ , \ 
              Message[makeEvaluatedRowBoxOfBoxes::argr, \ 
                HoldForm\ @\ makeEvaluatedRowBoxOfBoxes, 
                3], \ \[IndentingNewLine]\[ScriptN]\[ScriptU]\[ScriptM]\  \
\[NotEqual] \ 3\ \ , \ 
              Message[makeEvaluatedRowBoxOfBoxes::argrx, 
                HoldForm\ @\ 
                  makeEvaluatedRowBoxOfBoxes, \[ScriptN]\[ScriptU]\[ScriptM], 
                3], \[IndentingNewLine]True, \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
False]];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 1st argument of ",
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  " must be a list."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedRowBoxOfBoxes[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]_?\((headIsNot[
                  List])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[makeEvaluatedRowBoxOfBoxes::list, 
            HoldForm@\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 
            1];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 2nd argument of ",
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedRowBoxOfBoxes[_, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeEvaluatedRowBoxOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 2];\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 3rd argument of ",
  StyleBox["makeEvaluatedRowBoxOfBoxes", "MR"],
  " must be a symbol."
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          makeEvaluatedRowBoxOfBoxes[_, _, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]_?\((headIsNot[
                  Symbol])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            makeEvaluatedRowBoxOfBoxes::sym, \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB], 3];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolize Name Handling", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["operatorStringsToSymbolStrings", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(deleteMultipleUnderBrackets\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_\
String\  := \ 
        StringReplace[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG], "\<\
\[UnderBracket]\[UnderBracket]\>" \[Rule] "\<\[UnderBracket]\>"];\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(pruneEnclosingCharacters[\[ScriptS]\[ScriptT]\[ScriptR]_String\  /; \ 
            StringMatchQ[\[ScriptS]\[ScriptT]\[ScriptR], "\<\"\\[*]\"\>"]]\  \
:= \ StringDrop[StringDrop[\[ScriptS]\[ScriptT]\[ScriptR], \(-2\)], 
          3];\)\), "\[IndentingNewLine]", 
    \(\(pruneEnclosingCharacters\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]_\  := \ "\<\>";\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(convertNonLettersToFullNames\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_\
String\  := \ \[IndentingNewLine]StringJoin\ [\ 
          Characters[\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\ ]\  \
/. \[IndentingNewLine]\[ScriptS]\[ScriptT]\[ScriptR]_String\  /; \ \((\[Not] \
\ LetterQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\  \[And] \ \[Not] \ 
                      DigitQ\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\  \[And] \
\[ScriptS]\[ScriptT]\[ScriptR]\  \[NotEqual] \ "\<\[UnderBracket]\>")\)\  \
\[RuleDelayed] \ 
              pruneEnclosingCharacters\ @\ \(ToString\ @\ \(FullForm\ @\ \
\[ScriptS]\[ScriptT]\[ScriptR]\)\)];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(deletePossibleLeadingAndTrailingUnderBrackets\ @\ \
\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]_String := \[IndentingNewLine]Which[
          StringMatchQ[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG], "\<\
\[UnderBracket]*\[UnderBracket]\>"], \ 
          StringDrop[
            StringDrop[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG], 
              1], \(-1\)], \[IndentingNewLine]StringMatchQ[\[ScriptE]\
\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG], "\<\[UnderBracket]*\>"], \ \ StringDrop[\[ScriptE]\
\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG], 
            1], \[IndentingNewLine]StringMatchQ[\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG],\
 "\<*\[UnderBracket]\>"], \ \ StringDrop[\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG],\
 \(-1\)], \[IndentingNewLine]True, \ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]];\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\t\t\)\(\n\)\(operatorStringsToSymbolStrings\ @\ \[ScriptE]\
\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG]_String\  \
:= \[IndentingNewLine]deletePossibleLeadingAndTrailingUnderBrackets\ @\
\[IndentingNewLine]\(deleteMultipleUnderBrackets\ \
@\[IndentingNewLine]\(convertNonLettersToFullNames\ \
@\[IndentingNewLine]StringReplace[\t\t\
\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG], \[IndentingNewLine]{\[IndentingNewLine]"\< \
\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Space\[UnderBracket]\>", \
\[IndentingNewLine]"\<->\>"\ \  \[Rule] \ "\<\[UnderBracket]Rule\
\[UnderBracket]\>", \[IndentingNewLine]"\<:>\>"\ \  \[Rule] \ "\<\
\[UnderBracket]RuleDelayed\[UnderBracket]\>", \t\t\t\t\
\[IndentingNewLine]"\<:=\>"\ \  \[Rule] \ "\<\[UnderBracket]SetDelayed\
\[UnderBracket]\>", \[IndentingNewLine]"\<!\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Exclamation\[UnderBracket]\>", \[IndentingNewLine]"\<\"\>"\ \  \
\[Rule] \ "\<\[UnderBracket]DoubleQuote\[UnderBracket]\>", \
\[IndentingNewLine]"\<#\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Hash\
\[UnderBracket]\>", \[IndentingNewLine]"\<$\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Dollar\[UnderBracket]\>", \[IndentingNewLine]"\<%\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Percent\[UnderBracket]\>", \
\[IndentingNewLine]"\<&&\>"\ \  \[Rule] \ \
"\<\[UnderBracket]And\[UnderBracket]\>", \[IndentingNewLine]"\<&\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Ampersand\[UnderBracket]\>", \[IndentingNewLine]"\
\<'\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Quote\[UnderBracket]\>", \
\[IndentingNewLine]"\<(\>"\ \ \  \[Rule] \ "\<\[UnderBracket]LeftParenthesis\
\[UnderBracket]\>", \[IndentingNewLine]"\<)\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]RightParenthesis\[UnderBracket]\>", \[IndentingNewLine]"\<*\>"\
\ \ \  \[Rule] \ "\<\[UnderBracket]Times\[UnderBracket]\>", \
\[IndentingNewLine]"\<+\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Plus\
\[UnderBracket]\>", \[IndentingNewLine]"\<,\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Comma\[UnderBracket]\>", \[IndentingNewLine]"\<-\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Dash\[UnderBracket]\>", \
\[IndentingNewLine]"\<.\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Dot\
\[UnderBracket]\>", \[IndentingNewLine]"\</.\>"\ \  \[Rule] \ "\<\
\[UnderBracket]Replace\[UnderBracket]\>", \[IndentingNewLine]"\<//.\>"\  \
\[Rule] \ "\<\[UnderBracket]ReplaceRepeated\[UnderBracket]\>", \
\[IndentingNewLine]"\<//\>"\ \  \[Rule] \ "\<\[UnderBracket]BackAt\
\[UnderBracket]\>", \[IndentingNewLine]"\</;\>"\ \  \[Rule] \ "\<\
\[UnderBracket]Condition\[UnderBracket]\>", \[IndentingNewLine]"\</\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Slash\[UnderBracket]\>", \
\[IndentingNewLine]"\<:\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Colon\
\[UnderBracket]\>", \[IndentingNewLine]"\<;\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Semicolon\[UnderBracket]\>", \[IndentingNewLine]"\<<=\>"\ \  \
\[Rule] \ "\<\[UnderBracket]LessEqual\[UnderBracket]\>", \[IndentingNewLine]"\
\<<\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Less\[UnderBracket]\>", \
\[IndentingNewLine]"\<===\>"\  \[Rule] \ "\<\[UnderBracket]SameQ\
\[UnderBracket]\>", \[IndentingNewLine]"\<==\>"\ \  \[Rule] \ "\<\
\[UnderBracket]Equal\[UnderBracket]\>", \[IndentingNewLine]"\<=\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Set\[UnderBracket]\>", \
\[IndentingNewLine]"\<>=\>"\ \  \[Rule] \ "\<\[UnderBracket]GreaterEqual\
\[UnderBracket]\>", \[IndentingNewLine]"\<>\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Greater\[UnderBracket]\>", \[IndentingNewLine]"\<?\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Question\[UnderBracket]\>", \
\[IndentingNewLine]"\<@@\>"\ \  \[Rule] \ "\<\[UnderBracket]Apply\
\[UnderBracket]\>", \[IndentingNewLine]"\</@\>"\ \  \[Rule] \ "\<\
\[UnderBracket]Map\[UnderBracket]\>", \[IndentingNewLine]"\<@\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]At\[UnderBracket]\>", \[IndentingNewLine]"\<[\>"\ \
\ \  \[Rule] \ "\<\[UnderBracket]LeftBracket\[UnderBracket]\>", \
\[IndentingNewLine]"\<]\>"\ \ \  \[Rule] \ "\<\[UnderBracket]RightBracket\
\[UnderBracket]\>", \[IndentingNewLine]"\<\\\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Backslash\[UnderBracket]\>", \[IndentingNewLine]"\<^\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Wedge\[UnderBracket]\>", \
\[IndentingNewLine]"\<_\>"\ \ \  \[Rule] \ "\<\[UnderBracket]Underscore\
\[UnderBracket]\>", \[IndentingNewLine]"\<`\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]Backquote\[UnderBracket]\>", \[IndentingNewLine]"\<{\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]LeftBrace\[UnderBracket]\>", \[IndentingNewLine]"\
\<||\>"\ \  \[Rule] \ "\<\[UnderBracket]Or\[UnderBracket]\>", \
\[IndentingNewLine]"\<|\>"\ \ \  \[Rule] \ "\<\[UnderBracket]VerticalBar\
\[UnderBracket]\>", \[IndentingNewLine]"\<}\>"\ \ \  \[Rule] \ "\<\
\[UnderBracket]RightBrace\[UnderBracket]\>", \[IndentingNewLine]"\<~\>"\ \ \  \
\[Rule] \ "\<\[UnderBracket]Tilde\[UnderBracket]\>"}]\)\)\)\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["convertBoxesToStringRepresentation", "NumberedSubsubtitle"],

Cell[BoxData[
    \(convertBoxesToStringRepresentation[\[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_] := \[IndentingNewLine]operatorStringsToSymbolStrings\ \
@\ \(StringJoin\ @\ 
          Flatten[{\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]}\  \
//. \[IndentingNewLine]{\[IndentingNewLine]AdjustmentBox[\[ScriptA]_, ___]\  \
\[Rule] \ \[ScriptA], \[IndentingNewLine]ButtonBox[\[ScriptB]_, ___]\  \
\[Rule] \ \[ScriptB], \[IndentingNewLine]ErrorBox[\[ScriptB]_, ___]\ \  \
\[Rule] \ \[ScriptB], \[IndentingNewLine]FormBox[\[ScriptB]_, ___]\ \  \
\[Rule] \ \[ScriptB], \[IndentingNewLine]FractionBox[\[ScriptA]_, \
\[ScriptB]_, ___]\  \[Rule] \ {\[ScriptA], "\<\[UnderBracket]Over\
\[UnderBracket]\>", \[ScriptB]}, \[IndentingNewLine]FrameBox[\[ScriptB]_, \
___]\  \[Rule] \ \[ScriptB], \[IndentingNewLine]GridBox[\[ScriptA]\[ScriptR]\
\[ScriptG]\[ScriptS]_, ___]\ \  \[Rule] \ {\[ScriptA]\[ScriptR]\[ScriptG]\
\[ScriptS]}, \[IndentingNewLine]InterpretationBox[\[ScriptB]_, ___]\  \[Rule] \
\ \[ScriptB], \[IndentingNewLine]RadicalBox[\[ScriptA]_, \[ScriptB]_, ___]\  \
\[Rule] \ {\[ScriptA], "\<\[UnderBracket]Root\[UnderBracket]\>", \[ScriptB]}, \
\[IndentingNewLine]RowBox[\[ScriptA]_]\  \[Rule] \ \[ScriptA], \
\[IndentingNewLine]SqrtBox[\[ScriptA]_, ___] \[Rule] \ \
{"\<Sqrt\[UnderBracket]\>", \[ScriptA]}, \[IndentingNewLine]StyleBox[\
\[ScriptA]_, ___]\ \  \[Rule] \ \[ScriptA], \[IndentingNewLine]SubscriptBox[\
\[ScriptA]_, \[ScriptB]_, ___] \[Rule] \ {\[ScriptA], \
"\<\[UnderBracket]Subscript\[UnderBracket]\>", \[ScriptB]}, \
\[IndentingNewLine]SuperscriptBox[\[ScriptA]_, \[ScriptB]_, ___] \[Rule] \ {\
\[ScriptA], "\<\[UnderBracket]Superscript\[UnderBracket]\>", \[ScriptB]}, \
\[IndentingNewLine]SubsuperscriptBox[\[ScriptA]_, \[ScriptB]_, \[ScriptC]_, \
___]\  \[Rule] \ {\[ScriptA], "\<\[UnderBracket]Subsuperscript\[UnderBracket]\
\>", \[ScriptB], "\<\[UnderBracket]and\[UnderBracket]\>", \[ScriptC]}, \
\[IndentingNewLine]TagBox[\[ScriptB]_, ___]\  \[Rule] \ \[ScriptB], \
\[IndentingNewLine]UnderscriptBox[\[ScriptA]_, \[ScriptB]_] \[Rule] \ {\
\[ScriptA], "\<\[UnderBracket]Underscript\[UnderBracket]\>", \[ScriptB]}, \
\[IndentingNewLine]\ 
                OverscriptBox[\[ScriptA]_, \[ScriptB]_]\  \[Rule] \ {\
\[ScriptA], "\<\[UnderBracket]Overscript\[UnderBracket]\>", \[ScriptB]}, \
\[IndentingNewLine]UnderoverscriptBox[\[ScriptA]_, \[ScriptB]_, \[ScriptC]_]\ \
 \[Rule] \ {\[ScriptA], "\<\[UnderBracket]Underoverscript\[UnderBracket]\>", \
\[ScriptB], "\<\[UnderBracket]and\[UnderBracket]\>", \[ScriptC]}}]\)\)], \
"Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolize Implementation", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["setups before the Symbolize", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Wipe ",
  StyleBox["adjustedOptions", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "Wipe ",
  StyleBox["adjustedOptions", "MR"],
  ". This is purely a speed consideration, since ",
  StyleBox["AbsoluteOptions", "MR"],
  " takes so long to execute its value is cached for the duration of the \
calculation. "
}], "Text"],

Cell[BoxData[
    \(\(Symbolize[\[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalS]\[ScriptY]\
\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]___] /; \
\((silentEvaluate\ [\ adjustedOptions\ @\ Symbolize\  =. \ ]; 
            False)\)\  := \ $Failed;\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check Symbolize for parsing and valid  options.", "NumberedSubsubtitle",
  Background->GrayLevel[1]],

Cell["\<\
The condition /; True attached to some of the rules is to \
circumvent rule reordering bugs in Mathematica.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Handle ",
  StyleBox["RemoveSymbolize", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(RemoveSymbolize[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\
\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := 
      Symbolize[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], 
        Action -> 
          RemoveNotationRules, \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["Symbolize", "MR"],
  " statement must be created from the Palette."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE] : \ 
        Symbolize[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, ___]\  := \[IndentingNewLine]\((Message[Symbolize::noboxtag, 
            HoldForm\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\
\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\
\[ScriptE]]; \ $Failed)\) /; 
        Head\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]\  =!= \ NotationBoxTag\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Symbolize::noboxtag\  = \ "\<The Symbolize boxes `1` do not have an \
embedded NotationBoxTag TagBox. The Symbolize statement `2` may not have been \
entered using the palette, or the embedded TagBox may have been deleted. The \
embedded TagBox ensures correct parsing and retention of proper styling and \
grouping information.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The other arguments of ",
  StyleBox["Symbolize", "MR"],
  " must be options."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\  : 
        Symbolize[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, ___, \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]_, ___]\  \
:= \[IndentingNewLine]\((Message[Symbolize::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\
\[ScriptE]\ ]; $Failed)\) /; \[IndentingNewLine]Not\ @\ \(OptionQ\ @\ \
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Check that the ",
  StyleBox["Action", "MR"],
  " option is valid."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The value of option ",
  StyleBox["Action", "MR"],
  " should be valid."
}], "Text"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\  : 
        Symbolize[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, \ ___, \((Rule | RuleDelayed)\)[
            Action, \ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE]_], ___]\  := \ \((Message[
            Symbolize::optcrp, \ Action, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE], \ \ HoldForm\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\
\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]]; $Failed)\) /; 
        Not\ @\ MatchQ[\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE], 
            CreateNotationRules\  | \ RemoveNotationRules\  | \ 
              PrintNotationRules]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Symbolize::optcrp\  = \ "\<Value of option '`1` \[Rule] `2`\' in `3` \
should be CreateNotationRules, RemoveNotationRules or PrintNotationRules.\>";\
\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Check not wrapped by ",
  StyleBox["RowBox", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The boxes to be symbolized must also not have a head of ",
  StyleBox["RowBox", "MR"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(\(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\  : 
        Symbolize[\ 
          NotationBoxTag\ [\ 
            RowBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]___, \
___], \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]\((Message[Symbolize::rowboxh, \ 
            identityForm\  @@ \ {RowBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]}, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\
\[ScriptE]]; \ $Failed)\) /; \ True\)\(\n\)
    \)\), "\n", 
    \(\(Symbolize::rowboxh\  = \[IndentingNewLine]"\<The box structure '`1`' \
in `2` is not of the right form. Structures to be symbolized cannot have a \
RowBox as their head. Examine the full box structures for possible unintended \
groupings.\>";\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell["Options have all been checked and are o.k.", "NumberedSubsubsubtitle"]
}, Closed]],

Cell[CellGroupData[{

Cell["check form of the patterns in the Symbolize", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["boxes  too general", "NumberedSubsubsubtitle"],

Cell["The boxes to be symbolized must not be too General.", "Text"],

Cell[BoxData[
    \(\(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\  : 
          Symbolize[\ 
            NotationBoxTag\ [\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, ___], \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] := \ \
\[IndentingNewLine]With[{\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]\ \ \  = \ 
              boxedStringPatternsToPatterns\ [\[IndentingNewLine]cleanBoxes\ \
@\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \(WorkingForm\  \
\[Rule] \ 
                      WorkingForm\ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]}\)\  /. \ adjustedOptions\ @\ 
                    Symbolize\ ]\ }, \[IndentingNewLine]\((Message[
                Symbolize::ptogen, \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], 
                identityForm\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], 
                HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\
\[ScriptE]]; $Failed)\) /; \[IndentingNewLine]patternToGeneralQ\ @\ \
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]]\
;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Symbolize::ptogen\  = \[IndentingNewLine]"\<The pattern `1` appearing \
in the symbolize statement Symbolize[`2`] is too general to be \
used.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["Symbolize", "MR"],
  " is o.k."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The ",
  StyleBox["Symbolize", "MR"],
  " has been correctly parsed and checked. Now create the symbolization."
}], "Text"],

Cell[BoxData[
    \(Symbolize[\ \
\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\
\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] := \[IndentingNewLine]With[{\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  = \ 
            stripNotationBoxTag\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\
\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]}, \[IndentingNewLine]\(createSymbolize[\
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]];\)]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["unknown error", "NumberedSubsubsubtitle"],

Cell["\<\
Have encountered an unknown error in symbolization parsing... \
Report it!\
\>", "Text"],

Cell[BoxData[{
    \(\(\(Symbolize[\[ScriptA]\[ScriptL]\[ScriptL]___]\  \
:= \[IndentingNewLine]\((Message[Symbolize::unknpars, \ 
            identityForm\  @@ \ {{\[ScriptA]\[ScriptL]\[ScriptL]}}]; \
\[IndentingNewLine]CellPrint[
            Cell[BoxData[\ 
                colorizeStructuralBoxes[\ \[ScriptA]\[ScriptL]\[ScriptL]\ , \ 
                  1]], "\<Output\>"]]; $Failed)\);\)\(\n\)
    \)\), "\n", 
    \(\(Symbolize::unknpars\  = \ "\<Unknown error occurred in parsing the \
Symbolize definition `1`. Please report this to jasonh@wri.com, Please \
carefully examine the following box structures for spurious characters, weird \
groupings etc.\>";\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Definition of Symbolize containing patterns.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["createSymbolize", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["createSymbolize", "MR"],
  " handles the symbolization of boxes containing a pattern."
}], "Text"],

Cell[BoxData[
    \(createSymbolize\ [\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\ \
, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]With[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \ \ \ \ \ \ \ \ \
\ \ \  = \ \(WorkingForm\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Symbolize, \[IndentingNewLine]\[ScriptCapitalA]\[ScriptC]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\
\ \ \ \ \ \ \ \  = \ \(Action\ \ \ \ \ \ \  /. \ {\[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Symbolize}, \[IndentingNewLine]With[{\[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\ \ \  = \ 
              boxedStringPatternsToPatterns\ [\ 
                cleanBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ 
                WorkingForm\  \[Rule] \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\
\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ ]\ }, \
\[IndentingNewLine]\(If[
              FreeQ[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], 
                Pattern | Blank | BlankNull | BlankSequence | 
                  BlankNullSequence], \
\[IndentingNewLine]createSymbolizeSingleInstance\ [\ \[ScriptB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]], \
\[IndentingNewLine]executeSymbolizeAction[\[IndentingNewLine]myHold\ @\ 
                  NotationMakeExpression[\[ScriptM]\[ScriptA]\[ScriptT]\
\[ScriptC]\[ScriptH]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]\  : \ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]], \[IndentingNewLine]myHold\ [
                  createSymbolizeSingleInstance[\ \[ScriptM]\[ScriptA]\
\[ScriptT]\[ScriptC]\[ScriptH]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]; \
\[IndentingNewLine]\ 
                  MakeExpression[\[ScriptM]\[ScriptA]\[ScriptT]\[ScriptC]\
\[ScriptH]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\ ], \[IndentingNewLine]\
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT], \ \[ScriptCapitalA]\[ScriptC]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]];\)]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["executeSymbolizeAction", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["executeSymbolizeAction", "MR"],
  " enters, removes or prints the symbolization statement depending on \
action."
}], "Text"],

Cell[BoxData[
    \(executeSymbolizeAction[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \ \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        CreateNotationRules] := \ 
      releaseMyHold[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  := \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\ ]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(executeSymbolizeAction[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \ \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        RemoveNotationRules] := \ 
      releaseMyHold[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  =. \ ]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(executeSymbolizeAction[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \ \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
          PrintNotationRules] := \[IndentingNewLine]releaseMyHold\ @\ \
\(CellPrint\ @\ 
            Cell[\ BoxData\ @\ 
                MakeBoxes[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  := \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL], \ StandardForm], "\<Output\>", 
              ShowStringCharacters -> True]\);\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Definition of Symbolize without patterns.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["createSymbolizeSingleInstance", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["createSymbolizeSingleInstance", "MR"],
  " sets up ",
  StyleBox["MakeExpression", "MR"],
  " & ",
  StyleBox["MakeBoxes", "MR"],
  " rules for a given symbol without patterns in it."
}], "Text"],

Cell[BoxData[
    \(createSymbolizeSingleInstance\ [\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ]\  := \[IndentingNewLine]With[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \ \ \ \ \ \ \ \ \
\ \ \  = \ \(WorkingForm\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Symbolize, \[IndentingNewLine]\[ScriptCapitalS]\[ScriptY]\
\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\
\[ScriptCapitalR]\[ScriptO]\[ScriptO]\[ScriptT]\[ScriptCapitalN]\[ScriptA]\
\[ScriptM]\[ScriptE]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \ \ \  = \ \
\(SymbolizeRootName\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Symbolize, \[IndentingNewLine]\[ScriptCapitalA]\[ScriptC]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  = \ \(Action\ \ \ \ \ \
\ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Symbolize}, \[IndentingNewLine]With[{\[ScriptN]\[ScriptE]\
\[ScriptW]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\ \ \  = \
\[IndentingNewLine]If[\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\
\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\[ScriptE]\[ScriptCapitalR]\[ScriptO]\
\[ScriptO]\[ScriptT]\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]\  === \ "\<\>", 
                convertBoxesToStringRepresentation\ @\ \(cleanBoxes\ @\ \
\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\), \ \[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptI]\[ScriptZ]\
\[ScriptE]\[ScriptCapitalR]\[ScriptO]\[ScriptO]\[ScriptT]\[ScriptCapitalN]\
\[ScriptA]\[ScriptM]\[ScriptE]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, \
\[IndentingNewLine]executeSymbolizeSingleInstanceAction[\ \
\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptN]\[ScriptE]\
\[ScriptW]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\[ScriptCapitalS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG], \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT], \ \[ScriptCapitalA]\[ScriptC]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\[IndentingNewLine]]\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["executeSymbolizeSingleInstanceAction", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["executeSymbolizeSingleInstanceAction", "MR"],
  " enters, removes or prints the single symbolization instance depending on \
action."
}], "Text"],

Cell[BoxData[
    \(executeSymbolizeSingleInstanceAction[\[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_\ , \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        CreateNotationRules] := \[IndentingNewLine]With[{\[ScriptN]\[ScriptE]\
\[ScriptW]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\  = If[Names[\[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\[ScriptY]\
\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]]\  \[NotEqual] \ {}, \
\[IndentingNewLine]Message[Symbolize::bsymbexs]; 
              Unique[\[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\[ScriptY]\
\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG] <> \ "\<$\>"], 
              Symbol\ @\ \[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]]}, \[IndentingNewLine]releaseMyHold[\
\[IndentingNewLine]NotationMakeExpression[
              stripStylingBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]] := \ 
            HoldComplete\ @\ \[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]; \
\[IndentingNewLine]NotationMakeBoxes[\[ScriptN]\[ScriptE]\[ScriptW]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL], \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]]\  := \ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]; \
\[IndentingNewLine]symbolizedTable\ @\ \[ScriptN]\[ScriptE]\[ScriptW]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\  := {\
\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]}; \
\[IndentingNewLine]HoldComplete\ @\ \[ScriptN]\[ScriptE]\[ScriptW]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]]]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(executeSymbolizeSingleInstanceAction[\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_\ , \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        RemoveNotationRules] := \[IndentingNewLine]silentEvaluate\ @\
\[IndentingNewLine]With[{\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\
\[ScriptL]\  = \ 
              myHold\  @@ \ 
                MakeExpression[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, \[IndentingNewLine]releaseMyHold[\
\[IndentingNewLine]NotationMakeExpression[
                stripStylingBoxes\ @\ \
\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  =. \ \ \
; \[IndentingNewLine]NotationMakeBoxes[\[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\
\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  =. \ ; \
\[IndentingNewLine]symbolizedTable\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\  =. ]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(executeSymbolizeSingleInstanceAction[\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\
\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]_\ , \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        PrintNotationRules] := \[IndentingNewLine]With[{\[ScriptN]\[ScriptE]\
\[ScriptW]\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\
\  = Symbol\ @\ \[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalS]\[ScriptY]\
\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]\[ScriptCapitalS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG], \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptP]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]\  = \ 
            stripStylingBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]}, \[IndentingNewLine]releaseMyHold[\[IndentingNewLine]CellPrint\ @\
\[IndentingNewLine]Cell[
              BoxData\ @\ 
                MakeBoxes[
                  NotationMakeExpression[\[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptP]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]] := \ 
                    HoldComplete\ @\ \[ScriptN]\[ScriptE]\[ScriptW]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL], \ 
                  StandardForm], "\<Output\>", 
              ShowStringCharacters -> True]; \[IndentingNewLine]CellPrint\ @\ 
            Cell[BoxData\ @\ 
                MakeBoxes[
                  NotationMakeBoxes[\[ScriptN]\[ScriptE]\[ScriptW]\
\[ScriptCapitalS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL], \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]]\  := \ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ 
                  StandardForm], "\<Output\>", \ 
              ShowStringCharacters -> True];]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Symbolize::bsymbexs\  = \[IndentingNewLine]"\<Warning: The box \
structure attempting to be symbolized has a similar or identical symbol \
already defined, possibly overriding previously symbolized box structure.\>";\
\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Modify ",
  StyleBox["Remove", "MR"],
  " for symbolized symbols."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "Modify ",
  StyleBox["Remove", "MR"],
  " to take into account the removal of ",
  StyleBox["MakeExpression", "MR"],
  " & ",
  StyleBox["MakeBoxes", "MR"],
  " rules for a symbolized symbol."
}], "Text"],

Cell[BoxData[{
    \(\(wasProtected\  = \ Unprotect\ @\ Remove;\)\), "\[IndentingNewLine]", 
    \(\(Remove\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\
\[ScriptL]_ /; \ 
          ValueQ\ @\ \(symbolizedTable\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\)\ \ \  := \[IndentingNewLine]With[{\[ScriptB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  = \ \((symbolizedTable\ @\ \
\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL])\)\
\[LeftDoubleBracket]1\[RightDoubleBracket], \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\  = \
\((symbolizedTable\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\
\[ScriptL])\)\[LeftDoubleBracket]2\[RightDoubleBracket]}, \
\[IndentingNewLine]NotationMakeExpression[
              stripStylingBoxes\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  =. \ ; \
\[IndentingNewLine]NotationMakeBoxes[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\
\[ScriptO]\[ScriptL], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  =. \ ; \
\[IndentingNewLine]symbolizedTable\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]\[ScriptO]\[ScriptL]\  =. ; \[IndentingNewLine]ClearAll\ @\ \
\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\[ScriptO]\[ScriptL]; \
\[IndentingNewLine]Remove\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]\
\[ScriptO]\[ScriptL]];\)\), "\[IndentingNewLine]", 
    \(\(SetAttributes[Remove, ReadProtected];\)\), "\[IndentingNewLine]", 
    \(\(Protect\ @\ \(Evaluate\ @\ wasProtected\);\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(SetAttributes[symbolizedTable, HoldAll];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolize Error Handling Catch All", "NumberedSubsubtitle"],

Cell[TextData[{
  "Have encountered an unknown error in ",
  StyleBox["Symbolize", "MR"],
  " checking... Report it!"
}], "Text"],

Cell[BoxData[
    \(\(createSymbolize[\[ScriptA]\[ScriptL]\[ScriptL]_, \[ScriptO]\[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptR]___]\  := \((\[IndentingNewLine]Message[
            Symbolize::unknproc]; \[IndentingNewLine]CellPrint[
            Cell[BoxData[\ 
                colorizeStructuralBoxes[\ \[ScriptA]\[ScriptL]\[ScriptL]\ , \ 
                  1]], "\<Output\>"]]; \[IndentingNewLine]HoldComplete\ @\ \
\(Symbol\ @\ "\<$Failed\>"\))\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Symbolize::unknproc\  = \[IndentingNewLine]"\<Unknown error occurred \
in processing the Symbolize definition.  \t\tPlease report this to \
jasonh@wri.com, Please carefully examine the following box structures for \
spurious characters, weird groupings etc.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InfixNotation Implementation", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["setups before the InfixNotation", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Wipe ",
  StyleBox["adjustedOptions", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "Wipe ",
  StyleBox["adjustedOptions", "MR"],
  ". This is purely a speed consideration, since ",
  StyleBox["AbsoluteOptions", "MR"],
  " takes so long to execute its value is cached for the duration of the \
calculation. "
}], "Text"],

Cell[BoxData[
    \(InfixNotation[\[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalI]\[ScriptN]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]___] /; \((silentEvaluate\ [\ 
            adjustedOptions\ @\ InfixNotation\  =. \ ]; 
          False)\)\  := \ $Failed\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check InfixNotation for parsing and valid  options.", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Handle ",
  StyleBox["RemoveInfixNotation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(RemoveInfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \ \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := 
      InfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS],\
 \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\
\[ScriptE]\[ScriptA]\[ScriptD], 
        Action -> 
          RemoveNotationRules, \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["InfixNotation", "MR"],
  " statement must be created from the palette."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        InfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, ___]\  := \ \[IndentingNewLine]\((Message[InfixNotation::noboxtag, 
            HoldForm\ @\ \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS],\
 \ HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ $Failed)\) \
/; \[IndentingNewLine]Head\ @\ \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]\  =!= \ NotationBoxTag\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(InfixNotation::noboxtag\  = \ "\<The InfixNotation boxes `1` do not \
have an embedded NotationBoxTag TagBox. The InfixNotation statement `2` may \
not have been entered using the palette, or the embedded TagBox may have been \
deleted. The embedded TagBox ensures correct parsing and retention of proper \
styling and grouping information.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The other arguments of ",
  StyleBox["InfixNotation", "MR"],
  " must be options."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        InfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \ ___, \[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]_, ___]\  := \[IndentingNewLine]\((Message[InfixNotation::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ $Failed)\) \
/; \[IndentingNewLine]Not\ @\ \(OptionQ\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\)\)], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Check that the ",
  StyleBox["Action", "MR"],
  " option is valid."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The value of option ",
  StyleBox["Action", "MR"],
  " should be valid."
}], "Text"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        InfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, ___, \((Rule | 
                RuleDelayed)\)[
            Action, \ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE]_], ___]\  := \ \
\[IndentingNewLine]\((Message[InfixNotation::optcrp, \ Action, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; $Failed)\) \
/; \[IndentingNewLine]Not\ @\ 
          MatchQ[\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\[ScriptA]\
\[ScriptL]\[ScriptU]\[ScriptE], 
            CreateNotationRules\  | \ RemoveNotationRules\  | \ 
              PrintNotationRules]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(InfixNotation::optcrp\  = \ "\<Value of option '`1` \[Rule] `2`' in \
`3` should be CreateNotationRules, RemoveNotationRules or PrintNotationRules.\
\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Check not wrapped by ",
  StyleBox["RowBox", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The boxes to be ",
  StyleBox["InfixNotation", "MR"],
  " must also not have a head of ",
  StyleBox["RowBox", "MR"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(\(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN] : \ 
        InfixNotation[\ \ NotationBoxTag\ [\ 
            RowBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]___, \
___], \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___] := \ \[IndentingNewLine]\((Message[
            InfixNotation::rowboxh, \ 
            identityForm\  @@ \ {RowBox\ @\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]}, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ $Failed)\) /; 
        True\)\(\n\)
    \)\), "\n", 
    \(\(InfixNotation::rowboxh\  = \[IndentingNewLine]"\<The InfixNotation \
box structure '`1`' is not of the right form. Structures to be used as an \
infix operator cannot have a RowBox as their head. Examine the full box \
structures of `2` for possible unintended groupings.\>";\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The prefixHead argument to ",
  StyleBox["InfixNotation", "MR"],
  " must be a symbol."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(\(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN] : 
        InfixNotation[\ 
          NotationBoxTag\ [\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, ___], \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_\
, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] := \ \
\[IndentingNewLine]\((Message[InfixNotation::bprfxh, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalP]\
\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\
\[ScriptA]\[ScriptD], \ 
            identityForm\  @@ \ {\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]}, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ $Failed)\) \
/; \[IndentingNewLine]Head\ @\ \
\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]\  =!= \ 
          Symbol\)\(\n\)
    \)\), "\n", 
    \(\(InfixNotation::bprfxh\  = \[IndentingNewLine]"\<In `3`, the prefix \
head '`1`' corresponding to the infix operator '`2`' is not a \
symbol.\>";\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["InfixNotation", "MR"],
  " is ok. Create the ",
  StyleBox["InfixNotation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The ",
  StyleBox["InfixNotation", "MR"],
  " has been correctly parsed and checked. Now create the ",
  StyleBox["InfixNotation", "MR"],
  "."
}], "Text"],

Cell[BoxData[
    \(InfixNotation[\ \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]___] := \[IndentingNewLine]With[{\ \[ScriptI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  = \ \ stripNotationBoxTag\ @\ \
\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]}, \
\[IndentingNewLine]\(createInfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], \ \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]];\)\[IndentingNewLine]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Have encountered an unknown error in ",
  StyleBox["InfixNotation", "MR"],
  " parsing... Report it!"
}], "NumberedSubsubsubtitle"],

Cell[BoxData[{
    \(\(\(InfixNotation[\[ScriptA]\[ScriptL]\[ScriptL]_, \[ScriptO]\[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptR]___]\  := \[IndentingNewLine]\((Message[
            InfixNotation::unknpars, \ 
            identityForm\  @@ \ {\[ScriptA]\[ScriptL]\[ScriptL]}]; \
\[IndentingNewLine]CellPrint[
            Cell[BoxData[\ 
                colorizeStructuralBoxes[\ \[ScriptA]\[ScriptL]\[ScriptL]\ , \ 
                  1]], "\<Output\>"]]; $Failed)\);\)\(\n\)
    \)\), "\n", 
    \(\(InfixNotation::unknpars\  = \ "\<Unknown error occurred in parsing \
the InfixNotation definition `1`. Please report this to jasonh@wri.com, \
Please carefully examine the following box structures for spurious characters \
weird groupings etc.\>";\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Definition of ",
  Cell[BoxData[
      \(TraditionalForm\`InFixNotation[\ infixOp, prefixOp, precedence, \ 
        opts\ ]\)]]
}], "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["createInfixNotation", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["createInfixNotation", "MR"],
  " creates the ",
  StyleBox["MakeExpression", "MR"],
  " and ",
  StyleBox["MakeBoxes", "MR"],
  " rules that create the infix notation."
}], "Text"],

Cell[BoxData[
    \(createInfixNotation[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ]\  := \[IndentingNewLine]With[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \  = \ \
\(WorkingForm\ \ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                InfixNotation, \[IndentingNewLine]\[ScriptCapitalA]\[ScriptC]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\
\ \ \ \ \ \ \ \ \ \ \ \ \ \  = \ \(Action\ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ \
{\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                InfixNotation}, \
\[IndentingNewLine]executeInfixNotationAction[\[ScriptI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP], \[ScriptP]\[ScriptR]\[ScriptE]\
\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD],\
 \ effectiveOperator\ @\ \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT], \ \
\[ScriptCapitalA]\[ScriptC]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["executeInfixNotationAction", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["executeInfixNotationAction", "MR"],
  " enters, removes or prints the ",
  StyleBox["InfixNotation", "MR"],
  " statement depending on action."
}], "Text"],

Cell[BoxData[
    \(executeInfixNotationAction[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \
\[ScriptG]\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptE]\[ScriptD]\
\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE]_\ , \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        CreateNotationRules] := \((\[IndentingNewLine]NotationMakeExpression[
              RowBox\ @\ \[ScriptA]_, \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\
\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  /; \ 
            MemberQ[\[ScriptA], \ \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]]\  := \ \[IndentingNewLine]MakeExpression[
              parseFlatInfix[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], \ \
\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP], \ \
\[ScriptA]], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]] /; 
            appearsInfix[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP], \[ScriptA]]; \[IndentingNewLine]NotationMakeBoxes[\
\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\
\[ScriptE]\[ScriptA]\[ScriptD]\ [\ \[ScriptA]\[ScriptR]\[ScriptG]1_, \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]__], \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]] \
:= \[IndentingNewLine]\(RowBox\ @\ 
                padList[#, \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]]\  &\)\ @\[IndentingNewLine]\((\(Parenthesize[#, \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT], \[ScriptG]\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptE]\
\[ScriptD]\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE]]\  &\)\  /@ \ \
\(Unevaluated\  /@ \ 
                  Unevaluated\ @\ {\[ScriptA]\[ScriptR]\[ScriptG]1, \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]}\))\);)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(executeInfixNotationAction[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \
\[ScriptG]\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptE]\[ScriptD]\
\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE]_\ , \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        RemoveNotationRules] := \[IndentingNewLine]silentEvaluate\ @\((\
\[IndentingNewLine]NotationMakeExpression[
                RowBox\ @\ \[ScriptA]_, \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  /; \ 
              MemberQ[\[ScriptA], \ \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]]\  =. ; \[IndentingNewLine]NotationMakeBoxes[\
\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\
\[ScriptE]\[ScriptA]\[ScriptD]\ [\ \[ScriptA]\[ScriptR]\[ScriptG]1_, \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]__], \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]] =. ;)\)\)], "Input",\

  InitializationCell->True],

Cell[BoxData[
    \(executeInfixNotationAction[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]_, \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \
\[ScriptG]\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptE]\[ScriptD]\
\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE]_\ , \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]_, \ 
        PrintNotationRules] := \((\[IndentingNewLine]CellPrint[
          Cell[BoxData[\ 
              MakeBoxes[\[IndentingNewLine]NotationMakeExpression[
                      RowBox\ @\ \[ScriptA]_, \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\  /; \ 
                    MemberQ[\[ScriptA], \ \[ScriptI]\[ScriptN]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]]\  := 
                  MakeExpression[
                      parseFlatInfix[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], \ \
\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP], \ \
\[ScriptA]], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]] /; 
                    appearsInfix[\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP], \[ScriptA]], StandardForm]], "\<Output\>", 
            ShowStringCharacters -> True]]; \[IndentingNewLine]CellPrint[
          Cell[BoxData[\ 
              MakeBoxes[\[IndentingNewLine]MakeBoxes[\[ScriptP]\[ScriptR]\
\[ScriptE]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\
\[ScriptD]\ [\ \[ScriptA]\[ScriptR]\[ScriptG]1_, \[ScriptA]\[ScriptR]\
\[ScriptG]\[ScriptS]__], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]] := \[IndentingNewLine]\(RowBox\ @\ 
                        padList[#, \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptO]\[ScriptP]]\  &\)\ @\ \((\(Parenthesize[#, \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT], \[ScriptG]\[ScriptR]\[ScriptO]\[ScriptU]\[ScriptP]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptE]\
\[ScriptD]\[ScriptE]\[ScriptN]\[ScriptC]\[ScriptE]]\  &\)\  /@ \ \
\(Unevaluated\  /@ \ 
                          Unevaluated\ @\ {\[ScriptA]\[ScriptR]\[ScriptG]1, \
\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]}\))\), StandardForm]], "\<Output\>", 
            ShowStringCharacters -> True]];)\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["parseFlatInfix", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["parseFlatInfix", "MR"],
  " parses a chain of operands separated by the infix operator"
}], "Text"],

Cell["\<\
Note the following coding semi breaks the style of the rest of the \
notebook somewhat but the algorithim needs to be this way due to speed.\
\>", \
"Text"],

Cell[BoxData[
    \(\(SetAttributes[{parseFlatInfix, parseFlatInfixAux}, 
        HoldAll];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(parseFlatInfix[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \ \[ScriptI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]_, \ \
{\[ScriptL]___, \[ScriptF]\[ScriptI]\[ScriptR]\[ScriptS]\[ScriptT]_?
            notWhiteSpaceQ, ___?
            whiteSpaceQ, \[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\
\[ScriptO]\[ScriptP]_, ___?whiteSpaceQ, \[ScriptB]_?
            notWhiteSpaceQ, \[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]___}] := 
      parseFlatInfixAux[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], \ \[ScriptI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP], \ \[ScriptF]\
\[ScriptI]\[ScriptR]\[ScriptS]\[ScriptT], {\[ScriptL]}, {\ \[ScriptB], \
\[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(parseFlatInfixAux[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \ \[ScriptI]\
\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP]_, \ \[ScriptF]\
\[ScriptI]\[ScriptR]\[ScriptS]\[ScriptT]_, {\[ScriptL]___}, {\ \[ScriptR]\
\[ScriptE]\[ScriptS]\[ScriptT]___}] \
:= \[IndentingNewLine]Block[{parseOperator, parseArgument, 
            returnAnswer}, \[IndentingNewLine]SetAttributes[{parseOperator, 
              parseArgument}, 
            HoldAll]; \[IndentingNewLine]parseOperator[_?
                whiteSpaceQ, \ \[ScriptR]___] := 
            parseOperator\ @\ \[ScriptR]; \[IndentingNewLine]parseOperator[\
\[ScriptI]\[ScriptN]\[ScriptF]\[ScriptI]\[ScriptX]\[ScriptO]\[ScriptP], \ \
\[ScriptR]___] := 
            parseArgument\ @\ \[ScriptR]; \[IndentingNewLine]parseArgument[_?
                whiteSpaceQ, \ \[ScriptR]___] := 
            parseArgument\ @\ \[ScriptR]; \[IndentingNewLine]parseArgument[\
\[ScriptA]_, \[ScriptR]___] := 
            Sequence[\ \[ScriptA], 
              parseOperator\ @\ \[ScriptR]]; \[IndentingNewLine]returnAnswer\ \
@\ {\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptS]\[ScriptE]\[ScriptD]__, 
                parseOperator\ @\ \[ScriptR]___}\  := \ 
            returnFormatedOutput[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], \ {\
\[ScriptL]}, \ \
{\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptS]\[ScriptE]\[ScriptD]}, \
{\[ScriptR]}]; \[IndentingNewLine]returnAnswer\ @\ 
            Block[{$RecursionLimit = \[Infinity]}, {\[ScriptF]\[ScriptI]\
\[ScriptR]\[ScriptS]\[ScriptT], 
                parseArgument\ @\ \
\[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]}]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(appearsInfix[\[ScriptO]\[ScriptP]_, {___, _?notWhiteSpaceQ, ___?
            whiteSpaceQ, \[ScriptO]\[ScriptP]_, ___?whiteSpaceQ, _?
            notWhiteSpaceQ, ___}] := True\), "\[IndentingNewLine]", 
    \(appearsInfix\ @\ _\  := False\)}], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(\(returnFormatedOutput[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \ {\
\[ScriptL]___}, \ {\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptS]\[ScriptE]\
\[ScriptD]__}, {\[ScriptR]___}] := \[IndentingNewLine]RowBox\ @\ {\[ScriptL], 
            RowBox\ @{\ 
                ToString\ @\ \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\
\[ScriptI]\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], "\<[\>", 
                RowBox\ @\ 
                  padList[{\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptS]\[ScriptE]\
\[ScriptD]}, "\<,\>"], \ "\<]\>"}, \ \[ScriptR]}\  /; \ {\[ScriptL], \
\[ScriptR]} =!= {}\)\(\n\)
    \)\), "\n", 
    \(returnFormatedOutput[\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD]_, \ \
{\[ScriptL]___}, \ {\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptS]\[ScriptE]\
\[ScriptD]__}, {\[ScriptR]___}] := 
      RowBox\ @{\ 
            ToString\ @\ \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptF]\[ScriptI]\
\[ScriptX]\[ScriptCapitalH]\[ScriptE]\[ScriptA]\[ScriptD], "\<[\>", 
            RowBox\ @\ 
              padList[{\[ScriptP]\[ScriptA]\[ScriptR]\[ScriptS]\[ScriptE]\
\[ScriptD]}, "\<,\>"], \ "\<]\>"}\  /; \ {\[ScriptL], \[ScriptR]} === {}\)}], \
"Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["AddInputAlias and ActiveInputAliases Implementation", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["\<\
Check AddInputAlias for parsing and valid  options. (Legacy case of \
two argument form.)\
\>", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["AddInputAlias", "MR"],
  " statement must be created from the palette."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, ___]\  := \ \((Message[
            AddInputAlias::noboxtag, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; \ $Failed)\) /; \[IndentingNewLine]\(! MatchQ[
            Head\ @\ \
\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ NotationBoxTag | \ List | Rule]\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::noboxtag\  = \ "\<The InputAliasBoxes boxes `1` do not \
have an embedded NotationBoxTag TagBox. The AddInputAlias statement `2` may \
not have been entered using the palette, or the embedded TagBox may have been \
deleted. The embedded TagBox ensures correct parsing and retention of proper \
styling and grouping information.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The second argument of ",
  StyleBox["AddInputAlias", "MR"],
  " must be a string."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[\[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_NotationBoxTag, \[ScriptB]\[ScriptA]\
\[ScriptD]\[ScriptCapitalS]\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_, ___] := \((Message[
            AddInputAlias::bshfrm, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; \ $Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\  =!= \ String\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::bshfrm\  = \ "\<The short form `1` in the \
AddInputAlias statement `2` is not a string.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The third argument of ",
  StyleBox["AddInputAlias", "MR"],
  " must be a notebook object."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[\[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_NotationBoxTag, \[ScriptS]\[ScriptH]\
\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_\
String, \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]_] \
:= \[IndentingNewLine]\((Message[AddInputAlias::badnb, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; $Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]\  =!= \ NotebookObject\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::badnb\  = \ "\<The third argument of `2` is not a \
notebook object.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Check AddInputAlias for parsing and valid  options. (in rule \
form)\
\>", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["validAliasRule", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["validAliasRule", "MR"],
  " checkes to se wheather the given argument is a valid input alias rule \
before processing."
}], "Text"],

Cell[BoxData[{
    \(\(validAliasRule\ @\ \(HoldPattern[Rule]\)[_String, _NotationBoxTag] := 
        True;\)\), "\[IndentingNewLine]", 
    \(validAliasRule\ @\ _\  := False\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The first argument of ",
  StyleBox["AddInputAlias", "MR"],
  " (in rule form) must be a string."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptH]\
\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_\
 \[Rule] \[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_NotationBoxTag, ___] \
:= \[IndentingNewLine]\((Message[AddInputAlias::bshfrm, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; \ $Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalS]\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\  =!= \ String\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::bshfrm\  = \ "\<The short form `1` in the \
AddInputAlias statement `2` is not a string.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["AddInputAlias", "MR"],
  " statement (in rule form) must be created from the palette."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[_ \[Rule] \
\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, ___]\  := \ \[IndentingNewLine]\((Message[
            AddInputAlias::noboxtag, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; \ $Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] \
=!= \ NotationBoxTag\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::noboxtag\  = \[IndentingNewLine]"\<The InputAliasBoxes \
boxes `1` do not have an embedded NotationBoxTag TagBox. The AddInputAlias \
statement `2` may not have been entered using the palette, or the embedded \
TagBox may have been deleted. The embedded TagBox ensures correct parsing and \
retention of proper styling and grouping information.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The second argument of ",
  StyleBox["AddInputAlias", "MR"],
  " must be a notebook object."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[_?
            validAliasRule, \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]_] \
:= \[IndentingNewLine]\((Message[AddInputAlias::badnb, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; $Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]\  =!= \ NotebookObject\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::badnb\  = \ "\<The second argument of `2` is not a \
notebook object.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Check AddInputAlias for parsing and valid  options. (in lists of \
rules form)\
\>", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["AddInputAlias", "MR"],
  " statement with lists must have a non empty list of aliases."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\[ScriptE]\[ScriptS]\  : \ 
        AddInputAlias[{}, ___]\  := \ \[IndentingNewLine]\((Message[
          AddInputAlias::emptyals, \ 
          HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS]]; \ $Failed)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::emptyals\  = \[IndentingNewLine]"\<The input aliases \
list in `1` is empty. It must contain at least one valid input \
alias.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["AddInputAlias", "MR"],
  " statement with lists must be created from the palette."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\[ScriptE]\[ScriptS]\  : \ 
        AddInputAlias[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\[ScriptCapitalL]\[ScriptI]\[ScriptS]\
\[ScriptT]_List, ___]\  := \ \[IndentingNewLine]\((Message[
            AddInputAlias::noboxtgl, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\[ScriptCapitalL]\[ScriptI]\[ScriptS]\
\[ScriptT], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS]]; \ $Failed)\) \
/; \[IndentingNewLine]silentEvaluate\ @\ 
            Union[Head\  /@ \ \
\(\((#\[LeftDoubleBracket]2\[RightDoubleBracket] &)\)\  /@ \ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]\)]\  =!= {NotationBoxTag}\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::noboxtgl\  = \[IndentingNewLine]"\<The InputAliasBoxes \
boxes list `1` contains a rule which does not have an embedded NotationBoxTag \
TagBox. The AddInputAlias statement `2` may not have been entered using the \
palette, or the embedded TagBox may have been deleted. The embedded TagBox \
ensures correct parsing and retention of proper styling and grouping \
information.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The first arguments in the list of rules of ",
  StyleBox["AddInputAlias", "MR"],
  " statement with lists must be a string."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\[ScriptE]\[ScriptS]\  : \ 
        AddInputAlias[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalS]\
\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]_List, ___]\  := \ \
\[IndentingNewLine]\((Message[AddInputAlias::bshfrml, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS]]; \ $Failed)\) \
/; \[IndentingNewLine]silentEvaluate\ @\ 
            Union[Head\  /@ \ \(First\  /@ \ \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalS]\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalL]\[ScriptI]\[ScriptS]\[ScriptT]\
\)]\  =!= {String}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::bshfrml\  = \ "\<One of the short forms in the \
AddInputAlias `1` statement is not a string.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The second argument of ",
  StyleBox["AddInputAlias", "MR"],
  " must be a notebook object."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\
\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\  : \ AddInputAlias[{__?
              validAliasRule}, \
\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\
\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]_] := \[IndentingNewLine]\((Message[
            AddInputAlias::badnb, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]]; $Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\
\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]\  =!= \ NotebookObject\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddInputAlias::badnb\  = \ "\<The second argument of `2` is not a \
notebook object.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["AddInputAlias", "MR"],
  " expects 1, 2, or 3 arguments."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          AddInputAlias[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[
              1\  > \ \[ScriptN]\[ScriptU]\[ScriptM]\  \[Or] \ \[ScriptN]\
\[ScriptU]\[ScriptM]\  > \ 3, \ 
              Message[AddInputAlias::argb, 
                HoldForm\ @\ AddInputAlias, \[ScriptN]\[ScriptU]\[ScriptM], 
                1, \ 3], \[IndentingNewLine]True, \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ False]];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Definition of ",
  Cell[BoxData[
      \(TraditionalForm\`AddInputAlias[\ fullBoxes, shortForm, 
        notebook\ ]\)]]
}], "NumberedSubsubtitle"],

Cell[TextData[{
  "The ",
  StyleBox["AddInputAlias", "MR"],
  " has been correctly parsed and checked. Now add the alias(es) to the \
notebook. Basically just get the current aliases and add new one(s) to this \
list."
}], "Text"],

Cell[CellGroupData[{

Cell["handles adding a list of rule aliases (much faster.)", \
"NumberedSubsubsubtitle"],

Cell["\<\
The following handles adding a list of rule aliases at one time (It \
is much faster since communication with the front end is very slow.)\
\>", \
"Text"],

Cell[BoxData[
    \(AddInputAlias[{\[ScriptA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\[ScriptE]\[ScriptS]__Rule?validAliasRule}, 
        HoldPattern[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]_: 
             InputNotebook[]]] \
:= \[IndentingNewLine]With[\[IndentingNewLine]{\[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptP]\[ScriptE]\[ScriptD]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS]\  = \ 
            stripNotationBoxTag\ @\ {\[ScriptA]\[ScriptL]\[ScriptI]\[ScriptA]\
\[ScriptS]\[ScriptE]\[ScriptS]}, \[IndentingNewLine]\[ScriptO]\[ScriptL]\
\[ScriptD]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\
\[ScriptS] = \(Options[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK], InputAliases]\)\[LeftDoubleBracket]1, 
              2\[RightDoubleBracket]}, \[IndentingNewLine]SetOptions[\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK], 
          InputAliases \[Rule] \[IndentingNewLine]Join[
              DeleteCases[\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalA]\
\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS], \((Alternatives\
\  @@ \ \(First\  /@ \ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptP]\
\[ScriptE]\[ScriptD]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\[ScriptE]\[ScriptS]\))\) \[RuleDelayed] _], \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptP]\[ScriptE]\[ScriptD]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS]]]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["The following handles adding a single rule alias.", \
"NumberedSubsubsubtitle"],

Cell[BoxData[
    \(AddInputAlias[\[ScriptA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]_Rule?
          validAliasRule, 
        HoldPattern[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]_: 
             InputNotebook[]]] := \[IndentingNewLine]With[{\[ScriptS]\
\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptP]\[ScriptE]\[ScriptD]\[ScriptCapitalA]\
\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\  = \ 
            stripNotationBoxTag\ @\ {\[ScriptA]\[ScriptL]\[ScriptI]\[ScriptA]\
\[ScriptS]}, \[IndentingNewLine]\[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS] \
= \(Options[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\
\[ScriptO]\[ScriptK], InputAliases]\)\[LeftDoubleBracket]1, 
              2\[RightDoubleBracket]}, \[IndentingNewLine]SetOptions[\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK], 
          InputAliases \[Rule] \[IndentingNewLine]Join[
              DeleteCases[\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalA]\
\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS], \((Alternatives\
\  @@ \ \(First\  /@ \ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptP]\
\[ScriptE]\[ScriptD]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\
\))\) \[RuleDelayed] _], \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptP]\
\[ScriptE]\[ScriptD]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]]\
]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["The original calling syntax for compatibility.", \
"NumberedSubsubsubtitle"],

Cell[BoxData[
    \(AddInputAlias[\[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_NotationBoxTag, \[ScriptS]\[ScriptH]\
\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_\
String, HoldPattern[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]_: 
             InputNotebook[]]] \
:= \[IndentingNewLine]With[\[IndentingNewLine]{\[ScriptA]\[ScriptL]\[ScriptI]\
\[ScriptA]\[ScriptS]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\  = \ stripNotationBoxTag\ @\ \[ScriptF]\[ScriptU]\[ScriptL]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \
\[IndentingNewLine]\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalA]\[ScriptL]\
\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS] = \(Options[\[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], 
                InputAliases]\)\[LeftDoubleBracket]1, 
              2\[RightDoubleBracket]}, \[IndentingNewLine]SetOptions[\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK], 
          InputAliases \[Rule] \[IndentingNewLine]Join[
              DeleteCases[\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalA]\
\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\[ScriptS], \[ScriptS]\
\[ScriptH]\[ScriptO]\[ScriptR]\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM] \[RuleDelayed] _], {\[ScriptS]\[ScriptH]\[ScriptO]\[ScriptR]\
\[ScriptT]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM] \[RuleDelayed] \
\[ScriptA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]}]]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Check ActiveInputAliases for parsing and valid  options.", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "The first argument of ",
  StyleBox["ActiveInputAliases", "MR"],
  " must be a notebook object."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalA]\[ScriptC]\[ScriptT]\
\[ScriptI]\[ScriptV]\[ScriptE]\[ScriptCapitalI]\[ScriptN]\[ScriptP]\[ScriptU]\
\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\[ScriptS]\[ScriptE]\
\[ScriptS] : \ 
        ActiveInputAliases[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]_, ___]\
\  := \ \[IndentingNewLine]\((Message[ActiveInputAliases::badnb, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalA]\
\[ScriptC]\[ScriptT]\[ScriptI]\[ScriptV]\[ScriptE]\[ScriptCapitalI]\[ScriptN]\
\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalA]\[ScriptL]\[ScriptI]\[ScriptA]\
\[ScriptS]\[ScriptE]\[ScriptS]]; \ $Failed)\) /; \[IndentingNewLine]Head\ @\ \
\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\
\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]\  =!= \ NotebookObject\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(ActiveInputAliases::badnb\  = \ "\<The first argument of `2` is not a \
notebook object.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["ActiveInputAliases", "MR"],
  " expects zero or one arguments "
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          ActiveInputAliases[_, __]\ \  := \ $Failed\  \
/; \[IndentingNewLine]Message[ActiveInputAliases::argt, 
            HoldForm\ @\ ActiveInputAliases, 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 0, 1];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Definition of ",
  Cell[BoxData[
      \(TraditionalForm\`ActiveInputAliases[\ fullBoxes, shortForm, 
        notebook\ ]\)]]
}], "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["ActiveInputAliases", "MR"],
  " has been correctly parsed and checked. Now list the active Aliases."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(ActiveInputAliases\ @\ 
        HoldPattern[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]_: 
             InputNotebook[]] := \(\(Options[\[ScriptN]\[ScriptO]\[ScriptT]\
\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], 
              InputAliases]\)\[LeftDoubleBracket]1, 2\[RightDoubleBracket] // 
          TableForm\) // DisplayForm\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation Preprocessing", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["setups before the Notation", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Wipe ",
  StyleBox["adjustedOptions", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "Wipe ",
  StyleBox["adjustedOptions", "MR"],
  ". This is purely a speed consideration, since ",
  StyleBox["AbsoluteOptions", "MR"],
  " takes so long to execute its value is cached for the duration of the \
calculation. "
}], "Text"],

Cell[BoxData[
    \(Notation[\[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalN]\[ScriptO]\
\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]___] /; \
\((silentEvaluate\ [\ adjustedOptions\ @\ Notation\  =. ]\ ; 
          False)\)\  := \ $Failed\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["check Notation for parsing and valid  options.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Handle ",
  StyleBox["RemoveNotation", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(RemoveNotation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]_, \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := 
      Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN], 
        Action \[Rule] 
          RemoveNotationRules, \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Warn of legacy use of \[DoubleLeftRightArrow] vs. \
\[DoubleLongLeftRightArrow].", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(Notation[\[ScriptO]\[ScriptL]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\
\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]_, \[ScriptR]\
\[ScriptE]\[ScriptS]\[ScriptT]___]\  := \((Message[Notation::oldnota]; 
          Notation[
            DoubleLongLeftRightArrow\  @@ \ \[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN], \[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]])\) /; 
        MatchQ[SymbolName\ @\ \(Head\ @\ \[ScriptO]\[ScriptL]\[ScriptD]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]\), \ "\<DoubleLeftRightArrow\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::oldnota\  = \[IndentingNewLine]"\<Future versions of the \
Notation package will no longer support \[DoubleLeftRightArrow], instead they \
will use \[DoubleLongLeftRightArrow]. Please make this change to all your \
Notations.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The main argument to ",
  StyleBox["Notation", "MR"],
  " must be of the form (external notation) arrow (internal notation)."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(validNotationHeads\  = \ \(("\<DoubleLongRightArrow\>" | \ \
"\<DoubleLongLeftArrow\>" | \ "\<DoubleLongLeftRightArrow\>")\);\)\)], "Input",\

  InitializationCell->True],

Cell[BoxData[
    \(\(Notation[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\
\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]_, \[ScriptR]\
\[ScriptE]\[ScriptS]\[ScriptT]___]\  := \[IndentingNewLine]\((Message[
              Notation::badnota, \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]]; $Failed)\) /; \ \ \[Not] MatchQ[
              SymbolName\ @\ \(Head\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]\), \ validNotationHeads];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::badnota\  = \[IndentingNewLine]"\<The notation '`1`' is not \
of the form \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS] \
\[DoubleLongLeftRightArrow] \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalE]\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptS]\
\[ScriptS]\[ScriptI]\[ScriptO]\[ScriptN] or \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS] \[DoubleLongRightArrow] \[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\
\[ScriptX]\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptS]\[ScriptS]\[ScriptI]\
\[ScriptO]\[ScriptN] or \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS] \[DoubleLongLeftArrow] \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalE]\[ScriptX]\[ScriptP]\
\[ScriptR]\[ScriptE]\[ScriptS]\[ScriptS]\[ScriptI]\[ScriptO]\[ScriptN]. \
Examine the full box structures for possible unintended groupings.\>";\)\)], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["Notation", "MR"],
  " statement must be created from the Palette."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        Notation[\[ScriptD]\[ScriptI]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]_[\[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]_, _], \[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]___]\  \
:= \ \[IndentingNewLine]\((Message[Notation::noexbtag, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ \
$Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]\  =!= \ NotationBoxTag\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::noexbtag\  = \[IndentingNewLine]"\<The external \
representation `1` does not have an embedded NotationBoxTag TagBox. The \
Notation statement `2` may not have been entered using the palette, or the \
embedded TagBox may have been deleted. The embedded TagBox ensures correct \
parsing and retention of proper styling and grouping information.\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        Notation[\[ScriptD]\[ScriptI]\[ScriptR]\[ScriptE]\[ScriptC]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]_[_, \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]_], \[ScriptR]\[ScriptE]\[ScriptS]\[ScriptT]___]\  := \ \
\[IndentingNewLine]\((Message[Notation::noinbtag, 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ \
$Failed)\) /; 
        Head\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\  \
=!= \ NotationBoxTag\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::noinbtag\  = \[IndentingNewLine]"\<The internal \
representation `1` does not have an embedded NotationBoxTag TagBox. The \
Notation statement `2` may not have been entered using the palette, or the \
embedded TagBox may have been deleted. The embedded TagBox ensures correct \
parsing and retention of proper styling and grouping information.\>";\)\)], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The other arguments of ",
  StyleBox["Notation", "MR"],
  " must be options."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]_, \ ___, \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]_, ___]\  \
:= \[IndentingNewLine]\((Message[Notation::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\ ]; \
$Failed)\) /; \[IndentingNewLine]Not\ @\ \(OptionQ\ @\ \[ScriptN]\[ScriptO]\
\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\
\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "The value of option ",
  StyleBox["Action", "MR"],
  " should be valid."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
        Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]_, \ ___, \((Rule | RuleDelayed)\)[
            Action, \ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE]_], ___]\  := \ \
\[IndentingNewLine]\((Message[Notation::optcrp, \ Action, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\
\[ScriptA]\[ScriptL]\[ScriptU]\[ScriptE], 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ \
$Failed)\) /; \[IndentingNewLine]Not\ @\ 
          MatchQ[\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalV]\[ScriptA]\
\[ScriptL]\[ScriptU]\[ScriptE], 
            CreateNotationRules\  | \ RemoveNotationRules\  | \ 
              PrintNotationRules]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::optcrp\  = \[IndentingNewLine]"\<Value of option '`1` \
\[Rule] `2`' in `3` should be CreateNotationRules, RemoveNotationRules or \
PrintNotationRules.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "checks that the internal expression argument of ",
  StyleBox["Notation", "MR"],
  " is a parsable expression."
}], "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\  : \ 
          Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\
\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalT]\[ScriptY]\[ScriptP]\[ScriptE]_\
[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]_], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] := \ \
\[IndentingNewLine]\((Message[Notation::brepbxs, 
              HoldForm\ @\ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL], 
              HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]]; \ \
$Failed)\) /; \[IndentingNewLine]silentEvaluate\ @\ \(\[Not] \ 
              parsableQ\ [\ 
                stripNotationBoxTag\ @\ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\ , \ \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]]\);\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::brepbxs\  = \[IndentingNewLine]"\<Cannot parse the internal \
representation '`1`' occurring in `2`\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell["Options have all been checked and are o.k.", "NumberedSubsubsubtitle"]
}, Closed]],

Cell[CellGroupData[{

Cell["check form of complex NotationPattern's.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["\<\
Check that the complex external patterns are of the right \
form.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]\[ScriptCapitalT]\[ScriptY]\[ScriptP]\[ScriptE]_[\
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]_], \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]With[{\[ScriptC]\[ScriptO]\[ScriptM]\[ScriptP]\[ScriptL]\
\[ScriptE]\[ScriptX]\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\  = \ 
            complexPatternsInBoxes[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]]}, \[IndentingNewLine]\((Message[
              Notation::externalPatternTooComplex, \ 
              HoldForm\  @@ \ 
                First\ @\ \[ScriptC]\[ScriptO]\[ScriptM]\[ScriptP]\[ScriptL]\
\[ScriptE]\[ScriptX]\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], 
              identityForm\  @@ \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\ ]; \[IndentingNewLine]$Failed)\)\  \
/; \ \[ScriptC]\[ScriptO]\[ScriptM]\[ScriptP]\[ScriptL]\[ScriptE]\[ScriptX]\
\[ScriptCapitalE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]\  =!= \ {}]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \(\(Notation::externalPatternTooComplex\  = \[IndentingNewLine]"\<Pattern \
'`1`' appearing in the external representation '`2`' cannot be used since its \
head is not Optional, Pattern, PatternTest, or Condition.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Check that the complex internal patterns are of the right \
form.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]\[ScriptCapitalT]\[ScriptY]\[ScriptP]\[ScriptE]_[\
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]_], \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]With[{\[ScriptC]\[ScriptO]\[ScriptM]\[ScriptP]\[ScriptL]\
\[ScriptE]\[ScriptX]\[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\  = \ 
            complexPatternsInBoxes[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]]}, \[IndentingNewLine]\((Message[
              Notation::internalPatternTooComplex, \ 
              HoldForm\  @@ \ 
                First\ @\ \[ScriptC]\[ScriptO]\[ScriptM]\[ScriptP]\[ScriptL]\
\[ScriptE]\[ScriptX]\[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], 
              identityForm\  @@ \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\ ]; \[IndentingNewLine]$Failed)\)\  \
/; \ \[ScriptC]\[ScriptO]\[ScriptM]\[ScriptP]\[ScriptL]\[ScriptE]\[ScriptX]\
\[ScriptCapitalI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]\  =!= \ {}]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \(\(Notation::internalPatternTooComplex\  = \[IndentingNewLine]"\<Pattern \
'`1`' appearing in the internal representation '`2`' cannot be used since its \
head is not Optional, Pattern, PatternTest, or Condition.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["complexPatternsInBoxes", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  "Where ",
  StyleBox["complexPatternsInBoxes", "MR"],
  " is defined by."
}], "Text"],

Cell[BoxData[
    \(\(\(\ \)\(complexPatternsInBoxes\ [\ \[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  \
:= \[IndentingNewLine]Module[{\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \  = \ \(WorkingForm\ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ Notation}, \[IndentingNewLine]Union\ @\ 
          Cases[\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  \
//. \[IndentingNewLine]{HoldPattern[
                      NotationBoxTag]\ @\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \  \[RuleDelayed] \ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \
\[IndentingNewLine]TagBox[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, 
                    NotationPatternTag, ___]\  \[RuleDelayed] \ 
                  HoldPattern\  @@ \ 
                    toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]], \[IndentingNewLine]TagBox[\[ScriptS]\
\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, 
                    NotationMadeBoxesTag, ___]\  \[RuleDelayed] \ 
                  HoldPattern\  @@ \ 
                    toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, \[IndentingNewLine]\[ScriptP]\
\[ScriptA]\[ScriptT]\[ScriptT]_HoldPattern /; \((\ 
                headIsNot[
                    singleBlank | doubleBlank | 
                      tripleBlank]\  @@ \ \((convertPatterns\ @\ \[ScriptP]\
\[ScriptA]\[ScriptT]\[ScriptT])\))\), {0, \[Infinity]}]]\)\)\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["check form of the patterns in the Notation", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["\<\
compare the external and internal patterns for consistentancy\
\>", \
"NumberedSubsubsubtitle"],

Cell["\<\
The external and internal patterns now have to be compared to see \
if they are consistent with the notation.\
\>", "Text"],

Cell[BoxData[
    \(\(fullArrowsToShortArrowsRules\  = \
{\[IndentingNewLine]"\<DoubleLongRightArrow\>"\ \ \ \ \  \[Rule] \ "\<\
\[DoubleLongRightArrow]\>", \[IndentingNewLine]"\<DoubleLongLeftArrow\>"\ \ \ \
\ \ \  \[Rule] \ "\<\[DoubleLongLeftArrow]\>", \
\[IndentingNewLine]"\<DoubleLongLeftRightArrow\>"\  \[Rule] \ "\<\
\[DoubleLongLeftRightArrow]\>"};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Notation[\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\
\[ScriptO]\[ScriptN]\[ScriptCapitalT]\[ScriptY]\[ScriptP]\[ScriptE]_[\
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]_], \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]checkNotationPatterns[\[IndentingNewLine]\[ScriptE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ 
        patternsInBoxes\ [\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]], \
\[IndentingNewLine]SymbolName\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptA]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalT]\[ScriptY]\[ScriptP]\
\[ScriptE]\  /. 
          fullArrowsToShortArrowsRules, \[IndentingNewLine]\[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ 
        patternsInBoxes\ [\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]], \
\ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["patternsInBoxes", "Input"]], "NumberedSubsubsubtitle"],

Cell["\<\
where the patterns present in the boxes can be found from the \
following.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\ \)\(patternsInBoxes\ [\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  \
:= \[IndentingNewLine]Module[{\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \  = \ \(WorkingForm\ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ Notation}, \[IndentingNewLine]Union\ @\ 
          Cases[\ \[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  //. {\
\[IndentingNewLine]\ 
                TagBox[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, 
                    NotationPatternTag, ___]\  \[RuleDelayed] \
\[IndentingNewLine]With[{eval = 
                        convertPatterns\ @\ 
                          toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, 
                    eval /; 
                      True], \[IndentingNewLine]TagBox[\[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, 
                    NotationMadeBoxesTag, ___]\  \[RuleDelayed] \
\[IndentingNewLine]With[{eval = 
                        convertPatterns\ @\ 
                          toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, 
                    eval /; 
                      True], \[IndentingNewLine]\[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]_String\  /; \ 
                    StringMatchQ[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG], "\<*_\>"]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \  \[RuleDelayed] \
\ \ \[IndentingNewLine]With[{eval = 
                        convertPatterns\ @\ 
                          toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG], \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, 
                    eval /; 
                      True]}, \[IndentingNewLine]\[ScriptA]_singleBlank | \
\[ScriptA]_doubleBlank | \[ScriptA]_tripleBlank | \[ScriptA]_complexPattern \
\[Rule] \[ScriptA], {0, \[Infinity]}]]\)\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[" checkNotationPatterns for free blanks.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["Free blanks cannot occur in the output.", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ "\<\[DoubleLongLeftArrow]\>"\  | \
\ "\<\[DoubleLongLeftRightArrow]\>", \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := \ \[IndentingNewLine]\((Message[
            Notation::frepatex, 
            identityForm\  @@ \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]]; \[IndentingNewLine]$Failed)\)\  /; \ 
        containsFreeBlanksQ[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::frepatex\  = \[IndentingNewLine]"\<All patterns in the \
external representation must be able to be filled.  Free blank patterns found \
inside the external representation '`1`'.\>";\)\)], "Input",
  PageWidth->WindowWidth,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Free blanks cannot occur in the input,", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ "\<\[DoubleLongRightArrow]\>"\  \
| \ "\<\[DoubleLongLeftRightArrow]\>", \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := \ \[IndentingNewLine]\((Message[
            Notation::frepatin, 
            identityForm\  @@ \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]]; \[IndentingNewLine]$Failed)\)\  /; \ 
        containsFreeBlanksQ[\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::frepatin\  = \[IndentingNewLine]"\<All patterns in the \
internal representation must be able to be filled.  Free blank patterns found \
inside the internal representation '`1`'.\>";\)\)], "Input",
  PageWidth->WindowWidth,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["containsFreeBlanksQ", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "where ",
  StyleBox["containsFreeBlanksQ", "MR"],
  " is defined by."
}], "Text"],

Cell[BoxData[
    \(containsFreeBlanksQ\ [\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_\ ] := \ \ \ \[Not] \ 
        FreeQ[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS], \ 
          singleBlank[] | doubleBlank[] | tripleBlank[]]\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
 checkNotationPatterns to catch patterns that are not \
fillable.\
\>", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["\<\
Check for patterns in the external representation which are not \
being filled.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ "\<\[DoubleLongLeftArrow]\>"\  | \
\ "\<\[DoubleLongLeftRightArrow]\>", \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := \ \[IndentingNewLine]With[{\[ScriptL]\[ScriptH]\
\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptCapitalI]\
\[ScriptN]\[ScriptR]\[ScriptH]\[ScriptS]\  = \ 
            Complement[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\ , \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]]}, \
\[IndentingNewLine]\((Message[
              Notation::expatnf, \[IndentingNewLine]HoldForm\  @@ \ 
                First\ @\ \[ScriptL]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptCapitalI]\[ScriptN]\[ScriptR]\
\[ScriptH]\[ScriptS], \[IndentingNewLine]identityForm\  @@ \ \[ScriptE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \
\[IndentingNewLine]identityForm\  @@ \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]\ ]; \[IndentingNewLine]$Failed)\)\  /; \ \
\[ScriptL]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalI]\[ScriptN]\[ScriptR]\[ScriptH]\[ScriptS]\  =!= \ {}]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::expatnf\  = \[IndentingNewLine]"\<Pattern '`1`' appearing \
in the external representation '`2`' cannot be filled since '`1`' does not \
appear in the internal representation '`3`'.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Check for patterns in the internal representation which are not \
being filled.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ "\<\[DoubleLongRightArrow]\>"\  \
| \ "\<\[DoubleLongLeftRightArrow]\>", \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := \ \[IndentingNewLine]With[{\[ScriptR]\[ScriptH]\
\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptCapitalI]\
\[ScriptN]\[ScriptL]\[ScriptH]\[ScriptS]\  = \ 
            Complement[\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], \ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]]}, \
\[IndentingNewLine]\((Message[
              Notation::inpatnf, \[IndentingNewLine]HoldForm\  @@ \ 
                First\ @\ \[ScriptR]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptCapitalI]\[ScriptN]\[ScriptL]\
\[ScriptH]\[ScriptS], \[IndentingNewLine]identityForm\  @@ \ \[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \
\[IndentingNewLine]identityForm\  @@ \ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]\ ]; \[IndentingNewLine]$Failed)\)\  /; \ \ \
\[ScriptR]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalI]\[ScriptN]\[ScriptL]\[ScriptH]\[ScriptS]\  =!= \ {}]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::inpatnf\  = \n"\<Pattern '`1`' appearing in the internal \
representation '`2`' cannot be filled since '`1`' does not appear in the \
external representation '`3`'.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["checkNotationPatterns for patterns that are not used.", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["\<\
Check for named patterns in the external representation which are \
not being used.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ "\<\[DoubleLongRightArrow]\>", \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := \ \
\[IndentingNewLine]With[{\[ScriptL]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptCapitalI]\[ScriptN]\[ScriptR]\
\[ScriptH]\[ScriptS]\  = \ 
            Complement[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], \ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], {singleBlank[], 
                doubleBlank[], 
                tripleBlank[]}\ ]}, \[IndentingNewLine]$Failed\  /; \ \((\
\[ScriptL]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalI]\[ScriptN]\[ScriptR]\[ScriptH]\[ScriptS]\  =!= \ {})\)\  \
\[And] \[IndentingNewLine]\ 
            Message[Notation::expatnu, \[IndentingNewLine]\(\((HoldForm\  \
@@ \ #)\) &\)\  /@ \ \
\[ScriptL]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalI]\[ScriptN]\[ScriptR]\[ScriptH]\[ScriptS], \
\[IndentingNewLine]identityForm\  @@ \ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \[IndentingNewLine]identityForm\  @@ \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\ ]]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::expatnu\  = \[IndentingNewLine]"\<Warning: The pattern(s) \
'`1`' appearing in the external representation '`2`' are not used in the \
internal representation '`3`'.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Check for named patterns in the internal representation which are \
not being used. \
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ "\<\[DoubleLongLeftArrow]\>", \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := \ \
\[IndentingNewLine]With[{\[ScriptR]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptCapitalI]\[ScriptN]\[ScriptL]\
\[ScriptH]\[ScriptS]\  = \ 
            Complement[\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], \ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS], \ \
{singleBlank[], doubleBlank[], 
                tripleBlank[]}\ ]}, \[IndentingNewLine]$Failed\  /; \ \((\
\[ScriptR]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalI]\[ScriptN]\[ScriptL]\[ScriptH]\[ScriptS]\  =!= \ {})\)\  \
\[And] \ \[IndentingNewLine]Message[
              Notation::inpatnu, \[IndentingNewLine]\(\((HoldForm\  @@ \ #)\) \
&\)\  /@ \ \
\[ScriptR]\[ScriptH]\[ScriptS]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptCapitalI]\[ScriptN]\[ScriptL]\[ScriptH]\[ScriptS], \
\[IndentingNewLine]identityForm\  @@ \ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \[IndentingNewLine]identityForm\  @@ \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\ ]]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::inpatnu\  = \[IndentingNewLine]"\<Warning: The pattern(s) \
'`1`' appearing in the internal representation '`2`' are not used in the \
external representation '`3`'.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["checkNotationPatterns for patterns that are too General.", \
"NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["\<\
Check for patterns that are too general in the external \
representation.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptT]\[ScriptY]\[ScriptP]\
\[ScriptE]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := \ \
\[IndentingNewLine]With[{\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]\ \ \  = \ 
            boxedStringPatternsToPatterns\ [\ 
              cleanBoxes\  @@ \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[IndentingNewLine]\(WorkingForm\  \[Rule] \ 
                    WorkingForm\ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]}\)\  /. \ 
                adjustedOptions\ @\ 
                  Notation\ ]\ }, \[IndentingNewLine]\((Message[
              Notation::expattg, \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], 
              identityForm\ @\ \[ScriptT]\[ScriptY]\[ScriptP]\[ScriptE], \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]]; \
\[IndentingNewLine]$Failed)\) /; \ 
          
          patternToGeneralQ\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::expattg\  = \ "\<The external pattern `1` appearing in \
Notation[`2` `3` `4`] is too general to be used. Almost anything will match \
the external pattern `1`.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Check for patterns that are too general in the internal \
representation.\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptT]\[ScriptY]\[ScriptP]\
\[ScriptE]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := \ \
\[IndentingNewLine]With[{\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]\ \ \  = \ 
            boxedStringPatternsToPatterns\ [\ 
              cleanBoxes\  @@ \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \(WorkingForm\  \[Rule] \ 
                    WorkingForm\ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]}\)\  /. \ 
                adjustedOptions\ @\ 
                  Notation\ ]\ }, \[IndentingNewLine]\((Message[
              Notation::inpattg, \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], 
              identityForm\ @\ \[ScriptT]\[ScriptY]\[ScriptP]\[ScriptE], \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]]; \
\[IndentingNewLine]$Failed)\) /; \ 
          patternToGeneralQ\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptE]\[ScriptD]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::inpattg\  = \ "\<The internal pattern `1` appearing in \
Notation[`2` `3` `4`] is too general to be used. Almost anything will match \
the internal pattern `1`.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Definition of Notation.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["O.k. Now create the notation.", "NumberedSubsubsubtitle"],

Cell["\<\
The notation has been correctly parsed and checked. Now create the \
notation.\
\>", "Text"],

Cell[BoxData[
    \(checkNotationPatterns[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_, \ \[ScriptT]\[ScriptY]\[ScriptP]\
\[ScriptE]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___]\  := \ \
\[IndentingNewLine]executeNotation[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptT]\[ScriptY]\[ScriptP]\[ScriptE], \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\[ScriptA]\[ScriptL]\[ScriptL]\[ScriptO]\[ScriptK]\  : \ 
        executeNotation[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]_, "\<\[DoubleLongLeftRightArrow]\>", \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]With[{\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]\  = \ \ stripNotationBoxTag\ @\ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  = \ \ stripNotationBoxTag\ @\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]}, \[IndentingNewLine]createExternalToInternalRule[\[ScriptE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]]; \
\[IndentingNewLine]createInternalToExternalRule[\[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]];]\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\[ScriptA]\[ScriptL]\[ScriptL]\[ScriptO]\[ScriptK]\  : \ 
          executeNotation[\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, "\<\[DoubleLongRightArrow]\>", \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := \[IndentingNewLine]With[{\[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  = \ \ stripNotationBoxTag\ @\ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL], \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\  = \ \ stripNotationBoxTag\ @\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]}, \
\[IndentingNewLine]createExternalToInternalRule[\[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]];\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\[ScriptA]\[ScriptL]\[ScriptL]\[ScriptO]\[ScriptK]\  : \ 
          executeNotation[\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]_, "\<\[DoubleLongLeftArrow]\>", \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \[ScriptO]\[ScriptP]\
\[ScriptT]\[ScriptS]___]\  := \ \[IndentingNewLine]With[{\[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  = \ \ stripNotationBoxTag\ @\ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL], \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\  = \ \ stripNotationBoxTag\ @\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]}, \
\[IndentingNewLine]createInternalToExternalRule[\[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]];\)\)], \
"Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation error handling catch all's.", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["\<\
Have encountered an unknown error in notation parsing... Report it!\
\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(Notation[\[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]___]\  \
:= \[IndentingNewLine]\((Message[
            Notation::unknpars]; \[IndentingNewLine]StylePrint[
            identityForm\ @\ 
              colorizeStructuralBoxes[\ \(HoldForm[
                    Notation]\)[\[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]]\ , \ 
                1], "\<Output\>"]; \[IndentingNewLine]$Failed)\);\)\)], \
"Input",
  PageWidth->Infinity,
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::unknpars\  = \[IndentingNewLine]"\<Unknown error occurred \
in parsing the notation statement. Please report this to jasonh@wri.com, \
Please carefully examine the following box structures for spurious characters \
weird groupings etc.\>";\)\)], "Input",
  PageWidth->WindowWidth,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Have encountered an unknown error in notation pattern checking... \
Report it!\
\>", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(checkNotationPatterns[\[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]___]\  := \[IndentingNewLine]\((Message[
            Notation::unknpatu]; \[IndentingNewLine]StylePrint[
            identityForm\ @\ 
              colorizeStructuralBoxes[\ \(HoldForm[
                    Notation]\)[\[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]]\ , \ 
                1], "\<Output\>"]; \[IndentingNewLine]$Failed)\);\)\)], \
"Input",
  PageWidth->Infinity,
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::unknpatu\  = \[IndentingNewLine]"\<Unknown error occurred \
in checking the pattern used in the notation statement. It appears to have \
parsed ok. Please report this to jasonh@wri.com, Please carefully examine the \
following box structures for spurious characters weird groupings \
etc.\>";\)\)], "Input",
  PageWidth->WindowWidth,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Have encountered an unknown error in notation execution... Report \
it!\
\>", "NumberedSubsubsubtitle"],

Cell["\<\
executeNotation[\[ScriptA]\[ScriptL]\[ScriptL]_,\[ScriptO]\[ScriptT]\
\[ScriptH]\[ScriptE]\[ScriptR]___] :=
   (Message[Notation::unknexec];
  CellPrint[Cell[BoxData[ colorizeStructuralBoxes[ \[ScriptA]\[ScriptL]\
\[ScriptL] , 1]],\"Output\"]];
  HoldComplete @ Symbol @ \"$Failed\");\
\>", "Text"],

Cell[BoxData[
    \(\(Notation::unknexec\  = \[IndentingNewLine]"\<Unknown error occurred \
in executing the notation statement. It appears to have parsed and been \
processed ok. Please report this to jasonh@wri.com, Please carefully examine \
the following box structures for spurious characters weird groupings etc.\>";\
\)\)], "Input",
  PageWidth->WindowWidth,
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation InternalToExternal", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["convertInternalPatternsForInternalToExternal", "NumberedSubsubtitle"],

Cell[BoxData[
    \(convertInternalPatternsForInternalToExternal[\[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]With[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \ \ \ \ \ \ \ \ \
\ \ \  = \ \(WorkingForm\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Notation}, \[IndentingNewLine]cleanBoxes\ @\ \[ScriptP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\  //. \[IndentingNewLine]{TagBox[\
\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, 
                NotationPatternTag, ___]\  \[RuleDelayed] \[IndentingNewLine]\
\((\ \(MakeBoxes[#, \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]] &\)\  @@ \ 
                  toInert\ @\ 
                    toMyHeldExpression[\[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]])\), \[IndentingNewLine]TagBox[\
\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\
\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, 
                NotationMadeBoxesTag, ___]\  \[RuleDelayed] \
\[IndentingNewLine]\((\ \(MakeBoxes[#, \[ScriptCapitalW]\[ScriptO]\[ScriptR]\
\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]] &\)\  @@ \ 
                  toInert\ @\ 
                    toMyHeldExpression[\[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]])\)}]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["convertInternalBoxesForInternalToExternal", "NumberedSubsubtitle"],

Cell[BoxData[
    \(convertInternalBoxesForInternalToExternal[\[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]With[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \ \ \ \ \ \ \ \ \
\ \ \  = \ \(WorkingForm\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Notation}, \[IndentingNewLine]With[{\[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ \ \
toMyHeldExpression\ [\ 
                convertInternalPatternsForInternalToExternal\ [\ \[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\ , \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\
\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}, \
\[IndentingNewLine]fromInert\ @\ \(transformNotationalPatterns\ @\ \
\(flattenAllMyHold\ @\ \(myHold\ @\ 
                  NotationMakeBoxes\ [\ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\ , \[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\)\)\)]]\)\
], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["toInert", "MR"],
  " & ",
  StyleBox["fromInert", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["toInert", "MR"],
  " & ",
  StyleBox["fromInert", "MR"],
  " transform all system patterns into inert patterns and back again."
}], "Text"],

Cell[BoxData[{
    \(\(\(toInert[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_] \
:= \[IndentingNewLine]\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\  /. \ {\
\[IndentingNewLine]Pattern\  -> 
            Symbol[Context[] <> "\<inert`Pattern\>"], \
\[IndentingNewLine]PatternTest\  -> 
            Symbol[Context[] <> "\<inert`PatternTest\>"], \
\[IndentingNewLine]Condition\  -> 
            Symbol[Context[] <> "\<inert`Condition\>"], \
\[IndentingNewLine]Alternatives\  -> 
            Symbol[Context[] <> "\<inert`Alternatives\>"], \
\[IndentingNewLine]Optional\  -> 
            Symbol[Context[] <> "\<inert`Optional\>"], \
\[IndentingNewLine]Repeated\  -> 
            Symbol[Context[] <> "\<inert`Repeated\>"], \
\[IndentingNewLine]RepeatedNull\  -> 
            Symbol[Context[] <> "\<inert`RepeatedNull\>"]}\)\(\n\)
    \)\), "\n", 
    \(\(\(fromInert[\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_] \
:= \[IndentingNewLine]\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]\  /. {\
\[IndentingNewLine]Symbol[Context[] <> "\<inert`Pattern\>"]\  -> \ 
            Pattern\ , \[IndentingNewLine]Symbol[
              Context[] <> "\<inert`PatternTest\>"]\  -> \ 
            PatternTest, \[IndentingNewLine]Symbol[
              Context[] <> "\<inert`Condition\>"]\  -> \ 
            Condition, \[IndentingNewLine]Symbol[
              Context[] <> "\<inert`Alternatives\>"]\  -> \ 
            Alternatives, \[IndentingNewLine]Symbol[
              Context[] <> "\<inert`Optional\>"]\  -> \ 
            Optional, \[IndentingNewLine]Symbol[
              Context[] <> "\<inert`Repeated\>"]\  -> \ 
            Repeated, \[IndentingNewLine]Symbol[
              Context[] <> "\<inert`RepeatedNull\>"] -> \ 
            RepeatedNull}\)\(\n\)
    \)\), "\n", 
    \(\(SetAttributes[inertHold, HoldAll];\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["transformNotationalPatterns", "MR"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["transformNotationalPatterns", "MR"],
  " transforms all patterns that are not genuine patterns and converts them \
to match literal expressions."
}], "Text"],

Cell[BoxData[
    \(transformNotationalPatterns[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS]_] := \ \((\[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptS] \
//. \[IndentingNewLine]HoldPattern[\(HoldPattern[
                    HoldPattern]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]_]]\
 \[Rule] \(Verbatim[
                  HoldPattern]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]])\) \
//. {\[IndentingNewLine]\[IndentingNewLine]\(HoldPattern[\(HoldPattern[
                      Pattern]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalV]\[ScriptA]\[ScriptR]\[ScriptI]\
\[ScriptA]\[ScriptB]\[ScriptL]\[ScriptE]_, \ \[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptN]\[ScriptT]_]] /; 
                Not\ @\ 
                  MatchQ[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptN]\[ScriptT], \(HoldPattern[
                        Blank | BlankSequence | 
                          BlankNullSequence]\)[]]\) \
/; \[IndentingNewLine]\((Message[Notation::notapatu, 
                  HoldForm[\(HoldForm\ [\ 
                        Pattern]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalV]\[ScriptA]\[ScriptR]\[ScriptI]\
\[ScriptA]\[ScriptB]\[ScriptL]\[ScriptE], \[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptN]\[ScriptT]]]]; 
                True)\) \[Rule] \((\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT] : 
                  Pattern)\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalV]\[ScriptA]\[ScriptR]\[ScriptI]\
\[ScriptA]\[ScriptB]\[ScriptL]\[ScriptE], \[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptN]\[ScriptT]], \[IndentingNewLine]\
\[IndentingNewLine]HoldPattern[\(HoldPattern[
                    
                    PatternTest]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]_, \
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptCapitalT]\[ScriptE]\[ScriptS]\[ScriptT]_]] \
/; \[IndentingNewLine]\((Message[Notation::notapatu, 
                  HoldForm\ @\ 
                    PatternTest[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT], \
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptCapitalT]\[ScriptE]\[ScriptS]\[ScriptT]]]; 
                True)\) \[Rule] \(HoldPattern[
                PatternTest]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT], 
              HoldPattern[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalT]\[ScriptE]\[ScriptS]\[ScriptT]]], \
\[IndentingNewLine]\[IndentingNewLine]HoldPattern[\(HoldPattern[
                    Condition]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]_, \
\[ScriptC]\[ScriptO]\[ScriptN]\[ScriptD]_]] /; \((Message[Notation::notapatu, 
                  HoldForm\ @\ 
                    Condition[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT], \
\[ScriptC]\[ScriptO]\[ScriptN]\[ScriptD]]]; True)\) \[Rule] 
            HoldPattern[\(HoldPattern[
                  Condition]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT], \
\[ScriptC]\[ScriptO]\[ScriptN]\[ScriptD]]], \[IndentingNewLine]\
\[IndentingNewLine]HoldPattern[\(HoldPattern[
                    Alternatives]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]__\
]] /; \[IndentingNewLine]\((Message[Notation::notapatu, 
                  HoldForm\ @\ \(Alternatives\ @\ \[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\)]; True)\) \[Rule] \(HoldPattern[
                Alternatives]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]], \
\[IndentingNewLine]\[IndentingNewLine]HoldPattern[\(HoldPattern[
                    Optional]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]__]] \
/; \[IndentingNewLine]\((Message[Notation::notapatu, 
                  HoldForm\ @\ \(Optional\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]\)]; True)\) \[Rule] \(HoldPattern[
                Optional]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]], \
\[IndentingNewLine]\[IndentingNewLine]HoldPattern[\(HoldPattern[
                    Repeated]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]__]] \
/; \[IndentingNewLine]\((Message[Notation::notapatu, 
                  HoldForm\ @\ \(Repeated\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]\)]; True)\) \[Rule] \(HoldPattern[
                Repeated]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]], \
\[IndentingNewLine]HoldPattern[\(HoldPattern[
                    RepeatedNull]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]__\
]] /; \[IndentingNewLine]\((Message[Notation::notapatu, 
                  HoldForm\ @\ \(RepeatedNull\ @\ \[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\)]; True)\) \[Rule] \(HoldPattern[
                RepeatedNull]\)[\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]]}\)],\
 "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Notation::notapatu\  = \[IndentingNewLine]"\<Warning: The pattern `1` \
is being interpreted as a notation and not a pattern. Use an embedded \
NotationPatternTag TagBox wrapper if you want this pattern to be treated as a \
genuine pattern.\>";\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["convertExternalPatternsForInternalToExternal", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["convertExternalPatternsForInternalToExternal", \
"MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["convertExternalPatternsForInternalToExternal", "MR"],
  " will take an expression consisting of boxes and convert all patterns \
present in the boxes\[LongDash]patterns that are currently still unparsed \
strings and not yet expressions\[LongDash]and convert them to the \
corresponding patterned expressions, leaving the other boxes alone."
}], "Text"],

Cell[BoxData[
    \(convertExternalPatternsForInternalToExternal[\[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]Module[{\[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \  = \ \
\(WorkingForm\ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Notation}, \[IndentingNewLine]flattenAllMyHold\ [\ \ myHold\  \
@@ \ {\[IndentingNewLine]\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\
\  //. \ {\[IndentingNewLine]TagBox[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_\
, NotationMadeBoxesTag, ___]\ \  \[RuleDelayed] \[IndentingNewLine]myHold\  \
@@ \ removePatternsAndBlanks\ [\ 
                        complexPattern\  @@ \ 
                          toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\
\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]], \[IndentingNewLine]TagBox[\[ScriptS]\
\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, 
                      NotationPatternTag, ___]\ \  \[RuleDelayed] \
\[IndentingNewLine]removePatternsAndBlanks\ [\ 
                      complexPattern\  @@ \ 
                        toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]], \[IndentingNewLine]TagBox[\[ScriptS]\
\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, 
                      NotationBoxTag, ___]\ \ \ \ \ \ \ \ \ \ \ \  \
\[RuleDelayed] \ \[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \
\[IndentingNewLine]\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\[ScriptN]\
\[ScriptG]_String\  /; \ 
                      StringMatchQ[\[ScriptS]\[ScriptT]\[ScriptR]\[ScriptI]\
\[ScriptN]\[ScriptG], "\<*_\>"]\ \ \ \ \  \[RuleDelayed] \ 
                    convertPatterns\ @\ 
                      toMyHeldExpression\ [\ \[ScriptS]\[ScriptT]\[ScriptR]\
\[ScriptI]\[ScriptN]\[ScriptG], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\
\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]}}\[IndentingNewLine]]\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["convertExternalPatternsForInternalToExternal", "Input"]
}], "NumberedSubsubsubtitle"],

Cell["\<\
The second argument and beyond of \
convertExternalPatternsForInternalToExternal must be Options.\
\>", "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          convertExternalPatternsForInternalToExternal[_, ___, \[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]_?\((isNot[_?
                    OptionQ])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            convertExternalPatternsForInternalToExternal::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["convertExternalBoxesForInternalToExternal", "NumberedSubsubtitle"],

Cell[TextData[{
  "When redoing this move the ",
  StyleBox["With", "Input"],
  " outside the calculation. Thus creating the set of rules only once. then \
just apply it each time when needed. Profiling seems to indicate that a fair \
amount of time is spent here. Not changing this now since not retesting it to \
make sure everything is working."
}], "JasonComment"],

Cell[BoxData[
    \(convertExternalBoxesForInternalToExternal[\[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]Module[{\[ScriptCapitalC]\[ScriptO]\
\[ScriptM]\[ScriptM]\[ScriptA]\[ScriptCapitalQ]}, \[IndentingNewLine]\
\[ScriptCapitalC]\[ScriptO]\[ScriptM]\[ScriptM]\[ScriptA]\[ScriptCapitalQ]["\<\
,\>" | "\<\[InvisibleComma]\>"] := 
          True; \[IndentingNewLine]\[ScriptCapitalC]\[ScriptO]\[ScriptM]\
\[ScriptM]\[ScriptA]\[ScriptCapitalQ]\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\
\[ScriptE]\[ScriptR]_\  := 
          False; \[IndentingNewLine]With\ \ [{\[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\  = \ RowBox, \ \[ScriptCapitalB]\  = \ 
              singleBlank, \ \[ScriptCapitalB]\[ScriptCapitalB]\  = \ \
\((doubleBlank\  | \ 
                  tripleBlank)\), \ \[ScriptCapitalC]\[ScriptCapitalP]\  = \ 
              complexPattern, \[IndentingNewLine]\[ScriptCapitalO]\[ScriptP]\
\[ScriptCapitalQ]\  = \ 
              operatorQ, \ \[ScriptCapitalI]\[ScriptN]\[ScriptCapitalQ]\  = \ 
              infixOperatorQ, \ \[ScriptCapitalP]\[ScriptR]\[ScriptE]\
\[ScriptCapitalQ]\  = \ 
              prefixOperatorQ, \ \[ScriptCapitalP]\[ScriptO]\[ScriptS]\
\[ScriptT]\[ScriptCapitalQ]\  = \ 
              postfixOperatorQ, \
\[IndentingNewLine]\[ScriptCapitalD]\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\
\[ScriptCapitalQ]\  = \ 
              delimiterQ, \ \[ScriptCapitalE]\[ScriptF]\[ScriptF]\
\[ScriptCapitalO]\[ScriptP]\  = \ 
              effectiveOperator\ , \ \[ScriptCapitalP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN]\  = \ 
              Parenthesize, \ \[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ]\  \
= \ whiteSpaceQ, \[IndentingNewLine]\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]\ \
\  = \ \(WorkingForm\  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  \
/. \ adjustedOptions\ @\ 
                  Notation}, \
\[IndentingNewLine]convertExternalPatternsForInternalToExternal\ [\ 
              tidyBoxes\ @\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]\ ]\  //. {\[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptO]\
\[ScriptP]_?\[ScriptCapitalP]\[ScriptR]\[ScriptE]\[ScriptCapitalQ], \ \
\[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \
\[ScriptCapitalB]\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_, \ \
\[ScriptR]___}\ \ \  \[RuleDelayed] \ 
                With[{\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]\  = \ \
\[ScriptCapitalE]\[ScriptF]\[ScriptF]\[ScriptCapitalO]\[ScriptP]\ @\ \
\[ScriptO]\[ScriptP]}, \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \
\ \[ScriptO]\[ScriptP], \ \[ScriptW], \ \[ScriptCapitalP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN][\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]], \
\ \[ScriptR]} /; \ 
                    True], \[IndentingNewLine]\[ScriptCapitalR]\
\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptCapitalB]\ @\ \[ScriptS]\
\[ScriptY]\[ScriptM]\[ScriptB]_, \ \[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\
\[ScriptCapitalQ], \ \[ScriptO]\[ScriptP]_?\[ScriptCapitalI]\[ScriptN]\
\[ScriptCapitalQ], \ \[ScriptR]___}\ \ \  \[RuleDelayed] \ 
                With[{\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]\  = \ \
\[ScriptCapitalE]\[ScriptF]\[ScriptF]\[ScriptCapitalO]\[ScriptP]\ @\ \
\[ScriptO]\[ScriptP]}, \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \
\ \[ScriptCapitalP]\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN][\[ScriptS]\
\[ScriptY]\[ScriptM]\[ScriptB], \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ \
\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]], \ \[ScriptW], \ \[ScriptO]\
\[ScriptP], \ \[ScriptR]} /; \ 
                    True], \[IndentingNewLine]\[ScriptCapitalR]\
\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptO]\[ScriptP]_?\
\[ScriptCapitalI]\[ScriptN]\[ScriptCapitalQ], \ \[ScriptW]___?\
\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \[ScriptCapitalB]\ @\ \
\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_, \ \[ScriptR]___}\ \ \  \
\[RuleDelayed] \ 
                With[{\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]\  = \ \
\[ScriptCapitalE]\[ScriptF]\[ScriptF]\[ScriptCapitalO]\[ScriptP]\ @\ \
\[ScriptO]\[ScriptP]}, \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \
\ \[ScriptO]\[ScriptP], \ \[ScriptW], \ \[ScriptCapitalP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN][\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ \[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]], \
\ \[ScriptR]} /; \ 
                    True], \[IndentingNewLine]\[ScriptCapitalR]\
\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptCapitalB]\ @\ \[ScriptS]\
\[ScriptY]\[ScriptM]\[ScriptB]_, \ \[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\
\[ScriptCapitalQ], \ \[ScriptO]\[ScriptP]_?\[ScriptCapitalP]\[ScriptO]\
\[ScriptS]\[ScriptT]\[ScriptCapitalQ], \ \[ScriptR]___}\ \  \[RuleDelayed] \ 
                With[{\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]\  = \ \
\[ScriptCapitalE]\[ScriptF]\[ScriptF]\[ScriptCapitalO]\[ScriptP]\ @\ \
\[ScriptO]\[ScriptP]}, \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \
\ \[ScriptCapitalP]\[ScriptA]\[ScriptR]\[ScriptE]\[ScriptN][\[ScriptS]\
\[ScriptY]\[ScriptM]\[ScriptB], \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ \
\[ScriptP]\[ScriptR]\[ScriptE]\[ScriptC]], \ \[ScriptW], \ \[ScriptO]\
\[ScriptP], \ \[ScriptR]} /; \ 
                    True], \[IndentingNewLine]\[ScriptCapitalR]\
\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \[ScriptD]_?\[ScriptCapitalD]\
\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\[ScriptCapitalQ], \[ScriptM]___, \ \
\[ScriptCapitalB]\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_, \ \
\[ScriptR]___}\  \[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\
\[ScriptL], \ \[ScriptD], \[ScriptM], \ 
                    MakeBoxes[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], \ \[ScriptR]}, \[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \[ScriptCapitalB]\ @\
\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_, \[ScriptM]___, \[ScriptD]_?\
\[ScriptCapitalD]\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\[ScriptCapitalQ], \ \
\ \[ScriptR]___}\  \[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ \
{\[ScriptL], \ 
                    MakeBoxes[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], \[ScriptM], \[ScriptD], \ \
\[ScriptR]}, \[IndentingNewLine]\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\
\[ScriptL]___, \ \ \[ScriptCapitalB]\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]_, \ \[ScriptR]___}\ \  \[RuleDelayed] \ \ \[ScriptCapitalR]\
\[ScriptCapitalB]\ @\ {\[ScriptL], \ \[ScriptCapitalP]\[ScriptA]\[ScriptR]\
\[ScriptE]\[ScriptN][\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB], \ \[ScriptF]\
\[ScriptO]\[ScriptR]\[ScriptM], \ 
                        Times], \ \[ScriptR]} /; \(! \(({\[ScriptL], \
\[ScriptR]} === {})\)\), \[IndentingNewLine]\[ScriptCapitalB]\ \ @\ \ \
\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_\  \[RuleDelayed] \ 
                MakeBoxes[\[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB], \ \
\[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM]], \[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptD]_?\
\[ScriptCapitalC]\[ScriptO]\[ScriptM]\[ScriptM]\[ScriptA]\[ScriptCapitalQ], \ \
\[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \
\[ScriptCapitalB]\[ScriptCapitalB]\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]_, \ \[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \[ScriptCapitalR]\
\[ScriptCapitalB]\ @\ {\[ScriptL], \ \[ScriptD], \ \[ScriptW], \ 
                    makeHeldSequenceOfBoxes[{\[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptR]}, \[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptCapitalB]\
\[ScriptCapitalB]\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_, \ \
\[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \[ScriptD]_?\
\[ScriptCapitalC]\[ScriptO]\[ScriptM]\[ScriptM]\[ScriptA]\[ScriptCapitalQ], \ \
\[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\
\ {\[ScriptL], \ 
                    makeHeldSequenceOfBoxes[{\[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptW], \ \[ScriptD], \ \[ScriptR]}, \
\[IndentingNewLine]\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \
\[ScriptD]_?\[ScriptCapitalD]\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\
\[ScriptCapitalQ], \ \[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\
\[ScriptCapitalQ], \ \[ScriptCapitalB]\[ScriptCapitalB]\ @\ \[ScriptS]\
\[ScriptY]\[ScriptM]\[ScriptB]_, \ \[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \ \[ScriptD], \ \
\[ScriptW], \ 
                    makeHeldRowBoxOfBoxes[{\[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptR]}, \[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptCapitalB]\
\[ScriptCapitalB]\ @\ \[ScriptS]\[ScriptY]\[ScriptM]\[ScriptB]_, \ \
\[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \[ScriptD]_?\
\[ScriptCapitalD]\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\[ScriptCapitalQ], \ \
\[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\
\ {\[ScriptL], \ 
                    makeHeldRowBoxOfBoxes[{\[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptW], \ \[ScriptD], \ \[ScriptR]}, \
\[IndentingNewLine]\[ScriptCapitalB]\[ScriptCapitalB]\ @\ \ \[ScriptS]\
\[ScriptY]\[ScriptM]\[ScriptB]_\ \ \  \[RuleDelayed] \ 
                makeHeldRowBoxOfBoxes[{\[ScriptS]\[ScriptY]\[ScriptM]\
\[ScriptB]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                  None], \[IndentingNewLine]\[ScriptCapitalR]\[ScriptCapitalB]\
\ @\ \ {\[ScriptL]___, \ \[ScriptD]_?\[ScriptCapitalC]\[ScriptO]\[ScriptM]\
\[ScriptM]\[ScriptA]\[ScriptCapitalQ], \ \[ScriptW]___?\[ScriptCapitalW]\
\[ScriptH]\[ScriptCapitalQ], \ \[ScriptCapitalC]\[ScriptCapitalP]\ @\ \
\[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_, \ \[ScriptR]___}\ \ \  \
\[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \ \
\[ScriptD], \ \[ScriptW], \ 
                    makeEvaluatedSequenceOfBoxes[{\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptR]}, \[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptCapitalC]\
\[ScriptCapitalP]\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_, \ \
\[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \[ScriptD]_?\
\[ScriptCapitalC]\[ScriptO]\[ScriptM]\[ScriptM]\[ScriptA]\[ScriptCapitalQ], \ \
\[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\
\ {\[ScriptL], \ 
                    makeEvaluatedSequenceOfBoxes[{\[ScriptE]\[ScriptX]\
\[ScriptP]\[ScriptR]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptW], \ \[ScriptD], \ \[ScriptR]}, \
\[IndentingNewLine]\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \
\[ScriptD]_?\[ScriptCapitalD]\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\
\[ScriptCapitalQ], \ \[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\
\[ScriptCapitalQ], \ \[ScriptCapitalC]\[ScriptCapitalP]\ @\ \[ScriptE]\
\[ScriptX]\[ScriptP]\[ScriptR]_, \ \[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ {\[ScriptL], \ \[ScriptD], \ \
\[ScriptW], \ 
                    makeEvaluatedRowBoxOfBoxes[{\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptR]}, \[IndentingNewLine]\
\[ScriptCapitalR]\[ScriptCapitalB]\ @\ \ {\[ScriptL]___, \ \[ScriptCapitalC]\
\[ScriptCapitalP]\ @\ \[ScriptE]\[ScriptX]\[ScriptP]\[ScriptR]_, \ \
\[ScriptW]___?\[ScriptCapitalW]\[ScriptH]\[ScriptCapitalQ], \ \[ScriptD]_?\
\[ScriptCapitalD]\[ScriptE]\[ScriptL]\[ScriptI]\[ScriptM]\[ScriptCapitalQ], \ \
\[ScriptR]___}\ \ \  \[RuleDelayed] \ \ \[ScriptCapitalR]\[ScriptCapitalB]\ @\
\ {\[ScriptL], \ 
                    makeEvaluatedRowBoxOfBoxes[{\[ScriptE]\[ScriptX]\[ScriptP]\
\[ScriptR]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                      None], \ \[ScriptW], \ \[ScriptD], \ \[ScriptR]}, \
\[IndentingNewLine]\[ScriptCapitalC]\[ScriptCapitalP]\ @\ \ \[ScriptP]\
\[ScriptA]\[ScriptT]\[ScriptT]_\ \ \  \[RuleDelayed] \ 
                makeEvaluatedRowBoxOfBoxes[{\[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]}, \ \[ScriptF]\[ScriptO]\[ScriptR]\[ScriptM], \ 
                  None]}\[IndentingNewLine]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["\<\
The 2nd argument and beyond of \
convertExternalBoxesForInternalToExternal must be Options.\
\>", \
"NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          convertExternalBoxesForInternalToExternal[_, ___, \[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]_?\((isNot[_?
                    OptionQ])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            convertExternalBoxesForInternalToExternal::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Definition of createInternalToExternalRule", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Creates appropriate ",
  StyleBox["MakeBoxes", "MR"],
  " rule"
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "This creates a ",
  StyleBox["MakeBoxes", "MR"],
  " rule that will format an internal expression into an external box \
structure."
}], "Text"],

Cell[BoxData[
    \(createInternalToExternalRule[\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]With[{\[IndentingNewLine]\[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
            convertExternalBoxesForInternalToExternal\ [\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]\ ], \[IndentingNewLine]\ \[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
            convertInternalBoxesForInternalToExternal\ [\ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]\ ], \[IndentingNewLine]\
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]\ \  = \ \(WorkingForm\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Notation, \[IndentingNewLine]\[ScriptCapitalA]\[ScriptC]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\
\ \ \ \ \ \ \ \ \ \ \ \ \ \  = \ \(Action\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
              adjustedOptions\ @\ 
                Notation}, \
\[IndentingNewLine]\(executeInternalToExternalAction[\[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ \[ScriptE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT], \ \[ScriptCapitalA]\[ScriptC]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]];\)\[IndentingNewLine]]\)], \
"Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Entered, remove or print rule", "NumberedSubsubsubtitle"],

Cell["\<\
This determines if the rule should be entered, removed or \
printed.\
\>", "Text"],

Cell[BoxData[{
    \(executeInternalToExternalAction[\ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]_, \ CreateNotationRules] := \ 
      releaseMyHold[\ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  := \ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\ ]\), "\n", 
    \(executeInternalToExternalAction[\ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]_, \ RemoveNotationRules] := 
      releaseMyHold[\ 
        silentEvaluate\ @\ \((\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  =. \ )\)]\), "\n", 
    \(\(executeInternalToExternalAction[\ \[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]_, \ 
          PrintNotationRules] := \[IndentingNewLine]releaseMyHold\ @\ \
\(CellPrint\ @\ 
            Cell[BoxData\ @\ 
                MakeBoxes[\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  := \ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL], \ StandardForm], "\<Output\>", 
              ShowStringCharacters -> True]\);\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Notation ExternalToInternal", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["convertInternalPatternsForExternalToInternal", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["convertInternalPatternsForExternalToInternal", "MR",
  FontFamily->"Helvetica"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["convertInternalPatternsForExternalToInternal", "MR",
    FontFamily->"Helvetica"],
  StyleBox[" will take an expression consisting of boxes and convert all \
patterns present in the boxes\[LongDash]patterns that are currently still \
unparsed strings and not yet expressions\[LongDash]and convert them to the \
corresponding naked patterned variables stripping out the pattern content , \
leaving all other boxes alone.",
    FontFamily->"Helvetica"]
}], "Text"],

Cell[BoxData[
    \(convertInternalPatternsForExternalToInternal[\[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
          OptionQ] := \[IndentingNewLine]convertPatterns\ @\ \
\(flattenAllMyHold\ @\ 
            boxedStringPatternsToPatterns[\[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\) //. {\
\[IndentingNewLine]singleBlank\ @\ \[ScriptA]_\  \[Rule] \ \[ScriptA], \
\[IndentingNewLine]doubleBlank\ @\ \[ScriptA]_\  \[RuleDelayed] \ 
            stripSpuriousRowBox\ @\ \[ScriptA], \
\[IndentingNewLine]tripleBlank\ @\ \[ScriptA]_\  \[RuleDelayed] \ 
            stripSpuriousRowBox\ @\ \[ScriptA], \
\[IndentingNewLine]complexPattern\ \ @\ \[ScriptA]_\  \[RuleDelayed] \ 
            stripSpuriousRowBox\ @\ \[ScriptA]}\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["convertInternalPatternsForExternalToInternal", "MR",
    FontFamily->"Helvetica"]
}], "NumberedSubsubsubtitle"],

Cell["\<\
The 2nd argument and beyond of \
convertInternalPatternsForExternalToInternal must be Options.\
\>", "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          convertInternalPatternsForExternalToInternal[_, ___, \[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]_?\((isNot[_?
                    OptionQ])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            convertInternalPatternsForExternalToInternal::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(stripSpuriousRowBox\ @\ \(RowBox\ @\ {\[ScriptA]\[ScriptR]\[ScriptG]\
\[ScriptS]___}\) /; 
        MemberQ[{\[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]}, \ "\<,\>"\  | \ "\
\<\[InvisibleComma]\>"]\  := \ \[ScriptA]\[ScriptR]\[ScriptG]\[ScriptS]\), "\
\[IndentingNewLine]", 
    \(stripSpuriousRowBox\ @\ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\
\[ScriptR]___\  := \ \[ScriptO]\[ScriptT]\[ScriptH]\[ScriptE]\[ScriptR]\)}], \
"Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["convertInternalBoxesForExternalToInternal", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(convertInternalBoxesForExternalToInternal[\[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ \[ScriptH]\[ScriptE]\[ScriptA]\
\[ScriptD]\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\[ScriptO]\[ScriptW]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]___?
            OptionQ] \
:= \[IndentingNewLine]With[{\[IndentingNewLine]\[ScriptI]\[ScriptN]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
              convertInternalPatternsForExternalToInternal\ [\ 
                cleanBoxes\ @\ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]\ ], \
\[IndentingNewLine]\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \  = \ \(WorkingForm\ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
                adjustedOptions\ @\ 
                  Notation}, \[IndentingNewLine]If[\[ScriptH]\[ScriptE]\
\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\[ScriptO]\
\[ScriptW]\[ScriptCapitalB]\[ScriptO]\[ScriptX], \[IndentingNewLine]myHold\ @\
\ MakeExpression[
                RowBox[{lhs, \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], 
                    rhs}], \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\
\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]], \[IndentingNewLine]myHold\ @\ 
              MakeExpression[\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["convertExternalPatternsForExternalToInternal", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["convertExternalPatternsForExternalToInternal", \
"MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["convertExternalPatternsForExternalToInternal", "MR"],
  " will take an expression consisting of boxes and convert all patterns \
present in the boxes\[LongDash]patterns that are currently still unparsed \
strings and not yet expressions\[LongDash]and convert them to the \
corresponding patterned expressions, leaving the other boxes alone."
}], "Text"],

Cell[BoxData[
    \(\(convertExternalPatternsForExternalToInternal[\[ScriptP]\[ScriptA]\
\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptCapitalB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]_, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___?
            OptionQ] := \[IndentingNewLine]boxedStringPatternsToPatterns[\
\[ScriptP]\[ScriptA]\[ScriptT]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error checking for ",
  StyleBox["convertInternalPatternsForExternalToInternal", "MR",
    FontFamily->"Helvetica"]
}], "NumberedSubsubsubtitle"],

Cell["\<\
The 2nd argument and beyond of \
convertExternalPatternsForExternalToInternal must be Options.\
\>", "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          convertExternalPatternsForExternalToInternal[_, ___, \[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]_?\((isNot[_?
                    OptionQ])\), ___]\ \  := \ $Failed \
/; \[IndentingNewLine]Message[
            convertExternalPatternsForExternalToInternal::nonopt, \ 
            HoldForm\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptCapitalO]\
\[ScriptP]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN], \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["convertExternalBoxesForExternalToInternal", "NumberedSubsubtitle"],

Cell[BoxData[
    \(\(convertExternalBoxesForExternalToInternal[\[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\
\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ \[ScriptH]\[ScriptE]\[ScriptA]\
\[ScriptD]\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\[ScriptO]\[ScriptW]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\
\[ScriptS]___?
            OptionQ] := \[IndentingNewLine]With[{\[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
              convertExternalPatternsForExternalToInternal\ [\ 
                cleanBoxes\ @\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS], \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]\ ], \
\[IndentingNewLine]\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \  = \ \(WorkingForm\ \  /. \ {\
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
                adjustedOptions\ @\ 
                  Notation}, \[IndentingNewLine]If[\[ScriptH]\[ScriptE]\
\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\[ScriptO]\
\[ScriptW]\[ScriptCapitalB]\[ScriptO]\[ScriptX], \[IndentingNewLine]With[{\
\[ScriptN]\[ScriptE]\[ScriptW]\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
                  RowBox\ @\ {lhs___, 
                      Sequence\  @@ \ \(Sequence\  @@ \ \[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\), 
                      rhs___}}, \[IndentingNewLine]myHold\ @\ 
                NotationMakeExpression[\[ScriptN]\[ScriptE]\[ScriptW]\
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL], \ \[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\
\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\
\[ScriptCapitalO]\[ScriptP]\[ScriptT]]], \[IndentingNewLine]myHold\ @\ 
              
              NotationMakeExpression[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ \[ScriptCapitalW]\[ScriptO]\
\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]]\[IndentingNewLine]]\
\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Definition of createExternalToInternalRule", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Creates appropriate ",
  StyleBox["MakeExpression", "MR"],
  " rule"
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "This creates a ",
  StyleBox["MakeExpression", "MR"],
  " rule that will parse an external box structure into an internal box \
structure."
}], "Text"],

Cell[BoxData[
    \(\(createExternalToInternalRule[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\
\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, \ \[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]_, \ \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] \
:= \[IndentingNewLine]With[{\[ScriptH]\[ScriptE]\[ScriptA]\[ScriptD]\
\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\[ScriptO]\[ScriptW]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\  = \ \((Head\ @\ \
\(convertExternalPatternsForExternalToInternal\ @\ \(cleanBoxes\ @\ \
\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]\)\)\  \
=== \ RowBox)\)}, \[IndentingNewLine]With[{\[IndentingNewLine]\[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
                convertInternalBoxesForExternalToInternal\ [\ \[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptH]\
\[ScriptE]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\
\[ScriptO]\[ScriptW]\[ScriptCapitalB]\[ScriptO]\[ScriptX], \ \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]\ ], \[IndentingNewLine]\[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\  = \ 
                convertExternalBoxesForExternalToInternal\ [\ \[ScriptE]\
\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]\
\[ScriptCapitalB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], \ \[ScriptH]\
\[ScriptE]\[ScriptA]\[ScriptD]\[ScriptCapitalI]\[ScriptS]\[ScriptCapitalR]\
\[ScriptO]\[ScriptW]\[ScriptCapitalB]\[ScriptO]\[ScriptX], \ \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]\ ], \[IndentingNewLine]\[ScriptCapitalW]\
\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\[ScriptCapitalF]\
\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\ \ \  = \ \
\(WorkingForm\ \  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
                  adjustedOptions\ @\ 
                    Notation, \[IndentingNewLine]\[ScriptCapitalA]\[ScriptC]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]\
\  = \ \(Action\  /. \ {\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}\)\  /. \ 
                  adjustedOptions\ @\ 
                    Notation}, \
\[IndentingNewLine]\(executeExternalToInternalAction[\[ScriptE]\[ScriptX]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ \[ScriptI]\
\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL], \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT], \ \[ScriptCapitalA]\[ScriptC]\[ScriptT]\[ScriptI]\[ScriptO]\
\[ScriptN]\[ScriptCapitalO]\[ScriptP]\[ScriptT]];\)\[IndentingNewLine]]];\)\)]\
, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Entered, remove or print rule", "NumberedSubsubsubtitle"],

Cell["\<\
This determines if the rule should be entered, removed or \
printed.\
\>", "Text"],

Cell[BoxData[
    \(\(executeExternalToInternalAction[\ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \ \[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]_, \ CreateNotationRules] := 
        releaseMyHold[\ \[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  := \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL]\ ];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(executeExternalToInternalAction[\ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \ \[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]_, \ RemoveNotationRules] := 
        releaseMyHold[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  =. \ ];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(executeExternalToInternalAction[\ \[ScriptE]\[ScriptX]\[ScriptT]\
\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_, \ \[ScriptI]\[ScriptN]\
\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\[ScriptL]_\ , \ \
\[ScriptCapitalW]\[ScriptO]\[ScriptR]\[ScriptK]\[ScriptI]\[ScriptN]\[ScriptG]\
\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]\[ScriptCapitalO]\[ScriptP]\
\[ScriptT]_, \ PrintNotationRules] := 
        releaseMyHold\ @\ \(CellPrint\ @\ 
            Cell[BoxData\ @\ 
                MakeBoxes[\[ScriptE]\[ScriptX]\[ScriptT]\[ScriptE]\[ScriptR]\
\[ScriptN]\[ScriptA]\[ScriptL]\  := \ \
\[ScriptI]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptR]\[ScriptN]\[ScriptA]\
\[ScriptL], \ StandardForm], "\<Output\>", 
              ShowStringCharacters -> True]\);\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Utilities for the Package and Cleanups", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["ClearNotations", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["ClearNotations[]", "Input"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "This function removes all definitions for ",
  StyleBox["MakeBoxes", "MR"],
  " and ",
  StyleBox["MakeExpression", "MR"],
  ", leaving only the definitions of this package, Notation.m. Use this \
function to reset the notation handling to a pristine state."
}], "Text"],

Cell[BoxData[
    \(If[$NewVersion, \[IndentingNewLine]ClearNotations[]\  := \((\
\[IndentingNewLine]Clear[NotationMakeExpression, NotationMakeBoxes]; 
          NotationMakeExpression[
              TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ 
                NotationBoxTag, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___], \
\ \[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]_]\  := \ 
            HoldComplete\ @\ \(NotationBoxTag\ @\ \[ScriptB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]\); \[IndentingNewLine]NotationMakeBoxes[
              NotationBoxTag[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]__], \ \[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]_] := \ 
            TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], 
              NotationBoxTag, 
              TagStyle \[Rule] "\<NotationTemplateStyle\>"]; \
\[IndentingNewLine]NotationMakeBoxes[
              identityForm[\[ScriptA]\[ScriptN]\[ScriptY]___], \ \[ScriptA]\
\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_] := \ \
\[ScriptA]\[ScriptN]\[ScriptY];)\), \n\[IndentingNewLine]ClearNotations[]\  := \
\((\[IndentingNewLine]Clear[NotationMakeExpression, 
            NotationMakeBoxes]; \[IndentingNewLine]NotationMakeExpression[
              TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_, \ 
                NotationBoxTag, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___], \
\ \[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\
\[ScriptM]_]\  := \ 
            HoldComplete\ @\ \(NotationBoxTag\ @\ \[ScriptB]\[ScriptO]\
\[ScriptX]\[ScriptE]\[ScriptS]\); \[IndentingNewLine]NotationMakeBoxes[
              NotationBoxTag[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\
\[ScriptS]__], \ \[ScriptA]\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\
\[ScriptR]\[ScriptM]_] := \ 
            TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], 
              NotationBoxTag]; \[IndentingNewLine]NotationMakeBoxes[
              identityForm[\[ScriptA]\[ScriptN]\[ScriptY]___], \ \[ScriptA]\
\[ScriptN]\[ScriptY]\[ScriptCapitalF]\[ScriptO]\[ScriptR]\[ScriptM]_] := \ \
\[ScriptA]\[ScriptN]\[ScriptY];)\)\[IndentingNewLine]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["ClearNotations", "MR"],
  "."
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["ClearNotations", "MR"],
  " expects no arguments."
}], "Text"],

Cell[BoxData[{
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          ClearNotations[_]\ \ \  := \ $Failed\  /; 
          Message[ClearNotations::argr, HoldForm\ @\ ClearNotations, 
            0];\)\), "\n", 
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          ClearNotations[_, __]\ \  := \ $Failed\  /; 
          Message[ClearNotations::argrx, HoldForm\ @\ ClearNotations, 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 0];\)\)}], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["UpdateNotebookStyles", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["UpdateNotebookStyles[]", "Input"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["UpdateNotebookStyles", "MR"],
  " will ensure ",
  "the Notation styles are part of the Style Sheet ",
  "add the new notation styles to the style sheet if not. It will also add \
aliases for ",
  StyleBox["Notation", "MR"],
  ", ",
  StyleBox["Symbolize", "MR"],
  ", ",
  StyleBox["InfixNotation", "MR"],
  ", and ",
  StyleBox["AddInputAlias", "MR"],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(UpdateNotebookStyles[] := 
        UpdateNotebookStyles\ @\ InputNotebook[];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(UpdateNotebookStyles\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\
\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]_NotebookObject := \ \
\[IndentingNewLine]If[
        AddStylesToNotebook[
          notationPackageStyles, \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\
\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]], \[IndentingNewLine]SelectionMove[
          MessagesNotebook[], After, 
          Notebook]; \[IndentingNewLine]NotebookWrite[MessagesNotebook[], 
          Cell[\ TextData\ @\[IndentingNewLine]"\<Adding the Notation styles \
to the current style sheet. You might want to execute the command \
UpdateNotationsInNotebook[] to update any legacy notations present in the \
current notebook.\>", "\<Message\>", 
            CellLabel \[Rule] \ "\<From In[\>" <> 
                ToString\ @\ $Line <> "\<]:=\>", 
            ShowCellLabel \[Rule] True]]; \[IndentingNewLine]SetOptions[
          MessagesNotebook[], 
          Visible \[Rule] 
            True]; \[IndentingNewLine]AddInputAlias[{\[IndentingNewLine]"\<\
notation\>" \[Rule] 
              NotationBoxTag @@ {RowBox[{"\<Notation\>", "\<[\>", 
                      RowBox[{TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"], \
"\< \>", "\<\[DoubleLongLeftRightArrow]\>", "\< \>", 
                          TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"]}], \
"\<]\>"}]}, \[IndentingNewLine]\[IndentingNewLine]"\<notation>\>" \[Rule] \
\[IndentingNewLine]NotationBoxTag @@ {RowBox[{"\<Notation\>", "\<[\>", 
                      RowBox[{TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"], \
"\< \>", "\<\[DoubleLongRightArrow]\>", "\< \>", 
                          TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"]}], \
"\<]\>"}]}, \[IndentingNewLine]\[IndentingNewLine]"\<notation<\>" \[Rule] \
\[IndentingNewLine]NotationBoxTag @@ {RowBox[{"\<Notation\>", "\<[\>", 
                      RowBox[{TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"], \
"\< \>", "\<\[DoubleLongLeftArrow]\>", "\< \>", 
                          TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"]}], \
"\<]\>"}]}, \[IndentingNewLine]\[IndentingNewLine]"\<symb\>" \[Rule] \
\[IndentingNewLine]NotationBoxTag @@ {RowBox[{"\<Symbolize\>", "\<[\>", 
                      TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                        TagStyle \[Rule] "\<NotationTemplateStyle\>"], \
"\<]\>"}]}, \[IndentingNewLine]\[IndentingNewLine]"\<infixnotation\>" \[Rule] \
\[IndentingNewLine]NotationBoxTag @@ {RowBox[{"\<InfixNotation\>", "\<[\>", 
                      RowBox[{TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"], \
"\<,\>", "\<\[Placeholder]\>"}], "\<]\>"}]}, \[IndentingNewLine]\
\[IndentingNewLine]"\<addia\>" \[Rule] 
              NotationBoxTag @@ {RowBox[{"\<AddInputAlias\>", "\<[\>", 
                      RowBox[{"\<\"\[Placeholder]\"\>", "\<\[Rule]\>", 
                          TagBox["\<\[Placeholder]\>", NotationBoxTag, 
                            TagStyle \[Rule] "\<NotationTemplateStyle\>"]}], \
"\<]\>"}]}, \[IndentingNewLine]\[IndentingNewLine]"\<pattwraper\>" \[Rule] \ 
              NotationBoxTag @@ {TagBox["\<\[Placeholder]\>", \ 
                    NotationPatternTag, \ 
                    TagStyle\  -> \ "\<NotationPatternWrapperStyle\>"]}, \
\[IndentingNewLine]\[IndentingNewLine]"\<madeboxeswraper\>" \[Rule] 
              NotationBoxTag @@ {TagBox["\<\[Placeholder]\>", \ 
                    NotationMadeBoxesTag, 
                    TagStyle\  -> \ "\<NotationMadeBoxesWrapperStyle\>"]}}];\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["UpdateNotebookStyles", "Input"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The 1st argument of ",
  StyleBox["UpdateNotebookStyles", "Input"],
  " must be a Cell"
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          UpdateNotebookStyles[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalA]\
\[ScriptR]\[ScriptG]_?\((headIsNot[NotebookObject])\), ___]\ \  := \ $Failed /; 
          Message[UpdateNotebookStyles::badarg, \ NotebookObject, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["UpdateNotebookStyles", "Input"],
  " expects zero or one arguments "
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          UpdateNotebookStyles[_, __]\ \  := \ $Failed\  /; \ 
          Message[UpdateNotebookStyles::argt, 
            HoldForm\ @\ UpdateNotebookStyles, 
            heldLength\ @\ \
\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR], 0, 1];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["AddStylesToNotebook", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["AddStylesToNotebook", "Input"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The 1st argument of ",
  StyleBox["AddStylesToNotebook", "Input"],
  " must be a Cell"
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          AddStylesToNotebook[\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalA]\
\[ScriptR]\[ScriptG]_?\((headIsNot[Cell])\), ___]\ \  := \ $Failed /; 
          Message[AddStylesToNotebook::badarg, \ Cell, \ 1, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 2nd argument of ",
  StyleBox["AddStylesToNotebook", "Input"],
  " must be a ",
  StyleBox["NotebookObject", "Input"]
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          AddStylesToNotebook[_, \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalA]\[ScriptR]\[ScriptG]_?\((headIsNot[
                  NotebookObject])\), ___]\ \  := \ $Failed /; 
          Message[AddStylesToNotebook::badarg, \ NotebookObject, \ 2, \ 
            HoldForm\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\
\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "The 3rd argument of ",
  StyleBox["AddStylesToNotebook", "Input"],
  " must be a ",
  StyleBox["Notebook", "Input"]
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          AddStylesToNotebook[_, _, \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalA]\[ScriptR]\[ScriptG]_?\((headIsNot[
                  Notebook])\), ___]\ \  := $Failed /; 
          Message[AddStylesToNotebook::badarg, \ Notebook, \ 3, \ 
            HoldForm@\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]];\)\)]\
, "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["AddStylesToNotebook", "Input"],
  " expects between 1 and 3 arguments"
}], "Text"],

Cell[BoxData[
    \(\(\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]\  : 
          AddStylesToNotebook[___]\ \  := \ 
        With[{\[ScriptN]\[ScriptU]\[ScriptM]\  = \ 
              heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]}, \ $Failed\  /; \[IndentingNewLine]Which[
              1\  > \ \[ScriptN]\[ScriptU]\[ScriptM]\  \[Or] \ \[ScriptN]\
\[ScriptU]\[ScriptM]\  > \ 3, \ 
              Message[AddStylesToNotebook::argb, 
                HoldForm\ @\ 
                  AddStylesToNotebook, \[ScriptN]\[ScriptU]\[ScriptM], 1, \ 
                3], \[IndentingNewLine]True, \ \ False]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["AddStylesToNotebook", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["AddStylesToNotebook", "MR"],
  " will check to see that the style to be added is not part of the style \
sheet. If it is not then copy all the styles into a temporary notebook, add \
the new styles, then change the style sheet to a copy of this temporary \
notebook. The given styles must be contained in a cell or cell group. Also \
make sure that the global context is active to avoid problems with symbol \
contexts. Hopefully this is fixed in a later verion of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(AddStylesToNotebook::usage\  = \
\[IndentingNewLine]"\<AddStylesToNotebook[\[ScriptC]\[ScriptE]\[ScriptL]\
\[ScriptL]], adds the styles in the cell \[ScriptC]\[ScriptE]\[ScriptL]\
\[ScriptL] to the curret notebook. \[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL] \
can consist of a single cell or a cellgroup of other cells. \
AddStylesToNotebook[\[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL],\[ScriptN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK]] adds \
the styles to the notebook \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]. This function is mainly intended as a utility \
for package desginers who use the Notation package.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddStylesToNotebook\ @\ \[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL]_Cell \
:= AddStylesToNotebook[\[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL], 
          InputNotebook[]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(AddStylesToNotebook[\[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL]_Cell, \
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]_NotebookObject] := \ 
        AddStylesToNotebook[\[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL], \
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK], 
          getStyleSheet\ @\ \
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(AddStylesToNotebook[\[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL]_Cell, \
\[ScriptN]\[ScriptB]_NotebookObject, \[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\
\[ScriptE]\[ScriptCapitalS]\[ScriptH]\[ScriptE]\[ScriptE]\[ScriptT]_Notebook] \
:= \[IndentingNewLine]If[
        Or\  @@ \ \(\((FreeQ[{\[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\
\[ScriptE]\[ScriptCapitalS]\[ScriptH]\[ScriptE]\[ScriptE]\[ScriptT]}, #] &)\)\
\  /@ \ Union\ @\ 
              Cases[\[ScriptC]\[ScriptE]\[ScriptL]\[ScriptL], 
                StyleData[_String], {0, \[Infinity]}]\), \
\[IndentingNewLine]Module[{\[ScriptT]\[ScriptE]\[ScriptM]\[ScriptP]\
\[ScriptCapitalN]\[ScriptB]}, \[IndentingNewLine]Begin\ @\ "\<Global`\>"; \
\[IndentingNewLine]\[ScriptT]\[ScriptE]\[ScriptM]\[ScriptP]\[ScriptCapitalN]\
\[ScriptB] = \ 
            NotebookCreate[\ 
              Visible \[Rule] 
                False]; \[IndentingNewLine]NotebookPut[\[ScriptS]\[ScriptT]\
\[ScriptY]\[ScriptL]\[ScriptE]\[ScriptCapitalS]\[ScriptH]\[ScriptE]\[ScriptE]\
\[ScriptT], \[ScriptT]\[ScriptE]\[ScriptM]\[ScriptP]\[ScriptCapitalN]\
\[ScriptB]]; \[IndentingNewLine]SelectionMove[\[ScriptT]\[ScriptE]\[ScriptM]\
\[ScriptP]\[ScriptCapitalN]\[ScriptB], After, 
            Notebook]; \[IndentingNewLine]NotebookWrite[\[ScriptT]\[ScriptE]\
\[ScriptM]\[ScriptP]\[ScriptCapitalN]\[ScriptB], \[ScriptC]\[ScriptE]\
\[ScriptL]\[ScriptL]]; \[IndentingNewLine]SetOptions[\[ScriptN]\[ScriptB], 
            StyleDefinitions \[Rule] 
              NotebookGet\ @\ \[ScriptT]\[ScriptE]\[ScriptM]\[ScriptP]\
\[ScriptCapitalN]\[ScriptB], 
            Visible \[Rule] 
              True\ ]; \[IndentingNewLine]NotebookClose\ @\ \[ScriptT]\
\[ScriptE]\[ScriptM]\[ScriptP]\[ScriptCapitalN]\[ScriptB]; \
\[IndentingNewLine]End[];]; \[IndentingNewLine]True, False]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["GetStyleSheet", "MR"]], "NumberedSubsubsubtitle"],

Cell[TextData[{
  StyleBox["GetStyleSheet", "MR"],
  " will return a notebook corresponding to the styles sheet of the current \
notebook. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 currently returns failed if there is no ",
  StyleBox["StyleDefinitions", "MR"],
  " specified for the notebook. Also ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 returns blanks in the StyleSheetPath directory list, which me must \
remove. Finally make sure when returning the style sheet notebook that ",
  StyleBox["Visible", "MR"],
  " is ",
  StyleBox["False", "MR"],
  " so that the style notebook remains hidden. Also make sure the global \
context is active when getting the style sheet since in 4.0 some system \
symbols appear in the active context."
}], "Text"],

Cell[BoxData[
    \(getStyleSheet[\[ScriptCapitalC]\[ScriptU]\[ScriptR]\[ScriptR]\[ScriptE]\
\[ScriptN]\[ScriptT]\[ScriptCapitalN]\[ScriptB]_NotebookObject] := 
      getStyleSheetAux\ @\ 
        SilentCheck[
          StyleDefinitions /. 
            AbsoluteOptions[\[ScriptCapitalC]\[ScriptU]\[ScriptR]\[ScriptR]\
\[ScriptE]\[ScriptN]\[ScriptT]\[ScriptCapitalN]\[ScriptB], 
              StyleDefinitions], "\<Default.nb\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(getStyleSheetAux\ @\ $Failed := 
        getStyleSheetAux\ @\ "\<Default.nb\>";\)\), "\[IndentingNewLine]", 
    \(\(getStyleSheetAux\ @\ 
          Notebook[\[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\
\[ScriptCapitalS]\[ScriptH]\[ScriptE]\[ScriptE]\[ScriptT]_List, \[ScriptO]\
\[ScriptP]\[ScriptT]\[ScriptS]___?OptionQ] := \ 
        Notebook[\[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\
\[ScriptCapitalS]\[ScriptH]\[ScriptE]\[ScriptE]\[ScriptT], 
          Visible -> 
            False, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]];\)\), "\
\[IndentingNewLine]", 
    \(\(getStyleSheetAux\ @\ \
\[ScriptF]\[ScriptI]\[ScriptL]\[ScriptE]_FrontEnd`FileName\  := \ 
        Get\ @\ \ \(ToFileName\ @\ \
\[ScriptF]\[ScriptI]\[ScriptL]\[ScriptE]\);\)\), "\[IndentingNewLine]", 
    \(getStyleSheetAux\ @\ \[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\
\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]_String \
:= \[IndentingNewLine]Block[{\[ScriptF]\[ScriptI]\[ScriptL]\[ScriptE]\
\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]\[ScriptS]}, \
\[IndentingNewLine]Begin\ @\ "\<Global`\>"; \[IndentingNewLine]\[ScriptF]\
\[ScriptI]\[ScriptL]\[ScriptE]\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]\
\[ScriptS] = \ 
          FileNames[\ \[ScriptS]\[ScriptT]\[ScriptY]\[ScriptL]\[ScriptE]\
\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE], \(\((StyleSheetPath /. 
                    AbsoluteOptions[$FrontEnd, 
                      StyleSheetPath])\) \
/. \[IndentingNewLine]FrontEnd`FileName[{___, 
                      Verbatim\ @\ Blank[], ___}, _] \[RuleDelayed] \ 
                  Sequence\  @@ \ {}\) \
/. \[IndentingNewLine]FrontEnd`FileName[\[ScriptP]\[ScriptA]\[ScriptT]\
\[ScriptH]_List, _] \[RuleDelayed] \ 
                ToFileName\ @\ \[ScriptP]\[ScriptA]\[ScriptT]\[ScriptH]]; \
\[IndentingNewLine]End[]; \[IndentingNewLine]If[
          MatchQ[\[ScriptF]\[ScriptI]\[ScriptL]\[ScriptE]\[ScriptCapitalN]\
\[ScriptA]\[ScriptM]\[ScriptE]\[ScriptS], {__?
                StringQ}], \[IndentingNewLine]getStyleSheetAux@\ \ \(Get\ @\ \
\ \[ScriptF]\[ScriptI]\[ScriptL]\[ScriptE]\[ScriptCapitalN]\[ScriptA]\
\[ScriptM]\[ScriptE]\[ScriptS]\[LeftDoubleBracket]1\[RightDoubleBracket]\), \
\[IndentingNewLine]Message[
            getStyleSheetAux::nostlsh, \[ScriptS]\[ScriptT]\[ScriptY]\
\[ScriptL]\[ScriptE]\[ScriptCapitalN]\[ScriptA]\[ScriptM]\[ScriptE]]; 
          getStyleSheetAux\ @\ "\<Default.nb\>"]\[IndentingNewLine]]\)}], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(getStyleSheetAux::nostlsh = "\<Unable to locate the style sheet `1`. \
Ensure it is on the style sheet path as specified by the option \
'StyleSheetPath' for the $FrontEnd. Using the Default.nb style instead.\>";\)\
\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["UpdateNotationsInNotebook", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "Error Checking for ",
  StyleBox["UpdateNotationsInNotebook", "MR"]
}], "NumberedSubsubsubtitle"],

Cell[TextData[{
  "The first argument of ",
  StyleBox["UpdateNotationsInNotebook", "MR"],
  " must be a notebook object."
}], "Text"],

Cell[BoxData[
    \(\[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalU]\[ScriptP]\[ScriptD]\
\[ScriptA]\[ScriptT]\[ScriptE]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptA]\
\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptS] : \ 
        UpdateNotationsInNotebook[\[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]_, ___]\  := \ \[IndentingNewLine]\((Message[
            UpdateNotationsInNotebook::badnb, \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalN]\
\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK], \ 
            HoldForm\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\[ScriptCapitalU]\
\[ScriptP]\[ScriptD]\[ScriptA]\[ScriptT]\[ScriptE]\[ScriptCapitalN]\[ScriptO]\
\[ScriptT]\[ScriptA]\[ScriptT]\[ScriptI]\[ScriptO]\[ScriptN]\[ScriptS]]; \ \
$Failed)\) /; \[IndentingNewLine]Head\ @\ \[ScriptB]\[ScriptA]\[ScriptD]\
\[ScriptCapitalN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK]\  =!= \ NotebookObject\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(UpdateNotationsInNotebook::badnb\  = \ "\<The first argument of `2` \
is not a notebook object.\>";\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  StyleBox["UpdateNotationsInNotebook", "MR"],
  " expects zero or one arguments "
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
        "\[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\[ScriptR]", " ", ":", 
          RowBox[{
            StyleBox["UpdateNotationsInNotebook",
              "MR"], "[", \(_, __\), "]"}]}], "  ", ":=", " ", 
        RowBox[{"$Failed", " ", "/;", "\[IndentingNewLine]", 
          RowBox[{"Message", "[", 
            RowBox[{
              RowBox[{
                StyleBox["UpdateNotationsInNotebook",
                  "MR"], "::", "argt"}], ",", 
              RowBox[{"HoldForm", " ", "@", " ", 
                StyleBox["UpdateNotationsInNotebook",
                  "MR"]}], 
              ",", \(heldLength\ @\ \[ScriptE]\[ScriptR]\[ScriptR]\[ScriptO]\
\[ScriptR]\), ",", "0", ",", "1"}], "]"}]}]}], ";"}]], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["UpdateNotationsInNotebook", "Input"]], \
"NumberedSubsubsubtitle"],

Cell[TextData[{
  "If the Notebook contains old notation statement usages then ",
  StyleBox["UpdateNotationsInNotebook", "MR"],
  " will create a new updated duplicate."
}], "Text"],

Cell[BoxData[
    \(\(UpdateNotationsInNotebook\ [] := \ 
        UpdateNotationsInNotebook\ @\ InputNotebook[];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(UpdateNotationsInNotebook\ @\ \(HoldPattern\ @\ \
\[ScriptN]\[ScriptB]_NotebookObject\) := \[IndentingNewLine]If[$NewVersion\  \
\[And] \ \[Not] FreeQ[
                NotebookGet\ @\ \[ScriptN]\[ScriptB], \
\[IndentingNewLine]TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS]_,\
 NotationBoxTag, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] /; 
                  FreeQ[{\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}, 
                    TagStyle -> "\<NotationTemplateStyle\>"]], \
\[IndentingNewLine]Module[{\[ScriptN]\[ScriptE]\[ScriptW]\[ScriptCapitalC]\
\[ScriptO]\[ScriptN]\[ScriptT]\[ScriptE]\[ScriptN]\[ScriptT] = 
                massageNotebook\ @\ \(NotebookGet\ @\ \
\[ScriptN]\[ScriptB]\)}, \[IndentingNewLine]SetOptions[\[ScriptN]\[ScriptB], 
              Visible \[Rule] \ 
                False]; \
\[IndentingNewLine]SelectionMove[\[ScriptN]\[ScriptB], All, 
              Notebook]; \[IndentingNewLine]NotebookPut\ [\ \[ScriptN]\
\[ScriptE]\[ScriptW]\[ScriptCapitalC]\[ScriptO]\[ScriptN]\[ScriptT]\[ScriptE]\
\[ScriptN]\[ScriptT], \[ScriptN]\[ScriptB]]; \[IndentingNewLine]SetOptions[\
\[ScriptN]\[ScriptB], 
              Sequence\  @@ \[IndentingNewLine]MapAt["\<Updated Notations - \
\>" <> # &, AbsoluteOptions[\[ScriptN]\[ScriptB], WindowTitle], {1, 
                    2}]]; \[IndentingNewLine]SetOptions[\[ScriptN]\[ScriptB], 
              Visible \[Rule] 
                True]; \[IndentingNewLine]SetSelectedNotebook\ @\ \[ScriptN]\
\[ScriptB];\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["massageNotebook", "Input"]], "NumberedSubsubsubtitle"],

Cell["\<\
Where we need to massage a notebook by removing any references to \
its window size and positioning or else it will appear right on top of the \
old window. Also we must update any legacy notation statments, which was the \
whole point of the original function.\
\>", "Text"],

Cell[BoxData[
    \(massageNotebook\ @\ \[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\
\[ScriptO]\[ScriptO]\[ScriptK]_Notebook\  := \[IndentingNewLine]DeleteCases[\
\[ScriptN]\[ScriptO]\[ScriptT]\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\
\[ScriptK], \((ScreenRectangle \[Rule] \ _)\) | \((WindowSize\  \[Rule] \ \
_)\) | \((WindowMargins\  \[Rule] \ _)\), 
          1] //. \[IndentingNewLine]\(\(TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\
\[ScriptE]\[ScriptS]_, 
              NotationBoxTag, \[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]___] /; 
            FreeQ[{\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]}, 
              TagStyle \[Rule] "\<NotationTemplateStyle\>"]\  \[RuleDelayed] \
\[IndentingNewLine]TagBox[\[ScriptB]\[ScriptO]\[ScriptX]\[ScriptE]\[ScriptS], 
            NotationBoxTag, 
            TagStyle \[Rule] "\<NotationTemplateStyle\>", \
\[ScriptO]\[ScriptP]\[ScriptT]\[ScriptS]]\)\(\n\)
        \)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Endings", "NumberedSubtitle"],

Cell[CellGroupData[{

Cell["Establish Auto interactive values", "NumberedSubsubtitle"],

Cell["If any of these values are undefined they default to True.", "Text"],

Cell[BoxData[
    \(\(If[\[Not] ValueQ\ @\ AutoLoadNotationPalette, 
        AutoLoadNotationPalette = True];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(If[\[Not] ValueQ\ @\ AutoUpdateNotationStyleSheet, 
        AutoUpdateNotationStyleSheet = True];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Open the Palettes", "NumberedSubsubtitle"],

Cell[TextData[{
  "Open the Notation palette by default. Note with remote kernels ",
  StyleBox["NotebookOpen", "MR"],
  " does not work properly.  Make sure the main notebook ",
  "remains",
  " selected."
}], "Text"],

Cell[BoxData[
    \(If[\ 
      AutoLoadNotationPalette\  === \ 
        True, \[IndentingNewLine]Module[{\[ScriptN]\[ScriptB]\  = \ 
            InputNotebook[], \[ScriptD]\[ScriptI]\[ScriptR]\  = \
{$TopDirectory, "\<AddOns\>", "\<ExtraPackages\>", "\<Utilities\>"}\ }, \
\[IndentingNewLine]If[$Linked, \[IndentingNewLine]NotebookPut\ @\ \(Get\ @\ \ \
ToFileName[\[ScriptD]\[ScriptI]\[ScriptR], \ "\<NotationPalette.nb\>"]\), \
\[IndentingNewLine]NotebookOpen\ @\ \ ToFileName[\[ScriptD]\[ScriptI]\
\[ScriptR], \ "\<NotationPalette.nb\>"]]; \
\[IndentingNewLine]SetSelectedNotebook\ @\ \[ScriptN]\[ScriptB];]]\)], "Input",\

  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Update the style sheet if necessary", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["notationPackageStyles", "Input"]], \
"NumberedSubsubsubtitle"],

Cell["\<\
This defines the styles the Notation package adds to the style \
sheet.\
\>", "Text"],

Cell[BoxData[
    \(\(notationPackageStyles := \[IndentingNewLine]Cell[
          CellGroupData[{\[IndentingNewLine]Cell["\<Notation Package \
Styles\>", \ "\<Section\>", 
                CellTags -> "\<NotationPackage\>"], \[IndentingNewLine]\
\[IndentingNewLine]Cell["\<The cells below define certain styles needed by \
the Notation package. These styles serve to make visible otherwise invisible \
tagboxes.\>", \ "\<Text\>", 
                CellTags -> "\<NotationPackage\>"], \[IndentingNewLine]\
\[IndentingNewLine]Cell[
                StyleData["\<NotationTemplateStyle\>"], \
\[IndentingNewLine]StyleMenuListing -> None, \[IndentingNewLine]Background -> 
                  RGBColor[1, \ 1, \ 
                    0.85], \[IndentingNewLine]TagBoxOptions -> {SyntaxForm -> \
"\<symbol\>"}, \[IndentingNewLine]CellTags -> "\<NotationPackage\>"], \
\[IndentingNewLine]\[IndentingNewLine]Cell[
                StyleData["\<NotationPatternWrapperStyle\>"], \
\[IndentingNewLine]StyleMenuListing -> None, \[IndentingNewLine]Background -> 
                  RGBColor[1, \ 0.9, \ 
                    0.98], \[IndentingNewLine]TagBoxOptions -> {SyntaxForm -> \
"\<symbol\>"}, \[IndentingNewLine]CellTags -> "\<NotationPackage\>"], \
\[IndentingNewLine]\[IndentingNewLine]Cell[
                StyleData["\<NotationMadeBoxesWrapperStyle\>"], \
\[IndentingNewLine]\ 
                StyleMenuListing -> None, \[IndentingNewLine]Background -> 
                  RGBColor[0.9, \ 0.89, \ 
                    1], \[IndentingNewLine]TagBoxOptions -> {SyntaxForm -> \
"\<symbol\>"}, \[IndentingNewLine]CellTags -> "\<NotationPackage\>"]\
\[IndentingNewLine]}, Closed\ \ ]];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["update notebook styles if appropriate", "NumberedSubsubsubtitle"],

Cell[TextData[{
  "Finally if the version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is 4.0 or greater than ensure the ",
  StyleBox["Notation",
    FontSlant->"Italic"],
  " styles are in the Style Sheet and if not add them to the style sheet."
}], "Text"],

Cell[BoxData[
    \(\(If[$NewVersion\  \[And] \ 
          AutoUpdateNotationStyleSheet, \(UpdateNotebookStyles\ @\ \[ScriptI]\
\[ScriptN]\[ScriptP]\[ScriptU]\[ScriptT]\[ScriptCapitalN]\[ScriptO]\[ScriptT]\
\[ScriptE]\[ScriptB]\[ScriptO]\[ScriptO]\[ScriptK];\)];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["End the package", "NumberedSubsubtitle"],

Cell[CellGroupData[{

Cell["End Private", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(End[];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Protect Notation functions", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(SetAttributes[{ClearNotations, InfixNotation, Notation, NotationBoxTag, 
        RemoveInfixNotation, RemoveNotation, RemoveSymbolize, 
        Symbolize, \[IndentingNewLine]AddInputAlias, ActiveInputAliases, 
        UpdateNotationsInNotebook}, {ReadProtected, Protected}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(SetAttributes[{Action, CreateNotationRules, NotationBoxTag, 
        NotationPatternTag, NotationMadeBoxesTag, PrintNotationRules, 
        RemoveNotationRules, SymbolizeRootName, 
        WorkingForm, $NotationVersion}, {Protected}]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["End the Package", "NumberedSubsubsubtitle"],

Cell[BoxData[
    \(\(EndPackage[];\)\)], "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 551}, {0, 363}},
AutoGeneratedPackage->None,
WindowToolbars->{},
WindowSize->{1050, 666},
WindowMargins->{{Automatic, 47}, {Automatic, 29}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellTags->True,
InputAliases->{
  "ula"->"\[UpperLeftArrow]", "ui"->"\[UpArrow]", "di"->"\[DownArrow]", 
    "ura"->"\[UpperRightArrow]", "dra"->"\[LowerRightArrow]", 
    "join"->SubscriptBox[ "+", 
        RowBox[ {"{", "}"}]]},
LineIndent->3,
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->12],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{8, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->8],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    LineSpacing->{1, 11},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
    
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontSlant->"Plain"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
    
    LineSpacing->{1, 7},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
    
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Times",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 0\
.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica",
         "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
    
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                  BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
                0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
        "MMA"->"Mathematica", "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
    
    Hyphenation->True,
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    DefaultNewInlineCellStyle->"None",
    Hyphenation->True,
    LineSpacing->{1, 3},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->0.5,
    FontSize->7]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Plain"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}},
    FontSize->11],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}},
    FontSize->11],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontSize->11,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}},
    FontSize->11],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FrameLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["FrameLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["FrameLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["FrameLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->False,
    LanguageCategory->"Formula",
    ScriptLevel->1,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1},
    FontSize->11],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{59, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{108, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{158, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None",
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["Hyperlink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["MainBookLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["AddOnsLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["GettingStartedLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["OtherInformationLink", "Condensed"],
    FontSize->11],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, Placeholder]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Condensed"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    LanguageCategory->"Formula",
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Numbered objects", "Section"],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Numbered Headings", "Subsection",
    CounterAssignments->{{"Title", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}, {"ReferenceNumber", 0}}],
  
  Cell[StyleData["TitleCounterStyle"],
    StyleMenuListing->None,
    CounterBoxOptions->{
    CounterFunction:>(
      Part[ {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "A", "B", "C",
         "D", "E", "F", "G", "H"}, #]&)}],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedTitle"],
    PageWidth->WindowWidth,
    ShowClosedCellArea->True,
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"SectionGrouping", 0},
    PageBreakAbove->True,
    PageBreakBelow->False,
    CellFrameLabels->{{Inherited, None}, {None, None}},
    CounterIncrements->"Title",
    CounterAssignments->{{"Subtitle", 0}, {"Subsubtitle", 0}, {
        "Subsubsubtitle", 0}, {"ReferenceNumber", 0}, {"Section", 0}, {
        "Equation", 0}, {"Figure", 0}, {"Lemma", 0}, {"Theorem", 0}, {
        "Corollary", 0}, {"Definition", 0}, {"Conjecture", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["NumberedTitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["NumberedTitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["NumberedTitle", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->24,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedSubtitle"],
    PageWidth->WindowWidth,
    ShowClosedCellArea->True,
    CellMargins->{{12, Inherited}, {10, 50}},
    CellGroupingRules->{"SectionGrouping", 10},
    PageBreakBelow->False,
    CellFrameLabels->{{Cell[ 
            TextData[ {
              CounterBox[ "Title", CounterStyle -> "TitleCounterStyle"], ".", 
              
              CounterBox[ "Subtitle"], " "}]], None}, {None, None}},
    CounterIncrements->{"Subtitle", "RunningHead"},
    CounterAssignments->{{"Subsubtitle", 0}, {"Subsubsubtitle", 0}, {
        "ReferenceNumber", 0}, {"Section", 0}, {"Equation", 0}, {
        "Figure", 0}, {"Lemma", 0}, {"Theorem", 0}, {"Corollary", 0}, {
        "Definition", 0}, {"Conjecture", 0}},
    FontFamily->"Helvetica",
    FontSize->24,
    FontColor->RGBColor[0, 0.026688, 0.2]],
  
  Cell[StyleData["NumberedSubtitle", "Presentation"],
    CellMargins->{{24, 10}, {15, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["NumberedSubtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["NumberedSubtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedSubsubtitle"],
    PageWidth->WindowWidth,
    ShowClosedCellArea->True,
    CellMargins->{{12, Inherited}, {10, 30}},
    CellGroupingRules->{"SectionGrouping", 20},
    PageBreakBelow->False,
    CellFrameLabels->{{Cell[ 
            TextData[ {
              CounterBox[ "Title", CounterStyle -> "TitleCounterStyle"], ".", 
              
              CounterBox[ "Subtitle"], ".", 
              CounterBox[ "Subsubtitle"], " "}]], None}, {None, None}},
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Subsubsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontColor->RGBColor[0.18999, 0, 0.148836]],
  
  Cell[StyleData["NumberedSubsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {10, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["NumberedSubsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 12}},
    FontSize->12],
  
  Cell[StyleData["NumberedSubsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->14,
    FontSlant->"Plain"]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedSubsubsubtitle"],
    PageWidth->WindowWidth,
    ShowClosedCellArea->False,
    CellMargins->{{12, Inherited}, {10, 20}},
    CellElementSpacings->{"ClosedCellHeight"->19,
    "ClosedGroupTopMargin"->0},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameLabels->{{Cell[ 
            TextData[ {
              CounterBox[ "Title", CounterStyle -> "TitleCounterStyle"], ".", 
              
              CounterBox[ "Subtitle"], ".", 
              CounterBox[ "Subsubtitle"], ".", 
              CounterBox[ "Subsubsubtitle"], " "}]], None}, {None, None}},
    CounterIncrements->"Subsubsubtitle",
    CounterAssignments->{{"Section", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Plain",
    FontSlant->"Plain",
    FontColor->RGBColor[0.149996, 0, 0]],
  
  Cell[StyleData["NumberedSubsubsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {10, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["NumberedSubsubsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 12}},
    FontSize->12],
  
  Cell[StyleData["NumberedSubsubsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->14,
    FontSlant->"Plain"]
  }, Open  ]]
  }, Open  ]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.760006, 0.330007, 0.8]]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 122, 4, 156, "Title"],
Cell[1901, 59, 218, 6, 58, "Subsubtitle"],
Cell[2122, 67, 329, 10, 94, "Text",
  PageBreakAbove->True,
  PageBreakBelow->False],

Cell[CellGroupData[{
Cell[2476, 81, 46, 0, 96, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[2547, 85, 44, 0, 70, "NumberedSubsubtitle"],
Cell[2594, 87, 111, 2, 70, "Input",
  InitializationCell->True],
Cell[2708, 91, 416, 9, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3149, 104, 126, 4, 70, "NumberedSubsubsubtitle"],
Cell[3278, 110, 309, 6, 70, "Input",
  InitializationCell->True],
Cell[3590, 118, 428, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4055, 131, 175, 6, 70, "NumberedSubsubsubtitle"],
Cell[4233, 139, 93, 2, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4375, 147, 49, 0, 70, "NumberedSubsubtitle"],
Cell[4427, 149, 91, 2, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4543, 155, 58, 0, 70, "NumberedSubsubsubtitle"],
Cell[4604, 157, 108, 3, 70, "Text"],
Cell[4715, 162, 236, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4988, 171, 120, 4, 70, "NumberedSubsubsubtitle"],
Cell[5111, 177, 225, 7, 70, "Text"],
Cell[5339, 186, 1282, 23, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[6658, 214, 74, 0, 70, "NumberedSubsubsubtitle"],
Cell[6735, 216, 191, 4, 70, "Text"],
Cell[6929, 222, 339, 7, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[7305, 234, 115, 1, 70, "NumberedSubsubsubtitle"],
Cell[7423, 237, 195, 2, 70, "Text"],
Cell[7621, 241, 224, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[7882, 251, 89, 1, 70, "NumberedSubsubsubtitle"],
Cell[7974, 254, 189, 2, 70, "Text"],
Cell[8166, 258, 513, 8, 70, "Input",
  InitializationCell->True],
Cell[8682, 268, 277, 5, 70, "Input",
  InitializationCell->True],
Cell[8962, 275, 571, 11, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[9570, 291, 73, 0, 70, "NumberedSubsubsubtitle"],
Cell[9646, 293, 250, 6, 70, "Text"],
Cell[9899, 301, 110, 2, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[10046, 308, 77, 0, 70, "NumberedSubsubsubtitle"],
Cell[10126, 310, 71, 2, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10246, 318, 55, 0, 70, "NumberedSubsubtitle"],
Cell[10304, 320, 362, 6, 70, "Input",
  InitializationCell->True],
Cell[10669, 328, 282, 6, 70, "Input",
  InitializationCell->True],
Cell[10954, 336, 222, 4, 70, "Input",
  InitializationCell->True],
Cell[11179, 342, 609, 9, 70, "Input",
  InitializationCell->True],
Cell[11791, 353, 429, 7, 70, "Input",
  InitializationCell->True],
Cell[12223, 362, 1833, 25, 70, "Input",
  InitializationCell->True],
Cell[14059, 389, 1493, 21, 70, "Input",
  InitializationCell->True],
Cell[15555, 412, 309, 5, 70, "Input",
  InitializationCell->True],
Cell[15867, 419, 429, 7, 70, "Input",
  InitializationCell->True],
Cell[16299, 428, 415, 6, 70, "Input",
  InitializationCell->True],
Cell[16717, 436, 330, 5, 70, "Input",
  InitializationCell->True],
Cell[17050, 443, 371, 6, 70, "Input",
  InitializationCell->True],
Cell[17424, 451, 325, 5, 70, "Input",
  InitializationCell->True],
Cell[17752, 458, 357, 6, 70, "Input",
  InitializationCell->True],
Cell[18112, 466, 358, 6, 70, "Input",
  InitializationCell->True],
Cell[18473, 474, 379, 6, 70, "Input",
  InitializationCell->True],
Cell[18855, 482, 524, 8, 70, "Input",
  InitializationCell->True],
Cell[19382, 492, 310, 5, 70, "Input",
  InitializationCell->True],
Cell[19695, 499, 285, 5, 70, "Input",
  InitializationCell->True],
Cell[19983, 506, 541, 8, 70, "Input",
  InitializationCell->True],
Cell[20527, 516, 854, 13, 70, "Input",
  InitializationCell->True],
Cell[21384, 531, 706, 11, 70, "Input",
  InitializationCell->True],
Cell[22093, 544, 1018, 14, 70, "Input",
  InitializationCell->True],
Cell[23114, 560, 434, 7, 70, "Input",
  InitializationCell->True],
Cell[23551, 569, 205, 4, 70, "Input",
  InitializationCell->True],
Cell[23759, 575, 166, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],
Cell[23940, 581, 57, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[24022, 585, 83, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[24130, 590, 110, 4, 70, "NumberedSubsubsubtitle"],
Cell[24243, 596, 253, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[24533, 606, 111, 4, 70, "NumberedSubsubsubtitle"],
Cell[24647, 612, 303, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[24987, 623, 115, 4, 70, "NumberedSubsubsubtitle"],
Cell[25105, 629, 248, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[25402, 640, 52, 0, 70, "NumberedSubsubtitle"],
Cell[25457, 642, 91, 2, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[25585, 649, 46, 0, 70, "NumberedSubsubtitle"],
Cell[25634, 651, 118, 3, 70, "JasonComment"],
Cell[25755, 656, 420, 12, 70, "Text"],
Cell[26178, 670, 626, 10, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26853, 686, 50, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[26928, 690, 53, 0, 70, "NumberedSubsubtitle"],
Cell[26984, 692, 470, 12, 70, "Text"],
Cell[27457, 706, 1182, 20, 70, "Input",
  InitializationCell->True],
Cell[28642, 728, 129, 3, 70, "Input",
  InitializationCell->True],
Cell[28774, 733, 277, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[29088, 743, 54, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[29167, 747, 75, 0, 70, "NumberedSubsubsubtitle"],
Cell[29245, 749, 158, 4, 70, "Text"],
Cell[29406, 755, 565, 9, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[30008, 769, 85, 1, 70, "NumberedSubsubsubtitle"],
Cell[30096, 772, 226, 4, 70, "Text"],
Cell[30325, 778, 1493, 28, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[31867, 812, 40, 0, 70, "NumberedSubsubtitle"],
Cell[31910, 814, 417, 10, 70, "Text"],
Cell[32330, 826, 937, 15, 70, "Input",
  InitializationCell->True],
Cell[33270, 843, 788, 13, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[34095, 861, 42, 0, 70, "NumberedSubsubtitle"],
Cell[34140, 863, 205, 4, 70, "Text"],
Cell[34348, 869, 1356, 22, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35753, 897, 41, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[35819, 901, 91, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[35935, 906, 84, 1, 70, "NumberedSubsubsubtitle"],
Cell[36022, 909, 186, 6, 70, "Text"],
Cell[36211, 917, 552, 9, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[36800, 931, 77, 0, 70, "NumberedSubsubsubtitle"],
Cell[36880, 933, 176, 6, 70, "Text"],
Cell[37059, 941, 115, 2, 70, "Input",
  InitializationCell->True],
Cell[37177, 945, 544, 9, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37770, 960, 45, 0, 70, "NumberedSubsubtitle"],
Cell[37818, 962, 356, 12, 70, "Text"],
Cell[38177, 976, 422, 7, 70, "Input",
  InitializationCell->True],
Cell[38602, 985, 825, 15, 70, "Input",
  InitializationCell->True],
Cell[39430, 1002, 104, 2, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[39571, 1009, 50, 0, 70, "NumberedSubsubtitle"],
Cell[39624, 1011, 338, 10, 70, "Text"],
Cell[39965, 1023, 642, 11, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[40644, 1039, 54, 0, 70, "NumberedSubsubtitle"],
Cell[40701, 1041, 292, 10, 70, "Text"],
Cell[40996, 1053, 249, 6, 70, "Input",
  InitializationCell->True],
Cell[41248, 1061, 97, 2, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[41394, 1069, 55, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[41474, 1073, 42, 0, 70, "NumberedSubsubtitle"],
Cell[41519, 1075, 129, 3, 70, "Text"],
Cell[41651, 1080, 942, 14, 70, "Input",
  InitializationCell->True],
Cell[42596, 1096, 145, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[42778, 1104, 45, 0, 70, "NumberedSubsubtitle"],
Cell[42826, 1106, 132, 3, 70, "Text"],
Cell[42961, 1111, 184, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[43182, 1119, 107, 3, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[43314, 1126, 90, 1, 70, "NumberedSubsubsubtitle"],
Cell[43407, 1129, 432, 12, 70, "Text"],
Cell[43842, 1143, 2441, 35, 70, "Input",
  InitializationCell->True],
Cell[46286, 1180, 1156, 17, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[47479, 1202, 129, 4, 70, "NumberedSubsubsubtitle"],
Cell[47611, 1208, 129, 4, 70, "Text"],
Cell[47743, 1214, 473, 8, 70, "Input",
  InitializationCell->True],
Cell[48219, 1224, 112, 3, 70, "Text"],
Cell[48334, 1229, 590, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[48973, 1247, 64, 0, 70, "NumberedSubsubtitle"],
Cell[49040, 1249, 208, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[49273, 1258, 68, 0, 70, "NumberedSubsubsubtitle"],
Cell[49344, 1260, 188, 5, 70, "Text"],
Cell[49535, 1267, 433, 7, 70, "Input",
  InitializationCell->True],
Cell[49971, 1276, 277, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[50285, 1287, 77, 0, 70, "NumberedSubsubsubtitle"],
Cell[50365, 1289, 124, 3, 70, "Text"],
Cell[50492, 1294, 607, 11, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[51136, 1310, 135, 4, 70, "NumberedSubsubsubtitle"],
Cell[51274, 1316, 155, 4, 70, "Text"],
Cell[51432, 1322, 727, 16, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52208, 1344, 58, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[52291, 1348, 82, 1, 70, "NumberedSubsubsubtitle"],
Cell[52376, 1351, 125, 3, 70, "Text"],
Cell[52504, 1356, 4245, 63, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[56786, 1424, 111, 3, 70, "NumberedSubsubsubtitle"],
Cell[56900, 1429, 120, 4, 70, "Text"],
Cell[57023, 1435, 468, 8, 70, "Input",
  InitializationCell->True],
Cell[57494, 1445, 121, 4, 70, "Text"],
Cell[57618, 1451, 458, 8, 70, "Input",
  InitializationCell->True],
Cell[58079, 1461, 104, 3, 70, "Text"],
Cell[58186, 1466, 646, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[58893, 1484, 64, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[58982, 1488, 117, 3, 69, "NumberedSubsubtitle"],
Cell[59102, 1493, 177, 4, 70, "Text"],
Cell[59282, 1499, 250, 5, 70, "Input",
  InitializationCell->True],
Cell[59535, 1506, 187, 4, 70, "Text"],
Cell[59725, 1512, 308, 5, 70, "Input",
  InitializationCell->True],
Cell[60036, 1519, 192, 4, 70, "Text"],
Cell[60231, 1525, 200, 6, 70, "Input",
  InitializationCell->True],
Cell[60434, 1533, 378, 11, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[60849, 1549, 44, 0, 37, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[60918, 1553, 73, 0, 46, "NumberedSubsubsubtitle"],
Cell[60994, 1555, 122, 3, 70, "Text"],
Cell[61119, 1560, 685, 15, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[61841, 1580, 104, 3, 28, "NumberedSubsubsubtitle"],
Cell[61948, 1585, 94, 3, 32, "Text"],
Cell[62045, 1590, 534, 10, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[62628, 1606, 56, 0, 69, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[62709, 1610, 87, 1, 70, "NumberedSubsubsubtitle"],
Cell[62799, 1613, 233, 6, 70, "Text"],
Cell[63035, 1621, 309, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[63381, 1631, 116, 3, 70, "NumberedSubsubsubtitle"],
Cell[63500, 1636, 106, 3, 70, "Text"],
Cell[63609, 1641, 585, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[64243, 1659, 60, 0, 43, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[64328, 1663, 91, 1, 70, "NumberedSubsubsubtitle"],
Cell[64422, 1666, 237, 6, 70, "Text"],
Cell[64662, 1674, 330, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[65029, 1685, 120, 3, 70, "NumberedSubsubsubtitle"],
Cell[65152, 1690, 110, 3, 70, "Text"],
Cell[65265, 1695, 584, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[65898, 1713, 45, 0, 43, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[65968, 1717, 74, 0, 70, "NumberedSubsubsubtitle"],
Cell[66045, 1719, 283, 8, 70, "Text"],
Cell[66331, 1729, 1503, 26, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[67871, 1760, 105, 3, 70, "NumberedSubsubsubtitle"],
Cell[67979, 1765, 121, 4, 70, "Text"],
Cell[68103, 1771, 433, 8, 70, "Input",
  InitializationCell->True],
Cell[68539, 1781, 156, 3, 70, "Input",
  InitializationCell->True],
Cell[68698, 1786, 95, 3, 70, "Text"],
Cell[68796, 1791, 535, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[69380, 1808, 46, 0, 43, "NumberedSubsubtitle"],
Cell[69429, 1810, 263, 8, 70, "Text"],
Cell[69695, 1820, 599, 11, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[70319, 1835, 99, 3, 70, "NumberedSubsubsubtitle"],
Cell[70421, 1840, 868, 16, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[71326, 1861, 105, 3, 70, "NumberedSubsubsubtitle"],
Cell[71434, 1866, 495, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[71966, 1879, 106, 3, 70, "NumberedSubsubsubtitle"],
Cell[72075, 1884, 96, 3, 70, "Text"],
Cell[72174, 1889, 538, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[72761, 1906, 45, 0, 43, "NumberedSubsubtitle"],
Cell[72809, 1908, 269, 8, 70, "Text"],
Cell[73081, 1918, 573, 11, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[73679, 1933, 98, 3, 70, "NumberedSubsubsubtitle"],
Cell[73780, 1938, 3427, 74, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[77244, 2017, 105, 3, 70, "NumberedSubsubsubtitle"],
Cell[77352, 2022, 429, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[77818, 2035, 105, 3, 70, "NumberedSubsubsubtitle"],
Cell[77926, 2040, 95, 3, 70, "Text"],
Cell[78024, 2045, 535, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[78608, 2062, 47, 0, 43, "NumberedSubsubtitle"],
Cell[78658, 2064, 266, 8, 70, "Text"],
Cell[78927, 2074, 577, 9, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[79529, 2087, 100, 3, 70, "NumberedSubsubsubtitle"],
Cell[79632, 2092, 1057, 23, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[80726, 2120, 107, 3, 70, "NumberedSubsubsubtitle"],
Cell[80836, 2125, 415, 7, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[81288, 2137, 107, 3, 70, "NumberedSubsubsubtitle"],
Cell[81398, 2142, 97, 3, 70, "Text"],
Cell[81498, 2147, 541, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[82088, 2164, 40, 0, 43, "NumberedSubsubtitle"],
Cell[82131, 2166, 150, 5, 70, "Text"],
Cell[82284, 2173, 397, 7, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[82706, 2184, 100, 3, 70, "NumberedSubsubsubtitle"],
Cell[82809, 2189, 90, 3, 70, "Text"],
Cell[82902, 2194, 520, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[83471, 2211, 41, 0, 43, "NumberedSubsubtitle"],
Cell[83515, 2213, 260, 8, 70, "Text"],
Cell[83778, 2223, 553, 9, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[84356, 2236, 94, 3, 70, "NumberedSubsubsubtitle"],
Cell[84453, 2241, 632, 10, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[85122, 2256, 101, 3, 70, "NumberedSubsubsubtitle"],
Cell[85226, 2261, 916, 14, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[86179, 2280, 107, 3, 70, "NumberedSubsubsubtitle"],
Cell[86289, 2285, 91, 3, 70, "Text"],
Cell[86383, 2290, 523, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[86955, 2307, 54, 0, 43, "NumberedSubsubtitle"],
Cell[87012, 2309, 338, 9, 70, "Text"],
Cell[87353, 2320, 680, 12, 70, "Input",
  InitializationCell->True],
Cell[88036, 2334, 1434, 24, 70, "Input",
  InitializationCell->True],
Cell[89473, 2360, 811, 13, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[90321, 2378, 75, 0, 43, "NumberedSubsubtitle"],
Cell[90399, 2380, 126, 4, 70, "Text"],
Cell[90528, 2386, 470, 8, 70, "Input",
  InitializationCell->True],
Cell[91001, 2396, 127, 4, 70, "Text"],
Cell[91131, 2402, 476, 8, 70, "Input",
  InitializationCell->True],
Cell[91610, 2412, 128, 4, 70, "Text"],
Cell[91741, 2418, 478, 8, 70, "Input",
  InitializationCell->True],
Cell[92222, 2428, 107, 3, 70, "Text"],
Cell[92332, 2433, 588, 12, 70, "Input",
  InitializationCell->True],
Cell[92923, 2447, 108, 3, 70, "Text"],
Cell[93034, 2452, 591, 12, 70, "Input",
  InitializationCell->True],
Cell[93628, 2466, 109, 3, 70, "Text"],
Cell[93740, 2471, 594, 12, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[94371, 2488, 48, 0, 43, "NumberedSubsubtitle"],
Cell[94422, 2490, 142, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[94589, 2497, 103, 3, 70, "NumberedSubsubsubtitle"],
Cell[94695, 2502, 289, 5, 70, "Input",
  InitializationCell->True],
Cell[94987, 2509, 119, 2, 70, "Input",
  InitializationCell->True],
Cell[95109, 2513, 609, 11, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[95755, 2529, 108, 3, 70, "NumberedSubsubsubtitle"],
Cell[95866, 2534, 669, 12, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[96572, 2551, 108, 3, 70, "NumberedSubsubsubtitle"],
Cell[96683, 2556, 98, 3, 70, "Text"],
Cell[96784, 2561, 544, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[97389, 2579, 45, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[97459, 2583, 105, 3, 70, "NumberedSubsubtitle"],
Cell[97567, 2588, 359, 12, 70, "Text"],
Cell[97929, 2602, 134, 3, 70, "Input",
  InitializationCell->True],
Cell[98066, 2607, 361, 6, 70, "Input",
  InitializationCell->True],
Cell[98430, 2615, 359, 6, 70, "Input",
  InitializationCell->True],
Cell[98792, 2623, 228, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[99057, 2633, 54, 0, 70, "NumberedSubsubtitle"],
Cell[99114, 2635, 154, 3, 70, "Text"],
Cell[99271, 2640, 1037, 16, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[100333, 2660, 121, 4, 70, "NumberedSubsubsubtitle"],
Cell[100457, 2666, 104, 3, 70, "Text"],
Cell[100564, 2671, 579, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[101192, 2689, 46, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[101263, 2693, 75, 0, 70, "NumberedSubsubsubtitle"],
Cell[101341, 2695, 415, 13, 70, "Text"],
Cell[101759, 2710, 2005, 30, 70, "Input",
  InitializationCell->True],
Cell[103767, 2742, 156, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[103960, 2750, 113, 4, 70, "NumberedSubsubsubtitle"],
Cell[104076, 2756, 96, 3, 70, "Text"],
Cell[104175, 2761, 538, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[104762, 2778, 53, 0, 70, "NumberedSubsubtitle"],
Cell[104818, 2780, 236, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[105079, 2790, 70, 0, 70, "NumberedSubsubsubtitle"],
Cell[105152, 2792, 598, 9, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[105787, 2806, 82, 3, 70, "NumberedSubsubsubtitle"],
Cell[105872, 2811, 665, 11, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[106574, 2827, 150, 6, 70, "NumberedSubsubsubtitle"],
Cell[106727, 2835, 91, 3, 70, "Text"],
Cell[106821, 2840, 523, 11, 70, "Input",
  InitializationCell->True],
Cell[107347, 2853, 90, 3, 70, "Text"],
Cell[107440, 2858, 520, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[108009, 2875, 48, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[108082, 2879, 77, 0, 70, "NumberedSubsubsubtitle"],
Cell[108162, 2881, 233, 9, 70, "Text"],
Cell[108398, 2892, 2037, 36, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[110472, 2933, 115, 4, 70, "NumberedSubsubsubtitle"],
Cell[110590, 2939, 98, 3, 70, "Text"],
Cell[110691, 2944, 544, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[111284, 2961, 38, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[111347, 2965, 67, 0, 70, "NumberedSubsubsubtitle"],
Cell[111417, 2967, 260, 7, 70, "Text"],
Cell[111680, 2976, 466, 7, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[112183, 2988, 105, 4, 70, "NumberedSubsubsubtitle"],
Cell[112291, 2994, 105, 4, 70, "Text"],
Cell[112399, 3000, 421, 8, 70, "Input",
  InitializationCell->True],
Cell[112823, 3010, 84, 3, 70, "Text"],
Cell[112910, 3015, 733, 14, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[113692, 3035, 63, 0, 70, "NumberedSubsubtitle"],
Cell[113758, 3037, 284, 8, 70, "Text"],
Cell[114045, 3047, 623, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[114717, 3064, 70, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[114812, 3068, 60, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[114897, 3072, 91, 1, 70, "NumberedSubsubsubtitle"],
Cell[114991, 3075, 366, 6, 70, "Text"],
Cell[115360, 3083, 3296, 47, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[118693, 3135, 127, 4, 70, "NumberedSubsubsubtitle"],
Cell[118823, 3141, 140, 4, 70, "Text"],
Cell[118966, 3147, 626, 11, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[119641, 3164, 48, 0, 70, "NumberedSubsubtitle"],
Cell[119692, 3166, 177, 6, 70, "Text"],
Cell[119872, 3174, 107, 2, 70, "Input",
  InitializationCell->True],
Cell[119982, 3178, 1121, 19, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[121140, 3202, 82, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[121247, 3207, 85, 1, 70, "NumberedSubsubsubtitle"],
Cell[121335, 3210, 326, 9, 70, "Text"],
Cell[121664, 3221, 159, 3, 70, "Input",
  InitializationCell->True],
Cell[121826, 3226, 2795, 45, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[124658, 3276, 83, 1, 70, "NumberedSubsubsubtitle"],
Cell[124744, 3279, 376, 9, 70, "Text"],
Cell[125123, 3290, 2789, 45, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[127961, 3341, 92, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[128078, 3346, 90, 1, 70, "NumberedSubsubsubtitle"],
Cell[128171, 3349, 319, 8, 70, "Text"],
Cell[128493, 3359, 2831, 45, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[131361, 3409, 88, 1, 70, "NumberedSubsubsubtitle"],
Cell[131452, 3412, 369, 8, 70, "Text"],
Cell[131824, 3422, 2770, 43, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[134643, 3471, 73, 0, 70, "NumberedSubsubtitle"],
Cell[134719, 3473, 102, 3, 70, "Text"],
Cell[134824, 3478, 851, 16, 70, "Input",
  InitializationCell->True],
Cell[135678, 3496, 119, 4, 70, "Text"],
Cell[135800, 3502, 453, 8, 70, "Input",
  InitializationCell->True],
Cell[136256, 3512, 121, 4, 70, "Text"],
Cell[136380, 3518, 464, 8, 70, "Input",
  InitializationCell->True],
Cell[136847, 3528, 121, 4, 70, "Text"],
Cell[136971, 3534, 467, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[137475, 3547, 71, 0, 70, "NumberedSubsubtitle"],
Cell[137549, 3549, 100, 3, 70, "Text"],
Cell[137652, 3554, 841, 16, 70, "Input",
  InitializationCell->True],
Cell[138496, 3572, 117, 4, 70, "Text"],
Cell[138616, 3578, 449, 8, 70, "Input",
  InitializationCell->True],
Cell[139068, 3588, 119, 4, 70, "Text"],
Cell[139190, 3594, 460, 8, 70, "Input",
  InitializationCell->True],
Cell[139653, 3604, 119, 4, 70, "Text"],
Cell[139775, 3610, 463, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[140275, 3623, 78, 0, 70, "NumberedSubsubtitle"],
Cell[140356, 3625, 103, 3, 70, "Text"],
Cell[140462, 3630, 878, 17, 70, "Input",
  InitializationCell->True],
Cell[141343, 3649, 124, 4, 70, "Text"],
Cell[141470, 3655, 463, 8, 70, "Input",
  InitializationCell->True],
Cell[141936, 3665, 126, 4, 70, "Text"],
Cell[142065, 3671, 474, 8, 70, "Input",
  InitializationCell->True],
Cell[142542, 3681, 126, 4, 70, "Text"],
Cell[142671, 3687, 477, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[143185, 3700, 76, 0, 70, "NumberedSubsubtitle"],
Cell[143264, 3702, 105, 3, 70, "Text"],
Cell[143372, 3707, 866, 16, 70, "Input",
  InitializationCell->True],
Cell[144241, 3725, 122, 4, 70, "Text"],
Cell[144366, 3731, 459, 8, 70, "Input",
  InitializationCell->True],
Cell[144828, 3741, 124, 4, 70, "Text"],
Cell[144955, 3747, 470, 8, 70, "Input",
  InitializationCell->True],
Cell[145428, 3757, 124, 4, 70, "Text"],
Cell[145555, 3763, 473, 8, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[146077, 3777, 51, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[146153, 3781, 61, 0, 70, "NumberedSubsubtitle"],
Cell[146217, 3783, 429, 8, 70, "Input",
  InitializationCell->True],
Cell[146649, 3793, 434, 7, 70, "Input",
  InitializationCell->True],
Cell[147086, 3802, 824, 13, 70, "Input",
  InitializationCell->True],
Cell[147913, 3817, 1388, 22, 70, "Input",
  InitializationCell->True],
Cell[149304, 3841, 4949, 73, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[154290, 3919, 65, 0, 70, "NumberedSubsubtitle"],
Cell[154358, 3921, 2594, 38, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[157001, 3965, 52, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[157078, 3969, 58, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[157161, 3973, 99, 4, 70, "NumberedSubsubsubtitle"],
Cell[157263, 3979, 254, 7, 70, "Text"],
Cell[157520, 3988, 372, 6, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[157941, 4000, 106, 1, 70, "NumberedSubsubtitle"],
Cell[158050, 4003, 131, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[158206, 4010, 101, 4, 70, "NumberedSubsubsubtitle"],
Cell[158310, 4016, 549, 10, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[158896, 4031, 135, 4, 70, "NumberedSubsubsubtitle"],
Cell[159034, 4037, 978, 15, 70, "Input",
  InitializationCell->True],
Cell[160015, 4054, 397, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[160449, 4065, 127, 4, 70, "NumberedSubsubsubtitle"],
Cell[160579, 4071, 992, 15, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[161608, 4091, 116, 4, 70, "NumberedSubsubsubtitle"],
Cell[161727, 4097, 103, 4, 70, "Text"],
Cell[161833, 4103, 1081, 17, 70, "Input",
  InitializationCell->True],
Cell[162917, 4122, 215, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[163169, 4131, 106, 4, 70, "NumberedSubsubsubtitle"],
Cell[163278, 4137, 123, 4, 70, "Text"],
Cell[163404, 4143, 1003, 18, 70, "Input",
  InitializationCell->True]
}, Closed]],
Cell[164422, 4164, 76, 0, 70, "NumberedSubsubsubtitle"]
}, Closed]],

Cell[CellGroupData[{
Cell[164535, 4169, 74, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[164634, 4173, 52, 0, 70, "NumberedSubsubsubtitle"],
Cell[164689, 4175, 67, 0, 70, "Text"],
Cell[164759, 4177, 1554, 26, 70, "Input",
  InitializationCell->True],
Cell[166316, 4205, 211, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[166564, 4214, 99, 4, 70, "NumberedSubsubsubtitle"],
Cell[166666, 4220, 142, 4, 70, "Text"],
Cell[166811, 4226, 872, 13, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[167720, 4244, 47, 0, 70, "NumberedSubsubsubtitle"],
Cell[167770, 4246, 98, 3, 70, "Text"],
Cell[167871, 4251, 707, 13, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[168627, 4270, 75, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[168727, 4274, 75, 0, 70, "NumberedSubsubsubtitle"],
Cell[168805, 4276, 126, 3, 70, "Text"],
Cell[168934, 4281, 3386, 52, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[172357, 4338, 84, 1, 70, "NumberedSubsubsubtitle"],
Cell[172444, 4341, 153, 4, 70, "Text"],
Cell[172600, 4347, 669, 11, 70, "Input",
  InitializationCell->True],
Cell[173272, 4360, 583, 9, 70, "Input",
  InitializationCell->True],
Cell[173858, 4371, 840, 14, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[174747, 4391, 72, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[174844, 4395, 91, 1, 70, "NumberedSubsubsubtitle"],
Cell[174938, 4398, 223, 7, 70, "Text"],
Cell[175164, 4407, 2852, 42, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[178053, 4454, 98, 1, 70, "NumberedSubsubsubtitle"],
Cell[178154, 4457, 173, 4, 70, "Text"],
Cell[178330, 4463, 2667, 39, 70, "Input",
  InitializationCell->True],
Cell[181000, 4504, 1689, 26, 70, "Input",
  InitializationCell->True],
Cell[182692, 4532, 2355, 37, 70, "Input",
  InitializationCell->True],
Cell[185050, 4571, 283, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[185370, 4581, 115, 4, 70, "NumberedSubsubsubtitle"],
Cell[185488, 4587, 223, 8, 70, "Text"],
Cell[185714, 4597, 1914, 29, 70, "Input",
  InitializationCell->True],
Cell[187631, 4628, 105, 2, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[187785, 4636, 65, 0, 70, "NumberedSubsubtitle"],
Cell[187853, 4638, 129, 4, 70, "Text"],
Cell[187985, 4644, 487, 8, 70, "Input",
  InitializationCell->True],
Cell[188475, 4654, 326, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[188850, 4665, 56, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[188931, 4669, 62, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[189018, 4673, 99, 4, 70, "NumberedSubsubsubtitle"],
Cell[189120, 4679, 254, 7, 70, "Text"],
Cell[189377, 4688, 364, 6, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[189790, 4700, 84, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[189899, 4705, 105, 4, 70, "NumberedSubsubsubtitle"],
Cell[190007, 4711, 742, 13, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[190786, 4729, 139, 4, 70, "NumberedSubsubsubtitle"],
Cell[190928, 4735, 1025, 15, 70, "Input",
  InitializationCell->True],
Cell[191956, 4752, 409, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[192402, 4763, 131, 4, 70, "NumberedSubsubsubtitle"],
Cell[192536, 4769, 1135, 17, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[193708, 4791, 116, 4, 70, "NumberedSubsubsubtitle"],
Cell[193827, 4797, 103, 4, 70, "Text"],
Cell[193933, 4803, 1277, 21, 70, "Input",
  InitializationCell->True],
Cell[195213, 4826, 218, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[195468, 4835, 106, 4, 70, "NumberedSubsubsubtitle"],
Cell[195577, 4841, 154, 6, 70, "Text"],
Cell[195734, 4849, 1265, 21, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[197036, 4875, 136, 4, 70, "NumberedSubsubsubtitle"],
Cell[197175, 4881, 1652, 28, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[198864, 4914, 146, 5, 70, "NumberedSubsubsubtitle"],
Cell[199013, 4921, 174, 6, 70, "Text"],
Cell[199190, 4929, 935, 13, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[200162, 4947, 150, 4, 70, "NumberedSubsubsubtitle"],
Cell[200315, 4953, 786, 14, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[201150, 4973, 173, 5, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[201348, 4982, 79, 0, 70, "NumberedSubsubsubtitle"],
Cell[201430, 4984, 208, 7, 70, "Text"],
Cell[201641, 4993, 1624, 25, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[203302, 5023, 88, 1, 70, "NumberedSubsubsubtitle"],
Cell[203393, 5026, 183, 5, 70, "Text"],
Cell[203579, 5033, 2714, 39, 70, "Input",
  InitializationCell->True],
Cell[206296, 5074, 1506, 22, 70, "Input",
  InitializationCell->True],
Cell[207805, 5098, 3042, 45, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[210884, 5148, 74, 0, 70, "NumberedSubsubsubtitle"],
Cell[210961, 5150, 127, 3, 70, "Text"],
Cell[211091, 5155, 166, 4, 70, "Text"],
Cell[211260, 5161, 134, 3, 70, "Input",
  InitializationCell->True],
Cell[211397, 5166, 919, 14, 70, "Input",
  InitializationCell->True],
Cell[212319, 5182, 1797, 31, 70, "Input",
  InitializationCell->True],
Cell[214119, 5215, 300, 5, 70, "Input",
  InitializationCell->True],
Cell[214422, 5222, 1341, 24, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[215824, 5253, 79, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[215928, 5257, 128, 3, 63, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[216081, 5264, 139, 4, 48, "NumberedSubsubsubtitle"],
Cell[216223, 5270, 875, 14, 70, "Input",
  InitializationCell->True],
Cell[217101, 5286, 411, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[217549, 5297, 132, 4, 28, "NumberedSubsubsubtitle"],
Cell[217684, 5303, 1086, 16, 59, "Input",
  InitializationCell->True],
Cell[218773, 5321, 172, 3, 27, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[218982, 5329, 140, 4, 48, "NumberedSubsubsubtitle"],
Cell[219125, 5335, 1149, 16, 70, "Input",
  InitializationCell->True],
Cell[220277, 5353, 152, 3, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[220478, 5362, 107, 3, 69, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[220610, 5369, 74, 0, 70, "NumberedSubsubsubtitle"],
Cell[220687, 5371, 159, 4, 70, "Text"],
Cell[220849, 5377, 216, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[221102, 5386, 146, 4, 70, "NumberedSubsubsubtitle"],
Cell[221251, 5392, 1101, 16, 70, "Input",
  InitializationCell->True],
Cell[222355, 5410, 172, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[222564, 5418, 154, 4, 70, "NumberedSubsubsubtitle"],
Cell[222721, 5424, 866, 14, 70, "Input",
  InitializationCell->True],
Cell[223590, 5440, 428, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[224055, 5451, 141, 4, 70, "NumberedSubsubsubtitle"],
Cell[224199, 5457, 954, 14, 70, "Input",
  InitializationCell->True],
Cell[225156, 5473, 153, 3, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[225358, 5482, 117, 3, 43, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[225500, 5489, 155, 4, 70, "NumberedSubsubsubtitle"],
Cell[225658, 5495, 550, 9, 70, "Input",
  InitializationCell->True],
Cell[226211, 5506, 210, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[226458, 5515, 150, 4, 70, "NumberedSubsubsubtitle"],
Cell[226611, 5521, 1165, 20, 70, "Input",
  InitializationCell->True],
Cell[227779, 5543, 459, 7, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[228275, 5555, 174, 4, 70, "NumberedSubsubsubtitle"],
Cell[228452, 5561, 1023, 16, 70, "Input",
  InitializationCell->True],
Cell[229478, 5579, 177, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[229692, 5587, 141, 4, 70, "NumberedSubsubsubtitle"],
Cell[229836, 5593, 972, 15, 70, "Input",
  InitializationCell->True],
Cell[230811, 5610, 153, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[231001, 5618, 115, 3, 70, "NumberedSubsubsubtitle"],
Cell[231119, 5623, 656, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[231824, 5641, 166, 5, 43, "NumberedSubsubtitle"],
Cell[231993, 5648, 231, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[232249, 5658, 88, 1, 70, "NumberedSubsubsubtitle"],
Cell[232340, 5661, 164, 4, 70, "Text"],
Cell[232507, 5667, 1615, 25, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[234159, 5697, 85, 1, 70, "NumberedSubsubsubtitle"],
Cell[234247, 5700, 1500, 24, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[235784, 5729, 82, 1, 70, "NumberedSubsubsubtitle"],
Cell[235869, 5732, 1706, 26, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[237624, 5764, 89, 1, 43, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[237738, 5769, 145, 4, 70, "NumberedSubsubsubtitle"],
Cell[237886, 5775, 1129, 16, 70, "Input",
  InitializationCell->True],
Cell[239018, 5793, 157, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[239212, 5801, 121, 3, 70, "NumberedSubsubsubtitle"],
Cell[239336, 5806, 368, 7, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[239753, 5819, 171, 5, 43, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[239949, 5828, 168, 4, 70, "NumberedSubsubsubtitle"],
Cell[240120, 5834, 436, 8, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[240617, 5849, 50, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[240692, 5853, 57, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[240774, 5857, 99, 4, 70, "NumberedSubsubsubtitle"],
Cell[240876, 5863, 254, 7, 70, "Text"],
Cell[241133, 5872, 294, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[241476, 5883, 77, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[241578, 5887, 100, 4, 70, "NumberedSubsubsubtitle"],
Cell[241681, 5893, 416, 9, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[242134, 5907, 114, 1, 70, "NumberedSubsubsubtitle"],
Cell[242251, 5910, 707, 11, 70, "Input",
  InitializationCell->True],
Cell[242961, 5923, 304, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[243302, 5933, 174, 4, 70, "NumberedSubsubsubtitle"],
Cell[243479, 5939, 192, 4, 70, "Input",
  InitializationCell->True],
Cell[243674, 5945, 656, 10, 70, "Input",
  InitializationCell->True],
Cell[244333, 5957, 1311, 19, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[245681, 5981, 134, 4, 70, "NumberedSubsubsubtitle"],
Cell[245818, 5987, 1287, 19, 70, "Input",
  InitializationCell->True],
Cell[247108, 6008, 424, 7, 70, "Input",
  InitializationCell->True],
Cell[247535, 6017, 1277, 20, 70, "Input",
  InitializationCell->True],
Cell[248815, 6039, 424, 7, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[249276, 6051, 126, 4, 70, "NumberedSubsubsubtitle"],
Cell[249405, 6057, 905, 14, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[250347, 6076, 121, 4, 70, "NumberedSubsubsubtitle"],
Cell[250471, 6082, 1032, 17, 70, "Input",
  InitializationCell->True],
Cell[251506, 6101, 230, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[251773, 6110, 160, 4, 70, "NumberedSubsubsubtitle"],
Cell[251936, 6116, 1151, 18, 70, "Input",
  InitializationCell->True],
Cell[253090, 6136, 178, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],
Cell[253283, 6142, 76, 0, 70, "NumberedSubsubsubtitle"]
}, Closed]],

Cell[CellGroupData[{
Cell[253396, 6147, 71, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[253492, 6151, 107, 3, 70, "NumberedSubsubsubtitle"],
Cell[253602, 6156, 1683, 25, 70, "Input",
  Evaluatable->False],
Cell[255288, 6183, 297, 5, 70, "Input",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[255622, 6193, 107, 3, 70, "NumberedSubsubsubtitle"],
Cell[255732, 6198, 1683, 25, 70, "Input",
  Evaluatable->False],
Cell[257418, 6225, 297, 5, 70, "Input",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[257752, 6235, 84, 1, 70, "NumberedSubsubsubtitle"],
Cell[257839, 6238, 103, 4, 70, "Text"],
Cell[257945, 6244, 2975, 43, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[260969, 6293, 73, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[261067, 6297, 105, 3, 70, "NumberedSubsubsubtitle"],
Cell[261175, 6302, 133, 3, 70, "Text"],
Cell[261311, 6307, 400, 7, 70, "Input",
  InitializationCell->True],
Cell[261714, 6316, 1246, 18, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[262997, 6339, 78, 0, 70, "NumberedSubsubsubtitle"],
Cell[263078, 6341, 98, 3, 70, "Text"],
Cell[263179, 6346, 3200, 51, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[266428, 6403, 70, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[266523, 6407, 73, 0, 70, "NumberedSubsubsubtitle"],
Cell[266599, 6409, 1335, 19, 70, "Input",
  InitializationCell->True],
Cell[267937, 6430, 283, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[268257, 6440, 72, 0, 70, "NumberedSubsubsubtitle"],
Cell[268332, 6442, 1336, 19, 70, "Input",
  InitializationCell->True],
Cell[269671, 6463, 283, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[269991, 6473, 79, 0, 70, "NumberedSubsubsubtitle"],
Cell[270073, 6475, 100, 4, 70, "Text"],
Cell[270176, 6481, 348, 6, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[270573, 6493, 104, 3, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[270702, 6500, 121, 3, 70, "NumberedSubsubsubtitle"],
Cell[270826, 6505, 2468, 35, 70, "Input",
  InitializationCell->True],
Cell[273297, 6542, 285, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[273619, 6552, 121, 3, 70, "NumberedSubsubsubtitle"],
Cell[273743, 6557, 2467, 35, 70, "Input",
  InitializationCell->True],
Cell[276213, 6594, 268, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[276530, 6605, 86, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[276641, 6610, 125, 3, 70, "NumberedSubsubsubtitle"],
Cell[276769, 6615, 2512, 37, 70, "Input",
  InitializationCell->True],
Cell[279284, 6654, 269, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[279590, 6664, 126, 3, 70, "NumberedSubsubsubtitle"],
Cell[279719, 6669, 2500, 37, 70, "Input",
  InitializationCell->True],
Cell[282222, 6708, 269, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[282540, 6719, 89, 1, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[282654, 6724, 115, 3, 70, "NumberedSubsubsubtitle"],
Cell[282772, 6729, 2270, 35, 70, "Input",
  InitializationCell->True],
Cell[285045, 6766, 239, 4, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[285321, 6775, 115, 3, 70, "NumberedSubsubsubtitle"],
Cell[285439, 6780, 2238, 34, 70, "Input",
  InitializationCell->True],
Cell[287680, 6816, 239, 4, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[287968, 6826, 54, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[288047, 6830, 63, 0, 70, "NumberedSubsubsubtitle"],
Cell[288113, 6832, 102, 3, 70, "Text"],
Cell[288218, 6837, 1242, 17, 70, "Input",
  InitializationCell->True],
Cell[289463, 6856, 1714, 25, 70, "Input",
  InitializationCell->True],
Cell[291180, 6883, 1335, 20, 70, "Input",
  InitializationCell->True],
Cell[292518, 6905, 1336, 20, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[293903, 6931, 67, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[293995, 6935, 111, 3, 70, "NumberedSubsubsubtitle"],
Cell[294109, 6940, 495, 11, 70, "Input",
  InitializationCell->True],
Cell[294607, 6953, 340, 6, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[294984, 6964, 120, 3, 70, "NumberedSubsubsubtitle"],
Cell[295107, 6969, 508, 11, 70, "Input",
  InitializationCell->True],
Cell[295618, 6982, 393, 7, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[296048, 6994, 113, 3, 70, "NumberedSubsubsubtitle"],
Cell[296164, 6999, 308, 7, 70, "Text"],
Cell[296475, 7008, 393, 7, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[296929, 7022, 55, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[297009, 7026, 75, 0, 70, "NumberedSubsubtitle"],
Cell[297087, 7028, 2787, 41, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[299911, 7074, 72, 0, 70, "NumberedSubsubtitle"],
Cell[299986, 7076, 1689, 26, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[301700, 7106, 113, 4, 70, "NumberedSubsubsubtitle"],
Cell[301816, 7112, 167, 5, 70, "Text"],
Cell[301986, 7119, 1829, 36, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[303852, 7160, 89, 1, 70, "NumberedSubsubsubtitle"],
Cell[303944, 7163, 185, 4, 70, "Text"],
Cell[304132, 7169, 5110, 81, 70, "Input",
  InitializationCell->True],
Cell[309245, 7252, 309, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[309603, 7263, 75, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[309703, 7267, 106, 1, 70, "NumberedSubsubsubtitle"],
Cell[309812, 7270, 381, 6, 70, "Text"],
Cell[310196, 7278, 3602, 53, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[313835, 7336, 138, 3, 70, "NumberedSubsubsubtitle"],
Cell[313976, 7341, 121, 3, 70, "Text"],
Cell[314100, 7346, 669, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[314818, 7364, 72, 0, 70, "NumberedSubsubtitle"],
Cell[314893, 7366, 368, 7, 70, "JasonComment"],
Cell[315264, 7375, 13110, 199, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[328399, 7578, 135, 4, 70, "NumberedSubsubsubtitle"],
Cell[328537, 7584, 663, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[329249, 7602, 73, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[329347, 7606, 112, 4, 70, "NumberedSubsubsubtitle"],
Cell[329462, 7612, 163, 5, 70, "Text"],
Cell[329628, 7619, 2402, 36, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[332067, 7660, 63, 0, 70, "NumberedSubsubsubtitle"],
Cell[332133, 7662, 92, 3, 70, "Text"],
Cell[332228, 7667, 2051, 34, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[334340, 7708, 55, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[334420, 7712, 75, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[334520, 7716, 131, 1, 70, "NumberedSubsubsubtitle"],
Cell[334654, 7719, 490, 9, 70, "Text"],
Cell[335147, 7730, 1024, 16, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[336208, 7751, 164, 4, 70, "NumberedSubsubsubtitle"],
Cell[336375, 7757, 118, 3, 70, "Text"],
Cell[336496, 7762, 669, 12, 70, "Input",
  InitializationCell->True],
Cell[337168, 7776, 479, 9, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[337696, 7791, 72, 0, 70, "NumberedSubsubtitle"],
Cell[337771, 7793, 2075, 32, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[339883, 7830, 75, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[339983, 7834, 106, 1, 70, "NumberedSubsubsubtitle"],
Cell[340092, 7837, 381, 6, 70, "Text"],
Cell[340476, 7845, 539, 8, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[341052, 7858, 164, 4, 70, "NumberedSubsubsubtitle"],
Cell[341219, 7864, 118, 3, 70, "Text"],
Cell[341340, 7869, 669, 12, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[342058, 7887, 72, 0, 70, "NumberedSubsubtitle"],
Cell[342133, 7889, 2480, 38, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[344650, 7932, 73, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[344748, 7936, 117, 4, 70, "NumberedSubsubsubtitle"],
Cell[344868, 7942, 170, 5, 70, "Text"],
Cell[345041, 7949, 3059, 44, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[348137, 7998, 63, 0, 70, "NumberedSubsubsubtitle"],
Cell[348203, 8000, 92, 3, 70, "Text"],
Cell[348298, 8005, 674, 11, 70, "Input",
  InitializationCell->True],
Cell[348975, 8018, 586, 9, 70, "Input",
  InitializationCell->True],
Cell[349564, 8029, 824, 14, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[350449, 8050, 66, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[350540, 8054, 45, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[350610, 8058, 79, 0, 70, "NumberedSubsubsubtitle"],
Cell[350692, 8060, 289, 7, 70, "Text"],
Cell[350984, 8069, 2281, 36, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[353302, 8110, 112, 4, 70, "NumberedSubsubsubtitle"],
Cell[353417, 8116, 90, 3, 70, "Text"],
Cell[353510, 8121, 548, 10, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[354107, 8137, 51, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[354183, 8141, 87, 1, 70, "NumberedSubsubsubtitle"],
Cell[354273, 8144, 400, 14, 70, "Text"],
Cell[354676, 8160, 141, 3, 70, "Input",
  InitializationCell->True],
Cell[354820, 8165, 4059, 63, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[358916, 8233, 114, 3, 70, "NumberedSubsubsubtitle"],
Cell[359033, 8238, 118, 4, 70, "Text"],
Cell[359154, 8244, 435, 7, 70, "Input",
  InitializationCell->True],
Cell[359592, 8253, 108, 3, 70, "Text"],
Cell[359703, 8258, 366, 7, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[360118, 8271, 50, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[360193, 8275, 113, 3, 70, "NumberedSubsubsubtitle"],
Cell[360309, 8280, 117, 4, 70, "Text"],
Cell[360429, 8286, 413, 7, 70, "Input",
  InitializationCell->True],
Cell[360845, 8295, 152, 5, 70, "Text"],
Cell[361000, 8302, 455, 8, 70, "Input",
  InitializationCell->True],
Cell[361458, 8312, 146, 5, 70, "Text"],
Cell[361607, 8319, 440, 8, 70, "Input",
  InitializationCell->True],
Cell[362050, 8329, 110, 3, 70, "Text"],
Cell[362163, 8334, 665, 12, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[362865, 8351, 79, 0, 70, "NumberedSubsubsubtitle"],
Cell[362947, 8353, 565, 11, 70, "Text"],
Cell[363515, 8366, 751, 11, 70, "Input",
  InitializationCell->True],
Cell[364269, 8379, 230, 4, 70, "Input",
  InitializationCell->True],
Cell[364502, 8385, 510, 10, 70, "Input",
  InitializationCell->True],
Cell[365015, 8397, 1845, 31, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[366897, 8433, 73, 0, 70, "NumberedSubsubsubtitle"],
Cell[366973, 8435, 791, 19, 70, "Text"],
Cell[367767, 8456, 469, 9, 70, "Input",
  InitializationCell->True],
Cell[368239, 8467, 2514, 44, 70, "Input",
  InitializationCell->True],
Cell[370756, 8513, 279, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[371084, 8524, 56, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[371165, 8528, 116, 3, 70, "NumberedSubsubsubtitle"],
Cell[371284, 8533, 134, 4, 70, "Text"],
Cell[371421, 8539, 1080, 16, 70, "Input",
  InitializationCell->True],
Cell[372504, 8557, 164, 3, 70, "Input",
  InitializationCell->True],
Cell[372671, 8562, 110, 3, 70, "Text"],
Cell[372784, 8567, 808, 19, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[373629, 8591, 90, 1, 70, "NumberedSubsubsubtitle"],
Cell[373722, 8594, 182, 4, 70, "Text"],
Cell[373907, 8600, 155, 3, 70, "Input",
  InitializationCell->True],
Cell[374065, 8605, 1585, 26, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[375687, 8636, 78, 0, 70, "NumberedSubsubsubtitle"],
Cell[375768, 8638, 285, 5, 70, "Text"],
Cell[376056, 8645, 954, 16, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[377071, 8668, 43, 0, 50, "NumberedSubtitle"],

Cell[CellGroupData[{
Cell[377139, 8672, 64, 0, 70, "NumberedSubsubtitle"],
Cell[377206, 8674, 74, 0, 70, "Text"],
Cell[377283, 8676, 152, 3, 70, "Input",
  InitializationCell->True],
Cell[377438, 8681, 162, 3, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[377637, 8689, 48, 0, 70, "NumberedSubsubtitle"],
Cell[377688, 8691, 218, 6, 70, "Text"],
Cell[377909, 8699, 654, 12, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[378600, 8716, 66, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[378691, 8720, 86, 1, 70, "NumberedSubsubsubtitle"],
Cell[378780, 8723, 95, 3, 70, "Text"],
Cell[378878, 8728, 1710, 29, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[380625, 8762, 71, 0, 70, "NumberedSubsubsubtitle"],
Cell[380699, 8764, 276, 8, 70, "Text"],
Cell[380978, 8774, 305, 5, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[381332, 8785, 46, 0, 70, "NumberedSubsubtitle"],

Cell[CellGroupData[{
Cell[381403, 8789, 45, 0, 70, "NumberedSubsubsubtitle"],
Cell[381451, 8791, 71, 2, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[381559, 8798, 60, 0, 70, "NumberedSubsubsubtitle"],
Cell[381622, 8800, 334, 5, 70, "Input",
  InitializationCell->True],
Cell[381959, 8807, 294, 5, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[382290, 8817, 49, 0, 70, "NumberedSubsubsubtitle"],
Cell[382342, 8819, 78, 2, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

