(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)



(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37028,       1028]*)
(*NotebookOutlinePosition[     43124,       1239]*)
(*  CellTagsIndexPosition[     43080,       1235]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[
    ButtonBox[
      StyleBox[
        \(Minimal\[NonBreakingSpace]Notation\[NonBreakingSpace]Palette\),
        FontFamily->"Helvetica",
        FontColor->GrayLevel[1]],
      ButtonFunction:>(FrontEndExecute[ {
          FrontEnd`NotebookClose[ 
            FrontEnd`ButtonNotebook[ ]], 
          FrontEnd`NotebookOpen[ 
            FrontEnd`ToFileName[ 
            {$TopDirectory, "AddOns", "ExtraPackages", "Utilities", "Palettes", "English",
              "NotationPalette.nb"}]]}]&),
      ButtonStyle->None,
      Background->RGBColor[0.100008, 0.100008, 0.4],
      ButtonNote->"Switch to minimal NotationPalette"]], "Input",
  CellMargins->{{Inherited, Inherited}, {0, Inherited}},
  Active->True],

Cell[CellGroupData[{

Cell["Notations", "Section",
  CellMargins->{{Inherited, Inherited}, {Inherited, 6}}],

Cell[CellGroupData[{

Cell["StandardForm Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonData:>RowBox[ {"Notation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", 
                  "\[DoubleLongLeftRightArrow]", " ", 
                  TagBox[ 
                  "\[Placeholder]", NotationBoxTag, TagStyle -> 
                    "NotationTemplateStyle"]}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            
            ButtonNote->
              "\[EscapeKey]notation\[EscapeKey]. Notation template that \
parses and formats."]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonData:>RowBox[ {"Notation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", "\[DoubleLongRightArrow]", 
                  " ", 
                  TagBox[ 
                  "\[Placeholder]", NotationBoxTag, TagStyle -> 
                    "NotationTemplateStyle"]}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            
            ButtonNote->
              "\[EscapeKey]notation>\[EscapeKey]. Notation template that \
parses."]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonData:>RowBox[ {"Notation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", "\[DoubleLongLeftArrow]", 
                  " ", 
                  TagBox[ 
                  "\[Placeholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle]}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            
            ButtonNote->
              "\[EscapeKey]notation<\[EscapeKey]. Notation template that \
formats."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["StandardForm", "MR"],
  " notations (the default)",
  StyleBox[".", "MR"],
  "See the function ",
  Cell[BoxData[
      ButtonBox["Notation",
        ButtonData:>{"Notation:Definition:Notation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["TraditionalForm Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            FormBox[
              RowBox[{"Notation", "[", 
                RowBox[{
                  RowBox[{
                    TagBox["\[SelectionPlaceholder]",
                      NotationBoxTag,
                      TagStyle->"NotationTemplateStyle"], " ", 
                    "\[DoubleLongLeftRightArrow]", " ", 
                    TagBox["\[Placeholder]",
                      NotationBoxTag,
                      TagStyle->"NotationTemplateStyle"]}], ",", "\n", 
                  "\t    ", \(WorkingForm\  \[Rule] \ TraditionalForm\)}], 
                "]"}],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"Notation", "[", 
                  RowBox[ {
                    RowBox[ {
                      TagBox[ 
                      "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                        NotationTemplateStyle], " ", 
                      "\[DoubleLongLeftRightArrow]", " ", 
                      TagBox[ 
                      "\[Placeholder]", NotationBoxTag, TagStyle -> 
                        NotationTemplateStyle]}], ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            
            ButtonNote->
              "TraditionalForm notation template that parses and formats."]},
        {
          ButtonBox[
            FormBox[
              RowBox[{"Notation", "[", 
                RowBox[{
                  RowBox[{
                    TagBox["\[SelectionPlaceholder]",
                      NotationBoxTag,
                      TagStyle->"NotationTemplateStyle"], " ", 
                    "\[DoubleLongRightArrow]", " ", 
                    TagBox["\[Placeholder]",
                      NotationBoxTag,
                      TagStyle->"NotationTemplateStyle"]}], ",", "\n", 
                  "\t    ", \(WorkingForm\  \[Rule] \ TraditionalForm\)}], 
                "]"}],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"Notation", "[", 
                  RowBox[ {
                    RowBox[ {
                      TagBox[ 
                      "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                        NotationTemplateStyle], " ", 
                      "\[DoubleLongRightArrow]", " ", 
                      TagBox[ 
                      "\[Placeholder]", NotationBoxTag, TagStyle -> 
                        NotationTemplateStyle]}], ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"TraditionalForm notation template that parses."]},
        {
          ButtonBox[
            FormBox[
              RowBox[{"Notation", "[", 
                RowBox[{
                  RowBox[{
                    TagBox["\[SelectionPlaceholder]",
                      NotationBoxTag,
                      TagStyle->"NotationTemplateStyle"], " ", 
                    "\[DoubleLongLeftArrow]", " ", 
                    TagBox["\[Placeholder]",
                      NotationBoxTag,
                      TagStyle->"NotationTemplateStyle"]}], ",", " ", "\n", 
                  "\t    ", \(WorkingForm\  \[Rule] \ TraditionalForm\)}], 
                "]"}],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"Notation", "[", 
                  RowBox[ {
                    RowBox[ {
                      TagBox[ 
                      "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                        NotationTemplateStyle], " ", 
                      "\[DoubleLongLeftArrow]", " ", 
                      TagBox[ 
                      "\[Placeholder]", NotationBoxTag, TagStyle -> 
                        NotationTemplateStyle]}], ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"TraditionalForm notation template that formats."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["TraditionalForm", "MR"],
  " notations. See the function ",
  Cell[BoxData[
      ButtonBox["Notation",
        ButtonData:>{"Notation:Definition:Notation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  " and the option ",
  Cell[BoxData[
      ButtonBox["WorkingForm",
        ButtonData:>{"Notation:Definition:WorkingForm"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Other Form\" Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], " ", 
                  "\[DoubleLongLeftRightArrow]", " ", 
                  TagBox["\[Placeholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"]}], ",", "\n", 
                "\t    ", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}]
              ,
            ButtonData:>RowBox[ {"Notation", "[", 
                RowBox[ {
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], " ", 
                    "\[DoubleLongLeftRightArrow]", " ", 
                    TagBox[ 
                    "\[Placeholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle]}], ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "\[Placeholder]"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            
            ButtonNote->
              "Other-Form notation template that parses and formats."]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], " ", 
                  "\[DoubleLongRightArrow]", " ", 
                  TagBox["\[Placeholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"]}], ",", "\n", 
                "\t    ", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}]
              ,
            ButtonData:>RowBox[ {"Notation", "[", 
                RowBox[ {
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], " ", "\[DoubleLongRightArrow]", 
                    " ", 
                    TagBox[ 
                    "\[Placeholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle]}], ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "\[Placeholder]"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Other-Form notation template that parses."]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], " ", 
                  "\[DoubleLongLeftArrow]", " ", 
                  TagBox["\[Placeholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"]}], ",", "\n", 
                "\t    ", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}]
              ,
            ButtonData:>RowBox[ {"Notation", "[", 
                RowBox[ {
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], " ", "\[DoubleLongLeftArrow]", 
                    " ", 
                    TagBox[ 
                    "\[Placeholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle]}], ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "\[Placeholder]"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Other-Form notation template that formats."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["\"Other Form\"", "MRs"],
  " notations like ",
  StyleBox["LogicForm", "MR"],
  " or ",
  StyleBox["PhysicsForm", "MR"],
  ", etc. See the function ",
  Cell[BoxData[
      ButtonBox["Notation",
        ButtonData:>{"Notation:Definition:Notation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  " and the option ",
  Cell[BoxData[
      ButtonBox["WorkingForm",
        ButtonData:>{"Notation:Definition:WorkingForm"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Remove Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"RemoveNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonData:>RowBox[ {"RemoveNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", 
                  "\[DoubleLongLeftRightArrow]", " ", 
                  TagBox[ 
                  "\[Placeholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle]}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Remove parsing and formatting notation."]},
        {
          ButtonBox[
            RowBox[{"RemoveNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonData:>RowBox[ {"RemoveNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", "\[DoubleLongRightArrow]", 
                  " ", 
                  TagBox[ 
                  "\[Placeholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle]}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Remove parsing notation."]},
        {
          ButtonBox[
            RowBox[{"RemoveNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonData:>RowBox[ {"RemoveNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", "\[DoubleLongLeftArrow]", 
                  " ", 
                  TagBox[ 
                  "\[Placeholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle]}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Remove formatting notation."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates remove ",
  StyleBox["StandardForm", "MR"],
  " notations (the default)",
  StyleBox[".", "MR"],
  "See the function ",
  Cell[BoxData[
      ButtonBox["Notation",
        ButtonData:>{"Notation:Definition:Notation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolizations", "Section"],

Cell[CellGroupData[{

Cell["StandardForm Symbolize", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Symbolize", "[", 
              TagBox["\[SelectionPlaceholder]",
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], " ", "]"}],
            ButtonData:>RowBox[ {"Symbolize", "[", 
                TagBox[ 
                "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                  NotationTemplateStyle], " ", "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Symbolize a pattern."]},
        {
          ButtonBox[
            RowBox[{"RemoveSymbolize", "[", 
              TagBox["\[SelectionPlaceholder]",
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], " ", "]"}],
            ButtonData:>RowBox[ {"RemoveSymbolize", "[", 
                TagBox[ 
                "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                  NotationTemplateStyle], " ", "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Remove a symbolization."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["StandardForm", "MR"],
  " symbolizations (the default)",
  StyleBox[".", "MR"],
  "See the function ",
  Cell[BoxData[
      ButtonBox["Symbolize",
        ButtonData:>{"Notation:Definition:Symbolize"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["TraditionalForm Symbolize", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            FormBox[
              RowBox[{"Symbolize", "[", 
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], " ", ",", "\n", 
                  "\t   ", \(WorkingForm\  \[Rule] \ TraditionalForm\)}], "]"}
                ],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"Symbolize", "[", 
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], " ", ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"TraditionalForm symbolization template."]},
        {
          ButtonBox[
            FormBox[
              RowBox[{"RemoveSymbolize", "[", 
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], " ", ",", "\n", 
                  "\t   ", \(WorkingForm\  \[Rule] \ TraditionalForm\)}], "]"}
                ],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"RemoveSymbolize", "[", 
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], " ", ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Remove a TraditionalForm symbolization template."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["TraditionalForm", "MR"],
  " symbolizations. See the function ",
  Cell[BoxData[
      ButtonBox["Symbolize",
        ButtonData:>{"Notation:Definition:Symbolize"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  " and the option ",
  Cell[BoxData[
      ButtonBox["WorkingForm",
        ButtonData:>{"Notation:Definition:WorkingForm"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Other Form\" Symbolize", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Symbolize", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", ",", "\n", 
                "\t   ", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}],
            ButtonData:>RowBox[ {"Symbolize", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "\[Placeholder]"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Other-Form symbolization template."]},
        {
          ButtonBox[
            RowBox[{"RemoveSymbolize", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", ",", "\n", 
                "\t    ", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}]
              ,
            ButtonData:>RowBox[ {"RemoveSymbolize", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], " ", ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "\[Placeholder]"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Remove a Other-Form symbolization template."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["\"Other Form\"", "MRs"],
  " symbolizations like ",
  StyleBox["LogicForm", "MR"],
  " or ",
  StyleBox["PhysicsForm", "MR"],
  ", etc.See the function ",
  Cell[BoxData[
      ButtonBox["Symbolize",
        ButtonData:>{"Notation:Definition:Symbolize"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  " and the option ",
  Cell[BoxData[
      ButtonBox["WorkingForm",
        ButtonData:>{"Notation:Definition:WorkingForm"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Infix Notations", "Section",
  Active->False],

Cell[CellGroupData[{

Cell["StandardForm Infix Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"InfixNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}]
                , "]"}],
            ButtonData:>RowBox[ {"InfixNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], ",", "\[Placeholder]"}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"InfixNotation template."]},
        {
          ButtonBox[
            RowBox[{"RemoveInfixNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}]
                , "]"}],
            ButtonData:>RowBox[ {"RemoveInfixNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], ",", "\[Placeholder]"}], "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"RemoveInfixNotation template."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["StandardForm", "MR"],
  " infix notations (the default)",
  StyleBox[".", "MR"],
  "See the documentation for the function ",
  Cell[BoxData[
      ButtonBox["InfixNotation",
        ButtonData:>{"Notation:Definition:InfixNotation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["TraditionalForm Infix Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            FormBox[
              RowBox[{"InfixNotation", "[", 
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], ",", 
                  "\[Placeholder]", ",", "\n", "\t   ", 
                  \(WorkingForm\  \[Rule] \ TraditionalForm\)}], "]"}],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"InfixNotation", "[", 
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], ",", "\[Placeholder]", ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"TraditionalForm InfixNotation template."]},
        {
          ButtonBox[
            FormBox[
              RowBox[{"RemoveInfixNotation", "[", 
                RowBox[{
                  TagBox["\[SelectionPlaceholder]",
                    NotationBoxTag,
                    TagStyle->"NotationTemplateStyle"], ",", 
                  "\[Placeholder]", ",", "\n", "\t   ", 
                  \(WorkingForm\  \[Rule] \ TraditionalForm\)}], "]"}],
              "TraditionalForm"],
            ButtonData:>FormBox[ 
                RowBox[ {"RemoveInfixNotation", "[", 
                  RowBox[ {
                    TagBox[ 
                    "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                      NotationTemplateStyle], ",", "\[Placeholder]", ",", 
                    RowBox[ 
                    {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}]
                  , "]"}], "TraditionalForm"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"TraditionalForm RemoveInfixNotation template."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["TraditionalForm", "MR"],
  " infix notations",
  StyleBox[".", "MR"],
  "See the function ",
  Cell[BoxData[
      ButtonBox["InfixNotation",
        ButtonData:>{"Notation:Definition:InfixNotation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  " and the option ",
  Cell[BoxData[
      ButtonBox["WorkingForm",
        ButtonData:>{"Notation:Definition:WorkingForm"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Other Form\" Infix Notations", "Subsection"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"InfixNotation", "[", "\n", "\t", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]", 
                ",", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}],
            ButtonData:>RowBox[ {"InfixNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], ",", "\[Placeholder]", ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Other-Form InfixNotation template."]},
        {
          ButtonBox[
            RowBox[{"RemoveInfixNotation", "[", "\n", "\t", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]", 
                ",", \(WorkingForm\  \[Rule] \ \[Placeholder]\)}], "]"}],
            ButtonData:>RowBox[ {"RemoveInfixNotation", "[", 
                RowBox[ {
                  TagBox[ 
                  "\[SelectionPlaceholder]", NotationBoxTag, TagStyle -> 
                    NotationTemplateStyle], ",", "\[Placeholder]", ",", 
                  RowBox[ 
                  {"WorkingForm", " ", "\[Rule]", " ", "TraditionalForm"}]}], 
                "]"}],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            ButtonNote->"Other-Form RemoveInfixNotation template."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\\[Placeholder]", ButtonData :> "\\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These templates define ",
  StyleBox["\"Other Form\"", "MRs"],
  " infix notations like ",
  StyleBox["LogicForm", "MR"],
  " or ",
  StyleBox["PhysicsForm", "MR"],
  ", etc",
  StyleBox[".", "MR"],
  "See the documentation for the function ",
  Cell[BoxData[
      ButtonBox["InfixNotation",
        ButtonData:>{"Notation:Definition:InfixNotation"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  " and the option ",
  Cell[BoxData[
      ButtonBox["WorkingForm",
        ButtonData:>{"Notation:Definition:WorkingForm"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Wrapper Boxes", "Section"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["InsertPatternWrapper",
              FontFamily->"Helvetica",
              FontColor->GrayLevel[1]],
            
            ButtonData:>TagBox[ 
              "\[SelectionPlaceholder]", NotationPatternTag, TagStyle -> 
                "NotationPatternWrapperStyle"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            Background->RGBColor[0.100008, 0.100008, 0.4],
            
            ButtonNote->
              "\[EscapeKey]pattwrap\[EscapeKey]. Insert a complex pattern \
wrapper TagBox."]},
        {
          ButtonBox[
            StyleBox["InsertMadeBoxesWrapper",
              FontFamily->"Helvetica",
              FontColor->GrayLevel[1]],
            
            ButtonData:>TagBox[ 
              "\[SelectionPlaceholder]", NotationMadeBoxesTag, TagStyle -> 
                "NotationMadeBoxesWrapperStyle"],
            ButtonStyle->"Paste",
            ButtonSource->ButtonData,
            Background->RGBColor[0.100008, 0.100008, 0.4],
            
            ButtonNote->
              "\[EscapeKey]madeboxeswrap\[EscapeKey]. Insert a made boxes \
wrapper TagBox."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ 
        "\[Placeholder]", ButtonData :> "\[Placeholder]", ButtonSource :> 
          ButtonData]]], "Input",
  Active->True],

Cell[TextData[{
  "These are functions that embed tag boxes into expressions. See ",
  Cell[BoxData[
      ButtonBox[\(Complex\ Patterns\),
        ButtonData:>{"Notation:Definition:NotationPatternTag"},
        ButtonStyle->"DemosLink",
        ButtonSource->ButtonData]]],
  "."
}], "Text"]
}, Closed]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
Editable->False,
Background->GrayLevel[1],
WindowSize->{289, 322},
WindowMargins->{{Automatic, 104}, {Automatic, 160}},
WindowFrame->"Palette",
WindowElements->{"StatusArea", "VerticalScrollBar"},
WindowFrameElements->{"CloseBox", "ResizeArea"},
WindowClickSelect->False,
ShowCellBracket->False,
StyleDefinitions -> Notebook[{
  Cell["\<\
          Prototypes for the FullNotation Palette. This abbreviated style \
sheet is used to reduce the size of the notebook as a whole while still \
allowing the styles to be easily modifed. Remember that all other styles will \
be adopted from the default style sheet.          \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->None,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{19, Inherited}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 20}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 20}},
    FontSize->14],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->None,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{25, Inherited}, {Inherited, 8}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontFamily->"Times",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{24, Inherited}, {Inherited, 15}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{14, Inherited}, {Inherited, 15}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DemosLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["DemosLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{10, Inherited}, {0, Inherited}},
    FontFamily->"Times"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, Inherited}, {10, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{14, Inherited}, {0, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{4, Inherited}, {0, 2}},
    FontSize->10]
  }, Closed]],
  
  Cell[StyleData["MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{5, Inherited}, {Inherited, Inherited}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->Utilities`Notation`Private`DefaultInputFormatType,
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{45, Inherited}, {20, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{30, Inherited}, {10, Inherited}},
    FontSize->10],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{4, Inherited}, {2, 2}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notation Package Styles", "Section",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell["\<\
The cells below define certain styles needed by the Notation package. These \
styles serve to make visible otherwise invisible tagboxes.\
\>", "Text",
    GeneratedCell->True,
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationTemplateStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 1, 0.850004],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationPatternWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.900008, 0.979995],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"],
  
  Cell[StyleData["NotationMadeBoxesWrapperStyle"],
    GeneratedCell->True,
    StyleMenuListing->None,
    Background->RGBColor[0.900008, 0.889998, 1],
    TagBoxOptions->{SyntaxForm->"symbol"},
    CellTags->"NotationPackage"]
  }, Closed]]
  }]
]





(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

