(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)



(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5495,        149]*)
(*NotebookOutlinePosition[      7442,        219]*)
(*  CellTagsIndexPosition[      7398,        215]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]notation\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongRightArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]notation>\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Notation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], " ", 
                "\[DoubleLongLeftArrow]", " ", 
                TagBox["\[Placeholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"]}], "]"}],
            ButtonNote->"\[EscapeKey]notation<\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"Symbolize", "[", 
              TagBox["\[SelectionPlaceholder]",
                NotationBoxTag,
                TagStyle->"NotationTemplateStyle"], "]"}],
            ButtonNote->"\[EscapeKey]symb\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"InfixNotation", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}]
                , "]"}],
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]infixnotation\[EscapeKey]"]},
        {
          ButtonBox[
            RowBox[{"AddInputAlias", "[", 
              RowBox[{
                TagBox["\[SelectionPlaceholder]",
                  NotationBoxTag,
                  TagStyle->"NotationTemplateStyle"], ",", "\[Placeholder]"}]
                , "]"}],
            ButtonStyle->"Paste",
            ButtonNote->"\[EscapeKey]addia\[EscapeKey]"]},
        {
          ButtonBox[
            StyleBox[\(Full\ Notation\ Palette\),
              FontFamily->"Helvetica",
              FontColor->GrayLevel[1]],
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`NotebookClose[ 
                  FrontEnd`ButtonNotebook[ ]], 
                FrontEnd`NotebookOpen[ 
                  FrontEnd`ToFileName[ 
                  {$TopDirectory, "AddOns", "ExtraPackages", "Utilities", "Palettes", "English",
                    "FullNotationPalette.nb"}]]}]&),
            ButtonStyle->None,
            Background->RGBColor[0.100008, 0.100008, 0.4],
            ButtonNote->"Switch to FullNotationPalette"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\[Placeholder]"]]], NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 1024}, {0, 748}},
ClosingAutoSave->False,
WindowToolbars->{},
PageWidth->363,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 104}, {Automatic, 2}},
WindowFrame->"Palette",
WindowElements->"StatusArea",
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->"Notation Palette",
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell[CellGroupData[{
  
  Cell["Notation Package Styles", "Section",
    GeneratedCell->True,
    CellTags->"NotationPackage35"],
  
  Cell["\<\
The cells below define certain styles needed by the Notation \
package. These styles serve to make visible otherwise invisible \
tagboxes.\
\>", "Text",
    GeneratedCell->True,
    CellTags->"NotationPackage35"],
  
  Cell[StyleData["NotationTemplateStyle"],
    StyleMenuListing->None,
    Background->RGBColor[1, 1, 0.850004],
    CellTags->"NotationPackage35"]
  }, Closed]]
  }, Open  ]]
  }]
]


(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

