(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    202839,       7436]*)
(*NotebookOutlinePosition[    337129,      11271]*)
(*  CellTagsIndexPosition[    322234,      10705]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.13 ", "HeadingNumber"],
  StyleBox["MathLink", "SBO"],
  " and External Program Communication"
}], "Section",
  CellTags->{"S2.13.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.1 How ",
  StyleBox["MathLink", "SBO"],
  " Is Used"
}], "Subsection",
  CellTags->{"S2.13.1", "1.1"}],

Cell[TextData[{
  "Most of this book has been concerned with how human users interact with ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox["MathLink", "TI"],
  " provides a mechanism through which ",
  StyleBox["programs", "TI"],
  " rather than human users can interact with ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->{"S2.13.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Calling functions in an external program \
from within ",
              StyleBox["Mathematica", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Calling ",
              StyleBox["Mathematica", "TI"],
              " from within an external program. "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Setting up alternative front ends to ",
              StyleBox["Mathematica", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Exchanging data between ",
              StyleBox["Mathematica", "TI"],
              " and external programs. "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Exchanging data between concurrent ",
              StyleBox["Mathematica", "TI"],
              " processes. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "Some typical uses of ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " provides a general interface for external programs to communicate with ",
  StyleBox["Mathematica", "TI"],
  ". Many standard software systems now have ",
  StyleBox["MathLink", "TI"],
  " compatibility either built in or available in add\[Hyphen]on modules. "
}], "Text",
  CellTags->{"S2.13.1", "1.3"}],

Cell[TextData[{
  "In addition, the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit bundled with most versions of ",
  StyleBox["Mathematica", "TI"],
  " provides the tools you need to create your own ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs. "
}], "Text",
  CellTags->{"S2.13.1", "1.4"}],

Cell[TextData[{
  "Once you have a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program, you can transparently establish a link \
between it and ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.1", "1.5"}],

Cell["\<\
The link can either be on a single computer, or it can be over a \
network, potentially with a different type of computer at each end. \
\>", \
"Text",
  CellTags->{"S2.13.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Implementing inner loops in a low\
\[Hyphen]level language. \
\>"]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Handling large volumes of data external \
to ",
              StyleBox["Mathematica", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Sending ",
              StyleBox["Mathematica", "TI"],
              " graphics or other data for special processing. "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Connecting to a system with an \
existing user interface. \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "A few uses of ",
  StyleBox["MathLink", "SO"],
  "\[Hyphen]compatible programs. "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs range from very simple to very complex. A \
minimal ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program is just a few lines long. But it is also \
possible to build very large and sophisticated ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs. Indeed, the ",
  StyleBox["Mathematica", "TI"],
  " notebook front end is one example of a sophisticated ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program. "
}], "Text",
  CellTags->{"S2.13.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["MathLink", "TI"],
              " is a mechanism for exchanging ",
              StyleBox["Mathematica", "TI"],
              " expressions between programs. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "The basic idea of ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  "Much of the power of ",
  StyleBox["MathLink", "TI"],
  " comes from its use of ",
  StyleBox["Mathematica", "TI"],
  " expressions. The basic idea is that ",
  StyleBox["MathLink", "TI"],
  " provides a way to exchange ",
  StyleBox["Mathematica", "TI"],
  " expressions between programs, and such expressions can represent \
absolutely any kind of data. "
}], "Text",
  CellTags->{"S2.13.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["\[FilledSmallSquare] An array of numbers. "]},
          {
            Cell["\<\
\[FilledSmallSquare] A collection of geometrical \
objects. \
\>"]},
          {Cell["\[FilledSmallSquare] A sequence of commands. "]},
          {Cell["\[FilledSmallSquare] A stream of text. "]},
          {Cell["\[FilledSmallSquare] Records in a database. "]},
          {Cell[TextData[{
              "\[FilledSmallSquare] The cells of a ",
              StyleBox["Mathematica", "TI"],
              " notebook. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.1"],

Cell[TextData[{
  "A few examples of data represented by ",
  StyleBox["Mathematica", "SO"],
  " expressions in ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.1"],

Cell[TextData[{
  "The ",
  StyleBox["MathLink", "TI"],
  " library consists of a collection of routines that allow external programs \
to send and receive ",
  StyleBox["Mathematica", "TI"],
  " expressions.  "
}], "Text",
  CellTags->{"S2.13.1", "1.9"}],

Cell[TextData[{
  "The ",
  StyleBox["MathLink", "TI"],
  " Developer Kit provides utilities for incorporating these routines into \
external programs. Utilities are included for a variety of languages, \
although in this chapter we discuss mainly the case of C. "
}], "Text",
  CellTags->{"S2.13.1", "1.10"}],

Cell[TextData[{
  "An important feature of the ",
  StyleBox["MathLink", "TI"],
  " library is that it is completely platform independent: it can \
transparently use any interprogram communication mechanism that exists on \
your computer system. "
}], "Text",
  CellTags->{"S2.13.1", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.2 Installing Existing ",
  StyleBox["MathLink", "SBO"],
  "\[Hyphen]Compatible Programs"
}], "Subsection",
  CellTags->{"S2.13.2", "2.1"}],

Cell[TextData[{
  "One of the most common uses of ",
  StyleBox["MathLink", "TI"],
  " is to allow you to call functions in an external program from within ",
  StyleBox["Mathematica", "TI"],
  ". Once the external program has been set up, all you need do to be able to \
use it is to \[OpenCurlyDoubleQuote]install\[CloseCurlyDoubleQuote] it in \
your current ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.13.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "install a ",
              StyleBox["MathLink", "TI"],
              "\[Hyphen]compatible external program "
            }]]},
          {Cell[TextData[{
              StyleBox["Uninstall[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["uninstall the program "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.2"],

Cell[TextData[{
  "Setting up external programs with functions to be called from within ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.2"],

Cell[TextData[{
  "This installs a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible external program called ",
  StyleBox["bitprog", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.2", "2.3"}],

Cell[CellGroupData[{

Cell["Install[\"bitprog\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.2"],

Cell[BoxData[
    \(LinkObject["./bitprog", 4, 3]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.13.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BitShift", "MR"],
  " is one of the functions inside ",
  StyleBox["bitprog", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.2", "2.4"}],

Cell[CellGroupData[{

Cell["BitShift[111, 3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.2"],

Cell[BoxData[
    \(13\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.13.2"]
}, Open  ]],

Cell[TextData[{
  "You can use it just as you would a function within ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.2", "2.5"}],

Cell[CellGroupData[{

Cell["Table[BitShift[111, i], {i, 30, 35}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.2"],

Cell[BoxData[
    \({0, 0, 111, 55, 27, 13}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.2"]
}, Open  ]],

Cell[TextData[{
  "When you have a package written in the ",
  StyleBox["Mathematica", "TI"],
  " language a single version will run unchanged on any computer system. But \
external programs typically need to be compiled separately for every \
different type of computer. "
}], "Text",
  CellTags->{"S2.13.2", "2.6"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " has a convention of keeping versions of external programs in directories \
that are named after the types of computers on which they will run. And \
assuming that this convention has been followed, ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " should always install the version of ",
  StyleBox["prog", "TI"],
  " appropriate for the particular kind of computer that you are currently \
using. "
}], "Text",
  CellTags->{"S2.13.2", "2.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"name`\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "install a program found anywhere on ",
              StyleBox["$Path", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.2"],

Cell["Using context names to specify programs to install. ", "Caption",
  CellTags->"S2.13.2"],

Cell[TextData[{
  "When you ask to read in a ",
  StyleBox["Mathematica", "TI"],
  " language file using ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will automatically search all directories in the list ",
  StyleBox["$Path", "MR"],
  " in order to find a file with the appropriate name. Similarly, if you use \
",
  StyleBox["Install[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`\"]", "MR"],
  " ",
  StyleBox["Mathematica", "TI"],
  " will automatically search all directories in ",
  StyleBox["$Path", "MR"],
  " in order to find an external program with the name ",
  StyleBox["name", "TI"],
  StyleBox[".exe", "MR"],
  ". ",
  StyleBox["Install[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`\"]", "MR"],
  " allows you to install programs that are stored in a central directory \
without explicitly having to specify their location.    "
}], "Text",
  CellTags->{"S2.13.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.3 Setting Up External Functions to Be Called from ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S2.13.3", "3.1"}],

Cell[TextData[{
  "If you have a function defined in an external program, then what you need \
to do in order to make it possible to call the function from within ",
  StyleBox["Mathematica", "TI"],
  " is to add appropriate ",
  StyleBox["MathLink", "TI"],
  " code that passes arguments to the function, and takes back the results it \
produces. "
}], "Text",
  CellTags->{"S2.13.3", "3.2"}],

Cell[TextData[{
  "In simple cases, you can generate the necessary code just by giving an \
appropriate ",
  StyleBox["MathLink", "TI"],
  " ",
  StyleBox["template", "TI"],
  " for each external function.   "
}], "Text",
  CellTags->{"S2.13.3", "3.3"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.4"}],

Cell["\<\
:Begin:
:Function:      f
:Pattern:       f[x_Integer, y_Integer]
:Arguments:     {x, y}
:ArgumentTypes: {Integer, Integer}
:ReturnType:    Integer
:End:\
\>", "Program",
  CellTags->{"S2.13.3", "3.5"}],

Cell[TextData[StyleBox[" ", "MR"]], "ProgramBottom",
  CellTags->{"S2.13.3", "3.6"}],

Cell[TextData[{
  "A file ",
  StyleBox["f.tm", "MR"],
  " containing a ",
  StyleBox["MathLink", "SO"],
  " template for an external function ",
  StyleBox["f", "MR"],
  "."
}], "Caption",
  CellTags->"S2.13.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox[":Begin:", "MR"],
              " "
            }]], Cell["begin the template for a particular function "]},
          {Cell[TextData[{
              StyleBox[":Function:", "MR"],
              " "
            }]], Cell["the name of the function in the external program "]},
          {Cell[TextData[{
              StyleBox[":Pattern:", "MR"],
              " "
            }]], Cell["the pattern to be defined to call the function "]},
          {Cell[TextData[{
              StyleBox[":Arguments:", "MR"],
              " "
            }]], Cell["the arguments to the function "]},
          {Cell[TextData[{
              StyleBox[":ArgumentTypes:", "MR"],
              " "
            }]], Cell["the types of the arguments to the function "]},
          {Cell[TextData[{
              StyleBox[":ReturnType:", "MR"],
              " "
            }]], Cell["the type of the value returned by the function "]},
          {Cell[TextData[{
              StyleBox[":End:", "MR"],
              " "
            }]], Cell["end the template for a particular function "]},
          {Cell[TextData[{
              StyleBox[":Evaluate:", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " input to evaluate when the function is installed "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, False, False, True}},
  CellTags->"S2.13.3"],

Cell[TextData[{
  "The elements of a ",
  StyleBox["MathLink", "SO"],
  " template. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Once you have constructed a ",
  StyleBox["MathLink", "TI"],
  " template for a particular external function, you have to combine this \
template with the actual source code for the function. Assuming that the \
source code is written in the C programming language, you can do this just by \
adding a line to include the standard ",
  StyleBox["MathLink", "TI"],
  " header file, and then inserting a small ",
  StyleBox["main", "MR"],
  " program. "
}], "Text",
  CellTags->{"S2.13.3", "3.7"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.8"}],

Cell[TextData[{
  "Include the standard ",
  StyleBox["MathLink", "TI"],
  " header file. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.9"}],

Cell["\<\
#include \"mathlink.h\"
\
\>", "Program",
  CellTags->{"S2.13.3", "3.10"}],

Cell[TextData[{
  "Here is the actual source code for the function ",
  StyleBox["f", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.11"}],

Cell[TextData[{
  "int f(int x, int y) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return x+y;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.12"}],

Cell[TextData[{
  "This sets up the external program to be ready to take requests from ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.13"}],

Cell[TextData[{
  "int main(int argc, char *argv[]) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return MLMain(argc, argv);\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.14"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.15"}],

Cell[TextData[{
  "A file ",
  StyleBox["f.c", "MR"],
  " containing C source code. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Note that the form of ",
  StyleBox["main", "MR"],
  " required on different systems may be slightly different. The release \
notes included in the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit on your particular computer system should give the \
appropriate form. "
}], "Text",
  CellTags->{"S2.13.3", "3.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["mcc", "MR"],
              " "
            }]], Cell[TextData[{
              "preprocess and compile ",
              StyleBox["MathLink", "TI"],
              " source files "
            }]]},
          {Cell[TextData[{
              StyleBox["mprep", "MR"],
              " "
            }]], Cell[TextData[{
              "preprocess ",
              StyleBox["MathLink", "TI"],
              " source files "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Typical external programs for processing ",
  StyleBox["MathLink", "SO"],
  " source files. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " templates are conventionally put in files with names of the form ",
  StyleBox["file", "TI"],
  StyleBox[".tm", "MR"],
  ". Such files can also contain C source code, interspersed between \
templates for different functions. "
}], "Text",
  CellTags->{"S2.13.3", "3.17"}],

Cell[TextData[{
  "Once you have set up the appropriate files, you then need to process the \
",
  StyleBox["MathLink", "TI"],
  " template information, and compile all of your source code. Typically you \
do this by running various external programs, but the details will depend on \
your computer system. "
}], "Text",
  CellTags->{"S2.13.3", "3.18"}],

Cell[TextData[{
  "Under Unix, for example, the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit includes a program named ",
  StyleBox["mcc", "MR"],
  " which will preprocess ",
  StyleBox["MathLink", "TI"],
  " templates in any file whose name ends with ",
  StyleBox[".tm", "MR"],
  ", and then call ",
  StyleBox["cc", "MR"],
  " on the resulting C source code. ",
  StyleBox["mcc", "MR"],
  " will pass command\[Hyphen]line options and other files directly to ",
  StyleBox["cc", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.3", "3.19"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.20"}],

Cell[TextData[{
  "This preprocesses ",
  StyleBox["f.tm", "MR"],
  ", then compiles the resulting C source file together with the file ",
  StyleBox["f.c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.21"}],

Cell["mcc -o f.exe f.tm f.c", "Program",
  CellTags->{"S2.13.3", "3.22"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.23"}],

Cell[TextData[{
  "This installs the binary in the current ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.24"}],

Cell[CellGroupData[{

Cell["Install[\"f.exe\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(LinkObject["f.exe", 4, 4]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["f[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " calls the external function ",
  StyleBox["f(int", "MR"],
  " ",
  StyleBox["x,", "MR"],
  " ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["y)", "MR"],
  " and adds two integers together. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.25"}],

Cell[CellGroupData[{

Cell["f[6, 9]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(15\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell["\<\
The external program handles only machine integers, so this gives a \
peculiar result. \
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.26"}],

Cell[CellGroupData[{

Cell["f[2^31-1, 5]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(\(-2147483644\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "On systems other than Unix, the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit typically includes a program named ",
  StyleBox["mprep", "MR"],
  ", which you have to call directly, giving as input all of the ",
  StyleBox[".tm", "MR"],
  " files that you want to preprocess. ",
  StyleBox["mprep", "MR"],
  " will generate C source code as output, which you can then feed to a C \
compiler. "
}], "Text",
  CellTags->{"S2.13.3", "3.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["install an external program "]},
          {Cell[TextData[{
              StyleBox["Uninstall[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["uninstall an external program "]},
          {Cell[TextData[{
              StyleBox["Links[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "show active links associated with ",
              StyleBox["\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Links[ ]", "MR"],
              " "
            }]], Cell["show all active links "]},
          {Cell[TextData[{
              StyleBox["LinkPatterns[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "show patterns that can be evaluated on a particular link "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.3"],

Cell["Handling links to external programs. ", "Caption",
  CellTags->"S2.13.3"],

Cell[TextData[{
  "This finds the link to the ",
  StyleBox["f.exe", "MR"],
  " program. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.28"}],

Cell[CellGroupData[{

Cell["Links[\"f.exe\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \({LinkObject["./f.exe", 6, 4]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "This shows the ",
  StyleBox["Mathematica", "TI"],
  " patterns that can be evaluated using the link. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.29"}],

Cell[CellGroupData[{

Cell["LinkPatterns[%[[1]]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    RowBox[{"{", 
      TagBox[\(f[x_Integer, y_Integer]\),
        HoldForm], "}"}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Install", "MR"],
  " sets up the actual function ",
  StyleBox["f", "MR"],
  " to execute an appropriate ",
  StyleBox["ExternalCall", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.30"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S2.13.3"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[x_Integer, y_Integer] := 
                    ExternalCall[LinkObject["./f.exe", 6, 4], 
                      CallPacket[0, {x, y}]]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "When a ",
  StyleBox["MathLink", "TI"],
  " template file is processed, two basic things are done. First, the ",
  StyleBox[":Pattern:", "MR"],
  " and ",
  StyleBox[":Arguments:", "MR"],
  " specifications are used to generate a ",
  StyleBox["Mathematica", "TI"],
  " definition that calls an external function via ",
  StyleBox["MathLink", "TI"],
  ". And second, the ",
  StyleBox[":Function:", "MR"],
  ", ",
  StyleBox[":ArgumentTypes:", "MR"],
  " and ",
  StyleBox[":ReturnType:", "MR"],
  " specifications are used to generate C source code that calls your \
function within the external program. "
}], "Text",
  CellTags->{"S2.13.3", "3.31"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.32"}],

Cell[":Begin:", "Program",
  CellTags->{"S2.13.3", "3.33"}],

Cell["\<\
This gives the name of the actual C function to call in the \
external program.\
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.34"}],

Cell[":Function:      prog_add", "Program",
  CellTags->{"S2.13.3", "3.35"}],

Cell[TextData[{
  "This gives the ",
  StyleBox["Mathematica", "TI"],
  " pattern for which a definition should be set up."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.36"}],

Cell[":Pattern:       SkewAdd[x_Integer, y_Integer:1]", "Program",
  CellTags->{"S2.13.3", "3.37"}],

Cell["\<\
The values of the two list elements are the actual arguments to be \
passed to the external function. \
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.38"}],

Cell[TextData[{
  ":Arguments:     ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "x, If[x > 1, y, y + x - 2]",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.39"}],

Cell["\<\
This specifies that the arguments should be passed as integers to \
the C function.\
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.40"}],

Cell[TextData[{
  ":ArgumentTypes: ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer, Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.41"}],

Cell["\<\
This specifies that the return value from the C function will be an \
integer.\
\>", "MathCaption",
  CellTags->{"S2.13.3", "3.42"}],

Cell[":ReturnType:    Integer", "Program",
  CellTags->{"S2.13.3", "3.43"}],

Cell[":End:", "Program",
  CellTags->{"S2.13.3", "3.44"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.45"}],

Cell[TextData[{
  "Both the ",
  StyleBox[":Pattern:", "MR"],
  " and ",
  StyleBox[":Arguments:", "MR"],
  " specifications in a ",
  StyleBox["MathLink", "TI"],
  " template can be any ",
  StyleBox["Mathematica", "TI"],
  " expressions. Whatever you give as the ",
  StyleBox[":Arguments:", "MR"],
  " specification will be evaluated every time you call the external \
function. The result of the evaluation will be used as the list of arguments \
to pass to the function. "
}], "Text",
  CellTags->{"S2.13.3", "3.46"}],

Cell[TextData[{
  "Sometimes you may want to set up ",
  StyleBox["Mathematica", "TI"],
  " expressions that should be evaluated not when an external function is \
called, but instead only when the external function is first installed. "
}], "Text",
  CellTags->{"S2.13.3", "3.47"}],

Cell[TextData[{
  "You can do this by inserting ",
  StyleBox[":Evaluate:", "MR"],
  " specifications in your ",
  StyleBox["MathLink", "TI"],
  " template. The expression you give after ",
  StyleBox[":Evaluate:", "MR"],
  " can go on for several lines: it is assumed to end when there is first a \
blank line, or a line that does not begin with spaces or tabs. "
}], "Text",
  CellTags->{"S2.13.3", "3.48"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.49"}],

Cell[TextData[{
  "This specifies that a usage message for ",
  StyleBox["SkewAdd", "MR"],
  " should be set up when the external program is installed."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.50"}],

Cell["\<\
:Evaluate:    SkewAdd::usage = \"SkewAdd[x, y] performs
       a skew addition in an external program.\"\
\>", "Program",
  CellTags->{"S2.13.3", "3.51"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.52"}],

Cell[TextData[{
  "When an external program is installed, the specifications in its ",
  StyleBox["MathLink", "TI"],
  " template file are used in the order they were given. This means that any \
expressions given in ",
  StyleBox[":Evaluate:", "MR"],
  " specifications that appear before ",
  StyleBox[":Begin:", "MR"],
  " will have been evaluated before definitions for the external function are \
set up. "
}], "Text",
  CellTags->{"S2.13.3", "3.53"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.54"}],

Cell[TextData[{
  "Here are ",
  StyleBox["Mathematica", "TI"],
  " expressions to be evaluated before the definitions for external functions \
are set up."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.55"}],

Cell["\<\
:Evaluate:  BeginPackage[\"XPack`\"]
:Evaluate:  XF1::usage = \"XF1[x, y] is one external function.\"
:Evaluate:  XF2::usage = \"XF2[x] is another external function.\"
:Evaluate:  Begin[\"`Private`\"]
\
\>", "Program",
  CellTags->{"S2.13.3", "3.56"}],

Cell[TextData[{
  "This specifies that the function ",
  StyleBox["XF1", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " should be set up to call the function ",
  StyleBox["f", "MR"],
  " in the external C program."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.57"}],

Cell[TextData[{
  ":Begin:\n:Function:       f\n:Pattern:        XF1[x_Integer, y_Integer]\n\
:Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "x, y",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer, Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Integer\n:End:\n"
}], "Program",
  CellTags->{"S2.13.3", "3.58"}],

Cell[TextData[{
  "This specifies that ",
  StyleBox["XF2", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " should call ",
  StyleBox["g", "MR"],
  ". Its argument and return value are taken to be approximate real numbers. \
"
}], "MathCaption",
  CellTags->{"S2.13.3", "3.59"}],

Cell[TextData[{
  ":Begin:\n:Function:       g\n:Pattern:        XF2[x_?NumberQ]\n:Arguments: \
     ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "x",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Real",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Real\n:End:\n"
}], "Program",
  CellTags->{"S2.13.3", "3.60"}],

Cell[TextData[{
  "These ",
  StyleBox["Mathematica", "TI"],
  " expressions are evaluated after the definitions for the external \
functions. They end the special context used for the definitions."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.61"}],

Cell["\<\
:Evaluate:  End[ ]
:Evaluate:  EndPackage[ ]\
\>", "Program",
  CellTags->{"S2.13.3", "3.62"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.63"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.64"}],

Cell[TextData[{
  "Here is the actual source code for the function ",
  StyleBox["f", "MR"],
  ". There is no need for the arguments of this function to have the same \
names as their ",
  StyleBox["Mathematica", "TI"],
  " counterparts."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.65"}],

Cell[TextData[{
  "int f(int i, int j) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return i + j;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n"
}], "Program",
  CellTags->{"S2.13.3", "3.66"}],

Cell[TextData[{
  "Here is the actual source code for ",
  StyleBox["g", "MR"],
  ". Numbers that you give in ",
  StyleBox["Mathematica", "TI"],
  " will automatically be converted into C ",
  StyleBox["double", "MR"],
  " types before being passed to ",
  StyleBox["g", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.67"}],

Cell[TextData[{
  "double g(double x) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n   return x*x;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.3", "3.68"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.69"}],

Cell[TextData[{
  "By using ",
  StyleBox[":Evaluate:", "MR"],
  " specifications, you can evaluate ",
  StyleBox["Mathematica", "TI"],
  " expressions when an external program is first installed. You can also \
execute code inside the external program at this time simply by inserting the \
code in ",
  StyleBox["main()", "MR"],
  " before the call to ",
  StyleBox["MLMain()", "MR"],
  ". This is sometimes useful if you need to initialize the external program \
before any functions in it are used. "
}], "Text",
  CellTags->{"S2.13.3", "3.70"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLEvaluateString(stdlink, \"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\")", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate a string as ",
              StyleBox["Mathematica", "TI"],
              " input "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.3"],

Cell[TextData[{
  "Executing a command in ",
  StyleBox["Mathematica", "SO"],
  " from within an external program. "
}], "Caption",
  CellTags->"S2.13.3"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.3", "3.71"}],

Cell["int diff(int i, int j) {", "Program",
  CellTags->{"S2.13.3", "3.72"}],

Cell[TextData[{
  "This evaluates a ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Print", "MR"],
  " function if ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["j", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.3", "3.73"}],

Cell["\<\
    if (i < j) MLEvaluateString(stdlink, \
\"Print[\\\"negative\\\"]\");\
\>", "Program",
  CellTags->{"S2.13.3", "3.74"}],

Cell["\<\
    return i - j;
}\
\>", "Program",
  CellTags->{"S2.13.3", "3.75"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.3", "3.76"}],

Cell[TextData[{
  "This installs an external program containing the ",
  StyleBox["diff", "MR"],
  " function defined above. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.77"}],

Cell[CellGroupData[{

Cell["Install[\"diffprog\"]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(LinkObject["./diffprog", 7, 5]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "Calling ",
  StyleBox["diff", "MR"],
  " causes ",
  StyleBox["Print", "MR"],
  " to be executed. "
}], "MathCaption",
  CellTags->{"S2.13.3", "3.78"}],

Cell[CellGroupData[{

Cell["diff[4, 7]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \("negative"\)], "Print",
  CellTags->"S2.13.3"],

Cell[BoxData[
    \(\(-3\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.13.3"]
}, Open  ]],

Cell[TextData[{
  "Note that any results generated in the evaluation requested by ",
  StyleBox["MLEvaluateString()", "MR"],
  " are ignored. To make use of such results requires full two\[Hyphen]way \
communication between ",
  StyleBox["Mathematica", "TI"],
  " and external programs, as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.13.9",
    ButtonData:>{"2.13.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.13.3", "3.79"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.4 Handling Lists, Arrays and Other Expressions", "Subsection",
  CellTags->{"S2.13.4", "4.1"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows you to exchange data of any type with external programs. For more \
common types of data, you simply need to give appropriate ",
  StyleBox[":ArgumentTypes:", "MR"],
  " or ",
  StyleBox[":ReturnType:", "MR"],
  " specifications in your ",
  StyleBox["MathLink", "TI"],
  " template file. "
}], "Text",
  CellTags->{"S2.13.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              StyleBox[" specification", "SO10"],
              " "
            }]], Cell[""], Cell[TextData[{
              StyleBox["C specification", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integer", "MR"],
              " "
            }]], Cell["integer "], Cell[TextData[{
              StyleBox["int", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Real", "MR"],
              " "
            }]], Cell["floating\[Hyphen]point number "], Cell[TextData[{
              StyleBox["double", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IntegerList", "MR"],
              " "
            }]], Cell["list of integers "], Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["*", "MR"],
              ", ",
              StyleBox["long", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RealList", "MR"],
              " "
            }]], Cell["\<\
list of floating\[Hyphen]point numbers \
\>"], 
            Cell[TextData[{
              StyleBox["double", "MR"],
              " ",
              StyleBox["*", "MR"],
              ", ",
              StyleBox["long", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["String", "MR"],
              " "
            }]], Cell["character string "], Cell[TextData[{
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Symbol", "MR"],
              " "
            }]], Cell["symbol name "], Cell[TextData[{
              StyleBox["char", "MR"],
              " ",
              StyleBox["*", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Manual", "MR"],
              " "
            }]], Cell[TextData[{
              "call ",
              StyleBox["MathLink", "TI"],
              " routines directly "
            }]], Cell[TextData[{
              StyleBox["void", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False, False, False, False, False, True}},
  CellTags->"S2.13.4"],

Cell["Basic type specifications. ", "Caption",
  CellTags->"S2.13.4"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.3"}],

Cell[TextData[{
  "Here is the ",
  StyleBox["MathLink", "TI"],
  " template for a function that takes a list of integers as its argument. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.4"}],

Cell[TextData[{
  ":Begin:\n:Function:       h\n:Pattern:        h[a_List]\n:Arguments:      \
",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "a",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "IntegerList",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Integer\n:End:\n"
}], "Program",
  CellTags->{"S2.13.4", "4.5"}],

Cell[TextData[{
  "Here is the C source code for the function. Note the extra argument ",
  StyleBox["alen", "MR"],
  " which is used to pass the length of the list. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.6"}],

Cell[TextData[{
  "int h(int *a, long alen) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n\n   int i, tot=0;\n\n   for(i=0; i<alen; i++)\n      tot += a[i];\n\n   \
return tot;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.7"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.8"}],

Cell[TextData[{
  "This installs an external program containing the specifications for the \
function ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.9"}],

Cell[CellGroupData[{

Cell["Install[\"hprog\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(LinkObject["./hprog", 9, 6]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell["This calls the external code. ", "MathCaption",
  CellTags->{"S2.13.4", "4.10"}],

Cell[CellGroupData[{

Cell["h[{3, 5, 6}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(14\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "This does not match the pattern ",
  StyleBox["h[a_List]", "MR"],
  " so does not call the external code. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.11"}],

Cell[CellGroupData[{

Cell["h[67]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(h[67]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "The pattern is matched, but the elements in the list are of the wrong type \
for the external code, so ",
  StyleBox["$Failed", "MR"],
  " is returned. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.12"}],

Cell[CellGroupData[{

Cell["h[{a, b, c}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "You can mix basic types of arguments in any way you want. Whenever you use \
",
  StyleBox["IntegerList", "MR"],
  " or ",
  StyleBox["RealList", "MR"],
  ", however, you have to include an extra argument in your C program to \
represent the length of the list. "
}], "Text",
  CellTags->{"S2.13.4", "4.13"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.14"}],

Cell[TextData[{
  "Here is an ",
  StyleBox[":ArgumentTypes:", "MR"],
  " specification. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.15"}],

Cell[TextData[{
  ":ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "IntegerList, RealList, Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n"
}], "Program",
  CellTags->{"S2.13.4", "4.16"}],

Cell["Here is a possible corresponding C function declaration. ", \
"MathCaption",
  CellTags->{"S2.13.4", "4.17"}],

Cell["void f(int *a, long alen, double *b, long blen, int c)", "Program",
  CellTags->{"S2.13.4", "4.18"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.19"}],

Cell[TextData[{
  "Note that when a list is passed to a C program by ",
  StyleBox["MathLink", "TI"],
  " its first element is assumed to be at position 0, as is standard in C, \
rather than at position 1, as is standard in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.20"}],

Cell[TextData[{
  "In addition, following C standards, character strings specified by ",
  StyleBox["String", "MR"],
  " are passed as ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  " objects, terminated by \[Backslash]",
  StyleBox["0", "MR"],
  " null bytes. Section\[NonBreakingSpace]",
  ButtonBox["2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  " discusses how to handle special characters. "
}], "Text",
  CellTags->{"S2.13.4", "4.21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLPutInteger(stdlink, int ", "MR"],
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a single integer "]},
          {Cell[TextData[{
              StyleBox["MLPutReal(stdlink, double ", "MR"],
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a single floating\[Hyphen]point number \
\>"]},
          {Cell[TextData[{
              StyleBox["MLPutIntegerList(stdlink, int *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "put a list of ",
              StyleBox["n", "TI"],
              " integers starting from location\[NonBreakingSpace]",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutRealList(stdlink, double *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "put a list of ",
              StyleBox["n", "TI"],
              
              " floating\[Hyphen]point numbers starting from location\
\[NonBreakingSpace]",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutIntegerArray(stdlink, int *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[", NULL, long ", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "put an array of integers to form a depth ",
              StyleBox["d", "TI"],
              " list with dimensions ",
              StyleBox["dims", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutRealArray(stdlink, double *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[", NULL, long ", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put an array of floating\[Hyphen]point numbers \
\>"]},
          {Cell[TextData[{
              StyleBox["MLPutString(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a character string "]},
          {Cell[TextData[{
              StyleBox["MLPutSymbol(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a character string as a symbol name "]},
          {Cell[TextData[{
              StyleBox["MLPutFunction(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "begin putting a function with head ",
              StyleBox["s", "TI"],
              " and ",
              StyleBox["n", "TI"],
              " arguments "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False, True, False, True, False, True}},
  CellTags->"S2.13.4"],

Cell[TextData[{
  StyleBox["MathLink", "SO"],
  " functions for sending data to ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "When you use a ",
  StyleBox["MathLink", "TI"],
  " template file, what ",
  StyleBox["mprep", "MR"],
  " and ",
  StyleBox["mcc", "MR"],
  " actually do is to create a C program that includes explicit calls to ",
  StyleBox["MathLink", "TI"],
  " library functions. If you want to understand how ",
  StyleBox["MathLink", "TI"],
  " works, you can look at the source code of this program. Note when you use \
",
  StyleBox["mcc", "MR"],
  ", you typically need to give a ",
  StyleBox["-g", "MR"],
  " option, otherwise the source code that is generated is automatically \
deleted.  "
}], "Text",
  CellTags->{"S2.13.4", "4.22"}],

Cell[TextData[{
  "If your external function just returns a single integer or floating\
\[Hyphen]point number, then you can specify this just by giving ",
  StyleBox["Integer", "MR"],
  " or ",
  StyleBox["Real", "MR"],
  " as the ",
  StyleBox[":ReturnType:", "MR"],
  " in your ",
  StyleBox["MathLink", "TI"],
  " template file. But because of the way memory allocation and deallocation \
work in C, you cannot directly give ",
  StyleBox[":ReturnType:", "MR"],
  " specifications such as ",
  StyleBox["IntegerList", "MR"],
  " or ",
  StyleBox["RealList", "MR"],
  ". And instead, to return such structures, you must explicitly call ",
  StyleBox["MathLink", "TI"],
  " library functions within your C program, and give ",
  StyleBox["Manual", "MR"],
  " as the ",
  StyleBox[":ReturnType:", "MR"],
  " specification. "
}], "Text",
  CellTags->{"S2.13.4", "4.23"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.24"}],

Cell[TextData[{
  "Here is the ",
  StyleBox["MathLink", "TI"],
  " template for a function that takes an integer as an argument, and returns \
its value using explicit ",
  StyleBox["MathLink", "TI"],
  " functions. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.25"}],

Cell[TextData[{
  ":Begin:\n:Function:       bits\n:Pattern:        bits[i_Integer]\n\
:Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "i",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:     Manual\n:End:\n"
}], "Program",
  CellTags->{"S2.13.4", "4.26"}],

Cell[TextData[{
  "The function is declared as ",
  StyleBox["void", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.27"}],

Cell["\<\
void bits(int i) {

   int a[32], k;
\
\>", "Program",
  CellTags->{"S2.13.4", "4.28"}],

Cell[TextData[{
  "This puts values into the C array ",
  StyleBox["a", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.4", "4.29"}],

Cell[TextData[{
  "   for(k=0; k<32; k++) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n       a[k] = i%2;\n       i >>= 1;\n       if (i==0) break;\n   ",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n\n   if (k<32) k++;\n"
}], "Program",
  CellTags->{"S2.13.4", "4.30"}],

Cell[TextData[{
  "This sends ",
  StyleBox["k", "MR"],
  " elements of the array ",
  StyleBox["a", "MR"],
  " back to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.31"}],

Cell["\<\
    MLPutIntegerList(stdlink, a, k);
    return ;
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.32"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.33"}],

Cell[TextData[{
  "This installs the program containing the external function ",
  StyleBox["bits", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.34"}],

Cell[CellGroupData[{

Cell["Install[\"bitsprog\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \(LinkObject[bitsprog, 5, 5]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell["The external function now returns a list of bits. ", "MathCaption",
  CellTags->{"S2.13.4", "4.35"}],

Cell[CellGroupData[{

Cell["bits[14]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({0, 1, 1, 1}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "If you declare an array in C as ",
  StyleBox["int ", "MR"],
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["n1", "TI"],
  StyleBox["][", "MR"],
  StyleBox["n2", "TI"],
  StyleBox["][", "MR"],
  StyleBox["n3", "TI"],
  StyleBox["]", "MR"],
  " then you can use ",
  StyleBox["MLPutIntegerArray()", "MR"],
  " to send it to ",
  StyleBox["Mathematica", "TI"],
  " as a depth 3 list. "
}], "Text",
  CellTags->{"S2.13.4", "4.36"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.37"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.38"}],

Cell["\<\
Here is a declaration for a 3\[Hyphen]dimensional C array.\
\>", \
"MathCaption",
  CellTags->{"S2.13.4", "4.39"}],

Cell["   int a[8][16][100];", "Program",
  CellTags->{"S2.13.4", "4.40"}],

Cell[TextData[{
  "This sets up the array ",
  StyleBox["dims", "MR"],
  " and initializes it to the dimensions of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.41"}],

Cell[TextData[{
  "   long dims[] = ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "8, 16, 100",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  ";"
}], "Program",
  CellTags->{"S2.13.4", "4.42"}],

Cell["\<\
   ...
\
\>", "Program",
  CellTags->{"S2.13.4", "4.43"}],

Cell[TextData[{
  "This sends the 3\[Hyphen]dimensional array ",
  StyleBox["a", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  ", creating a depth 3 list. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.44"}],

Cell["    MLPutIntegerArray(stdlink, a, dims, NULL, 3);", "Program",
  CellTags->{"S2.13.4", "4.45"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.46"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.47"}],

Cell[TextData[{
  "You can use ",
  StyleBox["MathLink", "TI"],
  " functions to create absolutely any ",
  StyleBox["Mathematica", "TI"],
  " expression. The basic idea is to call a sequence of ",
  StyleBox["MathLink", "TI"],
  " functions that correspond directly to the ",
  StyleBox["FullForm", "MR"],
  " representation of the ",
  StyleBox["Mathematica", "TI"],
  " expression. "
}], "Text",
  CellTags->{"S2.13.4", "4.48"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.49"}],

Cell[TextData[{
  "This sets up the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Plus", "MR"],
  " with 2 arguments. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.50"}],

Cell["MLPutFunction(stdlink, \"Plus\", 2);", "Program",
  CellTags->{"S2.13.4", "4.51"}],

Cell[TextData[{
  "This specifies that the first argument is the integer ",
  StyleBox["77", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.4", "4.52"}],

Cell["MLPutInteger(stdlink, 77);", "Program",
  CellTags->{"S2.13.4", "4.53"}],

Cell[TextData[{
  "And this specifies that the second argument is the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.54"}],

Cell["MLPutSymbol(stdlink, \"x\");", "Program",
  CellTags->{"S2.13.4", "4.55"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.56"}],

Cell[TextData[{
  "In general, you first call ",
  StyleBox["MLPutFunction()", "MR"],
  ", giving the head of the ",
  StyleBox["Mathematica", "TI"],
  " function you want to create, and the number of arguments it has. Then you \
call other ",
  StyleBox["MathLink", "TI"],
  " functions to fill in each of these arguments in turn. Section ",
  ButtonBox["2.1",
    ButtonData:>{"2.1"},
    ButtonStyle->"MainBookLink"],
  " discusses the general structure of ",
  StyleBox["Mathematica", "TI"],
  " expressions and the notion of heads. "
}], "Text",
  CellTags->{"S2.13.4", "4.57"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.58"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["Mathematica", "TI"],
  " list with 2 elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.59"}],

Cell["MLPutFunction(stdlink, \"List\", 2);", "Program",
  CellTags->{"S2.13.4", "4.60"}],

Cell[TextData[{
  "The first element of the list is a list of 10 integers from the C array ",
  StyleBox["r", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.61"}],

Cell["MLPutIntegerList(stdlink, r, 10);", "Program",
  CellTags->{"S2.13.4", "4.62"}],

Cell["\<\
The second element of the main list is itself a list with 2 \
elements. \
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.63"}],

Cell["MLPutFunction(stdlink, \"List\", 2);", "Program",
  CellTags->{"S2.13.4", "4.64"}],

Cell["\<\
The first element of this sublist is a floating\[Hyphen]point \
number. \
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.65"}],

Cell["MLPutReal(stdlink, 4.5);", "Program",
  CellTags->{"S2.13.4", "4.66"}],

Cell["The second element is an integer. ", "MathCaption",
  CellTags->{"S2.13.4", "4.67"}],

Cell["MLPutInteger(stdlink, 11);", "Program",
  CellTags->{"S2.13.4", "4.68"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.69"}],

Cell[TextData[{
  StyleBox["MLPutIntegerArray()", "MR"],
  " and ",
  StyleBox["MLPutRealArray()", "MR"],
  " allow you to send arrays which are laid out in memory in the \
one\[Hyphen]dimensional way that C pre\[Hyphen]allocates them. But if you \
create arrays during the execution of a C program, it is more common to set \
them up as nested collections of pointers. You can send such arrays to ",
  StyleBox["Mathematica", "TI"],
  " by using a sequence of ",
  StyleBox["MLPutFunction()", "MR"],
  " calls, ending with an ",
  StyleBox["MLPutIntegerList()", "MR"],
  " call. "
}], "Text",
  CellTags->{"S2.13.4", "4.70"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.71"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.72"}],

Cell[TextData[{
  "This declares ",
  StyleBox["a", "MR"],
  " to be a nested list of lists of lists of integers. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.73"}],

Cell["int ***a;", "Program",
  CellTags->{"S2.13.4", "4.74"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.75"}],

Cell[TextData[{
  "This creates a ",
  StyleBox["Mathematica", "TI"],
  " list with ",
  StyleBox["n1", "MR"],
  " elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.76"}],

Cell["MLPutFunction(stdlink, \"List\", n1);", "Program",
  CellTags->{"S2.13.4", "4.77"}],

Cell["for (i=0; i<n1; i++) {", "Program",
  CellTags->{"S2.13.4", "4.78"}],

Cell[TextData[{
  "This creates a sublist with ",
  StyleBox["n2", "MR"],
  " elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.79"}],

Cell["    MLPutFunction(stdlink, \"List\", n2);", "Program",
  CellTags->{"S2.13.4", "4.80"}],

Cell["    for (j=0; j<n2; j++) {", "Program",
  CellTags->{"S2.13.4", "4.81"}],

Cell["This writes out lists of integers. ", "MathCaption",
  CellTags->{"S2.13.4", "4.82"}],

Cell["        MLPutIntegerList(stdlink, a[i][j], n3);", "Program",
  CellTags->{"S2.13.4", "4.83"}],

Cell["\<\
    }
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.84"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.85"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.86"}],

Cell[TextData[{
  "It is important to realize that any expression you create using ",
  StyleBox["MathLink", "TI"],
  " functions will be evaluated as soon as it is sent to ",
  StyleBox["Mathematica", "TI"],
  ". This means, for example, that if you wanted to transpose an array that \
you were sending back to ",
  StyleBox["Mathematica", "TI"],
  ", all you would need to do is to wrap a ",
  StyleBox["Transpose", "MR"],
  " around the expression representing the array. You can then do this simply \
by calling ",
  StyleBox["MLPutFunction(stdlink,", "MR"],
  " ",
  StyleBox["\"Transpose\",", "MR"],
  " ",
  StyleBox["1);", "MR"],
  " just before you start creating the expression that represents the array. \
"
}], "Text",
  CellTags->{"S2.13.4", "4.87"}],

Cell[TextData[{
  "The idea of post\[Hyphen]processing data that you send back to ",
  StyleBox["Mathematica", "TI"],
  " has many uses. One example is as a way of sending lists whose length you \
do not know in advance.  "
}], "Text",
  CellTags->{"S2.13.4", "4.88"}],

Cell[TextData[{
  "This creates a list in ",
  StyleBox["Mathematica", "TI"],
  " by explicitly appending successive elements. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.89"}],

Cell[CellGroupData[{

Cell["t = {}; Do[t = Append[t, i^2], {i, 5}]; t", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({1, 4, 9, 16, 25}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell["\<\
This creates a list in which each successive element is in a nested \
sublist. \
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.90"}],

Cell[CellGroupData[{

Cell["t = {}; Do[t = {t, i^2}, {i, 5}]; t", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({{{{{{}, 1}, 4}, 9}, 16}, 25}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Flatten", "MR"],
  " flattens out the list. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.91"}],

Cell[CellGroupData[{

Cell["Flatten[t]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({1, 4, 9, 16, 25}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Sequence", "MR"],
  " automatically flattens itself. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.92"}],

Cell[CellGroupData[{

Cell["{Sequence[1, Sequence[4, Sequence[ ]]]}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.13.4"],

Cell[BoxData[
    \({1, 4}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.13.4"]
}, Open  ]],

Cell[TextData[{
  "In order to call ",
  StyleBox["MLPutIntegerList()", "MR"],
  ", you need to know the length of the list you want to send. But by \
creating a sequence of nested ",
  StyleBox["Sequence", "MR"],
  " objects, you can avoid having to know the length of your whole list in \
advance. "
}], "Text",
  CellTags->{"S2.13.4", "4.93"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.94"}],

Cell[TextData[{
  "This sets up the ",
  StyleBox["List", "MR"],
  " around your result. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.95"}],

Cell["MLPutFunction(stdlink, \"List\", 1);", "Program",
  CellTags->{"S2.13.4", "4.96"}],

Cell[TextData[{
  "while(",
  StyleBox[" condition", "MO"],
  " ) {\n    ",
  StyleBox[" generate an element", "MO"]
}], "Program",
  CellTags->{"S2.13.4", "4.97"}],

Cell[TextData[{
  "Create the next level ",
  StyleBox["Sequence", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.98"}],

Cell["    MLPutFunction(stdlink, \"Sequence\", 2);", "Program",
  CellTags->{"S2.13.4", "4.99"}],

Cell["Put the element. ", "MathCaption",
  CellTags->{"S2.13.4", "4.100"}],

Cell[TextData[{
  "    MLPutInteger(stdlink, ",
  StyleBox[" i", "MO"],
  " );"
}], "Program",
  CellTags->{"S2.13.4", "4.101"}],

Cell["}", "Program",
  CellTags->{"S2.13.4", "4.102"}],

Cell[TextData[{
  "This closes off your last ",
  StyleBox["Sequence", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.103"}],

Cell["MLPutFunction(stdlink, \"Sequence\", 0);", "Program",
  CellTags->{"S2.13.4", "4.104"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.105"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetInteger(stdlink, int *", "MR"],
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "get an integer, storing it at address ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLGetReal(stdlink, double *", "MR"],
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "get a floating\[Hyphen]point number, storing it at address ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.4"],

Cell[TextData[{
  "Basic functions for explicitly getting data from ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "Just as ",
  StyleBox["MathLink", "TI"],
  " provides functions like ",
  StyleBox["MLPutInteger()", "MR"],
  " to send data from an external program into ",
  StyleBox["Mathematica", "TI"],
  ", so also ",
  StyleBox["MathLink", "TI"],
  " provides functions like ",
  StyleBox["MLGetInteger()", "MR"],
  " that allow you to get data from ",
  StyleBox["Mathematica", "TI"],
  " into an external program. "
}], "Text",
  CellTags->{"S2.13.4", "4.106"}],

Cell[TextData[{
  "The list that you give for ",
  StyleBox[":ArgumentTypes:", "MR"],
  " in a ",
  StyleBox["MathLink", "TI"],
  " template can end with ",
  StyleBox["Manual", "MR"],
  ", indicating that after other arguments have been received, you will call \
",
  StyleBox["MathLink", "TI"],
  " functions to get additional expressions. "
}], "Text",
  CellTags->{"S2.13.4", "4.107"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.108"}],

Cell["\<\
:Begin:
:Function:       f\
\>", "Program",
  CellTags->{"S2.13.4", "4.109"}],

Cell[TextData[{
  "The function ",
  StyleBox["f", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " takes 3 arguments. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.110"}],

Cell[":Pattern:        f[i_Integer, x_Real, y_Real]", "Program",
  CellTags->{"S2.13.4", "4.111"}],

Cell["\<\
All these arguments are passed directly to the external \
program.\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.112"}],

Cell[TextData[{
  ":Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "i, x, y",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.113"}],

Cell["\<\
Only the first argument is sent directly to the external function. \
\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.114"}],

Cell[TextData[{
  ":ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer, Manual",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.115"}],

Cell["\<\
:ReturnType:     Real
:End:
\
\>", "Program",
  CellTags->{"S2.13.4", "4.116"}],

Cell["The external function only takes one explicit argument. ", "MathCaption",
  CellTags->{"S2.13.4", "4.117"}],

Cell["\<\
double f(int i) {
\
\>", "Program",
  CellTags->{"S2.13.4", "4.118"}],

Cell[TextData[{
  "This declares the variables ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.119"}],

Cell["\<\
   double x, y;
\
\>", "Program",
  CellTags->{"S2.13.4", "4.120"}],

Cell[TextData[{
  StyleBox["MLGetReal()", "MR"],
  " explicitly gets data from the link. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.121"}],

Cell["\<\
   MLGetReal(stdlink, &x);
   MLGetReal(stdlink, &y);
\
\>", "Program",
  CellTags->{"S2.13.4", "4.122"}],

Cell["\<\
   return i+x+y;
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.123"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.124"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " functions such as ",
  StyleBox["MLGetInteger(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["pi", "TI"],
  StyleBox[")", "MR"],
  " work much like standard C library functions such as ",
  StyleBox["fscanf(", "MR"],
  StyleBox["fp", "TI"],
  StyleBox[", \"%d\", ", "MR"],
  StyleBox["pi", "TI"],
  StyleBox[")", "MR"],
  ". The first argument specifies the link from which to get data. The last \
argument gives the address at which the data that is obtained should be \
stored. "
}], "Text",
  CellTags->{"S2.13.4", "4.125"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLCheckFunction(stdlink, \"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
check the head of a function and store how many \
arguments it has \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.4"],

Cell[TextData[{
  "Getting a function via ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.4"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.126"}],

Cell["\<\
:Begin:
:Function:       f\
\>", "Program",
  CellTags->{"S2.13.4", "4.127"}],

Cell[TextData[{
  "The function ",
  StyleBox["f", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " takes a list of integers as an argument. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.128"}],

Cell[TextData[{
  ":Pattern:        f[a:",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "___Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "]"
}], "Program",
  CellTags->{"S2.13.4", "4.129"}],

Cell["The list is passed directly to the external program.", "MathCaption",
  CellTags->{"S2.13.4", "4.130"}],

Cell[TextData[{
  ":Arguments:      ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "a",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.131"}],

Cell["\<\
The argument is to be retrieved manually by the external program. \
\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.132"}],

Cell[TextData[{
  ":ArgumentTypes:  ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Manual",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.4", "4.133"}],

Cell["\<\
:ReturnType:     Integer
:End:
\
\>", "Program",
  CellTags->{"S2.13.4", "4.134"}],

Cell["The external function takes no explicit arguments. ", "MathCaption",
  CellTags->{"S2.13.4", "4.135"}],

Cell["\<\
int f(void) {
\
\>", "Program",
  CellTags->{"S2.13.4", "4.136"}],

Cell["This declares local variables. ", "MathCaption",
  CellTags->{"S2.13.4", "4.137"}],

Cell["\<\
    long n, i;
    int a[MAX];
\
\>", "Program",
  CellTags->{"S2.13.4", "4.138"}],

Cell[TextData[{
  "This checks that the function being sent is a list, and stores how many \
elements it has in ",
  StyleBox["n", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.139"}],

Cell["\<\
    MLCheckFunction(stdlink, \"List\", &n);
\
\>", "Program",
  CellTags->{"S2.13.4", "4.140"}],

Cell[TextData[{
  "This gets each element in the list, storing it in ",
  StyleBox["a[i]", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.4", "4.141"}],

Cell["\<\
   for (i=0; i<n; i++)
      MLGetInteger(stdlink, a+i);\
\>", "Program",
  CellTags->{"S2.13.4", "4.142"}],

Cell["\<\
...
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.143"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.144"}],

Cell[TextData[{
  "In simple cases, it is usually possible to ensure on the ",
  StyleBox["Mathematica", "TI"],
  " side that the data you send to an external program has the structure that \
is expected. But in general the return value from ",
  StyleBox["MLCheckFunction()", "MR"],
  " will be non\[Hyphen]zero only if the data consists of a function with the \
name you specify. "
}], "Text",
  CellTags->{"S2.13.4", "4.145"}],

Cell[TextData[{
  "Note that if you want to get a nested collection of lists or other \
objects, you can do this by making an appropriate sequence of calls to ",
  StyleBox["MLCheckFunction()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.146"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetIntegerList(stdlink, int **", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a list of integers, allocating the memory needed to \
store\[NonBreakingSpace]it\
\>"]},
          {Cell[TextData[{
              StyleBox["MLGetRealList(stdlink, double **", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a list of floating\[Hyphen]point numbers \
\>"]},
          {Cell[TextData[{
              StyleBox["MLDisownIntegerList(stdlink, int *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "disown the memory associated with a list of integers "]},
          {Cell[TextData[{
              StyleBox["MLDisownRealList(stdlink, double *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
disown the memory associated with a list of floating\
\[Hyphen]point numbers \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.4"],

Cell["Getting lists of numbers. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "When an external program gets data from ",
  StyleBox["Mathematica", "TI"],
  ", it must set up a place to store the data. If the data consists of a \
single integer, as in ",
  StyleBox["MLGetInteger(stdlink, &", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  ", then it suffices just to have declared this integer using ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["n", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.147"}],

Cell["\<\
But when the data consists of a list of integers of potentially any \
length, memory must be allocated to store this list at the time when the \
external program is actually called. \
\>", "Text",
  CellTags->{"S2.13.4", "4.148"}],

Cell[TextData[{
  StyleBox["MLGetIntegerList(stdlink, &", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", &", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " will automatically do this allocation, setting ",
  StyleBox["a", "TI"],
  " to be a pointer to the result. Note that memory allocated by functions \
like ",
  StyleBox["MLGetIntegerList()", "MR"],
  " is always in a special reserved area, so you cannot modify or free it \
directly. "
}], "Text",
  CellTags->{"S2.13.4", "4.149"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.4", "4.150"}],

Cell["\<\
Here is an external program that will be sent a list of integers. \
\
\>", "MathCaption",
  CellTags->{"S2.13.4", "4.151"}],

Cell["\<\
int f(void) {
\
\>", "Program",
  CellTags->{"S2.13.4", "4.152"}],

Cell[TextData[{
  "This declares local variables. ",
  StyleBox["a", "MR"],
  " is an array of integers. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.153"}],

Cell["\<\
    long n;
    int *a;
\
\>", "Program",
  CellTags->{"S2.13.4", "4.154"}],

Cell[TextData[{
  "This gets a list of integers, making ",
  StyleBox["a", "MR"],
  " be a pointer to the result. "
}], "MathCaption",
  CellTags->{"S2.13.4", "4.155"}],

Cell["\<\
    MLGetIntegerList(stdlink, &a, &n);
\
\>", "Program",
  CellTags->{"S2.13.4", "4.156"}],

Cell["...", "Program",
  CellTags->{"S2.13.4", "4.157"}],

Cell["This disowns the memory used to store the list of integers. ", \
"MathCaption",
  CellTags->{"S2.13.4", "4.158"}],

Cell["    MLDisownIntegerList(stdlink, a, n);", "Program",
  CellTags->{"S2.13.4", "4.159"}],

Cell["\<\
...
}\
\>", "Program",
  CellTags->{"S2.13.4", "4.160"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.4", "4.161"}],

Cell[TextData[{
  "If you use ",
  StyleBox["IntegerList", "MR"],
  " as an ",
  StyleBox[":ArgumentTypes:", "MR"],
  " specification, then ",
  StyleBox["MathLink", "TI"],
  " will automatically disown the memory used for the list after your \
external function exits. But if you get a list of integers explicitly using \
",
  StyleBox["MLGetIntegerList()", "MR"],
  ", then you must not forget to disown the memory used to store the list \
after you have finished with it. "
}], "Text",
  CellTags->{"S2.13.4", "4.162"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetIntegerArray(stdlink, int **", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long **", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[", char ***", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get an array of integers of any depth "]},
          {Cell[TextData[{
              StyleBox["MLGetRealArray(stdlink, double **", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long **", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[", char ***", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get an array of floating\[Hyphen]point numbers of any \
depth \
\>"]},
          {Cell[TextData[{
              StyleBox["MLDisownIntegerArray(stdlink, int *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[", char **", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with an integer array "]},
          {Cell[TextData[{
              StyleBox["MLDisownRealArray(stdlink, double *", "MR"],
              StyleBox["a", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["dims", "TI"],
              StyleBox[", char **", "MR"],
              StyleBox["heads", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["d", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
disown memory associated with a floating\[Hyphen]point \
array \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.4"],

Cell["Getting arrays of numbers. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  StyleBox["MLGetIntegerList()", "MR"],
  " extracts a one\[Hyphen]dimensional array of integers from a single ",
  StyleBox["Mathematica", "TI"],
  " list. ",
  StyleBox["MLGetIntegerArray()", "MR"],
  " extracts an array of integers from a collection of lists or other ",
  StyleBox["Mathematica", "TI"],
  " functions nested to any depth. "
}], "Text",
  CellTags->{"S2.13.4", "4.163"}],

Cell[TextData[{
  "The name of the ",
  StyleBox["Mathematica", "TI"],
  " function at level ",
  StyleBox["i", "TI"],
  " in the structure is stored as a string in ",
  StyleBox["heads", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". The size of the structure at level ",
  StyleBox["i", "TI"],
  " is stored in ",
  StyleBox["dims", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ", while the total depth is stored in ",
  StyleBox["d", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.164"}],

Cell[TextData[{
  "If you pass a list of complex numbers to your external program, then ",
  StyleBox["MLGetRealArray()", "MR"],
  " will create a two\[Hyphen]dimensional array containing a sequence of \
pairs of real and imaginary parts. In this case, ",
  StyleBox["heads", "TI"],
  StyleBox["[0]", "MR"],
  " will be ",
  StyleBox["\"List\"", "MR"],
  " while ",
  StyleBox["heads", "TI"],
  StyleBox["[1]", "MR"],
  " will be ",
  StyleBox["\"Complex\"", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.165"}],

Cell[TextData[{
  "Note that you can conveniently exchange arbitrary\[Hyphen]precision \
numbers with external programs by converting them to lists of digits in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["IntegerDigits", "MR"],
  " and ",
  StyleBox["RealDigits", "MR"],
  ".   "
}], "Text",
  CellTags->{"S2.13.4", "4.166"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetString(stdlink, char **", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a character string "]},
          {Cell[TextData[{
              StyleBox["MLGetSymbol(stdlink, char **", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a symbol name "]},
          {Cell[TextData[{
              StyleBox["MLDisownString(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with a character string "]},
          {Cell[TextData[{
              StyleBox["MLDisownSymbol(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with a symbol name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.4"],

Cell["Getting character strings and symbol names. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "If you use ",
  StyleBox["String", "MR"],
  " as an ",
  StyleBox[":ArgumentTypes:", "MR"],
  " specification, then ",
  StyleBox["MathLink", "TI"],
  " will automatically disown the memory that is used to store the string \
after your function exits. This means that if you want to continue to refer \
to the string, you must allocate memory for it, and explicitly copy each \
character in it. "
}], "Text",
  CellTags->{"S2.13.4", "4.167"}],

Cell[TextData[{
  "If you get a string using ",
  StyleBox["MLGetString()", "MR"],
  ", however, then ",
  StyleBox["MathLink", "TI"],
  " will not automatically disown the memory used for the string when your \
function exits. As a result, you can continue referring to the string. When \
you no longer need the string, you must nevertheless explicitly call ",
  StyleBox["MLDisownString()", "MR"],
  " in order to disown the memory associated with it. "
}], "Text",
  CellTags->{"S2.13.4", "4.168"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLGetFunction(stdlink, char **", "MR"],
              StyleBox["s", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "begin getting a function, storing the name of the head in ",
              StyleBox["s", "TI"],
              " and the number of arguments in ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MLDisownSymbol(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["disown memory associated with a function name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S2.13.4"],

Cell["Getting an arbitrary function. ", "Caption",
  CellTags->"S2.13.4"],

Cell[TextData[{
  "If you know what function to expect in your external program, then it is \
usually simpler to call ",
  StyleBox["MLCheckFunction()", "MR"],
  ". But if you do not know what function to expect, you have no choice but \
to call ",
  StyleBox["MLGetFunction()", "MR"],
  ". If you do this, you need to be sure to call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown the memory associated with the name of the function that is \
found by ",
  StyleBox["MLGetFunction()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.4", "4.169"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.5 Special Topic: Portability of ",
  StyleBox["MathLink", "SBO"],
  " Programs"
}], "Subsection",
  CellTags->{"S2.13.5", "5.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " side of a ",
  StyleBox["MathLink", "TI"],
  " connection is set up to work exactly the same on all computer systems. \
But inevitably there are differences between external programs on different \
computer systems."
}], "Text",
  CellTags->{"S2.13.5", "5.2"}],

Cell[TextData[{
  "For a start, different computer systems almost always require different \
executable binaries. When you call ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  ", therefore, you must be sure that ",
  StyleBox["prog", "TI"],
  " corresponds to a program that can be executed on your particular computer \
system.  "
}], "Text",
  CellTags->{"S2.13.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to execute ",
              StyleBox["file", "TI"],
              " directly "
            }]]},
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\", LinkProtocol->\"", "MR"],
              StyleBox["type", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
use the specified protocol for low\[Hyphen]level data \
transport \
\>"]},
          {Cell[TextData[{
              StyleBox["$SystemID", "MR"],
              " "
            }]], Cell["identify the type of computer system being used "]},
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["dir", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to execute a file with a name of the form ",
              StyleBox["dir", "TI"],
              StyleBox["/$SystemID/", "MR"],
              StyleBox["dir", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.5"],

Cell["Installing programs on different computer systems.", "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " follows the convention that if ",
  StyleBox["prog", "TI"],
  " is an ordinary file, then ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " will just try to execute it. But if ",
  StyleBox["prog", "TI"],
  " is a directory, then ",
  StyleBox["Mathematica", "TI"],
  " will look for a subdirectory of that directory whose name agrees with the \
current value of ",
  StyleBox["$SystemID", "MR"],
  ", and will then try to execute a file named ",
  StyleBox["prog", "TI"],
  " within that subdirectory. "
}], "Text",
  CellTags->{"S2.13.5", "5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["mcc -o ", "MR"],
              StyleBox["prog", "TI"],
              StyleBox[" ", "MR"],
              "\[Ellipsis]",
              StyleBox[" ", "MR"],
              " "
            }]], Cell[TextData[{
              "put compiled code in the file ",
              StyleBox["prog", "TI"],
              " in the current directory "
            }]]},
          {Cell[TextData[{
              StyleBox["mcc -xo ", "MR"],
              StyleBox["prog", "TI"],
              StyleBox[" ", "MR"],
              "\[Ellipsis]",
              StyleBox[" ", "MR"],
              " "
            }]], Cell[TextData[{
              "put compiled code in ",
              StyleBox["prog", "TI"],
              StyleBox["/$SystemID/", "MR"],
              StyleBox["prog", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.5"],

Cell["Typical Unix commands for compiling external programs. ", "Caption",
  CellTags->"S2.13.5"],

Cell["\<\
Even though the executable binary of an external program is \
inevitably different on different computer systems, it can still be the case \
that the source code in a language such as C from which this binary is \
obtained can be essentially the same.  \
\>", "Text",
  CellTags->{"S2.13.5", "5.5"}],

Cell["\<\
But to achieve portability in your C source code there are several \
points that you need to watch. \
\>", "Text",
  CellTags->{"S2.13.5", "5.6"}],

Cell["\<\
For a start, you should never make use of extra features of the C \
language or C run\[Hyphen]time libraries that happen to be provided on a \
particular system, but are not part of standard C. In addition, you should \
try to avoid dealing with segmented or otherwise special memory models. \
\
\>", "Text",
  CellTags->{"S2.13.5", "5.7"}],

Cell[TextData[{
  "The include file ",
  StyleBox["mathlink.h", "MR"],
  " contains standard C prototypes for all the functions in the ",
  StyleBox["MathLink", "TI"],
  " library. If your compiler does not support such prototypes, you can \
ignore them by giving the directive ",
  StyleBox["#define", "MR"],
  " ",
  StyleBox["MLPROTOTYPES", "MR"],
  " ",
  StyleBox["0", "MR"],
  " before ",
  StyleBox["#include", "MR"],
  " ",
  StyleBox["\"mathlink.h\"", "MR"],
  ". But assuming that it does support prototypes, your compiler will always \
be able to check that the calls you make to functions in the ",
  StyleBox["MathLink", "TI"],
  " library have arguments of appropriate types.  "
}], "Text",
  CellTags->{"S2.13.5", "5.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLPutInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              "default integer of type ",
              StyleBox["int", "MR"],
              "; sometimes 16 bits, sometimes 32 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutShortInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetShortInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              "short integer of type ",
              StyleBox["short", "MR"],
              "; usually 16 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutLongInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetLongInteger()", "MR"],
              " "
            }]], Cell[TextData[{
              "long integer of type ",
              StyleBox["long", "MR"],
              "; usually 32 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutReal()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetReal()", "MR"],
              " "
            }]], Cell[TextData[{
              "default real number of type ",
              StyleBox["double", "MR"],
              "; usually at least 64 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutFloat()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetFloat()", "MR"],
              " "
            }]], Cell[TextData[{
              
              "single\[Hyphen]precision floating\[Hyphen]point number of type \
",
              StyleBox["float", "MR"],
              "; often 32 bits "
            }]]},
          {Cell[TextData[{
              StyleBox["MLPutDouble()", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MLGetDouble()", "MR"],
              " "
            }]], Cell[TextData[{
              
              "double\[Hyphen]precision floating\[Hyphen]point number of type \
",
              StyleBox["double", "MR"],
              "; usually at least 64 bits "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.13.5"],

Cell[TextData[{
  StyleBox["MathLink", "SO"],
  " functions that use specific C types. "
}], "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  "On some computer systems and with some compilers, a C language ",
  StyleBox["int", "MR"],
  " may be equivalent to a ",
  StyleBox["long", "MR"],
  ". But the standard for the C language equally well allows ",
  StyleBox["int", "MR"],
  " to be equivalent to ",
  StyleBox["short", "MR"],
  ". And if you are going to call ",
  StyleBox["MathLink", "TI"],
  " library functions in a portable way, it is essential that you use the \
same types as they do. "
}], "Text",
  CellTags->{"S2.13.5", "5.9"}],

Cell[TextData[{
  "Once you have passed your data into the ",
  StyleBox["MathLink", "TI"],
  " library functions, these functions then take care of all further issues \
associated with differences between data representations on different \
computer systems. Thus, for example, ",
  StyleBox["MathLink", "TI"],
  " automatically swaps bytes when it sends data between big and little \
endian machines, and converts floating\[Hyphen]point formats losing as little \
precision as possible. "
}], "Text",
  CellTags->{"S2.13.5", "5.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLPutString(stdlink, char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a string without special characters "]},
          {Cell[TextData[{
              StyleBox["MLPutUnicodeString(stdlink, unsigned short *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a string encoded in terms of 16\[Hyphen]bit Unicode \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["MLPutByteString(stdlink, unsigned char *", "MR"],
              StyleBox["s", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a string containing only 8\[Hyphen]bit character \
codes \
\>"]},
          {Cell[TextData[{
              StyleBox["MLGetString(stdlink, char **", "MR"],
              StyleBox["s", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a string without special characters "]},
          {Cell[TextData[{
              StyleBox["MLGetUnicodeString(stdlink, unsigned short **", "MR"],
              
              StyleBox["s", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a string encoded in terms of 16\[Hyphen]bit Unicode \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["MLGetByteString(stdlink, unsigned char **", "MR"],
              StyleBox["s", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["spec", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              
              "get a string containing only 8\[Hyphen]bit character codes, \
using ",
              StyleBox["spec", "TI"],
              " as the code for all 16\[Hyphen]bit characters "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.13.5"],

Cell["Manipulating general strings. ", "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  "In simple C programs, it is typical to use strings that contain only \
ordinary ASCII characters. But in ",
  StyleBox["Mathematica", "TI"],
  " it is possible to have strings containing all sorts of special \
characters. These characters are specified within ",
  StyleBox["Mathematica", "TI"],
  " using Unicode character codes, as discussed in \
Section\[NonBreakingSpace]",
  ButtonBox["2.8.9",
    ButtonData:>{"2.8.9", "9.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Text",
  CellTags->{"S2.13.5", "5.11"}],

Cell[TextData[{
  "C language ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*", "MR"],
  " strings typically use only 8 bits to store the code for each character. \
Unicode character codes, however, require 16 bits. As a result, the functions \
",
  StyleBox["MLPutUnicodeString()", "MR"],
  " and ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " work with arrays of ",
  StyleBox["unsigned", "MR"],
  " ",
  StyleBox["short", "MR"],
  " integers.  "
}], "Text",
  CellTags->{"S2.13.5", "5.12"}],

Cell[TextData[{
  "If you know that your program will not have to handle special characters, \
then you may find it convenient to use ",
  StyleBox["MLPutByteString()", "MR"],
  " and ",
  StyleBox["MLGetByteString()", "MR"],
  ". These functions represent all characters directly using 8\[Hyphen]bit \
character codes. If a special character is sent from ",
  StyleBox["Mathematica", "TI"],
  ", then it will be converted by ",
  StyleBox["MLGetByteString()", "MR"],
  " to a fixed code that you specify. "
}], "Text",
  CellTags->{"S2.13.5", "5.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["main()", "MR"],
              " may need to be different on different computer systems "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.5"],

Cell[TextData[{
  "A point to watch in creating portable ",
  StyleBox["MathLink", "SO"],
  " programs. "
}], "Caption",
  CellTags->"S2.13.5"],

Cell[TextData[{
  "Computer systems and compilers that have C run\[Hyphen]time libraries \
based on the Unix model allow ",
  StyleBox["MathLink", "TI"],
  " programs to have a main program of the form ",
  StyleBox["main(argc,", "MR"],
  " ",
  StyleBox["argv)", "MR"],
  " which simply calls ",
  StyleBox["MLMain(argc,", "MR"],
  " ",
  StyleBox["argv)", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.5", "5.14"}],

Cell[TextData[{
  "Some computer systems or compilers may however require main programs of a \
different form. You should realize that you can do whatever initialization \
you want inside ",
  StyleBox["main()", "MR"],
  " before calling ",
  StyleBox["MLMain()", "MR"],
  ". Once you have called ",
  StyleBox["MLMain()", "MR"],
  ", however, your program will effectively go into an infinite loop, \
responding to requests from ",
  StyleBox["Mathematica", "TI"],
  " until the link to it is closed. "
}], "Text",
  CellTags->{"S2.13.5", "5.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.6 Using ",
  StyleBox["MathLink", "SBO"],
  " to Communicate between ",
  StyleBox["Mathematica", "SBO"],
  " Sessions"
}], "Subsection",
  CellTags->{"S2.13.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkCreate[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["create a link for another program to connect to "]},
          {Cell[TextData[{
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["connect to a link created by another program "]},
          {Cell[TextData[{
              StyleBox["LinkClose[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "close a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkWrite[", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", ", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write an expression to a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkRead[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "read an expression from a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkRead[", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", Hold]", "MR"],
              " "
            }]], Cell[TextData[{
              "read an expression and immediately wrap it with ",
              StyleBox["Hold", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LinkReadyQ[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "find out whether there is data ready to be read from a link "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False, False, True}},
  CellTags->"S2.13.6"],

Cell[TextData[{
  StyleBox["MathLink", "SO"],
  " connections between ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.13.6"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.2"}],

Cell["This starts up a link on port number 8000. ", "MathCaption",
  CellTags->{"S2.13.6", "6.3"}],

Cell[CellGroupData[{

Cell["link = LinkCreate[\"8000\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.6"],

Cell["LinkObject[8000@frog.wolfram.com, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.4"}],

Cell["This connects to the link on port 8000. ", "MathCaption",
  CellTags->{"S2.13.6", "6.5"}],

Cell[CellGroupData[{

Cell["Link = LinkConnect[\"8000\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.6"],

Cell["LinkObject[\"8000@frog.wolfram.com\", 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.6"}],

Cell[TextData[{
  "This evaluates ",
  StyleBox["15!", "MR"],
  " and writes it to the link. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.7"}],

Cell["LinkWrite[link, 15!]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.6"],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.8"}],

Cell[TextData[{
  "This reads from the link, getting the ",
  StyleBox["15!", "MR"],
  " that was sent. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.9"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.6"],

Cell["1307674368000", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["This writes data back on the link. ", "MathCaption",
  CellTags->{"S2.13.6", "6.10"}],

Cell["LinkWrite[link, N[%^6]]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S2.13.6"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.11"}],

Cell["And this reads the data written in session B. ", "MathCaption",
  CellTags->{"S2.13.6", "6.12"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[3]:=",
  CellTags->"S2.13.6"],

Cell[BoxData[
    \(5.000318485342659`*^72\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "One use of ",
  StyleBox["MathLink", "TI"],
  " connections between ",
  StyleBox["Mathematica", "TI"],
  " sessions is simply as a way to transfer data without using intermediate \
files. "
}], "Text",
  CellTags->{"S2.13.6", "6.13"}],

Cell["\<\
Another use is as a way to dispatch different parts of a \
computation to different sessions. \
\>", "Text",
  CellTags->{"S2.13.6", "6.14"}],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.15"}],

Cell[TextData[{
  "This writes the expression ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " without evaluating it. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.16"}],

Cell["LinkWrite[link, Unevaluated[2 + 2]]", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S2.13.6"],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.17"}],

Cell[TextData[{
  "This reads the expression from the link, immediately wrapping it in ",
  StyleBox["Hold", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.18"}],

Cell[CellGroupData[{

Cell["LinkRead[link, Hold]", "Input",
  CellLabel->"In[4]:=",
  CellTags->"S2.13.6"],

Cell["Hold[2 + 2]", "Output",
  CellLabel->"Out[4]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["This evaluates the expression. ", "MathCaption",
  CellTags->{"S2.13.6", "6.19"}],

Cell[CellGroupData[{

Cell["ReleaseHold[%]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"S2.13.6"],

Cell["4", "Output",
  CellLabel->"Out[5]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "When you call ",
  StyleBox["LinkWrite", "MR"],
  ", it writes an expression to the ",
  StyleBox["MathLink", "TI"],
  " connection and immediately returns. But when you call ",
  StyleBox["LinkRead", "MR"],
  ", it will not return until it has read a complete expression from the ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Text",
  CellTags->{"S2.13.6", "6.20"}],

Cell[TextData[{
  "You can tell whether anything is ready to be read by calling ",
  StyleBox["LinkReadyQ[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  ". If ",
  StyleBox["LinkReadyQ", "MR"],
  " returns ",
  StyleBox["True", "MR"],
  ", then you can safely call ",
  StyleBox["LinkRead", "MR"],
  " and expect immediately to start reading an expression. But if ",
  StyleBox["LinkReadyQ", "MR"],
  " returns ",
  StyleBox["False", "MR"],
  ", then ",
  StyleBox["LinkRead", "MR"],
  " would block until an expression for it to read had been written by a ",
  StyleBox["LinkWrite", "MR"],
  " in your other ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.13.6", "6.21"}],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.22"}],

Cell[TextData[{
  "There is nothing waiting to be read on the link, so if ",
  StyleBox["LinkRead", "MR"],
  " were to be called, it would block. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.23"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[5]:=",
  CellTags->"S2.13.6"],

Cell["False", "Output",
  CellLabel->"Out[5]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.6", "6.24"}],

Cell["This writes an expression to the link. ", "MathCaption",
  CellTags->{"S2.13.6", "6.25"}],

Cell["LinkWrite[link, x + y]", "Input",
  CellLabel->"In[6]:=",
  CellTags->"S2.13.6"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.6", "6.26"}],

Cell["Now there is an expression waiting to be read on the link. ", \
"MathCaption",
  CellTags->{"S2.13.6", "6.27"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[6]:=",
  CellTags->"S2.13.6"],

Cell["True", "Output",
  CellLabel->"Out[6]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LinkRead", "MR"],
  " can thus be called without fear of blocking. "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.28"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[7]:=",
  CellTags->"S2.13.6"],

Cell["x + y", "Output",
  CellLabel->"Out[7]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkCreate[ ]", "MR"],
              " "
            }]], Cell["pick any unused port on your computer "]},
          {Cell[TextData[{
              StyleBox["LinkCreate[\"", "MR"],
              StyleBox["number", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["use a specific port "]},
          {Cell[TextData[{
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["number", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["connect to a port on the same computer "]},
          {Cell[TextData[{
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["number", "TI"],
              StyleBox["@", "MR"],
              StyleBox["host", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["connect a port on another computer "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.6"],

Cell[TextData[{
  "Ways to set up ",
  StyleBox["MathLink", "SO"],
  " links. "
}], "Caption",
  CellTags->"S2.13.6"],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " can use whatever mechanism for interprogram communication your computer \
system supports. In setting up connections between concurrent ",
  StyleBox["Mathematica", "TI"],
  " sessions, the most common mechanism is internet TCP ports.  "
}], "Text",
  CellTags->{"S2.13.6", "6.29"}],

Cell["\<\
Most computer systems have a few thousand possible numbered ports, \
some of which are typically allocated to standard system services. \
\>", \
"Text",
  CellTags->{"S2.13.6", "6.30"}],

Cell[TextData[{
  "You can use any of the unallocated ports for ",
  StyleBox["MathLink", "TI"],
  " connections. "
}], "Text",
  CellTags->{"S2.13.6", "6.31"}],

Cell[TextData[{
  "Session on ",
  StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.6", "6.32"}],

Cell[TextData[{
  "This finds an unallocated port on ",
  StyleBox["frog.wolfram.com", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.33"}],

Cell[CellGroupData[{

Cell["link = LinkCreate[ ]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"S2.13.6"],

Cell["LinkObject[\"2981@frog.wolfram.com\", 5, 5]", "Output",
  CellLabel->"Out[8]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "Session on ",
  StyleBox["toad.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.6", "6.34"}],

Cell[TextData[{
  "This connects to the port on ",
  StyleBox["frog.wolfram.com", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.35"}],

Cell[CellGroupData[{

Cell["link = LinkConnect[\"2981@frog.wolfram.com\"]", "Input",
  CellLabel->"In[7]:=",
  CellTags->"S2.13.6"],

Cell["LinkObject[\"2981@frog.wolfram.com\", 5, 5]", "Output",
  CellLabel->"Out[7]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell["This sends the current machine name over the link. ", "MathCaption",
  CellTags->{"S2.13.6", "6.36"}],

Cell["LinkWrite[link, $MachineName]", "Input",
  CellLabel->"In[8]:=",
  CellTags->"S2.13.6"],

Cell[TextData[{
  "Session on ",
  StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.6", "6.37"}],

Cell[TextData[{
  "This reads the expression written on ",
  StyleBox["toad", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.6", "6.38"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[9]:=",
  CellTags->"S2.13.6"],

Cell["toad", "Output",
  CellLabel->"Out[9]=",
  CellTags->"S2.13.6"]
}, Open  ]],

Cell[TextData[{
  "By using internet ports for ",
  StyleBox["MathLink", "TI"],
  " connections, you can easily transfer data between ",
  StyleBox["Mathematica", "TI"],
  " sessions on different machines. All that is needed is that an internet \
connection exists between the machines. "
}], "Text",
  CellTags->{"S2.13.6", "6.39"}],

Cell[TextData[{
  "Note that because ",
  StyleBox["MathLink", "TI"],
  " is completely system independent, the computers at each end of a ",
  StyleBox["MathLink", "TI"],
  " connection do not have to be of the same type. ",
  StyleBox["MathLink", "TI"],
  " nevertheless notices when they are, and optimizes data transmission in \
this case. "
}], "Text",
  CellTags->{"S2.13.6", "6.40"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.7 Calling Subsidiary ",
  StyleBox["Mathematica", "SBO"],
  " Processes"
}], "Subsection",
  CellTags->{"S2.13.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkLaunch[\"", "MR"],
              StyleBox["prog", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "start an external program and open a connection to it "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Connecting to a subsidiary program via ",
  StyleBox["MathLink", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "This starts a subsidiary ",
  StyleBox["Mathematica", "TI"],
  " process on the computer system used here. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.2"}],

Cell[CellGroupData[{

Cell["link = LinkLaunch[\"math -mathlink\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.7"],

Cell["LinkObject[math -mathlink, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "Here is a packet representing the first input prompt from the subsidiary \
",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.3"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.7"],

Cell["InputNamePacket[In[1]:= ]", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "This writes a packet representing text to enter in the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.4"}],

Cell["LinkWrite[link, EnterTextPacket[\"10!\"]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Here is a packet representing the output prompt from the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.5"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.7"],

Cell["OutputNamePacket[Out[1]= ]", "Output",
  CellLabel->"Out[4]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["And here is the actual result from the computation. ", "MathCaption",
  CellTags->{"S2.13.7", "7.6"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.7"],

Cell["ReturnTextPacket[3628800]", "Output",
  CellLabel->"Out[5]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "The basic way that the various different objects involved in a ",
  StyleBox["Mathematica", "TI"],
  " session are kept organized is by using ",
  StyleBox["MathLink", "TI"],
  " ",
  StyleBox["packets", "TI"],
  ". A ",
  StyleBox["MathLink", "TI"],
  " packet is simply an expression with a definite head that indicates its \
role or meaning.  "
}], "Text",
  CellTags->{"S2.13.7", "7.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EnterTextPacket[\"", "MR"],
              StyleBox["input", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text to enter corresponding to an input line "]},
          {Cell[TextData[{
              StyleBox["ReturnTextPacket[\"", "MR"],
              StyleBox["output", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text returned corresponding to an output line "]},
          {Cell[TextData[{
              StyleBox["InputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text returned for the name of an input line "]},
          {Cell[TextData[{
              StyleBox["OutputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["text returned for the name of an output line "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Basic packets used in ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "The fact that ",
  StyleBox["LinkRead", "MR"],
  " returns an ",
  StyleBox["InputNamePacket", "MR"],
  " indicates that the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " is now ready for new input. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.8"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.7"],

Cell["InputNamePacket[In[2]:= ]", "Output",
  CellLabel->"Out[6]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "This enters two ",
  StyleBox["Print", "MR"],
  " commands as input. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.9"}],

Cell["LinkWrite[link, EnterTextPacket[\"Print[a]; Print[b];\"]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Here is the text from the first ",
  StyleBox["Print", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.10"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
TextPacket[a
]\
\>", "Output",
  CellLabel->"Out[8]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "And here is the text from the second ",
  StyleBox["Print", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.11"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
TextPacket[b
]\
\>", "Output",
  CellLabel->"Out[9]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "No output line is generated, so the new packet is an ",
  StyleBox["InputNamePacket", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.12"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.13.7"],

Cell["InputNamePacket[In[3]:= ]", "Output",
  CellLabel->"Out[10]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TextPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "text from ",
              StyleBox["Print", "MR"],
              " etc. "
            }]]},
          {Cell[TextData[{
              StyleBox["MessagePacket[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[", \"", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["a message name "]},
          {Cell[TextData[{
              StyleBox["DisplayPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["parts of PostScript graphics "]},
          {Cell[TextData[{
              StyleBox["DisplayEndPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["the end of PostScript graphics "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Some additional packets generated in ",
  StyleBox["Mathematica", "SO"],
  " sessions. "
}], "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "If you enter input to ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["EnterTextPacket[\"", "MR"],
  StyleBox["input", "TI"],
  StyleBox["\"]", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will automatically generate a string version of your output, and will \
respond with ",
  StyleBox["ReturnTextPacket[\"", "MR"],
  StyleBox["output", "TI"],
  StyleBox["\"]", "MR"],
  ". But if you instead enter input using ",
  StyleBox["EnterExpressionPacket[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " then ",
  StyleBox["Mathematica", "TI"],
  " will respond with ",
  StyleBox["ReturnExpressionPacket[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " and will not turn your output into a string. "
}], "Text",
  CellTags->{"S2.13.7", "7.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EnterExpressionPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "an expression to enter corresponding to an input line "]},
          {Cell[TextData[{
              StyleBox["ReturnExpressionPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "an expression returned corresponding to an output line "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell["\<\
Packets for representing input and output lines using expressions. \
\
\>", "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "This enters an expression into the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session without evaluating it. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.14"}],

Cell["\<\
LinkWrite[link, Unevaluated[EnterExpressionPacket[
    Factor[x^6 - 1]]]]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Here are the next 3 packets that come back from the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.15"}],

Cell[CellGroupData[{

Cell["Table[LinkRead[link], {3}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.13.7"],

Cell[BoxData[
    \({OutputNamePacket["Out[3]="], 
      ReturnExpressionPacket[\((\(-1\) + x)\)\ \((1 + x)\)\ \((1 - x - 
              x\^2)\)\ \((1 + x + x\^2)\)], 
      InputNamePacket["In[4]:="]}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InputNamePacket", "MR"],
  " and ",
  StyleBox["OutputNamePacket", "MR"],
  " packets are often convenient for making it possible totell the current \
state of a subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session. But you can suppress the generation of these packets by calling \
the subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session with a string such as ",
  StyleBox["\"math", "MR"],
  " ",
  StyleBox["-mathlink", "MR"],
  " ",
  StyleBox["-batchoutput\"", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.7", "7.16"}],

Cell[TextData[{
  "Even if you suppress the explicit generation of ",
  StyleBox["InputNamePacket", "MR"],
  " and ",
  StyleBox["OutputNamePacket", "MR"],
  " packets, ",
  StyleBox["Mathematica", "TI"],
  " will still process any input that you give with ",
  StyleBox["EnterTextPacket", "MR"],
  " or ",
  StyleBox["EnterExpressionPacket", "MR"],
  " as if you were entering an input line. This means for example that ",
  StyleBox["Mathematica", "TI"],
  " will call ",
  StyleBox["$Pre", "MR"],
  " and ",
  StyleBox["$Post", "MR"],
  ", and will assign values to ",
  StyleBox["In[$Line]", "MR"],
  " and ",
  StyleBox["Out[$Line]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.13.7", "7.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EvaluatePacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an expression to be sent purely for evaluation "]},
          {Cell[TextData[{
              StyleBox["ReturnPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an expression returned from an evaluation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell["\<\
Evaluating expressions without explicit input and output lines. \
\
\>", "Caption",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "This sends an ",
  StyleBox["EvaluatePacket", "MR"],
  ". The ",
  StyleBox["Unevaluated", "MR"],
  " prevents evaluation before the packet is sent. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.18"}],

Cell["LinkWrite[link, Unevaluated[EvaluatePacket[10!]]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "The result is a pure ",
  StyleBox["ReturnPacket", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.19"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.13.7"],

Cell[BoxData[
    \(ReturnPacket[3628800]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "This sends an ",
  StyleBox["EvaluatePacket", "MR"],
  " requesting evaluation of ",
  StyleBox["Print[x]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.20"}],

Cell["LinkWrite[link, Unevaluated[EvaluatePacket[Print[x]]]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "The first packet to come back is a ",
  StyleBox["TextPacket", "MR"],
  " representing text generated by the ",
  StyleBox["Print", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.21"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
TextPacket[x
]\
\>", "Output",
  CellLabel->"Out[16]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "After that, the actual result of the ",
  StyleBox["Print", "MR"],
  " is returned. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.22"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.13.7"],

Cell["ReturnPacket[Null]", "Output",
  CellLabel->"Out[17]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[TextData[{
  "In most cases, it is reasonable to assume that sending an ",
  StyleBox["EvaluatePacket", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  " will simply cause ",
  StyleBox["Mathematica", "TI"],
  " to do a computation and to return various other packets, ending with a ",
  StyleBox["ReturnPacket", "MR"],
  ". However, if the computation involves a function like ",
  StyleBox["Input", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will have to request additional input before it can proceed with the \
computation. "
}], "Text",
  CellTags->{"S2.13.7", "7.23"}],

Cell[TextData[{
  "This sends a packet whose evaluation involves an ",
  StyleBox["Input", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.24"}],

Cell["\<\
LinkWrite[link,
     Unevaluated[EvaluatePacket[2 + Input[\"data =\"]]]]\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "What comes back is an ",
  StyleBox["InputPacket", "MR"],
  " which indicates that further input is required. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.25"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.13.7"],

Cell["InputPacket[data =]", "Output",
  CellLabel->"Out[19]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["There is nothing more to be read on the link at this point. ", \
"MathCaption",
  CellTags->{"S2.13.7", "7.26"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.13.7"],

Cell["False", "Output",
  CellLabel->"Out[20]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["This enters more input. ", "MathCaption",
  CellTags->{"S2.13.7", "7.27"}],

Cell["LinkWrite[link, EnterTextPacket[\"x + y\"]]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Now the ",
  StyleBox["Input", "MR"],
  " function can be evaluated, and a ",
  StyleBox["ReturnPacket", "MR"],
  " is generated. "
}], "MathCaption",
  CellTags->{"S2.13.7", "7.28"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.13.7"],

Cell["ReturnPacket[2 + x + y]", "Output",
  CellLabel->"Out[22]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LinkInterrupt[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "send an interrupt to a ",
              StyleBox["MathLink", "TI"],
              "\[Hyphen]compatible program "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.7"],

Cell[TextData[{
  "Interrupting a ",
  StyleBox["MathLink", "SO"],
  "\[Hyphen]compatible program. "
}], "Caption",
  CellTags->"S2.13.7"],

Cell["\<\
This sends a very time\[Hyphen]consuming calculation to the \
subsidiary process. \
\>", "MathCaption",
  CellTags->{"S2.13.7", "7.29"}],

Cell["\<\
LinkWrite[link,
       EnterTextPacket[\"FactorInteger[2^777-1]\"]]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.13.7"],

Cell["The calculation is still going on. ", "MathCaption",
  CellTags->{"S2.13.7", "7.30"}],

Cell[CellGroupData[{

Cell["LinkReadyQ[link]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.13.7"],

Cell["False", "Output",
  CellLabel->"Out[24]=",
  CellTags->"S2.13.7"]
}, Open  ]],

Cell["This sends an interrupt. ", "MathCaption",
  CellTags->{"S2.13.7", "7.31"}],

Cell["LinkInterrupt[link]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.13.7"],

Cell["\<\
Now the subsidiary process has stopped, and is sending back an \
interrupt menu. \
\>", "MathCaption",
  CellTags->{"S2.13.7", "7.32"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.13.7"],

Cell["MenuPacket[1, Interrupt> ]", "Output",
  CellLabel->"Out[26]=",
  CellTags->"S2.13.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.8 Special Topic: Communication with ",
  StyleBox["Mathematica", "SBO"],
  " Front Ends"
}], "Subsection",
  CellTags->{"S2.13.8", "8.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " kernel uses ",
  StyleBox["MathLink", "TI"],
  " to communicate with ",
  StyleBox["Mathematica", "TI"],
  " front ends. If you start a ",
  StyleBox["Mathematica", "TI"],
  " kernel from within a front end, therefore, the kernel will be controlled \
through a ",
  StyleBox["MathLink", "TI"],
  " connection to this front end.  "
}], "Text",
  CellTags->{"S2.13.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$ParentLink", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["MathLink", "TI"],
              " connection to use for kernel input and output "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.8"],

Cell["The link to the front end for a particular kernel. ", "Caption",
  CellTags->"S2.13.8"],

Cell[TextData[{
  "The global variable ",
  StyleBox["$ParentLink", "MR"],
  " specifies the ",
  StyleBox["MathLink", "TI"],
  " connection that a particular kernel will use for input and output. "
}], "Text",
  CellTags->{"S2.13.8", "8.3"}],

Cell[TextData[{
  "It is sometimes useful to reset ",
  StyleBox["$ParentLink", "MR"],
  " in the middle of a ",
  StyleBox["Mathematica", "TI"],
  " session, thereby effectively changing the front end to which the kernel \
is connected. "
}], "Text",
  CellTags->{"S2.13.8", "8.4"}],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.8", "8.5"}],

Cell["This creates a link on port 8000. ", "MathCaption",
  CellTags->{"S2.13.8", "8.6"}],

Cell[CellGroupData[{

Cell["link = LinkCreate[\"8000\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.13.8"],

Cell["LinkObject[8000@frog.wolfram.com, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.8"]
}, Open  ]],

Cell["Session B", "SessionLabel",
  CellTags->{"S2.13.8", "8.7"}],

Cell["This connects to the link opened in session A. ", "MathCaption",
  CellTags->{"S2.13.8", "8.8"}],

Cell[CellGroupData[{

Cell["LinkConnect[\"8000\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.13.8"],

Cell["LinkObject[8000@frog.wolfram.com, 4, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.8"]
}, Open  ]],

Cell["\<\
This tells session B that it should use session A as a front end. \
\
\>", "MathCaption",
  CellTags->{"S2.13.8", "8.9"}],

Cell["$ParentLink = %", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.13.8"],

Cell["Session A", "SessionLabel",
  CellTags->{"S2.13.8", "8.10"}],

Cell["\<\
Session A now acts as a front end to session B and gets all output \
from it. \
\>", "MathCaption",
  CellTags->{"S2.13.8", "8.11"}],

Cell[CellGroupData[{

Cell["Table[LinkRead[link], {4}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.13.8"],

Cell["\<\
{ResumePacket[LinkObject[ParentLink, 1, 1]],
 OutputNamePacket[Out[2]= ], ReturnTextPacket[
  LinkObject[8000@frog.wolfram.com, 4, 4]],
 InputNamePacket[In[3]:= ]}\
\>", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.8"]
}, Open  ]],

Cell["This releases session B again. ", "MathCaption",
  CellTags->{"S2.13.8", "8.12"}],

Cell["LinkWrite[link, EnterTextPacket[\"$ParentLink=.\"]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.13.8"],

Cell[TextData[{
  "Much like the ",
  StyleBox["Mathematica", "TI"],
  " kernel, the standard notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " is set up to handle a certain set of ",
  StyleBox["MathLink", "TI"],
  " packets. "
}], "Text",
  CellTags->{"S2.13.8", "8.13"}],

Cell[TextData[{
  "Usually it is best to use functions like ",
  StyleBox["NotebookWrite", "MR"],
  " and ",
  StyleBox["FrontEndExecute", "MR"],
  " if you want to control the ",
  StyleBox["Mathematica", "TI"],
  " front end from the kernel. But in some cases you may find it convenient \
to send packets directly to the front end using ",
  StyleBox["LinkWrite", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.8", "8.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.13.9 Two\[Hyphen]Way Communication with External Programs\
\>", \
"Subsection",
  CellTags->{"S2.13.9", "9.1"}],

Cell[TextData[{
  "When you install a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible external program using ",
  StyleBox["Install", "MR"],
  ", the program is set up to behave somewhat like a simplified ",
  StyleBox["Mathematica", "TI"],
  " kernel. Every time you call a function in the external program, a ",
  StyleBox["CallPacket", "MR"],
  " is sent to the program, and the program responds by sending back a result \
wrapped in a ",
  StyleBox["ReturnPacket", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.9", "9.2"}],

Cell[TextData[{
  "This installs an external program, returning the ",
  StyleBox["LinkObject", "MR"],
  " used for the connection to that program. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.3"}],

Cell[CellGroupData[{

Cell["link = Install[\"bitsprog\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(LinkObject[bitsprog, 4, 4]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["ExternalCall", "MR"],
  " sends a ",
  StyleBox["CallPacket", "MR"],
  " to the external program. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.4"}],

Cell[CellGroupData[{

Cell["?bits", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \("Global`bits"\)], "Print",
  CellTags->"S2.13.9"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(bits[i_Integer] := 
                    ExternalCall[LinkObject["./bitsprog", 13, 7], 
                      CallPacket[0, {i}]]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ bits],
      Editable->False]], "Print",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "You can send the ",
  StyleBox["CallPacket", "MR"],
  " explicitly using ",
  StyleBox["LinkWrite", "MR"],
  ". The first argument of the ",
  StyleBox["CallPacket", "MR"],
  " specifies which function in the external program to call. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.5"}],

Cell["LinkWrite[link, CallPacket[0, {67}]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.13.9"],

Cell[TextData[{
  "Here is the response to the ",
  StyleBox["CallPacket", "MR"],
  " from the external program. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.6"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \({1, 1, 0, 0, 0, 0, 1}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "If you use ",
  StyleBox["Install", "MR"],
  " several times on a single external program, ",
  StyleBox["Mathematica", "TI"],
  " will open several ",
  StyleBox["MathLink", "TI"],
  " connections to the program. Each connection will however always \
correspond to a unique ",
  StyleBox["LinkObject", "MR"],
  ". Note that on some computer systems, you may need to make an explicit \
copy of the file containing the external program in order to be able to call \
it multiple times. "
}], "Text",
  CellTags->{"S2.13.9", "9.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$CurrentLink", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["MathLink", "TI"],
              " connection to the external program currently being run "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.9"],

Cell["\<\
Identifying different instances of a single external program. \
\
\>", "Caption",
  CellTags->"S2.13.9"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.9", "9.8"}],

Cell["\<\
:Begin:
:Function:      addto\
\>", "Program",
  CellTags->{"S2.13.9", "9.9"}],

Cell[TextData[{
  "This gives ",
  StyleBox["$CurrentLink", "MR"],
  " as an argument to ",
  StyleBox["addto", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.9", "9.10"}],

Cell[":Pattern:       addto[$CurrentLink, n_Integer]", "Program",
  CellTags->{"S2.13.9", "9.11"}],

Cell[TextData[{
  ":Arguments:     ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ArgumentTypes: ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "Integer",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n:ReturnType:    Integer\n:End:\n"
}], "Program",
  CellTags->{"S2.13.9", "9.12"}],

Cell[TextData[{
  "This zeros the global variable ",
  StyleBox["counter", "MR"],
  " every time the program is started."
}], "MathCaption",
  CellTags->{"S2.13.9", "9.13"}],

Cell["\<\
int counter = 0;
\
\>", "Program",
  CellTags->{"S2.13.9", "9.14"}],

Cell[TextData[{
  "int addto(int n) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    counter += n;\n    return counter;\n",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
  CellTags->{"S2.13.9", "9.15"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.9", "9.16"}],

Cell[TextData[{
  "This installs one instance of the external program containing ",
  StyleBox["addto", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.17"}],

Cell[CellGroupData[{

Cell["ct1 = Install[\"addtoprog\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(LinkObject[addtoprog, 5, 5]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["This installs another instance. ", "MathCaption",
  CellTags->{"S2.13.9", "9.18"}],

Cell[CellGroupData[{

Cell["ct2 = Install[\"addtoprog\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(LinkObject[addtoprog, 6, 6]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["\<\
This adds 10 to the counter in the first instance of the external \
program. \
\>", "MathCaption",
  CellTags->{"S2.13.9", "9.19"}],

Cell[CellGroupData[{

Cell["addto[ct1, 10]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["\<\
This adds 15 to the counter in the second instance of the external \
program. \
\>", "MathCaption",
  CellTags->{"S2.13.9", "9.20"}],

Cell[CellGroupData[{

Cell["addto[ct2, 15]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(15\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell["This operates on the first instance of the program again. ", \
"MathCaption",
  CellTags->{"S2.13.9", "9.21"}],

Cell[CellGroupData[{

Cell["addto[ct1, 20]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.13.9"],

Cell[BoxData[
    \(30\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.13.9"]
}, Open  ]],

Cell[TextData[{
  "If an external program maintains information about its state then you can \
use different instances of the program to represent different states. ",
  StyleBox["$CurrentLink", "MR"],
  " then provides a way to refer to each instance of the program. "
}], "Text",
  CellTags->{"S2.13.9", "9.22"}],

Cell[TextData[{
  "The value of ",
  StyleBox["$CurrentLink", "MR"],
  " is temporarily set every time a particular instance of the program is \
called, as well as when each instance of the program is first installed. "
}], "Text",
  CellTags->{"S2.13.9", "9.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLEvaluateString(stdlink, \"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\")", "MR"],
              " "
            }]], Cell[TextData[{
              "send input to ",
              StyleBox["Mathematica", "TI"],
              " but return no results "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.9"],

Cell[TextData[{
  "Sending a string for evaluation by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.9"],

Cell[TextData[{
  "The two\[Hyphen]way nature of ",
  StyleBox["MathLink", "TI"],
  " connections allows you not only to have ",
  StyleBox["Mathematica", "TI"],
  " call an external program, but also to have that external program call \
back to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.9", "9.24"}],

Cell[TextData[{
  "In the simplest case, you can use the ",
  StyleBox["MathLink", "TI"],
  " function ",
  StyleBox["MLEvaluateString()", "MR"],
  " to send a string to ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " will evaluate this string, producing whatever effects the string \
specifies, but it will not return any results from the evaluation back to the \
external program. "
}], "Text",
  CellTags->{"S2.13.9", "9.25"}],

Cell[TextData[{
  "To get results back you need explicitly to send an ",
  StyleBox["EvaluatePacket", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  ", and then read the contents of the ",
  StyleBox["ReturnPacket", "MR"],
  " that comes back. "
}], "Text",
  CellTags->{"S2.13.9", "9.26"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.9", "9.27"}],

Cell["...", "Program",
  CellTags->{"S2.13.9", "9.28"}],

Cell[TextData[{
  "This starts an ",
  StyleBox["EvaluatePacket", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.29"}],

Cell["MLPutFunction(stdlink, \"EvaluatePacket\", 1);", "Program",
  CellTags->{"S2.13.9", "9.30"}],

Cell[TextData[{
  "This constructs the expression ",
  StyleBox["Factorial[7]", "MR"],
  " or ",
  StyleBox["7!", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.9", "9.31"}],

Cell["\<\
  MLPutFunction(stdlink, \"Factorial\", 1);
    MLPutInteger(stdlink, 7);\
\>", "Program",
  CellTags->{"S2.13.9", "9.32"}],

Cell["\<\
This specifies that the packet you are constructing is finished. \
\
\>", "MathCaption",
  CellTags->{"S2.13.9", "9.33"}],

Cell["\<\
MLEndPacket(stdlink);
\
\>", "Program",
  CellTags->{"S2.13.9", "9.34"}],

Cell[TextData[{
  "This checks the ",
  StyleBox["ReturnPacket", "MR"],
  " that comes back. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.35"}],

Cell["MLCheckFunction(stdlink, \"ReturnPacket\", &n);", "Program",
  CellTags->{"S2.13.9", "9.36"}],

Cell[TextData[{
  "This extracts the integer result for ",
  StyleBox["7!", "MR"],
  " from the packet. "
}], "MathCaption",
  CellTags->{"S2.13.9", "9.37"}],

Cell["MLGetInteger(stdlink, &ans);", "Program",
  CellTags->{"S2.13.9", "9.38"}],

Cell["...", "Program",
  CellTags->{"S2.13.9", "9.39"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.9", "9.40"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLEndPacket(stdlink)", "MR"],
              " "
            }]], Cell[TextData[{
              "specify that a packet is finished and ready to be sent to ",
              StyleBox["Mathematica", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.9"],

Cell[TextData[{
  "Sending a packet to ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.13.9"],

Cell[TextData[{
  "When you can send ",
  StyleBox["Mathematica", "TI"],
  " an ",
  StyleBox["EvaluatePacket[", "MR"],
  StyleBox["input", "TI"],
  StyleBox["]", "MR"],
  ", it may in general produce many packets in response, but the final packet \
should be ",
  StyleBox["ReturnPacket[", "MR"],
  StyleBox["output", "TI"],
  StyleBox["]", "MR"],
  ". Section\[NonBreakingSpace]",
  ButtonBox["2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  " will discuss how to handle sequences of packets and expressions whose \
structure you do not know in advance. "
}], "Text",
  CellTags->{"S2.13.9", "9.41"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.10 Special Topic: Running Programs on Remote Computers", \
"Subsection",
  CellTags->{"S2.13.10", "10.1"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows you to call an external program from within ",
  StyleBox["Mathematica", "TI"],
  " even when that program is running on a remote computer. Typically, you \
need to start the program directly from the operating system on the remote \
computer. But then you can connect to it using commands within your ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S2.13.10", "10.2"}],

Cell[TextData[{
  "Operating system on ",
  StyleBox["toad.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.10", "10.3"}],

Cell[TextData[{
  "This starts the program ",
  StyleBox["fprog", "MR"],
  " and tells it to create a new link."
}], "MathCaption",
  CellTags->{"S2.13.10", "10.4"}],

Cell[TextData[{
  StyleBox["fprog -linkcreate", "MB"],
  " "
}], "Program",
  CellTags->{"S2.13.10", "10.5"}],

Cell["\<\
The program responds with the specification of the link it has \
created. \
\>", "MathCaption",
  CellTags->{"S2.13.10", "10.6"}],

Cell[TextData[{
  "Link",
  StyleBox[" ", "TR"],
  "created",
  StyleBox[" ", "TR"],
  "on:",
  StyleBox[" ", "TR"],
  "2976@toad.wolfram.com "
}], "Program",
  CellTags->{"S2.13.10", "10.7"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " session on ",
  StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
  CellTags->{"S2.13.10", "10.8"}],

Cell["This connects to the link that has been created. ", "MathCaption",
  CellTags->{"S2.13.10", "10.9"}],

Cell[CellGroupData[{

Cell["Install[LinkConnect[\"2976@toad.wolfram.com\"]]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.10"],

Cell["LinkObject[2976@toad.wolfram.com, 1]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[TextData[{
  "This now executes code in the external program on ",
  StyleBox["toad.wolfram.com", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.10", "10.10"}],

Cell[CellGroupData[{

Cell["f[16]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.10"],

Cell["561243", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[TextData[{
  "External programs that are created using ",
  StyleBox["mcc", "MR"],
  " or ",
  StyleBox["mprep", "MR"],
  " always contain the code that is needed to set up ",
  StyleBox["MathLink", "TI"],
  " connections. If you start such programs directly from your operating \
system, they will prompt you to specify what kind of connection you want. \
Alternatively, if your operating system supports it, you can also give this \
information as a command\[Hyphen]line argument to the external program. "
}], "Text",
  CellTags->{"S2.13.10", "10.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["prog", "TI"],
              StyleBox[" -linkcreate", "MR"],
              " "
            }]], 
            Cell["\<\
operating system command to run a program and have it \
create a link \
\>"]},
          {Cell[TextData[{
              StyleBox["Install[LinkConnect[\"", "MR"],
              StyleBox["port", "TI"],
              StyleBox["@", "MR"],
              StyleBox["host", "TI"],
              StyleBox["\"]]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " command to connect to the external program "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.10"],

Cell["Running an external program on a remote computer. ", "Caption",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.13.11 Special Topic: Running External Programs under a Debugger\
\
\>", "Subsection",
  CellTags->{"S2.13.11", "11.1"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows you to run external programs under whatever debugger is provided \
in your software environment. "
}], "Text",
  CellTags->{"S2.13.11", "11.2"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs are typically set up to take arguments, \
usually on the command line, which specify what ",
  StyleBox["MathLink", "TI"],
  " connections they should use. "
}], "Text",
  CellTags->{"S2.13.11", "11.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["In debugger: "], Cell[TextData[{
              StyleBox["run -linkcreate", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "In ",
              StyleBox["Mathematica", "TI"],
              ": "
            }]], Cell[TextData[{
              StyleBox["Install[LinkConnect[\"", "MR"],
              StyleBox["port", "TI"],
              StyleBox["\"]]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.11"],

Cell["Running an external program under a debugger. ", "Caption",
  CellTags->"S2.13.11"],

Cell[TextData[{
  "Note that in order to get a version of an external program that can be run \
under a debugger, you may need to specify ",
  StyleBox["-g", "MR"],
  " or other flags when you compile the program. "
}], "Text",
  CellTags->{"S2.13.11", "11.4"}],

Cell["Debugger", "SessionLabel",
  CellTags->{"S2.13.11", "11.5"}],

Cell[TextData[{
  "Set a breakpoint in the C function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.11", "11.6"}],

Cell[TextData[{
  StyleBox["break f", "MB"],
  "\nBreakpoint",
  StyleBox[" ", "TR"],
  "set:",
  StyleBox[" ", "TR"],
  "f:",
  StyleBox[" ", "TR"],
  "line",
  StyleBox[" ", "TR"],
  "1 "
}], "Program",
  CellTags->{"S2.13.11", "11.7"}],

Cell["Start the external program.", "MathCaption",
  CellTags->{"S2.13.11", "11.8"}],

Cell[TextData[{
  StyleBox["run -linkcreate", "MB"],
  " "
}], "Program",
  CellTags->{"S2.13.11", "11.9"}],

Cell["The program responds with what port it is listening on.", "MathCaption",
  CellTags->{"S2.13.11", "11.10"}],

Cell[TextData[{
  "Link",
  StyleBox[" ", "TR"],
  "created",
  StyleBox[" ", "TR"],
  "on:",
  StyleBox[" ", "TR"],
  "2981@frog.wolfram.com "
}], "Program",
  CellTags->{"S2.13.11", "11.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " session"
}], "SessionLabel",
  CellTags->{"S2.13.11", "11.12"}],

Cell["This connects to the program running under the debugger. ", \
"MathCaption",
  CellTags->{"S2.13.11", "11.13"}],

Cell[CellGroupData[{

Cell["Install[LinkConnect[\"2981@frog.wolfram.com\"]]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"S2.13.11"],

Cell["LinkObject[2981@frog.wolfram.com, 1]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S2.13.11"]
}, Open  ]],

Cell["\<\
This calls a function which executes code in the external program. \
\
\>", "MathCaption",
  CellTags->{"S2.13.11", "11.14"}],

Cell["f[16]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"S2.13.11"],

Cell["Debugger", "SessionLabel",
  CellTags->{"S2.13.11", "11.15"}],

Cell["The external program stops at the breakpoint. ", "MathCaption",
  CellTags->{"S2.13.11", "11.16"}],

Cell[TextData[{
  "Breakpoint:",
  StyleBox[" ", "TR"],
  "f(16) "
}], "Program",
  CellTags->{"S2.13.11", "11.17"}],

Cell["This tells the debugger to continue.", "MathCaption",
  CellTags->{"S2.13.11", "11.18"}],

Cell[TextData[{
  StyleBox["continue", "MB"],
  " "
}], "Program",
  CellTags->{"S2.13.11", "11.19"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " session"
}], "SessionLabel",
  CellTags->{"S2.13.11", "11.20"}],

Cell[TextData[{
  "Now ",
  StyleBox["f", "MR"],
  " returns. "
}], "MathCaption",
  CellTags->{"S2.13.11", "11.21"}],

Cell["561243", "Output",
  CellLabel->"Out[2]=",
  CellTags->"S2.13.11"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.12 Manipulating Expressions in External Programs", "Subsection",
  CellTags->{"S2.13.12", "12.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " expressions provide a very general way to handle all kinds of data, and \
you may sometimes want to use such expressions inside your external programs. \
A language like C, however, offers no direct way to store general ",
  StyleBox["Mathematica", "TI"],
  " expressions. But it is nevertheless possible to do this by using the ",
  StyleBox["loopback links", "TI"],
  " provided by the ",
  StyleBox["MathLink", "TI"],
  " library. A loopback link is a local ",
  StyleBox["MathLink", "TI"],
  " connection inside your external program, to which you can write \
expressions that can later be read back. "
}], "Text",
  CellTags->{"S2.13.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLINK MLLoopbackOpen(stdenv, long *", "MR"],
              StyleBox["errno", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["open a loopback link "]},
          {Cell[TextData[{
              StyleBox["void MLClose(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["close a link "]},
          {Cell[TextData[{
              StyleBox["int MLTransferExpression(MLINK ", "MR"],
              StyleBox["dest", "TI"],
              StyleBox[", MLINK ", "MR"],
              StyleBox["src", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "get an expression from ",
              StyleBox["src", "TI"],
              " and put it onto ",
              StyleBox["dest", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True}},
  CellTags->"S2.13.12"],

Cell["Functions for manipulating loopback links. ", "Caption",
  CellTags->"S2.13.12"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.3"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.4"}],

Cell["This opens a loopback link. ", "MathCaption",
  CellTags->{"S2.13.12", "12.5"}],

Cell["ml = MLLoopbackOpen(stdenv, &errno);", "Program",
  CellTags->{"S2.13.12", "12.6"}],

Cell[TextData[{
  "This puts the expression ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["3]", "MR"],
  " onto the loopback link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.7"}],

Cell["\<\
MLPutFunction(ml, \"Power\", 2);
  MLPutSymbol(ml, \"x\");
  MLPutInteger(ml, 3);\
\>", "Program",
  CellTags->{"S2.13.12", "12.8"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.9"}],

Cell["This gets the expression back from the loopback link. ", "MathCaption",
  CellTags->{"S2.13.12", "12.10"}],

Cell["\<\
MLGetFunction(ml, &head, &n);
  MLGetSymbol(ml, &sname);
  MLGetInteger(ml, &k);\
\>", "Program",
  CellTags->{"S2.13.12", "12.11"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.12"}],

Cell["This closes the loopback link again. ", "MathCaption",
  CellTags->{"S2.13.12", "12.13"}],

Cell["MLClose(ml);", "Program",
  CellTags->{"S2.13.12", "12.14"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.15"}],

Cell[TextData[{
  "You can use ",
  StyleBox["MLTransferExpression()", "MR"],
  " to take an expression that you get via ",
  StyleBox["stdlink", "MR"],
  " from ",
  StyleBox["Mathematica", "TI"],
  ", and save it in a local loopback link for later processing. "
}], "Text",
  CellTags->{"S2.13.12", "12.16"}],

Cell[TextData[{
  "You can also use ",
  StyleBox["MLTransferExpression()", "MR"],
  " to take an expression that you have built up on a local loopback link, \
and transfer it back to ",
  StyleBox["Mathematica", "TI"],
  " via ",
  StyleBox["stdlink", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.12", "12.17"}],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.18"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.19"}],

Cell[TextData[{
  "This puts ",
  StyleBox["21!", "MR"],
  " onto a local loopback link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.20"}],

Cell["\<\
MLPutFunction(ml, \"Factorial\", 1);
  MLPutInteger(ml, 21);\
\>", "Program",
  CellTags->{"S2.13.12", "12.21"}],

Cell[TextData[{
  "This sends the head ",
  StyleBox["FactorInteger", "MR"],
  " to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.22"}],

Cell["MLPutFunction(stdlink, \"FactorInteger\", 1);", "Program",
  CellTags->{"S2.13.12", "12.23"}],

Cell[TextData[{
  "This transfers the ",
  StyleBox["21!", "MR"],
  " from the loopback link to ",
  StyleBox["stdlink", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.13.12", "12.24"}],

Cell["MLTransferExpression(stdlink, ml);", "Program",
  CellTags->{"S2.13.12", "12.25"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.26"}],

Cell["\<\
You can put any sequence of expressions onto a loopback link. \
Usually you get the expressions off the link in the same order as you put \
them on. \
\>", "Text",
  CellTags->{"S2.13.12", "12.27"}],

Cell[TextData[{
  "And once you have got an expression off the link it is usually no longer \
saved. But by using ",
  StyleBox["MLCreateMark()", "MR"],
  " you can mark a particular position in a sequence of expressions on a \
link, forcing ",
  StyleBox["MathLink", "TI"],
  " to save every expression after the mark so that you can go back to it \
later. "
}], "Text",
  CellTags->{"S2.13.12", "12.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLMARK MLCreateMark(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
create a mark at the current position in a sequence of \
expressions on a link \
\>"]},
          {Cell[TextData[{
              StyleBox["MLSeekMark(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", MLMARK ", "MR"],
              StyleBox["mark", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "go back to a position ",
              StyleBox["n", "TI"],
              " expressions after the specified mark on a link "
            }]]},
          {Cell[TextData[{
              StyleBox["MLDestroyMark(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", MLMARK ", "MR"],
              StyleBox["mark", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["destroy a mark in a link "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.12"],

Cell[TextData[{
  "Setting up marks in ",
  StyleBox["MathLink", "SO"],
  " links. "
}], "Caption",
  CellTags->"S2.13.12"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.29"}],

Cell["...", "Program",
  CellTags->{"S2.13.12", "12.30"}],

Cell[TextData[{
  "This puts the integer ",
  StyleBox["45", "MR"],
  " onto a loopback link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.31"}],

Cell["MLPutInteger(ml, 45);", "Program",
  CellTags->{"S2.13.12", "12.32"}],

Cell[TextData[{
  "This puts ",
  StyleBox["33", "MR"],
  " onto the link. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.33"}],

Cell["MLPutInteger(ml, 33);", "Program",
  CellTags->{"S2.13.12", "12.34"}],

Cell[TextData[{
  "And this puts ",
  StyleBox["76", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.35"}],

Cell["\<\
MLPutInteger(ml, 76);
\
\>", "Program",
  CellTags->{"S2.13.12", "12.36"}],

Cell[TextData[{
  "This will read ",
  StyleBox["45", "MR"],
  " from the link. The ",
  StyleBox["45", "MR"],
  " will no longer be saved. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.37"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.38"}],

Cell["This creates a mark at the current position on the link. ", \
"MathCaption",
  CellTags->{"S2.13.12", "12.39"}],

Cell["mark = MLCreateMark(ml);", "Program",
  CellTags->{"S2.13.12", "12.40"}],

Cell[TextData[{
  "This will now read ",
  StyleBox["33", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.41"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.42"}],

Cell[TextData[{
  "And this will read ",
  StyleBox["76", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.43"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.44"}],

Cell["This goes back to the position of the mark. ", "MathCaption",
  CellTags->{"S2.13.12", "12.45"}],

Cell["MLSeekMark(ml, mark, 0);", "Program",
  CellTags->{"S2.13.12", "12.46"}],

Cell[TextData[{
  "Now this will read ",
  StyleBox["33", "MR"],
  " again. "
}], "MathCaption",
  CellTags->{"S2.13.12", "12.47"}],

Cell["MLGetInteger(ml, &i);", "Program",
  CellTags->{"S2.13.12", "12.48"}],

Cell["\<\
It is important to destroy marks when you have finished with them, \
so no unnecessary expressions will be saved.\
\>", "MathCaption",
  CellTags->{"S2.13.12", "12.49"}],

Cell["MLDestroyMark(ml, mark);", "Program",
  CellTags->{"S2.13.12", "12.50"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.51"}],

Cell[TextData[{
  "The way the ",
  StyleBox["MathLink", "TI"],
  " library is implemented, it is very efficient to open and close loopback \
links, and to create and destroy marks in them. The only point to remember is \
that as soon as you create a mark on a particular link, ",
  StyleBox["MathLink", "TI"],
  " will save subsequent expressions that are put on that link, and will go \
on doing this until the mark is destroyed. "
}], "Text",
  CellTags->{"S2.13.12", "12.52"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int MLGetNext(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["find the type of the next object on a link "]},
          {Cell[TextData[{
              StyleBox["int MLGetArgCount(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "store in ",
              StyleBox["n", "TI"],
              " the number of arguments for a function on a link "
            }]]},
          {Cell[TextData[{
              StyleBox["int MLGetSymbol(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", char **", "MR"],
              StyleBox["name", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get the name of a symbol "]},
          {Cell[TextData[{
              StyleBox["int MLGetInteger(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", int *", "MR"],
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a machine integer "]},
          {Cell[TextData[{
              StyleBox["int MLGetReal(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", double *", "MR"],
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
get a machine floating\[Hyphen]point number \
\>"]},
          {Cell[TextData[{
              StyleBox["int MLGetString(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", char **", "MR"],
              StyleBox["string", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["get a character string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, True, False}},
  CellTags->"S2.13.12"],

Cell["Functions for getting pieces of expressions from a link. ", "Caption",
  CellTags->"S2.13.12"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLTKFUNC", "MR"],
              " "
            }]], 
            Cell["\<\
composite function\[LongDash]head and arguments \
\
\>"]},
          {Cell[TextData[{
              StyleBox["MLTKSYM", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " symbol "
            }]]},
          {Cell[TextData[{
              StyleBox["MLTKINT", "MR"],
              " "
            }]], Cell["integer "]},
          {Cell[TextData[{
              StyleBox["MLTKREAL", "MR"],
              " "
            }]], Cell["floating\[Hyphen]point number "]},
          {Cell[TextData[{
              StyleBox["MLTKSTR", "MR"],
              " "
            }]], Cell["character string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.13.12"],

Cell[TextData[{
  "Constants returned by ",
  StyleBox["MLGetNext()", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.13.12"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.12", "12.53"}],

Cell["switch(MLGetNext(ml)) {", "Program",
  CellTags->{"S2.13.12", "12.54"}],

Cell["This reads a composite function. ", "MathCaption",
  CellTags->{"S2.13.12", "12.55"}],

Cell[TextData[{
  "    case MLTKFUNC:\n    MLGetArgCount(ml, &n);\n    ",
  StyleBox[" recurse for head", "MO"],
  "\n    for (i = 0; i < n; i++) ",
  Cell[BoxData[
      FormBox[
        StyleBox["{",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n        ",
  StyleBox[" recurse for each argument", "MO"],
  "\n    ",
  Cell[BoxData[
      FormBox[
        StyleBox["}",
          "TR"], TraditionalForm]], "InlineFormula"],
  "\n    \[Ellipsis] "
}], "Program",
  CellTags->{"S2.13.12", "12.56"}],

Cell["This reads a single symbol. ", "MathCaption",
  CellTags->{"S2.13.12", "12.57"}],

Cell["\<\
    case MLTKSYM:
    MLGetSymbol(ml, &name);
    \[Ellipsis] \
\>", "Program",
  CellTags->{"S2.13.12", "12.58"}],

Cell["This reads a machine integer. ", "MathCaption",
  CellTags->{"S2.13.12", "12.59"}],

Cell["\<\
    case MLTKINT:
    MLGetInteger(ml, &i);
    \[Ellipsis] \
\>", "Program",
  CellTags->{"S2.13.12", "12.60"}],

Cell["}", "Program",
  CellTags->{"S2.13.12", "12.61"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.12", "12.62"}],

Cell[TextData[{
  "By using ",
  StyleBox["MLGetNext()", "MR"],
  " it is straightforward to write programs that can read any expression. The \
way ",
  StyleBox["MathLink", "TI"],
  " works, the head and arguments of a function appear as successive \
expressions on the link, which you read one after another. "
}], "Text",
  CellTags->{"S2.13.12", "12.63"}],

Cell[TextData[{
  "Note that if you know that the head of a function will be a symbol, then \
you can use ",
  StyleBox["MLGetFunction()", "MR"],
  " instead of ",
  StyleBox["MLGetNext()", "MR"],
  ". In this case, however, you still need to call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown the memory used to store the symbol name. "
}], "Text",
  CellTags->{"S2.13.12", "12.64"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int MLPutNext(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", int ", "MR"],
              StyleBox["type", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "prepare to put an object of the specified type on a link "]},
          {Cell[TextData[{
              StyleBox["int MLPutArgCount(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", long ", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "give the number of arguments for a composite function "]},
          {Cell[TextData[{
              StyleBox["int MLPutSymbol(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", char *", "MR"],
              StyleBox["name", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a symbol on the link "]},
          {Cell[TextData[{
              StyleBox["int MLPutInteger(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", int ", "MR"],
              StyleBox["i", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a machine integer "]},
          {Cell[TextData[{
              StyleBox["int MLPutReal(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", double ", "MR"],
              StyleBox["x", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
put a machine floating\[Hyphen]point number \
\>"]},
          {Cell[TextData[{
              StyleBox["int MLPutString(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[", char *", "MR"],
              StyleBox["string", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["put a character string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, True, False}},
  CellTags->"S2.13.12"],

Cell["Functions for putting pieces of expressions onto a link. ", "Caption",
  CellTags->"S2.13.12"],

Cell[TextData[{
  StyleBox["MLPutNext()", "MR"],
  " specifies types of expressions using constants such as ",
  StyleBox["MLTKFUNC", "MR"],
  " from the ",
  StyleBox["mathlink.h", "MR"],
  " header file\[LongDash]just like ",
  StyleBox["MLGetNext()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.12", "12.65"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.13.13 Advanced Topic: Error and Interrupt Handling", "Subsection",
  CellTags->{"S2.13.13", "13.1"}],

Cell[TextData[{
  "When you are putting and getting data via ",
  StyleBox["MathLink", "TI"],
  " various kinds of errors can occur. Whenever any error occurs, ",
  StyleBox["MathLink", "TI"],
  " goes into a completely inactive state, and all ",
  StyleBox["MathLink", "TI"],
  " functions you call will return 0 immediately.  "
}], "Text",
  CellTags->{"S2.13.13", "13.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["long MLError(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "return a number identifying the current error, or ",
              StyleBox["0", "MR"],
              " if none has occurred "
            }]]},
          {Cell[TextData[{
              StyleBox["char *MLErrorMessage(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "return a character string describing the current error "]},
          {Cell[TextData[{
              StyleBox["int MLClearError(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "clear the current error, returning ",
              StyleBox["MathLink", "TI"],
              " if possible to an active state "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True}},
  CellTags->"S2.13.13"],

Cell[TextData[{
  "Handling errors in ",
  StyleBox["MathLink", "SO"],
  " programs. "
}], "Caption",
  CellTags->"S2.13.13"],

Cell[TextData[{
  "When you do complicated operations, it is often convenient to check for \
errors only at the end. If you find that an error occurred, you must then \
call ",
  StyleBox["MLClearError()", "MR"],
  " to activate ",
  StyleBox["MathLink", "TI"],
  " again. "
}], "Text",
  CellTags->{"S2.13.13", "13.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int MLNewPacket(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["skip to the end of the current packet "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.13"],

Cell["Clearing out the remains of a packet. ", "Caption",
  CellTags->"S2.13.13"],

Cell[TextData[{
  "After an error, it is common to want to discard the remainder of the \
packet or expression that you are currently processing. You can do this using \
",
  StyleBox["MLNewPacket()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.13", "13.4"}],

Cell[TextData[{
  "In some cases, you may want to set it up so that if an error occurs while \
you are processing particular data, you can then later go back and reprocess \
the data in a different way. You can do this by calling ",
  StyleBox["MLCreateMark()", "MR"],
  " to create a mark before you first process the data, and then calling ",
  StyleBox["MLSeekMark()", "MR"],
  " to seek back to the mark if you need to reprocess the data. You should \
not forgot to call ",
  StyleBox["MLDestroyMark()", "MR"],
  " when you have finally finished with the data\[LongDash]otherwise ",
  StyleBox["MathLink", "TI"],
  " will continue to store it. "
}], "Text",
  CellTags->{"S2.13.13", "13.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int", "MR"],
              " ",
              StyleBox["MLAbort", "MR"],
              " "
            }]], Cell[TextData[{
              "a global variable set when a program set up by ",
              StyleBox["Install", "MR"],
              " is sent an abort interrupt "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.13"],

Cell["Aborting an external program. ", "Caption",
  CellTags->"S2.13.13"],

Cell[TextData[{
  "If you interrupt ",
  StyleBox["Mathematica", "TI"],
  " while it is in the middle of executing an external function, it will \
typically give you the opportunity to try to abort the external function. If \
you choose to do this, what will happen is that the global variable ",
  StyleBox["MLAbort", "MR"],
  " will be set to ",
  StyleBox["1", "MR"],
  " inside your external program. "
}], "Text",
  CellTags->{"S2.13.13", "13.6"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " cannot automatically back out of an external function call that has been \
made. So if you have a function that can take a long time, you should \
explicitly check ",
  StyleBox["MLAbort", "MR"],
  " every so often, returning from the function if you find that the variable \
has been set. "
}], "Text",
  CellTags->{"S2.13.13", "13.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.13.14 Running ",
  StyleBox["Mathematica", "SBO"],
  " from Within an External Program"
}], "Subsection",
  CellTags->{"S2.13.14", "14.1"}],

Cell[TextData[{
  "To run ",
  StyleBox["Mathematica", "TI"],
  " from within an external program requires making use of many general \
features of ",
  StyleBox["MathLink", "TI"],
  ". The first issue is how to establish a ",
  StyleBox["MathLink", "TI"],
  " connection to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.2"}],

Cell[TextData[{
  "When you use ",
  StyleBox["MathLink", "TI"],
  " templates to create external programs that can be called from ",
  StyleBox["Mathematica", "TI"],
  ", source code to establish a ",
  StyleBox["MathLink", "TI"],
  " connection is automatically generated, and all you have to do in your \
external program is to call ",
  StyleBox["MLMain(", "MR"],
  StyleBox["argc", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["argv", "TI"],
  StyleBox[")", "MR"],
  ". But in general you need to call several functions to establish a ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Text",
  CellTags->{"S2.13.14", "14.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLENV MLInitialize(0)", "MR"],
              " "
            }]], Cell[TextData[{
              "initialize ",
              StyleBox["MathLink", "TI"],
              " library functions "
            }]]},
          {Cell[TextData[{
              StyleBox["MLINK MLOpenArgv(MLENV ", "MR"],
              StyleBox["env", "TI"],
              StyleBox[", char **", "MR"],
              StyleBox["argv0", "TI"],
              StyleBox[", char **", "MR"],
              StyleBox["argv1", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["errno", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "open a ",
              StyleBox["MathLink", "TI"],
              " connection taking parameters from an ",
              StyleBox["argv", "MR"],
              " array "
            }]]},
          {Cell[TextData[{
              StyleBox["MLINK MLOpenString(MLENV ", "MR"],
              StyleBox["env", "TI"],
              StyleBox[", char *", "MR"],
              StyleBox["string", "TI"],
              StyleBox[", long *", "MR"],
              StyleBox["errno", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "open a ",
              StyleBox["MathLink", "TI"],
              " connection taking parameters from a single character string "
            }]]},
          {Cell[TextData[{
              StyleBox["int MLActivate(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "activate a ",
              StyleBox["MathLink", "TI"],
              
              " connection, waiting for the program at the other end to \
respond "
            }]]},
          {Cell[TextData[{
              StyleBox["void MLClose(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "close a ",
              StyleBox["MathLink", "TI"],
              " connection "
            }]]},
          {Cell[TextData[{
              StyleBox["void MLDeinitialize(MLENV ", "MR"],
              StyleBox["env", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "deinitialize ",
              StyleBox["MathLink", "TI"],
              " library functions "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, True, False}},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Opening and closing ",
  StyleBox["MathLink", "SO"],
  " connections. "
}], "Caption",
  CellTags->"S2.13.14"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.14", "14.4"}],

Cell[TextData[{
  "Include the standard ",
  StyleBox["MathLink", "TI"],
  " header file. "
}], "MathCaption",
  CellTags->{"S2.13.14", "14.5"}],

Cell["\<\
#include \"mathlink.h\"
\
\>", "Program",
  CellTags->{"S2.13.14", "14.6"}],

Cell["int main(int argc, char *argv[]) {", "Program",
  CellTags->{"S2.13.14", "14.7"}],

Cell["\<\
   MLENV env;
   MLINK link;
   long errno;
\
\>", "Program",
  CellTags->{"S2.13.14", "14.8"}],

Cell[TextData[{
  "This initializes ",
  StyleBox["MathLink", "TI"],
  " library functions. "
}], "MathCaption",
  CellTags->{"S2.13.14", "14.9"}],

Cell["   env = MLInitialize(0);", "Program",
  CellTags->{"S2.13.14", "14.10"}],

Cell[TextData[{
  "This opens a ",
  StyleBox["MathLink", "TI"],
  " connection, using the same arguments as were passed to the main program. \
"
}], "MathCaption",
  CellTags->{"S2.13.14", "14.11"}],

Cell["   link = MLOpenArgv(env, argv, argv+argc, &errno);", "Program",
  CellTags->{"S2.13.14", "14.12"}],

Cell["\<\
This activates the connection, waiting for the other program to \
respond.\
\>", "MathCaption",
  CellTags->{"S2.13.14", "14.13"}],

Cell["   MLActivate(link);", "Program",
  CellTags->{"S2.13.14", "14.14"}],

Cell["\<\
   ...
}\
\>", "Program",
  CellTags->{"S2.13.14", "14.15"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.14", "14.16"}],

Cell[TextData[{
  "Often the ",
  StyleBox["argv", "MR"],
  " that you pass to ",
  StyleBox["MLOpenArgv()", "MR"],
  " will come directly from the ",
  StyleBox["argv", "MR"],
  " that is passed to ",
  StyleBox["main()", "MR"],
  " when your whole program is started. Note that ",
  StyleBox["MLOpenArgv()", "MR"],
  " takes pointers to the beginning and end of the ",
  StyleBox["argv", "MR"],
  " array. By not using ",
  StyleBox["argc", "MR"],
  " directly it avoids having to know the size of an ",
  StyleBox["int", "MR"],
  ".   "
}], "Text",
  CellTags->{"S2.13.14", "14.17"}],

Cell[TextData[{
  "The elements in the ",
  StyleBox["argv", "MR"],
  " array are character strings which mirror the arguments and options used \
in the ",
  StyleBox["Mathematica", "TI"],
  " functions ",
  StyleBox["LinkLaunch", "MR"],
  ", ",
  StyleBox["LinkCreate", "MR"],
  " and ",
  StyleBox["LinkConnect", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"-linklaunch\"", "MR"],
              " "
            }]], Cell[TextData[{
              "operate like ",
              StyleBox["LinkLaunch[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkcreate\"", "MR"],
              " "
            }]], Cell[TextData[{
              "operate like ",
              StyleBox["LinkCreate[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkconnect\"", "MR"],
              " "
            }]], Cell[TextData[{
              "operate like ",
              StyleBox["LinkConnect[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkname\", \"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["give the name to use "]},
          {Cell[TextData[{
              StyleBox["\"-linkprotocol\", \"", "MR"],
              StyleBox["protocol", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "give the link protocol to use (",
              StyleBox["tcp", "MR"],
              ", ",
              StyleBox["pipes", "MR"],
              ", etc.) "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True}},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Possible elements of the ",
  StyleBox["argv", "MR"],
  " array passed to ",
  StyleBox["MLOpenArgv()", "MR"],
  "."
}], "Caption",
  CellTags->"S2.13.14"],

Cell[TextData[{
  "As an alternative to ",
  StyleBox["MLOpenArgv()", "MR"],
  " you can use ",
  StyleBox["MLOpenString()", "MR"],
  ", which takes parameters concatenated into a single character string with \
spaces in between. "
}], "Text",
  CellTags->{"S2.13.14", "14.19"}],

Cell[TextData[{
  "Once you have successfully opened a ",
  StyleBox["MathLink", "TI"],
  " connection to the ",
  StyleBox["Mathematica", "TI"],
  " kernel, you can then use standard ",
  StyleBox["MathLink", "TI"],
  " functions to exchange data with it. "
}], "Text",
  CellTags->{"S2.13.14", "14.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int MLEndPacket(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["indicate the end of a packet "]},
          {Cell[TextData[{
              StyleBox["int MLNextPacket(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["find the head of the next packet "]},
          {Cell[TextData[{
              StyleBox["int MLNewPacket(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["skip to the end of the current packet "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Functions often used in communicating with the ",
  StyleBox["Mathematica", "SO"],
  " kernel. "
}], "Caption",
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Once you have sent all the pieces of a packet using ",
  StyleBox["MLPutFunction()", "MR"],
  " etc., ",
  StyleBox["MathLink", "TI"],
  " requires you to call ",
  StyleBox["MLEndPacket()", "MR"],
  " to ensure synchronization and consistency. "
}], "Text",
  CellTags->{"S2.13.14", "14.21"}],

Cell[TextData[{
  "One of the main issues in writing an external program which communicates \
directly with the ",
  StyleBox["Mathematica", "TI"],
  " kernel is handling all the various kinds of packets that the kernel can \
generate. "
}], "Text",
  CellTags->{"S2.13.14", "14.22"}],

Cell[TextData[{
  "The function ",
  StyleBox["MLNextPacket()", "MR"],
  " finds the head of the next packet that comes from the kernel, and returns \
a constant that indicates the type of the packet. "
}], "Text",
  CellTags->{"S2.13.14", "14.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              StyleBox[" packet", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["constant", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ReturnPacket[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["RETURNPKT", "MR"],
              " "
            }]], Cell["result from a computation "]},
          {Cell[TextData[{
              StyleBox["ReturnTextPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["RETURNTEXTPKT", "MR"],
              " "
            }]], Cell["textual form of a result "]},
          {Cell[TextData[{
              StyleBox["InputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["INPUTNAMEPKT", "MR"],
              " "
            }]], Cell["name of an input line "]},
          {Cell[TextData[{
              StyleBox["OutputNamePacket[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["OUTPUTNAMEPKT", "MR"],
              " "
            }]], Cell["name of an output line "]},
          {Cell[TextData[{
              StyleBox["TextPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["TEXTPKT", "MR"],
              " "
            }]], Cell[TextData[{
              "textual output from functions like ",
              StyleBox["Print", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MessagePacket[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox[", \"", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["MESSAGEPKT", "MR"],
              " "
            }]], Cell[TextData[{
              "name of a message generated by ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["DisplayPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["DISPLAYPKT", "MR"],
              " "
            }]], Cell["part of PostScript graphics "]},
          {Cell[TextData[{
              StyleBox["DisplayEndPacket[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["DISPLAYENDPKT", "MR"],
              " "
            }]], Cell["end of PostScript graphics "]},
          {Cell[TextData[{
              StyleBox["InputPacket[\"", "MR"],
              StyleBox["prompt", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["INPUTPKT", "MR"],
              " "
            }]], Cell[TextData[{
              "request for a response to an ",
              StyleBox["Input", "MR"],
              " function "
            }]]},
          {Cell[TextData[{
              StyleBox["CallPacket[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[", ", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["CALLPKT", "MR"],
              " "
            }]], Cell["request for a call to an external function "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, False, False, False, True, False}},
  CellTags->"S2.13.14"],

Cell[TextData[{
  "Some packets recognized by ",
  StyleBox["MLNextPacket()", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.13.14"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.13.14", "14.24"}],

Cell[TextData[{
  "This keeps on reading data from a link, discarding it until an error or a \
",
  StyleBox["ReturnPacket", "MR"],
  " is found. "
}], "MathCaption",
  CellTags->{"S2.13.14", "14.25"}],

Cell["\<\
while ((p = MLNextPacket(link)) && p != RETURNPKT)
    MLNewPacket(link);\
\>", "Program",
  CellTags->{"S2.13.14", "14.26"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.13.14", "14.27"}],

Cell[TextData[{
  "If you want to write a complete front end to ",
  StyleBox["Mathematica", "TI"],
  ", you will need to handle all of the possible types of packets that the \
kernel can generate. Typically you can do this by setting up an appropriate \
",
  StyleBox["switch", "MR"],
  " on the value returned by ",
  StyleBox["MLNextPacket()", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.28"}],

Cell[TextData[{
  "The ",
  StyleBox["MathLink", "TI"],
  " Developer Kit contains sample source code for several simple but complete \
front ends. "
}], "Text",
  CellTags->{"S2.13.14", "14.29"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["int MLReady(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[
            "test whether there is data waiting to be read on a link "]},
          {Cell[TextData[{
              StyleBox["int MLFlush(MLINK ", "MR"],
              StyleBox["link", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], 
            Cell["\<\
flush out buffers containing data waiting to be sent on \
a link\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.13.14"],

Cell["Flow of data on links. ", "Caption",
  CellTags->"S2.13.14"],

Cell[TextData[{
  "One feature of more sophisticated external programs such as front ends is \
that they may need to perform operations while they are waiting for data to \
be sent to them by ",
  StyleBox["Mathematica", "TI"],
  ". When you call a standard ",
  StyleBox["MathLink", "TI"],
  " library function such as ",
  StyleBox["MLNextPacket()", "MR"],
  " your program will normally block until all the data needed by this \
function is available.   "
}], "Text",
  CellTags->{"S2.13.14", "14.30"}],

Cell[TextData[{
  "You can avoid blocking by repeatedly calling ",
  StyleBox["MLReady()", "MR"],
  ", and only calling functions like ",
  StyleBox["MLNextPacket()", "MR"],
  " when ",
  StyleBox["MLReady()", "MR"],
  " no longer returns ",
  StyleBox["0", "MR"],
  ". ",
  StyleBox["MLReady()", "MR"],
  " is the analog of the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["LinkReadyQ", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.13.14", "14.31"}],

Cell[TextData[{
  "Note that ",
  StyleBox["MathLink", "TI"],
  " sometimes buffers the data that you tell it to send. To make sure that \
all necessary data has been sent you should call ",
  StyleBox["MLFlush()", "MR"],
  ". Only after doing this does it make sense to call ",
  StyleBox["MLReady()", "MR"],
  " and wait for data to be sent back. "
}], "Text",
  CellTags->{"S2.13.14", "14.32"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.13.0"->{
    Cell[1776, 53, 171, 5, 70, "Section",
      CellTags->{"S2.13.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 171, 5, 70, "Section",
      CellTags->{"S2.13.0", "0.1"}]},
  "S2.13.1"->{
    Cell[1972, 62, 126, 5, 70, "Subsection",
      CellTags->{"S2.13.1", "1.1"}],
    Cell[2101, 69, 368, 11, 70, "Text",
      CellTags->{"S2.13.1", "1.2"}],
    Cell[2472, 82, 1172, 33, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[3647, 117, 117, 5, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[3767, 124, 354, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.3"}],
    Cell[4124, 134, 315, 9, 70, "Text",
      CellTags->{"S2.13.1", "1.4"}],
    Cell[4442, 145, 242, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.5"}],
    Cell[4687, 155, 193, 5, 70, "Text",
      CellTags->{"S2.13.1", "1.6"}],
    Cell[4883, 162, 850, 28, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[5736, 192, 138, 5, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[5877, 199, 565, 14, 70, "Text",
      CellTags->{"S2.13.1", "1.7"}],
    Cell[6445, 215, 462, 13, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[6910, 230, 114, 5, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[7027, 237, 420, 12, 70, "Text",
      CellTags->{"S2.13.1", "1.8"}],
    Cell[7450, 251, 727, 20, 70, "FramedBox",
      CellTags->"S2.13.1"],
    Cell[8180, 273, 189, 7, 70, "Caption",
      CellTags->"S2.13.1"],
    Cell[8372, 282, 255, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.9"}],
    Cell[8630, 292, 309, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.10"}],
    Cell[8942, 301, 292, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.11"}]},
  "1.1"->{
    Cell[1972, 62, 126, 5, 70, "Subsection",
      CellTags->{"S2.13.1", "1.1"}]},
  "1.2"->{
    Cell[2101, 69, 368, 11, 70, "Text",
      CellTags->{"S2.13.1", "1.2"}]},
  "1.3"->{
    Cell[3767, 124, 354, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.3"}]},
  "1.4"->{
    Cell[4124, 134, 315, 9, 70, "Text",
      CellTags->{"S2.13.1", "1.4"}]},
  "1.5"->{
    Cell[4442, 145, 242, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.5"}]},
  "1.6"->{
    Cell[4687, 155, 193, 5, 70, "Text",
      CellTags->{"S2.13.1", "1.6"}]},
  "1.7"->{
    Cell[5877, 199, 565, 14, 70, "Text",
      CellTags->{"S2.13.1", "1.7"}]},
  "1.8"->{
    Cell[7027, 237, 420, 12, 70, "Text",
      CellTags->{"S2.13.1", "1.8"}]},
  "1.9"->{
    Cell[8372, 282, 255, 8, 70, "Text",
      CellTags->{"S2.13.1", "1.9"}]},
  "1.10"->{
    Cell[8630, 292, 309, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.10"}]},
  "1.11"->{
    Cell[8942, 301, 292, 7, 70, "Text",
      CellTags->{"S2.13.1", "1.11"}]},
  "S2.13.2"->{
    Cell[9271, 313, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.2", "2.1"}],
    Cell[9436, 320, 455, 11, 70, "Text",
      CellTags->{"S2.13.2", "2.2"}],
    Cell[9894, 333, 756, 22, 70, "DefinitionBox",
      CellTags->"S2.13.2"],
    Cell[10653, 357, 168, 5, 70, "Caption",
      CellTags->"S2.13.2"],
    Cell[10824, 364, 204, 7, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.3"}],
    Cell[11053, 375, 85, 2, 70, "Input",
      CellTags->"S2.13.2"],
    Cell[11141, 379, 111, 3, 70, "Output",
      CellTags->"S2.13.2"],
    Cell[11267, 385, 170, 6, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.4"}],
    Cell[11462, 395, 81, 2, 70, "Input",
      CellTags->"S2.13.2"],
    Cell[11546, 399, 84, 3, 70, "Output",
      CellTags->"S2.13.2"],
    Cell[11645, 405, 163, 5, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.5"}],
    Cell[11833, 414, 101, 2, 70, "Input",
      CellTags->"S2.13.2"],
    Cell[11937, 418, 105, 3, 70, "Output",
      CellTags->"S2.13.2"],
    Cell[12057, 424, 317, 7, 70, "Text",
      CellTags->{"S2.13.2", "2.6"}],
    Cell[12377, 433, 536, 13, 70, "Text",
      CellTags->{"S2.13.2", "2.7"}],
    Cell[12916, 448, 464, 14, 70, "DefinitionBox",
      CellTags->"S2.13.2"],
    Cell[13383, 464, 94, 1, 70, "Caption",
      CellTags->"S2.13.2"],
    Cell[13480, 467, 974, 30, 70, "Text",
      CellTags->{"S2.13.2", "2.8"}]},
  "2.1"->{
    Cell[9271, 313, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.2", "2.1"}]},
  "2.2"->{
    Cell[9436, 320, 455, 11, 70, "Text",
      CellTags->{"S2.13.2", "2.2"}]},
  "2.3"->{
    Cell[10824, 364, 204, 7, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.3"}]},
  "2.4"->{
    Cell[11267, 385, 170, 6, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.4"}]},
  "2.5"->{
    Cell[11645, 405, 163, 5, 70, "MathCaption",
      CellTags->{"S2.13.2", "2.5"}]},
  "2.6"->{
    Cell[12057, 424, 317, 7, 70, "Text",
      CellTags->{"S2.13.2", "2.6"}]},
  "2.7"->{
    Cell[12377, 433, 536, 13, 70, "Text",
      CellTags->{"S2.13.2", "2.7"}]},
  "2.8"->{
    Cell[13480, 467, 974, 30, 70, "Text",
      CellTags->{"S2.13.2", "2.8"}]},
  "S2.13.3"->{
    Cell[14491, 502, 159, 4, 70, "Subsection",
      CellTags->{"S2.13.3", "3.1"}],
    Cell[14653, 508, 393, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.2"}],
    Cell[15049, 519, 253, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.3"}],
    Cell[15305, 529, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.4"}],
    Cell[15363, 532, 212, 9, 70, "Program",
      CellTags->{"S2.13.3", "3.5"}],
    Cell[15578, 543, 84, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.6"}],
    Cell[15665, 546, 212, 9, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[15880, 557, 1622, 41, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[17505, 600, 123, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[17631, 607, 513, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.7"}],
    Cell[18147, 621, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.8"}],
    Cell[18205, 624, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.9"}],
    Cell[18350, 631, 84, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.10"}],
    Cell[18437, 637, 150, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.11"}],
    Cell[18590, 644, 326, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.12"}],
    Cell[18919, 658, 181, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.13"}],
    Cell[19103, 665, 354, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.14"}],
    Cell[19460, 679, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.15"}],
    Cell[19522, 682, 123, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[19648, 689, 335, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.16"}],
    Cell[19986, 700, 689, 22, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[20678, 724, 150, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[20831, 731, 321, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.17"}],
    Cell[21155, 741, 353, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.18"}],
    Cell[21511, 751, 545, 17, 70, "Text",
      CellTags->{"S2.13.3", "3.19"}],
    Cell[22059, 770, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.20"}],
    Cell[22118, 773, 222, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.21"}],
    Cell[22343, 782, 73, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.22"}],
    Cell[22419, 785, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.23"}],
    Cell[22481, 788, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.24"}],
    Cell[22667, 797, 83, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[22753, 801, 107, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[22875, 807, 388, 17, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.25"}],
    Cell[23288, 828, 72, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[23363, 832, 84, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[23462, 838, 151, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.26"}],
    Cell[23638, 846, 77, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[23718, 850, 97, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[23830, 856, 461, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.27"}],
    Cell[24294, 870, 1453, 41, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[25750, 913, 79, 1, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[25832, 916, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.28"}],
    Cell[25999, 925, 81, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[26083, 929, 111, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[26209, 935, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.29"}],
    Cell[26408, 944, 85, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[26496, 948, 158, 5, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[26669, 956, 237, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.30"}],
    Cell[26931, 968, 67, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[27001, 972, 66, 2, 70, "Print",
      CellTags->"S2.13.3"],
    Cell[27070, 976, 536, 15, 70, "Print",
      CellTags->"S2.13.3"],
    Cell[27621, 994, 671, 20, 70, "Text",
      CellTags->{"S2.13.3", "3.31"}],
    Cell[28295, 1016, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.32"}],
    Cell[28354, 1019, 59, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.33"}],
    Cell[28416, 1022, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.34"}],
    Cell[28562, 1028, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.35"}],
    Cell[28641, 1031, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.36"}],
    Cell[28819, 1038, 99, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.37"}],
    Cell[28921, 1041, 166, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.38"}],
    Cell[29090, 1047, 330, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.39"}],
    Cell[29423, 1061, 147, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.40"}],
    Cell[29573, 1067, 320, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.41"}],
    Cell[29896, 1081, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.42"}],
    Cell[30041, 1087, 75, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.43"}],
    Cell[30119, 1090, 57, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.44"}],
    Cell[30179, 1093, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.45"}],
    Cell[30241, 1096, 522, 15, 70, "Text",
      CellTags->{"S2.13.3", "3.46"}],
    Cell[30766, 1113, 282, 6, 70, "Text",
      CellTags->{"S2.13.3", "3.47"}],
    Cell[31051, 1121, 409, 10, 70, "Text",
      CellTags->{"S2.13.3", "3.48"}],
    Cell[31463, 1133, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.49"}],
    Cell[31522, 1136, 204, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.50"}],
    Cell[31729, 1143, 164, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.51"}],
    Cell[31896, 1149, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.52"}],
    Cell[31958, 1152, 456, 11, 70, "Text",
      CellTags->{"S2.13.3", "3.53"}],
    Cell[32417, 1165, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.54"}],
    Cell[32476, 1168, 208, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.55"}],
    Cell[32687, 1176, 261, 7, 70, "Program",
      CellTags->{"S2.13.3", "3.56"}],
    Cell[32951, 1185, 274, 9, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.57"}],
    Cell[33228, 1196, 686, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.58"}],
    Cell[33917, 1222, 284, 10, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.59"}],
    Cell[34204, 1234, 658, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.60"}],
    Cell[34865, 1260, 250, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.61"}],
    Cell[35118, 1268, 104, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.62"}],
    Cell[35225, 1274, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.63"}],
    Cell[35287, 1277, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.64"}],
    Cell[35346, 1280, 290, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.65"}],
    Cell[35639, 1290, 336, 13, 70, "Program",
      CellTags->{"S2.13.3", "3.66"}],
    Cell[35978, 1305, 336, 11, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.67"}],
    Cell[36317, 1318, 325, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.68"}],
    Cell[36645, 1332, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.69"}],
    Cell[36707, 1335, 549, 14, 70, "Text",
      CellTags->{"S2.13.3", "3.70"}],
    Cell[37259, 1351, 548, 16, 70, "DefinitionBox",
      CellTags->"S2.13.3"],
    Cell[37810, 1369, 154, 5, 70, "Caption",
      CellTags->"S2.13.3"],
    Cell[37967, 1376, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.71"}],
    Cell[38026, 1379, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.72"}],
    Cell[38105, 1382, 265, 13, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.73"}],
    Cell[38373, 1397, 132, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.74"}],
    Cell[38508, 1403, 79, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.75"}],
    Cell[38590, 1409, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.76"}],
    Cell[38652, 1412, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.77"}],
    Cell[38855, 1421, 86, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[38944, 1425, 112, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[39071, 1431, 170, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.78"}],
    Cell[39266, 1442, 75, 2, 70, "Input",
      CellTags->"S2.13.3"],
    Cell[39344, 1446, 66, 2, 70, "Print",
      CellTags->"S2.13.3"],
    Cell[39413, 1450, 88, 3, 70, "Output",
      CellTags->"S2.13.3"],
    Cell[39516, 1456, 474, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.79"}]},
  "3.1"->{
    Cell[14491, 502, 159, 4, 70, "Subsection",
      CellTags->{"S2.13.3", "3.1"}]},
  "3.2"->{
    Cell[14653, 508, 393, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.2"}]},
  "3.3"->{
    Cell[15049, 519, 253, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.3"}]},
  "3.4"->{
    Cell[15305, 529, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.4"}]},
  "3.5"->{
    Cell[15363, 532, 212, 9, 70, "Program",
      CellTags->{"S2.13.3", "3.5"}]},
  "3.6"->{
    Cell[15578, 543, 84, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.6"}]},
  "3.7"->{
    Cell[17631, 607, 513, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.7"}]},
  "3.8"->{
    Cell[18147, 621, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.8"}]},
  "3.9"->{
    Cell[18205, 624, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.9"}]},
  "3.10"->{
    Cell[18350, 631, 84, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.10"}]},
  "3.11"->{
    Cell[18437, 637, 150, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.11"}]},
  "3.12"->{
    Cell[18590, 644, 326, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.12"}]},
  "3.13"->{
    Cell[18919, 658, 181, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.13"}]},
  "3.14"->{
    Cell[19103, 665, 354, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.14"}]},
  "3.15"->{
    Cell[19460, 679, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.15"}]},
  "3.16"->{
    Cell[19648, 689, 335, 9, 70, "Text",
      CellTags->{"S2.13.3", "3.16"}]},
  "3.17"->{
    Cell[20831, 731, 321, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.17"}]},
  "3.18"->{
    Cell[21155, 741, 353, 8, 70, "Text",
      CellTags->{"S2.13.3", "3.18"}]},
  "3.19"->{
    Cell[21511, 751, 545, 17, 70, "Text",
      CellTags->{"S2.13.3", "3.19"}]},
  "3.20"->{
    Cell[22059, 770, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.20"}]},
  "3.21"->{
    Cell[22118, 773, 222, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.21"}]},
  "3.22"->{
    Cell[22343, 782, 73, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.22"}]},
  "3.23"->{
    Cell[22419, 785, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.23"}]},
  "3.24"->{
    Cell[22481, 788, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.24"}]},
  "3.25"->{
    Cell[22875, 807, 388, 17, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.25"}]},
  "3.26"->{
    Cell[23462, 838, 151, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.26"}]},
  "3.27"->{
    Cell[23830, 856, 461, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.27"}]},
  "3.28"->{
    Cell[25832, 916, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.28"}]},
  "3.29"->{
    Cell[26209, 935, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.29"}]},
  "3.30"->{
    Cell[26669, 956, 237, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.30"}]},
  "3.31"->{
    Cell[27621, 994, 671, 20, 70, "Text",
      CellTags->{"S2.13.3", "3.31"}]},
  "3.32"->{
    Cell[28295, 1016, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.32"}]},
  "3.33"->{
    Cell[28354, 1019, 59, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.33"}]},
  "3.34"->{
    Cell[28416, 1022, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.34"}]},
  "3.35"->{
    Cell[28562, 1028, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.35"}]},
  "3.36"->{
    Cell[28641, 1031, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.36"}]},
  "3.37"->{
    Cell[28819, 1038, 99, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.37"}]},
  "3.38"->{
    Cell[28921, 1041, 166, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.38"}]},
  "3.39"->{
    Cell[29090, 1047, 330, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.39"}]},
  "3.40"->{
    Cell[29423, 1061, 147, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.40"}]},
  "3.41"->{
    Cell[29573, 1067, 320, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.41"}]},
  "3.42"->{
    Cell[29896, 1081, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.42"}]},
  "3.43"->{
    Cell[30041, 1087, 75, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.43"}]},
  "3.44"->{
    Cell[30119, 1090, 57, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.44"}]},
  "3.45"->{
    Cell[30179, 1093, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.45"}]},
  "3.46"->{
    Cell[30241, 1096, 522, 15, 70, "Text",
      CellTags->{"S2.13.3", "3.46"}]},
  "3.47"->{
    Cell[30766, 1113, 282, 6, 70, "Text",
      CellTags->{"S2.13.3", "3.47"}]},
  "3.48"->{
    Cell[31051, 1121, 409, 10, 70, "Text",
      CellTags->{"S2.13.3", "3.48"}]},
  "3.49"->{
    Cell[31463, 1133, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.49"}]},
  "3.50"->{
    Cell[31522, 1136, 204, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.50"}]},
  "3.51"->{
    Cell[31729, 1143, 164, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.51"}]},
  "3.52"->{
    Cell[31896, 1149, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.52"}]},
  "3.53"->{
    Cell[31958, 1152, 456, 11, 70, "Text",
      CellTags->{"S2.13.3", "3.53"}]},
  "3.54"->{
    Cell[32417, 1165, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.54"}]},
  "3.55"->{
    Cell[32476, 1168, 208, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.55"}]},
  "3.56"->{
    Cell[32687, 1176, 261, 7, 70, "Program",
      CellTags->{"S2.13.3", "3.56"}]},
  "3.57"->{
    Cell[32951, 1185, 274, 9, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.57"}]},
  "3.58"->{
    Cell[33228, 1196, 686, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.58"}]},
  "3.59"->{
    Cell[33917, 1222, 284, 10, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.59"}]},
  "3.60"->{
    Cell[34204, 1234, 658, 24, 70, "Program",
      CellTags->{"S2.13.3", "3.60"}]},
  "3.61"->{
    Cell[34865, 1260, 250, 6, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.61"}]},
  "3.62"->{
    Cell[35118, 1268, 104, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.62"}]},
  "3.63"->{
    Cell[35225, 1274, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.63"}]},
  "3.64"->{
    Cell[35287, 1277, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.64"}]},
  "3.65"->{
    Cell[35346, 1280, 290, 8, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.65"}]},
  "3.66"->{
    Cell[35639, 1290, 336, 13, 70, "Program",
      CellTags->{"S2.13.3", "3.66"}]},
  "3.67"->{
    Cell[35978, 1305, 336, 11, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.67"}]},
  "3.68"->{
    Cell[36317, 1318, 325, 12, 70, "Program",
      CellTags->{"S2.13.3", "3.68"}]},
  "3.69"->{
    Cell[36645, 1332, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.69"}]},
  "3.70"->{
    Cell[36707, 1335, 549, 14, 70, "Text",
      CellTags->{"S2.13.3", "3.70"}]},
  "3.71"->{
    Cell[37967, 1376, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.3", "3.71"}]},
  "3.72"->{
    Cell[38026, 1379, 76, 1, 70, "Program",
      CellTags->{"S2.13.3", "3.72"}]},
  "3.73"->{
    Cell[38105, 1382, 265, 13, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.73"}]},
  "3.74"->{
    Cell[38373, 1397, 132, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.74"}]},
  "3.75"->{
    Cell[38508, 1403, 79, 4, 70, "Program",
      CellTags->{"S2.13.3", "3.75"}]},
  "3.76"->{
    Cell[38590, 1409, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.3", "3.76"}]},
  "3.77"->{
    Cell[38652, 1412, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.77"}]},
  "3.78"->{
    Cell[39071, 1431, 170, 7, 70, "MathCaption",
      CellTags->{"S2.13.3", "3.78"}]},
  "3.79"->{
    Cell[39516, 1456, 474, 12, 70, "Text",
      CellTags->{"S2.13.3", "3.79"}]},
  "S2.13.4"->{
    Cell[40027, 1473, 105, 1, 70, "Subsection",
      CellTags->{"S2.13.4", "4.1"}],
    Cell[40135, 1476, 391, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.2"}],
    Cell[40529, 1489, 2536, 82, 70, "DefinitionBox3Col",
      CellTags->"S2.13.4"],
    Cell[43068, 1573, 69, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[43140, 1576, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.3"}],
    Cell[43198, 1579, 191, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.4"}],
    Cell[43392, 1586, 661, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.5"}],
    Cell[44056, 1612, 218, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.6"}],
    Cell[44277, 1619, 402, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.7"}],
    Cell[44682, 1634, 58, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.8"}],
    Cell[44743, 1637, 185, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.9"}],
    Cell[44953, 1647, 83, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[45039, 1651, 109, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[45163, 1657, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.10"}],
    Cell[45274, 1662, 77, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[45354, 1666, 84, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[45453, 1672, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.11"}],
    Cell[45656, 1681, 70, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[45729, 1685, 87, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[45831, 1691, 224, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.12"}],
    Cell[46080, 1701, 77, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[46160, 1705, 89, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[46264, 1711, 327, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.13"}],
    Cell[46594, 1722, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.14"}],
    Cell[46653, 1725, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.15"}],
    Cell[46798, 1732, 343, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.16"}],
    Cell[47144, 1747, 115, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.17"}],
    Cell[47262, 1751, 106, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.18"}],
    Cell[47371, 1754, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.19"}],
    Cell[47433, 1757, 311, 8, 70, "Text",
      CellTags->{"S2.13.4", "4.20"}],
    Cell[47747, 1767, 490, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.21"}],
    Cell[48240, 1784, 3747, 106, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[51990, 1892, 160, 6, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[52153, 1900, 649, 19, 70, "Text",
      CellTags->{"S2.13.4", "4.22"}],
    Cell[52805, 1921, 869, 25, 70, "Text",
      CellTags->{"S2.13.4", "4.23"}],
    Cell[53677, 1948, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.24"}],
    Cell[53736, 1951, 270, 8, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.25"}],
    Cell[54009, 1961, 666, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.26"}],
    Cell[54678, 1987, 134, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.27"}],
    Cell[54815, 1994, 97, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.28"}],
    Cell[54915, 2002, 136, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.29"}],
    Cell[55054, 2009, 407, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.30"}],
    Cell[55464, 2024, 214, 9, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.31"}],
    Cell[55681, 2035, 111, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.32"}],
    Cell[55795, 2042, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.33"}],
    Cell[55857, 2045, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.34"}],
    Cell[56047, 2054, 86, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[56136, 2058, 108, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[56259, 2064, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.35"}],
    Cell[56390, 2069, 73, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[56466, 2073, 94, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[56575, 2079, 457, 17, 70, "Text",
      CellTags->{"S2.13.4", "4.36"}],
    Cell[57035, 2098, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.37"}],
    Cell[57094, 2101, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.38"}],
    Cell[57152, 2104, 124, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.39"}],
    Cell[57279, 2110, 73, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.40"}],
    Cell[57355, 2113, 199, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.41"}],
    Cell[57557, 2122, 322, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.42"}],
    Cell[57882, 2137, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.43"}],
    Cell[57952, 2143, 214, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.44"}],
    Cell[58169, 2152, 101, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.45"}],
    Cell[58273, 2155, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.46"}],
    Cell[58331, 2158, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.47"}],
    Cell[58393, 2161, 431, 13, 70, "Text",
      CellTags->{"S2.13.4", "4.48"}],
    Cell[58827, 2176, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.49"}],
    Cell[58886, 2179, 189, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.50"}],
    Cell[59078, 2188, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.51"}],
    Cell[59169, 2191, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.52"}],
    Cell[59329, 2198, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.53"}],
    Cell[59410, 2201, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.54"}],
    Cell[59574, 2208, 80, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.55"}],
    Cell[59657, 2211, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.56"}],
    Cell[59719, 2214, 583, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.57"}],
    Cell[60305, 2232, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.58"}],
    Cell[60364, 2235, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.59"}],
    Cell[60516, 2242, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.60"}],
    Cell[60607, 2245, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.61"}],
    Cell[60785, 2252, 85, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.62"}],
    Cell[60873, 2255, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.63"}],
    Cell[61012, 2261, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.64"}],
    Cell[61103, 2264, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.65"}],
    Cell[61242, 2270, 76, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.66"}],
    Cell[61321, 2273, 90, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.67"}],
    Cell[61414, 2276, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.68"}],
    Cell[61495, 2279, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.69"}],
    Cell[61557, 2282, 626, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.70"}],
    Cell[62186, 2299, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.71"}],
    Cell[62245, 2302, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.72"}],
    Cell[62303, 2305, 167, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.73"}],
    Cell[62473, 2312, 61, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.74"}],
    Cell[62537, 2315, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.75"}],
    Cell[62595, 2318, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.76"}],
    Cell[62776, 2327, 89, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.77"}],
    Cell[62868, 2330, 74, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.78"}],
    Cell[62945, 2333, 141, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.79"}],
    Cell[63089, 2340, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.80"}],
    Cell[63185, 2343, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.81"}],
    Cell[63266, 2346, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.82"}],
    Cell[63360, 2349, 99, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.83"}],
    Cell[63462, 2352, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.84"}],
    Cell[63532, 2358, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.85"}],
    Cell[63590, 2361, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.86"}],
    Cell[63652, 2364, 763, 20, 70, "Text",
      CellTags->{"S2.13.4", "4.87"}],
    Cell[64418, 2386, 268, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.88"}],
    Cell[64689, 2394, 180, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.89"}],
    Cell[64894, 2403, 106, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[65003, 2407, 99, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[65117, 2413, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.90"}],
    Cell[65285, 2421, 100, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[65388, 2425, 111, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[65514, 2431, 125, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.91"}],
    Cell[65664, 2439, 75, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[65742, 2443, 99, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[65856, 2449, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.92"}],
    Cell[66015, 2457, 105, 2, 70, "Input",
      CellTags->"S2.13.4"],
    Cell[66123, 2461, 89, 3, 70, "Output",
      CellTags->"S2.13.4"],
    Cell[66227, 2467, 346, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.93"}],
    Cell[66576, 2478, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.94"}],
    Cell[66635, 2481, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.95"}],
    Cell[66780, 2488, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.96"}],
    Cell[66871, 2491, 164, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.97"}],
    Cell[67038, 2499, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.98"}],
    Cell[67180, 2506, 96, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.99"}],
    Cell[67279, 2509, 74, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.100"}],
    Cell[67356, 2512, 128, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.101"}],
    Cell[67487, 2519, 54, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.102"}],
    Cell[67544, 2522, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.103"}],
    Cell[67691, 2529, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.104"}],
    Cell[67787, 2532, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.105"}],
    Cell[67850, 2535, 898, 26, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[68751, 2563, 148, 5, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[68902, 2570, 472, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.106"}],
    Cell[69377, 2587, 389, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.107"}],
    Cell[69769, 2601, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.108"}],
    Cell[69829, 2604, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.109"}],
    Cell[69919, 2610, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.110"}],
    Cell[70100, 2619, 98, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.111"}],
    Cell[70201, 2622, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.112"}],
    Cell[70335, 2628, 313, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.113"}],
    Cell[70651, 2642, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.114"}],
    Cell[70788, 2648, 321, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.115"}],
    Cell[71112, 2662, 89, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.116"}],
    Cell[71204, 2669, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.117"}],
    Cell[71320, 2672, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.118"}],
    Cell[71402, 2678, 166, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.119"}],
    Cell[71571, 2687, 77, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.120"}],
    Cell[71651, 2693, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.121"}],
    Cell[71797, 2699, 115, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.122"}],
    Cell[71915, 2706, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.123"}],
    Cell[71997, 2712, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.124"}],
    Cell[72060, 2715, 601, 18, 70, "Text",
      CellTags->{"S2.13.4", "4.125"}],
    Cell[72664, 2735, 579, 18, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[73246, 2755, 119, 5, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[73368, 2762, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.126"}],
    Cell[73428, 2765, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.127"}],
    Cell[73518, 2771, 200, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.128"}],
    Cell[73721, 2780, 327, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.129"}],
    Cell[74051, 2795, 109, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.130"}],
    Cell[74163, 2798, 307, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.131"}],
    Cell[74473, 2812, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.132"}],
    Cell[74609, 2818, 312, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.133"}],
    Cell[74924, 2832, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.134"}],
    Cell[75019, 2839, 108, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.135"}],
    Cell[75130, 2842, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.136"}],
    Cell[75208, 2848, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.137"}],
    Cell[75299, 2851, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.138"}],
    Cell[75394, 2858, 197, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.139"}],
    Cell[75594, 2866, 105, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.140"}],
    Cell[75702, 2872, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.141"}],
    Cell[75861, 2879, 117, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.142"}],
    Cell[75981, 2885, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.143"}],
    Cell[76050, 2891, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.144"}],
    Cell[76113, 2894, 429, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.145"}],
    Cell[76545, 2905, 253, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.146"}],
    Cell[76801, 2913, 1701, 50, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[78505, 2965, 68, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[78576, 2968, 459, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.147"}],
    Cell[79038, 2984, 240, 5, 70, "Text",
      CellTags->{"S2.13.4", "4.148"}],
    Cell[79281, 2991, 494, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.149"}],
    Cell[79778, 3007, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.150"}],
    Cell[79838, 3010, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.151"}],
    Cell[79974, 3016, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.152"}],
    Cell[80052, 3022, 159, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.153"}],
    Cell[80214, 3029, 85, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.154"}],
    Cell[80302, 3036, 168, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.155"}],
    Cell[80473, 3043, 100, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.156"}],
    Cell[80576, 3049, 56, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.157"}],
    Cell[80635, 3052, 119, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.158"}],
    Cell[80757, 3056, 92, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.159"}],
    Cell[80852, 3059, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.160"}],
    Cell[80921, 3065, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.161"}],
    Cell[80984, 3068, 522, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.162"}],
    Cell[81509, 3084, 2274, 62, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[83786, 3148, 69, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[83858, 3151, 405, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.163"}],
    Cell[84266, 3163, 563, 21, 70, "Text",
      CellTags->{"S2.13.4", "4.164"}],
    Cell[84832, 3186, 518, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.165"}],
    Cell[85353, 3204, 342, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.166"}],
    Cell[85698, 3216, 1178, 30, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[86879, 3248, 86, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[86968, 3251, 461, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.167"}],
    Cell[87432, 3265, 501, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.168"}],
    Cell[87936, 3278, 978, 26, 70, "DefinitionBox",
      CellTags->"S2.13.4"],
    Cell[88917, 3306, 73, 1, 70, "Caption",
      CellTags->"S2.13.4"],
    Cell[88993, 3309, 553, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.169"}]},
  "4.1"->{
    Cell[40027, 1473, 105, 1, 70, "Subsection",
      CellTags->{"S2.13.4", "4.1"}]},
  "4.2"->{
    Cell[40135, 1476, 391, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.2"}]},
  "4.3"->{
    Cell[43140, 1576, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.3"}]},
  "4.4"->{
    Cell[43198, 1579, 191, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.4"}]},
  "4.5"->{
    Cell[43392, 1586, 661, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.5"}]},
  "4.6"->{
    Cell[44056, 1612, 218, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.6"}]},
  "4.7"->{
    Cell[44277, 1619, 402, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.7"}]},
  "4.8"->{
    Cell[44682, 1634, 58, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.8"}]},
  "4.9"->{
    Cell[44743, 1637, 185, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.9"}]},
  "4.10"->{
    Cell[45163, 1657, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.10"}]},
  "4.11"->{
    Cell[45453, 1672, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.11"}]},
  "4.12"->{
    Cell[45831, 1691, 224, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.12"}]},
  "4.13"->{
    Cell[46264, 1711, 327, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.13"}]},
  "4.14"->{
    Cell[46594, 1722, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.14"}]},
  "4.15"->{
    Cell[46653, 1725, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.15"}]},
  "4.16"->{
    Cell[46798, 1732, 343, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.16"}]},
  "4.17"->{
    Cell[47144, 1747, 115, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.17"}]},
  "4.18"->{
    Cell[47262, 1751, 106, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.18"}]},
  "4.19"->{
    Cell[47371, 1754, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.19"}]},
  "4.20"->{
    Cell[47433, 1757, 311, 8, 70, "Text",
      CellTags->{"S2.13.4", "4.20"}]},
  "4.21"->{
    Cell[47747, 1767, 490, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.21"}]},
  "4.22"->{
    Cell[52153, 1900, 649, 19, 70, "Text",
      CellTags->{"S2.13.4", "4.22"}]},
  "4.23"->{
    Cell[52805, 1921, 869, 25, 70, "Text",
      CellTags->{"S2.13.4", "4.23"}]},
  "4.24"->{
    Cell[53677, 1948, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.24"}]},
  "4.25"->{
    Cell[53736, 1951, 270, 8, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.25"}]},
  "4.26"->{
    Cell[54009, 1961, 666, 24, 70, "Program",
      CellTags->{"S2.13.4", "4.26"}]},
  "4.27"->{
    Cell[54678, 1987, 134, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.27"}]},
  "4.28"->{
    Cell[54815, 1994, 97, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.28"}]},
  "4.29"->{
    Cell[54915, 2002, 136, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.29"}]},
  "4.30"->{
    Cell[55054, 2009, 407, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.30"}]},
  "4.31"->{
    Cell[55464, 2024, 214, 9, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.31"}]},
  "4.32"->{
    Cell[55681, 2035, 111, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.32"}]},
  "4.33"->{
    Cell[55795, 2042, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.33"}]},
  "4.34"->{
    Cell[55857, 2045, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.34"}]},
  "4.35"->{
    Cell[56259, 2064, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.35"}]},
  "4.36"->{
    Cell[56575, 2079, 457, 17, 70, "Text",
      CellTags->{"S2.13.4", "4.36"}]},
  "4.37"->{
    Cell[57035, 2098, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.37"}]},
  "4.38"->{
    Cell[57094, 2101, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.38"}]},
  "4.39"->{
    Cell[57152, 2104, 124, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.39"}]},
  "4.40"->{
    Cell[57279, 2110, 73, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.40"}]},
  "4.41"->{
    Cell[57355, 2113, 199, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.41"}]},
  "4.42"->{
    Cell[57557, 2122, 322, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.42"}]},
  "4.43"->{
    Cell[57882, 2137, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.43"}]},
  "4.44"->{
    Cell[57952, 2143, 214, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.44"}]},
  "4.45"->{
    Cell[58169, 2152, 101, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.45"}]},
  "4.46"->{
    Cell[58273, 2155, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.46"}]},
  "4.47"->{
    Cell[58331, 2158, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.47"}]},
  "4.48"->{
    Cell[58393, 2161, 431, 13, 70, "Text",
      CellTags->{"S2.13.4", "4.48"}]},
  "4.49"->{
    Cell[58827, 2176, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.49"}]},
  "4.50"->{
    Cell[58886, 2179, 189, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.50"}]},
  "4.51"->{
    Cell[59078, 2188, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.51"}]},
  "4.52"->{
    Cell[59169, 2191, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.52"}]},
  "4.53"->{
    Cell[59329, 2198, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.53"}]},
  "4.54"->{
    Cell[59410, 2201, 161, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.54"}]},
  "4.55"->{
    Cell[59574, 2208, 80, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.55"}]},
  "4.56"->{
    Cell[59657, 2211, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.56"}]},
  "4.57"->{
    Cell[59719, 2214, 583, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.57"}]},
  "4.58"->{
    Cell[60305, 2232, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.58"}]},
  "4.59"->{
    Cell[60364, 2235, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.59"}]},
  "4.60"->{
    Cell[60516, 2242, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.60"}]},
  "4.61"->{
    Cell[60607, 2245, 175, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.61"}]},
  "4.62"->{
    Cell[60785, 2252, 85, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.62"}]},
  "4.63"->{
    Cell[60873, 2255, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.63"}]},
  "4.64"->{
    Cell[61012, 2261, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.64"}]},
  "4.65"->{
    Cell[61103, 2264, 136, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.65"}]},
  "4.66"->{
    Cell[61242, 2270, 76, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.66"}]},
  "4.67"->{
    Cell[61321, 2273, 90, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.67"}]},
  "4.68"->{
    Cell[61414, 2276, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.68"}]},
  "4.69"->{
    Cell[61495, 2279, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.69"}]},
  "4.70"->{
    Cell[61557, 2282, 626, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.70"}]},
  "4.71"->{
    Cell[62186, 2299, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.71"}]},
  "4.72"->{
    Cell[62245, 2302, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.72"}]},
  "4.73"->{
    Cell[62303, 2305, 167, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.73"}]},
  "4.74"->{
    Cell[62473, 2312, 61, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.74"}]},
  "4.75"->{
    Cell[62537, 2315, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.75"}]},
  "4.76"->{
    Cell[62595, 2318, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.76"}]},
  "4.77"->{
    Cell[62776, 2327, 89, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.77"}]},
  "4.78"->{
    Cell[62868, 2330, 74, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.78"}]},
  "4.79"->{
    Cell[62945, 2333, 141, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.79"}]},
  "4.80"->{
    Cell[63089, 2340, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.80"}]},
  "4.81"->{
    Cell[63185, 2343, 78, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.81"}]},
  "4.82"->{
    Cell[63266, 2346, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.82"}]},
  "4.83"->{
    Cell[63360, 2349, 99, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.83"}]},
  "4.84"->{
    Cell[63462, 2352, 67, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.84"}]},
  "4.85"->{
    Cell[63532, 2358, 55, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.85"}]},
  "4.86"->{
    Cell[63590, 2361, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.86"}]},
  "4.87"->{
    Cell[63652, 2364, 763, 20, 70, "Text",
      CellTags->{"S2.13.4", "4.87"}]},
  "4.88"->{
    Cell[64418, 2386, 268, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.88"}]},
  "4.89"->{
    Cell[64689, 2394, 180, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.89"}]},
  "4.90"->{
    Cell[65117, 2413, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.90"}]},
  "4.91"->{
    Cell[65514, 2431, 125, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.91"}]},
  "4.92"->{
    Cell[65856, 2449, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.92"}]},
  "4.93"->{
    Cell[66227, 2467, 346, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.93"}]},
  "4.94"->{
    Cell[66576, 2478, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.94"}]},
  "4.95"->{
    Cell[66635, 2481, 142, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.95"}]},
  "4.96"->{
    Cell[66780, 2488, 88, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.96"}]},
  "4.97"->{
    Cell[66871, 2491, 164, 6, 70, "Program",
      CellTags->{"S2.13.4", "4.97"}]},
  "4.98"->{
    Cell[67038, 2499, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.98"}]},
  "4.99"->{
    Cell[67180, 2506, 96, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.99"}]},
  "4.100"->{
    Cell[67279, 2509, 74, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.100"}]},
  "4.101"->{
    Cell[67356, 2512, 128, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.101"}]},
  "4.102"->{
    Cell[67487, 2519, 54, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.102"}]},
  "4.103"->{
    Cell[67544, 2522, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.103"}]},
  "4.104"->{
    Cell[67691, 2529, 93, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.104"}]},
  "4.105"->{
    Cell[67787, 2532, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.105"}]},
  "4.106"->{
    Cell[68902, 2570, 472, 15, 70, "Text",
      CellTags->{"S2.13.4", "4.106"}]},
  "4.107"->{
    Cell[69377, 2587, 389, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.107"}]},
  "4.108"->{
    Cell[69769, 2601, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.108"}]},
  "4.109"->{
    Cell[69829, 2604, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.109"}]},
  "4.110"->{
    Cell[69919, 2610, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.110"}]},
  "4.111"->{
    Cell[70100, 2619, 98, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.111"}]},
  "4.112"->{
    Cell[70201, 2622, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.112"}]},
  "4.113"->{
    Cell[70335, 2628, 313, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.113"}]},
  "4.114"->{
    Cell[70651, 2642, 134, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.114"}]},
  "4.115"->{
    Cell[70788, 2648, 321, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.115"}]},
  "4.116"->{
    Cell[71112, 2662, 89, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.116"}]},
  "4.117"->{
    Cell[71204, 2669, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.117"}]},
  "4.118"->{
    Cell[71320, 2672, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.118"}]},
  "4.119"->{
    Cell[71402, 2678, 166, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.119"}]},
  "4.120"->{
    Cell[71571, 2687, 77, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.120"}]},
  "4.121"->{
    Cell[71651, 2693, 143, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.121"}]},
  "4.122"->{
    Cell[71797, 2699, 115, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.122"}]},
  "4.123"->{
    Cell[71915, 2706, 79, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.123"}]},
  "4.124"->{
    Cell[71997, 2712, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.124"}]},
  "4.125"->{
    Cell[72060, 2715, 601, 18, 70, "Text",
      CellTags->{"S2.13.4", "4.125"}]},
  "4.126"->{
    Cell[73368, 2762, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.126"}]},
  "4.127"->{
    Cell[73428, 2765, 87, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.127"}]},
  "4.128"->{
    Cell[73518, 2771, 200, 7, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.128"}]},
  "4.129"->{
    Cell[73721, 2780, 327, 13, 70, "Program",
      CellTags->{"S2.13.4", "4.129"}]},
  "4.130"->{
    Cell[74051, 2795, 109, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.130"}]},
  "4.131"->{
    Cell[74163, 2798, 307, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.131"}]},
  "4.132"->{
    Cell[74473, 2812, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.132"}]},
  "4.133"->{
    Cell[74609, 2818, 312, 12, 70, "Program",
      CellTags->{"S2.13.4", "4.133"}]},
  "4.134"->{
    Cell[74924, 2832, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.134"}]},
  "4.135"->{
    Cell[75019, 2839, 108, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.135"}]},
  "4.136"->{
    Cell[75130, 2842, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.136"}]},
  "4.137"->{
    Cell[75208, 2848, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.137"}]},
  "4.138"->{
    Cell[75299, 2851, 92, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.138"}]},
  "4.139"->{
    Cell[75394, 2858, 197, 6, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.139"}]},
  "4.140"->{
    Cell[75594, 2866, 105, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.140"}]},
  "4.141"->{
    Cell[75702, 2872, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.141"}]},
  "4.142"->{
    Cell[75861, 2879, 117, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.142"}]},
  "4.143"->{
    Cell[75981, 2885, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.143"}]},
  "4.144"->{
    Cell[76050, 2891, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.144"}]},
  "4.145"->{
    Cell[76113, 2894, 429, 9, 70, "Text",
      CellTags->{"S2.13.4", "4.145"}]},
  "4.146"->{
    Cell[76545, 2905, 253, 6, 70, "Text",
      CellTags->{"S2.13.4", "4.146"}]},
  "4.147"->{
    Cell[78576, 2968, 459, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.147"}]},
  "4.148"->{
    Cell[79038, 2984, 240, 5, 70, "Text",
      CellTags->{"S2.13.4", "4.148"}]},
  "4.149"->{
    Cell[79281, 2991, 494, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.149"}]},
  "4.150"->{
    Cell[79778, 3007, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.4", "4.150"}]},
  "4.151"->{
    Cell[79838, 3010, 133, 4, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.151"}]},
  "4.152"->{
    Cell[79974, 3016, 75, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.152"}]},
  "4.153"->{
    Cell[80052, 3022, 159, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.153"}]},
  "4.154"->{
    Cell[80214, 3029, 85, 5, 70, "Program",
      CellTags->{"S2.13.4", "4.154"}]},
  "4.155"->{
    Cell[80302, 3036, 168, 5, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.155"}]},
  "4.156"->{
    Cell[80473, 3043, 100, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.156"}]},
  "4.157"->{
    Cell[80576, 3049, 56, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.157"}]},
  "4.158"->{
    Cell[80635, 3052, 119, 2, 70, "MathCaption",
      CellTags->{"S2.13.4", "4.158"}]},
  "4.159"->{
    Cell[80757, 3056, 92, 1, 70, "Program",
      CellTags->{"S2.13.4", "4.159"}]},
  "4.160"->{
    Cell[80852, 3059, 66, 4, 70, "Program",
      CellTags->{"S2.13.4", "4.160"}]},
  "4.161"->{
    Cell[80921, 3065, 60, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.4", "4.161"}]},
  "4.162"->{
    Cell[80984, 3068, 522, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.162"}]},
  "4.163"->{
    Cell[83858, 3151, 405, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.163"}]},
  "4.164"->{
    Cell[84266, 3163, 563, 21, 70, "Text",
      CellTags->{"S2.13.4", "4.164"}]},
  "4.165"->{
    Cell[84832, 3186, 518, 16, 70, "Text",
      CellTags->{"S2.13.4", "4.165"}]},
  "4.166"->{
    Cell[85353, 3204, 342, 10, 70, "Text",
      CellTags->{"S2.13.4", "4.166"}]},
  "4.167"->{
    Cell[86968, 3251, 461, 12, 70, "Text",
      CellTags->{"S2.13.4", "4.167"}]},
  "4.168"->{
    Cell[87432, 3265, 501, 11, 70, "Text",
      CellTags->{"S2.13.4", "4.168"}]},
  "4.169"->{
    Cell[88993, 3309, 553, 14, 70, "Text",
      CellTags->{"S2.13.4", "4.169"}]},
  "S2.13.5"->{
    Cell[89583, 3328, 153, 5, 70, "Subsection",
      CellTags->{"S2.13.5", "5.1"}],
    Cell[89739, 3335, 323, 9, 70, "Text",
      CellTags->{"S2.13.5", "5.2"}],
    Cell[90065, 3346, 415, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.3"}],
    Cell[90483, 3359, 1483, 44, 70, "DefinitionBox",
      CellTags->"S2.13.5"],
    Cell[91969, 3405, 92, 1, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[92064, 3408, 641, 19, 70, "Text",
      CellTags->{"S2.13.5", "5.4"}],
    Cell[92708, 3429, 1061, 32, 70, "DefinitionBox",
      CellTags->"S2.13.5"],
    Cell[93772, 3463, 97, 1, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[93872, 3466, 309, 6, 70, "Text",
      CellTags->{"S2.13.5", "5.5"}],
    Cell[94184, 3474, 156, 4, 70, "Text",
      CellTags->{"S2.13.5", "5.6"}],
    Cell[94343, 3480, 350, 7, 70, "Text",
      CellTags->{"S2.13.5", "5.7"}],
    Cell[94696, 3489, 736, 21, 70, "Text",
      CellTags->{"S2.13.5", "5.8"}],
    Cell[95435, 3512, 2531, 76, 70, "DefinitionBox3Col",
      CellTags->"S2.13.5"],
    Cell[97969, 3590, 126, 4, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[98098, 3596, 520, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.9"}],
    Cell[98621, 3612, 535, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.10"}],
    Cell[99159, 3625, 2482, 71, 70, "DefinitionBox",
      CellTags->"S2.13.5"],
    Cell[101644, 3698, 72, 1, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[101719, 3701, 536, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.11"}],
    Cell[102258, 3717, 497, 17, 70, "Text",
      CellTags->{"S2.13.5", "5.12"}],
    Cell[102758, 3736, 552, 13, 70, "Text",
      CellTags->{"S2.13.5", "5.13"}],
    Cell[103313, 3751, 391, 11, 70, "FramedBox",
      CellTags->"S2.13.5"],
    Cell[103707, 3764, 143, 5, 70, "Caption",
      CellTags->"S2.13.5"],
    Cell[103853, 3771, 416, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.14"}],
    Cell[104272, 3787, 548, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.15"}]},
  "5.1"->{
    Cell[89583, 3328, 153, 5, 70, "Subsection",
      CellTags->{"S2.13.5", "5.1"}]},
  "5.2"->{
    Cell[89739, 3335, 323, 9, 70, "Text",
      CellTags->{"S2.13.5", "5.2"}]},
  "5.3"->{
    Cell[90065, 3346, 415, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.3"}]},
  "5.4"->{
    Cell[92064, 3408, 641, 19, 70, "Text",
      CellTags->{"S2.13.5", "5.4"}]},
  "5.5"->{
    Cell[93872, 3466, 309, 6, 70, "Text",
      CellTags->{"S2.13.5", "5.5"}]},
  "5.6"->{
    Cell[94184, 3474, 156, 4, 70, "Text",
      CellTags->{"S2.13.5", "5.6"}]},
  "5.7"->{
    Cell[94343, 3480, 350, 7, 70, "Text",
      CellTags->{"S2.13.5", "5.7"}]},
  "5.8"->{
    Cell[94696, 3489, 736, 21, 70, "Text",
      CellTags->{"S2.13.5", "5.8"}]},
  "5.9"->{
    Cell[98098, 3596, 520, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.9"}]},
  "5.10"->{
    Cell[98621, 3612, 535, 11, 70, "Text",
      CellTags->{"S2.13.5", "5.10"}]},
  "5.11"->{
    Cell[101719, 3701, 536, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.11"}]},
  "5.12"->{
    Cell[102258, 3717, 497, 17, 70, "Text",
      CellTags->{"S2.13.5", "5.12"}]},
  "5.13"->{
    Cell[102758, 3736, 552, 13, 70, "Text",
      CellTags->{"S2.13.5", "5.13"}]},
  "5.14"->{
    Cell[103853, 3771, 416, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.14"}]},
  "5.15"->{
    Cell[104272, 3787, 548, 14, 70, "Text",
      CellTags->{"S2.13.5", "5.15"}]},
  "S2.13.6"->{
    Cell[104857, 3806, 193, 7, 70, "Subsection",
      CellTags->{"S2.13.6", "6.1"}],
    Cell[105053, 3815, 2366, 67, 70, "DefinitionBox",
      CellTags->"S2.13.6"],
    Cell[107422, 3884, 159, 6, 70, "Caption",
      CellTags->"S2.13.6"],
    Cell[107584, 3892, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.2"}],
    Cell[107652, 3895, 98, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.3"}],
    Cell[107775, 3900, 92, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[107870, 3904, 104, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[107989, 3909, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.4"}],
    Cell[108057, 3912, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.5"}],
    Cell[108177, 3917, 92, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[108272, 3921, 108, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[108395, 3926, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.6"}],
    Cell[108463, 3929, 145, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.7"}],
    Cell[108611, 3936, 84, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[108698, 3940, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.8"}],
    Cell[108766, 3943, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.9"}],
    Cell[108947, 3952, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[109028, 3956, 78, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[109121, 3961, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.10"}],
    Cell[109215, 3964, 87, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[109305, 3968, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.11"}],
    Cell[109374, 3971, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.12"}],
    Cell[109501, 3976, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[109582, 3980, 104, 3, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[109701, 3986, 254, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.13"}],
    Cell[109958, 3996, 151, 4, 70, "Text",
      CellTags->{"S2.13.6", "6.14"}],
    Cell[110112, 4002, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.15"}],
    Cell[110181, 4005, 212, 9, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.16"}],
    Cell[110396, 4016, 99, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[110498, 4020, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.17"}],
    Cell[110567, 4023, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.18"}],
    Cell[110766, 4032, 84, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[110853, 4036, 76, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[110944, 4041, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.19"}],
    Cell[111056, 4046, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[111137, 4050, 66, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[111218, 4055, 395, 11, 70, "Text",
      CellTags->{"S2.13.6", "6.20"}],
    Cell[111616, 4068, 718, 23, 70, "Text",
      CellTags->{"S2.13.6", "6.21"}],
    Cell[112337, 4093, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.22"}],
    Cell[112406, 4096, 199, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.23"}],
    Cell[112630, 4105, 80, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[112713, 4109, 70, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[112798, 4114, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.24"}],
    Cell[112867, 4117, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.25"}],
    Cell[112965, 4120, 86, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[113054, 4124, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.26"}],
    Cell[113123, 4127, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.27"}],
    Cell[113265, 4133, 80, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[113348, 4137, 69, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[113432, 4142, 148, 4, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.28"}],
    Cell[113605, 4150, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[113686, 4154, 70, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[113771, 4159, 1138, 30, 70, "DefinitionBox",
      CellTags->"S2.13.6"],
    Cell[114912, 4191, 117, 5, 70, "Caption",
      CellTags->"S2.13.6"],
    Cell[115032, 4198, 332, 7, 70, "Text",
      CellTags->{"S2.13.6", "6.29"}],
    Cell[115367, 4207, 195, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.30"}],
    Cell[115565, 4214, 160, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.31"}],
    Cell[115728, 4221, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.32"}],
    Cell[115853, 4227, 152, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.33"}],
    Cell[116030, 4236, 84, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[116117, 4240, 108, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[116240, 4245, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.34"}],
    Cell[116365, 4251, 147, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.35"}],
    Cell[116537, 4260, 109, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[116649, 4264, 108, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[116772, 4269, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.36"}],
    Cell[116882, 4272, 93, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[116978, 4276, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.37"}],
    Cell[117103, 4282, 143, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.38"}],
    Cell[117271, 4291, 78, 2, 70, "Input",
      CellTags->"S2.13.6"],
    Cell[117352, 4295, 69, 2, 70, "Output",
      CellTags->"S2.13.6"],
    Cell[117436, 4300, 333, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.39"}],
    Cell[117772, 4310, 390, 10, 70, "Text",
      CellTags->{"S2.13.6", "6.40"}]},
  "6.1"->{
    Cell[104857, 3806, 193, 7, 70, "Subsection",
      CellTags->{"S2.13.6", "6.1"}]},
  "6.2"->{
    Cell[107584, 3892, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.2"}]},
  "6.3"->{
    Cell[107652, 3895, 98, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.3"}]},
  "6.4"->{
    Cell[107989, 3909, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.4"}]},
  "6.5"->{
    Cell[108057, 3912, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.5"}]},
  "6.6"->{
    Cell[108395, 3926, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.6"}]},
  "6.7"->{
    Cell[108463, 3929, 145, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.7"}]},
  "6.8"->{
    Cell[108698, 3940, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.8"}]},
  "6.9"->{
    Cell[108766, 3943, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.9"}]},
  "6.10"->{
    Cell[109121, 3961, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.10"}]},
  "6.11"->{
    Cell[109305, 3968, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.11"}]},
  "6.12"->{
    Cell[109374, 3971, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.12"}]},
  "6.13"->{
    Cell[109701, 3986, 254, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.13"}]},
  "6.14"->{
    Cell[109958, 3996, 151, 4, 70, "Text",
      CellTags->{"S2.13.6", "6.14"}]},
  "6.15"->{
    Cell[110112, 4002, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.15"}]},
  "6.16"->{
    Cell[110181, 4005, 212, 9, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.16"}]},
  "6.17"->{
    Cell[110498, 4020, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.17"}]},
  "6.18"->{
    Cell[110567, 4023, 174, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.18"}]},
  "6.19"->{
    Cell[110944, 4041, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.19"}]},
  "6.20"->{
    Cell[111218, 4055, 395, 11, 70, "Text",
      CellTags->{"S2.13.6", "6.20"}]},
  "6.21"->{
    Cell[111616, 4068, 718, 23, 70, "Text",
      CellTags->{"S2.13.6", "6.21"}]},
  "6.22"->{
    Cell[112337, 4093, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.22"}]},
  "6.23"->{
    Cell[112406, 4096, 199, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.23"}]},
  "6.24"->{
    Cell[112798, 4114, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.24"}]},
  "6.25"->{
    Cell[112867, 4117, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.25"}]},
  "6.26"->{
    Cell[113054, 4124, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.26"}]},
  "6.27"->{
    Cell[113123, 4127, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.27"}]},
  "6.28"->{
    Cell[113432, 4142, 148, 4, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.28"}]},
  "6.29"->{
    Cell[115032, 4198, 332, 7, 70, "Text",
      CellTags->{"S2.13.6", "6.29"}]},
  "6.30"->{
    Cell[115367, 4207, 195, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.30"}]},
  "6.31"->{
    Cell[115565, 4214, 160, 5, 70, "Text",
      CellTags->{"S2.13.6", "6.31"}]},
  "6.32"->{
    Cell[115728, 4221, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.32"}]},
  "6.33"->{
    Cell[115853, 4227, 152, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.33"}]},
  "6.34"->{
    Cell[116240, 4245, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.34"}]},
  "6.35"->{
    Cell[116365, 4251, 147, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.35"}]},
  "6.36"->{
    Cell[116772, 4269, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.36"}]},
  "6.37"->{
    Cell[116978, 4276, 122, 4, 70, "SessionLabel",
      CellTags->{"S2.13.6", "6.37"}]},
  "6.38"->{
    Cell[117103, 4282, 143, 5, 70, "MathCaption",
      CellTags->{"S2.13.6", "6.38"}]},
  "6.39"->{
    Cell[117436, 4300, 333, 8, 70, "Text",
      CellTags->{"S2.13.6", "6.39"}]},
  "6.40"->{
    Cell[117772, 4310, 390, 10, 70, "Text",
      CellTags->{"S2.13.6", "6.40"}]},
  "S2.13.7"->{
    Cell[118199, 4325, 146, 5, 70, "Subsection",
      CellTags->{"S2.13.7", "7.1"}],
    Cell[118348, 4332, 467, 13, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[118818, 4347, 135, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[118956, 4354, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.2"}],
    Cell[119159, 4363, 101, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[119263, 4367, 97, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[119375, 4372, 195, 6, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.3"}],
    Cell[119595, 4382, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[119677, 4386, 90, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[119782, 4391, 186, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.4"}],
    Cell[119971, 4398, 106, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[120080, 4402, 188, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.5"}],
    Cell[120293, 4411, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[120375, 4415, 91, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[120481, 4420, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.6"}],
    Cell[120613, 4425, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[120695, 4429, 90, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[120800, 4434, 410, 12, 70, "Text",
      CellTags->{"S2.13.7", "7.7"}],
    Cell[121213, 4448, 1205, 30, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[122421, 4480, 130, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[122554, 4487, 275, 9, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.8"}],
    Cell[122854, 4500, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[122936, 4504, 90, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[123041, 4509, 140, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.9"}],
    Cell[123184, 4516, 122, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[123309, 4520, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.10"}],
    Cell[123473, 4529, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[123555, 4533, 87, 5, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[123657, 4541, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.11"}],
    Cell[123826, 4550, 79, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[123908, 4554, 87, 5, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[124010, 4562, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.12"}],
    Cell[124205, 4571, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[124288, 4575, 91, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[124394, 4580, 1264, 36, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[125661, 4618, 145, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[125809, 4625, 811, 26, 70, "Text",
      CellTags->{"S2.13.7", "7.13"}],
    Cell[126623, 4653, 745, 20, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[127371, 4675, 119, 4, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[127493, 4681, 189, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.14"}],
    Cell[127685, 4688, 147, 5, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[127835, 4695, 184, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.15"}],
    Cell[128044, 4704, 92, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[128139, 4708, 264, 6, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[128418, 4717, 564, 18, 70, "Text",
      CellTags->{"S2.13.7", "7.16"}],
    Cell[128985, 4737, 698, 23, 70, "Text",
      CellTags->{"S2.13.7", "7.17"}],
    Cell[129686, 4762, 682, 18, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[130371, 4782, 116, 4, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[130490, 4788, 221, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.18"}],
    Cell[130714, 4797, 115, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[130832, 4801, 135, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.19"}],
    Cell[130992, 4810, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[131075, 4814, 104, 3, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[131194, 4820, 192, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.20"}],
    Cell[131389, 4829, 120, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[131512, 4833, 216, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.21"}],
    Cell[131753, 4844, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[131836, 4848, 88, 5, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[131939, 4856, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.22"}],
    Cell[132120, 4865, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[132203, 4869, 84, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[132302, 4874, 597, 16, 70, "Text",
      CellTags->{"S2.13.7", "7.23"}],
    Cell[132902, 4892, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.24"}],
    Cell[133070, 4899, 146, 5, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[133219, 4906, 182, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.25"}],
    Cell[133426, 4915, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[133509, 4919, 85, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[133609, 4924, 118, 2, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.26"}],
    Cell[133752, 4930, 82, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[133837, 4934, 71, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[133923, 4939, 80, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.27"}],
    Cell[134006, 4942, 109, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[134118, 4946, 202, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.28"}],
    Cell[134345, 4957, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[134428, 4961, 89, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[134532, 4966, 550, 16, 70, "DefinitionBox",
      CellTags->"S2.13.7"],
    Cell[135085, 4984, 138, 5, 70, "Caption",
      CellTags->"S2.13.7"],
    Cell[135226, 4991, 146, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.29"}],
    Cell[135375, 4997, 141, 5, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[135519, 5004, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.30"}],
    Cell[135635, 5009, 82, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[135720, 5013, 71, 2, 70, "Output",
      CellTags->"S2.13.7"],
    Cell[135806, 5018, 81, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.31"}],
    Cell[135890, 5021, 85, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[135978, 5025, 145, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.32"}],
    Cell[136148, 5033, 80, 2, 70, "Input",
      CellTags->"S2.13.7"],
    Cell[136231, 5037, 92, 2, 70, "Output",
      CellTags->"S2.13.7"]},
  "7.1"->{
    Cell[118199, 4325, 146, 5, 70, "Subsection",
      CellTags->{"S2.13.7", "7.1"}]},
  "7.2"->{
    Cell[118956, 4354, 178, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.2"}]},
  "7.3"->{
    Cell[119375, 4372, 195, 6, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.3"}]},
  "7.4"->{
    Cell[119782, 4391, 186, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.4"}]},
  "7.5"->{
    Cell[120080, 4402, 188, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.5"}]},
  "7.6"->{
    Cell[120481, 4420, 107, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.6"}]},
  "7.7"->{
    Cell[120800, 4434, 410, 12, 70, "Text",
      CellTags->{"S2.13.7", "7.7"}]},
  "7.8"->{
    Cell[122554, 4487, 275, 9, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.8"}]},
  "7.9"->{
    Cell[123041, 4509, 140, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.9"}]},
  "7.10"->{
    Cell[123309, 4520, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.10"}]},
  "7.11"->{
    Cell[123657, 4541, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.11"}]},
  "7.12"->{
    Cell[124010, 4562, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.12"}]},
  "7.13"->{
    Cell[125809, 4625, 811, 26, 70, "Text",
      CellTags->{"S2.13.7", "7.13"}]},
  "7.14"->{
    Cell[127493, 4681, 189, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.14"}]},
  "7.15"->{
    Cell[127835, 4695, 184, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.15"}]},
  "7.16"->{
    Cell[128418, 4717, 564, 18, 70, "Text",
      CellTags->{"S2.13.7", "7.16"}]},
  "7.17"->{
    Cell[128985, 4737, 698, 23, 70, "Text",
      CellTags->{"S2.13.7", "7.17"}]},
  "7.18"->{
    Cell[130490, 4788, 221, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.18"}]},
  "7.19"->{
    Cell[130832, 4801, 135, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.19"}]},
  "7.20"->{
    Cell[131194, 4820, 192, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.20"}]},
  "7.21"->{
    Cell[131512, 4833, 216, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.21"}]},
  "7.22"->{
    Cell[131939, 4856, 156, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.22"}]},
  "7.23"->{
    Cell[132302, 4874, 597, 16, 70, "Text",
      CellTags->{"S2.13.7", "7.23"}]},
  "7.24"->{
    Cell[132902, 4892, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.24"}]},
  "7.25"->{
    Cell[133219, 4906, 182, 5, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.25"}]},
  "7.26"->{
    Cell[133609, 4924, 118, 2, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.26"}]},
  "7.27"->{
    Cell[133923, 4939, 80, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.27"}]},
  "7.28"->{
    Cell[134118, 4946, 202, 7, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.28"}]},
  "7.29"->{
    Cell[135226, 4991, 146, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.29"}]},
  "7.30"->{
    Cell[135519, 5004, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.30"}]},
  "7.31"->{
    Cell[135806, 5018, 81, 1, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.31"}]},
  "7.32"->{
    Cell[135978, 5025, 145, 4, 70, "MathCaption",
      CellTags->{"S2.13.7", "7.32"}]},
  "S2.13.8"->{
    Cell[136372, 5045, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.8", "8.1"}],
    Cell[136537, 5052, 437, 14, 70, "Text",
      CellTags->{"S2.13.8", "8.2"}],
    Cell[136977, 5068, 474, 14, 70, "DefinitionBox",
      CellTags->"S2.13.8"],
    Cell[137454, 5084, 93, 1, 70, "Caption",
      CellTags->"S2.13.8"],
    Cell[137550, 5087, 242, 7, 70, "Text",
      CellTags->{"S2.13.8", "8.3"}],
    Cell[137795, 5096, 283, 8, 70, "Text",
      CellTags->{"S2.13.8", "8.4"}],
    Cell[138081, 5106, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.5"}],
    Cell[138149, 5109, 89, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.6"}],
    Cell[138263, 5114, 92, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[138358, 5118, 104, 2, 70, "Output",
      CellTags->"S2.13.8"],
    Cell[138477, 5123, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.7"}],
    Cell[138545, 5126, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.8"}],
    Cell[138672, 5131, 86, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[138761, 5135, 104, 2, 70, "Output",
      CellTags->"S2.13.8"],
    Cell[138880, 5140, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.9"}],
    Cell[139014, 5146, 80, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[139097, 5150, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.10"}],
    Cell[139166, 5153, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.11"}],
    Cell[139333, 5161, 91, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[139427, 5165, 236, 7, 70, "Output",
      CellTags->"S2.13.8"],
    Cell[139678, 5175, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.12"}],
    Cell[139768, 5178, 116, 2, 70, "Input",
      CellTags->"S2.13.8"],
    Cell[139887, 5182, 286, 9, 70, "Text",
      CellTags->{"S2.13.8", "8.13"}],
    Cell[140176, 5193, 424, 12, 70, "Text",
      CellTags->{"S2.13.8", "8.14"}]},
  "8.1"->{
    Cell[136372, 5045, 162, 5, 70, "Subsection",
      CellTags->{"S2.13.8", "8.1"}]},
  "8.2"->{
    Cell[136537, 5052, 437, 14, 70, "Text",
      CellTags->{"S2.13.8", "8.2"}]},
  "8.3"->{
    Cell[137550, 5087, 242, 7, 70, "Text",
      CellTags->{"S2.13.8", "8.3"}]},
  "8.4"->{
    Cell[137795, 5096, 283, 8, 70, "Text",
      CellTags->{"S2.13.8", "8.4"}]},
  "8.5"->{
    Cell[138081, 5106, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.5"}]},
  "8.6"->{
    Cell[138149, 5109, 89, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.6"}]},
  "8.7"->{
    Cell[138477, 5123, 65, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.7"}]},
  "8.8"->{
    Cell[138545, 5126, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.8"}]},
  "8.9"->{
    Cell[138880, 5140, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.9"}]},
  "8.10"->{
    Cell[139097, 5150, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.8", "8.10"}]},
  "8.11"->{
    Cell[139166, 5153, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.11"}]},
  "8.12"->{
    Cell[139678, 5175, 87, 1, 70, "MathCaption",
      CellTags->{"S2.13.8", "8.12"}]},
  "8.13"->{
    Cell[139887, 5182, 286, 9, 70, "Text",
      CellTags->{"S2.13.8", "8.13"}]},
  "8.14"->{
    Cell[140176, 5193, 424, 12, 70, "Text",
      CellTags->{"S2.13.8", "8.14"}]},
  "S2.13.9"->{
    Cell[140637, 5210, 123, 4, 70, "Subsection",
      CellTags->{"S2.13.9", "9.1"}],
    Cell[140763, 5216, 534, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.2"}],
    Cell[141300, 5232, 200, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.3"}],
    Cell[141525, 5241, 93, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[141621, 5245, 108, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[141744, 5251, 197, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.4"}],
    Cell[141966, 5262, 70, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[142039, 5266, 69, 2, 70, "Print",
      CellTags->"S2.13.9"],
    Cell[142111, 5270, 532, 15, 70, "Print",
      CellTags->"S2.13.9"],
    Cell[142658, 5288, 306, 9, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.5"}],
    Cell[142967, 5299, 101, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[143071, 5303, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.6"}],
    Cell[143261, 5312, 79, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[143343, 5316, 103, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[143461, 5322, 548, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.7"}],
    Cell[144012, 5338, 484, 14, 70, "DefinitionBox",
      CellTags->"S2.13.9"],
    Cell[144499, 5354, 114, 4, 70, "Caption",
      CellTags->"S2.13.9"],
    Cell[144616, 5360, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.8"}],
    Cell[144674, 5363, 88, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.9"}],
    Cell[144765, 5369, 176, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.10"}],
    Cell[144944, 5378, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.11"}],
    Cell[145045, 5381, 596, 23, 70, "Program",
      CellTags->{"S2.13.9", "9.12"}],
    Cell[145644, 5406, 173, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.13"}],
    Cell[145820, 5413, 77, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.14"}],
    Cell[145900, 5419, 347, 12, 70, "Program",
      CellTags->{"S2.13.9", "9.15"}],
    Cell[146250, 5433, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.16"}],
    Cell[146312, 5436, 169, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.17"}],
    Cell[146506, 5445, 94, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[146603, 5449, 110, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[146728, 5455, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.18"}],
    Cell[146841, 5460, 94, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[146938, 5464, 110, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[147063, 5470, 141, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.19"}],
    Cell[147229, 5478, 80, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[147312, 5482, 85, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[147412, 5488, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.20"}],
    Cell[147579, 5496, 80, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[147662, 5500, 85, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[147762, 5506, 116, 2, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.21"}],
    Cell[147903, 5512, 80, 2, 70, "Input",
      CellTags->"S2.13.9"],
    Cell[147986, 5516, 85, 3, 70, "Output",
      CellTags->"S2.13.9"],
    Cell[148086, 5522, 314, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.22"}],
    Cell[148403, 5530, 264, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.23"}],
    Cell[148670, 5538, 557, 16, 70, "DefinitionBox",
      CellTags->"S2.13.9"],
    Cell[149230, 5556, 134, 5, 70, "Caption",
      CellTags->"S2.13.9"],
    Cell[149367, 5563, 333, 10, 70, "Text",
      CellTags->{"S2.13.9", "9.24"}],
    Cell[149703, 5575, 462, 13, 70, "Text",
      CellTags->{"S2.13.9", "9.25"}],
    Cell[150168, 5590, 295, 9, 70, "Text",
      CellTags->{"S2.13.9", "9.26"}],
    Cell[150466, 5601, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.27"}],
    Cell[150525, 5604, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.28"}],
    Cell[150583, 5607, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.29"}],
    Cell[150717, 5614, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.30"}],
    Cell[150818, 5617, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.31"}],
    Cell[150999, 5626, 133, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.32"}],
    Cell[151135, 5632, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.33"}],
    Cell[151269, 5638, 82, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.34"}],
    Cell[151354, 5644, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.35"}],
    Cell[151503, 5651, 99, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.36"}],
    Cell[151605, 5654, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.37"}],
    Cell[151765, 5661, 80, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.38"}],
    Cell[151848, 5664, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.39"}],
    Cell[151906, 5667, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.40"}],
    Cell[151968, 5670, 494, 14, 70, "DefinitionBox",
      CellTags->"S2.13.9"],
    Cell[152465, 5686, 119, 5, 70, "Caption",
      CellTags->"S2.13.9"],
    Cell[152587, 5693, 638, 19, 70, "Text",
      CellTags->{"S2.13.9", "9.41"}]},
  "9.1"->{
    Cell[140637, 5210, 123, 4, 70, "Subsection",
      CellTags->{"S2.13.9", "9.1"}]},
  "9.2"->{
    Cell[140763, 5216, 534, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.2"}]},
  "9.3"->{
    Cell[141300, 5232, 200, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.3"}]},
  "9.4"->{
    Cell[141744, 5251, 197, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.4"}]},
  "9.5"->{
    Cell[142658, 5288, 306, 9, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.5"}]},
  "9.6"->{
    Cell[143071, 5303, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.6"}]},
  "9.7"->{
    Cell[143461, 5322, 548, 14, 70, "Text",
      CellTags->{"S2.13.9", "9.7"}]},
  "9.8"->{
    Cell[144616, 5360, 55, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.8"}]},
  "9.9"->{
    Cell[144674, 5363, 88, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.9"}]},
  "9.10"->{
    Cell[144765, 5369, 176, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.10"}]},
  "9.11"->{
    Cell[144944, 5378, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.11"}]},
  "9.12"->{
    Cell[145045, 5381, 596, 23, 70, "Program",
      CellTags->{"S2.13.9", "9.12"}]},
  "9.13"->{
    Cell[145644, 5406, 173, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.13"}]},
  "9.14"->{
    Cell[145820, 5413, 77, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.14"}]},
  "9.15"->{
    Cell[145900, 5419, 347, 12, 70, "Program",
      CellTags->{"S2.13.9", "9.15"}]},
  "9.16"->{
    Cell[146250, 5433, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.16"}]},
  "9.17"->{
    Cell[146312, 5436, 169, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.17"}]},
  "9.18"->{
    Cell[146728, 5455, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.18"}]},
  "9.19"->{
    Cell[147063, 5470, 141, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.19"}]},
  "9.20"->{
    Cell[147412, 5488, 142, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.20"}]},
  "9.21"->{
    Cell[147762, 5506, 116, 2, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.21"}]},
  "9.22"->{
    Cell[148086, 5522, 314, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.22"}]},
  "9.23"->{
    Cell[148403, 5530, 264, 6, 70, "Text",
      CellTags->{"S2.13.9", "9.23"}]},
  "9.24"->{
    Cell[149367, 5563, 333, 10, 70, "Text",
      CellTags->{"S2.13.9", "9.24"}]},
  "9.25"->{
    Cell[149703, 5575, 462, 13, 70, "Text",
      CellTags->{"S2.13.9", "9.25"}]},
  "9.26"->{
    Cell[150168, 5590, 295, 9, 70, "Text",
      CellTags->{"S2.13.9", "9.26"}]},
  "9.27"->{
    Cell[150466, 5601, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.13.9", "9.27"}]},
  "9.28"->{
    Cell[150525, 5604, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.28"}]},
  "9.29"->{
    Cell[150583, 5607, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.29"}]},
  "9.30"->{
    Cell[150717, 5614, 98, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.30"}]},
  "9.31"->{
    Cell[150818, 5617, 178, 7, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.31"}]},
  "9.32"->{
    Cell[150999, 5626, 133, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.32"}]},
  "9.33"->{
    Cell[151135, 5632, 131, 4, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.33"}]},
  "9.34"->{
    Cell[151269, 5638, 82, 4, 70, "Program",
      CellTags->{"S2.13.9", "9.34"}]},
  "9.35"->{
    Cell[151354, 5644, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.35"}]},
  "9.36"->{
    Cell[151503, 5651, 99, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.36"}]},
  "9.37"->{
    Cell[151605, 5654, 157, 5, 70, "MathCaption",
      CellTags->{"S2.13.9", "9.37"}]},
  "9.38"->{
    Cell[151765, 5661, 80, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.38"}]},
  "9.39"->{
    Cell[151848, 5664, 55, 1, 70, "Program",
      CellTags->{"S2.13.9", "9.39"}]},
  "9.40"->{
    Cell[151906, 5667, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.9", "9.40"}]},
  "9.41"->{
    Cell[152587, 5693, 638, 19, 70, "Text",
      CellTags->{"S2.13.9", "9.41"}]},
  "S2.13.10"->{
    Cell[153262, 5717, 117, 2, 70, "Subsection",
      CellTags->{"S2.13.10", "10.1"}],
    Cell[153382, 5721, 455, 10, 70, "Text",
      CellTags->{"S2.13.10", "10.2"}],
    Cell[153840, 5733, 132, 4, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.3"}],
    Cell[153975, 5739, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.4"}],
    Cell[154143, 5746, 109, 4, 70, "Program",
      CellTags->{"S2.13.10", "10.5"}],
    Cell[154255, 5752, 139, 4, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.6"}],
    Cell[154397, 5758, 192, 9, 70, "Program",
      CellTags->{"S2.13.10", "10.7"}],
    Cell[154592, 5769, 157, 5, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.8"}],
    Cell[154752, 5776, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.9"}],
    Cell[154883, 5781, 112, 2, 70, "Input",
      CellTags->"S2.13.10"],
    Cell[154998, 5785, 102, 2, 70, "Output",
      CellTags->"S2.13.10"],
    Cell[155115, 5790, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.10"}],
    Cell[155310, 5799, 70, 2, 70, "Input",
      CellTags->"S2.13.10"],
    Cell[155383, 5803, 72, 2, 70, "Output",
      CellTags->"S2.13.10"],
    Cell[155470, 5808, 560, 12, 70, "Text",
      CellTags->{"S2.13.10", "10.11"}],
    Cell[156033, 5822, 861, 26, 70, "DefinitionBox",
      CellTags->"S2.13.10"],
    Cell[156897, 5850, 93, 1, 70, "Caption",
      CellTags->"S2.13.10"]},
  "10.1"->{
    Cell[153262, 5717, 117, 2, 70, "Subsection",
      CellTags->{"S2.13.10", "10.1"}]},
  "10.2"->{
    Cell[153382, 5721, 455, 10, 70, "Text",
      CellTags->{"S2.13.10", "10.2"}]},
  "10.3"->{
    Cell[153840, 5733, 132, 4, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.3"}]},
  "10.4"->{
    Cell[153975, 5739, 165, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.4"}]},
  "10.5"->{
    Cell[154143, 5746, 109, 4, 70, "Program",
      CellTags->{"S2.13.10", "10.5"}]},
  "10.6"->{
    Cell[154255, 5752, 139, 4, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.6"}]},
  "10.7"->{
    Cell[154397, 5758, 192, 9, 70, "Program",
      CellTags->{"S2.13.10", "10.7"}]},
  "10.8"->{
    Cell[154592, 5769, 157, 5, 70, "SessionLabel",
      CellTags->{"S2.13.10", "10.8"}]},
  "10.9"->{
    Cell[154752, 5776, 106, 1, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.9"}]},
  "10.10"->{
    Cell[155115, 5790, 170, 5, 70, "MathCaption",
      CellTags->{"S2.13.10", "10.10"}]},
  "10.11"->{
    Cell[155470, 5808, 560, 12, 70, "Text",
      CellTags->{"S2.13.10", "10.11"}]},
  "S2.13.11"->{
    Cell[157027, 5856, 131, 4, 70, "Subsection",
      CellTags->{"S2.13.11", "11.1"}],
    Cell[157161, 5862, 201, 5, 70, "Text",
      CellTags->{"S2.13.11", "11.2"}],
    Cell[157365, 5869, 281, 7, 70, "Text",
      CellTags->{"S2.13.11", "11.3"}],
    Cell[157649, 5878, 654, 20, 70, "DefinitionBox",
      CellTags->"S2.13.11"],
    Cell[158306, 5900, 89, 1, 70, "Caption",
      CellTags->"S2.13.11"],
    Cell[158398, 5903, 261, 6, 70, "Text",
      CellTags->{"S2.13.11", "11.4"}],
    Cell[158662, 5911, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.5"}],
    Cell[158731, 5914, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.6"}],
    Cell[158873, 5921, 238, 12, 70, "Program",
      CellTags->{"S2.13.11", "11.7"}],
    Cell[159114, 5935, 84, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.8"}],
    Cell[159201, 5938, 107, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.9"}],
    Cell[159311, 5944, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.10"}],
    Cell[159427, 5947, 193, 9, 70, "Program",
      CellTags->{"S2.13.11", "11.11"}],
    Cell[159623, 5958, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.12"}],
    Cell[159742, 5964, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.13"}],
    Cell[159884, 5970, 112, 2, 70, "Input",
      CellTags->"S2.13.11"],
    Cell[159999, 5974, 102, 2, 70, "Output",
      CellTags->"S2.13.11"],
    Cell[160116, 5979, 135, 4, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.14"}],
    Cell[160254, 5985, 70, 2, 70, "Input",
      CellTags->"S2.13.11"],
    Cell[160327, 5989, 67, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.15"}],
    Cell[160397, 5992, 104, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.16"}],
    Cell[160504, 5995, 116, 5, 70, "Program",
      CellTags->{"S2.13.11", "11.17"}],
    Cell[160623, 6002, 94, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.18"}],
    Cell[160720, 6005, 101, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.19"}],
    Cell[160824, 6011, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.20"}],
    Cell[160943, 6017, 117, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.21"}],
    Cell[161063, 6024, 72, 2, 70, "Output",
      CellTags->"S2.13.11"]},
  "11.1"->{
    Cell[157027, 5856, 131, 4, 70, "Subsection",
      CellTags->{"S2.13.11", "11.1"}]},
  "11.2"->{
    Cell[157161, 5862, 201, 5, 70, "Text",
      CellTags->{"S2.13.11", "11.2"}]},
  "11.3"->{
    Cell[157365, 5869, 281, 7, 70, "Text",
      CellTags->{"S2.13.11", "11.3"}]},
  "11.4"->{
    Cell[158398, 5903, 261, 6, 70, "Text",
      CellTags->{"S2.13.11", "11.4"}]},
  "11.5"->{
    Cell[158662, 5911, 66, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.5"}]},
  "11.6"->{
    Cell[158731, 5914, 139, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.6"}]},
  "11.7"->{
    Cell[158873, 5921, 238, 12, 70, "Program",
      CellTags->{"S2.13.11", "11.7"}]},
  "11.8"->{
    Cell[159114, 5935, 84, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.8"}]},
  "11.9"->{
    Cell[159201, 5938, 107, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.9"}]},
  "11.10"->{
    Cell[159311, 5944, 113, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.10"}]},
  "11.11"->{
    Cell[159427, 5947, 193, 9, 70, "Program",
      CellTags->{"S2.13.11", "11.11"}]},
  "11.12"->{
    Cell[159623, 5958, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.12"}]},
  "11.13"->{
    Cell[159742, 5964, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.13"}]},
  "11.14"->{
    Cell[160116, 5979, 135, 4, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.14"}]},
  "11.15"->{
    Cell[160327, 5989, 67, 1, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.15"}]},
  "11.16"->{
    Cell[160397, 5992, 104, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.16"}]},
  "11.17"->{
    Cell[160504, 5995, 116, 5, 70, "Program",
      CellTags->{"S2.13.11", "11.17"}]},
  "11.18"->{
    Cell[160623, 6002, 94, 1, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.18"}]},
  "11.19"->{
    Cell[160720, 6005, 101, 4, 70, "Program",
      CellTags->{"S2.13.11", "11.19"}]},
  "11.20"->{
    Cell[160824, 6011, 116, 4, 70, "SessionLabel",
      CellTags->{"S2.13.11", "11.20"}]},
  "11.21"->{
    Cell[160943, 6017, 117, 5, 70, "MathCaption",
      CellTags->{"S2.13.11", "11.21"}]},
  "S2.13.12"->{
    Cell[161172, 6031, 109, 1, 70, "Subsection",
      CellTags->{"S2.13.12", "12.1"}],
    Cell[161284, 6034, 705, 15, 70, "Text",
      CellTags->{"S2.13.12", "12.2"}],
    Cell[161992, 6051, 1145, 32, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[163140, 6085, 86, 1, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[163229, 6088, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.3"}],
    Cell[163289, 6091, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.4"}],
    Cell[163348, 6094, 85, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.5"}],
    Cell[163436, 6097, 89, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.6"}],
    Cell[163528, 6100, 190, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.7"}],
    Cell[163721, 6109, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.8"}],
    Cell[163866, 6116, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.9"}],
    Cell[163925, 6119, 112, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.10"}],
    Cell[164040, 6122, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.11"}],
    Cell[164185, 6129, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.12"}],
    Cell[164245, 6132, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.13"}],
    Cell[164343, 6135, 66, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.14"}],
    Cell[164412, 6138, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.15"}],
    Cell[164476, 6141, 310, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.16"}],
    Cell[164789, 6152, 313, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.17"}],
    Cell[165105, 6164, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.18"}],
    Cell[165166, 6167, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.19"}],
    Cell[165226, 6170, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.20"}],
    Cell[165373, 6177, 122, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.21"}],
    Cell[165498, 6183, 180, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.22"}],
    Cell[165681, 6192, 99, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.23"}],
    Cell[165783, 6195, 187, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.24"}],
    Cell[165973, 6204, 88, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.25"}],
    Cell[166064, 6207, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.26"}],
    Cell[166128, 6210, 208, 5, 70, "Text",
      CellTags->{"S2.13.12", "12.27"}],
    Cell[166339, 6217, 406, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.28"}],
    Cell[166748, 6229, 1335, 38, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[168086, 6269, 123, 5, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[168212, 6276, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.29"}],
    Cell[168273, 6279, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.30"}],
    Cell[168333, 6282, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.31"}],
    Cell[168485, 6289, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.32"}],
    Cell[168563, 6292, 130, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.33"}],
    Cell[168696, 6299, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.34"}],
    Cell[168774, 6302, 120, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.35"}],
    Cell[168897, 6309, 84, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.36"}],
    Cell[168984, 6315, 195, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.37"}],
    Cell[169182, 6324, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.38"}],
    Cell[169260, 6327, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.39"}],
    Cell[169380, 6331, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.40"}],
    Cell[169461, 6334, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.41"}],
    Cell[169589, 6341, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.42"}],
    Cell[169667, 6344, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.43"}],
    Cell[169795, 6351, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.44"}],
    Cell[169873, 6354, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.45"}],
    Cell[169978, 6357, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.46"}],
    Cell[170059, 6360, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.47"}],
    Cell[170193, 6367, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.48"}],
    Cell[170271, 6370, 179, 4, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.49"}],
    Cell[170453, 6376, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.50"}],
    Cell[170534, 6379, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.51"}],
    Cell[170598, 6382, 480, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.52"}],
    Cell[171081, 6394, 2157, 59, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[173241, 6455, 100, 1, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[173344, 6458, 1005, 33, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[174352, 6493, 122, 5, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[174477, 6500, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.53"}],
    Cell[174538, 6503, 77, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.54"}],
    Cell[174618, 6506, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.55"}],
    Cell[174712, 6509, 511, 17, 70, "Program",
      CellTags->{"S2.13.12", "12.56"}],
    Cell[175226, 6528, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.57"}],
    Cell[175315, 6531, 124, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.58"}],
    Cell[175442, 6538, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.59"}],
    Cell[175533, 6541, 122, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.60"}],
    Cell[175658, 6548, 55, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.61"}],
    Cell[175716, 6551, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.62"}],
    Cell[175780, 6554, 359, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.63"}],
    Cell[176142, 6565, 393, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.64"}],
    Cell[176538, 6577, 2172, 59, 70, "DefinitionBox",
      CellTags->"S2.13.12"],
    Cell[178713, 6638, 100, 1, 70, "Caption",
      CellTags->"S2.13.12"],
    Cell[178816, 6641, 314, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.65"}]},
  "12.1"->{
    Cell[161172, 6031, 109, 1, 70, "Subsection",
      CellTags->{"S2.13.12", "12.1"}]},
  "12.2"->{
    Cell[161284, 6034, 705, 15, 70, "Text",
      CellTags->{"S2.13.12", "12.2"}]},
  "12.3"->{
    Cell[163229, 6088, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.3"}]},
  "12.4"->{
    Cell[163289, 6091, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.4"}]},
  "12.5"->{
    Cell[163348, 6094, 85, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.5"}]},
  "12.6"->{
    Cell[163436, 6097, 89, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.6"}]},
  "12.7"->{
    Cell[163528, 6100, 190, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.7"}]},
  "12.8"->{
    Cell[163721, 6109, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.8"}]},
  "12.9"->{
    Cell[163866, 6116, 56, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.9"}]},
  "12.10"->{
    Cell[163925, 6119, 112, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.10"}]},
  "12.11"->{
    Cell[164040, 6122, 142, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.11"}]},
  "12.12"->{
    Cell[164185, 6129, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.12"}]},
  "12.13"->{
    Cell[164245, 6132, 95, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.13"}]},
  "12.14"->{
    Cell[164343, 6135, 66, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.14"}]},
  "12.15"->{
    Cell[164412, 6138, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.15"}]},
  "12.16"->{
    Cell[164476, 6141, 310, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.16"}]},
  "12.17"->{
    Cell[164789, 6152, 313, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.17"}]},
  "12.18"->{
    Cell[165105, 6164, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.18"}]},
  "12.19"->{
    Cell[165166, 6167, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.19"}]},
  "12.20"->{
    Cell[165226, 6170, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.20"}]},
  "12.21"->{
    Cell[165373, 6177, 122, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.21"}]},
  "12.22"->{
    Cell[165498, 6183, 180, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.22"}]},
  "12.23"->{
    Cell[165681, 6192, 99, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.23"}]},
  "12.24"->{
    Cell[165783, 6195, 187, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.24"}]},
  "12.25"->{
    Cell[165973, 6204, 88, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.25"}]},
  "12.26"->{
    Cell[166064, 6207, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.26"}]},
  "12.27"->{
    Cell[166128, 6210, 208, 5, 70, "Text",
      CellTags->{"S2.13.12", "12.27"}]},
  "12.28"->{
    Cell[166339, 6217, 406, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.28"}]},
  "12.29"->{
    Cell[168212, 6276, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.29"}]},
  "12.30"->{
    Cell[168273, 6279, 57, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.30"}]},
  "12.31"->{
    Cell[168333, 6282, 149, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.31"}]},
  "12.32"->{
    Cell[168485, 6289, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.32"}]},
  "12.33"->{
    Cell[168563, 6292, 130, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.33"}]},
  "12.34"->{
    Cell[168696, 6299, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.34"}]},
  "12.35"->{
    Cell[168774, 6302, 120, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.35"}]},
  "12.36"->{
    Cell[168897, 6309, 84, 4, 70, "Program",
      CellTags->{"S2.13.12", "12.36"}]},
  "12.37"->{
    Cell[168984, 6315, 195, 7, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.37"}]},
  "12.38"->{
    Cell[169182, 6324, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.38"}]},
  "12.39"->{
    Cell[169260, 6327, 117, 2, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.39"}]},
  "12.40"->{
    Cell[169380, 6331, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.40"}]},
  "12.41"->{
    Cell[169461, 6334, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.41"}]},
  "12.42"->{
    Cell[169589, 6341, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.42"}]},
  "12.43"->{
    Cell[169667, 6344, 125, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.43"}]},
  "12.44"->{
    Cell[169795, 6351, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.44"}]},
  "12.45"->{
    Cell[169873, 6354, 102, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.45"}]},
  "12.46"->{
    Cell[169978, 6357, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.46"}]},
  "12.47"->{
    Cell[170059, 6360, 131, 5, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.47"}]},
  "12.48"->{
    Cell[170193, 6367, 75, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.48"}]},
  "12.49"->{
    Cell[170271, 6370, 179, 4, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.49"}]},
  "12.50"->{
    Cell[170453, 6376, 78, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.50"}]},
  "12.51"->{
    Cell[170534, 6379, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.51"}]},
  "12.52"->{
    Cell[170598, 6382, 480, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.52"}]},
  "12.53"->{
    Cell[174477, 6500, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.12", "12.53"}]},
  "12.54"->{
    Cell[174538, 6503, 77, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.54"}]},
  "12.55"->{
    Cell[174618, 6506, 91, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.55"}]},
  "12.56"->{
    Cell[174712, 6509, 511, 17, 70, "Program",
      CellTags->{"S2.13.12", "12.56"}]},
  "12.57"->{
    Cell[175226, 6528, 86, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.57"}]},
  "12.58"->{
    Cell[175315, 6531, 124, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.58"}]},
  "12.59"->{
    Cell[175442, 6538, 88, 1, 70, "MathCaption",
      CellTags->{"S2.13.12", "12.59"}]},
  "12.60"->{
    Cell[175533, 6541, 122, 5, 70, "Program",
      CellTags->{"S2.13.12", "12.60"}]},
  "12.61"->{
    Cell[175658, 6548, 55, 1, 70, "Program",
      CellTags->{"S2.13.12", "12.61"}]},
  "12.62"->{
    Cell[175716, 6551, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.12", "12.62"}]},
  "12.63"->{
    Cell[175780, 6554, 359, 9, 70, "Text",
      CellTags->{"S2.13.12", "12.63"}]},
  "12.64"->{
    Cell[176142, 6565, 393, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.64"}]},
  "12.65"->{
    Cell[178816, 6641, 314, 10, 70, "Text",
      CellTags->{"S2.13.12", "12.65"}]},
  "S2.13.13"->{
    Cell[179167, 6656, 108, 1, 70, "Subsection",
      CellTags->{"S2.13.13", "13.1"}],
    Cell[179278, 6659, 375, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.2"}],
    Cell[179656, 6670, 1223, 33, 70, "DefinitionBox",
      CellTags->"S2.13.13"],
    Cell[180882, 6705, 125, 5, 70, "Caption",
      CellTags->"S2.13.13"],
    Cell[181010, 6712, 320, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.3"}],
    Cell[181333, 6723, 446, 12, 70, "DefinitionBox",
      CellTags->"S2.13.13"],
    Cell[181782, 6737, 81, 1, 70, "Caption",
      CellTags->"S2.13.13"],
    Cell[181866, 6740, 260, 7, 70, "Text",
      CellTags->{"S2.13.13", "13.4"}],
    Cell[182129, 6749, 695, 14, 70, "Text",
      CellTags->{"S2.13.13", "13.5"}],
    Cell[182827, 6765, 550, 16, 70, "DefinitionBox",
      CellTags->"S2.13.13"],
    Cell[183380, 6783, 73, 1, 70, "Caption",
      CellTags->"S2.13.13"],
    Cell[183456, 6786, 452, 11, 70, "Text",
      CellTags->{"S2.13.13", "13.6"}],
    Cell[183911, 6799, 387, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.7"}]},
  "13.1"->{
    Cell[179167, 6656, 108, 1, 70, "Subsection",
      CellTags->{"S2.13.13", "13.1"}]},
  "13.2"->{
    Cell[179278, 6659, 375, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.2"}]},
  "13.3"->{
    Cell[181010, 6712, 320, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.3"}]},
  "13.4"->{
    Cell[181866, 6740, 260, 7, 70, "Text",
      CellTags->{"S2.13.13", "13.4"}]},
  "13.5"->{
    Cell[182129, 6749, 695, 14, 70, "Text",
      CellTags->{"S2.13.13", "13.5"}]},
  "13.6"->{
    Cell[183456, 6786, 452, 11, 70, "Text",
      CellTags->{"S2.13.13", "13.6"}]},
  "13.7"->{
    Cell[183911, 6799, 387, 9, 70, "Text",
      CellTags->{"S2.13.13", "13.7"}]},
  "S2.13.14"->{
    Cell[184335, 6813, 160, 5, 70, "Subsection",
      CellTags->{"S2.13.14", "14.1"}],
    Cell[184498, 6820, 363, 12, 70, "Text",
      CellTags->{"S2.13.14", "14.2"}],
    Cell[184864, 6834, 633, 18, 70, "Text",
      CellTags->{"S2.13.14", "14.3"}],
    Cell[185500, 6854, 2733, 78, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[188236, 6934, 129, 5, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[188368, 6941, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.14", "14.4"}],
    Cell[188428, 6944, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.5"}],
    Cell[188575, 6951, 85, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.6"}],
    Cell[188663, 6957, 87, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.7"}],
    Cell[188753, 6960, 105, 6, 70, "Program",
      CellTags->{"S2.13.14", "14.8"}],
    Cell[188861, 6968, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.9"}],
    Cell[189010, 6975, 79, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.10"}],
    Cell[189092, 6978, 199, 6, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.11"}],
    Cell[189294, 6986, 105, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.12"}],
    Cell[189402, 6989, 140, 4, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.13"}],
    Cell[189545, 6995, 74, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.14"}],
    Cell[189622, 6998, 70, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.15"}],
    Cell[189695, 7004, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.14", "14.16"}],
    Cell[189759, 7007, 586, 19, 70, "Text",
      CellTags->{"S2.13.14", "14.17"}],
    Cell[190348, 7028, 375, 14, 70, "Text",
      CellTags->{"S2.13.14", "14.18"}],
    Cell[190726, 7044, 1789, 54, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[192518, 7100, 174, 7, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[192695, 7109, 278, 8, 70, "Text",
      CellTags->{"S2.13.14", "14.19"}],
    Cell[192976, 7119, 305, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.20"}],
    Cell[193284, 7130, 913, 24, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[194200, 7156, 154, 5, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[194357, 7163, 312, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.21"}],
    Cell[194672, 7174, 284, 7, 70, "Text",
      CellTags->{"S2.13.14", "14.22"}],
    Cell[194959, 7183, 249, 6, 70, "Text",
      CellTags->{"S2.13.14", "14.23"}],
    Cell[195211, 7191, 4186, 120, 70, "DefinitionBox3Col",
      CellTags->"S2.13.14"],
    Cell[199400, 7313, 130, 5, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[199533, 7320, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.14", "14.24"}],
    Cell[199594, 7323, 201, 6, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.25"}],
    Cell[199798, 7331, 135, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.26"}],
    Cell[199936, 7337, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.14", "14.27"}],
    Cell[200000, 7340, 407, 11, 70, "Text",
      CellTags->{"S2.13.14", "14.28"}],
    Cell[200410, 7353, 196, 6, 70, "Text",
      CellTags->{"S2.13.14", "14.29"}],
    Cell[200609, 7361, 756, 23, 70, "DefinitionBox",
      CellTags->"S2.13.14"],
    Cell[201368, 7386, 66, 1, 70, "Caption",
      CellTags->"S2.13.14"],
    Cell[201437, 7389, 505, 12, 70, "Text",
      CellTags->{"S2.13.14", "14.30"}],
    Cell[201945, 7403, 466, 17, 70, "Text",
      CellTags->{"S2.13.14", "14.31"}],
    Cell[202414, 7422, 397, 10, 70, "Text",
      CellTags->{"S2.13.14", "14.32"}]},
  "14.1"->{
    Cell[184335, 6813, 160, 5, 70, "Subsection",
      CellTags->{"S2.13.14", "14.1"}]},
  "14.2"->{
    Cell[184498, 6820, 363, 12, 70, "Text",
      CellTags->{"S2.13.14", "14.2"}]},
  "14.3"->{
    Cell[184864, 6834, 633, 18, 70, "Text",
      CellTags->{"S2.13.14", "14.3"}]},
  "14.4"->{
    Cell[188368, 6941, 57, 1, 70, "ProgramTop",
      CellTags->{"S2.13.14", "14.4"}]},
  "14.5"->{
    Cell[188428, 6944, 144, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.5"}]},
  "14.6"->{
    Cell[188575, 6951, 85, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.6"}]},
  "14.7"->{
    Cell[188663, 6957, 87, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.7"}]},
  "14.8"->{
    Cell[188753, 6960, 105, 6, 70, "Program",
      CellTags->{"S2.13.14", "14.8"}]},
  "14.9"->{
    Cell[188861, 6968, 146, 5, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.9"}]},
  "14.10"->{
    Cell[189010, 6975, 79, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.10"}]},
  "14.11"->{
    Cell[189092, 6978, 199, 6, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.11"}]},
  "14.12"->{
    Cell[189294, 6986, 105, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.12"}]},
  "14.13"->{
    Cell[189402, 6989, 140, 4, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.13"}]},
  "14.14"->{
    Cell[189545, 6995, 74, 1, 70, "Program",
      CellTags->{"S2.13.14", "14.14"}]},
  "14.15"->{
    Cell[189622, 6998, 70, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.15"}]},
  "14.16"->{
    Cell[189695, 7004, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.14", "14.16"}]},
  "14.17"->{
    Cell[189759, 7007, 586, 19, 70, "Text",
      CellTags->{"S2.13.14", "14.17"}]},
  "14.18"->{
    Cell[190348, 7028, 375, 14, 70, "Text",
      CellTags->{"S2.13.14", "14.18"}]},
  "14.19"->{
    Cell[192695, 7109, 278, 8, 70, "Text",
      CellTags->{"S2.13.14", "14.19"}]},
  "14.20"->{
    Cell[192976, 7119, 305, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.20"}]},
  "14.21"->{
    Cell[194357, 7163, 312, 9, 70, "Text",
      CellTags->{"S2.13.14", "14.21"}]},
  "14.22"->{
    Cell[194672, 7174, 284, 7, 70, "Text",
      CellTags->{"S2.13.14", "14.22"}]},
  "14.23"->{
    Cell[194959, 7183, 249, 6, 70, "Text",
      CellTags->{"S2.13.14", "14.23"}]},
  "14.24"->{
    Cell[199533, 7320, 58, 1, 70, "ProgramTop",
      CellTags->{"S2.13.14", "14.24"}]},
  "14.25"->{
    Cell[199594, 7323, 201, 6, 70, "MathCaption",
      CellTags->{"S2.13.14", "14.25"}]},
  "14.26"->{
    Cell[199798, 7331, 135, 4, 70, "Program",
      CellTags->{"S2.13.14", "14.26"}]},
  "14.27"->{
    Cell[199936, 7337, 61, 1, 70, "ProgramBottom",
      CellTags->{"S2.13.14", "14.27"}]},
  "14.28"->{
    Cell[200000, 7340, 407, 11, 70, "Text",
      CellTags->{"S2.13.14", "14.28"}]},
  "14.29"->{
    Cell[200410, 7353, 196, 6, 70, "Text",
      CellTags->{"S2.13.14", "14.29"}]},
  "14.30"->{
    Cell[201437, 7389, 505, 12, 70, "Text",
      CellTags->{"S2.13.14", "14.30"}]},
  "14.31"->{
    Cell[201945, 7403, 466, 17, 70, "Text",
      CellTags->{"S2.13.14", "14.31"}]},
  "14.32"->{
    Cell[202414, 7422, 397, 10, 70, "Text",
      CellTags->{"S2.13.14", "14.32"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.13.0", 203455, 7452},
  {"0.1", 203546, 7455},
  {"S2.13.1", 203641, 7458},
  {"1.1", 205089, 7497},
  {"1.2", 205183, 7500},
  {"1.3", 205272, 7503},
  {"1.4", 205361, 7506},
  {"1.5", 205450, 7509},
  {"1.6", 205539, 7512},
  {"1.7", 205628, 7515},
  {"1.8", 205718, 7518},
  {"1.9", 205808, 7521},
  {"1.10", 205898, 7524},
  {"1.11", 205989, 7527},
  {"S2.13.2", 206083, 7530},
  {"2.1", 207467, 7567},
  {"2.2", 207562, 7570},
  {"2.3", 207652, 7573},
  {"2.4", 207749, 7576},
  {"2.5", 207846, 7579},
  {"2.6", 207943, 7582},
  {"2.7", 208033, 7585},
  {"2.8", 208124, 7588},
  {"S2.13.3", 208219, 7591},
  {"3.1", 216885, 7806},
  {"3.2", 216981, 7809},
  {"3.3", 217071, 7812},
  {"3.4", 217161, 7815},
  {"3.5", 217256, 7818},
  {"3.6", 217349, 7821},
  {"3.7", 217447, 7824},
  {"3.8", 217538, 7827},
  {"3.9", 217633, 7830},
  {"3.10", 217731, 7833},
  {"3.11", 217825, 7836},
  {"3.12", 217924, 7839},
  {"3.13", 218020, 7842},
  {"3.14", 218119, 7845},
  {"3.15", 218215, 7848},
  {"3.16", 218315, 7851},
  {"3.17", 218407, 7854},
  {"3.18", 218499, 7857},
  {"3.19", 218591, 7860},
  {"3.20", 218684, 7863},
  {"3.21", 218781, 7866},
  {"3.22", 218880, 7869},
  {"3.23", 218974, 7872},
  {"3.24", 219074, 7875},
  {"3.25", 219173, 7878},
  {"3.26", 219273, 7881},
  {"3.27", 219372, 7884},
  {"3.28", 219465, 7887},
  {"3.29", 219564, 7890},
  {"3.30", 219663, 7893},
  {"3.31", 219762, 7896},
  {"3.32", 219855, 7899},
  {"3.33", 219953, 7902},
  {"3.34", 220048, 7905},
  {"3.35", 220148, 7908},
  {"3.36", 220243, 7911},
  {"3.37", 220343, 7914},
  {"3.38", 220438, 7917},
  {"3.39", 220538, 7920},
  {"3.40", 220635, 7923},
  {"3.41", 220735, 7926},
  {"3.42", 220832, 7929},
  {"3.43", 220932, 7932},
  {"3.44", 221027, 7935},
  {"3.45", 221122, 7938},
  {"3.46", 221223, 7941},
  {"3.47", 221317, 7944},
  {"3.48", 221410, 7947},
  {"3.49", 221504, 7950},
  {"3.50", 221602, 7953},
  {"3.51", 221702, 7956},
  {"3.52", 221798, 7959},
  {"3.53", 221899, 7962},
  {"3.54", 221993, 7965},
  {"3.55", 222091, 7968},
  {"3.56", 222191, 7971},
  {"3.57", 222287, 7974},
  {"3.58", 222387, 7977},
  {"3.59", 222484, 7980},
  {"3.60", 222585, 7983},
  {"3.61", 222682, 7986},
  {"3.62", 222782, 7989},
  {"3.63", 222878, 7992},
  {"3.64", 222979, 7995},
  {"3.65", 223077, 7998},
  {"3.66", 223177, 8001},
  {"3.67", 223274, 8004},
  {"3.68", 223375, 8007},
  {"3.69", 223472, 8010},
  {"3.70", 223573, 8013},
  {"3.71", 223667, 8016},
  {"3.72", 223765, 8019},
  {"3.73", 223860, 8022},
  {"3.74", 223961, 8025},
  {"3.75", 224057, 8028},
  {"3.76", 224152, 8031},
  {"3.77", 224253, 8034},
  {"3.78", 224353, 8037},
  {"3.79", 224453, 8040},
  {"S2.13.4", 224550, 8043},
  {"4.1", 241489, 8454},
  {"4.2", 241586, 8457},
  {"4.3", 241678, 8460},
  {"4.4", 241774, 8463},
  {"4.5", 241872, 8466},
  {"4.6", 241967, 8469},
  {"4.7", 242065, 8472},
  {"4.8", 242160, 8475},
  {"4.9", 242259, 8478},
  {"4.10", 242358, 8481},
  {"4.11", 242457, 8484},
  {"4.12", 242557, 8487},
  {"4.13", 242657, 8490},
  {"4.14", 242750, 8493},
  {"4.15", 242848, 8496},
  {"4.16", 242948, 8499},
  {"4.17", 243045, 8502},
  {"4.18", 243145, 8505},
  {"4.19", 243241, 8508},
  {"4.20", 243342, 8511},
  {"4.21", 243435, 8514},
  {"4.22", 243529, 8517},
  {"4.23", 243623, 8520},
  {"4.24", 243717, 8523},
  {"4.25", 243815, 8526},
  {"4.26", 243915, 8529},
  {"4.27", 244012, 8532},
  {"4.28", 244112, 8535},
  {"4.29", 244207, 8538},
  {"4.30", 244307, 8541},
  {"4.31", 244404, 8544},
  {"4.32", 244504, 8547},
  {"4.33", 244600, 8550},
  {"4.34", 244701, 8553},
  {"4.35", 244801, 8556},
  {"4.36", 244901, 8559},
  {"4.37", 244995, 8562},
  {"4.38", 245093, 8565},
  {"4.39", 245188, 8568},
  {"4.40", 245288, 8571},
  {"4.41", 245383, 8574},
  {"4.42", 245483, 8577},
  {"4.43", 245580, 8580},
  {"4.44", 245675, 8583},
  {"4.45", 245775, 8586},
  {"4.46", 245871, 8589},
  {"4.47", 245966, 8592},
  {"4.48", 246067, 8595},
  {"4.49", 246161, 8598},
  {"4.50", 246259, 8601},
  {"4.51", 246359, 8604},
  {"4.52", 246454, 8607},
  {"4.53", 246554, 8610},
  {"4.54", 246649, 8613},
  {"4.55", 246749, 8616},
  {"4.56", 246844, 8619},
  {"4.57", 246945, 8622},
  {"4.58", 247039, 8625},
  {"4.59", 247137, 8628},
  {"4.60", 247237, 8631},
  {"4.61", 247332, 8634},
  {"4.62", 247432, 8637},
  {"4.63", 247527, 8640},
  {"4.64", 247627, 8643},
  {"4.65", 247722, 8646},
  {"4.66", 247822, 8649},
  {"4.67", 247917, 8652},
  {"4.68", 248016, 8655},
  {"4.69", 248111, 8658},
  {"4.70", 248212, 8661},
  {"4.71", 248306, 8664},
  {"4.72", 248404, 8667},
  {"4.73", 248499, 8670},
  {"4.74", 248599, 8673},
  {"4.75", 248694, 8676},
  {"4.76", 248789, 8679},
  {"4.77", 248889, 8682},
  {"4.78", 248984, 8685},
  {"4.79", 249079, 8688},
  {"4.80", 249179, 8691},
  {"4.81", 249274, 8694},
  {"4.82", 249369, 8697},
  {"4.83", 249468, 8700},
  {"4.84", 249563, 8703},
  {"4.85", 249658, 8706},
  {"4.86", 249753, 8709},
  {"4.87", 249854, 8712},
  {"4.88", 249948, 8715},
  {"4.89", 250041, 8718},
  {"4.90", 250141, 8721},
  {"4.91", 250241, 8724},
  {"4.92", 250341, 8727},
  {"4.93", 250441, 8730},
  {"4.94", 250534, 8733},
  {"4.95", 250632, 8736},
  {"4.96", 250732, 8739},
  {"4.97", 250827, 8742},
  {"4.98", 250923, 8745},
  {"4.99", 251023, 8748},
  {"4.100", 251119, 8751},
  {"4.101", 251220, 8754},
  {"4.102", 251318, 8757},
  {"4.103", 251415, 8760},
  {"4.104", 251517, 8763},
  {"4.105", 251614, 8766},
  {"4.106", 251717, 8769},
  {"4.107", 251813, 8772},
  {"4.108", 251909, 8775},
  {"4.109", 252009, 8778},
  {"4.110", 252106, 8781},
  {"4.111", 252208, 8784},
  {"4.112", 252305, 8787},
  {"4.113", 252407, 8790},
  {"4.114", 252506, 8793},
  {"4.115", 252608, 8796},
  {"4.116", 252707, 8799},
  {"4.117", 252804, 8802},
  {"4.118", 252906, 8805},
  {"4.119", 253003, 8808},
  {"4.120", 253105, 8811},
  {"4.121", 253202, 8814},
  {"4.122", 253304, 8817},
  {"4.123", 253402, 8820},
  {"4.124", 253499, 8823},
  {"4.125", 253602, 8826},
  {"4.126", 253698, 8829},
  {"4.127", 253798, 8832},
  {"4.128", 253895, 8835},
  {"4.129", 253997, 8838},
  {"4.130", 254096, 8841},
  {"4.131", 254198, 8844},
  {"4.132", 254297, 8847},
  {"4.133", 254399, 8850},
  {"4.134", 254498, 8853},
  {"4.135", 254595, 8856},
  {"4.136", 254697, 8859},
  {"4.137", 254794, 8862},
  {"4.138", 254895, 8865},
  {"4.139", 254992, 8868},
  {"4.140", 255094, 8871},
  {"4.141", 255192, 8874},
  {"4.142", 255294, 8877},
  {"4.143", 255392, 8880},
  {"4.144", 255489, 8883},
  {"4.145", 255592, 8886},
  {"4.146", 255687, 8889},
  {"4.147", 255782, 8892},
  {"4.148", 255878, 8895},
  {"4.149", 255973, 8898},
  {"4.150", 256069, 8901},
  {"4.151", 256169, 8904},
  {"4.152", 256271, 8907},
  {"4.153", 256368, 8910},
  {"4.154", 256470, 8913},
  {"4.155", 256567, 8916},
  {"4.156", 256669, 8919},
  {"4.157", 256767, 8922},
  {"4.158", 256864, 8925},
  {"4.159", 256966, 8928},
  {"4.160", 257063, 8931},
  {"4.161", 257160, 8934},
  {"4.162", 257263, 8937},
  {"4.163", 257359, 8940},
  {"4.164", 257455, 8943},
  {"4.165", 257551, 8946},
  {"4.166", 257647, 8949},
  {"4.167", 257743, 8952},
  {"4.168", 257839, 8955},
  {"4.169", 257935, 8958},
  {"S2.13.5", 258033, 8961},
  {"5.1", 260026, 9012},
  {"5.2", 260123, 9015},
  {"5.3", 260214, 9018},
  {"5.4", 260306, 9021},
  {"5.5", 260398, 9024},
  {"5.6", 260489, 9027},
  {"5.7", 260580, 9030},
  {"5.8", 260671, 9033},
  {"5.9", 260763, 9036},
  {"5.10", 260856, 9039},
  {"5.11", 260950, 9042},
  {"5.12", 261045, 9045},
  {"5.13", 261140, 9048},
  {"5.14", 261235, 9051},
  {"5.15", 261330, 9054},
  {"S2.13.6", 261428, 9057},
  {"6.1", 267277, 9204},
  {"6.2", 267375, 9207},
  {"6.3", 267474, 9210},
  {"6.4", 267572, 9213},
  {"6.5", 267671, 9216},
  {"6.6", 267769, 9219},
  {"6.7", 267868, 9222},
  {"6.8", 267967, 9225},
  {"6.9", 268066, 9228},
  {"6.10", 268166, 9231},
  {"6.11", 268266, 9234},
  {"6.12", 268367, 9237},
  {"6.13", 268468, 9240},
  {"6.14", 268562, 9243},
  {"6.15", 268656, 9246},
  {"6.16", 268757, 9249},
  {"6.17", 268858, 9252},
  {"6.18", 268959, 9255},
  {"6.19", 269060, 9258},
  {"6.20", 269160, 9261},
  {"6.21", 269255, 9264},
  {"6.22", 269350, 9267},
  {"6.23", 269451, 9270},
  {"6.24", 269552, 9273},
  {"6.25", 269653, 9276},
  {"6.26", 269753, 9279},
  {"6.27", 269854, 9282},
  {"6.28", 269955, 9285},
  {"6.29", 270056, 9288},
  {"6.30", 270150, 9291},
  {"6.31", 270244, 9294},
  {"6.32", 270338, 9297},
  {"6.33", 270440, 9300},
  {"6.34", 270541, 9303},
  {"6.35", 270643, 9306},
  {"6.36", 270744, 9309},
  {"6.37", 270845, 9312},
  {"6.38", 270947, 9315},
  {"6.39", 271048, 9318},
  {"6.40", 271142, 9321},
  {"S2.13.7", 271240, 9324},
  {"7.1", 278038, 9499},
  {"7.2", 278136, 9502},
  {"7.3", 278235, 9505},
  {"7.4", 278334, 9508},
  {"7.5", 278433, 9511},
  {"7.6", 278532, 9514},
  {"7.7", 278631, 9517},
  {"7.8", 278724, 9520},
  {"7.9", 278823, 9523},
  {"7.10", 278923, 9526},
  {"7.11", 279024, 9529},
  {"7.12", 279125, 9532},
  {"7.13", 279226, 9535},
  {"7.14", 279321, 9538},
  {"7.15", 279422, 9541},
  {"7.16", 279523, 9544},
  {"7.17", 279618, 9547},
  {"7.18", 279713, 9550},
  {"7.19", 279814, 9553},
  {"7.20", 279915, 9556},
  {"7.21", 280016, 9559},
  {"7.22", 280117, 9562},
  {"7.23", 280218, 9565},
  {"7.24", 280313, 9568},
  {"7.25", 280414, 9571},
  {"7.26", 280515, 9574},
  {"7.27", 280616, 9577},
  {"7.28", 280716, 9580},
  {"7.29", 280817, 9583},
  {"7.30", 280918, 9586},
  {"7.31", 281018, 9589},
  {"7.32", 281118, 9592},
  {"S2.13.8", 281222, 9595},
  {"8.1", 283150, 9644},
  {"8.2", 283248, 9647},
  {"8.3", 283341, 9650},
  {"8.4", 283433, 9653},
  {"8.5", 283525, 9656},
  {"8.6", 283624, 9659},
  {"8.7", 283722, 9662},
  {"8.8", 283821, 9665},
  {"8.9", 283920, 9668},
  {"8.10", 284020, 9671},
  {"8.11", 284121, 9674},
  {"8.12", 284222, 9677},
  {"8.13", 284322, 9680},
  {"8.14", 284416, 9683},
  {"S2.13.9", 284514, 9686},
  {"9.1", 289772, 9817},
  {"9.2", 289870, 9820},
  {"9.3", 289963, 9823},
  {"9.4", 290062, 9826},
  {"9.5", 290161, 9829},
  {"9.6", 290260, 9832},
  {"9.7", 290359, 9835},
  {"9.8", 290452, 9838},
  {"9.9", 290549, 9841},
  {"9.10", 290644, 9844},
  {"9.11", 290745, 9847},
  {"9.12", 290841, 9850},
  {"9.13", 290939, 9853},
  {"9.14", 291040, 9856},
  {"9.15", 291136, 9859},
  {"9.16", 291234, 9862},
  {"9.17", 291336, 9865},
  {"9.18", 291437, 9868},
  {"9.19", 291537, 9871},
  {"9.20", 291638, 9874},
  {"9.21", 291739, 9877},
  {"9.22", 291840, 9880},
  {"9.23", 291934, 9883},
  {"9.24", 292028, 9886},
  {"9.25", 292123, 9889},
  {"9.26", 292218, 9892},
  {"9.27", 292312, 9895},
  {"9.28", 292411, 9898},
  {"9.29", 292507, 9901},
  {"9.30", 292608, 9904},
  {"9.31", 292704, 9907},
  {"9.32", 292805, 9910},
  {"9.33", 292902, 9913},
  {"9.34", 293003, 9916},
  {"9.35", 293099, 9919},
  {"9.36", 293200, 9922},
  {"9.37", 293296, 9925},
  {"9.38", 293397, 9928},
  {"9.39", 293493, 9931},
  {"9.40", 293589, 9934},
  {"9.41", 293691, 9937},
  {"S2.13.10", 293790, 9940},
  {"10.1", 295213, 9975},
  {"10.2", 295314, 9978},
  {"10.3", 295410, 9981},
  {"10.4", 295513, 9984},
  {"10.5", 295615, 9987},
  {"10.6", 295713, 9990},
  {"10.7", 295815, 9993},
  {"10.8", 295913, 9996},
  {"10.9", 296016, 9999},
  {"10.10", 296119, 10002},
  {"10.11", 296223, 10005},
  {"S2.13.11", 296324, 10008},
  {"11.1", 298625, 10063},
  {"11.2", 298726, 10066},
  {"11.3", 298821, 10069},
  {"11.4", 298916, 10072},
  {"11.5", 299011, 10075},
  {"11.6", 299113, 10078},
  {"11.7", 299215, 10081},
  {"11.8", 299314, 10084},
  {"11.9", 299415, 10087},
  {"11.10", 299514, 10090},
  {"11.11", 299618, 10093},
  {"11.12", 299718, 10096},
  {"11.13", 299823, 10099},
  {"11.14", 299927, 10102},
  {"11.15", 300031, 10105},
  {"11.16", 300135, 10108},
  {"11.17", 300239, 10111},
  {"11.18", 300339, 10114},
  {"11.19", 300442, 10117},
  {"11.20", 300542, 10120},
  {"11.21", 300647, 10123},
  {"S2.13.12", 300754, 10126},
  {"12.1", 307202, 10277},
  {"12.2", 307303, 10280},
  {"12.3", 307399, 10283},
  {"12.4", 307499, 10286},
  {"12.5", 307596, 10289},
  {"12.6", 307697, 10292},
  {"12.7", 307794, 10295},
  {"12.8", 307896, 10298},
  {"12.9", 307994, 10301},
  {"12.10", 308092, 10304},
  {"12.11", 308196, 10307},
  {"12.12", 308296, 10310},
  {"12.13", 308395, 10313},
  {"12.14", 308498, 10316},
  {"12.15", 308597, 10319},
  {"12.16", 308702, 10322},
  {"12.17", 308799, 10325},
  {"12.18", 308897, 10328},
  {"12.19", 308999, 10331},
  {"12.20", 309098, 10334},
  {"12.21", 309202, 10337},
  {"12.22", 309302, 10340},
  {"12.23", 309406, 10343},
  {"12.24", 309505, 10346},
  {"12.25", 309609, 10349},
  {"12.26", 309708, 10352},
  {"12.27", 309813, 10355},
  {"12.28", 309910, 10358},
  {"12.29", 310008, 10361},
  {"12.30", 310110, 10364},
  {"12.31", 310209, 10367},
  {"12.32", 310313, 10370},
  {"12.33", 310412, 10373},
  {"12.34", 310516, 10376},
  {"12.35", 310615, 10379},
  {"12.36", 310719, 10382},
  {"12.37", 310818, 10385},
  {"12.38", 310922, 10388},
  {"12.39", 311021, 10391},
  {"12.40", 311125, 10394},
  {"12.41", 311224, 10397},
  {"12.42", 311328, 10400},
  {"12.43", 311427, 10403},
  {"12.44", 311531, 10406},
  {"12.45", 311630, 10409},
  {"12.46", 311734, 10412},
  {"12.47", 311833, 10415},
  {"12.48", 311937, 10418},
  {"12.49", 312036, 10421},
  {"12.50", 312140, 10424},
  {"12.51", 312239, 10427},
  {"12.52", 312344, 10430},
  {"12.53", 312442, 10433},
  {"12.54", 312544, 10436},
  {"12.55", 312643, 10439},
  {"12.56", 312746, 10442},
  {"12.57", 312847, 10445},
  {"12.58", 312950, 10448},
  {"12.59", 313050, 10451},
  {"12.60", 313153, 10454},
  {"12.61", 313253, 10457},
  {"12.62", 313352, 10460},
  {"12.63", 313457, 10463},
  {"12.64", 313554, 10466},
  {"12.65", 313652, 10469},
  {"S2.13.13", 313753, 10472},
  {"13.1", 314818, 10499},
  {"13.2", 314919, 10502},
  {"13.3", 315014, 10505},
  {"13.4", 315109, 10508},
  {"13.5", 315204, 10511},
  {"13.6", 315300, 10514},
  {"13.7", 315396, 10517},
  {"S2.13.14", 315495, 10520},
  {"14.1", 319041, 10605},
  {"14.2", 319142, 10608},
  {"14.3", 319238, 10611},
  {"14.4", 319334, 10614},
  {"14.5", 319434, 10617},
  {"14.6", 319536, 10620},
  {"14.7", 319633, 10623},
  {"14.8", 319730, 10626},
  {"14.9", 319828, 10629},
  {"14.10", 319931, 10632},
  {"14.11", 320030, 10635},
  {"14.12", 320134, 10638},
  {"14.13", 320234, 10641},
  {"14.14", 320338, 10644},
  {"14.15", 320437, 10647},
  {"14.16", 320536, 10650},
  {"14.17", 320641, 10653},
  {"14.18", 320739, 10656},
  {"14.19", 320837, 10659},
  {"14.20", 320934, 10662},
  {"14.21", 321031, 10665},
  {"14.22", 321128, 10668},
  {"14.23", 321225, 10671},
  {"14.24", 321322, 10674},
  {"14.25", 321424, 10677},
  {"14.26", 321528, 10680},
  {"14.27", 321628, 10683},
  {"14.28", 321733, 10686},
  {"14.29", 321831, 10689},
  {"14.30", 321928, 10692},
  {"14.31", 322026, 10695},
  {"14.32", 322124, 10698}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 171, 5, 70, "Section",
  CellTags->{"S2.13.0", "0.1"}],

Cell[CellGroupData[{
Cell[1972, 62, 126, 5, 70, "Subsection",
  CellTags->{"S2.13.1", "1.1"}],
Cell[2101, 69, 368, 11, 70, "Text",
  CellTags->{"S2.13.1", "1.2"}],
Cell[2472, 82, 1172, 33, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[3647, 117, 117, 5, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[3767, 124, 354, 8, 70, "Text",
  CellTags->{"S2.13.1", "1.3"}],
Cell[4124, 134, 315, 9, 70, "Text",
  CellTags->{"S2.13.1", "1.4"}],
Cell[4442, 145, 242, 8, 70, "Text",
  CellTags->{"S2.13.1", "1.5"}],
Cell[4687, 155, 193, 5, 70, "Text",
  CellTags->{"S2.13.1", "1.6"}],
Cell[4883, 162, 850, 28, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[5736, 192, 138, 5, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[5877, 199, 565, 14, 70, "Text",
  CellTags->{"S2.13.1", "1.7"}],
Cell[6445, 215, 462, 13, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[6910, 230, 114, 5, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[7027, 237, 420, 12, 70, "Text",
  CellTags->{"S2.13.1", "1.8"}],
Cell[7450, 251, 727, 20, 70, "FramedBox",
  CellTags->"S2.13.1"],
Cell[8180, 273, 189, 7, 70, "Caption",
  CellTags->"S2.13.1"],
Cell[8372, 282, 255, 8, 70, "Text",
  CellTags->{"S2.13.1", "1.9"}],
Cell[8630, 292, 309, 7, 70, "Text",
  CellTags->{"S2.13.1", "1.10"}],
Cell[8942, 301, 292, 7, 70, "Text",
  CellTags->{"S2.13.1", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9271, 313, 162, 5, 70, "Subsection",
  CellTags->{"S2.13.2", "2.1"}],
Cell[9436, 320, 455, 11, 70, "Text",
  CellTags->{"S2.13.2", "2.2"}],
Cell[9894, 333, 756, 22, 70, "DefinitionBox",
  CellTags->"S2.13.2"],
Cell[10653, 357, 168, 5, 70, "Caption",
  CellTags->"S2.13.2"],
Cell[10824, 364, 204, 7, 70, "MathCaption",
  CellTags->{"S2.13.2", "2.3"}],

Cell[CellGroupData[{
Cell[11053, 375, 85, 2, 70, "Input",
  CellTags->"S2.13.2"],
Cell[11141, 379, 111, 3, 70, "Output",
  CellTags->"S2.13.2"]
}, Open  ]],
Cell[11267, 385, 170, 6, 70, "MathCaption",
  CellTags->{"S2.13.2", "2.4"}],

Cell[CellGroupData[{
Cell[11462, 395, 81, 2, 70, "Input",
  CellTags->"S2.13.2"],
Cell[11546, 399, 84, 3, 70, "Output",
  CellTags->"S2.13.2"]
}, Open  ]],
Cell[11645, 405, 163, 5, 70, "MathCaption",
  CellTags->{"S2.13.2", "2.5"}],

Cell[CellGroupData[{
Cell[11833, 414, 101, 2, 70, "Input",
  CellTags->"S2.13.2"],
Cell[11937, 418, 105, 3, 70, "Output",
  CellTags->"S2.13.2"]
}, Open  ]],
Cell[12057, 424, 317, 7, 70, "Text",
  CellTags->{"S2.13.2", "2.6"}],
Cell[12377, 433, 536, 13, 70, "Text",
  CellTags->{"S2.13.2", "2.7"}],
Cell[12916, 448, 464, 14, 70, "DefinitionBox",
  CellTags->"S2.13.2"],
Cell[13383, 464, 94, 1, 70, "Caption",
  CellTags->"S2.13.2"],
Cell[13480, 467, 974, 30, 70, "Text",
  CellTags->{"S2.13.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14491, 502, 159, 4, 70, "Subsection",
  CellTags->{"S2.13.3", "3.1"}],
Cell[14653, 508, 393, 9, 70, "Text",
  CellTags->{"S2.13.3", "3.2"}],
Cell[15049, 519, 253, 8, 70, "Text",
  CellTags->{"S2.13.3", "3.3"}],
Cell[15305, 529, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.4"}],
Cell[15363, 532, 212, 9, 70, "Program",
  CellTags->{"S2.13.3", "3.5"}],
Cell[15578, 543, 84, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.6"}],
Cell[15665, 546, 212, 9, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[15880, 557, 1622, 41, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[17505, 600, 123, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[17631, 607, 513, 12, 70, "Text",
  CellTags->{"S2.13.3", "3.7"}],
Cell[18147, 621, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.8"}],
Cell[18205, 624, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.9"}],
Cell[18350, 631, 84, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.10"}],
Cell[18437, 637, 150, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.11"}],
Cell[18590, 644, 326, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.12"}],
Cell[18919, 658, 181, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.13"}],
Cell[19103, 665, 354, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.14"}],
Cell[19460, 679, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.15"}],
Cell[19522, 682, 123, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[19648, 689, 335, 9, 70, "Text",
  CellTags->{"S2.13.3", "3.16"}],
Cell[19986, 700, 689, 22, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[20678, 724, 150, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[20831, 731, 321, 8, 70, "Text",
  CellTags->{"S2.13.3", "3.17"}],
Cell[21155, 741, 353, 8, 70, "Text",
  CellTags->{"S2.13.3", "3.18"}],
Cell[21511, 751, 545, 17, 70, "Text",
  CellTags->{"S2.13.3", "3.19"}],
Cell[22059, 770, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.20"}],
Cell[22118, 773, 222, 7, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.21"}],
Cell[22343, 782, 73, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.22"}],
Cell[22419, 785, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.23"}],
Cell[22481, 788, 161, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.24"}],

Cell[CellGroupData[{
Cell[22667, 797, 83, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[22753, 801, 107, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[22875, 807, 388, 17, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.25"}],

Cell[CellGroupData[{
Cell[23288, 828, 72, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[23363, 832, 84, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[23462, 838, 151, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.26"}],

Cell[CellGroupData[{
Cell[23638, 846, 77, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[23718, 850, 97, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[23830, 856, 461, 12, 70, "Text",
  CellTags->{"S2.13.3", "3.27"}],
Cell[24294, 870, 1453, 41, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[25750, 913, 79, 1, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[25832, 916, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.28"}],

Cell[CellGroupData[{
Cell[25999, 925, 81, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[26083, 929, 111, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[26209, 935, 174, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.29"}],

Cell[CellGroupData[{
Cell[26408, 944, 85, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[26496, 948, 158, 5, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[26669, 956, 237, 8, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.30"}],

Cell[CellGroupData[{
Cell[26931, 968, 67, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[27001, 972, 66, 2, 70, "Print",
  CellTags->"S2.13.3"],
Cell[27070, 976, 536, 15, 70, "Print",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[27621, 994, 671, 20, 70, "Text",
  CellTags->{"S2.13.3", "3.31"}],
Cell[28295, 1016, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.32"}],
Cell[28354, 1019, 59, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.33"}],
Cell[28416, 1022, 143, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.34"}],
Cell[28562, 1028, 76, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.35"}],
Cell[28641, 1031, 175, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.36"}],
Cell[28819, 1038, 99, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.37"}],
Cell[28921, 1041, 166, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.38"}],
Cell[29090, 1047, 330, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.39"}],
Cell[29423, 1061, 147, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.40"}],
Cell[29573, 1067, 320, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.41"}],
Cell[29896, 1081, 142, 4, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.42"}],
Cell[30041, 1087, 75, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.43"}],
Cell[30119, 1090, 57, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.44"}],
Cell[30179, 1093, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.45"}],
Cell[30241, 1096, 522, 15, 70, "Text",
  CellTags->{"S2.13.3", "3.46"}],
Cell[30766, 1113, 282, 6, 70, "Text",
  CellTags->{"S2.13.3", "3.47"}],
Cell[31051, 1121, 409, 10, 70, "Text",
  CellTags->{"S2.13.3", "3.48"}],
Cell[31463, 1133, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.49"}],
Cell[31522, 1136, 204, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.50"}],
Cell[31729, 1143, 164, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.51"}],
Cell[31896, 1149, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.52"}],
Cell[31958, 1152, 456, 11, 70, "Text",
  CellTags->{"S2.13.3", "3.53"}],
Cell[32417, 1165, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.54"}],
Cell[32476, 1168, 208, 6, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.55"}],
Cell[32687, 1176, 261, 7, 70, "Program",
  CellTags->{"S2.13.3", "3.56"}],
Cell[32951, 1185, 274, 9, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.57"}],
Cell[33228, 1196, 686, 24, 70, "Program",
  CellTags->{"S2.13.3", "3.58"}],
Cell[33917, 1222, 284, 10, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.59"}],
Cell[34204, 1234, 658, 24, 70, "Program",
  CellTags->{"S2.13.3", "3.60"}],
Cell[34865, 1260, 250, 6, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.61"}],
Cell[35118, 1268, 104, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.62"}],
Cell[35225, 1274, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.63"}],
Cell[35287, 1277, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.64"}],
Cell[35346, 1280, 290, 8, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.65"}],
Cell[35639, 1290, 336, 13, 70, "Program",
  CellTags->{"S2.13.3", "3.66"}],
Cell[35978, 1305, 336, 11, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.67"}],
Cell[36317, 1318, 325, 12, 70, "Program",
  CellTags->{"S2.13.3", "3.68"}],
Cell[36645, 1332, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.69"}],
Cell[36707, 1335, 549, 14, 70, "Text",
  CellTags->{"S2.13.3", "3.70"}],
Cell[37259, 1351, 548, 16, 70, "DefinitionBox",
  CellTags->"S2.13.3"],
Cell[37810, 1369, 154, 5, 70, "Caption",
  CellTags->"S2.13.3"],
Cell[37967, 1376, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.3", "3.71"}],
Cell[38026, 1379, 76, 1, 70, "Program",
  CellTags->{"S2.13.3", "3.72"}],
Cell[38105, 1382, 265, 13, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.73"}],
Cell[38373, 1397, 132, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.74"}],
Cell[38508, 1403, 79, 4, 70, "Program",
  CellTags->{"S2.13.3", "3.75"}],
Cell[38590, 1409, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.3", "3.76"}],
Cell[38652, 1412, 178, 5, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.77"}],

Cell[CellGroupData[{
Cell[38855, 1421, 86, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[38944, 1425, 112, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[39071, 1431, 170, 7, 70, "MathCaption",
  CellTags->{"S2.13.3", "3.78"}],

Cell[CellGroupData[{
Cell[39266, 1442, 75, 2, 70, "Input",
  CellTags->"S2.13.3"],
Cell[39344, 1446, 66, 2, 70, "Print",
  CellTags->"S2.13.3"],
Cell[39413, 1450, 88, 3, 70, "Output",
  CellTags->"S2.13.3"]
}, Open  ]],
Cell[39516, 1456, 474, 12, 70, "Text",
  CellTags->{"S2.13.3", "3.79"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[40027, 1473, 105, 1, 70, "Subsection",
  CellTags->{"S2.13.4", "4.1"}],
Cell[40135, 1476, 391, 11, 70, "Text",
  CellTags->{"S2.13.4", "4.2"}],
Cell[40529, 1489, 2536, 82, 70, "DefinitionBox3Col",
  CellTags->"S2.13.4"],
Cell[43068, 1573, 69, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[43140, 1576, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.3"}],
Cell[43198, 1579, 191, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.4"}],
Cell[43392, 1586, 661, 24, 70, "Program",
  CellTags->{"S2.13.4", "4.5"}],
Cell[44056, 1612, 218, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.6"}],
Cell[44277, 1619, 402, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.7"}],
Cell[44682, 1634, 58, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.8"}],
Cell[44743, 1637, 185, 6, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.9"}],

Cell[CellGroupData[{
Cell[44953, 1647, 83, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[45039, 1651, 109, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[45163, 1657, 86, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.10"}],

Cell[CellGroupData[{
Cell[45274, 1662, 77, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[45354, 1666, 84, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[45453, 1672, 178, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.11"}],

Cell[CellGroupData[{
Cell[45656, 1681, 70, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[45729, 1685, 87, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[45831, 1691, 224, 6, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.12"}],

Cell[CellGroupData[{
Cell[46080, 1701, 77, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[46160, 1705, 89, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[46264, 1711, 327, 9, 70, "Text",
  CellTags->{"S2.13.4", "4.13"}],
Cell[46594, 1722, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.14"}],
Cell[46653, 1725, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.15"}],
Cell[46798, 1732, 343, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.16"}],
Cell[47144, 1747, 115, 2, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.17"}],
Cell[47262, 1751, 106, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.18"}],
Cell[47371, 1754, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.19"}],
Cell[47433, 1757, 311, 8, 70, "Text",
  CellTags->{"S2.13.4", "4.20"}],
Cell[47747, 1767, 490, 15, 70, "Text",
  CellTags->{"S2.13.4", "4.21"}],
Cell[48240, 1784, 3747, 106, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[51990, 1892, 160, 6, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[52153, 1900, 649, 19, 70, "Text",
  CellTags->{"S2.13.4", "4.22"}],
Cell[52805, 1921, 869, 25, 70, "Text",
  CellTags->{"S2.13.4", "4.23"}],
Cell[53677, 1948, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.24"}],
Cell[53736, 1951, 270, 8, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.25"}],
Cell[54009, 1961, 666, 24, 70, "Program",
  CellTags->{"S2.13.4", "4.26"}],
Cell[54678, 1987, 134, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.27"}],
Cell[54815, 1994, 97, 6, 70, "Program",
  CellTags->{"S2.13.4", "4.28"}],
Cell[54915, 2002, 136, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.29"}],
Cell[55054, 2009, 407, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.30"}],
Cell[55464, 2024, 214, 9, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.31"}],
Cell[55681, 2035, 111, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.32"}],
Cell[55795, 2042, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.33"}],
Cell[55857, 2045, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.34"}],

Cell[CellGroupData[{
Cell[56047, 2054, 86, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[56136, 2058, 108, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[56259, 2064, 106, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.35"}],

Cell[CellGroupData[{
Cell[56390, 2069, 73, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[56466, 2073, 94, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[56575, 2079, 457, 17, 70, "Text",
  CellTags->{"S2.13.4", "4.36"}],
Cell[57035, 2098, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.37"}],
Cell[57094, 2101, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.38"}],
Cell[57152, 2104, 124, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.39"}],
Cell[57279, 2110, 73, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.40"}],
Cell[57355, 2113, 199, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.41"}],
Cell[57557, 2122, 322, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.42"}],
Cell[57882, 2137, 67, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.43"}],
Cell[57952, 2143, 214, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.44"}],
Cell[58169, 2152, 101, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.45"}],
Cell[58273, 2155, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.46"}],
Cell[58331, 2158, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.47"}],
Cell[58393, 2161, 431, 13, 70, "Text",
  CellTags->{"S2.13.4", "4.48"}],
Cell[58827, 2176, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.49"}],
Cell[58886, 2179, 189, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.50"}],
Cell[59078, 2188, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.51"}],
Cell[59169, 2191, 157, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.52"}],
Cell[59329, 2198, 78, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.53"}],
Cell[59410, 2201, 161, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.54"}],
Cell[59574, 2208, 80, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.55"}],
Cell[59657, 2211, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.56"}],
Cell[59719, 2214, 583, 16, 70, "Text",
  CellTags->{"S2.13.4", "4.57"}],
Cell[60305, 2232, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.58"}],
Cell[60364, 2235, 149, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.59"}],
Cell[60516, 2242, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.60"}],
Cell[60607, 2245, 175, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.61"}],
Cell[60785, 2252, 85, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.62"}],
Cell[60873, 2255, 136, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.63"}],
Cell[61012, 2261, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.64"}],
Cell[61103, 2264, 136, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.65"}],
Cell[61242, 2270, 76, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.66"}],
Cell[61321, 2273, 90, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.67"}],
Cell[61414, 2276, 78, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.68"}],
Cell[61495, 2279, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.69"}],
Cell[61557, 2282, 626, 15, 70, "Text",
  CellTags->{"S2.13.4", "4.70"}],
Cell[62186, 2299, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.71"}],
Cell[62245, 2302, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.72"}],
Cell[62303, 2305, 167, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.73"}],
Cell[62473, 2312, 61, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.74"}],
Cell[62537, 2315, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.75"}],
Cell[62595, 2318, 178, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.76"}],
Cell[62776, 2327, 89, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.77"}],
Cell[62868, 2330, 74, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.78"}],
Cell[62945, 2333, 141, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.79"}],
Cell[63089, 2340, 93, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.80"}],
Cell[63185, 2343, 78, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.81"}],
Cell[63266, 2346, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.82"}],
Cell[63360, 2349, 99, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.83"}],
Cell[63462, 2352, 67, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.84"}],
Cell[63532, 2358, 55, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.85"}],
Cell[63590, 2361, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.86"}],
Cell[63652, 2364, 763, 20, 70, "Text",
  CellTags->{"S2.13.4", "4.87"}],
Cell[64418, 2386, 268, 6, 70, "Text",
  CellTags->{"S2.13.4", "4.88"}],
Cell[64689, 2394, 180, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.89"}],

Cell[CellGroupData[{
Cell[64894, 2403, 106, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[65003, 2407, 99, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[65117, 2413, 143, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.90"}],

Cell[CellGroupData[{
Cell[65285, 2421, 100, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[65388, 2425, 111, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[65514, 2431, 125, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.91"}],

Cell[CellGroupData[{
Cell[65664, 2439, 75, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[65742, 2443, 99, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[65856, 2449, 134, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.92"}],

Cell[CellGroupData[{
Cell[66015, 2457, 105, 2, 70, "Input",
  CellTags->"S2.13.4"],
Cell[66123, 2461, 89, 3, 70, "Output",
  CellTags->"S2.13.4"]
}, Open  ]],
Cell[66227, 2467, 346, 9, 70, "Text",
  CellTags->{"S2.13.4", "4.93"}],
Cell[66576, 2478, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.94"}],
Cell[66635, 2481, 142, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.95"}],
Cell[66780, 2488, 88, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.96"}],
Cell[66871, 2491, 164, 6, 70, "Program",
  CellTags->{"S2.13.4", "4.97"}],
Cell[67038, 2499, 139, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.98"}],
Cell[67180, 2506, 96, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.99"}],
Cell[67279, 2509, 74, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.100"}],
Cell[67356, 2512, 128, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.101"}],
Cell[67487, 2519, 54, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.102"}],
Cell[67544, 2522, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.103"}],
Cell[67691, 2529, 93, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.104"}],
Cell[67787, 2532, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.105"}],
Cell[67850, 2535, 898, 26, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[68751, 2563, 148, 5, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[68902, 2570, 472, 15, 70, "Text",
  CellTags->{"S2.13.4", "4.106"}],
Cell[69377, 2587, 389, 12, 70, "Text",
  CellTags->{"S2.13.4", "4.107"}],
Cell[69769, 2601, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.108"}],
Cell[69829, 2604, 87, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.109"}],
Cell[69919, 2610, 178, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.110"}],
Cell[70100, 2619, 98, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.111"}],
Cell[70201, 2622, 131, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.112"}],
Cell[70335, 2628, 313, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.113"}],
Cell[70651, 2642, 134, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.114"}],
Cell[70788, 2648, 321, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.115"}],
Cell[71112, 2662, 89, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.116"}],
Cell[71204, 2669, 113, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.117"}],
Cell[71320, 2672, 79, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.118"}],
Cell[71402, 2678, 166, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.119"}],
Cell[71571, 2687, 77, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.120"}],
Cell[71651, 2693, 143, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.121"}],
Cell[71797, 2699, 115, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.122"}],
Cell[71915, 2706, 79, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.123"}],
Cell[71997, 2712, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.124"}],
Cell[72060, 2715, 601, 18, 70, "Text",
  CellTags->{"S2.13.4", "4.125"}],
Cell[72664, 2735, 579, 18, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[73246, 2755, 119, 5, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[73368, 2762, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.126"}],
Cell[73428, 2765, 87, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.127"}],
Cell[73518, 2771, 200, 7, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.128"}],
Cell[73721, 2780, 327, 13, 70, "Program",
  CellTags->{"S2.13.4", "4.129"}],
Cell[74051, 2795, 109, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.130"}],
Cell[74163, 2798, 307, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.131"}],
Cell[74473, 2812, 133, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.132"}],
Cell[74609, 2818, 312, 12, 70, "Program",
  CellTags->{"S2.13.4", "4.133"}],
Cell[74924, 2832, 92, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.134"}],
Cell[75019, 2839, 108, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.135"}],
Cell[75130, 2842, 75, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.136"}],
Cell[75208, 2848, 88, 1, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.137"}],
Cell[75299, 2851, 92, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.138"}],
Cell[75394, 2858, 197, 6, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.139"}],
Cell[75594, 2866, 105, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.140"}],
Cell[75702, 2872, 156, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.141"}],
Cell[75861, 2879, 117, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.142"}],
Cell[75981, 2885, 66, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.143"}],
Cell[76050, 2891, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.144"}],
Cell[76113, 2894, 429, 9, 70, "Text",
  CellTags->{"S2.13.4", "4.145"}],
Cell[76545, 2905, 253, 6, 70, "Text",
  CellTags->{"S2.13.4", "4.146"}],
Cell[76801, 2913, 1701, 50, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[78505, 2965, 68, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[78576, 2968, 459, 14, 70, "Text",
  CellTags->{"S2.13.4", "4.147"}],
Cell[79038, 2984, 240, 5, 70, "Text",
  CellTags->{"S2.13.4", "4.148"}],
Cell[79281, 2991, 494, 14, 70, "Text",
  CellTags->{"S2.13.4", "4.149"}],
Cell[79778, 3007, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.4", "4.150"}],
Cell[79838, 3010, 133, 4, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.151"}],
Cell[79974, 3016, 75, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.152"}],
Cell[80052, 3022, 159, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.153"}],
Cell[80214, 3029, 85, 5, 70, "Program",
  CellTags->{"S2.13.4", "4.154"}],
Cell[80302, 3036, 168, 5, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.155"}],
Cell[80473, 3043, 100, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.156"}],
Cell[80576, 3049, 56, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.157"}],
Cell[80635, 3052, 119, 2, 70, "MathCaption",
  CellTags->{"S2.13.4", "4.158"}],
Cell[80757, 3056, 92, 1, 70, "Program",
  CellTags->{"S2.13.4", "4.159"}],
Cell[80852, 3059, 66, 4, 70, "Program",
  CellTags->{"S2.13.4", "4.160"}],
Cell[80921, 3065, 60, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.4", "4.161"}],
Cell[80984, 3068, 522, 14, 70, "Text",
  CellTags->{"S2.13.4", "4.162"}],
Cell[81509, 3084, 2274, 62, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[83786, 3148, 69, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[83858, 3151, 405, 10, 70, "Text",
  CellTags->{"S2.13.4", "4.163"}],
Cell[84266, 3163, 563, 21, 70, "Text",
  CellTags->{"S2.13.4", "4.164"}],
Cell[84832, 3186, 518, 16, 70, "Text",
  CellTags->{"S2.13.4", "4.165"}],
Cell[85353, 3204, 342, 10, 70, "Text",
  CellTags->{"S2.13.4", "4.166"}],
Cell[85698, 3216, 1178, 30, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[86879, 3248, 86, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[86968, 3251, 461, 12, 70, "Text",
  CellTags->{"S2.13.4", "4.167"}],
Cell[87432, 3265, 501, 11, 70, "Text",
  CellTags->{"S2.13.4", "4.168"}],
Cell[87936, 3278, 978, 26, 70, "DefinitionBox",
  CellTags->"S2.13.4"],
Cell[88917, 3306, 73, 1, 70, "Caption",
  CellTags->"S2.13.4"],
Cell[88993, 3309, 553, 14, 70, "Text",
  CellTags->{"S2.13.4", "4.169"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[89583, 3328, 153, 5, 70, "Subsection",
  CellTags->{"S2.13.5", "5.1"}],
Cell[89739, 3335, 323, 9, 70, "Text",
  CellTags->{"S2.13.5", "5.2"}],
Cell[90065, 3346, 415, 11, 70, "Text",
  CellTags->{"S2.13.5", "5.3"}],
Cell[90483, 3359, 1483, 44, 70, "DefinitionBox",
  CellTags->"S2.13.5"],
Cell[91969, 3405, 92, 1, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[92064, 3408, 641, 19, 70, "Text",
  CellTags->{"S2.13.5", "5.4"}],
Cell[92708, 3429, 1061, 32, 70, "DefinitionBox",
  CellTags->"S2.13.5"],
Cell[93772, 3463, 97, 1, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[93872, 3466, 309, 6, 70, "Text",
  CellTags->{"S2.13.5", "5.5"}],
Cell[94184, 3474, 156, 4, 70, "Text",
  CellTags->{"S2.13.5", "5.6"}],
Cell[94343, 3480, 350, 7, 70, "Text",
  CellTags->{"S2.13.5", "5.7"}],
Cell[94696, 3489, 736, 21, 70, "Text",
  CellTags->{"S2.13.5", "5.8"}],
Cell[95435, 3512, 2531, 76, 70, "DefinitionBox3Col",
  CellTags->"S2.13.5"],
Cell[97969, 3590, 126, 4, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[98098, 3596, 520, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.9"}],
Cell[98621, 3612, 535, 11, 70, "Text",
  CellTags->{"S2.13.5", "5.10"}],
Cell[99159, 3625, 2482, 71, 70, "DefinitionBox",
  CellTags->"S2.13.5"],
Cell[101644, 3698, 72, 1, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[101719, 3701, 536, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.11"}],
Cell[102258, 3717, 497, 17, 70, "Text",
  CellTags->{"S2.13.5", "5.12"}],
Cell[102758, 3736, 552, 13, 70, "Text",
  CellTags->{"S2.13.5", "5.13"}],
Cell[103313, 3751, 391, 11, 70, "FramedBox",
  CellTags->"S2.13.5"],
Cell[103707, 3764, 143, 5, 70, "Caption",
  CellTags->"S2.13.5"],
Cell[103853, 3771, 416, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.14"}],
Cell[104272, 3787, 548, 14, 70, "Text",
  CellTags->{"S2.13.5", "5.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[104857, 3806, 193, 7, 70, "Subsection",
  CellTags->{"S2.13.6", "6.1"}],
Cell[105053, 3815, 2366, 67, 70, "DefinitionBox",
  CellTags->"S2.13.6"],
Cell[107422, 3884, 159, 6, 70, "Caption",
  CellTags->"S2.13.6"],
Cell[107584, 3892, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.2"}],
Cell[107652, 3895, 98, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.3"}],

Cell[CellGroupData[{
Cell[107775, 3900, 92, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[107870, 3904, 104, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[107989, 3909, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.4"}],
Cell[108057, 3912, 95, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.5"}],

Cell[CellGroupData[{
Cell[108177, 3917, 92, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[108272, 3921, 108, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[108395, 3926, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.6"}],
Cell[108463, 3929, 145, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.7"}],
Cell[108611, 3936, 84, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[108698, 3940, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.8"}],
Cell[108766, 3943, 156, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.9"}],

Cell[CellGroupData[{
Cell[108947, 3952, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[109028, 3956, 78, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[109121, 3961, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.10"}],
Cell[109215, 3964, 87, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[109305, 3968, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.11"}],
Cell[109374, 3971, 102, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.12"}],

Cell[CellGroupData[{
Cell[109501, 3976, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[109582, 3980, 104, 3, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[109701, 3986, 254, 8, 70, "Text",
  CellTags->{"S2.13.6", "6.13"}],
Cell[109958, 3996, 151, 4, 70, "Text",
  CellTags->{"S2.13.6", "6.14"}],
Cell[110112, 4002, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.15"}],
Cell[110181, 4005, 212, 9, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.16"}],
Cell[110396, 4016, 99, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[110498, 4020, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.17"}],
Cell[110567, 4023, 174, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.18"}],

Cell[CellGroupData[{
Cell[110766, 4032, 84, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[110853, 4036, 76, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[110944, 4041, 87, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.19"}],

Cell[CellGroupData[{
Cell[111056, 4046, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[111137, 4050, 66, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[111218, 4055, 395, 11, 70, "Text",
  CellTags->{"S2.13.6", "6.20"}],
Cell[111616, 4068, 718, 23, 70, "Text",
  CellTags->{"S2.13.6", "6.21"}],
Cell[112337, 4093, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.22"}],
Cell[112406, 4096, 199, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.23"}],

Cell[CellGroupData[{
Cell[112630, 4105, 80, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[112713, 4109, 70, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[112798, 4114, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.24"}],
Cell[112867, 4117, 95, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.25"}],
Cell[112965, 4120, 86, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[113054, 4124, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.26"}],
Cell[113123, 4127, 117, 2, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.27"}],

Cell[CellGroupData[{
Cell[113265, 4133, 80, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[113348, 4137, 69, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[113432, 4142, 148, 4, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.28"}],

Cell[CellGroupData[{
Cell[113605, 4150, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[113686, 4154, 70, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[113771, 4159, 1138, 30, 70, "DefinitionBox",
  CellTags->"S2.13.6"],
Cell[114912, 4191, 117, 5, 70, "Caption",
  CellTags->"S2.13.6"],
Cell[115032, 4198, 332, 7, 70, "Text",
  CellTags->{"S2.13.6", "6.29"}],
Cell[115367, 4207, 195, 5, 70, "Text",
  CellTags->{"S2.13.6", "6.30"}],
Cell[115565, 4214, 160, 5, 70, "Text",
  CellTags->{"S2.13.6", "6.31"}],
Cell[115728, 4221, 122, 4, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.32"}],
Cell[115853, 4227, 152, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.33"}],

Cell[CellGroupData[{
Cell[116030, 4236, 84, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[116117, 4240, 108, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[116240, 4245, 122, 4, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.34"}],
Cell[116365, 4251, 147, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.35"}],

Cell[CellGroupData[{
Cell[116537, 4260, 109, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[116649, 4264, 108, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[116772, 4269, 107, 1, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.36"}],
Cell[116882, 4272, 93, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[116978, 4276, 122, 4, 70, "SessionLabel",
  CellTags->{"S2.13.6", "6.37"}],
Cell[117103, 4282, 143, 5, 70, "MathCaption",
  CellTags->{"S2.13.6", "6.38"}],

Cell[CellGroupData[{
Cell[117271, 4291, 78, 2, 70, "Input",
  CellTags->"S2.13.6"],
Cell[117352, 4295, 69, 2, 70, "Output",
  CellTags->"S2.13.6"]
}, Open  ]],
Cell[117436, 4300, 333, 8, 70, "Text",
  CellTags->{"S2.13.6", "6.39"}],
Cell[117772, 4310, 390, 10, 70, "Text",
  CellTags->{"S2.13.6", "6.40"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[118199, 4325, 146, 5, 70, "Subsection",
  CellTags->{"S2.13.7", "7.1"}],
Cell[118348, 4332, 467, 13, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[118818, 4347, 135, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[118956, 4354, 178, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.2"}],

Cell[CellGroupData[{
Cell[119159, 4363, 101, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[119263, 4367, 97, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[119375, 4372, 195, 6, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.3"}],

Cell[CellGroupData[{
Cell[119595, 4382, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[119677, 4386, 90, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[119782, 4391, 186, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.4"}],
Cell[119971, 4398, 106, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[120080, 4402, 188, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.5"}],

Cell[CellGroupData[{
Cell[120293, 4411, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[120375, 4415, 91, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[120481, 4420, 107, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.6"}],

Cell[CellGroupData[{
Cell[120613, 4425, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[120695, 4429, 90, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[120800, 4434, 410, 12, 70, "Text",
  CellTags->{"S2.13.7", "7.7"}],
Cell[121213, 4448, 1205, 30, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[122421, 4480, 130, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[122554, 4487, 275, 9, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.8"}],

Cell[CellGroupData[{
Cell[122854, 4500, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[122936, 4504, 90, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[123041, 4509, 140, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.9"}],
Cell[123184, 4516, 122, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[123309, 4520, 139, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.10"}],

Cell[CellGroupData[{
Cell[123473, 4529, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[123555, 4533, 87, 5, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[123657, 4541, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.11"}],

Cell[CellGroupData[{
Cell[123826, 4550, 79, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[123908, 4554, 87, 5, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[124010, 4562, 170, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.12"}],

Cell[CellGroupData[{
Cell[124205, 4571, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[124288, 4575, 91, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[124394, 4580, 1264, 36, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[125661, 4618, 145, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[125809, 4625, 811, 26, 70, "Text",
  CellTags->{"S2.13.7", "7.13"}],
Cell[126623, 4653, 745, 20, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[127371, 4675, 119, 4, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[127493, 4681, 189, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.14"}],
Cell[127685, 4688, 147, 5, 70, "Input",
  CellTags->"S2.13.7"],
Cell[127835, 4695, 184, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.15"}],

Cell[CellGroupData[{
Cell[128044, 4704, 92, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[128139, 4708, 264, 6, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[128418, 4717, 564, 18, 70, "Text",
  CellTags->{"S2.13.7", "7.16"}],
Cell[128985, 4737, 698, 23, 70, "Text",
  CellTags->{"S2.13.7", "7.17"}],
Cell[129686, 4762, 682, 18, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[130371, 4782, 116, 4, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[130490, 4788, 221, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.18"}],
Cell[130714, 4797, 115, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[130832, 4801, 135, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.19"}],

Cell[CellGroupData[{
Cell[130992, 4810, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[131075, 4814, 104, 3, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[131194, 4820, 192, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.20"}],
Cell[131389, 4829, 120, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[131512, 4833, 216, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.21"}],

Cell[CellGroupData[{
Cell[131753, 4844, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[131836, 4848, 88, 5, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[131939, 4856, 156, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.22"}],

Cell[CellGroupData[{
Cell[132120, 4865, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[132203, 4869, 84, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[132302, 4874, 597, 16, 70, "Text",
  CellTags->{"S2.13.7", "7.23"}],
Cell[132902, 4892, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.24"}],
Cell[133070, 4899, 146, 5, 70, "Input",
  CellTags->"S2.13.7"],
Cell[133219, 4906, 182, 5, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.25"}],

Cell[CellGroupData[{
Cell[133426, 4915, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[133509, 4919, 85, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[133609, 4924, 118, 2, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.26"}],

Cell[CellGroupData[{
Cell[133752, 4930, 82, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[133837, 4934, 71, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[133923, 4939, 80, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.27"}],
Cell[134006, 4942, 109, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[134118, 4946, 202, 7, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.28"}],

Cell[CellGroupData[{
Cell[134345, 4957, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[134428, 4961, 89, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[134532, 4966, 550, 16, 70, "DefinitionBox",
  CellTags->"S2.13.7"],
Cell[135085, 4984, 138, 5, 70, "Caption",
  CellTags->"S2.13.7"],
Cell[135226, 4991, 146, 4, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.29"}],
Cell[135375, 4997, 141, 5, 70, "Input",
  CellTags->"S2.13.7"],
Cell[135519, 5004, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.30"}],

Cell[CellGroupData[{
Cell[135635, 5009, 82, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[135720, 5013, 71, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]],
Cell[135806, 5018, 81, 1, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.31"}],
Cell[135890, 5021, 85, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[135978, 5025, 145, 4, 70, "MathCaption",
  CellTags->{"S2.13.7", "7.32"}],

Cell[CellGroupData[{
Cell[136148, 5033, 80, 2, 70, "Input",
  CellTags->"S2.13.7"],
Cell[136231, 5037, 92, 2, 70, "Output",
  CellTags->"S2.13.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[136372, 5045, 162, 5, 70, "Subsection",
  CellTags->{"S2.13.8", "8.1"}],
Cell[136537, 5052, 437, 14, 70, "Text",
  CellTags->{"S2.13.8", "8.2"}],
Cell[136977, 5068, 474, 14, 70, "DefinitionBox",
  CellTags->"S2.13.8"],
Cell[137454, 5084, 93, 1, 70, "Caption",
  CellTags->"S2.13.8"],
Cell[137550, 5087, 242, 7, 70, "Text",
  CellTags->{"S2.13.8", "8.3"}],
Cell[137795, 5096, 283, 8, 70, "Text",
  CellTags->{"S2.13.8", "8.4"}],
Cell[138081, 5106, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.8", "8.5"}],
Cell[138149, 5109, 89, 1, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.6"}],

Cell[CellGroupData[{
Cell[138263, 5114, 92, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[138358, 5118, 104, 2, 70, "Output",
  CellTags->"S2.13.8"]
}, Open  ]],
Cell[138477, 5123, 65, 1, 70, "SessionLabel",
  CellTags->{"S2.13.8", "8.7"}],
Cell[138545, 5126, 102, 1, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.8"}],

Cell[CellGroupData[{
Cell[138672, 5131, 86, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[138761, 5135, 104, 2, 70, "Output",
  CellTags->"S2.13.8"]
}, Open  ]],
Cell[138880, 5140, 131, 4, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.9"}],
Cell[139014, 5146, 80, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[139097, 5150, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.8", "8.10"}],
Cell[139166, 5153, 142, 4, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.11"}],

Cell[CellGroupData[{
Cell[139333, 5161, 91, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[139427, 5165, 236, 7, 70, "Output",
  CellTags->"S2.13.8"]
}, Open  ]],
Cell[139678, 5175, 87, 1, 70, "MathCaption",
  CellTags->{"S2.13.8", "8.12"}],
Cell[139768, 5178, 116, 2, 70, "Input",
  CellTags->"S2.13.8"],
Cell[139887, 5182, 286, 9, 70, "Text",
  CellTags->{"S2.13.8", "8.13"}],
Cell[140176, 5193, 424, 12, 70, "Text",
  CellTags->{"S2.13.8", "8.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[140637, 5210, 123, 4, 70, "Subsection",
  CellTags->{"S2.13.9", "9.1"}],
Cell[140763, 5216, 534, 14, 70, "Text",
  CellTags->{"S2.13.9", "9.2"}],
Cell[141300, 5232, 200, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.3"}],

Cell[CellGroupData[{
Cell[141525, 5241, 93, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[141621, 5245, 108, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[141744, 5251, 197, 7, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.4"}],

Cell[CellGroupData[{
Cell[141966, 5262, 70, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[142039, 5266, 69, 2, 70, "Print",
  CellTags->"S2.13.9"],
Cell[142111, 5270, 532, 15, 70, "Print",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[142658, 5288, 306, 9, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.5"}],
Cell[142967, 5299, 101, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[143071, 5303, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.6"}],

Cell[CellGroupData[{
Cell[143261, 5312, 79, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[143343, 5316, 103, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[143461, 5322, 548, 14, 70, "Text",
  CellTags->{"S2.13.9", "9.7"}],
Cell[144012, 5338, 484, 14, 70, "DefinitionBox",
  CellTags->"S2.13.9"],
Cell[144499, 5354, 114, 4, 70, "Caption",
  CellTags->"S2.13.9"],
Cell[144616, 5360, 55, 1, 70, "ProgramTop",
  CellTags->{"S2.13.9", "9.8"}],
Cell[144674, 5363, 88, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.9"}],
Cell[144765, 5369, 176, 7, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.10"}],
Cell[144944, 5378, 98, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.11"}],
Cell[145045, 5381, 596, 23, 70, "Program",
  CellTags->{"S2.13.9", "9.12"}],
Cell[145644, 5406, 173, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.13"}],
Cell[145820, 5413, 77, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.14"}],
Cell[145900, 5419, 347, 12, 70, "Program",
  CellTags->{"S2.13.9", "9.15"}],
Cell[146250, 5433, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.9", "9.16"}],
Cell[146312, 5436, 169, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.17"}],

Cell[CellGroupData[{
Cell[146506, 5445, 94, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[146603, 5449, 110, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[146728, 5455, 88, 1, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.18"}],

Cell[CellGroupData[{
Cell[146841, 5460, 94, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[146938, 5464, 110, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[147063, 5470, 141, 4, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.19"}],

Cell[CellGroupData[{
Cell[147229, 5478, 80, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[147312, 5482, 85, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[147412, 5488, 142, 4, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.20"}],

Cell[CellGroupData[{
Cell[147579, 5496, 80, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[147662, 5500, 85, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[147762, 5506, 116, 2, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.21"}],

Cell[CellGroupData[{
Cell[147903, 5512, 80, 2, 70, "Input",
  CellTags->"S2.13.9"],
Cell[147986, 5516, 85, 3, 70, "Output",
  CellTags->"S2.13.9"]
}, Open  ]],
Cell[148086, 5522, 314, 6, 70, "Text",
  CellTags->{"S2.13.9", "9.22"}],
Cell[148403, 5530, 264, 6, 70, "Text",
  CellTags->{"S2.13.9", "9.23"}],
Cell[148670, 5538, 557, 16, 70, "DefinitionBox",
  CellTags->"S2.13.9"],
Cell[149230, 5556, 134, 5, 70, "Caption",
  CellTags->"S2.13.9"],
Cell[149367, 5563, 333, 10, 70, "Text",
  CellTags->{"S2.13.9", "9.24"}],
Cell[149703, 5575, 462, 13, 70, "Text",
  CellTags->{"S2.13.9", "9.25"}],
Cell[150168, 5590, 295, 9, 70, "Text",
  CellTags->{"S2.13.9", "9.26"}],
Cell[150466, 5601, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.13.9", "9.27"}],
Cell[150525, 5604, 55, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.28"}],
Cell[150583, 5607, 131, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.29"}],
Cell[150717, 5614, 98, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.30"}],
Cell[150818, 5617, 178, 7, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.31"}],
Cell[150999, 5626, 133, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.32"}],
Cell[151135, 5632, 131, 4, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.33"}],
Cell[151269, 5638, 82, 4, 70, "Program",
  CellTags->{"S2.13.9", "9.34"}],
Cell[151354, 5644, 146, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.35"}],
Cell[151503, 5651, 99, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.36"}],
Cell[151605, 5654, 157, 5, 70, "MathCaption",
  CellTags->{"S2.13.9", "9.37"}],
Cell[151765, 5661, 80, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.38"}],
Cell[151848, 5664, 55, 1, 70, "Program",
  CellTags->{"S2.13.9", "9.39"}],
Cell[151906, 5667, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.9", "9.40"}],
Cell[151968, 5670, 494, 14, 70, "DefinitionBox",
  CellTags->"S2.13.9"],
Cell[152465, 5686, 119, 5, 70, "Caption",
  CellTags->"S2.13.9"],
Cell[152587, 5693, 638, 19, 70, "Text",
  CellTags->{"S2.13.9", "9.41"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[153262, 5717, 117, 2, 70, "Subsection",
  CellTags->{"S2.13.10", "10.1"}],
Cell[153382, 5721, 455, 10, 70, "Text",
  CellTags->{"S2.13.10", "10.2"}],
Cell[153840, 5733, 132, 4, 70, "SessionLabel",
  CellTags->{"S2.13.10", "10.3"}],
Cell[153975, 5739, 165, 5, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.4"}],
Cell[154143, 5746, 109, 4, 70, "Program",
  CellTags->{"S2.13.10", "10.5"}],
Cell[154255, 5752, 139, 4, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.6"}],
Cell[154397, 5758, 192, 9, 70, "Program",
  CellTags->{"S2.13.10", "10.7"}],
Cell[154592, 5769, 157, 5, 70, "SessionLabel",
  CellTags->{"S2.13.10", "10.8"}],
Cell[154752, 5776, 106, 1, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.9"}],

Cell[CellGroupData[{
Cell[154883, 5781, 112, 2, 70, "Input",
  CellTags->"S2.13.10"],
Cell[154998, 5785, 102, 2, 70, "Output",
  CellTags->"S2.13.10"]
}, Open  ]],
Cell[155115, 5790, 170, 5, 70, "MathCaption",
  CellTags->{"S2.13.10", "10.10"}],

Cell[CellGroupData[{
Cell[155310, 5799, 70, 2, 70, "Input",
  CellTags->"S2.13.10"],
Cell[155383, 5803, 72, 2, 70, "Output",
  CellTags->"S2.13.10"]
}, Open  ]],
Cell[155470, 5808, 560, 12, 70, "Text",
  CellTags->{"S2.13.10", "10.11"}],
Cell[156033, 5822, 861, 26, 70, "DefinitionBox",
  CellTags->"S2.13.10"],
Cell[156897, 5850, 93, 1, 70, "Caption",
  CellTags->"S2.13.10"]
}, Open  ]],

Cell[CellGroupData[{
Cell[157027, 5856, 131, 4, 70, "Subsection",
  CellTags->{"S2.13.11", "11.1"}],
Cell[157161, 5862, 201, 5, 70, "Text",
  CellTags->{"S2.13.11", "11.2"}],
Cell[157365, 5869, 281, 7, 70, "Text",
  CellTags->{"S2.13.11", "11.3"}],
Cell[157649, 5878, 654, 20, 70, "DefinitionBox",
  CellTags->"S2.13.11"],
Cell[158306, 5900, 89, 1, 70, "Caption",
  CellTags->"S2.13.11"],
Cell[158398, 5903, 261, 6, 70, "Text",
  CellTags->{"S2.13.11", "11.4"}],
Cell[158662, 5911, 66, 1, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.5"}],
Cell[158731, 5914, 139, 5, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.6"}],
Cell[158873, 5921, 238, 12, 70, "Program",
  CellTags->{"S2.13.11", "11.7"}],
Cell[159114, 5935, 84, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.8"}],
Cell[159201, 5938, 107, 4, 70, "Program",
  CellTags->{"S2.13.11", "11.9"}],
Cell[159311, 5944, 113, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.10"}],
Cell[159427, 5947, 193, 9, 70, "Program",
  CellTags->{"S2.13.11", "11.11"}],
Cell[159623, 5958, 116, 4, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.12"}],
Cell[159742, 5964, 117, 2, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.13"}],

Cell[CellGroupData[{
Cell[159884, 5970, 112, 2, 70, "Input",
  CellTags->"S2.13.11"],
Cell[159999, 5974, 102, 2, 70, "Output",
  CellTags->"S2.13.11"]
}, Open  ]],
Cell[160116, 5979, 135, 4, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.14"}],
Cell[160254, 5985, 70, 2, 70, "Input",
  CellTags->"S2.13.11"],
Cell[160327, 5989, 67, 1, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.15"}],
Cell[160397, 5992, 104, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.16"}],
Cell[160504, 5995, 116, 5, 70, "Program",
  CellTags->{"S2.13.11", "11.17"}],
Cell[160623, 6002, 94, 1, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.18"}],
Cell[160720, 6005, 101, 4, 70, "Program",
  CellTags->{"S2.13.11", "11.19"}],
Cell[160824, 6011, 116, 4, 70, "SessionLabel",
  CellTags->{"S2.13.11", "11.20"}],
Cell[160943, 6017, 117, 5, 70, "MathCaption",
  CellTags->{"S2.13.11", "11.21"}],
Cell[161063, 6024, 72, 2, 70, "Output",
  CellTags->"S2.13.11"]
}, Open  ]],

Cell[CellGroupData[{
Cell[161172, 6031, 109, 1, 70, "Subsection",
  CellTags->{"S2.13.12", "12.1"}],
Cell[161284, 6034, 705, 15, 70, "Text",
  CellTags->{"S2.13.12", "12.2"}],
Cell[161992, 6051, 1145, 32, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[163140, 6085, 86, 1, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[163229, 6088, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.3"}],
Cell[163289, 6091, 56, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.4"}],
Cell[163348, 6094, 85, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.5"}],
Cell[163436, 6097, 89, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.6"}],
Cell[163528, 6100, 190, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.7"}],
Cell[163721, 6109, 142, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.8"}],
Cell[163866, 6116, 56, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.9"}],
Cell[163925, 6119, 112, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.10"}],
Cell[164040, 6122, 142, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.11"}],
Cell[164185, 6129, 57, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.12"}],
Cell[164245, 6132, 95, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.13"}],
Cell[164343, 6135, 66, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.14"}],
Cell[164412, 6138, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.15"}],
Cell[164476, 6141, 310, 9, 70, "Text",
  CellTags->{"S2.13.12", "12.16"}],
Cell[164789, 6152, 313, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.17"}],
Cell[165105, 6164, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.18"}],
Cell[165166, 6167, 57, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.19"}],
Cell[165226, 6170, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.20"}],
Cell[165373, 6177, 122, 4, 70, "Program",
  CellTags->{"S2.13.12", "12.21"}],
Cell[165498, 6183, 180, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.22"}],
Cell[165681, 6192, 99, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.23"}],
Cell[165783, 6195, 187, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.24"}],
Cell[165973, 6204, 88, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.25"}],
Cell[166064, 6207, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.26"}],
Cell[166128, 6210, 208, 5, 70, "Text",
  CellTags->{"S2.13.12", "12.27"}],
Cell[166339, 6217, 406, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.28"}],
Cell[166748, 6229, 1335, 38, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[168086, 6269, 123, 5, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[168212, 6276, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.29"}],
Cell[168273, 6279, 57, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.30"}],
Cell[168333, 6282, 149, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.31"}],
Cell[168485, 6289, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.32"}],
Cell[168563, 6292, 130, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.33"}],
Cell[168696, 6299, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.34"}],
Cell[168774, 6302, 120, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.35"}],
Cell[168897, 6309, 84, 4, 70, "Program",
  CellTags->{"S2.13.12", "12.36"}],
Cell[168984, 6315, 195, 7, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.37"}],
Cell[169182, 6324, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.38"}],
Cell[169260, 6327, 117, 2, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.39"}],
Cell[169380, 6331, 78, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.40"}],
Cell[169461, 6334, 125, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.41"}],
Cell[169589, 6341, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.42"}],
Cell[169667, 6344, 125, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.43"}],
Cell[169795, 6351, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.44"}],
Cell[169873, 6354, 102, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.45"}],
Cell[169978, 6357, 78, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.46"}],
Cell[170059, 6360, 131, 5, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.47"}],
Cell[170193, 6367, 75, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.48"}],
Cell[170271, 6370, 179, 4, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.49"}],
Cell[170453, 6376, 78, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.50"}],
Cell[170534, 6379, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.51"}],
Cell[170598, 6382, 480, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.52"}],
Cell[171081, 6394, 2157, 59, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[173241, 6455, 100, 1, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[173344, 6458, 1005, 33, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[174352, 6493, 122, 5, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[174477, 6500, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.12", "12.53"}],
Cell[174538, 6503, 77, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.54"}],
Cell[174618, 6506, 91, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.55"}],
Cell[174712, 6509, 511, 17, 70, "Program",
  CellTags->{"S2.13.12", "12.56"}],
Cell[175226, 6528, 86, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.57"}],
Cell[175315, 6531, 124, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.58"}],
Cell[175442, 6538, 88, 1, 70, "MathCaption",
  CellTags->{"S2.13.12", "12.59"}],
Cell[175533, 6541, 122, 5, 70, "Program",
  CellTags->{"S2.13.12", "12.60"}],
Cell[175658, 6548, 55, 1, 70, "Program",
  CellTags->{"S2.13.12", "12.61"}],
Cell[175716, 6551, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.12", "12.62"}],
Cell[175780, 6554, 359, 9, 70, "Text",
  CellTags->{"S2.13.12", "12.63"}],
Cell[176142, 6565, 393, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.64"}],
Cell[176538, 6577, 2172, 59, 70, "DefinitionBox",
  CellTags->"S2.13.12"],
Cell[178713, 6638, 100, 1, 70, "Caption",
  CellTags->"S2.13.12"],
Cell[178816, 6641, 314, 10, 70, "Text",
  CellTags->{"S2.13.12", "12.65"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[179167, 6656, 108, 1, 70, "Subsection",
  CellTags->{"S2.13.13", "13.1"}],
Cell[179278, 6659, 375, 9, 70, "Text",
  CellTags->{"S2.13.13", "13.2"}],
Cell[179656, 6670, 1223, 33, 70, "DefinitionBox",
  CellTags->"S2.13.13"],
Cell[180882, 6705, 125, 5, 70, "Caption",
  CellTags->"S2.13.13"],
Cell[181010, 6712, 320, 9, 70, "Text",
  CellTags->{"S2.13.13", "13.3"}],
Cell[181333, 6723, 446, 12, 70, "DefinitionBox",
  CellTags->"S2.13.13"],
Cell[181782, 6737, 81, 1, 70, "Caption",
  CellTags->"S2.13.13"],
Cell[181866, 6740, 260, 7, 70, "Text",
  CellTags->{"S2.13.13", "13.4"}],
Cell[182129, 6749, 695, 14, 70, "Text",
  CellTags->{"S2.13.13", "13.5"}],
Cell[182827, 6765, 550, 16, 70, "DefinitionBox",
  CellTags->"S2.13.13"],
Cell[183380, 6783, 73, 1, 70, "Caption",
  CellTags->"S2.13.13"],
Cell[183456, 6786, 452, 11, 70, "Text",
  CellTags->{"S2.13.13", "13.6"}],
Cell[183911, 6799, 387, 9, 70, "Text",
  CellTags->{"S2.13.13", "13.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[184335, 6813, 160, 5, 70, "Subsection",
  CellTags->{"S2.13.14", "14.1"}],
Cell[184498, 6820, 363, 12, 70, "Text",
  CellTags->{"S2.13.14", "14.2"}],
Cell[184864, 6834, 633, 18, 70, "Text",
  CellTags->{"S2.13.14", "14.3"}],
Cell[185500, 6854, 2733, 78, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[188236, 6934, 129, 5, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[188368, 6941, 57, 1, 70, "ProgramTop",
  CellTags->{"S2.13.14", "14.4"}],
Cell[188428, 6944, 144, 5, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.5"}],
Cell[188575, 6951, 85, 4, 70, "Program",
  CellTags->{"S2.13.14", "14.6"}],
Cell[188663, 6957, 87, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.7"}],
Cell[188753, 6960, 105, 6, 70, "Program",
  CellTags->{"S2.13.14", "14.8"}],
Cell[188861, 6968, 146, 5, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.9"}],
Cell[189010, 6975, 79, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.10"}],
Cell[189092, 6978, 199, 6, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.11"}],
Cell[189294, 6986, 105, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.12"}],
Cell[189402, 6989, 140, 4, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.13"}],
Cell[189545, 6995, 74, 1, 70, "Program",
  CellTags->{"S2.13.14", "14.14"}],
Cell[189622, 6998, 70, 4, 70, "Program",
  CellTags->{"S2.13.14", "14.15"}],
Cell[189695, 7004, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.14", "14.16"}],
Cell[189759, 7007, 586, 19, 70, "Text",
  CellTags->{"S2.13.14", "14.17"}],
Cell[190348, 7028, 375, 14, 70, "Text",
  CellTags->{"S2.13.14", "14.18"}],
Cell[190726, 7044, 1789, 54, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[192518, 7100, 174, 7, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[192695, 7109, 278, 8, 70, "Text",
  CellTags->{"S2.13.14", "14.19"}],
Cell[192976, 7119, 305, 9, 70, "Text",
  CellTags->{"S2.13.14", "14.20"}],
Cell[193284, 7130, 913, 24, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[194200, 7156, 154, 5, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[194357, 7163, 312, 9, 70, "Text",
  CellTags->{"S2.13.14", "14.21"}],
Cell[194672, 7174, 284, 7, 70, "Text",
  CellTags->{"S2.13.14", "14.22"}],
Cell[194959, 7183, 249, 6, 70, "Text",
  CellTags->{"S2.13.14", "14.23"}],
Cell[195211, 7191, 4186, 120, 70, "DefinitionBox3Col",
  CellTags->"S2.13.14"],
Cell[199400, 7313, 130, 5, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[199533, 7320, 58, 1, 70, "ProgramTop",
  CellTags->{"S2.13.14", "14.24"}],
Cell[199594, 7323, 201, 6, 70, "MathCaption",
  CellTags->{"S2.13.14", "14.25"}],
Cell[199798, 7331, 135, 4, 70, "Program",
  CellTags->{"S2.13.14", "14.26"}],
Cell[199936, 7337, 61, 1, 70, "ProgramBottom",
  CellTags->{"S2.13.14", "14.27"}],
Cell[200000, 7340, 407, 11, 70, "Text",
  CellTags->{"S2.13.14", "14.28"}],
Cell[200410, 7353, 196, 6, 70, "Text",
  CellTags->{"S2.13.14", "14.29"}],
Cell[200609, 7361, 756, 23, 70, "DefinitionBox",
  CellTags->"S2.13.14"],
Cell[201368, 7386, 66, 1, 70, "Caption",
  CellTags->"S2.13.14"],
Cell[201437, 7389, 505, 12, 70, "Text",
  CellTags->{"S2.13.14", "14.30"}],
Cell[201945, 7403, 466, 17, 70, "Text",
  CellTags->{"S2.13.14", "14.31"}],
Cell[202414, 7422, 397, 10, 70, "Text",
  CellTags->{"S2.13.14", "14.32"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

