(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     95757,       3793]*)
(*NotebookOutlinePosition[    168810,       5554]*)
(*  CellTagsIndexPosition[    164260,       5405]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["A.11 ", "HeadingNumber"],
  "Listing of C Functions in the ",
  StyleBox["MathLink", "SBO"],
  " Library"
}], "Section",
  CellTags->{"SA.11.0", "0.1"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"SA.11.1", "1.1"}],

Cell[TextData[{
  "Listed here are functions provided in the ",
  StyleBox["MathLink", "TI"],
  " Developer Kit.    "
}], "Text",
  CellTags->{"SA.11.1", "1.2"}],

Cell[TextData[{
  "These functions are declared in the file ",
  StyleBox["mathlink.h", "MR"],
  ", which should be included in the source code for any ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible program. "
}], "Text",
  CellTags->{"SA.11.1", "1.3"}],

Cell[TextData[{
  "Unless you specify ",
  StyleBox["#define", "MR"],
  " ",
  StyleBox["MLPROTOTYPES", "MR"],
  " ",
  StyleBox["0", "MR"],
  " before ",
  StyleBox["#include", "MR"],
  " ",
  StyleBox["\"mathlink.h\"", "MR"],
  " the functions will be included with standard C prototypes. "
}], "Text",
  CellTags->{"SA.11.1", "1.4"}],

Cell[TextData[{
  "The following special types are defined in ",
  StyleBox["mathlink.h", "MR"],
  ": "
}], "Text",
  CellTags->{"SA.11.1", "1.5"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  ": a ",
  StyleBox["MathLink", "TI"],
  " link object (analogous to ",
  StyleBox["LinkObject", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ")  \n\[FilledSmallSquare] ",
  StyleBox["MLMARK", "MR"],
  ": a mark in a ",
  StyleBox["MathLink", "TI"],
  " stream  \n\[FilledSmallSquare] ",
  StyleBox["MLENV", "MR"],
  ": ",
  StyleBox["MathLink", "TI"],
  " library environment   "
}], "Notes",
  CellTags->{"SA.11.1", "1.6"}],

Cell[TextData[{
  "The following constants are set up when a ",
  StyleBox["MathLink", "TI"],
  " template file is processed: "
}], "Text",
  CellTags->{"SA.11.1", "1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK", "MR"],
  " ",
  StyleBox["stdlink", "MR"],
  ": the standard link that connects a program built from ",
  StyleBox["MathLink", "TI"],
  " templates to ",
  StyleBox["Mathematica", "TI"],
  " \n\[FilledSmallSquare] ",
  StyleBox["MLENV", "MR"],
  " ",
  StyleBox["stdenv", "MR"],
  ": the standard ",
  StyleBox["MathLink", "TI"],
  " environment in a program built from ",
  StyleBox["MathLink", "TI"],
  " templates   "
}], "Notes",
  CellTags->{"SA.11.1", "1.8"}],

Cell["\<\
All functions described here are C language functions. They can be \
called from other languages with appropriate wrappers. \
\>", "Text",
  CellTags->{"SA.11.1", "1.9"}],

Cell["The functions have the following general features: ", "Text",
  CellTags->{"SA.11.1", "1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] Those which return ",
  StyleBox["int", "MR"],
  " yield a non\[Hyphen]zero value if they succeed; otherwise they return ",
  StyleBox["0", "MR"],
  " and have no effect.  \n\[FilledSmallSquare] In a program set up using ",
  StyleBox["MathLink", "TI"],
  " templates, the link to ",
  StyleBox["Mathematica", "TI"],
  " is called ",
  StyleBox["stdlink", "MR"],
  ".  \n\[FilledSmallSquare] Functions which put data to a link do not \
deallocate memory used to store the data.  \n\[FilledSmallSquare] Functions \
which get data from a link may allocate memory to store the data.  \n\
\[FilledSmallSquare] Functions which get data from a link will not return \
until the necessary data becomes available. A yield function can be \
registered to be called during the wait.  "
}], "Notes",
  CellTags->{"SA.11.1", "1.11"}],

Cell[CellGroupData[{

Cell["MLAbort", "ObjectName",
  CellTags->{"S1.1001", "MLAbort"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int", "MR"],
  " ",
  StyleBox["MLAbort", "MR"],
  " is a global variable set when a program created using ",
  StyleBox["mcc", "MR"],
  " or ",
  StyleBox["mprep", "MR"],
  " has been sent an abort interrupt. "
}], "Usage",
  CellTags->{"S1.1001", "MLAbort"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkInterrupt[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " can be used to send an abort interrupt from ",
  StyleBox["Mathematica", "TI"],
  " to a program connected to a particular link. "
}], "Notes",
  CellTags->{"S1.1001", "MLAbort"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.5"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1001", "MLAbort"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLActivate()", "ObjectName",
  CellTags->{"S1.1002", "MLActivate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLActivate(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " activates a ",
  StyleBox["MathLink", "TI"],
  " connection, waiting for the program at the other end to respond. "
}], "Usage",
  CellTags->{"S1.1002", "MLActivate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLActivate()", "MR"],
  " can be called only after ",
  StyleBox["MLOpenArgv()", "MR"],
  " or ",
  StyleBox["MLOpenString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1002", "MLActivate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1002", "MLActivate"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLCheckFunction()", "ObjectName",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLCheckFunction(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["name", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " checks that a function whose head is a symbol with the specified name is \
on ",
  StyleBox["link", "TI"],
  ", and stores the number of the arguments of the function in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLCheckFunction()", "MR"],
  " returns ",
  StyleBox["0", "MR"],
  " if the current object on the link is not a function with a symbol as a \
head, or if the name of the symbol does not match ",
  StyleBox["name", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.125"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetFunction",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLClearError()", "ObjectName",
  CellTags->{"S1.1004", "MLClearError"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLClearError(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " if possible clears any error on ",
  StyleBox["link", "TI"],
  " and reactivates the link. "
}], "Usage",
  CellTags->{"S1.1004", "MLClearError"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLClearError()", "MR"],
  " returns ",
  StyleBox["0", "MR"],
  " if it was unable to clear the error. This can happen if the error was for \
example the result of a link no longer being open. "
}], "Notes",
  CellTags->{"S1.1004", "MLClearError"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1004", "MLClearError"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLClose()", "ObjectName",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLClose(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " closes a ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] Calling ",
  StyleBox["MLClose()", "MR"],
  " does not necessarily terminate a program at the other end of the link. "
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any data buffered in the link is sent when ",
  StyleBox["MLClose()", "MR"],
  " is called. "
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell["\<\
\[FilledSmallSquare] Programs should close all links they have \
opened before terminating. \
\>", "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDeinitialize",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1005", "MLClose"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLCreateMark()", "ObjectName",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMARK MLCreateMark(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " creates a mark at the current position in a sequence of expressions on a \
link. "
}], "Usage",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] Calling ",
  StyleBox["MLCreateMark()", "MR"],
  " effectively starts recording all expressions received on the link. "
}], "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLLoopbackOpen",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDeinitialize()", "ObjectName",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDeinitialize(MLENV ", "MR"],
  StyleBox["env", "TI"],
  StyleBox[")", "MR"],
  " deinitializes functions in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Usage",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] An appropriate call to ",
  StyleBox["MLDeinitialize()", "MR"],
  " is generated automatically when an external program is created from ",
  StyleBox["MathLink", "TI"],
  " templates. "
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any external program that uses the ",
  StyleBox["MathLink", "TI"],
  " library must call ",
  StyleBox["MLDeinitialize()", "MR"],
  " before exiting. "
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLClose()", "MR"],
  " must be called for all open links before calling ",
  StyleBox["MLDeinitialize()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDestroyMark()", "ObjectName",
  CellTags->{"S1.1008", "MLDestroyMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLDestroyMark(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", MLMARK ", "MR"],
  StyleBox["mark", "TI"],
  StyleBox[")", "MR"],
  " destroys the specified mark on a link. "
}], "Usage",
  CellTags->{"S1.1008", "MLDestroyMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] Calling ",
  StyleBox["MLDestroyMark()", "MR"],
  " disowns memory associated with the storage of expressions recorded after \
the mark. "
}], "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownByteString()", "ObjectName",
  CellTags->{"S1.1009", "MLDisownByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownByteString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", unsigned char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetByteString()", "MR"],
  " to store the array of character codes ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1009", "MLDisownByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDisownString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownIntegerArray()", "ObjectName",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownIntegerArray(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetIntegerArray()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  ", its dimensions ",
  StyleBox["dims", "TI"],
  " and the heads ",
  StyleBox["heads", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownIntegerList()", "ObjectName",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownIntegerList(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetIntegerList()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  " of length ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1011", "MLDisownIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownRealArray()", "ObjectName",
  CellTags->{"S1.1012", "MLDisownRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownRealArray(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetRealArray()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  ", its dimensions ",
  StyleBox["dims", "TI"],
  " and the heads ",
  StyleBox["heads", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1012", "MLDisownRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1012", "MLDisownRealArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownRealList()", "ObjectName",
  CellTags->{"S1.1013", "MLDisownRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownRealList(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetRealList()", "MR"],
  " to store the array ",
  StyleBox["a", "TI"],
  " of length ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1013", "MLDisownRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1013", "MLDisownRealList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownString()", "ObjectName",
  CellTags->{"S1.1014", "MLDisownString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetString()", "MR"],
  " to store the character string ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1014", "MLDisownString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.166"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1014", "MLDisownString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDisownUnicodeString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1014", "MLDisownString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownSymbol()", "ObjectName",
  CellTags->{"S1.1015", "MLDisownSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownSymbol(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetSymbol()", "MR"],
  " or ",
  StyleBox["MLGetFunction()", "MR"],
  " to store the character string ",
  StyleBox["s", "TI"],
  " corresponding to the name of a symbol. "
}], "Usage",
  CellTags->{"S1.1015", "MLDisownSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.166"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.168"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1015", "MLDisownSymbol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLDisownUnicodeString()", "ObjectName",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["void MLDisownUnicodeString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", unsigned short *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " disowns memory allocated by ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " to store the string ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLDisownString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLEndPacket()", "ObjectName",
  CellTags->{"S1.1017", "MLEndPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLEndPacket(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " specifies that a packet expression is complete and is ready to be sent on \
the specified link. "
}], "Usage",
  CellTags->{"S1.1017", "MLEndPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLEndPacket()", "MR"],
  " should be called to indicate the end of any top\[Hyphen]level expression, \
regardless of whether its head is a standard packet. "
}], "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.9",
    ButtonData:>{"2.13.9", "9.40"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLError()", "ObjectName",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["long MLError(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " returns a constant identifying the last error to occur on ",
  StyleBox["link", "TI"],
  ", or ",
  StyleBox["0", "MR"],
  " if none has occurred since the previous call to ",
  StyleBox["MLClearError()", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can get a textual description of errors by \
calling ",
  StyleBox["MLErrorMessage()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] Constants corresponding to standard ",
  StyleBox["MathLink", "TI"],
  " errors are defined in ",
  StyleBox["mathlink.h", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1018", "MLError"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1018", "MLError"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLErrorMessage()", "ObjectName",
  CellTags->{"S1.1019", "MLErrorMessage"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["char *MLErrorMessage(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " returns a character string describing the last error to occur on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1019", "MLErrorMessage"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1019", "MLErrorMessage"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLEvaluateString()", "ObjectName",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLEvaluateString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["string", "TI"],
  StyleBox[")", "MR"],
  " sends a string to ",
  StyleBox["Mathematica", "TI"],
  " for evaluation, and discards any packets sent in response. "
}], "Usage",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The code for ",
  StyleBox["MLEvaluateString()", "MR"],
  " is not included in the ",
  StyleBox["MathLink", "TI"],
  " library, but is generated automatically by ",
  StyleBox["mcc", "MR"],
  " or ",
  StyleBox["mprep", "MR"],
  " in processing ",
  StyleBox["MathLink", "TI"],
  " template files. "
}], "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLEvaluateString(\"Print[\[Backslash]\"", "MR"],
  StyleBox["string", "TI"],
  "\[Backslash]",
  StyleBox["\"]\")", "MR"],
  " will cause ",
  StyleBox["string", "TI"],
  " to be printed in a ",
  StyleBox["Mathematica", "TI"],
  " session at the other end of the link. "
}], "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.3",
    ButtonData:>{"2.13.3", "3.70"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.9",
    ButtonData:>{"2.13.9", "9.23"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLFlush()", "ObjectName",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLFlush(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " flushes out any buffers containing data waiting to be sent on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you call ",
  StyleBox["MLNextPacket()", "MR"],
  " or any of the ",
  StyleBox["MLGet*()", "MR"],
  " functions, then ",
  StyleBox["MLFlush()", "MR"],
  " will be called automatically. "
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you call ",
  StyleBox["MLReady()", "MR"],
  ", then you need to call ",
  StyleBox["MLFlush()", "MR"],
  " first in order to ensure that any necessary outgoing data has been sent. \
"
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.29"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLReady",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1021", "MLFlush"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetArgCount()", "ObjectName",
  CellTags->{"S1.1022", "MLGetArgCount"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetArgCount(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " finds the number of arguments to a function on ",
  StyleBox["link", "TI"],
  " and stores the result in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1022", "MLGetArgCount"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1022", "MLGetArgCount"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetByteString()", "ObjectName",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetByteString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", unsigned char **", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["spec", "TI"],
  StyleBox[")", "MR"],
  " gets a string of characters from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the codes for the characters in ",
  StyleBox["s", "TI"],
  " and the number of characters in ",
  StyleBox["n", "TI"],
  ". The code ",
  StyleBox["spec", "TI"],
  " is used for any character whose ",
  StyleBox["Mathematica", "TI"],
  " character code is larger than 255. "
}], "Usage",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetByteString()", "MR"],
  " allocates memory for the array of character codes. You must call ",
  StyleBox["MLDisownByteString()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetByteString()", "MR"],
  " is convenient in situations where no special characters occur. "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The character codes used by ",
  StyleBox["MLGetByteString()", "MR"],
  " are exactly the ones returned by ",
  StyleBox["ToCharacterCode", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array of character codes in ",
  StyleBox["MLGetByteString()", "MR"],
  " is not terminated by a null character. "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] Characters such as newlines are specified by their \
raw character codes, not by ASCII forms such as \[Backslash]",
  StyleBox["n", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetUnicodeString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetDouble()", "ObjectName",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetDouble(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double *", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " gets a floating\[Hyphen]point number from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as C type ",
  StyleBox["double", "MR"],
  " in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetDouble()", "MR"],
  " is normally equivalent to ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetFloat",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetFloat()", "ObjectName",
  CellTags->{"S1.1025", "MLGetFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetFloat(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", float *", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " gets a floating\[Hyphen]point number from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as C type ",
  StyleBox["float", "MR"],
  " in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1025", "MLGetFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetFunction()", "ObjectName",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetFunction(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a function with a symbol as a head from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the name of the symbol in ",
  StyleBox["s", "TI"],
  " and the number of arguments of the function in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetFunction()", "MR"],
  " allocates memory for the character string corresponding to the name of \
the head of the function. You must call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the character \
string ",
  StyleBox["s", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetFunction(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", &", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", &", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " has the same effect as ",
  StyleBox["MLGetNext(", "MR"],
  StyleBox["link", "TI"],
  StyleBox["); MLGetArgCount(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", &", "MR"],
  StyleBox["n", "TI"],
  StyleBox[");", "MR"],
  " ",
  StyleBox["MLGetSymbol(", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", &", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.168"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetNext",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetInteger()", "ObjectName",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetInteger(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int *", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " gets an integer from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it in ",
  StyleBox["i", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to a real number, \
",
  StyleBox["MLGetInteger()", "MR"],
  " will round it to an integer. "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to an integer too \
large to store in a C ",
  StyleBox["int", "MR"],
  " on your computer system, then ",
  StyleBox["MLGetInteger()", "MR"],
  " will fail, and return ",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can get arbitrary\[Hyphen]precision integers by \
first using ",
  StyleBox["IntegerDigits", "MR"],
  " to generate lists of digits, then calling ",
  StyleBox["MLGetIntegerList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.105"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetShortInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetLongInteger",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetIntegerArray()", "ObjectName",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetIntegerArray(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int **", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long **", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[", char ***", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " gets an array of integers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the array in ",
  StyleBox["a", "TI"],
  ", its dimensions in ",
  StyleBox["dims", "TI"],
  " and its depth in ",
  StyleBox["d", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " is laid out in memory like a C array declared as ",
  StyleBox["int a[m][n] ", "MR"],
  "\[Ellipsis]",
  StyleBox[" ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["heads", "TI"],
  " gives a list of character strings corresponding to the names of symbols \
that appear as heads at each level in the array. "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetIntegerArray()", "MR"],
  " allocates memory which must be disowned by calling ",
  StyleBox["MLDisownIntegerArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the arrays \
generated by ",
  StyleBox["MLGetIntegerArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetIntegerList()", "ObjectName",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetIntegerList(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int **", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a list of integers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the integers in the array ",
  StyleBox["a", "TI"],
  " and the length of the list in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetIntegerList()", "MR"],
  " allocates memory for the array of integers. You must call ",
  StyleBox["MLDisownIntegerList()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the array \
generated by ",
  StyleBox["MLGetIntegerList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetIntegerArray",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetLongInteger()", "ObjectName",
  CellTags->{"S1.1030", "MLGetLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetLongInteger(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " gets an integer from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as a C ",
  StyleBox["long", "MR"],
  " in ",
  StyleBox["i", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1030", "MLGetLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetNext()", "ObjectName",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetNext(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " goes to the next object on ",
  StyleBox["link", "TI"],
  " and returns its type. "
}], "Usage",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell["\<\
\[FilledSmallSquare] The following values can be returned: \
\>", \
"Notes",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MLTKERR", "MR"],
              " "
            }]], Cell["error "]},
          {Cell[TextData[{
              StyleBox["MLTKINT", "MR"],
              " "
            }]], Cell["integer "]},
          {Cell[TextData[{
              StyleBox["MLTKFUNC", "MR"],
              " "
            }]], Cell["composite function "]},
          {Cell[TextData[{
              StyleBox["MLTKREAL", "MR"],
              " "
            }]], Cell["approximate real number "]},
          {Cell[TextData[{
              StyleBox["MLTKSTR", "MR"],
              " "
            }]], Cell["character string "]},
          {Cell[TextData[{
              StyleBox["MLTKSYM", "MR"],
              " "
            }]], Cell["symbol "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"MLGetNext", "S1.1031"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLTKINT", "MR"],
  " and ",
  StyleBox["MLTKREAL", "MR"],
  " do not necessarily signify numbers that can be stored in C ",
  StyleBox["int", "MR"],
  " and ",
  StyleBox["double", "MR"],
  " variables. "
}], "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetArgCount",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1031", "MLGetNext"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetReal()", "ObjectName",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetReal(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double *", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " gets a floating\[Hyphen]point number from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it in ",
  StyleBox["x", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to an integer, ",
  StyleBox["MLGetReal()", "MR"],
  " will coerce it to a ",
  StyleBox["double", "MR"],
  " before storing it in ",
  StyleBox["x", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the data on the link corresponds to a number \
outside the range that can be stored in a C ",
  StyleBox["double", "MR"],
  " on your computer system, then ",
  StyleBox["MLGetReal()", "MR"],
  " will fail, and return ",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can get arbitrary\[Hyphen]precision real numbers \
by first using ",
  StyleBox["RealDigits", "MR"],
  " to generate lists of digits, then calling ",
  StyleBox["MLGetIntegerList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetReal()", "MR"],
  " is normally equivalent to ",
  StyleBox["MLGetDouble()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.105"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetFloat",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetDouble",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetRealList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1032", "MLGetReal"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetRealArray()", "ObjectName",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetRealArray(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double **", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long **", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[", char ***", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " gets an array of floating\[Hyphen]point numbers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the array in ",
  StyleBox["a", "TI"],
  ", its dimensions in ",
  StyleBox["dims", "TI"],
  " and its depth in ",
  StyleBox["d", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " is laid out in memory like a C array declared as ",
  StyleBox["double a[m][n] ", "MR"],
  "\[Ellipsis]",
  StyleBox[" ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["heads", "TI"],
  " gives a list of character strings corresponding to the names of symbols \
that appear as heads at each level in the array. "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetRealArray()", "MR"],
  " allocates memory which must be disowned by calling ",
  StyleBox["MLDisownRealArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the arrays \
generated by ",
  StyleBox["MLGetRealArray()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.162"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetRealList()", "ObjectName",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetRealList(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double **", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a list of floating\[Hyphen]point numbers from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the numbers in the array ",
  StyleBox["a", "TI"],
  " and the length of the list in ",
  StyleBox["n", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetRealList()", "MR"],
  " allocates memory for the array of numbers. You must call ",
  StyleBox["MLDisownRealList()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify the array \
generated by ",
  StyleBox["MLGetRealList()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.146"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetShortInteger()", "ObjectName",
  CellTags->{"S1.1035", "MLGetShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetShortInteger(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", short *", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " gets an integer from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " and stores it as a C ",
  StyleBox["short", "MR"],
  " in ",
  StyleBox["i", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1035", "MLGetShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLGetInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetString()", "ObjectName",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " gets a character string from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the string in ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " allocates memory for the character string. You must call ",
  StyleBox["MLDisownString()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify strings generated \
by ",
  StyleBox["MLGetString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " creates a string that is terminated by \[Backslash]",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " stores single \[Backslash] characters from ",
  StyleBox["Mathematica", "TI"],
  " as pairs of characters \[Backslash]\[Backslash]. "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetString()", "MR"],
  " stores special characters from ",
  StyleBox["Mathematica", "TI"],
  " in a private format. "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetByteString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetUnicodeString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1036", "MLGetString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetSymbol()", "ObjectName",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetSymbol(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " gets a character string corresponding to the name of a symbol from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the resulting string in ",
  StyleBox["s", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetSymbol()", "MR"],
  " allocates memory for the character string. You must call ",
  StyleBox["MLDisownSymbol()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetSymbol()", "MR"],
  " creates a string that is terminated by \[Backslash]",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.166"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.52"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLGetUnicodeString()", "ObjectName",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLGetUnicodeString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", unsigned short **", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " gets a character string from the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", storing the string in ",
  StyleBox["s", "TI"],
  " as a sequence of 16\[Hyphen]bit Unicode characters. "
}], "Usage",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " allocates memory for the character string. You must call ",
  StyleBox["MLDisownUnicodeString()", "MR"],
  " to disown this memory. "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs should not modify strings generated \
by ",
  StyleBox["MLGetUnicodeString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLGetUnicodeString()", "MR"],
  " stores all characters directly in 16\[Hyphen]bit Unicode form. "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell["\<\
\[FilledSmallSquare] 8\[Hyphen]bit ASCII characters are stored with \
a null high\[Hyphen]order byte. \
\>", "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLGetByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLInitialize()", "ObjectName",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLENV MLInitialize(0)", "MR"],
  " initializes functions in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Usage",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] An appropriate call to ",
  StyleBox["MLInitialize()", "MR"],
  " is generated automatically when an external program is created from ",
  StyleBox["MathLink", "TI"],
  " templates. "
}], "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any external program that uses the ",
  StyleBox["MathLink", "TI"],
  " library must call ",
  StyleBox["MLInitialize()", "MR"],
  " before calling any other ",
  StyleBox["MathLink", "TI"],
  " library functions. "
}], "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1039", "MLInitialize"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLLoopbackOpen()", "ObjectName",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK MLLoopbackOpen(MLENV ", "MR"],
  StyleBox["env", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  " opens a loopback ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] In an external program set up with ",
  StyleBox["MathLink", "TI"],
  " templates, the environment ",
  StyleBox["stdenv", "MR"],
  " should be used. "
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use loopback links to effectively store ",
  StyleBox["Mathematica", "TI"],
  " expressions in external programs. "
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLCreateMark",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLMain()", "ObjectName",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLMain(int ", "MR"],
  StyleBox["argc", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["argv", "TI"],
  StyleBox[")", "MR"],
  " sets up communication between an external program started using ",
  StyleBox["Install", "MR"],
  " and ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] The code for ",
  StyleBox["MLMain()", "MR"],
  " is generated automatically by ",
  StyleBox["mprep", "MR"],
  " or ",
  StyleBox["mcc", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMain()", "MR"],
  " opens a ",
  StyleBox["MathLink", "TI"],
  " connection using the parameters specified in ",
  StyleBox["argv", "TI"],
  ", then goes into a loop waiting for ",
  StyleBox["CallPacket", "MR"],
  " objects to arrive from ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMain()", "MR"],
  " internally calls ",
  StyleBox["MLOpenArgv()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.3",
    ButtonData:>{"2.13.3", "3.70"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1041", "MLMain"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLNewPacket()", "ObjectName",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLNewPacket(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " skips to the end of the current packet on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLNewPacket()", "MR"],
  " works even if the head of the current top\[Hyphen]level expression is not \
a standard packet type. "
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLNewPacket()", "MR"],
  " does nothing if you are already at the end of a packet. "
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.13",
    ButtonData:>{"2.13.13", "13.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLNextPacket",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLNextPacket()", "ObjectName",
  CellTags->{"S1.1043", "MLNextPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLNextPacket(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " goes to the next packet on ",
  StyleBox["link", "TI"],
  " and returns a constant to indicate its head. "
}], "Usage",
  CellTags->{"S1.1043", "MLNextPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.20"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLNewPacket",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLOpenArgv()", "ObjectName",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK MLOpenArgv(MLENV ", "MR"],
  StyleBox["env", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["argv0", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["argv1", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  " opens a ",
  StyleBox["MathLink", "TI"],
  " connection taking parameters from an ",
  StyleBox["argv", "MR"],
  " array. "
}], "Usage",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLInitialize()", "MR"],
  " must be called before ",
  StyleBox["MLOpenArgv()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " scans for the following at successive locations starting at ",
  StyleBox["argv0", "TI"],
  " and going up to just before ",
  StyleBox["argv1", "TI"],
  ": "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"-linkconnect\"", "MR"],
              " "
            }]], Cell[TextData[{
              "connect to an existing link (",
              StyleBox["LinkConnect", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkcreate\"", "MR"],
              " "
            }]], Cell[TextData[{
              "create a link (",
              StyleBox["LinkCreate", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linklaunch\"", "MR"],
              " "
            }]], Cell[TextData[{
              "launch a child process (",
              StyleBox["LinkLaunch", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["\"-linkname\", \"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["the name to use in opening the link "]},
          {Cell[TextData[{
              StyleBox["\"-linkprotocol\", \"", "MR"],
              StyleBox["protocol", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "the link protocol to use (",
              StyleBox["tcp", "MR"],
              ", ",
              StyleBox["pipes", "MR"],
              ", etc.) "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"MLOpenArgv", "S1.1044"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " is not sensitive to the case of argument names. "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " ignores argument names that it does not recognize. "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenArgv()", "MR"],
  " is called automatically by the ",
  StyleBox["MLMain()", "MR"],
  " function created by ",
  StyleBox["mprep", "MR"],
  " and ",
  StyleBox["mcc", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] With a main program ",
  StyleBox["main(int", "MR"],
  " ",
  StyleBox["argc,", "MR"],
  " ",
  StyleBox["char", "MR"],
  " ",
  StyleBox["*argv[])", "MR"],
  " typical usage is ",
  StyleBox["MLOpenArgv(", "MR"],
  StyleBox["env", "TI"],
  StyleBox[", argv, argv+argc, ", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Avoiding an explicit ",
  StyleBox["argc", "MR"],
  " argument allows ",
  StyleBox["MLOpenArgv()", "MR"],
  " to work independent of the size of an ",
  StyleBox["int", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] On some computer systems, giving ",
  StyleBox["0", "MR"],
  " for ",
  StyleBox["argv0", "TI"],
  " and ",
  StyleBox["argv1", "TI"],
  " will cause arguments to be requested interactively, typically through a \
dialog box. "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLActivate",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLOpenString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLOpenString()", "ObjectName",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLINK MLOpenString(MLENV ", "MR"],
  StyleBox["env", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["string", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["errno", "TI"],
  StyleBox[")", "MR"],
  " opens a ",
  StyleBox["MathLink", "TI"],
  " connection taking parameters from a character string. "
}], "Usage",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLInitialize()", "MR"],
  " must be called before ",
  StyleBox["MLOpenString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLOpenString()", "MR"],
  " takes a single string instead of the ",
  StyleBox["argv", "TI"],
  " array used by ",
  StyleBox["MLOpenArgv()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell["\<\
\[FilledSmallSquare] Arguments in the string are separated by \
spaces. \
\>", "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] On some computer systems, giving ",
  StyleBox["NULL", "MR"],
  " in place of the string pointer will cause arguments to be requested \
interactively, typically through a dialog box. "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLActivate",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLOpenArgv",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1045", "MLOpenString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutArgCount()", "ObjectName",
  CellTags->{"S1.1046", "MLPutArgCount"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutArgCount(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " specifies the number of arguments of a composite function to be put on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1046", "MLPutArgCount"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutByteString()", "ObjectName",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutByteString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", unsigned char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a string of ",
  StyleBox["n", "TI"],
  " characters starting from location ",
  StyleBox["s", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] All characters in the string must be specified using \
character codes as obtained from ",
  StyleBox["ToCharacterCode", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] Newlines must thus be specified in terms of their raw \
character codes, rather than using \[Backslash]",
  StyleBox["n", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLPutByteString()", "MR"],
  " handles only characters with codes less than 256. "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell["\<\
\[FilledSmallSquare] It can handle both ordinary ASCII as well as \
ISO Latin\[Hyphen]1 characters. \
\>", "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutDouble()", "ObjectName",
  CellTags->{"S1.1048", "MLPutDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutDouble(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double ", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " puts the floating\[Hyphen]point number ",
  StyleBox["x", "TI"],
  " of C type ",
  StyleBox["double", "MR"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1048", "MLPutDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutFloat()", "ObjectName",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutFloat(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double ", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " puts the floating\[Hyphen]point number ",
  StyleBox["x", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " with a precision corresponding to the C type ",
  StyleBox["float", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] The argument ",
  StyleBox["x", "TI"],
  " is typically declared as ",
  StyleBox["float", "MR"],
  " in external programs, but must be declared as ",
  StyleBox["double", "MR"],
  " in ",
  StyleBox["MLPutFloat()", "MR"],
  " itself in order to work even in the absence of C prototypes. "
}], "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutReal()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutFunction()", "ObjectName",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutFunction(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a function with head given by a symbol with name ",
  StyleBox["s", "TI"],
  " and with ",
  StyleBox["n", "TI"],
  " arguments to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] After the call to ",
  StyleBox["MLPutFunction()", "MR"],
  " other ",
  StyleBox["MathLink", "TI"],
  " functions must be called to send the arguments of the function. "
}], "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutInteger()", "ObjectName",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutInteger(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int ", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " puts the integer ",
  StyleBox["i", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can send arbitrary\[Hyphen]precision integers to \
",
  StyleBox["Mathematica", "TI"],
  " by giving lists of digits, then converting them to numbers using ",
  StyleBox["FromDigits", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLGetInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutShortInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutLongInteger",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutIntegerArray()", "ObjectName",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutIntegerArray(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " puts an array of integers to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " to form a depth ",
  StyleBox["d", "TI"],
  " array with dimensions ",
  StyleBox["dims", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " must be laid out in memory like a C array declared explicitly as ",
  StyleBox["int a[m][n] ", "MR"],
  "\[Ellipsis]",
  StyleBox[" ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["heads", "TI"],
  " is given as ",
  StyleBox["NULL", "MR"],
  ", the array will be assumed to have head ",
  StyleBox["List", "MR"],
  " at every level. "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The length of the array at level ",
  StyleBox["i", "TI"],
  " is taken to be ",
  StyleBox["dims[i]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutIntegerList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutIntegerList()", "ObjectName",
  CellTags->{"S1.1053", "MLPutIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutIntegerList(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a list of ",
  StyleBox["n", "TI"],
  " integers starting from location ",
  StyleBox["a", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1053", "MLPutIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutIntegerArray",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutLongInteger()", "ObjectName",
  CellTags->{"S1.1054", "MLPutLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutLongInteger(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " puts the long integer ",
  StyleBox["i", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1054", "MLPutLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutNext()", "ObjectName",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutNext(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int ", "MR"],
  StyleBox["type", "TI"],
  StyleBox[")", "MR"],
  " prepares to put an object of the specified type on ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] The type specifications are as given in the notes for \
",
  StyleBox["MLGetNext()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutArgCount",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1055", "MLPutNext"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutReal()", "ObjectName",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutReal(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double ", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " puts the floating\[Hyphen]point number ",
  StyleBox["x", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can send arbitrary\[Hyphen]precision real numbers \
to ",
  StyleBox["Mathematica", "TI"],
  " by giving lists of digits, then converting them to numbers using ",
  StyleBox["FromDigits", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLPutReal()", "MR"],
  " is normally equivalent to ",
  StyleBox["MLPutDouble()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutRealList",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutFloat",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutDouble",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1056", "MLPutReal"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutRealArray()", "ObjectName",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutRealArray(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long *", "MR"],
  StyleBox["dims", "TI"],
  StyleBox[", char **", "MR"],
  StyleBox["heads", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["d", "TI"],
  StyleBox[")", "MR"],
  " puts an array of floating\[Hyphen]point numbers to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  " to form a depth ",
  StyleBox["d", "TI"],
  " array with dimensions ",
  StyleBox["dims", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The array ",
  StyleBox["a", "TI"],
  " must be laid out in memory like a C array declared explicitly as ",
  StyleBox["double a[m][n] ", "MR"],
  "\[Ellipsis]",
  StyleBox[" ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["heads", "TI"],
  " is given as ",
  StyleBox["NULL", "MR"],
  ", the array will be assumed to have head ",
  StyleBox["List", "MR"],
  " at every level. "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] The length of the array at level ",
  StyleBox["i", "TI"],
  " is taken to be ",
  StyleBox["dims[i]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutRealList",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutRealList()", "ObjectName",
  CellTags->{"S1.1058", "MLPutRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutRealList(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", double *", "MR"],
  StyleBox["a", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a list of ",
  StyleBox["n", "TI"],
  " floating\[Hyphen]point numbers starting from location ",
  StyleBox["a", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1058", "MLPutRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutRealArray",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutShortInteger()", "ObjectName",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutShortInteger(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", int ", "MR"],
  StyleBox["i", "TI"],
  StyleBox[")", "MR"],
  " puts the integer ",
  StyleBox["i", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ", assuming that ",
  StyleBox["i", "TI"],
  " contains only the number of digits in the C type ",
  StyleBox["short", "MR"],
  ". "
}], "Usage",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] The argument ",
  StyleBox["i", "TI"],
  " is typically declared as ",
  StyleBox["short", "MR"],
  " in external programs, but must be declared as ",
  StyleBox["int", "MR"],
  " in ",
  StyleBox["MLPutShortInteger()", "MR"],
  " itself in order to work even in the absence of C prototypes. "
}], "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See notes for ",
  StyleBox["MLPutInteger()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutString()", "ObjectName",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " puts a character string to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] The character string must be terminated with a null \
byte, corresponding to \[Backslash]",
  StyleBox["0", "MR"],
  " in C. "
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell["\<\
\[FilledSmallSquare] A raw backslash in the string must be sent as \
two characters \[Backslash]\[Backslash]. \
\>", "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] Special characters can be sent only using the private \
format returned by ",
  StyleBox["MLGetString()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutByteString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutUnicodeString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutSymbol",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1060", "MLPutString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutSymbol()", "ObjectName",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutSymbol(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", char *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[")", "MR"],
  " puts a symbol whose name is given by the character string ",
  StyleBox["s", "TI"],
  " to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] The character string must be terminated with \
\[Backslash]",
  StyleBox["0", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.4",
    ButtonData:>{"2.13.4", "4.21"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.64"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLPutUnicodeString()", "ObjectName",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLPutUnicodeString(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", unsigned short *", "MR"],
  StyleBox["s", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " puts a string of ",
  StyleBox["n", "TI"],
  " 16\[Hyphen]bit Unicode characters to the ",
  StyleBox["MathLink", "TI"],
  " connection specified by ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell["\<\
\[FilledSmallSquare] All characters are assumed to be 16 bit. \
\
\>", "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell["\<\
\[FilledSmallSquare] 8\[Hyphen]bit characters can be sent by having \
the higher\[Hyphen]order byte be null. \
\>", "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["MLPutString",
    ButtonStyle->"MainBookLink"],
  ", ",
  ButtonBox["MLPutByteString",
    ButtonStyle->"MainBookLink"],
  ". "
}], "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLReady()", "ObjectName",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLReady(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[")", "MR"],
  " tests whether there is data ready to be read from ",
  StyleBox["link", "TI"],
  ". "
}], "Usage",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] Analogous to the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["LinkReadyQ", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLReady()", "MR"],
  " is often called in a loop as a way of polling a ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLReady()", "MR"],
  " will always return immediately, and will not block. "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] You need to call ",
  StyleBox["MLFlush()", "MR"],
  " before starting to call ",
  StyleBox["MLReady()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.14",
    ButtonData:>{"2.13.14", "14.29"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1063", "MLReady"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLSeekMark()", "ObjectName",
  CellTags->{"S1.1064", "MLSeekMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MLMARK MLSeekMark(MLINK ", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", MLMARK ", "MR"],
  StyleBox["mark", "TI"],
  StyleBox[", long ", "MR"],
  StyleBox["n", "TI"],
  StyleBox[")", "MR"],
  " goes back to a position ",
  StyleBox["n", "TI"],
  " expressions after the specified mark on a link. "
}], "Usage",
  CellTags->{"S1.1064", "MLSeekMark"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1064", "MLSeekMark"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MLTransferExpression()", "ObjectName",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["int MLTransferExpression(MLINK ", "MR"],
  StyleBox["dest", "TI"],
  StyleBox[", MLINK ", "MR"],
  StyleBox["src", "TI"],
  StyleBox[")", "MR"],
  " transfers an expression from one ",
  StyleBox["MathLink", "TI"],
  " connection to another. "
}], "Usage",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["src", "TI"],
  " and ",
  StyleBox["dest", "TI"],
  " need not be distinct. "
}], "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["src", "TI"],
  " and ",
  StyleBox["dest", "TI"],
  " can be either loopback or ordinary links. "
}], "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.12",
    ButtonData:>{"2.13.12", "12.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SA.11.0"->{
    Cell[1776, 53, 180, 6, 70, "Section",
      CellTags->{"SA.11.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 180, 6, 70, "Section",
      CellTags->{"SA.11.0", "0.1"}]},
  "SA.11.1"->{
    Cell[1981, 63, 66, 1, 70, "Subsection",
      CellTags->{"SA.11.1", "1.1"}],
    Cell[2050, 66, 161, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.2"}],
    Cell[2214, 73, 262, 7, 70, "Text",
      CellTags->{"SA.11.1", "1.3"}],
    Cell[2479, 82, 336, 13, 70, "Text",
      CellTags->{"SA.11.1", "1.4"}],
    Cell[2818, 97, 147, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.5"}],
    Cell[2968, 104, 503, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.6"}],
    Cell[3474, 125, 171, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.7"}],
    Cell[3648, 132, 528, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.8"}],
    Cell[4179, 153, 180, 4, 70, "Text",
      CellTags->{"SA.11.1", "1.9"}],
    Cell[4362, 159, 100, 1, 70, "Text",
      CellTags->{"SA.11.1", "1.10"}],
    Cell[4465, 162, 860, 18, 70, "Notes",
      CellTags->{"SA.11.1", "1.11"}]},
  "1.1"->{
    Cell[1981, 63, 66, 1, 70, "Subsection",
      CellTags->{"SA.11.1", "1.1"}]},
  "1.2"->{
    Cell[2050, 66, 161, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.2"}]},
  "1.3"->{
    Cell[2214, 73, 262, 7, 70, "Text",
      CellTags->{"SA.11.1", "1.3"}]},
  "1.4"->{
    Cell[2479, 82, 336, 13, 70, "Text",
      CellTags->{"SA.11.1", "1.4"}]},
  "1.5"->{
    Cell[2818, 97, 147, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.5"}]},
  "1.6"->{
    Cell[2968, 104, 503, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.6"}]},
  "1.7"->{
    Cell[3474, 125, 171, 5, 70, "Text",
      CellTags->{"SA.11.1", "1.7"}]},
  "1.8"->{
    Cell[3648, 132, 528, 19, 70, "Notes",
      CellTags->{"SA.11.1", "1.8"}]},
  "1.9"->{
    Cell[4179, 153, 180, 4, 70, "Text",
      CellTags->{"SA.11.1", "1.9"}]},
  "1.10"->{
    Cell[4362, 159, 100, 1, 70, "Text",
      CellTags->{"SA.11.1", "1.10"}]},
  "1.11"->{
    Cell[4465, 162, 860, 18, 70, "Notes",
      CellTags->{"SA.11.1", "1.11"}]},
  "S1.1001"->{
    Cell[5350, 184, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5418, 187, 315, 11, 70, "Usage",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5736, 200, 311, 9, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[6050, 211, 203, 7, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}]},
  "MLAbort"->{
    Cell[5350, 184, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5418, 187, 315, 11, 70, "Usage",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[5736, 200, 311, 9, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}],
    Cell[6050, 211, 203, 7, 70, "Notes",
      CellTags->{"S1.1001", "MLAbort"}]},
  "S1.1002"->{
    Cell[6290, 223, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6366, 226, 306, 9, 70, "Usage",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6675, 237, 247, 9, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6925, 248, 206, 7, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}]},
  "MLActivate"->{
    Cell[6290, 223, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6366, 226, 306, 9, 70, "Usage",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6675, 237, 247, 9, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}],
    Cell[6925, 248, 206, 7, 70, "Notes",
      CellTags->{"S1.1002", "MLActivate"}]},
  "S1.1003"->{
    Cell[7168, 260, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7254, 263, 512, 16, 70, "Usage",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7769, 281, 339, 10, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8111, 293, 210, 7, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8324, 302, 179, 6, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}]},
  "MLCheckFunction"->{
    Cell[7168, 260, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7254, 263, 512, 16, 70, "Usage",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[7769, 281, 339, 10, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8111, 293, 210, 7, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}],
    Cell[8324, 302, 179, 6, 70, "Notes",
      CellTags->{"S1.1003", "MLCheckFunction"}]},
  "S1.1004"->{
    Cell[8540, 313, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[8620, 316, 287, 9, 70, "Usage",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[8910, 327, 303, 8, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[9216, 337, 208, 7, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}]},
  "MLClearError"->{
    Cell[8540, 313, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[8620, 316, 287, 9, 70, "Usage",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[8910, 327, 303, 8, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}],
    Cell[9216, 337, 208, 7, 70, "Notes",
      CellTags->{"S1.1004", "MLClearError"}]},
  "S1.1005"->{
    Cell[9461, 349, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9531, 352, 245, 9, 70, "Usage",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9779, 363, 207, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9989, 370, 182, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10174, 377, 153, 4, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10330, 383, 334, 11, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10667, 396, 172, 6, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}]},
  "MLClose"->{
    Cell[9461, 349, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9531, 352, 245, 9, 70, "Usage",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9779, 363, 207, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[9989, 370, 182, 5, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10174, 377, 153, 4, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10330, 383, 334, 11, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}],
    Cell[10667, 396, 172, 6, 70, "Notes",
      CellTags->{"S1.1005", "MLClose"}]},
  "S1.1006"->{
    Cell[10876, 407, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[10956, 410, 280, 8, 70, "Usage",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11239, 420, 213, 5, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11455, 427, 209, 7, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11667, 436, 177, 6, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}]},
  "MLCreateMark"->{
    Cell[10876, 407, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[10956, 410, 280, 8, 70, "Usage",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11239, 420, 213, 5, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11455, 427, 209, 7, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}],
    Cell[11667, 436, 177, 6, 70, "Notes",
      CellTags->{"S1.1006", "MLCreateMark"}]},
  "S1.1007"->{
    Cell[11881, 447, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[11965, 450, 277, 9, 70, "Usage",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12245, 461, 281, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12529, 470, 248, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12780, 479, 230, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[13013, 488, 210, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}]},
  "MLDeinitialize"->{
    Cell[11881, 447, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[11965, 450, 277, 9, 70, "Usage",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12245, 461, 281, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12529, 470, 248, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[12780, 479, 230, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}],
    Cell[13013, 488, 210, 7, 70, "Notes",
      CellTags->{"S1.1007", "MLDeinitialize"}]},
  "S1.1008"->{
    Cell[13260, 500, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13342, 503, 294, 9, 70, "Usage",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13639, 514, 233, 6, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13875, 522, 210, 7, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}]},
  "MLDestroyMark"->{
    Cell[13260, 500, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13342, 503, 294, 9, 70, "Usage",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13639, 514, 233, 6, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}],
    Cell[13875, 522, 210, 7, 70, "Notes",
      CellTags->{"S1.1008", "MLDestroyMark"}]},
  "S1.1009"->{
    Cell[14122, 534, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14214, 537, 466, 15, 70, "Usage",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14683, 554, 212, 7, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14898, 563, 183, 6, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}]},
  "MLDisownByteString"->{
    Cell[14122, 534, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14214, 537, 466, 15, 70, "Usage",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14683, 554, 212, 7, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}],
    Cell[14898, 563, 183, 6, 70, "Notes",
      CellTags->{"S1.1009", "MLDisownByteString"}]},
  "S1.1010"->{
    Cell[15118, 574, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[15214, 577, 654, 23, 70, "Usage",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[15871, 602, 215, 7, 70, "Notes",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}]},
  "MLDisownIntegerArray"->{
    Cell[15118, 574, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[15214, 577, 654, 23, 70, "Usage",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}],
    Cell[15871, 602, 215, 7, 70, "Notes",
      CellTags->{"S1.1010", "MLDisownIntegerArray"}]},
  "S1.1011"->{
    Cell[16123, 614, 91, 1, 70, "ObjectName",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[16217, 617, 480, 17, 70, "Usage",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[16700, 636, 214, 7, 70, "Notes",
      CellTags->{"S1.1011", "MLDisownIntegerList"}]},
  "MLDisownIntegerList"->{
    Cell[16123, 614, 91, 1, 70, "ObjectName",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[16217, 617, 480, 17, 70, "Usage",
      CellTags->{"S1.1011", "MLDisownIntegerList"}],
    Cell[16700, 636, 214, 7, 70, "Notes",
      CellTags->{"S1.1011", "MLDisownIntegerList"}]},
  "S1.1012"->{
    Cell[16951, 648, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[17041, 651, 648, 23, 70, "Usage",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[17692, 676, 212, 7, 70, "Notes",
      CellTags->{"S1.1012", "MLDisownRealArray"}]},
  "MLDisownRealArray"->{
    Cell[16951, 648, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[17041, 651, 648, 23, 70, "Usage",
      CellTags->{"S1.1012", "MLDisownRealArray"}],
    Cell[17692, 676, 212, 7, 70, "Notes",
      CellTags->{"S1.1012", "MLDisownRealArray"}]},
  "S1.1013"->{
    Cell[17941, 688, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[18029, 691, 474, 17, 70, "Usage",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[18506, 710, 211, 7, 70, "Notes",
      CellTags->{"S1.1013", "MLDisownRealList"}]},
  "MLDisownRealList"->{
    Cell[17941, 688, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[18029, 691, 474, 17, 70, "Usage",
      CellTags->{"S1.1013", "MLDisownRealList"}],
    Cell[18506, 710, 211, 7, 70, "Notes",
      CellTags->{"S1.1013", "MLDisownRealList"}]},
  "S1.1014"->{
    Cell[18754, 722, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[18838, 725, 385, 13, 70, "Usage",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[19226, 740, 209, 7, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[19438, 749, 186, 6, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}]},
  "MLDisownString"->{
    Cell[18754, 722, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[18838, 725, 385, 13, 70, "Usage",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[19226, 740, 209, 7, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}],
    Cell[19438, 749, 186, 6, 70, "Notes",
      CellTags->{"S1.1014", "MLDisownString"}]},
  "S1.1015"->{
    Cell[19661, 760, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[19745, 763, 470, 15, 70, "Usage",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[20218, 780, 339, 11, 70, "Notes",
      CellTags->{"S1.1015", "MLDisownSymbol"}]},
  "MLDisownSymbol"->{
    Cell[19661, 760, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[19745, 763, 470, 15, 70, "Usage",
      CellTags->{"S1.1015", "MLDisownSymbol"}],
    Cell[20218, 780, 339, 11, 70, "Notes",
      CellTags->{"S1.1015", "MLDisownSymbol"}]},
  "S1.1016"->{
    Cell[20594, 796, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[20692, 799, 458, 15, 70, "Usage",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[21153, 816, 215, 7, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[21371, 825, 186, 6, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}]},
  "MLDisownUnicodeString"->{
    Cell[20594, 796, 95, 1, 70, "ObjectName",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[20692, 799, 458, 15, 70, "Usage",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[21153, 816, 215, 7, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}],
    Cell[21371, 825, 186, 6, 70, "Notes",
      CellTags->{"S1.1016", "MLDisownUnicodeString"}]},
  "S1.1017"->{
    Cell[21594, 836, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[21672, 839, 290, 8, 70, "Usage",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[21965, 849, 265, 6, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[22233, 857, 337, 11, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}]},
  "MLEndPacket"->{
    Cell[21594, 836, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[21672, 839, 290, 8, 70, "Usage",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[21965, 849, 265, 6, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}],
    Cell[22233, 857, 337, 11, 70, "Notes",
      CellTags->{"S1.1017", "MLEndPacket"}]},
  "S1.1018"->{
    Cell[22607, 873, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1018", "MLError"}],
    Cell[22677, 876, 404, 13, 70, "Usage",
      CellTags->{"S1.1018", "MLError"}],
    Cell[23084, 891, 193, 6, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[23280, 899, 225, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[23508, 908, 203, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}]},
  "MLError"->{
    Cell[22607, 873, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1018", "MLError"}],
    Cell[22677, 876, 404, 13, 70, "Usage",
      CellTags->{"S1.1018", "MLError"}],
    Cell[23084, 891, 193, 6, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[23280, 899, 225, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}],
    Cell[23508, 908, 203, 7, 70, "Notes",
      CellTags->{"S1.1018", "MLError"}]},
  "S1.1019"->{
    Cell[23748, 920, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[23832, 923, 301, 9, 70, "Usage",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[24136, 934, 210, 7, 70, "Notes",
      CellTags->{"S1.1019", "MLErrorMessage"}]},
  "MLErrorMessage"->{
    Cell[23748, 920, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[23832, 923, 301, 9, 70, "Usage",
      CellTags->{"S1.1019", "MLErrorMessage"}],
    Cell[24136, 934, 210, 7, 70, "Notes",
      CellTags->{"S1.1019", "MLErrorMessage"}]},
  "S1.1020"->{
    Cell[24383, 946, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[24471, 949, 379, 11, 70, "Usage",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[24853, 962, 398, 13, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[25254, 977, 384, 12, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[25641, 991, 339, 11, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}]},
  "MLEvaluateString"->{
    Cell[24383, 946, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[24471, 949, 379, 11, 70, "Usage",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[24853, 962, 398, 13, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[25254, 977, 384, 12, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}],
    Cell[25641, 991, 339, 11, 70, "Notes",
      CellTags->{"S1.1020", "MLEvaluateString"}]},
  "S1.1021"->{
    Cell[26017, 1007, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26087, 1010, 282, 9, 70, "Usage",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26372, 1021, 280, 9, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26655, 1032, 276, 8, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26934, 1042, 204, 7, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[27141, 1051, 165, 6, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}]},
  "MLFlush"->{
    Cell[26017, 1007, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26087, 1010, 282, 9, 70, "Usage",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26372, 1021, 280, 9, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26655, 1032, 276, 8, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[26934, 1042, 204, 7, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}],
    Cell[27141, 1051, 165, 6, 70, "Notes",
      CellTags->{"S1.1021", "MLFlush"}]},
  "S1.1022"->{
    Cell[27343, 1062, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[27425, 1065, 387, 13, 70, "Usage",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[27815, 1080, 210, 7, 70, "Notes",
      CellTags->{"S1.1022", "MLGetArgCount"}]},
  "MLGetArgCount"->{
    Cell[27343, 1062, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[27425, 1065, 387, 13, 70, "Usage",
      CellTags->{"S1.1022", "MLGetArgCount"}],
    Cell[27815, 1080, 210, 7, 70, "Notes",
      CellTags->{"S1.1022", "MLGetArgCount"}]},
  "S1.1023"->{
    Cell[28062, 1092, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[28148, 1095, 787, 25, 70, "Usage",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[28938, 1122, 281, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29222, 1131, 207, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29432, 1138, 293, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29728, 1149, 215, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29946, 1156, 242, 6, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[30191, 1164, 209, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[30403, 1173, 253, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}]},
  "MLGetByteString"->{
    Cell[28062, 1092, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[28148, 1095, 787, 25, 70, "Usage",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[28938, 1122, 281, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29222, 1131, 207, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29432, 1138, 293, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29728, 1149, 215, 5, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[29946, 1156, 242, 6, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[30191, 1164, 209, 7, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}],
    Cell[30403, 1173, 253, 9, 70, "Notes",
      CellTags->{"S1.1023", "MLGetByteString"}]},
  "S1.1024"->{
    Cell[30693, 1187, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[30771, 1190, 482, 17, 70, "Usage",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31256, 1209, 203, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31462, 1218, 149, 5, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31614, 1225, 204, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31821, 1234, 172, 6, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}]},
  "MLGetDouble"->{
    Cell[30693, 1187, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[30771, 1190, 482, 17, 70, "Usage",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31256, 1209, 203, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31462, 1218, 149, 5, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31614, 1225, 204, 7, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}],
    Cell[31821, 1234, 172, 6, 70, "Notes",
      CellTags->{"S1.1024", "MLGetDouble"}]},
  "S1.1025"->{
    Cell[32030, 1245, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[32106, 1248, 478, 17, 70, "Usage",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[32587, 1267, 148, 5, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[32738, 1274, 203, 7, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}]},
  "MLGetFloat"->{
    Cell[32030, 1245, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[32106, 1248, 478, 17, 70, "Usage",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[32587, 1267, 148, 5, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}],
    Cell[32738, 1274, 203, 7, 70, "Notes",
      CellTags->{"S1.1025", "MLGetFloat"}]},
  "S1.1026"->{
    Cell[32978, 1286, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[33060, 1289, 591, 19, 70, "Usage",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[33654, 1310, 321, 8, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[33978, 1320, 186, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[34167, 1328, 648, 25, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[34818, 1355, 208, 7, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[35029, 1364, 173, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}]},
  "MLGetFunction"->{
    Cell[32978, 1286, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[33060, 1289, 591, 19, 70, "Usage",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[33654, 1310, 321, 8, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[33978, 1320, 186, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[34167, 1328, 648, 25, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[34818, 1355, 208, 7, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}],
    Cell[35029, 1364, 173, 6, 70, "Notes",
      CellTags->{"S1.1026", "MLGetFunction"}]},
  "S1.1027"->{
    Cell[35239, 1375, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[35319, 1378, 415, 15, 70, "Usage",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[35737, 1395, 223, 6, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[35963, 1403, 331, 10, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[36297, 1415, 293, 8, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[36593, 1425, 207, 7, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[36803, 1434, 254, 9, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}]},
  "MLGetInteger"->{
    Cell[35239, 1375, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[35319, 1378, 415, 15, 70, "Usage",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[35737, 1395, 223, 6, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[35963, 1403, 331, 10, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[36297, 1415, 293, 8, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[36593, 1425, 207, 7, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}],
    Cell[36803, 1434, 254, 9, 70, "Notes",
      CellTags->{"S1.1027", "MLGetInteger"}]},
  "S1.1028"->{
    Cell[37094, 1448, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[37184, 1451, 709, 25, 70, "Usage",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[37896, 1478, 271, 9, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38170, 1489, 257, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38430, 1497, 251, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38684, 1506, 211, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38898, 1514, 212, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[39113, 1523, 184, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}]},
  "MLGetIntegerArray"->{
    Cell[37094, 1448, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[37184, 1451, 709, 25, 70, "Usage",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[37896, 1478, 271, 9, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38170, 1489, 257, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38430, 1497, 251, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38684, 1506, 211, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[38898, 1514, 212, 7, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}],
    Cell[39113, 1523, 184, 6, 70, "Notes",
      CellTags->{"S1.1028", "MLGetIntegerArray"}]},
  "S1.1029"->{
    Cell[39334, 1534, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[39422, 1537, 563, 19, 70, "Usage",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[39988, 1558, 277, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40268, 1567, 208, 6, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40479, 1575, 157, 5, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40639, 1582, 211, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40853, 1591, 257, 9, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}]},
  "MLGetIntegerList"->{
    Cell[39334, 1534, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[39422, 1537, 563, 19, 70, "Usage",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[39988, 1558, 277, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40268, 1567, 208, 6, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40479, 1575, 157, 5, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40639, 1582, 211, 7, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}],
    Cell[40853, 1591, 257, 9, 70, "Notes",
      CellTags->{"S1.1029", "MLGetIntegerList"}]},
  "S1.1030"->{
    Cell[41147, 1605, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[41235, 1608, 464, 17, 70, "Usage",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[41702, 1627, 157, 5, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[41862, 1634, 209, 7, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}]},
  "MLGetLongInteger"->{
    Cell[41147, 1605, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[41235, 1608, 464, 17, 70, "Usage",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[41702, 1627, 157, 5, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}],
    Cell[41862, 1634, 209, 7, 70, "Notes",
      CellTags->{"S1.1030", "MLGetLongInteger"}]},
  "S1.1031"->{
    Cell[42108, 1646, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[42182, 1649, 272, 9, 70, "Usage",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[42457, 1660, 124, 4, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[42584, 1666, 922, 28, 70, "2ColumnTable",
      CellTags->{"MLGetNext", "S1.1031"}],
    Cell[43509, 1696, 310, 11, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[43822, 1709, 206, 7, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[44031, 1718, 173, 6, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}]},
  "MLGetNext"->{
    Cell[42108, 1646, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[42182, 1649, 272, 9, 70, "Usage",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[42457, 1660, 124, 4, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[42584, 1666, 922, 28, 70, "2ColumnTable",
      CellTags->{"MLGetNext", "S1.1031"}],
    Cell[43509, 1696, 310, 11, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[43822, 1709, 206, 7, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}],
    Cell[44031, 1718, 173, 6, 70, "Notes",
      CellTags->{"S1.1031", "MLGetNext"}]},
  "S1.1032"->{
    Cell[44241, 1729, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[44315, 1732, 433, 15, 70, "Usage",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[44751, 1749, 290, 9, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45044, 1760, 344, 10, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45391, 1772, 291, 8, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45685, 1782, 201, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45889, 1791, 204, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[46096, 1800, 310, 12, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}]},
  "MLGetReal"->{
    Cell[44241, 1729, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[44315, 1732, 433, 15, 70, "Usage",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[44751, 1749, 290, 9, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45044, 1760, 344, 10, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45391, 1772, 291, 8, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45685, 1782, 201, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[45889, 1791, 204, 7, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}],
    Cell[46096, 1800, 310, 12, 70, "Notes",
      CellTags->{"S1.1032", "MLGetReal"}]},
  "S1.1033"->{
    Cell[46443, 1817, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[46527, 1820, 728, 25, 70, "Usage",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[47258, 1847, 271, 9, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[47532, 1858, 254, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[47789, 1866, 242, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[48034, 1875, 205, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[48242, 1883, 209, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}]},
  "MLGetRealArray"->{
    Cell[46443, 1817, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[46527, 1820, 728, 25, 70, "Usage",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[47258, 1847, 271, 9, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[47532, 1858, 254, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[47789, 1866, 242, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[48034, 1875, 205, 6, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}],
    Cell[48242, 1883, 209, 7, 70, "Notes",
      CellTags->{"S1.1033", "MLGetRealArray"}]},
  "S1.1034"->{
    Cell[48488, 1895, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[48570, 1898, 581, 19, 70, "Usage",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49154, 1919, 267, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49424, 1928, 202, 6, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49629, 1936, 151, 5, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49783, 1943, 208, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}]},
  "MLGetRealList"->{
    Cell[48488, 1895, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[48570, 1898, 581, 19, 70, "Usage",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49154, 1919, 267, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49424, 1928, 202, 6, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49629, 1936, 151, 5, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}],
    Cell[49783, 1943, 208, 7, 70, "Notes",
      CellTags->{"S1.1034", "MLGetRealList"}]},
  "S1.1035"->{
    Cell[50028, 1955, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[50118, 1958, 468, 17, 70, "Usage",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[50589, 1977, 158, 5, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[50750, 1984, 210, 7, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}]},
  "MLGetShortInteger"->{
    Cell[50028, 1955, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[50118, 1958, 468, 17, 70, "Usage",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[50589, 1977, 158, 5, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}],
    Cell[50750, 1984, 210, 7, 70, "Notes",
      CellTags->{"S1.1035", "MLGetShortInteger"}]},
  "S1.1036"->{
    Cell[50997, 1996, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51075, 1999, 429, 15, 70, "Usage",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51507, 2016, 261, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51771, 2025, 196, 6, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51970, 2033, 218, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52191, 2042, 268, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52462, 2051, 228, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52693, 2060, 205, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52901, 2069, 253, 9, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}]},
  "MLGetString"->{
    Cell[50997, 1996, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51075, 1999, 429, 15, 70, "Usage",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51507, 2016, 261, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51771, 2025, 196, 6, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[51970, 2033, 218, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52191, 2042, 268, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52462, 2051, 228, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52693, 2060, 205, 7, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}],
    Cell[52901, 2069, 253, 9, 70, "Notes",
      CellTags->{"S1.1036", "MLGetString"}]},
  "S1.1037"->{
    Cell[53191, 2083, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[53269, 2086, 477, 15, 70, "Usage",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[53749, 2103, 261, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[54013, 2112, 218, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[54234, 2121, 338, 11, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}]},
  "MLGetSymbol"->{
    Cell[53191, 2083, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[53269, 2086, 477, 15, 70, "Usage",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[53749, 2103, 261, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[54013, 2112, 218, 7, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}],
    Cell[54234, 2121, 338, 11, 70, "Notes",
      CellTags->{"S1.1037", "MLGetSymbol"}]},
  "S1.1038"->{
    Cell[54609, 2137, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[54701, 2140, 557, 17, 70, "Usage",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55261, 2159, 282, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55546, 2168, 210, 6, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55759, 2176, 213, 5, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55975, 2183, 174, 4, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[56152, 2189, 212, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[56367, 2198, 253, 9, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}]},
  "MLGetUnicodeString"->{
    Cell[54609, 2137, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[54701, 2140, 557, 17, 70, "Usage",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55261, 2159, 282, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55546, 2168, 210, 6, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55759, 2176, 213, 5, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[55975, 2183, 174, 4, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[56152, 2189, 212, 7, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}],
    Cell[56367, 2198, 253, 9, 70, "Notes",
      CellTags->{"S1.1038", "MLGetUnicodeString"}]},
  "S1.1039"->{
    Cell[56657, 2212, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[56737, 2215, 220, 7, 70, "Usage",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[56960, 2224, 277, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[57240, 2233, 309, 9, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[57552, 2244, 208, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}]},
  "MLInitialize"->{
    Cell[56657, 2212, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[56737, 2215, 220, 7, 70, "Usage",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[56960, 2224, 277, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[57240, 2233, 309, 9, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}],
    Cell[57552, 2244, 208, 7, 70, "Notes",
      CellTags->{"S1.1039", "MLInitialize"}]},
  "S1.1040"->{
    Cell[57797, 2256, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[57881, 2259, 324, 11, 70, "Usage",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58208, 2272, 247, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58458, 2281, 219, 5, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58680, 2288, 210, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58893, 2297, 177, 6, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}]},
  "MLLoopbackOpen"->{
    Cell[57797, 2256, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[57881, 2259, 324, 11, 70, "Usage",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58208, 2272, 247, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58458, 2281, 219, 5, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58680, 2288, 210, 7, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}],
    Cell[58893, 2297, 177, 6, 70, "Notes",
      CellTags->{"S1.1040", "MLLoopbackOpen"}]},
  "S1.1041"->{
    Cell[59107, 2308, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[59175, 2311, 384, 13, 70, "Usage",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[59562, 2326, 239, 9, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[59804, 2337, 387, 13, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[60194, 2352, 185, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[60382, 2361, 200, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}]},
  "MLMain"->{
    Cell[59107, 2308, 65, 1, 70, "ObjectName",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[59175, 2311, 384, 13, 70, "Usage",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[59562, 2326, 239, 9, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[59804, 2337, 387, 13, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[60194, 2352, 185, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}],
    Cell[60382, 2361, 200, 7, 70, "Notes",
      CellTags->{"S1.1041", "MLMain"}]},
  "S1.1042"->{
    Cell[60619, 2373, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[60697, 2376, 270, 9, 70, "Usage",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[60970, 2387, 236, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[61209, 2395, 192, 5, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[61404, 2402, 339, 11, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[61746, 2415, 174, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}]},
  "MLNewPacket"->{
    Cell[60619, 2373, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[60697, 2376, 270, 9, 70, "Usage",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[60970, 2387, 236, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[61209, 2395, 192, 5, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[61404, 2402, 339, 11, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}],
    Cell[61746, 2415, 174, 6, 70, "Notes",
      CellTags->{"S1.1042", "MLNewPacket"}]},
  "S1.1043"->{
    Cell[61957, 2426, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[62037, 2429, 301, 9, 70, "Usage",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[62341, 2440, 209, 7, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[62553, 2449, 174, 6, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}]},
  "MLNextPacket"->{
    Cell[61957, 2426, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[62037, 2429, 301, 9, 70, "Usage",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[62341, 2440, 209, 7, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}],
    Cell[62553, 2449, 174, 6, 70, "Notes",
      CellTags->{"S1.1043", "MLNextPacket"}]},
  "S1.1044"->{
    Cell[62764, 2460, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[62840, 2463, 488, 17, 70, "Usage",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[63331, 2482, 200, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[63534, 2491, 291, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[63828, 2502, 1532, 46, 70, "2ColumnTable",
      CellTags->{"MLOpenArgv", "S1.1044"}],
    Cell[65363, 2550, 182, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[65548, 2557, 185, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[65736, 2564, 293, 11, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[66032, 2577, 428, 17, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[66463, 2596, 275, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[66741, 2607, 318, 10, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67062, 2619, 206, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67271, 2628, 241, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}]},
  "MLOpenArgv"->{
    Cell[62764, 2460, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[62840, 2463, 488, 17, 70, "Usage",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[63331, 2482, 200, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[63534, 2491, 291, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[63828, 2502, 1532, 46, 70, "2ColumnTable",
      CellTags->{"MLOpenArgv", "S1.1044"}],
    Cell[65363, 2550, 182, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[65548, 2557, 185, 5, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[65736, 2564, 293, 11, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[66032, 2577, 428, 17, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[66463, 2596, 275, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[66741, 2607, 318, 10, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67062, 2619, 206, 7, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}],
    Cell[67271, 2628, 241, 9, 70, "Notes",
      CellTags->{"S1.1044", "MLOpenArgv"}]},
  "S1.1045"->{
    Cell[67549, 2642, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[67629, 2645, 411, 13, 70, "Usage",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68043, 2660, 204, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68250, 2669, 264, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68517, 2680, 138, 4, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68658, 2686, 278, 6, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68939, 2694, 208, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[69150, 2703, 241, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}]},
  "MLOpenString"->{
    Cell[67549, 2642, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[67629, 2645, 411, 13, 70, "Usage",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68043, 2660, 204, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68250, 2669, 264, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68517, 2680, 138, 4, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68658, 2686, 278, 6, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[68939, 2694, 208, 7, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}],
    Cell[69150, 2703, 241, 9, 70, "Notes",
      CellTags->{"S1.1045", "MLOpenString"}]},
  "S1.1046"->{
    Cell[69428, 2717, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1046", "MLPutArgCount"}],
    Cell[69510, 2720, 355, 11, 70, "Usage",
      CellTags->{"S1.1046", "MLPutArgCount"}]},
  "MLPutArgCount"->{
    Cell[69428, 2717, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1046", "MLPutArgCount"}],
    Cell[69510, 2720, 355, 11, 70, "Usage",
      CellTags->{"S1.1046", "MLPutArgCount"}]},
  "S1.1047"->{
    Cell[69902, 2736, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[69988, 2739, 529, 19, 70, "Usage",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[70520, 2760, 274, 8, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[70797, 2770, 232, 6, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71032, 2778, 194, 5, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71229, 2785, 169, 4, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71401, 2791, 209, 7, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71613, 2800, 251, 9, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}]},
  "MLPutByteString"->{
    Cell[69902, 2736, 83, 1, 70, "ObjectName",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[69988, 2739, 529, 19, 70, "Usage",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[70520, 2760, 274, 8, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[70797, 2770, 232, 6, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71032, 2778, 194, 5, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71229, 2785, 169, 4, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71401, 2791, 209, 7, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}],
    Cell[71613, 2800, 251, 9, 70, "Notes",
      CellTags->{"S1.1047", "MLPutByteString"}]},
  "S1.1048"->{
    Cell[71901, 2814, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[71979, 2817, 464, 17, 70, "Usage",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[72446, 2836, 149, 5, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[72598, 2843, 204, 7, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}]},
  "MLPutDouble"->{
    Cell[71901, 2814, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[71979, 2817, 464, 17, 70, "Usage",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[72446, 2836, 149, 5, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}],
    Cell[72598, 2843, 204, 7, 70, "Notes",
      CellTags->{"S1.1048", "MLPutDouble"}]},
  "S1.1049"->{
    Cell[72839, 2855, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[72915, 2858, 496, 17, 70, "Usage",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[73414, 2877, 381, 11, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[73798, 2890, 148, 5, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[73949, 2897, 203, 7, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}]},
  "MLPutFloat"->{
    Cell[72839, 2855, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[72915, 2858, 496, 17, 70, "Usage",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[73414, 2877, 381, 11, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[73798, 2890, 148, 5, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}],
    Cell[73949, 2897, 203, 7, 70, "Notes",
      CellTags->{"S1.1049", "MLPutFloat"}]},
  "S1.1050"->{
    Cell[74189, 2909, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[74271, 2912, 538, 19, 70, "Usage",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[74812, 2933, 265, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[75080, 2942, 207, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[75290, 2951, 175, 6, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}]},
  "MLPutFunction"->{
    Cell[74189, 2909, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[74271, 2912, 538, 19, 70, "Usage",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[74812, 2933, 265, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[75080, 2942, 207, 7, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}],
    Cell[75290, 2951, 175, 6, 70, "Notes",
      CellTags->{"S1.1050", "MLPutFunction"}]},
  "S1.1051"->{
    Cell[75502, 2962, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[75582, 2965, 396, 15, 70, "Usage",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[75981, 2982, 295, 8, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[76279, 2992, 338, 11, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[76620, 3005, 398, 15, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}]},
  "MLPutInteger"->{
    Cell[75502, 2962, 77, 1, 70, "ObjectName",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[75582, 2965, 396, 15, 70, "Usage",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[75981, 2982, 295, 8, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[76279, 2992, 338, 11, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}],
    Cell[76620, 3005, 398, 15, 70, "Notes",
      CellTags->{"S1.1051", "MLPutInteger"}]},
  "S1.1052"->{
    Cell[77055, 3025, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[77145, 3028, 653, 23, 70, "Usage",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[77801, 3053, 287, 9, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78091, 3064, 271, 9, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78365, 3075, 215, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78583, 3084, 211, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78797, 3093, 184, 6, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}]},
  "MLPutIntegerArray"->{
    Cell[77055, 3025, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[77145, 3028, 653, 23, 70, "Usage",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[77801, 3053, 287, 9, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78091, 3064, 271, 9, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78365, 3075, 215, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78583, 3084, 211, 7, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}],
    Cell[78797, 3093, 184, 6, 70, "Notes",
      CellTags->{"S1.1052", "MLPutIntegerArray"}]},
  "S1.1053"->{
    Cell[79018, 3104, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[79106, 3107, 517, 19, 70, "Usage",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[79626, 3128, 210, 7, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[79839, 3137, 257, 9, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}]},
  "MLPutIntegerList"->{
    Cell[79018, 3104, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[79106, 3107, 517, 19, 70, "Usage",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[79626, 3128, 210, 7, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}],
    Cell[79839, 3137, 257, 9, 70, "Notes",
      CellTags->{"S1.1053", "MLPutIntegerList"}]},
  "S1.1054"->{
    Cell[80133, 3151, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[80221, 3154, 410, 15, 70, "Usage",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[80634, 3171, 157, 5, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[80794, 3178, 209, 7, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}]},
  "MLPutLongInteger"->{
    Cell[80133, 3151, 85, 1, 70, "ObjectName",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[80221, 3154, 410, 15, 70, "Usage",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[80634, 3171, 157, 5, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}],
    Cell[80794, 3178, 209, 7, 70, "Notes",
      CellTags->{"S1.1054", "MLPutLongInteger"}]},
  "S1.1055"->{
    Cell[81040, 3190, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81114, 3193, 329, 11, 70, "Usage",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81446, 3206, 189, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81638, 3214, 206, 7, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81847, 3223, 173, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}]},
  "MLPutNext"->{
    Cell[81040, 3190, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81114, 3193, 329, 11, 70, "Usage",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81446, 3206, 189, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81638, 3214, 206, 7, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}],
    Cell[81847, 3223, 173, 6, 70, "Notes",
      CellTags->{"S1.1055", "MLPutNext"}]},
  "S1.1056"->{
    Cell[82057, 3234, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[82131, 3237, 415, 15, 70, "Usage",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[82549, 3254, 296, 8, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[82848, 3264, 201, 7, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[83052, 3273, 335, 11, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[83390, 3286, 310, 12, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}]},
  "MLPutReal"->{
    Cell[82057, 3234, 71, 1, 70, "ObjectName",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[82131, 3237, 415, 15, 70, "Usage",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[82549, 3254, 296, 8, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[82848, 3264, 201, 7, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[83052, 3273, 335, 11, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}],
    Cell[83390, 3286, 310, 12, 70, "Notes",
      CellTags->{"S1.1056", "MLPutReal"}]},
  "S1.1057"->{
    Cell[83737, 3303, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[83821, 3306, 672, 23, 70, "Usage",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[84496, 3331, 287, 9, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[84786, 3342, 268, 9, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[85057, 3353, 212, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[85272, 3362, 208, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[85483, 3371, 178, 6, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}]},
  "MLPutRealArray"->{
    Cell[83737, 3303, 81, 1, 70, "ObjectName",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[83821, 3306, 672, 23, 70, "Usage",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[84496, 3331, 287, 9, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[84786, 3342, 268, 9, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[85057, 3353, 212, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[85272, 3362, 208, 7, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}],
    Cell[85483, 3371, 178, 6, 70, "Notes",
      CellTags->{"S1.1057", "MLPutRealArray"}]},
  "S1.1058"->{
    Cell[85698, 3382, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[85780, 3385, 536, 19, 70, "Usage",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[86319, 3406, 207, 7, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[86529, 3415, 178, 6, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}]},
  "MLPutRealList"->{
    Cell[85698, 3382, 79, 1, 70, "ObjectName",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[85780, 3385, 536, 19, 70, "Usage",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[86319, 3406, 207, 7, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}],
    Cell[86529, 3415, 178, 6, 70, "Notes",
      CellTags->{"S1.1058", "MLPutRealList"}]},
  "S1.1059"->{
    Cell[86744, 3426, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[86834, 3429, 534, 19, 70, "Usage",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[87371, 3450, 392, 11, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[87766, 3463, 158, 5, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[87927, 3470, 210, 7, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}]},
  "MLPutShortInteger"->{
    Cell[86744, 3426, 87, 1, 70, "ObjectName",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[86834, 3429, 534, 19, 70, "Usage",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[87371, 3450, 392, 11, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[87766, 3463, 158, 5, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}],
    Cell[87927, 3470, 210, 7, 70, "Notes",
      CellTags->{"S1.1059", "MLPutShortInteger"}]},
  "S1.1060"->{
    Cell[88174, 3482, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[88252, 3485, 373, 13, 70, "Usage",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[88628, 3500, 219, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[88850, 3508, 175, 4, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[89028, 3514, 212, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[89243, 3522, 205, 7, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[89451, 3531, 322, 12, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}]},
  "MLPutString"->{
    Cell[88174, 3482, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[88252, 3485, 373, 13, 70, "Usage",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[88628, 3500, 219, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[88850, 3508, 175, 4, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[89028, 3514, 212, 6, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[89243, 3522, 205, 7, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}],
    Cell[89451, 3531, 322, 12, 70, "Notes",
      CellTags->{"S1.1060", "MLPutString"}]},
  "S1.1061"->{
    Cell[89810, 3548, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[89888, 3551, 437, 15, 70, "Usage",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[90328, 3568, 184, 6, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[90515, 3576, 337, 11, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[90855, 3589, 173, 6, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}]},
  "MLPutSymbol"->{
    Cell[89810, 3548, 75, 1, 70, "ObjectName",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[89888, 3551, 437, 15, 70, "Usage",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[90328, 3568, 184, 6, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[90515, 3576, 337, 11, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}],
    Cell[90855, 3589, 173, 6, 70, "Notes",
      CellTags->{"S1.1061", "MLPutSymbol"}]},
  "S1.1062"->{
    Cell[91065, 3600, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91157, 3603, 506, 17, 70, "Usage",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91666, 3622, 136, 4, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91805, 3628, 181, 4, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91989, 3634, 212, 7, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[92204, 3643, 253, 9, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}]},
  "MLPutUnicodeString"->{
    Cell[91065, 3600, 89, 1, 70, "ObjectName",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91157, 3603, 506, 17, 70, "Usage",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91666, 3622, 136, 4, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91805, 3628, 181, 4, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[91989, 3634, 212, 7, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}],
    Cell[92204, 3643, 253, 9, 70, "Notes",
      CellTags->{"S1.1062", "MLPutUnicodeString"}]},
  "S1.1063"->{
    Cell[92494, 3657, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[92564, 3660, 270, 9, 70, "Usage",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[92837, 3671, 196, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93036, 3680, 225, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93264, 3689, 180, 5, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93447, 3696, 208, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93658, 3705, 204, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}]},
  "MLReady"->{
    Cell[92494, 3657, 67, 1, 70, "ObjectName",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[92564, 3660, 270, 9, 70, "Usage",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[92837, 3671, 196, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93036, 3680, 225, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93264, 3689, 180, 5, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93447, 3696, 208, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}],
    Cell[93658, 3705, 204, 7, 70, "Notes",
      CellTags->{"S1.1063", "MLReady"}]},
  "S1.1064"->{
    Cell[93899, 3717, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[93975, 3720, 406, 13, 70, "Usage",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[94384, 3735, 207, 7, 70, "Notes",
      CellTags->{"S1.1064", "MLSeekMark"}]},
  "MLSeekMark"->{
    Cell[93899, 3717, 73, 1, 70, "ObjectName",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[93975, 3720, 406, 13, 70, "Usage",
      CellTags->{"S1.1064", "MLSeekMark"}],
    Cell[94384, 3735, 207, 7, 70, "Notes",
      CellTags->{"S1.1064", "MLSeekMark"}]},
  "S1.1065"->{
    Cell[94628, 3747, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[94724, 3750, 360, 11, 70, "Usage",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[95087, 3763, 194, 7, 70, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[95284, 3772, 214, 7, 70, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[95501, 3781, 216, 7, 70, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}]},
  "MLTransferExpression"->{
    Cell[94628, 3747, 93, 1, 70, "ObjectName",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[94724, 3750, 360, 11, 70, "Usage",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[95087, 3763, 194, 7, 70, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[95284, 3772, 214, 7, 70, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}],
    Cell[95501, 3781, 216, 7, 70, "Notes",
      CellTags->{"S1.1065", "MLTransferExpression"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SA.11.0", 96373, 3809},
  {"0.1", 96464, 3812},
  {"SA.11.1", 96559, 3815},
  {"1.1", 97427, 3838},
  {"1.2", 97520, 3841},
  {"1.3", 97608, 3844},
  {"1.4", 97696, 3847},
  {"1.5", 97785, 3850},
  {"1.6", 97873, 3853},
  {"1.7", 97964, 3856},
  {"1.8", 98053, 3859},
  {"1.9", 98144, 3862},
  {"1.10", 98234, 3865},
  {"1.11", 98325, 3868},
  {"S1.1001", 98421, 3871},
  {"MLAbort", 98770, 3880},
  {"S1.1002", 99119, 3889},
  {"MLActivate", 99482, 3898},
  {"S1.1003", 99842, 3907},
  {"MLCheckFunction", 100322, 3918},
  {"S1.1004", 100794, 3929},
  {"MLClearError", 101167, 3938},
  {"S1.1005", 101535, 3947},
  {"MLClose", 102133, 3962},
  {"S1.1006", 102731, 3977},
  {"MLCreateMark", 103196, 3988},
  {"S1.1007", 103656, 3999},
  {"MLDeinitialize", 104223, 4012},
  {"S1.1008", 104783, 4025},
  {"MLDestroyMark", 105165, 4034},
  {"S1.1009", 105541, 4043},
  {"MLDisownByteString", 105949, 4052},
  {"S1.1010", 106346, 4061},
  {"MLDisownIntegerArray", 106668, 4068},
  {"S1.1011", 106977, 4075},
  {"MLDisownIntegerList", 107295, 4082},
  {"S1.1012", 107601, 4089},
  {"MLDisownRealArray", 107911, 4096},
  {"S1.1013", 108211, 4103},
  {"MLDisownRealList", 108517, 4110},
  {"S1.1014", 108814, 4117},
  {"MLDisownString", 109202, 4126},
  {"S1.1015", 109583, 4135},
  {"MLDisownSymbol", 109882, 4142},
  {"S1.1016", 110174, 4149},
  {"MLDisownUnicodeString", 110597, 4158},
  {"S1.1017", 111006, 4167},
  {"MLEndPacket", 111379, 4176},
  {"S1.1018", 111748, 4185},
  {"MLError", 112184, 4196},
  {"S1.1019", 112620, 4207},
  {"MLErrorMessage", 112917, 4214},
  {"S1.1020", 113207, 4221},
  {"MLEvaluateString", 113700, 4232},
  {"S1.1021", 114184, 4243},
  {"MLFlush", 114708, 4256},
  {"S1.1022", 115232, 4269},
  {"MLGetArgCount", 115529, 4276},
  {"S1.1023", 115820, 4283},
  {"MLGetByteString", 116677, 4302},
  {"S1.1024", 117526, 4321},
  {"MLGetDouble", 118079, 4334},
  {"S1.1025", 118628, 4347},
  {"MLGetFloat", 119000, 4356},
  {"S1.1026", 119369, 4365},
  {"MLGetFunction", 120027, 4380},
  {"S1.1027", 120679, 4395},
  {"MLGetInteger", 121329, 4410},
  {"S1.1028", 121974, 4425},
  {"MLGetIntegerArray", 122757, 4442},
  {"S1.1029", 123530, 4459},
  {"MLGetIntegerList", 124211, 4474},
  {"S1.1030", 124883, 4489},
  {"MLGetLongInteger", 125285, 4498},
  {"S1.1031", 125678, 4507},
  {"MLGetNext", 126311, 4522},
  {"S1.1032", 126942, 4537},
  {"MLGetReal", 127655, 4554},
  {"S1.1033", 128366, 4571},
  {"MLGetRealArray", 129031, 4586},
  {"S1.1034", 129689, 4601},
  {"MLGetRealList", 130256, 4614},
  {"S1.1035", 130817, 4627},
  {"MLGetShortInteger", 131224, 4636},
  {"S1.1036", 131621, 4645},
  {"MLGetString", 132438, 4664},
  {"S1.1037", 133251, 4683},
  {"MLGetSymbol", 133717, 4694},
  {"S1.1038", 134179, 4705},
  {"MLGetUnicodeString", 134971, 4722},
  {"S1.1039", 135752, 4739},
  {"MLInitialize", 136222, 4750},
  {"S1.1040", 136687, 4761},
  {"MLLoopbackOpen", 137261, 4774},
  {"S1.1041", 137828, 4787},
  {"MLMain", 138347, 4800},
  {"S1.1042", 138867, 4813},
  {"MLNewPacket", 139420, 4826},
  {"S1.1043", 139969, 4839},
  {"MLNextPacket", 140350, 4848},
  {"S1.1044", 140726, 4857},
  {"MLOpenArgv", 141893, 4884},
  {"S1.1045", 143057, 4911},
  {"MLOpenString", 143795, 4928},
  {"S1.1046", 144528, 4945},
  {"MLPutArgCount", 144735, 4950},
  {"S1.1047", 144936, 4955},
  {"MLPutByteString", 145701, 4972},
  {"S1.1048", 146458, 4989},
  {"MLPutDouble", 146835, 4998},
  {"S1.1049", 147208, 5007},
  {"MLPutFloat", 147668, 5018},
  {"S1.1050", 148125, 5029},
  {"MLPutFunction", 148602, 5040},
  {"S1.1051", 149073, 5051},
  {"MLPutInteger", 149546, 5062},
  {"S1.1052", 150014, 5073},
  {"MLPutIntegerArray", 150703, 5088},
  {"S1.1053", 151382, 5103},
  {"MLPutIntegerList", 151784, 5112},
  {"S1.1054", 152177, 5121},
  {"MLPutLongInteger", 152579, 5130},
  {"S1.1055", 152972, 5139},
  {"MLPutNext", 153425, 5150},
  {"S1.1056", 153876, 5161},
  {"MLPutReal", 154417, 5174},
  {"S1.1057", 154956, 5187},
  {"MLPutRealArray", 155621, 5202},
  {"S1.1058", 156279, 5217},
  {"MLPutRealList", 156666, 5226},
  {"S1.1059", 157047, 5235},
  {"MLPutShortInteger", 157549, 5246},
  {"S1.1060", 158041, 5257},
  {"MLPutString", 158683, 5272},
  {"S1.1061", 159321, 5287},
  {"MLPutSymbol", 159787, 5298},
  {"S1.1062", 160249, 5309},
  {"MLPutUnicodeString", 160851, 5322},
  {"S1.1063", 161442, 5335},
  {"MLReady", 162050, 5350},
  {"S1.1064", 162658, 5365},
  {"MLSeekMark", 162943, 5372},
  {"S1.1065", 163225, 5379},
  {"MLTransferExpression", 163744, 5390}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 180, 6, 70, "Section",
  CellTags->{"SA.11.0", "0.1"}],

Cell[CellGroupData[{
Cell[1981, 63, 66, 1, 70, "Subsection",
  CellTags->{"SA.11.1", "1.1"}],
Cell[2050, 66, 161, 5, 70, "Text",
  CellTags->{"SA.11.1", "1.2"}],
Cell[2214, 73, 262, 7, 70, "Text",
  CellTags->{"SA.11.1", "1.3"}],
Cell[2479, 82, 336, 13, 70, "Text",
  CellTags->{"SA.11.1", "1.4"}],
Cell[2818, 97, 147, 5, 70, "Text",
  CellTags->{"SA.11.1", "1.5"}],
Cell[2968, 104, 503, 19, 70, "Notes",
  CellTags->{"SA.11.1", "1.6"}],
Cell[3474, 125, 171, 5, 70, "Text",
  CellTags->{"SA.11.1", "1.7"}],
Cell[3648, 132, 528, 19, 70, "Notes",
  CellTags->{"SA.11.1", "1.8"}],
Cell[4179, 153, 180, 4, 70, "Text",
  CellTags->{"SA.11.1", "1.9"}],
Cell[4362, 159, 100, 1, 70, "Text",
  CellTags->{"SA.11.1", "1.10"}],
Cell[4465, 162, 860, 18, 70, "Notes",
  CellTags->{"SA.11.1", "1.11"}],

Cell[CellGroupData[{
Cell[5350, 184, 65, 1, 70, "ObjectName",
  CellTags->{"S1.1001", "MLAbort"}],
Cell[5418, 187, 315, 11, 70, "Usage",
  CellTags->{"S1.1001", "MLAbort"}],
Cell[5736, 200, 311, 9, 70, "Notes",
  CellTags->{"S1.1001", "MLAbort"}],
Cell[6050, 211, 203, 7, 70, "Notes",
  CellTags->{"S1.1001", "MLAbort"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6290, 223, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1002", "MLActivate"}],
Cell[6366, 226, 306, 9, 70, "Usage",
  CellTags->{"S1.1002", "MLActivate"}],
Cell[6675, 237, 247, 9, 70, "Notes",
  CellTags->{"S1.1002", "MLActivate"}],
Cell[6925, 248, 206, 7, 70, "Notes",
  CellTags->{"S1.1002", "MLActivate"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7168, 260, 83, 1, 70, "ObjectName",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[7254, 263, 512, 16, 70, "Usage",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[7769, 281, 339, 10, 70, "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[8111, 293, 210, 7, 70, "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}],
Cell[8324, 302, 179, 6, 70, "Notes",
  CellTags->{"S1.1003", "MLCheckFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8540, 313, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1004", "MLClearError"}],
Cell[8620, 316, 287, 9, 70, "Usage",
  CellTags->{"S1.1004", "MLClearError"}],
Cell[8910, 327, 303, 8, 70, "Notes",
  CellTags->{"S1.1004", "MLClearError"}],
Cell[9216, 337, 208, 7, 70, "Notes",
  CellTags->{"S1.1004", "MLClearError"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9461, 349, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1005", "MLClose"}],
Cell[9531, 352, 245, 9, 70, "Usage",
  CellTags->{"S1.1005", "MLClose"}],
Cell[9779, 363, 207, 5, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[9989, 370, 182, 5, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10174, 377, 153, 4, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10330, 383, 334, 11, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}],
Cell[10667, 396, 172, 6, 70, "Notes",
  CellTags->{"S1.1005", "MLClose"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10876, 407, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[10956, 410, 280, 8, 70, "Usage",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11239, 420, 213, 5, 70, "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11455, 427, 209, 7, 70, "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}],
Cell[11667, 436, 177, 6, 70, "Notes",
  CellTags->{"S1.1006", "MLCreateMark"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11881, 447, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[11965, 450, 277, 9, 70, "Usage",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[12245, 461, 281, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[12529, 470, 248, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[12780, 479, 230, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}],
Cell[13013, 488, 210, 7, 70, "Notes",
  CellTags->{"S1.1007", "MLDeinitialize"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13260, 500, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1008", "MLDestroyMark"}],
Cell[13342, 503, 294, 9, 70, "Usage",
  CellTags->{"S1.1008", "MLDestroyMark"}],
Cell[13639, 514, 233, 6, 70, "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}],
Cell[13875, 522, 210, 7, 70, "Notes",
  CellTags->{"S1.1008", "MLDestroyMark"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14122, 534, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1009", "MLDisownByteString"}],
Cell[14214, 537, 466, 15, 70, "Usage",
  CellTags->{"S1.1009", "MLDisownByteString"}],
Cell[14683, 554, 212, 7, 70, "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}],
Cell[14898, 563, 183, 6, 70, "Notes",
  CellTags->{"S1.1009", "MLDisownByteString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15118, 574, 93, 1, 70, "ObjectName",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],
Cell[15214, 577, 654, 23, 70, "Usage",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}],
Cell[15871, 602, 215, 7, 70, "Notes",
  CellTags->{"S1.1010", "MLDisownIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16123, 614, 91, 1, 70, "ObjectName",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],
Cell[16217, 617, 480, 17, 70, "Usage",
  CellTags->{"S1.1011", "MLDisownIntegerList"}],
Cell[16700, 636, 214, 7, 70, "Notes",
  CellTags->{"S1.1011", "MLDisownIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16951, 648, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1012", "MLDisownRealArray"}],
Cell[17041, 651, 648, 23, 70, "Usage",
  CellTags->{"S1.1012", "MLDisownRealArray"}],
Cell[17692, 676, 212, 7, 70, "Notes",
  CellTags->{"S1.1012", "MLDisownRealArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17941, 688, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1013", "MLDisownRealList"}],
Cell[18029, 691, 474, 17, 70, "Usage",
  CellTags->{"S1.1013", "MLDisownRealList"}],
Cell[18506, 710, 211, 7, 70, "Notes",
  CellTags->{"S1.1013", "MLDisownRealList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18754, 722, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1014", "MLDisownString"}],
Cell[18838, 725, 385, 13, 70, "Usage",
  CellTags->{"S1.1014", "MLDisownString"}],
Cell[19226, 740, 209, 7, 70, "Notes",
  CellTags->{"S1.1014", "MLDisownString"}],
Cell[19438, 749, 186, 6, 70, "Notes",
  CellTags->{"S1.1014", "MLDisownString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19661, 760, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1015", "MLDisownSymbol"}],
Cell[19745, 763, 470, 15, 70, "Usage",
  CellTags->{"S1.1015", "MLDisownSymbol"}],
Cell[20218, 780, 339, 11, 70, "Notes",
  CellTags->{"S1.1015", "MLDisownSymbol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20594, 796, 95, 1, 70, "ObjectName",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],
Cell[20692, 799, 458, 15, 70, "Usage",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],
Cell[21153, 816, 215, 7, 70, "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}],
Cell[21371, 825, 186, 6, 70, "Notes",
  CellTags->{"S1.1016", "MLDisownUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21594, 836, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1017", "MLEndPacket"}],
Cell[21672, 839, 290, 8, 70, "Usage",
  CellTags->{"S1.1017", "MLEndPacket"}],
Cell[21965, 849, 265, 6, 70, "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}],
Cell[22233, 857, 337, 11, 70, "Notes",
  CellTags->{"S1.1017", "MLEndPacket"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22607, 873, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1018", "MLError"}],
Cell[22677, 876, 404, 13, 70, "Usage",
  CellTags->{"S1.1018", "MLError"}],
Cell[23084, 891, 193, 6, 70, "Notes",
  CellTags->{"S1.1018", "MLError"}],
Cell[23280, 899, 225, 7, 70, "Notes",
  CellTags->{"S1.1018", "MLError"}],
Cell[23508, 908, 203, 7, 70, "Notes",
  CellTags->{"S1.1018", "MLError"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[23748, 920, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1019", "MLErrorMessage"}],
Cell[23832, 923, 301, 9, 70, "Usage",
  CellTags->{"S1.1019", "MLErrorMessage"}],
Cell[24136, 934, 210, 7, 70, "Notes",
  CellTags->{"S1.1019", "MLErrorMessage"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24383, 946, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[24471, 949, 379, 11, 70, "Usage",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[24853, 962, 398, 13, 70, "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[25254, 977, 384, 12, 70, "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}],
Cell[25641, 991, 339, 11, 70, "Notes",
  CellTags->{"S1.1020", "MLEvaluateString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26017, 1007, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[26087, 1010, 282, 9, 70, "Usage",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[26372, 1021, 280, 9, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[26655, 1032, 276, 8, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[26934, 1042, 204, 7, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}],
Cell[27141, 1051, 165, 6, 70, "Notes",
  CellTags->{"S1.1021", "MLFlush"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27343, 1062, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1022", "MLGetArgCount"}],
Cell[27425, 1065, 387, 13, 70, "Usage",
  CellTags->{"S1.1022", "MLGetArgCount"}],
Cell[27815, 1080, 210, 7, 70, "Notes",
  CellTags->{"S1.1022", "MLGetArgCount"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[28062, 1092, 83, 1, 70, "ObjectName",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[28148, 1095, 787, 25, 70, "Usage",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[28938, 1122, 281, 7, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[29222, 1131, 207, 5, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[29432, 1138, 293, 9, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[29728, 1149, 215, 5, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[29946, 1156, 242, 6, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[30191, 1164, 209, 7, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}],
Cell[30403, 1173, 253, 9, 70, "Notes",
  CellTags->{"S1.1023", "MLGetByteString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[30693, 1187, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[30771, 1190, 482, 17, 70, "Usage",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[31256, 1209, 203, 7, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[31462, 1218, 149, 5, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[31614, 1225, 204, 7, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}],
Cell[31821, 1234, 172, 6, 70, "Notes",
  CellTags->{"S1.1024", "MLGetDouble"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[32030, 1245, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1025", "MLGetFloat"}],
Cell[32106, 1248, 478, 17, 70, "Usage",
  CellTags->{"S1.1025", "MLGetFloat"}],
Cell[32587, 1267, 148, 5, 70, "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}],
Cell[32738, 1274, 203, 7, 70, "Notes",
  CellTags->{"S1.1025", "MLGetFloat"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[32978, 1286, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[33060, 1289, 591, 19, 70, "Usage",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[33654, 1310, 321, 8, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[33978, 1320, 186, 6, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[34167, 1328, 648, 25, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[34818, 1355, 208, 7, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}],
Cell[35029, 1364, 173, 6, 70, "Notes",
  CellTags->{"S1.1026", "MLGetFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35239, 1375, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[35319, 1378, 415, 15, 70, "Usage",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[35737, 1395, 223, 6, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[35963, 1403, 331, 10, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[36297, 1415, 293, 8, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[36593, 1425, 207, 7, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}],
Cell[36803, 1434, 254, 9, 70, "Notes",
  CellTags->{"S1.1027", "MLGetInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[37094, 1448, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[37184, 1451, 709, 25, 70, "Usage",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[37896, 1478, 271, 9, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[38170, 1489, 257, 6, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[38430, 1497, 251, 7, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[38684, 1506, 211, 6, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[38898, 1514, 212, 7, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}],
Cell[39113, 1523, 184, 6, 70, "Notes",
  CellTags->{"S1.1028", "MLGetIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39334, 1534, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[39422, 1537, 563, 19, 70, "Usage",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[39988, 1558, 277, 7, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[40268, 1567, 208, 6, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[40479, 1575, 157, 5, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[40639, 1582, 211, 7, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}],
Cell[40853, 1591, 257, 9, 70, "Notes",
  CellTags->{"S1.1029", "MLGetIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41147, 1605, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1030", "MLGetLongInteger"}],
Cell[41235, 1608, 464, 17, 70, "Usage",
  CellTags->{"S1.1030", "MLGetLongInteger"}],
Cell[41702, 1627, 157, 5, 70, "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}],
Cell[41862, 1634, 209, 7, 70, "Notes",
  CellTags->{"S1.1030", "MLGetLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42108, 1646, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[42182, 1649, 272, 9, 70, "Usage",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[42457, 1660, 124, 4, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[42584, 1666, 922, 28, 70, "2ColumnTable",
  CellTags->{"MLGetNext", "S1.1031"}],
Cell[43509, 1696, 310, 11, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[43822, 1709, 206, 7, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}],
Cell[44031, 1718, 173, 6, 70, "Notes",
  CellTags->{"S1.1031", "MLGetNext"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[44241, 1729, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[44315, 1732, 433, 15, 70, "Usage",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[44751, 1749, 290, 9, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[45044, 1760, 344, 10, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[45391, 1772, 291, 8, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[45685, 1782, 201, 7, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[45889, 1791, 204, 7, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}],
Cell[46096, 1800, 310, 12, 70, "Notes",
  CellTags->{"S1.1032", "MLGetReal"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[46443, 1817, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[46527, 1820, 728, 25, 70, "Usage",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[47258, 1847, 271, 9, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[47532, 1858, 254, 6, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[47789, 1866, 242, 7, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[48034, 1875, 205, 6, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}],
Cell[48242, 1883, 209, 7, 70, "Notes",
  CellTags->{"S1.1033", "MLGetRealArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[48488, 1895, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[48570, 1898, 581, 19, 70, "Usage",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[49154, 1919, 267, 7, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[49424, 1928, 202, 6, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[49629, 1936, 151, 5, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}],
Cell[49783, 1943, 208, 7, 70, "Notes",
  CellTags->{"S1.1034", "MLGetRealList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[50028, 1955, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1035", "MLGetShortInteger"}],
Cell[50118, 1958, 468, 17, 70, "Usage",
  CellTags->{"S1.1035", "MLGetShortInteger"}],
Cell[50589, 1977, 158, 5, 70, "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}],
Cell[50750, 1984, 210, 7, 70, "Notes",
  CellTags->{"S1.1035", "MLGetShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[50997, 1996, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[51075, 1999, 429, 15, 70, "Usage",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[51507, 2016, 261, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[51771, 2025, 196, 6, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[51970, 2033, 218, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[52191, 2042, 268, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[52462, 2051, 228, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[52693, 2060, 205, 7, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}],
Cell[52901, 2069, 253, 9, 70, "Notes",
  CellTags->{"S1.1036", "MLGetString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[53191, 2083, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[53269, 2086, 477, 15, 70, "Usage",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[53749, 2103, 261, 7, 70, "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[54013, 2112, 218, 7, 70, "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}],
Cell[54234, 2121, 338, 11, 70, "Notes",
  CellTags->{"S1.1037", "MLGetSymbol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54609, 2137, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[54701, 2140, 557, 17, 70, "Usage",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[55261, 2159, 282, 7, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[55546, 2168, 210, 6, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[55759, 2176, 213, 5, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[55975, 2183, 174, 4, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[56152, 2189, 212, 7, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}],
Cell[56367, 2198, 253, 9, 70, "Notes",
  CellTags->{"S1.1038", "MLGetUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[56657, 2212, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[56737, 2215, 220, 7, 70, "Usage",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[56960, 2224, 277, 7, 70, "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[57240, 2233, 309, 9, 70, "Notes",
  CellTags->{"S1.1039", "MLInitialize"}],
Cell[57552, 2244, 208, 7, 70, "Notes",
  CellTags->{"S1.1039", "MLInitialize"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[57797, 2256, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[57881, 2259, 324, 11, 70, "Usage",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[58208, 2272, 247, 7, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[58458, 2281, 219, 5, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[58680, 2288, 210, 7, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}],
Cell[58893, 2297, 177, 6, 70, "Notes",
  CellTags->{"S1.1040", "MLLoopbackOpen"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[59107, 2308, 65, 1, 70, "ObjectName",
  CellTags->{"S1.1041", "MLMain"}],
Cell[59175, 2311, 384, 13, 70, "Usage",
  CellTags->{"S1.1041", "MLMain"}],
Cell[59562, 2326, 239, 9, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}],
Cell[59804, 2337, 387, 13, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}],
Cell[60194, 2352, 185, 7, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}],
Cell[60382, 2361, 200, 7, 70, "Notes",
  CellTags->{"S1.1041", "MLMain"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[60619, 2373, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[60697, 2376, 270, 9, 70, "Usage",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[60970, 2387, 236, 6, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[61209, 2395, 192, 5, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[61404, 2402, 339, 11, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}],
Cell[61746, 2415, 174, 6, 70, "Notes",
  CellTags->{"S1.1042", "MLNewPacket"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[61957, 2426, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1043", "MLNextPacket"}],
Cell[62037, 2429, 301, 9, 70, "Usage",
  CellTags->{"S1.1043", "MLNextPacket"}],
Cell[62341, 2440, 209, 7, 70, "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}],
Cell[62553, 2449, 174, 6, 70, "Notes",
  CellTags->{"S1.1043", "MLNextPacket"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[62764, 2460, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[62840, 2463, 488, 17, 70, "Usage",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[63331, 2482, 200, 7, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[63534, 2491, 291, 9, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[63828, 2502, 1532, 46, 70, "2ColumnTable",
  CellTags->{"MLOpenArgv", "S1.1044"}],
Cell[65363, 2550, 182, 5, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[65548, 2557, 185, 5, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[65736, 2564, 293, 11, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[66032, 2577, 428, 17, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[66463, 2596, 275, 9, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[66741, 2607, 318, 10, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[67062, 2619, 206, 7, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}],
Cell[67271, 2628, 241, 9, 70, "Notes",
  CellTags->{"S1.1044", "MLOpenArgv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[67549, 2642, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[67629, 2645, 411, 13, 70, "Usage",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[68043, 2660, 204, 7, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[68250, 2669, 264, 9, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[68517, 2680, 138, 4, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[68658, 2686, 278, 6, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[68939, 2694, 208, 7, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}],
Cell[69150, 2703, 241, 9, 70, "Notes",
  CellTags->{"S1.1045", "MLOpenString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[69428, 2717, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1046", "MLPutArgCount"}],
Cell[69510, 2720, 355, 11, 70, "Usage",
  CellTags->{"S1.1046", "MLPutArgCount"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[69902, 2736, 83, 1, 70, "ObjectName",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[69988, 2739, 529, 19, 70, "Usage",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[70520, 2760, 274, 8, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[70797, 2770, 232, 6, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[71032, 2778, 194, 5, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[71229, 2785, 169, 4, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[71401, 2791, 209, 7, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}],
Cell[71613, 2800, 251, 9, 70, "Notes",
  CellTags->{"S1.1047", "MLPutByteString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[71901, 2814, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1048", "MLPutDouble"}],
Cell[71979, 2817, 464, 17, 70, "Usage",
  CellTags->{"S1.1048", "MLPutDouble"}],
Cell[72446, 2836, 149, 5, 70, "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}],
Cell[72598, 2843, 204, 7, 70, "Notes",
  CellTags->{"S1.1048", "MLPutDouble"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[72839, 2855, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[72915, 2858, 496, 17, 70, "Usage",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[73414, 2877, 381, 11, 70, "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[73798, 2890, 148, 5, 70, "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}],
Cell[73949, 2897, 203, 7, 70, "Notes",
  CellTags->{"S1.1049", "MLPutFloat"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[74189, 2909, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[74271, 2912, 538, 19, 70, "Usage",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[74812, 2933, 265, 7, 70, "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[75080, 2942, 207, 7, 70, "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}],
Cell[75290, 2951, 175, 6, 70, "Notes",
  CellTags->{"S1.1050", "MLPutFunction"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[75502, 2962, 77, 1, 70, "ObjectName",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[75582, 2965, 396, 15, 70, "Usage",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[75981, 2982, 295, 8, 70, "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[76279, 2992, 338, 11, 70, "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}],
Cell[76620, 3005, 398, 15, 70, "Notes",
  CellTags->{"S1.1051", "MLPutInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[77055, 3025, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[77145, 3028, 653, 23, 70, "Usage",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[77801, 3053, 287, 9, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[78091, 3064, 271, 9, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[78365, 3075, 215, 7, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[78583, 3084, 211, 7, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}],
Cell[78797, 3093, 184, 6, 70, "Notes",
  CellTags->{"S1.1052", "MLPutIntegerArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[79018, 3104, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1053", "MLPutIntegerList"}],
Cell[79106, 3107, 517, 19, 70, "Usage",
  CellTags->{"S1.1053", "MLPutIntegerList"}],
Cell[79626, 3128, 210, 7, 70, "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}],
Cell[79839, 3137, 257, 9, 70, "Notes",
  CellTags->{"S1.1053", "MLPutIntegerList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[80133, 3151, 85, 1, 70, "ObjectName",
  CellTags->{"S1.1054", "MLPutLongInteger"}],
Cell[80221, 3154, 410, 15, 70, "Usage",
  CellTags->{"S1.1054", "MLPutLongInteger"}],
Cell[80634, 3171, 157, 5, 70, "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}],
Cell[80794, 3178, 209, 7, 70, "Notes",
  CellTags->{"S1.1054", "MLPutLongInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[81040, 3190, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[81114, 3193, 329, 11, 70, "Usage",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[81446, 3206, 189, 6, 70, "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[81638, 3214, 206, 7, 70, "Notes",
  CellTags->{"S1.1055", "MLPutNext"}],
Cell[81847, 3223, 173, 6, 70, "Notes",
  CellTags->{"S1.1055", "MLPutNext"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[82057, 3234, 71, 1, 70, "ObjectName",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[82131, 3237, 415, 15, 70, "Usage",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[82549, 3254, 296, 8, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[82848, 3264, 201, 7, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[83052, 3273, 335, 11, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}],
Cell[83390, 3286, 310, 12, 70, "Notes",
  CellTags->{"S1.1056", "MLPutReal"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[83737, 3303, 81, 1, 70, "ObjectName",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[83821, 3306, 672, 23, 70, "Usage",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[84496, 3331, 287, 9, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[84786, 3342, 268, 9, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[85057, 3353, 212, 7, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[85272, 3362, 208, 7, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}],
Cell[85483, 3371, 178, 6, 70, "Notes",
  CellTags->{"S1.1057", "MLPutRealArray"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[85698, 3382, 79, 1, 70, "ObjectName",
  CellTags->{"S1.1058", "MLPutRealList"}],
Cell[85780, 3385, 536, 19, 70, "Usage",
  CellTags->{"S1.1058", "MLPutRealList"}],
Cell[86319, 3406, 207, 7, 70, "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}],
Cell[86529, 3415, 178, 6, 70, "Notes",
  CellTags->{"S1.1058", "MLPutRealList"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[86744, 3426, 87, 1, 70, "ObjectName",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[86834, 3429, 534, 19, 70, "Usage",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[87371, 3450, 392, 11, 70, "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[87766, 3463, 158, 5, 70, "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}],
Cell[87927, 3470, 210, 7, 70, "Notes",
  CellTags->{"S1.1059", "MLPutShortInteger"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[88174, 3482, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[88252, 3485, 373, 13, 70, "Usage",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[88628, 3500, 219, 6, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[88850, 3508, 175, 4, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[89028, 3514, 212, 6, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[89243, 3522, 205, 7, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}],
Cell[89451, 3531, 322, 12, 70, "Notes",
  CellTags->{"S1.1060", "MLPutString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[89810, 3548, 75, 1, 70, "ObjectName",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[89888, 3551, 437, 15, 70, "Usage",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[90328, 3568, 184, 6, 70, "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[90515, 3576, 337, 11, 70, "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}],
Cell[90855, 3589, 173, 6, 70, "Notes",
  CellTags->{"S1.1061", "MLPutSymbol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[91065, 3600, 89, 1, 70, "ObjectName",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[91157, 3603, 506, 17, 70, "Usage",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[91666, 3622, 136, 4, 70, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[91805, 3628, 181, 4, 70, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[91989, 3634, 212, 7, 70, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}],
Cell[92204, 3643, 253, 9, 70, "Notes",
  CellTags->{"S1.1062", "MLPutUnicodeString"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[92494, 3657, 67, 1, 70, "ObjectName",
  CellTags->{"S1.1063", "MLReady"}],
Cell[92564, 3660, 270, 9, 70, "Usage",
  CellTags->{"S1.1063", "MLReady"}],
Cell[92837, 3671, 196, 7, 70, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[93036, 3680, 225, 7, 70, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[93264, 3689, 180, 5, 70, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[93447, 3696, 208, 7, 70, "Notes",
  CellTags->{"S1.1063", "MLReady"}],
Cell[93658, 3705, 204, 7, 70, "Notes",
  CellTags->{"S1.1063", "MLReady"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[93899, 3717, 73, 1, 70, "ObjectName",
  CellTags->{"S1.1064", "MLSeekMark"}],
Cell[93975, 3720, 406, 13, 70, "Usage",
  CellTags->{"S1.1064", "MLSeekMark"}],
Cell[94384, 3735, 207, 7, 70, "Notes",
  CellTags->{"S1.1064", "MLSeekMark"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[94628, 3747, 93, 1, 70, "ObjectName",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[94724, 3750, 360, 11, 70, "Usage",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[95087, 3763, 194, 7, 70, "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[95284, 3772, 214, 7, 70, "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}],
Cell[95501, 3781, 216, 7, 70, "Notes",
  CellTags->{"S1.1065", "MLTransferExpression"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

