(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     49082,       1926]*)
(*NotebookOutlinePosition[     84314,       2771]*)
(*  CellTagsIndexPosition[     83133,       2728]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Install", "ObjectName",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " starts a ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible external program and installs ",
  StyleBox["Mathematica", "TI"],
  " definitions to call functions in it. "
}], "Usage",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Mathematica", "TI"],
  " definitions set up by ",
  StyleBox["Install", "MR"],
  " are typically specified in the ",
  StyleBox["MathLink", "TI"],
  " template file used to create the source code for the external program. "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " will launch the specified program, then connect to it via ",
  StyleBox["MathLink", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["prog", "TI"],
  " is a directory, ",
  StyleBox["Install[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " will try to execute ",
  StyleBox["prog", "TI"],
  StyleBox["/$SystemID/", "MR"],
  StyleBox["prog", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`\"]", "MR"],
  " searches all directories on ",
  ButtonBox["$Path",
    ButtonStyle->"RefGuideLink"],
  " for a file or directory called ",
  StyleBox["name", "TI"],
  StyleBox[".exe", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " will take an existing ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  " and set up what is needed to call functions in the program corresponding \
to that ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install", "MR"],
  " returns a ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  " representing the ",
  StyleBox["MathLink", "TI"],
  " connection it is using. "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkPatterns[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " gives a list of the patterns defined when the specified link was set up. \
"
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can remove these definitions, and terminate the \
execution of the external program by calling ",
  StyleBox["Uninstall[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install[LinkConnect[\"", "MR"],
  StyleBox["port", "TI"],
  StyleBox["\"]]", "MR"],
  " will install an external program that has created a link on the specified \
port. You can use this to call external programs that have been started in a \
debugger or on a remote computer system. "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] If you call ",
  StyleBox["Install[\"", "MR"],
  StyleBox["command", "TI"],
  StyleBox["\"]", "MR"],
  " multiple times with the same ",
  StyleBox["command", "TI"],
  ", the later calls will overwrite definitions set up by earlier ones, \
unless the definitions depend on the values of global variables which have \
changed. "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Install", "MR"],
  " sets up definitions which send ",
  StyleBox["CallPacket", "MR"],
  " objects to the external program whenever functions in it are called, and \
waits for results to be returned in ",
  StyleBox["ReturnPacket", "MR"],
  " objects. "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] The external program can send ",
  StyleBox["EvaluatePacket", "MR"],
  " objects back to ",
  StyleBox["Mathematica", "TI"],
  " to request evaluations while the program is running. "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.11.11",
    ButtonData:>{"1.11.11", "11.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.2",
    ButtonData:>{"2.13.2", "2.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Get",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Run",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["RunThrough",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Uninstall",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$CurrentLink",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1001", "Install"}],

Cell["\<\
\[FilledSmallSquare] New in Version 2; modified in 3.\
\>", "Notes",
  CellTags->{"S0.1001", "Install"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkClose", "ObjectName",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkClose[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " closes an open ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["link", "TI"],
  " must be an active ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ", as returned by functions like ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] Closing a ",
  StyleBox["MathLink", "TI"],
  " connection does not necessarily terminate the program at the other end of \
the connection. "
}], "Notes",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.6",
    ButtonData:>{"2.13.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LinkInterrupt",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Close",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1002", "LinkClose"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"LinkClose", "S0.1002"}],

Cell[TextData[{
  "See the Further Examples for ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "ExampleSubsection",
  CellTags->{"LinkClose", "S0.1002"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkConnect", "ObjectName",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " connects to a ",
  StyleBox["MathLink", "TI"],
  " link created by another program. "
}], "Usage",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect", "MR"],
  " by default operates with internet TCP links, with names of the form ",
  StyleBox["port", "TI"],
  StyleBox["@", "MR"],
  StyleBox["host", "TI"],
  ". Ports are typically specified by numbers. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect", "MR"],
  " can connect to a port on a remote computer system. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] On some computer systems, ",
  StyleBox["LinkConnect[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " will bring up a port browser. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect", "MR"],
  " returns a ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["LinkConnect", "MR"],
  " with ",
  ButtonBox["LinkCreate",
    ButtonStyle->"RefGuideLink"],
  " to set up peer\[Hyphen]to\[Hyphen]peer communication between two ",
  StyleBox["Mathematica", "TI"],
  " processes. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect", "MR"],
  " can be used to connect to a link created by calling ",
  ButtonBox["LinkCreate",
    ButtonStyle->"RefGuideLink"],
  " in another ",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect", "MR"],
  " can be used to connect to an external program that has created a ",
  StyleBox["MathLink", "TI"],
  " link by calling the appropriate ",
  StyleBox["MathLink", "TI"],
  " library functions. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs built from ",
  StyleBox["MathLink", "TI"],
  " templates using ",
  StyleBox["mcc", "MR"],
  " and ",
  StyleBox["mprep", "MR"],
  " can typically create ",
  StyleBox["MathLink", "TI"],
  " links whenever they are given ",
  StyleBox["-linkcreate", "MR"],
  " command\[Hyphen]line arguments. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  ButtonBox["LinkProtocol",
    ButtonStyle->"RefGuideLink"],
  " specifies the underlying data transport protocol that ",
  StyleBox["LinkConnect", "MR"],
  " should use. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkConnect", "MR"],
  " internally calls a function analogous to the ",
  StyleBox["MLOpenArgv()", "MR"],
  " function in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] Even though no program may yet be connected to the \
other end of the ",
  StyleBox["MathLink", "TI"],
  " link, the function ",
  StyleBox["LinkConnect", "MR"],
  " will return immediately and will not block. "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.6",
    ButtonData:>{"2.13.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LinkCreate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkClose",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1003", "LinkConnect"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkCreate", "ObjectName",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkCreate[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " creates a ",
  StyleBox["MathLink", "TI"],
  " link with the specified name for another program to connect to. \n\
\[FilledSmallSquare] ",
  StyleBox["LinkCreate[ ]", "MR"],
  " picks an unused port on your computer system and creates a ",
  StyleBox["MathLink", "TI"],
  " link on it. "
}], "Usage",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkCreate", "MR"],
  " returns a ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["LinkCreate", "MR"],
  " and ",
  ButtonBox["LinkConnect",
    ButtonStyle->"RefGuideLink"],
  " to set up peer\[Hyphen]to\[Hyphen]peer communication between two ",
  StyleBox["Mathematica", "TI"],
  " processes. "
}], "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  ButtonBox["LinkProtocol",
    ButtonStyle->"RefGuideLink"],
  " specifies the underlying data transport protocol to use. "
}], "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkCreate", "MR"],
  " internally calls a function analogous to the ",
  StyleBox["MLOpenArgv()", "MR"],
  " function in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.6",
    ButtonData:>{"2.13.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LinkConnect",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkClose",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1004", "LinkCreate"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkInterrupt", "ObjectName",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkInterrupt[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " sends an interrupt to the program at the other end of the specified ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["link", "TI"],
  " must be an active ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ", as returned by functions such as ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell["\<\
\[FilledSmallSquare] It is up to the external program to determine \
how it will handle the interrupt. \
\>", "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell[TextData[{
  "\[FilledSmallSquare] External programs created from ",
  StyleBox["MathLink", "TI"],
  " templates will by default set the global variable ",
  StyleBox["MLAbort", "MR"],
  " if they receive an abort. "
}], "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.7",
    ButtonData:>{"2.13.7", "7.28"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Interrupt",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkClose",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkLaunch", "ObjectName",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkLaunch[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " starts the external program ",
  StyleBox["prog", "TI"],
  " and opens a ",
  StyleBox["MathLink", "TI"],
  " connection to it. "
}], "Usage",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkLaunch[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " runs ",
  StyleBox["prog", "TI"],
  " as a subsidiary or child process to your current ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use a command such as ",
  StyleBox["LinkLaunch[\"math -mathlink\"]", "MR"],
  " to launch a subsidiary ",
  StyleBox["Mathematica", "TI"],
  " kernel process from within your ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] On most computer systems calling ",
  StyleBox["LinkLaunch[\"", "MR"],
  StyleBox["prog", "TI"],
  StyleBox["\"]", "MR"],
  " multiple times with the same argument will start several ",
  StyleBox["prog", "TI"],
  " processes running. "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] On some computer systems, ",
  StyleBox["LinkLaunch[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " will bring up a program browser. "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkLaunch", "MR"],
  " returns a ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] The option ",
  ButtonBox["LinkProtocol",
    ButtonStyle->"RefGuideLink"],
  " specifies the underlying data transport protocol to use. "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkLaunch", "MR"],
  " internally calls a function analogous to the ",
  StyleBox["MLOpenArgv()", "MR"],
  " function in the ",
  StyleBox["MathLink", "TI"],
  " library. "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.7",
    ButtonData:>{"2.13.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkCreate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkConnect",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkClose",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[TextData[{
  StyleBox["LinkLaunch", "MR"],
  " launches and connects to a program that is aware of ",
  StyleBox["MathLink", "TI"],
  ". Here we launch a copy of ",
  StyleBox["Mathematica", "TI"],
  "; a reason for doing this would be for two or more kernels to cooperate in \
solving a problem. "
}], "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[CellGroupData[{

Cell["link = LinkLaunch[\"math -mathlink\"]", "Input",
  CellLabel->"In[1]:=",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell["LinkObject[math, 2, 2]", "Output",
  CellLabel->"Out[1]=",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Open  ]],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " communicates using packets. When the second kernel starts up, it sends a \
packet containing the first input prompt to the program that launched it. "
}], "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[CellGroupData[{

Cell["LinkRead[link]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell["InputNamePacket[In[1]:= ]", "Output",
  CellLabel->"Out[2]=",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Open  ]],

Cell[TextData[{
  "To send an expression to the second kernel for evaluation, wrap it in an \
EvaluatePacket; the result comes back in a ",
  StyleBox["ReturnPacket", "MR"],
  ". The ",
  StyleBox["Unevaluated", "MR"],
  " around the expression keeps it from evaluating before it is sent. "
}], "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[CellGroupData[{

Cell["\<\
{LinkWrite[link, Unevaluated[EvaluatePacket[2 + 2]]], \
LinkRead[link]}\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell["{Null, ReturnPacket[4]}", "Output",
  CellLabel->"Out[3]=",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Open  ]],

Cell["When you are finished, quit the second kernel. ", "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell["LinkClose[link]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkObject", "ObjectName",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkObject[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\", ", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " is an object that represents an active ",
  StyleBox["MathLink", "TI"],
  " connection for functions such as ",
  ButtonBox["LinkRead",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["LinkWrite",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Usage",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["LinkConnect",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkCreate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  " all return ",
  StyleBox["LinkObject", "MR"],
  " objects. "
}], "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[TextData[{
  "\[FilledSmallSquare] The integer ",
  StyleBox["n", "TI"],
  " is a serial number used to distinguish links with the same name. "
}], "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["name", "TI"],
  " is typically the name of an external program, or an internet TCP \
specification of the form ",
  StyleBox["port", "TI"],
  StyleBox["@", "MR"],
  StyleBox["host", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.2",
    ButtonData:>{"2.13.2", "2.3"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.9",
    ButtonData:>{"2.13.9", "9.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkReadyQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["InputStream",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"LinkObject", "S0.1007"}],

Cell[TextData[{
  "See the Further Examples for ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "ExampleSubsection",
  CellTags->{"LinkObject", "S0.1007"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkPatterns", "ObjectName",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkPatterns[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " gives a list of the patterns for which definitions were set up when the \
external program associated with the specified ",
  StyleBox["MathLink", "TI"],
  " connection was installed. "
}], "Usage",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell[TextData[{
  "\[FilledSmallSquare] Each element of the list returned by ",
  StyleBox["LinkPatterns", "MR"],
  " is wrapped in ",
  ButtonBox["HoldForm",
    ButtonStyle->"RefGuideLink"],
  " to prevent evaluation. "
}], "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell[TextData[{
  "\[FilledSmallSquare] The patterns in ",
  StyleBox["LinkPatterns", "MR"],
  " typically originate in ",
  StyleBox[":Pattern:", "MR"],
  " specifications in the ",
  StyleBox["MathLink", "TI"],
  " templates used to create source code for the external program. "
}], "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Uninstall[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " calls ",
  ButtonBox["Unset",
    ButtonStyle->"RefGuideLink"],
  " on the patterns in ",
  StyleBox["LinkPatterns[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.3",
    ButtonData:>{"2.13.3", "3.27"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkProtocol", "ObjectName",
  CellTags->{"S0.1009", "LinkProtocol"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkProtocol", "MR"],
  " is an option to ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  " and related functions which specifies the underlying data transport \
protocol to use for a new ",
  StyleBox["MathLink", "TI"],
  " link. "
}], "Usage",
  CellTags->{"S0.1009", "LinkProtocol"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typical settings for ",
  StyleBox["LinkProtocol", "MR"],
  " are ",
  StyleBox["\"SharedMemory\"", "MR"],
  " and ",
  StyleBox["\"FileMap\"", "MR"],
  " (Windows), ",
  StyleBox["\"Pipes\"", "MR"],
  " (Unix, Macintosh) and ",
  StyleBox["\"TCPIP\"", "MR"],
  " (all systems). "
}], "Notes",
  CellTags->{"S0.1009", "LinkProtocol"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.5",
    ButtonData:>{"2.13.5", "5.3"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1009", "LinkProtocol"}],

Cell["\<\
\[FilledSmallSquare] New in Version 3; modified in 5.\
\>", "Notes",
  CellTags->{"S0.1009", "LinkProtocol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkRead", "ObjectName",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkRead[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " reads one expression from the specified ",
  StyleBox["MathLink", "TI"],
  " connection. \n\[FilledSmallSquare] ",
  StyleBox["LinkRead[", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " wraps ",
  StyleBox["h", "TI"],
  " around the expression read before evaluating it. "
}], "Usage",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["link", "TI"],
  " must be an active ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ", as returned by functions like ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkRead", "MR"],
  " will wait until it has read a complete expression before returning. "
}], "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can test whether an expression is ready to be \
read from a particular link using ",
  ButtonBox["LinkReadyQ",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["LinkRead[", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", Hold]", "MR"],
  " to get an expression from a link without evaluating it. "
}], "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.6",
    ButtonData:>{"2.13.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LinkReadyQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkWrite",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Read",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"LinkRead", "S0.1010"}],

Cell[TextData[{
  "See the Further Examples for ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "ExampleSubsection",
  CellTags->{"LinkRead", "S0.1010"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkReadyQ", "ObjectName",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkReadyQ[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " tests whether there is an expression ready to read from the specified ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["link", "TI"],
  " must be an active ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ", as returned by functions like ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["LinkReadyQ[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  ", then ",
  StyleBox["LinkRead[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " will not block under any normal circumstances. "
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] If ",
  StyleBox["LinkReadyQ[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  ", then ",
  StyleBox["LinkRead[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " will block, and will not return until something becomes available to read \
on ",
  StyleBox["link", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkReadyQ[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " tests whether there is any data to read; it cannot determine whether the \
data represents a complete expression. "
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkReadyQ", "MR"],
  " corresponds to the ",
  StyleBox["MathLink", "TI"],
  " library function ",
  StyleBox["MLReady()", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.6",
    ButtonData:>{"2.13.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LinkRead",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkWrite",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkInterrupt",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Links", "ObjectName",
  CellTags->{"S0.1012", "Links"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Links[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives a list of all ",
  StyleBox["MathLink", "TI"],
  " connections that are currently open. \n\[FilledSmallSquare] ",
  StyleBox["Links[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\"]", "MR"],
  " lists only links with the specified name. "
}], "Usage",
  CellTags->{"S0.1012", "Links"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Links", "MR"],
  " returns a list of ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  " objects. "
}], "Notes",
  CellTags->{"S0.1012", "Links"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.3",
    ButtonData:>{"2.13.3", "3.27"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1012", "Links"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$ParentLink",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$CurrentLink",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Streams",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkReadyQ",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkClose",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1012", "Links"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1012", "Links"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkWrite", "ObjectName",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["LinkWrite[", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " writes ",
  StyleBox["expr", "TI"],
  " to the specified ",
  StyleBox["MathLink", "TI"],
  " connection. "
}], "Usage",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["link", "TI"],
  " must be an active ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  ", as returned by functions like ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  " or ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["LinkWrite[", "MR"],
  StyleBox["link", "TI"],
  StyleBox[", Unevaluated[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]]", "MR"],
  " to write ",
  StyleBox["expr", "TI"],
  " to the link without evaluating it. "
}], "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] The head of ",
  StyleBox["expr", "TI"],
  " will often be a packet which specifies how ",
  StyleBox["expr", "TI"],
  " should be processed by the program which receives it. "
}], "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] When ",
  StyleBox["LinkWrite", "MR"],
  " is used to send data to a ",
  StyleBox["Mathematica", "TI"],
  " kernel, ",
  StyleBox["EnterTextPacket[\"", "MR"],
  StyleBox["string", "TI"],
  StyleBox["\"]", "MR"],
  " enters the text of an input line, and ",
  StyleBox["EvaluatePacket[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " sends an expression for evaluation. "
}], "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.6",
    ButtonData:>{"2.13.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["LinkRead",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Write",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["FrontEndExecute",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[CellGroupData[{

Cell["Further Examples", "ExampleSection",
  CellTags->{"LinkWrite", "S0.1013"}],

Cell[TextData[{
  "See the Further Examples for ",
  ButtonBox["LinkLaunch",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "ExampleSubsection",
  CellTags->{"LinkWrite", "S0.1013"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uninstall", "ObjectName",
  CellTags->{"S0.1014", "Uninstall"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Uninstall[", "MR"],
  StyleBox["link", "TI"],
  StyleBox["]", "MR"],
  " terminates an external program started by ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  ", and removes ",
  StyleBox["Mathematica", "TI"],
  " definitions set up by it. "
}], "Usage",
  CellTags->{"S0.1014", "Uninstall"}],

Cell[TextData[{
  "\[FilledSmallSquare] The argument of ",
  StyleBox["Uninstall", "MR"],
  " is a ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  " representing a ",
  StyleBox["MathLink", "TI"],
  " link as returned by ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1014", "Uninstall"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Uninstall", "MR"],
  " calls ",
  ButtonBox["Unset",
    ButtonStyle->"RefGuideLink"],
  " to remove definitions set up by ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1014", "Uninstall"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 1.11.11",
    ButtonData:>{"1.11.11", "11.5"},
    ButtonStyle->"MainBookLink"],
  " and\[NonBreakingSpace]",
  ButtonBox["Section 2.13.2",
    ButtonData:>{"2.13.2", "2.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1014", "Uninstall"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["LinkClose",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Close",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1014", "Uninstall"}],

Cell["\<\
\[FilledSmallSquare] New in Version 2; modified in 3.\
\>", "Notes",
  CellTags->{"S0.1014", "Uninstall"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["$CurrentLink", "ObjectName",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$CurrentLink", "MR"],
  " is the ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  " representing the ",
  StyleBox["MathLink", "TI"],
  " connection for an external program currently being installed or being \
called. "
}], "Usage",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$CurrentLink", "MR"],
  " is temporarily set by ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  " and by ",
  StyleBox["ExternalCall", "MR"],
  ". "
}], "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can use ",
  StyleBox["$CurrentLink", "MR"],
  " to distinguish between several instances of an external program running \
at the same time. "
}], "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$CurrentLink", "MR"],
  " can be included in ",
  StyleBox[":Pattern:", "MR"],
  " and ",
  StyleBox[":Arguments:", "MR"],
  " ",
  StyleBox["MathLink", "TI"],
  " template specifications, and will be evaluated at the time when ",
  ButtonBox["Install",
    ButtonStyle->"RefGuideLink"],
  " is called. "
}], "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.9",
    ButtonData:>{"2.13.9", "9.7"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$ParentLink",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$Input",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["$InstallationDate", "ObjectName",
  CellTags->{"S0.1016", "$InstallationDate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$InstallationDate", "MR"],
  " gives the date and time at which the copy of the ",
  StyleBox["Mathematica", "TI"],
  " kernel you are running was installed. "
}], "Usage",
  CellTags->{"S0.1016", "$InstallationDate"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$InstallationDate", "MR"],
  " is in the form ",
  StyleBox["{", "MR"],
  StyleBox["year", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["month", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["day", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["hour", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["minute", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["second", "TI"],
  StyleBox["}", "MR"],
  " returned by ",
  ButtonBox["Date",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.14.5",
    ButtonData:>{"2.14.5", "5.7"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$CreationDate",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$InstallationDirectory",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["$InstallationDirectory", "ObjectName",
  CellTags->{"S0.1017", "$InstallationDirectory"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$InstallationDirectory", "MR"],
  " gives the top\[Hyphen]level directory in which your ",
  StyleBox["Mathematica", "TI"],
  " installation resides. "
}], "Usage",
  CellTags->{"S0.1017", "$InstallationDirectory"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$InstallationDirectory", "MR"],
  " returns the full name of the directory as a string. "
}], "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],

Cell["\[FilledSmallSquare] Typical values are: ", "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["C:\[Backslash]Program", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["Files\[Backslash]Wolfram", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox[
              "Research\[Backslash]Mathematica\[Backslash]5.2", "MR"],
              " "
            }]], Cell["Windows "]},
          {Cell[TextData[{
              StyleBox["/Applications/Mathematica", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              StyleBox["5.2.app", "MR"],
              " "
            }]], Cell["Macintosh "]},
          {Cell[TextData[{
              StyleBox["/usr/local/Wolfram/Mathematica/5.2", "MR"],
              " "
            }]], Cell["Unix "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "2ColumnTable",
  CellTags->{"$InstallationDirectory", "S0.1017"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.12.4",
    ButtonData:>{"2.12.4", "4.10"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$BaseDirectory",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$HomeDirectory",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$InitialDirectory",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$InstallationDate",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],

Cell["\[FilledSmallSquare] New in Version 5.", "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["$Linked", "ObjectName",
  CellTags->{"S0.1018", "$Linked"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$Linked", "MR"],
  " is ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " if the ",
  StyleBox["Mathematica", "TI"],
  " kernel is being run through ",
  StyleBox["MathLink", "TI"],
  ". "
}], "Usage",
  CellTags->{"S0.1018", "$Linked"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$Linked", "MR"],
  " is ",
  ButtonBox["True",
    ButtonStyle->"RefGuideLink"],
  " when ",
  StyleBox["Mathematica", "TI"],
  " is being run with a front end. "
}], "Notes",
  CellTags->{"S0.1018", "$Linked"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$Linked", "MR"],
  " is typically ",
  ButtonBox["False",
    ButtonStyle->"RefGuideLink"],
  " when ",
  StyleBox["Mathematica", "TI"],
  " is being run with a text\[Hyphen]based interface. "
}], "Notes",
  CellTags->{"S0.1018", "$Linked"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$CommandLine",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$BatchInput",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$BatchOutput",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$Notebooks",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1018", "$Linked"}],

Cell["\[FilledSmallSquare] New in Version 2.", "Notes",
  CellTags->{"S0.1018", "$Linked"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["$ParentLink", "ObjectName",
  CellTags->{"S0.1019", "$ParentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["$ParentLink", "MR"],
  " is the ",
  StyleBox["MathLink", "TI"],
  " ",
  ButtonBox["LinkObject",
    ButtonStyle->"RefGuideLink"],
  " currently used for input and output by the ",
  StyleBox["Mathematica", "TI"],
  " kernel in a particular session. "
}], "Usage",
  CellTags->{"S0.1019", "$ParentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] When the ",
  StyleBox["Mathematica", "TI"],
  " kernel is started by a ",
  StyleBox["Mathematica", "TI"],
  " front end, ",
  StyleBox["$ParentLink", "MR"],
  " gives the ",
  StyleBox["MathLink", "TI"],
  " connection between the front end and the kernel. "
}], "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] You can reset ",
  StyleBox["$ParentLink", "MR"],
  " in the middle of a ",
  StyleBox["Mathematica", "TI"],
  " session to connect the kernel to a different front end. "
}], "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] See ",
  ButtonBox["Section 2.13.8",
    ButtonData:>{"2.13.8", "8.2"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],

Cell[TextData[{
  "\[FilledSmallSquare] See also: ",
  ButtonBox["$CurrentLink",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Links",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["$Input",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],

Cell["\[FilledSmallSquare] New in Version 3.", "Notes",
  CellTags->{"S0.1019", "$ParentLink"}]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.1001"->{
    Cell[1776, 53, 65, 1, 70, "ObjectName",
      CellTags->{"S0.1001", "Install"}],
    Cell[1844, 56, 352, 11, 70, "Usage",
      CellTags->{"S0.1001", "Install"}],
    Cell[2199, 69, 331, 9, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[2533, 80, 276, 9, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[2812, 91, 345, 13, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[3160, 106, 362, 13, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[3525, 121, 416, 14, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[3944, 137, 281, 10, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[4228, 149, 256, 8, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[4487, 159, 278, 8, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[4768, 169, 389, 9, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[5160, 180, 416, 11, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[5579, 193, 357, 10, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[5939, 205, 272, 7, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[6214, 214, 331, 11, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[6548, 227, 495, 21, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[7046, 250, 114, 3, 70, "Notes",
      CellTags->{"S0.1001", "Install"}]},
  "Install"->{
    Cell[1776, 53, 65, 1, 70, "ObjectName",
      CellTags->{"S0.1001", "Install"}],
    Cell[1844, 56, 352, 11, 70, "Usage",
      CellTags->{"S0.1001", "Install"}],
    Cell[2199, 69, 331, 9, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[2533, 80, 276, 9, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[2812, 91, 345, 13, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[3160, 106, 362, 13, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[3525, 121, 416, 14, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[3944, 137, 281, 10, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[4228, 149, 256, 8, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[4487, 159, 278, 8, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[4768, 169, 389, 9, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[5160, 180, 416, 11, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[5579, 193, 357, 10, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[5939, 205, 272, 7, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[6214, 214, 331, 11, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[6548, 227, 495, 21, 70, "Notes",
      CellTags->{"S0.1001", "Install"}],
    Cell[7046, 250, 114, 3, 70, "Notes",
      CellTags->{"S0.1001", "Install"}]},
  "S0.1002"->{
    Cell[7197, 258, 69, 1, 70, "ObjectName",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[7269, 261, 244, 9, 70, "Usage",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[7516, 272, 375, 14, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[7894, 288, 231, 6, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8128, 296, 202, 7, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8333, 305, 236, 9, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8572, 316, 93, 1, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8690, 321, 80, 1, 70, "ExampleSection",
      CellTags->{"LinkClose", "S0.1002"}],
    Cell[8773, 324, 180, 6, 70, "ExampleSubsection",
      CellTags->{"LinkClose", "S0.1002"}]},
  "LinkClose"->{
    Cell[7197, 258, 69, 1, 70, "ObjectName",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[7269, 261, 244, 9, 70, "Usage",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[7516, 272, 375, 14, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[7894, 288, 231, 6, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8128, 296, 202, 7, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8333, 305, 236, 9, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8572, 316, 93, 1, 70, "Notes",
      CellTags->{"S0.1002", "LinkClose"}],
    Cell[8690, 321, 80, 1, 70, "ExampleSection",
      CellTags->{"LinkClose", "S0.1002"}],
    Cell[8773, 324, 180, 6, 70, "ExampleSubsection",
      CellTags->{"LinkClose", "S0.1002"}]},
  "S0.1003"->{
    Cell[9002, 336, 73, 1, 70, "ObjectName",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9078, 339, 272, 9, 70, "Usage",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9353, 350, 327, 9, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9683, 361, 185, 5, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9871, 368, 221, 7, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10095, 377, 212, 8, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10310, 387, 334, 10, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10647, 399, 313, 10, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10963, 411, 324, 9, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[11290, 422, 406, 13, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[11699, 437, 280, 8, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[11982, 447, 282, 9, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[12267, 458, 304, 8, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[12574, 468, 204, 7, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[12781, 477, 307, 12, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[13091, 491, 95, 1, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}]},
  "LinkConnect"->{
    Cell[9002, 336, 73, 1, 70, "ObjectName",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9078, 339, 272, 9, 70, "Usage",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9353, 350, 327, 9, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9683, 361, 185, 5, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[9871, 368, 221, 7, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10095, 377, 212, 8, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10310, 387, 334, 10, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10647, 399, 313, 10, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[10963, 411, 324, 9, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[11290, 422, 406, 13, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[11699, 437, 280, 8, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[11982, 447, 282, 9, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[12267, 458, 304, 8, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[12574, 468, 204, 7, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[12781, 477, 307, 12, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}],
    Cell[13091, 491, 95, 1, 70, "Notes",
      CellTags->{"S0.1003", "LinkConnect"}]},
  "S0.1004"->{
    Cell[13223, 497, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[13297, 500, 472, 14, 70, "Usage",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[13772, 516, 210, 8, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[13985, 526, 332, 10, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[14320, 538, 230, 6, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[14553, 546, 280, 9, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[14836, 557, 203, 7, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[15042, 566, 307, 12, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[15352, 580, 94, 1, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}]},
  "LinkCreate"->{
    Cell[13223, 497, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[13297, 500, 472, 14, 70, "Usage",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[13772, 516, 210, 8, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[13985, 526, 332, 10, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[14320, 538, 230, 6, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[14553, 546, 280, 9, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[14836, 557, 203, 7, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[15042, 566, 307, 12, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}],
    Cell[15352, 580, 94, 1, 70, "Notes",
      CellTags->{"S0.1004", "LinkCreate"}]},
  "S0.1005"->{
    Cell[15483, 586, 77, 1, 70, "ObjectName",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[15563, 589, 305, 9, 70, "Usage",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[15871, 600, 381, 14, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16255, 616, 170, 4, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16428, 622, 276, 7, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16707, 631, 207, 7, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16917, 640, 240, 9, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[17160, 651, 97, 1, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}]},
  "LinkInterrupt"->{
    Cell[15483, 586, 77, 1, 70, "ObjectName",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[15563, 589, 305, 9, 70, "Usage",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[15871, 600, 381, 14, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16255, 616, 170, 4, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16428, 622, 276, 7, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16707, 631, 207, 7, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[16917, 640, 240, 9, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}],
    Cell[17160, 651, 97, 1, 70, "Notes",
      CellTags->{"S0.1005", "LinkInterrupt"}]},
  "S0.1006"->{
    Cell[17294, 657, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[17368, 660, 314, 11, 70, "Usage",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[17685, 673, 322, 11, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18010, 686, 326, 9, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18339, 697, 328, 9, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18670, 708, 222, 7, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18895, 717, 210, 8, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19108, 727, 230, 6, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19341, 735, 280, 9, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19624, 746, 203, 7, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19830, 755, 372, 15, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[20205, 772, 94, 1, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[20324, 777, 81, 1, 70, "ExampleSection",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[20408, 780, 361, 9, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[20794, 793, 117, 2, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[20914, 797, 103, 2, 70, "Output",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21032, 802, 258, 5, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21315, 811, 95, 2, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21413, 815, 106, 2, 70, "Output",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21534, 820, 348, 8, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21907, 832, 160, 5, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[22070, 839, 104, 2, 70, "Output",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[22189, 844, 109, 1, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[22301, 847, 96, 2, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}]},
  "LinkLaunch"->{
    Cell[17294, 657, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[17368, 660, 314, 11, 70, "Usage",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[17685, 673, 322, 11, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18010, 686, 326, 9, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18339, 697, 328, 9, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18670, 708, 222, 7, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[18895, 717, 210, 8, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19108, 727, 230, 6, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19341, 735, 280, 9, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19624, 746, 203, 7, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[19830, 755, 372, 15, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[20205, 772, 94, 1, 70, "Notes",
      CellTags->{"S0.1006", "LinkLaunch"}],
    Cell[20324, 777, 81, 1, 70, "ExampleSection",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[20408, 780, 361, 9, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[20794, 793, 117, 2, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[20914, 797, 103, 2, 70, "Output",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21032, 802, 258, 5, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21315, 811, 95, 2, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21413, 815, 106, 2, 70, "Output",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21534, 820, 348, 8, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[21907, 832, 160, 5, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[22070, 839, 104, 2, 70, "Output",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[22189, 844, 109, 1, 70, "ExampleText",
      CellTags->{"LinkLaunch", "S0.1006"}],
    Cell[22301, 847, 96, 2, 70, "Input",
      CellTags->{"LinkLaunch", "S0.1006"}]},
  "S0.1007"->{
    Cell[22446, 855, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[22520, 858, 478, 17, 70, "Usage",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23001, 877, 424, 17, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23428, 896, 200, 5, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23631, 903, 302, 10, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23936, 915, 331, 11, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[24270, 928, 303, 12, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[24576, 942, 94, 1, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[24695, 947, 81, 1, 70, "ExampleSection",
      CellTags->{"LinkObject", "S0.1007"}],
    Cell[24779, 950, 181, 6, 70, "ExampleSubsection",
      CellTags->{"LinkObject", "S0.1007"}]},
  "LinkObject"->{
    Cell[22446, 855, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[22520, 858, 478, 17, 70, "Usage",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23001, 877, 424, 17, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23428, 896, 200, 5, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23631, 903, 302, 10, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[23936, 915, 331, 11, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[24270, 928, 303, 12, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[24576, 942, 94, 1, 70, "Notes",
      CellTags->{"S0.1007", "LinkObject"}],
    Cell[24695, 947, 81, 1, 70, "ExampleSection",
      CellTags->{"LinkObject", "S0.1007"}],
    Cell[24779, 950, 181, 6, 70, "ExampleSubsection",
      CellTags->{"LinkObject", "S0.1007"}]},
  "S0.1008"->{
    Cell[25009, 962, 75, 1, 70, "ObjectName",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[25087, 965, 370, 10, 70, "Usage",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[25460, 977, 275, 8, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[25738, 987, 335, 9, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26076, 998, 362, 14, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26441, 1014, 206, 7, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26650, 1023, 170, 6, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26823, 1031, 96, 1, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}]},
  "LinkPatterns"->{
    Cell[25009, 962, 75, 1, 70, "ObjectName",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[25087, 965, 370, 10, 70, "Usage",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[25460, 977, 275, 8, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[25738, 987, 335, 9, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26076, 998, 362, 14, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26441, 1014, 206, 7, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26650, 1023, 170, 6, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}],
    Cell[26823, 1031, 96, 1, 70, "Notes",
      CellTags->{"S0.1008", "LinkPatterns"}]},
  "S0.1009"->{
    Cell[26956, 1037, 75, 1, 70, "ObjectName",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[27034, 1040, 423, 14, 70, "Usage",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[27460, 1056, 374, 13, 70, "Notes",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[27837, 1071, 205, 7, 70, "Notes",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[28045, 1080, 119, 3, 70, "Notes",
      CellTags->{"S0.1009", "LinkProtocol"}]},
  "LinkProtocol"->{
    Cell[26956, 1037, 75, 1, 70, "ObjectName",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[27034, 1040, 423, 14, 70, "Usage",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[27460, 1056, 374, 13, 70, "Notes",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[27837, 1071, 205, 7, 70, "Notes",
      CellTags->{"S0.1009", "LinkProtocol"}],
    Cell[28045, 1080, 119, 3, 70, "Notes",
      CellTags->{"S0.1009", "LinkProtocol"}]},
  "S0.1010"->{
    Cell[28201, 1088, 67, 1, 70, "ObjectName",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[28271, 1091, 509, 17, 70, "Usage",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[28783, 1110, 373, 14, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29159, 1126, 196, 5, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29358, 1133, 245, 7, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29606, 1142, 252, 7, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29861, 1151, 201, 7, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[30065, 1160, 298, 12, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[30366, 1174, 92, 1, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[30483, 1179, 79, 1, 70, "ExampleSection",
      CellTags->{"LinkRead", "S0.1010"}],
    Cell[30565, 1182, 179, 6, 70, "ExampleSubsection",
      CellTags->{"LinkRead", "S0.1010"}]},
  "LinkRead"->{
    Cell[28201, 1088, 67, 1, 70, "ObjectName",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[28271, 1091, 509, 17, 70, "Usage",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[28783, 1110, 373, 14, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29159, 1126, 196, 5, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29358, 1133, 245, 7, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29606, 1142, 252, 7, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[29861, 1151, 201, 7, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[30065, 1160, 298, 12, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[30366, 1174, 92, 1, 70, "Notes",
      CellTags->{"S0.1010", "LinkRead"}],
    Cell[30483, 1179, 79, 1, 70, "ExampleSection",
      CellTags->{"LinkRead", "S0.1010"}],
    Cell[30565, 1182, 179, 6, 70, "ExampleSubsection",
      CellTags->{"LinkRead", "S0.1010"}]},
  "S0.1011"->{
    Cell[30793, 1194, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[30867, 1197, 301, 9, 70, "Usage",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[31171, 1208, 375, 14, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[31549, 1224, 394, 14, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[31946, 1240, 461, 17, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[32410, 1259, 296, 8, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[32709, 1269, 244, 9, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[32956, 1280, 203, 7, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[33162, 1289, 307, 12, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[33472, 1303, 94, 1, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}]},
  "LinkReadyQ"->{
    Cell[30793, 1194, 71, 1, 70, "ObjectName",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[30867, 1197, 301, 9, 70, "Usage",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[31171, 1208, 375, 14, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[31549, 1224, 394, 14, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[31946, 1240, 461, 17, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[32410, 1259, 296, 8, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[32709, 1269, 244, 9, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[32956, 1280, 203, 7, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[33162, 1289, 307, 12, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}],
    Cell[33472, 1303, 94, 1, 70, "Notes",
      CellTags->{"S0.1011", "LinkReadyQ"}]},
  "S0.1012"->{
    Cell[33603, 1309, 61, 1, 70, "ObjectName",
      CellTags->{"S0.1012", "Links"}],
    Cell[33667, 1312, 400, 13, 70, "Usage",
      CellTags->{"S0.1012", "Links"}],
    Cell[34070, 1327, 216, 8, 70, "Notes",
      CellTags->{"S0.1012", "Links"}],
    Cell[34289, 1337, 199, 7, 70, "Notes",
      CellTags->{"S0.1012", "Links"}],
    Cell[34491, 1346, 505, 21, 70, "Notes",
      CellTags->{"S0.1012", "Links"}],
    Cell[34999, 1369, 89, 1, 70, "Notes",
      CellTags->{"S0.1012", "Links"}]},
  "Links"->{
    Cell[33603, 1309, 61, 1, 70, "ObjectName",
      CellTags->{"S0.1012", "Links"}],
    Cell[33667, 1312, 400, 13, 70, "Usage",
      CellTags->{"S0.1012", "Links"}],
    Cell[34070, 1327, 216, 8, 70, "Notes",
      CellTags->{"S0.1012", "Links"}],
    Cell[34289, 1337, 199, 7, 70, "Notes",
      CellTags->{"S0.1012", "Links"}],
    Cell[34491, 1346, 505, 21, 70, "Notes",
      CellTags->{"S0.1012", "Links"}],
    Cell[34999, 1369, 89, 1, 70, "Notes",
      CellTags->{"S0.1012", "Links"}]},
  "S0.1013"->{
    Cell[35125, 1375, 69, 1, 70, "ObjectName",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[35197, 1378, 336, 13, 70, "Usage",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[35536, 1393, 374, 14, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[35913, 1409, 332, 11, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[36248, 1422, 267, 7, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[36518, 1431, 476, 15, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[36997, 1448, 202, 7, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[37202, 1457, 304, 12, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[37509, 1471, 93, 1, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[37627, 1476, 80, 1, 70, "ExampleSection",
      CellTags->{"LinkWrite", "S0.1013"}],
    Cell[37710, 1479, 180, 6, 70, "ExampleSubsection",
      CellTags->{"LinkWrite", "S0.1013"}]},
  "LinkWrite"->{
    Cell[35125, 1375, 69, 1, 70, "ObjectName",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[35197, 1378, 336, 13, 70, "Usage",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[35536, 1393, 374, 14, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[35913, 1409, 332, 11, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[36248, 1422, 267, 7, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[36518, 1431, 476, 15, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[36997, 1448, 202, 7, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[37202, 1457, 304, 12, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[37509, 1471, 93, 1, 70, "Notes",
      CellTags->{"S0.1013", "LinkWrite"}],
    Cell[37627, 1476, 80, 1, 70, "ExampleSection",
      CellTags->{"LinkWrite", "S0.1013"}],
    Cell[37710, 1479, 180, 6, 70, "ExampleSubsection",
      CellTags->{"LinkWrite", "S0.1013"}]},
  "S0.1014"->{
    Cell[37939, 1491, 69, 1, 70, "ObjectName",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[38011, 1494, 365, 12, 70, "Usage",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[38379, 1508, 355, 13, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[38737, 1523, 295, 11, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[39035, 1536, 333, 11, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[39371, 1549, 297, 12, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[39671, 1563, 116, 3, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}]},
  "Uninstall"->{
    Cell[37939, 1491, 69, 1, 70, "ObjectName",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[38011, 1494, 365, 12, 70, "Usage",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[38379, 1508, 355, 13, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[38737, 1523, 295, 11, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[39035, 1536, 333, 11, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[39371, 1549, 297, 12, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}],
    Cell[39671, 1563, 116, 3, 70, "Notes",
      CellTags->{"S0.1014", "Uninstall"}]},
  "S0.1015"->{
    Cell[39824, 1571, 75, 1, 70, "ObjectName",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[39902, 1574, 344, 11, 70, "Usage",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[40249, 1587, 271, 10, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[40523, 1599, 240, 6, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[40766, 1607, 413, 14, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[41182, 1623, 205, 7, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[41390, 1632, 301, 12, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[41694, 1646, 96, 1, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}]},
  "$CurrentLink"->{
    Cell[39824, 1571, 75, 1, 70, "ObjectName",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[39902, 1574, 344, 11, 70, "Usage",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[40249, 1587, 271, 10, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[40523, 1599, 240, 6, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[40766, 1607, 413, 14, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[41182, 1623, 205, 7, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[41390, 1632, 301, 12, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}],
    Cell[41694, 1646, 96, 1, 70, "Notes",
      CellTags->{"S0.1015", "$CurrentLink"}]},
  "S0.1016"->{
    Cell[41827, 1652, 85, 1, 70, "ObjectName",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[41915, 1655, 273, 7, 70, "Usage",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[42191, 1664, 568, 22, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[42762, 1688, 210, 7, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[42975, 1697, 261, 9, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[43239, 1708, 101, 1, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}]},
  "$InstallationDate"->{
    Cell[41827, 1652, 85, 1, 70, "ObjectName",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[41915, 1655, 273, 7, 70, "Usage",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[42191, 1664, 568, 22, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[42762, 1688, 210, 7, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[42975, 1697, 261, 9, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}],
    Cell[43239, 1708, 101, 1, 70, "Notes",
      CellTags->{"S0.1016", "$InstallationDate"}]},
  "S0.1017"->{
    Cell[43377, 1714, 95, 1, 70, "ObjectName",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[43475, 1717, 270, 7, 70, "Usage",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[43748, 1726, 208, 5, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[43959, 1733, 109, 1, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[44071, 1736, 1101, 26, 70, "2ColumnTable",
      CellTags->{"$InstallationDirectory", "S0.1017"}],
    Cell[45175, 1764, 216, 7, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[45394, 1773, 409, 15, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[45806, 1790, 106, 1, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}]},
  "$InstallationDirectory"->{
    Cell[43377, 1714, 95, 1, 70, "ObjectName",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[43475, 1717, 270, 7, 70, "Usage",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[43748, 1726, 208, 5, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[43959, 1733, 109, 1, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[44071, 1736, 1101, 26, 70, "2ColumnTable",
      CellTags->{"$InstallationDirectory", "S0.1017"}],
    Cell[45175, 1764, 216, 7, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[45394, 1773, 409, 15, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}],
    Cell[45806, 1790, 106, 1, 70, "Notes",
      CellTags->{"S0.1017", "$InstallationDirectory"}]},
  "S0.1018"->{
    Cell[45949, 1796, 65, 1, 70, "ObjectName",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46017, 1799, 303, 12, 70, "Usage",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46323, 1813, 266, 10, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46592, 1825, 296, 10, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46891, 1837, 377, 15, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[47271, 1854, 91, 1, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}]},
  "$Linked"->{
    Cell[45949, 1796, 65, 1, 70, "ObjectName",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46017, 1799, 303, 12, 70, "Usage",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46323, 1813, 266, 10, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46592, 1825, 296, 10, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[46891, 1837, 377, 15, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}],
    Cell[47271, 1854, 91, 1, 70, "Notes",
      CellTags->{"S0.1018", "$Linked"}]},
  "S0.1019"->{
    Cell[47399, 1860, 73, 1, 70, "ObjectName",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[47475, 1863, 360, 12, 70, "Usage",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[47838, 1877, 353, 11, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48194, 1890, 263, 7, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48460, 1899, 204, 7, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48667, 1908, 301, 12, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48971, 1922, 95, 1, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}]},
  "$ParentLink"->{
    Cell[47399, 1860, 73, 1, 70, "ObjectName",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[47475, 1863, 360, 12, 70, "Usage",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[47838, 1877, 353, 11, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48194, 1890, 263, 7, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48460, 1899, 204, 7, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48667, 1908, 301, 12, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}],
    Cell[48971, 1922, 95, 1, 70, "Notes",
      CellTags->{"S0.1019", "$ParentLink"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.1001", 49698, 1942},
  {"Install", 51116, 1977},
  {"S0.1002", 52534, 2012},
  {"LinkClose", 53332, 2031},
  {"S0.1003", 54128, 2050},
  {"LinkConnect", 55542, 2083},
  {"S0.1004", 56952, 2116},
  {"LinkCreate", 57751, 2135},
  {"S0.1005", 58547, 2154},
  {"LinkInterrupt", 59285, 2171},
  {"S0.1006", 60017, 2188},
  {"LinkLaunch", 62139, 2237},
  {"S0.1007", 64258, 2286},
  {"LinkObject", 65165, 2307},
  {"S0.1008", 66069, 2328},
  {"LinkPatterns", 66802, 2345},
  {"S0.1009", 67530, 2362},
  {"LinkProtocol", 68002, 2373},
  {"S0.1010", 68469, 2384},
  {"LinkRead", 69447, 2407},
  {"S0.1011", 70424, 2430},
  {"LinkReadyQ", 71320, 2451},
  {"S0.1012", 72213, 2472},
  {"Links", 72724, 2485},
  {"S0.1013", 73237, 2498},
  {"LinkWrite", 74229, 2521},
  {"S0.1014", 75219, 2544},
  {"Uninstall", 75848, 2559},
  {"S0.1015", 76475, 2574},
  {"$CurrentLink", 77215, 2591},
  {"S0.1016", 77950, 2608},
  {"$InstallationDate", 78545, 2621},
  {"S0.1017", 79130, 2634},
  {"$InstallationDirectory", 79967, 2651},
  {"S0.1018", 80789, 2668},
  {"$Linked", 81316, 2681},
  {"S0.1019", 81843, 2694},
  {"$ParentLink", 82485, 2709}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 65, 1, 70, "ObjectName",
  CellTags->{"S0.1001", "Install"}],
Cell[1844, 56, 352, 11, 70, "Usage",
  CellTags->{"S0.1001", "Install"}],
Cell[2199, 69, 331, 9, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[2533, 80, 276, 9, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[2812, 91, 345, 13, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[3160, 106, 362, 13, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[3525, 121, 416, 14, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[3944, 137, 281, 10, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[4228, 149, 256, 8, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[4487, 159, 278, 8, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[4768, 169, 389, 9, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[5160, 180, 416, 11, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[5579, 193, 357, 10, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[5939, 205, 272, 7, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[6214, 214, 331, 11, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[6548, 227, 495, 21, 70, "Notes",
  CellTags->{"S0.1001", "Install"}],
Cell[7046, 250, 114, 3, 70, "Notes",
  CellTags->{"S0.1001", "Install"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7197, 258, 69, 1, 70, "ObjectName",
  CellTags->{"S0.1002", "LinkClose"}],
Cell[7269, 261, 244, 9, 70, "Usage",
  CellTags->{"S0.1002", "LinkClose"}],
Cell[7516, 272, 375, 14, 70, "Notes",
  CellTags->{"S0.1002", "LinkClose"}],
Cell[7894, 288, 231, 6, 70, "Notes",
  CellTags->{"S0.1002", "LinkClose"}],
Cell[8128, 296, 202, 7, 70, "Notes",
  CellTags->{"S0.1002", "LinkClose"}],
Cell[8333, 305, 236, 9, 70, "Notes",
  CellTags->{"S0.1002", "LinkClose"}],
Cell[8572, 316, 93, 1, 70, "Notes",
  CellTags->{"S0.1002", "LinkClose"}],

Cell[CellGroupData[{
Cell[8690, 321, 80, 1, 70, "ExampleSection",
  CellTags->{"LinkClose", "S0.1002"}],
Cell[8773, 324, 180, 6, 70, "ExampleSubsection",
  CellTags->{"LinkClose", "S0.1002"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9002, 336, 73, 1, 70, "ObjectName",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[9078, 339, 272, 9, 70, "Usage",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[9353, 350, 327, 9, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[9683, 361, 185, 5, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[9871, 368, 221, 7, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[10095, 377, 212, 8, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[10310, 387, 334, 10, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[10647, 399, 313, 10, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[10963, 411, 324, 9, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[11290, 422, 406, 13, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[11699, 437, 280, 8, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[11982, 447, 282, 9, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[12267, 458, 304, 8, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[12574, 468, 204, 7, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[12781, 477, 307, 12, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}],
Cell[13091, 491, 95, 1, 70, "Notes",
  CellTags->{"S0.1003", "LinkConnect"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13223, 497, 71, 1, 70, "ObjectName",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[13297, 500, 472, 14, 70, "Usage",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[13772, 516, 210, 8, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[13985, 526, 332, 10, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[14320, 538, 230, 6, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[14553, 546, 280, 9, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[14836, 557, 203, 7, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[15042, 566, 307, 12, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}],
Cell[15352, 580, 94, 1, 70, "Notes",
  CellTags->{"S0.1004", "LinkCreate"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15483, 586, 77, 1, 70, "ObjectName",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[15563, 589, 305, 9, 70, "Usage",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[15871, 600, 381, 14, 70, "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[16255, 616, 170, 4, 70, "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[16428, 622, 276, 7, 70, "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[16707, 631, 207, 7, 70, "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[16917, 640, 240, 9, 70, "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}],
Cell[17160, 651, 97, 1, 70, "Notes",
  CellTags->{"S0.1005", "LinkInterrupt"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17294, 657, 71, 1, 70, "ObjectName",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[17368, 660, 314, 11, 70, "Usage",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[17685, 673, 322, 11, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[18010, 686, 326, 9, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[18339, 697, 328, 9, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[18670, 708, 222, 7, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[18895, 717, 210, 8, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[19108, 727, 230, 6, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[19341, 735, 280, 9, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[19624, 746, 203, 7, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[19830, 755, 372, 15, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],
Cell[20205, 772, 94, 1, 70, "Notes",
  CellTags->{"S0.1006", "LinkLaunch"}],

Cell[CellGroupData[{
Cell[20324, 777, 81, 1, 70, "ExampleSection",
  CellTags->{"LinkLaunch", "S0.1006"}],
Cell[20408, 780, 361, 9, 70, "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[CellGroupData[{
Cell[20794, 793, 117, 2, 70, "Input",
  CellTags->{"LinkLaunch", "S0.1006"}],
Cell[20914, 797, 103, 2, 70, "Output",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Open  ]],
Cell[21032, 802, 258, 5, 70, "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[CellGroupData[{
Cell[21315, 811, 95, 2, 70, "Input",
  CellTags->{"LinkLaunch", "S0.1006"}],
Cell[21413, 815, 106, 2, 70, "Output",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Open  ]],
Cell[21534, 820, 348, 8, 70, "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],

Cell[CellGroupData[{
Cell[21907, 832, 160, 5, 70, "Input",
  CellTags->{"LinkLaunch", "S0.1006"}],
Cell[22070, 839, 104, 2, 70, "Output",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Open  ]],
Cell[22189, 844, 109, 1, 70, "ExampleText",
  CellTags->{"LinkLaunch", "S0.1006"}],
Cell[22301, 847, 96, 2, 70, "Input",
  CellTags->{"LinkLaunch", "S0.1006"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22446, 855, 71, 1, 70, "ObjectName",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[22520, 858, 478, 17, 70, "Usage",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[23001, 877, 424, 17, 70, "Notes",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[23428, 896, 200, 5, 70, "Notes",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[23631, 903, 302, 10, 70, "Notes",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[23936, 915, 331, 11, 70, "Notes",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[24270, 928, 303, 12, 70, "Notes",
  CellTags->{"S0.1007", "LinkObject"}],
Cell[24576, 942, 94, 1, 70, "Notes",
  CellTags->{"S0.1007", "LinkObject"}],

Cell[CellGroupData[{
Cell[24695, 947, 81, 1, 70, "ExampleSection",
  CellTags->{"LinkObject", "S0.1007"}],
Cell[24779, 950, 181, 6, 70, "ExampleSubsection",
  CellTags->{"LinkObject", "S0.1007"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25009, 962, 75, 1, 70, "ObjectName",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[25087, 965, 370, 10, 70, "Usage",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[25460, 977, 275, 8, 70, "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[25738, 987, 335, 9, 70, "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[26076, 998, 362, 14, 70, "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[26441, 1014, 206, 7, 70, "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[26650, 1023, 170, 6, 70, "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}],
Cell[26823, 1031, 96, 1, 70, "Notes",
  CellTags->{"S0.1008", "LinkPatterns"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26956, 1037, 75, 1, 70, "ObjectName",
  CellTags->{"S0.1009", "LinkProtocol"}],
Cell[27034, 1040, 423, 14, 70, "Usage",
  CellTags->{"S0.1009", "LinkProtocol"}],
Cell[27460, 1056, 374, 13, 70, "Notes",
  CellTags->{"S0.1009", "LinkProtocol"}],
Cell[27837, 1071, 205, 7, 70, "Notes",
  CellTags->{"S0.1009", "LinkProtocol"}],
Cell[28045, 1080, 119, 3, 70, "Notes",
  CellTags->{"S0.1009", "LinkProtocol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[28201, 1088, 67, 1, 70, "ObjectName",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[28271, 1091, 509, 17, 70, "Usage",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[28783, 1110, 373, 14, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[29159, 1126, 196, 5, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[29358, 1133, 245, 7, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[29606, 1142, 252, 7, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[29861, 1151, 201, 7, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[30065, 1160, 298, 12, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],
Cell[30366, 1174, 92, 1, 70, "Notes",
  CellTags->{"S0.1010", "LinkRead"}],

Cell[CellGroupData[{
Cell[30483, 1179, 79, 1, 70, "ExampleSection",
  CellTags->{"LinkRead", "S0.1010"}],
Cell[30565, 1182, 179, 6, 70, "ExampleSubsection",
  CellTags->{"LinkRead", "S0.1010"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30793, 1194, 71, 1, 70, "ObjectName",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[30867, 1197, 301, 9, 70, "Usage",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[31171, 1208, 375, 14, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[31549, 1224, 394, 14, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[31946, 1240, 461, 17, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[32410, 1259, 296, 8, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[32709, 1269, 244, 9, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[32956, 1280, 203, 7, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[33162, 1289, 307, 12, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}],
Cell[33472, 1303, 94, 1, 70, "Notes",
  CellTags->{"S0.1011", "LinkReadyQ"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[33603, 1309, 61, 1, 70, "ObjectName",
  CellTags->{"S0.1012", "Links"}],
Cell[33667, 1312, 400, 13, 70, "Usage",
  CellTags->{"S0.1012", "Links"}],
Cell[34070, 1327, 216, 8, 70, "Notes",
  CellTags->{"S0.1012", "Links"}],
Cell[34289, 1337, 199, 7, 70, "Notes",
  CellTags->{"S0.1012", "Links"}],
Cell[34491, 1346, 505, 21, 70, "Notes",
  CellTags->{"S0.1012", "Links"}],
Cell[34999, 1369, 89, 1, 70, "Notes",
  CellTags->{"S0.1012", "Links"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35125, 1375, 69, 1, 70, "ObjectName",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[35197, 1378, 336, 13, 70, "Usage",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[35536, 1393, 374, 14, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[35913, 1409, 332, 11, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[36248, 1422, 267, 7, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[36518, 1431, 476, 15, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[36997, 1448, 202, 7, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[37202, 1457, 304, 12, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],
Cell[37509, 1471, 93, 1, 70, "Notes",
  CellTags->{"S0.1013", "LinkWrite"}],

Cell[CellGroupData[{
Cell[37627, 1476, 80, 1, 70, "ExampleSection",
  CellTags->{"LinkWrite", "S0.1013"}],
Cell[37710, 1479, 180, 6, 70, "ExampleSubsection",
  CellTags->{"LinkWrite", "S0.1013"}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37939, 1491, 69, 1, 70, "ObjectName",
  CellTags->{"S0.1014", "Uninstall"}],
Cell[38011, 1494, 365, 12, 70, "Usage",
  CellTags->{"S0.1014", "Uninstall"}],
Cell[38379, 1508, 355, 13, 70, "Notes",
  CellTags->{"S0.1014", "Uninstall"}],
Cell[38737, 1523, 295, 11, 70, "Notes",
  CellTags->{"S0.1014", "Uninstall"}],
Cell[39035, 1536, 333, 11, 70, "Notes",
  CellTags->{"S0.1014", "Uninstall"}],
Cell[39371, 1549, 297, 12, 70, "Notes",
  CellTags->{"S0.1014", "Uninstall"}],
Cell[39671, 1563, 116, 3, 70, "Notes",
  CellTags->{"S0.1014", "Uninstall"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39824, 1571, 75, 1, 70, "ObjectName",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[39902, 1574, 344, 11, 70, "Usage",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[40249, 1587, 271, 10, 70, "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[40523, 1599, 240, 6, 70, "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[40766, 1607, 413, 14, 70, "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[41182, 1623, 205, 7, 70, "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[41390, 1632, 301, 12, 70, "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}],
Cell[41694, 1646, 96, 1, 70, "Notes",
  CellTags->{"S0.1015", "$CurrentLink"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41827, 1652, 85, 1, 70, "ObjectName",
  CellTags->{"S0.1016", "$InstallationDate"}],
Cell[41915, 1655, 273, 7, 70, "Usage",
  CellTags->{"S0.1016", "$InstallationDate"}],
Cell[42191, 1664, 568, 22, 70, "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}],
Cell[42762, 1688, 210, 7, 70, "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}],
Cell[42975, 1697, 261, 9, 70, "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}],
Cell[43239, 1708, 101, 1, 70, "Notes",
  CellTags->{"S0.1016", "$InstallationDate"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[43377, 1714, 95, 1, 70, "ObjectName",
  CellTags->{"S0.1017", "$InstallationDirectory"}],
Cell[43475, 1717, 270, 7, 70, "Usage",
  CellTags->{"S0.1017", "$InstallationDirectory"}],
Cell[43748, 1726, 208, 5, 70, "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],
Cell[43959, 1733, 109, 1, 70, "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],
Cell[44071, 1736, 1101, 26, 70, "2ColumnTable",
  CellTags->{"$InstallationDirectory", "S0.1017"}],
Cell[45175, 1764, 216, 7, 70, "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],
Cell[45394, 1773, 409, 15, 70, "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}],
Cell[45806, 1790, 106, 1, 70, "Notes",
  CellTags->{"S0.1017", "$InstallationDirectory"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[45949, 1796, 65, 1, 70, "ObjectName",
  CellTags->{"S0.1018", "$Linked"}],
Cell[46017, 1799, 303, 12, 70, "Usage",
  CellTags->{"S0.1018", "$Linked"}],
Cell[46323, 1813, 266, 10, 70, "Notes",
  CellTags->{"S0.1018", "$Linked"}],
Cell[46592, 1825, 296, 10, 70, "Notes",
  CellTags->{"S0.1018", "$Linked"}],
Cell[46891, 1837, 377, 15, 70, "Notes",
  CellTags->{"S0.1018", "$Linked"}],
Cell[47271, 1854, 91, 1, 70, "Notes",
  CellTags->{"S0.1018", "$Linked"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47399, 1860, 73, 1, 70, "ObjectName",
  CellTags->{"S0.1019", "$ParentLink"}],
Cell[47475, 1863, 360, 12, 70, "Usage",
  CellTags->{"S0.1019", "$ParentLink"}],
Cell[47838, 1877, 353, 11, 70, "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],
Cell[48194, 1890, 263, 7, 70, "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],
Cell[48460, 1899, 204, 7, 70, "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],
Cell[48667, 1908, 301, 12, 70, "Notes",
  CellTags->{"S0.1019", "$ParentLink"}],
Cell[48971, 1922, 95, 1, 70, "Notes",
  CellTags->{"S0.1019", "$ParentLink"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

