(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7066,        168]*)
(*NotebookOutlinePosition[      9653,        255]*)
(*  CellTagsIndexPosition[      9361,        239]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["About the Author", "Section",
  CellTags->{"S0.1.1", "1.1"}],

Cell[TextData[{
  "Stephen Wolfram is the creator of ",
  StyleBox["Mathematica", "TI"],
  ", and a well\[Hyphen]known scientist. He is widely regarded as the most \
important innovator in technical computing today, as well as one of the \
world's most original research scientists. "
}], "Text",
  CellTags->{"S0.1.1", "1.2"}],

Cell["\<\
Born in London in 1959, he was educated at Eton, Oxford and \
Caltech. He published his first scientific paper at the age of fifteen, and \
had received his PhD in theoretical physics from Caltech by the age of \
twenty. Wolfram's early scientific work was mainly in high\[Hyphen]energy \
physics, quantum field theory and cosmology, and included several \
now\[Hyphen]classic results. Having started to use computers in 1973, Wolfram \
rapidly became a leader in the emerging field of scientific computing, and in \
1979 he began the construction of SMP\[LongDash]the first modern computer \
algebra system\[LongDash]which he released commercially in 1981.  \
\>", \
"Text",
  CellTags->{"S0.1.1", "1.3"}],

Cell["\<\
In recognition of his early work in physics and computing, Wolfram \
became in 1981 the youngest recipient of a MacArthur Prize Fellowship. Late \
in 1981, Wolfram then set out on an ambitious new direction in science: to \
develop a general theory of complexity in nature. Wolfram's key idea was to \
use computer experiments to study the behavior of simple computer programs \
known as cellular automata. And in 1982 he made the first in a series of \
startling discoveries about the origins of complexity. The publication of \
Wolfram's papers on cellular automata led to a major shift in scientific \
thinking, and laid the groundwork for a new field of science that Wolfram \
named \[OpenCurlyDoubleQuote]complex systems \
research\[CloseCurlyDoubleQuote]. \
\>", "Text",
  CellTags->{"S0.1.1", "1.4"}],

Cell["\<\
Through the mid\[Hyphen]1980s, Wolfram continued his work on \
complexity, discovering a number of fundamental connections between \
computation and nature, and inventing such concepts as computational \
irreducibility. Wolfram's work led to a wide range of \
applications\[LongDash]and provided the main scientific foundations for the \
popular movements known as complexity theory and artificial life. Wolfram \
himself used his ideas to develop a new randomness generation system and a \
new approach to computational fluid dynamics\[LongDash]both of which are now \
in widespread use. \
\>", "Text",
  CellTags->{"S0.1.1", "1.5"}],

Cell["\<\
Following his scientific work on complex systems research, Wolfram \
in 1986 founded the first research center and first journal in the field. \
Then, after a highly successful career in academia\[LongDash]first at \
Caltech, then at the Institute for Advanced Study in Princeton, and finally \
as Professor of Physics, Mathematics and Computer Science at the University \
of Illinois\[LongDash]Wolfram launched Wolfram Research, Inc. \
\>", "Text",
  CellTags->{"S0.1.1", "1.6"}],

Cell[TextData[{
  "Wolfram began the development of ",
  StyleBox["Mathematica", "TI"],
  " in late 1986. The first version of ",
  StyleBox["Mathematica", "TI"],
  " was released on June 23, 1988, and was immediately hailed as a major \
advance in computing. In the years that followed, the popularity of ",
  StyleBox["Mathematica", "TI"],
  " grew rapidly, and Wolfram Research became established as a world leader \
in the software industry, widely recognized for excellence in both technology \
and business. Wolfram has been president and CEO of Wolfram Research since \
its inception, and continues to be personally responsible for the overall \
design of its core technology. "
}], "Text",
  CellTags->{"S0.1.1", "1.7"}],

Cell[TextData[{
  "Following the release of ",
  StyleBox["Mathematica", "TI"],
  " Version 2 in 1991, Wolfram began to divide his time between ",
  StyleBox["Mathematica", "TI"],
  " development and scientific research. Building on his work from the mid\
\[Hyphen]1980s, and now with ",
  StyleBox["Mathematica", "TI"],
  " as a tool, Wolfram made a rapid succession of major new discoveries. By \
the mid\[Hyphen]1990s his discoveries led him to develop a fundamentally new \
conceptual framework, which he then spent the remainder of the 1990s applying \
not only to new kinds of questions, but also to many existing foundational \
problems in physics, biology, computer science, mathematics and several other \
fields.  "
}], "Text",
  CellTags->{"S0.1.1", "1.8"}],

Cell[TextData[{
  "After more than ten years of highly concentrated work, Wolfram finally \
described his achievements in his 1200\[Hyphen]page book ",
  StyleBox["A New Kind of Science", "TI"],
  ". Released on May 14, 2002, the book was widely acclaimed and immediately \
became a bestseller. Its publication has been seen as initiating a paradigm \
shift of historic importance in science. "
}], "Text",
  CellTags->{"S0.1.1", "1.9"}],

Cell["\<\
In addition to leading Wolfram Research to break new ground with \
innovative technology, Wolfram is now developing a series of research and \
educational initiatives in the science he has created. \
\>", "Text",
  CellTags->{"S0.1.1", "1.10"}]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 94}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.1.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.1.1", "1.1"}],
    Cell[1845, 56, 327, 7, 70, "Text",
      CellTags->{"S0.1.1", "1.2"}],
    Cell[2175, 65, 716, 12, 136, "Text",
      CellTags->{"S0.1.1", "1.3"}],
    Cell[2894, 79, 817, 13, 70, "Text",
      CellTags->{"S0.1.1", "1.4"}],
    Cell[3714, 94, 644, 11, 120, "Text",
      CellTags->{"S0.1.1", "1.5"}],
    Cell[4361, 107, 490, 8, 88, "Text",
      CellTags->{"S0.1.1", "1.6"}],
    Cell[4854, 117, 728, 14, 120, "Text",
      CellTags->{"S0.1.1", "1.7"}],
    Cell[5585, 133, 768, 15, 136, "Text",
      CellTags->{"S0.1.1", "1.8"}],
    Cell[6356, 150, 437, 8, 88, "Text",
      CellTags->{"S0.1.1", "1.9"}],
    Cell[6796, 160, 254, 5, 56, "Text",
      CellTags->{"S0.1.1", "1.10"}]},
  "1.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.1.1", "1.1"}]},
  "1.2"->{
    Cell[1845, 56, 327, 7, 70, "Text",
      CellTags->{"S0.1.1", "1.2"}]},
  "1.3"->{
    Cell[2175, 65, 716, 12, 136, "Text",
      CellTags->{"S0.1.1", "1.3"}]},
  "1.4"->{
    Cell[2894, 79, 817, 13, 70, "Text",
      CellTags->{"S0.1.1", "1.4"}]},
  "1.5"->{
    Cell[3714, 94, 644, 11, 120, "Text",
      CellTags->{"S0.1.1", "1.5"}]},
  "1.6"->{
    Cell[4361, 107, 490, 8, 88, "Text",
      CellTags->{"S0.1.1", "1.6"}]},
  "1.7"->{
    Cell[4854, 117, 728, 14, 120, "Text",
      CellTags->{"S0.1.1", "1.7"}]},
  "1.8"->{
    Cell[5585, 133, 768, 15, 136, "Text",
      CellTags->{"S0.1.1", "1.8"}]},
  "1.9"->{
    Cell[6356, 150, 437, 8, 88, "Text",
      CellTags->{"S0.1.1", "1.9"}]},
  "1.10"->{
    Cell[6796, 160, 254, 5, 56, "Text",
      CellTags->{"S0.1.1", "1.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.1.1", 7680, 184},
  {"1.1", 8459, 205},
  {"1.2", 8548, 208},
  {"1.3", 8635, 211},
  {"1.4", 8724, 214},
  {"1.5", 8812, 217},
  {"1.6", 8901, 220},
  {"1.7", 8989, 223},
  {"1.8", 9079, 226},
  {"1.9", 9169, 229},
  {"1.10", 9258, 232}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 66, 1, 65, "Section",
  CellTags->{"S0.1.1", "1.1"}],
Cell[1845, 56, 327, 7, 70, "Text",
  CellTags->{"S0.1.1", "1.2"}],
Cell[2175, 65, 716, 12, 136, "Text",
  CellTags->{"S0.1.1", "1.3"}],
Cell[2894, 79, 817, 13, 70, "Text",
  CellTags->{"S0.1.1", "1.4"}],
Cell[3714, 94, 644, 11, 120, "Text",
  CellTags->{"S0.1.1", "1.5"}],
Cell[4361, 107, 490, 8, 88, "Text",
  CellTags->{"S0.1.1", "1.6"}],
Cell[4854, 117, 728, 14, 120, "Text",
  CellTags->{"S0.1.1", "1.7"}],
Cell[5585, 133, 768, 15, 136, "Text",
  CellTags->{"S0.1.1", "1.8"}],
Cell[6356, 150, 437, 8, 88, "Text",
  CellTags->{"S0.1.1", "1.9"}],
Cell[6796, 160, 254, 5, 56, "Text",
  CellTags->{"S0.1.1", "1.10"}]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

