(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15944,        649]*)
(*NotebookOutlinePosition[     32880,       1182]*)
(*  CellTagsIndexPosition[     30645,       1087]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New in Version 5", "Section",
  CellTags->{"S0.3.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " Version 5 introduces important extensions to the ",
  StyleBox["Mathematica", "TI"],
  " system, especially in scope and scalability of numeric and symbolic \
computation. Building on the core language and extensive algorithm knowledge \
base of ",
  StyleBox["Mathematica", "TI"],
  ", Version 5 introduces a new generation of advanced algorithms for a wide \
range of numeric and symbolic operations.     "
}], "Text",
  CellTags->{"S0.3.1", "1.2"}],

Cell[CellGroupData[{

Cell["Numerical Computation", "Subsection",
  CellTags->{"S0.3.2", "1.3"}],

Cell["\<\
\[FilledSmallSquare] Major optimization of dense numerical linear \
algebra. \
\>", "Notes",
  CellTags->{"S0.3.2", "1.4"}],

Cell["\<\
\[FilledSmallSquare] New optimized sparse numerical linear algebra. \
\
\>", "Notes",
  CellTags->{"S0.3.2", "1.5"}],

Cell["\<\
\[FilledSmallSquare] Support for optimized \
arbitrary\[Hyphen]precision linear algebra. \
\>", "Notes",
  CellTags->{"S0.3.2", "1.6"}],

Cell["\<\
\[FilledSmallSquare] Generalized eigenvalues and singular value \
decomposition. \
\>", "Notes",
  CellTags->{"S0.3.2", "1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["LinearSolveFunction",
    ButtonStyle->"RefGuideLink"],
  " for repeated linear\[Hyphen]system solving. "
}], "Notes",
  CellTags->{"S0.3.2", "1.8"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          "TI"], TraditionalForm]], "InlineFormula"],
  " norms for vectors and matrices. "
}], "Notes",
  CellTags->{"S0.3.2", "1.9"}],

Cell[TextData[{
  "\[FilledSmallSquare] Built\[Hyphen]in ",
  ButtonBox["MatrixRank",
    ButtonStyle->"RefGuideLink"],
  " for exact and approximate matrices. "
}], "Notes",
  CellTags->{"S0.3.2", "1.10"}],

Cell["\<\
\[FilledSmallSquare] Support for large\[Hyphen]scale linear \
programming, with interior point methods. \
\>", "Notes",
  CellTags->{"S0.3.2", "1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] New methods and array variable support in ",
  ButtonBox["FindRoot",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FindMinimum",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.12"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FindFit",
    ButtonStyle->"RefGuideLink"],
  " for full nonlinear curve fitting. "
}], "Notes",
  CellTags->{"S0.3.2", "1.13"}],

Cell[TextData[{
  "\[FilledSmallSquare] Constrained global optimization with ",
  ButtonBox["NMinimize",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional PDEs in ",
  ButtonBox["NDSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.15"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for differential\[Hyphen]algebraic equations \
in ",
  ButtonBox["NDSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.16"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for vector and array\[Hyphen]valued functions \
in ",
  ButtonBox["NDSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] Highly extensive collection of automatically \
accessible algorithms in ",
  ButtonBox["NDSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.18"}],

Cell["\<\
\[FilledSmallSquare] Finer precision and accuracy control for \
arbitrary\[Hyphen]precision numbers. \
\>", "Notes",
  CellTags->{"S0.3.2", "1.19"}],

Cell["\<\
\[FilledSmallSquare] Higher\[Hyphen]efficiency big number \
arithmetic, including processor\[Hyphen]specific optimization. \
\>", "Notes",\

  CellTags->{"S0.3.2", "1.20"}],

Cell[TextData[{
  "\[FilledSmallSquare] Enhanced algorithms for number\[Hyphen]theoretical \
operations including ",
  ButtonBox["GCD",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["FactorInteger",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.2", "1.21"}],

Cell["\<\
\[FilledSmallSquare] Direct support for high\[Hyphen]performance \
basic statistics functions. \
\>", "Notes",
  CellTags->{"S0.3.2", "1.22"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Computation", "Subsection",
  CellTags->{"S0.3.3", "1.23"}],

Cell[TextData[{
  "\[FilledSmallSquare] Solutions to mixed systems of equations and \
inequalities in ",
  ButtonBox["Reduce",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.3", "1.24"}],

Cell["\<\
\[FilledSmallSquare] Complete solving of polynomial systems over \
real or complex numbers. \
\>", "Notes",
  CellTags->{"S0.3.3", "1.25"}],

Cell["\<\
\[FilledSmallSquare] Solving large classes of Diophantine \
equations. \
\>", "Notes",
  CellTags->{"S0.3.3", "1.26"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["ForAll",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Exists",
    ButtonStyle->"RefGuideLink"],
  " quantifiers and quantifier elimination. "
}], "Notes",
  CellTags->{"S0.3.3", "1.27"}],

Cell["\<\
\[FilledSmallSquare] Representation of discrete and continuous \
algebraic and transcendental solution sets. \
\>", "Notes",
  CellTags->{"S0.3.3", "1.28"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["FindInstance",
    ButtonStyle->"RefGuideLink"],
  " for finding instances of solutions over different domains. "
}], "Notes",
  CellTags->{"S0.3.3", "1.29"}],

Cell["\<\
\[FilledSmallSquare] Exact constrained minimization over real and \
integer domains. \
\>", "Notes",
  CellTags->{"S0.3.3", "1.30"}],

Cell[TextData[{
  "\[FilledSmallSquare] Integrated support for assumptions using ",
  ButtonBox["Assuming",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Refine",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.3", "1.31"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["RSolve",
    ButtonStyle->"RefGuideLink"],
  " for solving recurrence equations. "
}], "Notes",
  CellTags->{"S0.3.3", "1.32"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for nonlinear, partial and ",
  Cell[BoxData[
      FormBox[
        StyleBox["q",
          "TI"], TraditionalForm]], "InlineFormula"],
  " difference equations and systems. "
}], "Notes",
  CellTags->{"S0.3.3", "1.33"}],

Cell["\<\
\[FilledSmallSquare] Full solutions to systems of rational ordinary \
differential equations. \
\>", "Notes",
  CellTags->{"S0.3.3", "1.34"}],

Cell["\<\
\[FilledSmallSquare] Support for differential\[Hyphen]algebraic \
equations. \
\>", "Notes",
  CellTags->{"S0.3.3", "1.35"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["CoefficientArrays",
    ButtonStyle->"RefGuideLink"],
  " for converting systems of equations to tensors. "
}], "Notes",
  CellTags->{"S0.3.3", "1.36"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programming and Core System", "Subsection",
  CellTags->{"S0.3.4", "1.37"}],

Cell["\<\
\[FilledSmallSquare] Integrated language support for sparse arrays. \
\
\>", "Notes",
  CellTags->{"S0.3.4", "1.38"}],

Cell[TextData[{
  "\[FilledSmallSquare] New list programming with ",
  ButtonBox["Sow",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Reap",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.4", "1.39"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["EvaluationMonitor",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["StepMonitor",
    ButtonStyle->"RefGuideLink"],
  " for algorithm  monitoring. "
}], "Notes",
  CellTags->{"S0.3.4", "1.40"}],

Cell[TextData[{
  "\[FilledSmallSquare] Enhanced timing measurement, including ",
  ButtonBox["AbsoluteTiming",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.4", "1.41"}],

Cell[TextData[{
  "\[FilledSmallSquare] Major performance enhancements for ",
  StyleBox["MathLink", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.3.4", "1.42"}],

Cell["\<\
\[FilledSmallSquare] Optimization for 64\[Hyphen]bit operating \
systems and architectures. \
\>", "Notes",
  CellTags->{"S0.3.4", "1.43"}],

Cell["\<\
\[FilledSmallSquare] Support for computations in full \
64\[Hyphen]bit address spaces. \
\>", "Notes",
  CellTags->{"S0.3.4", "1.44"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interfaces", "Subsection",
  CellTags->{"S0.3.5", "1.45"}],

Cell["\<\
\[FilledSmallSquare] Support for more than 50 import and export \
formats. \
\>", "Notes",
  CellTags->{"S0.3.5", "1.46"}],

Cell["\<\
\[FilledSmallSquare] High\[Hyphen]efficiency import and export of \
tabular data. \
\>", "Notes",
  CellTags->{"S0.3.5", "1.47"}],

Cell["\<\
\[FilledSmallSquare] PNG, SVG and DICOM graphics and imaging \
formats. \
\>", "Notes",
  CellTags->{"S0.3.5", "1.48"}],

Cell["\<\
\[FilledSmallSquare] Import and export of sparse matrix formats. \
\
\>", "Notes",
  CellTags->{"S0.3.5", "1.49"}],

Cell["\<\
\[FilledSmallSquare] MPS linear programming format. \
\>", "Notes",
  CellTags->{"S0.3.5", "1.50"}],

Cell["\<\
\[FilledSmallSquare] Cascading style sheets and XHTML for notebook \
exporting. \
\>", "Notes",
  CellTags->{"S0.3.5", "1.51"}],

Cell[TextData[{
  "\[FilledSmallSquare] Preview version of ",
  StyleBox[".NET/Link", "TI"],
  " for integration with .NET. "
}], "Notes",
  CellTags->{"S0.3.5", "1.52"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Interface", "Subsection",
  CellTags->{"S0.3.6", "1.53"}],

Cell["\<\
\[FilledSmallSquare] Enhanced Help Browser design. \
\>", "Notes",
  CellTags->{"S0.3.6", "1.54"}],

Cell["\<\
\[FilledSmallSquare] Automatic copy/paste switching for Windows. \
\
\>", "Notes",
  CellTags->{"S0.3.6", "1.55"}],

Cell["\<\
\[FilledSmallSquare] Enhanced support for slide show presentation. \
\
\>", "Notes",
  CellTags->{"S0.3.6", "1.56"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AuthorTools", "TI"],
  " support for notebook diffs. "
}], "Notes",
  CellTags->{"S0.3.6", "1.57"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Add\[Hyphen]on Packages", "Subsection",
  CellTags->{"S0.3.7", "1.58"}],

Cell["\<\
\[FilledSmallSquare] Statistical plots and graphics. \
\>", "Notes",
  CellTags->{"S0.3.7", "1.59"}],

Cell["\[FilledSmallSquare] Algebraic number fields. ", "Notes",
  CellTags->{"S0.3.7", "1.60"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["New in Versions 4.1 and 4.2", "Subsection",
  CellTags->{"S0.3.8", "1.61"}],

Cell["\<\
\[FilledSmallSquare] Enhanced pattern matching of sequence objects. \
\
\>", "Notes",
  CellTags->{"S0.3.8", "1.62"}],

Cell[TextData[{
  "\[FilledSmallSquare] Enhanced optimizer for built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " compiler. "
}], "Notes",
  CellTags->{"S0.3.8", "1.63"}],

Cell["\<\
\[FilledSmallSquare] Enhanced continued fraction computation. \
\
\>", "Notes",
  CellTags->{"S0.3.8", "1.64"}],

Cell[TextData[{
  "\[FilledSmallSquare] Greatly enhanced ",
  ButtonBox["DSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.8", "1.65"}],

Cell[TextData[{
  "\[FilledSmallSquare] Additional ",
  ButtonBox["TraditionalForm",
    ButtonStyle->"RefGuideLink"],
  " formats. "
}], "Notes",
  CellTags->{"S0.3.8", "1.66"}],

Cell["\<\
\[FilledSmallSquare] Efficiency increases for multivariate \
polynomial operations. \
\>", "Notes",
  CellTags->{"S0.3.8", "1.67"}],

Cell["\<\
\[FilledSmallSquare] Support for import and export of DXF, STL, \
FITS and STDS data formats. \
\>", "Notes",
  CellTags->{"S0.3.8", "1.68"}],

Cell["\<\
\[FilledSmallSquare] Full support for CSV format import and export. \
\
\>", "Notes",
  CellTags->{"S0.3.8", "1.69"}],

Cell["\<\
\[FilledSmallSquare] Support for UTF character encodings. \
\>", \
"Notes",
  CellTags->{"S0.3.8", "1.70"}],

Cell["\<\
\[FilledSmallSquare] Extensive support for XML, including \
SymbolicXML subsystem and NotebookML. \
\>", "Notes",
  CellTags->{"S0.3.8", "1.71"}],

Cell[TextData[{
  "\[FilledSmallSquare] Native support for evaluation and formatting of ",
  ButtonBox["Nand",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Nor",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.3.8", "1.72"}],

Cell[TextData[{
  "\[FilledSmallSquare] High\[Hyphen]efficiency ",
  ButtonBox["CellularAutomaton",
    ButtonStyle->"RefGuideLink"],
  " function. "
}], "Notes",
  CellTags->{"S0.3.8", "1.73"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["J/Link", "TI"],
  " ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]based Java capabilities. "
}], "Notes",
  CellTags->{"S0.3.8", "1.74"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["MathMLForm",
    ButtonStyle->"RefGuideLink"],
  " and extended MathML support. "
}], "Notes",
  CellTags->{"S0.3.8", "1.75"}],

Cell[TextData[{
  "\[FilledSmallSquare] Extended simplification of ",
  ButtonBox["Floor",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Erf",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ProductLog",
    ButtonStyle->"RefGuideLink"],
  " and related functions. "
}], "Notes",
  CellTags->{"S0.3.8", "1.76"}],

Cell["\<\
\[FilledSmallSquare] Integration over regions defined by \
inequalities. \
\>", "Notes",
  CellTags->{"S0.3.8", "1.77"}],

Cell["\<\
\[FilledSmallSquare] Integration of piecewise functions. \
\>", \
"Notes",
  CellTags->{"S0.3.8", "1.78"}],

Cell["\<\
\[FilledSmallSquare] Standard package for visualization of regions \
defined by inequalities. \
\>", "Notes",
  CellTags->{"S0.3.8", "1.79"}],

Cell["\<\
\[FilledSmallSquare] ANOVA standard add\[Hyphen]on package. \
\>", \
"Notes",
  CellTags->{"S0.3.8", "1.80"}],

Cell[TextData[{
  "\[FilledSmallSquare] Enhanced ",
  StyleBox["Combinatorica", "TI"],
  " add\[Hyphen]on package. "
}], "Notes",
  CellTags->{"S0.3.8", "1.81"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["AuthorTools", "TI"],
  " notebook authoring environment. "
}], "Notes",
  CellTags->{"S0.3.8", "1.82"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.3.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.3.1", "1.1"}],
    Cell[1845, 56, 504, 11, 70, "Text",
      CellTags->{"S0.3.1", "1.2"}]},
  "1.1"->{
    Cell[1776, 53, 66, 1, 65, "Section",
      CellTags->{"S0.3.1", "1.1"}]},
  "1.2"->{
    Cell[1845, 56, 504, 11, 70, "Text",
      CellTags->{"S0.3.1", "1.2"}]},
  "S0.3.2"->{
    Cell[2374, 71, 74, 1, 70, "Subsection",
      CellTags->{"S0.3.2", "1.3"}],
    Cell[2451, 74, 133, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.4"}],
    Cell[2587, 80, 126, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.5"}],
    Cell[2716, 86, 145, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.6"}],
    Cell[2864, 92, 137, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.7"}],
    Cell[3004, 98, 205, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.8"}],
    Cell[3212, 106, 231, 8, 70, "Notes",
      CellTags->{"S0.3.2", "1.9"}],
    Cell[3446, 116, 206, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.10"}],
    Cell[3655, 124, 161, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.11"}],
    Cell[3819, 130, 266, 9, 70, "Notes",
      CellTags->{"S0.3.2", "1.12"}],
    Cell[4088, 141, 184, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.13"}],
    Cell[4275, 149, 190, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.14"}],
    Cell[4468, 157, 305, 11, 70, "Notes",
      CellTags->{"S0.3.2", "1.15"}],
    Cell[4776, 170, 209, 7, 70, "Notes",
      CellTags->{"S0.3.2", "1.16"}],
    Cell[4988, 179, 210, 7, 70, "Notes",
      CellTags->{"S0.3.2", "1.17"}],
    Cell[5201, 188, 223, 7, 70, "Notes",
      CellTags->{"S0.3.2", "1.18"}],
    Cell[5427, 197, 158, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.19"}],
    Cell[5588, 203, 182, 5, 70, "Notes",
      CellTags->{"S0.3.2", "1.20"}],
    Cell[5773, 210, 295, 10, 70, "Notes",
      CellTags->{"S0.3.2", "1.21"}],
    Cell[6071, 222, 152, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.22"}]},
  "1.3"->{
    Cell[2374, 71, 74, 1, 70, "Subsection",
      CellTags->{"S0.3.2", "1.3"}]},
  "1.4"->{
    Cell[2451, 74, 133, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.4"}]},
  "1.5"->{
    Cell[2587, 80, 126, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.5"}]},
  "1.6"->{
    Cell[2716, 86, 145, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.6"}]},
  "1.7"->{
    Cell[2864, 92, 137, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.7"}]},
  "1.8"->{
    Cell[3004, 98, 205, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.8"}]},
  "1.9"->{
    Cell[3212, 106, 231, 8, 70, "Notes",
      CellTags->{"S0.3.2", "1.9"}]},
  "1.10"->{
    Cell[3446, 116, 206, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.10"}]},
  "1.11"->{
    Cell[3655, 124, 161, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.11"}]},
  "1.12"->{
    Cell[3819, 130, 266, 9, 70, "Notes",
      CellTags->{"S0.3.2", "1.12"}]},
  "1.13"->{
    Cell[4088, 141, 184, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.13"}]},
  "1.14"->{
    Cell[4275, 149, 190, 6, 70, "Notes",
      CellTags->{"S0.3.2", "1.14"}]},
  "1.15"->{
    Cell[4468, 157, 305, 11, 70, "Notes",
      CellTags->{"S0.3.2", "1.15"}]},
  "1.16"->{
    Cell[4776, 170, 209, 7, 70, "Notes",
      CellTags->{"S0.3.2", "1.16"}]},
  "1.17"->{
    Cell[4988, 179, 210, 7, 70, "Notes",
      CellTags->{"S0.3.2", "1.17"}]},
  "1.18"->{
    Cell[5201, 188, 223, 7, 70, "Notes",
      CellTags->{"S0.3.2", "1.18"}]},
  "1.19"->{
    Cell[5427, 197, 158, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.19"}]},
  "1.20"->{
    Cell[5588, 203, 182, 5, 70, "Notes",
      CellTags->{"S0.3.2", "1.20"}]},
  "1.21"->{
    Cell[5773, 210, 295, 10, 70, "Notes",
      CellTags->{"S0.3.2", "1.21"}]},
  "1.22"->{
    Cell[6071, 222, 152, 4, 70, "Notes",
      CellTags->{"S0.3.2", "1.22"}]},
  "S0.3.3"->{
    Cell[6260, 231, 74, 1, 70, "Subsection",
      CellTags->{"S0.3.3", "1.23"}],
    Cell[6337, 234, 212, 7, 70, "Notes",
      CellTags->{"S0.3.3", "1.24"}],
    Cell[6552, 243, 149, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.25"}],
    Cell[6704, 249, 128, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.26"}],
    Cell[6835, 255, 256, 9, 70, "Notes",
      CellTags->{"S0.3.3", "1.27"}],
    Cell[7094, 266, 166, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.28"}],
    Cell[7263, 272, 214, 6, 70, "Notes",
      CellTags->{"S0.3.3", "1.29"}],
    Cell[7480, 280, 142, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.30"}],
    Cell[7625, 286, 260, 9, 70, "Notes",
      CellTags->{"S0.3.3", "1.31"}],
    Cell[7888, 297, 183, 6, 70, "Notes",
      CellTags->{"S0.3.3", "1.32"}],
    Cell[8074, 305, 269, 8, 70, "Notes",
      CellTags->{"S0.3.3", "1.33"}],
    Cell[8346, 315, 151, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.34"}],
    Cell[8500, 321, 134, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.35"}],
    Cell[8637, 327, 208, 6, 70, "Notes",
      CellTags->{"S0.3.3", "1.36"}]},
  "1.23"->{
    Cell[6260, 231, 74, 1, 70, "Subsection",
      CellTags->{"S0.3.3", "1.23"}]},
  "1.24"->{
    Cell[6337, 234, 212, 7, 70, "Notes",
      CellTags->{"S0.3.3", "1.24"}]},
  "1.25"->{
    Cell[6552, 243, 149, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.25"}]},
  "1.26"->{
    Cell[6704, 249, 128, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.26"}]},
  "1.27"->{
    Cell[6835, 255, 256, 9, 70, "Notes",
      CellTags->{"S0.3.3", "1.27"}]},
  "1.28"->{
    Cell[7094, 266, 166, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.28"}]},
  "1.29"->{
    Cell[7263, 272, 214, 6, 70, "Notes",
      CellTags->{"S0.3.3", "1.29"}]},
  "1.30"->{
    Cell[7480, 280, 142, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.30"}]},
  "1.31"->{
    Cell[7625, 286, 260, 9, 70, "Notes",
      CellTags->{"S0.3.3", "1.31"}]},
  "1.32"->{
    Cell[7888, 297, 183, 6, 70, "Notes",
      CellTags->{"S0.3.3", "1.32"}]},
  "1.33"->{
    Cell[8074, 305, 269, 8, 70, "Notes",
      CellTags->{"S0.3.3", "1.33"}]},
  "1.34"->{
    Cell[8346, 315, 151, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.34"}]},
  "1.35"->{
    Cell[8500, 321, 134, 4, 70, "Notes",
      CellTags->{"S0.3.3", "1.35"}]},
  "1.36"->{
    Cell[8637, 327, 208, 6, 70, "Notes",
      CellTags->{"S0.3.3", "1.36"}]},
  "S0.3.4"->{
    Cell[8882, 338, 81, 1, 70, "Subsection",
      CellTags->{"S0.3.4", "1.37"}],
    Cell[8966, 341, 127, 4, 70, "Notes",
      CellTags->{"S0.3.4", "1.38"}],
    Cell[9096, 347, 238, 9, 70, "Notes",
      CellTags->{"S0.3.4", "1.39"}],
    Cell[9337, 358, 259, 9, 70, "Notes",
      CellTags->{"S0.3.4", "1.40"}],
    Cell[9599, 369, 197, 6, 70, "Notes",
      CellTags->{"S0.3.4", "1.41"}],
    Cell[9799, 377, 159, 5, 70, "Notes",
      CellTags->{"S0.3.4", "1.42"}],
    Cell[9961, 384, 149, 4, 70, "Notes",
      CellTags->{"S0.3.4", "1.43"}],
    Cell[10113, 390, 144, 4, 70, "Notes",
      CellTags->{"S0.3.4", "1.44"}]},
  "1.37"->{
    Cell[8882, 338, 81, 1, 70, "Subsection",
      CellTags->{"S0.3.4", "1.37"}]},
  "1.38"->{
    Cell[8966, 341, 127, 4, 70, "Notes",
      CellTags->{"S0.3.4", "1.38"}]},
  "1.39"->{
    Cell[9096, 347, 238, 9, 70, "Notes",
      CellTags->{"S0.3.4", "1.39"}]},
  "1.40"->{
    Cell[9337, 358, 259, 9, 70, "Notes",
      CellTags->{"S0.3.4", "1.40"}]},
  "1.41"->{
    Cell[9599, 369, 197, 6, 70, "Notes",
      CellTags->{"S0.3.4", "1.41"}]},
  "1.42"->{
    Cell[9799, 377, 159, 5, 70, "Notes",
      CellTags->{"S0.3.4", "1.42"}]},
  "1.43"->{
    Cell[9961, 384, 149, 4, 70, "Notes",
      CellTags->{"S0.3.4", "1.43"}]},
  "1.44"->{
    Cell[10113, 390, 144, 4, 70, "Notes",
      CellTags->{"S0.3.4", "1.44"}]},
  "S0.3.5"->{
    Cell[10294, 399, 64, 1, 70, "Subsection",
      CellTags->{"S0.3.5", "1.45"}],
    Cell[10361, 402, 132, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.46"}],
    Cell[10496, 408, 139, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.47"}],
    Cell[10638, 414, 129, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.48"}],
    Cell[10770, 420, 124, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.49"}],
    Cell[10897, 426, 109, 3, 70, "Notes",
      CellTags->{"S0.3.5", "1.50"}],
    Cell[11009, 431, 137, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.51"}],
    Cell[11149, 437, 170, 5, 70, "Notes",
      CellTags->{"S0.3.5", "1.52"}]},
  "1.45"->{
    Cell[10294, 399, 64, 1, 70, "Subsection",
      CellTags->{"S0.3.5", "1.45"}]},
  "1.46"->{
    Cell[10361, 402, 132, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.46"}]},
  "1.47"->{
    Cell[10496, 408, 139, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.47"}]},
  "1.48"->{
    Cell[10638, 414, 129, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.48"}]},
  "1.49"->{
    Cell[10770, 420, 124, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.49"}]},
  "1.50"->{
    Cell[10897, 426, 109, 3, 70, "Notes",
      CellTags->{"S0.3.5", "1.50"}]},
  "1.51"->{
    Cell[11009, 431, 137, 4, 70, "Notes",
      CellTags->{"S0.3.5", "1.51"}]},
  "1.52"->{
    Cell[11149, 437, 170, 5, 70, "Notes",
      CellTags->{"S0.3.5", "1.52"}]},
  "S0.3.6"->{
    Cell[11356, 447, 72, 1, 70, "Subsection",
      CellTags->{"S0.3.6", "1.53"}],
    Cell[11431, 450, 108, 3, 70, "Notes",
      CellTags->{"S0.3.6", "1.54"}],
    Cell[11542, 455, 124, 4, 70, "Notes",
      CellTags->{"S0.3.6", "1.55"}],
    Cell[11669, 461, 126, 4, 70, "Notes",
      CellTags->{"S0.3.6", "1.56"}],
    Cell[11798, 467, 154, 5, 70, "Notes",
      CellTags->{"S0.3.6", "1.57"}]},
  "1.53"->{
    Cell[11356, 447, 72, 1, 70, "Subsection",
      CellTags->{"S0.3.6", "1.53"}]},
  "1.54"->{
    Cell[11431, 450, 108, 3, 70, "Notes",
      CellTags->{"S0.3.6", "1.54"}]},
  "1.55"->{
    Cell[11542, 455, 124, 4, 70, "Notes",
      CellTags->{"S0.3.6", "1.55"}]},
  "1.56"->{
    Cell[11669, 461, 126, 4, 70, "Notes",
      CellTags->{"S0.3.6", "1.56"}]},
  "1.57"->{
    Cell[11798, 467, 154, 5, 70, "Notes",
      CellTags->{"S0.3.6", "1.57"}]},
  "S0.3.7"->{
    Cell[11989, 477, 86, 1, 38, "Subsection",
      CellTags->{"S0.3.7", "1.58"}],
    Cell[12078, 480, 110, 3, 70, "Notes",
      CellTags->{"S0.3.7", "1.59"}],
    Cell[12191, 485, 95, 1, 24, "Notes",
      CellTags->{"S0.3.7", "1.60"}]},
  "1.58"->{
    Cell[11989, 477, 86, 1, 38, "Subsection",
      CellTags->{"S0.3.7", "1.58"}]},
  "1.59"->{
    Cell[12078, 480, 110, 3, 70, "Notes",
      CellTags->{"S0.3.7", "1.59"}]},
  "1.60"->{
    Cell[12191, 485, 95, 1, 24, "Notes",
      CellTags->{"S0.3.7", "1.60"}]},
  "S0.3.8"->{
    Cell[12323, 491, 81, 1, 38, "Subsection",
      CellTags->{"S0.3.8", "1.61"}],
    Cell[12407, 494, 127, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.62"}],
    Cell[12537, 500, 176, 5, 24, "Notes",
      CellTags->{"S0.3.8", "1.63"}],
    Cell[12716, 507, 121, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.64"}],
    Cell[12840, 513, 167, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.65"}],
    Cell[13010, 521, 178, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.66"}],
    Cell[13191, 529, 141, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.67"}],
    Cell[13335, 535, 151, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.68"}],
    Cell[13489, 541, 127, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.69"}],
    Cell[13619, 547, 117, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.70"}],
    Cell[13739, 553, 155, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.71"}],
    Cell[13897, 559, 260, 9, 24, "Notes",
      CellTags->{"S0.3.8", "1.72"}],
    Cell[14160, 570, 194, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.73"}],
    Cell[14357, 578, 191, 7, 24, "Notes",
      CellTags->{"S0.3.8", "1.74"}],
    Cell[14551, 587, 182, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.75"}],
    Cell[14736, 595, 327, 12, 24, "Notes",
      CellTags->{"S0.3.8", "1.76"}],
    Cell[15066, 609, 130, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.77"}],
    Cell[15199, 615, 116, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.78"}],
    Cell[15318, 621, 151, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.79"}],
    Cell[15472, 627, 119, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.80"}],
    Cell[15594, 633, 161, 5, 24, "Notes",
      CellTags->{"S0.3.8", "1.81"}],
    Cell[15758, 640, 158, 5, 24, "Notes",
      CellTags->{"S0.3.8", "1.82"}]},
  "1.61"->{
    Cell[12323, 491, 81, 1, 38, "Subsection",
      CellTags->{"S0.3.8", "1.61"}]},
  "1.62"->{
    Cell[12407, 494, 127, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.62"}]},
  "1.63"->{
    Cell[12537, 500, 176, 5, 24, "Notes",
      CellTags->{"S0.3.8", "1.63"}]},
  "1.64"->{
    Cell[12716, 507, 121, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.64"}]},
  "1.65"->{
    Cell[12840, 513, 167, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.65"}]},
  "1.66"->{
    Cell[13010, 521, 178, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.66"}]},
  "1.67"->{
    Cell[13191, 529, 141, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.67"}]},
  "1.68"->{
    Cell[13335, 535, 151, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.68"}]},
  "1.69"->{
    Cell[13489, 541, 127, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.69"}]},
  "1.70"->{
    Cell[13619, 547, 117, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.70"}]},
  "1.71"->{
    Cell[13739, 553, 155, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.71"}]},
  "1.72"->{
    Cell[13897, 559, 260, 9, 24, "Notes",
      CellTags->{"S0.3.8", "1.72"}]},
  "1.73"->{
    Cell[14160, 570, 194, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.73"}]},
  "1.74"->{
    Cell[14357, 578, 191, 7, 24, "Notes",
      CellTags->{"S0.3.8", "1.74"}]},
  "1.75"->{
    Cell[14551, 587, 182, 6, 24, "Notes",
      CellTags->{"S0.3.8", "1.75"}]},
  "1.76"->{
    Cell[14736, 595, 327, 12, 24, "Notes",
      CellTags->{"S0.3.8", "1.76"}]},
  "1.77"->{
    Cell[15066, 609, 130, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.77"}]},
  "1.78"->{
    Cell[15199, 615, 116, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.78"}]},
  "1.79"->{
    Cell[15318, 621, 151, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.79"}]},
  "1.80"->{
    Cell[15472, 627, 119, 4, 24, "Notes",
      CellTags->{"S0.3.8", "1.80"}]},
  "1.81"->{
    Cell[15594, 633, 161, 5, 24, "Notes",
      CellTags->{"S0.3.8", "1.81"}]},
  "1.82"->{
    Cell[15758, 640, 158, 5, 24, "Notes",
      CellTags->{"S0.3.8", "1.82"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.3.1", 16559, 665},
  {"1.1", 16724, 670},
  {"1.2", 16813, 673},
  {"S0.3.2", 16904, 676},
  {"1.3", 18469, 717},
  {"1.4", 18561, 720},
  {"1.5", 18649, 723},
  {"1.6", 18737, 726},
  {"1.7", 18825, 729},
  {"1.8", 18913, 732},
  {"1.9", 19001, 735},
  {"1.10", 19091, 738},
  {"1.11", 19182, 741},
  {"1.12", 19273, 744},
  {"1.13", 19364, 747},
  {"1.14", 19455, 750},
  {"1.15", 19546, 753},
  {"1.16", 19638, 756},
  {"1.17", 19729, 759},
  {"1.18", 19820, 762},
  {"1.19", 19911, 765},
  {"1.20", 20002, 768},
  {"1.21", 20093, 771},
  {"1.22", 20185, 774},
  {"S0.3.3", 20278, 777},
  {"1.23", 21387, 806},
  {"1.24", 21482, 809},
  {"1.25", 21573, 812},
  {"1.26", 21664, 815},
  {"1.27", 21755, 818},
  {"1.28", 21846, 821},
  {"1.29", 21937, 824},
  {"1.30", 22028, 827},
  {"1.31", 22119, 830},
  {"1.32", 22210, 833},
  {"1.33", 22301, 836},
  {"1.34", 22392, 839},
  {"1.35", 22483, 842},
  {"1.36", 22574, 845},
  {"S0.3.4", 22667, 848},
  {"1.37", 23309, 865},
  {"1.38", 23404, 868},
  {"1.39", 23495, 871},
  {"1.40", 23586, 874},
  {"1.41", 23677, 877},
  {"1.42", 23768, 880},
  {"1.43", 23859, 883},
  {"1.44", 23950, 886},
  {"S0.3.5", 24044, 889},
  {"1.45", 24693, 906},
  {"1.46", 24789, 909},
  {"1.47", 24881, 912},
  {"1.48", 24973, 915},
  {"1.49", 25065, 918},
  {"1.50", 25157, 921},
  {"1.51", 25249, 924},
  {"1.52", 25341, 927},
  {"S0.3.6", 25435, 930},
  {"1.53", 25847, 941},
  {"1.54", 25943, 944},
  {"1.55", 26035, 947},
  {"1.56", 26127, 950},
  {"1.57", 26219, 953},
  {"S0.3.7", 26313, 956},
  {"1.58", 26566, 963},
  {"1.59", 26662, 966},
  {"1.60", 26754, 969},
  {"S0.3.8", 26847, 972},
  {"1.61", 28603, 1017},
  {"1.62", 28699, 1020},
  {"1.63", 28791, 1023},
  {"1.64", 28883, 1026},
  {"1.65", 28975, 1029},
  {"1.66", 29067, 1032},
  {"1.67", 29159, 1035},
  {"1.68", 29251, 1038},
  {"1.69", 29343, 1041},
  {"1.70", 29435, 1044},
  {"1.71", 29527, 1047},
  {"1.72", 29619, 1050},
  {"1.73", 29711, 1053},
  {"1.74", 29803, 1056},
  {"1.75", 29895, 1059},
  {"1.76", 29987, 1062},
  {"1.77", 30080, 1065},
  {"1.78", 30172, 1068},
  {"1.79", 30264, 1071},
  {"1.80", 30356, 1074},
  {"1.81", 30448, 1077},
  {"1.82", 30540, 1080}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 66, 1, 65, "Section",
  CellTags->{"S0.3.1", "1.1"}],
Cell[1845, 56, 504, 11, 70, "Text",
  CellTags->{"S0.3.1", "1.2"}],

Cell[CellGroupData[{
Cell[2374, 71, 74, 1, 70, "Subsection",
  CellTags->{"S0.3.2", "1.3"}],
Cell[2451, 74, 133, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.4"}],
Cell[2587, 80, 126, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.5"}],
Cell[2716, 86, 145, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.6"}],
Cell[2864, 92, 137, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.7"}],
Cell[3004, 98, 205, 6, 70, "Notes",
  CellTags->{"S0.3.2", "1.8"}],
Cell[3212, 106, 231, 8, 70, "Notes",
  CellTags->{"S0.3.2", "1.9"}],
Cell[3446, 116, 206, 6, 70, "Notes",
  CellTags->{"S0.3.2", "1.10"}],
Cell[3655, 124, 161, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.11"}],
Cell[3819, 130, 266, 9, 70, "Notes",
  CellTags->{"S0.3.2", "1.12"}],
Cell[4088, 141, 184, 6, 70, "Notes",
  CellTags->{"S0.3.2", "1.13"}],
Cell[4275, 149, 190, 6, 70, "Notes",
  CellTags->{"S0.3.2", "1.14"}],
Cell[4468, 157, 305, 11, 70, "Notes",
  CellTags->{"S0.3.2", "1.15"}],
Cell[4776, 170, 209, 7, 70, "Notes",
  CellTags->{"S0.3.2", "1.16"}],
Cell[4988, 179, 210, 7, 70, "Notes",
  CellTags->{"S0.3.2", "1.17"}],
Cell[5201, 188, 223, 7, 70, "Notes",
  CellTags->{"S0.3.2", "1.18"}],
Cell[5427, 197, 158, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.19"}],
Cell[5588, 203, 182, 5, 70, "Notes",
  CellTags->{"S0.3.2", "1.20"}],
Cell[5773, 210, 295, 10, 70, "Notes",
  CellTags->{"S0.3.2", "1.21"}],
Cell[6071, 222, 152, 4, 70, "Notes",
  CellTags->{"S0.3.2", "1.22"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6260, 231, 74, 1, 70, "Subsection",
  CellTags->{"S0.3.3", "1.23"}],
Cell[6337, 234, 212, 7, 70, "Notes",
  CellTags->{"S0.3.3", "1.24"}],
Cell[6552, 243, 149, 4, 70, "Notes",
  CellTags->{"S0.3.3", "1.25"}],
Cell[6704, 249, 128, 4, 70, "Notes",
  CellTags->{"S0.3.3", "1.26"}],
Cell[6835, 255, 256, 9, 70, "Notes",
  CellTags->{"S0.3.3", "1.27"}],
Cell[7094, 266, 166, 4, 70, "Notes",
  CellTags->{"S0.3.3", "1.28"}],
Cell[7263, 272, 214, 6, 70, "Notes",
  CellTags->{"S0.3.3", "1.29"}],
Cell[7480, 280, 142, 4, 70, "Notes",
  CellTags->{"S0.3.3", "1.30"}],
Cell[7625, 286, 260, 9, 70, "Notes",
  CellTags->{"S0.3.3", "1.31"}],
Cell[7888, 297, 183, 6, 70, "Notes",
  CellTags->{"S0.3.3", "1.32"}],
Cell[8074, 305, 269, 8, 70, "Notes",
  CellTags->{"S0.3.3", "1.33"}],
Cell[8346, 315, 151, 4, 70, "Notes",
  CellTags->{"S0.3.3", "1.34"}],
Cell[8500, 321, 134, 4, 70, "Notes",
  CellTags->{"S0.3.3", "1.35"}],
Cell[8637, 327, 208, 6, 70, "Notes",
  CellTags->{"S0.3.3", "1.36"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8882, 338, 81, 1, 70, "Subsection",
  CellTags->{"S0.3.4", "1.37"}],
Cell[8966, 341, 127, 4, 70, "Notes",
  CellTags->{"S0.3.4", "1.38"}],
Cell[9096, 347, 238, 9, 70, "Notes",
  CellTags->{"S0.3.4", "1.39"}],
Cell[9337, 358, 259, 9, 70, "Notes",
  CellTags->{"S0.3.4", "1.40"}],
Cell[9599, 369, 197, 6, 70, "Notes",
  CellTags->{"S0.3.4", "1.41"}],
Cell[9799, 377, 159, 5, 70, "Notes",
  CellTags->{"S0.3.4", "1.42"}],
Cell[9961, 384, 149, 4, 70, "Notes",
  CellTags->{"S0.3.4", "1.43"}],
Cell[10113, 390, 144, 4, 70, "Notes",
  CellTags->{"S0.3.4", "1.44"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10294, 399, 64, 1, 70, "Subsection",
  CellTags->{"S0.3.5", "1.45"}],
Cell[10361, 402, 132, 4, 70, "Notes",
  CellTags->{"S0.3.5", "1.46"}],
Cell[10496, 408, 139, 4, 70, "Notes",
  CellTags->{"S0.3.5", "1.47"}],
Cell[10638, 414, 129, 4, 70, "Notes",
  CellTags->{"S0.3.5", "1.48"}],
Cell[10770, 420, 124, 4, 70, "Notes",
  CellTags->{"S0.3.5", "1.49"}],
Cell[10897, 426, 109, 3, 70, "Notes",
  CellTags->{"S0.3.5", "1.50"}],
Cell[11009, 431, 137, 4, 70, "Notes",
  CellTags->{"S0.3.5", "1.51"}],
Cell[11149, 437, 170, 5, 70, "Notes",
  CellTags->{"S0.3.5", "1.52"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11356, 447, 72, 1, 70, "Subsection",
  CellTags->{"S0.3.6", "1.53"}],
Cell[11431, 450, 108, 3, 70, "Notes",
  CellTags->{"S0.3.6", "1.54"}],
Cell[11542, 455, 124, 4, 70, "Notes",
  CellTags->{"S0.3.6", "1.55"}],
Cell[11669, 461, 126, 4, 70, "Notes",
  CellTags->{"S0.3.6", "1.56"}],
Cell[11798, 467, 154, 5, 70, "Notes",
  CellTags->{"S0.3.6", "1.57"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11989, 477, 86, 1, 38, "Subsection",
  CellTags->{"S0.3.7", "1.58"}],
Cell[12078, 480, 110, 3, 70, "Notes",
  CellTags->{"S0.3.7", "1.59"}],
Cell[12191, 485, 95, 1, 24, "Notes",
  CellTags->{"S0.3.7", "1.60"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12323, 491, 81, 1, 38, "Subsection",
  CellTags->{"S0.3.8", "1.61"}],
Cell[12407, 494, 127, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.62"}],
Cell[12537, 500, 176, 5, 24, "Notes",
  CellTags->{"S0.3.8", "1.63"}],
Cell[12716, 507, 121, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.64"}],
Cell[12840, 513, 167, 6, 24, "Notes",
  CellTags->{"S0.3.8", "1.65"}],
Cell[13010, 521, 178, 6, 24, "Notes",
  CellTags->{"S0.3.8", "1.66"}],
Cell[13191, 529, 141, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.67"}],
Cell[13335, 535, 151, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.68"}],
Cell[13489, 541, 127, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.69"}],
Cell[13619, 547, 117, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.70"}],
Cell[13739, 553, 155, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.71"}],
Cell[13897, 559, 260, 9, 24, "Notes",
  CellTags->{"S0.3.8", "1.72"}],
Cell[14160, 570, 194, 6, 24, "Notes",
  CellTags->{"S0.3.8", "1.73"}],
Cell[14357, 578, 191, 7, 24, "Notes",
  CellTags->{"S0.3.8", "1.74"}],
Cell[14551, 587, 182, 6, 24, "Notes",
  CellTags->{"S0.3.8", "1.75"}],
Cell[14736, 595, 327, 12, 24, "Notes",
  CellTags->{"S0.3.8", "1.76"}],
Cell[15066, 609, 130, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.77"}],
Cell[15199, 615, 116, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.78"}],
Cell[15318, 621, 151, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.79"}],
Cell[15472, 627, 119, 4, 24, "Notes",
  CellTags->{"S0.3.8", "1.80"}],
Cell[15594, 633, 161, 5, 24, "Notes",
  CellTags->{"S0.3.8", "1.81"}],
Cell[15758, 640, 158, 5, 24, "Notes",
  CellTags->{"S0.3.8", "1.82"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

