(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12539,        516]*)
(*NotebookOutlinePosition[     26703,        965]*)
(*  CellTagsIndexPosition[     24826,        884]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New in Version 5.1", "Section",
  CellTags->{"S0.4.1", "1.1"}],

Cell[CellGroupData[{

Cell["Numerical computation", "Subsection",
  CellTags->{"S0.4.2", "1.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] New highly\[Hyphen]enhanced algorithms for high\
\[Hyphen]precision ",
  ButtonBox["LinearSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.2", "1.3"}],

Cell["\<\
\[FilledSmallSquare] Internal vectorization of \
high\[Hyphen]precision vector operations. \
\>", "Notes",
  CellTags->{"S0.4.2", "1.4"}],

Cell[TextData[{
  "\[FilledSmallSquare] New high\[Hyphen]performance methods for ",
  ButtonBox["MatrixExp",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.2", "1.5"}],

Cell["\<\
\[FilledSmallSquare] Support for sparse singular value \
decomposition. \
\>", "Notes",
  CellTags->{"S0.4.2", "1.6"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for ",
  ButtonBox["HessenbergDecomposition",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.2", "1.7"}],

Cell[TextData[{
  "\[FilledSmallSquare] Typeset notation for ",
  ButtonBox["Transpose",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Conjugate",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.2", "1.8"}],

Cell["\<\
\[FilledSmallSquare] Numerical integration of discontinuous \
piecewise functions. \
\>", "Notes",
  CellTags->{"S0.4.2", "1.9"}],

Cell["\<\
\[FilledSmallSquare] Numerical integration over implicitly defined \
regions. \
\>", "Notes",
  CellTags->{"S0.4.2", "1.10"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for event detection in ",
  ButtonBox["NDSolve",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.2", "1.11"}],

Cell[TextData[{
  "\[FilledSmallSquare] Additional convenience functions ",
  ButtonBox["Boole",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Clip",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Rescale",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.2", "1.12"}],

Cell["\<\
\[FilledSmallSquare] Package for cluster analysis and dendrograms. \
\
\>", "Notes",
  CellTags->{"S0.4.2", "1.13"}],

Cell["\<\
\[FilledSmallSquare] Package for interactive exploration of \
differential equation systems. \
\>", "Notes",
  CellTags->{"S0.4.2", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic computation", "Subsection",
  CellTags->{"S0.4.3", "1.15"}],

Cell["\<\
\[FilledSmallSquare] General vector derivatives, including \
gradient, Hessian and Jacobian. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.16"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["Piecewise",
    ButtonStyle->"RefGuideLink"],
  " construct for representing general piecewise functions. "
}], "Notes",
  CellTags->{"S0.4.3", "1.17"}],

Cell["\<\
\[FilledSmallSquare] Simplification with piecewise and nested \
piecewise functions. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.18"}],

Cell["\<\
\[FilledSmallSquare] Reduction of piecewise equations and \
inequalities, including quantifiers. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.19"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["Limit",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["Series",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["D",
    ButtonStyle->"RefGuideLink"],
  " support for general piecewise functions. "
}], "Notes",
  CellTags->{"S0.4.3", "1.20"}],

Cell["\<\
\[FilledSmallSquare] Indefinite and definite integration of general \
piecewise functions. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.21"}],

Cell["\<\
\[FilledSmallSquare] Support for solving piecewise ordinary \
differential equations. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.22"}],

Cell["\<\
\[FilledSmallSquare] Symbolic multiple integration over regions \
defined by inequalities. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.23"}],

Cell["\<\
\[FilledSmallSquare] Enhanced support for solving Abel and other \
differential equations. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.24"}],

Cell["\<\
\[FilledSmallSquare] Support for linear differential equations with \
non\[Hyphen]rational coefficients. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.25"}],

Cell["\<\
\[FilledSmallSquare] Nonlinear partial differential equation \
solutions based on complete integrals. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.26"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for equations with multiple moduli in ",
  ButtonBox["Reduce",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.3", "1.27"}],

Cell["\<\
\[FilledSmallSquare] Additional methods for solving Diophantine \
equations. \
\>", "Notes",
  CellTags->{"S0.4.3", "1.28"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Language and core system", "Subsection",
  CellTags->{"S0.4.4", "1.29"}],

Cell["\<\
\[FilledSmallSquare] Full support for optimized string pattern \
matching. \
\>", "Notes",
  CellTags->{"S0.4.4", "1.30"}],

Cell["\<\
\[FilledSmallSquare] Integrated string and expression pattern \
language. \
\>", "Notes",
  CellTags->{"S0.4.4", "1.31"}],

Cell[TextData[{
  "\[FilledSmallSquare] General support for complement patterns with ",
  ButtonBox["Except",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.4", "1.32"}],

Cell["\<\
\[FilledSmallSquare] String patterns integrated into all string \
operations. \
\>", "Notes",
  CellTags->{"S0.4.4", "1.33"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generalized ",
  ButtonBox["StringCases",
    ButtonStyle->"RefGuideLink"],
  " for string analysis. "
}], "Notes",
  CellTags->{"S0.4.4", "1.34"}],

Cell[TextData[{
  "\[FilledSmallSquare] New functions ",
  ButtonBox["StringSplit",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["StringCount",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["StringReplaceList",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.4", "1.35"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["RegularExpression",
    ButtonStyle->"RefGuideLink"],
  " construct for compact string pattern notation. "
}], "Notes",
  CellTags->{"S0.4.4", "1.36"}],

Cell["\<\
\[FilledSmallSquare] English\[Hyphen]language dictionary package. \
\
\>", "Notes",
  CellTags->{"S0.4.4", "1.37"}],

Cell[TextData[{
  "\[FilledSmallSquare] Support for generalized ",
  ButtonBox["Tuples",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Subsets",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.4", "1.38"}],

Cell[TextData[{
  "\[FilledSmallSquare] Expression filtering function ",
  ButtonBox["Pick",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.4", "1.39"}],

Cell["\<\
\[FilledSmallSquare] Package for benchmarking of computer systems. \
\
\>", "Notes",
  CellTags->{"S0.4.4", "1.40"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Data handling and visualization", "Subsection",
  CellTags->{"S0.4.5", "1.41"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  ButtonBox["ArrayPlot",
    ButtonStyle->"RefGuideLink"],
  " for flexible large\[Hyphen]scale array visualization. "
}], "Notes",
  CellTags->{"S0.4.5", "1.42"}],

Cell["\<\
\[FilledSmallSquare] Package for fully\[Hyphen]automated network \
and tree layout in 2D and 3D. \
\>", "Notes",
  CellTags->{"S0.4.5", "1.43"}],

Cell["\<\
\[FilledSmallSquare] Highly optimized import and export of binary \
data. \
\>", "Notes",
  CellTags->{"S0.4.5", "1.44"}],

Cell["\<\
\[FilledSmallSquare] Import and export of XLS spreadsheet files. \
\
\>", "Notes",
  CellTags->{"S0.4.5", "1.45"}],

Cell["\<\
\[FilledSmallSquare] Support for HDF5, MAT (v5), DIF, and PCX. \
\
\>", "Notes",
  CellTags->{"S0.4.5", "1.46"}],

Cell["\[FilledSmallSquare] Export of AVI movie files. ", "Notes",
  CellTags->{"S0.4.5", "1.47"}],

Cell["\<\
\[FilledSmallSquare] Import from http and ftp URLs. \
\>", "Notes",
  CellTags->{"S0.4.5", "1.48"}],

Cell["\<\
\[FilledSmallSquare] Automated encoding and decoding of .gz files. \
\
\>", "Notes",
  CellTags->{"S0.4.5", "1.49"}],

Cell["\<\
\[FilledSmallSquare] Integrated TeX import and parsing in \
notebooks. \
\>", "Notes",
  CellTags->{"S0.4.5", "1.50"}],

Cell[TextData[{
  "\[FilledSmallSquare] Symbolic names for common colors such as ",
  ButtonBox["Red",
    ButtonStyle->"RefGuideLink"],
  " and ",
  ButtonBox["Black",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Notes",
  CellTags->{"S0.4.5", "1.51"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Database access", "Subsection",
  CellTags->{"S0.4.6", "1.52"}],

Cell["\<\
\[FilledSmallSquare] DatabaseLink for universal \
cross\[Hyphen]platform database connectivity. \
\>", "Notes",
  CellTags->{"S0.4.6", "1.53"}],

Cell["\<\
\[FilledSmallSquare] Bundled drivers for most common database \
systems. \
\>", "Notes",
  CellTags->{"S0.4.6", "1.54"}],

Cell["\<\
\[FilledSmallSquare] Integrated language interface for database \
discovery, query and updating. \
\>", "Notes",
  CellTags->{"S0.4.6", "1.55"}],

Cell["\<\
\[FilledSmallSquare] Graphical interface for database connection \
and exploration. \
\>", "Notes",
  CellTags->{"S0.4.6", "1.56"}],

Cell["\<\
\[FilledSmallSquare] Bundled SQL engine for creating custom \
databases. \
\>", "Notes",
  CellTags->{"S0.4.6", "1.57"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["GUI tools", "Subsection",
  CellTags->{"S0.4.7", "1.58"}],

Cell["\<\
\[FilledSmallSquare] Integrated GUIKit for building standalone user \
interfaces. \
\>", "Notes",
  CellTags->{"S0.4.7", "1.59"}],

Cell[TextData[{
  "\[FilledSmallSquare] Platform\[Hyphen]independent ",
  StyleBox["Mathematica", "TI"],
  " language GUI specification. "
}], "Notes",
  CellTags->{"S0.4.7", "1.60"}],

Cell["\<\
\[FilledSmallSquare] Over 100 types of controls and widgets. \
\>", \
"Notes",
  CellTags->{"S0.4.7", "1.61"}],

Cell["\<\
\[FilledSmallSquare] Automatic layout for complex dialog boxes. \
\
\>", "Notes",
  CellTags->{"S0.4.7", "1.62"}],

Cell["\<\
\[FilledSmallSquare] System for creating sequential wizard \
interfaces. \
\>", "Notes",
  CellTags->{"S0.4.7", "1.63"}],

Cell["\<\
\[FilledSmallSquare] Large library of sample GUI applications. \
\
\>", "Notes",
  CellTags->{"S0.4.7", "1.64"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Web Services", "Subsection",
  CellTags->{"S0.4.8", "1.65"}],

Cell[TextData[{
  "\[FilledSmallSquare] Transparent access to web services from within ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Notes",
  CellTags->{"S0.4.8", "1.66"}],

Cell["\[FilledSmallSquare] Support for SOAP and WSDL. ", "Notes",
  CellTags->{"S0.4.8", "1.67"}],

Cell["\<\
\[FilledSmallSquare] Packages for search and lookup on Wolfram \
Research and other sites. \
\>", "Notes",
  CellTags->{"S0.4.8", "1.68"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 4}, {28, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.4.1"->{
    Cell[1776, 53, 68, 1, 65, "Section",
      CellTags->{"S0.4.1", "1.1"}]},
  "1.1"->{
    Cell[1776, 53, 68, 1, 65, "Section",
      CellTags->{"S0.4.1", "1.1"}]},
  "S0.4.2"->{
    Cell[1869, 58, 74, 1, 70, "Subsection",
      CellTags->{"S0.4.2", "1.2"}],
    Cell[1946, 61, 222, 7, 70, "Notes",
      CellTags->{"S0.4.2", "1.3"}],
    Cell[2171, 70, 147, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.4"}],
    Cell[2321, 76, 193, 6, 70, "Notes",
      CellTags->{"S0.4.2", "1.5"}],
    Cell[2517, 84, 128, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.6"}],
    Cell[2648, 90, 178, 6, 70, "Notes",
      CellTags->{"S0.4.2", "1.7"}],
    Cell[2829, 98, 243, 9, 70, "Notes",
      CellTags->{"S0.4.2", "1.8"}],
    Cell[3075, 109, 139, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.9"}],
    Cell[3217, 115, 135, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.10"}],
    Cell[3355, 121, 182, 6, 70, "Notes",
      CellTags->{"S0.4.2", "1.11"}],
    Cell[3540, 129, 312, 12, 70, "Notes",
      CellTags->{"S0.4.2", "1.12"}],
    Cell[3855, 143, 126, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.13"}],
    Cell[3984, 149, 150, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.14"}]},
  "1.2"->{
    Cell[1869, 58, 74, 1, 70, "Subsection",
      CellTags->{"S0.4.2", "1.2"}]},
  "1.3"->{
    Cell[1946, 61, 222, 7, 70, "Notes",
      CellTags->{"S0.4.2", "1.3"}]},
  "1.4"->{
    Cell[2171, 70, 147, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.4"}]},
  "1.5"->{
    Cell[2321, 76, 193, 6, 70, "Notes",
      CellTags->{"S0.4.2", "1.5"}]},
  "1.6"->{
    Cell[2517, 84, 128, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.6"}]},
  "1.7"->{
    Cell[2648, 90, 178, 6, 70, "Notes",
      CellTags->{"S0.4.2", "1.7"}]},
  "1.8"->{
    Cell[2829, 98, 243, 9, 70, "Notes",
      CellTags->{"S0.4.2", "1.8"}]},
  "1.9"->{
    Cell[3075, 109, 139, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.9"}]},
  "1.10"->{
    Cell[3217, 115, 135, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.10"}]},
  "1.11"->{
    Cell[3355, 121, 182, 6, 70, "Notes",
      CellTags->{"S0.4.2", "1.11"}]},
  "1.12"->{
    Cell[3540, 129, 312, 12, 70, "Notes",
      CellTags->{"S0.4.2", "1.12"}]},
  "1.13"->{
    Cell[3855, 143, 126, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.13"}]},
  "1.14"->{
    Cell[3984, 149, 150, 4, 70, "Notes",
      CellTags->{"S0.4.2", "1.14"}]},
  "S0.4.3"->{
    Cell[4171, 158, 74, 1, 70, "Subsection",
      CellTags->{"S0.4.3", "1.15"}],
    Cell[4248, 161, 150, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.16"}],
    Cell[4401, 167, 208, 6, 70, "Notes",
      CellTags->{"S0.4.3", "1.17"}],
    Cell[4612, 175, 142, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.18"}],
    Cell[4757, 181, 154, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.19"}],
    Cell[4914, 187, 315, 12, 70, "Notes",
      CellTags->{"S0.4.3", "1.20"}],
    Cell[5232, 201, 148, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.21"}],
    Cell[5383, 207, 143, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.22"}],
    Cell[5529, 213, 148, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.23"}],
    Cell[5680, 219, 148, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.24"}],
    Cell[5831, 225, 162, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.25"}],
    Cell[5996, 231, 159, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.26"}],
    Cell[6158, 237, 196, 6, 70, "Notes",
      CellTags->{"S0.4.3", "1.27"}],
    Cell[6357, 245, 134, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.28"}]},
  "1.15"->{
    Cell[4171, 158, 74, 1, 70, "Subsection",
      CellTags->{"S0.4.3", "1.15"}]},
  "1.16"->{
    Cell[4248, 161, 150, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.16"}]},
  "1.17"->{
    Cell[4401, 167, 208, 6, 70, "Notes",
      CellTags->{"S0.4.3", "1.17"}]},
  "1.18"->{
    Cell[4612, 175, 142, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.18"}]},
  "1.19"->{
    Cell[4757, 181, 154, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.19"}]},
  "1.20"->{
    Cell[4914, 187, 315, 12, 70, "Notes",
      CellTags->{"S0.4.3", "1.20"}]},
  "1.21"->{
    Cell[5232, 201, 148, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.21"}]},
  "1.22"->{
    Cell[5383, 207, 143, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.22"}]},
  "1.23"->{
    Cell[5529, 213, 148, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.23"}]},
  "1.24"->{
    Cell[5680, 219, 148, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.24"}]},
  "1.25"->{
    Cell[5831, 225, 162, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.25"}]},
  "1.26"->{
    Cell[5996, 231, 159, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.26"}]},
  "1.27"->{
    Cell[6158, 237, 196, 6, 70, "Notes",
      CellTags->{"S0.4.3", "1.27"}]},
  "1.28"->{
    Cell[6357, 245, 134, 4, 70, "Notes",
      CellTags->{"S0.4.3", "1.28"}]},
  "S0.4.4"->{
    Cell[6528, 254, 78, 1, 70, "Subsection",
      CellTags->{"S0.4.4", "1.29"}],
    Cell[6609, 257, 132, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.30"}],
    Cell[6744, 263, 131, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.31"}],
    Cell[6878, 269, 195, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.32"}],
    Cell[7076, 277, 135, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.33"}],
    Cell[7214, 283, 187, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.34"}],
    Cell[7404, 291, 316, 12, 70, "Notes",
      CellTags->{"S0.4.4", "1.35"}],
    Cell[7723, 305, 207, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.36"}],
    Cell[7933, 313, 125, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.37"}],
    Cell[8061, 319, 242, 9, 70, "Notes",
      CellTags->{"S0.4.4", "1.38"}],
    Cell[8306, 330, 178, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.39"}],
    Cell[8487, 338, 126, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.40"}]},
  "1.29"->{
    Cell[6528, 254, 78, 1, 70, "Subsection",
      CellTags->{"S0.4.4", "1.29"}]},
  "1.30"->{
    Cell[6609, 257, 132, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.30"}]},
  "1.31"->{
    Cell[6744, 263, 131, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.31"}]},
  "1.32"->{
    Cell[6878, 269, 195, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.32"}]},
  "1.33"->{
    Cell[7076, 277, 135, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.33"}]},
  "1.34"->{
    Cell[7214, 283, 187, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.34"}]},
  "1.35"->{
    Cell[7404, 291, 316, 12, 70, "Notes",
      CellTags->{"S0.4.4", "1.35"}]},
  "1.36"->{
    Cell[7723, 305, 207, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.36"}]},
  "1.37"->{
    Cell[7933, 313, 125, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.37"}]},
  "1.38"->{
    Cell[8061, 319, 242, 9, 70, "Notes",
      CellTags->{"S0.4.4", "1.38"}]},
  "1.39"->{
    Cell[8306, 330, 178, 6, 70, "Notes",
      CellTags->{"S0.4.4", "1.39"}]},
  "1.40"->{
    Cell[8487, 338, 126, 4, 70, "Notes",
      CellTags->{"S0.4.4", "1.40"}]},
  "S0.4.5"->{
    Cell[8650, 347, 85, 1, 70, "Subsection",
      CellTags->{"S0.4.5", "1.41"}],
    Cell[8738, 350, 206, 6, 70, "Notes",
      CellTags->{"S0.4.5", "1.42"}],
    Cell[8947, 358, 154, 4, 70, "Notes",
      CellTags->{"S0.4.5", "1.43"}],
    Cell[9104, 364, 131, 4, 70, "Notes",
      CellTags->{"S0.4.5", "1.44"}],
    Cell[9238, 370, 124, 4, 24, "Notes",
      CellTags->{"S0.4.5", "1.45"}],
    Cell[9365, 376, 122, 4, 70, "Notes",
      CellTags->{"S0.4.5", "1.46"}],
    Cell[9490, 382, 97, 1, 24, "Notes",
      CellTags->{"S0.4.5", "1.47"}],
    Cell[9590, 385, 109, 3, 24, "Notes",
      CellTags->{"S0.4.5", "1.48"}],
    Cell[9702, 390, 126, 4, 24, "Notes",
      CellTags->{"S0.4.5", "1.49"}],
    Cell[9831, 396, 128, 4, 24, "Notes",
      CellTags->{"S0.4.5", "1.50"}],
    Cell[9962, 402, 254, 9, 24, "Notes",
      CellTags->{"S0.4.5", "1.51"}]},
  "1.41"->{
    Cell[8650, 347, 85, 1, 70, "Subsection",
      CellTags->{"S0.4.5", "1.41"}]},
  "1.42"->{
    Cell[8738, 350, 206, 6, 70, "Notes",
      CellTags->{"S0.4.5", "1.42"}]},
  "1.43"->{
    Cell[8947, 358, 154, 4, 70, "Notes",
      CellTags->{"S0.4.5", "1.43"}]},
  "1.44"->{
    Cell[9104, 364, 131, 4, 70, "Notes",
      CellTags->{"S0.4.5", "1.44"}]},
  "1.45"->{
    Cell[9238, 370, 124, 4, 24, "Notes",
      CellTags->{"S0.4.5", "1.45"}]},
  "1.46"->{
    Cell[9365, 376, 122, 4, 70, "Notes",
      CellTags->{"S0.4.5", "1.46"}]},
  "1.47"->{
    Cell[9490, 382, 97, 1, 24, "Notes",
      CellTags->{"S0.4.5", "1.47"}]},
  "1.48"->{
    Cell[9590, 385, 109, 3, 24, "Notes",
      CellTags->{"S0.4.5", "1.48"}]},
  "1.49"->{
    Cell[9702, 390, 126, 4, 24, "Notes",
      CellTags->{"S0.4.5", "1.49"}]},
  "1.50"->{
    Cell[9831, 396, 128, 4, 24, "Notes",
      CellTags->{"S0.4.5", "1.50"}]},
  "1.51"->{
    Cell[9962, 402, 254, 9, 24, "Notes",
      CellTags->{"S0.4.5", "1.51"}]},
  "S0.4.6"->{
    Cell[10253, 416, 69, 1, 38, "Subsection",
      CellTags->{"S0.4.6", "1.52"}],
    Cell[10325, 419, 153, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.53"}],
    Cell[10481, 425, 130, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.54"}],
    Cell[10614, 431, 154, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.55"}],
    Cell[10771, 437, 141, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.56"}],
    Cell[10915, 443, 130, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.57"}]},
  "1.52"->{
    Cell[10253, 416, 69, 1, 38, "Subsection",
      CellTags->{"S0.4.6", "1.52"}]},
  "1.53"->{
    Cell[10325, 419, 153, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.53"}]},
  "1.54"->{
    Cell[10481, 425, 130, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.54"}]},
  "1.55"->{
    Cell[10614, 431, 154, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.55"}]},
  "1.56"->{
    Cell[10771, 437, 141, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.56"}]},
  "1.57"->{
    Cell[10915, 443, 130, 4, 24, "Notes",
      CellTags->{"S0.4.6", "1.57"}]},
  "S0.4.7"->{
    Cell[11082, 452, 63, 1, 38, "Subsection",
      CellTags->{"S0.4.7", "1.58"}],
    Cell[11148, 455, 139, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.59"}],
    Cell[11290, 461, 183, 5, 24, "Notes",
      CellTags->{"S0.4.7", "1.60"}],
    Cell[11476, 468, 120, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.61"}],
    Cell[11599, 474, 123, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.62"}],
    Cell[11725, 480, 130, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.63"}],
    Cell[11858, 486, 122, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.64"}]},
  "1.58"->{
    Cell[11082, 452, 63, 1, 38, "Subsection",
      CellTags->{"S0.4.7", "1.58"}]},
  "1.59"->{
    Cell[11148, 455, 139, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.59"}]},
  "1.60"->{
    Cell[11290, 461, 183, 5, 24, "Notes",
      CellTags->{"S0.4.7", "1.60"}]},
  "1.61"->{
    Cell[11476, 468, 120, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.61"}]},
  "1.62"->{
    Cell[11599, 474, 123, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.62"}]},
  "1.63"->{
    Cell[11725, 480, 130, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.63"}]},
  "1.64"->{
    Cell[11858, 486, 122, 4, 24, "Notes",
      CellTags->{"S0.4.7", "1.64"}]},
  "S0.4.8"->{
    Cell[12017, 495, 66, 1, 38, "Subsection",
      CellTags->{"S0.4.8", "1.65"}],
    Cell[12086, 498, 174, 5, 24, "Notes",
      CellTags->{"S0.4.8", "1.66"}],
    Cell[12263, 505, 97, 1, 24, "Notes",
      CellTags->{"S0.4.8", "1.67"}],
    Cell[12363, 508, 148, 4, 24, "Notes",
      CellTags->{"S0.4.8", "1.68"}]},
  "1.65"->{
    Cell[12017, 495, 66, 1, 38, "Subsection",
      CellTags->{"S0.4.8", "1.65"}]},
  "1.66"->{
    Cell[12086, 498, 174, 5, 24, "Notes",
      CellTags->{"S0.4.8", "1.66"}]},
  "1.67"->{
    Cell[12263, 505, 97, 1, 24, "Notes",
      CellTags->{"S0.4.8", "1.67"}]},
  "1.68"->{
    Cell[12363, 508, 148, 4, 24, "Notes",
      CellTags->{"S0.4.8", "1.68"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.4.1", 13152, 532},
  {"1.1", 13241, 535},
  {"S0.4.2", 13333, 538},
  {"1.2", 14349, 565},
  {"1.3", 14441, 568},
  {"1.4", 14529, 571},
  {"1.5", 14617, 574},
  {"1.6", 14705, 577},
  {"1.7", 14793, 580},
  {"1.8", 14881, 583},
  {"1.9", 14969, 586},
  {"1.10", 15059, 589},
  {"1.11", 15150, 592},
  {"1.12", 15241, 595},
  {"1.13", 15333, 598},
  {"1.14", 15424, 601},
  {"S0.4.3", 15517, 604},
  {"1.15", 16627, 633},
  {"1.16", 16722, 636},
  {"1.17", 16813, 639},
  {"1.18", 16904, 642},
  {"1.19", 16995, 645},
  {"1.20", 17086, 648},
  {"1.21", 17178, 651},
  {"1.22", 17269, 654},
  {"1.23", 17360, 657},
  {"1.24", 17451, 660},
  {"1.25", 17542, 663},
  {"1.26", 17633, 666},
  {"1.27", 17724, 669},
  {"1.28", 17815, 672},
  {"S0.4.4", 17908, 675},
  {"1.29", 18862, 700},
  {"1.30", 18957, 703},
  {"1.31", 19048, 706},
  {"1.32", 19139, 709},
  {"1.33", 19230, 712},
  {"1.34", 19321, 715},
  {"1.35", 19412, 718},
  {"1.36", 19504, 721},
  {"1.37", 19595, 724},
  {"1.38", 19686, 727},
  {"1.39", 19777, 730},
  {"1.40", 19868, 733},
  {"S0.4.5", 19961, 736},
  {"1.41", 20835, 759},
  {"1.42", 20930, 762},
  {"1.43", 21021, 765},
  {"1.44", 21112, 768},
  {"1.45", 21203, 771},
  {"1.46", 21294, 774},
  {"1.47", 21385, 777},
  {"1.48", 21475, 780},
  {"1.49", 21566, 783},
  {"1.50", 21657, 786},
  {"1.51", 21748, 789},
  {"S0.4.6", 21841, 792},
  {"1.52", 22332, 805},
  {"1.53", 22428, 808},
  {"1.54", 22520, 811},
  {"1.55", 22612, 814},
  {"1.56", 22704, 817},
  {"1.57", 22796, 820},
  {"S0.4.7", 22890, 823},
  {"1.58", 23460, 838},
  {"1.59", 23556, 841},
  {"1.60", 23648, 844},
  {"1.61", 23740, 847},
  {"1.62", 23832, 850},
  {"1.63", 23924, 853},
  {"1.64", 24016, 856},
  {"S0.4.8", 24110, 859},
  {"1.65", 24442, 868},
  {"1.66", 24538, 871},
  {"1.67", 24630, 874},
  {"1.68", 24721, 877}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 68, 1, 65, "Section",
  CellTags->{"S0.4.1", "1.1"}],

Cell[CellGroupData[{
Cell[1869, 58, 74, 1, 70, "Subsection",
  CellTags->{"S0.4.2", "1.2"}],
Cell[1946, 61, 222, 7, 70, "Notes",
  CellTags->{"S0.4.2", "1.3"}],
Cell[2171, 70, 147, 4, 70, "Notes",
  CellTags->{"S0.4.2", "1.4"}],
Cell[2321, 76, 193, 6, 70, "Notes",
  CellTags->{"S0.4.2", "1.5"}],
Cell[2517, 84, 128, 4, 70, "Notes",
  CellTags->{"S0.4.2", "1.6"}],
Cell[2648, 90, 178, 6, 70, "Notes",
  CellTags->{"S0.4.2", "1.7"}],
Cell[2829, 98, 243, 9, 70, "Notes",
  CellTags->{"S0.4.2", "1.8"}],
Cell[3075, 109, 139, 4, 70, "Notes",
  CellTags->{"S0.4.2", "1.9"}],
Cell[3217, 115, 135, 4, 70, "Notes",
  CellTags->{"S0.4.2", "1.10"}],
Cell[3355, 121, 182, 6, 70, "Notes",
  CellTags->{"S0.4.2", "1.11"}],
Cell[3540, 129, 312, 12, 70, "Notes",
  CellTags->{"S0.4.2", "1.12"}],
Cell[3855, 143, 126, 4, 70, "Notes",
  CellTags->{"S0.4.2", "1.13"}],
Cell[3984, 149, 150, 4, 70, "Notes",
  CellTags->{"S0.4.2", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4171, 158, 74, 1, 70, "Subsection",
  CellTags->{"S0.4.3", "1.15"}],
Cell[4248, 161, 150, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.16"}],
Cell[4401, 167, 208, 6, 70, "Notes",
  CellTags->{"S0.4.3", "1.17"}],
Cell[4612, 175, 142, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.18"}],
Cell[4757, 181, 154, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.19"}],
Cell[4914, 187, 315, 12, 70, "Notes",
  CellTags->{"S0.4.3", "1.20"}],
Cell[5232, 201, 148, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.21"}],
Cell[5383, 207, 143, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.22"}],
Cell[5529, 213, 148, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.23"}],
Cell[5680, 219, 148, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.24"}],
Cell[5831, 225, 162, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.25"}],
Cell[5996, 231, 159, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.26"}],
Cell[6158, 237, 196, 6, 70, "Notes",
  CellTags->{"S0.4.3", "1.27"}],
Cell[6357, 245, 134, 4, 70, "Notes",
  CellTags->{"S0.4.3", "1.28"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6528, 254, 78, 1, 70, "Subsection",
  CellTags->{"S0.4.4", "1.29"}],
Cell[6609, 257, 132, 4, 70, "Notes",
  CellTags->{"S0.4.4", "1.30"}],
Cell[6744, 263, 131, 4, 70, "Notes",
  CellTags->{"S0.4.4", "1.31"}],
Cell[6878, 269, 195, 6, 70, "Notes",
  CellTags->{"S0.4.4", "1.32"}],
Cell[7076, 277, 135, 4, 70, "Notes",
  CellTags->{"S0.4.4", "1.33"}],
Cell[7214, 283, 187, 6, 70, "Notes",
  CellTags->{"S0.4.4", "1.34"}],
Cell[7404, 291, 316, 12, 70, "Notes",
  CellTags->{"S0.4.4", "1.35"}],
Cell[7723, 305, 207, 6, 70, "Notes",
  CellTags->{"S0.4.4", "1.36"}],
Cell[7933, 313, 125, 4, 70, "Notes",
  CellTags->{"S0.4.4", "1.37"}],
Cell[8061, 319, 242, 9, 70, "Notes",
  CellTags->{"S0.4.4", "1.38"}],
Cell[8306, 330, 178, 6, 70, "Notes",
  CellTags->{"S0.4.4", "1.39"}],
Cell[8487, 338, 126, 4, 70, "Notes",
  CellTags->{"S0.4.4", "1.40"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8650, 347, 85, 1, 70, "Subsection",
  CellTags->{"S0.4.5", "1.41"}],
Cell[8738, 350, 206, 6, 70, "Notes",
  CellTags->{"S0.4.5", "1.42"}],
Cell[8947, 358, 154, 4, 70, "Notes",
  CellTags->{"S0.4.5", "1.43"}],
Cell[9104, 364, 131, 4, 70, "Notes",
  CellTags->{"S0.4.5", "1.44"}],
Cell[9238, 370, 124, 4, 24, "Notes",
  CellTags->{"S0.4.5", "1.45"}],
Cell[9365, 376, 122, 4, 70, "Notes",
  CellTags->{"S0.4.5", "1.46"}],
Cell[9490, 382, 97, 1, 24, "Notes",
  CellTags->{"S0.4.5", "1.47"}],
Cell[9590, 385, 109, 3, 24, "Notes",
  CellTags->{"S0.4.5", "1.48"}],
Cell[9702, 390, 126, 4, 24, "Notes",
  CellTags->{"S0.4.5", "1.49"}],
Cell[9831, 396, 128, 4, 24, "Notes",
  CellTags->{"S0.4.5", "1.50"}],
Cell[9962, 402, 254, 9, 24, "Notes",
  CellTags->{"S0.4.5", "1.51"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10253, 416, 69, 1, 38, "Subsection",
  CellTags->{"S0.4.6", "1.52"}],
Cell[10325, 419, 153, 4, 24, "Notes",
  CellTags->{"S0.4.6", "1.53"}],
Cell[10481, 425, 130, 4, 24, "Notes",
  CellTags->{"S0.4.6", "1.54"}],
Cell[10614, 431, 154, 4, 24, "Notes",
  CellTags->{"S0.4.6", "1.55"}],
Cell[10771, 437, 141, 4, 24, "Notes",
  CellTags->{"S0.4.6", "1.56"}],
Cell[10915, 443, 130, 4, 24, "Notes",
  CellTags->{"S0.4.6", "1.57"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11082, 452, 63, 1, 38, "Subsection",
  CellTags->{"S0.4.7", "1.58"}],
Cell[11148, 455, 139, 4, 24, "Notes",
  CellTags->{"S0.4.7", "1.59"}],
Cell[11290, 461, 183, 5, 24, "Notes",
  CellTags->{"S0.4.7", "1.60"}],
Cell[11476, 468, 120, 4, 24, "Notes",
  CellTags->{"S0.4.7", "1.61"}],
Cell[11599, 474, 123, 4, 24, "Notes",
  CellTags->{"S0.4.7", "1.62"}],
Cell[11725, 480, 130, 4, 24, "Notes",
  CellTags->{"S0.4.7", "1.63"}],
Cell[11858, 486, 122, 4, 24, "Notes",
  CellTags->{"S0.4.7", "1.64"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12017, 495, 66, 1, 38, "Subsection",
  CellTags->{"S0.4.8", "1.65"}],
Cell[12086, 498, 174, 5, 24, "Notes",
  CellTags->{"S0.4.8", "1.66"}],
Cell[12263, 505, 97, 1, 24, "Notes",
  CellTags->{"S0.4.8", "1.67"}],
Cell[12363, 508, 148, 4, 24, "Notes",
  CellTags->{"S0.4.8", "1.68"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

