(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7982,        233]*)
(*NotebookOutlinePosition[     12252,        374]*)
(*  CellTagsIndexPosition[     11689,        347]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The Role of This Book", "Section",
  CellTags->{"S0.6.1", "1.1"}],

Cell[CellGroupData[{

Cell["The Scope of the Book", "Subsection",
  CellTags->{"S0.6.2", "1.2"}],

Cell[TextData[{
  "This book is intended to be a complete introduction to ",
  StyleBox["Mathematica", "TI"],
  ". It describes essentially all the capabilities of ",
  StyleBox["Mathematica", "TI"],
  ", and assumes no prior knowledge of the system. "
}], "Text",
  CellTags->{"S0.6.2", "1.3"}],

Cell[TextData[{
  "In most uses of ",
  StyleBox["Mathematica", "TI"],
  ", you will need to know only a small part of the system. This book is \
organized to make it easy for you to learn the part you need for a particular \
calculation. In many cases, for example, you may be able to set up your \
calculation simply by adapting some appropriate examples from the book. "
}], "Text",
  CellTags->{"S0.6.2", "1.4"}],

Cell["\<\
You should understand, however, that the examples in this book are \
chosen primarily for their simplicity, rather than to correspond to realistic \
calculations in particular application areas. \
\>", "Text",
  CellTags->{"S0.6.2", "1.5"}],

Cell[TextData[{
  "There are many other publications that discuss ",
  StyleBox["Mathematica", "TI"],
  " from the viewpoint of particular classes of applications. In some cases, \
you may find it better to read one of these publications first, and read this \
book only when you need a more general perspective on ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S0.6.2", "1.6"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is a system built on a fairly small set of very powerful principles. This \
book describes those principles, but by no means spells out all of their \
implications. In particular, while the book describes the elements that go \
into ",
  StyleBox["Mathematica", "TI"],
  " programs, it does not give detailed examples of complete programs. For \
those, you should look at other publications. "
}], "Text",
  CellTags->{"S0.6.2", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "SBO"],
  " System Described in the Book"
}], "Subsection",
  CellTags->{"S0.6.3", "1.8"}],

Cell[TextData[{
  "This book describes the standard ",
  StyleBox["Mathematica", "TI"],
  " kernel, as it exists on all computers that run ",
  StyleBox["Mathematica", "TI"],
  ". Most major supported features of the kernel in ",
  StyleBox["Mathematica", "TI"],
  " Version 5.2 are covered in this book. Many of the important features of \
the front end are also discussed. "
}], "Text",
  CellTags->{"S0.6.3", "1.9"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is an open software system that can be customized in a wide variety of \
ways. It is important to realize that this book covers only the full basic ",
  StyleBox["Mathematica", "TI"],
  " system. If your system is customized in some way, then it may behave \
differently from what is described in the book. "
}], "Text",
  CellTags->{"S0.6.3", "1.10"}],

Cell[TextData[{
  "The most common form of customization is the addition of various ",
  StyleBox["Mathematica", "TI"],
  " function definitions. These may come, for example, from loading a ",
  StyleBox["Mathematica", "TI"],
  " package. Sometimes the definitions may actually modify the behavior of \
functions described in this book. In other cases, the definitions may simply \
add a collection of new functions that are not described in the book. In \
certain applications, it may be primarily these new functions that you use, \
rather than the standard ones described in the book. "
}], "Text",
  CellTags->{"S0.6.3", "1.11"}],

Cell[TextData[{
  "This book describes what to do when you interact directly with the \
standard ",
  StyleBox["Mathematica", "TI"],
  " kernel and notebook front end. Sometimes, however, you may not be using \
the standard ",
  StyleBox["Mathematica", "TI"],
  " system directly. Instead, ",
  StyleBox["Mathematica", "TI"],
  " may be an embedded component of another system that you are using. This \
system may for example call on ",
  StyleBox["Mathematica", "TI"],
  " only for certain computations, and may hide the details of those \
computations from you. Most of what is in this book will only be useful if \
you can give explicit input to ",
  StyleBox["Mathematica", "TI"],
  ". If all of your input is substantially modified by the system you are \
using, then you must rely on the documentation for that system. "
}], "Text",
  CellTags->{"S0.6.3", "1.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Additional ",
  StyleBox["Mathematica", "SBO"],
  " Documentation"
}], "Subsection",
  CellTags->{"S0.6.4", "1.13"}],

Cell[TextData[{
  "For all standard versions of ",
  StyleBox["Mathematica", "TI"],
  ", the following is available in printed form, and can be ordered from \
Wolfram Research: "
}], "Text",
  CellTags->{"S0.6.4", "1.14"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Getting Started with Mathematica", "TI"],
  ": a booklet describing installation, basic operation, and troubleshooting \
of ",
  StyleBox["Mathematica", "TI"],
  " on specific computer systems.  "
}], "Notes",
  CellTags->{"S0.6.4", "1.15"}],

Cell[TextData[{
  "Extensive online documentation is included with most versions of ",
  StyleBox["Mathematica", "TI"],
  ". All such documentation can be accessed from the Help Browser in the ",
  StyleBox["Mathematica", "TI"],
  " notebook front end. "
}], "Text",
  CellTags->{"S0.6.4", "1.16"}],

Cell["\<\
In addition, the following sources of information are available on \
the web: \
\>", "Text",
  CellTags->{"S0.6.4", "1.17"}],

Cell[TextData[{
  "\[FilledSmallSquare] www.wolfram.com: the main Wolfram Research website.  \
\n\[FilledSmallSquare] documents.wolfram.com: full documentation for ",
  StyleBox["Mathematica", "TI"],
  ".  \n\[FilledSmallSquare] library.wolfram.com/infocenter: the ",
  StyleBox["Mathematica Information Center", "TI"],
  "\[LongDash]a central web repository for information on ",
  StyleBox["Mathematica", "TI"],
  " and its applications.  "
}], "Notes",
  CellTags->{"S0.6.4", "1.18"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.6.1"->{
    Cell[1776, 53, 71, 1, 65, "Section",
      CellTags->{"S0.6.1", "1.1"}]},
  "1.1"->{
    Cell[1776, 53, 71, 1, 65, "Section",
      CellTags->{"S0.6.1", "1.1"}]},
  "S0.6.2"->{
    Cell[1872, 58, 74, 1, 70, "Subsection",
      CellTags->{"S0.6.2", "1.2"}],
    Cell[1949, 61, 295, 7, 70, "Text",
      CellTags->{"S0.6.2", "1.3"}],
    Cell[2247, 70, 416, 8, 70, "Text",
      CellTags->{"S0.6.2", "1.4"}],
    Cell[2666, 80, 250, 5, 70, "Text",
      CellTags->{"S0.6.2", "1.5"}],
    Cell[2919, 87, 400, 9, 70, "Text",
      CellTags->{"S0.6.2", "1.6"}],
    Cell[3322, 98, 489, 10, 88, "Text",
      CellTags->{"S0.6.2", "1.7"}]},
  "1.2"->{
    Cell[1872, 58, 74, 1, 70, "Subsection",
      CellTags->{"S0.6.2", "1.2"}]},
  "1.3"->{
    Cell[1949, 61, 295, 7, 70, "Text",
      CellTags->{"S0.6.2", "1.3"}]},
  "1.4"->{
    Cell[2247, 70, 416, 8, 70, "Text",
      CellTags->{"S0.6.2", "1.4"}]},
  "1.5"->{
    Cell[2666, 80, 250, 5, 70, "Text",
      CellTags->{"S0.6.2", "1.5"}]},
  "1.6"->{
    Cell[2919, 87, 400, 9, 70, "Text",
      CellTags->{"S0.6.2", "1.6"}]},
  "1.7"->{
    Cell[3322, 98, 489, 10, 88, "Text",
      CellTags->{"S0.6.2", "1.7"}]},
  "S0.6.3"->{
    Cell[3848, 113, 142, 5, 70, "Subsection",
      CellTags->{"S0.6.3", "1.8"}],
    Cell[3993, 120, 419, 10, 72, "Text",
      CellTags->{"S0.6.3", "1.9"}],
    Cell[4415, 132, 405, 8, 72, "Text",
      CellTags->{"S0.6.3", "1.10"}],
    Cell[4823, 142, 633, 11, 120, "Text",
      CellTags->{"S0.6.3", "1.11"}],
    Cell[5459, 155, 871, 19, 136, "Text",
      CellTags->{"S0.6.3", "1.12"}]},
  "1.8"->{
    Cell[3848, 113, 142, 5, 70, "Subsection",
      CellTags->{"S0.6.3", "1.8"}]},
  "1.9"->{
    Cell[3993, 120, 419, 10, 72, "Text",
      CellTags->{"S0.6.3", "1.9"}]},
  "1.10"->{
    Cell[4415, 132, 405, 8, 72, "Text",
      CellTags->{"S0.6.3", "1.10"}]},
  "1.11"->{
    Cell[4823, 142, 633, 11, 120, "Text",
      CellTags->{"S0.6.3", "1.11"}]},
  "1.12"->{
    Cell[5459, 155, 871, 19, 136, "Text",
      CellTags->{"S0.6.3", "1.12"}]},
  "S0.6.4"->{
    Cell[6367, 179, 135, 5, 38, "Subsection",
      CellTags->{"S0.6.4", "1.13"}],
    Cell[6505, 186, 222, 6, 40, "Text",
      CellTags->{"S0.6.4", "1.14"}],
    Cell[6730, 194, 296, 8, 40, "Notes",
      CellTags->{"S0.6.4", "1.15"}],
    Cell[7029, 204, 298, 7, 56, "Text",
      CellTags->{"S0.6.4", "1.16"}],
    Cell[7330, 213, 134, 4, 24, "Text",
      CellTags->{"S0.6.4", "1.17"}],
    Cell[7467, 219, 487, 10, 84, "Notes",
      CellTags->{"S0.6.4", "1.18"}]},
  "1.13"->{
    Cell[6367, 179, 135, 5, 38, "Subsection",
      CellTags->{"S0.6.4", "1.13"}]},
  "1.14"->{
    Cell[6505, 186, 222, 6, 40, "Text",
      CellTags->{"S0.6.4", "1.14"}]},
  "1.15"->{
    Cell[6730, 194, 296, 8, 40, "Notes",
      CellTags->{"S0.6.4", "1.15"}]},
  "1.16"->{
    Cell[7029, 204, 298, 7, 56, "Text",
      CellTags->{"S0.6.4", "1.16"}]},
  "1.17"->{
    Cell[7330, 213, 134, 4, 24, "Text",
      CellTags->{"S0.6.4", "1.17"}]},
  "1.18"->{
    Cell[7467, 219, 487, 10, 84, "Notes",
      CellTags->{"S0.6.4", "1.18"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.6.1", 8597, 249},
  {"1.1", 8686, 252},
  {"S0.6.2", 8778, 255},
  {"1.2", 9246, 268},
  {"1.3", 9338, 271},
  {"1.4", 9425, 274},
  {"1.5", 9512, 277},
  {"1.6", 9599, 280},
  {"1.7", 9686, 283},
  {"S0.6.3", 9777, 286},
  {"1.8", 10183, 297},
  {"1.9", 10277, 300},
  {"1.10", 10367, 303},
  {"1.11", 10457, 306},
  {"1.12", 10549, 309},
  {"S0.6.4", 10643, 312},
  {"1.13", 11127, 325},
  {"1.14", 11223, 328},
  {"1.15", 11313, 331},
  {"1.16", 11404, 334},
  {"1.17", 11494, 337},
  {"1.18", 11584, 340}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 71, 1, 65, "Section",
  CellTags->{"S0.6.1", "1.1"}],

Cell[CellGroupData[{
Cell[1872, 58, 74, 1, 70, "Subsection",
  CellTags->{"S0.6.2", "1.2"}],
Cell[1949, 61, 295, 7, 70, "Text",
  CellTags->{"S0.6.2", "1.3"}],
Cell[2247, 70, 416, 8, 70, "Text",
  CellTags->{"S0.6.2", "1.4"}],
Cell[2666, 80, 250, 5, 70, "Text",
  CellTags->{"S0.6.2", "1.5"}],
Cell[2919, 87, 400, 9, 70, "Text",
  CellTags->{"S0.6.2", "1.6"}],
Cell[3322, 98, 489, 10, 88, "Text",
  CellTags->{"S0.6.2", "1.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3848, 113, 142, 5, 70, "Subsection",
  CellTags->{"S0.6.3", "1.8"}],
Cell[3993, 120, 419, 10, 72, "Text",
  CellTags->{"S0.6.3", "1.9"}],
Cell[4415, 132, 405, 8, 72, "Text",
  CellTags->{"S0.6.3", "1.10"}],
Cell[4823, 142, 633, 11, 120, "Text",
  CellTags->{"S0.6.3", "1.11"}],
Cell[5459, 155, 871, 19, 136, "Text",
  CellTags->{"S0.6.3", "1.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6367, 179, 135, 5, 38, "Subsection",
  CellTags->{"S0.6.4", "1.13"}],
Cell[6505, 186, 222, 6, 40, "Text",
  CellTags->{"S0.6.4", "1.14"}],
Cell[6730, 194, 296, 8, 40, "Notes",
  CellTags->{"S0.6.4", "1.15"}],
Cell[7029, 204, 298, 7, 56, "Text",
  CellTags->{"S0.6.4", "1.16"}],
Cell[7330, 213, 134, 4, 24, "Text",
  CellTags->{"S0.6.4", "1.17"}],
Cell[7467, 219, 487, 10, 84, "Notes",
  CellTags->{"S0.6.4", "1.18"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

