(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20522,        554]*)
(*NotebookOutlinePosition[     30551,        869]*)
(*  CellTagsIndexPosition[     29336,        815]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Suggestions about Learning ",
  StyleBox["Mathematica", "SBO"]
}], "Section",
  CellTags->{"S0.7.1", "1.1"}],

Cell[CellGroupData[{

Cell["Getting Started", "Subsection",
  CellTags->{"S0.7.1", "1.2"}],

Cell[TextData[{
  "As with any other computer system, there are a few points that you need to \
get straight before you can even start using ",
  StyleBox["Mathematica", "TI"],
  ". For example, you absolutely must know how to type your input to ",
  StyleBox["Mathematica", "TI"],
  ". To find out these kinds of basic points, you should read at least the \
first section of Part 1 in this book. "
}], "Text",
  CellTags->{"S0.7.1", "1.3"}],

Cell[TextData[{
  "Once you know the basics, you can begin to get a feeling for ",
  StyleBox["Mathematica", "TI"],
  " by typing in some examples from this book. Always be sure that you type \
in exactly what appears in the book\[LongDash]do not change any \
capitalization, bracketing, etc. "
}], "Text",
  CellTags->{"S0.7.1", "1.4"}],

Cell["\<\
After you have tried a few examples from the book, you should start \
experimenting for yourself. Change the examples slightly, and see what \
happens. You should look at each piece of output carefully, and try to \
understand why it came out as it did. \
\>", "Text",
  CellTags->{"S0.7.1", "1.5"}],

Cell[TextData[{
  "After you have run through some simple examples, you should be ready to \
take the next step: learning to go through what is needed to solve a complete \
problem with ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S0.7.1", "1.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solving a Complete Problem", "Subsection",
  CellTags->{"S0.7.1", "1.7"}],

Cell[TextData[{
  "You will probably find it best to start by picking a specific problem to \
work on. Pick a problem that you understand well\[LongDash]preferably one \
whose solution you could easily reproduce by hand. Then go through each step \
in solving the problem, learning what you need to know about ",
  StyleBox["Mathematica", "TI"],
  " to do it. Always be ready to experiment with simple cases, and understand \
the results you get with these, before going back to your original problem. "
}], "Text",
  CellTags->{"S0.7.1", "1.8"}],

Cell[TextData[{
  "In going through the steps to solve your problem, you will learn about \
various specific features of ",
  StyleBox["Mathematica", "TI"],
  ", typically from sections of Part 1. After you have done a few problems \
with ",
  StyleBox["Mathematica", "TI"],
  ", you should get a feeling for many of the basic features of the system. "
}], "Text",
  CellTags->{"S0.7.1", "1.9"}],

Cell[TextData[{
  "When you have built up a reasonable knowledge of the features of ",
  StyleBox["Mathematica", "TI"],
  ", you should go back and learn about the overall structure of the ",
  StyleBox["Mathematica", "TI"],
  " system. You can do this by systematically reading Part 2 of this book. \
What you will discover is that many of the features that seemed unrelated \
actually fit together into a coherent overall structure. Knowing this \
structure will make it much easier for you to understand and remember the \
specific features you have already learned.  "
}], "Text",
  CellTags->{"S0.7.1", "1.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "The Principles of ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S0.7.1", "1.11"}],

Cell[TextData[{
  "You should not try to learn the overall structure of ",
  StyleBox["Mathematica", "TI"],
  " too early. Unless you have had broad experience with advanced computer \
languages or pure mathematics, you will probably find Part 2 difficult to \
understand at first. You will find the structure and principles it describes \
difficult to remember, and you will always be wondering why particular \
aspects of them might be useful. However, if you first get some practical \
experience with ",
  StyleBox["Mathematica", "TI"],
  ", you will find the overall structure much easier to grasp. You should \
realize that the principles on which ",
  StyleBox["Mathematica", "TI"],
  " is built are very general, and it is usually difficult to understand such \
general principles before you have seen specific examples. "
}], "Text",
  CellTags->{"S0.7.1", "1.12"}],

Cell[TextData[{
  "One of the most important aspects of ",
  StyleBox["Mathematica", "TI"],
  " is that it applies a fairly small number of principles as widely as \
possible. This means that even though you have used a particular feature only \
in a specific situation, the principle on which that feature is based can \
probably be applied in many other situations. One reason it is so important \
to understand the underlying principles of ",
  StyleBox["Mathematica", "TI"],
  " is that by doing so you can leverage your knowledge of specific features \
into a more general context. As an example, you may first learn about \
transformation rules in the context of algebraic expressions. "
}], "Text",
  CellTags->{"S0.7.1", "1.13"}],

Cell[TextData[{
  "But the basic principle of transformation rules applies to any symbolic \
expression. Thus you can also use such rules to modify the structure of, say, \
an expression that represents a ",
  StyleBox["Mathematica", "TI"],
  " graphics object. "
}], "Text",
  CellTags->{"S0.7.1", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing the Way You Work", "Subsection",
  CellTags->{"S0.7.1", "1.15"}],

Cell[TextData[{
  "Learning to use ",
  StyleBox["Mathematica", "TI"],
  " well involves changing the way you solve problems. When you move from \
pencil and paper to ",
  StyleBox["Mathematica", "TI"],
  " the balance of what aspects of problem solving are difficult changes. \
With pencil and paper, you can often get by with a fairly imprecise initial \
formulation of your problem. Then when you actually do calculations in \
solving the problem, you can usually fix up the formulation as you go along. \
However, the calculations you do have to be fairly simple, and you cannot \
afford to try out many different cases. "
}], "Text",
  CellTags->{"S0.7.1", "1.16"}],

Cell[TextData[{
  "When you use ",
  StyleBox["Mathematica", "TI"],
  ", on the other hand, the initial formulation of your problem has to be \
quite precise. However, once you have the formulation, you can easily do many \
different calculations with it. This means that you can effectively carry out \
many mathematical experiments on your problem. By looking at the results you \
get, you can then refine the original formulation of your problem.  "
}], "Text",
  CellTags->{"S0.7.1", "1.17"}],

Cell[TextData[{
  "There are typically many different ways to formulate a given prob\[Hyphen] \
lem in ",
  StyleBox["Mathematica", "TI"],
  ". In almost all cases, however, the most direct and simple formulations \
will be best. The more you can formulate your problem in ",
  StyleBox["Mathematica", "TI"],
  " from the beginning, the better. Often, in fact, you will find that \
formulating your problem directly in ",
  StyleBox["Mathematica", "TI"],
  " is better than first trying to set up a traditional mathematical \
formulation, say an algebraic one. The main point is that ",
  StyleBox["Mathematica", "TI"],
  " allows you to express not only traditional mathematical operations, but \
also algorithmic and structural ones. This greater range of possibilities \
gives you a better chance of being able to find a direct way to represent \
your original problem. "
}], "Text",
  CellTags->{"S0.7.1", "1.18"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing Programs", "Subsection",
  CellTags->{"S0.7.1", "1.19"}],

Cell[TextData[{
  "For most of the more sophisticated problems that you want to solve with ",
  StyleBox["Mathematica", "TI"],
  ", you will have to create ",
  StyleBox["Mathematica", "TI"],
  " programs. ",
  StyleBox["Mathematica", "TI"],
  " supports several types of programming, and you have to choose which one \
to use in each case. It turns out that no single type of programming suits \
all cases well. As a result, it is very important that you learn several \
different types of programming. "
}], "Text",
  CellTags->{"S0.7.1", "1.20"}],

Cell[TextData[{
  "If you already know a traditional programming language such as BASIC, C, \
Fortran, Perl or Java, you will probably find it easiest to learn procedural \
programming in ",
  StyleBox["Mathematica", "TI"],
  ", using ",
  StyleBox["Do", "MR"],
  ", ",
  StyleBox["For", "MR"],
  " and so on. But while almost any ",
  StyleBox["Mathematica", "TI"],
  " program can, in principle, be written in a procedural way, this is rarely \
the best approach. In a symbolic system like ",
  StyleBox["Mathematica", "TI"],
  ", functional and rule\[Hyphen]based programming typically yields programs \
that are more efficient, and easier to understand."
}], "Text",
  CellTags->{"S0.7.1", "1.21"}],

Cell[TextData[{
  "If you find yourself using procedural programming a lot, you should make \
an active effort to convert at least some of your programs to other types. At \
first, you may find functional and rule\[Hyphen]based programs difficult to \
understand. But after a while, you will find that their global structure is \
usually much easier to grasp than procedural programs. And as your experience \
with ",
  StyleBox["Mathematica", "TI"],
  " grows over a period of months or years, you will probably find that you \
write more and more of your programs in non\[Hyphen]procedural ways.  "
}], "Text",
  CellTags->{"S0.7.1", "1.22"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Learning the Whole System", "Subsection",
  CellTags->{"S0.7.1", "1.23"}],

Cell[TextData[{
  "As you proceed in using and learning ",
  StyleBox["Mathematica", "TI"],
  ", it is important to remember that ",
  StyleBox["Mathematica", "TI"],
  " is a large system. Although after a while you should know all of its \
basic principles, you may never learn the details of all its features. As a \
result, even after you have had a great deal of experience with ",
  StyleBox["Mathematica", "TI"],
  ", you will undoubtedly still find it useful to look through this book. \
When you do so, you are quite likely to notice features that you never \
noticed before, but that with your experience, you can now see how to use. "
}], "Text",
  CellTags->{"S0.7.1", "1.24"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["How to Read This Book", "Subsection",
  CellTags->{"S0.7.1", "1.25"}],

Cell[TextData[{
  "If at all possible, you should read this book in conjunction with using an \
actual ",
  StyleBox["Mathematica", "TI"],
  " system. When you see examples in the book, you should try them out on \
your computer. "
}], "Text",
  CellTags->{"S0.7.1", "1.26"}],

Cell[TextData[{
  "You can get a basic feeling for what ",
  StyleBox["Mathematica", "TI"],
  " does by looking at \[OpenCurlyDoubleQuote]A Tour of ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyDoubleQuote] in Section\[NonBreakingSpace]",
  ButtonBox["T.0",
    ButtonData:>{"T.0", "0.0"},
    ButtonStyle->"MainBookLink"],
  ". You may also find it useful to try out examples from this Tour with your \
own copy of ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S0.7.1", "1.27"}],

Cell[TextData[{
  "Whatever your background, you should make sure to look at the first three \
or four sections in Part 1 before you start to use ",
  StyleBox["Mathematica", "TI"],
  " on your own. These sections describe the basics that you need to know in \
order to use ",
  StyleBox["Mathematica", "TI"],
  " at any level. "
}], "Text",
  CellTags->{"S0.7.1", "1.28"}],

Cell[TextData[{
  "The remainder of Part 1 shows you how to do many different kinds of \
computations with ",
  StyleBox["Mathematica", "TI"],
  ". If you are trying to do a specific calculation, you will often find it \
sufficient just to look at the sections of Part 1 that discuss the features \
of ",
  StyleBox["Mathematica", "TI"],
  " you need to use. A good approach is to try and find examples in the book \
which are close to what you want to do. "
}], "Text",
  CellTags->{"S0.7.1", "1.29"}],

Cell[TextData[{
  "The emphasis in Part 1 is on using the basic functions that are built into \
",
  StyleBox["Mathematica", "TI"],
  " to carry out various different kinds of computations. "
}], "Text",
  CellTags->{"S0.7.1", "1.30"}],

Cell[TextData[{
  "Part 2, on the other hand, discusses the basic structure and principles \
that underlie all of ",
  StyleBox["Mathematica", "TI"],
  ". Rather than describing a sequence of specific features, Part 2 takes a \
more global approach. If you want to learn how to create your own ",
  StyleBox["Mathematica", "TI"],
  " functions, you should read Part 2.  "
}], "Text",
  CellTags->{"S0.7.1", "1.31"}],

Cell[TextData[{
  "Part 3 is intended for those with more sophisticated mathematical \
interests and knowledge. It covers the more advanced mathematical features of \
",
  StyleBox["Mathematica", "TI"],
  ", as well as describing some features already mentioned in Part 1 in \
greater mathematical detail. "
}], "Text",
  CellTags->{"S0.7.1", "1.32"}],

Cell["\<\
Each part of the book is divided into sections and subsections. \
There are two special kinds of subsections, indicated by the following \
headings:  \
\>", "Text",
  CellTags->{"S0.7.1", "1.33"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Advanced Topic:", "SB"],
  " Advanced material which can be omitted on a first reading. \n\
\[FilledSmallSquare] ",
  StyleBox["Special Topic:", "SB"],
  " Material relevant only for certain users or certain computer systems. "
}], "Notes",
  CellTags->{"S0.7.1", "1.34"}],

Cell[TextData[{
  "The main parts in this book are intended to be pedagogical, and can \
meaningfully be read in a sequential fashion. The Appendix, however, is \
intended solely for reference purposes. Once you are familiar with ",
  StyleBox["Mathematica", "TI"],
  ", you will probably find the list of functions in the Appendix the best \
place to look up details you need. "
}], "Text",
  CellTags->{"S0.7.1", "1.35"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["About the Examples in This Book", "Subsection",
  CellTags->{"S0.7.1", "1.36"}],

Cell[TextData[{
  "All the examples given in this book were generated by running an actual \
copy of ",
  StyleBox["Mathematica", "TI"],
  " Version 5.2. If you have a copy of this version, you should be able to \
reproduce the examples on your computer as they appear in the book. "
}], "Text",
  CellTags->{"S0.7.1", "1.37"}],

Cell["There are, however, a few points to watch: ", "Text",
  CellTags->{"S0.7.1", "1.38"}],

Cell[TextData[{
  "\[FilledSmallSquare] Until you are familiar with ",
  StyleBox["Mathematica", "TI"],
  ", make sure to type the input ",
  StyleBox["exactly", "TI"],
  " as it appears in the book. Do not change any of the capital letters or \
brackets. Later, you will learn what things you can change. When you start \
out, however, it is important that you do not make any changes; otherwise you \
may not get the same results as in the book. "
}], "Notes",
  CellTags->{"S0.7.1", "1.39"}],

Cell[TextData[{
  "\[FilledSmallSquare] Never type the prompt ",
  StyleBox["In[", "MB"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MB"],
  " that begins each input line. Type only the text that follows this prompt. \
"
}], "Notes",
  CellTags->{"S0.7.1", "1.40"}],

Cell[TextData[{
  "\[FilledSmallSquare] You will see that the lines in each dialog are \
numbered in sequence. Most subsections in the book contain separate dialogs. \
To make sure you get exactly what the book says, you should start a new ",
  StyleBox["Mathematica", "TI"],
  " session each time the book does. "
}], "Notes",
  CellTags->{"S0.7.1", "1.41"}],

Cell["\<\
\[FilledSmallSquare] Some \[OpenCurlyDoubleQuote]Special Topic\
\[CloseCurlyDoubleQuote] subsections give examples that may be specific to \
particular computer systems.  \
\>", "Notes",
  CellTags->{"S0.7.1", "1.42"}],

Cell[TextData[{
  "\[FilledSmallSquare] Any examples that involve random numbers will \
generally give different results than in the book, since the sequence of \
random numbers produced by ",
  StyleBox["Mathematica", "TI"],
  " is different in every session.  "
}], "Notes",
  CellTags->{"S0.7.1", "1.43"}],

Cell[TextData[{
  "\[FilledSmallSquare] Some examples that use machine\[Hyphen]precision \
arithmetic may come out differently on different computer systems. This is a \
result of differences in floating\[Hyphen]point hardware. If you use \
arbitrary\[Hyphen]precision ",
  StyleBox["Mathematica", "TI"],
  " numbers, you should not see differences. "
}], "Notes",
  CellTags->{"S0.7.1", "1.44"}],

Cell[TextData[{
  "\[FilledSmallSquare] Almost all of the examples show output as it would be \
generated in ",
  StyleBox["StandardForm", "MR"],
  " with a notebook interface to ",
  StyleBox["Mathematica", "TI"],
  ". Output with a text\[Hyphen]based interface will look similar, but not \
identical. "
}], "Notes",
  CellTags->{"S0.7.1", "1.45"}],

Cell[TextData[{
  "\[FilledSmallSquare] Almost all of the examples in this book assume that \
your computer or terminal uses a standard U.S. ASCII character set. If you \
cannot find some of the characters you need on your keyboard, or if ",
  StyleBox["Mathematica", "TI"],
  " prints out different characters than you see in the book, you will need \
to look at your computer documentation to find the correspondence with the \
character set you are using. The most common problem is that the dollar sign \
character (Shift\[Hyphen]4) may come out as your local currency character."
}], "Notes",
  CellTags->{"S0.7.1", "1.46"}],

Cell[TextData[{
  "\[FilledSmallSquare] If the version of ",
  StyleBox["Mathematica", "TI"],
  " is more recent than the one used to produce this book, then it is \
possible that some results you get may be different. "
}], "Notes",
  CellTags->{"S0.7.1", "1.47"}],

Cell[TextData[{
  "\[FilledSmallSquare] Most of the examples in \[OpenCurlyDoubleQuote]A Tour \
of ",
  StyleBox["Mathematica", "TI"],
  "\[CloseCurlyDoubleQuote], as well as Parts 1 and 2, are chosen so as to be \
fairly quick to execute. Assuming you have a machine with a clock speed of \
over about 1 GHz (and most machines produced in 2003 or later do), then \
almost none of the examples should take anything more than a small fraction \
of a second to execute. If they do, there is probably something wrong. \
Section ",
  ButtonBox["1.3.12",
    ButtonData:>{"1.3.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  " describes how to stop the calculation. "
}], "Notes",
  CellTags->{"S0.7.1", "1.48"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S0.7.1"->{
    Cell[1776, 53, 127, 4, 65, "Section",
      CellTags->{"S0.7.1", "1.1"}],
    Cell[1928, 61, 68, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.2"}],
    Cell[1999, 64, 441, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.3"}],
    Cell[2443, 75, 337, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.4"}],
    Cell[2783, 84, 309, 6, 70, "Text",
      CellTags->{"S0.7.1", "1.5"}],
    Cell[3095, 92, 271, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.6"}],
    Cell[3403, 104, 79, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.7"}],
    Cell[3485, 107, 546, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.8"}],
    Cell[4034, 118, 395, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.9"}],
    Cell[4432, 129, 616, 11, 70, "Text",
      CellTags->{"S0.7.1", "1.10"}],
    Cell[5085, 145, 122, 4, 70, "Subsection",
      CellTags->{"S0.7.1", "1.11"}],
    Cell[5210, 151, 874, 16, 70, "Text",
      CellTags->{"S0.7.1", "1.12"}],
    Cell[6087, 169, 737, 13, 70, "Text",
      CellTags->{"S0.7.1", "1.13"}],
    Cell[6827, 184, 307, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.14"}],
    Cell[7171, 196, 79, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.15"}],
    Cell[7253, 199, 670, 13, 70, "Text",
      CellTags->{"S0.7.1", "1.16"}],
    Cell[7926, 214, 496, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.17"}],
    Cell[8425, 225, 918, 18, 70, "Text",
      CellTags->{"S0.7.1", "1.18"}],
    Cell[9380, 248, 70, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.19"}],
    Cell[9453, 251, 549, 12, 70, "Text",
      CellTags->{"S0.7.1", "1.20"}],
    Cell[10005, 265, 702, 17, 70, "Text",
      CellTags->{"S0.7.1", "1.21"}],
    Cell[10710, 284, 644, 11, 70, "Text",
      CellTags->{"S0.7.1", "1.22"}],
    Cell[11391, 300, 79, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.23"}],
    Cell[11473, 303, 688, 13, 70, "Text",
      CellTags->{"S0.7.1", "1.24"}],
    Cell[12198, 321, 75, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.25"}],
    Cell[12276, 324, 275, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.26"}],
    Cell[12554, 333, 507, 14, 70, "Text",
      CellTags->{"S0.7.1", "1.27"}],
    Cell[13064, 349, 373, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.28"}],
    Cell[13440, 360, 502, 11, 70, "Text",
      CellTags->{"S0.7.1", "1.29"}],
    Cell[13945, 373, 235, 6, 70, "Text",
      CellTags->{"S0.7.1", "1.30"}],
    Cell[14183, 381, 415, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.31"}],
    Cell[14601, 392, 351, 8, 70, "Text",
      CellTags->{"S0.7.1", "1.32"}],
    Cell[14955, 402, 206, 5, 70, "Text",
      CellTags->{"S0.7.1", "1.33"}],
    Cell[15164, 409, 327, 8, 70, "Notes",
      CellTags->{"S0.7.1", "1.34"}],
    Cell[15494, 419, 423, 8, 70, "Text",
      CellTags->{"S0.7.1", "1.35"}],
    Cell[15954, 432, 85, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.36"}],
    Cell[16042, 435, 327, 7, 56, "Text",
      CellTags->{"S0.7.1", "1.37"}],
    Cell[16372, 444, 91, 1, 70, "Text",
      CellTags->{"S0.7.1", "1.38"}],
    Cell[16466, 447, 494, 10, 88, "Notes",
      CellTags->{"S0.7.1", "1.39"}],
    Cell[16963, 459, 264, 8, 40, "Notes",
      CellTags->{"S0.7.1", "1.40"}],
    Cell[17230, 469, 359, 7, 56, "Notes",
      CellTags->{"S0.7.1", "1.41"}],
    Cell[17592, 478, 228, 5, 40, "Notes",
      CellTags->{"S0.7.1", "1.42"}],
    Cell[17823, 485, 308, 7, 56, "Notes",
      CellTags->{"S0.7.1", "1.43"}],
    Cell[18134, 494, 396, 8, 56, "Notes",
      CellTags->{"S0.7.1", "1.44"}],
    Cell[18533, 504, 349, 9, 56, "Notes",
      CellTags->{"S0.7.1", "1.45"}],
    Cell[18885, 515, 629, 10, 104, "Notes",
      CellTags->{"S0.7.1", "1.46"}],
    Cell[19517, 527, 265, 6, 40, "Notes",
      CellTags->{"S0.7.1", "1.47"}],
    Cell[19785, 535, 709, 15, 104, "Notes",
      CellTags->{"S0.7.1", "1.48"}]},
  "1.1"->{
    Cell[1776, 53, 127, 4, 65, "Section",
      CellTags->{"S0.7.1", "1.1"}]},
  "1.2"->{
    Cell[1928, 61, 68, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.2"}]},
  "1.3"->{
    Cell[1999, 64, 441, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.3"}]},
  "1.4"->{
    Cell[2443, 75, 337, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.4"}]},
  "1.5"->{
    Cell[2783, 84, 309, 6, 70, "Text",
      CellTags->{"S0.7.1", "1.5"}]},
  "1.6"->{
    Cell[3095, 92, 271, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.6"}]},
  "1.7"->{
    Cell[3403, 104, 79, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.7"}]},
  "1.8"->{
    Cell[3485, 107, 546, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.8"}]},
  "1.9"->{
    Cell[4034, 118, 395, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.9"}]},
  "1.10"->{
    Cell[4432, 129, 616, 11, 70, "Text",
      CellTags->{"S0.7.1", "1.10"}]},
  "1.11"->{
    Cell[5085, 145, 122, 4, 70, "Subsection",
      CellTags->{"S0.7.1", "1.11"}]},
  "1.12"->{
    Cell[5210, 151, 874, 16, 70, "Text",
      CellTags->{"S0.7.1", "1.12"}]},
  "1.13"->{
    Cell[6087, 169, 737, 13, 70, "Text",
      CellTags->{"S0.7.1", "1.13"}]},
  "1.14"->{
    Cell[6827, 184, 307, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.14"}]},
  "1.15"->{
    Cell[7171, 196, 79, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.15"}]},
  "1.16"->{
    Cell[7253, 199, 670, 13, 70, "Text",
      CellTags->{"S0.7.1", "1.16"}]},
  "1.17"->{
    Cell[7926, 214, 496, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.17"}]},
  "1.18"->{
    Cell[8425, 225, 918, 18, 70, "Text",
      CellTags->{"S0.7.1", "1.18"}]},
  "1.19"->{
    Cell[9380, 248, 70, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.19"}]},
  "1.20"->{
    Cell[9453, 251, 549, 12, 70, "Text",
      CellTags->{"S0.7.1", "1.20"}]},
  "1.21"->{
    Cell[10005, 265, 702, 17, 70, "Text",
      CellTags->{"S0.7.1", "1.21"}]},
  "1.22"->{
    Cell[10710, 284, 644, 11, 70, "Text",
      CellTags->{"S0.7.1", "1.22"}]},
  "1.23"->{
    Cell[11391, 300, 79, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.23"}]},
  "1.24"->{
    Cell[11473, 303, 688, 13, 70, "Text",
      CellTags->{"S0.7.1", "1.24"}]},
  "1.25"->{
    Cell[12198, 321, 75, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.25"}]},
  "1.26"->{
    Cell[12276, 324, 275, 7, 70, "Text",
      CellTags->{"S0.7.1", "1.26"}]},
  "1.27"->{
    Cell[12554, 333, 507, 14, 70, "Text",
      CellTags->{"S0.7.1", "1.27"}]},
  "1.28"->{
    Cell[13064, 349, 373, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.28"}]},
  "1.29"->{
    Cell[13440, 360, 502, 11, 70, "Text",
      CellTags->{"S0.7.1", "1.29"}]},
  "1.30"->{
    Cell[13945, 373, 235, 6, 70, "Text",
      CellTags->{"S0.7.1", "1.30"}]},
  "1.31"->{
    Cell[14183, 381, 415, 9, 70, "Text",
      CellTags->{"S0.7.1", "1.31"}]},
  "1.32"->{
    Cell[14601, 392, 351, 8, 70, "Text",
      CellTags->{"S0.7.1", "1.32"}]},
  "1.33"->{
    Cell[14955, 402, 206, 5, 70, "Text",
      CellTags->{"S0.7.1", "1.33"}]},
  "1.34"->{
    Cell[15164, 409, 327, 8, 70, "Notes",
      CellTags->{"S0.7.1", "1.34"}]},
  "1.35"->{
    Cell[15494, 419, 423, 8, 70, "Text",
      CellTags->{"S0.7.1", "1.35"}]},
  "1.36"->{
    Cell[15954, 432, 85, 1, 70, "Subsection",
      CellTags->{"S0.7.1", "1.36"}]},
  "1.37"->{
    Cell[16042, 435, 327, 7, 56, "Text",
      CellTags->{"S0.7.1", "1.37"}]},
  "1.38"->{
    Cell[16372, 444, 91, 1, 70, "Text",
      CellTags->{"S0.7.1", "1.38"}]},
  "1.39"->{
    Cell[16466, 447, 494, 10, 88, "Notes",
      CellTags->{"S0.7.1", "1.39"}]},
  "1.40"->{
    Cell[16963, 459, 264, 8, 40, "Notes",
      CellTags->{"S0.7.1", "1.40"}]},
  "1.41"->{
    Cell[17230, 469, 359, 7, 56, "Notes",
      CellTags->{"S0.7.1", "1.41"}]},
  "1.42"->{
    Cell[17592, 478, 228, 5, 40, "Notes",
      CellTags->{"S0.7.1", "1.42"}]},
  "1.43"->{
    Cell[17823, 485, 308, 7, 56, "Notes",
      CellTags->{"S0.7.1", "1.43"}]},
  "1.44"->{
    Cell[18134, 494, 396, 8, 56, "Notes",
      CellTags->{"S0.7.1", "1.44"}]},
  "1.45"->{
    Cell[18533, 504, 349, 9, 56, "Notes",
      CellTags->{"S0.7.1", "1.45"}]},
  "1.46"->{
    Cell[18885, 515, 629, 10, 104, "Notes",
      CellTags->{"S0.7.1", "1.46"}]},
  "1.47"->{
    Cell[19517, 527, 265, 6, 40, "Notes",
      CellTags->{"S0.7.1", "1.47"}]},
  "1.48"->{
    Cell[19785, 535, 709, 15, 104, "Notes",
      CellTags->{"S0.7.1", "1.48"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S0.7.1", 21137, 570},
  {"1.1", 24928, 667},
  {"1.2", 25018, 670},
  {"1.3", 25110, 673},
  {"1.4", 25197, 676},
  {"1.5", 25284, 679},
  {"1.6", 25371, 682},
  {"1.7", 25458, 685},
  {"1.8", 25551, 688},
  {"1.9", 25639, 691},
  {"1.10", 25728, 694},
  {"1.11", 25819, 697},
  {"1.12", 25915, 700},
  {"1.13", 26006, 703},
  {"1.14", 26097, 706},
  {"1.15", 26187, 709},
  {"1.16", 26282, 712},
  {"1.17", 26373, 715},
  {"1.18", 26463, 718},
  {"1.19", 26554, 721},
  {"1.20", 26649, 724},
  {"1.21", 26740, 727},
  {"1.22", 26832, 730},
  {"1.23", 26924, 733},
  {"1.24", 27020, 736},
  {"1.25", 27112, 739},
  {"1.26", 27208, 742},
  {"1.27", 27299, 745},
  {"1.28", 27391, 748},
  {"1.29", 27482, 751},
  {"1.30", 27574, 754},
  {"1.31", 27665, 757},
  {"1.32", 27756, 760},
  {"1.33", 27847, 763},
  {"1.34", 27938, 766},
  {"1.35", 28030, 769},
  {"1.36", 28121, 772},
  {"1.37", 28217, 775},
  {"1.38", 28308, 778},
  {"1.39", 28398, 781},
  {"1.40", 28491, 784},
  {"1.41", 28583, 787},
  {"1.42", 28675, 790},
  {"1.43", 28767, 793},
  {"1.44", 28859, 796},
  {"1.45", 28951, 799},
  {"1.46", 29043, 802},
  {"1.47", 29137, 805},
  {"1.48", 29229, 808}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 127, 4, 65, "Section",
  CellTags->{"S0.7.1", "1.1"}],

Cell[CellGroupData[{
Cell[1928, 61, 68, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.2"}],
Cell[1999, 64, 441, 9, 70, "Text",
  CellTags->{"S0.7.1", "1.3"}],
Cell[2443, 75, 337, 7, 70, "Text",
  CellTags->{"S0.7.1", "1.4"}],
Cell[2783, 84, 309, 6, 70, "Text",
  CellTags->{"S0.7.1", "1.5"}],
Cell[3095, 92, 271, 7, 70, "Text",
  CellTags->{"S0.7.1", "1.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3403, 104, 79, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.7"}],
Cell[3485, 107, 546, 9, 70, "Text",
  CellTags->{"S0.7.1", "1.8"}],
Cell[4034, 118, 395, 9, 70, "Text",
  CellTags->{"S0.7.1", "1.9"}],
Cell[4432, 129, 616, 11, 70, "Text",
  CellTags->{"S0.7.1", "1.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5085, 145, 122, 4, 70, "Subsection",
  CellTags->{"S0.7.1", "1.11"}],
Cell[5210, 151, 874, 16, 70, "Text",
  CellTags->{"S0.7.1", "1.12"}],
Cell[6087, 169, 737, 13, 70, "Text",
  CellTags->{"S0.7.1", "1.13"}],
Cell[6827, 184, 307, 7, 70, "Text",
  CellTags->{"S0.7.1", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7171, 196, 79, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.15"}],
Cell[7253, 199, 670, 13, 70, "Text",
  CellTags->{"S0.7.1", "1.16"}],
Cell[7926, 214, 496, 9, 70, "Text",
  CellTags->{"S0.7.1", "1.17"}],
Cell[8425, 225, 918, 18, 70, "Text",
  CellTags->{"S0.7.1", "1.18"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9380, 248, 70, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.19"}],
Cell[9453, 251, 549, 12, 70, "Text",
  CellTags->{"S0.7.1", "1.20"}],
Cell[10005, 265, 702, 17, 70, "Text",
  CellTags->{"S0.7.1", "1.21"}],
Cell[10710, 284, 644, 11, 70, "Text",
  CellTags->{"S0.7.1", "1.22"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11391, 300, 79, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.23"}],
Cell[11473, 303, 688, 13, 70, "Text",
  CellTags->{"S0.7.1", "1.24"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12198, 321, 75, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.25"}],
Cell[12276, 324, 275, 7, 70, "Text",
  CellTags->{"S0.7.1", "1.26"}],
Cell[12554, 333, 507, 14, 70, "Text",
  CellTags->{"S0.7.1", "1.27"}],
Cell[13064, 349, 373, 9, 70, "Text",
  CellTags->{"S0.7.1", "1.28"}],
Cell[13440, 360, 502, 11, 70, "Text",
  CellTags->{"S0.7.1", "1.29"}],
Cell[13945, 373, 235, 6, 70, "Text",
  CellTags->{"S0.7.1", "1.30"}],
Cell[14183, 381, 415, 9, 70, "Text",
  CellTags->{"S0.7.1", "1.31"}],
Cell[14601, 392, 351, 8, 70, "Text",
  CellTags->{"S0.7.1", "1.32"}],
Cell[14955, 402, 206, 5, 70, "Text",
  CellTags->{"S0.7.1", "1.33"}],
Cell[15164, 409, 327, 8, 70, "Notes",
  CellTags->{"S0.7.1", "1.34"}],
Cell[15494, 419, 423, 8, 70, "Text",
  CellTags->{"S0.7.1", "1.35"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15954, 432, 85, 1, 70, "Subsection",
  CellTags->{"S0.7.1", "1.36"}],
Cell[16042, 435, 327, 7, 56, "Text",
  CellTags->{"S0.7.1", "1.37"}],
Cell[16372, 444, 91, 1, 70, "Text",
  CellTags->{"S0.7.1", "1.38"}],
Cell[16466, 447, 494, 10, 88, "Notes",
  CellTags->{"S0.7.1", "1.39"}],
Cell[16963, 459, 264, 8, 40, "Notes",
  CellTags->{"S0.7.1", "1.40"}],
Cell[17230, 469, 359, 7, 56, "Notes",
  CellTags->{"S0.7.1", "1.41"}],
Cell[17592, 478, 228, 5, 40, "Notes",
  CellTags->{"S0.7.1", "1.42"}],
Cell[17823, 485, 308, 7, 56, "Notes",
  CellTags->{"S0.7.1", "1.43"}],
Cell[18134, 494, 396, 8, 56, "Notes",
  CellTags->{"S0.7.1", "1.44"}],
Cell[18533, 504, 349, 9, 56, "Notes",
  CellTags->{"S0.7.1", "1.45"}],
Cell[18885, 515, 629, 10, 104, "Notes",
  CellTags->{"S0.7.1", "1.46"}],
Cell[19517, 527, 265, 6, 40, "Notes",
  CellTags->{"S0.7.1", "1.47"}],
Cell[19785, 535, 709, 15, 104, "Notes",
  CellTags->{"S0.7.1", "1.48"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

