(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27968,        667]*)
(*NotebookOutlinePosition[     35160,        898]*)
(*  CellTagsIndexPosition[     34344,        860]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Part 1", "Chapter",
  CellTags->{"S1", "0.1"}],

Cell[TextData[{
  "This Part gives a self\[Hyphen]contained introduction to ",
  StyleBox["Mathematica", "TI"],
  ", concentrating on using ",
  StyleBox["Mathematica", "TI"],
  " as an interactive problem\[Hyphen]solving system. "
}], "Text",
  CellTags->{"S1", "0.2"}],

Cell[TextData[{
  "When you have read this Part, you should have sufficient knowledge of ",
  StyleBox["Mathematica", "TI"],
  " to tackle many kinds of practical problems. "
}], "Text",
  CellTags->{"S1", "0.3"}],

Cell[TextData[{
  "You should realize, however, that what is discussed in this Part is in \
many respects just the surface of ",
  StyleBox["Mathematica", "TI"],
  ". Underlying all the various features and capabilities that are discussed, \
there are powerful and general principles. These principles are discussed in \
Part 2. To get the most out of ",
  StyleBox["Mathematica", "TI"],
  ", you will need to understand them. "
}], "Text",
  CellTags->{"S1", "0.4"}],

Cell[TextData[{
  "This Part does not assume that you have used a computer before. In \
addition, most of the material in it requires no knowledge of mathematics \
beyond high\[Hyphen]school level. The more advanced mathematical aspects of \
",
  StyleBox["Mathematica", "TI"],
  " are discussed in Part 3 of this book. "
}], "Text",
  CellTags->{"S1", "0.5"}],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.0 ", "HeadingNumber"],
  "Running ",
  StyleBox["Mathematica", "SBO"]
}], "Section",
  CellTags->{"S1.0.0", "0.6"}],

Cell[TextData[{
  "To find out how to install and run ",
  StyleBox["Mathematica", "TI"],
  " you should read the documentation that came with your copy of ",
  StyleBox["Mathematica", "TI"],
  ". The details differ from one computer system to another, and are affected \
by various kinds of customization that can be done on ",
  StyleBox["Mathematica", "TI"],
  ". Nevertheless, this section outlines two common cases.  "
}], "Text",
  CellTags->{"S1.0.0", "0.7"}],

Cell[TextData[{
  "Note that although the details of running ",
  StyleBox["Mathematica", "TI"],
  " differ from one computer system to another, the structure of ",
  StyleBox["Mathematica", "TI"],
  " calculations is the same in all cases. You enter input, then ",
  StyleBox["Mathematica", "TI"],
  " processes it, and returns a result. "
}], "Text",
  CellTags->{"S1.0.0", "0.8"}],

Cell[CellGroupData[{

Cell["1.0.1 Notebook Interfaces", "Subsection",
  CellTags->{"S1.0.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "use an icon or the ",
              StyleBox["Start", "SR"],
              " menu "
            }]], Cell[TextData[{
              "graphical ways to start ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["mathematica", "MR"],
              " "
            }]], Cell[TextData[{
              "the shell command to start ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell["text ending with Shift\[Hyphen]Enter "], Cell[TextData[{
              "input for ",
              StyleBox["Mathematica", "TI"],
              " (Shift\[Hyphen]Return on some keyboards) "
            }]]},
          {Cell[TextData[{
              "choose the ",
              StyleBox["Quit", "SR"],
              " menu item "
            }]], Cell[TextData[{
              "exiting ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S1.0.1"],

Cell[TextData[{
  "Running ",
  StyleBox["Mathematica", "SO"],
  " with a notebook interface. "
}], "Caption",
  CellTags->"S1.0.1"],

Cell[TextData[{
  "In a \[OpenCurlyDoubleQuote]notebook\[CloseCurlyDoubleQuote] interface, \
you interact with ",
  StyleBox["Mathematica", "TI"],
  " by creating interactive documents.  "
}], "Text",
  CellTags->{"S1.0.1", "1.2"}],

Cell[TextData[{
  "If you use your computer via a purely graphical interface, you will \
typically double\[Hyphen]click the ",
  StyleBox["Mathematica", "TI"],
  " icon to start ",
  StyleBox["Mathematica", "TI"],
  ". If you use your computer via a textually based operating system, you \
will typically type the command ",
  StyleBox["mathematica", "MR"],
  " to start ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"S1.0.1", "1.3"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " starts up, it usually gives you a blank notebook. You enter ",
  StyleBox["Mathematica", "TI"],
  " input into the notebook, then type Shift\[Hyphen]Enter to make ",
  StyleBox["Mathematica", "TI"],
  " process your input. (To type Shift\[Hyphen]Enter, hold down the Shift \
key, then press Enter.) You can use the standard editing features of your \
graphical interface to prepare your input, which may go on for several lines. \
Shift\[Hyphen]Enter tells ",
  StyleBox["Mathematica", "TI"],
  " that you have finished your input. If your keyboard has a numeric keypad, \
you can use its Enter key instead of Shift\[Hyphen]Enter.   "
}], "Text",
  CellTags->{"S1.0.1", "1.4"}],

Cell[TextData[{
  "After you send ",
  StyleBox["Mathematica", "TI"],
  " input from your notebook, ",
  StyleBox["Mathematica", "TI"],
  " will label your input with ",
  StyleBox["In[", "MB"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MB"],
  ". It labels the corresponding output ",
  StyleBox["Out[", "MB"],
  StyleBox["n", "TI"],
  StyleBox["]=", "MB"],
  ". "
}], "Text",
  CellTags->{"S1.0.1", "1.5"}],

Cell[TextData[{
  "You type ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  ", then end your input with Shift\[Hyphen]Enter. ",
  StyleBox["Mathematica", "TI"],
  " processes the input, then adds the input label ",
  StyleBox["In[1]:=", "MB"],
  ", and gives the output. "
}], "MathCaption",
  CellTags->{"S1.0.1", "1.6"}],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool`3o
ool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooog0?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<m0?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H00000o`3ooonO
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<m0?ooo`8000000P3oool2000000L0oooo00<000000?ooo`3oool01@3o
ool200000080oooo0P00003o0?oooil0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ch0oooo0P0000080?ooo`D00000
1P3oool200000?l0ooooXP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?`3oool2000000T0oooo00<000000?ooo`3o
ool01`3oool200000?l0ooooX@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c@03oool2000000P0oooo00<000000?oo
o`3oool0203oool200000?l0ooooX03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c@@3oool2000001<0oooo0P00003o
0?oooil0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<cd0oooo0P0000020?ooo`8000003`3oool200000080oooo0P00
003o0?oooih0oooo0P000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c?P3oool400000140oooo1000003o0?oooih0oooo00<0003o0?ooo`000?l0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooom03oool010000?l0oooo0?ooo`000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooc0?ooo`050000o`3oool0oooo0?ooo`000?l01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
lP3oool60000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2I
VIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI
0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo003o
0>GUiOl0iNGU2`3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.0.1"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<C4a034a<@3o034a<Ol0<C4a200a<C410?ooo`000P3WinOo034a<Ol0
<C4a2@0a<C410?ooo`0000<0inOW09bLW02LW9`0o`2LW9co09bLW0H0W9bL0P0a<C410?ooo`0000<0
inOW09bLW02LW9`0o`2LW9co09bLW0H0W9bL0P0a<C410?ooo`0000<0inOW09bLW02LW9`0o`2LW9co
09bLW0H0W9bL0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bLo`3WinOo0>OWi`80inOW0`2LW9`2
034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103WinL0W9bL09bLW02L
W9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103WinL0W9bL09bL
W02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103WinL0W9bL
09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103WinL0
W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103W
inL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0
103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3o
ool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooo
k@3oool50000o`80oooo1@000?l50?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool000040>OW
i`2LW9`0W9bL09bLW080<C4a703oool20000o`H0oooo0P000?oo0?oool/0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool00004
0>OWi`2LW9`0W9bL09bLW080<C4a703oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo
0?l0oooob@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bL
W02LW9`0W9bL0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C4?0?ooo`80003o103oool0
0`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000
o`0@0?ooo`<00000o`3ooonh0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<@h0oooo
00@0003o0?ooo`3oool0003o0P3oool01P000?l0oooo0000o`000?l0oooo0000o`80oooo00<0003o
0?ooo`3oool00P3oool01P000?l0oooo0?ooo`3oool0003o0?ooo`@0003o303oool00`000000oooo
0?ooo`3o0?oookL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>OW
i`2LW9`0W9bL09bLW080<C4a0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4a3@3oool00`000?l0
oooo0?ooo`020?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0
oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`000?l03@3oool600000?l0oooo^03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C41
0?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C4=0?ooo`030000o`3oool0oooo0080oooo00<0003o
0?ooo`000?l00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00H0003o
0?ooo`3oool0oooo0000o`3oool40000o`P0oooo00D000000?ooo`3oool0oooo0000003o0?oookT0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bL
W080<C4a0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4a3@3oool00`000?l0oooo0?ooo`020?oo
o`030000o`3oool0003o0080oooo00H0003o0?ooo`000?l0003o0?ooo`000?l40?ooo`050000o`3o
ool0oooo0?ooo`000?l03P3oool010000000oooo0?ooo`00003o0?oookT0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool00004
0>OWi`2LW9`0W9bL09bLW080<C4a3P3oool010000?l0oooo0?ooo`000?l70?ooo`040000o`3oool0
oooo0000o`<0oooo0P000?l30?ooo`030000o`3oool0oooo00d0oooo00<000000?ooo`000000o`3o
oonf0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a
0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4a3`3oool20000o`/0oooo0P000?l30?ooo`030000
o`3oool0oooo0080003o403oool200000?l0oooo^@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?ooo`0000@0inOW09bLW02LW9`0
W9bL0P0a<C4g0?ooo`030000003oool0oooo0?l0oooo]P3oool20000o`H0oooo00<0003o0?ooo`3o
ool00`3oool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a
<Ol0ooook`3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bL
W02LW9`0W9bL0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C7o0?ooonh0oooo00@0003o
0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a
0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4ao`3oooo]0?ooo`050000o`3oool0oooo0?ooo`00
0?l01P3oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool00004
0>OWi`2LW9`0W9bL09bLW080<C4ao`3oooo/0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`030?oo
o`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4ao`3ooooh
0?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?ooo`0000@0inOW
09bLW02LW9`0W9bL0P0a<C7o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool0103WinL0W9bL09bL
W02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooon03oool00`000?l0oooo
0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool000040>OWi`2LW9`0W9bL09bLW080
<C4ao`3ooooh0?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?oo
o`0000@0inOW09bLW02LW9`0W9bL0P0a<C7o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool0103W
inL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooon03oool0
0`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool000040>OWi`2LW9`0
W9bL09bLW080<C4ao`3ooooh0?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL
0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C7o0?ooooP0oooo00<0003o0?ooo`3oool0
0`3oool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0
oooon03oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool00004
0>OWi`2LW9`0W9bL09bLW080<C4ao`3ooooh0?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bL
W02LW9`0W9bL0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C7o0?ooond0oooo1@000?l6
0?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?ooo`0000@0inOW
09bLW02LW9`0W9bL0P0a<C4H0?ooo`80003o1P3oool20000ool0ooooc`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?ooo`0000@0
inOW09bLW02LW9`0W9bL0P0a<C4H0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0
o`3oooo=0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103WinL0W9bL
09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<A40oooo00<0003o0?ooo`00
0?l00P3oool00`000?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool00`00
0?l0oooo0?ooo`0;0?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H00000o`3ooonT0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103WinL0W9bL09bLW02LW9`2
034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<A40oooo00<0003o0?ooo`000?l00P3oool0
0`000?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000o`P0oooo0P00
00020?ooo`8000001`3oool00`000000oooo0?ooo`050?ooo`8000000P3oool200000?l0ooooY03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL
0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C4A0?ooo`030000o`3oool0003o0080oooo
00<0003o0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o0140oooo0P0000080?ooo`D0
00001P3oool200000?l0ooooY`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C4A0?oo
o`080000o`3oool0003o0000o`3oool0003o0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`00
0?l0103oool40000o`X0oooo0P0000090?ooo`030000003oool0oooo00L0oooo0P00003o0?ooojH0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>OWi`2LW9`0W9bL09bL
W080<C4a0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4a4@3oool01@000?l0oooo0000o`3oool0
003o0080oooo00<0003o0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o0080oooo00<0
003o0?ooo`3oool03P3oool2000000P0oooo00<000000?ooo`3oool0203oool200000?l0ooooY@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL
0P0a<C410?ooo`0000@0inOW09bLW02LW9`0W9bL0P0a<C4A0?ooo`030000o`3oool0oooo00@0oooo
00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3oool0oooo0180oooo0P00000C0?ooo`80
0000o`3ooonT0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103WinL0
W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<A40oooo00<0003o0?oo
o`3oool0103oool20000o`<0oooo00<0003o0?ooo`3oool00P000?l@0?ooo`8000000P3oool20000
00l0oooo0P0000020?ooo`800000o`3ooonT0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2
034a<C<0oooo1000000A0?ooo`@00000o`3ooonT0?ooo`80003o1P3oool00`000?l0oooo0?ooo`03
0?ooo`040>OWi`2LW9`0W9bL09bLW080<C4a0@3oool000040>OWi`2LW9`0W9bL09bLW080<C4ao`3o
ooo_0?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool00`3oool0103WinL0W9bL09bL
W02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0ooookP3oool010000?l0oooo
0?ooo`000?l60?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?oo
o`0000@0inOW09bLW02LW9`0W9bL0P0a<C7o0?ooond0oooo00D0003o0?ooo`3oool0oooo0000o`06
0?ooo`030000o`3oool0oooo00<0oooo00@0inOW09bLW02LW9`0W9bL0P0a<C410?ooo`0000@0inOW
09bLW02LW9`0W9bL0P0a<C7o0?ooon`0oooo1P000?l20?ooo`D0003o1@3oool0103WinL0W9bL09bL
W02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103WinL0W9bL
09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103WinL0
W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0103W
inL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3oool0
103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooooP3o
ool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0oooo
oP3oool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9`2034a<Ol0
oooooP3oool0103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9co034a
<Ol0<C4a0@0a<C40103WinL0W9bL09bLW02LW9`2034a<@40oooo0000103WinL0W9bL09bLW02LW9co
034a<Ol0<C4a0@0a<C40103WinL0W9bL09bLW02LW9`2034a<@40oooo00000`3WinL0W9bL09bLW03o
09bLW?l0W9bL1P2LW9`2034a<@40oooo00000`3WinL0W9bL09bLW03o09bLW?l0W9bL1P2LW9`2034a
<@40oooo00000`3WinL0W9bL09bLW03o09bLW?l0W9bL1P2LW9`10>OWi`40<C4a0@3oool00?l0inOW
o`3WinL;0>OWi`40oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.0.1"]
}, Open  ]],

Cell[TextData[{
  "Throughout this book, \[OpenCurlyDoubleQuote]dialogs\
\[CloseCurlyDoubleQuote] with ",
  StyleBox["Mathematica", "TI"],
  " are shown in the following way: "
}], "Text",
  CellTags->{"S1.0.1", "1.7"}],

Cell[TextData[{
  "With a notebook interface, you just type in ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " then adds the label ",
  StyleBox["In[1]:=", "MB"],
  ", and prints the result. "
}], "MathCaption",
  CellTags->{"S1.0.1", "1.8"}],

Cell[CellGroupData[{

Cell["2 + 2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.0.1"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.0.1"]
}, Open  ]],

Cell[TextData[{
  "Section\[NonBreakingSpace]",
  ButtonBox["0.7.1",
    ButtonData:>{"0.7.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " discusses some important details about reproducing the dialogs on your \
computer system. Section\[NonBreakingSpace]",
  ButtonBox["1.3",
    ButtonData:>{"1.3"},
    ButtonStyle->"MainBookLink"],
  " gives more information about ",
  StyleBox["Mathematica", "TI"],
  " notebooks. "
}], "Text",
  CellTags->{"S1.0.1", "1.9"}],

Cell[TextData[{
  "You should realize that notebooks are part of the \
\[OpenCurlyDoubleQuote]front end\[CloseCurlyDoubleQuote] to ",
  StyleBox["Mathematica", "TI"],
  ". The ",
  StyleBox["Mathematica", "TI"],
  " kernel which actually performs computations may be run either on the same \
computer as the front end, or on another computer connected via some kind of \
network or line. In most cases, the kernel is not even started until you \
actually do a calculation with ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.0.1", "1.10"}],

Cell[TextData[{
  "To exit ",
  StyleBox["Mathematica", "TI"],
  ", you typically choose the ",
  StyleBox["Quit", "SR"],
  " menu item in the notebook interface. "
}], "Text",
  CellTags->{"S1.0.1", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.0.2 Text\[Hyphen]Based Interfaces", "Subsection",
  CellTags->{"S1.0.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["math", "MR"],
              " "
            }]], Cell[TextData[{
              "the operating system command to start ",
              StyleBox["Mathematica", "TI"],
              " "
            }]]},
          {Cell["text ending with Enter "], Cell[TextData[{
              "input for ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              "Control\[Hyphen]D \[ThinSpace]or \[ThinSpace]",
              StyleBox["Quit[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "exiting ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.0.2"],

Cell[TextData[{
  "Running ",
  StyleBox["Mathematica", "SO"],
  " with a text\[Hyphen]based interface. "
}], "Caption",
  CellTags->"S1.0.2"],

Cell["\<\
With a text\[Hyphen]based interface, you interact with your \
computer primarily by typing text on the keyboard. \
\>", "Text",
  CellTags->{"S1.0.2", "2.2"}],

Cell[TextData[{
  "To start ",
  StyleBox["Mathematica", "TI"],
  " with a text\[Hyphen]based interface, you typically type the command ",
  StyleBox["math", "MR"],
  " at an operating system prompt. On some systems, you may also be able to \
start ",
  StyleBox["Mathematica", "TI"],
  " with a text\[Hyphen]based interface by double\[Hyphen]clicking on a ",
  StyleBox["Mathematica", "TI"],
  " Kernel icon. "
}], "Text",
  CellTags->{"S1.0.2", "2.3"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " has started, it will print the prompt ",
  StyleBox["In[1]:=", "MB"],
  ", signifying that it is ready for your input. You can then type your \
input, ending with Enter or Return.  "
}], "Text",
  CellTags->{"S1.0.2", "2.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will then process the input, and generate a result. If it prints the \
result out, it will label it with ",
  StyleBox["Out[1]=", "MB"],
  ". "
}], "Text",
  CellTags->{"S1.0.2", "2.5"}],

Cell[TextData[{
  "Throughout this book, dialogs with ",
  StyleBox["Mathematica", "TI"],
  " are shown in the following way: "
}], "Text",
  CellTags->{"S1.0.2", "2.6"}],

Cell[TextData[{
  "The computer prints ",
  StyleBox["In[1]:=", "MB"],
  ". You just type in ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  ". The line that starts with ",
  StyleBox["Out[1]=", "MB"],
  " is the result from ",
  StyleBox["Mathematica", "TI"],
  "."
}], "MathCaption",
  CellTags->{"S1.0.2", "2.7"}],

Cell[CellGroupData[{

Cell["2 + 2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.0.2"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.0.2"]
}, Open  ]],

Cell[TextData[{
  "Section\[NonBreakingSpace]",
  ButtonBox["0.7.1",
    ButtonData:>{"0.7.1", "1.38"},
    ButtonStyle->"MainBookLink"],
  " discusses some important details about reproducing the dialogs on your \
computer system. Note that you do not explicitly type the ",
  StyleBox["In[", "MB"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MB"],
  " prompt; only type the text that follows this prompt. "
}], "Text",
  CellTags->{"S1.0.2", "2.8"}],

Cell[TextData[{
  "Note also that most of the actual dialogs given in the book show output in \
the form you get with a notebook interface to ",
  StyleBox["Mathematica", "TI"],
  "; output with a text\[Hyphen]based interface looks similar, but lacks such \
features as special characters and font size changes. "
}], "Text",
  CellTags->{"S1.0.2", "2.9"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.3",
    ButtonData:>{"1.3"},
    ButtonStyle->"MainBookLink"],
  " gives more details on running ",
  StyleBox["Mathematica", "TI"],
  " with a text\[Hyphen]based interface. To exit ",
  StyleBox["Mathematica", "TI"],
  ", either type Control\[Hyphen]D, Control\[Hyphen]Z or ",
  StyleBox["Quit[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " at an input prompt. "
}], "Text",
  CellTags->{"S1.0.2", "2.10"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1"->{
    Cell[1776, 53, 52, 1, 92, "Chapter",
      CellTags->{"S1", "0.1"}],
    Cell[1831, 56, 270, 7, 70, "Text",
      CellTags->{"S1", "0.2"}],
    Cell[2104, 65, 213, 5, 70, "Text",
      CellTags->{"S1", "0.3"}],
    Cell[2320, 72, 467, 10, 70, "Text",
      CellTags->{"S1", "0.4"}],
    Cell[2790, 84, 360, 8, 70, "Text",
      CellTags->{"S1", "0.5"}]},
  "0.1"->{
    Cell[1776, 53, 52, 1, 92, "Chapter",
      CellTags->{"S1", "0.1"}]},
  "0.2"->{
    Cell[1831, 56, 270, 7, 70, "Text",
      CellTags->{"S1", "0.2"}]},
  "0.3"->{
    Cell[2104, 65, 213, 5, 70, "Text",
      CellTags->{"S1", "0.3"}]},
  "0.4"->{
    Cell[2320, 72, 467, 10, 70, "Text",
      CellTags->{"S1", "0.4"}]},
  "0.5"->{
    Cell[2790, 84, 360, 8, 70, "Text",
      CellTags->{"S1", "0.5"}]},
  "S1.0.0"->{
    Cell[3175, 96, 145, 5, 70, "Section",
      CellTags->{"S1.0.0", "0.6"}],
    Cell[3323, 103, 466, 10, 70, "Text",
      CellTags->{"S1.0.0", "0.7"}],
    Cell[3792, 115, 383, 9, 70, "Text",
      CellTags->{"S1.0.0", "0.8"}]},
  "0.6"->{
    Cell[3175, 96, 145, 5, 70, "Section",
      CellTags->{"S1.0.0", "0.6"}]},
  "0.7"->{
    Cell[3323, 103, 466, 10, 70, "Text",
      CellTags->{"S1.0.0", "0.7"}]},
  "0.8"->{
    Cell[3792, 115, 383, 9, 70, "Text",
      CellTags->{"S1.0.0", "0.8"}]},
  "S1.0.1"->{
    Cell[4200, 128, 78, 1, 70, "Subsection",
      CellTags->{"S1.0.1", "1.1"}],
    Cell[4281, 131, 1179, 34, 70, "DefinitionBox",
      CellTags->"S1.0.1"],
    Cell[5463, 167, 132, 5, 70, "Caption",
      CellTags->"S1.0.1"],
    Cell[5598, 174, 231, 6, 70, "Text",
      CellTags->{"S1.0.1", "1.2"}],
    Cell[5832, 182, 457, 13, 70, "Text",
      CellTags->{"S1.0.1", "1.3"}],
    Cell[6292, 197, 741, 15, 70, "Text",
      CellTags->{"S1.0.1", "1.4"}],
    Cell[7036, 214, 408, 15, 70, "Text",
      CellTags->{"S1.0.1", "1.5"}],
    Cell[7447, 231, 362, 13, 70, "MathCaption",
      CellTags->{"S1.0.1", "1.6"}],
    Cell[7834, 248, 4021, 54, 70, 3886, 49, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.0.1"],
    Cell[11858, 304, 9711, 124, 70, 9576, 119, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.0.1"],
    Cell[21584, 431, 219, 6, 70, "Text",
      CellTags->{"S1.0.1", "1.7"}],
    Cell[21806, 439, 325, 13, 70, "MathCaption",
      CellTags->{"S1.0.1", "1.8"}],
    Cell[22156, 456, 69, 2, 70, "Input",
      CellTags->"S1.0.1"],
    Cell[22228, 460, 82, 3, 70, "Output",
      CellTags->"S1.0.1"],
    Cell[22325, 466, 467, 14, 70, "Text",
      CellTags->{"S1.0.1", "1.9"}],
    Cell[22795, 482, 563, 13, 70, "Text",
      CellTags->{"S1.0.1", "1.10"}],
    Cell[23361, 497, 208, 7, 40, "Text",
      CellTags->{"S1.0.1", "1.11"}]},
  "1.1"->{
    Cell[4200, 128, 78, 1, 70, "Subsection",
      CellTags->{"S1.0.1", "1.1"}]},
  "1.2"->{
    Cell[5598, 174, 231, 6, 70, "Text",
      CellTags->{"S1.0.1", "1.2"}]},
  "1.3"->{
    Cell[5832, 182, 457, 13, 70, "Text",
      CellTags->{"S1.0.1", "1.3"}]},
  "1.4"->{
    Cell[6292, 197, 741, 15, 70, "Text",
      CellTags->{"S1.0.1", "1.4"}]},
  "1.5"->{
    Cell[7036, 214, 408, 15, 70, "Text",
      CellTags->{"S1.0.1", "1.5"}]},
  "1.6"->{
    Cell[7447, 231, 362, 13, 70, "MathCaption",
      CellTags->{"S1.0.1", "1.6"}]},
  "1.7"->{
    Cell[21584, 431, 219, 6, 70, "Text",
      CellTags->{"S1.0.1", "1.7"}]},
  "1.8"->{
    Cell[21806, 439, 325, 13, 70, "MathCaption",
      CellTags->{"S1.0.1", "1.8"}]},
  "1.9"->{
    Cell[22325, 466, 467, 14, 70, "Text",
      CellTags->{"S1.0.1", "1.9"}]},
  "1.10"->{
    Cell[22795, 482, 563, 13, 70, "Text",
      CellTags->{"S1.0.1", "1.10"}]},
  "1.11"->{
    Cell[23361, 497, 208, 7, 40, "Text",
      CellTags->{"S1.0.1", "1.11"}]},
  "S1.0.2"->{
    Cell[23606, 509, 88, 1, 70, "Subsection",
      CellTags->{"S1.0.2", "2.1"}],
    Cell[23697, 512, 937, 28, 106, "DefinitionBox",
      CellTags->"S1.0.2"],
    Cell[24637, 542, 142, 5, 16, "Caption",
      CellTags->"S1.0.2"],
    Cell[24782, 549, 168, 4, 40, "Text",
      CellTags->{"S1.0.2", "2.2"}],
    Cell[24953, 555, 454, 12, 72, "Text",
      CellTags->{"S1.0.2", "2.3"}],
    Cell[25410, 569, 289, 8, 40, "Text",
      CellTags->{"S1.0.2", "2.4"}],
    Cell[25702, 579, 239, 7, 40, "Text",
      CellTags->{"S1.0.2", "2.5"}],
    Cell[25944, 588, 170, 5, 24, "Text",
      CellTags->{"S1.0.2", "2.6"}],
    Cell[26117, 595, 356, 15, 56, "MathCaption",
      CellTags->{"S1.0.2", "2.7"}],
    Cell[26498, 614, 69, 2, 28, "Input",
      CellTags->"S1.0.2"],
    Cell[26570, 618, 82, 3, 25, "Output",
      CellTags->"S1.0.2"],
    Cell[26667, 624, 450, 12, 56, "Text",
      CellTags->{"S1.0.2", "2.8"}],
    Cell[27120, 638, 356, 7, 56, "Text",
      CellTags->{"S1.0.2", "2.9"}],
    Cell[27479, 647, 449, 15, 40, "Text",
      CellTags->{"S1.0.2", "2.10"}]},
  "2.1"->{
    Cell[23606, 509, 88, 1, 70, "Subsection",
      CellTags->{"S1.0.2", "2.1"}]},
  "2.2"->{
    Cell[24782, 549, 168, 4, 40, "Text",
      CellTags->{"S1.0.2", "2.2"}]},
  "2.3"->{
    Cell[24953, 555, 454, 12, 72, "Text",
      CellTags->{"S1.0.2", "2.3"}]},
  "2.4"->{
    Cell[25410, 569, 289, 8, 40, "Text",
      CellTags->{"S1.0.2", "2.4"}]},
  "2.5"->{
    Cell[25702, 579, 239, 7, 40, "Text",
      CellTags->{"S1.0.2", "2.5"}]},
  "2.6"->{
    Cell[25944, 588, 170, 5, 24, "Text",
      CellTags->{"S1.0.2", "2.6"}]},
  "2.7"->{
    Cell[26117, 595, 356, 15, 56, "MathCaption",
      CellTags->{"S1.0.2", "2.7"}]},
  "2.8"->{
    Cell[26667, 624, 450, 12, 56, "Text",
      CellTags->{"S1.0.2", "2.8"}]},
  "2.9"->{
    Cell[27120, 638, 356, 7, 56, "Text",
      CellTags->{"S1.0.2", "2.9"}]},
  "2.10"->{
    Cell[27479, 647, 449, 15, 40, "Text",
      CellTags->{"S1.0.2", "2.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1", 28579, 683},
  {"0.1", 28949, 694},
  {"0.2", 29034, 697},
  {"0.3", 29117, 700},
  {"0.4", 29200, 703},
  {"0.5", 29284, 706},
  {"S1.0.0", 29370, 709},
  {"0.6", 29613, 716},
  {"0.7", 29703, 719},
  {"0.8", 29792, 722},
  {"S1.0.1", 29883, 725},
  {"1.1", 31330, 764},
  {"1.2", 31423, 767},
  {"1.3", 31511, 770},
  {"1.4", 31600, 773},
  {"1.5", 31689, 776},
  {"1.6", 31778, 779},
  {"1.7", 31874, 782},
  {"1.8", 31963, 785},
  {"1.9", 32060, 788},
  {"1.10", 32151, 791},
  {"1.11", 32243, 794},
  {"S1.0.2", 32336, 797},
  {"2.1", 33422, 826},
  {"2.2", 33516, 829},
  {"2.3", 33605, 832},
  {"2.4", 33695, 835},
  {"2.5", 33784, 838},
  {"2.6", 33873, 841},
  {"2.7", 33962, 844},
  {"2.8", 34059, 847},
  {"2.9", 34149, 850},
  {"2.10", 34239, 853}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 52, 1, 92, "Chapter",
  CellTags->{"S1", "0.1"}],
Cell[1831, 56, 270, 7, 70, "Text",
  CellTags->{"S1", "0.2"}],
Cell[2104, 65, 213, 5, 70, "Text",
  CellTags->{"S1", "0.3"}],
Cell[2320, 72, 467, 10, 70, "Text",
  CellTags->{"S1", "0.4"}],
Cell[2790, 84, 360, 8, 70, "Text",
  CellTags->{"S1", "0.5"}],

Cell[CellGroupData[{
Cell[3175, 96, 145, 5, 70, "Section",
  CellTags->{"S1.0.0", "0.6"}],
Cell[3323, 103, 466, 10, 70, "Text",
  CellTags->{"S1.0.0", "0.7"}],
Cell[3792, 115, 383, 9, 70, "Text",
  CellTags->{"S1.0.0", "0.8"}],

Cell[CellGroupData[{
Cell[4200, 128, 78, 1, 70, "Subsection",
  CellTags->{"S1.0.1", "1.1"}],
Cell[4281, 131, 1179, 34, 70, "DefinitionBox",
  CellTags->"S1.0.1"],
Cell[5463, 167, 132, 5, 70, "Caption",
  CellTags->"S1.0.1"],
Cell[5598, 174, 231, 6, 70, "Text",
  CellTags->{"S1.0.1", "1.2"}],
Cell[5832, 182, 457, 13, 70, "Text",
  CellTags->{"S1.0.1", "1.3"}],
Cell[6292, 197, 741, 15, 70, "Text",
  CellTags->{"S1.0.1", "1.4"}],
Cell[7036, 214, 408, 15, 70, "Text",
  CellTags->{"S1.0.1", "1.5"}],
Cell[7447, 231, 362, 13, 70, "MathCaption",
  CellTags->{"S1.0.1", "1.6"}],

Cell[CellGroupData[{
Cell[7834, 248, 4021, 54, 70, 3886, 49, "GraphicsData", "Bitmap", "Picture",
  Evaluatable->False,
  CellTags->"S1.0.1"],
Cell[11858, 304, 9711, 124, 70, 9576, 119, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.0.1"]
}, Open  ]],
Cell[21584, 431, 219, 6, 70, "Text",
  CellTags->{"S1.0.1", "1.7"}],
Cell[21806, 439, 325, 13, 70, "MathCaption",
  CellTags->{"S1.0.1", "1.8"}],

Cell[CellGroupData[{
Cell[22156, 456, 69, 2, 70, "Input",
  CellTags->"S1.0.1"],
Cell[22228, 460, 82, 3, 70, "Output",
  CellTags->"S1.0.1"]
}, Open  ]],
Cell[22325, 466, 467, 14, 70, "Text",
  CellTags->{"S1.0.1", "1.9"}],
Cell[22795, 482, 563, 13, 70, "Text",
  CellTags->{"S1.0.1", "1.10"}],
Cell[23361, 497, 208, 7, 40, "Text",
  CellTags->{"S1.0.1", "1.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[23606, 509, 88, 1, 70, "Subsection",
  CellTags->{"S1.0.2", "2.1"}],
Cell[23697, 512, 937, 28, 106, "DefinitionBox",
  CellTags->"S1.0.2"],
Cell[24637, 542, 142, 5, 16, "Caption",
  CellTags->"S1.0.2"],
Cell[24782, 549, 168, 4, 40, "Text",
  CellTags->{"S1.0.2", "2.2"}],
Cell[24953, 555, 454, 12, 72, "Text",
  CellTags->{"S1.0.2", "2.3"}],
Cell[25410, 569, 289, 8, 40, "Text",
  CellTags->{"S1.0.2", "2.4"}],
Cell[25702, 579, 239, 7, 40, "Text",
  CellTags->{"S1.0.2", "2.5"}],
Cell[25944, 588, 170, 5, 24, "Text",
  CellTags->{"S1.0.2", "2.6"}],
Cell[26117, 595, 356, 15, 56, "MathCaption",
  CellTags->{"S1.0.2", "2.7"}],

Cell[CellGroupData[{
Cell[26498, 614, 69, 2, 28, "Input",
  CellTags->"S1.0.2"],
Cell[26570, 618, 82, 3, 25, "Output",
  CellTags->"S1.0.2"]
}, Open  ]],
Cell[26667, 624, 450, 12, 56, "Text",
  CellTags->{"S1.0.2", "2.8"}],
Cell[27120, 638, 356, 7, 56, "Text",
  CellTags->{"S1.0.2", "2.9"}],
Cell[27479, 647, 449, 15, 40, "Text",
  CellTags->{"S1.0.2", "2.10"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

