(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     81229,       2310]*)
(*NotebookOutlinePosition[    103549,       2979]*)
(*  CellTagsIndexPosition[    101531,       2894]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.1 ", "HeadingNumber"],
  "Numerical Calculations"
}], "Section",
  CellTags->{"S1.1.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.1.1 Arithmetic", "Subsection",
  CellTags->{"S1.1.1", "1.1"}],

Cell[TextData[{
  "You can do arithmetic with ",
  StyleBox["Mathematica", "TI"],
  " just as you would on an electronic calculator. "
}], "Text",
  CellTags->{"S1.1.1", "1.2"}],

Cell["This is the sum of two numbers. ", "MathCaption",
  CellTags->{"S1.1.1", "1.3"}],

Cell[CellGroupData[{

Cell["2.3 + 5.63", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(7.93`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell[TextData[{
  "Here the ",
  StyleBox["/", "MR"],
  " stands for division, and the ",
  StyleBox["^", "MR"],
  " stands for power.  "
}], "MathCaption",
  CellTags->{"S1.1.1", "1.4"}],

Cell[CellGroupData[{

Cell["2.4 / 8.9 ^ 2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(0.030299204645878042`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell[TextData[{
  "Spaces denote multiplication in ",
  StyleBox["Mathematica", "TI"],
  ". You can use a ",
  StyleBox["*", "MR"],
  " for multiplication if you want to. "
}], "MathCaption",
  CellTags->{"S1.1.1", "1.5"}],

Cell[CellGroupData[{

Cell["2 3 4", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(24\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell["You can type arithmetic expressions with parentheses. ", "MathCaption",
  CellTags->{"S1.1.1", "1.6"}],

Cell[CellGroupData[{

Cell["(3 + 4) ^ 2 - 2 (3 + 1)", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(41\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell["\<\
Spaces are not needed, though they often make your input easier to \
read. \
\>", "MathCaption",
  CellTags->{"S1.1.1", "1.7"}],

Cell[CellGroupData[{

Cell["(3+4)^2-2(3+1)", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(41\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["^", "MR"],
              StyleBox["y", "TI"],
              " "
            }]], Cell["power "]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["x", "TI"],
              " "
            }]], Cell["minus "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["/", "MR"],
              StyleBox["y", "TI"],
              " "
            }]], Cell["divide "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["z", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["x", "TI"],
              StyleBox["*", "MR"],
              StyleBox["y", "TI"],
              StyleBox["*", "MR"],
              StyleBox["z", "TI"],
              " "
            }]], Cell["multiply  "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["+", "MR"],
              StyleBox["y", "TI"],
              StyleBox["+", "MR"],
              StyleBox["z", "TI"],
              " "
            }]], Cell["add  "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.1"],

Cell[TextData[{
  "Arithmetic operations in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.1.1"],

Cell[TextData[{
  "Arithmetic operations in ",
  StyleBox["Mathematica", "TI"],
  " are grouped according to the standard mathematical conventions. As usual, \
",
  StyleBox["2", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["3", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["4", "MR"],
  ", for example, means ",
  StyleBox["(2", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["3)", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["4", "MR"],
  ", and not ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["(3", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["4)", "MR"],
  ". You can always control grouping by explicitly using parentheses.  "
}], "Text",
  CellTags->{"S1.1.1", "1.8"}],

Cell["This result is given in scientific notation. ", "MathCaption",
  CellTags->{"S1.1.1", "1.9"}],

Cell[CellGroupData[{

Cell["2.4 ^ 45", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(1.2867846661244414`*^17\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell["You can enter numbers in scientific notation like this. ", "MathCaption",
  CellTags->{"S1.1.1", "1.10"}],

Cell[CellGroupData[{

Cell["2.3 10^70", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(2.3`*^70\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.1.1"]
}, Open  ]],

Cell["Or like this. ", "MathCaption",
  CellTags->{"S1.1.1", "1.11"}],

Cell[CellGroupData[{

Cell["2.3*^70", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.1.1"],

Cell[BoxData[
    \(2.3`*^70\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.1.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1.2 Exact and Approximate Results", "Subsection",
  CellTags->{"S1.1.2", "2.1"}],

Cell[TextData[{
  "A standard electronic calculator does all your calculations to a \
particular accuracy, say ten decimal digits. With ",
  StyleBox["Mathematica", "TI"],
  ", however, you can often get ",
  StyleBox["exact", "TI"],
  " results.  "
}], "Text",
  CellTags->{"S1.1.2", "2.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " gives an ",
  StyleBox["exact", "TI"],
  " result for ",
  Cell[BoxData[
      \(TraditionalForm\`2\^100\)], "InlineFormula"],
  ", even though it has 31 decimal digits. "
}], "MathCaption",
  CellTags->{"S1.1.2", "2.3"}],

Cell[CellGroupData[{

Cell["2 ^ 100", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(1267650600228229401496703205376\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell[TextData[{
  "You can tell ",
  StyleBox["Mathematica", "TI"],
  " to give you an approximate numerical result, just as a calculator would, \
by ending your input with ",
  StyleBox["//N", "MR"],
  ". The ",
  StyleBox["N", "MR"],
  " stands for \[OpenCurlyDoubleQuote]numerical\[CloseCurlyDoubleQuote]. It \
must be a capital letter. Section\[NonBreakingSpace]",
  ButtonBox["2.1.3",
    ButtonData:>{"2.1.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " will explain what the ",
  StyleBox["//", "MR"],
  " means. "
}], "Text",
  CellTags->{"S1.1.2", "2.4"}],

Cell["This gives an approximate numerical result. ", "MathCaption",
  CellTags->{"S1.1.2", "2.5"}],

Cell[CellGroupData[{

Cell["2 ^ 100 //N", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(1.2676506002282294`*^30\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can give results in terms of rational numbers.  "
}], "MathCaption",
  CellTags->{"S1.1.2", "2.6"}],

Cell[CellGroupData[{

Cell["1/3 + 2/7", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(13\/21\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["//N", "MR"],
  " always gives the approximate numerical result. "
}], "MathCaption",
  CellTags->{"S1.1.2", "2.7"}],

Cell[CellGroupData[{

Cell["1/3 + 2/7 //N", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(0.6190476190476191`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["//N", "MR"],
              " "
            }]], Cell[TextData[{
              "give an approximate numerical value for ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.2"],

Cell["Getting numerical approximations. ", "Caption",
  CellTags->"S1.1.2"],

Cell[TextData[{
  "When you type in an integer like ",
  StyleBox["7", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " assumes that it is exact. If you type in a number like ",
  StyleBox["4.5", "MR"],
  ", with an explicit decimal point, ",
  StyleBox["Mathematica", "TI"],
  " assumes that it is accurate only to a fixed number of decimal places. "
}], "Text",
  CellTags->{"S1.1.2", "2.8"}],

Cell["\<\
This is taken to be an exact rational number, and reduced to its \
lowest terms. \
\>", "MathCaption",
  CellTags->{"S1.1.2", "2.9"}],

Cell[CellGroupData[{

Cell["452/62", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(226\/31\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell[TextData[{
  "Whenever you give a number with an explicit decimal point, ",
  StyleBox["Mathematica", "TI"],
  " produces an approximate numerical result. "
}], "MathCaption",
  CellTags->{"S1.1.2", "2.10"}],

Cell[CellGroupData[{

Cell["452.3/62", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(7.29516129032258`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell[TextData[{
  "Here again, the presence of the decimal point makes ",
  StyleBox["Mathematica", "TI"],
  " give you an approximate numerical result. "
}], "MathCaption",
  CellTags->{"S1.1.2", "2.11"}],

Cell[CellGroupData[{

Cell["452./62", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(7.290322580645161`\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.1.2"]
}, Open  ]],

Cell["\<\
When any number in an arithmetic expression is given with an \
explicit decimal point, you get an approximate numerical result for the whole \
expression. \
\>", "MathCaption",
  CellTags->{"S1.1.2", "2.12"}],

Cell[CellGroupData[{

Cell["1. + 452/62", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.1.2"],

Cell[BoxData[
    \(8.29032258064516`\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.1.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1.3 Some Mathematical Functions", "Subsection",
  CellTags->{"S1.1.3", "3.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " includes a very large collection of mathematical functions. Section ",
  ButtonBox["3.2",
    ButtonData:>{"3.2"},
    ButtonStyle->"MainBookLink"],
  " gives the complete list. Here are a few of the common ones. "
}], "Text",
  CellTags->{"S1.1.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sqrt[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "square root (",
              Cell[BoxData[
                  FormBox[
                    SqrtBox[
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ")  "
            }]]},
          {Cell[TextData[{
              StyleBox["Exp[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "exponential (",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["e",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ")  "
            }]]},
          {Cell[TextData[{
              StyleBox["Log[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "natural logarithm (",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["log", 
                        StyleBox["e",
                          "TI"]], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              ")  "
            }]]},
          {Cell[TextData[{
              StyleBox["Log[", "MR"],
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "logarithm to base ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["b",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox["log", 
                        StyleBox["b",
                          "TI"]], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Sin[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Cos[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Tan[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "trigonometric functions (with arguments in radians) "]},
          {Cell[TextData[{
              StyleBox["ArcSin[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcCos[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["ArcTan[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse trigonometric functions  "]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              StyleBox["!", "MR"],
              " "
            }]], Cell[TextData[{
              "factorial (product of integers ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              ")  "
            }]]},
          {Cell[TextData[{
              StyleBox["Abs[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["absolute value   "]},
          {Cell[TextData[{
              StyleBox["Round[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "closest integer to ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              "  "
            }]]},
          {Cell[TextData[{
              StyleBox["Mod[", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " modulo ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " (remainder on division of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " by ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["m",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ")   "
            }]]},
          {Cell[TextData[{
              StyleBox["Random[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["pseudorandom number between 0 and 1   "]},
          {Cell[TextData[{
              StyleBox["Max[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Min[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximum, minimum of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Ellipsis]\)], "InlineFormula"],
              "    "
            }]]},
          {Cell[TextData[{
              StyleBox["FactorInteger[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "prime factors of ",
              StyleBox["n", "TI"],
              " (see Section\[NonBreakingSpace]",
              ButtonBox["3.2.5",
                ButtonData:>{"3.2.5", "5.13"},
                ButtonStyle->"MainBookLink"],
              ")   "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.3"],

Cell["Some common mathematical functions. ", "Caption",
  CellTags->"S1.1.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] The arguments of all ",
              StyleBox["Mathematica", "TI"],
              " functions are enclosed in ",
              StyleBox["square brackets", "TI"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] The names of built\[Hyphen]in ",
              StyleBox["Mathematica", "TI"],
              " functions begin with ",
              StyleBox["capital letters", "TI"],
              ". "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.3"],

Cell[TextData[{
  "Two important points about functions in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.1.3"],

Cell[TextData[{
  "It is important to remember that all function arguments in ",
  StyleBox["Mathematica", "TI"],
  " are enclosed in ",
  StyleBox["square brackets", "TI"],
  ", not parentheses. Parentheses in ",
  StyleBox["Mathematica", "TI"],
  " are used only to indicate the grouping of terms, and never to give \
function arguments.  "
}], "Text",
  CellTags->{"S1.1.3", "3.3"}],

Cell[TextData[{
  "This gives ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["log", 
            StyleBox["e",
              "TI"]], \((8.4)\)}], TraditionalForm]], "InlineFormula"],
  ". Notice the capital letter for ",
  StyleBox["Log", "MR"],
  ", and the ",
  StyleBox["square brackets", "TI"],
  " for the argument. "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.4"}],

Cell[CellGroupData[{

Cell["Log[8.4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(2.128231705849268`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "Just as with arithmetic operations, ",
  StyleBox["Mathematica", "TI"],
  " tries to give exact values for mathematical functions when you give it \
exact input. "
}], "Text",
  CellTags->{"S1.1.3", "3.5"}],

Cell[TextData[{
  "This gives ",
  Cell[BoxData[
      \(TraditionalForm\`\@16\)], "InlineFormula"],
  " as an exact integer. "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.6"}],

Cell[CellGroupData[{

Cell["Sqrt[16]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "This gives an approximate numerical result for ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.7"}],

Cell[CellGroupData[{

Cell["Sqrt[2] //N", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(1.4142135623730951`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "The presence of an explicit decimal point tells ",
  StyleBox["Mathematica", "TI"],
  " to give an approximate numerical result. "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.8"}],

Cell[CellGroupData[{

Cell["Sqrt[2.]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(1.4142135623730951`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "Since you are not asking for an approximate numerical result, ",
  StyleBox["Mathematica", "TI"],
  " leaves the number here in an exact symbolic form. "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.9"}],

Cell[CellGroupData[{

Cell["Sqrt[2]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(\@2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the exact integer result for ",
  Cell[BoxData[
      \(TraditionalForm\`\(30\[Cross]29\[Cross] ... \)\[Cross]1\)], 
    "InlineFormula"],
  ". Computing factorials like this can give you very large numbers. You \
should be able to calculate up to at least ",
  StyleBox["2000!", "MR"],
  " in a short time. "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.10"}],

Cell[CellGroupData[{

Cell["30!", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(265252859812191058636308480000000\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell["\<\
This gives the approximate numerical value of the factorial. \
\>", \
"MathCaption",
  CellTags->{"S1.1.3", "3.11"}],

Cell[CellGroupData[{

Cell["30! //N", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(2.6525285981219107`*^32\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Pi", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi] \[TildeEqual] 3.14159\)], 
                "InlineFormula"],
              "  "
            }]]},
          {Cell[TextData[{
              StyleBox["E", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["e",
                        "TI"], "\[TildeEqual]", "2.71828"}], 
                    TraditionalForm]], "InlineFormula"],
              " (normally output as ",
              Cell[BoxData[
                  \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
              ")   "
            }]]},
          {Cell[TextData[{
              StyleBox["Degree", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(\(\[Pi]/
                    180\)\(\[NegativeMediumSpace]\)\)\)], "InlineFormula"],
              
              ": degrees\[Hyphen]to\[Hyphen]radians conversion factor \
(normally output as ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
              ")  "
            }]]},
          {Cell[TextData[{
              StyleBox["I", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], "=", \(\@\(-1\)\)}], TraditionalForm]], 
                "InlineFormula"],
              " (normally output as ",
              Cell[BoxData[
                  \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
              ")  "
            }]]},
          {Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.3"],

Cell["Some common mathematical constants. ", "Caption",
  CellTags->"S1.1.3"],

Cell["\<\
Notice that the names of these built\[Hyphen]in constants all begin \
with capital letters. \
\>", "Text",
  CellTags->{"S1.1.3", "3.12"}],

Cell[TextData[{
  "This gives the numerical value of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.13"}],

Cell[CellGroupData[{

Cell["Pi ^ 2 //N", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(9.869604401089358`\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "This gives the exact result for ",
  Cell[BoxData[
      \(TraditionalForm\`sin(\[Pi]/2)\)], "InlineFormula"],
  ". Notice that the arguments to trigonometric functions are always in \
radians. "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.14"}],

Cell[CellGroupData[{

Cell["Sin[Pi/2]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "This gives the numerical value of ",
  Cell[BoxData[
      \(TraditionalForm\`sin(20\^\[EmptySmallCircle])\)], "InlineFormula"],
  ". Multiplying by the constant ",
  StyleBox["Degree", "MR"],
  " converts the argument to radians.  "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.15"}],

Cell[CellGroupData[{

Cell["Sin[20 Degree] //N", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(0.3420201433256687`\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Log[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " gives logarithms to base ",
  Cell[BoxData[
      FormBox[
        StyleBox["e",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.16"}],

Cell[CellGroupData[{

Cell["Log[E ^ 5]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.1.3"]
}, Open  ]],

Cell[TextData[{
  "You can get logarithms in any base ",
  StyleBox["b", "TI"],
  " using ",
  StyleBox["Log[", "MR"],
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". As in standard mathematical notation, the ",
  StyleBox["b", "TI"],
  " is optional.  "
}], "MathCaption",
  CellTags->{"S1.1.3", "3.17"}],

Cell[CellGroupData[{

Cell["Log[2, 256]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.1.3"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.1.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.1.4 Arbitrary\[Hyphen]Precision Calculations\
\>", "Subsection",
  CellTags->{"S1.1.4", "4.1"}],

Cell[TextData[{
  "When you use ",
  StyleBox["//N", "MR"],
  " to get a numerical result, ",
  StyleBox["Mathematica", "TI"],
  " does what a standard calculator would do: it gives you a result to a \
fixed number of significant figures. You can also tell ",
  StyleBox["Mathematica", "TI"],
  " exactly how many significant figures to keep in a particular calculation. \
This allows you to get numerical results in ",
  StyleBox["Mathematica", "TI"],
  " to any degree of precision. "
}], "Text",
  CellTags->{"S1.1.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["//N", "MR"],
              "  or  ",
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "approximate numerical value of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical value of ",
              StyleBox["expr", "TI"],
              " calculated with ",
              StyleBox["n", "TI"],
              "\[Hyphen]digit precision "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.4"],

Cell["Numerical evaluation functions. ", "Caption",
  CellTags->"S1.1.4"],

Cell[TextData[{
  "This gives the numerical value of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " to a fixed number of significant digits. Typing ",
  StyleBox["N[Pi]", "MR"],
  " is exactly equivalent to ",
  StyleBox["Pi", "MR"],
  " ",
  StyleBox["//N", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.1.4", "4.3"}],

Cell[CellGroupData[{

Cell["N[Pi]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.1.4"],

Cell[BoxData[
    \(3.141592653589793`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.1.4"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " to 40 digits. "
}], "MathCaption",
  CellTags->{"S1.1.4", "4.4"}],

Cell[CellGroupData[{

Cell["N[Pi, 40]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.1.4"],

Cell[BoxData[
    \(3.141592653589793238462643383279502884197169399375105820985`40. \)], \
"Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.1.4"]
}, Open  ]],

Cell[TextData[{
  "Here is ",
  Cell[BoxData[
      \(TraditionalForm\`\@7\)], "InlineFormula"],
  " to 30 digits. "
}], "MathCaption",
  CellTags->{"S1.1.4", "4.5"}],

Cell[CellGroupData[{

Cell["N[Sqrt[7], 30]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.1.4"],

Cell[BoxData[
    \(2.645751311064590590501615753639260425710259183082`30. \)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.1.4"]
}, Open  ]],

Cell["\<\
Doing any kind of numerical calculation can introduce small \
roundoff errors into your results. When you increase the numerical precision, \
these errors typically become correspondingly smaller. Making sure that you \
get the same answer when you increase numerical precision is often a good way \
to check your results. \
\>", "Text",
  CellTags->{"S1.1.4", "4.6"}],

Cell[TextData[{
  "The quantity ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["e",
            "TI"], \(\[Pi] \@ 163\)], TraditionalForm]], "InlineFormula"],
  " turns out to be very close to an integer. To check that the result is \
not, in fact, an integer, you have to use sufficient numerical precision. "
}], "MathCaption",
  CellTags->{"S1.1.4", "4.7"}],

Cell[CellGroupData[{

Cell["N[Exp[Pi Sqrt[163]], 40]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.1.4"],

Cell[BoxData[
    \(2.6253741264076874399999999999925007259719818568887935389`40.*^17\)], \
"Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.1.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1.5 Complex Numbers", "Subsection",
  CellTags->{"S1.1.5", "5.1"}],

Cell[TextData[{
  "You can enter complex numbers in ",
  StyleBox["Mathematica", "TI"],
  " just by including the constant ",
  StyleBox["I", "MR"],
  ", equal to ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
  ". Make sure that you type a capital ",
  StyleBox["I", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.1.5", "5.2"}],

Cell[TextData[{
  "If you are using notebooks, you can also enter ",
  StyleBox["I", "MR"],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " by typing \[EscapeKey]",
  StyleBox["ii\[EscapeKey]", "MR"],
  " (see Section\[NonBreakingSpace]",
  ButtonBox["1.1.7",
    ButtonData:>{"1.1.7", "7.6"},
    ButtonStyle->"MainBookLink"],
  "). The form ",
  Cell[BoxData[
      \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
  " is normally what is used in output. Note that an ordinary ",
  StyleBox["i", "MR"],
  " means a variable named ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", not ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S1.1.5", "5.3"}],

Cell[TextData[{
  "This gives the imaginary number result\[NonBreakingSpace]",
  Cell[BoxData[
      FormBox[
        RowBox[{"2", 
          StyleBox["i",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.1.5", "5.4"}],

Cell[CellGroupData[{

Cell["Sqrt[-4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.1.5"],

Cell[BoxData[
    \(2\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.1.5"]
}, Open  ]],

Cell["This gives the ratio of two complex numbers. ", "MathCaption",
  CellTags->{"S1.1.5", "5.5"}],

Cell[CellGroupData[{

Cell["(4 + 3 I) / (2 - I)", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.1.5"],

Cell[BoxData[
    \(1 + 2\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.1.5"]
}, Open  ]],

Cell["Here is the numerical value of a complex exponential. ", "MathCaption",
  CellTags->{"S1.1.5", "5.6"}],

Cell[CellGroupData[{

Cell["Exp[2 + 9 I] //N", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.1.5"],

Cell[BoxData[
    \(\(-6.7323926184992535`\) + 
      3.045166606857663`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.1.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["I", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "the complex number ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "+", 
                      StyleBox["i",
                        "TI"], " ", 
                      StyleBox["y",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Re[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["real part  "]},
          {Cell[TextData[{
              StyleBox["Im[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["imaginary part  "]},
          {Cell[TextData[{
              StyleBox["Conjugate[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "complex conjugate ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["z",
                        "TI"], "*"], TraditionalForm]], "InlineFormula"],
              " or ",
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["z",
                        "TI"], "_"], TraditionalForm]], "InlineFormula"],
              "  "
            }]]},
          {Cell[TextData[{
              StyleBox["Abs[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "absolute value ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[VerticalSeparator]", 
                      StyleBox["z",
                        "TI"], "\[VerticalSeparator]"}], TraditionalForm]], 
                "InlineFormula"],
              "   "
            }]]},
          {Cell[TextData[{
              StyleBox["Arg[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the argument ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CurlyPhi]\)], "InlineFormula"],
              " in ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[VerticalSeparator]", 
                      StyleBox["z",
                        "TI"], "\[VerticalSeparator]", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "\[CurlyPhi]"}]]}], TraditionalForm]], 
                "InlineFormula"],
              "  "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.5"],

Cell["Complex number operations. ", "Caption",
  CellTags->"S1.1.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.1.6 Getting Used to ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S1.1.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Arguments of functions are given in ",
              StyleBox["square brackets", "TI"],
              ". "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Names of built\[Hyphen]in \
functions have their first letters capitalized. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Multiplication can be represented \
by a space. \
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Powers are denoted by ",
              StyleBox["^", "MR"],
              ". "
            }]]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Numbers in scientific notation are \
entered, for example, as ",
              StyleBox["2.5*^-4", "MR"],
              " or ",
              StyleBox["2.5", "MR"],
              " ",
              StyleBox["10^-4", "MR"],
              ". "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.1.6"],

Cell[TextData[{
  "Important points to remember in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.1.6"],

Cell[TextData[{
  "This section has given you a first glimpse of ",
  StyleBox["Mathematica", "TI"],
  ". If you have used other computer systems before, you will probably have \
noticed some similarities and some differences. Often you will find the \
differences the most difficult parts to remember. It may help you, however, \
to understand a little about ",
  StyleBox["why", "TI"],
  " ",
  StyleBox["Mathematica", "TI"],
  " is set up the way it is, and why such differences exist. "
}], "Text",
  CellTags->{"S1.1.6", "6.2"}],

Cell[TextData[{
  "One important feature of ",
  StyleBox["Mathematica", "TI"],
  " that differs from other computer languages, and from conventional \
mathematical notation, is that function arguments are enclosed in square \
brackets, not parentheses. Parentheses in ",
  StyleBox["Mathematica", "TI"],
  " are reserved specifically for indicating the grouping of terms. There is \
obviously a conceptual distinction between giving arguments to a function and \
grouping terms together; the fact that the same notation has often been used \
for both is largely a consequence of typography and of early computer \
keyboards. In ",
  StyleBox["Mathematica", "TI"],
  ", the concepts are distinguished by different notation. "
}], "Text",
  CellTags->{"S1.1.6", "6.3"}],

Cell[TextData[{
  "This distinction has several advantages. In parenthesis notation, it is \
not clear whether ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["c",
            "TI"], 
          RowBox[{"(", 
            RowBox[{"1", "+", 
              StyleBox["x",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  " means ",
  StyleBox["c[1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " or ",
  StyleBox["c*(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x)", "MR"],
  ". Using square brackets for function arguments removes this ambiguity. It \
also allows multiplication to be indicated without an explicit ",
  StyleBox["*", "MR"],
  " or other character. As a result, ",
  StyleBox["Mathematica", "TI"],
  " can handle expressions like ",
  StyleBox["2x", "MR"],
  " and ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["x", "MR"],
  " or ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x)", "MR"],
  ", treating them just as in standard mathematical notation. "
}], "Text",
  CellTags->{"S1.1.6", "6.4"}],

Cell[TextData[{
  "You will have seen in this section that built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions often have quite long names. You may wonder why, for example, \
the pseudorandom number function is called ",
  StyleBox["Random", "MR"],
  ", rather than, say, ",
  StyleBox["Rand", "MR"],
  ". The answer, which pervades much of the design of ",
  StyleBox["Mathematica", "TI"],
  ", is consistency. There is a general convention in ",
  StyleBox["Mathematica", "TI"],
  " that all function names are spelled out as full English words, unless \
there is a standard mathematical abbreviation for them. The great advantage \
of this scheme is that it is ",
  StyleBox["predictable", "TI"],
  ". Once you know what a function does, you will usually be able to guess \
exactly what its name is. If the names were abbreviated, you would always \
have to remember which shortening of the standard English words was used.  "
}], "Text",
  CellTags->{"S1.1.6", "6.5"}],

Cell[TextData[{
  "Another feature of built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " names is that they all start with capital letters. In later sections, you \
will see how to define variables and functions of your own. The capital \
letter convention makes it easy to distinguish built\[Hyphen]in objects. If \
",
  StyleBox["Mathematica", "TI"],
  " used ",
  StyleBox["max", "MR"],
  " instead of ",
  StyleBox["Max", "MR"],
  " to represent the operation of finding a maximum, then you would never be \
able to use ",
  StyleBox["max", "MR"],
  " as the name of one of your variables. In addition, when you read programs \
written in ",
  StyleBox["Mathematica", "TI"],
  ", the capitalization of built\[Hyphen]in names makes them easier to pick \
out.  "
}], "Text",
  CellTags->{"S1.1.6", "6.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.1.7 Mathematical Notation in Notebooks", "Subsection",
  CellTags->{"S1.1.7", "7.1"}],

Cell[TextData[{
  "If you use a text\[Hyphen]based interface to ",
  StyleBox["Mathematica", "TI"],
  ", then the input you give must consist only of characters that you can \
type directly on your computer keyboard. But if you use a notebook interface \
then other kinds of input become possible.  "
}], "Text",
  CellTags->{"S1.1.7", "7.2"}],

Cell[TextData[{
  "Usually there are palettes provided which operate like extensions of your \
keyboard, and which have buttons that you can click to enter particular \
forms. You can typically access standard palettes using the ",
  StyleBox["Palettes", "SR"],
  " submenu of the ",
  StyleBox["File", "SR"],
  " menu.  "
}], "Text",
  CellTags->{"S1.1.7", "7.3"}],

Cell[TextData[{
  "Clicking the ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " button in this palette will enter a pi into your notebook."
}], "MathCaption",
  CellTags->{"S1.1.7", "7.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001G0000DR000`400?l00000o`00003oE`3oool0
00030?ooo`0c<c<0<c<c05<0<c<c0@3oool00080k^k^E00c<c<10?ooo`0000<0k^k^09VIV@2IVIT0
D@2IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@1A09VIV@80<c<c0@3oool000030>k^kP2IVIT0
VIVI0540VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVIC03^k^h409VIV@80<c<c0@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<cB@0000000`3^k^h0VIVI09VIV@0209VIV@80<c<c0@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo05EEE@1EEED03@1EEED00`3oool0EEEE05EEE@0:
05EEE@030?ooo`1EEED0EEEE00X0EEEE00<0oooo05EEE@1EEED0301EEED00`3oool0EEEE05EEE@0<
05EEE@030000003^k^h0VIVI00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0
0`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd0
0`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE
0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE
0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0
gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0103MgMd3000000D0gMgM00<0EEEE0?ooo`3MgMd0303MgMd0
0`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo
0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE
0?ooo`3MgMd00`3MgMd01@000000gMgM0=gMg@3MgMd0000000@0gMgM00<0EEEE0?ooo`3MgMd00`3M
gMd00`000000gMgM0=gMg@030=gMg@060000003MgMd0gMgM05EEE@000000k^k^102IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3M
gMd00`3MgMd01P000000gMgM0=gMg@3MgMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd00`3MgMd0
1P000000gMgM0=gMg@1EEED000000>k^kP@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI
0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0505EEE@3oool0gMgM0=gMg@0000001@3MgMd01@000000
gMgM0=gMg@1EEED0oooo00D0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0oooo0=gMg@020=gM
g@030000003MgMd0gMgM00<0gMgM00H000000=gMg@3MgMd0gMgM05EEE@3oool40=gMg@030000003M
gMd0gMgM00<0gMgM00H000000=gMg@3MgMd0EEEE0000003^k^h409VIV@80<c<c0@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd00`000000gMgM0=gMg@030=gMg@03
05EEE@3oool0gMgM0080gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@0305EEE@3oool0gMgM
00<0gMgM00<000000=gMg@000000103MgMd00`1EEED0oooo0=gMg@020=gMg@030000003MgMd0gMgM
00<0gMgM00H000000=gMg@3MgMd0gMgM05EEE@3oool40=gMg@030000003MgMd0gMgM00<0gMgM00H0
00000=gMg@3MgMd0EEEE0000003^k^h409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c00<0oooo0=gMg@3MgMd01P3MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM0080
gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@0305EEE@3oool0gMgM00<0gMgM00<000000=gM
g@000000103MgMd00`1EEED0oooo0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00H000000=gM
g@3MgMd0gMgM05EEE@3oool40=gMg@030000003MgMd0gMgM00<0gMgM00H000000=gMg@3MgMd0EEEE
0000003^k^h409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3M
gMd00P3MgMd5000000D0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd01@000000gMgM0=gMg@3MgMd00000
00<0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM00<0EEEE
0?ooo`3MgMd00P3MgMd00`000000gMgM0=gMg@030=gMg@060000003MgMd0gMgM0=gMg@1EEED0oooo
103MgMd00`000000gMgM0=gMg@030=gMg@060000003MgMd0gMgM05EEE@000000k^k^102IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?oo
o`3MgMd00`3MgMd00`000000gMgM000000040=gMg@0305EEE@3oool0gMgM0080gMgM00D000000=gM
g@3MgMd0gMgM000000030=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd0
1P000000gMgM0=gMg@3MgMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM
0=gMg@1EEED000000>k^kP@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3o
ool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00<0gMgM00<000000=gMg@000000103MgMd00`1E
EED0oooo0=gMg@020=gMg@050000003MgMd0gMgM0=gMg@0000000`3MgMd00`1EEED0oooo0=gMg@02
0=gMg@030000003MgMd0gMgM00<0gMgM00H000000=gMg@3MgMd0gMgM05EEE@3oool40=gMg@030000
003MgMd0gMgM00<0gMgM00H000000=gMg@3MgMd0EEEE0000003^k^h409VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@040=gM
g@030000003MgMd0gMgM00<0gMgM00D0EEEE0?ooo`3MgMd0gMgM000000050=gMg@050000003MgMd0
gMgM05EEE@3oool00`3MgMd00`000000gMgM0=gMg@030=gMg@060000003MgMd0gMgM0=gMg@1EEED0
oooo1@3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM00<0EEEE0000003^k^h0102IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?oo
o`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gM
g@3MgMd00`3MgMd01P000000gMgM0=gMg@3MgMd0EEEE0?ooo`H0gMgM0`0000040=gMg@0305EEE@00
0000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gM
g@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gM
g@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3M
gMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303M
gMd00`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cB03o
ool00`000000k^k^09VIV@0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0
oooo05EEE@1EEED03@1EEED00`3oool0EEEE05EEE@0:05EEE@030?ooo`1EEED0EEEE00X0EEEE00<0
oooo05EEE@1EEED0301EEED00`3oool0EEEE05EEE@0<05EEE@030000003^k^h0VIVI00<0VIVI0P0c
<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3o
ool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3o
ool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gM
g@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^
kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303M
gMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303M
gMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0
EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00<0gMgM00<0
gmoO0>OWi`3WinL00P3WinL01`3UiND0g=cL0=gMg@3MgMd0EEEE0000003^k^h0102IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd00`3MgMd00`000000gMgM0=gMg@040=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3M
gMd0303MgMd01`1EEED0oooo0=gMg@3MgMd0g=cL0=gMg@3Ng]h01@3MgMd01P3QhN40gMgM0=gMg@1E
EED000000>k^kP@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM
0=gMg@0<0=gMg@0305EEE@3oool0gMgM00<0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0oooo
0=gMg@020=gMg@D000000`3MgMd00`1EEED0oooo0=gMg@030=gMg@D00000103MgMd01P1EEED0oooo
0=gMg@3MgMd0iNGU0=gMg@H0000000H0j>SX0=gMg@3MgMd0EEEE0000003^k^h409VIV@80<c<c0@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c00@0oooo0=gMg@3MgMd0gMgM0`000000103MgMd00000
0000000000040=gMg@0405EEE@3oool0gMgM0=gMg@H000000`3MgMd00`1EEED0oooo0=gMg@060=gM
g@060000003MgMd0gMgM0=gMg@1EEED0oooo103MgMd00`000000gMgM0=gMg@060=gMg@0605EEE@3o
ool0gMgM0=gMg@3WinL000000P3MgMd30=CDe0070=KFeP3Ng]h0gMgM0=gMg@1EEED000000>k^kP04
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd0
0`1EEED0oooo0=gMg@040=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3MgMd0103MgMd2
000000@0gMgM00<0EEEE0?ooo`3MgMd0103MgMd2000000H0gMgM00D0EEEE0?ooo`3MgMd0gMgM0>OW
i`07000000060>[ZjP3MgMd0gMgM05EEE@000000k^k^102IVIT203<c<`40oooo0000103^k^h0VIVI
09VIV@2IVIT203<c<`040?ooo`3MgMd0gMgM0=gMg@<0000000@0gMgM0000000000000000103MgMd0
101EEED0oooo0=gMg@3MgMd6000000<0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd2000000H0gMgM00<0
EEEE0?ooo`3MgMd01P3MgMd2000000@0gMgM00P0EEEE0?ooo`3MgMd0gMgM0>OWi`000000gMgM0>?S
h`<0fMWI00L0f][J0=gMg@3MgMd0gMgM05EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00@0gMgM00<0
00000=gMg@3MgMd00`3MgMd00`1EEED0oooo0=gMg@040=gMg@800000103MgMd00`1EEED0oooo0=gM
g@040=gMg@8000001P3MgMd01P1EEED0oooo0=gMg@3MgMd0i>CT0=gMg@H0000000H0jNWY0=gMg@3M
gMd0EEEE0000003^k^h409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo
0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@050=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE
0?ooo`3MgMd01P3MgMd01P000000gMgM0=gMg@3MgMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd0
1P3MgMd01@1EEED0oooo0=gMg@3MgMd0g=cL00X0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd01@3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3M
gMd0303MgMd00`1EEED0oooo0=gMg@030=gMg@030=kNgP3UiND0iNGU0080iNGU00L0hn?S0=gMg@3M
gMd0gMgM05EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0
0`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd0
0`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE
0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE
0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0
gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000
k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=80?ooo`030000003^k^h0
VIVI00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0EEEE05EEE@0=
05EEE@030?ooo`1EEED0EEEE00X0EEEE00<0oooo05EEE@1EEED02P1EEED00`3oool0EEEE05EEE@0<
05EEE@030?ooo`1EEED0EEEE00`0EEEE00<000000>k^kP2IVIT00`2IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd0
0`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd0
0`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo
0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE
0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<1
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0
gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0
gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:
0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP04
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd0
0`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd0
0`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<00000
0=gMg@3MgMd00P3MgMd00`1EEED0oooo0=gMg@040=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE
0?ooo`3MgMd00P3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM00<0EEEE0?ooo`3MgMd01P3M
gMd00`000000gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00P3M
gMd00`000000gMgM0=gMg@020=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@030=gMg@040000003MgMd0gMgM000000D0gMgM
00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@030=gMg@030000003MgMd0000000@0gMgM
00<0EEEE0?ooo`3MgMd01`3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3oool0gMgM00P0gMgM
00L000000=gMg@3MgMd0gMgM05EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2I
VIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@040=gMg@8000001P3MgMd00`1EEED0oooo0=gMg@020=gM
g@D000000`3MgMd00`1EEED0oooo0=gMg@040=gMg@030000003MgMd0gMgM00<0gMgM00@0EEEE0?oo
o`3MgMd0gMgM200000030=gMg@0305EEE@3oool0gMgM00<0gMgM1`0000020=gMg@0305EEE@000000
k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@04
0=gMg@8000001P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00<0gMgM00<00000
0=gMg@000000103MgMd00`1EEED0oooo0=gMg@070=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE
0?ooo`3MgMd0203MgMd01`000000gMgM0=gMg@3MgMd0EEEE0000003^k^h0102IVIT203<c<`40oooo
0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00<0gMgM00@000000=gMg@3MgMd0
00001@3MgMd00`1EEED0oooo0=gMg@040=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3M
gMd00P3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM00<0EEEE0?ooo`3MgMd01P3MgMd00`00
0000gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00P3MgMd00`00
0000gMgM0=gMg@020=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2I
VIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<000000=gM
g@3MgMd00P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?oo
o`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<10?oo
o`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM
00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM
00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gM
g@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VI
V@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1E
EED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1E
EED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2I
VIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?oo
o`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000
003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<dP0oooo00<000000>k^
kP2IVIT00`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`1EEED0EEEE
00d0EEEE00<0oooo05EEE@1EEED02P1EEED00`3oool0EEEE05EEE@0:05EEE@030?ooo`1EEED0EEEE
00`0EEEE00<0oooo05EEE@1EEED0301EEED00`000000k^k^09VIV@0309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gM
g@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gM
g@0305EEE@000000k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3o
ool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1E
EED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?oo
o`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?oo
o`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM
00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^
00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gM
g@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gM
g@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<`050?ooo`3MgMd0gMgM0=gMg@000000103MgMd00`000000gMgM0=gMg@03
0=gMg@0305EEE@3oool0gMgM00<0gMgM100000030=gMg@0305EEE@3oool0gMgM0080gMgM1@000003
0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP04
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd00P3MgMd0
10000000gMgM0=gMg@0000060=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@0000001@3M
gMd00`1EEED0oooo0=gMg@030=gMg@030000003MgMd0000000@0gMgM00<0EEEE0?ooo`3MgMd00P3M
gMd3000000040=gMg@0000000000000000<0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED00000
0>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0
0`3MgMd00`000000gMgM000000060=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@000000
1@3MgMd00`1EEED0oooo0=gMg@030=gMg@030000003MgMd0000000@0gMgM00D0EEEE0?ooo`3MgMd0
gMgM000000030=gMg@8000000P3MgMd01@000000gMgM0=gMg@1EEED0oooo00d0gMgM00<0EEEE0000
003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM
00<0gMgM00<000000=gMg@0000001P3MgMd00`1EEED0oooo0=gMg@020=gMg@030000003MgMd00000
008000000`3MgMd00`1EEED0oooo0=gMg@030=gMg@030000003MgMd0000000@0gMgM00D0EEEE0?oo
o`3MgMd0gMgM000000020=gMg@8000000`3MgMd01@000000gMgM0=gMg@1EEED0oooo00d0gMgM00<0
EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3M
gMd0gMgM00@0gMgM00<000000=gMg@0000001@3MgMd00`1EEED0oooo0=gMg@020=gMg@050000003M
gMd000000=gMg@0000000`3MgMd00`1EEED0oooo0=gMg@030=gMg@030000003MgMd0000000@0gMgM
00<0EEEE0?ooo`3MgMd00P3MgMd3000000040=gMg@0000000000000000<0gMgM00<0EEEE0?ooo`3M
gMd0103MgMd2000000H0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^k^h0VIVI
09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM0080gMgM1P0000040=gMg@0305EEE@3oool0gMgM00<0
gMgM0`0000040=gMg@0305EEE@3oool0gMgM0080gMgM100000040=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0?ooo`3MgMd00`3MgMd010000000gMgM0=gMg@0000050=gMg@0305EEE@000000k^k^
00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gM
g@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gM
g@0305EEE@3oool0gMgM00<0gMgM00@000000=gMg@3MgMd000001@3MgMd00`1EEED000000>k^kP04
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd0
0`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00@0gMgM00<000000=gMg@3MgMd00`3MgMd0
0`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00@0gMgM0P0000060=gMg@0305EEE@000000
k^k^00@0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<
0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<
0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd0
0`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd0
0`1EEED000000>k^kP0409VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cB03oool0
0`000000k^k^09VIV@0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIVD/0<c<c00<0k^k^
09VIV@2IVIT00P2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIU;03<c<`030>k^kP2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000<0k^k^09VIV@2IVIT0D@2IVIT203<c<`40oooo00000`3^k^h0
VIVI09VIV@1A09VIV@80<c<c0@3oool000030>k^kP2IVIT0VIVI0540VIVI0P0c<c<10?ooo`00E@3^
k^h103<c<`40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{87, 82},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.1.7"],

Cell["\<\
Clicking the first button in this palette will create an empty \
structure for entering a power. You can use the mouse to fill in the \
structure. \
\>", "MathCaption",
  CellTags->{"S1.1.7", "7.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001K0000A2000`400?l00000o`00003oF`3oool0
05X0<c<c0@3oool000030>GUi@0c<c<0<c<c05L0<c<c0@3oool000030>GUi@2IVIT0VIVI05D0VIVI
0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0E@2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@1E
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@<0iNGU00<0e]KF0>GUi@3UiND0B`3UiND3
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c0P0000000`0c<c<0000000000018
0000000303<c<`3UiND0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<0
0`3Fe]H0DU9B059BDP0R059BDP030=KFeP3oool0DU9B02D0DU9B00<0<c<c0>GUi@2IVIT00P2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<b@0e]KF00<0DU9B0=KFeP3oool09@3Fe]H0
0`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c903Fe]H0
0`1BDU80e]KF0?ooo`0U0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<T0=KFeP03059BDP3Fe]H0oooo02D0e]KF00<0DU9B03<c<`3UiND00`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0e]KF0P00000F0=KFeP03059BDP3Fe]H0
oooo00`0e]KF0P00000G0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<<0=KFeP030000003Fe]H0e]KF01D0e]KF00<0DU9B0=KFeP3oool0303Fe]H0
0`000000e]KF0=KFeP0F0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<<0=KFeP0303<c<`000000e]KF01D0e]KF00<0DU9B0=KFeP3oool0303Fe]H2
000001L0e]KF00<0DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<`/0e]KF00<000000=KFeP0c<c<01`3Fe]H8000000L0e]KF00<0DU9B0=KFeP3oool02`3Fe]H0
0`000000e]KF000000070=KFePP00000203Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c2`3Fe]H00`000000e]KF000000070=KFePP000001`3Fe]H0
0`1BDU80e]KF0?ooo`0;0=KFeP030000003Fe]H0000000L0e]KF200000080=KFeP03059BDP0c<c<0
iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0=KFeP050000003Fe]H0
e]KF0=KFeP0000001P3Fe]H8000000L0e]KF00<0DU9B0=KFeP3oool02P3Fe]H01@000000e]KF0=KF
eP3Fe]H0000000H0e]KF200000080=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<:0=KFeP050000003Fe]H0e]KF0=KFeP0000001P3Fe]H8000000L0
e]KF00<0DU9B0=KFeP3oool02P3Fe]H01@000000e]KF0=KFeP3Fe]H0000000H0e]KF200000080=KF
eP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<90=KF
eP030000003Fe]H0e]KF0080e]KF00<000000=KFeP3Fe]H0103Fe]H8000000L0e]KF00<0DU9B0=KF
eP3oool02@3Fe]H00`000000e]KF0=KFeP020=KFeP030000003Fe]H0e]KF00@0e]KF200000080=KF
eP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<90=KF
eP030000003Fe]H0e]KF00<0e]KF00<000000=KFeP3Fe]H00`3Fe]H8000000L0e]KF00<0DU9B0=KF
eP3oool02@3Fe]H00`000000e]KF0=KFeP030=KFeP030000003Fe]H0e]KF00<0e]KF200000080=KF
eP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<60=KF
eP<000001P3Fe]H00`000000e]KF0=KFeP030=KFeP0303<c<`000000000000D000001`3Fe]H00`1B
DU80e]KF0?ooo`060=KFeP<000001P3Fe]H00`000000e]KF0=KFeP030=KFePP00000203Fe]H00`1B
DU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c203Fe]H00`00
0000e]KF0=KFeP040=KFeP030000003Fe]H0e]KF00<0e]KF00<0000003<c<`0c<c<01@0000070=KF
eP03059BDP3Fe]H0oooo00P0e]KF00<000000=KFeP3Fe]H0103Fe]H00`000000e]KF0=KFeP030=KF
ePP00000203Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c403Fe]H00`000000e]KF0=KFeP0A0=KFeP03059BDP3Fe]H0oooo0100e]KF00<000000=KF
eP3Fe]H04P3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c403Fe]H00`000000e]KF0=KFeP0A0=KFeP03059BDP3Fe]H0oooo0100e]KF00<000000=KF
eP3Fe]H04P3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c403Fe]H00`000000e]KF0=KFeP0A0=KFeP03059BDP3Fe]H0oooo00/0e]KF100000000`3F
e]H000000=KFeP0C0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<@0=KFeP030000003Fe]H0e]KF0140e]KF00<0DU9B0=KFeP3oool02`3Fe]H01P00
0000e]KF0=KFeP000000e]KF000001@0e]KF00<0DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<a40e]KF00<000000=KFeP3Fe]H0403Fe]H00`1BDU80e]KF0?oo
o`0;0=KFeP@000000P3Fe]H00`000000e]KF0=KFeP0A0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0=KFeP030000003Fe]H0e]KF0100e]KF00<0
DU9B0=KFeP3oool04@3Fe]H00`000000e]KF0=KFeP0A0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0=KFeP030000003Fe]H0e]KF0100e]KF00<0
DU9B0=KFeP3oool04@3Fe]H00`000000e]KF0=KFeP0A0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<B0=KFeP`000001P3Fe]H00`1BDU80e]KF0?oo
o`0B0=KFePd000001P3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c903Fe]H00`1BDU80e]KF0?ooo`0U0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<T0=KFeP03059BDP3Fe]H0oooo02D0e]KF00<0
DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<b@0e]KF00<0
DU9B0=KFeP3oool09@3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c903Fe]H00`1BDU80e]KF0?ooo`0U0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<T0=KFeP03059BDP3Fe]H0oooo02D0e]KF00<0
DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<bD0oooo00<0
e]KF0?ooo`3oool09@3oool00`0c<c<0iNGU09VIV@0209VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c00<0e]KF059BDP1BDU808P1BDU800`3Fe]H0oooo059BDP0U059BDP0303<c<`3U
iND0VIVI0080VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<T0=KFeP03059BDP3F
e]H0oooo02D0e]KF00<0DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<b@0e]KF00<0DU9B0=KFeP3oool09@3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c903Fe]H00`1BDU80e]KF0?ooo`0U0=KFeP03059BDP0c
<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<T0=KFeP03059BDP3F
e]H0oooo02D0e]KF00<0DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<b@0e]KF00<0DU9B0=KFeP3oool04@3Fe]H6000000h0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<b@0e]KF00<0DU9B0=KFeP3oool04@3F
e]H00`000000e]KF0=KFeP020=KFeP030000003Fe]H0e]KF00`0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<b@0e]KF00<0DU9B0=KFeP3oool04@3F
e]H00`000000e]KF0=KFeP020=KFeP030000003Fe]H0e]KF00`0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<b@0e]KF00<0DU9B0=KFeP3oool04@3F
e]H00`000000e]KF0=KFeP020=KFeP030000003Fe]H0e]KF00`0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`X0e]KF2000000B0=KFeP03059BDP3F
e]H0oooo0140e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP0<0=KFeP03059BDP0c
<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0=KFePP000004P3F
e]H00`1BDU80e]KF0?ooo`0A0=KFePH000003P3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3Fe]H800000180e]KF00<0DU9B0=KFeP3oool09@3F
e]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3F
e]H800000180e]KF00<0DU9B0=KFeP3oool03@3Fe]H=000000/0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`X0e]KF2000000B0=KFeP03059BDP3F
e]H0oooo02D0e]KF00<0DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<`X0e]KF2000000B0=KFeP03059BDP3Fe]H0oooo02D0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`X0e]KF200000030=KFePH000002@3F
e]H00`1BDU80e]KF0?ooo`0A0=KFePH000003P3Fe]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3Fe]H8000000<0e]KF00<000000=KFeP3Fe]H00P3F
e]H00`000000e]KF0=KFeP070=KFeP03059BDP3Fe]H0oooo0140e]KF1P00000>0=KFeP03059BDP0c
<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<E0=KFeP030000003F
e]H0e]KF0080e]KF00<000000=KFeP3Fe]H01`3Fe]H00`1BDU80e]KF0?ooo`0A0=KFePH000003P3F
e]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c5@3F
e]H00`000000e]KF0=KFeP020=KFeP030000003Fe]H0e]KF00L0e]KF00<0DU9B0=KFeP3oool04@3F
e]H6000000h0e]KF00<0DU9B03<c<`3UiND00`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<aD0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP070=KFeP03059BDP3F
e]H0oooo0140e]KF1P00000>0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<E0=KFePH000002@3Fe]H00`1BDU80e]KF0?ooo`0A0=KFePH000003P3F
e]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c903F
e]H00`1BDU80e]KF0?ooo`0U0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<T0=KFeP03059BDP3Fe]H0oooo02D0e]KF00<0DU9B03<c<`3UiND00`2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<b@0e]KF00<0DU9B0=KFeP3oool09@3F
e]H00`1BDU80<c<c0>GUi@0309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c903F
e]H00`1BDU80e]KF0?ooo`0U0=KFeP03059BDP0c<c<0iNGU00<0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVID00c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIU@03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI05D0VIVI
0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0E@2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@1E
09VIV@80<c<c0@3oool005T0iNGU0@0c<c<10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{91, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.1.7"],

Cell["\<\
You can also give input by using special keys on your keyboard. \
Pressing one of these keys does not lead to an ordinary character being \
entered, but instead typically causes some action to occur or some structure \
to be created. \
\>", "Text",
  CellTags->{"S1.1.7", "7.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["p\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "the symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["inf\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "the symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["ee\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "the symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[ExponentialE]\)], "InlineFormula"],
              " for the exponential constant (equivalent to ",
              StyleBox["E", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["ii\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "the symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[ImaginaryI]\)], "InlineFormula"],
              " for ",
              Cell[BoxData[
                  \(TraditionalForm\`\@\(-1\)\)], "InlineFormula"],
              " (equivalent to ",
              StyleBox["I", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["deg\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "the symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
              " (equivalent to ",
              StyleBox["Degree", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["^\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["6\[RightModified]", "MR"],
              " "
            }]], Cell["go to the superscript for a power "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["/\[RightModified]", "MR"],
              " "
            }]], Cell["go to the denominator for a fraction "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["@\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["2\[RightModified]", "MR"],
              " "
            }]], Cell["go into a square root "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] (Control\[Hyphen]Space) "
            }]], Cell[
            "return from a superscript, denominator or square root "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False, False, True}},
  CellTags->"S1.1.7"],

Cell["\<\
A few ways to enter special notations on a standard \
English\[Hyphen]language keyboard. \
\>", "Caption",
  CellTags->"S1.1.7"],

Cell["\<\
Here is a computation entered using ordinary characters on a \
keyboard. \
\>", "MathCaption",
  CellTags->{"S1.1.7", "7.7"}],

Cell[CellGroupData[{

Cell["N[Pi^2/6]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.1.7"],

Cell[BoxData[
    \(1.6449340668482262`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.1.7"]
}, Open  ]],

Cell["\<\
Here is the same computation entered using a palette or special \
keys. \
\>", "MathCaption",
  CellTags->{"S1.1.7", "7.8"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[\[Pi]\^2\/6]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.1.7"],

Cell[BoxData[
    \(1.6449340668482262`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.1.7"]
}, Open  ]],

Cell["\<\
Here is an actual sequence of keys that can be used to enter the \
input. \
\>", "MathCaption",
  CellTags->{"S1.1.7", "7.9"}],

Cell[CellGroupData[{

Cell[TextData[{
  "N[ \[EscapeKey]",
  StyleBox["p\[EscapeKey]", "MR"],
  " \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " 2 \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] \[ControlKey]\[LeftModified]",
  StyleBox["/\[RightModified]", "MR"],
  " 6 \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] ]"
}], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.1.7"],

Cell[BoxData[
    \(1.6449340668482262`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.1.7"]
}, Open  ]],

Cell[TextData[{
  "In a traditional computer language such as C, Fortran, Java or Perl, the \
input you give must always consist of a string of ordinary characters that \
can be typed directly on a keyboard. But the ",
  StyleBox["Mathematica", "TI"],
  " language also allows you to give input that contains special characters, \
superscripts, built\[Hyphen]up fractions, and so on. "
}], "Text",
  CellTags->{"S1.1.7", "7.10"}],

Cell["\<\
The language incorporates many features of traditional mathematical \
notation. But you should realize that the goal of the language is to provide \
a precise and consistent way to specify computations. And as a result, it \
does not follow all of the somewhat haphazard details of traditional \
mathematical notation.  \
\>", "Text",
  CellTags->{"S1.1.7", "7.11"}],

Cell[TextData[{
  "Nevertheless, as discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.10.9",
    ButtonData:>{"1.10.9", "9.12"},
    ButtonStyle->"MainBookLink"],
  ", it is always possible to get ",
  StyleBox["Mathematica", "TI"],
  " to produce ",
  StyleBox["output", "TI"],
  " that imitates every aspect of traditional mathematical notation. And as \
discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.10.9",
    ButtonData:>{"1.10.9", "9.19"},
    ButtonStyle->"MainBookLink"],
  ", it is also possible for ",
  StyleBox["Mathematica", "TI"],
  " to import text that uses such notation, and to some extent to translate \
it into its own more precise language.  "
}], "Text",
  CellTags->{"S1.1.7", "7.12"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.1.0"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S1.1.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S1.1.0", "0.1"}]},
  "S1.1.1"->{
    Cell[1926, 61, 69, 1, 70, "Subsection",
      CellTags->{"S1.1.1", "1.1"}],
    Cell[1998, 64, 177, 5, 70, "Text",
      CellTags->{"S1.1.1", "1.2"}],
    Cell[2178, 71, 86, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.3"}],
    Cell[2289, 76, 74, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[2366, 80, 86, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[2467, 86, 187, 7, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.4"}],
    Cell[2679, 97, 77, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[2759, 101, 102, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[2876, 107, 222, 7, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.5"}],
    Cell[3123, 118, 69, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[3195, 122, 83, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[3293, 128, 108, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.6"}],
    Cell[3426, 133, 87, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[3516, 137, 83, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[3614, 143, 137, 4, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.7"}],
    Cell[3776, 151, 78, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[3857, 155, 83, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[3955, 161, 1422, 45, 70, "DefinitionBox",
      CellTags->"S1.1.1"],
    Cell[5380, 208, 123, 5, 70, "Caption",
      CellTags->"S1.1.1"],
    Cell[5506, 215, 754, 36, 70, "Text",
      CellTags->{"S1.1.1", "1.8"}],
    Cell[6263, 253, 99, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.9"}],
    Cell[6387, 258, 72, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[6462, 262, 104, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[6581, 268, 111, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.10"}],
    Cell[6717, 273, 73, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[6793, 277, 89, 3, 70, "Output",
      CellTags->"S1.1.1"],
    Cell[6897, 283, 69, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.11"}],
    Cell[6991, 288, 71, 2, 70, "Input",
      CellTags->"S1.1.1"],
    Cell[7065, 292, 89, 3, 70, "Output",
      CellTags->"S1.1.1"]},
  "1.1"->{
    Cell[1926, 61, 69, 1, 70, "Subsection",
      CellTags->{"S1.1.1", "1.1"}]},
  "1.2"->{
    Cell[1998, 64, 177, 5, 70, "Text",
      CellTags->{"S1.1.1", "1.2"}]},
  "1.3"->{
    Cell[2178, 71, 86, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.3"}]},
  "1.4"->{
    Cell[2467, 86, 187, 7, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.4"}]},
  "1.5"->{
    Cell[2876, 107, 222, 7, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.5"}]},
  "1.6"->{
    Cell[3293, 128, 108, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.6"}]},
  "1.7"->{
    Cell[3614, 143, 137, 4, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.7"}]},
  "1.8"->{
    Cell[5506, 215, 754, 36, 70, "Text",
      CellTags->{"S1.1.1", "1.8"}]},
  "1.9"->{
    Cell[6263, 253, 99, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.9"}]},
  "1.10"->{
    Cell[6581, 268, 111, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.10"}]},
  "1.11"->{
    Cell[6897, 283, 69, 1, 70, "MathCaption",
      CellTags->{"S1.1.1", "1.11"}]},
  "S1.1.2"->{
    Cell[7203, 301, 88, 1, 70, "Subsection",
      CellTags->{"S1.1.2", "2.1"}],
    Cell[7294, 304, 292, 8, 70, "Text",
      CellTags->{"S1.1.2", "2.2"}],
    Cell[7589, 314, 274, 9, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.3"}],
    Cell[7888, 327, 71, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[7962, 331, 112, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[8089, 337, 566, 17, 70, "Text",
      CellTags->{"S1.1.2", "2.4"}],
    Cell[8658, 356, 98, 1, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.5"}],
    Cell[8781, 361, 75, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[8859, 365, 104, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[8978, 371, 152, 4, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.6"}],
    Cell[9155, 379, 73, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[9231, 383, 87, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[9333, 389, 143, 4, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.7"}],
    Cell[9501, 397, 77, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[9581, 401, 100, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[9696, 407, 508, 16, 70, "DefinitionBox",
      CellTags->"S1.1.2"],
    Cell[10207, 425, 75, 1, 70, "Caption",
      CellTags->"S1.1.2"],
    Cell[10285, 428, 397, 11, 70, "Text",
      CellTags->{"S1.1.2", "2.8"}],
    Cell[10685, 441, 143, 4, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.9"}],
    Cell[10853, 449, 70, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[10926, 453, 88, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[11029, 459, 212, 5, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.10"}],
    Cell[11266, 468, 72, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[11341, 472, 98, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[11454, 478, 205, 5, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.11"}],
    Cell[11684, 487, 71, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[11758, 491, 99, 3, 70, "Output",
      CellTags->"S1.1.2"],
    Cell[11872, 497, 218, 5, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.12"}],
    Cell[12115, 506, 75, 2, 70, "Input",
      CellTags->"S1.1.2"],
    Cell[12193, 510, 98, 3, 70, "Output",
      CellTags->"S1.1.2"]},
  "2.1"->{
    Cell[7203, 301, 88, 1, 70, "Subsection",
      CellTags->{"S1.1.2", "2.1"}]},
  "2.2"->{
    Cell[7294, 304, 292, 8, 70, "Text",
      CellTags->{"S1.1.2", "2.2"}]},
  "2.3"->{
    Cell[7589, 314, 274, 9, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.3"}]},
  "2.4"->{
    Cell[8089, 337, 566, 17, 70, "Text",
      CellTags->{"S1.1.2", "2.4"}]},
  "2.5"->{
    Cell[8658, 356, 98, 1, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.5"}]},
  "2.6"->{
    Cell[8978, 371, 152, 4, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.6"}]},
  "2.7"->{
    Cell[9333, 389, 143, 4, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.7"}]},
  "2.8"->{
    Cell[10285, 428, 397, 11, 70, "Text",
      CellTags->{"S1.1.2", "2.8"}]},
  "2.9"->{
    Cell[10685, 441, 143, 4, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.9"}]},
  "2.10"->{
    Cell[11029, 459, 212, 5, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.10"}]},
  "2.11"->{
    Cell[11454, 478, 205, 5, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.11"}]},
  "2.12"->{
    Cell[11872, 497, 218, 5, 70, "MathCaption",
      CellTags->{"S1.1.2", "2.12"}]},
  "S1.1.3"->{
    Cell[12340, 519, 86, 1, 70, "Subsection",
      CellTags->{"S1.1.3", "3.1"}],
    Cell[12429, 522, 310, 8, 70, "Text",
      CellTags->{"S1.1.3", "3.2"}],
    Cell[12742, 532, 7566, 228, 70, "DefinitionBox",
      CellTags->"S1.1.3"],
    Cell[20311, 762, 77, 1, 70, "Caption",
      CellTags->"S1.1.3"],
    Cell[20391, 765, 723, 20, 70, "FramedBox",
      CellTags->"S1.1.3"],
    Cell[21117, 787, 138, 5, 70, "Caption",
      CellTags->"S1.1.3"],
    Cell[21258, 794, 385, 10, 70, "Text",
      CellTags->{"S1.1.3", "3.3"}],
    Cell[21646, 806, 399, 14, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.4"}],
    Cell[22070, 824, 72, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[22145, 828, 99, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[22259, 834, 225, 6, 70, "Text",
      CellTags->{"S1.1.3", "3.5"}],
    Cell[22487, 842, 177, 6, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.6"}],
    Cell[22689, 852, 72, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[22764, 856, 82, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[22861, 862, 192, 6, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.7"}],
    Cell[23078, 872, 75, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[23156, 876, 100, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[23271, 882, 199, 5, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.8"}],
    Cell[23495, 891, 72, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[23570, 895, 100, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[23685, 901, 222, 5, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.9"}],
    Cell[23932, 910, 71, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[24006, 914, 84, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[24105, 920, 387, 10, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.10"}],
    Cell[24517, 934, 67, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[24587, 938, 114, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[24716, 944, 126, 4, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.11"}],
    Cell[24867, 952, 71, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[24941, 956, 104, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[25060, 962, 2307, 67, 70, "DefinitionBox",
      CellTags->"S1.1.3"],
    Cell[27370, 1031, 77, 1, 70, "Caption",
      CellTags->"S1.1.3"],
    Cell[27450, 1034, 148, 4, 70, "Text",
      CellTags->{"S1.1.3", "3.12"}],
    Cell[27601, 1040, 185, 6, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.13"}],
    Cell[27811, 1050, 74, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[27888, 1054, 99, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[28002, 1060, 265, 7, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.14"}],
    Cell[28292, 1071, 73, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[28368, 1075, 82, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[28465, 1081, 303, 8, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.15"}],
    Cell[28793, 1093, 83, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[28879, 1097, 101, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[28995, 1103, 284, 11, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.16"}],
    Cell[29304, 1118, 75, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[29382, 1122, 83, 3, 70, "Output",
      CellTags->"S1.1.3"],
    Cell[29480, 1128, 361, 14, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.17"}],
    Cell[29866, 1146, 76, 2, 70, "Input",
      CellTags->"S1.1.3"],
    Cell[29945, 1150, 83, 3, 70, "Output",
      CellTags->"S1.1.3"]},
  "3.1"->{
    Cell[12340, 519, 86, 1, 70, "Subsection",
      CellTags->{"S1.1.3", "3.1"}]},
  "3.2"->{
    Cell[12429, 522, 310, 8, 70, "Text",
      CellTags->{"S1.1.3", "3.2"}]},
  "3.3"->{
    Cell[21258, 794, 385, 10, 70, "Text",
      CellTags->{"S1.1.3", "3.3"}]},
  "3.4"->{
    Cell[21646, 806, 399, 14, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.4"}]},
  "3.5"->{
    Cell[22259, 834, 225, 6, 70, "Text",
      CellTags->{"S1.1.3", "3.5"}]},
  "3.6"->{
    Cell[22487, 842, 177, 6, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.6"}]},
  "3.7"->{
    Cell[22861, 862, 192, 6, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.7"}]},
  "3.8"->{
    Cell[23271, 882, 199, 5, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.8"}]},
  "3.9"->{
    Cell[23685, 901, 222, 5, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.9"}]},
  "3.10"->{
    Cell[24105, 920, 387, 10, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.10"}]},
  "3.11"->{
    Cell[24716, 944, 126, 4, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.11"}]},
  "3.12"->{
    Cell[27450, 1034, 148, 4, 70, "Text",
      CellTags->{"S1.1.3", "3.12"}]},
  "3.13"->{
    Cell[27601, 1040, 185, 6, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.13"}]},
  "3.14"->{
    Cell[28002, 1060, 265, 7, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.14"}]},
  "3.15"->{
    Cell[28465, 1081, 303, 8, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.15"}]},
  "3.16"->{
    Cell[28995, 1103, 284, 11, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.16"}]},
  "3.17"->{
    Cell[29480, 1128, 361, 14, 70, "MathCaption",
      CellTags->{"S1.1.3", "3.17"}]},
  "S1.1.4"->{
    Cell[30077, 1159, 107, 3, 70, "Subsection",
      CellTags->{"S1.1.4", "4.1"}],
    Cell[30187, 1164, 529, 13, 70, "Text",
      CellTags->{"S1.1.4", "4.2"}],
    Cell[30719, 1179, 1094, 34, 70, "DefinitionBox",
      CellTags->"S1.1.4"],
    Cell[31816, 1215, 73, 1, 70, "Caption",
      CellTags->"S1.1.4"],
    Cell[31892, 1218, 351, 12, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.3"}],
    Cell[32268, 1234, 69, 2, 70, "Input",
      CellTags->"S1.1.4"],
    Cell[32340, 1238, 99, 3, 70, "Output",
      CellTags->"S1.1.4"],
    Cell[32454, 1244, 171, 6, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.4"}],
    Cell[32650, 1254, 73, 2, 70, "Input",
      CellTags->"S1.1.4"],
    Cell[32726, 1258, 147, 4, 70, "Output",
      CellTags->"S1.1.4"],
    Cell[32888, 1265, 166, 6, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.5"}],
    Cell[33079, 1275, 78, 2, 70, "Input",
      CellTags->"S1.1.4"],
    Cell[33160, 1279, 136, 3, 70, "Output",
      CellTags->"S1.1.4"],
    Cell[33311, 1285, 378, 7, 70, "Text",
      CellTags->{"S1.1.4", "4.6"}],
    Cell[33692, 1294, 390, 10, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.7"}],
    Cell[34107, 1308, 88, 2, 70, "Input",
      CellTags->"S1.1.4"],
    Cell[34198, 1312, 148, 4, 70, "Output",
      CellTags->"S1.1.4"]},
  "4.1"->{
    Cell[30077, 1159, 107, 3, 70, "Subsection",
      CellTags->{"S1.1.4", "4.1"}]},
  "4.2"->{
    Cell[30187, 1164, 529, 13, 70, "Text",
      CellTags->{"S1.1.4", "4.2"}]},
  "4.3"->{
    Cell[31892, 1218, 351, 12, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.3"}]},
  "4.4"->{
    Cell[32454, 1244, 171, 6, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.4"}]},
  "4.5"->{
    Cell[32888, 1265, 166, 6, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.5"}]},
  "4.6"->{
    Cell[33311, 1285, 378, 7, 70, "Text",
      CellTags->{"S1.1.4", "4.6"}]},
  "4.7"->{
    Cell[33692, 1294, 390, 10, 70, "MathCaption",
      CellTags->{"S1.1.4", "4.7"}]},
  "S1.1.5"->{
    Cell[34395, 1322, 74, 1, 70, "Subsection",
      CellTags->{"S1.1.5", "5.1"}],
    Cell[34472, 1325, 352, 12, 70, "Text",
      CellTags->{"S1.1.5", "5.2"}],
    Cell[34827, 1339, 824, 27, 70, "Text",
      CellTags->{"S1.1.5", "5.3"}],
    Cell[35654, 1368, 270, 9, 70, "MathCaption",
      CellTags->{"S1.1.5", "5.4"}],
    Cell[35949, 1381, 72, 2, 70, "Input",
      CellTags->"S1.1.5"],
    Cell[36024, 1385, 97, 3, 70, "Output",
      CellTags->"S1.1.5"],
    Cell[36136, 1391, 99, 1, 70, "MathCaption",
      CellTags->{"S1.1.5", "5.5"}],
    Cell[36260, 1396, 83, 2, 70, "Input",
      CellTags->"S1.1.5"],
    Cell[36346, 1400, 101, 3, 70, "Output",
      CellTags->"S1.1.5"],
    Cell[36462, 1406, 108, 1, 70, "MathCaption",
      CellTags->{"S1.1.5", "5.6"}],
    Cell[36595, 1411, 80, 2, 70, "Input",
      CellTags->"S1.1.5"],
    Cell[36678, 1415, 148, 4, 70, "Output",
      CellTags->"S1.1.5"],
    Cell[36841, 1422, 3342, 99, 70, "DefinitionBox",
      CellTags->"S1.1.5"],
    Cell[40186, 1523, 68, 1, 70, "Caption",
      CellTags->"S1.1.5"]},
  "5.1"->{
    Cell[34395, 1322, 74, 1, 70, "Subsection",
      CellTags->{"S1.1.5", "5.1"}]},
  "5.2"->{
    Cell[34472, 1325, 352, 12, 70, "Text",
      CellTags->{"S1.1.5", "5.2"}]},
  "5.3"->{
    Cell[34827, 1339, 824, 27, 70, "Text",
      CellTags->{"S1.1.5", "5.3"}]},
  "5.4"->{
    Cell[35654, 1368, 270, 9, 70, "MathCaption",
      CellTags->{"S1.1.5", "5.4"}]},
  "5.5"->{
    Cell[36136, 1391, 99, 1, 70, "MathCaption",
      CellTags->{"S1.1.5", "5.5"}]},
  "5.6"->{
    Cell[36462, 1406, 108, 1, 70, "MathCaption",
      CellTags->{"S1.1.5", "5.6"}]},
  "S1.1.6"->{
    Cell[40291, 1529, 125, 4, 70, "Subsection",
      CellTags->{"S1.1.6", "6.1"}],
    Cell[40419, 1535, 1131, 37, 70, "FramedBox",
      CellTags->"S1.1.6"],
    Cell[41553, 1574, 130, 5, 70, "Caption",
      CellTags->"S1.1.6"],
    Cell[41686, 1581, 533, 12, 70, "Text",
      CellTags->{"S1.1.6", "6.2"}],
    Cell[42222, 1595, 768, 15, 70, "Text",
      CellTags->{"S1.1.6", "6.3"}],
    Cell[42993, 1612, 1151, 45, 70, "Text",
      CellTags->{"S1.1.6", "6.4"}],
    Cell[44147, 1659, 987, 20, 70, "Text",
      CellTags->{"S1.1.6", "6.5"}],
    Cell[45137, 1681, 813, 21, 70, "Text",
      CellTags->{"S1.1.6", "6.6"}]},
  "6.1"->{
    Cell[40291, 1529, 125, 4, 70, "Subsection",
      CellTags->{"S1.1.6", "6.1"}]},
  "6.2"->{
    Cell[41686, 1581, 533, 12, 70, "Text",
      CellTags->{"S1.1.6", "6.2"}]},
  "6.3"->{
    Cell[42222, 1595, 768, 15, 70, "Text",
      CellTags->{"S1.1.6", "6.3"}]},
  "6.4"->{
    Cell[42993, 1612, 1151, 45, 70, "Text",
      CellTags->{"S1.1.6", "6.4"}]},
  "6.5"->{
    Cell[44147, 1659, 987, 20, 70, "Text",
      CellTags->{"S1.1.6", "6.5"}]},
  "6.6"->{
    Cell[45137, 1681, 813, 21, 70, "Text",
      CellTags->{"S1.1.6", "6.6"}]},
  "S1.1.7"->{
    Cell[45987, 1707, 93, 1, 70, "Subsection",
      CellTags->{"S1.1.7", "7.1"}],
    Cell[46083, 1710, 343, 7, 70, "Text",
      CellTags->{"S1.1.7", "7.2"}],
    Cell[46429, 1719, 365, 9, 70, "Text",
      CellTags->{"S1.1.7", "7.3"}],
    Cell[46797, 1730, 217, 6, 70, "MathCaption",
      CellTags->{"S1.1.7", "7.4"}],
    Cell[47017, 1738, 18106, 228, 70, 17972, 223, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.1.7"],
    Cell[65126, 1968, 209, 5, 70, "MathCaption",
      CellTags->{"S1.1.7", "7.5"}],
    Cell[65338, 1975, 8977, 115, 76, 8843, 110, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.1.7"],
    Cell[74318, 2092, 289, 6, 70, "Text",
      CellTags->{"S1.1.7", "7.6"}],
    Cell[74610, 2100, 3355, 91, 252, "DefinitionBox",
      CellTags->"S1.1.7"],
    Cell[77968, 2193, 138, 4, 16, "Caption",
      CellTags->"S1.1.7"],
    Cell[78109, 2199, 135, 4, 40, "MathCaption",
      CellTags->{"S1.1.7", "7.7"}],
    Cell[78269, 2207, 73, 2, 28, "Input",
      CellTags->"S1.1.7"],
    Cell[78345, 2211, 100, 3, 25, "Output",
      CellTags->"S1.1.7"],
    Cell[78460, 2217, 134, 4, 40, "MathCaption",
      CellTags->{"S1.1.7", "7.8"}],
    Cell[78619, 2225, 94, 3, 45, "Input",
      CellTags->"S1.1.7"],
    Cell[78716, 2230, 100, 3, 25, "Output",
      CellTags->"S1.1.7"],
    Cell[78831, 2236, 136, 4, 40, "MathCaption",
      CellTags->{"S1.1.7", "7.9"}],
    Cell[78992, 2244, 554, 16, 28, "Input",
      CellTags->"S1.1.7"],
    Cell[79549, 2262, 100, 3, 25, "Output",
      CellTags->"S1.1.7"],
    Cell[79664, 2268, 429, 8, 72, "Text",
      CellTags->{"S1.1.7", "7.10"}],
    Cell[80096, 2278, 376, 7, 72, "Text",
      CellTags->{"S1.1.7", "7.11"}],
    Cell[80475, 2287, 726, 19, 88, "Text",
      CellTags->{"S1.1.7", "7.12"}]},
  "7.1"->{
    Cell[45987, 1707, 93, 1, 70, "Subsection",
      CellTags->{"S1.1.7", "7.1"}]},
  "7.2"->{
    Cell[46083, 1710, 343, 7, 70, "Text",
      CellTags->{"S1.1.7", "7.2"}]},
  "7.3"->{
    Cell[46429, 1719, 365, 9, 70, "Text",
      CellTags->{"S1.1.7", "7.3"}]},
  "7.4"->{
    Cell[46797, 1730, 217, 6, 70, "MathCaption",
      CellTags->{"S1.1.7", "7.4"}]},
  "7.5"->{
    Cell[65126, 1968, 209, 5, 70, "MathCaption",
      CellTags->{"S1.1.7", "7.5"}]},
  "7.6"->{
    Cell[74318, 2092, 289, 6, 70, "Text",
      CellTags->{"S1.1.7", "7.6"}]},
  "7.7"->{
    Cell[78109, 2199, 135, 4, 40, "MathCaption",
      CellTags->{"S1.1.7", "7.7"}]},
  "7.8"->{
    Cell[78460, 2217, 134, 4, 40, "MathCaption",
      CellTags->{"S1.1.7", "7.8"}]},
  "7.9"->{
    Cell[78831, 2236, 136, 4, 40, "MathCaption",
      CellTags->{"S1.1.7", "7.9"}]},
  "7.10"->{
    Cell[79664, 2268, 429, 8, 72, "Text",
      CellTags->{"S1.1.7", "7.10"}]},
  "7.11"->{
    Cell[80096, 2278, 376, 7, 72, "Text",
      CellTags->{"S1.1.7", "7.11"}]},
  "7.12"->{
    Cell[80475, 2287, 726, 19, 88, "Text",
      CellTags->{"S1.1.7", "7.12"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.1.0", 81844, 2326},
  {"0.1", 81934, 2329},
  {"S1.1.1", 82027, 2332},
  {"1.1", 84159, 2391},
  {"1.2", 84251, 2394},
  {"1.3", 84338, 2397},
  {"1.4", 84431, 2400},
  {"1.5", 84525, 2403},
  {"1.6", 84620, 2406},
  {"1.7", 84715, 2409},
  {"1.8", 84810, 2412},
  {"1.9", 84899, 2415},
  {"1.10", 84994, 2418},
  {"1.11", 85091, 2421},
  {"S1.1.2", 85189, 2424},
  {"2.1", 87421, 2485},
  {"2.2", 87514, 2488},
  {"2.3", 87602, 2491},
  {"2.4", 87697, 2494},
  {"2.5", 87786, 2497},
  {"2.6", 87880, 2500},
  {"2.7", 87975, 2503},
  {"2.8", 88070, 2506},
  {"2.9", 88160, 2509},
  {"2.10", 88257, 2512},
  {"2.11", 88355, 2515},
  {"2.12", 88453, 2518},
  {"S1.1.3", 88553, 2521},
  {"3.1", 92086, 2616},
  {"3.2", 92180, 2619},
  {"3.3", 92269, 2622},
  {"3.4", 92359, 2625},
  {"3.5", 92456, 2628},
  {"3.6", 92545, 2631},
  {"3.7", 92641, 2634},
  {"3.8", 92737, 2637},
  {"3.9", 92833, 2640},
  {"3.10", 92930, 2643},
  {"3.11", 93029, 2646},
  {"3.12", 93127, 2649},
  {"3.13", 93219, 2652},
  {"3.14", 93318, 2655},
  {"3.15", 93417, 2658},
  {"3.16", 93516, 2661},
  {"3.17", 93616, 2664},
  {"S1.1.4", 93718, 2667},
  {"4.1", 95023, 2702},
  {"4.2", 95119, 2705},
  {"4.3", 95210, 2708},
  {"4.4", 95308, 2711},
  {"4.5", 95405, 2714},
  {"4.6", 95502, 2717},
  {"4.7", 95592, 2720},
  {"S1.1.5", 95693, 2723},
  {"5.1", 96770, 2752},
  {"5.2", 96865, 2755},
  {"5.3", 96956, 2758},
  {"5.4", 97047, 2761},
  {"5.5", 97144, 2764},
  {"5.6", 97240, 2767},
  {"S1.1.6", 97340, 2770},
  {"6.1", 97980, 2787},
  {"6.2", 98076, 2790},
  {"6.3", 98167, 2793},
  {"6.4", 98258, 2796},
  {"6.5", 98350, 2799},
  {"6.6", 98441, 2802},
  {"S1.1.7", 98535, 2805},
  {"7.1", 100390, 2854},
  {"7.2", 100485, 2857},
  {"7.3", 100575, 2860},
  {"7.4", 100665, 2863},
  {"7.5", 100762, 2866},
  {"7.6", 100859, 2869},
  {"7.7", 100949, 2872},
  {"7.8", 101046, 2875},
  {"7.9", 101143, 2878},
  {"7.10", 101241, 2881},
  {"7.11", 101333, 2884},
  {"7.12", 101425, 2887}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 125, 4, 65, "Section",
  CellTags->{"S1.1.0", "0.1"}],

Cell[CellGroupData[{
Cell[1926, 61, 69, 1, 70, "Subsection",
  CellTags->{"S1.1.1", "1.1"}],
Cell[1998, 64, 177, 5, 70, "Text",
  CellTags->{"S1.1.1", "1.2"}],
Cell[2178, 71, 86, 1, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.3"}],

Cell[CellGroupData[{
Cell[2289, 76, 74, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[2366, 80, 86, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[2467, 86, 187, 7, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.4"}],

Cell[CellGroupData[{
Cell[2679, 97, 77, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[2759, 101, 102, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[2876, 107, 222, 7, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.5"}],

Cell[CellGroupData[{
Cell[3123, 118, 69, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[3195, 122, 83, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[3293, 128, 108, 1, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.6"}],

Cell[CellGroupData[{
Cell[3426, 133, 87, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[3516, 137, 83, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[3614, 143, 137, 4, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.7"}],

Cell[CellGroupData[{
Cell[3776, 151, 78, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[3857, 155, 83, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[3955, 161, 1422, 45, 70, "DefinitionBox",
  CellTags->"S1.1.1"],
Cell[5380, 208, 123, 5, 70, "Caption",
  CellTags->"S1.1.1"],
Cell[5506, 215, 754, 36, 70, "Text",
  CellTags->{"S1.1.1", "1.8"}],
Cell[6263, 253, 99, 1, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.9"}],

Cell[CellGroupData[{
Cell[6387, 258, 72, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[6462, 262, 104, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[6581, 268, 111, 1, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.10"}],

Cell[CellGroupData[{
Cell[6717, 273, 73, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[6793, 277, 89, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]],
Cell[6897, 283, 69, 1, 70, "MathCaption",
  CellTags->{"S1.1.1", "1.11"}],

Cell[CellGroupData[{
Cell[6991, 288, 71, 2, 70, "Input",
  CellTags->"S1.1.1"],
Cell[7065, 292, 89, 3, 70, "Output",
  CellTags->"S1.1.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7203, 301, 88, 1, 70, "Subsection",
  CellTags->{"S1.1.2", "2.1"}],
Cell[7294, 304, 292, 8, 70, "Text",
  CellTags->{"S1.1.2", "2.2"}],
Cell[7589, 314, 274, 9, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.3"}],

Cell[CellGroupData[{
Cell[7888, 327, 71, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[7962, 331, 112, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[8089, 337, 566, 17, 70, "Text",
  CellTags->{"S1.1.2", "2.4"}],
Cell[8658, 356, 98, 1, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.5"}],

Cell[CellGroupData[{
Cell[8781, 361, 75, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[8859, 365, 104, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[8978, 371, 152, 4, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.6"}],

Cell[CellGroupData[{
Cell[9155, 379, 73, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[9231, 383, 87, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[9333, 389, 143, 4, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.7"}],

Cell[CellGroupData[{
Cell[9501, 397, 77, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[9581, 401, 100, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[9696, 407, 508, 16, 70, "DefinitionBox",
  CellTags->"S1.1.2"],
Cell[10207, 425, 75, 1, 70, "Caption",
  CellTags->"S1.1.2"],
Cell[10285, 428, 397, 11, 70, "Text",
  CellTags->{"S1.1.2", "2.8"}],
Cell[10685, 441, 143, 4, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.9"}],

Cell[CellGroupData[{
Cell[10853, 449, 70, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[10926, 453, 88, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[11029, 459, 212, 5, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.10"}],

Cell[CellGroupData[{
Cell[11266, 468, 72, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[11341, 472, 98, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[11454, 478, 205, 5, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.11"}],

Cell[CellGroupData[{
Cell[11684, 487, 71, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[11758, 491, 99, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]],
Cell[11872, 497, 218, 5, 70, "MathCaption",
  CellTags->{"S1.1.2", "2.12"}],

Cell[CellGroupData[{
Cell[12115, 506, 75, 2, 70, "Input",
  CellTags->"S1.1.2"],
Cell[12193, 510, 98, 3, 70, "Output",
  CellTags->"S1.1.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12340, 519, 86, 1, 70, "Subsection",
  CellTags->{"S1.1.3", "3.1"}],
Cell[12429, 522, 310, 8, 70, "Text",
  CellTags->{"S1.1.3", "3.2"}],
Cell[12742, 532, 7566, 228, 70, "DefinitionBox",
  CellTags->"S1.1.3"],
Cell[20311, 762, 77, 1, 70, "Caption",
  CellTags->"S1.1.3"],
Cell[20391, 765, 723, 20, 70, "FramedBox",
  CellTags->"S1.1.3"],
Cell[21117, 787, 138, 5, 70, "Caption",
  CellTags->"S1.1.3"],
Cell[21258, 794, 385, 10, 70, "Text",
  CellTags->{"S1.1.3", "3.3"}],
Cell[21646, 806, 399, 14, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.4"}],

Cell[CellGroupData[{
Cell[22070, 824, 72, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[22145, 828, 99, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[22259, 834, 225, 6, 70, "Text",
  CellTags->{"S1.1.3", "3.5"}],
Cell[22487, 842, 177, 6, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.6"}],

Cell[CellGroupData[{
Cell[22689, 852, 72, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[22764, 856, 82, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[22861, 862, 192, 6, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.7"}],

Cell[CellGroupData[{
Cell[23078, 872, 75, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[23156, 876, 100, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[23271, 882, 199, 5, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.8"}],

Cell[CellGroupData[{
Cell[23495, 891, 72, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[23570, 895, 100, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[23685, 901, 222, 5, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.9"}],

Cell[CellGroupData[{
Cell[23932, 910, 71, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[24006, 914, 84, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[24105, 920, 387, 10, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.10"}],

Cell[CellGroupData[{
Cell[24517, 934, 67, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[24587, 938, 114, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[24716, 944, 126, 4, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.11"}],

Cell[CellGroupData[{
Cell[24867, 952, 71, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[24941, 956, 104, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[25060, 962, 2307, 67, 70, "DefinitionBox",
  CellTags->"S1.1.3"],
Cell[27370, 1031, 77, 1, 70, "Caption",
  CellTags->"S1.1.3"],
Cell[27450, 1034, 148, 4, 70, "Text",
  CellTags->{"S1.1.3", "3.12"}],
Cell[27601, 1040, 185, 6, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.13"}],

Cell[CellGroupData[{
Cell[27811, 1050, 74, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[27888, 1054, 99, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[28002, 1060, 265, 7, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.14"}],

Cell[CellGroupData[{
Cell[28292, 1071, 73, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[28368, 1075, 82, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[28465, 1081, 303, 8, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.15"}],

Cell[CellGroupData[{
Cell[28793, 1093, 83, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[28879, 1097, 101, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[28995, 1103, 284, 11, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.16"}],

Cell[CellGroupData[{
Cell[29304, 1118, 75, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[29382, 1122, 83, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]],
Cell[29480, 1128, 361, 14, 70, "MathCaption",
  CellTags->{"S1.1.3", "3.17"}],

Cell[CellGroupData[{
Cell[29866, 1146, 76, 2, 70, "Input",
  CellTags->"S1.1.3"],
Cell[29945, 1150, 83, 3, 70, "Output",
  CellTags->"S1.1.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30077, 1159, 107, 3, 70, "Subsection",
  CellTags->{"S1.1.4", "4.1"}],
Cell[30187, 1164, 529, 13, 70, "Text",
  CellTags->{"S1.1.4", "4.2"}],
Cell[30719, 1179, 1094, 34, 70, "DefinitionBox",
  CellTags->"S1.1.4"],
Cell[31816, 1215, 73, 1, 70, "Caption",
  CellTags->"S1.1.4"],
Cell[31892, 1218, 351, 12, 70, "MathCaption",
  CellTags->{"S1.1.4", "4.3"}],

Cell[CellGroupData[{
Cell[32268, 1234, 69, 2, 70, "Input",
  CellTags->"S1.1.4"],
Cell[32340, 1238, 99, 3, 70, "Output",
  CellTags->"S1.1.4"]
}, Open  ]],
Cell[32454, 1244, 171, 6, 70, "MathCaption",
  CellTags->{"S1.1.4", "4.4"}],

Cell[CellGroupData[{
Cell[32650, 1254, 73, 2, 70, "Input",
  CellTags->"S1.1.4"],
Cell[32726, 1258, 147, 4, 70, "Output",
  CellTags->"S1.1.4"]
}, Open  ]],
Cell[32888, 1265, 166, 6, 70, "MathCaption",
  CellTags->{"S1.1.4", "4.5"}],

Cell[CellGroupData[{
Cell[33079, 1275, 78, 2, 70, "Input",
  CellTags->"S1.1.4"],
Cell[33160, 1279, 136, 3, 70, "Output",
  CellTags->"S1.1.4"]
}, Open  ]],
Cell[33311, 1285, 378, 7, 70, "Text",
  CellTags->{"S1.1.4", "4.6"}],
Cell[33692, 1294, 390, 10, 70, "MathCaption",
  CellTags->{"S1.1.4", "4.7"}],

Cell[CellGroupData[{
Cell[34107, 1308, 88, 2, 70, "Input",
  CellTags->"S1.1.4"],
Cell[34198, 1312, 148, 4, 70, "Output",
  CellTags->"S1.1.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34395, 1322, 74, 1, 70, "Subsection",
  CellTags->{"S1.1.5", "5.1"}],
Cell[34472, 1325, 352, 12, 70, "Text",
  CellTags->{"S1.1.5", "5.2"}],
Cell[34827, 1339, 824, 27, 70, "Text",
  CellTags->{"S1.1.5", "5.3"}],
Cell[35654, 1368, 270, 9, 70, "MathCaption",
  CellTags->{"S1.1.5", "5.4"}],

Cell[CellGroupData[{
Cell[35949, 1381, 72, 2, 70, "Input",
  CellTags->"S1.1.5"],
Cell[36024, 1385, 97, 3, 70, "Output",
  CellTags->"S1.1.5"]
}, Open  ]],
Cell[36136, 1391, 99, 1, 70, "MathCaption",
  CellTags->{"S1.1.5", "5.5"}],

Cell[CellGroupData[{
Cell[36260, 1396, 83, 2, 70, "Input",
  CellTags->"S1.1.5"],
Cell[36346, 1400, 101, 3, 70, "Output",
  CellTags->"S1.1.5"]
}, Open  ]],
Cell[36462, 1406, 108, 1, 70, "MathCaption",
  CellTags->{"S1.1.5", "5.6"}],

Cell[CellGroupData[{
Cell[36595, 1411, 80, 2, 70, "Input",
  CellTags->"S1.1.5"],
Cell[36678, 1415, 148, 4, 70, "Output",
  CellTags->"S1.1.5"]
}, Open  ]],
Cell[36841, 1422, 3342, 99, 70, "DefinitionBox",
  CellTags->"S1.1.5"],
Cell[40186, 1523, 68, 1, 70, "Caption",
  CellTags->"S1.1.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40291, 1529, 125, 4, 70, "Subsection",
  CellTags->{"S1.1.6", "6.1"}],
Cell[40419, 1535, 1131, 37, 70, "FramedBox",
  CellTags->"S1.1.6"],
Cell[41553, 1574, 130, 5, 70, "Caption",
  CellTags->"S1.1.6"],
Cell[41686, 1581, 533, 12, 70, "Text",
  CellTags->{"S1.1.6", "6.2"}],
Cell[42222, 1595, 768, 15, 70, "Text",
  CellTags->{"S1.1.6", "6.3"}],
Cell[42993, 1612, 1151, 45, 70, "Text",
  CellTags->{"S1.1.6", "6.4"}],
Cell[44147, 1659, 987, 20, 70, "Text",
  CellTags->{"S1.1.6", "6.5"}],
Cell[45137, 1681, 813, 21, 70, "Text",
  CellTags->{"S1.1.6", "6.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[45987, 1707, 93, 1, 70, "Subsection",
  CellTags->{"S1.1.7", "7.1"}],
Cell[46083, 1710, 343, 7, 70, "Text",
  CellTags->{"S1.1.7", "7.2"}],
Cell[46429, 1719, 365, 9, 70, "Text",
  CellTags->{"S1.1.7", "7.3"}],
Cell[46797, 1730, 217, 6, 70, "MathCaption",
  CellTags->{"S1.1.7", "7.4"}],
Cell[47017, 1738, 18106, 228, 70, 17972, 223, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.1.7"],
Cell[65126, 1968, 209, 5, 70, "MathCaption",
  CellTags->{"S1.1.7", "7.5"}],
Cell[65338, 1975, 8977, 115, 76, 8843, 110, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.1.7"],
Cell[74318, 2092, 289, 6, 70, "Text",
  CellTags->{"S1.1.7", "7.6"}],
Cell[74610, 2100, 3355, 91, 252, "DefinitionBox",
  CellTags->"S1.1.7"],
Cell[77968, 2193, 138, 4, 16, "Caption",
  CellTags->"S1.1.7"],
Cell[78109, 2199, 135, 4, 40, "MathCaption",
  CellTags->{"S1.1.7", "7.7"}],

Cell[CellGroupData[{
Cell[78269, 2207, 73, 2, 28, "Input",
  CellTags->"S1.1.7"],
Cell[78345, 2211, 100, 3, 25, "Output",
  CellTags->"S1.1.7"]
}, Open  ]],
Cell[78460, 2217, 134, 4, 40, "MathCaption",
  CellTags->{"S1.1.7", "7.8"}],

Cell[CellGroupData[{
Cell[78619, 2225, 94, 3, 45, "Input",
  CellTags->"S1.1.7"],
Cell[78716, 2230, 100, 3, 25, "Output",
  CellTags->"S1.1.7"]
}, Open  ]],
Cell[78831, 2236, 136, 4, 40, "MathCaption",
  CellTags->{"S1.1.7", "7.9"}],

Cell[CellGroupData[{
Cell[78992, 2244, 554, 16, 28, "Input",
  CellTags->"S1.1.7"],
Cell[79549, 2262, 100, 3, 25, "Output",
  CellTags->"S1.1.7"]
}, Open  ]],
Cell[79664, 2268, 429, 8, 72, "Text",
  CellTags->{"S1.1.7", "7.10"}],
Cell[80096, 2278, 376, 7, 72, "Text",
  CellTags->{"S1.1.7", "7.11"}],
Cell[80475, 2287, 726, 19, 88, "Text",
  CellTags->{"S1.1.7", "7.12"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

