(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     34957,       1321]*)
(*NotebookOutlinePosition[     51571,       1824]*)
(*  CellTagsIndexPosition[     50056,       1759]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.2 ", "HeadingNumber"],
  "Building Up Calculations"
}], "Section",
  CellTags->{"S1.2.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.2.1 Using Previous Results", "Subsection",
  CellTags->{"S1.2.1", "1.1"}],

Cell[TextData[{
  "In doing calculations, you will often need to use previous results that \
you have got. In ",
  StyleBox["Mathematica", "TI"],
  ", ",
  StyleBox["%", "MR"],
  " always stands for your last result. "
}], "Text",
  CellTags->{"S1.2.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["%", "MR"],
              " "
            }]], Cell["the last result generated "]},
          {Cell[TextData[{
              StyleBox["%%", "MR"],
              " "
            }]], Cell["the next\[Hyphen]to\[Hyphen]last result "]},
          {Cell[TextData[{
              StyleBox["%%", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["%", "MR"],
              " (",
              Cell[BoxData[
                  FormBox[
                    StyleBox["k",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " times) "
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["k",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " previous result "
            }]]},
          {Cell[TextData[{
              StyleBox["%", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the result on output line ",
              StyleBox["Out[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " (to be used with care) "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.1"],

Cell["Ways to refer to your previous results. ", "Caption",
  CellTags->"S1.2.1"],

Cell["Here is the first result. ", "MathCaption",
  CellTags->{"S1.2.1", "1.3"}],

Cell[CellGroupData[{

Cell["77 ^ 2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.2.1"],

Cell[BoxData[
    \(5929\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.2.1"]
}, Open  ]],

Cell["This adds 1 to the last result. ", "MathCaption",
  CellTags->{"S1.2.1", "1.4"}],

Cell[CellGroupData[{

Cell["% + 1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.2.1"],

Cell[BoxData[
    \(5930\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.2.1"]
}, Open  ]],

Cell["This uses both the last result, and the result before that. ", \
"MathCaption",
  CellTags->{"S1.2.1", "1.5"}],

Cell[CellGroupData[{

Cell["3 % + % ^ 2 + %%", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.2.1"],

Cell[BoxData[
    \(35188619\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.2.1"]
}, Open  ]],

Cell[TextData[{
  "You will have noticed that all the input and output lines in ",
  StyleBox["Mathematica", "TI"],
  " are numbered. You can use these numbers to refer to previous results. "
}], "Text",
  CellTags->{"S1.2.1", "1.6"}],

Cell[TextData[{
  "This adds the results on lines ",
  StyleBox["2", "MR"],
  " and ",
  StyleBox["3", "MR"],
  " above. "
}], "MathCaption",
  CellTags->{"S1.2.1", "1.7"}],

Cell[CellGroupData[{

Cell["%2 + %3", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.2.1"],

Cell[BoxData[
    \(35194549\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.2.1"]
}, Open  ]],

Cell[TextData[{
  "If you use a text\[Hyphen]based interface to ",
  StyleBox["Mathematica", "TI"],
  ", then successive input and output lines will always appear in order, as \
they do in the dialogs in this book. However, if you use a notebook interface \
to ",
  StyleBox["Mathematica", "TI"],
  ", as discussed in Section ",
  ButtonBox["1.0.1",
    ButtonData:>{"1.0.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", then successive input and output lines need not appear in order. You can \
for example \[OpenCurlyDoubleQuote]scroll back\[CloseCurlyDoubleQuote] and \
insert your next calculation wherever you want in the notebook. You should \
realize that ",
  StyleBox["%", "MR"],
  " is always defined to be the last result that ",
  StyleBox["Mathematica", "TI"],
  " generated. This may or may not be the result that appears immediately \
above your present position in the notebook. With a notebook interface, the \
only way to tell when a particular result was generated is to look at the ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " label that it has. Because you can insert and delete anywhere in a \
notebook, the textual ordering of results in a notebook need have no relation \
to the order in which the results were generated. "
}], "Text",
  CellTags->{"S1.2.1", "1.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.2 Defining Variables", "Subsection",
  CellTags->{"S1.2.2", "2.1"}],

Cell[TextData[{
  "When you do long calculations, it is often convenient to give ",
  StyleBox["names", "TI"],
  " to your intermediate results. Just as in standard mathematics, or in \
other computer languages, you can do this by introducing named ",
  StyleBox["variables", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.2.2", "2.2"}],

Cell[TextData[{
  "This sets the value of the ",
  StyleBox["variable", "TI"],
  " ",
  StyleBox["x", "MR"],
  " to be ",
  StyleBox["5", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.2.2", "2.3"}],

Cell[CellGroupData[{

Cell["x = 5", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.2.2"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[TextData[{
  "Whenever ",
  StyleBox["x", "MR"],
  " appears, ",
  StyleBox["Mathematica", "TI"],
  " now replaces it with the value ",
  StyleBox["5", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.2.2", "2.4"}],

Cell[CellGroupData[{

Cell["x ^ 2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.2.2"],

Cell[BoxData[
    \(25\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[TextData[{
  "This assigns a new value to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.2.2", "2.5"}],

Cell[CellGroupData[{

Cell["x = 7 + 4", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.2.2"],

Cell[BoxData[
    \(11\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["pi", "MR"],
  " is set to be the numerical value of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " to 40\[Hyphen]digit accuracy. "
}], "MathCaption",
  CellTags->{"S1.2.2", "2.6"}],

Cell[CellGroupData[{

Cell["pi = N[Pi, 40]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.2.2"],

Cell[BoxData[
    \(3.141592653589793238462643383279502884197169399375105820985`40. \)], \
"Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[TextData[{
  "Here is the value you defined for ",
  StyleBox["pi", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.2.2", "2.7"}],

Cell[CellGroupData[{

Cell["pi", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.2.2"],

Cell[BoxData[
    \(3.141592653589793238462643383279502884197169399375105820985`40. \)], \
"Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[TextData[{
  "This gives the numerical value of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^2\)], "InlineFormula"],
  ", to the same accuracy as ",
  StyleBox["pi", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.2.2", "2.8"}],

Cell[CellGroupData[{

Cell["pi ^ 2", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.2.2"],

Cell[BoxData[
    \(9.869604401089358618834490999876151135313699407240790626476`39.\
69897000433602\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "assign a value to the variable ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "assign a value to both ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Clear[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove any value assigned to ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.2"],

Cell["Assigning values to variables. ", "Caption",
  CellTags->"S1.2.2"],

Cell[TextData[{
  "It is very important to realize that values you assign to variables are ",
  StyleBox["permanent", "TI"],
  ". Once you have assigned a value to a particular variable, the value will \
be kept until you explicitly remove it. The value will, of course, disappear \
if you start a whole new ",
  StyleBox["Mathematica", "TI"],
  " session. "
}], "Text",
  CellTags->{"S1.2.2", "2.9"}],

Cell[TextData[{
  "Forgetting about definitions you made earlier is the single most common \
cause of mistakes when using ",
  StyleBox["Mathematica", "TI"],
  ". If you set ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["5", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " assumes that you ",
  StyleBox["always", "TI"],
  " want ",
  StyleBox["x", "MR"],
  " to have the value ",
  StyleBox["5", "MR"],
  ", until or unless you explicitly tell it otherwise. To avoid mistakes, you \
should remove values you have defined as soon as you have finished using \
them. "
}], "Text",
  CellTags->{"S1.2.2", "2.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Remove values you assign to \
variables as soon as you finish using them. \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.2"],

Cell[TextData[{
  "A useful principle in using ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.2.2"],

Cell[TextData[{
  "The variables you define can have almost any names. There is no limit on \
the length of their names. One constraint, however, is that variable names \
can never ",
  StyleBox["start", "TI"],
  " with numbers. For example, ",
  StyleBox["x2", "MR"],
  " could be a variable, but ",
  StyleBox["2x", "MR"],
  " means ",
  StyleBox["2*x", "MR"],
  ".   "
}], "Text",
  CellTags->{"S1.2.2", "2.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses both upper\[Hyphen] and lower\[Hyphen]case letters. There is a \
convention that built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " objects always have names starting with upper\[Hyphen]case (capital) \
letters. To avoid confusion, you should always choose names for your own \
variables that start with lower\[Hyphen]case letters.   "
}], "Text",
  CellTags->{"S1.2.2", "2.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["aaaaa", "TI"],
              " "
            }]], 
            Cell["\<\
a variable name containing only lower\[Hyphen]case \
letters \
\>"]},
          {Cell[TextData[{
              StyleBox["Aaaaa", "TI"],
              " "
            }]], 
            Cell["\<\
a built\[Hyphen]in object whose name begins with a \
capital letter \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.2"],

Cell["Naming conventions. ", "Caption",
  CellTags->"S1.2.2"],

Cell[TextData[{
  "You can type formulas involving variables in ",
  StyleBox["Mathematica", "TI"],
  " almost exactly as you would in mathematics. There are a few important \
points to watch, however. "
}], "Text",
  CellTags->{"S1.2.2", "2.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["y", "MR"],
              " means ",
              StyleBox["x", "MR"],
              " times ",
              StyleBox["y", "MR"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["xy", "MR"],
              " with no space is the variable with name ",
              StyleBox["xy", "MR"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["5x", "MR"],
              " means ",
              StyleBox["5", "MR"],
              " times ",
              StyleBox["x", "MR"],
              ". "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["x^2y", "MR"],
              " means ",
              StyleBox["(x^2)", "MR"],
              " ",
              StyleBox["y", "MR"],
              ", not ",
              StyleBox["x^(2y)", "MR"],
              ". "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.2"],

Cell[TextData[{
  "Some points to watch when using variables in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.3 Making Lists of Objects", "Subsection",
  CellTags->{"S1.2.3", "3.1"}],

Cell[TextData[{
  "In doing calculations, it is often convenient to collect together several \
objects, and treat them as a single entity. ",
  StyleBox["Lists", "TI"],
  " give you a way to make collections of objects in ",
  StyleBox["Mathematica", "TI"],
  ". As you will see later, lists are very important and general structures \
in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.2.3", "3.2"}],

Cell[TextData[{
  "A list such as ",
  StyleBox["{3,", "MR"],
  " ",
  StyleBox["5,", "MR"],
  " ",
  StyleBox["1}", "MR"],
  " is a collection of three objects. But in many ways, you can treat the \
whole list as a single object. You can, for example, do arithmetic on the \
whole list at once, or assign the whole list to be the value of a variable. "
}], "Text",
  CellTags->{"S1.2.3", "3.3"}],

Cell["Here is a list of three numbers. ", "MathCaption",
  CellTags->{"S1.2.3", "3.4"}],

Cell[CellGroupData[{

Cell["{3, 5, 1}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({3, 5, 1}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.2.3"]
}, Open  ]],

Cell[TextData[{
  "This squares each number in the list, and adds ",
  StyleBox["1", "MR"],
  " to it. "
}], "MathCaption",
  CellTags->{"S1.2.3", "3.5"}],

Cell[CellGroupData[{

Cell["{3, 5, 1}^2 + 1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({10, 26, 2}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.2.3"]
}, Open  ]],

Cell["\<\
This takes differences between corresponding elements in the two \
lists. The lists must be the same length. \
\>", "MathCaption",
  CellTags->{"S1.2.3", "3.6"}],

Cell[CellGroupData[{

Cell["{6, 7, 8} - {3.5, 4, 2.5}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({2.5`, 3, 5.5`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.2.3"]
}, Open  ]],

Cell[TextData[{
  "The value of ",
  StyleBox["%", "MR"],
  " is the whole list. "
}], "MathCaption",
  CellTags->{"S1.2.3", "3.7"}],

Cell[CellGroupData[{

Cell["%", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({2.5`, 3, 5.5`}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.2.3"]
}, Open  ]],

Cell[TextData[{
  "You can apply any of the mathematical functions in Section ",
  ButtonBox["1.1.3",
    ButtonData:>{"1.1.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " to whole lists. "
}], "MathCaption",
  CellTags->{"S1.2.3", "3.8"}],

Cell[CellGroupData[{

Cell["Exp[ % ] // N", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({12.182493960703473`, 20.085536923187668`, 
      244.69193226422038`}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.2.3"]
}, Open  ]],

Cell["\<\
Just as you can set variables to be numbers, so also you can set \
them to be lists. \
\>", "Text",
  CellTags->{"S1.2.3", "3.9"}],

Cell[TextData[{
  "This assigns ",
  StyleBox["v", "MR"],
  " to be a list. "
}], "MathCaption",
  CellTags->{"S1.2.3", "3.10"}],

Cell[CellGroupData[{

Cell["v = {2, 4, 3.1}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({2, 4, 3.1`}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.2.3"]
}, Open  ]],

Cell[TextData[{
  "Wherever ",
  StyleBox["v", "MR"],
  " appears, it is replaced by the list. "
}], "MathCaption",
  CellTags->{"S1.2.3", "3.11"}],

Cell[CellGroupData[{

Cell["v / (v - 1)", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.2.3"],

Cell[BoxData[
    \({2, 4\/3, 1.476190476190476`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.2.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.4 Manipulating Elements of Lists", "Subsection",
  CellTags->{"S1.2.4", "4.1"}],

Cell[TextData[{
  "Many of the most powerful list manipulation operations in ",
  StyleBox["Mathematica", "TI"],
  " treat whole lists as single objects. Sometimes, however, you need to pick \
out or set individual elements in a list.  "
}], "Text",
  CellTags->{"S1.2.4", "4.2"}],

Cell[TextData[{
  "You can refer to an element of a ",
  StyleBox["Mathematica", "TI"],
  " list by giving its \[OpenCurlyDoubleQuote]index\[CloseCurlyDoubleQuote]. \
The elements are numbered in order, starting at 1.  "
}], "Text",
  CellTags->{"S1.2.4", "4.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["a list "]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element of ",
              StyleBox["list", "TI"],
              " (the first element is ",
              StyleBox["list", "TI"],
              StyleBox["[[1]]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["list", "TI"],
              StyleBox["[[{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              ", ",
              StyleBox["j", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " elements of ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.4"],

Cell["Operations on list elements. ", "Caption",
  CellTags->"S1.2.4"],

Cell["This extracts the second element of the list. ", "MathCaption",
  CellTags->{"S1.2.4", "4.4"}],

Cell[CellGroupData[{

Cell["{5, 8, 6, 9}[[2]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.2.4"]
}, Open  ]],

Cell["This extracts a list of elements. ", "MathCaption",
  CellTags->{"S1.2.4", "4.5"}],

Cell[CellGroupData[{

Cell["{5, 8, 6, 9}[[ {3, 1, 3, 2, 4} ]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \({6, 5, 6, 8, 9}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.2.4"]
}, Open  ]],

Cell[TextData[{
  "This assigns the value of ",
  StyleBox["v", "MR"],
  " to be a list. "
}], "MathCaption",
  CellTags->{"S1.2.4", "4.6"}],

Cell[CellGroupData[{

Cell["v = {2, 4, 7}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \({2, 4, 7}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.2.4"]
}, Open  ]],

Cell[TextData[{
  "You can extract elements of ",
  StyleBox["v", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.2.4", "4.7"}],

Cell[CellGroupData[{

Cell["v[[ 2 ]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.2.4"]
}, Open  ]],

Cell[TextData[{
  "By assigning a variable to be a list, you can use ",
  StyleBox["Mathematica", "TI"],
  " lists much like \[OpenCurlyDoubleQuote]arrays\[CloseCurlyDoubleQuote] in \
other computer languages. Thus, for example, you can reset an element of a \
list by assigning a value to ",
  StyleBox["v", "TI"],
  StyleBox["[[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.2.4", "4.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["v", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "extract the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element of a list "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["v", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "reset the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element of a list "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.4"],

Cell["\<\
Array\[Hyphen]like operations on lists. \
\>", "Caption",
  CellTags->"S1.2.4"],

Cell["Here is a list. ", "MathCaption",
  CellTags->{"S1.2.4", "4.9"}],

Cell[CellGroupData[{

Cell["v = {4, -1, 8, 7}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \({4, \(-1\), 8, 7}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.2.4"]
}, Open  ]],

Cell["This resets the third element of the list. ", "MathCaption",
  CellTags->{"S1.2.4", "4.10"}],

Cell[CellGroupData[{

Cell["v[[3]] = 0", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.2.4"]
}, Open  ]],

Cell[TextData[{
  "Now the list assigned to ",
  StyleBox["v", "MR"],
  " has been modified. "
}], "MathCaption",
  CellTags->{"S1.2.4", "4.11"}],

Cell[CellGroupData[{

Cell["v", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.2.4"],

Cell[BoxData[
    \({4, \(-1\), 0, 7}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.2.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.2.5 The Four Kinds of Bracketing in ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S1.2.5", "5.1"}],

Cell[TextData[{
  "Over the course of the last few sections, we have introduced each of the \
four kinds of bracketing used in ",
  StyleBox["Mathematica", "TI"],
  ". Each kind of bracketing has a very different meaning. It is important \
that you remember all of them. "
}], "Text",
  CellTags->{"S1.2.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["term", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell["parentheses for grouping "]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["square brackets for functions "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["curly braces for lists "]},
          {Cell[TextData[{
              StyleBox["v", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "double brackets for indexing (",
              StyleBox["Part[", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.5"],

Cell[TextData[{
  "The four kinds of bracketing in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.2.5"],

Cell[TextData[{
  "When the expressions you type in are complicated, it is often a good idea \
to put extra space inside each set of brackets. This makes it somewhat easier \
for you to see matching pairs of brackets. ",
  StyleBox["v", "TI"],
  StyleBox["[[", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["}", "MR"],
  " ",
  StyleBox["]]", "MR"],
  " is, for example, easier to recognize than ",
  StyleBox["v", "TI"],
  StyleBox["[[{", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["}]]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.2.5", "5.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.2.6 Sequences of Operations", "Subsection",
  CellTags->{"S1.2.6", "6.1"}],

Cell[TextData[{
  "In doing a calculation with ",
  StyleBox["Mathematica", "TI"],
  ", you usually go through a sequence of steps. If you want to, you can do \
each step on a separate line. Often, however, you will find it convenient to \
put several steps on the same line. You can do this simply by separating the \
pieces of input you want to give with semicolons. "
}], "Text",
  CellTags->{"S1.2.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[
            "do several operations, and give the result of the last one "]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " "
            }]], Cell["do the operations, but print no output "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.6"],

Cell[TextData[{
  "Ways to do sequences of operations in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.2.6"],

Cell["\<\
This does three operations on the same line. The result is the \
result from the last operation. \
\>", "MathCaption",
  CellTags->{"S1.2.6", "6.3"}],

Cell[CellGroupData[{

Cell["x = 4; y = 6; z = y + 6", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.2.6"],

Cell[BoxData[
    \(12\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.2.6"]
}, Open  ]],

Cell[TextData[{
  "If you end your input with a semicolon, it is as if you are giving a \
sequence of operations, with an \[OpenCurlyDoubleQuote]empty\
\[CloseCurlyDoubleQuote] one at the end. This has the effect of making ",
  StyleBox["Mathematica", "TI"],
  " perform the operations you specify, but display no output. "
}], "Text",
  CellTags->{"S1.2.6", "6.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[";", "MR"],
              " "
            }]], Cell["do an operation, but display no output "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.2.6"],

Cell["Inhibiting output. ", "Caption",
  CellTags->"S1.2.6"],

Cell[TextData[{
  "Putting a semicolon at the end of the line tells ",
  StyleBox["Mathematica", "TI"],
  " to show no output. "
}], "MathCaption",
  CellTags->{"S1.2.6", "6.5"}],

Cell["x = 67 - 5 ;", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.2.6"],

Cell[TextData[{
  "You can still use ",
  StyleBox["%", "MR"],
  " to get the output that would have been shown. "
}], "MathCaption",
  CellTags->{"S1.2.6", "6.6"}],

Cell[CellGroupData[{

Cell["%", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.2.6"],

Cell[BoxData[
    \(62\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.2.6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.2.0"->{
    Cell[1776, 53, 127, 4, 65, "Section",
      CellTags->{"S1.2.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 127, 4, 65, "Section",
      CellTags->{"S1.2.0", "0.1"}]},
  "S1.2.1"->{
    Cell[1928, 61, 81, 1, 70, "Subsection",
      CellTags->{"S1.2.1", "1.1"}],
    Cell[2012, 64, 261, 8, 70, "Text",
      CellTags->{"S1.2.1", "1.2"}],
    Cell[2276, 74, 1572, 47, 70, "DefinitionBox",
      CellTags->"S1.2.1"],
    Cell[3851, 123, 81, 1, 70, "Caption",
      CellTags->"S1.2.1"],
    Cell[3935, 126, 80, 1, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.3"}],
    Cell[4040, 131, 70, 2, 70, "Input",
      CellTags->"S1.2.1"],
    Cell[4113, 135, 85, 3, 70, "Output",
      CellTags->"S1.2.1"],
    Cell[4213, 141, 86, 1, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.4"}],
    Cell[4324, 146, 69, 2, 70, "Input",
      CellTags->"S1.2.1"],
    Cell[4396, 150, 85, 3, 70, "Output",
      CellTags->"S1.2.1"],
    Cell[4496, 156, 116, 2, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.5"}],
    Cell[4637, 162, 80, 2, 70, "Input",
      CellTags->"S1.2.1"],
    Cell[4720, 166, 89, 3, 70, "Output",
      CellTags->"S1.2.1"],
    Cell[4824, 172, 234, 5, 70, "Text",
      CellTags->{"S1.2.1", "1.6"}],
    Cell[5061, 179, 172, 7, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.7"}],
    Cell[5258, 190, 71, 2, 70, "Input",
      CellTags->"S1.2.1"],
    Cell[5332, 194, 89, 3, 70, "Output",
      CellTags->"S1.2.1"],
    Cell[5436, 200, 1326, 28, 70, "Text",
      CellTags->{"S1.2.1", "1.8"}]},
  "1.1"->{
    Cell[1928, 61, 81, 1, 70, "Subsection",
      CellTags->{"S1.2.1", "1.1"}]},
  "1.2"->{
    Cell[2012, 64, 261, 8, 70, "Text",
      CellTags->{"S1.2.1", "1.2"}]},
  "1.3"->{
    Cell[3935, 126, 80, 1, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.3"}]},
  "1.4"->{
    Cell[4213, 141, 86, 1, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.4"}]},
  "1.5"->{
    Cell[4496, 156, 116, 2, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.5"}]},
  "1.6"->{
    Cell[4824, 172, 234, 5, 70, "Text",
      CellTags->{"S1.2.1", "1.6"}]},
  "1.7"->{
    Cell[5061, 179, 172, 7, 70, "MathCaption",
      CellTags->{"S1.2.1", "1.7"}]},
  "1.8"->{
    Cell[5436, 200, 1326, 28, 70, "Text",
      CellTags->{"S1.2.1", "1.8"}]},
  "S1.2.2"->{
    Cell[6799, 233, 77, 1, 70, "Subsection",
      CellTags->{"S1.2.2", "2.1"}],
    Cell[6879, 236, 332, 8, 70, "Text",
      CellTags->{"S1.2.2", "2.2"}],
    Cell[7214, 246, 201, 9, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.3"}],
    Cell[7440, 259, 69, 2, 70, "Input",
      CellTags->"S1.2.2"],
    Cell[7512, 263, 82, 3, 70, "Output",
      CellTags->"S1.2.2"],
    Cell[7609, 269, 220, 9, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.4"}],
    Cell[7854, 282, 69, 2, 70, "Input",
      CellTags->"S1.2.2"],
    Cell[7926, 286, 83, 3, 70, "Output",
      CellTags->"S1.2.2"],
    Cell[8024, 292, 129, 5, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.5"}],
    Cell[8178, 301, 73, 2, 70, "Input",
      CellTags->"S1.2.2"],
    Cell[8254, 305, 83, 3, 70, "Output",
      CellTags->"S1.2.2"],
    Cell[8352, 311, 237, 7, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.6"}],
    Cell[8614, 322, 78, 2, 70, "Input",
      CellTags->"S1.2.2"],
    Cell[8695, 326, 147, 4, 70, "Output",
      CellTags->"S1.2.2"],
    Cell[8857, 333, 136, 5, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.7"}],
    Cell[9018, 342, 66, 2, 70, "Input",
      CellTags->"S1.2.2"],
    Cell[9087, 346, 147, 4, 70, "Output",
      CellTags->"S1.2.2"],
    Cell[9249, 353, 240, 8, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.8"}],
    Cell[9514, 365, 70, 2, 70, "Input",
      CellTags->"S1.2.2"],
    Cell[9587, 369, 160, 4, 70, "Output",
      CellTags->"S1.2.2"],
    Cell[9762, 376, 1494, 50, 70, "DefinitionBox",
      CellTags->"S1.2.2"],
    Cell[11259, 428, 72, 1, 70, "Caption",
      CellTags->"S1.2.2"],
    Cell[11334, 431, 401, 9, 70, "Text",
      CellTags->{"S1.2.2", "2.9"}],
    Cell[11738, 442, 642, 22, 70, "Text",
      CellTags->{"S1.2.2", "2.10"}],
    Cell[12383, 466, 331, 11, 70, "FramedBox",
      CellTags->"S1.2.2"],
    Cell[12717, 479, 126, 5, 70, "Caption",
      CellTags->"S1.2.2"],
    Cell[12846, 486, 415, 13, 70, "Text",
      CellTags->{"S1.2.2", "2.11"}],
    Cell[13264, 501, 443, 9, 70, "Text",
      CellTags->{"S1.2.2", "2.12"}],
    Cell[13710, 512, 599, 22, 70, "DefinitionBox",
      CellTags->"S1.2.2"],
    Cell[14312, 536, 61, 1, 70, "Caption",
      CellTags->"S1.2.2"],
    Cell[14376, 539, 247, 6, 70, "Text",
      CellTags->{"S1.2.2", "2.13"}],
    Cell[14626, 547, 1321, 44, 70, "FramedBox",
      CellTags->"S1.2.2"],
    Cell[15950, 593, 143, 5, 70, "Caption",
      CellTags->"S1.2.2"]},
  "2.1"->{
    Cell[6799, 233, 77, 1, 70, "Subsection",
      CellTags->{"S1.2.2", "2.1"}]},
  "2.2"->{
    Cell[6879, 236, 332, 8, 70, "Text",
      CellTags->{"S1.2.2", "2.2"}]},
  "2.3"->{
    Cell[7214, 246, 201, 9, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.3"}]},
  "2.4"->{
    Cell[7609, 269, 220, 9, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.4"}]},
  "2.5"->{
    Cell[8024, 292, 129, 5, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.5"}]},
  "2.6"->{
    Cell[8352, 311, 237, 7, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.6"}]},
  "2.7"->{
    Cell[8857, 333, 136, 5, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.7"}]},
  "2.8"->{
    Cell[9249, 353, 240, 8, 70, "MathCaption",
      CellTags->{"S1.2.2", "2.8"}]},
  "2.9"->{
    Cell[11334, 431, 401, 9, 70, "Text",
      CellTags->{"S1.2.2", "2.9"}]},
  "2.10"->{
    Cell[11738, 442, 642, 22, 70, "Text",
      CellTags->{"S1.2.2", "2.10"}]},
  "2.11"->{
    Cell[12846, 486, 415, 13, 70, "Text",
      CellTags->{"S1.2.2", "2.11"}]},
  "2.12"->{
    Cell[13264, 501, 443, 9, 70, "Text",
      CellTags->{"S1.2.2", "2.12"}]},
  "2.13"->{
    Cell[14376, 539, 247, 6, 70, "Text",
      CellTags->{"S1.2.2", "2.13"}]},
  "S1.2.3"->{
    Cell[16130, 603, 82, 1, 70, "Subsection",
      CellTags->{"S1.2.3", "3.1"}],
    Cell[16215, 606, 424, 11, 70, "Text",
      CellTags->{"S1.2.3", "3.2"}],
    Cell[16642, 619, 396, 11, 70, "Text",
      CellTags->{"S1.2.3", "3.3"}],
    Cell[17041, 632, 87, 1, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.4"}],
    Cell[17153, 637, 73, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[17229, 641, 90, 3, 70, "Output",
      CellTags->"S1.2.3"],
    Cell[17334, 647, 154, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.5"}],
    Cell[17513, 656, 79, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[17595, 660, 92, 3, 70, "Output",
      CellTags->"S1.2.3"],
    Cell[17702, 666, 171, 4, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.6"}],
    Cell[17898, 674, 89, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[17990, 678, 96, 3, 70, "Output",
      CellTags->"S1.2.3"],
    Cell[18101, 684, 132, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.7"}],
    Cell[18258, 693, 65, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[18326, 697, 96, 3, 70, "Output",
      CellTags->"S1.2.3"],
    Cell[18437, 703, 241, 7, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.8"}],
    Cell[18703, 714, 77, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[18783, 718, 151, 4, 70, "Output",
      CellTags->"S1.2.3"],
    Cell[18949, 725, 140, 4, 70, "Text",
      CellTags->{"S1.2.3", "3.9"}],
    Cell[19092, 731, 128, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.10"}],
    Cell[19245, 740, 79, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[19327, 744, 93, 3, 70, "Output",
      CellTags->"S1.2.3"],
    Cell[19435, 750, 147, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.11"}],
    Cell[19607, 759, 75, 2, 70, "Input",
      CellTags->"S1.2.3"],
    Cell[19685, 763, 110, 3, 70, "Output",
      CellTags->"S1.2.3"]},
  "3.1"->{
    Cell[16130, 603, 82, 1, 70, "Subsection",
      CellTags->{"S1.2.3", "3.1"}]},
  "3.2"->{
    Cell[16215, 606, 424, 11, 70, "Text",
      CellTags->{"S1.2.3", "3.2"}]},
  "3.3"->{
    Cell[16642, 619, 396, 11, 70, "Text",
      CellTags->{"S1.2.3", "3.3"}]},
  "3.4"->{
    Cell[17041, 632, 87, 1, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.4"}]},
  "3.5"->{
    Cell[17334, 647, 154, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.5"}]},
  "3.6"->{
    Cell[17702, 666, 171, 4, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.6"}]},
  "3.7"->{
    Cell[18101, 684, 132, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.7"}]},
  "3.8"->{
    Cell[18437, 703, 241, 7, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.8"}]},
  "3.9"->{
    Cell[18949, 725, 140, 4, 70, "Text",
      CellTags->{"S1.2.3", "3.9"}]},
  "3.10"->{
    Cell[19092, 731, 128, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.10"}]},
  "3.11"->{
    Cell[19435, 750, 147, 5, 70, "MathCaption",
      CellTags->{"S1.2.3", "3.11"}]},
  "S1.2.4"->{
    Cell[19844, 772, 89, 1, 70, "Subsection",
      CellTags->{"S1.2.4", "4.1"}],
    Cell[19936, 775, 280, 6, 70, "Text",
      CellTags->{"S1.2.4", "4.2"}],
    Cell[20219, 783, 263, 6, 70, "Text",
      CellTags->{"S1.2.4", "4.3"}],
    Cell[20485, 791, 2781, 86, 70, "DefinitionBox",
      CellTags->"S1.2.4"],
    Cell[23269, 879, 70, 1, 70, "Caption",
      CellTags->"S1.2.4"],
    Cell[23342, 882, 100, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.4"}],
    Cell[23467, 887, 81, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[23551, 891, 82, 3, 70, "Output",
      CellTags->"S1.2.4"],
    Cell[23648, 897, 88, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.5"}],
    Cell[23761, 902, 97, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[23861, 906, 96, 3, 70, "Output",
      CellTags->"S1.2.4"],
    Cell[23972, 912, 140, 5, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.6"}],
    Cell[24137, 921, 77, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[24217, 925, 90, 3, 70, "Output",
      CellTags->"S1.2.4"],
    Cell[24322, 931, 129, 5, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.7"}],
    Cell[24476, 940, 72, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[24551, 944, 82, 3, 70, "Output",
      CellTags->"S1.2.4"],
    Cell[24648, 950, 436, 12, 70, "Text",
      CellTags->{"S1.2.4", "4.8"}],
    Cell[25087, 964, 1790, 54, 70, "DefinitionBox",
      CellTags->"S1.2.4"],
    Cell[26880, 1020, 89, 3, 70, "Caption",
      CellTags->"S1.2.4"],
    Cell[26972, 1025, 70, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.9"}],
    Cell[27067, 1030, 81, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[27151, 1034, 98, 3, 70, "Output",
      CellTags->"S1.2.4"],
    Cell[27264, 1040, 98, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.10"}],
    Cell[27387, 1045, 74, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[27464, 1049, 82, 3, 70, "Output",
      CellTags->"S1.2.4"],
    Cell[27561, 1055, 145, 5, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.11"}],
    Cell[27731, 1064, 65, 2, 70, "Input",
      CellTags->"S1.2.4"],
    Cell[27799, 1068, 98, 3, 70, "Output",
      CellTags->"S1.2.4"]},
  "4.1"->{
    Cell[19844, 772, 89, 1, 70, "Subsection",
      CellTags->{"S1.2.4", "4.1"}]},
  "4.2"->{
    Cell[19936, 775, 280, 6, 70, "Text",
      CellTags->{"S1.2.4", "4.2"}]},
  "4.3"->{
    Cell[20219, 783, 263, 6, 70, "Text",
      CellTags->{"S1.2.4", "4.3"}]},
  "4.4"->{
    Cell[23342, 882, 100, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.4"}]},
  "4.5"->{
    Cell[23648, 897, 88, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.5"}]},
  "4.6"->{
    Cell[23972, 912, 140, 5, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.6"}]},
  "4.7"->{
    Cell[24322, 931, 129, 5, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.7"}]},
  "4.8"->{
    Cell[24648, 950, 436, 12, 70, "Text",
      CellTags->{"S1.2.4", "4.8"}]},
  "4.9"->{
    Cell[26972, 1025, 70, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.9"}]},
  "4.10"->{
    Cell[27264, 1040, 98, 1, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.10"}]},
  "4.11"->{
    Cell[27561, 1055, 145, 5, 70, "MathCaption",
      CellTags->{"S1.2.4", "4.11"}]},
  "S1.2.5"->{
    Cell[27946, 1077, 141, 4, 70, "Subsection",
      CellTags->{"S1.2.5", "5.1"}],
    Cell[28090, 1083, 315, 7, 70, "Text",
      CellTags->{"S1.2.5", "5.2"}],
    Cell[28408, 1092, 1535, 47, 70, "DefinitionBox",
      CellTags->"S1.2.5"],
    Cell[29946, 1141, 130, 5, 70, "Caption",
      CellTags->"S1.2.5"],
    Cell[30079, 1148, 675, 25, 72, "Text",
      CellTags->{"S1.2.5", "5.3"}]},
  "5.1"->{
    Cell[27946, 1077, 141, 4, 70, "Subsection",
      CellTags->{"S1.2.5", "5.1"}]},
  "5.2"->{
    Cell[28090, 1083, 315, 7, 70, "Text",
      CellTags->{"S1.2.5", "5.2"}]},
  "5.3"->{
    Cell[30079, 1148, 675, 25, 72, "Text",
      CellTags->{"S1.2.5", "5.3"}]},
  "S1.2.6"->{
    Cell[30791, 1178, 82, 1, 70, "Subsection",
      CellTags->{"S1.2.6", "6.1"}],
    Cell[30876, 1181, 413, 8, 72, "Text",
      CellTags->{"S1.2.6", "6.2"}],
    Cell[31292, 1191, 1668, 45, 84, "DefinitionBox",
      CellTags->"S1.2.6"],
    Cell[32963, 1238, 136, 5, 16, "Caption",
      CellTags->"S1.2.6"],
    Cell[33102, 1245, 159, 4, 56, "MathCaption",
      CellTags->{"S1.2.6", "6.3"}],
    Cell[33286, 1253, 87, 2, 28, "Input",
      CellTags->"S1.2.6"],
    Cell[33376, 1257, 83, 3, 25, "Output",
      CellTags->"S1.2.6"],
    Cell[33474, 1263, 366, 7, 56, "Text",
      CellTags->{"S1.2.6", "6.4"}],
    Cell[33843, 1272, 408, 12, 46, "DefinitionBox",
      CellTags->"S1.2.6"],
    Cell[34254, 1286, 60, 1, 16, "Caption",
      CellTags->"S1.2.6"],
    Cell[34317, 1289, 178, 5, 40, "MathCaption",
      CellTags->{"S1.2.6", "6.5"}],
    Cell[34498, 1296, 76, 2, 28, "Input",
      CellTags->"S1.2.6"],
    Cell[34577, 1300, 164, 5, 40, "MathCaption",
      CellTags->{"S1.2.6", "6.6"}],
    Cell[34766, 1309, 65, 2, 28, "Input",
      CellTags->"S1.2.6"],
    Cell[34834, 1313, 83, 3, 25, "Output",
      CellTags->"S1.2.6"]},
  "6.1"->{
    Cell[30791, 1178, 82, 1, 70, "Subsection",
      CellTags->{"S1.2.6", "6.1"}]},
  "6.2"->{
    Cell[30876, 1181, 413, 8, 72, "Text",
      CellTags->{"S1.2.6", "6.2"}]},
  "6.3"->{
    Cell[33102, 1245, 159, 4, 56, "MathCaption",
      CellTags->{"S1.2.6", "6.3"}]},
  "6.4"->{
    Cell[33474, 1263, 366, 7, 56, "Text",
      CellTags->{"S1.2.6", "6.4"}]},
  "6.5"->{
    Cell[34317, 1289, 178, 5, 40, "MathCaption",
      CellTags->{"S1.2.6", "6.5"}]},
  "6.6"->{
    Cell[34577, 1300, 164, 5, 40, "MathCaption",
      CellTags->{"S1.2.6", "6.6"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.2.0", 35572, 1337},
  {"0.1", 35662, 1340},
  {"S1.2.1", 35755, 1343},
  {"1.1", 37092, 1380},
  {"1.2", 37184, 1383},
  {"1.3", 37271, 1386},
  {"1.4", 37365, 1389},
  {"1.5", 37459, 1392},
  {"1.6", 37554, 1395},
  {"1.7", 37642, 1398},
  {"1.8", 37737, 1401},
  {"S1.2.2", 37830, 1404},
  {"2.1", 40288, 1471},
  {"2.2", 40381, 1474},
  {"2.3", 40469, 1477},
  {"2.4", 40564, 1480},
  {"2.5", 40659, 1483},
  {"2.6", 40754, 1486},
  {"2.7", 40849, 1489},
  {"2.8", 40944, 1492},
  {"2.9", 41039, 1495},
  {"2.10", 41129, 1498},
  {"2.11", 41221, 1501},
  {"2.12", 41313, 1504},
  {"2.13", 41404, 1507},
  {"S1.2.3", 41497, 1510},
  {"3.1", 43374, 1561},
  {"3.2", 43468, 1564},
  {"3.3", 43558, 1567},
  {"3.4", 43648, 1570},
  {"3.5", 43743, 1573},
  {"3.6", 43839, 1576},
  {"3.7", 43935, 1579},
  {"3.8", 44031, 1582},
  {"3.9", 44127, 1585},
  {"3.10", 44217, 1588},
  {"3.11", 44315, 1591},
  {"S1.2.4", 44415, 1594},
  {"4.1", 46595, 1653},
  {"4.2", 46689, 1656},
  {"4.3", 46778, 1659},
  {"4.4", 46867, 1662},
  {"4.5", 46963, 1665},
  {"4.6", 47058, 1668},
  {"4.7", 47154, 1671},
  {"4.8", 47250, 1674},
  {"4.9", 47340, 1677},
  {"4.10", 47437, 1680},
  {"4.11", 47535, 1683},
  {"S1.2.5", 47636, 1686},
  {"5.1", 48041, 1697},
  {"5.2", 48137, 1700},
  {"5.3", 48227, 1703},
  {"S1.2.6", 48321, 1706},
  {"6.1", 49476, 1737},
  {"6.2", 49571, 1740},
  {"6.3", 49661, 1743},
  {"6.4", 49758, 1746},
  {"6.5", 49848, 1749},
  {"6.6", 49945, 1752}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 127, 4, 65, "Section",
  CellTags->{"S1.2.0", "0.1"}],

Cell[CellGroupData[{
Cell[1928, 61, 81, 1, 70, "Subsection",
  CellTags->{"S1.2.1", "1.1"}],
Cell[2012, 64, 261, 8, 70, "Text",
  CellTags->{"S1.2.1", "1.2"}],
Cell[2276, 74, 1572, 47, 70, "DefinitionBox",
  CellTags->"S1.2.1"],
Cell[3851, 123, 81, 1, 70, "Caption",
  CellTags->"S1.2.1"],
Cell[3935, 126, 80, 1, 70, "MathCaption",
  CellTags->{"S1.2.1", "1.3"}],

Cell[CellGroupData[{
Cell[4040, 131, 70, 2, 70, "Input",
  CellTags->"S1.2.1"],
Cell[4113, 135, 85, 3, 70, "Output",
  CellTags->"S1.2.1"]
}, Open  ]],
Cell[4213, 141, 86, 1, 70, "MathCaption",
  CellTags->{"S1.2.1", "1.4"}],

Cell[CellGroupData[{
Cell[4324, 146, 69, 2, 70, "Input",
  CellTags->"S1.2.1"],
Cell[4396, 150, 85, 3, 70, "Output",
  CellTags->"S1.2.1"]
}, Open  ]],
Cell[4496, 156, 116, 2, 70, "MathCaption",
  CellTags->{"S1.2.1", "1.5"}],

Cell[CellGroupData[{
Cell[4637, 162, 80, 2, 70, "Input",
  CellTags->"S1.2.1"],
Cell[4720, 166, 89, 3, 70, "Output",
  CellTags->"S1.2.1"]
}, Open  ]],
Cell[4824, 172, 234, 5, 70, "Text",
  CellTags->{"S1.2.1", "1.6"}],
Cell[5061, 179, 172, 7, 70, "MathCaption",
  CellTags->{"S1.2.1", "1.7"}],

Cell[CellGroupData[{
Cell[5258, 190, 71, 2, 70, "Input",
  CellTags->"S1.2.1"],
Cell[5332, 194, 89, 3, 70, "Output",
  CellTags->"S1.2.1"]
}, Open  ]],
Cell[5436, 200, 1326, 28, 70, "Text",
  CellTags->{"S1.2.1", "1.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6799, 233, 77, 1, 70, "Subsection",
  CellTags->{"S1.2.2", "2.1"}],
Cell[6879, 236, 332, 8, 70, "Text",
  CellTags->{"S1.2.2", "2.2"}],
Cell[7214, 246, 201, 9, 70, "MathCaption",
  CellTags->{"S1.2.2", "2.3"}],

Cell[CellGroupData[{
Cell[7440, 259, 69, 2, 70, "Input",
  CellTags->"S1.2.2"],
Cell[7512, 263, 82, 3, 70, "Output",
  CellTags->"S1.2.2"]
}, Open  ]],
Cell[7609, 269, 220, 9, 70, "MathCaption",
  CellTags->{"S1.2.2", "2.4"}],

Cell[CellGroupData[{
Cell[7854, 282, 69, 2, 70, "Input",
  CellTags->"S1.2.2"],
Cell[7926, 286, 83, 3, 70, "Output",
  CellTags->"S1.2.2"]
}, Open  ]],
Cell[8024, 292, 129, 5, 70, "MathCaption",
  CellTags->{"S1.2.2", "2.5"}],

Cell[CellGroupData[{
Cell[8178, 301, 73, 2, 70, "Input",
  CellTags->"S1.2.2"],
Cell[8254, 305, 83, 3, 70, "Output",
  CellTags->"S1.2.2"]
}, Open  ]],
Cell[8352, 311, 237, 7, 70, "MathCaption",
  CellTags->{"S1.2.2", "2.6"}],

Cell[CellGroupData[{
Cell[8614, 322, 78, 2, 70, "Input",
  CellTags->"S1.2.2"],
Cell[8695, 326, 147, 4, 70, "Output",
  CellTags->"S1.2.2"]
}, Open  ]],
Cell[8857, 333, 136, 5, 70, "MathCaption",
  CellTags->{"S1.2.2", "2.7"}],

Cell[CellGroupData[{
Cell[9018, 342, 66, 2, 70, "Input",
  CellTags->"S1.2.2"],
Cell[9087, 346, 147, 4, 70, "Output",
  CellTags->"S1.2.2"]
}, Open  ]],
Cell[9249, 353, 240, 8, 70, "MathCaption",
  CellTags->{"S1.2.2", "2.8"}],

Cell[CellGroupData[{
Cell[9514, 365, 70, 2, 70, "Input",
  CellTags->"S1.2.2"],
Cell[9587, 369, 160, 4, 70, "Output",
  CellTags->"S1.2.2"]
}, Open  ]],
Cell[9762, 376, 1494, 50, 70, "DefinitionBox",
  CellTags->"S1.2.2"],
Cell[11259, 428, 72, 1, 70, "Caption",
  CellTags->"S1.2.2"],
Cell[11334, 431, 401, 9, 70, "Text",
  CellTags->{"S1.2.2", "2.9"}],
Cell[11738, 442, 642, 22, 70, "Text",
  CellTags->{"S1.2.2", "2.10"}],
Cell[12383, 466, 331, 11, 70, "FramedBox",
  CellTags->"S1.2.2"],
Cell[12717, 479, 126, 5, 70, "Caption",
  CellTags->"S1.2.2"],
Cell[12846, 486, 415, 13, 70, "Text",
  CellTags->{"S1.2.2", "2.11"}],
Cell[13264, 501, 443, 9, 70, "Text",
  CellTags->{"S1.2.2", "2.12"}],
Cell[13710, 512, 599, 22, 70, "DefinitionBox",
  CellTags->"S1.2.2"],
Cell[14312, 536, 61, 1, 70, "Caption",
  CellTags->"S1.2.2"],
Cell[14376, 539, 247, 6, 70, "Text",
  CellTags->{"S1.2.2", "2.13"}],
Cell[14626, 547, 1321, 44, 70, "FramedBox",
  CellTags->"S1.2.2"],
Cell[15950, 593, 143, 5, 70, "Caption",
  CellTags->"S1.2.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16130, 603, 82, 1, 70, "Subsection",
  CellTags->{"S1.2.3", "3.1"}],
Cell[16215, 606, 424, 11, 70, "Text",
  CellTags->{"S1.2.3", "3.2"}],
Cell[16642, 619, 396, 11, 70, "Text",
  CellTags->{"S1.2.3", "3.3"}],
Cell[17041, 632, 87, 1, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.4"}],

Cell[CellGroupData[{
Cell[17153, 637, 73, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[17229, 641, 90, 3, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]],
Cell[17334, 647, 154, 5, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.5"}],

Cell[CellGroupData[{
Cell[17513, 656, 79, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[17595, 660, 92, 3, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]],
Cell[17702, 666, 171, 4, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.6"}],

Cell[CellGroupData[{
Cell[17898, 674, 89, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[17990, 678, 96, 3, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]],
Cell[18101, 684, 132, 5, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.7"}],

Cell[CellGroupData[{
Cell[18258, 693, 65, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[18326, 697, 96, 3, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]],
Cell[18437, 703, 241, 7, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.8"}],

Cell[CellGroupData[{
Cell[18703, 714, 77, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[18783, 718, 151, 4, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]],
Cell[18949, 725, 140, 4, 70, "Text",
  CellTags->{"S1.2.3", "3.9"}],
Cell[19092, 731, 128, 5, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.10"}],

Cell[CellGroupData[{
Cell[19245, 740, 79, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[19327, 744, 93, 3, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]],
Cell[19435, 750, 147, 5, 70, "MathCaption",
  CellTags->{"S1.2.3", "3.11"}],

Cell[CellGroupData[{
Cell[19607, 759, 75, 2, 70, "Input",
  CellTags->"S1.2.3"],
Cell[19685, 763, 110, 3, 70, "Output",
  CellTags->"S1.2.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19844, 772, 89, 1, 70, "Subsection",
  CellTags->{"S1.2.4", "4.1"}],
Cell[19936, 775, 280, 6, 70, "Text",
  CellTags->{"S1.2.4", "4.2"}],
Cell[20219, 783, 263, 6, 70, "Text",
  CellTags->{"S1.2.4", "4.3"}],
Cell[20485, 791, 2781, 86, 70, "DefinitionBox",
  CellTags->"S1.2.4"],
Cell[23269, 879, 70, 1, 70, "Caption",
  CellTags->"S1.2.4"],
Cell[23342, 882, 100, 1, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.4"}],

Cell[CellGroupData[{
Cell[23467, 887, 81, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[23551, 891, 82, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]],
Cell[23648, 897, 88, 1, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.5"}],

Cell[CellGroupData[{
Cell[23761, 902, 97, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[23861, 906, 96, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]],
Cell[23972, 912, 140, 5, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.6"}],

Cell[CellGroupData[{
Cell[24137, 921, 77, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[24217, 925, 90, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]],
Cell[24322, 931, 129, 5, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.7"}],

Cell[CellGroupData[{
Cell[24476, 940, 72, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[24551, 944, 82, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]],
Cell[24648, 950, 436, 12, 70, "Text",
  CellTags->{"S1.2.4", "4.8"}],
Cell[25087, 964, 1790, 54, 70, "DefinitionBox",
  CellTags->"S1.2.4"],
Cell[26880, 1020, 89, 3, 70, "Caption",
  CellTags->"S1.2.4"],
Cell[26972, 1025, 70, 1, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.9"}],

Cell[CellGroupData[{
Cell[27067, 1030, 81, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[27151, 1034, 98, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]],
Cell[27264, 1040, 98, 1, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.10"}],

Cell[CellGroupData[{
Cell[27387, 1045, 74, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[27464, 1049, 82, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]],
Cell[27561, 1055, 145, 5, 70, "MathCaption",
  CellTags->{"S1.2.4", "4.11"}],

Cell[CellGroupData[{
Cell[27731, 1064, 65, 2, 70, "Input",
  CellTags->"S1.2.4"],
Cell[27799, 1068, 98, 3, 70, "Output",
  CellTags->"S1.2.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27946, 1077, 141, 4, 70, "Subsection",
  CellTags->{"S1.2.5", "5.1"}],
Cell[28090, 1083, 315, 7, 70, "Text",
  CellTags->{"S1.2.5", "5.2"}],
Cell[28408, 1092, 1535, 47, 70, "DefinitionBox",
  CellTags->"S1.2.5"],
Cell[29946, 1141, 130, 5, 70, "Caption",
  CellTags->"S1.2.5"],
Cell[30079, 1148, 675, 25, 72, "Text",
  CellTags->{"S1.2.5", "5.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[30791, 1178, 82, 1, 70, "Subsection",
  CellTags->{"S1.2.6", "6.1"}],
Cell[30876, 1181, 413, 8, 72, "Text",
  CellTags->{"S1.2.6", "6.2"}],
Cell[31292, 1191, 1668, 45, 84, "DefinitionBox",
  CellTags->"S1.2.6"],
Cell[32963, 1238, 136, 5, 16, "Caption",
  CellTags->"S1.2.6"],
Cell[33102, 1245, 159, 4, 56, "MathCaption",
  CellTags->{"S1.2.6", "6.3"}],

Cell[CellGroupData[{
Cell[33286, 1253, 87, 2, 28, "Input",
  CellTags->"S1.2.6"],
Cell[33376, 1257, 83, 3, 25, "Output",
  CellTags->"S1.2.6"]
}, Open  ]],
Cell[33474, 1263, 366, 7, 56, "Text",
  CellTags->{"S1.2.6", "6.4"}],
Cell[33843, 1272, 408, 12, 46, "DefinitionBox",
  CellTags->"S1.2.6"],
Cell[34254, 1286, 60, 1, 16, "Caption",
  CellTags->"S1.2.6"],
Cell[34317, 1289, 178, 5, 40, "MathCaption",
  CellTags->{"S1.2.6", "6.5"}],
Cell[34498, 1296, 76, 2, 28, "Input",
  CellTags->"S1.2.6"],
Cell[34577, 1300, 164, 5, 40, "MathCaption",
  CellTags->{"S1.2.6", "6.6"}],

Cell[CellGroupData[{
Cell[34766, 1309, 65, 2, 28, "Input",
  CellTags->"S1.2.6"],
Cell[34834, 1313, 83, 3, 25, "Output",
  CellTags->"S1.2.6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

