(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1312911,      17578]*)
(*NotebookOutlinePosition[   1349967,      18649]*)
(*  CellTagsIndexPosition[   1345868,      18498]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.3 ", "HeadingNumber"],
  "Using the ",
  StyleBox["Mathematica", "SBO"],
  " System"
}], "Section",
  CellTags->{"S1.3.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "1.3.1 The Structure of ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S1.3.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]], Cell["the part that actually performs computations "]},
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " front end "
            }]], Cell["the part that handles interaction with the user "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.1"],

Cell[TextData[{
  "The basic parts of the ",
  StyleBox["Mathematica", "SO"],
  " system. "
}], "Caption",
  CellTags->"S1.3.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is a modular software system in which the ",
  StyleBox["kernel", "TI"],
  " which actually performs computations is separate from the ",
  StyleBox["front end", "TI"],
  " which handles interaction with the user. "
}], "Text",
  CellTags->{"S1.3.1", "1.2"}],

Cell[TextData[{
  "The most common type of front end for ",
  StyleBox["Mathematica", "TI"],
  " is based on interactive documents known as ",
  StyleBox["notebooks", "TI"],
  ". Notebooks mix ",
  StyleBox["Mathematica", "TI"],
  " input and output with text, graphics, palettes and other material. You \
can use notebooks either for doing ongoing computations, or as means of \
presenting or publishing your results.   "
}], "Text",
  CellTags->{"S1.3.1", "1.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Notebook interface "], Cell["interactive documents "]},
          {Cell["Text\[Hyphen]based interface "], Cell[
            "text from the keyboard "]},
          {Cell[TextData[{
              StyleBox["MathLink", "TI"],
              " interface "
            }]], Cell["communication with other programs "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.1"],

Cell[TextData[{
  "Common kinds of interfaces to ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.3.1"],

Cell[TextData[{
  "The notebook front end includes many menus and graphical tools for \
creating and reading notebook documents and for sending and receiving \
material from the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "Text",
  CellTags->{"S1.3.1", "1.4"}],

Cell[TextData[{
  "A notebook mixing text, graphics and ",
  StyleBox["Mathematica", "TI"],
  " input and output."
}], "MathCaption",
  CellTags->{"S1.3.1", "1.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0001Ob000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooU0?ooo`D0003o0P3oool50000o`80oooo1@000?l50?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=B0?ooo`@0
0000o`3ooonC0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<O0?ooo`80003o0`3oool20000obd0oooo00<000000?ooo`3oool0o`3ooonC0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<O0?ooo`03
0000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0:`3oool00`000000oooo0?ooo`3o0?oooi<0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a@0
oooo0`000?l30?ooo`80003o0P3oool20000o`030?ooo`000?l0003o00<0003o6@3oool400000080
oooo100000040?ooo`80000000H0oooo000000000000oooo0000003oool200000080oooo0`000000
1@3oool00000000000000000oooo00D000000`3oool3000000<0oooo1000003o0?ooogH0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a<0oooo00l0
003o0?ooo`3oool0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0
0`3oool00`000?l0oooo0000o`030000oa<0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?ooogD0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a<0oooo00d0
003o0?ooo`3oool0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o0080oooo00@0
003o0?ooo`3oool0003o5`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000000:
0?ooo`800000o`3ooome0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<C0?ooo`0=0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?oo
o`000?l0oooo0000o`030?ooo`040000o`3oool0003o0?ooo`@0003o2@3oool5000000@0oooo00<0
00000?ooo`3oool0100000020?ooo`030000003oool0oooo00@0oooo100000020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`000000203oool2000000L0oooo1@00003o0?ooof/0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a<0oooo00X0003o0?ooo`3oool0
oooo0000o`3oool0003o0?ooo`000?l0oooo0`000?l40?ooo`80003o5`3oool00`000000oooo0?oo
o`060?ooo`800000203oool00`000000oooo0?ooo`0200000080oooo00<000000?ooo`3oool00P00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?ooog80oooo10000?l60?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c4`3oool01@000?l0oooo0?ooo`3oool0003o
00D0oooo00D0003o0?ooo`000?l0oooo0000o`020?ooo`80003o5`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080000000<0oooo0000000000000P3oool400000080oooo0P000000
0`3oool00000000000030?ooo`040000003oool00000000000<0oooo0`0000050?ooo`@000000`3o
ool400000?l0ooooM@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c503oool30000o`P0oooo0P000?l00`3oool0003o0000o`020000oaP0oooo00<0
00000?ooo`3oool00P00000G0?ooo`030000003oool0oooo0?l0ooooR`3oool20000o`H0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`80000000<0oooo0000003oool05@3o
ool2000000P0oooo00<000000?ooo`3oool0o`3ooon10?ooo`030000o`3oool0003o00H0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonH0oooo00@0003o0?ooo`3oool0003o
1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooi@3oool01@000?l0oooo
0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon@0
oooo1P000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooU0?ooo`D0003o1P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooY0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonT0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo0P00000/0?ooo`@0
00000`3oool00`000000oooo0?ooo`020?ooo`@000009P3oool4000000<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0U0?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`80
00009`3oool4000000<0oooo00<000000?ooo`3oool00`3oool2000002d0oooo1000002g0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`03
0000003oool0oooo02d0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`070?ooo`04
0000003oool0oooo000002P0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000/
0?ooo`030000003oool0oooo0;P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<b40oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool01P3oool5000002P0oooo00<00000
0?ooo`3oool01`3oool010000000oooo0?ooo`00000X0?ooo`030000003oool0oooo00L0oooo00@0
00000?ooo`3oool00000;@3oool00`000000oooo0?ooo`2g0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`800000;P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool01P3oool010000000oooo
0?ooo`00000Y0?ooo`030000003oool0oooo00L0oooo0`00000Y0?ooo`030000003oool0oooo00P0
oooo0P00000_0?ooo`030000003oool0oooo0;H0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0000000Y0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0:@3oool00`000000
oooo0?ooo`070?ooo`040000003oool0oooo000002l0oooo00<000000?ooo`3oool0]@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool00`00
0000oooo0?ooo`0[0?ooo`<000002@3oool010000000oooo0?ooo`00000V0?ooo`<000002P3oool2
000002L0oooo0`0000090?ooo`030000003oool0oooo02L0oooo0`0000090?ooo`040000003oool0
oooo000002`0oooo00@000000?ooo`3oool00000]`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool2000002h0oooo00<000000?ooo`3oool0
203oool2000002T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo00P0oooo0`00000X0?ooo`030000003oool0oooo00P0oooo0P00000^0?ooo`800000
^03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
8@3oool00`000000oooo0?ooo`3o0?ooolD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooool00000
7P00002a0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<Q0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`2f0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<Q0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`2f0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<Q0?ooo`800000o`3oooo60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`030000003oool0oooo0?l0ooooa@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo
0?ooo`3o0?ooolD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<b40oooo0P00003o0?ooolH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`800000
o`3oooo60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<Q0?ooo`030000003oool0oooo0?l0ooooa@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`3o0?ooolD0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo
0P00003o0?ooolH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<b40oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`800000103oool00`000000oooo
0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`3o0?ooolD0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`020?ooo`<00000o`3oooo50?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?ooolD0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo100000030?ooo`80
00002@3oool3000000D0oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01@3oool200000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool010000000oooo0?ooo`0000080?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`8000002@3oool40000
00@0oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`800000o`3oooo60?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`030000003oool0oooo
0?l0ooooa@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c8@3oool200000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`3o0?ooolD0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo00<000000?oo
o`3oool0o`3oooo50?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<Q0?ooo`800000o`3oooo60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`030000003oool0oooo0?l0ooooa@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6P3oool20000
00D0oooo00<000000?ooo`3oool0o`3oooo50?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`040000003oool0oooo000000@0oooo0`00003o
0?ooolD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<a`0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?ooolD0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a<0oooo10000003
0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooolD0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a`0oooo00<000000?ooo`3oool00P3oool2
00000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c6@3oool010000000oooo0?ooo`0000040?ooo`800000o`3oooo60?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooo`8000001@3o
ool200000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c8@3oool200000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool200000?l0ooooaP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool200000?l0ooooaP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3o
ool200000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c8@3oool200000?l0ooooaP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool200000?l0ooooaP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool200000?l0ooooaP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3o
ool4000000<0oooo00<000000?ooo`3oool00P3oool3000000D0oooo0P00003o0?ooolH0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`020?ooo`<00000o`3oooo50?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000003o0?ooolD0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo1000
00040?ooo`030000003oool0oooo00L0oooo0`0000050?ooo`030000003oool000000?l0ooooa@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c403o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo0`00003o0?ooolD0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo00000?l0
ooooa03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c3P3oool2000000T0oooo100000040?ooo`040000003oool0oooo00000?l0ooooa03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool20000
00030?ooo`000000oooo0?l0oooo``3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c8@3oool010000000oooo0?ooo`00003o0?oool@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo0P000000
0`3oool000000?ooo`3o0?oool<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<b40oooo00D000000?ooo`3oool0oooo0000003o0?oool<0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo00D0
00000?ooo`3oool0oooo0000003o0?oool<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo0P0000030?ooo`030000003oool0oooo0?l0oooo
`03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
8@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo_`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool4000000@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oookh0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo00<000000?ooo`3oool0
1@3oool3000000@0oooo00<000000?ooo`3oool0o`3ooonn0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?oookd0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a<0oooo100000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?oook`0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a`0oooo
00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool0o`3ooonk0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`3o0?oookX0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aX0
oooo0P0000050?ooo`030000003oool0oooo00T0oooo0P00003o0?oookX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo0P00000<0?ooo`03
0000003oool0oooo0?l0oooo]`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`0<0?ooo`800000o`3ooong0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`03
0000003oool0oooo00h0oooo0P00003o0?oookD0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo0P00000A0?ooo`<00000o`3ooonb0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`03
0000003oool0oooo01<0oooo0`00003o0?ooojl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40oooo0P00000G0?ooo`800000o`3ooon]0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<Q0?ooo`03
0000003oool0oooo01P0oooo0`00003o0?ooojX0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo100000030?ooo`030000003oool0oooo0080
oooo0`0000050?ooo`030000003oool0oooo01/0oooo0`00003o0?ooojL0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`020?ooo`<000007P3oool400000?l0ooooX`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool08P3oool600000?l0
ooooW@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c1`3oool4000000@0oooo00<000000?ooo`3oool01`3oool3000000D0oooo00<000000?ooo`3o
ool0:03oool600000?l0ooooU`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c3`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0
oooo0P00000_0?ooo`H00000o`3ooonA0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`<000002@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo03@0oooo2000003o0?ooohT0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo00<000000?ooo`3oool01`3oool4000000@0
oooo00<000000?ooo`3oool0?03oool<00000?l0ooooO@3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool2000004T0oooo2`00003o0?ooog80
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b40
oooo00<000000?ooo`3oool0D`3oool;00000?l0ooooI`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`1N0?ooo``0
0000o`3ooomK0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<Q0?ooo`800000J`3ooolE00000?l0ooooAP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`1o0?oooaL0
0000o`3oool_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<Q0?ooo`800000U`3ooolR00000?l0oooo3@3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`2h0?ooobd0
0000g`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c6@3oool4000000@0oooo00<000000?ooo`3oool0i@3ooolW00000;P0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3o
ool00`3oool300000?l0ooooa@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c6`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0
ooooa@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c4`3oool4000000@0oooo00<000000?ooo`3oool0o`3oooo80?ooo`@0003o1P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`3oool0o`3oooo;0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`<0
0000o`3oooo90?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooi@3oool50000o`H0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonT0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo0P000?l30?ooo`80
003o<@3oool4000001/0oooo0P00000l0?ooo`800000103oool400000?l0oooo;`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool00`000?l0
oooo0?ooo`030?ooo`030000o`3oool0oooo02l0oooo0P00000=0?ooo`8000003@3oool2000000d0
oooo0P00000F0?ooo`8000005`3oool2000000D0oooo0P00003o0?ooobl0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo00P0003o0?ooo`00
0?l0oooo0000o`3oool0003o0?ooo`D0003o00<0oooo0000o`3oool0303oool5000000@0oooo1P00
00030?ooo`@000001@3oool3000000@0oooo0P0000030?ooo`8000000P3oool2000000D0oooo0P00
000<0?ooo`800000103oool6000000@0oooo0P00000<0?ooo`H00000103oool2000000`0oooo1P00
00040?ooo`8000001@3oool200000?l0oooo;`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool02@000?l0oooo0000o`3oool0003o0?ooo`00
0?l0oooo0000o`030?ooo`040000o`3oool0oooo0?ooo`@0003o2@3oool2000000P0oooo0P000004
0?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool2
000000030?ooo`0000000000008000004P3oool2000000D0oooo1000000E0?ooo`800000503oool2
00000080oooo0P0000040?ooo`8000001@3oool200000?l0oooo;`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool01`000?l0oooo0000o`3o
ool0003o0?ooo`000?l00P3oool010000?l0oooo0?ooo`000?l@0?ooo`800000203oool2000000@0
oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000040?ooo`H000004@3oool2000000L0
oooo0P00000F0?ooo`8000005@3oool2000000P0oooo0P0000040?ooo`800000o`3oool_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`07
0000o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`030000o`3oool0003o00<0oooo10000?l9
0?ooo`D000001@3oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P000005
0?ooo`@000004`3oool2000000H0oooo0P00000F0?ooo`8000005P3oool2000000H0oooo0P000005
0?ooo`800000o`3oool_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<E0?ooo`040000o`3oool0003o0000o`80oooo00<0003o0?ooo`3oool00P3o
ool20000o`030?ooo`000?l0oooo00d0oooo0P0000020?ooo`800000103oool2000000@0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000040?ooo`@00000503oool2000000D0oooo1000
000E0?ooo`8000005`3oool2000000D0oooo0P0000050?ooo`800000o`3oool_0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`030000o`3o
ool0oooo00<0oooo00<0003o0?ooo`000?l00P3oool20000oa00oooo0P0000020?ooo`800000103o
ool2000000D0oooo100000030?ooo`D00000103oool2000000<0oooo1P00000C0?ooo`800000103o
ool600000180oooo1000000H0?ooo`800000103oool2000000D0oooo0P00003o0?ooobl0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo00<0
003o0?ooo`3oool00`3oool20000o`030?ooo`000?l0003o0080003o403oool200000080oooo0P00
00040?ooo`8000003@3oool2000000H0oooo0P0000030?ooo`@0000000<0oooo0000000000004P3o
ool2000001d0oooo0`00000D0?ooo`8000000P3oool2000000@0oooo0P0000050?ooo`800000o`3o
ool^0?ooo`80003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40oooo1P00
00030?ooo`@000003@3oool2000000H0oooo100000020?ooo`8000000P3oool2000001<0oooo0P00
000M0?ooo`8000005@3oool4000000@0oooo0P0000040?ooo`@00000o`3oool]0?ooo`030000o`3o
ool0003o00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonH0oooo00@0
003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
i@3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooon@0oooo1P000?l20?ooo`D0003o1P3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool50000o`H0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cC`3oool3000005D0oooo0`00003o0?ooodH0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=@0?ooo`030000003oool0oooo05<0oooo00D000000?ooo`3oool0oooo0000003o0?oo
odD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=@0?ooo`030000003oool0oooo
05<0oooo00D000000?ooo`3oool0oooo0000003o0?ooodD0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<>0?ooo`<000000`3oool6000000040?ooo`00000000000?ooo`80000000<0
oooo0000000000000`3oool3000000040?ooo`00000000000?ooo`8000000P3oool300000080oooo
0P0000050?ooo`H000001P3oool2000000030?ooo`000000oooo0080oooo00@000000?ooo`000000
00000P3oool3000000040?ooo`0000000000000000<0oooo00<000000?ooo`3oool00`3oool30000
0080oooo0`0000050?ooo`030000003oool000000080000000@0oooo000000000000oooo0P000005
0?ooo`<000000P3oool200000080oooo0`0000040?ooo`80000000<0oooo0000000000000P000000
0`3oool000000?ooo`06000000040?ooo`00000000000?ooo`<000001@3oool3000000<0oooo0P00
00000`3oool0000000000002000000040?ooo`00000000000?ooo`8000000`3oool00`000000oooo
00000002000000040?ooo`000000000000000080oooo0`0000001@3oool000000000003oool00000
0?l0oooo603oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo00<000000?oo
o`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo0P000005
0?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo000000@0oooo0P0000020?ooo`060000003oool0oooo0000003oool00000
0`3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000020?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo00000002
0?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`0000002@3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`030000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo0?l0oooo6@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo
00D000000?ooo`3oool0oooo000000030?ooo`060000003oool0oooo0000003oool000000`3oool0
0`000000oooo0?ooo`030?ooo`060000003oool0oooo0000003oool000001@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo0?ooo`800000103oool010000000oooo0?ooo`000004
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003o
ool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000P0oooo00@000000?ooo`3o
ool000001P3oool200000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo00000003
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P0000070?ooo`050000003o
ool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000@0
oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`3o0?oooaT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<@0?ooo`D000000`3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`000000oooo00@000000P3oool00`000000oooo0?ooo`040000
00D0oooo00@000000?ooo`00000000001`3oool3000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0000000<0oooo00<000000?ooo`0000001@3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`0000000`0000050?ooo`030000003oool0oooo00@0000000<0oooo00000000
0000103oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000<0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000
103oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo0?l0oooo6@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<a00oooo00D000000?ooo`3oool0oooo000000030?ooo`060000003oool0oooo0000003oool0
00000P3oool2000000D0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0
oooo0080000000D0oooo0000003oool0oooo000000050?ooo`030000003oool000000080oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`8000000P3oool01P000000oooo
0?ooo`000000oooo000000<0oooo00<000000?ooo`0000001@3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`80000000L0oooo0000003oool0oooo
0000003oool000000080oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000
oooo000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`030000
003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?oooaT0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<A0?ooo`030000003oool0000000<0oooo00@00000
0?ooo`00000000000`3oool2000000030?ooo`000000oooo00@0oooo0`0000030?ooo`8000000P3o
ool01@000000oooo000000000000oooo008000001@3oool200000080oooo0`0000050?ooo`800000
103oool2000000030?ooo`000000000000<0oooo00<000000?ooo`3oool00`000000103oool00000
0000000000050?ooo`<000000P3oool3000000<0oooo0`0000020?ooo`<000000`3oool2000000D0
oooo00D000000?ooo`00000000000?ooo`02000000<0oooo0`000000103oool000000000003oool2
00000080oooo100000001P3oool000000000003oool000000?ooo`8000000`3oool4000000@0oooo
0`000000103oool000000000003oool2000000030?ooo`000000oooo008000000`3oool200000005
0?ooo`00000000000000003oool00P0000020?ooo`<000000P3oool010000000oooo000000000003
0?ooo`030000003oool0oooo0?l0oooo5P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<a40oooo00<000000?ooo`0000003@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo0000000Q0?ooo`030000003oool0000001D0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`3o0?ooobT0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0o`3o
oolm0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c4P3oool00`000000oooo0?oo
o`0;0?ooo`800000103oool2000001H0oooo00<000000?ooo`3oool05@3oool2000001D0oooo0P00
00060?ooo`800000803oool2000000D0oooo00<000000?ooo`3oool0403oool2000001D0oooo00<0
00000?ooo`3oool0o`3ooolU0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooo]0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo00oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooU0?ooo`D0003o0P3o
ool50000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cH`3oool00`000000oooo0?ooo`3o0?oooh<0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f<0oooo00<0
00000?ooo`3oool0o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=R0?ooo`800000203oool300000?l0ooooNP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cHP3oool00`000000oooo0000
00060?ooo`050000003oool0oooo0?ooo`000000o`3ooomi0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=Q0?ooo`040000003oool0oooo000000X0
oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=O0?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`1G0?ooo`<00000H03oool300000;T0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f00oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`050?ooo`800000F@3oool01@000000oooo0?ooo`3oool00000
05h0oooo00D000000?ooo`3oool0oooo0000002h0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=U0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0FP3oool00`000000oooo0?ooo`1L0?ooo`050000003oool0oooo0?ooo`000000^03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cI@3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000G03oool00`000000oooo
0?ooo`1L0?ooo`050000003oool0oooo0?ooo`000000^03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cI@3oool00`000000oooo0?ooo`040?ooo`<0
0000F`3oool2000005l0oooo1000002i0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=V0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3o
ool0G03oool00`000000oooo0?ooo`2j0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=V0?ooo`030000003oool0oooo05l0oooo00D000000?ooo`3o
ool0oooo0000001O0?ooo`030000003oool0oooo0;T0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fH0oooo3000001G0?ooo`<00000H@3oool30000
0;P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<al0oooo0P000?l30?ooo`80003oo`3oooo30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<O0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?oo
o`3oool0o`3oooo10?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<D0?ooo`<0003o0`3oool20000o`80oooo0P000?l30?ooo`030000o`3oool0003o
0?l0oooo``3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c4`3oool03@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o0?oo
o`000?l00`3oool010000?l0oooo0000o`3oool40000og<0oooo00<000000?ooo`3oool0o`3ooom8
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<C
0?ooo`0=0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`03
0?ooo`030000o`3oool0003o01H0ooooF@0000090?ooo`030000003oool0oooo00H0ooooB000000A
0?oooeX00000SP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c4`3oool03@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o
0?ooo`000?l00`3oool010000?l0oooo0000o`3oool40000o`T0oooo1@00001S0?ooo`D00000E03o
ool500000>h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<a<0oooo00X0003o0?ooo`3oool0oooo0000o`3oool0003o0?ooo`000?l0oooo0`000?l3
0?ooo`030000o`3oool0003o07P0oooo00<000000?ooo`3oool0o`3ooom80?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<C0?ooo`050000o`3oool0
oooo0?ooo`000?l01@3oool00`000?l0oooo0000o`020?ooo`80003o00<0oooo0000o`3oool0M`3o
ool00`000000oooo0?ooo`3o0?ooodP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<a@0oooo0`000?l80?ooo`80003o0P3oool30000oe<0oooo00<0
00000?ooo`3oool0o`3ooom]0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=i0?ooo`030000003oool0oooo03/0oooo1000001E0?ooo`@00000e03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN03o
ool200000400oooo0P0000040?ooo`8000009P3oool2000002T0oooo0P0000040?ooo`800000>@3o
ool200000980oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<gL0oooo00<000000?ooo`000000@@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool0T03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cM03oool01P000000oooo0?ooo`000000oooo000000D0
oooo0`00000V0?ooo`H000000`3oool3000000@0oooo0P0000000`3oool000000?ooo`030?ooo`03
0000003oool0oooo00X0oooo1@00000=0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3o
ool05@3oool6000000<0oooo0`0000040?ooo`80000000<0oooo0000003oool00`3oool00`000000
oooo0?ooo`020?ooo`D000003P3oool2000000<0oooo0P00000=0?ooo`8000000`3oool2000000T0
oooo00<000000?ooo`3oool0T03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cM@3oool2000000<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0T0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`0F0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00P0000040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?oo
o`0000001`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3oool0
0`000000oooo0?ooo`2@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c=f0?ooo`050000003oool0oooo0?ooo`0000001@3oool2000002L0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000D0oooo0P0000040?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0F0?ooo`070000003oool0oooo0?oo
o`000000oooo000000050?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`030000003oool0
oooo0900oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<gX0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool2000000@0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`D000001@3oool00`000000oooo0?ooo`050?ooo`D000001P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`800000103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool01@3oool5
000000L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`2@0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=[0?ooo`8000003@3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000`0oooo0P00000H0?ooo`030000003o
ool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00800000
103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo000000050?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P0000040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`03
0000003oool0oooo0900oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<f/0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`80
00003P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0oooo0`0000040?ooo`80
000000<0oooo0000000000000`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00`3oool3000000040?ooo`0000000000000000<0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`050?ooo`<00000103oool2000000030?ooo`0000000000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00@0oooo0`000000103oool000000000000000060?ooo`030000003oool0oooo00@0oooo0`000000
1@3oool00000000000000000oooo00@00000103oool00`000000oooo0?ooo`2@0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=[0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0F0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool02P3oool3000001T0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo0`00000/0?ooo`8000001P3o
ool00`000000oooo0?ooo`2@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=[0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0E0?ooo`@00000503oool2000000d0oooo00<000000?ooo`3oool05P3o
ool2000001L0oooo1000000D0?ooo`8000001@3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo0080oooo0P00002B0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=[0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo09D0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f/0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0;X0oooo00@000000?ooo`3oool00000
U`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
J`3oool00`000000oooo0?ooo`0=0?ooo`X000002`3oool00`000000oooo0?ooo`2k0?ooo`800000
V03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
?P3oool3000000050?ooo`00000000000000003oool0100000040?ooo`<000000`3oool5000000<0
oooo0P0000000`3oool0000000000003000000040?ooo`0000000000000000<0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`3o0?oooeH0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P0000020?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0?l0ooooEP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`030?oooaX000001@3oool00`000000oooo0?ooo`3o
0?oooeH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<cl0oooo1@0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`3o0?oooeH0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d00oooo00<000000?ooo`000000103o
ool2000000@0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`3o0?oooeH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<d00oooo00<000000?ooo`0000000`3oool2000000030?oo
o`000000000000<0oooo100000001@3oool000000?ooo`3oool000000080oooo00<000000?ooo`00
00000`0000020?ooo`80000000<0oooo0000000000001@3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo0?l0ooooEP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c@@3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`D000000`3oool01000
0000oooo0?ooo`3oool400000080oooo0P0000000`3oool00000000000070?ooo`030000003oool0
oooo0?l0ooooEP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c?`3oool300000140oooo1`00000A0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`3oool2000000D0oooo0`0000080?ooo`030000003o
ool0oooo0?l0ooooD`3oool40000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=[0?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0oooo1@0000030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`3o0?oooeH0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f/0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00P0000000`3oool00000000000070?ooo`030000003oool0oooo0?l0oooo
E@3oool20000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=[0?ooo`030000
003oool0oooo00@0oooo0`0000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo0?l0ooooE03oool00`000?l0oooo0000o`060?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cJ`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00P0oooo0P00000?0?ooo`030000003oool0oooo0?l0ooooD`3oool010000?l0
oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cJ`3oool20000
0280oooo0P00003o0?oooe@0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooT0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooi@3oool5
0000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonT0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo1000000<
0?ooo`H000005P3oool600000?l0ooooQ03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c<P3oool010000000oooo0?ooo`3oool2000000`0oooo1000
000I0?ooo`800000o`3ooon60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<g0?ooo`030000003oool0oooo00/0oooo0P00000>0?ooo`D000001`3o
ool200000?l0ooooQP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c=`3oool2000000`0oooo0P0000040?ooo`<000004`3oool200000?l0ooooQP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3o
ool2000000/0oooo100000020?ooo`80000000<0oooo0000000000004P3oool200000?l0ooooQP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3o
ool2000000X0oooo1P0000040?ooo`800000403oool400000?l0ooooQP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool2000001<0oooo0P00
000B0?ooo`<00000o`3ooon60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<g0?ooo`8000004@3oool2000000030?ooo`00000000000180oooo0P00
003o0?ooohH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<a/0oooo0P000?l30?ooo`80003o5@3oool200000180oooo0`00003o0?oooi/0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<0
003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`0C0?ooo`800000o`3ooon`0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`070000o`3o
ool0003o0?ooo`000?l0oooo0000o`030?ooo`050000o`3oool0003o0?ooo`000?l04`3oool20000
03D0oooo1P0000040?ooo`H00000o`3ooom[0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000
o`030?ooo`030000o`3oool0003o00<0oooo10000?l>0?ooo`800000=03oool2000000050?ooo`00
000000000?ooo`0000001@3oool400000?l0ooooK03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool01`000?l0oooo0000o`3oool0003o0?oo
o`000?l00`3oool00`000?l0oooo0000o`0E0?ooo`8000001`3ooolX000000D0oooo0P0000001@3o
ool000000000003oool0000000H0oooo0P00003o0?ooofd0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo00L0003o0?ooo`000?l0oooo0000
o`3oool0003o00<0oooo00<0003o0?ooo`000?l00`3oool40000o`h0oooo0P00000d0?ooo`800000
00D0oooo000000000000oooo000000060?ooo`800000o`3ooom]0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`040000o`3oool0003o0000
o`80oooo00T0003o0?ooo`3oool0oooo0000o`3oool0003o0?ooo`000?l04`3oool2000003@0oooo
0P0000001@3oool000000000003oool0000000D0oooo1000003o0?ooof`0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo00<0003o0?ooo`3o
ool00`3oool00`000?l0oooo0?ooo`020000o`030?ooo`000?l0oooo01@0oooo0P00000e0?ooo`@0
000000<0oooo0000003oool00`3oool600000?l0ooooJ`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool00`000?l0oooo0?ooo`030?ooo`80
003o0P3oool30000oaD0oooo0P00000g0?ooo`80000000<0oooo0000003oool0o`3ooomd0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`80
0000=P3oool500000?l0ooooM@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=`3oool200000?l0oooo/03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool2000001P0oooo1P00003o0?oooi80
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0
oooo0P00000J0?ooo`800000o`3ooonD0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`8000006P3oool200000?l0ooooU03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool2000001X0
oooo0P00003o0?oooi@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cL0oooo0P00000J0?ooo`800000o`3ooonC0?ooo`80003o1P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P0000030?ooo`030000003oool0oooo0140
oooo1000003o0?oooi80oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cT0oooo1000000E0?ooo`<00000o`3ooonA0?ooo`040000o`3oool0oooo0000
o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=C0?ooo`800000o`3ooon@0?oo
o`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooi03oool60000o`80oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/0?ooo`D0003o1P3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=J
0?ooo`<00000<P3oool2000001T0oooo0`00000H0?ooo`<00000<`3oool300000?40oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=K0?ooo`030000003oool0oooo0340oooo00<00000
0?ooo`0000006@3oool00`000000oooo0?ooo`0F0?ooo`050000003oool0oooo0?ooo`000000<@3o
ool01@000000oooo0?ooo`3oool000000?00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c=K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0F0?ooo`050000003oool0oooo0?ooo`000000<@3oool01@000000oooo0?ooo`3oool00000
0?00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`<000000P3oool30000
0080oooo0P0000020?ooo`<000000P3oool2000000D0oooo1P0000060?ooo`80000000<0oooo0000
000000000P0000000`3oool00000000000040?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0P0000000`3oool0000000000002000000040?ooo`00000000000?ooo`80000000<0oooo
0000003oool00P0000020?ooo`<0000000<0oooo0000000000001P3oool300000080oooo0`000005
0?ooo`80000000<0oooo0000003oool0103oool00`000000oooo0?ooo`020?ooo`8000000P3oool3
000000<0oooo00<000000?ooo`3oool0103oool300000080oooo1P000000103oool000000000003o
ool2000000030?ooo`000000oooo008000000P3oool3000000030?ooo`000000000000H0oooo0P00
00000`3oool0000000000002000000040?ooo`0000000000000000<0oooo0P0000030?ooo`<00000
0P3oool300000080oooo0P0000000`3oool0000000000002000000030?ooo`000000000000D0oooo
1P0000001@3oool000000000003oool000000080oooo0P0000030?ooo`<000000P3oool300000080
oooo0P0000000`3oool0000000000002000000030?ooo`000000oooo0>00oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<?0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`030000003oool00000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo008000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool01000
0000oooo0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0P0000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`0000001@3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo
00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080
oooo00H000000?ooo`3oool000000?ooo`0000060?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool00000i03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool0oooo0P0000040?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0000000L0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3oool00`000000
oooo000000020?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool0
000000L0oooo0P0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000001`3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo008000000`3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`060000003o
ool0oooo0000003oool00000203oool010000000oooo0?ooo`0000020?ooo`030000003oool00000
0080oooo00<000000?ooo`3oool00`3oool2000000@0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`00003T0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@000000P3oool00`000000oooo0?oo
o`04000000D0oooo00@000000?ooo`00000000001`3oool300000080oooo00@000000?ooo`3oool0
0000103oool4000000<0oooo00<000000?ooo`3oool00P3oool300000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0000003oool01000
00040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`<00000
1@3oool00`000000oooo000000020?ooo`@000000P3oool01`000000oooo0?ooo`3oool000000?oo
o`0000001@3oool2000000@0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo00000003000000D0oooo
0`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool0100000000`3oool00000
0?ooo`020?ooo`040000003oool0oooo000000<0oooo0`0000020?ooo`030000003oool0000000P0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`@0000000D0oooo0000
003oool0oooo000000030?ooo`040000003oool0oooo0?ooo`<000000P3oool00`000000oooo0?oo
o`3R0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool600000080oooo00@0
00000?ooo`3oool000000P3oool2000000050?ooo`000000oooo0?ooo`0000001@3oool00`000000
oooo000000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P0000020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`040000003o
ool0oooo000000@0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00<000000?oo
o`3oool00P0000000`3oool000000?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo
0P0000020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0000000000080oooo00<000000?ooo`3oool00P0000001@3oool00000
0?ooo`3oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`000000
oooo00000080oooo00@000000?ooo`3oool0oooo0P0000001@3oool000000?ooo`3oool000000080
oooo00<000000?ooo`3oool0hP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3oool200000080oooo00D000000?oo
o`00000000000?ooo`02000000D0oooo0P0000020?ooo`<000001@3oool200000080oooo00@00000
0?ooo`00000000001P3oool200000080oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool01@000000oooo000000000000oooo008000000P3oool2000000030?ooo`000000000000<0oooo
00<000000?ooo`3oool00P0000060?ooo`<000000P3oool3000000D0oooo0P0000040?ooo`<00000
00D0oooo00000000000000000?ooo`0200000080oooo00<000000?ooo`0000000`000000103oool0
00000000000000040?ooo`<0000000H0oooo000000000000oooo0000003oool2000000030?ooo`00
000000000080oooo0P0000000`3oool00000000000030?ooo`030000003oool0oooo008000001P3o
ool2000000<0oooo00<000000?ooo`3oool0100000020?ooo`8000000P3oool010000000oooo0000
000000020?ooo`050000003oool000000000003oool00P0000020?ooo`8000000P3oool2000000D0
oooo0P0000000`3oool000000?ooo`02000000040?ooo`000000000000000080oooo0P0000030?oo
o`@0000000<0oooo0000003oool00P0000000`3oool00000000000030?ooo`040000003oool0oooo
00000>40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<?0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo03`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`3R0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo04/0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0
oooo0>80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`<000000P3oool3
000001<0oooo00<000000?ooo`3oool0=@3oool200000140oooo0P00000Y0?ooo`030000003oool0
oooo00l0oooo0P00000>0?ooo`8000002`3oool2000000l0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0L0?ooo`800000i03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooook@3oool40000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d80oooo0P00001<0?ooo`@00000o`3ooomL
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c@P3oool2000004/0oooo0P000002
0?ooo`800000o`3ooomK0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c@P3oool2
00000500oooo0P00003o0?oooeX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=
0?ooo`T000001P3oool800000080oooo0P0000030?ooo`8000000P3oool900000080oooo0P000002
0?ooo`8000000P3oool5000000<0oooo0P0000040?ooo`<00000103oool5000000T0oooo0`000003
0?ooo`8000002@3oool200000080oooo0P0000030?ooo`8000000P3oool2000000@0oooo0`000005
0?ooo`D0000000<0oooo000000000000103oool9000000<0oooo1@00003o0?oood80oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`T000001P3oool2000000T0oooo0P000000
0`3oool00000000000020?ooo`8000000P3oool3000000030?ooo`00000000000080oooo0P000002
0?ooo`8000000P3oool3000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo
0000000000000P3oool2000000<0oooo0P0000070?ooo`80000000<0oooo0000000000000P3oool2
000000T0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000@0oooo0P000000
0`3oool00000000000030?ooo`80000000D0oooo00000000000000000?ooo`02000000<0oooo0P00
00020?ooo`<0000000<0oooo0000000000000P3oool2000000<0oooo0P00003o0?oood40oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`T000001P3oool2000000T0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P00
00020?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`00
0000000000T0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00
00030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P00003o0?oood40oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`T000001P3oool2000000X0oooo0`00
00030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`8000000P3o
ool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000002`3oool2000000H0oooo0P00
00030?ooo`80000000<0oooo0000000000002@3oool200000080oooo0P0000030?ooo`80000000<0
oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool2000000<0oooo0P0000000`3oool00000000000070?ooo`800000o`3ooom10?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool9000000H0oooo0P00000:0?ooo`<00000103o
ool6000000030?ooo`00000000000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P00
00000`3oool00000000000020?ooo`L00000103oool3000000L0oooo0P0000030?ooo`80000000<0
oooo0000000000002@3oool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool7000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000040?ooo`H0000000<0
oooo0000000000001@3oool300000?l0oooo@P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`d0oooo2@0000060?ooo`8000002P3oool3000000L0oooo0`0000000`3oool000000000
00020?ooo`8000000P3oool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000P3o
ool2000000<0oooo0P0000020?ooo`<000002@3oool2000000<0oooo0P0000000`3oool000000000
00090?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3o
ool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000070?ooo`<0000000<0
oooo0000000000000`3oool300000?l0ooooA03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`d0oooo2@0000060?ooo`P000000`3oool2000000030?ooo`00000000000080oooo0P00
00030?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000020?ooo`8000000`3o
ool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3o
ool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000002@3oool200000080oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000000`3oool000000000
00020?ooo`8000000`3oool200000?l0oooo@@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`d0oooo2@0000060?ooo`8000002@3oool2000000030?ooo`00000000000080oooo0P00
00030?ooo`80000000D0oooo00000000000000000?ooo`03000000030?ooo`00000000000080oooo
0`0000000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`00000000000080oooo
0P0000030?ooo`8000001`3oool2000000030?ooo`00000000000080oooo0P0000090?ooo`800000
0P3oool300000080oooo0P0000000`3oool00000000000040?ooo`80000000<0oooo000000000000
0`3oool2000000050?ooo`00000000000000003oool00`0000020?ooo`8000000`3oool200000003
0?ooo`00000000000080oooo0P0000030?ooo`800000o`3ooom10?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c3@3oool9000000H0oooo0P0000080?ooo`8000000`3oool200000080
oooo1@0000020?ooo`D0000000@0oooo00000000000000000`3oool5000000<0oooo0P0000040?oo
o`<00000103oool5000000T0oooo0`0000020?ooo`@00000203oool200000080oooo1P0000000`3o
ool0000000000002000000@0oooo0`0000050?ooo`D0000000<0oooo0000000000000P0000020?oo
o`D000000P3oool2000000<0oooo1@00003o0?oood80oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<L0?ooo`800000;03oool2000001l0oooo0P0000090?ooo`8000002P3oool20000
0200oooo0P00003o0?ooodX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<L0?oo
o`800000;03oool2000001l0oooo0P0000090?ooo`8000002P3oool200000200oooo0P00003o0?oo
odL0oooo10000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a`0oooo2000000V0?ooo`800000803oool20000
00P0oooo0P00000/0?ooo`800000o`3ooom:0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooo/0?ooo`D0003o0P3oool50000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0
VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3UiND0
iNGU0?l0iNGUo`3UiND80>GUi@40oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 383},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.1"],

Cell[TextData[{
  "In some cases, you may not need to use the notebook front end, and you may \
want instead to interact more directly with the ",
  StyleBox["Mathematica", "TI"],
  " kernel. You can do this by using a text\[Hyphen]based interface, in which \
text you type on the keyboard goes straight to the kernel. "
}], "Text",
  CellTags->{"S1.3.1", "1.6"}],

Cell["", "SessionLabel",
  CellTags->{"S1.3.1", "1.7"}],

Cell[TextData[{
  "A dialog with ",
  StyleBox["Mathematica", "TI"],
  " using a text\[Hyphen]based interface."
}], "MathCaption",
  CellTags->{"S1.3.1", "1.8"}],

Cell["\<\
In[1]:= 2^100

Out[1]= 1267650600228229401496703205376

In[2]:= Integrate[1/(x^3 - 1), x]

                 1 + 2 x
          ArcTan[-------]                               2
                 Sqrt[3]     Log[-1 + x]   Log[1 + x + x ]
Out[2]= -(---------------) + ----------- - ---------------
              Sqrt[3]             3               6\
\>", "Program",
  CellTags->{"S1.3.1", "1.9"}],

Cell[TextData[{
  "An important aspect of ",
  StyleBox["Mathematica", "TI"],
  " is that it can interact not only with human users but also with other \
programs. This is achieved primarily through ",
  StyleBox["MathLink", "TI"],
  ", which is a standardized protocol for two\[Hyphen]way communication \
between external programs and the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "Text",
  CellTags->{"S1.3.1", "1.10"}],

Cell["", "SessionLabel",
  CellTags->{"S1.3.1", "1.11"}],

Cell[TextData[{
  "A fragment of C code that communicates via ",
  StyleBox["MathLink", "TI"],
  " with the ",
  StyleBox["Mathematica", "TI"],
  " kernel."
}], "MathCaption",
  CellTags->{"S1.3.1", "1.12"}],

Cell["\<\
MLPutFunction(stdlink,  \"EvaluatePacket\", 1);

  MLPutFunction(stdlink, \"Gamma\", 2);
    MLPutReal(stdlink, 2);
    MLPutInteger(stdlink, n);

MLEndPacket(stdlink);
MLCheckFunction(stdlink, \"ReturnPacket\", &n);

MLGetReal(stdlink, &result);\
\>", "Program",
  CellTags->{"S1.3.1", "1.13"}],

Cell[TextData[{
  "Among the many ",
  StyleBox["MathLink", "TI"],
  "\[Hyphen]compatible programs that are now available, some are set up to \
serve as complete front ends to ",
  StyleBox["Mathematica", "TI"],
  ". Often such front ends provide their own special user interfaces, and \
treat the ",
  StyleBox["Mathematica", "TI"],
  " kernel purely as an embedded computational engine. If you are using ",
  StyleBox["Mathematica", "TI"],
  " in this way, then only some parts of the discussion in the remainder of \
this section will probably be relevant. "
}], "Text",
  CellTags->{"S1.3.1", "1.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3.2 Differences between Computer Systems", "Subsection",
  CellTags->{"S1.3.2", "2.1"}],

Cell[TextData[{
  "There are many detailed differences between different kinds of computer \
systems. But one of the important features of ",
  StyleBox["Mathematica", "TI"],
  " is that it allows you to work and create material without being concerned \
about such differences.  "
}], "Text",
  CellTags->{"S1.3.2", "2.2"}],

Cell[TextData[{
  "In order to fit in as well as possible with particular computer systems, \
the user interface for ",
  StyleBox["Mathematica", "TI"],
  " on different systems is inevitably at least slightly different. But the \
crucial point is that beyond superficial differences, ",
  StyleBox["Mathematica", "TI"],
  " is set up to work in exactly the same way on every kind of computer \
system.  "
}], "Text",
  CellTags->{"S1.3.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] The language used by the ",
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] The structure of ",
              StyleBox["Mathematica", "TI"],
              " notebooks "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] The ",
              StyleBox["MathLink", "TI"],
              " communication protocol "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.2"],

Cell[TextData[{
  "Elements of ",
  StyleBox["Mathematica", "SO"],
  " that are exactly the same on all computer systems. "
}], "Caption",
  CellTags->"S1.3.2"],

Cell[TextData[{
  "The commands that you give to the ",
  StyleBox["Mathematica", "TI"],
  " kernel, for example, are absolutely identical on every computer system. \
This means that when you write a program using these commands, you can \
immediately take the program and run it on any computer that supports ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"S1.3.2", "2.4"}],

Cell[TextData[{
  "The structure of ",
  StyleBox["Mathematica", "TI"],
  " notebooks is also the same on all computer systems. And as a result, if \
you create a notebook on one computer system, you can immediately take it and \
use it on any other system.  "
}], "Text",
  CellTags->{"S1.3.2", "2.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] The visual appearance of windows, \
fonts, etc.\
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Mechanisms for importing and \
exporting material from notebooks \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Keyboard shortcuts for menu \
commands \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.2"],

Cell["\<\
Elements that can differ from one computer system to another. \
\
\>", "Caption",
  CellTags->"S1.3.2"],

Cell[TextData[{
  "Although the underlying structure of ",
  StyleBox["Mathematica", "TI"],
  " notebooks is always the same, there are often superficial differences in \
the way notebooks look on different computer systems, and in some of the \
mechanisms provided for interacting with them. "
}], "Text",
  CellTags->{"S1.3.2", "2.6"}],

Cell["\<\
The goal in each case is to make notebooks work in a way that is as \
familiar as possible to people who are used to a particular type of computer \
system. \
\>", "Text",
  CellTags->{"S1.3.2", "2.7"}],

Cell["\<\
And in addition, by adapting the details of notebooks to each \
specific computer system, it becomes easier to exchange material between \
notebooks and other programs running on that computer system.  \
\>", "Text",
  CellTags->{"S1.3.2", "2.8"}],

Cell[TextData[{
  "The same ",
  StyleBox["Mathematica", "TI"],
  " notebook on three different computer systems. The underlying structure is \
exactly the same, but some details of the presentation are different."
}], "MathCaption",
  CellTags->{"S1.3.2", "2.9"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008Q0001Cb000`400?l00000o`00003ooooooooo
ooooob?ooooo003ooooooooooooo8oooool00;CoooooooogmoMSooOgm`_ooooo002`ooooo`;omoOg
00?okoO_ono_koo_knl0ooo_knmSono_k`03onogkoogmoOomoOg00Oooooo002_ooooo`03ooOgmoo_
mnookno_00;oinOWoooNg]iSomkNgP;oinOW00?okno_onogkoogmoL01_ooool00:kooooo00ComoOg
ono_kooWinOog]kN0_oFe]H2olk>c_ooa/K6Goo6a/H2olk>cP;oe]KF00Cog]kNonOWioo_knoomoOg
1Oooool00:gooooo00OomoOgonogkooWinOog]kNomKFe_o6a/Ko_Kfm00;o]KFeoon][JeOojf][@;o
]KFe00Oo_KfmolK6a_oFe]Kog]kNonOWioo_mnoomoOg00Cooooo002]ooooo`08ooOgmoo_knoog]kN
omKFe_o6a/Ko]KFeojf]YOnLW9cooiBDU67oU9BD00SoW9bLojf]YOne]KGoa/K6omKFe_oNg]kokno_
ooOgm`Cooooo002]ooooo`09onogkooWinOoe]KFolK6a_ne]KGoYJFUoiBDU?n<S8coQ8B40?ooNg]k
GomkNg/02On4Q8CoS8b<oiBDU?nUYJGo]KFeolK6a_oFe]KoinOWonogk`04ooooo`00[Oooool02_o_
knooinOWomKFe_nm_Kgo[JfUoiBDU?n4Q8CoNg]kof]cJom[Jf_oof=SHegoHf=S00[oJf][of]cJomk
Ng_oQ8B4oiBDU?n][JGo_KfmomKFe_oWinOokno_1?ooool00:cooooo00_omoOgono_kooNg]koc/k>
okFe]OnLW9coS8b<og]kNom[Jf_oHf=SoeYJFP3ooe9BDUgoDU9B00_oFUYJof=SHom[Jf_oNg]kohb<
S?nLW9co]KFeolk>c_oNg]kokno_ooOgm`03ooooo`00[?ooool02oogmoOokno_omkNg_o>c/ko]KFe
oiBDU?n4Q8CoJg=[of=SHomBDU;oBU9:0?ooBTY:GOm:BTX02om:DT[oDU9Bof=SHom[Lf_oQ8B4oiBD
U?ne]KGoc/k>omkNg_o_knoomoOg00?ooooo002/ooooo`0:ooOgmoo_knoog]kNolK6a_n][JgoU9BD
og]kNom[Jf_oFUYJodYBB_oo@T92D?m2@T8>ohN7VP0;ohR8V_n5QISoKfn5of][JomkNg_oU9BDojf]
[Oo6a/Kog]kNono_koogmoL00oooool00:kooooo00?oKfn5ohF5V?n8R9X0oon7QiYSohN7VP0;ohR8
V_n5QISoKfn5of][JomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:kooooo00?oPh>G
oooooooWj>l0ooo/kO=Sonc]l`0;onOXkoooooooPh>Gof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_
koogmoL00oooool00:kooooo00CoQhNJonOXk_moP9OoK6b5oom]KHIDofe]QP03ofm_Qom_KhSoKfn8
00[oKfn800coKVj7ogn0UooWj>koQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3oooo
o`00[_ooool01On7Qi[ok>kcofa/QOo5aLkohn?W06coh>3U00?oh>3TolO6c_o7a/h0:Oo7a/h01?o8
aloo`lC?oh:2T_nCTZ<8oi6AX@06oi2@X?n;S9coe=KJokbl__nBTj7oSi2PL_n@TJ001?n>SiooYJF]
om7@d?o<c=Pbolc<e`0IomCCf?oThnKohn;Uon?Ri_oNg=conOWeooGem_oJf=[olO7]oo_ko?oLf]go
j^WVooooooo:bM3oKfn8onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03oooo
o`00[_ooool01?n7Qi[ok>gcog=dS?nEU9]/onCSiP03on?RiOojn__ohn?U02[ohn;U00Coh^7TojJW
/_oSi>Woe]OR2?oGf>801_oHfN?oemSMohf>W?o4a<[oe=GOolS9eg;obL[G00CoalSFomcMhOnc];go
oooo<_ono_l06Oo?c]CohN3Ton3OhooSh^So][:QokfiY_oemO_o`KjdojjZT_obl_CocL_6ojNRR?oZ
jNGobLS@ofm_R?o/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:ko
oooo00CoQhNJonc]lomcM8goT92HK?oPgn<00ooNgN;on_[jon7Pi002on3Oh`0=on7Pi?oem?SomoKj
onOVj_oNgN7oi>?WooOfn_ofmOWohn;VomkMhOoYj>comoKjooCcm`03on3Oh`04on7Pi?oal?CogmkR
omoNhP;ol_7e00?ogmkRon3OhooPgn<03ooPgn<01?oNgN7oZJZdoo?cmoo5a]D2ol[;f@03olW:f?oC
e>?ocLkM00?ob/_I00Koc<gKonk^l?n3QICoe=CIon3Qjoo;c=]bolg>g004olW:fOocm?OoYjRboooo
oc;ono_n00CoclkDon7Pi?oPgn?ohN3U0_oCdLh04ooQh>GoemKEolk<aooMg>3ofm[Kolk;aOoLf]co
alK>ofm_R?o/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:kooooo
00CoQhNJonc]lomcM8goT92HK?oPgn<00ooNgN;on_[jon7Pi002on3Oh`0Dom_Jg_m9BD[o@D52ojRW
Z_o^kO;oclkBocPh>Olj>S_oe]GIoo;amOn[Zjgo=CDfod];C?o]k?3ogmkRon3OhooHem_oKfi`onSW
joofmOT2oemOH003ooKenOoOg^;oh=oS00ooh=oS00[og]gQojVZ]?ocm?Soa/OGol_<f_o:bmWoemWX
oiFEW_nl_<Woc/oM0_o;c=X01oo=c]cok^k`oh>5U?oDe=Woh>7[ol_<f_o=c]`05oo=c]/<olg>g0_o
cLkK1Oo=c]`Golg>f`cocLkL2oo=c]/@olg>g004olW:fOocm?OoZ:Rcoooooc;on_[n01WoclkDon7P
i?oPgn?oh=oSon?RiooRhNKoh=oRomoNhoogmo[om_KgomgKh?oblOGoo_koolO7c_m_KhSok>gcohN7
V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002^ooooo`04ohN7V_o/kO?oLgB=
oi2@V6coh=oS00?og]gRoo[jn_oQh>@00_oPgn<05?oSh^KoOgj0oc@d=OoNgN3of]WMod10@?nf]KWo
];>fodA4AOn`/;?oCdi?okRg^onSXZGoBTY;onk]l_oPgn?odm;FobTX:Oooo_ooH5mQ0_n@Si400omP
Gf7ol_7eon3Oh`06on3Oh`03on?Ri_oUi>SoiNCX00?oiNCX0ooPgn<02_oNgN7oZJZdoo?dn?o6amOo
blcJomCEiOnTY:ko=34`odm=Coo9b]L2ol_<fP07olg>g?o^k_3oPhFDomCDfOoUiNkod]?Nom?Dh00<
om?Dg`_odmCP3?oCe>4;omCDh0CodmCQ00?odmCPom?DgooCe=l02_oCe=l;om?Dh0codmCQ2ooDe>0<
om?Dh@?odmCP00GodmCQom3AgooemOSoYjRcooooo`0booWin`03olo>e?oQh>Coh=oS00?oh=oS01?o
i>?YolK3^_nf/YgomoOjolk<b?n^ZY?olO7]olW8d?m_KhSok>gcohN7V_mSHf?oNg]koiBDU?n][Jgo
a/K6omkNg_o_knoomoOg00?ooooo002^ooooo`04ohN7V_o/kO?oLgB=oi2@V6coh=oS00?og]gRoo[j
n_oQh>@00_oPgn<06?oViNWoZJR[ode<C_ogm_[odm;Eob`/;Oogm_[olo;fobh^;onQX:?oCDa>oo[i
oOoHem_o:b//oo3_looZj>gomO?hojRXZomOGV3oO7]mohn>T?n@Si7oH5mQoo;am@Koh=oS00?oiNCX
oknn`Ond/kL00_nj^Kd00onk^[ko[jjaomkMh@02on3Oh`0:omkMhOnYZ[Com?CiolK8f?oFenKoYJJ`
oc4_;Oln?3co];G1olo@g`;oc<gL00Ooc/oNonk^l?n3QICodm?Hon_[l_oJf^Gofm_U02kofmcU1?oK
fnH00ooKfnGofmcUom_Li@0/om_LiA3ofm_V00Cof=WSooKfn?nWZ;?ooooo<_oinO/00oo?c]CohN3T
on3Oh`03on3Oh`0Con;RiooAc/[oa/>hon3OhooGeMCo`Kjbom[HfOo8alooKfn8onc]lon7Qi[oHf=S
og]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00[_ooool01?n7Qi[ok>gcog=dSOn@T9Q/
on3Oh`03omkMh_ojn_[ohN3T00;oh=oS01Soi^GYojFTYom:BT_omOChom?Be_l[:bcolO3eonk]lOl^
;BkoXJ2SodY:Booem?Sodm;FobXZ:_ooooooYJBVogMfN?oEe=OoEEEFom_Jg_mUI6KoGemPooKenOoO
g^86on3Oh`03onk]l_n5Q8Oo0P8200?o000000go>3PiomgLh?oPgn?oh=oSomkMhOnYZK?om_OjomGG
i?nHV:7o<c4`oe5@DOo2`lgofmgZ00?odmGQ00OoeMOSonk^l?n3QICodm?Honc/looMg>OogMgV02ko
gMkW1?oNgNL00ooMgNKogMkWomgNi`0/omgNi`cog]gW0ooMgNL01OoNgNOof]_VooOgnOnWZ;;oo_ko
03;on?Sj00?oclkDon7Pi?oPgn<00ooPgn<04ooPgn;oh^7WonCSjOoPgn;ohN3UooGen_ohn?WoalK>
ofm_R?o/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:kooooo00Co
QhNJonc]lomcM8goT92HK?oPgn<00ooNgN;on_[jon7Pi002on3Oh`0GonOVj_nb/KCoBDU:ooGdn?oC
d]Ko:b//oo7`mOo^kO7o;Rd^oj6PXom:BT_omOChom?Be_le=CKo]KFhoeiMG_mcLWCoP822ohf<S_mm
OGoooooooo;amOoOg^801ooPgn<00ooNgN7om??hoibKWP02o`000003odm>D?oZjNgoi>?W00;oh=oS
00Wog]gQojRY/oojnogoh^?/ojBSZ?la;bkoD4i@ol_:d_oXjO800ooOh>P01ooQh^[ok^oaoh>5U?oB
d]Som?ChonKVkOoVi^h03?oWind;onOVkAOoi^O]1?oWind00ooVi^koinO]onOWk@0:onOWk@_oinK]
5ooVind@onOWk@04onCUk?ohnO[oYZNboo_loS;omOKi00?oclkDon7Pi?oPgn<01_oPgn<04?oRhNOo
d]3>ok^hY?ohn?CobLS@ofm_R?o/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3
ooooo`00[_ooool01?n7Qi[ok>gcog=dSOn@T9Q/on3Oh`03omkMh_ojn_[ohN3T00;oh=oS01Kog=_O
oa8B4_mIF5[omOChom?Ce_l/;2gojNO/onGTj?l_;c3oXj:UodU9B_o/jnoobl_>ocdm?_n0Oh7oPH22
onOVj_l/;2col>kcodY:Bonf]KSoi>?W2OoPgn<01_oOg^;ol>kcoi2@Tolg=cSokN_`onOUjP?oh=oS
00[og]gQojNX/_ooooooj>S^ooKfnonm_<3o;bd/ochl??o=c=7oknod0_o[jo001oo]kO;oknoaoh>5
U?oBd]Som_KionOXk_oXj>l03?oYjNh;onWXkQOoj>W^1?oXjNl00ooXj>oojNW^onWYkP0:onWYkP_o
jNS^5ooXjNh<onSYk`?ojNW^00Goj>W_onKVkOoinO[oYZNbooWio00boo?cm`03olo>e?oQh>Coh=oS
00Koh=oS013oh^7Wom?Ac_nh]:;ogM_KolS7com_KhSok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6
omkNg_o_knoomoOg0oooool00:kooooo00CoQhNJonc]lomcM8goT92HK?oPgn<00ooNgN;on_[jon7P
i002on3Oh`0FonGTj?nYZ:_oI6AUoo7`m?oUi>So^[Vmoa/K7?lN7Qoo`l;6ono^l_nCTYGo61PIobh^
;ooNgN7ol>ocofQXJ_lT92Gof][MooCcn?mOGUoo/k:eonCSi`_oh=oS00?ohn;Von3OhooSh^H01?oP
gn<02_oNgN7oYjNbooooooodm?OomOGhooooooo2`/Co<Bl^oeACDoobl_D2ooGen006ooOgn_o_ko7o
PhFDom;Beoogmo[oj^[`L_o[jo001?oYjNoonOWkojFV/_ofmo/boo3amP03olo>e?oQh>Coh=oS00Oo
h=oS00oohN3Uon?RjOoSh^KoalK>ofm_R?o/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_
koogmoL00oooool00:kooooo00CoQhNJonc]lomcM8goT92HK?oPgn<00ooNgN;on_[jon7Pi003on3O
h`05onCSioo[j^kogmkRon3OhooSh^H00_oal?@03OoRhNGogmkRonOVj_oal?Col>ocon3OhooNgN7o
j^W]oo3_looPgn?ogmkRon_Zk_oThnL04ooPgn<00ooNgN7oYZNbooooo`03oogno@04oooooon`[joo
h=oOooooo`;ooOkm00Koooooono_lOn3QICodM;Goo[joOo^k_=bono_l`04onk^l_ojn__oYJJaooGf
nS;oko3e00?oclkDon7Pi?oPgn<02OoPgn<03OoSh^GoalK>ofm_R?o/kO?oQhNJof=SHomkNg_oU9BD
ojf][Oo6a/Kog]kNono_koogmoL00oooool00:kooooo00CoQhNJonc]lomcM8goT92HK?oPgn<00ooN
gN;on_[jon7Pi00Zon3Oh`03omkMh_nNWj_on?Sh00[ooooo00?og]kRogn0T?o>c]@0MOooool00oom
oOgoXJ:^oo?en@0bong_m003on3PhooQh>Coh^7U00Woh^3T00goiNCWolO6c_m_KhSok>gcohN7V_mS
Hf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002^ooooo`04ohN7V_o/kO?oM7B=ohn?
UV;ogMcP00?oh=oSonCSiooNgN401ooMg>000ooKf]konOWjon3Oh`0WomoNhP07on3OhooViNWohn;V
on?Ri?o4b<WoZJVcol[:d006olC4bP07ol?4b_o4a<[o`/;9oj:T[_oAeMCoaLK=olC5b`0:olK7c003
olW9coo7b<goa/O<00Ooa/O<00OobLW?olG7boo9bLooa/K<ol?3bOo6a/cobl_A00SobL[?00?ob/[@
olK6boo6a//00_o6a//01Oo9bLooa<C:olC4b_o4a<[obLW?00Ooa<C:2Oo6al`00oo9bLooalS=olK7
c007olK7c007olW9coo5al_obLW?olK6c?o3`lWoa/K<ol_;d@08olW:c`03ol[:d?o6a/_oa/K;00;o
a/K;00GobLW?olC4b_o4a<[oa<C:olW9c`0ColC4bP04olG5bonf^<?oalWAonk`mC;ojngc00?oi^CU
on;Qi_o<c=802OoAd=H03Oo@cmGoc<_Cofi_Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kN
ono_koogmoL00oooool00:kooooo00CoQhNJonc]lombLh_oWYjToooooolJooooo`Gok>cY00?ojncY
onk^kOoZj_40<_oZj_401?oalNWo`/?<ojBU/?na/l07ok2b_P0>ok6c_onUYk7o/;:nog5aROo/kO?o
QhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3ooooo`00[_ooool01On7Qi[ok>gcofe]
Q_oQhNGokno_0?ooooooDoooool01?o[j^CoXjB^ooCdn?oCe>47omKGh`0>om?EhOocloGoQHBDogEe
SOo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3ooooo`00[_ooool01On7Qi[o
k>gcofe]Q_oQhNGokno_0?ooooooDoooool01?o[j^Co[:ffoo;bmoo5a]H2ol[;f@03olc=foo;c=_o
b/_I00;ob/_I00koa/OFooGfn?n;Ri[oM7B=onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]ko
kno_ooOgm`?ooooo002/ooooo`07ooOgmoo_knooQhNJonc]lom]KHKohN7Uono_k`3ooooooe?ooooo
00Wojn[Tojb]]_obl_Ooa/OGol_<f_o?d=ooa<GBolG6doo?d=h00_o;c=X03_o7b=Oom_Khoh^;V_md
M8gok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg0oooool00:cooooo00OomoOg
ono_kon7Qi[ok>gcofe]Q_oQhNGokno_0?ooooooDoooool06Oo[j^Co[:ffoo;bmoo6amOocLkMom;C
h_mPGf;oHf9Vom?Dhoo=c]coblcJolO8eoofm_SoRh^JogAdSOo/kO?oQhNJof=SHomkNg_oU9BDojf]
[Oo6a/Kog]kNono_koogmoL00oooool00:cooooo00OomoOgono_kon7Qi[ok>gcofe]Q_oQhNGokno_
0?ooooooDoooool06Oo[j^Co[:ffoo;bmoo6amKodmCSofMVJol^;2[o;b`ZofYYK_oDeNCob/_IolO8
eoofm_SoRh^JogAdSOo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool0
0:cooooo00OomoOgono_kon7Qi[ok>gcofe]Q_oQhNGokno_0?ooooooDoooool06Oo[j^Co[:bfooGe
n_o?d>3oIVAYob/X9omnOX?oNWYoob/Y9omYJ6coe=KTolg>gOofmoWoRh^JogAdSOo/kO?oQhNJof=S
HomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:cooooo00OomoOgono_kon7Qi[ok>gc
ofe]Q_oQhNGokno_0?ooooooDoooool06Oo[j^CoZjbeoooooon8R8go;R/Zog5`LooTi_3ohnC^ofe/
Kol^:b_oShnDon?Tl?ohn?[oRX^JogAdSOo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_
koogmoL00oooool00:cooooo00OomoOgono_kon7Qi[ok>gcofe]Q_oQhNGokno_0?ooooooDoooool0
1_o[j^CoZZ^eooclo_obl__oUIBGong]m0;oiNG/017ojn_boiJEV?oemOgohn?[oo[jnon:Ri[oM7B=
onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00[?ooool01_ogmoOo
kno_ohN7V_o/kO?oKFf6on7QiOooooooB_ooool01_nLW?oo:BWoobTYoolY:OoooooooibLo`;o:BWo
0_ooool01Oo[j^CoZJZdooooooo_ko?ooOgm00?olO7e017ol_;eoocloOo`l?Col?3doocloOn:Ri[o
M7B=onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00[?ooool01_og
moOokno_ohN7V_o/kO?oKFf6on7QiBKooooo00?oNg]koe9BD_oNg]h00oooool00omJFU[oDU9Boooo
o`3ooooooakooooo00?o:BWoomKFooooool00_ooool01OlY:Oooe]KooooooonYZKCooooo00Won__l
00goo_knohZ:VOmdM8gok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo
002/ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U9_ooool02One]KGo_Kfmof=SHooWinOooooo
oe9BD_nDU9CoYJFUodY:BP3ooooooakooooo00?o:BWoomKFooooool00_ooool01?lY:Ooojn[TojVZ
]?nUYK0:ooooo`0=oogmoOn6QYKoM7F=onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_
ooOgm`03ooooo`00[?ooool01_ogmoOokno_ohN7V_o/kO?oKFf6on7QiBOooooo00Go]KFeoiBDU?l8
20Soooooo`000002ooooo`03o`000?oooooooooo0?oooooo7?ooool00olY:Oooe]Koooooo`02oooo
o`08obTYooo[j^CoZJZdojR[/_o3`l[oh^7UomgMhOoMgN04omcLh00?om_Lh?oOgn?o][Jooi^MYomb
Lh_ok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002/ooooo`06ooOg
moo_knooQhNJonc]lom]KHKohN7U9_ooool01_mcLg?oHf=Sog]kNol820SooooooaPH60;ooooo00?o
410@ooooooooool0oooooolLooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[CohNCW
olG7d?oCdm_od]?JomCDfooFe]coemOMomOHgOoHf=gof=SNom[Jh?o@d=SoblgDofi_Qoo/kO?oQhNJ
of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:cooooo00KomoOgono_kon7Qi[o
k>gcofe]Q_oQhNDVooooo`06o`000?ooooooooooo`P82?oooooo00000_ooool00ol0003ooooooooo
o`3ooooooacooooo00?o:BWoomKFooooool00_ooool03?lY:Ooojn[TojVZ]?o]l?Kol_Gioo?cn?od
mO[omoOkooWjoOolo?koo_gooogmo`?ooooo00coc<gHofi_Qoo/kO?oQhNJof=SHomkNg_oU9BDojf]
[Oo6a/Kog]kNono_koogmoL3ooooo`00[?ooool01_ogmoOokno_ohN7V_o/kO?oKFf6on7QiBKooooo
00WoNg]kof=SHomSHf?oJg=[oooooomkNg_oFUYJof=SHom[Lf/0oooooolNooooo`03obTYoooFe_oo
oooo00;ooooo00[o:BWoon_Zi?nYZ[Cojnkcong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03ooj
n_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03
ooooo`00[?ooool01_ogmoOokno_ohN7V_o/kO?oKFf6on7QiBOooooo00?oU9BDohb<S?ooool00_oo
ool00onDU9CoS8b<ooooo`09ooooo`03odY:B_oooooooooo06?ooooo00?oQ8B4oaPH6?ooool01_oo
ool00ooNg]ko20P8omkNgP02ooooo`03odY:B_oooooooooo09gooooo00?o:BWoomKFooooool00_oo
ool02_lY:Ooojn[TojVZ]?o[k_?okNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_oknoko
o_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002/
ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U=_ooool01Oo_knoo@T92olk>c_oooooo]KFe00?o
[Jf]0_ooool00onLW9coU9BDooooo`02ooooo`;og]kN0oooool00one]KGoooooooooo`06ooooo`03
olk>c_oooooooooo00?ooooo00CoW9bLokFe]OnUYJGoa/K60_ooool00onDU9Co[JfUooooo`02oooo
o`03olK6a_oooooooooo00;ooooo00?oa/K6ooooooooool01_ooool00oo>c/koooooooooo`04oooo
o`0<olk>c_oooooooooooooooon][JgoYJFUojf][Oo_knooooooono_konDU9Coa/K61?ooool01?ne
]KGoYJFUojFUYOoNg]h2ooooo`;oU9BD00Koa/K6oooooooooooog]kNoiBDU?oFe]H2ooooo`07oiBD
U?n][Jgo]KFeonOWiooooooo<C4aojFUY@03ooooo`03oiBDU?n][Jgooooo00;ooooo00Ko:BTYokFe
]OoooooooooookFe]OmBDU:Nooooo`03obTYoooFe_oooooo00;ooooo00[o:BWoon_Zi?nYZ[Cojnkc
ong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[o
Hf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00[?ooool01_ogmoOokno_ohN7V_o/
kO?oKFf6on7QiCKooooo00goQ8B4of]cJooooooooooooiBDU?lH61So20P8ohB4Q?ooooooJf][oe9B
D_m[Jf_oHf=S00;ooooo00Coe]KFob4Q8Oo_knoooooo0_mkNg/8ooooo`03oaPH6?oooooooooo00?o
oooo00WoLg=co`000?la<C7oYJFUoooooomSHf?oJf][oe9BD_nDU9@00_ooool01_n][Jgo<C4aoooo
ooooooooBTY:ojf][@Sooooo00?o0000ooooooooool01?ooool03Ol0003oooooooooooo6a/Ko0000
ohB4Q?l820SoHf=Soooooom:BT[oJg=[odY:B_ne]KD00_ooool06?ogmoOo0000ohB4Q?la<C7o61PH
oooooomSHf?oNg]kof]cJon][Jgoooooolk>c_m:BT[oJf][od92@_ne]KGoJf][ohB4Q?mBDU;o0000
onOWiooooooo@T92olK6aP;ooooo00Co@T92of=SHomBDU;oU9BD0_ooool00om:BT[o]KFeooooo`02
ooooo`03odY:B_n][Jgooooo09cooooo00?o:BWoomKFooooool00_ooool02_lY:Ooojn[TojVZ]?o[
k_?okNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7
V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002/ooooo`06ooOgmoo_knooQhNJ
onc]lom]KHKohN7U9?ooool00ooNg]ko0000oa0@4008oa0@4003o`P82?l@413ooooo00Cooooo00?o
S8b<of]cJoooool00_ooool01One]KGoS8b<ooooooooooooe]KF00;ooooo00So0000oooooooooooo
ooooooOgmola<C7ooooooa0@40Oooooo00Gokno_oa0@4?l0003o410@oibLW004ooooo`05of=SHooN
g]koooooooooool@41000_ooool02?l0003ooooooooooooooooo_Kfmoe9BD_oooooo20P81oooool0
1One]KGo410@o`000?l@413oe]KF00Cooooo00Koc/k>od92@_ooooooooooohB4Q?nm_Kd2ooooo`05
olK6a_m2@T;oooooojf]YOmJFUX00oooool2ojFUY@04ooooooo_mnooooooo`0000Cooooo00WoU9BD
of=SHoooooooooooonOWiola<C7oooooolk>c_m:DTX00_ooool01Om2@T;o_Kfmoooooooooooog]kN
00;ooooo00Go0000ooooooooooooBTY:okFe]@03ooooo`03odYBB_ne]KGooooo09cooooo00?o:BWo
omKFooooool00_ooool02_lY:Ooojn[TojVZ]?o[k_?okNodono`mOo`lOKolo?gooGfnOohn?X2ooWi
n`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoo
moOg00?ooooo002/ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U=_ooool00on<S8coJg=[oooo
o`02ooooo`03oiBDU?m[Jf_ooooo00;ooooo00?oQ8B4og=cLomSHf<01?ooool00oo_knooJf][of=S
H`09ooooo`03oa0@4?ogmoOooooo00Cooooo00SoBTY:okfm_Oooooooooooo`000?n4Q8CoFUYJohb<
S0Cooooo00?oU9BDohb<S?mBDU802Oooool00ol0003oooooooooo`04ooooo`03onogkol820Sooooo
00;ooooo00SoFUYJojFUYOooooooa/K6od92@_ooooooU9BDof]cJ`Cooooo00_o61PHomKFe_oooooo
ooooo`000?m[Lf_o:BTYoaPH6?oooooo]KFeog]kN`03ooooo`04ohB4Q?mSHf?o@T92ob4Q8@;ooooo
00?o@T92okfm_Oooool00_ooool00one]KGoBU9:ojf][@02ooooo`03odY:B_ne]KGooooo00;ooooo
00?oDU9BokFe]Oooool0W?ooool00olY:Oooe]Koooooo`02ooooo`0:obTYooo[j^CoZJZdon_^loo]
koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=S
HomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:cooooo00KomoOgono_kon7Qi[ok>gc
ofe]Q_oQhNDfooooo`03ohB4Q?mSHf?ooooo00;ooooo00?o[Jf]of]cJoooool00_ooool00ol0003o
[Jf]ooooo`03ooooo`06ohB4Q?l820So0000o`000?l@413o[Jf]1oooool00oo6a/Koooooooooo`04
ooooo`07oe9BD_nm_Kgoooooooooool0003oW9bLokFe]@04ooooo`06odY:B_l0003o0000o`000?lH
61Sog]kN1oooool00onm_Kgoooooooooo`05ooooo`03ohB4Q?n][Jgooooo00;ooooo00OoHf=Sojf]
[OoNg]ko@T92oooooonUYJGoHf=S00Gooooo00SoHf=SooooooooooooW9bLoe9BD_m:DT[oe]KFoooo
o`;o000000Co8B4Qog]kNoooooooQ8B40_m:BTX01OoFe]Kooooooooooom2@T;oc/k>00?ooooo00?o
inOWohB4Q?n4Q8@00_ooool00omBDU;o]KFeooooo`02ooooo`03od92@_ne]KGooooo09cooooo00?o
:BWoomKFooooool00_ooool02_lY:Ooojn[TojVZ]?o[k_?okNodono`mOo`lOKolo?gooGfnOohn?X2
ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_
knoomoOg00?ooooo002/ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U=oooool01_m[Jf_oQ8B4
oooooooooooo<C4aof=SH`?ooooo00?o0000omKFe_ne]KD00oooool02OogmoOokoO_oooooooooooo
kno_ooooool0003o8B4QolK6aP0;ooooo`08o`000?nm_Kgoooooooooooo6a/KoLg=cokfm_Oo6a/H3
ooooo`09ono_koooooooooooooooooo_knooooooono_kol0003oDU9B00Wooooo00oo_Kfmo`000?ne
]KGoBTY:of]cJoo_knoo@T92ojf][OmSHf?oU9BDooOgmom2@T;o[Jf]of=SHonDU9@00_ooool01Oo_
mnoo0000olK6a_mJFU[o<C4a00;ooooo00KoinOWonogkoooooooooooojFUYOn4Q8@2ooOgm`;ooooo
00?oinOWono_koooool00_ooool02?lY:BWoHf=Soooooooooooo<C4aokFe]OnLW9coDU9B0_ooool0
1_l0003o]KFeooooooooooooJf][ohB4Q9kooooo00?o:BWoomKFooooool00_ooool02_lY:Ooojn[T
ojVZ]?o[k_?okNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOo
k>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002/ooooo`06ooOgmoo_
knooQhNJonc]lom]KHKohN7U>?ooool01On4Q8CooooooooooomBDU;oe]KF00?ooooo00?oLg=coeYJ
F_m[Jf/02Oooool00on4Q8Co_Kfmooooo`0:ooooo`03onOWiomSHf?omoOg00?ooooo00?o_Kfmoe9B
D_nDU9@02Oooool00omSHf?o0000og=cL`09ooooo`09ooOgmomSHf?oHf=Sof=SHooFe]Koooooolk>
c_mBDU;oYJFU00;ooooo00?oc/k>oe9BD_nLW9`01?ooool01?m[Jf_oHf=Sof=SHonm_KdAooooo`03
okfm_OmSHf?ooooo00;ooooo00OoDU9Bof]cJoooooooooooonOWiomSHf?omoOg00;ooooo00?oS8b<
ooooooooool0WOooool00olY:Oooe]Koooooo`02ooooo`0:obTYooo[j^CoZJZdon_^loo]koCoko3e
oo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomkNg_o
U9BDojf][Oo6a/Kog]kNono_koogmoL00oooool00:cooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQ
hNDYooooo`04ob4Q8Ol0003o20P8oeYJFQoooooo00?oc/k>obTY:Oooool06oooool01?oNg]ko61PH
ob4Q8One]KGNooooo`03oeYJoooFe_oooooo00;ooooo00[o:BWoon_Zi?nYZ[Cojnkcong_m?o_l?Go
l?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonD
U9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00Zoooool01oogmoOokno_onOWion7Qi[ok>gcofe]
Q_oQhND0:_ooool00omBDU;o[Jf]ooooo`0Oooooo`03of=SHom2@T;o_Kfm01cooooo00?oinOWo`00
0?ooool0g?ooool2oibLo`03obTYoooWiooooooo00;ooooo00[o:BWoon_Zi?nYZ[Cojnkcong_m?o_
l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]k
NonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00Zoooool01ooWinOog]kNomKFe_n7Qi[ok>gc
ofe]Q_oQhND0:_ooool00omBDU;o]KFeooooo`0Pooooo`03olK6a_oooooooooo01cooooo00?oc/k>
ooOgmoooool0foooool2oibLo`03obTYooo_kooooooo00;ooooo00[o:BWoon_Zi?nYZ[Cojnkcong_
m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=S
og]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00[?ooool01_ogmoOokno_ohN7V_o/kO?o
KFf6on7QiB[ooooo00?oDU9Bojf][Oooool0oooooolOooooo`03okFeoolY:Oooknoo00?ooooo00[o
:BWoon_Zi?nYZ[Cojnkcong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<
c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00[?ooool0
1_ogmoOokno_ohN7V_o/kO?oKFf6on7QiB[ooooo00?oFUYJojf][Oooool0oooooolNooooo`04oeYJ
oooFe_ooFU[oomKFo`?ooooo00[o:BWoon_Zi?nYZ[Cojnkcong_m?o_l?Gol?7foo?cmooem_Won?Sj
0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]ko
kno_ooOgm`03ooooo`00[?ooool01_ogmoOokno_ohN7V_o/kO?oKFf6on7QiBWooooo00?oinOWo`00
0?o6a/H0oooooolNooooo`;oFU[o00?oooooobTYoooFe_l00oooool02_lY:Ooojn[TojVZ]?o[k_?o
kNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mS
Hf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002/ooooo`06ooOgmoo_knooQhNJonc]
lom]KHKohN7Uoooooom9ooooo`03onOWoolY:Ooo:BWo00;o:BWo1?ooool02_lY:Ooojn[TojVZ]?oo
ooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7
V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo002/ooooo`06ooOgmoo_knooQhNJ
onc]lom]KHKohN7UoooooomBooooo`0:obTYooo[j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKi
ooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Ko
g]kNono_koogmoL00oooool00:_ooooo00OomoOgono_kooWinOoQhNJonc]lom]KHKohN7U0?oooooo
D_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_ok
nokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo
001Looooo`03ooOgmoo_knookno_04cokno_00OoinOWomkNg_oFe]KoQhNJonc]lom]KHKohN7U0?oo
ooooD_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[j
o_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?o
oooo001Jooooo`04ooOgmoo_knooinOWomkNgTgoe]KF00Ooc/k>olK6a_nm_KgoQhNJonc]lom]KHKo
hN7U0?ooooooD_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWi
n`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoo
moOg00?ooooo001Jooooo`05ono_kooWinOoe]KFolK6a_nm_Kd0C?ne]KD2ojf][@05ojFUYOn7Qi[o
k>gcofe]Q_oQhND0oooooomBooooo`0:obTYooo[j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKi
ooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Ko
g]kNono_koogmoL00oooool005Wooooo00OomoOgonOWiooFe]Ko_Kfmojf]YOnLW9coU9BD04coS8b<
0_n4Q8@01?n7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Go
l?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonD
U9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00FOooool01oo_knoog]kNolK6a_n][JGoU9BDohB4
Q?mcLg<0Bom[Lf/01om[Jf_oHf=Sof=SHon7Qi[ok>gcofe]Q_oQhND0oooooomBooooo`0:obTYooo[
j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_
Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00Ookno_
omKFe_nm_KgoW9bLohB4Q?m[Jf_oHf=S04goDU9B00GoBU9:ohN7V_o/kO?oKFf6on7Qi@3ooooooe;o
oooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_n
ooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00
FOooool01oo_knooe]KFokFe]OnDU9CoLg=cof=SHom:DTX0C_m2@T801?n7Qi[ok>gcofe]Q_oQhNGo
oooood[ooooo00GoW9coobTYoolY:Ooo:BWoooOoo`03ooooo`0:obTYooo[j^CoZJZdooooooo]koCo
ko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomk
Ng_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00gokno_ok2`/?nVYZKoVi^Koi:B
T_n:RX[oPX:2og]kNomeMGGoL71`ofa/K?mYJFWoIVIV02WoIFEU00?oFUYJoe=CDomADE407?mADE40
1?n7Qi[ok>gcofe]Q_oQhNDkooooo`03onOWionLW9coYJFU0?oooooo3oooool00olY:Oooe]Kooooo
o`02ooooo`0:obTYooo[j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[n
oo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00ooo
ool005Wooooo00?okno_ojf][OoGemL00ooPh>001?oQhN7oh^;Ron;Rh_oRh^8[on?Sh`04omgMgOnA
TI7oZ:RXojb/[0Co[jn_00?o[Zj^ojn_[on_[jl01On_[jl01?n^[Zko[jn_ojn_[on^[Zh2ojn_[`03
ok2`/?na/K7o[Zj^00?o[jn_00So/K6aok2`/?n_[joo/;2`ohN7V_o/kO?oKFf6on7QiC_ooooo00?o
inOWo`000?mSHf<0ooooool?ooooo`03obTYoooFe_oooooo00;ooooo00[o:BWoon_Zi?nYZ[Cooooo
ong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[o
Hf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00FOooool01?o_knooYjNWomcLg?oc
lo<aoo3`l004om[Jf_n?Shooj^[Zooclo1;ooooo00?ooOgmoo[jn_ooool00oooool02Oojn_[ooOgm
ooooooohn?SoS8bNong^l_n5QI_o`<38ooknoP08ooooo`;oc/k>00KoooooomkNg_oFe]Kog]kNoooo
oonm_Kd2ooooo`;oc/k>00?oooooooOgmoo6a/H00oooool01OoWinOoe]KFomKFe_oFe/koe]KF00Co
oooo00Ooc/k>ono_kooNg]koe]KFoooooooNg]kooooo00;og]kN1?ooool00oo6a/Ko_Kfmooooo`02
ooooo`09olK6a_oFe]Koe]KFooooooo>c/kooooooe9BD_ooooooa/K600?ooooo00Soc/k>omKFe_oF
e]Koooooolk>c_ooooooinOWono_kooooooo0oooool00olY:Oooe]Koooooo`02ooooo`0:obTYooo[
j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_
Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00Cokno_
ojJVY_oMgMgolo?c<Oo`l?001?oJf][oShn?onCTi?okno/;ooooo`0:ooCdm?n1PH7o=CDeodI6A_nU
YJGoooooomoOgomIFEWoEeMGoj6QX@;ooooo00WoYZJVoeIFE_mHF5SohN7QonWYjOn7Qi[ok>gcofe]
Q_oQhND02Oooool2o`000008oooooonUYJGo0000ojFUYOnm_Kgo@T92odY:B_ooool2o`000004oooo
oomBDU;o<C4aojFUY@;ooooo00Ko[Jf]o`000?l0003o20P8of=SHoo6a/H3ooooo`0:o`000?nm_Kgo
Jg=[o`000?oWinOo0000of]cJomJFU[o<C4aolK6aP;ooooo01[oYJFUoc4a<Ola<C7oU9BDoooooonU
YJGoBTY:o`000?m[Jf_oNg]ko`000?ooooooBTY:oc4a<Om2@T;oLg=coooooonm_KgoBTY:o`000?lY
:BWo]KFeo`000?ooooooYJFUokFe]Ooooooo0oooool00olY:Oooe]Koooooo`02ooooo`0:obTYooo[
j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_
Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00Cokno_
ojBTY?oRh^;ooooo<OomoOd01?oMgMgoSHf=on3Ph?odm?@3ooShn0WonOWi01CooooooeEEEOn][Jgo
no_koooooomXJ6So`/;2onOWiomUIFGof=SHomoOgomPH63ok>c/okfm_OmYJFWoooooohN7V_o/kO?o
KFf6on7Qi@Wooooo013oQ8B4okfm_OooooooooooobTY:Ooooooo410@oooooooFe]KooooooibLW?o>
c/koe]KFoe9BD_oooooo_Kfm0oooool01Ola<C7ooooooooooolQ8B7oDU9B00?ooooo00[o61PHoooo
ooooooooBTY:oooooom:DT[oNg]kolK6a_oooooog]kN0_ooool05ol0003oooooooooool0003ooooo
o`000?ooooooDU9BoooooomcLg?o]KFeoooooom2@T;oW9bLooooool@413oooooob4Q8OooooooU9BD
omKFe_o6a/KoNg]k0?oooooo1_ooool00olY:Oooe]Koooooo`02ooooo`0:obTYooo[j^CoZJZdoooo
ooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJ
of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00Cokno_ojBTY?oLg=co
l?3`<Oo]kNd01OoIfMWoSXj>on7QhOoalO7om?Cd00?olo?c0oodm?@00ooemOGom?CdooCdm002ooCd
m00DoooooomJFU[o/;2`oo_knoogmoOo@410onk^k_ooooooIFEUokBd]?nn_[koGUiNoooooooalO7o
?CdmooShn?n7Qi[ok>gcofe]Q_oQhND9ooooo`0@ohB4Q?m:BT[oYJFUojFUYOl0003ooooooa0@4?mB
DU;o0000oooooon][JgoBU9:onogkol0003oBTY:obTY:@?ooooo00GoBTY:oiBDU?l@413oooooonOW
i`03ooooo`0:ob4Q8OoooooomoOgo`000?oooooo@T92og]kNolY:BWo61PHohB4Q0;ooooo01Oo0000
oooooooooooo0000oooooolQ8B7oooooodY:B_ooooooQ8B4okFe]OooooooDU9BoiBDU?oooooo20P8
oooooomBDU;oooooohb<S?nm_Kgoe]KFog]kN`3oooooo`Kooooo00?o:BWoomKFooooool00_ooool0
2_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_oknokoo_ko
olc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo001Ioooo
o`04ono_konRXZ;og=cLoo3`l37okNg]00KofMWIohj>S_oLg=cojn_[onk^k_o]kNd2oo3`l0Cokno_
1?o`l?005?omoOgoFEUIojf][Oojn_[ogMgMoc`l??oXj>Soooooof9RH_nLW9coXJ6Qof1PH?oooooo
kNg]ocLg=ooGemOoQhNJonc]lom]KHKohN7U2Oooool04?n4Q8Co8B4Qog=cLomkNg_o0000oooooone
]KGoDU9Bof][Jooooooo0000oaPH6?m[Jf_oNg]koe9BD_ne]KD2ooooo`06ojFUYOl0003oinOWof=S
HolH61So@T920_ooool02?n<S8co0000okFe]Ooooooo0000of=SHonUYJGoe]KF0_mBDU801?o>c/ko
oooooooooonUYJD2oc4a<@0:ojf][Oo6a/Ko0000onOWiol0003og]kNo`000?lY:BWoinOWo`0000;o
@T9200_oQ8B4onogkol0003oe]KFo`000?ne]KGo@T92o`000?ooooooYJFUokFe]@3oooooo`?ooooo
00?o:BWoomKFooooool00_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOoh
n?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkN
g_o_knoomoOg00?ooooo001Iooooo`04ono_konQXJ7oh^;Roooooc7ooOgm00KogMgMohf=SOoIfMWo
inOWon[Zj_oYjNT2on[ZjPSojn_[01ConOWioeMGEonYZJWolO7aooGemOm1@D7oi>CToooooomQHF7o
]KFeol71`OmHF5SoooooonKVi_m:BT[o/K6aohN7V_o/kO?oKFf6on7Qi@Wooooo00GoQ8B4olK6a_oo
ooooooooobTY:@02ooooo`08olK6a_ooooooooooolk>c_oooooomoOgooooooo>c/h3ooooo`05onOW
ioo_mnooooooono_koo>c/h00oooool01OoNg]ko0000oooooooooooo@T9200?ooooo00?oe]KFonOW
ioooool00oooool03_o>c/koa/K6ooooooo_knoog]kNoooooooFe]KoooooobTY:Om[Lf_oooooomKF
e_ooooooa/K60_ooool02OoFe]Koooooolk>c_ooooooJg=[oc4a<OooooooinOWono_k`3oooooo`?o
oooo00?o:BWoomKFooooool00_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGf
nOohn?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6
omkNg_o_knoomoOg00?ooooo001Iooooo`04ono_konRXZ;ogMgMoo?clc7ol?3`00Sof][Johf=SOoE
eMGogmoOonGUiOoTi>Coi^KVonCTi0?oiNGU01Woi^KVonGUiOoVi^KoinOWomgMgOnm_Kgo>3Phoj:R
XOoXj>Ookno_og=cLon>SXko[Zj^oemOGoo=cLgodm?CoeaLG?n`/;3oS8b<ogemOOn_[jooQhNJonc]
lom]KHKohN7U00Wooooo00Ko0000oaPH6?oooooo_Kfmo`000?n][Jd=ooooo`03oibLW?oooooooooo
00Gooooo00CoNg]koooooomSHf?o20P84Oooool00on][Jgoc/k>ooooo`09ooooo`03olk>c_n][Jgo
oooo0?oooooo1Oooool00olY:Oooe]Koooooo`02ooooo`0:obTYooo[j^CoZJZdooooooo]koCoko3e
oo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomkNg_o
U9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00Cokno_oj>SXooKfm_ok^k^<Oo[jn/0
9?oHf=SoSHf=olk>c_oJf][ogmoOomgMgOoNg]kogMgMomcLg?oOgmoog]kNomcLg?oOgmoogMgMomoO
gooKfm_oT92@oeQHF?nd];Gog]kOomoOgooCdm?oIVIVoeYJF_nVYZKoiNGUon?ShonZZZ[oFe]KofIV
I_oBd];ofMWIohN7V_o/kO?oKFf6on7Qi@Wooooo00KoYJFUoibLW?ooooooc/k>ojf][Oo6a/H=oooo
o`03ojFUYOoooooooooo00Oooooo00?oYJFUolk>c_ooool0oooooolTooooo`03obTYoooFe_oooooo
00;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_ko
no_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03oooo
o`00FOooool01?o_knooXZ:Ron7QhOoooolaoo_kn`05omgMgOn<S8cof=SHonCTi?oUiND00_oVi^H2
onGUi@03onOWiooVi^KoiNGU00;oinOW0_oVi^H05?o`l?3on_[jonWYjOoUiNCoi>CTonWYjOodm?Co
l?3`ono_kooVi^KoiNGUonk^k_obl_;omOGeonWYjOoWinOoQhNJonc]lom]KHKohN7Uoooooom;oooo
o`;o]KGo00?o:BWoonOWooooool00_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?g
ooGfnOohn?X2ooWin`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgo
a/K6omkNg_o_knoomoOg00?ooooo001Iooooo`04ono_konTY:Cog]kNooShn37om?Cd00Sof][Joh^;
Roo/k>con_[jooWinOohn?Son_[jooShn0;onOWi00Kon_[jooWinOoinOWon_[jooWinOohn?P3oo[j
nP;onOWi00?on?Shoo[jn_ojn_X00_oinOT02_ojn_[onOWioo[jn_ojn_[onOWiooShn?n7Qi[ok>gc
ofe]Q_oQhNGooooood_ooooo0_nLW?l00olY:Oooknooooooo`02ooooo`0:obTYooo[j^CoZJZdoooo
ooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJ
of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00?okno_ojRXZ?oGemL0
<_oDe=@00ooFe]KoW9bLoiNGU`05oiRHV0;oVIVI0onHV9P00onIVIWoV9RHoiVIV@03oiRHV003oiVI
VOnHV9SoV9RH00;oV9RH0_nIVIT3oiRHV007oiVIVOnHV9SoVIVIohN7V_o/kO?oKFf6on7Qi@3ooooo
od[ooooo00GoW9coobTYoomJF_oo:BWoono_o`03ooooo`0:obTYooo[j^CoZJZdooooooo]koCoko3e
oo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cGofi_Qoo/kO?oQhNJof=SHomkNg_o
U9BDojf][Oo6a/Kog]kNono_koogmoL00oooool005Wooooo00?okno_ojn_[oooool0D_ooool01?n7
Qi[ok>gcofe]Q_oQhNGooooooe;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7foo?cmooe
m_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6
a_oNg]kokno_ooOgm`03ooooo`00FOooool00oo_knoo[jn_ooooo`1Booooo`04ohN7V_o/kO?oKFf6
on7QiOooooooD_ooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWi
n`0?oo[jo_oknokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoo
moOg00?ooooo001Iooooo`03ono_kon`/;3ooooo053ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQ
hNGooooooe;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/0
3oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOg
m`03ooooo`001?ooool00oo_mnookno_ono_k`1Aono_k`03onOWiooFe]Ko/;2`057ooooo00KomoOg
ono_kon7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7f
oo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co
[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000oooool00oo_knooe]KFolK6aP1Cokfm_@03ojf][On`
/;3ooooo053ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo00[o:BWoon_Zi?nY
Z[Coooooong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]
lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01?o_mnooe]KF
ojf][On<S8aBohB4Q003og]kNomcLg?o/;2`057ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNGo
oooooe;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03ooj
n_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03
ooooo`000_ooool01?o_knooa/K6ohb<S?mSHf=Coe9BDP03odY:B_n`/;3ooooo053ooooo00KomoOg
ono_kon7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo00[o:BWoon_Zi?nYZ[Coooooong_m?o_l?Gol?7f
oo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7onc]lon7Qi[oHf=Sog]kNonDU9Co
[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01?o_knoo_KfmohB4Q?mBDU9Cod92@P03oc4a
<On`/;3ooooo053ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo00[o:BWoon_Z
i?nYZ[Coooooong_m?o_l?Gol?7foo?cmooem_Won?Sj0_oinO/03oojn_kono_nooknooo<c=OoKVn7
onc]lon7Qi[oHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool00oo_knoo
@W^Uo`PaBP0=o`PaBP04o`PQ>OlHBV_o>F^<o`PQ>DCo235:00?o/;2`ooooooooool0Coooool01_og
moOokno_ohN7V_o/kO?oKFf6on7QiOooooooB_ooool01?ne]OooFU[ooeYJoomJF_l4ooooo`0:obTY
ooo[j^CoZJZdooooooo]koCoko3eoo3am_ocloOomOKiooShnP;onOWk00oon_[noo_ko_ono_ooc<cG
ofi_Qoo/kO?oQhNJof=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Ko
kno_odZDa_m2NjGo@W^UodZDa_m2NjD:odZDaP;o649J00CoLjG6odZDa_m2NjGo@W^U2Om:U<H00om2
NjGoBYC6odZDaP0CodZDaP03od9kYOm:U<KoBYC601koBYC60_m2NjD00on`/;3oooooooooo`1?oooo
o`06ooOgmoo_knooQhNJonc]lom]KHKohN7Uoooooom:ooooo`05omKFoone]Ooo]KGoobTYoooFe_l0
0oooool02_lY:Ooojn[TojVZ]?ooooookNodono`mOo`lOKolo?gooGfnOohn?X2ooWin`0?oo[jo_ok
nokoo_koolc<eom^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo
0002ooooo`05ono_kom:U<Ko>G>LoaQ:Jom:U<H02olYNkD00olQHiCo235:od9kY@14obUk]@03obU[
U?n`/;3ooooo053ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNDRooooo`05ohb<S?nDU9Cooooo
ohb<S?o_knl00on4Q8@01?n<S8coYJFUohB4Q?oFe]Kooooooaoooooo00?o:BWoomKFooooool00_oo
ool02_lY:Ooojn[TojVZ]?ooooooj^caong^loo^koColO7eoo?dmooem_P2ooKfn@0?ooOgo?ohnOco
no_nolg>f?m^KhOok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002
ooooo`06ono_kom:U<Ko@W^Uo`0H<OlY:BWoFUYJ2_m:DU800omBFV?oDU9BodYBDP14odYBDP03odY:
B_n`/;3ooooo053ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNDRooooo`05obTY:Om2@T;og]kN
o`000?ooool00on4Q8@01?nDU9Co0000og=cLooFe]Kooooooaoooooo00?o:BWoomKFooooool00_oo
ool01_lY:Ooojn[TojVZ]?ooooooUiRVojJW]P;oYJJe00?oYJJdojJW]OnVYkD00_nWZ;H03_nXZ[Oo
X::/olG4aOm_KhWok>gcohN7V_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg0oooool000;o
oooo00Ookno_odZDa_m2NjGo01Paof=SHooooooog^ON00?og^OW00?og^ONomkWiooNinL02?oNinL2
omkWgP04omkWiooNimkog^ONomkWi`;og^ON00Gog^OWomkWg_oNimkog^OWomkWgP02omkWi`04omkW
g_oNinOog^OWomkWgP;og^OW00Cog^ONomkWiooNinOog^ON0_oNinL01OoNimkog^OWomkWg_oNimko
g^OW00;og^ON00Cog^OWomkWg_oNimkog^OW0_oNimh01OoNinOog^ONomkWg_oNinOog^ON00;og^OW
00Cog^ONomkWiooNinOog^ON0_oNinL01?oNimkog^OWomkWiooNimh2omkWi`09omkWg_oNinOog^ON
omkWg_oNinOog^ONomKNg_o>c/ko/;2`057ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNDRoooo
o`0:oe9BD_m[Jf_oW9bLohb<S?oooooo:BTYoc4a<OmSHf?oooooob4Q8Ooooooo8Oooool00olY:Ooo
e]Koooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onSYk_oVingogMkWom_LiOoCe>7o
cLkLolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoo
moOg00?ooooo0002ooooo`07ono_kom:U<Ko@W^Uo`0H<OmBFV?og^ONokfm_@1?okg6_@03okfm_On]
[Jgo/;2`057ooooo00KomoOgono_kon7Qi[ok>gcofe]Q_oQhNDRooooo`03odYBB_mBDU;oLg=c00Ko
oooo00?o61PHooooooooool00oooool01OmSHf?oNg]koooooomcLg?oHf=S0?oooooo5oooool00olY
:Oooe]Koooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onSYk_oVingogMkWom_LiOoC
e>7ocLkLolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_
knoomoOg00?ooooo0002ooooo`07ono_kom:U<Ko@W^Uo`0H<OmBFV?og^OWokg6_@02okg6aP;o_LJm
Bonma/H00onm_Kgo[Jf]ok2`/01Aooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U:Oooool00ooN
g]ko20P8o`000005ooooo`05of=SHol0003oe]KFo`000?mkNg/0oooooolGooooo`03obTYoooFe_oo
oooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3oj>W^onKWkOoMg^OofmcUom?DhOo=c]co
bL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL0
0oooool000;ooooo00Ookno_odZDa_m2NjGo01Paoe9JHooNinOo_LJm00?o_LK600?o_LJmokg6a_nm
a/H01?nma/H2okg6_D?o_LK600?o_Kfmojf][On`/;00DOooool01_ogmoOokno_ohN7V_o/kO?oKFf6
on7QiC7ooooo00Soc/k>o`000?o_knoo0000onogkoooooooW9bLojFUYOoooooo5?ooool00olY:Ooo
e]Koooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onSYk_oVingogMkWom_LiOoCe>7o
cLkLolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoo
moOg00?ooooo0002ooooo`07ono_kom:U<Ko@W^Uo`0H<OmBFV?og^OWokg6_@0:okg6aP;o_LJm@onm
a/H00onm_Kgo[Jf]ok2`/00Zooooo`03omkNg_oooooooooo00;ooooo00?og]kNono_koooool07ooo
ool01_ogmoOokno_ohN7V_o/kO?oKFf6on7QiB;ooooo00Co:BTYod92@_m:BT[o<C4a1?lY:BT00om2
@T;oBTY:ohB4Q004ooooo`08okFe]Ol0003oinOWo`000?oWinOoooooo`000?mSHf?ooooooaCooooo
00?o:BWoomKFooooool00_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oXjNkoi^O]omgNiooK
g>GodmCQolg>g?o9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oN
g]kokno_ooOgm`03ooooo`000_ooool01oo_knooBYC6od9kYOl0637oDUYSomkWionma[d0Conma/H0
0onm_Kgo[Jf]ok2`/01Aooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U8_ooool01On<S8co0000
ojf][Ooooooog]kN00;oe]KF00Cog]kNooOgmol0003o20P81?ooool02?l820So0000oaPH6?mcLg?o
ooooo`000?l@413oBTY:oooooolDooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Co
ooooono_loo[jo3oj>W^onKWkOoMg^OofmcUom?DhOo=c]cobL[IooKfnOn;Ri[oM7B=onc]lon7Qi[o
a/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Ookno_odZDa_m2
NjGo01Paoe9JHooNinOo_LJm02?o_LK60_nma[dSokg6aP;o_LJm1Onma/H00onm_Kgo[Jf]ok2`/01A
ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U8oooool00on][Jgo0000onogk`05ooooo`03o`00
0?lH61Sooooo00Sooooo00?oLg=coa0@4?o_mnl0oooooolDooooo`03obTYoooFe_oooooo00;ooooo
01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3oj>W^onKWkOoMg^OofmcUom?DhOo=c]cobL[IooKfnOn;
Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;o
oooo00Ookno_odZDa_m2NjGo01Paoe9JHooNinOo_LJm02Ko_LK600?o_LJmokg6a_nma/H05onma/H0
0onma[go_LK6okg6aP03okg6aP;o_LJm00?oa/k6okg6a_nma/H01?nma/H00onm_Kgo[Jf]ok2`/01A
ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U9?ooool00onLW9co0000omKFeP04ooooo`03o`00
0?lH61Sooooo00Wooooo00?o20P8omkNg_ooool01oooool00om[Lf_o61PHooooo`0Cooooo`03okFe
]Ol0003ooooo0?;ooooo00?o:BWoomKFooooool00_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[
l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]k
NonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01oo_knooBYC6od9kYOl0637oDUYS
omkWionma[d08Onma/H01?nma[goa/k6okg>e_nma/H2okg6_AWo_LK60_nma[d5okg6aP03okg6_Oo6
c/ko_LkF00Go_LK600?o_Kfmojf][On`/;00DOooool01_ogmoOokno_ohN7V_o/kO?oKFf6on7QiBGo
oooo00?oU9BDo`000?oWinL06?ooool02OoFe]Ko0000onOWiooWinOo[Jf]omkNg_o_knoo]KFeolK6
aP04ooooo`03olk>c_oooooooooo00?ooooo0_nm_Kd00onUYJGoooooooooo`02o`000?;ooooo00?o
:BWoomKFooooool00_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYj>koinK]omgNiooKg>Go
dmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]ko
kno_ooOgm`03ooooo`000_ooool01oo_knooBYC6od9kYOl0637oDUYSomkWionma[d0B?nma/H00onm
a[go_LK6okg6aP04okg6aP03okfm_On][Jgo/;2`02[ooooo00?og]kNooooooooool00_ooool00ooN
g]kokno_ooooo`0Oooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U9_ooool00onLW9co0000omkN
gP0Gooooo`09ob4Q8Ola<C7oooooomkNg_l0003o:BTYof]cJol0003o]KFe00?ooooo00?oe]KFob4Q
8Oooool01?ooool00one]KGo0000oaPH6002ooooo`03okfm_Ol0003o_Kfm0?7ooooo00?o:BWoomKF
ooooool00_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYj>koinK]omgNiooKg>GodmCPolg>
foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOg
m`03ooooo`000_ooool01oo_knooBYC6ocUcW?l0637oDUYSonO_koo6c/H0Coo>c/h00oo6a/Ko]Kfe
ok2`/00Yooooo`03omkNg_lH61SoQ8B400;ooooo00CoS8b<ob4Q8OlQ8B7oc/k>7oooool01_ogmoOo
kno_ohN7V_o/kO?oKFf6on7QiBOooooo00?o[Jf]o`000?ne]KD01_ooool00om2@T;o20P8oa0@4006
oa0@40;o20P81Oooool02?l0003oYJFUoooooooooooo61PHod92@_n<S8co00000oooool01?mkNg_o
20P8o`000?lH61P2ooooo`06onOWiol0003oFUYJo`000?l@413okoO_0_ooool00ol0003oJg=[oooo
o`3`ooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNS^onOV
kOoMg^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf]
[Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m:U<Ko235:od9BD_ne_KeAoibL
W003oiBDU?n`/;3ooooo02[ooooo00CoS8b<ohB4Q?oooooo00000_ooool00olH61Soooooooooo`0M
ooooo`06ooOgmoo_knooQhNJonc]lom]KHKohN7U:?ooool00ol0003o@T92ooooo`0Eooooo`08o`00
0?nUYJGoooooooooool@413oBTY:oiBDU?l00004ooooo`03omKFe_lY:BWooooo00;ooooo00Gokno_
oe9BD_oooooo0000ohb<S003ooooo`03o`000?m[Jf_ooooo0?3ooooo00?o:BWoomKFooooool00_oo
ool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Ki
oh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00
0_ooool01oo_knoo>F^<od9kYOlaJiCo:CTiog]kNom[Lf/0Com[Jf/2of=SH`03ok2`/?oooooooooo
02Oooooo00Wo[Jf]oa0@4?lH61So8B4Qooooool@413oooooomkNg_lY:BT07oooool01_ogmoOokno_
ohN7V_o/kO?oKFf6on7QiBOooooo00?o0000of=SHoooool05_ooool01?mkNg_o0000oooooonm_Kd3
o`000003ojFUYOoooooooooo00?ooooo00?oe]KFooooooooool00_ooool01?mkNg_oQ8B4o`000?n4
Q8@2ooooo`03of]cJol0003ooooo00?ooooo00?okoO_ooooooooool0joooool00olY:Oooe]Kooooo
o`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:
fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?o
oooo0002ooooo`07ono_kol@BW_o01Pao`0H<OlY>CWoQ8B4ojFUY@04oibLW0KoYJFU4On][Jd00on]
[JGoYJFUoibLW00aoibLW003oiBDU?n<S8co/;2`02Wooooo00Wo0000oooooooooooo:BTYooooool@
413oooooonOWiolY:BT08Oooool01On<S9kokNkbohF5Voo0`<Soo_kn02Gooooo00?o0000oe9BD_oo
ool05oooool00ooWinOo0000ohB4Q00@ooooo`07og=cLol0003oLg=cooooooo_knoo0000od92@P02
ooooo`;o000000?oDU9Booooooooool0joooool00olY:Oooe]Koooooo`02ooooo`0KobTYooo[j^Co
ZJZdooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?o
QhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`0:ono_kom:
U<Ko>F^<o`PQ>Ola@T[oJf][ojFUYOn][JGoYJFUojf]Y@;o[Jf]00GoS8b<of=SHonUYJGoS8b<oeYJ
FP0Bof=SH`03og=cLon][JgoYJFU037oYJFU00?oU9BDok2`/?ooool0:?ooool02OlH61SooooookFe
]Ola<C7ooooooaPH6?oooooo]KFeod92@P0Qooooo`04ohN7V_o/kO?oKFf6on7QiBGooooo00?o0000
odYBB_ooool00_ooool00one]KGo@T92ooooo`0Dooooo`03olK6a_m[Jf_ooooo013ooooo00GoQ8B4
olk>c_ooooooc/k>og=cL`03ooooo`03ono_komJFU[ooooo0>gooooo00?o:BWoomKFooooool00_oo
ool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Ki
oh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00
0_ooool04?o_knooBYC6od9kYOl88CWo<D9:of]cJon][JGo[Jf]okFe]On][JgoU9BDoeYJF_mBDU;o
FUYJojFUYOnLW9`BohB4Q003of]cJomSHf?o[Jf]037o[Jf]00?oYJFUoibLW?n`/;00:Oooool00ooW
inOo61PHoc4a<@02ooooo`03omkNg_lH61So<C4a00[ooooo00?o[Jf]ooooooooool05Oooool01?n7
Qi[ok>gcofe]Q_oQhNDTooooo`03o`000?n4Q8Cooooo00?ooooo00?oQ8B4o`000?ooool01_ooool0
1_oWinOo20P8o`000?l0003o20P8ono_kbGooooo00?o61PHooooooooool0joooool00olY:Oooe]Ko
ooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkK
olW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg
00?ooooo0002ooooo`0Bono_kom:U<Ko@W^Uo`PQ>Ola@T[oJg=[ojf]YOne]KGoQ8B4of=SHom2@T;o
W9bLoiBDU?mBDU;oYJFUoiBDU?o6a/Koe]kF3oo>e]H01?oWknOoU9BDoe9BD_n][Jdaojf]Y@03ojFU
YOnLW9co/;2`03[ooooo00?o@T92ojf][Oooool05_ooool01?n7Qi[ok>gcofe]Q_oQhNDRooooo`05
omkNg_l0003o0000oiBDU?mcLg<00_m[Lf/00omkNg_o61PHo`000009ooooo`03o`000?lH61Sooooo
02?ooooo00CoinOWoc4a<OmkNg_oHf=SkOooool00olY:Oooe]Koooooo`02ooooo`0KobTYooo[j^Co
ZJZdooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?o
QhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`0Bono_kom:
U<Ko@W^Uo`PQ>Ola@T[oJg=[oibLW?m[Jf_oHf=SohB4Q?o6a/Kog]kNojf][Om:DT[oYJFUoiBDU?ne
_KGoa/K63onma/H01?o>e]KoS8b<oeYJF_n][Jdaojf]Y@03ojFUYOnLW9co/;2`03Wooooo00GoBU9:
ojf][OoooooooooooaPH6002o`000006og=cLoooooooQ8B4o`P82?lQ8B7okno_0_ooool01Om[Jf_o
U9BDooooooo6a/KoDU9B00Kooooo00CoQhNJonc]lom]KHKohN7U8_ooool01?oNg]ko[Jf]okfm_OnL
W9`3oiBDU003oibLW?n][Jgo_Kfm00Wooooo00?o20P8ob4Q8Oooool09?ooool00oo_mnooQ8B4oooo
o`3]ooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNS^onOV
kOoMg^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf]
[Oo6a/Kog]kNono_koogmoL00oooool000;ooooo01Cokno_odZDa_m2NjGo224ioc52B_m[Lf_oW9bL
oiBDU?ne]KGoa/K6olkFe_oFe/koYJFUodYBB_nUYJGoU9BDokFm]Oo6a/Ko_LK6olK6aPgo_LK600Co
c]KFohb<S?mJFU[o[Jf]<On][JD00onUYJGoW9bLok2`/00Wooooo`03olK6a_m2@T;oBU9:00SoBU9:
00?oBTY:og=cLoooool01?ooool00om2@T;oc/k>ooooo`02ooooo`08oe9BD_oNg]kooooooooooonU
YJGoooooonOWiolQ8B43ooooo`03oeYJF_o6a/Ko61PH00Oooooo00CoQhNJonc]lom]KHKohN7U=Ooo
ool00olH61So8B4Qooooo`3ooooooaGooooo00?oFU[oomKFooooool00_ooool06olY:Ooojn[TojVZ
]?ooooooknocon_[l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7
V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool02?o_knooBYC6
od9kYOl88CWo<D9:of]cJon][JGoYJFU0_nDU9@02?nUYJGoc/k>ojFUYOm:DT[oYJFUoiBDU?ne_Kgo
c/k>3oo6a/H01?oFg]KoS8b<oe9BD_n][Jdaojf]Y@03ojFUYOnLW9co/;2`02Oooooo00?oinOWojf]
[One]KD02One]KD00oo6a/Koooooooooo`03ooooo`03od92@_o6a/Kooooo00;ooooo00So@T92olK6
a_oooooooooooeYJF_ogmoOo[JfUodY:BPCooooo00?oHf=Sof][Joooool01_ooool01?n7Qi[ok>gc
ofe]Q_oQhNDUooooo`04okFe]OmJFU[oinOWodY:BP[ooooo00Cokno_odY:B_l0003o8B4QoooooolE
ooooo`03omKFoolY:Oooknoo00?ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNS^onOVkOoM
g^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6
a/Kog]kNono_koogmoL00oooool000;ooooo00Ookno_odZDa_m2NjGo224ioc52B_m[Lf_oYJFU00;o
[Jf]00WoYJFUoiBDU?nLW9coS8b<oe9BD_nUYJGoW9bLojf][One_Kd03one_KD01?o6a/KoU9BDoeYJ
F_n][Jdaojf]Y@03ojFUYOnLW9co/;2`03Wooooo00Oo8B4QomKFe_ooooooooooolk>c_mSHf?oa/K6
00;ooooo00?o0000oc4a<Om:BTX01?ooool01?nLW9co61PHobTY:Ol00006ooooo`04ohN7V_o/kO?o
KFf6on7QiBCooooo00Koc/k>od92@_n4Q8CoHf=So`000?oNg]h:ooooo`03olK6a_l820So<C4a0?oo
oooo5?ooool01?oFe_ooFU[oobTYoooWiol3ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onWX
k_oWi^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBD
U?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`07ono_kom:U<Ko@W^Uo`PQ>Ola@T[oJg=[
ojf][@04okFe]@;o[Jf]00?oU9BDojf][OnUYJD00_nLW9`00onDU9CoW9bLoibLW00=oibLW003ojFU
YOnDU9Co]KFe037o]KFe00?o[Jf]ojFUYOn`/;00>Oooool01oo>c/ko@T92ooooooooooooNg]ko`00
0?oFe]H00_ooool00olQ8B7oooooooooo`04ooooo`08ohb<S?nDU9CoU9BDoibLW?mBDU;o:BTYoc4a
<Oo>c/h2ooooo`04ohN7V_o/kO?oKFf6on7QiBGooooo00CoYJFUodY:B_oNg]ko<C4aoooooolQoooo
o`05onOWoomJF_oooooooeYJoooFe_l00oooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYj>ko
inK]omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co
[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01Oo_knooBYC6od9kYOl88CWo:CTi05;oHf=S
00?oFUYJok2`/?ooool0>Oooool01_nm_KgoHf=SooooooooooooBU9:omKFeP;ooooo00Co0000oaPH
6?l820SoLg=c2?ooool00ol@413oa/K6ooooo`02ooooo`04ohN7V_o/kO?oKFf6on7QiOooooooBOoo
ool00ooWiooo:BWoobTYo`02obTYo`0OonOWoooooooooooooooooolY:Ooojn[TojVZ]?ooooooknoc
on_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=S
og]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo
<D9:oiBDU53oQ8B400?oNg]kog=cLon`/;00:oooool01OogmoOo@T92of=SHom:DT[o[Jf]01oooooo
00SoBTY:omKFe_ooooooooooohN7V_o/kO?oKFf6on7QiOooooooB_ooool2ono_o`03onOWooogoooo
oooo00?ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_o
bL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL0
0oooool000;ooooo00Kokno_odZDa_m2NjGo01Paoe9JHoo_moL2omKFcP?oc]KF00?oe]KFomKFc_o>
e]H08oo>e]H00ooFe/koc]KFomKFcP0RolkFeP03olk>c_nma[go/;2`02cooooo00Co]KFeo`000?nD
U9Cog]kN7Oooool01?mSHf?oe]KFoeYJF_nDU9@2ooooo`04ohN7V_o/kO?oKFf6on7QiOooooooD_oo
ool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Ki
oh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`00
0_ooool02?o_knooBYC6od9kYOl0637oDUYSomkNg_nma[Go]Lk>9onma[D00oo>e/Ko_LkFokg6]@0T
okg6]@03okFm]On][Jgo/;2`02gooooo00?o<C4aooooooooool07_ooool00olQ8B7oU9BDooooo`02
ooooo`04ohN7V_o/kO?oKFf6on7QiOooooooD_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oY
jNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonD
U9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool02?o_knooBYC6od9kYOl0637oHf=Sooo_
oooNa^ooe]Ko:?oNa^l00ooFc^oog/K_omk6k`0Tomk6k`03olJmg_n`/;3ooooo02cooooo00?o<C4a
onOWioooool08oooool01?n7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Cooooo
ono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6
of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Gokno_odZDa_m2NjGo
224iocTiN`1Coi@iaP03ok2`/?oooooooooo02Wooooo00Cog]kNof=SHolH61SokoO_9?ooool01?n7
Qi[ok>gcofe]Q_oQhNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoM
g^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6
a/Kog]kNono_koogmoL00oooool000;ooooo00Ookno_odZDa_m2NjGo224iocT0Q?oFc^oooooo04oo
moo_00?okno_omkWg_n`/;00;?ooool00ooNg]ko0000ono_k`0Tooooo`04ohN7V_o/kO?oKFf6on7Q
iOooooooD_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>
foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOg
m`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00
;Oooool00oo_knooooooooooo`0Sooooo`04ohN7V_o/kO?oKFf6on7QiOooooooD_ooool06olY:Ooo
jn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8go
k>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_
knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00Doooool01?n7Qi[ok>gcofe]
Q_oQhNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?D
goo=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_
koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo
/;2`05?ooooo00CoQhNJonc]lom]KHKohN7UoooooomBooooo`0KobTYooo[j^CoZJZdooooooo_ko?o
jn_`onWYk_oWingogMkWom_LiOoCe=oocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?o
Ng]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli
08Coe/k_D?ooool00oogmoOoinOWok2`/01Cooooo`04ohN7V_o/kO?oKFf6on7QiOooooooD_ooool0
6olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;
V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_oo
ool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00Doooool01?n7Qi[o
k>gcofe]Q_oQhNGooooood[ooooo00GoW9coobTYoolY:Ooo:BWoono_o`03ooooo`0KobTYooo[j^Co
ZJZdooooooo_ko?ojn_`onWYk_oWingogMkWom_LiOoCe=oocLkKolW:fOofm_WoRh^JogAdSOo/kO?o
QhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:
U<Ko@W^Uo`PQ>Oli08Coe/k_D?ooool00oogmoOoinOWok2`/01Cooooo`04ohN7V_o/kO?oKFf6on7Q
iCKooooo00?oe]KFof=SHomcLg<0oooooolDooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Z
i?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]
lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`05?ooooo00CoQhNJonc]lom]KHKo
hN7U=oooool00ol0003oS8b<ooooo`3ooooooa?ooooo00?o:BWoomKFooooool00_ooool06olY:Ooo
jn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8go
k>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_
knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00Doooool01?n7Qi[ok>gcofe]
Q_oQhND9ooooo`;oU9BD00Soooooolk>c_nUYJGoa/K6oooooon4Q8Cog]kNooooo`;oU9BD00?ooooo
omKFe_n4Q8@00oooool01Oo>c/koYJFUojFUYOnLW9co[Jf]00Cooooo00OoW9bLomKFe_nm_KgoW9bL
ono_kon][Jgokno_00;o]KFe0oooool02_n][Jgo[JfUoiBDU?nUYJGoe]KFolK6a_o>c/koHf=Soooo
oon<S8`3ooooo`?oYJFU00GooooooiBDU?ooooooa/K6omKFeP3oooooo`Sooooo00?o:BWoomKFoooo
ool00_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9
b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03
ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00Dooo
ool01?n7Qi[ok>gcofe]Q_oQhND9ooooo`0@o`000?lH61SoooooolK6a_l0003oa/K6oiBDU?n4Q8Co
DU9BooOgmol@413o8B4QooOgmomJFU[oNg]kohB4Q0;ooooo00Koa/K6o`000?lH61So@T92of][JonD
U9@3ooooo`0:o`000?oNg]koU9BDo`000?oooooo0000of][Jon4Q8CoHf=Sojf][@;ooooo01GoQ8B4
o`000?n<S8co0000onOWiol0003o_Kfmof=SHolH61SoQ8B4odYBB_ooooooU9BDog]kNol@413oBU9:
ojf][Ol0003ooooookfm_Oo>c/h0ooooool8ooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Z
i?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]
lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`05?ooooo00CoQhNJonc]lom]KHKo
hN7U2Oooool04?n4Q8Coa/K6oooooooooooo:BTYoooooolH61Sog]kNolK6a_ooooooU9BDomKFe_oN
g]ko@T92ooooooo>c/h3ooooo`05oc4a<Oooooookno_ob4Q8OmkNg/00oooool02_lH61Sooooooooo
oom:BT[oooooodYBB_n4Q8CoU9BDomkNg_oWinL3ooooo`0Aoc4a<Ooooooo<C4aoooooolH61Sooooo
od92@_o>c/kooooooa0@4?oooooo8B4Qoooooon<S8coe]KFokFe]OmkNg/0ooooool;ooooo`03obTY
oooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3oj>S_onKVkOoMgNKofm_Uom?D
h?o=c]cobL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_
koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo
/;2`05?ooooo00CoQhNJonc]lom]KHKohN7U2Oooool04?n4Q8Co8B4Qof][Jom[Lf_o0000oooooolH
61SoJf][o`000?o_mnoo[Jf]ob4Q8OoNg]ko20P8oeYJF_l@4103ooooo`05od92@_n4Q8Co410@oooo
ooo6a/H00oooool02_lH61Soooooooooool0003ooooood92@_mkNg_o@T92oaPH6?mcLg<3ooooo`0A
ob4Q8Ooooooo0000onOWiolH61SoooooodY:B_mSHf?oooooo`P82?oooooo@T92oooooon4Q8Co_Kfm
olk>c_mkNg/0ooooool;ooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_
loo[jo3oj>W^onKWkOoMg^OofmcUom?DhOo=c]cobL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=S
HomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224i
ocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`03gooooo0_n4Q8@Dooooo`04ohN7V_o/kO?oKFf6on7Q
i@Wooooo013oQ8B4odY:B_nUYJGo[Jf]o`000?oooooog]kNoc4a<On4Q8Coooooo`000?m:BT[oJg=[
ohb<S?m2@T;og]kN0_ooool01_nDU9Co0000oooooom[Jf_o0000odY:BP;ooooo00_oNg]ko`000?n]
[JgooooooaPH6?mSHf?o_KfmooOgmom:BT[oFUYJono_k`02ooooo`;o<C4a01?oU9BDo`000?m[Jf_o
YJFUonOWiol0003oLg=coaPH6?n][JGoinOWo`000?oFe]Ko0000okfm_OlH61So0000oooooon<S8co
[Jf]0?oooooo2?ooool00olY:Oooe]Koooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`
onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]k
oiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Co
e/k_D?ooool00oogmoOoinOWok2`/00Cooooo`03ooOgmooooooooooo02Oooooo00?o@T92o`P82?oo
ool04oooool01?n7Qi[ok>gcofe]Q_oQhND9ooooo`05ohB4Q?nm_KgooooooooooolY:BT00_ooool0
0oo_mnooooooooooo`04ooooo`03onogkooooooooooo00[ooooo00Co0000oooooooooooo@T924Ooo
ool00oo_mnooooooooooo`04ooooo`03ohB4Q?m:BT[ooooo0?oooooo2_ooool00olY:Oooe]Kooooo
o`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:
fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?o
oooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_D?ooool00oogmoOoinOWok2`/00;oooo
o`0AonOWiol0003o0000oooooomkNg_o0000oibLW?oWinOo410@of]cJooooooo0000oa0@4?oooooo
@T92oa0@4?oFe/h00_ooool01_m[Jf_o0000o`000?l0003oDU9Bono_k`?ooooo00WoQ8B4oaPH6?lY
:BWo[Jf]o`000?m[Lf_oHf=SoaPH6?oFe]H00_ooool06?oNg]ko61PHoa0@4?n][JgoooooomkNg_l8
20SoNg]kof=SHoooooooHf=SolK6a_l0003o@T92onOWioooooooU9BDoa0@4?n4Q8CoS8b<omKFe_m[
Jf_oQ8B4olk>cPWooooo00CoQhNJonc]lom]KHKohN7U2Oooool2o`000004oooooonUYJGo0000ohb<
S0gooooo00?oHf=Sooooooooool01Oooool01?n][Jgooooood92@_l@4108ooooo`03ono_kom[Jf_o
oooo00gooooo00?og]kNolk>c_ooool0ooooool:ooooo`03obTYoooFe_oooooo00;ooooo01_o:BWo
on_Zi?nYZ[Coooooono_loo[jo3ojNS^onOVkOoMg^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=
onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Ko
kno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`00cooooo00coJf][okfm_Ooo
oooooooooaPH6?oooooo410@oooooonm_Kgoooooof=SHooWinL2oibLW003oooooone]KGooooo00;o
oooo00Go<C4aonOWioooooooU9BDof=SH`02ooooo`0:omKFe_lQ8B7ooooooaPH6?oooooo@T92ohB4
Q?n][JgooooookFe]@;ooooo01Go20P8oooooooooooo0000ooooool820Sooooood92@_ooooooLg=c
okFe]Oo6a/KoQ8B4oooooolQ8B7oooooo`P82?oooooo20P8ooooool820P03?ooool01?n7Qi[ok>gc
ofe]Q_oQhND9ooooo`04omKFe_oFe/koooooonOWi`;og]kN3Oooool00oo>c/koooooooooo`07oooo
o`03omKFe_o_knoooooo00Sooooo00?oe]KFooooooooool0oooooolIooooo`03oeYJoooFe_oooooo
00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNS^onOVkOoMg^OofmcUom?Dh?o=c]_obL[I
ooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00ooo
ool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`00cooooo
013oJf][ohb<S?oWinOoinOWoa0@4?oooooo0000od92@_l820Soooooof=SHooWinOoa/K6o`000?la
<C7oQ8B40oooool01OlQ8B7oooooodYBB_mSHf?omoOg00?ooooo00Wo@T92oooooolH61SoooooobTY
:OnDU9Co20P8oc4a<On<S8`00_ooool05Ol820Soooooooooool0003ooooooc4a<OooooooFUYJoooo
oonLW9coc/k>omkNg_n4Q8Coooooob4Q8Ooooooo8B4QoooooolH61SoooooobTY:@0<ooooo`04ohN7
V_o/kO?oKFf6on7QiOooooooBoooool2oibLo`03obTYooo_kooooooo00;ooooo01_o:BWoon_Zi?nY
Z[Coooooono_loo[jo3ojNS^onOVkOoMg^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7
Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZD
a_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`00cooooo00_oNg]koa0@4?m2@T;o@T92
o`P82?ooooooNg]kohB4Q?m:BT[okno_oe9BDP03of]cJ`0:of=SHonDU9CooooooooooonLW9co0000
ojf][Om[Jf_o8B4QohB4Q0;ooooo00OoNg]ko`000?oooooo20P8ohb<S?mcLg?o_Kfm00;oHf=S01_o
W9bLooooooooooooQ8B4of=SHomkNg_oHf=SooOgmol0003omoOgo`000?oNg]ko:BTYoe9BD_m:BT[o
410@og]kNonLW9coYJFUo`P82?oNg]ko0000ooooool0003oYJFUokFe]OoWinL02Oooool01?n7Qi[o
k>gcofe]Q_oQhNGooooood_ooooo0_nLW?l00olY:OooinOoooooo`02ooooo`0KobTYooo[j^CoZJZd
ooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJ
olK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko
@W^Uo`PQ>Oli08Coe/k_D?ooool00oogmoOoinOWok2`/00<ooooo`05oe9BD_ne]KGoooooooooool8
20P00_ooool01On4Q8CooooooooooooFe]Ko]KFe00;oc/k>00[oW9bLoooooooooooooooookFe]OnU
YJGoooooojf][OnDU9Cokno_0_ooool01On4Q8Co0000ooooool0003oW9bL00;ooooo00?o_KfmojFU
YOooool00oooool02_nDU9CoQ8B4oooooooWinOoW9bLooOgmonDU9Coooooob4Q8Om2@T83ojFUY@0:
oooooonUYJGoa/K6olk>c_ne]KGokno_o`000?n][Jgoa/K6ono_k`Wooooo00CoQhNJonc]lom]KHKo
hN7Uoooooom:ooooo`05oibLoolY:OooFU[oobTYooogool00oooool06olY:Ooojn[TojVZ]?oooooo
knocon_[l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/Ko
Hf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl8
8CWo>@24omK>kbcooooo00?omoogooooooooool08Oooool00oogmoOoinOWok2`/00;ooooo`07onOW
iol820So61PHoooooomcLg?o0000ohB4Q00=ooooo`03of=SHooooooooooo00Kooooo00?oJg=[oc4a
<Oooool0:?ooool01?n7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Coooooono_
loo[jo3ojNS^onOVkOoMg^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=S
HomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224i
ocT0Q?oFc^l^ooooo`03ooOomooooooooooo01oooooo00?omoOgonOWion`/;00Doooool01?n7Qi[o
k>gcofe]Q_oQhNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNS^onOVkOoMg^Oo
fmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Ko
g]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lTooooo`03ooOo
mooooooooooo00;ooooo0_ogooLUooooo`03ooOgmooWinOo/;2`057ooooo00OomoOgono_kon<S9ko
kNkbohF5Voo0`<Soo_kn0?ooooooDOooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYj>koinK]
omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]
olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbGooooo
00?okoO_oe9BD_mBDU800oooool00oo_mnooFUYJog=cL`0Rooooo`03ooOgmooWinOo/;2`05?ooooo
00CoQhNJonc]lom]KHKohN7UoooooomBooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onWXk_oW
i^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n]
[Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_9Ooo
ool01?ogmoOoU9BDojFUYOmSHf<2ooooo`04od92@_nUYJGoNg]kof][Jb7ooooo00?omoOgonOWion`
/;00Doooool01?n7Qi[ok>gcofe]Q_oQhNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[
jo3ojNS^onOVkOoMg^OofmcUom?Dh?o=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomk
Ng_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0
Q?oFc^lTooooo`04ooOomoooooooooooolk>cP;oFUYJ00Gooooooa0@4?ooooookno_oaPH600Qoooo
o`03ooOgmooWinOo/;2`05?ooooo00CoQhNJonc]lom]KHKohN7UoooooomBooooo`0KobTYooo[j^Co
ZJZdooooooo_ko?ojn_`onWXk_oWi^gogMkWom_LiOoCe>3ocLkKolW:fOofm_WoRh^JogAdSOo/kO?o
QhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:
U<Ko@W^Uo`PQ>Oli08Coe/k_9Oooool02_o_knooDU9Bof=SHola<C7oDU9BoooooolH61SoooooomKF
e_lY:BT6ooooo`03ooOomooooooooooo00Sooooo00?omoogooooooooool03Oooool00oogmoOoinOW
ok2`/01Cooooo`04ohN7V_o/kO?oKFf6on7QiOooooooD_ooool06olY:Ooojn[TojVZ]?ooooooknoc
on_[l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=S
og]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo
>@24omK>kbGooooo00[oc/k>ob4Q8Ooooooog]kNodY:B_oooooo61PHoooooooFe]Ko:BTY8Oooool0
0oogmoOoinOWok2`/01Cooooo`04ohN7V_o/kO?oKFf6on7QiOooooooD_ooool06olY:Ooojn[TojVZ
]?ooooooknocon_[l?oYj>koinK]omgNiooKg>GodmCPolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7
V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6
od9kYOl88CWo>@24omK>kbGooooo00[oc/k>ob4Q8Oooooooc/k>obTY:Ooooooo20P8ooooooogmoOo
410@2oooool2ooOom`kooooo00?omoogooooooooool00oooool00oogmoOoinOWok2`/01Cooooo`04
ohN7V_o/kO?oKFf6on7QiOooooooD_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]
omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]
olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbKooooo
00WoJf][oc4a<Ola<C7oc/k>oooooomkNg_o<C4aobTY:Onm_Kd02Oooool00omJFU[oooooooooo`0>
ooooo`03ooOomooooooooooo00Cooooo00?omoOgonOWion`/;00Doooool01?n7Qi[ok>gcofe]Q_oQ
hNGooooooe;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=
c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koog
moL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lTooooo`05ooOomooooooooooo
olK>a_oFg]H00oooool00oo6c/Koc]KFooooo`08ooooo`09odY:B_n][Jgoooooolk>c_o>c/Koe]K>
olK6a_ooooooinOW00;o_Kfm1?ooool01_ne]KGoooooooooooooooooe]kFooOgm`Cooooo00?omoOg
onOWion`/;00Doooool01?n7Qi[ok>gcofe]Q_oQhNGooooood[ooooo00Co]KGoobTYoomJF_ooFU[o
1?ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wo
m_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03oooo
o`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kcKooooo00[oJg=[og]kNoooooooooooog=c
Lol820So0000oe9BD_o>c/ko<C4a0_m2@T802_mcLg?oooooooooooo_mnoo:BTYoeYJF_ooooooc/k>
oc4a<OogmoL4ooooo`03ooOgmooWinOo/;2`05?ooooo00CoQhNJonc]lom]KHKohN7Uoooooom:oooo
o`05omKFoone]Ooo]KGoobTYoooFe_l00oooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNko
inO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co
[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbCo
oooo00?oQ8B4oa0@4?lH61P02OlH61P00om2@T;oooooooooo`03ooooo`;oNg]k00SoooooooOomooo
oooo_Kfeog]kNoooooooc]KFooOom`;ooooo00?o0000onOWioooool00_ooool01Om2@T;oooooof]c
Jonm_KGooooo00;omoog0_ooool00oogmoOoinOWok2`/01Cooooo`04ohN7V_o/kO?oKFf6on7QiBGo
oooo00CoDU9Bo`000?l820SomoOgoooooolTooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Z
i?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]
lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^lTooooo`03ono_kooWinOoinoW00SoinoW0_oWinL5ooooo`;oNg]k
00GoooooooOomoooooooW9bLoeYJFP02ooooo`05onOWion][Jgo[Jf]oc4a<OogmoL00_ooool01_oW
inOoU9BDoa0@4?lY:BWoBU9:olK6aPCooooo00?omoOgonOWion`/;009?ooool03OogmoOoQ8B4oooo
oon4Q8Cokno_oooooomSHf?oJg=[okfm_One]KGoU9BDog]kNoo_knl08_ooool01?n7Qi[ok>gcofe]
Q_oQhNDUooooo`04omKFe_nUYJGo0000ojFUYOoooooo9?ooool00olY:Oooe]Koooooo`02ooooo`0K
obTYooo[j^CoZJZdooooooo_ko?ojn_`onWYk_oWingogMkWom_LiOoCe=oocLkKolW:fOofm_WoRh^J
ogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002oooo
o`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_8_ooool2ooOoma;ooooo00OoJf][og]kNooooooomooo
oooooonUYJGoFUYJ00;ooooo00go61PHoc4a<OmBDU;oino_ooooooogooooooooolK6a_mBDU;oJf][
of]cJomSHf?oQ8B400Cooooo00?omoOgonOWion`/;009?ooool01_oFe/ko0000onOWiol0003oYJFU
ooooo`;oQ8B400Coa/K6omkNg_l0003o8B4Q8oooool01?n7Qi[ok>gcofe]Q_oQhND8ooooo`03o`P8
2?l0003o000000?o000000CoDU9Boooooooooooooooo0_lQ8B44ooooo`03og]kNol0003ooooo00Co
oooo0ol000000ola<C7oooooooooo`02ooooo`;o00000oooool01Ol0003oYJFUoooooomkNg_o0000
00;ooooo00Go0000of=SHooooooo0000ohb<S002o`000005oibLW?oooooooooooooooomcLg<00_l0
00000omcLg?oooooooooo`02oa0@4003ooooool0003oBTY:00;ooooo00CoBU9:o`000?l0003oU9BD
1Oooool01OnUYJGo0000o`000?l0003oU9BD00;ooooo00Woe]KFo`000?l0003o61PHog=cLol0003o
oooooc4a<Ol000000_ooool01Ol0003o[Jf]oooooomcLg?o00000>7ooooo00?o:BWoomKFooooool0
0_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wo
m_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03oooo
o`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb;ooooo0_ogooL00ooooooomoogooOom`0?
ooooo`07ooOgmom2@T;o_Kfmooooooo_mnooQ8B4of=SH`02ooooo`04obTY:Oooooooooooooooo`;o
mooo00?omoogooooooooool01?ooool01on4Q8Co0000ob4Q8On][JgoooooonOWion`/;009?ooool0
3?oFe]Ko0000og=cLol0003oe]KFooOgmolY:BWo<C4aohB4Q?oooooo0000ohb<S2?ooooo00CoQhNJ
onc]lom]KHKohN7U2?ooool6o`000003odYBB_oooooooooo00;ooooo00?o0000olK6a_ooool00_oo
ool00ol0003o]KFeooooo`02ooooo`07omkNg_l0003o0000og=cLomSHf?o0000oc4a<@02ooooo`04
oibLW?l0003o0000ohb<S0;ooooo00Go0000oibLW?ooooooNg]ko`000002ooooo`03o`000?mSHf?o
oooo00;o000000coJf][oaPH6?l0003o[Jf]oooooomcLg?o0000oe9BD_m:BT[o0000ohB4Q?ooool2
o`P82009ooooool0003oBTY:oooooomBDU;o0000of=SHolQ8B7o000000Cooooo00coYJFUo`000?lH
61SoLg=cobTY:Ol0003oU9BDooooool0003o20P8og=cLom2@T82o`000003oooooolQ8B7o000000;o
oooo00Go0000ojFUYOooooooLg=co`00003Qooooo`03obTYoooFe_oooooo00;ooooo01_o:BWoon_Z
i?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]
lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^lhooooo`05oe9BD_ooooooHf=So`000?mJFUX00_ooool01?lH61So
Hf=Sohb<S?mkNg/:ooooo`06od92@_n][JgoooooooOgmooWinOo/;2`9?ooool01?ogmoOoQ8B4og]k
Noo6a/H6ooooo`03o`000?mkNg_ooooo00Cooooo00KoHf=SoeYJF_m:BT[oBTY:oeYJF_mBDU8Hoooo
o`04ohN7V_o/kO?oKFf6on7Qi@Sooooo00?o410@o`000?l000000ol000000omJFU[oooooooooo`02
ooooo`07o`000?l@413o20P8o`000?lH61So0000okFe]@03ooooo`03oiBDU?l0003okno_00;ooooo
00SoQ8B4o`000?ooooooooooo`000?la<C7o@T92o`0000;ooooo00Go0000ojFUYOooooooQ8B4o`00
0002ooooo`05o`000?m[Jf_oooooo`000?mcLg<00_ooool2o`P82003ooooool0003o@T9200;ooooo
00?o@T92o`000?ooool00_l@41001_oooooo0000oe9BD_oooooo0000of]cJ`;ooooo00?oa/K6oooo
ooooool00_ooool00ol820So0000ooooo`02ooooo`05oaPH6?l0003oooooo`000?mJFUX00_ooool0
1OmBDU;o0000oooooola<C7o000000;ooooo00Go0000ojf][OooooooNg]ko`00003Qooooo`03obTY
oooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?D
goo=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_
koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lkooooo`05ooOgmoo6a/Ko
oooooooooonm_Kd00_mcLg<00om[Lf_oooooooooo`09ooooo`05oe9BD_n][JgoooooonOWion`/;00
;Oooool00om[Jf_o0000ohb<S005ooooo`06olK6a_l0003oU9BDokFe]Ol0003o[Jf]6?ooool01?n7
Qi[ok>gcofe]Q_oQhND8ooooo`03oa0@4?l0003o000000?o000000?oFUYJooooooooool00_ooool0
1_n][Jgo0000oc4a<Om2@T;o0000oe9BDPOooooo0_n][Jd2o`00000=ooooooo_mnoo0000ojf][One
]KGo0000onogkooooooo0000okfm_OooooooQ8B4o`000002ooooo`05o`000?m[Jf_oooooo`000?o6
a/H00_ooool01OlQ8B7o61PHooooool0003oLg=c00;ooooo00?oJg=[o`000?ooool00_l@41001_oo
oooo0000oe9BD_oooooo0000okFe]@[ooooo00Oo]KFeof][Jol0003oHf=Sooooool0003o@T9200;o
oooo00GoNg]ko`000?oooooo<C4ao`P82002ooooo`05o`000?o6a/Koooooog]kNol00000hOooool0
0olY:Oooe]Koooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?ojn_`onWYk_oWingogMkWom_L
iOoCe=oocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkN
g_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_:?ooool01OoFg]Ko
20P8o`000?l820SoU9BD00gooooo00?omoogooooooooool00_ogooL=ooooo`07of][JonUYJGoLg=c
ohB4Q?ooooooinOWok2`/00fooooo`04o`000?ooooooooooo`0000?ooooo00?oNg]kolk>c_ooool0
4oooool01?n7Qi[ok>gcofe]Q_oQhND8ooooo`03oa0@4?l0003o000000?o000000?oFUYJoooooooo
ool00_ooool01_nLW9co0000oooooooooooo0000obTY:@Gooooo00GoW9bLob4Q8Ol0003o0000o`P8
2002ooooo`0Hof][Jol0003oooooooooool0003oHf=Sooooool0003o61PHoooooonLW9co0000oiBD
U?oooooo0000of=SHooooooo0000oaPH6?ooooooinOWo`000?lH61Sooooo0_l00002ooooo`;o0000
00cooooooa0@4?l@413oooooo`000?mBDU;oooooo`000?l@413oooooomkNg_lY:BT5ooooo`05of=S
Hol0003o0000o`000?m[Jf/00_ooool04?l0003o@T92ooooooooooooJg=[o`000?oooooo@T92o`00
0?o>c/koooooo`000?lH61Soooooohb<S?l0003Qooooo`03obTYoooFe_oooooo00;ooooo01_o:BWo
on_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=
onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Ko
kno_odZDa_m2NjGo224iocT0Q?oFc^lZooooo`03oaPH6?oooooooooo023ooooo00KoBTY:ohB4Q?oo
oooomoOgonOWion`/;0Uooooo`04oibLW?l@413o<C4aobTY:@Go61PH00?o:BTYoaPH6?oWinL01?oo
ool01_o_knoo0000oaPH6?o6a/Ko0000ono_k`;ooooo00?o0000of]cJoooool04oooool01?n7Qi[o
k>gcofe]Q_oQhND8ooooo`Ko000000?o@T92ooooooooool00oooool01?lQ8B7o@T92oibLW?l00005
ooooo`04ojf][Ol0003o0000ohB4Q0;ooooo00CokoO_omkNg_l0003o]KFe0_ooool00oo6a/Ko0000
omKFeP08o`000003ohb<S?oooooo000000Co00000_ooool00ooWinOo0000o`000002o`000009ono_
kooooooo410@oa0@4?oooooo0000oc4a<Oooooooa/K600Co00001?ooool01?m2@T;o0000o`000?oW
inL2ooooo`04onOWiooooooo0000ob4Q8@;ooooo00CoDU9Bo`000?oooooo8B4Q2?l0003Qooooo`03
obTYoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^OofmcU
om?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kN
ono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lZooooo`03oaPH6?o_
mnoooooo02?ooooo00?omoOgonOWion`/;009_ooool01?lH61So0000ooooooooool3ooOgm`04oooo
ooo6a/Ko0000omkNgPCooooo00Ko@T92ob4Q8OlH61So8B4Qojf][Oooool3o`000003ohb<S?oooooo
oooo01;ooooo00CoQhNJonc]lom]KHKohN7U2?ooool00omkNg_oJg=[og=cL`02og=cL`03of=SHonU
YJGooooo00Cooooo00Co410@obTY:OnUYJGo00001Oooool00onDU9Co0000ooooo`02ooooo`05odY:
B_l0003og]kNodY:B_ogmoL00oooool01_m:BT[okno_oe9BD_ogmoOoQ8B4oeYJFP;ooooo00SoDU9B
ohB4Q?ooooooooooo`000?o6a/KoS8b<oeYJFPCooooo00Cog]kNof=SHomSHf?og]kN0_ooool2oa0@
4003oooooon<S8co_Kfm00;ooooo00?o_Kfmof=SHomSHf<01Oooool00ol0003o61PHooooo`02oooo
o`;o000000?oooooof][JonLW9`00_ooool00one]KGoDU9Booooo`02oiBDU006omkNg_mBDU;o]KFe
oooooom[Jf_oFUYJh_ooool00olY:Oooe]Koooooo`02ooooo`0KobTYooo[j^CoZJZdooooooo_ko?o
jn_`onWYk_oWingogMkWom_LiOoCe=oocLkKolW:fOofm_WoRh^JogAdSOo/kO?oQhNJolK6a_mSHf?o
Ng]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli
08Coe/k_:_ooool00olH61SokoO_ooooo`0Sooooo`03ooOgmooWinOo/;2`02Oooooo00?o<C4aoa0@
4?ooool01?ooool00ooNg]ko0000onOWi`0:ooooo`04ooOgmol0003o0000ohB4Q1Cooooo00CoQhNJ
onc]lom]KHKohN7U5?ooool01?o_knoo0000o`000?nLW9`6ooooo`03ob4Q8Ol0003o20P800;o0000
00?oNg]kooooooooool04?ooool00ol0003oS8b<ooooo`0;ooooo`;o000000?oooooob4Q8OmkNg/0
2_ooool01?oNg]ko0000o`P82?l820P2o`000003omKFe_oooooooooo0?3ooooo00?o:BWoomKFoooo
ool00_ooool06olY:Ooojn[TojVZ]?ooooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9
b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03
ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb[ooooo00?o8B4Qonogkoooool08ooo
ool00oogmoOoinOWok2`/00Xooooo`03oaPH6?l0003ooooo00?ooooo00?oe]KFo`000?oNg]h03?oo
ool00ol0003oS8b<ooooo`07ooooo`03ojf][Ol0003omoOg00Wooooo00CoQhNJonc]lom]KHKohN7U
5Oooool00ola<C7o61PHooooo`07ooooo`04obTY:OlQ8B7o8B4QohB4Q1?ooooo00?o61PHokFe]Ooo
ool02oooool2oe9BDP03ooooool@413oJf][00_ooooo00GoinOWoaPH6?lQ8B7o8B4QomKFeP3coooo
o`03oeYJoooFe_oooooo00;ooooo01_o:BWoon_Zi?nYZ[Coooooono_loo[jo3ojNW^onOWkOoMg^Oo
fmcUom?Dgoo=c]_obL[IooKfnOn;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Ko
g]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lXooooo`03omKN
e_l@413o000000?ooooo00?omoogooooooooool07oooool00oogmoOoinOWok2`/00Yooooo`03oaPH
6?l820Sooooo01_ooooo00Ko0000ohB4Q?ooooooJg=[oiBDU?m[Lf/2ohB4Q0Cooooo00CoQhNJonc]
lom]KHKohN7Uoooooom;ooooo`;oFU[o00?o:BWoono_ooooool00_ooool06olY:Ooojn[TojVZ]?oo
ooooknocon_[l?oYjNkoinO]omgNiooKg>GodmCOolg>foo9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6
a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9k
YOl88CWo>@24omK>kb[ooooo00?oHf=SooOgmoooool08oooool00oogmoOoinOWok2`/00Zooooo`03
ob4Q8Ol0003ooooo00Oooooo00?okno_ooOgmoogmoL02?ogmoL00oo_mnooooooooooo`04ooooo`09
oe9BD_l0003ooooooooooola<C7o0000olK6a_l@413o000000Cooooo00CoQhNJonc]lom]KHKohN7U
oooooom:ooooo`04onOWoonLW?ooW9coobTYo`;oknoo01go]KGoomKFoolY:Ooojn[TojVZ]?oooooo
knocon_[l?oXj>ooi^K]omgMi_oKfnGodmCPolg>g?o9b]Wom_Kioh^;V_mdM8gok>gcohN7V_o6a/Ko
Hf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl8
8CWo>@24omK>kbCooooo00?omoogooooooooool0:Oooool00oogmoOoinOWok2`/00[ooooo`03od92
@_l0003okno_00Gooooo00?oe]KFoa0@4?lH61P02_lH61P00omkNg_oooooooooo`03ooooo`09o`00
0?lH61SooooooooooonUYJGo0000oooooomSHf?o000000Cooooo00CoQhNJonc]lom]KHKohN7Uoooo
oom:ooooo`06oibLoomJF_ooFU[ooeYJoooooooo]KGo0_lY:Ol06omJF_oojn[TojVZ]?ooooookNgb
onWYkooVincoi>G[om[Ji_oHf>Cocm3LolS9f?o4aMKomOGhoh^<V_mdM8gok>gcohN7V_o6a/KoHf=S
og]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo
>@24omK>ke3ooooo00?omoOgonOWion`/;00:oooool00omkNg_o0000omkNgP0Hooooo`09o`000?lH
61SooooooooooonDU9Co0000olK6a_mSHf?o000000Cooooo00CoQhNJonc]lom]KHKohN7UoooooomC
ooooo`05on_Zi?nMWZ[ono[kooooooomoOh00_olo?d00oogmo_om_KjooCdn002oo7am`0>onc[k_n4
QIGoMGF=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3ooooo`000_oo
ool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00:_ooool00omBDU;o
0000ooooo`0Jooooo`03o`000?nm_Kgooooo00Co000000?oe]KFooooooooool00_ooool01?n7Qi[o
k>gcofe]Q_oQhNGooooooe?ooooo00Colo;[omWIg?nRXjkoalO<0_o3`lT05?o2`/So`l?9olC4b_o4
a<[oaLG:olS8c_nSXjkoaLG6ofm_R?o/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_
knoomoOg0oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo
/;2`02Wooooo00?oBU9:o`000?ooool06oooool00olH61So0000ooooo`09ooooo`04ohN7V_o/kO?o
KFf6on7QiOooooooDoooool01?oblN_od=7IoiNHY?nYZ[H7ojNX]00?ojRY]OnKW:So_l7<ofm`R?o/
kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_
kom:U<Ko@W^Uo`PQ>OlQ0<koe]KoD?ooool00oogmoOoinOWok2`/00Xooooo`03oe9BD_l0003ooooo
00?ooooo00?o20P8oibLW?ooool02?ooool01?o_knooooooooooooo_knl;ooooo`03ojFUYOoooooo
oooo00Sooooo00CoQhNJonc]lom]KHKohN7UoooooomCooooo`04on_Zi?nRXjgok^kbomKGh`Oof=WT
00ooe]OSon_/k_n5QYGoMGF=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koog
moL00oooool000;ooooo00Kokno_odZDa_m2NjGo235:od80YOoFc^m@ooooo`03ooOgmooWinOo/;2`
02Oooooo00?oJf][oa0@4?ooool01?ooool00ol0003oJg=[ooooo`07ooooo`05omKFe_lH61So0000
o`000?lH61P05_ooool01?n7Qi[ok>gcofe]Q_oQhNGooooooe?ooooo00Cojn[Tojb]]_obl_OoaLKF
1oo:bmT03oo6amKomOKhoh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]ko
kno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOW
ion`/;009_ooool01?mBDU;o0000obTY:Om2@T83oc4a<@03od92@_l0003oJg=[00[ooooo00?o0000
of=SHoooool05_ooool01?n7Qi[ok>gcofe]Q_oQhNGooooooe?ooooo00Gojn[Tojb]]_obl_Ooa/OF
olg>g@04ol_<fP0Aolg>gOo;c=[oalSGooKfn?n;Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BD
ojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@
ooooo`03ooOgmooWinOo/;2`02Kooooo00?og]kNooOgmooWinL01OoFe]H00oogmoOoooooooooo`09
ooooo`03o`000?m:BT[ooooo01Kooooo00CoQhNJonc]lom]KHKohN7UoooooomCooooo`06on_Zi?n/
[KKolO7folk?gonj^lKod]?Q0_o:bmT04_oAd^7o^[_7om?Dhoo6b=Kom_Khoh^;V_mdM8gok>gcohN7
V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`?ooooo0002ooooo`06ono_kom:U<Ko
@W^Uo`PQ>Oli08Coe/k_D?ooool00oogmoOoinOWok2`/00hooooo`04omkNg_n4Q8Co0000oe9BDQOo
oooo00CoQhNJonc]lom]KHKohN7UoooooomCooooo`06on_Zi?n/[KKon?Wnoj2Q[?ln?CcoXZ>/0_oG
f>L04_nOWjSo?cdmojNX/_o>cmkom_Khoh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]
olK6a_oNg]kokno_ooOgm`?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_?Oooool0
1OogooOooooooooooooooooomoog00kooooo00?omoOgonOWion`/;00:?ooool01OmcLg?o8B4QobTY
:OlQ8B7oLg=c00_ooooo00ComoOgoaPH6?l0003oBTY:5oooool01?n7Qi[ok>gcofe]Q_oQhNGooooo
oe?ooooo01[ojn[Tojb/]_ojn_ooYJFaoc/i>Olf=3?o[JfhojZZ]?le<c7o?C/kojb/]_oBdn?om_Oi
oh^;V_mdM8gok>gcohN7V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`?ooooo0002
ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_=oooool00oogooOoooooooooo`04ooooo`03olk>
c_mcLg?oQ8B400oooooo00?omoOgonOWion`/;00:?ooool01Ol@413o0000o`000?l0003o61PH00go
oooo00?o<C4aog]kNoooool05_ooool01?n7Qi[ok>gcofe]Q_oQhNGooooooe?ooooo01[ojn[Toj^/
]Oofmo[og=kZol71b_lk>CSoA4=3od=1@_lm>c_oa<C=on3QkOoDeN7on?SjohZ;V_mdM8gok>gcohN7
V_o6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`?ooooo0002ooooo`06ono_kom:U<Ko
@W^Uo`PQ>Oli08Coe/k_6_ooool00oogooOoooooooooo`0Dooooo`03ooOomooooooooooo00?ooooo
00?omoogooooooooool01Oooool01?l0003oW9bLooooooogooL=ooooo`03ooOgmooWinOo/;2`02So
oooo00Go_KfmoiBDU?nLW9coU9BDokfm_@0Vooooo`04ohN7V_o/kO?oKFf6on7QiOooooooDoooool0
6_o[j^CoZZ^eooclo_oQhN[oj^[bol_;dOlk>CWo?S`kolk>e?oYjO;oi>C/on;Rjoojn__oRX^JogAd
SOo/kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg0oooool000;ooooo00Ko
kno_odZDa_m2NjGo224iocT0Q?oFc^l8ooooo`;o[Jf]0_o_mnl2ojf][@;ooooo00[oa/K6oibLW?oo
oooo_Kfeojf][OogmoOoooooonO_ionLW9coe]kF0_ooool01oo>c/ko]KFeolk>c_oWinOoW9bLomkN
g_ooool00_ogooL02ooooooomoogoibLW?n][Jgo]KFeonogkone]KGoe]kFoooooone]KGoW9bL00;o
oooo00ComoogoooooooFg]KoW9bL0oooool02OnDU9ComoooolK6_Ooooooo[Jf]ono_komBDU;oU9BD
onOWi`02ooooo`08omKNe_n][JgokoO_omkNg_ooooooU9BDomkWg_ne_Kd4ooooo`03ooOgmooWinOo
/;2`05?ooooo00CoQhNJonc]lom]KHKohN7UoooooomCooooo`09on_Zi?nYZ[Coooooonk^l_o_ko?o
n_[nokno`Oo3`lGonOWm00;oknoc00ook^kbooclo?n:Ri[oM7B=onc]lon7Qi[oa/K6of=SHomkNg_o
U9BDojf][Oo6a/Kog]kNono_koogmoL00oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oF
c^l8ooooo`0Hoc4a<Ol0003okoO_onogkol0003o<C4aoooooonUYJGo0000og=cLomSHf?o61PHo`00
0?oooooog]kNo`000?mSHf?o@T92olK6a_oooooo[Jf]o`000?nm_Kgo8B4Q0_mBDU803oo>c/kooooo
ooooooo_knooDU9Bof=SHolY:BWo0000onO_iol0003oe]KFog=cLol0003oJf][of=SH`02ooooo`0=
omKFc_m:BT[oBTY:oibLW?ooooooJf][of=SHomBDU;oW9bLokFe]Ola<C7o[Jf]odY:BP02oe9BDP;o
inOW00SoBTY:of=SHom:BT[oe]KFog]kNom:DT[oa/k6ohB4Q0Cooooo00?omoOgonOWion`/;00Dooo
ool01?n7Qi[ok>gcofe]Q_oQhNGooooooe?ooooo00Cojn[TojVZ]?oooooon?Sj0_oinOX00oolo?go
o?clooWinP03ooWinP0>oogmo_n:RYWoM7B=onc]lon7Qi[oa/K6of=SHomkNg_oU9BDojf][Oo6a/Ko
g]kNono_koogmoL3ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>k`Sooooo01?oe]K>
of=SHoooooooooooof=SHoo>e]KooooooaPH6?n<S8coooooono_kon][JgoS8b<oooooon4Q8Co<C4a
ooooooo_knoog^ON00;ooooo00Ko61PHoooooooWinOoknOWo`000?ne]KD2ooooo`0<olk>c_lQ8B7o
ooooomkNg_mSHf?oooooobTY:Ooooooo0000olk>c_ooooooa/k60_ooool03on<S8coLg=cooooool@
413oooooo`000?oooooo410@oooooola<C7oe]KFoooooolY:BWoooooof]cJ`02ojf][@05og=cLooo
oooo8B4Qooooool000000oooool01oogooOooooooooooooooooomoOgonOWion`/;00Doooool01?n7
Qi[ok>gcofe]Q_oQhNGooooooe?ooooo00?ojn[TojRX/oooool02Oooool03_ono_koRHVIogAeSOo/
kO?oQhNJolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg0oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^l8ooooo`0BolK6a_l@413oW9bLoibLW?l@413oa/K6oooooolQ8B7o
Hf=So`000?o>e]Koe]KFoaPH6?ooooooU9BDoaPH6?la<C7o@T920oooool01_lH61SooooooaPH6?mJ
FU[oooooono_k`;ooooo00cokoO_od92@_oooooo_LJmof=SHooooooo0000ooooool0003oJg=[o`00
0?o_knl2ooooo`0Fohb<S?mcLg?ooooooaPH6?oooooo61PHoooooolQ8B7oooooof=SHooNg]kooooo
od92@_ooooooJg=[ojf][OoFe]KoJg=[oooooolY:BWoooooob4Q8@?ooooo00Oomoogoooooooooooo
ooooooOgmooWinOo/;2`057ooooo00OomoOgono_kon<S9kokNkbohF5Voo0`<Soo_kn0?ooooooD_oo
ool01?odln[oZJ^don7Qi?ojn_X7ooKfm`0?ooWin_oCe=WoUINSog=cRoo]k_?oQhNJolK6a_mSHf?o
Ng]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg00?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli
08Coe/k_2?ooool04_o>c/ko0000ohB4Q?n4Q8Co0000olK6a_oooooo]KfeodYBB_mSHf?oinoWog=c
Lol0003o8B4QonogkomSHf?oBU9:okfm_@;ooooo00OoU9BDo`000?oooooo_Kfeof=SHol0003oU9BD
00;ooooo00co@T92o`000?m:DT[oa/K6o`000?m2@T;o[JfUoooooonLW9coHf=Sog=cLoogmoL2oooo
o`0IomkNg_m:BT[o:BTYolK6a_n4Q8Co0000olk>c_l0003og^ONo`000?lH61SoBTY:o`000?la<C7o
DU9Booooool0003oNg]koe9BD_la<C7o[Jf]o`000?m2@T;o_LJmog=cL`04ooooo`03ooOgmooWinOo
/;2`057ooooo00KomoOgono_komlO93ok^ocogYjTOnf]/7ooo7albWolO7c:Oo5aM001Oo6a]7o_Kg3
ojBV/_n0P9CoU9>U00CoTI6R01;oT96Roi6AX_n@TJ;oTY:SogioTonNXJkoKVj7onKWk?n7Qi[oa/K6
of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3ooooo`000_ooool01_o_knooBYC6od9kYOl8
8CWo>@24omK>k`Sooooo00Koc/k>of][Joooooooooooof][JooFe/h2ooooo`0>olK6a_o_mnoooooo
omkWg_ooooooa/K6oooooooNimkoc/k>ooooooogooOoooooomkNg_o_mnl2ooooo`;oc/k>0oooool0
1_n][Jgo<C4aomkNg_oNg]ko:BTYomkNgP?ooooo00?o]Kfmooooooooool00_ogooL06Oooooookno_
olK6a_ooooooe]KFonOWioo_mnooe]KFoooooom2@T;oU9BDomKFc_oNimkoa/K6onogkoooooooa/K6
oooooooFe/komoOgomkWg_lQ8B7oc/k>onogkoo>e]H01?ooool00oogmoOoinOWok2`/01Aooooo`07
ooOgmoo_knooPH6EonOWk?nATJKoPX>Noh:2W@0<ohB5WoooPX:M7?n2PYdZoi:CZ`03oiBE[OnHV:oo
W9bc00WoVIZa00koW9fcoiNG[onNW[?oiNGZohJ5VOo6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]ko
kno_ooOgm`?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_2?ooool01_m2@T;o0000
oooooooooooo0000od92@PSooooo00?omoooooooooooool01?ooool00onDU9Coooooooooo`08oooo
o`03oc4a<Om2@T;ooooo02Gooooo00?omoOgonOWion`/;00DOooool02_ogmoOokno_ogmoToo_ko;o
dM7HomKEg?oEeMcoa/O=ol_<d_o;bm82ol_<dP08olc<doo;c=;oblcBol_<d_o<c=?oblcBolc<dooJ
f^0BomGEg003omKFg?oIfMooeMGL0?ooeMGL1_oEeM`Aon;Ri003on?Si?oRhN?ogmoQ00OogmoQ00Go
h^;Son?Si?oRh^Cohn?Ton7Qh`07omoOh@06on3OhOoSh^Coh^?Ton;Ri?oShnGoh>7S0_oQg^02on7O
h0?ohMkP013oh>3Ron?TiOoSh^Coh^;TomoOhOohn?WoPX:FolK6a_mSHf?oNg]koiBDU?n][Jgoa/K6
omkNg_o_knoomoOg0oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^l8ooooo`;oW9bL
0_oWknl00onDU9CoW9bLooooo`0>ooooo`03oibLW?oooooooooo00Sooooo00?oS8b<olk>c_ooool0
3_ooool00oogooOoooooooooo`09ooooo`03ooOomooooooooooo00Sooooo00?omoOgonOWion`/;00
DOooool01?ogmoOokno_ogemTOoal_@3oocknP03om?Dd_n[ZjWoZZZY00;oZJVX00SoZ:RWojJWZ?nW
Z:OoYjRWojVYZOnYZJSoYjNVolW9a`Coo?_j0_olo?X2oocknPKoo?cj00Koo?_joocln_olno[oo?cj
ooWhnOoLfN02ooclnP04oockn_olo?[oo?cjoocknP?oo?cj00?oo?_joocln_olnoX00_olnoX00ool
o?[oo?_jooclnP02ooclnP?oo?_j0_olo?X01Oolno[oo?cjoocln_olo?[oo?_j00?oo?cj0_olnoX3
ooclnP;oo?_j0oolo?X01?olno[oo?cjoockn_olnoX2ooclnP04oockn_olo?[oo?_jooclnP;oo?_j
1_olo?[:oocknQ7ooooo00Cojn_/oiVQ]?m`NICoLGZE0_maNYH3og5jU@08og1jUOnQZKWolO7aoooo
oooPh>?oSIJ[ofigTomaNYD2og5jUP;oLGZE00WoL7VDog=lUona]/?onOShoooooooBg>?oWFUjojPc
@OnW>dT00_nX?4T2ojLkB@04ojPe@onNEFKoa<gGookoo`;ooooo00_oo_knoginToo6a/KoHf=Sog]k
NonDU9Co[Jf]olK6a_oNg]kokno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24
omK>kbCooooo00?omoogooooooooool0:Oooool00oogmoOoinOWok2`/01Aooooo`0FooOgmoo_knoo
Ng^?onGUi_ono_ooo?gnoo_koOnVYZOoXJ6QomGEeOoThMooin_`olS4[?o9Yf;oiN?PonCQgOoOc;Go
in?PonKWjOnf][KooooooogmoTkooooo00?oo_gnoogloOomo?d0>_omo?dAoocmoBOooOcmEOoloOd@
oo[jo003oooooon[//?oJgBE00;oSi6g0_n>TKL3ohnA]`07ohf?]OmYLY?o^/3=oooooonDW;7oL7NJ
ohR;]003ohJ9/P0:ohF8/_n<S[GoT9:hohN:/?mYLi;odmKOooknoonKIg[o[3A6okE7FPGo]4EI017o
]DIIojlgBOnGDFCojNS/oogmoOolo?kolo?bog]kSoo6a/KoHf=Sog]kNonDU9Co[Jf]olK6a_oNg]ko
kno_ooOgm`03ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOW
ion`/;00DOooool0<_ogmoOokno_og]kSooQhNComoOiooGen?odm_So^[^kojNWYooTiNKohm;9om>Q
TOo<^gGoijL0onfiL_oXY5_ohJinoncgoooZj>Ko][Ffoocmoooem_SonO[kooOhnOoLfn7oeM7Lono]
looooooojn[]om;?f?oIe^3oj^S^onWWkOogm_SokN_aoo3^l_ocl_Goj^O]ooWhn_oThNWoo?cmonGR
j_ohmoWonOWkonSVk?o[j^oodLkHomKCgOo`k_?ono_l<_oinOX00oodm?Oom_KhooGfn00jooGfn17o
mOGh9ooem_QEooGen13olo?f00Cooooooi2HZ_nDVK[oYJG21?nOX;d02_nRXkooYZO2ojNXa?n;TK;o
WjJeoooooomkQ9coZZg;onCTkOoWio02onKVk`0Pon_[l_o2`mWoXjC1ojVZaommQ:Go_<7:ooWdm_nY
<coo_U1OolQ>Doo9CE;ocEYNoleKGoo;DeOobDeBol]FF_o0DUkoYbXhonG@e?oemo[omOGgono_l?mk
Nhooa/K6of=SHomkNg_oU9BDojf][Oo6a/Kog]kNono_koogmoL3ooooo`000_ooool01_o_knooBYC6
od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00DOooool0<oogmoOokno_og]kT?oNgN;o
knocong_l_o[kO3oUYNHoj>TYOoHg=oohn7]olY:3oo=X@Oo`kH0on2A0?njH@3o/XYJomo2OooHb9co
]KFgooCen_o^ko;ono_lojVZ[?m5ADOoJV]_olc;doo6aL_oC4e@od92A_m9B4koOWb5oh^9T_o6a/_o
J6M^on3Ni_mNGF;oi>;/oeaLG_oBd=[oOh62oj6MZOono_koNW]mohN4S_le=SWo@D55of=TIoo;bM?o
jNS^oo;dm`0aoo7am@03onc/loo^ko?okNkc03[okNkc4Oo]ko<Wong^leGokNoc4?o[k>l04_ogmoSo
T9RZojFY`onn_]7onOWlono_mOo`l?Gom?Chom7Ag_nWYl7o[k38oijS_OnMY;CooOgmogj7W_o;c^3o
e]GNoh>2WP;oSXfW023oUYF`oe9BI_nGUjko][O?ohfD[onf_<Sok^g`oji0BOo9C53ojK>fooWXjOo@
Ff3oc4aAonR`/_olk^oocEQMoleIGOn`>D;og<cAong`m?o/k_7oj^[]og]kT?o6a/KoHf=Sog]kNonD
U9Co[Jf]olK6a_oNg]kokno_ooOgm`?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_
D?ooool00oogmoOoinOWok2`/01Aooooo`05ooOgmoo_knooNg^@omOHgooOhNT00_oOhNP0;?n/[kKo
WiF:om2JC_oW`SGol/@:oo;T0?nh_03oLW<0ogia0?oX^03ohKmGonGTfOna/[Goi>K]omoPiooUi^_o
iNK/onWZl?mfN7[oYZR/oe9BE_nm^/KoinW^oe=DEomXIVkoOWb5okJg_OmDDUWof=OPodA4B?oNg>So
QhV<on[[l?mPHVCoVINQoo_loomOH6?oKfaeoeIEG?ocl_[oYJRZoeaJH_o[joCoi^S]<OoTi^`00ooV
io3ogn7WomoQi`37omoQia3ofmgU03Coi^O]oh^BYon^//WobL[IoinN[?m@Cg3oGEajod92G?mNGg3o
b<WNokfndonUZ/7oUIb_on_/lOmlQIgoe=KUol2ocOn>SZ_o^[c@ok6bbOoVio;oJfYdoiNH[Oo4a=Wo
TiVbojba`?oPgNCo[Sm9om=AEOoCZZ[on_ooooKKg?oXYJOoooooomkMg?oEGf;oe5eQok8j@oo?_lOo
g>7Yom_Mi_oQh^OoNg^@olK6a_m[Jf_oNg]koiBDU?n][Jgoa/K6omkNg_o_knoomoOg0oooool000;o
oooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`03[ooooo00?okoO_
ooooooooool05?ooool0<oogmoOokno_og]kT?oCeMcoe=OQomGGh?oCe]koSi2FohF3ROng[H_oe:dX
onfb0?oob@3oZIh0oc4[0?nnR@3ookH3om^oSooWjoCo[jnbomWLiOoEen3oemWRomKHhOmhNWooX:6X
ong^mom7B4co_[_7om_Mi?mEEE[oK6YbohR5Sonf][ooGUaSomOFh_m3@dKodm7NonCVk_oXjO;oGV1S
oj>PZoohn?ooG5eQog1^M_mRH6SomOCooj2RYomJF5ooh^;]omSJhP0aomOHh@03omkNjOoEen3oeMOP
0<OoeMOP4?oCe]l07ooMgnOoQhnTol72eOnb]<;oD51Qof5QL?mPH6koFEUXoi:CX_oDe^Coc]3Nok:d
b?n@V:_oh^CZogb5W?oPhNco_kk=oiZK]?o<cmco`lGEoo;cnom/K7KoYZNgomKGiOnLXKSoYZblomOF
gOn_@4Woj6]ZoiHj=_nLQ8800_ooool04oo<a<?oN3LcomeVHooPIfGo]Ca3olVi`ooDfN;odmGNom_M
iOmkNi3oa/K6of]cJon4Q8CoU9BDokFe]Oo>c/kog]kNono_koogmoL00oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`03Wooooo00?o0000od92@_ooool0
5Oooool0<_ogmoOokno_og]kT?o?d][oc]3KoloAg?o>d=_oWj2Woi^KV_oKgnWoejaVon:40?oZMP3o
TRd0odP;0?oPH`3oohL0oo:F7ooG`9ko[Zncom;Dh?o?dMcof]cWohjAUomRIFWoWYZUok>`_?m1@TKo
_;[6om?Dgom;C53oJfYaoeMEFomgMGgo?3/ooi>?VOmRHfSoeMKQom3Bg?oOhNcoEEMJofYWKonPW:So
H61VohZ<Tom6AT_oXIjYog9`N?mnOhGofmgX<_o@dM`00ooFf>?ocm7KoloAf`0joloAfa7oc]7L9oo?
dM]EolkAg13ocLoI03Coe]OPohF=X_o3aMGof][WonGUlooTi?7oi>CbonGUlooMgN_oe=CQomWHiOng
^/coSIFXom_LhomkQ9coi^K`okZibOnj^/[oooooooShn_ooooooIfMbojj^_OoPgn_oXJJjoj6W^?o?
c]So/D9;onEaKOoaJfSo]I6?ookooooooooo`knnome]J_oVKV_oj79^okY0B?o2/[kocM;Molc?f_oG
fN;oNW^@olK6a_mkNg_oS8b<oibLW?ne]KGoc/k>omkNg_o_knoomoOg0oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`00_ooooo013okno_oc4a<Ola<C7o
ooooohB4Q?la<C7oW9bLoooooolH61Soa/K6oooooolY:BWo@T92oooooomkNg_o@T920oooool01On4
Q8Co@T92oc4a<OlY:BWoQ8B400Cooooo00Soa/K6obTY:On4Q8Co]KFeoc4a<OnUYJGoS8b<odY:BP?o
oooo00KoLg=cod92@_m2@T;o@T92ojFUYOn<S8`2ohB4Q00;obTY:OnLW9cooooooooooonDU9CoBTY:
okfm_Oo>c/koe]KFoibLW?mcLg<03Oooool0<?o_knooNg^@olg>f?o6b]Kob<_EolK:e?n@TYWo/[Fh
om>lVOo8Rc;odgL?on6=0?oKP`3oRCl0ok@o0?odPb_oi<ZNoo?Q`on/[K7ob/gJolS;eoo7b]Kod=;O
oh63RomEEUgoUYVSohb>Uoo1`m3obL_HohZ<UOnPXZgoF5]QoeiQIomPHf[oHF=YolO9e_o:c=Woal[G
oloAgon?TYcoEeYOoe=FG?n_/KgoZjjiobPY:omMGVCoMgZ2om;EhP;oal[G<Oo8b]L00oo6b=KoalWG
olO9e`0jolO9ea7oal_F9oo7bMMEolO;eQ3oaLSD00CocM3Joh:;XOo4aMKohMo[1_oOg^X0:OoRhNco
^;[<ohZBY_oBe=koNX>KonOVl?o1`LooK6^<ohJ5Won4PikoS8^WocHfC?nn_LWoj>Kboj6U^_nLXkGo
b<SCok=5COo/Lfgoml?2oooooooBb/[oUh5oooooooooknkokH1jonmoNOnnAd_o^jfjolK<f?o5b=Go
dmCOogYjT?o6a/KoQ8B4oiBDU?n][JGo_KfmomKFe_oWinOokno_00Cooooo0002ooooo`06ono_kom:
U<Ko@W^Uo`PQ>Oli08Coe/k_D?ooool00oogmoOoinOWok2`/00<ooooo`0@oc4a<OmkNg_oooooonog
kol0003ooooood92@_ooooooQ8B4oooooola<C7oW9bLojf][On<S8cog]kNohb<S0;ooooo00KoinOW
oa0@4?mSHf?oe]KFohB4Q?mkNg/2ooooo`0:omkNg_lY:BWomoOgo`P82?oooooo410@og=cLonLW9co
e]KFoiBDU0;ooooo01?og]kNo`000?oooooo0000ooooool@413omoOgoeYJF_o6a/KoJf][okFe]Onm
_KgoDU9Bolk>c_la<C7ooooooaPH6?ooooooinOW00gooooo023okoO_og]kT?o:bmOo`LCAol;5d_o1
a=;oSi6Hoh^<Roo7^jKojn3EolbF;Oobc@3ok:@0olAi0OnNH@?obX10omcKhoocmocoZjb_olC8e_o2
aM;o`/CBol73dOo<cmgodMCSolS;fOo:cM_o`/GCol74dOo;c]coal[Hom7DhP;od=?Q00Kocm;Qol;5
doo1a=7o`LCBol33d?o:cMX2om7DhP06olkAh?nFVJ?oI6E[omkPl?o=d=ko`LCAL?o1a=8Aol75dROo
`LCBEOo1aM8@ol73d@04olW:eomnQikof]WUonk]m@;oj^Wb0_oZjO402_oZjO;oj^Waoo7`moo;c=[o
QHfSolg>f_mjPi_onOKnojVY]?lg=TP3odE4E@0Noc`lC?oBd]_on_Onok2caOnFWK3o`l;?okM3BOom
QGSogKNeol_;c?n8ET_o/gEToif9ROoMf=[olhZ3ooZ=POo4BDWo]jJeol;7e?o0`m7ocm;NogYjT?o6
a/KoU9BDojFUYOne]KGoa/K6omKFe_oWinOokoO_1?ooool000;ooooo00Kokno_odZDa_m2NjGo224i
ocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`00cooooo00OoJf][olK6a_ooooooooooob4Q8Ooooooo
20P800;oLg=c00Ooooooof=SHooWinOo]KFeoaPH6?n4Q8Coa/K600?ooooo00Go8B4QoooooonDU9Co
Hf=SomKFcP02ooooo`0:onOWiola<C7ooooooaPH6?oooooo@T92oibLW?lY:BWoQ8B4olk>cP?ooooo
013o8B4QoooooolH61Soooooob4Q8OooooooDU9Boooooon4Q8Co[Jf]okfm_OmcLg?ooooood92@_oo
oooo61PH3oooool05OogmoOoNg^@olO8eOnl_/go_/3>okfocOn?TI[oYJFSonCUi_obknOof;LmonkX
`?o^_VGoeI8BomCEd_oKa:7oiLbfooCcm?nZZjoo`<;Bokk0cP0Eokg0cP04okk0c_nk_/co^;_8okk1
cSGo_L3>?Onn`<hAokg0cROo_/3>EOnm`<h@okg0c@04olC6d_n6Sj?oWj>ioo?an0Kooooo00Ook^ce
oiBJ/On=UJWob<[Eog^5Vonb]<Son_Sm00Kooooo01cohn;^ohB;Y?nMXkGo_l7>ojEIHooiQ7Wo]GIT
oh9TC_oni;Woon^ookBLN_moHD[oojnJooN9Non]DUWo/jjmokk2d?nk_/coblgIogYjT?o6a/Ko[JfU
okFe]Oo6a/Koe]KFomkNg_o_knoomoOg1?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oF
c^m@ooooo`03ooOgmooWinOo/;2`00cooooo013oNg]ko`000?lH61So61PHo`000?oooooo8B4QoiBD
U?l0003ooooooe9BD_ne]KGoW9bLodY:B_mSHf?o@T920_ooool01_o_knoo61PHojFUYOm[Jf_oDU9B
ojf][@;ooooo00Soc/k>ob4Q8Ooooooo61PHoooooom2@T;oU9BDodY:BP;oDU9B0_ooool04ooNg]ko
20P8ooooool@413oooooob4Q8Ooooooo:BTYolK6a_m[Lf_o_KfmoiBDU?m[Jf_og]kNoc4a<Ooooooo
61PHooooooo_knl03Oooool03oogmoOoNg^@olC5eOnd]<So][O9okFfbOn5QY7oUiNEon?SiOogk]co
o?gWoogooooljmWokkm_ooWjn`03ooooo`05ojRY[Ong^<go]KO:ok>dbOnd]<T05?nc]<T00ond]L[o
]KK;ok>db@0eok>dbCgo]KO:4Onf]lXWokFgbUGo][O:4?nc/lP01One]LWoZZ[1ogAmU_n<Tj[oXJRg
00CoX:Ng00WoX:NfohR>Y_mgP9Wo[Jk4okJeb_nQXk_oLGZDoi>I[_nQZ;P01?nPYkL07OnNYKGoOhNP
ogn6Wona/LSo];K<oiRQ^OnNEf;of6QQomN0MOo6N6Woa7MXom22L?oGPgKoc6ENojeEFon@Tj_o/[O>
ok>cbOnb//SoalWJogYjT?o6a/Ko_KfmolK6a_oFe]Kog]kNonOWioo_mnoomoOg00Cooooo0002oooo
o`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_;oooool4ooOomagooooo00?omoOgonOWion`/;003?oo
ool01OmkNg_o_Kfmoooooooooooo8B4Q00;ooooo00So<C4aomKFe_o_knooW9bLof=SHon4Q8CoW9bL
oe9BDP?ooooo00KoJg=[of=SHoooooooHf=SobTY:Onm_Kd2ooooo`09od92@_l0003oooooo`P82?lY
:BWokno_oooooomkNg_oFUYJ00?ooooo01?oHf=SohB4Q?n][JGoa/K6oaPH6?oNg]kokoO_ob4Q8OlY
:BWoS8b<oooooolH61So_KfmodYBB_nLW9coQ8B4o`000?ne]KGoJf][00kooooo01?oL727ol?4donf
]L_oZ:O2oj^Za?n7QiSoZj^Xolg=boo:blWobLW<ol[:b?o:c<coa/6eolc<b_o<c<_ocLk<ol_;b?nY
ZJko[Jc80?oo[J_56_n]ZlDAoj^Za003ojj/a_nWYl3oVI^e00GoUiRc00SoUiRdoiZL]_nXZL7o[Zc6
ojZZa?n^[LKoY:FmoiRJ]@GoUiRc00OoUiVdoibN]on[Zl?o[Jc5oj^Za?n/[/OoXj2i00;oYHfV0onU
S:L02_nUSJKoYHjVoj>K/onZ[/So[:[4ojVX`one]L[oblcJogUiT?o6a/H2omKFeP04omkNg_oWinOo
kno_ooOgm`Gooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_;oooool4ooOomagooooo
00?omoOgonOWion`/;002oooool01oo_knoo0000o`P82?ooooooQ8B4o`000?nLW9`03Oooool00on4
Q8Coooooooooo`05ooooo`03omKFe_n4Q8Co000000Wooooo00?oQ8B4ooooooooool03?ooool00oo6
a/Koooooooooo`0>ooooo`09omgMi?nf]LWogmoXokjmdOn_[/GoYjJmoj:Q]?nTXkKoXj:f00?oXj:e
00OoXjBjoj:R]OnRXKGoXZ6eoj:R]OnXYkcoZ:O00?ooZ:No6_nXYklBojZY`003oj^Y`On[Z/;oZj[2
00KoZj[200GoZjW1ojZY`?nZZL3oZZW0oj^Y`@08oj^Z`P05oj^Y`OnZZL3oZZW0ojZY`?n[Z/801onZ
Zl<02?nZZ/;oZjW1ok:aa_o5aMGojNW`ok>baOoWingo_Kfm0_oWinL00oo_knookoO_ooOgm`06oooo
o`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;003?ooool0
1?oWinOog]kNoooooooWinL2ono_k`gooooo00?og]kNooooooooool01_ooool00ooNg]kokno_oooo
o`08ooooo`03omkNg_oooooooooo01gooooo00OonOSioj2P/OoQh^[ono[komgMj?oAd=oo`l?E00_o
`/;Dooo2`]<Kol;2dcGoc<gK00Wofm_VonWYlOoooooogn3XojJV]oobl_Coa/K6ono_koo_mnl00_og
moL7ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb?ooooo00[o_LJmo`000?oFe]Ko
0000okFe]Ooooooo:BTYoc4a<On4Q8CoYJFU0_l000000one]KGoooooooooo`0Nooooo`03ooOgmooW
inOo/;2`05Cooooo00OomoOiojFU^?nXZKOocL_Dom?Bg?oAdN7oc<gK0?oocLgL9Oo=cM`dol71d`06
olC4e_o1`=3o]kG2ohn?XOnKVZgomOCg3Oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oF
c^lSooooo`0<okfm_Ol0003omoOgo`000?nUYJGoooooof]cJomkNg_oW9bLooooool0003o:BTY8Ooo
ool00oogmoOoinOWok2`/01Eooooo`05onc/k_n_[kcoKFf5ofETP?m`Kh/0oom`KhXVog1_RSGoL729
00CoK6b5ofUYP_oIfMoojn_^3_ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lSoooo
o`06okFm]Ol0003o8B4Qo`000?nUYJGooooo0_n4Q8@01?n][Jgoooooojf][Ola<C4Qooooo`03ooOg
mooWinOo/;2`05Oooooo00?ojNW]on7QiOoQhND0oooQhNDVon7QiDOooooo0002ooooo`06ono_kom:
U<Ko@W^Uo`PQ>Oli08Coe/k_9Oooool00oo_mnooooooooooo`04ooooo`03od92@_mBDU;o:BTY027o
oooo00?omoOgonOWion`/;00ooooooo7ooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>
kbcooooo00?o]Kfeof=SHon][Jd08Oooool00oogmoOoinOWok2`/03ooooooeCooooo01OoW9cooeYJ
oooooooooooooc4a<Oo?c<Ko5DN_og^Tgon@^^OoR;KWod^Ah?mHW^ooL;Cooh?8oonCgOooOkWNogQc
L?l0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24
omK>kb7ooooo00?okoO_ooOomoooool01ooNimh01_oWinOooooooooooooooooog^ONonO_iaoooooo
00?omoOgonOWion`/;00oooooomDooooo`0GoibLoomJF_oooooooooooola<C7oclc6oaI6[omjX]ko
S;SVohBci_m6SN7oD9[]ofVaoOmla_ooS=[oogRdg_mhLg3o0000of]cJon<S8co]KFeomKFe_o_knl0
G?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lQooooo`04ojf]YOl0003o0000odY:
BP?o8B4Q1olH61P01?lQ8B7o61PHo`000?ne_KD2ooooo`06ooOgmonDU9Co[Jf]ojf][OoWknOoYJFU
5Oooool00oogmoOoinOWok2`/03ooooooeCooooo01OoW9cooeYJoooooooooooooc4a<Oo?c<Ko5TN_
ogbRg_n;^>KoP[;VodJ>hOmBVo3oJ;7nogg3oon;eoooN;?NogQcL?l0003oJg=[ohb<S?ne]KGoe]KF
ono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb;ooooo00?o[Jf]o`000?og
moL03?ooool00ol0003o_LK6ooooo`02ooooo`05ob4Q8Ol0003oYJFUohB4Q?l000005Oooool00oog
moOoinOWok2`/03ooooooeCooooo01OoW9cooeYJoooooooooooooc4a<Oo?c<Ko5DN_og^Tgon?^NOo
QkCVod^@h?mGWNooL;Gnoh?8oonCfoooOKGNogQcL?l0003oJg=[ohb<S?ne]KGoe]KFono_k`1Loooo
o`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb?ooooo00?oYJFUo`000?nma[d02_ooool0
2ooNimko0000olK6a_oooooomoogoooooonma[go0000oooooonDU9Co000000;ooooo00?oinOWonog
koooool04?ooool00oogmoOoinOWok2`/03ooooooeCooooo01OoW9cooeYJoooooooooooooc4a<Oo?
c<Ko5DN_ogbVgonC_NSoR[SXoe2Ch_mMX_7oMKSoohO;oonGhOooPk_NogMcL?l0003oJg=[ohb<S?ne
]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbCooooo00?oYJFU
o`000?o6a/H02Oooool03ooNimko0000okg6a_oooooomooooooooone_KGo0000olk>c_n][Jgo0000
oibLW?lY:BWo0000oaPH600Aooooo`03ooOgmooWinOo/;2`0?ooooooE?ooool05onLW?ooFU[ooooo
oooooooo<C4aolo<a_lEAjooO:SPoiFojOn?^nSoEIOTof2TlOmh^oooSM3ooi_Qoon5_=koMg=`o`00
0?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_
9Oooool00onUYJGo0000olK6aP03ooooo`;omoog0oooool00ooFg]Ko0000okFm]@02ooooo`03ooOg
mol0003oJf][00;o000000GoS8b<og=cLol0003o0000omkWgP0Aooooo`03ooOgmooWinOo/;2`0?oo
ooooE?ooool05onLW?ooFU[ooooooooooooo<C4aolo<a_lEAjooOj_RoiNnjOn@^n[oF9SUofBVloml
_?ooT=7ooj7Woon9_]koMg9`o`000?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002ooooo`06ono_
kom:U<Ko@W^Uo`PQ>Oli08Coe/k_9_ooool00onUYJGo0000olK6aP02ooooo`;omoog1?ooool00oog
moOoooooooooo`02ooooo`06omkWg_ooooooooooonO_iooooooog]kN0_l0000<ooooo`03ooOomooo
oooooooo00?ooooo00?omoOgonOWion`/;00oooooom=ooooo`03omKFoooWioooinOo00Cooooo01Oo
W9cooeYJoooooooooooooc4a<Oo?c<Ko5TN_ogn^honH_n[oT[gZoe^Li_mYZoGoPL7ooiGEoonTjOoo
S<7NogMbL?l0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl8
8CWo>@24omK>kbOooooo00?o[Jf]o`000?o6a/H01?ooool00oogooOoooooooooo`0:ooooo`03ono_
kol0003o000000[ooooo00?oHf=SoibLW?ooool01Oooool00oogmoOoinOWok2`/03oooooodcooooo
00GoknooobTYoolY:Ooo:BWooeYJo`03ooooo`0GoibLoomJF_oooooooooooola<C7oclc6oaE7[oml
[>?oVL7ZoiBnjomOX>SoK:cdoh?2oonGe_ooYncoohk4g_mgLW3o0000of]cJon<S8co]KFeomKFe_o_
knl0G?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lXooooo`03ojFUYOl0003oa/K6
00oooooo00ComoogooooooogmoOo_LK62Oooool01_m[Lf_o0000ono_koo_mnooooooono_k`?ooooo
00?omoOgonOWion`/;00:Oooool00olY:BWo61PHooooo`3oooooob?ooooo00?oe]KooeYJooooool0
0_ooool05onLW?ooFU[ooooooooooooo<C4aolo<a_lEAjooOJcRoi[2j_nC_N_oFY[VofJWl_mo_ooo
TmGooj?Woon<`=koMg9`o`000?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:
U<Ko@W^Uo`PQ>Oli08Coe/k_:Oooool00onUYJGo0000olK6aP0Fooooo`03ooOomooooooooooo00;o
oooo00Co0000od92@_ooooooHf=S0_l000001_oWinOo0000oibLW?ooooooinOWok2`/2Wooooo00Co
0000o`P82?l0003omoOgoooooolRooooo`03okFeoomJF_oooooo00;ooooo01OoW9cooeYJoooooooo
oooooc4a<Oo?c<Ko5DN_ogfYhOnH_^[oSk_[oeJGi?mRY_?oNkcoohoBoonOiOooR;oNogMbL?l0003o
Jg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb[o
oooo00?o[Jf]o`000?nm_Kd02?ooool00om:DT[o:BTYoc4a<@08oc4a<@03obTY:On<S8cooooo00?o
oooo00?oU9BDo`000?ooool00_ooool02?l0003o[Jf]ooooool0003oYJFUooooooo_knoo/;2`2ooo
ool5ohB4Q003og]kNonm_Kgooooo00;ooooo00?okoO_oeYJF_ogmoL00oooool00omJFU[okno_oooo
o`04ooooo`04of]cJomkNg_oNg]kof]cJ`Gooooo00Ko0000obTY:Ooooooooooookfm_OmSHf<2oooo
o`0;of=SHoo6a/Koooooolk>c_mSHf?ooooookFe]On<S8coooooof][JonUYJD01?ooool01?mkNg_o
Lg=cog=cLoo6a/H2ooooo`05ojf][OmcLg?oooooohb<S?nDU9@00_ooool01?oNg]koJg=[of]cJoo_
knl6ooooo`05omkNg_mcLg?oNg]kog=cLonDU9@00oooool03?ne]KGoLg=cof]cJoooooooJf][omkN
g_ooooooFUYJonogkoooooooYJFUog]kN`;ooooo00?oHf=SomkNg_ooool0g?ooool00one]OooFU[o
ooooo`02ooooo`0GoibLoomJF_oooooooooooola<C7oclc6oaE7[omlZ>3oTkgWoh^hjOmBU^CoGjCa
ogJioon<coooVn;oohFlg_mgLg3o0000of]cJon<S8co]KFeomKFe_o_knl0G?ooool000;ooooo00Ko
kno_odZDa_m2NjGo224iocT0Q?oFc^l[ooooo`03og]kNol0003oinOW00Oooooo00?oc/k>okg6a_o6
a/H01?o6a/H2okg6aP04olK6a_nma/Ko_LK6omkNgPCooooo00?oU9BDo`000?ooool00_ooool02?l0
003oJf][ooooool0003oU9BDoooooooWinOo/;2`2oooool6o`000007oe9BD_oooooooooooooooooF
e]Ko0000okfm_@02ooooo`03olk>c_l0003oc/k>00Cooooo00?o<C4ao`000?l000000_l000001ol8
20SoooooooooooooooooDU9Bo`000?m:BTX00_ooool02omBDU;o0000oooooooooooo0000og=cLooo
ooooU9BDo`000?ooooooFUYJ00Co000000CoU9BDooooooooooooDU9B1?l000001Oo>c/kooooood92
@_l0003ooooo00;o000000?oooooono_kol000000ol000000ol820Soooooooooo`02ooooo`03onOW
iol0003o000000?o000000?oS8b<ooooooo6a/H01Ol000001on][Jgoooooo`000?oFe]KooooooaPH
6?l000000_ooool00ol0003oYJFUooooo`3Looooo`03okFeoomJF_oooooo00;ooooo01OoW9cooeYJ
oooooooooooooc4a<Oo?c<Ko5DN_ogbWhOnB_>SoRKOWodjEhomLX_7oM;OoohK:oonFh?ooP[_NogQc
L?l0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24
omK>kb[ooooo00?o[Jf]o`000?nm_Kd05_ooool02?ogooOooooooooooooFe]Ko0000ohb<S?oooooo
S8b<0_l000001_m2@T;o0000omKFc_ooooooinOWok2`/0_ooooo1_l000000omcLg?oooooooooo`02
ooooo`06ohB4Q?l0003o_Kfmokfm_Ol0003oLg=c1?ooool00omBDU;o0000ojFUY@02ooooo`0<onOW
iol0003o<C4aoooooooFe]Ko0000ooOgmol0003o[JfUoooooom[Lf_o00000_ooool04?l0003oQ8B4
oooooonUYJGo0000oooooomcLg?o0000ojf][Ooooooo<C4ao`000?ooooooYJFUo`000?n4Q8@2oooo
o`09oa0@4?l0003oooooof=SHol0003ooooooa0@4?lH61Sooooo00;o00000_ooool00on<S8co<C4a
ooooo`03ooooo`;o00000oooool01OmSHf?o0000ooooooo6a/Ko000000;ooooo00WoLg=co`000?o6
a/Koooooo`000?oWinOooooood92@_l000000_ooool00ol0003o]KFeooooo`3Looooo`03okFeoomJ
F_oooooo00;ooooo01OoW9cooeYJoooooooooooooc4a<Oo?c<Ko5TJ_og^Sgon?^^OoR;GWodZ@h?mF
W^ooKk?noh;8oonBgOooO[WNogQcL?l0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool0
1_o_knooBYC6od9kYOl88CWo>@24omK>kbWooooo00?oYJFUo`000?o6a/H06Oooool03_ogooOooooo
od92@_l0003oooooojFUYOoFe/komoogoiBDU?oFg]KoooooooOgmooWinOo/;2`2oooool6o`000003
og=cLooooooooooo00;ooooo00?oNg]ko`000?l000000_l000000om[Lf_oooooooooo`02ooooo`03
omKFe_nm_Kgooooo00;ooooo00cog]kNo`000?la<C7oooooono_kol0003oinOWo`000?o6a/Kooooo
of][Jol00002ooooo`08o`000?nDU9CooooooibLW?l0003oooooof][Jol00003ooooo`04o`000?oo
oooo[JfUo`0000?ooooo00_o]KFeo`000?ooooooHf=So`000?oooooo410@oaPH6?oooooo0000og]k
N`08ooooo`03ojf][Ooooooooooo00;ooooo00GoHf=So`000?ooooooc/k>o`000003ooooo`08o`00
0?o6a/Koooooo`000?ogmoOooooooc4a<Ol00002ooooo`03o`000?ne]KGooooo0=cooooo00?o]KGo
oeYJooooool00_ooool05onLW?ooFU[ooooooooooooo<C4aolo<a_lFAZooNj7Nohbii_n3/^KoAHgQ
odnIkOmX/?goO<Kooh_Ioomf/mkoNG=`o`000?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002oooo
o`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_:?ooool01?nUYJGo0000okg6a_ooool2ooOom`kooooo
00?omoogooooooooool02Oooool00ol0003oQ8B4ooooo`05ooooo`03ooOgmooWinOo/;2`00_ooooo
1_l000000omcLg?oooooooooo`02ooooo`06oibLW?l0003oooooooooool0003oU9BD1_ooool4o`00
000;oa0@4?oooooooooooibLW?l0003okoO_o`000?n4Q8Coooooog=cLol000000_ooool02?l0003o
Hf=Sooooooo6a/Ko0000oooooom[Lf_o00000_ooool01OnUYJGo0000oooooonDU9Co000000?ooooo
00_oJg=[o`000?ooooooHf=So`000?oooooo410@oaPH6?oooooo0000odY:BP03ooooo`03olk>c_oo
oooooooo00?ooooo00?oQ8B4o`000?l000000_l000001?n<S8cooooookFe]Ol00003ooooo`08o`00
0?o6a/Koooooo`000?nm_Kgooooooe9BD_l00002ooooo`03o`000?ne]KGooooo0=cooooo00?o]KGo
oeYJooooool00_ooool05onLW?ooFU[ooooooooooooo<C4aolo<a_lFAjooO:;Ooh^hi_n3/^KoAhkQ
oe>Kl?mZ/_koO/CoohcHoomi]=koN7=`o`000?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002oooo
o`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_9oooool00onUYJGo0000olK6aP02ooooo`;omoog8_oo
ool00oogmoOoinOWok2`/00;ooooo`Ko000000?oJf][ooooooooool00oooool01?l0003oFUYJof=S
Hol00005ooooo`03olK6a_l0003o20P800?oQ8B40oooool01ol0003oQ8B4oooooonm_Kgo0000oooo
oomkNg/00_l000002?n4Q8Co0000o`000?mSHf?o@T92o`000?ooooooNg]k0_l000001OmkNg_o0000
oaPH6?ooooooinOW00;o000000ooLg=coeYJF_l0003oDU9BoooooomJFU[o0000ooooool820So410@
oooooomkNg_o0000od92@_mcLg<00_l00004ooooo`03of=SHol0003oFUYJ00;oQ8B400Go]KFeoooo
oooooooo[Jf]o`000003ooooo`03o`000?nm_Kgooooo00;o000000OoQ8B4oa0@4?l0003o20P8og]k
Nol0003oYJFU0=gooooo00?o]KGooeYJooooool00_ooool05onLW?ooFU[ooooooooooooo<C4aolo<
a_lEAjooNjCOoi2jion6]>OoBi3PoeRNkoma]OkoQ<WooiCMoomn]]koN7=`o`000?m[Lf_oS8b<okFe
]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_9_ooool01_nUYJGo
0000olK6a_oooooomoogooooo`;omoog0_ooool00oogmoOoooooooooo`06ooooo`05oiBDU?l@413o
410@oaPH6?lQ8B404_ooool00oogmoOoinOWok2`/00;ooooo`Ko000000?oJf][ooooooooool00ooo
ool01?l820SoDU9Bof=SHol00005ooooo`03oe9BD_l0003ooooo00?ooooo00oo8B4Qod92@_oooooo
0000og]kNooooooo[Jf]o`000?ooooooLg=co`000?n4Q8Co0000ob4Q8Oooool00_l000001onDU9Co
ooooof=SHol0003oU9BDo`000?lQ8B401?ooool3o`000008odYBB_oooooooooooe9BD_l0003ooooo
oc4a<Om2@T82ooooo`05of]cJol0003o0000og=cLooWinL01?ooool00ol0003oBTY:ooooo`03oooo
o`04o`000?o_knoo_Kfmo`0000?ooooo00Go0000okFe]Ooooooo0000ojf]Y@02o`000004ooOgmomS
Hf?o0000oc4a<Mkooooo00?oe]KooeYJooooool00_ooool05onLW?ooFU[ooooooooooooo<C4aolo<
a_lEAjooNjOOoi>nion<^>SoDICRoejSlOme^OooR<_ooiSQoon4_=koMg=`o`000?m[Lf_oS8b<okFe
]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_9Oooool00onUYJGo
0000okg6_@08ooooo`03o`000?mBDU;ooooo00Sooooo00?o0000og=cLoooool04_ooool00oogmoOo
inOWok2`/00Hooooo`;o00001_ooool00one]KGo0000obTY:@02okFe]@03od92@_l0003oQ8B4017o
oooo00?oHf=So`000?ooool03?ooool00omBDU;o0000ooooo`02olK6aP_ooooo00Go@T92o`000?n4
Q8Co[Jf]okFe]@02o`000003onOWiooooooooooo0>[ooooo00Coe]KooibLoomJF_ooFU[o0oooool0
5one]OooFU[ooooooooooooo:BTYolo<a_lEAjooO:WQoiNnjOn?^nWoEYSUof2Tl_mi^oooS]7ooicR
oon5_=koMg=`o`000?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^U
o`PQ>Oli08Coe/k_9?ooool01OnUYJGo0000olK>a_oooooomooo00;omoog1Oooool00ol0003oHf=S
ooooo`08ooooo`03o`000?n4Q8Cooooo01;ooooo00?omoOgonOWion`/;006?ooool2o`0000Oooooo
00?o_Kfmo`000?l000000_l000000onDU9Coooooooooo`0@ooooo`03odYBB_l0003ooooo00cooooo
00?o@T92o`000?ooool00_l0000<ooooo`03od92@_l0003o000000;o0000k_ooool01?oFe_ooW9co
oeYJoomJF_l3ooooo`0GoibLoomJF_oooooooooooolY:BWoclc6oaI7[on0[>7oUkkXoi2kj_mHV>Co
IJOcogfmoon@d_ooX^OoohZng_mgLW3o0000of]cJon<S8co]KFeomKFe_o_knl0G?ooool000;ooooo
00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lSooooo`03ojf][Ol0003okoO_00[ooooo00?o0000of=S
Hoooool02?ooool00ol0003oQ8B4ooooo`0Booooo`03ooOgmooWinOo/;2`0?ooooooC?ooool01_o_
kooo:BWoobTYoolY:OooW9coooooo`?o:BWo01KoW9cooooooooooooo:BTYolo<a_lFAjooOZgSoiRo
j_nB_N[oG9gWofZ/mOn2`OooUmKoojGZoon<`]koMg9`o`000?m[Lf_oS8b<okFe]OoFe]Kokno_G?oo
ool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lSooooo`04o`000?lH61SoS8b<of]cJ`Oo
Jf][00CoJg=[ohB4Q?l0003oBTY:2Oooool00ol0003oQ8B4ooooo`0Booooo`03ooOgmooWinOo/;2`
0?ooooooF?ooool04olY:BWoclc6oaE7[oml[>?oV/7ZoiBnjomNWnSoK:_doh;2oonFe_ooYncoohk3
g_mfLW3o0000of]cJon<S8co]KFeomKFe_o_knl0G?ooool000;ooooo00Kokno_odZDa_m2NjGo224i
ocT0Q?oFc^lNooooo`;omoog0oooool00on][JgoYJFUohb<S00:ohb<S003ojf][OoFe]Kooooo00Ko
oooo00CoW9bLob4Q8Ol0003oNg]k4oooool00oogmoOoinOWok2`/03ooooooeSooooo01?o:BTYolo<
a_lEAjooOJcRoi[1j_nB_>[oFIWUofFWl_mn__ooTmGooj?Woon;`=koMg9_o`000?m[Lf_oS8b<okFe
]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_7_ooool2ooOomaWo
oooo00ComoOgonOWiol0003oU9BD4oooool00oogmoOoinOWok2`/03ooooooeSooooo01?o:BTYolo<
a_lEAjooOJWQoiNnjOn>^^_oEIOTof:Vlomj_?ooSM3ooikUoon7_]koMW9_o`000?m[Lf_oS8b<okFe
]OoFe]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_8oooool4ooOom`Wo
oooo00?omoogooooooooool07Oooool00oogmoOoinOWok2`/03ooooooeSooooo01?o:BTYolo=a_lE
>jWoNjKOoi:kion:^>WoCiCSoe^QlOmd^?ooQl_ooiGNoomo^MkoMg9^o`000?m[Lf_oS8b<okFe]OoF
e]Kokno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_9oooool01Oo_mnoo:BTY
oiBDU?mSHf?o@T9202Cooooo00?omoOgonOWion`/;00oooooomHooooo`0CobTY:Oo?cLKo5CJWog^T
g_n>^NOoQKCWodV?h?mEW>koKK7moh76oon>f?ooN;7NogE`K?l0003oJg=[ohb<S?ne]KGoe]KFono_
k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbOooooo00GoLg=cof][JomSHf?o
BTY:o`00000Tooooo`03ooOgmooWinOo/;2`0?ooooooF?ooool04olY:BWoc/c5oaD^Y?meVm_oR[KU
ogf_iOlnQmgoBYG[of:Znome__ooO/_ooffXg_meL6_o0000of]cJon<S8co]KFeomKFe_o_knl0G?oo
ool000;ooooo00Kokno_odZDa_m2NjGo235:ob40c_oFe_lXooooo`04of][Joo>c/ko[Jf]oibLW2Co
oooo00?omoOgonOWion`/;00oooooomHooooo`0CobTY:Oo=c<Go6BZMoe1ecOn4[n?oK:GQobmmfOlj
RNCoDYogof>aoom[^?ooFi??ogYfLOl0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool0
1_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00oooooomHooooo`0CobTY
:Oo>cLSo=D6Io`/f]OlkMlko;GWAob1`d_lePmkoB9CYoeJQm_mLYOWoCGBPohJ3P?l0003oJg=[ohb<
S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?o
moOgonOWion`/;00oooooomHooooo`0Cob4Q8OoBd/ooJFjEo`DVYOl0=kKo0e;1oaMWb_l/N=?o?HKK
odR?hom7QLcoCemboinMW?l0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knoo
BYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00oooooomHooooo`0Cob4Q8OoAdM3o
YJFWod=CT?l5=Jco04Jno`YLa?lMK<_o:WWDoc=fa?m1Gh3oM7Edolk>c_l0003oJg=[ohb<S?ne]KGo
e]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00?omoOgonOW
ion`/;00oooooomHooooo`0Cob4Q8Oo?cloobLW7ojVYZomCHHSo7TNIo`M=/olAEk?o:UbKodIKLomg
MgSoa<?2ooGemOl0003oJg=[ohb<S?ne]KGoe]KFono_k`1Looooo`000_ooool01_o_knooBYC6od9k
YOl88CWo>@24omK>ke3ooooo00?omoOgonOWion`/;00oooooomIooooo`0Bom3@d?o>c/kok>c[okjn
_OnCTi?oPh>3og]kNon7QXKoYjJUomkNgOoinOWon_[jo`000?m[Lf_oS8b<okFe]OoFe]Kokno_G?oo
ool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`03ooOgmooWinOo/;2`0?oooooo
FOooool04_o?clooc<c<ooGemOoclo?oh>3PomSHf?oRh^;ojNWYoo;bl_ojn_[oo_knooclo?l0003o
Jg=[ohb<S?ne]KGoe]KFono_kecooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_D?oo
ool00oogmoOooooool30`03ooooooeWooooo01;od=3@olk>c_odm?Con_[jooShn?oXj>Sohn?Sonc/
k?odm?Coo?clookno_okno_o0000of]cJon<S8co]KFeomKFe_o_knmLooooo`000_ooool01_o_knoo
BYC6od9kYOl88CWo>@24omK>ke3ooooo00GomoOgoooooonl_;coh^;RomoOg`3oon3Ph5Koh>3P00Co
i^KVolg=cOo=cLgom_Kf0_okno/03Oo]kNgoh>3PonOWioo_knoon?Shoo_knooinOWo0000of]cJon<
S8co]KFeomKFe_o_knl0G?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`05
ooOgmooooooo];BdoinOWonNWYh01_nLW9`00onMWIgoW9bLoifMW@02oijNWPCoWIfM2?nLW9`4oifM
W@;oWYjN0onMWId9oibLW0?oWIfM0onNWYh3oifMWOooW9bL9?nLW9`04onKVi_o]KFeok>c/ooDe=Co
dm?Col[:b_nn_[ko_knoolK6a_o=cLgoe=CDomKFe_oBd];o0000of]cJon<S8co]KFeomKFe_o_knl0
G?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^m@ooooo`06ooOgmoooooooa<C4ooOg
moo/k>coi>CT0_oShn<01ooRh^;ohn?Son?ShooRh^;oh>3PomoOgooMgMd00_oNg]h00ooPh>3oh^;R
on?Sh`09on?Sh`03on;Rh_oPh>3og]kN00;ogMgM00?ogmoOon3Ph?oShn<02_oShn<01ooRh^;oh>3P
omkNg_oNg]kogMgMomoOgooQhN40oooShn<Yon?Sh`03on;Rh_oShn?ohn?S00Cohn?S00SojNWYooSh
n?l0003oJg=[ohb<S?ne]KGoe]KFono_kecooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Co
e/k_4Oooool2ooOomb;ooooo0_ogooL00ooooooomoogooooo`05ooooo`;omoog3oooool01OogmoOo
ooooolG5aOo`l?3oi^KV00?oh>3P00cohN7Qon3Ph?oNg]kof][Jolk>c_no_koo];Bdok6a/Oni^KWo
alO7omGEeOoMgMd8on3Ph00:omkNg_oFe]KobLW9ok^k^onb/[;o/k>cokfm_Oo;bl_of=SHomkNgPSo
h>3P00[ofm_Kom;Bd_o4a<Co]kNgok6a/Onf][Ko`/;2om7AdOoKfm_ogmoOoooPh>0Kon3Ph003on7Q
h?oQhN7ohN7Q00WohN7Q00Coh>3Pon7QhOoPh>3ohN7Q0ooPh>002?oUiNGol?3`o`000?m[Lf_oS8b<
okFe]OoFe]Kokno_G?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lAooooo`;omoog
8_ooool2ooOom`03ooooooogooOooooo00;ooooo00?omoogooooooooool00_ogooL?ooooo`05ooOg
mooooooob<S8oo?cloo_knl01?o^k^h03?o]kNgoiNGUolk>c_nUYjOoOXB5ofI/KOmPIfSoL7Ifoi6F
U_nk^k_ofm_KonWYj@KokNg]00cojn_[omoOgoo1`L3oUiRLogAeOOmQHFcoI6A^ogUiPOnNWj;ob<S7
on;Rh_o[jn/6ong]k@0<onSXj?oFe]Ko];>dohf:T?m`JgCoI61ZofiYL_n9QH_o[jj_omCDe?oXj>So
kNg]7?o^k^hDono_kb;ok^k^1_o]kNdDonk^kQCokno_8_o^k^h9ong]kAgok^k^5Oo]kNdRonk^kASo
kno]00Cokno^ono_kOo`l>kokno^0_o_knd6onk^k@;okno]00Gok^k^ono_koo^k^kokno_ong]k@02
onk^kP08ono_kooemOGo0000of]cJon<S8co]KFeomKFe_o_knmLooooo`000_ooool01_o_knooBYC6
od9kYOl88CWo>@24omK>kcWooooo00?o]KFeof=SHon4Q8@05?ooool01OogmoOooooool_;booemOGo
j>SX00;ohN7Q00ooh^;Ron7QhOoKfm_o`l?2ohfCTomKFEWoGd8nogI=AOmoDTWoJdI0oeQ7AOm`MgOo
[:f]om;Bd_oPh>001?oQhN403OoPh>3oe]KFokFe]?mhNh;oF5A8ofQU=_mmOC[oNGTiof=Q=omIEe3o
PhF<okfm_OoHf=P01OoQhN403OoNg]kocLg=oj>RXomZIfgoBETmoeE_>OmSP3koF78iodYK>omTHVGo
W9ZMolW9bOoLg=`0HOoQhN48on3Ph005omoOgooYjNWohn?SonCTi?oVi^H00_oPh>003ooTi>CoinOW
onCTi?oWinOoj^[Zon7QhOoRh^;oj^[Zon?ShooOgmooinOWonSXj?oOgmoohN7Qon[ZjP02on7Qh@0?
on_[jooUiNGogmoOonSXj?oVi^KogmoOon7QhOoZj^[oh^;RomoOgooPh>3oj>SXomoOgooVi^Koi>CT
00Woh>3PO_oQhN401_oQhN3ogMgMomGEe?o9bLOo`<30okjn_@Ko_Kfm00Ko_[jmol30`?o9bLWoe]KF
omkNg_oPh>02on7Qh@09on;Rh_oWinOom?Cdo`000?m[Lf_oS8b<okFe]OoFe]Kokno_05cooooo0002
ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_>_ooool00ol0003o_LK6ooooo`0Cooooo`05ooOg
moooooooc/k>ooOgmoo/k>`00ooTi>@03ooRh^;od];BoijPXOmVEECoWTDkomiiJoojXI7oojfLonfA
Poo6H5;oM40kogamO_nn_koog]kNon?Sh`03onCTi00>omoOgoo7alOoQXN:ofeM??nlY3?oj>=Noooo
N_olo7Oohn1IojfH;omXG4KoTiBGolg=cOoQhN43onCTi00?on?ShooKfm_o];Bdofi`K_m=M2koR<a7
okWdL_oBohCo`OMhoiCGD?mDPbkoIFYTojb/[OoGemOohn?S063oi>CT2?oWinL0:?obl_;oHV9Rob`/
;?ln?SkoVIVIono_kooYjNWo[jn_obd];Olm?CgoPH61oeMGEooMgMgoa/K6oeADE?o1`L7ol_;bohB4
Q?maLG7omOGeomCDe?m4A4CocLg=omCDe?lk>c_oTi>Coo[jn_mZJV[oShn?oo7alOo@d=3oC4a<olK6
a_oIfMWoEUIFoeUIFOli>CWo<c<cojn_[ooZj^X8onOWigkoi>CT00GogMgMolO7b?nHV9WoJ6QXodm?
C`08odM7A`05oe1@D?m]KFgoWYjNol[:b_oNg]h00ooTi>@02?oZj^[om_Kfo`000?m[Lf_oS8b<okFe
]OoFe]Kokno_G?ooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^l8ooooo`;oYJFU0_o_
mnl2ojFUY@;ooooo00[o]Kfeohb<S?oooooo[Jf]oibLW?o_mnooooooomkNg_n<S8coc]KF0_ooool0
1oo6a/KoYJFUolK6a_oNg]koU9BDomKFe_ooool00_ogooL02ooooooomoOgohb<S?nLW9coYJFUonog
konUYJGoc]KFoooooonUYJGoS8b<00?ooooo00[oW9bLojFUYOnLW9coYJFUonOWione]KGomoOgod92
@_nDU9Coino_0_ooool02?nma[go[Jf]omkWg_oNimkoooooohB4Q?oFg]Ko]KFe2Oooool01?ogmoOo
ooooom;Bd_ojn_X4ooKfmP0>oo;bl_oCe=CoRH61oihg<?okOFooojNLoonfZ_oo_:oook:UoonIS?oI
ETWoOT]8ojnf]ooYjNT4ooKfmP0>onc/k?nk_l?oQ71IolnJ:oooiVOooob8ooooUOoooiCooon6oooT
GonmRbKoQg]`olS:cOo_knl3ooKfmP0?ooGemOoShn?oYJ:Vod]d=on4cTCo_?enom3oTooIoicoeOnG
olGoQOnCh4coC7`_oiVHVOoLg=com?Cd06Som_Kf02Won_[jolG5aOodm?Co/;2`ocPh>?oFe]Koo_kn
oeIFE_mlO7cog]kNodY:B_lF5QKok^k^olc<c?lg=cOoa<C4oooooomeMGGoGUiNoooooooNg]ko8B4Q
om7AdOo]kNgoPh>3okno_oono_koDe=Coh:2P_oooooof=SHob`/;?o;bl_oiNGUobTY:On=SHgol_;b
oiBDU?lZ:R[ojn_[ooShn024ooKfmP06oo?clooLg=coVIVIogIfM_nYZJWof=SH1ooNg]h04OoOgmoo
eMGEoj>SXomeMGGoX:2Pon7QhOoemOGom_KfooOgmooemOGoo?clo`000?m[Lf_oS8b<okFe]OoFe]Ko
kno_05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_2?ooool06om2@T;o0000ooOg
moogmoOo0000od92@_ooooooU9BDo`000?n4Q8CoHf=SoaPH6?l0003oooooomKFe_l0003oNg]kodY:
B_o6a/KooooookFe]Ol0003oa/K6obTY:OmSHf?oDU9Bolk>cP02ooooo`0<ono_kom:DT[oLg=cod92
@_l0003okoO_o`000?oNg]koHf=So`000?n4Q8CoFUYJ0_ooool04?lQ8B7o20P8of=SHol0003omoOg
o`000?oFe]Ko<C4aog=cLom:BT[omoOgolK6a_m:BT[oHf=SodY:B_oWinL2of=SH`03olk>c_nDU9Co
oooo00Sooooo00GomoOgoooooooGemOono_koo3`l003on[ZjP0?onGUiOnm_kooPTM5om97>OohQG[o
oiB8oonRU_ooYi[ooijAooj=P?o^KF3oYC0Uoi65Q_oIgMgoj^[Z00;ojn_[00ooj^[ZomgOh?nSW9ko
/FlWoofj?_oofV?oon]dooofP?onmX3oon]coooKH_oi/c?oXV/eok6_/OoRh^<00oo[jn/03ooYjNWo
e]CFofanKom@VaooUMMGojg^L?nlo7ooaOn7ol3oP_namWCoWMmPoeZZ8omNMekocL_=onSXj009on[Z
jPCojn_[;ooZj^X4on_[j`[oj^[Z5_o[jn/9onSXj00Foo7alOnj^[[oBTY:odU9BOoHf=Sokno_ocXj
>_nOWiooo_knojj^[_l`<33ogMgMol71`Oli>CWo^k^kooShn?mbLW;oGEeMoo[jn_oAdM7o92@Tol?3
``;ok^k^013ojn_[oo3`l?mADE7oPH61ooGemOo=cLgo;Rh^ol71`OoFe]Ko>SXjok>c/oofm_Koh>3P
oadM7OnVYZKol?3`1ooYjNTKon[ZjPCojn_[2OoZj^XSon_[j`[oj^[[0oo[jn/Uon[Zj`06on?Si?ne
]KKoNWYkokno_ooalO7oo_kn2?ooool04?omoOgokno_okNg]omlO7co_[jnonKVi_o[jn_oj^[Zono_
kookno_o0000of]cJon<S8co]KFeomKFe_o_knmLooooo`000_ooool01_o_knooBYC6od9kYOl88CWo
>@24omK>k`Sooooo01?oe]K>of][Joooooooooooof][JooFe/kooooooaPH6?n<S8coooooooOgmon]
[JgoS8b<oooooon4Q8Co@T92ooooooo_knooinoW00;ooooo00Ko61PHoooooooWinOog]KNo`P82?ne
_Kd2ooooo`0<olk>c_lQ8B7oooooomkNg_mSHf?oooooobTY:Ooooooo0000olk>c_ooooooc]KF0_oo
ool04On][JgoQ8B4oooooom2@T;ooooooaPH6?oooooo61PHoooooom2@T;oe]KFohB4Q?nLW9comoog
od92@_oooooo20P800?ooooo00?omoogooooooooool01_ooool01_ogmoOoooooomWIfOolo?cokno_
onSXj0;oinOW00oohN7QokVj^_n6:BOoddloonQ_HOohP7Coo925oofDR?omRgoolWQZon=SDonZ:R3o
SfUZomGLg?oVi^H00_oWinL03ooVi^Kof=_NojJAR_o1Ja_oo;Djook6COomeF7oo^1`ookPK_oneV3o
olE:oofd=ondH1ko[jNVomkNg`03onOWi`0?onGUiOoEd=GoBW==oeFP9_n5bTGoV=]Koj[XK_nakgGo
[Neboi_OG_n8cTSoHZd]oca]??o;al_oi>CT06SoinOW02Wokno_oiRHV?lZ:R[oHV9Rom7AdOo_knoo
j>SXoc`l??nNWYkonOWiok>c/old=3Cofm_Kol30`?lh>3So`L71oo_knomeMGGoFe]KoooooooEeMGo
8b<Sol;2`_o]kNgoinOWonSXj?o`l?3oDE5AogYjN_ooooooclo?obd];Oo0`<3oe]KFoc/k>onh^;So
nOWion[Zj_lS8b?oZ:RXono_k`07onSXj7goinOW00Kog]kOoj:RX_nGUiOoe]KFomcLg?oZj^X3ono_
k`;ol?3`0oo_knl04?oYjNWofm_Kom?CdonATI7oZZZZon?ShooWinOoi^KVono_koolo?co0000of]c
Jon<S8co]KFeomKFe_o_knmLooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>k`Sooooo
01;oa/K6o`P82?n4Q8CoQ8B4o`P82?o6c/Koooooob4Q8OmSHf?o0000olk>c_oFg]Ko410@oooooonD
U9Co8B4Qod92@_la<C43ooooo`06oaPH6?oooooo410@of=SHooooooog^ON0_ooool03?o_mnoo@T92
oooooonm_KgoHf=Sooooool0003oooooo`000?mcLg?o0000onOWi`;ooooo017o[Jf]of]cJooooooo
8B4Qooooool0003oooooobTY:Ooooooo@T92omkNg_nUYJGoU9BDooOomom:BT[oooooobTY:@0<oooo
o`05ooOgmooooooofMWIoooooookno/00ooinOT03_odm?Coclo?og`D5?o5?cOoe594on5WFooZMf_o
k7Y]onQbI_oLGU3oddXmoidG5?nGJ6Sok?Cd1?oinOT03_o]l_Co^IVAokaC3oo`Y2SonK0aoo^oB_oj
aUGonlIDooc0Aooj[bcol:@/okA93oo5^;Kol_?c0ooinOT03oohn?SoknW_od1[@_m1Sb?oK;HZogo5
@On@dEGoU]ELoi;EF?n3bDGoKkPZoe2O:ol[HBcoi>3TooOgm`1PooWin@Son_[j01Sooooood];Bomm
OGgoooooooclo?ohn?Sono_kochn?_nYZJWooooookno_olf=SKokNg]omGEeOlK6a_oJVYZoo;bl_mL
G5co9BDUokno_oo:b/[o:RXZomWIfOomoOd2oo[jnP0?oogmoOmDE5Co:BTYolG5aOnl_;co<S8bom[J
f_oYjNWo:BTYofUYJOo[jn_oXj>SoahN7_oalO7ono_k00Oon_[jOOoinOT00oo`l?3o/;2`oi^KV`02
olS8b003olg=cOo@d=3od=3@00Coclo?0_o@d=004?o=cLgob<S8olK6a_nGUiOo^;RhooCdm?oinOWo
n?Shoo[jn_oooooo0000of]cJon<S8co]KFeomKFe_o_knmLooooo`000_ooool01_o_knooBYC6od9k
YOl88CWo>@24omK>k`Sooooo00coa/K>o`P82?nDU9CoU9BDoa0@4?o6a/KoooooolK>a_m2@T;oJf][
onogkomcLg<2oaPH6004oooooomSHf?oBTY:omKFcP;ooooo00OoQ8B4o`000?ooooooc/k>oe9BD_l0
003oW9bL00;ooooo00_o@T92o`000?m2@T;oa/K6o`000?la<C7o_Kfeoooooon][JgoDU9BohB4Q003
ooooo`05o`000?mcLg?oS8b<of]cJolQ8B400_nm_Kd03Ol0003o:BTYof][Jooooooo0000oibLW?lQ
8B7oHf=Sohb<S?l0003o:BTYokfm_Om[Lf/02Oooool05_ogmoOoooooomWIfOoooooomoOgoo7alOoc
lo?ol_;boo3`l?oGf=SoJ24Rok0a;Ono<RGoadPkom5GBooBFTgoce96olDn<Onk;B?oPQXKoi=fM_o`
mOD4oo;blP0>ongblonkWIkoYCXGomb88ooVUQKojj8Yoo6[=Ooa[3CokZ<VonRF5?oJQbWoW38Iol^o
`?o^ko04oo;blP0>oo?`lom@He3o:G@UodbL6omRZR7oLkHeogJj>_me^COoIjlToe2Q6OlcPR[o>U@j
on_Xjoobl_89oo?cla;ol_;b5?oclo<Aoo;blQ7olo?c3oobl_86oo?cl`;ol_;b01SomOGeojj^[_m?
Cdoo<30`ogmoOoojn_[omOGeoe1@D?n/[:cooooool30`?m9BDWoinOWolk>c_m>CTkoLG5aod=3@olb
<S;oYZJVofMWIolS8b?oLW9bonc/k?oemOD2oo?cl`0>ooWinOmXJ6SoJVYZoeaLG?lT92CoOgmooo?c
looLg=co?cloofYZJ_m4A4Co7QhNohb<S?ohn?P3oo?cl`Gol_;b3Ooclo<Boo;blQ3olo?c5Oobl_8A
oo?clQ7ol_;b5ooclo802?o]kN_o_;bkoh>3Ponn_[kod=3@omKFe_oGemOoe]KF1?oEeMD04_oFe]Ko
emOGomKFe_o?cloo^KVioh:2P_o4a<Cok^k^oo?cloobl_;om_Kfooooool0003oJg=[ohb<S?ne]KGo
e]KFono_kecooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_2?ooool01_oFe]KoJf][
ooooooooooooHf=SomKFcP;ooooo00Woe]KFooOomoooooooinoWoooooooFg]KoooooonogkooFg]H0
0oooool03ooWknOooooooooooooooooog]kNomkWg_oooooomooooooooonm_KgoBTY:ooOgmooWinOo
<C4aonogk`03ooooo`03olkFe_oooooooooo00;ooooo00KoinoWooooooo_mnooooooolkFe_ooool2
onogk`0<omKNe_ooooooooooomKNe_oooooog^ONoooooooFg]Ko@T92onOWioogmoOog^ON2Oooool0
1_ogmoOoooooomWIfOoooooolo?con[ZjP?ojNWY00Gog]oOofQ>C_n7;Roo]3/hol9@AP02olILD`06
olEJD?nk@C_oXSHfof@Z:_nQWIgok^o_1?oYjNT03OoZkNgo`kNioh`f<?o5ISCof90gon6R??oRY43o
hJA0on2N>ooFS3So^eP`oh]0?_oCcm001OoYjNT03Oo_knooOgaoobQ=:Om2SSWoHjHgogJa@_mf/DKo
Mk53ofNX>?m6TS[o:ED[of]YJooZj^X0J_oYjNT03Oo[jn_ohN7Qom[Jf_oRh^;oj^[ZonWYjOoUiNGo
inOWon[Zj_oXj>SoiNGUonWYjOoXj>P00_oWinL01ooMgMgoh^;Rong]kOoShn?ogMgMonSXj?oZj^X0
1?oYjNT03?oVi^KojNWYon;Rh_oMgMgoj>SXonk^k_o@d=3o>c/kok2`/?oXj>SogmoOon[ZjXKojNWY
00GoinOWolg=cOmcLg?oVi^Konk^kP03ooooo`04ookno_ooooooooooooknoP?ooooo00GojNWYoi:B
T_miNGWoe=CDonSXj002onWYj@08oo7alOono_ko0000og=cLonDU9Co]KFeomKFe_o_knmLooooo`00
0_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>k`Sooooo00So<C4ao`000?o_mnookoO_o`000?la
<C7oooooooOom`gooooo00?oQ8B4ooOomoooool00oooool2ooOom`?ooooo00?o8B4Qod92@_ooool0
2?ooool00oo>c/koYJFUooooo`0Jooooo`06ooOgmooooooofMWIooooooojn_[om_Kf0_ohn?P03_of
m_Kom_Ogojf/[?mA;RkoYfi_omj_/?oY`L;oj<;1onFm_Oo9TiCoLT51of]KFooUj>SonOWi1?ogmoL0
3Oohn?Sok_7aoi]bLonC?CKoeif:onkB_?oag<ColM_3ong=]oo?SWcoQc4]ojfAT_ocmOD01OogmoL0
3OoinOWof=SHod94@_mBJe?oXL>RolOO`_o:hL?obN73ojW;Z_mMN5ko=SXfolW9bOohn?P02_ogmoLg
ooShn23omoOg2_ofm_H2ooOgm`?om_Kf00GomoOgooKfm_ofm_Kom_KfooOgm`02ooKfmP04ooOgmoof
m_KomoOgooOgm`;om_Kf00?omoOgooKfm_ofm_H02Oofm_H01OoinOWofMWIobd];One]KGooooo00_o
m_Kf7oohn?PfooOgmbSon?Sg00KomoOgoo7alOno_kooMgMgohj>S_nWYjL2ojb/[0Co[Jf]0_n/[:`0
4?nVYZGoRXZ:ogYjN_o8b<Sol_;booOgmoohn?SomoOgooWinOoooooo0000ohB4Q?nLW9co_KfmomKF
e_o_knmLooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>k`Sooooo0_n][Jd2onogk`;o
[Jf]3oooool00on][Jgoooooooooo`08ooooo`03ojFUYOoFg]Kooooo00Sooooo00?og]kNolK6a_oo
ool06_ooool01_ogmoOoooooom_Kfoooooooo_knoo[jnP?on?Sh00gonOWiooKgmon:Rh_oD4E5ojRJ
V_oVg]kol^[[om;6a_mdIVKoFeEEolkAdOoooooomoOg00Gon?Sh00cooOknon7Rh_n5HV?oSeEIomRi
^_oeinWol^;SoljZZon2B4coT7Igong`l?ojno/5ooShn00=ooOgmoono_ko^;NhodU7BOmiNg[od=7A
on[[k?oGemSoQhV7odE3AOnWYJOooOgmooOgm`1QooShn2Won_[j00Cojn_[oi6ATOoHf=SonOWi2ooj
n_YnooShn008ooWin?ogmoOoe=CCojJVY_nHV9SoVIVIoiZJV_nLW9`2oi^KV`07oibLW?nJVY[oVIVI
oiRHV?nXZ:SofMWIooOgm`03ooShn009oo[jn_omoOgoooooo`000?nDU9Co[JfUolK6a_oNg]kokno_
05cooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_<_ooool00oogooOoooooooooo`0K
ooooo`07ooOomoooooooh>3PooOgmoolo?colO7aon_[j`02on[ZjP0;onWYjOo/k>cojnc/ojNXZ?mU
Hf?o?S`lobl];OmBD53oOh20omGFe_o]kNd02?oZj^X02_o/kNgog]oOoiN;Rom^EUOoDC0`oeDg=omb
G5goXiZJonKWioo/k>`8on[ZjP09ong]kOo7alOoLW5bodQ7B?l/:bco@T52of]ZJonl_;cokNg]06?o
j^[Z:Oo[jn/00oo]kNgon_[joo3`l00<on_[jh3oj^[Z00?ok^k_oo7alOo`l?002?o_knl00oo`l?3o
lO7aonk^kP04on[ZjP09ono_koojn_[ono_ko`000?n][JGo_KfmomKFe_oWinOomoOg05cooooo0002
ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_D?ooool01_ogooOoooooonKVi_oPh>3oooooooSh
n0Golo?c0_oemOD01oo`l?3ojn_[on[Zj_o]kNgol_;booKfm_odm?@02Ooclo<02?oem_Kol_?conk^
k_o[j^[ok>[Zono_koocm?Com_Ge2Ooclo<02Oodm?Com_Kfoo7alOo/k>coj^[Zon_[jooalO7omOGe
ooCdm03ooo?clb[olo?c00col_;boo?clooclo?olo?cooShn?ono_koj>SXo`000?o6a/Koe]KFonOW
ioo_knmMooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ke3ooooo00Komoogoooooooe
mOGog]kNon;Rh_ojn_[ooooooeoooooo00Soo?clonSXj?oKfm_o01PaomkNg_oWinOokno_ooOgmego
oooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_6oooool00oogooOoooooooooo`0Coooo
o`03ooOomooooooooooo01cooooo00OomoogoooooooinOWom_Kfon?ShooPh>3oh^;R0?oogmoOGOoO
gml2on7Qh@05on3Ph?oclo?oW:f]ono_koogmoL0Goooool000;ooooo00Kokno_odZDa_m2NjGo224i
ocT0Q?oFc^mBooooo`06oo_knoojn_[on?Shoo?cloo^k^kokNg]0_o/k>`2on_[j`Coj^[ZoooYjNU<
onWYj@Coj^[Z00?ojn_[onc/k?o/k>`00_o]kNd00oobl_;on?Shoo[jnP1Rooooo`000_ooool01_o_
knooBYC6od9kYOl88CWo>@24omK>kooooooooooooolKooooo`000_ooool01_o_knooBYC6od9kYOl8
8CWo>@24omK>koooooooC?ooool00oogooOooooooaPHU002ooooo`09omkNionD>LKoe/kNolkFa_nD
U9CoFUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KFoiBDU?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`PaB_n4
Q8Co_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>koooooooB_ooool3
ooOom`0=oooooolH69CooooooooooooNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co]KFeolK6aP02
okg6aP0;olkFe_nDU9CoFUYJokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;o
oooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^oooooood[ooooo0oogooL03Ooooooo61RDoooooooo
oooog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BDoeYJF_nm
]Jgo64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ
>Oli08Coe/k_oooooom:ooooo`?omoog00gooooooaPHU?ooooooooooomkNionD>LKoe/kNolkFa_nD
U9CoFUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KFoiBDU?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`PaB_n4
Q8Co_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kb;ooooo0_ogooOo
ooooobSooooo00?omoogoooooolH69@00_ooool02OoNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co
]KFeolK6aP02okg6aP0;olkFe_nDU9CoFUYJokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0
/oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^lRooooo`;omoog?Oooool00oogooOo
ooooooooo`3Wooooo`03ooOomooooooo61RD00;ooooo00Wog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[o
U9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BDoeYJF_nm]Jgo64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgo
kno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_HOooool2ooOomn;ooooo00?o
moogooooooooool00oooool00oogooOooooooaPHU002ooooo`09omkNionD>LKoe/kNolkFa_nDU9Co
FUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KFoiBDU?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`PaB_n4Q8Co
_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbKooooo00?oc/k>omKF
c_ooool0<_ooool2ooOomnSooooo00Go:BVLoaPHU?lH69Co61RDooooo`02ooOom`0=oooooolH69Co
oooooooooooNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co]KFeolK6aP02okg6aP0;olkFe_n<S8co
FUYJokfe[OlaDV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_odZDa_m2
NjGo224iocT0Q?oFc^lUooooo`04onOWiol0003o0000ohB4Q3;ooooo0_ogooL6ooooo`03ooOomooo
oooooooo0>;ooooo00Ko61RDoooooooooooomoogoooooolH69@2ooooo`09omkNionD>LKoe/kNolkF
a_nDU9CoFUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KFohb<S?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`Pa
B_n4Q8Co_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>kbKooooo00?o
e]KFobTY:Ol00000oooooolKooooo`;omoog0oooool01_lH69CoooooooOomoogooOooooooaPHU0;o
oooo00Wog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BDoeYJ
F_nm]Jgo<E9[od9kYOlYNkGo235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^U
o`PQ>Oli08Coe/k_1oooool00oo>c/ko_Kfeokg6_@02okg6_@;o_Kfm0_ooool01?ogooOoooooolk>
c_nma[d4ooooo`03ojf][Onma[gooooo00;ooooo00?omoogoooooooNimh00_nm_KD00one_KGooooo
ooooo`02ooooo`03oeYJF_l0003oQ8B400;ooooo00koe]KFojf][Oooooooooooojf][OoFe]Kooooo
onogkon][JGomoogooooooo6c/Koc/k>ooooo`;o]KFe00Oog^ONooooooogooOooooookg6_Onm_Kgo
]Kfe00?ooooo00Go[Jf]onO_iooooooog^ONojf][@04ooooo`;o]KFe00?okno_ooooooogooL01Ooo
ool03one]KGo_KfmokFe]OogooOoooooooOooooooooo_LJmokfm_Oo6a/Koooooojf][OooooookoO_
ojf]Y@02ooooo`;o_LJm0_ooool00on][JgoinoWooooo`3Gooooo`06oaPHU?oooooomoogooOomooo
oooo61RD0_ooool02OoNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co]KFeolK6aP02okg6aP0;olkF
e_nDU9CoFUYJokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^l7ooooo`03obTY:Ol0003o000000Co00000oooool00onm_KGo0000
o`P82003ooooo`03ojFUYOl0003o]KFe00Cooooo00?okno_o`000?l000000_l000002on<S8cooooo
ooooooooooooFUYJo`000?l@413okno_oooooom2@T;o000000;ooooo00[o0000od92@_oooooo]KFe
o`000?oFe]Koooooob4Q8Ol0003o410@0_l000001?n4Q8Cooooooooooon][JD3o`000008ohb<S?oo
oooomoOgo`000?nDU9Coooooof][Jol00003ooooo`05oaPH6?l0003o0000o`000?oWknL01Oooool0
0omBDU;o0000o`000002o`0000;ooooo00_oW9bLo`000?l0003o0000obTY:Ol0003oooooojFUYOl0
003okoO_ooooo`02o`000004ooooooo_mnoo0000oiBDU=Sooooo00Ko61RDooooooogooOomoogoooo
oolH69@2ooooo`09omkNionD>LKoe/kNolkFa_nDU9CoFUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KF
oiBDU?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool01_o_knoo
BYC6od9kYOl88CWo>@24omK>k`Oooooo00?oBU9:o`000?l000001?l00004ooooo`03oaPH6?l0003o
000000Co000000GoooooooOomoooooooooooooOgm`02o`00000>omkNg_ogooOoooooo`000?nDU9Co
oooookFe]Ol0003o20P8o`000?oFe]Koooooof=SHol00002ooooo`0Ko`000?mSHf?oooooolK6a_l0
003oinOWoooooom:DT[o0000of=SHooooooo[Jf]o`000?ooooooa/K6o`000?lH61Sooooood92@_l0
003oYJFUooooool0003oYJFUoooooon4Q8Co000000;ooooo00Co8B4Qo`000?n][Jgog^ON0_l00004
ooooo`03od92@_l0003oJg=[00;ooooo00OoBTY:o`000?oooooo8B4Qo`000?ooooookno_00;o0000
00Gooooookfm_Ol0003omoooooooo`02oa0@40;ooooo00?o0000ojFUYOooool0eoooool01_lH69Co
ooooooOomoogooOooooooaPHU0;ooooo00Wog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6
a/H00_nma/H02oo>e]KoU9BDoeYJF_nm]Jgo64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo
0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_1oooool00om:DT[o0000o`000004o`0000Co
oooo00Oo61PHo`000?lH61SoDU9Bob4Q8Ol0003oJg=[00Cooooo00?omoOgobTY:OogooL00_ooool0
3?oWinOo0000of][Jooooooo]Kfeo`000?oooooo0000og=cLoooooooHf=So`0000;ooooo00Wo0000
of=SHoooooooa/K6o`000?oWinOooooooc4a<Ol000000_ooool01OoFe]Ko0000oooooone]KGo0000
00?ooooo00So0000ohB4Q?oooooo0000ojFUYOooooooQ8B4o`0000;ooooo00?o0000od92@_ooool0
1?ooool01OogoooooooooooooomcLg?oHf=S00?ooooo00Go<C4ao`000?oooooo@T92o`000002oooo
o`05omkNg_l0003ooooookfm_Ol000000_ooool2oa0@4004ooooooogoooo0000ojFUYM?ooooo0_og
ooL3ooooo`06oaPHU?oooooomoogooOomooooooo61RD0_ooool02OoNg^OoU3W6omK>g_o>e/KoU9BD
oeYJF_nDU9Co]KFeolK6aP02okg6aP0;olkFe_nDU9CoFUYJokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4
okfm_Oo_knl0/oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^l7ooooo`03odYBB_l0
003o000000Co00001?ooool01_o6a/Ko0000ojf][Oooooooe]kFo`0000Cooooo00Comoogoooooooo
ooooW9bL0_m2@T82o`000005onogkooooooo410@o`000?oNg]h00_l000000oooooooJf][o`000002
ooooo`09o`000?mSHf?oooooomkWg_l0003og^ONoooooom2@T;o000000;ooooo00Goe]KFo`000?oo
oooo]KFeo`000003ooooo`08o`000?n4Q8Coooooo`000?nUYJGoooooohB4Q?l00002ooooo`03o`00
0?m2@T;ooooo00Cooooo0_ogool3ooooo`;o@T9200Ko20P8o`000?nDU9Cooooooc4a<Ol00002oooo
o`05olK6a_l0003ooooookfm_Ol000000_ooool2oaPH60;ooooo00?o0000ojFUYOooool0doooool0
1_ogooOooooooooooooooooo61RDooooo`;omoog00gooooooaPHU?ooooooooooomkNionD>LKoe/kN
olkFa_nDU9CoFUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KFoiBDU?mJFU[o_KF]oc5BJom2NjGoBYC6
o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>k`Oooooo
00?oBU9:o`000?l000001?l00005ooooo`;o000000Coooooohb<S?l0003omoog1Oooool01On4Q8Co
0000o`000?l0003o410@00?ooooo00[o0000ojFUYOooooooQ8B4o`000?ooooooNg]ko`000?la<C7o
oooo0_l000002One]KGo_Kfeo`000?oFg]KoooooodYBB_l0003oDU9Booooo`02o`00000>ooooooo>
c/ko0000oa0@4?oooooo:BTYo`000?n][Jgoooooo`000?nUYJGoooooohB4Q?l00002ooooo`04obTY
:Ol0003oW9bLolkFeP;o00000_ooool00oogooOoooooooOgm`04o`000005ojf][Ooooooooooooc4a
<Ol000000_ooool01?nma/Ko0000oooooonma[d2o`000007oooooolQ8B7o0000og=cLoo_mnoo0000
oiBDU03Hooooo`06oaPHU?oooooomoogooOomooooooo61RD0_ooool02OoNg^OoU3W6omK>g_o>e/Ko
U9BDoeYJF_nDU9Co]KFeolK6aP02okg6aP0;olkFe_nDU9CoFUYJokfe[OlaDV_o@W^UodZDa_l8<D[o
Q8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^l7ooooo`03obTY
:Ol0003o000000Co00001Oooool01OoNg]ko0000ooOgmol0003o]KFe00Gooooo00CokoO_o`000?m:
BT[oYJFU0_ooool03?mkNg_oe]KFohB4Q?l0003oW9bLoooooomkNg_o0000ojFUYOmSHf?o0000obTY
:@;o000000CoQ8B4o`000?l0003o410@0_ooool00om2@T;o0000ob4Q8@02o`000004ohB4Q?oooooo
oooookFe]@?o000000SoU9BDoooooooooooo0000ojFUYOooooooLg=co`0000?ooooo00Go61PHo`00
0?l0003o0000ooOgm`04ooooo`03ob4Q8Ol0003oQ8B400;ooooo00GoinOWof]cJooooooo61PHo`00
0002ooooo`06okFe]Ol0003oooooojFUYOl0003o@T920_l000001On4Q8Co0000o`000?l0003og]kN
0=Sooooo00Ko61RDooooooogooOomoogoooooolH69@2ooooo`09omkNionD>LKoe/kNolkFa_nDU9Co
FUYJoiBDU?ne]KGoa/K600;o_LK600_oc]KFoiBDU?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`PaB_n4Q8Co
_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>k`Oooooo00?oe]kFolK>
a_o>c/h00oo>c/h00oo6c/Koooooooooo`03ooooo`05okg6a_l0003o8B4Qo`000?nUYJD01Oooool0
0oogmoOo0000okfm_@02ooooo`0Bof=SHol0003oNg]kolk>c_nm_Kgoino_oooooooWinOo_Kfmoooo
oooNimkoc/k>oooooonma/Koe]kFoooooooWinOo_LK60oooool01_la<C7o0000ooooooo6c/Koa/K6
onO_i`?ooooo0_o>c/h02oo6c/Kooooooooooooooooo0000ojFUYOooooookno_okfm_Ooooooomooo
00;ooooo00Goa/K6olK>a_ogmoOoooooooOom`03ooooo`05oc4a<Ol0003ooooooooooooNimh00_l0
00000oooooooe]kFokg6aP02ooooo`0>ooOgmone_KGoooooonogkonm_Kgooooookg6a_o6c/Kooooo
ooOomonma/KoinoWooooooogooOGooooo`06oaPHU?ooooooooooooOomooooooo61RD0_ooool02OoN
g^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co]KFeolK6aP02okg6aP0;olkFe_nDU9CoFUYJokfe[OlH
BV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0
Q?oFc^lDooooo`03oe9BD_l0003o<C4a00Oooooo00?oa/K6o`000?l000000_l000000omSHf?ooooo
ooooo`02ooooo`03ooOooooooooooooo00Kooooo00SomoogooooooooooooooooooOooooooooo61PH
o`0000cooooo00KokoO_o`000?nDU9Coooooog=cLol00007ooooo`03ooOomooooooooooo00?ooooo
00?o8B4Qo`000?l000000_l000001?ogmoOoooooooooooooool2ooOom`Sooooo00?omoogoooooooo
ool0f_ooool00olH69CoooooooOoo`02ooooo`0<oaPHU?ooooooooooomkNionD>LKoe/kNolkFa_nD
U9CoFUYJoiBDU?ne]KGoa/K60_nma/H02oo>e]KoU9BDoeYJF_nm]Jgo64Y[od9kYOm:U<Ko235:ohB4
Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_3Oooool00oogooOo
ooooooooo`04ooooo`03okg6_On4Q8Co]Kfe00Sooooo00Co_LJmohb<S?n<S8coS8b<1Oooool00oog
ooOoooooooooo`0:ooooo`04ooOomooooooo[Jf]ohb<S0?ooooo00?omoogooooooooool01oooool0
1OmcLg?oe]kFooooooo6c/KoLg=c00kooooo00CoQ8B4ohb<S?n<S8coinOW1?ooool2ooOomnGooooo
00?o61RDooooooogooL00_ooool03?lH69CooooooooooooNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nD
U9Co]KFeolK6aP;o_LK600_oc]KFoiBDU?mJFU[o_KF]oaQ:Jom2NjGoBYC6o`PaB_n4Q8Co_Kfmono_
k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>ka?ooooo00Gomoogoooooooooooo
ooooooOom`06ooooo`03ooOomooooooooooo00Cooooo0_ogooL?ooooo`04ooOomoooooooooooooOo
m`[ooooo00GomoogooooooooooooooooooOom`0>ooooo`03ooOomooooooooooo00?ooooo00?omoog
ooooooooool0i_ooool2olJmgP03oaPHU?oooooooooo00;ooooo00co61RDoooooooooooog]kWoi@i
a_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H2okg6aP0;olkFe_nDU9CoFUYJokfe[OlHBV_o@W^U
odZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^l=
ooooo`05ooOomoooooooooooooooooogooL0ooooooleooooo`03oe9BU?m:BZgo61RD00Cooooo00co
:BVLoooooooooooog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H2okg6aP0;olkFe_nD
U9CoFUYJokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_odZD
a_m2NjGo224iocT0Q?oFc^ooooooodKooooo0om:BZd01_lH69Cooooooe9cS?lH69Co:BVLob40cP;o
oooo00Wog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BDoeYJ
F_nm]Jgo64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^U
o`PQ>Oli08Coe/k_oooooom6ooooo`09omkNkooNg^Oog]k_ooOgmoooooooinOWomkNiooNg^ookoO_
00;ooooo00Wog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BD
oeYJF_nm]Jgo64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko
@W^Uo`PQ>Oli08Coe/k_oooooom:ooooo`03ooOomooooooooooo00Cooooo00Wog]kWoi@ia_oFc]ko
c]K6oiBDU?mJFU[oU9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BDoeYJF_nm]Jgo64Y[od9kYOm:U<Ko
235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_oooooom9
ooooo`?omoog1Oooool02OoNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co]KFeolK6aP02okg6aP0;
olkFe_nDU9CoFUYJokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Ko
kno_odZDa_m2NjGo224iocT0Q?oFc^oooooooe7ooooo00Wog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[o
U9BDokFe]Oo6a/H00_nma/H02oo>e]KoU9BDoeYJF_nm]Jgo64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgo
kno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_oooooomAooooo`09omkNionD
>LKoe/kNolkFa_nDU9CoFUYJoiBDU?ne]KGoa/k600;o_LK600_oe]KFohb<S?mJFU[o_KF]oaQ:Jom2
NjGoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>
koooooooDOooool02OoNg^OoU3W6omK>g_o>e/KoU9BDoeYJF_nDU9Co]KFeolK6aP02okg6_@0;olk>
c_nDU9CoDU9Bokfe[OlHBV_o@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_
odZDa_m2NjGo224iocT0Q?oFc^oooooooe7ooooo00Oog]kWoi@ia_oFc]koc]K6oiBDU?mJFU[oW9bL
00GoU9BD00[oW9bLohB4Q?n][Ico64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_/oooool000;ooooo
00Kokno_odZDa_m2NjGo224iocT0Q?oFc^oooooooe7ooooo00Sog]kWoi@ia_oFc]koc]K6ohb<S?mJ
FU[o[Jf]ojFUY@Ko[Jf]00So[JfmoaQ:Jom2NjGoBYC6o`PaB_n4Q8Co_Kfmono_kk?ooooo0002oooo
o`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_oooooomAooooo`09omkNionD>LKoe/kNolkFa_nDU9Co
FUYJoiBDU?mSHf?oDU9B00;oFUYJ0omSHf<02?nma/Ko64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_
/oooool000;ooooo00Kokno_odZDa_m2NjGo224iocT0Q?oFc^oooooooe7ooooo00Wog]kWoi@ia_oF
c]koc]K6oiBDU?mJFU[o[Jf]ohB4Q?n<S8`00_nDU9@02on4Q8CoDU9BohB4Q?ne]JGo64Y[od9kYOm:
U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_oooo
oomAooooo`0FomkNionD>LKoe/kNolkFa_n<S8coFUYJojf][OnLW9coe]K>omKFe_oNimko]Kfeoe9B
D_nUYJGo]KFUoaQ:Jom2NjGoBYC6o`PaB_n4Q8Co_Kfmono_kk?ooooo0002ooooo`06ono_kom:U<Ko
@W^Uo`PQ>Om20:Goe/k_oooooomAooooo`07omkNionD>LKoe/kNolkFa_n<S8coFUYJokFe]@02oibL
W00=olk>c_oFe/koDU9BohB4Q?ne]KGo[JfLoaQ:Jom2NjGoBYC6o`PaB_n4Q8Co_Kfmono_k`2coooo
o`000_ooool01_o_knooBYC6od9kYOl8<D[o8@3>omKFooooooooDOooool05_oNg^OoU3W6omK>g_o>
e/KoS8b<oeYJF_ne]KGoYJFUoiBDU?nma[goW9bLoeYJF_nUYJGo[Jf]ojf]W?lHBV_o@W^UodZDa_l8
<D[oQ8B4okfm_Oo_knncooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omK>koooooooDOoo
ool01_oNg^OoU3W6omK>g_o>e/KoS8b<oeYJFP;o[Jf]00koU9BDokFe]OmcLg?oLg=cokFe]OnUYJGo
[JfLoaQ:Jom2NjGoBYC6o`PaB_n4Q8Co_Kfmono_kk?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ
>Oli08Coe/k_oooooomAooooo`06omkNionD>LKoe/kNolkFa_n<S8coFUYJ0_n][Jd00onUYJGoW9bL
of=SH`02ojf][@09ojFUYOn][Ico64Y[od9kYOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002oooo
o`06ono_kom:U<Ko@W^Uo`PQ>Oli08Coe/k_oooooomAooooo`07omkNionD>LKoe/kNolkFa_n<S8co
FUYJokFe]@02ojf][@0=ojFUYOnDU9Co[Jf]okFe]On][Jgo]KFUoc5BJom2NjGoBYC6o`PaB_n4Q8Co
_Kfmono_k`2cooooo`000_ooool01_o_knooBYC6od9kYOl88CWo>@24omKFooooooooDOooool01_oW
ioOoU3W6omkNiooFg]KoU9BDodY:BPOoHf=S00WoFUYJohB4Q?laDV_o@W^UodZDa_l8<D[oQ8B4okfm
_Oo_knl0/oooool000;ooooo00Ookno_odZDa_m2NjGo224iocTiNoo>c/kog]kF0?ooe]kFCooFg]H0
1_oNg]koa/K6ohB4a_o6a/Ko_LJeoibLW0WoQ8B400SoU9BDoaQ2F_m2NjGoBYC6o`PaB_n4Q8Co_Kfm
ono_kk?ooooo0002ooooo`06ono_kom:U<Ko@W^Uo`PQ>Ola@T[oLg=coomBDU9Aoe9BDP03oeYJF_mS
Hf?oFUYJ00;oHf=S2OmcLg<02?n4Q8Co649Jod9kYOm:U<Ko235:ohB4Q?nm_Kgokno_/oooool000;o
oooo00Ookno_odZDa_m2NjGo01Paod9BD_nDU9CoLg=c0?ooNg]kGomkNg/01ol8<D[o@W^UodZDa_l8
<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Gokno_odZDa_m2NjGo01Paoc52BP02omKNeP03olkF
e_oFe]Koc]KF00Koe]KF00?oc]KFomKFe_oFe]H01_oFe]H00oo>e]Koe]KFomKFeP09omKFeP04olkF
e_oFe]Koc]KFolkFeP?oe]KF00Goc]KFomKFe_oFe]Koe]KFolkFeP0BomKFeP03olkFe_oFe]Koe]KF
00Koe]KF00Coc]KFomKFe_oFe]Koc]KF4ooFe]H00oo>e]Koe]KFomKFeP0:omKFeP;oc]KF4OoFe]H0
0oo>e]Koe]KFomKFeP03omKFeP04olkFe_oFg]Koe]kFolkFeQOoe]KF00?oc]KFomKFe_oFe]H0;_oF
e]H00oo>e]Koe]KFomKFeP04omKFeP;oc]KF2OoFe]H01?o>e]Koe]KFomKFe_oFe]H2olkFeP;oe]KF
0oo>e]H3omKFeP03olkFe_oFe]Koe]KF05[oe]KF1?o>e]H02?oFe]Koc]KFolkFe_o>e]Koe]KFomkN
g_o>e]Koe]KF1Oo>e]H02OoNimkoa/Jeo`PQ>Om2NjGoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`00
0_ooool01oo_knooBYC6od9kYOl0637o<D9:olk>c_o6a/H07_nma/H2okg6_@Ko_LK600?o_LJmokg6
a_nma/H0FOnma/H00oo6a/Ko]Kfeokg6_@1Ookg6aP;o_LJmIonma/H01?nma[go_LK6okg6a_nma[d2
okg6aP03olK6a_ne]KGoa/K600Ko_LK600Woc/k>okFeYOl88CWo@W^UodZDa_l8<D[oQ8B4okfm_Oo_
knl0/oooool000;ooooo00Ookno_odZDa_m2NjGo01Paoc52B_o>c/koa/K600;o_LK600_o_LJmomKF
e_o>c/ko_LJmokg6a_nma[goc]KFonOWiooFg]Ko_LJmolK6aP02omkWgP06olK6a_nma[goe]kFomkW
g_o>e]Ko_LJm2_nma/H03?oNimkoinOWonOWiooFg]Ko_LK6omkWg_oWinOog^ONolK>a_o>e]KoinOW
omKNeP;o_LJm00?oc/k>omkWg_o6c/H02_nma/H04_nma[goe]kFomkWg_oFg]Ko_LJmolK>a_oWimKo
g^ONolK6a_nma[gog^ONonOWioo>c/ko_LJmolkFe_oNimkoe]kFokg6_@Wo_LK600?o_LJmomKFe_o6
c/H00_nma/H01_nma[goe]KFomkWg_oFe]Koa/K6omKNeP;o_LK600Oo_LJmolkFe_o>c/ko_LJmomKN
e_o6c/Koc]KF00;oinOW00Goe]KFokg6_Oo>c/kog^ONolK>aP0:okg6aP06okg6_OoFe]KoinOWomKN
e_o6a/Koe]kF0_nma/H03_ogoooo8B4Qohb<S?oFg]Ko_LK6okg6_OoFe]Kog^ONomKFe_o>e]Ko_LJm
olk>c_oNimkoa/k62?nma/H2okg6_@03olk>c_o>e]Ko_LJm00?oc/k>0_oNimh00oo6a/Koe]KFolk>
cP02okg6_@06olk>c_o>e]Ko_LJmolk>c_o>e]Koa/k60_oNimh01_o6c/Ko_LJmomKNe_oNimkoc]KF
okg6_@Wo_LK600?oa/K6omKFe_nma[d00_nma/H00onma[gog^ONomkWgP02olk>cP08olkFe_nma[go
c/k>olkFe_o6c/Kog^ONonOWiooNg]h9okg6aP07okg6_Oo>c/koe]KFokg6_Oo>e]Koc/k>olK>aP02
omkWgP07olK6a_oFe]Koc/k>okg6_OoFg]Koa/k6olkFeP02onOWi`07olkFe_o6c/Kog^ONomkWg_o6
c/Ko_LK6omKFeP02olkFeP03okg6_Onma/Ko_LK604oo_LK600Koa/K6omKNg_nma/Koa/K6omKFe_nm
a/H2omkWgP09olk>c_nma[goe]K>onOWiooNg]koc]KFo`000?o>c/koa/K600Go_LK600Woc/k>okFe
YOl88CWo@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo01Cokno_odZDa_m2NjGo01Pa
oc52B_o>c/koa/K6okg6a_nma[goe]kFof=SHonUYJGoc/k>okg6_OoFe]KoNg]koaPH6?m:BT[og]kN
okFm]@;o61PH00Ko_KfeonOWiom:BT[o61PHog]kNooFg]H9okg6aP07omKFc_la<C7o8B4QoaPH6?m:
BT[okoO_od92@P02oaPH600:olkFe_n4Q8Co61PHodY:B_oFe]Koe]kFoiBDU?l@413o]KFeolk>cPWo
_LK601;og^ONog=cLolH61SoFUYJonOWionma/Ko235:oaPH6?nm_Kgoe]kFod92@_lH61SoS8b<onO_
iomkNg_o61PHodY:B_oFe]H9okg6aP0DomKNe_mBDU;o[Jf]olK>a_nma/Kog]kNog=cLolH61SoHf=S
onOWiom:BT[oc/k>okg6a_oFg]KoHf=SojFUYOo_mnooFUYJolk>c_n<S8`2oaPH6006ohB4Q?o_mnoo
U9BDoa0@4?ne]KGoc/k>2Onma/H05ooFg]KoJf][oaPH6?mSHf?og]kNodY:B_o>e]Ko]KFeog=cLom:
BT[oS8b<omKNe_oFe/kog^ONohB4Q?lH61SoS8b<og]kNoo_mnooU9BDoa0@4?ne]KGoc/k>00So_LK6
00Coe]K>oiBDU?m[Lf_okoO_0_n4Q8@01_o>c/ko61PHoaPH6?oFg]KoJf][oibLW0;oc/k>00KoYJFU
of=SHooWknOoU9BDog]kNooFg]H2oaPH6006okFe]OoNimkoBTY:oaPH6?n4Q8Coe]KF2Onma/H00oo6
a/KoBTY:olk>cP02okg6_@0:olkFe_m2@T;o61PHoibLW?n][JgoHf=SonO_ionDU9CoNg]komKNeP;o
61PH00?o@T92omKNe_nma/H00onma/H2okg6_@;o_LK6013oc]KFoiBDU?mcLg?oooooohB4Q?n<S8co
_LJmoaPH6?lQ8B7og]kNof=SHonLW9coinOWoe9BD_o6c/KoS8b<0_lH61P02_n<S8coe]kFoaPH6?lH
61Soa/K6onO_iomSHf?oQ8B4og]kNooNg]iAokg6aP0BolK6a_m:BT[oc]KFokFm]OmBDU;okoO_od92
@_lH61SoS8b<onO_ion4Q8Co61PHodY:B_o_mnoo410@omKFc_o>c/koc]KF1?nma/H02Oo>c/ko]KFU
o`PQ>Om2NjGoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool05?o_knooBYC6od9kYOl0637o
<D9:olk>c_o6a/Ko_LK6okg6_OoWknOo61PHohB4Q?oFg]Ko_LJmolK6a_o>c/ko0000oibLW?oFe/ko
g^ON0_m2@T801oooooooDU9Bog=cLoo_mnooHf=SojFUYOo>c/h02?nma/H04oo>c/ko0000okFe]OnL
W9coa/k6odY:B_mcLg?oe]KFo`000?n][Jgog]kNo`000?nLW9coe]kFojFUYOlH61So]KFeoc4a<Oo>
c/h02?nma/H03_oFg]KoQ8B4oc4a<Oo>c/koFUYJohB4Q?la<C7oe]Koojf]_OmBDU;oinOWohB4Q?l0
003oe]kF0_o>c/h00ol0003oW9bLolk>cP05okg6aP0Cokg6_Onma/Ko_LK6okg6a_oWknOo20P8oibL
W?o>c/koe]kFohB4Q?la<C7oe]KFodYBB_mcLg?o410@omKNe_nma/KoinoWobTY:@02of=SH`0;od92
@_mSHf?o<C4aoooooom[Jf_oBTY:olk>c_lH61So]KFeoc4a<Oo>c/h02Onma/H05oo6c/Ko_LJmo`00
0?ne]KGoe]KFo`000?oNinOo]KFeob4Q8OmSHf?o0000oa0@4?n4Q8CoYJFUoc4a<Oo6a/Ko0000oe9B
D_o>c/ko61PHokFe]Ola<C7oc/k>00So_LK601;og]kNof][Jom2@T;ooooooc4a<OmcLg?o<C4aomKF
e_ne]KGoQ8B4oc4a<On4Q8Coe]kFomKFe_n4Q8Co61PHoooooom[Jf/2odY:BP08olK6a_o6a[goDU9B
omkNg_nLW9co0000olk>c_o6a/H5okg6aP07okg6_Onma/Ko_LK6okg6a_o6a/Ko0000omKFeP02okg6
_@0>omKFe_n4Q8Co0000onO_kon<S8co61PHoooooom[Jf_oBTY:od92@_nUYJGo[Jf]o`000?oFg]H4
okg6aP;o_LJm0_nma/H04OoNg]koQ8B4o`000?nLW9co0000of][Jooooooo8B4Qoe9BD_oooooo61PH
ohB4Q?oooooo61PHog=cLola<C7oe]KF00;oDU9B00[o@T92ojFUYOnUYJGo<C4aof]cJomBDU;oBTY:
od92@_nDU9Coc]KFD?nma/H04oo6c/Ko0000omkNg_ne]KGo61PHof=SHon4Q8Coino_oeYJF_ne]KGo
e]KFo`000?nLW9cokoO_o`000?lH61So20P8oibLW?o>e]H00_nma[d02_nma/Koc/k>okFeYOl88CWo
@W^UodZDa_l8<D[oQ8B4okfm_Oo_knncooooo`000_ooool05?o_knooBYC6od9kYOl0637o<D9:olk>
c_o6a/Ko_LK6okg6_OoWinOo<C4aojFUYOogmoOoc/k>okg6_OoWknoo61PHokg6_Oo6c/KoinOW0_mS
Hf<01oooooooBTY:obTY:Om[Jf_oHf=Sokg6_Oo>c/h02?nma/H04_o>c/ko61PHoooooooWknOomoog
ob4Q8OnDU9Coooooob4Q8OnUYJGomooooaPH6?nma[goe]kFojFUYOlQ8B7oooooolk>cP?o_LK600?o
_LJmokg6a_nma/H00onma/H01ooFg]KoLg=cod92@_ogmoOoc]KFomKNe_l000000_mSHf<02_n4Q8Co
inOWojf][OlQ8B7okno_okg6_OoWknOo61PHokg6_Oo6c/H9okg6aP08onO_iolQ8B7o]KfmonO_kooW
knOoJg=[od92@_ooool2of=SH`06oc4a<Oo_knooc/k>oooooom2@T;oJg=[0_mBDU802OnDU9CoBTY:
og=cLolY:BWoHf=Solk>c_lH61Soooooolk>cP03okg6aP03okg6_Onma/Ko_LK600Go_LK601Gog]kN
oa0@4?oFg]Koc/k>oaPH6?ogmoOo_LJmoc4a<OmBDU;oW9bLoooooolY:BWoHf=Sod92@_ooooooQ8B4
oeYJF_o>c/ko8B4Qooooooo>c/h02Onma/H01ooFg]KoNg]kof=SHomkNg_oJf][ooOgmol000000_mS
Hf<02onUYJGoBTY:oibLW?oNimkoinoWoiBDU?m2@T;oooooog]kNomSHf?o8B4Q00;oHf=S00GoLg=c
omkNg_nma[go61PHonO_i`0:okg6aP0Colk>c_lH61SomoogomkNg_nma/Koe]K>okFe]OlQ8B7ooooo
ohb<S?m2@T;oooooog]kNomJFU[o:BTYomkWg_oWinOo410@omKNeP08okg6aP04omKNe_mkNg_oHf=S
odY:BP;oHf=S00koooooodYBB_n4Q8Cooooooc4a<OnLW9cooooooc4a<OmSHf?o@T92oooooon4Q8Co
Hf=SobTY:@;og^ON00Oo:BTYof=SHomSHf?o@T92odYBB_n<S8coe]kF053o_LK601?oc/k>oaPH6?oo
ooooe]KFod92@_mBDU;o<C4aof][JomSHf?oa/K6onogkolH61So_LJmomkWg_l@413oinoWonOWiol0
003oe]KF00?o_LK600Woc/k>okFeYOl88CWo@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;o
oooo00Ookno_odZDa_m2NjGo01Paoc52B_o>c/koa/K600;o_LK601KoinoWod92@_l820So410@ohB4
Q?oFg]Koe]kNo`000?ne_KGoa/K6omkWg_mSHf?oFUYJoooooomBDU;o<C4aohb<S?l0003oU9BDolkF
e_nma[go_LK60_nma[d4okg6aP0AomKFe_l0003o61PHoa0@4?oWinOo<C4aohB4Q?o_knoo61PHojf]
[OoWknOo0000okFm]OoNg]koU9BDob4Q8Oo>e]H00onma/H00onma[go_LK6okg6aP04okg6aP0ComKN
e_mcLg?o@T92onOWioo6a/Koc/k>o`000?mcLg?oFUYJo`000?o_knooYJFUoaPH6?oWinOo_LJmomkW
g_l@413o]KfeolK>aP05okg6aP;o_LJm0_nma/H06_oWknOo:BTYoa0@4?l@413o[Jf]ohB4Q?m2@T;o
koO_oe9BD_mcLg?o0000of=SHone]KGoJf][od92@_mJFU[oDU9Boc4a<Onm_Kgo]Kfeof]cJola<C7o
Jf][okFm]OlQ8B7oe]KF0onma/H00onma[go_LK6okg6aP06okg6aP07omkNg_l820Soc/k>omKNe_l0
003oJf][okFe]@02od92@P0;og]kNooWknOo<C4aof][JolY:BWoooooof]cJom:BT[o_LJmob4Q8OoF
e]H02_nma/H05?oNg]koQ8B4o`000?mcLg?omoogolk>c_l0003oLg=coe9BD_lY:BWoBU9:o`000?oF
e]KoFUYJohB4Q?l0003o]KFeog=cLomSHf?o:BTY0_mSHf<01Ol0003og^ONokFe]Ol@413og^ON00Ko
_LK60_nma[d2okg6aP0ComKFe_l0003o61PHoa0@4?nma[goe]kFohb<S?l@413omooooibLW?l0003o
]KFeog=cLomSHf?o<C4aokfm]Oo6a/Ko410@omkNgP08okg6aP04omKNe_mkNg_oDU9Boe9BDP;oHf=S
00koooooobTY:OmcLg?oooooobTY:Ol0003oinOWobTY:OmcLg?o<C4aono_kom[Lf_oHf=Soc4a<@;o
_Kfe00Oo<C4aoe9BD_m[Lf_og]kNobTY:On4Q8Coe]kF04ko_LK6017o_LJmokg6a_oFg]Ko0000ob4Q
8OlH61So<C4aof=SHom2@T;oQ8B4o`000?nUYJGokoO_oa0@4?nm_KGog^ONo`000002okfm_@03oa0@
4?oFg]Ko_LK600;o_LK600Woc/k>okFeYOl88CWo@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool0
00;ooooo00Ookno_odZDa_m2NjGo01Paoc52B_o>c/koa/K600;o_LK600_oinoWoc4a<On4Q8Coa/k6
okg6_OoFg]KoLg=coaPH6?o>c/koa/K6omkWgP02of=SH`06onOWiooFg]KoDU9BobTY:On4Q8Coe]kF
0onma/H2okg6_@Co_LK601?oc/k>oa0@4?o>c/ko]KFeolk>c_oFg]Ko:BTYob4Q8Ol0003oc/k>ohB4
Q?lH61Soc/k>omkNg_lY:BWo0000oaPH6?ne]KGoa/k600So_LK600Ooe]kFog=cLom2@T;oinOWolk>
c_oNimko[Jf]00;o:BTY00[oa/K6omKNe_nUYJGo61PHonO_ionma/Kog^ONoa0@4?ne_KGoa/k61Onm
a/H2okg6_@;o_LK601coinoWob4Q8OnLW9co_Kfmokg6a_oNimkoHf=Soa0@4?mBDU;og^ONoe9BD_mc
Lg?o20P8olk>c_mSHf?o8B4QohB4Q?mkNg_okno_ohB4Q?lQ8B7oDU9Bonogkola<C7o0000oaPH6?ne
]KGoa/k62_nma/H02OoNg]ko410@olk>c_o>c/koBU9:og=cLol820Sog]kNof]cJ`02oa0@400;oiBD
U?n][JgoDU9Bonogkon4Q8CoNg]kodY:B_l0003o61PHokFe]Oo6c/H02?nma/H05?oFg]KoNg]kodY:
B_mSHf?oW9bLono_kon][Jgo8B4QobTY:OoWinOoJf][ohB4Q?l@413oQ8B4ojf][OmSHf?o@T92oc4a
<OoWinOo_LJm0_lQ8B401Onm_Kgoe]KFokfm]Ol@413og^ON00Ko_LK60_nma[d2okg6aP0Colk>c_l@
413oc/k>okFe]Oo6a/Koe]KFob4Q8OmJFU[oinoWoibLW?mSHf?o@T92oc4a<OoWinOo]Kfmoa0@4?lH
61So0000omkWi`08okg6aP0DomKNe_mcLg?oBTY:oooooomSHf?oJf][olk>c_l@413oYJFUonogkomS
Hf?oQ8B4oa0@4?n<S8comoOgog=cLolH61So0000of=SHooNg]h2o`P82007omKFc_m[Lf_oS8b<oooo
oomBDU;oW9bLolk>cP1=okg6aP;o_LJm01Co_LK6olk>c_l@413oe]KFojf][OlH61Sooooood92@_lY
:BWoU9BDomKNe_oNimko410@okfm]OoNimko:BTYoaPH6?l@413o]Kfeolk>cP?o_LK600Woc/k>okFe
YOl88CWo@W^UodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Ookno_odZDa_m2NjGo01Pa
oc52B_o>c/koa/K600;o_LK601;oinoWobTY:OnLW9comoOgomKNe_o6a/Kog^ONog=cLone_Kgoa/K6
onO_iomSHf?oFUYJomkWg_nma/Koe]kFomkNg_o>e]H2okg6_@So_LK601?oc/k>oa0@4?ogooOog^ON
omKFc_o6c/Koe]kFoooooolQ8B7oYJFUonogkom[Lf_o_KfeomKFe_n][Jgo61PHooooooo6a/Ko_LJm
00Ko_LK60_nma[d01_oFg]KoJf][od92@_ooooooS8b<ohB4Q0?og]kN00[oa/k6olkFe_n][Jgo61PH
onOWionma/Koino_oa0@4?ne]KGoa/k61Onma/H2okg6_@0<okg6a_nma[goinoWoaPH6?ne_KGokoO_
omKFe_o6c/Koe]KFomkNg_oFg]Koa/k60_oFg]H02OoNg]koc/k>omKFe_oNimkoe]KFolk>c_nma[go
c/k>omkNgP02omKNeP04ojf][OlH61SoooooolK6aP_o_LK600Cog^ONoa0@4?oFe]Koc/k>0_oFg]H0
0ooNg]koa/k6omKFeP02omkWgP0:olkFe_o>c/koc]KFokg6_Oo>c/kog^ONojf][OlH61SoooooolK6
aPOo_LK6017o_LJmokg6a_oFg]KoLg=codY:B_ogooOo:BTYoiBDU?oNimkog]kNomKNe_o6c/Koc]KF
omKNe_oNg]koc]KFolk>cP03omKNeP04okg6a_o>c/kog^ONomkWgP;oc/k>00?o_LJmoa0@4?oNimh0
2_nma/H02_o>c/ko410@ooOgmooNinOoe]K>olk>c_nma[goJg=[olkFe_o>c/h3omKNeP06okg6a_o>
c/kog^ONonO_iol820Soe]kF0_nma[d02_nma/Ko_LJmokg6_Onma/Ko_LJmokg6a_oFg]KoLg=cod92
@_ooool2oe9BDP0Goooooon<S8coW9bLolk>c_oFe]Koe]kFomkNg_oFe/ko_LK6olkFe_ogooOoQ8B4
od92@_o_mnoog]kNomkWg_o>c/koc]KFolk>c_nma[goc]KFolk>c_nma[d0C?nma/H2okg6_@;o_LK6
01;oc/k>o`P82?oWknOo_LJmo`P82?oWknOoe]kFomkNg_o>c/ko_LK6onO_iol@413o]KFeolk>c_oN
g]kog^ONomkNe_o>c/h4okg6aP09olk>c_ne]JGo224iod9kYOm:U<Ko235:ohB4Q?nm_Kgokno_0;?o
oooo0002ooooo`07ono_kom:U<Ko@W^Uo`0H<Ola@T[oc/k>olK6aP02okg6aP0>omkWg_m:BT[o0000
oa0@4?l0003o]KFeolkFe_nDU9Co_KfmolK>a_nm_Kgo0000og]kNooNg]h;okg6aP0Eokg6_Onma/Ko
_LK6omKFc_l0003o410@o`P82?la<C7oe]KFokg6a_oNimko:BTYojFUYOoFe]KoU9BDokfm_Oo6a/Ko
_LJmojf][Oo6c/Ko_LJm00Wo_LK600Ooa/K6olk>c_m:DT[o410@obTY:One_Kgoa/k600?o_LK600Oo
e]kFoa0@4?lQ8B7og^ONomKNe_mcLg?o000000;oa/K62Onma/H02OoNimko<C4ao`P82?l@413o20P8
okg6_Oo6a/Ko_LJmokg6aP04okg6_@[o_LK600?o_LJmojf][Oo6c/H02onma/H01OoFg]KoHf=So`00
0?mBDU;oe]kF00?o_LK60_nma[d8okg6aP03okg6_On][Jgoa/k600Ko_LK600_o_LJmokg6a_nma/Ko
_LK6omKNe_mkNg_oBTY:oooooomSHf?oDU9BomkWgP06okg6aP03okg6_Onma/Ko_LK600Oo_LK600Co
e]kFobTY:Ol@413og^ON2_nma/H02_oFe/ko0000oa0@4?l820So<C4aomKNe_ne_KGoW9bLolK>a_nm
a/H2okg6_@Co_LK600?oa/K6oaPH6?o>e]H02?nma/H01?oFg]KoNg]kodY:B_ogool2of=SH`04onOW
ionUYJGo[Jf]olK6aPKo_LK600Coe]kFog]kNom:BT[og^ONFOnma/H01_o6a/Ko61PHomKFe_ne]KGo
61PHomKNeP?o_LK600?oe]kFog=cLol000000_o6a/H8okg6aP09olk>c_ne]JGo224iod9kYOm:U<Ko
235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`07ono_kom:U<Ko@W^Uo`0H<Ola@T[oa/k>olK6aP03
okg6aP?oc/k>0_o6a/H01Onma/Koc/k>okg6a_nma[goa/K600;oc/k>3onma/H01?o6a/Koe]K>olk>
c_o>c/h2olK6aP;o_LK600Coc/k>olK6a_nma[goc/k>0onma/H00oo>c/ko_LJmokg6_@09okg6aP04
okg6_Oo>c/koc/k>olK6aP;oc/k>00Co_LJmokg6a_nma/Ko_LK60_o6a/H01_o>c/koa/Jmokg6a_o6
a/Koc/k>olK>aP[o_LK600Coa/K6omKFc_o>c/koc/k>0_o6a/H2okg6_@03okg6a_nma[go_LJm00;o
_LJm2_nma/H00oo6a/Koc/k>okg6_@0<okg6aP04olK6a_o>e]Koa/K6olK6aP?o_LK60_nma[d8okg6
aP03olK6a_o>c/ko_LJm00_o_LK600Ooa/k6olk>c_nma/Koa/k6olk>c_nma/Ko_LJm00Go_LK600?o
_LJmokg6a_nma/H01onma/H2olK6aP03olk>c_o6a/Ko_LK600;o_LK600?o_LJmokg6a_nma/H01?nm
a/H02_o6a/Koe]K>olk>c_o6c/Koa/K6okg6a_o6a/Koc/k>okg6_Onma/H2okg6_@Co_LK600?oa/K6
olk>c_nma/H02Onma/H00oo6c/Koc/k>okg6aP02olK>aP03okg6_Oo6c/Koa/K600So_LK600?oa/k6
olk>c_nma/H0FOnma/H01_o6a/Koc/k>olK6a_o6a/Koc/k>olK6aPCo_LK600?oa/K6olk>c_o6c/H0
2Onma/H02Oo>c/ko]KFUo`PQ>Om2NjGoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool01oo_
knooBYC6od9kYOl0637o<D9:olk>c_o6a/H00onma/H00onma[go_LK6okg6aP06okg6aP03okg6_Onm
a/Ko_LK600oo_LK600?o_LJmokg6a_nma/H00onma/H2okg6_Ako_LK600?oa/K6okg6a_nma/H05?nm
a/H2okg6_E?o_LK600Coa/Jmokg6a_nma/Ko_LJm0onma/H2okg6_@_o_LK600?o_LJmokg6a_nma/H0
ROnma/H00onma[go_LK6okg6aP09okg6aP09olk>c_ne]JGo224iod9kYOlYNkGo235:ohB4Q?nm_Kgo
kno_0;?ooooo0002ooooo`05ono_kom:U<Ko@W^Uo`0H<Ola@TX00_o>c/h4olK6aP03olk>a_o6a/Ko
a/K600ooa/K600Coa/k6omKNg_o6c/koa/K60_o>c/H6olK6aP03olK>a_o6a/Koa/K606coa/K600Co
e]kNolK>c_o6a/Koa/k67oo6a/H00oo>c/Koa/K6olK6aP0;olK6aP03olK>a_o6a/Koa/K608Woa/K6
00?oa/k6olK6a_o6a/H02oo6a/H02OoFe]Ko]KFUo`PQ>Om2NjGoBYC6o`PQ>On4Q8Co_Kfmono_k`2c
ooooo`000_ooool02?o_knooBYC6og>Ua_laDV_o@U9BomKNg_o6c/ko_LK60_o6c/h01?nma/Koa/K>
olK>c_nma/H2olK>cP?o_LK600Coa/k6olK>c_nma/Ko_LK61?o6c/h00onma/Koa/k>olK6aP02okg>
eP05olK6a_o6c/Koa/k>olK>c_nma/H00_o6c/h01?nma/Koa/k>olK6a_nma/H2olK>cP;o_LK600Go
a/k>okg6a_o6c/koa/k>okg6aP02olK>cP06okg6a_o6c/ko_LK6okg6a_o6c/koa/k60_o6c/h01?nm
a/Koa/k>olK>c_nma/H2olK>cP04okg6a_o6c/koa/k>okg6aP;oa/k>00Co_LK6olK>c_nma/Ko_LK6
0_o6c/h01?nma/Koa/k>olK>c_nma/H2olK>cP03okg6a_o6c/ko_LK600?o_LK60_o6c/h01?nma/Ko
a/k>olK>c_nma/H2olK>cP04okg6a_o6c/koa/k>okg6aP;oa/k>00Oo_LK6olK>c_o6c/ko_LK6olK6
c_o6c/ko_LK600;oa/k>00Go_LK6olK>c_o6c/ko_LK6olK>cP02okg6aP05olK>c_nma/Koa/k>olK>
c_nma/H00_o6c/h01?nma/Koa/k>okg6a_nma/H2olK>cP04okg6a_o6c/koa/k>okg6aP;oa/k>00Co
_LK6olK>c_o6c/ko_LK60_o6c/h02?nma/Koa/k>olK>c_nma/Koa/k6okg6a_nmc]Koa/K60_o6c/H0
1?o6c/ko_LK6okg6a_o6c/h2okg6aP;oa/k600?oa/k>okg6a_o6c/h00onma/H2olK>cP05okg6a_o6
c/koa/k>okg6a_o6c/h00_nma/H01?o6c/Ko_LK6okg6a_o6c/h2okg6aP04olK>c_o6c/Koa/k>olK>
cPCo_LK600?oa/k>okg6a_nma/H00_o6c/h01onma/Koa/k>olK>c_nma/Koa/K>olK>c_nma/H00_o6
c/h01?nma/Koa/k>olK>c_nma/H2olK>cPCo_LK600Coa/k>okg6a_o6c/koa/k>0_nma/H01Oo6c/ko
_LK6okg6a_o6c/ko_LK600;oa/k>00Co_LK6olK>c_o6c/ko_LK60_o6c/h01?nma/Koa/K>olK6a_nm
a/H2olK>cP05okg6a_o6c/koa/k>okg6a_o6c/h00_nma/H01Oo6c/ko_LK6olK>c_o6c/ko_LK600;o
a/k>00Co_LK6olK>c_o6c/ko_LK60_o6c/h01?nma/Koa/k>olK>c_nma/H2olK>cP04okg6a_o6c/ko
a/k>okg6aP;oa/k>00Go_LK6olK>c_o6c/ko_LK6olK>cP02okg6aP05olK>c_nma/Koa/k>olK>c_nm
a/H00_o6c/h01?nma/Koa/k>olK>c_nma/H2olK>cP04okg6a_o6c/koa/k>okg6aP;oa/k>00Co_LK6
olK>c_o6c/ko_LK60_o6c/h01Onma/Koa/k>olK>c_nma/Koa/k>00;o_LK600Goa/k>okg6a_o6c/ko
a/k>okg6aP02olK>cP04okg6a_o6c/koa/k>okg6aP;oa/k>00?o_LK6olK>c_o6c/h01?nma/H2olK>
cP05okg6a_o6c/koa/k>okg6a_o6c/h00_nma/H00oo6a/ko_LK6okg6aP02okg6aP;oa/k>00ko_LK6
olK>c_o6c/ko_LK6olK>c_o>c/koc/k6oaQ2F_m2NjGoLjG6ocU[S?n4Q8Co_Kfmono_kk?ooooo0002
ooooo`06ono_kolH@U[o649JoaQ:JolY>CWo<D9:oolY>CUOobTi>@08oc52B_l8<D[o649JoaQ2F_lH
BV_oQ8B4okfm_Oo_knncooooo`000_ooool01oo_knoo:G^eo`PaB_l0637o44YkobUSQ?l88CT02Ol8
<DX01?l0637o649Joc5SS?l88CWoo`PaBSOo235:00Co224io`PaB_liJhco224i2Ol8<DX2o`PQ>@03
ocUcW?l8<D[o235:00So235:0_l88CT01_m2NjGo235:o`PQ>On4Q8Co_Kfmono_kk?ooooo0002oooo
o`07ono_kom:U<KoHhbUo`PQ>OlHBV_oLjG6oc5[U008ocU[S005oe9cS?l8<D[o649Jog>Ua_liLi`0
ooliJh`focU[S006oe9cS?lH@U[o235:og>Ua_m2NjGo>F=k1oliJh`01omBLhco<E9[o`PQ>OmcYLKo
@W^UocUSNoliJh`01omBLh`02?laDV_o224iof><YOm:U<Ko235:ohB4Q?nm_Kgokno_/oooool000;o
oooo00Ookno_odZDa_m2NjGo224ioaQ:Jom:U<Ko:F^D00Ko:F><00Oo<F><obUSS?liJhco235:oaQ2
F_m:U<Ko:F^D08[o:F><01;o<F><ob5JQ?l@BW_o44Ykob5JQ?laHhco8EZ4oa1:NolQFXCo44Ykob5J
Q?l@BW_o8EZ4obUSS?l@BW_o8EZ4obUSQ?l@BW/2obUSQ00<oa1:NolQFXCo44Ykob5JQ?lYHhCo44Yk
ob5JQ?l@BW_o8EZ4oa1:NolQFXCo<F><RolYHh`01OliJhco649Jo`PaB_m:U<Ko>G>L00Go:F><0_la
Hh`01olYHhco<F^DoaQ:Jol88CWoHhbUobUk]OlYHh@01Ol8<DX02olH@U[o235:obUSQ?laDV_o224i
of><YOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`08ono_kom:U<Ko@W^Uo`PQ>OlHBV_o
BYC6obU[U?laHh`7oc5[U006ocU[S?l8<D[o649Jog>Ua_lYJiCo:F>42olaHh`00olYHhco<F><oc5S
S012oc5SS003obUSS?laHhco<F><03Ko<F><01;o8EZ4oe9cS?n][JgoW:f]ocU[S?l@BW_o>F=koib]
[OlaDV_oW9bLocUSNomcYLKoDW><oc5BJomcYLKoDW><ocUSNomcYLH2ocUSN`0<og>Ua_liHg_oW9bL
ocU[S?lYHhCoW9bLocUSNomcYLKo>F=koiBDU?mSS:Go44Yk3_laHh`00olYHhco<F><oc5SS01joc5S
S005ocU[S?lH@U[o235:og>Ua_liLi`00olYHh`3oc5[U00:oc5SS?lYHhco>F^<oaQ:Jol88CWoHhbU
ocUcW?lYJiCo@W^UobUSQ0?o:F><00_o<F^DoaQ2F_laDV_o<E9[o`PQ>OmSS:GoBYC6o`PaB_n4Q8Co
_Kfmono_k`2cooooo`000_ooool02Oo_knooBYC6od9kYOl88CWo64Y[odZDa_lYJiCo64Y[o`PaBP05
oaQ2FP07oaQ:JomBLhco235:oaQ2F_mcYLKo:F^DobUSQ004oc5SS003obUSS?laHhco<F><00;o<F><
0_lYHha4oc5SS003obUSS?laHhco<F><03Ko<F><02?o8EZ4ocU[S?ooooooYKg>okFe]Ooooooo<E9[
ooOooonmg^Oo[MKNoooooomSS:Gooooooib][OlH@U[oooooof><YOliHg_ooooooe9cS?mSS:Gooooo
of><YOooooooHhbUobUSS?ooooooHhbUooooooo_ooooYKg>oooooomBLhco8EZ4obUSS005oc5SS0;o
:F><1_laHh`00olYHhco<F><oc5SS01Toc5SS0;o:F><4_laHh`02OlYHhco>F^<oaQ2F_l8<D[oLjG6
ocUcW?lYHhCo<F><obUSQ003oaQ2FP;o<F><00So>F^<oaQ:Jol88CWoHhbUocUcW?lYJiCo@W^UobUS
Q0?o<F><00_o<F^DoaQ2F_laDV_o<E9[o`PQ>OmSS:GoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`00
0_ooool02Oo_knooBYC6od9kYOl88CWo64Y[odZDa_lQHiCo>F^<ocUSN`05oc5BJ`07o`PaB_mBLhco
235:oaQ2F_mcYLKo:F^DobUSQ003oc5SS0;o:F><1OlaHh`00olYHhco<F><oc5SS01loc5SS003ocUS
NolaDV_o64Y[00;ooooo01goDW><oooooomBLhco>F^<oooooomBLhcooooooib][OlH@U[oooooof><
YOlaDV_ooooooe9cS?lHBV_o>F=kobUSQ?ooooooHhbUob5JQ?ooooooDW><oooooone]KGo235:oooo
oonLW9co44YkobUSS005oc5SS003obUSS?laHhco<F><06Oo<F><0_lYHh`4oc5SS003obUSS?laHhco
<F><013o<F><00Oo:F><ocU[S?lH@U[o235:og>Ua_liLico:F>400;o<F><00go>F^<oc5BJol8<D[o
:F><oc5SS?liJhco64Y[o`PQ>OmSS:Go>G>LobU[U?m2NjGo:F>400?o<F><00_o<F^DoaQ2F_laDV_o
<E9[o`PQ>OmSS:GoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool02Oo_knooBYC6od9kYOl8
8CWo64Y[odZDa_lQHiCo:G^eodZDaP05obUk]@07o`PaB_mBLhco235:oaQ2F_mcYLKo:F^DobUSQ008
oc5SS003obUSS?laHhco<F><07go<F><01Co:F>4ocU[S?nLW9cooooookFm_OlQFXCo44YkoooooomS
S:Go44YkoooooomBLhcoooooog>Ua_lH@U[oooooof><YOlaDV_oooooohB4Q0;o44Yk00go:F>4oooo
oom2NjGo44YkoooooomBLhcoooooof><YOl8<D[ooooooiBDU?l@BW_o:F><06ko<F><00Co:F>4ocUc
W?lYNkGo:F><5_laHh`01_lYHhco>F^<oaQ2F_l8<D[oBYC6ocUcW0?o<F><00goBYC6od9kYOl8<D[o
:F>4obUSS?liJhco64Y[o`PQ>OmSS:Go>G>LobU[U?m2NjGo:F>400?o<F><00_o<F^DoaQ2F_laDV_o
<E9[o`PQ>OmSS:GoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool02?o_knooBYC6od9kYOl8
8CWo64Y[odZDa_lYJiCo<F><1_liLi`01olQFXCo>F^<o`PaB_lH@U[oLjG6obU[U?lYHh@00olaHh`2
obUSS003oc5SS?lYHhCo<F><00Co<F><00?o:F><oc5SS?laHh`0N?laHh`09_lYHhco8EZ4oe9cS?oo
oooo[Jf]oe9JHooNmnooDW><oooooomSS:Go:F>4oooooomkNg_ooooooib][Om2DU;oooooof><YOmS
Hf?oooooof><YOl@BW_o8EZ4oc5SS?oooooog_O_of><YOooooooDW><onooooo_moOoLg=coooooomS
S:Go44YkobUSS?laHhco:F><<olaHh`00olYHhco<F><oc5SS007oc5SS0;o:F><;_laHh`2oc5[U003
obUSS?laHhco<F><01Co<F><00Oo:F><ocU[S?lH@U[o235:og>Ua_liLico:F>400;o<F><00go<F^D
ocUcW?lQFXCo<F><obUSS?liJhco64Y[o`PQ>OmSS:Go>G>LobU[U?m2NjGo8EZ400?o:F>400_o<F><
oaQ2F_laDV_o<E9[o`PQ>OmSS:GoBYC6o`PaB_n4Q8Co_Kfmono_k`2cooooo`000_ooool01oo_knoo
BYC6od9kYOl88CWo64Y[odZDa_lYJi@01olYHh@02OlaHhco>F^<o`PaB_lH@U[oLjG6obU[U?lYHhCo
<F><obUSS004oc5SS003oc5[U?laHhco<F><00?o<F><00?o:F><oc5SS?laHh`0N?laHh`2obUSS00;
oaQ:JomcYLKog]kWonogmomcYLKo64Y[ooOooomSS:Go:F><ooOooomSS:D00_mcYLH04oo_moOoW:f]
og>Ua_o_moOoW:f]oaQ:JolaHhco:F>4ocU[S?ogooOoHhbUokgNionL[Jgo235:oooooonL[Jgo]Lk>
ojFmc_lHBV/01_laHh`00olYHhco<F><oc5SS00^oc5SS003obUSS?laHhco<F><00Oo<F><00?o:F><
oc5SS?laHh`0A_laHh`01olYHhco>F^<oaQ2F_l8<D[oLjG6ocUcW?lYHh@00_laHh`2obUSQ0;o<F><
00Wo:F><ocU[S?lHBV_o224iof><YOliLico:F^Dod9kYOlaJi@00oliLi`02om2NjGo649Joc5BJola
DV_o224iof><YOm:U<Ko235:ohB4Q?nm_Kgokno_0;?ooooo0002ooooo`07ono_kom:U<Ko@W^Uo`PQ
>OlHBV_oBYC6obU[U002obUSQ003oc5SS?lYHhCo<F><00;o<F><00Oo:F><ocUSNol8<D[o649Jog>U
a_lYJiCo:F>400;o:F><0olaHh`01?lYHhCo:G^eobU[U?lYHhB1oc5SS0Co44Yk00Ko8EZ4oa1:NolQ
FXCo8EZ4oa1:NolQFX@7oa1:N`04obUSQ?lYHhco<F><ob5JQ0Co44Yk00Ko<E9[oooooonL[Jgo235:
oa1:NolYHh`6oc5SS0;o:F><<?laHh`00olYHhCo<F><oc5SS007oc5SS003obUSQ?laHhco<F><00Go
<F><0_lYHh@Voc5SS003obUSS?laHhco<F><00;o<F><0_lYHh`Aoc5SS007obUSS?liJhco649Jo`Pa
B_mcYLKo>G>LobUSQ006oc5SS007obUSS?laHhco64Y[o`PQ>OmSS:Go>G>Lob5JQ005ocUcW00;obUk
]OlYHhCo>F=koc5BJol88CWoHhbUodZDa_l8<D[oQ8B4okfm_Oo_knl0/oooool000;ooooo00Kokno_
odZDa_m2NjGo224ioaQ:Jom:U<H9obU[U006oc5[U?l88CWo649JodZDa_lYJiCo8F>D1_lYJi@00olQ
HiCo:F^DobU[U02JobU[U004ob5SU?m2NjGo<F^Dob5SU8go:F^D00Ko<F^DoaQ2F_l88CWoBYC6obUk
]OlQHi@7obU[U005oc5[U?lH@U[o224iodZDa_lYNkD01olQHi@02_lYJiCo>G>LoaQ:Jol0637oHhbU
odZDa_l8<D[oQ8B4okfm_Oo_knncooooo`000_ooool01_o_knooBYC6od9kYOl88CWo64Y[og>UaPWo
BYC600CoLjG6ocUSNolH@U[oLjG6hOm:U<H01?mcYLKoBYC6odZDa_mcYLH;odZDaP;oLjG6A?m:U<H0
1?mcYLKoDW><o`PaB_mcYLH9odZDaP04og>Ua_m2NjGo235:of><Y@?oBYC600CoLjG6odZDa_m:U<Ko
LjG60_m:U<H02OmcYLKoHhbUo`PaB_mSS:GoBYC6o`PaB_n<S8coa/K6ono_k`2cooooo`000_ooool0
1Oo_mnooBYC6od9kYOl88CWo235:00co64Y[00?o235:oaQ:JolHBV/0hOlHBV/2ob5SU0go64Y[00?o
8EZ4oaQ:JolHBV/0@olHBV/00olQFXCo235:oaQ:J`0:oaQ:J`03ob5JQ?l8<D[o649J00[o64Y[00So
8EZ4o`PaB_mSS:GoBYC6o`PaB_n][Jgoe]KFonogkk?ooooo0003ooooo`03odZDa_liLico235:00co
224i00Co01PaoaQ:JolYHhCo01Paool88CTho`PQ>@03o`PaB_l88CWo224i00Wo224i00Go01Pao`Pa
B_liJhco224io`0H<@0:o`PQ>@05oaQ2F_m2NjGo235:omKFe_o_knl0]?ooool000?ooooo00?oBYC6
od9kYOliLi`02om2NjD01?mSS:Go235:oaQ2F_mcYLKood9kYDCo@W^U00GoHhbUoc5BJol88CWoLjG6
odZDaP0;od9kY@04ocUcW?lYNkGo235:onogkkGooooo0003ooooo`ooBYC600?o>G>LoaQ2F_m:U<H0
oom:U<I6odZDaP03oaQ2F_m2NjGoBYC600goBYC600?o@W^Uooooooooool0]?ooool00?oooooooooo
oolSooooo`00ooooooooooooob?ooooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{545, 335},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.2"],

Cell[TextData[{
  "One consequence of the modular nature of the ",
  StyleBox["Mathematica", "TI"],
  " system is that its parts can be run on different computers. Thus, for \
example, it is not uncommon to run the front end for ",
  StyleBox["Mathematica", "TI"],
  " on one computer, while running the kernel on a quite separate computer.  \
"
}], "Text",
  CellTags->{"S1.3.2", "2.10"}],

Cell[TextData[{
  "Communications between the kernel and the front end are handled by ",
  StyleBox["MathLink", "TI"],
  ", using whatever networking mechanisms are available. "
}], "Text",
  CellTags->{"S1.3.2", "2.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.3.3 Special Topic: Using a Text\[Hyphen]Based Interface\
\>", \
"Subsection",
  CellTags->{"S1.3.3", "3.1"}],

Cell[TextData[{
  "With a text\[Hyphen]based interface, you interact with ",
  StyleBox["Mathematica", "TI"],
  " just by typing successive lines of input, and getting back successive \
lines of output on your screen. "
}], "Text",
  CellTags->{"S1.3.3", "3.2"}],

Cell[TextData[{
  "At each stage, ",
  StyleBox["Mathematica", "TI"],
  " prints a prompt of the form ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MR"],
  " to tell you that it is ready to receive input. When you have entered your \
input, ",
  StyleBox["Mathematica", "TI"],
  " processes it, and then displays the result with a label of the form ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]=", "MR"],
  ".  "
}], "Text",
  CellTags->{"S1.3.3", "3.3"}],

Cell[TextData[{
  "If your input is short, then you can give it on a single line, ending the \
line by pressing Enter or Return. If your input is longer, you can give it on \
several lines. ",
  StyleBox["Mathematica", "TI"],
  " will automatically continue reading successive lines until it has \
received a complete expression. Thus, for example, if you type an opening \
parenthesis on one line, ",
  StyleBox["Mathematica", "TI"],
  " will go on reading successive lines of input until it sees the \
corresponding closing parenthesis. Note that if you enter a completely blank \
line, ",
  StyleBox["Mathematica", "TI"],
  " will throw away the lines you have typed so far, and issue a new input \
prompt.  "
}], "Text",
  CellTags->{"S1.3.3", "3.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["%", "MR"],
              StyleBox["n", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Out[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the value of the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " output "
            }]]},
          {Cell[TextData[{
              StyleBox["InString[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the text of the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " input "
            }]]},
          {Cell[TextData[{
              StyleBox["In[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " input, for re\[Hyphen]evaluation "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.3"],

Cell["\<\
Retrieving and re\[Hyphen]evaluating previous input and output. \
\
\>", "Caption",
  CellTags->"S1.3.3"],

Cell[TextData[{
  "With a text\[Hyphen]based interface, each line of ",
  StyleBox["Mathematica", "TI"],
  " input and output appears sequentially. Often your computer system will \
allow you to scroll backwards to review previous work, and to cut\[Hyphen]and\
\[Hyphen]paste previous lines of input. "
}], "Text",
  CellTags->{"S1.3.3", "3.5"}],

Cell[TextData[{
  "But whatever kind of computer system you have, you can always use ",
  StyleBox["Mathematica", "TI"],
  " to retrieve or re\[Hyphen]evaluate previous input and output. In general, \
re\[Hyphen]evaluating a particular piece of input or output may give you a \
different result than when you evaluated it in the first place. The reason is \
that in between you may have reset the values of variables that are used in \
that piece of input or output. If you ask for ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will give you the final form of your ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " output. On the other hand, if you ask for ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will take the ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " input you gave, and re\[Hyphen]evaluate it using whatever current \
assignments you have given for variables. "
}], "Text",
  CellTags->{"S1.3.3", "3.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3.4 Doing Computations in Notebooks", "Subsection",
  CellTags->{"S1.3.4", "4.1"}],

Cell[TextData[{
  "A typical ",
  StyleBox["Mathematica", "TI"],
  " notebook containing text, graphics and ",
  StyleBox["Mathematica", "TI"],
  " expressions. The brackets on the right indicate the extent of each cell."
}], "MathCaption",
  CellTags->{"S1.3.4", "4.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008<0001[b000`400?l00000o`00003oo`3ooooo
0?ooo`h0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c2@0c<c<20?ooo`000P3UiNGo03<c<ol0
<c<c2P0c<c<20?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI0P0c<c<20?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI0P0c<c<20?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@L0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@<0iNGU0`2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool10?ooo`<0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo0@3oool309VIV@80<c<c0P3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?oo
o`D0003o0P3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=A0?ooo`@00000o`3ooonJ0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ah0oooo0P000?l30?ooo`80003o;@3oool00`000000oooo0?ooo`3o0?oooiX0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c7P3oool00`000?l0oooo0?ooo`030?ooo`030000
o`3oool0oooo02/0oooo00<000000?ooo`3oool0o`3ooonJ0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<a<0oooo0`000?l30?ooo`80003o0P3oool20000o`80oooo0P000?l00`3oool0
003o0?ooo`0H0?ooo`@000000P3oool4000000@0oooo0P0000001P3oool000000000003oool00000
0?ooo`8000000P3oool3000000050?ooo`00000000000000003oool01@0000030?ooo`<000000`3o
ool400000?l0ooooO@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<B0?ooo`0?0000
o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o0080
oooo0P000?l00`3oool0003o0000o`020000oa<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P0000020?ooo`8000000P3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?ooog`0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4P3oool03@000?l0oooo0?ooo`3oool0003o
0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0103oool20000oaL0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000002P3oool200000?l0ooooO03oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<B0?ooo`0=0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0
003o0?ooo`000?l0oooo0000o`030?ooo`040000o`3oool0003o0?ooo`@0003o2@3oool5000000@0
oooo00<000000?ooo`3oool0100000020?ooo`030000003oool0oooo00@0oooo100000020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`000000203oool2000000L0oooo1@00003o0?ooog80oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c4P3oool02P000?l0oooo0?ooo`3oool0003o0?ooo`000?l0
oooo0000o`3oool30000o`@0oooo0P000?lG0?ooo`030000003oool0oooo00H0oooo0P0000080?oo
o`030000003oool0oooo008000000P3oool00`000000oooo0?ooo`0200000080oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000?l0ooooN@3oool40000o`H0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a80oooo
00D0003o0?ooo`3oool0oooo0000o`050?ooo`050000o`3oool0003o0?ooo`000?l00P3oool20000
oaL0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`02000000030?ooo`0000000000
0080oooo100000020?ooo`80000000<0oooo0000000000000`3oool010000000oooo000000000003
0?ooo`<000001@3oool4000000<0oooo1000003o0?ooog`0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c4`3oool30000o`P0oooo0P000?l00`3oool0003o0000o`020000oaP0oooo00<0
00000?ooo`3oool00P00000G0?ooo`030000003oool0oooo0?l0ooooTP3oool20000o`H0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ch0oooo0P0000000`3oool000000?ooo`0E0?ooo`800000203oool00`000000oooo
0?ooo`3o0?ooohP0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo/0?ooo`04
0000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool01@000?l0oooo0?ooo`3o
ool0003o00H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`H0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`H0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`8000008`3oool00`000000
oooo0000000U0?ooo`030000003oool000000200oooo00@000000?ooo`0000000000o@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool08`3oool2000002<0oooo00<000000?ooo`0000009@3oool00`000000oooo0000000P
0?ooo`030000003oool0000000800000o03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<a0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool2000002<0oooo00<0
00000?ooo`0000009@3oool00`000000oooo0000000P0?ooo`040000003oool0000000000?d0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00<000000?ooo`00
0000803oool010000000oooo00000000003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<c40oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`8000008`3oool0
0`000000oooo0000000U0?ooo`030000003oool000000200oooo00@000000?ooo`0000000000o@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool08`3oool2000002<0oooo00<000000?ooo`0000009@3oool010000000oooo
0?ooo`00000O0?ooo`040000003oool0000000000?d0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S
0?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000007`3oool00`000000oooo0000
000200000?`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo
00@000000?ooo`3oool000007P3oool00`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000007P3oool0
0`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S0?ooo`030000003o
ool0000002D0oooo00@000000?ooo`3oool000007P3oool00`000000oooo0?ooo`0200000?d0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00@000000?ooo`3o
ool000007P3oool00`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S
0?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000007P3oool00`000000oooo0?oo
o`0300000?`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo
00@000000?ooo`3oool000007P3oool00`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000007P3oool0
0`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S0?ooo`030000003o
ool0000002D0oooo00@000000?ooo`3oool000007P3oool00`000000oooo0?ooo`0200000?d0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00@000000?ooo`3o
ool000007P3oool00`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S
0?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000007P3oool00`000000oooo0?oo
o`0300000?`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo
00@000000?ooo`3oool000007P3oool00`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00@000000?ooo`3oool000007P3oool0
0`000000oooo0?ooo`0200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000S0?ooo`030000003o
ool0000002D0oooo00@000000?ooo`3oool000007P3oool00`000000oooo0?ooo`0200000?d0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo02<0oooo0P00000S0?ooo`030000003oool0000002D0oooo00@000000?ooo`3o
ool000004P3oool4000000<0oooo0P0000030?ooo`030000003oool0oooo00800000o@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool08`3oool2000002<0oooo00<000000?ooo`0000009@3oool010000000oooo0?ooo`00
000D0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`@0
0000n`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool08`3oool2000002<0oooo00<000000?ooo`0000009@3oool01000
0000oooo0?ooo`00000D0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0000
00030?ooo`800000o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool2000002<0oooo00<000000?ooo`000000
9@3oool010000000oooo0?ooo`00000<0?ooo`@00000103oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`0000000`3oool200000?d0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000R
0?ooo`040000003oool0oooo000002D0oooo00D000000?ooo`3oool0oooo0000000C0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo000000030?ooo`800000o@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool08`3oool200000280oooo00@000000?ooo`3oool000009@3oool01@000000oooo0?ooo`3o
ool000000140oooo0`0000030?ooo`060000003oool0oooo0000003oool000000`3oool200000?d0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?oo
o`030000003oool0oooo02<0oooo0P00000R0?ooo`040000003oool0oooo000002D0oooo00D00000
0?ooo`3oool0oooo0000000C0?ooo`030000003oool0oooo0080oooo0P0000020?ooo`040000003o
ool0oooo0?ooo`<00000o03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool200000280oooo00@000000?ooo`3o
ool000009@3oool01@000000oooo0?ooo`3oool0000001`0oooo00@000000?ooo`3oool0oooo0P00
003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0S0?ooo`8000008P3oool010000000oooo0?ooo`00000U0?ooo`05
0000003oool0oooo0?ooo`000000703oool010000000oooo0?ooo`3oool200000?d0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003o
ool0oooo02<0oooo0P00000R0?ooo`040000003oool0oooo000002D0oooo00D000000?ooo`3oool0
oooo0000000L0?ooo`040000003oool0oooo0?ooo`800000o@3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool2
00000280oooo00@000000?ooo`3oool000009@3oool01@000000oooo0?ooo`3oool0000001`0oooo
00@000000?ooo`3oool0oooo0P00003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<c40oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`8000008P3oool01000
0000oooo0?ooo`00000U0?ooo`050000003oool0oooo0?ooo`0000006`3oool00`000000oooo0?oo
o`020?ooo`<00000o03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool200000280oooo00@000000?ooo`3oool0
00009@3oool01@000000oooo0?ooo`3oool0000001/0oooo00<000000?ooo`3oool00P3oool20000
0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo02<0oooo0P00000R0?ooo`040000003oool0oooo000002D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0080oooo0P00
003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`0S0?ooo`8000008P3oool010000000oooo0?ooo`00000U0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`020?ooo`80
0000o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool08`3oool200000280oooo00@000000?ooo`3oool000009@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool00P3oool2
00000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?oo
o`0S0?ooo`030000003oool0oooo02<0oooo0P00000R0?ooo`040000003oool0oooo000002D0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00<0oooo
0P00003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3o
ool08`3oool00`000000oooo0?ooo`0S0?ooo`8000008P3oool010000000oooo0?ooo`00000U0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`030?oo
o`<00000o03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool08`3oool200000280oooo00@000000?ooo`3oool000009@3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3o
ool200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00000R0?ooo`040000003oool0oooo000002D0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00<0
oooo0P00003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?oo
o`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`8000008P3oool010000000oooo0?ooo`00000U
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`03
0?ooo`800000o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool08`3oool200000240oooo00D000000?ooo`3oool0oooo
0000000U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`040?ooo`800000o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool200000240oooo00D000000?ooo`3o
ool0oooo0000000U0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`040?ooo`<00000o03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0000000P
0?ooo`050000003oool0oooo0?ooo`0000009@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0103oool200000?d0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`000000803oool01@000000oooo0?ooo`3oool0000002D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00D0oooo0P00003m0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool000000200oooo00D000000?ooo`3oool0oooo0000000U
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04P3oool3000000H0oooo0P00003m
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool000000200oooo00D000000?ooo`3oool0oooo
0000000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04P3oool00`000000oooo
000000050?ooo`800000o@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`03
0000003oool0oooo02<0oooo0P00000T0?ooo`030000003oool000000200oooo00D000000?ooo`3o
ool0oooo0000000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool04@3oool01000
0000oooo0?ooo`0000050?ooo`@00000n`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<a0?ooo`030000003oool0oooo02<0oooo0P00000T0?ooo`030000003oool000000200oooo00D0
00000?ooo`3oool0oooo0000000U0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
2P3oool400000080oooo0`0000060?ooo`800000o@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<a0?ooo`030000003oool0oooo02<0oooo0P00000T0?ooo`030000003oool0000001l0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool03P3oool2000000P0oooo0P00003m0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool08`3oool2000002@0oooo00<000000?oo
o`0000007`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0<0?ooo`030000003oool0000000P0oooo0P00003m0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool08`3oool2
000002@0oooo00<000000?ooo`0000007`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00@000001@3oool200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3o
ool00`000000oooo0?ooo`0S0?ooo`800000903oool00`000000oooo0000000O0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02P3oool300000?`0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0S0?ooo`800000903oool00`000000oooo
0000000O0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0:0?ooo`8000001`3oool2000000d0oooo0P00003m0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool08`3oool2000002@0oooo00<000000?ooo`00
00007`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0303oool8000000h0oooo0P00003m0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<c40oooo00<000000?ooo`3oool08`3oool2000002@0oooo00<000000?ooo`0000007P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08P3oool20000
0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0000002@0oooo00<000000?ooo`0000007P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08P3oool200000?d0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0000002@0oooo00<000000?ooo`0000007@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool08P3oool300000?`0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0000002@0oooo
00@000000?ooo`3oool00000703oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0
oooo00<000000?ooo`3oool08P3oool200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c<@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0000002@0oooo00@000000?oo
o`3oool00000703oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool08P3oool200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3o
ool00`000000oooo0?ooo`0R0?ooo`030000003oool0000002@0oooo00@000000?ooo`3oool00000
6`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
8P3oool200000?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0000002@0oooo00@000000?ooo`3oool000006P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08P3oool20000
0?d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0000002@0oooo00@000000?ooo`3oool000006P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08P3oool300000?`0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0R0?ooo`050000
003oool000000?ooo`0000008P3oool01@000000oooo0?ooo`3oool0000001T0oooo00<000000?oo
o`3oool01P3oool400000280oooo00<000000?ooo`3oool08P3oool2000004T0oooo1000001:0?oo
o`030000003oool0oooo06<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool0
0`000000oooo0?ooo`0R0?ooo`050000003oool000000?ooo`0000008P3oool010000000oooo0?oo
o`3oool2000001H0oooo0P0000090?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
8P3oool2000004T0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`1S0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3oool08P3oool600000240
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00T0
oooo0P00000T0?ooo`030000003oool0oooo0280oooo0P00001:0?ooo`030000003oool0oooo04L0
oooo1@00001T0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?oo
o`3oool07P3oool7000000030?ooo`000000oooo0240oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0?0?ooo`8000001P3oool400000080oooo00<000000?ooo`0000008`3oool00`00
0000oooo0?ooo`0R0?ooo`800000B`3oool00`000000oooo0?ooo`160?ooo`040000003oool0oooo
000006D0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?oo
o`0Q0?ooo`060000003oool0oooo0000003oool000008P3oool00`000000oooo0?ooo`050?ooo`<0
00002P3oool4000000h0oooo00@000000?ooo`3oool000008P3oool00`000000oooo0?ooo`0R0?oo
o`<00000B`3oool00`000000oooo0?ooo`160?ooo`030000003oool0000006D0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0
oooo00<000008P3oool00`000000oooo0?ooo`070?ooo`/000004P3oool010000000oooo0?ooo`00
000R0?ooo`030000003oool0oooo0280oooo0P0000190?ooo`040000003oool0oooo000004T0oooo
0P00001U0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo00<000000?ooo`3o
ool08@3oool01P000000oooo0?ooo`000000oooo00000280oooo00<000000?ooo`3oool0903oool3
000002<0oooo00<000000?ooo`3oool08P3oool2000004X0oooo0P00001;0?ooo`030000003oool0
oooo06<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool00`000000oooo0?oo
o`0P0?ooo`050000003oool0oooo0?ooo`000000903oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo02<0oooo00<000000?ooo`3oool08P3oool200000?d0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c<P3oool00`000000oooo0?ooo`0L0?ooo`<00000103oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08`3oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo0?/0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c<`3ooolN000000L0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0T0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`3k0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<bP0ooooo`00002A000003H0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cE`3oool2000000@0oooo5000000<0?ooo`030000003o
ool0oooo02<0oooo0P00000U0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0B@3o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo06<0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cF03oool00`000000oooo00000002000001@0oooo0`0000090?ooo`030000
003oool0oooo02@0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo0?/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool3000001T0
oooo0`0000060?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08`3oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo0?/0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<cF03oool2000001d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0T0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0T0?oo
obD00000/P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=H0?ooo`8000007P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08`3oool0
0`000000oooo0?ooo`0S0?ooo`8000007@3oool8000002D0oooo2P00002X0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<eP0oooo00<000000?ooo`3oool07P3oool01@000000oooo0?oo
o`3oool0000002H0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`030000
003oool0oooo01L0oooo1@00000g0?ooo``00000W03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=H0?ooo`030000003oool0oooo01h0oooo00D000000?ooo`3oool0oooo0000000V0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0B0?oo
o`D00000B03oool4000009P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool0
0`000000oooo0?ooo`0O0?ooo`040000003oool0oooo000002H0oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0100oooo0P00001A0?ooo`H00000TP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=H0?ooo`030000003oool0oooo01l0oooo
00@000000?ooo`3oool000009P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02<0
oooo00<000000?ooo`3oool03P3oool2000005T0oooo1P00002<0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<eP0oooo00<000000?ooo`3oool07`3oool010000000oooo0?ooo`00000V
0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08`3oool2000000h0oooo00<00000
0?ooo`3oool0G`3oool2000008X0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0000002H0oooo00<000000?ooo`3oool02`3o
ool4000001@0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0680oooo0`0000270?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<eP0oooo
00<000000?ooo`3oool0803oool00`000000oooo0000000V0?ooo`030000003oool0oooo00P0oooo
0`0000040?ooo`<000004@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0IP3oool3000008@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cF03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0000002H0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`080?ooo`8000003`3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0JP3oool400000800oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0P0?ooo`030000003oool00000
02H0oooo00<000000?ooo`3oool01@3oool2000000d0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0K`3oool20000
07h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0000002H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool08`3oool2000000T0oooo00<00000
0?ooo`3oool0LP3oool2000007`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0000002H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07@0oooo0P00001j0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<eP0oooo00<000000?ooo`3oool0803oool00`000000oooo
0000000V0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`1g0?ooo`800000N03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=H0?ooo`03
0000003oool0oooo0240oooo0P00000V0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`1i0?ooo`800000MP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=H0?ooo`030000003oool0oooo0240oooo0P00000V0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1l0?ooo`800000M03oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0S
0?ooo`8000001`3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo0740oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0800oooo0P00001a0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`050000003oool0oooo0?ooo`00
00005`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`220?ooo`800000K`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=l0?ooo`8000009P3oool01@000000oooo0?ooo`3oool0000001P0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0Q03oool00`000000oooo0?ooo`1/0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<g`0oooo0P00000V0?ooo`050000003oool0oooo0?ooo`000000603oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo01T0oooo0`0000070?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`1[0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`050000003oool0oooo0?ooo`000000603oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0103oool30000
00@0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`1Z0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103U
iND0VIVI09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`050000003oool0oooo0?ooo`0000006@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08P0oooo0P00001Z0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`040000003oool0oooo000001X0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`<000001`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo08/0oooo00<000000?ooo`3oool0I`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool010000000oooo0?ooo`00000J
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`1V
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`040000003o
ool0oooo000001X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`2>0?ooo`030000
003oool0oooo06D0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0
oooo00@000000?ooo`3oool000006`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
01T0oooo100000060?ooo`8000000`3oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo
06@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0oooo00@00000
0?ooo`3oool000006`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo06<0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0oooo00@000000?ooo`3oool0
00006`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo0680oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0oooo00@000000?ooo`3oool000006`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`2B0?ooo`030000003oool0oooo0640oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cO03oool2000002H0oooo00@000000?ooo`3oool000006`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`2C0?ooo`030000003oool0oooo0600oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cO03oool2000002H0oooo00@000000?ooo`3oool00000703oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`2D0?oo
o`030000003oool0oooo05l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2
000002H0oooo00<000000?ooo`0000007@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02<0oooo0P0000020?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0GP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000
000M0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool08`3oool01@000000oooo0?oo
o`3oool0000009T0oooo00<000000?ooo`3oool0G@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000000M0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`3oool0000009X0oooo00<000000?oo
o`3oool0G03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool0
0`000000oooo0000000N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool08`3oool0
1@000000oooo0?ooo`3oool0000009/0oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000000N0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`3oool0000009/0
oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?oo
o`8000009P3oool00`000000oooo0000000N0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool08`3oool200000080oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`1J0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`030000003oool0
000001h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0S0?ooo`040000003oool0
oooo000009d0oooo00<000000?ooo`3oool0FP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000000N0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool08`3oool010000000oooo0?ooo`00002N0?ooo`030000003oool0oooo05T0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0oooo00<000000?oo
o`0000007P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00@000000?oo
o`3oool00000W`3oool00`000000oooo0?ooo`1H0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<g`0oooo0P00000V0?ooo`030000003oool0000001h0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0S0?ooo`040000003oool0oooo000009l0oooo00<000000?ooo`3oool0
F03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000
oooo0000000N0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool08`3oool200000003
0?ooo`000000oooo09l0oooo00<000000?ooo`3oool0E`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000000N0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool08`3oool010000000oooo0?ooo`00002Q0?ooo`030000003oool0
oooo05H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000002H0oooo00<0
00000?ooo`0000007P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00@0
00000?ooo`3oool00000X@3oool00`000000oooo0?ooo`1F0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<g`0oooo0P00000V0?ooo`030000003oool0000001l0oooo00D000000?ooo`3o
ool0oooo0000000U0?ooo`040000003oool0oooo00000:80oooo00<000000?ooo`3oool0E@3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000
000O0?ooo`050000003oool0oooo0?ooo`0000005@3oool4000000<0oooo0P0000070?ooo`040000
003oool0oooo00000:80oooo00<000000?ooo`3oool0E@3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=l0?ooo`8000009P3oool00`000000oooo0000000O0?ooo`050000003oool0oooo
0?ooo`0000005`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103o
ool400000:<0oooo00<000000?ooo`3oool0E03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=m0?ooo`030000003oool0oooo02@0oooo0P00000P0?ooo`050000003oool0oooo0?ooo`00
00005`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool01000
0000oooo0?ooo`00002S0?ooo`030000003oool0oooo05@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cO@3oool00`000000oooo0?ooo`0T0?ooo`800000803oool01@000000oooo0?oo
o`3oool0000001L0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0
oooo00@000000?ooo`3oool00000Y03oool00`000000oooo0?ooo`1C0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103U
iND0VIVI09VIV@2IVIT203<c<gd0oooo00<000000?ooo`3oool0903oool200000200oooo00D00000
0?ooo`3oool0oooo0000000G0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`040?ooo`040000003oool0oooo00000:@0oooo00<000000?ooo`3oool0D`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=m0?ooo`030000003oool0oooo02@0oooo0P00000P0?oo
o`050000003oool0oooo0?ooo`0000005@3oool3000000<0oooo00@000000?ooo`3oool000001P3o
ool010000000oooo0?ooo`00002U0?ooo`030000003oool0oooo0580oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cO@3oool00`000000oooo0?ooo`0T0?ooo`800000803oool01@000000
oooo0?ooo`3oool0000001L0oooo00<000000?ooo`3oool00P3oool2000000L0oooo0P0000000`3o
ool000000?ooo`2T0?ooo`030000003oool0oooo0580oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<cO@3oool00`000000oooo0?ooo`0T0?ooo`800000803oool01@000000oooo0?ooo`3o
ool0000002D0oooo00@000000?ooo`3oool00000YP3oool00`000000oooo0?ooo`1A0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<gd0oooo00<000000?ooo`3oool0903oool200000200
oooo00D000000?ooo`3oool0oooo0000000U0?ooo`040000003oool0oooo00000:H0oooo00<00000
0?ooo`3oool0D@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=m0?ooo`030000003o
ool0oooo02@0oooo0P00000P0?ooo`050000003oool0oooo0?ooo`0000009@3oool00`000000oooo
0000002X0?ooo`030000003oool0oooo0500oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cO@3oool00`000000oooo0?ooo`0T0?ooo`800000803oool01@000000oooo0?ooo`3oool00000
02D0oooo00<000000?ooo`000000Z03oool00`000000oooo0?ooo`1@0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103U
iND0VIVI09VIV@2IVIT203<c<gd0oooo00<000000?ooo`3oool0903oool200000200oooo00D00000
0?ooo`3oool0oooo0000000U0?ooo`<00000Z@3oool00`000000oooo0?ooo`1?0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<gd0oooo00<000000?ooo`3oool0903oool200000200oooo
00D000000?ooo`3oool0oooo0000000U0?ooo`030000003oool000000:T0oooo00<000000?ooo`3o
ool0C`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=m0?ooo`030000003oool0oooo
02@0oooo0P00000P0?ooo`050000003oool0oooo0?ooo`0000009@3oool00`000000oooo0000002Z
0?ooo`030000003oool0oooo04h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cY03o
ool200000240oooo00@000000?ooo`3oool000009@3oool00`000000oooo0000002Z0?ooo`030000
003oool0oooo04h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cY03oool200000240
oooo00@000000?ooo`3oool000009@3oool00`000000oooo0000002[0?ooo`030000003oool0oooo
04d0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cY03oool200000240oooo00@00000
0?ooo`3oool000009@3oool300000:/0oooo00<000000?ooo`3oool0BP3oool40000o`H0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VI
V@2IVIT203<c<j@0oooo0P00000Q0?ooo`040000003oool0oooo000002D0oooo00<000000?ooo`00
0000[03oool00`000000oooo0?ooo`1<0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<j@0oooo0P00000Q0?ooo`040000003oool0oooo000002D0oooo00<000000?ooo`000000[03oool0
0`000000oooo0?ooo`180?ooo`D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooof0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<aX0oooo0P000?l30?ooo`80003o<@3oool4000002/0oooo
1000000:0?ooo`@000004@3oool2000003h0oooo0P0000040?ooo`@00000o`3oool10?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<aX0oooo00<0003o0?ooo`3oool00`3oool00`000?l0
oooo0?ooo`0_0?ooo`800000;@3oool2000000h0oooo0P0000040?ooo`8000002P3oool2000000d0
oooo0P00000K0?ooo`800000503oool2000000D0oooo0P00003o0?ooo`40oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c503oool01`000?l0oooo0000o`3oool0003o0?ooo`000?l00P3o
ool20000o`040?ooo`000?l0oooo0000o`d0oooo1@0000040?ooo`H000000`3oool4000000D0oooo
0`0000040?ooo`8000001@3oool4000000<0oooo1P0000000`3oool000000000000>000000030?oo
o`000000000000@000000`3oool2000000@0oooo1P0000040?ooo`8000001@3oool2000000T0oooo
0P0000040?ooo`H00000103oool200000180oooo100000050?ooo`8000002P3oool4000000D0oooo
0P0000050?ooo`800000o`3oool10?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0
oooo00T0003o0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l00P3oool20000o`<0oooo1000
0?l90?ooo`800000203oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000040?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P00
00030?ooo`H000000P3oool6000000030?ooo`00000000000080oooo0P0000040?ooo`8000001@3o
ool4000000D0oooo0P00000@0?ooo`8000001@3oool4000001P0oooo0P0000020?ooo`8000003`3o
ool200000080oooo0P0000040?ooo`8000001@3oool200000?l0oooo0@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<D0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000o`040?oo
o`80003o403oool2000000P0oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool60000
0080oooo1P0000000`3oool00000000000020?ooo`800000103oool2000000H0oooo0P0000060?oo
o`8000003`3oool2000000L0oooo0P00000A0?ooo`D000001`3oool2000001<0oooo0P0000050?oo
o`800000103oool200000?l0oooo0@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<D
0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`030000o`3oool0003o00<0oooo
10000?l90?ooo`D000001@3oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000H0oooo
0P0000030?ooo`8000000P3oool4000000030?ooo`000000000000<000000`3oool600000080oooo
1P0000020?ooo`D00000103oool2000000H0oooo0P0000060?ooo`800000403oool2000000H0oooo
0P00000I0?ooo`8000000P3oool2000000l0oooo0P0000020?ooo`800000103oool2000000D0oooo
0P00003o0?ooo`40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c503oool010000?l0
oooo0000o`000?l20?ooo`030000o`3oool0oooo0080oooo0P000?l00`3oool0003o0?ooo`0=0?oo
o`8000000P3oool2000000@0oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`8000000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool600000080oooo1P0000000`3o
ool00000000000020?ooo`800000103oool2000000D0oooo100000050?ooo`800000403oool20000
00D0oooo1000000H0?ooo`D00000403oool5000000D0oooo0P0000050?ooo`800000o`3oool10?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo00<0003o0?ooo`3oool00`3oool0
0`000?l0oooo0000o`020?ooo`80003o403oool200000080oooo0P0000040?ooo`8000001@3oool4
000000<0oooo1@0000040?ooo`8000000`3oool2000000L0oooo100000030?ooo`H000000P3oool6
000000<0oooo100000050?ooo`800000103oool6000000@0oooo0P00000@0?ooo`800000103oool6
000001L0oooo0P00000C0?ooo`800000203oool2000000D0oooo0P00003o0?ooo`40oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c503oool00`000?l0oooo0?ooo`030?ooo`80003o00<0
oooo0000o`000?l00P000?l@0?ooo`8000000P3oool2000000@0oooo0P00000=0?ooo`8000001P3o
ool2000000@0oooo0P0000020?ooo`8000008`3oool2000000h0oooo0P00000@0?ooo`8000008@3o
ool2000001<0oooo0P0000080?ooo`8000001@3oool200000?l0oooo0P000?l60?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<`0?ooo`H000000`3oool4000000d0oooo0P0000060?ooo`@000000`3oool5000002<0oooo
1000000:0?ooo`@000004@3oool200000200oooo1P00000?0?ooo`H000000`3oool2000000@0oooo
1000003n0?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook03oool010000?l0
oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo00D0003o0?ooo`3oool0oooo0000
o`060?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonX0oooo1P000?l20?ooo`D0003o203oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
o`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<cL0oooo0`00003o0?oook`0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<cP0oooo00<000000?ooo`3oool0o`3ooonk
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<h0?ooo`030000003oool0oooo0?l0oooo^`3oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
3`3oool300000080oooo0`0000000`3oool0000000000006000000D0oooo1P0000060?ooo`800000
00<0oooo0000003oool00P3oool010000000oooo0000000000020?ooo`<0000000@0oooo00000000
000000000`3oool00`000000oooo0?ooo`030?ooo`<000000P3oool3000000D0oooo00<000000?oo
o`0000000P000000103oool000000000003oool2000000D0oooo0`0000020?ooo`8000000P3oool3
000000070?ooo`00000000000?ooo`000000oooo000000020?ooo`8000000`3oool2000000030?oo
o`000000000000H0oooo0`0000070?ooo`<000000`3oool2000000030?ooo`000000000000800000
00@0oooo000000000000oooo0P0000030?ooo`030000003oool000000080000000@0oooo00000000
000000000P3oool3000000050?ooo`00000000000?ooo`000000o`3ooolc0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<@0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo
000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`060000003oool0oooo0000
003oool000000`3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
000000020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool01P000000
oooo0?ooo`000000oooo00000080oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`00
0000oooo00000080oooo0P0000080?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`00
0000oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`3o0?oooc@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`8000001@3oool010000000
oooo0?ooo`3oool2000000@0oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`0000000`3oool00`000000oooo000000050?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo000000080?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`0000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000080?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool01`000000oooo
0?ooo`3oool000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo0?l0oooo=03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`00000000001`3oool010000000oooo0000000000070?oo
o`<00000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo00000003000000D0oooo
00<000000?ooo`3oool0100000020?ooo`030000003oool0oooo00<0000000@0oooo0000003oool0
oooo100000000`3oool000000?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01`3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0o`3ooold0?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo00000002
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000@0oooo0P0000020?ooo`060000003oool0oooo0000003oool0
00000`3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo00000002
0?ooo`030000003oool0oooo00<0oooo0P0000001@3oool000000?ooo`3oool000000080oooo00<0
00000?ooo`0000000P3oool00`000000oooo000000020?ooo`060000003oool0oooo0000003oool0
00000P3oool2000000P0oooo00<000000?ooo`3oool01`3oool01@000000oooo0?ooo`3oool00000
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0?l0oooo=03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool00`000000oooo0?ooo`020?ooo`<00000
0P3oool200000080oooo0`0000040?ooo`8000000P3oool3000000D0oooo0P0000040?ooo`800000
00<0oooo0000000000000`3oool00`000000oooo0?ooo`03000000040?ooo`0000000000000000D0
oooo0`0000020?ooo`<000000`3oool300000080oooo0`0000030?ooo`8000001@3oool01@000000
oooo000000000000oooo008000000`3oool00`000000oooo0?ooo`02000000040?ooo`0000000000
00000080oooo0P0000030?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`06
0?ooo`<0000000@0oooo000000000000oooo0P0000000`3oool000000?ooo`02000000<0oooo0P00
00001@3oool00000000000000000oooo008000000P3oool300000080oooo00@000000?ooo`000000
00000`3oool00`000000oooo0?ooo`3o0?oooc40oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000005P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool0
1@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`3o0?oood@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0000000Y0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01@3oool6000000D0
oooo00<000000?ooo`3oool0o`3ooomH0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`T000001@3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo01D0oooo0P00000E0?ooo`8000001P3oool20000
01D0oooo0P00000A0?ooo`8000004`3oool2000001D0oooo00<000000?ooo`3oool0o`3ooom00?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?oooo<0oooo10000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo80oooo
1@000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`D0003o
0P3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c7P3oool20000
o`<0oooo0P000?oo0?ooolX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c7P3oool0
0`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo0?l0oooob03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<C0?ooo`<0003o0`3oool20000o`80oooo0P000?l00`3oool0003o0000
o`030000o`h0oooo0`0000050?ooo`030000003oool0oooo00@0oooo0`0000040?ooo`<000000`3o
ool5000000<0oooo0`0000030?ooo`D00000103oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo0?ooo`D000000`3oool300000?l0ooooM@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<B0?ooo`0?0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0
oooo0000o`3oool0003o00<0oooo00<0003o0?ooo`000?l00`000?l<0?ooo`030000003oool0oooo
00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000001@3oool010000000oooo0?ooo`0000060?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo0000003o0?ooog@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c4P3oool03@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3o
ool0003o0?ooo`000?l00P3oool010000?l0oooo0?ooo`000?lB0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00L0oooo0P0000070?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo0000003o0?ooog@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c4P3oool03@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3o
ool0003o0?ooo`000?l00`3oool010000?l0oooo0000o`3oool40000o`X0oooo1000000=0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`060?ooo`8000001`3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000o`3ooomd0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<a80oooo00X0003o0?ooo`3oool0oooo0000o`3oool0003o0?oo
o`000?l0oooo0`000?l40?ooo`80003o3P3oool01@000000oooo0?ooo`3oool0000000/0oooo0P00
00050?ooo`8000001P3oool010000000oooo0?ooo`3oool4000000H0oooo00<000000?ooo`3oool0
103oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo0000003o0?ooog@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4P3oool0
1@000?l0oooo0?ooo`3oool0003o00D0oooo00D0003o0?ooo`000?l0oooo0000o`020?ooo`80003o
3P3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool0103oool010000000
oooo0?ooo`0000030?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo0000
00040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`000000o`3ooomd0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<a<0oooo0`000?l80?ooo`80003o00<0oooo0000o`000?l00P000?l>0?ooo`05
0000003oool0oooo0?ooo`0000002@3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000003@3oool3000000@0oooo00H000000?ooo`3o
ool0oooo0000003oool5000000040?ooo`0000000000000000@0oooo00<000000?ooo`3oool0o`3o
oomP0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=03oool3000000/0oooo0`0000040?ooo`<00000
103oool3000000D0oooo0`0000030?ooo`<00000403oool00`000000oooo0?ooo`030?ooo`<00000
103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000o`3ooomU0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<gh0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooH@3oool20000o`H0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<gh0oooo00@000000?ooo`3oool0oooo0`0000050?ooo`030000003oool0oooo0?l0ooooH03o
ool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`<000000`3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo00000?l0ooooH@3oool010000?l0oooo0?ooo`000?l60?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=n0?ooo`040000003oool0oooo0?ooo`<000000P3oool400000?l0ooooH03o
ool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`H0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<aX0oooo0P000?l30?ooo`80003o6@3oool4000000X0oooo1000
003o0?oooj<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c6P3oool00`000?l0oooo
0?ooo`030?ooo`030000o`3oool0oooo01L0oooo0P00000>0?ooo`800000o`3ooonS0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo00P0003o0?ooo`000?l0oooo0000o`3oool0
003o0?ooo`D0003o00<0oooo0000o`3oool0303oool4000000030?ooo`000000000000<0oooo0P00
00030?ooo`8000000P3oool2000000D0oooo0P00003o0?oooj<0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c503oool02@000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`03
0?ooo`040000o`3oool0oooo0?ooo`@0003o2@3oool2000000040?ooo`0000000000000000<0oooo
0P0000030?ooo`80000000<0oooo0000000000000P0000040?ooo`800000o`3ooonS0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo00L0003o0?ooo`000?l0oooo0000o`3oool0
003o0080oooo00@0003o0?ooo`3oool0003o403oool2000000040?ooo`0000000000000000<0oooo
0P0000040?ooo`H00000103oool200000?l0ooooX`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<D0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`030000o`3oool0
003o00<0oooo10000?l90?ooo`H000000`3oool2000000D0oooo100000050?ooo`800000o`3ooonS
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo00@0003o0?ooo`000?l0003o
0P3oool00`000?l0oooo0?ooo`020?ooo`80003o00<0oooo0000o`3oool03@3oool6000000<0oooo
0P0000040?ooo`@000001P3oool200000?l0ooooX`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<D0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`000?l00P3oool20000oa00
oooo0`0000000`3oool00000000000030?ooo`8000000`3oool6000000D0oooo0P00003o0?oooj<0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c503oool00`000?l0oooo0?ooo`030?oo
o`80003o00<0oooo0000o`000?l00P000?l@0?ooo`<0000000<0oooo0000000000000`3oool20000
00<0oooo100000000`3oool00000000000040?ooo`800000o`3ooonR0?ooo`80003o1P3oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<03oool3000000030?ooo`0000000000008000000P3oool400000080oooo0P000002
0?ooo`8000000P3oool400000?l0ooooX@3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooon`0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`05
0000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`H0003o0P3oool5
0000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo1@000?l2
0?ooo`D0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<cX0oooo100000040?ooo`<000000`3oool500000080oooo100000030?oo
o`D000000P3oool5000000<0oooo0`0000030?ooo`@000000`3oool500000080oooo1@0000030?oo
o`<000000`3oool3000000@0oooo1@0000030?ooo`<00000103oool3000000@0oooo0`0000050?oo
o`<000000`3oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?oo
o`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?oo
o`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?oo
o`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?oo
o`<00000V03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<i0?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00@00000
0?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0
oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`00
00030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000
oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3o
ool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo09D0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?P3oool010000000oooo0?ooo`000003
0?ooo`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000H0oooo
00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003o
ool0oooo0?ooo`000000oooo1P0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo0000002G0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ch0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000`3oool4000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool01000
0000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool00000
0`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?oo
o`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo
00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`000003
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo
0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0U@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<j0?ooo`@00000103oool3000000H0oooo00@00000
0?ooo`3oool0oooo100000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3o
ool3000000<0oooo100000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo0080oooo100000040?ooo`<000000`3oool4000000<0oooo00@000000?ooo`3o
ool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`000000U`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<j0?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool01@3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000002G0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<cX0oooo00<000000?ooo`3oool0103oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0
oooo0`0000040?ooo`<00000103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo0`0000040?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo0`0000050?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0
oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo0000002G0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<cX0
oooo1@0000030?ooo`<00000103oool3000000<0oooo1@0000040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool3000000<0oooo1@0000030?ooo`<000001@3oool00`000000
oooo0?ooo`030?ooo`<00000103oool3000000D0oooo00<000000?ooo`3oool0103oool3000000<0
oooo0`0000050?ooo`<000001@3oool00`000000oooo0?ooo`020?ooo`<00000103oool3000000@0
oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0
oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0
oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3000000@0
oooo0`0000040?ooo`<00000103oool3000000@0oooo0`00002H0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
>P3oool3000000D0oooo0`0000040?ooo`<00000103oool3000000<0oooo0`0000040?ooo`@00000
0`3oool500000080oooo1@0000040?ooo`030000003oool0oooo0080oooo100000030?ooo`<00000
103oool3000000@0oooo0`0000040?ooo`<000001@3oool3000000<0oooo1@0000020?ooo`D00000
0P3oool3000000@0oooo0`0000040?ooo`D000000P3oool4000000@0oooo0`0000040?ooo`<00000
103oool3000000<0oooo0`0000060?ooo`<000000P3oool5000000@0oooo0`0000030?ooo`<00000
103oool3000000<0oooo0`0000060?ooo`030000003oool0oooo00<0oooo0`0000030?ooo`D00000
0P3oool4000000@0oooo0`0000030?ooo`@000000`3oool5000000<0oooo0`0000030?ooo`D00000
0`3oool3000000@0oooo0`0000030?ooo`D000000P3oool4000000@0oooo0`0000040?ooo`<00000
0`3oool3000000H0oooo00<000000?ooo`3oool00P3oool3000000@0oooo1@0000030?ooo`<00000
103oool3000000<0oooo1@0000040?ooo`030000003oool0oooo0080oooo1@0000020?ooo`D00000
0`3oool3000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0H0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<cd0oooo00D000000?ooo`3oool0oooo000000030?oo
o`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`030?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000@0
oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000<0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?oo
o`3oool0oooo000000040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`070000003oool0oooo0?ooo`000000oooo
000000040?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0200oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?P3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo00@0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo00000005000000@0oooo00@000000?oo
o`3oool0oooo1P0000020?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0
oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool06@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<k0?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000000H0oooo00@000000?ooo`3oool0
00000`3oool010000000oooo0?ooo`3oool4000000H0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool01000
0000oooo0?ooo`3oool4000000<0oooo100000030?ooo`@000000`3oool4000000H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo10000003
0?ooo`@00000103oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo000000<0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0?oo
o`@0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`3oool4000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3o
ool0oooo100000050?ooo`030000003oool0oooo0080oooo100000040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<j0?ooo`050000003oool0oooo0?ooo`00
00000P3oool4000000D0oooo0P0000040?ooo`<000000`3oool01@000000oooo0?ooo`3oool00000
0080oooo100000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool01000
0000oooo0?ooo`3oool4000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`8000001P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00P3oool4000000<0oooo100000030?ooo`050000003oool0oooo0?ooo`000000
0`3oool3000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
00D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`@000001@3oool2
000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`040000003oool0oooo0?ooo`@00000
1@3oool00`000000oooo0?ooo`020?ooo`@000000`3oool4000000<0oooo100000050?ooo`030000
003oool0oooo00<0oooo0`0000060?ooo`030000003oool0oooo0080oooo0`0000030?ooo`@00000
1P3oool010000000oooo0?ooo`3oool4000000D0oooo0P0000030?ooo`@000000`3oool01@000000
oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo0?ooo`<00000
1P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01X0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`000003
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000001P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool00000
00H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000060?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`00
00030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00P0oooo00@0
00000?ooo`3oool000001P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool07`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<j0?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`<00000103oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool3000000@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`8000000`3oool3000000H0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo0`0000040?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000200oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c>`3oool3000000D0oooo0`0000030?ooo`<00000103oool3
000000@0oooo0`0000030?ooo`D000000`3oool3000000D0oooo00<000000?ooo`3oool00P3oool5
00000080oooo1@0000030?ooo`<00000103oool3000000@0oooo0`0000040?ooo`<00000103oool3
000000@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000050?ooo`030000003oool0
oooo0080oooo1@0000040?ooo`<000000`3oool3000000@0oooo0`0000040?ooo`<000001P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool3
000000<0oooo0`0000040?ooo`<000000`3oool5000000@0oooo0`0000040?ooo`030000003oool0
oooo0080oooo1@0000040?ooo`<000000P3oool5000000@0oooo00<000000?ooo`3oool00`3oool3
000000@0oooo0`0000040?ooo`<000001@3oool3000000<0oooo0`0000030?ooo`D000000`3oool3
000000D0oooo0`0000030?ooo`<000000`3oool5000000<0oooo0`0000040?ooo`<00000103oool3
000000@0oooo0`0000040?ooo`<000000`3oool5000000<0oooo0`0000040?ooo`<00000103oool3
000000<0oooo1@00000P0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ah0oooo0P000?l30?ooo`80003oo`3oooo:0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ah0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?ooolP0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool30000o`<0oooo0P000?l20?oo
o`80003o0`3oool00`000?l0oooo0000o`0>0?ooo`<000001@3oool3000000@0oooo0`0000030?oo
o`D000000`3oool3000000<0oooo1@0000020?ooo`D000000P3oool4000000D0oooo0`0000040?oo
o`<000000`3oool3000000<0oooo0`0000060?ooo`<00000103oool300000080oooo1@0000020?oo
o`@000000`3oool5000000<0oooo0`0000040?ooo`<000000`3oool5000000<0oooo0`0000030?oo
o`<00000103oool3000000@0oooo1@0000030?ooo`<00000103oool3000000@0oooo0`0000030?oo
o`@00000103oool3000000<0oooo1@0000030?ooo`<00000103oool3000000D0oooo00<000000?oo
o`3oool00`3oool3000000@0oooo0`0000050?ooo`<000000P3oool3000000D0oooo0`0000050?oo
o`030000003oool0oooo0080oooo1@0000020?ooo`@000000`3oool3000000D0oooo0`0000040?oo
o`<000000`3oool5000000<0oooo0`0000050?ooo`<000000`3oool3000000@0oooo0`0000030?oo
o`D000000`3oool3000000<0oooo1@0000020?ooo`D00000103oool3000000<0oooo0`0000040?oo
o`<000000`3oool4000000<0oooo0`0000040?ooo`D000001@3oool00`000000oooo0?ooo`0H0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a80oooo00d0003o0?ooo`3oool0oooo0000
o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o00<0oooo00@0003o0?ooo`000?l0oooo1000
0?l<0?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000@0oooo00@000000?oo
o`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00001@3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool01000
0000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo000000040?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3o
ool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000030?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0N0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<a80oooo00d0003o0?ooo`3oool0oooo0000o`3oool0003o
0?ooo`000?l0oooo0000o`3oool0003o00<0oooo00<0003o0?ooo`000?l04P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`0000001@0000000`3oool0000000000004000000H0oooo00<000000?oo
o`3oool0103oool00`000000oooo00000005000000030?ooo`000000000000@00000103oool00`00
0000oooo0?ooo`060?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000090?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0
oooo000000050?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00H0
00000?ooo`3oool0oooo0000003oool6000000H0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`040?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00H000000?ooo`3oool0oooo0000003oool60000
00H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00D0oooo00@0
00000?ooo`3oool0oooo1P0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0
000000L0oooo00<000000?ooo`3oool06@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<B0?ooo`0=0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000
o`030?ooo`040000o`3oool0003o0?ooo`@0003o2P3oool4000000H0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000
oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool01000
0000oooo0?ooo`3oool4000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
00<0oooo100000030?ooo`@00000103oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`040?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?oo
o`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`040000003oool0oooo0?ooo`@0
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`3oool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0103oool010000000oooo
0?ooo`3oool4000000@0oooo00<000000?ooo`3oool0803oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<B0?ooo`0:0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`<0
003o0`3oool00`000?l0oooo0000o`0>0?ooo`050000003oool0oooo0?ooo`000000103oool20000
00D0oooo0P0000060?ooo`040000003oool0oooo0?ooo`@000001P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo100000030?ooo`040000003oool0oooo000000<0oooo00@0
00000?ooo`3oool000001@3oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`02
0?ooo`@000001P3oool010000000oooo0?ooo`3oool4000000@0oooo0`0000050?ooo`030000003o
ool0oooo0080oooo100000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00`3oool2000000@0oooo0`0000040?ooo`<0
00000`3oool4000000<0oooo100000060?ooo`040000003oool0oooo0?ooo`@000000`3oool40000
00H0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00@0
00000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00P3oool4000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`@00000103oool3
000000H0oooo00@000000?ooo`3oool0oooo100000030?ooo`040000003oool0oooo000000D0oooo
0P0000040?ooo`<000001@3oool00`000000oooo0?ooo`020?ooo`@000001P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool4000000@0
oooo0`0000030?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0G0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4P3oool0
1@000?l0oooo0?ooo`3oool0003o00D0oooo00<0003o0?ooo`000?l00P3oool20000o`030?ooo`00
0?l0oooo00d0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo00@0oooo
00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000060?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`000000103oool00`000000oooo000000070?ooo`040000003oool0oooo000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000@0oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000001P3oool010000000
oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000001P3o
ool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00L0oooo00D000000?ooo`3oool0oooo000000030?ooo`04
0000003oool0oooo000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`0000001`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<a<0oooo0`000?l80?ooo`80003o0P3oool30000o`h0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`<00000103oool00`000000oooo
0?ooo`060?ooo`8000001@3oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`000000103oool2000000D0oooo0P0000030?ooo`<00000103oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000P3oool3000000D0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103o
ool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo0`0000040?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`050?ooo`8000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`<000001@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000000P3oool3000000H0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000007`3oool20000o`H0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c
<c@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000050?ooo`<000000`3oool30000
00D0oooo00<000000?ooo`3oool00P3oool5000000D0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`020?ooo`<00000103oool3000000H0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo1@0000030?ooo`<000001@3oool30000
00<0oooo0`0000050?ooo`030000003oool0oooo00@0oooo0`0000030?ooo`<00000103oool30000
00@0oooo0`0000040?ooo`<00000103oool3000000@0oooo0`0000030?ooo`D00000103oool30000
00<0oooo0`0000050?ooo`<00000103oool300000080oooo1@0000030?ooo`<00000103oool30000
00H0oooo00<000000?ooo`3oool00P3oool3000000@0oooo0`0000030?ooo`D00000103oool00`00
0000oooo0?ooo`020?ooo`D000000`3oool3000000D0oooo0`0000030?ooo`<00000103oool30000
00D0oooo0`0000050?ooo`030000003oool0oooo0080oooo0`0000040?ooo`<000001@3oool00`00
0000oooo0?ooo`040?ooo`<000000`3oool3000000D0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`030?ooo`<000000`3oool3000000<0oooo1@0000030?ooo`<00000103oool30000
01l0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo/0?ooo`040000o`3oool0
oooo0000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool01@000?l0oooo0?ooo`3oool0003o00H0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`H0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`D0003o1P3oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<aX0oooo
0P000?l30?ooo`80003oo`3oooo>0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<aX0
oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?oool`0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c503oool01`000?l0oooo0000o`3oool0003o0?ooo`000?l00`3o
ool01@000?l0oooo0000o`3oool0003o00h0oooo1P0000030?ooo`@00000103oool4000000H0oooo
0P00003o0?oooj40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c503oool01`000?l0
oooo0000o`3oool0003o0?ooo`000?l00`3oool00`000?l0oooo0000o`030?ooo`@0003o2`3oool2
000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000050?ooo`800000o`3ooonQ
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo00L0003o0?ooo`000?l0oooo
0000o`3oool0003o00<0oooo00<0003o0?ooo`000?l04P3oool2000000@0oooo0P0000020?ooo`80
00000P3oool200000080oooo0P00003o0?ooojP0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c503oool01`000?l0oooo0000o`3oool0003o0?ooo`000?l00`3oool00`000?l0oooo0000
o`030?ooo`@0003o2`3oool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00
00050?ooo`800000o`3ooonQ0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo
00@0003o0?ooo`000?l0003o0P3oool02@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000
o`0@0?ooo`800000103oool200000080oooo0P0000020?ooo`8000000P3oool2000000D0oooo0P00
003o0?oooj40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c503oool00`000?l0oooo
0?ooo`030?ooo`030000o`3oool0oooo0080003o00<0oooo0000o`3oool03`3oool4000000@0oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000050?ooo`800000o`3ooonQ0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<a@0oooo00<0003o0?ooo`3oool00`3oool20000o`80
oooo0`000?lA0?ooo`<00000103oool200000080oooo0P0000020?ooo`8000000P3oool2000000D0
oooo0P00003o0?oooj00oooo0P000?l60?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<c0?ooo`8000001@3oool40000
00@0oooo100000060?ooo`800000o`3ooonO0?ooo`030000o`3oool0003o00H0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooook03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo
00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonX0oooo1P000?l20?oo
o`D0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooo`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3oool50000
o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo0`0000020?ooo`<000000P3oool20000
0080oooo0`0000020?ooo`8000001@3oool6000000H0oooo0P0000000`3oool000000?ooo`020?oo
o`<000000P3oool2000000030?ooo`000000oooo008000000`3oool00`000000oooo0?ooo`030000
0080oooo0`0000001@3oool00000000000000000oooo0080000000<0oooo0000000000000P000000
0`3oool000000?ooo`3o0?oooi<0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<`h0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3o
ool000001@3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<0
00000?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00L000000?ooo`3oool0
oooo0000003oool000000080oooo00@000000?ooo`3oool00000o`3ooonG0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<>0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo0?ooo`800000103oool010000000oooo0?ooo`000005
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000103oool010000000oooo0?oo
o`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`0000000P3oool010000000
oooo0?ooo`00003o0?oooiL0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<`h0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0400000080oooo00<000000?ooo`3oool0100000050?ooo`040000003oool0
0000000000L0oooo0`0000050?ooo`040000003oool0oooo0?ooo`<0000000<0oooo0000003oool0
0`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool00`0000020?ooo`030000003oool0oooo0?l0ooooU@3oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3P3oool6
00000080oooo00@000000?ooo`3oool000000P3oool2000000050?ooo`000000oooo0?ooo`000000
1@3oool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00001@3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?oo
o`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`030000003oool0
00000080oooo00@000000?ooo`3oool00000o`3ooonG0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`050000003oool000000000
003oool00P0000050?ooo`8000000P3oool3000000D0oooo0P0000050?ooo`<000000P3oool20000
00<0oooo0P000000103oool000000000000000020?ooo`<000000P3oool00`000000oooo00000003
00000080oooo0P0000030?ooo`040000003oool0oooo00000?l0ooooU03oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
3P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0?l0ooooU@3oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c3P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`3o0?oooiD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo0`0000020?oo
o`<000004`3oool00`000000oooo0?ooo`0A0?ooo`800000603oool00`000000oooo0?ooo`040?oo
o`800000o`3ooonG0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo10000?l80?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?oooo80oooo1@000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooo0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<203<c
<`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<2
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT7
09VIV@80<c<c0P3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0P3oool00003
0>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0P3oool000030>GUi@2IVIT0VIVI0?l0VIVI
o`2IVIT709VIV@030>GUi@0c<c<0oooo0040oooo003o0>GUiOl0iNGU303UiND20?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{524, 431},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " notebooks are structured interactive documents that are organized into a \
sequence of ",
  StyleBox["cells", "TI"],
  ". Each cell contains material of a definite type\[LongDash]usually text, \
graphics, sounds or ",
  StyleBox["Mathematica", "TI"],
  " expressions. When a notebook is displayed on the screen, the extent of \
each cell is indicated by a bracket on the right.  "
}], "Text",
  CellTags->{"S1.3.4", "4.3"}],

Cell[TextData[{
  "The notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " provides many ways to enter and edit the material in a notebook. Some of \
these ways will be standard to whatever computer system or graphical \
interface you are using. Others are specific to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.3.4", "4.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Shift\[Hyphen]Enter  or  Shift\[Hyphen]Return "], Cell[
            TextData[{
              "send a cell of input to the ",
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.4"],

Cell[TextData[{
  "Doing a computation in a ",
  StyleBox["Mathematica", "SO"],
  " notebook. "
}], "Caption",
  CellTags->"S1.3.4"],

Cell[TextData[{
  "Once you have prepared the material in a cell, you can send it as input to \
the ",
  StyleBox["Mathematica", "TI"],
  " kernel simply by pressing Shift\[Hyphen]Enter or Shift\[Hyphen]Return. \
The kernel will send back whatever output is generated, and the front end \
will create new cells in your notebook to display this output. Note that if \
you have a numeric keypad on your keyboard, then you can use its Enter key as \
an alternative to Shift\[Hyphen]Enter. "
}], "Text",
  CellTags->{"S1.3.4", "4.5"}],

Cell[TextData[{
  "Here is a cell ready to be sent as input to the ",
  StyleBox["Mathematica", "TI"],
  " kernel."
}], "MathCaption",
  CellTags->{"S1.3.4", "4.6"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool`3oool5
0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<`3oool4000000h0
oooo1P0000030?ooo`@00000103oool400000?l0ooooW@3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<P3oool20000
0080oooo0P00000?0?ooo`800000103oool200000080oooo0P0000020?ooo`8000000P3oool20000
0?l0ooooW03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000000l0oooo0P0000040?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`800000o`3ooonL0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<f0?ooo`8000003`3o
ool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?oooi`0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<c@0oooo0`00000@0?ooo`800000103oool200000080oooo0P0000020?ooo`800000
0P3oool200000?l0ooooW03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000000<0oooo0P0000020?ooo`80
0000103oool4000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?oooi`0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<c80oooo0P0000020?ooo`800000103oool4000000H0oooo0`0000040?oo
o`8000000P3oool200000080oooo0P0000020?ooo`800000o`3ooonL0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<c
0?ooo`@000001P3oool2000000P0oooo0P0000050?ooo`@00000103oool400000?l0ooooW03oool2
0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom03oool010000?l0oooo0?ooo`000?l60?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooc0?oo
o`050000o`3oool0oooo0?ooo`000?l01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3oool60000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40
<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c
<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VI
V@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00
00<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2I
VIWo09VIV@H0VIVI0@3UiND103<c<`40oooo003o0>GUiOl0iNGU2`3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell["The output from the computation is inserted in a new cell.", \
"MathCaption",
  CellTags->{"S1.3.4", "4.7"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
j`3oool50000o`80oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c6`3oool20000o`H0oooo0P000?oo0?ooolX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c6`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo
0?l0oooob03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`80003o103oool0
0`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000
o`0=0?ooo`@000000`3oool500000080oooo100000040?ooo`<000001@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0080oooo100000030?ooo`D000000`3oool3000000D0oooo00<0
00000?ooo`3oool00`3oool3000000<0oooo1@0000030?ooo`<000000`3oool500000080oooo1@00
00030?ooo`<00000103oool3000000<0oooo1@0000030?ooo`<00000103oool3000000@0oooo0`00
00050?ooo`<000000`3oool3000000<0oooo1@0000020?ooo`D000000P3oool500000080oooo0`00
00060?ooo`030000003oool0oooo00<0oooo0`0000030?ooo`@00000103oool3000000<0oooo1@00
00020?ooo`D000000P3oool5000000@0oooo00<000000?ooo`3oool00P3oool5000000@0oooo00<0
00000?ooo`3oool00`3oool3000000<0oooo1@0000020?ooo`D000000`3oool3000000D0oooo00<0
00000?ooo`3oool00P3oool4000000<0oooo1@0000020?ooo`D000000`3oool3000000@0oooo0`00
00030?ooo`D00000KP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`040000
o`3oool0oooo0000o`80oooo00H0003o0?ooo`000?l0003o0?ooo`000?l20?ooo`030000o`3oool0
oooo0080oooo00H0003o0?ooo`3oool0oooo0000o`3oool40000o`L0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000050?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3o
ool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000@0oooo
00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo06h0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool00`000?l0oooo
0?ooo`020?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo
0?ooo`020?ooo`050000o`3oool0oooo0?ooo`000?l04@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool01P3oool01@000000oooo0?ooo`3oool00000
00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00H0oooo00D00000
0?ooo`3oool0oooo000000050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000060?ooo`04
0000003oool0oooo000000<0oooo00<000000?ooo`0000001@0000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000060?ooo`040000003oool0oooo000000<0oooo00D000000?ooo`3oool0
oooo000000070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`060?ooo`050000003oool0
oooo0?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0KP3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`030000o`3oool0oooo0080oooo00<0003o0?oo
o`000?l00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00H0003o0?oo
o`3oool0oooo0000o`3oool40000o``0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000001P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo100000050?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool0KP3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<<0?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P3oool01P000?l0
oooo0000o`000?l0oooo0000o`@0oooo00D0003o0?ooo`3oool0oooo0000o`0=0?ooo`@000001@3o
ool00`000000oooo0?ooo`020?ooo`@000001@3oool2000000H0oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`3oool4000000H0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool2000000H0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`8000001@3oool2000000D0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo0P0000030?ooo`@000000`3oool010000000oooo0?ooo`00
00030?ooo`@000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0
oooo100000030?ooo`@000000`3oool4000000H0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
000000D0oooo00@000000?ooo`3oool0oooo100000060?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`1^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<`d0oooo00@0003o0?ooo`3oool0003o1`3oool010000?l0oooo0?ooo`000?l30?ooo`80003o0`3o
ool00`000?l0oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103o
ool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000H0oooo
00@000000?ooo`3oool000001`3oool00`000000oooo000000030?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo0000
00060?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo
0?ooo`3oool0000000H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo06/0oooo10000?l60?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`80
003o2`3oool20000o`<0oooo00<0003o0?ooo`3oool00P000?l=0?ooo`030000003oool0oooo00@0
oooo0`0000040?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool3000000@0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool2000000@0oooo00<0
00000?ooo`3oool00`3oool3000000@0oooo0`0000040?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`0000000P3oool3000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo0`0000040?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo0`00001`0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<c80oooo1@0000040?ooo`030000003oool0oooo0080
oooo1@0000030?ooo`<000000`3oool500000080oooo1@0000020?ooo`D000000`3oool3000000@0
oooo0`0000030?ooo`D000000`3oool3000000@0oooo0`0000040?ooo`<000001@3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo0`0000040?ooo`<000001@3oool00`000000
oooo0?ooo`030?ooo`<00000103oool3000000D0oooo0`0000050?ooo`030000003oool0oooo00<0
oooo0`0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool3000000@0
oooo0`0000030?ooo`D00000103oool300000080oooo1@0000040?ooo`<000000`3oool3000000D0
oooo00<000000?ooo`3oool00`3oool3000000<0oooo1@0000030?ooo`<000000`3oool5000000<0
oooo0`0000040?ooo`<000001@3oool00`000000oooo0?ooo`030?ooo`<000000`3oool500000080
oooo1@0000030?ooo`<00000103oool3000000@0oooo0`0000040?ooo`<000001@3oool00`000000
oooo0?ooo`1]0?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo]0?ooo`030000o`3oool0003o
00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooook03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooon/0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onX0oooo1P000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`H0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<aP0oooo0P00
0?l60?ooo`80003oo`3oooo=0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<aP0oooo
00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`3o0?oool/0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c4@3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0
oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`030000o`3oool0oooo00X0oooo1000000>0?oo
o`H000000`3oool4000000@0oooo1000003o0?oooiL0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c4@3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o
0?ooo`3oool0oooo0000o`040?ooo`@0003o1P3oool200000080oooo0P00000?0?ooo`800000103o
ool200000080oooo0P0000020?ooo`8000000P3oool200000?l0ooooUP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l0
103oool01@000?l0oooo0?ooo`3oool0003o0180oooo0P00000?0?ooo`800000103oool200000080
oooo0P0000020?ooo`8000000P3oool200000?l0ooooUP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<A0?ooo`080000o`3oool0003o0000o`3oool0003o0?ooo`000?l40?ooo`050000
o`3oool0oooo0?ooo`000?l0103oool40000o`X0oooo0P00000?0?ooo`800000103oool200000080
oooo0P0000020?ooo`8000000P3oool200000?l0ooooUP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<A0?ooo`050000o`3oool0003o0?ooo`000?l00P3oool00`000?l0oooo0?ooo`02
0?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool00`000?l0oooo0?ooo`0;0?ooo`<00000403o
ool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?oooiH0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4@3oool00`000?l0oooo0?ooo`040?ooo`040000
o`3oool0oooo0?ooo`80003o0`3oool00`000?l0oooo0?ooo`0@0?ooo`8000000`3oool200000080
oooo0P0000040?ooo`@00000103oool200000080oooo0P0000020?ooo`8000000P3oool200000?l0
ooooUP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`030000o`3oool0oooo
00@0oooo0P000?l30?ooo`030000o`3oool0oooo0080003o3P3oool200000080oooo0P0000040?oo
o`@000001P3oool3000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?oo
oiH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool4000000H0oooo0P000008
0?ooo`8000001@3oool4000000@0oooo1000003o0?oooiH0oooo0P000?l60?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooond0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo/0?ooo`040000
o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool01@000?l0oooo0?ooo`3oool0
003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`80oooo1@000?l70?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
VOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030>GUi@2IVIT0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VI
V@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`00
o`3UiNGo0>GUi@/0iNGU0@3oool00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell[TextData[{
  "Most kinds of output that you get in ",
  StyleBox["Mathematica", "TI"],
  " notebooks can readily be edited, just like input. Usually ",
  StyleBox["Mathematica", "TI"],
  " will make a copy of the output when you first start editing it, so you \
can keep track of the original output and its edited form.  "
}], "Text",
  CellTags->{"S1.3.4", "4.8"}],

Cell[TextData[{
  "Once you have done the editing you want, you can typically just press \
Shift\[Hyphen]Enter to send what you have created as input to the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "Text",
  CellTags->{"S1.3.4", "4.9"}],

Cell[TextData[{
  "Here is a typical computation in a ",
  StyleBox["Mathematica", "TI"],
  " notebook. "
}], "MathCaption",
  CellTags->{"S1.3.4", "4.10"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000GB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT80>GUiOl0oooo?P3ooonj0>GU
i@<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonX0oooo1@000?l20?ooo`D0003o1`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo^0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cm03oool00`000000oooo0?ooo`3f0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cm03oool00`000000oooo0?ooo`050?ooo`D0
0000k03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<o<0oooo0P0000070?ooo`05
0000003oool0oooo0?ooo`000000k03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<o<0oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`3]0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<clP3oool010000000oooo0?ooo`0000080?ooo`030000003oool0
oooo0>`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?`0?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3[0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<cl@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo0000003/0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cmP3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
k03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<mX0oooo0P00000J0?ooo`030000
003oool0oooo00@0oooo0`00000I0?ooo`800000dP3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<mX0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0Q0?ooo`030000
003oool0oooo0=00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?J0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`3@0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cfP3oool00`000000oooo0?ooo`0J0?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool0d03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<mX0oooo00<000000?ooo`3oool06P3oool<000001L0oooo00<000000?ooo`3oool0
d03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a`0oooo0P000?l60?ooo`80003o
4@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0
?@3oool00`000000oooo0?ooo`3@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
703oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00l0oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`1/0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0
d03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo0P000?l40?ooo`030000
o`3oool0003o0080oooo00<0003o0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o0100
oooo0P00000>0?ooo`D000003P3oool2000000<0oooo0P00000:0?ooo`8000001`3oool5000000d0
oooo0P0000030?ooo`8000004@3oool5000000@0oooo0`0000001@3oool00000000000000000oooo
00@00000103oool3000000<0oooo100000030?ooo`D0000000@0oooo00000000000000000P3oool5
000000040?ooo`0000000000000000<0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`3@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool010000?l0oooo0?oo
o`000?l20?ooo`060000o`3oool0003o0000o`3oool0003o0P3oool00`000?l0oooo0?ooo`020?oo
o`060000o`3oool0oooo0?ooo`000?l0oooo10000?l;0?ooo`030000003oool0000000l0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000
2`3oool00`000000oooo000000080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool01@3oool01@000000
oooo0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3@0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool00`000?l0oooo0?ooo`020?oo
o`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0?ooo`020?oo
o`050000o`3oool0oooo0?ooo`000?l03`3oool010000000oooo0?ooo`00000?0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`040000003o
ool0oooo000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0000000/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`050000
003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00`3ooold
000000H0oooo00<000000?ooo`3oool0d03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<`d0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0
003o0080oooo00<0003o0?ooo`3oool00P3oool01P000?l0oooo0?ooo`3oool0003o0?ooo`@0003o
203oool00`000000oooo000000020?ooo`030000003oool0oooo00@0oooo1@0000040?ooo`030000
003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`000000
0P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo1@0000060?ooo`030000
003oool0oooo00P0oooo1@0000070?ooo`030000003oool0oooo00D0oooo1@0000030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool3000000@0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo03d0oooo00<000000?ooo`3oool0d03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`d0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020?oo
o`060000o`3oool0003o0000o`3oool0003o103oool01@000?l0oooo0?ooo`3oool0003o00h0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0000000:0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`0000002`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000P3oool3000000H0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3o
ool00P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0?@3oool00`000000
oooo0?ooo`3@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool010000?l0
oooo0?ooo`000?l70?ooo`040000o`3oool0oooo0000o`<0oooo0P000?l30?ooo`030000o`3oool0
oooo0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00@0oooo0`000000103oool0000000000000000=0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`<0000000@0oooo0000000000000000
2@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000
oooo000000030?ooo`030000003oool00000008000000`3oool3000000<0oooo00<000000?ooo`3o
ool0103oool3000000<0oooo00<000000?ooo`0000000P0000030?ooo`040000003oool000000000
00D0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3@0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c3`3oool20000o`/0oooo0P000?l30?ooo`030000o`3oool0oooo
0080003o4`3oool00`000000oooo0?ooo`0:0?ooo`<00000903oool00`000000oooo0?ooo`030?oo
o`<000009`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0403oool0
1@000000oooo0?ooo`3oool000000100oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`0m0?ooo`030000003oool0oooo0=00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<i0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo02H0oooo0`0000060?ooo`<000004`3oool4000000@0oooo00<0
00000?ooo`3oool0203oool2000000P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`0`0?ooo`030000003oool0oooo0=00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<j0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0d03oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<cX0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`1Y0?ooo`030000003oool0oooo00T0oooo0P00000>0?ooo`D000003P3oool2000000<0oooo0P00
000:0?ooo`030000003oool0oooo0=00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<j0?ooobL000003@3ooolO000004d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0000
000?0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?oo
o`3oool0000000/0oooo00<000000?ooo`3oool0d03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<mX0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000?0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000<0?ooo`03
0000003oool0oooo0=00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?J0?ooo`80
00001`3oool00`000000oooo000000020?ooo`030000003oool0oooo00@0oooo1@0000040?ooo`03
0000003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00X0oooo0P00003B0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ci03oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool000000=l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?Y0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`<0
000000@0oooo0000000000000000g@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<nT0oooo00<000000?ooo`3oool02P3oool300000?40oooo10000?l60?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<nT0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`3b0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cjP3oool00`000000oooo0?ooo`3o0?ooo`80003o1P3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?Z0?ooo`030000003oool0oooo0?h0oooo00<0003o0?ooo`000?l01P3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?Z0?ooobL00000f@3oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooojP3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oooY0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooZ0?ooo`D0003o1P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<I0?ooo`80003o1P3oool20000obh0oooo1000000U0?ooo`@000003@3oool400000180oooo1000
000O0?ooo`@000006P3oool400000180oooo1000000O0?ooo`@000006`3oool400000:l0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`030000o`3oool0oooo00H0oooo00<0
003o0?ooo`3oool0;`3oool2000002@0oooo0P00000@0?ooo`8000004`3oool2000002<0oooo0P00
00050?ooo`030000003oool0oooo01<0oooo0P00000C0?ooo`8000008`3oool2000000@0oooo0P00
000G0?ooo`800000[`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a80oooo00<0
003o0?ooo`000?l00P3oool00`000?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l0
0P3oool00`000?l0oooo0?ooo`090?ooo`H0000000<0oooo0000000000001P0000030?ooo`<00000
103oool4000000<0oooo1@0000030?ooo`D000000`3oool6000000@0oooo0`0000040?ooo`@00000
103oool2000000@0oooo1@0000040?ooo`D000000P3oool5000000D0oooo0`0000040?ooo`800000
103oool6000000L0oooo00<000000?ooo`3oool01@3oool6000000@0oooo0P0000050?ooo`800000
203oool5000000@0oooo1@0000020?ooo`D000001@3oool3000000@0oooo0P0000040?ooo`H00000
3`3oool6000000@0oooo0P0000050?ooo`800000303oool6000000@0oooo0P00002_0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c4P3oool00`000?l0oooo0000o`020?ooo`030000
o`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`@0003o203oool2000000@0
oooo0P0000020?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`80
000000<0oooo0000000000000P3oool2000000@0oooo0P0000040?ooo`8000000P3oool2000000@0
oooo0P0000000`3oool00000000000020?ooo`8000000P3oool2000000<0oooo0P0000040?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000000`3oool0
0000000000030?ooo`8000001@3oool4000000P0oooo00<000000?ooo`3oool01`3oool2000000H0
oooo0P0000060?ooo`030000003oool0oooo00H0oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000030?ooo`8000001P3oool2000000030?ooo`000000000000<0oooo0P0000050?ooo`@0
00004P3oool2000000H0oooo0P00000D0?ooo`@000001@3oool200000:l0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<B0?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`00
0?l0103oool01@000?l0oooo0?ooo`3oool0003o0100oooo0P0000040?ooo`8000000P3oool20000
00<0oooo0P0000050?ooo`8000001@3oool200000080oooo0P0000040?ooo`800000103oool20000
0080oooo0P0000040?ooo`8000001@3oool2000000L0oooo0P0000080?ooo`8000000P3oool20000
0080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P0000060?ooo`8000001`3oool50000
00L0oooo0P0000060?ooo`8000001P3oool2000000/0oooo0P0000020?ooo`8000000P3oool20000
00<0oooo0P0000060?ooo`8000001P3oool2000000H0oooo0P0000070?ooo`D000001`3oool20000
00H0oooo0P00000E0?ooo`8000001P3oool200000:l0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<B0?ooo`080000o`3oool0003o0000o`3oool0003o0?ooo`000?l40?ooo`050000
o`3oool0oooo0?ooo`000?l0103oool40000o`P0oooo0P0000040?ooo`8000000P3oool2000000<0
oooo0P0000050?ooo`H0000000<0oooo0000000000000P3oool2000000@0oooo0P0000050?ooo`D0
0000103oool2000000D0oooo1P0000030?ooo`800000203oool200000080oooo0P0000020?ooo`80
00000`3oool2000000H0oooo0P0000060?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3o
ool01`3oool2000000H0oooo0P0000070?ooo`030000003oool0oooo00T0oooo0P0000020?ooo`80
00000P3oool2000000<0oooo0P0000060?ooo`8000001P3oool2000000H0oooo0P00000C0?ooo`80
00001P3oool2000001D0oooo0P0000060?ooo`800000[`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<a80oooo00D0003o0?ooo`000?l0oooo0000o`020?ooo`030000o`3oool0oooo
0080oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`030000o`3oool0oooo00/0oooo0P000004
0?ooo`<0000000<0oooo0000000000000`3oool2000000D0oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool2000000@0oooo0`0000030?ooo`8000000P3oool2000000@0oooo0P000005
0?ooo`8000000P3oool2000000<0oooo0P0000050?ooo`@000000`3oool200000080oooo0P000003
0?ooo`<000001@3oool2000000H0oooo0P0000050?ooo`@00000203oool00`000000oooo0?ooo`07
0?ooo`8000001P3oool2000000L0oooo0P0000070?ooo`@000000`3oool200000080oooo0P000003
0?ooo`<000001@3oool2000000H0oooo0P0000050?ooo`@000004P3oool2000000H0oooo0P00000D
0?ooo`@000001@3oool200000:l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<B
0?ooo`030000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000o`3o
ool0oooo00h0oooo0P0000030?ooo`H000000`3oool5000000@0oooo100000030?ooo`H000000P3o
ool600000080oooo100000040?ooo`D00000103oool4000000@0oooo0P0000040?ooo`8000001`3o
ool6000000030?ooo`000000000000@000000P3oool5000000@0oooo0P0000040?ooo`H000003`3o
ool4000000H0oooo0P0000080?ooo`030000003oool0oooo00@0oooo0P0000070?ooo`H0000000<0
oooo000000000000100000020?ooo`D00000103oool2000000@0oooo1P00000?0?ooo`@000001P3o
ool2000001<0oooo1P0000040?ooo`800000[`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<a80oooo00<0003o0?ooo`3oool0103oool20000o`<0oooo00<0003o0?ooo`3oool00P00
0?l@0?ooo`8000003@3oool2000002H0oooo0P00000>0?ooo`800000103oool200000080oooo0P00
000C0?ooo`8000001P3oool2000001X0oooo0`0000060?ooo`800000203oool2000000D0oooo0P00
00020?ooo`8000004`3oool2000000H0oooo0P00000J0?ooo`<000001P3oool2000001d0oooo0P00
002^0?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`H000002`3oool2000002H0oooo0P00
000>0?ooo`@000000`3oool5000001<0oooo0P0000060?ooo`@000006@3oool2000000@0oooo1000
00090?ooo`030000003oool0oooo00@0oooo1@00000C0?ooo`8000001P3oool4000001T0oooo0P00
00040?ooo`@000006`3oool400000:d0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooon/0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonX0oooo
00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool60000o`80
oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2I
VIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@L0iNGU0@0c<c<1
0?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 93},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will automatically make a copy if you start editing the output. "
}], "MathCaption",
  CellTags->{"S1.3.4", "4.11"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000XB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool00080ooooo`00003o000000T000000@3oool000030?oo
o`3UiND0iNGU0?l0<c<co`0c<c<803<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0
iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooa80oooo00<000000?ooo`3oool0j03oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooolB0?ooo`030000003oool0oooo00D0oooo
1P00003M0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooa40oooo0P0000070?ooo`8000000P3oool200000=<0oooo1@000?l50?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooa40oooo
0P0000080?ooo`800000fP3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooa00oooo00@000000?ooo`3oool0
0000203oool200000=T0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oool@0?ooo`040000003oool0oooo0000
00T0oooo0P00003H0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo303oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo00P0oooo0P00003G0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo3@3oool3
000000<0oooo00<000000?ooo`3oool0103oool200000080oooo0P00003G0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooo3P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo1000003H
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooo503oool00`000000oooo0?ooo`3P0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooo503oool00`000000oooo0?ooo`3P0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<jP0oooo10000016
0?ooo`@000007P3oool00`000000oooo0?ooo`0P0?ooo`@00000603oool4000009l0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cZ03oool2000004P0oooo0P00000P0?ooo`030000003oool0oooo0280oooo0P00000J
0?ooo`800000W`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>X0?ooo`800000B03oool200000200oooo3@00000H
0?ooo`8000006P3oool2000009l0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo03/0oooo0P0000180?ooo`800000A@3oool2000001X0oooo0P00000`
0?ooo`@000007@3oool4000004X0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo03/0oooo0P0000180?ooo`800000A@3oool2000000@0oooo0P00000D
0?ooo`8000001`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0200oooo0P00000O
0?ooo`800000B`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`8000003P3oool6000000P0oooo00<00000
0?ooo`3oool01@3oool6000000d0oooo0P0000070?ooo`H000001`3oool00`000000oooo0?ooo`05
0?ooo`H000002P3oool00`000000oooo0?ooo`040?ooo`D000001@3oool2000000@0oooo1P000004
0?ooo`P0000000<0oooo0000000000000`0000040?ooo`@000000`3oool5000000<0oooo1P000000
0`3oool000000000000>00000080oooo0P0000150?ooo`8000001@3oool2000000T0oooo1P000004
0?ooo`8000001`3oool2000000D0oooo0P0000090?ooo`D000000`3oool6000000030?ooo`000000
000000H0000000<0oooo0000000000000`0000030?ooo`H000000P3oool600000080oooo1@000005
0?ooo`800000BP3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`800000403oool2000000X0oooo00<00000
0?ooo`3oool01P3oool4000000h0oooo0P0000090?ooo`8000002@3oool00`000000oooo0?ooo`06
0?ooo`@000002`3oool00`000000oooo0?ooo`050?ooo`80000000<0oooo000000000000103oool2
000000@0oooo0P0000020?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001@3oool2
00000080oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P0000040?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`8000000`3oool2000004D0oooo0P00000A0?ooo`@000001@3oool2
000000P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`8000000P3oool2
000000@0oooo0P0000040?ooo`H000000P3oool200000080oooo0P0000040?ooo`8000001P3oool2
000000D0oooo0P0000070?ooo`800000BP3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<_0?ooo`040000003oool0
oooo000000H0oooo1@0000040?ooo`800000203oool5000000L0oooo0P00000>0?ooo`040000003o
ool0oooo000000P0oooo0P0000070?ooo`D000001`3oool2000000X0oooo1@0000050?ooo`800000
0P3oool2000000<0oooo0P0000050?ooo`800000203oool6000000<0oooo0P0000050?ooo`800000
2P3oool2000000@0oooo0P0000040?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
0`3oool2000000H0oooo>@0000060?ooo`8000004P3oool2000000H0oooo0P0000080?ooo`800000
1@3oool2000000`0oooo0P0000040?ooo`800000103oool600000080oooo0P0000020?ooo`800000
103oool2000000H0oooo0P0000050?ooo`8000001P3oool4000004T0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
;`3oool010000000oooo0?ooo`00000?0?ooo`8000002P3oool00`000000oooo0?ooo`070?ooo`80
00003P3oool010000000oooo0?ooo`0000080?ooo`8000002@3oool00`000000oooo0?ooo`070?oo
o`800000303oool00`000000oooo0?ooo`050?ooo`8000000P3oool2000000<0oooo0P0000060?oo
o`800000203oool4000000@0oooo0P0000050?ooo`8000002P3oool2000000@0oooo0P0000040?oo
o`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool2000004D0oooo0P00000B0?oo
o`8000001P3oool2000000T0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?oo
o`800000103oool2000000@0oooo1P0000020?ooo`8000000P3oool2000000@0oooo0P0000060?oo
o`8000001@3oool2000000H0oooo100000190?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b/0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`0=0?ooo`8000002P3oool00`000000oooo0?ooo`06
0?ooo`@000002@3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00H0oooo0P00
00090?ooo`030000003oool0oooo00H0oooo1000000;0?ooo`030000003oool0oooo00D0oooo0P00
00020?ooo`8000000`3oool2000000L0oooo0P0000070?ooo`@00000103oool3000000@0oooo0P00
00020?ooo`8000000`3oool4000000D0oooo0P0000040?ooo`<0000000<0oooo0000000000000P3o
ool200000080oooo0P0000030?ooo`800000A@3oool200000140oooo100000050?ooo`8000002@3o
ool2000000D0oooo0P0000080?ooo`@000001@3oool2000000@0oooo1P0000020?ooo`8000000P3o
ool2000000@0oooo0P0000060?ooo`8000001@3oool2000000D0oooo0P0000020?ooo`800000B03o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c</0?ooo`<000000`3oool00`000000oooo0?ooo`0;0?ooo`@000004P3o
ool6000000T0oooo0`0000030?ooo`030000003oool0oooo00@0oooo1000000A0?ooo`H000004P3o
ool200000080oooo0P0000030?ooo`800000203oool2000000L0oooo0P0000040?ooo`H000000`3o
ool4000000<0oooo0P0000060?ooo`@000000`3oool6000000<0oooo1@0000040?ooo`800000A@3o
ool200000100oooo1P0000040?ooo`8000002P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo0P0000060?ooo`@000000`3oool600000080oooo1P0000050?ooo`800000103o
ool4000000@0oooo1@0000020?ooo`P00000A`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<]0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool02`3oool300000280oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`040?ooo`<00000:@3oool2000000030?ooo`000000000000@0oooo0P00
00040?ooo`8000000P3oool2000000L0oooo0P00000D0?ooo`8000000P3oool200000180oooo0P00
00070?ooo`8000003`3oool00`000000oooo0?ooo`0c0?ooo`8000006P3oool2000000X0oooo0P00
00050?ooo`8000001P3oool200000080oooo0P00000L0?ooo`8000003@3oool2000005<0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c<`3oool00`000000oooo0?ooo`0<0?ooo`800000:03oool00`000000oooo0?oo
o`050?ooo`800000:03oool5000000D0oooo0P0000050?ooo`@000001`3oool3000001D0oooo1@00
00040?ooo`8000002`3oool3000000L0oooo0P00000?0?ooo`030000003oool0oooo03<0oooo0P00
000J0?ooo`8000002`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo1@00
00040?ooo`800000503oool4000000H0oooo0P0000060?ooo`<00000D@3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<c0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0>@3oool2000004P0oooo0P00
000>0?ooo`8000003P3oool6000000P0oooo00<000000?ooo`3oool01@3oool6000000/0oooo0P00
000J0?ooo`800000W`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`030000003oool0oooo03H0oooo00<0
00000?ooo`3oool0>03oool4000004H0oooo1000000<0?ooo`800000403oool2000000X0oooo00<0
00000?ooo`3oool01P3oool4000000X0oooo1000000H0?ooo`@00000W`3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<d0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0T@3oool010000000oooo0?oo
o`0000060?ooo`D00000103oool2000000P0oooo1@0000070?ooo`800000bP3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<d0?ooobX000003`3ooolR00000780oooo00@000000?ooo`3oool000003`3oool2000000X0
oooo00<000000?ooo`3oool01`3oool200000<X0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co@3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo00d0oooo0P00000:0?ooo`030000003oool0oooo
00H0oooo100000390?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<oh0oooo0`0000030?ooo`030000003oool0oooo
00/0oooo1000000B0?ooo`H00000b03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool02`3oool300000>00oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oool60?oo
o`030000003oool0oooo00`0oooo0P00003P0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo1P3oool00`00
0000oooo0?ooo`3^0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo1`3oool00`000000oooo0?ooo`3]0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooo1`3oool00`000000oooo0?ooo`3]0?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooo1`3ooolZ00000<H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooomP3oool20000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0000o`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00@0003o0?oo
o`3oool0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooooc0?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`H0003o1@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ckP3o
ool00`000000oooo0?ooo`3o0?ooo``0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<nh0oooo00<000000?ooo`3oool01@3oool500000?l0oooo0P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ck@3o
ool2000000L0oooo00D000000?ooo`3oool0oooo0000003`0?ooo`D0003o0P3oool50000o`D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<nd0oooo
00<000000?ooo`0000001`3oool00`000000oooo0?ooo`3e0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<ck03oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo0?@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?Z0?ooo`030000003oool000000080
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3c0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cj`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo0000003d0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cl03oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000m03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<m@0oooo0P00000J0?ooo`030000003oool0
oooo00@0oooo0`00000I0?ooo`800000fP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<m@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0
oooo0=P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?D0?ooo`030000003oool0
oooo01X0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`3H0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<ce03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0f03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<m@0oooo00<000000?ooo`3oool06P3oool<000001L0oooo00<000000?ooo`3oool0f03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aH0oooo0P000?l60?ooo`80003o4@3oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0?@3oool0
0`000000oooo0?ooo`3H0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5P3oool0
0`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00l0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0f03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`T0oooo0P000?l40?ooo`030000o`3oool0
003o0080oooo00<0003o0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o0100oooo0P00
000>0?ooo`D000003P3oool2000000<0oooo0P00000:0?ooo`8000001`3oool5000000d0oooo0P00
00030?ooo`8000004@3oool5000000@0oooo0`0000001@3oool00000000000000000oooo00@00000
103oool3000000<0oooo100000030?ooo`D0000000@0oooo00000000000000000P3oool500000004
0?ooo`0000000000000000<0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3H0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool010000?l0oooo0?ooo`000?l2
0?ooo`060000o`3oool0003o0000o`3oool0003o0P3oool00`000?l0oooo0?ooo`020?ooo`060000
o`3oool0oooo0?ooo`000?l0oooo10000?l;0?ooo`030000003oool0000000l0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002`3oool0
0`000000oooo000000080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?oo
o`3oool0000000D0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool0
0`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3H0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1`3oool00`000?l0oooo0?ooo`020?ooo`030000
o`3oool0003o0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0?ooo`020?ooo`050000
o`3oool0oooo0?ooo`000?l03`3oool010000000oooo0?ooo`00000?0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`040000003oool0oooo
000000P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
000000/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00`3ooold000000H0
oooo00<000000?ooo`3oool0f03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0
oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o0080
oooo00<0003o0?ooo`3oool00P3oool01P000?l0oooo0?ooo`3oool0003o0?ooo`@0003o203oool0
0`000000oooo000000020?ooo`030000003oool0oooo00@0oooo1@0000040?ooo`030000003oool0
oooo00D0oooo1@0000070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo1@0000060?ooo`030000003oool0
oooo00P0oooo1@0000070?ooo`030000003oool0oooo00D0oooo1@0000030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01P3oool3000000@0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo03d0oooo00<000000?ooo`3oool0f03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`L0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020?ooo`060000
o`3oool0003o0000o`3oool0003o103oool01@000?l0oooo0?ooo`3oool0003o00h0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0000000:0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`0000002`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool3000000H0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool00P00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?oo
o`3H0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool010000?l0oooo0?oo
o`000?l70?ooo`040000o`3oool0oooo0000o`<0oooo0P000?l30?ooo`030000o`3oool0oooo0140
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0
oooo0`000000103oool0000000000000000=0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`030?ooo`<0000000@0oooo00000000000000002@3oool0
0`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0000
00030?ooo`030000003oool00000008000000`3oool3000000<0oooo00<000000?ooo`3oool0103o
ool3000000<0oooo00<000000?ooo`0000000P0000030?ooo`040000003oool00000000000D0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3H0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c2@3oool20000o`/0oooo0P000?l30?ooo`030000o`3oool0oooo0080003o
4`3oool00`000000oooo0?ooo`0:0?ooo`<00000903oool00`000000oooo0?ooo`030?ooo`<00000
9`3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0403oool01@000000
oooo0?ooo`3oool000000100oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo0=P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo02H0oooo0`0000060?ooo`<000004`3oool4000000@0oooo00<000000?oo
o`3oool0203oool2000000P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo0=P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?oo
o`030000003oool0oooo0340oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool0f03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<c@0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`1Y0?oo
o`030000003oool0oooo00T0oooo0P00000>0?ooo`D000003P3oool2000000<0oooo0P00000:0?oo
o`030000003oool0oooo0=P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?oo
obL000003@3ooolO000004d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0000000?0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0
000000/0oooo00<000000?ooo`3oool0f03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<m@0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`00000?0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000<0?ooo`030000003o
ool0oooo0=P0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?D0?ooo`8000001`3o
ool00`000000oooo000000020?ooo`030000003oool0oooo00@0oooo1@0000040?ooo`030000003o
ool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00X0oooo0P00003J0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cgP3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool000000>L0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?S0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`<0000000@0
oooo0000000000000000i@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<n<0oooo
00<000000?ooo`3oool02P3oool300000?`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?S0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0nP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<n@0oooo00<000000?ooo`3oool0o`3oool90?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ci03oool00`000000oooo0?ooo`3o0?ooo`T0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?T0?ooobL00000h@3oool40000o`H0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooo_0?ooo`80003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`000?l0
1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooond0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooon`0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooj`3oool60000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<C0?oo
o`80003o1P3oool20000obh0oooo1000000U0?ooo`@000003@3oool400000180oooo1000000O0?oo
o`@000006P3oool400000180oooo1000000O0?ooo`@000006`3oool400000;h0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c4`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo02l0oooo0P00000T0?oo
o`800000403oool2000001<0oooo0P00000S0?ooo`8000001@3oool00`000000oooo0?ooo`0C0?oo
o`8000004`3oool2000002<0oooo0P0000040?ooo`8000005`3oool200000;h0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c303oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o0?oo
o`3oool0oooo0000o`020?ooo`030000o`3oool0oooo00T0oooo1P0000000`3oool0000000000006
000000<0oooo0`0000040?ooo`@000000`3oool5000000<0oooo1@0000030?ooo`H00000103oool3
000000@0oooo100000040?ooo`800000103oool5000000@0oooo1@0000020?ooo`D000001@3oool3
000000@0oooo0P0000040?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H00000103oool2
000000D0oooo0P0000080?ooo`D00000103oool500000080oooo1@0000050?ooo`<00000103oool2
000000@0oooo1P00000?0?ooo`H00000103oool2000000D0oooo0P00000<0?ooo`H00000103oool2
00000;<0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo00<0003o0?ooo`000?l00P3oool0
0`000?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000o`P0oooo0P00
00040?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000030?ooo`00000000000080oooo0P0000040?ooo`800000103oool200000080oooo0P00
00040?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000030?ooo`800000103o
ool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80000000<0
oooo0000000000000`3oool2000000D0oooo100000080?ooo`030000003oool0oooo00L0oooo0P00
00060?ooo`8000001P3oool00`000000oooo0?ooo`060?ooo`8000000P3oool200000080oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000000`3oool00000000000030?ooo`8000001@3o
ool400000180oooo0P0000060?ooo`800000503oool4000000D0oooo0P00002g0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool00`000?l0oooo0000o`020?ooo`030000o`3o
ool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`0@0?ooo`800000103oool200000080oooo
0P0000030?ooo`8000001@3oool2000000D0oooo0P0000020?ooo`800000103oool2000000@0oooo
0P0000020?ooo`800000103oool2000000D0oooo0P0000070?ooo`800000203oool200000080oooo
0P0000020?ooo`8000000`3oool2000000H0oooo0P0000060?ooo`8000001P3oool2000000L0oooo
1@0000070?ooo`8000001P3oool2000000H0oooo0P00000;0?ooo`8000000P3oool200000080oooo
0P0000030?ooo`8000001P3oool2000000H0oooo0P0000060?ooo`8000001`3oool5000000L0oooo
0P0000060?ooo`8000005@3oool2000000H0oooo0P00002g0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c303oool020000?l0oooo0000o`000?l0oooo0000o`3oool0003o103oool0
1@000?l0oooo0?ooo`3oool0003o00@0oooo10000?l80?ooo`800000103oool200000080oooo0P00
00030?ooo`8000001@3oool6000000030?ooo`00000000000080oooo0P0000040?ooo`8000001@3o
ool5000000@0oooo0P0000050?ooo`H000000`3oool2000000P0oooo0P0000020?ooo`8000000P3o
ool2000000<0oooo0P0000060?ooo`8000001P3oool2000000H0oooo0P0000090?ooo`030000003o
ool0oooo00L0oooo0P0000060?ooo`8000001`3oool00`000000oooo0?ooo`090?ooo`8000000P3o
ool200000080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P0000060?ooo`8000004`3o
ool2000000H0oooo0P00000E0?ooo`8000001P3oool200000;L0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<<0?ooo`050000o`3oool0003o0?ooo`000?l00P3oool00`000?l0oooo
0?ooo`020?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool00`000?l0oooo0?ooo`0;0?ooo`80
0000103oool3000000030?ooo`000000000000<0oooo0P0000050?ooo`8000000P3oool200000003
0?ooo`00000000000080oooo0P0000040?ooo`<000000`3oool200000080oooo0P0000040?ooo`80
00001@3oool200000080oooo0P0000030?ooo`8000001@3oool4000000<0oooo0P0000020?ooo`80
00000`3oool3000000D0oooo0P0000060?ooo`8000001@3oool4000000P0oooo00<000000?ooo`3o
ool01`3oool2000000H0oooo0P0000070?ooo`8000001`3oool4000000<0oooo0P0000020?ooo`80
00000`3oool3000000D0oooo0P0000060?ooo`8000001@3oool400000180oooo0P0000060?ooo`80
0000503oool4000000D0oooo0P00002g0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c303oool00`000?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0?ooo`80003o0`3oool00`00
0?l0oooo0?ooo`0>0?ooo`8000000`3oool6000000<0oooo1@0000040?ooo`@000000`3oool60000
0080oooo1P0000020?ooo`@00000103oool5000000@0oooo100000040?ooo`800000103oool20000
00L0oooo1P0000000`3oool000000000000400000080oooo1@0000040?ooo`800000103oool60000
00l0oooo100000060?ooo`800000203oool00`000000oooo0?ooo`040?ooo`8000001`3oool60000
00030?ooo`000000000000@000000P3oool5000000@0oooo0P0000040?ooo`H000003`3oool40000
00H0oooo0P00000C0?ooo`H00000103oool200000;L0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<<0?ooo`030000o`3oool0oooo00@0oooo0P000?l30?ooo`030000o`3oool0oooo
0080003o403oool2000000d0oooo0P00000V0?ooo`8000003P3oool2000000@0oooo0P0000020?oo
o`8000004`3oool2000000H0oooo0P00000J0?ooo`<000001P3oool2000000P0oooo0P0000050?oo
o`8000000P3oool2000001<0oooo0P0000060?ooo`8000006P3oool3000000H0oooo0P00000M0?oo
o`800000]`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b/0oooo1P00000;0?oo
o`8000009P3oool2000000h0oooo100000030?ooo`D000004`3oool2000000H0oooo1000000I0?oo
o`800000103oool4000000T0oooo00<000000?ooo`3oool0103oool5000001<0oooo0P0000060?oo
o`@000006@3oool2000000@0oooo1000000K0?ooo`@00000]`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool20000
o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooo^0?ooo`030000o`3oool0003o00H0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooo]0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/
0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo1P00
0?l20?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`00003m000000040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGU
o`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 161},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell[TextData[{
  "After you have edited the output, you can send it back as further input to \
the ",
  StyleBox["Mathematica", "TI"],
  " kernel. "
}], "MathCaption",
  CellTags->{"S1.3.4", "4.12"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000a2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool00000o`00000900000040oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooooP3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<c0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0o`3ooon30?ooo`D0003o
0P3oool50000o`D0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<`3o
ool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0?l0ooooQ`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c<P3oool2000000l0oooo1@00000=0?ooo`8000000`3oool2000000X0oooo0P000007
0?ooo`D000003P3oool2000000<0oooo0P00003o0?ooofP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<c80oooo00<000000?ooo`000000403oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`030000003oool0000000P0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000o`3o
oomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`040000003oool0oooo00000100oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`000000o`3ooomZ0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<_0?ooo`030000003o
ool000000080oooo00<000000?ooo`3oool0103oool5000000D0oooo00<000000?ooo`3oool01@3o
ool5000000H0oooo00<000000?ooo`3oool0203oool00`000000oooo000000020?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool0o`3o
oomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool03@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`0000002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool000000?l0ooooJP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c=@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool00`3oool3000000040?ooo`0000000000000000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000
103oool0000000000000003o0?ooofP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo00<00000
0?ooo`3oool02`3oool3000002<0oooo00<000000?ooo`3oool00`3oool300000?l0ooooO`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c=@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooogd0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`3o0?oooh@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo00<000000?ooo`3oool0<@3oool00`000000oooo
0?ooo`3o0?oooh@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo9`00000=0?oooal00000o`3o
oomX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`80003o1P3oool20000ool0oooodP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c5@3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo
0?l0ooood03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool20000o`@0oooo00<0003o0?ooo`00
0?l00P3oool00`000?l0oooo0000o`020?ooo`@0003o0P3oool00`000?l0oooo0?ooo`3o0?ooom00
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo00@0003o0?ooo`3oool0003o0P3oool01P000?l0
oooo0000o`000?l0oooo0000o`80oooo00@0003o0?ooo`3oool0003o1@3oool00`000?l0oooo0000
o`030000ool0ooooc@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1P3oool00`000?l0oooo0?ooo`02
0?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l00P3oool01@000?l0oooo0?ooo`3o
ool0003o00@0oooo00<0003o0?ooo`3oool0303ooomQ00000?l0ooooH`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c1P3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080oooo00<0003o
0?ooo`000?l00P3oool00`000?l0oooo0?ooo`020?ooo`060000o`3oool0oooo0?ooo`000?l0oooo
10000?oo0?ooold0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`H0oooo00<0003o0?ooo`3oool00P3o
ool00`000?l0oooo0000o`020?ooo`060000o`3oool0003o0000o`3oool0003o1@3oool010000?l0
oooo0?ooo`000?oo0?ooom80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo00@0003o0?ooo`3o
ool0003o1`3oool010000?l0oooo0?ooo`000?l20?ooo`040000o`3oool0oooo0000o`80oooo00<0
003o0?ooo`3oool0o`3oooo@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`80003o2`3oool2
0000o`80oooo0P000?l20?ooo`80003oo`3ooooB0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
oo40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooa0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=G0?ooo`8000000`3oool200000?l0ooooT`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<cF03oool01@000000oooo0?ooo`3oool000000?l0ooooU03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<cF@3oool00`000000oooo0000003o0?oooiD0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<eX0oooo00<000000?ooo`3oool0o`3ooonD0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=I0?ooo`030000003oool000000080oooo1000003o0?ooohl0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<eL0oooo0`0000001P3oool00000000000000000oooo00000?l0ooooT@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cH03oool00`000000oooo0?ooo`3o0?oooh/0oooo10000?l60?ooo`03
0000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
H@3oool00`000000oooo0?ooo`3o0?ooohd0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<eh0oooo00@0
00000?ooo`3oool00000o`3ooon>0?ooo`80003o1P3oool00`000?l0oooo0?ooo`030?ooo`<0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<el0oooo0P00003o0?ooohh0oooo00<0
003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooookP3oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3o
ool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo]
0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool60000o`H0oooo00<0003o
0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooP0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3o
ool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooP0oooo00<0003o
0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooP0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3o
ool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooP0oooo00<0003o
0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
oa40oooo00<000000?ooo`3oool0f@3oool50000o`H0oooo00<0003o0?ooo`3oool00`3oool309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooa40oooo00<000000?ooo`3o
ool01@3oool600000=80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo403oool2000000L0oooo
0P0000020?ooo`800000dP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oool@0?ooo`800000203o
ool200000=D0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo3`3oool010000000oooo0?ooo`00
00080?ooo`800000e03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oool?0?ooo`040000003oool0
oooo000000T0oooo0P00003C0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooo`/0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`800000dP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oool<0?ooo`<000000`3oool00`000000oooo0?ooo`040?ooo`8000000P3oool2
00000=80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo3@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00@0oooo1000003C0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooa<0
oooo00<000000?ooo`3oool0f`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooolC0?ooo`030000
003oool0oooo0=/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<jL0oooo100000160?ooo`@000007P3o
ool00`000000oooo0?ooo`0P0?ooo`@00000603oool4000009X0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<jL0oooo0P0000180?ooo`800000803oool00`000000oooo0?ooo`0R0?ooo`8000006P3oool2
000009X0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<jL0oooo0P0000180?ooo`800000803oool=0000
01P0oooo0P00000J0?ooo`800000VP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c4P3oool20000o`H0
oooo0P000?lD0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0>`3oool2000004P0
oooo0P0000150?ooo`8000006P3oool200000300oooo1000000M0?ooo`@00000A@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c4P3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo0180oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0k0?ooo`800000B03oool2000004D0oooo
0P0000040?ooo`800000503oool2000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0P0?ooo`8000007`3oool2000004H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0oooo00<0
003o0?ooo`000?l00P3oool00`000?l0oooo0000o`020?ooo`@0003o0P3oool010000?l0oooo0?oo
o`000?l@0?ooo`8000003P3oool6000000P0oooo00<000000?ooo`3oool01@3oool6000000d0oooo
0P0000070?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H000002P3oool00`000000oooo
0?ooo`040?ooo`D000001@3oool2000000@0oooo1P0000040?ooo`P0000000<0oooo000000000000
0`0000040?ooo`@000000`3oool5000000<0oooo1P0000000`3oool000000000000>00000080oooo
0P0000150?ooo`8000001@3oool2000000T0oooo1P0000040?ooo`8000001`3oool2000000D0oooo
0P0000090?ooo`D000000`3oool6000000030?ooo`000000000000H0000000<0oooo000000000000
0`0000030?ooo`H000000P3oool600000080oooo1@0000050?ooo`800000A@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c2`3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o0080oooo00<0
003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`020?ooo`@0003o2`3oool200000100oooo0P00
000:0?ooo`030000003oool0oooo00H0oooo1000000>0?ooo`8000002@3oool2000000T0oooo00<0
00000?ooo`3oool01P3oool4000000/0oooo00<000000?ooo`3oool01@3oool2000000030?ooo`00
0000000000@0oooo0P0000040?ooo`8000000P3oool2000000D0oooo0P0000020?ooo`8000000`3o
ool2000000D0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000040?ooo`800000103o
ool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000150?ooo`8000004@3o
ool4000000D0oooo0P0000080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool200000080oooo0P0000040?ooo`800000103oool600000080oooo0P0000020?ooo`800000103o
ool2000000H0oooo0P0000050?ooo`8000001`3oool2000004D0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<`/0oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000o`030?ooo`030000o`3oool0
oooo0080oooo00<0003o0?ooo`3oool0403oool010000000oooo0?ooo`0000060?ooo`D00000103o
ool2000000P0oooo1@0000070?ooo`8000003P3oool010000000oooo0?ooo`0000080?ooo`800000
1`3oool5000000L0oooo0P00000:0?ooo`D000001@3oool200000080oooo0P0000030?ooo`800000
1@3oool2000000P0oooo1P0000030?ooo`8000001@3oool2000000X0oooo0P0000040?ooo`800000
103oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000060?ooocT00000
1P3oool200000180oooo0P0000060?ooo`800000203oool2000000D0oooo0P00000<0?ooo`800000
103oool2000000@0oooo1P0000020?ooo`8000000P3oool2000000@0oooo0P0000060?ooo`800000
1@3oool2000000H0oooo100000140?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`080000o`3o
ool0003o0000o`3oool0003o0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`000?l0103oool4
0000o`X0oooo00@000000?ooo`3oool000003`3oool2000000X0oooo00<000000?ooo`3oool01`3o
ool2000000h0oooo00@000000?ooo`3oool00000203oool2000000T0oooo00<000000?ooo`3oool0
1`3oool2000000`0oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000030?ooo`800000
1P3oool2000000P0oooo100000040?ooo`8000001@3oool2000000X0oooo0P0000040?ooo`800000
103oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000150?ooo`800000
4P3oool2000000H0oooo0P0000090?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
2P3oool2000000@0oooo0P0000040?ooo`H000000P3oool200000080oooo0P0000040?ooo`800000
1P3oool2000000D0oooo0P0000060?ooo`@00000A03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2`3o
ool01@000?l0oooo0000o`3oool0003o0080oooo00<0003o0?ooo`3oool00`3oool010000?l0oooo
0?ooo`000?l20?ooo`030000o`3oool0oooo00T0oooo00@000000?ooo`3oool000000`3oool00`00
0000oooo0?ooo`0=0?ooo`8000002P3oool00`000000oooo0?ooo`060?ooo`@000002@3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo00H0oooo0P0000090?ooo`030000003oool0
oooo00H0oooo1000000;0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`8000000`3oool2
000000L0oooo0P0000070?ooo`@00000103oool3000000@0oooo0P0000020?ooo`8000000`3oool4
000000D0oooo0P0000040?ooo`<0000000<0oooo0000000000000P3oool200000080oooo0P000003
0?ooo`800000A@3oool200000140oooo100000050?ooo`8000002@3oool2000000D0oooo0P000008
0?ooo`@000001@3oool2000000@0oooo1P0000020?ooo`8000000P3oool2000000@0oooo0P000006
0?ooo`8000001@3oool2000000D0oooo0P0000020?ooo`800000@`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c2`3oool00`000?l0oooo0?ooo`040?ooo`040000o`3oool0oooo0000o`80oooo00@0003o
0?ooo`3oool0003o3`3oool3000000<0oooo00<000000?ooo`3oool02`3oool400000180oooo1P00
00090?ooo`<000000`3oool00`000000oooo0?ooo`040?ooo`@000004@3oool600000180oooo0P00
00020?ooo`8000000`3oool2000000P0oooo0P0000070?ooo`800000103oool6000000<0oooo1000
00030?ooo`8000001P3oool4000000<0oooo1P0000030?ooo`D00000103oool2000004D0oooo0P00
000@0?ooo`H00000103oool2000000X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`8000001P3oool4000000<0oooo1P0000020?ooo`H000001@3oool2000000@0oooo1000
00040?ooo`D000000P3oool800000480oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0oooo00<0003o
0?ooo`3oool0103oool20000o`80oooo0P000?l20?ooo`80003o403oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00/0oooo0`00000R0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0103oool3000002T0oooo0P0000000`3oool00000000000040?ooo`800000103oool2
00000080oooo0P0000070?ooo`800000503oool200000080oooo0P00000B0?ooo`8000001`3oool2
000000l0oooo00<000000?ooo`3oool0<`3oool2000001X0oooo0P00000:0?ooo`8000001@3oool2
000000H0oooo0P0000020?ooo`800000703oool2000000d0oooo0P00001>0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<b0?ooo`030000003oool0oooo00`0oooo0P00000X0?ooo`030000003oool0oooo
00D0oooo0P00000X0?ooo`D000001@3oool2000000D0oooo100000070?ooo`<000005@3oool50000
00@0oooo0P00000;0?ooo`<000001`3oool2000000l0oooo00<000000?ooo`3oool0<`3oool20000
01X0oooo0P00000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool50000
00@0oooo0P00000D0?ooo`@000001P3oool2000000H0oooo0`00001<0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<b0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0>@3oool2000004P0
oooo0P00000>0?ooo`8000003P3oool6000000P0oooo00<000000?ooo`3oool01@3oool6000000/0
oooo0P00000J0?ooo`800000VP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<`3oool00`000000oooo
0?ooo`0f0?ooo`030000003oool0oooo03P0oooo100000160?ooo`@00000303oool200000100oooo
0P00000:0?ooo`030000003oool0oooo00H0oooo1000000:0?ooo`@00000603oool4000009X0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<c<0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`2A0?ooo`040000003oool0oooo000000H0oooo1@0000040?ooo`800000203oool5000000L0oooo
0P0000350?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooobX000003`3ooolR00000780oooo00@0
00000?ooo`3oool000003`3oool2000000X0oooo00<000000?ooo`3oool01`3oool200000<D0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<o`0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`0=0?ooo`8000002P3oool00`000000oooo0?ooo`060?ooo`@00000a03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co@3oool3000000<0oooo00<000000?ooo`3oool02`3oool400000180oooo1P00
00330?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?n0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool02`3oool300000=/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo1@3oool00`00
0000oooo0?ooo`0<0?ooo`800000f`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oool50?ooo`03
0000003oool0oooo0>T0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo1P3oool00`000000oooo
0?ooo`3X0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooo`H0oooo00<000000?ooo`3oool0j03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oool60?ooobX00000`03oool20000o`H0oooo00<0003o
0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooookP3oool010000?l0oooo0?ooo`000?l60?oo
o`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooo]0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?oo
o`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool60000o`80
oooo1@000?l50?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
oP3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooh0oooo0`2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooon0?ooo`<0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooooP3oool309VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooh0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooon0?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooooP3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooh0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooon0?oo
o`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooooP3oool309VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooh0oooo0`2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooon0?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooooP3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooooh0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<ck@3oool00`000000oooo0?ooo`3l0?ooo`D0003o0P3oool50000o`D0oooo0`2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ck@3oool00`000000oooo0?ooo`050?ooo`D00000
mP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<ck03oool2000000L0oooo00D000000?ooo`3oool0oooo
0000003f0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?/0?ooo`030000003oool0000000L0oooo00<0
00000?ooo`3oool0m`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cj`3oool010000000oooo0?ooo`00
00080?ooo`030000003oool0oooo0?H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<nT0oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?D0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<nX0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`000000mP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ck`3oool00`00
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000mP3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<cd`3oool2000001X0oooo00<000000?ooo`3oool0103oool3000001T0oooo0P00003L0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?C0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool08@3oool00`000000oooo0?ooo`3J0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?C0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`3J0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?C0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`3J0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3o
ool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?C0?ooo`030000003oool0
oooo01X0oooo3000000G0?ooo`030000003oool0oooo0=X0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<aD0oooo0P000?l60?ooo`80003o4@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
06`0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3J0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<E0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool03`3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0?@3oool00`000000
oooo0?ooo`3J0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`80003o103oool00`000?l0oooo
0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`0@0?ooo`80
00003P3oool5000000h0oooo0P0000030?ooo`8000002P3oool2000000L0oooo1@00000=0?ooo`80
00000`3oool200000140oooo1@0000040?ooo`<0000000D0oooo00000000000000000?ooo`040000
00@0oooo0`0000030?ooo`@000000`3oool5000000040?ooo`000000000000000080oooo1@000000
103oool000000000000000030?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0fP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c1`3oool010000?l0oooo0?ooo`000?l20?ooo`060000o`3o
ool0003o0000o`3oool0003o0P3oool00`000?l0oooo0?ooo`020?ooo`060000o`3oool0oooo0?oo
o`000?l0oooo10000?l;0?ooo`030000003oool0000000l0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0000
00080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool01@000000oooo0?oo
o`3oool0000000X0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000D0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3J0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<60?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo
0000o`020?ooo`030000o`3oool0oooo0080oooo00D0003o0?ooo`3oool0oooo0000o`0?0?ooo`04
0000003oool0oooo000000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000/0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000002`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`030?oooc@000001P3oool00`000000oooo0?ooo`3J0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<60?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l0
0P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00H0003o0?ooo`3oool0
oooo0000o`3oool40000o`P0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`040?oo
o`D00000103oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000oooo0?ooo`080?oo
o`030000003oool000000080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`D000001P3oool00`000000oooo0?ooo`080?ooo`D000001`3oool00`000000oooo0?ooo`050?oo
o`D000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo0`0000040?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0=X0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`H0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`02
0?ooo`060000o`3oool0003o0000o`3oool0003o103oool01@000?l0oooo0?ooo`3oool0003o00h0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`0000002`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`0000000P3oool3000000H0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?oo
o`3oool00P0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0?@3oool00`00
0000oooo0?ooo`3J0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?ooo`040000o`3oool0oooo0000
o`L0oooo00@0003o0?ooo`3oool0003o0`3oool20000o`<0oooo00<0003o0?ooo`3oool04@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool3
000000040?ooo`0000000000000000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00<0oooo0`000000103oool000000000000000090?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000P0000030?ooo`<000000`3oool00`000000oooo0?ooo`040?ooo`<0
00000`3oool00`000000oooo00000002000000<0oooo00@000000?ooo`00000000001@3oool00`00
0000oooo0?ooo`0m0?ooo`030000003oool0oooo0=X0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`P0
oooo0P000?l;0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020000oa<0oooo00<000000?ooo`3o
ool02P3oool3000002@0oooo00<000000?ooo`3oool00`3oool3000002L0oooo00D000000?ooo`3o
ool0oooo000000070?ooo`030000003oool0oooo0100oooo00D000000?ooo`3oool0oooo0000000@
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`3J
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<b0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02H0oooo0`0000060?oo
o`<000004`3oool4000000@0oooo00<000000?ooo`3oool0203oool2000000P0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0=X0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<c<0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`1Y0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`3J0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<c0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0
J@3oool00`000000oooo0?ooo`090?ooo`8000003P3oool5000000h0oooo0P0000030?ooo`800000
2P3oool00`000000oooo0?ooo`3J0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooobL000003@3o
oolO000004d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0000000?0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000/0oooo
00<000000?ooo`3oool0fP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cd`3oool00`000000oooo0?oo
o`080?ooo`040000003oool0oooo000000l0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`060?ooo`030000003oool0000000`0oooo00<000000?ooo`3oool0fP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cd`3oool2000000L0oooo00<000000?ooo`0000000P3oool00`000000oooo0?oo
o`040?ooo`D00000103oool00`000000oooo0?ooo`050?ooo`D000001`3oool00`000000oooo0?oo
o`0:0?ooo`800000g03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo0`2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cg@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool000000>T0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<n80oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000103o
ool0000000000000003W0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool3
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?R0?ooo`030000003oool0oooo
00X0oooo0`00003n0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?R0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0o03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ch`3oool00`000000oooo
0?ooo`3o0?ooo`P0oooo10000?l60?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<ch`3oool00`000000oooo0?ooo`3o0?ooo`/0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<n<0oooo9`00003U0?ooo`80003o1P3oool00`000?l0oooo0?ooo`03
0?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool00`00
0?l0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo^0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o0?oo
o`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooond0
oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/0?ooo`H0003o1P3oool00`000?l0
oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
n03oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?oo
o`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooon03oool00`000?l0
oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
n03oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?oo
o`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooon03oool00`000?l0
oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a80oooo
0P000?l60?ooo`80003o;P3oool4000002D0oooo1000000=0?ooo`@000004P3oool4000001l0oooo
1000000J0?ooo`@000004P3oool4000001l0oooo1000000K0?ooo`@00000]@3oool50000o`H0oooo
00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<B0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0;`3oool2000002@0oooo0P00
000@0?ooo`8000004`3oool2000002<0oooo0P0000050?ooo`030000003oool0oooo01<0oooo0P00
000C0?ooo`8000008`3oool2000000@0oooo0P00000G0?ooo`800000^@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c2`3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0003o
0?ooo`3oool0oooo0000o`020?ooo`030000o`3oool0oooo00T0oooo1P0000000`3oool000000000
0006000000<0oooo0`0000040?ooo`@000000`3oool5000000<0oooo1@0000030?ooo`H00000103o
ool3000000@0oooo100000040?ooo`800000103oool5000000@0oooo1@0000020?ooo`D000001@3o
ool3000000@0oooo0P0000040?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H00000103o
ool2000000D0oooo0P0000080?ooo`D00000103oool500000080oooo1@0000050?ooo`<00000103o
ool2000000@0oooo1P00000?0?ooo`H00000103oool2000000D0oooo0P00000<0?ooo`H00000103o
ool200000;T0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0oooo00<0003o0?ooo`000?l00P3oool0
0`000?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000o`P0oooo0P00
00040?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000030?ooo`00000000000080oooo0P0000040?ooo`800000103oool200000080oooo0P00
00040?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000030?ooo`800000103o
ool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`80000000<0
oooo0000000000000`3oool2000000D0oooo100000080?ooo`030000003oool0oooo00L0oooo0P00
00060?ooo`8000001P3oool00`000000oooo0?ooo`060?ooo`8000000P3oool200000080oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000000`3oool00000000000030?ooo`8000001@3o
ool400000180oooo0P0000060?ooo`800000503oool4000000D0oooo0P00002i0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<;0?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l0103oool0
1@000?l0oooo0?ooo`3oool0003o0100oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P00
00050?ooo`8000001@3oool200000080oooo0P0000040?ooo`800000103oool200000080oooo0P00
00040?ooo`8000001@3oool2000000L0oooo0P0000080?ooo`8000000P3oool200000080oooo0P00
00030?ooo`8000001P3oool2000000H0oooo0P0000060?ooo`8000001`3oool5000000L0oooo0P00
00060?ooo`8000001P3oool2000000/0oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P00
00060?ooo`8000001P3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0oooo0P00
000E0?ooo`8000001P3oool200000;T0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`/0oooo00P0003o
0?ooo`000?l0003o0?ooo`000?l0oooo0000o`@0oooo00D0003o0?ooo`3oool0oooo0000o`040?oo
o`@0003o203oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000D0oooo1P0000000`3o
ool00000000000020?ooo`800000103oool2000000D0oooo1@0000040?ooo`8000001@3oool60000
00<0oooo0P0000080?ooo`8000000P3oool200000080oooo0P0000030?ooo`8000001P3oool20000
00H0oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool20000
00L0oooo00<000000?ooo`3oool02@3oool200000080oooo0P0000020?ooo`8000000`3oool20000
00H0oooo0P0000060?ooo`8000001P3oool2000001<0oooo0P0000060?ooo`8000005@3oool20000
00H0oooo0P00002i0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`050000o`3oool0003o0?oo
o`000?l00P3oool00`000?l0oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool0
0`000?l0oooo0?ooo`0;0?ooo`800000103oool3000000030?ooo`000000000000<0oooo0P000005
0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`<000000`3oool2
00000080oooo0P0000040?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001@3oool4
000000<0oooo0P0000020?ooo`8000000`3oool3000000D0oooo0P0000060?ooo`8000001@3oool4
000000P0oooo00<000000?ooo`3oool01`3oool2000000H0oooo0P0000070?ooo`8000001`3oool4
000000<0oooo0P0000020?ooo`8000000`3oool3000000D0oooo0P0000060?ooo`8000001@3oool4
00000180oooo0P0000060?ooo`800000503oool4000000D0oooo0P00002i0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<;0?ooo`030000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0P000?l3
0?ooo`030000o`3oool0oooo00h0oooo0P0000030?ooo`H000000`3oool5000000@0oooo10000003
0?ooo`H000000P3oool600000080oooo100000040?ooo`D00000103oool4000000@0oooo0P000004
0?ooo`8000001`3oool6000000030?ooo`000000000000@000000P3oool5000000@0oooo0P000004
0?ooo`H000003`3oool4000000H0oooo0P0000080?ooo`030000003oool0oooo00@0oooo0P000007
0?ooo`H0000000<0oooo000000000000100000020?ooo`D00000103oool2000000@0oooo1P00000?
0?ooo`@000001P3oool2000001<0oooo1P0000040?ooo`800000^@3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c2`3oool00`000?l0oooo0?ooo`040?ooo`80003o0`3oool00`000?l0oooo0?ooo`020000
oa00oooo0P00000=0?ooo`8000009P3oool2000000h0oooo0P0000040?ooo`8000000P3oool20000
01<0oooo0P0000060?ooo`8000006P3oool3000000H0oooo0P0000080?ooo`8000001@3oool20000
0080oooo0P00000C0?ooo`8000001P3oool2000001X0oooo0`0000060?ooo`8000007@3oool20000
0;T0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bX0oooo1P00000;0?ooo`8000009P3oool2000000h0
oooo100000030?ooo`D000004`3oool2000000H0oooo1000000I0?ooo`800000103oool4000000T0
oooo00<000000?ooo`3oool0103oool5000001<0oooo0P0000060?ooo`@000006@3oool2000000@0
oooo1000000K0?ooo`@00000^@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`80003o
1P3oool00`000?l0oooo0?ooo`030?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooook`3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo0`2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo^0?ooo`040000o`3oool0
oooo0000o`H0oooo00<0003o0?ooo`3oool00`3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooond0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3o
ool0oooo00<0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/
0?ooo`H0003o0P3oool50000o`D0oooo0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooon0?ooo`<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooooP3oool309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooh0oooo
0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooon0?ooo`<0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`00003m
000000040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o
03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3o
ool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 196},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell[TextData[{
  "When you do computations in a ",
  StyleBox["Mathematica", "TI"],
  " notebook, each line of input is typically labeled with ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MR"],
  ", while each line of output is labeled with the corresponding ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]=", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.3.4", "4.13"}],

Cell["\<\
There is no reason, however, that successive lines of input and \
output should necessarily appear one after the other in your notebook. Often, \
for example, you will want to go back to an earlier part of your notebook, \
and re\[Hyphen]evaluate some input you gave before.   \
\>", "Text",
  CellTags->{"S1.3.4", "4.14"}],

Cell[TextData[{
  "It is important to realize that wherever a particular expression appears \
in your notebook, it is the line number given in ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]:=", "MR"],
  " or ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]=", "MR"],
  " which determines when the expression was processed by the ",
  StyleBox["Mathematica", "TI"],
  " kernel. Thus, for example, the fact that one expression may appear \
earlier than another in your notebook does not mean that it will have been \
evaluated first by the kernel. This will only be the case if it has a lower \
line number.  "
}], "Text",
  CellTags->{"S1.3.4", "4.15"}],

Cell["\<\
Each line of input and output is given a label when it is evaluated \
by the kernel. It is these labels, not the position of the expression in the \
notebook, that indicate the ordering of evaluation by the kernel. \
\>", \
"MathCaption",
  CellTags->{"S1.3.4", "4.16"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:00019B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool000000000003o00000?l00000200000010?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
j`3oool50000o`80oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ad0oooo0P000?l30?ooo`80003oo`3oooo;0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ad0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?ooolT0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c4P3oool30000o`<0oooo0P000?l20?ooo`80003o0P3o
ool20000o`030?ooo`000?l0oooo00d0oooo1@0000030?ooo`<00000103oool300000?l0ooooZ`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`0?0000o`3oool0oooo0?ooo`00
0?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o0080oooo0P000?l00`3oool0
003o0000o`020000o`/0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo0000003o0?ooojX0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c4@3oool03@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3oool0
003o0?ooo`000?l0103oool20000oa00oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo0000003o0?ooojX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c4@3oool03@000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo
0000o`3oool0003o0?ooo`000?l00`3oool010000?l0oooo0000o`3oool40000o`/0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
0000003o0?ooojX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4@3oool02P000?l0
oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3oool30000o`@0oooo0P000?l@0?ooo`030000
003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`000000o`3ooonW0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4@3oool01@000?l0oooo0?ooo`3o
ool0003o00D0oooo00D0003o0?ooo`000?l0oooo0000o`020?ooo`80003o403oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0?l0ooooZP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<B0?ooo`<0003o203oool2
0000o`030?ooo`000?l0003o0080003o3P3oool3000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`050000003oool0oooo0?ooo`000000o`3ooonY0?ooo`80003o1P3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c=03oool00`000000oooo0?ooo`030?ooo`<00000103oool300000?l0ooooZ@3oool00`000?l0
oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon`0oooo00@0003o0?ooo`3oool0003o1P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooo[0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3ooooZ0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo1@000?l60?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c6@3oool20000o`<0oooo0P00
0?oo0?oooll0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c6@3oool00`000?l0oooo
0?ooo`030?ooo`030000o`3oool0oooo0?l0ooooc@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<C0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000o`020?ooo`80003o00@0oooo
0000o`3oool0003o3P3oool500000180oooo1P0000030?ooo`@00000103oool400000?l0ooooT`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`090000o`3oool0003o0?ooo`00
0?l0oooo0000o`3oool0003o0080oooo0P000?l30?ooo`@0003o2@3oool200000080oooo0P000006
0?ooo`D00000203oool2000000@0oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o
0?oooi80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool01`000?l0oooo0000
o`3oool0003o0?ooo`000?l0103oool20000oa@0oooo0P00000C0?ooo`800000103oool200000080
oooo0P0000020?ooo`8000000P3oool200000?l0ooooTP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<C0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`030000o`3o
ool0003o00<0oooo10000?l:0?ooo`@000001`3oool5000000P0oooo0P0000040?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`800000o`3ooonB0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<a<0oooo00@0003o0?ooo`000?l0003o0P3oool00`000?l0oooo0?ooo`020?ooo`80
003o00<0oooo0000o`3oool03@3oool200000080oooo0P00000C0?ooo`800000103oool200000080
oooo0P0000020?ooo`8000000P3oool200000?l0ooooTP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<C0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`000?l00P3oool20000
oa40oooo1000000B0?ooo`@00000103oool200000080oooo0P0000020?ooo`8000000P3oool20000
0?l0ooooTP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`030000o`3oool0
oooo00<0oooo0P000?l00`3oool0003o0000o`020000obP0oooo0`0000040?ooo`8000000P3oool2
00000080oooo0P0000020?ooo`800000o`3ooonA0?ooo`80003o1P3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cB@3o
ool2000000D0oooo100000040?ooo`@00000o`3ooonA0?ooo`030000o`3oool0003o00H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0ooook03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
on/0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonX0oooo1P00
0?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3o
ool50000o`80oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ad0
oooo0P000?l30?ooo`80003oo`3oooo;0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ad0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?ooolT0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c4P3oool30000o`<0oooo0P000?l20?ooo`80003o0`3oool0
0`000?l0oooo0000o`0>0?ooo`D000000P3oool500000?l0oooo/@3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<A0?ooo`0=0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o
0?ooo`000?l0oooo0000o`030?ooo`040000o`3oool0003o0?ooo`@0003o2`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`000000o`3ooona0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<a40oooo00d0003o0?ooo`3oool0oooo0000o`3oool0003o0?ooo`000?l0
oooo0000o`3oool0003o00<0oooo00<0003o0?ooo`000?l0403oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0?l0oooo/P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A
0?ooo`0=0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`03
0?ooo`040000o`3oool0003o0?ooo`@0003o2`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0?l0oooo/@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`0:0000
o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`<0003o0`3oool00`000?l0oooo0000
o`0@0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooon]0?ooo`@0003o1P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c4@3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00<0003o0?ooo`00
0?l00P3oool20000o`030?ooo`000?l0oooo00l0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool000000?l0oooo/@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<B
0?ooo`<0003o203oool20000o`80oooo0`000?l>0?ooo`<00000103oool01@000000oooo0?ooo`3o
ool000000?l0oooo/03oool20000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c@0oooo00<000000?ooo`3oool0
0`3oool300000?l0oooo/03oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon`0
oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`050000o`3oool0
oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`H0003o1P3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0
oooo1@000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c6@3oool20000o`<0oooo0P000?oo0?oooll0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c6@3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo0?l0ooooc@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`070000o`3oool0003o0?ooo`00
0?l0oooo0000o`030?ooo`050000o`3oool0003o0?ooo`000?l03P3oool500000180oooo1P000002
0?ooo`H00000o`3ooonJ0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a<0oooo00L0
003o0?ooo`000?l0oooo0000o`3oool0003o00<0oooo00<0003o0?ooo`000?l00`3oool40000o`T0
oooo0P0000020?ooo`8000001P3oool5000000P0oooo0P0000040?ooo`8000000P3oool200000?l0
ooooVP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`070000o`3oool0003o
0?ooo`000?l0oooo0000o`030?ooo`030000o`3oool0003o01@0oooo0P00000C0?ooo`8000001@3o
ool200000?l0ooooW@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`070000
o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`030000o`3oool0003o00<0oooo10000?l:0?oo
o`@000001`3oool5000000P0oooo0P0000060?ooo`800000o`3ooonL0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<a<0oooo00@0003o0?ooo`000?l0003o0P3oool02@000?l0oooo0?oo
o`3oool0003o0?ooo`000?l0oooo0000o`0>0?ooo`8000000P3oool2000001<0oooo0P0000070?oo
o`800000o`3ooonK0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a<0oooo00<0003o
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`020000o`030?ooo`000?l0oooo0100oooo1000000B
0?ooo`@00000203oool200000?l0ooooVP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<C0?ooo`030000o`3oool0oooo00<0oooo0P000?l20?ooo`<0003o:03oool3000000@0oooo0P00
00020?ooo`800000o`3ooonI0?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cB@3oool2000000D0oooo
1000003o0?oooiT0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo/0?ooo`04
0000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool01@000?l0oooo0?ooo`3o
ool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`80oooo1@000?l70?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob0?ooo`D0003o1`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c:03oool300000?l0oooob`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c9`3oool01@000000oooo0?ooo`3o
ool000000?l0oooobP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c9`3oool01@000000oooo0?ooo`3oool000000?l0
oooobP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c303oool00`000000oooo00000002000000<0oooo0P0000030?oo
o`050000003oool0oooo0000003oool01P000000103oool000000000003oool300000080oooo0`00
00050?ooo`<000000P3oool300000080oooo0`0000040?ooo`<000000`3oool00`000000oooo0?oo
o`3o0?ooojL0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo0P0000020?ooo`80000000L0oooo0000003oool0
oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0
oooo0000003oool000001@3oool010000000oooo0?ooo`0000050?ooo`040000003oool0oooo0000
00<0oooo00@000000?ooo`3oool000001@3oool010000000oooo0?ooo`00003o0?oooj`0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<``0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000040?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020000
00D0oooo0P0000050?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000001`3o
ool200000?l0oooo[03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool2000000030?ooo`000000000000800000
00D0oooo0000003oool0oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`02000000L0oooo00@000000?ooo`3oool000000`3oool0
10000000oooo0?ooo`0000050?ooo`800000o`3ooon^0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`<00000
0P3oool01P000000oooo0?ooo`000000oooo00000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`020000
00@0oooo00@000000?ooo`3oool00000o`3ooon/0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`8000001@3o
ool2000000030?ooo`000000000000@0000000H0oooo000000000000oooo0000003oool2000000<0
oooo100000020?ooo`<00000103oool300000080oooo0`0000020?ooo`040000003oool000000000
00@0oooo0`0000020?ooo`030000003oool0oooo0?l0ooooY`3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool000006P3o
ool00`000000oooo0?ooo`3o0?oookd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo00@000000?ooo`3oool0
oooo0P00000T0?ooo`030000003oool0oooo0?l0oooo_@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool30000
00030?ooo`000000oooo00`0oooo00<000000?ooo`3oool05@3oool200000?l0oooo_@3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3ooooc0?ooo`@0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob0?ooo`D0003o
1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`80oooo
1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ad0oooo0P000?l30?oo
o`80003oo`3oooo;0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ad0oooo00<0003o
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?ooolT0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c4P3oool30000o`<0oooo0P000?l20?ooo`80003o0`3oool00`000?l0oooo0000
o`0>0?ooo`D000000`3oool3000000@0oooo0`0000040?ooo`<000000`3oool500000?l0ooooW03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`0=0000o`3oool0oooo0?ooo`00
0?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`040000o`3oool0003o0?ooo`@0
003o2`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`000000o`3ooonL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a40
oooo00h0003o0?ooo`3oool0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o0?oo
o`D0003o403oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo0?l0ooooW@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`0D
0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o
0?ooo`000?l0oooo0000o`3oool40000o`/0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`3o0?oooi`0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c4@3oool02P000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3oool3
0000o`80oooo0P000?l00`3oool0003o0?ooo`0?0?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0o`3ooonH0?ooo`@0003o1P3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c4@3oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00<0003o0?ooo`000?l00P3oool2
0000o`030?ooo`000?l0oooo00l0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000?l0ooooW03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<B0?ooo`<0003o203oool20000o`80oooo0`000?l>0?ooo`<00000103oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000?l0ooooV`3oool20000
o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<c@0oooo00<000000?ooo`3oool00`3oool3000000@0oooo0`000004
0?ooo`<00000103oool300000?l0ooooV`3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooon`0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`05
0000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`H0003o1P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooon/0oooo1@000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c6@3oool20000o`<0oooo0P000?oo0?oooll0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c6@3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo
0?l0ooooc@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`070000o`3oool0
003o0?ooo`000?l0oooo0000o`030?ooo`050000o`3oool0003o0?ooo`000?l03P3oool5000000h0
oooo1P00000:0?ooo`030000003oool0oooo00P0oooo1P00003o0?oooh/0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool01`000?l0oooo0000o`3oool0003o0?ooo`000?l00`3o
ool00`000?l0oooo0000o`030?ooo`@0003o2@3oool200000080oooo0P00000=0?ooo`8000000P3o
ool2000000X0oooo00<000000?ooo`3oool0203oool200000080oooo0P00003o0?oooh/0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool020000?l0oooo0000o`3oool0003o0?oo
o`000?l0oooo1@000?lD0?ooo`8000003P3oool2000000/0oooo1@0000090?ooo`800000o`3ooon>
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a<0oooo00d0003o0?ooo`000?l0oooo
0000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o00<0oooo10000?l:0?ooo`@00000403o
ool2000000`0oooo00<000000?ooo`3oool02P3oool200000?l0ooooS@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`040000o`3oool0003o0000o`80oooo00<0003o0?ooo`3o
ool00P000?l0103oool0003o0?ooo`000?l>0?ooo`8000000P3oool200000100oooo0P00000;0?oo
o`030000003oool0oooo00/0oooo0P00003o0?oooh`0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c4`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo0080003o00<0oooo
0000o`3oool0403oool4000000@0oooo0P0000020?ooo`800000203oool2000001T0oooo0P00003o
0?oooh/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool00`000?l0oooo0?oo
o`030?ooo`80003o0P3oool30000oaX0oooo100000050?ooo`8000000P3oool2000001D0oooo0P00
00020?ooo`800000o`3ooon:0?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>`3oool2000000L0oooo
1000000G0?ooo`@00000o`3ooon:0?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
ooook03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo00D0003o
0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonX0oooo1P000?l20?ooo`D0003o
1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`80oooo
1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ad0oooo0P000?l30?oo
o`80003oo`3oooo;0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ad0oooo00<0003o
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?ooolT0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c4P3oool30000o`<0oooo0P000?l20?ooo`80003o00<0oooo0000o`000?l00`00
0?l>0?ooo`D00000103oool3000000<0oooo0`00003o0?oooj/0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c4@3oool03`000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0000o`3o
ool0003o0?ooo`000?l0oooo0000o`030?ooo`030000o`3oool0003o00<0003o2`3oool00`000000
oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`3o0?oo
ojP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4@3oool03@000?l0oooo0?ooo`3o
ool0003o0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l00P3oool010000?l0oooo0?ooo`00
0?l@0?ooo`040000003oool0oooo0?ooo`H000000P3oool01@000000oooo0?ooo`3oool000000?l0
ooooZP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<A0?ooo`0=0000o`3oool0oooo
0?ooo`000?l0oooo0000o`3oool0003o0?ooo`000?l0oooo0000o`030?ooo`040000o`3oool0003o
0?ooo`@0003o2`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0oooo0?l0ooooZ03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<A0?ooo`0:0000o`3oool0oooo0?ooo`000?l0oooo0000o`3oool0003o0?ooo`<0003o
103oool20000oa00oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`@0
0000o`3ooonX0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4@3oool01@000?l0oooo0?ooo`3oool0
003o00D0oooo00D0003o0?ooo`000?l0oooo0000o`020?ooo`80003o403oool00`000000oooo0?oo
o`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0o`3ooon/0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<a80oooo0`000?l80?ooo`80003o00<0oooo0000o`000?l0
0P000?l>0?ooo`<000001P3oool2000000@0oooo00<000000?ooo`3oool0o`3ooonZ0?ooo`80003o
1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c=03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0
oooo0`00003o0?ooojP0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo/0?oo
o`040000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool01@000?l0oooo0?oo
o`3oool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`H0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?oo
o`D0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<aT0oooo0P000?l30?ooo`80003oo`3oooo?0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<aT0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`3o0?ooold0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool020000?l0oooo0000o`3oool0003o
0?ooo`000?l0oooo1@000?l00`3oool0003o0?ooo`0=0?ooo`D000003P3oool6000000X0oooo00<0
00000?ooo`3oool0203oool600000?l0ooooR`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<C0?ooo`090000o`3oool0003o0?ooo`000?l0oooo0000o`3oool0003o00<0oooo00@0003o
0?ooo`3oool0oooo10000?l90?ooo`8000000P3oool2000000d0oooo0P0000020?ooo`8000002P3o
ool00`000000oooo0?ooo`080?ooo`8000000P3oool200000?l0ooooR`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`070000o`3oool0003o0?ooo`000?l0oooo0000o`020?oo
o`040000o`3oool0oooo0000oa@0oooo0P00000>0?ooo`8000002`3oool5000000T0oooo0P00003o
0?ooohh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool01`000?l0oooo0000
o`3oool0003o0?ooo`000?l00`3oool00`000?l0oooo0000o`030?ooo`@0003o2P3oool400000100
oooo0P00000<0?ooo`030000003oool0oooo00X0oooo0P00003o0?ooohd0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c4`3oool010000?l0oooo0000o`000?l20?ooo`030000o`3oool0
oooo0080oooo0P000?l00`3oool0003o0?ooo`0=0?ooo`8000000P3oool200000100oooo0P00000;
0?ooo`030000003oool0oooo00/0oooo0P00003o0?oooh`0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c4`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0003o0080oooo0P00
0?lA0?ooo`@00000103oool200000080oooo0P0000080?ooo`8000006@3oool200000?l0ooooR`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<C0?ooo`030000o`3oool0oooo00<0oooo
0P000?l00`3oool0003o0000o`020000oaX0oooo100000050?ooo`8000000P3oool2000001D0oooo
0P0000020?ooo`800000o`3ooon:0?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>`3oool2000000L0
oooo1000000G0?ooo`@00000o`3ooon:0?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0ooook03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo00D0
003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonX0oooo1P000?l20?ooo`D0
003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3oool50000o`L0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo0`0000030?ooo`80000000<0oooo00000000
00000P3oool3000000@0oooo0P0000000`3oool0000000000002000000030?ooo`000000oooo00<0
00000`3oool00`000000oooo0?ooo`3o0?oool<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?oo
o`3oool00P3oool00`000000oooo000000020?ooo`030000003oool000000080oooo00@000000?oo
o`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0
0000o`3oooo80?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`040?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0000000@0oooo0P00003o0?ooolP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00@000000?ooo`3oool0
00000`3oool4000000030?ooo`000000000000@0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo000000020?ooo`800000o`3oooo:0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`D000000P3oool0
1P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool01P000000
oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool00000o`3oooo80?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<=0?ooo`040000003oool0oooo0?ooo`8000000P3oool2000000<0oooo0`000000103oool0
00000000003oool200000080oooo100000020?ooo`<000000P3oool00`000000oooo0?ooo`3o0?oo
ol<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool000000?l0oooocP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool010000000oooo0?oo
o`3oool200000180oooo00<000000?ooo`3oool0o`3oooo>0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`H0
00004P3oool200000?l0ooood03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooc0?ooo`@0003o1`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooob0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c
<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3U
iND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool00?l0iNGUo`3UiND;0>GUi@40
oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 293},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.4"],

Cell[TextData[{
  "If you make a mistake and try to enter input that the ",
  StyleBox["Mathematica", "TI"],
  " kernel does not understand, then the front end will produce a beep. In \
general, you will get a beep whenever something goes wrong in the front end. \
You can find out the origin of the beep using the ",
  StyleBox["Why the Beep?", "SR"],
  " item in the ",
  StyleBox["Help", "SR"],
  " menu.  "
}], "Text",
  CellTags->{"S1.3.4", "4.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Animate graphics "], 
            Cell["\<\
double\[Hyphen]click the first cell in the sequence of \
frames \
\>"]},
          {Cell["Resize a graphic "], Cell[
            "click the graphic and move the handles that appear "]},
          {Cell["Find coordinates in a graphic "], 
            Cell["\<\
move around in the graphic holding down the Command or \
Control key (or equivalent) \
\>"]},
          {Cell["Play a sound "], 
            Cell["\<\
double\[Hyphen]click the cell that contains it \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.4"],

Cell["Operations on graphics and sounds. ", "Caption",
  CellTags->"S1.3.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3.5 Notebooks as Documents", "Subsection",
  CellTags->{"S1.3.5", "5.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " notebooks allow you to create documents that can be viewed interactively \
on screen or printed on paper.  "
}], "Text",
  CellTags->{"S1.3.5", "5.2"}],

Cell["\<\
Particularly in larger notebooks, it is common to have chapters, \
sections and so on, each represented by groups of cells. The extent of these \
groups is indicated by a bracket on the right. \
\>", "Text",
  CellTags->{"S1.3.5", "5.3"}],

Cell["\<\
The grouping of cells in a notebook is indicated by nested brackets \
on the right.\
\>", "MathCaption",
  CellTags->{"S1.3.5", "5.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000l2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool000000000003o00000?l00000200000010?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`80oooo1@000?l20?ooo`D0003o1`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
j03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<`l0oooo0`0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo00<000000?oo
o`3oool01@3oool00`000000oooo000000030?ooo`<0000000<0oooo0000003oool00`0000000`3o
ool0000000000006000000030?ooo`000000000000@0oooo00<000000?ooo`0000000P000000103o
ool000000000003oool2000000D0oooo0`0000030?ooo`8000000`3oool2000000<0oooo0`000002
0?ooo`<0000000@0oooo000000000000oooo0P0000000`3oool00000000000030?ooo`<00000103o
ool2000000030?ooo`000000oooo00<000000P3oool3000000<0oooo0P0000030?ooo`8000000`3o
ool00`000000oooo00000002000000040?ooo`000000000000000080oooo0`0000001@3oool00000
0000003oool000000?l0oooo>@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<a00oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000@0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`060000003oool0oooo0000003oool00000
0P3oool00`000000oooo000000020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo000000020?ooo`800000103oool010000000oooo0?ooo`0000020?oo
o`060000003oool0oooo0000003oool000000`3oool00`000000oooo000000020?ooo`030000003o
ool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?ooocX0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`05
0000003oool0oooo0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000L0oooo00D00000
0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0000000T0oooo0P0000000`3oool000000?ooo`030?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0
oooo0000003oool000000`3oool00`000000oooo0?ooo`040?ooo`8000000P3oool01P000000oooo
0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool0oooo0P0000000`3oool000000?ooo`03
0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?ooocX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`040000003oool0oooo
0?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0000000<00000103oool2000000<0oooo100000000`3oool000000?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo000000<0
oooo00<000000?ooo`3oool00P3oool2000000@0oooo00H000000?ooo`3oool000000?ooo`000003
0?ooo`040000003oool00000000000<0oooo100000000`3oool000000?ooo`030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool0o`3ooolj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c403oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool00000
0?ooo`0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3oool01P000000
oooo0?ooo`000000oooo000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`0000000P3oool2000000@0oooo00@000000?ooo`3oool00000
0P3oool01@000000oooo0?ooo`000000oooo008000000P3oool00`000000oooo000000020?ooo`03
0000003oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`03
0000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?oo
ocX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@
0?ooo`030000003oool0oooo0080oooo0P0000020?ooo`80000000<0oooo0000000000000`000004
0?ooo`80000000@0oooo000000000000oooo200000020?ooo`<000000P3oool2000000030?ooo`00
0000oooo00800000103oool300000080oooo0`0000030?ooo`8000001P3oool300000080oooo0P00
00030?ooo`8000000`3oool300000080oooo00@000000?ooo`00000000000`3oool2000000030?oo
o`000000oooo00@0oooo0`000000103oool000000000003oool2000000030?ooo`000000oooo0080
00000`3oool300000080oooo0P0000030?ooo`80000000D0oooo00000000000000000?ooo`020000
0080oooo0`0000020?ooo`040000003oool0000000000?l0oooo?@3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0?0?ooo`050000003oool0oooo0?ooo`000000403oool01@000000oooo
0?ooo`3oool0000002/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`03
0000003oool0oooo0?l0ooooBP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`d0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo0?l0ooooG`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<`d0oooo1`00000K0?ooo`030000003oool0oooo0080oooo0P00
00050?ooo`030000003oool0oooo00/0oooo0P00000Z0?ooo`8000003P3oool2000001P0oooo00<0
00000?ooo`3oool0o`3ooom60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooU0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool5
0000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c5`3oool30000
0080oooo2@000000103oool000000000000000020?ooo`<00000103oool7000000040?ooo`000000
000000000080oooo0`0000000`3oool0000000000002000000D0oooo100000030?ooo`80000000L0
oooo00000000000000000?ooo`000000oooo00<000000P3oool4000000<0oooo0`0000030?ooo`<0
00000`3oool700000080oooo0`0000020?ooo`@0000000@0oooo0000000000000000o`3ooomN0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6
000000H0oooo00<000000?ooo`3oool00`3oool200000080oooo0P0000020?ooo`8000000P3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool200000080oooo0P000002
0?ooo`040000003oool00000000000H0oooo00<000000?ooo`3oool00P000000103oool000000000
003oool300000080oooo0P0000020?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool0
0000000000020?ooo`040000003oool0000000000080oooo00@000000?ooo`00000000000`3oool2
00000080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool200000?l0ooooG`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P00
00070?ooo`040000003oool0oooo0?ooo`8000000`3oool200000080oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000000`3oool00000
000000050?ooo`800000203oool3000000030?ooo`00000000000080oooo0P0000020?ooo`800000
0`3oool200000080oooo1@0000040?ooo`8000001@3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000P3oool200000?l0ooooG`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000070?ooo`H0
00000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000080oooo0P0000000`3oool0000000000004000000030?ooo`000000000000L0
oooo0`0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`80000000D0oooo00000000
000000000?ooo`08000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`00000000000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`H000001`3oool00`000000oooo0?ooo`02
000000@0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000
000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000030?ooo`000000
000000H0oooo0`0000030?ooo`8000000P3oool200000080oooo0P0000030?ooo`D000000P3oool2
00000080oooo100000020?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000020?ooo`800000o`3ooomO0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6000000P0oooo00@0
00000?ooo`0000000000103oool3000000030?ooo`00000000000080oooo0P0000000`3oool00000
000000020?ooo`8000000`3oool3000000030?ooo`00000000000080oooo00@000000?ooo`3oool0
00000P3oool5000000<0oooo0P0000020?ooo`040000003oool0000000000080oooo0P0000020?oo
o`<0000000@0oooo000000000000oooo0P0000020?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00P000000103oool000000000003oool2000000<0oooo0P0000020?ooo`80000000<0
oooo0000000000000P3oool3000000030?ooo`00000000000?l0ooooG`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000080?ooo`@00000
0`3oool3000000030?ooo`000000000000@0oooo0`0000020?ooo`@000000P3oool2000000030?oo
o`000000000000@0oooo0P0000020?ooo`<0000000<0oooo000000000000103oool7000000040?oo
o`000000000000000080oooo0P0000000`3oool00000000000030?ooo`@000000P3oool2000000@0
oooo0`0000000`3oool0000000000002000000040?ooo`0000000000000000<0oooo0`0000020?oo
o`<0000000<0oooo000000000000o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c6P3oool3000001@0oooo0P0000030?ooo`8000008P3oool2
000001L0oooo0P00003o0?ooog<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<K0?ooo`8000005@3oool010000000oooo0?ooo`3oool200000280oooo
0P00000H0?ooo`040000003oool0oooo0?ooo`800000o`3ooom^0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c6`3oool00`000000oooo0?ooo`0G0?oo
o`<000008@3oool3000001`0oooo0P00003o0?ooofh0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonD0oooo10000?l60?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`80oooo1@000?l60?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l20?ooo`D0003o1P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool300000080oooo00<000000?ooo`3oool00`00
0000103oool000000000000000020?ooo`<000000P3oool2000000H0oooo00<000000?ooo`3oool0
0P0000020?ooo`80000000<0oooo0000000000000P3oool010000000oooo0?ooo`00003o0?oooj/0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`06
0000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`3o0?ooojd0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`060000003o
ool0oooo0000003oool000000P3oool00`000000oooo000000030?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000060?ooo`050000003oool0
oooo0?ooo`000000o`3ooon_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c3P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`0000020?ooo`@00000103oool00`000000oooo0?ooo`04
000000<0oooo00D000000?ooo`3oool0oooo0000003o0?ooojl0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`030000003oool0000000<0oooo
00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo0080000000D0oooo0000003o
ool0oooo000000040?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?oo
o`0000020?ooo`030000003oool0oooo0?l0oooo[@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<`h0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000020?ooo`<000000P3oool01@000000oooo000000000000oooo00800000103oool30000
0080oooo0P0000020?ooo`80000000<0oooo0000000000000`00003o0?ooojh0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`8000001@3oool2
000001<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`3o0?ooojd0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`8000001@3o
ool200000?l0ooood@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<`d0oooo0P0000070?ooo`800000o`3oooo@0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooU0?ooo`@0003o1P3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooT0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`<000000`3oool200000080oooo0P000000
0`3oool00000000000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000000`3oool3
000000030?ooo`000000oooo00<0000000<0oooo0000000000001P0000000`3oool0000000000004
0?ooo`80000000<0oooo0000003oool00P3oool3000000@0oooo0P0000000`3oool000000?ooo`03
00000080oooo0`0000030?ooo`8000000`3oool2000000<0oooo00<000000?ooo`0000000P000000
103oool000000000000000020?ooo`<0000000D0oooo000000000000oooo0000003o0?ooofH0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<0
00000?ooo`3oool01P3oool00`000000oooo000000040?ooo`030000003oool0000000<0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080
oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`060000003oool0
oooo0000003oool000000`3oool00`000000oooo000000020?ooo`030000003oool000000080oooo
00<000000?ooo`0000000P3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`3o0?ooofL0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`050000003oool0oooo
0?ooo`0000001P3oool01@000000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000001P3oool2
00000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo0?ooo`80
000000<0oooo0000003oool00`3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0o`3o
oomW0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
403oool010000000oooo0?ooo`3oool4000000<0oooo00D000000?ooo`3oool0oooo000000070?oo
o`050000003oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`<00000
103oool2000000@0oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool00000
000000<0oooo100000000`3oool000000?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0o`3ooomW0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool01@00
0000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`0000000`3oool01P000000oooo0?ooo`000000oooo0000
00<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0000003oool00P0000020?ooo`030000003oool000000080oooo00<000000?oo
o`0000000P3oool00`000000oooo000000020?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0?l0ooooI`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<0
00000?ooo`3oool00P3oool200000080oooo0P0000000`3oool0000000000003000000@0oooo0P00
0000103oool000000000003oool800000080oooo0`0000020?ooo`80000000<0oooo0000003oool0
0P0000060?ooo`8000001P3oool3000000040?ooo`00000000000?ooo`80000000<0oooo0000003o
ool00P0000030?ooo`<000000P3oool2000000<0oooo0P0000001@3oool00000000000000000oooo
008000000P3oool300000080oooo00@000000?ooo`0000000000o`3ooomZ0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c403oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00l0oooo00D000000?ooo`3oool0oooo0000000S0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0o`3ooomg0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3o0?oo
oh`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=
0?ooo`L000006`3oool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`0J
0?ooo`800000603oool00`000000oooo0?ooo`3o0?ooog<0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonD0oooo10000?l60?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`H0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooooT0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>4
0?ooo`D00000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cQ03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooG03o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<hD0oooo
1@00003o0?oooeh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<G0?ooo`030000003oool0000000<00000103oool2000000070?ooo`00000000000000
003oool000000?ooo`0300000080oooo100000030?ooo`<000000`3oool3000000<0oooo1`000002
0?ooo`<000000P3oool4000000040?ooo`0000000000000000<0oooo10000000103oool000000000
000000020?ooo`<0000000<0oooo0000000000001@0000020?ooo`80000000<0oooo000000000000
2@0000000`3oool000000000000600000?l0ooooG`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000050?ooo`8000000`3oool200000080
oooo0P000000103oool000000000000000020?ooo`8000000P3oool2000000040?ooo`000000oooo
0?ooo`80000000<0oooo0000000000000P3oool010000000oooo0000000000020?ooo`040000003o
ool00000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo
0P0000050?ooo`8000000P3oool200000080oooo0P0000020?ooo`<000000P3oool200000080oooo
0P000000103oool000000000000000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`03
0000003oool0oooo0?l0ooooH03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<``0oooo1P0000050?ooo`030000003oool0oooo0080oooo0P0000020?oo
o`8000000P3oool200000080oooo0P0000030?ooo`8000000P3oool5000000@0oooo0P0000050?oo
o`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?oo
o`8000001@3oool200000080oooo0P0000000`3oool00000000000040?ooo`8000000P3oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?oo
o`@00000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c303oool6000000T0oooo0`0000020?ooo`8000000P3oool200000080oooo0P000003
0?ooo`80000000D0oooo00000000000000000?ooo`08000000D0oooo0P0000030?ooo`80000000<0
oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000050?ooo`8000000P3o
ool2000000030?ooo`000000000000@000000P3oool4000000030?ooo`000000000000<0oooo0P00
00020?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000o`3o
oomN0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
303oool6000000L0oooo100000030?ooo`8000000P3oool200000080oooo0P0000030?ooo`D00000
0P3oool200000080oooo100000020?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000001@3oool200000080oooo
0P0000000`3oool00000000000020?ooo`@000000P3oool2000000030?ooo`000000000000<0oooo
0P0000020?ooo`8000000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000
o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c303oool6000000H0oooo100000040?ooo`8000000P3oool200000080oooo0`000000103oool0
00000000003oool200000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020000
00040?ooo`00000000000?ooo`8000000`3oool200000080oooo0P0000000`3oool0000000000002
0?ooo`<0000000<0oooo0000000000001@3oool3000000030?ooo`00000000000080oooo00D00000
0?ooo`3oool000000?ooo`0200000080oooo0P0000020?ooo`80000000@0oooo0000000000000000
0P3oool200000080oooo0`000000103oool000000000003oool200000080oooo0P00003o0?oooeh0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?oo
o`H000001@3oool3000000D0oooo0`000000103oool000000000000000020?ooo`80000000<0oooo
0000000000000`3oool400000080oooo0P0000040?ooo`<0000000<0oooo0000000000000P000000
103oool000000000000000030?ooo`<000000P3oool3000000030?ooo`000000000000H0oooo0P00
00000`3oool00000000000040?ooo`8000000`3oool4000000@0oooo0P000000103oool000000000
003oool3000000050?ooo`00000000000000003oool00P0000030?ooo`H00000o`3ooomM0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c5`3oool20000
00@0oooo00<000000?ooo`3oool0203oool2000001L0oooo0P00000I0?ooo`8000005`3oool20000
0?l0ooooL@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<aL0oooo0P0000030?ooo`8000002P3oool2000001P0oooo00@000000?ooo`3oool0oooo0P00
000D0?ooo`8000005`3oool200000080oooo0P00003o0?ooofd0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<H0?ooo`@0000000<0oooo0000003oool0
203oool3000001`0oooo0P00000C0?ooo`<000005P3oool300000080oooo0P00003o0?ooofd0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onD0oooo10000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03o
ool50000o`80oooo1@000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`H0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>00?ooo`@00000o`3ooom[0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<gl0oooo0P0000020?ooo`800000o`3ooomZ0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<h@0oooo0P00003o0?ooofT0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000P0oooo1@0000050?ooo`<000001@3oool3
000000@0oooo0P0000020?ooo`800000103oool3000000<0oooo0P0000030?ooo`8000001P3oool2
000000<0oooo0P0000030?ooo`<00000103oool700000080oooo1@0000000`3oool0000000000002
0?ooo`8000000`3oool2000000<0oooo1@00003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c303oool9000000L0oooo0P0000030?ooo`8000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`8000000P3o
ool2000000030?ooo`00000000000080oooo0P0000020?ooo`<000000P3oool2000000050?ooo`00
000000000000003oool00P0000020?ooo`8000000`3oool200000080oooo0P000000103oool00000
00000000003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool90000
00H0oooo0P0000050?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3o
ool00000000000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oo
ofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000H0oooo0P000005
0?ooo`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`8000000P3oool2
000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P000000
0`3oool00000000000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o
0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000d0oooo0P00
00000`3oool0000000000005000000030?ooo`000000000000H0oooo0P0000030?ooo`8000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0oooo0P00
00000`3oool000000000000500000080oooo1P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3o
oomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@00000<0?ooo`800000
0P3oool2000000<0oooo0P0000000`3oool00000000000060?ooo`8000000`3oool200000080oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000D0oooo0`0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000080?ooo`D0
00000`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0
oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`800000203oool2000000030?ooo`0000000000
00<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool2000000<0oooo0P0000000`3o
ool00000000000020?ooo`<000000P3oool2000000H0oooo0`0000020?ooo`8000000P3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool2000000050?ooo`0000000000
0000003oool00P0000020?ooo`<000000P3oool200000080oooo0P000000103oool0000000000000
003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000H0oooo
0P0000050?ooo`8000000`3oool3000000D0oooo100000000`3oool000000000000200000080oooo
0P0000040?ooo`<000000`3oool6000000L0oooo1P0000040?ooo`<00000103oool5000000@0oooo
1@0000000`3oool00000000000020?ooo`H00000103oool500000?l0ooooJ@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<K0?ooo`8000001@3oool200000140oooo0P00000L0?ooo`80
00006`3oool200000?l0ooooO@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<L0?oo
o`8000000`3oool200000180oooo0P00000L0?ooo`8000006`3oool200000?l0ooooNP3oool40000
o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ad0oooo1@00000H0?ooo`8000005`3oool2000001/0oooo0P000000
0`3oool000000000003o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo[0?ooo`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o00000?h0000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c
<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VI
V@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00o`3UiNGo0>GUi@X0iNGU0@0c<c<10?ooo`00
o`3UiNGo0>GUi@/0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 240},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.5"],

Cell[TextData[{
  "A group of cells can be either ",
  StyleBox["open", "TI"],
  " or ",
  StyleBox["closed", "TI"],
  ". When it is open, you can see all the cells in it explicitly. But when it \
is closed, you see only the first or ",
  StyleBox["heading", "TI"],
  " cell in the group.  "
}], "Text",
  CellTags->{"S1.3.5", "5.5"}],

Cell["\<\
Large notebooks are often distributed with many closed groups of \
cells, so that when you first look at the notebook, you see just an outline \
of its contents. You can then open parts you are interested in by double\
\[Hyphen]clicking the appropriate brackets. \
\>", "Text",
  CellTags->{"S1.3.5", "5.6"}],

Cell["\<\
Double\[Hyphen]clicking the bracket that spans a group of cells \
closes the group, leaving only the first cell visible. \
\>", "MathCaption",
  CellTags->{"S1.3.5", "5.7"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000PR000`400?l00000o`00003o0P3ooooo
00000?l000002@0000010?ooo`0000<0oooo0>GUi@3UiND0o`0c<c?o03<c<`P0<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooohP3oool50000o`H0oooo00<0003o0?ooo`3oool01@000?l80?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onH0oooo00<0003o0?ooo`3oool00`3oool20000o`H0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooV0?oo
o`030000o`3oool0oooo0080oooo0`000?l60?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool01000
0?l0oooo0?ooo`3oool40000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool300000080oooo2@000000
103oool000000000000000020?ooo`<00000103oool7000000040?ooo`000000000000000080oooo
0`0000000`3oool0000000000002000000D0oooo100000030?ooo`80000000L0oooo000000000000
00000?ooo`000000oooo00<000000P3oool4000000<0oooo0`0000030?ooo`<000000`3oool70000
0080oooo0`0000020?ooo`@0000000@0oooo0000000000000000o`3ooomN0?ooo`030000o`3oool0
oooo00D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001P3oool00`000000oooo0?ooo`03
0?ooo`8000000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2
000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo00@000000?ooo`00000000001P3o
ool00`000000oooo0?ooo`02000000040?ooo`00000000000?ooo`<000000P3oool200000080oooo
0P000000103oool000000?ooo`3oool2000000030?ooo`00000000000080oooo00@000000?ooo`00
000000000P3oool010000000oooo0000000000030?ooo`8000000P3oool2000000030?ooo`000000
00000080oooo0P0000020?ooo`800000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001`3oool010000000oooo0?ooo`3o
ool2000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
0000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000001@3oool2000000P0oooo0`00
00000`3oool00000000000020?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`D00000103o
ool2000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00
000000000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000070?ooo`H000000`3oool200000080oooo0P00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P00
00000`3oool0000000000004000000030?ooo`000000000000L0oooo0`0000020?ooo`8000000P3o
ool200000080oooo0P0000030?ooo`80000000D0oooo00000000000000000?ooo`08000000D0oooo
0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo
0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`X0oooo1P0000070?ooo`030000003oool0oooo00800000103oool200000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo
0P0000000`3oool00000000000020?ooo`80000000<0oooo0000000000001P3oool3000000<0oooo
0P0000020?ooo`8000000P3oool2000000<0oooo1@0000020?ooo`8000000P3oool400000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000080?ooo`040000003oool00000000000@0
oooo0`0000000`3oool00000000000020?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0`0000000`3oool00000000000020?ooo`040000003oool0oooo00000080oooo1@0000030?oo
o`8000000P3oool010000000oooo0000000000020?ooo`8000000P3oool3000000040?ooo`000000
00000?ooo`8000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo0080000000@0
oooo000000000000oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0`0000000`3oool000000000003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000080?ooo`@000000`3oool3000000030?oo
o`000000000000@0oooo0`0000020?ooo`@000000P3oool2000000030?ooo`000000000000@0oooo
0P0000020?ooo`<0000000<0oooo000000000000103oool7000000040?ooo`000000000000000080
oooo0P0000000`3oool00000000000030?ooo`@000000P3oool2000000@0oooo0`0000000`3oool0
000000000002000000040?ooo`0000000000000000<0oooo0`0000020?ooo`<0000000<0oooo0000
00000000o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<H0?ooo`<00000503oool2000000<0oooo0P00000R0?ooo`8000005`3oool20000
0?l0ooooL`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c6@3oool2000001D0oooo00@000000?ooo`3oool0oooo0P00000R0?ooo`800000603oool0
10000000oooo0?ooo`3oool200000?l0ooooKP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool00`000000oooo0?ooo`0G0?ooo`<000008@3o
ool3000001`0oooo0P00003o0?ooofh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooS0?ooo`@0003o1P3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooR0?ooo`D0003o0P3oool50000o`H0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooR0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<h80oooo1@00003o0?oooel0oooo00<0003o0?ooo`3oool00`3oool20000o`H0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cPP3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooG03o
ool00`000?l0oooo0?ooo`020?ooo`<0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>30?ooo`D00000o`3o
oomN0?ooo`040000o`3oool0oooo0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`030000
003oool0000000<00000103oool2000000070?ooo`00000000000000003oool000000?ooo`030000
0080oooo100000030?ooo`<000000`3oool3000000<0oooo1`0000020?ooo`<000000P3oool40000
00040?ooo`0000000000000000<0oooo10000000103oool000000000000000020?ooo`<0000000<0
oooo0000000000001@0000020?ooo`80000000<0oooo0000000000002@0000000`3oool000000000
000600000?l0ooooG`3oool00`000?l0oooo0?ooo`050000o`H0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3o
ool6000000D0oooo0P0000030?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo
0P0000020?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool00000000000020?ooo`04
0000003oool0000000000080oooo00@000000?ooo`00000000000`3oool200000080oooo0P000000
0`3oool00000000000020?ooo`8000000P3oool2000000D0oooo0P0000020?ooo`8000000P3oool2
00000080oooo0`0000020?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo0P00
00020?ooo`8000000P3oool200000080oooo00<000000?ooo`3oool0o`3ooomP0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001@3o
ool00`000000oooo0?ooo`020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3o
ool200000080oooo1@0000040?ooo`8000001@3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`80000000<0oooo0000000000000P3oool2000000D0oooo0P0000020?ooo`80000000<0
oooo000000000000103oool200000080oooo0P0000000`3oool00000000000030?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`8000000P3oool400000?l0ooooG`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3oool6000000T0oooo0`00
00020?ooo`8000000P3oool200000080oooo0P0000030?ooo`80000000D0oooo0000000000000000
0?ooo`08000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000050?ooo`8000000P3oool2000000030?ooo`000000000000@00000
0P3oool4000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000P3oool200000080oooo
0P0000000`3oool00000000000020?ooo`800000o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001`3oool4000000<0oooo
0P0000020?ooo`8000000P3oool2000000<0oooo1@0000020?ooo`8000000P3oool400000080oooo
0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000050?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
100000020?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000020?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P00003o0?oooeh0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo1P0000060?ooo`@00000
103oool200000080oooo0P0000020?ooo`<0000000@0oooo000000000000oooo0P0000020?ooo`03
0000003oool000000080oooo00<000000?ooo`3oool00P000000103oool000000000003oool20000
00<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool3000000030?ooo`0000000000
00D0oooo0`0000000`3oool00000000000020?ooo`050000003oool0oooo0000003oool00P000002
0?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo0P0000020?ooo`<0000000@0
oooo000000000000oooo0P0000020?ooo`800000o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`H000001@3oool3000000D0oooo
0`000000103oool000000000000000020?ooo`80000000<0oooo0000000000000`3oool400000080
oooo0P0000040?ooo`<0000000<0oooo0000000000000P000000103oool000000000000000030?oo
o`<000000P3oool3000000030?ooo`000000000000H0oooo0P0000000`3oool00000000000040?oo
o`8000000`3oool4000000@0oooo0P000000103oool000000000003oool3000000050?ooo`000000
00000000003oool00P0000030?ooo`H00000o`3ooomM0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`800000103oool00`000000oooo0?oo
o`080?ooo`8000005`3oool2000001T0oooo0P00000G0?ooo`800000o`3oooma0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`8000000`3o
ool2000000X0oooo0P00000H0?ooo`040000003oool0oooo0?ooo`800000503oool2000001L0oooo
0P0000020?ooo`800000o`3ooom]0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<F0?ooo`@0000000<0oooo0000003oool0203oool3000001`0oooo
0P00000C0?ooo`<000005P3oool300000080oooo0P00003o0?ooofd0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooS0?ooo`@0003o
1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooiP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooR0?ooo`D0003o
0P3oool50000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooood0?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooj@3oool50000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo]0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cOP3oool400000?l0ooooJ`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<gd0oooo0P0000020?ooo`800000o`3ooomZ0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cPP3oool200000?l0ooooJ@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo2@0000080?ooo`D000001@3oool3000000D0oooo
0`0000040?ooo`8000000P3oool2000000@0oooo0`0000030?ooo`8000000`3oool2000000H0oooo
0P0000030?ooo`8000000`3oool3000000@0oooo1`0000020?ooo`D0000000<0oooo000000000000
0P3oool2000000<0oooo0P0000030?ooo`D00000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c2P3oool9000000L0oooo0P0000030?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo
0P0000000`3oool00000000000020?ooo`8000000`3oool2000000H0oooo0P0000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`<000000P3oool2000000050?oo
o`00000000000000003oool00P0000020?ooo`8000000`3oool200000080oooo0P000000103oool0
000000000000003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?oo
o`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000
000000000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool20000
00030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
0?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo2@0000060?oo
o`8000001@3oool2000000030?ooo`000000000000H0oooo0P0000060?ooo`8000000`3oool20000
0080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?oo
o`80000000<0oooo0000000000001P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3oool90000
00d0oooo0P0000000`3oool0000000000005000000030?ooo`000000000000H0oooo0P0000030?oo
o`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool000000000000500000080oooo1P0000000`3oool00000000000030?oo
o`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?oo
o`800000o`3ooomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c2P3oool90000
00`0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?oo
o`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`8000001@3oool3000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P00003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?oo
o`T00000203oool5000000<0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3o
ool00000000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`0000000000
0080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooJ@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo2@0000070?ooo`800000203oool20000
00030?ooo`000000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000`3oool20000
00<0oooo0P0000000`3oool00000000000020?ooo`<000000P3oool2000000H0oooo0`0000020?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool20000
00050?ooo`00000000000000003oool00P0000020?ooo`<000000P3oool200000080oooo0P000000
103oool0000000000000003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<:0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000001@3oool4000000030?ooo`00
00000000008000000P3oool2000000@0oooo0`0000030?ooo`H000001`3oool6000000@0oooo0`00
00040?ooo`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3o
oomY0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool2000000D0oooo0P00
000A0?ooo`800000703oool2000001/0oooo0P00003o0?ooogd0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<J0?ooo`8000000`3oool200000180oooo0P00000L0?ooo`8000006`3o
ool200000?l0ooooNP3oool40000o`H0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool5000001P0oooo0P00
000G0?ooo`8000006`3oool2000000030?ooo`00000000000?l0ooooNP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj@3oool50000o`80oooo1@000?l80?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`00003m000000040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40
iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00?l0ooooo`3o
ool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 130},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.5"],

Cell["\<\
When a group is closed, the bracket for it has an arrow at the \
bottom. Double\[Hyphen]clicking this arrow opens the group again. \
\>", \
"MathCaption",
  CellTags->{"S1.3.5", "5.8"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000e2000`400?l00000o`00003o00<0oooo
000000000000o`00003o000000P000000@3oool00080iNGUo`0c<c?o03<c<`T0<c<c0@3oool00003
0>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0oooo00D0003o1`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0
oooo0?ooo`030?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo
0080oooo0`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00@0003o0?ooo`3oool0oooo1000
0?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<G0?ooo`<000000P3oool9000000040?ooo`000000000000000080
oooo0`0000040?ooo`L0000000@0oooo00000000000000000P3oool3000000030?ooo`0000000000
008000001@3oool4000000<0oooo0P0000001`3oool00000000000000000oooo0000003oool00`00
00020?ooo`@000000`3oool3000000<0oooo0`0000030?ooo`L000000P3oool300000080oooo1000
0000103oool0000000000000003o0?oooeh0oooo00<0003o0?ooo`3oool01@000?l60?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<<0?ooo`H000001P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool200000080
oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`80
00000P3oool200000080oooo00@000000?ooo`00000000001P3oool00`000000oooo0?ooo`020000
00040?ooo`00000000000?ooo`<000000P3oool200000080oooo0P000000103oool000000?ooo`3o
ool2000000030?ooo`00000000000080oooo00@000000?ooo`00000000000P3oool010000000oooo
0000000000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`80
0000o`3ooomO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c303oool6000000L0oooo00@000000?ooo`3oool0oooo0P0000030?ooo`8000000P3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`8000000P3oool2
000000030?ooo`000000000000D0oooo0P0000080?ooo`<0000000<0oooo0000000000000P3oool2
00000080oooo0P0000030?ooo`8000000P3oool5000000@0oooo0P0000050?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`800000o`3ooomO
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303o
ool6000000L0oooo1P0000030?ooo`8000000P3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`8000000P3oool2000000030?ooo`000000000000@0000000<0
oooo0000000000001`3oool300000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P00
00001@3oool00000000000000000oooo00P000001@3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000P3oool200000?l0ooooG`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo1P0000070?ooo`03
0000003oool0oooo00800000103oool200000080oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`80
000000<0oooo0000000000001P3oool3000000<0oooo0P0000020?ooo`8000000P3oool2000000<0
oooo1@0000020?ooo`8000000P3oool400000080oooo0P0000000`3oool00000000000030?ooo`80
000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P00003o0?oooel0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?oo
o`H00000203oool010000000oooo0000000000040?ooo`<0000000<0oooo0000000000000P3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`<0000000<0oooo0000000000000P3oool0
10000000oooo0?ooo`0000020?ooo`D000000`3oool200000080oooo00@000000?ooo`0000000000
0P3oool200000080oooo0`000000103oool000000000003oool200000080oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`02000000040?ooo`00000000000?ooo`8000000`3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`<0000000<0oooo000000000000o`3ooomO0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6
000000P0oooo100000030?ooo`<0000000<0oooo000000000000103oool300000080oooo10000002
0?ooo`80000000<0oooo000000000000103oool200000080oooo0`0000000`3oool0000000000004
0?ooo`L0000000@0oooo00000000000000000P3oool2000000030?ooo`000000000000<0oooo1000
00020?ooo`800000103oool3000000030?ooo`00000000000080000000@0oooo0000000000000000
0`3oool300000080oooo0`0000000`3oool000000000003o0?ooof00oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<J0?ooo`<00000503oool2000000<0
oooo0P00000R0?ooo`8000005`3oool200000?l0ooooL`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a/0oooo0P00000E0?ooo`040000003oool0oooo
0?ooo`8000008P3oool2000001P0oooo00@000000?ooo`3oool0oooo0P00003o0?ooofh0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<K0?ooo`030000
003oool0oooo01L0oooo0`00000Q0?ooo`<00000703oool200000?l0ooooKP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi@3oool40000
o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooT0?ooo`D0003o0P3o
ool50000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000
o`80oooo1@000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`<000000P3oool00`00
0000oooo0?ooo`03000000040?ooo`000000000000000080oooo0`0000020?ooo`8000001P3oool0
0`000000oooo0?ooo`0200000080oooo0P0000000`3oool00000000000020?ooo`040000003oool0
oooo00000?l0ooooZ`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<`h0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0
oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo0?l0
oooo[@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<`h0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0000000<0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`050?ooo`040000003oool0oooo000000H0
oooo00D000000?ooo`3oool0oooo0000003o0?ooojl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<>0?ooo`060000003oool0oooo0000003oool00000
0P3oool00`000000oooo000000030?ooo`040000003oool0oooo00000080oooo100000040?ooo`03
0000003oool0oooo00@000000`3oool01@000000oooo0?ooo`3oool000000?l0oooo[`3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`h0oooo00<00000
0?ooo`0000000`3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool00P00
00001@3oool000000?ooo`3oool0000000@0oooo00@000000?ooo`3oool000000P3oool01P000000
oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool0o`3ooon]0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3P3oool00`000000oooo0000
00030?ooo`030000003oool000000080oooo0`0000020?ooo`050000003oool000000000003oool0
0P0000040?ooo`<000000P3oool200000080oooo0P0000000`3oool000000000000300000?l0oooo
[P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`h0
oooo0P0000050?ooo`8000004`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0
oooo[@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<`h0oooo0P0000050?ooo`800000o`3ooooA0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool2000000L0oooo0P00003o0?ooom00oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonD0oooo1000
0?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi03oool50000o`H0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
k`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo0`0000030?ooo`80
00000P3oool2000000030?ooo`00000000000080oooo00<000000?ooo`3oool01@3oool00`000000
oooo000000030?ooo`<0000000<0oooo0000003oool00`0000000`3oool000000000000600000003
0?ooo`000000000000@0oooo0P0000000`3oool000000?ooo`020?ooo`<00000103oool200000003
0?ooo`000000oooo00<000000P3oool3000000<0oooo0P0000030?ooo`8000000`3oool00`000000
oooo00000002000000040?ooo`000000000000000080oooo0`0000001@3oool000000000003oool0
00000?l0ooooIP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<a00oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0oooo0000003o
ool000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000@0oooo00<000000?oo
o`0000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo00000080
oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`030000003oool000000080oooo00<00000
0?ooo`0000000P3oool00`000000oooo000000020?ooo`030000003oool0000000<0oooo00<00000
0?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0?l0ooooI`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo
00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000001`3oool01@00
0000oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000060?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00@00000
0?ooo`3oool0oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0oooo0080oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`3o0?ooofL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<@0?ooo`040000003oool0oooo0?ooo`@000000`3oool01@000000oooo0?oo
o`3oool0000000L0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0000000<0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00<0oooo0`0000040?ooo`800000103oool01P000000oooo0?ooo`000000oooo000000<0oooo
00@000000?ooo`00000000000`3oool4000000030?ooo`000000oooo00<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`3o0?ooofL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<@0?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo00<000000?ooo`3oool0103oool00`000000oooo000000030?ooo`060000003oool0
oooo0000003oool000000`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0
oooo00000080oooo00D000000?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`000000
0P3oool00`000000oooo000000020?ooo`030000003oool000000080oooo00<000000?ooo`000000
0`3oool00`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool0o`3ooomW0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c403oool00`000000oooo0?ooo`020?ooo`8000000P3oool2000000030?ooo`0000000000
00<00000103oool2000000040?ooo`00000000000?ooo`P000000P3oool300000080oooo0P000000
0`3oool000000?ooo`02000000H0oooo0P0000060?ooo`<0000000@0oooo000000000000oooo0P00
00000`3oool000000?ooo`02000000<0oooo0`0000020?ooo`8000000`3oool2000000050?ooo`00
000000000000003oool00P0000020?ooo`<000000P3oool010000000oooo00000000003o0?ooofX0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool01@000000oooo0?ooo`3oool0
000002<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`3o0?ooogL0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0Q0?ooo`030000
003oool0oooo0?l0ooooS03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<`d0oooo1`00000K0?ooo`030000003oool0oooo0080oooo0P0000050?ooo`03
0000003oool0oooo01X0oooo0P00000H0?ooo`030000003oool0oooo0?l0ooooL`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooi@3oool40000
o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooT0?ooo`D0003o1P3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<h@0oooo1@00003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>40?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0o`3ooomL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<cQ@3oool500000?l0ooooGP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<aL0oooo00<000000?ooo`0000000`0000040?ooo`80000000L0
oooo00000000000000000?ooo`000000oooo00<000000P3oool4000000<0oooo0`0000030?ooo`<0
00000`3oool700000080oooo0`0000020?ooo`@0000000@0oooo00000000000000000`3oool40000
00040?ooo`000000000000000080oooo0`0000000`3oool000000000000500000080oooo0P000000
0`3oool0000000000009000000030?ooo`000000000000H00000o`3ooomO0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6000000D0oooo0P00
00030?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo0P0000020?ooo`800000
00@0oooo0000003oool0oooo0P0000000`3oool00000000000020?ooo`040000003oool000000000
0080oooo00@000000?ooo`00000000000`3oool200000080oooo0P0000000`3oool0000000000002
0?ooo`8000000P3oool2000000D0oooo0P0000020?ooo`8000000P3oool200000080oooo0`000002
0?ooo`8000000P3oool2000000040?ooo`000000000000000080oooo0P0000020?ooo`8000000P3o
ool200000080oooo00<000000?ooo`3oool0o`3ooomP0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool6000000D0oooo00<000000?ooo`3oool0
0P3oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`D00000
103oool2000000D0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000030?oo
o`00000000000080oooo0P0000050?ooo`8000000P3oool2000000030?ooo`000000000000@0oooo
0P0000020?ooo`80000000<0oooo0000000000000`3oool200000080oooo0P0000020?ooo`800000
0P3oool200000080oooo1000003o0?oooel0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`H000002@3oool300000080oooo0P0000020?ooo`80
00000P3oool2000000<0oooo0P0000001@3oool00000000000000000oooo00P000001@3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool20000
00D0oooo0P0000020?ooo`80000000<0oooo000000000000100000020?ooo`@0000000<0oooo0000
000000000`3oool200000080oooo0P0000020?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0P00003o0?oooeh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<<0?ooo`H000001`3oool4000000<0oooo0P0000020?ooo`8000000P3oool2
000000<0oooo1@0000020?ooo`8000000P3oool400000080oooo0P0000000`3oool0000000000003
0?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P000005
0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo100000020?ooo`80000000<0oooo
0000000000000`3oool200000080oooo0P0000020?ooo`8000000P3oool2000000030?ooo`000000
00000080oooo0P00003o0?oooeh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<<0?ooo`H000001P3oool4000000@0oooo0P0000020?ooo`8000000P3o
ool3000000040?ooo`00000000000?ooo`8000000P3oool00`000000oooo000000020?ooo`030000
003oool0oooo0080000000@0oooo000000000000oooo0P0000030?ooo`8000000P3oool200000003
0?ooo`00000000000080oooo0`0000000`3oool00000000000050?ooo`<0000000<0oooo00000000
00000P3oool01@000000oooo0?ooo`000000oooo008000000P3oool200000080oooo0P000000103o
ool000000000000000020?ooo`8000000P3oool3000000040?ooo`00000000000?ooo`8000000P3o
ool200000?l0ooooGP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<``0oooo1P0000050?ooo`<000001@3oool3000000040?ooo`000000000000000080
oooo0P0000000`3oool00000000000030?ooo`@000000P3oool2000000@0oooo0`0000000`3oool0
000000000002000000040?ooo`0000000000000000<0oooo0`0000020?ooo`<0000000<0oooo0000
000000001P3oool2000000030?ooo`000000000000@0oooo0P0000030?ooo`@00000103oool20000
00040?ooo`00000000000?ooo`<0000000D0oooo00000000000000000?ooo`02000000<0oooo1P00
003o0?oooed0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<G0?ooo`800000103oool00`000000oooo0?ooo`080?ooo`8000005`3oool2000001T0oooo
0P00000G0?ooo`800000o`3oooma0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c5`3oool2000000<0oooo0P00000:0?ooo`800000603oool010000000
oooo0?ooo`3oool2000001@0oooo0P00000G0?ooo`8000000P3oool200000?l0ooooK@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<aP0oooo10000000
0`3oool000000?ooo`080?ooo`<00000703oool2000001<0oooo0`00000F0?ooo`<000000P3oool2
00000?l0ooooK@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0ooooi@3oool40000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooooT0?ooo`D0003o0P3oool50000o`H0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<h00oooo1000003o
0?ooof/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO`3oool200000080oooo0P00
003o0?ooofX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cQ03oool200000?l0oooo
J@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T00000203oool5000000D0
oooo0`0000050?ooo`<00000103oool200000080oooo0P0000040?ooo`<000000`3oool2000000<0
oooo0P0000060?ooo`8000000`3oool2000000<0oooo0`0000040?ooo`L000000P3oool500000003
0?ooo`00000000000080oooo0P0000030?ooo`8000000`3oool500000?l0ooooJ@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T000001`3oool2000000<0oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?oo
o`8000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000001P3oool20000
00<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo0`0000020?oo
o`80000000D0oooo00000000000000000?ooo`0200000080oooo0P0000030?ooo`8000000P3oool2
000000040?ooo`000000000000000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<<0?ooo`T000001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`800000
0`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000
0`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo000000000000
0`3oool200000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T0
00001P3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`8000001P3oool2000000<0
oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`80
00000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool200000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?oo
o`T000003@3oool2000000030?ooo`000000000000D0000000<0oooo0000000000001P3oool20000
00<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?oo
o`8000000`3oool2000000030?ooo`000000000000D000000P3oool6000000030?ooo`0000000000
00<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P00003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9
000000`0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P000003
0?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2
000000<0oooo0P0000000`3oool00000000000030?ooo`8000001@3oool3000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000
000000<0oooo0P00003o0?ooofT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303o
ool9000000P0oooo1@0000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool000000000
00030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool000000000
00020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooofT0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000L0oooo0P0000080?ooo`800000
00<0oooo0000000000000`3oool200000080oooo0P0000000`3oool00000000000030?ooo`800000
0`3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`8000001P3oool300000080oooo
0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`800000
00D0oooo00000000000000000?ooo`0200000080oooo0`0000020?ooo`8000000P3oool200000004
0?ooo`000000000000000?l0ooooJ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<
0?ooo`T000001P3oool2000000D0oooo0P0000030?ooo`<000001@3oool4000000030?ooo`000000
0000008000000P3oool2000000@0oooo0`0000030?ooo`H000001`3oool6000000@0oooo0`000004
0?ooo`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3ooomY
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a/0oooo0P0000050?ooo`8000004@3o
ool2000001`0oooo0P00000K0?ooo`800000o`3ooomm0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<a`0oooo0P0000030?ooo`8000004P3oool2000001`0oooo0P00000K0?ooo`800000
o`3ooomj0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c7@3oool5000001P0oooo0P00000G0?ooo`80
00006`3oool2000000030?ooo`00000000000?l0ooooNP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooon/0oooo1@000?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol00000oP000000103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3UiND0VIVI
09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo003o0>GU
iOl0iNGU2P3UiND103<c<`40oooo003o0>GUiOl0iNGU2`3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 212},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.5"],

Cell[TextData[{
  "Each cell within a notebook is assigned a particular ",
  StyleBox["style", "TI"],
  " which indicates its role within the notebook. Thus, for example, material \
intended as input to be executed by the ",
  StyleBox["Mathematica", "TI"],
  " kernel is typically in ",
  StyleBox["Input", "MR"],
  " style, while text that is intended purely to be read is typically in ",
  StyleBox["Text", "MR"],
  " style.   "
}], "Text",
  CellTags->{"S1.3.5", "5.9"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " front end provides menus and keyboard shortcuts for creating cells with \
different styles, and for changing styles of existing cells. "
}], "Text",
  CellTags->{"S1.3.5", "5.10"}],

Cell["\<\
This shows cells in various styles. The styles define not only the \
format of the cell contents, but also their placement and spacing.\
\>", \
"MathCaption",
  CellTags->{"S1.3.5", "5.11"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000hb000`400?l00000o`00003o00<0oooo
000000000000o`00003o000000P000000@3oool000030?ooo`3UiND0iNGU0?l0<c<co`0c<c<803<c
<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0iNGUo`3UiND10>GUi@<0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooog@3oool50000o`80oooo1@000?l20?oo
o`D0003o0P3oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooh@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>/0?ooo`@00000:03oool40000
0?l0oooo1@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c>]0?ooo`800000:P3oool200000?l0oooo1P3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<b0?ooo`@000000P3oool8000000030?ooo`000000000000@000000P3oool50000
00L0oooo100000040?ooo`@000000`3oool600000080oooo1P0000050?ooo`H000000P3oool50000
00H0oooo1P0000000`3oool0000000000006000000@0oooo1P0000000`3oool00000000000060000
00030?ooo`000000000000<00000103oool6000000<0oooo0`0000060?ooo`D000001@3oool30000
00D0oooo0P0000040?ooo`H000000`3oool4000000@0oooo0P00003]0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<c<0oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P0000040?ooo`8000000P3oool20000
00D0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000040?ooo`8000001P3oool20000
00T0oooo0P0000040?ooo`8000000P3oool2000000L0oooo0P0000040?ooo`8000000P3oool20000
00L0oooo0P0000040?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool20000
00040?ooo`0000000000000000<0oooo0P0000000`3oool00000000000050?ooo`8000000P3oool2
000000<0oooo0P0000000`3oool00000000000040?ooo`8000001P3oool2000000@0oooo0P000002
0?ooo`800000lP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<c0?ooo`800000103oool200000080oooo0P000004
0?ooo`800000203oool2000000D0oooo0P0000060?ooo`800000203oool2000000H0oooo0P000009
0?ooo`800000203oool2000000L0oooo0P0000040?ooo`8000000P3oool2000000L0oooo0P000004
0?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P000003
0?ooo`800000303oool2000000<0oooo0P0000060?ooo`@000001@3oool2000000@0oooo0P00003f
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<c<0oooo0P0000040?ooo`8000000P3oool2000000@0oooo0P000005
0?ooo`@000001P3oool2000000H0oooo1P0000040?ooo`8000001P3oool2000000T0oooo0P000005
0?ooo`@00000203oool2000000@0oooo0P0000020?ooo`8000001`3oool2000000@0oooo0P000002
0?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P000009
0?ooo`@00000103oool2000000H0oooo100000050?ooo`800000103oool600000?80oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c<`3oool2000000@0oooo0P0000020?ooo`800000103oool2000000@0oooo0P000002
0?ooo`8000001@3oool200000080oooo0P0000020?ooo`8000000P3oool2000000@0oooo0P000006
0?ooo`8000002@3oool2000000@0oooo0P0000020?ooo`8000001`3oool2000000@0oooo0`000000
0`3oool00000000000070?ooo`800000103oool3000000030?ooo`00000000000080oooo0P000002
0?ooo`8000000P3oool200000080oooo0P0000030?ooo`800000203oool200000080oooo0P000003
0?ooo`8000001@3oool200000080oooo0P0000040?ooo`800000103oool200000080oooo0P00003b
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<c00oooo0P000000103oool000000000003oool2000000030?ooo`00
0000000000<000000`3oool4000000D0oooo100000070?ooo`@00000103oool4000000D0oooo0P00
00060?ooo`8000001`3oool4000000D0oooo100000060?ooo`@000000`3oool6000000P0oooo0P00
00030?ooo`H000000P3oool600000080oooo0`000000103oool000000000000000020?ooo`D00000
1`3oool4000000<0oooo1@0000020?ooo`P000000`3oool2000000D0oooo1000003c0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<c00oooo0P000000103oool000000000003oool2000000030?ooo`000000000002/0
oooo0P0000060?ooo`800000;`3oool2000001d0oooo0P00000A0?ooo`8000003`3oool200000?/0
oooo0P000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<`0?ooo`/00000203oool2000001l0oooo100000040?ooo`@000002@3oool200000140
oooo0P00000?0?ooo`H000006`3oool200000140oooo0P00000=0?ooo`@00000nP3oool00`000?l0
oooo0000o`060?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooomh0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooM0?ooo`050000o`3oool0oooo
0?ooo`000?l01P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooooL0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooomd0oooo1@000?l60?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon40oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cIP3oool00`000000oooo0?ooo`3o0?ooogP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cI`3oool0
0`000000oooo0?ooo`3o0?ooogL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool02@000000oooo0?ooo`00
0000oooo0000003oool000000?ooo`02000000D0oooo00@000000?ooo`3oool0oooo0P000000103o
ool000000?ooo`0000030?ooo`040000003oool00000000000@0oooo00D000000?ooo`000000oooo
000000040?ooo`8000000P3oool01@000000oooo0000003oool000000080oooo0P000000103oool0
00000?ooo`0000030?ooo`040000003oool0oooo0?ooo`80000000L0oooo0000003oool0oooo0000
003oool000000080oooo0P0000030?ooo`030000003oool000000080oooo00<000000?ooo`3oool0
0P0000000`3oool000000?ooo`3o0?ooofl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool020000000oooo
0?ooo`000000oooo0000003oool000000`3oool02@000000oooo0?ooo`3oool000000?ooo`000000
oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`050000003oool000000?ooo`0000000`3oool04P000000oooo0?ooo`000000oooo0000003oool0
00000?ooo`000000oooo0000003oool000000?ooo`000000oooo000000<0oooo00@000000?ooo`3o
ool00000103oool2000000030?ooo`000000oooo00@0oooo00<000000?ooo`0000000P3oool01P00
0000oooo0?ooo`000000oooo00000?l0ooooM03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<?0?ooo`080000003o
ool0oooo0000003oool000000?ooo`0000020?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool0oooo0`000000103oool000000?ooo`0000030?ooo`040000003oool0oooo000000@0oooo
00D000000?ooo`000000oooo000000060?ooo`070000003oool000000?ooo`000000oooo00000002
0?ooo`80000000@0oooo0000003oool000000`3oool00`000000oooo0?ooo`0300000080oooo0P00
00000`3oool000000?ooo`030?ooo`0;0000003oool0oooo0000003oool000000?ooo`000000oooo
0000003oool00`00003o0?ooog80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool02P000000oooo0?ooo`00
0000oooo0000003oool000000?ooo`0000050?ooo`0;0000003oool000000?ooo`000000oooo0000
003oool000000?ooo`0000000`3oool00`000000oooo000000050?ooo`050000003oool000000?oo
o`000000103oool200000080oooo00d000000?ooo`000000oooo0000003oool000000?ooo`000000
oooo0000003oool0000000<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`80000000<0
oooo0000003oool00P3oool03`000000oooo0?ooo`3oool000000?ooo`000000oooo0000003oool0
00000?ooo`000000oooo0000003o0?ooog80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool00`000000oooo
0?ooo`0200000080oooo00<000000?ooo`3oool00P0000040?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo000000030?ooo`030000003oool0oooo008000000`3oool010000000
oooo0000000000040?ooo`030000003oool0oooo0080oooo0P0000000`3oool000000?ooo`020?oo
o`060000003oool0oooo0000003oool000000`3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool00`0000030?ooo`80000000P0oooo00000000000000000?ooo`000000oooo
00000080oooo00<000000?ooo`3oool0o`3oooma0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo00@00000
0?ooo`3oool000004`3oool00`000000oooo0000000C0?ooo`040000003oool0oooo000000/0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooog@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
3@3oool6000000<0oooo00<000000?ooo`3oool03@3oool00`000000oooo000000030?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool2000000`0oooo00@000000?ooo`000000
oooo1@00000F0?ooo`030000003oool0oooo0?l0ooooL@3oool40000o`H0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooh@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooomd0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooog@3oool50000o`H0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooh@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=^0?ooo`800000o`3oooma0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fh0oooo00<000000?ooo`00
0000o`3ooom`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<g00oooo00<000000?ooo`3oool0o`3ooom^0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<`l0oooo0`0000020?ooo`<0000000<0oooo0000000000001P0000060?ooo`80
00000`3oool200000080oooo1P0000030?ooo`H000001@3oool6000000030?ooo`000000000000D0
oooo0`0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo00<000000?ooo`3o
ool00P3oool3000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`<0000000<0oooo0000
000000000`3oool00`000000oooo0?ooo`3o0?ooof00oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c403oool00`00
0000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3oool01@00
0000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000
003oool0oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`3o0?ooof<0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c403oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool0oooo0P0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000050?ooo`040000003oool0oooo0?ooo`8000001@3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo00000006
0?ooo`050000003oool0oooo0?ooo`0000001`3oool2000000030?ooo`000000oooo0080oooo00<0
00000?ooo`0000000`3oool00`000000oooo0000003o0?ooofP0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c403o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`000000
00001P3oool00`000000oooo0?ooo`020?ooo`@000000P3oool010000000oooo0?ooo`0000050?oo
o`040000003oool00000000000L0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`050?ooo`040000003oool0oooo0?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000D0
oooo0P0000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0
000000<00000o`3ooomU0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3o
ool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool000000080oooo00<000000?ooo`3oool00`3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`030?ooo`06
0000003oool0oooo0000003oool000000P3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`0000000P3oool00`000000oooo0?ooo`3o0?ooof<0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c403o
ool00`000000oooo0?ooo`020?ooo`<000000P3oool200000080oooo0`0000050?ooo`8000000`3o
ool2000000<0oooo00@000000?ooo`3oool00000103oool200000080oooo0`0000040?ooo`800000
00<0oooo0000003oool00P0000080?ooo`030000003oool0oooo0080oooo0P0000020?ooo`800000
00<0oooo0000000000000`0000050?ooo`T0000000H0oooo00000000000000000?ooo`0000020?oo
o`800000o`3ooomV0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0H0?ooo`040000003oool0oooo000001h0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0o`3ooomX
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`d0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000
000J0?ooo`040000003oool0oooo000001/0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo0?l0ooooJ03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`T0
00001@3oool00`000000oooo0?ooo`0A0?ooo`80000000<0oooo0000000000001@3oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo1`00000O0?ooo`800000o`3ooomZ0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooogP3oool40000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooh@3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooomd0
oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooj03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooomd0oooo1@000?l60?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>i0?ooo`<00000o`3ooolU0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<kT0oooo0`00003o0?ooobD0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c_03oool00`000000
oooo0?ooo`3o0?ooob80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool400000080oooo0`0000000`3oool0
000000000009000000D0oooo0`0000020?ooo`<0000000<0oooo0000000000001P0000030?ooo`P0
0000103oool7000000040?ooo`0000000000000000<0oooo1@0000040?ooo`D0000000<0oooo0000
003oool00`0000000`3oool0000000000002000000<0oooo1@0000000`3oool000000?ooo`030000
00030?ooo`0000000000008000000P3oool300000080oooo0`0000030?ooo`H0000000<0oooo0000
000000000P0000001@3oool00000000000000000oooo00<000000`3oool4000000<0oooo0P000003
0?ooo`030000003oool0oooo00@0000000D0oooo00000000000000000?ooo`0200000?l0oooo5`3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<=0?ooo`D00000203oool2000000@0oooo0P0000000`3oool000000000
00020?ooo`80000000@0oooo0000003oool0oooo0P0000030?ooo`<0000000@0oooo000000000000
00000P3oool010000000oooo0000000000020?ooo`8000001@3oool2000000040?ooo`000000oooo
0?ooo`800000103oool200000080oooo0P0000000`3oool00000000000040?ooo`8000000P3oool2
00000080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool300000080oooo0P000000
103oool000000000003oool200000080oooo0P0000020?ooo`<000000P3oool400000080oooo1000
00000`3oool000000?ooo`0200000080oooo0P0000000`3oool00000000000020?ooo`80000000@0
oooo000000000000oooo0P0000040?ooo`030000003oool0oooo0080000000<0oooo000000000000
0`3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`<00000o`3ooolG0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`d0oooo1@0000080?ooo`800000103oool2000000030?ooo`00000000000080oooo
0P0000030?ooo`<000000`3oool2000000<0oooo0P0000040?ooo`8000000P3oool2000000D0oooo
0P0000030?ooo`<00000103oool200000080oooo0P0000000`3oool00000000000040?ooo`040000
003oool0oooo0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`80
00000P3oool3000000040?ooo`00000000000?ooo`8000000P3oool200000080oooo0P0000020?oo
o`D000000`3oool2000000@0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool20000
00040?ooo`00000000000?ooo`8000001P3oool3000000030?ooo`000000000000<0oooo0`000002
0?ooo`80000000<0oooo000000000000o`3ooolL0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo1@000008
0?ooo`800000103oool2000000030?ooo`00000000000080oooo0P000000103oool0000000000000
00050?ooo`8000000`3oool5000000030?ooo`00000000000080oooo0P0000050?ooo`80000000@0
oooo00000000000000001P3oool200000080oooo0P0000000`3oool00000000000060?ooo`@00000
0P3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`D000000`3oool2000000030?oo
o`00000000000080oooo0P0000020?ooo`D000000P3oool7000000@0oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool2000000040?ooo`00000000000?ooo`800000103oool3000000<0
oooo0P0000020?ooo`80000000@0oooo0000003oool0oooo0P0000000`3oool00000000000030000
0?l0oooo6@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`D00000203oool2000000@0oooo1@0000020?oo
o`80000000<0oooo0000000000000P3oool010000000oooo0?ooo`3oool2000000030?ooo`000000
00000080000000@0oooo000000000000oooo0P0000020?ooo`8000001@3oool2000000030?ooo`00
000000000080oooo00<000000?ooo`3oool00P3oool200000080oooo1@0000040?ooo`@00000103o
ool2000000030?ooo`00000000000080oooo0P0000020?ooo`@000000P3oool01@000000oooo0000
00000000oooo008000000P3oool200000080oooo100000020?ooo`<0000000<0oooo000000000000
0P000000103oool000000000003oool200000080oooo0P0000000`3oool00000000000020?ooo`80
000000<0oooo0000000000000`0000040?ooo`8000000P3oool010000000oooo0000000000020?oo
o`80000000@0oooo000000000000oooo0P000000103oool000000000003oool200000?l0oooo6@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<=0?ooo`D00000203oool2000000@0oooo0P000000103oool000000000
003oool300000080oooo100000040?ooo`@0000000@0oooo00000000000000000P3oool200000080
oooo0P0000040?ooo`<000000P3oool4000000<0oooo0`0000001@3oool00000000000000000oooo
00800000103oool2000000<0oooo00<000000?ooo`0000000P0000000`3oool00000000000020?oo
o`D000000P3oool7000000030?ooo`00000000000080oooo1@0000020?ooo`@0000000@0oooo0000
0000000000000P3oool;00000080oooo100000001@3oool00000000000000000oooo008000001@3o
ool;000000040?ooo`00000000000?ooo`8000000P3oool300000?l0oooo6P3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<G0?ooo`030000003oool0oooo008000000P3oool010000000oooo00000000000K0?ooo`80
00000P3oool2000001h0oooo0P0000020?ooo`8000002@3oool200000140oooo0P00000D0?ooo`80
00006`3oool2000000P0oooo0P00003o0?oooal0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5`3oool;000000D0
oooo0P00000C0?ooo`<0000000@0oooo00000000000000001@3oool2000000X0oooo0P00000<0?oo
o`D00000203oool300000100oooo0`00000E0?ooo`030000003oool0oooo00800000603oool00`00
0000oooo0?ooo`050?ooo`<00000o`3ooolO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooh@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooomh0oooo10000?l60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon40oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooM0?oo
o`D0003o0P3oool50000o`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon@0oooo1@000?l60?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c]03oool300000?l0oooo<@3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c]03oool2000000030?ooo`000000oooo
0?l0oooo;`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c]`3oool00`000000oooo0?ooo`3o0?ooobh0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo100000020?ooo`@0000000<0oooo0000
000000002@0000060?ooo`<000000`3oool3000000030?ooo`000000000000H000000`3oool80000
00@0oooo20000000103oool000000000000000030?ooo`030000003oool0000000<00000103oool2
000000070?ooo`00000000000000003oool000000?ooo`0300000080oooo100000030?ooo`<00000
0`3oool3000000<0oooo1`0000020?ooo`<000000P3oool4000000040?ooo`0000000000000000<0
oooo100000030?ooo`<000000`3oool010000000oooo0?ooo`3oool400000080oooo0`0000000`3o
ool000000000003o0?ooob40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<``0oooo1P0000090?ooo`800000103oool200000080oooo0P0000020?oo
o`80000000@0oooo0000003oool0oooo0P0000040?ooo`8000000P3oool010000000oooo00000000
00020?ooo`040000003oool0000000000080oooo0P0000050?ooo`80000000@0oooo0000003oool0
oooo0P0000040?ooo`8000000P3oool200000080oooo0P0000040?ooo`8000000`3oool200000080
oooo0P000000103oool000000000000000020?ooo`8000000P3oool2000000040?ooo`000000oooo
0?ooo`80000000<0oooo0000000000000P3oool010000000oooo0000000000020?ooo`040000003o
ool00000000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool200000080oooo
0P0000040?ooo`030000003oool0oooo0080000000<0oooo0000000000001@3oool2000000<0oooo
0P0000020?ooo`8000000P3oool300000?l0oooo8@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool6000000T0oooo0P0000040?ooo`800000
0P3oool200000080oooo0P0000030?ooo`<000000`3oool2000000@0oooo0P0000050?ooo`800000
0P3oool2000000D0oooo0P0000030?ooo`<00000103oool200000080oooo0P0000020?ooo`800000
103oool00`000000oooo0?ooo`020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
0`3oool200000080oooo1@0000040?ooo`8000001@3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000P3oool2000000H0oooo0`0000000`3oool00000
000000040?ooo`<000000`3oool2000000030?ooo`00000000000?l0oooo9`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool6000000T0oooo
0P0000040?ooo`8000000P3oool200000080oooo0P0000020?ooo`<00000103oool2000000@0oooo
1P0000000`3oool00000000000020?ooo`8000001@3oool200000080oooo0`0000050?ooo`800000
0P3oool200000080oooo0P0000080?ooo`<000000P3oool200000080oooo0P0000020?ooo`800000
0`3oool2000000050?ooo`00000000000000003oool0200000050?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000001@3oool300000080
oooo0P0000040?ooo`<000000`3oool2000000030?ooo`000000000000@00000o`3ooolS0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`H0
00002@3oool2000000@0oooo0P0000020?ooo`8000000P3oool2000000040?ooo`00000000000000
00D0oooo0P0000020?ooo`@000000P3oool2000000030?ooo`00000000000080oooo0P0000050?oo
o`80000000@0oooo00000000000000001P3oool200000080oooo0P0000020?ooo`8000001P3oool4
000000<0oooo0P0000020?ooo`8000000P3oool2000000<0oooo1@0000020?ooo`8000000P3oool4
00000080oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000000`3oool2
000000030?ooo`00000000000080oooo0P0000040?ooo`<000000`3oool2000000<0oooo0P000002
0?ooo`030000003oool0oooo0080000000<0oooo0000000000000P3oool200000?l0oooo8`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool6
000000T0oooo0P0000040?ooo`<0000000<0oooo0000000000000P3oool2000000030?ooo`000000
00000080oooo00<000000?ooo`3oool00P3oool2000000050?ooo`00000000000?ooo`0000000P3o
ool00`000000oooo0?ooo`0200000080oooo0P0000050?ooo`80000000<0oooo0000000000000P3o
ool00`000000oooo0?ooo`020?ooo`8000000P3oool3000000030?ooo`000000000000D0oooo1000
00040?ooo`8000000P3oool200000080oooo0`000000103oool000000000003oool200000080oooo
00<000000?ooo`0000000P3oool00`000000oooo0?ooo`02000000040?ooo`00000000000?ooo`80
00000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`<0000000<0oooo00000000
0000103oool200000080oooo00@000000?ooo`00000000000`3oool200000080oooo00<000000?oo
o`3oool00P0000020?ooo`040000003oool0oooo00000?l0oooo903oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool6000000T0oooo0P000004
0?ooo`80000000<0oooo0000000000000P3oool300000080oooo100000050?ooo`<000000`3oool2
000000<0oooo0P0000020?ooo`800000103oool300000080oooo100000030?ooo`<0000000D0oooo
00000000000000000?ooo`02000000D0oooo0`0000050?ooo`<0000000@0oooo0000000000000000
0P3oool2000000030?ooo`000000000000<0oooo100000020?ooo`800000103oool3000000030?oo
o`00000000000080000000@0oooo00000000000000000`3oool300000080oooo0`0000000`3oool0
0000000000060?ooo`P0000000D0oooo00000000000000000?ooo`03000000030?ooo`0000000000
00<0oooo0P00003o0?ooobD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<aL0oooo00@000000?ooo`3oool0oooo0P0000030?ooo`<000007P3oool2
00000080oooo0P00000O0?ooo`800000103oool00`000000oooo0?ooo`080?ooo`8000005`3oool2
000001h0oooo0P00000:0?ooo`800000o`3ooolZ0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<G0?ooo`040000003oool0oooo0?ooo`8000000`3o
ool3000000H0oooo0P00000F0?ooo`8000000P3oool2000000D0oooo0P00000:0?ooo`800000303o
ool2000000<0oooo0P00000:0?ooo`800000603oool010000000oooo0?ooo`3oool2000001X0oooo
00<000000?ooo`3oool0203oool200000?l0oooo:P3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5`3oool<000000H0oooo0P00000E0?ooo`<00000
00@0oooo00000000000000001@3oool2000000X0oooo0P00000=0?ooo`@0000000<0oooo0000003o
ool0203oool3000001`0oooo0P00000T0?ooo`<00000o`3ooolZ0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooi@3oool40000o`H0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonP0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooi03oool50000o`80
oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooon/0oooo1@000?l60?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<l40oooo0`00003o0?ooob/0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?20?ooo`<00000o`3ooolZ0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c``3oool200000?l0oooo:P3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<``0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000000`3oool0
0000000000030?ooo`D000002@3oool3000000D0oooo0`0000030?ooo`8000000P3oool2000000L0
oooo0P0000030?ooo`D000001`3oool200000080oooo0P0000030?ooo`800000203oool5000000D0
oooo0`0000050?ooo`<00000103oool200000080oooo0P0000040?ooo`<000000`3oool2000000<0
oooo0P0000070?ooo`D000000`3oool2000000@0oooo0P0000040?ooo`800000103oool3000000<0
oooo0P00003o0?oooaP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T0
00002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool2000000<0
oooo0P0000070?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080
oooo0P0000020?ooo`8000001`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080
oooo0P0000030?ooo`8000001`3oool2000000<0oooo0P0000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000000`3oool200000003
0?ooo`00000000000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool0
0000000000040?ooo`@000000`3oool2000000<0oooo0P0000000`3oool000000000003o0?oooa`0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0
oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000060?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`80
00001`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080oooo0P0000030?ooo`80
00001P3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000@0
oooo100000030?ooo`8000000P3oool2000000<0oooo0P00003o0?oooa/0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80
000000<0oooo0000000000001`3oool2000000H0oooo0P0000060?ooo`8000001P3oool200000080
oooo0P0000070?ooo`8000001`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000H0
oooo0P0000050?ooo`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`80
00000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000002`3oool200000003
0?ooo`000000000000@0oooo100000030?ooo`8000000P3oool200000?l0oooo803oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000090?ooo`800000103oool2000000<0
oooo0P0000000`3oool00000000000050?ooo`<000001`3oool2000000H0oooo1`0000000`3oool0
0000000000020?ooo`8000001`3oool2000000D0oooo0`0000070?ooo`8000000P3oool2000000<0
oooo0P00000=0?ooo`80000000<0oooo0000000000001@0000000`3oool00000000000060?ooo`80
00000`3oool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000T0
oooo0`0000020?ooo`8000000`3oool200000080oooo0P0000020?ooo`8000000P3oool700000?l0
oooo6`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000090?ooo`80
0000103oool2000000<0oooo0P0000000`3oool00000000000030?ooo`<000002@3oool2000000H0
oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool2000000L0oooo0P0000030?ooo`<0
00002@3oool200000080oooo0P0000030?ooo`800000303oool200000080oooo0P0000030?ooo`80
000000<0oooo0000000000001P3oool2000000<0oooo0P0000020?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P0000070?ooo`<00000103oool2000000<0oooo0P0000020?ooo`80
00000P3oool200000080oooo0P0000030?ooo`800000o`3ooolK0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c303oool9000000T0oooo0P0000040?ooo`8000000`3oool200000003
0?ooo`00000000000080oooo0P0000030?ooo`8000001P3oool2000000<0oooo0P0000000`3oool0
0000000000030?ooo`80000000<0oooo0000000000000P3oool2000000L0oooo0P0000020?ooo`80
00000`3oool2000000H0oooo0P0000020?ooo`8000000`3oool2000000P0oooo1@0000030?ooo`80
00000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80
00000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000001P3oool2000000<0
oooo0P0000000`3oool00000000000030?ooo`8000000P3oool200000080oooo0P0000020?ooo`80
00000`3oool200000?l0oooo6`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0
oooo2@0000090?ooo`800000103oool300000080oooo0P0000000`3oool00000000000020?ooo`80
00000`3oool2000000L0oooo0P0000020?ooo`8000000P3oool2000000030?ooo`00000000000080
oooo0P0000020?ooo`8000001`3oool200000080oooo0P0000030?ooo`8000001P3oool200000080
oooo0`0000020?ooo`8000001`3oool2000000P0oooo0P0000000`3oool00000000000030?ooo`80
00000P3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`80000000<0oooo00000000
00000P3oool300000080oooo0P0000060?ooo`8000000`3oool2000000030?ooo`00000000000080
oooo0P0000040?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000?l0
oooo703oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000090?ooo`80
0000103oool600000080oooo0P0000030?ooo`D000002@3oool4000000@0oooo0`0000030?ooo`80
00000P3oool2000000L0oooo0P0000030?ooo`D000001`3oool200000080oooo1P0000070?ooo`80
00001@3oool2000000<0oooo0`0000050?ooo`@0000000<0oooo0000000000000P0000020?ooo`80
0000103oool3000000<0oooo1P0000080?ooo`D0000000<0oooo0000000000000P0000000`3oool0
0000000000040?ooo`80000000<0oooo000000000000103oool300000?l0oooo7@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ah0oooo0P0000040?ooo`8000009`3oool200000080
oooo0P00000Y0?ooo`8000001@3oool200000140oooo0P00000T0?ooo`8000002`3oool200000?l0
oooo903oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ah0oooo0P0000040?ooo`80
00009`3oool200000080oooo0P00000Z0?ooo`8000000`3oool200000180oooo0P00000T0?ooo`80
00002`3oool200000?l0oooo8@3oool40000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool800000003
0?ooo`000000000000H0oooo0P00000O0?ooo`8000000P3oool2000000L0oooo0P00000?0?ooo`80
00004@3oool5000001P0oooo0P00000/0?ooo`800000o`3ooolT0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo[0?ooo`D0003o0P3oool50000o`H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`00003m000000040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2I
VIT609VIV@80<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@40<c<c0@3oool0
00030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 227},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.5"],

Cell["\<\
By putting a cell in a particular style, you specify a whole \
collection of properties for the cell, including for example how large and in \
what font text should be given. \
\>", "Text",
  CellTags->{"S1.3.5", "5.12"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " front end allows you to modify such properties, either for complete \
cells, or for specific material within cells. "
}], "Text",
  CellTags->{"S1.3.5", "5.13"}],

Cell[TextData[{
  "Even within a cell of a particular style, the ",
  StyleBox["Mathematica", "TI"],
  " front end allows a wide range of properties to be modified separately."
}], "MathCaption",
  CellTags->{"S1.3.5", "5.14"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000Jb000`400?l00000o`00003o00<0oooo
000000000000o`00003o000000T0000000020>GUiOl0<c<co`0c<c<903<c<`40000000000`3UiND0
VIVI09VIV@3o09VIVOl0VIVI1`2IVIT103<c<`40000000000`3UiND0VIVI09VIV@3o09VIVOl0VIVI
1`2IVIT103<c<`40000000000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT50>GUiOl0oooon@3oool30>GUi@@0VIVI0@0c<c<10000000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00
000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c
<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2I
VIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VI
V@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<:0?ooool00000ZP00000o0?ooo`D0003o1P3oool00`3UiND0VIVI09VI
V@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SH
f03o0=SHf:H0f=SH00<000000?ooo`3oool0@@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003H
f=P0f=SH0?l0f=SHYP3Hf=P00`000000oooo0?ooo`110?ooo`030000o`3oool0oooo00@0oooo00<0
iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`X0oooo00<0
00000=SHf03Hf=P0o`3Hf=RV0=SHf0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3o
ool00`000000f=SH0=SHf03o0=SHf:H0f=SH00<000000?ooo`3oool0@@3oool00`000?l0oooo0?oo
o`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<:0?ooo`030000003Hf=P0f=SH0?l0f=SHYP3Hf=P00`000000oooo0?ooo`110?ooo`030000o`3o
ool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2I
VIT203<c<`X0oooo00<000000=SHf03Hf=P0o`3Hf=RV0=SHf0030000003oool0oooo0440oooo00<0
003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0
VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SHf03o0=SHf:H0f=SH00<000000?ooo`3oool0@@3o
ool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003Hf=P0f=SH0?l0f=SHYP3Hf=P00`000000oooo0?oo
o`110?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<`X0oooo00<000000=SHf03Hf=P0o`3Hf=RV0=SHf0030000003o
ool0oooo0440oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00
000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SHf01?0=SHf0<000003@3H
f=P300000940f=SH0`00002_0=SHf0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3o
ool00`000000f=SH0=SHf01@0=SHf0030000003Hf=P0f=SH00d0f=SH00<000000=SHf03Hf=P0S`3H
f=P01@000000f=SH0=SHf03Hf=P000000:h0f=SH00<000000?ooo`3oool0@@3oool00`000?l0oooo
0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<:0?ooo`030000003Hf=P0f=SH0500f=SH00<000000=SHf03Hf=P03@3Hf=P00`000000f=SH
0=SHf02?0=SHf0050000003Hf=P0f=SH0=SHf0000000[P3Hf=P00`000000oooo0?ooo`110?ooo`03
0000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI
09VIV@2IVIT203<c<`X0oooo00<000000=SHf03Hf=P01@3Hf=P3000000<0f=SH0`0000040=SHf080
00000`3Hf=P200000080f=SH1P0000040=SHf08000000`3Hf=P2000000030=SHf000000000000080
000000<0f=SH0000000000000`3Hf=P3000000040=SHf000000000000=SHf080000000D0f=SH0000
003Hf=P0f=SH000000040=SHf08000001@3Hf=P010000000f=SH0000000000020=SHf0<000000P3H
f=P300000080f=SH00@000000=SHf000000000000`3Hf=P200000080f=SH0`0000020=SHf0030000
003Hf=P000000080000000<0f=SH0000000000000P3Hf=P3000000D0f=SH0`0000040=SHf0800000
00<0f=SH0000003Hf=P00P0000020=SHf0<0000000<0f=SH000000000000103Hf=P2000000030=SH
f00000000000008000001P3Hf=P2000000030=SHf0000000f=SH0080f=SH0`000000103Hf=P00000
0000000000020=SHf080000000<0f=SH0000000000000P000000103Hf=P000000000003Hf=P20000
0080f=SH0P0000060=SHf0<000000P3Hf=P3000000D0f=SH0`0000030=SHf080000000<0f=SH0000
003Hf=P00P0000020=SHf0<0000000@0f=SH000000000000f=SH0`0000020=SHf0<000000P3Hf=P3
000000@0f=SH0P0000000`3Hf=P0000000000002000000040=SHf000000000000=SHf080000000D0
f=SH000000000000f=SH0000002?0=SHf0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0
103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c
2P3oool00`000000f=SH0=SHf0060=SHf0030000003Hf=P0f=SH00<0f=SH00<000000=SHf03Hf=P0
0P3Hf=P01P000000f=SH0=SHf0000000f=SH00000080f=SH00@000000=SHf03Hf=P000000P3Hf=P0
0`000000f=SH0=SHf0020=SHf0060000003Hf=P0f=SH0000003Hf=P000000P3Hf=P010000000f=SH
0=SHf00000020=SHf0030000003Hf=P0f=SH00<0f=SH00H000000=SHf03Hf=P000000=SHf0000002
0=SHf0050000003Hf=P0f=SH0=SHf00000000`3Hf=P010000000f=SH0=SHf00000040=SHf0800000
0P3Hf=P010000000f=SH0=SHf00000020=SHf0060000003Hf=P0f=SH0=SHf0000000f=SH0P000002
0=SHf0030000003Hf=P000000080f=SH00@000000=SHf03Hf=P000000P3Hf=P01`000000f=SH0=SH
f03Hf=P000000=SHf00000000P3Hf=P00`000000f=SH000000020=SHf0030000003Hf=P0f=SH0080
f=SH00@000000=SHf03Hf=P000000P3Hf=P01P000000f=SH0=SHf0000000f=SH00000080f=SH00@0
00000=SHf03Hf=P000000P3Hf=P00`000000f=SH0=SHf0020=SHf0060000003Hf=P0f=SH0000003H
f=P000000P3Hf=P00`000000f=SH0=SHf0020=SHf0040000003Hf=P0f=SH000000D0f=SH00D00000
0=SHf03Hf=P0f=SH000000020=SHf0040000003Hf=P0f=SH00000080f=SH00@000000=SHf03Hf=P0
00000P3Hf=P010000000f=SH0=SHf00000020=SHf0030000003Hf=P0f=SH0080f=SH00D000000=SH
f03Hf=P0f=SH000000020=SHf0030000003Hf=P0f=SH00<0f=SH00L000000=SHf03Hf=P0f=SH0000
003Hf=P000000080f=SH00<000000=SHf00000000P3Hf=P010000000f=SH0=SHf00000020=SHf003
0000003Hf=P0000000H0f=SH00@000000=SHf03Hf=P000000`3Hf=P010000000f=SH0=SHf0000002
0=SHf0040000003Hf=P0f=SH00000080f=SH00<000000=SHf00000000P3Hf=P200000980f=SH00<0
00000?ooo`3oool0@@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c
<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003Hf=P0f=SH00L0f=SH00D0
00000=SHf03Hf=P0f=SH000000050=SHf0030000003Hf=P0f=SH0080f=SH00<000000=SHf03Hf=P0
0`3Hf=P010000000f=SH0=SHf00000040=SHf0030000003Hf=P0f=SH0080f=SH00@000000=SHf03H
f=P000000P3Hf=P010000000f=SH0=SHf00000050=SHf0060000003Hf=P0f=SH0000003Hf=P00000
0P3Hf=P01P000000f=SH0=SHf0000000f=SH00000080f=SH00<000000=SHf03Hf=P01@3Hf=P01@00
0000f=SH0=SHf03Hf=P000000080f=SH00@000000=SHf03Hf=P000000`3Hf=P00`000000f=SH0000
00030=SHf0030000003Hf=P0000000D0f=SH00@000000=SHf03Hf=P000000`3Hf=P00`000000f=SH
000000060=SHf08000001P3Hf=P200000080f=SH00H000000=SHf03Hf=P000000=SHf00000050=SH
f0040000003Hf=P0f=SH000000@0f=SH00@000000=SHf03Hf=P000000`3Hf=P2000000@0f=SH00@0
00000=SHf03Hf=P000001@3Hf=P01@000000f=SH0=SHf03Hf=P000000080f=SH00@000000=SHf03H
f=P000000P3Hf=P010000000f=SH0=SHf00000020=SHf0040000003Hf=P0f=SH000000L0f=SH00D0
00000=SHf03Hf=P0f=SH000000020=SHf0030000003Hf=P0f=SH00<0f=SH00L000000=SHf03Hf=P0
f=SH0000003Hf=P000000080f=SH00<000000=SHf00000001@3Hf=P00`000000f=SH000000030=SH
f0800000103Hf=P010000000f=SH0=SHf00000030=SHf0040000003Hf=P0f=SH00000080f=SH00@0
00000=SHf03Hf=P000000P3Hf=P00`000000f=SH000000030=SHf0030000003Hf=P0f=SH0900f=SH
00<000000?ooo`3oool0@@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI
0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003Hf=P0f=SH00L0f=SH
1@0000050=SHf0030000003Hf=P0f=SH0080f=SH100000020=SHf0040000003Hf=P0f=SH000000@0
f=SH00<000000=SHf03Hf=P00`3Hf=P300000080f=SH00@000000=SHf03Hf=P000001@3Hf=P01000
0000f=SH0=SHf00000020=SHf0<000000P3Hf=P00`000000f=SH000000020=SHf0@00000103Hf=P0
1@000000f=SH0=SHf03Hf=P000000080f=SH00@000000=SHf03Hf=P000000`3Hf=P00`000000f=SH
000000030=SHf0030000003Hf=P0000000<000000P3Hf=P010000000f=SH0=SHf00000030=SHf003
0000003Hf=P0000000<0000000<0f=SH0000000000001P3Hf=P2000000@0f=SH00H000000=SHf03H
f=P000000=SHf00000050=SHf0040000003Hf=P0f=SH000000D0f=SH0`0000000`3Hf=P000000000
00070=SHf0<000001@3Hf=P01@000000f=SH0=SHf03Hf=P0000000<0f=SH0`0000020=SHf0040000
003Hf=P0f=SH00000080f=SH00<000000=SHf03Hf=P0100000040=SHf0050000003Hf=P0f=SH0=SH
f00000000P3Hf=P00`000000f=SH0=SHf0030=SHf0050000003Hf=P0f=SH0=SHf00000000P3Hf=P3
000000030=SHf0000000f=SH00@0f=SH0P0000030=SHf0040000003Hf=P0f=SH000000<0f=SH00@0
00000=SHf03Hf=P000000`3Hf=P010000000f=SH0=SHf00000020=SHf0040000003Hf=P0f=SH0000
0080f=SH00<000000=SHf00000000`3Hf=P00`000000f=SH0=SHf02@0=SHf0030000003oool0oooo
0440oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000000004
0>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SHf0070=SHf0050000003Hf=P0f=SH
0=SHf00000001@3Hf=P01P000000f=SH0=SHf0000000f=SH00000080f=SH00@000000=SHf03Hf=P0
00000P3Hf=P00`000000f=SH0=SHf0020=SHf0060000003Hf=P0f=SH0000003Hf=P000000P3Hf=P0
10000000f=SH0=SHf00000020=SHf0030000003Hf=P0f=SH00<0f=SH00H000000=SHf03Hf=P00000
0=SHf00000020=SHf0030000003Hf=P0000000<0f=SH00<000000=SHf00000000P3Hf=P00`000000
f=SH0=SHf0020=SHf08000000P3Hf=P00`000000f=SH0=SHf002000000030=SHf0000000f=SH0080
f=SH00@000000=SHf000000000000P3Hf=P00`000000f=SH000000020=SHf0030000003Hf=P0f=SH
0080000000<0f=SH0000003Hf=P00P3Hf=P00`000000f=SH000000020=SHf0030000003Hf=P00000
0080f=SH00<000000=SHf03Hf=P00P3Hf=P010000000f=SH0=SHf00000020=SHf0060000003Hf=P0
f=SH0000003Hf=P000000P3Hf=P010000000f=SH0=SHf00000020=SHf0030000003Hf=P0f=SH0080
f=SH00H000000=SHf03Hf=P000000=SHf00000020=SHf0030000003Hf=P0f=SH0080f=SH00@00000
0=SHf03Hf=P000001@3Hf=P010000000f=SH0=SHf03Hf=P2000000050=SHf0000000f=SH0=SHf000
00000P3Hf=P010000000f=SH0=SHf00000020=SHf0040000003Hf=P0f=SH00000080f=SH00<00000
0=SHf03Hf=P00P3Hf=P01@000000f=SH0=SHf03Hf=P000000080f=SH0P0000040=SHf08000000P3H
f=P00`000000f=SH000000020=SHf0030000003Hf=P000000080f=SH00H000000=SHf03Hf=P00000
0=SHf00000020=SHf0040000003Hf=P0f=SH000000<0f=SH0P0000000`3Hf=P000000=SHf0020=SH
f0040000003Hf=P0f=SH00000080f=SH00@000000=SHf03Hf=P000000P3Hf=P00`000000f=SH0000
00020=SHf0800000TP3Hf=P00`000000oooo0?ooo`110?ooo`030000o`3oool0oooo00@0oooo00<0
iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`X0oooo00<0
00000=SHf03Hf=P0203Hf=P00`000000f=SH000000070=SHf08000000`3Hf=P2000000<0f=SH00@0
00000=SHf03Hf=P000001@3Hf=P2000000<0f=SH0P0000020=SHf0040000003Hf=P00000000000H0
f=SH0`0000030=SHf080000000D0f=SH00000000000000000=SHf003000000030=SHf00000000000
00@0f=SH0P0000000`3Hf=P00000000000020=SHf0050000003Hf=P000000000003Hf=P00`000000
103Hf=P000000000003Hf=P2000000<0f=SH0P0000020=SHf0030000003Hf=P0000000<0000000<0
f=SH0000000000000P3Hf=P2000000<0f=SH0`0000050=SHf0<0000000@0f=SH000000000000f=SH
0P0000020=SHf08000000`3Hf=P3000000H0f=SH0P0000030=SHf0<000001@3Hf=P2000000D0f=SH
0`0000000`3Hf=P000000=SHf002000000030=SHf000000000000080f=SH00D000000=SHf0000000
00000=SHf002000000@0f=SH0P0000060=SHf0<000000P3Hf=P010000000f=SH0000000000030=SH
f0040000003Hf=P00000000000<0f=SH0P0000030=SHf08000000`3Hf=P010000000f=SH00000000
00020=SHf0@0000000<0f=SH0000003Hf=P00P000000103Hf=P000000000000000020=SHf0800000
00H0f=SH000000000000f=SH0000003Hf=P2000000<0f=SH0P0000000`3Hf=P000000=SHf02A0=SH
f0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VI
V@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SHf0080=SH
f0030000003Hf=P000000140f=SH00@000000=SHf03Hf=P00000603Hf=P00`000000f=SH0=SHf00d
0=SHf0030000003Hf=P0f=SH0240f=SH00<000000=SHf03Hf=P06`3Hf=P00`000000f=SH0=SHf00X
0=SHf0030000003Hf=P0f=SH00h0f=SH00<000000=SHf03Hf=P08P3Hf=P00`000000f=SH0=SHf02@
0=SHf0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@02
09VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SHf009
0=SHf0030000003Hf=P0f=SH0100f=SH00@000000=SHf03Hf=P00000603Hf=P00`000000f=SH0=SH
f01H0=SHf0030000003Hf=P0f=SH01/0f=SH00<000000=SHf03Hf=P0:03Hf=P00`000000f=SH0=SH
f00>0=SHf0030000003Hf=P0f=SH0280f=SH00<000000=SHf03Hf=P0T03Hf=P00`000000oooo0?oo
o`110?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<`X0oooo00<000000=SHf03Hf=P02@3Hf=P00`000000f=SH0=SH
f00?0=SHf080000000<0f=SH0000000000005`3Hf=P2000003X0f=SH00<000000=SHf03Hf=P0703H
f=P2000001h0f=SH0P00000W0=SHf08000003`3Hf=P2000002<0f=SH0P00002B0=SHf0030000003o
ool0oooo0440oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00
000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SHf03o0=SHf:H0f=SH00<0
00000?ooo`3oool0@@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c
<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003Hf=P0f=SH0?l0f=SHYP3H
f=P00`000000oooo0?ooo`110?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2I
VIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`X0oooo00<000000=SHf03Hf=P0o`3H
f=RV0=SHf0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VI
V@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000f=SH0=SH
f03o0=SHf:H0f=SH00<000000?ooo`3oool0@@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003H
f=P0f=SH0?l0f=SHYP3Hf=P00`000000oooo0?ooo`110?ooo`030000o`3oool0oooo00@0oooo00<0
iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`X0oooo00<0
00000=SHf03Hf=P0o`3Hf=RV0=SHf0030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3o
ool00`000000f=SH0=SHf03o0=SHf:H0f=SH00<000000?ooo`3oool0@@3oool00`000?l0oooo0?oo
o`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<:0?ooo`030000003Hf=P0f=SH0?l0f=SHYP3Hf=P00`000000oooo0?ooo`110?ooo`030000o`3o
ool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2I
VIT203<c<`X0oooo00<000000=SHf03Hf=P0o`3Hf=RV0=SHf0030000003oool0oooo03h0oooo1000
0?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<:0?ooo`030000003Hf=P0f=SH0?l0f=SHYP3Hf=P00`000000oooo0?ooo`110?ooo`030000o`3o
ool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2I
VIT203<c<`X0ooooo`00002Z000003l0oooo1@000?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c
<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2I
VIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VI
V@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00
000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c
<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2I
VIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VI
V@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooc0?ooo`D0003o1P3o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooog0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<jl0oooo1@00003o0?oood<0oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c[P3o
ool2000000@0oooo00<000000?ooo`3oool0[`3oool2000008h0oooo00<0003o0?ooo`3oool0103o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<cFP3o
ool00`000000oooo0?ooo`1A0?ooo`800000103oool200000380oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`100?ooo`800000SP3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c=K0?ooo`030000003o
ool0oooo0580oooo1P00000c0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0@03o
ool2000008d0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00
000000040>GUi@2IVIT0VIVI09VIV@80<c<c3P3oool01@000000oooo0?ooo`3oool0000000<0oooo
0`0000000`3oool000000?ooo`03000000030?ooo`000000000000H0000000<0oooo000000000000
103oool2000000030?ooo`000000oooo00<0oooo00<000000?ooo`3oool00P0000020?ooo`800000
00<0oooo0000000000000P3oool00`000000oooo0?ooo`030?ooo`8000000`3oool200000080oooo
1P0000000`3oool000000?ooo`040?ooo`030000003oool000000080000000@0oooo000000000000
oooo0P0000020?ooo`<000000P3oool2000000H0oooo0P0000030?ooo`80000000<0oooo00000000
00000P0000000`3oool00000000000040?ooo`<000000`3oool2000000D0oooo100000020?ooo`80
00000P3oool2000000030?ooo`0000000000008000000`3oool6000000@0oooo0`0000080?ooo`@0
0000103oool4000000<0oooo100000000`3oool000000000000200000080oooo0P0000020?ooo`@0
00000`3oool00`000000oooo0?ooo`030?ooo`030000003oool00000008000000P3oool400000003
0?ooo`00000000000080000000<0oooo000000000000100000030?ooo`@0000000<0oooo00000000
00000P0000001@3oool00000000000000000oooo00<000000P3oool600000080oooo00<000000?oo
o`3oool00`3oool2000000030?ooo`00000000000080000000@0oooo000000000000oooo0P000000
0`3oool00000000000040?ooo`<00000103oool4000000040?ooo`000000000000000080oooo0`00
00030?ooo`<000000P3oool3000000<0oooo0`0000050?ooo`8000002@3oool3000000D0oooo1@00
00040?ooo`<000000`3oool3000000<0oooo100000020?ooo`D000001P3oool00`000000oooo0?oo
o`1B0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<`h0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?ooo`00
00020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`030?ooo`06
0000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool000000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`060000003oool0oooo
0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo
00L000000?ooo`3oool0oooo0000003oool000000080oooo00<000000?ooo`3oool00`3oool20000
0080oooo0P0000001`3oool00000000000000000oooo0000003oool00P0000040?ooo`030000003o
ool0oooo00H0oooo1@0000080?ooo`800000103oool200000080oooo0P0000030?ooo`8000000`3o
ool200000080oooo0P000000103oool000000000000000020?ooo`800000203oool200000080oooo
100000020?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`8000001@3oool200000003
0?ooo`00000000000080oooo0P000000103oool000000000003oool200000080oooo0P000000103o
ool000000?ooo`3oool2000000H0oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?oo
o`000000oooo00000080oooo0P0000050?ooo`<00000103oool800000080oooo0`0000030?ooo`<0
00000P3oool3000000<0oooo0`0000050?ooo`<00000203oool3000000@0oooo1`0000030?ooo`<0
00000`3oool3000000<0oooo100000020?ooo`H00000FP3oool00`000?l0oooo0?ooo`040?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`80
00000P3oool2000000@0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
00040?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo000000050?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000070?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000050?ooo`040000003oool0
oooo000000L0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000@0oooo00L000000?ooo`3oool0oooo0000003oool0000000P0oooo0P000002
0?ooo`8000000P3oool2000000<0oooo0P0000050?ooo`D000000P3oool3000000<0oooo00<00000
0?ooo`3oool01@3oool2000000<0oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P000002
0?ooo`8000000P3oool00`000000oooo0?ooo`03000000P0oooo0P0000020?ooo`@000000P3oool2
000000040?ooo`00000000000?ooo`8000000P3oool2000000D0oooo0P0000000`3oool000000000
00020?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`8000000`3oool3000000H0oooo
00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<00000
0?ooo`3oool0103oool3000000<0oooo0`0000020?ooo`@000000P3oool3000000<0oooo0`000002
0?ooo`<000000`3oool3000000@0oooo0`0000090?ooo`<000000`3oool300000080oooo0`000003
0?ooo`<000000`3oool300000080oooo0`0000080?ooo`800000F@3oool00`000?l0oooo0?ooo`04
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=
0?ooo`070000003oool000000?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
00<0oooo0`0000040?ooo`030000003oool0oooo00@000000`3oool01@000000oooo0?ooo`3oool0
000000D0oooo00<000000?ooo`3oool00P3oool400000080oooo00@000000?ooo`3oool000001`3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000`0000020?ooo`030000
003oool0oooo00@00000103oool00`000000oooo0?ooo`030?ooo`<000000P3oool010000000oooo
0?ooo`0000040?ooo`060000003oool0oooo0?ooo`000000oooo100000050?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P0000040?ooo`<000000P3oool2000000030?ooo`000000
000000`0oooo0P0000030?ooo`800000103oool200000080oooo0P0000030?ooo`8000000P3oool2
000000@0oooo0`0000090?ooo`8000000P3oool400000080oooo0P000000103oool000000000003o
ool200000080oooo0P0000050?ooo`80000000<0oooo0000000000000P3oool2000000040?ooo`00
000000000?ooo`8000000P3oool2000000040?ooo`0000000000000000T0oooo0`0000020?ooo`06
0000003oool0oooo0000003oool000000`3oool00`000000oooo0?ooo`040?ooo`<000000`3oool3
000000<0oooo0`0000020?ooo`<000000`3oool300000080oooo0`0000030?ooo`<00000103oool4
000000P0oooo0`0000030?ooo`<000000`3oool300000080oooo0`0000030?ooo`<000000P3oool3
000000P0oooo0P00001I0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT1
03<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<``0oooo0P0000001P3oool0000000000000
0000oooo000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000004
0?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`03
0000003oool0oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`0000000P3oool00`000000oooo0?ooo`02000000050?ooo`000000oooo0?ooo`00
0000103oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo000000020?ooo`030000003o
ool0oooo00<0oooo0P0000050?ooo`<000000`3oool2000000@0oooo0P0000030?ooo`80000000<0
oooo0000000000001@0000070?ooo`8000000`3oool2000000@0oooo0P0000020?ooo`8000000`3o
ool200000080oooo0P0000030?ooo`<000002P3oool200000080oooo100000020?ooo`80000000@0
oooo000000000000oooo0P0000020?ooo`8000001@3oool2000000030?ooo`00000000000080oooo
0P0000000`3oool000000000000300000080oooo0P0000000`3oool00000000000020?ooo`030000
003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo
00000080oooo0P0000060?ooo`<000000`3oool3000000<0oooo0`0000020?ooo`<000000`3oool3
00000080oooo0`0000030?ooo`<00000103oool2000000030?ooo`000000000000L0oooo0`000003
0?ooo`<000000`3oool300000080oooo0`0000030?ooo`<000000P3oool3000000H0oooo1000001I
0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103U
iND0VIVI09VIV@2IVIT203<c<``0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00D000000P3oool300000080oooo0P0000000`3oool000000?ooo`02000000H0oooo0P00
00040?ooo`<000000P3oool200000080oooo0P0000000`3oool0000000000003000000D0oooo0P00
00030?ooo`8000000`3oool010000000oooo0?ooo`0000060?ooo`<000000P3oool3000000<0oooo
0P0000020?ooo`050000003oool000000000003oool00P0000060?ooo`8000000`3oool200000080
oooo00@000000?ooo`00000000001@3oool010000000oooo0000000000030?ooo`8000001P3oool2
00000080oooo00@000000?ooo`3oool0oooo0P0000030?ooo`800000103oool2000000<0oooo0P00
00000`3oool00000000000030?ooo`8000001`3oool2000000<0oooo0P0000040?ooo`8000000P3o
ool2000000<0oooo0P0000020?ooo`8000000P3oool300000080oooo00<000000?ooo`3oool01P3o
ool500000080oooo100000020?ooo`8000000P3oool5000000@0oooo100000000`3oool000000000
0002000000050?ooo`00000000000000003oool00P0000000`3oool0000000000002000000030?oo
o`0000000000008000001`3oool200000080oooo00@000000?ooo`00000000000`3oool200000003
0?ooo`000000oooo00D0oooo0`0000030?ooo`<000000`3oool300000080oooo0`0000030?ooo`<0
00000P3oool3000000<0oooo0`0000030?ooo`<0000000<0oooo0000000000001`3oool3000000<0
oooo0`0000030?ooo`<000000P3oool3000000<0oooo0`0000020?ooo`<000001@3oool4000005X0
oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GU
i@2IVIT0VIVI09VIV@80<c<c2`3oool200000080oooo0P0000030?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo0000000H0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool03P3oool010000000oooo0?ooo`0000070?ooo`050000003oool0oooo0?ooo`000000:03o
ool00`000000oooo0?ooo`0<0?ooo`8000000P3oool200000080oooo0P0000020?ooo`<0000000@0
oooo000000000000oooo0P0000020?ooo`<000000P3oool01@000000oooo0?ooo`3oool0000000P0
oooo0P0000040?ooo`8000000P3oool200000080oooo100000020?ooo`8000000P3oool200000080
oooo0P0000020?ooo`800000203oool2000000/0oooo0P0000050?ooo`8000001@3oool2000000l0
oooo0P00000K0?ooo`030000003oool0oooo00D0oooo0`0000030?ooo`<000000`3oool300000080
oooo0`0000030?ooo`<000000P3oool3000000<0oooo0`0000020?ooo`<000000P3oool2000000L0
oooo0`0000030?ooo`<000000`3oool300000080oooo0`0000030?ooo`<000000P3oool3000000@0
oooo0`00001K0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`40
00000000103UiND0VIVI09VIV@2IVIT203<c<`/0oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0=@3oool010000000oooo0?ooo`00000;
0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0303oool2000000<0oooo10000004
0?ooo`030000003oool00000008000000P3oool5000000040?ooo`000000oooo0?ooo`<00000203o
ool5000000<0oooo100000050?ooo`030000003oool00000008000000P3oool400000080oooo1000
00080?ooo`<000002P3oool3000000@0oooo0`0000060?ooo`<000003P3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo00D0oooo0`0000030?ooo`<000000`3oool300000080oooo0`00
00030?ooo`<000000P3oool3000000<0oooo0`0000020?ooo`<000000`3oool2000000H0oooo0`00
00030?ooo`<000000P3oool400000080oooo0`0000030?ooo`<000000P3oool3000000@0oooo0P00
001L0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000
103UiND0VIVI09VIV@2IVIT203<c<`X0oooo0`000000103oool000000000000000020?ooo`<00000
00<0oooo0000003oool00`3oool2000000D0oooo00<000000?ooo`3oool0;P3oool2000000030?oo
o`000000000000X0oooo0P00000W0?ooo`8000003P3oool2000002L0oooo0P00000F0?ooo`800000
F03oool2000000L0oooo0`0000030?ooo`<000000`3oool300000080oooo2@0000020?ooo`T00000
0P3oool2000000@0oooo0P0000060?ooo`<00000103oool7000000<0oooo2@0000020?ooo`<00000
103oool6000005P0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40<c<c
0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<cW03oool2000002L0oooo0P00000G0?ooo`030000
003oool0oooo05h0oooo1P000000103oool000000000000000030?ooo`<000000P3oool300000080
oooo0`0000030?ooo`<000000P3oool3000000<0oooo0P0000050?ooo`800000103oool6000000@0
oooo100000040?ooo`<000000P3oool300000080oooo1P0000040?ooo`@00000F03oool00`000?l0
oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0
VIVI0P0c<c>K0?ooo`<000009`3oool200000080oooo00<000000?ooo`3oool0M@3oool300000380
oooo0`00000I0?ooo`<00000H@3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080
VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c>L0?ooo`800000:03oool3000007P0
oooo1P00000_0?ooo`H000005P3oool300000640oooo00<0003o0?ooo`3oool0103oool00`3UiND0
VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooom30?ooo`D0
0000<03oool5000001L0oooo0P00001Q0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2I
VIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0
oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@40
<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00@0
oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooom03oool40000o`H0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`030>GUi@2IVIT0VIVI0080
VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo1@000?l60?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<100000000
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`40
00000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40
<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080
VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2I
VIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<00`3UiND0
VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`03
0>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI
0@0c<c<10000000000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI0@0c<c<10000000000<0iNGU
09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI0@0c<c<100000000o`3UiNGo0>GUi@/0iNGU0@0000000?l0
ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 107},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.5"],

Cell[TextData[{
  "It is worth realizing that in doing different kinds of things with ",
  StyleBox["Mathematica", "TI"],
  " notebooks, you are using different parts of the ",
  StyleBox["Mathematica", "TI"],
  " system. Operations such as opening and closing groups of cells, doing \
animations and playing sounds use only a small part of the ",
  StyleBox["Mathematica", "TI"],
  " front end, and these operations are supported by a widely available \
program known as ",
  StyleBox["MathReader", "TI"],
  ".  "
}], "Text",
  CellTags->{"S1.3.5", "5.15"}],

Cell[TextData[{
  "To be able to create and edit notebooks, you need more of the ",
  StyleBox["Mathematica", "TI"],
  " front end. And finally, to be able to actually do computations within a \
",
  StyleBox["Mathematica", "TI"],
  " notebook, you need a full ",
  StyleBox["Mathematica", "TI"],
  " system, with both the front end and the kernel. "
}], "Text",
  CellTags->{"S1.3.5", "5.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MathReader", "TI"],
              " "
            }]], Cell[TextData[{
              "reading ",
              StyleBox["Mathematica", "TI"],
              " notebooks "
            }]]},
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " front end "
            }]], Cell[TextData[{
              "creating and editing ",
              StyleBox["Mathematica", "TI"],
              " notebooks "
            }]]},
          {Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " kernel "
            }]], Cell["doing computations in notebooks "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.5"],

Cell["\<\
Programs required for different kinds of operations with notebooks. \
\
\>", "Caption",
  CellTags->"S1.3.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3.6 Active Elements in Notebooks", "Subsection",
  CellTags->{"S1.3.6", "6.1"}],

Cell[TextData[{
  "One of the most powerful features of ",
  StyleBox["Mathematica", "TI"],
  " notebooks is that their actions can be programmed. Thus, for example, you \
can set up a button in a ",
  StyleBox["Mathematica", "TI"],
  " notebook which causes various operations to be performed whenever you \
click it.  "
}], "Text",
  CellTags->{"S1.3.6", "6.2"}],

Cell["Here is a notebook that contains a button. ", "MathCaption",
  CellTags->{"S1.3.6", "6.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000<R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool000000000003o00000?l000002@0000000080iNGUo`0c<c?o03<c<`T0
<c<c0@00000000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@40<c<c0@00000000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT709VIV@40<c<c0@00000000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT7
09VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@@0VIVI0@0c<c<1
0000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT1
03<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@02
09VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0
VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU
09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
0`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103U
iND0VIVI09VIV@2IVIT203<c<l80oooo<@00003n0?ooo`D0003o1`3oool00`3UiND0VIVI09VIV@02
09VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c``3oool_05EEE@030000003oool0
oooo0?l0oooo0@3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<1
0000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?30?ooobh0f=SH00<0EEEE0000003oool0o`3oool2
0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103U
iND0VIVI09VIV@2IVIT203<c<l<0oooo;P3Hf=P00`1EEED000000?ooo`3o0?ooo`80oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI
09VIV@80<c<cI03oool3000005`0oooo;P3Hf=P00`1EEED000000?ooo`3o0?ooo`80oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI
09VIV@80<c<cH`3oool01@000000oooo0?ooo`3oool0000005/0oooo8@3Hf=P2000000@0f=SH0P00
00050=SHf00305EEE@000000oooo0?l0oooo0P3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2I
VIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c=S0?ooo`050000003o
ool0oooo0?ooo`000000F`3ooolQ0=SHf0030000003Hf=P0f=SH00@0f=SH00<000000=SHf03Hf=P0
0`3Hf=P00`1EEED000000?ooo`3o0?ooo`80oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI
09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool400000080oooo
1P0000000`3oool00000000000020?ooo`<0000000<0oooo000000000000103oool00`000000oooo
00000002000000040?ooo`00000000000?ooo`8000001P3oool3000000@0oooo0P000000103oool0
00000?ooo`0000020?ooo`030000003oool0oooo00<000000P3oool3000000030?ooo`0000000000
00@0oooo00<000000?ooo`3oool00`0000060?ooo`<000000`3oool2000000<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo00000002000000040?ooo`00000000000?ooo`8000001P3oool2
000000@0oooo0P0000000`3oool0000000000002000000040?ooo`000000000000000080oooo0P00
00020?ooo`<0000000D0oooo000000000000oooo000000050?ooo`80000000@0oooo000000000000
oooo0P000000103oool000000?ooo`0000020?ooo`8000000`3oool00`000000oooo0?ooo`030?oo
o`80f=SH1@0000040=SHf080000000<0f=SH0000000000000`3Hf=P3000000<0f=SH0`0000050=SH
f0030000003Hf=P0f=SH00@0f=SH00<000000=SHf03Hf=P00`3Hf=P00`1EEED000000?ooo`3o0?oo
o`80oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@0000000004
0>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool200000080oooo0P0000020?ooo`060000003oool0oooo
0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`060000003oool0oooo0000003oool000001@3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo000000D0
oooo00<000000?ooo`3oool00P0000001`3oool000000?ooo`3oool000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000080?ooo`<0f=SH00<000000=SHf03Hf=P00P0000020=SHf0030000003H
f=P0f=SH008000000`3Hf=P01`000000f=SH0=SHf03Hf=P000000=SHf00000000`3Hf=P00`000000
f=SH0=SHf0020=SHf0030000003Hf=P0f=SH00@0f=SH00<000000=SHf03Hf=P00`3Hf=P00`1EEED0
00000?ooo`3o0?ooo`80oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@40
<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`0000001@3oool00`000000oooo000000050?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000070?ooo`050000003oool0
oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3o
ool000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`030?ooo`8000000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0000000L0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`060000003oool0oooo
0000003oool000001@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool00`000000
oooo000000020?ooo`030000003oool0oooo00T0oooo0`3Hf=P01@000000f=SH0=SHf03Hf=P00000
0080f=SH00D000000=SHf03Hf=P0f=SH000000030=SHf0030000003Hf=P0f=SH0080f=SH00<00000
0=SHf03Hf=P01`3Hf=P00`000000f=SH0=SHf0040=SHf0030000003Hf=P0f=SH00<0f=SH00<0EEEE
0000003oool0o`3oool20?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT1
03<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`T0oooo00<000000?ooo`3oool01P3oool0
1P000000oooo0?ooo`000000oooo000000D0oooo0P0000060?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo00000003000000@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000030?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool4000000030?ooo`000000
oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000<00000103o
ool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`@000000P3oool01P000000oooo0?ooo`000000oooo000000D0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`<0000000@0oooo0000003oool0oooo100000080?ooo`<0f=SH
00D000000=SHf03Hf=P0f=SH000000030=SHf0@000000`3Hf=P00`000000f=SH0=SHf0020=SHf0H0
0000103Hf=P00`000000f=SH0=SHf0040=SHf0030000003Hf=P0f=SH00<0f=SH00<0EEEE0000003o
ool0o@3oool01@000?l0oooo0000o`3oool0003o00L0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c
<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`T0oooo00<000000?ooo`3oool01P3oool01P00
0000oooo0?ooo`000000oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000050?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo
0080oooo0P0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000P3oool01P000000oooo0?ooo`000000oooo000000D0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo0P0000020?ooo`80000000D0oooo0000
003oool0oooo000000020?ooo`060000003oool0oooo0000003oool000001@3oool00`000000oooo
0?ooo`02000000070?ooo`000000oooo0?ooo`000000oooo000000020?ooo`040000003oool0oooo
000000P0oooo0`3Hf=P01@000000f=SH0=SHf03Hf=P0000000H0f=SH00D000000=SHf03Hf=P0f=SH
000000050=SHf0050000003Hf=P0f=SH0=SHf0000000103Hf=P00`000000f=SH0=SHf0040=SHf003
0000003Hf=P0f=SH00<0f=SH00<0EEEE0000003oool0o@3oool01@000?l0oooo0000o`3oool0003o
00L0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c
<`T0oooo00<000000?ooo`3oool01P3oool010000000oooo0000000000020?ooo`8000000`3oool0
10000000oooo0000000000030?ooo`<000000P3oool3000000<0oooo0P0000050?ooo`040000003o
ool0000000000080oooo0P0000000`3oool000000000000600000080oooo0`0000020?ooo`040000
003oool00000000000@0oooo0`0000020?ooo`<000001P3oool400000080oooo0P000000103oool0
00000000000000030?ooo`<000000P3oool3000000<0oooo0P0000060?ooo`8000000P3oool20000
00060?ooo`00000000000?ooo`000000oooo0`000000103oool000000000003oool200000080oooo
00D000000?ooo`00000000000?ooo`03000000D0oooo0P000000103oool000000?ooo`3oool20000
00040?ooo`000000000000000080oooo0P0000030?ooo`030000003oool0oooo00<0oooo0`3Hf=P0
1@000000f=SH0=SHf03Hf=P000000080f=SH100000030=SHf0D000000`3Hf=P3000000D0f=SH00<0
00000=SHf03Hf=P0103Hf=P00`000000f=SH0=SHf0030=SHf00305EEE@000000oooo0?d0oooo0`00
0?l00`3oool0003o0?ooo`060?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<:0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
2P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000303oool00`000000
oooo0?ooo`090?ooo`040000003oool0oooo00000140oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000:P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool30=SHf0030000003Hf=P0
f=SH008000002P3Hf=P00`000000f=SH0=SHf00<0=SHf0030000003Hf=P0f=SH00@0f=SH00<00000
0=SHf03Hf=P00`3Hf=P00`1EEED000000?ooo`3m0?ooo`050000o`3oool0003o0?ooo`000?l01`3o
ool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c2P3o
ool200000080oooo0P0000020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0<P3o
ool00`000000oooo0?ooo`0C0?ooo`80f=SH1@00000;0=SHf0030000003Hf=P0f=SH00`0f=SH0P00
00040=SHf08000001@3Hf=P00`1EEED000000?ooo`3n0?ooo`040000o`3oool0oooo0000o`L0oooo
00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIT203<c<`/0oooo
0`0000000`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool0103oool2000000X0oooo
0P00000;0?ooo`800000@03oool2000003<0oooo0P00000E0?ooobh0f=SH00<0EEEE0000003oool0
o`3oool20?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`400000
0000103UiND0VIVI09VIV@2IVIT203<c<l<0oooo;P3Hf=P00`1EEED000000?ooo`3n0?ooo`@0003o
1`3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c
lP3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI
09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob0?ooo`D0003o
1`3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`4000000000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c0@00000000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0@0c<c<10000000000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT103<c<`400000
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@40<c<c
0@00000000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI
0@0c<c<10000000000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o00000?h0000000<0iNGU09VIV@2IVIT0
0P2IVIT103<c<`4000000000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<00`3UiND0VIVI
09VIV@0209VIV@40<c<c0@00000000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@40<c<c0@00
000000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@40<c<c0@00000000030>GUi@2IVIT0VIVI
0?l0VIVIo`2IVIT709VIV@40<c<c0@00000000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@40
iNGU0@0000000?l0iNGUo`3UiND;0>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 50},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["\<\
Clicking the button in this case causes the current date to be \
displayed.\
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000CR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool000000000003o00000?l00000200000010?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
lP3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c00oooo0P00002T0?ooo`800000o`3ooolN0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<_0?ooo`8000009@3oool200000180oooo0P00000C0?ooo`8000006`3oool2
000001/0oooo0P00000L0?ooo`800000o`3ooolM0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<_0?ooo`800000103o
ool6000000<0oooo0`0000050?ooo`<000001@3oool4000000D0oooo0P0000090?ooo`<000001P3o
ool2000000X0oooo100000050?ooo`8000002@3oool6000000<0oooo100000050?ooo`8000002`3o
ool4000000<0oooo100000050?ooo`8000002P3oool4000000@0oooo100000050?ooo`800000o`3o
oolM0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<_0?ooo`8000001P3oool2000000L0oooo0P0000060?ooo`800000
0`3oool200000080oooo0P00000A0?ooo`800000403oool200000080oooo0P00000A0?ooo`800000
103oool200000080oooo0P00000B0?ooo`8000000`3oool200000080oooo0P00000?0?ooo`800000
0P3oool200000080oooo0P0000020?ooo`800000103oool200000?l0oooo7@3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c;P3oool2000000L0oooo0P0000080?ooo`8000001P3oool2000000H0oooo0P00000B0?ooo`80
00004`3oool200000140oooo0P0000040?ooo`8000000P3oool200000180oooo0P0000030?ooo`80
00000P3oool2000001<0oooo0P0000060?ooo`8000001@3oool200000?l0oooo703oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c;`3oool2000000H0oooo0P0000050?ooo`D000000`3oool500000080oooo0P0000020?oo
o`8000003`3oool5000000l0oooo0P0000020?ooo`8000004@3oool2000000@0oooo0P0000020?oo
o`8000003`3oool600000080oooo0P0000020?ooo`8000003`3oool200000080oooo0P0000060?oo
o`800000103oool200000?l0oooo7@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c;`3oool2000000H0oooo0P000004
0?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool5000000l0oooo0P000002
0?ooo`8000003`3oool500000180oooo0P0000040?ooo`8000000P3oool2000000l0oooo0P000000
0`3oool00000000000030?ooo`8000000P3oool2000000l0oooo1@0000050?ooo`<000001@3oool2
00000?l0oooo7@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c;`3oool2000000@0oooo100000040?ooo`8000000P3o
ool200000080oooo0P0000020?ooo`8000000P3oool200000180oooo0P0000020?ooo`8000003`3o
ool2000001<0oooo100000040?ooo`8000000P3oool200000100oooo100000030?ooo`8000000P3o
ool2000000l0oooo0P00000:0?ooo`800000103oool200000?l0oooo7@3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
;`3oool2000000D0oooo0`0000040?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
0P3oool200000180oooo0P0000020?ooo`8000003`3oool2000001@0oooo0`0000040?ooo`800000
0P3oool200000140oooo0`0000030?ooo`8000000P3oool2000000l0oooo0P0000060?ooo`800000
0P3oool2000000@0oooo0P00003o0?oooa`0oooo0P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<03oool2000000D0oooo0P0000050?ooo`@0
0000103oool4000000<0oooo1P00000?0?ooo`@00000403oool600000140oooo0P0000050?ooo`@0
00004`3oool2000000@0oooo1000000@0?ooo`H000000`3oool4000000@0oooo0P00003o0?oooa`0
oooo00<0003o0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooool`3oool010000?l0oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob0?ooo`050000o`3o
ool0oooo0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooool@3oool60000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?30?oooc400000o@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?40?ooobl0EEEE00<000000?ooo`3oool0o`3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<ca03oool^0=SHf00305EEE@000000oooo0?l0oooo0@3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<ca03o
ool^0=SHf00305EEE@000000oooo0?l0oooo0@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cI@3oool3000005`0oooo
;P3Hf=P00`1EEED000000?ooo`3o0?ooo`40oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<f@0oooo00D000000?ooo`3o
ool0oooo0000001K0?ooob40f=SH0P0000040=SHf08000001@3Hf=P00`1EEED000000?ooo`3o0?oo
o`40oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<f@0oooo00D000000?ooo`3oool0oooo0000001K0?ooob40f=SH00<0
00000=SHf03Hf=P0103Hf=P00`000000f=SH0=SHf0030=SHf00305EEE@000000oooo0?l0oooo0@3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c303oool400000080oooo1P0000000`3oool00000000000020?ooo`<00000
00<0oooo000000000000103oool00`000000oooo00000002000000040?ooo`00000000000?ooo`80
00001P3oool3000000@0oooo0P000000103oool000000?ooo`0000020?ooo`030000003oool0oooo
00<000000P3oool3000000030?ooo`000000000000@0oooo00<000000?ooo`3oool00`0000060?oo
o`<000000`3oool2000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo000000020000
00040?ooo`00000000000?ooo`8000001P3oool2000000@0oooo0P0000000`3oool0000000000002
000000040?ooo`000000000000000080oooo0P0000020?ooo`<0000000D0oooo000000000000oooo
000000050?ooo`80000000@0oooo000000000000oooo0P000000103oool000000?ooo`0000020?oo
o`8000000`3oool00`000000oooo0?ooo`030?ooo`80f=SH1@0000040=SHf080000000<0f=SH0000
000000000`3Hf=P3000000<0f=SH0`0000050=SHf0030000003Hf=P0f=SH00@0f=SH00<000000=SH
f03Hf=P00`3Hf=P00`1EEED000000?ooo`3o0?ooo`40oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`/0oooo0P000002
0?ooo`8000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo000000020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000030?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool01P000000oooo0?ooo`00
0000oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool000000080
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo
00H000000?ooo`3oool000000?ooo`0000050?ooo`030000003oool0oooo0080000000L0oooo0000
003oool0oooo0000003oool000000080oooo00@000000?ooo`3oool00000203oool30=SHf0030000
003Hf=P0f=SH008000000P3Hf=P00`000000f=SH0=SHf002000000<0f=SH00L000000=SHf03Hf=P0
f=SH0000003Hf=P0000000<0f=SH00<000000=SHf03Hf=P00P3Hf=P00`000000f=SH0=SHf0040=SH
f0030000003Hf=P0f=SH00<0f=SH00<0EEEE0000003oool0o`3oool10?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<;
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0000
00050?ooo`030000003oool0000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0000000L0oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0oooo0000
003oool000000P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0
oooo0P0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00<0oooo00H000000?ooo`3oool000000?ooo`0000050?ooo`070000003oool0oooo0?oo
o`000000oooo000000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool02@3oool3
0=SHf0050000003Hf=P0f=SH0=SHf00000000P3Hf=P01@000000f=SH0=SHf03Hf=P0000000<0f=SH
00<000000=SHf03Hf=P00P3Hf=P00`000000f=SH0=SHf0070=SHf0030000003Hf=P0f=SH00@0f=SH
00<000000=SHf03Hf=P00`3Hf=P00`1EEED000000?ooo`3o0?ooo`40oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`X0
oooo00<000000?ooo`3oool01P3oool01P000000oooo0?ooo`000000oooo000000D0oooo0P000006
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo00000003000000@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`060000003oool0oooo0000003oool000000P3oool01000
0000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00000P3oool4000000030?ooo`000000oooo00@0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0000000<00000103oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`@000000P3oool01P000000oooo0?oo
o`000000oooo000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`<0000000@0oooo0000
003oool0oooo100000080?ooo`<0f=SH00D000000=SHf03Hf=P0f=SH000000030=SHf0@000000`3H
f=P00`000000f=SH0=SHf0020=SHf0H00000103Hf=P00`000000f=SH0=SHf0040=SHf0030000003H
f=P0f=SH00<0f=SH00<0EEEE0000003oool0o03oool01@000?l0oooo0000o`3oool0003o00L0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:0?ooo`03
0000003oool0oooo00H0oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`060000003oool0
oooo0000003oool000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`020?ooo`8000000P3oool010000000oooo0?ooo`0000020?oo
o`030000003oool000000080oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`000005
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000020?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`80
00000P3oool2000000050?ooo`000000oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000
oooo000000D0oooo00<000000?ooo`3oool00P0000001`3oool000000?ooo`3oool000000?ooo`00
00000P3oool010000000oooo0?ooo`0000080?ooo`<0f=SH00D000000=SHf03Hf=P0f=SH00000006
0=SHf0050000003Hf=P0f=SH0=SHf00000001@3Hf=P01@000000f=SH0=SHf03Hf=P0000000@0f=SH
00<000000=SHf03Hf=P0103Hf=P00`000000f=SH0=SHf0030=SHf00305EEE@000000oooo0?`0oooo
00D0003o0?ooo`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool00`000000oooo0?ooo`060?ooo`040000003oool00000
00000080oooo0P0000030?ooo`040000003oool00000000000<0oooo0`0000020?ooo`<000000`3o
ool2000000D0oooo00@000000?ooo`00000000000P3oool2000000030?ooo`000000000000H00000
0P3oool300000080oooo00@000000?ooo`0000000000103oool300000080oooo0`0000060?ooo`@0
00000P3oool2000000040?ooo`0000000000000000<0oooo0`0000020?ooo`<000000`3oool20000
00H0oooo0P0000020?ooo`80000000H0oooo000000000000oooo0000003oool3000000040?ooo`00
000000000?ooo`8000000P3oool01@000000oooo000000000000oooo00<000001@3oool200000004
0?ooo`000000oooo0?ooo`80000000@0oooo00000000000000000P3oool2000000<0oooo00<00000
0?ooo`3oool00`3oool30=SHf0050000003Hf=P0f=SH0=SHf00000000P3Hf=P4000000<0f=SH1@00
00030=SHf0<000001@3Hf=P00`000000f=SH0=SHf0040=SHf0030000003Hf=P0f=SH00<0f=SH00<0
EEEE0000003oool0o03oool30000o`030?ooo`000?l0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<;0?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?oo
o`000000303oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo00000140oooo00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000:P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303o
ool30=SHf0030000003Hf=P0f=SH008000002P3Hf=P00`000000f=SH0=SHf00<0=SHf0030000003H
f=P0f=SH00@0f=SH00<000000=SHf03Hf=P00`3Hf=P00`1EEED000000?ooo`3l0?ooo`050000o`3o
ool0003o0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<`/0oooo0P0000020?ooo`8000000P3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0o0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool04`3oool20=SHf0D000002`3Hf=P00`000000
f=SH0=SHf00<0=SHf0800000103Hf=P2000000D0f=SH00<0EEEE0000003oool0o@3oool010000?l0
oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c303oool3000000030?ooo`000000oooo008000000P3oool00`000000oooo0?ooo`04
0?ooo`8000002P3oool2000000/0oooo0P0000100?ooo`800000<`3oool2000001D0oooo;P3Hf=P0
0`1EEED000000?ooo`3o0?ooo`40oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<l@0oooo;P3Hf=P00`1EEED000000?oo
o`3m0?ooo`@0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<o<0oooo00<000000?ooo`3oool0o`3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob0?ooo`D0
003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0
VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI
1P2IVIT10>GUi@40<c<c0@3oool00?l0iNGUo`3UiND;0>GUi@40oooo003o0?ooool0oooo303oool0
0001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 78},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell[TextData[{
  "Later in this book, we will discuss how you can set up buttons and other \
similar objects in ",
  StyleBox["Mathematica", "TI"],
  " notebooks. But here suffice it to say that whenever a cell is indicated \
as ",
  StyleBox["active", "TI"],
  ", typically by the presence of a stylized \[OpenCurlyDoubleQuote]A\
\[CloseCurlyDoubleQuote] in its cell bracket, clicking on active elements \
within the cell will cause actions that have been programmed for these \
elements to be performed.  "
}], "Text",
  CellTags->{"S1.3.6", "6.5"}],

Cell[TextData[{
  "It is common to set up ",
  StyleBox["palettes", "TI"],
  " which consist of arrays of buttons. Sometimes such palettes appear as \
cells within a notebook. But more often, a special kind of separate notebook \
window is used, which can conveniently be placed on the side of your computer \
screen and used in conjunction with any other notebook.  "
}], "Text",
  CellTags->{"S1.3.6", "6.6"}],

Cell["\<\
Palettes consisting of arrays of buttons are often placed in \
separate notebooks. \
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.7"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001G0000DR000`400?l00000o`00003oE`3oool0
05H000000@3oool000030>k^kP000000<c<c0580<c<c0@0000010?ooo`0000<0k^k^09VIV@2IVIT0
D@2IVIT103<c<`4000000@3oool000030>k^kP2IVIT0VIVI0540VIVI0@0c<c<100000040oooo0000
0`3^k^h0VIVI09VIV@1A09VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVIC03^k^h4
09VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=9000000030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`1EEED0
EEEE00d0EEEE00<0oooo05EEE@1EEED02P1EEED00`3oool0EEEE05EEE@0:05EEE@030?ooo`1EEED0
EEEE00`0EEEE00<0oooo05EEE@1EEED0301EEED00`000000k^k^09VIV@0309VIV@40<c<c0@000001
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0
gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0
gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0
gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000
k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0
gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0
gMgM00@0gMgM0`0000050=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT1
03<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd0
0`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd0
1@000000gMgM0=gMg@3MgMd0000000@0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd00`000000gMgM0=gM
g@030=gMg@060000003MgMd0gMgM05EEE@000000k^k^102IVIT103<c<`4000000@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@03
05EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd00`000000gMgM0=gMg@030=gMg@06
0000003MgMd0gMgM0=gMg@1EEED0oooo103MgMd00`000000gMgM0=gMg@030=gMg@060000003MgMd0
gMgM05EEE@000000k^k^102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c
00<0oooo0=gMg@3MgMd0303MgMd01@1EEED0oooo0=gMg@3MgMd0000000D0gMgM00D000000=gMg@3M
gMd0EEEE0?ooo`050=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd00`00
0000gMgM0=gMg@030=gMg@060000003MgMd0gMgM0=gMg@1EEED0oooo103MgMd00`000000gMgM0=gM
g@030=gMg@060000003MgMd0gMgM05EEE@000000k^k^102IVIT103<c<`4000000@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd00`000000gMgM0=gMg@030=gMg@03
05EEE@3oool0gMgM0080gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@0305EEE@3oool0gMgM
00<0gMgM00<000000=gMg@000000103MgMd00`1EEED0oooo0=gMg@020=gMg@030000003MgMd0gMgM
00<0gMgM00H000000=gMg@3MgMd0gMgM05EEE@3oool40=gMg@030000003MgMd0gMgM00<0gMgM00H0
00000=gMg@3MgMd0EEEE0000003^k^h409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<00`3oool0gMgM0=gMg@060=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3M
gMd00P3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd00`00
0000gMgM000000040=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd01P00
0000gMgM0=gMg@3MgMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM0=gM
g@1EEED000000>k^kP@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`03
0?ooo`3MgMd0gMgM0080gMgM1@0000050=gMg@0305EEE@3oool0gMgM0080gMgM00D000000=gMg@3M
gMd0gMgM000000030=gMg@0305EEE@3oool0gMgM0080gMgM00D000000=gMg@3MgMd0gMgM00000003
0=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM0=gMg@3M
gMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM0=gMg@1EEED000000>k^
kP@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM
00`0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd00`000000gMgM000000040=gMg@0305EEE@3oool0gMgM
0080gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@0305EEE@3oool0gMgM0080gMgM00<00000
0=gMg@3MgMd00`3MgMd01P000000gMgM0=gMg@3MgMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd0
0`3MgMd01P000000gMgM0=gMg@1EEED000000>k^kP@0VIVI0@0c<c<100000040oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd00`00
0000gMgM000000040=gMg@0305EEE@3oool0gMgM0080gMgM00D000000=gMg@3MgMd0gMgM00000003
0=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM0=gMg@3M
gMd0EEEE0?ooo`@0gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM0=gMg@1EEED000000>k^
kP@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM
00`0gMgM00<0EEEE0?ooo`3MgMd0103MgMd00`000000gMgM0=gMg@030=gMg@0505EEE@3oool0gMgM
0=gMg@0000001@3MgMd01@000000gMgM0=gMg@1EEED0oooo00<0gMgM00<000000=gMg@3MgMd00`3M
gMd01P000000gMgM0=gMg@3MgMd0EEEE0?ooo`D0gMgM00D000000=gMg@3MgMd0gMgM000000030=gM
g@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gM
g@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd01P000000gMgM0=gMg@3MgMd0
EEEE0?ooo`H0gMgM0`0000040=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3M
gMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303M
gMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c
<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3M
gMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102I
VIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cB03oool00`000000k^k^09VI
V@0309VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0EEEE05EE
E@0=05EEE@030?ooo`1EEED0EEEE00X0EEEE00<0oooo05EEE@1EEED02P1EEED00`3oool0EEEE05EE
E@0<05EEE@030?ooo`1EEED0EEEE00`0EEEE00<000000>k^kP2IVIT00`2IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gM
g@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gM
g@0<0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gM
g@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^
kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gM
g@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gM
g@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gM
g@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gM
g@0<0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd00`000000gMgM0=gM
g@040=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gM
g@0<0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd00`000000gMgM0=gM
g@040=gMg@0305EEE@3oool0gMgM0080gMgM1@0000030=gMg@0305EEE@3oool0gMgM00<0gMgM1@00
00040=gMg@0305EEE@3oool0gMgM00H0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED000000>k^
kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0103oool0gMgM0=gM
g@3MgMd3000000040=gMg@0000000000000000@0gMgM00@0EEEE0?ooo`3MgMd0gMgM1P0000030=gM
g@0305EEE@3oool0gMgM00H0gMgM00H000000=gMg@3MgMd0gMgM05EEE@3oool40=gMg@030000003M
gMd0gMgM00H0gMgM00@0EEEE0?ooo`3MgMd0gMgM1`0000040=gMg@0305EEE@000000k^k^00@0VIVI
0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM
00<0EEEE0?ooo`3MgMd0103MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM00@0gMgM
0P0000040=gMg@0305EEE@3oool0gMgM00@0gMgM0P0000060=gMg@0305EEE@3oool0gMgM00L0gMgM
0P0000030=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VI
V@2IVIT203<c<`040?ooo`3MgMd0gMgM0=gMg@<0000000@0gMgM0000000000000000103MgMd0101E
EED0oooo0=gMg@3MgMd6000000<0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd2000000H0gMgM00<0EEEE
0?ooo`3MgMd01P3MgMd2000000@0gMgM00@0EEEE0?ooo`3MgMd0gMgM1`0000040=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3M
gMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0103MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@3o
ool0gMgM00@0gMgM0P0000040=gMg@0305EEE@3oool0gMgM00@0gMgM0P0000060=gMg@0305EEE@3o
ool0gMgM00H0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@00
00010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3o
ool0gMgM00D0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0oooo0=gMg@060=gMg@060000003M
gMd0gMgM0=gMg@1EEED0oooo103MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@050=gMg@030000003MgMd0gMgM0080
gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0
gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0
VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0
gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`00
00@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0
gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<cB03oool00`000000k^k^09VIV@0309VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<00`3oool0EEEE05EEE@0=05EEE@030?ooo`1EEED0EEEE00X0EEEE00<0oooo05EEE@1E
EED02P1EEED00`3oool0EEEE05EEE@0<05EEE@030?ooo`1EEED0EEEE00`0EEEE00<000000>k^kP2I
VIT00`2IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3M
gMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3M
gMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3M
gMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^
k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3M
gMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3M
gMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3M
gMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<00`3oool0gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<000000=gMg@3M
gMd00P3MgMd00`1EEED0oooo0=gMg@040=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3M
gMd00P3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM00<0EEEE0?ooo`3MgMd01P3MgMd00`00
0000gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@3MgMd00P3MgMd00`00
0000gMgM0=gMg@020=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00<0gMgM00@000000=gMg@3MgMd000001@3MgMd0
0`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00<0gMgM00<000000=gMg@000000103MgMd0
0`1EEED0oooo0=gMg@070=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0?ooo`3MgMd0203MgMd0
1`000000gMgM0=gMg@3MgMd0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0103MgMd2000000H0gMgM00<0EEEE0?ooo`3MgMd0
0P3MgMd5000000<0gMgM00<0EEEE0?ooo`3MgMd0103MgMd00`000000gMgM0=gMg@030=gMg@0405EE
E@3oool0gMgM0=gMg@P000000`3MgMd00`1EEED0oooo0=gMg@030=gMg@L000000P3MgMd00`1EEED0
00000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0
gMgM0=gMg@040=gMg@8000001P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00<0
gMgM00<000000=gMg@000000103MgMd00`1EEED0oooo0=gMg@070=gMg@030000003MgMd0gMgM0080
gMgM00<0EEEE0?ooo`3MgMd0203MgMd01`000000gMgM0=gMg@3MgMd0EEEE0000003^k^h0102IVIT1
03<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd00`3MgMd0
10000000gMgM0=gMg@0000050=gMg@0305EEE@3oool0gMgM00@0gMgM00<000000=gMg@3MgMd00`3M
gMd00`1EEED0oooo0=gMg@020=gMg@050000003MgMd0gMgM0=gMg@0000000`3MgMd00`1EEED0oooo
0=gMg@060=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd00`000000gMgM
0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0000003^k^h0102IVIT103<c<`400000
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd00P3MgMd00`000000gMgM
0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo
0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED00000
0>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM
0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo
0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`400000
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo
0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo
0=gMg@0<0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VI
V@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo
0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED00000
0>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM
0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo
0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`400000
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cB03oool00`000000k^k^09VIV@0309VIV@40<c<c
0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0EEEE05EEE@0=05EEE@030?oo
o`1EEED0EEEE00X0EEEE00<0oooo05EEE@1EEED02P1EEED00`3oool0EEEE05EEE@0<05EEE@030?oo
o`1EEED0EEEE00`0EEEE00<000000>k^kP2IVIT00`2IVIT103<c<`4000000@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EE
E@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EE
E@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?oo
o`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EE
E@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c
0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EE
E@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EE
E@3oool0gMgM00`0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EE
E@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EE
E@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?oo
o`3MgMd0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EE
E@3oool0gMgM00`0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c
0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<01@3oool0gMgM0=gMg@3MgMd0000000@0
gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0oooo0=gMg@030=gMg@@000000`3MgMd00`1EEED0
oooo0=gMg@020=gMg@D000000`3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c00<0oooo0=gMg@3MgMd00P3MgMd010000000gMgM0=gMg@0000060=gMg@0305EEE@3oool0gMgM
0080gMgM00<000000=gMg@0000001@3MgMd00`1EEED0oooo0=gMg@030=gMg@030000003MgMd00000
00@0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd3000000040=gMg@0000000000000000<0gMgM00<0EEEE
0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@030=gMg@030000003MgMd0000000H0gMgM00<0EEEE
0?ooo`3MgMd00P3MgMd00`000000gMgM000000050=gMg@0305EEE@3oool0gMgM00<0gMgM00<00000
0=gMg@000000103MgMd01@1EEED0oooo0=gMg@3MgMd0000000<0gMgM0P0000020=gMg@050000003M
gMd0gMgM05EEE@3oool03@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0
k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@030=gMg@030000003MgMd0000000H0gMgM
00<0EEEE0?ooo`3MgMd00P3MgMd00`000000gMgM00000002000000<0gMgM00<0EEEE0?ooo`3MgMd0
0`3MgMd00`000000gMgM000000040=gMg@0505EEE@3oool0gMgM0=gMg@0000000P3MgMd2000000<0
gMgM00D000000=gMg@3MgMd0EEEE0?ooo`0=0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<10000
0040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00@0gMgM00<000000=gM
g@0000001@3MgMd00`1EEED0oooo0=gMg@020=gMg@050000003MgMd000000=gMg@0000000`3MgMd0
0`1EEED0oooo0=gMg@030=gMg@030000003MgMd0000000@0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd3
000000040=gMg@0000000000000000<0gMgM00<0EEEE0?ooo`3MgMd0103MgMd2000000H0gMgM00<0
EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0
oooo0=gMg@3MgMd00P3MgMd6000000@0gMgM00<0EEEE0?ooo`3MgMd00`3MgMd3000000@0gMgM00<0
EEEE0?ooo`3MgMd00P3MgMd4000000@0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo0=gM
g@030=gMg@040000003MgMd0gMgM000000D0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`400000
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0oooo
0=gMg@0:0=gMg@0305EEE@3oool0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED0oooo
0=gMg@030=gMg@040000003MgMd0gMgM000000D0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`40
00000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0303MgMd00`1EEED0
oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00@0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0
oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00@0gMgM0P0000060=gMg@0305EEE@000000k^k^00@0
VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00`0
gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0?ooo`3MgMd0303MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`00
00@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0<0=gMg@0305EEE@3oool0gMgM00X0
gMgM00<0EEEE0?ooo`3MgMd02P3MgMd00`1EEED0oooo0=gMg@0<0=gMg@0305EEE@3oool0gMgM00`0
gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<cB03oool00`000000k^k^09VIV@0309VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0
VIVIB`0c<c<00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0
VIVIB`0c<c<00`3^k^h0VIVI09VIV@0209VIV@40<c<c0@0000010?ooo`0000<0k^k^09VIV@2IVIT0
D@2IVIT103<c<`4000000@3oool000030>k^kP2IVIT0VIVI0540VIVI0@0c<c<100000040oooo0000
0`3^k^h0VIVI09VIV@1A09VIV@40<c<c0@0000010?ooo`00E@3^k^h100000040oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{87, 82},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["\<\
In the simplest cases, the buttons in palettes serve essentially \
like additional keys on your keyboard. Thus, when you press a button, the \
character or object shown in that button is inserted into your notebook just \
as if you had typed it. \
\>", "Text",
  CellTags->{"S1.3.6", "6.8"}],

Cell["\<\
Here is a palette of Greek letters with buttons that act like \
additional keys on your keyboard. \
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.9"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001b0000Tb000`400?l00000o`00003o00<0oooo
03<c<`0c<c<0K`0c<c<000030?ooo`3^k^h0k^k^06l0<c<c00000`3oool0k^k^09VIV@1]09VIV@80
<c<c00000`3oool0k^k^09VIV@1]09VIV@80<c<c00000`3oool0k^k^09VIV@1]09VIV@80<c<c0000
0`3oool0k^k^09VIV@0209VIVFL0k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c
<f@0000000<0k^k^09VIV@2IVIT00P2IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`03
0=gMg@1EEED0EEEE00l0EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A05EEE@03
0=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd000000>k^kP0409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1@3MgMd3000000<0gMgM0`0000030=gMg@0305EE
E@3MgMd0oooo00D0gMgM2@0000030=gMg@0305EEE@3MgMd0oooo00L0gMgM1P0000040=gMg@0305EE
E@3MgMd0oooo00L0gMgM1@0000050=gMg@0305EEE@3MgMd0oooo00L0gMgM0`0000000`3MgMd00000
0000000200000080gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd00`3MgMd00`000000gMgM0=gMg@020=gMg@0305EE
E@3MgMd0oooo00D0gMgM00<000000=gMg@3MgMd01@3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gM
g@3oool02@3MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3MgMd0oooo00T0gMgM00<000000=gM
g@3MgMd01@3MgMd00`1EEED0gMgM0?ooo`090=gMg@030000003MgMd0000000D0gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM00<000000=gM
g@3MgMd00`3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00D0gMgM00<000000=gM
g@3MgMd01@3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool01`3MgMd6000000@0gMgM00<0
EEEE0=gMg@3oool01`3MgMd4000000H0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM0=gM
g@02000000@0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<`L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo00L0gMgM
00D000000=gMg@3MgMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo00H0gMgM00@000000=gMg@3M
gMd000000`3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool01P3MgMd01@000000gMgM0=gM
g@000000gMgM00800000103MgMd00`1EEED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM00<0gMgM
00P000000=gMg@3MgMd0gMgM05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI
0080VIVI0P0c<c<70=gMg@050000003MgMd0gMgM0=gMg@0000001@3MgMd00`1EEED0gMgM0?ooo`07
0=gMg@D000001@3MgMd00`1EEED0gMgM0?ooo`060=gMg@040000003MgMd0gMgM000000<0gMgM00L0
00000=gMg@3MgMd0gMgM05EEE@3MgMd0oooo00H0gMgM00@000000=gMg@3MgMd000000P3MgMd00`00
0000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00L0gMgM00<000000=gMg@3MgMd0103MgMd01`00
0000gMgM0=gMg@1EEED0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT2
03<c<`L0gMgM00@000000=gMg@3MgMd000001P3MgMd00`1EEED0gMgM0?ooo`070=gMg@050000003M
gMd0gMgM0=gMg@0000001@3MgMd00`1EEED0gMgM0?ooo`070=gMg@H00000103MgMd00`1EEED0gMgM
0?ooo`060=gMg@040000003MgMd0gMgM00000080gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0
gMgM0?ooo`070=gMg@030000003MgMd0gMgM00@0gMgM00L000000=gMg@3MgMd0EEEE0=gMg@000000
k^k^00@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<80=gMg@030000003MgMd00000
00H0gMgM00<0EEEE0=gMg@3oool01@3MgMd00`000000gMgM0=gMg@050=gMg@070000003MgMd0gMgM
0=gMg@1EEED0gMgM0?ooo`090=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE0=gMg@3oool02@3M
gMd00`000000gMgM0=gMg@050=gMg@0305EEE@3MgMd0oooo00P0gMgM00@000000=gMg@3MgMd0gMgM
0P0000030=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<80=gMg@8000001`3MgMd00`1EEED0gMgM0?ooo`050=gMg@T000000`3MgMd00`1EEED0gMgM
0?ooo`070=gMg@H00000103MgMd00`1EEED0gMgM0?ooo`070=gMg@D000001@3MgMd00`1EEED0gMgM
0?ooo`090=gMg@<000001@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c2@3MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4P3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gMg@3oool0oooo0140oooo
00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gMg@000000k^k^00@0VIVI
0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c
<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3MgMd0EEEE05EEE@0?05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0
k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`P0
gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<80=gMg@030000003MgMd0gMgM00H0
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0
k^k^09VIV@0209VIV@80<c<c1`3MgMd4000000H0gMgM00<0EEEE0=gMg@3oool01P3MgMd200000080
gMgM0P0000050=gMg@0305EEE@3MgMd0oooo00H0gMgM100000070=gMg@0305EEE@3MgMd0oooo00D0
gMgM2@0000030=gMg@0305EEE@3MgMd0oooo00T0gMgM0`0000050=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@060000003MgMd0gMgM0000
003MgMd000001@3MgMd00`1EEED0gMgM0?ooo`050=gMg@030000003MgMd0gMgM008000000P3MgMd0
0`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3MgMd0
0`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd0
0`1EEED0gMgM0?ooo`080=gMg@040000003MgMd0gMgM0=gMg@8000000`3MgMd0101EEED0gMgM0000
003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1P3MgMd01P000000gMgM0=gM
g@000000gMgM000000D0gMgM00<0EEEE0=gMg@3oool01@3MgMd01@000000gMgM0=gMg@3MgMd00000
00<0gMgM00L000000=gMg@3MgMd0gMgM05EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3M
gMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3M
gMd00`1EEED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM00<0gMgM00P000000=gMg@3MgMd0gMgM
05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@06
0000003MgMd0gMgM0000003MgMd000001@3MgMd00`1EEED0gMgM0?ooo`050=gMg@050000003MgMd0
gMgM0=gMg@0000000`3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool0203MgMd00`000000
gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gM
g@0305EEE@3MgMd0oooo00L0gMgM0P0000030=gMg@030000003MgMd000000080gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`L0gMgM00<000000=gM
g@0000000P3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00H0gMgM00@000000=gM
g@3MgMd000000`3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool0203MgMd00`000000gMgM
0=gMg@060=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gMg@03
05EEE@3MgMd0oooo00L0gMgM1P000000203MgMd000000=gMg@3MgMd0EEEE0=gMg@000000k^k^102I
VIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`L0gMgM00<000000=gMg@0000000P3MgMd0
0`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd0103MgMd0
1`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool0203MgMd01@000000gMgM0=gMg@3MgMd0000000@0
gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo00L0
gMgM0P0000030=gMg@030000003MgMd000000080gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c
<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM0P0000020=gMg@040000003MgMd000000000
00<0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM
0080gMgM00<0EEEE0=gMg@3oool0203MgMd01@000000gMgM0=gMg@3MgMd0000000@0gMgM00<0EEEE
0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo00L0gMgM00<00000
0=gMg@3MgMd00`3MgMd020000000gMgM0=gMg@3MgMd0EEEE0=gMg@000000k^k^102IVIT203<c<`00
00<0oooo0>k^kP2IVIT00P2IVIT203<c<`X0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00H0gMgM1`0000040=gMg@0305EEE@3MgMd0oooo00P0gMgM
0P0000070=gMg@0305EEE@3MgMd0oooo00P0gMgM1@0000040=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<:0=gMg@030000003MgMd0gMgM00@0gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00T0gMgM
00<000000=gMg@3MgMd01@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<:0=gMg@030000003MgMd0gMgM00@0gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=T000000030>k^kP2IVIT0VIVI0080VIVI
0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c
<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3MgMd0EEEE05EEE@0?05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0
k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`080=gMg@030000003MgMd0gMgM00H0
gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00H0
gMgM00<000000=gMg@3MgMd00`3MgMd2000000<0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c
<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0
gMgM0?ooo`080=gMg@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000
gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<70=gM
g@@000001P3MgMd00`1EEED0gMgM0?ooo`090=gMg@8000001P3MgMd00`1EEED0gMgM0?ooo`070=gM
g@@000001P3MgMd00`1EEED0gMgM0?ooo`070=gMg@@000001P3MgMd00`1EEED0gMgM0?ooo`080=gM
g@040000003MgMd0gMgM000000D0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@03
0=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd00P0000040=gMg@0305EEE@3MgMd0
oooo00H0gMgM00H000000=gMg@3MgMd000000=gMg@0000050=gMg@0305EEE@3MgMd0oooo00H0gMgM
00H000000=gMg@3MgMd000000=gMg@0000050=gMg@0305EEE@3MgMd0oooo00T0gMgM0P0000060=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gM
g@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`080=gM
g@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@000002
0=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd01P000000gMgM0=gMg@00
0000gMgM000000D0gMgM00<0EEEE0=gMg@3oool02P3MgMd00`000000gMgM0=gMg@040=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@030000
003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`080=gMg@030000
003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@0000020=gMg@03
0000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@0000020=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool02P3MgMd00`000000gMgM0=gMg@040=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gM
g@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`080=gM
g@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@000002
0=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@00
00020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool02@3MgMd00`000000gMgM0000
00050=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c
<c<70=gMg@050000003MgMd0gMgM0=gMg@0000001@3MgMd00`1EEED0gMgM0?ooo`090=gMg@030000
003MgMd0gMgM00D0gMgM00<0EEEE0=gMg@3oool01`3MgMd01@000000gMgM0000003MgMd0000000D0
gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM000000020=gMg@030000003MgMd0gMgM0080
gMgM00<0EEEE0=gMg@3oool02@3MgMd010000000gMgM0=gMg@0000040=gMg@0405EEE@3MgMd00000
0>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<80=gMg@H000000`3MgMd00`1E
EED0gMgM0?ooo`070=gMg@H00000103MgMd00`1EEED0gMgM0?ooo`080=gMg@<000001P3MgMd00`1E
EED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM008000001@3MgMd00`1EEED0gMgM0?ooo`070=gM
g@800000103MgMd200000080gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0:0=gM
g@030000003MgMd0gMgM00@0gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool02P3MgMd00`000000gMgM0=gMg@040=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo00X0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4P3oool00`3MgMd0oooo0?ooo`0A0?oo
o`030=gMg@3oool0oooo0140oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?oo
o`030=gMg@000000k^k^00@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@03
0000003^k^h0VIVI00<0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3MgMd0EEEE
05EEE@0?05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo
0=gMg@0A05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0000003^k^h0102IVIT203<c<`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000
003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c
<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000
003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1@3MgMd00`000000gMgM0=gM
g@090=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool01`3MgMd4000000H0gMgM00<0
EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00P0gMgM00@0
EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM00<0
00000=gMg@3MgMd0203MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00L0gMgM00D0
00000=gMg@3MgMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
1P3MgMd00`000000gMgM0=gMg@080=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@@000000P3MgMd00`000000gMgM0=gMg@020=gMg@0305EE
E@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0gMgM0?ooo`080=gMg@<00000
1P3MgMd00`1EEED0gMgM0?ooo`050=gMg@030000003MgMd0gMgM00<0gMgM0P0000040=gMg@0305EE
E@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd00`0000050=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@040000003MgMd0gMgM0=gMg@80
00001@3MgMd00`1EEED0gMgM0?ooo`080=gMg@8000001`3MgMd00`1EEED0gMgM0?ooo`060=gMg@80
00002@3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM0080gMgM00<000000=gMg@3M
gMd00`3MgMd00`1EEED0gMgM0?ooo`070=gMg@8000000`3MgMd00`000000gMgM0=gMg@020=gMg@04
05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@03
0000003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0gMgM0?ooo`080=gMg@80
00001`3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00P0gMgM00<0EEEE0=gMg@3o
ool01`3MgMd01@000000gMgM0=gMg@3MgMd0000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`00
0000gMgM0=gMg@030=gMg@080000003MgMd0gMgM0=gMg@1EEED0gMgM0000003^k^h409VIV@80<c<c
00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3MgMd01@000000gMgM0=gMg@3MgMd0000000D0gMgM
00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo00H0gMgM
00<000000=gMg@3MgMd0203MgMd00`1EEED0gMgM0?ooo`080=gMg@040000003MgMd0gMgM000000D0
gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@030=gMg@080000003MgMd0gMgM0=gM
g@1EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3MgMd0
1@000000gMgM0=gMg@3MgMd0000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd01@000000gMgM0=gM
g@3MgMd0000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd2000000P0gMgM00<0EEEE0=gMg@3oool0
203MgMd010000000gMgM0=gMg@0000050=gMg@0305EEE@3MgMd0oooo00L0gMgM00<000000=gMg@3M
gMd00`3MgMd020000000gMgM0=gMg@3MgMd0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@02
0=gMg@0305EEE@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@03
0=gMg@0305EEE@3MgMd0oooo00T0gMgM0`0000050=gMg@0305EEE@3MgMd0oooo00P0gMgM00@00000
0=gMg@3MgMd000001@3MgMd00`1EEED0gMgM0?ooo`080=gMg@050000003MgMd0gMgM0=gMg@000000
103MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c
1`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool0
1@3MgMd00`000000gMgM0=gMg@040=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool0
203MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00H0gMgM200000030=gMg@0305EE
E@3MgMd0oooo00T0gMgM0`0000050=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
203MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
4@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c
4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00T0gMgM100000040=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<C0=gMg@030?oo
o`3MgMd0gMgM0140gMgM00<0oooo0=gMg@3MgMd04@3MgMd00`3oool0gMgM0=gMg@0A0=gMg@030?oo
o`3MgMd0gMgM0140gMgM00<000000>k^kP2IVIT00`2IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<a80oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gMg@3o
ool0oooo0140oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd000000>k^kP0409VIV@80<c<c0000
0`3oool0k^k^09VIV@0209VIV@80<c<c00<0gMgM05EEE@1EEED03`1EEED00`3MgMd0oooo0=gMg@0A
05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A
05EEE@030=gMg@000000k^k^00@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo00X0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3MgMd4000000H0gMgM00<0EEEE0=gM
g@3oool02P3MgMd00`000000gMgM0=gMg@040=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gM
g@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<50=gMg@800000103MgMd00`000000gMgM0=gMg@030=gM
g@0305EEE@3MgMd0oooo00/0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c2@3MgMd2000000H0gMgM00<0EEEE0=gM
g@3oool01P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0=gM
g@3oool01`3MgMd3000000L0gMgM00<0EEEE0=gMg@3oool01@3MgMd2000000@0gMgM0P0000040=gM
g@0305EEE@3MgMd0oooo00L0gMgM0P0000040=gMg@8000000P3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1P3MgMd3000000P0gMgM00<0EEEE0=gM
g@3oool01P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0=gM
g@3oool01P3MgMd010000000gMgM0=gMg@3MgMd2000000D0gMgM00<0EEEE0=gMg@3oool01P3MgMd0
1@000000gMgM0=gMg@3MgMd0000000H0gMgM00<0EEEE0=gMg@3oool02@3MgMd01@000000gMgM0=gM
g@3MgMd0000000<0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd0203MgMd00`1EEED0gMgM0?ooo`060=gMg@030000
003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0gMgM0?ooo`050=gMg@030000
003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`070=gMg@040000
003MgMd0gMgM000000H0gMgM00<0EEEE0=gMg@3oool02@3MgMd010000000gMgM0=gMg@0000040=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gM
g@030000003MgMd0gMgM00P0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@020=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01@3MgMd00`000000gMgM0=gMg@040=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01`3MgMd3000000L0gMgM00<0EEEE0=gM
g@3oool02P3MgMd00`000000gMgM000000040=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@030000003MgMd0gMgM00P0gMgM00<0EEEE0=gM
g@3oool01`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gM
g@3oool01@3MgMd9000000<0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM000000070=gM
g@0305EEE@3MgMd0oooo00/0gMgM0P0000040=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<70=gMg@030000003MgMd0gMgM00L0gMgM00<0EEEE0=gM
g@3oool01`3MgMd2000000<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`050=gM
g@030000003MgMd0gMgM00D0gMgM00L000000=gMg@3MgMd0gMgM05EEE@3MgMd0oooo00L0gMgM00<0
00000=gMg@3MgMd00P0000050=gMg@0305EEE@3MgMd0oooo00`0gMgM00<000000=gMg@3MgMd00P3M
gMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3M
gMd00`000000gMgM00000002000000D0gMgM00<0EEEE0=gMg@3oool01P3MgMd2000000040=gMg@00
00000000000000D0gMgM00<0EEEE0=gMg@3oool01P3MgMd2000000@0gMgM00<000000=gMg@3MgMd0
0P3MgMd00`1EEED0gMgM0?ooo`060=gMg@800000103MgMd2000000<0gMgM00<0EEEE0=gMg@3oool0
303MgMd00`000000gMgM0=gMg@020=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<70=gMg@<000000P3MgMd2000000<0gMgM00<0EEEE0=gMg@3oool0
4@3MgMd00`1EEED0gMgM0?ooo`080=gMg@@000001@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo00/0gMgM00<000000=gMg@3MgMd00`3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c2P3MgMd3000000@0gMgM00<0EEEE0=gMg@3oool0
4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
2@3MgMd2000000H0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<B0?ooo`030=gM
g@3oool0oooo0140oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gM
g@3oool0oooo0140oooo00<0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<f<0gMgM00<000000>k^kP2IVIT00`2IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT2
03<c<`030=gMg@1EEED0EEEE00l0EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A
05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd000000>k^kP04
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo00D0gMgM00<000000=gMg@3MgMd02@3MgMd00`1EEED0gMgM0?ooo`080=gM
g@8000001`3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gM
g@3oool01@3MgMd00`000000gMgM0=gMg@090=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gM
g@0000001P3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM0`0000030=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd00`000000gMgM000000020000
00H0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo
00L0gMgM0`0000070=gMg@0305EEE@3MgMd0oooo00P0gMgM1@0000040=gMg@0405EEE@3MgMd00000
0>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<50=gMg@070000003MgMd0gMgM
0=gMg@000000gMgM000000050=gMg@0305EEE@3MgMd0oooo00H0gMgM0P0000030=gMg@030000003M
gMd0gMgM00<0gMgM00<0EEEE0=gMg@3oool02@3MgMd2000000H0gMgM00<0EEEE0=gMg@3oool01P3M
gMd010000000gMgM0=gMg@3MgMd2000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM
0=gMg@030=gMg@080000003MgMd0gMgM0=gMg@1EEED0gMgM0000003^k^h409VIV@80<c<c00000`3o
ool0k^k^09VIV@0209VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@020=gMg@8000001@3MgMd00`1E
EED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1E
EED0gMgM0?ooo`090=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE0=gMg@3oool01P3MgMd00`00
0000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`00
0000gMgM0=gMg@070=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI
0080VIVI0P0c<c<50=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00`3MgMd00`1E
EED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1E
EED0gMgM0?ooo`090=gMg@8000001P3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM
00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`070=gMg@H00000103MgMd0101E
EED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1@3MgMd00`00
0000gMgM0=gMg@020=gMg@8000001@3MgMd00`1EEED0gMgM0?ooo`070=gMg@040000003MgMd0gMgM
0=gMg@800000103MgMd00`1EEED0gMgM0?ooo`090=gMg@030000003MgMd0000000D0gMgM00<0EEEE
0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE
0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@070=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c
<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@070000003MgMd0gMgM0=gMg@000000gMgM
000000040=gMg@0305EEE@3MgMd0oooo00L0gMgM00@000000=gMg@00000000001P3MgMd00`1EEED0
gMgM0?ooo`070=gMg@8000000P3MgMd2000000@0gMgM00<0EEEE0=gMg@3oool0203MgMd200000003
0=gMg@000000gMgM00@0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM0=gMg@060=gMg@04
05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<70=gMg@<0
00000P3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3M
gMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo00D0gMgM0P0000060=gMg@070000003MgMd0gMgM
0=gMg@1EEED0gMgM0?ooo`090=gMg@8000001P3MgMd00`1EEED0gMgM0?ooo`090=gMg@D000000`3M
gMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3M
gMd00`1EEED0gMgM0?ooo`080=gMg@050000003MgMd0gMgM0=gMg@000000103MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<A0=gMg@0305EEE@3MgMd0oooo00T0gMgM0`0000050=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool02@3MgMd4000000@0gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM
0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`00
00<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM
0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<C0=gMg@030?ooo`3MgMd0gMgM0140gMgM00<0oooo0=gMg@3MgMd04@3MgMd00`3oool0gMgM
0=gMg@0A0=gMg@030?ooo`3MgMd0gMgM0140gMgM00<000000>k^kP2IVIT00`2IVIT203<c<`0000<0
oooo0>k^kP2IVIT00P2IVIUV03<c<`030>k^kP2IVIT0VIVI0080VIVI0P0c<c<000030?ooo`3^k^h0
VIVI06d0VIVI0P0c<c<000030?ooo`3^k^h0VIVI06d0VIVI0P0c<c<000030?ooo`3^k^h0VIVI06d0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI06d0VIVI0P0c<c<000030?ooo`3^k^h0k^k^06h0k^k^0@0c
<c<00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{114, 147},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell[TextData[{
  "Often, however, a button may contain a placeholder indicated by ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  ". This signifies that when you press the button, whatever is currently \
selected in your notebook will be inserted at the position of the \
placeholder.  "
}], "Text",
  CellTags->{"S1.3.6", "6.10"}],

Cell[TextData[{
  "The buttons here contain placeholders indicated by ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.3.6", "6.11"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000o0000=b000`400?l00000o`00003o?`3oool0
03h0<c<c0@3oool000030>k^kP0c<c<0<c<c03/0<c<c0@3oool000030>k^kP2IVIT0VIVI03T0VIVI
0P0c<c<10?ooo`0000<0k^k^09VIV@2IVIT0>@2IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@0i
09VIV@80<c<c0@3oool000040?ooo`2IVIT0VIVI09VIVCD0k^k^0`2IVIT203<c<`40oooo00001@3^
k^h0VIVI09VIV@2IVIT0<c<c03<0000000@0k^k^09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<00`3oool0EEEE05EEE@0J05EEE@80oooo4P1EEED00`000000k^k^09VI
V@0209VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd06@3M
gMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0I0=gMg@0305EEE@3oool0oooo0140gMgM00<0
EEEE0000003^k^h00`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3M
gMd0gMgM01T0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd06@3MgMd00`1EEED0oooo0?oo
o`0A0=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c
<c<00`3oool0gMgM0=gMg@0I0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h00`2I
VIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`040?ooo`3MgMd0gMgM0=gMg@D00000
4`3MgMd00`1EEED0oooo0?ooo`030=gMg@D000002@3MgMd00`1EEED000000>k^kP0309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00@0oooo0=gMg@3MgMd0gMgM1@00000C0=gMg@03
05EEE@3oool0oooo00<0gMgM1@0000090=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`00
00@0k^k^09VIV@2IVIT0VIVI0P0c<c<0103oool0gMgM0=gMg@3MgMd5000001<0gMgM00<0EEEE0?oo
o`3oool00`3MgMd5000000T0gMgM00<0EEEE0000003^k^h00`2IVIT203<c<`40oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<`040?ooo`3MgMd0gMgM0=gMg@D000001`3MgMd00`000000gMgM0=gMg@09
0=gMg@0305EEE@3oool0oooo00<0gMgM1@0000090=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<1
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0103oool0gMgM0=gMg@3MgMd500000080gMgM0`00
00020=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0oooo0?oo
o`030=gMg@D00000103MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@000000k^k^00<0VIVI0P0c
<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0103oool0gMgM0=gMg@3MgMd5000000<0gMgM
00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@030=gMg@030000003MgMd0gMgM0080gMgM
00<0EEEE0?ooo`3oool00`3MgMd5000000@0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED00000
0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0
2@3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00@00000103MgMd00`1EEED0oooo
0?ooo`090=gMg@@00000103MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd02@3MgMd00`000000gMgM0=gMg@020=gMg@070000
003MgMd0gMgM0=gMg@000000gMgM000000040=gMg@0305EEE@3oool0oooo00X0gMgM00<000000=gM
g@000000103MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c00<0oooo0=gMg@3MgMd02@3MgMd00`000000gMgM0=gMg@030=gMg@040000003MgMd0gMgM
0=gMg@800000103MgMd00`1EEED0oooo0?ooo`0;0=gMg@800000103MgMd00`1EEED000000>k^kP03
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0203MgMd2
000000D0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3oool0
oooo00`0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd06@3MgMd00`1EEED0oooo0?ooo`0A
0=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0
0`3oool0gMgM0=gMg@0I0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h00`2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<c40oooo00<000000>k^kP2IVIT00P2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<c40oooo00<000000>k^kP2IVIT00P2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`1EEED0EEEE01X0EEEE0P3ooolB
05EEE@030000003^k^h0VIVI0080VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<0
0`3oool0gMgM0=gMg@0I0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h00`2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM01T0gMgM00<0EEEE
0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c00<0oooo0=gMg@3MgMd06@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000
k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@05
0=gMg@030000003MgMd0gMgM0140gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP03
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd01@3MgMd0
0`000000gMgM0=gMg@0A0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h00`2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM00@0gMgM0P000007
0=gMg@D000001`3MgMd00`1EEED0oooo0?ooo`030=gMg@D000002@3MgMd00`1EEED000000>k^kP03
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd0103MgMd0
0`000000gMgM000000060=gMg@D000001`3MgMd00`1EEED0oooo0?ooo`030=gMg@D000002@3MgMd0
0`1EEED000000>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo
0=gMg@3MgMd00`3MgMd010000000gMgM0=gMg@0000060=gMg@D000001`3MgMd00`1EEED0oooo0?oo
o`030=gMg@D000002@3MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0
VIVI09VIV@80<c<c00L0oooo0=gMg@3MgMd0gMgM0000003MgMd000000080gMgM00<000000=gMg@3M
gMd0103MgMd5000000L0gMgM00<0EEEE0?ooo`3oool00`3MgMd5000000T0gMgM00<0EEEE0000003^
k^h00`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`030?ooo`3MgMd0gMgM0080
gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@030=gMg@D000001`3MgMd00`1EEED0
oooo0?ooo`030=gMg@D000002@3MgMd00`1EEED000000>k^kP0309VIV@80<c<c0@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gMg@3MgMd01`3MgMd00`000000gMgM0=gMg@030=gMg@D0
00001`3MgMd00`1EEED0oooo0?ooo`030=gMg@D0000000<0gMgM0000000000000P0000040=gMg@03
05EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0
gMgM0=gMg@070=gMg@030000003MgMd0gMgM00l0gMgM00<0EEEE0?ooo`3oool02P3MgMd00`000000
gMgM0=gMg@040=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<00`3oool0gMgM0=gMg@070=gMg@030000003MgMd0gMgM00l0gMgM00<0EEEE0?ooo`3o
ool02`3MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`00
00@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@080=gMg@030000003MgMd0gMgM00h0
gMgM00<0EEEE0?ooo`3oool0303MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@000000k^k^00<0
VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@080=gMg@03
0000003MgMd0gMgM00h0gMgM00<0EEEE0?ooo`3oool02@3MgMd010000000gMgM0=gMg@0000040=gM
g@0305EEE@000000k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3o
ool0gMgM0=gMg@080=gMg@`000001@3MgMd00`1EEED0oooo0?ooo`0:0=gMg@8000001@3MgMd00`1E
EED000000>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c00<0oooo0=gM
g@3MgMd06@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00<0VIVI0P0c<c<10?oo
o`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<00`3oool0gMgM0=gMg@0I0=gMg@0305EEE@3oool0oooo
0140gMgM00<0EEEE0000003^k^h00`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<`030?ooo`3MgMd0gMgM01T0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0309VI
V@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c<@3oool00`000000k^k^09VIV@0209VI
V@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIVC<0<c<c00<000000>k^kP2IVIT00P2IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVITd03<c<`040>k^kP2IVIT0VIVI09VIV@80<c<c0@3oool0
00030>k^kP2IVIT0VIVI03T0VIVI0P0c<c<10?ooo`0000<0k^k^09VIV@2IVIT0>@2IVIT203<c<`40
oooo00000`3^k^h0VIVI09VIV@0i09VIV@80<c<c0@3oool003d0k^k^0@0c<c<10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{63, 55},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["Here is a notebook with an expression selected.", "MathCaption",
  CellTags->{"S1.3.6", "6.12"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030?ooo`0c<c<0<c<c0?l0<c<co`0c<c<803<c<`40
oooo00020>GUiOl0<c<co`0c<c<903<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3U
iND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo0>GU
iOl0iNGU0P3UiND309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooc0?ooo`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cE03oool20000
01H0oooo103Ng]h2000001/0g]kN0P00000V0=kNgP800000303Ng]h2000000/0g]kN00<0oooo0000
00000000o`3ooolT0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=C0?ooo`8000005`3oool30=kNgP8000006`3Ng]h2
000002P0g]kN0P00000<0=kNgP8000002P3Ng]h20?ooo`800000o`3ooolS0?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c=C0?ooo`8000005`3oool30=kNgP8000006`3Ng]h2000002P0g]kN0P00000<0=kNgP8000002P3N
g]h20?ooo`800000o`3ooolS0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=B0?ooo`800000603oool20=kNgP800000
6`3Ng]h2000002X0g]kN0P00000<0=kNgP8000002@3Ng]h30?ooo`800000o`3ooolR0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=B0?ooo`800000603oool20=kNgP8000006`3Ng]h2000002X0g]kN0P00000<0=kNgP80
00002@3Ng]h30?ooo`800000o`3ooolR0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`H000001`3oool00`00
0000oooo0?ooo`060?ooo`800000103oool6000000L0oooo00<000000?ooo`3oool0103oool20=kN
gP800000103Ng]h6000000L0g]kN00<000000=kNgP3Ng]h01`3Ng]h2000000@0g]kN1P0000070=kN
gP030000003Ng]h0g]kN00D0g]kN1P00000;0=kNgP800000303Ng]h2000000T0g]kN0`3oool20000
0?l0oooo8P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c?P3oool2000000T0oooo00<000000?ooo`3oool01P3oool2
000000H0oooo0P0000090?ooo`030000003oool0oooo00@0oooo0P3Ng]h2000000H0g]kN0P000009
0=kNgP030000003Ng]h0g]kN00L0g]kN0P0000060=kNgP8000002@3Ng]h00`000000g]kN0=kNgP06
0=kNgP@00000303Ng]h2000000`0g]kN0P0000090=kNgP<0oooo0P00003o0?ooob80oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ch0oooo0P0000070?ooo`D000001P3oool2000000H0oooo0P0000070?ooo`D00000103o
ool20=kNgP8000001P3Ng]h2000000L0g]kN1@0000070=kNgP8000001P3Ng]h2000000L0g]kN1@00
00070=kNgP8000003@3Ng]h2000000`0g]kN0P0000090=kNgP<0oooo0P00003o0?ooob80oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ch0oooo0P0000090?ooo`030000003oool0oooo00H0oooo0P0000060?ooo`800000
2@3oool00`000000oooo0?ooo`040?ooo`80g]kN0P0000060=kNgP8000002@3Ng]h00`000000g]kN
0=kNgP070=kNgP8000001P3Ng]h2000000T0g]kN00<000000=kNgP3Ng]h01`3Ng]h2000000d0g]kN
0P00000<0=kNgP8000002@3Ng]h30?ooo`800000o`3ooolR0?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<n0?ooo`80
00002@3oool00`000000oooo0?ooo`060?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3o
ool0103oool20=kNgP8000001P3Ng]h2000000T0g]kN00<000000=kNgP3Ng]h01`3Ng]h2000000H0
g]kN0P0000090=kNgP030000003Ng]h0g]kN00H0g]kN1000000<0=kNgP800000303Ng]h2000000T0
g]kN0`3oool200000?l0oooo8P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool400000180oooo0P0000040?oo
o`@00000403oool20=kNgP800000103Ng]h4000001<0g]kN0P0000040=kNgP@000004@3Ng]h60000
00030=kNgP000000000000<000001@3Ng]h2000000`0g]kN0P0000090=kNgP<0oooo0P00003o0?oo
ob80oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<cd0oooo0`00000B0?ooo`8000001@3oool300000100oooo0P3Ng]h2
000000D0g]kN0`00000C0=kNgP8000001@3Ng]h3000001T0g]kN0P0000070=kNgP8000000P3Ng]h5
000000D0g]kN0P0000090=kNgP<0oooo0P00003o0?ooob80oooo00<0003o0?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ch0oooo0P00
000C0?ooo`8000001@3oool200000100oooo0`3Ng]h2000000D0g]kN0P00000D0=kNgP8000001@3N
g]h2000001X0g]kN0P0000050=kNgP800000103Ng]h2000000H0g]kN0P0000030=kNgPD000000P3N
g]h20?ooo`800000o`3ooolS0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=C0?ooo`8000005`3oool30=kNgP800000
6`3Ng]h200000280g]kN0P0000040=kNgP8000001@3Ng]h2000000D0g]kN0P0000040=kNgP800000
103Ng]h20?ooo`8000000`3oool500000?l0oooo6`3oool00`000?l0oooo0?ooo`040?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cE03oool2000001H0
oooo103Ng]h2000001/0g]kN0P00000N0=kNgP80000000<0g]kN0000000000000`3Ng]h2000000L0
g]kN0P0000030=kNgP8000001P3Ng]h2000000<0g]kN00<0oooo0000000000001@3oool200000?l0
oooo7@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cK03ooom20=kNgP<000002P3Ng]h2000000030=kNgP0000000000
00`0g]kN0P0000020=kNgPT0oooo0P00003o0?oooa/0oooo0P000?l60?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cK03ooom@0=kNgP<000002P3Ng]h2
000000030=kNgP00000000000080g]kN2P3oool200000?l0oooo6@3oool00`000?l0oooo0000o`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cK03o
oomN0=kNgP<000000`3Ng]h70?ooo`80000000<0oooo000000000000o`3ooolH0?ooo`040000o`3o
ool0oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?H0?ooo`<00000o`3ooolH0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3oool6
0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2I
VIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI
0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo003o
0>GUiOl0iNGU2`3UiND10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["\<\
Pressing the top left button in the palette wraps the selected \
expression with a square root.\
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.13"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000?2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<e00
oooo0P00002<0?ooo`800000o`3ooolB0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dl0oooo0P00002>0?ooo`800000o`3ooolE0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=?0?ooo`800000SP3oool200000?l0oooo5@3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cC`3o
ool2000008h0oooo0P00003o0?oooaD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dh0oooo0P00002@0?ooo`800000
o`3ooolD0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?ooo`800000T03oool200000?l0oooo503oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<cCP3oool200000900oooo0P00003o0?oooa@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dh0oooo0P00002@
0?ooo`800000o`3ooolD0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?ooo`8000007P3oool00`000000oooo0?oo
o`1_0?ooo`800000o`3ooolD0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?ooo`8000007P3oool00`000000oooo
0?ooo`090?ooo`8000006`3oool2000002H0oooo0P00000<0?ooo`8000004@3oool200000?l0oooo
503oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cCP3oool2000001h0oooo00<000000?ooo`3oool0203oool2000001/0
oooo0P00000X0?ooo`800000303oool200000100oooo0P00003o0?oooa@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<cL0oooo1P0000070?ooo`030000003oool0oooo00L0oooo0P0000030?ooo`H000001`3oool00`00
0000oooo0?ooo`0:0?ooo`8000002P3oool2000000<0oooo1P0000070?ooo`030000003oool0oooo
00P0oooo0P0000030?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H000002P3oool20000
00`0oooo0P00000@0?ooo`800000o`3ooolD0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<i0?ooo`8000002@3oool0
0`000000oooo0?ooo`070?ooo`8000001@3oool2000000T0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo000000080?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3oool01`3oool2
000000H0oooo0P0000090?ooo`030000003oool0oooo00H0oooo1000000<0?ooo`800000303oool2
000000l0oooo0P00003o0?oooa@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cT0oooo0P0000070?ooo`D000001`3o
ool2000000D0oooo0P0000070?ooo`D000002@3oool010000000oooo0?ooo`0000080?ooo`800000
1P3oool2000000L0oooo1@0000070?ooo`8000001P3oool2000000L0oooo1@0000070?ooo`800000
3@3oool2000000`0oooo0P00000?0?ooo`800000o`3ooolD0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<i0?ooo`80
00002@3oool00`000000oooo0?ooo`070?ooo`8000001@3oool2000000T0oooo00<000000?ooo`3o
ool02@3oool010000000oooo0?ooo`0000080?ooo`8000001P3oool2000000T0oooo00<000000?oo
o`3oool01`3oool2000000H0oooo0P0000090?ooo`030000003oool0oooo00L0oooo0P00000=0?oo
o`800000303oool2000000l0oooo0P00003o0?oooa@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cT0oooo0P000009
0?ooo`030000003oool0oooo00L0oooo0P0000050?ooo`8000002@3oool00`000000oooo0?ooo`09
0?ooo`040000003oool0oooo000000P0oooo0P0000060?ooo`8000002@3oool00`000000oooo0?oo
o`070?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3oool01P3oool400000080oooo1@00
00050?ooo`800000303oool2000000l0oooo0P00003o0?oooa@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cL0oooo
1000000C0?ooo`8000000`3oool400000140oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`060?ooo`8000000`3oool4000001@0oooo0P0000030?ooo`@000004@3oool600000080
oooo0P0000060?ooo`8000000`3oool5000000@0oooo0P00000@0?ooo`800000o`3ooolD0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<h0?ooo`<000004`3oool2000000@0oooo0`00000B0?ooo`<00000103oool00`00
0000oooo0?ooo`060?ooo`800000103oool3000001@0oooo0P0000040?ooo`<000006P3oool20000
00D0oooo0P0000040?ooo`8000001P3oool2000000<0oooo1@0000080?ooo`800000o`3ooolD0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<i0?ooo`8000004`3oool2000000D0oooo0P00000C0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01`3oool2000000@0oooo0P00000E0?ooo`800000103oool2
000001/0oooo0P0000030?ooo`8000001P3oool2000000@0oooo0P0000050?ooo`8000002P3oool2
00000?l0oooo503oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cCP3oool200000200oooo00<000000?ooo`3oool0A03o
ool2000000030?ooo`000000000000`0oooo0P00000;0?ooo`8000002@3oool200000?l0oooo503o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cCP3oool200000200oooo00<000000?ooo`3oool0A@3oool3000000X0oooo
0P0000000`3oool000000000000<0?ooo`800000203oool200000?l0oooo503oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cCP3oool200000240oooo00<000000?ooo`3oool0DP3oool3000000X0oooo0P0000000`3oool0
0000000000080?ooo`800000o`3ooolD0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?ooo`8000008@3oool00`00
0000oooo0?ooo`1P0?ooo`<000002@3oool200000?l0oooo503oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cCP3oool2
00000240oooo00<000000?ooo`3oool0K03oool200000?l0oooo503oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cC`3o
ool200000200oooo00<000000?ooo`3oool0J`3oool2000000<0oooo1@00003o0?ooo`d0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<dl0oooo0P00000Q0?ooo`030000003oool0oooo06X0oooo0P0000040?ooo`800000
o`3oool?0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c=?0?ooo`8000008@3oool00`000000oooo0?ooo`1Z0?ooo`80
00001@3oool200000?l0oooo3P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cD03oool200000200ooooJ00000040?oo
o`8000001`3oool200000?l0oooo3@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<ci03oool2000000030?ooo`000000
00000?l0oooo303oool20000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?U0?ooo`<00000o`3oool<0?ooo`030000o`3oool0003o00L0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo
00@0003o0?ooo`3oool0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooolP3oool01@000?l0oooo0?ooo`3oool0003o00L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo40oooo1P00
0?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`00o`3UiNGo0>GU
i@/0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 60},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell[TextData[{
  "Sometimes buttons that contain placeholders will be programmed simply to \
insert a certain expression in your notebook. But more often, they will be \
programmed to evaluate the result, sending it as input to the ",
  StyleBox["Mathematica", "TI"],
  " kernel.  "
}], "Text",
  CellTags->{"S1.3.6", "6.14"}],

Cell["These buttons are set up to perform algebraic operations. ", \
"MathCaption",
  CellTags->{"S1.3.6", "6.15"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0000@2000`400?l00000o`00003oc`0c<c<0
00030>k^kP0c<c<0<c<c0<`0<c<c00000`3^k^h0VIVI09VIV@3:09VIV@80<c<c00000`3^k^h0VIVI
09VIV@3:09VIV@80<c<c00000`3^k^h0VIVI09VIV@3:09VIV@80<c<c0000103^k^h0VIVI09VIV@2I
VIW50>k^kP@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c`P0000000`3^k^h0VIVI09VI
V@0209VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<e80EEEE00<0oooo05EEE@1EEED0K01E
EED00`000000k^k^09VIV@0309VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<e40gMgM00<0
EEEE0?ooo`3MgMd0K03MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI09VIV@2I
VIT203<c<e40gMgM00<0EEEE0?ooo`3MgMd0K03MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000
103^k^h0VIVI09VIV@2IVIT203<c<a<0gMgM0`00000k0=gMg@0305EEE@3oool0gMgM01l0gMgM0`00
001:0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c503M
gMd00`000000gMgM0=gMg@0K0=gMg@8000002`3MgMd200000100gMgM00<0EEEE0?ooo`3MgMd08P3M
gMd00`000000gMgM0=gMg@0U0=gMg@8000002`3MgMd2000001<0gMgM00<0EEEE0000003^k^h0102I
VIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<D0=gMg@030000003MgMd0gMgM01/0gMgM00<0
00000=gMg@3MgMd02`3MgMd00`000000gMgM0=gMg@0>0=gMg@0305EEE@3oool0gMgM0280gMgM00<0
00000=gMg@3MgMd09@3MgMd00`000000gMgM0=gMg@0;0=gMg@030000003MgMd0gMgM0140gMgM00<0
EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<<0=gMg@<0000000D0
gMgM00000000000000000=gMg@04000000@0gMgM0`0000000`3MgMd000000=gMg@04000000D0gMgM
0`0000040=gMg@030000003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00h0gMgM
00<0EEEE0?ooo`3MgMd0403MgMd5000000<0gMgM0`0000040=gMg@@000000`3MgMd3000000D0gMgM
0`0000001@3MgMd00000000000000000gMgM00<000000P3MgMd3000000<0gMgM100000050=gMg@03
0000003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM0140gMgM00<0EEEE0000003^
k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<=0=gMg@050000003MgMd0gMgM0=gM
g@0000000P3MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM0000
00030=gMg@030000003MgMd0gMgM00@0gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@030000
003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00h0gMgM00<0EEEE0?ooo`3MgMd0
4P3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@000000
gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@070000003MgMd0
gMgM0=gMg@000000gMgM000000030=gMg@040000003MgMd0gMgM000000<0gMgM00D000000=gMg@3M
gMd0gMgM000000070=gMg@030000003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM
0140gMgM00<0EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<=0=gM
g@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D0
00000=gMg@3MgMd0gMgM000000030=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd0
1@3MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gMg@0>0=gMg@0305EE
E@3oool0gMgM0180gMgM00<000000=gMg@3MgMd00P3MgMd01@000000gMgM0=gMg@3MgMd000000080
gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@030000003MgMd0gMgM00D0gMgM00<000000=gM
g@3MgMd00`3MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00<000000=gMg@3MgMd01@3MgMd0
0`000000gMgM0=gMg@050=gMg@030000003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0
gMgM0140gMgM00<0EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<=
0=gMg@D000000P3MgMd01@000000gMgM0=gMg@3MgMd0000000<0gMgM100000030=gMg@030000003M
gMd0gMgM00@0gMgM00<000000=gMg@3MgMd01@3MgMd00`000000gMgM0=gMg@020=gMg@D00000103M
gMd00`000000gMgM0=gMg@0>0=gMg@0305EEE@3oool0gMgM0180gMgM00<000000=gMg@3MgMd00P3M
gMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@D0
00000`3MgMd00`000000gMgM0=gMg@030=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd50000
00<0gMgM00<000000=gMg@3MgMd01@3MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`00
0000gMgM0=gMg@0A0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VI
V@80<c<c3P3MgMd00`000000gMgM000000030=gMg@050000003MgMd0gMgM0=gMg@0000001P3MgMd0
1@000000gMgM0=gMg@3MgMd0000000H0gMgM00<000000=gMg@3MgMd01@3MgMd00`000000gMgM0=gM
g@020=gMg@D00000103MgMd00`000000gMgM0=gMg@0>0=gMg@0305EEE@3oool0gMgM0180gMgM00<0
00000=gMg@3MgMd00P3MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3MgMd0
gMgM000000020=gMg@050000003MgMd0gMgM0=gMg@0000000`3MgMd00`000000gMgM0=gMg@030=gM
g@8000000P3MgMd010000000gMgM0=gMg@0000030=gMg@050000003MgMd0gMgM0=gMg@0000001`3M
gMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gMg@0A0=gMg@0305EEE@00
0000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c3P3MgMd00`000000gMgM0000
00020=gMg@030000003MgMd00000008000000`3MgMd4000000<0gMgM00<000000=gMg@0000000P00
00020=gMg@D00000103MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gM
g@0>0=gMg@0305EEE@3oool0gMgM00l0gMgM00@000000=gMg@3MgMd000000P3MgMd00`000000gMgM
0=gMg@03000000@0gMgM0`000000103MgMd000000=gMg@3MgMd3000000<0gMgM1@0000020=gMg@04
0000003MgMd00000000000@0gMgM0`0000030=gMg@030000003MgMd0000000800000103MgMd00`00
0000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gMg@0A0=gMg@0305EEE@000000k^k^
00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c3`3MgMd00`000000gMgM0=gMg@0H0=gM
g@030000003MgMd0gMgM00D0gMgM00<000000=gMg@3MgMd02`3MgMd00`000000gMgM0=gMg@0>0=gM
g@0305EEE@3oool0gMgM00l0gMgM00@000000=gMg@3MgMd000000P3MgMd00`000000gMgM0=gMg@0E
0=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd0503MgMd00`000000gMgM0=gMg@0;
0=gMg@030000003MgMd0gMgM0140gMgM00<0EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<=0=gMg@<000006P3MgMd00`000000gMgM0=gMg@050=gMg@8000002`3MgMd2
00000100gMgM00<0EEEE0?ooo`3MgMd03`3MgMd7000001L0gMgM00<000000=gMg@3MgMd00P3MgMd2
000001H0gMgM0P00000;0=gMg@8000004`3MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^
k^h0VIVI09VIV@2IVIT203<c<e40gMgM00<0EEEE0?ooo`3MgMd0K03MgMd00`1EEED000000>k^kP04
09VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<e40gMgM00<0EEEE0?ooo`3MgMd0K03MgMd0
0`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<l40oooo00<00000
0>k^kP2IVIT00`2IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=B05EEE@030?ooo`1EEED0
EEEE06`0EEEE00<000000>k^kP2IVIT00`2IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=A
0=gMg@0305EEE@3oool0gMgM06`0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c=A0=gMg@0305EEE@3oool0gMgM06`0gMgM00<0EEEE0000003^k^h0102IVIT2
03<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<G0=gMg@<00000=`3MgMd00`1EEED0oooo0=gMg@1/
0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c603MgMd0
0`000000gMgM0=gMg@0K0=gMg@8000002`3MgMd2000000`0gMgM00<0EEEE0?ooo`3MgMd0@`3MgMd2
000000/0gMgM0P00000J0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI
09VIV@80<c<c603MgMd00`000000gMgM0=gMg@0K0=gMg@030000003MgMd0gMgM00/0gMgM00<00000
0=gMg@3MgMd02P3MgMd00`1EEED0oooo0=gMg@130=gMg@030000003MgMd0gMgM00/0gMgM00<00000
0=gMg@3MgMd0603MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT2
03<c<`T0gMgM1P0000000`3MgMd00000000000030=gMg@80000000<0gMgM0000000000000P000004
0=gMg@<0000000<0gMgM0000000000000P0000020=gMg@8000000P3MgMd3000000030=gMg@000000
gMgM0080gMgM00<000000=gMg@3MgMd00P3MgMd5000000@0gMgM00<000000=gMg@3MgMd02P3MgMd0
0`1EEED0oooo0=gMg@0F0=gMg@@000001@3MgMd3000000040=gMg@000000gMgM0=gMg@<000001@3M
gMd3000000<0gMgM0`0000030=gMg@@000001@3MgMd00`000000gMgM0=gMg@020=gMg@D00000103M
gMd00`000000gMgM0=gMg@0H0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0
VIVI09VIV@80<c<c2P3MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3MgMd0
gMgM000000020=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@000000gMgM0=gMg@3MgMd0
00000080gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@050000003MgMd0gMgM0=gMg@000000
103MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gMg@0:0=gMg@0305EE
E@3oool0gMgM01L0gMgM00<000000=gMg@3MgMd0103MgMd01@000000gMgM0=gMg@3MgMd000000080
gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@070000003MgMd0gMgM0=gMg@000000gMgM0000
00030=gMg@050000003MgMd0gMgM0=gMg@0000001`3MgMd00`000000gMgM0=gMg@020=gMg@D00000
103MgMd00`000000gMgM0=gMg@0H0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2I
VIT0VIVI09VIV@80<c<c2P3MgMd00`000000gMgM0=gMg@050=gMg@030000003MgMd0000000<0gMgM
00D000000=gMg@3MgMd0gMgM000000020=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@00
0000gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM000000040=gMg@030000003M
gMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00X0gMgM00<0EEEE0?ooo`3MgMd05`3M
gMd00`000000gMgM0=gMg@040=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd00`000000gMgM
0=gMg@050=gMg@030000003MgMd0gMgM00<0gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@03
0000003MgMd0gMgM00D0gMgM00<000000=gMg@3MgMd00P3MgMd5000000@0gMgM00<000000=gMg@3M
gMd0603MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<`X0
gMgM00@000000=gMg@3MgMd000001@3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM
0=gMg@0000000`3MgMd400000080gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@050000003M
gMd0gMgM0=gMg@000000103MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM
0=gMg@0:0=gMg@0305EEE@3oool0gMgM01L0gMgM00<000000=gMg@0000001@3MgMd400000080gMgM
00<000000=gMg@3MgMd01@3MgMd00`000000gMgM0=gMg@030=gMg@050000003MgMd0gMgM0=gMg@00
00000`3MgMd00`000000gMgM0=gMg@050=gMg@030000003MgMd0gMgM0080gMgM1@0000040=gMg@03
0000003MgMd0gMgM01P0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<:0=gMg@@00000103MgMd00`000000gMgM000000030=gMg@050000003MgMd0gMgM0=gM
g@0000001P3MgMd00`000000gMgM0=gMg@0200000080gMgM00@000000=gMg@3MgMd000000`3MgMd0
0`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0
gMgM00X0gMgM00<0EEEE0?ooo`3MgMd05`3MgMd3000000P0gMgM00@000000=gMg@3MgMd000000`3M
gMd01@000000gMgM0=gMg@3MgMd0000000D0gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@03
0000003MgMd0gMgM00D0gMgM00<000000=gMg@3MgMd00P3MgMd5000000@0gMgM00<000000=gMg@3M
gMd0603MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<`X0
gMgM00@000000=gMg@3MgMd000000P3MgMd3000000030=gMg@00000000000080000000@0gMgM0000
0000000000000`3MgMd400000080gMgM00<000000=gMg@0000000P0000040=gMg@@00000103MgMd0
0`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gMg@0:0=gMg@0305EEE@3oool0
gMgM01L0gMgM00D000000=gMg@000000gMgM000000020=gMg@@00000103MgMd3000000<0gMgM1@00
00030=gMg@<000000`3MgMd00`000000gMgM00000002000000@0gMgM00<000000=gMg@3MgMd00P3M
gMd5000000@0gMgM00<000000=gMg@3MgMd0603MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000
103^k^h0VIVI09VIV@2IVIT203<c<`X0gMgM00D000000=gMg@3MgMd0gMgM0000000R0=gMg@030000
003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd02`3MgMd00`000000gMgM0=gMg@0:0=gMg@0305EE
E@3oool0gMgM01L0gMgM00D000000=gMg@3MgMd0gMgM0000000A0=gMg@030000003MgMd0gMgM01<0
gMgM00<000000=gMg@3MgMd02`3MgMd00`000000gMgM0=gMg@0H0=gMg@0305EEE@000000k^k^00@0
VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c2@3MgMd600000240gMgM0P0000040=gMg@80
00002`3MgMd2000000`0gMgM00<0EEEE0?ooo`3MgMd05P3MgMd600000140gMgM00<000000=gMg@3M
gMd04`3MgMd2000000/0gMgM0P00000J0=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^
kP2IVIT0VIVI09VIV@80<c<cD@3MgMd00`1EEED0oooo0=gMg@1/0=gMg@0305EEE@000000k^k^00@0
VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<cD@3MgMd00`1EEED0oooo0=gMg@1/0=gMg@03
05EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c`@3oool00`000000
k^k^09VIV@0309VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<e80EEEE00<0oooo05EEE@1E
EED0K01EEED00`000000k^k^09VIV@0309VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<e40
gMgM00<0EEEE0?ooo`3MgMd0K03MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI
09VIV@2IVIT203<c<e40gMgM00<0EEEE0?ooo`3MgMd0K03MgMd00`1EEED000000>k^kP0409VIV@80
<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<aL0gMgM0`00000J0=gMg@8000006`3MgMd00`1EEED0
oooo0=gMg@0b0=gMg@<000006P3MgMd2000001/0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`00
00@0k^k^09VIV@2IVIT0VIVI0P0c<c<H0=gMg@030000003MgMd0gMgM01/0gMgM00<000000=gMg@3M
gMd0103MgMd2000000/0gMgM0P0000050=gMg@0305EEE@3oool0gMgM03<0gMgM00<000000=gMg@3M
gMd06`3MgMd00`000000gMgM0=gMg@040=gMg@8000002`3MgMd2000000D0gMgM00<0EEEE0000003^
k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<H0=gMg@030000003MgMd0gMgM01/0
gMgM00<000000=gMg@3MgMd0103MgMd00`000000gMgM0=gMg@0;0=gMg@030000003MgMd0gMgM00<0
gMgM00<0EEEE0?ooo`3MgMd0<`3MgMd00`000000gMgM0=gMg@0K0=gMg@030000003MgMd0gMgM00@0
gMgM00<000000=gMg@3MgMd02`3MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@000000k^k^00@0
VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd4000000<0gMgM1@0000001P3MgMd0
00000000003MgMd000000=gMg@80000000<0gMgM0000000000000P0000030=gMg@H0000000<0gMgM
0000000000000`0000020=gMg@@000001@3MgMd00`000000gMgM0=gMg@040=gMg@030000003MgMd0
gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00<0gMgM00@0EEEE0?ooo`3MgMd0gMgM1000
00050=gMg@<0000000<0gMgM0000003MgMd01P0000000`3MgMd0000000000004000000030=gMg@00
00000000008000000`3MgMd5000000060=gMg@00000000000=gMg@000000gMgM0P0000000`3MgMd0
000000000002000000<0gMgM1P0000000`3MgMd000000000000300000080gMgM100000050=gMg@03
0000003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3MgMd5000000@0gMgM00<000000=gMg@3M
gMd00`3MgMd00`1EEED000000>k^kP0409VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<`<0
gMgM00D000000=gMg@3MgMd0gMgM000000040=gMg@030000003MgMd0gMgM0080gMgM00D000000=gM
g@000000gMgM000000020=gMg@050000003MgMd0gMgM0=gMg@000000103MgMd00`000000gMgM0=gM
g@040=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd0103MgMd3000000D0gMgM00<0
00000=gMg@3MgMd00P3MgMd5000000@0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0oooo0=gM
g@020=gMg@030000003MgMd0gMgM00@0gMgM00D000000=gMg@3MgMd0gMgM000000040=gMg@030000
003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3MgMd01@000000gMgM0=gMg@3MgMd0000000@0
gMgM00<000000=gMg@3MgMd00P3MgMd01@000000gMgM0000003MgMd000000080gMgM00D000000=gM
g@3MgMd0gMgM000000040=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00`3MgMd0
0`000000gMgM0=gMg@040=gMg@<000001@3MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd0
0`000000gMgM0=gMg@030=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI
09VIV@80<c<c1`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00D00000
0=gMg@000000gMgM000000020=gMg@050000003MgMd0gMgM0=gMg@000000103MgMd00`000000gMgM
0=gMg@040=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd0103MgMd00`000000gMgM
000000050=gMg@030000003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00<0gMgM
00<0EEEE0?ooo`3MgMd00P3MgMd00`000000gMgM0=gMg@040=gMg@050000003MgMd0gMgM0=gMg@00
0000103MgMd00`000000gMgM0=gMg@040=gMg@030000003MgMd0gMgM00H0gMgM00<000000=gMg@3M
gMd00P3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd000000=gMg@0000000P3MgMd01@00
0000gMgM0=gMg@3MgMd0000000@0gMgM00<000000=gMg@3MgMd0103MgMd00`000000gMgM0=gMg@03
0=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@0000001@3MgMd00`000000gMgM0=gMg@02
0=gMg@D00000103MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@000000k^k^00@0VIVI0P0c<c<0
00040>k^kP2IVIT0VIVI09VIV@80<c<c1@3MgMd3000000@0gMgM00<000000=gMg@3MgMd00P3MgMd0
1@000000gMgM0000003MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM000000040=gMg@030000
003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00`3MgMd00`000000gMgM0=gMg@030=gMg@050000
003MgMd0gMgM0=gMg@000000103MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd00`000000
gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM0080gMgM00<000000=gMg@000000103MgMd01@000000
gMgM0=gMg@3MgMd0000000@0gMgM00<000000=gMg@3MgMd0103MgMd00`000000gMgM0=gMg@040=gM
g@<00000103MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd000000=gMg@0000000P3MgMd0
1@000000gMgM0=gMg@3MgMd0000000@0gMgM00<000000=gMg@3MgMd0103MgMd00`000000gMgM0=gM
g@030=gMg@030000003MgMd0gMgM00<0gMgM00D000000=gMg@3MgMd0gMgM000000040=gMg@030000
003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0000003^k^h0
102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<30=gMg@<000001P3MgMd00`000000gMgM
0=gMg@020=gMg@050000003MgMd000000=gMg@0000000P3MgMd01@000000gMgM0=gMg@3MgMd00000
00@0gMgM00<000000=gMg@3MgMd0103MgMd00`000000gMgM0=gMg@030=gMg@030000003MgMd0gMgM
00<0gMgM00D000000=gMg@3MgMd0gMgM000000040=gMg@030000003MgMd0gMgM0080gMgM1@000004
0=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0?ooo`3MgMd00P3MgMd3000000@0gMgM00D00000
0=gMg@3MgMd0gMgM000000040=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3M
gMd3000000H0gMgM00<000000=gMg@3MgMd00P3MgMd01@000000gMgM0000003MgMd000000080gMgM
00D000000=gMg@3MgMd0gMgM000000040=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@3M
gMd00`3MgMd00`000000gMgM0=gMg@030=gMg@050000003MgMd0gMgM0=gMg@000000103MgMd00`00
0000gMgM0=gMg@020=gMg@D00000103MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@000000k^k^
00@0VIVI0P0c<c<000040>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd00`000000gMgM0=gMg@040=gM
g@<000000`3MgMd3000000060=gMg@000000gMgM0=gMg@000000gMgM0`0000050=gMg@030000003M
gMd0gMgM0080gMgM0`0000040=gMg@D0000000D0gMgM00000000000000000=gMg@03000000<0gMgM
00<000000=gMg@3MgMd00P3MgMd5000000@0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0oooo
0=gMg@020=gMg@060000003MgMd000000=gMg@000000gMgM0P0000020=gMg@800000103MgMd00`00
0000gMgM0=gMg@040=gMg@030000003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd0103MgMd30000
00<0gMgM0`0000001P3MgMd000000=gMg@3MgMd000000=gMg@<000001@3MgMd00`000000gMgM0=gM
g@020=gMg@<00000103MgMd5000000050=gMg@00000000000000003MgMd00`0000030=gMg@030000
003MgMd0gMgM0080gMgM1@0000040=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0000003^k^h0
102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<30=gMg@050000003MgMd0gMgM0=gMg@00
00006@3MgMd00`000000gMgM0=gMg@0:0=gMg@030000003MgMd0gMgM00`0gMgM00<000000=gMg@3M
gMd02`3MgMd00`000000gMgM0=gMg@030=gMg@0305EEE@3oool0gMgM0080gMgM00D000000=gMg@3M
gMd0gMgM0000000;0=gMg@030000003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3MgMd01@00
0000gMgM0=gMg@3MgMd0000001T0gMgM00<000000=gMg@3MgMd02P3MgMd00`000000gMgM0=gMg@0<
0=gMg@030000003MgMd0gMgM00/0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED000000>k^kP04
09VIV@80<c<c0000103^k^h0VIVI09VIV@2IVIT203<c<`@0gMgM100000040=gMg@030000003MgMd0
gMgM0100gMgM0`0000060=gMg@030000003MgMd0gMgM00@0gMgM0`00000;0=gMg@8000002`3MgMd2
000000D0gMgM00@0EEEE0?ooo`3MgMd0gMgM1P0000090=gMg@<00000103MgMd3000000D0gMgM1000
00040=gMg@030000003MgMd0gMgM0100gMgM0`0000060=gMg@030000003MgMd0gMgM00@0gMgM0`00
000;0=gMg@8000002`3MgMd2000000D0gMgM00<0EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c=A0=gMg@0305EEE@3oool0gMgM06`0gMgM00<0EEEE0000003^k^h0102I
VIT203<c<`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=A0=gMg@0305EEE@3oool0gMgM06`0gMgM00<0
EEEE0000003^k^h0102IVIT203<c<`0000@0k^k^09VIV@2IVIT0VIVIa00c<c<00`3^k^h0VIVI09VI
V@0209VIV@80<c<c00000`3^k^h0VIVI09VIV@3:09VIV@80<c<c00000`3^k^h0VIVI09VIV@3:09VI
V@80<c<c00000`3^k^h0VIVI09VIV@3:09VIV@80<c<c00000`3^k^h0VIVI09VIV@3:09VIV@80<c<c
003>0>k^kP40<c<c003?0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{207, 64},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["Here is a notebook with an expression selected. ", "MathCaption",
  CellTags->{"S1.3.6", "6.16"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3o
ool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=40?ooo`@00000?03oool60=kNgP@000000`3Ng]h600000=40g]kNS@3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cA@3oool2000003d0oooo1@3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h200000=40
g]kNS@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cA@3oool2000003d0oooo2@3Ng]h2000000<0g]kN0P00003D0=kN
gXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<d80oooo1P00000l0?ooo`T0g]kN0P0000040=kNgP800000d`3Ng]j=
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=20?ooo`80000000<0oooo000000000000?@3oool70=kNgP<000001P3N
g]h200000=80g]kNS@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c@`3oool4000003d0oooo2@3Ng]h2000000H0g]kN
0P00003A0=kNgXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<d@0oooo0`00000m0?ooo`D0g]kN0P0000020=kNgP80
00000P3Ng]h200000080g]kN0P00003A0=kNgXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dD0oooo0P00000m0?oo
o`H0g]kN100000040=kNgP@00000dP3Ng]j=0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>40?ooon@0g]kNS@3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cQ03ooolO0=kNgP800000B`3Ng]h4000001D0g]kN1000000e0=kNgP@000005@3N
g]h4000000<0g]kN0P0000040=kNgXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<h@0oooo7P3Ng]h2000004`0g]kN
0P00000I0=kNgP800000=@3Ng]h2000001T0g]kN0P0000040=kNgP8000000`3Ng]j=0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=l0?ooo`030000003oool0oooo00D0oooo7P3Ng]h2000000<0g]kN1P0000020=kNgPH0
00003`3Ng]h6000000<0g]kN100000070=kNgP@00000103Ng]h4000000<0g]kN1@0000040=kNgP80
0000103Ng]h6000000D0g]kN1P0000040=kNgP8000002@3Ng]h00`000000g]kN0=kNgP070=kNgP@0
00001P3Ng]h4000000@0g]kN100000030=kNgPD00000103Ng]h2000000H0g]kN100000050=kNgPH0
0000103Ng]h2000000@0g]kN0P0000030=kNgXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<g`0oooo00<000000?oo
o`3oool01@3ooolM0=kNgP8000001P3Ng]h2000000@0g]kN0P0000020=kNgP8000004@3Ng]h20000
00@0g]kN0P0000020=kNgP8000001@3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h20000
0080g]kN0P0000020=kNgP8000000`3Ng]h2000000@0g]kN0P0000020=kNgP8000001P3Ng]h40000
00D0g]kN0P0000090=kNgP030000003Ng]h0g]kN00P0g]kN0P0000060=kNgP8000000P3Ng]h20000
0080g]kN0P0000020=kNgP8000000P3Ng]h200000080g]kN0P0000030=kNgP8000001`3Ng]h20000
00L0g]kN100000050=kNgP8000001@3Ng]h200000080g]kNS@3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c5`3ooomM
000000H0oooo1@0000050?ooo`80g]kN4`0000080=kNgP8000001P3Ng]h2000000D0g]kN0P000008
0=kNgPD000001`3Ng]h2000000@0g]kN0P0000020=kNgP800000103Ng]h2000000L0g]kN0P000002
0=kNgP8000001P3Ng]h2000000<0g]kN0P0000050=kNgP8000002P3Ng]h2000000H0g]kN0P000007
0=kNgPD00000203Ng]h2000000D0g]kN0P0000070=kNgP8000000P3Ng]h2000000H0g]kN0P000003
0=kNgP8000001`3Ng]h2000000P0g]kN0P0000060=kNgP8000001@3Ng]h200000080g]kNS@3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cO03oool00`000000oooo0?ooo`050?oooad0g]kN0P0000060=kNgP8000001P3N
g]h2000001<0g]kN0P0000040=kNgP8000000P3Ng]h2000000@0g]kN0P0000070=kNgP8000000P3N
g]h2000000<0g]kN100000040=kNgP8000001P3Ng]h2000000T0g]kN0P0000060=kNgP8000002@3N
g]h00`000000g]kN0=kNgP050=kNgPH00000103Ng]h2000000L0g]kN0P0000020=kNgP8000000`3N
g]h4000000@0g]kN0P0000040=kNgPH000001`3Ng]h2000000H0g]kN0P0000050=kNgP8000000P3N
g]j=0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c=l0?ooo`030000003oool0oooo00D0oooo7@3Ng]h2000000H0g]kN
0P0000070=kNgP8000004P3Ng]h2000000@0g]kN1@0000050=kNgP8000001`3Ng]h200000080g]kN
0P0000020=kNgP8000000P3Ng]h2000000<0g]kN0P0000070=kNgP8000001`3Ng]h4000000D0g]kN
0P0000090=kNgP030000003Ng]h0g]kN00D0g]kN0P0000000`3Ng]h00000000000050=kNgP800000
1`3Ng]h200000080g]kN0P0000020=kNgP8000000P3Ng]h2000000<0g]kN0P0000040=kNgP800000
00<0g]kN0000000000001`3Ng]h4000000D0g]kN0P0000050=kNgP8000000P3Ng]j=0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c>40?oooah0g]kN0P0000030=kNgP@00000203Ng]h2000000l0g]kN100000040=kNgP80
0000203Ng]h2000000P0g]kN100000040=kNgP@00000103Ng]h2000000P0g]kN0P0000050=kNgPH0
0000103Ng]h200000180g]kN100000050=kNgP800000203Ng]h4000000@0g]kN100000040=kNgP80
00001@3Ng]h4000000H0g]kN1P0000040=kNgP800000103Ng]h2000000<0g]kNS@3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<cD`3oool4000001D0oooo1000000D0?oooah0g]kN0P0000040=kNgP<00000103Ng]h20000
0080g]kN0P00000@0=kNgP<000001@3Ng]h2000000P0g]kN0P0000020=kNgP8000004`3Ng]h20000
00@0g]kN0P0000020=kNgP8000003`3Ng]h2000001<0g]kN0`0000060=kNgP8000000P3Ng]h20000
01<0g]kN0P0000060=kNgP<00000403Ng]h2000000@0g]kN0P0000030=kNgXd0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<e<0oooo0P00000I0?ooo`800000503ooolO0=kNgP800000103Ng]h2000000D0g]kN1000000B
0=kNgP8000001P3Ng]h3000000L0g]kN1@00000C0=kNgP@000000`3Ng]h4000000h0g]kN1000000D
0=kNgP8000001`3Ng]h5000001<0g]kN100000050=kNgP8000003P3Ng]h4000000<0g]kN0P000004
0=kNgXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<aX0oooo1P0000070?ooo`030000003oool0oooo00D0oooo1P00
00060?ooo`@00000103oool4000000<0oooo1@0000040?ooo`800000103oool6000000D0oooo1P00
00040?ooo`800000503oool90=kNgPH00000e@3Ng]j=0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<J0?ooo`800000
0P3oool2000000L0oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000050?ooo`800000
0P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`800000
103oool200000080oooo0P0000060?ooo`@000001@3oool2000001@0oooo2`3Ng]h200000=L0g]kN
S@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c6`3oool2000000P0oooo1@0000060?ooo`8000001`3oool2000000L0
oooo0P0000020?ooo`8000001P3oool2000000<0oooo0P0000050?ooo`8000002P3oool2000000H0
oooo0P00000D0?ooo`/0g]kN0P00003G0=kNgXd0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<a`0oooo0P0000090?oo
o`030000003oool0oooo00L0oooo0P0000060?ooo`8000001`3oool200000080oooo0P0000030?oo
o`@00000103oool2000000H0oooo0P0000090?ooo`8000001P3oool2000001@0oooo2`3Ng]h20000
0=L0g]kNS@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c7@3oool2000000P0oooo00<000000?ooo`3oool0203oool2
000000D0oooo0P0000070?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool2
000000L0oooo0P0000070?ooo`@000001@3oool2000001@0oooo2`3Ng]h200000=L0g]kNS@3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c7P3oool2000001<0oooo0P0000040?ooo`800000203oool4000000@0oooo1000
00040?ooo`800000203oool2000000D0oooo1P0000040?ooo`800000503oool90=kNgP@00000e`3N
g]j<0?ooo`80003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<aX0oooo0P0000020?ooo`8000003`3oool200000080oooo0P0000050?ooo`800000
0P3oool2000001<0oooo0P0000040?ooo`8000000P3oool2000000l0oooo0P00000D0?ooo`X0g]kN
0`00003G0=kNgX/0oooo00<0003o0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<a/0oooo1000000A0?ooo`@000001`3oool5000001<0
oooo100000030?ooo`@000003P3oool4000001@0oooo2`3Ng]h200000=L0g]kNRP3oool010000?l0
oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooob0?ooo`050000o`3oool0oooo0?ooo`000?l01`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool@3oool60000o`L0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c
<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
o`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0
o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c
<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo003o0>GU
iOl0iNGU2`3UiND10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["\<\
Pressing the top left button in the palette causes the selected \
expression to be simplified. \
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.17"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<803<c<`80oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c1`0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0`2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f<0
oooo1000003o0?oooh/0oooo1@000?l50?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=T0?ooo`800000o`3ooon@0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f@0
oooo0P00003o0?oooi00oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cH@3oool600000?l0ooooS`3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=Q0?ooo`80000000<0oooo000000000000o`3ooon@0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f80
oooo1000003o0?oooi00oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cH`3oool300000?l0ooooT03oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=T0?ooo`800000o`3ooon@0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c>S0?oooaX0g]kN1000000:0=kNgP@000002@3Ng]ko0?oooah0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cX`3ooolJ0=kNgP8000003P3Ng]h2000000T0g]kNo`3ooolN0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<i/0
oooo00<000000?ooo`3oool01@3oool00`3Ng]h0000000000003000000<0g]kN1P0000000`3Ng]h0
00000000000600000080g]kN0P0000040=kNgPH00000103Ng]h2000000T0g]kNo`3ooolN0?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<i/0oooo00<000000?ooo`3oool01@3oool00`3Ng]h00000000000020=kNgP80
0000103Ng]h2000000@0g]kN0P0000020=kNgP8000000`3Ng]h2000000D0g]kN100000050=kNgP80
00002@3Ng]ko0?oooah0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3ooomM000000H0oooo1@0000050?ooo`D0
g]kN0P0000040=kNgP800000103Ng]h200000080g]kN0P0000030=kNgP8000001P3Ng]h2000000H0
g]kN0P0000090=kNg_l0oooo7P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>K0?ooo`030000003oool0oooo00D0
oooo1@3Ng]h2000000@0g]kN0P0000040=kNgP8000000P3Ng]h2000000<0g]kN0P0000060=kNgP80
00001P3Ng]h2000000T0g]kNo`3ooolN0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<i/0oooo00<000000?ooo`3o
ool01@3oool20=kNgP@000001@3Ng]h2000000@0g]kN0`0000000`3Ng]h00000000000030=kNgP80
00001@3Ng]h4000000D0g]kN0P0000090=kNg_l0oooo7P3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>S0?ooo`03
0=kNgP000000000000H0g]kN100000030=kNgPH00000103Ng]h2000000@0g]kN1P0000040=kNgP80
00001@3Ng]h200000080g]kNo`3ooolN0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<g80oooo1000000E0?ooo`@0
0000503oool00`3Ng]h00000000000020=kNgP8000004`3Ng]h2000000h0g]kN0P0000050=kNgP80
00000P3Ng]ko0?oooah0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cLP3oool2000001T0oooo0P00000D0?ooo`80
g]kN1@0000040=kNgP8000003@3Ng]h4000000X0g]kN100000020=kNgPD000000P3Ng]ko0?oooah0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c>@3oool6000000L0oooo00<000000?ooo`3oool01@3oool6000000H0
oooo100000040?ooo`@000000`3oool5000000@0oooo0P0000040?ooo`H000001@3oool6000000@0
oooo0P00000D0?ooobl0g]kN100000020=kNg_l0oooo7P3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<i0?ooo`80
00000P3oool2000000L0oooo00<000000?ooo`3oool01@3oool200000080oooo0P0000050?ooo`80
00000P3oool200000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000030?ooo`80
0000103oool200000080oooo0P0000060?ooo`@000001@3oool2000001@0oooo<03Ng]h300000080
g]kNo`3ooolN0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cX0oooo0P0000080?ooo`D000001P3oool2000000L0
oooo0P0000070?ooo`8000000P3oool2000000H0oooo0P0000030?ooo`8000001@3oool2000000X0
oooo0P0000060?ooo`800000503ooola0=kNgP8000000P3Ng]ko0?oooah0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>`3oool2000000T0oooo00<000000?ooo`3oool01`3oool2000000H0oooo0P0000070?ooo`80
00000P3oool2000000<0oooo100000040?ooo`8000001P3oool2000000T0oooo0P0000060?ooo`80
0000o`3ooomW0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo0P0000080?ooo`030000003oool0oooo00P0
oooo0P0000050?ooo`8000001`3oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0
oooo0P0000070?ooo`8000001`3oool4000000D0oooo0P00003o0?ooofL0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c?@3oool2000001<0oooo0P0000040?ooo`800000203oool4000000@0oooo100000040?ooo`80
0000203oool2000000D0oooo1P0000040?ooo`800000o`3ooomW0?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cT0
oooo0P0000020?ooo`8000003`3oool200000080oooo0P0000050?ooo`8000000P3oool2000001<0
oooo0P0000040?ooo`8000000P3oool2000000l0oooo0P00003o0?ooofH0oooo0P000?l50?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?ooo`@0
00004@3oool4000000L0oooo1@00000C0?ooo`@000000`3oool4000000h0oooo1000003o0?ooofD0
oooo00<0003o0?ooo`000?l01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooc0?ooo`040000o`3oool0oooo0000o`D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool01@00
0?l0oooo0?ooo`3oool0003o00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool60000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<coP0c<c<0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<coP0c<c<0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1@2IVIT2
03<c<`80oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@3o09VIVOl0VIVI1@2IVIT00`3UiND0<c<c0?ooo`010?ooo`0000<0oooo0>GUi@3UiND0
o`3UiNGo0>GUi@L0iNGU0P3oool00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell[TextData[{
  "There are some situations in which it is convenient to have several \
placeholders in a single button. Your current selection is typically inserted \
at the position of the primary placeholder, indicated by ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  ". Additional placeholders may however be indicated by ",
  Cell[BoxData[
      \(TraditionalForm\`\[Placeholder]\)], "InlineFormula"],
  ", and you can move to the positions of successive placeholders using Tab.  \
"
}], "Text",
  CellTags->{"S1.3.6", "6.18"}],

Cell["\<\
Here is a palette containing buttons with several placeholders. \
\
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.19"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001l0000CB000`400?l00000o`00003oO03oool0
00030?ooo`0c<c<0<c<c07P0<c<c0@3oool000030?ooo`3^k^h0<c<c07P0<c<c0@3oool000030?oo
o`3^k^h0VIVI07H0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT0MP2IVIT203<c<`40oooo0000
0`3oool0k^k^09VIV@1f09VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVIL03^k^h409VI
V@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVIK`0c<c<00`3^k^h0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<i05EEE@030=gMg@3oool0gMgM0300EEEE
00<0<c<c0>k^kP2IVIT00`2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0
oooo0=gMg@3MgMd0=@3MgMd00`1EEED0gMgM0?ooo`0`0=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c
<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM03D0gMgM00<0EEEE
0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI
0080VIVI0P0c<c<00`3oool0gMgM0=gMg@0e0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE03<c
<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3M
gMd0=@3MgMd00`1EEED0gMgM0?ooo`0`0=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`00
00<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM00L0gMgM1P00000X0=gMg@0305EE
E@3MgMd0oooo0300gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VI
V@0209VIV@80<c<c00<0oooo0=gMg@3MgMd00`3MgMd200000080gMgM00<000000=gMg@3MgMd00P3M
gMd00`000000gMgM0=gMg@0V0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE03<c<`3^k^h0102I
VIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd00`3MgMd0
1@000000gMgM0000003MgMd0000000@0gMgM00<000000=gMg@3MgMd09P3MgMd00`1EEED0gMgM0?oo
o`0G0=gMg@030000003MgMd0gMgM01H0gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo0000
0`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd2000000@0gMgM00<00000
0=gMg@3MgMd09P3MgMd00`1EEED0gMgM0?ooo`0>0=gMg@H000000`3MgMd010000000gMgM0=gMg@3M
gMd6000000l0gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@02
09VIV@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd7000002P0gMgM00<0EEEE0=gMg@3oool03P3MgMd0
0`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00@000000=gMg@3MgMd00000103M
gMd00`000000gMgM0=gMg@0=0=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM00H0gMgM00<000000=gMg@3MgMd0;03MgMd0
0`1EEED0gMgM0?ooo`0>0=gMg@030000003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd01@3MgMd0
0`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00d0gMgM00<0EEEE03<c<`3^k^h0102IVIT2
03<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd00`00
0000gMgM0=gMg@0:0=gMg@L000001P3MgMd3000000030=gMg@000000000000@0gMgM1`0000040=gM
g@0305EEE@3MgMd0oooo00P0gMgM0`0000030=gMg@030000003MgMd0gMgM0080gMgM00<000000=gM
g@3MgMd01@3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM1`0000030=gM
g@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`03
0?ooo`3MgMd0gMgM00H0gMgM00<000000=gMg@3MgMd02P3MgMd7000000H0gMgM00<000000=gMg@3M
gMd00`0000040=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0
gMgM0?ooo`070=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd6000000L0gMgM1P0000050=gM
g@L000000`3MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<00`3oool0gMgM0=gMg@060=gMg@030000003MgMd0gMgM00X0gMgM1`0000050=gMg@03
0000003MgMd0gMgM0080gMgM0P0000040=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3M
gMd00P3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3M
gMd05`3MgMd7000000<0gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^
09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd00`000000gMgM0=gMg@0:0=gMg@L00000
1@3MgMd00`000000gMgM0=gMg@020=gMg@800000103MgMd00`000000gMgM0=gMg@030=gMg@030000
003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd00`000000gMgM0=gMg@030=gMg@030000
003MgMd0gMgM01L0gMgM1`0000030=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM00H0gMgM00<000000=gMg@3MgMd02P3M
gMd7000000D0gMgM00<000000=gMg@3MgMd00P3MgMd2000000@0gMgM00<000000=gMg@3MgMd00`3M
gMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd00`3M
gMd2000001P0gMgM1`0000030=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM00H0gMgM00<000000=gMg@3MgMd02P3MgMd7
000000D0gMgM00@000000=gMg@3MgMd0gMgM0`0000040=gMg@030000003MgMd0gMgM00<0gMgM00<0
00000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM0080gMgM0P00
000H0=gMg@L000000`3MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0
VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@060=gMg@030000003MgMd0gMgM00X0gMgM1`000006
0=gMg@<0000000<0gMgM000000000000103MgMd7000000@0gMgM00<0EEEE0=gMg@3oool0203MgMd4
000000030=gMg@000000gMgM01L0gMgM1`0000030=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<1
0?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM00H0gMgM00<000000=gM
g@3MgMd06`3MgMd2000000l0gMgM00<0EEEE0=gMg@3oool0203MgMd010000000gMgM0=gMg@3MgMd2
00000280gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VI
V@80<c<c00<0oooo0=gMg@3MgMd01P3MgMd00`000000gMgM0=gMg@0J0=gMg@<000003`3MgMd00`1E
EED0gMgM0?ooo`090=gMg@<00000903MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool00003
0?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@060=gMg@030000003MgMd0gMgM02`0
gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@060=gMg@030000003MgMd0gMgM02`0gMgM
00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^
k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@060=gMg@040000003MgMd0gMgM0=gMg@H00000
9@3MgMd00`1EEED0gMgM0?ooo`0`0=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM00H0gMgM00<000000=gMg@3MgMd00P00
00040=gMg@030000003MgMd0gMgM02<0gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^
kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@07
0=gMg@@00000103MgMd00`000000gMgM0=gMg@0S0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE
03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gM
g@3MgMd02P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM02<0gMgM00<0EEEE0=gM
g@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080
VIVI0P0c<c<00`3oool0gMgM0=gMg@0:0=gMg@H000009@3MgMd00`1EEED0gMgM0?ooo`0`0=gMg@03
05EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?oo
o`3MgMd0gMgM03D0gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c
0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@0e0=gMg@0305EEE@3M
gMd0oooo0300gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@02
09VIV@80<c<c00<0oooo0=gMg@3MgMd0=@3MgMd00`1EEED0gMgM0?ooo`0`0=gMg@0305EEE@0c<c<0
k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM
03D0gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool00003
0?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@0g0=gMg@030?ooo`3MgMd0gMgM02l0
gMgM00<0<c<c0>k^kP2IVIT00`2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c
>@3oool00`3MgMd0oooo0?ooo`0`0?ooo`0303<c<`3^k^h0VIVI00<0VIVI0P0c<c<10?ooo`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM06T0gMgM00<0<c<c0>k^kP2IVIT00`2I
VIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo05EEE@1EEED0=P1EEED0
0`3MgMd0oooo0=gMg@0`05EEE@0303<c<`3^k^h0VIVI00<0VIVI0P0c<c<10?ooo`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM03D0gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1E
EED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0
gMgM0=gMg@0e0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40
oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd0=@3MgMd00`1EEED0gMgM
0?ooo`0`0=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<`030?ooo`3MgMd0gMgM00H0gMgM0P00000]0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0
EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo
0=gMg@3MgMd01P3MgMd00`000000gMgM0000000/0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE
03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gM
g@3MgMd02@3MgMd00`000000gMgM0=gMg@0Y0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE03<c
<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3M
gMd02@3MgMd00`000000gMgM0=gMg@0Y0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE03<c<`3^
k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd0
2@3MgMd00`000000gMgM0=gMg@0Y0=gMg@0305EEE@3MgMd0oooo01D0gMgM1P00000E0=gMg@0305EE
E@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3M
gMd0gMgM00T0gMgM00<000000=gMg@3MgMd0:@3MgMd00`1EEED0gMgM0?ooo`0E0=gMg@030000003M
gMd0gMgM0080gMgM00<000000=gMg@3MgMd04`3MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3o
ool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@090=gMg@030000003MgMd0
gMgM02T0gMgM00<0EEEE0=gMg@3oool05@3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0
gMgM01<0gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VI
V@80<c<c00<0oooo0=gMg@3MgMd02@3MgMd00`000000gMgM0=gMg@030=gMg@L000001`3MgMd30000
00030=gMg@000000000000<0gMgM1`0000080=gMg@0305EEE@3MgMd0oooo00l0gMgM0`0000030=gM
g@030000003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd00P3MgMd7000000X0gMgM00<0EEEE03<c
<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3M
gMd02@3MgMd00`000000gMgM0=gMg@030=gMg@L000001`3MgMd00`000000gMgM0=gMg@03000000<0
gMgM00<000000=gMg@3MgMd00`3MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00h0
gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@H00000103MgMd7000000X0gMgM00<0EEEE03<c
<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3M
gMd02@3MgMd00`000000gMgM0=gMg@030=gMg@L000001P3MgMd00`000000gMgM0=gMg@020=gMg@80
00000`3MgMd00`000000gMgM0=gMg@030=gMg@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3o
ool03@3MgMd00`000000gMgM0=gMg@030=gMg@030000003MgMd0gMgM00T0gMgM1`00000:0=gMg@03
05EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?oo
o`3MgMd0gMgM00T0gMgM00<000000=gMg@3MgMd00`3MgMd7000000H0gMgM00<000000=gMg@3MgMd0
0P3MgMd2000000<0gMgM00<000000=gMg@3MgMd00`3MgMd00`000000gMgM0=gMg@060=gMg@0305EE
E@3MgMd0oooo00d0gMgM00<000000=gMg@3MgMd00`3MgMd00`000000gMgM0=gMg@090=gMg@L00000
2P3MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c
<c<00`3oool0gMgM0=gMg@090=gMg@030000003MgMd0gMgM00<0gMgM1`0000060=gMg@030000003M
gMd0gMgM0080gMgM0P0000030=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd01P3M
gMd00`1EEED0gMgM0?ooo`0=0=gMg@030000003MgMd0gMgM00<0gMgM0P00000:0=gMg@L000002P3M
gMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<0
0`3oool0gMgM0=gMg@090=gMg@030000003MgMd0gMgM00<0gMgM1`0000060=gMg@040000003MgMd0
gMgM0=gMg@<000000`3MgMd00`000000gMgM0=gMg@030=gMg@030000003MgMd0gMgM00H0gMgM00<0
EEEE0=gMg@3oool03P3MgMd00`000000gMgM0=gMg@020=gMg@8000002P3MgMd7000000X0gMgM00<0
EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo
0=gMg@3MgMd02@3MgMd00`000000gMgM0=gMg@030=gMg@L000001`3MgMd3000000030=gMg@000000
000000<0gMgM1`0000080=gMg@0305EEE@3MgMd0oooo00l0gMgM100000000`3MgMd000000=gMg@09
0=gMg@L000002P3MgMd00`1EEED0<c<c0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI
0080VIVI0P0c<c<00`3oool0gMgM0=gMg@090=gMg@030000003MgMd0gMgM01D0gMgM0P00000B0=gM
g@0305EEE@3MgMd0oooo00l0gMgM00@000000=gMg@3MgMd0gMgM0P00000K0=gMg@0305EEE@0c<c<0
k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`030?ooo`3MgMd0gMgM
00T0gMgM00<000000=gMg@3MgMd0503MgMd300000180gMgM00<0EEEE0=gMg@3oool0403MgMd30000
01d0gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80
<c<c00<0oooo0=gMg@3MgMd02@3MgMd00`000000gMgM0=gMg@0Y0=gMg@0305EEE@3MgMd0oooo0300
gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c
00<0oooo0=gMg@3MgMd02@3MgMd010000000gMgM0=gMg@00000X0=gMg@0305EEE@3MgMd0oooo0300
gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^09VIV@0209VIV@80<c<c
00<0oooo0=gMg@3MgMd02P3MgMd3000002P0gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c
0>k^kP0409VIV@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gM
g@0e0=gMg@0305EEE@3MgMd0oooo0300gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo0000
0`3oool0k^k^09VIV@0209VIV@80<c<c00<0oooo0=gMg@3MgMd0=@3MgMd00`1EEED0gMgM0?ooo`0`
0=gMg@0305EEE@0c<c<0k^k^00@0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIT203<c
<`030?ooo`3MgMd0gMgM03D0gMgM00<0EEEE0=gMg@3oool0<03MgMd00`1EEED0<c<c0>k^kP0409VI
V@80<c<c0@3oool000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3oool0gMgM0=gMg@0e0=gMg@03
05EEE@3MgMd0oooo0300gMgM00<0EEEE03<c<`3^k^h0102IVIT203<c<`40oooo00000`3oool0k^k^
09VIV@0209VIV@80<c<c>@3oool00`3MgMd0oooo0?ooo`0`0?ooo`0303<c<`3^k^h0VIVI00<0VIVI
0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIU_03<c<`030>k^kP2IVIT0VIVI0080VIVI0P0c
<c<10?ooo`0000<0oooo0>k^kP2IVIT00P2IVIU_03<c<`030>k^kP2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>k^kP2IVIT0MP2IVIT203<c<`40oooo00000`3oool0k^k^09VIV@1f09VIV@80
<c<c0@3oool000030?ooo`3^k^h0VIVI07H0VIVI0P0c<c<10?ooo`0000<0oooo0>k^kP2IVIT0MP2I
VIT203<c<`40oooo00000`3oool0k^k^0>k^kP1g0>k^kP40<c<c0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{124, 77},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["Here is an expression in a notebook.", "MathCaption",
  CellTags->{"S1.3.6", "6.20"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool`3oool50000
o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>03oool=0=kNgPH00000
1`3Ng]h00`000000g]kN0=kNgP050=kNgPH000003P3Ng]ko0?ooohT0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cP0
oooo3`3Ng]h2000000T0g]kN00<000000=kNgP3Ng]h01P3Ng]h4000000l0g]kNo`3ooon90?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<h0?ooo`l0g]kN0P0000070=kNgPD000001`3Ng]h200000100g]kNo`3ooon90?oo
o`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<h0?ooo`l0g]kN0P0000090=kNgP030000003Ng]h0g]kN00L0g]kN0P00000@
0=kNg_l0ooooR@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c>03oool?0=kNgP8000002@3Ng]h00`000000g]kN0=kN
gP060=kNgP@000003`3Ng]ko0?ooohT0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cP0oooo3@3Ng]h400000140g]kN
1P00000>0=kNg_l0ooooR@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>03oool>0=kNgP<000009@3Ng]ko0?ooohT0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<cP0oooo3`3Ng]h2000002D0g]kNo`3ooon90?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h
0?ooocH0g]kNo`3ooon90?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooocH0g]kNo`3ooon90?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<h0?ooocH0g]kNo`3ooon90?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooocH0g]kNo`3ooon90?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<h0?ooocH0g]kNo`3ooon90?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooo`80g]kN<@000003
0=kNg_l0ooooR@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c>03ooolf0=kNg_l0ooooR@3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
>03ooolf0=kNg_l0ooooR@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>03ooolf0=kNg_l0ooooR@3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c>03ooolN0=kNgP@000002P3Ng]h4000000H0g]kNo`3ooon90?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h
0?oooah0g]kN0P00000>0=kNgP8000001P3Ng]ko0?ooohT0oooo00<0003o0?ooo`3oool0103oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cP0oooo1@3N
g]h5000000<0g]kN1P0000000`3Ng]h000000000000600000080g]kN0P0000040=kNgPH00000103N
g]h2000000H0g]kNo`3ooon90?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooo`D0g]kN0P0000020=kNgP800000
103Ng]h2000000@0g]kN0P0000020=kNgP8000000`3Ng]h2000000D0g]kN100000050=kNgP800000
1P3Ng]ko0?ooohT0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<cP0oooo2@3Ng]h2000000@0g]kN0P0000040=kNgP80
00000P3Ng]h2000000<0g]kN0P0000060=kNgP8000001P3Ng]h2000000H0g]kNo`3ooon90?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<h0?ooo`T0g]kN0P0000040=kNgP800000103Ng]h200000080g]kN0P0000030=kN
gP8000001P3Ng]h2000000H0g]kN0P0000060=kNg_l0ooooR03oool20000o`H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooo`H0g]kN10000005
0=kNgP800000103Ng]h3000000030=kNgP000000000000<0g]kN0P0000050=kNgP@000001@3Ng]h2
000000H0g]kNo`3ooon70?ooo`030000o`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooo`D0g]kN0P0000060=kNgP@000000`3N
g]h6000000@0g]kN0P0000040=kNgPH00000103Ng]h2000000H0g]kNo`3ooon60?ooo`040000o`3o
ool0oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<h0?ooo`D0g]kN0P0000020=kNgP8000004`3Ng]h2000000h0g]kN0P0000060=kNg_l0
ooooQ@3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<h0?ooo`H0g]kN1@0000040=kNgP8000003@3Ng]h4
000000X0g]kN100000060=kNg_l0ooooQ03oool60000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI
0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU
09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0@3UiND103<c<`40oooo003o0>GUiOl0iNGU2`3UiND10?oo
o`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell[TextData[{
  "Pressing the top left button in the palette inserts the expression in \
place of the ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  "."
}], "MathCaption",
  CellTags->{"S1.3.6", "6.21"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<803<c<`80oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c1`0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@D0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0`2IVIT203<c
<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0
VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooook`3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<c<0oooo1000000D0?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H0
0000o`3ooon=0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c80oooo00@000000?ooo`3oool0oooo0P00000E0?oo
o`8000002@3oool00`000000oooo0?ooo`060?ooo`@00000o`3ooon>0?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<cL0oooo00<000000?ooo`3oool04`3oool2000000L0oooo1@0000070?ooo`800000o`3ooon?0?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<cL0oooo0P00000D0?ooo`8000002@3oool00`000000oooo0?ooo`070?oo
o`800000o`3ooon?0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<2
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00000D0?ooo`8000002@3oool00`00
0000oooo0?ooo`060?ooo`@00000o`3ooon>0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00000B0?oo
o`@000004@3oool600000?l0ooooS@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`8000004`3oool30000
0?l0ooooY03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`800000503oool200000?l0ooooY03oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<g0?ooo`800000o`3ooonj0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00003o0?oo
okX0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c=`3oool200000?l0oooo^P3oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?oo
o`800000?`3oool6000000<0oooo00<0g]kN0000000000001000003o0?ooof/0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c=`3oool2000003h0oooo0P0000001@3oool000000000003oool0000000<0oooo00<0g]kN
0000003Ng]h00`3Ng]h00`000000oooo0?ooo`3o0?ooofT0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=`3oool2
000000L0oooo<@0000060?ooo`80000000D0oooo000000000000oooo000000030?ooo`030=kNgP00
0000g]kN00<0g]kN00<000000?ooo`3oool0o`3ooomY0?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00
000n0?ooo`80000000D0oooo000000000000oooo000000030?ooo`030=kNgP000000g]kN00<0g]kN
00<000000?ooo`3oool0o`3ooomY0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00000n0?ooo`800000
00D0oooo000000000000oooo000000030?ooo`030=kNgP000000g]kN00<0g]kN00<000000?ooo`3o
ool0o`3ooomY0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00000o0?ooo`@0000000<0oooo0000003o
ool00P3oool00`3Ng]h000000000000400000?l0ooooJ`3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`80
00008`3oool4000000X0oooo1000000<0?ooo`80000000<0oooo0000003oool0o`3ooomd0?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<cL0oooo0P00000S0?ooo`8000003P3oool2000000/0oooo1@00003o0?ooogD0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=`3oool2000000X0oooo1@0000030?ooo`H0000000<0oooo00000000
00001P0000020?ooo`800000103oool6000000@0oooo0P00003o0?ooohD0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c=`3oool2000000X0oooo0P0000020?ooo`800000103oool2000000@0oooo0P0000020?ooo`80
00000`3oool2000000D0oooo100000050?ooo`800000o`3ooon50?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0
oooo0P00000>0?ooo`800000103oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000H0
oooo0P0000060?ooo`800000o`3ooon50?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00000>0?ooo`80
0000103oool2000000@0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000060?ooo`80
0000o`3ooon50?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo0P00000;0?ooo`@000001@3oool2000000@0
oooo0`0000000`3oool00000000000030?ooo`8000001@3oool4000000D0oooo0P00003o0?ooohD0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c>03oool2000000<0oooo00<000000?ooo`3oool00`3oool2000000H0
oooo100000030?ooo`H00000103oool2000000@0oooo1P0000040?ooo`800000o`3ooon40?ooo`80
003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>@3oool4000000H0oooo0P0000020?ooo`8000004`3oool2000000h0oooo0P00003o0?oooh<0
oooo00<0003o0?ooo`000?l0203oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cA03oool5000000@0oooo0P00000=0?ooo`@000002P3oool400000?l0
ooooPP3oool010000?l0oooo0?ooo`000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonl0oooo00D0003o0?ooo`3oool0oooo0000o`08
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooonh0oooo1P000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<20?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2IVIT203<c<`80oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0P3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<20?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<coP0c<c<0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<coP0c<c<0103UiND0VIVI09VIV@2I
VIT203<c<`80oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1@2IVIT203<c<`80oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1@2IVIT203<c<`80oooo00000`3oool0iNGU09VIV@3o09VIVOl0
VIVI1@2IVIT203<c<`80oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU1P3UiND103<c<`40oooo
0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@80oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 54},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"],

Cell["\<\
You can move to the other placeholders using Tab, and then edit \
them to insert whatever you want. \
\>", "MathCaption",
  CellTags->{"S1.3.6", "6.22"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool@3oool5
0000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<P3oool4000001@0
oooo1P0000070?ooo`030000003oool0oooo00D0oooo1P00003o0?oooi00oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<c40oooo00@000000?ooo`3oool0oooo0P00000E0?ooo`8000002@3oool00`000000oooo0?ooo`06
0?ooo`@00000o`3ooonA0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<f0?ooo`030000003oool0oooo01<0oooo0P00
00070?ooo`D000001`3oool200000?l0ooooTP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000001@0oooo
0P0000090?ooo`030000003oool0oooo00L0oooo0P00003o0?oooi80oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cH0
oooo0P00000D0?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`@00000o`3ooonA0?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<f0?ooo`8000004P3oool400000140oooo1P00003o0?oooi00oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<cH0oooo0P00000C0?ooo`<00000o`3ooonW0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<f0?ooo`800000503o
ool200000?l0ooooY`3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool200000?l0oooo_@3oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c=P3oool200000?l0oooo_@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool200000?l0oooo_@3oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c=P3oool2000003l0oooo1P0000040?ooo`H00000o`3ooom^0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<f0?ooo`800000?P3oool2000000050?ooo`00000000000?ooo`0000001@3oool400000?l0oooo
K`3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c=P3oool2000000L0oooo<@0000060?ooo`80000000D0oooo00000000
0000oooo000000060?ooo`800000o`3ooom`0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<f0?ooo`800000?P3oool2
000000050?ooo`00000000000?ooo`0000001P3oool200000?l0ooooL03oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
=P3oool2000003h0oooo0P0000001@3oool000000000003oool0000000D0oooo1000003o0?ooofl0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<cH0oooo0P00000o0?ooo`@0000000<0oooo0000003oool00`3oool60000
0?l0ooooKP3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000002<0oooo1000000:0?ooo`@00000303oool2
000000030?ooo`000000oooo0?l0ooooM`3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000002<0oooo0P00
000>0?ooo`8000002`3oool500000?l0ooooN03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000000X0oooo
1@0000030?ooo`H0000000<0oooo0000000000001P0000020?ooo`800000103oool6000000@0oooo
0P00003o0?ooohP0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<cH0oooo0P00000:0?ooo`8000000P3oool2000000@0
oooo0P0000040?ooo`8000000P3oool2000000<0oooo0P0000050?ooo`@000001@3oool200000?l0
ooooR03oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool2000000h0oooo0P0000040?ooo`800000103oool20000
0080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P00003o0?ooohP0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<cH0oooo0P00000>0?ooo`800000103oool2000000@0oooo0P0000020?ooo`8000000`3oool2
000000H0oooo0P0000060?ooo`800000o`3ooon70?ooo`80003o203oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cH0oooo0P00000;0?ooo`@000001@3o
ool2000000@0oooo0`0000000`3oool00000000000030?ooo`8000001@3oool4000000D0oooo0P00
003o0?ooohH0oooo00<0003o0?ooo`000?l0203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<cL0oooo0P0000030?ooo`030000003oool0oooo00<0oooo
0P0000060?ooo`@000000`3oool6000000@0oooo0P0000040?ooo`H00000103oool200000?l0oooo
Q@3oool010000?l0oooo0?ooo`000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c>03oool4000000H0oooo0P0000020?ooo`8000004`3oool20000
00h0oooo0P00003o0?oooh@0oooo00D0003o0?ooo`3oool0oooo0000o`080?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c@`3oool5000000@0oooo0P00
000=0?ooo`@000002P3oool400000?l0ooooP`3oool60000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40
<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0
VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00o`3UiNGo0>GUi@X0iNGU0@0c<c<1
0?ooo`00o`3UiNGo0>GUi@/0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 54},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3.7 Special Topic: Hyperlinks and Active Text", "Subsection",
  CellTags->{"S1.3.7", "7.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " front end provides a variety of ways to search for particular words or \
text in ",
  StyleBox["Mathematica", "TI"],
  " notebooks. But particularly when large documents or collections of \
documents are involved, it is often convenient to insert hyperlinks which \
immediately take you to a specific point in a notebook, just as is often done \
on websites. "
}], "Text",
  CellTags->{"S1.3.7", "7.2"}],

Cell["\<\
Hyperlinks are usually indicated by words or phrases that are \
underlined, and are often in a different color. Clicking on a hyperlink \
immediately takes you to wherever the hyperlink points. \
\>", "MathCaption",
  CellTags->{"S1.3.7", "7.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:b000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c2@0c<c<00080iNGUo`0c<c?o03<c<`X0
<c<c00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT203<c<`0000<0iNGU09VIV@2IVIT0o`2I
VIWo09VIV@L0VIVI0P0c<c<000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c0000103U
iND0VIVI09VIV@2IVIWo0>GUiOl0iNGU0P3UiND409VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooool`3oool50000o`H0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo2P3oool300000>X0oooo00<0003o
0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<m80oooo4P000?l00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0>T0oooo00<0003o
0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<nD0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`3Y0?ooo`030000o`3oool0
oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<:
0?ooo`<000000P3oool300000080oooo0P0000020?ooo`<000000P3oool2000000D0oooo1P000005
0?ooo`<000000`3oool300000080oooo0`000000103oool000000000003oool200000080oooo0P00
00060?ooo`030000003oool0oooo008000000P3oool2000000030?ooo`00000000000080oooo00@0
00000?ooo`3oool000002@3oool300000080oooo0`000000103oool000000000003oool2000000H0
oooo00<000000?ooo`3oool00P0000020?ooo`80000000<0oooo0000000000000P3oool00`000000
oooo0?ooo`030?ooo`8000000`3oool2000000030?ooo`00000000000080000000<0oooo00000000
0000103oool2000000<0oooo0`0000020?ooo`<0000000D0oooo000000000000oooo000000020?oo
o`80000000<0oooo0000000000001@0000000`3oool00000000000040?ooo`80000000<0oooo0000
003oool01@3oool90000o`030?ooo`000?l0003o00<0003o00D0oooo0000o`000?l0oooo00000007
0?ooo`030000003oool0000000<0oooo0`0000000`3oool0000000000003000000030?ooo`000000
00000080oooo0`0000000`3oool00000000000030?ooo`040000003oool00000000000<0oooo0`00
00020?ooo`H0000000H0oooo000000000000oooo0000003oool3000000H0oooo0P0000020?ooo`H0
00000`3oool2000000D0oooo00<000000?ooo`0000000`3oool3000000040?ooo`00000000000?oo
o`8000000P3oool300000080oooo0P0000030?ooo`030000003oool0oooo09T0oooo00<0003o0?oo
o`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c
<`/0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo000000020?ooo`030000
003oool0oooo0080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`040000
003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo00000080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000
003oool000000P3oool00`000000oooo0?ooo`030?ooo`060000003oool0oooo0000003oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00H000000?ooo`3o
ool000000?ooo`0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000080?ooo`040000o`3oool0oooo0000o`80oooo00@0003o
0?ooo`3oool0003o0P3oool010000?l0oooo0?ooo`000?l:0?ooo`030000003oool0000000@0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`0000000`3oool01000
0000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo
0?ooo`0000040?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`00
0000oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000103oool01P00
0000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`00002N0?ooo`030000o`3oool0oooo00@0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<;0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000001@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0?ooo`8000001P3o
ool2000000030?ooo`000000oooo0080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool000001P3oool01@00
0000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`00
0000oooo000000L0oooo00@000000?ooo`3oool000001P3oool01@000000oooo0?ooo`3oool00000
00D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000P0oooo
00@0003o0?ooo`3oool0003o0P3oool010000?l0oooo0?ooo`000?l20?ooo`030000o`3oool0003o
00X0oooo00D000000?ooo`000000oooo000000030?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`0000001@3oool010000000oooo0?ooo`0000040?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?oo
o`0000040?ooo`800000103oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`80
000000<0oooo0000003oool01@3oool01@000000oooo0000003oool0000000<0oooo00H000000?oo
o`3oool000000?ooo`0000050?ooo`040000003oool0oooo00000:40oooo00<0003o0?ooo`3oool0
103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<`/0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0400000080oooo00<000000?ooo`3oool0
100000050?ooo`040000003oool00000000000H0oooo0P0000030?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00@00000103oool0
0`000000oooo0?ooo`04000000<0oooo00D000000?ooo`3oool0oooo0000000>0?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool000000?ooo`04000000@0oooo00<000000?ooo`3oool0
100000030?ooo`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`030?ooo`<0
00000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`060000003oool0oooo0000003oool000000`3oool300000080oooo
00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`<00000203oool010000?l0
oooo0?ooo`000?l20?ooo`040000o`3oool0oooo0000o`80oooo0P000?l;0?ooo`050000003oool0
00000?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0000000D0oooo
00@000000?ooo`3oool00000103oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool0
10000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3oool2000000H0
oooo100000020?ooo`040000003oool00000000000<0oooo100000030?ooo`050000003oool00000
0?ooo`0000000`3oool01@000000oooo0?ooo`000000oooo00@000000P3oool00`000000oooo0?oo
o`04000009X0oooo00D0003o0?ooo`000?l0oooo0000o`060?ooo`030>GUi@2IVIT0VIVI0080VIVI
0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool600000080oooo00@000000?ooo`3oool0
00000P3oool2000000050?ooo`000000oooo0?ooo`0000001@3oool00`000000oooo000000020?oo
o`030000003oool0oooo0080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003o
ool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?oo
o`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo0000
0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0
oooo0000003oool000000P3oool00`000000oooo0?ooo`030?ooo`060000003oool0oooo0000003o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00H00000
0?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
00000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000080?ooo`040000o`3oool0oooo0000o`80oooo
00@0003o0?ooo`3oool0003o0P3oool00`000?l0oooo0000o`090?ooo`030000003oool0000000<0
oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`8000000P3oool00`000000oooo
000000030?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`000002
0?ooo`040000003oool0oooo000000@0oooo00@000000?ooo`3oool000000P3oool00`000000oooo
000000020?ooo`030000003oool000000080oooo00H000000?ooo`3oool000000?ooo`0000030?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`02
000000050?ooo`000000oooo0?ooo`000000VP3oool01@000?l0oooo0000o`3oool0003o00H0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<;0?ooo`030000
003oool0oooo0080oooo00@000000?ooo`3oool0oooo0P0000020?ooo`050000003oool000000000
003oool00P0000050?ooo`8000000P3oool3000000D0oooo0`0000020?ooo`<000000P3oool01@00
0000oooo000000000000oooo00800000103oool2000000@0oooo0`0000020?ooo`8000000P3oool2
000000030?ooo`000000000000<000003@3oool00`000000oooo0?ooo`020?ooo`<000000`3oool2
000000@0oooo0`0000020?ooo`8000000P3oool2000000030?ooo`000000000000<000001@3oool2
000000<0oooo0P0000020?ooo`040000003oool00000000000H0oooo0P0000030?ooo`<000000P3o
ool01@000000oooo000000000000oooo00<000000P3oool200000080oooo0P0000000`3oool00000
0?ooo`02000000H0oooo0P0000090?ooo`070000o`3oool0003o0000o`3oool0003o0?ooo`020000
o`<0oooo00@0003o0?ooo`000?l0003o1`3oool2000000040?ooo`00000000000?ooo`<0000000@0
oooo00000000000000000P3oool200000080oooo0P0000030?ooo`<00000103oool2000000030?oo
o`000000000000<0oooo0`0000020?ooo`80000000<0oooo0000003oool00P000000103oool00000
0000000000020?ooo`<000001@3oool2000000<0oooo00<000000?ooo`3oool00`0000020?ooo`80
00000P3oool2000000040?ooo`00000000000?ooo`<0000000@0oooo00000000000000000`3oool2
00000080oooo00D000000?ooo`00000000000?ooo`02000009/0oooo0`000?l00`3oool0003o0?oo
o`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool07@3o
ool00`000?l0oooo0?ooo`090?ooo`030000o`3oool0oooo0180oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`2Y0?ooo`050000o`3oool0003o0?ooo`000?l01P3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<`/0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`1C0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
0000I03oool00`000?l0oooo0?ooo`090?ooo`030000o`3oool0oooo0180oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0ZP3oool010000?l0oooo0?ooo`000?l60?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<00004
0>GUi@2IVIT0VIVI09VIV@80<c<c2P3oool300000080oooo0`00000C0?ooo`030000003oool0oooo
03h0oooo2@00001=0?ooo`030000003oool0oooo01<0oooo0P000?l20?ooo`030000o`3oool0oooo
00D0oooo0P000?lC0?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`800000503oool00`00
0000oooo0?ooo`0E0?ooo`800000503oool200000:l0oooo00<0003o0?ooo`3oool0103oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom03oool40000
o`H0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooL0oooo00<0003o0?ooo`3oool0103oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooool`3oool50000o`H0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI0P0c<c<000030>GUi@2IVIT0VIVI0?l0VIVI
o`2IVIT709VIV@80<c<c00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT203<c<`00o`3UiNGo
0>GUi@/0iNGU0@0c<c<00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 43},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.3.7"],

Cell["\<\
Hyperlinks in notebooks work very much like the buttons discussed \
in the previous section. And once again, all aspects of hyperlinks are \
programmable. \
\>", "Text",
  CellTags->{"S1.3.7", "7.4"}],

Cell["\<\
Indeed, it is possible to set up active text in notebooks that \
performs almost any kind of action. \
\>", "Text",
  CellTags->{"S1.3.7", "7.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.3.8 Getting Help in the Notebook Front End", "Subsection",
  CellTags->{"S1.3.8", "8.1"}],

Cell[TextData[{
  "In most versions of the ",
  StyleBox["Mathematica", "TI"],
  " notebook front end, the ",
  StyleBox["Help", "SR"],
  " menu gives you access to the ",
  StyleBox["Help Browser", "TI"],
  ", which serves as an entry point into a large amount of online \
documentation for ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.3.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Getting Started", "SR"],
              " "
            }]], Cell[TextData[{
              "a quick start to using ",
              StyleBox["Mathematica", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["Built\[Hyphen]in Functions", "SR"],
              " "
            }]], 
            Cell["\<\
information on all built\[Hyphen]in functions \
\>"]},
          {Cell[TextData[{
              StyleBox["The Mathematica Book", "SR"],
              " "
            }]], Cell["the complete book online "]},
          {Cell[TextData[{
              StyleBox["Master Index", "SR"],
              " "
            }]], Cell["index of all online documentation material "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.3.8"],

Cell["\<\
Typical types of help available with the notebook front end. \
\>", \
"Caption",
  CellTags->"S1.3.8"],

Cell["\<\
An example of looking up basic information about a function in the \
Help Browser.\
\>", "MathCaption",
  CellTags->{"S1.3.8", "8.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005500019B000`400?l00000o`00003ooooooom6
ooooo`000_ooool00oodm?Com_KfooKfmP3oooKfmSgom_Kf00?ol_;booooooooool00Oooool00005
oooooonPX;3oRHVLokRha?n_[k`0B_n`[kd00on_[kco];K3okBe`P04okBe`P04okBf`onc]L;o[k2n
okBe`h?o];G200?o/;6ook6b_ona/[l0Cona/[l00on`/Kko/kC1okBf``05okBe`P03okBf`on`/Kko
/K:o00Ko/K:o00?o/K?0okRga?mUIG`00_ooool00006oooooon`/;cofMSRohZ<X_n;SJ;oR8ZOB?n9
RZ000on8RIooSXnToh>4V@04oh:3V005oh>4V?moP9GoRHVOoiRI[?n2PiH0P_n6Qi/00on3Q9WoT8nR
oh:3V01?oh62V005oh21Uon6QigoRX^Qogn0UOn3Q9P01?n2PiP03On1PYOoTI:VohF7W?n6R9goQHFL
oh:4VOn6QIgoPXBIohJ6WOmgMi7o_Kc;ok>c`?ocloD00Oooool00006ooooooni^L?o/K;2ogUhR?oo
oooolO7bAoo`l?403_o_ko3onOWhon_]k_nLWJSo/[>ook2a_Onb/koo/;6mok6b_On`/KkoZ:^dol?4
a?nXZKKoXZ>d?_nUY[@4ojBU]3koYJJd00CoXZ>boj:S/Oo9b<SomOOnCoo]k_@05_o`lOOom?GlojRY
/On][[_o/;6mok:c_on_/;co/K:mok:c_onPXk3obLW?onOSiOoJfMcok>_`onWYjooYincojNW[ono^
l_oWiNKoMgV@okBc`?ofm_H1ooooo`0000OooooookRg`Onn`<ooGem`ooCalOoThNGohMoS04Koh]oS
00koh=gRonk[kOo>c]?oiNKZomSIjOoLgN[omoWoon[/o?oGf>GoinSeomCEfOnOX:[onocoom?Ci1Go
f]_Y5_oIfnT:om[Jj@Sof]_Y00KofM[Xon7Pk_oQh_3ohMo]on7Rl?oIf^P8om[Kj@[of][Y5_oJfnTD
omWKj@04om[KjOoCe>Gok^ojok^m`e7ooooo01GonOSholK8c?oZjoKofmcYooCfooo^koooemSTomOH
j?o`lOOo][JlooOfn?oThn[o/ZfAooOfnon^ZI3ol_;fokB_Too_k_3oQXROok2b_oofm_H00Oooool0
0006oooooonh]l7o_Ko>ofATMooem?;oh^7UAooPgn<03_oNg^;ojn[]om?Ce_oFemoob<WJoooooolf
<S?oKVicon7Sloo>d=kod<oFojJW/?o[k?Oob<_H2_o?d=`;olo@gP03om7@g_o@d=kod=3N01;od=3N
00?odM3NoloBgOo?d]d02?o?d]d7olo@g@03oloAg_oCd^3o^;[700;o_;k=00?o^;c8omCDh?o?d=`0
1oo?d=`:oloBgP_ocm3L2oo?d=h00ooAd=kod=3Nom3@gP0Aom3@gP06om7@g_o;c=[oh^?]ok^l`_oo
oooon_[mCOoinO`05ooinO_oooooonk_l_o4aL[oeMKUom_Mk_lG4a3oY:F^ooGgoonm_/ooh>7WokNg
_oo/jngoh=oTon3Pi?oJfN3ol_;fon_Xk_ocm?SojnW[oh:4Vona/[oom_Kf007ooooo00001_oooooo
^;O1okfoc_mTI7OomOCbon;QiDOoh=oS00oogmkRoncZkOo@d]GofmcTomkPmOmBD5?o9RDRomKFj?oB
dn?oe=GUolk?e?nSY:conOSoomOFhOoKgND02OoKg>D;om_MiAGofmcU00?ofmgUom_JiooKfnH03_oK
fnH02OoLfnOoeMGSono_n?no`lKoaLO=olW>dOn_]Kgogmk/omcKi`07om_Ki`[ofm_U00?ofmgUom_L
iOoKg>D02?oKg>D;om_MiACofmcU00KofmgUomSGhoo]koKo^K[1oooooooknoa=oo[jn`0GooWinooo
ooook^oaol?4booGf>Oofmg_oijOZOl40`3oYZJaomSKkooRh^_o]kNnongZk_oOg^;oi^GZomoNi?n_
ZXkoko3dok2[T?oXincoQXFLok6b_oofm_H00Oooool00006oooooonh]l7o_Ko>ofATMooem?;oh^7U
AooPgn<03ooOg^;ok>_]olc>doo]k_Coe]?No`000?ng]/3oooooom?Cg?o[j_?ocloEoijPZooooooo
h^;YonOVk@09onKVk@03onKTkOoViNgoi^G]00Ooi^G]00?oinC]onGVkOoUi^d05?oUi^d00ooWi^go
i^K]onKVk@0=onKVk@09onOWkOoTi>[on?OjokBj`?nl`LWo`<C:oj^a^_o_k_CoinO]00Koi^K]00?o
inO]onGUkOoUiNd02?oUiNd00ooWi^goi^K]onKVk@08onKVk@03onKTkOoViNgoi^G]00Ooi^G]00?o
inC]onGVkOoUi^d04ooUi^d01OoQhn[on?OmokJh`?olo?gon?Oj04gomoKi01Oom_KioogmoooYjNko
a<C9on_Zl_oPh>_oooooob@P8OlY:2KooOgoonc/lOnc/k_okN_^omoNh_oPgn?oh^7Von7Pi?oJfN3o
n?Smon_Yjon2Q9_o/K:oooKfmP01ooooo`0000KooooookRg`Onm_lkoI6AgooGcl_oRhNE7on3Oh`08
omkMh_o/jngobl[Bon3RiOooooooo?goo`000?nHUYT2ooooo`05olk@e_nNWZSoooooonCTjooYjNd0
2OoXj>d;onSYkAKojNS]2_oXj>l6onSXk@09onWYk_oUiN_om?CfomSJg_oLg^;ogMoUom7Df_o[jnoo
jNW^00Ooj>S]2_oYjNl;onSXk@_oj>W]5?oYj>d01_oYjNgoiNG/oocloone]kkoloCkoo;cn4golO;g
00Col?7gooOhoOoRhnco`/;80_ooool02?l<2PWo<c8`oooooooinogom??eok2a^Oo^jnkogmkR0_oP
gn<01ooViN[og]kTokB_TOo/jnkoQHFLok6b_oofm_H00Oooool00006oooooonh]l7o_Ko>ofEUMooj
n?Koi^GZAooThnL01?oSh^Kol_7bol?3boocl_D2ooooo`08on_ZjOoZj^OooooooooooooDdm[oSHnN
ooooooomoOlmooooo`03oogmoooooooooooo043ooooo00Goo_kooooooon`[kWol??hoo3bmP1=onka
m@04onk`mOofn?cofmgUolC3bP;ooooo00?oaL?2ooooooooool00_ooool00onVY;;ok^g^omkMhP03
omoNhP06on3Oi?oViN[of=OLohN8WOna/[oom_Kf0Oooool00007oooooonh]l7o_l3?oeaLK?oRh>7o
eMCIom?AeP16om?BeP0=om;AeOoHe]_ogMoRoj:RZ_oKf]kobl_@onCUj_oMgN;oc/kComWGg_nNXJWo
[k2hom[JgP0oom?Ce`Cod];F?ooCdmL01?oDeMSo[Jjjonobn?oWj_1>onOYl00=on[/loo/k_GoVYbS
omGCeoo=c]?ojncaomKFfoo=c]?of][MojZ/]Oni_<;omO7eonk]kP03ong/kP06ong[kOohm_Soi^CW
ohF7Vona/[oom_Kf0Oooool00006oooooonh^<;o];G6ohJ6UooPhMcoa<G7B?o6a/P03Onl_<7ooooo
ooCek_o]k>SokngYong[j?o]k>SokngYon_Zi_omnoGoooooonSXi_o]kN/0P?o]kNX01?o]kN_oj^[W
oo_kn?ocm?Y?oo7bmP0>oo3am_ofmocooOgeoncZioo_kNWok>_Wonk/j?o^kNWokNcXooGckooooooo
`/;;ojj`^?nj^/82okVi`@06okZj`Onf][ko`/;:oi:CZOn`/Kkom_Kf0Oooool00004ooooooni^L?o
Z:ZiojNW]ooooooo=Oooool03?oblN_o[ZnfomOHi_o:bmWocLkLol_<f_o8bM[ogn3[ojj`^?mnOiGo
];K3ooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00cojn[Vol;4b_oGf>KocLkO
onSZn_oOh?3o`lCBon;Sl?o4`lWoNWbAokNf`oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aoooo
ooleooooo`0<on_[ioo0_lKohnCcoocloolN71[oYZJ_oo;doooMg^Wo`/?9og]lT_nf]/?om_Kf0Ooo
ool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oZj^KoalO=ong_oolP7Qgo=C8ao`000?nJ
W:Kom_Oool71aomjO9;o][K3ooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00co
jNWUomSHh?nYZJgo7A/JoooooonXZJoo6aLGooooooo2`/WoNWZAokJf`oofm_H1ooooo`0000Cooooo
okVi`onYZk[oXJ6aooooooleooooo`05on_Yi_nj_<?oooooooooooodm_P00oooool01?nn_LCoN7ZB
okNf`oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`03onOUhonn_/Gooooo00Go
oooo00Co_Kk5ogEfS_ng]lCom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?ol
o?CoVYbUomOFg?oDe=Sod];Gom7Ae_oDe=Sof]WOoiZMY_n<SJ7o/k;0ooKfmP7ooooo00001?oooooo
^KW3ojV[^_nQXK7oooooocGooooo00com_Kjonc_m_oRiN_oj>W`ono_looaloGolO7fooknooodlo[o
Q8JLok2b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo3_m?oZk??om?Gi
ooCenoojn_goo_gooogmooooooool?7eoh21V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q
/Ooooooo=Oooool01Ooal_OoinW`onk`mOo`lOOom_Ki00;onOWk00Goooooong^m?n1PYSo/K:oooKf
mP01ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Wo
n_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Ooo
ool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo0000
1?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWloooo
ooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oW
jO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?o
ZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo
/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;g
ooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aoooo
ooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Ooo
ool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooi
nOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00co
lO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000Cooooo
okVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkd
oh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onka
mOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQ
XK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oof
m_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Wo
n_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Ooo
ool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo0000
1?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWloooo
ooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oW
jO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?o
ZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo
/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;g
ooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aoooo
ooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Ooo
ool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooi
nOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00co
lO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000Cooooo
okVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkd
oh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onka
mOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQ
XK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oof
m_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Wo
n_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/C?ooooo00?o
Fe]Kooooooooool0o_ooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo
/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK44ooooo`03ojn_[oo^k^kooooo00Kooooo01?o
GUiNoooooooooooodM7Aol71`On=SHgo/K6aojJVY_oooooo[Zj^om;Bd_mfMWKoooooof=SHooooooo
bl_;ofm_KoooooooHf=S00?ooooo01_oLG5aoeIFE_mUIFGoWIfMomkNg_olo?coU9BDonk^k_nWYjOo
QhN7okJf]_ne]KGoe]KFojRXZ?oNg]ko^;Rho`000?n2PX;oooooomCDe?nEUIGoooooofe]KOo0`<3o
ooooohB4Q?n2PX80m_ooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo
/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK44ooooo`03of5QHOlT92Cooooo00Kooooo01?o
0000oooooooooooo0000oo3`l?l0003oCdm?oc`l??oooooo0000ooooool0003oooooo`000?n`/;3o
:2PXokFe]OoalO7o000000?ooooo01co0000ooooooooooooinOWocXj>_lg=cOoh>3Po`000?o^k^ko
0000oeADE?mIFEWoWYjNod10@?nXZ:So<c<coa@D5?o:b/[o;Rh^ogQhN?ln?SkoE5ADoh^;RonNWYko
oooook:b/_lD51CoCdm?mOooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1
PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK44ooooo`04og1`L?oYjNWoKVi^ooclo0Go
oooo01?o0000oe1@D?o=cLgo0000ooooool20P;oGemOoe=CDooooooo0000ooooool0003oooooo`00
0?m[Jf_o9BDUodU9BOmjNW[o000000?ooooo01co0000ofIVI_mMGEgoooooocTi>Ol0003ooooooj^[
ZooLg=co0000of=SHom/K6co[:b/odQ8B?nj^[[o<S8bo`H61_oooooo0@41of][JomJFU[o2PX:oi6A
TOl0003ogMgMoa<C4omjNW[on_[jmOooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcooooo
ong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK44ooooo`04of1PH?ooooooXJ6Q
ohn?S`Gooooo01Co0000oooooooooooo0000ooooool0003oFUYJoaDE5Oo@d=3o0000omGEeOl0003o
[jn_odA4A?ooooooE5ADodQ8B?oooooo0000oiFEU@;ooooo01co0000ooooooooooooQhN7og1`L?nT
Y:CoGUiNoogmoOm9BDWoGUiNoh:2P_lE5AGoPH61ofQXJ?mADE7oclo?o`000?m`L73oWinOoiRHV?lj
>S[on_[jobh^;_nGUiOoo?clob<S8omIFEWo`L71mOooool03?oal_KoinW`onkamOoal_OomoKioo[j
nooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK44ooooo`03ogmo
Oom]KFgoWinO00Kooooo00?o0000oe1@D?nj^[X01_ooool00ol_;booooooo`000007ooooo`07oo[j
n_ooooooooooo`000?mRHV;oIfMWoo_kn`02ooooo`03ookno_ooooooiNGU00[ooooo00CoJ6QXo`H6
1_oooooolO7a0oooool00ooinOWoooooooooo`3dooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[k
ooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/@Cooooo00?oC4a<
ogAdM?ooool01oooool00ooTi>Col_;booooo`0Cooooo`03on_[jooOgmoooooo0?oooooo3_ooool0
3?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oo
oooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]
k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3o
k_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^j
oj6Q/Ooooooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:o
ooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOf
nOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aoooooole
ooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool0
0004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOco
ooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK4=ooooo`03oeIFE_mIFEWo
H61P0?ooGemO8OmOGel04?mQHF7o@D51okFe]OoooooolO;fonOYl?o^lOGolO;gooOfnOojn__onOWl
ooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6a3Oooool00ooVi^KoinOW
on[ZjP3oon[ZjR;oj^[Z00oohn?SooGemOoooooolO;fonOYl?o^lOGolO;gooOfnOojn__onOWloooo
ooo]k_CoPH:Hok6b_oofm_H00Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oal_Ko
inW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oooooo^KW3
ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:H
ok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7b
moogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooo
oooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7o
oooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__o
nOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6a4Oooool00oogmoOo
n_[jooooo`02ooooo`03ooKfm_oooooooooo00Gooooo00Con_[joooooooooooon?Sh2_ooool00oog
moOono_kooooo`02ooooo`05ooCdm?ooooooooooooooooogmoL00_ooool01?oemOGoooooooKfm_ok
no_hooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Ooo
ool00004ooooooni^L?oZJ^joj6Q/@gooooo00kobLW9oeQHF?m[Jf_ooooook2`/?l0003ooooooiBD
U?m=CDgo20P8oooooomkNg_oeMGEoa4A4@;ooooo00GoEEEEof9RH_nUYJGoPh>3og=cL`02ooooo`0B
o`000?ooooooooooo`000?nBTY;oJf][on?Shooooooo0000oiBDU?mADE7oT92@oi:BT_m=CDgooooo
og]kNonATI7oIVIV0_ooool01?l0003oU9BDomkNg_oMgMghooooo`0<oo7bm_oWjO3ok_7eoo7bmoog
m_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/@gooooo
00?oO7alo`000?l000000_ooool02_n2PX;oh^;RogalO?l0003oKFe]onSXj?nYZJWo8b<SodA4A?mh
N7P2ooooo`04oifMWOnYZJWocLg=oh20P0;ooooo00OoCTi>ogEeMOoooooo51@Dohj>S_ooooooBTY:
00;ooooo00WoRHV9oooooomRHV;oHV9RoooooomIFEWo^;RholW9bOn1PH400oooool00omMGEgooooo
ooooo`3hooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf
0Oooool00004ooooooni^L?oZJ^joj6Q/@gooooo00?oOWino`000?l000000_ooool04?nKVi_o=SHf
omSHf?nPX:3oYjNWodi>C_m5ADGoh^;RodI6A_mdM7CooooooifMWOmNGUkoD51@ob0P8?m@D502oooo
o`0Boj:RX_miNGWoXj>Sooooool61PKoYjNWo`000?m/K6cok>c/oda<C?nk^k_oCDe=oooooolZ:R[o
emOGocPh>?lR8R;oBDU90oooool00om?Cdooooooooooo`3hooooo`0<oo7bm_oWjO3ok_7eoo7bmoog
m_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/A;ooooo
00Oojn_[o`000?oooooo@D51ookno_oooooono_k00Gooooo00?o/k>conk^k_ooool00oooool01?m=
CDgomOGeojJVY_mhN7P5ooooo`05onk^k_oooooo^;RhooOgmooclo<01oooool00olc<c?oo?cloooo
o`3hooooo`0<oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Ooo
ool00004ooooooni^L?oZJ^joj6Q/A;ooooo00Go@T92okfm_OooooooBd];oiZJVP07ooooo`03ooCd
m?oooooooooo00?ooooo00CoBDU9okJf]_oemOGo820P1oooool00ooemOGono_kooooo`07ooooo`03
oeYJF_o^k^kooooo0?Sooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:H
ok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<oo7bm_oWjO3ok_7eoo7b
moogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooo
oooo=Oooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7o
oooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__o
nOWlooooooo]k_CoPH:Hok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6aooooooleooooo`0<
oo7bm_oWjO3ok_7eoo7bmoogm_Won_[kooWio?ooooookNkdoh62V?na/[oom_Kf0Oooool00004oooo
ooni^L?oZJ^joj6Q/BOooooo00cocm;Tog1g/On:T;ooR8fmohV?__n7SKgoR8jnohZ@_on9SkkoR8fn
ohZ?_on:T;l2ohR>_P08ohZ@_on9SkkoR8fnohZ?_on9SkkoRHjnogEk/_o1`n42ooooo`05omOJj_m`
NK7oRXnoohV?_on:T;l00_n8S[h01?n:T;ooRHnnohR=_OmiP;H3ooooo`0>ohjB_omoQK[oRHnnohZ@
_on8S[koQhfmohV?__n:SkooQhfmohR>__n6S;koUY_5ok:geonDUl@3ohR>_P0?ohZ@_on9SkkoR8fn
ohV?_on8S[koR8fmohR=__n9S[koR8jnohV?__n5Rkco[kCDojJ[comcNK7o];KJ00;ooooo00kohNC^
og9h/On8S[koRY2oohV?_on7SKgoR8jnohZ?_on8S[koQhfmohV>__n8SKgoYjc@ojV/d0;oQhfm0on8
S[h04On:SkkoQ8Zmoi>Ia?nh_MWoSI?0ohR>__n:T;ooR8jnohN=_On8SKgoQhfmohV?__n7SKgoRHno
ohV?__mjP;OoWjC:0:7ooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:H
ok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6a:Oooool00oono_ooooooooooo`02ooooo`05
ono`m_ooookoooooooGfn_o_l?H00_ooool01Oo]kOKoooonooooooobl_Soooko00;ooooo00Co^K[0
ooShmOoooooonocm0_ooool02Oogn?[oko3eooooooooooool?3fooooo_oooooom_OlokRh^@02oooo
o`04on[[mOooooooooooon[Zl`?ooooo00SomOGjooooooooooooooooomSJjOmiO[Gon?WjooShnP;o
oooo00Cojn_cooooo_oooooomOGh1Oooool03Oolo?goooooog9g/Onb]=Gooooooko0aOo^k^gooooo
oo_ko?odmO[ooooooo7anOohn?X00_ooool00ooaloSoooooooooo`02ooooo`03oiZMa_nWZ/oooooo
00Cooooo00Com_OkoooooooKg>goFf6U0_ooool00oo/k?Goooooooooo`02ooooo`03ooknoooooooo
mOKi0:Cooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1
ooooo`0000CooooookVi`onYZk[oXJ6a4Oooool02?n[Zj_o7alOokfm_OooooooF5QHooooooo6a/Ko
QXJ60_ooool08oo9bLWoEUIFofYZJ_m[Jf_oADE5olW9bOooooooADE5ojVYZOooooooVYZJooooooo?
d^GoVYo8oooooonAUl?og^3]ohZ?_on4RK_oooooon[ZmOm_M:ooo_gmoooooon8SKko[[?CoooooooY
jOCoKW>_oooooooFf>WoKgF`oo?coonf/jSo3Ph?00;ooooo00co]KWFoiJKa?ooooooooooojBVc?n4
RKcooooooo7amom/Ljkoooooo`000?o@d=02ooooo`0PohjD`?nh_=Wooooooj2TbomnQ;WoalOPoo[j
o?n2R;_oR8blooooooofm_coDU^PogQo]_ooooooTYS4ok:deOooooool_;hofab[oooooooZZkAoiFH
a?n<T<3ob<[QokNif?oinoco]KOFolG9h?lkAY?ok>goom[Ic?l00002ooooo`0Gon_[m?mbN;7ooooo
ooKfnOn5R[coP8Fioooooon[[M7oQ8Zlok6deOooooooXJC;odE@Voo:c>7oWZ?:ohb@`Onf^]OoVYk8
oooooonCUlCoooooodaGW_n0QKT00_ooool02on_/mCoVIc7oiZOb?nFVLGoh^;^ogf3]ooooooo^;[H
ogn5^Onl_]ooZZRP0:3ooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:H
ok6b_oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6a3Oooool03?mnOWko0000o`000?ooooooYZJV
oooooon8R8So=CDeokVi^One]KGoGEeMok^k^`;ooooo00[oJVYZog=cLonm_KgoDe=ColG5aOm;Bd_o
CTi>oogmoOmXJ6Soe=CD0oooool05Old?8ooPhVkof9YZOooooooKWF_ooooooomo_koLWR_ooooooo`
loOoWj?:om;Cioo>dNGoknogogZ0]_ooooooPXRjoo?cn?oTi>ooUi[6omkQk003ooooo`0:ohJ=__oo
ooooQH^kokbofon_]=;ooOcooooooom^MZoooooooloCiPCooooo00GoPHRjol?6g_ooooooSY?1ol[=
hP02ooooo`0Hoh^B`?ng^mWoooooofef[_ooooooPHJjoooooon8S[ko^koJoooooomYLJcoooooohjD
`?n[[M7ogMo[om3BiOoemOSoWZ?:ofA[Z_oooooo_L3Koo3bn?n//=?o`LCK1?ooool01?m>F9kooooo
oooooomSK:/3ooooo`0KoeIMXOooooooZ:g?omGHjOoGfNSod=;UogV0]Ooooooo/kOFoogno_mKI:Go
Z:g?oooooon8S[koooooogj4]ooDe^So_/;Loj:Uc?nk_mWoOhRioooooomXKj_o`lKOol[=h?o6b^7o
YZ[@0:7ooooo00colO;fonOYl?o^lOGolO;gooOfnOojn__onOWlooooooo]k_CoPH:Hok6b_oofm_H1
ooooo`0000CooooookVi`onYZk[oXJ6a3Oooool00omlO7co0000o`000002ooooo`07okBd]?mkNg_o
Ng]ko`L71omhN7So=3@do`X:2P02ooooo`0:ofIVI_l0003oo_knogIfM_m5ADGo_knooeMGEoohn?So
J6QXomCDe0?ooooo00Go/;GEoeILXoojn_cooooooc4kSP02ooooo`05og9i/_oooooogn7_oj2UbooT
i_400_ooool01_m`N;3oooooogn5^OooooooKGJaof]a[PGooooo00WoQhfmoo_koOni_=OoFf>Vod]D
WOo_l?KoOX>goooooonl_]X01?ooool01OnY[]7ogn3]oooooon;T<3oOhNi00;ooooo00ooRi:oomKH
j?ooooooMgfdonk^m?m2BiOooooook6ee?oIfnWoooooofQ`[?ooooooQhfloo7cnOlM:8@00_ooool0
1on>UL;oIFb[oooooonKXLSoUY[5okNle_o9c><01?ooool01OmoQ;Oooooooooooolb>hoomOGi00;o
oooo01_oJ72/oooooonVZlgoeMSXog1g/OoIfn[oP8Fjof1WYoooooook>gcoe]TY_n^/=;ooooooc8k
S_ooooooOXBgoooooomiOkKoAe6KooKhnom>EIgomoKjoiFLa_o9c>;ob/gQohnC`?o<d>@0XOooool0
3?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo00001?oo
oooo^KW3ojV[^_nQXK4=ooooo`06olW9bOmHF5SoJf][oooooonIVIWoXj>S0_ooool01?mlO7cooooo
om3@d?n/[:`2ooooo`0;ojf][Oo3`l?oooooofi^K_oooooo=3@doooooom@D53oZ:RXoooooonJVYX0
0_ooool04?o?d>CoJ6n/ooooooo=d>?o[;7AohjC`OooooooiNGaoeaUY_o>cnCoZk7AomGFj?o0`]go
ookoonOYl_mTK:X2ooooo`03ojZ_d_n5SKgon__m00?ooooo00[oJG6/okRleon//M7ooooooj>WcOo6
b^7oooooonGTl?mQJZ[oYJW=0oooool07oo4b=ooUY[5okbnf_o@d^Ko[K7Bok>feOnd]mKonOWloeaT
Y_omoOooooooom[LjonTZ<koX:G<okVlf?nSZ<go];WGolk@i?oloOooGFJVoooooonVZlkoPXRkolG8
h?ni_=Wo/KGCooGgnonLX<So];SGokFie_nX[<l00oooool02_o=d>?oeMKXogEl]OoUio7o]kWGokBj
e_nBUl?ooooooiBIaOnHW<L2ooooo`0HoiVNb?nm`]co];SEofee[onj_M[odM;UohV@_oooooooUYc5
olK8gon`]]GoUY_5ooCdnOooooooY:[>olc=hooin?_oXjW=oiRLa_oalOSooooook6ee?m[M:ooa<ON
XOooool03?oal_KoinW`onkamOoal_OomoKioo[jnooinOcoooooong^m?n1PYSo/K:oooKfmP7ooooo
00001?oooooo^KW3ojV[^_nQXK4Aooooo`04oj^[ZomaLG7o0000ooCdm0Sooooo00?oVYZJoc0`<?oo
ool02?ooool00oo?d^GoZJgAooooo`08ooooo`03oi2D`OmXLJcoo?gn00[ooooo00?of=SYoj2Tc?nl
`=/02_ooool01?n0Q[[oT9O3oh27^OnTZ<h4ooooo`03on[[loo]k??ooooo00?ooooo00CoQHblohjC
`_n3R;coWj?:0oooool01?nDV/CoXZO<ogQn]?ojnod9ooooo`05omWLjom`M[7oWJ;8ofec/?ohn?/0
1?ooool00oo?d^Coooooooooo`02ooooo`04ooKgnon0QkWoWJ;:oiBHaA3ooooo00?oVIo7onWZm?oo
ool0X?ooool03?oal_Koi^S_ong_m?o_l?KomOGhooShn_ohn?_oooooonc^m?n1PYSo/K:oooKfmP7o
oooo00001?oooooo^KW3ojV[^_nQXK4Booooo`03on;Rh_ogmoOooooo00Sooooo00?om_Kfoooooooo
ool0oooooolEooooo`03ong^m_obmo_ooooo00Gooooo00ConOWmogn1Uona/[oom_Kf0Oooool00004
ooooooni^L?oZJ^joj6Q/Ooooooo=_ooool02oo8bm?o[:bkokbmbOnn_lWo`L7;olK5cOo6am3ocloC
ohnAYOn`/Kkom_Kf007ooooo00001?oooooo^KW3ojV[^_nQXK7oooooocGooooo00col>kWojZ//OoS
iNgocloLolk?g?o8bMKo_[oBom3Ah_n][K?oOX2EokBf`oofm_H1ooooo`0000CooooookVi`onYZk[o
XJ6aooooooleooooo`0<onSXi?no`LSooooooo;bm?o^k_;oh^;/olo@g_oVio?oa<?9ogYjTOng]/?o
m_Kf0Oooool00004ooooooni^L?oZJ^joj6Q/Ooooooo=Oooool03?oZjNCo_ko6oooooooWingoi>K[
om_LiOo=c=[oh>;^ol?3bOmjO9;o][K3ooKfmP7ooooo00001?oooooo^KW3ojV[^_nQXK5Fooooo`0?
ooOgnOofm_[ok>geoo[jnoo^koKol_;gooOgnoo]k_Kom_OjooKfn_oinO_om?Cioo_lo?o^k_KonOWk
00;om_Kj00kolo?gonk_mooin__om_Okono_moodm?Sol_?hoo[ko?o_l?Oolo?gooKfn_oko?coloCh
oo3am`_ooooo01oom_OiooWio?o^koKol_;gooOhnoo/kOGomoSkoo7bmoobl_OomoOkooOgn_oemO[o
moOkooKgn_oalOOon_[kooGen_ogmo_ok^ofooOhnooko?col?7foo;cmoofm_[onOWkoo[jo?oal_Oo
m?Choo3amoolo?cojn_d09Gooooo00coj^WTokjoa_ooooooj>S]onGVk?oKgNGocLcKon3Rk_o3`lWo
NWbBokJf`oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6a4_ooool01ooPh>3ooooooooooooQhN7o
oooooogmoOoclo<00_ooool00oojn_[onOWiooooo`02ooooo`03oogmoOoooooon?Sh00;ooooo0_oi
nOT2ooooo`03oo[jn_oooooooooo00;ooooo00?onOWiooooooooool00_ooool00oono_kooooooooo
o`05ooooo`03ookno_oooooooooo00;ooooo00Col_;boooooooooooooooo0_ono_h01Ooooooog=cL
oo[jn_ooooooj>SX00;ooooo00?oj>SXooooooooool00oooool08_o/k>coooooonOWlOmJHJGoR8no
ojncdomdNkGoWJ;9oiBKaOn0Q[[oWZC:oh^A_on1Q[[oRY2ooi^Ob?m[LZooY:W=oh>9^on9T;ooSI?1
ohB<_?nBUl;oQ8VlohB;^on@U/;oOHFhohZ?_on3RK_oS9:oohN<__n0Qk[oKgF`ogZ1]oni_MT2oooo
o`03ooCdm?ojn_[ooooo00;ooooo02GolO7aooGemOoooooooooooiZMb?mQJ:SoYZ[?oiNNa_mgO[Ko
[K;Bogb2]_nGW<OoU9W4oh>9^on3RKcoV9k7oh68^On5RkgoV9o7oh26^OnAUL;oPhZkoiJLaOmiO[Go
K7>_ojBXcOn6S;coOhBiohV?_omnP[OoUY_5ogf2]onTZ<coJFn]ohfD`ooUiNgooool09?ooooo00co
j^WTokjoa_ooooooj>S]onGVk?oKgNGocLcKon3Rk_o3`lWoNWbBokJf`oofm_H1ooooo`0000Cooooo
okVi`onYZk[oXJ6a3Oooool03?o9bLWoF5QHof][JoooooooGemOob`/;?n3Ph?oc/k>ofIVI_oJf][o
R8R8ogmoO`;ooooo04co/;2`o`000?ooooooI6ATomoOgole=CGoSHf=o`000?o?cloooooook>c/ol0
003oW9bLoi6ATOlV9RKoUYJFob4Q8Ol^;RkoMgMgog1`L?nLW9coT92@oh:2P_lE5AGoRXZ:ogQhN?o=
cLgoQhN7oiNGUomfMWKoCDe=o`000?nKVi_o@d=3ogMgMon1PH7oUiNGog=cLon3Ph?o:BTYo`000?oo
oooobLW9o`000?nATI7oJ6QXom;Bd_lk>c_o]kNgoogmoOl^;Rkoc<c<ojZZZ_nCTi?oC4a<oogmoOnS
Xj?ooooook2deOn0QkWo`/KNoo[io?ng^]Ooo?goolc>honHW/Soooooog=j]?onookoGVJYolW<hOnQ
Y/gom_SjohnD`_o4aMkoOHBh0_ooool02ommQ;SoYZ_@oooooooOgngooooood19V?oooooooOknomcM
k?nW[M3oZ:c>00;ooooo02_oR8R8ocdm?Olj>S[o820PojFUYOlY:BWoSXj>oaPH6?mJFU[oooooof=[
Zon_]=?og]k]on3Pk?o8b^;ooooooiVNaooPi>kog]o]ojjbdone^MKoRHnnol;4g_n]/]?oooooofI^
[Oo@e>OoUY_5oooooonm`M_oX:G;om7DiOooooooj^_doeUQY?n6SKkoiNKaoo_moOoAe>OoVj;9omgP
looPgmGoa/K709?ooooo00coj^WTokjoa_ooooooj>S]onGVk?oKgNGocLcKon3Rk_o3`lWoNWbBokJf
`oofm_H1ooooo`0000CooooookVi`onYZk[oXJ6a3Oooool00omlO7co0000o`000003ooooo`07ogUi
NOl_;booRHV9oi2@T?mBDU;oOGemoo?cl`02ooooo`08ogQhN?o[jn_oooooofQXJ?o`l?3o?ShnoeIF
E_nd];@2ooooo`0NokNg]om@D53oHf=Son3Ph?lm?CgooOgmokBd]?o6a/Kolo?cohj>S_oEeMGoShn?
oc<c<on9RHWoooooog]kNon_[joodm?CogYjN_n0P83ooooookZj^_nXZ:SoooooofIVI_mBDU;ooooo
ofMWIooXj>SoXZ:R0_ooool02omdM7Cooooook:b/_lD51CooooookZj^_l410Cooooooh^;Roo[jn_o
000000Kooooo00Go/kKEodmHX?nIW<Oo[[3BogIm]002ooooo`09ohN>_OooooooPHNiogV0]Ooooooo
KGB`omOJj_oJg>_oOH:i00;ooooo00?o[[CCom;Ci_ooool00_ooool00ommP[Ooooooooooo`02oooo
o`0<ojnddoni_=WooooooginO_m?Cdool?3`oiZJV_oRh^;o9bLWooooooo4a<Co^KVi0oooool04?m]
MJkoHFVYolS;h?m]M:oofM[Zoooooong^]Ooj^_eoocloOm>Eiooooooolc>h_no`]co]kcGolO9gong
^MP3ooooo`05of9[Z_oooooooooooo?dn?n^/]@00_ooool00omKHJGooooood]DV`2Eooooo`0<on[Y
i?nn_lKoooooonSXkOoUi^cofmgUolg<fooPh^ko`l?9ogYlT_nf]/?om_Kf0Oooool00004ooooooni
^L?oZJ^joj6Q/@gooooo00?oOWino`000?l000000_ooool01om4A4Cok>c/ooCdm?l51@Go_KfmogIf
M_lR8R800oooool02?m]KFgol?3`oooooolg=cOo6a/KoooooomoOgoo;Bd]0_ooool0;_nFUYKoHF5Q
okZj^_l0003ooooooiNGUolG5aOoZ:RXobHV9_nWYjOo=SHfoeeMGOoooooo1PH6oj6QXOl@413o<c<c
obXZ:_mRHV;ooooooclo?omOGeooIfMWobh^;_mVIVKoooooo`000?ooooooX:2Po`000?oBd];ooooo
ohb<S?lm?CgoL71`oooooomeMGGoAdM7oooooomfMWKoC4a<oooooon6QXKo9bLWoiZJV_nh^;P2oooo
o`0AohV>_ooEenSooooood]EWOnj_M_oaLWOodaFWOo1a=goATjIomgQk?mdNK;oa<WOog1h/OoLg^co
O8:hoeMPY?o3amh00_ooool00onf^MOob/kSooooo`02ooooo`06ogf5^OoooooooooooooooooXj?;o
DUZQ0_ooool07?n6QXKo;bl_onKVi_l0003oM7Adom[Jf_mZJV[o61PHolk>c_oooooom?CiofY_[?oo
ooooZ:_>oeeTYooXj_;oP8Fjogf3]on8SkkoVj37oi>H`onf^]OoTIS3ohZ?_oo[jo?o>4>BohR=__og
n?/2ooooo`03ofM^Z_o?d>Cooooo00;ooooo00Ko/KGDokFieoooooooD5ZOohfC`_nf^]JEooooo`0<
on[Yi?nn_lKoooooonSXkOoUi^cofmgUolg<fooPh^ko`l?9ogYlT_nf]/?om_Kf0Oooool00004oooo
ooni^L?oZJ^joj6Q/A7ooooo00CoBd];omOGeoo3`l?ono_k1_ooool01On`/;3o`<30oe5ADOo?cloo
;bl_00Kooooo00_oUiNGoadM7Ooooooo0000ofm_Kooooooono_koooooomPH63oXj>SohJ6QP09oooo
o`06