(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     89952,       3428]*)
(*NotebookOutlinePosition[    135733,       4775]*)
(*  CellTagsIndexPosition[    131601,       4610]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.4 ", "HeadingNumber"],
  "Algebraic Calculations"
}], "Section",
  CellTags->{"S1.4.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.4.1 Symbolic Computation", "Subsection",
  CellTags->{"S1.4.1", "1.1"}],

Cell[TextData[{
  "One of the important features of ",
  StyleBox["Mathematica", "TI"],
  " is that it can do ",
  StyleBox["symbolic", "TI"],
  ", as well as ",
  StyleBox["numerical", "TI"],
  " calculations. This means that it can handle algebraic formulas as well as \
numbers. "
}], "Text",
  CellTags->{"S1.4.1", "1.2"}],

Cell["Here is a typical numerical computation. ", "MathCaption",
  CellTags->{"S1.4.1", "1.3"}],

Cell[CellGroupData[{

Cell["3 + 62 - 1", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(64\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell["This is a symbolic computation. ", "MathCaption",
  CellTags->{"S1.4.1", "1.4"}],

Cell[CellGroupData[{

Cell["3x - x + 2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(2 + 2\ x\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Numerical computation "], Cell[TextData[{
              StyleBox["3", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["62", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["1", "MR"],
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              "  ",
              StyleBox["64", "MR"],
              " "
            }]]},
          {Cell["Symbolic computation "], Cell[TextData[{
              StyleBox["3x", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["2", "MR"],
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              "  ",
              StyleBox["2", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["2", "MR"],
              " ",
              StyleBox["x", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.1"],

Cell["Numerical and symbolic computations. ", "Caption",
  CellTags->"S1.4.1"],

Cell[TextData[{
  "You can type any algebraic expression into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.1", "1.5"}],

Cell[CellGroupData[{

Cell["-1 + 2x + x^3", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(\(-1\) + 2\ x + x\^3\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " automatically carries out basic algebraic simplifications. Here it \
combines ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-4\), 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  " to get ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-3\), 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  ".  "
}], "MathCaption",
  CellTags->{"S1.4.1", "1.6"}],

Cell[CellGroupData[{

Cell["x^2 + x - 4 x^2", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(x - 3\ x\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  "You can type in any algebraic expression, using the operators listed in \
Section\[NonBreakingSpace]",
  ButtonBox["1.1.1",
    ButtonData:>{"1.1.1", "1.7"},
    ButtonStyle->"MainBookLink"],
  ". You can use spaces to denote multiplication. Be careful not to forget \
the space in ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["y", "MR"],
  ". If you type in ",
  StyleBox["xy", "MR"],
  " with no space, ",
  StyleBox["Mathematica", "TI"],
  " will interpret this as a single symbol, with the name ",
  StyleBox["xy", "MR"],
  ", not as a product of the two symbols ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.4.1", "1.7"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " rearranges and combines terms using the standard rules of algebra. "
}], "MathCaption",
  CellTags->{"S1.4.1", "1.8"}],

Cell[CellGroupData[{

Cell["x y + 2 x^2 y + y^2 x^2 - 2 y x", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(\(-x\)\ y + 2\ x\^2\ y + x\^2\ y\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell["Here is another algebraic expression. ", "MathCaption",
  CellTags->{"S1.4.1", "1.9"}],

Cell[CellGroupData[{

Cell["(x + 2y + 1)(x - 2)^2", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(\((\(-2\) + x)\)\^2\ \((1 + x + 2\ y)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Expand", "MR"],
  " multiplies out products and powers. "
}], "MathCaption",
  CellTags->{"S1.4.1", "1.10"}],

Cell[CellGroupData[{

Cell["Expand[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(4 - 3\ x\^2 + x\^3 + 8\ y - 8\ x\ y + 2\ x\^2\ y\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " does essentially the inverse of ",
  StyleBox["Expand", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.1", "1.11"}],

Cell[CellGroupData[{

Cell["Factor[%]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(\((\(-2\) + x)\)\^2\ \((1 + x + 2\ y)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  "When you type in more complicated expressions, it is important that you \
put parentheses in the right places. Thus, for example, you have to give the \
expression ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          RowBox[{"4", 
            StyleBox["y",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  " in the form ",
  StyleBox["x^(4y)", "MR"],
  ". If you leave out the parentheses, you get ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "4"], 
          StyleBox["y",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " instead. It never hurts to put in too many parentheses, but to find out \
exactly when you need to use parentheses, look at Section ",
  ButtonBox["A.2",
    ButtonData:>{"A.2"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.4.1", "1.12"}],

Cell["\<\
Here is a more complicated formula, requiring several parentheses. \
\
\>", "MathCaption",
  CellTags->{"S1.4.1", "1.13"}],

Cell[CellGroupData[{

Cell["Sqrt[2]/9801 (4n)! (1103 + 26390 n) / (n!^4 396^(4n))", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(\(2\^\(1\/2 - 8\ n\)\ 99\^\(\(-2\) - 4\ n\)\ \((1103 + 26390\ n)\)\ \
\(\((4\ n)\)!\)\)\/\((\(n!\))\)\^4\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  "When you type in an expression, ",
  StyleBox["Mathematica", "TI"],
  " automatically applies its large repertoire of rules for transforming \
expressions. These rules include the standard rules of algebra, such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "-", 
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", together with much more sophisticated rules involving higher \
mathematical functions. "
}], "Text",
  CellTags->{"S1.4.1", "1.14"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses standard rules of algebra to replace ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            SqrtBox[
              RowBox[{"1", "+", 
                StyleBox["x",
                  "TI"]}]], ")"}], "4"], TraditionalForm]], "InlineFormula"],
  " by ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", 
              StyleBox["x",
                "TI"]}], ")"}], "2"], TraditionalForm]], "InlineFormula"],
  "."
}], "MathCaption",
  CellTags->{"S1.4.1", "1.15"}],

Cell[CellGroupData[{

Cell["Sqrt[1 + x]^4", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(\((1 + x)\)\^2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows no rules for this expression, so it leaves the expression in the \
original form you gave. "
}], "MathCaption",
  CellTags->{"S1.4.1", "1.16"}],

Cell[CellGroupData[{

Cell["Log[1 + Cos[x]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.4.1"],

Cell[BoxData[
    \(Log[1 + Cos[x]]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[TextData[{
  "The notion of transformation rules is a very general one. In fact, you can \
think of the whole of ",
  StyleBox["Mathematica", "TI"],
  " as simply a system for applying a collection of transformation rules to \
many different kinds of expressions. "
}], "Text",
  CellTags->{"S1.4.1", "1.17"}],

Cell[TextData[{
  "The general principle that ",
  StyleBox["Mathematica", "TI"],
  " follows is simple to state. It takes any expression you input, and gets \
results by applying a succession of transformation rules, stopping when it \
knows no more transformation rules that can be applied. "
}], "Text",
  CellTags->{"S1.4.1", "1.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Take any expression, and apply \
transformation rules until the result no longer changes. \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.1"],

Cell[TextData[{
  "The fundamental principle of ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.2 Values for Symbols", "Subsection",
  CellTags->{"S1.4.2", "2.1"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " transforms an expression such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x", "MR"],
  " into ",
  StyleBox["2x", "MR"],
  ", it is treating the variable ",
  StyleBox["x", "MR"],
  " in a purely symbolic or formal fashion. In such cases, ",
  StyleBox["x", "MR"],
  " is a symbol which can stand for any expression. "
}], "Text",
  CellTags->{"S1.4.2", "2.2"}],

Cell[TextData[{
  "Often, however, you need to replace a symbol like ",
  StyleBox["x", "MR"],
  " with a definite \[OpenCurlyDoubleQuote]value\[CloseCurlyDoubleQuote]. \
Sometimes this value will be a number; often it will be another expression. "
}], "Text",
  CellTags->{"S1.4.2", "2.3"}],

Cell[TextData[{
  "To take an expression such as ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2x", "MR"],
  " and replace the symbol ",
  StyleBox["x", "MR"],
  " that appears in it with a definite value, you can create a ",
  StyleBox["Mathematica", "TI"],
  " transformation rule, and then apply this rule to the expression. To \
replace ",
  StyleBox["x", "MR"],
  " with the value ",
  StyleBox["3", "MR"],
  ", you would create the transformation rule ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["3", "MR"],
  ". You must type ",
  StyleBox["->", "MR"],
  " as a pair of characters, with no space in between. You can think of ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["3", "MR"],
  " as being a rule in which \[OpenCurlyDoubleQuote]",
  StyleBox["x", "MR"],
  " goes to ",
  StyleBox["3", "MR"],
  "\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S1.4.2", "2.4"}],

Cell[TextData[{
  "To apply a transformation rule to a particular ",
  StyleBox["Mathematica", "TI"],
  " expression, you type ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox["/.", "MR"],
  " ",
  StyleBox["rule", "TI"],
  ". The \[OpenCurlyDoubleQuote]replacement operator\[CloseCurlyDoubleQuote] \
",
  StyleBox["/.", "MR"],
  " is typed as a pair of characters, with no space in between. "
}], "Text",
  CellTags->{"S1.4.2", "2.5"}],

Cell[TextData[{
  "This uses the transformation rule ",
  StyleBox["x->3", "MR"],
  " in the expression ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.6"}],

Cell[CellGroupData[{

Cell["1 + 2x /. x -> 3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "You can replace ",
  StyleBox["x", "MR"],
  " with any expression. Here every occurrence of ",
  StyleBox["x", "MR"],
  " is replaced by ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.7"}],

Cell[CellGroupData[{

Cell["1 + x + x^2 /. x -> 2 - y", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(3 + \((2 - y)\)\^2 - y\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "Here is a transformation rule. ",
  StyleBox["Mathematica", "TI"],
  " treats it like any other symbolic expression. "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.8"}],

Cell[CellGroupData[{

Cell["x -> 3 + y", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(x \[Rule] 3 + y\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "This applies the transformation rule on the previous line to the \
expression ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["9", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.9"}],

Cell[CellGroupData[{

Cell["x^2 - 9 /. %", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(\(-9\) + \((3 + y)\)\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "replace ",
              StyleBox["x", "TI"],
              " by ",
              StyleBox["value", "TI"],
              " in the expression ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["xval", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["yval", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["perform several replacements "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.2"],

Cell["Replacing symbols by values in expressions. ", "Caption",
  CellTags->"S1.4.2"],

Cell["\<\
You can apply rules together by putting the rules in a list. \
\>", \
"MathCaption",
  CellTags->{"S1.4.2", "2.10"}],

Cell[CellGroupData[{

Cell["(x + y) (x - y)^2 /. {x -> 3, y -> 1 - a}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(\((4 - a)\)\ \((2 + a)\)\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "The replacement operator ",
  StyleBox["/.", "MR"],
  " allows you to apply transformation rules to a particular expression. \
Sometimes, however, you will want to define transformation rules that should \
",
  StyleBox["always", "TI"],
  " be applied. For example, you might want to replace ",
  StyleBox["x", "MR"],
  " with ",
  StyleBox["3", "MR"],
  " whenever ",
  StyleBox["x", "MR"],
  " occurs. "
}], "Text",
  CellTags->{"S1.4.2", "2.11"}],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["1.2.2",
    ButtonData:>{"1.2.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ", you can do this by ",
  StyleBox["assigning", "TI"],
  " the value ",
  StyleBox["3", "MR"],
  " to ",
  StyleBox["x", "MR"],
  " using ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["3", "MR"],
  ". Once you have made the assignment ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["3", "MR"],
  ", ",
  StyleBox["x", "MR"],
  " will always be replaced by ",
  StyleBox["3", "MR"],
  ", whenever it appears. "
}], "Text",
  CellTags->{"S1.4.2", "2.12"}],

Cell[TextData[{
  "This assigns the value ",
  StyleBox["3", "MR"],
  " to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.13"}],

Cell[CellGroupData[{

Cell["x = 3", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["x", "MR"],
  " will automatically be replaced by ",
  StyleBox["3", "MR"],
  " wherever it appears. "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.14"}],

Cell[CellGroupData[{

Cell["x^2 - 1", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "This assigns the expression ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a", "MR"],
  " to be the value of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.15"}],

Cell[CellGroupData[{

Cell["x = 1 + a", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(1 + a\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["x", "MR"],
  " is replaced by ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.16"}],

Cell[CellGroupData[{

Cell["x^2 - 1", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(\(-1\) + \((1 + a)\)\^2\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "You can define the value of a symbol to be any expression, not just a \
number. You should realize that once you have given such a definition, the \
definition will continue to be used whenever the symbol appears, until you \
explicitly change or remove the definition. For most people, forgetting to \
remove values you have assigned to symbols is the single most common source \
of mistakes in using ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.4.2", "2.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "define a value for ",
              StyleBox["x", "TI"],
              " which will always be used "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell[TextData[{
              "remove any value defined for ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.2"],

Cell["Assigning values to symbols. ", "Caption",
  CellTags->"S1.4.2"],

Cell[TextData[{
  "The symbol ",
  StyleBox["x", "MR"],
  " still has the value you assigned to it above. "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.18"}],

Cell[CellGroupData[{

Cell["x + 5 - 2x", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(6 + a - 2\ \((1 + a)\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "This removes the value you assigned to\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.19"}],

Cell["x =.", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.4.2"],

Cell[TextData[{
  "Now ",
  StyleBox["x", "MR"],
  " has no value defined, so it can be used as a purely symbolic variable. "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.20"}],

Cell[CellGroupData[{

Cell["x + 5 - 2x", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(5 - x\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "A symbol such as ",
  StyleBox["x", "MR"],
  " can serve many different purposes in ",
  StyleBox["Mathematica", "TI"],
  ", and in fact, much of the flexibility of ",
  StyleBox["Mathematica", "TI"],
  " comes from being able to mix these purposes at will. However, you need to \
keep some of the different uses of ",
  StyleBox["x", "MR"],
  " straight in order to avoid making mistakes. The most important \
distinction is between the use of ",
  StyleBox["x", "MR"],
  " as a name for another expression, and as a symbolic variable that stands \
only for itself. "
}], "Text",
  CellTags->{"S1.4.2", "2.21"}],

Cell[TextData[{
  "Traditional programming languages that do not support symbolic computation \
allow variables to be used only as names for objects, typically numbers, that \
have been assigned as values for them. In ",
  StyleBox["Mathematica", "TI"],
  ", however, ",
  StyleBox["x", "MR"],
  " can also be treated as a purely formal variable, to which various \
transformation rules can be applied. Of course, if you explicitly give a \
definition, such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["3", "MR"],
  ", then ",
  StyleBox["x", "MR"],
  " will always be replaced by ",
  StyleBox["3", "MR"],
  ", and can no longer serve as a formal variable. "
}], "Text",
  CellTags->{"S1.4.2", "2.22"}],

Cell[TextData[{
  "You should understand that explicit definitions such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["3", "MR"],
  " have a global effect. On the other hand, a replacement such as ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox["/.", "MR"],
  " ",
  StyleBox["x->3", "MR"],
  " affects only the specific expression ",
  StyleBox["expr", "TI"],
  ". It is usually much easier to keep things straight if you avoid using \
explicit definitions except when absolutely necessary."
}], "Text",
  CellTags->{"S1.4.2", "2.23"}],

Cell["\<\
You can always mix replacements with assignments. With assignments, \
you can give names to expressions in which you want to do replacements, or to \
rules that you want to use to do the replacements. \
\>", "Text",
  CellTags->{"S1.4.2", "2.24"}],

Cell[TextData[{
  "This assigns a value to the symbol ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.25"}],

Cell[CellGroupData[{

Cell["t = 1 + x^2", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(1 + x\^2\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "This finds the value of ",
  StyleBox["t", "MR"],
  ", and then replaces ",
  StyleBox["x", "MR"],
  " by ",
  StyleBox["2", "MR"],
  " in it. "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.26"}],

Cell[CellGroupData[{

Cell["t /. x -> 2", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "This finds the value of ",
  StyleBox["t", "MR"],
  " for a different value of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.27"}],

Cell[CellGroupData[{

Cell["t /. x -> 5a", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(1 + 25\ a\^2\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.4.2"]
}, Open  ]],

Cell[TextData[{
  "This finds the value of ",
  StyleBox["t", "MR"],
  " when ",
  StyleBox["x", "MR"],
  " is replaced by ",
  StyleBox["Pi", "MR"],
  ", and then evaluates the result numerically. "
}], "MathCaption",
  CellTags->{"S1.4.2", "2.28"}],

Cell[CellGroupData[{

Cell["t /. x -> Pi //N", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.4.2"],

Cell[BoxData[
    \(10.869604401089358`\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S1.4.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.3 Transforming Algebraic Expressions", "Subsection",
  CellTags->{"S1.4.3", "3.1"}],

Cell[TextData[{
  "There are often many different ways to write the same algebraic \
expression. As one example, the expression ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", 
              StyleBox["x",
                "TI"]}], ")"}], "2"], TraditionalForm]], "InlineFormula"],
  " can be written as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "+", "2", 
          StyleBox["x",
            "TI"], "+", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " provides a large collection of functions for converting between different \
forms of algebraic expressions.   "
}], "Text",
  CellTags->{"S1.4.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Expand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
multiply out products and powers, writing the result as \
a sum of terms \
\>"]},
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write ",
              StyleBox["expr", "TI"],
              " as a product of minimal factors "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.3"],

Cell["\<\
Two common functions for transforming algebraic expressions. \
\>", \
"Caption",
  CellTags->"S1.4.3"],

Cell[TextData[{
  StyleBox["Expand", "MR"],
  " gives the \[OpenCurlyDoubleQuote]expanded form\[CloseCurlyDoubleQuote], \
with products and powers multiplied out. "
}], "MathCaption",
  CellTags->{"S1.4.3", "3.3"}],

Cell[CellGroupData[{

Cell["Expand[ (1 + x)^2 ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.3"],

Cell[BoxData[
    \(1 + 2\ x + x\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " recovers the original form.  "
}], "MathCaption",
  CellTags->{"S1.4.3", "3.4"}],

Cell[CellGroupData[{

Cell["Factor[ % ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.3"],

Cell[BoxData[
    \(\((1 + x)\)\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.3"]
}, Open  ]],

Cell[TextData[{
  "It is easy to generate complicated expressions with ",
  StyleBox["Expand", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.3", "3.5"}],

Cell[CellGroupData[{

Cell["Expand[ (1 + x + 3 y)^4 ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.3"],

Cell[BoxData[
    \(1 + 4\ x + 6\ x\^2 + 4\ x\^3 + x\^4 + 12\ y + 36\ x\ y + 36\ x\^2\ y + 
      12\ x\^3\ y + 54\ y\^2 + 108\ x\ y\^2 + 54\ x\^2\ y\^2 + 108\ y\^3 + 
      108\ x\ y\^3 + 81\ y\^4\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " often gives you simpler expressions. "
}], "MathCaption",
  CellTags->{"S1.4.3", "3.6"}],

Cell[CellGroupData[{

Cell["Factor[ % ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.3"],

Cell[BoxData[
    \(\((1 + x + 3\ y)\)\^4\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.3"]
}, Open  ]],

Cell[TextData[{
  "There are some cases, though, where ",
  StyleBox["Factor", "MR"],
  " can give you more complicated expressions. "
}], "MathCaption",
  CellTags->{"S1.4.3", "3.7"}],

Cell[CellGroupData[{

Cell["Factor[ x^10 - 1 ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.3"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((1 + x)\)\ \((1 - x + x\^2 - x\^3 + x\^4)\)\ \((1 + 
          x + x\^2 + x\^3 + x\^4)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.3"]
}, Open  ]],

Cell[TextData[{
  "In this case, ",
  StyleBox["Expand", "MR"],
  " gives the \[OpenCurlyDoubleQuote]simpler\[CloseCurlyDoubleQuote] form. "
}], "MathCaption",
  CellTags->{"S1.4.3", "3.8"}],

Cell[CellGroupData[{

Cell["Expand[ % ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.3"],

Cell[BoxData[
    \(\(-1\) + x\^10\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.4 Simplifying Algebraic Expressions", "Subsection",
  CellTags->{"S1.4.4", "4.1"}],

Cell["\<\
There are many situations where you want to write a particular \
algebraic expression in the simplest possible form. Although it is difficult \
to know exactly what one means in all cases by the \
\[OpenCurlyDoubleQuote]simplest form\[CloseCurlyDoubleQuote], a worthwhile \
practical procedure is to look at many different forms of an expression, and \
pick out the one that involves the smallest number of parts.      \
\>", \
"Text",
  CellTags->{"S1.4.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Simplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "try to find the simplest form of ",
              StyleBox["expr", "TI"],
              " by applying various standard algebraic transformations "
            }]]},
          {Cell[TextData[{
              StyleBox["FullSimplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
try to find the simplest form by applying a wide range \
of transformations \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.4"],

Cell["Simplifying algebraic expressions. ", "Caption",
  CellTags->"S1.4.4"],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " writes ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", "2", 
          StyleBox["x",
            "TI"], "+", "1"}], TraditionalForm]], "InlineFormula"],
  " in factored form. "
}], "MathCaption",
  CellTags->{"S1.4.4", "4.3"}],

Cell[CellGroupData[{

Cell["Simplify[x^2 + 2x + 1]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(\((1 + x)\)\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " leaves ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "10"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  " in expanded form, since for this expression, the factored form is larger. \
"
}], "MathCaption",
  CellTags->{"S1.4.4", "4.4"}],

Cell[CellGroupData[{

Cell["Simplify[x^10 - 1]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(\(-1\) + x\^10\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  "You can often use ",
  StyleBox["Simplify", "MR"],
  " to \[OpenCurlyDoubleQuote]clean up\[CloseCurlyDoubleQuote] complicated \
expressions that you get as the results of computations. "
}], "Text",
  CellTags->{"S1.4.4", "4.5"}],

Cell[TextData[{
  "Here is the integral of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "/", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "4"], "-", "1"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". Integrals are discussed in more detail in Section ",
  ButtonBox["1.5.3",
    ButtonData:>{"1.5.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.4", "4.6"}],

Cell[CellGroupData[{

Cell["Integrate[1/(x^4-1), x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(\(-\(ArcTan[x]\/2\)\) + 1\/4\ Log[\(-1\) + x] - 
      1\/4\ Log[1 + x]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  "Differentiating the result from ",
  StyleBox["Integrate", "MR"],
  " should give back your original expression. In this case, as is common, \
you get a more complicated version of the expression. "
}], "MathCaption",
  CellTags->{"S1.4.4", "4.7"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(1\/\(4\ \((\(-1\) + x)\)\) - 1\/\(4\ \((1 + x)\)\) - 
      1\/\(2\ \((1 + x\^2)\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " succeeds in getting back the original, more simple, form of the \
expression. "
}], "MathCaption",
  CellTags->{"S1.4.4", "4.8"}],

Cell[CellGroupData[{

Cell["Simplify[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(1\/\(\(-1\) + x\^4\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " is set up to try various standard algebraic transformations on the \
expressions you give. Sometimes, however, it can take more sophisticated \
transformations to make progress in finding the simplest form of an \
expression. "
}], "Text",
  CellTags->{"S1.4.4", "4.9"}],

Cell[TextData[{
  StyleBox["FullSimplify", "MR"],
  " tries a much wider range of transformations, involving not only algebraic \
functions, but also many other kinds of functions. "
}], "Text",
  CellTags->{"S1.4.4", "4.10"}],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " does nothing to this expression. "
}], "MathCaption",
  CellTags->{"S1.4.4", "4.11"}],

Cell[CellGroupData[{

Cell["Simplify[Gamma[x] Gamma[1 - x]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(Gamma[1 - x]\ Gamma[x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullSimplify", "MR"],
  ", however, transforms it to a simpler form. "
}], "MathCaption",
  CellTags->{"S1.4.4", "4.12"}],

Cell[CellGroupData[{

Cell["FullSimplify[Gamma[x] Gamma[1 - x]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.4"],

Cell[BoxData[
    \(\[Pi]\ Csc[\[Pi]\ x]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.4"]
}, Open  ]],

Cell[TextData[{
  "For fairly small expressions, ",
  StyleBox["FullSimplify", "MR"],
  " will often succeed in making some remarkable simplifications. But for \
larger expressions, it can become unmanageably slow. "
}], "Text",
  CellTags->{"S1.4.4", "4.13"}],

Cell[TextData[{
  "The reason for this is that to do its job, ",
  StyleBox["FullSimplify", "MR"],
  " effectively has to try combining every part of an expression with every \
other, and for large expressions the number of cases that it has to consider \
can be astronomically large.  "
}], "Text",
  CellTags->{"S1.4.4", "4.14"}],

Cell[TextData[{
  StyleBox["Simplify", "MR"],
  " also has a difficult task to do, but it is set up to avoid some of the \
most time\[Hyphen]consuming transformations that are tried by ",
  StyleBox["FullSimplify", "MR"],
  ". For simple algebraic calculations, therefore, you may often find it \
convenient to apply ",
  StyleBox["Simplify", "MR"],
  " quite routinely to your results. "
}], "Text",
  CellTags->{"S1.4.4", "4.15"}],

Cell[TextData[{
  "In more complicated calculations, however, even ",
  StyleBox["Simplify", "MR"],
  ", let alone ",
  StyleBox["FullSimplify", "MR"],
  ", may end up needing to try a very large number of different forms, and \
therefore taking a long time. In such cases, you typically need to do more \
controlled simplification, and use your knowledge of the form you want to get \
to guide the process.   "
}], "Text",
  CellTags->{"S1.4.4", "4.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.4.5 Advanced Topic: Putting Expressions into Different \
Forms\
\>", "Subsection",
  CellTags->{"S1.4.5", "5.1"}],

Cell[TextData[{
  "Complicated algebraic expressions can usually be written in many different \
ways. ",
  StyleBox["Mathematica", "TI"],
  " provides a variety of functions for converting expressions from one form \
to another. "
}], "Text",
  CellTags->{"S1.4.5", "5.2"}],

Cell[TextData[{
  "In many applications, the most common of these functions are ",
  StyleBox["Expand", "MR"],
  ", ",
  StyleBox["Factor", "MR"],
  " and ",
  StyleBox["Simplify", "MR"],
  ". However, particularly when you have rational expressions that contain \
quotients, you may need to use other functions.  "
}], "Text",
  CellTags->{"S1.4.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Expand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["multiply out products and powers "]},
          {Cell[TextData[{
              StyleBox["ExpandAll[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["Expand", "MR"],
              " everywhere "
            }]]},
          {Cell[TextData[{
              StyleBox["Factor[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["reduce to a product of factors "]},
          {Cell[TextData[{
              StyleBox["Together[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["put all terms over a common denominator "]},
          {Cell[TextData[{
              StyleBox["Apart[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["separate into terms with simple denominators "]},
          {Cell[TextData[{
              StyleBox["Cancel[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "cancel common factors between numerators and denominators "]},
          {Cell[TextData[{
              StyleBox["Simplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "try a sequence of algebraic transformations and give the \
smallest form of ",
              StyleBox["expr", "TI"],
              " found "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.5"],

Cell["Functions for transforming algebraic expressions. ", "Caption",
  CellTags->"S1.4.5"],

Cell["\<\
Here is a rational expression that can be written in many different \
forms. \
\>", "MathCaption",
  CellTags->{"S1.4.5", "5.4"}],

Cell[CellGroupData[{

Cell["e = (x - 1)^2 (2 + x) / ((1 + x) (x - 3)^2)", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\(\((\(-1\) + x)\)\^2\ \((2 + x)\)\)\/\(\((\(-3\) + x)\)\^2\ \((1 + \
x)\)\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Expand", "MR"],
  " expands out the numerator, but leaves the denominator in factored form. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.5"}],

Cell[CellGroupData[{

Cell["Expand[e]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(2\/\(\((\(-3\) + x)\)\^2\ \((1 + x)\)\) - \(3\ x\)\/\(\((\(-3\) + \
x)\)\^2\ \((1 + x)\)\) + 
      x\^3\/\(\((\(-3\) + x)\)\^2\ \((1 + x)\)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExpandAll", "MR"],
  " expands out everything, including the denominator. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.6"}],

Cell[CellGroupData[{

Cell["ExpandAll[e]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(2\/\(9 + 3\ x - 5\ x\^2 + x\^3\) - \(3\ x\)\/\(9 + 3\ x - 5\ x\^2 + \
x\^3\) + x\^3\/\(9 + 3\ x - 5\ x\^2 + x\^3\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Together", "MR"],
  " collects all the terms together over a common denominator.   "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.7"}],

Cell[CellGroupData[{

Cell["Together[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\(2 - 3\ x + x\^3\)\/\(\((\(-3\) + x)\)\^2\ \((1 + x)\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Apart", "MR"],
  " breaks the expression apart into terms with simple denominators. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.8"}],

Cell[CellGroupData[{

Cell["Apart[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(1 + 5\/\((\(-3\) + x)\)\^2 + 19\/\(4\ \((\(-3\) + x)\)\) + 
      1\/\(4\ \((1 + x)\)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Factor", "MR"],
  " factors everything, in this case reproducing the original form. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.9"}],

Cell[CellGroupData[{

Cell["Factor[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\(\((\(-1\) + x)\)\^2\ \((2 + x)\)\)\/\(\((\(-3\) + x)\)\^2\ \((1 + \
x)\)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "According to ",
  StyleBox["Simplify", "MR"],
  ", this is the simplest way to write the original expression. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.10"}],

Cell[CellGroupData[{

Cell["Simplify[e]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\(\((\(-1\) + x)\)\^2\ \((2 + x)\)\)\/\(\((\(-3\) + x)\)\^2\ \((1 + \
x)\)\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell["\<\
Getting expressions into the form you want is something of an art. \
In most cases, it is best simply to experiment, trying different \
transformations until you get what you want. Often you will be able to use \
palettes in the front end to do this. \
\>", "Text",
  CellTags->{"S1.4.5", "5.11"}],

Cell["\<\
When you have an expression with a single variable, you can choose \
to write it as a sum of terms, a product, and so on. If you have an \
expression with several variables, there is an even wider selection of \
possible forms. You can, for example, choose to group terms in the expression \
so that one or another of the variables is \[OpenCurlyDoubleQuote]dominant\
\[CloseCurlyDoubleQuote].  \
\>", "Text",
  CellTags->{"S1.4.5", "5.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Collect[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "group together powers of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FactorTerms[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pull out factors that do not depend on ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.5"],

Cell["Rearranging expressions in several variables. ", "Caption",
  CellTags->"S1.4.5"],

Cell["Here is an algebraic expression in two variables. ", "MathCaption",
  CellTags->{"S1.4.5", "5.13"}],

Cell[CellGroupData[{

Cell["v = Expand[(3 + 2 x)^2 (x + 2 y)^2]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(9\ x\^2 + 12\ x\^3 + 4\ x\^4 + 36\ x\ y + 48\ x\^2\ y + 16\ x\^3\ y + 
      36\ y\^2 + 48\ x\ y\^2 + 16\ x\^2\ y\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "This groups together terms in ",
  StyleBox["v", "MR"],
  " that involve the same power of ",
  StyleBox["x", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.14"}],

Cell[CellGroupData[{

Cell["Collect[v, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(4\ x\^4 + 36\ y\^2 + x\^3\ \((12 + 16\ y)\) + 
      x\^2\ \((9 + 48\ y + 16\ y\^2)\) + 
      x\ \((36\ y + 48\ y\^2)\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "This groups together powers of ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.15"}],

Cell[CellGroupData[{

Cell["Collect[v, y]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(9\ x\^2 + 12\ x\^3 + 
      4\ x\^4 + \((36\ x + 48\ x\^2 + 16\ x\^3)\)\ y + \((36 + 48\ x + 
            16\ x\^2)\)\ y\^2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "This factors out the piece that does not depend on ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.16"}],

Cell[CellGroupData[{

Cell["FactorTerms[v, y]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\((9 + 12\ x + 4\ x\^2)\)\ \((x\^2 + 4\ x\ y + 4\ y\^2)\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "As we have seen, even when you restrict yourself to polynomials and \
rational expressions, there are many different ways to write any particular \
expression. If you consider more complicated expressions, involving, for \
example, higher mathematical functions, the variety of possible forms becomes \
still greater. As a result, it is totally infeasible to have a specific \
function built into ",
  StyleBox["Mathematica", "TI"],
  " to produce each possible form. Rather, ",
  StyleBox["Mathematica", "TI"],
  " allows you to construct arbitrary sets of transformation rules for \
converting between different forms. Many ",
  StyleBox["Mathematica", "TI"],
  " packages include such rules; the details of how to construct them for \
yourself are given in Section ",
  ButtonBox["2.5",
    ButtonData:>{"2.5"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.4.5", "5.17"}],

Cell[TextData[{
  "There are nevertheless a few additional built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions for transforming expressions."
}], "Text",
  CellTags->{"S1.4.5", "5.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TrigExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "expand out trigonometric expressions into a sum of terms "]},
          {Cell[TextData[{
              StyleBox["TrigFactor[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "factor trigonometric expressions into products of terms "]},
          {Cell[TextData[{
              StyleBox["TrigReduce[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "reduce trigonometric expressions using multiple angles "]},
          {Cell[TextData[{
              StyleBox["TrigToExp[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["convert trigonometric functions to exponentials "]},
          {Cell[TextData[{
              StyleBox["ExpToTrig[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["convert exponentials to trigonometric functions "]},
          {Cell[TextData[{
              StyleBox["FunctionExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand out special and other functions "]},
          {Cell[TextData[{
              StyleBox["ComplexExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "perform expansions assuming that all variables are real "]},
          {Cell[TextData[{
              StyleBox["PowerExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "transform ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      RowBox[{"(", 
                        StyleBox[\(x  y\),
                          "TI"], ")"}], 
                      StyleBox["p",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " into ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SuperscriptBox[
                        StyleBox["x",
                          "TI"], 
                        StyleBox["p",
                          "TI"]], 
                      SuperscriptBox[
                        StyleBox["y",
                          "TI"], 
                        StyleBox["p",
                          "TI"]]}], TraditionalForm]], "InlineFormula"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.5"],

Cell["Some other functions for transforming expressions. ", "Caption",
  CellTags->"S1.4.5"],

Cell[TextData[{
  "This expands out the trigonometric expression, writing it so that all \
functions have argument ",
  StyleBox["x", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.19"}],

Cell[CellGroupData[{

Cell["TrigExpand[Tan[x] Cos[2x]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(3\/2\ Cos[x]\ Sin[x] - Tan[x]\/2 - 1\/2\ Sin[x]\^2\ Tan[x]\)], "Output",\

  CellLabel->"Out[12]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell["\<\
This uses trigonometric identities to generate a factored form of \
the expression. \
\>", "MathCaption",
  CellTags->{"S1.4.5", "5.20"}],

Cell[CellGroupData[{

Cell["TrigFactor[%]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\((Cos[x] - Sin[x])\)\ \((Cos[x] + Sin[x])\)\ Tan[x]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell["This reduces the expression by using multiple angles. ", "MathCaption",
  CellTags->{"S1.4.5", "5.21"}],

Cell[CellGroupData[{

Cell["TrigReduce[%]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\(-\(1\/2\)\)\ Sec[x]\ \((Sin[x] - Sin[3\ x])\)\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "This expands the sine assuming that ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " are both real. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.22"}],

Cell[CellGroupData[{

Cell["ComplexExpand[ Sin[x + I y] ]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(Cosh[y]\ Sin[x] + \[ImaginaryI]\ Cos[x]\ Sinh[y]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "This does the expansion allowing ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " to be complex. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.23"}],

Cell[CellGroupData[{

Cell["ComplexExpand[ Sin[x + I y], {x, y} ]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\(-Cosh[Im[x] + Re[y]]\)\ Sin[Im[y] - Re[x]] + \[ImaginaryI]\ Cos[
          Im[y] - Re[x]]\ Sinh[Im[x] + Re[y]]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  "The transformations on expressions done by functions like ",
  StyleBox["Expand", "MR"],
  " and ",
  StyleBox["Factor", "MR"],
  " are always correct, whatever values the symbolic variables in the \
expressions may have. Sometimes, however, it is useful to perform \
transformations that are only correct for some possible values of symbolic \
variables. One such transformation is performed by ",
  StyleBox["PowerExpand", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.4.5", "5.24"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not automatically expand out non\[Hyphen]integer powers of products. \
"
}], "MathCaption",
  CellTags->{"S1.4.5", "5.25"}],

Cell[CellGroupData[{

Cell["Sqrt[x y]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\@\(x\ y\)\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S1.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PowerExpand", "MR"],
  " does the expansion. "
}], "MathCaption",
  CellTags->{"S1.4.5", "5.26"}],

Cell[CellGroupData[{

Cell["PowerExpand[%]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S1.4.5"],

Cell[BoxData[
    \(\@x\ \@y\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S1.4.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.6 Advanced Topic: Simplifying with Assumptions", "Subsection",
  CellTags->{"S1.4.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Simplify[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["assum", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "simplify ",
              StyleBox["expr", "TI"],
              " with assumptions "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.6"],

Cell["Simplifying with assumptions. ", "Caption",
  CellTags->"S1.4.6"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not automatically simplify this, since it is only true for some \
values of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.2"}],

Cell[CellGroupData[{

Cell["Simplify[Sqrt[x^2]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(\@x\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SqrtBox[
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]], TraditionalForm]], "InlineFormula"],
  " is equal to ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[GreaterEqual]", "0"}], TraditionalForm]], 
    "InlineFormula"],
  ", but not otherwise. "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.3"}],

Cell[CellGroupData[{

Cell["{Sqrt[4^2], Sqrt[(-4)^2]}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \({4, 4}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Simplify", "MR"],
  " to make the assumption ",
  StyleBox["x", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["0", "MR"],
  ", so that simplification can proceed. "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.4"}],

Cell[CellGroupData[{

Cell["Simplify[Sqrt[x^2], x > 0]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell["No automatic simplification can be done on this expression. ", \
"MathCaption",
  CellTags->{"S1.4.6", "6.5"}],

Cell[CellGroupData[{

Cell["2 a + 2 Sqrt[a - Sqrt[-b]] Sqrt[a + Sqrt[-b]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(2\ a + 2\ \@\(a - \@\(-b\)\)\ \@\(a + \@\(-b\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      FormBox[
        StyleBox["a",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["b",
          "TI"], TraditionalForm]], "InlineFormula"],
  " are assumed to be positive, the expression can however be simplified. "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.6"}],

Cell[CellGroupData[{

Cell["Simplify[%, a > 0 && b > 0]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(2\ \((a + \@\(a\^2 + b\))\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell["Here is a simple example involving trigonometric functions. ", \
"MathCaption",
  CellTags->{"S1.4.6", "6.7"}],

Cell[CellGroupData[{

Cell["Simplify[ArcSin[Sin[x]], -Pi/2 < x < Pi/2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Element[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "state that ",
              StyleBox["x", "TI"],
              " is an element of the domain ",
              StyleBox["dom", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Element[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["dom", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "state that all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are elements of the domain ",
              StyleBox["dom", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reals", "MR"],
              " "
            }]], Cell["real numbers "]},
          {Cell[TextData[{
              StyleBox["Integers", "MR"],
              " "
            }]], Cell["integers "]},
          {Cell[TextData[{
              StyleBox["Primes", "MR"],
              " "
            }]], Cell["prime numbers "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S1.4.6"],

Cell["Some domains used in assumptions. ", "Caption",
  CellTags->"S1.4.6"],

Cell[TextData[{
  "This simplifies ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]], TraditionalForm]], "InlineFormula"],
  " assuming that ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a real number. "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.8"}],

Cell[CellGroupData[{

Cell["Simplify[Sqrt[x^2], Element[x, Reals]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(Abs[x]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell[TextData[{
  "This simplifies the sine assuming that ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is an integer. "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.9"}],

Cell[CellGroupData[{

Cell["Simplify[Sin[x + 2 n Pi], Element[n, Integers]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(Sin[x]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell["\<\
With the assumptions given, Fermat's Little Theorem can be used.  \
\
\>", "MathCaption",
  CellTags->{"S1.4.6", "6.10"}],

Cell[CellGroupData[{

Cell["\<\
Simplify[Mod[a^p, p], Element[a, Integers] && Element[p, Primes]]\
\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \(Mod[a, p]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.4.6"]
}, Open  ]],

Cell[TextData[{
  "This uses the fact that ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", but not ",
  Cell[BoxData[
      FormBox[
        RowBox[{"arcsin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", is real when ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is real. "
}], "MathCaption",
  CellTags->{"S1.4.6", "6.11"}],

Cell[CellGroupData[{

Cell["Simplify[Re[{Sin[x], ArcSin[x]}], Element[x, Reals]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.4.6"],

Cell[BoxData[
    \({Sin[x], Re[ArcSin[x]]}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.4.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.7 Picking Out Pieces of Algebraic Expressions", "Subsection",
  CellTags->{"S1.4.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Coefficient[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "coefficient of ",
              StyleBox["form", "TI"],
              " in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Exponent[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximum power of ",
              StyleBox["form", "TI"],
              " in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["expr", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " term of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.7"],

Cell["Functions to pick out pieces of polynomials. ", "Caption",
  CellTags->"S1.4.7"],

Cell["Here is an algebraic expression. ", "MathCaption",
  CellTags->{"S1.4.7", "7.2"}],

Cell[CellGroupData[{

Cell["e = Expand[(1 + 3x + 4y^2)^2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(1 + 6\ x + 9\ x\^2 + 8\ y\^2 + 24\ x\ y\^2 + 16\ y\^4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[TextData[{
  "This gives the coefficient of ",
  StyleBox["x", "MR"],
  " in ",
  StyleBox["e", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.7", "7.3"}],

Cell[CellGroupData[{

Cell["Coefficient[e, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(6 + 24\ y\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Exponent[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  " gives the highest power of ",
  StyleBox["y", "TI"],
  " that appears in ",
  StyleBox["expr", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.7", "7.4"}],

Cell[CellGroupData[{

Cell["Exponent[e, y]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[TextData[{
  "This gives the fourth term in ",
  StyleBox["e", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.4.7", "7.5"}],

Cell[CellGroupData[{

Cell["Part[e, 4]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(8\ y\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[TextData[{
  "You may notice that the function ",
  StyleBox["Part[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " used to pick out the ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " term in a sum is the same as the function described in Section ",
  ButtonBox["1.2.4",
    ButtonData:>{"1.2.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " for picking out elements in lists. This is no coincidence. In fact, as \
discussed in Section ",
  ButtonBox["2.1.5",
    ButtonData:>{"2.1.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ", every ",
  StyleBox["Mathematica", "TI"],
  " expression can be manipulated structurally much like a list. However, as \
discussed in Section ",
  ButtonBox["2.1.5",
    ButtonData:>{"2.1.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ", you must be careful, because ",
  StyleBox["Mathematica", "TI"],
  " often shows algebraic expressions in a form that is different from the \
way it treats them internally. "
}], "Text",
  CellTags->{"S1.4.7", "7.6"}],

Cell[TextData[{
  StyleBox["Coefficient", "MR"],
  " works even with polynomials that are not explicitly expanded out. "
}], "MathCaption",
  CellTags->{"S1.4.7", "7.7"}],

Cell[CellGroupData[{

Cell["Coefficient[(1 + 3x + 4y^2)^2, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(6 + 24\ y\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Numerator[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerator of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Denominator[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "denominator of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.7"],

Cell["Functions to pick out pieces of rational expressions. ", "Caption",
  CellTags->"S1.4.7"],

Cell["Here is a rational expression. ", "MathCaption",
  CellTags->{"S1.4.7", "7.8"}],

Cell[CellGroupData[{

Cell["r = (1 + x)/(2 (2 - y))", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(\(1 + x\)\/\(2\ \((2 - y)\)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Denominator", "MR"],
  " picks out the denominator. "
}], "MathCaption",
  CellTags->{"S1.4.7", "7.9"}],

Cell[CellGroupData[{

Cell["Denominator[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(2\ \((2 - y)\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Denominator", "MR"],
  " gives ",
  StyleBox["1", "MR"],
  " for expressions that are not quotients. "
}], "MathCaption",
  CellTags->{"S1.4.7", "7.10"}],

Cell[CellGroupData[{

Cell["Denominator[1/x + 2/y]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.4.7"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.4.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.8 Controlling the Display of Large Expressions", "Subsection",
  CellTags->{"S1.4.8", "8.1"}],

Cell[TextData[{
  "When you do symbolic calculations, it is quite easy to end up with \
extremely complicated expressions. Often, you will not even want to ",
  StyleBox["see", "TI"],
  " the complete result of a computation. "
}], "Text",
  CellTags->{"S1.4.8", "8.2"}],

Cell[TextData[{
  "If you end your input with a semicolon, ",
  StyleBox["Mathematica", "TI"],
  " will do the computation you asked for, but will not display the result. \
You can nevertheless use ",
  StyleBox["%", "MR"],
  " or ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " to refer to the result.  "
}], "Text",
  CellTags->{"S1.4.8", "8.3"}],

Cell[TextData[{
  "Even though you may not want to see the ",
  StyleBox["whole", "TI"],
  " result from a computation, you often do need to see its basic form. You \
can use ",
  StyleBox["Short", "MR"],
  " to display the ",
  StyleBox["outline", "TI"],
  " of an expression, omitting some of the terms.   "
}], "Text",
  CellTags->{"S1.4.8", "8.4"}],

Cell[TextData[{
  "Ending your input with ",
  StyleBox[";", "MR"],
  " stops ",
  StyleBox["Mathematica", "TI"],
  " from displaying the complicated result of the computation. "
}], "MathCaption",
  CellTags->{"S1.4.8", "8.5"}],

Cell["Expand[(x + 5 y + 10)^8] ;", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.8"],

Cell[TextData[{
  "You can still refer to the result as ",
  StyleBox["%", "MR"],
  ". ",
  StyleBox["//Short", "MR"],
  " displays a one\[Hyphen]line outline of the result. The ",
  StyleBox["<<", "MR"],
  StyleBox["n", "TI"],
  StyleBox[">>", "MR"],
  " stands for ",
  StyleBox["n", "TI"],
  " terms that have been left out. "
}], "MathCaption",
  CellTags->{"S1.4.8", "8.6"}],

Cell[CellGroupData[{

Cell["% //Short", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.8"],

Cell[BoxData[
    TagBox[\(100000000 + 80000000\ x + \[LeftSkeleton]42\[RightSkeleton] + 
        390625\ y\^8\),
      Short]], "Output",
  CellLabel->"Out[2]//Short= ",
  CellTags->"S1.4.8"]
}, Open  ]],

Cell["\<\
This shows a three\[Hyphen]line version of the expression. More \
parts are now visible. \
\>", "MathCaption",
  CellTags->{"S1.4.8", "8.7"}],

Cell[CellGroupData[{

Cell["Short[%, 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.8"],

Cell[BoxData[
    TagBox[\(100000000 + 80000000\ x + 28000000\ x\^2 + 5600000\ x\^3 + 
        700000\ x\^4 + \[LeftSkeleton]35\[RightSkeleton] + 8750000\ x\ y\^6 + 
        437500\ x\^2\ y\^6 + 6250000\ y\^7 + 625000\ x\ y\^7 + 
        390625\ y\^8\),
      (Short[ #, 3]&)]], "Output",
  CellLabel->"Out[3]//Short= ",
  CellTags->"S1.4.8"]
}, Open  ]],

Cell["This gives the total number of terms in the sum.  ", "MathCaption",
  CellTags->{"S1.4.8", "8.8"}],

Cell[CellGroupData[{

Cell["Length[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.8"],

Cell[BoxData[
    \(45\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["command", "TI"],
              " ",
              StyleBox[";", "MR"],
              " "
            }]], Cell[TextData[{
              "execute ",
              StyleBox["command", "TI"],
              ", but do not print the result "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["//", "MR"],
              " ",
              StyleBox["Short", "MR"],
              " "
            }]], Cell[TextData[{
              "show a one\[Hyphen]line outline form of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Short[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "show an ",
              StyleBox["n", "TI"],
              "\[Hyphen]line outline of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.8"],

Cell["Some ways to shorten your output. ", "Caption",
  CellTags->"S1.4.8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.4.9 The Limits of ",
  StyleBox["Mathematica", "SBO"]
}], "Subsection",
  CellTags->{"S1.4.9", "9.1"}],

Cell[TextData[{
  "In just one ",
  StyleBox["Mathematica", "TI"],
  " command, you can easily specify a calculation that is far too complicated \
for any computer to do. For example, you could ask for ",
  StyleBox["Expand[(1+x)^(10^100)]", "MR"],
  ". The result of this calculation would have ",
  Cell[BoxData[
      \(TraditionalForm\`10\^100 + 1\)], "InlineFormula"],
  " terms\[LongDash]more than the total number of particles in the universe. \
"
}], "Text",
  CellTags->{"S1.4.9", "9.2"}],

Cell[TextData[{
  "You should have no trouble working out ",
  StyleBox["Expand[(1+x)^100]", "MR"],
  " on any computer that can run ",
  StyleBox["Mathematica", "TI"],
  ". But as you increase the exponent of ",
  StyleBox["(1+x)", "MR"],
  ", the results you get will eventually become too big for your computer's \
memory to hold. Exactly at what point this happens depends not only on the \
total amount of memory your computer has, but often also on such details as \
what other jobs happen to be running on your computer when you try to do your \
calculation. "
}], "Text",
  CellTags->{"S1.4.9", "9.3"}],

Cell[TextData[{
  "If your computer does run out of memory in the middle of a calculation, \
most versions of ",
  StyleBox["Mathematica", "TI"],
  " have no choice but to stop immediately. As a result, it is important to \
plan your calculations so that they never need more memory than your computer \
has. "
}], "Text",
  CellTags->{"S1.4.9", "9.4"}],

Cell[TextData[{
  "Even if the result of an algebraic calculation is quite simple, the \
intermediate expressions that you generate in the course of the calculation \
can be very complicated. This means that even if the final result is small, \
the intermediate parts of a calculation can be too big for your computer to \
handle. If this happens, you can usually break your calculation into pieces, \
and succeed in doing each piece on its own. You should know that the internal \
scheme which ",
  StyleBox["Mathematica", "TI"],
  " uses for memory management is such that once part of a calculation is \
finished, the memory used to store intermediate expressions that arose is \
immediately made available for new expressions.  "
}], "Text",
  CellTags->{"S1.4.9", "9.5"}],

Cell[TextData[{
  "Memory space is the most common limiting factor in ",
  StyleBox["Mathematica", "TI"],
  " calculations. Time can also, however, be a limiting factor. You will \
usually be prepared to wait a second, or even a minute, for the result of a \
calculation. But you will less often be prepared to wait an hour or a day, \
and you will almost never be able to wait a year. "
}], "Text",
  CellTags->{"S1.4.9", "9.6"}],

Cell[TextData[{
  "The internal code of ",
  StyleBox["Mathematica", "TI"],
  " uses highly efficient and optimized algorithms. But there are some tasks \
for which the best known algorithms always eventually take a large amount of \
time. A typical issue is that the time required by the algorithm may increase \
almost exponentially with the size of the input. A classic case is integer \
factorization\[LongDash]where the best known algorithms require times that \
grow almost exponentially with the number of digits. In practice, you will \
find that ",
  StyleBox["FactorInteger[", "MR"],
  StyleBox["k", "TI"],
  StyleBox["]", "MR"],
  " will give a result almost immediately when ",
  StyleBox["k", "TI"],
  " has fewer than about 40 digits. But if ",
  StyleBox["k", "TI"],
  " has 60 digits, ",
  StyleBox["FactorInteger[", "MR"],
  StyleBox["k", "TI"],
  StyleBox["]", "MR"],
  " can start taking an unmanageably long time.  "
}], "Text",
  CellTags->{"S1.4.9", "9.7"}],

Cell[TextData[{
  "In some cases, there is progressive improvement in the algorithms that are \
known, so that successive versions of ",
  StyleBox["Mathematica", "TI"],
  " can perform particular computations progressively faster. But ideas from \
the theory of computation strongly suggest that many computations will always \
in effect require an irreducible amount of computational work\[LongDash]so \
that no fast algorithm for them will ever be found.   "
}], "Text",
  CellTags->{"S1.4.9", "9.8"}],

Cell[TextData[{
  "Whether or not the only algorithms involve exponentially increasing \
amounts of time, there will always come a point where a computation is too \
large or time\[Hyphen]consuming to do on your particular computer system. As \
you work with ",
  StyleBox["Mathematica", "TI"],
  ", you should develop some feeling for the limits on the kinds of \
calculations you can do in your particular application area. "
}], "Text",
  CellTags->{"S1.4.9", "9.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Doing arithmetic with numbers \
containing a few hundred million digits. \
\>"]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Generating a million digits of numbers \
like ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["e",
                      "TI"], TraditionalForm]], "InlineFormula"],
              "."
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Expanding out a polynomial that \
gives a million terms. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Factoring a polynomial in four \
variables with a hundred thousand terms. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Reducing a system of quadratic \
inequalities to a few thousand independent components. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Finding integer roots of a sparse \
polynomial with degree a million. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Applying a recursive rule a \
million times. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Calculating all the primes up to \
ten million. \
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Finding the numerical inverse of a ",
              Cell[BoxData[
                  \(TraditionalForm\`1000\[Cross]1000\)], "InlineFormula"],
              " dense matrix. "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Solving a million\[Hyphen]variable \
sparse linear system with a hundred thousand non\[Hyphen]zero coefficients. \
\
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Finding the determinant of a ",
              Cell[BoxData[
                  \(TraditionalForm\`250\[Cross]250\)], "InlineFormula"],
              " integer matrix. "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Finding the determinant of a ",
              Cell[BoxData[
                  \(TraditionalForm\`20\[Cross]20\)], "InlineFormula"],
              " symbolic matrix. "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Finding numerical roots of a \
polynomial of degree 200. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Solving a sparse linear \
programming problem with a few hundred thousand variables. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Finding the Fourier transform of a \
list with a hundred million elements. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Rendering a million graphics \
primitives. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Sorting a list of ten million \
elements. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Searching a string that is ten \
million characters long. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Importing a few tens of megabytes \
of numerical data. \
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Formatting a few hundred pages of ",
              StyleBox["TraditionalForm", "MR"],
              " output. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.4.9"],

Cell["\<\
Some operations that typically take a few seconds on a 2004 vintage \
PC. \
\>", "Caption",
  CellTags->"S1.4.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.4.10 Using Symbols to Tag Objects", "Subsection",
  CellTags->{"S1.4.10", "10.1"}],

Cell[TextData[{
  "There are many ways to use symbols in ",
  StyleBox["Mathematica", "TI"],
  ". So far, we have concentrated on using symbols to store values and to \
represent mathematical variables. This section describes another way to use \
symbols in ",
  StyleBox["Mathematica", "TI"],
  ".  "
}], "Text",
  CellTags->{"S1.4.10", "10.2"}],

Cell["\<\
The idea is to use symbols as \[OpenCurlyDoubleQuote]tags\
\[CloseCurlyDoubleQuote] for different types of objects. \
\>", "Text",
  CellTags->{"S1.4.10", "10.3"}],

Cell["\<\
Working with physical units gives one simple example. When you \
specify the length of an object, you want to give not only a number, but also \
the units in which the length is measured. In standard notation, you might \
write a length as 12 meters. \
\>", "Text",
  CellTags->{"S1.4.10", "10.4"}],

Cell[TextData[{
  "You can imitate this notation almost directly in ",
  StyleBox["Mathematica", "TI"],
  ". You can for example simply use a symbol ",
  StyleBox["meters", "MR"],
  " to indicate the units of our measurement. "
}], "Text",
  CellTags->{"S1.4.10", "10.5"}],

Cell[TextData[{
  "The symbol ",
  StyleBox["meters", "MR"],
  " here acts as a tag, which indicates the units used. "
}], "MathCaption",
  CellTags->{"S1.4.10", "10.6"}],

Cell[CellGroupData[{

Cell["12 meters", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(12\ meters\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.4.10"]
}, Open  ]],

Cell["You can add lengths like this. ", "MathCaption",
  CellTags->{"S1.4.10", "10.7"}],

Cell[CellGroupData[{

Cell["% + 5.3 meters", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(17.3`\ meters\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.4.10"]
}, Open  ]],

Cell["This gives a speed. ", "MathCaption",
  CellTags->{"S1.4.10", "10.8"}],

Cell[CellGroupData[{

Cell["% / (25 seconds)", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(\(0.6920000000000001`\ meters\)\/seconds\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.4.10"]
}, Open  ]],

Cell["This converts to a speed in feet per second. ", "MathCaption",
  CellTags->{"S1.4.10", "10.9"}],

Cell[CellGroupData[{

Cell["% /. meters -> 3.28084 feet", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(\(2.2703412800000002`\ feet\)\/seconds\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.4.10"]
}, Open  ]],

Cell[TextData[{
  "There is in fact a standard ",
  StyleBox["Mathematica", "TI"],
  " package that allows you to work with units. The package defines many \
symbols that represent standard types of units. "
}], "Text",
  CellTags->{"S1.4.10", "10.10"}],

Cell[TextData[{
  "Load the ",
  StyleBox["Mathematica", "TI"],
  " package for handling units. "
}], "MathCaption",
  CellTags->{"S1.4.10", "10.11"}],

Cell["<<Miscellaneous`Units`", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.4.10"],

Cell["The package uses standardized names for units. ", "MathCaption",
  CellTags->{"S1.4.10", "10.12"}],

Cell[CellGroupData[{

Cell["12 Meter/Second", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(\(12\ Meter\)\/Second\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.4.10"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Convert[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["units", "TI"],
  StyleBox["]", "MR"],
  " converts to the specified units. "
}], "MathCaption",
  CellTags->{"S1.4.10", "10.13"}],

Cell[CellGroupData[{

Cell["Convert[ %, Mile/Hour ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(\(37500\ Mile\)\/\(1397\ Hour\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.4.10"]
}, Open  ]],

Cell["\<\
Usually you have to give prefixes for units as separate words. \
\
\>", "MathCaption",
  CellTags->{"S1.4.10", "10.14"}],

Cell[CellGroupData[{

Cell["Convert[ 3 Kilo Meter / Hour, Inch / Minute ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.4.10"],

Cell[BoxData[
    \(\(250000\ Inch\)\/\(127\ Minute\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.4.10"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.4.0"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S1.4.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S1.4.0", "0.1"}]},
  "S1.4.1"->{
    Cell[1926, 61, 79, 1, 70, "Subsection",
      CellTags->{"S1.4.1", "1.1"}],
    Cell[2008, 64, 326, 10, 70, "Text",
      CellTags->{"S1.4.1", "1.2"}],
    Cell[2337, 76, 95, 1, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.3"}],
    Cell[2457, 81, 74, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[2534, 85, 83, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[2632, 91, 86, 1, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.4"}],
    Cell[2743, 96, 74, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[2820, 100, 89, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[2924, 106, 1420, 46, 70, "DefinitionBox",
      CellTags->"S1.4.1"],
    Cell[4347, 154, 78, 1, 70, "Caption",
      CellTags->"S1.4.1"],
    Cell[4428, 157, 154, 5, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.5"}],
    Cell[4607, 166, 77, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[4687, 170, 101, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[4803, 176, 705, 25, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.6"}],
    Cell[5533, 205, 79, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[5615, 209, 92, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[5722, 215, 694, 23, 70, "Text",
      CellTags->{"S1.4.1", "1.7"}],
    Cell[6419, 240, 171, 4, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.8"}],
    Cell[6615, 248, 95, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[6713, 252, 116, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[6844, 258, 92, 1, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.9"}],
    Cell[6961, 263, 85, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[7049, 267, 120, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[7184, 273, 155, 5, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.10"}],
    Cell[7364, 282, 73, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[7440, 286, 129, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[7584, 292, 168, 6, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.11"}],
    Cell[7777, 302, 73, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[7853, 306, 120, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[7988, 312, 970, 30, 70, "Text",
      CellTags->{"S1.4.1", "1.12"}],
    Cell[8961, 344, 132, 4, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.13"}],
    Cell[9118, 352, 117, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[9238, 356, 185, 4, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[9438, 363, 563, 15, 70, "Text",
      CellTags->{"S1.4.1", "1.14"}],
    Cell[10004, 380, 618, 21, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.15"}],
    Cell[10647, 405, 78, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[10728, 409, 96, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[10839, 415, 202, 5, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.16"}],
    Cell[11066, 424, 80, 2, 70, "Input",
      CellTags->"S1.4.1"],
    Cell[11149, 428, 97, 3, 70, "Output",
      CellTags->"S1.4.1"],
    Cell[11261, 434, 314, 7, 70, "Text",
      CellTags->{"S1.4.1", "1.17"}],
    Cell[11578, 443, 338, 7, 70, "Text",
      CellTags->{"S1.4.1", "1.18"}],
    Cell[11919, 452, 347, 11, 70, "FramedBox",
      CellTags->"S1.4.1"],
    Cell[12269, 465, 127, 5, 70, "Caption",
      CellTags->"S1.4.1"]},
  "1.1"->{
    Cell[1926, 61, 79, 1, 70, "Subsection",
      CellTags->{"S1.4.1", "1.1"}]},
  "1.2"->{
    Cell[2008, 64, 326, 10, 70, "Text",
      CellTags->{"S1.4.1", "1.2"}]},
  "1.3"->{
    Cell[2337, 76, 95, 1, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.3"}]},
  "1.4"->{
    Cell[2632, 91, 86, 1, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.4"}]},
  "1.5"->{
    Cell[4428, 157, 154, 5, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.5"}]},
  "1.6"->{
    Cell[4803, 176, 705, 25, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.6"}]},
  "1.7"->{
    Cell[5722, 215, 694, 23, 70, "Text",
      CellTags->{"S1.4.1", "1.7"}]},
  "1.8"->{
    Cell[6419, 240, 171, 4, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.8"}]},
  "1.9"->{
    Cell[6844, 258, 92, 1, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.9"}]},
  "1.10"->{
    Cell[7184, 273, 155, 5, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.10"}]},
  "1.11"->{
    Cell[7584, 292, 168, 6, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.11"}]},
  "1.12"->{
    Cell[7988, 312, 970, 30, 70, "Text",
      CellTags->{"S1.4.1", "1.12"}]},
  "1.13"->{
    Cell[8961, 344, 132, 4, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.13"}]},
  "1.14"->{
    Cell[9438, 363, 563, 15, 70, "Text",
      CellTags->{"S1.4.1", "1.14"}]},
  "1.15"->{
    Cell[10004, 380, 618, 21, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.15"}]},
  "1.16"->{
    Cell[10839, 415, 202, 5, 70, "MathCaption",
      CellTags->{"S1.4.1", "1.16"}]},
  "1.17"->{
    Cell[11261, 434, 314, 7, 70, "Text",
      CellTags->{"S1.4.1", "1.17"}]},
  "1.18"->{
    Cell[11578, 443, 338, 7, 70, "Text",
      CellTags->{"S1.4.1", "1.18"}]},
  "S1.4.2"->{
    Cell[12433, 475, 77, 1, 70, "Subsection",
      CellTags->{"S1.4.2", "2.1"}],
    Cell[12513, 478, 459, 17, 70, "Text",
      CellTags->{"S1.4.2", "2.2"}],
    Cell[12975, 497, 291, 6, 70, "Text",
      CellTags->{"S1.4.2", "2.3"}],
    Cell[13269, 505, 968, 36, 70, "Text",
      CellTags->{"S1.4.2", "2.4"}],
    Cell[14240, 543, 434, 14, 70, "Text",
      CellTags->{"S1.4.2", "2.5"}],
    Cell[14677, 559, 247, 11, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.6"}],
    Cell[14949, 574, 80, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[15032, 578, 82, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[15129, 584, 298, 13, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.7"}],
    Cell[15452, 601, 89, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[15544, 605, 103, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[15662, 611, 187, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.8"}],
    Cell[15874, 620, 74, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[15951, 624, 96, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[16062, 630, 241, 10, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.9"}],
    Cell[16328, 644, 76, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[16407, 648, 104, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[16526, 654, 1407, 47, 70, "DefinitionBox",
      CellTags->"S1.4.2"],
    Cell[17936, 703, 85, 1, 70, "Caption",
      CellTags->"S1.4.2"],
    Cell[18024, 706, 126, 4, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.10"}],
    Cell[18175, 714, 105, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[18283, 718, 108, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[18406, 724, 468, 15, 70, "Text",
      CellTags->{"S1.4.2", "2.11"}],
    Cell[18877, 741, 646, 29, 70, "Text",
      CellTags->{"S1.4.2", "2.12"}],
    Cell[19526, 772, 158, 7, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.13"}],
    Cell[19709, 783, 69, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[19781, 787, 82, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[19878, 793, 190, 7, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.14"}],
    Cell[20093, 804, 71, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[20167, 808, 82, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[20264, 814, 239, 11, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.15"}],
    Cell[20528, 829, 73, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[20604, 833, 86, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[20705, 839, 211, 11, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.16"}],
    Cell[20941, 854, 71, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[21015, 858, 104, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[21134, 864, 507, 10, 70, "Text",
      CellTags->{"S1.4.2", "2.17"}],
    Cell[21644, 876, 849, 28, 70, "DefinitionBox",
      CellTags->"S1.4.2"],
    Cell[22496, 906, 70, 1, 70, "Caption",
      CellTags->"S1.4.2"],
    Cell[22569, 909, 158, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.18"}],
    Cell[22752, 918, 75, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[22830, 922, 104, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[22949, 928, 159, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.19"}],
    Cell[23111, 935, 69, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[23183, 939, 176, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.20"}],
    Cell[23384, 948, 75, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[23462, 952, 87, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[23564, 958, 631, 16, 70, "Text",
      CellTags->{"S1.4.2", "2.21"}],
    Cell[24198, 976, 736, 21, 70, "Text",
      CellTags->{"S1.4.2", "2.22"}],
    Cell[24937, 999, 566, 18, 70, "Text",
      CellTags->{"S1.4.2", "2.23"}],
    Cell[25506, 1019, 257, 5, 70, "Text",
      CellTags->{"S1.4.2", "2.24"}],
    Cell[25766, 1026, 137, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.25"}],
    Cell[25928, 1035, 76, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[26007, 1039, 90, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[26112, 1045, 214, 9, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.26"}],
    Cell[26351, 1058, 76, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[26430, 1062, 83, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[26528, 1068, 181, 7, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.27"}],
    Cell[26734, 1079, 77, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[26814, 1083, 94, 3, 70, "Output",
      CellTags->"S1.4.2"],
    Cell[26923, 1089, 250, 9, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.28"}],
    Cell[27198, 1102, 81, 2, 70, "Input",
      CellTags->"S1.4.2"],
    Cell[27282, 1106, 101, 3, 70, "Output",
      CellTags->"S1.4.2"]},
  "2.1"->{
    Cell[12433, 475, 77, 1, 70, "Subsection",
      CellTags->{"S1.4.2", "2.1"}]},
  "2.2"->{
    Cell[12513, 478, 459, 17, 70, "Text",
      CellTags->{"S1.4.2", "2.2"}]},
  "2.3"->{
    Cell[12975, 497, 291, 6, 70, "Text",
      CellTags->{"S1.4.2", "2.3"}]},
  "2.4"->{
    Cell[13269, 505, 968, 36, 70, "Text",
      CellTags->{"S1.4.2", "2.4"}]},
  "2.5"->{
    Cell[14240, 543, 434, 14, 70, "Text",
      CellTags->{"S1.4.2", "2.5"}]},
  "2.6"->{
    Cell[14677, 559, 247, 11, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.6"}]},
  "2.7"->{
    Cell[15129, 584, 298, 13, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.7"}]},
  "2.8"->{
    Cell[15662, 611, 187, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.8"}]},
  "2.9"->{
    Cell[16062, 630, 241, 10, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.9"}]},
  "2.10"->{
    Cell[18024, 706, 126, 4, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.10"}]},
  "2.11"->{
    Cell[18406, 724, 468, 15, 70, "Text",
      CellTags->{"S1.4.2", "2.11"}]},
  "2.12"->{
    Cell[18877, 741, 646, 29, 70, "Text",
      CellTags->{"S1.4.2", "2.12"}]},
  "2.13"->{
    Cell[19526, 772, 158, 7, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.13"}]},
  "2.14"->{
    Cell[19878, 793, 190, 7, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.14"}]},
  "2.15"->{
    Cell[20264, 814, 239, 11, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.15"}]},
  "2.16"->{
    Cell[20705, 839, 211, 11, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.16"}]},
  "2.17"->{
    Cell[21134, 864, 507, 10, 70, "Text",
      CellTags->{"S1.4.2", "2.17"}]},
  "2.18"->{
    Cell[22569, 909, 158, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.18"}]},
  "2.19"->{
    Cell[22949, 928, 159, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.19"}]},
  "2.20"->{
    Cell[23183, 939, 176, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.20"}]},
  "2.21"->{
    Cell[23564, 958, 631, 16, 70, "Text",
      CellTags->{"S1.4.2", "2.21"}]},
  "2.22"->{
    Cell[24198, 976, 736, 21, 70, "Text",
      CellTags->{"S1.4.2", "2.22"}]},
  "2.23"->{
    Cell[24937, 999, 566, 18, 70, "Text",
      CellTags->{"S1.4.2", "2.23"}]},
  "2.24"->{
    Cell[25506, 1019, 257, 5, 70, "Text",
      CellTags->{"S1.4.2", "2.24"}]},
  "2.25"->{
    Cell[25766, 1026, 137, 5, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.25"}]},
  "2.26"->{
    Cell[26112, 1045, 214, 9, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.26"}]},
  "2.27"->{
    Cell[26528, 1068, 181, 7, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.27"}]},
  "2.28"->{
    Cell[26923, 1089, 250, 9, 70, "MathCaption",
      CellTags->{"S1.4.2", "2.28"}]},
  "S1.4.3"->{
    Cell[27432, 1115, 93, 1, 70, "Subsection",
      CellTags->{"S1.4.3", "3.1"}],
    Cell[27528, 1118, 798, 24, 70, "Text",
      CellTags->{"S1.4.3", "3.2"}],
    Cell[28329, 1144, 807, 26, 70, "DefinitionBox",
      CellTags->"S1.4.3"],
    Cell[29139, 1172, 112, 4, 70, "Caption",
      CellTags->"S1.4.3"],
    Cell[29254, 1178, 214, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.3"}],
    Cell[29493, 1187, 83, 2, 70, "Input",
      CellTags->"S1.4.3"],
    Cell[29579, 1191, 96, 3, 70, "Output",
      CellTags->"S1.4.3"],
    Cell[29690, 1197, 128, 4, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.4"}],
    Cell[29843, 1205, 75, 2, 70, "Input",
      CellTags->"S1.4.3"],
    Cell[29921, 1209, 95, 3, 70, "Output",
      CellTags->"S1.4.3"],
    Cell[30031, 1215, 158, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.5"}],
    Cell[30214, 1224, 89, 2, 70, "Input",
      CellTags->"S1.4.3"],
    Cell[30306, 1228, 258, 5, 70, "Output",
      CellTags->"S1.4.3"],
    Cell[30579, 1236, 136, 4, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.6"}],
    Cell[30740, 1244, 75, 2, 70, "Input",
      CellTags->"S1.4.3"],
    Cell[30818, 1248, 102, 3, 70, "Output",
      CellTags->"S1.4.3"],
    Cell[30935, 1254, 184, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.7"}],
    Cell[31144, 1263, 82, 2, 70, "Input",
      CellTags->"S1.4.3"],
    Cell[31229, 1267, 189, 4, 70, "Output",
      CellTags->"S1.4.3"],
    Cell[31433, 1274, 190, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.8"}],
    Cell[31648, 1283, 75, 2, 70, "Input",
      CellTags->"S1.4.3"],
    Cell[31726, 1287, 95, 3, 70, "Output",
      CellTags->"S1.4.3"]},
  "3.1"->{
    Cell[27432, 1115, 93, 1, 70, "Subsection",
      CellTags->{"S1.4.3", "3.1"}]},
  "3.2"->{
    Cell[27528, 1118, 798, 24, 70, "Text",
      CellTags->{"S1.4.3", "3.2"}]},
  "3.3"->{
    Cell[29254, 1178, 214, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.3"}]},
  "3.4"->{
    Cell[29690, 1197, 128, 4, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.4"}]},
  "3.5"->{
    Cell[30031, 1215, 158, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.5"}]},
  "3.6"->{
    Cell[30579, 1236, 136, 4, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.6"}]},
  "3.7"->{
    Cell[30935, 1254, 184, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.7"}]},
  "3.8"->{
    Cell[31433, 1274, 190, 5, 70, "MathCaption",
      CellTags->{"S1.4.3", "3.8"}]},
  "S1.4.4"->{
    Cell[31870, 1296, 92, 1, 70, "Subsection",
      CellTags->{"S1.4.4", "4.1"}],
    Cell[31965, 1299, 476, 9, 70, "Text",
      CellTags->{"S1.4.4", "4.2"}],
    Cell[32444, 1310, 868, 26, 70, "DefinitionBox",
      CellTags->"S1.4.4"],
    Cell[33315, 1338, 76, 1, 70, "Caption",
      CellTags->"S1.4.4"],
    Cell[33394, 1341, 363, 13, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.3"}],
    Cell[33782, 1358, 86, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[33871, 1362, 95, 3, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[33981, 1368, 368, 12, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.4"}],
    Cell[34374, 1384, 82, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[34459, 1388, 95, 3, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[34569, 1394, 248, 6, 70, "Text",
      CellTags->{"S1.4.4", "4.5"}],
    Cell[34820, 1402, 506, 17, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.6"}],
    Cell[35351, 1423, 87, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[35441, 1427, 152, 4, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[35608, 1434, 267, 6, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.7"}],
    Cell[35900, 1444, 71, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[35974, 1448, 165, 4, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[36154, 1455, 179, 5, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.8"}],
    Cell[36358, 1464, 75, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[36436, 1468, 101, 3, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[36552, 1474, 320, 7, 70, "Text",
      CellTags->{"S1.4.4", "4.9"}],
    Cell[36875, 1483, 226, 5, 70, "Text",
      CellTags->{"S1.4.4", "4.10"}],
    Cell[37104, 1490, 135, 4, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.11"}],
    Cell[37264, 1498, 95, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[37362, 1502, 103, 3, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[37480, 1508, 149, 4, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.12"}],
    Cell[37654, 1516, 99, 2, 70, "Input",
      CellTags->"S1.4.4"],
    Cell[37756, 1520, 101, 3, 70, "Output",
      CellTags->"S1.4.4"],
    Cell[37872, 1526, 260, 6, 70, "Text",
      CellTags->{"S1.4.4", "4.13"}],
    Cell[38135, 1534, 331, 7, 70, "Text",
      CellTags->{"S1.4.4", "4.14"}],
    Cell[38469, 1543, 432, 10, 70, "Text",
      CellTags->{"S1.4.4", "4.15"}],
    Cell[38904, 1555, 455, 10, 70, "Text",
      CellTags->{"S1.4.4", "4.16"}]},
  "4.1"->{
    Cell[31870, 1296, 92, 1, 70, "Subsection",
      CellTags->{"S1.4.4", "4.1"}]},
  "4.2"->{
    Cell[31965, 1299, 476, 9, 70, "Text",
      CellTags->{"S1.4.4", "4.2"}]},
  "4.3"->{
    Cell[33394, 1341, 363, 13, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.3"}]},
  "4.4"->{
    Cell[33981, 1368, 368, 12, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.4"}]},
  "4.5"->{
    Cell[34569, 1394, 248, 6, 70, "Text",
      CellTags->{"S1.4.4", "4.5"}]},
  "4.6"->{
    Cell[34820, 1402, 506, 17, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.6"}]},
  "4.7"->{
    Cell[35608, 1434, 267, 6, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.7"}]},
  "4.8"->{
    Cell[36154, 1455, 179, 5, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.8"}]},
  "4.9"->{
    Cell[36552, 1474, 320, 7, 70, "Text",
      CellTags->{"S1.4.4", "4.9"}]},
  "4.10"->{
    Cell[36875, 1483, 226, 5, 70, "Text",
      CellTags->{"S1.4.4", "4.10"}]},
  "4.11"->{
    Cell[37104, 1490, 135, 4, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.11"}]},
  "4.12"->{
    Cell[37480, 1508, 149, 4, 70, "MathCaption",
      CellTags->{"S1.4.4", "4.12"}]},
  "4.13"->{
    Cell[37872, 1526, 260, 6, 70, "Text",
      CellTags->{"S1.4.4", "4.13"}]},
  "4.14"->{
    Cell[38135, 1534, 331, 7, 70, "Text",
      CellTags->{"S1.4.4", "4.14"}]},
  "4.15"->{
    Cell[38469, 1543, 432, 10, 70, "Text",
      CellTags->{"S1.4.4", "4.15"}]},
  "4.16"->{
    Cell[38904, 1555, 455, 10, 70, "Text",
      CellTags->{"S1.4.4", "4.16"}]},
  "S1.4.5"->{
    Cell[39396, 1570, 125, 4, 70, "Subsection",
      CellTags->{"S1.4.5", "5.1"}],
    Cell[39524, 1576, 273, 7, 70, "Text",
      CellTags->{"S1.4.5", "5.2"}],
    Cell[39800, 1585, 358, 10, 70, "Text",
      CellTags->{"S1.4.5", "5.3"}],
    Cell[40161, 1597, 2049, 59, 70, "DefinitionBox",
      CellTags->"S1.4.5"],
    Cell[42213, 1658, 91, 1, 70, "Caption",
      CellTags->"S1.4.5"],
    Cell[42307, 1661, 139, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.4"}],
    Cell[42471, 1669, 107, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[42581, 1673, 157, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[42753, 1680, 171, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.5"}],
    Cell[42949, 1688, 73, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[43025, 1692, 223, 5, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[43263, 1700, 153, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.6"}],
    Cell[43441, 1708, 76, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[43520, 1712, 195, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[43730, 1719, 162, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.7"}],
    Cell[43917, 1727, 75, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[43995, 1731, 138, 3, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[44148, 1737, 163, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.8"}],
    Cell[44336, 1745, 72, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[44411, 1749, 168, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[44594, 1756, 163, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.9"}],
    Cell[44782, 1764, 73, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[44858, 1768, 157, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[45030, 1775, 181, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.10"}],
    Cell[45236, 1784, 75, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[45314, 1788, 157, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[45486, 1795, 307, 6, 70, "Text",
      CellTags->{"S1.4.5", "5.11"}],
    Cell[45796, 1803, 451, 8, 70, "Text",
      CellTags->{"S1.4.5", "5.12"}],
    Cell[46250, 1813, 1014, 32, 70, "DefinitionBox",
      CellTags->"S1.4.5"],
    Cell[47267, 1847, 87, 1, 70, "Caption",
      CellTags->"S1.4.5"],
    Cell[47357, 1850, 105, 1, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.13"}],
    Cell[47487, 1855, 99, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[47589, 1859, 197, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[47801, 1866, 194, 7, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.14"}],
    Cell[48020, 1877, 77, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[48100, 1881, 201, 5, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[48316, 1889, 133, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.15"}],
    Cell[48474, 1898, 78, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[48555, 1902, 205, 5, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[48775, 1910, 153, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.16"}],
    Cell[48953, 1919, 82, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[49038, 1923, 139, 3, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[49192, 1929, 918, 20, 70, "Text",
      CellTags->{"S1.4.5", "5.17"}],
    Cell[50113, 1951, 200, 5, 70, "Text",
      CellTags->{"S1.4.5", "5.18"}],
    Cell[50316, 1958, 3052, 83, 70, "DefinitionBox",
      CellTags->"S1.4.5"],
    Cell[53371, 2043, 92, 1, 70, "Caption",
      CellTags->"S1.4.5"],
    Cell[53466, 2046, 199, 6, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.19"}],
    Cell[53690, 2056, 91, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[53784, 2060, 142, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[53941, 2067, 147, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.20"}],
    Cell[54113, 2075, 78, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[54194, 2079, 134, 3, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[54343, 2085, 109, 1, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.21"}],
    Cell[54477, 2090, 78, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[54558, 2094, 129, 3, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[54702, 2100, 186, 7, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.22"}],
    Cell[54913, 2111, 94, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[55010, 2115, 130, 3, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[55155, 2121, 183, 7, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.23"}],
    Cell[55363, 2132, 102, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[55468, 2136, 194, 4, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[55677, 2143, 501, 12, 70, "Text",
      CellTags->{"S1.4.5", "5.24"}],
    Cell[56181, 2157, 181, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.25"}],
    Cell[56387, 2166, 74, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[56464, 2170, 92, 3, 70, "Output",
      CellTags->"S1.4.5"],
    Cell[56571, 2176, 125, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.26"}],
    Cell[56721, 2184, 79, 2, 70, "Input",
      CellTags->"S1.4.5"],
    Cell[56803, 2188, 90, 3, 70, "Output",
      CellTags->"S1.4.5"]},
  "5.1"->{
    Cell[39396, 1570, 125, 4, 70, "Subsection",
      CellTags->{"S1.4.5", "5.1"}]},
  "5.2"->{
    Cell[39524, 1576, 273, 7, 70, "Text",
      CellTags->{"S1.4.5", "5.2"}]},
  "5.3"->{
    Cell[39800, 1585, 358, 10, 70, "Text",
      CellTags->{"S1.4.5", "5.3"}]},
  "5.4"->{
    Cell[42307, 1661, 139, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.4"}]},
  "5.5"->{
    Cell[42753, 1680, 171, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.5"}]},
  "5.6"->{
    Cell[43263, 1700, 153, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.6"}]},
  "5.7"->{
    Cell[43730, 1719, 162, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.7"}]},
  "5.8"->{
    Cell[44148, 1737, 163, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.8"}]},
  "5.9"->{
    Cell[44594, 1756, 163, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.9"}]},
  "5.10"->{
    Cell[45030, 1775, 181, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.10"}]},
  "5.11"->{
    Cell[45486, 1795, 307, 6, 70, "Text",
      CellTags->{"S1.4.5", "5.11"}]},
  "5.12"->{
    Cell[45796, 1803, 451, 8, 70, "Text",
      CellTags->{"S1.4.5", "5.12"}]},
  "5.13"->{
    Cell[47357, 1850, 105, 1, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.13"}]},
  "5.14"->{
    Cell[47801, 1866, 194, 7, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.14"}]},
  "5.15"->{
    Cell[48316, 1889, 133, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.15"}]},
  "5.16"->{
    Cell[48775, 1910, 153, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.16"}]},
  "5.17"->{
    Cell[49192, 1929, 918, 20, 70, "Text",
      CellTags->{"S1.4.5", "5.17"}]},
  "5.18"->{
    Cell[50113, 1951, 200, 5, 70, "Text",
      CellTags->{"S1.4.5", "5.18"}]},
  "5.19"->{
    Cell[53466, 2046, 199, 6, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.19"}]},
  "5.20"->{
    Cell[53941, 2067, 147, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.20"}]},
  "5.21"->{
    Cell[54343, 2085, 109, 1, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.21"}]},
  "5.22"->{
    Cell[54702, 2100, 186, 7, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.22"}]},
  "5.23"->{
    Cell[55155, 2121, 183, 7, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.23"}]},
  "5.24"->{
    Cell[55677, 2143, 501, 12, 70, "Text",
      CellTags->{"S1.4.5", "5.24"}]},
  "5.25"->{
    Cell[56181, 2157, 181, 5, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.25"}]},
  "5.26"->{
    Cell[56571, 2176, 125, 4, 70, "MathCaption",
      CellTags->{"S1.4.5", "5.26"}]},
  "S1.4.6"->{
    Cell[56942, 2197, 103, 1, 70, "Subsection",
      CellTags->{"S1.4.6", "6.1"}],
    Cell[57048, 2200, 609, 19, 70, "DefinitionBox",
      CellTags->"S1.4.6"],
    Cell[57660, 2221, 71, 1, 70, "Caption",
      CellTags->"S1.4.6"],
    Cell[57734, 2224, 216, 7, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.2"}],
    Cell[57975, 2235, 83, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[58061, 2239, 87, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[58163, 2245, 552, 21, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.3"}],
    Cell[58740, 2270, 89, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[58832, 2274, 87, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[58934, 2280, 268, 11, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.4"}],
    Cell[59227, 2295, 90, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[59320, 2299, 82, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[59417, 2305, 116, 2, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.5"}],
    Cell[59558, 2311, 109, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[59670, 2315, 129, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[59814, 2321, 375, 13, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.6"}],
    Cell[60214, 2338, 91, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[60308, 2342, 108, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[60431, 2348, 116, 2, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.7"}],
    Cell[60572, 2354, 106, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[60681, 2358, 82, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[60778, 2364, 2280, 69, 70, "DefinitionBox",
      CellTags->"S1.4.6"],
    Cell[63061, 2435, 75, 1, 70, "Caption",
      CellTags->"S1.4.6"],
    Cell[63139, 2438, 404, 15, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.8"}],
    Cell[63568, 2457, 102, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[63673, 2461, 87, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[63775, 2467, 238, 8, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.9"}],
    Cell[64038, 2479, 111, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[64152, 2483, 87, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[64254, 2489, 131, 4, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.10"}],
    Cell[64410, 2497, 139, 5, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[64552, 2504, 90, 3, 70, "Output",
      CellTags->"S1.4.6"],
    Cell[64657, 2510, 602, 22, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.11"}],
    Cell[65284, 2536, 117, 2, 70, "Input",
      CellTags->"S1.4.6"],
    Cell[65404, 2540, 105, 3, 70, "Output",
      CellTags->"S1.4.6"]},
  "6.1"->{
    Cell[56942, 2197, 103, 1, 70, "Subsection",
      CellTags->{"S1.4.6", "6.1"}]},
  "6.2"->{
    Cell[57734, 2224, 216, 7, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.2"}]},
  "6.3"->{
    Cell[58163, 2245, 552, 21, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.3"}]},
  "6.4"->{
    Cell[58934, 2280, 268, 11, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.4"}]},
  "6.5"->{
    Cell[59417, 2305, 116, 2, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.5"}]},
  "6.6"->{
    Cell[59814, 2321, 375, 13, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.6"}]},
  "6.7"->{
    Cell[60431, 2348, 116, 2, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.7"}]},
  "6.8"->{
    Cell[63139, 2438, 404, 15, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.8"}]},
  "6.9"->{
    Cell[63775, 2467, 238, 8, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.9"}]},
  "6.10"->{
    Cell[64254, 2489, 131, 4, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.10"}]},
  "6.11"->{
    Cell[64657, 2510, 602, 22, 70, "MathCaption",
      CellTags->{"S1.4.6", "6.11"}]},
  "S1.4.7"->{
    Cell[65558, 2549, 102, 1, 70, "Subsection",
      CellTags->{"S1.4.7", "7.1"}],
    Cell[65663, 2552, 1820, 57, 70, "DefinitionBox",
      CellTags->"S1.4.7"],
    Cell[67486, 2611, 86, 1, 70, "Caption",
      CellTags->"S1.4.7"],
    Cell[67575, 2614, 87, 1, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.2"}],
    Cell[67687, 2619, 93, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[67783, 2623, 134, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[67932, 2629, 164, 7, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.3"}],
    Cell[68121, 2640, 81, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[68205, 2644, 93, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[68313, 2650, 311, 13, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.4"}],
    Cell[68649, 2667, 78, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[68730, 2671, 82, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[68827, 2677, 131, 5, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.5"}],
    Cell[68983, 2686, 74, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[69060, 2690, 88, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[69163, 2696, 1120, 33, 70, "Text",
      CellTags->{"S1.4.7", "7.6"}],
    Cell[70286, 2731, 170, 4, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.7"}],
    Cell[70481, 2739, 97, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[70581, 2743, 93, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[70689, 2749, 808, 26, 70, "DefinitionBox",
      CellTags->"S1.4.7"],
    Cell[71500, 2777, 95, 1, 70, "Caption",
      CellTags->"S1.4.7"],
    Cell[71598, 2780, 85, 1, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.8"}],
    Cell[71708, 2785, 87, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[71798, 2789, 110, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[71923, 2795, 131, 4, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.9"}],
    Cell[72079, 2803, 78, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[72160, 2807, 95, 3, 70, "Output",
      CellTags->"S1.4.7"],
    Cell[72270, 2813, 181, 6, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.10"}],
    Cell[72476, 2823, 86, 2, 70, "Input",
      CellTags->"S1.4.7"],
    Cell[72565, 2827, 82, 3, 70, "Output",
      CellTags->"S1.4.7"]},
  "7.1"->{
    Cell[65558, 2549, 102, 1, 70, "Subsection",
      CellTags->{"S1.4.7", "7.1"}]},
  "7.2"->{
    Cell[67575, 2614, 87, 1, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.2"}]},
  "7.3"->{
    Cell[67932, 2629, 164, 7, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.3"}]},
  "7.4"->{
    Cell[68313, 2650, 311, 13, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.4"}]},
  "7.5"->{
    Cell[68827, 2677, 131, 5, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.5"}]},
  "7.6"->{
    Cell[69163, 2696, 1120, 33, 70, "Text",
      CellTags->{"S1.4.7", "7.6"}]},
  "7.7"->{
    Cell[70286, 2731, 170, 4, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.7"}]},
  "7.8"->{
    Cell[71598, 2780, 85, 1, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.8"}]},
  "7.9"->{
    Cell[71923, 2795, 131, 4, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.9"}]},
  "7.10"->{
    Cell[72270, 2813, 181, 6, 70, "MathCaption",
      CellTags->{"S1.4.7", "7.10"}]},
  "S1.4.8"->{
    Cell[72696, 2836, 103, 1, 70, "Subsection",
      CellTags->{"S1.4.8", "8.1"}],
    Cell[72802, 2839, 270, 6, 70, "Text",
      CellTags->{"S1.4.8", "8.2"}],
    Cell[73075, 2847, 379, 12, 70, "Text",
      CellTags->{"S1.4.8", "8.3"}],
    Cell[73457, 2861, 352, 10, 70, "Text",
      CellTags->{"S1.4.8", "8.4"}],
    Cell[73812, 2873, 228, 7, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.5"}],
    Cell[74043, 2882, 90, 2, 70, "Input",
      CellTags->"S1.4.8"],
    Cell[74136, 2886, 379, 13, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.6"}],
    Cell[74540, 2903, 73, 2, 70, "Input",
      CellTags->"S1.4.8"],
    Cell[74616, 2907, 192, 5, 70, "Output",
      CellTags->"S1.4.8"],
    Cell[74823, 2915, 151, 4, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.7"}],
    Cell[74999, 2923, 75, 2, 70, "Input",
      CellTags->"S1.4.8"],
    Cell[75077, 2927, 342, 7, 70, "Output",
      CellTags->"S1.4.8"],
    Cell[75434, 2937, 104, 1, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.8"}],
    Cell[75563, 2942, 73, 2, 70, "Input",
      CellTags->"S1.4.8"],
    Cell[75639, 2946, 83, 3, 70, "Output",
      CellTags->"S1.4.8"],
    Cell[75737, 2952, 1328, 43, 70, "DefinitionBox",
      CellTags->"S1.4.8"],
    Cell[77068, 2997, 75, 1, 70, "Caption",
      CellTags->"S1.4.8"]},
  "8.1"->{
    Cell[72696, 2836, 103, 1, 70, "Subsection",
      CellTags->{"S1.4.8", "8.1"}]},
  "8.2"->{
    Cell[72802, 2839, 270, 6, 70, "Text",
      CellTags->{"S1.4.8", "8.2"}]},
  "8.3"->{
    Cell[73075, 2847, 379, 12, 70, "Text",
      CellTags->{"S1.4.8", "8.3"}]},
  "8.4"->{
    Cell[73457, 2861, 352, 10, 70, "Text",
      CellTags->{"S1.4.8", "8.4"}]},
  "8.5"->{
    Cell[73812, 2873, 228, 7, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.5"}]},
  "8.6"->{
    Cell[74136, 2886, 379, 13, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.6"}]},
  "8.7"->{
    Cell[74823, 2915, 151, 4, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.7"}]},
  "8.8"->{
    Cell[75434, 2937, 104, 1, 70, "MathCaption",
      CellTags->{"S1.4.8", "8.8"}]},
  "S1.4.9"->{
    Cell[77180, 3003, 123, 4, 70, "Subsection",
      CellTags->{"S1.4.9", "9.1"}],
    Cell[77306, 3009, 497, 12, 70, "Text",
      CellTags->{"S1.4.9", "9.2"}],
    Cell[77806, 3023, 610, 13, 70, "Text",
      CellTags->{"S1.4.9", "9.3"}],
    Cell[78419, 3038, 353, 8, 70, "Text",
      CellTags->{"S1.4.9", "9.4"}],
    Cell[78775, 3048, 776, 13, 70, "Text",
      CellTags->{"S1.4.9", "9.5"}],
    Cell[79554, 3063, 430, 8, 70, "Text",
      CellTags->{"S1.4.9", "9.6"}],
    Cell[79987, 3073, 979, 23, 70, "Text",
      CellTags->{"S1.4.9", "9.7"}],
    Cell[80969, 3098, 504, 9, 70, "Text",
      CellTags->{"S1.4.9", "9.8"}],
    Cell[81476, 3109, 470, 9, 70, "Text",
      CellTags->{"S1.4.9", "9.9"}],
    Cell[81949, 3120, 3517, 118, 70, "FramedBox",
      CellTags->"S1.4.9"],
    Cell[85469, 3240, 123, 4, 70, "Caption",
      CellTags->"S1.4.9"]},
  "9.1"->{
    Cell[77180, 3003, 123, 4, 70, "Subsection",
      CellTags->{"S1.4.9", "9.1"}]},
  "9.2"->{
    Cell[77306, 3009, 497, 12, 70, "Text",
      CellTags->{"S1.4.9", "9.2"}]},
  "9.3"->{
    Cell[77806, 3023, 610, 13, 70, "Text",
      CellTags->{"S1.4.9", "9.3"}]},
  "9.4"->{
    Cell[78419, 3038, 353, 8, 70, "Text",
      CellTags->{"S1.4.9", "9.4"}]},
  "9.5"->{
    Cell[78775, 3048, 776, 13, 70, "Text",
      CellTags->{"S1.4.9", "9.5"}]},
  "9.6"->{
    Cell[79554, 3063, 430, 8, 70, "Text",
      CellTags->{"S1.4.9", "9.6"}]},
  "9.7"->{
    Cell[79987, 3073, 979, 23, 70, "Text",
      CellTags->{"S1.4.9", "9.7"}]},
  "9.8"->{
    Cell[80969, 3098, 504, 9, 70, "Text",
      CellTags->{"S1.4.9", "9.8"}]},
  "9.9"->{
    Cell[81476, 3109, 470, 9, 70, "Text",
      CellTags->{"S1.4.9", "9.9"}]},
  "S1.4.10"->{
    Cell[85629, 3249, 90, 1, 70, "Subsection",
      CellTags->{"S1.4.10", "10.1"}],
    Cell[85722, 3252, 346, 9, 70, "Text",
      CellTags->{"S1.4.10", "10.2"}],
    Cell[86071, 3263, 173, 4, 70, "Text",
      CellTags->{"S1.4.10", "10.3"}],
    Cell[86247, 3269, 308, 6, 70, "Text",
      CellTags->{"S1.4.10", "10.4"}],
    Cell[86558, 3277, 272, 7, 70, "Text",
      CellTags->{"S1.4.10", "10.5"}],
    Cell[86833, 3286, 170, 5, 70, "MathCaption",
      CellTags->{"S1.4.10", "10.6"}],
    Cell[87028, 3295, 74, 2, 70, "Input",
      CellTags->"S1.4.10"],
    Cell[87105, 3299, 92, 3, 70, "Output",
      CellTags->"S1.4.10"],
    Cell[87212, 3305, 87, 1, 70, "MathCaption",
      CellTags->{"S1.4.10", "10.7"}],
    Cell[87324, 3310, 79, 2, 70, "Input",
      CellTags->"S1.4.10"],
    Cell[87406, 3314, 95, 3, 70, "Output",
      CellTags->"S1.4.10"],
    Cell[87516, 3320, 76, 1, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.8"}],
    Cell[87617, 3325, 81, 2, 70, "Input",
      CellTags->"S1.4.10"],
    Cell[87701, 3329, 122, 3, 42, "Output",
      CellTags->"S1.4.10"],
    Cell[87838, 3335, 101, 1, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.9"}],
    Cell[87964, 3340, 92, 2, 28, "Input",
      CellTags->"S1.4.10"],
    Cell[88059, 3344, 120, 3, 42, "Output",
      CellTags->"S1.4.10"],
    Cell[88194, 3350, 253, 6, 40, "Text",
      CellTags->{"S1.4.10", "10.10"}],
    Cell[88450, 3358, 150, 5, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.11"}],
    Cell[88603, 3365, 87, 2, 28, "Input",
      CellTags->"S1.4.10"],
    Cell[88693, 3369, 104, 1, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.12"}],
    Cell[88822, 3374, 80, 2, 28, "Input",
      CellTags->"S1.4.10"],
    Cell[88905, 3378, 103, 3, 42, "Output",
      CellTags->"S1.4.10"],
    Cell[89023, 3384, 262, 10, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.13"}],
    Cell[89310, 3398, 88, 2, 28, "Input",
      CellTags->"S1.4.10"],
    Cell[89401, 3402, 113, 3, 42, "Output",
      CellTags->"S1.4.10"],
    Cell[89529, 3408, 130, 4, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.14"}],
    Cell[89684, 3416, 110, 2, 28, "Input",
      CellTags->"S1.4.10"],
    Cell[89797, 3420, 115, 3, 42, "Output",
      CellTags->"S1.4.10"]},
  "10.1"->{
    Cell[85629, 3249, 90, 1, 70, "Subsection",
      CellTags->{"S1.4.10", "10.1"}]},
  "10.2"->{
    Cell[85722, 3252, 346, 9, 70, "Text",
      CellTags->{"S1.4.10", "10.2"}]},
  "10.3"->{
    Cell[86071, 3263, 173, 4, 70, "Text",
      CellTags->{"S1.4.10", "10.3"}]},
  "10.4"->{
    Cell[86247, 3269, 308, 6, 70, "Text",
      CellTags->{"S1.4.10", "10.4"}]},
  "10.5"->{
    Cell[86558, 3277, 272, 7, 70, "Text",
      CellTags->{"S1.4.10", "10.5"}]},
  "10.6"->{
    Cell[86833, 3286, 170, 5, 70, "MathCaption",
      CellTags->{"S1.4.10", "10.6"}]},
  "10.7"->{
    Cell[87212, 3305, 87, 1, 70, "MathCaption",
      CellTags->{"S1.4.10", "10.7"}]},
  "10.8"->{
    Cell[87516, 3320, 76, 1, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.8"}]},
  "10.9"->{
    Cell[87838, 3335, 101, 1, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.9"}]},
  "10.10"->{
    Cell[88194, 3350, 253, 6, 40, "Text",
      CellTags->{"S1.4.10", "10.10"}]},
  "10.11"->{
    Cell[88450, 3358, 150, 5, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.11"}]},
  "10.12"->{
    Cell[88693, 3369, 104, 1, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.12"}]},
  "10.13"->{
    Cell[89023, 3384, 262, 10, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.13"}]},
  "10.14"->{
    Cell[89529, 3408, 130, 4, 40, "MathCaption",
      CellTags->{"S1.4.10", "10.14"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.4.0", 90567, 3444},
  {"0.1", 90657, 3447},
  {"S1.4.1", 90750, 3450},
  {"1.1", 94009, 3539},
  {"1.2", 94101, 3542},
  {"1.3", 94189, 3545},
  {"1.4", 94282, 3548},
  {"1.5", 94375, 3551},
  {"1.6", 94470, 3554},
  {"1.7", 94566, 3557},
  {"1.8", 94655, 3560},
  {"1.9", 94750, 3563},
  {"1.10", 94845, 3566},
  {"1.11", 94942, 3569},
  {"1.12", 95039, 3572},
  {"1.13", 95130, 3575},
  {"1.14", 95227, 3578},
  {"1.15", 95318, 3581},
  {"1.16", 95417, 3584},
  {"1.17", 95515, 3587},
  {"1.18", 95606, 3590},
  {"S1.4.2", 95699, 3593},
  {"2.1", 100457, 3720},
  {"2.2", 100551, 3723},
  {"2.3", 100641, 3726},
  {"2.4", 100730, 3729},
  {"2.5", 100820, 3732},
  {"2.6", 100910, 3735},
  {"2.7", 101007, 3738},
  {"2.8", 101104, 3741},
  {"2.9", 101200, 3744},
  {"2.10", 101298, 3747},
  {"2.11", 101396, 3750},
  {"2.12", 101488, 3753},
  {"2.13", 101580, 3756},
  {"2.14", 101678, 3759},
  {"2.15", 101776, 3762},
  {"2.16", 101875, 3765},
  {"2.17", 101974, 3768},
  {"2.18", 102066, 3771},
  {"2.19", 102164, 3774},
  {"2.20", 102262, 3777},
  {"2.21", 102360, 3780},
  {"2.22", 102452, 3783},
  {"2.23", 102544, 3786},
  {"2.24", 102636, 3789},
  {"2.25", 102728, 3792},
  {"2.26", 102827, 3795},
  {"2.27", 102926, 3798},
  {"2.28", 103025, 3801},
  {"S1.4.3", 103126, 3804},
  {"3.1", 104798, 3849},
  {"3.2", 104893, 3852},
  {"3.3", 104984, 3855},
  {"3.4", 105081, 3858},
  {"3.5", 105178, 3861},
  {"3.6", 105275, 3864},
  {"3.7", 105372, 3867},
  {"3.8", 105469, 3870},
  {"S1.4.4", 105569, 3873},
  {"4.1", 108023, 3938},
  {"4.2", 108118, 3941},
  {"4.3", 108208, 3944},
  {"4.4", 108306, 3947},
  {"4.5", 108404, 3950},
  {"4.6", 108494, 3953},
  {"4.7", 108592, 3956},
  {"4.8", 108689, 3959},
  {"4.9", 108786, 3962},
  {"4.10", 108877, 3965},
  {"4.11", 108969, 3968},
  {"4.12", 109068, 3971},
  {"4.13", 109167, 3974},
  {"4.14", 109259, 3977},
  {"4.15", 109351, 3980},
  {"4.16", 109444, 3983},
  {"S1.4.5", 109539, 3986},
  {"5.1", 114704, 4123},
  {"5.2", 114800, 4126},
  {"5.3", 114890, 4129},
  {"5.4", 114981, 4132},
  {"5.5", 115078, 4135},
  {"5.6", 115175, 4138},
  {"5.7", 115272, 4141},
  {"5.8", 115369, 4144},
  {"5.9", 115466, 4147},
  {"5.10", 115564, 4150},
  {"5.11", 115663, 4153},
  {"5.12", 115755, 4156},
  {"5.13", 115847, 4159},
  {"5.14", 115946, 4162},
  {"5.15", 116045, 4165},
  {"5.16", 116144, 4168},
  {"5.17", 116243, 4171},
  {"5.18", 116336, 4174},
  {"5.19", 116428, 4177},
  {"5.20", 116527, 4180},
  {"5.21", 116626, 4183},
  {"5.22", 116725, 4186},
  {"5.23", 116824, 4189},
  {"5.24", 116923, 4192},
  {"5.25", 117016, 4195},
  {"5.26", 117115, 4198},
  {"S1.4.6", 117216, 4201},
  {"6.1", 119869, 4272},
  {"6.2", 119965, 4275},
  {"6.3", 120062, 4278},
  {"6.4", 120160, 4281},
  {"6.5", 120258, 4284},
  {"6.6", 120355, 4287},
  {"6.7", 120453, 4290},
  {"6.8", 120550, 4293},
  {"6.9", 120648, 4296},
  {"6.10", 120746, 4299},
  {"6.11", 120845, 4302},
  {"S1.4.7", 120947, 4305},
  {"7.1", 123218, 4366},
  {"7.2", 123314, 4369},
  {"7.3", 123410, 4372},
  {"7.4", 123507, 4375},
  {"7.5", 123605, 4378},
  {"7.6", 123702, 4381},
  {"7.7", 123794, 4384},
  {"7.8", 123891, 4387},
  {"7.9", 123987, 4390},
  {"7.10", 124085, 4393},
  {"S1.4.8", 124186, 4396},
  {"8.1", 125498, 4431},
  {"8.2", 125594, 4434},
  {"8.3", 125684, 4437},
  {"8.4", 125775, 4440},
  {"8.5", 125866, 4443},
  {"8.6", 125963, 4446},
  {"8.7", 126061, 4449},
  {"8.8", 126158, 4452},
  {"S1.4.9", 126258, 4455},
  {"9.1", 127131, 4478},
  {"9.2", 127227, 4481},
  {"9.3", 127318, 4484},
  {"9.4", 127409, 4487},
  {"9.5", 127499, 4490},
  {"9.6", 127590, 4493},
  {"9.7", 127680, 4496},
  {"9.8", 127771, 4499},
  {"9.9", 127861, 4502},
  {"S1.4.10", 127955, 4505},
  {"10.1", 130216, 4564},
  {"10.2", 130314, 4567},
  {"10.3", 130407, 4570},
  {"10.4", 130500, 4573},
  {"10.5", 130593, 4576},
  {"10.6", 130686, 4579},
  {"10.7", 130786, 4582},
  {"10.8", 130885, 4585},
  {"10.9", 130984, 4588},
  {"10.10", 131085, 4591},
  {"10.11", 131180, 4594},
  {"10.12", 131282, 4597},
  {"10.13", 131384, 4600},
  {"10.14", 131487, 4603}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 125, 4, 65, "Section",
  CellTags->{"S1.4.0", "0.1"}],

Cell[CellGroupData[{
Cell[1926, 61, 79, 1, 70, "Subsection",
  CellTags->{"S1.4.1", "1.1"}],
Cell[2008, 64, 326, 10, 70, "Text",
  CellTags->{"S1.4.1", "1.2"}],
Cell[2337, 76, 95, 1, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.3"}],

Cell[CellGroupData[{
Cell[2457, 81, 74, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[2534, 85, 83, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[2632, 91, 86, 1, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.4"}],

Cell[CellGroupData[{
Cell[2743, 96, 74, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[2820, 100, 89, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[2924, 106, 1420, 46, 70, "DefinitionBox",
  CellTags->"S1.4.1"],
Cell[4347, 154, 78, 1, 70, "Caption",
  CellTags->"S1.4.1"],
Cell[4428, 157, 154, 5, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.5"}],

Cell[CellGroupData[{
Cell[4607, 166, 77, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[4687, 170, 101, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[4803, 176, 705, 25, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.6"}],

Cell[CellGroupData[{
Cell[5533, 205, 79, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[5615, 209, 92, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[5722, 215, 694, 23, 70, "Text",
  CellTags->{"S1.4.1", "1.7"}],
Cell[6419, 240, 171, 4, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.8"}],

Cell[CellGroupData[{
Cell[6615, 248, 95, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[6713, 252, 116, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[6844, 258, 92, 1, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.9"}],

Cell[CellGroupData[{
Cell[6961, 263, 85, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[7049, 267, 120, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[7184, 273, 155, 5, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.10"}],

Cell[CellGroupData[{
Cell[7364, 282, 73, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[7440, 286, 129, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[7584, 292, 168, 6, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.11"}],

Cell[CellGroupData[{
Cell[7777, 302, 73, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[7853, 306, 120, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[7988, 312, 970, 30, 70, "Text",
  CellTags->{"S1.4.1", "1.12"}],
Cell[8961, 344, 132, 4, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.13"}],

Cell[CellGroupData[{
Cell[9118, 352, 117, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[9238, 356, 185, 4, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[9438, 363, 563, 15, 70, "Text",
  CellTags->{"S1.4.1", "1.14"}],
Cell[10004, 380, 618, 21, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.15"}],

Cell[CellGroupData[{
Cell[10647, 405, 78, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[10728, 409, 96, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[10839, 415, 202, 5, 70, "MathCaption",
  CellTags->{"S1.4.1", "1.16"}],

Cell[CellGroupData[{
Cell[11066, 424, 80, 2, 70, "Input",
  CellTags->"S1.4.1"],
Cell[11149, 428, 97, 3, 70, "Output",
  CellTags->"S1.4.1"]
}, Open  ]],
Cell[11261, 434, 314, 7, 70, "Text",
  CellTags->{"S1.4.1", "1.17"}],
Cell[11578, 443, 338, 7, 70, "Text",
  CellTags->{"S1.4.1", "1.18"}],
Cell[11919, 452, 347, 11, 70, "FramedBox",
  CellTags->"S1.4.1"],
Cell[12269, 465, 127, 5, 70, "Caption",
  CellTags->"S1.4.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12433, 475, 77, 1, 70, "Subsection",
  CellTags->{"S1.4.2", "2.1"}],
Cell[12513, 478, 459, 17, 70, "Text",
  CellTags->{"S1.4.2", "2.2"}],
Cell[12975, 497, 291, 6, 70, "Text",
  CellTags->{"S1.4.2", "2.3"}],
Cell[13269, 505, 968, 36, 70, "Text",
  CellTags->{"S1.4.2", "2.4"}],
Cell[14240, 543, 434, 14, 70, "Text",
  CellTags->{"S1.4.2", "2.5"}],
Cell[14677, 559, 247, 11, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.6"}],

Cell[CellGroupData[{
Cell[14949, 574, 80, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[15032, 578, 82, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[15129, 584, 298, 13, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.7"}],

Cell[CellGroupData[{
Cell[15452, 601, 89, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[15544, 605, 103, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[15662, 611, 187, 5, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.8"}],

Cell[CellGroupData[{
Cell[15874, 620, 74, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[15951, 624, 96, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[16062, 630, 241, 10, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.9"}],

Cell[CellGroupData[{
Cell[16328, 644, 76, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[16407, 648, 104, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[16526, 654, 1407, 47, 70, "DefinitionBox",
  CellTags->"S1.4.2"],
Cell[17936, 703, 85, 1, 70, "Caption",
  CellTags->"S1.4.2"],
Cell[18024, 706, 126, 4, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.10"}],

Cell[CellGroupData[{
Cell[18175, 714, 105, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[18283, 718, 108, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[18406, 724, 468, 15, 70, "Text",
  CellTags->{"S1.4.2", "2.11"}],
Cell[18877, 741, 646, 29, 70, "Text",
  CellTags->{"S1.4.2", "2.12"}],
Cell[19526, 772, 158, 7, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.13"}],

Cell[CellGroupData[{
Cell[19709, 783, 69, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[19781, 787, 82, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[19878, 793, 190, 7, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.14"}],

Cell[CellGroupData[{
Cell[20093, 804, 71, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[20167, 808, 82, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[20264, 814, 239, 11, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.15"}],

Cell[CellGroupData[{
Cell[20528, 829, 73, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[20604, 833, 86, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[20705, 839, 211, 11, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.16"}],

Cell[CellGroupData[{
Cell[20941, 854, 71, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[21015, 858, 104, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[21134, 864, 507, 10, 70, "Text",
  CellTags->{"S1.4.2", "2.17"}],
Cell[21644, 876, 849, 28, 70, "DefinitionBox",
  CellTags->"S1.4.2"],
Cell[22496, 906, 70, 1, 70, "Caption",
  CellTags->"S1.4.2"],
Cell[22569, 909, 158, 5, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.18"}],

Cell[CellGroupData[{
Cell[22752, 918, 75, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[22830, 922, 104, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[22949, 928, 159, 5, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.19"}],
Cell[23111, 935, 69, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[23183, 939, 176, 5, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.20"}],

Cell[CellGroupData[{
Cell[23384, 948, 75, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[23462, 952, 87, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[23564, 958, 631, 16, 70, "Text",
  CellTags->{"S1.4.2", "2.21"}],
Cell[24198, 976, 736, 21, 70, "Text",
  CellTags->{"S1.4.2", "2.22"}],
Cell[24937, 999, 566, 18, 70, "Text",
  CellTags->{"S1.4.2", "2.23"}],
Cell[25506, 1019, 257, 5, 70, "Text",
  CellTags->{"S1.4.2", "2.24"}],
Cell[25766, 1026, 137, 5, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.25"}],

Cell[CellGroupData[{
Cell[25928, 1035, 76, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[26007, 1039, 90, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[26112, 1045, 214, 9, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.26"}],

Cell[CellGroupData[{
Cell[26351, 1058, 76, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[26430, 1062, 83, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[26528, 1068, 181, 7, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.27"}],

Cell[CellGroupData[{
Cell[26734, 1079, 77, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[26814, 1083, 94, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]],
Cell[26923, 1089, 250, 9, 70, "MathCaption",
  CellTags->{"S1.4.2", "2.28"}],

Cell[CellGroupData[{
Cell[27198, 1102, 81, 2, 70, "Input",
  CellTags->"S1.4.2"],
Cell[27282, 1106, 101, 3, 70, "Output",
  CellTags->"S1.4.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27432, 1115, 93, 1, 70, "Subsection",
  CellTags->{"S1.4.3", "3.1"}],
Cell[27528, 1118, 798, 24, 70, "Text",
  CellTags->{"S1.4.3", "3.2"}],
Cell[28329, 1144, 807, 26, 70, "DefinitionBox",
  CellTags->"S1.4.3"],
Cell[29139, 1172, 112, 4, 70, "Caption",
  CellTags->"S1.4.3"],
Cell[29254, 1178, 214, 5, 70, "MathCaption",
  CellTags->{"S1.4.3", "3.3"}],

Cell[CellGroupData[{
Cell[29493, 1187, 83, 2, 70, "Input",
  CellTags->"S1.4.3"],
Cell[29579, 1191, 96, 3, 70, "Output",
  CellTags->"S1.4.3"]
}, Open  ]],
Cell[29690, 1197, 128, 4, 70, "MathCaption",
  CellTags->{"S1.4.3", "3.4"}],

Cell[CellGroupData[{
Cell[29843, 1205, 75, 2, 70, "Input",
  CellTags->"S1.4.3"],
Cell[29921, 1209, 95, 3, 70, "Output",
  CellTags->"S1.4.3"]
}, Open  ]],
Cell[30031, 1215, 158, 5, 70, "MathCaption",
  CellTags->{"S1.4.3", "3.5"}],

Cell[CellGroupData[{
Cell[30214, 1224, 89, 2, 70, "Input",
  CellTags->"S1.4.3"],
Cell[30306, 1228, 258, 5, 70, "Output",
  CellTags->"S1.4.3"]
}, Open  ]],
Cell[30579, 1236, 136, 4, 70, "MathCaption",
  CellTags->{"S1.4.3", "3.6"}],

Cell[CellGroupData[{
Cell[30740, 1244, 75, 2, 70, "Input",
  CellTags->"S1.4.3"],
Cell[30818, 1248, 102, 3, 70, "Output",
  CellTags->"S1.4.3"]
}, Open  ]],
Cell[30935, 1254, 184, 5, 70, "MathCaption",
  CellTags->{"S1.4.3", "3.7"}],

Cell[CellGroupData[{
Cell[31144, 1263, 82, 2, 70, "Input",
  CellTags->"S1.4.3"],
Cell[31229, 1267, 189, 4, 70, "Output",
  CellTags->"S1.4.3"]
}, Open  ]],
Cell[31433, 1274, 190, 5, 70, "MathCaption",
  CellTags->{"S1.4.3", "3.8"}],

Cell[CellGroupData[{
Cell[31648, 1283, 75, 2, 70, "Input",
  CellTags->"S1.4.3"],
Cell[31726, 1287, 95, 3, 70, "Output",
  CellTags->"S1.4.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31870, 1296, 92, 1, 70, "Subsection",
  CellTags->{"S1.4.4", "4.1"}],
Cell[31965, 1299, 476, 9, 70, "Text",
  CellTags->{"S1.4.4", "4.2"}],
Cell[32444, 1310, 868, 26, 70, "DefinitionBox",
  CellTags->"S1.4.4"],
Cell[33315, 1338, 76, 1, 70, "Caption",
  CellTags->"S1.4.4"],
Cell[33394, 1341, 363, 13, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.3"}],

Cell[CellGroupData[{
Cell[33782, 1358, 86, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[33871, 1362, 95, 3, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[33981, 1368, 368, 12, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.4"}],

Cell[CellGroupData[{
Cell[34374, 1384, 82, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[34459, 1388, 95, 3, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[34569, 1394, 248, 6, 70, "Text",
  CellTags->{"S1.4.4", "4.5"}],
Cell[34820, 1402, 506, 17, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.6"}],

Cell[CellGroupData[{
Cell[35351, 1423, 87, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[35441, 1427, 152, 4, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[35608, 1434, 267, 6, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.7"}],

Cell[CellGroupData[{
Cell[35900, 1444, 71, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[35974, 1448, 165, 4, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[36154, 1455, 179, 5, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.8"}],

Cell[CellGroupData[{
Cell[36358, 1464, 75, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[36436, 1468, 101, 3, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[36552, 1474, 320, 7, 70, "Text",
  CellTags->{"S1.4.4", "4.9"}],
Cell[36875, 1483, 226, 5, 70, "Text",
  CellTags->{"S1.4.4", "4.10"}],
Cell[37104, 1490, 135, 4, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.11"}],

Cell[CellGroupData[{
Cell[37264, 1498, 95, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[37362, 1502, 103, 3, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[37480, 1508, 149, 4, 70, "MathCaption",
  CellTags->{"S1.4.4", "4.12"}],

Cell[CellGroupData[{
Cell[37654, 1516, 99, 2, 70, "Input",
  CellTags->"S1.4.4"],
Cell[37756, 1520, 101, 3, 70, "Output",
  CellTags->"S1.4.4"]
}, Open  ]],
Cell[37872, 1526, 260, 6, 70, "Text",
  CellTags->{"S1.4.4", "4.13"}],
Cell[38135, 1534, 331, 7, 70, "Text",
  CellTags->{"S1.4.4", "4.14"}],
Cell[38469, 1543, 432, 10, 70, "Text",
  CellTags->{"S1.4.4", "4.15"}],
Cell[38904, 1555, 455, 10, 70, "Text",
  CellTags->{"S1.4.4", "4.16"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39396, 1570, 125, 4, 70, "Subsection",
  CellTags->{"S1.4.5", "5.1"}],
Cell[39524, 1576, 273, 7, 70, "Text",
  CellTags->{"S1.4.5", "5.2"}],
Cell[39800, 1585, 358, 10, 70, "Text",
  CellTags->{"S1.4.5", "5.3"}],
Cell[40161, 1597, 2049, 59, 70, "DefinitionBox",
  CellTags->"S1.4.5"],
Cell[42213, 1658, 91, 1, 70, "Caption",
  CellTags->"S1.4.5"],
Cell[42307, 1661, 139, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.4"}],

Cell[CellGroupData[{
Cell[42471, 1669, 107, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[42581, 1673, 157, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[42753, 1680, 171, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.5"}],

Cell[CellGroupData[{
Cell[42949, 1688, 73, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[43025, 1692, 223, 5, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[43263, 1700, 153, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.6"}],

Cell[CellGroupData[{
Cell[43441, 1708, 76, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[43520, 1712, 195, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[43730, 1719, 162, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.7"}],

Cell[CellGroupData[{
Cell[43917, 1727, 75, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[43995, 1731, 138, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[44148, 1737, 163, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.8"}],

Cell[CellGroupData[{
Cell[44336, 1745, 72, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[44411, 1749, 168, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[44594, 1756, 163, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.9"}],

Cell[CellGroupData[{
Cell[44782, 1764, 73, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[44858, 1768, 157, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[45030, 1775, 181, 5, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.10"}],

Cell[CellGroupData[{
Cell[45236, 1784, 75, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[45314, 1788, 157, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[45486, 1795, 307, 6, 70, "Text",
  CellTags->{"S1.4.5", "5.11"}],
Cell[45796, 1803, 451, 8, 70, "Text",
  CellTags->{"S1.4.5", "5.12"}],
Cell[46250, 1813, 1014, 32, 70, "DefinitionBox",
  CellTags->"S1.4.5"],
Cell[47267, 1847, 87, 1, 70, "Caption",
  CellTags->"S1.4.5"],
Cell[47357, 1850, 105, 1, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.13"}],

Cell[CellGroupData[{
Cell[47487, 1855, 99, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[47589, 1859, 197, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[47801, 1866, 194, 7, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.14"}],

Cell[CellGroupData[{
Cell[48020, 1877, 77, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[48100, 1881, 201, 5, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[48316, 1889, 133, 5, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.15"}],

Cell[CellGroupData[{
Cell[48474, 1898, 78, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[48555, 1902, 205, 5, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[48775, 1910, 153, 5, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.16"}],

Cell[CellGroupData[{
Cell[48953, 1919, 82, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[49038, 1923, 139, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[49192, 1929, 918, 20, 70, "Text",
  CellTags->{"S1.4.5", "5.17"}],
Cell[50113, 1951, 200, 5, 70, "Text",
  CellTags->{"S1.4.5", "5.18"}],
Cell[50316, 1958, 3052, 83, 70, "DefinitionBox",
  CellTags->"S1.4.5"],
Cell[53371, 2043, 92, 1, 70, "Caption",
  CellTags->"S1.4.5"],
Cell[53466, 2046, 199, 6, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.19"}],

Cell[CellGroupData[{
Cell[53690, 2056, 91, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[53784, 2060, 142, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[53941, 2067, 147, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.20"}],

Cell[CellGroupData[{
Cell[54113, 2075, 78, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[54194, 2079, 134, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[54343, 2085, 109, 1, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.21"}],

Cell[CellGroupData[{
Cell[54477, 2090, 78, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[54558, 2094, 129, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[54702, 2100, 186, 7, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.22"}],

Cell[CellGroupData[{
Cell[54913, 2111, 94, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[55010, 2115, 130, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[55155, 2121, 183, 7, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.23"}],

Cell[CellGroupData[{
Cell[55363, 2132, 102, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[55468, 2136, 194, 4, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[55677, 2143, 501, 12, 70, "Text",
  CellTags->{"S1.4.5", "5.24"}],
Cell[56181, 2157, 181, 5, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.25"}],

Cell[CellGroupData[{
Cell[56387, 2166, 74, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[56464, 2170, 92, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]],
Cell[56571, 2176, 125, 4, 70, "MathCaption",
  CellTags->{"S1.4.5", "5.26"}],

Cell[CellGroupData[{
Cell[56721, 2184, 79, 2, 70, "Input",
  CellTags->"S1.4.5"],
Cell[56803, 2188, 90, 3, 70, "Output",
  CellTags->"S1.4.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56942, 2197, 103, 1, 70, "Subsection",
  CellTags->{"S1.4.6", "6.1"}],
Cell[57048, 2200, 609, 19, 70, "DefinitionBox",
  CellTags->"S1.4.6"],
Cell[57660, 2221, 71, 1, 70, "Caption",
  CellTags->"S1.4.6"],
Cell[57734, 2224, 216, 7, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.2"}],

Cell[CellGroupData[{
Cell[57975, 2235, 83, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[58061, 2239, 87, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[58163, 2245, 552, 21, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.3"}],

Cell[CellGroupData[{
Cell[58740, 2270, 89, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[58832, 2274, 87, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[58934, 2280, 268, 11, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.4"}],

Cell[CellGroupData[{
Cell[59227, 2295, 90, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[59320, 2299, 82, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[59417, 2305, 116, 2, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.5"}],

Cell[CellGroupData[{
Cell[59558, 2311, 109, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[59670, 2315, 129, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[59814, 2321, 375, 13, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.6"}],

Cell[CellGroupData[{
Cell[60214, 2338, 91, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[60308, 2342, 108, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[60431, 2348, 116, 2, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.7"}],

Cell[CellGroupData[{
Cell[60572, 2354, 106, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[60681, 2358, 82, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[60778, 2364, 2280, 69, 70, "DefinitionBox",
  CellTags->"S1.4.6"],
Cell[63061, 2435, 75, 1, 70, "Caption",
  CellTags->"S1.4.6"],
Cell[63139, 2438, 404, 15, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.8"}],

Cell[CellGroupData[{
Cell[63568, 2457, 102, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[63673, 2461, 87, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[63775, 2467, 238, 8, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.9"}],

Cell[CellGroupData[{
Cell[64038, 2479, 111, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[64152, 2483, 87, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[64254, 2489, 131, 4, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.10"}],

Cell[CellGroupData[{
Cell[64410, 2497, 139, 5, 70, "Input",
  CellTags->"S1.4.6"],
Cell[64552, 2504, 90, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]],
Cell[64657, 2510, 602, 22, 70, "MathCaption",
  CellTags->{"S1.4.6", "6.11"}],

Cell[CellGroupData[{
Cell[65284, 2536, 117, 2, 70, "Input",
  CellTags->"S1.4.6"],
Cell[65404, 2540, 105, 3, 70, "Output",
  CellTags->"S1.4.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65558, 2549, 102, 1, 70, "Subsection",
  CellTags->{"S1.4.7", "7.1"}],
Cell[65663, 2552, 1820, 57, 70, "DefinitionBox",
  CellTags->"S1.4.7"],
Cell[67486, 2611, 86, 1, 70, "Caption",
  CellTags->"S1.4.7"],
Cell[67575, 2614, 87, 1, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.2"}],

Cell[CellGroupData[{
Cell[67687, 2619, 93, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[67783, 2623, 134, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[67932, 2629, 164, 7, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.3"}],

Cell[CellGroupData[{
Cell[68121, 2640, 81, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[68205, 2644, 93, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[68313, 2650, 311, 13, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.4"}],

Cell[CellGroupData[{
Cell[68649, 2667, 78, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[68730, 2671, 82, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[68827, 2677, 131, 5, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.5"}],

Cell[CellGroupData[{
Cell[68983, 2686, 74, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[69060, 2690, 88, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[69163, 2696, 1120, 33, 70, "Text",
  CellTags->{"S1.4.7", "7.6"}],
Cell[70286, 2731, 170, 4, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.7"}],

Cell[CellGroupData[{
Cell[70481, 2739, 97, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[70581, 2743, 93, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[70689, 2749, 808, 26, 70, "DefinitionBox",
  CellTags->"S1.4.7"],
Cell[71500, 2777, 95, 1, 70, "Caption",
  CellTags->"S1.4.7"],
Cell[71598, 2780, 85, 1, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.8"}],

Cell[CellGroupData[{
Cell[71708, 2785, 87, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[71798, 2789, 110, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[71923, 2795, 131, 4, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.9"}],

Cell[CellGroupData[{
Cell[72079, 2803, 78, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[72160, 2807, 95, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]],
Cell[72270, 2813, 181, 6, 70, "MathCaption",
  CellTags->{"S1.4.7", "7.10"}],

Cell[CellGroupData[{
Cell[72476, 2823, 86, 2, 70, "Input",
  CellTags->"S1.4.7"],
Cell[72565, 2827, 82, 3, 70, "Output",
  CellTags->"S1.4.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72696, 2836, 103, 1, 70, "Subsection",
  CellTags->{"S1.4.8", "8.1"}],
Cell[72802, 2839, 270, 6, 70, "Text",
  CellTags->{"S1.4.8", "8.2"}],
Cell[73075, 2847, 379, 12, 70, "Text",
  CellTags->{"S1.4.8", "8.3"}],
Cell[73457, 2861, 352, 10, 70, "Text",
  CellTags->{"S1.4.8", "8.4"}],
Cell[73812, 2873, 228, 7, 70, "MathCaption",
  CellTags->{"S1.4.8", "8.5"}],
Cell[74043, 2882, 90, 2, 70, "Input",
  CellTags->"S1.4.8"],
Cell[74136, 2886, 379, 13, 70, "MathCaption",
  CellTags->{"S1.4.8", "8.6"}],

Cell[CellGroupData[{
Cell[74540, 2903, 73, 2, 70, "Input",
  CellTags->"S1.4.8"],
Cell[74616, 2907, 192, 5, 70, "Output",
  CellTags->"S1.4.8"]
}, Open  ]],
Cell[74823, 2915, 151, 4, 70, "MathCaption",
  CellTags->{"S1.4.8", "8.7"}],

Cell[CellGroupData[{
Cell[74999, 2923, 75, 2, 70, "Input",
  CellTags->"S1.4.8"],
Cell[75077, 2927, 342, 7, 70, "Output",
  CellTags->"S1.4.8"]
}, Open  ]],
Cell[75434, 2937, 104, 1, 70, "MathCaption",
  CellTags->{"S1.4.8", "8.8"}],

Cell[CellGroupData[{
Cell[75563, 2942, 73, 2, 70, "Input",
  CellTags->"S1.4.8"],
Cell[75639, 2946, 83, 3, 70, "Output",
  CellTags->"S1.4.8"]
}, Open  ]],
Cell[75737, 2952, 1328, 43, 70, "DefinitionBox",
  CellTags->"S1.4.8"],
Cell[77068, 2997, 75, 1, 70, "Caption",
  CellTags->"S1.4.8"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77180, 3003, 123, 4, 70, "Subsection",
  CellTags->{"S1.4.9", "9.1"}],
Cell[77306, 3009, 497, 12, 70, "Text",
  CellTags->{"S1.4.9", "9.2"}],
Cell[77806, 3023, 610, 13, 70, "Text",
  CellTags->{"S1.4.9", "9.3"}],
Cell[78419, 3038, 353, 8, 70, "Text",
  CellTags->{"S1.4.9", "9.4"}],
Cell[78775, 3048, 776, 13, 70, "Text",
  CellTags->{"S1.4.9", "9.5"}],
Cell[79554, 3063, 430, 8, 70, "Text",
  CellTags->{"S1.4.9", "9.6"}],
Cell[79987, 3073, 979, 23, 70, "Text",
  CellTags->{"S1.4.9", "9.7"}],
Cell[80969, 3098, 504, 9, 70, "Text",
  CellTags->{"S1.4.9", "9.8"}],
Cell[81476, 3109, 470, 9, 70, "Text",
  CellTags->{"S1.4.9", "9.9"}],
Cell[81949, 3120, 3517, 118, 70, "FramedBox",
  CellTags->"S1.4.9"],
Cell[85469, 3240, 123, 4, 70, "Caption",
  CellTags->"S1.4.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85629, 3249, 90, 1, 70, "Subsection",
  CellTags->{"S1.4.10", "10.1"}],
Cell[85722, 3252, 346, 9, 70, "Text",
  CellTags->{"S1.4.10", "10.2"}],
Cell[86071, 3263, 173, 4, 70, "Text",
  CellTags->{"S1.4.10", "10.3"}],
Cell[86247, 3269, 308, 6, 70, "Text",
  CellTags->{"S1.4.10", "10.4"}],
Cell[86558, 3277, 272, 7, 70, "Text",
  CellTags->{"S1.4.10", "10.5"}],
Cell[86833, 3286, 170, 5, 70, "MathCaption",
  CellTags->{"S1.4.10", "10.6"}],

Cell[CellGroupData[{
Cell[87028, 3295, 74, 2, 70, "Input",
  CellTags->"S1.4.10"],
Cell[87105, 3299, 92, 3, 70, "Output",
  CellTags->"S1.4.10"]
}, Open  ]],
Cell[87212, 3305, 87, 1, 70, "MathCaption",
  CellTags->{"S1.4.10", "10.7"}],

Cell[CellGroupData[{
Cell[87324, 3310, 79, 2, 70, "Input",
  CellTags->"S1.4.10"],
Cell[87406, 3314, 95, 3, 70, "Output",
  CellTags->"S1.4.10"]
}, Open  ]],
Cell[87516, 3320, 76, 1, 40, "MathCaption",
  CellTags->{"S1.4.10", "10.8"}],

Cell[CellGroupData[{
Cell[87617, 3325, 81, 2, 70, "Input",
  CellTags->"S1.4.10"],
Cell[87701, 3329, 122, 3, 42, "Output",
  CellTags->"S1.4.10"]
}, Open  ]],
Cell[87838, 3335, 101, 1, 40, "MathCaption",
  CellTags->{"S1.4.10", "10.9"}],

Cell[CellGroupData[{
Cell[87964, 3340, 92, 2, 28, "Input",
  CellTags->"S1.4.10"],
Cell[88059, 3344, 120, 3, 42, "Output",
  CellTags->"S1.4.10"]
}, Open  ]],
Cell[88194, 3350, 253, 6, 40, "Text",
  CellTags->{"S1.4.10", "10.10"}],
Cell[88450, 3358, 150, 5, 40, "MathCaption",
  CellTags->{"S1.4.10", "10.11"}],
Cell[88603, 3365, 87, 2, 28, "Input",
  CellTags->"S1.4.10"],
Cell[88693, 3369, 104, 1, 40, "MathCaption",
  CellTags->{"S1.4.10", "10.12"}],

Cell[CellGroupData[{
Cell[88822, 3374, 80, 2, 28, "Input",
  CellTags->"S1.4.10"],
Cell[88905, 3378, 103, 3, 42, "Output",
  CellTags->"S1.4.10"]
}, Open  ]],
Cell[89023, 3384, 262, 10, 40, "MathCaption",
  CellTags->{"S1.4.10", "10.13"}],

Cell[CellGroupData[{
Cell[89310, 3398, 88, 2, 28, "Input",
  CellTags->"S1.4.10"],
Cell[89401, 3402, 113, 3, 42, "Output",
  CellTags->"S1.4.10"]
}, Open  ]],
Cell[89529, 3408, 130, 4, 40, "MathCaption",
  CellTags->{"S1.4.10", "10.14"}],

Cell[CellGroupData[{
Cell[89684, 3416, 110, 2, 28, "Input",
  CellTags->"S1.4.10"],
Cell[89797, 3420, 115, 3, 42, "Output",
  CellTags->"S1.4.10"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

