(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    201036,       6704]*)
(*NotebookOutlinePosition[    262616,       8481]*)
(*  CellTagsIndexPosition[    257319,       8273]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.5 ", "HeadingNumber"],
  "Symbolic Mathematics"
}], "Section",
  CellTags->{"S1.5.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.5.1 Basic Operations", "Subsection",
  CellTags->{"S1.5.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  "'s ability to deal with symbolic expressions, as well as numbers, allows \
you to use it for many kinds of mathematics.  "
}], "Text",
  CellTags->{"S1.5.1", "1.2"}],

Cell[TextData[{
  "Calculus is one example. With ",
  StyleBox["Mathematica", "TI"],
  ", you can differentiate an expression ",
  StyleBox["symbolically", "TI"],
  ", and get a formula for the result. "
}], "Text",
  CellTags->{"S1.5.1", "1.3"}],

Cell[TextData[{
  "This finds the derivative of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.1", "1.4"}],

Cell[CellGroupData[{

Cell["D[ x^n, x ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.1"],

Cell[BoxData[
    \(n\ x\^\(\(-1\) + n\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.1"]
}, Open  ]],

Cell["Here is a slightly more complicated example. ", "MathCaption",
  CellTags->{"S1.5.1", "1.5"}],

Cell[CellGroupData[{

Cell["D[x^2 Log[x + a], x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.1"],

Cell[BoxData[
    \(x\^2\/\(a + x\) + 2\ x\ Log[a + x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the (partial) derivative ",
              Cell[BoxData[
                  FormBox[
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["f",
                          "TI"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          "TI"]}]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the indefinite integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the sum ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["i",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solution to an equation for ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Series[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["order", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a power series expansion of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["f",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " about the point ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "=", 
                      SubscriptBox[
                        StyleBox["x",
                          "TI"], "0"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Limit[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["->", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the limit ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderscriptBox["lim", 
                        RowBox[{
                          StyleBox["x",
                            "TI"], "\[Rule]", 
                          SubscriptBox[
                            StyleBox["x",
                              "TI"], "0"]}],
                        LimitsPositioning->True], 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Minimize[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "minimization of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["f",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " with respect to ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.1"],

Cell["Some symbolic mathematical operations. ", "Caption",
  CellTags->"S1.5.1"],

Cell[TextData[{
  "Getting formulas as the results of computations is usually desirable when \
it is possible. There are however many circumstances where it is \
mathematically impossible to get an explicit formula as the result of a \
computation. This happens, for example, when you try to solve an equation for \
which there is no \[OpenCurlyDoubleQuote]closed form\[CloseCurlyDoubleQuote] \
solution. In such cases, you must resort to numerical methods and \
approximations. These are discussed in Section ",
  ButtonBox["1.6",
    ButtonData:>{"1.6"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.5.1", "1.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.2 Differentiation", "Subsection",
  CellTags->{"S1.5.2", "2.1"}],

Cell[TextData[{
  "Here is the derivative of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " with respect to ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.2"}],

Cell[CellGroupData[{

Cell["D[ x^n, x ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    \(n\ x\^\(\(-1\) + n\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows the derivatives of all the standard mathematical functions. "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.3"}],

Cell[CellGroupData[{

Cell["D[ ArcTan[x], x ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    \(1\/\(1 + x\^2\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.2"]
}, Open  ]],

Cell[TextData[{
  "This differentiates three times with respect to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.4"}],

Cell[CellGroupData[{

Cell["D[ x^n, {x, 3} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    \(\((\(-2\) + n)\)\ \((\(-1\) + n)\)\ n\ x\^\(\(-3\) + n\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.2"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["D[x^n,", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " really gives a ",
  StyleBox["partial", "TI"],
  " derivative, in which ",
  StyleBox["n", "MR"],
  " is assumed not to depend on ",
  StyleBox["x", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " has another function, called ",
  StyleBox["Dt", "MR"],
  ", which finds ",
  StyleBox["total", "TI"],
  " derivatives, in which all variables are assumed to be related. In \
mathematical notation, ",
  StyleBox["D[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is like ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            StyleBox["f",
              "TI"]}], 
          RowBox[{"\[PartialD]", 
            StyleBox["x",
              "TI"]}]], TraditionalForm]], "InlineFormula"],
  ", while ",
  StyleBox["Dt[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is like ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[\(d  f\),
            "TI"], 
          StyleBox[\(d  x\),
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". You can think of ",
  StyleBox["Dt", "MR"],
  " as standing for \[OpenCurlyDoubleQuote]derivative total\
\[CloseCurlyDoubleQuote].    "
}], "Text",
  CellTags->{"S1.5.2", "2.5"}],

Cell[TextData[{
  StyleBox["Dt", "MR"],
  " gives a ",
  StyleBox["total derivative", "TI"],
  ", which assumes that ",
  StyleBox["n", "MR"],
  " can depend on ",
  StyleBox["x", "MR"],
  ". ",
  StyleBox["Dt[n,", "MR"],
  " ",
  StyleBox["x]", "MR"],
  " stands for ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox[\(d  n\),
            "TI"], 
          StyleBox[\(d  x\),
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.6"}],

Cell[CellGroupData[{

Cell["Dt[ x^n, x ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    \(x\^n\ \((n\/x + Dt[n, x]\ Log[x])\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.2"]
}, Open  ]],

Cell[TextData[{
  "This gives the total differential ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["d",
            "TI"], 
          RowBox[{"(", 
            SuperscriptBox[
              StyleBox["x",
                "TI"], 
              StyleBox["n",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["Dt[x]", "MR"],
  " is the differential ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(d  x\),
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.7"}],

Cell[CellGroupData[{

Cell["Dt[ x^n ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    \(x\^n\ \((\(n\ Dt[x]\)\/x + Dt[n]\ Log[x])\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "partial derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          StyleBox["x",
                            "TI"]}]], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "multiple derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          SubscriptBox[
                            StyleBox["x",
                              "TI"], "1"]}]], 
                      FractionBox["\[PartialD]", 
                        RowBox[{"\[PartialD]", 
                          SubscriptBox[
                            StyleBox["x",
                              "TI"], "2"]}]], " ", \(\(...\)\(\ \)\), 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "repeated derivative ",
              Cell[BoxData[
                  FormBox[
                    FractionBox[
                      RowBox[{
                        SuperscriptBox["\[PartialD]", 
                          StyleBox["n",
                            "TI"]], 
                        StyleBox["f",
                          "TI"]}], 
                      RowBox[{"\[PartialD]", 
                        SuperscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["n",
                            "TI"]]}]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "total differential ",
              Cell[BoxData[
                  FormBox[
                    StyleBox[\(d  f\),
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "total derivative ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      FractionBox[
                        StyleBox["d",
                          "TI"], 
                        StyleBox[\(d  x\),
                          "TI"]], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S1.5.2"],

Cell["Some differentiation functions. ", "Caption",
  CellTags->"S1.5.2"],

Cell[TextData[{
  "As well as treating variables like ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " symbolically, you can also treat functions in ",
  StyleBox["Mathematica", "TI"],
  " symbolically. Thus, for example, you can find formulas for derivatives of \
",
  StyleBox["f[x]", "MR"],
  ", without specifying any explicit form for the function ",
  StyleBox["f", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.5.2", "2.8"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not know how to differentiate ",
  StyleBox["f", "MR"],
  ", so it gives you back a symbolic result in terms of ",
  StyleBox["f'", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.9"}],

Cell[CellGroupData[{

Cell["D[ f[x], x ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses the chain rule to simplify derivatives. "
}], "MathCaption",
  CellTags->{"S1.5.2", "2.10"}],

Cell[CellGroupData[{

Cell["D[ 2 x f[x^2], x ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.2"],

Cell[BoxData[
    RowBox[{\(2\ f[x\^2]\), "+", 
      RowBox[{"4", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", \(x\^2\), "]"}]}]}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.3 Integration", "Subsection",
  CellTags->{"S1.5.3", "3.1"}],

Cell[TextData[{
  "Here is the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["n",
              "TI"]], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.2"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(x\^\(1 + n\)\/\(1 + n\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell["Here is a slightly more complicated example. ", "MathCaption",
  CellTags->{"S1.5.3", "3.3"}],

Cell[CellGroupData[{

Cell["Integrate[1/(x^4 - a^4), x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\(-\(ArcTan[x\/a]\/\(2\ a\^3\)\)\) + Log[a - x]\/\(4\ a\^3\) - 
      Log[a + x]\/\(4\ a\^3\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows how to do almost any integral that can be done in terms of standard \
mathematical functions. But you should realize that even though an integrand \
may contain only fairly simple functions, its integral may involve much more \
complicated functions\[LongDash]or may not be expressible at all in terms of \
standard mathematical functions.  "
}], "Text",
  CellTags->{"S1.5.3", "3.4"}],

Cell["Here is a fairly straightforward integral. ", "MathCaption",
  CellTags->{"S1.5.3", "3.5"}],

Cell[CellGroupData[{

Cell["Integrate[Log[1 - x^2], x ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\(-2\)\ x - Log[\(-1\) + x] + Log[1 + x] + x\ Log[1 - x\^2]\)], "Output",\

  CellLabel->"Out[3]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell["\<\
This integral can be done only in terms of a dilogarithm function. \
\
\>", "MathCaption",
  CellTags->{"S1.5.3", "3.6"}],

Cell[CellGroupData[{

Cell["Integrate[Log[1 - x^2]/x, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\(-\(1\/2\)\)\ PolyLog[2, x\^2]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[TextData[{
  "This integral involves ",
  StyleBox["Erf", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.7"}],

Cell[CellGroupData[{

Cell["Integrate[Exp[1 - x^2], x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(1\/2\ \[ExponentialE]\ \@\[Pi]\ Erf[x]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell["And this one involves a Fresnel function. ", "MathCaption",
  CellTags->{"S1.5.3", "3.8"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[x^2], x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\@\(\[Pi]\/2\)\ FresnelS[\@\(2\/\[Pi]\)\ x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell["Even this integral requires a hypergeometric function. ", "MathCaption",
  CellTags->{"S1.5.3", "3.9"}],

Cell[CellGroupData[{

Cell["Integrate[(1 - x^2)^n, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(x\ Hypergeometric2F1[1\/2, \(-n\), 3\/2, x\^2]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[TextData[{
  "This integral simply cannot be done in terms of standard mathematical \
functions. As a result, ",
  StyleBox["Mathematica", "TI"],
  " just leaves it undone. "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.10"}],

Cell[CellGroupData[{

Cell["Integrate[ x^x, x ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\[Integral]\(x\^x\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the indefinite integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the multiple integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["y",
                        "TI"], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the definite integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the multiple integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"], 
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["y",
                        "TI"], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.3"],

Cell["Integration. ", "Caption",
  CellTags->"S1.5.3"],

Cell[TextData[{
  "Here is the definite integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubsuperscriptBox["\[Integral]", 
            StyleBox["a",
              "TI"], 
            StyleBox["b",
              "TI"]], \(sin\^2\), 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], " ", 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.11"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[x]^2, {x, a, b} ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(1\/2\ \((\(-a\) + b + Cos[a]\ Sin[a] - Cos[b]\ Sin[b])\)\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell["Here is another definite integral. ", "MathCaption",
  CellTags->{"S1.5.3", "3.12"}],

Cell[CellGroupData[{

Cell["Integrate[Exp[-x^2], {x, 0, Infinity}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\@\[Pi]\/2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " cannot give you a formula for this definite integral. "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.13"}],

Cell[CellGroupData[{

Cell["Integrate[ x^x, {x, 0, 1} ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\[Integral]\_0\%1\( x\^x\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell["You can still get a numerical result, though. ", "MathCaption",
  CellTags->{"S1.5.3", "3.14"}],

Cell[CellGroupData[{

Cell["N[ % ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(0.783430510715466`\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[TextData[{
  "This evaluates the multiple integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_0\%1\), 
          StyleBox["d",
            "TI"], 
          StyleBox["x",
            "TI"], 
          SubsuperscriptBox["\[Integral]", "0", 
            StyleBox["x",
              "TI"]], 
          StyleBox["d",
            "TI"], 
          StyleBox["y",
            "TI"], " ", 
          RowBox[{"(", 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  "TI"], "2"], "+", 
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "2"]}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  ". The range of the outermost integration variable appears first. "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.15"}],

Cell[CellGroupData[{

Cell["Integrate[ x^2 + y^2, {x, 0, 1}, {y, 0, x} ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(1\/3\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.5.3"]
}, Open  ]],

Cell[TextData[{
  "This integrates ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "10"], TraditionalForm]], "InlineFormula"],
  " over a circular region. "
}], "MathCaption",
  CellTags->{"S1.5.3", "3.16"}],

Cell[CellGroupData[{

Cell["\<\
Integrate[ x^10 Boole[x^2 + y^2 <= 1], {x, -1, 1}, {y, -1 \
,1}]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.5.3"],

Cell[BoxData[
    \(\(21\ \[Pi]\)\/512\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.5.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.4 Sums and Products", "Subsection",
  CellTags->{"S1.5.4", "4.1"}],

Cell[TextData[{
  "This constructs the sum ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], "7",
            LimitsPositioning->True], 
          FractionBox[
            SuperscriptBox[
              StyleBox["x",
                "TI"], 
              StyleBox["i",
                "TI"]], 
            StyleBox["i",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.4", "4.2"}],

Cell[CellGroupData[{

Cell["Sum[x^i/i, {i, 1, 7}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(x + x\^2\/2 + x\^3\/3 + x\^4\/4 + x\^5\/5 + x\^6\/6 + 
      x\^7\/7\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[TextData[{
  "You can leave out the lower limit if it is equal to ",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.4", "4.3"}],

Cell[CellGroupData[{

Cell["Sum[x^i/i, {i, 7}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(x + x\^2\/2 + x\^3\/3 + x\^4\/4 + x\^5\/5 + x\^6\/6 + 
      x\^7\/7\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[TextData[{
  "This makes ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " increase in steps of ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ", so that only odd\[Hyphen]numbered values are included. "
}], "MathCaption",
  CellTags->{"S1.5.4", "4.4"}],

Cell[CellGroupData[{

Cell["Sum[x^i/i, {i, 1, 5, 2}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(x + x\^3\/3 + x\^5\/5\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell["Products work just like sums. ", "MathCaption",
  CellTags->{"S1.5.4", "4.5"}],

Cell[CellGroupData[{

Cell["Product[x + i, {i, 1, 4}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(\((1 + x)\)\ \((2 + x)\)\ \((3 + x)\)\ \((4 + x)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the sum ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["i",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the sum with ",
              StyleBox["i", "TI"],
              " increasing in steps of ",
              StyleBox["di", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the nested sum ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["i",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], 
                      UnderoverscriptBox["\[Sum]", 
                        RowBox[{
                          StyleBox["j",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["j",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["j",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Product[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the product ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Product]", 
                        RowBox[{
                          StyleBox["i",
                            "TI"], "=", 
                          SubscriptBox[
                            StyleBox["i",
                              "TI"], 
                            StyleBox["min",
                              "TI"]]}], 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["max",
                            "TI"]],
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.4"],

Cell["Sums and products. ", "Caption",
  CellTags->"S1.5.4"],

Cell[TextData[{
  "This sum is computed symbolically as a function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.4", "4.6"}],

Cell[CellGroupData[{

Cell["Sum[i^2, {i, 1, n}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(1\/6\ n\ \((1 + n)\)\ \((1 + 2\ n)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can also give an exact result for this infinite sum.   "
}], "MathCaption",
  CellTags->{"S1.5.4", "4.7"}],

Cell[CellGroupData[{

Cell["Sum[1/i^4, {i, 1, Infinity}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(\[Pi]\^4\/90\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell["\<\
As with integrals, simple sums can lead to complicated results.  \
\
\>", "MathCaption",
  CellTags->{"S1.5.4", "4.8"}],

Cell[CellGroupData[{

Cell["Sum[x^(i (i + 1)), {i, 1, Infinity}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(\(\(-2\)\ x\^\(1/4\) + EllipticTheta[2, 0, x]\)\/\(2\ x\^\(1/4\)\)\)], \
"Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell["\<\
This sum cannot be evaluated exactly using standard mathematical \
functions. \
\>", "MathCaption",
  CellTags->{"S1.5.4", "4.9"}],

Cell[CellGroupData[{

Cell["Sum[1/(i! + (2i)!), {i, 1, Infinity}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(\[Sum]\+\(i = 1\)\%\[Infinity] 1\/\(\(i!\) + \(\((2\ i)\)!\)\)\)], \
"Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell["\<\
You can nevertheless find a numerical approximation to the result. \
\
\>", "MathCaption",
  CellTags->{"S1.5.4", "4.10"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(0.37319734675969646`\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " also has a notation for multiple sums and products. ",
  StyleBox["Sum[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["j", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["j",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " represents a sum over ",
  StyleBox["i", "TI"],
  " and ",
  StyleBox["j", "TI"],
  ", which would be written in standard mathematical notation as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", 
              SubscriptBox[
                StyleBox["i",
                  "TI"], 
                StyleBox["min",
                  "TI"]]}], 
            SubscriptBox[
              StyleBox["i",
                "TI"], 
              StyleBox["max",
                "TI"]],
            LimitsPositioning->True], 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["j",
                "TI"], "=", 
              SubscriptBox[
                StyleBox["j",
                  "TI"], 
                StyleBox["min",
                  "TI"]]}], 
            SubscriptBox[
              StyleBox["j",
                "TI"], 
              StyleBox["max",
                "TI"]],
            LimitsPositioning->True], " ", 
          StyleBox["f",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". Notice that in ",
  StyleBox["Mathematica", "TI"],
  " notation, as in standard mathematical notation, the range of the ",
  StyleBox["outermost", "TI"],
  " variable is given ",
  StyleBox["first", "TI"],
  ".  "
}], "Text",
  CellTags->{"S1.5.4", "4.11"}],

Cell[TextData[{
  "This is the multiple sum ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], "3",
            LimitsPositioning->True], 
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["j",
                "TI"], "=", "1"}], 
            StyleBox["i",
              "TI"],
            LimitsPositioning->True], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            StyleBox["i",
              "TI"]], 
          SuperscriptBox[
            StyleBox["y",
              "TI"], 
            StyleBox["j",
              "TI"]]}], TraditionalForm]], "InlineFormula"],
  ". Notice that the outermost sum over ",
  StyleBox["i", "MR"],
  " is given first, just as in the mathematical notation. "
}], "MathCaption",
  CellTags->{"S1.5.4", "4.12"}],

Cell[CellGroupData[{

Cell["Sum[x^i y^j, {i, 1, 3}, {j, 1, i}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.5.4"],

Cell[BoxData[
    \(x\ y + x\^2\ y + x\^3\ y + x\^2\ y\^2 + x\^3\ y\^2 + 
      x\^3\ y\^3\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[TextData[{
  "The way the ranges of variables are specified in ",
  StyleBox["Sum", "MR"],
  " and ",
  StyleBox["Product", "MR"],
  " is an example of the rather general ",
  StyleBox["iterator notation", "TI"],
  " that ",
  StyleBox["Mathematica", "TI"],
  " uses. You will see this notation again when we discuss generating tables \
and lists using ",
  StyleBox["Table", "MR"],
  " (Section ",
  ButtonBox["1.8.2",
    ButtonData:>{"1.8.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  "), and when we describe ",
  StyleBox["Do", "MR"],
  " loops (Section ",
  ButtonBox["1.7.3",
    ButtonData:>{"1.7.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ").  "
}], "Text",
  CellTags->{"S1.5.4", "4.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "iterate ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " times, without incrementing any variables "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              StyleBox["1", "MR"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in steps of ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in steps of ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " in steps of ",
              StyleBox["di", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              StyleBox["i", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", and for each such value, ",
              StyleBox["j", "TI"],
              " goes from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.4"],

Cell[TextData[{
  StyleBox["Mathematica", "SO"],
  " iterator notation. "
}], "Caption",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.5 Equations", "Subsection",
  CellTags->{"S1.5.5", "5.1"}],

Cell[TextData[{
  "Section\[NonBreakingSpace]",
  ButtonBox["1.2.2",
    ButtonData:>{"1.2.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  " discussed ",
  StyleBox["assignments", "TI"],
  " such as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["y", "TI"],
  " which ",
  StyleBox["set", "TI"],
  " ",
  StyleBox["x", "TI"],
  " equal to ",
  StyleBox["y", "TI"],
  ". This section discusses ",
  StyleBox["equations", "TI"],
  ", which ",
  StyleBox["test", "TI"],
  " equality. The equation ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "TI"],
  " ",
  StyleBox["tests", "TI"],
  " whether ",
  StyleBox["x", "TI"],
  " is equal to ",
  StyleBox["y", "TI"],
  ".     "
}], "Text",
  CellTags->{"S1.5.5", "5.2"}],

Cell[TextData[{
  "This ",
  StyleBox["tests", "TI"],
  " whether ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " and ",
  StyleBox["4", "MR"],
  " are equal. The result is the symbol ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.3"}],

Cell[CellGroupData[{

Cell["2 + 2 == 4", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "It is very important that you do not confuse ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["y", "TI"],
  " with ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". While ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["y", "TI"],
  " is an ",
  StyleBox["imperative", "TI"],
  " statement that actually causes an assignment to be done, ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "TI"],
  " merely ",
  StyleBox["tests", "TI"],
  " whether ",
  StyleBox["x", "TI"],
  " and ",
  StyleBox["y", "TI"],
  " are equal, and causes no explicit action. If you have used the C \
programming language, you will recognize that the notation for assignment and \
testing in ",
  StyleBox["Mathematica", "TI"],
  " is the same as in C.   "
}], "Text",
  CellTags->{"S1.5.5", "5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "assigns ",
              StyleBox["x", "TI"],
              " to have value ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "tests whether ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " are equal "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.5"],

Cell["Assignments and tests. ", "Caption",
  CellTags->"S1.5.5"],

Cell[TextData[{
  "This ",
  StyleBox["assigns", "TI"],
  " ",
  StyleBox["x", "MR"],
  " to have value ",
  StyleBox["4", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.5"}],

Cell[CellGroupData[{

Cell["x = 4", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "If you ask for ",
  StyleBox["x", "MR"],
  ", you now get ",
  StyleBox["4", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.6"}],

Cell[CellGroupData[{

Cell["x", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "This ",
  StyleBox["tests", "TI"],
  " whether ",
  StyleBox["x", "MR"],
  " is equal to ",
  StyleBox["4", "MR"],
  ". In this case, it is. "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.7"}],

Cell[CellGroupData[{

Cell["x == 4", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["x", "MR"],
  " is equal to ",
  StyleBox["4", "MR"],
  ", not ",
  StyleBox["6", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.8"}],

Cell[CellGroupData[{

Cell["x == 6", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "This removes the value assigned to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.9"}],

Cell["x =.", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.5"],

Cell[TextData[{
  "The tests we have used so far involve only numbers, and always give a \
definite answer, either ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ". You can also do tests on symbolic expressions. "
}], "Text",
  CellTags->{"S1.5.5", "5.10"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " cannot get a definite result for this test unless you give ",
  StyleBox["x", "MR"],
  " a specific numerical value. "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.11"}],

Cell[CellGroupData[{

Cell["x == 5", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(x \[Equal] 5\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "If you replace ",
  StyleBox["x", "MR"],
  " by the specific numerical value ",
  StyleBox["4", "MR"],
  ", the test gives ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.12"}],

Cell[CellGroupData[{

Cell["% /. x -> 4", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "Even when you do tests on symbolic expressions, there are some cases where \
you can get definite results. An important one is when you test the equality \
of two expressions that are ",
  StyleBox["identical", "TI"],
  ". Whatever the numerical values of the variables in these expressions may \
be, ",
  StyleBox["Mathematica", "TI"],
  " knows that the expressions must always be equal. "
}], "Text",
  CellTags->{"S1.5.5", "5.13"}],

Cell[TextData[{
  "The two expressions are ",
  StyleBox["identical", "TI"],
  ", so the result is ",
  StyleBox["True", "MR"],
  ", whatever the value of ",
  StyleBox["x", "MR"],
  " may be. "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.14"}],

Cell[CellGroupData[{

Cell["2 x + x^2 == 2 x + x^2", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not try to tell whether these expressions are equal. In this case, \
using ",
  StyleBox["Expand", "MR"],
  " would make them have the same form. "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.15"}],

Cell[CellGroupData[{

Cell["2 x + x^2 == x (2 + x)", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(2\ x + x\^2 \[Equal] x\ \((2 + x)\)\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "Expressions like ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["4", "MR"],
  " represent ",
  StyleBox["equations", "TI"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". There are many functions in ",
  StyleBox["Mathematica", "TI"],
  " for manipulating and solving equations. "
}], "Text",
  CellTags->{"S1.5.5", "5.16"}],

Cell[TextData[{
  "This is an ",
  StyleBox["equation", "TI"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". Subsection\[NonBreakingSpace]",
  ButtonBox["1.5.7",
    ButtonData:>{"1.5.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how to solve it for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.17"}],

Cell[CellGroupData[{

Cell["x^2 + 2 x - 7 == 0", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(\(-7\) + 2\ x + x\^2 \[Equal] 0\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell["You can assign a name to the equation. ", "MathCaption",
  CellTags->{"S1.5.5", "5.18"}],

Cell[CellGroupData[{

Cell["eqn = %", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(\(-7\) + 2\ x + x\^2 \[Equal] 0\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.5.5"]
}, Open  ]],

Cell[TextData[{
  "If you ask for ",
  StyleBox["eqn", "MR"],
  ", you now get the equation. "
}], "MathCaption",
  CellTags->{"S1.5.5", "5.19"}],

Cell[CellGroupData[{

Cell["eqn", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.5.5"],

Cell[BoxData[
    \(\(-7\) + 2\ x + x\^2 \[Equal] 0\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.5.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.6 Relational and Logical Operators", "Subsection",
  CellTags->{"S1.5.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "equal (also input as ",
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "unequal (also input as ",
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox[">", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell["greater than "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox[">=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "greater than or equal to (also input as ",
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              ")"
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["<", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell["less than "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["<=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "less than or equal to (also input as ",
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              ")"
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell["all equal "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell["all unequal (distinct) "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox[">", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox[">", "MR"],
              " ",
              StyleBox["z", "TI"],
              ",  etc. "
            }]], Cell["strictly decreasing, etc. "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, False, True, False}},
  CellTags->"S1.5.6"],

Cell["Relational operators. ", "Caption",
  CellTags->"S1.5.6"],

Cell[TextData[{
  "This tests whether ",
  StyleBox["10", "MR"],
  " is less than ",
  StyleBox["7", "MR"],
  ". The result is ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.2"}],

Cell[CellGroupData[{

Cell["10 < 7", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  "Not all of these numbers are unequal, so this gives ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.3"}],

Cell[CellGroupData[{

Cell["3 != 2 != 3", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  "You can mix ",
  StyleBox["<", "MR"],
  " and ",
  StyleBox["<=", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.4"}],

Cell[CellGroupData[{

Cell["3 < 5 <= 6", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  "Since both of the quantities involved are numeric, ",
  StyleBox["Mathematica", "TI"],
  " can determine that this is true. "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.5"}],

Cell[CellGroupData[{

Cell["Pi^E < E^Pi", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not know whether this is true or false. "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.6"}],

Cell[CellGroupData[{

Cell["x > y", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(x > y\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["p", "TI"],
              " "
            }]], Cell[TextData[{
              "not (also input as ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Not] \)], "InlineFormula"],
              StyleBox["p", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["q", "TI"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "and (also input as ",
              StyleBox["p", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              StyleBox["q", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              "\[Ellipsis]",
              " ",
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              " ",
              StyleBox["||", "MR"],
              " ",
              StyleBox["q", "TI"],
              " ",
              StyleBox["||", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "or (also input as ",
              StyleBox["p", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              StyleBox["q", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              "\[Ellipsis]",
              " ",
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Xor[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["q", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "exclusive or (also input as ",
              StyleBox["p", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
              " ",
              StyleBox["q", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Xor] \)], "InlineFormula"],
              " ",
              "\[Ellipsis]",
              " ",
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Nand[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["q", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              "  and  ",
              StyleBox["Nor[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["q", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "nand and nor (also input as ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nand] \)], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Nor] \)], "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["If[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["then", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["else", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["then", "TI"],
              " if ",
              StyleBox["p", "TI"],
              " is ",
              StyleBox["True", "MR"],
              ", and ",
              StyleBox["else", "TI"],
              " if ",
              StyleBox["p", "TI"],
              " is ",
              StyleBox["False", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["LogicalExpand[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["expand out logical expressions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False}},
  CellTags->"S1.5.6"],

Cell["Logical operations. ", "Caption",
  CellTags->"S1.5.6"],

Cell[TextData[{
  "Both tests give ",
  StyleBox["True", "MR"],
  ", so the result is ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.7"}],

Cell[CellGroupData[{

Cell["7 > 4 && 2 != 3", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  "You should remember that the logical operations ",
  StyleBox["==", "MR"],
  ", ",
  StyleBox["&&", "MR"],
  " and ",
  StyleBox["||", "MR"],
  " are all ",
  StyleBox["double characters", "TI"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". If you have used a programming language such as C, you will be familiar \
with this notation.  "
}], "Text",
  CellTags->{"S1.5.6", "6.8"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not know whether this is true or false. "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.9"}],

Cell[CellGroupData[{

Cell["p && q", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(p && q\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " leaves this expression unchanged. "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.10"}],

Cell[CellGroupData[{

Cell["(p || q) && !(r || s)", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(\((p || q)\) && \(! \((r || s)\)\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.5.6"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["LogicalExpand", "MR"],
  " to expand out the terms. "
}], "MathCaption",
  CellTags->{"S1.5.6", "6.11"}],

Cell[CellGroupData[{

Cell["LogicalExpand[ % ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.5.6"],

Cell[BoxData[
    \(\((p && \(! r\) && \(! s\))\) || \((q && \(! r\) && \(! s\))\)\)], \
"Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.5.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.7 Solving Equations", "Subsection",
  CellTags->{"S1.5.7", "7.1"}],

Cell[TextData[{
  "An expression like ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["7", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["0", "MR"],
  " represents an ",
  StyleBox["equation", "TI"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". You will often need to ",
  StyleBox["solve", "TI"],
  " equations like this, to find out for what values of ",
  StyleBox["x", "MR"],
  " they are true.    "
}], "Text",
  CellTags->{"S1.5.7", "7.2"}],

Cell[TextData[{
  "This gives the two solutions to the quadratic equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", "2", 
          StyleBox["x",
            "TI"], "-", "7", "=", "0"}], TraditionalForm]], "InlineFormula"],
  ". The solutions are given as replacements for\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.3"}],

Cell[CellGroupData[{

Cell["Solve[x^2 + 2x - 7 == 0, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-1\) - 2\ \@2}, {x \[Rule] \(-1\) + 2\ \@2}}\)], "Output",\

  CellLabel->"Out[1]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell["Here are the numerical values of the solutions.    ", "MathCaption",
  CellTags->{"S1.5.7", "7.4"}],

Cell[CellGroupData[{

Cell["N[ % ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-3.8284271247461903`\)}, {x \[Rule] 
          1.8284271247461903`}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "You can get a list of the actual solutions for ",
  StyleBox["x", "MR"],
  " by applying the rules generated by ",
  StyleBox["Solve", "MR"],
  " to ",
  StyleBox["x", "MR"],
  " using the replacement operator. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.5"}],

Cell[CellGroupData[{

Cell["x /. %", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({\(-3.8284271247461903`\), 1.8284271247461903`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "You can equally well apply the rules to any other expression involving ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.6"}],

Cell[CellGroupData[{

Cell["x^2 + 3 x /. %%", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({3.17157287525381`, 8.828427124746192`}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve an equation, giving a list of rules for ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["solution", "TI"],
              " "
            }]], Cell[TextData[{
              "use the list of rules to get values for ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["solution", "TI"],
              " "
            }]], Cell[
            "use the list of rules to get values for an expression "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.7"],

Cell["Finding and using solutions to equations. ", "Caption",
  CellTags->"S1.5.7"],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " always tries to give you explicit ",
  StyleBox["formulas", "TI"],
  " for the solutions to equations. However, it is a basic mathematical \
result that, for sufficiently complicated equations, explicit algebraic \
formulas cannot be given. If you have an algebraic equation in one variable, \
and the highest power of the variable is at most four, then ",
  StyleBox["Mathematica", "TI"],
  " can always give you formulas for the solutions. However, if the highest \
power is five or more, it may be mathematically impossible to give explicit \
algebraic formulas for all the solutions. "
}], "Text",
  CellTags->{"S1.5.7", "7.7"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can always solve algebraic equations in one variable when the highest \
power is less than five. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.8"}],

Cell[CellGroupData[{

Cell["Solve[x^4 - 5 x^2 - 3 == 0, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-\@\(5\/2 + \@37\/2\)\)}, {x \[Rule] \@\(5\/2 + \
\@37\/2\)}, {x \[Rule] \(-\[ImaginaryI]\)\ \@\(1\/2\ \((\(-5\) + \@37)\)\)}, \
{x \[Rule] \[ImaginaryI]\ \@\(1\/2\ \((\(-5\) + \@37)\)\)}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell["It can solve some equations that involve higher powers. ", "MathCaption",
  CellTags->{"S1.5.7", "7.9"}],

Cell[CellGroupData[{

Cell["Solve[x^6 == 1, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 
          1}, {x \[Rule] \(-\((\(-1\))\)\^\(1/3\)\)}, {x \[Rule] \((\(-1\))\)\
\^\(1/3\)}, {x \[Rule] \(-\((\(-1\))\)\^\(2/3\)\)}, {x \[Rule] \((\(-1\))\)\^\
\(2/3\)}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "There are some equations, however, for which it is mathematically \
impossible to find explicit formulas for the solutions. ",
  StyleBox["Mathematica", "TI"],
  " uses ",
  StyleBox["Root", "MR"],
  " objects to represent the solutions in this case.  "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.10"}],

Cell[CellGroupData[{

Cell["Solve[2 - 4 x + x^5 == 0, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] Root[2 - 4\ #1 + #1\^5 &, 1]}, {x \[Rule] 
          Root[2 - 4\ #1 + #1\^5 &, 2]}, {x \[Rule] 
          Root[2 - 4\ #1 + #1\^5 &, 3]}, {x \[Rule] 
          Root[2 - 4\ #1 + #1\^5 &, 4]}, {x \[Rule] 
          Root[2 - 4\ #1 + #1\^5 &, 5]}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell["\<\
Even though you cannot get explicit formulas, you can still find \
the solutions numerically. \
\>", "MathCaption",
  CellTags->{"S1.5.7", "7.11"}],

Cell[CellGroupData[{

Cell["N[ % ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-1.518512152784912`\)}, {x \[Rule] 
          0.5084994846573329`}, {x \[Rule] 
          1.2435963905735432`}, {x \[Rule] \(-0.11679186122298205`\) - 
            1.4384476953291772`\ \[ImaginaryI]}, {x \[Rule] \
\(-0.11679186122298205`\) + 1.4384476953291772`\ \[ImaginaryI]}}\)], "Output",\

  CellLabel->"Out[8]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "In addition to being able to solve purely algebraic equations, ",
  StyleBox["Mathematica", "TI"],
  " can also solve some equations involving other functions. "
}], "Text",
  CellTags->{"S1.5.7", "7.12"}],

Cell[TextData[{
  "After printing a warning, ",
  StyleBox["Mathematica", "TI"],
  " returns one solution to this equation. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.13"}],

Cell[CellGroupData[{

Cell["Solve[ Sin[x] == a, x ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(Solve::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found; use Reduce for complete solution information."\)], "Message",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] ArcSin[a]}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "It is important to realize that an equation such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["a",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " actually has an infinite number of possible solutions, in this case \
differing by multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi]\)], "InlineFormula"],
  ". However, ",
  StyleBox["Solve", "MR"],
  " by default returns just one solution, but prints a message telling you \
that other solutions may exist. You can use ",
  StyleBox["Reduce", "MR"],
  " to get more information. "
}], "Text",
  CellTags->{"S1.5.7", "7.14"}],

Cell["\<\
There is no explicit \[OpenCurlyDoubleQuote]closed form\
\[CloseCurlyDoubleQuote] solution for a transcendental equation like this. \
\
\>", "MathCaption",
  CellTags->{"S1.5.7", "7.15"}],

Cell[CellGroupData[{

Cell["Solve[ Cos[x] == x, x ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(Solve::"tdep" \(\(:\)\(\ \)\) 
      "The equations appear to involve the variables to be solved for in an \
essentially non-algebraic way."\)], "Message",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(Solve[Cos[x] \[Equal] x, x]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "You can find an approximate numerical solution using ",
  StyleBox["FindRoot", "MR"],
  ", and giving a starting value for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.16"}],

Cell[CellGroupData[{

Cell["FindRoot[ Cos[x] == x, {x, 0} ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({x \[Rule] 0.7390851332151607`}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Solve", "MR"],
  " can also handle equations involving symbolic functions. In such cases, it \
again prints a warning, then gives results in terms of formal inverse \
functions. "
}], "Text",
  CellTags->{"S1.5.7", "7.17"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " returns a result in terms of the formal inverse function of ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.18"}],

Cell[CellGroupData[{

Cell["Solve[ f[x^2] == a, x ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(InverseFunction::"ifun" \(\(:\)\(\ \)\) 
      "Inverse functions are being used. Values may be lost for multivalued \
inverses."\)], "Message",
  CellTags->"S1.5.7"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"x", "\[Rule]", 
            RowBox[{"-", 
              SqrtBox[
                RowBox[{
                  TagBox[\(f\^\((\(-1\))\)\),
                    {InverseFunction, 1, 1},
                    Editable->False], "[", "a", "]"}]]}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"x", "\[Rule]", 
            SqrtBox[
              RowBox[{
                TagBox[\(f\^\((\(-1\))\)\),
                  {InverseFunction, 1, 1},
                  Editable->False], "[", "a", "]"}]]}], "}"}]}], 
      "}"}]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Solve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a set of simultaneous equations for ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.7"],

Cell["Solving sets of simultaneous equations. ", "Caption",
  CellTags->"S1.5.7"],

Cell[TextData[{
  "You can also use ",
  StyleBox["Mathematica", "TI"],
  " to solve sets of simultaneous equations. You simply give the list of \
equations, and specify the list of variables to solve for. "
}], "Text",
  CellTags->{"S1.5.7", "7.19"}],

Cell[TextData[{
  "Here is a list of two simultaneous equations, to be solved for the \
variables ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.20"}],

Cell[CellGroupData[{

Cell["Solve[{a x + y == 0, 2 x + (1-a) y == 1}, {x, y}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-\(1\/\(\(-2\) + a - a\^2\)\)\), 
        y \[Rule] \(-\(a\/\(2 - a + a\^2\)\)\)}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "Here are some more complicated simultaneous equations. The two solutions \
are given as two lists of replacements for ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.21"}],

Cell[CellGroupData[{

Cell["Solve[{x^2 + y^2 == 1, x + 3 y == 0}, {x, y}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({{x \[Rule] \(-\(3\/\@10\)\), y \[Rule] 1\/\@10}, {x \[Rule] 3\/\@10, 
        y \[Rule] \(-\(1\/\@10\)\)}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "This uses the solutions to evaluate the expression ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.22"}],

Cell[CellGroupData[{

Cell["x + y /. %", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({\(-\@\(2\/5\)\), \@\(2\/5\)}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can solve any set of simultaneous ",
  StyleBox["linear", "TI"],
  " equations. It can also solve a large class of simultaneous polynomial \
equations. Even when it does not manage to solve the equations explicitly, ",
  StyleBox["Mathematica", "TI"],
  " will still usually reduce them to a much simpler form. "
}], "Text",
  CellTags->{"S1.5.7", "7.23"}],

Cell["\<\
When you are working with sets of equations in several variables, \
it is often convenient to reorganize the equations by eliminating some \
variables between them.  \
\>", "Text",
  CellTags->{"S1.5.7", "7.24"}],

Cell[TextData[{
  "This eliminates ",
  StyleBox["y", "MR"],
  " between the two equations, giving a single equation \
for\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.25"}],

Cell[CellGroupData[{

Cell["Eliminate[{a x + y == 0, 2 x + (1-a) y == 1}, y]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(\((2 - a + a\^2)\)\ x \[Equal] 1\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "If you have several equations, there is no guarantee that there exists ",
  StyleBox["any", "TI"],
  " consistent solution for a particular variable.   "
}], "Text",
  CellTags->{"S1.5.7", "7.26"}],

Cell[TextData[{
  "There is no consistent solution to these equations, so ",
  StyleBox["Mathematica", "TI"],
  " returns ",
  StyleBox["{}", "MR"],
  ", indicating that the set of solutions is empty. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.27"}],

Cell[CellGroupData[{

Cell["Solve[{x==1, x==2}, x]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "There is also no consistent solution to these equations for almost all \
values of\[NonBreakingSpace]",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.28"}],

Cell[CellGroupData[{

Cell["Solve[{x==1, x==a}, x]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "The general question of whether a set of equations has any consistent \
solution is quite a subtle one. For example, for most values of ",
  StyleBox["a", "MR"],
  ", the equations ",
  StyleBox["{x==1,", "MR"],
  " ",
  StyleBox["x==a}", "MR"],
  " are inconsistent, so there is no possible solution for ",
  StyleBox["x", "MR"],
  ". However, if ",
  StyleBox["a", "MR"],
  " is equal to ",
  StyleBox["1", "MR"],
  ", then the equations ",
  StyleBox["do", "TI"],
  " have a solution. ",
  StyleBox["Solve", "MR"],
  " is set up to give you ",
  StyleBox["generic", "TI"],
  " solutions to equations. It discards any solutions that exist only when \
special constraints between parameters are satisfied.     "
}], "Text",
  CellTags->{"S1.5.7", "7.29"}],

Cell[TextData[{
  "If you use ",
  StyleBox["Reduce", "MR"],
  " instead of ",
  StyleBox["Solve", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will however keep ",
  StyleBox["all", "TI"],
  " the possible solutions to a set of equations, including those that \
require special conditions on parameters.  "
}], "Text",
  CellTags->{"S1.5.7", "7.30"}],

Cell[TextData[{
  "This shows that the equations have a solution only when ",
  StyleBox["a==1", "MR"],
  ". The notation ",
  StyleBox["a==1", "MR"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  StyleBox["x==1", "MR"],
  " represents the requirement that ",
  StyleBox["both", "TI"],
  " ",
  StyleBox["a==1", "MR"],
  " ",
  StyleBox["and", "TI"],
  " ",
  StyleBox["x==1", "MR"],
  " should be ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.31"}],

Cell[CellGroupData[{

Cell["Reduce[{x==a, x==1}, x]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(a \[Equal] 1 && x \[Equal] 1\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "This gives the complete set of possible solutions to the equation. The \
answer is stated in terms of a combination of simpler equations. ",
  StyleBox["&&", "MR"],
  " indicates equations that must simultaneously be true; ",
  StyleBox["||", "MR"],
  " indicates alternatives. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.32"}],

Cell[CellGroupData[{

Cell["Reduce[a x - b == 0, x]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(\((b \[Equal] 0 && a \[Equal] 0)\) || \((a \[NotEqual] 0 && 
          x \[Equal] b\/a)\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell["This gives a more complicated combination of equations. ", "MathCaption",
  CellTags->{"S1.5.7", "7.33"}],

Cell[CellGroupData[{

Cell["Reduce[a x^2 - b == 0, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(\((b \[Equal] 0 && 
          a \[Equal] 0)\) || \((a \[NotEqual] 
            0 && \((x \[Equal] \(-\(\@b\/\@a\)\) || 
              x \[Equal] \@b\/\@a)\))\)\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell["This gives a symbolic representation of all solutions. ", "MathCaption",
  CellTags->{"S1.5.7", "7.34"}],

Cell[CellGroupData[{

Cell["Reduce[Sin[x] == a, x]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(C[1] \[Element] 
        Integers && \((x \[Equal] \[Pi] - ArcSin[a] + 2\ \[Pi]\ C[1] || 
          x \[Equal] ArcSin[a] + 2\ \[Pi]\ C[1])\)\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Solve[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve an equation for ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Solve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a set of simultaneous equations for ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Eliminate[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "eliminate ",
              StyleBox["x", "TI"],
              ", \[Ellipsis]",
              " ",
              " in a set of simultaneous equations "
            }]]},
          {Cell[TextData[{
              StyleBox["Reduce[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], 
            Cell["\<\
give a set of simplified equations, including all \
possible solutions \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.7"],

Cell["Functions for solving and manipulating equations. ", "Caption",
  CellTags->"S1.5.7"],

Cell[TextData[{
  StyleBox["Reduce", "MR"],
  " also has powerful capabilities for handling equations specifically over \
real numbers or integers. Section ",
  ButtonBox["3.4.9",
    ButtonData:>{"3.4.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  " discusses this in more detail. "
}], "Text",
  CellTags->{"S1.5.7", "7.35"}],

Cell[TextData[{
  "This reduces the equation assuming ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " are complex. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.36"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 == 1, y]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(y \[Equal] \(-\@\(1 - x\^2\)\) || y \[Equal] \@\(1 - x\^2\)\)], "Output",\

  CellLabel->"Out[23]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell[TextData[{
  "This includes the conditions for ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " to be real. "
}], "MathCaption",
  CellTags->{"S1.5.7", "7.37"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 == 1, y, Reals]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(\(-1\) \[LessEqual] x \[LessEqual] 
        1 && \((y \[Equal] \(-\@\(1 - x\^2\)\) || 
          y \[Equal] \@\(1 - x\^2\))\)\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S1.5.7"]
}, Open  ]],

Cell["This gives only the integer solutions. ", "MathCaption",
  CellTags->{"S1.5.7", "7.38"}],

Cell[CellGroupData[{

Cell["Reduce[x^2 + y^2 == 1, y, Integers]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S1.5.7"],

Cell[BoxData[
    \(\((x \[Equal] \(-1\) && y \[Equal] 0)\) || \((x \[Equal] 0 && 
          y \[Equal] \(-1\))\) || \((x \[Equal] 0 && 
          y \[Equal] 1)\) || \((x \[Equal] 1 && y \[Equal] 0)\)\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S1.5.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.8 Inequalities", "Subsection",
  CellTags->{"S1.5.8", "8.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Reduce[", "MR"],
              StyleBox["ineqs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["reduce a collection of inequalities "]},
          {Cell[TextData[{
              StyleBox["FindInstance[", "MR"],
              StyleBox["ineqs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find an instance that satisfies the ",
              StyleBox["ineqs", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.8"],

Cell["Handling inequalities. ", "Caption",
  CellTags->"S1.5.8"],

Cell["This finds a reduced form for the inequalities. ", "MathCaption",
  CellTags->{"S1.5.8", "8.2"}],

Cell[CellGroupData[{

Cell["Reduce[x + y < 1 && y > x > 0, {x, y}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.8"],

Cell[BoxData[
    \(0 < x < 1\/2 && x < y < 1 - x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.8"]
}, Open  ]],

Cell["These inequalities can never be satisfied. ", "MathCaption",
  CellTags->{"S1.5.8", "8.3"}],

Cell[CellGroupData[{

Cell["Reduce[x + y < 1 && y > x > 1, {x, y}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.8"]
}, Open  ]],

Cell["It is easy to end up with rather complicated results. ", "MathCaption",
  CellTags->{"S1.5.8", "8.4"}],

Cell[CellGroupData[{

Cell["Reduce[x + y < 1 && y^2 > x > 0, {x, y}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.8"],

Cell[BoxData[
    \(\((0 < x < 
            1\/2\ \((3 - \@5)\) && \((y < \(-\@x\) || \@x < y < 
                1 - x)\))\) || \((1\/2\ \((3 - \@5)\) \[LessEqual] x < 
            1\/2\ \((3 + \@5)\) && 
          y < \(-\@x\))\) || \((x \[GreaterEqual] 1\/2\ \((3 + \@5)\) && 
          y < 1 - x)\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.8"]
}, Open  ]],

Cell[TextData[{
  "Equations can often be solved to give definite values of variables. But \
inequalities typically just define regions that can only be specified by \
other inequalities. You can use ",
  StyleBox["FindInstance", "MR"],
  " to find definite values of variables that satisfy a particular set of \
inequalities. "
}], "Text",
  CellTags->{"S1.5.8", "8.5"}],

Cell["\<\
This finds a point in the region specified by the inequalities. \
\
\>", "MathCaption",
  CellTags->{"S1.5.8", "8.6"}],

Cell[CellGroupData[{

Cell["FindInstance[x + y < 1 && y^2 > x > 0, {x, y}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.8"],

Cell[BoxData[
    \({{x \[Rule] 7\/2, y \[Rule] \(-3\)}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Minimize[{", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ineq", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "minimize ",
              StyleBox["expr", "TI"],
              " while satisfying ",
              StyleBox["ineqs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Maximize[{", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ineq", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximize ",
              StyleBox["expr", "TI"],
              " while satisfying ",
              StyleBox["ineqs", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.8"],

Cell["Constrained minimization and maximization. ", "Caption",
  CellTags->"S1.5.8"],

Cell["This gives the maximum, together with where it occurs. ", "MathCaption",
  CellTags->{"S1.5.8", "8.7"}],

Cell[CellGroupData[{

Cell["Maximize[{x^2 + y, x^2 + y^2 <= 1}, {x, y}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.8"],

Cell[BoxData[
    \({5\/4, {x \[Rule] \(-\(\@3\/2\)\), y \[Rule] 1\/2}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.9 Differential Equations", "Subsection",
  CellTags->{"S1.5.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DSolve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a differential equation for ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              ", taking ",
              StyleBox["x", "TI"],
              " as the independent variable "
            }]]},
          {Cell[TextData[{
              StyleBox["DSolve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a solution for ",
              StyleBox["y", "TI"],
              " in pure function form "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.9"],

Cell["Solving an ordinary differential equation. ", "Caption",
  CellTags->"S1.5.9"],

Cell[TextData[{
  "Here is the solution to the differential equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["a",
            "TI"], 
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "+", "1"}], TraditionalForm]], "InlineFormula"],
  ". ",
  StyleBox["C[1]", "MR"],
  " is a coefficient which must be determined from boundary conditions. "
}], "MathCaption",
  CellTags->{"S1.5.9", "9.2"}],

Cell[CellGroupData[{

Cell["DSolve[ y'[x] == a y[x] + 1, y[x], x ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.9"],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(-\(1\/a\)\) + \[ExponentialE]\^\(a\ x\)\ C[
                1]}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.9"]
}, Open  ]],

Cell["\<\
If you include an appropriate initial condition, there are no \
undetermined coefficients in the solution. \
\>", "MathCaption",
  CellTags->{"S1.5.9", "9.3"}],

Cell[CellGroupData[{

Cell["DSolve[ {y'[x] == a y[x] + 1, y[0] == 0}, y[x], x ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.9"],

Cell[BoxData[
    \({{y[x] \[Rule] \(\(-1\) + \[ExponentialE]\^\(a\ x\)\)\/a}}\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"S1.5.9"]
}, Open  ]],

Cell[TextData[{
  "Whereas algebraic equations such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", 
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " are equations for ",
  StyleBox["variables", "TI"],
  ", differential equations such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " are equations for ",
  StyleBox["functions", "TI"],
  ". In ",
  StyleBox["Mathematica", "TI"],
  ", you must always give differential equations explicitly in terms of \
functions such as ",
  StyleBox["y", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", and you must specify the variables such as ",
  StyleBox["x", "TI"],
  " on which the functions depend. As a result, you must write an equation \
such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " in the form ",
  StyleBox["y''[x]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y'[x]", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y[x]", "MR"],
  ". You cannot write it as ",
  StyleBox["y''", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y'", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.5.9", "9.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can solve both linear and nonlinear ordinary differential equations, as \
well as lists of simultaneous equations. If you do not specify enough initial \
or boundary conditions, ",
  StyleBox["Mathematica", "TI"],
  " will give solutions that involve an appropriate number of undetermined \
coefficients. Each time you use ",
  StyleBox["DSolve", "MR"],
  ", it names the undetermined coefficients ",
  StyleBox["C[1]", "MR"],
  ", ",
  StyleBox["C[2]", "MR"],
  ", etc. "
}], "Text",
  CellTags->{"S1.5.9", "9.5"}],

Cell["\<\
Here is a pair of simultaneous differential equations, with no \
initial or boundary conditions. The solution you get involves two \
undetermined coefficients. \
\>", "MathCaption",
  CellTags->{"S1.5.9", "9.6"}],

Cell[CellGroupData[{

Cell["DSolve[ {x'[t] == y[t], y'[t] == x[t]}, {x[t], y[t]}, t ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.9"],

Cell[BoxData[
    \({{x[t] \[Rule] 
          1\/2\ \[ExponentialE]\^\(-t\)\ \((1 + \[ExponentialE]\^\(2\ t\))\)\ \
C[1] + 1\/2\ \[ExponentialE]\^\(-t\)\ \((\(-1\) + \[ExponentialE]\^\(2\ \
t\))\)\ C[2], 
        y[t] \[Rule] 
          1\/2\ \[ExponentialE]\^\(-t\)\ \((\(-1\) + \[ExponentialE]\^\(2\ \
t\))\)\ C[1] + 
            1\/2\ \[ExponentialE]\^\(-t\)\ \((1 + \[ExponentialE]\^\(2\ \
t\))\)\ C[2]}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.9"]
}, Open  ]],

Cell[TextData[{
  "When you ask ",
  StyleBox["DSolve", "MR"],
  " to get you a solution for ",
  StyleBox["y[x]", "MR"],
  ", the rules it returns specify how to replace ",
  StyleBox["y[x]", "MR"],
  " in any expression. However, these rules do not specify how to replace \
objects such as ",
  StyleBox["y'[x]", "MR"],
  ". If you want to manipulate solutions that you get from ",
  StyleBox["DSolve", "MR"],
  ", you will often find it better to ask for solutions for ",
  StyleBox["y", "MR"],
  ", rather than for ",
  StyleBox["y[x]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.5.9", "9.7"}],

Cell[TextData[{
  "This gives the solution for ",
  StyleBox["y", "MR"],
  " as a \[OpenCurlyDoubleQuote]pure function\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S1.5.9", "9.8"}],

Cell[CellGroupData[{

Cell["DSolve[ y'[x] == x + y[x], y, x ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.9"],

Cell[BoxData[
    \({{y \[Rule] 
          Function[{x}, \(-1\) - x + \[ExponentialE]\^x\ C[1]]}}\)], "Output",\

  CellLabel->"Out[4]= ",
  CellTags->"S1.5.9"]
}, Open  ]],

Cell[TextData[{
  "You can now use the replacement operator to apply this solution to \
expressions involving ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.9", "9.9"}],

Cell[CellGroupData[{

Cell["y''[x] + y[x] /. %", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.9"],

Cell[BoxData[
    \({\(-1\) - x + 2\ \[ExponentialE]\^x\ C[1]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.9"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["2.2.5",
    ButtonData:>{"2.2.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " explains how the \[OpenCurlyDoubleQuote]pure function\
\[CloseCurlyDoubleQuote] indicated by ",
  StyleBox["&", "MR"],
  " that appears in the result from ",
  StyleBox["DSolve", "MR"],
  " works. "
}], "Text",
  CellTags->{"S1.5.9", "9.10"}],

Cell[TextData[{
  "Note that ",
  StyleBox["DSolve", "MR"],
  " can handle combinations of algebraic and differential equations. It can \
also handle partial differential equations, in which there is more than one \
independent variable. "
}], "Text",
  CellTags->{"S1.5.9", "9.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.10 Power Series", "Subsection",
  CellTags->{"S1.5.10", "10.1"}],

Cell[TextData[{
  "The mathematical operations we have discussed so far are ",
  StyleBox["exact", "TI"],
  ". Given precise input, their results are exact formulas. "
}], "Text",
  CellTags->{"S1.5.10", "10.2"}],

Cell[TextData[{
  "In many situations, however, you do not need an exact result. It may be \
quite sufficient, for example, to find an ",
  StyleBox["approximate", "TI"],
  " formula that is valid, say, when the quantity ",
  StyleBox["x", "MR"],
  " is small.       "
}], "Text",
  CellTags->{"S1.5.10", "10.3"}],

Cell[TextData[{
  "This gives a power series approximation to ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", 
              StyleBox["x",
                "TI"]}], ")"}], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " close to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ", up to terms of order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.4"}],

Cell[CellGroupData[{

Cell["Series[(1 + x)^n, {x, 0, 3}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(n\ x\), "+", \(1\/2\ \((\(-1\) + n)\)\ n\ x\^2\), 
        "+", \(1\/6\ \((\(-2\) + n)\)\ \((\(-1\) + n)\)\ n\ x\^3\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, n, 
        Times[ 
          Rational[ 1, 2], 
          Plus[ -1, n], n], 
        Times[ 
          Rational[ 1, 6], 
          Plus[ -2, n], 
          Plus[ -1, n], n]}, 0, 4, 1],
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows the power series expansions for many mathematical functions. "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.5"}],

Cell[CellGroupData[{

Cell["Series[Exp[-a t] (1 + Sin[2 t]), {t, 0, 4}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(\((2 - a)\)\ t\), "+", \(\((\(-2\)\ a + a\^2\/2)\)\ t\^2\), 
        "+", \(\((\(-\(4\/3\)\) + a\^2 - a\^3\/6)\)\ t\^3\), 
        "+", \(\((\(4\ a\)\/3 - a\^3\/3 + a\^4\/24)\)\ t\^4\), "+", 
        InterpretationBox[\(O[t]\^5\),
          SeriesData[ t, 0, {}, 0, 5, 1],
          Editable->False]}],
      SeriesData[ t, 0, {1, 
        Plus[ 2, 
          Times[ -1, a]], 
        Plus[ 
          Times[ -2, a], 
          Times[ 
            Rational[ 1, 2], 
            Power[ a, 2]]], 
        Plus[ 
          Rational[ -4, 3], 
          Power[ a, 2], 
          Times[ 
            Rational[ -1, 6], 
            Power[ a, 3]]], 
        Plus[ 
          Times[ 
            Rational[ 4, 3], a], 
          Times[ 
            Rational[ -1, 3], 
            Power[ a, 3]], 
          Times[ 
            Rational[ 1, 24], 
            Power[ a, 4]]]}, 0, 5, 1],
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[TextData[{
  "If you give it a function that it does not know, ",
  StyleBox["Series", "MR"],
  " writes out the power series in terms of derivatives. "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.6"}],

Cell[CellGroupData[{

Cell["Series[1 + f[t], {t, 0, 3}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    TagBox[
      RowBox[{"1", "+", \(f[0]\), "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], " ", "t"}], "+", 
        RowBox[{\(1\/2\), " ", 
          RowBox[{
            SuperscriptBox["f", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], " ", \(t\^2\)}], "+",
         
        RowBox[{\(1\/6\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "0", "]"}], " ", \(t\^3\)}], 
        "+", \(O[t]\^4\)}],
      HoldForm]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[TextData[{
  "Power series are approximate formulas that play much the same role with \
respect to algebraic expressions as approximate numbers play with respect to \
numerical expressions. ",
  StyleBox["Mathematica", "TI"],
  " allows you to perform operations on power series, in all cases \
maintaining the appropriate order or \[OpenCurlyDoubleQuote]degree of \
precision\[CloseCurlyDoubleQuote] for the resulting power series. "
}], "Text",
  CellTags->{"S1.5.10", "10.7"}],

Cell[TextData[{
  "Here is a simple power series, accurate to order ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "5"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.8"}],

Cell[CellGroupData[{

Cell["Series[Exp[x], {x, 0, 5}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", \(x\^4\/24\), 
        "+", \(x\^5\/120\), "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ x, 0, {1, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24], 
        Rational[ 1, 120]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[TextData[{
  "When you do operations on a power series, the result is computed only to \
the appropriate order in ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.9"}],

Cell[CellGroupData[{

Cell["%^2 (1 + %)", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "2", "+", \(5\ x\), "+", \(\(13\ x\^2\)\/2\), "+", \(\(35\ x\^3\)\/6\), 
        "+", \(\(97\ x\^4\)\/24\), "+", \(\(55\ x\^5\)\/24\), "+", 
        InterpretationBox[\(O[x]\^6\),
          SeriesData[ x, 0, {}, 0, 6, 1],
          Editable->False]}],
      SeriesData[ x, 0, {2, 5, 
        Rational[ 13, 2], 
        Rational[ 35, 6], 
        Rational[ 97, 24], 
        Rational[ 55, 24]}, 0, 6, 1],
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell["\<\
This turns the power series back into an ordinary expression. \
\
\>", "MathCaption",
  CellTags->{"S1.5.10", "10.10"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    \(2 + 
      5\ x + \(13\ x\^2\)\/2 + \(35\ x\^3\)\/6 + \(97\ x\^4\)\/24 + \(55\ \
x\^5\)\/24\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[TextData[{
  "Now the square is computed ",
  StyleBox["exactly", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.11"}],

Cell[CellGroupData[{

Cell["%^2", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    \(\((2 + 5\ x + \(13\ x\^2\)\/2 + \(35\ x\^3\)\/6 + \(97\ x\^4\)\/24 + \
\(55\ x\^5\)\/24)\)\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[TextData[{
  "Applying ",
  StyleBox["Expand", "MR"],
  " gives a result with eleven terms. "
}], "MathCaption",
  CellTags->{"S1.5.10", "10.12"}],

Cell[CellGroupData[{

Cell["Expand[%]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.10"],

Cell[BoxData[
    \(4 + 20\ x + 
      51\ x\^2 + \(265\ x\^3\)\/3 + \(467\ x\^4\)\/4 + \(1505\ x\^5\)\/12 + \
\(7883\ x\^6\)\/72 + \(1385\ x\^7\)\/18 + \(24809\ x\^8\)\/576 + \(5335\ x\^9\
\)\/288 + \(3025\ x\^10\)\/576\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Series[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the power series expansion of ",
              StyleBox["expr", "TI"],
              " about the point ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " to at most ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " order "
            }]]},
          {Cell[TextData[{
              StyleBox["Normal[", "MR"],
              StyleBox["series", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "truncate a power series to give an ordinary expression "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.10"],

Cell["Power series operations. ", "Caption",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.11 Limits", "Subsection",
  CellTags->{"S1.5.11", "11.1"}],

Cell[TextData[{
  "Here is the expression ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.11", "11.2"}],

Cell[CellGroupData[{

Cell["t = Sin[x]/x", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.11"],

Cell[BoxData[
    \(Sin[x]\/x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.11"]
}, Open  ]],

Cell[TextData[{
  "If you replace ",
  StyleBox["x", "MR"],
  " by ",
  StyleBox["0", "MR"],
  ", the expression becomes ",
  StyleBox["0/0", "MR"],
  ", and you get an indeterminate result. "
}], "MathCaption",
  CellTags->{"S1.5.11", "11.3"}],

Cell[CellGroupData[{

Cell["t /. x->0", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.11"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellTags->"S1.5.11"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellTags->"S1.5.11"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.11"]
}, Open  ]],

Cell[TextData[{
  "If you find the numerical value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " close to ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ", however, you get a result that is close to ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.11", "11.4"}],

Cell[CellGroupData[{

Cell["t /. x->0.01", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.11"],

Cell[BoxData[
    \(0.9999833334166665`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.11"]
}, Open  ]],

Cell[TextData[{
  "This finds the ",
  StyleBox["limit", "TI"],
  " of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " as ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " approaches ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". The result is indeed ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.11", "11.5"}],

Cell[CellGroupData[{

Cell["Limit[t, x->0]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.11"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Limit[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["->", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the limit of ",
              StyleBox["expr", "TI"],
              " as ",
              StyleBox["x", "TI"],
              " approaches ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.11"],

Cell["Limits. ", "Caption",
  CellTags->"S1.5.11"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.12 Integral Transforms", "Subsection",
  CellTags->{"S1.5.12", "12.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LaplaceTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the Laplace transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseLaplaceTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the inverse Laplace transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.12"],

Cell["Laplace transforms. ", "Caption",
  CellTags->"S1.5.12"],

Cell["This computes a Laplace transform. ", "MathCaption",
  CellTags->{"S1.5.12", "12.2"}],

Cell[CellGroupData[{

Cell["LaplaceTransform[t^3 Exp[a t], t, s]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.12"],

Cell[BoxData[
    \(6\/\((a - s)\)\^4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.12"]
}, Open  ]],

Cell["Here is the inverse transform. ", "MathCaption",
  CellTags->{"S1.5.12", "12.3"}],

Cell[CellGroupData[{

Cell["InverseLaplaceTransform[%, s, t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.12"],

Cell[BoxData[
    \(\[ExponentialE]\^\(a\ t\)\ t\^3\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FourierTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["w", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the symbolic Fourier transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseFourierTransform[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["w", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["t", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the inverse Fourier transform of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.12"],

Cell["Fourier transforms. ", "Caption",
  CellTags->"S1.5.12"],

Cell["This computes a Fourier transform. ", "MathCaption",
  CellTags->{"S1.5.12", "12.4"}],

Cell[CellGroupData[{

Cell["FourierTransform[t^4 Exp[-t^2], t, w]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.12"],

Cell[BoxData[
    \(\(\[ExponentialE]\^\(-\(w\^2\/4\)\)\ \((12 - 12\ w\^2 + w\^4)\)\)\/\(16\
\ \@2\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.12"]
}, Open  ]],

Cell["Here is the inverse transform. ", "MathCaption",
  CellTags->{"S1.5.12", "12.5"}],

Cell[CellGroupData[{

Cell["InverseFourierTransform[%, w, t]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.12"],

Cell[BoxData[
    \(\[ExponentialE]\^\(-t\^2\)\ t\^4\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.12"]
}, Open  ]],

Cell[TextData[{
  "Note that in the scientific and technical literature many different \
conventions are used for defining Fourier transforms. Section ",
  ButtonBox["3.8.4",
    ButtonData:>{"3.8.4", "4.11"},
    ButtonStyle->"MainBookLink"],
  " describes the setup in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.5.12", "12.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.13 Recurrence Equations", "Subsection",
  CellTags->{"S1.5.13", "13.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RSolve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve the recurrence equations ",
              StyleBox["eqns", "TI"],
              " for ",
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.13"],

Cell["Solving recurrence equations. ", "Caption",
  CellTags->"S1.5.13"],

Cell["This solves a simple recurrence equation. ", "MathCaption",
  CellTags->{"S1.5.13", "13.2"}],

Cell[CellGroupData[{

Cell["RSolve[{a[n] == 3 a[n-1]+1, a[1]==1}, a[n], n]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.13"],

Cell[BoxData[
    \({{a[n] \[Rule] 1\/2\ \((\(-1\) + 3\^n)\)}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.14 Packages for Symbolic Mathematics", "Subsection",
  CellTags->{"S1.5.14", "14.1"}],

Cell[TextData[{
  "There are many ",
  StyleBox["Mathematica", "TI"],
  " packages which implement symbolic mathematical operations. This section \
gives a few examples drawn from the standard set of packages distributed with \
",
  StyleBox["Mathematica", "TI"],
  ". As discussed in Section ",
  ButtonBox["1.3.10",
    ButtonData:>{"1.3.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  ", some copies of ",
  StyleBox["Mathematica", "TI"],
  " may be set up so that the functions described here are automatically \
loaded into ",
  StyleBox["Mathematica", "TI"],
  " if they are ever needed. "
}], "Text",
  CellTags->{"S1.5.14", "14.2"}],

Cell[CellGroupData[{

Cell["Vector Analysis", "Subsubsection",
  CellTags->{"S1.5.14", "14.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<Calculus`VectorAnalysis`", "MR"],
              " "
            }]], Cell["load the vector analysis package "]},
          {Cell[TextData[{
              StyleBox["SetCoordinates[", "MR"],
              StyleBox["system", "TI"],
              StyleBox["[", "MR"],
              StyleBox["names", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "specify the coordinate system to be used (",
              StyleBox["Cartesian", "MR"],
              ", ",
              StyleBox["Cylindrical", "MR"],
              ", ",
              StyleBox["Spherical", "MR"],
              ", etc.), giving the names of the coordinates in that system "
            }]]},
          {Cell[TextData[{
              StyleBox["Grad[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate the gradient ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Del]", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " of ",
              StyleBox["f", "TI"],
              " in the coordinate system chosen"
            }]]},
          {Cell[TextData[{
              StyleBox["Div[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate the divergence ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Del]", "\[CenterDot]", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " of the list ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Curl[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate the curl ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Del]", "\[Cross]", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " of the list ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Laplacian[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate the Laplacian ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{\(\[Del]\^2\), 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.5.14"],

Cell["Vector analysis. ", "Caption",
  CellTags->"S1.5.14"],

Cell[TextData[{
  "This loads the vector analysis package. In some versions of ",
  StyleBox["Mathematica", "TI"],
  ", you may not need to load the package explicitly. "
}], "MathCaption",
  CellTags->{"S1.5.14", "14.4"}],

Cell["<<Calculus`VectorAnalysis`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.14"],

Cell[TextData[{
  "This specifies that a spherical coordinate system with coordinate names ",
  StyleBox["r", "MR"],
  ", ",
  StyleBox["theta", "MR"],
  " and ",
  StyleBox["phi", "MR"],
  " should be used. "
}], "MathCaption",
  CellTags->{"S1.5.14", "14.5"}],

Cell[CellGroupData[{

Cell["SetCoordinates[Spherical[r, theta, phi]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.14"],

Cell[BoxData[
    \(Spherical[r, theta, phi]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.14"]
}, Open  ]],

Cell[TextData[{
  "This evaluates the gradient of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["r",
              "TI"], "2"], "sin", \((\[Theta])\)}], TraditionalForm]], 
    "InlineFormula"],
  " in the spherical coordinate system. "
}], "MathCaption",
  CellTags->{"S1.5.14", "14.6"}],

Cell[CellGroupData[{

Cell["Grad[r^2 Sin[theta]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.14"],

Cell[BoxData[
    \({2\ r\ Sin[theta], r\ Cos[theta], 0}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variational Methods", "Subsubsection",
  CellTags->{"S1.5.14", "14.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<Calculus`VariationalMethods`", "MR"],
              " "
            }]], Cell["load the variational methods package "]},
          {Cell[TextData[{
              StyleBox["VariationalD[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find the variational derivative of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S1.5.14"],

Cell["Variational methods. ", "Caption",
  CellTags->"S1.5.14"],

Cell["This loads the variational methods package. ", "MathCaption",
  CellTags->{"S1.5.14", "14.8"}],

Cell["<<Calculus`VariationalMethods`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.14"],

Cell[TextData[{
  "This finds the functional derivative of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], 
          SqrtBox[
            RowBox[{
              SuperscriptBox[
                StyleBox["y",
                  "TI"], "\[Prime]"], 
              RowBox[{"(", 
                StyleBox["x",
                  "TI"], ")"}]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.14", "14.9"}],

Cell[CellGroupData[{

Cell["VariationalD[y[x] Sqrt[y'[x]], y[x], x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.14"],

Cell[BoxData[
    FractionBox[
      RowBox[{
        RowBox[{"2", " ", 
          SuperscriptBox[
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], "2"]}], "+", 
        RowBox[{\(y[x]\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}]}], 
      RowBox[{"4", " ", 
        SuperscriptBox[
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], \(3/
            2\)]}]]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quaternions", "Subsubsection",
  CellTags->{"S1.5.14", "14.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<Algebra`Quaternions`", "MR"],
              " "
            }]], Cell["load the quaternions package "]},
          {Cell[TextData[{
              StyleBox["Quaternion[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the quaternion ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["a",
                        "TI"], "+", 
                      StyleBox["b",
                        "TI"], 
                      StyleBox["i",
                        "TI"], "+", 
                      StyleBox["c",
                        "TI"], 
                      StyleBox["j",
                        "TI"], "+", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["k",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S1.5.14"],

Cell["Quaternions. ", "Caption",
  CellTags->"S1.5.14"],

Cell["This loads the quaternions package. ", "MathCaption",
  CellTags->{"S1.5.14", "14.11"}],

Cell["<<Algebra`Quaternions`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.14"],

Cell["This finds the principal square root of a quaternion. ", "MathCaption",
  CellTags->{"S1.5.14", "14.12"}],

Cell[CellGroupData[{

Cell["Sqrt[Quaternion[1, 1, 1, 0]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.14"],

Cell[BoxData[
    \(Quaternion[
      3\^\(1/4\)\ Cos[
          ArcTan[\@2]\/2], \(3\^\(1/4\)\ Sin[ArcTan[\@2]\/2]\)\/\@2, \
\(3\^\(1/4\)\ Sin[ArcTan[\@2]\/2]\)\/\@2, 0]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.14"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.5.15 Advanced Topic: Generic and Non\[Hyphen]Generic Cases\
\>", \
"Subsection",
  CellTags->{"S1.5.15", "15.1"}],

Cell[TextData[{
  "This gives a result for the integral of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " that is valid for almost all values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.2"}],

Cell[CellGroupData[{

Cell["Integrate[x^n, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(x\^\(1 + n\)\/\(1 + n\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell[TextData[{
  "For the special case of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], \(-1\)], TraditionalForm]], "InlineFormula"],
  ", however, the correct result is different. "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.3"}],

Cell[CellGroupData[{

Cell["Integrate[x^-1, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(Log[x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell["\<\
The overall goal of symbolic computation is typically to get \
formulas that are valid for many possible values of the variables that appear \
in them. It is however often not practical to try to get formulas that are \
valid for absolutely every possible value of each variable. \
\>", "Text",
  CellTags->{"S1.5.15", "15.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " always replaces ",
  Cell[BoxData[
      FormBox[
        RowBox[{"0", "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.5"}],

Cell[CellGroupData[{

Cell["0 / x", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell[TextData[{
  "If ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is equal to 0, however, then the true result is not 0. "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.6"}],

Cell[CellGroupData[{

Cell["0 / 0", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell["\<\
This construct treats both cases, but would be quite unwieldy to \
use. \
\>", "MathCaption",
  CellTags->{"S1.5.15", "15.7"}],

Cell[CellGroupData[{

Cell["If[x != 0, 0, Indeterminate]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(If[x \[NotEqual] 0, 0, Indeterminate]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica", "TI"],
  " did not automatically replace ",
  Cell[BoxData[
      FormBox[
        RowBox[{"0", "/", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " by 0, then few symbolic computations would get very far. But you should \
realize that the practical necessity of making such replacements can cause \
misleading results to be obtained when exceptional values of parameters are \
used. "
}], "Text",
  CellTags->{"S1.5.15", "15.8"}],

Cell[TextData[{
  "The basic operations of ",
  StyleBox["Mathematica", "TI"],
  " are nevertheless carefully set up so that whenever possible the results \
obtained will be valid for almost all values of each variable. "
}], "Text",
  CellTags->{"S1.5.15", "15.9"}],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        SqrtBox[
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]], TraditionalForm]], "InlineFormula"],
  " is not automatically replaced by ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.10"}],

Cell[CellGroupData[{

Cell["Sqrt[x^2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(\@x\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell[TextData[{
  "If it were, then the result here would be ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\)], "InlineFormula"],
  ", which is incorrect. "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.11"}],

Cell[CellGroupData[{

Cell["% /. x -> -2", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.5.15"]
}, Open  ]],

Cell[TextData[{
  "This makes the assumption that ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a positive real variable, and does the replacement. "
}], "MathCaption",
  CellTags->{"S1.5.15", "15.12"}],

Cell[CellGroupData[{

Cell["Simplify[Sqrt[x^2], x > 0]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.5.15"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.5.15"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.5.16 Mathematical Notation in Notebooks", "Subsection",
  CellTags->{"S1.5.16", "16.1"}],

Cell[TextData[{
  "If you use the notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then you can enter some of the operations discussed in this section in \
special ways. "
}], "Text",
  CellTags->{"S1.5.16", "16.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "=", 
                        StyleBox[\(i\_min\),
                          "TI"]}], 
                      StyleBox[\(i\_max\),
                        "TI"]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["sum "]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    UnderoverscriptBox["\[Product]", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "=", 
                        StyleBox[\(i\_min\),
                          "TI"]}], 
                      StyleBox[\(i\_max\),
                        "TI"]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Product[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["product "]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{"\[Integral]", 
                    RowBox[{
                      StyleBox["f",
                        "TI"], " ", 
                      RowBox[{"\[DifferentialD]", 
                        StyleBox["x",
                          "TI"]}]}]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["indefinite integral "]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubsuperscriptBox["\[Integral]", 
                      StyleBox[\(x\_min\),
                        "TI"], 
                      StyleBox[\(x\_max\),
                        "TI"]], 
                    RowBox[{
                      StyleBox["f",
                        "TI"], " ", 
                      RowBox[{"\[DifferentialD]", 
                        StyleBox["x",
                          "TI"]}]}]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["definite integral "]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[PartialD]", 
                      StyleBox["x",
                        "TI"]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["partial derivative "]},
          {Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[PartialD]", 
                      RowBox[{
                        StyleBox["x",
                          "TI"], ",", 
                        StyleBox["y",
                          "TI"]}]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["multivariate partial derivative "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.5.16"],

Cell["\<\
Special and ordinary ways to enter mathematical operations in \
notebooks. \
\>", "Caption",
  CellTags->"S1.5.16"],

Cell["\<\
This shows part of the standard palette for entering mathematical \
operations. When you press a button in the palette, the form shown in the \
button is inserted into your notebook, with the black square replaced by \
whatever you had selected in the notebook.\
\>", "MathCaption",
  CellTags->{"S1.5.16", "16.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001S0000UB000`400?l00000o`00003oH`3oool0
0680<c<c0@3oool000030>k^kP0c<c<0<c<c05l0<c<c0@3oool000030>k^kP2IVIT0VIVI05d0VIVI
0P0c<c<10?ooo`0000<0k^k^09VIV@2IVIT0G@2IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@1M
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIVET0k^k^0`2IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<eD000000P3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c:`1EEED20?ooobL0EEEE00<000000>k^kP3^k^h00`2IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^
k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?oo
o`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI
0P0c<c<Z0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED0
00000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1E
EED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<?0=gMg@D000000P3MgMd5000000l0gMgM00<0EEEE0?ooo`3oool09P3MgMd0
101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c2@3M
gMd00`000000gMgM0=gMg@030=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@000000gMgM
0=gMg@3MgMd0000000D0gMgM00<000000=gMg@3MgMd01`3MgMd00`1EEED0oooo0?ooo`0V0=gMg@04
05EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<80=gM
g@030000003MgMd0gMgM00@0gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@050000003MgMd0
gMgM0=gMg@0000001P3MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3oool0oooo02H0gMgM00@0
EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`P0gMgM
00<000000=gMg@3MgMd0103MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D000000=gMg@3M
gMd0gMgM000000060=gMg@030000003MgMd0gMgM00H0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101E
EED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c1`3MgMd0
0`000000gMgM0=gMg@050=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@000000gMgM0=gM
g@3MgMd0000000L0gMgM00<000000=gMg@3MgMd01@3MgMd00`1EEED0oooo0?ooo`0?0=gMg@@00000
1`3MgMd4000000P0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI
09VIV@2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd01@3MgMd500000080gMgM1@0000070=gMg@03
0000003MgMd0gMgM00D0gMgM00<0EEEE0?ooo`3oool03`3MgMd00`000000gMgM000000090=gMg@03
0000003MgMd0000000P0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd0603MgMd00`000000gMgM0=gMg@050=gM
g@0305EEE@3oool0oooo00H0gMgM1@0000040=gMg@030000003MgMd000000080gMgM1@0000020=gM
g@030000003MgMd0000000P0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd0603MgMd00`000000gMgM0=gMg@05
0=gMg@0305EEE@3oool0oooo00H0gMgM1@0000040=gMg@030000003MgMd000000080gMgM00D00000
0=gMg@3MgMd0gMgM000000020=gMg@030000003MgMd0000000P0gMgM00@0EEEE0000003^k^h0k^k^
0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd0
603MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3oool0oooo00H0gMgM1@0000040=gMg@030000
003MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM000000020=gMg@030000003MgMd0000000P0
gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<`L0gMgM00<000000=gMg@3MgMd0603MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3oool0oooo
00H0gMgM1@0000040=gMg@030000003MgMd000000080gMgM00D000000=gMg@3MgMd0gMgM00000002
0=gMg@030000003MgMd0000000P0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd0603MgMd00`000000gMgM0=gM
g@050=gMg@0305EEE@3oool0oooo00H0gMgM1@0000040=gMg@030000003MgMd000000080gMgM00D0
00000=gMg@3MgMd0gMgM000000020=gMg@030000003MgMd0000000P0gMgM00@0EEEE0000003^k^h0
k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM00<000000=gMg@3M
gMd01@3MgMd500000080gMgM1@0000070=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE0?ooo`3o
ool01P3MgMd5000000@0gMgM00<000000=gMg@0000000P3MgMd500000080gMgM00<000000=gMg@00
0000203MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c1`3MgMd00`000000gMgM0=gMg@050=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd0
1@000000gMgM0=gMg@3MgMd0000000L0gMgM00<000000=gMg@3MgMd01@3MgMd00`1EEED0oooo0?oo
o`0?0=gMg@030000003MgMd0000000T0gMgM00<000000=gMg@000000203MgMd0101EEED000000>k^
kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c1`3MgMd00`000000gMgM
0=gMg@050=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@000000gMgM0=gMg@3MgMd00000
00L0gMgM00<000000=gMg@3MgMd01@3MgMd00`1EEED0oooo0?ooo`0?0=gMg@@000001`3MgMd40000
00P0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<`P0gMgM00<000000=gMg@3MgMd0103MgMd01@000000gMgM0=gMg@3MgMd000000080gMgM00D0
00000=gMg@3MgMd0gMgM000000060=gMg@030000003MgMd0gMgM00H0gMgM00<0EEEE0?ooo`3oool0
9P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c203MgMd00`000000gMgM0=gMg@040=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd01@00
0000gMgM0=gMg@3MgMd0000000H0gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0oooo0?ooo`0V
0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c
<c<90=gMg@030000003MgMd0gMgM00<0gMgM1@0000020=gMg@D000001@3MgMd00`000000gMgM0=gM
g@070=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo
0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED00000
0>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0
oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2I
VIT0VIVI0P0c<c<Z0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0
101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03o
ool00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03o
ool00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:`1E
EED20?ooobL0EEEE00<000000>k^kP3^k^h00`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EE
E@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<>0=gMg@@0
000000<0gMgM0000000000000P0000000`3MgMd0000000000002000000h0gMgM00<0EEEE0?ooo`3o
ool0303MgMd4000000030=gMg@00000000000080000000<0gMgM0000000000000P00000<0=gMg@04
05EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<40=gM
g@P000000P3MgMd010000000gMgM0=gMg@0000060=gMg@040000003MgMd0gMgM000000h0gMgM00<0
EEEE0?ooo`3oool00`3MgMd300000080gMgM0`0000001@3MgMd000000=gMg@3MgMd0000000H0gMgM
00@000000=gMg@3MgMd00000303MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@030=gMg@040000003MgMd0gMgM
00000080gMgM00<000000=gMg@0000000`0000001@3MgMd000000=gMg@3MgMd0000000h0gMgM00<0
EEEE0?ooo`3oool0103MgMd00`000000gMgM0=gMg@020=gMg@040000003MgMd0gMgM00000080gMgM
00<000000=gMg@0000000`0000001@3MgMd000000=gMg@3MgMd0000000`0gMgM00@0EEEE0000003^
k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM00<000000=gM
g@3MgMd01@3MgMd4000000H0gMgM1000000>0=gMg@0305EEE@3oool0oooo00@0gMgM00<000000=gM
g@3MgMd00P3MgMd00`000000gMgM0=gMg@04000000H0gMgM1000000<0=gMg@0405EEE@000000k^k^
0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<70=gMg@030000003MgMd0
gMgM01H0gMgM1@0000050=gMg@0305EEE@3oool0oooo00@0gMgM00<000000=gMg@3MgMd00P3MgMd0
0`000000gMgM0=gMg@0C0=gMg@D000000P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c203MgMd00`000000gMgM0=gMg@0E0=gMg@D000001@3M
gMd00`1EEED0oooo0?ooo`040=gMg@030000003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd04`3M
gMd500000080gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VI
V@2IVIT203<c<`T0gMgM00<000000=gMg@3MgMd0503MgMd5000000D0gMgM00<0EEEE0?ooo`3oool0
103MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM01<0gMgM1@0000020=gMg@0405EE
E@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<80=gMg@03
0000003MgMd0gMgM01D0gMgM1@0000050=gMg@0305EEE@3oool0oooo00@0gMgM00<000000=gMg@3M
gMd00P3MgMd00`000000gMgM0=gMg@0C0=gMg@D000000P3MgMd0101EEED000000>k^kP3^k^h309VI
V@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c1`3MgMd00`000000gMgM0=gMg@040=gM
g@@000003P3MgMd5000000D0gMgM00<0EEEE0?ooo`3oool0103MgMd00`000000gMgM0=gMg@020=gM
g@030000003MgMd0gMgM00@000003`3MgMd500000080gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT2
03<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd00P3MgMd0
10000000gMgM0=gMg@0000020=gMg@030000003MgMd0gMgM00`0gMgM1@0000050=gMg@0305EEE@3o
ool0oooo00@0gMgM00<000000=gMg@3MgMd00P3MgMd010000000gMgM0=gMg@0000020=gMg@030000
003MgMd0gMgM00d0gMgM1@0000020=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`00
00@0k^k^09VIV@2IVIT0VIVI0P0c<c<50=gMg@L000000P3MgMd010000000gMgM0=gMg@00000H0=gM
g@0305EEE@3oool0oooo00<0gMgM200000001@3MgMd000000=gMg@3MgMd0000001H0gMgM00@0EEEE
0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`h0gMgM1000
000H0=gMg@0305EEE@3oool0oooo00`0gMgM1000000F0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI
0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z0=gMg@0305EEE@3oool0oooo02H0gMgM
00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0
gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c:`1EEED20?ooobL0EEEE00<000000>k^kP3^k^h00`2IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101E
EED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd0
0`1EEED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<70=gMg@@000007`3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@00
0000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<30=gMg@800000
0P3MgMd010000000gMgM0=gMg@00000O0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^
k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`80gMgM00H000000=gM
g@3MgMd000000=gMg@0000020=gMg@030000003MgMd0gMgM01d0gMgM00<0EEEE0?ooo`3oool04@3M
gMd00`000000gMgM0=gMg@0B0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0
k^k^09VIV@2IVIT0VIVI0P0c<c<50=gMg@030000003MgMd0000000<000007`3MgMd00`1EEED0oooo
0?ooo`0B0=gMg@030000003MgMd0gMgM0140gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`D0gMgM00<000000=gMg@3MgMd08P3MgMd00`1EEED0
oooo0?ooo`0<0=gMg@@000000P3MgMd010000000gMgM0=gMg@3MgMd4000000`0gMgM00@0EEEE0000
003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`D0gMgM00<00000
0=gMg@3MgMd08P3MgMd00`1EEED0oooo0?ooo`0<0=gMg@040000003MgMd0gMgM000000H0gMgM00@0
00000=gMg@3MgMd00000303MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@080=gMg@D000001@3MgMd600000080
gMgM1@0000030=gMg@0305EEE@3oool0oooo00H0gMgM0`0000030=gMg@040000003MgMd0gMgM0000
00H0gMgM00@000000=gMg@3MgMd000000`3MgMd5000000@0gMgM00@0EEEE0000003^k^h0k^k^0`2I
VIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`D0gMgM00<000000=gMg@3MgMd0203M
gMd5000000@0gMgM00H000000=gMg@3MgMd000000=gMg@0000030=gMg@050000003MgMd0gMgM0=gM
g@0000000`3MgMd00`1EEED0oooo0?ooo`050=gMg@050000003MgMd0gMgM0=gMg@0000000P3MgMd4
000000H0gMgM100000030=gMg@D00000103MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@080=gMg@D00000103M
gMd01P000000gMgM0=gMg@000000gMgM000000<0gMgM00D000000=gMg@3MgMd0gMgM000000030=gM
g@0305EEE@3oool0oooo00D0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@0@0=gM
g@D00000103MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@080=gMg@D00000103MgMd01P000000gMgM0=gMg@00
0000gMgM000000<0gMgM00D000000=gMg@3MgMd0gMgM000000030=gMg@0305EEE@3oool0oooo00D0
gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@0@0=gMg@D00000103MgMd0101EEED0
00000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c1@3MgMd00`00
0000gMgM0=gMg@080=gMg@D00000103MgMd01P000000gMgM0=gMg@000000gMgM000000<0gMgM00D0
00000=gMg@3MgMd0gMgM000000030=gMg@0305EEE@3oool0oooo00H0gMgM00D000000=gMg@3MgMd0
gMgM0000000B0=gMg@D00000103MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@080=gMg@D000001@3MgMd30000
00030=gMg@000000gMgM0080gMgM1@0000030=gMg@0305EEE@3oool0oooo00L0gMgM1000000B0=gM
g@D00000103MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@020=gMg@@000003P3MgMd00`000000gMgM0000000;
0=gMg@0305EEE@3oool0oooo00X0gMgM00<000000=gMg@3MgMd06@3MgMd0101EEED000000>k^kP3^
k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c1@3MgMd00`000000gMgM0=gM
g@020=gMg@040000003MgMd0gMgM000000d0gMgM1000000;0=gMg@0305EEE@3oool0oooo00H0gMgM
1000000L0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<50=gMg@060000003MgMd0gMgM0000003MgMd000000P3MgMd00`000000gMgM0=gMg@0J
0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM0P0000020=gMg@@00000703MgMd00`1EEED0oooo0?oo
o`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI
0P0c<c<Z0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED0
00000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`00
0000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:`1EEED20?oo
obL0EEEE00<000000>k^kP3^k^h00`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@000000
k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<60=gMg@8000008P3M
gMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0
k^k^09VIV@2IVIT0VIVI0P0c<c<50=gMg@040000003MgMd0gMgM00000240gMgM00<0EEEE0?ooo`3o
ool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c203MgMd00`000000gMgM0=gMg@0O0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000
003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`P0gMgM00<00000
0=gMg@3MgMd07`3MgMd00`1EEED0oooo0?ooo`0A0=gMg@@000004@3MgMd0101EEED000000>k^kP3^
k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c203MgMd00`000000gMgM0=gM
g@0O0=gMg@0305EEE@3oool0oooo0140gMgM00@000000=gMg@3MgMd000004@3MgMd0101EEED00000
0>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c203MgMd00`000000
gMgM0=gMg@020=gMg@D000001@3MgMd600000080gMgM1@0000060=gMg@0305EEE@3oool0oooo00/0
gMgM0`0000030=gMg@040000003MgMd0gMgM000000<0gMgM1@0000090=gMg@0405EEE@000000k^k^
0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<80=gMg@030000003MgMd0
gMgM0080gMgM1@0000040=gMg@060000003MgMd0gMgM0000003MgMd000000`3MgMd01@000000gMgM
0=gMg@3MgMd0000000H0gMgM00<0EEEE0?ooo`3oool02P3MgMd01@000000gMgM0=gMg@3MgMd00000
0080gMgM100000030=gMg@D000002@3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c203MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd0
1P000000gMgM0=gMg@000000gMgM000000<0gMgM00D000000=gMg@3MgMd0gMgM000000060=gMg@03
05EEE@3oool0oooo00X0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@060=gMg@D0
00002@3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c203MgMd00`000000gMgM0=gMg@020=gMg@D00000103MgMd01P000000gMgM0=gMg@000000
gMgM000000<0gMgM00D000000=gMg@3MgMd0gMgM000000060=gMg@0305EEE@3oool0oooo00X0gMgM
00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@060=gMg@D000002@3MgMd0101EEED00000
0>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c203MgMd00`000000
gMgM0=gMg@020=gMg@D00000103MgMd01P000000gMgM0=gMg@000000gMgM000000<0gMgM00D00000
0=gMg@3MgMd0gMgM000000060=gMg@0305EEE@3oool0oooo00/0gMgM00D000000=gMg@3MgMd0gMgM
000000080=gMg@D000002@3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c203MgMd00`000000gMgM0=gMg@020=gMg@D000001@3MgMd300000003
0=gMg@000000gMgM0080gMgM1@0000060=gMg@0305EEE@3oool0oooo00`0gMgM100000080=gMg@D0
00002@3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c203MgMd00`000000gMgM0=gMg@0>0=gMg@030000003MgMd0000000h0gMgM00<0EEEE0?oo
o`3oool03`3MgMd00`000000gMgM0=gMg@0D0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<1
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<80=gMg@030000003MgMd0gMgM00d0gMgM1000000>
0=gMg@0305EEE@3oool0oooo00/0gMgM1000000G0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c
<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<80=gMg@040000003MgMd0gMgM000001h0gMgM
00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c2@3MgMd2000001l0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED0
00000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1E
EED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<Z0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2I
VIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<e@0oooo00<000000>k^kP3^k^h00`2I
VIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<e@0oooo00<000000>k^kP3^k^h00`2I
VIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<b/0EEEE0P3ooolW05EEE@030000003^
k^h0k^k^00<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z0=gMg@0305EEE@3o
ool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VI
V@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80
<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@04
05EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<?0=gM
g@030000003MgMd0gMgM01P0gMgM00<0EEEE0?ooo`3oool03@3MgMd00`000000gMgM0=gMg@0F0=gM
g@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<?
0=gMg@030000003MgMd0gMgM01P0gMgM00<0EEEE0?ooo`3oool03@3MgMd00`000000gMgM0=gMg@0F
0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c
<c<>0=gMg@8000001`3MgMd5000000h0gMgM00<0EEEE0?ooo`3oool0303MgMd2000000L0gMgM1@00
000<0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI
0P0c<c<>0=gMg@030000003MgMd0000000H0gMgM1@00000>0=gMg@0305EEE@3oool0oooo00`0gMgM
00<000000=gMg@0000001P3MgMd5000000`0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40
oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`d0gMgM00@000000=gMg@3MgMd000001P3MgMd50000
00h0gMgM00<0EEEE0?ooo`3oool02`3MgMd010000000gMgM0=gMg@0000060=gMg@D00000303MgMd0
101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c2`3M
gMd00`000000gMgM000000020=gMg@030000003MgMd0gMgM00@0gMgM1@00000>0=gMg@0305EEE@3o
ool0oooo00T0gMgM00<000000=gMg@0000000P3MgMd00`000000gMgM0=gMg@040=gMg@D00000303M
gMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c
303MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM1@00000>0=gMg@0305EE
E@3oool0oooo00X0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@030=gMg@D00000
303MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c4@3MgMd00`000000gMgM0=gMg@030=gMg@D000003P3MgMd00`1EEED0oooo0?ooo`0?0=gMg@03
0000003MgMd0gMgM00<0gMgM1@00000<0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?oo
o`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@030000003MgMd0gMgM01H0gMgM00<0EEEE0?oo
o`3oool03`3MgMd00`000000gMgM0=gMg@0D0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<1
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@030000003MgMd0gMgM01H0gMgM00<0EEEE
0?ooo`3oool0303MgMd4000001H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<a80gMgM00<000000=gMg@3MgMd05@3MgMd00`1EEED0oooo0?oo
o`0<0=gMg@030000003MgMd0gMgM008000005@3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4P3MgMd00`000000gMgM0=gMg@0E0=gMg@0305EE
E@3oool0oooo00`0gMgM00<000000=gMg@3MgMd00P00000E0=gMg@0405EEE@000000k^k^0>k^kP<0
VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<B0=gMg@`00000303MgMd00`1EEED0
oooo0?ooo`0<0=gMgA0000002P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^
0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z0=gMg@0305EEE@3oool0
oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`000000k^k^0>k^kP0309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`000000k^k^0>k^kP0309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:`1EEED20?ooobL0EEEE00<000000>k^kP3^k^h0
0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool0
9P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?oo
o`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z0=gMg@0305EEE@3oool0oooo0180gMgM1000000@0=gM
g@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z
0=gMg@0305EEE@3oool0oooo0180gMgM00@000000=gMg@3MgMd00000403MgMd0101EEED000000>k^
kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo
0?ooo`0B0=gMg@040000003MgMd0gMgM00000100gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<bX0gMgM00<0EEEE0?ooo`3oool04P3MgMd40000
0100gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<bX0gMgM00<0EEEE0?ooo`3oool09P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@00
0000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z0=gMg@0305EE
E@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI
09VIV@2IVIT203<c<`l0gMgM1@00000F0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^
k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`l0gMgM1@00000F0=gM
g@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`l0gMgM1@00000F0=gMg@0305EEE@3oool0oooo00l0gMgM2000000?
0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c
<c<?0=gMg@D000005P3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI
0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<?0=gMg@D000005P3MgMd00`1EEED0oooo
0?ooo`0V0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0
VIVI0P0c<c<?0=gMg@D000000P3MgMd400000100gMgM00<0EEEE0?ooo`3oool04P3MgMd400000100
gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<aH0gMgM00@000000=gMg@3MgMd00000403MgMd00`1EEED0oooo0?ooo`0B0=gMg@@00000403MgMd0
101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c5P3M
gMd010000000gMgM0=gMg@00000@0=gMg@0305EEE@3oool0oooo0180gMgM1000000@0=gMg@0405EE
E@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<F0=gMg@@0
0000403MgMd00`1EEED0oooo0?ooo`0B0=gMg@@00000403MgMd0101EEED000000>k^kP3^k^h309VI
V@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c:P3MgMd00`1EEED0oooo0?ooo`0V0=gM
g@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<Z
0=gMg@0305EEE@3oool0oooo02H0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000
103^k^h0VIVI09VIV@2IVIUG03<c<`80k^k^0`2IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@1M
09VIV@80<c<c0@3oool000030>k^kP2IVIT0VIVI05d0VIVI0P0c<c<10?ooo`0000<0k^k^09VIV@2I
VIT0G@2IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@1M09VIV@80<c<c0@3oool00640k^k^0@0c
<c<10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{99, 149},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.5.16"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["sum\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "summation sign ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["prod\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "product sign ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Product]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["int\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "integral sign ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["dd\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "special differential ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " for use in integrals "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["pd\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "partial derivative ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PartialD]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["_\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["-\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
move to the subscript position or lower limit of an \
integral \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["^\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["6\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
move to the superscript position or upper limit of an \
integral \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["+\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["=\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
move to the underscript position or lower limit of a \
sum or product \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["7\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
move to the overscript position or upper limit of a sum \
or product \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["%\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["5\[RightModified]", "MR"],
              " "
            }]], Cell["switch between upper and lower positions "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] (Control\[Hyphen]Space) "
            }]], Cell["return from upper or lower positions "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, False, False, False, True, False, False, False, True, False}},
  CellTags->"S1.5.16"],

Cell["\<\
Ways to enter special notations on a standard \
English\[Hyphen]language keyboard. \
\>", "Caption",
  CellTags->"S1.5.16"],

Cell[TextData[{
  "You can enter an integral like this. Be sure to use the special \
differential ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " entered as \[EscapeKey]",
  StyleBox["dd\[EscapeKey]", "MR"],
  ", not just an ordinary\[NonBreakingSpace]",
  StyleBox["d", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.5.16", "16.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]x\^n\ \[DifferentialD]x\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.5.16"],

Cell[BoxData[
    \(x\^\(1 + n\)\/\(1 + n\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.5.16"]
}, Open  ]],

Cell["Here is the actual key sequence you type to get the input. ", \
"MathCaption",
  CellTags->{"S1.5.16", "16.5"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[EscapeKey]",
  StyleBox["int\[EscapeKey]", "MR"],
  "x\[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  "n\[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] \[EscapeKey]",
  StyleBox["dd\[EscapeKey]", "MR"],
  "x"
}], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.5.16"],

Cell[BoxData[
    \(x\^\(1 + n\)\/\(1 + n\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.5.16"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.5.0"->{
    Cell[1776, 53, 123, 4, 65, "Section",
      CellTags->{"S1.5.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 123, 4, 65, "Section",
      CellTags->{"S1.5.0", "0.1"}]},
  "S1.5.1"->{
    Cell[1924, 61, 75, 1, 70, "Subsection",
      CellTags->{"S1.5.1", "1.1"}],
    Cell[2002, 64, 217, 5, 70, "Text",
      CellTags->{"S1.5.1", "1.2"}],
    Cell[2222, 71, 246, 7, 70, "Text",
      CellTags->{"S1.5.1", "1.3"}],
    Cell[2471, 80, 287, 11, 70, "MathCaption",
      CellTags->{"S1.5.1", "1.4"}],
    Cell[2783, 95, 75, 2, 70, "Input",
      CellTags->"S1.5.1"],
    Cell[2861, 99, 101, 3, 70, "Output",
      CellTags->"S1.5.1"],
    Cell[2977, 105, 99, 1, 70, "MathCaption",
      CellTags->{"S1.5.1", "1.5"}],
    Cell[3101, 110, 84, 2, 70, "Input",
      CellTags->"S1.5.1"],
    Cell[3188, 114, 115, 3, 70, "Output",
      CellTags->"S1.5.1"],
    Cell[3318, 120, 7078, 205, 70, "DefinitionBox",
      CellTags->"S1.5.1"],
    Cell[10399, 327, 80, 1, 70, "Caption",
      CellTags->"S1.5.1"],
    Cell[10482, 330, 640, 13, 70, "Text",
      CellTags->{"S1.5.1", "1.6"}]},
  "1.1"->{
    Cell[1924, 61, 75, 1, 70, "Subsection",
      CellTags->{"S1.5.1", "1.1"}]},
  "1.2"->{
    Cell[2002, 64, 217, 5, 70, "Text",
      CellTags->{"S1.5.1", "1.2"}]},
  "1.3"->{
    Cell[2222, 71, 246, 7, 70, "Text",
      CellTags->{"S1.5.1", "1.3"}]},
  "1.4"->{
    Cell[2471, 80, 287, 11, 70, "MathCaption",
      CellTags->{"S1.5.1", "1.4"}]},
  "1.5"->{
    Cell[2977, 105, 99, 1, 70, "MathCaption",
      CellTags->{"S1.5.1", "1.5"}]},
  "1.6"->{
    Cell[10482, 330, 640, 13, 70, "Text",
      CellTags->{"S1.5.1", "1.6"}]},
  "S1.5.2"->{
    Cell[11159, 348, 74, 1, 70, "Subsection",
      CellTags->{"S1.5.2", "2.1"}],
    Cell[11236, 351, 414, 16, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.2"}],
    Cell[11675, 371, 75, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[11753, 375, 101, 3, 70, "Output",
      CellTags->"S1.5.2"],
    Cell[11869, 381, 170, 4, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.3"}],
    Cell[12064, 389, 81, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[12148, 393, 96, 3, 70, "Output",
      CellTags->"S1.5.2"],
    Cell[12259, 399, 149, 5, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.4"}],
    Cell[12433, 408, 80, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[12516, 412, 137, 3, 70, "Output",
      CellTags->"S1.5.2"],
    Cell[12668, 418, 1418, 55, 70, "Text",
      CellTags->{"S1.5.2", "2.5"}],
    Cell[14089, 475, 514, 22, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.6"}],
    Cell[14628, 501, 76, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[14707, 505, 116, 3, 70, "Output",
      CellTags->"S1.5.2"],
    Cell[14838, 511, 580, 22, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.7"}],
    Cell[15443, 537, 73, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[15519, 541, 124, 3, 70, "Output",
      CellTags->"S1.5.2"],
    Cell[15658, 547, 4696, 135, 70, "DefinitionBox",
      CellTags->"S1.5.2"],
    Cell[20357, 684, 73, 1, 70, "Caption",
      CellTags->"S1.5.2"],
    Cell[20433, 687, 493, 15, 70, "Text",
      CellTags->{"S1.5.2", "2.8"}],
    Cell[20929, 704, 253, 8, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.9"}],
    Cell[21207, 716, 76, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[21286, 720, 173, 5, 70, "Output",
      CellTags->"S1.5.2"],
    Cell[21474, 728, 150, 4, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.10"}],
    Cell[21649, 736, 82, 2, 70, "Input",
      CellTags->"S1.5.2"],
    Cell[21734, 740, 268, 7, 70, "Output",
      CellTags->"S1.5.2"]},
  "2.1"->{
    Cell[11159, 348, 74, 1, 70, "Subsection",
      CellTags->{"S1.5.2", "2.1"}]},
  "2.2"->{
    Cell[11236, 351, 414, 16, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.2"}]},
  "2.3"->{
    Cell[11869, 381, 170, 4, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.3"}]},
  "2.4"->{
    Cell[12259, 399, 149, 5, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.4"}]},
  "2.5"->{
    Cell[12668, 418, 1418, 55, 70, "Text",
      CellTags->{"S1.5.2", "2.5"}]},
  "2.6"->{
    Cell[14089, 475, 514, 22, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.6"}]},
  "2.7"->{
    Cell[14838, 511, 580, 22, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.7"}]},
  "2.8"->{
    Cell[20433, 687, 493, 15, 70, "Text",
      CellTags->{"S1.5.2", "2.8"}]},
  "2.9"->{
    Cell[20929, 704, 253, 8, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.9"}]},
  "2.10"->{
    Cell[21474, 728, 150, 4, 70, "MathCaption",
      CellTags->{"S1.5.2", "2.10"}]},
  "S1.5.3"->{
    Cell[22051, 753, 70, 1, 70, "Subsection",
      CellTags->{"S1.5.3", "3.1"}],
    Cell[22124, 756, 459, 18, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.2"}],
    Cell[22608, 778, 81, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[22692, 782, 104, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[22811, 788, 99, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.3"}],
    Cell[22935, 793, 91, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[23029, 797, 174, 4, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[23218, 804, 444, 8, 70, "Text",
      CellTags->{"S1.5.3", "3.4"}],
    Cell[23665, 814, 97, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.5"}],
    Cell[23787, 819, 91, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[23881, 823, 142, 4, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[24038, 830, 131, 4, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.6"}],
    Cell[24194, 838, 92, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[24289, 842, 112, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[24416, 848, 126, 5, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.7"}],
    Cell[24567, 857, 90, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[24660, 861, 119, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[24794, 867, 96, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.8"}],
    Cell[24915, 872, 86, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[25004, 876, 124, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[25143, 882, 109, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.9"}],
    Cell[25277, 887, 89, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[25369, 891, 127, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[25511, 897, 230, 6, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.10"}],
    Cell[25766, 907, 83, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[25852, 911, 118, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[25985, 917, 6788, 194, 70, "DefinitionBox",
      CellTags->"S1.5.3"],
    Cell[32776, 1113, 54, 1, 70, "Caption",
      CellTags->"S1.5.3"],
    Cell[32833, 1116, 520, 19, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.11"}],
    Cell[33378, 1139, 95, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[33476, 1143, 137, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[33628, 1149, 90, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.12"}],
    Cell[33743, 1154, 103, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[33849, 1158, 92, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[33956, 1164, 159, 4, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.13"}],
    Cell[34140, 1172, 92, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[34235, 1176, 126, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[34376, 1182, 101, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.14"}],
    Cell[34502, 1187, 71, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[34576, 1191, 100, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[34691, 1197, 815, 27, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.15"}],
    Cell[35531, 1228, 109, 2, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[35643, 1232, 86, 3, 70, "Output",
      CellTags->"S1.5.3"],
    Cell[35744, 1238, 260, 9, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.16"}],
    Cell[36029, 1251, 137, 5, 70, "Input",
      CellTags->"S1.5.3"],
    Cell[36169, 1258, 100, 3, 70, "Output",
      CellTags->"S1.5.3"]},
  "3.1"->{
    Cell[22051, 753, 70, 1, 70, "Subsection",
      CellTags->{"S1.5.3", "3.1"}]},
  "3.2"->{
    Cell[22124, 756, 459, 18, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.2"}]},
  "3.3"->{
    Cell[22811, 788, 99, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.3"}]},
  "3.4"->{
    Cell[23218, 804, 444, 8, 70, "Text",
      CellTags->{"S1.5.3", "3.4"}]},
  "3.5"->{
    Cell[23665, 814, 97, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.5"}]},
  "3.6"->{
    Cell[24038, 830, 131, 4, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.6"}]},
  "3.7"->{
    Cell[24416, 848, 126, 5, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.7"}]},
  "3.8"->{
    Cell[24794, 867, 96, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.8"}]},
  "3.9"->{
    Cell[25143, 882, 109, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.9"}]},
  "3.10"->{
    Cell[25511, 897, 230, 6, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.10"}]},
  "3.11"->{
    Cell[32833, 1116, 520, 19, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.11"}]},
  "3.12"->{
    Cell[33628, 1149, 90, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.12"}]},
  "3.13"->{
    Cell[33956, 1164, 159, 4, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.13"}]},
  "3.14"->{
    Cell[34376, 1182, 101, 1, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.14"}]},
  "3.15"->{
    Cell[34691, 1197, 815, 27, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.15"}]},
  "3.16"->{
    Cell[35744, 1238, 260, 9, 70, "MathCaption",
      CellTags->{"S1.5.3", "3.16"}]},
  "S1.5.4"->{
    Cell[36318, 1267, 76, 1, 70, "Subsection",
      CellTags->{"S1.5.4", "4.1"}],
    Cell[36397, 1270, 561, 20, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.2"}],
    Cell[36983, 1294, 85, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[37071, 1298, 149, 4, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[37235, 1305, 153, 5, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.3"}],
    Cell[37413, 1314, 82, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[37498, 1318, 149, 4, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[37662, 1325, 344, 11, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.4"}],
    Cell[38031, 1340, 88, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[38122, 1344, 102, 3, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[38239, 1350, 84, 1, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.5"}],
    Cell[38348, 1355, 89, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[38440, 1359, 131, 3, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[38586, 1365, 8269, 233, 70, "DefinitionBox",
      CellTags->"S1.5.4"],
    Cell[46858, 1600, 60, 1, 70, "Caption",
      CellTags->"S1.5.4"],
    Cell[46921, 1603, 236, 8, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.6"}],
    Cell[47182, 1615, 83, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[47268, 1619, 117, 3, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[47400, 1625, 159, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.7"}],
    Cell[47584, 1633, 92, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[47679, 1637, 93, 3, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[47787, 1643, 129, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.8"}],
    Cell[47941, 1651, 100, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[48044, 1655, 149, 4, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[48208, 1662, 140, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.9"}],
    Cell[48373, 1670, 101, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[48477, 1674, 145, 4, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[48637, 1681, 132, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.10"}],
    Cell[48794, 1689, 68, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[48865, 1693, 101, 3, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[48981, 1699, 2593, 98, 70, "Text",
      CellTags->{"S1.5.4", "4.11"}],
    Cell[51577, 1799, 934, 31, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.12"}],
    Cell[52536, 1834, 99, 2, 70, "Input",
      CellTags->"S1.5.4"],
    Cell[52638, 1838, 152, 4, 70, "Output",
      CellTags->"S1.5.4"],
    Cell[52805, 1845, 710, 24, 70, "Text",
      CellTags->{"S1.5.4", "4.13"}],
    Cell[53518, 1871, 8096, 237, 70, "DefinitionBox",
      CellTags->"S1.5.4"],
    Cell[61617, 2110, 110, 4, 70, "Caption",
      CellTags->"S1.5.4"]},
  "4.1"->{
    Cell[36318, 1267, 76, 1, 70, "Subsection",
      CellTags->{"S1.5.4", "4.1"}]},
  "4.2"->{
    Cell[36397, 1270, 561, 20, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.2"}]},
  "4.3"->{
    Cell[37235, 1305, 153, 5, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.3"}]},
  "4.4"->{
    Cell[37662, 1325, 344, 11, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.4"}]},
  "4.5"->{
    Cell[38239, 1350, 84, 1, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.5"}]},
  "4.6"->{
    Cell[46921, 1603, 236, 8, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.6"}]},
  "4.7"->{
    Cell[47400, 1625, 159, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.7"}]},
  "4.8"->{
    Cell[47787, 1643, 129, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.8"}]},
  "4.9"->{
    Cell[48208, 1662, 140, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.9"}]},
  "4.10"->{
    Cell[48637, 1681, 132, 4, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.10"}]},
  "4.11"->{
    Cell[48981, 1699, 2593, 98, 70, "Text",
      CellTags->{"S1.5.4", "4.11"}]},
  "4.12"->{
    Cell[51577, 1799, 934, 31, 70, "MathCaption",
      CellTags->{"S1.5.4", "4.12"}]},
  "4.13"->{
    Cell[52805, 1845, 710, 24, 70, "Text",
      CellTags->{"S1.5.4", "4.13"}]},
  "S1.5.5"->{
    Cell[61764, 2119, 68, 1, 70, "Subsection",
      CellTags->{"S1.5.5", "5.1"}],
    Cell[61835, 2122, 775, 37, 70, "Text",
      CellTags->{"S1.5.5", "5.2"}],
    Cell[62613, 2161, 311, 15, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.3"}],
    Cell[62949, 2180, 74, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[63026, 2184, 85, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[63126, 2190, 918, 39, 70, "Text",
      CellTags->{"S1.5.5", "5.4"}],
    Cell[64047, 2231, 983, 34, 70, "DefinitionBox",
      CellTags->"S1.5.5"],
    Cell[65033, 2267, 64, 1, 70, "Caption",
      CellTags->"S1.5.5"],
    Cell[65100, 2270, 186, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.5"}],
    Cell[65311, 2283, 69, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[65383, 2287, 82, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[65480, 2293, 159, 7, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.6"}],
    Cell[65664, 2304, 65, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[65732, 2308, 82, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[65829, 2314, 211, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.7"}],
    Cell[66065, 2327, 70, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[66138, 2331, 85, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[66238, 2337, 172, 8, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.8"}],
    Cell[66435, 2349, 70, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[66508, 2353, 86, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[66609, 2359, 136, 5, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.9"}],
    Cell[66748, 2366, 68, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[66819, 2370, 278, 8, 70, "Text",
      CellTags->{"S1.5.5", "5.10"}],
    Cell[67100, 2380, 222, 6, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.11"}],
    Cell[67347, 2390, 70, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[67420, 2394, 93, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[67528, 2400, 229, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.12"}],
    Cell[67782, 2413, 75, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[67860, 2417, 86, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[67961, 2423, 454, 10, 70, "Text",
      CellTags->{"S1.5.5", "5.13"}],
    Cell[68418, 2435, 245, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.14"}],
    Cell[68688, 2448, 86, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[68777, 2452, 85, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[68877, 2458, 256, 7, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.15"}],
    Cell[69158, 2469, 87, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[69248, 2473, 117, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[69380, 2479, 372, 15, 70, "Text",
      CellTags->{"S1.5.5", "5.16"}],
    Cell[69755, 2496, 352, 13, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.17"}],
    Cell[70132, 2513, 83, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[70218, 2517, 113, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[70346, 2523, 94, 1, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.18"}],
    Cell[70465, 2528, 72, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[70540, 2532, 113, 3, 70, "Output",
      CellTags->"S1.5.5"],
    Cell[70668, 2538, 145, 5, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.19"}],
    Cell[70838, 2547, 68, 2, 70, "Input",
      CellTags->"S1.5.5"],
    Cell[70909, 2551, 113, 3, 70, "Output",
      CellTags->"S1.5.5"]},
  "5.1"->{
    Cell[61764, 2119, 68, 1, 70, "Subsection",
      CellTags->{"S1.5.5", "5.1"}]},
  "5.2"->{
    Cell[61835, 2122, 775, 37, 70, "Text",
      CellTags->{"S1.5.5", "5.2"}]},
  "5.3"->{
    Cell[62613, 2161, 311, 15, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.3"}]},
  "5.4"->{
    Cell[63126, 2190, 918, 39, 70, "Text",
      CellTags->{"S1.5.5", "5.4"}]},
  "5.5"->{
    Cell[65100, 2270, 186, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.5"}]},
  "5.6"->{
    Cell[65480, 2293, 159, 7, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.6"}]},
  "5.7"->{
    Cell[65829, 2314, 211, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.7"}]},
  "5.8"->{
    Cell[66238, 2337, 172, 8, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.8"}]},
  "5.9"->{
    Cell[66609, 2359, 136, 5, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.9"}]},
  "5.10"->{
    Cell[66819, 2370, 278, 8, 70, "Text",
      CellTags->{"S1.5.5", "5.10"}]},
  "5.11"->{
    Cell[67100, 2380, 222, 6, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.11"}]},
  "5.12"->{
    Cell[67528, 2400, 229, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.12"}]},
  "5.13"->{
    Cell[67961, 2423, 454, 10, 70, "Text",
      CellTags->{"S1.5.5", "5.13"}]},
  "5.14"->{
    Cell[68418, 2435, 245, 9, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.14"}]},
  "5.15"->{
    Cell[68877, 2458, 256, 7, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.15"}]},
  "5.16"->{
    Cell[69380, 2479, 372, 15, 70, "Text",
      CellTags->{"S1.5.5", "5.16"}]},
  "5.17"->{
    Cell[69755, 2496, 352, 13, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.17"}]},
  "5.18"->{
    Cell[70346, 2523, 94, 1, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.18"}]},
  "5.19"->{
    Cell[70668, 2538, 145, 5, 70, "MathCaption",
      CellTags->{"S1.5.5", "5.19"}]},
  "S1.5.6"->{
    Cell[71071, 2560, 91, 1, 70, "Subsection",
      CellTags->{"S1.5.6", "6.1"}],
    Cell[71165, 2563, 3809, 126, 70, "DefinitionBox",
      CellTags->"S1.5.6"],
    Cell[74977, 2691, 63, 1, 70, "Caption",
      CellTags->"S1.5.6"],
    Cell[75043, 2694, 213, 9, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.2"}],
    Cell[75281, 2707, 70, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[75354, 2711, 86, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[75455, 2717, 157, 5, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.3"}],
    Cell[75637, 2726, 75, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[75715, 2730, 86, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[75816, 2736, 148, 7, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.4"}],
    Cell[75989, 2747, 74, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[76066, 2751, 85, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[76166, 2757, 194, 5, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.5"}],
    Cell[76385, 2766, 75, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[76463, 2770, 85, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[76563, 2776, 149, 4, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.6"}],
    Cell[76737, 2784, 69, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[76809, 2788, 86, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[76910, 2794, 5032, 165, 70, "DefinitionBox",
      CellTags->"S1.5.6"],
    Cell[81945, 2961, 61, 1, 70, "Caption",
      CellTags->"S1.5.6"],
    Cell[82009, 2964, 171, 7, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.7"}],
    Cell[82205, 2975, 79, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[82287, 2979, 85, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[82387, 2985, 402, 14, 70, "Text",
      CellTags->{"S1.5.6", "6.8"}],
    Cell[82792, 3001, 149, 4, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.9"}],
    Cell[82966, 3009, 70, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[83039, 3013, 87, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[83141, 3019, 139, 4, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.10"}],
    Cell[83305, 3027, 85, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[83393, 3031, 115, 3, 70, "Output",
      CellTags->"S1.5.6"],
    Cell[83523, 3037, 150, 5, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.11"}],
    Cell[83698, 3046, 82, 2, 70, "Input",
      CellTags->"S1.5.6"],
    Cell[83783, 3050, 145, 4, 70, "Output",
      CellTags->"S1.5.6"]},
  "6.1"->{
    Cell[71071, 2560, 91, 1, 70, "Subsection",
      CellTags->{"S1.5.6", "6.1"}]},
  "6.2"->{
    Cell[75043, 2694, 213, 9, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.2"}]},
  "6.3"->{
    Cell[75455, 2717, 157, 5, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.3"}]},
  "6.4"->{
    Cell[75816, 2736, 148, 7, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.4"}]},
  "6.5"->{
    Cell[76166, 2757, 194, 5, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.5"}]},
  "6.6"->{
    Cell[76563, 2776, 149, 4, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.6"}]},
  "6.7"->{
    Cell[82009, 2964, 171, 7, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.7"}]},
  "6.8"->{
    Cell[82387, 2985, 402, 14, 70, "Text",
      CellTags->{"S1.5.6", "6.8"}]},
  "6.9"->{
    Cell[82792, 3001, 149, 4, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.9"}]},
  "6.10"->{
    Cell[83141, 3019, 139, 4, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.10"}]},
  "6.11"->{
    Cell[83523, 3037, 150, 5, 70, "MathCaption",
      CellTags->{"S1.5.6", "6.11"}]},
  "S1.5.7"->{
    Cell[83977, 3060, 76, 1, 70, "Subsection",
      CellTags->{"S1.5.7", "7.1"}],
    Cell[84056, 3063, 577, 27, 70, "Text",
      CellTags->{"S1.5.7", "7.2"}],
    Cell[84636, 3092, 466, 14, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.3"}],
    Cell[85127, 3110, 91, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[85221, 3114, 141, 4, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[85377, 3121, 105, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.4"}],
    Cell[85507, 3126, 70, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[85580, 3130, 163, 4, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[85758, 3137, 281, 9, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.5"}],
    Cell[86064, 3150, 70, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[86137, 3154, 128, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[86280, 3160, 172, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.6"}],
    Cell[86477, 3169, 79, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[86559, 3173, 120, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[86694, 3179, 1381, 44, 70, "DefinitionBox",
      CellTags->"S1.5.7"],
    Cell[88078, 3225, 83, 1, 70, "Caption",
      CellTags->"S1.5.7"],
    Cell[88164, 3228, 679, 13, 70, "Text",
      CellTags->{"S1.5.7", "7.7"}],
    Cell[88846, 3243, 201, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.8"}],
    Cell[89072, 3252, 94, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[89169, 3256, 283, 5, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[89467, 3264, 110, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.9"}],
    Cell[89602, 3269, 82, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[89687, 3273, 281, 6, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[89983, 3282, 323, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.10"}],
    Cell[90331, 3294, 92, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[90426, 3298, 335, 7, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[90776, 3308, 157, 4, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.11"}],
    Cell[90958, 3316, 70, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[91031, 3320, 375, 8, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[91421, 3331, 224, 5, 70, "Text",
      CellTags->{"S1.5.7", "7.12"}],
    Cell[91648, 3338, 176, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.13"}],
    Cell[91849, 3347, 87, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[91939, 3351, 228, 4, 70, "Message",
      CellTags->"S1.5.7"],
    Cell[92170, 3357, 104, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[92289, 3363, 740, 21, 70, "Text",
      CellTags->{"S1.5.7", "7.14"}],
    Cell[93032, 3386, 197, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.15"}],
    Cell[93254, 3395, 88, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[93345, 3399, 197, 4, 70, "Message",
      CellTags->"S1.5.7"],
    Cell[93545, 3405, 109, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[93669, 3411, 225, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.16"}],
    Cell[93919, 3422, 96, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[94018, 3426, 113, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[94146, 3432, 251, 6, 70, "Text",
      CellTags->{"S1.5.7", "7.17"}],
    Cell[94400, 3440, 196, 6, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.18"}],
    Cell[94621, 3450, 88, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[94712, 3454, 186, 4, 70, "Message",
      CellTags->"S1.5.7"],
    Cell[94901, 3460, 667, 20, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[95583, 3483, 1943, 58, 70, "DefinitionBox",
      CellTags->"S1.5.7"],
    Cell[97529, 3543, 81, 1, 70, "Caption",
      CellTags->"S1.5.7"],
    Cell[97613, 3546, 251, 6, 70, "Text",
      CellTags->{"S1.5.7", "7.19"}],
    Cell[97867, 3554, 383, 14, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.20"}],
    Cell[98275, 3572, 114, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[98392, 3576, 178, 4, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[98585, 3583, 254, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.21"}],
    Cell[98864, 3595, 110, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[98977, 3599, 189, 4, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[99181, 3606, 213, 9, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.22"}],
    Cell[99419, 3619, 75, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[99497, 3623, 111, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[99623, 3629, 409, 9, 70, "Text",
      CellTags->{"S1.5.7", "7.23"}],
    Cell[100035, 3640, 222, 5, 70, "Text",
      CellTags->{"S1.5.7", "7.24"}],
    Cell[100260, 3647, 224, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.25"}],
    Cell[100509, 3659, 113, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[100625, 3663, 114, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[100754, 3669, 216, 5, 70, "Text",
      CellTags->{"S1.5.7", "7.26"}],
    Cell[100973, 3676, 253, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.27"}],
    Cell[101251, 3687, 87, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[101341, 3691, 84, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[101440, 3697, 203, 6, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.28"}],
    Cell[101668, 3707, 87, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[101758, 3711, 84, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[101857, 3717, 775, 23, 70, "Text",
      CellTags->{"S1.5.7", "7.29"}],
    Cell[102635, 3742, 358, 12, 70, "Text",
      CellTags->{"S1.5.7", "7.30"}],
    Cell[102996, 3756, 478, 21, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.31"}],
    Cell[103499, 3781, 88, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[103590, 3785, 110, 3, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[103715, 3791, 349, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.32"}],
    Cell[104089, 3803, 88, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[104180, 3807, 171, 4, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[104366, 3814, 111, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.33"}],
    Cell[104502, 3819, 90, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[104595, 3823, 241, 6, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[104851, 3832, 110, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.34"}],
    Cell[104986, 3837, 87, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[105076, 3841, 222, 5, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[105313, 3849, 5599, 168, 70, "DefinitionBox",
      CellTags->"S1.5.7"],
    Cell[110915, 4019, 91, 1, 70, "Caption",
      CellTags->"S1.5.7"],
    Cell[111009, 4022, 328, 9, 70, "Text",
      CellTags->{"S1.5.7", "7.35"}],
    Cell[111340, 4033, 183, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.36"}],
    Cell[111548, 4044, 90, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[111641, 4048, 143, 4, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[111799, 4055, 180, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.37"}],
    Cell[112004, 4066, 97, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[112104, 4070, 207, 5, 70, "Output",
      CellTags->"S1.5.7"],
    Cell[112326, 4078, 94, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.38"}],
    Cell[112445, 4083, 100, 2, 70, "Input",
      CellTags->"S1.5.7"],
    Cell[112548, 4087, 262, 5, 70, "Output",
      CellTags->"S1.5.7"]},
  "7.1"->{
    Cell[83977, 3060, 76, 1, 70, "Subsection",
      CellTags->{"S1.5.7", "7.1"}]},
  "7.2"->{
    Cell[84056, 3063, 577, 27, 70, "Text",
      CellTags->{"S1.5.7", "7.2"}]},
  "7.3"->{
    Cell[84636, 3092, 466, 14, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.3"}]},
  "7.4"->{
    Cell[85377, 3121, 105, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.4"}]},
  "7.5"->{
    Cell[85758, 3137, 281, 9, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.5"}]},
  "7.6"->{
    Cell[86280, 3160, 172, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.6"}]},
  "7.7"->{
    Cell[88164, 3228, 679, 13, 70, "Text",
      CellTags->{"S1.5.7", "7.7"}]},
  "7.8"->{
    Cell[88846, 3243, 201, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.8"}]},
  "7.9"->{
    Cell[89467, 3264, 110, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.9"}]},
  "7.10"->{
    Cell[89983, 3282, 323, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.10"}]},
  "7.11"->{
    Cell[90776, 3308, 157, 4, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.11"}]},
  "7.12"->{
    Cell[91421, 3331, 224, 5, 70, "Text",
      CellTags->{"S1.5.7", "7.12"}]},
  "7.13"->{
    Cell[91648, 3338, 176, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.13"}]},
  "7.14"->{
    Cell[92289, 3363, 740, 21, 70, "Text",
      CellTags->{"S1.5.7", "7.14"}]},
  "7.15"->{
    Cell[93032, 3386, 197, 5, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.15"}]},
  "7.16"->{
    Cell[93669, 3411, 225, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.16"}]},
  "7.17"->{
    Cell[94146, 3432, 251, 6, 70, "Text",
      CellTags->{"S1.5.7", "7.17"}]},
  "7.18"->{
    Cell[94400, 3440, 196, 6, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.18"}]},
  "7.19"->{
    Cell[97613, 3546, 251, 6, 70, "Text",
      CellTags->{"S1.5.7", "7.19"}]},
  "7.20"->{
    Cell[97867, 3554, 383, 14, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.20"}]},
  "7.21"->{
    Cell[98585, 3583, 254, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.21"}]},
  "7.22"->{
    Cell[99181, 3606, 213, 9, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.22"}]},
  "7.23"->{
    Cell[99623, 3629, 409, 9, 70, "Text",
      CellTags->{"S1.5.7", "7.23"}]},
  "7.24"->{
    Cell[100035, 3640, 222, 5, 70, "Text",
      CellTags->{"S1.5.7", "7.24"}]},
  "7.25"->{
    Cell[100260, 3647, 224, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.25"}]},
  "7.26"->{
    Cell[100754, 3669, 216, 5, 70, "Text",
      CellTags->{"S1.5.7", "7.26"}]},
  "7.27"->{
    Cell[100973, 3676, 253, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.27"}]},
  "7.28"->{
    Cell[101440, 3697, 203, 6, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.28"}]},
  "7.29"->{
    Cell[101857, 3717, 775, 23, 70, "Text",
      CellTags->{"S1.5.7", "7.29"}]},
  "7.30"->{
    Cell[102635, 3742, 358, 12, 70, "Text",
      CellTags->{"S1.5.7", "7.30"}]},
  "7.31"->{
    Cell[102996, 3756, 478, 21, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.31"}]},
  "7.32"->{
    Cell[103715, 3791, 349, 8, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.32"}]},
  "7.33"->{
    Cell[104366, 3814, 111, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.33"}]},
  "7.34"->{
    Cell[104851, 3832, 110, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.34"}]},
  "7.35"->{
    Cell[111009, 4022, 328, 9, 70, "Text",
      CellTags->{"S1.5.7", "7.35"}]},
  "7.36"->{
    Cell[111340, 4033, 183, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.36"}]},
  "7.37"->{
    Cell[111799, 4055, 180, 7, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.37"}]},
  "7.38"->{
    Cell[112326, 4078, 94, 1, 70, "MathCaption",
      CellTags->{"S1.5.7", "7.38"}]},
  "S1.5.8"->{
    Cell[112859, 4098, 71, 1, 70, "Subsection",
      CellTags->{"S1.5.8", "8.1"}],
    Cell[112933, 4101, 1388, 44, 70, "DefinitionBox",
      CellTags->"S1.5.8"],
    Cell[114324, 4147, 64, 1, 70, "Caption",
      CellTags->"S1.5.8"],
    Cell[114391, 4150, 102, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.2"}],
    Cell[114518, 4155, 102, 2, 70, "Input",
      CellTags->"S1.5.8"],
    Cell[114623, 4159, 110, 3, 70, "Output",
      CellTags->"S1.5.8"],
    Cell[114748, 4165, 97, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.3"}],
    Cell[114870, 4170, 102, 2, 70, "Input",
      CellTags->"S1.5.8"],
    Cell[114975, 4174, 86, 3, 70, "Output",
      CellTags->"S1.5.8"],
    Cell[115076, 4180, 108, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.4"}],
    Cell[115209, 4185, 104, 2, 70, "Input",
      CellTags->"S1.5.8"],
    Cell[115316, 4189, 362, 8, 70, "Output",
      CellTags->"S1.5.8"],
    Cell[115693, 4200, 371, 8, 70, "Text",
      CellTags->{"S1.5.8", "8.5"}],
    Cell[116067, 4210, 128, 4, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.6"}],
    Cell[116220, 4218, 110, 2, 70, "Input",
      CellTags->"S1.5.8"],
    Cell[116333, 4222, 117, 3, 70, "Output",
      CellTags->"S1.5.8"],
    Cell[116465, 4228, 1764, 58, 70, "DefinitionBox",
      CellTags->"S1.5.8"],
    Cell[118232, 4288, 84, 1, 70, "Caption",
      CellTags->"S1.5.8"],
    Cell[118319, 4291, 109, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.7"}],
    Cell[118453, 4296, 107, 2, 70, "Input",
      CellTags->"S1.5.8"],
    Cell[118563, 4300, 132, 3, 70, "Output",
      CellTags->"S1.5.8"]},
  "8.1"->{
    Cell[112859, 4098, 71, 1, 70, "Subsection",
      CellTags->{"S1.5.8", "8.1"}]},
  "8.2"->{
    Cell[114391, 4150, 102, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.2"}]},
  "8.3"->{
    Cell[114748, 4165, 97, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.3"}]},
  "8.4"->{
    Cell[115076, 4180, 108, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.4"}]},
  "8.5"->{
    Cell[115693, 4200, 371, 8, 70, "Text",
      CellTags->{"S1.5.8", "8.5"}]},
  "8.6"->{
    Cell[116067, 4210, 128, 4, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.6"}]},
  "8.7"->{
    Cell[118319, 4291, 109, 1, 70, "MathCaption",
      CellTags->{"S1.5.8", "8.7"}]},
  "S1.5.9"->{
    Cell[118744, 4309, 81, 1, 70, "Subsection",
      CellTags->{"S1.5.9", "9.1"}],
    Cell[118828, 4312, 1464, 45, 70, "DefinitionBox",
      CellTags->"S1.5.9"],
    Cell[120295, 4359, 84, 1, 70, "Caption",
      CellTags->"S1.5.9"],
    Cell[120382, 4362, 663, 22, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.2"}],
    Cell[121070, 4388, 102, 2, 70, "Input",
      CellTags->"S1.5.9"],
    Cell[121175, 4392, 175, 5, 70, "Output",
      CellTags->"S1.5.9"],
    Cell[121365, 4400, 169, 4, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.3"}],
    Cell[121559, 4408, 115, 2, 70, "Input",
      CellTags->"S1.5.9"],
    Cell[121677, 4412, 141, 4, 70, "Output",
      CellTags->"S1.5.9"],
    Cell[121833, 4419, 2347, 89, 70, "Text",
      CellTags->{"S1.5.9", "9.4"}],
    Cell[124183, 4510, 568, 15, 70, "Text",
      CellTags->{"S1.5.9", "9.5"}],
    Cell[124754, 4527, 222, 5, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.6"}],
    Cell[125001, 4536, 121, 2, 70, "Input",
      CellTags->"S1.5.9"],
    Cell[125125, 4540, 469, 11, 70, "Output",
      CellTags->"S1.5.9"],
    Cell[125609, 4554, 597, 18, 70, "Text",
      CellTags->{"S1.5.9", "9.7"}],
    Cell[126209, 4574, 195, 5, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.8"}],
    Cell[126429, 4583, 97, 2, 70, "Input",
      CellTags->"S1.5.9"],
    Cell[126529, 4587, 160, 5, 70, "Output",
      CellTags->"S1.5.9"],
    Cell[126704, 4595, 192, 6, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.9"}],
    Cell[126921, 4605, 82, 2, 70, "Input",
      CellTags->"S1.5.9"],
    Cell[127006, 4609, 123, 3, 70, "Output",
      CellTags->"S1.5.9"],
    Cell[127144, 4615, 365, 12, 70, "Text",
      CellTags->{"S1.5.9", "9.10"}],
    Cell[127512, 4629, 283, 7, 70, "Text",
      CellTags->{"S1.5.9", "9.11"}]},
  "9.1"->{
    Cell[118744, 4309, 81, 1, 70, "Subsection",
      CellTags->{"S1.5.9", "9.1"}]},
  "9.2"->{
    Cell[120382, 4362, 663, 22, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.2"}]},
  "9.3"->{
    Cell[121365, 4400, 169, 4, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.3"}]},
  "9.4"->{
    Cell[121833, 4419, 2347, 89, 70, "Text",
      CellTags->{"S1.5.9", "9.4"}]},
  "9.5"->{
    Cell[124183, 4510, 568, 15, 70, "Text",
      CellTags->{"S1.5.9", "9.5"}]},
  "9.6"->{
    Cell[124754, 4527, 222, 5, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.6"}]},
  "9.7"->{
    Cell[125609, 4554, 597, 18, 70, "Text",
      CellTags->{"S1.5.9", "9.7"}]},
  "9.8"->{
    Cell[126209, 4574, 195, 5, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.8"}]},
  "9.9"->{
    Cell[126704, 4595, 192, 6, 70, "MathCaption",
      CellTags->{"S1.5.9", "9.9"}]},
  "9.10"->{
    Cell[127144, 4615, 365, 12, 70, "Text",
      CellTags->{"S1.5.9", "9.10"}]},
  "9.11"->{
    Cell[127512, 4629, 283, 7, 70, "Text",
      CellTags->{"S1.5.9", "9.11"}]},
  "S1.5.10"->{
    Cell[127832, 4641, 74, 1, 70, "Subsection",
      CellTags->{"S1.5.10", "10.1"}],
    Cell[127909, 4644, 212, 5, 70, "Text",
      CellTags->{"S1.5.10", "10.2"}],
    Cell[128124, 4651, 313, 8, 70, "Text",
      CellTags->{"S1.5.10", "10.3"}],
    Cell[128440, 4661, 744, 27, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.4"}],
    Cell[129209, 4692, 93, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[129305, 4696, 601, 18, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[129921, 4717, 173, 4, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.5"}],
    Cell[130119, 4725, 108, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[130230, 4729, 1026, 34, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[131271, 4766, 209, 5, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.6"}],
    Cell[131505, 4775, 92, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[131600, 4779, 734, 21, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[132349, 4803, 484, 9, 70, "Text",
      CellTags->{"S1.5.10", "10.7"}],
    Cell[132836, 4814, 270, 9, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.8"}],
    Cell[133131, 4827, 90, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[133224, 4831, 505, 15, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[133744, 4849, 203, 6, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.9"}],
    Cell[133972, 4859, 76, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[134051, 4863, 544, 15, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[134610, 4881, 129, 4, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.10"}],
    Cell[134764, 4889, 74, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[134841, 4893, 173, 5, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[135029, 4901, 137, 5, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.11"}],
    Cell[135191, 4910, 68, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[135262, 4914, 175, 4, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[135452, 4921, 151, 5, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.12"}],
    Cell[135628, 4930, 74, 2, 70, "Input",
      CellTags->"S1.5.10"],
    Cell[135705, 4934, 282, 6, 70, "Output",
      CellTags->"S1.5.10"],
    Cell[136002, 4943, 1760, 51, 70, "DefinitionBox",
      CellTags->"S1.5.10"],
    Cell[137765, 4996, 67, 1, 70, "Caption",
      CellTags->"S1.5.10"]},
  "10.1"->{
    Cell[127832, 4641, 74, 1, 70, "Subsection",
      CellTags->{"S1.5.10", "10.1"}]},
  "10.2"->{
    Cell[127909, 4644, 212, 5, 70, "Text",
      CellTags->{"S1.5.10", "10.2"}]},
  "10.3"->{
    Cell[128124, 4651, 313, 8, 70, "Text",
      CellTags->{"S1.5.10", "10.3"}]},
  "10.4"->{
    Cell[128440, 4661, 744, 27, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.4"}]},
  "10.5"->{
    Cell[129921, 4717, 173, 4, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.5"}]},
  "10.6"->{
    Cell[131271, 4766, 209, 5, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.6"}]},
  "10.7"->{
    Cell[132349, 4803, 484, 9, 70, "Text",
      CellTags->{"S1.5.10", "10.7"}]},
  "10.8"->{
    Cell[132836, 4814, 270, 9, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.8"}]},
  "10.9"->{
    Cell[133744, 4849, 203, 6, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.9"}]},
  "10.10"->{
    Cell[134610, 4881, 129, 4, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.10"}]},
  "10.11"->{
    Cell[135029, 4901, 137, 5, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.11"}]},
  "10.12"->{
    Cell[135452, 4921, 151, 5, 70, "MathCaption",
      CellTags->{"S1.5.10", "10.12"}]},
  "S1.5.11"->{
    Cell[137869, 5002, 68, 1, 70, "Subsection",
      CellTags->{"S1.5.11", "11.1"}],
    Cell[137940, 5005, 324, 12, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.2"}],
    Cell[138289, 5021, 77, 2, 70, "Input",
      CellTags->"S1.5.11"],
    Cell[138369, 5025, 91, 3, 70, "Output",
      CellTags->"S1.5.11"],
    Cell[138475, 5031, 244, 9, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.3"}],
    Cell[138744, 5044, 74, 2, 70, "Input",
      CellTags->"S1.5.11"],
    Cell[138821, 5048, 140, 3, 70, "Message",
      CellTags->"S1.5.11"],
    Cell[138964, 5053, 169, 4, 70, "Message",
      CellTags->"S1.5.11"],
    Cell[139136, 5059, 95, 3, 70, "Output",
      CellTags->"S1.5.11"],
    Cell[139246, 5065, 651, 23, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.4"}],
    Cell[139922, 5092, 77, 2, 70, "Input",
      CellTags->"S1.5.11"],
    Cell[140002, 5096, 101, 3, 70, "Output",
      CellTags->"S1.5.11"],
    Cell[140118, 5102, 647, 25, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.5"}],
    Cell[140790, 5131, 79, 2, 70, "Input",
      CellTags->"S1.5.11"],
    Cell[140872, 5135, 83, 3, 70, "Output",
      CellTags->"S1.5.11"],
    Cell[140970, 5141, 1111, 33, 70, "DefinitionBox",
      CellTags->"S1.5.11"],
    Cell[142084, 5176, 50, 1, 70, "Caption",
      CellTags->"S1.5.11"]},
  "11.1"->{
    Cell[137869, 5002, 68, 1, 70, "Subsection",
      CellTags->{"S1.5.11", "11.1"}]},
  "11.2"->{
    Cell[137940, 5005, 324, 12, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.2"}]},
  "11.3"->{
    Cell[138475, 5031, 244, 9, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.3"}]},
  "11.4"->{
    Cell[139246, 5065, 651, 23, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.4"}]},
  "11.5"->{
    Cell[140118, 5102, 647, 25, 70, "MathCaption",
      CellTags->{"S1.5.11", "11.5"}]},
  "S1.5.12"->{
    Cell[142171, 5182, 81, 1, 70, "Subsection",
      CellTags->{"S1.5.12", "12.1"}],
    Cell[142255, 5185, 1224, 38, 70, "DefinitionBox",
      CellTags->"S1.5.12"],
    Cell[143482, 5225, 62, 1, 70, "Caption",
      CellTags->"S1.5.12"],
    Cell[143547, 5228, 91, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.2"}],
    Cell[143663, 5233, 101, 2, 70, "Input",
      CellTags->"S1.5.12"],
    Cell[143767, 5237, 99, 3, 70, "Output",
      CellTags->"S1.5.12"],
    Cell[143881, 5243, 87, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.3"}],
    Cell[143993, 5248, 97, 2, 70, "Input",
      CellTags->"S1.5.12"],
    Cell[144093, 5252, 113, 3, 70, "Output",
      CellTags->"S1.5.12"],
    Cell[144221, 5258, 1233, 38, 70, "DefinitionBox",
      CellTags->"S1.5.12"],
    Cell[145457, 5298, 62, 1, 70, "Caption",
      CellTags->"S1.5.12"],
    Cell[145522, 5301, 91, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.4"}],
    Cell[145638, 5306, 102, 2, 70, "Input",
      CellTags->"S1.5.12"],
    Cell[145743, 5310, 162, 4, 70, "Output",
      CellTags->"S1.5.12"],
    Cell[145920, 5317, 87, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.5"}],
    Cell[146032, 5322, 97, 2, 70, "Input",
      CellTags->"S1.5.12"],
    Cell[146132, 5326, 114, 3, 70, "Output",
      CellTags->"S1.5.12"],
    Cell[146261, 5332, 358, 10, 70, "Text",
      CellTags->{"S1.5.12", "12.6"}]},
  "12.1"->{
    Cell[142171, 5182, 81, 1, 70, "Subsection",
      CellTags->{"S1.5.12", "12.1"}]},
  "12.2"->{
    Cell[143547, 5228, 91, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.2"}]},
  "12.3"->{
    Cell[143881, 5243, 87, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.3"}]},
  "12.4"->{
    Cell[145522, 5301, 91, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.4"}]},
  "12.5"->{
    Cell[145920, 5317, 87, 1, 70, "MathCaption",
      CellTags->{"S1.5.12", "12.5"}]},
  "12.6"->{
    Cell[146261, 5332, 358, 10, 70, "Text",
      CellTags->{"S1.5.12", "12.6"}]},
  "S1.5.13"->{
    Cell[146656, 5347, 82, 1, 70, "Subsection",
      CellTags->{"S1.5.13", "13.1"}],
    Cell[146741, 5350, 932, 29, 70, "DefinitionBox",
      CellTags->"S1.5.13"],
    Cell[147676, 5381, 72, 1, 70, "Caption",
      CellTags->"S1.5.13"],
    Cell[147751, 5384, 98, 1, 70, "MathCaption",
      CellTags->{"S1.5.13", "13.2"}],
    Cell[147874, 5389, 111, 2, 70, "Input",
      CellTags->"S1.5.13"],
    Cell[147988, 5393, 124, 3, 70, "Output",
      CellTags->"S1.5.13"]},
  "13.1"->{
    Cell[146656, 5347, 82, 1, 70, "Subsection",
      CellTags->{"S1.5.13", "13.1"}]},
  "13.2"->{
    Cell[147751, 5384, 98, 1, 70, "MathCaption",
      CellTags->{"S1.5.13", "13.2"}]},
  "S1.5.14"->{
    Cell[148161, 5402, 95, 1, 70, "Subsection",
      CellTags->{"S1.5.14", "14.1"}],
    Cell[148259, 5405, 642, 18, 70, "Text",
      CellTags->{"S1.5.14", "14.2"}],
    Cell[148926, 5427, 73, 1, 70, "Subsubsection",
      CellTags->{"S1.5.14", "14.3"}],
    Cell[149002, 5430, 3147, 90, 70, "DefinitionBox",
      CellTags->"S1.5.14"],
    Cell[152152, 5522, 59, 1, 70, "Caption",
      CellTags->"S1.5.14"],
    Cell[152214, 5525, 222, 5, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.4"}],
    Cell[152439, 5532, 91, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[152533, 5536, 261, 9, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.5"}],
    Cell[152819, 5549, 105, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[152927, 5553, 106, 3, 70, "Output",
      CellTags->"S1.5.14"],
    Cell[153048, 5559, 340, 11, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.6"}],
    Cell[153413, 5574, 85, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[153501, 5578, 118, 3, 70, "Output",
      CellTags->"S1.5.14"],
    Cell[153668, 5587, 77, 1, 70, "Subsubsection",
      CellTags->{"S1.5.14", "14.7"}],
    Cell[153748, 5590, 946, 28, 70, "DefinitionBox",
      CellTags->"S1.5.14"],
    Cell[154697, 5620, 63, 1, 70, "Caption",
      CellTags->"S1.5.14"],
    Cell[154763, 5623, 100, 1, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.8"}],
    Cell[154866, 5626, 95, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[154964, 5630, 562, 20, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.9"}],
    Cell[155551, 5654, 104, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[155658, 5658, 657, 19, 70, "Output",
      CellTags->"S1.5.14"],
    Cell[156364, 5683, 70, 1, 70, "Subsubsection",
      CellTags->{"S1.5.14", "14.10"}],
    Cell[156437, 5686, 1504, 45, 70, "DefinitionBox",
      CellTags->"S1.5.14"],
    Cell[157944, 5733, 55, 1, 70, "Caption",
      CellTags->"S1.5.14"],
    Cell[158002, 5736, 93, 1, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.11"}],
    Cell[158098, 5739, 87, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[158188, 5743, 111, 1, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.12"}],
    Cell[158324, 5748, 93, 2, 70, "Input",
      CellTags->"S1.5.14"],
    Cell[158420, 5752, 232, 6, 70, "Output",
      CellTags->"S1.5.14"]},
  "14.1"->{
    Cell[148161, 5402, 95, 1, 70, "Subsection",
      CellTags->{"S1.5.14", "14.1"}]},
  "14.2"->{
    Cell[148259, 5405, 642, 18, 70, "Text",
      CellTags->{"S1.5.14", "14.2"}]},
  "14.3"->{
    Cell[148926, 5427, 73, 1, 70, "Subsubsection",
      CellTags->{"S1.5.14", "14.3"}]},
  "14.4"->{
    Cell[152214, 5525, 222, 5, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.4"}]},
  "14.5"->{
    Cell[152533, 5536, 261, 9, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.5"}]},
  "14.6"->{
    Cell[153048, 5559, 340, 11, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.6"}]},
  "14.7"->{
    Cell[153668, 5587, 77, 1, 70, "Subsubsection",
      CellTags->{"S1.5.14", "14.7"}]},
  "14.8"->{
    Cell[154763, 5623, 100, 1, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.8"}]},
  "14.9"->{
    Cell[154964, 5630, 562, 20, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.9"}]},
  "14.10"->{
    Cell[156364, 5683, 70, 1, 70, "Subsubsection",
      CellTags->{"S1.5.14", "14.10"}]},
  "14.11"->{
    Cell[158002, 5736, 93, 1, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.11"}]},
  "14.12"->{
    Cell[158188, 5743, 111, 1, 70, "MathCaption",
      CellTags->{"S1.5.14", "14.12"}]},
  "S1.5.15"->{
    Cell[158713, 5765, 125, 4, 70, "Subsection",
      CellTags->{"S1.5.15", "15.1"}],
    Cell[158841, 5771, 453, 16, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.2"}],
    Cell[159319, 5791, 82, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[159404, 5795, 105, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[159524, 5801, 290, 9, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.3"}],
    Cell[159839, 5814, 83, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[159925, 5818, 88, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[160028, 5824, 337, 6, 70, "Text",
      CellTags->{"S1.5.15", "15.4"}],
    Cell[160368, 5832, 345, 13, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.5"}],
    Cell[160738, 5849, 70, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[160811, 5853, 83, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[160909, 5859, 244, 8, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.6"}],
    Cell[161178, 5871, 70, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[161251, 5875, 140, 3, 70, "Message",
      CellTags->"S1.5.15"],
    Cell[161394, 5880, 169, 4, 70, "Message",
      CellTags->"S1.5.15"],
    Cell[161566, 5886, 95, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[161676, 5892, 136, 4, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.7"}],
    Cell[161837, 5900, 93, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[161933, 5904, 119, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[162067, 5910, 520, 14, 70, "Text",
      CellTags->{"S1.5.15", "15.8"}],
    Cell[162590, 5926, 266, 6, 70, "Text",
      CellTags->{"S1.5.15", "15.9"}],
    Cell[162859, 5934, 387, 14, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.10"}],
    Cell[163271, 5952, 74, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[163348, 5956, 88, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[163451, 5962, 213, 6, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.11"}],
    Cell[163689, 5972, 77, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[163769, 5976, 83, 3, 70, "Output",
      CellTags->"S1.5.15"],
    Cell[163867, 5982, 273, 8, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.12"}],
    Cell[164165, 5994, 91, 2, 70, "Input",
      CellTags->"S1.5.15"],
    Cell[164259, 5998, 83, 3, 70, "Output",
      CellTags->"S1.5.15"]},
  "15.1"->{
    Cell[158713, 5765, 125, 4, 70, "Subsection",
      CellTags->{"S1.5.15", "15.1"}]},
  "15.2"->{
    Cell[158841, 5771, 453, 16, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.2"}]},
  "15.3"->{
    Cell[159524, 5801, 290, 9, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.3"}]},
  "15.4"->{
    Cell[160028, 5824, 337, 6, 70, "Text",
      CellTags->{"S1.5.15", "15.4"}]},
  "15.5"->{
    Cell[160368, 5832, 345, 13, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.5"}]},
  "15.6"->{
    Cell[160909, 5859, 244, 8, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.6"}]},
  "15.7"->{
    Cell[161676, 5892, 136, 4, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.7"}]},
  "15.8"->{
    Cell[162067, 5910, 520, 14, 70, "Text",
      CellTags->{"S1.5.15", "15.8"}]},
  "15.9"->{
    Cell[162590, 5926, 266, 6, 70, "Text",
      CellTags->{"S1.5.15", "15.9"}]},
  "15.10"->{
    Cell[162859, 5934, 387, 14, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.10"}]},
  "15.11"->{
    Cell[163451, 5962, 213, 6, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.11"}]},
  "15.12"->{
    Cell[163867, 5982, 273, 8, 70, "MathCaption",
      CellTags->{"S1.5.15", "15.12"}]},
  "S1.5.16"->{
    Cell[164391, 6007, 96, 1, 70, "Subsection",
      CellTags->{"S1.5.16", "16.1"}],
    Cell[164490, 6010, 231, 6, 70, "Text",
      CellTags->{"S1.5.16", "16.2"}],
    Cell[164724, 6018, 6714, 194, 70, "DefinitionBox3Col",
      CellTags->"S1.5.16"],
    Cell[171441, 6214, 125, 4, 70, "Caption",
      CellTags->"S1.5.16"],
    Cell[171569, 6220, 325, 6, 88, "MathCaption",
      CellTags->{"S1.5.16", "16.3"}],
    Cell[171897, 6228, 23689, 297, 70, 23553, 292, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.5.16"],
    Cell[195589, 6527, 3982, 114, 330, "DefinitionBox",
      CellTags->"S1.5.16"],
    Cell[199574, 6643, 133, 4, 16, "Caption",
      CellTags->"S1.5.16"],
    Cell[199710, 6649, 375, 11, 56, "MathCaption",
      CellTags->{"S1.5.16", "16.4"}],
    Cell[200110, 6664, 115, 3, 40, "Input",
      CellTags->"S1.5.16"],
    Cell[200228, 6669, 105, 3, 44, "Output",
      CellTags->"S1.5.16"],
    Cell[200348, 6675, 117, 2, 40, "MathCaption",
      CellTags->{"S1.5.16", "16.5"}],
    Cell[200490, 6681, 398, 13, 28, "Input",
      CellTags->"S1.5.16"],
    Cell[200891, 6696, 105, 3, 44, "Output",
      CellTags->"S1.5.16"]},
  "16.1"->{
    Cell[164391, 6007, 96, 1, 70, "Subsection",
      CellTags->{"S1.5.16", "16.1"}]},
  "16.2"->{
    Cell[164490, 6010, 231, 6, 70, "Text",
      CellTags->{"S1.5.16", "16.2"}]},
  "16.3"->{
    Cell[171569, 6220, 325, 6, 88, "MathCaption",
      CellTags->{"S1.5.16", "16.3"}]},
  "16.4"->{
    Cell[199710, 6649, 375, 11, 56, "MathCaption",
      CellTags->{"S1.5.16", "16.4"}]},
  "16.5"->{
    Cell[200348, 6675, 117, 2, 40, "MathCaption",
      CellTags->{"S1.5.16", "16.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.5.0", 201651, 6720},
  {"0.1", 201741, 6723},
  {"S1.5.1", 201834, 6726},
  {"1.1", 202738, 6751},
  {"1.2", 202830, 6754},
  {"1.3", 202917, 6757},
  {"1.4", 203004, 6760},
  {"1.5", 203099, 6763},
  {"1.6", 203193, 6766},
  {"S1.5.2", 203286, 6769},
  {"2.1", 205244, 6822},
  {"2.2", 205338, 6825},
  {"2.3", 205435, 6828},
  {"2.4", 205531, 6831},
  {"2.5", 205627, 6834},
  {"2.6", 205718, 6837},
  {"2.7", 205815, 6840},
  {"2.8", 205912, 6843},
  {"2.9", 206002, 6846},
  {"2.10", 206099, 6849},
  {"S1.5.3", 206199, 6852},
  {"3.1", 209654, 6945},
  {"3.2", 209748, 6948},
  {"3.3", 209845, 6951},
  {"3.4", 209940, 6954},
  {"3.5", 210029, 6957},
  {"3.6", 210124, 6960},
  {"3.7", 210220, 6963},
  {"3.8", 210316, 6966},
  {"3.9", 210411, 6969},
  {"3.10", 210508, 6972},
  {"3.11", 210606, 6975},
  {"3.12", 210706, 6978},
  {"3.13", 210804, 6981},
  {"3.14", 210903, 6984},
  {"3.15", 211002, 6987},
  {"3.16", 211102, 6990},
  {"S1.5.4", 211203, 6993},
  {"4.1", 214019, 7068},
  {"4.2", 214114, 7071},
  {"4.3", 214212, 7074},
  {"4.4", 214309, 7077},
  {"4.5", 214407, 7080},
  {"4.6", 214503, 7083},
  {"4.7", 214600, 7086},
  {"4.8", 214697, 7089},
  {"4.9", 214794, 7092},
  {"4.10", 214892, 7095},
  {"4.11", 214991, 7098},
  {"4.12", 215085, 7101},
  {"4.13", 215185, 7104},
  {"S1.5.5", 215280, 7107},
  {"5.1", 218776, 7200},
  {"5.2", 218871, 7203},
  {"5.3", 218962, 7206},
  {"5.4", 219060, 7209},
  {"5.5", 219151, 7212},
  {"5.6", 219248, 7215},
  {"5.7", 219345, 7218},
  {"5.8", 219442, 7221},
  {"5.9", 219539, 7224},
  {"5.10", 219637, 7227},
  {"5.11", 219729, 7230},
  {"5.12", 219828, 7233},
  {"5.13", 219927, 7236},
  {"5.14", 220020, 7239},
  {"5.15", 220119, 7242},
  {"5.16", 220218, 7245},
  {"5.17", 220311, 7248},
  {"5.18", 220411, 7251},
  {"5.19", 220509, 7254},
  {"S1.5.6", 220610, 7257},
  {"6.1", 223108, 7324},
  {"6.2", 223203, 7327},
  {"6.3", 223300, 7330},
  {"6.4", 223397, 7333},
  {"6.5", 223494, 7336},
  {"6.6", 223591, 7339},
  {"6.7", 223688, 7342},
  {"6.8", 223785, 7345},
  {"6.9", 223876, 7348},
  {"6.10", 223974, 7351},
  {"6.11", 224073, 7354},
  {"S1.5.7", 224174, 7357},
  {"7.1", 231576, 7552},
  {"7.2", 231671, 7555},
  {"7.3", 231762, 7558},
  {"7.4", 231860, 7561},
  {"7.5", 231957, 7564},
  {"7.6", 232054, 7567},
  {"7.7", 232151, 7570},
  {"7.8", 232242, 7573},
  {"7.9", 232339, 7576},
  {"7.10", 232437, 7579},
  {"7.11", 232536, 7582},
  {"7.12", 232635, 7585},
  {"7.13", 232727, 7588},
  {"7.14", 232826, 7591},
  {"7.15", 232919, 7594},
  {"7.16", 233018, 7597},
  {"7.17", 233117, 7600},
  {"7.18", 233209, 7603},
  {"7.19", 233308, 7606},
  {"7.20", 233400, 7609},
  {"7.21", 233500, 7612},
  {"7.22", 233599, 7615},
  {"7.23", 233698, 7618},
  {"7.24", 233790, 7621},
  {"7.25", 233883, 7624},
  {"7.26", 233983, 7627},
  {"7.27", 234076, 7630},
  {"7.28", 234176, 7633},
  {"7.29", 234276, 7636},
  {"7.30", 234370, 7639},
  {"7.31", 234464, 7642},
  {"7.32", 234565, 7645},
  {"7.33", 234665, 7648},
  {"7.34", 234765, 7651},
  {"7.35", 234865, 7654},
  {"7.36", 234958, 7657},
  {"7.37", 235058, 7660},
  {"7.38", 235158, 7663},
  {"S1.5.8", 235259, 7666},
  {"8.1", 236883, 7709},
  {"8.2", 236979, 7712},
  {"8.3", 237077, 7715},
  {"8.4", 237174, 7718},
  {"8.5", 237272, 7721},
  {"8.6", 237363, 7724},
  {"8.7", 237461, 7727},
  {"S1.5.9", 237562, 7730},
  {"9.1", 239358, 7777},
  {"9.2", 239454, 7780},
  {"9.3", 239553, 7783},
  {"9.4", 239651, 7786},
  {"9.5", 239744, 7789},
  {"9.6", 239836, 7792},
  {"9.7", 239934, 7795},
  {"9.8", 240026, 7798},
  {"9.9", 240124, 7801},
  {"9.10", 240223, 7804},
  {"9.11", 240317, 7807},
  {"S1.5.10", 240413, 7810},
  {"10.1", 242777, 7871},
  {"10.2", 242876, 7874},
  {"10.3", 242970, 7877},
  {"10.4", 243064, 7880},
  {"10.5", 243166, 7883},
  {"10.6", 243267, 7886},
  {"10.7", 243368, 7889},
  {"10.8", 243462, 7892},
  {"10.9", 243563, 7895},
  {"10.10", 243665, 7898},
  {"10.11", 243768, 7901},
  {"10.12", 243871, 7904},
  {"S1.5.11", 243976, 7907},
  {"11.1", 245306, 7942},
  {"11.2", 245405, 7945},
  {"11.3", 245507, 7948},
  {"11.4", 245608, 7951},
  {"11.5", 245710, 7954},
  {"S1.5.12", 245815, 7957},
  {"12.1", 247231, 7994},
  {"12.2", 247330, 7997},
  {"12.3", 247430, 8000},
  {"12.4", 247530, 8003},
  {"12.5", 247630, 8006},
  {"12.6", 247730, 8009},
  {"S1.5.13", 247828, 8012},
  {"13.1", 248313, 8025},
  {"13.2", 248412, 8028},
  {"S1.5.14", 248515, 8031},
  {"14.1", 250839, 8090},
  {"14.2", 250938, 8093},
  {"14.3", 251033, 8096},
  {"14.4", 251135, 8099},
  {"14.5", 251236, 8102},
  {"14.6", 251337, 8105},
  {"14.7", 251439, 8108},
  {"14.8", 251541, 8111},
  {"14.9", 251642, 8114},
  {"14.10", 251745, 8117},
  {"14.11", 251849, 8120},
  {"14.12", 251951, 8123},
  {"S1.5.15", 252056, 8126},
  {"15.1", 254404, 8187},
  {"15.2", 254504, 8190},
  {"15.3", 254606, 8193},
  {"15.4", 254707, 8196},
  {"15.5", 254801, 8199},
  {"15.6", 254903, 8202},
  {"15.7", 255004, 8205},
  {"15.8", 255105, 8208},
  {"15.9", 255200, 8211},
  {"15.10", 255295, 8214},
  {"15.11", 255399, 8217},
  {"15.12", 255502, 8220},
  {"S1.5.16", 255607, 8223},
  {"16.1", 256809, 8254},
  {"16.2", 256908, 8257},
  {"16.3", 257002, 8260},
  {"16.4", 257103, 8263},
  {"16.5", 257205, 8266}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 123, 4, 65, "Section",
  CellTags->{"S1.5.0", "0.1"}],

Cell[CellGroupData[{
Cell[1924, 61, 75, 1, 70, "Subsection",
  CellTags->{"S1.5.1", "1.1"}],
Cell[2002, 64, 217, 5, 70, "Text",
  CellTags->{"S1.5.1", "1.2"}],
Cell[2222, 71, 246, 7, 70, "Text",
  CellTags->{"S1.5.1", "1.3"}],
Cell[2471, 80, 287, 11, 70, "MathCaption",
  CellTags->{"S1.5.1", "1.4"}],

Cell[CellGroupData[{
Cell[2783, 95, 75, 2, 70, "Input",
  CellTags->"S1.5.1"],
Cell[2861, 99, 101, 3, 70, "Output",
  CellTags->"S1.5.1"]
}, Open  ]],
Cell[2977, 105, 99, 1, 70, "MathCaption",
  CellTags->{"S1.5.1", "1.5"}],

Cell[CellGroupData[{
Cell[3101, 110, 84, 2, 70, "Input",
  CellTags->"S1.5.1"],
Cell[3188, 114, 115, 3, 70, "Output",
  CellTags->"S1.5.1"]
}, Open  ]],
Cell[3318, 120, 7078, 205, 70, "DefinitionBox",
  CellTags->"S1.5.1"],
Cell[10399, 327, 80, 1, 70, "Caption",
  CellTags->"S1.5.1"],
Cell[10482, 330, 640, 13, 70, "Text",
  CellTags->{"S1.5.1", "1.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11159, 348, 74, 1, 70, "Subsection",
  CellTags->{"S1.5.2", "2.1"}],
Cell[11236, 351, 414, 16, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.2"}],

Cell[CellGroupData[{
Cell[11675, 371, 75, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[11753, 375, 101, 3, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]],
Cell[11869, 381, 170, 4, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.3"}],

Cell[CellGroupData[{
Cell[12064, 389, 81, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[12148, 393, 96, 3, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]],
Cell[12259, 399, 149, 5, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.4"}],

Cell[CellGroupData[{
Cell[12433, 408, 80, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[12516, 412, 137, 3, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]],
Cell[12668, 418, 1418, 55, 70, "Text",
  CellTags->{"S1.5.2", "2.5"}],
Cell[14089, 475, 514, 22, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.6"}],

Cell[CellGroupData[{
Cell[14628, 501, 76, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[14707, 505, 116, 3, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]],
Cell[14838, 511, 580, 22, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.7"}],

Cell[CellGroupData[{
Cell[15443, 537, 73, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[15519, 541, 124, 3, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]],
Cell[15658, 547, 4696, 135, 70, "DefinitionBox",
  CellTags->"S1.5.2"],
Cell[20357, 684, 73, 1, 70, "Caption",
  CellTags->"S1.5.2"],
Cell[20433, 687, 493, 15, 70, "Text",
  CellTags->{"S1.5.2", "2.8"}],
Cell[20929, 704, 253, 8, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.9"}],

Cell[CellGroupData[{
Cell[21207, 716, 76, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[21286, 720, 173, 5, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]],
Cell[21474, 728, 150, 4, 70, "MathCaption",
  CellTags->{"S1.5.2", "2.10"}],

Cell[CellGroupData[{
Cell[21649, 736, 82, 2, 70, "Input",
  CellTags->"S1.5.2"],
Cell[21734, 740, 268, 7, 70, "Output",
  CellTags->"S1.5.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22051, 753, 70, 1, 70, "Subsection",
  CellTags->{"S1.5.3", "3.1"}],
Cell[22124, 756, 459, 18, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.2"}],

Cell[CellGroupData[{
Cell[22608, 778, 81, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[22692, 782, 104, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[22811, 788, 99, 1, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.3"}],

Cell[CellGroupData[{
Cell[22935, 793, 91, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[23029, 797, 174, 4, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[23218, 804, 444, 8, 70, "Text",
  CellTags->{"S1.5.3", "3.4"}],
Cell[23665, 814, 97, 1, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.5"}],

Cell[CellGroupData[{
Cell[23787, 819, 91, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[23881, 823, 142, 4, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[24038, 830, 131, 4, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.6"}],

Cell[CellGroupData[{
Cell[24194, 838, 92, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[24289, 842, 112, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[24416, 848, 126, 5, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.7"}],

Cell[CellGroupData[{
Cell[24567, 857, 90, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[24660, 861, 119, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[24794, 867, 96, 1, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.8"}],

Cell[CellGroupData[{
Cell[24915, 872, 86, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[25004, 876, 124, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[25143, 882, 109, 1, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.9"}],

Cell[CellGroupData[{
Cell[25277, 887, 89, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[25369, 891, 127, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[25511, 897, 230, 6, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.10"}],

Cell[CellGroupData[{
Cell[25766, 907, 83, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[25852, 911, 118, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[25985, 917, 6788, 194, 70, "DefinitionBox",
  CellTags->"S1.5.3"],
Cell[32776, 1113, 54, 1, 70, "Caption",
  CellTags->"S1.5.3"],
Cell[32833, 1116, 520, 19, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.11"}],

Cell[CellGroupData[{
Cell[33378, 1139, 95, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[33476, 1143, 137, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[33628, 1149, 90, 1, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.12"}],

Cell[CellGroupData[{
Cell[33743, 1154, 103, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[33849, 1158, 92, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[33956, 1164, 159, 4, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.13"}],

Cell[CellGroupData[{
Cell[34140, 1172, 92, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[34235, 1176, 126, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[34376, 1182, 101, 1, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.14"}],

Cell[CellGroupData[{
Cell[34502, 1187, 71, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[34576, 1191, 100, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[34691, 1197, 815, 27, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.15"}],

Cell[CellGroupData[{
Cell[35531, 1228, 109, 2, 70, "Input",
  CellTags->"S1.5.3"],
Cell[35643, 1232, 86, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]],
Cell[35744, 1238, 260, 9, 70, "MathCaption",
  CellTags->{"S1.5.3", "3.16"}],

Cell[CellGroupData[{
Cell[36029, 1251, 137, 5, 70, "Input",
  CellTags->"S1.5.3"],
Cell[36169, 1258, 100, 3, 70, "Output",
  CellTags->"S1.5.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36318, 1267, 76, 1, 70, "Subsection",
  CellTags->{"S1.5.4", "4.1"}],
Cell[36397, 1270, 561, 20, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.2"}],

Cell[CellGroupData[{
Cell[36983, 1294, 85, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[37071, 1298, 149, 4, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[37235, 1305, 153, 5, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.3"}],

Cell[CellGroupData[{
Cell[37413, 1314, 82, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[37498, 1318, 149, 4, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[37662, 1325, 344, 11, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.4"}],

Cell[CellGroupData[{
Cell[38031, 1340, 88, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[38122, 1344, 102, 3, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[38239, 1350, 84, 1, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.5"}],

Cell[CellGroupData[{
Cell[38348, 1355, 89, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[38440, 1359, 131, 3, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[38586, 1365, 8269, 233, 70, "DefinitionBox",
  CellTags->"S1.5.4"],
Cell[46858, 1600, 60, 1, 70, "Caption",
  CellTags->"S1.5.4"],
Cell[46921, 1603, 236, 8, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.6"}],

Cell[CellGroupData[{
Cell[47182, 1615, 83, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[47268, 1619, 117, 3, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[47400, 1625, 159, 4, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.7"}],

Cell[CellGroupData[{
Cell[47584, 1633, 92, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[47679, 1637, 93, 3, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[47787, 1643, 129, 4, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.8"}],

Cell[CellGroupData[{
Cell[47941, 1651, 100, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[48044, 1655, 149, 4, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[48208, 1662, 140, 4, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.9"}],

Cell[CellGroupData[{
Cell[48373, 1670, 101, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[48477, 1674, 145, 4, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[48637, 1681, 132, 4, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.10"}],

Cell[CellGroupData[{
Cell[48794, 1689, 68, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[48865, 1693, 101, 3, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[48981, 1699, 2593, 98, 70, "Text",
  CellTags->{"S1.5.4", "4.11"}],
Cell[51577, 1799, 934, 31, 70, "MathCaption",
  CellTags->{"S1.5.4", "4.12"}],

Cell[CellGroupData[{
Cell[52536, 1834, 99, 2, 70, "Input",
  CellTags->"S1.5.4"],
Cell[52638, 1838, 152, 4, 70, "Output",
  CellTags->"S1.5.4"]
}, Open  ]],
Cell[52805, 1845, 710, 24, 70, "Text",
  CellTags->{"S1.5.4", "4.13"}],
Cell[53518, 1871, 8096, 237, 70, "DefinitionBox",
  CellTags->"S1.5.4"],
Cell[61617, 2110, 110, 4, 70, "Caption",
  CellTags->"S1.5.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61764, 2119, 68, 1, 70, "Subsection",
  CellTags->{"S1.5.5", "5.1"}],
Cell[61835, 2122, 775, 37, 70, "Text",
  CellTags->{"S1.5.5", "5.2"}],
Cell[62613, 2161, 311, 15, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.3"}],

Cell[CellGroupData[{
Cell[62949, 2180, 74, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[63026, 2184, 85, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[63126, 2190, 918, 39, 70, "Text",
  CellTags->{"S1.5.5", "5.4"}],
Cell[64047, 2231, 983, 34, 70, "DefinitionBox",
  CellTags->"S1.5.5"],
Cell[65033, 2267, 64, 1, 70, "Caption",
  CellTags->"S1.5.5"],
Cell[65100, 2270, 186, 9, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.5"}],

Cell[CellGroupData[{
Cell[65311, 2283, 69, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[65383, 2287, 82, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[65480, 2293, 159, 7, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.6"}],

Cell[CellGroupData[{
Cell[65664, 2304, 65, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[65732, 2308, 82, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[65829, 2314, 211, 9, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.7"}],

Cell[CellGroupData[{
Cell[66065, 2327, 70, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[66138, 2331, 85, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[66238, 2337, 172, 8, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.8"}],

Cell[CellGroupData[{
Cell[66435, 2349, 70, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[66508, 2353, 86, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[66609, 2359, 136, 5, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.9"}],
Cell[66748, 2366, 68, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[66819, 2370, 278, 8, 70, "Text",
  CellTags->{"S1.5.5", "5.10"}],
Cell[67100, 2380, 222, 6, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.11"}],

Cell[CellGroupData[{
Cell[67347, 2390, 70, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[67420, 2394, 93, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[67528, 2400, 229, 9, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.12"}],

Cell[CellGroupData[{
Cell[67782, 2413, 75, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[67860, 2417, 86, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[67961, 2423, 454, 10, 70, "Text",
  CellTags->{"S1.5.5", "5.13"}],
Cell[68418, 2435, 245, 9, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.14"}],

Cell[CellGroupData[{
Cell[68688, 2448, 86, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[68777, 2452, 85, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[68877, 2458, 256, 7, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.15"}],

Cell[CellGroupData[{
Cell[69158, 2469, 87, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[69248, 2473, 117, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[69380, 2479, 372, 15, 70, "Text",
  CellTags->{"S1.5.5", "5.16"}],
Cell[69755, 2496, 352, 13, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.17"}],

Cell[CellGroupData[{
Cell[70132, 2513, 83, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[70218, 2517, 113, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[70346, 2523, 94, 1, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.18"}],

Cell[CellGroupData[{
Cell[70465, 2528, 72, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[70540, 2532, 113, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]],
Cell[70668, 2538, 145, 5, 70, "MathCaption",
  CellTags->{"S1.5.5", "5.19"}],

Cell[CellGroupData[{
Cell[70838, 2547, 68, 2, 70, "Input",
  CellTags->"S1.5.5"],
Cell[70909, 2551, 113, 3, 70, "Output",
  CellTags->"S1.5.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71071, 2560, 91, 1, 70, "Subsection",
  CellTags->{"S1.5.6", "6.1"}],
Cell[71165, 2563, 3809, 126, 70, "DefinitionBox",
  CellTags->"S1.5.6"],
Cell[74977, 2691, 63, 1, 70, "Caption",
  CellTags->"S1.5.6"],
Cell[75043, 2694, 213, 9, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.2"}],

Cell[CellGroupData[{
Cell[75281, 2707, 70, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[75354, 2711, 86, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[75455, 2717, 157, 5, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.3"}],

Cell[CellGroupData[{
Cell[75637, 2726, 75, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[75715, 2730, 86, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[75816, 2736, 148, 7, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.4"}],

Cell[CellGroupData[{
Cell[75989, 2747, 74, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[76066, 2751, 85, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[76166, 2757, 194, 5, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.5"}],

Cell[CellGroupData[{
Cell[76385, 2766, 75, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[76463, 2770, 85, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[76563, 2776, 149, 4, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.6"}],

Cell[CellGroupData[{
Cell[76737, 2784, 69, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[76809, 2788, 86, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[76910, 2794, 5032, 165, 70, "DefinitionBox",
  CellTags->"S1.5.6"],
Cell[81945, 2961, 61, 1, 70, "Caption",
  CellTags->"S1.5.6"],
Cell[82009, 2964, 171, 7, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.7"}],

Cell[CellGroupData[{
Cell[82205, 2975, 79, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[82287, 2979, 85, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[82387, 2985, 402, 14, 70, "Text",
  CellTags->{"S1.5.6", "6.8"}],
Cell[82792, 3001, 149, 4, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.9"}],

Cell[CellGroupData[{
Cell[82966, 3009, 70, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[83039, 3013, 87, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[83141, 3019, 139, 4, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.10"}],

Cell[CellGroupData[{
Cell[83305, 3027, 85, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[83393, 3031, 115, 3, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]],
Cell[83523, 3037, 150, 5, 70, "MathCaption",
  CellTags->{"S1.5.6", "6.11"}],

Cell[CellGroupData[{
Cell[83698, 3046, 82, 2, 70, "Input",
  CellTags->"S1.5.6"],
Cell[83783, 3050, 145, 4, 70, "Output",
  CellTags->"S1.5.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[83977, 3060, 76, 1, 70, "Subsection",
  CellTags->{"S1.5.7", "7.1"}],
Cell[84056, 3063, 577, 27, 70, "Text",
  CellTags->{"S1.5.7", "7.2"}],
Cell[84636, 3092, 466, 14, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.3"}],

Cell[CellGroupData[{
Cell[85127, 3110, 91, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[85221, 3114, 141, 4, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[85377, 3121, 105, 1, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.4"}],

Cell[CellGroupData[{
Cell[85507, 3126, 70, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[85580, 3130, 163, 4, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[85758, 3137, 281, 9, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.5"}],

Cell[CellGroupData[{
Cell[86064, 3150, 70, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[86137, 3154, 128, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[86280, 3160, 172, 5, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.6"}],

Cell[CellGroupData[{
Cell[86477, 3169, 79, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[86559, 3173, 120, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[86694, 3179, 1381, 44, 70, "DefinitionBox",
  CellTags->"S1.5.7"],
Cell[88078, 3225, 83, 1, 70, "Caption",
  CellTags->"S1.5.7"],
Cell[88164, 3228, 679, 13, 70, "Text",
  CellTags->{"S1.5.7", "7.7"}],
Cell[88846, 3243, 201, 5, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.8"}],

Cell[CellGroupData[{
Cell[89072, 3252, 94, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[89169, 3256, 283, 5, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[89467, 3264, 110, 1, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.9"}],

Cell[CellGroupData[{
Cell[89602, 3269, 82, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[89687, 3273, 281, 6, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[89983, 3282, 323, 8, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.10"}],

Cell[CellGroupData[{
Cell[90331, 3294, 92, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[90426, 3298, 335, 7, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[90776, 3308, 157, 4, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.11"}],

Cell[CellGroupData[{
Cell[90958, 3316, 70, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[91031, 3320, 375, 8, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[91421, 3331, 224, 5, 70, "Text",
  CellTags->{"S1.5.7", "7.12"}],
Cell[91648, 3338, 176, 5, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.13"}],

Cell[CellGroupData[{
Cell[91849, 3347, 87, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[91939, 3351, 228, 4, 70, "Message",
  CellTags->"S1.5.7"],
Cell[92170, 3357, 104, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[92289, 3363, 740, 21, 70, "Text",
  CellTags->{"S1.5.7", "7.14"}],
Cell[93032, 3386, 197, 5, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.15"}],

Cell[CellGroupData[{
Cell[93254, 3395, 88, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[93345, 3399, 197, 4, 70, "Message",
  CellTags->"S1.5.7"],
Cell[93545, 3405, 109, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[93669, 3411, 225, 7, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.16"}],

Cell[CellGroupData[{
Cell[93919, 3422, 96, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[94018, 3426, 113, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[94146, 3432, 251, 6, 70, "Text",
  CellTags->{"S1.5.7", "7.17"}],
Cell[94400, 3440, 196, 6, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.18"}],

Cell[CellGroupData[{
Cell[94621, 3450, 88, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[94712, 3454, 186, 4, 70, "Message",
  CellTags->"S1.5.7"],
Cell[94901, 3460, 667, 20, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[95583, 3483, 1943, 58, 70, "DefinitionBox",
  CellTags->"S1.5.7"],
Cell[97529, 3543, 81, 1, 70, "Caption",
  CellTags->"S1.5.7"],
Cell[97613, 3546, 251, 6, 70, "Text",
  CellTags->{"S1.5.7", "7.19"}],
Cell[97867, 3554, 383, 14, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.20"}],

Cell[CellGroupData[{
Cell[98275, 3572, 114, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[98392, 3576, 178, 4, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[98585, 3583, 254, 8, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.21"}],

Cell[CellGroupData[{
Cell[98864, 3595, 110, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[98977, 3599, 189, 4, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[99181, 3606, 213, 9, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.22"}],

Cell[CellGroupData[{
Cell[99419, 3619, 75, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[99497, 3623, 111, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[99623, 3629, 409, 9, 70, "Text",
  CellTags->{"S1.5.7", "7.23"}],
Cell[100035, 3640, 222, 5, 70, "Text",
  CellTags->{"S1.5.7", "7.24"}],
Cell[100260, 3647, 224, 8, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.25"}],

Cell[CellGroupData[{
Cell[100509, 3659, 113, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[100625, 3663, 114, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[100754, 3669, 216, 5, 70, "Text",
  CellTags->{"S1.5.7", "7.26"}],
Cell[100973, 3676, 253, 7, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.27"}],

Cell[CellGroupData[{
Cell[101251, 3687, 87, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[101341, 3691, 84, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[101440, 3697, 203, 6, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.28"}],

Cell[CellGroupData[{
Cell[101668, 3707, 87, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[101758, 3711, 84, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[101857, 3717, 775, 23, 70, "Text",
  CellTags->{"S1.5.7", "7.29"}],
Cell[102635, 3742, 358, 12, 70, "Text",
  CellTags->{"S1.5.7", "7.30"}],
Cell[102996, 3756, 478, 21, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.31"}],

Cell[CellGroupData[{
Cell[103499, 3781, 88, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[103590, 3785, 110, 3, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[103715, 3791, 349, 8, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.32"}],

Cell[CellGroupData[{
Cell[104089, 3803, 88, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[104180, 3807, 171, 4, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[104366, 3814, 111, 1, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.33"}],

Cell[CellGroupData[{
Cell[104502, 3819, 90, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[104595, 3823, 241, 6, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[104851, 3832, 110, 1, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.34"}],

Cell[CellGroupData[{
Cell[104986, 3837, 87, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[105076, 3841, 222, 5, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[105313, 3849, 5599, 168, 70, "DefinitionBox",
  CellTags->"S1.5.7"],
Cell[110915, 4019, 91, 1, 70, "Caption",
  CellTags->"S1.5.7"],
Cell[111009, 4022, 328, 9, 70, "Text",
  CellTags->{"S1.5.7", "7.35"}],
Cell[111340, 4033, 183, 7, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.36"}],

Cell[CellGroupData[{
Cell[111548, 4044, 90, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[111641, 4048, 143, 4, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[111799, 4055, 180, 7, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.37"}],

Cell[CellGroupData[{
Cell[112004, 4066, 97, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[112104, 4070, 207, 5, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]],
Cell[112326, 4078, 94, 1, 70, "MathCaption",
  CellTags->{"S1.5.7", "7.38"}],

Cell[CellGroupData[{
Cell[112445, 4083, 100, 2, 70, "Input",
  CellTags->"S1.5.7"],
Cell[112548, 4087, 262, 5, 70, "Output",
  CellTags->"S1.5.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[112859, 4098, 71, 1, 70, "Subsection",
  CellTags->{"S1.5.8", "8.1"}],
Cell[112933, 4101, 1388, 44, 70, "DefinitionBox",
  CellTags->"S1.5.8"],
Cell[114324, 4147, 64, 1, 70, "Caption",
  CellTags->"S1.5.8"],
Cell[114391, 4150, 102, 1, 70, "MathCaption",
  CellTags->{"S1.5.8", "8.2"}],

Cell[CellGroupData[{
Cell[114518, 4155, 102, 2, 70, "Input",
  CellTags->"S1.5.8"],
Cell[114623, 4159, 110, 3, 70, "Output",
  CellTags->"S1.5.8"]
}, Open  ]],
Cell[114748, 4165, 97, 1, 70, "MathCaption",
  CellTags->{"S1.5.8", "8.3"}],

Cell[CellGroupData[{
Cell[114870, 4170, 102, 2, 70, "Input",
  CellTags->"S1.5.8"],
Cell[114975, 4174, 86, 3, 70, "Output",
  CellTags->"S1.5.8"]
}, Open  ]],
Cell[115076, 4180, 108, 1, 70, "MathCaption",
  CellTags->{"S1.5.8", "8.4"}],

Cell[CellGroupData[{
Cell[115209, 4185, 104, 2, 70, "Input",
  CellTags->"S1.5.8"],
Cell[115316, 4189, 362, 8, 70, "Output",
  CellTags->"S1.5.8"]
}, Open  ]],
Cell[115693, 4200, 371, 8, 70, "Text",
  CellTags->{"S1.5.8", "8.5"}],
Cell[116067, 4210, 128, 4, 70, "MathCaption",
  CellTags->{"S1.5.8", "8.6"}],

Cell[CellGroupData[{
Cell[116220, 4218, 110, 2, 70, "Input",
  CellTags->"S1.5.8"],
Cell[116333, 4222, 117, 3, 70, "Output",
  CellTags->"S1.5.8"]
}, Open  ]],
Cell[116465, 4228, 1764, 58, 70, "DefinitionBox",
  CellTags->"S1.5.8"],
Cell[118232, 4288, 84, 1, 70, "Caption",
  CellTags->"S1.5.8"],
Cell[118319, 4291, 109, 1, 70, "MathCaption",
  CellTags->{"S1.5.8", "8.7"}],

Cell[CellGroupData[{
Cell[118453, 4296, 107, 2, 70, "Input",
  CellTags->"S1.5.8"],
Cell[118563, 4300, 132, 3, 70, "Output",
  CellTags->"S1.5.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[118744, 4309, 81, 1, 70, "Subsection",
  CellTags->{"S1.5.9", "9.1"}],
Cell[118828, 4312, 1464, 45, 70, "DefinitionBox",
  CellTags->"S1.5.9"],
Cell[120295, 4359, 84, 1, 70, "Caption",
  CellTags->"S1.5.9"],
Cell[120382, 4362, 663, 22, 70, "MathCaption",
  CellTags->{"S1.5.9", "9.2"}],

Cell[CellGroupData[{
Cell[121070, 4388, 102, 2, 70, "Input",
  CellTags->"S1.5.9"],
Cell[121175, 4392, 175, 5, 70, "Output",
  CellTags->"S1.5.9"]
}, Open  ]],
Cell[121365, 4400, 169, 4, 70, "MathCaption",
  CellTags->{"S1.5.9", "9.3"}],

Cell[CellGroupData[{
Cell[121559, 4408, 115, 2, 70, "Input",
  CellTags->"S1.5.9"],
Cell[121677, 4412, 141, 4, 70, "Output",
  CellTags->"S1.5.9"]
}, Open  ]],
Cell[121833, 4419, 2347, 89, 70, "Text",
  CellTags->{"S1.5.9", "9.4"}],
Cell[124183, 4510, 568, 15, 70, "Text",
  CellTags->{"S1.5.9", "9.5"}],
Cell[124754, 4527, 222, 5, 70, "MathCaption",
  CellTags->{"S1.5.9", "9.6"}],

Cell[CellGroupData[{
Cell[125001, 4536, 121, 2, 70, "Input",
  CellTags->"S1.5.9"],
Cell[125125, 4540, 469, 11, 70, "Output",
  CellTags->"S1.5.9"]
}, Open  ]],
Cell[125609, 4554, 597, 18, 70, "Text",
  CellTags->{"S1.5.9", "9.7"}],
Cell[126209, 4574, 195, 5, 70, "MathCaption",
  CellTags->{"S1.5.9", "9.8"}],

Cell[CellGroupData[{
Cell[126429, 4583, 97, 2, 70, "Input",
  CellTags->"S1.5.9"],
Cell[126529, 4587, 160, 5, 70, "Output",
  CellTags->"S1.5.9"]
}, Open  ]],
Cell[126704, 4595, 192, 6, 70, "MathCaption",
  CellTags->{"S1.5.9", "9.9"}],

Cell[CellGroupData[{
Cell[126921, 4605, 82, 2, 70, "Input",
  CellTags->"S1.5.9"],
Cell[127006, 4609, 123, 3, 70, "Output",
  CellTags->"S1.5.9"]
}, Open  ]],
Cell[127144, 4615, 365, 12, 70, "Text",
  CellTags->{"S1.5.9", "9.10"}],
Cell[127512, 4629, 283, 7, 70, "Text",
  CellTags->{"S1.5.9", "9.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[127832, 4641, 74, 1, 70, "Subsection",
  CellTags->{"S1.5.10", "10.1"}],
Cell[127909, 4644, 212, 5, 70, "Text",
  CellTags->{"S1.5.10", "10.2"}],
Cell[128124, 4651, 313, 8, 70, "Text",
  CellTags->{"S1.5.10", "10.3"}],
Cell[128440, 4661, 744, 27, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.4"}],

Cell[CellGroupData[{
Cell[129209, 4692, 93, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[129305, 4696, 601, 18, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[129921, 4717, 173, 4, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.5"}],

Cell[CellGroupData[{
Cell[130119, 4725, 108, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[130230, 4729, 1026, 34, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[131271, 4766, 209, 5, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.6"}],

Cell[CellGroupData[{
Cell[131505, 4775, 92, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[131600, 4779, 734, 21, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[132349, 4803, 484, 9, 70, "Text",
  CellTags->{"S1.5.10", "10.7"}],
Cell[132836, 4814, 270, 9, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.8"}],

Cell[CellGroupData[{
Cell[133131, 4827, 90, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[133224, 4831, 505, 15, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[133744, 4849, 203, 6, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.9"}],

Cell[CellGroupData[{
Cell[133972, 4859, 76, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[134051, 4863, 544, 15, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[134610, 4881, 129, 4, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.10"}],

Cell[CellGroupData[{
Cell[134764, 4889, 74, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[134841, 4893, 173, 5, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[135029, 4901, 137, 5, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.11"}],

Cell[CellGroupData[{
Cell[135191, 4910, 68, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[135262, 4914, 175, 4, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[135452, 4921, 151, 5, 70, "MathCaption",
  CellTags->{"S1.5.10", "10.12"}],

Cell[CellGroupData[{
Cell[135628, 4930, 74, 2, 70, "Input",
  CellTags->"S1.5.10"],
Cell[135705, 4934, 282, 6, 70, "Output",
  CellTags->"S1.5.10"]
}, Open  ]],
Cell[136002, 4943, 1760, 51, 70, "DefinitionBox",
  CellTags->"S1.5.10"],
Cell[137765, 4996, 67, 1, 70, "Caption",
  CellTags->"S1.5.10"]
}, Open  ]],

Cell[CellGroupData[{
Cell[137869, 5002, 68, 1, 70, "Subsection",
  CellTags->{"S1.5.11", "11.1"}],
Cell[137940, 5005, 324, 12, 70, "MathCaption",
  CellTags->{"S1.5.11", "11.2"}],

Cell[CellGroupData[{
Cell[138289, 5021, 77, 2, 70, "Input",
  CellTags->"S1.5.11"],
Cell[138369, 5025, 91, 3, 70, "Output",
  CellTags->"S1.5.11"]
}, Open  ]],
Cell[138475, 5031, 244, 9, 70, "MathCaption",
  CellTags->{"S1.5.11", "11.3"}],

Cell[CellGroupData[{
Cell[138744, 5044, 74, 2, 70, "Input",
  CellTags->"S1.5.11"],
Cell[138821, 5048, 140, 3, 70, "Message",
  CellTags->"S1.5.11"],
Cell[138964, 5053, 169, 4, 70, "Message",
  CellTags->"S1.5.11"],
Cell[139136, 5059, 95, 3, 70, "Output",
  CellTags->"S1.5.11"]
}, Open  ]],
Cell[139246, 5065, 651, 23, 70, "MathCaption",
  CellTags->{"S1.5.11", "11.4"}],

Cell[CellGroupData[{
Cell[139922, 5092, 77, 2, 70, "Input",
  CellTags->"S1.5.11"],
Cell[140002, 5096, 101, 3, 70, "Output",
  CellTags->"S1.5.11"]
}, Open  ]],
Cell[140118, 5102, 647, 25, 70, "MathCaption",
  CellTags->{"S1.5.11", "11.5"}],

Cell[CellGroupData[{
Cell[140790, 5131, 79, 2, 70, "Input",
  CellTags->"S1.5.11"],
Cell[140872, 5135, 83, 3, 70, "Output",
  CellTags->"S1.5.11"]
}, Open  ]],
Cell[140970, 5141, 1111, 33, 70, "DefinitionBox",
  CellTags->"S1.5.11"],
Cell[142084, 5176, 50, 1, 70, "Caption",
  CellTags->"S1.5.11"]
}, Open  ]],

Cell[CellGroupData[{
Cell[142171, 5182, 81, 1, 70, "Subsection",
  CellTags->{"S1.5.12", "12.1"}],
Cell[142255, 5185, 1224, 38, 70, "DefinitionBox",
  CellTags->"S1.5.12"],
Cell[143482, 5225, 62, 1, 70, "Caption",
  CellTags->"S1.5.12"],
Cell[143547, 5228, 91, 1, 70, "MathCaption",
  CellTags->{"S1.5.12", "12.2"}],

Cell[CellGroupData[{
Cell[143663, 5233, 101, 2, 70, "Input",
  CellTags->"S1.5.12"],
Cell[143767, 5237, 99, 3, 70, "Output",
  CellTags->"S1.5.12"]
}, Open  ]],
Cell[143881, 5243, 87, 1, 70, "MathCaption",
  CellTags->{"S1.5.12", "12.3"}],

Cell[CellGroupData[{
Cell[143993, 5248, 97, 2, 70, "Input",
  CellTags->"S1.5.12"],
Cell[144093, 5252, 113, 3, 70, "Output",
  CellTags->"S1.5.12"]
}, Open  ]],
Cell[144221, 5258, 1233, 38, 70, "DefinitionBox",
  CellTags->"S1.5.12"],
Cell[145457, 5298, 62, 1, 70, "Caption",
  CellTags->"S1.5.12"],
Cell[145522, 5301, 91, 1, 70, "MathCaption",
  CellTags->{"S1.5.12", "12.4"}],

Cell[CellGroupData[{
Cell[145638, 5306, 102, 2, 70, "Input",
  CellTags->"S1.5.12"],
Cell[145743, 5310, 162, 4, 70, "Output",
  CellTags->"S1.5.12"]
}, Open  ]],
Cell[145920, 5317, 87, 1, 70, "MathCaption",
  CellTags->{"S1.5.12", "12.5"}],

Cell[CellGroupData[{
Cell[146032, 5322, 97, 2, 70, "Input",
  CellTags->"S1.5.12"],
Cell[146132, 5326, 114, 3, 70, "Output",
  CellTags->"S1.5.12"]
}, Open  ]],
Cell[146261, 5332, 358, 10, 70, "Text",
  CellTags->{"S1.5.12", "12.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[146656, 5347, 82, 1, 70, "Subsection",
  CellTags->{"S1.5.13", "13.1"}],
Cell[146741, 5350, 932, 29, 70, "DefinitionBox",
  CellTags->"S1.5.13"],
Cell[147676, 5381, 72, 1, 70, "Caption",
  CellTags->"S1.5.13"],
Cell[147751, 5384, 98, 1, 70, "MathCaption",
  CellTags->{"S1.5.13", "13.2"}],

Cell[CellGroupData[{
Cell[147874, 5389, 111, 2, 70, "Input",
  CellTags->"S1.5.13"],
Cell[147988, 5393, 124, 3, 70, "Output",
  CellTags->"S1.5.13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148161, 5402, 95, 1, 70, "Subsection",
  CellTags->{"S1.5.14", "14.1"}],
Cell[148259, 5405, 642, 18, 70, "Text",
  CellTags->{"S1.5.14", "14.2"}],

Cell[CellGroupData[{
Cell[148926, 5427, 73, 1, 70, "Subsubsection",
  CellTags->{"S1.5.14", "14.3"}],
Cell[149002, 5430, 3147, 90, 70, "DefinitionBox",
  CellTags->"S1.5.14"],
Cell[152152, 5522, 59, 1, 70, "Caption",
  CellTags->"S1.5.14"],
Cell[152214, 5525, 222, 5, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.4"}],
Cell[152439, 5532, 91, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[152533, 5536, 261, 9, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.5"}],

Cell[CellGroupData[{
Cell[152819, 5549, 105, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[152927, 5553, 106, 3, 70, "Output",
  CellTags->"S1.5.14"]
}, Open  ]],
Cell[153048, 5559, 340, 11, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.6"}],

Cell[CellGroupData[{
Cell[153413, 5574, 85, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[153501, 5578, 118, 3, 70, "Output",
  CellTags->"S1.5.14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[153668, 5587, 77, 1, 70, "Subsubsection",
  CellTags->{"S1.5.14", "14.7"}],
Cell[153748, 5590, 946, 28, 70, "DefinitionBox",
  CellTags->"S1.5.14"],
Cell[154697, 5620, 63, 1, 70, "Caption",
  CellTags->"S1.5.14"],
Cell[154763, 5623, 100, 1, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.8"}],
Cell[154866, 5626, 95, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[154964, 5630, 562, 20, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.9"}],

Cell[CellGroupData[{
Cell[155551, 5654, 104, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[155658, 5658, 657, 19, 70, "Output",
  CellTags->"S1.5.14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[156364, 5683, 70, 1, 70, "Subsubsection",
  CellTags->{"S1.5.14", "14.10"}],
Cell[156437, 5686, 1504, 45, 70, "DefinitionBox",
  CellTags->"S1.5.14"],
Cell[157944, 5733, 55, 1, 70, "Caption",
  CellTags->"S1.5.14"],
Cell[158002, 5736, 93, 1, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.11"}],
Cell[158098, 5739, 87, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[158188, 5743, 111, 1, 70, "MathCaption",
  CellTags->{"S1.5.14", "14.12"}],

Cell[CellGroupData[{
Cell[158324, 5748, 93, 2, 70, "Input",
  CellTags->"S1.5.14"],
Cell[158420, 5752, 232, 6, 70, "Output",
  CellTags->"S1.5.14"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[158713, 5765, 125, 4, 70, "Subsection",
  CellTags->{"S1.5.15", "15.1"}],
Cell[158841, 5771, 453, 16, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.2"}],

Cell[CellGroupData[{
Cell[159319, 5791, 82, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[159404, 5795, 105, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[159524, 5801, 290, 9, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.3"}],

Cell[CellGroupData[{
Cell[159839, 5814, 83, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[159925, 5818, 88, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[160028, 5824, 337, 6, 70, "Text",
  CellTags->{"S1.5.15", "15.4"}],
Cell[160368, 5832, 345, 13, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.5"}],

Cell[CellGroupData[{
Cell[160738, 5849, 70, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[160811, 5853, 83, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[160909, 5859, 244, 8, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.6"}],

Cell[CellGroupData[{
Cell[161178, 5871, 70, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[161251, 5875, 140, 3, 70, "Message",
  CellTags->"S1.5.15"],
Cell[161394, 5880, 169, 4, 70, "Message",
  CellTags->"S1.5.15"],
Cell[161566, 5886, 95, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[161676, 5892, 136, 4, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.7"}],

Cell[CellGroupData[{
Cell[161837, 5900, 93, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[161933, 5904, 119, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[162067, 5910, 520, 14, 70, "Text",
  CellTags->{"S1.5.15", "15.8"}],
Cell[162590, 5926, 266, 6, 70, "Text",
  CellTags->{"S1.5.15", "15.9"}],
Cell[162859, 5934, 387, 14, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.10"}],

Cell[CellGroupData[{
Cell[163271, 5952, 74, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[163348, 5956, 88, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[163451, 5962, 213, 6, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.11"}],

Cell[CellGroupData[{
Cell[163689, 5972, 77, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[163769, 5976, 83, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]],
Cell[163867, 5982, 273, 8, 70, "MathCaption",
  CellTags->{"S1.5.15", "15.12"}],

Cell[CellGroupData[{
Cell[164165, 5994, 91, 2, 70, "Input",
  CellTags->"S1.5.15"],
Cell[164259, 5998, 83, 3, 70, "Output",
  CellTags->"S1.5.15"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[164391, 6007, 96, 1, 70, "Subsection",
  CellTags->{"S1.5.16", "16.1"}],
Cell[164490, 6010, 231, 6, 70, "Text",
  CellTags->{"S1.5.16", "16.2"}],
Cell[164724, 6018, 6714, 194, 70, "DefinitionBox3Col",
  CellTags->"S1.5.16"],
Cell[171441, 6214, 125, 4, 70, "Caption",
  CellTags->"S1.5.16"],
Cell[171569, 6220, 325, 6, 88, "MathCaption",
  CellTags->{"S1.5.16", "16.3"}],
Cell[171897, 6228, 23689, 297, 70, 23553, 292, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.5.16"],
Cell[195589, 6527, 3982, 114, 330, "DefinitionBox",
  CellTags->"S1.5.16"],
Cell[199574, 6643, 133, 4, 16, "Caption",
  CellTags->"S1.5.16"],
Cell[199710, 6649, 375, 11, 56, "MathCaption",
  CellTags->{"S1.5.16", "16.4"}],

Cell[CellGroupData[{
Cell[200110, 6664, 115, 3, 40, "Input",
  CellTags->"S1.5.16"],
Cell[200228, 6669, 105, 3, 44, "Output",
  CellTags->"S1.5.16"]
}, Open  ]],
Cell[200348, 6675, 117, 2, 40, "MathCaption",
  CellTags->{"S1.5.16", "16.5"}],

Cell[CellGroupData[{
Cell[200490, 6681, 398, 13, 28, "Input",
  CellTags->"S1.5.16"],
Cell[200891, 6696, 105, 3, 44, "Output",
  CellTags->"S1.5.16"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

