(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     80729,       2840]*)
(*NotebookOutlinePosition[    100146,       3415]*)
(*  CellTagsIndexPosition[     98560,       3347]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.6 ", "HeadingNumber"],
  "Numerical Mathematics"
}], "Section",
  CellTags->{"S1.6.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.6.1 Basic Operations", "Subsection",
  CellTags->{"S1.6.1", "1.1"}],

Cell["\<\
Exact symbolic results are usually very desirable when they can be \
found. In many calculations, however, it is not possible to get symbolic \
results. In such cases, you must resort to numerical methods. \
\>", "Text",
  CellTags->{"S1.6.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical value of an expression (see Section ",
              ButtonBox["1.1",
                ButtonData:>{"1.1"},
                ButtonStyle->"MainBookLink"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["NIntegrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical approximation to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], " ", 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"]
            }]]},
          {Cell[TextData[{
              StyleBox["NSum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Infinity}]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical approximation to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], "\[Infinity]",
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindRoot[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "search for a numerical solution to an equation, starting with \
",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NSolve[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "numerical approximations to all solutions of an equation "]},
          {Cell[TextData[{
              StyleBox["FindMinimum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "search for a minimum of ",
              StyleBox["f", "TI"],
              ", starting with ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NMinimize[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "attempt to find the global minimum of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.1"],

Cell["Basic numerical operations. ", "Caption",
  CellTags->"S1.6.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " maintains this expression in an exact, symbolic, form. "
}], "MathCaption",
  CellTags->{"S1.6.1", "1.3"}],

Cell[CellGroupData[{

Cell["(3 + Sqrt[2])^3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.1"],

Cell[BoxData[
    \(\((3 + \@2)\)\^3\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.1"]
}, Open  ]],

Cell["You can even use standard symbolic operations on it. ", "MathCaption",
  CellTags->{"S1.6.1", "1.4"}],

Cell[CellGroupData[{

Cell["Expand[ % ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.1"],

Cell[BoxData[
    \(45 + 29\ \@2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["N[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives you a numerical approximation. "
}], "MathCaption",
  CellTags->{"S1.6.1", "1.5"}],

Cell[CellGroupData[{

Cell["N[ % ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.1"],

Cell[BoxData[
    \(86.01219330881976`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.6.1"]
}, Open  ]],

Cell[TextData[{
  "Functions such as ",
  StyleBox["Integrate", "MR"],
  " always try to get exact results for computations. When they cannot get \
exact results, they typically return unevaluated. You can then find numerical \
approximations by explicitly applying ",
  StyleBox["N", "MR"],
  ". Functions such as ",
  StyleBox["NIntegrate", "MR"],
  " do the calculations numerically from the start, without first trying to \
get an exact result. "
}], "Text",
  CellTags->{"S1.6.1", "1.6"}],

Cell[TextData[{
  "There is no exact formula for this integral, so ",
  StyleBox["Mathematica", "TI"],
  " returns it unevaluated. "
}], "MathCaption",
  CellTags->{"S1.6.1", "1.7"}],

Cell[CellGroupData[{

Cell["Integrate[Sin[Sin[x]], {x, 1, 2}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.6.1"],

Cell[BoxData[
    \(\[Integral]\_1\%2 Sin[Sin[x]] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.6.1"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["N", "MR"],
  " to get an approximate numerical result. "
}], "MathCaption",
  CellTags->{"S1.6.1", "1.8"}],

Cell[CellGroupData[{

Cell["N[ % ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.6.1"],

Cell[BoxData[
    \(0.8164499551233124`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " does the integral numerically from the start. "
}], "MathCaption",
  CellTags->{"S1.6.1", "1.9"}],

Cell[CellGroupData[{

Cell["NIntegrate[Sin[Sin[x]], {x, 1, 2}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.6.1"],

Cell[BoxData[
    \(0.8164499551233124`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.6.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.2 Numerical Sums, Products and Integrals", "Subsection",
  CellTags->{"S1.6.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NSum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Infinity}]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical approximation to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Sum]", 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], "\[Infinity]",
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NProduct[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Infinity}]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical approximation to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      UnderoverscriptBox["\[Product]", 
                        SubscriptBox[
                          StyleBox["i",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], "\[Infinity]",
                        LimitsPositioning->True], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NIntegrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "numerical approximation to ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], " ", 
                      StyleBox["f",
                        "TI"], " ", 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"]
            }]]},
          {Cell[TextData[{
              StyleBox["NIntegrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the multiple integral ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["x",
                        "TI"], 
                      SubsuperscriptBox["\[Integral]", 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["min",
                            "TI"]], 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["max",
                            "TI"]]], 
                      StyleBox["d",
                        "TI"], 
                      StyleBox["y",
                        "TI"], " ", 
                      StyleBox["f",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.2"],

Cell["Numerical sums, products and integrals. ", "Caption",
  CellTags->"S1.6.2"],

Cell[TextData[{
  "Here is a numerical approximation to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          UnderoverscriptBox["\[Sum]", 
            RowBox[{
              StyleBox["i",
                "TI"], "=", "1"}], "\[Infinity]",
            LimitsPositioning->True], 
          FractionBox["1", 
            SuperscriptBox[
              StyleBox["i",
                "TI"], "3"]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.2", "2.2"}],

Cell[CellGroupData[{

Cell["NSum[1/i^3, {i, 1, Infinity}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.2"],

Cell[BoxData[
    \(1.2020569031403265`\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NIntegrate", "MR"],
  " can handle singularities at the end points of the integration region. "
}], "MathCaption",
  CellTags->{"S1.6.2", "2.3"}],

Cell[CellGroupData[{

Cell["NIntegrate[1/Sqrt[x (1-x)], {x, 0, 1}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.2"],

Cell[BoxData[
    \(3.1415926578348596`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.6.2"]
}, Open  ]],

Cell["You can do numerical integrals over infinite regions. ", "MathCaption",
  CellTags->{"S1.6.2", "2.4"}],

Cell[CellGroupData[{

Cell["NIntegrate[Exp[-x^2], {x, -Infinity, Infinity}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.2"],

Cell[BoxData[
    \(1.7724538504129463`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.6.2"]
}, Open  ]],

Cell["\<\
Here is a double integral over a triangular domain. Note the order \
in which the variables are given. \
\>", "MathCaption",
  CellTags->{"S1.6.2", "2.5"}],

Cell[CellGroupData[{

Cell["NIntegrate[ Sin[x y], {x, 0, 1}, {y, 0, x} ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.6.2"],

Cell[BoxData[
    \(0.11990587168081977`\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.6.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.3 Numerical Equation Solving", "Subsection",
  CellTags->{"S1.6.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NSolve[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["solve a polynomial equation numerically "]},
          {Cell[TextData[{
              StyleBox["NSolve[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[
            "solve a system of polynomial equations numerically "]},
          {Cell[TextData[{
              StyleBox["FindRoot[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["==", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "search for a numerical solution to an equation, starting at ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindRoot[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["==", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[
            "search for numerical solutions to simultaneous equations "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.3"],

Cell["Numerical root finding. ", "Caption",
  CellTags->"S1.6.3"],

Cell[TextData[{
  StyleBox["NSolve", "MR"],
  " gives you numerical approximations to all the roots of a polynomial \
equation. "
}], "MathCaption",
  CellTags->{"S1.6.3", "3.2"}],

Cell[CellGroupData[{

Cell["NSolve[ x^5 + x + 1 == 0, x ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.3"],

Cell[BoxData[
    \({{x \[Rule] \(-0.7548776662466926`\)}, {x \[Rule] \(-0.5`\) - 
            0.8660254037844386`\ \[ImaginaryI]}, {x \[Rule] \(-0.5`\) + 
            0.8660254037844386`\ \[ImaginaryI]}, {x \[Rule] \
\(\(0.8774388331233463`\)\(\[InvisibleSpace]\)\) - 
            0.7448617666197443`\ \[ImaginaryI]}, {x \[Rule] \
\(\(0.8774388331233463`\)\(\[InvisibleSpace]\)\) + 
            0.7448617666197443`\ \[ImaginaryI]}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.3"]
}, Open  ]],

Cell[TextData[{
  "You can also use ",
  StyleBox["NSolve", "MR"],
  " to solve sets of simultaneous equations numerically. "
}], "MathCaption",
  CellTags->{"S1.6.3", "3.3"}],

Cell[CellGroupData[{

Cell["\<\
NSolve[{x + y == 2, x - 3 y + z == 3, x - y + z == 0}, {x, y, z}]\
\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.3"],

Cell[BoxData[
    \({{x \[Rule] 3.5`, y \[Rule] \(-1.5`\), z \[Rule] \(-5.`\)}}\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"S1.6.3"]
}, Open  ]],

Cell[TextData[{
  "If your equations involve only linear functions or polynomials, then you \
can use ",
  StyleBox["NSolve", "MR"],
  " to get numerical approximations to all the solutions. However, when your \
equations involve more complicated functions, there is in general no \
systematic procedure for finding all solutions, even numerically. In such \
cases, you can use ",
  StyleBox["FindRoot", "MR"],
  " to search for solutions. You have to give ",
  StyleBox["FindRoot", "MR"],
  " a place to start its search. "
}], "Text",
  CellTags->{"S1.6.3", "3.4"}],

Cell[TextData[{
  "This searches for a numerical solution, starting at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.3", "3.5"}],

Cell[CellGroupData[{

Cell["FindRoot[ 3 Cos[x] == Log[x], {x, 1} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.3"],

Cell[BoxData[
    \({x \[Rule] 1.447258617277903`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.6.3"]
}, Open  ]],

Cell[TextData[{
  "The equation has several solutions. If you start at a different ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  StyleBox["FindRoot", "MR"],
  " may return a different solution. "
}], "MathCaption",
  CellTags->{"S1.6.3", "3.6"}],

Cell[CellGroupData[{

Cell["FindRoot[ 3 Cos[x] == Log[x], {x, 10} ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.6.3"],

Cell[BoxData[
    \({x \[Rule] 13.10638768062491`}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.6.3"]
}, Open  ]],

Cell["\<\
You can search for solutions to sets of equations. Here the \
solution involves complex numbers. \
\>", "MathCaption",
  CellTags->{"S1.6.3", "3.7"}],

Cell[CellGroupData[{

Cell["FindRoot[{x==Log[y], y==Log[x]}, {{x, I}, {y, 2}}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.6.3"],

Cell[BoxData[
    \({x \[Rule] \(\(0.3181315052047642`\)\(\[InvisibleSpace]\)\) + 
          1.3372357014306895`\ \[ImaginaryI], 
      y \[Rule] \(\(0.3181315052047641`\)\(\[InvisibleSpace]\)\) + 
          1.3372357014306895`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.6.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.4 Numerical Differential Equations", "Subsection",
  CellTags->{"S1.6.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NDSolve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve numerically for the function ",
              StyleBox["y", "TI"],
              ", with the independent variable ",
              StyleBox["x", "TI"],
              " in the range ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NDSolve[", "MR"],
              StyleBox["eqns", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "solve a system of equations for the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.4"],

Cell["Numerical solution of differential equations. ", "Caption",
  CellTags->"S1.6.4"],

Cell[TextData[{
  "This generates a numerical solution to the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " with ",
  Cell[BoxData[
      FormBox[
        RowBox[{"0", "<", 
          StyleBox["x",
            "TI"], "<", "2"}], TraditionalForm]], "InlineFormula"],
  ". The result is given in terms of an ",
  StyleBox["InterpolatingFunction", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.4", "4.2"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == y[x], y[0] == 1}, y, {x, 0, 2}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.4"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], \((1.5)\)}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.4", "4.3"}],

Cell[CellGroupData[{

Cell["y[1.5] /. %", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.4"],

Cell[BoxData[
    \({4.481685650645397`}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[TextData[{
  "With an algebraic equation such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"], "+", "3", 
          StyleBox["x",
            "TI"], "+", "1", "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", each solution for ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is simply a single number. For a differential equation, however, the \
solution is a ",
  StyleBox["function", "TI"],
  ", rather than a single number. For example, in the equation ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["y",
              "TI"], "\[Prime]"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", you want to get an approximation to the function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " as the independent variable ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " varies over some range. "
}], "Text",
  CellTags->{"S1.6.4", "4.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " represents numerical approximations to functions as ",
  StyleBox["InterpolatingFunction", "MR"],
  " objects. These objects are functions which, when applied to a particular \
",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", return the approximate value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " at that point. The ",
  StyleBox["InterpolatingFunction", "MR"],
  " effectively stores a table of values for ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            SubscriptBox[
              StyleBox["x",
                "TI"], 
              StyleBox["i",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", then interpolates this table to find an approximation to ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " at the particular ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " you request. "
}], "Text",
  CellTags->{"S1.6.4", "4.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["solution", "TI"],
              " "
            }]], Cell[TextData[{
              "use the list of rules for the function ",
              StyleBox["y", "TI"],
              " to get values for ",
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InterpolatingFunction[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["][", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate an interpolated function at the point ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Plot[Evaluate[", "MR"],
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["solution", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["plot the solution to a differential equation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.4"],

Cell[TextData[{
  "Using results from ",
  StyleBox["NDSolve", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.6.4"],

Cell["This solves a system of two coupled differential equations. ", \
"MathCaption",
  CellTags->{"S1.6.4", "4.6"}],

Cell[CellGroupData[{

Cell["\<\
NDSolve[ {y'[x] == z[x], z'[x] == -y[x], y[0] == 0, z[0] == 1}, {y, \
z}, {x, 0, Pi} ]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.4"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"y", "\[Rule]", 
            
            TagBox[\(InterpolatingFunction[{{0.`, 3.141592653589793`}}, 
                "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"z", "\[Rule]", 
            
            TagBox[\(InterpolatingFunction[{{0.`, 3.141592653589793`}}, 
                "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the value of ",
  StyleBox["z[2]", "MR"],
  " found from the solution. "
}], "MathCaption",
  CellTags->{"S1.6.4", "4.7"}],

Cell[CellGroupData[{

Cell["z[2] /. %", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.6.4"],

Cell[BoxData[
    \({\(-0.4161465105807504`\)}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot of the solution for ",
  StyleBox["z[x]", "MR"],
  " found on line 3. ",
  StyleBox["Plot", "MR"],
  " is discussed in Section ",
  ButtonBox["1.9.1",
    ButtonData:>{"1.9.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.4", "4.8"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[z[x] /. %3], {x, 0, Pi}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.6.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.309017 0.294302 [
[.17539 .29652 -9 -9 ]
[.17539 .29652 9 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -9 -9 ]
[.47854 .29652 9 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -9 -9 ]
[.78169 .29652 9 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(0.5)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(1)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(1.5)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(2)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(2.5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(3)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60332 L
.02605 .60331 L
.02729 .6033 L
.02846 .60328 L
.03053 .60325 L
.03279 .60319 L
.03527 .60311 L
.0379 .603 L
.04262 .60275 L
.04749 .60242 L
.05205 .60204 L
.06244 .60093 L
.07305 .59945 L
.08274 .59778 L
.10458 .59293 L
.12357 .58753 L
.14429 .58038 L
.18493 .56272 L
.22406 .54141 L
.26565 .51454 L
.30571 .48498 L
.34426 .45364 L
.38527 .41776 L
.42475 .38132 L
.46273 .34511 L
.50315 .30596 L
.54206 .26832 L
.58342 .22905 L
.62326 .19262 L
.66159 .15946 L
.70238 .12682 L
.74164 .09849 L
.77939 .07458 L
.8196 .05311 L
.85828 .0367 L
.87793 .03004 L
.89942 .0241 L
.91995 .01977 L
.92911 .01826 L
.93905 .01692 L
.94426 .01635 L
.94906 .01589 L
.95356 .01553 L
.95851 .01522 L
.96295 .015 L
.9671 .01485 L
.96939 .01479 L
.97148 .01475 L
.97264 .01474 L
Mistroke
.9739 .01472 L
.97509 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.6.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NDSolve[", "MR"],
              StyleBox["eqn", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["u", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["solve a partial differential equation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.4"],

Cell["Numerical solution of partial differential equations. ", "Caption",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.5 Numerical Optimization", "Subsection",
  CellTags->{"S1.6.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NMinimize[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "minimize ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NMaximize[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximize ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NMinimize[{", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ineqs", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "minimize ",
              StyleBox["f", "TI"],
              " subject to the constraints ",
              StyleBox["ineqs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NMaximize[{", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ineqs", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "maximize ",
              StyleBox["f", "TI"],
              " subject to the constraints ",
              StyleBox["ineqs", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.5"],

Cell["Finding global minima and maxima. ", "Caption",
  CellTags->"S1.6.5"],

Cell["This gives the maximum value, and where it occurs. ", "MathCaption",
  CellTags->{"S1.6.5", "5.2"}],

Cell[CellGroupData[{

Cell["NMaximize[x/(1 + Exp[x]), x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.5"],

Cell[BoxData[
    \({0.2784645427610738`, {x \[Rule] 1.2784645427603774`}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.5"]
}, Open  ]],

Cell["This minimizes the function within the unit circle. ", "MathCaption",
  CellTags->{"S1.6.5", "5.3"}],

Cell[CellGroupData[{

Cell["NMinimize[{Cos[x] - Exp[x y], x^2 + y^2 < 1}, {x, y}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.5"],

Cell[BoxData[
    \({\(-0.9194414901050992`\), {x \[Rule] 0.7959757138813257`, 
        y \[Rule] 0.6053285586377634`}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.6.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NMinimize", "MR"],
  " and ",
  StyleBox["NMaximize", "MR"],
  " can find the absolute minima and maxima of many functions. But in some \
cases it is not realistic to do this. You can search for local minima and \
maxima using ",
  StyleBox["FindMinimum", "MR"],
  " and ",
  StyleBox["FindMaximum", "MR"],
  ".  "
}], "Text",
  CellTags->{"S1.6.5", "5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindMinimum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "search for a local minimum of ",
              StyleBox["f", "TI"],
              ", starting at ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FindMinimum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["search for a local minimum in several variables "]},
          {Cell[TextData[{
              StyleBox["FindMaximum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["search for a local maximum "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.5"],

Cell["Searching for local minima and maxima. ", "Caption",
  CellTags->"S1.6.5"],

Cell[TextData[{
  "This searches for a local minimum of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "cos", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ", starting at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "2"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.5", "5.5"}],

Cell[CellGroupData[{

Cell["FindMinimum[x Cos[x], {x, 2}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.5"],

Cell[BoxData[
    \({\(-3.2883713955908966`\), {x \[Rule] 3.425618459492147`}}\)], "Output",\

  CellLabel->"Out[3]= ",
  CellTags->"S1.6.5"]
}, Open  ]],

Cell["\<\
With a different starting point, you may reach a different local \
minimum. \
\>", "MathCaption",
  CellTags->{"S1.6.5", "5.6"}],

Cell[CellGroupData[{

Cell["FindMinimum[x Cos[x], {x, 10}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.6.5"],

Cell[BoxData[
    \({\(-9.477294259479795`\), {x \[Rule] 9.529334405361269`}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.6.5"]
}, Open  ]],

Cell[TextData[{
  "This finds a local minimum of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox[\(x  y\),
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.5", "5.7"}],

Cell[CellGroupData[{

Cell["FindMinimum[Sin[x y], {{x, 2}, {y, 2}}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.6.5"],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] 2.170803763674703`, 
        y \[Rule] 2.170803763674703`}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.6.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.6 Manipulating Numerical Data", "Subsection",
  CellTags->{"S1.6.6", "6.1"}],

Cell["\<\
When you have numerical data, it is often convenient to find a \
simple formula that approximates it. For example, you can try to \
\[OpenCurlyDoubleQuote]fit\[CloseCurlyDoubleQuote] a line or curve through \
the points in your data. \
\>", "Text",
  CellTags->{"S1.6.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Fit[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "fit the values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to a linear combination of functions ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Fit[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "fit the points ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{
                        SubscriptBox[
                          StyleBox["x",
                            "TI"], 
                          StyleBox["n",
                            "TI"]], ",", 
                        SubscriptBox[
                          StyleBox["y",
                            "TI"], 
                          StyleBox["n",
                            "TI"]]}], ")"}], TraditionalForm]], 
                "InlineFormula"],
              " to a linear combination of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.6"],

Cell["Fitting curves to linear combinations of functions. ", "Caption",
  CellTags->"S1.6.6"],

Cell[TextData[{
  "This generates a table of the numerical values of the exponential \
function. ",
  StyleBox["Table", "MR"],
  " will be discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.8.2",
    ButtonData:>{"1.8.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.6", "6.3"}],

Cell[CellGroupData[{

Cell["data = Table[ Exp[x/5.] , {x, 7}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \({1.2214027581601699`, 1.4918246976412703`, 1.822118800390509`, 
      2.225540928492468`, 2.718281828459045`, 3.320116922736548`, 
      4.055199966844675`}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[TextData[{
  "This finds a least\[Hyphen]squares fit to ",
  StyleBox["data", "MR"],
  " of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["c",
              "TI"], "1"], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "2"], 
          StyleBox["x",
            "TI"], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "3"], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  ". The elements of ",
  StyleBox["data", "MR"],
  " are assumed to correspond to values ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\` ... \)], "InlineFormula"],
  " of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.6", "6.4"}],

Cell[CellGroupData[{

Cell["Fit[data, {1, x, x^2}, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \(\(\(1.0942849747025405`\)\(\[InvisibleSpace]\)\) + 
      0.09863372758205054`\ x + 0.04594819076792495`\ x\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[TextData[{
  "This finds a fit of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["c",
              "TI"], "1"], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "2"], 
          StyleBox["x",
            "TI"], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "3"], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "3"], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "4"], 
          SuperscriptBox[
            StyleBox["x",
              "TI"], "5"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.6", "6.5"}],

Cell[CellGroupData[{

Cell["Fit[data, {1, x, x^3, x^5}, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \(\(\(0.9680596480276644`\)\(\[InvisibleSpace]\)\) + 
      0.24682874521153209`\ x + 0.004282807454629648`\ x\^3 - 
      6.579479585683434`*^-6\ x\^5\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[TextData[{
  "This gives a table of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " pairs. "
}], "MathCaption",
  CellTags->{"S1.6.6", "6.6"}],

Cell[CellGroupData[{

Cell["data = Table[ {x, Exp[Sin[x]]} , {x, 0., 1., 0.2}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \({{0.`, 1.`}, {0.2`, 1.219778556000619`}, {0.4`, 
        1.4761219464457283`}, {0.6000000000000001`, 
        1.7588188457669929`}, {0.8`, 2.0490086501642746`}, {1.`, 
        2.319776824715853`}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[TextData[{
  "This finds a fit to the new data, of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["c",
              "TI"], "1"], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "2"], "sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "+", 
          SubscriptBox[
            StyleBox["c",
              "TI"], "3"], "sin", 
          RowBox[{"(", 
            RowBox[{"2", 
              StyleBox["x",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.6.6", "6.7"}],

Cell[CellGroupData[{

Cell["Fit[%, {1, Sin[x], Sin[2x]}, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \(\(\(0.989559222665401`\)\(\[InvisibleSpace]\)\) + 
      2.0419920584273297`\ Sin[x] - 0.418176479429078`\ Sin[2\ x]\)], "Output",\

  CellLabel->"Out[5]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindFit[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find a fit to ",
              StyleBox["form", "TI"],
              " with parameters ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.6"],

Cell["Fitting data to general forms. ", "Caption",
  CellTags->"S1.6.6"],

Cell["This finds the best parameters for a linear fit. ", "MathCaption",
  CellTags->{"S1.6.6", "6.8"}],

Cell[CellGroupData[{

Cell["FindFit[data, a + b x + c x^2, {a, b, c}, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \({a \[Rule] 0.9912512908782979`, b \[Rule] 1.164211191590086`, 
      c \[Rule] 0.1742561377515558`}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell["This does a nonlinear fit. ", "MathCaption",
  CellTags->{"S1.6.6", "6.9"}],

Cell[CellGroupData[{

Cell["FindFit[data, a + b^(c + d x), {a, b, c, d}, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \({a \[Rule] \(-3.651990330771109`\), b \[Rule] 1.6571669043106532`, 
      c \[Rule] 3.0393414742531255`, 
      d \[Rule] 0.5017928529376584`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[TextData[{
  "One common way of picking out \[OpenCurlyDoubleQuote]signals\
\[CloseCurlyDoubleQuote] in numerical data is to find the ",
  StyleBox["Fourier transform", "TI"],
  ", or frequency spectrum, of the data. "
}], "Text",
  CellTags->{"S1.6.6", "6.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Fourier[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["numerical Fourier transform "]},
          {Cell[TextData[{
              StyleBox["InverseFourier[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["inverse Fourier transform "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.6"],

Cell["Fourier transforms. ", "Caption",
  CellTags->"S1.6.6"],

Cell["Here is a simple square pulse. ", "MathCaption",
  CellTags->{"S1.6.6", "6.11"}],

Cell[CellGroupData[{

Cell["data = {1, 1, 1, 1, -1, -1, -1, -1}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \({1, 1, 1, 1, \(-1\), \(-1\), \(-1\), \(-1\)}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell["This takes the Fourier transform of the pulse. ", "MathCaption",
  CellTags->{"S1.6.6", "6.12"}],

Cell[CellGroupData[{

Cell["Fourier[data]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.6.6"],

Cell[BoxData[
    \({\(\(0.`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(0.7071067811865476`\)\(\[InvisibleSpace]\)\) \
+ 1.7071067811865475`\ \[ImaginaryI], \(\(0.`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(0.7071067811865476`\)\(\[InvisibleSpace]\)\) \
+ 0.29289321881345254`\ \[ImaginaryI], \(\(0.`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(0.7071067811865476`\)\(\[InvisibleSpace]\)\) \
- 0.29289321881345254`\ \[ImaginaryI], \(\(0.`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(0.7071067811865476`\)\(\[InvisibleSpace]\)\) \
- 1.7071067811865475`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.6.6"]
}, Open  ]],

Cell[TextData[{
  "Note that the ",
  StyleBox["Fourier", "MR"],
  " function in ",
  StyleBox["Mathematica", "TI"],
  " is defined with the sign convention typically used in the physical \
sciences\[LongDash]opposite to the one often used in electrical engineering. \
Section ",
  ButtonBox["3.8.4",
    ButtonData:>{"3.8.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " gives more details. "
}], "Text",
  CellTags->{"S1.6.6", "6.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.6.7 Statistics", "Subsection",
  CellTags->{"S1.6.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Mean[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["mean (average value) "]},
          {Cell[TextData[{
              StyleBox["Median[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["median (central value) "]},
          {Cell[TextData[{
              StyleBox["Variance[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["variance "]},
          {Cell[TextData[{
              StyleBox["StandardDeviation[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["standard deviation "]},
          {Cell[TextData[{
              StyleBox["Quantile[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["q", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["q", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " quantile "
            }]]},
          {Cell[TextData[{
              StyleBox["Total[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["total of values "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.7"],

Cell["Basic descriptive statistics. ", "Caption",
  CellTags->"S1.6.7"],

Cell["Here is some \[OpenCurlyDoubleQuote]data\[CloseCurlyDoubleQuote]. ", \
"MathCaption",
  CellTags->{"S1.6.7", "7.2"}],

Cell[CellGroupData[{

Cell["data = {4.3, 7.2, 8.4, 5.8, 9.2, 3.9}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.6.7"],

Cell[BoxData[
    \({4.3`, 7.2`, 8.4`, 5.8`, 9.2`, 3.9`}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.6.7"]
}, Open  ]],

Cell["This gives the mean of your data. ", "MathCaption",
  CellTags->{"S1.6.7", "7.3"}],

Cell[CellGroupData[{

Cell["Mean[data]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.6.7"],

Cell[BoxData[
    \(6.466666666666666`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.6.7"]
}, Open  ]],

Cell["Here is the variance. ", "MathCaption",
  CellTags->{"S1.6.7", "7.4"}],

Cell[CellGroupData[{

Cell["Variance[data]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.6.7"],

Cell[BoxData[
    \(4.6946666666666665`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.6.7"]
}, Open  ]],

Cell[TextData[{
  "The standard set of packages distributed with ",
  StyleBox["Mathematica", "TI"],
  " includes several for doing more sophisticated statistical analyses of \
data.  "
}], "Text",
  CellTags->{"S1.6.7", "7.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Statistics`DescriptiveStatistics`", "MR"],
              " "
            }]], Cell["descriptive statistics functions "]},
          {Cell[TextData[{
              StyleBox["Statistics`MultivariateDescriptiveStatistics`", "MR"],
              
              " "
            }]], Cell["multivariate descriptive statistics functions "]},
          {Cell[TextData[{
              StyleBox["Statistics`ContinuousDistributions`", "MR"],
              " "
            }]], Cell[
            "properties of continuous statistical distributions "]},
          {Cell[TextData[{
              StyleBox["Statistics`DiscreteDistributions`", "MR"],
              " "
            }]], Cell["properties of discrete statistical distributions "]},
          {Cell[TextData[{
              StyleBox["Statistics`HypothesisTests`", "MR"],
              " "
            }]], Cell["hypothesis tests based on the normal distribution "]},
          {Cell[TextData[{
              StyleBox["Statistics`ConfidenceIntervals`", "MR"],
              " "
            }]], Cell[
            "confidence intervals derived from the normal distribution "]},
          {Cell[TextData[{
              StyleBox["Statistics`MultinormalDistribution`", "MR"],
              " "
            }]], 
            Cell["\<\
properties of distributions based on the multivariate \
normal distribution \
\>"]},
          {Cell[TextData[{
              StyleBox["Statistics`LinearRegression`", "MR"],
              " "
            }]], Cell["linear regression analysis "]},
          {Cell[TextData[{
              StyleBox["Statistics`NonlinearFit`", "MR"],
              " "
            }]], Cell["nonlinear fitting of data "]},
          {Cell[TextData[{
              StyleBox["Statistics`DataSmoothing`", "MR"],
              " "
            }]], Cell["smoothing of data "]},
          {Cell[TextData[{
              StyleBox["Statistics`DataManipulation`", "MR"],
              " "
            }]], Cell["utilities for data manipulation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.6.7"],

Cell["Some standard statistical analysis packages. ", "Caption",
  CellTags->"S1.6.7"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.6.0"->{
    Cell[1776, 53, 124, 4, 65, "Section",
      CellTags->{"S1.6.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 124, 4, 65, "Section",
      CellTags->{"S1.6.0", "0.1"}]},
  "S1.6.1"->{
    Cell[1925, 61, 75, 1, 70, "Subsection",
      CellTags->{"S1.6.1", "1.1"}],
    Cell[2003, 64, 261, 5, 70, "Text",
      CellTags->{"S1.6.1", "1.2"}],
    Cell[2267, 71, 6615, 193, 70, "DefinitionBox",
      CellTags->"S1.6.1"],
    Cell[8885, 266, 69, 1, 70, "Caption",
      CellTags->"S1.6.1"],
    Cell[8957, 269, 159, 4, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.3"}],
    Cell[9141, 277, 79, 2, 70, "Input",
      CellTags->"S1.6.1"],
    Cell[9223, 281, 97, 3, 70, "Output",
      CellTags->"S1.6.1"],
    Cell[9335, 287, 107, 1, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.4"}],
    Cell[9467, 292, 75, 2, 70, "Input",
      CellTags->"S1.6.1"],
    Cell[9545, 296, 93, 3, 70, "Output",
      CellTags->"S1.6.1"],
    Cell[9653, 302, 181, 6, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.5"}],
    Cell[9859, 312, 70, 2, 70, "Input",
      CellTags->"S1.6.1"],
    Cell[9932, 316, 99, 3, 70, "Output",
      CellTags->"S1.6.1"],
    Cell[10046, 322, 493, 12, 70, "Text",
      CellTags->{"S1.6.1", "1.6"}],
    Cell[10542, 336, 182, 5, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.7"}],
    Cell[10749, 345, 97, 2, 70, "Input",
      CellTags->"S1.6.1"],
    Cell[10849, 349, 128, 3, 70, "Output",
      CellTags->"S1.6.1"],
    Cell[10992, 355, 152, 5, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.8"}],
    Cell[11169, 364, 70, 2, 70, "Input",
      CellTags->"S1.6.1"],
    Cell[11242, 368, 100, 3, 70, "Output",
      CellTags->"S1.6.1"],
    Cell[11357, 374, 149, 4, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.9"}],
    Cell[11531, 382, 98, 2, 70, "Input",
      CellTags->"S1.6.1"],
    Cell[11632, 386, 100, 3, 70, "Output",
      CellTags->"S1.6.1"]},
  "1.1"->{
    Cell[1925, 61, 75, 1, 70, "Subsection",
      CellTags->{"S1.6.1", "1.1"}]},
  "1.2"->{
    Cell[2003, 64, 261, 5, 70, "Text",
      CellTags->{"S1.6.1", "1.2"}]},
  "1.3"->{
    Cell[8957, 269, 159, 4, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.3"}]},
  "1.4"->{
    Cell[9335, 287, 107, 1, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.4"}]},
  "1.5"->{
    Cell[9653, 302, 181, 6, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.5"}]},
  "1.6"->{
    Cell[10046, 322, 493, 12, 70, "Text",
      CellTags->{"S1.6.1", "1.6"}]},
  "1.7"->{
    Cell[10542, 336, 182, 5, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.7"}]},
  "1.8"->{
    Cell[10992, 355, 152, 5, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.8"}]},
  "1.9"->{
    Cell[11357, 374, 149, 4, 70, "MathCaption",
      CellTags->{"S1.6.1", "1.9"}]},
  "S1.6.2"->{
    Cell[11781, 395, 97, 1, 70, "Subsection",
      CellTags->{"S1.6.2", "2.1"}],
    Cell[11881, 398, 7707, 216, 70, "DefinitionBox",
      CellTags->"S1.6.2"],
    Cell[19591, 616, 81, 1, 70, "Caption",
      CellTags->"S1.6.2"],
    Cell[19675, 619, 494, 16, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.2"}],
    Cell[20194, 639, 93, 2, 70, "Input",
      CellTags->"S1.6.2"],
    Cell[20290, 643, 100, 3, 70, "Output",
      CellTags->"S1.6.2"],
    Cell[20405, 649, 173, 4, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.3"}],
    Cell[20603, 657, 102, 2, 70, "Input",
      CellTags->"S1.6.2"],
    Cell[20708, 661, 100, 3, 70, "Output",
      CellTags->"S1.6.2"],
    Cell[20823, 667, 108, 1, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.4"}],
    Cell[20956, 672, 111, 2, 70, "Input",
      CellTags->"S1.6.2"],
    Cell[21070, 676, 100, 3, 70, "Output",
      CellTags->"S1.6.2"],
    Cell[21185, 682, 165, 4, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.5"}],
    Cell[21375, 690, 108, 2, 70, "Input",
      CellTags->"S1.6.2"],
    Cell[21486, 694, 101, 3, 70, "Output",
      CellTags->"S1.6.2"]},
  "2.1"->{
    Cell[11781, 395, 97, 1, 70, "Subsection",
      CellTags->{"S1.6.2", "2.1"}]},
  "2.2"->{
    Cell[19675, 619, 494, 16, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.2"}]},
  "2.3"->{
    Cell[20405, 649, 173, 4, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.3"}]},
  "2.4"->{
    Cell[20823, 667, 108, 1, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.4"}]},
  "2.5"->{
    Cell[21185, 682, 165, 4, 70, "MathCaption",
      CellTags->{"S1.6.2", "2.5"}]},
  "S1.6.3"->{
    Cell[21636, 703, 85, 1, 70, "Subsection",
      CellTags->{"S1.6.3", "3.1"}],
    Cell[21724, 706, 5335, 153, 70, "DefinitionBox",
      CellTags->"S1.6.3"],
    Cell[27062, 861, 65, 1, 70, "Caption",
      CellTags->"S1.6.3"],
    Cell[27130, 864, 179, 5, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.2"}],
    Cell[27334, 873, 93, 2, 70, "Input",
      CellTags->"S1.6.3"],
    Cell[27430, 877, 493, 9, 70, "Output",
      CellTags->"S1.6.3"],
    Cell[27938, 889, 175, 5, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.3"}],
    Cell[28138, 898, 139, 5, 70, "Input",
      CellTags->"S1.6.3"],
    Cell[28280, 905, 142, 4, 70, "Output",
      CellTags->"S1.6.3"],
    Cell[28437, 912, 567, 13, 70, "Text",
      CellTags->{"S1.6.3", "3.4"}],
    Cell[29007, 927, 270, 9, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.5"}],
    Cell[29302, 940, 102, 2, 70, "Input",
      CellTags->"S1.6.3"],
    Cell[29407, 944, 111, 3, 70, "Output",
      CellTags->"S1.6.3"],
    Cell[29533, 950, 319, 10, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.6"}],
    Cell[29877, 964, 103, 2, 70, "Input",
      CellTags->"S1.6.3"],
    Cell[29983, 968, 111, 3, 70, "Output",
      CellTags->"S1.6.3"],
    Cell[30109, 974, 159, 4, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.7"}],
    Cell[30293, 982, 114, 2, 70, "Input",
      CellTags->"S1.6.3"],
    Cell[30410, 986, 304, 6, 70, "Output",
      CellTags->"S1.6.3"]},
  "3.1"->{
    Cell[21636, 703, 85, 1, 70, "Subsection",
      CellTags->{"S1.6.3", "3.1"}]},
  "3.2"->{
    Cell[27130, 864, 179, 5, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.2"}]},
  "3.3"->{
    Cell[27938, 889, 175, 5, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.3"}]},
  "3.4"->{
    Cell[28437, 912, 567, 13, 70, "Text",
      CellTags->{"S1.6.3", "3.4"}]},
  "3.5"->{
    Cell[29007, 927, 270, 9, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.5"}]},
  "3.6"->{
    Cell[29533, 950, 319, 10, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.6"}]},
  "3.7"->{
    Cell[30109, 974, 159, 4, 70, "MathCaption",
      CellTags->{"S1.6.3", "3.7"}]},
  "S1.6.4"->{
    Cell[30763, 998, 91, 1, 70, "Subsection",
      CellTags->{"S1.6.4", "4.1"}],
    Cell[30857, 1001, 3988, 116, 70, "DefinitionBox",
      CellTags->"S1.6.4"],
    Cell[34848, 1119, 87, 1, 70, "Caption",
      CellTags->"S1.6.4"],
    Cell[34938, 1122, 758, 26, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.2"}],
    Cell[35721, 1152, 113, 2, 70, "Input",
      CellTags->"S1.6.4"],
    Cell[35837, 1156, 271, 8, 70, "Output",
      CellTags->"S1.6.4"],
    Cell[36123, 1167, 240, 9, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.3"}],
    Cell[36388, 1180, 75, 2, 70, "Input",
      CellTags->"S1.6.4"],
    Cell[36466, 1184, 101, 3, 70, "Output",
      CellTags->"S1.6.4"],
    Cell[36582, 1190, 1478, 49, 70, "Text",
      CellTags->{"S1.6.4", "4.4"}],
    Cell[38063, 1241, 1465, 49, 70, "Text",
      CellTags->{"S1.6.4", "4.5"}],
    Cell[39531, 1292, 2476, 73, 70, "DefinitionBox",
      CellTags->"S1.6.4"],
    Cell[42010, 1367, 113, 5, 70, "Caption",
      CellTags->"S1.6.4"],
    Cell[42126, 1374, 116, 2, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.6"}],
    Cell[42267, 1380, 158, 5, 70, "Input",
      CellTags->"S1.6.4"],
    Cell[42428, 1387, 550, 17, 70, "Output",
      CellTags->"S1.6.4"],
    Cell[42993, 1407, 149, 5, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.7"}],
    Cell[43167, 1416, 73, 2, 70, "Input",
      CellTags->"S1.6.4"],
    Cell[43243, 1420, 107, 3, 70, "Output",
      CellTags->"S1.6.4"],
    Cell[43365, 1426, 309, 11, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.8"}],
    Cell[43699, 1441, 102, 2, 70, "Input",
      CellTags->"S1.6.4"],
    Cell[43804, 1445, 4208, 294, 70, 4135, 291, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S1.6.4"],
    Cell[48015, 1741, 177, 5, 70, "Output",
      CellTags->"S1.6.4"],
    Cell[48207, 1749, 2142, 63, 70, "DefinitionBox",
      CellTags->"S1.6.4"],
    Cell[50352, 1814, 95, 1, 70, "Caption",
      CellTags->"S1.6.4"]},
  "4.1"->{
    Cell[30763, 998, 91, 1, 70, "Subsection",
      CellTags->{"S1.6.4", "4.1"}]},
  "4.2"->{
    Cell[34938, 1122, 758, 26, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.2"}]},
  "4.3"->{
    Cell[36123, 1167, 240, 9, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.3"}]},
  "4.4"->{
    Cell[36582, 1190, 1478, 49, 70, "Text",
      CellTags->{"S1.6.4", "4.4"}]},
  "4.5"->{
    Cell[38063, 1241, 1465, 49, 70, "Text",
      CellTags->{"S1.6.4", "4.5"}]},
  "4.6"->{
    Cell[42126, 1374, 116, 2, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.6"}]},
  "4.7"->{
    Cell[42993, 1407, 149, 5, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.7"}]},
  "4.8"->{
    Cell[43365, 1426, 309, 11, 70, "MathCaption",
      CellTags->{"S1.6.4", "4.8"}]},
  "S1.6.5"->{
    Cell[50484, 1820, 81, 1, 70, "Subsection",
      CellTags->{"S1.6.5", "5.1"}],
    Cell[50568, 1823, 2988, 100, 70, "DefinitionBox",
      CellTags->"S1.6.5"],
    Cell[53559, 1925, 75, 1, 70, "Caption",
      CellTags->"S1.6.5"],
    Cell[53637, 1928, 105, 1, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.2"}],
    Cell[53767, 1933, 92, 2, 70, "Input",
      CellTags->"S1.6.5"],
    Cell[53862, 1937, 135, 3, 70, "Output",
      CellTags->"S1.6.5"],
    Cell[54012, 1943, 106, 1, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.3"}],
    Cell[54143, 1948, 117, 2, 70, "Input",
      CellTags->"S1.6.5"],
    Cell[54263, 1952, 180, 4, 70, "Output",
      CellTags->"S1.6.5"],
    Cell[54458, 1959, 385, 12, 70, "Text",
      CellTags->{"S1.6.5", "5.4"}],
    Cell[54846, 1973, 2925, 86, 70, "DefinitionBox",
      CellTags->"S1.6.5"],
    Cell[57774, 2061, 80, 1, 70, "Caption",
      CellTags->"S1.6.5"],
    Cell[57857, 2064, 491, 18, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.5"}],
    Cell[58373, 2086, 93, 2, 70, "Input",
      CellTags->"S1.6.5"],
    Cell[58469, 2090, 141, 4, 70, "Output",
      CellTags->"S1.6.5"],
    Cell[58625, 2097, 138, 4, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.6"}],
    Cell[58788, 2105, 94, 2, 70, "Input",
      CellTags->"S1.6.5"],
    Cell[58885, 2109, 138, 3, 70, "Output",
      CellTags->"S1.6.5"],
    Cell[59038, 2115, 285, 10, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.7"}],
    Cell[59348, 2129, 103, 2, 70, "Input",
      CellTags->"S1.6.5"],
    Cell[59454, 2133, 162, 4, 70, "Output",
      CellTags->"S1.6.5"]},
  "5.1"->{
    Cell[50484, 1820, 81, 1, 70, "Subsection",
      CellTags->{"S1.6.5", "5.1"}]},
  "5.2"->{
    Cell[53637, 1928, 105, 1, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.2"}]},
  "5.3"->{
    Cell[54012, 1943, 106, 1, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.3"}]},
  "5.4"->{
    Cell[54458, 1959, 385, 12, 70, "Text",
      CellTags->{"S1.6.5", "5.4"}]},
  "5.5"->{
    Cell[57857, 2064, 491, 18, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.5"}]},
  "5.6"->{
    Cell[58625, 2097, 138, 4, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.6"}]},
  "5.7"->{
    Cell[59038, 2115, 285, 10, 70, "MathCaption",
      CellTags->{"S1.6.5", "5.7"}]},
  "S1.6.6"->{
    Cell[59665, 2143, 86, 1, 70, "Subsection",
      CellTags->{"S1.6.6", "6.1"}],
    Cell[59754, 2146, 289, 6, 70, "Text",
      CellTags->{"S1.6.6", "6.2"}],
    Cell[60046, 2154, 4915, 139, 70, "DefinitionBox",
      CellTags->"S1.6.6"],
    Cell[64964, 2295, 93, 1, 70, "Caption",
      CellTags->"S1.6.6"],
    Cell[65060, 2298, 326, 10, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.3"}],
    Cell[65411, 2312, 97, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[65511, 2316, 237, 5, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[65763, 2324, 1044, 39, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.4"}],
    Cell[66832, 2367, 89, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[66924, 2371, 191, 4, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[67130, 2378, 724, 27, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.5"}],
    Cell[67879, 2409, 94, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[67976, 2413, 230, 5, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[68221, 2421, 328, 13, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.6"}],
    Cell[68574, 2438, 114, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[68691, 2442, 277, 6, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[68983, 2451, 658, 23, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.7"}],
    Cell[69666, 2478, 95, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[69764, 2482, 199, 5, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[69978, 2490, 1625, 49, 70, "DefinitionBox",
      CellTags->"S1.6.6"],
    Cell[71606, 2541, 72, 1, 70, "Caption",
      CellTags->"S1.6.6"],
    Cell[71681, 2544, 103, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.8"}],
    Cell[71809, 2549, 108, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[71920, 2553, 180, 4, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[72115, 2560, 81, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.9"}],
    Cell[72221, 2565, 111, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[72335, 2569, 223, 5, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[72573, 2577, 267, 6, 70, "Text",
      CellTags->{"S1.6.6", "6.10"}],
    Cell[72843, 2585, 641, 18, 70, "DefinitionBox",
      CellTags->"S1.6.6"],
    Cell[73487, 2605, 61, 1, 70, "Caption",
      CellTags->"S1.6.6"],
    Cell[73551, 2608, 86, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.11"}],
    Cell[73662, 2613, 99, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[73764, 2617, 125, 3, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[73904, 2623, 102, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.12"}],
    Cell[74031, 2628, 77, 2, 70, "Input",
      CellTags->"S1.6.6"],
    Cell[74111, 2632, 695, 11, 70, "Output",
      CellTags->"S1.6.6"],
    Cell[74821, 2646, 438, 13, 70, "Text",
      CellTags->{"S1.6.6", "6.13"}]},
  "6.1"->{
    Cell[59665, 2143, 86, 1, 70, "Subsection",
      CellTags->{"S1.6.6", "6.1"}]},
  "6.2"->{
    Cell[59754, 2146, 289, 6, 70, "Text",
      CellTags->{"S1.6.6", "6.2"}]},
  "6.3"->{
    Cell[65060, 2298, 326, 10, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.3"}]},
  "6.4"->{
    Cell[65763, 2324, 1044, 39, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.4"}]},
  "6.5"->{
    Cell[67130, 2378, 724, 27, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.5"}]},
  "6.6"->{
    Cell[68221, 2421, 328, 13, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.6"}]},
  "6.7"->{
    Cell[68983, 2451, 658, 23, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.7"}]},
  "6.8"->{
    Cell[71681, 2544, 103, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.8"}]},
  "6.9"->{
    Cell[72115, 2560, 81, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.9"}]},
  "6.10"->{
    Cell[72573, 2577, 267, 6, 70, "Text",
      CellTags->{"S1.6.6", "6.10"}]},
  "6.11"->{
    Cell[73551, 2608, 86, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.11"}]},
  "6.12"->{
    Cell[73904, 2623, 102, 1, 70, "MathCaption",
      CellTags->{"S1.6.6", "6.12"}]},
  "6.13"->{
    Cell[74821, 2646, 438, 13, 70, "Text",
      CellTags->{"S1.6.6", "6.13"}]},
  "S1.6.7"->{
    Cell[75296, 2664, 69, 1, 70, "Subsection",
      CellTags->{"S1.6.7", "7.1"}],
    Cell[75368, 2667, 1699, 50, 70, "DefinitionBox",
      CellTags->"S1.6.7"],
    Cell[77070, 2719, 71, 1, 70, "Caption",
      CellTags->"S1.6.7"],
    Cell[77144, 2722, 122, 2, 70, "MathCaption",
      CellTags->{"S1.6.7", "7.2"}],
    Cell[77291, 2728, 101, 2, 70, "Input",
      CellTags->"S1.6.7"],
    Cell[77395, 2732, 117, 3, 70, "Output",
      CellTags->"S1.6.7"],
    Cell[77527, 2738, 88, 1, 70, "MathCaption",
      CellTags->{"S1.6.7", "7.3"}],
    Cell[77640, 2743, 74, 2, 28, "Input",
      CellTags->"S1.6.7"],
    Cell[77717, 2747, 99, 3, 70, "Output",
      CellTags->"S1.6.7"],
    Cell[77831, 2753, 76, 1, 40, "MathCaption",
      CellTags->{"S1.6.7", "7.4"}],
    Cell[77932, 2758, 78, 2, 28, "Input",
      CellTags->"S1.6.7"],
    Cell[78013, 2762, 100, 3, 25, "Output",
      CellTags->"S1.6.7"],
    Cell[78128, 2768, 228, 6, 40, "Text",
      CellTags->{"S1.6.7", "7.5"}],
    Cell[78359, 2776, 2253, 57, 436, "DefinitionBox",
      CellTags->"S1.6.7"],
    Cell[80615, 2835, 86, 1, 16, "Caption",
      CellTags->"S1.6.7"]},
  "7.1"->{
    Cell[75296, 2664, 69, 1, 70, "Subsection",
      CellTags->{"S1.6.7", "7.1"}]},
  "7.2"->{
    Cell[77144, 2722, 122, 2, 70, "MathCaption",
      CellTags->{"S1.6.7", "7.2"}]},
  "7.3"->{
    Cell[77527, 2738, 88, 1, 70, "MathCaption",
      CellTags->{"S1.6.7", "7.3"}]},
  "7.4"->{
    Cell[77831, 2753, 76, 1, 40, "MathCaption",
      CellTags->{"S1.6.7", "7.4"}]},
  "7.5"->{
    Cell[78128, 2768, 228, 6, 40, "Text",
      CellTags->{"S1.6.7", "7.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.6.0", 81344, 2856},
  {"0.1", 81434, 2859},
  {"S1.6.1", 81527, 2862},
  {"1.1", 83239, 2909},
  {"1.2", 83331, 2912},
  {"1.3", 83418, 2915},
  {"1.4", 83513, 2918},
  {"1.5", 83608, 2921},
  {"1.6", 83703, 2924},
  {"1.7", 83793, 2927},
  {"1.8", 83889, 2930},
  {"1.9", 83985, 2933},
  {"S1.6.2", 84084, 2936},
  {"2.1", 85220, 2967},
  {"2.2", 85314, 2970},
  {"2.3", 85411, 2973},
  {"2.4", 85507, 2976},
  {"2.5", 85603, 2979},
  {"S1.6.3", 85702, 2982},
  {"3.1", 87139, 3021},
  {"3.2", 87233, 3024},
  {"3.3", 87329, 3027},
  {"3.4", 87425, 3030},
  {"3.5", 87515, 3033},
  {"3.6", 87611, 3036},
  {"3.7", 87708, 3039},
  {"S1.6.4", 87807, 3042},
  {"4.1", 89799, 3095},
  {"4.2", 89893, 3098},
  {"4.3", 89991, 3101},
  {"4.4", 90088, 3104},
  {"4.5", 90180, 3107},
  {"4.6", 90272, 3110},
  {"4.7", 90369, 3113},
  {"4.8", 90466, 3116},
  {"S1.6.5", 90567, 3119},
  {"5.1", 92173, 3162},
  {"5.2", 92268, 3165},
  {"5.3", 92365, 3168},
  {"5.4", 92462, 3171},
  {"5.5", 92553, 3174},
  {"5.6", 92651, 3177},
  {"5.7", 92748, 3180},
  {"S1.6.6", 92849, 3183},
  {"6.1", 95669, 3258},
  {"6.2", 95764, 3261},
  {"6.3", 95854, 3264},
  {"6.4", 95952, 3267},
  {"6.5", 96051, 3270},
  {"6.6", 96149, 3273},
  {"6.7", 96247, 3276},
  {"6.8", 96345, 3279},
  {"6.9", 96442, 3282},
  {"6.10", 96539, 3285},
  {"6.11", 96631, 3288},
  {"6.12", 96729, 3291},
  {"6.13", 96828, 3294},
  {"S1.6.7", 96923, 3297},
  {"7.1", 98072, 3328},
  {"7.2", 98167, 3331},
  {"7.3", 98264, 3334},
  {"7.4", 98360, 3337},
  {"7.5", 98456, 3340}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 124, 4, 65, "Section",
  CellTags->{"S1.6.0", "0.1"}],

Cell[CellGroupData[{
Cell[1925, 61, 75, 1, 70, "Subsection",
  CellTags->{"S1.6.1", "1.1"}],
Cell[2003, 64, 261, 5, 70, "Text",
  CellTags->{"S1.6.1", "1.2"}],
Cell[2267, 71, 6615, 193, 70, "DefinitionBox",
  CellTags->"S1.6.1"],
Cell[8885, 266, 69, 1, 70, "Caption",
  CellTags->"S1.6.1"],
Cell[8957, 269, 159, 4, 70, "MathCaption",
  CellTags->{"S1.6.1", "1.3"}],

Cell[CellGroupData[{
Cell[9141, 277, 79, 2, 70, "Input",
  CellTags->"S1.6.1"],
Cell[9223, 281, 97, 3, 70, "Output",
  CellTags->"S1.6.1"]
}, Open  ]],
Cell[9335, 287, 107, 1, 70, "MathCaption",
  CellTags->{"S1.6.1", "1.4"}],

Cell[CellGroupData[{
Cell[9467, 292, 75, 2, 70, "Input",
  CellTags->"S1.6.1"],
Cell[9545, 296, 93, 3, 70, "Output",
  CellTags->"S1.6.1"]
}, Open  ]],
Cell[9653, 302, 181, 6, 70, "MathCaption",
  CellTags->{"S1.6.1", "1.5"}],

Cell[CellGroupData[{
Cell[9859, 312, 70, 2, 70, "Input",
  CellTags->"S1.6.1"],
Cell[9932, 316, 99, 3, 70, "Output",
  CellTags->"S1.6.1"]
}, Open  ]],
Cell[10046, 322, 493, 12, 70, "Text",
  CellTags->{"S1.6.1", "1.6"}],
Cell[10542, 336, 182, 5, 70, "MathCaption",
  CellTags->{"S1.6.1", "1.7"}],

Cell[CellGroupData[{
Cell[10749, 345, 97, 2, 70, "Input",
  CellTags->"S1.6.1"],
Cell[10849, 349, 128, 3, 70, "Output",
  CellTags->"S1.6.1"]
}, Open  ]],
Cell[10992, 355, 152, 5, 70, "MathCaption",
  CellTags->{"S1.6.1", "1.8"}],

Cell[CellGroupData[{
Cell[11169, 364, 70, 2, 70, "Input",
  CellTags->"S1.6.1"],
Cell[11242, 368, 100, 3, 70, "Output",
  CellTags->"S1.6.1"]
}, Open  ]],
Cell[11357, 374, 149, 4, 70, "MathCaption",
  CellTags->{"S1.6.1", "1.9"}],

Cell[CellGroupData[{
Cell[11531, 382, 98, 2, 70, "Input",
  CellTags->"S1.6.1"],
Cell[11632, 386, 100, 3, 70, "Output",
  CellTags->"S1.6.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11781, 395, 97, 1, 70, "Subsection",
  CellTags->{"S1.6.2", "2.1"}],
Cell[11881, 398, 7707, 216, 70, "DefinitionBox",
  CellTags->"S1.6.2"],
Cell[19591, 616, 81, 1, 70, "Caption",
  CellTags->"S1.6.2"],
Cell[19675, 619, 494, 16, 70, "MathCaption",
  CellTags->{"S1.6.2", "2.2"}],

Cell[CellGroupData[{
Cell[20194, 639, 93, 2, 70, "Input",
  CellTags->"S1.6.2"],
Cell[20290, 643, 100, 3, 70, "Output",
  CellTags->"S1.6.2"]
}, Open  ]],
Cell[20405, 649, 173, 4, 70, "MathCaption",
  CellTags->{"S1.6.2", "2.3"}],

Cell[CellGroupData[{
Cell[20603, 657, 102, 2, 70, "Input",
  CellTags->"S1.6.2"],
Cell[20708, 661, 100, 3, 70, "Output",
  CellTags->"S1.6.2"]
}, Open  ]],
Cell[20823, 667, 108, 1, 70, "MathCaption",
  CellTags->{"S1.6.2", "2.4"}],

Cell[CellGroupData[{
Cell[20956, 672, 111, 2, 70, "Input",
  CellTags->"S1.6.2"],
Cell[21070, 676, 100, 3, 70, "Output",
  CellTags->"S1.6.2"]
}, Open  ]],
Cell[21185, 682, 165, 4, 70, "MathCaption",
  CellTags->{"S1.6.2", "2.5"}],

Cell[CellGroupData[{
Cell[21375, 690, 108, 2, 70, "Input",
  CellTags->"S1.6.2"],
Cell[21486, 694, 101, 3, 70, "Output",
  CellTags->"S1.6.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21636, 703, 85, 1, 70, "Subsection",
  CellTags->{"S1.6.3", "3.1"}],
Cell[21724, 706, 5335, 153, 70, "DefinitionBox",
  CellTags->"S1.6.3"],
Cell[27062, 861, 65, 1, 70, "Caption",
  CellTags->"S1.6.3"],
Cell[27130, 864, 179, 5, 70, "MathCaption",
  CellTags->{"S1.6.3", "3.2"}],

Cell[CellGroupData[{
Cell[27334, 873, 93, 2, 70, "Input",
  CellTags->"S1.6.3"],
Cell[27430, 877, 493, 9, 70, "Output",
  CellTags->"S1.6.3"]
}, Open  ]],
Cell[27938, 889, 175, 5, 70, "MathCaption",
  CellTags->{"S1.6.3", "3.3"}],

Cell[CellGroupData[{
Cell[28138, 898, 139, 5, 70, "Input",
  CellTags->"S1.6.3"],
Cell[28280, 905, 142, 4, 70, "Output",
  CellTags->"S1.6.3"]
}, Open  ]],
Cell[28437, 912, 567, 13, 70, "Text",
  CellTags->{"S1.6.3", "3.4"}],
Cell[29007, 927, 270, 9, 70, "MathCaption",
  CellTags->{"S1.6.3", "3.5"}],

Cell[CellGroupData[{
Cell[29302, 940, 102, 2, 70, "Input",
  CellTags->"S1.6.3"],
Cell[29407, 944, 111, 3, 70, "Output",
  CellTags->"S1.6.3"]
}, Open  ]],
Cell[29533, 950, 319, 10, 70, "MathCaption",
  CellTags->{"S1.6.3", "3.6"}],

Cell[CellGroupData[{
Cell[29877, 964, 103, 2, 70, "Input",
  CellTags->"S1.6.3"],
Cell[29983, 968, 111, 3, 70, "Output",
  CellTags->"S1.6.3"]
}, Open  ]],
Cell[30109, 974, 159, 4, 70, "MathCaption",
  CellTags->{"S1.6.3", "3.7"}],

Cell[CellGroupData[{
Cell[30293, 982, 114, 2, 70, "Input",
  CellTags->"S1.6.3"],
Cell[30410, 986, 304, 6, 70, "Output",
  CellTags->"S1.6.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30763, 998, 91, 1, 70, "Subsection",
  CellTags->{"S1.6.4", "4.1"}],
Cell[30857, 1001, 3988, 116, 70, "DefinitionBox",
  CellTags->"S1.6.4"],
Cell[34848, 1119, 87, 1, 70, "Caption",
  CellTags->"S1.6.4"],
Cell[34938, 1122, 758, 26, 70, "MathCaption",
  CellTags->{"S1.6.4", "4.2"}],

Cell[CellGroupData[{
Cell[35721, 1152, 113, 2, 70, "Input",
  CellTags->"S1.6.4"],
Cell[35837, 1156, 271, 8, 70, "Output",
  CellTags->"S1.6.4"]
}, Open  ]],
Cell[36123, 1167, 240, 9, 70, "MathCaption",
  CellTags->{"S1.6.4", "4.3"}],

Cell[CellGroupData[{
Cell[36388, 1180, 75, 2, 70, "Input",
  CellTags->"S1.6.4"],
Cell[36466, 1184, 101, 3, 70, "Output",
  CellTags->"S1.6.4"]
}, Open  ]],
Cell[36582, 1190, 1478, 49, 70, "Text",
  CellTags->{"S1.6.4", "4.4"}],
Cell[38063, 1241, 1465, 49, 70, "Text",
  CellTags->{"S1.6.4", "4.5"}],
Cell[39531, 1292, 2476, 73, 70, "DefinitionBox",
  CellTags->"S1.6.4"],
Cell[42010, 1367, 113, 5, 70, "Caption",
  CellTags->"S1.6.4"],
Cell[42126, 1374, 116, 2, 70, "MathCaption",
  CellTags->{"S1.6.4", "4.6"}],

Cell[CellGroupData[{
Cell[42267, 1380, 158, 5, 70, "Input",
  CellTags->"S1.6.4"],
Cell[42428, 1387, 550, 17, 70, "Output",
  CellTags->"S1.6.4"]
}, Open  ]],
Cell[42993, 1407, 149, 5, 70, "MathCaption",
  CellTags->{"S1.6.4", "4.7"}],

Cell[CellGroupData[{
Cell[43167, 1416, 73, 2, 70, "Input",
  CellTags->"S1.6.4"],
Cell[43243, 1420, 107, 3, 70, "Output",
  CellTags->"S1.6.4"]
}, Open  ]],
Cell[43365, 1426, 309, 11, 70, "MathCaption",
  CellTags->{"S1.6.4", "4.8"}],

Cell[CellGroupData[{
Cell[43699, 1441, 102, 2, 70, "Input",
  CellTags->"S1.6.4"],
Cell[43804, 1445, 4208, 294, 70, 4135, 291, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S1.6.4"],
Cell[48015, 1741, 177, 5, 70, "Output",
  CellTags->"S1.6.4"]
}, Open  ]],
Cell[48207, 1749, 2142, 63, 70, "DefinitionBox",
  CellTags->"S1.6.4"],
Cell[50352, 1814, 95, 1, 70, "Caption",
  CellTags->"S1.6.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50484, 1820, 81, 1, 70, "Subsection",
  CellTags->{"S1.6.5", "5.1"}],
Cell[50568, 1823, 2988, 100, 70, "DefinitionBox",
  CellTags->"S1.6.5"],
Cell[53559, 1925, 75, 1, 70, "Caption",
  CellTags->"S1.6.5"],
Cell[53637, 1928, 105, 1, 70, "MathCaption",
  CellTags->{"S1.6.5", "5.2"}],

Cell[CellGroupData[{
Cell[53767, 1933, 92, 2, 70, "Input",
  CellTags->"S1.6.5"],
Cell[53862, 1937, 135, 3, 70, "Output",
  CellTags->"S1.6.5"]
}, Open  ]],
Cell[54012, 1943, 106, 1, 70, "MathCaption",
  CellTags->{"S1.6.5", "5.3"}],

Cell[CellGroupData[{
Cell[54143, 1948, 117, 2, 70, "Input",
  CellTags->"S1.6.5"],
Cell[54263, 1952, 180, 4, 70, "Output",
  CellTags->"S1.6.5"]
}, Open  ]],
Cell[54458, 1959, 385, 12, 70, "Text",
  CellTags->{"S1.6.5", "5.4"}],
Cell[54846, 1973, 2925, 86, 70, "DefinitionBox",
  CellTags->"S1.6.5"],
Cell[57774, 2061, 80, 1, 70, "Caption",
  CellTags->"S1.6.5"],
Cell[57857, 2064, 491, 18, 70, "MathCaption",
  CellTags->{"S1.6.5", "5.5"}],

Cell[CellGroupData[{
Cell[58373, 2086, 93, 2, 70, "Input",
  CellTags->"S1.6.5"],
Cell[58469, 2090, 141, 4, 70, "Output",
  CellTags->"S1.6.5"]
}, Open  ]],
Cell[58625, 2097, 138, 4, 70, "MathCaption",
  CellTags->{"S1.6.5", "5.6"}],

Cell[CellGroupData[{
Cell[58788, 2105, 94, 2, 70, "Input",
  CellTags->"S1.6.5"],
Cell[58885, 2109, 138, 3, 70, "Output",
  CellTags->"S1.6.5"]
}, Open  ]],
Cell[59038, 2115, 285, 10, 70, "MathCaption",
  CellTags->{"S1.6.5", "5.7"}],

Cell[CellGroupData[{
Cell[59348, 2129, 103, 2, 70, "Input",
  CellTags->"S1.6.5"],
Cell[59454, 2133, 162, 4, 70, "Output",
  CellTags->"S1.6.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59665, 2143, 86, 1, 70, "Subsection",
  CellTags->{"S1.6.6", "6.1"}],
Cell[59754, 2146, 289, 6, 70, "Text",
  CellTags->{"S1.6.6", "6.2"}],
Cell[60046, 2154, 4915, 139, 70, "DefinitionBox",
  CellTags->"S1.6.6"],
Cell[64964, 2295, 93, 1, 70, "Caption",
  CellTags->"S1.6.6"],
Cell[65060, 2298, 326, 10, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.3"}],

Cell[CellGroupData[{
Cell[65411, 2312, 97, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[65511, 2316, 237, 5, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[65763, 2324, 1044, 39, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.4"}],

Cell[CellGroupData[{
Cell[66832, 2367, 89, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[66924, 2371, 191, 4, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[67130, 2378, 724, 27, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.5"}],

Cell[CellGroupData[{
Cell[67879, 2409, 94, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[67976, 2413, 230, 5, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[68221, 2421, 328, 13, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.6"}],

Cell[CellGroupData[{
Cell[68574, 2438, 114, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[68691, 2442, 277, 6, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[68983, 2451, 658, 23, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.7"}],

Cell[CellGroupData[{
Cell[69666, 2478, 95, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[69764, 2482, 199, 5, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[69978, 2490, 1625, 49, 70, "DefinitionBox",
  CellTags->"S1.6.6"],
Cell[71606, 2541, 72, 1, 70, "Caption",
  CellTags->"S1.6.6"],
Cell[71681, 2544, 103, 1, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.8"}],

Cell[CellGroupData[{
Cell[71809, 2549, 108, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[71920, 2553, 180, 4, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[72115, 2560, 81, 1, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.9"}],

Cell[CellGroupData[{
Cell[72221, 2565, 111, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[72335, 2569, 223, 5, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[72573, 2577, 267, 6, 70, "Text",
  CellTags->{"S1.6.6", "6.10"}],
Cell[72843, 2585, 641, 18, 70, "DefinitionBox",
  CellTags->"S1.6.6"],
Cell[73487, 2605, 61, 1, 70, "Caption",
  CellTags->"S1.6.6"],
Cell[73551, 2608, 86, 1, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.11"}],

Cell[CellGroupData[{
Cell[73662, 2613, 99, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[73764, 2617, 125, 3, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[73904, 2623, 102, 1, 70, "MathCaption",
  CellTags->{"S1.6.6", "6.12"}],

Cell[CellGroupData[{
Cell[74031, 2628, 77, 2, 70, "Input",
  CellTags->"S1.6.6"],
Cell[74111, 2632, 695, 11, 70, "Output",
  CellTags->"S1.6.6"]
}, Open  ]],
Cell[74821, 2646, 438, 13, 70, "Text",
  CellTags->{"S1.6.6", "6.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[75296, 2664, 69, 1, 70, "Subsection",
  CellTags->{"S1.6.7", "7.1"}],
Cell[75368, 2667, 1699, 50, 70, "DefinitionBox",
  CellTags->"S1.6.7"],
Cell[77070, 2719, 71, 1, 70, "Caption",
  CellTags->"S1.6.7"],
Cell[77144, 2722, 122, 2, 70, "MathCaption",
  CellTags->{"S1.6.7", "7.2"}],

Cell[CellGroupData[{
Cell[77291, 2728, 101, 2, 70, "Input",
  CellTags->"S1.6.7"],
Cell[77395, 2732, 117, 3, 70, "Output",
  CellTags->"S1.6.7"]
}, Open  ]],
Cell[77527, 2738, 88, 1, 70, "MathCaption",
  CellTags->{"S1.6.7", "7.3"}],

Cell[CellGroupData[{
Cell[77640, 2743, 74, 2, 28, "Input",
  CellTags->"S1.6.7"],
Cell[77717, 2747, 99, 3, 70, "Output",
  CellTags->"S1.6.7"]
}, Open  ]],
Cell[77831, 2753, 76, 1, 40, "MathCaption",
  CellTags->{"S1.6.7", "7.4"}],

Cell[CellGroupData[{
Cell[77932, 2758, 78, 2, 28, "Input",
  CellTags->"S1.6.7"],
Cell[78013, 2762, 100, 3, 25, "Output",
  CellTags->"S1.6.7"]
}, Open  ]],
Cell[78128, 2768, 228, 6, 40, "Text",
  CellTags->{"S1.6.7", "7.5"}],
Cell[78359, 2776, 2253, 57, 436, "DefinitionBox",
  CellTags->"S1.6.7"],
Cell[80615, 2835, 86, 1, 16, "Caption",
  CellTags->"S1.6.7"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

