(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26362,       1028]*)
(*NotebookOutlinePosition[     40993,       1471]*)
(*  CellTagsIndexPosition[     39671,       1414]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.7 ", "HeadingNumber"],
  "Functions and Programs"
}], "Section",
  CellTags->{"S1.7.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.7.1 Defining Functions", "Subsection",
  CellTags->{"S1.7.1", "1.1"}],

Cell[TextData[{
  "In this part of the book, we have seen many examples of functions that are \
built into ",
  StyleBox["Mathematica", "TI"],
  ". In this section, we discuss how you can add your own simple functions to \
",
  StyleBox["Mathematica", "TI"],
  ". Part 2 will describe in much greater detail the mechanisms for adding \
functions to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.7.1", "1.2"}],

Cell[TextData[{
  "As a first example, consider adding a function called ",
  StyleBox["f", "MR"],
  " which squares its argument. The ",
  StyleBox["Mathematica", "TI"],
  " command to define this function is ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  ". The ",
  StyleBox["_", "MR"],
  " (referred to as \[OpenCurlyDoubleQuote]blank\[CloseCurlyDoubleQuote]) on \
the left\[Hyphen]hand side is very important; what it means will be discussed \
below. For now, just remember to put a ",
  StyleBox["_", "MR"],
  " on the left\[Hyphen]hand side, but not on the right\[Hyphen]hand side, of \
your definition. "
}], "Text",
  CellTags->{"S1.7.1", "1.3"}],

Cell[TextData[{
  "This defines the function ",
  StyleBox["f", "MR"],
  ". Notice the ",
  StyleBox["_", "MR"],
  " on the left\[Hyphen]hand side. "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.4"}],

Cell["f[x_] := x^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.7.1"],

Cell[TextData[{
  StyleBox["f", "MR"],
  " squares its argument. "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.5"}],

Cell[CellGroupData[{

Cell["f[a+1]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \(\((1 + a)\)\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell["The argument can be a number. ", "MathCaption",
  CellTags->{"S1.7.1", "1.6"}],

Cell[CellGroupData[{

Cell["f[4]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \(16\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell["Or it can be a more complicated expression. ", "MathCaption",
  CellTags->{"S1.7.1", "1.7"}],

Cell[CellGroupData[{

Cell["f[3x + x^2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \(\((3\ x + x\^2)\)\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["f", "MR"],
  " in a calculation. "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.8"}],

Cell[CellGroupData[{

Cell["Expand[f[(x+1+y)]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \(1 + 2\ x + x\^2 + 2\ y + 2\ x\ y + y\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell[TextData[{
  "This shows the definition you made for\[NonBreakingSpace]",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.9"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S1.7.1"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[x_] := x\^2\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f[x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["x^2", "MR"],
              " "
            }]], Cell[TextData[{
              "define the function ",
              StyleBox["f", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["?", "MR"],
              StyleBox["f", "TI"],
              " "
            }]], Cell[TextData[{
              "show the definition of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Clear[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "clear all definitions for ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.7.1"],

Cell[TextData[{
  "Defining a function in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.7.1"],

Cell[TextData[{
  "The names like ",
  StyleBox["f", "MR"],
  " that you use for functions in ",
  StyleBox["Mathematica", "TI"],
  " are just symbols. Because of this, you should make sure to avoid using \
names that begin with capital letters, to prevent confusion with built\
\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions. You should also make sure that you have not used the names for \
anything else earlier in your session. "
}], "Text",
  CellTags->{"S1.7.1", "1.10"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " functions can have any number of arguments. "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.11"}],

Cell["hump[x_, xmax_] := (x - xmax)^2 / xmax", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.7.1"],

Cell[TextData[{
  "You can use the ",
  StyleBox["hump", "MR"],
  " function just as you would any of the built\[Hyphen]in functions. "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.12"}],

Cell[CellGroupData[{

Cell["2 + hump[x, 3.5]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \(2 + 0.2857142857142857`\ \((\(-3.5`\) + x)\)\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell[TextData[{
  "This gives a new definition for ",
  StyleBox["hump", "MR"],
  ", which overwrites the previous one. "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.13"}],

Cell["hump[x_, xmax_] := (x - xmax)^4", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.7.1"],

Cell["The new definition is displayed. ", "MathCaption",
  CellTags->{"S1.7.1", "1.14"}],

Cell[CellGroupData[{

Cell["?hump", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.7.1"],

Cell[BoxData[
    \("Global`hump"\)], "Print",
  CellTags->"S1.7.1"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(hump[x_, xmax_] := \((x - xmax)\)\^4\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ hump],
      Editable->False]], "Print",
  CellTags->"S1.7.1"]
}, Open  ]],

Cell[TextData[{
  "This clears all definitions for ",
  StyleBox["hump", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.7.1", "1.15"}],

Cell["Clear[hump]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.7.1"],

Cell[TextData[{
  "When you have finished with a particular function, it is always a good \
idea to clear definitions you have made for it. If you do not do this, then \
you will run into trouble if you try to use the same function for a different \
purpose later in your ",
  StyleBox["Mathematica", "TI"],
  " session. You can clear all definitions you have made for a function or \
symbol ",
  StyleBox["f", "TI"],
  " by using ",
  StyleBox["Clear[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.7.1", "1.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.7.2 Functions as Procedures", "Subsection",
  CellTags->{"S1.7.2", "2.1"}],

Cell[TextData[{
  "In many kinds of calculations, you may find yourself typing the same input \
to ",
  StyleBox["Mathematica", "TI"],
  " over and over again. You can save yourself a lot of typing by defining a \
",
  StyleBox["function", "TI"],
  " that contains your input commands. "
}], "Text",
  CellTags->{"S1.7.2", "2.2"}],

Cell["\<\
This constructs a product of three terms, and expands out the \
result. \
\>", "MathCaption",
  CellTags->{"S1.7.2", "2.3"}],

Cell[CellGroupData[{

Cell["Expand[ Product[x + i, {i, 3}] ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(6 + 11\ x + 6\ x\^2 + x\^3\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.7.2"]
}, Open  ]],

Cell["This does the same thing, but with four terms. ", "MathCaption",
  CellTags->{"S1.7.2", "2.4"}],

Cell[CellGroupData[{

Cell["Expand[ Product[x + i, {i, 4}] ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(24 + 50\ x + 35\ x\^2 + 10\ x\^3 + x\^4\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.7.2"]
}, Open  ]],

Cell[TextData[{
  "This defines a function ",
  StyleBox["exprod", "MR"],
  " which constructs a product of ",
  StyleBox["n", "TI"],
  " terms, then expands it out. "
}], "MathCaption",
  CellTags->{"S1.7.2", "2.5"}],

Cell["exprod[n_] := Expand[ Product[ x + i, {i, 1, n} ] ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.7.2"],

Cell[TextData[{
  "Every time you use the function, it will execute the ",
  StyleBox["Product", "MR"],
  " and ",
  StyleBox["Expand", "MR"],
  " operations. "
}], "MathCaption",
  CellTags->{"S1.7.2", "2.6"}],

Cell[CellGroupData[{

Cell["exprod[5]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(120 + 274\ x + 225\ x\^2 + 85\ x\^3 + 15\ x\^4 + x\^5\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.7.2"]
}, Open  ]],

Cell[TextData[{
  "The functions you define in ",
  StyleBox["Mathematica", "TI"],
  " are essentially procedures that execute the commands you give. You can \
have several steps in your procedures, separated by semicolons. "
}], "Text",
  CellTags->{"S1.7.2", "2.7"}],

Cell["\<\
The result you get from the whole function is simply the last \
expression in the procedure. Notice that you have to put parentheses around \
the procedure when you define it like this. \
\>", "MathCaption",
  CellTags->{"S1.7.2", "2.8"}],

Cell["cex[n_, i_] := ( t = exprod[n]; Coefficient[t, x^i] )", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.7.2"],

Cell["This \[OpenCurlyDoubleQuote]runs\[CloseCurlyDoubleQuote] the procedure. \
", "MathCaption",
  CellTags->{"S1.7.2", "2.9"}],

Cell[CellGroupData[{

Cell["cex[5, 3]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(85\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.7.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[";", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell["a sequence of expressions to evaluate "]},
          {Cell[TextData[{
              StyleBox["Module[{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["proc", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a procedure with local variables ",
              StyleBox["a", "TI"],
              ", ",
              StyleBox["b", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.7.2"],

Cell["Constructing procedures. ", "Caption",
  CellTags->"S1.7.2"],

Cell[TextData[{
  "When you write procedures in ",
  StyleBox["Mathematica", "TI"],
  ", it is usually a good idea to make variables you use inside the \
procedures ",
  StyleBox["local", "TI"],
  ", so that they do not interfere with things outside the procedures. You \
can do this by setting up your procedures as ",
  StyleBox["modules", "TI"],
  ", in which you give a list of variables to be treated as local. "
}], "Text",
  CellTags->{"S1.7.2", "2.10"}],

Cell[TextData[{
  "The function ",
  StyleBox["cex", "MR"],
  " defined above is not a module, so the value of ",
  StyleBox["t", "MR"],
  " \[OpenCurlyDoubleQuote]escapes\[CloseCurlyDoubleQuote], and exists even \
after the function returns. "
}], "MathCaption",
  CellTags->{"S1.7.2", "2.11"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(120 + 274\ x + 225\ x\^2 + 85\ x\^3 + 15\ x\^4 + x\^5\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.7.2"]
}, Open  ]],

Cell[TextData[{
  "This function is defined as a module with local variable ",
  StyleBox["u", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.7.2", "2.12"}],

Cell["\<\
ncex[n_, i_] := Module[{u}, u = exprod[n]; Coefficient[u, \
x^i]]\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.7.2"],

Cell["The function gives the same result as before. ", "MathCaption",
  CellTags->{"S1.7.2", "2.13"}],

Cell[CellGroupData[{

Cell["ncex[5, 3]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(85\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.7.2"]
}, Open  ]],

Cell[TextData[{
  "Now, however, the value of ",
  StyleBox["u", "MR"],
  " does not escape from the function. "
}], "MathCaption",
  CellTags->{"S1.7.2", "2.14"}],

Cell[CellGroupData[{

Cell["u", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.7.2"],

Cell[BoxData[
    \(u\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.7.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.7.3 Repetitive Operations", "Subsection",
  CellTags->{"S1.7.3", "3.1"}],

Cell[TextData[{
  "In using ",
  StyleBox["Mathematica", "TI"],
  ", you sometimes need to repeat an operation many times. There are many \
ways to do this. Often the most natural is in fact to set up a structure such \
as a list with many elements, and then apply your operation to each of the \
elements. "
}], "Text",
  CellTags->{"S1.7.3", "3.2"}],

Cell[TextData[{
  "Another approach is to use the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Do", "MR"],
  ", which works much like the iteration constructs in languages such as C \
and Fortran. ",
  StyleBox["Do", "MR"],
  " uses the standard ",
  StyleBox["Mathematica", "TI"],
  " iterator notation introduced for ",
  StyleBox["Sum", "MR"],
  " and ",
  StyleBox["Product", "MR"],
  " in Section ",
  ButtonBox["1.5.4",
    ButtonData:>{"1.5.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.7.3", "3.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Do[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " running from ",
              StyleBox["1", "MR"],
              " to ",
              StyleBox["imax", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Do[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imin", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " running from ",
              StyleBox["imin", "TI"],
              " to ",
              StyleBox["imax", "TI"],
              " in steps of ",
              StyleBox["di", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Print[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a list of the values of ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " running from ",
              StyleBox["1", "MR"],
              " to ",
              StyleBox["imax", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.7.3"],

Cell["Implementing repetitive operations. ", "Caption",
  CellTags->"S1.7.3"],

Cell["This prints out the values of the first five factorials. ", \
"MathCaption",
  CellTags->{"S1.7.3", "3.4"}],

Cell[CellGroupData[{

Cell["Do[ Print[i!], {i, 5} ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \(24\)], "Print",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \(120\)], "Print",
  CellTags->"S1.7.3"]
}, Open  ]],

Cell["\<\
It is often more useful to have a list of results, which you can \
then manipulate further. \
\>", "MathCaption",
  CellTags->{"S1.7.3", "3.5"}],

Cell[CellGroupData[{

Cell["Table[ i!, {i, 5} ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \({1, 2, 6, 24, 120}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.7.3"]
}, Open  ]],

Cell[TextData[{
  "If you do not give an iteration variable, ",
  StyleBox["Mathematica", "TI"],
  " simply repeats the operation you have specified, without changing \
anything. "
}], "MathCaption",
  CellTags->{"S1.7.3", "3.6"}],

Cell[CellGroupData[{

Cell["r = 1; Do[ r = 1/(1 + r), {100} ]; r", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.7.3"],

Cell[BoxData[
    \(573147844013817084101\/927372692193078999176\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.7.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.7.4 Transformation Rules for Functions", "Subsection",
  CellTags->{"S1.7.4", "4.1"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.4.2",
    ButtonData:>{"1.4.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  " discussed how you can use transformation rules of the form ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["value", "TI"],
  " to replace symbols by values. The notion of transformation rules in ",
  StyleBox["Mathematica", "TI"],
  " is, however, quite general. You can set up transformation rules not only \
for symbols, but for any ",
  StyleBox["Mathematica", "TI"],
  " expression. "
}], "Text",
  CellTags->{"S1.7.4", "4.2"}],

Cell[TextData[{
  "Applying the transformation rule ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["3", "MR"],
  " replaces ",
  StyleBox["x", "MR"],
  " by ",
  StyleBox["3", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.7.4", "4.3"}],

Cell[CellGroupData[{

Cell["1 + f[x] + f[y] /. x -> 3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.7.4"],

Cell[BoxData[
    \(1 + f[3] + f[y]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.7.4"]
}, Open  ]],

Cell[TextData[{
  "You can also use a transformation rule for ",
  StyleBox["f[x]", "MR"],
  ". This rule does not affect ",
  StyleBox["f[y]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.7.4", "4.4"}],

Cell[CellGroupData[{

Cell["1 + f[x] + f[y] /. f[x] -> p", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.7.4"],

Cell[BoxData[
    \(1 + p + f[y]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.7.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["f[t_]", "MR"],
  " is a ",
  StyleBox["pattern", "TI"],
  " that stands for ",
  StyleBox["f", "MR"],
  " with any argument. "
}], "MathCaption",
  CellTags->{"S1.7.4", "4.5"}],

Cell[CellGroupData[{

Cell["1 + f[x] + f[y] /. f[t_] -> t^2", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.7.4"],

Cell[BoxData[
    \(1 + x\^2 + y\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.7.4"]
}, Open  ]],

Cell[TextData[{
  "Probably the most powerful aspect of transformation rules in ",
  StyleBox["Mathematica", "TI"],
  " is that they can involve not only literal expressions, but also ",
  StyleBox["patterns", "TI"],
  ". A pattern is an expression such as ",
  StyleBox["f[t_]", "MR"],
  " which contains a blank (underscore). The blank can stand for any \
expression. Thus, a transformation rule for ",
  StyleBox["f[t_]", "MR"],
  " specifies how the function ",
  StyleBox["f", "MR"],
  " with ",
  StyleBox["any", "TI"],
  " argument should be transformed. Notice that, in contrast, a \
transformation rule for ",
  StyleBox["f[x]", "MR"],
  " without a blank, specifies only how the literal expression ",
  StyleBox["f[x]", "MR"],
  " should be transformed, and does not, for example, say anything about the \
transformation of ",
  StyleBox["f[y]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.7.4", "4.6"}],

Cell[TextData[{
  "When you give a function definition such as ",
  StyleBox["f[t_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["t^2", "MR"],
  ", all you are doing is telling ",
  StyleBox["Mathematica", "TI"],
  " to automatically apply the transformation rule ",
  StyleBox["f[t_]", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["t^2", "MR"],
  " whenever possible. "
}], "Text",
  CellTags->{"S1.7.4", "4.7"}],

Cell["\<\
You can set up transformation rules for expressions of any form. \
\
\>", "MathCaption",
  CellTags->{"S1.7.4", "4.8"}],

Cell[CellGroupData[{

Cell["f[a b] + f[c d] /. f[x_ y_] -> f[x] + f[y]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.7.4"],

Cell[BoxData[
    \(f[a] + f[b] + f[c] + f[d]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.7.4"]
}, Open  ]],

Cell[TextData[{
  "This uses a transformation rule for ",
  StyleBox["x^p_", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.7.4", "4.9"}],

Cell[CellGroupData[{

Cell["1 + x^2 + x^4 /. x^p_ -> f[p]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.7.4"],

Cell[BoxData[
    \(1 + f[2] + f[4]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.7.4"]
}, Open  ]],

Cell[TextData[{
  "Sections ",
  ButtonBox["2.3",
    ButtonData:>{"2.3"},
    ButtonStyle->"MainBookLink"],
  " and ",
  ButtonBox["2.5",
    ButtonData:>{"2.5"},
    ButtonStyle->"MainBookLink"],
  " will explain in detail how to set up patterns and transformation rules \
for any kind of expression. Suffice it to say here that in ",
  StyleBox["Mathematica", "TI"],
  " all expressions have a definite symbolic structure; transformation rules \
allow you to transform parts of that structure. "
}], "Text",
  CellTags->{"S1.7.4", "4.10"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.7.0"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S1.7.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S1.7.0", "0.1"}]},
  "S1.7.1"->{
    Cell[1926, 61, 77, 1, 70, "Subsection",
      CellTags->{"S1.7.1", "1.1"}],
    Cell[2006, 64, 434, 12, 70, "Text",
      CellTags->{"S1.7.1", "1.2"}],
    Cell[2443, 78, 703, 20, 70, "Text",
      CellTags->{"S1.7.1", "1.3"}],
    Cell[3149, 100, 199, 7, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.4"}],
    Cell[3351, 109, 76, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[3430, 113, 116, 4, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.5"}],
    Cell[3571, 121, 70, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[3644, 125, 95, 3, 70, "Output",
      CellTags->"S1.7.1"],
    Cell[3754, 131, 84, 1, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.6"}],
    Cell[3863, 136, 68, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[3934, 140, 83, 3, 70, "Output",
      CellTags->"S1.7.1"],
    Cell[4032, 146, 98, 1, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.7"}],
    Cell[4155, 151, 75, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[4233, 155, 101, 3, 70, "Output",
      CellTags->"S1.7.1"],
    Cell[4349, 161, 130, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.8"}],
    Cell[4504, 170, 82, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[4589, 174, 120, 3, 70, "Output",
      CellTags->"S1.7.1"],
    Cell[4724, 180, 158, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.9"}],
    Cell[4907, 189, 66, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[4976, 193, 65, 2, 70, "Print",
      CellTags->"S1.7.1"],
    Cell[5044, 197, 413, 13, 70, "Print",
      CellTags->"S1.7.1"],
    Cell[5472, 213, 1104, 37, 70, "DefinitionBox",
      CellTags->"S1.7.1"],
    Cell[6579, 252, 121, 5, 70, "Caption",
      CellTags->"S1.7.1"],
    Cell[6703, 259, 491, 12, 70, "Text",
      CellTags->{"S1.7.1", "1.10"}],
    Cell[7197, 273, 149, 4, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.11"}],
    Cell[7349, 279, 102, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[7454, 283, 186, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.12"}],
    Cell[7665, 292, 80, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[7748, 296, 128, 3, 70, "Output",
      CellTags->"S1.7.1"],
    Cell[7891, 302, 172, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.13"}],
    Cell[8066, 309, 95, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[8164, 313, 88, 1, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.14"}],
    Cell[8277, 318, 70, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[8350, 322, 68, 2, 70, "Print",
      CellTags->"S1.7.1"],
    Cell[8421, 326, 439, 13, 70, "Print",
      CellTags->"S1.7.1"],
    Cell[8875, 342, 137, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.15"}],
    Cell[9015, 349, 76, 2, 70, "Input",
      CellTags->"S1.7.1"],
    Cell[9094, 353, 558, 15, 70, "Text",
      CellTags->{"S1.7.1", "1.16"}]},
  "1.1"->{
    Cell[1926, 61, 77, 1, 70, "Subsection",
      CellTags->{"S1.7.1", "1.1"}]},
  "1.2"->{
    Cell[2006, 64, 434, 12, 70, "Text",
      CellTags->{"S1.7.1", "1.2"}]},
  "1.3"->{
    Cell[2443, 78, 703, 20, 70, "Text",
      CellTags->{"S1.7.1", "1.3"}]},
  "1.4"->{
    Cell[3149, 100, 199, 7, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.4"}]},
  "1.5"->{
    Cell[3430, 113, 116, 4, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.5"}]},
  "1.6"->{
    Cell[3754, 131, 84, 1, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.6"}]},
  "1.7"->{
    Cell[4032, 146, 98, 1, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.7"}]},
  "1.8"->{
    Cell[4349, 161, 130, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.8"}]},
  "1.9"->{
    Cell[4724, 180, 158, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.9"}]},
  "1.10"->{
    Cell[6703, 259, 491, 12, 70, "Text",
      CellTags->{"S1.7.1", "1.10"}]},
  "1.11"->{
    Cell[7197, 273, 149, 4, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.11"}]},
  "1.12"->{
    Cell[7454, 283, 186, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.12"}]},
  "1.13"->{
    Cell[7891, 302, 172, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.13"}]},
  "1.14"->{
    Cell[8164, 313, 88, 1, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.14"}]},
  "1.15"->{
    Cell[8875, 342, 137, 5, 70, "MathCaption",
      CellTags->{"S1.7.1", "1.15"}]},
  "1.16"->{
    Cell[9094, 353, 558, 15, 70, "Text",
      CellTags->{"S1.7.1", "1.16"}]},
  "S1.7.2"->{
    Cell[9689, 373, 82, 1, 70, "Subsection",
      CellTags->{"S1.7.2", "2.1"}],
    Cell[9774, 376, 330, 9, 70, "Text",
      CellTags->{"S1.7.2", "2.2"}],
    Cell[10107, 387, 134, 4, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.3"}],
    Cell[10266, 395, 96, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[10365, 399, 107, 3, 70, "Output",
      CellTags->"S1.7.2"],
    Cell[10487, 405, 101, 1, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.4"}],
    Cell[10613, 410, 96, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[10712, 414, 120, 3, 70, "Output",
      CellTags->"S1.7.2"],
    Cell[10847, 420, 217, 7, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.5"}],
    Cell[11067, 429, 115, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[11185, 433, 210, 7, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.6"}],
    Cell[11420, 444, 73, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[11496, 448, 134, 3, 70, "Output",
      CellTags->"S1.7.2"],
    Cell[11645, 454, 268, 6, 70, "Text",
      CellTags->{"S1.7.2", "2.7"}],
    Cell[11916, 462, 248, 5, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.8"}],
    Cell[12167, 469, 117, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[12287, 473, 128, 2, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.9"}],
    Cell[12440, 479, 73, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[12516, 483, 83, 3, 70, "Output",
      CellTags->"S1.7.2"],
    Cell[12614, 489, 1576, 49, 70, "DefinitionBox",
      CellTags->"S1.7.2"],
    Cell[14193, 540, 66, 1, 70, "Caption",
      CellTags->"S1.7.2"],
    Cell[14262, 543, 461, 11, 70, "Text",
      CellTags->{"S1.7.2", "2.10"}],
    Cell[14726, 556, 295, 8, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.11"}],
    Cell[15046, 568, 65, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[15114, 572, 134, 3, 70, "Output",
      CellTags->"S1.7.2"],
    Cell[15263, 578, 159, 5, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.12"}],
    Cell[15425, 585, 137, 5, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[15565, 592, 101, 1, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.13"}],
    Cell[15691, 597, 74, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[15768, 601, 83, 3, 70, "Output",
      CellTags->"S1.7.2"],
    Cell[15866, 607, 163, 5, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.14"}],
    Cell[16054, 616, 66, 2, 70, "Input",
      CellTags->"S1.7.2"],
    Cell[16123, 620, 83, 3, 70, "Output",
      CellTags->"S1.7.2"]},
  "2.1"->{
    Cell[9689, 373, 82, 1, 70, "Subsection",
      CellTags->{"S1.7.2", "2.1"}]},
  "2.2"->{
    Cell[9774, 376, 330, 9, 70, "Text",
      CellTags->{"S1.7.2", "2.2"}]},
  "2.3"->{
    Cell[10107, 387, 134, 4, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.3"}]},
  "2.4"->{
    Cell[10487, 405, 101, 1, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.4"}]},
  "2.5"->{
    Cell[10847, 420, 217, 7, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.5"}]},
  "2.6"->{
    Cell[11185, 433, 210, 7, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.6"}]},
  "2.7"->{
    Cell[11645, 454, 268, 6, 70, "Text",
      CellTags->{"S1.7.2", "2.7"}]},
  "2.8"->{
    Cell[11916, 462, 248, 5, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.8"}]},
  "2.9"->{
    Cell[12287, 473, 128, 2, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.9"}]},
  "2.10"->{
    Cell[14262, 543, 461, 11, 70, "Text",
      CellTags->{"S1.7.2", "2.10"}]},
  "2.11"->{
    Cell[14726, 556, 295, 8, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.11"}]},
  "2.12"->{
    Cell[15263, 578, 159, 5, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.12"}]},
  "2.13"->{
    Cell[15565, 592, 101, 1, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.13"}]},
  "2.14"->{
    Cell[15866, 607, 163, 5, 70, "MathCaption",
      CellTags->{"S1.7.2", "2.14"}]},
  "S1.7.3"->{
    Cell[16255, 629, 80, 1, 70, "Subsection",
      CellTags->{"S1.7.3", "3.1"}],
    Cell[16338, 632, 351, 8, 70, "Text",
      CellTags->{"S1.7.3", "3.2"}],
    Cell[16692, 642, 562, 20, 70, "Text",
      CellTags->{"S1.7.3", "3.3"}],
    Cell[17257, 664, 2844, 93, 70, "DefinitionBox",
      CellTags->"S1.7.3"],
    Cell[20104, 759, 77, 1, 70, "Caption",
      CellTags->"S1.7.3"],
    Cell[20184, 762, 113, 2, 70, "MathCaption",
      CellTags->{"S1.7.3", "3.4"}],
    Cell[20322, 768, 87, 2, 70, "Input",
      CellTags->"S1.7.3"],
    Cell[20412, 772, 56, 2, 70, "Print",
      CellTags->"S1.7.3"],
    Cell[20471, 776, 56, 2, 70, "Print",
      CellTags->"S1.7.3"],
    Cell[20530, 780, 56, 2, 70, "Print",
      CellTags->"S1.7.3"],
    Cell[20589, 784, 57, 2, 70, "Print",
      CellTags->"S1.7.3"],
    Cell[20649, 788, 58, 2, 70, "Print",
      CellTags->"S1.7.3"],
    Cell[20722, 793, 154, 4, 70, "MathCaption",
      CellTags->{"S1.7.3", "3.5"}],
    Cell[20901, 801, 83, 2, 70, "Input",
      CellTags->"S1.7.3"],
    Cell[20987, 805, 99, 3, 70, "Output",
      CellTags->"S1.7.3"],
    Cell[21101, 811, 230, 6, 70, "MathCaption",
      CellTags->{"S1.7.3", "3.6"}],
    Cell[21356, 821, 100, 2, 70, "Input",
      CellTags->"S1.7.3"],
    Cell[21459, 825, 125, 3, 70, "Output",
      CellTags->"S1.7.3"]},
  "3.1"->{
    Cell[16255, 629, 80, 1, 70, "Subsection",
      CellTags->{"S1.7.3", "3.1"}]},
  "3.2"->{
    Cell[16338, 632, 351, 8, 70, "Text",
      CellTags->{"S1.7.3", "3.2"}]},
  "3.3"->{
    Cell[16692, 642, 562, 20, 70, "Text",
      CellTags->{"S1.7.3", "3.3"}]},
  "3.4"->{
    Cell[20184, 762, 113, 2, 70, "MathCaption",
      CellTags->{"S1.7.3", "3.4"}]},
  "3.5"->{
    Cell[20722, 793, 154, 4, 70, "MathCaption",
      CellTags->{"S1.7.3", "3.5"}]},
  "3.6"->{
    Cell[21101, 811, 230, 6, 70, "MathCaption",
      CellTags->{"S1.7.3", "3.6"}]},
  "S1.7.4"->{
    Cell[21633, 834, 93, 1, 70, "Subsection",
      CellTags->{"S1.7.4", "4.1"}],
    Cell[21729, 837, 581, 18, 70, "Text",
      CellTags->{"S1.7.4", "4.2"}],
    Cell[22313, 857, 267, 13, 70, "MathCaption",
      CellTags->{"S1.7.4", "4.3"}],
    Cell[22605, 874, 89, 2, 28, "Input",
      CellTags->"S1.7.4"],
    Cell[22697, 878, 96, 3, 70, "Output",
      CellTags->"S1.7.4"],
    Cell[22808, 884, 207, 7, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.4"}],
    Cell[23040, 895, 92, 2, 28, "Input",
      CellTags->"S1.7.4"],
    Cell[23135, 899, 93, 3, 25, "Output",
      CellTags->"S1.7.4"],
    Cell[23243, 905, 204, 8, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.5"}],
    Cell[23472, 917, 95, 2, 28, "Input",
      CellTags->"S1.7.4"],
    Cell[23570, 921, 96, 3, 27, "Output",
      CellTags->"S1.7.4"],
    Cell[23681, 927, 912, 24, 120, "Text",
      CellTags->{"S1.7.4", "4.6"}],
    Cell[24596, 953, 437, 17, 56, "Text",
      CellTags->{"S1.7.4", "4.7"}],
    Cell[25036, 972, 129, 4, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.8"}],
    Cell[25190, 980, 106, 2, 28, "Input",
      CellTags->"S1.7.4"],
    Cell[25299, 984, 106, 3, 25, "Output",
      CellTags->"S1.7.4"],
    Cell[25420, 990, 140, 5, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.9"}],
    Cell[25585, 999, 93, 2, 28, "Input",
      CellTags->"S1.7.4"],
    Cell[25681, 1003, 96, 3, 25, "Output",
      CellTags->"S1.7.4"],
    Cell[25792, 1009, 542, 15, 72, "Text",
      CellTags->{"S1.7.4", "4.10"}]},
  "4.1"->{
    Cell[21633, 834, 93, 1, 70, "Subsection",
      CellTags->{"S1.7.4", "4.1"}]},
  "4.2"->{
    Cell[21729, 837, 581, 18, 70, "Text",
      CellTags->{"S1.7.4", "4.2"}]},
  "4.3"->{
    Cell[22313, 857, 267, 13, 70, "MathCaption",
      CellTags->{"S1.7.4", "4.3"}]},
  "4.4"->{
    Cell[22808, 884, 207, 7, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.4"}]},
  "4.5"->{
    Cell[23243, 905, 204, 8, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.5"}]},
  "4.6"->{
    Cell[23681, 927, 912, 24, 120, "Text",
      CellTags->{"S1.7.4", "4.6"}]},
  "4.7"->{
    Cell[24596, 953, 437, 17, 56, "Text",
      CellTags->{"S1.7.4", "4.7"}]},
  "4.8"->{
    Cell[25036, 972, 129, 4, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.8"}]},
  "4.9"->{
    Cell[25420, 990, 140, 5, 40, "MathCaption",
      CellTags->{"S1.7.4", "4.9"}]},
  "4.10"->{
    Cell[25792, 1009, 542, 15, 72, "Text",
      CellTags->{"S1.7.4", "4.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.7.0", 26977, 1044},
  {"0.1", 27067, 1047},
  {"S1.7.1", 27160, 1050},
  {"1.1", 29976, 1127},
  {"1.2", 30068, 1130},
  {"1.3", 30156, 1133},
  {"1.4", 30244, 1136},
  {"1.5", 30339, 1139},
  {"1.6", 30434, 1142},
  {"1.7", 30528, 1145},
  {"1.8", 30622, 1148},
  {"1.9", 30717, 1151},
  {"1.10", 30813, 1154},
  {"1.11", 30904, 1157},
  {"1.12", 31001, 1160},
  {"1.13", 31098, 1163},
  {"1.14", 31195, 1166},
  {"1.15", 31291, 1169},
  {"1.16", 31388, 1172},
  {"S1.7.2", 31481, 1175},
  {"2.1", 33969, 1242},
  {"2.2", 34062, 1245},
  {"2.3", 34150, 1248},
  {"2.4", 34246, 1251},
  {"2.5", 34342, 1254},
  {"2.6", 34438, 1257},
  {"2.7", 34534, 1260},
  {"2.8", 34623, 1263},
  {"2.9", 34719, 1266},
  {"2.10", 34816, 1269},
  {"2.11", 34908, 1272},
  {"2.12", 35006, 1275},
  {"2.13", 35104, 1278},
  {"2.14", 35202, 1281},
  {"S1.7.3", 35302, 1284},
  {"3.1", 36636, 1321},
  {"3.2", 36730, 1324},
  {"3.3", 36819, 1327},
  {"3.4", 36909, 1330},
  {"3.5", 37005, 1333},
  {"3.6", 37101, 1336},
  {"S1.7.4", 37200, 1339},
  {"4.1", 38718, 1380},
  {"4.2", 38812, 1383},
  {"4.3", 38902, 1386},
  {"4.4", 38999, 1389},
  {"4.5", 39095, 1392},
  {"4.6", 39191, 1395},
  {"4.7", 39282, 1398},
  {"4.8", 39372, 1401},
  {"4.9", 39468, 1404},
  {"4.10", 39565, 1407}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 125, 4, 65, "Section",
  CellTags->{"S1.7.0", "0.1"}],

Cell[CellGroupData[{
Cell[1926, 61, 77, 1, 70, "Subsection",
  CellTags->{"S1.7.1", "1.1"}],
Cell[2006, 64, 434, 12, 70, "Text",
  CellTags->{"S1.7.1", "1.2"}],
Cell[2443, 78, 703, 20, 70, "Text",
  CellTags->{"S1.7.1", "1.3"}],
Cell[3149, 100, 199, 7, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.4"}],
Cell[3351, 109, 76, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[3430, 113, 116, 4, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.5"}],

Cell[CellGroupData[{
Cell[3571, 121, 70, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[3644, 125, 95, 3, 70, "Output",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[3754, 131, 84, 1, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.6"}],

Cell[CellGroupData[{
Cell[3863, 136, 68, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[3934, 140, 83, 3, 70, "Output",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[4032, 146, 98, 1, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.7"}],

Cell[CellGroupData[{
Cell[4155, 151, 75, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[4233, 155, 101, 3, 70, "Output",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[4349, 161, 130, 5, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.8"}],

Cell[CellGroupData[{
Cell[4504, 170, 82, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[4589, 174, 120, 3, 70, "Output",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[4724, 180, 158, 5, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.9"}],

Cell[CellGroupData[{
Cell[4907, 189, 66, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[4976, 193, 65, 2, 70, "Print",
  CellTags->"S1.7.1"],
Cell[5044, 197, 413, 13, 70, "Print",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[5472, 213, 1104, 37, 70, "DefinitionBox",
  CellTags->"S1.7.1"],
Cell[6579, 252, 121, 5, 70, "Caption",
  CellTags->"S1.7.1"],
Cell[6703, 259, 491, 12, 70, "Text",
  CellTags->{"S1.7.1", "1.10"}],
Cell[7197, 273, 149, 4, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.11"}],
Cell[7349, 279, 102, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[7454, 283, 186, 5, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.12"}],

Cell[CellGroupData[{
Cell[7665, 292, 80, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[7748, 296, 128, 3, 70, "Output",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[7891, 302, 172, 5, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.13"}],
Cell[8066, 309, 95, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[8164, 313, 88, 1, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.14"}],

Cell[CellGroupData[{
Cell[8277, 318, 70, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[8350, 322, 68, 2, 70, "Print",
  CellTags->"S1.7.1"],
Cell[8421, 326, 439, 13, 70, "Print",
  CellTags->"S1.7.1"]
}, Open  ]],
Cell[8875, 342, 137, 5, 70, "MathCaption",
  CellTags->{"S1.7.1", "1.15"}],
Cell[9015, 349, 76, 2, 70, "Input",
  CellTags->"S1.7.1"],
Cell[9094, 353, 558, 15, 70, "Text",
  CellTags->{"S1.7.1", "1.16"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9689, 373, 82, 1, 70, "Subsection",
  CellTags->{"S1.7.2", "2.1"}],
Cell[9774, 376, 330, 9, 70, "Text",
  CellTags->{"S1.7.2", "2.2"}],
Cell[10107, 387, 134, 4, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.3"}],

Cell[CellGroupData[{
Cell[10266, 395, 96, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[10365, 399, 107, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]],
Cell[10487, 405, 101, 1, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.4"}],

Cell[CellGroupData[{
Cell[10613, 410, 96, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[10712, 414, 120, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]],
Cell[10847, 420, 217, 7, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.5"}],
Cell[11067, 429, 115, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[11185, 433, 210, 7, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.6"}],

Cell[CellGroupData[{
Cell[11420, 444, 73, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[11496, 448, 134, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]],
Cell[11645, 454, 268, 6, 70, "Text",
  CellTags->{"S1.7.2", "2.7"}],
Cell[11916, 462, 248, 5, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.8"}],
Cell[12167, 469, 117, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[12287, 473, 128, 2, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.9"}],

Cell[CellGroupData[{
Cell[12440, 479, 73, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[12516, 483, 83, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]],
Cell[12614, 489, 1576, 49, 70, "DefinitionBox",
  CellTags->"S1.7.2"],
Cell[14193, 540, 66, 1, 70, "Caption",
  CellTags->"S1.7.2"],
Cell[14262, 543, 461, 11, 70, "Text",
  CellTags->{"S1.7.2", "2.10"}],
Cell[14726, 556, 295, 8, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.11"}],

Cell[CellGroupData[{
Cell[15046, 568, 65, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[15114, 572, 134, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]],
Cell[15263, 578, 159, 5, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.12"}],
Cell[15425, 585, 137, 5, 70, "Input",
  CellTags->"S1.7.2"],
Cell[15565, 592, 101, 1, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.13"}],

Cell[CellGroupData[{
Cell[15691, 597, 74, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[15768, 601, 83, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]],
Cell[15866, 607, 163, 5, 70, "MathCaption",
  CellTags->{"S1.7.2", "2.14"}],

Cell[CellGroupData[{
Cell[16054, 616, 66, 2, 70, "Input",
  CellTags->"S1.7.2"],
Cell[16123, 620, 83, 3, 70, "Output",
  CellTags->"S1.7.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16255, 629, 80, 1, 70, "Subsection",
  CellTags->{"S1.7.3", "3.1"}],
Cell[16338, 632, 351, 8, 70, "Text",
  CellTags->{"S1.7.3", "3.2"}],
Cell[16692, 642, 562, 20, 70, "Text",
  CellTags->{"S1.7.3", "3.3"}],
Cell[17257, 664, 2844, 93, 70, "DefinitionBox",
  CellTags->"S1.7.3"],
Cell[20104, 759, 77, 1, 70, "Caption",
  CellTags->"S1.7.3"],
Cell[20184, 762, 113, 2, 70, "MathCaption",
  CellTags->{"S1.7.3", "3.4"}],

Cell[CellGroupData[{
Cell[20322, 768, 87, 2, 70, "Input",
  CellTags->"S1.7.3"],
Cell[20412, 772, 56, 2, 70, "Print",
  CellTags->"S1.7.3"],
Cell[20471, 776, 56, 2, 70, "Print",
  CellTags->"S1.7.3"],
Cell[20530, 780, 56, 2, 70, "Print",
  CellTags->"S1.7.3"],
Cell[20589, 784, 57, 2, 70, "Print",
  CellTags->"S1.7.3"],
Cell[20649, 788, 58, 2, 70, "Print",
  CellTags->"S1.7.3"]
}, Open  ]],
Cell[20722, 793, 154, 4, 70, "MathCaption",
  CellTags->{"S1.7.3", "3.5"}],

Cell[CellGroupData[{
Cell[20901, 801, 83, 2, 70, "Input",
  CellTags->"S1.7.3"],
Cell[20987, 805, 99, 3, 70, "Output",
  CellTags->"S1.7.3"]
}, Open  ]],
Cell[21101, 811, 230, 6, 70, "MathCaption",
  CellTags->{"S1.7.3", "3.6"}],

Cell[CellGroupData[{
Cell[21356, 821, 100, 2, 70, "Input",
  CellTags->"S1.7.3"],
Cell[21459, 825, 125, 3, 70, "Output",
  CellTags->"S1.7.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21633, 834, 93, 1, 70, "Subsection",
  CellTags->{"S1.7.4", "4.1"}],
Cell[21729, 837, 581, 18, 70, "Text",
  CellTags->{"S1.7.4", "4.2"}],
Cell[22313, 857, 267, 13, 70, "MathCaption",
  CellTags->{"S1.7.4", "4.3"}],

Cell[CellGroupData[{
Cell[22605, 874, 89, 2, 28, "Input",
  CellTags->"S1.7.4"],
Cell[22697, 878, 96, 3, 70, "Output",
  CellTags->"S1.7.4"]
}, Open  ]],
Cell[22808, 884, 207, 7, 40, "MathCaption",
  CellTags->{"S1.7.4", "4.4"}],

Cell[CellGroupData[{
Cell[23040, 895, 92, 2, 28, "Input",
  CellTags->"S1.7.4"],
Cell[23135, 899, 93, 3, 25, "Output",
  CellTags->"S1.7.4"]
}, Open  ]],
Cell[23243, 905, 204, 8, 40, "MathCaption",
  CellTags->{"S1.7.4", "4.5"}],

Cell[CellGroupData[{
Cell[23472, 917, 95, 2, 28, "Input",
  CellTags->"S1.7.4"],
Cell[23570, 921, 96, 3, 27, "Output",
  CellTags->"S1.7.4"]
}, Open  ]],
Cell[23681, 927, 912, 24, 120, "Text",
  CellTags->{"S1.7.4", "4.6"}],
Cell[24596, 953, 437, 17, 56, "Text",
  CellTags->{"S1.7.4", "4.7"}],
Cell[25036, 972, 129, 4, 40, "MathCaption",
  CellTags->{"S1.7.4", "4.8"}],

Cell[CellGroupData[{
Cell[25190, 980, 106, 2, 28, "Input",
  CellTags->"S1.7.4"],
Cell[25299, 984, 106, 3, 25, "Output",
  CellTags->"S1.7.4"]
}, Open  ]],
Cell[25420, 990, 140, 5, 40, "MathCaption",
  CellTags->{"S1.7.4", "4.9"}],

Cell[CellGroupData[{
Cell[25585, 999, 93, 2, 28, "Input",
  CellTags->"S1.7.4"],
Cell[25681, 1003, 96, 3, 25, "Output",
  CellTags->"S1.7.4"]
}, Open  ]],
Cell[25792, 1009, 542, 15, 72, "Text",
  CellTags->{"S1.7.4", "4.10"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

