(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    125590,       4608]*)
(*NotebookOutlinePosition[    171811,       5953]*)
(*  CellTagsIndexPosition[    167957,       5800]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.8 ", "HeadingNumber"],
  "Lists"
}], "Section",
  CellTags->{"S1.8.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.8.1 Collecting Objects Together", "Subsection",
  CellTags->{"S1.8.1", "1.1"}],

Cell[TextData[{
  "We first encountered lists in Section\[NonBreakingSpace]",
  ButtonBox["1.2.3",
    ButtonData:>{"1.2.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " as a way of collecting numbers together. In this section, we shall see \
many different ways to use lists. You will find that lists are some of the \
most flexible and powerful objects in ",
  StyleBox["Mathematica", "TI"],
  ". You will see that lists in ",
  StyleBox["Mathematica", "TI"],
  " represent generalizations of several standard concepts in mathematics and \
computer science. "
}], "Text",
  CellTags->{"S1.8.1", "1.2"}],

Cell[TextData[{
  "At a basic level, what a ",
  StyleBox["Mathematica", "TI"],
  " list essentially does is to provide a way for you to collect together \
several expressions of any kind. "
}], "Text",
  CellTags->{"S1.8.1", "1.3"}],

Cell["Here is a list of numbers. ", "MathCaption",
  CellTags->{"S1.8.1", "1.4"}],

Cell[CellGroupData[{

Cell["{2, 3, 4}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.1"],

Cell[BoxData[
    \({2, 3, 4}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.1"]
}, Open  ]],

Cell["This gives a list of symbolic expressions. ", "MathCaption",
  CellTags->{"S1.8.1", "1.5"}],

Cell[CellGroupData[{

Cell["x^% - 1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.1"],

Cell[BoxData[
    \({\(-1\) + x\^2, \(-1\) + x\^3, \(-1\) + x\^4}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.1"]
}, Open  ]],

Cell["You can differentiate these expressions. ", "MathCaption",
  CellTags->{"S1.8.1", "1.6"}],

Cell[CellGroupData[{

Cell["D[%, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.1"],

Cell[BoxData[
    \({2\ x, 3\ x\^2, 4\ x\^3}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.1"]
}, Open  ]],

Cell[TextData[{
  "And then you can find values when ",
  StyleBox["x", "MR"],
  " is replaced with ",
  StyleBox["3", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.1", "1.7"}],

Cell[CellGroupData[{

Cell["% /. x -> 3", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.1"],

Cell[BoxData[
    \({6, 27, 108}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.1"]
}, Open  ]],

Cell[TextData[{
  "The mathematical functions that are built into ",
  StyleBox["Mathematica", "TI"],
  " are mostly set up to be \[OpenCurlyDoubleQuote]listable\
\[CloseCurlyDoubleQuote] so that they act separately on each element of a \
list.  This is, however, not true of all functions in ",
  StyleBox["Mathematica", "TI"],
  ". Unless you set it up specially, a new function ",
  StyleBox["f", "MR"],
  " that you introduce will treat lists just as single objects. Sections ",
  ButtonBox["2.2.4",
    ButtonData:>{"2.2.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " and ",
  ButtonBox["2.2.10",
    ButtonData:>{"2.2.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  " will describe how you can use ",
  StyleBox["Map", "MR"],
  " and ",
  StyleBox["Thread", "MR"],
  " to apply a function like this separately to each element in a list. "
}], "Text",
  CellTags->{"S1.8.1", "1.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.2 Making Tables of Values", "Subsection",
  CellTags->{"S1.8.2", "2.1"}],

Cell["\<\
You can use lists as tables of values. You can generate the tables, \
for example, by evaluating an expression for a sequence of different \
parameter values. \
\>", "Text",
  CellTags->{"S1.8.2", "2.2"}],

Cell[TextData[{
  "This gives a table of the values of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["i",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", with ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " running from 1 to 6. "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.3"}],

Cell[CellGroupData[{

Cell["Table[i^2, {i, 6}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "Here is a table of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["n",
                "TI"], "/", "5"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  " for ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " from ",
  Cell[BoxData[
      \(TraditionalForm\`0\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`4\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.4"}],

Cell[CellGroupData[{

Cell["Table[Sin[n/5], {n, 0, 4}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({0, Sin[1\/5], Sin[2\/5], Sin[3\/5], Sin[4\/5]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell["This gives the numerical values. ", "MathCaption",
  CellTags->{"S1.8.2", "2.5"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({0.`, 0.19866933079506122`, 0.3894183423086505`, 0.5646424733950354`, 
      0.7173560908995228`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell["You can also make tables of formulas. ", "MathCaption",
  CellTags->{"S1.8.2", "2.6"}],

Cell[CellGroupData[{

Cell["Table[x^i + 2i, {i, 5}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({2 + x, 4 + x\^2, 6 + x\^3, 8 + x\^4, 10 + x\^5}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Table", "MR"],
  " uses exactly the same iterator notation as the functions ",
  StyleBox["Sum", "MR"],
  " and ",
  StyleBox["Product", "MR"],
  ", which were discussed in Section ",
  ButtonBox["1.5.4",
    ButtonData:>{"1.5.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.7"}],

Cell[CellGroupData[{

Cell["Product[x^i + 2i, {i, 5}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \(\((2 + x)\)\ \((4 + x\^2)\)\ \((6 + x\^3)\)\ \((8 + x\^4)\)\ \((10 + 
          x\^5)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "This makes a table with values of ",
  StyleBox["x", "MR"],
  " running from ",
  StyleBox["0", "MR"],
  " to ",
  StyleBox["1", "MR"],
  " in steps of ",
  StyleBox["0.25", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.8"}],

Cell[CellGroupData[{

Cell["Table[Sqrt[x], {x, 0, 1, 0.25}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({0, 0.5`, 0.7071067811865476`, 0.8660254037844386`, 1.`}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "You can perform other operations on the lists you get from ",
  StyleBox["Table", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.9"}],

Cell[CellGroupData[{

Cell["%^2 + 3", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({3, 3.25`, 3.5`, 3.75`, 4.`}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TableForm", "MR"],
  " displays lists in a \
\[OpenCurlyDoubleQuote]tabular\[CloseCurlyDoubleQuote] format. Notice that \
both words in the name ",
  StyleBox["TableForm", "MR"],
  " begin with capital letters.  "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.10"}],

Cell[CellGroupData[{

Cell["% // TableForm", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"3"},
          {"3.25`"},
          {"3.5`"},
          {"3.75`"},
          {"4.`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {3, 3.25, 3.5, 3.75, 4}]]], "Output",
  CellLabel->"Out[8]//TableForm= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "All the examples so far have been of tables obtained by varying a single \
parameter. You can also make tables that involve several parameters. These \
multidimensional tables are specified using the standard ",
  StyleBox["Mathematica", "TI"],
  " iterator notation, discussed in Section ",
  ButtonBox["1.5.4",
    ButtonData:>{"1.5.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.8.2", "2.11"}],

Cell[TextData[{
  "This makes a table of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], 
            RowBox[{" ", 
              StyleBox["i",
                "TI"]}]], "+", 
          SuperscriptBox[
            StyleBox["y",
              "TI"], 
            RowBox[{" ", 
              StyleBox["j",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  " with ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " running from ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`3\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  " running from ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.12"}],

Cell[CellGroupData[{

Cell["Table[x^i + y^j, {i, 3}, {j, 2}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({{x + y, x + y\^2}, {x\^2 + y, x\^2 + y\^2}, {x\^3 + y, 
        x\^3 + y\^2}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "The table in this example is a ",
  StyleBox["list of lists", "TI"],
  ". The elements of the outer list correspond to successive values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". The elements of each inner list correspond to successive values of ",
  Cell[BoxData[
      FormBox[
        StyleBox["j",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", with ",
  Cell[BoxData[
      FormBox[
        StyleBox["i",
          "TI"], TraditionalForm]], "InlineFormula"],
  " fixed. "
}], "Text",
  CellTags->{"S1.8.2", "2.13"}],

Cell["\<\
Sometimes you may want to generate a table by evaluating a \
particular expression many times, without incrementing any variables. \
\>", \
"Text",
  CellTags->{"S1.8.2", "2.14"}],

Cell[TextData[{
  "This creates a list containing four copies of the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.15"}],

Cell[CellGroupData[{

Cell["Table[x, {4}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({x, x, x, x}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "This gives a list of four pseudorandom numbers. ",
  StyleBox["Table", "MR"],
  " re\[Hyphen]evaluates ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " for each element in the list, so that you get a different pseudorandom \
number. "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.16"}],

Cell[CellGroupData[{

Cell["Table[Random[ ], {4}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({0.056070794834861534`, 0.630299795779359`, 0.3598942942214413`, 
      0.8713770771750458`}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " values of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the values of ",
              StyleBox["f", "TI"],
              " as ",
              StyleBox["i", "TI"],
              " runs from ",
              StyleBox["1", "MR"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of values with ",
              StyleBox["i", "TI"],
              " running from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "use steps of ",
              StyleBox["di", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["generate a multidimensional table "]},
          {Cell[TextData[{
              StyleBox["TableForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["display a list in tabular form "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True}},
  CellTags->"S1.8.2"],

Cell["Functions for generating tables. ", "Caption",
  CellTags->"S1.8.2"],

Cell[TextData[{
  "You can use the operations discussed in Section ",
  ButtonBox["1.2.4",
    ButtonData:>{"1.2.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " to extract elements of the table.  "
}], "Text",
  CellTags->{"S1.8.2", "2.17"}],

Cell[TextData[{
  "This creates a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " table, and gives it the name ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.18"}],

Cell[CellGroupData[{

Cell["m = Table[i - j, {i, 2}, {j, 2}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({{0, \(-1\)}, {1, 0}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell["\<\
This extracts the first sublist from the list of lists that makes \
up the table. \
\>", "MathCaption",
  CellTags->{"S1.8.2", "2.19"}],

Cell[CellGroupData[{

Cell["m[[1]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({0, \(-1\)}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell["This extracts the second element of that sublist. ", "MathCaption",
  CellTags->{"S1.8.2", "2.20"}],

Cell[CellGroupData[{

Cell["%[[2]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \(\(-1\)\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell["This does the two operations together. ", "MathCaption",
  CellTags->{"S1.8.2", "2.21"}],

Cell[CellGroupData[{

Cell["m[[1,2]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \(\(-1\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[TextData[{
  "This displays ",
  StyleBox["m", "MR"],
  " in a \[OpenCurlyDoubleQuote]tabular\[CloseCurlyDoubleQuote] form. "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.22"}],

Cell[CellGroupData[{

Cell["TableForm[m]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", \(-1\)},
          {"1", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[16]//TableForm= ",
  CellTags->"S1.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["t", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " sublist in ",
              StyleBox["t", "TI"],
              " (also input as ",
              StyleBox["t", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftDoubleBracket]\)], 
                "InlineFormula"],
              "i",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightDoubleBracket]\)], 
                "InlineFormula"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["t", "TI"],
              StyleBox["[[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " parts of ",
              StyleBox["t", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["t", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["t", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the part of ",
              StyleBox["t", "TI"],
              " corresponding to ",
              StyleBox["t", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]][[", "MR"],
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.2"],

Cell["Ways to extract parts of tables. ", "Caption",
  CellTags->"S1.8.2"],

Cell[TextData[{
  "As we mentioned in Section ",
  ButtonBox["1.2.4",
    ButtonData:>{"1.2.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ", you can think of lists in ",
  StyleBox["Mathematica", "TI"],
  " as being analogous to \[OpenCurlyDoubleQuote]arrays\
\[CloseCurlyDoubleQuote]. Lists of lists are then like \
two\[Hyphen]dimensional arrays. When you lay them out in a tabular form, the \
two indices of each element are like its ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " coordinates.  "
}], "Text",
  CellTags->{"S1.8.2", "2.23"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Table", "MR"],
  " to generate arrays with any number of dimensions. "
}], "Text",
  CellTags->{"S1.8.2", "2.24"}],

Cell[TextData[{
  "This generates a three\[Hyphen]dimensional ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\[Cross]2\)], "InlineFormula"],
  " array. It is a list of lists of lists. "
}], "MathCaption",
  CellTags->{"S1.8.2", "2.25"}],

Cell[CellGroupData[{

Cell["Table[i j^2 k^3, {i, 2}, {j, 2}, {k, 2}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.8.2"],

Cell[BoxData[
    \({{{1, 8}, {4, 32}}, {{2, 16}, {8, 64}}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S1.8.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.3 Vectors and Matrices", "Subsection",
  CellTags->{"S1.8.3", "3.1"}],

Cell[TextData[{
  "Vectors and matrices in ",
  StyleBox["Mathematica", "TI"],
  " are simply represented by lists and by lists of lists, respectively. "
}], "Text",
  CellTags->{"S1.8.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "vector ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{
                        StyleBox["a",
                          "TI"], ",", 
                        StyleBox["b",
                          "TI"], ",", 
                        StyleBox["c",
                          "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
              
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["}}", "MR"],
              " "
            }]], Cell[TextData[{
              "matrix ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", Cell[BoxData[
                          FormBox[GridBox[{
                                {Cell[TextData[Cell[BoxData[
                                      StyleBox["a",
                                        "TI"]], "InlineFormula"]]], Cell[
                                  TextData[Cell[BoxData[
                                      StyleBox["b",
                                        "TI"]], "InlineFormula"]]]},
                                {Cell[TextData[Cell[BoxData[
                                      StyleBox["c",
                                        "TI"]], "InlineFormula"]]], Cell[
                                  TextData[Cell[BoxData[
                                      StyleBox["d",
                                        "TI"]], "InlineFormula"]]]}
                                },
                              ColumnAlignments->{Decimal}], 
                            TraditionalForm]]], ")"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.3"],

Cell["The representation of vectors and matrices by lists. ", "Caption",
  CellTags->"S1.8.3"],

Cell[TextData[{
  "This is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.3"}],

Cell[CellGroupData[{

Cell["m = {{a, b}, {c, d}}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["Here is the first row.  ", "MathCaption",
  CellTags->{"S1.8.3", "3.4"}],

Cell[CellGroupData[{

Cell["m[[1]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({a, b}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the element ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["m",
            "TI"], "12"], TraditionalForm]], "InlineFormula"],
  ".   "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.5"}],

Cell[CellGroupData[{

Cell["m[[1,2]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \(b\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["\<\
This is a two\[Hyphen]component vector.  \
\>", "MathCaption",
  CellTags->{"S1.8.3", "3.6"}],

Cell[CellGroupData[{

Cell["v = {x, y}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({x, y}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "The objects ",
  StyleBox["p", "MR"],
  " and ",
  StyleBox["q", "MR"],
  " are treated as scalars.  "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.7"}],

Cell[CellGroupData[{

Cell["p v + q", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({q + p\ x, q + p\ y}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["Vectors are added component by component. ", "MathCaption",
  CellTags->{"S1.8.3", "3.8"}],

Cell[CellGroupData[{

Cell["v + {xp, yp} + {xpp, ypp}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({x + xp + xpp, y + yp + ypp}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["\<\
This takes the dot (\[OpenCurlyDoubleQuote]scalar\
\[CloseCurlyDoubleQuote]) product of two vectors.  \
\>", "MathCaption",
  CellTags->{"S1.8.3", "3.9"}],

Cell[CellGroupData[{

Cell["{x, y} . {xp, yp}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \(x\ xp + y\ yp\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["You can also multiply a matrix by a vector. ", "MathCaption",
  CellTags->{"S1.8.3", "3.10"}],

Cell[CellGroupData[{

Cell["m . v", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["Or a matrix by a matrix. ", "MathCaption",
  CellTags->{"S1.8.3", "3.11"}],

Cell[CellGroupData[{

Cell["m . m", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{a\^2 + b\ c, a\ b + b\ d}, {a\ c + c\ d, b\ c + d\^2}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["Or a vector by a matrix. ", "MathCaption",
  CellTags->{"S1.8.3", "3.12"}],

Cell[CellGroupData[{

Cell["v . m", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({a\ x + c\ y, b\ x + d\ y}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["This combination makes a scalar. ", "MathCaption",
  CellTags->{"S1.8.3", "3.13"}],

Cell[CellGroupData[{

Cell["v . m . v", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \(x\ \((a\ x + c\ y)\) + y\ \((b\ x + d\ y)\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "Because of the way ",
  StyleBox["Mathematica", "TI"],
  " uses lists to represent vectors and matrices, you never have to \
distinguish between \[OpenCurlyDoubleQuote]row\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]column\[CloseCurlyDoubleQuote] vectors.   "
}], "Text",
  CellTags->{"S1.8.3", "3.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "build a length\[Hyphen]",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " vector by evaluating ",
              StyleBox["f", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["1", "MR"],
              ", ",
              StyleBox["2", "MR"],
              ", \[Ellipsis]",
              " ",
              ", ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "build a length\[Hyphen]",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " vector of the form ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox["[1],", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["[2],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Range[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create the list ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["2,", "MR"],
              " ",
              StyleBox["3,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Range[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create the list ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "+1, \[Ellipsis] , ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" ", "TR"]
            }]]},
          {Cell[TextData[{
              StyleBox["Range[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dn", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create the list ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "+",
              StyleBox["dn", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" ", "TR"]
            }]]},
          {Cell[TextData[{
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element in the vector ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Length[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the number of elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ColumnForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "display the elements of ",
              StyleBox["list", "TI"],
              " in a column "
            }]]},
          {Cell[TextData[{
              StyleBox["c", "TI"],
              " ",
              StyleBox["v", "TI"],
              " "
            }]], Cell["multiply by a scalar "]},
          {Cell[TextData[{
              StyleBox["a", "TI"],
              " ",
              StyleBox[".", "MR"],
              " ",
              StyleBox["b", "TI"],
              " "
            }]], Cell["vector dot product "]},
          {Cell[TextData[{
              StyleBox["Cross[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "vector cross product (also input as ",
              StyleBox["a", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              StyleBox["b", "TI"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Norm[", "MR"],
              StyleBox["v", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["norm of a vector "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, False, False, False, True, False}},
  CellTags->"S1.8.3"],

Cell["Functions for vectors. ", "Caption",
  CellTags->"S1.8.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "build an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " matrix by evaluating ",
              StyleBox["f", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " ranging from ",
              StyleBox["1", "MR"],
              " to ",
              StyleBox["m", "TI"],
              " and ",
              StyleBox["j", "TI"],
              " ranging from ",
              StyleBox["1", "MR"],
              " to ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "build an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " matrix with ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], ",", 
                      StyleBox["j",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element ",
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["IdentityMatrix[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "\[Cross]", 
                      StyleBox["n",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " identity matrix "
            }]]},
          {Cell[TextData[{
              StyleBox["DiagonalMatrix[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a square matrix with the elements in ",
              StyleBox["list", "TI"],
              " on the diagonal "
            }]]},
          {Cell[TextData[{
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " row in the matrix ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["list", "TI"],
              StyleBox["[[All,", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["All,", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the ",
              StyleBox["j", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " column in the matrix ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["i",
                        "TI"], ",", 
                      StyleBox["j",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element in the matrix ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Dimensions[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the dimensions of a matrix represented by ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MatrixForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "display ",
              StyleBox["list", "TI"],
              " in matrix form "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.3"],

Cell["Functions for matrices. ", "Caption",
  CellTags->"S1.8.3"],

Cell[TextData[{
  "This builds a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " matrix ",
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          "TI"], TraditionalForm]], "InlineFormula"],
  " with elements ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["s",
              "TI"], 
            StyleBox["ij",
              "TI"]], "=", 
          StyleBox["i",
            "TI"], "+", 
          StyleBox["j",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.15"}],

Cell[CellGroupData[{

Cell["s = Table[i+j, {i, 3}, {j, 3}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{2, 3, 4}, {3, 4, 5}, {4, 5, 6}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "This displays ",
  StyleBox["s", "MR"],
  " in standard two\[Hyphen]dimensional matrix format. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.16"}],

Cell[CellGroupData[{

Cell["MatrixForm[s]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"2", "3", "4"},
            {"3", "4", "5"},
            {"4", "5", "6"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[13]//MatrixForm= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["\<\
This gives a vector with symbolic elements. You can use this in \
deriving general formulas that are valid with any choice of vector \
components. \
\>", "MathCaption",
  CellTags->{"S1.8.3", "3.17"}],

Cell[CellGroupData[{

Cell["Array[a, 4]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({a[1], a[2], a[3], a[4]}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "This gives a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]2\)], "InlineFormula"],
  " matrix with symbolic elements. Section ",
  ButtonBox["2.2.6",
    ButtonData:>{"2.2.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how you can produce other kinds of elements with ",
  StyleBox["Array", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.18"}],

Cell[CellGroupData[{

Cell["Array[p, {3, 2}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{p[1, 1], p[1, 2]}, {p[2, 1], p[2, 2]}, {p[3, 1], 
        p[3, 2]}}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["Here are the dimensions of the matrix on the previous line. ", \
"MathCaption",
  CellTags->{"S1.8.3", "3.19"}],

Cell[CellGroupData[{

Cell["Dimensions[%]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({3, 2}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " diagonal matrix. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.20"}],

Cell[CellGroupData[{

Cell["DiagonalMatrix[{a, b, c}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{a, 0, 0}, {0, b, 0}, {0, 0, c}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["c", "TI"],
              " ",
              StyleBox["m", "TI"],
              " "
            }]], Cell["multiply by a scalar "]},
          {Cell[TextData[{
              StyleBox["a", "TI"],
              " ",
              StyleBox[".", "MR"],
              " ",
              StyleBox["b", "TI"],
              " "
            }]], Cell["matrix product "]},
          {Cell[TextData[{
              StyleBox["Inverse[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["matrix inverse "]},
          {Cell[TextData[{
              StyleBox["MatrixPower[", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " power of a matrix "
            }]]},
          {Cell[TextData[{
              StyleBox["Det[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["determinant "]},
          {Cell[TextData[{
              StyleBox["Tr[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["trace "]},
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["transpose "]},
          {Cell[TextData[{
              StyleBox["Eigenvalues[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["eigenvalues "]},
          {Cell[TextData[{
              StyleBox["Eigenvectors[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["eigenvectors"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.3"],

Cell["Some mathematical operations on matrices. ", "Caption",
  CellTags->"S1.8.3"],

Cell[TextData[{
  "Here is the ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix of symbolic variables that was defined above. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.21"}],

Cell[CellGroupData[{

Cell["m", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["This gives its determinant. ", "MathCaption",
  CellTags->{"S1.8.3", "3.22"}],

Cell[CellGroupData[{

Cell["Det[m]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \(\(-b\)\ c + a\ d\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the transpose of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.23"}],

Cell[CellGroupData[{

Cell["Transpose[m]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{a, c}, {b, d}}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "This gives the inverse of ",
  StyleBox["m", "MR"],
  " in symbolic form. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.24"}],

Cell[CellGroupData[{

Cell["Inverse[m]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{d\/\(\(-b\)\ c + a\ d\), \(-\(b\/\(\(-b\)\ c + 
                a\ d\)\)\)}, {\(-\(c\/\(\(-b\)\ c + a\ d\)\)\), 
        a\/\(\(-b\)\ c + a\ d\)}}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " rational matrix.  "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.25"}],

Cell[CellGroupData[{

Cell["h = Table[1/(i+j-1), {i, 3}, {j, 3}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{1, 1\/2, 1\/3}, {1\/2, 1\/3, 1\/4}, {1\/3, 1\/4, 1\/5}}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["This gives its inverse. ", "MathCaption",
  CellTags->{"S1.8.3", "3.26"}],

Cell[CellGroupData[{

Cell["Inverse[h]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{9, \(-36\), 30}, {\(-36\), 192, \(-180\)}, {30, \(-180\), 
        180}}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["\<\
Taking the dot product of the inverse with the original matrix \
gives the identity matrix. \
\>", "MathCaption",
  CellTags->{"S1.8.3", "3.27"}],

Cell[CellGroupData[{

Cell["% . h", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.28"}],

Cell[CellGroupData[{

Cell["r = Table[i+j+1, {i, 3}, {j, 3}]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{3, 4, 5}, {4, 5, 6}, {5, 6, 7}}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Eigenvalues", "MR"],
  " gives the eigenvalues of the matrix. "
}], "MathCaption",
  CellTags->{"S1.8.3", "3.29"}],

Cell[CellGroupData[{

Cell["Eigenvalues[r]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({1\/2\ \((15 + \@249)\), 1\/2\ \((15 - \@249)\), 0}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["This gives a numerical approximation to the matrix. ", "MathCaption",
  CellTags->{"S1.8.3", "3.30"}],

Cell[CellGroupData[{

Cell["rn = N[r]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({{3.`, 4.`, 5.`}, {4.`, 5.`, 6.`}, {5.`, 6.`, 7.`}}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell["Here are numerical approximations to the eigenvalues.  ", "MathCaption",
  CellTags->{"S1.8.3", "3.31"}],

Cell[CellGroupData[{

Cell["Eigenvalues[rn]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S1.8.3"],

Cell[BoxData[
    \({15.389866919029751`, \(-0.3898669190297496`\), \
\(-1.499553248501123`*^-16\)}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S1.8.3"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["3.7",
    ButtonData:>{"3.7"},
    ButtonStyle->"MainBookLink"],
  " discusses many other matrix operations that are built into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.8.3", "3.32"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.4 Getting Pieces of Lists", "Subsection",
  CellTags->{"S1.8.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["First[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the first element in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Last[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the last element "]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["list", "TI"],
              StyleBox["[[-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element from the end "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["list", "TI"],
              StyleBox["[[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the list of elements at positions ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.4"],

Cell["Picking out elements of lists. ", "Caption",
  CellTags->"S1.8.4"],

Cell["We will use this list for the examples. ", "MathCaption",
  CellTags->{"S1.8.4", "4.2"}],

Cell[CellGroupData[{

Cell["t = {a,b,c,d,e,f,g}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({a, b, c, d, e, f, g}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the last element of ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.3"}],

Cell[CellGroupData[{

Cell["Last[t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \(g\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell["This gives the third element. ", "MathCaption",
  CellTags->{"S1.8.4", "4.4"}],

Cell[CellGroupData[{

Cell["t[[3]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \(c\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell["This gives a list of the first and fourth elements. ", "MathCaption",
  CellTags->{"S1.8.4", "4.5"}],

Cell[CellGroupData[{

Cell["t[[ {1, 4} ]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({a, d}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the first ",
              StyleBox["n", "TI"],
              " elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the last ",
              StyleBox["n", "TI"],
              " elements "
            }]]},
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "elements ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " (inclusive) "
            }]]},
          {Cell[TextData[{
              StyleBox["Rest[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["list", "TI"],
              " with its first element dropped "
            }]]},
          {Cell[TextData[{
              StyleBox["Drop[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["list", "TI"],
              " with its first ",
              StyleBox["n", "TI"],
              " elements dropped "
            }]]},
          {Cell[TextData[{
              StyleBox["Most[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["list", "TI"],
              " with its last element dropped "
            }]]},
          {Cell[TextData[{
              StyleBox["Drop[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["list", "TI"],
              " with its last ",
              StyleBox["n", "TI"],
              " elements dropped "
            }]]},
          {Cell[TextData[{
              StyleBox["Drop[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["list", "TI"],
              " with elements ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " dropped"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S1.8.4"],

Cell["Picking out sequences in lists. ", "Caption",
  CellTags->"S1.8.4"],

Cell[TextData[{
  "This gives the first three elements of the list ",
  StyleBox["t", "MR"],
  " defined above. "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.6"}],

Cell[CellGroupData[{

Cell["Take[t, 3]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({a, b, c}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell["This gives the last three elements. ", "MathCaption",
  CellTags->{"S1.8.4", "4.7"}],

Cell[CellGroupData[{

Cell["Take[t, -3]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({e, f, g}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives elements ",
  StyleBox["2", "MR"],
  " through ",
  StyleBox["5", "MR"],
  " inclusive. "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.8"}],

Cell[CellGroupData[{

Cell["Take[t, {2, 5}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({b, c, d, e}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives elements ",
  StyleBox["3", "MR"],
  " through ",
  StyleBox["7", "MR"],
  " in steps of ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.9"}],

Cell[CellGroupData[{

Cell["Take[t, {3, 7, 2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({c, e, g}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["t", "MR"],
  " with the first element dropped. "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.10"}],

Cell[CellGroupData[{

Cell["Rest[t]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({b, c, d, e, f, g}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["t", "MR"],
  " with its first three elements dropped. "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.11"}],

Cell[CellGroupData[{

Cell["Drop[t, 3]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({d, e, f, g}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["t", "MR"],
  " with only its third element dropped. "
}], "MathCaption",
  CellTags->{"S1.8.4", "4.12"}],

Cell[CellGroupData[{

Cell["Drop[t, {3, 3}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.8.4"],

Cell[BoxData[
    \({a, b, d, e, f, g}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.8.4"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["2.1.5",
    ButtonData:>{"2.1.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " shows how all the functions in this section can be generalized to work \
not only on lists, but on any ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Text",
  CellTags->{"S1.8.4", "4.13"}],

Cell[TextData[{
  "The functions in this section allow you to pick out pieces that occur at \
particular positions in lists. Section ",
  ButtonBox["2.3.2",
    ButtonData:>{"2.3.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  " shows how you can use functions like ",
  StyleBox["Select", "MR"],
  " and ",
  StyleBox["Cases", "MR"],
  " to pick out elements of lists based not on their positions, but instead \
on their properties. "
}], "Text",
  CellTags->{"S1.8.4", "4.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.5 Testing and Searching List Elements", "Subsection",
  CellTags->{"S1.8.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Position[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the positions at which ",
              StyleBox["form", "TI"],
              " occurs in ",
              StyleBox["list", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["Count[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the number of times ",
              StyleBox["form", "TI"],
              " appears as an element of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MemberQ[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["form", "TI"],
              " is an element of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FreeQ[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["form", "TI"],
              " occurs nowhere in ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.5"],

Cell["Testing and searching for elements of lists. ", "Caption",
  CellTags->"S1.8.5"],

Cell[TextData[{
  "The previous section discussed how to extract pieces of lists based on \
their positions or indices. ",
  StyleBox["Mathematica", "TI"],
  " also has functions that search and test for elements of lists, based on \
the values of those elements. "
}], "Text",
  CellTags->{"S1.8.5", "5.2"}],

Cell[TextData[{
  "This gives a list of the positions at which ",
  StyleBox["a", "MR"],
  " appears in the list. "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.3"}],

Cell[CellGroupData[{

Cell["Position[{a, b, c, a, b}, a]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \({{1}, {4}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Count", "MR"],
  " counts the number of occurrences of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.4"}],

Cell[CellGroupData[{

Cell["Count[{a, b, c, a, b}, a]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  "This shows that ",
  StyleBox["a", "MR"],
  " is an element of ",
  StyleBox["{a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.5"}],

Cell[CellGroupData[{

Cell["MemberQ[{a, b, c}, a]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  "On the other hand, ",
  StyleBox["d", "MR"],
  " is not. "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.6"}],

Cell[CellGroupData[{

Cell["MemberQ[{a, b, c}, d]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  "This assigns ",
  StyleBox["m", "MR"],
  " to be the ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " identity matrix. "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.7"}],

Cell[CellGroupData[{

Cell["m = IdentityMatrix[3]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  "This shows that ",
  StyleBox["0", "MR"],
  " does occur ",
  StyleBox["somewhere", "TI"],
  " in ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.8"}],

Cell[CellGroupData[{

Cell["FreeQ[m, 0]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  "This gives a list of the positions at which ",
  StyleBox["0", "MR"],
  " occurs in ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.5", "5.9"}],

Cell[CellGroupData[{

Cell["Position[m, 0]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.8.5"],

Cell[BoxData[
    \({{1, 2}, {1, 3}, {2, 1}, {2, 3}, {3, 1}, {3, 2}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.8.5"]
}, Open  ]],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.3.2",
    ButtonData:>{"2.3.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ", the functions ",
  StyleBox["Count", "MR"],
  " and ",
  StyleBox["Position", "MR"],
  ", as well as ",
  StyleBox["MemberQ", "MR"],
  " and ",
  StyleBox["FreeQ", "MR"],
  ", can be used not only to search for ",
  StyleBox["particular", "TI"],
  " list elements, but also to search for classes of elements which match \
specific \[OpenCurlyDoubleQuote]patterns\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S1.8.5", "5.10"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.6 Adding, Removing and Modifying List Elements", "Subsection",
  CellTags->{"S1.8.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Prepend[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["element", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["element", "TI"],
              " at the beginning of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Append[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["element", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["element", "TI"],
              " at the end of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Insert[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["element", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert ",
              StyleBox["element", "TI"],
              " at position ",
              StyleBox["i", "TI"],
              " in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Insert[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["element", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert at position ",
              StyleBox["i", "TI"],
              " counting from the end of ",
              StyleBox["list", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["Delete[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "delete the element at position ",
              StyleBox["i", "TI"],
              " in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["new", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace the element at position ",
              StyleBox["i", "TI"],
              " in ",
              StyleBox["list", "TI"],
              " with ",
              StyleBox["new", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["new", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " with ",
              StyleBox["new", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False}},
  CellTags->"S1.8.6"],

Cell["Functions for manipulating elements in explicit lists. ", "Caption",
  CellTags->"S1.8.6"],

Cell[TextData[{
  "This gives a list with ",
  StyleBox["x", "MR"],
  " prepended. "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.2"}],

Cell[CellGroupData[{

Cell["Prepend[{a, b, c}, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({x, a, b, c}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "This inserts ",
  StyleBox["x", "MR"],
  " so that it becomes element number 2. "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.3"}],

Cell[CellGroupData[{

Cell["Insert[{a, b, c}, x, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({a, x, b, c}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "This replaces the third element in the list with ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.4"}],

Cell[CellGroupData[{

Cell["ReplacePart[{a, b, c, d}, x, 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({a, b, x, d}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "This replaces the ",
  Cell[BoxData[
      \(TraditionalForm\`1, 2\)], "InlineFormula"],
  " element in a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.5"}],

Cell[CellGroupData[{

Cell["ReplacePart[{{a, b}, {c, d}}, x, {1, 2}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({{a, x}, {c, d}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["ReplacePart", "MR"],
  " take explicit lists and give you new lists. Sometimes, however, you may \
want to modify a list \[OpenCurlyDoubleQuote]in \
place\[CloseCurlyDoubleQuote], without explicitly generating a new list. "
}], "Text",
  CellTags->{"S1.8.6", "6.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["v", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["assign a variable to be a list "]},
          {Cell[TextData[{
              StyleBox["v", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["new", "TI"],
              " "
            }]], Cell[TextData[{
              "assign a new value to the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.6"],

Cell["Resetting list elements. ", "Caption",
  CellTags->"S1.8.6"],

Cell[TextData[{
  "This defines ",
  StyleBox["v", "MR"],
  " to be a list. "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.7"}],

Cell[CellGroupData[{

Cell["v = {a, b, c, d}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({a, b, c, d}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "This sets the third element to be ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.8"}],

Cell[CellGroupData[{

Cell["v[[3]] = x", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["v", "MR"],
  " has been changed. "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.9"}],

Cell[CellGroupData[{

Cell["v", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({a, b, x, d}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["new", "TI"],
              " "
            }]], Cell[TextData[{
              "replace the ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], ",", 
                        StyleBox["j",
                          "TI"]}], ")"}], TraditionalForm]], "InlineFormula"],
              
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element of a matrix "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["new", "TI"],
              " "
            }]], Cell[TextData[{
              "replace the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " row "
            }]]},
          {Cell[TextData[{
              StyleBox["m", "TI"],
              StyleBox["[[All,", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["new", "TI"],
              " "
            }]], Cell[TextData[{
              "replace the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " column "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.6"],

Cell["Resetting pieces of matrices. ", "Caption",
  CellTags->"S1.8.6"],

Cell[TextData[{
  "This defines ",
  StyleBox["m", "MR"],
  " to be a matrix. "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.10"}],

Cell[CellGroupData[{

Cell["m = {{a, b}, {c, d}}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell["This sets the first column of the matrix. ", "MathCaption",
  CellTags->{"S1.8.6", "6.11"}],

Cell[CellGroupData[{

Cell["m[[All, 1]] = {x, y}; m", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({{x, b}, {y, d}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.8.6"]
}, Open  ]],

Cell[TextData[{
  "This sets every element in the first column to be ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.6", "6.12"}],

Cell[CellGroupData[{

Cell["m[[All, 1]] = 0; m", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.8.6"],

Cell[BoxData[
    \({{0, b}, {0, d}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.8.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.7 Combining Lists", "Subsection",
  CellTags->{"S1.8.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Join[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["concatenate lists together "]},
          {Cell[TextData[{
              StyleBox["Union[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
combine lists, removing repeated elements and sorting \
the result \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.7"],

Cell["Functions for combining lists. ", "Caption",
  CellTags->"S1.8.7"],

Cell[TextData[{
  StyleBox["Join", "MR"],
  " concatenates any number of lists together. "
}], "MathCaption",
  CellTags->{"S1.8.7", "7.2"}],

Cell[CellGroupData[{

Cell["Join[{a, b, c}, {x, y}, {t, u}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.7"],

Cell[BoxData[
    \({a, b, c, x, y, t, u}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Union", "MR"],
  " combines lists, keeping only distinct elements. "
}], "MathCaption",
  CellTags->{"S1.8.7", "7.3"}],

Cell[CellGroupData[{

Cell["Union[{a, b, c}, {c, a, d}, {a, d}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.7"],

Cell[BoxData[
    \({a, b, c, d}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.8 Advanced Topic: Lists as Sets", "Subsection",
  CellTags->{"S1.8.8", "8.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " usually keeps the elements of a list in exactly the order you originally \
entered them. If you want to treat a ",
  StyleBox["Mathematica", "TI"],
  " list like a mathematical ",
  StyleBox["set", "TI"],
  ", however, you may want to ignore the order of elements in the list.  "
}], "Text",
  CellTags->{"S1.8.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Union[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the distinct elements in the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Intersection[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the elements that are common to all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Complement[", "MR"],
              StyleBox["universal", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the elements that are in ",
              StyleBox["universal", "TI"],
              ", but not in any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Subsets[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of all subsets of the elements in ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.8"],

Cell["Set theoretical functions. ", "Caption",
  CellTags->"S1.8.8"],

Cell[TextData[{
  StyleBox["Union", "MR"],
  " gives the elements that occur in ",
  StyleBox["any", "TI"],
  " of the lists. "
}], "MathCaption",
  CellTags->{"S1.8.8", "8.3"}],

Cell[CellGroupData[{

Cell["Union[{c, a, b}, {d, a, c}, {a, e}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.8"],

Cell[BoxData[
    \({a, b, c, d, e}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Intersection", "MR"],
  " gives only elements that occur in ",
  StyleBox["all", "TI"],
  " the lists. "
}], "MathCaption",
  CellTags->{"S1.8.8", "8.4"}],

Cell[CellGroupData[{

Cell["Intersection[{a, c, b}, {b, a, d, a}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.8"],

Cell[BoxData[
    \({a, b}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Complement", "MR"],
  " gives elements that occur in the first list, but not in any of the \
others. "
}], "MathCaption",
  CellTags->{"S1.8.8", "8.5"}],

Cell[CellGroupData[{

Cell["Complement[{a, b, c, d}, {a, d}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.8"],

Cell[BoxData[
    \({b, c}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.8"]
}, Open  ]],

Cell["This gives all the subsets of the list. ", "MathCaption",
  CellTags->{"S1.8.8", "8.6"}],

Cell[CellGroupData[{

Cell["Subsets[{a, b, c}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.8"],

Cell[BoxData[
    \({{}, {a}, {b}, {c}, {a, b}, {a, c}, {b, c}, {a, b, c}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.9 Rearranging Lists", "Subsection",
  CellTags->{"S1.8.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sort[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sort the elements of ",
              StyleBox["list", "TI"],
              " into a standard order "
            }]]},
          {Cell[TextData[{
              StyleBox["Union[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["sort elements, removing any duplicates "]},
          {Cell[TextData[{
              StyleBox["Reverse[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reverse the order of elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RotateLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "rotate the elements of ",
              StyleBox["list", "TI"],
              " ",
              StyleBox["n", "TI"],
              " places to the left "
            }]]},
          {Cell[TextData[{
              StyleBox["RotateRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "rotate ",
              StyleBox["n", "TI"],
              " places to the right"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.9"],

Cell["Functions for rearranging lists. ", "Caption",
  CellTags->"S1.8.9"],

Cell["\<\
This sorts the elements of a list into a standard order. In simple \
cases like this, the order is alphabetical or numerical. \
\>", "MathCaption",\

  CellTags->{"S1.8.9", "9.2"}],

Cell[CellGroupData[{

Cell["Sort[{b, a, c, a, b}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.9"],

Cell[BoxData[
    \({a, a, b, b, c}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.9"]
}, Open  ]],

Cell["This sorts the elements, removing any duplicates. ", "MathCaption",
  CellTags->{"S1.8.9", "9.3"}],

Cell[CellGroupData[{

Cell["Union[{b, a, c, a, b}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.9"],

Cell[BoxData[
    \({a, b, c}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.9"]
}, Open  ]],

Cell["\<\
This rotates \
(\[OpenCurlyDoubleQuote]shifts\[CloseCurlyDoubleQuote]) the elements in the \
list two places to the left. \
\>", "MathCaption",
  CellTags->{"S1.8.9", "9.4"}],

Cell[CellGroupData[{

Cell["RotateLeft[{a, b, c, d, e}, 2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.9"],

Cell[BoxData[
    \({c, d, e, a, b}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.9"]
}, Open  ]],

Cell[TextData[{
  "You can rotate to the right by giving a negative displacement, or by using \
",
  StyleBox["RotateRight", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.8.9", "9.5"}],

Cell[CellGroupData[{

Cell["RotateLeft[{a, b, c, d, e}, -2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.9"],

Cell[BoxData[
    \({d, e, a, b, c}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["len", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad ",
              StyleBox["list", "TI"],
              " on the left with ",
              StyleBox["x", "TI"],
              " to make it length ",
              StyleBox["len", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PadRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["len", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad ",
              StyleBox["list", "TI"],
              " on the right "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.9"],

Cell["Padding lists. ", "Caption",
  CellTags->"S1.8.9"],

Cell[TextData[{
  "This pads a list with ",
  StyleBox["x", "MR"],
  "'s to make it length 10. "
}], "MathCaption",
  CellTags->{"S1.8.9", "9.6"}],

Cell[CellGroupData[{

Cell["PadLeft[{a, b, c}, 10, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.9"],

Cell[BoxData[
    \({x, x, x, x, x, x, x, a, b, c}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.10 Grouping and Combining Elements of Lists", "Subsection",
  CellTags->{"S1.8.10", "10.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "partition ",
              StyleBox["list", "TI"],
              " into ",
              StyleBox["n", "TI"],
              "\[Hyphen]element pieces "
            }]]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use offset ",
              StyleBox["d", "TI"],
              " for successive pieces "
            }]]},
          {Cell[TextData[{
              StyleBox["Split[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split ",
              StyleBox["list", "TI"],
              " into pieces consisting of runs of identical elements "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.10"],

Cell["Functions for grouping together elements of lists. ", "Caption",
  CellTags->"S1.8.10"],

Cell["Here is a list. ", "MathCaption",
  CellTags->{"S1.8.10", "10.2"}],

Cell[CellGroupData[{

Cell["t = {a, b, c, d, e, f, g}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({a, b, c, d, e, f, g}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.10"]
}, Open  ]],

Cell["\<\
This groups the elements of the list in pairs, throwing away the \
single element left at the end. \
\>", "MathCaption",
  CellTags->{"S1.8.10", "10.3"}],

Cell[CellGroupData[{

Cell["Partition[t, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({{a, b}, {c, d}, {e, f}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.10"]
}, Open  ]],

Cell["\<\
This groups elements in triples. There is no overlap between the \
triples. \
\>", "MathCaption",
  CellTags->{"S1.8.10", "10.4"}],

Cell[CellGroupData[{

Cell["Partition[t, 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({{a, b, c}, {d, e, f}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.10"]
}, Open  ]],

Cell["\<\
This makes triples of elements, with each successive triple offset \
by just one element. \
\>", "MathCaption",
  CellTags->{"S1.8.10", "10.5"}],

Cell[CellGroupData[{

Cell["Partition[t, 3, 1]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}, {d, e, f}, {e, f, g}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.10"]
}, Open  ]],

Cell["This splits up the list into runs of identical elements. ", \
"MathCaption",
  CellTags->{"S1.8.10", "10.6"}],

Cell[CellGroupData[{

Cell["Split[{a, a, b, b, b, a, a, a, b}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({{a, a}, {b, b, b}, {a, a, a}, {b}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.8.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Tuples[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate all possible ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              "\[Hyphen]tuples of elements from ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Tuples[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate all tuples whose ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["i",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element is from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.10"],

Cell["Finding possible tuples of elements in lists. ", "Caption",
  CellTags->"S1.8.10"],

Cell["\<\
This gives all possible ways of picking two elements out of the \
list. \
\>", "MathCaption",
  CellTags->{"S1.8.10", "10.7"}],

Cell[CellGroupData[{

Cell["Tuples[{a, b}, 2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({{a, a}, {a, b}, {b, a}, {b, b}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.8.10"]
}, Open  ]],

Cell["\<\
This gives all possible ways of picking one element from each list. \
\
\>", "MathCaption",
  CellTags->{"S1.8.10", "10.8"}],

Cell[CellGroupData[{

Cell["Tuples[{{a, b}, {1, 2, 3}}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.8.10"],

Cell[BoxData[
    \({{a, 1}, {a, 2}, {a, 3}, {b, 1}, {b, 2}, {b, 3}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.8.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.11 Ordering in Lists", "Subsection",
  CellTags->{"S1.8.11", "11.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sort[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sort the elements of ",
              StyleBox["list", "TI"],
              " into order "
            }]]},
          {Cell[TextData[{
              StyleBox["Min[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the smallest element in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Ordering[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the positions of the ",
              StyleBox["n", "TI"],
              " smallest elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Max[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the largest element in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Ordering[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the positions of the ",
              StyleBox["n", "TI"],
              " largest elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Ordering[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ordering of all elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Permutations[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "all possible orderings of ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.11"],

Cell["Ordering in lists. ", "Caption",
  CellTags->"S1.8.11"],

Cell["Here is a list. ", "MathCaption",
  CellTags->{"S1.8.11", "11.2"}],

Cell[CellGroupData[{

Cell["t = {17, 21, 14, 9, 18}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.11"],

Cell[BoxData[
    \({17, 21, 14, 9, 18}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.11"]
}, Open  ]],

Cell["This gives the smallest element in the list. ", "MathCaption",
  CellTags->{"S1.8.11", "11.3"}],

Cell[CellGroupData[{

Cell["Min[t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.11"],

Cell[BoxData[
    \(9\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.11"]
}, Open  ]],

Cell["\<\
This gives in order the positions of the 3 smallest elements. \
\
\>", "MathCaption",
  CellTags->{"S1.8.11", "11.4"}],

Cell[CellGroupData[{

Cell["Ordering[t, 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.8.11"],

Cell[BoxData[
    \({4, 3, 1}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.8.11"]
}, Open  ]],

Cell["Here are the actual elements. ", "MathCaption",
  CellTags->{"S1.8.11", "11.5"}],

Cell[CellGroupData[{

Cell["t[[%]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.8.11"],

Cell[BoxData[
    \({9, 14, 17}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.8.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.8.12 Advanced Topic: Rearranging Nested Lists", "Subsection",
  CellTags->{"S1.8.12", "12.1"}],

Cell[TextData[{
  "You will encounter nested lists if you use matrices or generate \
multidimensional arrays and tables. ",
  StyleBox["Mathematica", "TI"],
  " provides many functions for handling such lists.    "
}], "Text",
  CellTags->{"S1.8.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten out all levels in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten out the top ",
              StyleBox["n", "TI"],
              " levels in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "partition into blocks of size ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "\[Ellipsis]"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["interchange the top two levels of lists "]},
          {Cell[TextData[{
              StyleBox["RotateLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "rotate successive levels by ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " places "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad successive levels to be length ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.8.12"],

Cell["A few functions for rearranging nested lists. ", "Caption",
  CellTags->"S1.8.12"],

Cell["\<\
This \[OpenCurlyDoubleQuote]flattens out\[CloseCurlyDoubleQuote] \
sublists. You can think of it as effectively just removing all inner braces. \
\
\>", "MathCaption",
  CellTags->{"S1.8.12", "12.3"}],

Cell[CellGroupData[{

Cell["Flatten[{{a}, {b, {c}}, {d}}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.8.12"],

Cell[BoxData[
    \({a, b, c, d}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.8.12"]
}, Open  ]],

Cell["This flattens out only one level of sublists. ", "MathCaption",
  CellTags->{"S1.8.12", "12.4"}],

Cell[CellGroupData[{

Cell["Flatten[{{a}, {b, {c}}, {d}}, 1]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.8.12"],

Cell[BoxData[
    \({a, b, {c}, d}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.8.12"]
}, Open  ]],

Cell[TextData[{
  "There are many other operations you can perform on nested lists. We will \
discuss more of them in Section\[NonBreakingSpace]",
  ButtonBox["2.4",
    ButtonData:>{"2.4"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.8.12", "12.5"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 124}, {28, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.8.0"->{
    Cell[1776, 53, 108, 4, 65, "Section",
      CellTags->{"S1.8.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 108, 4, 65, "Section",
      CellTags->{"S1.8.0", "0.1"}]},
  "S1.8.1"->{
    Cell[1909, 61, 86, 1, 70, "Subsection",
      CellTags->{"S1.8.1", "1.1"}],
    Cell[1998, 64, 605, 14, 70, "Text",
      CellTags->{"S1.8.1", "1.2"}],
    Cell[2606, 80, 233, 6, 70, "Text",
      CellTags->{"S1.8.1", "1.3"}],
    Cell[2842, 88, 81, 1, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.4"}],
    Cell[2948, 93, 73, 2, 70, "Input",
      CellTags->"S1.8.1"],
    Cell[3024, 97, 90, 3, 70, "Output",
      CellTags->"S1.8.1"],
    Cell[3129, 103, 97, 1, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.5"}],
    Cell[3251, 108, 71, 2, 70, "Input",
      CellTags->"S1.8.1"],
    Cell[3325, 112, 126, 3, 70, "Output",
      CellTags->"S1.8.1"],
    Cell[3466, 118, 95, 1, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.6"}],
    Cell[3586, 123, 71, 2, 70, "Input",
      CellTags->"S1.8.1"],
    Cell[3660, 127, 105, 3, 70, "Output",
      CellTags->"S1.8.1"],
    Cell[3780, 133, 182, 7, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.7"}],
    Cell[3987, 144, 75, 2, 70, "Input",
      CellTags->"S1.8.1"],
    Cell[4065, 148, 93, 3, 70, "Output",
      CellTags->"S1.8.1"],
    Cell[4173, 154, 892, 23, 70, "Text",
      CellTags->{"S1.8.1", "1.8"}]},
  "1.1"->{
    Cell[1909, 61, 86, 1, 70, "Subsection",
      CellTags->{"S1.8.1", "1.1"}]},
  "1.2"->{
    Cell[1998, 64, 605, 14, 70, "Text",
      CellTags->{"S1.8.1", "1.2"}]},
  "1.3"->{
    Cell[2606, 80, 233, 6, 70, "Text",
      CellTags->{"S1.8.1", "1.3"}]},
  "1.4"->{
    Cell[2842, 88, 81, 1, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.4"}]},
  "1.5"->{
    Cell[3129, 103, 97, 1, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.5"}]},
  "1.6"->{
    Cell[3466, 118, 95, 1, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.6"}]},
  "1.7"->{
    Cell[3780, 133, 182, 7, 70, "MathCaption",
      CellTags->{"S1.8.1", "1.7"}]},
  "1.8"->{
    Cell[4173, 154, 892, 23, 70, "Text",
      CellTags->{"S1.8.1", "1.8"}]},
  "S1.8.2"->{
    Cell[5102, 182, 82, 1, 70, "Subsection",
      CellTags->{"S1.8.2", "2.1"}],
    Cell[5187, 185, 214, 5, 70, "Text",
      CellTags->{"S1.8.2", "2.2"}],
    Cell[5404, 192, 395, 14, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.3"}],
    Cell[5824, 210, 82, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[5909, 214, 102, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[6026, 220, 581, 23, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.4"}],
    Cell[6632, 247, 90, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[6725, 251, 128, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[6868, 257, 87, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.5"}],
    Cell[6980, 262, 68, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[7051, 266, 178, 4, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[7244, 273, 92, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.6"}],
    Cell[7361, 278, 87, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[7451, 282, 129, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[7595, 288, 357, 12, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.7"}],
    Cell[7977, 304, 89, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[8069, 308, 168, 4, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[8252, 315, 256, 11, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.8"}],
    Cell[8533, 330, 95, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[8631, 334, 137, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[8783, 340, 164, 5, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.9"}],
    Cell[8972, 349, 71, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[9046, 353, 109, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[9170, 359, 292, 8, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.10"}],
    Cell[9487, 371, 78, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[9568, 375, 387, 14, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[9970, 392, 450, 11, 70, "Text",
      CellTags->{"S1.8.2", "2.11"}],
    Cell[10423, 405, 1059, 41, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.12"}],
    Cell[11507, 450, 96, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[11606, 454, 159, 4, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[11780, 461, 627, 20, 70, "Text",
      CellTags->{"S1.8.2", "2.13"}],
    Cell[12410, 483, 189, 5, 70, "Text",
      CellTags->{"S1.8.2", "2.14"}],
    Cell[12602, 490, 159, 5, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.15"}],
    Cell[12786, 499, 78, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[12867, 503, 94, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[12976, 509, 321, 10, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.16"}],
    Cell[13322, 523, 86, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[13411, 527, 174, 4, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[13600, 534, 7179, 212, 70, "DefinitionBox",
      CellTags->"S1.8.2"],
    Cell[20782, 748, 74, 1, 70, "Caption",
      CellTags->"S1.8.2"],
    Cell[20859, 751, 243, 7, 70, "Text",
      CellTags->{"S1.8.2", "2.17"}],
    Cell[21105, 760, 227, 8, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.18"}],
    Cell[21357, 772, 97, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[21457, 776, 103, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[21575, 782, 145, 4, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.19"}],
    Cell[21745, 790, 71, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[21819, 794, 93, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[21927, 800, 105, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.20"}],
    Cell[22057, 805, 71, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[22131, 809, 88, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[22234, 815, 94, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.21"}],
    Cell[22353, 820, 73, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[22429, 824, 88, 3, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[22532, 830, 181, 5, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.22"}],
    Cell[22738, 839, 77, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[22818, 843, 345, 12, 70, "Output",
      CellTags->"S1.8.2"],
    Cell[23178, 858, 4882, 146, 70, "DefinitionBox",
      CellTags->"S1.8.2"],
    Cell[28063, 1006, 74, 1, 70, "Caption",
      CellTags->"S1.8.2"],
    Cell[28140, 1009, 730, 22, 70, "Text",
      CellTags->{"S1.8.2", "2.23"}],
    Cell[28873, 1033, 160, 5, 70, "Text",
      CellTags->{"S1.8.2", "2.24"}],
    Cell[29036, 1040, 243, 6, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.25"}],
    Cell[29304, 1050, 105, 2, 70, "Input",
      CellTags->"S1.8.2"],
    Cell[29412, 1054, 121, 3, 70, "Output",
      CellTags->"S1.8.2"]},
  "2.1"->{
    Cell[5102, 182, 82, 1, 70, "Subsection",
      CellTags->{"S1.8.2", "2.1"}]},
  "2.2"->{
    Cell[5187, 185, 214, 5, 70, "Text",
      CellTags->{"S1.8.2", "2.2"}]},
  "2.3"->{
    Cell[5404, 192, 395, 14, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.3"}]},
  "2.4"->{
    Cell[6026, 220, 581, 23, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.4"}]},
  "2.5"->{
    Cell[6868, 257, 87, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.5"}]},
  "2.6"->{
    Cell[7244, 273, 92, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.6"}]},
  "2.7"->{
    Cell[7595, 288, 357, 12, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.7"}]},
  "2.8"->{
    Cell[8252, 315, 256, 11, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.8"}]},
  "2.9"->{
    Cell[8783, 340, 164, 5, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.9"}]},
  "2.10"->{
    Cell[9170, 359, 292, 8, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.10"}]},
  "2.11"->{
    Cell[9970, 392, 450, 11, 70, "Text",
      CellTags->{"S1.8.2", "2.11"}]},
  "2.12"->{
    Cell[10423, 405, 1059, 41, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.12"}]},
  "2.13"->{
    Cell[11780, 461, 627, 20, 70, "Text",
      CellTags->{"S1.8.2", "2.13"}]},
  "2.14"->{
    Cell[12410, 483, 189, 5, 70, "Text",
      CellTags->{"S1.8.2", "2.14"}]},
  "2.15"->{
    Cell[12602, 490, 159, 5, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.15"}]},
  "2.16"->{
    Cell[12976, 509, 321, 10, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.16"}]},
  "2.17"->{
    Cell[20859, 751, 243, 7, 70, "Text",
      CellTags->{"S1.8.2", "2.17"}]},
  "2.18"->{
    Cell[21105, 760, 227, 8, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.18"}]},
  "2.19"->{
    Cell[21575, 782, 145, 4, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.19"}]},
  "2.20"->{
    Cell[21927, 800, 105, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.20"}]},
  "2.21"->{
    Cell[22234, 815, 94, 1, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.21"}]},
  "2.22"->{
    Cell[22532, 830, 181, 5, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.22"}]},
  "2.23"->{
    Cell[28140, 1009, 730, 22, 70, "Text",
      CellTags->{"S1.8.2", "2.23"}]},
  "2.24"->{
    Cell[28873, 1033, 160, 5, 70, "Text",
      CellTags->{"S1.8.2", "2.24"}]},
  "2.25"->{
    Cell[29036, 1040, 243, 6, 70, "MathCaption",
      CellTags->{"S1.8.2", "2.25"}]},
  "S1.8.3"->{
    Cell[29582, 1063, 79, 1, 70, "Subsection",
      CellTags->{"S1.8.3", "3.1"}],
    Cell[29664, 1066, 196, 5, 70, "Text",
      CellTags->{"S1.8.3", "3.2"}],
    Cell[29863, 1073, 2661, 71, 70, "DefinitionBox",
      CellTags->"S1.8.3"],
    Cell[32527, 1146, 94, 1, 70, "Caption",
      CellTags->"S1.8.3"],
    Cell[32624, 1149, 169, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.3"}],
    Cell[32818, 1159, 84, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[32905, 1163, 97, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[33017, 1169, 78, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.4"}],
    Cell[33120, 1174, 70, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[33193, 1178, 87, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[33295, 1184, 240, 9, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.5"}],
    Cell[33560, 1197, 72, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[33635, 1201, 82, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[33732, 1207, 103, 3, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.6"}],
    Cell[33860, 1214, 74, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[33937, 1218, 87, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[34039, 1224, 171, 7, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.7"}],
    Cell[34235, 1235, 71, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[34309, 1239, 101, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[34425, 1245, 96, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.8"}],
    Cell[34546, 1250, 89, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[34638, 1254, 109, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[34762, 1260, 164, 4, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.9"}],
    Cell[34951, 1268, 81, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[35035, 1272, 94, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[35144, 1278, 99, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.10"}],
    Cell[35268, 1283, 69, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[35340, 1287, 107, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[35462, 1293, 80, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.11"}],
    Cell[35567, 1298, 69, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[35639, 1302, 137, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[35791, 1308, 80, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.12"}],
    Cell[35896, 1313, 70, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[35969, 1317, 108, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[36092, 1323, 88, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.13"}],
    Cell[36205, 1328, 74, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[36282, 1332, 125, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[36422, 1338, 331, 7, 70, "Text",
      CellTags->{"S1.8.3", "3.14"}],
    Cell[36756, 1347, 8377, 256, 70, "DefinitionBox",
      CellTags->"S1.8.3"],
    Cell[45136, 1605, 64, 1, 70, "Caption",
      CellTags->"S1.8.3"],
    Cell[45203, 1608, 7245, 218, 70, "DefinitionBox",
      CellTags->"S1.8.3"],
    Cell[52451, 1828, 65, 1, 70, "Caption",
      CellTags->"S1.8.3"],
    Cell[52519, 1831, 615, 24, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.15"}],
    Cell[53159, 1859, 95, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[53257, 1863, 115, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[53387, 1869, 166, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.16"}],
    Cell[53578, 1878, 78, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[53659, 1882, 417, 13, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[54091, 1898, 210, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.17"}],
    Cell[54326, 1907, 76, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[54405, 1911, 106, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[54526, 1917, 397, 12, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.18"}],
    Cell[54948, 1933, 81, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[55032, 1937, 151, 4, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[55198, 1944, 117, 2, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.19"}],
    Cell[55340, 1950, 78, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[55421, 1954, 88, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[55524, 1960, 186, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.20"}],
    Cell[55735, 1970, 90, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[55828, 1974, 115, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[55958, 1980, 2268, 70, 70, "DefinitionBox",
      CellTags->"S1.8.3"],
    Cell[58229, 2052, 83, 1, 70, "Caption",
      CellTags->"S1.8.3"],
    Cell[58315, 2055, 217, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.21"}],
    Cell[58557, 2065, 66, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[58626, 2069, 98, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[58739, 2075, 83, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.22"}],
    Cell[58847, 2080, 71, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[58921, 2084, 98, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[59034, 2090, 127, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.23"}],
    Cell[59186, 2099, 77, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[59266, 2103, 98, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[59379, 2109, 145, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.24"}],
    Cell[59549, 2118, 75, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[59627, 2122, 230, 5, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[59872, 2130, 180, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.25"}],
    Cell[60077, 2140, 101, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[60181, 2144, 139, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[60335, 2150, 79, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.26"}],
    Cell[60439, 2155, 75, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[60517, 2159, 156, 4, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[60688, 2166, 155, 4, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.27"}],
    Cell[60868, 2174, 70, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[60941, 2178, 115, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[61071, 2184, 170, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.28"}],
    Cell[61266, 2194, 97, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[61366, 2198, 115, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[61496, 2204, 142, 4, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.29"}],
    Cell[61663, 2212, 79, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[61745, 2216, 133, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[61893, 2222, 107, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.30"}],
    Cell[62025, 2227, 74, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[62102, 2231, 133, 3, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[62250, 2237, 110, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.31"}],
    Cell[62385, 2242, 80, 2, 70, "Input",
      CellTags->"S1.8.3"],
    Cell[62468, 2246, 161, 4, 70, "Output",
      CellTags->"S1.8.3"],
    Cell[62644, 2253, 257, 9, 70, "Text",
      CellTags->{"S1.8.3", "3.32"}]},
  "3.1"->{
    Cell[29582, 1063, 79, 1, 70, "Subsection",
      CellTags->{"S1.8.3", "3.1"}]},
  "3.2"->{
    Cell[29664, 1066, 196, 5, 70, "Text",
      CellTags->{"S1.8.3", "3.2"}]},
  "3.3"->{
    Cell[32624, 1149, 169, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.3"}]},
  "3.4"->{
    Cell[33017, 1169, 78, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.4"}]},
  "3.5"->{
    Cell[33295, 1184, 240, 9, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.5"}]},
  "3.6"->{
    Cell[33732, 1207, 103, 3, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.6"}]},
  "3.7"->{
    Cell[34039, 1224, 171, 7, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.7"}]},
  "3.8"->{
    Cell[34425, 1245, 96, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.8"}]},
  "3.9"->{
    Cell[34762, 1260, 164, 4, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.9"}]},
  "3.10"->{
    Cell[35144, 1278, 99, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.10"}]},
  "3.11"->{
    Cell[35462, 1293, 80, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.11"}]},
  "3.12"->{
    Cell[35791, 1308, 80, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.12"}]},
  "3.13"->{
    Cell[36092, 1323, 88, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.13"}]},
  "3.14"->{
    Cell[36422, 1338, 331, 7, 70, "Text",
      CellTags->{"S1.8.3", "3.14"}]},
  "3.15"->{
    Cell[52519, 1831, 615, 24, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.15"}]},
  "3.16"->{
    Cell[53387, 1869, 166, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.16"}]},
  "3.17"->{
    Cell[54091, 1898, 210, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.17"}]},
  "3.18"->{
    Cell[54526, 1917, 397, 12, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.18"}]},
  "3.19"->{
    Cell[55198, 1944, 117, 2, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.19"}]},
  "3.20"->{
    Cell[55524, 1960, 186, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.20"}]},
  "3.21"->{
    Cell[58315, 2055, 217, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.21"}]},
  "3.22"->{
    Cell[58739, 2075, 83, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.22"}]},
  "3.23"->{
    Cell[59034, 2090, 127, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.23"}]},
  "3.24"->{
    Cell[59379, 2109, 145, 5, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.24"}]},
  "3.25"->{
    Cell[59872, 2130, 180, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.25"}]},
  "3.26"->{
    Cell[60335, 2150, 79, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.26"}]},
  "3.27"->{
    Cell[60688, 2166, 155, 4, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.27"}]},
  "3.28"->{
    Cell[61071, 2184, 170, 6, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.28"}]},
  "3.29"->{
    Cell[61496, 2204, 142, 4, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.29"}]},
  "3.30"->{
    Cell[61893, 2222, 107, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.30"}]},
  "3.31"->{
    Cell[62250, 2237, 110, 1, 70, "MathCaption",
      CellTags->{"S1.8.3", "3.31"}]},
  "3.32"->{
    Cell[62644, 2253, 257, 9, 70, "Text",
      CellTags->{"S1.8.3", "3.32"}]},
  "S1.8.4"->{
    Cell[62938, 2267, 82, 1, 70, "Subsection",
      CellTags->{"S1.8.4", "4.1"}],
    Cell[63023, 2270, 4201, 124, 70, "DefinitionBox",
      CellTags->"S1.8.4"],
    Cell[67227, 2396, 72, 1, 70, "Caption",
      CellTags->"S1.8.4"],
    Cell[67302, 2399, 94, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.2"}],
    Cell[67421, 2404, 83, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[67507, 2408, 102, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[67624, 2414, 129, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.3"}],
    Cell[67778, 2423, 71, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[67852, 2427, 82, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[67949, 2433, 84, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.4"}],
    Cell[68058, 2438, 70, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[68131, 2442, 82, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[68228, 2448, 106, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.5"}],
    Cell[68359, 2453, 77, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[68439, 2457, 87, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[68541, 2463, 3786, 121, 70, "DefinitionBox",
      CellTags->"S1.8.4"],
    Cell[72330, 2586, 73, 1, 70, "Caption",
      CellTags->"S1.8.4"],
    Cell[72406, 2589, 163, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.6"}],
    Cell[72594, 2598, 74, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[72671, 2602, 90, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[72776, 2608, 90, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.7"}],
    Cell[72891, 2613, 75, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[72969, 2617, 90, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[73074, 2623, 169, 7, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.8"}],
    Cell[73268, 2634, 79, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[73350, 2638, 93, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[73458, 2644, 201, 9, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.9"}],
    Cell[73684, 2657, 82, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[73769, 2661, 90, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[73874, 2667, 144, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.10"}],
    Cell[74043, 2676, 71, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[74117, 2680, 99, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[74231, 2686, 151, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.11"}],
    Cell[74407, 2695, 75, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[74485, 2699, 94, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[74594, 2705, 149, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.12"}],
    Cell[74768, 2714, 80, 2, 70, "Input",
      CellTags->"S1.8.4"],
    Cell[74851, 2718, 100, 3, 70, "Output",
      CellTags->"S1.8.4"],
    Cell[74966, 2724, 324, 10, 70, "Text",
      CellTags->{"S1.8.4", "4.13"}],
    Cell[75293, 2736, 479, 13, 70, "Text",
      CellTags->{"S1.8.4", "4.14"}]},
  "4.1"->{
    Cell[62938, 2267, 82, 1, 70, "Subsection",
      CellTags->{"S1.8.4", "4.1"}]},
  "4.2"->{
    Cell[67302, 2399, 94, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.2"}]},
  "4.3"->{
    Cell[67624, 2414, 129, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.3"}]},
  "4.4"->{
    Cell[67949, 2433, 84, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.4"}]},
  "4.5"->{
    Cell[68228, 2448, 106, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.5"}]},
  "4.6"->{
    Cell[72406, 2589, 163, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.6"}]},
  "4.7"->{
    Cell[72776, 2608, 90, 1, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.7"}]},
  "4.8"->{
    Cell[73074, 2623, 169, 7, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.8"}]},
  "4.9"->{
    Cell[73458, 2644, 201, 9, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.9"}]},
  "4.10"->{
    Cell[73874, 2667, 144, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.10"}]},
  "4.11"->{
    Cell[74231, 2686, 151, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.11"}]},
  "4.12"->{
    Cell[74594, 2705, 149, 5, 70, "MathCaption",
      CellTags->{"S1.8.4", "4.12"}]},
  "4.13"->{
    Cell[74966, 2724, 324, 10, 70, "Text",
      CellTags->{"S1.8.4", "4.13"}]},
  "4.14"->{
    Cell[75293, 2736, 479, 13, 70, "Text",
      CellTags->{"S1.8.4", "4.14"}]},
  "S1.8.5"->{
    Cell[75809, 2754, 94, 1, 70, "Subsection",
      CellTags->{"S1.8.5", "5.1"}],
    Cell[75906, 2757, 2057, 65, 70, "DefinitionBox",
      CellTags->"S1.8.5"],
    Cell[77966, 2824, 86, 1, 70, "Caption",
      CellTags->"S1.8.5"],
    Cell[78055, 2827, 308, 7, 70, "Text",
      CellTags->{"S1.8.5", "5.2"}],
    Cell[78366, 2836, 165, 5, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.3"}],
    Cell[78556, 2845, 92, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[78651, 2849, 91, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[78757, 2855, 165, 6, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.4"}],
    Cell[78947, 2865, 89, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[79039, 2869, 82, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[79136, 2875, 228, 11, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.5"}],
    Cell[79389, 2890, 85, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[79477, 2894, 85, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[79577, 2900, 127, 5, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.6"}],
    Cell[79729, 2909, 85, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[79817, 2913, 86, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[79918, 2919, 221, 8, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.7"}],
    Cell[80164, 2931, 85, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[80252, 2935, 114, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[80381, 2941, 199, 9, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.8"}],
    Cell[80605, 2954, 75, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[80683, 2958, 86, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[80784, 2964, 185, 7, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.9"}],
    Cell[80994, 2975, 78, 2, 70, "Input",
      CellTags->"S1.8.5"],
    Cell[81075, 2979, 129, 3, 70, "Output",
      CellTags->"S1.8.5"],
    Cell[81219, 2985, 573, 18, 70, "Text",
      CellTags->{"S1.8.5", "5.10"}]},
  "5.1"->{
    Cell[75809, 2754, 94, 1, 70, "Subsection",
      CellTags->{"S1.8.5", "5.1"}]},
  "5.2"->{
    Cell[78055, 2827, 308, 7, 70, "Text",
      CellTags->{"S1.8.5", "5.2"}]},
  "5.3"->{
    Cell[78366, 2836, 165, 5, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.3"}]},
  "5.4"->{
    Cell[78757, 2855, 165, 6, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.4"}]},
  "5.5"->{
    Cell[79136, 2875, 228, 11, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.5"}]},
  "5.6"->{
    Cell[79577, 2900, 127, 5, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.6"}]},
  "5.7"->{
    Cell[79918, 2919, 221, 8, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.7"}]},
  "5.8"->{
    Cell[80381, 2941, 199, 9, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.8"}]},
  "5.9"->{
    Cell[80784, 2964, 185, 7, 70, "MathCaption",
      CellTags->{"S1.8.5", "5.9"}]},
  "5.10"->{
    Cell[81219, 2985, 573, 18, 70, "Text",
      CellTags->{"S1.8.5", "5.10"}]},
  "S1.8.6"->{
    Cell[81829, 3008, 103, 1, 70, "Subsection",
      CellTags->{"S1.8.6", "6.1"}],
    Cell[81935, 3011, 4286, 137, 70, "DefinitionBox",
      CellTags->"S1.8.6"],
    Cell[86224, 3150, 96, 1, 70, "Caption",
      CellTags->"S1.8.6"],
    Cell[86323, 3153, 134, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.2"}],
    Cell[86482, 3162, 85, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[86570, 3166, 93, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[86678, 3172, 150, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.3"}],
    Cell[86853, 3181, 87, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[86943, 3185, 93, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[87051, 3191, 150, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.4"}],
    Cell[87226, 3200, 95, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[87324, 3204, 93, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[87432, 3210, 265, 9, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.5"}],
    Cell[87722, 3223, 104, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[87829, 3227, 97, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[87941, 3233, 315, 7, 70, "Text",
      CellTags->{"S1.8.6", "6.6"}],
    Cell[88259, 3242, 1592, 48, 70, "DefinitionBox",
      CellTags->"S1.8.6"],
    Cell[89854, 3292, 66, 1, 70, "Caption",
      CellTags->"S1.8.6"],
    Cell[89923, 3295, 127, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.7"}],
    Cell[90075, 3304, 80, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[90158, 3308, 93, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[90266, 3314, 135, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.8"}],
    Cell[90426, 3323, 74, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[90503, 3327, 82, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[90600, 3333, 122, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.9"}],
    Cell[90747, 3342, 65, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[90815, 3346, 93, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[90923, 3352, 2231, 69, 70, "DefinitionBox",
      CellTags->"S1.8.6"],
    Cell[93157, 3423, 71, 1, 70, "Caption",
      CellTags->"S1.8.6"],
    Cell[93231, 3426, 130, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.10"}],
    Cell[93386, 3435, 84, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[93473, 3439, 97, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[93585, 3445, 97, 1, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.11"}],
    Cell[93707, 3450, 87, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[93797, 3454, 97, 3, 70, "Output",
      CellTags->"S1.8.6"],
    Cell[93909, 3460, 152, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.12"}],
    Cell[94086, 3469, 83, 2, 70, "Input",
      CellTags->"S1.8.6"],
    Cell[94172, 3473, 98, 3, 70, "Output",
      CellTags->"S1.8.6"]},
  "6.1"->{
    Cell[81829, 3008, 103, 1, 70, "Subsection",
      CellTags->{"S1.8.6", "6.1"}]},
  "6.2"->{
    Cell[86323, 3153, 134, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.2"}]},
  "6.3"->{
    Cell[86678, 3172, 150, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.3"}]},
  "6.4"->{
    Cell[87051, 3191, 150, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.4"}]},
  "6.5"->{
    Cell[87432, 3210, 265, 9, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.5"}]},
  "6.6"->{
    Cell[87941, 3233, 315, 7, 70, "Text",
      CellTags->{"S1.8.6", "6.6"}]},
  "6.7"->{
    Cell[89923, 3295, 127, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.7"}]},
  "6.8"->{
    Cell[90266, 3314, 135, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.8"}]},
  "6.9"->{
    Cell[90600, 3333, 122, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.9"}]},
  "6.10"->{
    Cell[93231, 3426, 130, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.10"}]},
  "6.11"->{
    Cell[93585, 3445, 97, 1, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.11"}]},
  "6.12"->{
    Cell[93909, 3460, 152, 5, 70, "MathCaption",
      CellTags->{"S1.8.6", "6.12"}]},
  "S1.8.7"->{
    Cell[94319, 3482, 74, 1, 70, "Subsection",
      CellTags->{"S1.8.7", "7.1"}],
    Cell[94396, 3485, 1734, 52, 70, "DefinitionBox",
      CellTags->"S1.8.7"],
    Cell[96133, 3539, 72, 1, 70, "Caption",
      CellTags->"S1.8.7"],
    Cell[96208, 3542, 140, 4, 70, "MathCaption",
      CellTags->{"S1.8.7", "7.2"}],
    Cell[96373, 3550, 95, 2, 70, "Input",
      CellTags->"S1.8.7"],
    Cell[96471, 3554, 102, 3, 70, "Output",
      CellTags->"S1.8.7"],
    Cell[96588, 3560, 146, 4, 70, "MathCaption",
      CellTags->{"S1.8.7", "7.3"}],
    Cell[96759, 3568, 99, 2, 70, "Input",
      CellTags->"S1.8.7"],
    Cell[96861, 3572, 93, 3, 70, "Output",
      CellTags->"S1.8.7"]},
  "7.1"->{
    Cell[94319, 3482, 74, 1, 70, "Subsection",
      CellTags->{"S1.8.7", "7.1"}]},
  "7.2"->{
    Cell[96208, 3542, 140, 4, 70, "MathCaption",
      CellTags->{"S1.8.7", "7.2"}]},
  "7.3"->{
    Cell[96588, 3560, 146, 4, 70, "MathCaption",
      CellTags->{"S1.8.7", "7.3"}]},
  "S1.8.8"->{
    Cell[97003, 3581, 88, 1, 70, "Subsection",
      CellTags->{"S1.8.8", "8.1"}],
    Cell[97094, 3584, 375, 9, 70, "Text",
      CellTags->{"S1.8.8", "8.2"}],
    Cell[97472, 3595, 3708, 107, 70, "DefinitionBox",
      CellTags->"S1.8.8"],
    Cell[101183, 3704, 68, 1, 70, "Caption",
      CellTags->"S1.8.8"],
    Cell[101254, 3707, 177, 6, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.3"}],
    Cell[101456, 3717, 99, 2, 70, "Input",
      CellTags->"S1.8.8"],
    Cell[101558, 3721, 96, 3, 70, "Output",
      CellTags->"S1.8.8"],
    Cell[101669, 3727, 182, 6, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.4"}],
    Cell[101876, 3737, 101, 2, 70, "Input",
      CellTags->"S1.8.8"],
    Cell[101980, 3741, 87, 3, 70, "Output",
      CellTags->"S1.8.8"],
    Cell[102082, 3747, 180, 5, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.5"}],
    Cell[102287, 3756, 96, 2, 70, "Input",
      CellTags->"S1.8.8"],
    Cell[102386, 3760, 87, 3, 70, "Output",
      CellTags->"S1.8.8"],
    Cell[102488, 3766, 94, 1, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.6"}],
    Cell[102607, 3771, 82, 2, 70, "Input",
      CellTags->"S1.8.8"],
    Cell[102692, 3775, 135, 3, 70, "Output",
      CellTags->"S1.8.8"]},
  "8.1"->{
    Cell[97003, 3581, 88, 1, 70, "Subsection",
      CellTags->{"S1.8.8", "8.1"}]},
  "8.2"->{
    Cell[97094, 3584, 375, 9, 70, "Text",
      CellTags->{"S1.8.8", "8.2"}]},
  "8.3"->{
    Cell[101254, 3707, 177, 6, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.3"}]},
  "8.4"->{
    Cell[101669, 3727, 182, 6, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.4"}]},
  "8.5"->{
    Cell[102082, 3747, 180, 5, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.5"}]},
  "8.6"->{
    Cell[102488, 3766, 94, 1, 70, "MathCaption",
      CellTags->{"S1.8.8", "8.6"}]},
  "S1.8.9"->{
    Cell[102876, 3784, 76, 1, 70, "Subsection",
      CellTags->{"S1.8.9", "9.1"}],
    Cell[102955, 3787, 1946, 60, 70, "DefinitionBox",
      CellTags->"S1.8.9"],
    Cell[104904, 3849, 74, 1, 70, "Caption",
      CellTags->"S1.8.9"],
    Cell[104981, 3852, 190, 5, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.2"}],
    Cell[105196, 3861, 85, 2, 70, "Input",
      CellTags->"S1.8.9"],
    Cell[105284, 3865, 96, 3, 70, "Output",
      CellTags->"S1.8.9"],
    Cell[105395, 3871, 104, 1, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.3"}],
    Cell[105524, 3876, 86, 2, 70, "Input",
      CellTags->"S1.8.9"],
    Cell[105613, 3880, 90, 3, 70, "Output",
      CellTags->"S1.8.9"],
    Cell[105718, 3886, 184, 5, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.4"}],
    Cell[105927, 3895, 94, 2, 70, "Input",
      CellTags->"S1.8.9"],
    Cell[106024, 3899, 96, 3, 70, "Output",
      CellTags->"S1.8.9"],
    Cell[106135, 3905, 188, 6, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.5"}],
    Cell[106348, 3915, 95, 2, 70, "Input",
      CellTags->"S1.8.9"],
    Cell[106446, 3919, 96, 3, 70, "Output",
      CellTags->"S1.8.9"],
    Cell[106557, 3925, 1301, 42, 70, "DefinitionBox",
      CellTags->"S1.8.9"],
    Cell[107861, 3969, 56, 1, 70, "Caption",
      CellTags->"S1.8.9"],
    Cell[107920, 3972, 146, 5, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.6"}],
    Cell[108091, 3981, 89, 2, 70, "Input",
      CellTags->"S1.8.9"],
    Cell[108183, 3985, 111, 3, 70, "Output",
      CellTags->"S1.8.9"]},
  "9.1"->{
    Cell[102876, 3784, 76, 1, 70, "Subsection",
      CellTags->{"S1.8.9", "9.1"}]},
  "9.2"->{
    Cell[104981, 3852, 190, 5, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.2"}]},
  "9.3"->{
    Cell[105395, 3871, 104, 1, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.3"}]},
  "9.4"->{
    Cell[105718, 3886, 184, 5, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.4"}]},
  "9.5"->{
    Cell[106135, 3905, 188, 6, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.5"}]},
  "9.6"->{
    Cell[107920, 3972, 146, 5, 70, "MathCaption",
      CellTags->{"S1.8.9", "9.6"}]},
  "S1.8.10"->{
    Cell[108343, 3994, 102, 1, 70, "Subsection",
      CellTags->{"S1.8.10", "10.1"}],
    Cell[108448, 3997, 1510, 47, 70, "DefinitionBox",
      CellTags->"S1.8.10"],
    Cell[109961, 4046, 93, 1, 70, "Caption",
      CellTags->"S1.8.10"],
    Cell[110057, 4049, 72, 1, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.2"}],
    Cell[110154, 4054, 90, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[110247, 4058, 103, 3, 70, "Output",
      CellTags->"S1.8.10"],
    Cell[110365, 4064, 163, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.3"}],
    Cell[110553, 4072, 80, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[110636, 4076, 106, 3, 70, "Output",
      CellTags->"S1.8.10"],
    Cell[110757, 4082, 140, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.4"}],
    Cell[110922, 4090, 80, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[111005, 4094, 104, 3, 70, "Output",
      CellTags->"S1.8.10"],
    Cell[111124, 4100, 154, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.5"}],
    Cell[111303, 4108, 83, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[111389, 4112, 137, 3, 70, "Output",
      CellTags->"S1.8.10"],
    Cell[111541, 4118, 115, 2, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.6"}],
    Cell[111681, 4124, 99, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[111783, 4128, 117, 3, 70, "Output",
      CellTags->"S1.8.10"],
    Cell[111915, 4134, 2156, 62, 70, "DefinitionBox",
      CellTags->"S1.8.10"],
    Cell[114074, 4198, 88, 1, 70, "Caption",
      CellTags->"S1.8.10"],
    Cell[114165, 4201, 136, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.7"}],
    Cell[114326, 4209, 82, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[114411, 4213, 114, 3, 70, "Output",
      CellTags->"S1.8.10"],
    Cell[114540, 4219, 134, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.8"}],
    Cell[114699, 4227, 92, 2, 70, "Input",
      CellTags->"S1.8.10"],
    Cell[114794, 4231, 130, 3, 70, "Output",
      CellTags->"S1.8.10"]},
  "10.1"->{
    Cell[108343, 3994, 102, 1, 70, "Subsection",
      CellTags->{"S1.8.10", "10.1"}]},
  "10.2"->{
    Cell[110057, 4049, 72, 1, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.2"}]},
  "10.3"->{
    Cell[110365, 4064, 163, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.3"}]},
  "10.4"->{
    Cell[110757, 4082, 140, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.4"}]},
  "10.5"->{
    Cell[111124, 4100, 154, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.5"}]},
  "10.6"->{
    Cell[111541, 4118, 115, 2, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.6"}]},
  "10.7"->{
    Cell[114165, 4201, 136, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.7"}]},
  "10.8"->{
    Cell[114540, 4219, 134, 4, 70, "MathCaption",
      CellTags->{"S1.8.10", "10.8"}]},
  "S1.8.11"->{
    Cell[114973, 4240, 79, 1, 70, "Subsection",
      CellTags->{"S1.8.11", "11.1"}],
    Cell[115055, 4243, 2738, 87, 70, "DefinitionBox",
      CellTags->"S1.8.11"],
    Cell[117796, 4332, 61, 1, 70, "Caption",
      CellTags->"S1.8.11"],
    Cell[117860, 4335, 72, 1, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.2"}],
    Cell[117957, 4340, 88, 2, 70, "Input",
      CellTags->"S1.8.11"],
    Cell[118048, 4344, 101, 3, 70, "Output",
      CellTags->"S1.8.11"],
    Cell[118164, 4350, 101, 1, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.3"}],
    Cell[118290, 4355, 71, 2, 70, "Input",
      CellTags->"S1.8.11"],
    Cell[118364, 4359, 83, 3, 70, "Output",
      CellTags->"S1.8.11"],
    Cell[118462, 4365, 128, 4, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.4"}],
    Cell[118615, 4373, 79, 2, 70, "Input",
      CellTags->"S1.8.11"],
    Cell[118697, 4377, 91, 3, 25, "Output",
      CellTags->"S1.8.11"],
    Cell[118803, 4383, 86, 1, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.5"}],
    Cell[118914, 4388, 71, 2, 28, "Input",
      CellTags->"S1.8.11"],
    Cell[118988, 4392, 93, 3, 25, "Output",
      CellTags->"S1.8.11"]},
  "11.1"->{
    Cell[114973, 4240, 79, 1, 70, "Subsection",
      CellTags->{"S1.8.11", "11.1"}]},
  "11.2"->{
    Cell[117860, 4335, 72, 1, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.2"}]},
  "11.3"->{
    Cell[118164, 4350, 101, 1, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.3"}]},
  "11.4"->{
    Cell[118462, 4365, 128, 4, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.4"}]},
  "11.5"->{
    Cell[118803, 4383, 86, 1, 70, "MathCaption",
      CellTags->{"S1.8.11", "11.5"}]},
  "S1.8.12"->{
    Cell[119130, 4401, 102, 1, 38, "Subsection",
      CellTags->{"S1.8.12", "12.1"}],
    Cell[119235, 4404, 259, 6, 40, "Text",
      CellTags->{"S1.8.12", "12.2"}],
    Cell[119497, 4412, 4916, 145, 186, "DefinitionBox",
      CellTags->"S1.8.12"],
    Cell[124416, 4559, 88, 1, 16, "Caption",
      CellTags->"S1.8.12"],
    Cell[124507, 4562, 210, 5, 56, "MathCaption",
      CellTags->{"S1.8.12", "12.3"}],
    Cell[124742, 4571, 94, 2, 28, "Input",
      CellTags->"S1.8.12"],
    Cell[124839, 4575, 94, 3, 25, "Output",
      CellTags->"S1.8.12"],
    Cell[124948, 4581, 102, 1, 40, "MathCaption",
      CellTags->{"S1.8.12", "12.4"}],
    Cell[125075, 4586, 97, 2, 28, "Input",
      CellTags->"S1.8.12"],
    Cell[125175, 4590, 96, 3, 25, "Output",
      CellTags->"S1.8.12"],
    Cell[125286, 4596, 276, 8, 40, "Text",
      CellTags->{"S1.8.12", "12.5"}]},
  "12.1"->{
    Cell[119130, 4401, 102, 1, 38, "Subsection",
      CellTags->{"S1.8.12", "12.1"}]},
  "12.2"->{
    Cell[119235, 4404, 259, 6, 40, "Text",
      CellTags->{"S1.8.12", "12.2"}]},
  "12.3"->{
    Cell[124507, 4562, 210, 5, 56, "MathCaption",
      CellTags->{"S1.8.12", "12.3"}]},
  "12.4"->{
    Cell[124948, 4581, 102, 1, 40, "MathCaption",
      CellTags->{"S1.8.12", "12.4"}]},
  "12.5"->{
    Cell[125286, 4596, 276, 8, 40, "Text",
      CellTags->{"S1.8.12", "12.5"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.8.0", 126205, 4624},
  {"0.1", 126295, 4627},
  {"S1.8.1", 126388, 4630},
  {"1.1", 127576, 4663},
  {"1.2", 127668, 4666},
  {"1.3", 127756, 4669},
  {"1.4", 127843, 4672},
  {"1.5", 127936, 4675},
  {"1.6", 128030, 4678},
  {"1.7", 128124, 4681},
  {"1.8", 128219, 4684},
  {"S1.8.2", 128311, 4687},
  {"2.1", 133019, 4814},
  {"2.2", 133112, 4817},
  {"2.3", 133200, 4820},
  {"2.4", 133296, 4823},
  {"2.5", 133392, 4826},
  {"2.6", 133486, 4829},
  {"2.7", 133580, 4832},
  {"2.8", 133676, 4835},
  {"2.9", 133772, 4838},
  {"2.10", 133868, 4841},
  {"2.11", 133965, 4844},
  {"2.12", 134056, 4847},
  {"2.13", 134156, 4850},
  {"2.14", 134248, 4853},
  {"2.15", 134339, 4856},
  {"2.16", 134437, 4859},
  {"2.17", 134536, 4862},
  {"2.18", 134627, 4865},
  {"2.19", 134725, 4868},
  {"2.20", 134823, 4871},
  {"2.21", 134921, 4874},
  {"2.22", 135018, 4877},
  {"2.23", 135116, 4880},
  {"2.24", 135209, 4883},
  {"2.25", 135301, 4886},
  {"S1.8.3", 135402, 4889},
  {"3.1", 142647, 5082},
  {"3.2", 142742, 5085},
  {"3.3", 142832, 5088},
  {"3.4", 142929, 5091},
  {"3.5", 143025, 5094},
  {"3.6", 143122, 5097},
  {"3.7", 143219, 5100},
  {"3.8", 143316, 5103},
  {"3.9", 143412, 5106},
  {"3.10", 143510, 5109},
  {"3.11", 143608, 5112},
  {"3.12", 143706, 5115},
  {"3.13", 143804, 5118},
  {"3.14", 143902, 5121},
  {"3.15", 143994, 5124},
  {"3.16", 144094, 5127},
  {"3.17", 144193, 5130},
  {"3.18", 144292, 5133},
  {"3.19", 144392, 5136},
  {"3.20", 144491, 5139},
  {"3.21", 144590, 5142},
  {"3.22", 144689, 5145},
  {"3.23", 144787, 5148},
  {"3.24", 144886, 5151},
  {"3.25", 144985, 5154},
  {"3.26", 145084, 5157},
  {"3.27", 145182, 5160},
  {"3.28", 145281, 5163},
  {"3.29", 145380, 5166},
  {"3.30", 145479, 5169},
  {"3.31", 145578, 5172},
  {"3.32", 145677, 5175},
  {"S1.8.4", 145771, 5178},
  {"4.1", 148796, 5259},
  {"4.2", 148891, 5262},
  {"4.3", 148987, 5265},
  {"4.4", 149084, 5268},
  {"4.5", 149180, 5271},
  {"4.6", 149277, 5274},
  {"4.7", 149374, 5277},
  {"4.8", 149470, 5280},
  {"4.9", 149567, 5283},
  {"4.10", 149665, 5286},
  {"4.11", 149764, 5289},
  {"4.12", 149863, 5292},
  {"4.13", 149962, 5295},
  {"4.14", 150055, 5298},
  {"S1.8.5", 150150, 5301},
  {"5.1", 152125, 5354},
  {"5.2", 152220, 5357},
  {"5.3", 152310, 5360},
  {"5.4", 152407, 5363},
  {"5.5", 152504, 5366},
  {"5.6", 152602, 5369},
  {"5.7", 152699, 5372},
  {"5.8", 152796, 5375},
  {"5.9", 152893, 5378},
  {"5.10", 152991, 5381},
  {"S1.8.6", 153086, 5384},
  {"6.1", 155957, 5461},
  {"6.2", 156053, 5464},
  {"6.3", 156150, 5467},
  {"6.4", 156247, 5470},
  {"6.5", 156344, 5473},
  {"6.6", 156441, 5476},
  {"6.7", 156531, 5479},
  {"6.8", 156628, 5482},
  {"6.9", 156725, 5485},
  {"6.10", 156823, 5488},
  {"6.11", 156922, 5491},
  {"6.12", 157020, 5494},
  {"S1.8.7", 157121, 5497},
  {"7.1", 157816, 5516},
  {"7.2", 157911, 5519},
  {"7.3", 158008, 5522},
  {"S1.8.8", 158108, 5525},
  {"8.1", 159343, 5558},
  {"8.2", 159438, 5561},
  {"8.3", 159528, 5564},
  {"8.4", 159626, 5567},
  {"8.5", 159724, 5570},
  {"8.6", 159822, 5573},
  {"S1.8.9", 159922, 5576},
  {"9.1", 161460, 5617},
  {"9.2", 161556, 5620},
  {"9.3", 161654, 5623},
  {"9.4", 161752, 5626},
  {"9.5", 161850, 5629},
  {"9.6", 161948, 5632},
  {"S1.8.10", 162050, 5635},
  {"10.1", 164083, 5688},
  {"10.2", 164183, 5691},
  {"10.3", 164283, 5694},
  {"10.4", 164384, 5697},
  {"10.5", 164485, 5700},
  {"10.6", 164586, 5703},
  {"10.7", 164687, 5706},
  {"10.8", 164788, 5709},
  {"S1.8.11", 164892, 5712},
  {"11.1", 166069, 5743},
  {"11.2", 166168, 5746},
  {"11.3", 166268, 5749},
  {"11.4", 166369, 5752},
  {"11.5", 166470, 5755},
  {"S1.8.12", 166573, 5758},
  {"12.1", 167454, 5781},
  {"12.2", 167554, 5784},
  {"12.3", 167648, 5787},
  {"12.4", 167749, 5790},
  {"12.5", 167850, 5793}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 108, 4, 65, "Section",
  CellTags->{"S1.8.0", "0.1"}],

Cell[CellGroupData[{
Cell[1909, 61, 86, 1, 70, "Subsection",
  CellTags->{"S1.8.1", "1.1"}],
Cell[1998, 64, 605, 14, 70, "Text",
  CellTags->{"S1.8.1", "1.2"}],
Cell[2606, 80, 233, 6, 70, "Text",
  CellTags->{"S1.8.1", "1.3"}],
Cell[2842, 88, 81, 1, 70, "MathCaption",
  CellTags->{"S1.8.1", "1.4"}],

Cell[CellGroupData[{
Cell[2948, 93, 73, 2, 70, "Input",
  CellTags->"S1.8.1"],
Cell[3024, 97, 90, 3, 70, "Output",
  CellTags->"S1.8.1"]
}, Open  ]],
Cell[3129, 103, 97, 1, 70, "MathCaption",
  CellTags->{"S1.8.1", "1.5"}],

Cell[CellGroupData[{
Cell[3251, 108, 71, 2, 70, "Input",
  CellTags->"S1.8.1"],
Cell[3325, 112, 126, 3, 70, "Output",
  CellTags->"S1.8.1"]
}, Open  ]],
Cell[3466, 118, 95, 1, 70, "MathCaption",
  CellTags->{"S1.8.1", "1.6"}],

Cell[CellGroupData[{
Cell[3586, 123, 71, 2, 70, "Input",
  CellTags->"S1.8.1"],
Cell[3660, 127, 105, 3, 70, "Output",
  CellTags->"S1.8.1"]
}, Open  ]],
Cell[3780, 133, 182, 7, 70, "MathCaption",
  CellTags->{"S1.8.1", "1.7"}],

Cell[CellGroupData[{
Cell[3987, 144, 75, 2, 70, "Input",
  CellTags->"S1.8.1"],
Cell[4065, 148, 93, 3, 70, "Output",
  CellTags->"S1.8.1"]
}, Open  ]],
Cell[4173, 154, 892, 23, 70, "Text",
  CellTags->{"S1.8.1", "1.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5102, 182, 82, 1, 70, "Subsection",
  CellTags->{"S1.8.2", "2.1"}],
Cell[5187, 185, 214, 5, 70, "Text",
  CellTags->{"S1.8.2", "2.2"}],
Cell[5404, 192, 395, 14, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.3"}],

Cell[CellGroupData[{
Cell[5824, 210, 82, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[5909, 214, 102, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[6026, 220, 581, 23, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.4"}],

Cell[CellGroupData[{
Cell[6632, 247, 90, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[6725, 251, 128, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[6868, 257, 87, 1, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.5"}],

Cell[CellGroupData[{
Cell[6980, 262, 68, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[7051, 266, 178, 4, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[7244, 273, 92, 1, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.6"}],

Cell[CellGroupData[{
Cell[7361, 278, 87, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[7451, 282, 129, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[7595, 288, 357, 12, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.7"}],

Cell[CellGroupData[{
Cell[7977, 304, 89, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[8069, 308, 168, 4, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[8252, 315, 256, 11, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.8"}],

Cell[CellGroupData[{
Cell[8533, 330, 95, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[8631, 334, 137, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[8783, 340, 164, 5, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.9"}],

Cell[CellGroupData[{
Cell[8972, 349, 71, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[9046, 353, 109, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[9170, 359, 292, 8, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.10"}],

Cell[CellGroupData[{
Cell[9487, 371, 78, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[9568, 375, 387, 14, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[9970, 392, 450, 11, 70, "Text",
  CellTags->{"S1.8.2", "2.11"}],
Cell[10423, 405, 1059, 41, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.12"}],

Cell[CellGroupData[{
Cell[11507, 450, 96, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[11606, 454, 159, 4, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[11780, 461, 627, 20, 70, "Text",
  CellTags->{"S1.8.2", "2.13"}],
Cell[12410, 483, 189, 5, 70, "Text",
  CellTags->{"S1.8.2", "2.14"}],
Cell[12602, 490, 159, 5, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.15"}],

Cell[CellGroupData[{
Cell[12786, 499, 78, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[12867, 503, 94, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[12976, 509, 321, 10, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.16"}],

Cell[CellGroupData[{
Cell[13322, 523, 86, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[13411, 527, 174, 4, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[13600, 534, 7179, 212, 70, "DefinitionBox",
  CellTags->"S1.8.2"],
Cell[20782, 748, 74, 1, 70, "Caption",
  CellTags->"S1.8.2"],
Cell[20859, 751, 243, 7, 70, "Text",
  CellTags->{"S1.8.2", "2.17"}],
Cell[21105, 760, 227, 8, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.18"}],

Cell[CellGroupData[{
Cell[21357, 772, 97, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[21457, 776, 103, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[21575, 782, 145, 4, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.19"}],

Cell[CellGroupData[{
Cell[21745, 790, 71, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[21819, 794, 93, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[21927, 800, 105, 1, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.20"}],

Cell[CellGroupData[{
Cell[22057, 805, 71, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[22131, 809, 88, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[22234, 815, 94, 1, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.21"}],

Cell[CellGroupData[{
Cell[22353, 820, 73, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[22429, 824, 88, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[22532, 830, 181, 5, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.22"}],

Cell[CellGroupData[{
Cell[22738, 839, 77, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[22818, 843, 345, 12, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]],
Cell[23178, 858, 4882, 146, 70, "DefinitionBox",
  CellTags->"S1.8.2"],
Cell[28063, 1006, 74, 1, 70, "Caption",
  CellTags->"S1.8.2"],
Cell[28140, 1009, 730, 22, 70, "Text",
  CellTags->{"S1.8.2", "2.23"}],
Cell[28873, 1033, 160, 5, 70, "Text",
  CellTags->{"S1.8.2", "2.24"}],
Cell[29036, 1040, 243, 6, 70, "MathCaption",
  CellTags->{"S1.8.2", "2.25"}],

Cell[CellGroupData[{
Cell[29304, 1050, 105, 2, 70, "Input",
  CellTags->"S1.8.2"],
Cell[29412, 1054, 121, 3, 70, "Output",
  CellTags->"S1.8.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29582, 1063, 79, 1, 70, "Subsection",
  CellTags->{"S1.8.3", "3.1"}],
Cell[29664, 1066, 196, 5, 70, "Text",
  CellTags->{"S1.8.3", "3.2"}],
Cell[29863, 1073, 2661, 71, 70, "DefinitionBox",
  CellTags->"S1.8.3"],
Cell[32527, 1146, 94, 1, 70, "Caption",
  CellTags->"S1.8.3"],
Cell[32624, 1149, 169, 6, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.3"}],

Cell[CellGroupData[{
Cell[32818, 1159, 84, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[32905, 1163, 97, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[33017, 1169, 78, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.4"}],

Cell[CellGroupData[{
Cell[33120, 1174, 70, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[33193, 1178, 87, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[33295, 1184, 240, 9, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.5"}],

Cell[CellGroupData[{
Cell[33560, 1197, 72, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[33635, 1201, 82, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[33732, 1207, 103, 3, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.6"}],

Cell[CellGroupData[{
Cell[33860, 1214, 74, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[33937, 1218, 87, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[34039, 1224, 171, 7, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.7"}],

Cell[CellGroupData[{
Cell[34235, 1235, 71, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[34309, 1239, 101, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[34425, 1245, 96, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.8"}],

Cell[CellGroupData[{
Cell[34546, 1250, 89, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[34638, 1254, 109, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[34762, 1260, 164, 4, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.9"}],

Cell[CellGroupData[{
Cell[34951, 1268, 81, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[35035, 1272, 94, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[35144, 1278, 99, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.10"}],

Cell[CellGroupData[{
Cell[35268, 1283, 69, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[35340, 1287, 107, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[35462, 1293, 80, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.11"}],

Cell[CellGroupData[{
Cell[35567, 1298, 69, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[35639, 1302, 137, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[35791, 1308, 80, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.12"}],

Cell[CellGroupData[{
Cell[35896, 1313, 70, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[35969, 1317, 108, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[36092, 1323, 88, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.13"}],

Cell[CellGroupData[{
Cell[36205, 1328, 74, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[36282, 1332, 125, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[36422, 1338, 331, 7, 70, "Text",
  CellTags->{"S1.8.3", "3.14"}],
Cell[36756, 1347, 8377, 256, 70, "DefinitionBox",
  CellTags->"S1.8.3"],
Cell[45136, 1605, 64, 1, 70, "Caption",
  CellTags->"S1.8.3"],
Cell[45203, 1608, 7245, 218, 70, "DefinitionBox",
  CellTags->"S1.8.3"],
Cell[52451, 1828, 65, 1, 70, "Caption",
  CellTags->"S1.8.3"],
Cell[52519, 1831, 615, 24, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.15"}],

Cell[CellGroupData[{
Cell[53159, 1859, 95, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[53257, 1863, 115, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[53387, 1869, 166, 5, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.16"}],

Cell[CellGroupData[{
Cell[53578, 1878, 78, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[53659, 1882, 417, 13, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[54091, 1898, 210, 5, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.17"}],

Cell[CellGroupData[{
Cell[54326, 1907, 76, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[54405, 1911, 106, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[54526, 1917, 397, 12, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.18"}],

Cell[CellGroupData[{
Cell[54948, 1933, 81, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[55032, 1937, 151, 4, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[55198, 1944, 117, 2, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.19"}],

Cell[CellGroupData[{
Cell[55340, 1950, 78, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[55421, 1954, 88, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[55524, 1960, 186, 6, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.20"}],

Cell[CellGroupData[{
Cell[55735, 1970, 90, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[55828, 1974, 115, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[55958, 1980, 2268, 70, 70, "DefinitionBox",
  CellTags->"S1.8.3"],
Cell[58229, 2052, 83, 1, 70, "Caption",
  CellTags->"S1.8.3"],
Cell[58315, 2055, 217, 6, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.21"}],

Cell[CellGroupData[{
Cell[58557, 2065, 66, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[58626, 2069, 98, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[58739, 2075, 83, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.22"}],

Cell[CellGroupData[{
Cell[58847, 2080, 71, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[58921, 2084, 98, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[59034, 2090, 127, 5, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.23"}],

Cell[CellGroupData[{
Cell[59186, 2099, 77, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[59266, 2103, 98, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[59379, 2109, 145, 5, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.24"}],

Cell[CellGroupData[{
Cell[59549, 2118, 75, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[59627, 2122, 230, 5, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[59872, 2130, 180, 6, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.25"}],

Cell[CellGroupData[{
Cell[60077, 2140, 101, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[60181, 2144, 139, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[60335, 2150, 79, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.26"}],

Cell[CellGroupData[{
Cell[60439, 2155, 75, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[60517, 2159, 156, 4, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[60688, 2166, 155, 4, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.27"}],

Cell[CellGroupData[{
Cell[60868, 2174, 70, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[60941, 2178, 115, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[61071, 2184, 170, 6, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.28"}],

Cell[CellGroupData[{
Cell[61266, 2194, 97, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[61366, 2198, 115, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[61496, 2204, 142, 4, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.29"}],

Cell[CellGroupData[{
Cell[61663, 2212, 79, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[61745, 2216, 133, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[61893, 2222, 107, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.30"}],

Cell[CellGroupData[{
Cell[62025, 2227, 74, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[62102, 2231, 133, 3, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[62250, 2237, 110, 1, 70, "MathCaption",
  CellTags->{"S1.8.3", "3.31"}],

Cell[CellGroupData[{
Cell[62385, 2242, 80, 2, 70, "Input",
  CellTags->"S1.8.3"],
Cell[62468, 2246, 161, 4, 70, "Output",
  CellTags->"S1.8.3"]
}, Open  ]],
Cell[62644, 2253, 257, 9, 70, "Text",
  CellTags->{"S1.8.3", "3.32"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[62938, 2267, 82, 1, 70, "Subsection",
  CellTags->{"S1.8.4", "4.1"}],
Cell[63023, 2270, 4201, 124, 70, "DefinitionBox",
  CellTags->"S1.8.4"],
Cell[67227, 2396, 72, 1, 70, "Caption",
  CellTags->"S1.8.4"],
Cell[67302, 2399, 94, 1, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.2"}],

Cell[CellGroupData[{
Cell[67421, 2404, 83, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[67507, 2408, 102, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[67624, 2414, 129, 5, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.3"}],

Cell[CellGroupData[{
Cell[67778, 2423, 71, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[67852, 2427, 82, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[67949, 2433, 84, 1, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.4"}],

Cell[CellGroupData[{
Cell[68058, 2438, 70, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[68131, 2442, 82, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[68228, 2448, 106, 1, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.5"}],

Cell[CellGroupData[{
Cell[68359, 2453, 77, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[68439, 2457, 87, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[68541, 2463, 3786, 121, 70, "DefinitionBox",
  CellTags->"S1.8.4"],
Cell[72330, 2586, 73, 1, 70, "Caption",
  CellTags->"S1.8.4"],
Cell[72406, 2589, 163, 5, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.6"}],

Cell[CellGroupData[{
Cell[72594, 2598, 74, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[72671, 2602, 90, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[72776, 2608, 90, 1, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.7"}],

Cell[CellGroupData[{
Cell[72891, 2613, 75, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[72969, 2617, 90, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[73074, 2623, 169, 7, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.8"}],

Cell[CellGroupData[{
Cell[73268, 2634, 79, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[73350, 2638, 93, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[73458, 2644, 201, 9, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.9"}],

Cell[CellGroupData[{
Cell[73684, 2657, 82, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[73769, 2661, 90, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[73874, 2667, 144, 5, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.10"}],

Cell[CellGroupData[{
Cell[74043, 2676, 71, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[74117, 2680, 99, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[74231, 2686, 151, 5, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.11"}],

Cell[CellGroupData[{
Cell[74407, 2695, 75, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[74485, 2699, 94, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[74594, 2705, 149, 5, 70, "MathCaption",
  CellTags->{"S1.8.4", "4.12"}],

Cell[CellGroupData[{
Cell[74768, 2714, 80, 2, 70, "Input",
  CellTags->"S1.8.4"],
Cell[74851, 2718, 100, 3, 70, "Output",
  CellTags->"S1.8.4"]
}, Open  ]],
Cell[74966, 2724, 324, 10, 70, "Text",
  CellTags->{"S1.8.4", "4.13"}],
Cell[75293, 2736, 479, 13, 70, "Text",
  CellTags->{"S1.8.4", "4.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[75809, 2754, 94, 1, 70, "Subsection",
  CellTags->{"S1.8.5", "5.1"}],
Cell[75906, 2757, 2057, 65, 70, "DefinitionBox",
  CellTags->"S1.8.5"],
Cell[77966, 2824, 86, 1, 70, "Caption",
  CellTags->"S1.8.5"],
Cell[78055, 2827, 308, 7, 70, "Text",
  CellTags->{"S1.8.5", "5.2"}],
Cell[78366, 2836, 165, 5, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.3"}],

Cell[CellGroupData[{
Cell[78556, 2845, 92, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[78651, 2849, 91, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[78757, 2855, 165, 6, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.4"}],

Cell[CellGroupData[{
Cell[78947, 2865, 89, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[79039, 2869, 82, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[79136, 2875, 228, 11, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.5"}],

Cell[CellGroupData[{
Cell[79389, 2890, 85, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[79477, 2894, 85, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[79577, 2900, 127, 5, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.6"}],

Cell[CellGroupData[{
Cell[79729, 2909, 85, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[79817, 2913, 86, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[79918, 2919, 221, 8, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.7"}],

Cell[CellGroupData[{
Cell[80164, 2931, 85, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[80252, 2935, 114, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[80381, 2941, 199, 9, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.8"}],

Cell[CellGroupData[{
Cell[80605, 2954, 75, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[80683, 2958, 86, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[80784, 2964, 185, 7, 70, "MathCaption",
  CellTags->{"S1.8.5", "5.9"}],

Cell[CellGroupData[{
Cell[80994, 2975, 78, 2, 70, "Input",
  CellTags->"S1.8.5"],
Cell[81075, 2979, 129, 3, 70, "Output",
  CellTags->"S1.8.5"]
}, Open  ]],
Cell[81219, 2985, 573, 18, 70, "Text",
  CellTags->{"S1.8.5", "5.10"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[81829, 3008, 103, 1, 70, "Subsection",
  CellTags->{"S1.8.6", "6.1"}],
Cell[81935, 3011, 4286, 137, 70, "DefinitionBox",
  CellTags->"S1.8.6"],
Cell[86224, 3150, 96, 1, 70, "Caption",
  CellTags->"S1.8.6"],
Cell[86323, 3153, 134, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.2"}],

Cell[CellGroupData[{
Cell[86482, 3162, 85, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[86570, 3166, 93, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[86678, 3172, 150, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.3"}],

Cell[CellGroupData[{
Cell[86853, 3181, 87, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[86943, 3185, 93, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[87051, 3191, 150, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.4"}],

Cell[CellGroupData[{
Cell[87226, 3200, 95, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[87324, 3204, 93, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[87432, 3210, 265, 9, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.5"}],

Cell[CellGroupData[{
Cell[87722, 3223, 104, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[87829, 3227, 97, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[87941, 3233, 315, 7, 70, "Text",
  CellTags->{"S1.8.6", "6.6"}],
Cell[88259, 3242, 1592, 48, 70, "DefinitionBox",
  CellTags->"S1.8.6"],
Cell[89854, 3292, 66, 1, 70, "Caption",
  CellTags->"S1.8.6"],
Cell[89923, 3295, 127, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.7"}],

Cell[CellGroupData[{
Cell[90075, 3304, 80, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[90158, 3308, 93, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[90266, 3314, 135, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.8"}],

Cell[CellGroupData[{
Cell[90426, 3323, 74, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[90503, 3327, 82, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[90600, 3333, 122, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.9"}],

Cell[CellGroupData[{
Cell[90747, 3342, 65, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[90815, 3346, 93, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[90923, 3352, 2231, 69, 70, "DefinitionBox",
  CellTags->"S1.8.6"],
Cell[93157, 3423, 71, 1, 70, "Caption",
  CellTags->"S1.8.6"],
Cell[93231, 3426, 130, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.10"}],

Cell[CellGroupData[{
Cell[93386, 3435, 84, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[93473, 3439, 97, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[93585, 3445, 97, 1, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.11"}],

Cell[CellGroupData[{
Cell[93707, 3450, 87, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[93797, 3454, 97, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]],
Cell[93909, 3460, 152, 5, 70, "MathCaption",
  CellTags->{"S1.8.6", "6.12"}],

Cell[CellGroupData[{
Cell[94086, 3469, 83, 2, 70, "Input",
  CellTags->"S1.8.6"],
Cell[94172, 3473, 98, 3, 70, "Output",
  CellTags->"S1.8.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94319, 3482, 74, 1, 70, "Subsection",
  CellTags->{"S1.8.7", "7.1"}],
Cell[94396, 3485, 1734, 52, 70, "DefinitionBox",
  CellTags->"S1.8.7"],
Cell[96133, 3539, 72, 1, 70, "Caption",
  CellTags->"S1.8.7"],
Cell[96208, 3542, 140, 4, 70, "MathCaption",
  CellTags->{"S1.8.7", "7.2"}],

Cell[CellGroupData[{
Cell[96373, 3550, 95, 2, 70, "Input",
  CellTags->"S1.8.7"],
Cell[96471, 3554, 102, 3, 70, "Output",
  CellTags->"S1.8.7"]
}, Open  ]],
Cell[96588, 3560, 146, 4, 70, "MathCaption",
  CellTags->{"S1.8.7", "7.3"}],

Cell[CellGroupData[{
Cell[96759, 3568, 99, 2, 70, "Input",
  CellTags->"S1.8.7"],
Cell[96861, 3572, 93, 3, 70, "Output",
  CellTags->"S1.8.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[97003, 3581, 88, 1, 70, "Subsection",
  CellTags->{"S1.8.8", "8.1"}],
Cell[97094, 3584, 375, 9, 70, "Text",
  CellTags->{"S1.8.8", "8.2"}],
Cell[97472, 3595, 3708, 107, 70, "DefinitionBox",
  CellTags->"S1.8.8"],
Cell[101183, 3704, 68, 1, 70, "Caption",
  CellTags->"S1.8.8"],
Cell[101254, 3707, 177, 6, 70, "MathCaption",
  CellTags->{"S1.8.8", "8.3"}],

Cell[CellGroupData[{
Cell[101456, 3717, 99, 2, 70, "Input",
  CellTags->"S1.8.8"],
Cell[101558, 3721, 96, 3, 70, "Output",
  CellTags->"S1.8.8"]
}, Open  ]],
Cell[101669, 3727, 182, 6, 70, "MathCaption",
  CellTags->{"S1.8.8", "8.4"}],

Cell[CellGroupData[{
Cell[101876, 3737, 101, 2, 70, "Input",
  CellTags->"S1.8.8"],
Cell[101980, 3741, 87, 3, 70, "Output",
  CellTags->"S1.8.8"]
}, Open  ]],
Cell[102082, 3747, 180, 5, 70, "MathCaption",
  CellTags->{"S1.8.8", "8.5"}],

Cell[CellGroupData[{
Cell[102287, 3756, 96, 2, 70, "Input",
  CellTags->"S1.8.8"],
Cell[102386, 3760, 87, 3, 70, "Output",
  CellTags->"S1.8.8"]
}, Open  ]],
Cell[102488, 3766, 94, 1, 70, "MathCaption",
  CellTags->{"S1.8.8", "8.6"}],

Cell[CellGroupData[{
Cell[102607, 3771, 82, 2, 70, "Input",
  CellTags->"S1.8.8"],
Cell[102692, 3775, 135, 3, 70, "Output",
  CellTags->"S1.8.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[102876, 3784, 76, 1, 70, "Subsection",
  CellTags->{"S1.8.9", "9.1"}],
Cell[102955, 3787, 1946, 60, 70, "DefinitionBox",
  CellTags->"S1.8.9"],
Cell[104904, 3849, 74, 1, 70, "Caption",
  CellTags->"S1.8.9"],
Cell[104981, 3852, 190, 5, 70, "MathCaption",
  CellTags->{"S1.8.9", "9.2"}],

Cell[CellGroupData[{
Cell[105196, 3861, 85, 2, 70, "Input",
  CellTags->"S1.8.9"],
Cell[105284, 3865, 96, 3, 70, "Output",
  CellTags->"S1.8.9"]
}, Open  ]],
Cell[105395, 3871, 104, 1, 70, "MathCaption",
  CellTags->{"S1.8.9", "9.3"}],

Cell[CellGroupData[{
Cell[105524, 3876, 86, 2, 70, "Input",
  CellTags->"S1.8.9"],
Cell[105613, 3880, 90, 3, 70, "Output",
  CellTags->"S1.8.9"]
}, Open  ]],
Cell[105718, 3886, 184, 5, 70, "MathCaption",
  CellTags->{"S1.8.9", "9.4"}],

Cell[CellGroupData[{
Cell[105927, 3895, 94, 2, 70, "Input",
  CellTags->"S1.8.9"],
Cell[106024, 3899, 96, 3, 70, "Output",
  CellTags->"S1.8.9"]
}, Open  ]],
Cell[106135, 3905, 188, 6, 70, "MathCaption",
  CellTags->{"S1.8.9", "9.5"}],

Cell[CellGroupData[{
Cell[106348, 3915, 95, 2, 70, "Input",
  CellTags->"S1.8.9"],
Cell[106446, 3919, 96, 3, 70, "Output",
  CellTags->"S1.8.9"]
}, Open  ]],
Cell[106557, 3925, 1301, 42, 70, "DefinitionBox",
  CellTags->"S1.8.9"],
Cell[107861, 3969, 56, 1, 70, "Caption",
  CellTags->"S1.8.9"],
Cell[107920, 3972, 146, 5, 70, "MathCaption",
  CellTags->{"S1.8.9", "9.6"}],

Cell[CellGroupData[{
Cell[108091, 3981, 89, 2, 70, "Input",
  CellTags->"S1.8.9"],
Cell[108183, 3985, 111, 3, 70, "Output",
  CellTags->"S1.8.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[108343, 3994, 102, 1, 70, "Subsection",
  CellTags->{"S1.8.10", "10.1"}],
Cell[108448, 3997, 1510, 47, 70, "DefinitionBox",
  CellTags->"S1.8.10"],
Cell[109961, 4046, 93, 1, 70, "Caption",
  CellTags->"S1.8.10"],
Cell[110057, 4049, 72, 1, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.2"}],

Cell[CellGroupData[{
Cell[110154, 4054, 90, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[110247, 4058, 103, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]],
Cell[110365, 4064, 163, 4, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.3"}],

Cell[CellGroupData[{
Cell[110553, 4072, 80, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[110636, 4076, 106, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]],
Cell[110757, 4082, 140, 4, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.4"}],

Cell[CellGroupData[{
Cell[110922, 4090, 80, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[111005, 4094, 104, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]],
Cell[111124, 4100, 154, 4, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.5"}],

Cell[CellGroupData[{
Cell[111303, 4108, 83, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[111389, 4112, 137, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]],
Cell[111541, 4118, 115, 2, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.6"}],

Cell[CellGroupData[{
Cell[111681, 4124, 99, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[111783, 4128, 117, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]],
Cell[111915, 4134, 2156, 62, 70, "DefinitionBox",
  CellTags->"S1.8.10"],
Cell[114074, 4198, 88, 1, 70, "Caption",
  CellTags->"S1.8.10"],
Cell[114165, 4201, 136, 4, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.7"}],

Cell[CellGroupData[{
Cell[114326, 4209, 82, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[114411, 4213, 114, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]],
Cell[114540, 4219, 134, 4, 70, "MathCaption",
  CellTags->{"S1.8.10", "10.8"}],

Cell[CellGroupData[{
Cell[114699, 4227, 92, 2, 70, "Input",
  CellTags->"S1.8.10"],
Cell[114794, 4231, 130, 3, 70, "Output",
  CellTags->"S1.8.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114973, 4240, 79, 1, 70, "Subsection",
  CellTags->{"S1.8.11", "11.1"}],
Cell[115055, 4243, 2738, 87, 70, "DefinitionBox",
  CellTags->"S1.8.11"],
Cell[117796, 4332, 61, 1, 70, "Caption",
  CellTags->"S1.8.11"],
Cell[117860, 4335, 72, 1, 70, "MathCaption",
  CellTags->{"S1.8.11", "11.2"}],

Cell[CellGroupData[{
Cell[117957, 4340, 88, 2, 70, "Input",
  CellTags->"S1.8.11"],
Cell[118048, 4344, 101, 3, 70, "Output",
  CellTags->"S1.8.11"]
}, Open  ]],
Cell[118164, 4350, 101, 1, 70, "MathCaption",
  CellTags->{"S1.8.11", "11.3"}],

Cell[CellGroupData[{
Cell[118290, 4355, 71, 2, 70, "Input",
  CellTags->"S1.8.11"],
Cell[118364, 4359, 83, 3, 70, "Output",
  CellTags->"S1.8.11"]
}, Open  ]],
Cell[118462, 4365, 128, 4, 70, "MathCaption",
  CellTags->{"S1.8.11", "11.4"}],

Cell[CellGroupData[{
Cell[118615, 4373, 79, 2, 70, "Input",
  CellTags->"S1.8.11"],
Cell[118697, 4377, 91, 3, 25, "Output",
  CellTags->"S1.8.11"]
}, Open  ]],
Cell[118803, 4383, 86, 1, 70, "MathCaption",
  CellTags->{"S1.8.11", "11.5"}],

Cell[CellGroupData[{
Cell[118914, 4388, 71, 2, 28, "Input",
  CellTags->"S1.8.11"],
Cell[118988, 4392, 93, 3, 25, "Output",
  CellTags->"S1.8.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[119130, 4401, 102, 1, 38, "Subsection",
  CellTags->{"S1.8.12", "12.1"}],
Cell[119235, 4404, 259, 6, 40, "Text",
  CellTags->{"S1.8.12", "12.2"}],
Cell[119497, 4412, 4916, 145, 186, "DefinitionBox",
  CellTags->"S1.8.12"],
Cell[124416, 4559, 88, 1, 16, "Caption",
  CellTags->"S1.8.12"],
Cell[124507, 4562, 210, 5, 56, "MathCaption",
  CellTags->{"S1.8.12", "12.3"}],

Cell[CellGroupData[{
Cell[124742, 4571, 94, 2, 28, "Input",
  CellTags->"S1.8.12"],
Cell[124839, 4575, 94, 3, 25, "Output",
  CellTags->"S1.8.12"]
}, Open  ]],
Cell[124948, 4581, 102, 1, 40, "MathCaption",
  CellTags->{"S1.8.12", "12.4"}],

Cell[CellGroupData[{
Cell[125075, 4586, 97, 2, 28, "Input",
  CellTags->"S1.8.12"],
Cell[125175, 4590, 96, 3, 25, "Output",
  CellTags->"S1.8.12"]
}, Open  ]],
Cell[125286, 4596, 276, 8, 40, "Text",
  CellTags->{"S1.8.12", "12.5"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

