(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2866471,     117796]*)
(*NotebookOutlinePosition[   2925906,     119444]*)
(*  CellTagsIndexPosition[   2921175,     119276]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.9 ", "HeadingNumber"],
  "Graphics and Sound"
}], "Section",
  CellTags->{"S1.9.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.9.1 Basic Plotting", "Subsection",
  CellTags->{"S1.9.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Plot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "plot ",
              StyleBox["f", "TI"],
              " as a function of ",
              StyleBox["x", "TI"],
              " from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Plot[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["plot several functions together "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.1"],

Cell["Basic plotting functions. ", "Caption",
  CellTags->"S1.9.1"],

Cell[TextData[{
  "This plots a graph of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " as a function of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " from 0 to ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi]\)], "InlineFormula"],
  ".  "
}], "MathCaption",
  CellTags->{"S1.9.1", "1.2"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x], {x, 0, 2Pi}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004/0000]2000`400007o`0on03o`000ooooool]
ooooo`00ooooool]ooooo`00ooooool]ooooo`00ooooool]ooooo`006oooool00`00003ooooooooo
o`3oooooo`oooooo000Kooooo`0300000?oooooooooo0?oooooo3oooool001?ooooo10000004oooo
o`0300000?oooooooooo0?oooooo3oooool001Gooooo00<00000ooooooooool00oooool00`00003o
ooooooooo`3oooooo`oooooo000Eooooo`0300000?oooooooooo00?ooooo0`000030ooooo`P00000
A_ooool000gooooo10000004ooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool0_Ooo
ool3000000Sooooo0`000013ooooo`005Oooool00`00003oooooooooo`03ooooo`0300000?oooooo
oooo0;_ooooo0P00000>ooooo`<00000@?ooool001?ooooo0`000005ooooo`0300000?oooooooooo
0;Sooooo0`00000Cooooo`800000?_ooool001Gooooo00<00000ooooooooool00oooool00`00003o
ooooooooo`2fooooo`8000006?ooool2000003cooooo000Kooooo`0300000?oooooooooo0;Cooooo
0P00000Looooo`0300000?oooooooooo03Wooooo000Kooooo`0300000?oooooooooo0;?ooooo00<0
0000ooooooooool07Oooool2000003Wooooo000Kooooo`0300000?oooooooooo0;;ooooo00<00000
ooooooooool08?ooool00`00003oooooooooo`0fooooo`006oooool200000;;ooooo00<00000oooo
ooooool08_ooool00`00003oooooooooo`0eooooo`006oooool00`00003oooooooooo`2`ooooo`03
00000?oooooooooo02Cooooo0P00000eooooo`006oooool00`00003oooooooooo`2_ooooo`030000
0?oooooooooo02Oooooo00<00000ooooooooool0<_ooool001_ooooo00<00000ooooooooool0[_oo
ool00`00003oooooooooo`0Yooooo`0300000?oooooooooo037ooooo000Kooooo`0300000?oooooo
oooo0:gooooo00<00000ooooooooool0:oooool00`00003oooooooooo`0`ooooo`006oooool00`00
003oooooooooo`2/ooooo`0300000?oooooooooo02gooooo00<00000ooooooooool0;oooool001_o
oooo00<00000ooooooooool0Zoooool00`00003oooooooooo`0_ooooo`0300000?oooooooooo02ko
oooo000Kooooo`0300000?oooooooooo0:[ooooo00<00000ooooooooool0<?ooool00`00003ooooo
ooooo`0^ooooo`006oooool00`00003oooooooooo`2Yooooo`0300000?oooooooooo03;ooooo00<0
0000ooooooooool0;Oooool001_ooooo0P00002Yooooo`0300000?oooooooooo03Cooooo00<00000
ooooooooool0;?ooool001_ooooo00<00000ooooooooool0Yoooool00`00003oooooooooo`0foooo
o`0300000?oooooooooo02_ooooo000Kooooo`0300000?oooooooooo0:Kooooo00<00000oooooooo
ool0>?ooool00`00003oooooooooo`0Zooooo`006oooool00`00003oooooooooo`2Uooooo`030000
0?oooooooooo03[ooooo00<00000ooooooooool0:Oooool001_ooooo00<00000ooooooooool0YOoo
ool00`00003oooooooooo`0jooooo`0300000?oooooooooo02Wooooo000Kooooo`0300000?oooooo
oooo0:Cooooo00<00000ooooooooool0??ooool00`00003oooooooooo`0Xooooo`006oooool00`00
003oooooooooo`2Sooooo`0300000?oooooooooo03kooooo00<00000ooooooooool09oooool001_o
oooo00<00000ooooooooool0X_ooool00`00003oooooooooo`10ooooo`0300000?oooooooooo02Ko
oooo000Kooooo`800000X_ooool00`00003oooooooooo`11ooooo`0300000?oooooooooo02Kooooo
000Kooooo`0300000?oooooooooo0:7ooooo00<00000ooooooooool0@_ooool00`00003ooooooooo
o`0Uooooo`006oooool00`00003oooooooooo`2Pooooo`0300000?oooooooooo04Cooooo00<00000
ooooooooool09?ooool001_ooooo00<00000ooooooooool0X?ooool00`00003oooooooooo`14oooo
o`0300000?oooooooooo02Cooooo000Kooooo`0300000?oooooooooo09oooooo00<00000oooooooo
ool0A_ooool00`00003oooooooooo`0Sooooo`006oooool00`00003oooooooooo`2Nooooo`030000
0?oooooooooo04Sooooo00<00000ooooooooool08_ooool001_ooooo00<00000ooooooooool0W_oo
ool00`00003oooooooooo`18ooooo`0300000?oooooooooo02;ooooo000Kooooo`0300000?oooooo
oooo09gooooo00<00000ooooooooool0B_ooool00`00003oooooooooo`0Qooooo`006oooool20000
09kooooo00<00000ooooooooool0Boooool00`00003oooooooooo`0Pooooo`006oooool00`00003o
ooooooooo`2Looooo`0300000?oooooooooo04cooooo00<00000ooooooooool08?ooool001_ooooo
00<00000ooooooooool0W?ooool00`00003oooooooooo`1=ooooo`0300000?oooooooooo01oooooo
000Kooooo`0300000?oooooooooo09_ooooo00<00000ooooooooool0Coooool00`00003ooooooooo
o`0Nooooo`006oooool00`00003oooooooooo`2Jooooo`0300000?oooooooooo053ooooo00<00000
ooooooooool07_ooool001_ooooo00<00000ooooooooool0V_ooool00`00003oooooooooo`1Aoooo
o`0300000?oooooooooo01gooooo0008ooooo`8000001?ooool00`00003oooooooooo`02ooooo`<0
00001Oooool00`00003oooooooooo`2Iooooo`0300000?oooooooooo05?ooooo00<00000oooooooo
ool07?ooool000Oooooo00@00000ooooooooool000002oooool00`00003oooooooooo`02ooooo`03
00000?oooooooooo09Wooooo00<00000ooooooooool0Doooool00`00003oooooooooo`0Looooo`00
1oooool01000003oooooooooo`00000;ooooo`0300000?oooooooooo00;ooooo0`00002Hooooo`03
00000?oooooooooo05Gooooo00<00000ooooooooool06oooool00003ooooo`000000000000800000
0_ooool01000003oooooooooo`000008ooooo`<000001Oooool00`00003oooooooooo`2Gooooo`03
00000?oooooooooo05Oooooo00<00000ooooooooool06_ooool000Oooooo00@00000ooooooooool0
00002?ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo09Oooooo00<00000oooooooo
ool0Eoooool00`00003oooooooooo`0Jooooo`001oooool01000003oooooooooo`000008ooooo`03
00000?oooooooooo00Gooooo00<00000ooooooooool0U_ooool00`00003oooooooooo`1Iooooo`03
00000?oooooooooo01Wooooo0008ooooo`8000002Oooool4000000Cooooo00<00000ooooooooool0
U_ooool00`00003oooooooooo`1Iooooo`0300000?oooooooooo01Wooooo000Kooooo`0300000?oo
oooooooo09Gooooo00<00000ooooooooool0Foooool00`00003oooooooooo`0Hooooo`006oooool0
0`00003oooooooooo`2Dooooo`0300000?oooooooooo05cooooo00<00000ooooooooool06?ooool0
01_ooooo00<00000ooooooooool0U?ooool00`00003oooooooooo`1Mooooo`0300000?oooooooooo
01Oooooo000Kooooo`800000U?ooool00`00003oooooooooo`1Oooooo`0300000?oooooooooo01Ko
oooo000Kooooo`0300000?oooooooooo09?ooooo00<00000ooooooooool0Goooool00`00003ooooo
ooooo`0Fooooo`006oooool00`00003oooooooooo`2Booooo`0300000?oooooooooo067ooooo00<0
0000ooooooooool05Oooool001_ooooo00<00000ooooooooool0TOooool00`00003oooooooooo`1R
ooooo`0300000?oooooooooo01Gooooo000Kooooo`0300000?oooooooooo097ooooo00<00000oooo
ooooool0Hoooool00`00003oooooooooo`0Dooooo`006oooool00`00003oooooooooo`2@ooooo`03
00000?oooooooooo06Gooooo00<00000ooooooooool04oooool001_ooooo00<00000ooooooooool0
T?ooool00`00003oooooooooo`1Uooooo`0300000?oooooooooo01?ooooo000Kooooo`0300000?oo
oooooooo08oooooo00<00000ooooooooool0Ioooool00`00003oooooooooo`0Booooo`006oooool2
000008oooooo00<00000ooooooooool0J?ooool00`00003oooooooooo`0Booooo`006oooool00`00
003oooooooooo`2>ooooo`0300000?oooooooooo06Wooooo00<00000ooooooooool04Oooool001_o
oooo00<00000ooooooooool0SOooool00`00003oooooooooo`1Zooooo`0300000?oooooooooo017o
oooo000Kooooo`0300000?oooooooooo08gooooo00<00000ooooooooool0Joooool00`00003ooooo
ooooo`0@ooooo`006oooool00`00003oooooooooo`2<ooooo`0300000?oooooooooo06cooooo00<0
0000ooooooooool04?ooool001_ooooo00<00000ooooooooool0S?ooool00`00003oooooooooo`1]
ooooo`0300000?oooooooooo00oooooo000Kooooo`0300000?oooooooooo08_ooooo00<00000oooo
ooooool0K_ooool00`00003oooooooooo`0?ooooo`006oooool00`00003oooooooooo`2;ooooo`03
00000?oooooooooo06oooooo00<00000ooooooooool03_ooool001_ooooo00<00000ooooooooool0
R_ooool00`00003oooooooooo`1`ooooo`0300000?oooooooooo00kooooo000Kooooo`800000Rooo
ool00`00003oooooooooo`1aooooo`0300000?oooooooooo00gooooo000Kooooo`0300000?oooooo
oooo08Wooooo00<00000ooooooooool0L_ooool00`00003oooooooooo`0=ooooo`006oooool00`00
003oooooooooo`29ooooo`0300000?oooooooooo07?ooooo00<00000ooooooooool03?ooool001_o
oooo00<00000ooooooooool0R?ooool00`00003oooooooooo`1dooooo`0300000?oooooooooo00co
oooo000Kooooo`0300000?oooooooooo08Sooooo00<00000ooooooooool0MOooool00`00003ooooo
ooooo`0;ooooo`006oooool00`00003oooooooooo`27ooooo`0300000?oooooooooo07Kooooo00<0
0000ooooooooool02oooool001_ooooo00<00000ooooooooool09Oooool4000002Kooooo1000000W
ooooo`8000002oooool00`00003oooooooooo`0Looooo`0300000?oooooooooo02Gooooo0`00000X
ooooo`8000001_ooool00`00003oooooooooo`0:ooooo`006oooool00`00003oooooooooo`0Woooo
o`0300000?oooooooooo02Gooooo00<00000ooooooooool09oooool01000003oooooooooo`000009
ooooo`0300000?oooooooooo01gooooo00<00000ooooooooool0:?ooool00`00003oooooooooo`0T
ooooo`0400000?oooooooooo000000Gooooo00<00000ooooooooool02_ooool001_ooooo0P00000X
ooooo`0300000?oooooooooo02Kooooo00<00000ooooooooool0:Oooool00`00003oooooooooo`07
ooooo`0300000?oooooooooo01[ooooo1@00000Yooooo`0300000?oooooooooo02Cooooo00@00000
ooooooooool000001_ooool00`00003oooooooooo`09ooooo`006oooool00`00003oooooooooo`0W
ooooo`0300000?oooooooooo02Oooooo00<00000ooooooooool09_ooool2000000Wooooo00<00000
ooooooooool06oooool01000003oooooooooo`00000Wooooo`<000009oooool3000000Oooooo00<0
0000ooooooooool02Oooool001_ooooo00<00000ooooooooool09oooool00`00003oooooooooo`0X
ooooo`0300000?oooooooooo02Oooooo00<00000ooooooooool01_ooool00`00003oooooooooo`0L
ooooo`0300000?ooool0000002Oooooo00<00000ooooooooool09oooool00`00003oooooooooo`08
ooooo`0300000?oooooooooo00Sooooo000Kooooo`0300000?oooooooooo02Gooooo0`00000Woooo
o`0400000?oooooooooo000002Kooooo00@00000ooooooooool000001oooool00`00003ooooooooo
o`0Nooooo`8000009oooool00`00003oooooooooo`0Wooooo`0300000?oooooooooo00Sooooo00<0
0000ooooooooool02?ooool001_ooooo00<00000ooooooooool09oooool00`00003oooooooooo`0V
ooooo`800000:?ooool2000000Sooooo00<00000ooooooooool07oooool00`00003oooooooooo`0U
ooooo`@000009oooool3000000Sooooo00<00000ooooooooool01oooool001_ooooo00<00000oooo
ooooool0Poooool00`00003oooooooooo`1nooooo`0300000?oooooooooo00Oooooo000Kooooo`03
00000?oooooooooo08?ooooo00<00000ooooooooool0Ooooool00`00003oooooooooo`06ooooo`00
6oooool00`00003oooooooooo`22ooooo`0300000?oooooooooo083ooooo00<00000ooooooooool0
1_ooool001Coooooo`00000I000000006oooool2000000Kooooo00<00000ooooooooool01_ooool0
0`00003oooooooooo`05ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01Oooool0
0`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01Oooool0
0`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_ooool0
0`00003oooooooooo`05ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01Oooool0
0`00003oooooooooo`05ooooo`0300000?oooooooooo00?ooooo00@00000ooooooooool000001ooo
ool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_oo
ool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_oo
ool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Kooooo00<00000ooooooooool01Ooo
ool00`00003oooooooooo`06ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_oo
ool00`00003oooooooooo`05ooooo`0300000?oooooooooo00Gooooo00<00000ooooooooool01_oo
ool10000007ooooo0Oooool001_ooooo0P00000Xooooo`0300000?oooooooooo02Oooooo00<00000
ooooooooool09oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo02?ooooo00<00000
ooooooooool09oooool00`00003oooooooooo`0Wooooo`0300000?oooooooooo017ooooo000Koooo
o`0300000?ooool00000083ooooo00<00000ooooooooool0Roooool001_ooooo00<00000ooooo`00
0000Ooooool00`00003oooooooooo`2<ooooo`006oooool01000003oooooooooo`00001nooooo`03
00000?oooooooooo08cooooo000Kooooo`0400000?oooooooooo000007gooooo00<00000oooooooo
ool0SOooool001_ooooo00D00000oooooooooooooooo0000001looooo`0300000?oooooooooo08go
oooo000Kooooo`8000000_ooool00`00003oooooooooo`1iooooo`0300000?oooooooooo08kooooo
000Kooooo`0300000?oooooooooo00;ooooo00<00000ooooooooool0N?ooool00`00003ooooooooo
o`2>ooooo`006oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo07Oooooo00<00000
ooooooooool0Soooool001_ooooo00<00000ooooooooool00oooool00`00003oooooooooo`1foooo
o`0300000?oooooooooo08oooooo000Kooooo`0300000?oooooooooo00?ooooo00<00000oooooooo
ool0MOooool00`00003oooooooooo`2@ooooo`006oooool00`00003oooooooooo`04ooooo`030000
0?oooooooooo07Cooooo00<00000ooooooooool0T?ooool001_ooooo00<00000ooooooooool01?oo
ool00`00003oooooooooo`1cooooo`0300000?oooooooooo097ooooo000Kooooo`0300000?oooooo
oooo00Gooooo00<00000ooooooooool0L_ooool00`00003oooooooooo`2Aooooo`006oooool20000
00Kooooo00<00000ooooooooool0LOooool00`00003oooooooooo`2Booooo`006oooool00`00003o
ooooooooo`06ooooo`0300000?oooooooooo073ooooo00<00000ooooooooool0T_ooool001_ooooo
00<00000ooooooooool01_ooool00`00003oooooooooo`1_ooooo`0300000?oooooooooo09?ooooo
000Kooooo`0300000?oooooooooo00Oooooo00<00000ooooooooool0K_ooool00`00003ooooooooo
o`2Cooooo`006oooool00`00003oooooooooo`07ooooo`0300000?oooooooooo06gooooo00<00000
ooooooooool0U?ooool001_ooooo00<00000ooooooooool02?ooool00`00003oooooooooo`1/oooo
o`0300000?oooooooooo09Cooooo000Kooooo`0300000?oooooooooo00Wooooo00<00000oooooooo
ool0J_ooool00`00003oooooooooo`2Eooooo`006oooool00`00003oooooooooo`09ooooo`030000
0?oooooooooo06Wooooo00<00000ooooooooool0U_ooool001_ooooo00<00000ooooooooool02_oo
ool00`00003oooooooooo`1Xooooo`0300000?oooooooooo09Kooooo000Kooooo`8000002oooool0
0`00003oooooooooo`1Wooooo`0300000?oooooooooo09Oooooo000Kooooo`0300000?oooooooooo
00_ooooo00<00000ooooooooool0I_ooool00`00003oooooooooo`2Gooooo`006oooool00`00003o
ooooooooo`0;ooooo`0300000?oooooooooo06Gooooo00<00000ooooooooool0V?ooool001_ooooo
00<00000ooooooooool03?ooool00`00003oooooooooo`1Tooooo`0300000?oooooooooo09Sooooo
000Kooooo`0300000?oooooooooo00cooooo00<00000ooooooooool0Hoooool00`00003ooooooooo
o`2Iooooo`006oooool00`00003oooooooooo`0=ooooo`0300000?oooooooooo06;ooooo00<00000
ooooooooool0VOooool001_ooooo00<00000ooooooooool03Oooool00`00003oooooooooo`1Qoooo
o`0300000?oooooooooo09[ooooo000Kooooo`0300000?oooooooooo00kooooo00<00000oooooooo
ool0H?ooool00`00003oooooooooo`2Jooooo`006oooool2000000oooooo00<00000ooooooooool0
Goooool00`00003oooooooooo`2Kooooo`006oooool00`00003oooooooooo`0?ooooo`0300000?oo
oooooooo05gooooo00<00000ooooooooool0W?ooool001_ooooo00<00000ooooooooool03oooool0
0`00003oooooooooo`1Mooooo`0300000?oooooooooo09cooooo000Kooooo`0300000?oooooooooo
013ooooo00<00000ooooooooool0Foooool00`00003oooooooooo`2Mooooo`006oooool00`00003o
ooooooooo`0@ooooo`0300000?oooooooooo05_ooooo00<00000ooooooooool0WOooool001_ooooo
00<00000ooooooooool04Oooool00`00003oooooooooo`1Iooooo`0300000?oooooooooo09kooooo
0008ooooo`8000001?ooool00`00003oooooooooo`02ooooo`<000001Oooool00`00003ooooooooo
o`0Aooooo`0300000?oooooooooo05Wooooo00<00000ooooooooool0W_ooool000Oooooo00@00000
ooooooooool000002oooool00`00003oooooooooo`02ooooo`0300000?oooooooooo01;ooooo00<0
0000ooooooooool0Eoooool00`00003oooooooooo`2Oooooo`001oooool01000003oooooooooo`00
000;ooooo`0300000?oooooooooo00;ooooo0`00000Booooo`0300000?oooooooooo05Oooooo00<0
0000ooooooooool0Woooool000Oooooo00@00000ooooooooool000002?ooool3000000Gooooo00<0
0000ooooooooool04oooool00`00003oooooooooo`1Eooooo`0300000?oooooooooo0:3ooooo0007
ooooo`0400000?oooooooooo000000Sooooo00<00000ooooooooool01Oooool00`00003ooooooooo
o`0Dooooo`0300000?oooooooooo05?ooooo00<00000ooooooooool0XOooool000Oooooo00@00000
ooooooooool000002?ooool00`00003oooooooooo`05ooooo`0300000?oooooooooo01Cooooo00<0
0000ooooooooool0Doooool00`00003oooooooooo`2Qooooo`002?ooool2000000Wooooo10000004
ooooo`0300000?oooooooooo01Gooooo00<00000ooooooooool0DOooool00`00003oooooooooo`2R
ooooo`006oooool00`00003oooooooooo`0Fooooo`0300000?oooooooooo04oooooo00<00000oooo
ooooool0Xoooool001_ooooo00<00000ooooooooool05_ooool00`00003oooooooooo`1?ooooo`03
00000?oooooooooo0:?ooooo000Kooooo`0300000?oooooooooo01Oooooo00<00000ooooooooool0
COooool00`00003oooooooooo`2Tooooo`006oooool2000001Wooooo00<00000ooooooooool0Booo
ool00`00003oooooooooo`2Uooooo`006oooool00`00003oooooooooo`0Iooooo`0300000?oooooo
oooo04[ooooo00<00000ooooooooool0YOooool001_ooooo00<00000ooooooooool06Oooool00`00
003oooooooooo`19ooooo`0300000?oooooooooo0:Kooooo000Kooooo`0300000?oooooooooo01[o
oooo00<00000ooooooooool0Aoooool00`00003oooooooooo`2Wooooo`006oooool00`00003ooooo
ooooo`0Kooooo`0300000?oooooooooo04Gooooo00<00000ooooooooool0Z?ooool001_ooooo00<0
0000ooooooooool06oooool00`00003oooooooooo`15ooooo`0300000?oooooooooo0:Sooooo000K
ooooo`0300000?oooooooooo01cooooo00<00000ooooooooool0@oooool00`00003oooooooooo`2Y
ooooo`006oooool00`00003oooooooooo`0Mooooo`0300000?oooooooooo047ooooo00<00000oooo
ooooool0Z_ooool001_ooooo0P00000Nooooo`0300000?oooooooooo047ooooo00<00000oooooooo
ool0Z_ooool001_ooooo00<00000ooooooooool07_ooool00`00003oooooooooo`0oooooo`030000
0?oooooooooo0:_ooooo000Kooooo`0300000?oooooooooo01oooooo00<00000ooooooooool0?Ooo
ool00`00003oooooooooo`2/ooooo`006oooool00`00003oooooooooo`0Pooooo`0300000?oooooo
oooo03_ooooo00<00000ooooooooool0[Oooool001_ooooo00<00000ooooooooool08Oooool00`00
003oooooooooo`0iooooo`0300000?oooooooooo0:kooooo000Kooooo`0300000?oooooooooo027o
oooo00<00000ooooooooool0>Oooool00`00003oooooooooo`2^ooooo`006oooool00`00003ooooo
ooooo`0Rooooo`0300000?oooooooooo03Oooooo00<00000ooooooooool0[oooool001_ooooo00<0
0000ooooooooool08oooool00`00003oooooooooo`0eooooo`0300000?oooooooooo0;3ooooo000K
ooooo`8000009Oooool00`00003oooooooooo`0cooooo`0300000?oooooooooo0;7ooooo000Koooo
o`0300000?oooooooooo02Gooooo00<00000ooooooooool0<Oooool00`00003oooooooooo`2boooo
o`006oooool00`00003oooooooooo`0Vooooo`0300000?oooooooooo02oooooo00<00000oooooooo
ool0/oooool001_ooooo00<00000ooooooooool09_ooool00`00003oooooooooo`0_ooooo`030000
0?oooooooooo0;?ooooo000Kooooo`0300000?oooooooooo02Oooooo00<00000ooooooooool0;Ooo
ool00`00003oooooooooo`2dooooo`006oooool00`00003oooooooooo`0Xooooo`0300000?oooooo
oooo02_ooooo00<00000ooooooooool0]Oooool001_ooooo00<00000ooooooooool0:Oooool00`00
003oooooooooo`0Yooooo`0300000?oooooooooo0;Kooooo000Kooooo`0300000?oooooooooo02[o
oooo00<00000ooooooooool09oooool00`00003oooooooooo`2gooooo`006oooool00`00003ooooo
ooooo`0[ooooo`0300000?oooooooooo02Cooooo0P00002jooooo`006oooool2000002gooooo00<0
0000ooooooooool08_ooool00`00003oooooooooo`2jooooo`006oooool00`00003oooooooooo`0]
ooooo`0300000?oooooooooo023ooooo00<00000ooooooooool0^oooool001_ooooo00<00000oooo
ooooool0;_ooool00`00003oooooooooo`0Mooooo`800000__ooool001_ooooo00<00000oooooooo
ool0;oooool2000001cooooo00<00000ooooooooool0__ooool001_ooooo00<00000ooooooooool0
<Oooool2000001Sooooo0P000031ooooo`006oooool00`00003oooooooooo`0cooooo`<000004ooo
ool200000<?ooooo000Cooooo`@000001?ooool00`00003oooooooooo`0fooooo`8000003oooool2
00000<Gooooo000Eooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool0>?ooool40000
00Oooooo10000037ooooo`005Oooool00`00003oooooooooo`03ooooo`<00000??ooool700000<_o
oooo000Eooooo`0300000?oooooooooo00?ooooo00<00000ooooooooool0ooooool?ooooo`005Ooo
ool00`00003oooooooooo`03ooooo`0300000?oooooooooo0?oooooo3oooool001?ooooo0`000005
ooooo`0300000?oooooooooo0?oooooo3oooool001Gooooo00<00000ooooooooool00oooool00`00
003oooooooooo`3oooooo`oooooo003oooooobgooooo003oooooobgooooo003oooooobgooooo0000
\
\>"],
  ImageRangeCache->{{{0, 299}, {179, 0}} -> {0, -1, 0, 0}},
  CellTags->"S1.9.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell[TextData[{
  "You can plot functions that have singularities. ",
  StyleBox["Mathematica", "TI"],
  " will try to choose appropriate scales. "
}], "MathCaption",
  CellTags->{"S1.9.1", "1.3"}],

Cell[CellGroupData[{

Cell["Plot[Tan[x], {x, -3, 3}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.308868 0.00596293 [
[.02381 .29637 -6 -9 ]
[.02381 .29637 6 0 ]
[.18254 .29637 -6 -9 ]
[.18254 .29637 6 0 ]
[.34127 .29637 -6 -9 ]
[.34127 .29637 6 0 ]
[.65873 .29637 -3 -9 ]
[.65873 .29637 3 0 ]
[.81746 .29637 -3 -9 ]
[.81746 .29637 3 0 ]
[.97619 .29637 -3 -9 ]
[.97619 .29637 3 0 ]
[.4875 .07035 -18 -4.5 ]
[.4875 .07035 0 4.5 ]
[.4875 .18961 -18 -4.5 ]
[.4875 .18961 0 4.5 ]
[.4875 .42813 -12 -4.5 ]
[.4875 .42813 0 4.5 ]
[.4875 .54739 -12 -4.5 ]
[.4875 .54739 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30887 m
.02381 .31512 L
s
[(-3)] .02381 .29637 0 1 Mshowa
.18254 .30887 m
.18254 .31512 L
s
[(-2)] .18254 .29637 0 1 Mshowa
.34127 .30887 m
.34127 .31512 L
s
[(-1)] .34127 .29637 0 1 Mshowa
.65873 .30887 m
.65873 .31512 L
s
[(1)] .65873 .29637 0 1 Mshowa
.81746 .30887 m
.81746 .31512 L
s
[(2)] .81746 .29637 0 1 Mshowa
.97619 .30887 m
.97619 .31512 L
s
[(3)] .97619 .29637 0 1 Mshowa
.125 Mabswid
.05556 .30887 m
.05556 .31262 L
s
.0873 .30887 m
.0873 .31262 L
s
.11905 .30887 m
.11905 .31262 L
s
.15079 .30887 m
.15079 .31262 L
s
.21429 .30887 m
.21429 .31262 L
s
.24603 .30887 m
.24603 .31262 L
s
.27778 .30887 m
.27778 .31262 L
s
.30952 .30887 m
.30952 .31262 L
s
.37302 .30887 m
.37302 .31262 L
s
.40476 .30887 m
.40476 .31262 L
s
.43651 .30887 m
.43651 .31262 L
s
.46825 .30887 m
.46825 .31262 L
s
.53175 .30887 m
.53175 .31262 L
s
.56349 .30887 m
.56349 .31262 L
s
.59524 .30887 m
.59524 .31262 L
s
.62698 .30887 m
.62698 .31262 L
s
.69048 .30887 m
.69048 .31262 L
s
.72222 .30887 m
.72222 .31262 L
s
.75397 .30887 m
.75397 .31262 L
s
.78571 .30887 m
.78571 .31262 L
s
.84921 .30887 m
.84921 .31262 L
s
.88095 .30887 m
.88095 .31262 L
s
.9127 .30887 m
.9127 .31262 L
s
.94444 .30887 m
.94444 .31262 L
s
.25 Mabswid
0 .30887 m
1 .30887 L
s
.5 .07035 m
.50625 .07035 L
s
[(-40)] .4875 .07035 1 0 Mshowa
.5 .18961 m
.50625 .18961 L
s
[(-20)] .4875 .18961 1 0 Mshowa
.5 .42813 m
.50625 .42813 L
s
[(20)] .4875 .42813 1 0 Mshowa
.5 .54739 m
.50625 .54739 L
s
[(40)] .4875 .54739 1 0 Mshowa
.125 Mabswid
.5 .10017 m
.50375 .10017 L
s
.5 .12998 m
.50375 .12998 L
s
.5 .15979 m
.50375 .15979 L
s
.5 .21942 m
.50375 .21942 L
s
.5 .24924 m
.50375 .24924 L
s
.5 .27905 m
.50375 .27905 L
s
.5 .33868 m
.50375 .33868 L
s
.5 .3685 m
.50375 .3685 L
s
.5 .39831 m
.50375 .39831 L
s
.5 .45794 m
.50375 .45794 L
s
.5 .48776 m
.50375 .48776 L
s
.5 .51757 m
.50375 .51757 L
s
.5 .04054 m
.50375 .04054 L
s
.5 .01072 m
.50375 .01072 L
s
.5 .5772 m
.50375 .5772 L
s
.5 .60701 m
.50375 .60701 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30972 m
.06244 .31128 L
.08255 .31222 L
.10458 .31341 L
.1253 .31478 L
.14415 .31638 L
.16372 .31864 L
.17449 .32032 L
.18466 .32237 L
.19436 .32497 L
.19966 .32678 L
.20463 .32885 L
.21341 .3338 L
.21807 .33749 L
.22307 .34282 L
.22561 .34633 L
.22831 .35093 L
.23087 .35642 L
.23318 .36277 L
.23591 .37281 L
.23744 .38028 L
.23886 .38887 L
.2401 .39829 L
.24146 .41155 L
.24215 .41984 L
.24288 .43034 L
.24421 .45534 L
.24486 .47178 L
.24555 .49382 L
.24679 .55316 L
.24748 .60607 L
s
.24748 .60607 m
.24759 .61803 L
s
.24976 .61803 m
.24992 0 L
s
.25379 0 m
.25472 .07523 L
.25597 .13031 L
.25714 .16283 L
.2582 .18336 L
.25935 .19997 L
.2606 .21371 L
.26192 .22493 L
.2643 .23961 L
.26551 .24528 L
.26683 .2505 L
.26923 .25811 L
.27157 .26384 L
.27374 .26813 L
.27865 .27539 L
.28139 .27845 L
.28387 .28078 L
.28841 .28426 L
.29331 .28721 L
.30219 .29115 L
.31172 .29414 L
.32216 .29654 L
.33307 .29843 L
.34324 .29983 L
.36363 .30195 L
.3822 .3034 L
.4221 .30568 L
.46048 .30735 L
.50132 .30892 L
.54063 .31043 L
.57844 .31208 L
.59945 .31318 L
.61869 .3144 L
.63758 .31589 L
.64718 .31682 L
.65743 .31799 L
.6678 .31944 L
.67721 .32108 L
.68667 .32318 L
.69559 .3258 L
.70534 .32983 L
.71025 .3326 L
.71565 .33654 L
.72025 .34105 L
.72279 .34419 L
.72519 .34777 L
.72743 .3518 L
.72986 .35722 L
.73207 .36347 L
.73411 .37086 L
Mistroke
.73529 .37607 L
.73652 .38259 L
.73873 .39804 L
.73997 .40982 L
.74112 .42395 L
.74238 .44482 L
.74308 .46018 L
.74372 .4775 L
.74488 .52141 L
.74595 .58858 L
Mfstroke
.74595 .58858 m
.74618 .61803 L
s
.74844 .61803 m
.74851 0 L
s
.75249 0 m
.75275 .03214 L
.75342 .07706 L
.75412 .11125 L
.75539 .1527 L
.75617 .17048 L
.7569 .18389 L
.75827 .20306 L
.75958 .21663 L
.76079 .22638 L
.76219 .23544 L
.76351 .24228 L
.76579 .25156 L
.76829 .25919 L
.77073 .26491 L
.77335 .26975 L
.77864 .27694 L
.78353 .28162 L
.7889 .28544 L
.7946 .28853 L
.80417 .2923 L
.80962 .29393 L
.81473 .29522 L
.82457 .29724 L
.83492 .2989 L
.85343 .30112 L
.87319 .30284 L
.89156 .3041 L
.93063 .30614 L
.97215 .30786 L
.97619 .30802 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell["You can give a list of functions to plot. ", "MathCaption",
  CellTags->{"S1.9.1", "1.4"}],

Cell[CellGroupData[{

Cell["Plot[{Sin[x], Sin[2x], Sin[3x]}, {x, 0, 2Pi}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
.02381 .30902 m
.06244 .45263 L
.08255 .51497 L
.0932 .54236 L
.10458 .56657 L
.11009 .57624 L
.11531 .58409 L
.12038 .59047 L
.12507 .59525 L
.12951 .59877 L
.13178 .60018 L
.13422 .60141 L
.13549 .60193 L
.13666 .60234 L
.13784 .60268 L
.13895 .60293 L
.14022 .60314 L
.1409 .60322 L
.14161 .60328 L
.1423 .60331 L
.14295 .60332 L
.14415 .60328 L
.14531 .60316 L
.14656 .60297 L
.14773 .60271 L
.14881 .60241 L
.15143 .60144 L
.15392 .60019 L
.15886 .59679 L
.16423 .59169 L
.17383 .57909 L
.1827 .56357 L
.20137 .51989 L
.22197 .45702 L
.26217 .30798 L
.30086 .16432 L
.32051 .10346 L
.3309 .0766 L
.342 .05274 L
.35275 .03485 L
.35784 .0283 L
.36253 .02337 L
.36724 .01952 L
.36972 .01794 L
.37235 .01661 L
.37463 .01574 L
.37573 .01541 L
.37677 .01516 L
.37799 .01494 L
.37911 .0148 L
Mistroke
.38031 .01472 L
.38162 .01473 L
.38227 .01476 L
.38296 .01482 L
.38419 .01498 L
.38551 .01524 L
.38695 .01564 L
.38955 .0166 L
.39197 .01782 L
.39649 .02088 L
.40134 .02529 L
.40698 .0319 L
.41232 .03956 L
.42232 .05748 L
.44227 .1059 L
.4607 .16316 L
.50002 .3091 L
.53782 .44987 L
.55884 .51523 L
.56803 .53913 L
.57808 .56136 L
.58722 .57774 L
.59696 .59091 L
.60236 .59621 L
.60726 .59976 L
.60962 .60104 L
.61086 .6016 L
.61218 .60211 L
.61333 .60248 L
.61459 .60281 L
.61574 .60304 L
.61682 .60319 L
.61808 .60329 L
.61871 .60332 L
.61941 .60332 L
.62065 .60325 L
.62181 .60312 L
.62248 .60302 L
.62318 .60288 L
.62443 .60258 L
.62578 .60216 L
.62725 .6016 L
.62973 .6004 L
.63238 .59878 L
.63715 .59497 L
.64214 .58976 L
.64686 .58372 L
.6557 .56958 L
.67568 .52489 L
.69413 .47033 L
Mistroke
.7335 .32685 L
.77136 .18397 L
.79241 .1157 L
.81166 .06613 L
.82118 .04724 L
.8262 .0389 L
.83155 .03133 L
.8367 .02536 L
.84136 .02107 L
.84361 .01939 L
.84604 .01786 L
.84835 .01669 L
.85045 .01586 L
.85159 .0155 L
.85283 .01519 L
.85414 .01494 L
.85538 .01479 L
.85653 .01472 L
.85776 .01472 L
.85881 .01479 L
.85997 .01492 L
.86063 .01502 L
.86132 .01516 L
.86256 .01547 L
.86535 .01644 L
.86777 .0176 L
.87041 .01921 L
.87569 .02348 L
.88133 .02957 L
.89148 .0444 L
.90173 .06419 L
.91284 .09067 L
.933 .15021 L
.97393 .30026 L
.97619 .30902 L
Mfstroke
.02381 .30902 m
.04262 .41606 L
.06244 .51276 L
.07286 .5519 L
.08255 .57915 L
.08813 .59036 L
.09076 .59448 L
.0932 .5976 L
.096 .60036 L
.09748 .60145 L
.09824 .60191 L
.09905 .60234 L
.09976 .60265 L
.10041 .60288 L
.10168 .60319 L
.10239 .60328 L
.10317 .60332 L
.1039 .60329 L
.10458 .60321 L
.10587 .6029 L
.10651 .60268 L
.10722 .60237 L
.10848 .6017 L
.10966 .6009 L
.11231 .59853 L
.11515 .59509 L
.12035 .58647 L
.1251 .57604 L
.13466 .54801 L
.14371 .51358 L
.18204 .31193 L
.20142 .20156 L
.21172 .14833 L
.22282 .09846 L
.23339 .06036 L
.23801 .04701 L
.24307 .03492 L
.24787 .02599 L
.25234 .01998 L
.25481 .01761 L
.25705 .01607 L
.25829 .01546 L
.259 .0152 L
.25964 .01501 L
.26083 .01478 L
.26209 .01472 L
.2633 .01483 L
.26462 .01514 L
.26586 .01562 L
.26702 .01622 L
Mistroke
.2692 .01778 L
.27152 .02003 L
.27427 .02348 L
.27684 .02749 L
.28166 .03693 L
.29046 .06049 L
.29997 .09438 L
.31995 .1885 L
.34103 .30762 L
.36093 .42068 L
.37905 .50916 L
.3891 .54783 L
.3986 .57578 L
.40382 .58716 L
.40863 .59506 L
.41115 .59815 L
.41392 .60072 L
.41532 .60169 L
.41605 .60211 L
.41682 .60248 L
.41749 .60275 L
.41823 .60299 L
.41953 .60325 L
.42017 .60331 L
.42086 .60332 L
.42208 .6032 L
.42339 .60288 L
.42414 .60261 L
.42483 .6023 L
.42724 .6008 L
.4286 .59967 L
.42983 .59846 L
.43463 .5921 L
.43918 .58372 L
.44922 .55747 L
.46014 .51783 L
.47989 .42306 L
.50089 .30381 L
.52056 .19252 L
.53861 .10537 L
.54802 .06955 L
.55794 .04079 L
.56309 .02985 L
.56789 .02227 L
.57065 .01909 L
.57315 .01694 L
.57454 .01605 L
.57527 .01568 L
.57605 .01535 L
.57672 .01512 L
Mistroke
.57747 .01492 L
.57878 .01473 L
.58007 .01474 L
.58127 .01492 L
.58259 .01531 L
.58332 .01561 L
.58399 .01594 L
.58653 .01767 L
.58893 .01997 L
.59339 .02597 L
.59821 .03494 L
.6035 .04765 L
.60909 .06418 L
.61909 .10109 L
.65708 .29942 L
.67824 .41987 L
.69753 .51344 L
.70711 .54968 L
.71216 .56538 L
.71752 .57926 L
.7222 .58887 L
.72468 .59301 L
.72736 .5967 L
.72981 .59937 L
.73088 .60032 L
.73205 .60122 L
.73309 .60188 L
.7342 .60244 L
.73537 .60289 L
.73645 .60316 L
.73769 .60331 L
.73839 .60331 L
.73905 .60327 L
.73974 .60316 L
.74037 .60302 L
.7411 .6028 L
.74179 .60253 L
.74301 .60193 L
.74414 .60121 L
.74671 .59905 L
.74953 .59581 L
.75209 .5921 L
.75782 .58118 L
.76281 .5688 L
.7682 .55259 L
.77797 .51632 L
.81905 .29977 L
.83953 .18454 L
.84952 .13458 L
.85861 .09497 L
Mistroke
.86742 .06317 L
.87699 .03711 L
.88224 .02689 L
.88455 .02336 L
.88709 .02016 L
.88949 .01781 L
.89173 .01621 L
.89297 .01557 L
.8941 .01514 L
.89541 .01483 L
.89665 .01472 L
.89789 .01478 L
.89859 .01489 L
.89924 .01505 L
.90042 .01546 L
.90168 .01607 L
.90385 .01755 L
.90623 .0198 L
.90878 .02291 L
.91151 .02706 L
.91645 .03663 L
.92606 .06263 L
.93483 .09413 L
.95391 .18339 L
.97467 .30013 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell[TextData[{
  "To get smooth curves, ",
  StyleBox["Mathematica", "TI"],
  " has to evaluate functions you plot at a large number of points. As a \
result, it is important that you set things up so that each function \
evaluation is as quick as possible. "
}], "Text",
  CellTags->{"S1.9.1", "1.5"}],

Cell[TextData[{
  "When you ask ",
  StyleBox["Mathematica", "TI"],
  " to plot an object, say ",
  StyleBox["f", "TI"],
  ", as a function of ",
  StyleBox["x", "TI"],
  ", there are two possible approaches it can take. One approach is first to \
try and evaluate ",
  StyleBox["f", "TI"],
  ", presumably getting a symbolic expression in terms of ",
  StyleBox["x", "TI"],
  ", and then subsequently evaluate this expression numerically for the \
specific values of ",
  StyleBox["x", "TI"],
  " needed in the plot. The second approach is first to work out what values \
of ",
  StyleBox["x", "TI"],
  " are needed, and only subsequently to evaluate ",
  StyleBox["f", "TI"],
  " with those values of ",
  StyleBox["x", "TI"],
  "."
}], "Text",
  CellTags->{"S1.9.1", "1.6"}],

Cell[TextData[{
  "If you type ",
  StyleBox["Plot[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  " it is the second of these approaches that is used. This has the advantage \
that ",
  StyleBox["Mathematica", "TI"],
  " only tries to evaluate ",
  StyleBox["f", "TI"],
  " for specific numerical values of ",
  StyleBox["x", "TI"],
  "; it does not matter whether sensible values are defined for ",
  StyleBox["f", "TI"],
  " when ",
  StyleBox["x", "TI"],
  " is symbolic. "
}], "Text",
  CellTags->{"S1.9.1", "1.7"}],

Cell[TextData[{
  "There are, however, some cases in which it is much better to have ",
  StyleBox["Mathematica", "TI"],
  " evaluate ",
  StyleBox["f", "TI"],
  " before it starts to make the plot. A typical case is when ",
  StyleBox["f", "TI"],
  " is actually a command that generates a table of functions. You want to \
have ",
  StyleBox["Mathematica", "TI"],
  " first produce the table, and then evaluate the functions, rather than \
trying to produce the table afresh for each value of ",
  StyleBox["x", "TI"],
  ". You can do this by typing ",
  StyleBox["Plot[Evaluate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["],", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["min",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["max",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.9.1", "1.8"}],

Cell[TextData[{
  "This makes a plot of the Bessel functions ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], 
            StyleBox["n",
              "TI"]], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " with ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " running from ",
  Cell[BoxData[
      \(TraditionalForm\`1\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`4\)], "InlineFormula"],
  ". The ",
  StyleBox["Evaluate", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["first", "TI"],
  " to make the table of functions, and only ",
  StyleBox["then", "TI"],
  " to evaluate them for particular values of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.1", "1.9"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[Table[BesselJ[n, x], {n, 4}]], {x, 0, 10}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.234255 0.634279 [
[.21429 .22176 -3 -9 ]
[.21429 .22176 3 0 ]
[.40476 .22176 -3 -9 ]
[.40476 .22176 3 0 ]
[.59524 .22176 -3 -9 ]
[.59524 .22176 3 0 ]
[.78571 .22176 -3 -9 ]
[.78571 .22176 3 0 ]
[.97619 .22176 -6 -9 ]
[.97619 .22176 6 0 ]
[.01131 .1074 -24 -4.5 ]
[.01131 .1074 0 4.5 ]
[.01131 .36111 -18 -4.5 ]
[.01131 .36111 0 4.5 ]
[.01131 .48797 -18 -4.5 ]
[.01131 .48797 0 4.5 ]
[.01131 .61482 -18 -4.5 ]
[.01131 .61482 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .23426 m
.21429 .24051 L
s
[(2)] .21429 .22176 0 1 Mshowa
.40476 .23426 m
.40476 .24051 L
s
[(4)] .40476 .22176 0 1 Mshowa
.59524 .23426 m
.59524 .24051 L
s
[(6)] .59524 .22176 0 1 Mshowa
.78571 .23426 m
.78571 .24051 L
s
[(8)] .78571 .22176 0 1 Mshowa
.97619 .23426 m
.97619 .24051 L
s
[(10)] .97619 .22176 0 1 Mshowa
.125 Mabswid
.07143 .23426 m
.07143 .23801 L
s
.11905 .23426 m
.11905 .23801 L
s
.16667 .23426 m
.16667 .23801 L
s
.2619 .23426 m
.2619 .23801 L
s
.30952 .23426 m
.30952 .23801 L
s
.35714 .23426 m
.35714 .23801 L
s
.45238 .23426 m
.45238 .23801 L
s
.5 .23426 m
.5 .23801 L
s
.54762 .23426 m
.54762 .23801 L
s
.64286 .23426 m
.64286 .23801 L
s
.69048 .23426 m
.69048 .23801 L
s
.7381 .23426 m
.7381 .23801 L
s
.83333 .23426 m
.83333 .23801 L
s
.88095 .23426 m
.88095 .23801 L
s
.92857 .23426 m
.92857 .23801 L
s
.25 Mabswid
0 .23426 m
1 .23426 L
s
.02381 .1074 m
.03006 .1074 L
s
[(-0.2)] .01131 .1074 1 0 Mshowa
.02381 .36111 m
.03006 .36111 L
s
[(0.2)] .01131 .36111 1 0 Mshowa
.02381 .48797 m
.03006 .48797 L
s
[(0.4)] .01131 .48797 1 0 Mshowa
.02381 .61482 m
.03006 .61482 L
s
[(0.6)] .01131 .61482 1 0 Mshowa
.125 Mabswid
.02381 .13911 m
.02756 .13911 L
s
.02381 .17083 m
.02756 .17083 L
s
.02381 .20254 m
.02756 .20254 L
s
.02381 .26597 m
.02756 .26597 L
s
.02381 .29768 m
.02756 .29768 L
s
.02381 .3294 m
.02756 .3294 L
s
.02381 .39282 m
.02756 .39282 L
s
.02381 .42454 m
.02756 .42454 L
s
.02381 .45625 m
.02756 .45625 L
s
.02381 .51968 m
.02756 .51968 L
s
.02381 .55139 m
.02756 .55139 L
s
.02381 .58311 m
.02756 .58311 L
s
.02381 .07569 m
.02756 .07569 L
s
.02381 .04397 m
.02756 .04397 L
s
.02381 .01226 m
.02756 .01226 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .23426 m
.06244 .36028 L
.10458 .47975 L
.12507 .52599 L
.14415 .56016 L
.1536 .57359 L
.16254 .58406 L
.16748 .58889 L
.17284 .59335 L
.17735 .59648 L
.18221 .59918 L
.18475 .60033 L
.18708 .60122 L
.18945 .60196 L
.19165 .60251 L
.19298 .60277 L
.1942 .60297 L
.19554 .60313 L
.19628 .6032 L
.19698 .60325 L
.19825 .60331 L
.19941 .60332 L
.20069 .60329 L
.20134 .60325 L
.20205 .6032 L
.20345 .60306 L
.20479 .60287 L
.20729 .60237 L
.20999 .60164 L
.21292 .60062 L
.2182 .59817 L
.22307 .59521 L
.2327 .58748 L
.24174 .578 L
.26234 .54883 L
.28252 .51113 L
.30103 .46995 L
.34065 .3672 L
.37876 .26133 L
.41932 .15673 L
.45837 .07732 L
.46861 .06127 L
.47971 .04641 L
.48931 .0358 L
.49986 .02658 L
.50482 .02316 L
.51013 .02013 L
.51515 .01788 L
.51974 .01636 L
.52242 .0157 L
Mistroke
.52491 .01523 L
.52634 .01503 L
.52763 .0149 L
.52835 .01484 L
.52913 .01478 L
.52986 .01475 L
.53054 .01473 L
.53177 .01472 L
.53291 .01474 L
.53417 .01479 L
.53488 .01484 L
.53552 .0149 L
.53682 .01504 L
.53823 .01523 L
.54078 .0157 L
.54313 .01626 L
.54565 .01701 L
.55021 .01872 L
.55563 .02135 L
.5606 .02432 L
.57084 .03208 L
.58162 .04251 L
.6014 .06714 L
.61978 .09547 L
.65888 .16776 L
.70043 .25105 L
.74046 .32392 L
.75881 .35159 L
.77898 .37631 L
.78859 .38573 L
.79889 .39403 L
.80458 .39779 L
.80978 .4007 L
.81471 .40299 L
.81995 .40492 L
.82465 .40621 L
.82733 .40676 L
.82985 .40715 L
.83097 .40728 L
.83215 .4074 L
.83315 .40748 L
.83425 .40754 L
.83545 .40759 L
.83672 .4076 L
.83792 .40759 L
.83901 .40756 L
.8403 .40749 L
.84096 .40744 L
.84167 .40738 L
.84413 .4071 L
Mistroke
.84551 .40689 L
.847 .40663 L
.84968 .40605 L
.85495 .40453 L
.85976 .4027 L
.86962 .39767 L
.87876 .39153 L
.89949 .37269 L
.92003 .34817 L
.93864 .32194 L
.97619 .26183 L
Mfstroke
.02381 .23426 m
.02499 .23427 L
.02605 .2343 L
.02729 .23436 L
.02846 .23444 L
.03053 .23465 L
.03279 .23496 L
.03527 .2354 L
.0379 .23599 L
.04262 .23734 L
.04749 .23913 L
.05205 .24118 L
.06244 .24712 L
.07305 .25498 L
.08274 .26366 L
.10458 .28794 L
.14429 .34504 L
.18248 .40764 L
.22313 .47091 L
.24192 .49567 L
.26226 .51751 L
.27341 .52689 L
.28367 .53372 L
.29348 .53853 L
.29842 .54029 L
.30101 .54103 L
.30384 .5417 L
.30656 .54219 L
.30776 .54237 L
.30908 .54253 L
.31024 .54264 L
.31149 .54273 L
.31281 .5428 L
.31404 .54283 L
.31517 .54283 L
.31641 .5428 L
.3177 .54274 L
.3189 .54266 L
.32003 .54255 L
.32105 .54244 L
.32335 .5421 L
.32603 .54157 L
.32851 .54096 L
.33411 .53914 L
.33904 .53702 L
.34426 .53425 L
.3537 .5279 L
.36384 .51917 L
.38215 .49857 L
.40332 .46757 L
Mistroke
.42343 .43195 L
.46167 .35186 L
.50237 .25833 L
.54155 .17211 L
.56157 .13323 L
.58319 .09715 L
.60409 .06935 L
.61404 .05888 L
.6233 .05079 L
.63241 .04447 L
.63709 .04187 L
.64217 .03954 L
.64506 .03844 L
.64773 .03758 L
.65023 .0369 L
.65299 .03629 L
.65546 .03588 L
.65659 .03574 L
.65777 .03561 L
.65905 .03551 L
.66021 .03544 L
.66147 .0354 L
.66218 .03539 L
.66284 .03539 L
.66413 .03542 L
.66477 .03544 L
.66548 .03548 L
.66674 .03557 L
.66791 .03568 L
.67056 .03604 L
.67339 .03657 L
.6786 .03796 L
.68334 .03968 L
.69289 .04444 L
.70194 .05049 L
.72183 .06873 L
.74024 .09104 L
.77947 .15177 L
.81719 .21927 L
.85736 .28982 L
.89602 .34616 L
.91603 .36809 L
.92623 .37698 L
.93713 .38465 L
.94243 .38769 L
.94745 .39012 L
.95234 .39207 L
.95684 .39352 L
.96112 .39457 L
.96327 .39498 L
Mistroke
.96565 .39533 L
.96803 .3956 L
.96936 .3957 L
.97058 .39577 L
.97171 .39581 L
.97295 .39583 L
.97412 .39583 L
.9752 .3958 L
.97619 .39576 L
Mfstroke
.02381 .23426 m
.02499 .23426 L
.02605 .23426 L
.02729 .23426 L
.02846 .23426 L
.02954 .23426 L
.03053 .23426 L
.03163 .23426 L
.03279 .23427 L
.03395 .23427 L
.0352 .23428 L
.03746 .23429 L
.03884 .23431 L
.04016 .23432 L
.04262 .23436 L
.045 .2344 L
.04753 .23446 L
.0521 .2346 L
.05752 .23484 L
.06244 .23513 L
.06787 .23555 L
.07287 .23603 L
.08414 .23753 L
.09408 .23938 L
.10458 .24196 L
.12422 .24869 L
.14255 .25747 L
.1629 .27022 L
.18146 .2846 L
.22131 .32363 L
.25964 .36883 L
.30042 .41939 L
.33968 .46341 L
.35938 .48144 L
.37743 .49461 L
.38686 .5 L
.39678 .50446 L
.4016 .50616 L
.40674 .50762 L
.4097 .5083 L
.41239 .5088 L
.41509 .50921 L
.41632 .50935 L
.41764 .50949 L
.41889 .50959 L
.42003 .50967 L
.42118 .50973 L
.42227 .50976 L
.42353 .50978 L
.4247 .50978 L
Mistroke
.42599 .50975 L
.42671 .50972 L
.42736 .50969 L
.42869 .50961 L
.42991 .50951 L
.43266 .50921 L
.43509 .50885 L
.43765 .50836 L
.44221 .50726 L
.44645 .50594 L
.4561 .50191 L
.46658 .4959 L
.4765 .48867 L
.49506 .47115 L
.53345 .41997 L
.57428 .34817 L
.6136 .27007 L
.6514 .19547 L
.69166 .12618 L
.71017 .10031 L
.7304 .07757 L
.74011 .0689 L
.75048 .06137 L
.75621 .05798 L
.76142 .05539 L
.76636 .05338 L
.77159 .05171 L
.77636 .0506 L
.77907 .05015 L
.78037 .04998 L
.7816 .04985 L
.78271 .04975 L
.78392 .04967 L
.78502 .04962 L
.78604 .04959 L
.78714 .04958 L
.78835 .04959 L
.78962 .04963 L
.79081 .04969 L
.79203 .04978 L
.79335 .04991 L
.79603 .05026 L
.79851 .0507 L
.80082 .0512 L
.80604 .05267 L
.81162 .05475 L
.82185 .05991 L
.83294 .06739 L
.85309 .08565 L
.89397 .13805 L
Mistroke
.93335 .20075 L
.9712 .26334 L
.97619 .27128 L
Mfstroke
.02381 .23426 m
.02499 .23426 L
.02605 .23426 L
.02729 .23426 L
.02846 .23426 L
.02954 .23426 L
.03053 .23426 L
.03163 .23426 L
.03279 .23426 L
.03395 .23426 L
.0352 .23426 L
.03638 .23426 L
.03746 .23426 L
.03873 .23426 L
.04011 .23426 L
.04141 .23426 L
.04262 .23426 L
.04386 .23426 L
.04521 .23426 L
.04765 .23426 L
.05003 .23426 L
.05221 .23427 L
.05459 .23427 L
.05719 .23428 L
.06244 .2343 L
.06527 .23431 L
.06795 .23433 L
.07296 .23437 L
.07836 .23443 L
.08424 .23452 L
.08936 .23462 L
.0948 .23475 L
.10458 .23508 L
.11395 .23552 L
.12405 .23617 L
.13359 .23698 L
.14233 .23792 L
.16125 .24071 L
.17198 .24282 L
.18195 .24518 L
.20241 .25134 L
.221 .25866 L
.26098 .28045 L
.29945 .30929 L
.34037 .34703 L
.37977 .38718 L
.41766 .42512 L
.43874 .4442 L
.458 .45944 L
.47814 .47245 L
Mistroke
.48794 .47749 L
.49682 .48125 L
.50603 .48429 L
.51109 .48557 L
.51584 .48651 L
.51837 .4869 L
.52104 .48724 L
.52332 .48746 L
.5246 .48755 L
.52581 .48763 L
.52649 .48766 L
.52722 .48769 L
.5285 .48773 L
.52923 .48774 L
.53 .48775 L
.53066 .48774 L
.53139 .48774 L
.53268 .48771 L
.5334 .48769 L
.53407 .48766 L
.53529 .48759 L
.53658 .4875 L
.53916 .48726 L
.5416 .48695 L
.54615 .48619 L
.55106 .48507 L
.55636 .48351 L
.56593 .47979 L
.57474 .47533 L
.59354 .46248 L
.6142 .44329 L
.65459 .39193 L
.69347 .32919 L
.73479 .25532 L
.77461 .18551 L
.81291 .12746 L
.83227 .10369 L
.84255 .09294 L
.85366 .08293 L
.8642 .07503 L
.87388 .06922 L
.88314 .06499 L
.88779 .06337 L
.89289 .06197 L
.89542 .06143 L
.89816 .06095 L
.89942 .06078 L
.90076 .06061 L
.90191 .0605 L
.90315 .06039 L
Mistroke
.90435 .06032 L
.90544 .06027 L
.90654 .06023 L
.90759 .06022 L
.9088 .06023 L
.90993 .06025 L
.91116 .06031 L
.91248 .06039 L
.91389 .06051 L
.91519 .06064 L
.91813 .06104 L
.92073 .06151 L
.92346 .06212 L
.92821 .06344 L
.93342 .06528 L
.94363 .07006 L
.95294 .07572 L
.97386 .09273 L
.97619 .09497 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell[TextData[{
  "This finds the numerical solution to a differential equation, as discussed \
in Section ",
  ButtonBox["1.6.4",
    ButtonData:>{"1.6.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.1", "1.10"}],

Cell[CellGroupData[{

Cell["NDSolve[{y'[x] == Sin[y[x]], y[0] == 1}, y, {x, 0, 4}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.9.1"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 4.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot of the solution. The ",
  StyleBox["Evaluate", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " to first set up an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object, then evaluate this at a sequence of ",
  StyleBox["x", "MR"],
  " values. "
}], "MathCaption",
  CellTags->{"S1.9.1", "1.11"}],

Cell[CellGroupData[{

Cell["Plot[Evaluate[ y[x] /. % ], {x, 0, 4}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.9.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 -0.269009 0.283724 [
[.2619 .00222 -3 -9 ]
[.2619 .00222 3 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -3 -9 ]
[.7381 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .15658 -18 -4.5 ]
[.01131 .15658 0 4.5 ]
[.01131 .29844 -6 -4.5 ]
[.01131 .29844 0 4.5 ]
[.01131 .4403 -18 -4.5 ]
[.01131 .4403 0 4.5 ]
[.01131 .58216 -6 -4.5 ]
[.01131 .58216 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(1)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(2)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(3)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(4)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .15658 m
.03006 .15658 L
s
[(1.5)] .01131 .15658 1 0 Mshowa
.02381 .29844 m
.03006 .29844 L
s
[(2)] .01131 .29844 1 0 Mshowa
.02381 .4403 m
.03006 .4403 L
s
[(2.5)] .01131 .4403 1 0 Mshowa
.02381 .58216 m
.03006 .58216 L
s
[(3)] .01131 .58216 1 0 Mshowa
.125 Mabswid
.02381 .04309 m
.02756 .04309 L
s
.02381 .07146 m
.02756 .07146 L
s
.02381 .09983 m
.02756 .09983 L
s
.02381 .1282 m
.02756 .1282 L
s
.02381 .18495 m
.02756 .18495 L
s
.02381 .21332 m
.02756 .21332 L
s
.02381 .24169 m
.02756 .24169 L
s
.02381 .27007 m
.02756 .27007 L
s
.02381 .32681 m
.02756 .32681 L
s
.02381 .35518 m
.02756 .35518 L
s
.02381 .38356 m
.02756 .38356 L
s
.02381 .41193 m
.02756 .41193 L
s
.02381 .46867 m
.02756 .46867 L
s
.02381 .49705 m
.02756 .49705 L
s
.02381 .52542 m
.02756 .52542 L
s
.02381 .55379 m
.02756 .55379 L
s
.02381 .61054 m
.02756 .61054 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .05507 L
.10458 .10225 L
.14415 .14858 L
.18221 .19387 L
.22272 .24158 L
.26171 .28582 L
.30316 .32996 L
.34309 .36892 L
.3815 .40276 L
.42237 .43472 L
.46172 .46168 L
.49955 .48429 L
.53984 .50512 L
.57861 .52234 L
.61984 .53798 L
.65954 .55079 L
.69774 .56131 L
.73838 .57083 L
.77751 .5786 L
.81909 .58559 L
.85916 .59127 L
.89771 .5959 L
.93871 .60008 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Plot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["first", "TI"],
              " choose specific numerical values for ",
              StyleBox["x", "TI"],
              ", then evaluate ",
              StyleBox["f", "TI"],
              " for each value of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Plot[Evaluate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["first", "TI"],
              " evaluate ",
              StyleBox["f", "TI"],
              ", then choose specific numerical values of ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Plot[Evaluate[Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["generate a list of functions, and then plot them "]},
          {Cell[TextData[{
              StyleBox["Plot[Evaluate[", "MR"],
              StyleBox["y", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["solution", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "plot a numerical solution to a differential equation obtained \
from ",
              StyleBox["NDSolve", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.1"],

Cell["Methods for setting up objects to plot. ", "Caption",
  CellTags->"S1.9.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.9.2 Options", "Subsection",
  CellTags->{"S1.9.2", "2.1"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " plots a graph for you, it has to make many choices. It has to work out \
what the scales should be, where the function should be sampled, how the axes \
should be drawn, and so on. Most of the time, ",
  StyleBox["Mathematica", "TI"],
  " will probably make pretty good choices. However, if you want to get the \
very best possible pictures for your particular purposes, you may have to \
help ",
  StyleBox["Mathematica", "TI"],
  " in making some of its choices. "
}], "Text",
  CellTags->{"S1.9.2", "2.2"}],

Cell[TextData[{
  "There is a general mechanism for specifying \[OpenCurlyDoubleQuote]options\
\[CloseCurlyDoubleQuote] in ",
  StyleBox["Mathematica", "TI"],
  " functions. Each option has a definite name. As the last arguments to a \
function like ",
  StyleBox["Plot", "MR"],
  ", you can include a sequence of rules of the form ",
  StyleBox["name", "TI"],
  StyleBox["->", "MR"],
  StyleBox["value", "TI"],
  ", to specify the values for various options. Any option for which you do \
not give an explicit rule is taken to have its \[OpenCurlyDoubleQuote]default\
\[CloseCurlyDoubleQuote] value.   "
}], "Text",
  CellTags->{"S1.9.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Plot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "make a plot, specifying a particular value for an option "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.2"],

Cell["Choosing an option for a plot. ", "Caption",
  CellTags->"S1.9.2"],

Cell[TextData[{
  "A function like ",
  StyleBox["Plot", "MR"],
  " has many options that you can set. Usually you will need to use at most a \
few of them at a time. If you want to optimize a particular plot, you will \
probably do best to experiment, trying a sequence of different settings for \
various options. "
}], "Text",
  CellTags->{"S1.9.2", "2.4"}],

Cell[TextData[{
  "Each time you produce a plot, you can specify options for it. Section ",
  ButtonBox["1.9.3",
    ButtonData:>{"1.9.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " will also discuss how you can change some of the options, even after you \
have produced the plot. "
}], "Text",
  CellTags->{"S1.9.2", "2.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["AspectRatio", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["1/GoldenRatio", "MR"],
              " "
            }]], Cell[TextData[{
              "the height\[Hyphen]to\[Hyphen]width ratio for the plot; ",
              StyleBox["Automatic", "MR"],
              " sets it from the absolute ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " coordinates "
            }]]},
          {Cell[TextData[{
              StyleBox["Axes", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["whether to include axes "]},
          {Cell[TextData[{
              StyleBox["AxesLabel", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[TextData[{
              "labels to be put on the axes; ",
              StyleBox["ylabel", "TI"],
              " specifies a label for the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axis, ",
              StyleBox["{", "MR"],
              StyleBox["xlabel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ylabel", "TI"],
              StyleBox["}", "MR"],
              " for both axes"
            }]]},
          {Cell[TextData[{
              StyleBox["AxesOrigin", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["the point at which axes cross "]},
          {Cell[TextData[{
              StyleBox["TextStyle", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$TextStyle", "MR"],
              " "
            }]], Cell["the default style to use for text in the plot "]},
          {Cell[TextData[{
              StyleBox["FormatType", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["StandardForm", "MR"],
              " "
            }]], Cell[
            "the default format type to use for text in the plot "]},
          {Cell[TextData[{
              StyleBox["DisplayFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$DisplayFunction", "MR"],
              " "
            }]], Cell[TextData[{
              "how to display graphics; ",
              StyleBox["Identity", "MR"],
              " causes no display "
            }]]},
          {Cell[TextData[{
              StyleBox["Frame", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to draw a frame around the plot "]},
          {Cell[TextData[{
              StyleBox["FrameLabel", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[TextData[{
              
              "labels to be put around the frame; give a list in clockwise \
order starting with the lower ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axis "
            }]]},
          {Cell[TextData[{
              StyleBox["FrameTicks", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "what tick marks to draw if there is a frame; ",
              StyleBox["None", "MR"],
              " gives no tick marks "
            }]]},
          {Cell[TextData[{
              StyleBox["GridLines", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[TextData[{
              "what grid lines to include; ",
              StyleBox["Automatic", "MR"],
              " includes a grid line for every major tick mark "
            }]]},
          {Cell[TextData[{
              StyleBox["PlotLabel", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[
            "an expression to be printed as a label for the plot "]},
          {Cell[TextData[{
              StyleBox["PlotRange", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "the range of coordinates to include in the plot; ",
              StyleBox["All", "MR"],
              " includes all points "
            }]]},
          {Cell[TextData[{
              StyleBox["Ticks", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "what tick marks to draw if there are axes; ",
              StyleBox["None", "MR"],
              " gives no tick marks "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.9.2"],

Cell[TextData[{
  "Some of the options for ",
  StyleBox["Plot", "MR"],
  ". These can also be used in ",
  StyleBox["Show", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.9.2"],

Cell["\<\
Here is a plot with all options having their default values. \
\>", \
"MathCaption",
  CellTags->{"S1.9.2", "2.6"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x^2], {x, 0, 3}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309015 0.294305 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.5)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(1)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(2)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .19129 m
.02756 .19129 L
s
.02381 .22072 m
.02756 .22072 L
s
.02381 .25015 m
.02756 .25015 L
s
.02381 .27958 m
.02756 .27958 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02499 .30902 L
.02605 .30903 L
.02729 .30905 L
.02846 .30908 L
.03053 .30915 L
.03279 .30925 L
.03527 .3094 L
.0379 .30959 L
.04262 .31005 L
.04749 .31065 L
.05205 .31134 L
.06244 .31337 L
.07305 .31609 L
.08274 .31916 L
.10458 .32805 L
.12357 .33803 L
.14429 .35126 L
.18493 .38399 L
.22406 .42306 L
.26565 .47038 L
.30571 .51777 L
.34426 .55963 L
.36381 .57729 L
.37417 .58519 L
.38527 .59231 L
.39075 .59525 L
.39595 .59765 L
.40101 .59961 L
.40569 .60107 L
.41012 .60213 L
.41235 .60254 L
.41364 .60274 L
.41482 .6029 L
.416 .60303 L
.41729 .60314 L
.41858 .60323 L
.41929 .60327 L
.41994 .60329 L
.42116 .60332 L
.42227 .60332 L
.42355 .60329 L
.42475 .60323 L
.42591 .60316 L
.42715 .60304 L
.42938 .60277 L
.43204 .60231 L
.43448 .60177 L
.43975 .60019 L
.44477 .59816 L
Mistroke
.4536 .59327 L
.46322 .58597 L
.47356 .57575 L
.48293 .5643 L
.50392 .53098 L
.5232 .49108 L
.54404 .43867 L
.58509 .31362 L
.62463 .18358 L
.64453 .12361 L
.66266 .07702 L
.67202 .05706 L
.6822 .03924 L
.68779 .03134 L
.69296 .02533 L
.69789 .0208 L
.70045 .01893 L
.70313 .01732 L
.70548 .01623 L
.70671 .01577 L
.70804 .01537 L
.70926 .01508 L
.71036 .01489 L
.71148 .01477 L
.71253 .01472 L
.71376 .01473 L
.71506 .01483 L
.71617 .015 L
.71738 .01525 L
.7187 .01562 L
.7201 .01613 L
.72264 .01733 L
.72499 .01876 L
.72755 .02068 L
.73221 .02514 L
.74093 .03686 L
.75032 .05433 L
.76069 .07932 L
.78168 .14676 L
.82186 .31967 L
.86051 .49021 L
.88053 .5566 L
.8906 .5802 L
.8963 .59013 L
.89907 .59398 L
.90162 .59696 L
.90402 .59926 L
.90666 .6012 L
.90803 .60196 L
.90931 .60252 L
Mistroke
.91001 .60277 L
.91067 .60296 L
.91143 .60313 L
.91212 .60323 L
.91332 .60332 L
.91459 .60327 L
.91579 .60308 L
.91687 .60279 L
.91815 .60232 L
.91954 .60163 L
.92205 .59993 L
.9243 .59792 L
.92676 .59516 L
.93173 .58788 L
.93633 .5791 L
.94063 .56917 L
.95924 .50798 L
.97619 .4303 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell["This draws axes on a frame around the plot. ", "MathCaption",
  CellTags->{"S1.9.2", "2.7"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x^2], {x, 0, 3}, Frame->True]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309015 0.294305 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -9 -9 ]
[.18254 -0.0125 9 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -9 -9 ]
[.81746 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01471 -12 -4.5 ]
[-0.0125 .01471 0 4.5 ]
[-0.0125 .16186 -24 -4.5 ]
[-0.0125 .16186 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .45617 -18 -4.5 ]
[-0.0125 .45617 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(0.5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1.5)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(2)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2.5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01471 m
.00625 .01471 L
s
[(-1)] -0.0125 .01471 1 0 Mshowa
0 .16186 m
.00625 .16186 L
s
[(-0.5)] -0.0125 .16186 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .45617 m
.00625 .45617 L
s
[(0.5)] -0.0125 .45617 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04414 m
.00375 .04414 L
s
0 .07357 m
.00375 .07357 L
s
0 .103 m
.00375 .103 L
s
0 .13243 m
.00375 .13243 L
s
0 .19129 m
.00375 .19129 L
s
0 .22072 m
.00375 .22072 L
s
0 .25015 m
.00375 .25015 L
s
0 .27958 m
.00375 .27958 L
s
0 .33845 m
.00375 .33845 L
s
0 .36788 m
.00375 .36788 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .4856 m
.00375 .4856 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01471 m
1 .01471 L
s
.99375 .16186 m
1 .16186 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .45617 m
1 .45617 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04414 m
1 .04414 L
s
.99625 .07357 m
1 .07357 L
s
.99625 .103 m
1 .103 L
s
.99625 .13243 m
1 .13243 L
s
.99625 .19129 m
1 .19129 L
s
.99625 .22072 m
1 .22072 L
s
.99625 .25015 m
1 .25015 L
s
.99625 .27958 m
1 .27958 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .36788 m
1 .36788 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .4856 m
1 .4856 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .30902 m
1 .30902 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02499 .30902 L
.02605 .30903 L
.02729 .30905 L
.02846 .30908 L
.03053 .30915 L
.03279 .30925 L
.03527 .3094 L
.0379 .30959 L
.04262 .31005 L
.04749 .31065 L
.05205 .31134 L
.06244 .31337 L
.07305 .31609 L
.08274 .31916 L
.10458 .32805 L
.12357 .33803 L
.14429 .35126 L
.18493 .38399 L
.22406 .42306 L
.26565 .47038 L
.30571 .51777 L
.34426 .55963 L
.36381 .57729 L
.37417 .58519 L
.38527 .59231 L
.39075 .59525 L
.39595 .59765 L
.40101 .59961 L
.40569 .60107 L
.41012 .60213 L
.41235 .60254 L
.41364 .60274 L
.41482 .6029 L
.416 .60303 L
.41729 .60314 L
.41858 .60323 L
.41929 .60327 L
.41994 .60329 L
.42116 .60332 L
.42227 .60332 L
.42355 .60329 L
.42475 .60323 L
.42591 .60316 L
.42715 .60304 L
.42938 .60277 L
.43204 .60231 L
.43448 .60177 L
.43975 .60019 L
.44477 .59816 L
Mistroke
.4536 .59327 L
.46322 .58597 L
.47356 .57575 L
.48293 .5643 L
.50392 .53098 L
.5232 .49108 L
.54404 .43867 L
.58509 .31362 L
.62463 .18358 L
.64453 .12361 L
.66266 .07702 L
.67202 .05706 L
.6822 .03924 L
.68779 .03134 L
.69296 .02533 L
.69789 .0208 L
.70045 .01893 L
.70313 .01732 L
.70548 .01623 L
.70671 .01577 L
.70804 .01537 L
.70926 .01508 L
.71036 .01489 L
.71148 .01477 L
.71253 .01472 L
.71376 .01473 L
.71506 .01483 L
.71617 .015 L
.71738 .01525 L
.7187 .01562 L
.7201 .01613 L
.72264 .01733 L
.72499 .01876 L
.72755 .02068 L
.73221 .02514 L
.74093 .03686 L
.75032 .05433 L
.76069 .07932 L
.78168 .14676 L
.82186 .31967 L
.86051 .49021 L
.88053 .5566 L
.8906 .5802 L
.8963 .59013 L
.89907 .59398 L
.90162 .59696 L
.90402 .59926 L
.90666 .6012 L
.90803 .60196 L
.90931 .60252 L
Mistroke
.91001 .60277 L
.91067 .60296 L
.91143 .60313 L
.91212 .60323 L
.91332 .60332 L
.91459 .60327 L
.91579 .60308 L
.91687 .60279 L
.91815 .60232 L
.91954 .60163 L
.92205 .59993 L
.9243 .59792 L
.92676 .59516 L
.93173 .58788 L
.93633 .5791 L
.94063 .56917 L
.95924 .50798 L
.97619 .4303 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell[TextData[{
  "This specifies labels for the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axes. The expressions you give as labels are printed just as they would \
be if they appeared as ",
  StyleBox["Mathematica", "TI"],
  " output. You can give any piece of text by putting it inside a pair of \
double quotes. "
}], "MathCaption",
  CellTags->{"S1.9.2", "2.8"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Sin[x^2], {x, 0, 3}, AxesLabel -> {\"x value\", \"Sin[x^2]\"} \
]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.9.2"],

Cell[BoxData[
    \(FrontEndObject::"notavail" \(\(:\)\(\ \)\) 
      "A front end is not available; certain operations require a front end."\
\)], "Message",
  CellTags->"S1.9.2"],

Cell[BoxData[
    \(FrontEndObject::"notavail" \(\(:\)\(\ \)\) 
      "A front end is not available; certain operations require a front end."\
\)], "Message",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309015 0.294305 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[1.025 .30902 0 -4.5 ]
[1.025 .30902 42 4.5 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -24 0 ]
[.02381 .64303 24 9 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.5)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(1)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(2)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
[(x value)] 1.025 .30902 -1 0 Mshowa
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .19129 m
.02756 .19129 L
s
.02381 .22072 m
.02756 .22072 L
s
.02381 .25015 m
.02756 .25015 L
s
.02381 .27958 m
.02756 .27958 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
[(Sin[x^2])] .02381 .64303 0 -1 Mshowa
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02499 .30902 L
.02605 .30903 L
.02729 .30905 L
.02846 .30908 L
.03053 .30915 L
.03279 .30925 L
.03527 .3094 L
.0379 .30959 L
.04262 .31005 L
.04749 .31065 L
.05205 .31134 L
.06244 .31337 L
.07305 .31609 L
.08274 .31916 L
.10458 .32805 L
.12357 .33803 L
.14429 .35126 L
.18493 .38399 L
.22406 .42306 L
.26565 .47038 L
.30571 .51777 L
.34426 .55963 L
.36381 .57729 L
.37417 .58519 L
.38527 .59231 L
.39075 .59525 L
.39595 .59765 L
.40101 .59961 L
.40569 .60107 L
.41012 .60213 L
.41235 .60254 L
.41364 .60274 L
.41482 .6029 L
.416 .60303 L
.41729 .60314 L
.41858 .60323 L
.41929 .60327 L
.41994 .60329 L
.42116 .60332 L
.42227 .60332 L
.42355 .60329 L
.42475 .60323 L
.42591 .60316 L
.42715 .60304 L
.42938 .60277 L
.43204 .60231 L
.43448 .60177 L
.43975 .60019 L
.44477 .59816 L
Mistroke
.4536 .59327 L
.46322 .58597 L
.47356 .57575 L
.48293 .5643 L
.50392 .53098 L
.5232 .49108 L
.54404 .43867 L
.58509 .31362 L
.62463 .18358 L
.64453 .12361 L
.66266 .07702 L
.67202 .05706 L
.6822 .03924 L
.68779 .03134 L
.69296 .02533 L
.69789 .0208 L
.70045 .01893 L
.70313 .01732 L
.70548 .01623 L
.70671 .01577 L
.70804 .01537 L
.70926 .01508 L
.71036 .01489 L
.71148 .01477 L
.71253 .01472 L
.71376 .01473 L
.71506 .01483 L
.71617 .015 L
.71738 .01525 L
.7187 .01562 L
.7201 .01613 L
.72264 .01733 L
.72499 .01876 L
.72755 .02068 L
.73221 .02514 L
.74093 .03686 L
.75032 .05433 L
.76069 .07932 L
.78168 .14676 L
.82186 .31967 L
.86051 .49021 L
.88053 .5566 L
.8906 .5802 L
.8963 .59013 L
.89907 .59398 L
.90162 .59696 L
.90402 .59926 L
.90666 .6012 L
.90803 .60196 L
.90931 .60252 L
Mistroke
.91001 .60277 L
.91067 .60296 L
.91143 .60313 L
.91212 .60323 L
.91332 .60332 L
.91459 .60327 L
.91579 .60308 L
.91687 .60279 L
.91815 .60232 L
.91954 .60163 L
.92205 .59993 L
.9243 .59792 L
.92676 .59516 L
.93173 .58788 L
.93633 .5791 L
.94063 .56917 L
.95924 .50798 L
.97619 .4303 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell["\<\
You can give several options at the same time, in any order. \
\>", \
"MathCaption",
  CellTags->{"S1.9.2", "2.9"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Sin[x^2], {x, 0, 3}, Frame -> True, GridLines -> \
Automatic]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.309015 0.294305 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -9 -9 ]
[.18254 -0.0125 9 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -9 -9 ]
[.81746 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01471 -12 -4.5 ]
[-0.0125 .01471 0 4.5 ]
[-0.0125 .16186 -24 -4.5 ]
[-0.0125 .16186 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .45617 -18 -4.5 ]
[-0.0125 .45617 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .61803 L
s
.34127 0 m
.34127 .61803 L
s
.5 0 m
.5 .61803 L
s
.65873 0 m
.65873 .61803 L
s
.81746 0 m
.81746 .61803 L
s
0 .16186 m
1 .16186 L
s
0 .30902 m
1 .30902 L
s
0 .45617 m
1 .45617 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(0.5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1.5)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(2)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2.5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01471 m
.00625 .01471 L
s
[(-1)] -0.0125 .01471 1 0 Mshowa
0 .16186 m
.00625 .16186 L
s
[(-0.5)] -0.0125 .16186 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .45617 m
.00625 .45617 L
s
[(0.5)] -0.0125 .45617 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04414 m
.00375 .04414 L
s
0 .07357 m
.00375 .07357 L
s
0 .103 m
.00375 .103 L
s
0 .13243 m
.00375 .13243 L
s
0 .19129 m
.00375 .19129 L
s
0 .22072 m
.00375 .22072 L
s
0 .25015 m
.00375 .25015 L
s
0 .27958 m
.00375 .27958 L
s
0 .33845 m
.00375 .33845 L
s
0 .36788 m
.00375 .36788 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .4856 m
.00375 .4856 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01471 m
1 .01471 L
s
.99375 .16186 m
1 .16186 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .45617 m
1 .45617 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04414 m
1 .04414 L
s
.99625 .07357 m
1 .07357 L
s
.99625 .103 m
1 .103 L
s
.99625 .13243 m
1 .13243 L
s
.99625 .19129 m
1 .19129 L
s
.99625 .22072 m
1 .22072 L
s
.99625 .25015 m
1 .25015 L
s
.99625 .27958 m
1 .27958 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .36788 m
1 .36788 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .4856 m
1 .4856 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .30902 m
1 .30902 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02499 .30902 L
.02605 .30903 L
.02729 .30905 L
.02846 .30908 L
.03053 .30915 L
.03279 .30925 L
.03527 .3094 L
.0379 .30959 L
.04262 .31005 L
.04749 .31065 L
.05205 .31134 L
.06244 .31337 L
.07305 .31609 L
.08274 .31916 L
.10458 .32805 L
.12357 .33803 L
.14429 .35126 L
.18493 .38399 L
.22406 .42306 L
.26565 .47038 L
.30571 .51777 L
.34426 .55963 L
.36381 .57729 L
.37417 .58519 L
.38527 .59231 L
.39075 .59525 L
.39595 .59765 L
.40101 .59961 L
.40569 .60107 L
.41012 .60213 L
.41235 .60254 L
.41364 .60274 L
.41482 .6029 L
.416 .60303 L
.41729 .60314 L
.41858 .60323 L
.41929 .60327 L
.41994 .60329 L
.42116 .60332 L
.42227 .60332 L
.42355 .60329 L
.42475 .60323 L
.42591 .60316 L
.42715 .60304 L
.42938 .60277 L
.43204 .60231 L
.43448 .60177 L
.43975 .60019 L
.44477 .59816 L
Mistroke
.4536 .59327 L
.46322 .58597 L
.47356 .57575 L
.48293 .5643 L
.50392 .53098 L
.5232 .49108 L
.54404 .43867 L
.58509 .31362 L
.62463 .18358 L
.64453 .12361 L
.66266 .07702 L
.67202 .05706 L
.6822 .03924 L
.68779 .03134 L
.69296 .02533 L
.69789 .0208 L
.70045 .01893 L
.70313 .01732 L
.70548 .01623 L
.70671 .01577 L
.70804 .01537 L
.70926 .01508 L
.71036 .01489 L
.71148 .01477 L
.71253 .01472 L
.71376 .01473 L
.71506 .01483 L
.71617 .015 L
.71738 .01525 L
.7187 .01562 L
.7201 .01613 L
.72264 .01733 L
.72499 .01876 L
.72755 .02068 L
.73221 .02514 L
.74093 .03686 L
.75032 .05433 L
.76069 .07932 L
.78168 .14676 L
.82186 .31967 L
.86051 .49021 L
.88053 .5566 L
.8906 .5802 L
.8963 .59013 L
.89907 .59398 L
.90162 .59696 L
.90402 .59926 L
.90666 .6012 L
.90803 .60196 L
.90931 .60252 L
Mistroke
.91001 .60277 L
.91067 .60296 L
.91143 .60313 L
.91212 .60323 L
.91332 .60332 L
.91459 .60327 L
.91579 .60308 L
.91687 .60279 L
.91815 .60232 L
.91954 .60163 L
.92205 .59993 L
.9243 .59792 L
.92676 .59516 L
.93173 .58788 L
.93633 .5791 L
.94063 .56917 L
.95924 .50798 L
.97619 .4303 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell[TextData[{
  "Setting the ",
  StyleBox["AspectRatio", "MR"],
  " option changes the whole shape of your plot. ",
  StyleBox["AspectRatio", "MR"],
  " gives the ratio of width to height. Its default value is the inverse of \
the Golden Ratio\[LongDash]supposedly the most pleasing shape for a \
rectangle. "
}], "MathCaption",
  CellTags->{"S1.9.2", "2.10"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x^2], {x, 0, 3}, AspectRatio -> 1]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.499997 0.476196 [
[.18254 .4875 -9 -9 ]
[.18254 .4875 9 0 ]
[.34127 .4875 -3 -9 ]
[.34127 .4875 3 0 ]
[.5 .4875 -9 -9 ]
[.5 .4875 9 0 ]
[.65873 .4875 -3 -9 ]
[.65873 .4875 3 0 ]
[.81746 .4875 -9 -9 ]
[.81746 .4875 9 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.01131 .0238 -12 -4.5 ]
[.01131 .0238 0 4.5 ]
[.01131 .2619 -24 -4.5 ]
[.01131 .2619 0 4.5 ]
[.01131 .73809 -18 -4.5 ]
[.01131 .73809 0 4.5 ]
[.01131 .97619 -6 -4.5 ]
[.01131 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .5 m
.18254 .50625 L
s
[(0.5)] .18254 .4875 0 1 Mshowa
.34127 .5 m
.34127 .50625 L
s
[(1)] .34127 .4875 0 1 Mshowa
.5 .5 m
.5 .50625 L
s
[(1.5)] .5 .4875 0 1 Mshowa
.65873 .5 m
.65873 .50625 L
s
[(2)] .65873 .4875 0 1 Mshowa
.81746 .5 m
.81746 .50625 L
s
[(2.5)] .81746 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(3)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.05556 .5 m
.05556 .50375 L
s
.0873 .5 m
.0873 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.15079 .5 m
.15079 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.24603 .5 m
.24603 .50375 L
s
.27778 .5 m
.27778 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.37302 .5 m
.37302 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.43651 .5 m
.43651 .50375 L
s
.46825 .5 m
.46825 .50375 L
s
.53175 .5 m
.53175 .50375 L
s
.56349 .5 m
.56349 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.62698 .5 m
.62698 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.72222 .5 m
.72222 .50375 L
s
.75397 .5 m
.75397 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.84921 .5 m
.84921 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.9127 .5 m
.9127 .50375 L
s
.94444 .5 m
.94444 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.02381 .0238 m
.03006 .0238 L
s
[(-1)] .01131 .0238 1 0 Mshowa
.02381 .2619 m
.03006 .2619 L
s
[(-0.5)] .01131 .2619 1 0 Mshowa
.02381 .73809 m
.03006 .73809 L
s
[(0.5)] .01131 .73809 1 0 Mshowa
.02381 .97619 m
.03006 .97619 L
s
[(1)] .01131 .97619 1 0 Mshowa
.125 Mabswid
.02381 .07142 m
.02756 .07142 L
s
.02381 .11904 m
.02756 .11904 L
s
.02381 .16666 m
.02756 .16666 L
s
.02381 .21428 m
.02756 .21428 L
s
.02381 .30952 m
.02756 .30952 L
s
.02381 .35714 m
.02756 .35714 L
s
.02381 .40476 m
.02756 .40476 L
s
.02381 .45238 m
.02756 .45238 L
s
.02381 .54762 m
.02756 .54762 L
s
.02381 .59524 m
.02756 .59524 L
s
.02381 .64286 m
.02756 .64286 L
s
.02381 .69048 m
.02756 .69048 L
s
.02381 .78571 m
.02756 .78571 L
s
.02381 .83333 m
.02756 .83333 L
s
.02381 .88095 m
.02756 .88095 L
s
.02381 .92857 m
.02756 .92857 L
s
.25 Mabswid
.02381 0 m
.02381 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.02381 .5 m
.02499 .5 L
.02605 .50002 L
.02729 .50005 L
.02846 .5001 L
.03053 .50021 L
.03279 .50038 L
.03527 .50062 L
.0379 .50093 L
.04262 .50167 L
.04749 .50265 L
.05205 .50377 L
.06244 .50705 L
.07305 .51145 L
.08274 .51641 L
.10458 .5308 L
.12357 .54694 L
.14429 .56835 L
.18493 .62131 L
.22406 .68452 L
.26565 .76109 L
.30571 .83777 L
.34426 .9055 L
.36381 .93407 L
.37417 .94686 L
.38527 .95838 L
.39075 .96313 L
.39595 .96701 L
.40101 .97018 L
.40569 .97255 L
.41012 .97426 L
.41235 .97493 L
.41364 .97525 L
.41482 .9755 L
.416 .97572 L
.41729 .97591 L
.41858 .97605 L
.41929 .97611 L
.41994 .97615 L
.42116 .97619 L
.42227 .97619 L
.42355 .97614 L
.42475 .97605 L
.42591 .97593 L
.42715 .97574 L
.42938 .9753 L
.43204 .97456 L
.43448 .97369 L
.43975 .97113 L
.44477 .96784 L
Mistroke
.4536 .95994 L
.46322 .94812 L
.47356 .93158 L
.48293 .91306 L
.50392 .85914 L
.5232 .79458 L
.54404 .70978 L
.58509 .50744 L
.62463 .29704 L
.64453 .2 L
.66266 .12462 L
.67202 .09233 L
.6822 .06349 L
.68779 .05072 L
.69296 .04099 L
.69789 .03365 L
.70045 .03062 L
.70313 .02803 L
.70548 .02626 L
.70671 .02552 L
.70804 .02487 L
.70926 .02441 L
.71036 .0241 L
.71148 .0239 L
.71253 .02381 L
.71376 .02383 L
.71506 .024 L
.71617 .02426 L
.71738 .02468 L
.7187 .02528 L
.7201 .0261 L
.72264 .02803 L
.72499 .03035 L
.72755 .03346 L
.73221 .04067 L
.74093 .05964 L
.75032 .0879 L
.76069 .12834 L
.78168 .23746 L
.82186 .51724 L
.86051 .79318 L
.88053 .90059 L
.8906 .93878 L
.8963 .95485 L
.89907 .96108 L
.90162 .96591 L
.90402 .96962 L
.90666 .97276 L
.90803 .97399 L
.90931 .9749 L
Mistroke
.91001 .9753 L
.91067 .9756 L
.91143 .97588 L
.91212 .97605 L
.91332 .97619 L
.91459 .9761 L
.91579 .9758 L
.91687 .97534 L
.91815 .97457 L
.91954 .97346 L
.92205 .97071 L
.9243 .96745 L
.92676 .96299 L
.93173 .95121 L
.93633 .93701 L
.94063 .92094 L
.95924 .82192 L
.97619 .69625 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["use internal algorithms "]},
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["do not include this "]},
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["include everything "]},
          {Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["do this "]},
          {Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["do not do this "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.2"],

Cell["Some common settings for various options. ", "Caption",
  CellTags->"S1.9.2"],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " makes a plot, it tries to set the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " scales to include only the \[OpenCurlyDoubleQuote]interesting\
\[CloseCurlyDoubleQuote] parts of the plot. If your function increases very \
rapidly, or has singularities, the parts where it gets too large will be cut \
off. By specifying the option ",
  StyleBox["PlotRange", "MR"],
  ", you can control exactly what ranges of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " coordinates are included in your plot. "
}], "Text",
  CellTags->{"S1.9.2", "2.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], 
            Cell["\<\
show at least a large fraction of the points, including \
the \[OpenCurlyDoubleQuote]interesting\[CloseCurlyDoubleQuote] region (the \
default setting) \
\>"]},
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["show all points "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "show a specific range of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " values "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["xrange", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["yrange", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "show the specified ranges of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " values "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.2"],

Cell[TextData[{
  "Settings for the option ",
  StyleBox["PlotRange", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.9.2"],

Cell[TextData[{
  "The setting for the option ",
  StyleBox["PlotRange", "MR"],
  " gives explicit ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " limits for the graph. With the ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " limits specified here, the bottom of the curve is cut off. "
}], "MathCaption",
  CellTags->{"S1.9.2", "2.12"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x^2], {x, 0, 3}, PlotRange -> {0, 1.2}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 -2.18738e-17 0.515028 [
[.18254 -0.0125 -9 -9 ]
[.18254 -0.0125 9 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -9 -9 ]
[.5 -0.0125 9 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -9 -9 ]
[.81746 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[.01131 .10301 -18 -4.5 ]
[.01131 .10301 0 4.5 ]
[.01131 .20601 -18 -4.5 ]
[.01131 .20601 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .41202 -18 -4.5 ]
[.01131 .41202 0 4.5 ]
[.01131 .51503 -6 -4.5 ]
[.01131 .51503 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .00625 L
s
[(0.5)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(1)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1.5)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(2)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(2.5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(3)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .10301 m
.03006 .10301 L
s
[(0.2)] .01131 .10301 1 0 Mshowa
.02381 .20601 m
.03006 .20601 L
s
[(0.4)] .01131 .20601 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(0.6)] .01131 .30902 1 0 Mshowa
.02381 .41202 m
.03006 .41202 L
s
[(0.8)] .01131 .41202 1 0 Mshowa
.02381 .51503 m
.03006 .51503 L
s
[(1)] .01131 .51503 1 0 Mshowa
.125 Mabswid
.02381 .02575 m
.02756 .02575 L
s
.02381 .0515 m
.02756 .0515 L
s
.02381 .07725 m
.02756 .07725 L
s
.02381 .12876 m
.02756 .12876 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18026 m
.02756 .18026 L
s
.02381 .23176 m
.02756 .23176 L
s
.02381 .25751 m
.02756 .25751 L
s
.02381 .28327 m
.02756 .28327 L
s
.02381 .33477 m
.02756 .33477 L
s
.02381 .36052 m
.02756 .36052 L
s
.02381 .38627 m
.02756 .38627 L
s
.02381 .43777 m
.02756 .43777 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .48928 m
.02756 .48928 L
s
.02381 .54078 m
.02756 .54078 L
s
.02381 .56653 m
.02756 .56653 L
s
.02381 .59228 m
.02756 .59228 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.02499 1e-05 L
.02605 3e-05 L
.02729 6e-05 L
.02846 .00011 L
.03053 .00023 L
.03279 .00041 L
.03527 .00067 L
.0379 .00101 L
.04262 .00181 L
.04749 .00287 L
.05205 .00408 L
.06244 .00763 L
.07305 .01239 L
.08274 .01775 L
.10458 .03332 L
.12357 .05077 L
.14429 .07392 L
.18493 .13121 L
.22406 .19957 L
.26565 .28238 L
.30571 .36532 L
.34426 .43858 L
.36381 .46948 L
.37417 .4833 L
.38527 .49576 L
.39075 .5009 L
.39595 .5051 L
.40101 .50853 L
.40569 .51109 L
.41012 .51294 L
.41235 .51366 L
.41364 .51401 L
.41482 .51428 L
.416 .51452 L
.41729 .51472 L
.41858 .51487 L
.41929 .51494 L
.41994 .51498 L
.42116 .51502 L
.42227 .51502 L
.42355 .51497 L
.42475 .51488 L
.42591 .51474 L
.42715 .51454 L
.42938 .51406 L
.43204 .51326 L
.43448 .51232 L
.43975 .50956 L
.44477 .506 L
Mistroke
.4536 .49745 L
.46322 .48467 L
.47356 .46678 L
.48293 .44675 L
.50392 .38843 L
.5232 .31861 L
.54404 .22689 L
.58509 .00805 L
Mfstroke
.58509 .00805 m
.58649 0 L
s
.81938 0 m
.82186 .01865 L
.86051 .31709 L
.88053 .43326 L
.8906 .47457 L
.8963 .49195 L
.89907 .49869 L
.90162 .5039 L
.90402 .50792 L
.90666 .51131 L
.90803 .51265 L
.90931 .51363 L
.91001 .51406 L
.91067 .51439 L
.91143 .51469 L
.91212 .51488 L
.91332 .51503 L
.91459 .51493 L
.91579 .5146 L
.91687 .51411 L
.91815 .51328 L
.91954 .51207 L
.92205 .5091 L
.9243 .50557 L
.92676 .50075 L
.93173 .48801 L
.93633 .47265 L
.94063 .45527 L
.95924 .34818 L
.97619 .21225 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " always tries to plot functions as smooth curves. As a result, in places \
where your function wiggles a lot, ",
  StyleBox["Mathematica", "TI"],
  " will use more points. In general, ",
  StyleBox["Mathematica", "TI"],
  " tries to ",
  StyleBox["adapt", "TI"],
  " its sampling of your function to the form of the function. There is, \
however, a limit, which you can set, to how finely ",
  StyleBox["Mathematica", "TI"],
  " will ever sample a function.  "
}], "Text",
  CellTags->{"S1.9.2", "2.13"}],

Cell[TextData[{
  "The function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            FractionBox["1", 
              StyleBox["x",
                "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
  " wiggles infinitely often when ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "\[TildeEqual]", "0"}], TraditionalForm]], 
    "InlineFormula"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " tries to sample more points in the region where the function wiggles a \
lot, but it can never sample the infinite number that you would need to \
reproduce the function exactly. As a result, there are slight glitches in the \
plot. "
}], "MathCaption",
  CellTags->{"S1.9.2", "2.14"}],

Cell[CellGroupData[{

Cell["Plot[Sin[1/x], {x, -1, 1}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.9.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309017 0.294302 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .06137 m
.06244 .04831 L
.10458 .03426 L
.12507 .02792 L
.14415 .02264 L
.16254 .01846 L
.17284 .01667 L
.1773 .01605 L
.18221 .01549 L
.18704 .01507 L
.18969 .01491 L
.19096 .01485 L
.19216 .0148 L
.19327 .01476 L
.19448 .01474 L
.19557 .01472 L
.19659 .01472 L
.1978 .01472 L
.1989 .01473 L
.20016 .01476 L
.20135 .0148 L
.20256 .01485 L
.20388 .01492 L
.20655 .01511 L
.20903 .01535 L
.21134 .01563 L
.21655 .01647 L
.22214 .01772 L
.22742 .01927 L
.23231 .02106 L
.24338 .02657 L
.25313 .03339 L
.2635 .04308 L
.27287 .05446 L
.28297 .07006 L
.30125 .10934 L
.31082 .13695 L
.32129 .1739 L
.34239 .2737 L
.36364 .41009 L
.38295 .54435 L
.38763 .57079 L
.39019 .58278 L
.39259 .59193 L
.39394 .59606 L
.39518 .5991 L
.39583 .6004 L
.39655 .60156 L
.3973 .60248 L
.39802 .60305 L
Mistroke
.39928 .60328 L
.39999 .60297 L
.40062 .60239 L
.40187 .60044 L
.40303 .59754 L
.40414 .5938 L
.40535 .58852 L
.40778 .57383 L
.41004 .555 L
.41215 .53258 L
.4169 .46348 L
.422 .36128 L
.42694 .24048 L
.4322 .11062 L
.43493 .05589 L
.43569 .044 L
.43649 .03314 L
.43726 .02495 L
.43795 .01942 L
.43919 .01479 L
.4399 .01541 L
.44055 .01828 L
.44187 .03132 L
.44261 .04311 L
.44328 .05672 L
.44454 .09 L
.44587 .13606 L
.44825 .24401 L
.45104 .39617 L
.4524 .46996 L
.45364 .52944 L
.45479 .57242 L
.45588 .59737 L
.45704 .60217 L
.45829 .57746 L
.45958 .51702 L
.46023 .47331 L
.46095 .416 L
.46341 .18169 L
.46454 .08543 L
.46575 .02269 L
.46645 .01516 L
.46708 .03035 L
.46832 .12422 L
.46952 .28397 L
.4708 .47452 L
.47146 .55306 L
.47219 .59988 L
.47349 .5377 L
.47467 .32404 L
Mistroke
.47594 .07084 L
.47714 .03934 L
.47824 .27745 L
.47934 .56568 L
.48054 .48903 L
.48168 .08631 L
.48273 .11993 L
.48395 .59849 L
.48523 .09298 L
.4859 .10135 L
.48664 .56815 L
.48793 .01969 L
.48915 .33316 L
.49046 .40628 L
.4917 .09484 L
.49283 .42287 L
.49355 .60311 L
.49421 .13942 L
.49495 .31835 L
.49572 .59828 L
.49703 .30561 L
.49777 .32911 L
.49847 .19485 L
.49975 .4007 L
.50093 .05239 L
.50222 .53353 L
.50287 .4649 L
.50358 .56852 L
.5049 .37779 L
.50612 .50404 L
.50676 .59714 L
.50746 .56138 L
.50819 .60308 L
.50887 .23047 L
.51013 .34285 L
.51128 .02017 L
.51191 .53431 L
.51261 .3315 L
.51386 .37083 L
.51508 .35668 L
.51639 .1027 L
.51763 .58959 L
.51877 .37906 L
.5198 .04938 L
.52093 .10557 L
.52211 .4371 L
.52321 .60183 L
.52389 .56901 L
.52454 .46459 L
.52575 .20615 L
Mistroke
.52706 .02976 L
.52779 .01783 L
.52847 .05893 L
.52977 .22537 L
.5312 .43525 L
.53191 .51735 L
.53269 .57631 L
.53341 .60141 L
.53408 .59932 L
.53536 .53952 L
.53655 .44012 L
.53797 .30208 L
.53925 .18541 L
.54047 .09782 L
.54163 .0433 L
.54284 .0168 L
.54416 .02133 L
.549 .22398 L
.55138 .35516 L
.55359 .46001 L
.55479 .50613 L
.55612 .54663 L
.55746 .57605 L
.55819 .58748 L
.55888 .5953 L
.56009 .60258 L
.5612 .60254 L
.56242 .59593 L
.5637 .58251 L
.56502 .56283 L
.56644 .53656 L
.569 .47967 L
.57479 .33362 L
.58018 .20969 L
.58515 .12148 L
.58763 .0881 L
.59025 .06025 L
.59289 .03959 L
.59439 .03086 L
.59579 .02453 L
.59708 .02015 L
.59832 .01724 L
.59942 .01559 L
.60063 .01477 L
.60194 .01496 L
.60267 .01552 L
.60333 .0163 L
.60462 .0185 L
.60583 .02136 L
.60812 .02858 L
Mistroke
.61054 .03846 L
.61486 .06072 L
.62463 .12411 L
.64452 .26405 L
.66264 .37143 L
.68218 .45721 L
.69293 .49255 L
.7031 .51952 L
.71278 .54021 L
.72304 .55771 L
.73266 .57061 L
.74147 .57995 L
.75086 .58768 L
.76097 .59389 L
.76989 .59782 L
.77437 .59933 L
.77926 .60067 L
.78456 .60177 L
.78716 .60219 L
.78956 .60252 L
.7917 .60276 L
.79404 .60297 L
.79641 .60313 L
.7977 .6032 L
.7989 .60325 L
.8002 .60328 L
.80094 .6033 L
.80162 .60331 L
.80286 .60332 L
.80349 .60332 L
.80419 .60332 L
.80538 .6033 L
.80668 .60327 L
.80789 .60323 L
.80901 .60319 L
.81153 .60306 L
.8143 .60286 L
.81986 .60233 L
.82513 .60166 L
.83012 .6009 L
.83944 .59918 L
.86038 .59421 L
.8988 .58268 L
.93968 .569 L
.97619 .55666 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.9.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["PlotStyle", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              
              "a list of lists of graphics primitives to use for each curve \
(see Section ",
              ButtonBox["2.10.3",
                ButtonData:>{"2.10.3", "3.1"},
                ButtonStyle->"MainBookLink"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["PlotPoints", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["25", "MR"],
              " "
            }]], 
            Cell["\<\
the minimum number of points at which to sample the \
function \
\>"]},
          {Cell[TextData[{
              StyleBox["MaxBend", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["10.", "MR"],
              " "
            }]], 
            Cell["\<\
the maximum kink angle between successive segments of a \
curve \
\>"]},
          {Cell[TextData[{
              StyleBox["PlotDivision", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["30.", "MR"],
              " "
            }]], 
            Cell["\<\
the maximum factor by which to subdivide in sampling \
the function \
\>"]},
          {Cell[TextData[{
              StyleBox["Compiled", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to compile the function being plotted "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.9.2"],

Cell[TextData[{
  "More options for ",
  StyleBox["Plot", "MR"],
  ". These cannot be used in ",
  StyleBox["Show", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.9.2"],

Cell[TextData[{
  "It is important to realize that since ",
  StyleBox["Mathematica", "TI"],
  " can only sample your function at a limited number of points, it can \
always miss features of the function. By increasing ",
  StyleBox["PlotPoints", "MR"],
  ", you can make ",
  StyleBox["Mathematica", "TI"],
  " sample your function at a larger number of points. Of course, the larger \
you set ",
  StyleBox["PlotPoints", "MR"],
  " to be, the longer it will take ",
  StyleBox["Mathematica", "TI"],
  " to plot ",
  StyleBox["any", "TI"],
  " function, even a smooth one. "
}], "Text",
  CellTags->{"S1.9.2", "2.15"}],

Cell[TextData[{
  "Since ",
  StyleBox["Plot", "MR"],
  " needs to evaluate your function many times, it is important to make each \
evaluation as quick as possible. As a result, ",
  StyleBox["Mathematica", "TI"],
  " usually ",
  StyleBox["compiles", "TI"],
  " your function into a low\[Hyphen]level pseudocode that can be executed \
very efficiently. One potential problem with this, however, is that the \
pseudocode allows only machine\[Hyphen]precision numerical operations. If the \
function you are plotting requires higher\[Hyphen]precision operations, you \
may have to switch off compilation in ",
  StyleBox["Plot", "MR"],
  ". You can do this by setting the option ",
  StyleBox["Compiled", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  ". Note that ",
  StyleBox["Mathematica", "TI"],
  " can only compile \[OpenCurlyDoubleQuote]inline code\
\[CloseCurlyDoubleQuote]; it cannot for example compile functions that you \
have defined. As a result, you should, when possible, use ",
  StyleBox["Evaluate", "MR"],
  " as described in Section\[NonBreakingSpace]",
  ButtonBox["1.9.1",
    ButtonData:>{"1.9.1", "1.8"},
    ButtonStyle->"MainBookLink"],
  " to evaluate any such definitions and get a form that the ",
  StyleBox["Mathematica", "TI"],
  " compiler can handle. "
}], "Text",
  CellTags->{"S1.9.2", "2.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.9.3 Redrawing and Combining Plots", "Subsection",
  CellTags->{"S1.9.3", "3.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " saves information about every plot you produce, so that you can later \
redraw it. When you redraw plots, you can change some of the options you use. \
  "
}], "Text",
  CellTags->{"S1.9.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Show[", "MR"],
              StyleBox["plot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["redraw a plot "]},
          {Cell[TextData[{
              StyleBox["Show[", "MR"],
              StyleBox["plot", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["redraw with options changed "]},
          {Cell[TextData[{
              StyleBox["Show[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["combine several plots "]},
          {Cell[TextData[{
              StyleBox["Show[GraphicsArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["draw an array of plots "]},
          {Cell[TextData[{
              StyleBox["InputForm[", "MR"],
              StyleBox["plot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["show the information that is saved about a plot "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.3"],

Cell["Functions for manipulating plots. ", "Caption",
  CellTags->"S1.9.3"],

Cell[TextData[{
  "Here is a simple plot. ",
  StyleBox["-Graphics-", "MR"],
  " is usually printed on the output line to stand for the information that \
",
  StyleBox["Mathematica", "TI"],
  " saves about the plot. "
}], "MathCaption",
  CellTags->{"S1.9.3", "3.3"}],

Cell[CellGroupData[{

Cell["Plot[ChebyshevT[7, x], {x, -1, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309017 0.294302 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02846 .14477 L
.03279 .24781 L
.03793 .34961 L
.04262 .42447 L
.04754 .48677 L
.0522 .53175 L
.05711 .56613 L
.05988 .58016 L
.06244 .58997 L
.06487 .59664 L
.06623 .59934 L
.06747 .60118 L
.06862 .60237 L
.06988 .60312 L
.07107 .60332 L
.07218 .60307 L
.07285 .60273 L
.07358 .6022 L
.0749 .60081 L
.07618 .59896 L
.07737 .59684 L
.08006 .5906 L
.0829 .58203 L
.08824 .5611 L
.09323 .53678 L
.10458 .46916 L
.14349 .20513 L
.15366 .14714 L
.16473 .09477 L
.1698 .07495 L
.17518 .05693 L
.18022 .04294 L
.18485 .03259 L
.18941 .0247 L
.19171 .02161 L
.19422 .01889 L
.19675 .01684 L
.19817 .01599 L
.19945 .01541 L
.20065 .01503 L
.20196 .01478 L
.20319 .01472 L
.20432 .01479 L
.20537 .01498 L
.2065 .01531 L
.20757 .01574 L
.20855 .01624 L
.21093 .01785 L
.2132 .01989 L
Mistroke
.2177 .02541 L
.2226 .03352 L
.23294 .05732 L
.24231 .08579 L
.2633 .16793 L
.30342 .35669 L
.32183 .43894 L
.34202 .51482 L
.35167 .54391 L
.362 .56905 L
.36771 .5801 L
.3729 .58834 L
.37813 .59482 L
.38068 .59733 L
.38307 .59928 L
.38548 .60086 L
.38768 .60196 L
.38887 .60242 L
.39012 .60281 L
.39138 .60308 L
.39209 .60319 L
.39275 .60326 L
.3934 .60331 L
.39409 .60332 L
.39536 .60326 L
.39659 .6031 L
.39772 .60287 L
.39895 .60251 L
.4003 .60201 L
.40302 .60063 L
.40543 .59901 L
.40762 .59721 L
.41255 .59202 L
.42146 .57882 L
.43135 .55865 L
.44052 .53522 L
.46127 .46782 L
.5005 .30684 L
.53822 .15207 L
.55755 .0883 L
.5675 .06208 L
.57276 .05032 L
.57839 .03948 L
.58382 .0308 L
.58876 .02448 L
.59114 .02199 L
.59372 .01969 L
.59614 .01792 L
.59841 .01661 L
.59973 .01601 L
Mistroke
.60094 .01555 L
.60229 .01517 L
.60303 .015 L
.60374 .01488 L
.60441 .01479 L
.60514 .01474 L
.60643 .01472 L
.60723 .01477 L
.60798 .01485 L
.60865 .01496 L
.60938 .01511 L
.6106 .01544 L
.61194 .01591 L
.61465 .01725 L
.61716 .01892 L
.6195 .02087 L
.62451 .02626 L
.62996 .03402 L
.63987 .05304 L
.64951 .0774 L
.65843 .10469 L
.69772 .26666 L
.73549 .44476 L
.74571 .48797 L
.75647 .52813 L
.76644 .55904 L
.7713 .57152 L
.77571 .58122 L
.78 .58908 L
.78465 .59574 L
.78721 .59854 L
.78956 .60057 L
.79182 .60199 L
.79295 .60252 L
.7942 .60294 L
.79485 .6031 L
.79555 .60322 L
.79683 .60332 L
.79808 .60325 L
.79924 .60303 L
.79995 .60283 L
.80061 .6026 L
.80186 .60203 L
.8032 .60123 L
.80465 .60015 L
.80713 .59777 L
.80974 .59454 L
.81442 .58687 L
.8194 .57604 L
.82393 .56378 L
Mistroke
.83411 .52805 L
.85246 .43702 L
.87321 .30268 L
.89238 .16901 L
.902 .10792 L
.91102 .06028 L
.91554 .04149 L
.91787 .03348 L
.92042 .0262 L
.92186 .0228 L
.92319 .02015 L
.92457 .01792 L
.92583 .01639 L
.92706 .01536 L
.92822 .01482 L
.92945 .01474 L
.93014 .01493 L
.93078 .01524 L
.93204 .01629 L
.93323 .01782 L
.93431 .01967 L
.93547 .02219 L
.93809 .02987 L
.94051 .03964 L
.94491 .06454 L
.94959 .10209 L
.95466 .15713 L
.95941 .22406 L
.97025 .44082 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell["This redraws the plot from the previous line. ", "MathCaption",
  CellTags->{"S1.9.3", "3.4"}],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309017 0.294302 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02846 .14477 L
.03279 .24781 L
.03793 .34961 L
.04262 .42447 L
.04754 .48677 L
.0522 .53175 L
.05711 .56613 L
.05988 .58016 L
.06244 .58997 L
.06487 .59664 L
.06623 .59934 L
.06747 .60118 L
.06862 .60237 L
.06988 .60312 L
.07107 .60332 L
.07218 .60307 L
.07285 .60273 L
.07358 .6022 L
.0749 .60081 L
.07618 .59896 L
.07737 .59684 L
.08006 .5906 L
.0829 .58203 L
.08824 .5611 L
.09323 .53678 L
.10458 .46916 L
.14349 .20513 L
.15366 .14714 L
.16473 .09477 L
.1698 .07495 L
.17518 .05693 L
.18022 .04294 L
.18485 .03259 L
.18941 .0247 L
.19171 .02161 L
.19422 .01889 L
.19675 .01684 L
.19817 .01599 L
.19945 .01541 L
.20065 .01503 L
.20196 .01478 L
.20319 .01472 L
.20432 .01479 L
.20537 .01498 L
.2065 .01531 L
.20757 .01574 L
.20855 .01624 L
.21093 .01785 L
.2132 .01989 L
Mistroke
.2177 .02541 L
.2226 .03352 L
.23294 .05732 L
.24231 .08579 L
.2633 .16793 L
.30342 .35669 L
.32183 .43894 L
.34202 .51482 L
.35167 .54391 L
.362 .56905 L
.36771 .5801 L
.3729 .58834 L
.37813 .59482 L
.38068 .59733 L
.38307 .59928 L
.38548 .60086 L
.38768 .60196 L
.38887 .60242 L
.39012 .60281 L
.39138 .60308 L
.39209 .60319 L
.39275 .60326 L
.3934 .60331 L
.39409 .60332 L
.39536 .60326 L
.39659 .6031 L
.39772 .60287 L
.39895 .60251 L
.4003 .60201 L
.40302 .60063 L
.40543 .59901 L
.40762 .59721 L
.41255 .59202 L
.42146 .57882 L
.43135 .55865 L
.44052 .53522 L
.46127 .46782 L
.5005 .30684 L
.53822 .15207 L
.55755 .0883 L
.5675 .06208 L
.57276 .05032 L
.57839 .03948 L
.58382 .0308 L
.58876 .02448 L
.59114 .02199 L
.59372 .01969 L
.59614 .01792 L
.59841 .01661 L
.59973 .01601 L
Mistroke
.60094 .01555 L
.60229 .01517 L
.60303 .015 L
.60374 .01488 L
.60441 .01479 L
.60514 .01474 L
.60643 .01472 L
.60723 .01477 L
.60798 .01485 L
.60865 .01496 L
.60938 .01511 L
.6106 .01544 L
.61194 .01591 L
.61465 .01725 L
.61716 .01892 L
.6195 .02087 L
.62451 .02626 L
.62996 .03402 L
.63987 .05304 L
.64951 .0774 L
.65843 .10469 L
.69772 .26666 L
.73549 .44476 L
.74571 .48797 L
.75647 .52813 L
.76644 .55904 L
.7713 .57152 L
.77571 .58122 L
.78 .58908 L
.78465 .59574 L
.78721 .59854 L
.78956 .60057 L
.79182 .60199 L
.79295 .60252 L
.7942 .60294 L
.79485 .6031 L
.79555 .60322 L
.79683 .60332 L
.79808 .60325 L
.79924 .60303 L
.79995 .60283 L
.80061 .6026 L
.80186 .60203 L
.8032 .60123 L
.80465 .60015 L
.80713 .59777 L
.80974 .59454 L
.81442 .58687 L
.8194 .57604 L
.82393 .56378 L
Mistroke
.83411 .52805 L
.85246 .43702 L
.87321 .30268 L
.89238 .16901 L
.902 .10792 L
.91102 .06028 L
.91554 .04149 L
.91787 .03348 L
.92042 .0262 L
.92186 .0228 L
.92319 .02015 L
.92457 .01792 L
.92583 .01639 L
.92706 .01536 L
.92822 .01482 L
.92945 .01474 L
.93014 .01493 L
.93078 .01524 L
.93204 .01629 L
.93323 .01782 L
.93431 .01967 L
.93547 .02219 L
.93809 .02987 L
.94051 .03964 L
.94491 .06454 L
.94959 .10209 L
.95466 .15713 L
.95941 .22406 L
.97025 .44082 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "When you redraw the plot, you can change some of the options. This changes \
the choice of ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " scale. "
}], "MathCaption",
  CellTags->{"S1.9.3", "3.5"}],

Cell[CellGroupData[{

Cell["Show[%, PlotRange -> {-1, 2}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.206011 0.206011 [
[.02381 .19351 -6 -9 ]
[.02381 .19351 6 0 ]
[.2619 .19351 -12 -9 ]
[.2619 .19351 12 0 ]
[.7381 .19351 -9 -9 ]
[.7381 .19351 9 0 ]
[.97619 .19351 -3 -9 ]
[.97619 .19351 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .10301 -24 -4.5 ]
[.4875 .10301 0 4.5 ]
[.4875 .30902 -18 -4.5 ]
[.4875 .30902 0 4.5 ]
[.4875 .41202 -6 -4.5 ]
[.4875 .41202 0 4.5 ]
[.4875 .51503 -18 -4.5 ]
[.4875 .51503 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .20601 m
.02381 .21226 L
s
[(-1)] .02381 .19351 0 1 Mshowa
.2619 .20601 m
.2619 .21226 L
s
[(-0.5)] .2619 .19351 0 1 Mshowa
.7381 .20601 m
.7381 .21226 L
s
[(0.5)] .7381 .19351 0 1 Mshowa
.97619 .20601 m
.97619 .21226 L
s
[(1)] .97619 .19351 0 1 Mshowa
.125 Mabswid
.07143 .20601 m
.07143 .20976 L
s
.11905 .20601 m
.11905 .20976 L
s
.16667 .20601 m
.16667 .20976 L
s
.21429 .20601 m
.21429 .20976 L
s
.30952 .20601 m
.30952 .20976 L
s
.35714 .20601 m
.35714 .20976 L
s
.40476 .20601 m
.40476 .20976 L
s
.45238 .20601 m
.45238 .20976 L
s
.54762 .20601 m
.54762 .20976 L
s
.59524 .20601 m
.59524 .20976 L
s
.64286 .20601 m
.64286 .20976 L
s
.69048 .20601 m
.69048 .20976 L
s
.78571 .20601 m
.78571 .20976 L
s
.83333 .20601 m
.83333 .20976 L
s
.88095 .20601 m
.88095 .20976 L
s
.92857 .20601 m
.92857 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .10301 m
.50625 .10301 L
s
[(-0.5)] .4875 .10301 1 0 Mshowa
.5 .30902 m
.50625 .30902 L
s
[(0.5)] .4875 .30902 1 0 Mshowa
.5 .41202 m
.50625 .41202 L
s
[(1)] .4875 .41202 1 0 Mshowa
.5 .51503 m
.50625 .51503 L
s
[(1.5)] .4875 .51503 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .0206 m
.50375 .0206 L
s
.5 .0412 m
.50375 .0412 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .0824 m
.50375 .0824 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .16481 m
.50375 .16481 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .22661 m
.50375 .22661 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26781 m
.50375 .26781 L
s
.5 .28842 m
.50375 .28842 L
s
.5 .32962 m
.50375 .32962 L
s
.5 .35022 m
.50375 .35022 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .39142 m
.50375 .39142 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .45322 m
.50375 .45322 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .53563 m
.50375 .53563 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57683 m
.50375 .57683 L
s
.5 .59743 m
.50375 .59743 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.02846 .09104 L
.03279 .16317 L
.03793 .23442 L
.04262 .28683 L
.04754 .33044 L
.0522 .36192 L
.05711 .38599 L
.05988 .39581 L
.06244 .40268 L
.06487 .40734 L
.06623 .40924 L
.06747 .41052 L
.06862 .41136 L
.06988 .41188 L
.07107 .41202 L
.07218 .41185 L
.07285 .41161 L
.07358 .41124 L
.0749 .41027 L
.07618 .40897 L
.07737 .40749 L
.08006 .40312 L
.0829 .39712 L
.08824 .38247 L
.09323 .36545 L
.10458 .31811 L
.14349 .13329 L
.15366 .09269 L
.16473 .05604 L
.1698 .04217 L
.17518 .02955 L
.18022 .01975 L
.18485 .01251 L
.18941 .00699 L
.19171 .00483 L
.19422 .00292 L
.19675 .00149 L
.19817 .0009 L
.19945 .00049 L
.20065 .00022 L
.20196 5e-05 L
.20319 0 L
.20432 5e-05 L
.20537 .00019 L
.2065 .00042 L
.20757 .00072 L
.20855 .00107 L
.21093 .00219 L
.2132 .00363 L
Mistroke
.2177 .00748 L
.2226 .01317 L
.23294 .02982 L
.24231 .04975 L
.2633 .10725 L
.30342 .23938 L
.32183 .29695 L
.34202 .35007 L
.35167 .37044 L
.362 .38804 L
.36771 .39577 L
.3729 .40154 L
.37813 .40608 L
.38068 .40783 L
.38307 .4092 L
.38548 .4103 L
.38768 .41107 L
.38887 .4114 L
.39012 .41166 L
.39138 .41186 L
.39209 .41193 L
.39275 .41198 L
.3934 .41201 L
.39409 .41202 L
.39536 .41198 L
.39659 .41187 L
.39772 .41171 L
.39895 .41146 L
.4003 .41111 L
.40302 .41014 L
.40543 .40901 L
.40762 .40774 L
.41255 .40411 L
.42146 .39487 L
.43135 .38076 L
.44052 .36436 L
.46127 .31718 L
.5005 .20449 L
.53822 .09615 L
.55755 .05151 L
.5675 .03315 L
.57276 .02492 L
.57839 .01733 L
.58382 .01126 L
.58876 .00684 L
.59114 .00509 L
.59372 .00348 L
.59614 .00224 L
.59841 .00133 L
.59973 .00091 L
Mistroke
.60094 .00059 L
.60229 .00032 L
.60303 .0002 L
.60374 .00012 L
.60441 6e-05 L
.60514 2e-05 L
.60643 1e-05 L
.60723 4e-05 L
.60798 .0001 L
.60865 .00017 L
.60938 .00027 L
.6106 .0005 L
.61194 .00084 L
.61465 .00177 L
.61716 .00295 L
.6195 .00431 L
.62451 .00808 L
.62996 .01351 L
.63987 .02683 L
.64951 .04388 L
.65843 .06298 L
.69772 .17636 L
.73549 .30103 L
.74571 .33128 L
.75647 .35939 L
.76644 .38103 L
.7713 .38976 L
.77571 .39656 L
.78 .40206 L
.78465 .40672 L
.78721 .40868 L
.78956 .4101 L
.79182 .41109 L
.79295 .41146 L
.7942 .41176 L
.79485 .41187 L
.79555 .41196 L
.79683 .41202 L
.79808 .41197 L
.79924 .41182 L
.79995 .41168 L
.80061 .41152 L
.80186 .41112 L
.8032 .41056 L
.80465 .4098 L
.80713 .40814 L
.80974 .40588 L
.81442 .40051 L
.8194 .39292 L
.82393 .38434 L
Mistroke
.83411 .35934 L
.85246 .29561 L
.87321 .20157 L
.89238 .10801 L
.902 .06524 L
.91102 .0319 L
.91554 .01874 L
.91787 .01314 L
.92042 .00804 L
.92186 .00566 L
.92319 .0038 L
.92457 .00225 L
.92583 .00118 L
.92706 .00045 L
.92822 8e-05 L
.92945 2e-05 L
.93014 .00015 L
.93078 .00037 L
.93204 .0011 L
.93323 .00218 L
.93431 .00347 L
.93547 .00523 L
.93809 .01061 L
.94051 .01745 L
.94491 .03488 L
.94959 .06116 L
.95466 .09969 L
.95941 .14654 L
.97025 .29828 L
.97619 .41202 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell["\<\
This takes the plot from the previous line, and changes another \
option in it. \
\>", "MathCaption",
  CellTags->{"S1.9.3", "3.6"}],

Cell[CellGroupData[{

Cell["Show[%, PlotLabel -> \"A Chebyshev Polynomial\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.206011 0.206011 [
[.02381 .19351 -6 -9 ]
[.02381 .19351 6 0 ]
[.2619 .19351 -12 -9 ]
[.2619 .19351 12 0 ]
[.7381 .19351 -9 -9 ]
[.7381 .19351 9 0 ]
[.97619 .19351 -3 -9 ]
[.97619 .19351 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .10301 -24 -4.5 ]
[.4875 .10301 0 4.5 ]
[.4875 .30902 -18 -4.5 ]
[.4875 .30902 0 4.5 ]
[.4875 .41202 -6 -4.5 ]
[.4875 .41202 0 4.5 ]
[.4875 .51503 -18 -4.5 ]
[.4875 .51503 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -68 0 ]
[.5 .63053 68 10.125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .20601 m
.02381 .21226 L
s
[(-1)] .02381 .19351 0 1 Mshowa
.2619 .20601 m
.2619 .21226 L
s
[(-0.5)] .2619 .19351 0 1 Mshowa
.7381 .20601 m
.7381 .21226 L
s
[(0.5)] .7381 .19351 0 1 Mshowa
.97619 .20601 m
.97619 .21226 L
s
[(1)] .97619 .19351 0 1 Mshowa
.125 Mabswid
.07143 .20601 m
.07143 .20976 L
s
.11905 .20601 m
.11905 .20976 L
s
.16667 .20601 m
.16667 .20976 L
s
.21429 .20601 m
.21429 .20976 L
s
.30952 .20601 m
.30952 .20976 L
s
.35714 .20601 m
.35714 .20976 L
s
.40476 .20601 m
.40476 .20976 L
s
.45238 .20601 m
.45238 .20976 L
s
.54762 .20601 m
.54762 .20976 L
s
.59524 .20601 m
.59524 .20976 L
s
.64286 .20601 m
.64286 .20976 L
s
.69048 .20601 m
.69048 .20976 L
s
.78571 .20601 m
.78571 .20976 L
s
.83333 .20601 m
.83333 .20976 L
s
.88095 .20601 m
.88095 .20976 L
s
.92857 .20601 m
.92857 .20976 L
s
.25 Mabswid
0 .20601 m
1 .20601 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .10301 m
.50625 .10301 L
s
[(-0.5)] .4875 .10301 1 0 Mshowa
.5 .30902 m
.50625 .30902 L
s
[(0.5)] .4875 .30902 1 0 Mshowa
.5 .41202 m
.50625 .41202 L
s
[(1)] .4875 .41202 1 0 Mshowa
.5 .51503 m
.50625 .51503 L
s
[(1.5)] .4875 .51503 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .0206 m
.50375 .0206 L
s
.5 .0412 m
.50375 .0412 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .0824 m
.50375 .0824 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .16481 m
.50375 .16481 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .22661 m
.50375 .22661 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26781 m
.50375 .26781 L
s
.5 .28842 m
.50375 .28842 L
s
.5 .32962 m
.50375 .32962 L
s
.5 .35022 m
.50375 .35022 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .39142 m
.50375 .39142 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .45322 m
.50375 .45322 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .53563 m
.50375 .53563 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57683 m
.50375 .57683 L
s
.5 .59743 m
.50375 .59743 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -129 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
75.000 11.562 moveto
(Chebyshev) show
135.000 11.562 moveto
(Polynomial) show
195.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.02846 .09104 L
.03279 .16317 L
.03793 .23442 L
.04262 .28683 L
.04754 .33044 L
.0522 .36192 L
.05711 .38599 L
.05988 .39581 L
.06244 .40268 L
.06487 .40734 L
.06623 .40924 L
.06747 .41052 L
.06862 .41136 L
.06988 .41188 L
.07107 .41202 L
.07218 .41185 L
.07285 .41161 L
.07358 .41124 L
.0749 .41027 L
.07618 .40897 L
.07737 .40749 L
.08006 .40312 L
.0829 .39712 L
.08824 .38247 L
.09323 .36545 L
.10458 .31811 L
.14349 .13329 L
.15366 .09269 L
.16473 .05604 L
.1698 .04217 L
.17518 .02955 L
.18022 .01975 L
.18485 .01251 L
.18941 .00699 L
.19171 .00483 L
.19422 .00292 L
.19675 .00149 L
.19817 .0009 L
.19945 .00049 L
.20065 .00022 L
.20196 5e-05 L
.20319 0 L
.20432 5e-05 L
.20537 .00019 L
.2065 .00042 L
.20757 .00072 L
.20855 .00107 L
.21093 .00219 L
.2132 .00363 L
Mistroke
.2177 .00748 L
.2226 .01317 L
.23294 .02982 L
.24231 .04975 L
.2633 .10725 L
.30342 .23938 L
.32183 .29695 L
.34202 .35007 L
.35167 .37044 L
.362 .38804 L
.36771 .39577 L
.3729 .40154 L
.37813 .40608 L
.38068 .40783 L
.38307 .4092 L
.38548 .4103 L
.38768 .41107 L
.38887 .4114 L
.39012 .41166 L
.39138 .41186 L
.39209 .41193 L
.39275 .41198 L
.3934 .41201 L
.39409 .41202 L
.39536 .41198 L
.39659 .41187 L
.39772 .41171 L
.39895 .41146 L
.4003 .41111 L
.40302 .41014 L
.40543 .40901 L
.40762 .40774 L
.41255 .40411 L
.42146 .39487 L
.43135 .38076 L
.44052 .36436 L
.46127 .31718 L
.5005 .20449 L
.53822 .09615 L
.55755 .05151 L
.5675 .03315 L
.57276 .02492 L
.57839 .01733 L
.58382 .01126 L
.58876 .00684 L
.59114 .00509 L
.59372 .00348 L
.59614 .00224 L
.59841 .00133 L
.59973 .00091 L
Mistroke
.60094 .00059 L
.60229 .00032 L
.60303 .0002 L
.60374 .00012 L
.60441 6e-05 L
.60514 2e-05 L
.60643 1e-05 L
.60723 4e-05 L
.60798 .0001 L
.60865 .00017 L
.60938 .00027 L
.6106 .0005 L
.61194 .00084 L
.61465 .00177 L
.61716 .00295 L
.6195 .00431 L
.62451 .00808 L
.62996 .01351 L
.63987 .02683 L
.64951 .04388 L
.65843 .06298 L
.69772 .17636 L
.73549 .30103 L
.74571 .33128 L
.75647 .35939 L
.76644 .38103 L
.7713 .38976 L
.77571 .39656 L
.78 .40206 L
.78465 .40672 L
.78721 .40868 L
.78956 .4101 L
.79182 .41109 L
.79295 .41146 L
.7942 .41176 L
.79485 .41187 L
.79555 .41196 L
.79683 .41202 L
.79808 .41197 L
.79924 .41182 L
.79995 .41168 L
.80061 .41152 L
.80186 .41112 L
.8032 .41056 L
.80465 .4098 L
.80713 .40814 L
.80974 .40588 L
.81442 .40051 L
.8194 .39292 L
.82393 .38434 L
Mistroke
.83411 .35934 L
.85246 .29561 L
.87321 .20157 L
.89238 .10801 L
.902 .06524 L
.91102 .0319 L
.91554 .01874 L
.91787 .01314 L
.92042 .00804 L
.92186 .00566 L
.92319 .0038 L
.92457 .00225 L
.92583 .00118 L
.92706 .00045 L
.92822 8e-05 L
.92945 2e-05 L
.93014 .00015 L
.93078 .00037 L
.93204 .0011 L
.93323 .00218 L
.93431 .00347 L
.93547 .00523 L
.93809 .01061 L
.94051 .01745 L
.94491 .03488 L
.94959 .06116 L
.95466 .09969 L
.95941 .14654 L
.97025 .29828 L
.97619 .41202 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "By using ",
  StyleBox["Show", "MR"],
  " with a sequence of different options, you can look at the same plot in \
many different ways. You may want to do this, for example, if you are trying \
to find the best possible setting of options. "
}], "Text",
  CellTags->{"S1.9.3", "3.7"}],

Cell[TextData[{
  "You can also use ",
  StyleBox["Show", "MR"],
  " to combine plots. It does not matter whether the plots have the same \
scales: ",
  StyleBox["Mathematica", "TI"],
  " will always choose new scales to include the points you want. "
}], "Text",
  CellTags->{"S1.9.3", "3.8"}],

Cell[TextData[{
  "This sets ",
  StyleBox["gj0", "MR"],
  " to be a plot of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["J",
              "TI"], "0"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " from ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`10\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.3", "3.9"}],

Cell[CellGroupData[{

Cell["gj0 = Plot[BesselJ[0, x], {x, 0, 10}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.183713 0.419605 [
[.21429 .17121 -3 -9 ]
[.21429 .17121 3 0 ]
[.40476 .17121 -3 -9 ]
[.40476 .17121 3 0 ]
[.59524 .17121 -3 -9 ]
[.59524 .17121 3 0 ]
[.78571 .17121 -3 -9 ]
[.78571 .17121 3 0 ]
[.97619 .17121 -6 -9 ]
[.97619 .17121 6 0 ]
[.01131 .01587 -24 -4.5 ]
[.01131 .01587 0 4.5 ]
[.01131 .09979 -24 -4.5 ]
[.01131 .09979 0 4.5 ]
[.01131 .26763 -18 -4.5 ]
[.01131 .26763 0 4.5 ]
[.01131 .35156 -18 -4.5 ]
[.01131 .35156 0 4.5 ]
[.01131 .43548 -18 -4.5 ]
[.01131 .43548 0 4.5 ]
[.01131 .5194 -18 -4.5 ]
[.01131 .5194 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .18371 m
.21429 .18996 L
s
[(2)] .21429 .17121 0 1 Mshowa
.40476 .18371 m
.40476 .18996 L
s
[(4)] .40476 .17121 0 1 Mshowa
.59524 .18371 m
.59524 .18996 L
s
[(6)] .59524 .17121 0 1 Mshowa
.78571 .18371 m
.78571 .18996 L
s
[(8)] .78571 .17121 0 1 Mshowa
.97619 .18371 m
.97619 .18996 L
s
[(10)] .97619 .17121 0 1 Mshowa
.125 Mabswid
.07143 .18371 m
.07143 .18746 L
s
.11905 .18371 m
.11905 .18746 L
s
.16667 .18371 m
.16667 .18746 L
s
.2619 .18371 m
.2619 .18746 L
s
.30952 .18371 m
.30952 .18746 L
s
.35714 .18371 m
.35714 .18746 L
s
.45238 .18371 m
.45238 .18746 L
s
.5 .18371 m
.5 .18746 L
s
.54762 .18371 m
.54762 .18746 L
s
.64286 .18371 m
.64286 .18746 L
s
.69048 .18371 m
.69048 .18746 L
s
.7381 .18371 m
.7381 .18746 L
s
.83333 .18371 m
.83333 .18746 L
s
.88095 .18371 m
.88095 .18746 L
s
.92857 .18371 m
.92857 .18746 L
s
.25 Mabswid
0 .18371 m
1 .18371 L
s
.02381 .01587 m
.03006 .01587 L
s
[(-0.4)] .01131 .01587 1 0 Mshowa
.02381 .09979 m
.03006 .09979 L
s
[(-0.2)] .01131 .09979 1 0 Mshowa
.02381 .26763 m
.03006 .26763 L
s
[(0.2)] .01131 .26763 1 0 Mshowa
.02381 .35156 m
.03006 .35156 L
s
[(0.4)] .01131 .35156 1 0 Mshowa
.02381 .43548 m
.03006 .43548 L
s
[(0.6)] .01131 .43548 1 0 Mshowa
.02381 .5194 m
.03006 .5194 L
s
[(0.8)] .01131 .5194 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03685 m
.02756 .03685 L
s
.02381 .05783 m
.02756 .05783 L
s
.02381 .07881 m
.02756 .07881 L
s
.02381 .12077 m
.02756 .12077 L
s
.02381 .14175 m
.02756 .14175 L
s
.02381 .16273 m
.02756 .16273 L
s
.02381 .20469 m
.02756 .20469 L
s
.02381 .22567 m
.02756 .22567 L
s
.02381 .24665 m
.02756 .24665 L
s
.02381 .28861 m
.02756 .28861 L
s
.02381 .3096 m
.02756 .3096 L
s
.02381 .33058 m
.02756 .33058 L
s
.02381 .37254 m
.02756 .37254 L
s
.02381 .39352 m
.02756 .39352 L
s
.02381 .4145 m
.02756 .4145 L
s
.02381 .45646 m
.02756 .45646 L
s
.02381 .47744 m
.02756 .47744 L
s
.02381 .49842 m
.02756 .49842 L
s
.02381 .54038 m
.02756 .54038 L
s
.02381 .56136 m
.02756 .56136 L
s
.02381 .58234 m
.02756 .58234 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60326 L
.02729 .60318 L
.02846 .60307 L
.03053 .6028 L
.03279 .60239 L
.03527 .6018 L
.0379 .60103 L
.04262 .59924 L
.04749 .59686 L
.05205 .59414 L
.06244 .58623 L
.07305 .57575 L
.08274 .5641 L
.10458 .53119 L
.14429 .45151 L
.18248 .35892 L
.22313 .25533 L
.26226 .16264 L
.28223 .12146 L
.30384 .08336 L
.32471 .05395 L
.33464 .04272 L
.34391 .03392 L
.35375 .02637 L
.36273 .02113 L
.36785 .01884 L
.3727 .01714 L
.37518 .01644 L
.37782 .01583 L
.3792 .01557 L
.38072 .01532 L
.3821 .01513 L
.38339 .01498 L
.38453 .01488 L
.38574 .0148 L
.38643 .01476 L
.38709 .01474 L
.38831 .01472 L
.3896 .01472 L
.39079 .01475 L
.3921 .01482 L
.39276 .01486 L
.39349 .01492 L
.39579 .01517 L
.39827 .01555 L
.40274 .01651 L
.40833 .01822 L
.41364 .02033 L
Mistroke
.4236 .02558 L
.43321 .03214 L
.44344 .04062 L
.46184 .05938 L
.50348 .11424 L
.54359 .17477 L
.5822 .2303 L
.60178 .2547 L
.62325 .27711 L
.63313 .28565 L
.64371 .29343 L
.65363 .29938 L
.66279 .3037 L
.66764 .30551 L
.67299 .30713 L
.67837 .30835 L
.68131 .30885 L
.68407 .30921 L
.68654 .30944 L
.68778 .30952 L
.68849 .30956 L
.68913 .30959 L
.6903 .30962 L
.69154 .30964 L
.69268 .30964 L
.69377 .30962 L
.69504 .30958 L
.69567 .30955 L
.69638 .30951 L
.69878 .30932 L
.70013 .30918 L
.70158 .309 L
.70421 .30861 L
.70948 .30754 L
.71436 .30621 L
.72542 .30208 L
.73517 .29717 L
.74553 .29073 L
.78325 .25826 L
.82342 .21319 L
.86208 .16705 L
.90319 .12332 L
.92369 .10592 L
.94278 .09326 L
.95893 .08554 L
.96797 .08248 L
.97619 .08052 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "Here is a plot of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["Y",
              "TI"], "1"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  " from ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  " to\[NonBreakingSpace]",
  Cell[BoxData[
      \(TraditionalForm\`10\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.3", "3.10"}],

Cell[CellGroupData[{

Cell["gy1 = Plot[BesselY[1, x], {x, 1, 10}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.398561 0.491346 [
[.21429 .38606 -3 -9 ]
[.21429 .38606 3 0 ]
[.40476 .38606 -3 -9 ]
[.40476 .38606 3 0 ]
[.59524 .38606 -3 -9 ]
[.59524 .38606 3 0 ]
[.78571 .38606 -3 -9 ]
[.78571 .38606 3 0 ]
[.97619 .38606 -6 -9 ]
[.97619 .38606 6 0 ]
[.01131 .00548 -24 -4.5 ]
[.01131 .00548 0 4.5 ]
[.01131 .10375 -24 -4.5 ]
[.01131 .10375 0 4.5 ]
[.01131 .20202 -24 -4.5 ]
[.01131 .20202 0 4.5 ]
[.01131 .30029 -24 -4.5 ]
[.01131 .30029 0 4.5 ]
[.01131 .49683 -18 -4.5 ]
[.01131 .49683 0 4.5 ]
[.01131 .5951 -18 -4.5 ]
[.01131 .5951 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .39856 m
.21429 .40481 L
s
[(2)] .21429 .38606 0 1 Mshowa
.40476 .39856 m
.40476 .40481 L
s
[(4)] .40476 .38606 0 1 Mshowa
.59524 .39856 m
.59524 .40481 L
s
[(6)] .59524 .38606 0 1 Mshowa
.78571 .39856 m
.78571 .40481 L
s
[(8)] .78571 .38606 0 1 Mshowa
.97619 .39856 m
.97619 .40481 L
s
[(10)] .97619 .38606 0 1 Mshowa
.125 Mabswid
.07143 .39856 m
.07143 .40231 L
s
.11905 .39856 m
.11905 .40231 L
s
.16667 .39856 m
.16667 .40231 L
s
.2619 .39856 m
.2619 .40231 L
s
.30952 .39856 m
.30952 .40231 L
s
.35714 .39856 m
.35714 .40231 L
s
.45238 .39856 m
.45238 .40231 L
s
.5 .39856 m
.5 .40231 L
s
.54762 .39856 m
.54762 .40231 L
s
.64286 .39856 m
.64286 .40231 L
s
.69048 .39856 m
.69048 .40231 L
s
.7381 .39856 m
.7381 .40231 L
s
.83333 .39856 m
.83333 .40231 L
s
.88095 .39856 m
.88095 .40231 L
s
.92857 .39856 m
.92857 .40231 L
s
.25 Mabswid
0 .39856 m
1 .39856 L
s
.02381 .00548 m
.03006 .00548 L
s
[(-0.8)] .01131 .00548 1 0 Mshowa
.02381 .10375 m
.03006 .10375 L
s
[(-0.6)] .01131 .10375 1 0 Mshowa
.02381 .20202 m
.03006 .20202 L
s
[(-0.4)] .01131 .20202 1 0 Mshowa
.02381 .30029 m
.03006 .30029 L
s
[(-0.2)] .01131 .30029 1 0 Mshowa
.02381 .49683 m
.03006 .49683 L
s
[(0.2)] .01131 .49683 1 0 Mshowa
.02381 .5951 m
.03006 .5951 L
s
[(0.4)] .01131 .5951 1 0 Mshowa
.125 Mabswid
.02381 .03005 m
.02756 .03005 L
s
.02381 .05462 m
.02756 .05462 L
s
.02381 .07919 m
.02756 .07919 L
s
.02381 .12832 m
.02756 .12832 L
s
.02381 .15289 m
.02756 .15289 L
s
.02381 .17745 m
.02756 .17745 L
s
.02381 .22659 m
.02756 .22659 L
s
.02381 .25116 m
.02756 .25116 L
s
.02381 .27572 m
.02756 .27572 L
s
.02381 .32486 m
.02756 .32486 L
s
.02381 .34943 m
.02756 .34943 L
s
.02381 .37399 m
.02756 .37399 L
s
.02381 .42313 m
.02756 .42313 L
s
.02381 .4477 m
.02756 .4477 L
s
.02381 .47226 m
.02756 .47226 L
s
.02381 .5214 m
.02756 .5214 L
s
.02381 .54596 m
.02756 .54596 L
s
.02381 .57053 m
.02756 .57053 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .01472 m
.15382 .15139 L
.19174 .27775 L
.22736 .38303 L
.26161 .46958 L
.2807 .50991 L
.29806 .54088 L
.31631 .56702 L
.33316 .58501 L
.34152 .59168 L
.35039 .59711 L
.35499 .59926 L
.35929 .60085 L
.36401 .60214 L
.36667 .60266 L
.36792 .60285 L
.36909 .603 L
.37018 .60312 L
.37134 .60321 L
.37241 .60327 L
.37338 .6033 L
.37444 .60332 L
.37561 .60331 L
.37619 .60329 L
.37682 .60327 L
.37796 .6032 L
.37901 .60311 L
.38016 .60299 L
.38226 .60271 L
.3843 .60234 L
.38618 .60192 L
.39048 .60071 L
.39522 .59895 L
.40483 .59404 L
.41392 .58781 L
.42224 .58083 L
.44102 .56096 L
.47668 .51041 L
.51097 .45187 L
.54748 .38713 L
.58262 .33031 L
.60054 .30565 L
.61997 .28334 L
.62906 .27468 L
.63869 .26684 L
.64771 .26079 L
.65595 .25638 L
.66444 .25298 L
.66913 .25161 L
.67128 .2511 L
Mistroke
.67357 .25064 L
.67572 .25028 L
.67766 .25002 L
.6786 .24992 L
.67962 .24982 L
.68057 .24975 L
.68145 .24969 L
.68249 .24964 L
.68363 .24961 L
.68474 .2496 L
.68593 .24961 L
.68704 .24963 L
.68809 .24968 L
.68903 .24973 L
.69005 .24981 L
.69216 .25002 L
.69443 .25032 L
.69853 .25108 L
.70341 .25232 L
.70788 .25378 L
.7171 .25773 L
.7268 .26322 L
.7446 .2766 L
.76115 .29245 L
.79633 .33458 L
.83373 .38626 L
.86976 .43564 L
.90443 .47649 L
.922 .49306 L
.93131 .50046 L
.9413 .50726 L
.95073 .51252 L
.95934 .51633 L
.96348 .51781 L
.96799 .51916 L
.97619 .52091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell["\<\
This shows the previous two plots combined into one. Notice that \
the scale is adjusted appropriately. \
\>", "MathCaption",
  CellTags->{"S1.9.3", "3.11"}],

Cell[CellGroupData[{

Cell["gjy = Show[gj0, gy1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[.21429 .26037 -3 -9 ]
[.21429 .26037 3 0 ]
[.40476 .26037 -3 -9 ]
[.40476 .26037 3 0 ]
[.59524 .26037 -3 -9 ]
[.59524 .26037 3 0 ]
[.78571 .26037 -3 -9 ]
[.78571 .26037 3 0 ]
[.97619 .26037 -6 -9 ]
[.97619 .26037 6 0 ]
[.01131 .02503 -30 -4.5 ]
[.01131 .02503 0 4.5 ]
[.01131 .10764 -24 -4.5 ]
[.01131 .10764 0 4.5 ]
[.01131 .19025 -30 -4.5 ]
[.01131 .19025 0 4.5 ]
[.01131 .35548 -24 -4.5 ]
[.01131 .35548 0 4.5 ]
[.01131 .43809 -18 -4.5 ]
[.01131 .43809 0 4.5 ]
[.01131 .52071 -24 -4.5 ]
[.01131 .52071 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .27287 m
.21429 .27912 L
s
[(2)] .21429 .26037 0 1 Mshowa
.40476 .27287 m
.40476 .27912 L
s
[(4)] .40476 .26037 0 1 Mshowa
.59524 .27287 m
.59524 .27912 L
s
[(6)] .59524 .26037 0 1 Mshowa
.78571 .27287 m
.78571 .27912 L
s
[(8)] .78571 .26037 0 1 Mshowa
.97619 .27287 m
.97619 .27912 L
s
[(10)] .97619 .26037 0 1 Mshowa
.125 Mabswid
.07143 .27287 m
.07143 .27662 L
s
.11905 .27287 m
.11905 .27662 L
s
.16667 .27287 m
.16667 .27662 L
s
.2619 .27287 m
.2619 .27662 L
s
.30952 .27287 m
.30952 .27662 L
s
.35714 .27287 m
.35714 .27662 L
s
.45238 .27287 m
.45238 .27662 L
s
.5 .27287 m
.5 .27662 L
s
.54762 .27287 m
.54762 .27662 L
s
.64286 .27287 m
.64286 .27662 L
s
.69048 .27287 m
.69048 .27662 L
s
.7381 .27287 m
.7381 .27662 L
s
.83333 .27287 m
.83333 .27662 L
s
.88095 .27287 m
.88095 .27662 L
s
.92857 .27287 m
.92857 .27662 L
s
.25 Mabswid
0 .27287 m
1 .27287 L
s
.02381 .02503 m
.03006 .02503 L
s
[(-0.75)] .01131 .02503 1 0 Mshowa
.02381 .10764 m
.03006 .10764 L
s
[(-0.5)] .01131 .10764 1 0 Mshowa
.02381 .19025 m
.03006 .19025 L
s
[(-0.25)] .01131 .19025 1 0 Mshowa
.02381 .35548 m
.03006 .35548 L
s
[(0.25)] .01131 .35548 1 0 Mshowa
.02381 .43809 m
.03006 .43809 L
s
[(0.5)] .01131 .43809 1 0 Mshowa
.02381 .52071 m
.03006 .52071 L
s
[(0.75)] .01131 .52071 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04155 m
.02756 .04155 L
s
.02381 .05807 m
.02756 .05807 L
s
.02381 .0746 m
.02756 .0746 L
s
.02381 .09112 m
.02756 .09112 L
s
.02381 .12416 m
.02756 .12416 L
s
.02381 .14069 m
.02756 .14069 L
s
.02381 .15721 m
.02756 .15721 L
s
.02381 .17373 m
.02756 .17373 L
s
.02381 .20678 m
.02756 .20678 L
s
.02381 .2233 m
.02756 .2233 L
s
.02381 .23982 m
.02756 .23982 L
s
.02381 .25635 m
.02756 .25635 L
s
.02381 .28939 m
.02756 .28939 L
s
.02381 .30591 m
.02756 .30591 L
s
.02381 .32244 m
.02756 .32244 L
s
.02381 .33896 m
.02756 .33896 L
s
.02381 .372 m
.02756 .372 L
s
.02381 .38853 m
.02756 .38853 L
s
.02381 .40505 m
.02756 .40505 L
s
.02381 .42157 m
.02756 .42157 L
s
.02381 .45462 m
.02756 .45462 L
s
.02381 .47114 m
.02756 .47114 L
s
.02381 .48766 m
.02756 .48766 L
s
.02381 .50418 m
.02756 .50418 L
s
.02381 .53723 m
.02756 .53723 L
s
.02381 .55375 m
.02756 .55375 L
s
.02381 .57027 m
.02756 .57027 L
s
.02381 .5868 m
.02756 .5868 L
s
.02381 .00851 m
.02756 .00851 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Show[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["plot",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["plot",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " you can combine several plots into one. ",
  StyleBox["GraphicsArray", "MR"],
  " allows you to draw several plots in an array. "
}], "Text",
  CellTags->{"S1.9.3", "3.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Show[GraphicsArray[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["draw several plots side by side "]},
          {Cell[TextData[{
              StyleBox["Show[GraphicsArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["draw a column of plots "]},
          {Cell[TextData[{
              StyleBox["Show[GraphicsArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plot",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["draw a rectangular array of plots "]},
          {Cell[TextData[{
              StyleBox["Show[GraphicsArray[", "MR"],
              StyleBox["plots", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["GraphicsSpacing", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["h", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["v", "TI"],
              StyleBox["}]]", "MR"],
              " "
            }]], 
            Cell["\<\
put the specified horizontal and vertical spacing \
between the plots \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.3"],

Cell["Drawing arrays of plots. ", "Caption",
  CellTags->"S1.9.3"],

Cell["This shows the plots given above in an array. ", "MathCaption",
  CellTags->{"S1.9.3", "3.13"}],

Cell[CellGroupData[{

Cell["Show[GraphicsArray[{{gj0, gjy}, {gy1, gjy}}]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.398561 0.491346 [
[.21429 .38606 -3 -9 ]
[.21429 .38606 3 0 ]
[.40476 .38606 -3 -9 ]
[.40476 .38606 3 0 ]
[.59524 .38606 -3 -9 ]
[.59524 .38606 3 0 ]
[.78571 .38606 -3 -9 ]
[.78571 .38606 3 0 ]
[.97619 .38606 -6 -9 ]
[.97619 .38606 6 0 ]
[.01131 .00548 -24 -4.5 ]
[.01131 .00548 0 4.5 ]
[.01131 .10375 -24 -4.5 ]
[.01131 .10375 0 4.5 ]
[.01131 .20202 -24 -4.5 ]
[.01131 .20202 0 4.5 ]
[.01131 .30029 -24 -4.5 ]
[.01131 .30029 0 4.5 ]
[.01131 .49683 -18 -4.5 ]
[.01131 .49683 0 4.5 ]
[.01131 .5951 -18 -4.5 ]
[.01131 .5951 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .39856 m
.21429 .40481 L
s
[(2)] .21429 .38606 0 1 Mshowa
.40476 .39856 m
.40476 .40481 L
s
[(4)] .40476 .38606 0 1 Mshowa
.59524 .39856 m
.59524 .40481 L
s
[(6)] .59524 .38606 0 1 Mshowa
.78571 .39856 m
.78571 .40481 L
s
[(8)] .78571 .38606 0 1 Mshowa
.97619 .39856 m
.97619 .40481 L
s
[(10)] .97619 .38606 0 1 Mshowa
.125 Mabswid
.07143 .39856 m
.07143 .40231 L
s
.11905 .39856 m
.11905 .40231 L
s
.16667 .39856 m
.16667 .40231 L
s
.2619 .39856 m
.2619 .40231 L
s
.30952 .39856 m
.30952 .40231 L
s
.35714 .39856 m
.35714 .40231 L
s
.45238 .39856 m
.45238 .40231 L
s
.5 .39856 m
.5 .40231 L
s
.54762 .39856 m
.54762 .40231 L
s
.64286 .39856 m
.64286 .40231 L
s
.69048 .39856 m
.69048 .40231 L
s
.7381 .39856 m
.7381 .40231 L
s
.83333 .39856 m
.83333 .40231 L
s
.88095 .39856 m
.88095 .40231 L
s
.92857 .39856 m
.92857 .40231 L
s
.25 Mabswid
0 .39856 m
1 .39856 L
s
.02381 .00548 m
.03006 .00548 L
s
[(-0.8)] .01131 .00548 1 0 Mshowa
.02381 .10375 m
.03006 .10375 L
s
[(-0.6)] .01131 .10375 1 0 Mshowa
.02381 .20202 m
.03006 .20202 L
s
[(-0.4)] .01131 .20202 1 0 Mshowa
.02381 .30029 m
.03006 .30029 L
s
[(-0.2)] .01131 .30029 1 0 Mshowa
.02381 .49683 m
.03006 .49683 L
s
[(0.2)] .01131 .49683 1 0 Mshowa
.02381 .5951 m
.03006 .5951 L
s
[(0.4)] .01131 .5951 1 0 Mshowa
.125 Mabswid
.02381 .03005 m
.02756 .03005 L
s
.02381 .05462 m
.02756 .05462 L
s
.02381 .07919 m
.02756 .07919 L
s
.02381 .12832 m
.02756 .12832 L
s
.02381 .15289 m
.02756 .15289 L
s
.02381 .17745 m
.02756 .17745 L
s
.02381 .22659 m
.02756 .22659 L
s
.02381 .25116 m
.02756 .25116 L
s
.02381 .27572 m
.02756 .27572 L
s
.02381 .32486 m
.02756 .32486 L
s
.02381 .34943 m
.02756 .34943 L
s
.02381 .37399 m
.02756 .37399 L
s
.02381 .42313 m
.02756 .42313 L
s
.02381 .4477 m
.02756 .4477 L
s
.02381 .47226 m
.02756 .47226 L
s
.02381 .5214 m
.02756 .5214 L
s
.02381 .54596 m
.02756 .54596 L
s
.02381 .57053 m
.02756 .57053 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .01472 m
.15382 .15139 L
.19174 .27775 L
.22736 .38303 L
.26161 .46958 L
.2807 .50991 L
.29806 .54088 L
.31631 .56702 L
.33316 .58501 L
.34152 .59168 L
.35039 .59711 L
.35499 .59926 L
.35929 .60085 L
.36401 .60214 L
.36667 .60266 L
.36792 .60285 L
.36909 .603 L
.37018 .60312 L
.37134 .60321 L
.37241 .60327 L
.37338 .6033 L
.37444 .60332 L
.37561 .60331 L
.37619 .60329 L
.37682 .60327 L
.37796 .6032 L
.37901 .60311 L
.38016 .60299 L
.38226 .60271 L
.3843 .60234 L
.38618 .60192 L
.39048 .60071 L
.39522 .59895 L
.40483 .59404 L
.41392 .58781 L
.42224 .58083 L
.44102 .56096 L
.47668 .51041 L
.51097 .45187 L
.54748 .38713 L
.58262 .33031 L
.60054 .30565 L
.61997 .28334 L
.62906 .27468 L
.63869 .26684 L
.64771 .26079 L
.65595 .25638 L
.66444 .25298 L
.66913 .25161 L
.67128 .2511 L
Mistroke
.67357 .25064 L
.67572 .25028 L
.67766 .25002 L
.6786 .24992 L
.67962 .24982 L
.68057 .24975 L
.68145 .24969 L
.68249 .24964 L
.68363 .24961 L
.68474 .2496 L
.68593 .24961 L
.68704 .24963 L
.68809 .24968 L
.68903 .24973 L
.69005 .24981 L
.69216 .25002 L
.69443 .25032 L
.69853 .25108 L
.70341 .25232 L
.70788 .25378 L
.7171 .25773 L
.7268 .26322 L
.7446 .2766 L
.76115 .29245 L
.79633 .33458 L
.83373 .38626 L
.86976 .43564 L
.90443 .47649 L
.922 .49306 L
.93131 .50046 L
.9413 .50726 L
.95073 .51252 L
.95934 .51633 L
.96348 .51781 L
.96799 .51916 L
.97619 .52091 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[.21429 .26037 -3 -9 ]
[.21429 .26037 3 0 ]
[.40476 .26037 -3 -9 ]
[.40476 .26037 3 0 ]
[.59524 .26037 -3 -9 ]
[.59524 .26037 3 0 ]
[.78571 .26037 -3 -9 ]
[.78571 .26037 3 0 ]
[.97619 .26037 -6 -9 ]
[.97619 .26037 6 0 ]
[.01131 .02503 -30 -4.5 ]
[.01131 .02503 0 4.5 ]
[.01131 .10764 -24 -4.5 ]
[.01131 .10764 0 4.5 ]
[.01131 .19025 -30 -4.5 ]
[.01131 .19025 0 4.5 ]
[.01131 .35548 -24 -4.5 ]
[.01131 .35548 0 4.5 ]
[.01131 .43809 -18 -4.5 ]
[.01131 .43809 0 4.5 ]
[.01131 .52071 -24 -4.5 ]
[.01131 .52071 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .27287 m
.21429 .27912 L
s
[(2)] .21429 .26037 0 1 Mshowa
.40476 .27287 m
.40476 .27912 L
s
[(4)] .40476 .26037 0 1 Mshowa
.59524 .27287 m
.59524 .27912 L
s
[(6)] .59524 .26037 0 1 Mshowa
.78571 .27287 m
.78571 .27912 L
s
[(8)] .78571 .26037 0 1 Mshowa
.97619 .27287 m
.97619 .27912 L
s
[(10)] .97619 .26037 0 1 Mshowa
.125 Mabswid
.07143 .27287 m
.07143 .27662 L
s
.11905 .27287 m
.11905 .27662 L
s
.16667 .27287 m
.16667 .27662 L
s
.2619 .27287 m
.2619 .27662 L
s
.30952 .27287 m
.30952 .27662 L
s
.35714 .27287 m
.35714 .27662 L
s
.45238 .27287 m
.45238 .27662 L
s
.5 .27287 m
.5 .27662 L
s
.54762 .27287 m
.54762 .27662 L
s
.64286 .27287 m
.64286 .27662 L
s
.69048 .27287 m
.69048 .27662 L
s
.7381 .27287 m
.7381 .27662 L
s
.83333 .27287 m
.83333 .27662 L
s
.88095 .27287 m
.88095 .27662 L
s
.92857 .27287 m
.92857 .27662 L
s
.25 Mabswid
0 .27287 m
1 .27287 L
s
.02381 .02503 m
.03006 .02503 L
s
[(-0.75)] .01131 .02503 1 0 Mshowa
.02381 .10764 m
.03006 .10764 L
s
[(-0.5)] .01131 .10764 1 0 Mshowa
.02381 .19025 m
.03006 .19025 L
s
[(-0.25)] .01131 .19025 1 0 Mshowa
.02381 .35548 m
.03006 .35548 L
s
[(0.25)] .01131 .35548 1 0 Mshowa
.02381 .43809 m
.03006 .43809 L
s
[(0.5)] .01131 .43809 1 0 Mshowa
.02381 .52071 m
.03006 .52071 L
s
[(0.75)] .01131 .52071 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04155 m
.02756 .04155 L
s
.02381 .05807 m
.02756 .05807 L
s
.02381 .0746 m
.02756 .0746 L
s
.02381 .09112 m
.02756 .09112 L
s
.02381 .12416 m
.02756 .12416 L
s
.02381 .14069 m
.02756 .14069 L
s
.02381 .15721 m
.02756 .15721 L
s
.02381 .17373 m
.02756 .17373 L
s
.02381 .20678 m
.02756 .20678 L
s
.02381 .2233 m
.02756 .2233 L
s
.02381 .23982 m
.02756 .23982 L
s
.02381 .25635 m
.02756 .25635 L
s
.02381 .28939 m
.02756 .28939 L
s
.02381 .30591 m
.02756 .30591 L
s
.02381 .32244 m
.02756 .32244 L
s
.02381 .33896 m
.02756 .33896 L
s
.02381 .372 m
.02756 .372 L
s
.02381 .38853 m
.02756 .38853 L
s
.02381 .40505 m
.02756 .40505 L
s
.02381 .42157 m
.02756 .42157 L
s
.02381 .45462 m
.02756 .45462 L
s
.02381 .47114 m
.02756 .47114 L
s
.02381 .48766 m
.02756 .48766 L
s
.02381 .50418 m
.02756 .50418 L
s
.02381 .53723 m
.02756 .53723 L
s
.02381 .55375 m
.02756 .55375 L
s
.02381 .57027 m
.02756 .57027 L
s
.02381 .5868 m
.02756 .5868 L
s
.02381 .00851 m
.02756 .00851 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.323031 0.477324 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.183713 0.419605 [
[.21429 .17121 -3 -9 ]
[.21429 .17121 3 0 ]
[.40476 .17121 -3 -9 ]
[.40476 .17121 3 0 ]
[.59524 .17121 -3 -9 ]
[.59524 .17121 3 0 ]
[.78571 .17121 -3 -9 ]
[.78571 .17121 3 0 ]
[.97619 .17121 -6 -9 ]
[.97619 .17121 6 0 ]
[.01131 .01587 -24 -4.5 ]
[.01131 .01587 0 4.5 ]
[.01131 .09979 -24 -4.5 ]
[.01131 .09979 0 4.5 ]
[.01131 .26763 -18 -4.5 ]
[.01131 .26763 0 4.5 ]
[.01131 .35156 -18 -4.5 ]
[.01131 .35156 0 4.5 ]
[.01131 .43548 -18 -4.5 ]
[.01131 .43548 0 4.5 ]
[.01131 .5194 -18 -4.5 ]
[.01131 .5194 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .18371 m
.21429 .18996 L
s
[(2)] .21429 .17121 0 1 Mshowa
.40476 .18371 m
.40476 .18996 L
s
[(4)] .40476 .17121 0 1 Mshowa
.59524 .18371 m
.59524 .18996 L
s
[(6)] .59524 .17121 0 1 Mshowa
.78571 .18371 m
.78571 .18996 L
s
[(8)] .78571 .17121 0 1 Mshowa
.97619 .18371 m
.97619 .18996 L
s
[(10)] .97619 .17121 0 1 Mshowa
.125 Mabswid
.07143 .18371 m
.07143 .18746 L
s
.11905 .18371 m
.11905 .18746 L
s
.16667 .18371 m
.16667 .18746 L
s
.2619 .18371 m
.2619 .18746 L
s
.30952 .18371 m
.30952 .18746 L
s
.35714 .18371 m
.35714 .18746 L
s
.45238 .18371 m
.45238 .18746 L
s
.5 .18371 m
.5 .18746 L
s
.54762 .18371 m
.54762 .18746 L
s
.64286 .18371 m
.64286 .18746 L
s
.69048 .18371 m
.69048 .18746 L
s
.7381 .18371 m
.7381 .18746 L
s
.83333 .18371 m
.83333 .18746 L
s
.88095 .18371 m
.88095 .18746 L
s
.92857 .18371 m
.92857 .18746 L
s
.25 Mabswid
0 .18371 m
1 .18371 L
s
.02381 .01587 m
.03006 .01587 L
s
[(-0.4)] .01131 .01587 1 0 Mshowa
.02381 .09979 m
.03006 .09979 L
s
[(-0.2)] .01131 .09979 1 0 Mshowa
.02381 .26763 m
.03006 .26763 L
s
[(0.2)] .01131 .26763 1 0 Mshowa
.02381 .35156 m
.03006 .35156 L
s
[(0.4)] .01131 .35156 1 0 Mshowa
.02381 .43548 m
.03006 .43548 L
s
[(0.6)] .01131 .43548 1 0 Mshowa
.02381 .5194 m
.03006 .5194 L
s
[(0.8)] .01131 .5194 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03685 m
.02756 .03685 L
s
.02381 .05783 m
.02756 .05783 L
s
.02381 .07881 m
.02756 .07881 L
s
.02381 .12077 m
.02756 .12077 L
s
.02381 .14175 m
.02756 .14175 L
s
.02381 .16273 m
.02756 .16273 L
s
.02381 .20469 m
.02756 .20469 L
s
.02381 .22567 m
.02756 .22567 L
s
.02381 .24665 m
.02756 .24665 L
s
.02381 .28861 m
.02756 .28861 L
s
.02381 .3096 m
.02756 .3096 L
s
.02381 .33058 m
.02756 .33058 L
s
.02381 .37254 m
.02756 .37254 L
s
.02381 .39352 m
.02756 .39352 L
s
.02381 .4145 m
.02756 .4145 L
s
.02381 .45646 m
.02756 .45646 L
s
.02381 .47744 m
.02756 .47744 L
s
.02381 .49842 m
.02756 .49842 L
s
.02381 .54038 m
.02756 .54038 L
s
.02381 .56136 m
.02756 .56136 L
s
.02381 .58234 m
.02756 .58234 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60326 L
.02729 .60318 L
.02846 .60307 L
.03053 .6028 L
.03279 .60239 L
.03527 .6018 L
.0379 .60103 L
.04262 .59924 L
.04749 .59686 L
.05205 .59414 L
.06244 .58623 L
.07305 .57575 L
.08274 .5641 L
.10458 .53119 L
.14429 .45151 L
.18248 .35892 L
.22313 .25533 L
.26226 .16264 L
.28223 .12146 L
.30384 .08336 L
.32471 .05395 L
.33464 .04272 L
.34391 .03392 L
.35375 .02637 L
.36273 .02113 L
.36785 .01884 L
.3727 .01714 L
.37518 .01644 L
.37782 .01583 L
.3792 .01557 L
.38072 .01532 L
.3821 .01513 L
.38339 .01498 L
.38453 .01488 L
.38574 .0148 L
.38643 .01476 L
.38709 .01474 L
.38831 .01472 L
.3896 .01472 L
.39079 .01475 L
.3921 .01482 L
.39276 .01486 L
.39349 .01492 L
.39579 .01517 L
.39827 .01555 L
.40274 .01651 L
.40833 .01822 L
.41364 .02033 L
Mistroke
.4236 .02558 L
.43321 .03214 L
.44344 .04062 L
.46184 .05938 L
.50348 .11424 L
.54359 .17477 L
.5822 .2303 L
.60178 .2547 L
.62325 .27711 L
.63313 .28565 L
.64371 .29343 L
.65363 .29938 L
.66279 .3037 L
.66764 .30551 L
.67299 .30713 L
.67837 .30835 L
.68131 .30885 L
.68407 .30921 L
.68654 .30944 L
.68778 .30952 L
.68849 .30956 L
.68913 .30959 L
.6903 .30962 L
.69154 .30964 L
.69268 .30964 L
.69377 .30962 L
.69504 .30958 L
.69567 .30955 L
.69638 .30951 L
.69878 .30932 L
.70013 .30918 L
.70158 .309 L
.70421 .30861 L
.70948 .30754 L
.71436 .30621 L
.72542 .30208 L
.73517 .29717 L
.74553 .29073 L
.78325 .25826 L
.82342 .21319 L
.86208 .16705 L
.90319 .12332 L
.92369 .10592 L
.94278 .09326 L
.95893 .08554 L
.96797 .08248 L
.97619 .08052 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.323031 0.97619 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[.21429 .26037 -3 -9 ]
[.21429 .26037 3 0 ]
[.40476 .26037 -3 -9 ]
[.40476 .26037 3 0 ]
[.59524 .26037 -3 -9 ]
[.59524 .26037 3 0 ]
[.78571 .26037 -3 -9 ]
[.78571 .26037 3 0 ]
[.97619 .26037 -6 -9 ]
[.97619 .26037 6 0 ]
[.01131 .02503 -30 -4.5 ]
[.01131 .02503 0 4.5 ]
[.01131 .10764 -24 -4.5 ]
[.01131 .10764 0 4.5 ]
[.01131 .19025 -30 -4.5 ]
[.01131 .19025 0 4.5 ]
[.01131 .35548 -24 -4.5 ]
[.01131 .35548 0 4.5 ]
[.01131 .43809 -18 -4.5 ]
[.01131 .43809 0 4.5 ]
[.01131 .52071 -24 -4.5 ]
[.01131 .52071 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .27287 m
.21429 .27912 L
s
[(2)] .21429 .26037 0 1 Mshowa
.40476 .27287 m
.40476 .27912 L
s
[(4)] .40476 .26037 0 1 Mshowa
.59524 .27287 m
.59524 .27912 L
s
[(6)] .59524 .26037 0 1 Mshowa
.78571 .27287 m
.78571 .27912 L
s
[(8)] .78571 .26037 0 1 Mshowa
.97619 .27287 m
.97619 .27912 L
s
[(10)] .97619 .26037 0 1 Mshowa
.125 Mabswid
.07143 .27287 m
.07143 .27662 L
s
.11905 .27287 m
.11905 .27662 L
s
.16667 .27287 m
.16667 .27662 L
s
.2619 .27287 m
.2619 .27662 L
s
.30952 .27287 m
.30952 .27662 L
s
.35714 .27287 m
.35714 .27662 L
s
.45238 .27287 m
.45238 .27662 L
s
.5 .27287 m
.5 .27662 L
s
.54762 .27287 m
.54762 .27662 L
s
.64286 .27287 m
.64286 .27662 L
s
.69048 .27287 m
.69048 .27662 L
s
.7381 .27287 m
.7381 .27662 L
s
.83333 .27287 m
.83333 .27662 L
s
.88095 .27287 m
.88095 .27662 L
s
.92857 .27287 m
.92857 .27662 L
s
.25 Mabswid
0 .27287 m
1 .27287 L
s
.02381 .02503 m
.03006 .02503 L
s
[(-0.75)] .01131 .02503 1 0 Mshowa
.02381 .10764 m
.03006 .10764 L
s
[(-0.5)] .01131 .10764 1 0 Mshowa
.02381 .19025 m
.03006 .19025 L
s
[(-0.25)] .01131 .19025 1 0 Mshowa
.02381 .35548 m
.03006 .35548 L
s
[(0.25)] .01131 .35548 1 0 Mshowa
.02381 .43809 m
.03006 .43809 L
s
[(0.5)] .01131 .43809 1 0 Mshowa
.02381 .52071 m
.03006 .52071 L
s
[(0.75)] .01131 .52071 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04155 m
.02756 .04155 L
s
.02381 .05807 m
.02756 .05807 L
s
.02381 .0746 m
.02756 .0746 L
s
.02381 .09112 m
.02756 .09112 L
s
.02381 .12416 m
.02756 .12416 L
s
.02381 .14069 m
.02756 .14069 L
s
.02381 .15721 m
.02756 .15721 L
s
.02381 .17373 m
.02756 .17373 L
s
.02381 .20678 m
.02756 .20678 L
s
.02381 .2233 m
.02756 .2233 L
s
.02381 .23982 m
.02756 .23982 L
s
.02381 .25635 m
.02756 .25635 L
s
.02381 .28939 m
.02756 .28939 L
s
.02381 .30591 m
.02756 .30591 L
s
.02381 .32244 m
.02756 .32244 L
s
.02381 .33896 m
.02756 .33896 L
s
.02381 .372 m
.02756 .372 L
s
.02381 .38853 m
.02756 .38853 L
s
.02381 .40505 m
.02756 .40505 L
s
.02381 .42157 m
.02756 .42157 L
s
.02381 .45462 m
.02756 .45462 L
s
.02381 .47114 m
.02756 .47114 L
s
.02381 .48766 m
.02756 .48766 L
s
.02381 .50418 m
.02756 .50418 L
s
.02381 .53723 m
.02756 .53723 L
s
.02381 .55375 m
.02756 .55375 L
s
.02381 .57027 m
.02756 .57027 L
s
.02381 .5868 m
.02756 .5868 L
s
.02381 .00851 m
.02756 .00851 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "If you redisplay an array of plots using ",
  StyleBox["Show", "MR"],
  ", any options you specify will be used for the whole array, rather than \
for individual plots. "
}], "MathCaption",
  CellTags->{"S1.9.3", "3.14"}],

Cell[CellGroupData[{

Cell["Show[%, Frame->True, FrameTicks->None]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .61803 L
s
0 .61803 m
1 .61803 L
s
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.398561 0.491346 [
[.21429 .38606 -3 -9 ]
[.21429 .38606 3 0 ]
[.40476 .38606 -3 -9 ]
[.40476 .38606 3 0 ]
[.59524 .38606 -3 -9 ]
[.59524 .38606 3 0 ]
[.78571 .38606 -3 -9 ]
[.78571 .38606 3 0 ]
[.97619 .38606 -6 -9 ]
[.97619 .38606 6 0 ]
[.01131 .00548 -24 -4.5 ]
[.01131 .00548 0 4.5 ]
[.01131 .10375 -24 -4.5 ]
[.01131 .10375 0 4.5 ]
[.01131 .20202 -24 -4.5 ]
[.01131 .20202 0 4.5 ]
[.01131 .30029 -24 -4.5 ]
[.01131 .30029 0 4.5 ]
[.01131 .49683 -18 -4.5 ]
[.01131 .49683 0 4.5 ]
[.01131 .5951 -18 -4.5 ]
[.01131 .5951 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .39856 m
.21429 .40481 L
s
[(2)] .21429 .38606 0 1 Mshowa
.40476 .39856 m
.40476 .40481 L
s
[(4)] .40476 .38606 0 1 Mshowa
.59524 .39856 m
.59524 .40481 L
s
[(6)] .59524 .38606 0 1 Mshowa
.78571 .39856 m
.78571 .40481 L
s
[(8)] .78571 .38606 0 1 Mshowa
.97619 .39856 m
.97619 .40481 L
s
[(10)] .97619 .38606 0 1 Mshowa
.125 Mabswid
.07143 .39856 m
.07143 .40231 L
s
.11905 .39856 m
.11905 .40231 L
s
.16667 .39856 m
.16667 .40231 L
s
.2619 .39856 m
.2619 .40231 L
s
.30952 .39856 m
.30952 .40231 L
s
.35714 .39856 m
.35714 .40231 L
s
.45238 .39856 m
.45238 .40231 L
s
.5 .39856 m
.5 .40231 L
s
.54762 .39856 m
.54762 .40231 L
s
.64286 .39856 m
.64286 .40231 L
s
.69048 .39856 m
.69048 .40231 L
s
.7381 .39856 m
.7381 .40231 L
s
.83333 .39856 m
.83333 .40231 L
s
.88095 .39856 m
.88095 .40231 L
s
.92857 .39856 m
.92857 .40231 L
s
.25 Mabswid
0 .39856 m
1 .39856 L
s
.02381 .00548 m
.03006 .00548 L
s
[(-0.8)] .01131 .00548 1 0 Mshowa
.02381 .10375 m
.03006 .10375 L
s
[(-0.6)] .01131 .10375 1 0 Mshowa
.02381 .20202 m
.03006 .20202 L
s
[(-0.4)] .01131 .20202 1 0 Mshowa
.02381 .30029 m
.03006 .30029 L
s
[(-0.2)] .01131 .30029 1 0 Mshowa
.02381 .49683 m
.03006 .49683 L
s
[(0.2)] .01131 .49683 1 0 Mshowa
.02381 .5951 m
.03006 .5951 L
s
[(0.4)] .01131 .5951 1 0 Mshowa
.125 Mabswid
.02381 .03005 m
.02756 .03005 L
s
.02381 .05462 m
.02756 .05462 L
s
.02381 .07919 m
.02756 .07919 L
s
.02381 .12832 m
.02756 .12832 L
s
.02381 .15289 m
.02756 .15289 L
s
.02381 .17745 m
.02756 .17745 L
s
.02381 .22659 m
.02756 .22659 L
s
.02381 .25116 m
.02756 .25116 L
s
.02381 .27572 m
.02756 .27572 L
s
.02381 .32486 m
.02756 .32486 L
s
.02381 .34943 m
.02756 .34943 L
s
.02381 .37399 m
.02756 .37399 L
s
.02381 .42313 m
.02756 .42313 L
s
.02381 .4477 m
.02756 .4477 L
s
.02381 .47226 m
.02756 .47226 L
s
.02381 .5214 m
.02756 .5214 L
s
.02381 .54596 m
.02756 .54596 L
s
.02381 .57053 m
.02756 .57053 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .01472 m
.15382 .15139 L
.19174 .27775 L
.22736 .38303 L
.26161 .46958 L
.2807 .50991 L
.29806 .54088 L
.31631 .56702 L
.33316 .58501 L
.34152 .59168 L
.35039 .59711 L
.35499 .59926 L
.35929 .60085 L
.36401 .60214 L
.36667 .60266 L
.36792 .60285 L
.36909 .603 L
.37018 .60312 L
.37134 .60321 L
.37241 .60327 L
.37338 .6033 L
.37444 .60332 L
.37561 .60331 L
.37619 .60329 L
.37682 .60327 L
.37796 .6032 L
.37901 .60311 L
.38016 .60299 L
.38226 .60271 L
.3843 .60234 L
.38618 .60192 L
.39048 .60071 L
.39522 .59895 L
.40483 .59404 L
.41392 .58781 L
.42224 .58083 L
.44102 .56096 L
.47668 .51041 L
.51097 .45187 L
.54748 .38713 L
.58262 .33031 L
.60054 .30565 L
.61997 .28334 L
.62906 .27468 L
.63869 .26684 L
.64771 .26079 L
.65595 .25638 L
.66444 .25298 L
.66913 .25161 L
.67128 .2511 L
Mistroke
.67357 .25064 L
.67572 .25028 L
.67766 .25002 L
.6786 .24992 L
.67962 .24982 L
.68057 .24975 L
.68145 .24969 L
.68249 .24964 L
.68363 .24961 L
.68474 .2496 L
.68593 .24961 L
.68704 .24963 L
.68809 .24968 L
.68903 .24973 L
.69005 .24981 L
.69216 .25002 L
.69443 .25032 L
.69853 .25108 L
.70341 .25232 L
.70788 .25378 L
.7171 .25773 L
.7268 .26322 L
.7446 .2766 L
.76115 .29245 L
.79633 .33458 L
.83373 .38626 L
.86976 .43564 L
.90443 .47649 L
.922 .49306 L
.93131 .50046 L
.9413 .50726 L
.95073 .51252 L
.95934 .51633 L
.96348 .51781 L
.96799 .51916 L
.97619 .52091 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[.21429 .26037 -3 -9 ]
[.21429 .26037 3 0 ]
[.40476 .26037 -3 -9 ]
[.40476 .26037 3 0 ]
[.59524 .26037 -3 -9 ]
[.59524 .26037 3 0 ]
[.78571 .26037 -3 -9 ]
[.78571 .26037 3 0 ]
[.97619 .26037 -6 -9 ]
[.97619 .26037 6 0 ]
[.01131 .02503 -30 -4.5 ]
[.01131 .02503 0 4.5 ]
[.01131 .10764 -24 -4.5 ]
[.01131 .10764 0 4.5 ]
[.01131 .19025 -30 -4.5 ]
[.01131 .19025 0 4.5 ]
[.01131 .35548 -24 -4.5 ]
[.01131 .35548 0 4.5 ]
[.01131 .43809 -18 -4.5 ]
[.01131 .43809 0 4.5 ]
[.01131 .52071 -24 -4.5 ]
[.01131 .52071 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .27287 m
.21429 .27912 L
s
[(2)] .21429 .26037 0 1 Mshowa
.40476 .27287 m
.40476 .27912 L
s
[(4)] .40476 .26037 0 1 Mshowa
.59524 .27287 m
.59524 .27912 L
s
[(6)] .59524 .26037 0 1 Mshowa
.78571 .27287 m
.78571 .27912 L
s
[(8)] .78571 .26037 0 1 Mshowa
.97619 .27287 m
.97619 .27912 L
s
[(10)] .97619 .26037 0 1 Mshowa
.125 Mabswid
.07143 .27287 m
.07143 .27662 L
s
.11905 .27287 m
.11905 .27662 L
s
.16667 .27287 m
.16667 .27662 L
s
.2619 .27287 m
.2619 .27662 L
s
.30952 .27287 m
.30952 .27662 L
s
.35714 .27287 m
.35714 .27662 L
s
.45238 .27287 m
.45238 .27662 L
s
.5 .27287 m
.5 .27662 L
s
.54762 .27287 m
.54762 .27662 L
s
.64286 .27287 m
.64286 .27662 L
s
.69048 .27287 m
.69048 .27662 L
s
.7381 .27287 m
.7381 .27662 L
s
.83333 .27287 m
.83333 .27662 L
s
.88095 .27287 m
.88095 .27662 L
s
.92857 .27287 m
.92857 .27662 L
s
.25 Mabswid
0 .27287 m
1 .27287 L
s
.02381 .02503 m
.03006 .02503 L
s
[(-0.75)] .01131 .02503 1 0 Mshowa
.02381 .10764 m
.03006 .10764 L
s
[(-0.5)] .01131 .10764 1 0 Mshowa
.02381 .19025 m
.03006 .19025 L
s
[(-0.25)] .01131 .19025 1 0 Mshowa
.02381 .35548 m
.03006 .35548 L
s
[(0.25)] .01131 .35548 1 0 Mshowa
.02381 .43809 m
.03006 .43809 L
s
[(0.5)] .01131 .43809 1 0 Mshowa
.02381 .52071 m
.03006 .52071 L
s
[(0.75)] .01131 .52071 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04155 m
.02756 .04155 L
s
.02381 .05807 m
.02756 .05807 L
s
.02381 .0746 m
.02756 .0746 L
s
.02381 .09112 m
.02756 .09112 L
s
.02381 .12416 m
.02756 .12416 L
s
.02381 .14069 m
.02756 .14069 L
s
.02381 .15721 m
.02756 .15721 L
s
.02381 .17373 m
.02756 .17373 L
s
.02381 .20678 m
.02756 .20678 L
s
.02381 .2233 m
.02756 .2233 L
s
.02381 .23982 m
.02756 .23982 L
s
.02381 .25635 m
.02756 .25635 L
s
.02381 .28939 m
.02756 .28939 L
s
.02381 .30591 m
.02756 .30591 L
s
.02381 .32244 m
.02756 .32244 L
s
.02381 .33896 m
.02756 .33896 L
s
.02381 .372 m
.02756 .372 L
s
.02381 .38853 m
.02756 .38853 L
s
.02381 .40505 m
.02756 .40505 L
s
.02381 .42157 m
.02756 .42157 L
s
.02381 .45462 m
.02756 .45462 L
s
.02381 .47114 m
.02756 .47114 L
s
.02381 .48766 m
.02756 .48766 L
s
.02381 .50418 m
.02756 .50418 L
s
.02381 .53723 m
.02756 .53723 L
s
.02381 .55375 m
.02756 .55375 L
s
.02381 .57027 m
.02756 .57027 L
s
.02381 .5868 m
.02756 .5868 L
s
.02381 .00851 m
.02756 .00851 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.323031 0.477324 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.183713 0.419605 [
[.21429 .17121 -3 -9 ]
[.21429 .17121 3 0 ]
[.40476 .17121 -3 -9 ]
[.40476 .17121 3 0 ]
[.59524 .17121 -3 -9 ]
[.59524 .17121 3 0 ]
[.78571 .17121 -3 -9 ]
[.78571 .17121 3 0 ]
[.97619 .17121 -6 -9 ]
[.97619 .17121 6 0 ]
[.01131 .01587 -24 -4.5 ]
[.01131 .01587 0 4.5 ]
[.01131 .09979 -24 -4.5 ]
[.01131 .09979 0 4.5 ]
[.01131 .26763 -18 -4.5 ]
[.01131 .26763 0 4.5 ]
[.01131 .35156 -18 -4.5 ]
[.01131 .35156 0 4.5 ]
[.01131 .43548 -18 -4.5 ]
[.01131 .43548 0 4.5 ]
[.01131 .5194 -18 -4.5 ]
[.01131 .5194 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .18371 m
.21429 .18996 L
s
[(2)] .21429 .17121 0 1 Mshowa
.40476 .18371 m
.40476 .18996 L
s
[(4)] .40476 .17121 0 1 Mshowa
.59524 .18371 m
.59524 .18996 L
s
[(6)] .59524 .17121 0 1 Mshowa
.78571 .18371 m
.78571 .18996 L
s
[(8)] .78571 .17121 0 1 Mshowa
.97619 .18371 m
.97619 .18996 L
s
[(10)] .97619 .17121 0 1 Mshowa
.125 Mabswid
.07143 .18371 m
.07143 .18746 L
s
.11905 .18371 m
.11905 .18746 L
s
.16667 .18371 m
.16667 .18746 L
s
.2619 .18371 m
.2619 .18746 L
s
.30952 .18371 m
.30952 .18746 L
s
.35714 .18371 m
.35714 .18746 L
s
.45238 .18371 m
.45238 .18746 L
s
.5 .18371 m
.5 .18746 L
s
.54762 .18371 m
.54762 .18746 L
s
.64286 .18371 m
.64286 .18746 L
s
.69048 .18371 m
.69048 .18746 L
s
.7381 .18371 m
.7381 .18746 L
s
.83333 .18371 m
.83333 .18746 L
s
.88095 .18371 m
.88095 .18746 L
s
.92857 .18371 m
.92857 .18746 L
s
.25 Mabswid
0 .18371 m
1 .18371 L
s
.02381 .01587 m
.03006 .01587 L
s
[(-0.4)] .01131 .01587 1 0 Mshowa
.02381 .09979 m
.03006 .09979 L
s
[(-0.2)] .01131 .09979 1 0 Mshowa
.02381 .26763 m
.03006 .26763 L
s
[(0.2)] .01131 .26763 1 0 Mshowa
.02381 .35156 m
.03006 .35156 L
s
[(0.4)] .01131 .35156 1 0 Mshowa
.02381 .43548 m
.03006 .43548 L
s
[(0.6)] .01131 .43548 1 0 Mshowa
.02381 .5194 m
.03006 .5194 L
s
[(0.8)] .01131 .5194 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03685 m
.02756 .03685 L
s
.02381 .05783 m
.02756 .05783 L
s
.02381 .07881 m
.02756 .07881 L
s
.02381 .12077 m
.02756 .12077 L
s
.02381 .14175 m
.02756 .14175 L
s
.02381 .16273 m
.02756 .16273 L
s
.02381 .20469 m
.02756 .20469 L
s
.02381 .22567 m
.02756 .22567 L
s
.02381 .24665 m
.02756 .24665 L
s
.02381 .28861 m
.02756 .28861 L
s
.02381 .3096 m
.02756 .3096 L
s
.02381 .33058 m
.02756 .33058 L
s
.02381 .37254 m
.02756 .37254 L
s
.02381 .39352 m
.02756 .39352 L
s
.02381 .4145 m
.02756 .4145 L
s
.02381 .45646 m
.02756 .45646 L
s
.02381 .47744 m
.02756 .47744 L
s
.02381 .49842 m
.02756 .49842 L
s
.02381 .54038 m
.02756 .54038 L
s
.02381 .56136 m
.02756 .56136 L
s
.02381 .58234 m
.02756 .58234 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60326 L
.02729 .60318 L
.02846 .60307 L
.03053 .6028 L
.03279 .60239 L
.03527 .6018 L
.0379 .60103 L
.04262 .59924 L
.04749 .59686 L
.05205 .59414 L
.06244 .58623 L
.07305 .57575 L
.08274 .5641 L
.10458 .53119 L
.14429 .45151 L
.18248 .35892 L
.22313 .25533 L
.26226 .16264 L
.28223 .12146 L
.30384 .08336 L
.32471 .05395 L
.33464 .04272 L
.34391 .03392 L
.35375 .02637 L
.36273 .02113 L
.36785 .01884 L
.3727 .01714 L
.37518 .01644 L
.37782 .01583 L
.3792 .01557 L
.38072 .01532 L
.3821 .01513 L
.38339 .01498 L
.38453 .01488 L
.38574 .0148 L
.38643 .01476 L
.38709 .01474 L
.38831 .01472 L
.3896 .01472 L
.39079 .01475 L
.3921 .01482 L
.39276 .01486 L
.39349 .01492 L
.39579 .01517 L
.39827 .01555 L
.40274 .01651 L
.40833 .01822 L
.41364 .02033 L
Mistroke
.4236 .02558 L
.43321 .03214 L
.44344 .04062 L
.46184 .05938 L
.50348 .11424 L
.54359 .17477 L
.5822 .2303 L
.60178 .2547 L
.62325 .27711 L
.63313 .28565 L
.64371 .29343 L
.65363 .29938 L
.66279 .3037 L
.66764 .30551 L
.67299 .30713 L
.67837 .30835 L
.68131 .30885 L
.68407 .30921 L
.68654 .30944 L
.68778 .30952 L
.68849 .30956 L
.68913 .30959 L
.6903 .30962 L
.69154 .30964 L
.69268 .30964 L
.69377 .30962 L
.69504 .30958 L
.69567 .30955 L
.69638 .30951 L
.69878 .30932 L
.70013 .30918 L
.70158 .309 L
.70421 .30861 L
.70948 .30754 L
.71436 .30621 L
.72542 .30208 L
.73517 .29717 L
.74553 .29073 L
.78325 .25826 L
.82342 .21319 L
.86208 .16705 L
.90319 .12332 L
.92369 .10592 L
.94278 .09326 L
.95893 .08554 L
.96797 .08248 L
.97619 .08052 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.323031 0.97619 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[.21429 .26037 -3 -9 ]
[.21429 .26037 3 0 ]
[.40476 .26037 -3 -9 ]
[.40476 .26037 3 0 ]
[.59524 .26037 -3 -9 ]
[.59524 .26037 3 0 ]
[.78571 .26037 -3 -9 ]
[.78571 .26037 3 0 ]
[.97619 .26037 -6 -9 ]
[.97619 .26037 6 0 ]
[.01131 .02503 -30 -4.5 ]
[.01131 .02503 0 4.5 ]
[.01131 .10764 -24 -4.5 ]
[.01131 .10764 0 4.5 ]
[.01131 .19025 -30 -4.5 ]
[.01131 .19025 0 4.5 ]
[.01131 .35548 -24 -4.5 ]
[.01131 .35548 0 4.5 ]
[.01131 .43809 -18 -4.5 ]
[.01131 .43809 0 4.5 ]
[.01131 .52071 -24 -4.5 ]
[.01131 .52071 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .27287 m
.21429 .27912 L
s
[(2)] .21429 .26037 0 1 Mshowa
.40476 .27287 m
.40476 .27912 L
s
[(4)] .40476 .26037 0 1 Mshowa
.59524 .27287 m
.59524 .27912 L
s
[(6)] .59524 .26037 0 1 Mshowa
.78571 .27287 m
.78571 .27912 L
s
[(8)] .78571 .26037 0 1 Mshowa
.97619 .27287 m
.97619 .27912 L
s
[(10)] .97619 .26037 0 1 Mshowa
.125 Mabswid
.07143 .27287 m
.07143 .27662 L
s
.11905 .27287 m
.11905 .27662 L
s
.16667 .27287 m
.16667 .27662 L
s
.2619 .27287 m
.2619 .27662 L
s
.30952 .27287 m
.30952 .27662 L
s
.35714 .27287 m
.35714 .27662 L
s
.45238 .27287 m
.45238 .27662 L
s
.5 .27287 m
.5 .27662 L
s
.54762 .27287 m
.54762 .27662 L
s
.64286 .27287 m
.64286 .27662 L
s
.69048 .27287 m
.69048 .27662 L
s
.7381 .27287 m
.7381 .27662 L
s
.83333 .27287 m
.83333 .27662 L
s
.88095 .27287 m
.88095 .27662 L
s
.92857 .27287 m
.92857 .27662 L
s
.25 Mabswid
0 .27287 m
1 .27287 L
s
.02381 .02503 m
.03006 .02503 L
s
[(-0.75)] .01131 .02503 1 0 Mshowa
.02381 .10764 m
.03006 .10764 L
s
[(-0.5)] .01131 .10764 1 0 Mshowa
.02381 .19025 m
.03006 .19025 L
s
[(-0.25)] .01131 .19025 1 0 Mshowa
.02381 .35548 m
.03006 .35548 L
s
[(0.25)] .01131 .35548 1 0 Mshowa
.02381 .43809 m
.03006 .43809 L
s
[(0.5)] .01131 .43809 1 0 Mshowa
.02381 .52071 m
.03006 .52071 L
s
[(0.75)] .01131 .52071 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04155 m
.02756 .04155 L
s
.02381 .05807 m
.02756 .05807 L
s
.02381 .0746 m
.02756 .0746 L
s
.02381 .09112 m
.02756 .09112 L
s
.02381 .12416 m
.02756 .12416 L
s
.02381 .14069 m
.02756 .14069 L
s
.02381 .15721 m
.02756 .15721 L
s
.02381 .17373 m
.02756 .17373 L
s
.02381 .20678 m
.02756 .20678 L
s
.02381 .2233 m
.02756 .2233 L
s
.02381 .23982 m
.02756 .23982 L
s
.02381 .25635 m
.02756 .25635 L
s
.02381 .28939 m
.02756 .28939 L
s
.02381 .30591 m
.02756 .30591 L
s
.02381 .32244 m
.02756 .32244 L
s
.02381 .33896 m
.02756 .33896 L
s
.02381 .372 m
.02756 .372 L
s
.02381 .38853 m
.02756 .38853 L
s
.02381 .40505 m
.02756 .40505 L
s
.02381 .42157 m
.02756 .42157 L
s
.02381 .45462 m
.02756 .45462 L
s
.02381 .47114 m
.02756 .47114 L
s
.02381 .48766 m
.02756 .48766 L
s
.02381 .50418 m
.02756 .50418 L
s
.02381 .53723 m
.02756 .53723 L
s
.02381 .55375 m
.02756 .55375 L
s
.02381 .57027 m
.02756 .57027 L
s
.02381 .5868 m
.02756 .5868 L
s
.02381 .00851 m
.02756 .00851 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell["\<\
Here is a way to change options for all the plots in the array. \
\
\>", "MathCaption",
  CellTags->{"S1.9.3", "3.15"}],

Cell[CellGroupData[{

Cell["Show[ % /. (Ticks -> Automatic) -> (Ticks -> None) ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .61803 L
s
0 .61803 m
1 .61803 L
s
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.398561 0.491346 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .39856 m
1 .39856 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .01472 m
.15382 .15139 L
.19174 .27775 L
.22736 .38303 L
.26161 .46958 L
.2807 .50991 L
.29806 .54088 L
.31631 .56702 L
.33316 .58501 L
.34152 .59168 L
.35039 .59711 L
.35499 .59926 L
.35929 .60085 L
.36401 .60214 L
.36667 .60266 L
.36792 .60285 L
.36909 .603 L
.37018 .60312 L
.37134 .60321 L
.37241 .60327 L
.37338 .6033 L
.37444 .60332 L
.37561 .60331 L
.37619 .60329 L
.37682 .60327 L
.37796 .6032 L
.37901 .60311 L
.38016 .60299 L
.38226 .60271 L
.3843 .60234 L
.38618 .60192 L
.39048 .60071 L
.39522 .59895 L
.40483 .59404 L
.41392 .58781 L
.42224 .58083 L
.44102 .56096 L
.47668 .51041 L
.51097 .45187 L
.54748 .38713 L
.58262 .33031 L
.60054 .30565 L
.61997 .28334 L
.62906 .27468 L
.63869 .26684 L
.64771 .26079 L
.65595 .25638 L
.66444 .25298 L
.66913 .25161 L
.67128 .2511 L
Mistroke
.67357 .25064 L
.67572 .25028 L
.67766 .25002 L
.6786 .24992 L
.67962 .24982 L
.68057 .24975 L
.68145 .24969 L
.68249 .24964 L
.68363 .24961 L
.68474 .2496 L
.68593 .24961 L
.68704 .24963 L
.68809 .24968 L
.68903 .24973 L
.69005 .24981 L
.69216 .25002 L
.69443 .25032 L
.69853 .25108 L
.70341 .25232 L
.70788 .25378 L
.7171 .25773 L
.7268 .26322 L
.7446 .2766 L
.76115 .29245 L
.79633 .33458 L
.83373 .38626 L
.86976 .43564 L
.90443 .47649 L
.922 .49306 L
.93131 .50046 L
.9413 .50726 L
.95073 .51252 L
.95934 .51633 L
.96348 .51781 L
.96799 .51916 L
.97619 .52091 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .27287 m
1 .27287 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.323031 0.477324 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.183713 0.419605 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .18371 m
1 .18371 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60326 L
.02729 .60318 L
.02846 .60307 L
.03053 .6028 L
.03279 .60239 L
.03527 .6018 L
.0379 .60103 L
.04262 .59924 L
.04749 .59686 L
.05205 .59414 L
.06244 .58623 L
.07305 .57575 L
.08274 .5641 L
.10458 .53119 L
.14429 .45151 L
.18248 .35892 L
.22313 .25533 L
.26226 .16264 L
.28223 .12146 L
.30384 .08336 L
.32471 .05395 L
.33464 .04272 L
.34391 .03392 L
.35375 .02637 L
.36273 .02113 L
.36785 .01884 L
.3727 .01714 L
.37518 .01644 L
.37782 .01583 L
.3792 .01557 L
.38072 .01532 L
.3821 .01513 L
.38339 .01498 L
.38453 .01488 L
.38574 .0148 L
.38643 .01476 L
.38709 .01474 L
.38831 .01472 L
.3896 .01472 L
.39079 .01475 L
.3921 .01482 L
.39276 .01486 L
.39349 .01492 L
.39579 .01517 L
.39827 .01555 L
.40274 .01651 L
.40833 .01822 L
.41364 .02033 L
Mistroke
.4236 .02558 L
.43321 .03214 L
.44344 .04062 L
.46184 .05938 L
.50348 .11424 L
.54359 .17477 L
.5822 .2303 L
.60178 .2547 L
.62325 .27711 L
.63313 .28565 L
.64371 .29343 L
.65363 .29938 L
.66279 .3037 L
.66764 .30551 L
.67299 .30713 L
.67837 .30835 L
.68131 .30885 L
.68407 .30921 L
.68654 .30944 L
.68778 .30952 L
.68849 .30956 L
.68913 .30959 L
.6903 .30962 L
.69154 .30964 L
.69268 .30964 L
.69377 .30962 L
.69504 .30958 L
.69567 .30955 L
.69638 .30951 L
.69878 .30932 L
.70013 .30918 L
.70158 .309 L
.70421 .30861 L
.70948 .30754 L
.71436 .30621 L
.72542 .30208 L
.73517 .29717 L
.74553 .29073 L
.78325 .25826 L
.82342 .21319 L
.86208 .16705 L
.90319 .12332 L
.92369 .10592 L
.94278 .09326 L
.95893 .08554 L
.96797 .08248 L
.97619 .08052 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.323031 0.97619 0.603319 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .27287 m
1 .27287 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["GraphicsArray", "MR"],
  " by default puts a narrow border around each of the plots in the array it \
gives. You can change the size of this border by setting the option ",
  StyleBox["GraphicsSpacing", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["h", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["v", "TI"],
  StyleBox["}", "MR"],
  ". The parameters ",
  StyleBox["h", "TI"],
  " and ",
  StyleBox["v", "TI"],
  " give the horizontal and vertical spacings to be used, as fractions of the \
width and height of the plots. "
}], "Text",
  CellTags->{"S1.9.3", "3.16"}],

Cell["\<\
This increases the horizontal spacing, but decreases the vertical \
spacing between the plots in the array. \
\>", "MathCaption",
  CellTags->{"S1.9.3", "3.17"}],

Cell[CellGroupData[{

Cell["Show[%, GraphicsSpacing -> {0.3, 0}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53742 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127957 0.47619 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .53742 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .53742 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .53742 L
s
0 .53742 m
1 .53742 L
s
1 0 m
1 .53742 L
s
0 0 m
1 0 L
1 .53742 L
0 .53742 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127957 0.437888 0.26871 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.398561 0.491346 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .39856 m
1 .39856 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .01472 m
.15382 .15139 L
.19174 .27775 L
.22736 .38303 L
.26161 .46958 L
.2807 .50991 L
.29806 .54088 L
.31631 .56702 L
.33316 .58501 L
.34152 .59168 L
.35039 .59711 L
.35499 .59926 L
.35929 .60085 L
.36401 .60214 L
.36667 .60266 L
.36792 .60285 L
.36909 .603 L
.37018 .60312 L
.37134 .60321 L
.37241 .60327 L
.37338 .6033 L
.37444 .60332 L
.37561 .60331 L
.37619 .60329 L
.37682 .60327 L
.37796 .6032 L
.37901 .60311 L
.38016 .60299 L
.38226 .60271 L
.3843 .60234 L
.38618 .60192 L
.39048 .60071 L
.39522 .59895 L
.40483 .59404 L
.41392 .58781 L
.42224 .58083 L
.44102 .56096 L
.47668 .51041 L
.51097 .45187 L
.54748 .38713 L
.58262 .33031 L
.60054 .30565 L
.61997 .28334 L
.62906 .27468 L
.63869 .26684 L
.64771 .26079 L
.65595 .25638 L
.66444 .25298 L
.66913 .25161 L
.67128 .2511 L
Mistroke
.67357 .25064 L
.67572 .25028 L
.67766 .25002 L
.6786 .24992 L
.67962 .24982 L
.68057 .24975 L
.68145 .24969 L
.68249 .24964 L
.68363 .24961 L
.68474 .2496 L
.68593 .24961 L
.68704 .24963 L
.68809 .24968 L
.68903 .24973 L
.69005 .24981 L
.69216 .25002 L
.69443 .25032 L
.69853 .25108 L
.70341 .25232 L
.70788 .25378 L
.7171 .25773 L
.7268 .26322 L
.7446 .2766 L
.76115 .29245 L
.79633 .33458 L
.83373 .38626 L
.86976 .43564 L
.90443 .47649 L
.922 .49306 L
.93131 .50046 L
.9413 .50726 L
.95073 .51252 L
.95934 .51633 L
.96348 .51781 L
.96799 .51916 L
.97619 .52091 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.562112 0.0127957 0.97619 0.26871 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .27287 m
1 .27287 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.0238095 0.26871 0.437888 0.524625 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.183713 0.419605 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .18371 m
1 .18371 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60326 L
.02729 .60318 L
.02846 .60307 L
.03053 .6028 L
.03279 .60239 L
.03527 .6018 L
.0379 .60103 L
.04262 .59924 L
.04749 .59686 L
.05205 .59414 L
.06244 .58623 L
.07305 .57575 L
.08274 .5641 L
.10458 .53119 L
.14429 .45151 L
.18248 .35892 L
.22313 .25533 L
.26226 .16264 L
.28223 .12146 L
.30384 .08336 L
.32471 .05395 L
.33464 .04272 L
.34391 .03392 L
.35375 .02637 L
.36273 .02113 L
.36785 .01884 L
.3727 .01714 L
.37518 .01644 L
.37782 .01583 L
.3792 .01557 L
.38072 .01532 L
.3821 .01513 L
.38339 .01498 L
.38453 .01488 L
.38574 .0148 L
.38643 .01476 L
.38709 .01474 L
.38831 .01472 L
.3896 .01472 L
.39079 .01475 L
.3921 .01482 L
.39276 .01486 L
.39349 .01492 L
.39579 .01517 L
.39827 .01555 L
.40274 .01651 L
.40833 .01822 L
.41364 .02033 L
Mistroke
.4236 .02558 L
.43321 .03214 L
.44344 .04062 L
.46184 .05938 L
.50348 .11424 L
.54359 .17477 L
.5822 .2303 L
.60178 .2547 L
.62325 .27711 L
.63313 .28565 L
.64371 .29343 L
.65363 .29938 L
.66279 .3037 L
.66764 .30551 L
.67299 .30713 L
.67837 .30835 L
.68131 .30885 L
.68407 .30921 L
.68654 .30944 L
.68778 .30952 L
.68849 .30956 L
.68913 .30959 L
.6903 .30962 L
.69154 .30964 L
.69268 .30964 L
.69377 .30962 L
.69504 .30958 L
.69567 .30955 L
.69638 .30951 L
.69878 .30932 L
.70013 .30918 L
.70158 .309 L
.70421 .30861 L
.70948 .30754 L
.71436 .30621 L
.72542 .30208 L
.73517 .29717 L
.74553 .29073 L
.78325 .25826 L
.82342 .21319 L
.86208 .16705 L
.90319 .12332 L
.92369 .10592 L
.94278 .09326 L
.95893 .08554 L
.96797 .08248 L
.97619 .08052 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.562112 0.26871 0.97619 0.524625 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.272868 0.330451 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .27287 m
1 .27287 L
s
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60327 L
.02729 .60321 L
.02846 .60312 L
.03053 .60291 L
.03279 .60259 L
.03527 .60212 L
.0379 .60151 L
.04262 .6001 L
.04749 .59823 L
.05205 .59609 L
.06244 .58986 L
.07305 .58161 L
.08274 .57243 L
.10458 .54652 L
.14429 .48376 L
.18248 .41085 L
.22313 .32927 L
.26226 .25627 L
.28223 .22384 L
.30384 .19384 L
.32471 .17068 L
.33464 .16183 L
.34391 .1549 L
.35375 .14896 L
.36273 .14483 L
.36785 .14303 L
.3727 .14169 L
.37518 .14114 L
.37782 .14066 L
.3792 .14045 L
.38072 .14025 L
.3821 .1401 L
.38339 .13999 L
.38453 .13991 L
.38574 .13984 L
.38643 .13981 L
.38709 .1398 L
.38831 .13978 L
.3896 .13978 L
.39079 .13981 L
.3921 .13986 L
.39276 .13989 L
.39349 .13994 L
.39579 .14014 L
.39827 .14044 L
.40274 .14119 L
.40833 .14253 L
.41364 .1442 L
Mistroke
.4236 .14833 L
.43321 .1535 L
.44344 .16018 L
.46184 .17495 L
.50348 .21815 L
.54359 .26582 L
.5822 .30955 L
.60178 .32877 L
.62325 .34642 L
.63313 .35314 L
.64371 .35927 L
.65363 .36396 L
.66279 .36736 L
.66764 .36879 L
.67299 .37006 L
.67837 .37103 L
.68131 .37142 L
.68407 .3717 L
.68654 .37188 L
.68778 .37195 L
.68849 .37198 L
.68913 .372 L
.6903 .37203 L
.69154 .37204 L
.69268 .37204 L
.69377 .37202 L
.69504 .37199 L
.69567 .37197 L
.69638 .37193 L
.69878 .37179 L
.70013 .37168 L
.70158 .37154 L
.70421 .37123 L
.70948 .37038 L
.71436 .36934 L
.72542 .36608 L
.73517 .36221 L
.74553 .35714 L
.78325 .33158 L
.82342 .29608 L
.86208 .25974 L
.90319 .22531 L
.92369 .21161 L
.94278 .20163 L
.95893 .19555 L
.96797 .19315 L
.97619 .1916 L
Mfstroke
.11905 .01472 m
.15382 .10664 L
.19174 .19162 L
.22736 .26242 L
.26161 .32063 L
.2807 .34775 L
.29806 .36858 L
.31631 .38616 L
.33316 .39826 L
.34152 .40275 L
.35039 .4064 L
.35499 .40784 L
.35929 .40892 L
.36401 .40979 L
.36667 .41013 L
.36792 .41026 L
.36909 .41036 L
.37018 .41044 L
.37134 .4105 L
.37241 .41054 L
.37338 .41057 L
.37444 .41058 L
.37561 .41057 L
.37619 .41056 L
.37682 .41054 L
.37796 .4105 L
.37901 .41044 L
.38016 .41036 L
.38226 .41016 L
.3843 .40992 L
.38618 .40964 L
.39048 .40882 L
.39522 .40764 L
.40483 .40433 L
.41392 .40015 L
.42224 .39545 L
.44102 .38209 L
.47668 .34809 L
.51097 .30872 L
.54748 .26518 L
.58262 .22697 L
.60054 .21038 L
.61997 .19537 L
.62906 .18955 L
.63869 .18428 L
.64771 .18021 L
.65595 .17725 L
.66444 .17496 L
.66913 .17404 L
.67128 .17369 L
Mistroke
.67357 .17338 L
.67572 .17314 L
.67766 .17297 L
.6786 .1729 L
.67962 .17284 L
.68057 .17279 L
.68145 .17275 L
.68249 .17272 L
.68363 .17269 L
.68474 .17268 L
.68593 .17269 L
.68704 .17271 L
.68809 .17274 L
.68903 .17278 L
.69005 .17283 L
.69216 .17297 L
.69443 .17317 L
.69853 .17368 L
.70341 .17451 L
.70788 .17549 L
.7171 .17816 L
.7268 .18185 L
.7446 .19085 L
.76115 .20151 L
.79633 .22984 L
.83373 .26459 L
.86976 .29781 L
.90443 .32528 L
.922 .33642 L
.93131 .3414 L
.9413 .34597 L
.95073 .34951 L
.95934 .35207 L
.96348 .35307 L
.96799 .35397 L
.97619 .35516 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "When you make a plot, ",
  StyleBox["Mathematica", "TI"],
  " saves the list of points it used, together with some other information. \
Using what is saved, you can redraw plots in many different ways with ",
  StyleBox["Show", "MR"],
  ". However, you should realize that no matter what options you specify, ",
  StyleBox["Show", "MR"],
  " still has the same basic set of points to work with. So, for example, if \
you set the options so that ",
  StyleBox["Mathematica", "TI"],
  " displays a small portion of your original plot magnified, you will \
probably be able to see the individual sample points that ",
  StyleBox["Plot", "MR"],
  " used. Options like ",
  StyleBox["PlotPoints", "MR"],
  " can only be set in the original ",
  StyleBox["Plot", "MR"],
  " command itself. (",
  StyleBox["Mathematica", "TI"],
  " always plots the actual points it has; it avoids using smoothed or \
splined curves, which can give misleading results in mathematical graphics.) \
"
}], "Text",
  CellTags->{"S1.9.3", "3.18"}],

Cell["Here is a simple plot. ", "MathCaption",
  CellTags->{"S1.9.3", "3.19"}],

Cell[CellGroupData[{

Cell["Plot[Cos[x], {x, -Pi, Pi}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.151576 0.309018 0.294303 [
[.04527 .29652 -6 -9 ]
[.04527 .29652 6 0 ]
[.19685 .29652 -6 -9 ]
[.19685 .29652 6 0 ]
[.34842 .29652 -6 -9 ]
[.34842 .29652 6 0 ]
[.65158 .29652 -3 -9 ]
[.65158 .29652 3 0 ]
[.80315 .29652 -3 -9 ]
[.80315 .29652 3 0 ]
[.95473 .29652 -3 -9 ]
[.95473 .29652 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .30902 m
.04527 .31527 L
s
[(-3)] .04527 .29652 0 1 Mshowa
.19685 .30902 m
.19685 .31527 L
s
[(-2)] .19685 .29652 0 1 Mshowa
.34842 .30902 m
.34842 .31527 L
s
[(-1)] .34842 .29652 0 1 Mshowa
.65158 .30902 m
.65158 .31527 L
s
[(1)] .65158 .29652 0 1 Mshowa
.80315 .30902 m
.80315 .31527 L
s
[(2)] .80315 .29652 0 1 Mshowa
.95473 .30902 m
.95473 .31527 L
s
[(3)] .95473 .29652 0 1 Mshowa
.125 Mabswid
.07559 .30902 m
.07559 .31277 L
s
.1059 .30902 m
.1059 .31277 L
s
.13622 .30902 m
.13622 .31277 L
s
.16653 .30902 m
.16653 .31277 L
s
.22716 .30902 m
.22716 .31277 L
s
.25748 .30902 m
.25748 .31277 L
s
.28779 .30902 m
.28779 .31277 L
s
.31811 .30902 m
.31811 .31277 L
s
.37874 .30902 m
.37874 .31277 L
s
.40905 .30902 m
.40905 .31277 L
s
.43937 .30902 m
.43937 .31277 L
s
.46968 .30902 m
.46968 .31277 L
s
.53032 .30902 m
.53032 .31277 L
s
.56063 .30902 m
.56063 .31277 L
s
.59095 .30902 m
.59095 .31277 L
s
.62126 .30902 m
.62126 .31277 L
s
.68189 .30902 m
.68189 .31277 L
s
.71221 .30902 m
.71221 .31277 L
s
.74252 .30902 m
.74252 .31277 L
s
.77284 .30902 m
.77284 .31277 L
s
.83347 .30902 m
.83347 .31277 L
s
.86378 .30902 m
.86378 .31277 L
s
.8941 .30902 m
.8941 .31277 L
s
.92441 .30902 m
.92441 .31277 L
s
.01496 .30902 m
.01496 .31277 L
s
.98504 .30902 m
.98504 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01475 L
.02729 .01479 L
.02846 .01485 L
.03053 .015 L
.03279 .01523 L
.03527 .01556 L
.0379 .01599 L
.04262 .01698 L
.04749 .0183 L
.05205 .01981 L
.06244 .02422 L
.07305 .03011 L
.08274 .03668 L
.10458 .05552 L
.14429 .10289 L
.18248 .16177 L
.22313 .23454 L
.26226 .3097 L
.30384 .3894 L
.34391 .46058 L
.38246 .51918 L
.402 .54393 L
.42346 .56659 L
.44388 .58338 L
.45301 .58929 L
.46295 .59457 L
.46838 .59694 L
.4734 .5988 L
.4781 .60026 L
.4833 .60154 L
.48553 .60198 L
.48794 .60239 L
.49002 .60268 L
.4923 .60294 L
.49473 .60314 L
.49605 .60322 L
.49728 .60327 L
.49844 .6033 L
.49949 .60332 L
.50071 .60332 L
.50186 .6033 L
.50301 .60326 L
.50425 .60321 L
.50542 .60313 L
.50648 .60305 L
.5091 .60279 L
.51158 .60246 L
.5165 .60158 L
Mistroke
.52187 .60026 L
.53144 .59701 L
.54032 .59297 L
.56088 .5799 L
.5795 .56376 L
.61962 .51633 L
.65822 .45702 L
.69928 .38356 L
.73882 .30761 L
.77684 .2346 L
.81732 .1621 L
.85628 .1021 L
.87613 .07654 L
.89769 .0533 L
.91843 .03582 L
.92832 .02927 L
.93759 .02421 L
.94643 .02037 L
.95595 .01733 L
.9611 .01617 L
.96369 .01572 L
.96652 .01531 L
.96894 .01505 L
.9703 .01494 L
.97153 .01485 L
.97268 .01479 L
.97393 .01475 L
.97511 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.9.3"]
}, Open  ]],

Cell[TextData[{
  "This shows a small region of the plot in a magnified form. At this \
resolution, you can see the individual line segments that were produced by \
the original ",
  StyleBox["Plot", "MR"],
  " command. "
}], "MathCaption",
  CellTags->{"S1.9.3", "3.20"}],

Cell[CellGroupData[{

Cell["Show[%, PlotRange -> {{0, .3}, {.92, 1}}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.9.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.68629e-18 3.33333 -7.10739 7.72542 [
[.16667 .60553 -12 -9 ]
[.16667 .60553 12 0 ]
[.33333 .60553 -9 -9 ]
[.33333 .60553 9 0 ]
[.5 .60553 -12 -9 ]
[.5 .60553 12 0 ]
[.66667 .60553 -9 -9 ]
[.66667 .60553 9 0 ]
[.83333 .60553 -12 -9 ]
[.83333 .60553 12 0 ]
[-0.0125 0 -24 -4.5 ]
[-0.0125 0 0 4.5 ]
[-0.0125 .07725 -24 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -24 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -24 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -24 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -24 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -24 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -24 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .62428 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .61803 m
.16667 .62428 L
s
[(0.05)] .16667 .60553 0 1 Mshowa
.33333 .61803 m
.33333 .62428 L
s
[(0.1)] .33333 .60553 0 1 Mshowa
.5 .61803 m
.5 .62428 L
s
[(0.15)] .5 .60553 0 1 Mshowa
.66667 .61803 m
.66667 .62428 L
s
[(0.2)] .66667 .60553 0 1 Mshowa
.83333 .61803 m
.83333 .62428 L
s
[(0.25)] .83333 .60553 0 1 Mshowa
.125 Mabswid
.03333 .61803 m
.03333 .62178 L
s
.06667 .61803 m
.06667 .62178 L
s
.1 .61803 m
.1 .62178 L
s
.13333 .61803 m
.13333 .62178 L
s
.2 .61803 m
.2 .62178 L
s
.23333 .61803 m
.23333 .62178 L
s
.26667 .61803 m
.26667 .62178 L
s
.3 .61803 m
.3 .62178 L
s
.36667 .61803 m
.36667 .62178 L
s
.4 .61803 m
.4 .62178 L
s
.43333 .61803 m
.43333 .62178 L
s
.46667 .61803 m
.46667 .62178 L
s
.53333 .61803 m
.53333 .62178 L
s
.56667 .61803 m
.56667 .62178 L
s
.6 .61803 m
.6 .62178 L
s
.63333 .61803 m
.63333 .62178 L
s
.7 .61803 m
.7 .62178 L
s
.73333 .61803 m
.73333 .62178 L
s
.76667 .61803 m
.76667 .62178 L
s
.8 .61803 m
.8 .62178 L
s
.86667 .61803 m
.86667 .62178 L
s
.9 .61803 m
.9 .62178 L
s
.93333 .61803 m
.93333 .62178 L
s
.96667 .61803 m
.96667 .62178 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
0 0 m
.00625 0 L
s
[(0.92)] -0.0125 0 1 0 Mshowa
0 .07725 m
.00625 .07725 L
s
[(0.93)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(0.94)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(0.95)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0.96)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(0.97)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(0.98)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(0.99)] -0.0125 .54078 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .61797 m
.01558 .61795 L
.0408 .61746 L
.06615 .61651 L
.09339 .615 L
.1191 .6131 L
.1426 .61097 L
.20004 .60413 L
.25458 .59551 L
.36287 .5723 L
.48092 .53777 L
.69148 .4524 L
.88671 .3463 L
s
.88671 .3463 m
1 .26034 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.9.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.9.4 Advanced Topic: Manipulating Options", "Subsection",
  CellTags->{"S1.9.4", "4.1"}],

Cell[TextData[{
  "There are a number of functions built into ",
  StyleBox["Mathematica", "TI"],
  " which, like ",
  StyleBox["Plot", "MR"],
  ", have various options you can set. ",
  StyleBox["Mathematica", "TI"],
  " provides some general mechanisms for handling such options. "
}], "Text",
  CellTags->{"S1.9.4", "4.2"}],

Cell[TextData[{
  "If you do not give a specific setting for an option to a function like ",
  StyleBox["Plot", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will automatically use a default value for the option. The function ",
  StyleBox["Options[", "MR"],
  StyleBox["function", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["option", "TI"],
  StyleBox["]", "MR"],
  " allows you to find out the default value for a particular option. You can \
reset the default using ",
  StyleBox["SetOptions[", "MR"],
  StyleBox["function", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["option", "TI"],
  StyleBox["->", "MR"],
  StyleBox["value", "TI"],
  StyleBox["]", "MR"],
  ". Note that if you do this, the default value you have given will stay \
until you explicitly change it. "
}], "Text",
  CellTags->{"S1.9.4", "4.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["function", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "give a list of the current default settings for all options "]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["function", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the default setting for a particular option "]},
          {Cell[TextData[{
              StyleBox["SetOptions[", "MR"],
              StyleBox["function", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["->", "MR"],
              StyleBox["value", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["reset defaults "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.4"],

Cell["Manipulating default settings for options. ", "Caption",
  CellTags->"S1.9.4"],

Cell[TextData[{
  "Here is the default setting for the ",
  StyleBox["PlotRange", "MR"],
  " option of ",
  StyleBox["Plot", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.4", "4.4"}],

Cell[CellGroupData[{

Cell["Options[Plot, PlotRange]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.9.4"],

Cell[BoxData[
    \({PlotRange \[Rule] Automatic}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.9.4"]
}, Open  ]],

Cell[TextData[{
  "This resets the default for the ",
  StyleBox["PlotRange", "MR"],
  " option. The semicolon stops ",
  StyleBox["Mathematica", "TI"],
  " from printing out the rather long list of options for ",
  StyleBox["Plot", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.4", "4.5"}],

Cell["SetOptions[Plot, PlotRange->All] ;", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.9.4"],

Cell[TextData[{
  "Until you explicitly reset it, the default for the ",
  StyleBox["PlotRange", "MR"],
  " option will now be ",
  StyleBox["All", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.4", "4.6"}],

Cell[CellGroupData[{

Cell["Options[Plot, PlotRange]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.9.4"],

Cell[BoxData[
    \({PlotRange \[Rule] All}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.9.4"]
}, Open  ]],

Cell[TextData[{
  "The graphics objects that you get from ",
  StyleBox["Plot", "MR"],
  " or ",
  StyleBox["Show", "MR"],
  " store information on the options they use. You can get this information \
by applying the ",
  StyleBox["Options", "MR"],
  " function to these graphics objects. "
}], "Text",
  CellTags->{"S1.9.4", "4.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["plot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["show all the options used for a particular plot "]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["plot", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["show the setting for a specific option "]},
          {Cell[TextData[{
              StyleBox["AbsoluteOptions[", "MR"],
              StyleBox["plot", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["option", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "show the absolute form used for a specific option, even if the \
setting for the option is ",
              StyleBox["Automatic", "MR"],
              " or ",
              StyleBox["All", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.4"],

Cell["Getting information on options used in plots. ", "Caption",
  CellTags->"S1.9.4"],

Cell["Here is a plot, with default settings for all options. ", "MathCaption",
  CellTags->{"S1.9.4", "4.8"}],

Cell[CellGroupData[{

Cell["g = Plot[SinIntegral[x], {x, 0, 20}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.9.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0476191 0.0147148 0.317832 [
[.2619 .00221 -3 -9 ]
[.2619 .00221 3 0 ]
[.5 .00221 -6 -9 ]
[.5 .00221 6 0 ]
[.7381 .00221 -6 -9 ]
[.7381 .00221 6 0 ]
[.97619 .00221 -6 -9 ]
[.97619 .00221 6 0 ]
[.01131 .09417 -24 -4.5 ]
[.01131 .09417 0 4.5 ]
[.01131 .17363 -18 -4.5 ]
[.01131 .17363 0 4.5 ]
[.01131 .25309 -24 -4.5 ]
[.01131 .25309 0 4.5 ]
[.01131 .33255 -6 -4.5 ]
[.01131 .33255 0 4.5 ]
[.01131 .412 -24 -4.5 ]
[.01131 .412 0 4.5 ]
[.01131 .49146 -18 -4.5 ]
[.01131 .49146 0 4.5 ]
[.01131 .57092 -24 -4.5 ]
[.01131 .57092 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01471 m
.2619 .02096 L
s
[(5)] .2619 .00221 0 1 Mshowa
.5 .01471 m
.5 .02096 L
s
[(10)] .5 .00221 0 1 Mshowa
.7381 .01471 m
.7381 .02096 L
s
[(15)] .7381 .00221 0 1 Mshowa
.97619 .01471 m
.97619 .02096 L
s
[(20)] .97619 .00221 0 1 Mshowa
.125 Mabswid
.07143 .01471 m
.07143 .01846 L
s
.11905 .01471 m
.11905 .01846 L
s
.16667 .01471 m
.16667 .01846 L
s
.21429 .01471 m
.21429 .01846 L
s
.30952 .01471 m
.30952 .01846 L
s
.35714 .01471 m
.35714 .01846 L
s
.40476 .01471 m
.40476 .01846 L
s
.45238 .01471 m
.45238 .01846 L
s
.54762 .01471 m
.54762 .01846 L
s
.59524 .01471 m
.59524 .01846 L
s
.64286 .01471 m
.64286 .01846 L
s
.69048 .01471 m
.69048 .01846 L
s
.78571 .01471 m
.78571 .01846 L
s
.83333 .01471 m
.83333 .01846 L
s
.88095 .01471 m
.88095 .01846 L
s
.92857 .01471 m
.92857 .01846 L
s
.25 Mabswid
0 .01471 m
1 .01471 L
s
.02381 .09417 m
.03006 .09417 L
s
[(0.25)] .01131 .09417 1 0 Mshowa
.02381 .17363 m
.03006 .17363 L
s
[(0.5)] .01131 .17363 1 0 Mshowa
.02381 .25309 m
.03006 .25309 L
s
[(0.75)] .01131 .25309 1 0 Mshowa
.02381 .33255 m
.03006 .33255 L
s
[(1)] .01131 .33255 1 0 Mshowa
.02381 .412 m
.03006 .412 L
s
[(1.25)] .01131 .412 1 0 Mshowa
.02381 .49146 m
.03006 .49146 L
s
[(1.5)] .01131 .49146 1 0 Mshowa
.02381 .57092 m
.03006 .57092 L
s
[(1.75)] .01131 .57092 1 0 Mshowa
.125 Mabswid
.02381 .03061 m
.02756 .03061 L
s
.02381 .0465 m
.02756 .0465 L
s
.02381 .06239 m
.02756 .06239 L
s
.02381 .07828 m
.02756 .07828 L
s
.02381 .11006 m
.02756 .11006 L
s
.02381 .12596 m
.02756 .12596 L
s
.02381 .14185 m
.02756 .14185 L
s
.02381 .15774 m
.02756 .15774 L
s
.02381 .18952 m
.02756 .18952 L
s
.02381 .20541 m
.02756 .20541 L
s
.02381 .22131 m
.02756 .22131 L
s
.02381 .2372 m
.02756 .2372 L
s
.02381 .26898 m
.02756 .26898 L
s
.02381 .28487 m
.02756 .28487 L
s
.02381 .30076 m
.02756 .30076 L
s
.02381 .31665 m
.02756 .31665 L
s
.02381 .34844 m
.02756 .34844 L
s
.02381 .36433 m
.02756 .36433 L
s
.02381 .38022 m
.02756 .38022 L
s
.02381 .39611 m
.02756 .39611 L
s
.02381 .4279 m
.02756 .4279 L
s
.02381 .44379 m
.02756 .44379 L
s
.02381 .45968 m
.02756 .45968 L
s
.02381 .47557 m
.02756 .47557 L
s
.02381 .50735 m
.02756 .50735 L
s
.02381 .52325 m
.02756 .52325 L
s
.02381 .53914 m
.02756 .53914 L
s
.02381 .55503 m
.02756 .55503 L
s
.02381 .58681 m
.02756 .58681 L
s
.02381 .6027 m
.02756 .6027 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
.5 Mabswid
.02381 .01472 m
.06244 .26334 L
.08255 .37513 L
.10458 .47473 L
.11448 .51046 L
.12507 .54212 L
.13506 .56573 L
.14415 .582 L
.14898 .58869 L
.15411 .59434 L
.15848 .59803 L
.16095 .59967 L
.1633 .60094 L
.16459 .60152 L
.166 .60205 L
.16729 .60246 L
.16847 .60276 L
.16986 .60303 L
.17063 .60314 L
.17135 .60322 L
.17264 .60331 L
.17336 .60332 L
.17403 .60331 L
.17523 .60325 L
.17636 .60313 L
.17759 .60294 L
.17892 .60266 L
.18162 .60187 L
.18408 .6009 L
.18889 .59836 L
.19399 .59478 L
.20317 .5864 L
.22393 .5607 L
.26168 .50762 L
.28102 .48577 L
.2919 .47664 L
.29673 .47343 L
.30188 .47059 L
.30702 .46838 L
.31168 .46691 L
.31393 .46638 L
.31512 .46615 L
.31638 .46595 L
.31747 .46579 L
.31868 .46566 L
.31978 .46557 L
.3208 .4655 L
.32208 .46546 L
.32281 .46545 L
.32348 .46545 L
Mistroke
.32471 .46548 L
.32602 .46555 L
.32731 .46565 L
.32852 .46578 L
.33078 .46611 L
.33347 .46664 L
.33594 .46725 L
.3415 .46907 L
.35127 .47359 L
.36037 .47912 L
.38104 .49493 L
.42001 .52688 L
.43021 .53366 L
.44129 .53963 L
.44636 .54181 L
.45175 .54372 L
.45635 .54501 L
.45877 .54556 L
.46142 .54606 L
.46398 .54645 L
.46635 .54671 L
.46767 .54682 L
.46886 .5469 L
.46952 .54694 L
.47024 .54697 L
.47154 .547 L
.47266 .54701 L
.47388 .54699 L
.47516 .54696 L
.47636 .5469 L
.47748 .54683 L
.4785 .54675 L
.4808 .54651 L
.48347 .54615 L
.48593 .54572 L
.49152 .54445 L
.49644 .54301 L
.50167 .54117 L
.52112 .53202 L
.53939 .52136 L
.55785 .51026 L
.56831 .50443 L
.57805 .49961 L
.58853 .49527 L
.59806 .49224 L
.6033 .49098 L
.60826 .49007 L
.61098 .48968 L
.61348 .4894 L
.61624 .48917 L
Mistroke
.61763 .48909 L
.61837 .48905 L
.61915 .48902 L
.62045 .48899 L
.62164 .48897 L
.62238 .48897 L
.62307 .48897 L
.62436 .489 L
.62559 .48903 L
.62673 .48908 L
.62798 .48916 L
.6293 .48925 L
.63159 .48945 L
.63372 .4897 L
.63858 .49042 L
.64385 .49148 L
.64866 .49267 L
.65946 .49604 L
.69933 .51351 L
.71756 .52168 L
.72794 .52572 L
.73768 .52891 L
.7472 .53134 L
.75256 .53238 L
.75747 .53312 L
.75983 .5334 L
.76236 .53364 L
.76381 .53375 L
.76513 .53384 L
.76638 .53391 L
.76771 .53397 L
.76836 .53399 L
.76909 .53401 L
.77037 .53403 L
.77108 .53404 L
.77186 .53404 L
.77258 .53404 L
.77325 .53403 L
.77453 .53401 L
.77526 .53399 L
.77593 .53396 L
.77848 .53384 L
.77977 .53376 L
.78114 .53366 L
.78358 .53343 L
.78908 .53274 L
.79384 .53195 L
.79906 .53089 L
.81768 .52569 L
.85818 .51061 L
Mistroke
.87687 .50428 L
.88671 .50159 L
.89716 .49937 L
.90243 .49853 L
.90522 .49817 L
.90823 .49784 L
.91099 .4976 L
.91351 .49743 L
.91472 .49736 L
.91604 .4973 L
.91729 .49726 L
.91845 .49723 L
.91972 .4972 L
.92043 .4972 L
.92109 .49719 L
.92229 .4972 L
.92356 .49721 L
.92471 .49723 L
.92577 .49726 L
.92694 .49731 L
.9282 .49736 L
.93099 .49753 L
.93363 .49774 L
.93859 .49827 L
.94309 .49888 L
.94806 .49972 L
.95812 .50184 L
.97619 .50679 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.9.4"]
}, Open  ]],

Cell[TextData[{
  "The setting used for the ",
  StyleBox["PlotRange", "MR"],
  " option was ",
  StyleBox["All", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.4", "4.9"}],

Cell[CellGroupData[{

Cell["Options[g, PlotRange]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.9.4"],

Cell[BoxData[
    \({PlotRange \[Rule] All}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.9.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["AbsoluteOptions", "MR"],
  " gives the ",
  StyleBox["absolute", "TI"],
  " automatically chosen values used for ",
  StyleBox["PlotRange", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.4", "4.10"}],

Cell[CellGroupData[{

Cell["AbsoluteOptions[g, PlotRange]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.9.4"],

Cell[BoxData[
    \({PlotRange \[Rule] {{\(-0.499999125`\), 
            20.499999125`}, {\(-0.046297568292173394`\), 
            1.8982352999791046`}}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.9.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.9.5 Contour and Density Plots", "Subsection",
  CellTags->{"S1.9.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ContourPlot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a contour plot of ",
              StyleBox["f", "TI"],
              " as a function of ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DensityPlot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a density plot of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.5"],

Cell["Contour and density plots. ", "Caption",
  CellTags->"S1.9.5"],

Cell[TextData[{
  "This gives a contour plot of the function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "sin", 
          RowBox[{"(", 
            StyleBox["y",
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.5", "5.2"}],

Cell[CellGroupData[{

Cell["ContourPlot[Sin[x] Sin[y], {x, -2, 2}, {y, -2, 2}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.9.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.240385 0.5 0.240385 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -12 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-2)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.6 g
.01923 .47485 m
.05929 .47632 L
.09936 .47703 L
.13942 .47708 L
.17949 .47648 L
.21955 .47513 L
.25962 .47281 L
.29968 .46907 L
.33974 .46293 L
.35351 .45994 L
.37981 .45207 L
.41987 .42921 L
.42921 .41987 L
.45207 .37981 L
.45994 .35351 L
.46293 .33974 L
.46907 .29968 L
.47281 .25962 L
.47513 .21955 L
.47648 .17949 L
.47708 .13942 L
.47703 .09936 L
.47632 .05929 L
.47485 .01923 L
.01923 .01923 L
F
0 g
.01923 .47485 m
.05929 .47632 L
.09936 .47703 L
.13942 .47708 L
.17949 .47648 L
.21955 .47513 L
.25962 .47281 L
.29968 .46907 L
.33974 .46293 L
.35351 .45994 L
.37981 .45207 L
.41987 .42921 L
.42921 .41987 L
.45207 .37981 L
.45994 .35351 L
.46293 .33974 L
.46907 .29968 L
.47281 .25962 L
.47513 .21955 L
.47648 .17949 L
.47708 .13942 L
.47703 .09936 L
.47632 .05929 L
.47485 .01923 L
s
.4 g
.01923 .52515 m
.05929 .52368 L
.09936 .52297 L
.13942 .52292 L
.17949 .52352 L
.21955 .52487 L
.25962 .52719 L
.29968 .53093 L
.33974 .53707 L
.35351 .54006 L
.37981 .54793 L
.41987 .57079 L
.42921 .58013 L
.45207 .62019 L
.45994 .64649 L
.46293 .66026 L
.46907 .70032 L
.47281 .74038 L
.47513 .78045 L
.47648 .82051 L
.47708 .86058 L
.47703 .90064 L
.47632 .94071 L
.47485 .98077 L
.01923 .98077 L
F
0 g
.01923 .52515 m
.05929 .52368 L
.09936 .52297 L
.13942 .52292 L
.17949 .52352 L
.21955 .52487 L
.25962 .52719 L
.29968 .53093 L
.33974 .53707 L
.35351 .54006 L
.37981 .54793 L
.41987 .57079 L
.42921 .58013 L
.45207 .62019 L
.45994 .64649 L
.46293 .66026 L
.46907 .70032 L
.47281 .74038 L
.47513 .78045 L
.47648 .82051 L
.47708 .86058 L
.47703 .90064 L
.47632 .94071 L
.47485 .98077 L
s
.7 g
.01923 .42339 m
.05929 .42801 L
.09936 .43022 L
.13942 .43037 L
.17949 .42849 L
.21955 .42426 L
.24648 .41987 L
.25962 .41697 L
.29968 .40503 L
.33974 .3849 L
.34704 .37981 L
.37981 .34704 L
.3849 .33974 L
.40503 .29968 L
.41697 .25962 L
.41987 .24648 L
.42426 .21955 L
.42849 .17949 L
.43037 .13942 L
.43022 .09936 L
.42801 .05929 L
.42339 .01923 L
.01923 .01923 L
F
0 g
.01923 .42339 m
.05929 .42801 L
.09936 .43022 L
.13942 .43037 L
.17949 .42849 L
.21955 .42426 L
.24648 .41987 L
.25962 .41697 L
.29968 .40503 L
.33974 .3849 L
.34704 .37981 L
.37981 .34704 L
.3849 .33974 L
.40503 .29968 L
.41697 .25962 L
.41987 .24648 L
.42426 .21955 L
.42849 .17949 L
.43037 .13942 L
.43022 .09936 L
.42801 .05929 L
.42339 .01923 L
s
.3 g
.01923 .57661 m
.05929 .57199 L
.09936 .56978 L
.13942 .56963 L
.17949 .57151 L
.21955 .57574 L
.24648 .58013 L
.25962 .58303 L
.29968 .59497 L
.33974 .6151 L
.34704 .62019 L
.37981 .65296 L
.3849 .66026 L
.40503 .70032 L
.41697 .74038 L
.41987 .75352 L
.42426 .78045 L
.42849 .82051 L
.43037 .86058 L
.43022 .90064 L
.42801 .94071 L
.42339 .98077 L
.01923 .98077 L
F
0 g
.01923 .57661 m
.05929 .57199 L
.09936 .56978 L
.13942 .56963 L
.17949 .57151 L
.21955 .57574 L
.24648 .58013 L
.25962 .58303 L
.29968 .59497 L
.33974 .6151 L
.34704 .62019 L
.37981 .65296 L
.3849 .66026 L
.40503 .70032 L
.41697 .74038 L
.41987 .75352 L
.42426 .78045 L
.42849 .82051 L
.43037 .86058 L
.43022 .90064 L
.42801 .94071 L
.42339 .98077 L
s
.8 g
.01923 .36795 m
.05929 .37644 L
.08932 .37981 L
.09936 .38045 L
.13942 .38073 L
.15549 .37981 L
.17949 .3773 L
.21955 .36957 L
.25962 .3559 L
.28967 .33974 L
.29968 .33261 L
.33261 .29968 L
.33974 .28967 L
.3559 .25962 L
.36957 .21955 L
.3773 .17949 L
.37981 .15549 L
.38073 .13942 L
.38045 .09936 L
.37981 .08932 L
.37644 .05929 L
.36795 .01923 L
.01923 .01923 L
F
0 g
.01923 .36795 m
.05929 .37644 L
.08932 .37981 L
.09936 .38045 L
.13942 .38073 L
.15549 .37981 L
.17949 .3773 L
.21955 .36957 L
.25962 .3559 L
.28967 .33974 L
.29968 .33261 L
.33261 .29968 L
.33974 .28967 L
.3559 .25962 L
.36957 .21955 L
.3773 .17949 L
.37981 .15549 L
.38073 .13942 L
.38045 .09936 L
.37981 .08932 L
.37644 .05929 L
.36795 .01923 L
s
.2 g
.01923 .63205 m
.05929 .62356 L
.08932 .62019 L
.09936 .61955 L
.13942 .61927 L
.15549 .62019 L
.17949 .6227 L
.21955 .63043 L
.25962 .6441 L
.28967 .66026 L
.29968 .66739 L
.33261 .70032 L
.33974 .71033 L
.3559 .74038 L
.36957 .78045 L
.3773 .82051 L
.37981 .84451 L
.38073 .86058 L
.38045 .90064 L
.37981 .91068 L
.37644 .94071 L
.36795 .98077 L
.01923 .98077 L
F
0 g
.01923 .63205 m
.05929 .62356 L
.08932 .62019 L
.09936 .61955 L
.13942 .61927 L
.15549 .62019 L
.17949 .6227 L
.21955 .63043 L
.25962 .6441 L
.28967 .66026 L
.29968 .66739 L
.33261 .70032 L
.33974 .71033 L
.3559 .74038 L
.36957 .78045 L
.3773 .82051 L
.37981 .84451 L
.38073 .86058 L
.38045 .90064 L
.37981 .91068 L
.37644 .94071 L
.36795 .98077 L
s
.9 g
.01923 .30291 m
.05929 .31756 L
.09936 .32427 L
.13942 .32472 L
.17949 .31902 L
.21955 .30575 L
.23228 .29968 L
.25962 .28123 L
.28123 .25962 L
.29968 .23228 L
.30575 .21955 L
.31902 .17949 L
.32472 .13942 L
.32427 .09936 L
.31756 .05929 L
.30291 .01923 L
.01923 .01923 L
F
0 g
.01923 .30291 m
.05929 .31756 L
.09936 .32427 L
.13942 .32472 L
.17949 .31902 L
.21955 .30575 L
.23228 .29968 L
.25962 .28123 L
.28123 .25962 L
.29968 .23228 L
.30575 .21955 L
.31902 .17949 L
.32472 .13942 L
.32427 .09936 L
.31756 .05929 L
.30291 .01923 L
s
.1 g
.01923 .69709 m
.05929 .68244 L
.09936 .67573 L
.13942 .67528 L
.17949 .68098 L
.21955 .69425 L
.23228 .70032 L
.25962 .71877 L
.28123 .74038 L
.29968 .76772 L
.30575 .78045 L
.31902 .82051 L
.32472 .86058 L
.32427 .90064 L
.31756 .94071 L
.30291 .98077 L
.01923 .98077 L
F
0 g
.01923 .69709 m
.05929 .68244 L
.09936 .67573 L
.13942 .67528 L
.17949 .68098 L
.21955 .69425 L
.23228 .70032 L
.25962 .71877 L
.28123 .74038 L
.29968 .76772 L
.30575 .78045 L
.31902 .82051 L
.32472 .86058 L
.32427 .90064 L
.31756 .94071 L
.30291 .98077 L
s
1 g
.01923 .20856 m
.0317 .21955 L
.05929 .23935 L
.09936 .25211 L
.13942 .25292 L
.17949 .24224 L
.21462 .21955 L
.21955 .21462 L
.24224 .17949 L
.25292 .13942 L
.25211 .09936 L
.23935 .05929 L
.21955 .0317 L
.20856 .01923 L
.01923 .01923 L
F
0 g
.01923 .20856 m
.0317 .21955 L
.05929 .23935 L
.09936 .25211 L
.13942 .25292 L
.17949 .24224 L
.21462 .21955 L
.21955 .21462 L
.24224 .17949 L
.25292 .13942 L
.25211 .09936 L
.23935 .05929 L
.21955 .0317 L
.20856 .01923 L
s
.01923 .79144 m
.0317 .78045 L
.05929 .76065 L
.09936 .74789 L
.13942 .74708 L
.17949 .75776 L
.21462 .78045 L
.21955 .78538 L
.24224 .82051 L
.25292 .86058 L
.25211 .90064 L
.23935 .94071 L
.21955 .9683 L
.20856 .98077 L
.01923 .98077 L
F
.01923 .79144 m
.0317 .78045 L
.05929 .76065 L
.09936 .74789 L
.13942 .74708 L
.17949 .75776 L
.21462 .78045 L
.21955 .78538 L
.24224 .82051 L
.25292 .86058 L
.25211 .90064 L
.23935 .94071 L
.21955 .9683 L
.20856 .98077 L
s
.9 g
.01923 .03873 m
.03873 .01923 L
.01923 .01923 L
F
0 g
.01923 .03873 m
.03873 .01923 L
s
.1 g
.01923 .96127 m
.03873 .98077 L
.01923 .98077 L
F
0 g
.01923 .96127 m
.03873 .98077 L
s
.4 g
.98077 .47485 m
.94071 .47632 L
.90064 .47703 L
.86058 .47708 L
.82051 .47648 L
.78045 .47513 L
.74038 .47281 L
.70032 .46907 L
.66026 .46293 L
.64649 .45994 L
.62019 .45207 L
.58013 .42921 L
.57079 .41987 L
.54793 .37981 L
.54006 .35351 L
.53707 .33974 L
.53093 .29968 L
.52719 .25962 L
.52487 .21955 L
.52352 .17949 L
.52292 .13942 L
.52297 .09936 L
.52368 .05929 L
.52515 .01923 L
.98077 .01923 L
F
0 g
.98077 .47485 m
.94071 .47632 L
.90064 .47703 L
.86058 .47708 L
.82051 .47648 L
.78045 .47513 L
.74038 .47281 L
.70032 .46907 L
.66026 .46293 L
.64649 .45994 L
.62019 .45207 L
.58013 .42921 L
.57079 .41987 L
.54793 .37981 L
.54006 .35351 L
.53707 .33974 L
.53093 .29968 L
.52719 .25962 L
.52487 .21955 L
.52352 .17949 L
.52292 .13942 L
.52297 .09936 L
.52368 .05929 L
.52515 .01923 L
s
.6 g
.98077 .52515 m
.94071 .52368 L
.90064 .52297 L
.86058 .52292 L
.82051 .52352 L
.78045 .52487 L
.74038 .52719 L
.70032 .53093 L
.66026 .53707 L
.64649 .54006 L
.62019 .54793 L
.58013 .57079 L
.57079 .58013 L
.54793 .62019 L
.54006 .64649 L
.53707 .66026 L
.53093 .70032 L
.52719 .74038 L
.52487 .78045 L
.52352 .82051 L
.52292 .86058 L
.52297 .90064 L
.52368 .94071 L
.52515 .98077 L
.98077 .98077 L
F
0 g
.98077 .52515 m
.94071 .52368 L
.90064 .52297 L
.86058 .52292 L
.82051 .52352 L
.78045 .52487 L
.74038 .52719 L
.70032 .53093 L
.66026 .53707 L
.64649 .54006 L
.62019 .54793 L
.58013 .57079 L
.57079 .58013 L
.54793 .62019 L
.54006 .64649 L
.53707 .66026 L
.53093 .70032 L
.52719 .74038 L
.52487 .78045 L
.52352 .82051 L
.52292 .86058 L
.52297 .90064 L
.52368 .94071 L
.52515 .98077 L
s
.3 g
.98077 .42339 m
.94071 .42801 L
.90064 .43022 L
.86058 .43037 L
.82051 .42849 L
.78045 .42426 L
.75352 .41987 L
.74038 .41697 L
.70032 .40503 L
.66026 .3849 L
.65296 .37981 L
.62019 .34704 L
.6151 .33974 L
.59497 .29968 L
.58303 .25962 L
.58013 .24648 L
.57574 .21955 L
.57151 .17949 L
.56963 .13942 L
.56978 .09936 L
.57199 .05929 L
.57661 .01923 L
.98077 .01923 L
F
0 g
.98077 .42339 m
.94071 .42801 L
.90064 .43022 L
.86058 .43037 L
.82051 .42849 L
.78045 .42426 L
.75352 .41987 L
.74038 .41697 L
.70032 .40503 L
.66026 .3849 L
.65296 .37981 L
.62019 .34704 L
.6151 .33974 L
.59497 .29968 L
.58303 .25962 L
.58013 .24648 L
.57574 .21955 L
.57151 .17949 L
.56963 .13942 L
.56978 .09936 L
.57199 .05929 L
.57661 .01923 L
s
.7 g
.98077 .57661 m
.94071 .57199 L
.90064 .56978 L
.86058 .56963 L
.82051 .57151 L
.78045 .57574 L
.75352 .58013 L
.74038 .58303 L
.70032 .59497 L
.66026 .6151 L
.65296 .62019 L
.62019 .65296 L
.6151 .66026 L
.59497 .70032 L
.58303 .74038 L
.58013 .75352 L
.57574 .78045 L
.57151 .82051 L
.56963 .86058 L
.56978 .90064 L
.57199 .94071 L
.57661 .98077 L
.98077 .98077 L
F
0 g
.98077 .57661 m
.94071 .57199 L
.90064 .56978 L
.86058 .56963 L
.82051 .57151 L
.78045 .57574 L
.75352 .58013 L
.74038 .58303 L
.70032 .59497 L
.66026 .6151 L
.65296 .62019 L
.62019 .65296 L
.6151 .66026 L
.59497 .70032 L
.58303 .74038 L
.58013 .75352 L
.57574 .78045 L
.57151 .82051 L
.56963 .86058 L
.56978 .90064 L
.57199 .94071 L
.57661 .98077 L
s
.2 g
.98077 .36795 m
.94071 .37644 L
.91068 .37981 L
.90064 .38045 L
.86058 .38073 L
.84451 .37981 L
.82051 .3773 L
.78045 .36957 L
.74038 .3559 L
.71033 .33974 L
.70032 .33261 L
.66739 .29968 L
.66026 .28967 L
.6441 .25962 L
.63043 .21955 L
.6227 .17949 L
.62019 .15549 L
.61927 .13942 L
.61955 .09936 L
.62019 .08932 L
.62356 .05929 L
.63205 .01923 L
.98077 .01923 L
F
0 g
.98077 .36795 m
.94071 .37644 L
.91068 .37981 L
.90064 .38045 L
.86058 .38073 L
.84451 .37981 L
.82051 .3773 L
.78045 .36957 L
.74038 .3559 L
.71033 .33974 L
.70032 .33261 L
.66739 .29968 L
.66026 .28967 L
.6441 .25962 L
.63043 .21955 L
.6227 .17949 L
.62019 .15549 L
.61927 .13942 L
.61955 .09936 L
.62019 .08932 L
.62356 .05929 L
.63205 .01923 L
s
.8 g
.98077 .63205 m
.94071 .62356 L
.91068 .62019 L
.90064 .61955 L
.86058 .61927 L
.84451 .62019 L
.82051 .6227 L
.78045 .63043 L
.74038 .6441 L
.71033 .66026 L
.70032 .66739 L
.66739 .70032 L
.66026 .71033 L
.6441 .74038 L
.63043 .78045 L
.6227 .82051 L
.62019 .84451 L
.61927 .86058 L
.61955 .90064 L
.62019 .91068 L
.62356 .94071 L
.63205 .98077 L
.98077 .98077 L
F
0 g
.98077 .63205 m
.94071 .62356 L
.91068 .62019 L
.90064 .61955 L
.86058 .61927 L
.84451 .62019 L
.82051 .6227 L
.78045 .63043 L
.74038 .6441 L
.71033 .66026 L
.70032 .66739 L
.66739 .70032 L
.66026 .71033 L
.6441 .74038 L
.63043 .78045 L
.6227 .82051 L
.62019 .84451 L
.61927 .86058 L
.61955 .90064 L
.62019 .91068 L
.62356 .94071 L
.63205 .98077 L
s
.1 g
.98077 .30291 m
.94071 .31756 L
.90064 .32427 L
.86058 .32472 L
.82051 .31902 L
.78045 .30575 L
.76772 .29968 L
.74038 .28123 L
.71877 .25962 L
.70032 .23228 L
.69425 .21955 L
.68098 .17949 L
.67528 .13942 L
.67573 .09936 L
.68244 .05929 L
.69709 .01923 L
.98077 .01923 L
F
0 g
.98077 .30291 m
.94071 .31756 L
.90064 .32427 L
.86058 .32472 L
.82051 .31902 L
.78045 .30575 L
.76772 .29968 L
.74038 .28123 L
.71877 .25962 L
.70032 .23228 L
.69425 .21955 L
.68098 .17949 L
.67528 .13942 L
.67573 .09936 L
.68244 .05929 L
.69709 .01923 L
s
.9 g
.98077 .69709 m
.94071 .68244 L
.90064 .67573 L
.86058 .67528 L
.82051 .68098 L
.78045 .69425 L
.76772 .70032 L
.74038 .71877 L
.71877 .74038 L
.70032 .76772 L
.69425 .78045 L
.68098 .82051 L
.67528 .86058 L
.67573 .90064 L
.68244 .94071 L
.69709 .98077 L
.98077 .98077 L
F
0 g
.98077 .69709 m
.94071 .68244 L
.90064 .67573 L
.86058 .67528 L
.82051 .68098 L
.78045 .69425 L
.76772 .70032 L
.74038 .71877 L
.71877 .74038 L
.70032 .76772 L
.69425 .78045 L
.68098 .82051 L
.67528 .86058 L
.67573 .90064 L
.68244 .94071 L
.69709 .98077 L
s
.98077 .20856 m
.9683 .21955 L
.94071 .23935 L
.90064 .25211 L
.86058 .25292 L
.82051 .24224 L
.78538 .21955 L
.78045 .21462 L
.75776 .17949 L
.74708 .13942 L
.74789 .09936 L
.76065 .05929 L
.78045 .0317 L
.79144 .01923 L
.98077 .01923 L
F
.98077 .20856 m
.9683 .21955 L
.94071 .23935 L
.90064 .25211 L
.86058 .25292 L
.82051 .24224 L
.78538 .21955 L
.78045 .21462 L
.75776 .17949 L
.74708 .13942 L
.74789 .09936 L
.76065 .05929 L
.78045 .0317 L
.79144 .01923 L
s
1 g
.98077 .79144 m
.9683 .78045 L
.94071 .76065 L
.90064 .74789 L
.86058 .74708 L
.82051 .75776 L
.78538 .78045 L
.78045 .78538 L
.75776 .82051 L
.74708 .86058 L
.74789 .90064 L
.76065 .94071 L
.78045 .9683 L
.79144 .98077 L
.98077 .98077 L
F
0 g
.98077 .79144 m
.9683 .78045 L
.94071 .76065 L
.90064 .74789 L
.86058 .74708 L
.82051 .75776 L
.78538 .78045 L
.78045 .78538 L
.75776 .82051 L
.74708 .86058 L
.74789 .90064 L
.76065 .94071 L
.78045 .9683 L
.79144 .98077 L
s
.1 g
.98077 .03873 m
.96127 .01923 L
.98077 .01923 L
F
0 g
.98077 .03873 m
.96127 .01923 L
s
.9 g
.98077 .96127 m
.96127 .98077 L
.98077 .98077 L
F
0 g
.98077 .96127 m
.96127 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.9.5"]
}, Open  ]],

Cell[TextData[{
  "A contour plot gives you essentially a \[OpenCurlyDoubleQuote]topographic \
map\[CloseCurlyDoubleQuote] of a function. The contours join points on the \
surface that have the same height. The default is to have contours \
corresponding to a sequence of equally spaced ",
  StyleBox["z", "TI"],
  " values. Contour plots produced by ",
  StyleBox["Mathematica", "TI"],
  " are by default shaded, in such a way that regions with higher ",
  StyleBox["z", "TI"],
  " values are lighter. "
}], "Text",
  CellTags->{"S1.9.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ColorFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "what colors to use for shading; ",
              StyleBox["Hue", "MR"],
              " uses a sequence of hues "
            }]]},
          {Cell[TextData[{
              StyleBox["Contours", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["10", "MR"],
              " "
            }]], Cell[TextData[{
              "the total number of contours, or the list of ",
              StyleBox["z", "TI"],
              " values for contours "
            }]]},
          {Cell[TextData[{
              StyleBox["PlotRange", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "the range of values to be included; you can specify ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[", ", "TR"],
              StyleBox["All", "MR"],
              " or ",
              StyleBox["Automatic", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ContourShading", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to use shading "]},
          {Cell[TextData[{
              StyleBox["PlotPoints", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["25", "MR"],
              " "
            }]], Cell["number of evaluation points in each direction "]},
          {Cell[TextData[{
              StyleBox["Compiled", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to compile the function being plotted "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False, False, False, True, False}},
  CellTags->"S1.9.5"],

Cell[TextData[{
  "Some options for ",
  StyleBox["ContourPlot", "MR"],
  ". The first set can also be used in ",
  StyleBox["Show", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.9.5"],

Cell["\<\
Particularly if you use a display or printer that does not handle \
gray levels well, you may find it better to switch off shading in contour \
plots. \
\>", "MathCaption",
  CellTags->{"S1.9.5", "5.4"}],

Cell[CellGroupData[{

Cell["Show[%, ContourShading -> False]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.9.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.240385 0.5 0.240385 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -12 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-2)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.98077 .96127 m
.96127 .98077 L
s
.98077 .79144 m
.9683 .78045 L
.94071 .76065 L
.90064 .74789 L
.86058 .74708 L
.82051 .75776 L
.78538 .78045 L
.78045 .78538 L
.75776 .82051 L
.74708 .86058 L
.74789 .90064 L
.76065 .94071 L
.78045 .9683 L
.79144 .98077 L
s
.01923 .20856 m
.0317 .21955 L
.05929 .23935 L
.09936 .25211 L
.13942 .25292 L
.17949 .24224 L
.21462 .21955 L
.21955 .21462 L
.24224 .17949 L
.25292 .13942 L
.25211 .09936 L
.23935 .05929 L
.21955 .0317 L
.20856 .01923 L
s
.01923 .03873 m
.03873 .01923 L
s
.98077 .69709 m
.94071 .68244 L
.90064 .67573 L
.86058 .67528 L
.82051 .68098 L
.78045 .69425 L
.76772 .70032 L
.74038 .71877 L
.71877 .74038 L
.70032 .76772 L
.69425 .78045 L
.68098 .82051 L
.67528 .86058 L
.67573 .90064 L
.68244 .94071 L
.69709 .98077 L
s
.01923 .30291 m
.05929 .31756 L
.09936 .32427 L
.13942 .32472 L
.17949 .31902 L
.21955 .30575 L
.23228 .29968 L
.25962 .28123 L
.28123 .25962 L
.29968 .23228 L
.30575 .21955 L
.31902 .17949 L
.32472 .13942 L
.32427 .09936 L
.31756 .05929 L
.30291 .01923 L
s
.98077 .63205 m
.94071 .62356 L
.91068 .62019 L
.90064 .61955 L
.86058 .61927 L
.84451 .62019 L
.82051 .6227 L
.78045 .63043 L
.74038 .6441 L
.71033 .66026 L
.70032 .66739 L
.66739 .70032 L
.66026 .71033 L
.6441 .74038 L
.63043 .78045 L
.6227 .82051 L
.62019 .84451 L
.61927 .86058 L
.61955 .90064 L
.62019 .91068 L
.62356 .94071 L
.63205 .98077 L
s
.01923 .36795 m
.05929 .37644 L
.08932 .37981 L
.09936 .38045 L
.13942 .38073 L
.15549 .37981 L
.17949 .3773 L
.21955 .36957 L
.25962 .3559 L
.28967 .33974 L
.29968 .33261 L
.33261 .29968 L
.33974 .28967 L
.3559 .25962 L
.36957 .21955 L
.3773 .17949 L
.37981 .15549 L
.38073 .13942 L
.38045 .09936 L
.37981 .08932 L
.37644 .05929 L
.36795 .01923 L
s
.98077 .57661 m
.94071 .57199 L
.90064 .56978 L
.86058 .56963 L
.82051 .57151 L
.78045 .57574 L
.75352 .58013 L
.74038 .58303 L
.70032 .59497 L
.66026 .6151 L
.65296 .62019 L
.62019 .65296 L
.6151 .66026 L
.59497 .70032 L
.58303 .74038 L
.58013 .75352 L
.57574 .78045 L
.57151 .82051 L
.56963 .86058 L
.56978 .90064 L
.57199 .94071 L
.57661 .98077 L
s
.01923 .42339 m
.05929 .42801 L
.09936 .43022 L
.13942 .43037 L
.17949 .42849 L
.21955 .42426 L
.24648 .41987 L
.25962 .41697 L
.29968 .40503 L
.33974 .3849 L
.34704 .37981 L
.37981 .34704 L
.3849 .33974 L
.40503 .29968 L
.41697 .25962 L
.41987 .24648 L
.42426 .21955 L
.42849 .17949 L
.43037 .13942 L
.43022 .09936 L
.42801 .05929 L
.42339 .01923 L
s
.98077 .52515 m
.94071 .52368 L
.90064 .52297 L
.86058 .52292 L
.82051 .52352 L
.78045 .52487 L
.74038 .52719 L
.70032 .53093 L
.66026 .53707 L
.64649 .54006 L
.62019 .54793 L
.58013 .57079 L
.57079 .58013 L
.54793 .62019 L
.54006 .64649 L
.53707 .66026 L
.53093 .70032 L
.52719 .74038 L
.52487 .78045 L
.52352 .82051 L
.52292 .86058 L
.52297 .90064 L
.52368 .94071 L
.52515 .98077 L
s
.01923 .47485 m
.05929 .47632 L
.09936 .47703 L
.13942 .47708 L
.17949 .47648 L
.21955 .47513 L
.25962 .47281 L
.29968 .46907 L
.33974 .46293 L
.35351 .45994 L
.37981 .45207 L
.41987 .42921 L
.42921 .41987 L
.45207 .37981 L
.45994 .35351 L
.46293 .33974 L
.46907 .29968 L
.47281 .25962 L
.47513 .21955 L
.47648 .17949 L
.47708 .13942 L
.47703 .09936 L
.47632 .05929 L
.47485 .01923 L
s
.01923 .52515 m
.05929 .52368 L
.09936 .52297 L
.13942 .52292 L
.17949 .52352 L
.21955 .52487 L
.25962 .52719 L
.29968 .53093 L
.33974 .53707 L
.35351 .54006 L
.37981 .54793 L
.41987 .57079 L
.42921 .58013 L
.45207 .62019 L
.45994 .64649 L
.46293 .66026 L
.46907 .70032 L
.47281 .74038 L
.47513 .78045 L
.47648 .82051 L
.47708 .86058 L
.47703 .90064 L
.47632 .94071 L
.47485 .98077 L
s
.98077 .47485 m
.94071 .47632 L
.90064 .47703 L
.86058 .47708 L
.82051 .47648 L
.78045 .47513 L
.74038 .47281 L
.70032 .46907 L
.66026 .46293 L
.64649 .45994 L
.62019 .45207 L
.58013 .42921 L
.57079 .41987 L
.54793 .37981 L
.54006 .35351 L
.53707 .33974 L
.53093 .29968 L
.52719 .25962 L
.52487 .21955 L
.52352 .17949 L
.52292 .13942 L
.52297 .09936 L
.52368 .05929 L
.52515 .01923 L
s
.01923 .57661 m
.05929 .57199 L
.09936 .56978 L
.13942 .56963 L
.17949 .57151 L
.21955 .57574 L
.24648 .58013 L
.25962 .58303 L
.29968 .59497 L
.33974 .6151 L
.34704 .62019 L
.37981 .65296 L
.3849 .66026 L
.40503 .70032 L
.41697 .74038 L
.41987 .75352 L
.42426 .78045 L
.42849 .82051 L
.43037 .86058 L
.43022 .90064 L
.42801 .94071 L
.42339 .98077 L
s
.98077 .42339 m
.94071 .42801 L
.90064 .43022 L
.86058 .43037 L
.82051 .42849 L
.78045 .42426 L
.75352 .41987 L
.74038 .41697 L
.70032 .40503 L
.66026 .3849 L
.65296 .37981 L
.62019 .34704 L
.6151 .33974 L
.59497 .29968 L
.58303 .25962 L
.58013 .24648 L
.57574 .21955 L
.57151 .17949 L
.56963 .13942 L
.56978 .09936 L
.57199 .05929 L
.57661 .01923 L
s
.01923 .63205 m
.05929 .62356 L
.08932 .62019 L
.09936 .61955 L
.13942 .61927 L
.15549 .62019 L
.17949 .6227 L
.21955 .63043 L
.25962 .6441 L
.28967 .66026 L
.29968 .66739 L
.33261 .70032 L
.33974 .71033 L
.3559 .74038 L
.36957 .78045 L
.3773 .82051 L
.37981 .84451 L
.38073 .86058 L
.38045 .90064 L
.37981 .91068 L
.37644 .94071 L
.36795 .98077 L
s
.98077 .36795 m
.94071 .37644 L
.91068 .37981 L
.90064 .38045 L
.86058 .38073 L
.84451 .37981 L
.82051 .3773 L
.78045 .36957 L
.74038 .3559 L
.71033 .33974 L
.70032 .33261 L
.66739 .29968 L
.66026 .28967 L
.6441 .25962 L
.63043 .21955 L
.6227 .17949 L
.62019 .15549 L
.61927 .13942 L
.61955 .09936 L
.62019 .08932 L
.62356 .05929 L
.63205 .01923 L
s
.01923 .69709 m
.05929 .68244 L
.09936 .67573 L
.13942 .67528 L
.17949 .68098 L
.21955 .69425 L
.23228 .70032 L
.25962 .71877 L
.28123 .74038 L
.29968 .76772 L
.30575 .78045 L
.31902 .82051 L
.32472 .86058 L
.32427 .90064 L
.31756 .94071 L
.30291 .98077 L
s
.98077 .30291 m
.94071 .31756 L
.90064 .32427 L
.86058 .32472 L
.82051 .31902 L
.78045 .30575 L
.76772 .29968 L
.74038 .28123 L
.71877 .25962 L
.70032 .23228 L
.69425 .21955 L
.68098 .17949 L
.67528 .13942 L
.67573 .09936 L
.68244 .05929 L
.69709 .01923 L
s
.01923 .79144 m
.0317 .78045 L
.05929 .76065 L
.09936 .74789 L
.13942 .74708 L
.17949 .75776 L
.21462 .78045 L
.21955 .78538 L
.24224 .82051 L
.25292 .86058 L
.25211 .90064 L
.23935 .94071 L
.21955 .9683 L
.20856 .98077 L
s
.01923 .96127 m
.03873 .98077 L
s
.98077 .03873 m
.96127 .01923 L
s
.98077 .20856 m
.9683 .21955 L
.94071 .23935 L
.90064 .25211 L
.86058 .25292 L
.82051 .24224 L
.78538 .21955 L
.78045 .21462 L
.75776 .17949 L
.74708 .13942 L
.74789 .09936 L
.76065 .05929 L
.78045 .0317 L
.79144 .01923 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.9.5"]
}, Open  ]],

Cell[TextData[{
  "You should realize that if you do not evaluate your function on a fine \
enough grid, there may be inaccuracies in your contour plot. One point to \
notice is that whereas a curve generated by ",
  StyleBox["Plot", "MR"],
  " may be inaccurate if your function varies too quickly in a particular \
region, the shape of contours can be inaccurate if your function varies too \
slowly. A rapidly varying function gives a regular pattern of contours, but a \
function that is almost flat can give irregular contours. You can typically \
overcome such problems by increasing the value of ",
  StyleBox["PlotPoints", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.9.5", "5.5"}],

Cell["\<\
Density plots show the values of your function at a regular array \
of points. Lighter regions are higher. \
\>", "MathCaption",
  CellTags->{"S1.9.5", "5.6"}],

Cell[CellGroupData[{

Cell["DensityPlot[Sin[x] Sin[y], {x, -2, 2}, {y, -2, 2}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.9.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.240385 0.5 0.240385 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -12 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-2)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
25 string
25 25 8 [25 0 0 25 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
EAF0F4F4F1EBE2D6C8B8A6937F6C594737291D140E0B0B0F15
F0F7FBFBF8F2E8DBCCBBA8947F6B57443324170D070404080F
F4FBFFFFFCF5EBDECFBDA9957F6A56423021140A030000040B
F4FBFFFFFCF5EBDECFBDA9957F6A56423021140A030000040B
F1F8FCFCF9F2E9DCCDBBA8947F6B57443223160D060303070E
EBF2F5F5F2ECE3D7C9B8A6937F6C594736281C130D0A0A0D14
E2E8EBEBE9E3DBD0C2B3A3917F6E5C4C3D2F241C161414171D
D6DBDEDEDCD7D0C6BAAD9F8F7F70605245392F282321212429
C8CCCFCFCDC9C2BAB1A69A8D7F7265594E453D363230303337
B8BBBDBDBBB8B3ADA69D948A7F756B6259524C474442424447
A6A8A9A9A8A6A39F9A948D867F79726B65605C595756565759
939495959493918F8D8A86837F7C797572706E6C6B6A6A6B6C
7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080
6C6B6A6A6B6C6E707275797C8083868A8D8F91939495959493
5957565657595C60656B727980868D949A9FA3A6A8A9A9A8A6
4744424244474C5259626B75808A949DA6ADB3B8BBBDBDBBB8
3733303032363D454E596572808D9AA6B1BAC2C9CDCFCFCCC8
2924212123282F3945526070808F9FADBAC6D0D7DCDEDEDBD6
1D171414161C242F3D4C5C6E8091A3B3C2D0DBE3E9EBEBE8E2
140D0A0A0D131C283647596C8093A6B8C9D7E3ECF2F5F5F2EB
0E070303060D16233244576B8094A8BBCDDCE9F2F9FCFCF8F1
0B040000030A14213042566A8095A9BDCFDEEBF5FCFFFFFBF4
0B040000030A14213042566A8095A9BDCFDEEBF5FCFFFFFBF4
0F080404070D17243344576B8094A8BBCCDBE8F2F8FBFBF7F0
150F0B0B0E141D293747596C8093A6B8C8D6E2EBF1F4F4F0EA
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.05769 .01923 m
.05769 .98077 L
s
.09615 .01923 m
.09615 .98077 L
s
.13462 .01923 m
.13462 .98077 L
s
.17308 .01923 m
.17308 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.25 .01923 m
.25 .98077 L
s
.28846 .01923 m
.28846 .98077 L
s
.32692 .01923 m
.32692 .98077 L
s
.36538 .01923 m
.36538 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.44231 .01923 m
.44231 .98077 L
s
.48077 .01923 m
.48077 .98077 L
s
.51923 .01923 m
.51923 .98077 L
s
.55769 .01923 m
.55769 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.63462 .01923 m
.63462 .98077 L
s
.67308 .01923 m
.67308 .98077 L
s
.71154 .01923 m
.71154 .98077 L
s
.75 .01923 m
.75 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.82692 .01923 m
.82692 .98077 L
s
.86538 .01923 m
.86538 .98077 L
s
.90385 .01923 m
.90385 .98077 L
s
.94231 .01923 m
.94231 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .05769 m
.98077 .05769 L
s
.01923 .09615 m
.98077 .09615 L
s
.01923 .13462 m
.98077 .13462 L
s
.01923 .17308 m
.98077 .17308 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .25 m
.98077 .25 L
s
.01923 .28846 m
.98077 .28846 L
s
.01923 .32692 m
.98077 .32692 L
s
.01923 .36538 m
.98077 .36538 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .44231 m
.98077 .44231 L
s
.01923 .48077 m
.98077 .48077 L
s
.01923 .51923 m
.98077 .51923 L
s
.01923 .55769 m
.98077 .55769 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .63462 m
.98077 .63462 L
s
.01923 .67308 m
.98077 .67308 L
s
.01923 .71154 m
.98077 .71154 L
s
.01923 .75 m
.98077 .75 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .82692 m
.98077 .82692 L
s
.01923 .86538 m
.98077 .86538 L
s
.01923 .90385 m
.98077 .90385 L
s
.01923 .94231 m
.98077 .94231 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.9.5"]
}, Open  ]],

Cell["\<\
You can get rid of the mesh like this. But unless you have a very \
large number of regions, plots usually look better when you include the mesh. \
\
\>", "MathCaption",
  CellTags->{"S1.9.5", "5.7"}],

Cell[CellGroupData[{

Cell["Show[%, Mesh -> False]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.9.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.240385 0.5 0.240385 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -12 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-2)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
25 string
25 25 8 [25 0 0 25 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
EAF0F4F4F1EBE2D6C8B8A6937F6C594737291D140E0B0B0F15
F0F7FBFBF8F2E8DBCCBBA8947F6B57443324170D070404080F
F4FBFFFFFCF5EBDECFBDA9957F6A56423021140A030000040B
F4FBFFFFFCF5EBDECFBDA9957F6A56423021140A030000040B
F1F8FCFCF9F2E9DCCDBBA8947F6B57443223160D060303070E
EBF2F5F5F2ECE3D7C9B8A6937F6C594736281C130D0A0A0D14
E2E8EBEBE9E3DBD0C2B3A3917F6E5C4C3D2F241C161414171D
D6DBDEDEDCD7D0C6BAAD9F8F7F70605245392F282321212429
C8CCCFCFCDC9C2BAB1A69A8D7F7265594E453D363230303337
B8BBBDBDBBB8B3ADA69D948A7F756B6259524C474442424447
A6A8A9A9A8A6A39F9A948D867F79726B65605C595756565759
939495959493918F8D8A86837F7C797572706E6C6B6A6A6B6C
7F7F7F7F7F7F7F7F7F7F7F7F7F808080808080808080808080
6C6B6A6A6B6C6E707275797C8083868A8D8F91939495959493
5957565657595C60656B727980868D949A9FA3A6A8A9A9A8A6
4744424244474C5259626B75808A949DA6ADB3B8BBBDBDBBB8
3733303032363D454E596572808D9AA6B1BAC2C9CDCFCFCCC8
2924212123282F3945526070808F9FADBAC6D0D7DCDEDEDBD6
1D171414161C242F3D4C5C6E8091A3B3C2D0DBE3E9EBEBE8E2
140D0A0A0D131C283647596C8093A6B8C9D7E3ECF2F5F5F2EB
0E070303060D16233244576B8094A8BBCDDCE9F2F9FCFCF8F1
0B040000030A14213042566A8095A9BDCFDEEBF5FCFFFFFBF4
0B040000030A14213042566A8095A9BDCFDEEBF5FCFFFFFBF4
0F080404070D17243344576B8094A8BBCCDBE8F2F8FBFBF7F0
150F0B0B0E141D293747596C8093A6B8C8D6E2EBF1F4F4F0EA
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.9.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ColorFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "what colors to use for shading; ",
              StyleBox["Hue", "MR"],
              " uses a sequence of hues "
            }]]},
          {Cell[TextData[{
              StyleBox["Mesh", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to draw a mesh "]},
          {Cell[TextData[{
              StyleBox["PlotPoints", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["25", "MR"],
              " "
            }]], Cell["number of evaluation points in each direction "]},
          {Cell[TextData[{
              StyleBox["Compiled", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to compile the function being plotted "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False, True, False}},
  CellTags->"S1.9.5"],

Cell[TextData[{
  "Some options for ",
  StyleBox["DensityPlot", "MR"],
  ". The first set can also be used in ",
  StyleBox["Show", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.9.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.9.6 Three\[Hyphen]Dimensional Surface Plots\
\>", "Subsection",
  CellTags->{"S1.9.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Plot3D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a three\[Hyphen]dimensional plot of ",
              StyleBox["f", "TI"],
              " as a function of the variables ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.6"],

Cell["Basic 3D plotting function. ", "Caption",
  CellTags->"S1.9.6"],

Cell[TextData[{
  "This makes a three\[Hyphen]dimensional plot of the function ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox[\(x  y\),
              "TI"], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.9.6", "6.2"}],

Cell[CellGroupData[{

Cell["Plot3D[Sin[x y], {x, 0, 3}, {y, 0, 3}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.00289e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.22808 .16727 -5.79519 -9 ]
[.22808 .16727 .20481 0 ]
[.44535 .08183 -5.37821 -9 ]
[.44535 .08183 .62179 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.80849 .15988 0 -6.10118 ]
[.80849 .15988 6 2.89882 ]
[.90119 .30183 0 -5.96721 ]
[.90119 .30183 6 3.03279 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02412 .26508 -12 -2.74229 ]
[.02412 .26508 0 6.25771 ]
[.01569 .31793 -24 -2.78697 ]
[.01569 .31793 0 6.21303 ]
[.00696 .37262 -6 -2.83338 ]
[.00696 .37262 0 6.16662 ]
[-0.00208 .42926 -18 -2.8816 ]
[-0.00208 .42926 0 6.1184 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(2)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(3)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.79613 .16428 m
.78995 .16648 L
s
[(1)] .80849 .15988 -1 .35582 Mshowa
.88871 .30589 m
.88247 .30793 L
s
[(2)] .90119 .30183 -1 .32605 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(3)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71157 .03492 m
.70789 .03634 L
s
.73369 .06877 m
.73001 .07015 L
s
.75514 .10158 m
.75145 .10294 L
s
.77594 .1334 m
.77224 .13474 L
s
.81573 .19425 m
.81201 .19555 L
s
.83476 .22337 m
.83104 .22465 L
s
.85326 .25166 m
.84953 .25292 L
s
.87123 .27915 m
.8675 .28039 L
s
.90572 .33191 m
.90197 .33311 L
s
.92227 .35722 m
.91851 .3584 L
s
.93838 .38186 m
.93462 .38303 L
s
.95406 .40586 m
.9503 .40701 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .2603 m
.04245 .25791 L
s
[(-1)] .02412 .26508 1 -0.3906 Mshowa
.02795 .31326 m
.03408 .31092 L
s
[(-0.5)] .01569 .31793 1 -0.38067 Mshowa
.01926 .36806 m
.02542 .36579 L
s
[(0)] .00696 .37262 1 -0.37036 Mshowa
.01027 .42482 m
.01644 .4226 L
s
[(0.5)] -0.00208 .42926 1 -0.35964 Mshowa
.00095 .48364 m
.00715 .48148 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03469 .27075 m
.03836 .26932 L
s
.03302 .28127 m
.03669 .27985 L
s
.03134 .29186 m
.03502 .29044 L
s
.02965 .30252 m
.03333 .30111 L
s
.02624 .32407 m
.02992 .32267 L
s
.02451 .33495 m
.0282 .33357 L
s
.02277 .34591 m
.02646 .34453 L
s
.02103 .35695 m
.02471 .35558 L
s
.01749 .37926 m
.02118 .3779 L
s
.0157 .39053 m
.0194 .38917 L
s
.01391 .40188 m
.01761 .40053 L
s
.01209 .41331 m
.0158 .41197 L
s
.00843 .43642 m
.01214 .43509 L
s
.00658 .44809 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.779 .289 0 r
.38853 .69035 .40169 .70184 .4226 .7331 .40946 .72017 Metetra
.648 .145 0 r
.40946 .72017 .4226 .7331 .44426 .75992 .43112 .7461 Metetra
0 .206 .707 r
.43112 .7461 .44426 .75992 .46667 .77729 .45355 .76366 Metetra
.338 .594 .94 r
.45355 .76366 .46667 .77729 .48971 .78143 .47664 .76934 Metetra
.678 .759 .912 r
.47664 .76934 .48971 .78143 .51313 .77058 .50018 .76129 Metetra
.825 .816 .841 r
.50018 .76129 .51313 .77058 .53664 .74539 .5239 .73966 Metetra
.897 .846 .786 r
.5239 .73966 .53664 .74539 .55998 .70879 .54755 .70663 Metetra
.936 .87 .748 r
.54755 .70663 .55998 .70879 .58301 .66536 .57095 .66594 Metetra
.955 .892 .727 r
.57095 .66594 .58301 .66536 .60571 .62048 .59402 .62222 Metetra
.958 .913 .728 r
.59402 .62222 .60571 .62048 .6282 .57941 .61684 .58025 Metetra
.943 .931 .76 r
.61684 .58025 .6282 .57941 .65072 .54663 .63957 .54433 Metetra
.896 .931 .832 r
.63957 .54433 .65072 .54663 .67358 .52537 .66248 .51783 Metetra
.778 .864 .913 r
.66248 .51783 .67358 .52537 .69713 .51739 .68587 .50297 Metetra
.58 .69 .917 r
.68587 .50297 .69713 .51739 .72166 .52288 .71006 .50062 Metetra
.401 .501 .846 r
.71006 .50062 .72166 .52288 .74737 .54044 .73529 .51035 Metetra
.305 .381 .777 r
.73529 .51035 .74737 .54044 .77434 .56715 .76171 .53038 Metetra
.273 .326 .736 r
.76171 .53038 .77434 .56715 .80242 .59873 .78933 .55768 Metetra
.281 .316 .72 r
.78933 .55768 .80242 .59873 .83129 .62995 .81798 .58815 Metetra
.312 .336 .725 r
.81798 .58815 .83129 .62995 .86041 .65524 .8473 .61702 Metetra
.365 .386 .749 r
.8473 .61702 .86041 .65524 .88913 .66958 .87677 .63936 Metetra
.446 .479 .8 r
.87677 .63936 .88913 .66958 .91682 .66943 .90578 .6509 Metetra
.581 .657 .89 r
.90578 .6509 .91682 .66943 .94298 .65357 .93374 .64878 Metetra
.76 .953 .938 r
.93374 .64878 .94298 .65357 .96742 .62328 .96022 .63209 Metetra
.96022 .63209 .96742 .62328 .99025 .58217 .98503 .60214 Metetra
.755 .257 0 r
.37518 .67869 .38853 .69035 .40946 .72017 .39612 .70705 Metetra
.62 .115 0 r
.39612 .70705 .40946 .72017 .43112 .7461 .41779 .73202 Metetra
0 .204 .707 r
.41779 .73202 .43112 .7461 .45355 .76366 .44024 .74962 Metetra
.287 .564 .932 r
.44024 .74962 .45355 .76366 .47664 .76934 .46337 .75664 Metetra
.632 .74 .926 r
.46337 .75664 .47664 .76934 .50018 .76129 .48701 .75118 Metetra
.796 .809 .862 r
.48701 .75118 .50018 .76129 .5239 .73966 .51092 .73302 Metetra
.879 .846 .807 r
.51092 .73302 .5239 .73966 .54755 .70663 .53484 .70367 Metetra
.926 .872 .766 r
.53484 .70367 .54755 .70663 .57095 .66594 .55859 .66609 Metetra
.95 .896 .739 r
.55859 .66609 .57095 .66594 .59402 .62222 .58205 .62419 Metetra
.957 .917 .729 r
.58205 .62419 .59402 .62222 .61684 .58025 .60523 .58219 Metetra
.949 .936 .745 r
.60523 .58219 .61684 .58025 .63957 .54433 .62823 .54412 Metetra
.92 .946 .798 r
.62823 .54412 .63957 .54433 .66248 .51783 .65128 .51336 Metetra
.849 .918 .879 r
.65128 .51336 .66248 .51783 .68587 .50297 .67463 .49238 Metetra
.701 .8 .927 r
.67463 .49238 .68587 .50297 .71006 .50062 .69858 .4826 Metetra
.518 .615 .889 r
.69858 .4826 .71006 .50062 .73529 .51035 .72339 .48432 Metetra
.387 .462 .816 r
.72339 .48432 .73529 .51035 .76171 .53038 .74927 .49672 Metetra
.323 .375 .76 r
.74927 .49672 .76171 .53038 .78933 .55768 .77634 .51787 Metetra
.306 .337 .73 r
.77634 .51787 .78933 .55768 .81798 .58815 .80455 .54483 Metetra
.316 .333 .719 r
.80455 .54483 .81798 .58815 .8473 .61702 .83372 .5738 Metetra
.345 .354 .726 r
.83372 .5738 .8473 .61702 .87677 .63936 .86349 .6005 Metetra
.391 .402 .751 r
.86349 .6005 .87677 .63936 .90578 .6509 .89336 .62063 Metetra
.464 .492 .803 r
.89336 .62063 .90578 .6509 .93374 .64878 .92275 .63051 Metetra
.586 .668 .896 r
.92275 .63051 .93374 .64878 .96022 .63209 .95114 .62769 Metetra
.739 .96 .941 r
.95114 .62769 .96022 .63209 .98503 .60214 .9781 .61144 Metetra
.726 .221 0 r
.36161 .66686 .37518 .67869 .39612 .70705 .38259 .69372 Metetra
.587 .082 0 r
.38259 .69372 .39612 .70705 .41779 .73202 .40428 .71766 Metetra
0 .208 .711 r
.40428 .71766 .41779 .73202 .44024 .74962 .42674 .73518 Metetra
.243 .535 .922 r
.42674 .73518 .44024 .74962 .46337 .75664 .4499 .74333 Metetra
.584 .718 .935 r
.4499 .74333 .46337 .75664 .48701 .75118 .47362 .74024 Metetra
.762 .798 .882 r
.47362 .74024 .48701 .75118 .51092 .73302 .49769 .72541 Metetra
.857 .842 .829 r
.49769 .72541 .51092 .73302 .53484 .70367 .52187 .69978 Metetra
.912 .874 .786 r
.52187 .69978 .53484 .70367 .55859 .66609 .54595 .66561 Metetra
.942 .899 .755 r
.54595 .66561 .55859 .66609 .58205 .62419 .56978 .62611 Metetra
.954 .921 .736 r
.56978 .62611 .58205 .62419 .60523 .58219 .59334 .58492 Metetra
.951 .94 .738 r
.59334 .58492 .60523 .58219 .62823 .54412 .61668 .54571 Metetra
.933 .954 .77 r
.61668 .54571 .62823 .54412 .65128 .51336 .63995 .51173 Metetra
.891 .95 .838 r
.63995 .51173 .65128 .51336 .67463 .49238 .66336 .48559 Metetra
.796 .887 .911 r
.66336 .48559 .67463 .49238 .69858 .4826 .68718 .46905 Metetra
.639 .736 .919 r
.68718 .46905 .69858 .4826 .72339 .48432 .71167 .46299 Metetra
.487 .565 .86 r
.71167 .46299 .72339 .48432 .74927 .49672 .73707 .46734 Metetra
.391 .444 .795 r
.73707 .46734 .74927 .49672 .77634 .51787 .76355 .48109 Metetra
.347 .377 .75 r
.76355 .48109 .77634 .51787 .80455 .54483 .7912 .50233 Metetra
.337 .349 .725 r
.7912 .50233 .80455 .54483 .83372 .5738 .81995 .52832 Metetra
.346 .347 .718 r
.81995 .52832 .83372 .5738 .86349 .6005 .84961 .55565 Metetra
.371 .367 .725 r
.84961 .55565 .86349 .6005 .89336 .62063 .87984 .58053 Metetra
.41 .411 .75 r
.87984 .58053 .89336 .62063 .92275 .63051 .91017 .59922 Metetra
.472 .494 .799 r
.91017 .59922 .92275 .63051 .95114 .62769 .94006 .60849 Metetra
.578 .658 .891 r
.94006 .60849 .95114 .62769 .9781 .61144 .96902 .60617 Metetra
.692 .18 0 r
.34784 .65483 .36161 .66686 .38259 .69372 .36886 .68018 Metetra
.549 .045 0 r
.36886 .68018 .38259 .69372 .40428 .71766 .39057 .70304 Metetra
0 .218 .719 r
.39057 .70304 .40428 .71766 .42674 .73518 .41305 .72032 Metetra
.206 .51 .911 r
.41305 .72032 .42674 .73518 .4499 .74333 .43624 .7294 Metetra
.535 .693 .94 r
.43624 .7294 .4499 .74333 .47362 .74024 .46003 .72845 Metetra
.723 .784 .9 r
.46003 .72845 .47362 .74024 .49769 .72541 .48423 .71676 Metetra
.83 .836 .852 r
.48423 .71676 .49769 .72541 .52187 .69978 .50862 .69482 Metetra
.894 .873 .809 r
.50862 .69482 .52187 .69978 .54595 .66561 .533 .66429 Metetra
.931 .902 .774 r
.533 .66429 .54595 .66561 .56978 .62611 .55721 .62768 Metetra
.948 .925 .749 r
.55721 .62768 .56978 .62611 .59334 .58492 .58116 .58808 Metetra
.95 .944 .738 r
.58116 .58808 .59334 .58492 .61668 .54571 .60487 .54871 Metetra
.938 .96 .751 r
.60487 .54871 .61668 .54571 .63995 .51173 .62843 .51261 Metetra
.912 .967 .799 r
.62843 .51261 .63995 .51173 .66336 .48559 .652 .48239 Metetra
.858 .944 .874 r
.652 .48239 .66336 .48559 .68718 .46905 .67581 .46002 Metetra
.748 .847 .924 r
.67581 .46002 .68718 .46905 .71167 .46299 .7001 .44676 Metetra
.6 .685 .901 r
.7001 .44676 .71167 .46299 .73707 .46734 .72511 .44312 Metetra
.478 .536 .838 r
.72511 .44312 .73707 .46734 .76355 .48109 .75106 .44882 Metetra
.406 .437 .78 r
.75106 .44882 .76355 .48109 .7912 .50233 .77808 .46284 Metetra
.373 .383 .742 r
.77808 .46284 .7912 .50233 .81995 .52832 .80625 .48338 Metetra
.364 .36 .722 r
.80625 .48338 .81995 .52832 .84961 .55565 .83549 .50799 Metetra
.372 .359 .715 r
.83549 .50799 .84961 .55565 .87984 .58053 .86562 .53367 Metetra
.392 .376 .722 r
.86562 .53367 .87984 .58053 .91017 .59922 .89633 .55712 Metetra
.424 .414 .745 r
.89633 .55712 .91017 .59922 .94006 .60849 .92718 .57507 Metetra
.475 .486 .79 r
.92718 .57507 .94006 .60849 .96902 .60617 .95769 .58466 Metetra
.652 .135 0 r
.33385 .64262 .34784 .65483 .36886 .68018 .35492 .66644 Metetra
.506 .003 0 r
.35492 .66644 .36886 .68018 .39057 .70304 .37667 .68814 Metetra
0 .232 .732 r
.37667 .68814 .39057 .70304 .41305 .72032 .39916 .70506 Metetra
.177 .49 .902 r
.39916 .70506 .41305 .72032 .43624 .7294 .42238 .71484 Metetra
.487 .666 .942 r
.42238 .71484 .43624 .7294 .46003 .72845 .44622 .71578 Metetra
.68 .765 .915 r
.44622 .71578 .46003 .72845 .48423 .71676 .47053 .70701 Metetra
.797 .825 .873 r
.47053 .70701 .48423 .71676 .50862 .69482 .49511 .68868 Metetra
.871 .869 .833 r
.49511 .68868 .50862 .69482 .533 .66429 .51976 .6619 Metetra
.916 .903 .797 r
.51976 .6619 .533 .66429 .55721 .62768 .54431 .6286 Metetra
.94 .93 .766 r
.54431 .6286 .55721 .62768 .58116 .58808 .56866 .59127 Metetra
.945 .949 .745 r
.56866 .59127 .58116 .58808 .60487 .54871 .59277 .55269 Metetra
.937 .964 .741 r
.59277 .55269 .60487 .54871 .62843 .51261 .61668 .51559 Metetra
.919 .975 .766 r
.61668 .51559 .62843 .51261 .652 .48239 .64051 .48245 Metetra
.889 .975 .827 r
.64051 .48245 .652 .48239 .67581 .46002 .66442 .45534 Metetra
.827 .931 .899 r
.66442 .45534 .67581 .46002 .7001 .44676 .68864 .43576 Metetra
.714 .811 .925 r
.68864 .43576 .7001 .44676 .72511 .44312 .71339 .42463 Metetra
.582 .652 .884 r
.71339 .42463 .72511 .44312 .75106 .44882 .73888 .42222 Metetra
.483 .522 .822 r
.73888 .42222 .75106 .44882 .77808 .46284 .76532 .4282 Metetra
.425 .439 .771 r
.76532 .4282 .77808 .46284 .80625 .48338 .79282 .44159 Metetra
.398 .392 .737 r
.79282 .44159 .80625 .48338 .83549 .50799 .82143 .46081 Metetra
.39 .372 .718 r
.82143 .46081 .83549 .50799 .86562 .53367 .85112 .48373 Metetra
.395 .369 .712 r
.85112 .48373 .86562 .53367 .89633 .55712 .8817 .50777 Metetra
.41 .382 .717 r
.8817 .50777 .89633 .55712 .92718 .57507 .9129 .5301 Metetra
.434 .413 .736 r
.9129 .5301 .92718 .57507 .95769 .58466 .94434 .54786 Metetra
.605 .083 0 r
.31964 .63022 .33385 .64262 .35492 .66644 .34077 .65248 Metetra
0 .042 .542 r
.34077 .65248 .35492 .66644 .37667 .68814 .36257 .67297 Metetra
0 .251 .748 r
.36257 .67297 .37667 .68814 .39916 .70506 .38508 .68939 Metetra
.158 .475 .895 r
.38508 .68939 .39916 .70506 .42238 .71484 .40832 .69967 Metetra
.443 .64 .94 r
.40832 .69967 .42238 .71484 .44622 .71578 .4322 .70222 Metetra
.635 .742 .926 r
.4322 .70222 .44622 .71578 .47053 .70701 .4566 .69613 Metetra
.759 .81 .893 r
.4566 .69613 .47053 .70701 .49511 .68868 .48133 .68125 Metetra
.842 .861 .857 r
.48133 .68125 .49511 .68868 .51976 .6619 .50622 .65827 Metetra
.896 .901 .822 r
.50622 .65827 .51976 .6619 .54431 .6286 .5311 .62856 Metetra
.927 .932 .789 r
.5311 .62856 .54431 .6286 .56866 .59127 .55583 .5941 Metetra
.937 .955 .759 r
.55583 .5941 .56866 .59127 .59277 .55269 .58035 .55716 Metetra
.932 .969 .74 r
.58035 .55716 .59277 .55269 .61668 .51559 .60465 .52014 Metetra
.916 .979 .743 r
.60465 .52014 .61668 .51559 .64051 .48245 .62881 .48532 Metetra
.896 .987 .78 r
.62881 .48532 .64051 .48245 .66442 .45534 .65294 .4547 Metetra
.867 .979 .849 r
.65294 .4547 .66442 .45534 .68864 .43576 .67722 .42991 Metetra
.803 .917 .915 r
.67722 .42991 .68864 .43576 .71339 .42463 .70184 .41214 Metetra
.694 .786 .921 r
.70184 .41214 .71339 .42463 .73888 .42222 .72702 .40206 Metetra
.579 .636 .872 r
.72702 .40206 .73888 .42222 .76532 .4282 .75295 .39985 Metetra
.496 .52 .812 r
.75295 .39985 .76532 .4282 .79282 .44159 .77981 .40517 Metetra
.447 .446 .765 r
.77981 .40517 .79282 .44159 .82143 .46081 .80772 .41718 Metetra
.422 .403 .733 r
.80772 .41718 .82143 .46081 .85112 .48373 .83673 .43454 Metetra
.413 .382 .715 r
.83673 .43454 .85112 .48373 .8817 .50777 .8668 .45547 Metetra
.415 .377 .708 r
.8668 .45547 .8817 .50777 .9129 .5301 .8978 .47781 Metetra
.425 .386 .711 r
.8978 .47781 .9129 .5301 .94434 .54786 .92949 .49915 Metetra
.549 .026 0 r
.3052 .61762 .31964 .63022 .34077 .65248 .32641 .63831 Metetra
0 .092 .592 r
.32641 .63831 .34077 .65248 .36257 .67297 .34826 .65752 Metetra
0 .274 .766 r
.34826 .65752 .36257 .67297 .38508 .68939 .37081 .67331 Metetra
.147 .466 .891 r
.37081 .67331 .38508 .68939 .40832 .69967 .39407 .68387 Metetra
.404 .615 .936 r
.39407 .68387 .40832 .69967 .4322 .70222 .41798 .68778 Metetra
.589 .717 .932 r
.41798 .68778 .4322 .70222 .4566 .69613 .44244 .68407 Metetra
.717 .79 .909 r
.44244 .68407 .4566 .69613 .48133 .68125 .4673 .67244 Metetra
.807 .847 .88 r
.4673 .67244 .48133 .68125 .50622 .65827 .49239 .65319 Metetra
.87 .894 .849 r
.49239 .65319 .50622 .65827 .5311 .62856 .51756 .62727 Metetra
.909 .932 .815 r
.51756 .62727 .5311 .62856 .55583 .5941 .54265 .59614 Metetra
.926 .959 .781 r
.54265 .59614 .55583 .5941 .58035 .55716 .56758 .56161 Metetra
.923 .975 .75 r
.56758 .56161 .58035 .55716 .60465 .52014 .59231 .52569 Metetra
.908 .983 .733 r
.59231 .52569 .60465 .52014 .62881 .48532 .61685 .49038 Metetra
.888 .989 .742 r
.61685 .49038 .62881 .48532 .65294 .4547 .64129 .45756 Metetra
.871 .995 .789 r
.64129 .45756 .65294 .4547 .67722 .42991 .66576 .42887 Metetra
.848 .982 .865 r
.66576 .42887 .67722 .42991 .70184 .41214 .6904 .40561 Metetra
.789 .911 .924 r
.6904 .40561 .70184 .41214 .72702 .40206 .71541 .38872 Metetra
.689 .776 .918 r
.71541 .38872 .72702 .40206 .75295 .39985 .74098 .37874 Metetra
.588 .635 .865 r
.74098 .37874 .75295 .39985 .77981 .40517 .7673 .37582 Metetra
.515 .527 .807 r
.7673 .37582 .77981 .40517 .80772 .41718 .79452 .37967 Metetra
.47 .457 .762 r
.79452 .37967 .80772 .41718 .83673 .43454 .82277 .38964 Metetra
.446 .416 .731 r
.82277 .38964 .83673 .43454 .8668 .45547 .85209 .40463 Metetra
.435 .393 .713 r
.85209 .40463 .8668 .45547 .8978 .47781 .88249 .42322 Metetra
.434 .385 .704 r
.88249 .42322 .8978 .47781 .92949 .49915 .91385 .44364 Metetra
.485 0 0 r
.29053 .60482 .3052 .61762 .32641 .63831 .31184 .62391 Metetra
0 .145 .644 r
.31184 .62391 .32641 .63831 .34826 .65752 .33375 .64179 Metetra
0 .302 .788 r
.33375 .64179 .34826 .65752 .37081 .67331 .35634 .65682 Metetra
.146 .462 .889 r
.35634 .65682 .37081 .67331 .39407 .68387 .37962 .66747 Metetra
.372 .593 .931 r
.37962 .66747 .39407 .68387 .41798 .68778 .40356 .67244 Metetra
.544 .69 .935 r
.40356 .67244 .41798 .68778 .44244 .68407 .42807 .67082 Metetra
.672 .766 .921 r
.42807 .67082 .44244 .68407 .4673 .67244 .45303 .66215 Metetra
.767 .828 .9 r
.45303 .66215 .4673 .67244 .49239 .65319 .47829 .6465 Metetra
.837 .882 .875 r
.47829 .6465 .49239 .65319 .51756 .62727 .5037 .62443 Metetra
.885 .927 .845 r
.5037 .62443 .51756 .62727 .54265 .59614 .52912 .59697 Metetra
.91 .96 .809 r
.52912 .59697 .54265 .59614 .56758 .56161 .55444 .56548 Metetra
.912 .98 .77 r
.55444 .56548 .56758 .56161 .59231 .52569 .5796 .53157 Metetra
.896 .986 .735 r
.5796 .53157 .59231 .52569 .61685 .49038 .60458 .49694 Metetra
.872 .987 .718 r
.60458 .49694 .61685 .49038 .64129 .45756 .62941 .46325 Metetra
.852 .991 .732 r
.62941 .46325 .64129 .45756 .66576 .42887 .65417 .43205 Metetra
.842 .998 .787 r
.65417 .43205 .66576 .42887 .6904 .40561 .67898 .40467 Metetra
.83 .988 .87 r
.67898 .40467 .6904 .40561 .71541 .38872 .704 .38218 Metetra
.784 .916 .928 r
.704 .38218 .71541 .38872 .74098 .37874 .72938 .36535 Metetra
.697 .784 .918 r
.72938 .36535 .74098 .37874 .7673 .37582 .7553 .35465 Metetra
.606 .647 .865 r
.7553 .35465 .7673 .37582 .79452 .37967 .78195 .35023 Metetra
.538 .543 .808 r
.78195 .35023 .79452 .37967 .82277 .38964 .80946 .35192 Metetra
.495 .474 .763 r
.80946 .35192 .82277 .38964 .85209 .40463 .83796 .35922 Metetra
.47 .431 .732 r
.83796 .35922 .85209 .40463 .88249 .42322 .86752 .37131 Metetra
.457 .406 .712 r
.86752 .37131 .88249 .42322 .91385 .44364 .89816 .3871 Metetra
0 .104 .582 r
.27563 .59181 .29053 .60482 .31184 .62391 .29703 .60928 Metetra
0 .201 .696 r
.29703 .60928 .31184 .62391 .33375 .64179 .31902 .62577 Metetra
0 .332 .81 r
.31902 .62577 .33375 .64179 .35634 .65682 .34166 .63993 Metetra
.153 .464 .889 r
.34166 .63993 .35634 .65682 .37962 .66747 .36497 .65045 Metetra
.348 .575 .926 r
.36497 .65045 .37962 .66747 .40356 .67244 .38893 .65621 Metetra
.504 .664 .933 r
.38893 .65621 .40356 .67244 .42807 .67082 .41348 .65634 Metetra
.626 .738 .927 r
.41348 .65634 .42807 .67082 .45303 .66215 .43851 .65034 Metetra
.722 .803 .915 r
.43851 .65034 .45303 .66215 .47829 .6465 .46391 .63806 Metetra
.797 .863 .898 r
.46391 .63806 .47829 .6465 .5037 .62443 .48953 .61979 Metetra
.853 .915 .874 r
.48953 .61979 .5037 .62443 .52912 .59697 .51524 .59618 Metetra
.887 .957 .842 r
.51524 .59618 .52912 .59697 .55444 .56548 .54094 .5682 Metetra
.896 .983 .799 r
.54094 .5682 .55444 .56548 .5796 .53157 .56652 .53708 Metetra
.882 .991 .752 r
.56652 .53708 .5796 .53157 .60458 .49694 .59196 .50417 Metetra
.853 .986 .711 r
.59196 .50417 .60458 .49694 .62941 .46325 .61723 .4709 Metetra
.822 .98 .691 r
.61723 .4709 .62941 .46325 .65417 .43205 .64238 .43863 Metetra
.804 .982 .708 r
.64238 .43863 .65417 .43205 .67898 .40467 .66749 .40862 Metetra
.805 .996 .77 r
.66749 .40862 .67898 .40467 .704 .38218 .69266 .38199 Metetra
.811 .995 .862 r
.69266 .38199 .704 .38218 .72938 .36535 .71804 .35961 Metetra
.785 .935 .929 r
.71804 .35961 .72938 .36535 .7553 .35465 .74377 .34215 Metetra
.714 .81 .925 r
.74377 .34215 .7553 .35465 .78195 .35023 .77001 .33006 Metetra
.632 .675 .873 r
.77001 .33006 .78195 .35023 .80946 .35192 .79693 .32349 Metetra
.566 .569 .816 r
.79693 .32349 .80946 .35192 .83796 .35922 .82467 .3224 Metetra
.522 .497 .769 r
.82467 .3224 .83796 .35922 .86752 .37131 .85334 .32645 Metetra
.495 .45 .736 r
.85334 .32645 .86752 .37131 .89816 .3871 .88304 .33509 Metetra
0 .175 .652 r
.26048 .5786 .27563 .59181 .29703 .60928 .282 .59442 Metetra
0 .26 .746 r
.282 .59442 .29703 .60928 .31902 .62577 .30408 .60947 Metetra
0 .366 .833 r
.30408 .60947 .31902 .62577 .34166 .63993 .32678 .62264 Metetra
.168 .471 .892 r
.32678 .62264 .34166 .63993 .36497 .65045 .35013 .63283 Metetra
.334 .562 .921 r
.35013 .63283 .36497 .65045 .38893 .65621 .37412 .6391 Metetra
.471 .64 .93 r
.37412 .6391 .38893 .65621 .41348 .65634 .39869 .64065 Metetra
.582 .709 .929 r
.39869 .64065 .41348 .65634 .43851 .65034 .42378 .63695 Metetra
.675 .773 .924 r
.42378 .63695 .43851 .65034 .46391 .63806 .44928 .62775 Metetra
.751 .835 .916 r
.44928 .62775 .46391 .63806 .48953 .61979 .47507 .61311 Metetra
.813 .894 .901 r
.47507 .61311 .48953 .61979 .51524 .59618 .50103 .59339 Metetra
.856 .946 .876 r
.50103 .59339 .51524 .59618 .54094 .5682 .52706 .56922 Metetra
.875 .981 .837 r
.52706 .56922 .54094 .5682 .56652 .53708 .55304 .54148 Metetra
.866 .996 .783 r
.55304 .54148 .56652 .53708 .59196 .50417 .57893 .5112 Metetra
.834 .989 .724 r
.57893 .5112 .59196 .50417 .61723 .4709 .60468 .47951 Metetra
.791 .971 .673 r
.60468 .47951 .61723 .4709 .64238 .43863 .63029 .44756 Metetra
.754 .956 .648 r
.63029 .44756 .64238 .43863 .66749 .40862 .65581 .41648 Metetra
.738 .957 .664 r
.65581 .41648 .66749 .40862 .69266 .38199 .68129 .38731 Metetra
.75 .978 .729 r
.68129 .38731 .69266 .38199 .71804 .35961 .70684 .36095 Metetra
.778 .998 .832 r
.70684 .36095 .71804 .35961 .74377 .34215 .73258 .33817 Metetra
.784 .965 .92 r
.73258 .33817 .74377 .34215 .77001 .33006 .75864 .31957 Metetra
.739 .857 .936 r
.75864 .31957 .77001 .33006 .79693 .32349 .78517 .30554 Metetra
.666 .722 .891 r
.78517 .30554 .79693 .32349 .82467 .3224 .81231 .29631 Metetra
.6 .609 .832 r
.81231 .29631 .82467 .3224 .85334 .32645 .84021 .29192 Metetra
.553 .529 .782 r
.84021 .29192 .85334 .32645 .88304 .33509 .86898 .29221 Metetra
0 .249 .719 r
.24509 .56516 .26048 .5786 .282 .59442 .26674 .57932 Metetra
0 .318 .792 r
.26674 .57932 .282 .59442 .30408 .60947 .28892 .59288 Metetra
.037 .401 .855 r
.28892 .59288 .30408 .60947 .32678 .62264 .3117 .60495 Metetra
.191 .482 .896 r
.3117 .60495 .32678 .62264 .35013 .63283 .33509 .61462 Metetra
.328 .554 .917 r
.33509 .61462 .35013 .63283 .37412 .6391 .3591 .62111 Metetra
.445 .619 .925 r
.3591 .62111 .37412 .6391 .39869 .64065 .3837 .62373 Metetra
.544 .68 .927 r
.3837 .62373 .39869 .64065 .42378 .63695 .40883 .62195 Metetra
.629 .74 .928 r
.40883 .62195 .42378 .63695 .44928 .62775 .4344 .61546 Metetra
.703 .801 .926 r
.4344 .61546 .44928 .62775 .47507 .61311 .46033 .60418 Metetra
.766 .864 .921 r
.46033 .60418 .47507 .61311 .50103 .59339 .4865 .58824 Metetra
.816 .923 .907 r
.4865 .58824 .50103 .59339 .52706 .56922 .51281 .56801 Metetra
.845 .971 .877 r
.51281 .56801 .52706 .56922 .55304 .54148 .53916 .54405 Metetra
.846 .997 .827 r
.53916 .54405 .55304 .54148 .57893 .5112 .56548 .51709 Metetra
.817 .995 .758 r
.56548 .51709 .57893 .5112 .60468 .47951 .59172 .48798 Metetra
.765 .969 .683 r
.59172 .48798 .60468 .47951 .63029 .44756 .61783 .45763 Metetra
.708 .935 .62 r
.61783 .45763 .63029 .44756 .65581 .41648 .64384 .42697 Metetra
.664 .909 .585 r
.64384 .42697 .65581 .41648 .68129 .38731 .66975 .39691 Metetra
.647 .907 .593 r
.66975 .39691 .68129 .38731 .70684 .36095 .69565 .3683 Metetra
.664 .933 .652 r
.69565 .3683 .70684 .36095 .73258 .33817 .7216 .34192 Metetra
.713 .977 .762 r
.7216 .34192 .73258 .33817 .75864 .31957 .74771 .31841 Metetra
.762 .992 .884 r
.74771 .31841 .75864 .31957 .78517 .30554 .7741 .2983 Metetra
.76 .923 .943 r
.7741 .2983 .78517 .30554 .81231 .29631 .80089 .28199 Metetra
.707 .795 .919 r
.80089 .28199 .81231 .29631 .84021 .29192 .82823 .26974 Metetra
.643 .671 .862 r
.82823 .26974 .84021 .29192 .86898 .29221 .85623 .26168 Metetra
0 .322 .781 r
.22944 .5515 .24509 .56516 .26674 .57932 .25123 .56398 Metetra
0 .376 .834 r
.25123 .56398 .26674 .57932 .28892 .59288 .27353 .576 Metetra
.094 .437 .876 r
.27353 .576 .28892 .59288 .3117 .60495 .2964 .58685 Metetra
.219 .497 .902 r
.2964 .58685 .3117 .60495 .33509 .61462 .31985 .59583 Metetra
.332 .552 .914 r
.31985 .59583 .33509 .61462 .3591 .62111 .3439 .60228 Metetra
.429 .603 .919 r
.3439 .60228 .3591 .62111 .3837 .62373 .36852 .6056 Metetra
.513 .654 .922 r
.36852 .6056 .3837 .62373 .40883 .62195 .39368 .60534 Metetra
.587 .707 .925 r
.39368 .60534 .40883 .62195 .4344 .61546 .41931 .60115 Metetra
.654 .763 .929 r
.41931 .60115 .4344 .61546 .46033 .60418 .44533 .59285 Metetra
.715 .824 .932 r
.44533 .59285 .46033 .60418 .4865 .58824 .47166 .58045 Metetra
.768 .887 .93 r
.47166 .58045 .4865 .58824 .51281 .56801 .49821 .56408 Metetra
.807 .945 .915 r
.49821 .56408 .51281 .56801 .53916 .54405 .52489 .54408 Metetra
.821 .987 .877 r
.52489 .54408 .53916 .54405 .56548 .51709 .55161 .52091 Metetra
.801 .999 .812 r
.55161 .52091 .56548 .51709 .59172 .48798 .57831 .49514 Metetra
.749 .977 .724 r
.57831 .49514 .59172 .48798 .61783 .45763 .60494 .46746 Metetra
.677 .93 .63 r
.60494 .46746 .61783 .45763 .64384 .42697 .63148 .43856 Metetra
.607 .878 .552 r
.63148 .43856 .64384 .42697 .66975 .39691 .65792 .4092 Metetra
.554 .839 .503 r
.65792 .4092 .66975 .39691 .69565 .3683 .68429 .3801 Metetra
.529 .826 .496 r
.68429 .3801 .69565 .3683 .7216 .34192 .71064 .35197 Metetra
.541 .848 .537 r
.71064 .35197 .7216 .34192 .74771 .31841 .73703 .32542 Metetra
.594 .903 .635 r
.73703 .32542 .74771 .31841 .7741 .2983 .76354 .30104 Metetra
.678 .97 .779 r
.76354 .30104 .7741 .2983 .80089 .28199 .79027 .27929 Metetra
.745 .983 .909 r
.79027 .27929 .80089 .28199 .82823 .26974 .81734 .26057 Metetra
.745 .898 .947 r
.81734 .26057 .82823 .26974 .85623 .26168 .84486 .24514 Metetra
0 .392 .835 r
.21353 .53762 .22944 .5515 .25123 .56398 .23548 .54839 Metetra
.048 .431 .87 r
.23548 .54839 .25123 .56398 .27353 .576 .25792 .55882 Metetra
.153 .473 .895 r
.25792 .55882 .27353 .576 .2964 .58685 .28088 .56837 Metetra
.253 .514 .907 r
.28088 .56837 .2964 .58685 .31985 .59583 .30441 .57647 Metetra
.343 .553 .912 r
.30441 .57647 .31985 .59583 .3439 .60228 .32851 .58261 Metetra
.421 .592 .914 r
.32851 .58261 .3439 .60228 .36852 .6056 .35316 .58629 Metetra
.491 .632 .915 r
.35316 .58629 .36852 .6056 .39368 .60534 .37834 .58712 Metetra
.553 .675 .919 r
.37834 .58712 .39368 .60534 .41931 .60115 .40401 .58477 Metetra
.611 .724 .926 r
.40401 .58477 .41931 .60115 .44533 .59285 .4301 .57902 Metetra
.666 .779 .934 r
.4301 .57902 .44533 .59285 .47166 .58045 .45656 .56976 Metetra
.716 .84 .941 r
.45656 .56976 .47166 .58045 .49821 .56408 .4833 .55702 Metetra
.759 .903 .941 r
.4833 .55702 .49821 .56408 .52489 .54408 .51024 .54093 Metetra
.785 .96 .923 r
.51024 .54093 .52489 .54408 .55161 .52091 .5373 .52175 Metetra
.783 .994 .876 r
.5373 .52175 .55161 .52091 .57831 .49514 .56443 .49982 Metetra
.742 .989 .794 r
.56443 .49982 .57831 .49514 .60494 .46746 .59156 .47559 Metetra
.667 .944 .684 r
.59156 .47559 .60494 .46746 .63148 .43856 .61865 .44957 Metetra
.577 .874 .571 r
.61865 .44957 .63148 .43856 .65792 .4092 .64567 .4223 Metetra
.64567 .4223 .65792 .4092 .68429 .3801 .67262 .39435 Metetra
.67262 .39435 .68429 .3801 .71064 .35197 .69951 .36631 Metetra
.69951 .36631 .71064 .35197 .73703 .32542 .72637 .33871 Metetra
.72637 .33871 .73703 .32542 .76354 .30104 .75325 .3121 Metetra
.75325 .3121 .76354 .30104 .79027 .27929 .78021 .28695 Metetra
.501 .847 .578 r
.78021 .28695 .79027 .27929 .81734 .26057 .80734 .26367 Metetra
.616 .943 .748 r
.80734 .26367 .81734 .26057 .84486 .24514 .83472 .24264 Metetra
.048 .458 .88 r
.19736 .5235 .21353 .53762 .23548 .54839 .21948 .53254 Metetra
.129 .483 .9 r
.21948 .53254 .23548 .54839 .25792 .55882 .24207 .54135 Metetra
.212 .508 .91 r
.24207 .54135 .25792 .55882 .28088 .56837 .26515 .54949 Metetra
.291 .534 .912 r
.26515 .54949 .28088 .56837 .30441 .57647 .28877 .55656 Metetra
.361 .559 .911 r
.28877 .55656 .30441 .57647 .32851 .58261 .31292 .56213 Metetra
.423 .586 .908 r
.31292 .56213 .32851 .58261 .35316 .58629 .33761 .56584 Metetra
.478 .615 .908 r
.33761 .56584 .35316 .58629 .37834 .58712 .36282 .56733 Metetra
.528 .648 .911 r
.36282 .56733 .37834 .58712 .40401 .58477 .38852 .56633 Metetra
.576 .687 .917 r
.38852 .56633 .40401 .58477 .4301 .57902 .41467 .56262 Metetra
.621 .733 .927 r
.41467 .56262 .4301 .57902 .45656 .56976 .44121 .55603 Metetra
.666 .786 .939 r
.44121 .55603 .45656 .56976 .4833 .55702 .46809 .54651 Metetra
.707 .847 .949 r
.46809 .54651 .4833 .55702 .51024 .54093 .49524 .53407 Metetra
.74 .91 .952 r
.49524 .53407 .51024 .54093 .5373 .52175 .5226 .51881 Metetra
.755 .964 .933 r
.5226 .51881 .5373 .52175 .56443 .49982 .5501 .5009 Metetra
.737 .99 .878 r
.5501 .5009 .56443 .49982 .59156 .47559 .57768 .4806 Metetra
.676 .97 .779 r
.57768 .4806 .59156 .47559 .61865 .44957 .6053 .45822 Metetra
.582 .904 .65 r
.6053 .45822 .61865 .44957 .64567 .4223 .63291 .43413 Metetra
.63291 .43413 .64567 .4223 .67262 .39435 .66048 .40872 Metetra
.66048 .40872 .67262 .39435 .69951 .36631 .68801 .38242 Metetra
.68801 .38242 .69951 .36631 .72637 .33871 .71549 .35567 Metetra
.71549 .35567 .72637 .33871 .75325 .3121 .74295 .3289 Metetra
.74295 .3289 .75325 .3121 .78021 .28695 .7704 .30253 Metetra
.7704 .30253 .78021 .28695 .80734 .26367 .79791 .27696 Metetra
.79791 .27696 .80734 .26367 .83472 .24264 .82552 .25254 Metetra
.141 .517 .915 r
.1809 .50914 .19736 .5235 .21948 .53254 .20322 .51644 Metetra
.207 .529 .922 r
.20322 .51644 .21948 .53254 .24207 .54135 .22597 .52358 Metetra
.271 .542 .921 r
.22597 .52358 .24207 .54135 .26515 .54949 .2492 .53023 Metetra
.331 .554 .916 r
.2492 .53023 .26515 .54949 .28877 .55656 .27293 .5361 Metetra
.384 .568 .909 r
.27293 .5361 .28877 .55656 .31292 .56213 .29716 .54088 Metetra
.431 .584 .904 r
.29716 .54088 .31292 .56213 .33761 .56584 .3219 .54427 Metetra
.474 .603 .9 r
.3219 .54427 .33761 .56584 .36282 .56733 .34714 .54602 Metetra
.513 .627 .901 r
.34714 .54602 .36282 .56733 .38852 .56633 .37286 .54588 Metetra
.55 .655 .905 r
.37286 .54588 .38852 .56633 .41467 .56262 .39905 .54365 Metetra
.586 .69 .914 r
.39905 .54365 .41467 .56262 .44121 .55603 .42565 .53917 Metetra
.622 .733 .926 r
.42565 .53917 .44121 .55603 .46809 .54651 .45263 .53234 Metetra
.657 .783 .941 r
.45263 .53234 .46809 .54651 .49524 .53407 .47994 .52309 Metetra
.69 .842 .956 r
.47994 .52309 .49524 .53407 .5226 .51881 .50753 .51143 Metetra
.714 .904 .963 r
.50753 .51143 .5226 .51881 .5501 .5009 .53534 .49741 Metetra
.72 .957 .947 r
.53534 .49741 .5501 .5009 .57768 .4806 .56331 .48114 Metetra
.692 .98 .891 r
.56331 .48114 .57768 .4806 .6053 .45822 .5914 .46279 Metetra
.618 .951 .782 r
.5914 .46279 .6053 .45822 .63291 .43413 .61957 .44255 Metetra
.509 .87 .637 r
.61957 .44255 .63291 .43413 .66048 .40872 .64777 .42068 Metetra
.64777 .42068 .66048 .40872 .68801 .38242 .67597 .39744 Metetra
.67597 .39744 .68801 .38242 .71549 .35567 .70416 .37314 Metetra
.70416 .37314 .71549 .35567 .74295 .3289 .73233 .34809 Metetra
.73233 .34809 .74295 .3289 .7704 .30253 .76048 .32261 Metetra
.76048 .32261 .7704 .30253 .79791 .27696 .78863 .29702 Metetra
.78863 .29702 .79791 .27696 .82552 .25254 .8168 .27163 Metetra
.229 .569 .939 r
.16417 .49454 .1809 .50914 .20322 .51644 .1867 .50008 Metetra
.28 .57 .936 r
.1867 .50008 .20322 .51644 .22597 .52358 .20964 .5055 Metetra
.329 .572 .929 r
.20964 .5055 .22597 .52358 .2492 .53023 .23302 .51058 Metetra
.373 .575 .918 r
.23302 .51058 .2492 .53023 .27293 .5361 .25687 .51512 Metetra
.412 .579 .908 r
.25687 .51512 .27293 .5361 .29716 .54088 .2812 .51888 Metetra
.447 .587 .899 r
.2812 .51888 .29716 .54088 .3219 .54427 .30601 .52166 Metetra
.478 .597 .893 r
.30601 .52166 .3219 .54427 .34714 .54602 .3313 .52325 Metetra
.508 .611 .89 r
.3313 .52325 .34714 .54602 .37286 .54588 .35706 .52348 Metetra
.535 .63 .892 r
.35706 .52348 .37286 .54588 .39905 .54365 .38327 .52217 Metetra
.562 .654 .898 r
.38327 .52217 .39905 .54365 .42565 .53917 .40992 .51917 Metetra
.589 .685 .908 r
.40992 .51917 .42565 .53917 .45263 .53234 .43697 .51439 Metetra
.616 .722 .922 r
.43697 .51439 .45263 .53234 .47994 .52309 .46439 .50772 Metetra
.643 .768 .939 r
.46439 .50772 .47994 .52309 .50753 .51143 .49215 .49912 Metetra
.668 .823 .958 r
.49215 .49912 .50753 .51143 .53534 .49741 .52019 .48856 Metetra
.687 .882 .971 r
.52019 .48856 .53534 .49741 .56331 .48114 .54848 .47608 Metetra
.689 .937 .965 r
.54848 .47608 .56331 .48114 .5914 .46279 .57697 .46172 Metetra
.66 .965 .92 r
.57697 .46172 .5914 .46279 .61957 .44255 .60562 .44556 Metetra
.584 .943 .818 r
.60562 .44556 .61957 .44255 .64777 .42068 .63439 .42773 Metetra
.469 .861 .667 r
.63439 .42773 .64777 .42068 .67597 .39744 .66325 .40837 Metetra
.66325 .40837 .67597 .39744 .70416 .37314 .69217 .38765 Metetra
.69217 .38765 .70416 .37314 .73233 .34809 .72111 .36577 Metetra
.72111 .36577 .73233 .34809 .76048 .32261 .75008 .34293 Metetra
.75008 .34293 .76048 .32261 .78863 .29702 .77905 .31935 Metetra
.77905 .31935 .78863 .29702 .8168 .27163 .80803 .29526 Metetra
.309 .612 .955 r
.14715 .47968 .16417 .49454 .1867 .50008 .1699 .48344 Metetra
.348 .606 .945 r
.1699 .48344 .1867 .50008 .20964 .5055 .19305 .48711 Metetra
.383 .6 .932 r
.19305 .48711 .20964 .5055 .23302 .51058 .21662 .49056 Metetra
.415 .595 .918 r
.21662 .49056 .23302 .51058 .25687 .51512 .24061 .49363 Metetra
.443 .592 .905 r
.24061 .49363 .25687 .51512 .2812 .51888 .26506 .49617 Metetra
.467 .592 .894 r
.26506 .49617 .2812 .51888 .30601 .52166 .28995 .49805 Metetra
.49 .595 .886 r
.28995 .49805 .30601 .52166 .3313 .52325 .3153 .49911 Metetra
.51 .601 .88 r
.3153 .49911 .3313 .52325 .35706 .52348 .34111 .49923 Metetra
.53 .611 .879 r
.34111 .49923 .35706 .52348 .38327 .52217 .36736 .49827 Metetra
.549 .626 .881 r
.36736 .49827 .38327 .52217 .40992 .51917 .39404 .49613 Metetra
.568 .645 .886 r
.39404 .49613 .40992 .51917 .43697 .51439 .42114 .49269 Metetra
.587 .67 .896 r
.42114 .49269 .43697 .51439 .46439 .50772 .44864 .48788 Metetra
.607 .702 .911 r
.44864 .48788 .46439 .50772 .49215 .49912 .47651 .48162 Metetra
.627 .741 .929 r
.47651 .48162 .49215 .49912 .52019 .48856 .50471 .47387 Metetra
.646 .788 .95 r
.50471 .47387 .52019 .48856 .54848 .47608 .53324 .4646 Metetra
.661 .842 .969 r
.53324 .4646 .54848 .47608 .57697 .46172 .56204 .45379 Metetra
.666 .898 .979 r
.56204 .45379 .57697 .46172 .60562 .44556 .59108 .44146 Metetra
.647 .941 .962 r
.59108 .44146 .60562 .44556 .63439 .42773 .62034 .42764 Metetra
.587 .946 .893 r
.62034 .42764 .63439 .42773 .66325 .40837 .64977 .41238 Metetra
.482 .89 .761 r
.64977 .41238 .66325 .40837 .69217 .38765 .67935 .39577 Metetra
.67935 .39577 .69217 .38765 .72111 .36577 .70905 .37787 Metetra
.70905 .37787 .72111 .36577 .75008 .34293 .73884 .35882 Metetra
.73884 .35882 .75008 .34293 .77905 .31935 .76871 .33871 Metetra
.76871 .33871 .77905 .31935 .80803 .29526 .79863 .31769 Metetra
.381 .648 .962 r
.12984 .46457 .14715 .47968 .1699 .48344 .15283 .46652 Metetra
.409 .636 .948 r
.15283 .46652 .1699 .48344 .19305 .48711 .17621 .46841 Metetra
.434 .624 .933 r
.17621 .46841 .19305 .48711 .21662 .49056 .19997 .47015 Metetra
.456 .614 .917 r
.19997 .47015 .21662 .49056 .24061 .49363 .22414 .47165 Metetra
.475 .605 .902 r
.22414 .47165 .24061 .49363 .26506 .49617 .24872 .4728 Metetra
.491 .6 .889 r
.24872 .4728 .26506 .49617 .28995 .49805 .27373 .47352 Metetra
.506 .597 .878 r
.27373 .47352 .28995 .49805 .3153 .49911 .29917 .4737 Metetra
.52 .596 .871 r
.29917 .4737 .3153 .49911 .34111 .49923 .32503 .47327 Metetra
.533 .599 .866 r
.32503 .47327 .34111 .49923 .36736 .49827 .35133 .47213 Metetra
.546 .606 .864 r
.35133 .47213 .36736 .49827 .39404 .49613 .37805 .4702 Metetra
.559 .616 .866 r
.37805 .4702 .39404 .49613 .42114 .49269 .40519 .4674 Metetra
.571 .629 .871 r
.40519 .4674 .42114 .49269 .44864 .48788 .43273 .46366 Metetra
.585 .648 .879 r
.43273 .46366 .44864 .48788 .47651 .48162 .46067 .45893 Metetra
.598 .671 .891 r
.46067 .45893 .47651 .48162 .50471 .47387 .48899 .45314 Metetra
.612 .701 .907 r
.48899 .45314 .50471 .47387 .53324 .4646 .51766 .44625 Metetra
.626 .738 .927 r
.51766 .44625 .53324 .4646 .56204 .45379 .54668 .43823 Metetra
.639 .782 .95 r
.54668 .43823 .56204 .45379 .59108 .44146 .57601 .42905 Metetra
.647 .833 .972 r
.57601 .42905 .59108 .44146 .62034 .42764 .60563 .4187 Metetra
.644 .885 .985 r
.60563 .4187 .62034 .42764 .64977 .41238 .63552 .40719 Metetra
.618 .926 .971 r
.63552 .40719 .64977 .41238 .67935 .39577 .66564 .39451 Metetra
.553 .93 .908 r
.66564 .39451 .67935 .39577 .70905 .37787 .69599 .3807 Metetra
.442 .873 .779 r
.69599 .3807 .70905 .37787 .73884 .35882 .72653 .36579 Metetra
.72653 .36579 .73884 .35882 .76871 .33871 .75724 .34981 Metetra
.75724 .34981 .76871 .33871 .79863 .31769 .78809 .33284 Metetra
.444 .677 .963 r
.11222 .44919 .12984 .46457 .15283 .46652 .13548 .44932 Metetra
.464 .661 .947 r
.13548 .44932 .15283 .46652 .17621 .46841 .1591 .4494 Metetra
.48 .645 .93 r
.1591 .4494 .17621 .46841 .19997 .47015 .18309 .44938 Metetra
.495 .631 .913 r
.18309 .44938 .19997 .47015 .22414 .47165 .20745 .4492 Metetra
.507 .619 .897 r
.20745 .4492 .22414 .47165 .24872 .4728 .2322 .4488 Metetra
.517 .609 .883 r
.2322 .4488 .24872 .4728 .27373 .47352 .25734 .44813 Metetra
.527 .601 .871 r
.25734 .44813 .27373 .47352 .29917 .4737 .28289 .44713 Metetra
.535 .596 .861 r
.28289 .44713 .29917 .4737 .32503 .47327 .30884 .44575 Metetra
.543 .593 .854 r
.30884 .44575 .32503 .47327 .35133 .47213 .33519 .44393 Metetra
.551 .593 .849 r
.33519 .44393 .35133 .47213 .37805 .4702 .36196 .44162 Metetra
.559 .595 .847 r
.36196 .44162 .37805 .4702 .40519 .4674 .38914 .43877 Metetra
.566 .601 .847 r
.38914 .43877 .40519 .4674 .43273 .46366 .41672 .43533 Metetra
.574 .609 .849 r
.41672 .43533 .43273 .46366 .46067 .45893 .4447 .43126 Metetra
.582 .62 .855 r
.4447 .43126 .46067 .45893 .48899 .45314 .47308 .42651 Metetra
.591 .635 .863 r
.47308 .42651 .48899 .45314 .51766 .44625 .50185 .42103 Metetra
.6 .654 .875 r
.50185 .42103 .51766 .44625 .54668 .43823 .53099 .41481 Metetra
.61 .678 .89 r
.53099 .41481 .54668 .43823 .57601 .42905 .56049 .4078 Metetra
.619 .708 .909 r
.56049 .4078 .57601 .42905 .60563 .4187 .59035 .39998 Metetra
.628 .745 .931 r
.59035 .39998 .60563 .4187 .63552 .40719 .62055 .39132 Metetra
.635 .788 .956 r
.62055 .39132 .63552 .40719 .66564 .39451 .65107 .38182 Metetra
.635 .837 .978 r
.65107 .38182 .66564 .39451 .69599 .3807 .68189 .37146 Metetra
.622 .884 .989 r
.68189 .37146 .69599 .3807 .72653 .36579 .71301 .36024 Metetra
.582 .916 .971 r
.71301 .36024 .72653 .36579 .75724 .34981 .7444 .34815 Metetra
.503 .908 .899 r
.7444 .34815 .75724 .34981 .78809 .33284 .77604 .33521 Metetra
.499 .701 .96 r
.09428 .43354 .11222 .44919 .13548 .44932 .11784 .43183 Metetra
.512 .681 .942 r
.11784 .43183 .13548 .44932 .1591 .4494 .14173 .43007 Metetra
.523 .663 .925 r
.14173 .43007 .1591 .4494 .18309 .44938 .16596 .42824 Metetra
.532 .646 .907 r
.16596 .42824 .18309 .44938 .20745 .4492 .19054 .42629 Metetra
.539 .631 .891 r
.19054 .42629 .20745 .4492 .2322 .4488 .21548 .42421 Metetra
.544 .618 .877 r
.21548 .42421 .2322 .4488 .25734 .44813 .24078 .42196 Metetra
.55 .607 .864 r
.24078 .42196 .25734 .44813 .28289 .44713 .26646 .41952 Metetra
.554 .598 .852 r
.26646 .41952 .28289 .44713 .30884 .44575 .29252 .41685 Metetra
.558 .591 .843 r
.29252 .41685 .30884 .44575 .33519 .44393 .31897 .41392 Metetra
.562 .586 .836 r
.31897 .41392 .33519 .44393 .36196 .44162 .3458 .41071 Metetra
.566 .583 .83 r
.3458 .41071 .36196 .44162 .38914 .43877 .37302 .40718 Metetra
.57 .582 .826 r
.37302 .40718 .38914 .43877 .41672 .43533 .40064 .40331 Metetra
.574 .583 .824 r
.40064 .40331 .41672 .43533 .4447 .43126 .42866 .39907 Metetra
.578 .585 .824 r
.42866 .39907 .4447 .43126 .47308 .42651 .45707 .39444 Metetra
.582 .59 .826 r
.45707 .39444 .47308 .42651 .50185 .42103 .48587 .38938 Metetra
.587 .597 .829 r
.48587 .38938 .50185 .42103 .53099 .41481 .51507 .38387 Metetra
.592 .607 .835 r
.51507 .38387 .53099 .41481 .56049 .4078 .54466 .37788 Metetra
.598 .619 .844 r
.54466 .37788 .56049 .4078 .59035 .39998 .57463 .3714 Metetra
.604 .635 .855 r
.57463 .3714 .59035 .39998 .62055 .39132 .60499 .36441 Metetra
.61 .654 .869 r
.60499 .36441 .62055 .39132 .65107 .38182 .63573 .35688 Metetra
.616 .678 .886 r
.63573 .35688 .65107 .38182 .68189 .37146 .66683 .34879 Metetra
.623 .707 .906 r
.66683 .34879 .68189 .37146 .71301 .36024 .6983 .34014 Metetra
.628 .742 .929 r
.6983 .34014 .71301 .36024 .7444 .34815 .73013 .3309 Metetra
.63 .783 .955 r
.73013 .3309 .7444 .34815 .77604 .33521 .76231 .32107 Metetra
.547 .719 .952 r
.07603 .41761 .09428 .43354 .11784 .43183 .0999 .41405 Metetra
.555 .698 .935 r
.0999 .41405 .11784 .43183 .14173 .43007 .12408 .41042 Metetra
.561 .678 .918 r
.12408 .41042 .14173 .43007 .16596 .42824 .14857 .40673 Metetra
.566 .66 .901 r
.14857 .40673 .16596 .42824 .19054 .42629 .1734 .40296 Metetra
.569 .643 .885 r
.1734 .40296 .19054 .42629 .21548 .42421 .19856 .39908 Metetra
.571 .628 .87 r
.19856 .39908 .21548 .42421 .24078 .42196 .22405 .3951 Metetra
.573 .615 .856 r
.22405 .3951 .24078 .42196 .26646 .41952 .2499 .391 Metetra
.575 .603 .844 r
.2499 .391 .26646 .41952 .29252 .41685 .2761 .38676 Metetra
.576 .593 .833 r
.2761 .38676 .29252 .41685 .31897 .41392 .30265 .38237 Metetra
.577 .585 .824 r
.30265 .38237 .31897 .41392 .3458 .41071 .32957 .37781 Metetra
.578 .577 .816 r
.32957 .37781 .3458 .41071 .37302 .40718 .35686 .37308 Metetra
.579 .572 .809 r
.35686 .37308 .37302 .40718 .40064 .40331 .38452 .36816 Metetra
.58 .567 .804 r
.38452 .36816 .40064 .40331 .42866 .39907 .41257 .36303 Metetra
.582 .564 .799 r
.41257 .36303 .42866 .39907 .45707 .39444 .44099 .35768 Metetra
.583 .562 .796 r
.44099 .35768 .45707 .39444 .48587 .38938 .46981 .3521 Metetra
.585 .562 .795 r
.46981 .3521 .48587 .38938 .51507 .38387 .49901 .34628 Metetra
.587 .562 .794 r
.49901 .34628 .51507 .38387 .54466 .37788 .52861 .34019 Metetra
.589 .565 .795 r
.52861 .34019 .54466 .37788 .57463 .3714 .5586 .33384 Metetra
.591 .568 .797 r
.5586 .33384 .57463 .3714 .60499 .36441 .589 .3272 Metetra
.594 .573 .8 r
.589 .3272 .60499 .36441 .63573 .35688 .61979 .32026 Metetra
.596 .58 .805 r
.61979 .32026 .63573 .35688 .66683 .34879 .65099 .31301 Metetra
.6 .588 .812 r
.65099 .31301 .66683 .34879 .6983 .34014 .68259 .30544 Metetra
.603 .599 .82 r
.68259 .30544 .6983 .34014 .73013 .3309 .71459 .29754 Metetra
.607 .612 .83 r
.71459 .29754 .73013 .3309 .76231 .32107 .747 .28929 Metetra
.589 .733 .943 r
.05745 .40139 .07603 .41761 .0999 .41405 .08165 .39595 Metetra
.593 .711 .926 r
.08165 .39595 .0999 .41405 .12408 .41042 .10614 .39045 Metetra
.595 .691 .909 r
.10614 .39045 .12408 .41042 .14857 .40673 .13093 .38487 Metetra
.597 .672 .893 r
.13093 .38487 .14857 .40673 .1734 .40296 .15603 .37921 Metetra
.597 .654 .877 r
.15603 .37921 .1734 .40296 .19856 .39908 .18143 .37347 Metetra
.597 .638 .862 r
.18143 .37347 .19856 .39908 .22405 .3951 .20714 .36764 Metetra
.597 .623 .849 r
.20714 .36764 .22405 .3951 .2499 .391 .23318 .36171 Metetra
.596 .61 .836 r
.23318 .36171 .2499 .391 .2761 .38676 .25955 .35569 Metetra
.595 .598 .824 r
.25955 .35569 .2761 .38676 .30265 .38237 .28624 .34957 Metetra
.594 .587 .814 r
.28624 .34957 .30265 .38237 .32957 .37781 .31328 .34333 Metetra
.593 .577 .804 r
.31328 .34333 .32957 .37781 .35686 .37308 .34065 .33699 Metetra
.592 .568 .796 r
.34065 .33699 .35686 .37308 .38452 .36816 .36838 .33052 Metetra
.592 .56 .788 r
.36838 .33052 .38452 .36816 .41257 .36303 .39646 .32393 Metetra
.591 .554 .781 r
.39646 .32393 .41257 .36303 .44099 .35768 .4249 .31721 Metetra
.59 .548 .775 r
.4249 .31721 .44099 .35768 .46981 .3521 .45371 .31036 Metetra
.59 .543 .77 r
.45371 .31036 .46981 .3521 .49901 .34628 .4829 .30337 Metetra
.589 .538 .765 r
.4829 .30337 .49901 .34628 .52861 .34019 .51246 .29622 Metetra
.589 .535 .762 r
.51246 .29622 .52861 .34019 .5586 .33384 .5424 .28893 Metetra
.589 .532 .758 r
.5424 .28893 .5586 .33384 .589 .3272 .57274 .28148 Metetra
.589 .53 .756 r
.57274 .28148 .589 .3272 .61979 .32026 .60347 .27386 Metetra
.589 .528 .754 r
.60347 .27386 .61979 .32026 .65099 .31301 .6346 .26608 Metetra
.59 .528 .753 r
.6346 .26608 .65099 .31301 .68259 .30544 .66614 .25812 Metetra
.59 .528 .753 r
.66614 .25812 .68259 .30544 .71459 .29754 .69809 .24998 Metetra
.591 .529 .753 r
.69809 .24998 .71459 .29754 .747 .28929 .73046 .24166 Metetra
.625 .743 .932 r
.03853 .38488 .05745 .40139 .08165 .39595 .06309 .37755 Metetra
.626 .722 .916 r
.06309 .37755 .08165 .39595 .10614 .39045 .08792 .37014 Metetra
.626 .701 .9 r
.08792 .37014 .10614 .39045 .13093 .38487 .11303 .36265 Metetra
.625 .682 .884 r
.11303 .36265 .13093 .38487 .15603 .37921 .13841 .35507 Metetra
.623 .664 .869 r
.13841 .35507 .15603 .37921 .18143 .37347 .16408 .3474 Metetra
.621 .647 .855 r
.16408 .3474 .18143 .37347 .20714 .36764 .19005 .33965 Metetra
.619 .632 .841 r
.19005 .33965 .20714 .36764 .23318 .36171 .2163 .3318 Metetra
.617 .617 .828 r
.2163 .3318 .23318 .36171 .25955 .35569 .24286 .32386 Metetra
.615 .604 .817 r
.24286 .32386 .25955 .35569 .28624 .34957 .26973 .31583 Metetra
.612 .592 .806 r
.26973 .31583 .28624 .34957 .31328 .34333 .2969 .3077 Metetra
.61 .58 .795 r
.2969 .3077 .31328 .34333 .34065 .33699 .32439 .29947 Metetra
.608 .57 .786 r
.32439 .29947 .34065 .33699 .36838 .33052 .3522 .29114 Metetra
.606 .56 .777 r
.3522 .29114 .36838 .33052 .39646 .32393 .38034 .28271 Metetra
.604 .551 .768 r
.38034 .28271 .39646 .32393 .4249 .31721 .40881 .27417 Metetra
.602 .543 .761 r
.40881 .27417 .4249 .31721 .45371 .31036 .43762 .26552 Metetra
.6 .535 .754 r
.43762 .26552 .45371 .31036 .4829 .30337 .46677 .25677 Metetra
.598 .528 .747 r
.46677 .25677 .4829 .30337 .51246 .29622 .49628 .2479 Metetra
.596 .521 .741 r
.49628 .2479 .51246 .29622 .5424 .28893 .52614 .23892 Metetra
.594 .515 .735 r
.52614 .23892 .5424 .28893 .57274 .28148 .55636 .22982 Metetra
.593 .51 .73 r
.55636 .22982 .57274 .28148 .60347 .27386 .58695 .2206 Metetra
.592 .505 .725 r
.58695 .2206 .60347 .27386 .6346 .26608 .61792 .21126 Metetra
.59 .5 .721 r
.61792 .21126 .6346 .26608 .66614 .25812 .64927 .20179 Metetra
.589 .496 .717 r
.64927 .20179 .66614 .25812 .69809 .24998 .68101 .1922 Metetra
.588 .492 .713 r
.68101 .1922 .69809 .24998 .73046 .24166 .71315 .18248 Metetra
.656 .751 .92 r
.01926 .36806 .03853 .38488 .06309 .37755 .04421 .35883 Metetra
.655 .73 .905 r
.04421 .35883 .06309 .37755 .08792 .37014 .0694 .3495 Metetra
.653 .71 .89 r
.0694 .3495 .08792 .37014 .11303 .36265 .09485 .34007 Metetra
.65 .691 .875 r
.09485 .34007 .11303 .36265 .13841 .35507 .12055 .33055 Metetra
.647 .673 .861 r
.12055 .33055 .13841 .35507 .16408 .3474 .14652 .32094 Metetra
.644 .656 .847 r
.14652 .32094 .16408 .3474 .19005 .33965 .17275 .31122 Metetra
.641 .64 .834 r
.17275 .31122 .19005 .33965 .2163 .3318 .19925 .3014 Metetra
.637 .625 .822 r
.19925 .3014 .2163 .3318 .24286 .32386 .22603 .29149 Metetra
.634 .611 .81 r
.22603 .29149 .24286 .32386 .26973 .31583 .25309 .28147 Metetra
.63 .598 .799 r
.25309 .28147 .26973 .31583 .2969 .3077 .28043 .27134 Metetra
.627 .586 .789 r
.28043 .27134 .2969 .3077 .32439 .29947 .30805 .26111 Metetra
.624 .575 .779 r
.30805 .26111 .32439 .29947 .3522 .29114 .33597 .25077 Metetra
.621 .564 .769 r
.33597 .25077 .3522 .29114 .38034 .28271 .36418 .24032 Metetra
.618 .554 .761 r
.36418 .24032 .38034 .28271 .40881 .27417 .3927 .22976 Metetra
.615 .545 .752 r
.3927 .22976 .40881 .27417 .43762 .26552 .42152 .21908 Metetra
.612 .536 .745 r
.42152 .21908 .43762 .26552 .46677 .25677 .45066 .20829 Metetra
.609 .528 .737 r
.45066 .20829 .46677 .25677 .49628 .2479 .48011 .19739 Metetra
.607 .52 .73 r
.48011 .19739 .49628 .2479 .52614 .23892 .50988 .18636 Metetra
.604 .512 .724 r
.50988 .18636 .52614 .23892 .55636 .22982 .53998 .17521 Metetra
.602 .505 .717 r
.53998 .17521 .55636 .22982 .58695 .2206 .57041 .16394 Metetra
.6 .499 .711 r
.57041 .16394 .58695 .2206 .61792 .21126 .60118 .15255 Metetra
.597 .493 .706 r
.60118 .15255 .61792 .21126 .64927 .20179 .63229 .14103 Metetra
.595 .487 .7 r
.63229 .14103 .64927 .20179 .68101 .1922 .66375 .12937 Metetra
.593 .481 .695 r
.66375 .12937 .68101 .1922 .71315 .18248 .69556 .11759 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(2)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(3)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.9.6"]
}, Open  ]],

Cell[TextData[{
  "There are many options for three\[Hyphen]dimensional plots in ",
  StyleBox["Mathematica", "TI"],
  ". Some will be discussed in this section; others will be described in \
Section ",
  ButtonBox["2.10",
    ButtonData:>{"2.10"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.9.6", "6.3"}],

Cell["\<\
The first set of options for three\[Hyphen]dimensional plots is \
largely analogous to those provided in the two\[Hyphen]dimensional case. \
\
\>", "Text",
  CellTags->{"S1.9.6", "6.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["Axes", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to include axes "]},
          {Cell[TextData[{
              StyleBox["AxesLabel", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[TextData[{
              "labels to be put on the axes: ",
              StyleBox["zlabel", "TI"],
              " specifies a label for the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["z",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axis, ",
              StyleBox["{", "MR"],
              StyleBox["xlabel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ylabel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["zlabel", "TI"],
              StyleBox["}", "MR"],
              " for all axes "
            }]]},
          {Cell[TextData[{
              StyleBox["Boxed", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], 
            Cell["\<\
whether to draw a three\[Hyphen]dimensional box around \
the surface \
\>"]},
          {Cell[TextData[{
              StyleBox["ColorFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              "what colors to use for shading; ",
              StyleBox["Hue", "MR"],
              " uses a sequence of hues "
            }]]},
          {Cell[TextData[{
              StyleBox["TextStyle", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$TextStyle", "MR"],
              " "
            }]], Cell["the default style to use for text in the plot "]},
          {Cell[TextData[{
              StyleBox["FormatType", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["StandardForm", "MR"],
              " "
            }]], Cell[
            "the default format type to use for text in the plot "]},
          {Cell[TextData[{
              StyleBox["DisplayFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["$DisplayFunction", "MR"],
              " "
            }]], Cell[TextData[{
              "how to display graphics; ",
              StyleBox["Identity", "MR"],
              " causes no display "
            }]]},
          {Cell[TextData[{
              StyleBox["FaceGrids", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell[TextData[{
              "how to draw grids on faces of the bounding box; ",
              StyleBox["All", "MR"],
              " draws a grid on every face "
            }]]},
          {Cell[TextData[{
              StyleBox["HiddenSurface", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to draw the surface as solid "]},
          {Cell[TextData[{
              StyleBox["Lighting", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[
            "whether to color the surface using simulated lighting "]},
          {Cell[TextData[{
              StyleBox["Mesh", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[TextData[{
              "whether an ",
              Cell[BoxData[
                  FormBox[
                    StyleBox[\(x  y\),
                      "TI"], TraditionalForm]], "InlineFormula"],
              " mesh should be drawn on the surface "
            }]]},
          {Cell[TextData[{
              StyleBox["PlotRange", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              
              "the range of coordinates to include in the plot: you can \
specify ",
              StyleBox["All", "MR"],
              ", ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" or ", "TR"],
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Shading", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[
            "whether the surface should be shaded or left white "]},
          {Cell[TextData[{
              StyleBox["ViewPoint", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{1.3,", "MR"],
              " ",
              StyleBox["-2.4,", "MR"],
              " ",
              StyleBox["2}", "MR"],
              " "
            }]], Cell[
            "the point in space from which to look at the surface "]},
          {Cell[TextData[{
              StyleBox["PlotPoints", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["25", "MR"],
              " "
            }]], Cell[TextData[{
              
              "the number of points in each direction at which to sample the \
function; ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" specifies different numbers in the ", "TR"],
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " directions "
            }]]},
          {Cell[TextData[{
              StyleBox["Compiled", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to compile the function being plotted "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, False, False, False, False, False, 
      False, False, False, False, True, False}},
  CellTags->"S1.9.6"],

Cell[TextData[{
  "Some options for ",
  StyleBox["Plot3D", "MR"],
  ". The first set can also be used in ",
  StyleBox["Show", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.9.6"],

Cell[TextData[{
  "This redraws the plot on the previous line, with options changed. With \
this setting for ",
  StyleBox["PlotRange", "MR"],
  ", only the part of the surface in the range ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(-0.5\), "\[LessEqual]", 
          StyleBox["z",
            "TI"], "\[LessEqual]", "0.5"}], TraditionalForm]], 
    "InlineFormula"],
  " is shown."
}], "MathCaption",
  CellTags->{"S1.9.6", "6.5"}],

Cell[CellGroupData[{

Cell["Show[%, PlotRange -> {-0.5, 0.5}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.84061e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.22808 .16727 -5.79519 -9 ]
[.22808 .16727 .20481 0 ]
[.44535 .08183 -5.37821 -9 ]
[.44535 .08183 .62179 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.80849 .15988 0 -6.10118 ]
[.80849 .15988 6 2.89882 ]
[.90119 .30183 0 -5.96721 ]
[.90119 .30183 6 3.03279 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02145 .28182 -24 -2.75643 ]
[.02145 .28182 0 6.24357 ]
[.01431 .32657 -24 -2.7943 ]
[.01431 .32657 0 6.2057 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00061 .42007 -18 -2.87377 ]
[-0.00061 .42007 0 6.12623 ]
[-0.00841 .46894 -18 -2.91549 ]
[-0.00841 .46894 0 6.08451 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(2)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(3)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.79613 .16428 m
.78995 .16648 L
s
[(1)] .80849 .15988 -1 .35582 Mshowa
.88871 .30589 m
.88247 .30793 L
s
[(2)] .90119 .30183 -1 .32605 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(3)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71157 .03492 m
.70789 .03634 L
s
.73369 .06877 m
.73001 .07015 L
s
.75514 .10158 m
.75145 .10294 L
s
.77594 .1334 m
.77224 .13474 L
s
.81573 .19425 m
.81201 .19555 L
s
.83476 .22337 m
.83104 .22465 L
s
.85326 .25166 m
.84953 .25292 L
s
.87123 .27915 m
.8675 .28039 L
s
.90572 .33191 m
.90197 .33311 L
s
.92227 .35722 m
.91851 .3584 L
s
.93838 .38186 m
.93462 .38303 L
s
.95406 .40586 m
.9503 .40701 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03368 .27708 m
.0398 .27471 L
s
[(-0.4)] .02145 .28182 1 -0.38746 Mshowa
.02658 .32192 m
.03271 .3196 L
s
[(-0.2)] .01431 .32657 1 -0.37904 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01173 .41561 m
.0179 .41338 L
s
[(0.2)] -0.00061 .42007 1 -0.36138 Mshowa
.00397 .46458 m
.01016 .4624 L
s
[(0.4)] -0.00841 .46894 1 -0.35211 Mshowa
.125 Mabswid
.03193 .28817 m
.0356 .28676 L
s
.03016 .29934 m
.03383 .29793 L
s
.02837 .31059 m
.03205 .30919 L
s
.02477 .33334 m
.02845 .33195 L
s
.02295 .34483 m
.02663 .34345 L
s
.02111 .35641 m
.0248 .35504 L
s
.0174 .37983 m
.02109 .37847 L
s
.01552 .39167 m
.01922 .39032 L
s
.01363 .4036 m
.01733 .40225 L
s
.00981 .42772 m
.01352 .42639 L
s
.00788 .43991 m
.01159 .43859 L
s
.00593 .4522 m
.00964 .45089 L
s
.03543 .26607 m
.0391 .26464 L
s
.00199 .47706 m
.00571 .47576 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.933 .572 .307 r
.38853 .69037 .40169 .70185 .42139 .77524 .40813 .76077 Metetra
.629 .141 0 r
.40813 .76077 .42139 .77524 .44337 .79922 .43002 .78805 Metetra
.645 .763 .934 r
.43002 .78805 .44337 .79922 .46642 .79319 .45318 .78192 Metetra
.645 .763 .934 r
.45318 .78192 .46642 .79319 .48965 .78711 .47655 .77574 Metetra
.645 .763 .934 r
.47655 .77574 .48965 .78711 .51309 .78097 .50012 .7695 Metetra
.645 .763 .934 r
.50012 .7695 .51309 .78097 .53673 .77478 .52389 .76322 Metetra
.645 .763 .934 r
.52389 .76322 .53673 .77478 .56056 .76715 .54787 .75687 Metetra
.919 .771 .682 r
.54787 .75687 .56056 .76715 .58328 .68154 .57135 .69662 Metetra
.996 .865 .561 r
.57135 .69662 .58328 .68154 .60511 .59482 .59381 .61177 Metetra
.988 .878 .535 r
.59381 .61177 .60511 .59482 .62677 .53231 .61554 .53237 Metetra
.828 .982 .88 r
.61554 .53237 .62677 .53231 .64992 .52534 .63848 .51233 Metetra
.664 .741 .907 r
.63848 .51233 .64992 .52534 .67327 .51832 .66196 .5052 Metetra
.664 .741 .907 r
.66196 .5052 .67327 .51832 .69681 .51124 .68563 .498 Metetra
.664 .741 .907 r
.68563 .498 .69681 .51124 .72055 .50409 .70951 .49075 Metetra
.664 .741 .907 r
.70951 .49075 .72055 .50409 .74449 .49689 .73359 .48343 Metetra
.664 .741 .907 r
.73359 .48343 .74449 .49689 .77203 .53581 .75787 .47606 Metetra
.108 .145 .618 r
.75787 .47606 .77203 .53581 .80329 .60943 .78779 .53797 Metetra
.137 .149 .608 r
.78779 .53797 .80329 .60943 .83612 .68438 .81986 .61 Metetra
.212 .2 .627 r
.81986 .61 .83612 .68438 .86368 .68919 .85285 .6762 Metetra
.645 .763 .934 r
.85285 .6762 .86368 .68919 .89044 .68218 .87979 .66908 Metetra
.645 .763 .934 r
.87979 .66908 .89044 .68218 .91746 .67511 .90698 .66188 Metetra
.645 .763 .934 r
.90698 .66188 .91746 .67511 .94472 .66797 .93443 .65462 Metetra
.645 .763 .934 r
.93443 .65462 .94472 .66797 .97223 .66077 .96213 .6473 Metetra
.645 .763 .934 r
.96213 .6473 .97223 .66077 .99714 .63256 .9901 .6399 Metetra
.931 .564 .294 r
.37517 .67871 .38853 .69037 .40813 .76077 .3947 .74607 Metetra
.71 .228 0 r
.3947 .74607 .40813 .76077 .43002 .78805 .41645 .77669 Metetra
.645 .763 .934 r
.41645 .77669 .43002 .78805 .45318 .78192 .43974 .77047 Metetra
.645 .763 .934 r
.43974 .77047 .45318 .78192 .47655 .77574 .46324 .76419 Metetra
.645 .763 .934 r
.46324 .76419 .47655 .77574 .50012 .7695 .48694 .75785 Metetra
.645 .763 .934 r
.48694 .75785 .50012 .7695 .52389 .76322 .51084 .75146 Metetra
.645 .763 .934 r
.51084 .75146 .52389 .76322 .54787 .75687 .53496 .74502 Metetra
.866 .783 .768 r
.53496 .74502 .54787 .75687 .57135 .69662 .55903 .71124 Metetra
.995 .872 .57 r
.55903 .71124 .57135 .69662 .59381 .61177 .58214 .62969 Metetra
.986 .88 .532 r
.58214 .62969 .59381 .61177 .61554 .53237 .60446 .54968 Metetra
.86 .903 .489 r
.60446 .54968 .61554 .53237 .63848 .51233 .62685 .49911 Metetra
.664 .741 .907 r
.62685 .49911 .63848 .51233 .66196 .5052 .65046 .49187 Metetra
.664 .741 .907 r
.65046 .49187 .66196 .5052 .68563 .498 .67428 .48456 Metetra
.664 .741 .907 r
.67428 .48456 .68563 .498 .70951 .49075 .69829 .4772 Metetra
.664 .741 .907 r
.69829 .4772 .70951 .49075 .73359 .48343 .72251 .46977 Metetra
.664 .741 .907 r
.72251 .46977 .73359 .48343 .75787 .47606 .74694 .46227 Metetra
.294 .558 .927 r
.74694 .46227 .75787 .47606 .78779 .53797 .77276 .47033 Metetra
.166 .173 .621 r
.77276 .47033 .78779 .53797 .81986 .61 .80363 .53379 Metetra
.191 .182 .617 r
.80363 .53379 .81986 .61 .85285 .6762 .8364 .60324 Metetra
.298 .261 .648 r
.8364 .60324 .85285 .6762 .87979 .66908 .86896 .65574 Metetra
.645 .763 .934 r
.86896 .65574 .87979 .66908 .90698 .66188 .89633 .64843 Metetra
.645 .763 .934 r
.89633 .64843 .90698 .66188 .93443 .65462 .92397 .64104 Metetra
.645 .763 .934 r
.92397 .64104 .93443 .65462 .96213 .6473 .95186 .63358 Metetra
.645 .763 .934 r
.95186 .63358 .96213 .6473 .9901 .6399 .98003 .62606 Metetra
.928 .556 .279 r
.36161 .66687 .37517 .67871 .3947 .74607 .38107 .73115 Metetra
.77 .298 0 r
.38107 .73115 .3947 .74607 .41645 .77669 .40266 .76516 Metetra
.645 .763 .934 r
.40266 .76516 .41645 .77669 .43974 .77047 .42608 .75883 Metetra
.645 .763 .934 r
.42608 .75883 .43974 .77047 .46324 .76419 .44971 .75245 Metetra
.645 .763 .934 r
.44971 .75245 .46324 .76419 .48694 .75785 .47354 .74601 Metetra
.645 .763 .934 r
.47354 .74601 .48694 .75785 .51084 .75146 .49758 .73952 Metetra
.645 .763 .934 r
.49758 .73952 .51084 .75146 .53496 .74502 .52184 .73297 Metetra
.67 .77 .925 r
.52184 .73297 .53496 .74502 .55903 .71124 .5463 .72494 Metetra
.993 .88 .584 r
.5463 .72494 .55903 .71124 .58214 .62969 .57007 .64802 Metetra
.983 .885 .534 r
.57007 .64802 .58214 .62969 .60446 .54968 .59303 .56912 Metetra
.961 .889 .503 r
.59303 .56912 .60446 .54968 .62685 .49911 .61532 .49587 Metetra
.808 .943 .914 r
.61532 .49587 .62685 .49911 .65046 .49187 .63879 .47833 Metetra
.664 .741 .907 r
.63879 .47833 .65046 .49187 .67428 .48456 .66274 .47091 Metetra
.664 .741 .907 r
.66274 .47091 .67428 .48456 .69829 .4772 .6869 .46343 Metetra
.664 .741 .907 r
.6869 .46343 .69829 .4772 .72251 .46977 .71126 .45588 Metetra
.664 .741 .907 r
.71126 .45588 .72251 .46977 .74694 .46227 .73584 .44826 Metetra
.664 .741 .907 r
.73584 .44826 .74694 .46227 .77276 .47033 .76063 .44058 Metetra
.293 .38 .781 r
.76063 .44058 .77276 .47033 .80363 .53379 .78787 .46073 Metetra
.216 .201 .626 r
.78787 .46073 .80363 .53379 .8364 .60324 .81945 .52263 Metetra
.237 .209 .623 r
.81945 .52263 .8364 .60324 .86896 .65574 .85282 .58903 Metetra
.312 .281 .663 r
.85282 .58903 .86896 .65574 .89633 .64843 .8855 .63474 Metetra
.645 .763 .934 r
.8855 .63474 .89633 .64843 .92397 .64104 .91332 .62722 Metetra
.645 .763 .934 r
.91332 .62722 .92397 .64104 .95186 .63358 .94141 .61963 Metetra
.645 .763 .934 r
.94141 .61963 .95186 .63358 .98003 .62606 .96977 .61197 Metetra
.925 .546 .262 r
.34784 .65485 .36161 .66687 .38107 .73115 .36726 .71601 Metetra
.814 .354 0 r
.36726 .71601 .38107 .73115 .40266 .76516 .38865 .75343 Metetra
.645 .763 .934 r
.38865 .75343 .40266 .76516 .42608 .75883 .4122 .74701 Metetra
.645 .763 .934 r
.4122 .74701 .42608 .75883 .44971 .75245 .43596 .74052 Metetra
.645 .763 .934 r
.43596 .74052 .44971 .75245 .47354 .74601 .45993 .73398 Metetra
.645 .763 .934 r
.45993 .73398 .47354 .74601 .49758 .73952 .48411 .72738 Metetra
.645 .763 .934 r
.48411 .72738 .49758 .73952 .52184 .73297 .5085 .72072 Metetra
.645 .763 .934 r
.5085 .72072 .52184 .73297 .5463 .72494 .53312 .714 Metetra
.905 .786 .719 r
.53312 .714 .5463 .72494 .57007 .64802 .55757 .66613 Metetra
.98 .892 .542 r
.55757 .66613 .57007 .64802 .59303 .56912 .58119 .59001 Metetra
.953 .888 .493 r
.58119 .59001 .59303 .56912 .61532 .49587 .60409 .51587 Metetra
.795 .865 .424 r
.60409 .51587 .61532 .49587 .63879 .47833 .62694 .46458 Metetra
.664 .741 .907 r
.62694 .46458 .63879 .47833 .66274 .47091 .65103 .45704 Metetra
.664 .741 .907 r
.65103 .45704 .66274 .47091 .6869 .46343 .67533 .44944 Metetra
.664 .741 .907 r
.67533 .44944 .6869 .46343 .71126 .45588 .69983 .44177 Metetra
.664 .741 .907 r
.69983 .44177 .71126 .45588 .73584 .44826 .72456 .43403 Metetra
.664 .741 .907 r
.72456 .43403 .73584 .44826 .76063 .44058 .7495 .42623 Metetra
.664 .741 .907 r
.7495 .42623 .76063 .44058 .78787 .46073 .77465 .41835 Metetra
.324 .339 .722 r
.77465 .41835 .78787 .46073 .81945 .52263 .80296 .44474 Metetra
.26 .226 .629 r
.80296 .44474 .81945 .52263 .85282 .58903 .83512 .50409 Metetra
.276 .232 .627 r
.83512 .50409 .85282 .58903 .8855 .63474 .86903 .56727 Metetra
.312 .281 .663 r
.86903 .56727 .8855 .63474 .91332 .62722 .90249 .61316 Metetra
.645 .763 .934 r
.90249 .61316 .91332 .62722 .94141 .61963 .93078 .60543 Metetra
.645 .763 .934 r
.93078 .60543 .94141 .61963 .96977 .61197 .95934 .59764 Metetra
.921 .535 .243 r
.33385 .64264 .34784 .65485 .36726 .71601 .35325 .70063 Metetra
.847 .399 0 r
.35325 .70063 .36726 .71601 .38865 .75343 .37442 .74152 Metetra
.645 .763 .934 r
.37442 .74152 .38865 .75343 .4122 .74701 .3981 .73499 Metetra
.645 .763 .934 r
.3981 .73499 .4122 .74701 .43596 .74052 .42198 .7284 Metetra
.645 .763 .934 r
.42198 .7284 .43596 .74052 .45993 .73398 .44609 .72174 Metetra
.645 .763 .934 r
.44609 .72174 .45993 .73398 .48411 .72738 .4704 .71503 Metetra
.645 .763 .934 r
.4704 .71503 .48411 .72738 .5085 .72072 .49494 .70826 Metetra
.645 .763 .934 r
.49494 .70826 .5085 .72072 .53312 .714 .5197 .70143 Metetra
.783 .79 .859 r
.5197 .70143 .53312 .714 .55757 .66613 .54462 .68338 Metetra
.976 .902 .557 r
.54462 .68338 .55757 .66613 .58119 .59001 .56892 .61158 Metetra
.944 .891 .491 r
.56892 .61158 .58119 .59001 .60409 .51587 .59248 .53848 Metetra
.902 .878 .447 r
.59248 .53848 .60409 .51587 .62694 .46458 .61542 .4698 Metetra
.825 .995 .758 r
.61542 .4698 .62694 .46458 .65103 .45704 .63912 .44295 Metetra
.664 .741 .907 r
.63912 .44295 .65103 .45704 .67533 .44944 .66357 .43523 Metetra
.664 .741 .907 r
.66357 .43523 .67533 .44944 .69983 .44177 .68822 .42743 Metetra
.664 .741 .907 r
.68822 .42743 .69983 .44177 .72456 .43403 .71309 .41957 Metetra
.664 .741 .907 r
.71309 .41957 .72456 .43403 .7495 .42623 .73818 .41164 Metetra
.664 .741 .907 r
.73818 .41164 .7495 .42623 .77465 .41835 .7635 .40364 Metetra
.664 .741 .907 r
.7635 .40364 .77465 .41835 .80296 .44474 .78904 .39556 Metetra
.364 .345 .705 r
.78904 .39556 .80296 .44474 .83512 .50409 .81792 .42194 Metetra
.298 .248 .632 r
.81792 .42194 .83512 .50409 .86903 .56727 .85055 .47796 Metetra
.309 .251 .629 r
.85055 .47796 .86903 .56727 .90249 .61316 .88492 .53781 Metetra
.298 .261 .648 r
.88492 .53781 .90249 .61316 .93078 .60543 .91995 .59098 Metetra
.645 .763 .934 r
.91995 .59098 .93078 .60543 .95934 .59764 .94871 .58304 Metetra
.916 .521 .221 r
.31963 .63024 .33385 .64264 .35325 .70063 .33905 .68502 Metetra
.87 .435 .039 r
.33905 .68502 .35325 .70063 .37442 .74152 .35995 .72941 Metetra
.645 .763 .934 r
.35995 .72941 .37442 .74152 .3981 .73499 .38376 .72277 Metetra
.645 .763 .934 r
.38376 .72277 .3981 .73499 .42198 .7284 .40778 .71607 Metetra
.645 .763 .934 r
.40778 .71607 .42198 .7284 .44609 .72174 .43202 .70931 Metetra
.645 .763 .934 r
.43202 .70931 .44609 .72174 .4704 .71503 .45647 .70248 Metetra
.645 .763 .934 r
.45647 .70248 .4704 .71503 .49494 .70826 .48115 .6956 Metetra
.645 .763 .934 r
.48115 .6956 .49494 .70826 .5197 .70143 .50606 .68865 Metetra
.645 .763 .934 r
.50606 .68865 .5197 .70143 .54462 .68338 .53119 .68164 Metetra
.951 .87 .721 r
.53119 .68164 .54462 .68338 .56892 .61158 .55618 .63299 Metetra
.936 .897 .498 r
.55618 .63299 .56892 .61158 .59248 .53848 .58044 .56279 Metetra
.883 .871 .43 r
.58044 .56279 .59248 .53848 .61542 .4698 .60402 .49368 Metetra
.831 .852 .393 r
.60402 .49368 .61542 .4698 .63912 .44295 .62708 .43027 Metetra
.689 .774 .916 r
.62708 .43027 .63912 .44295 .66357 .43523 .65161 .42078 Metetra
.664 .741 .907 r
.65161 .42078 .66357 .43523 .68822 .42743 .67642 .41286 Metetra
.664 .741 .907 r
.67642 .41286 .68822 .42743 .71309 .41957 .70144 .40487 Metetra
.664 .741 .907 r
.70144 .40487 .71309 .41957 .73818 .41164 .72669 .39681 Metetra
.664 .741 .907 r
.72669 .39681 .73818 .41164 .7635 .40364 .75216 .38867 Metetra
.664 .741 .907 r
.75216 .38867 .7635 .40364 .78904 .39556 .77786 .38047 Metetra
.664 .741 .907 r
.77786 .38047 .78904 .39556 .81792 .42194 .80379 .37218 Metetra
.421 .382 .71 r
.80379 .37218 .81792 .42194 .85055 .47796 .83267 .39219 Metetra
.332 .268 .634 r
.83267 .39219 .85055 .47796 .88492 .53781 .86562 .44416 Metetra
.339 .268 .629 r
.86562 .44416 .88492 .53781 .91995 .59098 .90035 .50039 Metetra
.338 .272 .635 r
.90035 .50039 .91995 .59098 .94871 .58304 .9364 .5559 Metetra
.91 .506 .195 r
.3052 .61764 .31963 .63024 .33905 .68502 .32464 .66918 Metetra
.888 .464 .085 r
.32464 .66918 .33905 .68502 .35995 .72941 .34524 .7171 Metetra
.645 .763 .934 r
.34524 .7171 .35995 .72941 .38376 .72277 .36918 .71035 Metetra
.645 .763 .934 r
.36918 .71035 .38376 .72277 .40778 .71607 .39333 .70354 Metetra
.645 .763 .934 r
.39333 .70354 .40778 .71607 .43202 .70931 .41771 .69666 Metetra
.645 .763 .934 r
.41771 .69666 .43202 .70931 .45647 .70248 .44231 .68972 Metetra
.645 .763 .934 r
.44231 .68972 .45647 .70248 .48115 .6956 .46713 .68272 Metetra
.645 .763 .934 r
.46713 .68272 .48115 .6956 .50606 .68865 .49218 .67566 Metetra
.645 .763 .934 r
.49218 .67566 .50606 .68865 .53119 .68164 .51747 .66853 Metetra
.753 .788 .882 r
.51747 .66853 .53119 .68164 .55618 .63299 .54295 .65334 Metetra
.928 .908 .515 r
.54295 .65334 .55618 .63299 .58044 .56279 .56791 .58775 Metetra
.864 .869 .425 r
.56791 .58775 .58044 .56279 .60402 .49368 .5922 .52033 Metetra
.793 .829 .357 r
.5922 .52033 .60402 .49368 .62708 .43027 .61588 .45535 Metetra
.61588 .45535 .62708 .43027 .65161 .42078 .63947 .40611 Metetra
.664 .741 .907 r
.63947 .40611 .65161 .42078 .67642 .41286 .66442 .39805 Metetra
.664 .741 .907 r
.66442 .39805 .67642 .41286 .70144 .40487 .6896 .38993 Metetra
.664 .741 .907 r
.6896 .38993 .70144 .40487 .72669 .39681 .715 .38173 Metetra
.664 .741 .907 r
.715 .38173 .72669 .39681 .75216 .38867 .74063 .37346 Metetra
.664 .741 .907 r
.74063 .37346 .75216 .38867 .77786 .38047 .76649 .36512 Metetra
.664 .741 .907 r
.76649 .36512 .77786 .38047 .80379 .37218 .79259 .3567 Metetra
.664 .741 .907 r
.79259 .3567 .80379 .37218 .83267 .39219 .81892 .3482 Metetra
.51 .456 .733 r
.81892 .3482 .83267 .39219 .86562 .44416 .84713 .35568 Metetra
.363 .286 .635 r
.84713 .35568 .86562 .44416 .90035 .50039 .88023 .40277 Metetra
.366 .283 .629 r
.88023 .40277 .90035 .50039 .9364 .5559 .91519 .45483 Metetra
.902 .487 .165 r
.29053 .60484 .3052 .61764 .32464 .66918 .31003 .65309 Metetra
.882 .454 .068 r
.31003 .65309 .32464 .66918 .34524 .7171 .33055 .69976 Metetra
.566 .668 .907 r
.33055 .69976 .34524 .7171 .36918 .71035 .35436 .69772 Metetra
.645 .763 .934 r
.35436 .69772 .36918 .71035 .39333 .70354 .37865 .6908 Metetra
.645 .763 .934 r
.37865 .6908 .39333 .70354 .41771 .69666 .40316 .6838 Metetra
.645 .763 .934 r
.40316 .6838 .41771 .69666 .44231 .68972 .4279 .67675 Metetra
.645 .763 .934 r
.4279 .67675 .44231 .68972 .46713 .68272 .45287 .66963 Metetra
.645 .763 .934 r
.45287 .66963 .46713 .68272 .49218 .67566 .47807 .66244 Metetra
.645 .763 .934 r
.47807 .66244 .49218 .67566 .51747 .66853 .50351 .65518 Metetra
.645 .763 .934 r
.50351 .65518 .51747 .66853 .54295 .65334 .52918 .64786 Metetra
.911 .875 .788 r
.52918 .64786 .54295 .65334 .56791 .58775 .55485 .6122 Metetra
.847 .874 .432 r
.55485 .6122 .56791 .58775 .5922 .52033 .57988 .54848 Metetra
.758 .813 .337 r
.57988 .54848 .5922 .52033 .61588 .45535 .60428 .48429 Metetra
.679 .762 .274 r
.60428 .48429 .61588 .45535 .63947 .40611 .62814 .4231 Metetra
.671 .84 .423 r
.62814 .4231 .63947 .40611 .66442 .39805 .65222 .383 Metetra
.664 .741 .907 r
.65222 .383 .66442 .39805 .6896 .38993 .67755 .37474 Metetra
.664 .741 .907 r
.67755 .37474 .6896 .38993 .715 .38173 .70311 .36641 Metetra
.664 .741 .907 r
.70311 .36641 .715 .38173 .74063 .37346 .72891 .358 Metetra
.664 .741 .907 r
.72891 .358 .74063 .37346 .76649 .36512 .75493 .34951 Metetra
.664 .741 .907 r
.75493 .34951 .76649 .36512 .79259 .3567 .7812 .34095 Metetra
.664 .741 .907 r
.7812 .34095 .79259 .3567 .81892 .3482 .8077 .33231 Metetra
.664 .741 .907 r
.8077 .33231 .81892 .3482 .84713 .35568 .83446 .32358 Metetra
.641 .585 .776 r
.83446 .32358 .84713 .35568 .88023 .40277 .86146 .31478 Metetra
.397 .31 .639 r
.86146 .31478 .88023 .40277 .91519 .45483 .89433 .35422 Metetra
.891 .465 .13 r
.27563 .59183 .29053 .60484 .31003 .65309 .29521 .63675 Metetra
.866 .428 .028 r
.29521 .63675 .31003 .65309 .33055 .69976 .31576 .6805 Metetra
.421 .581 .905 r
.31576 .6805 .33055 .69976 .35436 .69772 .33928 .68488 Metetra
.645 .763 .934 r
.33928 .68488 .35436 .69772 .37865 .6908 .36371 .67784 Metetra
.645 .763 .934 r
.36371 .67784 .37865 .6908 .40316 .6838 .38837 .67073 Metetra
.645 .763 .934 r
.38837 .67073 .40316 .6838 .4279 .67675 .41325 .66355 Metetra
.645 .763 .934 r
.41325 .66355 .4279 .67675 .45287 .66963 .43837 .6563 Metetra
.645 .763 .934 r
.43837 .6563 .45287 .66963 .47807 .66244 .46372 .64899 Metetra
.645 .763 .934 r
.46372 .64899 .47807 .66244 .50351 .65518 .48931 .64161 Metetra
.645 .763 .934 r
.48931 .64161 .50351 .65518 .52918 .64786 .51514 .63416 Metetra
.645 .763 .934 r
.51514 .63416 .52918 .64786 .55485 .6122 .54121 .62664 Metetra
.903 .947 .593 r
.54121 .62664 .55485 .6122 .57988 .54848 .56701 .57668 Metetra
.727 .806 .333 r
.56701 .57668 .57988 .54848 .60428 .48429 .59218 .51553 Metetra
.59218 .51553 .60428 .48429 .62814 .4231 .61677 .45457 Metetra
.61677 .45457 .62814 .4231 .65222 .383 .64087 .39662 Metetra
.72 .892 .507 r
.64087 .39662 .65222 .383 .67755 .37474 .66531 .3593 Metetra
.664 .741 .907 r
.66531 .3593 .67755 .37474 .70311 .36641 .69103 .35082 Metetra
.664 .741 .907 r
.69103 .35082 .70311 .36641 .72891 .358 .71698 .34227 Metetra
.664 .741 .907 r
.71698 .34227 .72891 .358 .75493 .34951 .74318 .33364 Metetra
.664 .741 .907 r
.74318 .33364 .75493 .34951 .7812 .34095 .76961 .32493 Metetra
.664 .741 .907 r
.76961 .32493 .7812 .34095 .8077 .33231 .79629 .31614 Metetra
.664 .741 .907 r
.79629 .31614 .8077 .33231 .83446 .32358 .82322 .30727 Metetra
.664 .741 .907 r
.82322 .30727 .83446 .32358 .86146 .31478 .85041 .29831 Metetra
.664 .741 .907 r
.85041 .29831 .86146 .31478 .89433 .35422 .87784 .28927 Metetra
.876 .437 .087 r
.26048 .57861 .27563 .59183 .29521 .63675 .28017 .62017 Metetra
.844 .396 0 r
.28017 .62017 .29521 .63675 .31576 .6805 .30077 .66089 Metetra
.195 .455 .878 r
.30077 .66089 .31576 .6805 .33928 .68488 .32395 .67182 Metetra
.645 .763 .934 r
.32395 .67182 .33928 .68488 .36371 .67784 .34852 .66466 Metetra
.645 .763 .934 r
.34852 .66466 .36371 .67784 .38837 .67073 .37332 .65742 Metetra
.645 .763 .934 r
.37332 .65742 .38837 .67073 .41325 .66355 .39835 .65012 Metetra
.645 .763 .934 r
.39835 .65012 .41325 .66355 .43837 .6563 .42361 .64275 Metetra
.645 .763 .934 r
.42361 .64275 .43837 .6563 .46372 .64899 .44911 .63531 Metetra
.645 .763 .934 r
.44911 .63531 .46372 .64899 .48931 .64161 .47485 .6278 Metetra
.645 .763 .934 r
.47485 .6278 .48931 .64161 .51514 .63416 .50084 .62022 Metetra
.645 .763 .934 r
.50084 .62022 .51514 .63416 .54121 .62664 .52708 .61256 Metetra
.669 .77 .926 r
.52708 .61256 .54121 .62664 .56701 .57668 .55356 .60335 Metetra
.703 .811 .351 r
.55356 .60335 .56701 .57668 .59218 .51553 .57952 .5473 Metetra
.57952 .5473 .59218 .51553 .61677 .45457 .60491 .48905 Metetra
.60491 .48905 .61677 .45457 .64087 .39662 .62976 .43113 Metetra
.62976 .43113 .64087 .39662 .66531 .3593 .65417 .37586 Metetra
.671 .84 .423 r
.65417 .37586 .66531 .3593 .69103 .35082 .67874 .33497 Metetra
.664 .741 .907 r
.67874 .33497 .69103 .35082 .71698 .34227 .70486 .32628 Metetra
.664 .741 .907 r
.70486 .32628 .71698 .34227 .74318 .33364 .73122 .3175 Metetra
.664 .741 .907 r
.73122 .3175 .74318 .33364 .76961 .32493 .75783 .30864 Metetra
.664 .741 .907 r
.75783 .30864 .76961 .32493 .79629 .31614 .78468 .29969 Metetra
.664 .741 .907 r
.78468 .29969 .79629 .31614 .82322 .30727 .81179 .29067 Metetra
.664 .741 .907 r
.81179 .29067 .82322 .30727 .85041 .29831 .83916 .28155 Metetra
.664 .741 .907 r
.83916 .28155 .85041 .29831 .87784 .28927 .86679 .27235 Metetra
.856 .403 .036 r
.24509 .56517 .26048 .57861 .28017 .62017 .26491 .60332 Metetra
.815 .356 0 r
.26491 .60332 .28017 .62017 .30077 .66089 .2856 .64092 Metetra
0 .259 .767 r
.2856 .64092 .30077 .66089 .32395 .67182 .30836 .65854 Metetra
.645 .763 .934 r
.30836 .65854 .32395 .67182 .34852 .66466 .33307 .65125 Metetra
.645 .763 .934 r
.33307 .65125 .34852 .66466 .37332 .65742 .35801 .64389 Metetra
.645 .763 .934 r
.35801 .64389 .37332 .65742 .39835 .65012 .38318 .63646 Metetra
.645 .763 .934 r
.38318 .63646 .39835 .65012 .42361 .64275 .40859 .62896 Metetra
.645 .763 .934 r
.40859 .62896 .42361 .64275 .44911 .63531 .43425 .62139 Metetra
.645 .763 .934 r
.43425 .62139 .44911 .63531 .47485 .6278 .46015 .61375 Metetra
.645 .763 .934 r
.46015 .61375 .47485 .6278 .50084 .62022 .4863 .60603 Metetra
.645 .763 .934 r
.4863 .60603 .50084 .62022 .52708 .61256 .5127 .59824 Metetra
.645 .763 .934 r
.5127 .59824 .52708 .61256 .55356 .60335 .53936 .59037 Metetra
.717 .805 .919 r
.53936 .59037 .55356 .60335 .57952 .5473 .56622 .57759 Metetra
.56622 .57759 .57952 .5473 .60491 .48905 .59245 .52432 Metetra
.59245 .52432 .60491 .48905 .62976 .43113 .61816 .46913 Metetra
.61816 .46913 .62976 .43113 .65417 .37586 .64336 .41408 Metetra
0 0 .001 r
.64336 .41408 .65417 .37586 .67874 .33497 .66814 .36105 Metetra
.66814 .36105 .67874 .33497 .70486 .32628 .69262 .31168 Metetra
.689 .774 .916 r
.69262 .31168 .70486 .32628 .73122 .3175 .71906 .30107 Metetra
.664 .741 .907 r
.71906 .30107 .73122 .3175 .75783 .30864 .74584 .29206 Metetra
.664 .741 .907 r
.74584 .29206 .75783 .30864 .78468 .29969 .77287 .28296 Metetra
.664 .741 .907 r
.77287 .28296 .78468 .29969 .81179 .29067 .80016 .27377 Metetra
.664 .741 .907 r
.80016 .27377 .81179 .29067 .83916 .28155 .82772 .2645 Metetra
.664 .741 .907 r
.82772 .2645 .83916 .28155 .86679 .27235 .85553 .25514 Metetra
.829 .359 0 r
.22944 .55152 .24509 .56517 .26491 .60332 .24943 .58622 Metetra
.775 .305 0 r
.24943 .58622 .26491 .60332 .2856 .64092 .27023 .6206 Metetra
0 .027 .572 r
.27023 .6206 .2856 .64092 .30836 .65854 .2925 .64503 Metetra
.645 .763 .934 r
.2925 .64503 .30836 .65854 .33307 .65125 .31735 .63761 Metetra
.645 .763 .934 r
.31735 .63761 .33307 .65125 .35801 .64389 .34243 .63012 Metetra
.645 .763 .934 r
.34243 .63012 .35801 .64389 .38318 .63646 .36775 .62256 Metetra
.645 .763 .934 r
.36775 .62256 .38318 .63646 .40859 .62896 .39331 .61493 Metetra
.645 .763 .934 r
.39331 .61493 .40859 .62896 .43425 .62139 .41912 .60722 Metetra
.645 .763 .934 r
.41912 .60722 .43425 .62139 .46015 .61375 .44518 .59944 Metetra
.645 .763 .934 r
.44518 .59944 .46015 .61375 .4863 .60603 .47149 .59159 Metetra
.645 .763 .934 r
.47149 .59159 .4863 .60603 .5127 .59824 .49806 .58365 Metetra
.645 .763 .934 r
.49806 .58365 .5127 .59824 .53936 .59037 .52489 .57564 Metetra
.645 .763 .934 r
.52489 .57564 .53936 .59037 .56622 .57759 .55198 .56755 Metetra
.657 .842 .971 r
.55198 .56755 .56622 .57759 .59245 .52432 .57932 .55788 Metetra
.57932 .55788 .59245 .52432 .61816 .46913 .60592 .50786 Metetra
.60592 .50786 .61816 .46913 .64336 .41408 .63204 .45592 Metetra
0 0 .043 r
.63204 .45592 .64336 .41408 .66814 .36105 .65769 .40367 Metetra
0 0 .082 r
.65769 .40367 .66814 .36105 .69262 .31168 .68293 .35268 Metetra
0 0 .094 r
.68293 .35268 .69262 .31168 .71906 .30107 .70785 .3043 Metetra
.825 .995 .758 r
.70785 .3043 .71906 .30107 .74584 .29206 .73364 .27519 Metetra
.664 .741 .907 r
.73364 .27519 .74584 .29206 .77287 .28296 .76085 .26593 Metetra
.664 .741 .907 r
.76085 .26593 .77287 .28296 .80016 .27377 .78833 .25658 Metetra
.664 .741 .907 r
.78833 .25658 .80016 .27377 .82772 .2645 .81607 .24714 Metetra
.664 .741 .907 r
.81607 .24714 .82772 .2645 .85553 .25514 .84407 .23761 Metetra
.79 .304 0 r
.21353 .53763 .22944 .55152 .24943 .58622 .23372 .56886 Metetra
.721 .241 0 r
.23372 .56886 .24943 .58622 .27023 .6206 .25467 .59992 Metetra
.584 .132 0 r
.25467 .59992 .27023 .6206 .2925 .64503 .27648 .62961 Metetra
.618 .731 .927 r
.27648 .62961 .2925 .64503 .31735 .63761 .30135 .62373 Metetra
.645 .763 .934 r
.30135 .62373 .31735 .63761 .34243 .63012 .32657 .61611 Metetra
.645 .763 .934 r
.32657 .61611 .34243 .63012 .36775 .62256 .35204 .60841 Metetra
.645 .763 .934 r
.35204 .60841 .36775 .62256 .39331 .61493 .37776 .60064 Metetra
.645 .763 .934 r
.37776 .60064 .39331 .61493 .41912 .60722 .40372 .5928 Metetra
.645 .763 .934 r
.40372 .5928 .41912 .60722 .44518 .59944 .42994 .58488 Metetra
.645 .763 .934 r
.42994 .58488 .44518 .59944 .47149 .59159 .45642 .57688 Metetra
.645 .763 .934 r
.45642 .57688 .47149 .59159 .49806 .58365 .48315 .5688 Metetra
.645 .763 .934 r
.48315 .5688 .49806 .58365 .52489 .57564 .51015 .56065 Metetra
.645 .763 .934 r
.51015 .56065 .52489 .57564 .55198 .56755 .53742 .55241 Metetra
.645 .763 .934 r
.53742 .55241 .55198 .56755 .57932 .55788 .56496 .54409 Metetra
.642 .784 .949 r
.56496 .54409 .57932 .55788 .60592 .50786 .59278 .53568 Metetra
.59278 .53568 .60592 .50786 .63204 .45592 .62004 .49791 Metetra
0 0 .052 r
.62004 .49791 .63204 .45592 .65769 .40367 .64668 .44949 Metetra
0 0 .112 r
.64668 .44949 .65769 .40367 .68293 .35268 .67289 .40024 Metetra
0 0 .149 r
.67289 .40024 .68293 .35268 .70785 .3043 .69869 .35139 Metetra
.009 0 .166 r
.69869 .35139 .70785 .3043 .73364 .27519 .72416 .30409 Metetra
.72416 .30409 .73364 .27519 .76085 .26593 .7494 .25935 Metetra
.808 .943 .914 r
.7494 .25935 .76085 .26593 .78833 .25658 .77628 .23909 Metetra
.664 .741 .907 r
.77628 .23909 .78833 .25658 .81607 .24714 .80421 .22948 Metetra
.664 .741 .907 r
.80421 .22948 .81607 .24714 .84407 .23761 .83241 .21978 Metetra
.736 .233 0 r
.19735 .52351 .21353 .53763 .23372 .56886 .21778 .55122 Metetra
.645 .159 0 r
.21778 .55122 .23372 .56886 .25467 .59992 .23891 .5789 Metetra
0 0 .496 r
.23891 .5789 .25467 .59992 .27648 .62961 .26083 .60562 Metetra
.444 .556 .875 r
.26083 .60562 .27648 .62961 .30135 .62373 .28506 .6096 Metetra
.645 .763 .934 r
.28506 .6096 .30135 .62373 .32657 .61611 .31044 .60184 Metetra
.645 .763 .934 r
.31044 .60184 .32657 .61611 .35204 .60841 .33606 .59401 Metetra
.645 .763 .934 r
.33606 .59401 .35204 .60841 .37776 .60064 .36192 .5861 Metetra
.645 .763 .934 r
.36192 .5861 .37776 .60064 .40372 .5928 .38805 .57812 Metetra
.645 .763 .934 r
.38805 .57812 .40372 .5928 .42994 .58488 .41443 .57005 Metetra
.645 .763 .934 r
.41443 .57005 .42994 .58488 .45642 .57688 .44106 .56191 Metetra
.645 .763 .934 r
.44106 .56191 .45642 .57688 .48315 .5688 .46797 .55368 Metetra
.645 .763 .934 r
.46797 .55368 .48315 .5688 .51015 .56065 .49514 .54537 Metetra
.645 .763 .934 r
.49514 .54537 .51015 .56065 .53742 .55241 .52259 .53698 Metetra
.645 .763 .934 r
.52259 .53698 .53742 .55241 .56496 .54409 .55031 .52851 Metetra
.645 .763 .934 r
.55031 .52851 .56496 .54409 .59278 .53568 .57831 .51995 Metetra
.645 .763 .934 r
.57831 .51995 .59278 .53568 .62004 .49791 .6066 .5113 Metetra
.6066 .5113 .62004 .49791 .64668 .44949 .6349 .49416 Metetra
0 0 .108 r
.6349 .49416 .64668 .44949 .67289 .40024 .66221 .44975 Metetra
.033 0 .164 r
.66221 .44975 .67289 .40024 .69869 .35139 .68911 .40395 Metetra
.075 0 .2 r
.68911 .40395 .69869 .35139 .72416 .30409 .71562 .35773 Metetra
.102 0 .221 r
.71562 .35773 .72416 .30409 .7494 .25935 .74178 .31201 Metetra
.118 0 .229 r
.74178 .31201 .7494 .25935 .77628 .23909 .76766 .26765 Metetra
.76766 .26765 .77628 .23909 .80421 .22948 .79337 .22541 Metetra
.828 .982 .88 r
.79337 .22541 .80421 .22948 .83241 .21978 .82054 .20161 Metetra
.657 .14 0 r
.1809 .50916 .19735 .52351 .21778 .55122 .20159 .53331 Metetra
.543 .059 0 r
.20159 .53331 .21778 .55122 .23891 .5789 .22294 .55752 Metetra
0 .046 .592 r
.22294 .55752 .23891 .5789 .26083 .60562 .24502 .58111 Metetra
.134 .376 .832 r
.24502 .58111 .26083 .60562 .28506 .6096 .26849 .59522 Metetra
.645 .763 .934 r
.26849 .59522 .28506 .6096 .31044 .60184 .29401 .58732 Metetra
.645 .763 .934 r
.29401 .58732 .31044 .60184 .33606 .59401 .31978 .57935 Metetra
.645 .763 .934 r
.31978 .57935 .33606 .59401 .36192 .5861 .3458 .5713 Metetra
.645 .763 .934 r
.3458 .5713 .36192 .5861 .38805 .57812 .37208 .56316 Metetra
.645 .763 .934 r
.37208 .56316 .38805 .57812 .41443 .57005 .39863 .55495 Metetra
.645 .763 .934 r
.39863 .55495 .41443 .57005 .44106 .56191 .42543 .54666 Metetra
.645 .763 .934 r
.42543 .54666 .44106 .56191 .46797 .55368 .45251 .53828 Metetra
.645 .763 .934 r
.45251 .53828 .46797 .55368 .49514 .54537 .47985 .52982 Metetra
.645 .763 .934 r
.47985 .52982 .49514 .54537 .52259 .53698 .50748 .52127 Metetra
.645 .763 .934 r
.50748 .52127 .52259 .53698 .55031 .52851 .53538 .51263 Metetra
.645 .763 .934 r
.53538 .51263 .55031 .52851 .57831 .51995 .56358 .50391 Metetra
.645 .763 .934 r
.56358 .50391 .57831 .51995 .6066 .5113 .59206 .4951 Metetra
.645 .763 .934 r
.59206 .4951 .6066 .5113 .6349 .49416 .62083 .48619 Metetra
.594 .872 .993 r
.62083 .48619 .6349 .49416 .66221 .44975 .64991 .4772 Metetra
.105 0 .007 r
.64991 .4772 .66221 .44975 .68911 .40395 .67873 .45613 Metetra
.112 0 .198 r
.67873 .45613 .68911 .40395 .71562 .35773 .70648 .41454 Metetra
.15 0 .235 r
.70648 .41454 .71562 .35773 .74178 .31201 .73388 .37178 Metetra
.176 0 .259 r
.73388 .37178 .74178 .31201 .76766 .26765 .76093 .32859 Metetra
.194 0 .274 r
.76093 .32859 .76766 .26765 .79337 .22541 .78767 .28564 Metetra
.205 0 .28 r
.78767 .28564 .79337 .22541 .82054 .20161 .81415 .24358 Metetra
.546 .023 0 r
.16417 .49455 .1809 .50916 .20159 .53331 .18516 .51512 Metetra
0 .061 .581 r
.18516 .51512 .20159 .53331 .22294 .55752 .20677 .53579 Metetra
0 .152 .686 r
.20677 .53579 .22294 .55752 .24502 .58111 .22904 .55609 Metetra
0 .233 .751 r
.22904 .55609 .24502 .58111 .26849 .59522 .25202 .57554 Metetra
.562 .669 .91 r
.25202 .57554 .26849 .59522 .29401 .58732 .27729 .57254 Metetra
.645 .763 .934 r
.27729 .57254 .29401 .58732 .31978 .57935 .30321 .56442 Metetra
.645 .763 .934 r
.30321 .56442 .31978 .57935 .3458 .5713 .32939 .55622 Metetra
.645 .763 .934 r
.32939 .55622 .3458 .5713 .37208 .56316 .35583 .54794 Metetra
.645 .763 .934 r
.35583 .54794 .37208 .56316 .39863 .55495 .38253 .53957 Metetra
.645 .763 .934 r
.38253 .53957 .39863 .55495 .42543 .54666 .40951 .53112 Metetra
.645 .763 .934 r
.40951 .53112 .42543 .54666 .45251 .53828 .43676 .52259 Metetra
.645 .763 .934 r
.43676 .52259 .45251 .53828 .47985 .52982 .46428 .51397 Metetra
.645 .763 .934 r
.46428 .51397 .47985 .52982 .50748 .52127 .49209 .50526 Metetra
.645 .763 .934 r
.49209 .50526 .50748 .52127 .53538 .51263 .52018 .49646 Metetra
.645 .763 .934 r
.52018 .49646 .53538 .51263 .56358 .50391 .54856 .48757 Metetra
.645 .763 .934 r
.54856 .48757 .56358 .50391 .59206 .4951 .57724 .47859 Metetra
.645 .763 .934 r
.57724 .47859 .59206 .4951 .62083 .48619 .60621 .46951 Metetra
.645 .763 .934 r
.60621 .46951 .62083 .48619 .64991 .4772 .63549 .46034 Metetra
.645 .763 .934 r
.63549 .46034 .64991 .4772 .67873 .45613 .66508 .45107 Metetra
.535 .892 .977 r
.66508 .45107 .67873 .45613 .70648 .41454 .69498 .4417 Metetra
.282 0 .069 r
.69498 .4417 .70648 .41454 .73388 .37178 .72511 .43068 Metetra
.206 0 .252 r
.72511 .43068 .73388 .37178 .76093 .32859 .75361 .39256 Metetra
.232 0 .28 r
.75361 .39256 .76093 .32859 .78767 .28564 .78179 .35322 Metetra
.251 0 .3 r
.78179 .35322 .78767 .28564 .81415 .24358 .80965 .31319 Metetra
0 .118 .597 r
.14715 .4797 .16417 .49455 .18516 .51512 .16849 .49665 Metetra
0 .194 .704 r
.16849 .49665 .18516 .51512 .20677 .53579 .19038 .51371 Metetra
0 .261 .77 r
.19038 .51371 .20677 .53579 .22904 .55609 .21289 .53059 Metetra
.043 .312 .799 r
.21289 .53059 .22904 .55609 .25202 .57554 .23604 .54694 Metetra
.299 .441 .837 r
.23604 .54694 .25202 .57554 .27729 .57254 .26026 .55749 Metetra
.645 .763 .934 r
.26026 .55749 .27729 .57254 .30321 .56442 .28633 .54922 Metetra
.645 .763 .934 r
.28633 .54922 .30321 .56442 .32939 .55622 .31267 .54087 Metetra
.645 .763 .934 r
.31267 .54087 .32939 .55622 .35583 .54794 .33927 .53243 Metetra
.645 .763 .934 r
.33927 .53243 .35583 .54794 .38253 .53957 .36614 .52391 Metetra
.645 .763 .934 r
.36614 .52391 .38253 .53957 .40951 .53112 .39329 .5153 Metetra
.645 .763 .934 r
.39329 .5153 .40951 .53112 .43676 .52259 .42071 .5066 Metetra
.645 .763 .934 r
.42071 .5066 .43676 .52259 .46428 .51397 .44841 .49782 Metetra
.645 .763 .934 r
.44841 .49782 .46428 .51397 .49209 .50526 .4764 .48894 Metetra
.645 .763 .934 r
.4764 .48894 .49209 .50526 .52018 .49646 .50468 .47997 Metetra
.645 .763 .934 r
.50468 .47997 .52018 .49646 .54856 .48757 .53325 .47091 Metetra
.645 .763 .934 r
.53325 .47091 .54856 .48757 .57724 .47859 .56213 .46176 Metetra
.645 .763 .934 r
.56213 .46176 .57724 .47859 .60621 .46951 .5913 .4525 Metetra
.645 .763 .934 r
.5913 .4525 .60621 .46951 .63549 .46034 .62079 .44315 Metetra
.645 .763 .934 r
.62079 .44315 .63549 .46034 .66508 .45107 .65059 .4337 Metetra
.645 .763 .934 r
.65059 .4337 .66508 .45107 .69498 .4417 .68071 .42415 Metetra
.645 .763 .934 r
.68071 .42415 .69498 .4417 .72511 .43068 .71116 .41449 Metetra
.643 .783 .949 r
.71116 .41449 .72511 .43068 .75361 .39256 .74193 .40473 Metetra
.064 0 0 r
.74193 .40473 .75361 .39256 .78179 .35322 .77304 .39487 Metetra
.365 .004 .212 r
.77304 .39487 .78179 .35322 .80965 .31319 .80435 .38332 Metetra
0 .273 .741 r
.12983 .46458 .14715 .4797 .16849 .49665 .15155 .47788 Metetra
0 .328 .808 r
.15155 .47788 .16849 .49665 .19038 .51371 .17378 .49129 Metetra
.062 .364 .834 r
.17378 .49129 .19038 .51371 .21289 .53059 .19657 .50462 Metetra
.163 .387 .834 r
.19657 .50462 .21289 .53059 .23604 .54694 .21994 .51766 Metetra
.24 .402 .824 r
.21994 .51766 .23604 .54694 .26026 .55749 .24391 .53021 Metetra
.45 .544 .861 r
.24391 .53021 .26026 .55749 .28633 .54922 .26914 .53373 Metetra
.645 .763 .934 r
.26914 .53373 .28633 .54922 .31267 .54087 .29564 .52523 Metetra
.645 .763 .934 r
.29564 .52523 .31267 .54087 .33927 .53243 .3224 .51663 Metetra
.645 .763 .934 r
.3224 .51663 .33927 .53243 .36614 .52391 .34944 .50795 Metetra
.645 .763 .934 r
.34944 .50795 .36614 .52391 .39329 .5153 .37676 .49918 Metetra
.645 .763 .934 r
.37676 .49918 .39329 .5153 .42071 .5066 .40435 .49031 Metetra
.645 .763 .934 r
.40435 .49031 .42071 .5066 .44841 .49782 .43224 .48136 Metetra
.645 .763 .934 r
.43224 .48136 .44841 .49782 .4764 .48894 .46041 .47231 Metetra
.645 .763 .934 r
.46041 .47231 .4764 .48894 .50468 .47997 .48888 .46317 Metetra
.645 .763 .934 r
.48888 .46317 .50468 .47997 .53325 .47091 .51765 .45393 Metetra
.645 .763 .934 r
.51765 .45393 .53325 .47091 .56213 .46176 .54672 .4446 Metetra
.645 .763 .934 r
.54672 .4446 .56213 .46176 .5913 .4525 .5761 .43516 Metetra
.645 .763 .934 r
.5761 .43516 .5913 .4525 .62079 .44315 .6058 .42562 Metetra
.645 .763 .934 r
.6058 .42562 .62079 .44315 .65059 .4337 .63582 .41599 Metetra
.645 .763 .934 r
.63582 .41599 .65059 .4337 .68071 .42415 .66616 .40624 Metetra
.645 .763 .934 r
.66616 .40624 .68071 .42415 .71116 .41449 .69683 .39639 Metetra
.645 .763 .934 r
.69683 .39639 .71116 .41449 .74193 .40473 .72784 .38644 Metetra
.645 .763 .934 r
.72784 .38644 .74193 .40473 .77304 .39487 .75918 .37637 Metetra
.645 .763 .934 r
.75918 .37637 .77304 .39487 .80435 .38332 .79088 .36619 Metetra
0 .424 .858 r
.11221 .44921 .12983 .46458 .15155 .47788 .13435 .45882 Metetra
.114 .446 .881 r
.13435 .45882 .15155 .47788 .17378 .49129 .15696 .46852 Metetra
.207 .454 .875 r
.15696 .46852 .17378 .49129 .19657 .50462 .18008 .4782 Metetra
.276 .453 .855 r
.18008 .4782 .19657 .50462 .21994 .51766 .20371 .48774 Metetra
.327 .451 .834 r
.20371 .48774 .21994 .51766 .24391 .53021 .22788 .49703 Metetra
.365 .449 .814 r
.22788 .49703 .24391 .53021 .26914 .53373 .25261 .50593 Metetra
.45 .544 .861 r
.25261 .50593 .26914 .53373 .29564 .52523 .27829 .50929 Metetra
.645 .763 .934 r
.27829 .50929 .29564 .52523 .3224 .51663 .30521 .50053 Metetra
.645 .763 .934 r
.30521 .50053 .3224 .51663 .34944 .50795 .33242 .49168 Metetra
.645 .763 .934 r
.33242 .49168 .34944 .50795 .37676 .49918 .35991 .48274 Metetra
.645 .763 .934 r
.35991 .48274 .37676 .49918 .40435 .49031 .38768 .47371 Metetra
.645 .763 .934 r
.38768 .47371 .40435 .49031 .43224 .48136 .41575 .46458 Metetra
.645 .763 .934 r
.41575 .46458 .43224 .48136 .46041 .47231 .44411 .45536 Metetra
.645 .763 .934 r
.44411 .45536 .46041 .47231 .48888 .46317 .47277 .44604 Metetra
.645 .763 .934 r
.47277 .44604 .48888 .46317 .51765 .45393 .50174 .43662 Metetra
.645 .763 .934 r
.50174 .43662 .51765 .45393 .54672 .4446 .53101 .4271 Metetra
.645 .763 .934 r
.53101 .4271 .54672 .4446 .5761 .43516 .5606 .41748 Metetra
.645 .763 .934 r
.5606 .41748 .5761 .43516 .6058 .42562 .59051 .40775 Metetra
.645 .763 .934 r
.59051 .40775 .6058 .42562 .63582 .41599 .62075 .39792 Metetra
.645 .763 .934 r
.62075 .39792 .63582 .41599 .66616 .40624 .65131 .38798 Metetra
.645 .763 .934 r
.65131 .38798 .66616 .40624 .69683 .39639 .68221 .37793 Metetra
.645 .763 .934 r
.68221 .37793 .69683 .39639 .72784 .38644 .71345 .36777 Metetra
.645 .763 .934 r
.71345 .36777 .72784 .38644 .75918 .37637 .74504 .35749 Metetra
.645 .763 .934 r
.74504 .35749 .75918 .37637 .79088 .36619 .77698 .3471 Metetra
.193 .548 .93 r
.09428 .43355 .11221 .44921 .13435 .45882 .11688 .43945 Metetra
.275 .541 .92 r
.11688 .43945 .13435 .45882 .15696 .46852 .13992 .44541 Metetra
.334 .525 .894 r
.13992 .44541 .15696 .46852 .18008 .4782 .1634 .45136 Metetra
.376 .509 .864 r
.1634 .45136 .18008 .4782 .20371 .48774 .18735 .45725 Metetra
.406 .494 .836 r
.18735 .45725 .20371 .48774 .22788 .49703 .21178 .46301 Metetra
.429 .481 .812 r
.21178 .46301 .22788 .49703 .25261 .50593 .2367 .46859 Metetra
.446 .471 .792 r
.2367 .46859 .25261 .50593 .27829 .50929 .26213 .47392 Metetra
.445 .486 .807 r
.26213 .47392 .27829 .50929 .30521 .50053 .28807 .47893 Metetra
.562 .669 .91 r
.28807 .47893 .30521 .50053 .33242 .49168 .31508 .47511 Metetra
.645 .763 .934 r
.31508 .47511 .33242 .49168 .35991 .48274 .34274 .46599 Metetra
.645 .763 .934 r
.34274 .46599 .35991 .48274 .38768 .47371 .37069 .45679 Metetra
.645 .763 .934 r
.37069 .45679 .38768 .47371 .41575 .46458 .39894 .44748 Metetra
.645 .763 .934 r
.39894 .44748 .41575 .46458 .44411 .45536 .42749 .43808 Metetra
.645 .763 .934 r
.42749 .43808 .44411 .45536 .47277 .44604 .45635 .42857 Metetra
.645 .763 .934 r
.45635 .42857 .47277 .44604 .50174 .43662 .48551 .41896 Metetra
.645 .763 .934 r
.48551 .41896 .50174 .43662 .53101 .4271 .51499 .40925 Metetra
.645 .763 .934 r
.51499 .40925 .53101 .4271 .5606 .41748 .54479 .39944 Metetra
.645 .763 .934 r
.54479 .39944 .5606 .41748 .59051 .40775 .57491 .38951 Metetra
.645 .763 .934 r
.57491 .38951 .59051 .40775 .62075 .39792 .60537 .37948 Metetra
.645 .763 .934 r
.60537 .37948 .62075 .39792 .65131 .38798 .63616 .36934 Metetra
.645 .763 .934 r
.63616 .36934 .65131 .38798 .68221 .37793 .66729 .35908 Metetra
.645 .763 .934 r
.66729 .35908 .68221 .37793 .71345 .36777 .69877 .34871 Metetra
.645 .763 .934 r
.69877 .34871 .71345 .36777 .74504 .35749 .73061 .33822 Metetra
.645 .763 .934 r
.73061 .33822 .74504 .35749 .77698 .3471 .7628 .32762 Metetra
.359 .638 .96 r
.07603 .41762 .09428 .43355 .11688 .43945 .09914 .41978 Metetra
.408 .61 .931 r
.09914 .41978 .11688 .43945 .13992 .44541 .12265 .42195 Metetra
.44 .58 .897 r
.12265 .42195 .13992 .44541 .1634 .45136 .14655 .42411 Metetra
.462 .553 .863 r
.14655 .42411 .1634 .45136 .18735 .45725 .17086 .42622 Metetra
.477 .53 .833 r
.17086 .42622 .18735 .45725 .21178 .46301 .1956 .42828 Metetra
.488 .511 .808 r
.1956 .42828 .21178 .46301 .2367 .46859 .22077 .43024 Metetra
.496 .495 .786 r
.22077 .43024 .2367 .46859 .26213 .47392 .24638 .43209 Metetra
.502 .482 .768 r
.24638 .43209 .26213 .47392 .28807 .47893 .27245 .4338 Metetra
.507 .472 .753 r
.27245 .4338 .28807 .47893 .31508 .47511 .29898 .43533 Metetra
.504 .498 .783 r
.29898 .43533 .31508 .47511 .34274 .46599 .32598 .43666 Metetra
.487 .562 .858 r
.32598 .43666 .34274 .46599 .37069 .45679 .35346 .43776 Metetra
.618 .731 .927 r
.35346 .43776 .37069 .45679 .39894 .44748 .3818 .43004 Metetra
.645 .763 .934 r
.3818 .43004 .39894 .44748 .42749 .43808 .41054 .42045 Metetra
.645 .763 .934 r
.41054 .42045 .42749 .43808 .45635 .42857 .43959 .41075 Metetra
.645 .763 .934 r
.43959 .41075 .45635 .42857 .48551 .41896 .46896 .40095 Metetra
.645 .763 .934 r
.46896 .40095 .48551 .41896 .51499 .40925 .49864 .39105 Metetra
.645 .763 .934 r
.49864 .39105 .51499 .40925 .54479 .39944 .52866 .38103 Metetra
.645 .763 .934 r
.52866 .38103 .54479 .39944 .57491 .38951 .559 .3709 Metetra
.645 .763 .934 r
.559 .3709 .57491 .38951 .60537 .37948 .58968 .36067 Metetra
.645 .763 .934 r
.58968 .36067 .60537 .37948 .63616 .36934 .6207 .35031 Metetra
.645 .763 .934 r
.6207 .35031 .63616 .36934 .66729 .35908 .65207 .33985 Metetra
.645 .763 .934 r
.65207 .33985 .66729 .35908 .69877 .34871 .68379 .32926 Metetra
.645 .763 .934 r
.68379 .32926 .69877 .34871 .73061 .33822 .71587 .31855 Metetra
.645 .763 .934 r
.71587 .31855 .73061 .33822 .7628 .32762 .74832 .30772 Metetra
.489 .696 .961 r
.05745 .40141 .07603 .41762 .09914 .41978 .08112 .39979 Metetra
.512 .657 .925 r
.08112 .39979 .09914 .41978 .12265 .42195 .10514 .39815 Metetra
.525 .62 .889 r
.10514 .39815 .12265 .42195 .14655 .42411 .12951 .39646 Metetra
.533 .588 .856 r
.12951 .39646 .14655 .42411 .17086 .42622 .15424 .39473 Metetra
.538 .561 .826 r
.15424 .39473 .17086 .42622 .1956 .42828 .17933 .39295 Metetra
.54 .538 .801 r
.17933 .39295 .1956 .42828 .22077 .43024 .20481 .3911 Metetra
.541 .518 .779 r
.20481 .3911 .22077 .43024 .24638 .43209 .23067 .38918 Metetra
.542 .501 .76 r
.23067 .38918 .24638 .43209 .27245 .4338 .25692 .38718 Metetra
.542 .487 .744 r
.25692 .38718 .27245 .4338 .29898 .43533 .28357 .38509 Metetra
.542 .475 .73 r
.28357 .38509 .29898 .43533 .32598 .43666 .31063 .3829 Metetra
.542 .465 .718 r
.31063 .3829 .32598 .43666 .35346 .43776 .33811 .3806 Metetra
.542 .456 .708 r
.33811 .3806 .35346 .43776 .3818 .43004 .36601 .37818 Metetra
.545 .475 .728 r
.36601 .37818 .3818 .43004 .41054 .42045 .39435 .37563 Metetra
.547 .505 .76 r
.39435 .37563 .41054 .42045 .43959 .41075 .42313 .37295 Metetra
.548 .543 .8 r
.42313 .37295 .43959 .41075 .46896 .40095 .45236 .37012 Metetra
.547 .592 .85 r
.45236 .37012 .46896 .40095 .49864 .39105 .48204 .36713 Metetra
.566 .668 .907 r
.48204 .36713 .49864 .39105 .52866 .38103 .51219 .36225 Metetra
.645 .763 .934 r
.51219 .36225 .52866 .38103 .559 .3709 .54276 .35191 Metetra
.645 .763 .934 r
.54276 .35191 .559 .3709 .58968 .36067 .57366 .34146 Metetra
.645 .763 .934 r
.57366 .34146 .58968 .36067 .6207 .35031 .60491 .33089 Metetra
.645 .763 .934 r
.60491 .33089 .6207 .35031 .65207 .33985 .63652 .32021 Metetra
.645 .763 .934 r
.63652 .32021 .65207 .33985 .68379 .32926 .66849 .3094 Metetra
.645 .763 .934 r
.66849 .3094 .68379 .32926 .71587 .31855 .70082 .29846 Metetra
.645 .763 .934 r
.70082 .29846 .71587 .31855 .74832 .30772 .73353 .2874 Metetra
.585 .731 .944 r
.03853 .3849 .05745 .40141 .08112 .39979 .06281 .37948 Metetra
.592 .688 .909 r
.06281 .37948 .08112 .39979 .10514 .39815 .08739 .374 Metetra
.593 .649 .875 r
.08739 .374 .10514 .39815 .12951 .39646 .11227 .36845 Metetra
.592 .615 .844 r
.11227 .36845 .12951 .39646 .15424 .39473 .13747 .36283 Metetra
.589 .586 .816 r
.13747 .36283 .15424 .39473 .17933 .39295 .16298 .35713 Metetra
.586 .561 .792 r
.16298 .35713 .17933 .39295 .20481 .3911 .18881 .35136 Metetra
.583 .539 .771 r
.18881 .35136 .20481 .3911 .23067 .38918 .21496 .34551 Metetra
.579 .52 .753 r
.21496 .34551 .23067 .38918 .25692 .38718 .24145 .33958 Metetra
.576 .504 .737 r
.24145 .33958 .25692 .38718 .28357 .38509 .26828 .33356 Metetra
.573 .489 .722 r
.26828 .33356 .28357 .38509 .31063 .3829 .29546 .32746 Metetra
.57 .477 .71 r
.29546 .32746 .31063 .3829 .33811 .3806 .32299 .32128 Metetra
.567 .466 .698 r
.32299 .32128 .33811 .3806 .36601 .37818 .35088 .315 Metetra
.565 .456 .688 r
.35088 .315 .36601 .37818 .39435 .37563 .37913 .30862 Metetra
.563 .447 .679 r
.37913 .30862 .39435 .37563 .42313 .37295 .40776 .30215 Metetra
.561 .439 .671 r
.40776 .30215 .42313 .37295 .45236 .37012 .43677 .29558 Metetra
.559 .432 .664 r
.43677 .29558 .45236 .37012 .48204 .36713 .46617 .28891 Metetra
.557 .426 .658 r
.46617 .28891 .48204 .36713 .51219 .36225 .49596 .28214 Metetra
.556 .423 .655 r
.49596 .28214 .51219 .36225 .54276 .35191 .52615 .27525 Metetra
.559 .431 .662 r
.52615 .27525 .54276 .35191 .57366 .34146 .55676 .26826 Metetra
.561 .439 .671 r
.55676 .26826 .57366 .34146 .60491 .33089 .58778 .26115 Metetra
.564 .448 .68 r
.58778 .26115 .60491 .33089 .63652 .32021 .61923 .25393 Metetra
.566 .458 .69 r
.61923 .25393 .63652 .32021 .66849 .3094 .65111 .24658 Metetra
.569 .469 .701 r
.65111 .24658 .66849 .3094 .70082 .29846 .68344 .23911 Metetra
.572 .481 .712 r
.68344 .23911 .70082 .29846 .73353 .2874 .71622 .23152 Metetra
.656 .751 .92 r
.01926 .36808 .03853 .3849 .06281 .37948 .0442 .35884 Metetra
.652 .708 .888 r
.0442 .35884 .06281 .37948 .08739 .374 .0694 .34951 Metetra
.646 .669 .858 r
.0694 .34951 .08739 .374 .11227 .36845 .09484 .34009 Metetra
.64 .635 .83 r
.09484 .34009 .11227 .36845 .13747 .36283 .12055 .33057 Metetra
.632 .606 .805 r
.12055 .33057 .13747 .36283 .16298 .35713 .14652 .32095 Metetra
.625 .58 .783 r
.14652 .32095 .16298 .35713 .18881 .35136 .17275 .31124 Metetra
.619 .558 .764 r
.17275 .31124 .18881 .35136 .21496 .34551 .19925 .30142 Metetra
.613 .538 .746 r
.19925 .30142 .21496 .34551 .24145 .33958 .22603 .2915 Metetra
.607 .52 .731 r
.22603 .2915 .24145 .33958 .26828 .33356 .25309 .28148 Metetra
.602 .505 .717 r
.25309 .28148 .26828 .33356 .29546 .32746 .28042 .27136 Metetra
.597 .491 .704 r
.28042 .27136 .29546 .32746 .32299 .32128 .30805 .26113 Metetra
.592 .478 .693 r
.30805 .26113 .32299 .32128 .35088 .315 .33597 .25079 Metetra
.588 .467 .682 r
.33597 .25079 .35088 .315 .37913 .30862 .36418 .24034 Metetra
.584 .457 .673 r
.36418 .24034 .37913 .30862 .40776 .30215 .3927 .22977 Metetra
.581 .448 .664 r
.3927 .22977 .40776 .30215 .43677 .29558 .42152 .2191 Metetra
.577 .439 .657 r
.42152 .2191 .43677 .29558 .46617 .28891 .45066 .20831 Metetra
.574 .432 .65 r
.45066 .20831 .46617 .28891 .49596 .28214 .48011 .1974 Metetra
.572 .425 .643 r
.48011 .1974 .49596 .28214 .52615 .27525 .50988 .18638 Metetra
.569 .418 .637 r
.50988 .18638 .52615 .27525 .55676 .26826 .53998 .17523 Metetra
.567 .412 .631 r
.53998 .17523 .55676 .26826 .58778 .26115 .57041 .16396 Metetra
.564 .407 .626 r
.57041 .16396 .58778 .26115 .61923 .25393 .60118 .15256 Metetra
.562 .402 .621 r
.60118 .15256 .61923 .25393 .65111 .24658 .63229 .14104 Metetra
.56 .397 .617 r
.63229 .14104 .65111 .24658 .68344 .23911 .66375 .12939 Metetra
.558 .392 .613 r
.66375 .12939 .68344 .23911 .71622 .23152 .69556 .11761 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(2)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(3)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.9.6"]
}, Open  ]],

Cell["\<\
When you make the original plot, you can choose to sample more \
points. You will need to do this to get good pictures of functions that \
wiggle a lot. \
\>", "MathCaption",
  CellTags->{"S1.9.6", "6.6"}],

Cell[CellGroupData[{

Cell["\<\
Plot3D[10 Sin[x + Sin[y]], {x, -10, 10}, {y, -10, 10}, PlotPoints \
-> 50]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.1664e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -18 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -9.92245 -9 ]
[.68156 -0.01098 2.07755 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 18 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 12 3.14607 ]
[.02411 .26511 -18 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -12 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -6 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -12 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-10)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(10)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-10)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(10)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-10)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(10)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.793 .598 .637 r
.3927 .76593 .39843 .79509 .41029 .76604 .40491 .72665 Metetra
.774 .572 .626 r
.40491 .72665 .41029 .76604 .42235 .72622 .41709 .68257 Metetra
.759 .557 .623 r
.41709 .68257 .42235 .72622 .43434 .68212 .42901 .64054 Metetra
.743 .547 .629 r
.42901 .64054 .43434 .68212 .44606 .64055 .44053 .60667 Metetra
.718 .538 .646 r
.44053 .60667 .44606 .64055 .45741 .60753 .45163 .58552 Metetra
.654 .528 .698 r
.45163 .58552 .45741 .60753 .46841 .58749 .46237 .57967 Metetra
0 .156 .686 r
.46237 .57967 .46841 .58749 .47914 .58284 .4729 .58954 Metetra
.826 .474 .391 r
.4729 .58954 .47914 .58284 .48974 .59383 .48339 .61333 Metetra
.79 .487 .476 r
.48339 .61333 .48974 .59383 .50038 .61852 .494 .64719 Metetra
.768 .481 .498 r
.494 .64719 .50038 .61852 .5112 .65289 .50487 .68546 Metetra
.75 .466 .501 r
.50487 .68546 .5112 .65289 .5223 .6912 .51606 .72138 Metetra
.725 .436 .489 r
.51606 .72138 .5223 .6912 .53371 .72663 .52754 .74814 Metetra
.67 .36 .44 r
.52754 .74814 .53371 .72663 .54535 .75244 .5392 .76019 Metetra
.166 0 0 r
.5392 .76019 .54535 .75244 .5571 .76323 .55088 .75461 Metetra
.866 .729 .709 r
.55088 .75461 .5571 .76323 .56877 .75633 .56242 .73181 Metetra
.81 .617 .641 r
.56242 .73181 .56877 .75633 .58021 .73239 .57369 .69545 Metetra
.785 .58 .622 r
.57369 .69545 .58021 .73239 .5913 .69529 .58465 .65151 Metetra
.768 .56 .617 r
.58465 .65151 .5913 .69529 .60206 .65112 .59538 .60697 Metetra
.752 .548 .62 r
.59538 .60697 .60206 .65112 .6126 .60687 .60602 .56847 Metetra
.731 .539 .633 r
.60602 .56847 .6126 .60687 .62309 .56909 .61678 .54131 Metetra
.689 .532 .668 r
.61678 .54131 .62309 .56909 .63377 .54297 .62788 .52892 Metetra
.483 .494 .792 r
.62788 .52892 .63377 .54297 .64488 .53179 .63952 .53259 Metetra
.837 .394 .175 r
.63952 .53259 .64488 .53179 .65662 .53665 .65182 .5514 Metetra
.805 .471 .424 r
.65182 .5514 .65662 .53665 .66909 .55648 .66482 .58223 Metetra
.779 .473 .469 r
.66482 .58223 .66909 .55648 .68231 .58801 .67841 .62002 Metetra
.759 .462 .482 r
.67841 .62002 .68231 .58801 .69616 .62603 .69237 .65823 Metetra
.736 .439 .478 r
.69237 .65823 .69616 .62603 .71033 .66396 .70633 .68979 Metetra
.697 .389 .451 r
.70633 .68979 .71033 .66396 .72445 .69473 .71987 .70835 Metetra
.544 .182 .304 r
.71987 .70835 .72445 .69473 .73805 .71211 .73261 .70974 Metetra
.92 .894 .787 r
.73261 .70974 .73805 .71211 .75075 .71214 .74431 .69298 Metetra
.835 .649 .651 r
.74431 .69298 .75075 .71214 .76231 .69412 .75494 .66059 Metetra
.8 .591 .62 r
.75494 .66059 .76231 .69412 .77274 .6608 .76469 .6179 Metetra
.779 .566 .611 r
.76469 .6179 .77274 .6608 .78226 .61766 .77396 .57181 Metetra
.761 .55 .612 r
.77396 .57181 .78226 .61766 .79132 .57167 .78325 .52934 Metetra
.742 .54 .622 r
.78325 .52934 .79132 .57167 .80046 .52978 .79308 .4965 Metetra
.71 .533 .647 r
.79308 .4965 .80046 .52978 .81023 .49789 .80391 .47756 Metetra
.62 .523 .722 r
.80391 .47756 .81023 .49789 .8211 .48013 .81611 .47469 Metetra
0 .058 .57 r
.81611 .47469 .8211 .48013 .83342 .47849 .82984 .48782 Metetra
.822 .437 .323 r
.82984 .48782 .83342 .47849 .84736 .49275 .84506 .51467 Metetra
.791 .459 .425 r
.84506 .51467 .84736 .49275 .86285 .52046 .86151 .55086 Metetra
.769 .454 .454 r
.86151 .55086 .86285 .52046 .87957 .55709 .87865 .59026 Metetra
.746 .437 .46 r
.87865 .59026 .87957 .55709 .89695 .59642 .89576 .62574 Metetra
.714 .401 .446 r
.89576 .62574 .89695 .59642 .91423 .63129 .91203 .65036 Metetra
.634 .295 .379 r
.91203 .65036 .91423 .63129 .93054 .65484 .92671 .65882 Metetra
.92671 .65882 .93054 .65484 .94514 .66196 .93934 .64873 Metetra
.875 .71 .675 r
.93934 .64873 .94514 .66196 .95758 .65052 .94984 .62131 Metetra
.819 .609 .619 r
.94984 .62131 .95758 .65052 .96783 .62199 .95856 .581 Metetra
.792 .573 .604 r
.95856 .581 .96783 .62199 .97628 .58102 .96623 .5344 Metetra
.772 .553 .602 r
.96623 .5344 .97628 .58102 .98371 .53431 .97374 .48877 Metetra
.769 .566 .625 r
.3875 .72439 .3927 .76593 .40491 .72665 .39986 .68027 Metetra
.753 .55 .622 r
.39986 .68027 .40491 .72665 .41709 .68257 .41196 .63815 Metetra
.736 .539 .626 r
.41196 .63815 .41709 .68257 .42901 .64054 .42362 .60416 Metetra
.712 .53 .642 r
.42362 .60416 .42901 .64054 .44053 .60667 .43479 .58288 Metetra
.65 .518 .69 r
.43479 .58288 .44053 .60667 .45163 .58552 .44554 .5769 Metetra
0 .194 .722 r
.44554 .5769 .45163 .58552 .46237 .57967 .45599 .58665 Metetra
.823 .474 .395 r
.45599 .58665 .46237 .57967 .4729 .58954 .46633 .61036 Metetra
.784 .484 .48 r
.46633 .61036 .4729 .58954 .48339 .61333 .47674 .64419 Metetra
.762 .477 .502 r
.47674 .64419 .48339 .61333 .494 .64719 .48739 .68248 Metetra
.742 .462 .505 r
.48739 .68248 .494 .64719 .50487 .68546 .49836 .71847 Metetra
.718 .433 .494 r
.49836 .71847 .50487 .68546 .51606 .72138 .50967 .74534 Metetra
.665 .362 .45 r
.50967 .74534 .51606 .72138 .52754 .74814 .52124 .75752 Metetra
.247 0 .051 r
.52124 .75752 .52754 .74814 .5392 .76019 .53292 .75207 Metetra
.87 .735 .712 r
.53292 .75207 .5392 .76019 .55088 .75461 .54454 .72935 Metetra
.806 .613 .641 r
.54454 .72935 .55088 .75461 .56242 .73181 .55595 .69303 Metetra
.78 .574 .622 r
.55595 .69303 .56242 .73181 .57369 .69545 .56711 .64907 Metetra
.762 .554 .616 r
.56711 .64907 .57369 .69545 .58465 .65151 .57803 .60446 Metetra
.745 .541 .619 r
.57803 .60446 .58465 .65151 .59538 .60697 .58883 .56584 Metetra
.724 .532 .63 r
.58883 .56584 .59538 .60697 .60602 .56847 .5997 .53855 Metetra
.684 .523 .662 r
.5997 .53855 .60602 .56847 .61678 .54131 .61083 .52602 Metetra
.495 .486 .776 r
.61083 .52602 .61678 .54131 .62788 .52892 .62241 .52957 Metetra
.837 .394 .174 r
.62241 .52957 .62788 .52892 .63952 .53259 .63458 .54828 Metetra
.8 .47 .43 r
.63458 .54828 .63952 .53259 .65182 .5514 .64738 .57905 Metetra
.772 .469 .474 r
.64738 .57905 .65182 .5514 .66482 .58223 .66075 .61684 Metetra
.751 .458 .487 r
.66075 .61684 .66482 .58223 .67841 .62002 .67448 .6551 Metetra
.728 .436 .484 r
.67448 .6551 .67841 .62002 .69237 .65823 .68825 .68676 Metetra
.69 .388 .459 r
.68825 .68676 .69237 .65823 .70633 .68979 .70167 .70545 Metetra
.551 .204 .334 r
.70167 .70545 .70633 .68979 .71987 .70835 .71438 .70697 Metetra
.925 .919 .789 r
.71438 .70697 .71987 .70835 .73261 .70974 .72614 .69032 Metetra
.833 .647 .651 r
.72614 .69032 .73261 .70974 .74431 .69298 .7369 .65798 Metetra
.794 .586 .619 r
.7369 .65798 .74431 .69298 .75494 .66059 .74684 .6153 Metetra
.772 .559 .61 r
.74684 .6153 .75494 .66059 .76469 .6179 .75631 .56915 Metetra
.754 .543 .61 r
.75631 .56915 .76469 .6179 .77396 .57181 .76578 .52658 Metetra
.735 .533 .619 r
.76578 .52658 .77396 .57181 .78325 .52934 .77574 .49361 Metetra
.704 .524 .643 r
.77574 .49361 .78325 .52934 .79308 .4965 .78663 .47453 Metetra
.619 .513 .711 r
.78663 .47453 .79308 .4965 .80391 .47756 .79879 .47152 Metetra
0 .085 .607 r
.79879 .47152 .80391 .47756 .81611 .47469 .81241 .48454 Metetra
.818 .437 .331 r
.81241 .48454 .81611 .47469 .82984 .48782 .82746 .51131 Metetra
.784 .456 .433 r
.82746 .51131 .82984 .48782 .84506 .51467 .84368 .54748 Metetra
.761 .451 .461 r
.84368 .54748 .84506 .51467 .86151 .55086 .86058 .5869 Metetra
.738 .434 .467 r
.86058 .5869 .86151 .55086 .87865 .59026 .87748 .62246 Metetra
.706 .399 .455 r
.87748 .62246 .87865 .59026 .89576 .62574 .8936 .64721 Metetra
.63 .302 .396 r
.8936 .64721 .89576 .62574 .91203 .65036 .90822 .6558 Metetra
.90822 .6558 .91203 .65036 .92671 .65882 .92088 .64583 Metetra
.876 .713 .676 r
.92088 .64583 .92671 .65882 .93934 .64873 .9315 .61849 Metetra
.814 .605 .619 r
.9315 .61849 .93934 .64873 .94984 .62131 .94041 .57821 Metetra
.785 .566 .604 r
.94041 .57821 .94984 .62131 .95856 .581 .94829 .53157 Metetra
.765 .546 .602 r
.94829 .53157 .95856 .581 .96623 .5344 .95599 .48586 Metetra
.745 .533 .608 r
.95599 .48586 .96623 .5344 .97374 .48877 .96443 .4477 Metetra
.763 .561 .624 r
.38241 .68194 .3875 .72439 .39986 .68027 .39472 .63925 Metetra
.748 .551 .629 r
.39472 .63925 .39986 .68027 .41196 .63815 .40656 .60413 Metetra
.725 .543 .644 r
.40656 .60413 .41196 .63815 .42362 .60416 .41787 .58134 Metetra
.668 .534 .691 r
.41787 .58134 .42362 .60416 .43479 .58288 .42866 .5737 Metetra
.024 .312 .801 r
.42866 .5737 .43479 .58288 .44554 .5769 .43907 .58186 Metetra
.832 .47 .369 r
.43907 .58186 .44554 .5769 .45599 .58665 .44928 .60428 Metetra
.795 .489 .471 r
.44928 .60428 .45599 .58665 .46633 .61036 .4595 .63732 Metetra
.774 .484 .495 r
.4595 .63732 .46633 .61036 .47674 .64419 .46991 .67548 Metetra
.755 .47 .499 r
.46991 .67548 .47674 .64419 .48739 .68248 .48065 .71207 Metetra
.732 .442 .489 r
.48065 .71207 .48739 .68248 .49836 .71847 .49176 .7402 Metetra
.683 .373 .444 r
.49176 .7402 .49836 .71847 .50967 .74534 .50322 .75411 Metetra
.319 0 .068 r
.50322 .75411 .50967 .74534 .52124 .75752 .51489 .75051 Metetra
.873 .752 .725 r
.51489 .75051 .52124 .75752 .53292 .75207 .52659 .72943 Metetra
.815 .625 .646 r
.52659 .72943 .53292 .75207 .54454 .72935 .53817 .69422 Metetra
.79 .585 .624 r
.53817 .69422 .54454 .72935 .55595 .69303 .54953 .65068 Metetra
.773 .565 .618 r
.54953 .65068 .55595 .69303 .56711 .64907 .56066 .60576 Metetra
.757 .553 .62 r
.56066 .60576 .56711 .64907 .57803 .60446 .57163 .56619 Metetra
.737 .544 .632 r
.57163 .56619 .57803 .60446 .58883 .56584 .58258 .53749 Metetra
.699 .537 .664 r
.58258 .53749 .58883 .56584 .5997 .53855 .59372 .52331 Metetra
.535 .51 .775 r
.59372 .52331 .5997 .53855 .61083 .52602 .60521 .52518 Metetra
.828 .361 .096 r
.60521 .52518 .61083 .52602 .62241 .52957 .6172 .54243 Metetra
.811 .472 .413 r
.6172 .54243 .62241 .52957 .63458 .54828 .62977 .57218 Metetra
.785 .475 .465 r
.62977 .57218 .63458 .54828 .64738 .57905 .64289 .60955 Metetra
.765 .465 .479 r
.64289 .60955 .64738 .57905 .66075 .61684 .65638 .64813 Metetra
.743 .444 .476 r
.65638 .64813 .66075 .61684 .67448 .6551 .66998 .68082 Metetra
.706 .397 .451 r
.66998 .68082 .67448 .6551 .68825 .68676 .68334 .70111 Metetra
.579 .22 .324 r
.68334 .70111 .68825 .68676 .70167 .70545 .69609 .70451 Metetra
.91 .942 .815 r
.69609 .70451 .70167 .70545 .71438 .70697 .708 .68966 Metetra
.841 .661 .658 r
.708 .68966 .71438 .70697 .72614 .69032 .71898 .6587 Metetra
.805 .598 .622 r
.71898 .6587 .72614 .69032 .7369 .65798 .72916 .61672 Metetra
.784 .571 .612 r
.72916 .61672 .7369 .65798 .74684 .6153 .73885 .57054 Metetra
.767 .555 .612 r
.73885 .57054 .74684 .6153 .75631 .56915 .74847 .52724 Metetra
.748 .545 .621 r
.74847 .52724 .75631 .56915 .76578 .52658 .75849 .493 Metetra
.718 .538 .645 r
.75849 .493 .76578 .52658 .77574 .49361 .76934 .4723 Metetra
.64 .529 .712 r
.76934 .4723 .77574 .49361 .78663 .47453 .78136 .46757 Metetra
0 .201 .72 r
.78136 .46757 .78663 .47453 .79879 .47152 .79474 .479 Metetra
.828 .43 .297 r
.79474 .479 .79879 .47152 .81241 .48454 .8095 .50453 Metetra
.797 .46 .417 r
.8095 .50453 .81241 .48454 .82746 .51131 .82542 .54 Metetra
.775 .457 .449 r
.82542 .54 .82746 .51131 .84368 .54748 .84207 .57944 Metetra
.753 .441 .456 r
.84207 .57944 .84368 .54748 .86058 .5869 .85881 .61577 Metetra
.723 .407 .444 r
.85881 .61577 .86058 .5869 .87748 .62246 .87489 .64194 Metetra
.651 .31 .383 r
.87489 .64194 .87748 .62246 .8936 .64721 .88962 .65238 Metetra
.88962 .65238 .8936 .64721 .90822 .6558 .90251 .64433 Metetra
.883 .73 .688 r
.90251 .64433 .90822 .6558 .92088 .64583 .91342 .61859 Metetra
.825 .618 .623 r
.91342 .61859 .92088 .64583 .9315 .61849 .92264 .57931 Metetra
.797 .579 .605 r
.92264 .57931 .9315 .61849 .94041 .57821 .93078 .53293 Metetra
.778 .558 .602 r
.93078 .53293 .94041 .57821 .94829 .53157 .93865 .48674 Metetra
.758 .546 .609 r
.93865 .48674 .94829 .53157 .95599 .48586 .94713 .44748 Metetra
.733 .538 .628 r
.94713 .44748 .95599 .48586 .96443 .4477 .95701 .42044 Metetra
.781 .584 .634 r
.37698 .64975 .38241 .68194 .39472 .63925 .38914 .61132 Metetra
.763 .579 .648 r
.38914 .61132 .39472 .63925 .40656 .60413 .40073 .58378 Metetra
.723 .577 .69 r
.40073 .58378 .40656 .60413 .41787 .58134 .41173 .57066 Metetra
.46 .534 .847 r
.41173 .57066 .41787 .58134 .42866 .5737 .42223 .5734 Metetra
.85 .429 .23 r
.42223 .5734 .42866 .5737 .43907 .58186 .4324 .59119 Metetra
.83 .5 .431 r
.4324 .59119 .43907 .58186 .44928 .60428 .44246 .62111 Metetra
.811 .504 .471 r
.44246 .62111 .44928 .60428 .4595 .63732 .45262 .65824 Metetra
.795 .495 .48 r
.45262 .65824 .4595 .63732 .46991 .67548 .46307 .69622 Metetra
.777 .472 .471 r
.46307 .69622 .46991 .67548 .48065 .71207 .47392 .72806 Metetra
.742 .415 .429 r
.47392 .72806 .48065 .71207 .49176 .7402 .48518 .74744 Metetra
.547 .109 .161 r
.48518 .74744 .49176 .7402 .50322 .75411 .49677 .75009 Metetra
.876 .821 .791 r
.49677 .75009 .50322 .75411 .51489 .75051 .50853 .73482 Metetra
.839 .663 .664 r
.50853 .73482 .51489 .75051 .52659 .72943 .52027 .7039 Metetra
.819 .62 .633 r
.52027 .7039 .52659 .72943 .53817 .69422 .53187 .66242 Metetra
.805 .599 .624 r
.53187 .66242 .53817 .69422 .54953 .65068 .54323 .61711 Metetra
.792 .588 .625 r
.54323 .61711 .54953 .65068 .56066 .60576 .5544 .57491 Metetra
.776 .581 .636 r
.5544 .57491 .56066 .60576 .57163 .56619 .56546 .54187 Metetra
.746 .577 .666 r
.56546 .54187 .57163 .56619 .58258 .53749 .57657 .52232 Metetra
.645 .572 .758 r
.57657 .52232 .58258 .53749 .59372 .52331 .58792 .51857 Metetra
.609 .083 0 r
.58792 .51857 .59372 .52331 .60521 .52518 .59966 .5307 Metetra
.844 .467 .336 r
.59966 .5307 .60521 .52518 .6172 .54243 .61192 .55659 Metetra
.823 .491 .425 r
.61192 .55659 .6172 .54243 .62977 .57218 .62471 .59201 Metetra
.806 .488 .45 r
.62471 .59201 .62977 .57218 .64289 .60955 .63794 .631 Metetra
.789 .471 .45 r
.63794 .631 .64289 .60955 .65638 .64813 .65139 .66657 Metetra
.761 .43 .425 r
.65139 .66657 .65638 .64813 .66998 .68082 .66476 .69183 Metetra
.674 .289 .309 r
.66476 .69183 .66998 .68082 .68334 .70111 .6777 .70143 Metetra
.733 .987 .89 r
.6777 .70143 .68334 .70111 .69609 .70451 .68995 .69282 Metetra
.864 .709 .688 r
.68995 .69282 .69609 .70451 .708 .68966 .70133 .66695 Metetra
.835 .636 .634 r
.70133 .66695 .708 .68966 .71898 .6587 .71191 .62801 Metetra
.818 .607 .617 r
.71191 .62801 .71898 .6587 .72916 .61672 .72189 .58239 Metetra
.804 .592 .615 r
.72189 .58239 .72916 .61672 .73885 .57054 .73164 .53725 Metetra
.788 .583 .623 r
.73164 .53725 .73885 .57054 .74847 .52724 .74161 .4992 Metetra
.764 .578 .647 r
.74161 .4992 .74847 .52724 .75849 .493 .75221 .47338 Metetra
.705 .576 .708 r
.75221 .47338 .75849 .493 .76934 .4723 .76382 .46294 Metetra
.299 .481 .87 r
.76382 .46294 .76934 .4723 .78136 .46757 .77668 .46887 Metetra
.832 .374 .123 r
.77668 .46887 .78136 .46757 .79474 .479 .79088 .48989 Metetra
.836 .465 .351 r
.79088 .48989 .79474 .479 .8095 .50453 .80631 .52253 Metetra
.818 .474 .405 r
.80631 .52253 .8095 .50453 .82542 .54 .82261 .56139 Metetra
.8 .463 .418 r
.82261 .56139 .82542 .54 .84207 .57944 .83924 .59967 Metetra
.775 .433 .406 r
.83924 .59967 .84207 .57944 .85881 .61577 .85552 .63014 Metetra
.72 .348 .343 r
.85552 .63014 .85881 .61577 .87489 .64194 .87071 .64652 Metetra
.278 0 0 r
.87071 .64652 .87489 .64194 .88962 .65238 .88427 .64497 Metetra
.896 .797 .742 r
.88427 .64497 .88962 .65238 .90251 .64433 .89592 .62501 Metetra
.857 .663 .639 r
.89592 .62501 .90251 .64433 .91342 .61859 .9058 .58972 Metetra
.834 .619 .611 r
.9058 .58972 .91342 .61859 .92264 .57931 .91438 .54492 Metetra
.818 .598 .605 r
.91438 .54492 .92264 .57931 .93078 .53293 .92242 .49777 Metetra
.801 .586 .61 r
.92242 .49777 .93078 .53293 .93865 .48674 .93074 .45534 Metetra
.779 .579 .629 r
.93074 .45534 .93865 .48674 .94713 .44748 .94016 .42353 Metetra
.738 .577 .674 r
.94016 .42353 .94713 .44748 .95701 .42044 .95135 .40635 Metetra
.834 .648 .651 r
.37094 .63238 .37698 .64975 .38914 .61132 .38305 .59667 Metetra
.813 .652 .682 r
.38305 .59667 .38914 .61132 .40073 .58378 .39453 .57316 Metetra
.739 .662 .774 r
.39453 .57316 .40073 .58378 .41173 .57066 .40539 .56476 Metetra
0 .218 .702 r
.40539 .56476 .41173 .57066 .42223 .5734 .41575 .57222 Metetra
.878 .476 .262 r
.41575 .57222 .42223 .5734 .4324 .59119 .42581 .59411 Metetra
.879 .533 .389 r
.42581 .59411 .4324 .59119 .44246 .62111 .43579 .62684 Metetra
.872 .541 .421 r
.43579 .62684 .44246 .62111 .45262 .65824 .44591 .665 Metetra
.863 .531 .42 r
.44591 .665 .45262 .65824 .46307 .69622 .45638 .70191 Metetra
.849 .496 .385 r
.45638 .70191 .46307 .69622 .47392 .72806 .46728 .73062 Metetra
.792 .361 .225 r
.46728 .73062 .47392 .72806 .48518 .74744 .47862 .74528 Metetra
.543 .866 .995 r
.47862 .74528 .48518 .74744 .49677 .75009 .49029 .74246 Metetra
.864 .743 .728 r
.49029 .74246 .49677 .75009 .50853 .73482 .50213 .72202 Metetra
.868 .689 .658 r
.50213 .72202 .50853 .73482 .52027 .7039 .51395 .68719 Metetra
.864 .668 .635 r
.51395 .68719 .52027 .7039 .53187 .66242 .52561 .64371 Metetra
.858 .658 .63 r
.52561 .64371 .53187 .66242 .54323 .61711 .53704 .59854 Metetra
.849 .654 .637 r
.53704 .59854 .54323 .61711 .5544 .57491 .54828 .55846 Metetra
.833 .655 .662 r
.54828 .55846 .5544 .57491 .56546 .54187 .55942 .52906 Metetra
.787 .662 .725 r
.55942 .52906 .56546 .54187 .57657 .52232 .57064 .51411 Metetra
.493 .618 .903 r
.57064 .51411 .57657 .52232 .58792 .51857 .58209 .51524 Metetra
.802 .311 0 r
.58209 .51524 .58792 .51857 .59966 .5307 .59395 .53186 Metetra
.886 .494 .283 r
.59395 .53186 .59966 .5307 .61192 .55659 .6063 .56119 Metetra
.884 .522 .355 r
.6063 .56119 .61192 .55659 .62471 .59201 .61914 .59843 Metetra
.876 .52 .37 r
.61914 .59843 .62471 .59201 .63794 .631 .63237 .6372 Metetra
.863 .494 .349 r
.63237 .6372 .63794 .631 .65139 .66657 .64576 .67038 Metetra
.825 .408 .25 r
.64576 .67038 .65139 .66657 .66476 .69183 .65899 .69139 Metetra
.36 0 0 r
.65899 .69139 .66476 .69183 .6777 .70143 .67175 .69558 Metetra
.856 .808 .801 r
.67175 .69558 .6777 .70143 .68995 .69282 .68379 .68145 Metetra
.883 .716 .669 r
.68379 .68145 .68995 .69282 .70133 .66695 .69501 .65099 Metetra
.881 .683 .63 r
.69501 .65099 .70133 .66695 .71191 .62801 .70549 .6092 Metetra
.875 .668 .618 r
.70549 .6092 .71191 .62801 .72189 .58239 .71549 .56288 Metetra
.867 .661 .622 r
.71549 .56288 .72189 .58239 .73164 .53725 .72539 .51915 Metetra
.852 .66 .641 r
.72539 .51915 .73164 .53725 .74161 .4992 .7356 .48426 Metetra
.82 .664 .69 r
.7356 .48426 .74161 .4992 .75221 .47338 .74654 .4628 Metetra
.693 .663 .817 r
.74654 .4628 .75221 .47338 .76382 .46294 .75853 .45729 Metetra
0 .167 .668 r
.75853 .45729 .76382 .46294 .77668 .46887 .77179 .46801 Metetra
.856 .401 .084 r
.77179 .46801 .77668 .46887 .79088 .48989 .78633 .49302 Metetra
.887 .483 .248 r
.78633 .49302 .79088 .48989 .80631 .52253 .80199 .52823 Metetra
.885 .496 .292 r
.80199 .52823 .80631 .52253 .82261 .56139 .81837 .56773 Metetra
.873 .48 .288 r
.81837 .56773 .82261 .56139 .83924 .59967 .8349 .60444 Metetra
.843 .418 .221 r
.8349 .60444 .83924 .59967 .85552 .63014 .85087 .63126 Metetra
.671 .128 0 r
.85087 .63126 .85552 .63014 .87071 .64652 .86561 .64249 Metetra
.752 .888 .94 r
.86561 .64249 .87071 .64652 .88427 .64497 .87864 .63522 Metetra
.897 .756 .697 r
.87864 .63522 .88427 .64497 .89592 .62501 .8898 .61009 Metetra
.9 .703 .627 r
.8898 .61009 .89592 .62501 .9058 .58972 .89933 .57113 Metetra
.895 .68 .605 r
.89933 .57113 .9058 .58972 .91438 .54492 .90779 .52474 Metetra
.887 .67 .603 r
.90779 .52474 .91438 .54492 .92242 .49777 .91594 .47821 Metetra
.874 .666 .619 r
.91594 .47821 .92242 .49777 .93074 .45534 .92462 .43837 Metetra
.848 .669 .66 r
.92462 .43837 .93074 .45534 .94016 .42353 .93459 .41058 Metetra
.772 .673 .754 r
.93459 .41058 .94016 .42353 .95135 .40635 .94645 .39825 Metetra
.93 .767 .658 r
.36419 .63016 .37094 .63238 .38305 .59667 .37644 .5934 Metetra
.911 .781 .706 r
.37644 .5934 .38305 .59667 .39453 .57316 .38805 .56846 Metetra
.818 .797 .832 r
.38805 .56846 .39453 .57316 .40539 .56476 .39902 .55847 Metetra
0 .371 .831 r
.39902 .55847 .40539 .56476 .41575 .57222 .40944 .5644 Metetra
.849 .412 0 r
.40944 .5644 .41575 .57222 .42581 .59411 .41951 .58502 Metetra
.929 .547 .176 r
.41951 .58502 .42581 .59411 .43579 .62684 .42945 .61695 Metetra
.943 .578 .221 r
.42945 .61695 .43579 .62684 .44591 .665 .43952 .65492 Metetra
.938 .569 .2 r
.43952 .65492 .44591 .665 .45638 .70191 .44992 .69233 Metetra
.902 .504 .089 r
.44992 .69233 .45638 .70191 .46728 .73062 .46075 .72219 Metetra
.645 .186 0 r
.46075 .72219 .46728 .73062 .47862 .74528 .47206 .73845 Metetra
.567 .703 .933 r
.47206 .73845 .47862 .74528 .49029 .74246 .48374 .73738 Metetra
.884 .79 .751 r
.48374 .73738 .49029 .74246 .50213 .72202 .49563 .71851 Metetra
.935 .78 .665 r
.49563 .71851 .50213 .72202 .51395 .68719 .50755 .68477 Metetra
.95 .774 .63 r
.50755 .68477 .51395 .68719 .52561 .64371 .51932 .64172 Metetra
.955 .774 .62 r
.51932 .64172 .52561 .64371 .53704 .59854 .53088 .59628 Metetra
.953 .78 .63 r
.53088 .59628 .53704 .59854 .54828 .55846 .54222 .55532 Metetra
.941 .793 .669 r
.54222 .55532 .54828 .55846 .55942 .52906 .55344 .52459 Metetra
.887 .811 .768 r
.55344 .52459 .55942 .52906 .57064 .51411 .56469 .50807 Metetra
.529 .707 .952 r
.56469 .50807 .57064 .51411 .58209 .51524 .57615 .50759 Metetra
0 0 .435 r
.57615 .50759 .58209 .51524 .59395 .53186 .58797 .52279 Metetra
.84 .426 0 r
.58797 .52279 .59395 .53186 .6063 .56119 .60026 .55109 Metetra
.891 .502 .054 r
.60026 .55109 .6063 .56119 .61914 .59843 .61305 .58787 Metetra
.892 .507 .056 r
.61305 .58787 .61914 .59843 .63237 .6372 .62623 .62687 Metetra
.852 .453 0 r
.62623 .62687 .63237 .6372 .64576 .67038 .63961 .66096 Metetra
.669 .242 0 r
.63961 .66096 .64576 .67038 .65899 .69139 .65288 .68345 Metetra
.189 .474 .892 r
.65288 .68345 .65899 .69139 .67175 .69558 .66573 .68941 Metetra
.835 .801 .819 r
.66573 .68941 .67175 .69558 .68379 .68145 .67791 .67699 Metetra
.942 .804 .679 r
.67791 .67699 .68379 .68145 .69501 .65099 .68928 .64786 Metetra
.967 .794 .616 r
.68928 .64786 .69501 .65099 .70549 .6092 .69991 .60678 Metetra
.975 .791 .591 r
.69991 .60678 .70549 .6092 .71549 .56288 .71003 .56046 Metetra
.976 .795 .593 r
.71003 .56046 .71549 .56288 .72539 .51915 .72 .51606 Metetra
.969 .807 .626 r
.72 .51606 .72539 .51915 .7356 .48426 .73024 .47998 Metetra
.937 .827 .711 r
.73024 .47998 .7356 .48426 .74654 .4628 .74116 .45699 Metetra
.759 .804 .888 r
.74116 .45699 .74654 .4628 .75853 .45729 .75308 .44982 Metetra
0 .324 .81 r
.75308 .44982 .75853 .45729 .77179 .46801 .76623 .459 Metetra
.613 .2 0 r
.76623 .459 .77179 .46801 .78633 .49302 .78067 .48278 Metetra
.755 .359 0 r
.78067 .48278 .78633 .49302 .80199 .52823 .79624 .51727 Metetra
.78 .393 0 r
.79624 .51727 .80199 .52823 .81837 .56773 .81259 .55671 Metetra
.743 .355 0 r
.81259 .55671 .81837 .56773 .8349 .60444 .82914 .59408 Metetra
0 0 .367 r
.82914 .59408 .8349 .60444 .85087 .63126 .84522 .6222 Metetra
0 .244 .759 r
.84522 .6222 .85087 .63126 .86561 .64249 .86015 .63515 Metetra
.7 .762 .9 r
.86015 .63515 .86561 .64249 .87864 .63522 .87341 .62968 Metetra
.937 .832 .714 r
.87341 .62968 .87864 .63522 .8898 .61009 .88481 .60609 Metetra
.982 .817 .602 r
.88481 .60609 .8898 .61009 .89933 .57113 .89455 .56812 Metetra
.993 .807 .552 r
.89455 .56812 .89933 .57113 .90779 .52474 .90316 .52201 Metetra
.995 .806 .54 r
.90316 .52201 .90779 .52474 .91594 .47821 .91138 .47506 Metetra
.993 .818 .565 r
.91138 .47506 .91594 .47821 .92462 .43837 .92005 .43418 Metetra
.976 .841 .644 r
.92005 .43418 .92462 .43837 .93459 .41058 .92993 .40495 Metetra
.878 .85 .812 r
.92993 .40495 .93459 .41058 .94645 .39825 .94163 .39096 Metetra
.989 .887 .563 r
.35663 .64326 .36419 .63016 .37644 .5934 .36922 .60236 Metetra
.982 .91 .616 r
.36922 .60236 .37644 .5934 .38805 .56846 .38122 .57111 Metetra
.941 .94 .761 r
.38122 .57111 .38805 .56846 .39902 .55847 .39254 .55359 Metetra
.584 .763 .964 r
.39254 .55359 .39902 .55847 .40944 .5644 .40325 .55183 Metetra
0 .072 .634 r
.40325 .55183 .40944 .5644 .41951 .58502 .4135 .56567 Metetra
0 0 .362 r
.4135 .56567 .41951 .58502 .42945 .61695 .42351 .59274 Metetra
0 0 .277 r
.42351 .59274 .42945 .61695 .43952 .65492 .43353 .62863 Metetra
0 0 .284 r
.43353 .62863 .43952 .65492 .44992 .69233 .44378 .66726 Metetra
0 0 .363 r
.44378 .66726 .44992 .69233 .46075 .72219 .45443 .70168 Metetra
0 0 .54 r
.45443 .70168 .46075 .72219 .47206 .73845 .46556 .72518 Metetra
.284 .403 .808 r
.46556 .72518 .47206 .73845 .48374 .73738 .47713 .73274 Metetra
.823 .822 .848 r
.47713 .73274 .48374 .73738 .49563 .71851 .489 .72224 Metetra
.977 .904 .673 r
.489 .72224 .49563 .71851 .50755 .68477 .50099 .69501 Metetra
.984 .888 .546 r
.50099 .69501 .50755 .68477 .51932 .64172 .51292 .6555 Metetra
.971 .871 .482 r
.51292 .6555 .51932 .64172 .53088 .59628 .52464 .61018 Metetra
.961 .869 .467 r
.52464 .61018 .53088 .59628 .54222 .55532 .53614 .56611 Metetra
.96 .891 .507 r
.53614 .56611 .54222 .55532 .55344 .52459 .54747 .52972 Metetra
.959 .942 .642 r
.54747 .52972 .55344 .52459 .56469 .50807 .55874 .5059 Metetra
.808 .916 .912 r
.55874 .5059 .56469 .50807 .57615 .50759 .57013 .49754 Metetra
.16 .383 .831 r
.57013 .49754 .57615 .50759 .58797 .52279 .58181 .50536 Metetra
0 0 .564 r
.58181 .50536 .58797 .52279 .60026 .55109 .59393 .52783 Metetra
0 0 .453 r
.59393 .52783 .60026 .55109 .61305 .58787 .60654 .56128 Metetra
0 0 .431 r
.60654 .56128 .61305 .58787 .62623 .62687 .61961 .60014 Metetra
0 0 .466 r
.61961 .60014 .62623 .62687 .63961 .66096 .63299 .63757 Metetra
0 .004 .56 r
.63299 .63757 .63961 .66096 .65288 .68345 .64642 .66647 Metetra
.152 .268 .73 r
.64642 .66647 .65288 .68345 .66573 .68941 .65958 .68085 Metetra
.654 .7 .88 r
.65958 .68085 .66573 .68941 .67791 .67699 .67217 .67727 Metetra
.959 .922 .724 r
.67217 .67727 .67791 .67699 .68928 .64786 .68399 .65569 Metetra
.961 .889 .503 r
.68399 .65569 .68928 .64786 .69991 .60678 .69502 .61949 Metetra
.915 .836 .38 r
.69502 .61949 .69991 .60678 .71003 .56046 .7054 .57466 Metetra
.884 .812 .332 r
.7054 .57466 .71003 .56046 .72 .51606 .71544 .52831 Metetra
.879 .825 .351 r
.71544 .52831 .72 .51606 .73024 .47998 .72555 .48738 Metetra
.907 .89 .47 r
.72555 .48738 .73024 .47998 .74116 .45699 .73614 .4575 Metetra
.908 .981 .779 r
.73614 .4575 .74116 .45699 .75308 .44982 .74759 .44244 Metetra
.46 .636 .931 r
.74759 .44244 .75308 .44982 .76623 .459 .7602 .44379 Metetra
.029 .198 .705 r
.7602 .44379 .76623 .459 .78067 .48278 .77409 .46089 Metetra
0 .034 .583 r
.77409 .46089 .78067 .48278 .79624 .51727 .78923 .49088 Metetra
0 0 .543 r
.78923 .49088 .79624 .51727 .81259 .55671 .80536 .52882 Metetra
0 0 .549 r
.80536 .52882 .81259 .55671 .82914 .59408 .82199 .56818 Metetra
0 .068 .595 r
.82199 .56818 .82914 .59408 .84522 .6222 .83849 .60167 Metetra
.125 .219 .691 r
.83849 .60167 .84522 .6222 .86015 .63515 .85414 .62256 Metetra
.464 .53 .84 r
.85414 .62256 .86015 .63515 .87341 .62968 .86833 .62615 Metetra
.902 .908 .818 r
.86833 .62615 .87341 .62968 .88481 .60609 .88069 .61097 Metetra
.93 .89 .48 r
.88069 .61097 .88481 .60609 .89455 .56812 .89124 .57915 Metetra
.818 .769 .259 r
.89124 .57915 .89455 .56812 .90316 .52201 .90035 .53594 Metetra
.748 .703 .165 r
.90035 .53594 .90316 .52201 .91138 .47506 .90868 .48832 Metetra
.725 .694 .155 r
.90868 .48832 .91138 .47506 .92005 .43418 .91706 .44358 Metetra
.758 .755 .242 r
.91706 .44358 .92005 .43418 .92993 .40495 .92631 .40804 Metetra
.865 .926 .538 r
.92631 .40804 .92993 .40495 .94163 .39096 .93712 .38631 Metetra
.763 .774 .271 r
.34825 .67011 .35663 .64326 .36922 .60236 .36122 .62549 Metetra
.768 .791 .297 r
.36122 .62549 .36922 .60236 .38122 .57111 .37375 .58608 Metetra
.822 .87 .427 r
.37375 .58608 .38122 .57111 .39254 .55359 .38566 .55736 Metetra
.889 .99 .77 r
.38566 .55736 .39254 .55359 .40325 .55183 .3969 .54304 Metetra
.47 .59 .891 r
.3969 .54304 .40325 .55183 .4135 .56567 .40756 .54467 Metetra
.076 .158 .648 r
.40756 .54467 .4135 .56567 .42351 .59274 .41781 .56161 Metetra
0 .006 .532 r
.41781 .56161 .42351 .59274 .43353 .62863 .42788 .59105 Metetra
0 0 .493 r
.42788 .59105 .43353 .62863 .44378 .66726 .43801 .62815 Metetra
0 0 .496 r
.43801 .62815 .44378 .66726 .45443 .70168 .44843 .66658 Metetra
0 .024 .537 r
.44843 .66658 .45443 .70168 .46556 .72518 .45927 .69927 Metetra
.118 .163 .634 r
.45927 .69927 .46556 .72518 .47713 .73274 .47059 .71976 Metetra
.444 .503 .825 r
.47059 .71976 .47713 .73274 .489 .72224 .48231 .72352 Metetra
.901 .97 .815 r
.48231 .72352 .489 .72224 .50099 .69501 .49429 .70916 Metetra
.799 .847 .389 r
.49429 .70916 .50099 .69501 .51292 .6555 .50633 .67873 Metetra
.50633 .67873 .51292 .6555 .52464 .61018 .51827 .63725 Metetra
.51827 .63725 .52464 .61018 .53614 .56611 .52998 .59144 Metetra
.52998 .59144 .53614 .56611 .54747 .52972 .54147 .54836 Metetra
.54147 .54836 .54747 .52972 .55874 .5059 .55282 .51418 Metetra
.796 .905 .503 r
.55282 .51418 .55874 .5059 .57013 .49754 .56415 .49339 Metetra
.705 .837 .946 r
.56415 .49339 .57013 .49754 .58181 .50536 .57566 .48845 Metetra
.255 .324 .743 r
.57566 .48845 .58181 .50536 .59393 .52783 .58751 .49959 Metetra
.095 .134 .612 r
.58751 .49959 .59393 .52783 .60654 .56128 .59983 .52481 Metetra
.046 .071 .563 r
.59983 .52481 .60654 .56128 .61961 .60014 .61266 .56 Metetra
.043 .061 .553 r
.61266 .56 .61961 .60014 .63299 .63757 .62594 .59924 Metetra
.073 .089 .571 r
.62594 .59924 .63299 .63757 .64642 .66647 .63948 .63552 Metetra
.148 .168 .624 r
.63948 .63552 .64642 .66647 .65958 .68085 .653 .66182 Metetra
.328 .362 .745 r
.653 .66182 .65958 .68085 .67217 .67727 .66616 .67257 Metetra
.767 .847 .912 r
.66616 .67257 .67217 .67727 .68399 .65569 .67868 .66498 Metetra
.765 .854 .41 r
.67868 .66498 .68399 .65569 .69502 .61949 .69038 .63979 Metetra
.69038 .63979 .69502 .61949 .7054 .57466 .70128 .60104 Metetra
0 0 .041 r
.70128 .60104 .7054 .57466 .71544 .52831 .71158 .5551 Metetra
0 0 .064 r
.71158 .5551 .71544 .52831 .72555 .48738 .72161 .5092 Metetra
0 0 .017 r
.72161 .5092 .72555 .48738 .73614 .4575 .73181 .47006 Metetra
.73181 .47006 .73614 .4575 .74759 .44244 .7426 .44299 Metetra
.83 .999 .825 r
.7426 .44299 .74759 .44244 .7602 .44379 .75434 .4313 Metetra
.419 .492 .828 r
.75434 .4313 .7602 .44379 .77409 .46089 .76731 .43611 Metetra
.218 .244 .674 r
.76731 .43611 .77409 .46089 .78923 .49088 .7816 .45629 Metetra
.156 .163 .615 r
.7816 .45629 .78923 .49088 .80536 .52882 .79713 .4885 Metetra
.142 .14 .595 r
.79713 .4885 .80536 .52882 .82199 .56818 .81357 .52741 Metetra
.154 .15 .6 r
.81357 .52741 .82199 .56818 .83849 .60167 .83041 .56621 Metetra
.196 .193 .628 r
.83041 .56621 .83849 .60167 .85414 .62256 .84695 .59761 Metetra
.294 .302 .698 r
.84695 .59761 .85414 .62256 .86833 .62615 .86247 .61514 Metetra
.566 .617 .863 r
.86247 .61514 .86833 .62615 .88069 .61097 .87639 .6147 Metetra
.802 .935 .571 r
.87639 .6147 .88069 .61097 .89124 .57915 .88841 .59558 Metetra
0 0 .008 r
.88841 .59558 .89124 .57915 .90035 .53594 .89864 .56068 Metetra
0 0 .161 r
.89864 .56068 .90035 .53594 .90868 .48832 .90752 .51574 Metetra
0 0 .204 r
.90752 .51574 .90868 .48832 .91706 .44358 .91578 .46797 Metetra
0 0 .188 r
.91578 .46797 .91706 .44358 .92631 .40804 .92428 .42455 Metetra
0 0 .083 r
.92428 .42455 .92631 .40804 .93712 .38631 .93382 .39151 Metetra
.33936 .70286 .34825 .67011 .36122 .62549 .35251 .6594 Metetra
.35251 .6594 .36122 .62549 .37375 .58608 .36551 .6147 Metetra
.36551 .6147 .37375 .58608 .38566 .55736 .37806 .57544 Metetra
.37806 .57544 .38566 .55736 .3969 .54304 .38999 .5471 Metetra
.865 .995 .762 r
.38999 .5471 .3969 .54304 .40756 .54467 .40127 .53328 Metetra
.482 .539 .839 r
.40127 .53328 .40756 .54467 .41781 .56161 .41198 .53549 Metetra
.198 .208 .644 r
.41198 .53549 .41781 .56161 .42788 .59105 .42231 .55298 Metetra
.101 .094 .562 r
.42231 .55298 .42788 .59105 .43801 .62815 .43249 .58286 Metetra
.069 .056 .533 r
.43249 .58286 .43801 .62815 .44843 .66658 .44275 .62022 Metetra
.071 .057 .534 r
.44275 .62022 .44843 .66658 .45927 .69927 .4533 .65865 Metetra
.105 .096 .562 r
.4533 .65865 .45927 .69927 .47059 .71976 .46429 .69108 Metetra
.195 .203 .64 r
.46429 .69108 .47059 .71976 .48231 .72352 .47573 .71105 Metetra
.461 .523 .835 r
.47573 .71105 .48231 .72352 .49429 .70916 .48756 .71413 Metetra
.814 .98 .696 r
.48756 .71413 .49429 .70916 .50633 .67873 .49961 .69904 Metetra
.49961 .69904 .50633 .67873 .51827 .63725 .5117 .66796 Metetra
0 0 .043 r
.5117 .66796 .51827 .63725 .52998 .59144 .52365 .62602 Metetra
0 0 .089 r
.52365 .62602 .52998 .59144 .54147 .54836 .53538 .58001 Metetra
0 0 .074 r
.53538 .58001 .54147 .54836 .55282 .51418 .54689 .537 Metetra
.54689 .537 .55282 .51418 .56415 .49339 .55826 .50311 Metetra
.675 .83 .399 r
.55826 .50311 .56415 .49339 .57566 .48845 .56965 .48279 Metetra
.687 .781 .922 r
.56965 .48279 .57566 .48845 .58751 .49959 .58124 .47842 Metetra
.322 .33 .713 r
.58124 .47842 .58751 .49959 .59983 .52481 .59321 .49013 Metetra
.205 .187 .616 r
.59321 .49013 .59983 .52481 .61266 .56 .60568 .51585 Metetra
.165 .137 .579 r
.60568 .51585 .61266 .56 .62594 .59924 .61868 .55138 Metetra
.157 .127 .571 r
.61868 .55138 .62594 .59924 .63948 .63552 .63214 .59073 Metetra
.173 .145 .584 r
.63214 .59073 .63948 .63552 .653 .66182 .64585 .62684 Metetra
.222 .205 .627 r
.64585 .62684 .653 .66182 .66616 .67257 .65951 .65271 Metetra
.357 .375 .741 r
.65951 .65271 .66616 .67257 .67868 .66498 .67277 .66281 Metetra
.78 .939 .932 r
.67277 .66281 .67868 .66498 .69038 .63979 .68535 .65447 Metetra
.68535 .65447 .69038 .63979 .70128 .60104 .69706 .62856 Metetra
0 0 .136 r
.69706 .62856 .70128 .60104 .71158 .5551 .70796 .58926 Metetra
0 0 .204 r
.70796 .58926 .71158 .5551 .72161 .5092 .71824 .54301 Metetra
0 0 .21 r
.71824 .54301 .72161 .5092 .73181 .47006 .72827 .49707 Metetra
0 0 .16 r
.72827 .49707 .73181 .47006 .7426 .44299 .73849 .45815 Metetra
.73849 .45815 .7426 .44299 .75434 .4313 .74934 .4315 Metetra
.821 .998 .843 r
.74934 .4315 .75434 .4313 .76731 .43611 .7612 .42035 Metetra
.444 .461 .783 r
.7612 .42035 .76731 .43611 .7816 .45629 .77433 .42574 Metetra
.292 .268 .66 r
.77433 .42574 .7816 .45629 .79713 .4885 .78882 .44646 Metetra
.243 .205 .615 r
.78882 .44646 .79713 .4885 .81357 .52741 .80457 .47908 Metetra
.229 .186 .6 r
.80457 .47908 .81357 .52741 .83041 .56621 .82125 .5182 Metetra
.234 .191 .604 r
.82125 .5182 .83041 .56621 .84695 .59761 .8383 .55695 Metetra
.26 .224 .627 r
.8383 .55695 .84695 .59761 .86247 .61514 .85502 .588 Metetra
.331 .317 .692 r
.85502 .588 .86247 .61514 .87639 .6147 .87065 .60494 Metetra
.579 .653 .887 r
.87065 .60494 .87639 .6147 .88841 .59558 .88462 .60376 Metetra
.88462 .60376 .88841 .59558 .89864 .56068 .89664 .58387 Metetra
0 0 .196 r
.89664 .58387 .89864 .56068 .90752 .51574 .90681 .54833 Metetra
0 0 .288 r
.90681 .54833 .90752 .51574 .91578 .46797 .91563 .50297 Metetra
0 0 .309 r
.91563 .50297 .91578 .46797 .92428 .42455 .92385 .45505 Metetra
0 0 .289 r
.92385 .45505 .92428 .42455 .93382 .39151 .93235 .41175 Metetra
.33065 .72868 .33936 .70286 .35251 .6594 .3436 .69303 Metetra
.3436 .69303 .35251 .6594 .36551 .6147 .35679 .64931 Metetra
.35679 .64931 .36551 .6147 .37806 .57544 .36982 .60448 Metetra
.36982 .60448 .37806 .57544 .38999 .5471 .3824 .56525 Metetra
.3824 .56525 .38999 .5471 .40127 .53328 .39436 .53705 Metetra
.865 .995 .772 r
.39436 .53705 .40127 .53328 .41198 .53549 .40568 .52348 Metetra
.476 .526 .829 r
.40568 .52348 .41198 .53549 .42231 .55298 .41647 .52597 Metetra
.205 .209 .641 r
.41647 .52597 .42231 .55298 .43249 .58286 .42689 .54377 Metetra
.112 .1 .563 r
.42689 .54377 .43249 .58286 .44275 .62022 .43718 .57391 Metetra
.081 .063 .535 r
.43718 .57391 .44275 .62022 .4533 .65865 .44757 .61145 Metetra
.083 .065 .536 r
.44757 .61145 .4533 .65865 .46429 .69108 .45826 .64992 Metetra
.115 .102 .565 r
.45826 .64992 .46429 .69108 .47573 .71105 .46938 .68225 Metetra
.203 .208 .642 r
.46938 .68225 .47573 .71105 .48756 .71413 .48094 .70196 Metetra
.47 .535 .842 r
.48094 .70196 .48756 .71413 .49961 .69904 .49287 .70466 Metetra
.788 .966 .659 r
.49287 .70466 .49961 .69904 .5117 .66796 .505 .68913 Metetra
.505 .68913 .5117 .66796 .52365 .62602 .51713 .65764 Metetra
0 0 .062 r
.51713 .65764 .52365 .62602 .53538 .58001 .5291 .61538 Metetra
0 0 .104 r
.5291 .61538 .53538 .58001 .54689 .537 .54084 .56919 Metetra
0 0 .087 r
.54084 .56919 .54689 .537 .55826 .50311 .55236 .52614 Metetra
.55236 .52614 .55826 .50311 .56965 .48279 .56376 .49235 Metetra
.672 .83 .402 r
.56376 .49235 .56965 .48279 .58124 .47842 .57521 .47224 Metetra
.677 .764 .916 r
.57521 .47224 .58124 .47842 .59321 .49013 .58689 .46814 Metetra
.325 .327 .707 r
.58689 .46814 .59321 .49013 .60568 .51585 .59898 .48016 Metetra
.213 .19 .614 r
.59898 .48016 .60568 .51585 .61868 .55138 .61159 .50616 Metetra
.174 .142 .579 r
.61159 .50616 .61868 .55138 .63214 .59073 .62476 .54191 Metetra
.166 .132 .572 r
.62476 .54191 .63214 .59073 .64585 .62684 .6384 .58136 Metetra
.181 .15 .585 r
.6384 .58136 .64585 .62684 .65951 .65271 .65228 .61742 Metetra
.229 .209 .628 r
.65228 .61742 .65951 .65271 .67277 .66281 .66609 .64307 Metetra
.363 .38 .744 r
.66609 .64307 .67277 .66281 .68535 .65447 .67947 .65283 Metetra
.783 .957 .925 r
.67947 .65283 .68535 .65447 .69706 .62856 .69211 .64406 Metetra
.69211 .64406 .69706 .62856 .70796 .58926 .70386 .61771 Metetra
0 0 .154 r
.70386 .61771 .70796 .58926 .71824 .54301 .71475 .57804 Metetra
0 0 .216 r
.71475 .57804 .71824 .54301 .72827 .49707 .72502 .53154 Metetra
0 0 .221 r
.72502 .53154 .72827 .49707 .73849 .45815 .73504 .4855 Metetra
0 0 .169 r
.73504 .4855 .73849 .45815 .74934 .4315 .74528 .44663 Metetra
.74528 .44663 .74934 .4315 .7612 .42035 .75619 .42015 Metetra
.822 .995 .858 r
.75619 .42015 .7612 .42035 .77433 .42574 .76814 .40925 Metetra
.442 .453 .776 r
.76814 .40925 .77433 .42574 .78882 .44646 .78141 .41495 Metetra
.297 .268 .657 r
.78141 .41495 .78882 .44646 .80457 .47908 .79609 .43596 Metetra
.25 .208 .614 r
.79609 .43596 .80457 .47908 .82125 .5182 .81206 .46883 Metetra
.235 .189 .6 r
.81206 .46883 .82125 .5182 .8383 .55695 .82897 .50809 Metetra
.24 .195 .604 r
.82897 .50809 .8383 .55695 .85502 .588 .84624 .54684 Metetra
.266 .228 .628 r
.84624 .54684 .85502 .588 .87065 .60494 .86315 .57774 Metetra
.336 .32 .693 r
.86315 .57774 .87065 .60494 .88462 .60376 .87892 .59438 Metetra
.587 .669 .896 r
.87892 .59438 .88462 .60376 .89664 .58387 .89297 .59277 Metetra
.89297 .59277 .89664 .58387 .90681 .54833 .90501 .57243 Metetra
0 0 .212 r
.90501 .57243 .90681 .54833 .91563 .50297 .91516 .53647 Metetra
0 0 .298 r
.91516 .53647 .91563 .50297 .92385 .45505 .92393 .4908 Metetra
0 0 .317 r
.92393 .4908 .92385 .45505 .93235 .41175 .93212 .44272 Metetra
.893 .943 .58 r
.32259 .73952 .33065 .72868 .3436 .69303 .33509 .71513 Metetra
.777 .811 .33 r
.33509 .71513 .3436 .69303 .35679 .64931 .34817 .67757 Metetra
.71 .741 .229 r
.34817 .67757 .35679 .64931 .36982 .60448 .36141 .63302 Metetra
.688 .723 .207 r
.36141 .63302 .36982 .60448 .3824 .56525 .37443 .58851 Metetra
.711 .758 .256 r
.37443 .58851 .3824 .56525 .39436 .53705 .38696 .55062 Metetra
.8 .873 .438 r
.38696 .55062 .39436 .53705 .40568 .52348 .39887 .52452 Metetra
.858 .978 .859 r
.39887 .52452 .40568 .52348 .41647 .52597 .41016 .51347 Metetra
.368 .458 .821 r
.41016 .51347 .41647 .52597 .42689 .54377 .42094 .51856 Metetra
.081 .134 .618 r
.42094 .51856 .42689 .54377 .43718 .57391 .43141 .53866 Metetra
0 .022 .533 r
.43141 .53866 .43718 .57391 .44757 .61145 .44179 .57045 Metetra
0 0 .506 r
.44179 .57045 .44757 .61145 .45826 .64992 .45232 .6087 Metetra
0 .005 .515 r
.45232 .6087 .45826 .64992 .46938 .68225 .46318 .64675 Metetra
.042 .067 .56 r
.46318 .64675 .46938 .68225 .48094 .70196 .47447 .67748 Metetra
.187 .222 .666 r
.47447 .67748 .48094 .70196 .49287 .70466 .4862 .69467 Metetra
.557 .625 .875 r
.4862 .69467 .49287 .70466 .505 .68913 .49826 .69436 Metetra
.886 .978 .683 r
.49826 .69436 .505 .68913 .51713 .65764 .51046 .67589 Metetra
.679 .749 .251 r
.51046 .67589 .51713 .65764 .5291 .61538 .52262 .64208 Metetra
.52262 .64208 .5291 .61538 .54084 .56919 .5346 .59852 Metetra
.5346 .59852 .54084 .56919 .55236 .52614 .54633 .5522 Metetra
.54633 .5522 .55236 .52614 .56376 .49235 .55786 .51013 Metetra
.55786 .51013 .56376 .49235 .57521 .47224 .56929 .47821 Metetra
.813 .947 .597 r
.56929 .47821 .57521 .47224 .58689 .46814 .58082 .46054 Metetra
.585 .689 .913 r
.58082 .46054 .58689 .46814 .59898 .48016 .59263 .45909 Metetra
.233 .274 .699 r
.59263 .45909 .59898 .48016 .61159 .50616 .6049 .4736 Metetra
.118 .135 .602 r
.6049 .4736 .61159 .50616 .62476 .54191 .61773 .50159 Metetra
.083 .089 .566 r
.61773 .50159 .62476 .54191 .6384 .58136 .63112 .53846 Metetra
.085 .086 .561 r
.63112 .53846 .6384 .58136 .65228 .61742 .64496 .57794 Metetra
.117 .119 .583 r
.64496 .57794 .65228 .61742 .66609 .64307 .659 .61284 Metetra
.196 .206 .643 r
.659 .61284 .66609 .64307 .67947 .65283 .67289 .63626 Metetra
.4 .437 .783 r
.67289 .63626 .67947 .65283 .69211 .64406 .68627 .64307 Metetra
.854 .97 .87 r
.68627 .64307 .69211 .64406 .70386 .61771 .69885 .6312 Metetra
.69885 .6312 .70386 .61771 .71475 .57804 .7105 .60217 Metetra
0 0 .03 r
.7105 .60217 .71475 .57804 .72502 .53154 .72129 .56074 Metetra
0 0 .106 r
.72129 .56074 .72502 .53154 .73504 .4855 .7315 .51364 Metetra
0 0 .111 r
.7315 .51364 .73504 .4855 .74528 .44663 .74153 .46818 Metetra
0 0 .043 r
.74153 .46818 .74528 .44663 .75619 .42015 .75187 .43089 Metetra
.75187 .43089 .75619 .42015 .76814 .40925 .76297 .40669 Metetra
.784 .938 .929 r
.76297 .40669 .76814 .40925 .78141 .41495 .7752 .39845 Metetra
.368 .409 .772 r
.7752 .39845 .78141 .41495 .79609 .43596 .78881 .40677 Metetra
.226 .23 .654 r
.78881 .40677 .79609 .43596 .81206 .46883 .80386 .43005 Metetra
.18 .17 .61 r
.80386 .43005 .81206 .46883 .82897 .50809 .82018 .46443 Metetra
.172 .156 .597 r
.82018 .46443 .82897 .50809 .84624 .54684 .83738 .50419 Metetra
.186 .17 .606 r
.83738 .50419 .84624 .54684 .86315 .57774 .85484 .54223 Metetra
.23 .218 .638 r
.85484 .54223 .86315 .57774 .87892 .59438 .87179 .57125 Metetra
.339 .346 .721 r
.87179 .57125 .87892 .59438 .89297 .59277 .88746 .5851 Metetra
.674 .757 .913 r
.88746 .5851 .89297 .59277 .90501 .57243 .90129 .58032 Metetra
.90129 .58032 .90501 .57243 .91516 .53647 .91305 .55701 Metetra
0 0 .117 r
.91305 .55701 .91516 .53647 .92393 .4908 .92295 .51885 Metetra
0 0 .219 r
.92295 .51885 .92393 .4908 .93212 .44272 .93156 .47209 Metetra
.895 .872 .807 r
.31512 .73821 .32259 .73952 .33509 .71513 .32719 .72295 Metetra
.981 .908 .647 r
.32719 .72295 .33509 .71513 .34817 .67757 .34007 .69194 Metetra
.982 .893 .551 r
.34007 .69194 .34817 .67757 .36141 .63302 .35335 .65029 Metetra
.972 .883 .507 r
.35335 .65029 .36141 .63302 .37443 .58851 .3666 .60474 Metetra
.965 .888 .506 r
.3666 .60474 .37443 .58851 .38696 .55062 .3795 .56229 Metetra
.964 .913 .561 r
.3795 .56229 .38696 .55062 .39887 .52452 .39183 .529 Metetra
.948 .957 .718 r
.39183 .529 .39887 .52452 .41016 .51347 .40352 .50924 Metetra
.671 .82 .955 r
.40352 .50924 .41016 .51347 .42094 .51856 .41461 .50532 Metetra
0 .19 .713 r
.41461 .50532 .42094 .51856 .43141 .53866 .42528 .51736 Metetra
0 0 .463 r
.42528 .51736 .43141 .53866 .44179 .57045 .43573 .54322 Metetra
0 0 .374 r
.43573 .54322 .44179 .57045 .45232 .6087 .4462 .5787 Metetra
0 0 .369 r
.4462 .5787 .45232 .6087 .46318 .64675 .45691 .61781 Metetra
0 0 .423 r
.45691 .61781 .46318 .64675 .47447 .67748 .46801 .65355 Metetra
0 0 .552 r
.46801 .65355 .47447 .67748 .4862 .69467 .47957 .67897 Metetra
.242 .346 .77 r
.47957 .67897 .4862 .69467 .49826 .69436 .49152 .68869 Metetra
.782 .806 .871 r
.49152 .68869 .49826 .69436 .51046 .67589 .50373 .68013 Metetra
.972 .928 .67 r
.50373 .68013 .51046 .67589 .52262 .64208 .516 .6542 Metetra
.955 .889 .496 r
.516 .6542 .52262 .64208 .5346 .59852 .52816 .61511 Metetra
.92 .852 .408 r
.52816 .61511 .5346 .59852 .54633 .5522 .54009 .56928 Metetra
.9 .84 .382 r
.54009 .56928 .54633 .5522 .55786 .51013 .55178 .52388 Metetra
.902 .863 .419 r
.55178 .52388 .55786 .51013 .56929 .47821 .5633 .48557 Metetra
.927 .931 .565 r
.5633 .48557 .56929 .47821 .58082 .46054 .57481 .4595 Metetra
.85 .955 .88 r
.57481 .4595 .58082 .46054 .59263 .45909 .5865 .44888 Metetra
.283 .463 .861 r
.5865 .44888 .59263 .45909 .6049 .4736 .59856 .45467 Metetra
0 .081 .621 r
.59856 .45467 .6049 .4736 .61773 .50159 .61114 .47563 Metetra
0 0 .516 r
.61114 .47563 .61773 .50159 .63112 .53846 .6243 .50829 Metetra
0 0 .488 r
.6243 .50829 .63112 .53846 .64496 .57794 .638 .54725 Metetra
0 0 .508 r
.638 .54725 .64496 .57794 .659 .61284 .65205 .58568 Metetra
0 .041 .574 r
.65205 .58568 .659 .61284 .67289 .63626 .66615 .61631 Metetra
.157 .245 .705 r
.66615 .61631 .67289 .63626 .68627 .64307 .67994 .63284 Metetra
.59 .645 .873 r
.67994 .63284 .68627 .64307 .69885 .6312 .69307 .63136 Metetra
.948 .943 .742 r
.69307 .63136 .69885 .6312 .7105 .60217 .70531 .61138 Metetra
.912 .876 .445 r
.70531 .61138 .7105 .60217 .72129 .56074 .7166 .57597 Metetra
.826 .785 .284 r
.7166 .57597 .72129 .56074 .7315 .51364 .72714 .53096 Metetra
.777 .743 .222 r
.72714 .53096 .7315 .51364 .74153 .46818 .73726 .48356 Metetra
.77 .751 .234 r
.73726 .48356 .74153 .46818 .75187 .43089 .74741 .44087 Metetra
.814 .827 .352 r
.74741 .44087 .75187 .43089 .76297 .40669 .75808 .40879 Metetra
.893 .98 .696 r
.75808 .40879 .76297 .40669 .7752 .39845 .7697 .39139 Metetra
.545 .7 .942 r
.7697 .39139 .7752 .39845 .78881 .40677 .78259 .39053 Metetra
.133 .262 .731 r
.78259 .39053 .78881 .40677 .80386 .43005 .79694 .40584 Metetra
0 .099 .616 r
.79694 .40584 .80386 .43005 .82018 .46443 .81269 .43468 Metetra
0 .049 .574 r
.81269 .43468 .82018 .46443 .83738 .50419 .82959 .47232 Metetra
0 .053 .573 r
.82959 .47232 .83738 .50419 .85484 .54223 .84712 .51231 Metetra
.031 .102 .605 r
.84712 .51231 .85484 .54223 .87179 .57125 .86457 .54728 Metetra
.154 .218 .678 r
.86457 .54728 .87179 .57125 .88746 .5851 .88115 .57022 Metetra
.42 .477 .813 r
.88115 .57022 .88746 .5851 .90129 .58032 .89616 .576 Metetra
.871 .906 .852 r
.89616 .576 .90129 .58032 .91305 .55701 .90914 .56267 Metetra
.869 .871 .428 r
.90914 .56267 .91305 .55701 .92295 .51885 .92007 .532 Metetra
.696 .69 .153 r
.92007 .532 .92295 .51885 .93156 .47209 .92934 .48899 Metetra
.826 .783 .812 r
.30783 .73258 .31512 .73821 .32719 .72295 .31978 .7205 Metetra
.923 .792 .698 r
.31978 .7205 .32719 .72295 .34007 .69194 .33262 .69198 Metetra
.949 .789 .65 r
.33262 .69198 .34007 .69194 .35335 .65029 .34595 .65168 Metetra
.958 .79 .632 r
.34595 .65168 .35335 .65029 .3666 .60474 .35935 .60619 Metetra
.96 .795 .633 r
.35935 .60619 .3666 .60474 .3795 .56229 .37243 .56256 Metetra
.954 .806 .658 r
.37243 .56256 .3795 .56229 .39183 .529 .38496 .5271 Metetra
.926 .825 .726 r
.38496 .5271 .39183 .529 .40352 .50924 .39683 .50456 Metetra
.764 .816 .894 r
.39683 .50456 .40352 .50924 .41461 .50532 .40807 .49763 Metetra
0 .172 .69 r
.40807 .49763 .41461 .50532 .42528 .51736 .41882 .50683 Metetra
.815 .401 0 r
.41882 .50683 .42528 .51736 .43573 .54322 .42929 .53045 Metetra
.897 .523 .066 r
.42929 .53045 .43573 .54322 .4462 .5787 .43972 .56462 Metetra
.909 .547 .094 r
.43972 .56462 .4462 .5787 .45691 .61781 .45035 .60364 Metetra
.886 .519 .044 r
.45035 .60364 .45691 .61781 .46801 .65355 .46136 .64059 Metetra
.783 .395 0 r
.46136 .64059 .46801 .65355 .47957 .67897 .47283 .66842 Metetra
0 .109 .659 r
.47283 .66842 .47957 .67897 .49152 .68869 .48475 .68132 Metetra
.7 .746 .887 r
.48475 .68132 .49152 .68869 .50373 .68013 .49697 .67611 Metetra
.917 .813 .728 r
.49697 .67611 .50373 .68013 .516 .6542 .50932 .65305 Metetra
.962 .81 .645 r
.50932 .65305 .516 .6542 .52816 .61511 .52159 .61583 Metetra
.976 .807 .609 r
.52159 .61583 .52816 .61511 .54009 .56928 .53367 .57057 Metetra
.98 .81 .6 r
.53367 .57057 .54009 .56928 .55178 .52388 .54549 .52444 Metetra
.978 .82 .618 r
.54549 .52444 .55178 .52388 .5633 .48557 .55712 .48428 Metetra
.961 .839 .676 r
.55712 .48428 .5633 .48557 .57481 .4595 .56869 .45559 Metetra
.876 .852 .816 r
.56869 .45559 .57481 .4595 .5865 .44888 .58039 .44194 Metetra
.332 .592 .94 r
.58039 .44194 .5865 .44888 .59856 .45467 .5924 .44473 Metetra
0 0 .449 r
.5924 .44473 .59856 .45467 .61114 .47563 .6049 .46312 Metetra
.751 .369 0 r
.6049 .46312 .61114 .47563 .6243 .50829 .61796 .49403 Metetra
.797 .432 0 r
.61796 .49403 .6243 .50829 .638 .54725 .63157 .53237 Metetra
.779 .419 0 r
.63157 .53237 .638 .54725 .65205 .58568 .64558 .57151 Metetra
.684 .322 0 r
.64558 .57151 .65205 .58568 .66615 .61631 .65972 .60414 Metetra
0 0 .562 r
.65972 .60414 .66615 .61631 .67994 .63284 .67363 .62366 Metetra
.45 .603 .911 r
.67363 .62366 .67994 .63284 .69307 .63136 .68694 .62561 Metetra
.884 .826 .785 r
.68694 .62561 .69307 .63136 .70531 .61138 .69942 .60882 Metetra
.972 .834 .648 r
.69942 .60882 .70531 .61138 .7166 .57597 .71096 .57576 Metetra
.991 .825 .58 r
.71096 .57576 .7166 .57597 .72714 .53096 .72169 .53186 Metetra
.996 .823 .553 r
.72169 .53186 .72714 .53096 .73726 .48356 .73194 .48421 Metetra
.996 .831 .561 r
.73194 .48421 .73726 .48356 .74741 .44087 .74213 .44004 Metetra
.989 .851 .612 r
.74213 .44004 .74741 .44087 .75808 .40879 .75274 .40557 Metetra
.944 .877 .74 r
.75274 .40557 .75808 .40879 .7697 .39139 .76422 .3852 Metetra
.658 .779 .938 r
.76422 .3852 .7697 .39139 .78259 .39053 .77691 .38123 Metetra
0 .231 .75 r
.77691 .38123 .78259 .39053 .79694 .40584 .79103 .3937 Metetra
0 0 .45 r
.79103 .3937 .79694 .40584 .81269 .43468 .80657 .42039 Metetra
0 0 .334 r
.80657 .42039 .81269 .43468 .82959 .47232 .82332 .45691 Metetra
0 0 .322 r
.82332 .45691 .82959 .47232 .84712 .51231 .84081 .49706 Metetra
0 0 .392 r
.84081 .49706 .84712 .51231 .86457 .54728 .85838 .53356 Metetra
0 0 .567 r
.85838 .53356 .86457 .54728 .88115 .57022 .87522 .5592 Metetra
.2 .409 .842 r
.87522 .5592 .88115 .57022 .89616 .576 .89062 .56837 Metetra
.788 .8 .862 r
.89062 .56837 .89616 .576 .90914 .56267 .90405 .55847 Metetra
.972 .862 .672 r
.90405 .55847 .90914 .56267 .92007 .532 .91541 .53059 Metetra
.999 .842 .546 r
.91541 .53059 .92007 .532 .92934 .48899 .925 .48923 Metetra
.848 .762 .768 r
.30052 .72623 .30783 .73258 .31978 .7205 .31275 .71024 Metetra
.87 .705 .675 r
.31275 .71024 .31978 .7205 .33262 .69198 .32584 .67857 Metetra
.871 .684 .646 r
.32584 .67857 .33262 .69198 .34595 .65168 .33936 .63644 Metetra
.869 .674 .637 r
.33936 .63644 .34595 .65168 .35935 .60619 .35286 .59065 Metetra
.863 .671 .641 r
.35286 .59065 .35935 .60619 .37243 .56256 .36597 .54823 Metetra
.851 .673 .66 r
.36597 .54823 .37243 .56256 .38496 .5271 .37846 .51519 Metetra
.82 .681 .711 r
.37846 .51519 .38496 .5271 .39683 .50456 .39025 .49586 Metetra
.655 .681 .863 r
.39025 .49586 .39683 .50456 .40807 .49763 .40138 .49248 Metetra
.704 .185 0 r
.40138 .49248 .40807 .49763 .41882 .50683 .41203 .50507 Metetra
.893 .497 .263 r
.41203 .50507 .41882 .50683 .42929 .53045 .4224 .53142 Metetra
.898 .539 .354 r
.4224 .53142 .42929 .53045 .43972 .56462 .43277 .56725 Metetra
.894 .543 .375 r
.43277 .56725 .43972 .56462 .45035 .60364 .44337 .60648 Metetra
.886 .526 .359 r
.44337 .60648 .45035 .60364 .46136 .64059 .45439 .64207 Metetra
.863 .463 .279 r
.45439 .64207 .46136 .64059 .47283 .66842 .46591 .66709 Metetra
.642 .083 0 r
.46591 .66709 .47283 .66842 .48475 .68132 .47789 .67618 Metetra
.799 .824 .871 r
.47789 .67618 .48475 .68132 .49697 .67611 .4902 .66686 Metetra
.88 .733 .695 r
.4902 .66686 .49697 .67611 .50932 .65305 .50263 .64021 Metetra
.887 .7 .644 r
.50263 .64021 .50932 .65305 .52159 .61583 .51499 .60055 Metetra
.885 .686 .627 r
.51499 .60055 .52159 .61583 .53367 .57057 .52715 .55437 Metetra
.88 .68 .627 r
.52715 .55437 .53367 .57057 .54549 .52444 .53905 .5089 Metetra
.87 .679 .641 r
.53905 .5089 .54549 .52444 .55712 .48428 .55077 .47076 Metetra
.847 .685 .681 r
.55077 .47076 .55712 .48428 .56869 .45559 .56243 .44507 Metetra
.764 .694 .785 r
.56243 .44507 .56869 .45559 .58039 .44194 .57422 .43494 Metetra
.042 .412 .861 r
.57422 .43494 .58039 .44194 .5924 .44473 .58633 .4413 Metetra
.843 .378 .025 r
.58633 .4413 .5924 .44473 .6049 .46312 .5989 .46278 Metetra
.898 .497 .238 r
.5989 .46278 .6049 .46312 .61796 .49403 .61202 .49586 Metetra
.901 .519 .293 r
.61202 .49586 .61796 .49403 .63157 .53237 .62565 .53503 Metetra
.895 .51 .293 r
.62565 .53503 .63157 .53237 .64558 .57151 .63964 .57342 Metetra
.875 .463 .237 r
.63964 .57342 .64558 .57151 .65972 .60414 .6537 .60373 Metetra
.77 .265 0 r
.6537 .60373 .65972 .60414 .67363 .62366 .66748 .61969 Metetra
.527 .817 .999 r
.66748 .61969 .67363 .62366 .68694 .62561 .68066 .61747 Metetra
.883 .775 .737 r
.68066 .61747 .68694 .62561 .69942 .60882 .69299 .59672 Metetra
.903 .722 .647 r
.69299 .59672 .69942 .60882 .71096 .57576 .70445 .56065 Metetra
.904 .7 .617 r
.70445 .56065 .71096 .57576 .72169 .53186 .71517 .51519 Metetra
.9 .69 .61 r
.71517 .51519 .72169 .53186 .73194 .48421 .7255 .4676 Metetra
.892 .688 .62 r
.7255 .4676 .73194 .48421 .74213 .44004 .73586 .42499 Metetra
.873 .691 .653 r
.73586 .42499 .74213 .44004 .75274 .40557 .74672 .39322 Metetra
.82 .7 .732 r
.74672 .39322 .75274 .40557 .76422 .3852 .7585 .37628 Metetra
.542 .647 .903 r
.7585 .37628 .76422 .3852 .77691 .38123 .77151 .37597 Metetra
.571 .07 0 r
.77151 .37597 .77691 .38123 .79103 .3937 .78592 .39183 Metetra
.856 .402 .04 r
.78592 .39183 .79103 .3937 .80657 .42039 .80171 .42114 Metetra
.891 .468 .163 r
.80171 .42114 .80657 .42039 .82332 .45691 .8186 .45908 Metetra
.892 .475 .189 r
.8186 .45908 .82332 .45691 .84081 .49706 .83611 .49912 Metetra
.874 .44 .154 r
.83611 .49912 .84081 .49706 .85838 .53356 .85353 .53387 Metetra
.801 .308 0 r
.85353 .53387 .85838 .53356 .87522 .5592 .87009 .55631 Metetra
0 .432 .782 r
.87009 .55631 .87522 .5592 .89062 .56837 .8851 .56139 Metetra
.856 .831 .821 r
.8851 .56139 .89062 .56837 .90405 .55847 .89813 .54727 Metetra
.919 .754 .66 r
.89813 .54727 .90405 .55847 .91541 .53059 .90916 .51586 Metetra
.925 .719 .606 r
.90916 .51586 .91541 .53059 .925 .48923 .91856 .47229 Metetra
.846 .694 .693 r
.29349 .71488 .30052 .72623 .31275 .71024 .30636 .68915 Metetra
.828 .638 .646 r
.30636 .68915 .31275 .71024 .32584 .67857 .3199 .65051 Metetra
.815 .614 .63 r
.3199 .65051 .32584 .67857 .33936 .63644 .33364 .60529 Metetra
.804 .601 .627 r
.33364 .60529 .33936 .63644 .35286 .59065 .34712 .56059 Metetra
.791 .594 .634 r
.34712 .56059 .35286 .59065 .36597 .54823 .36002 .52297 Metetra
.77 .59 .656 r
.36002 .52297 .36597 .54823 .37846 .51519 .3722 .49752 Metetra
.713 .591 .718 r
.3722 .49752 .37846 .51519 .39025 .49586 .38362 .48737 Metetra
.101 .405 .857 r
.38362 .48737 .39025 .49586 .40138 .49248 .3944 .49348 Metetra
.853 .448 .27 r
.3944 .49348 .40138 .49248 .41203 .50507 .40475 .51455 Metetra
.838 .499 .413 r
.40475 .51455 .41203 .50507 .4224 .53142 .41495 .54712 Metetra
.822 .501 .447 r
.41495 .54712 .4224 .53142 .43277 .56725 .42525 .58581 Metetra
.807 .489 .452 r
.42525 .58581 .43277 .56725 .44337 .60648 .43592 .62383 Metetra
.786 .459 .434 r
.43592 .62383 .44337 .60648 .45439 .64207 .44709 .65403 Metetra
.737 .37 .358 r
.44709 .65403 .45439 .64207 .46591 .66709 .45882 .67021 Metetra
.119 0 0 r
.45882 .67021 .46591 .66709 .47789 .67618 .47101 .66859 Metetra
.868 .759 .74 r
.47101 .66859 .47789 .67618 .4902 .66686 .48348 .64872 Metetra
.844 .659 .652 r
.48348 .64872 .4902 .66686 .50263 .64021 .49603 .61368 Metetra
.829 .624 .626 r
.49603 .61368 .50263 .64021 .51499 .60055 .50845 .56926 Metetra
.816 .607 .619 r
.50845 .56926 .51499 .60055 .52715 .55437 .52063 .52255 Metetra
.803 .597 .623 r
.52063 .52255 .52715 .55437 .53905 .5089 .53257 .48057 Metetra
.785 .592 .639 r
.53257 .48057 .53905 .5089 .55077 .47076 .54435 .44917 Metetra
.746 .591 .683 r
.54435 .44917 .55077 .47076 .56243 .44507 .55612 .43232 Metetra
.569 .575 .82 r
.55612 .43232 .56243 .44507 .57422 .43494 .56807 .43187 Metetra
.766 .257 0 r
.56807 .43187 .57422 .43494 .58633 .4413 .58036 .44739 Metetra
.849 .465 .321 r
.58036 .44739 .58633 .4413 .5989 .46278 .59312 .47625 Metetra
.834 .486 .396 r
.59312 .47625 .5989 .46278 .61202 .49586 .60639 .5137 Metetra
.818 .48 .416 r
.60639 .5137 .61202 .49586 .62565 .53503 .62009 .55334 Metetra
.799 .458 .409 r
.62009 .55334 .62565 .53503 .63964 .57342 .63401 .58789 Metetra
.763 .398 .363 r
.63401 .58789 .63964 .57342 .6537 .60373 .64785 .61045 Metetra
.587 .117 .106 r
.64785 .61045 .6537 .60373 .66748 .61969 .66129 .61601 Metetra
.871 .89 .845 r
.66129 .61601 .66748 .61969 .68066 .61747 .67403 .60271 Metetra
.866 .694 .667 r
.67403 .60271 .68066 .61747 .69299 .59672 .68595 .57233 Metetra
.845 .639 .624 r
.68595 .57233 .69299 .59672 .70445 .56065 .69711 .52984 Metetra
.831 .615 .61 r
.69711 .52984 .70445 .56065 .71517 .51519 .70773 .48215 Metetra
.817 .601 .611 r
.70773 .48215 .71517 .51519 .7255 .4676 .71819 .43659 Metetra
.8 .594 .624 r
.71819 .43659 .7255 .4676 .73586 .42499 .72892 .39967 Metetra
.77 .592 .657 r
.72892 .39967 .73586 .42499 .74672 .39322 .74036 .37619 Metetra
.682 .59 .746 r
.74036 .37619 .74672 .39322 .7585 .37628 .75285 .36889 Metetra
0 .311 .8 r
.75285 .36889 .7585 .37628 .77151 .37597 .76662 .37825 Metetra
.838 .384 .135 r
.76662 .37825 .77151 .37597 .78592 .39183 .78176 .40246 Metetra
.844 .456 .314 r
.78176 .40246 .78592 .39183 .80171 .42114 .79809 .43756 Metetra
.829 .463 .361 r
.79809 .43756 .80171 .42114 .8186 .45908 .81526 .47764 Metetra
.811 .448 .369 r
.81526 .47764 .8186 .45908 .83611 .49912 .83266 .51553 Metetra
.781 .404 .343 r
.83266 .51553 .83611 .49912 .85353 .53387 .84956 .54385 Metetra
.691 .258 .217 r
.84956 .54385 .85353 .53387 .87009 .55631 .86523 .55656 Metetra
.478 .897 .842 r
.86523 .55656 .87009 .55631 .8851 .56139 .87912 .55035 Metetra
.892 .754 .702 r
.87912 .55035 .8851 .56139 .89813 .54727 .89104 .52559 Metetra
.866 .662 .624 r
.89104 .52559 .89813 .54727 .90916 .51586 .90119 .4862 Metetra
.848 .625 .6 r
.90119 .4862 .90916 .51586 .91856 .47229 .91013 .43864 Metetra
.81 .619 .644 r
.28729 .69051 .29349 .71488 .30636 .68915 .30092 .65332 Metetra
.79 .586 .625 r
.30092 .65332 .30636 .68915 .3199 .65051 .31485 .60855 Metetra
.774 .568 .62 r
.31485 .60855 .3199 .65051 .33364 .60529 .32859 .56329 Metetra
.759 .556 .622 r
.32859 .56329 .33364 .60529 .34712 .56059 .34176 .52424 Metetra
.738 .548 .636 r
.34176 .52424 .34712 .56059 .36002 .52297 .35415 .49675 Metetra
.694 .54 .674 r
.35415 .49675 .36002 .52297 .3722 .49752 .36571 .48426 Metetra
.425 .483 .817 r
.36571 .48426 .3722 .49752 .38362 .48737 .37652 .48805 Metetra
.844 .427 .245 r
.37652 .48805 .38362 .48737 .3944 .49348 .3868 .50713 Metetra
.81 .481 .433 r
.3868 .50713 .3944 .49348 .40475 .51455 .39681 .53836 Metetra
.786 .48 .47 r
.39681 .53836 .40475 .51455 .41495 .54712 .40687 .57659 Metetra
.767 .467 .479 r
.40687 .57659 .41495 .54712 .42525 .58581 .41724 .61518 Metetra
.745 .442 .47 r
.41724 .61518 .42525 .58581 .43592 .62383 .42815 .64696 Metetra
.703 .383 .432 r
.42815 .64696 .43592 .62383 .44709 .65403 .43967 .66548 Metetra
.502 .098 .206 r
.43967 .66548 .44709 .65403 .45882 .67021 .45177 .66652 Metetra
.895 .838 .782 r
.45177 .66652 .45882 .67021 .47101 .66859 .46428 .64914 Metetra
.831 .648 .655 r
.46428 .64914 .47101 .66859 .48348 .64872 .47696 .61593 Metetra
.803 .597 .623 r
.47696 .61593 .48348 .64872 .49603 .61368 .4896 .57237 Metetra
.785 .573 .614 r
.4896 .57237 .49603 .61368 .50845 .56926 .50203 .52548 Metetra
.769 .559 .614 r
.50203 .52548 .50845 .56926 .52063 .52255 .51419 .48237 Metetra
.75 .549 .624 r
.51419 .48237 .52063 .52255 .53257 .48057 .52612 .4491 Metetra
.718 .542 .651 r
.52612 .4491 .53257 .48057 .54435 .44917 .53795 .42996 Metetra
.614 .53 .736 r
.53795 .42996 .54435 .44917 .55612 .43232 .54984 .4271 Metetra
.632 .112 0 r
.54984 .4271 .55612 .43232 .56807 .43187 .56198 .44043 Metetra
.826 .451 .345 r
.56198 .44043 .56807 .43187 .58036 .44739 .5745 .46763 Metetra
.798 .467 .428 r
.5745 .46763 .58036 .44739 .59312 .47625 .58748 .50423 Metetra
.777 .46 .451 r
.58748 .50423 .59312 .47625 .60639 .5137 .6009 .54403 Metetra
.756 .441 .452 r
.6009 .54403 .60639 .5137 .62009 .55334 .6146 .57979 Metetra
.722 .398 .43 r
.6146 .57979 .62009 .55334 .63401 .58789 .62832 .60446 Metetra
.628 .263 .331 r
.62832 .60446 .63401 .58789 .64785 .61045 .64176 .61267 Metetra
.69 .974 .783 r
.64176 .61267 .64785 .61045 .66129 .61601 .65464 .60203 Metetra
.863 .699 .678 r
.65464 .60203 .66129 .61601 .67403 .60271 .66679 .57383 Metetra
.821 .614 .623 r
.66679 .57383 .67403 .60271 .68595 .57233 .67822 .53263 Metetra
.798 .58 .607 r
.67822 .53263 .68595 .57233 .69711 .52984 .68911 .48516 Metetra
.78 .562 .604 r
.68911 .48516 .69711 .52984 .70773 .48215 .69978 .4388 Metetra
.761 .55 .612 r
.69978 .4388 .70773 .48215 .71819 .43659 .71061 .40024 Metetra
.734 .542 .633 r
.71061 .40024 .71819 .43659 .72892 .39967 .72202 .37457 Metetra
.674 .536 .689 r
.72202 .37457 .72892 .39967 .74036 .37619 .73435 .36483 Metetra
.277 .441 .844 r
.73435 .36483 .74036 .37619 .75285 .36889 .74787 .37183 Metetra
.824 .369 .145 r
.74787 .37183 .75285 .36889 .76662 .37825 .76267 .39411 Metetra
.811 .443 .361 r
.76267 .39411 .76662 .37825 .78176 .40246 .77865 .42798 Metetra
.788 .447 .41 r
.77865 .42798 .78176 .40246 .79809 .43756 .7955 .4678 Metetra
.766 .434 .424 r
.7955 .4678 .79809 .43756 .81526 .47764 .81268 .50649 Metetra
.737 .402 .414 r
.81268 .50649 .81526 .47764 .83266 .51553 .82952 .53663 Metetra
.676 .319 .362 r
.82952 .53663 .83266 .51553 .84956 .54385 .8453 .55187 Metetra
.291 0 0 r
.8453 .55187 .84956 .54385 .86523 .55656 .85946 .54844 Metetra
.91 .804 .73 r
.85946 .54844 .86523 .55656 .87912 .55035 .87174 .52615 Metetra
.845 .642 .628 r
.87174 .52615 .87912 .55035 .89104 .52559 .88228 .48845 Metetra
.814 .591 .601 r
.88228 .48845 .89104 .52559 .90119 .4862 .89155 .44155 Metetra
.792 .566 .594 r
.89155 .44155 .90119 .4862 .91013 .43864 .90031 .39288 Metetra
.779 .575 .623 r
.28217 .65103 .28729 .69051 .30092 .65332 .2963 .60626 Metetra
.762 .555 .617 r
.2963 .60626 .30092 .65332 .31485 .60855 .31026 .5609 Metetra
.746 .542 .618 r
.31026 .5609 .31485 .60855 .32859 .56329 .32362 .52167 Metetra
.725 .531 .629 r
.32362 .52167 .32859 .56329 .34176 .52424 .33614 .49395 Metetra
.683 .521 .661 r
.33614 .49395 .34176 .52424 .35415 .49675 .34774 .48122 Metetra
.458 .47 .783 r
.34774 .48122 .35415 .49675 .36571 .48426 .35851 .48476 Metetra
.844 .427 .242 r
.35851 .48476 .36571 .48426 .37652 .48805 .36865 .50364 Metetra
.799 .475 .441 r
.36865 .50364 .37652 .48805 .3868 .50713 .37845 .53475 Metetra
.772 .472 .478 r
.37845 .53475 .3868 .50713 .39681 .53836 .38825 .57294 Metetra
.752 .458 .486 r
.38825 .57294 .39681 .53836 .40687 .57659 .39837 .61161 Metetra
.729 .434 .48 r
.39837 .61161 .40687 .57659 .41724 .61518 .40905 .64356 Metetra
.688 .38 .448 r
.40905 .64356 .41724 .61518 .42815 .64696 .42043 .66232 Metetra
.524 .156 .283 r
.42043 .66232 .42815 .64696 .43967 .66548 .43247 .66362 Metetra
.91 .88 .792 r
.43247 .66362 .43967 .66548 .45177 .66652 .44503 .64647 Metetra
.828 .644 .654 r
.44503 .64647 .45177 .66652 .46428 .64914 .45786 .61341 Metetra
.793 .586 .622 r
.45786 .61341 .46428 .64914 .47696 .61593 .4707 .5699 Metetra
.772 .56 .611 r
.4707 .5699 .47696 .61593 .4896 .57237 .48336 .52295 Metetra
.755 .544 .61 r
.48336 .52295 .4896 .57237 .50203 .52548 .49572 .47969 Metetra
.736 .533 .618 r
.49572 .47969 .50203 .52548 .51419 .48237 .5078 .4462 Metetra
.704 .523 .641 r
.5078 .4462 .51419 .48237 .52612 .4491 .5197 .42681 Metetra
.611 .508 .713 r
.5197 .42681 .52612 .4491 .53795 .42996 .53157 .42369 Metetra
.57 .066 0 r
.53157 .42369 .53795 .42996 .54984 .4271 .54359 .4368 Metetra
.818 .449 .357 r
.54359 .4368 .54984 .4271 .56198 .44043 .55592 .46383 Metetra
.784 .46 .44 r
.55592 .46383 .56198 .44043 .5745 .46763 .56865 .50036 Metetra
.761 .452 .462 r
.56865 .50036 .5745 .46763 .58748 .50423 .5818 .54019 Metetra
.739 .433 .464 r
.5818 .54019 .58748 .50423 .6009 .54403 .59526 .57609 Metetra
.706 .393 .446 r
.59526 .57609 .6009 .54403 .6146 .57979 .6088 .60098 Metetra
.621 .279 .37 r
.6088 .60098 .6146 .57979 .62832 .60446 .62216 .60945 Metetra
.62216 .60945 .62832 .60446 .64176 .61267 .63507 .59907 Metetra
.865 .703 .68 r
.63507 .59907 .64176 .61267 .65464 .60203 .64735 .57105 Metetra
.811 .604 .622 r
.64735 .57105 .65464 .60203 .66679 .57383 .65898 .52994 Metetra
.785 .567 .605 r
.65898 .52994 .66679 .57383 .67822 .53263 .6701 .48245 Metetra
.765 .547 .602 r
.6701 .48245 .67822 .53263 .68911 .48516 .68098 .43598 Metetra
.746 .534 .607 r
.68098 .43598 .68911 .48516 .69978 .4388 .69199 .39721 Metetra
.719 .524 .625 r
.69199 .39721 .69978 .4388 .71061 .40024 .70349 .37129 Metetra
.664 .516 .673 r
.70349 .37129 .71061 .40024 .72202 .37457 .71583 .36129 Metetra
.334 .44 .821 r
.71583 .36129 .72202 .37457 .73435 .36483 .72925 .36805 Metetra
.823 .371 .156 r
.72925 .36805 .73435 .36483 .74787 .37183 .74387 .39013 Metetra
.798 .439 .378 r
.74387 .39013 .74787 .37183 .76267 .39411 .7596 .42389 Metetra
.771 .44 .426 r
.7596 .42389 .76267 .39411 .77865 .42798 .77618 .46369 Metetra
.748 .426 .439 r
.77618 .46369 .77865 .42798 .7955 .4678 .7931 .50248 Metetra
.719 .397 .433 r
.7931 .50248 .7955 .4678 .81268 .50649 .80974 .53281 Metetra
.662 .326 .392 r
.80974 .53281 .81268 .50649 .82952 .53663 .82541 .54831 Metetra
.38 0 .138 r
.82541 .54831 .82952 .53663 .8453 .55187 .83957 .54514 Metetra
.923 .83 .736 r
.83957 .54514 .8453 .55187 .85946 .54844 .85197 .52307 Metetra
.837 .634 .628 r
.85197 .52307 .85946 .54844 .87174 .52615 .86269 .48551 Metetra
.8 .578 .6 r
.86269 .48551 .87174 .52615 .88228 .48845 .8722 .43863 Metetra
.777 .551 .592 r
.8722 .43863 .88228 .48845 .89155 .44155 .8812 .38987 Metetra
.757 .535 .596 r
.8812 .38987 .89155 .44155 .90031 .39288 .89049 .34646 Metetra
.766 .559 .617 r
.27758 .60535 .28217 .65103 .2963 .60626 .29176 .5598 Metetra
.75 .546 .619 r
.29176 .5598 .2963 .60626 .31026 .5609 .30534 .52011 Metetra
.729 .536 .629 r
.30534 .52011 .31026 .5609 .32362 .52167 .31802 .49172 Metetra
.689 .526 .661 r
.31802 .49172 .32362 .52167 .33614 .49395 .3297 .47821 Metetra
.482 .482 .781 r
.3297 .47821 .33614 .49395 .34774 .48122 .34045 .48098 Metetra
.845 .419 .22 r
.34045 .48098 .34774 .48122 .35851 .48476 .35048 .49921 Metetra
.803 .476 .437 r
.35048 .49921 .35851 .48476 .36865 .50364 .36009 .52986 Metetra
.776 .474 .475 r
.36009 .52986 .36865 .50364 .37845 .53475 .36964 .56789 Metetra
.756 .461 .485 r
.36964 .56789 .37845 .53475 .38825 .57294 .37949 .60673 Metetra
.734 .437 .478 r
.37949 .60673 .38825 .57294 .39837 .61161 .38993 .63917 Metetra
.695 .384 .446 r
.38993 .63917 .39837 .61161 .40905 .64356 .40113 .65868 Metetra
.54 .169 .286 r
.40113 .65868 .40905 .64356 .42043 .66232 .4131 .66084 Metetra
.907 .892 .803 r
.4131 .66084 .42043 .66232 .43247 .66362 .42569 .64449 Metetra
.83 .649 .658 r
.42569 .64449 .43247 .66362 .44503 .64647 .43865 .61203 Metetra
.796 .591 .623 r
.43865 .61203 .44503 .64647 .45786 .61341 .4517 .5688 Metetra
.776 .564 .612 r
.4517 .5688 .45786 .61341 .4707 .5699 .46458 .52179 Metetra
.759 .548 .611 r
.46458 .52179 .4707 .5699 .48336 .52295 .47716 .47816 Metetra
.74 .537 .619 r
.47716 .47816 .48336 .52295 .49572 .47969 .48941 .44406 Metetra
.71 .528 .642 r
.48941 .44406 .49572 .47969 .5078 .4462 .50138 .42391 Metetra
.621 .515 .712 r
.50138 .42391 .5078 .4462 .5197 .42681 .51323 .42 Metetra
0 0 .496 r
.51323 .42 .5197 .42681 .53157 .42369 .52514 .43238 Metetra
.822 .448 .348 r
.52514 .43238 .53157 .42369 .54359 .4368 .53726 .45886 Metetra
.789 .462 .436 r
.53726 .45886 .54359 .4368 .55592 .46383 .54974 .49509 Metetra
.766 .455 .459 r
.54974 .49509 .55592 .46383 .56865 .50036 .56262 .53495 Metetra
.744 .436 .461 r
.56262 .53495 .56865 .50036 .5818 .54019 .57583 .57122 Metetra
.712 .397 .443 r
.57583 .57122 .5818 .54019 .59526 .57609 .58919 .59679 Metetra
.63 .285 .368 r
.58919 .59679 .59526 .57609 .6088 .60098 .60248 .6061 Metetra
.60248 .6061 .6088 .60098 .62216 .60945 .61543 .59658 Metetra
.867 .71 .685 r
.61543 .59658 .62216 .60945 .63507 .59907 .62785 .56927 Metetra
.815 .609 .624 r
.62785 .56927 .63507 .59907 .64735 .57105 .6397 .52858 Metetra
.789 .571 .606 r
.6397 .52858 .64735 .57105 .65898 .52994 .65106 .48117 Metetra
.77 .551 .602 r
.65106 .48117 .65898 .52994 .6701 .48245 .66217 .43443 Metetra
.751 .538 .608 r
.66217 .43443 .6701 .48245 .68098 .43598 .67334 .39513 Metetra
.725 .529 .625 r
.67334 .39513 .68098 .43598 .69199 .39721 .68492 .36848 Metetra
.671 .521 .672 r
.68492 .36848 .69199 .39721 .70349 .37129 .69724 .35768 Metetra
.366 .455 .82 r
.69724 .35768 .70349 .37129 .71583 .36129 .71053 .36366 Metetra
.821 .362 .131 r
.71053 .36366 .71583 .36129 .72925 .36805 .72493 .38509 Metetra
.802 .44 .371 r
.72493 .38509 .72925 .36805 .74387 .39013 .7404 .41843 Metetra
.776 .442 .422 r
.7404 .41843 .74387 .39013 .7596 .42389 .75668 .45812 Metetra
.753 .429 .435 r
.75668 .45812 .7596 .42389 .77618 .46369 .77335 .49715 Metetra
.725 .4 .429 r
.77335 .49715 .77618 .46369 .7931 .50248 .7898 .52806 Metetra
.67 .329 .388 r
.7898 .52806 .7931 .50248 .80974 .53281 .80541 .54437 Metetra
.4 0 .137 r
.80541 .54437 .80974 .53281 .82541 .54831 .81962 .54209 Metetra
.923 .841 .746 r
.81962 .54209 .82541 .54831 .83957 .54514 .83218 .52082 Metetra
.841 .64 .63 r
.83218 .52082 .83957 .54514 .85197 .52307 .84314 .48381 Metetra
.805 .583 .601 r
.84314 .48381 .85197 .52307 .86269 .48551 .85292 .43714 Metetra
.782 .555 .593 r
.85292 .43714 .86269 .48551 .8722 .43863 .86215 .38825 Metetra
.761 .539 .596 r
.86215 .38825 .8722 .43863 .8812 .38987 .87161 .34439 Metetra
.738 .529 .61 r
.87161 .34439 .8812 .38987 .89049 .34646 .88204 .31155 Metetra
.774 .571 .624 r
.27261 .56645 .27758 .60535 .29176 .5598 .28653 .52476 Metetra
.757 .563 .634 r
.28653 .52476 .29176 .5598 .30534 .52011 .29957 .49326 Metetra
.723 .557 .665 r
.29957 .49326 .30534 .52011 .31802 .49172 .31154 .47601 Metetra
.585 .541 .772 r
.31154 .47601 .31802 .49172 .3297 .47821 .32248 .47492 Metetra
.817 .337 .035 r
.32248 .47492 .3297 .47821 .34045 .48098 .33256 .4897 Metetra
.827 .482 .403 r
.33256 .4897 .34045 .48098 .35048 .49921 .34208 .51782 Metetra
.803 .489 .458 r
.34208 .51782 .35048 .49921 .36009 .52986 .35141 .55469 Metetra
.785 .48 .472 r
.35141 .55469 .36009 .52986 .36964 .56789 .36094 .59402 Metetra
.766 .459 .467 r
.36094 .59402 .36964 .56789 .37949 .60673 .37103 .62864 Metetra
.734 .412 .436 r
.37103 .62864 .37949 .60673 .38993 .63917 .3819 .65171 Metetra
.618 .233 .29 r
.3819 .65171 .38993 .63917 .40113 .65868 .39364 .6582 Metetra
.864 .948 .868 r
.39364 .6582 .40113 .65868 .4131 .66084 .40614 .64609 Metetra
.846 .679 .675 r
.40614 .64609 .4131 .66084 .42569 .64449 .41915 .61699 Metetra
.817 .616 .631 r
.41915 .61699 .42569 .64449 .43865 .61203 .43238 .57564 Metetra
.799 .589 .617 r
.43238 .57564 .43865 .61203 .4517 .5688 .44552 .52879 Metetra
.785 .574 .615 r
.44552 .52879 .4517 .5688 .46458 .52179 .45838 .48369 Metetra
.768 .564 .623 r
.45838 .48369 .46458 .52179 .47716 .47816 .47085 .44682 Metetra
.742 .558 .645 r
.47085 .44682 .47716 .47816 .48941 .44406 .48297 .42305 Metetra
.672 .552 .711 r
.48297 .42305 .48941 .44406 .50138 .42391 .49485 .4152 Metetra
0 .288 .787 r
.49485 .4152 .50138 .42391 .51323 .42 .50665 .42385 Metetra
.84 .435 .275 r
.50665 .42385 .51323 .42 .52514 .43238 .51858 .44733 Metetra
.816 .472 .406 r
.51858 .44733 .52514 .43238 .53726 .45886 .53077 .48179 Metetra
.796 .471 .439 r
.53077 .48179 .53726 .45886 .54974 .49509 .54334 .52145 Metetra
.776 .455 .444 r
.54334 .52145 .54974 .49509 .56262 .53495 .55628 .55927 Metetra
.749 .42 .426 r
.55628 .55927 .56262 .53495 .57583 .57122 .56946 .58796 Metetra
.683 .32 .351 r
.56946 .58796 .57583 .57122 .58919 .59679 .5827 .60147 Metetra
.5827 .60147 .58919 .59679 .60248 .6061 .59575 .59642 Metetra
.879 .748 .715 r
.59575 .59642 .60248 .6061 .61543 .59658 .6084 .57297 Metetra
.836 .638 .635 r
.6084 .57297 .61543 .59658 .62785 .56927 .62054 .53483 Metetra
.813 .599 .612 r
.62054 .53483 .62785 .56927 .6397 .52858 .6322 .48826 Metetra
.796 .578 .606 r
.6322 .48826 .6397 .52858 .65106 .48117 .64354 .44064 Metetra
.779 .566 .611 r
.64354 .44064 .65106 .48117 .66217 .43443 .65484 .39899 Metetra
.757 .559 .629 r
.65484 .39899 .66217 .43443 .67334 .39513 .66642 .36895 Metetra
.711 .554 .674 r
.66642 .36895 .67334 .39513 .68492 .36848 .67858 .35421 Metetra
.5 .524 .813 r
.67858 .35421 .68492 .36848 .69724 .35768 .69159 .35625 Metetra
.778 .273 0 r
.69159 .35625 .69724 .35768 .71053 .36366 .70562 .37429 Metetra
.828 .44 .317 r
.70562 .37429 .71053 .36366 .72493 .38509 .72068 .40527 Metetra
.807 .454 .389 r
.72068 .40527 .72493 .38509 .7404 .41843 .73659 .44408 Metetra
.787 .445 .409 r
.73659 .44408 .7404 .41843 .75668 .45812 .753 .48397 Metetra
.762 .419 .404 r
.753 .48397 .75668 .45812 .77335 .49715 .76938 .51746 Metetra
.715 .352 .361 r
.76938 .51746 .77335 .49715 .7898 .52806 .78512 .5377 Metetra
.5 .053 .12 r
.78512 .5377 .7898 .52806 .80541 .54437 .79966 .53997 Metetra
.909 .893 .802 r
.79966 .53997 .80541 .54437 .81962 .54209 .81268 .52297 Metetra
.862 .674 .646 r
.81268 .52297 .81962 .54209 .83218 .52082 .82413 .48915 Metetra
.831 .613 .607 r
.82413 .48915 .83218 .52082 .84314 .48381 .83432 .44404 Metetra
.81 .585 .596 r
.83432 .44404 .84314 .48381 .85292 .43714 .84383 .39492 Metetra
.792 .569 .598 r
.84383 .39492 .85292 .43714 .86215 .38825 .85336 .3492 Metetra
.771 .559 .612 r
.85336 .3492 .86215 .38825 .87161 .34439 .86365 .31327 Metetra
.736 .555 .648 r
.86365 .31327 .87161 .34439 .88204 .31155 .87533 .29166 Metetra
.812 .618 .641 r
.26663 .54181 .27261 .56645 .28653 .52476 .28032 .50401 Metetra
.791 .618 .666 r
.28032 .50401 .28653 .52476 .29957 .49326 .29298 .47848 Metetra
.73 .623 .74 r
.29298 .47848 .29957 .49326 .31154 .47601 .30451 .46836 Metetra
0 .357 .827 r
.30451 .46836 .31154 .47601 .32248 .47492 .315 .47458 Metetra
.863 .457 .261 r
.315 .47458 .32248 .47492 .33256 .4897 .3247 .49581 Metetra
.857 .512 .399 r
.3247 .49581 .33256 .4897 .34208 .51782 .33395 .52858 Metetra
.845 .518 .433 r
.33395 .52858 .34208 .51782 .35141 .55469 .34317 .56745 Metetra
.833 .507 .436 r
.34317 .56745 .35141 .55469 .36094 .59402 .35276 .60561 Metetra
.816 .474 .41 r
.35276 .60561 .36094 .59402 .37103 .62864 .36306 .63584 Metetra
.764 .368 .302 r
.36306 .63584 .37103 .62864 .3819 .65171 .37426 .65193 Metetra
.207 .734 .812 r
.37426 .65193 .3819 .65171 .39364 .6582 .38637 .65007 Metetra
.863 .75 .737 r
.38637 .65007 .39364 .6582 .40614 .64609 .3992 .62987 Metetra
.855 .673 .655 r
.3992 .62987 .40614 .64609 .41915 .61699 .41248 .59444 Metetra
.846 .644 .63 r
.41248 .59444 .41915 .61699 .43238 .57564 .42587 .54963 Metetra
.837 .63 .623 r
.42587 .54963 .43238 .57564 .44552 .52879 .43907 .5026 Metetra
.826 .623 .628 r
.43907 .5026 .44552 .52879 .45838 .48369 .45191 .4604 Metetra
.808 .62 .648 r
.45191 .4604 .45838 .48369 .47085 .44682 .46433 .42887 Metetra
.768 .623 .699 r
.46433 .42887 .47085 .44682 .48297 .42305 .47638 .41201 Metetra
.554 .603 .857 r
.47638 .41201 .48297 .42305 .49485 .4152 .4882 .41162 Metetra
.777 .274 0 r
.4882 .41162 .49485 .4152 .50665 .42385 .49998 .42729 Metetra
.866 .475 .299 r
.49998 .42729 .50665 .42385 .51858 .44733 .5119 .45632 Metetra
.857 .5 .374 r
.5119 .45632 .51858 .44733 .53077 .48179 .52411 .49397 Metetra
.846 .496 .392 r
.52411 .49397 .53077 .48179 .54334 .52145 .5367 .53376 Metetra
.829 .472 .38 r
.5367 .53376 .54334 .52145 .55628 .55927 .54964 .56837 Metetra
.793 .402 .313 r
.54964 .56837 .55628 .55927 .56946 .58796 .5628 .59088 Metetra
.54 0 0 r
.5628 .59088 .56946 .58796 .5827 .60147 .57596 .59625 Metetra
.858 .844 .83 r
.57596 .59625 .5827 .60147 .59575 .59642 .5889 .58263 Metetra
.873 .704 .67 r
.5889 .58263 .59575 .59642 .6084 .57297 .60143 .55186 Metetra
.862 .659 .627 r
.60143 .55186 .6084 .57297 .62054 .53483 .6135 .50897 Metetra
.852 .639 .613 r
.6135 .50897 .62054 .53483 .6322 .48826 .62516 .46092 Metetra
.841 .628 .615 r
.62516 .46092 .6322 .48826 .64354 .44064 .63661 .41509 Metetra
.825 .623 .63 r
.63661 .41509 .64354 .44064 .65484 .39899 .64812 .378 Metetra
.795 .624 .67 r
.64812 .378 .65484 .39899 .66642 .36895 .66001 .35446 Metetra
.695 .625 .774 r
.66001 .35446 .66642 .36895 .67858 .35421 .67255 .34719 Metetra
0 .263 .757 r
.67255 .34719 .67858 .35421 .69159 .35625 .68597 .35665 Metetra
.845 .387 .105 r
.68597 .35665 .69159 .35625 .70562 .37429 .70039 .38103 Metetra
.864 .466 .28 r
.70039 .38103 .70562 .37429 .72068 .40527 .71574 .4163 Metetra
.856 .476 .327 r
.71574 .4163 .72068 .40527 .73659 .44408 .73179 .45654 Metetra
.841 .46 .33 r
.73179 .45654 .73659 .44408 .753 .48397 .74813 .49452 Metetra
.812 .409 .287 r
.74813 .49452 .753 .48397 .76938 .51746 .7642 .52283 Metetra
.698 .211 .087 r
.7642 .52283 .76938 .51746 .78512 .5377 .77942 .53539 Metetra
.661 .938 .966 r
.77942 .53539 .78512 .5377 .79966 .53997 .79333 .52889 Metetra
.891 .754 .703 r
.79333 .52889 .79966 .53997 .81268 .52297 .80571 .50375 Metetra
.882 .681 .626 r
.80571 .50375 .81268 .52297 .82413 .48915 .81668 .46394 Metetra
.87 .65 .602 r
.81668 .46394 .82413 .48915 .83432 .44404 .82665 .41599 Metetra
.859 .635 .599 r
.82665 .41599 .83432 .44404 .84383 .39492 .83624 .36743 Metetra
.844 .628 .61 r
.83624 .36743 .84383 .39492 .85336 .3492 .84617 .32534 Metetra
.818 .627 .643 r
.84617 .32534 .85336 .3492 .86365 .31327 .85711 .29535 Metetra
.756 .629 .72 r
.85711 .29535 .86365 .31327 .87533 .29166 .86964 .28105 Metetra
.889 .714 .659 r
.25943 .53283 .26663 .54181 .28032 .50401 .27318 .49556 Metetra
.868 .725 .701 r
.27318 .49556 .28032 .50401 .29298 .47848 .28585 .47085 Metetra
.776 .74 .82 r
.28585 .47085 .29298 .47848 .30451 .46836 .29735 .46169 Metetra
0 .236 .717 r
.29735 .46169 .30451 .46836 .315 .47458 .30778 .46887 Metetra
.889 .463 .137 r
.30778 .46887 .315 .47458 .3247 .49581 .3174 .49096 Metetra
.924 .552 .292 r
.3174 .49096 .3247 .49581 .33395 .52858 .32657 .52432 Metetra
.927 .57 .328 r
.32657 .52432 .33395 .52858 .34317 .56745 .33572 .56341 Metetra
.925 .562 .317 r
.33572 .56341 .34317 .56745 .35276 .60561 .34527 .60134 Metetra
.909 .514 .241 r
.34527 .60134 .35276 .60561 .36306 .63584 .35557 .63091 Metetra
.772 .268 0 r
.35557 .63091 .36306 .63584 .37426 .65193 .3668 .64599 Metetra
.62 .775 .955 r
.3668 .64599 .37426 .65193 .38637 .65007 .37899 .64295 Metetra
.877 .765 .735 r
.37899 .64295 .38637 .65007 .3992 .62987 .39194 .62161 Metetra
.907 .738 .661 r
.39194 .62161 .3992 .62987 .41248 .59444 .40535 .58532 Metetra
.914 .726 .635 r
.40535 .58532 .41248 .59444 .42587 .54963 .41886 .54005 Metetra
.914 .722 .628 r
.41886 .54005 .42587 .54963 .43907 .5026 .43219 .493 Metetra
.91 .724 .639 r
.43219 .493 .43907 .5026 .45191 .4604 .44512 .45121 Metetra
.895 .732 .673 r
.44512 .45121 .45191 .4604 .46433 .42887 .45761 .42041 Metetra
.841 .747 .76 r
.45761 .42041 .46433 .42887 .47638 .41201 .4697 .40448 Metetra
.465 .654 .942 r
.4697 .40448 .47638 .41201 .4882 .41162 .48153 .40509 Metetra
.722 .232 0 r
.48153 .40509 .4882 .41162 .49998 .42729 .49329 .42168 Metetra
.898 .481 .127 r
.49329 .42168 .49998 .42729 .5119 .45632 .50518 .45143 Metetra
.922 .531 .214 r
.50518 .45143 .5119 .45632 .52411 .49397 .51735 .48945 Metetra
.923 .533 .222 r
.51735 .48945 .52411 .49397 .5367 .53376 .5299 .5292 Metetra
.906 .496 .166 r
.5299 .5292 .5367 .53376 .54964 .56837 .54281 .5633 Metetra
.815 .339 0 r
.54281 .5633 .54964 .56837 .5628 .59088 .55595 .5849 Metetra
.12 .527 .915 r
.55595 .5849 .5628 .59088 .57596 .59625 .56912 .58911 Metetra
.85 .798 .8 r
.56912 .58911 .57596 .59625 .5889 .58263 .5821 .57429 Metetra
.918 .762 .673 r
.5821 .57429 .5889 .58263 .60143 .55186 .59471 .54251 Metetra
.932 .744 .625 r
.59471 .54251 .60143 .55186 .6135 .50897 .60687 .49897 Metetra
.935 .736 .609 r
.60687 .49897 .6135 .50897 .62516 .46092 .61864 .45073 Metetra
.933 .736 .614 r
.61864 .45073 .62516 .46092 .63661 .41509 .63021 .40515 Metetra
.922 .743 .642 r
.63021 .40515 .63661 .41509 .64812 .378 .64183 .36868 Metetra
.886 .756 .713 r
.64183 .36868 .64812 .378 .66001 .35446 .65382 .34602 Metetra
.715 .741 .872 r
.65382 .34602 .66001 .35446 .67255 .34719 .66645 .33976 Metetra
0 .221 .728 r
.66645 .33976 .67255 .34719 .68597 .35665 .67994 .3502 Metetra
.78 .321 0 r
.67994 .3502 .68597 .35665 .70039 .38103 .6944 .37539 Metetra
.874 .447 .034 r
.6944 .37539 .70039 .38103 .71574 .4163 .70976 .4112 Metetra
.891 .473 .077 r
.70976 .4112 .71574 .4163 .73179 .45654 .7258 .45157 Metetra
.876 .447 .043 r
.7258 .45157 .73179 .45654 .74813 .49452 .7421 .48921 Metetra
.797 .331 0 r
.7421 .48921 .74813 .49452 .7642 .52283 .75812 .51674 Metetra
0 .179 .667 r
.75812 .51674 .7642 .52283 .77942 .53539 .77329 .52818 Metetra
.745 .808 .902 r
.77329 .52818 .77942 .53539 .79333 .52889 .78716 .52045 Metetra
.923 .794 .701 r
.78716 .52045 .79333 .52889 .80571 .50375 .79953 .49417 Metetra
.951 .767 .617 r
.79953 .49417 .80571 .50375 .81668 .46394 .81053 .45355 Metetra
.958 .753 .585 r
.81053 .45355 .81668 .46394 .82665 .41599 .82057 .40522 Metetra
.957 .75 .581 r
.82057 .40522 .82665 .41599 .83624 .36743 .83028 .35674 Metetra
.95 .755 .605 r
.83028 .35674 .83624 .36743 .84617 .32534 .84036 .31516 Metetra
.925 .768 .667 r
.84036 .31516 .84617 .32534 .85711 .29535 .85147 .28597 Metetra
.826 .772 .801 r
.85147 .28597 .85711 .29535 .86964 .28105 .86416 .27265 Metetra
.98 .846 .637 r
.2509 .53954 .25943 .53283 .27318 .49556 .26507 .49896 Metetra
.966 .863 .686 r
.26507 .49896 .27318 .49556 .28585 .47085 .2782 .46948 Metetra
.895 .879 .812 r
.2782 .46948 .28585 .47085 .29735 .46169 .29015 .45482 Metetra
.362 .623 .952 r
.29015 .45482 .29735 .46169 .30778 .46887 .30096 .45653 Metetra
0 0 .365 r
.30096 .45653 .30778 .46887 .3174 .49096 .31083 .4739 Metetra
.807 .461 0 r
.31083 .4739 .3174 .49096 .32657 .52432 .32011 .50404 Metetra
.845 .521 0 r
.32011 .50404 .32657 .52432 .33572 .56341 .32921 .54198 Metetra
.827 .511 0 r
.32921 .54198 .33572 .56341 .34527 .60134 .33857 .58118 Metetra
.741 .425 0 r
.33857 .58118 .34527 .60134 .35557 .63091 .34859 .6144 Metetra
0 0 .459 r
.34859 .6144 .35557 .63091 .3668 .64599 .35952 .63495 Metetra
.388 .533 .88 r
.35952 .63495 .3668 .64599 .37899 .64295 .37145 .6382 Metetra
.869 .823 .8 r
.37145 .6382 .37899 .64295 .39194 .62161 .38424 .62276 Metetra
.967 .851 .675 r
.38424 .62276 .39194 .62161 .40535 .58532 .39762 .59084 Metetra
.989 .849 .61 r
.39762 .59084 .40535 .58532 .41886 .54005 .41123 .54768 Metetra
.995 .85 .583 r
.41123 .54768 .41886 .54005 .43219 .493 .42474 .50027 Metetra
.995 .858 .586 r
.42474 .50027 .43219 .493 .44512 .45121 .43792 .45585 Metetra
.988 .875 .627 r
.43792 .45585 .44512 .45121 .45761 .42041 .45064 .4207 Metetra
.951 .901 .738 r
.45064 .4207 .45761 .42041 .4697 .40448 .46291 .39938 Metetra
.697 .821 .941 r
.46291 .39938 .4697 .40448 .48153 .40509 .47486 .39433 Metetra
0 .178 .714 r
.47486 .39433 .48153 .40509 .49329 .42168 .48666 .40573 Metetra
0 0 .352 r
.48666 .40573 .49329 .42168 .50518 .45143 .49852 .43152 Metetra
0 0 .228 r
.49852 .43152 .50518 .45143 .51735 .48945 .5106 .46747 Metetra
0 0 .217 r
.5106 .46747 .51735 .48945 .5299 .5292 .52304 .50751 Metetra
0 0 .288 r
.52304 .50751 .5299 .5292 .54281 .5633 .53586 .5444 Metetra
0 0 .47 r
.53586 .5444 .54281 .5633 .55595 .5849 .54898 .57093 Metetra
.13 .319 .786 r
.54898 .57093 .55595 .5849 .56912 .58911 .56223 .58135 Metetra
.761 .777 .866 r
.56223 .58135 .56912 .58911 .5821 .57429 .57536 .57285 Metetra
.962 .873 .701 r
.57536 .57285 .5821 .57429 .59471 .54251 .58818 .54624 Metetra
.995 .867 .585 r
.58818 .54624 .59471 .54251 .60687 .49897 .60057 .50581 Metetra
.996 .857 .527 r
.60057 .50581 .60687 .49897 .61864 .45073 .61254 .45816 Metetra
.993 .858 .513 r
.61254 .45816 .61864 .45073 .63021 .40515 .62424 .41076 Metetra
.991 .875 .543 r
.62424 .41076 .63021 .40515 .64183 .36868 .63589 .37048 Metetra
.981 .911 .646 r
.63589 .37048 .64183 .36868 .65382 .34602 .64779 .34268 Metetra
.861 .911 .864 r
.64779 .34268 .65382 .34602 .66645 .33976 .66024 .33067 Metetra
.269 .505 .897 r
.66024 .33067 .66645 .33976 .67994 .3502 .67348 .33557 Metetra
0 .024 .596 r
.67348 .33557 .67994 .3502 .6944 .37539 .68765 .35616 Metetra
0 0 .441 r
.68765 .35616 .6944 .37539 .70976 .4112 .70278 .38901 Metetra
0 0 .399 r
.70278 .38901 .70976 .4112 .7258 .45157 .71868 .42867 Metetra
0 0 .428 r
.71868 .42867 .7258 .45157 .7421 .48921 .73501 .46814 Metetra
0 0 .525 r
.73501 .46814 .7421 .48921 .75812 .51674 .75126 .49989 Metetra
.024 .204 .712 r
.75126 .49989 .75812 .51674 .77329 .52818 .76684 .51729 Metetra
.565 .643 .887 r
.76684 .51729 .77329 .52818 .78716 .52045 .78126 .5161 Metetra
.934 .886 .761 r
.78126 .5161 .78716 .52045 .79953 .49417 .79421 .49568 Metetra
.991 .883 .564 r
.79421 .49568 .79953 .49417 .81053 .45355 .80571 .45912 Metetra
.974 .849 .451 r
.80571 .45912 .81053 .45355 .82057 .40522 .81608 .4124 Metetra
.958 .833 .405 r
.81608 .4124 .82057 .40522 .83028 .35674 .82589 .36299 Metetra
.954 .844 .418 r
.82589 .36299 .83028 .35674 .84036 .31516 .83582 .31825 Metetra
.966 .89 .512 r
.83582 .31825 .84036 .31516 .85147 .28597 .84658 .28428 Metetra
.943 .953 .746 r
.84658 .28428 .85147 .28597 .86416 .27265 .85875 .26529 Metetra
.939 .887 .48 r
.24096 .56163 .2509 .53954 .26507 .49896 .2557 .51644 Metetra
.94 .906 .518 r
.2557 .51644 .26507 .49896 .2782 .46948 .26964 .47875 Metetra
.946 .951 .643 r
.26964 .47875 .2782 .46948 .29015 .45482 .28247 .45362 Metetra
.83 .926 .897 r
.28247 .45362 .29015 .45482 .30096 .45653 .2941 .44408 Metetra
.196 .373 .813 r
.2941 .44408 .30096 .45653 .31083 .4739 .30464 .45096 Metetra
0 0 .517 r
.30464 .45096 .31083 .4739 .32011 .50404 .31434 .47286 Metetra
0 0 .393 r
.31434 .47286 .32011 .50404 .32921 .54198 .32357 .50618 Metetra
0 0 .362 r
.32357 .50618 .32921 .54198 .33857 .58118 .33276 .54537 Metetra
0 0 .39 r
.33276 .54537 .33857 .58118 .34859 .6144 .34236 .58353 Metetra
0 0 .482 r
.34236 .58353 .34859 .6144 .35952 .63495 .35272 .61341 Metetra
.081 .18 .669 r
.35272 .61341 .35952 .63495 .37145 .6382 .36405 .62881 Metetra
.621 .683 .887 r
.36405 .62881 .37145 .6382 .38424 .62276 .37634 .62602 Metetra
.948 .948 .737 r
.37634 .62602 .38424 .62276 .39762 .59084 .38943 .60481 Metetra
.933 .905 .511 r
.38943 .60481 .39762 .59084 .41123 .54768 .40299 .56846 Metetra
.884 .851 .395 r
.40299 .56846 .41123 .54768 .42474 .50027 .41667 .52298 Metetra
.856 .827 .352 r
.41667 .52298 .42474 .50027 .43792 .45585 .43016 .4756 Metetra
.854 .839 .371 r
.43016 .4756 .43792 .45585 .45064 .4207 .44326 .43339 Metetra
.885 .898 .481 r
.44326 .43339 .45064 .4207 .46291 .39938 .4559 .40216 Metetra
.907 .983 .764 r
.4559 .40216 .46291 .39938 .47486 .39433 .46812 .38581 Metetra
.498 .644 .921 r
.46812 .38581 .47486 .39433 .48666 .40573 .48007 .38607 Metetra
.033 .159 .665 r
.48007 .38607 .48666 .40573 .49852 .43152 .49194 .40241 Metetra
0 0 .526 r
.49194 .40241 .49852 .43152 .5106 .46747 .50394 .43205 Metetra
0 0 .479 r
.50394 .43205 .5106 .46747 .52304 .50751 .51622 .4701 Metetra
0 0 .481 r
.51622 .4701 .52304 .50751 .53586 .5444 .52889 .51002 Metetra
0 0 .526 r
.52889 .51002 .53586 .5444 .54898 .57093 .54192 .54441 Metetra
.068 .14 .63 r
.54192 .54441 .54898 .57093 .56223 .58135 .5552 .56633 Metetra
.413 .48 .819 r
.5552 .56633 .56223 .58135 .57536 .57285 .56852 .57082 Metetra
.891 .93 .837 r
.56852 .57082 .57536 .57285 .58818 .54624 .58165 .55618 Metetra
.894 .901 .488 r
.58165 .55618 .58818 .54624 .60057 .50581 .59441 .52441 Metetra
.784 .782 .28 r
.59441 .52441 .60057 .50581 .61254 .45816 .60671 .48072 Metetra
.722 .723 .198 r
.60671 .48072 .61254 .45816 .62424 .41076 .61862 .43217 Metetra
.706 .716 .191 r
.61862 .43217 .62424 .41076 .63589 .37048 .63031 .3862 Metetra
.741 .772 .271 r
.63031 .3862 .63589 .37048 .64779 .34268 .64206 .34929 Metetra
.847 .924 .536 r
.64206 .34929 .64779 .34268 .66024 .33067 .65417 .32619 Metetra
.734 .873 .945 r
.65417 .32619 .66024 .33067 .67348 .33557 .66692 .31953 Metetra
.243 .349 .773 r
.66692 .31953 .67348 .33557 .68765 .35616 .68054 .32966 Metetra
.049 .125 .622 r
.68054 .32966 .68765 .35616 .70278 .38901 .69515 .35467 Metetra
0 .05 .563 r
.69515 .35467 .70278 .38901 .71868 .42867 .71068 .39044 Metetra
0 .037 .55 r
.71068 .39044 .71868 .42867 .73501 .46814 .72692 .43091 Metetra
.021 .066 .569 r
.72692 .43091 .73501 .46814 .75126 .49989 .74343 .46879 Metetra
.106 .15 .625 r
.74343 .46879 .75126 .49989 .76684 .51729 .75966 .49663 Metetra
.3 .348 .745 r
.75966 .49663 .76684 .51729 .78126 .5161 .77504 .50838 Metetra
.735 .796 .901 r
.77504 .50838 .78126 .5161 .79421 .49568 .7891 .50087 Metetra
.873 .921 .526 r
.7891 .50087 .79421 .49568 .80571 .45912 .80163 .47466 Metetra
.80163 .47466 .80571 .45912 .81608 .4124 .81276 .43394 Metetra
.81276 .43394 .81608 .4124 .82589 .36299 .8229 .38535 Metetra
.8229 .38535 .82589 .36299 .83582 .31825 .83269 .33651 Metetra
.83269 .33651 .83582 .31825 .84658 .28428 .84284 .29448 Metetra
.84284 .29448 .84658 .28428 .85875 .26529 .85404 .26484 Metetra
.737 .772 .273 r
.22992 .59396 .24096 .56163 .2557 .51644 .24503 .54746 Metetra
.732 .77 .271 r
.24503 .54746 .2557 .51644 .26964 .47875 .25978 .50252 Metetra
.768 .818 .343 r
.25978 .50252 .26964 .47875 .28247 .45362 .27369 .46563 Metetra
.861 .934 .558 r
.27369 .46563 .28247 .45362 .2941 .44408 .28648 .44168 Metetra
.796 .899 .915 r
.28648 .44168 .2941 .44408 .30464 .45096 .29808 .43354 Metetra
.269 .338 .749 r
.29808 .43354 .30464 .45096 .31434 .47286 .30861 .44183 Metetra
.019 .059 .562 r
.30861 .44183 .31434 .47286 .32357 .50618 .31834 .46495 Metetra
0 0 .485 r
.31834 .46495 .32357 .50618 .33276 .54537 .32765 .49909 Metetra
0 0 .463 r
.32765 .49909 .33276 .54537 .34236 .58353 .33697 .53857 Metetra
0 0 .479 r
.33697 .53857 .34236 .58353 .35272 .61341 .34674 .57637 Metetra
.008 .036 .539 r
.34674 .57637 .35272 .61341 .36405 .62881 .35728 .60525 Metetra
.194 .24 .683 r
.35728 .60525 .36405 .62881 .37634 .62602 .36879 .61916 Metetra
.673 .768 .922 r
.36879 .61916 .37634 .62602 .38943 .60481 .38126 .61465 Metetra
.842 .939 .571 r
.38126 .61465 .38943 .60481 .40299 .56846 .39447 .5918 Metetra
.67 .744 .246 r
.39447 .5918 .40299 .56846 .41667 .52298 .40812 .55422 Metetra
.40812 .55422 .41667 .52298 .43016 .4756 .42184 .50809 Metetra
.42184 .50809 .43016 .4756 .44326 .43339 .43534 .46071 Metetra
.43534 .46071 .44326 .43339 .4559 .40216 .44844 .41911 Metetra
.693 .785 .308 r
.44844 .41911 .4559 .40216 .46812 .38581 .46109 .38895 Metetra
.87 .994 .765 r
.46109 .38895 .46812 .38581 .48007 .38607 .47335 .37396 Metetra
.478 .55 .852 r
.47335 .37396 .48007 .38607 .49194 .40241 .48538 .37566 Metetra
.175 .201 .648 r
.48538 .37566 .49194 .40241 .50394 .43205 .49737 .39333 Metetra
.072 .08 .561 r
.49737 .39333 .50394 .43205 .51622 .4701 .50951 .42398 Metetra
.04 .04 .529 r
.50951 .42398 .51622 .4701 .52889 .51002 .52198 .46256 Metetra
.044 .043 .53 r
.52198 .46256 .52889 .51002 .54192 .54441 .53483 .50238 Metetra
.083 .085 .561 r
.53483 .50238 .54192 .54441 .5552 .56633 .54805 .53599 Metetra
.182 .198 .641 r
.54805 .53599 .5552 .56633 .56852 .57082 .56148 .55656 Metetra
.46 .52 .833 r
.56148 .55656 .56852 .57082 .58165 .55618 .5749 .55934 Metetra
.852 .992 .737 r
.5749 .55934 .58165 .55618 .59441 .52441 .58808 .54295 Metetra
.58808 .54295 .59441 .52441 .60671 .48072 .60085 .50973 Metetra
.60085 .50973 .60671 .48072 .61862 .43217 .61314 .46513 Metetra
0 0 .051 r
.61314 .46513 .61862 .43217 .63031 .3862 .62504 .41633 Metetra
0 0 .039 r
.62504 .41633 .63031 .3862 .64206 .34929 .63674 .37075 Metetra
.63674 .37075 .64206 .34929 .65417 .32619 .64854 .33476 Metetra
.705 .849 .424 r
.64854 .33476 .65417 .32619 .66692 .31953 .66075 .31294 Metetra
.689 .794 .93 r
.66075 .31294 .66692 .31953 .68054 .32966 .67367 .30773 Metetra
.31 .331 .721 r
.67367 .30773 .68054 .32966 .69515 .35467 .68751 .31928 Metetra
.185 .179 .618 r
.68751 .31928 .69515 .35467 .71068 .39044 .70236 .34546 Metetra
.143 .127 .579 r
.70236 .34546 .71068 .39044 .72692 .43091 .71816 .38196 Metetra
.136 .117 .57 r
.71816 .38196 .72692 .43091 .74343 .46879 .73465 .42259 Metetra
.155 .137 .584 r
.73465 .42259 .74343 .46879 .75966 .49663 .75137 .45994 Metetra
.209 .2 .629 r
.75137 .45994 .75966 .49663 .77504 .50838 .76774 .48661 Metetra
.354 .374 .743 r
.76774 .48661 .77504 .50838 .7891 .50087 .78316 .49672 Metetra
.783 .918 .929 r
.78316 .49672 .7891 .50087 .80163 .47466 .79719 .48739 Metetra
.79719 .48739 .80163 .47466 .81276 .43394 .80965 .45956 Metetra
0 0 .099 r
.80965 .45956 .81276 .43394 .8229 .38535 .82068 .41767 Metetra
0 0 .176 r
.82068 .41767 .8229 .38535 .83269 .33651 .83075 .36856 Metetra
0 0 .185 r
.83075 .36856 .83269 .33651 .84284 .29448 .84053 .31986 Metetra
0 0 .134 r
.84053 .31986 .84284 .29448 .85404 .26484 .85075 .27858 Metetra
.673 .746 .248 r
.21879 .62445 .22992 .59396 .24503 .54746 .23369 .58337 Metetra
.23369 .58337 .24503 .54746 .25978 .50252 .24886 .53668 Metetra
.24886 .53668 .25978 .50252 .27369 .46563 .26366 .4916 Metetra
.689 .764 .273 r
.26366 .4916 .27369 .46563 .28648 .44168 .27761 .45465 Metetra
.822 .915 .519 r
.27761 .45465 .28648 .44168 .29808 .43354 .29046 .4307 Metetra
.793 .887 .913 r
.29046 .4307 .29808 .43354 .30861 .44183 .30213 .42261 Metetra
.3 .338 .734 r
.30213 .42261 .30861 .44183 .31834 .46495 .31274 .431 Metetra
.08 .091 .569 r
.31274 .431 .31834 .46495 .32765 .49909 .32256 .45424 Metetra
.002 .002 .502 r
.32256 .45424 .32765 .49909 .33697 .53857 .33199 .48851 Metetra
0 0 .482 r
.33199 .48851 .33697 .53857 .34674 .57637 .34144 .52808 Metetra
0 0 .495 r
.34144 .52808 .34674 .57637 .35728 .60525 .35134 .56593 Metetra
.052 .061 .547 r
.35134 .56593 .35728 .60525 .36879 .61916 .36201 .59479 Metetra
.212 .248 .682 r
.36201 .59479 .36879 .61916 .38126 .61465 .37364 .60859 Metetra
.676 .796 .938 r
.37364 .60859 .38126 .61465 .39447 .5918 .38621 .60389 Metetra
.744 .881 .472 r
.38621 .60389 .39447 .5918 .40812 .55422 .3995 .58081 Metetra
.3995 .58081 .40812 .55422 .42184 .50809 .4132 .54298 Metetra
.4132 .54298 .42184 .50809 .43534 .46071 .42695 .49663 Metetra
.42695 .49663 .43534 .46071 .44844 .41911 .44048 .44909 Metetra
.44048 .44909 .44844 .41911 .46109 .38895 .45362 .40739 Metetra
.45362 .40739 .46109 .38895 .47335 .37396 .46631 .3772 Metetra
.863 .995 .761 r
.46631 .3772 .47335 .37396 .48538 .37566 .47864 .36224 Metetra
.486 .532 .83 r
.47864 .36224 .48538 .37566 .49737 .39333 .49077 .36403 Metetra
.215 .215 .643 r
.49077 .36403 .49737 .39333 .50951 .42398 .50288 .3818 Metetra
.122 .106 .566 r
.50288 .3818 .50951 .42398 .52198 .46256 .51518 .41257 Metetra
.091 .069 .538 r
.51518 .41257 .52198 .46256 .53483 .50238 .52782 .45126 Metetra
.091 .07 .538 r
.52782 .45126 .53483 .50238 .54805 .53599 .54085 .49114 Metetra
.121 .106 .565 r
.54085 .49114 .54805 .53599 .56148 .55656 .55424 .52475 Metetra
.205 .208 .64 r
.55424 .52475 .56148 .55656 .5749 .55934 .56782 .54524 Metetra
.462 .526 .838 r
.56782 .54524 .5749 .55934 .58808 .54295 .58137 .54786 Metetra
.777 .963 .657 r
.58137 .54786 .58808 .54295 .60085 .50973 .59463 .53124 Metetra
.59463 .53124 .60085 .50973 .61314 .46513 .60744 .49777 Metetra
0 0 .075 r
.60744 .49777 .61314 .46513 .62504 .41633 .61975 .45292 Metetra
0 0 .116 r
.61975 .45292 .62504 .41633 .63674 .37075 .63164 .40393 Metetra
0 0 .099 r
.63164 .40393 .63674 .37075 .64854 .33476 .64336 .35822 Metetra
.64336 .35822 .64854 .33476 .66075 .31294 .65519 .32217 Metetra
.656 .816 .382 r
.65519 .32217 .66075 .31294 .67367 .30773 .66746 .30036 Metetra
.685 .772 .917 r
.66746 .30036 .67367 .30773 .68751 .31928 .68048 .29521 Metetra
.333 .331 .708 r
.68048 .29521 .68751 .31928 .70236 .34546 .69447 .30685 Metetra
.22 .194 .615 r
.69447 .30685 .70236 .34546 .71816 .38196 .70951 .33314 Metetra
.181 .146 .58 r
.70951 .33314 .71816 .38196 .73465 .42259 .72554 .36976 Metetra
.173 .136 .572 r
.72554 .36976 .73465 .42259 .75137 .45994 .74226 .41046 Metetra
.186 .153 .585 r
.74226 .41046 .75137 .45994 .76774 .48661 .75921 .44783 Metetra
.231 .209 .627 r
.75921 .44783 .76774 .48661 .78316 .49672 .77579 .47444 Metetra
.36 .376 .741 r
.77579 .47444 .78316 .49672 .79719 .48739 .79137 .48441 Metetra
.775 .954 .931 r
.79137 .48441 .79719 .48739 .80965 .45956 .8055 .47487 Metetra
.8055 .47487 .80965 .45956 .82068 .41767 .81799 .44677 Metetra
0 0 .164 r
.81799 .44677 .82068 .41767 .83075 .36856 .82902 .40463 Metetra
0 0 .225 r
.82902 .40463 .83075 .36856 .84053 .31986 .83906 .3553 Metetra
0 0 .229 r
.83906 .3553 .84053 .31986 .85075 .27858 .84881 .30645 Metetra
.856 .908 .499 r
.20863 .64149 .21879 .62445 .23369 .58337 .22278 .61128 Metetra
.773 .811 .33 r
.22278 .61128 .23369 .58337 .24886 .53668 .2378 .56925 Metetra
.734 .769 .269 r
.2378 .56925 .24886 .53668 .26366 .4916 .25302 .52222 Metetra
.733 .772 .274 r
.25302 .52222 .26366 .4916 .27761 .45465 .26782 .47746 Metetra
.774 .825 .355 r
.26782 .47746 .27761 .45465 .29046 .4307 .28175 .44135 Metetra
.871 .948 .59 r
.28175 .44135 .29046 .4307 .30213 .42261 .29455 .41862 Metetra
.753 .854 .925 r
.29455 .41862 .30213 .42261 .31274 .431 .30619 .41195 Metetra
.233 .298 .725 r
.30619 .41195 .31274 .431 .32256 .45424 .3168 .42174 Metetra
.007 .046 .551 r
.3168 .42174 .32256 .45424 .33199 .48851 .32667 .44617 Metetra
0 0 .481 r
.32667 .44617 .33199 .48851 .34144 .52808 .33619 .48123 Metetra
0 0 .464 r
.33619 .48123 .34144 .52808 .35134 .56593 .34577 .52103 Metetra
0 0 .483 r
.34577 .52103 .35134 .56593 .36201 .59479 .35584 .55845 Metetra
.019 .048 .548 r
.35584 .55845 .36201 .59479 .37364 .60859 .36671 .58625 Metetra
.223 .273 .704 r
.36671 .58625 .37364 .60859 .38621 .60389 .37853 .59851 Metetra
.728 .828 .927 r
.37853 .59851 .38621 .60389 .3995 .58081 .39126 .59207 Metetra
.822 .917 .524 r
.39126 .59207 .3995 .58081 .4132 .54298 .40467 .56737 Metetra
.40467 .56737 .4132 .54298 .42695 .49663 .41844 .52834 Metetra
.41844 .52834 .42695 .49663 .44048 .44909 .43223 .4814 Metetra
.43223 .4814 .44048 .44909 .45362 .40739 .44578 .43393 Metetra
.44578 .43393 .45362 .40739 .46631 .3772 .45891 .39289 Metetra
.709 .804 .336 r
.45891 .39289 .46631 .3772 .47864 .36224 .47163 .36381 Metetra
.868 .993 .816 r
.47163 .36381 .47864 .36224 .49077 .36403 .48401 .35023 Metetra
.434 .5 .827 r
.48401 .35023 .49077 .36403 .50288 .3818 .49622 .35347 Metetra
.16 .184 .636 r
.49622 .35347 .50288 .3818 .51518 .41257 .50846 .37256 Metetra
.067 .074 .556 r
.50846 .37256 .51518 .41257 .52782 .45126 .52092 .40431 Metetra
.039 .04 .528 r
.52092 .40431 .52782 .45126 .54085 .49114 .53375 .44345 Metetra
.047 .045 .532 r
.53375 .44345 .54085 .49114 .55424 .52475 .54698 .48316 Metetra
.089 .092 .566 r
.54698 .48316 .55424 .52475 .56782 .54524 .56055 .51594 Metetra
.198 .216 .653 r
.56055 .51594 .56782 .54524 .58137 .54786 .57428 .53501 Metetra
.506 .574 .858 r
.57428 .53501 .58137 .54786 .59463 .53124 .58792 .53589 Metetra
.833 .973 .666 r
.58792 .53589 .59463 .53124 .60744 .49777 .60123 .51753 Metetra
.60123 .51753 .60744 .49777 .61975 .45292 .61404 .48264 Metetra
0 0 .008 r
.61404 .48264 .61975 .45292 .63164 .40393 .62633 .43693 Metetra
0 0 .053 r
.62633 .43693 .63164 .40393 .64336 .35822 .63821 .38776 Metetra
0 0 .035 r
.63821 .38776 .64336 .35822 .65519 .32217 .64994 .3425 Metetra
.64994 .3425 .65519 .32217 .66746 .30036 .66183 .30742 Metetra
.739 .888 .489 r
.66183 .30742 .66746 .30036 .68048 .29521 .67423 .28693 Metetra
.639 .731 .915 r
.67423 .28693 .68048 .29521 .69447 .30685 .68743 .28323 Metetra
.291 .308 .706 r
.68743 .28323 .69447 .30685 .70951 .33314 .70164 .29627 Metetra
.179 .172 .613 r
.70164 .29627 .70951 .33314 .72554 .36976 .71695 .32371 Metetra
.142 .125 .577 r
.71695 .32371 .72554 .36976 .74226 .41046 .73325 .36101 Metetra
.138 .118 .571 r
.73325 .36101 .74226 .41046 .75921 .44783 .75024 .4018 Metetra
.159 .141 .587 r
.75024 .4018 .75921 .44783 .77579 .47444 .7674 .43857 Metetra
.217 .21 .636 r
.7674 .43857 .77579 .47444 .79137 .48441 .7841 .46395 Metetra
.378 .404 .761 r
.7841 .46395 .79137 .48441 .8055 .47487 .79972 .47223 Metetra
.817 .968 .901 r
.79972 .47223 .8055 .47487 .81799 .44677 .81381 .46087 Metetra
.81381 .46087 .81799 .44677 .82902 .40463 .82621 .43116 Metetra
0 0 .112 r
.82621 .43116 .82902 .40463 .83906 .3553 .83713 .3879 Metetra
0 0 .179 r
.83713 .3879 .83906 .3553 .84881 .30645 .84711 .33811 Metetra
.933 .921 .777 r
.19969 .6436 .20863 .64149 .22278 .61128 .21296 .62433 Metetra
.971 .923 .605 r
.21296 .62433 .22278 .61128 .2378 .56925 .22754 .58955 Metetra
.954 .897 .512 r
.22754 .58955 .2378 .56925 .25302 .52222 .24279 .54497 Metetra
.939 .885 .476 r
.24279 .54497 .25302 .52222 .26782 .47746 .25802 .49773 Metetra
.935 .892 .487 r
.25802 .49773 .26782 .47746 .28175 .44135 .27266 .45496 Metetra
.943 .925 .563 r
.27266 .45496 .28175 .44135 .29455 .41862 .28632 .4226 Metetra
.927 .969 .759 r
.28632 .4226 .29455 .41862 .30619 .41195 .29881 .40475 Metetra
.558 .709 .942 r
.29881 .40475 .30619 .41195 .3168 .42174 .31016 .40336 Metetra
0 .111 .645 r
.31016 .40336 .3168 .42174 .32667 .44617 .32056 .41815 Metetra
0 0 .445 r
.32056 .41815 .32667 .44617 .33619 .48123 .33034 .44655 Metetra
0 0 .376 r
.33034 .44655 .33619 .48123 .34577 .52103 .33989 .4839 Metetra
0 0 .376 r
.33989 .4839 .34577 .52103 .35584 .55845 .34965 .52383 Metetra
0 0 .432 r
.34965 .52383 .35584 .55845 .36671 .58625 .36002 .559 Metetra
0 .026 .564 r
.36002 .559 .36671 .58625 .37853 .59851 .37126 .5824 Metetra
.326 .413 .798 r
.37126 .5824 .37853 .59851 .39126 .59207 .38346 .58885 Metetra
.856 .886 .858 r
.38346 .58885 .39126 .59207 .40467 .56737 .39652 .57626 Metetra
.953 .936 .604 r
.39652 .57626 .40467 .56737 .41844 .52834 .41016 .54628 Metetra
.901 .871 .434 r
.41016 .54628 .41844 .52834 .43223 .4814 .42404 .50379 Metetra
.861 .831 .358 r
.42404 .50379 .43223 .4814 .44578 .43393 .43785 .4557 Metetra
.846 .824 .346 r
.43785 .4557 .44578 .43393 .45891 .39289 .45133 .40943 Metetra
.861 .859 .406 r
.45133 .40943 .45891 .39289 .47163 .36381 .4644 .37157 Metetra
.907 .947 .594 r
.4644 .37157 .47163 .36381 .48401 .35023 .47706 .34707 Metetra
.785 .907 .925 r
.47706 .34707 .48401 .35023 .49622 .35347 .48943 .33878 Metetra
.218 .355 .789 r
.48943 .33878 .49622 .35347 .50846 .37256 .50171 .34728 Metetra
0 .05 .584 r
.50171 .34728 .50846 .37256 .52092 .40431 .51409 .37089 Metetra
0 0 .499 r
.51409 .37089 .52092 .40431 .53375 .44345 .52676 .40571 Metetra
0 0 .479 r
.52676 .40571 .53375 .44345 .54698 .48316 .53982 .44591 Metetra
0 0 .502 r
.53982 .44591 .54698 .48316 .56055 .51594 .55328 .48428 Metetra
0 .054 .572 r
.55328 .48428 .56055 .51594 .57428 .53501 .56703 .51338 Metetra
.209 .279 .716 r
.56703 .51338 .57428 .53501 .58792 .53589 .58086 .52698 Metetra
.682 .74 .895 r
.58086 .52698 .58792 .53589 .60123 .51753 .59451 .52158 Metetra
.937 .958 .655 r
.59451 .52158 .60123 .51753 .61404 .48264 .60775 .49735 Metetra
.826 .828 .353 r
.60775 .49735 .61404 .48264 .62633 .43693 .62045 .45812 Metetra
.738 .738 .218 r
.62045 .45812 .62633 .43693 .63821 .38776 .63263 .4103 Metetra
.7 .706 .177 r
.63263 .4103 .63821 .38776 .64994 .3425 .64448 .36144 Metetra
.708 .728 .21 r
.64448 .36144 .64994 .3425 .66183 .30742 .65627 .31869 Metetra
.781 .831 .365 r
.65627 .31869 .66183 .30742 .67423 .28693 .66834 .28779 Metetra
.878 .993 .779 r
.66834 .28779 .67423 .28693 .68743 .28323 .68104 .27245 Metetra
.456 .58 .89 r
.68104 .27245 .68743 .28323 .70164 .29627 .69463 .27419 Metetra
.126 .211 .683 r
.69463 .27419 .70164 .29627 .71695 .32371 .70931 .2922 Metetra
.017 .082 .588 r
.70931 .2922 .71695 .32371 .73325 .36101 .7251 .32341 Metetra
0 .043 .556 r
.7251 .32341 .73325 .36101 .75024 .4018 .74181 .36265 Metetra
.005 .051 .558 r
.74181 .36265 .75024 .4018 .7674 .43857 .75908 .40305 Metetra
.06 .103 .593 r
.75908 .40305 .7674 .43857 .7841 .46395 .77632 .43699 Metetra
.186 .23 .675 r
.77632 .43699 .7841 .46395 .79972 .47223 .79288 .45741 Metetra
.484 .538 .837 r
.79288 .45741 .79972 .47223 .81381 .46087 .80816 .45947 Metetra
.912 .974 .787 r
.80816 .45947 .81381 .46087 .82621 .43116 .82179 .44182 Metetra
.747 .787 .295 r
.82179 .44182 .82621 .43116 .83713 .3879 .83373 .40697 Metetra
.83373 .40697 .83713 .3879 .84711 .33811 .8443 .36061 Metetra
.838 .8 .815 r
.19135 .63809 .19969 .6436 .21296 .62433 .20414 .62483 Metetra
.946 .831 .699 r
.20414 .62483 .21296 .62433 .22754 .58955 .21844 .59464 Metetra
.974 .833 .643 r
.21844 .59464 .22754 .58955 .24279 .54497 .23365 .55247 Metetra
.983 .836 .62 r
.23365 .55247 .24279 .54497 .25802 .49773 .24907 .50516 Metetra
.984 .843 .621 r
.24907 .50516 .25802 .49773 .27266 .45496 .26408 .46002 Metetra
.978 .856 .65 r
.26408 .46002 .27266 .45496 .28632 .4226 .2782 .42347 Metetra
.948 .877 .732 r
.2782 .42347 .28632 .4226 .29881 .40475 .29117 .40032 Metetra
.76 .844 .915 r
.29117 .40032 .29881 .40475 .31016 .40336 .30294 .39327 Metetra
0 .186 .716 r
.30294 .39327 .31016 .40336 .32056 .41815 .31366 .40276 Metetra
.71 .347 0 r
.31366 .40276 .32056 .41815 .33034 .44655 .32361 .42702 Metetra
.81 .48 0 r
.32361 .42702 .33034 .44655 .33989 .4839 .33319 .46204 Metetra
.819 .503 0 r
.33319 .46204 .33989 .4839 .34965 .52383 .34283 .50196 Metetra
.773 .46 0 r
.34283 .50196 .34965 .52383 .36002 .559 .35296 .53963 Metetra
0 0 .292 r
.35296 .53963 .36002 .559 .37126 .5824 .3639 .56774 Metetra
0 .178 .709 r
.3639 .56774 .37126 .5824 .38346 .58885 .37581 .58031 Metetra
.709 .743 .878 r
.37581 .58031 .38346 .58885 .39652 .57626 .38866 .5741 Metetra
.938 .85 .729 r
.38866 .5741 .39652 .57626 .41016 .54628 .40222 .54949 Metetra
.984 .854 .632 r
.40222 .54949 .41016 .54628 .42404 .50379 .41616 .51038 Metetra
.995 .851 .585 r
.41616 .51038 .42404 .50379 .43785 .4557 .43013 .46319 Metetra
.996 .855 .572 r
.43013 .46319 .43785 .4557 .45133 .40943 .44385 .41536 Metetra
.994 .867 .592 r
.44385 .41536 .45133 .40943 .4644 .37157 .45715 .3739 Metetra
.979 .891 .664 r
.45715 .3739 .4644 .37157 .47706 .34707 .47002 .34438 Metetra
.887 .9 .833 r
.47002 .34438 .47706 .34707 .48943 .33878 .48253 .33038 Metetra
.325 .57 .928 r
.48253 .33038 .48943 .33878 .50171 .34728 .49487 .33327 Metetra
0 0 .528 r
.49487 .33327 .50171 .34728 .51409 .37089 .50723 .35212 Metetra
0 0 .307 r
.50723 .35212 .51409 .37089 .52676 .40571 .51981 .38376 Metetra
0 0 .246 r
.51981 .38376 .52676 .40571 .53982 .44591 .53276 .42295 Metetra
0 0 .272 r
.53276 .42295 .53982 .44591 .55328 .48428 .54612 .46285 Metetra
0 0 .384 r
.54612 .46285 .55328 .48428 .56703 .51338 .55983 .49591 Metetra
0 .068 .627 r
.55983 .49591 .56703 .51338 .58086 .52698 .57371 .51531 Metetra
.481 .589 .885 r
.57371 .51531 .58086 .52698 .59451 .52158 .58752 .51645 Metetra
.902 .856 .788 r
.58752 .51645 .59451 .52158 .60775 .49735 .60099 .49824 Metetra
.988 .876 .628 r
.60099 .49824 .60775 .49735 .62045 .45812 .61396 .46332 Metetra
.996 .862 .538 r
.61396 .46332 .62045 .45812 .63263 .4103 .62639 .41743 Metetra
.992 .855 .501 r
.62639 .41743 .63263 .4103 .64448 .36144 .63842 .36792 Metetra
.989 .863 .507 r
.63842 .36792 .64448 .36144 .65627 .31869 .65027 .32225 Metetra
.988 .891 .571 r
.65027 .32225 .65627 .31869 .66834 .28779 .66229 .28672 Metetra
.954 .931 .736 r
.66229 .28672 .66834 .28779 .68104 .27245 .6748 .26578 Metetra
.643 .786 .951 r
.6748 .26578 .68104 .27245 .69463 .27419 .68813 .26169 Metetra
0 .244 .754 r
.68813 .26169 .69463 .27419 .70931 .2922 .7025 .27443 Metetra
0 0 .526 r
.7025 .27443 .70931 .2922 .7251 .32341 .71798 .30169 Metetra
0 0 .438 r
.71798 .30169 .7251 .32341 .74181 .36265 .73447 .33896 Metetra
0 0 .431 r
.73447 .33896 .74181 .36265 .75908 .40305 .75167 .37986 Metetra
0 0 .486 r
.75167 .37986 .75908 .40305 .77632 .43699 .76906 .41688 Metetra
0 .063 .616 r
.76906 .41688 .77632 .43699 .79288 .45741 .786 .44256 Metetra
.273 .411 .819 r
.786 .44256 .79288 .45741 .80816 .45947 .80185 .45114 Metetra
.799 .813 .862 r
.80185 .45114 .80816 .45947 .82179 .44182 .81614 .43997 Metetra
.983 .901 .648 r
.81614 .43997 .82179 .44182 .83373 .40697 .8287 .4103 Metetra
.979 .863 .481 r
.8287 .4103 .83373 .40697 .8443 .36061 .83976 .3669 Metetra
.835 .773 .792 r
.18306 .63131 .19135 .63809 .20414 .62483 .19602 .61687 Metetra
.889 .736 .686 r
.19602 .61687 .20414 .62483 .21844 .59464 .2105 .58569 Metetra
.9 .721 .65 r
.2105 .58569 .21844 .59464 .23365 .55247 .22589 .54288 Metetra
.903 .715 .638 r
.22589 .54288 .23365 .55247 .24907 .50516 .24146 .49538 Metetra
.9 .715 .642 r
.24146 .49538 .24907 .50516 .26408 .46002 .25657 .45048 Metetra
.892 .72 .662 r
.25657 .45048 .26408 .46002 .2782 .42347 .27074 .41455 Metetra
.864 .732 .716 r
.27074 .41455 .2782 .42347 .29117 .40032 .28371 .39227 Metetra
.716 .737 .868 r
.28371 .39227 .29117 .40032 .30294 .39327 .29545 .38621 Metetra
.516 .005 0 r
.29545 .38621 .30294 .39327 .31366 .40276 .3061 .39668 Metetra
.897 .477 .147 r
.3061 .39668 .31366 .40276 .32361 .42702 .31596 .42175 Metetra
.925 .548 .271 r
.31596 .42175 .32361 .42702 .33319 .46204 .32545 .4573 Metetra
.928 .561 .298 r
.32545 .4573 .33319 .46204 .34283 .50196 .33502 .49735 Metetra
.923 .545 .274 r
.33502 .49735 .34283 .50196 .35296 .53963 .34511 .53468 Metetra
.894 .474 .164 r
.34511 .53468 .35296 .53963 .3639 .56774 .35605 .56203 Metetra
.589 .049 0 r
.35605 .56203 .3639 .56774 .37581 .58031 .36802 .57351 Metetra
.745 .796 .894 r
.36802 .57351 .37581 .58031 .38866 .5741 .38096 .56607 Metetra
.893 .763 .711 r
.38096 .56607 .38866 .5741 .40222 .54949 .39465 .54034 Metetra
.915 .739 .649 r
.39465 .54034 .40222 .54949 .41616 .51038 .40873 .50043 Metetra
.921 .729 .626 r
.40873 .50043 .41616 .51038 .43013 .46319 .42284 .45287 Metetra
.921 .727 .623 r
.42284 .45287 .43013 .46319 .44385 .41536 .43668 .40512 Metetra
.914 .73 .639 r
.43668 .40512 .44385 .41536 .45715 .3739 .45008 .36415 Metetra
.894 .74 .683 r
.45008 .36415 .45715 .3739 .47002 .34438 .46302 .33542 Metetra
.816 .753 .793 r
.46302 .33542 .47002 .34438 .48253 .33038 .47557 .3224 Metetra
.23 .53 .92 r
.47557 .3224 .48253 .33038 .49487 .33327 .48792 .32629 Metetra
.763 .287 0 r
.48792 .32629 .49487 .33327 .50723 .35212 .50026 .34604 Metetra
.895 .475 .104 r
.50026 .34604 .50723 .35212 .51981 .38376 .5128 .37835 Metetra
.916 .516 .175 r
.5128 .37835 .51981 .38376 .53276 .42295 .52571 .41784 Metetra
.914 .511 .17 r
.52571 .41784 .53276 .42295 .54612 .46285 .53902 .45759 Metetra
.885 .455 .088 r
.53902 .45759 .54612 .46285 .55983 .49591 .5527 .49003 Metetra
.713 .21 0 r
.5527 .49003 .55983 .49591 .57371 .51531 .56658 .50841 Metetra
.449 .705 .976 r
.56658 .50841 .57371 .51531 .58752 .51645 .5804 .50834 Metetra
.881 .795 .761 r
.5804 .50834 .58752 .51645 .60099 .49824 .59392 .48891 Metetra
.93 .763 .654 r
.59392 .48891 .60099 .49824 .61396 .46332 .60697 .45303 Metetra
.941 .747 .612 r
.60697 .45303 .61396 .46332 .62639 .41743 .61951 .40657 Metetra
.943 .741 .6 r
.61951 .40657 .62639 .41743 .63842 .36792 .63165 .35697 Metetra
.939 .742 .61 r
.63165 .35697 .63842 .36792 .65027 .32225 .64364 .31165 Metetra
.925 .751 .647 r
.64364 .31165 .65027 .32225 .66229 .28672 .65578 .27682 Metetra
.875 .764 .737 r
.65578 .27682 .66229 .28672 .6748 .26578 .66841 .25681 Metetra
.615 .709 .912 r
.66841 .25681 .6748 .26578 .68813 .26169 .68183 .25375 Metetra
0 .092 .621 r
.68183 .25375 .68813 .26169 .7025 .27443 .69626 .26745 Metetra
.774 .321 0 r
.69626 .26745 .7025 .27443 .71798 .30169 .71178 .29549 Metetra
.855 .424 0 r
.71178 .29549 .71798 .30169 .73447 .33896 .72829 .33321 Metetra
.867 .441 .013 r
.72829 .33321 .73447 .33896 .75167 .37986 .74547 .37415 Metetra
.839 .398 0 r
.74547 .37415 .75167 .37986 .76906 .41688 .76282 .41071 Metetra
.707 .228 0 r
.76282 .41071 .76906 .41688 .786 .44256 .77971 .4355 Metetra
.002 .417 .857 r
.77971 .4355 .786 .44256 .80185 .45114 .7955 .44289 Metetra
.82 .821 .85 r
.7955 .44289 .80185 .45114 .81614 .43997 .80974 .43045 Metetra
.94 .794 .672 r
.80974 .43045 .81614 .43997 .8287 .4103 .8223 .39968 Metetra
.962 .768 .597 r
.8223 .39968 .8287 .4103 .83976 .3669 .83339 .35553 Metetra
.855 .728 .721 r
.17496 .62195 .18306 .63131 .19602 .61687 .18876 .59947 Metetra
.848 .665 .655 r
.18876 .59947 .19602 .61687 .2105 .58569 .20388 .5622 Metetra
.839 .64 .633 r
.20388 .5622 .2105 .58569 .22589 .54288 .21962 .51628 Metetra
.831 .627 .627 r
.21962 .51628 .22589 .54288 .24146 .49538 .23525 .46899 Metetra
.821 .621 .633 r
.23525 .46899 .24146 .49538 .25657 .45048 .25015 .42735 Metetra
.803 .619 .653 r
.25015 .42735 .25657 .45048 .27074 .41455 .26392 .39704 Metetra
.759 .624 .71 r
.26392 .39704 .27074 .41455 .28371 .39227 .27639 .38183 Metetra
.449 .576 .89 r
.27639 .38183 .28371 .39227 .29545 .38621 .28759 .38328 Metetra
.838 .376 .095 r
.28759 .38328 .29545 .38621 .3061 .39668 .29776 .40069 Metetra
.863 .495 .349 r
.29776 .40069 .3061 .39668 .31596 .42175 .30726 .43113 Metetra
.853 .51 .403 r
.30726 .43113 .31596 .42175 .32545 .4573 .31656 .46957 Metetra
.841 .502 .413 r
.31656 .46957 .32545 .4573 .33502 .49735 .32613 .50937 Metetra
.825 .476 .395 r
.32613 .50937 .33502 .49735 .34511 .53468 .33642 .54311 Metetra
.786 .395 .314 r
.33642 .54311 .34511 .53468 .35605 .56203 .34773 .56392 Metetra
.401 0 0 r
.34773 .56392 .35605 .56203 .36802 .57351 .36013 .56704 Metetra
.86 .802 .793 r
.36013 .56704 .36802 .57351 .38096 .56607 .37351 .55103 Metetra
.864 .691 .666 r
.37351 .55103 .38096 .56607 .39465 .54034 .38755 .51816 Metetra
.854 .653 .63 r
.38755 .51816 .39465 .54034 .40873 .50043 .40187 .47381 Metetra
.845 .635 .618 r
.40187 .47381 .40873 .50043 .42284 .45287 .41608 .42515 Metetra
.835 .626 .62 r
.41608 .42515 .42284 .45287 .43668 .40512 .42991 .37958 Metetra
.82 .622 .636 r
.42991 .37958 .43668 .40512 .45008 .36415 .44324 .34348 Metetra
.788 .624 .678 r
.44324 .34348 .45008 .36415 .46302 .33542 .45607 .32147 Metetra
.666 .624 .797 r
.45607 .32147 .46302 .33542 .47557 .3224 .46852 .31601 Metetra
.485 0 0 r
.46852 .31601 .47557 .3224 .48792 .32629 .48079 .3273 Metetra
.861 .434 .204 r
.48079 .3273 .48792 .32629 .50026 .34604 .49309 .35325 Metetra
.863 .484 .326 r
.49309 .35325 .50026 .34604 .5128 .37835 .50562 .38958 Metetra
.853 .487 .358 r
.50562 .38958 .5128 .37835 .52571 .41784 .51854 .43015 Metetra
.838 .468 .353 r
.51854 .43015 .52571 .41784 .53902 .45759 .53189 .46757 Metetra
.807 .411 .301 r
.53189 .46757 .53902 .45759 .5527 .49003 .54557 .49444 Metetra
.666 .165 .045 r
.54557 .49444 .5527 .49003 .56658 .50841 .55941 .50487 Metetra
.776 .919 .933 r
.55941 .50487 .56658 .50841 .5804 .50834 .57315 .49593 Metetra
.881 .732 .692 r
.57315 .49593 .5804 .50834 .59392 .48891 .58658 .46847 Metetra
.872 .672 .629 r
.58658 .46847 .59392 .48891 .60697 .45303 .59956 .42689 Metetra
.862 .646 .608 r
.59956 .42689 .60697 .45303 .61951 .40657 .61209 .37797 Metetra
.851 .632 .605 r
.61209 .37797 .61951 .40657 .63165 .35697 .62431 .32933 Metetra
.837 .626 .617 r
.62431 .32933 .63165 .35697 .64364 .31165 .63649 .28799 Metetra
.811 .626 .651 r
.63649 .28799 .64364 .31165 .65578 .27682 .64891 .25936 Metetra
.742 .629 .735 r
.64891 .25936 .65578 .27682 .66841 .25681 .66191 .2468 Metetra
.291 .51 .895 r
.66191 .2468 .66841 .25681 .68183 .25375 .67575 .25141 Metetra
.776 .273 0 r
.67575 .25141 .68183 .25375 .69626 .26745 .69059 .272 Metetra
.86 .432 .199 r
.69059 .272 .69626 .26745 .71178 .29549 .70645 .30511 Metetra
.859 .457 .274 r
.70645 .30511 .71178 .29549 .72829 .33321 .72316 .3452 Metetra
.847 .448 .289 r
.72316 .3452 .72829 .33321 .74547 .37415 .74033 .38516 Metetra
.821 .406 .257 r
.74033 .38516 .74547 .37415 .76282 .41071 .75744 .4173 Metetra
.738 .261 .112 r
.75744 .4173 .76282 .41071 .77971 .4355 .77384 .4348 Metetra
.175 .709 .825 r
.77384 .4348 .77971 .4355 .7955 .44289 .78898 .43331 Metetra
.894 .8 .749 r
.78898 .43331 .7955 .44289 .80974 .43045 .80254 .41215 Metetra
.893 .7 .633 r
.80254 .41215 .80974 .43045 .8223 .39968 .81454 .3745 Metetra
.882 .66 .597 r
.81454 .3745 .8223 .39968 .83339 .35553 .82531 .32651 Metetra
.829 .648 .657 r
.16787 .60225 .17496 .62195 .18876 .59947 .18289 .56793 Metetra
.808 .605 .628 r
.18289 .56793 .18876 .59947 .20388 .5622 .19877 .52334 Metetra
.793 .583 .618 r
.19877 .52334 .20388 .5622 .21962 .51628 .21471 .47564 Metetra
.779 .57 .618 r
.21471 .47564 .21962 .51628 .23525 .46899 .23002 .43202 Metetra
.761 .562 .628 r
.23002 .43202 .23525 .46899 .25015 .42735 .24423 .39858 Metetra
.728 .556 .659 r
.24423 .39858 .25015 .42735 .26392 .39704 .25708 .37955 Metetra
.6 .542 .761 r
.25708 .37955 .26392 .39704 .27639 .38183 .26855 .37703 Metetra
.77 .263 0 r
.26855 .37703 .27639 .38183 .28759 .38328 .27883 .39086 Metetra
.831 .468 .367 r
.27883 .39086 .28759 .38328 .29776 .40069 .28827 .41862 Metetra
.807 .479 .433 r
.28827 .41862 .29776 .40069 .30726 .43113 .29734 .45576 Metetra
.789 .47 .45 r
.29734 .45576 .30726 .43113 .31656 .46957 .30657 .49593 Metetra
.769 .449 .445 r
.30657 .49593 .31656 .46957 .32613 .50937 .31643 .53178 Metetra
.735 .399 .411 r
.31643 .53178 .32613 .50937 .33642 .54311 .32732 .55619 Metetra
.617 .215 .259 r
.32732 .55619 .33642 .54311 .34773 .56392 .3394 .56374 Metetra
.838 .969 .885 r
.3394 .56374 .34773 .56392 .36013 .56704 .3526 .55214 Metetra
.853 .689 .678 r
.3526 .55214 .36013 .56704 .37351 .55103 .36665 .5228 Metetra
.823 .62 .628 r
.36665 .5228 .37351 .55103 .38755 .51816 .38113 .48049 Metetra
.805 .591 .612 r
.38113 .48049 .38755 .51816 .40187 .47381 .39562 .43209 Metetra
.79 .574 .608 r
.39562 .43209 .40187 .47381 .41608 .42515 .40978 .38509 Metetra
.773 .563 .616 r
.40978 .38509 .41608 .42515 .42991 .37958 .42341 .34621 Metetra
.746 .557 .639 r
.42341 .34621 .42991 .37958 .44324 .34348 .43646 .32053 Metetra
.678 .552 .704 r
.43646 .32053 .44324 .34348 .45607 .32147 .44901 .31104 Metetra
.076 .364 .832 r
.44901 .31104 .45607 .32147 .46852 .31601 .46122 .31847 Metetra
.837 .406 .209 r
.46122 .31847 .46852 .31601 .48079 .3273 .47334 .34128 Metetra
.82 .458 .371 r
.47334 .34128 .48079 .3273 .49309 .35325 .4856 .37568 Metetra
.8 .458 .41 r
.4856 .37568 .49309 .35325 .50562 .38958 .49817 .41591 Metetra
.779 .442 .416 r
.49817 .41591 .50562 .38958 .51854 .43015 .51118 .45479 Metetra
.751 .405 .397 r
.51118 .45479 .51854 .43015 .53189 .46757 .5246 .48478 Metetra
.681 .299 .317 r
.5246 .48478 .53189 .46757 .54557 .49444 .53832 .49949 Metetra
.004 0 0 r
.53832 .49949 .54557 .49444 .55941 .50487 .5521 .49516 Metetra
.887 .767 .725 r
.5521 .49516 .55941 .50487 .57315 .49593 .56571 .47174 Metetra
.844 .644 .633 r
.56571 .47174 .57315 .49593 .58658 .46847 .57898 .43287 Metetra
.82 .601 .606 r
.57898 .43287 .58658 .46847 .59956 .42689 .59183 .38492 Metetra
.803 .579 .598 r
.59183 .38492 .59956 .42689 .61209 .37797 .60434 .33548 Metetra
.785 .565 .603 r
.60434 .33548 .61209 .37797 .62431 .32933 .61671 .29179 Metetra
.762 .557 .621 r
.61671 .29179 .62431 .32933 .63649 .28799 .62918 .25972 Metetra
.716 .553 .667 r
.62918 .25972 .63649 .28799 .64891 .25936 .64208 .24316 Metetra
.525 .529 .802 r
.64208 .24316 .64891 .25936 .66191 .2468 .65567 .24373 Metetra
.712 .187 0 r
.65567 .24373 .66191 .2468 .67575 .25141 .67014 .26078 Metetra
.828 .415 .261 r
.67014 .26078 .67575 .25141 .69059 .272 .68557 .29137 Metetra
.81 .436 .349 r
.68557 .29137 .69059 .272 .70645 .30511 .70187 .33043 Metetra
.789 .429 .374 r
.70187 .33043 .70645 .30511 .72316 .3452 .71874 .37114 Metetra
.763 .401 .369 r
.71874 .37114 .72316 .3452 .74033 .38516 .7357 .40582 Metetra
.712 .329 .322 r
.7357 .40582 .74033 .38516 .75744 .4173 .75218 .42728 Metetra
.491 .024 .071 r
.75218 .42728 .75744 .4173 .77384 .4348 .76761 .43046 Metetra
.902 .92 .821 r
.76761 .43046 .77384 .4348 .78898 .43331 .78162 .41375 Metetra
.872 .685 .646 r
.78162 .41375 .78898 .43331 .80254 .41215 .79411 .37946 Metetra
.84 .616 .6 r
.79411 .37946 .80254 .41215 .81454 .3745 .80534 .33317 Metetra
.818 .585 .587 r
.80534 .33317 .81454 .3745 .82531 .32651 .81582 .28233 Metetra
.794 .589 .624 r
.16249 .56642 .16787 .60225 .18289 .56793 .17857 .5221 Metetra
.775 .563 .613 r
.17857 .5221 .18289 .56793 .19877 .52334 .19476 .47432 Metetra
.758 .547 .611 r
.19476 .47432 .19877 .52334 .21471 .47564 .21034 .43032 Metetra
.739 .536 .618 r
.21034 .43032 .21471 .47564 .23002 .43202 .22478 .39624 Metetra
.707 .526 .641 r
.22478 .39624 .23002 .43202 .24423 .39858 .23777 .37644 Metetra
.604 .508 .718 r
.23777 .37644 .24423 .39858 .25708 .37955 .24927 .37312 Metetra
.715 .204 0 r
.24927 .37312 .25708 .37955 .26855 .37703 .25948 .38622 Metetra
.819 .46 .377 r
.25948 .38622 .26855 .37703 .27883 .39086 .26874 .41343 Metetra
.787 .466 .445 r
.26874 .41343 .27883 .39086 .28827 .41862 .27755 .45027 Metetra
.765 .455 .462 r
.27755 .45027 .28827 .41862 .29734 .45576 .28647 .49049 Metetra
.743 .434 .459 r
.28647 .49049 .29734 .45576 .30657 .49593 .29603 .52674 Metetra
.709 .389 .435 r
.29603 .52674 .30657 .49593 .31643 .53178 .30667 .55183 Metetra
.613 .253 .335 r
.30667 .55183 .31643 .53178 .32732 .55619 .31859 .56025 Metetra
.673 .968 .774 r
.31859 .56025 .32732 .55619 .3394 .56374 .33177 .54952 Metetra
.855 .695 .683 r
.33177 .54952 .3394 .56374 .3526 .55214 .34591 .52089 Metetra
.81 .606 .626 r
.34591 .52089 .3526 .55214 .36665 .5228 .36059 .47898 Metetra
.787 .57 .608 r
.36059 .47898 .36665 .5228 .38113 .48049 .37534 .43064 Metetra
.769 .55 .603 r
.37534 .43064 .38113 .48049 .39562 .43209 .38977 .38336 Metetra
.75 .537 .607 r
.38977 .38336 .39562 .43209 .40978 .38509 .40362 .34392 Metetra
.723 .527 .625 r
.40362 .34392 .40978 .38509 .42341 .34621 .41681 .3175 Metetra
.664 .517 .674 r
.41681 .3175 .42341 .34621 .43646 .32053 .4294 .3072 Metetra
.24 .402 .824 r
.4294 .3072 .43646 .32053 .44901 .31104 .44154 .31384 Metetra
.831 .401 .214 r
.44154 .31384 .44901 .31104 .46122 .31847 .45347 .336 Metetra
.8 .447 .389 r
.45347 .336 .46122 .31847 .47334 .34128 .46546 .36999 Metetra
.775 .445 .428 r
.46546 .36999 .47334 .34128 .4856 .37568 .47773 .41012 Metetra
.752 .428 .436 r
.47773 .41012 .4856 .37568 .49817 .41591 .49042 .44926 Metetra
.723 .394 .423 r
.49042 .44926 .49817 .41591 .51118 .45479 .5036 .47984 Metetra
.661 .31 .368 r
.5036 .47984 .51118 .45479 .5246 .48478 .51716 .49537 Metetra
.282 0 0 r
.51716 .49537 .5246 .48478 .53832 .49949 .53092 .49195 Metetra
.902 .801 .739 r
.53092 .49195 .53832 .49949 .5521 .49516 .54464 .46933 Metetra
.834 .634 .632 r
.54464 .46933 .5521 .49516 .56571 .47174 .55811 .431 Metetra
.802 .581 .603 r
.55811 .431 .56571 .47174 .57898 .43287 .57123 .38325 Metetra
.78 .555 .594 r
.57123 .38325 .57898 .43287 .59183 .38492 .58402 .33365 Metetra
.761 .539 .596 r
.58402 .33365 .59183 .38492 .60434 .33548 .59661 .28949 Metetra
.737 .528 .61 r
.59661 .28949 .60434 .33548 .61671 .29179 .60923 .25674 Metetra
.695 .519 .646 r
.60923 .25674 .61671 .29179 .62918 .25972 .62216 .23936 Metetra
.548 .499 .753 r
.62216 .23936 .62918 .25972 .64208 .24316 .63566 .23911 Metetra
.677 .151 0 r
.63566 .23911 .64208 .24316 .65567 .24373 .64994 .25543 Metetra
.813 .41 .288 r
.64994 .25543 .65567 .24373 .67014 .26078 .6651 .2855 Metetra
.786 .426 .376 r
.6651 .2855 .67014 .26078 .68557 .29137 .68107 .32431 Metetra
.761 .417 .401 r
.68107 .32431 .68557 .29137 .70187 .33043 .69762 .36514 Metetra
.734 .391 .4 r
.69762 .36514 .70187 .33043 .71874 .37114 .71432 .40029 Metetra
.687 .333 .369 r
.71432 .40029 .71874 .37114 .7357 .40582 .73064 .42251 Metetra
.533 .13 .223 r
.73064 .42251 .7357 .40582 .75218 .42728 .74606 .4266 Metetra
.874 .992 .811 r
.74606 .4266 .75218 .42728 .76761 .43046 .76019 .41077 Metetra
.868 .683 .649 r
.76019 .41077 .76761 .43046 .78162 .41375 .77292 .37714 Metetra
.821 .597 .599 r
.77292 .37714 .78162 .41375 .79411 .37946 .78443 .33119 Metetra
.794 .561 .584 r
.78443 .33119 .79411 .37946 .80534 .33317 .7952 .28033 Metetra
.773 .541 .583 r
.7952 .28033 .80534 .33317 .81582 .28233 .80586 .23224 Metetra
.772 .56 .612 r
.15842 .51945 .16249 .56642 .17857 .5221 .17487 .47161 Metetra
.756 .544 .61 r
.17487 .47161 .17857 .5221 .19476 .47432 .19069 .42745 Metetra
.736 .532 .616 r
.19069 .42745 .19476 .47432 .21034 .43032 .2053 .39315 Metetra
.704 .522 .638 r
.2053 .39315 .21034 .43032 .22478 .39624 .21839 .3731 Metetra
.605 .502 .711 r
.21839 .3731 .22478 .39624 .23777 .37644 .2299 .36952 Metetra
.697 .188 0 r
.2299 .36952 .23777 .37644 .24927 .37312 .24 .38239 Metetra
.817 .459 .379 r
.24 .38239 .24927 .37312 .25948 .38622 .24906 .40943 Metetra
.784 .464 .447 r
.24906 .40943 .25948 .38622 .26874 .41343 .25759 .44619 Metetra
.761 .453 .463 r
.25759 .44619 .26874 .41343 .27755 .45027 .2662 .48643 Metetra
.739 .431 .461 r
.2662 .48643 .27755 .45027 .28647 .49049 .27548 .52282 Metetra
.705 .388 .438 r
.27548 .52282 .28647 .49049 .29603 .52674 .28589 .54813 Metetra
.613 .257 .343 r
.28589 .54813 .29603 .52674 .30667 .55183 .2977 .55682 Metetra
.606 .933 .721 r
.2977 .55682 .30667 .55183 .31859 .56025 .31087 .54635 Metetra
.856 .698 .685 r
.31087 .54635 .31859 .56025 .33177 .54952 .32513 .5179 Metetra
.809 .604 .626 r
.32513 .5179 .33177 .54952 .34591 .52089 .34002 .47609 Metetra
.784 .568 .607 r
.34002 .47609 .34591 .52089 .36059 .47898 .35503 .42773 Metetra
.765 .547 .602 r
.35503 .42773 .36059 .47898 .37534 .43064 .36971 .38032 Metetra
.746 .533 .606 r
.36971 .38032 .37534 .43064 .38977 .38336 .38378 .34069 Metetra
.72 .523 .622 r
.38378 .34069 .38977 .38336 .40362 .34392 .3971 .31402 Metetra
.662 .512 .669 r
.3971 .31402 .40362 .34392 .41681 .3175 .40971 .30344 Metetra
.266 .406 .817 r
.40971 .30344 .41681 .3175 .4294 .3072 .42177 .30984 Metetra
.831 .4 .213 r
.42177 .30984 .4294 .3072 .44154 .31384 .43352 .33179 Metetra
.798 .446 .391 r
.43352 .33179 .44154 .31384 .45347 .336 .44524 .36566 Metetra
.772 .443 .43 r
.44524 .36566 .45347 .336 .46546 .36999 .45719 .40578 Metetra
.748 .426 .438 r
.45719 .40578 .46546 .36999 .47773 .41012 .46959 .445 Metetra
.719 .393 .426 r
.46959 .445 .47773 .41012 .49042 .44926 .48251 .47578 Metetra
.658 .312 .374 r
.48251 .47578 .49042 .44926 .5036 .47984 .49591 .49156 Metetra
.312 0 .034 r
.49591 .49156 .5036 .47984 .51716 .49537 .50964 .48841 Metetra
.905 .81 .743 r
.50964 .48841 .51716 .49537 .53092 .49195 .52345 .46601 Metetra
.833 .633 .633 r
.52345 .46601 .53092 .49195 .54464 .46933 .53713 .42782 Metetra
.799 .578 .603 r
.53713 .42782 .54464 .46933 .55811 .431 .55051 .3801 Metetra
.777 .551 .593 r
.55051 .3801 .55811 .431 .57123 .38325 .56356 .33041 Metetra
.757 .535 .595 r
.56356 .33041 .57123 .38325 .58402 .33365 .57638 .28608 Metetra
.733 .523 .608 r
.57638 .28608 .58402 .33365 .59661 .28949 .58917 .25308 Metetra
.692 .514 .642 r
.58917 .25308 .59661 .28949 .60923 .25674 .60215 .23544 Metetra
.552 .494 .744 r
.60215 .23544 .60923 .25674 .62216 .23936 .6156 .23492 Metetra
.667 .142 0 r
.6156 .23492 .62216 .23936 .63566 .23911 .62971 .25101 Metetra
.811 .41 .291 r
.62971 .25101 .63566 .23911 .64994 .25543 .64461 .28091 Metetra
.782 .425 .379 r
.64461 .28091 .64994 .25543 .6651 .2855 .66027 .31966 Metetra
.757 .415 .404 r
.66027 .31966 .6651 .2855 .68107 .32431 .6765 .36053 Metetra
.73 .39 .404 r
.6765 .36053 .68107 .32431 .69762 .36514 .69292 .39584 Metetra
.684 .333 .375 r
.69292 .39584 .69762 .36514 .71432 .40029 .70906 .4183 Metetra
.537 .142 .24 r
.70906 .4183 .71432 .40029 .73064 .42251 .72442 .42266 Metetra
.853 .998 .799 r
.72442 .42266 .73064 .42251 .74606 .4266 .73861 .40708 Metetra
.868 .684 .651 r
.73861 .40708 .74606 .4266 .76019 .41077 .75152 .37363 Metetra
.819 .595 .599 r
.75152 .37363 .76019 .41077 .77292 .37714 .7633 .32775 Metetra
.791 .558 .584 r
.7633 .32775 .77292 .37714 .78443 .33119 .77435 .27684 Metetra
.769 .537 .583 r
.77435 .27684 .78443 .33119 .7952 .28033 .78526 .2286 Metetra
.746 .523 .593 r
.78526 .2286 .7952 .28033 .80586 .23224 .79668 .18973 Metetra
.771 .561 .614 r
.15425 .47452 .15842 .51945 .17487 .47161 .17043 .42936 Metetra
.754 .55 .62 r
.17043 .42936 .17487 .47161 .19069 .42745 .18542 .39327 Metetra
.726 .542 .642 r
.18542 .39327 .19069 .42745 .2053 .39315 .19883 .37094 Metetra
.642 .531 .712 r
.19883 .37094 .2053 .39315 .21839 .3731 .21055 .36491 Metetra
0 0 .492 r
.21055 .36491 .21839 .3731 .2299 .36952 .22073 .3755 Metetra
.831 .459 .35 r
.22073 .3755 .2299 .36952 .24 .38239 .22973 .40073 Metetra
.801 .473 .434 r
.22973 .40073 .24 .38239 .24906 .40943 .23806 .43646 Metetra
.78 .465 .455 r
.23806 .43646 .24906 .40943 .25759 .44619 .24635 .47667 Metetra
.76 .446 .454 r
.24635 .47667 .25759 .44619 .2662 .48643 .25524 .5141 Metetra
.73 .405 .431 r
.25524 .5141 .2662 .48643 .27548 .52282 .26527 .54143 Metetra
.65 .285 .339 r
.26527 .54143 .27548 .52282 .28589 .54813 .27676 .55275 Metetra
.429 .846 .681 r
.27676 .55275 .28589 .54813 .2977 .55682 .28976 .54503 Metetra
.862 .718 .701 r
.28976 .54503 .2977 .55682 .31087 .54635 .304 .51892 Metetra
.821 .622 .633 r
.304 .51892 .31087 .54635 .32513 .5179 .31903 .47858 Metetra
.799 .585 .612 r
.31903 .47858 .32513 .5179 .34002 .47609 .33429 .43064 Metetra
.782 .565 .606 r
.33429 .43064 .34002 .47609 .35503 .42773 .34928 .38258 Metetra
.765 .552 .61 r
.34928 .38258 .35503 .42773 .36971 .38032 .36365 .3414 Metetra
.741 .543 .626 r
.36365 .3414 .36971 .38032 .38378 .34069 .3772 .31258 Metetra
.689 .536 .673 r
.3772 .31258 .38378 .34069 .3971 .31402 .38995 .29955 Metetra
.384 .47 .825 r
.38995 .29955 .3971 .31402 .40971 .30344 .40201 .30352 Metetra
.83 .374 .139 r
.40201 .30352 .40971 .30344 .42177 .30984 .41363 .32341 Metetra
.814 .451 .369 r
.41363 .32341 .42177 .30984 .43352 .33179 .42511 .35588 Metetra
.791 .453 .416 r
.42511 .35588 .43352 .33179 .44524 .36566 .43675 .39553 Metetra
.77 .439 .427 r
.43675 .39553 .44524 .36566 .45719 .40578 .44879 .43538 Metetra
.743 .408 .416 r
.44879 .43538 .45719 .40578 .46959 .445 .46141 .46784 Metetra
.689 .331 .363 r
.46141 .46784 .46959 .445 .48251 .47578 .4746 .48611 Metetra
.392 0 .036 r
.4746 .48611 .48251 .47578 .49591 .49156 .48826 .48578 Metetra
.902 .837 .772 r
.48826 .48578 .49591 .49156 .50964 .48841 .50215 .46599 Metetra
.845 .652 .643 r
.50215 .46599 .50964 .48841 .52345 .46601 .51603 .42968 Metetra
.814 .597 .608 r
.51603 .42968 .52345 .46601 .53713 .42782 .52969 .38281 Metetra
.794 .57 .597 r
.52969 .38281 .53713 .42782 .55051 .3801 .54305 .33286 Metetra
.776 .554 .598 r
.54305 .33286 .55051 .3801 .56356 .33041 .55612 .28729 Metetra
.754 .543 .611 r
.55612 .28729 .56356 .33041 .57638 .28608 .56906 .25231 Metetra
.717 .537 .645 r
.56906 .25231 .57638 .28608 .58917 .25308 .58208 .23226 Metetra
.595 .524 .744 r
.58208 .23226 .58917 .25308 .60215 .23544 .59542 .22923 Metetra
.526 .014 0 r
.59542 .22923 .60215 .23544 .6156 .23492 .60931 .24304 Metetra
.823 .404 .247 r
.60931 .24304 .6156 .23492 .62971 .25101 .62389 .27121 Metetra
.801 .432 .357 r
.62389 .27121 .62971 .25101 .64461 .28091 .63918 .30908 Metetra
.779 .426 .387 r
.63918 .30908 .64461 .28091 .66027 .31966 .65506 .35013 Metetra
.754 .402 .388 r
.65506 .35013 .66027 .31966 .6765 .36053 .67123 .38674 Metetra
.711 .348 .357 r
.67123 .38674 .6765 .36053 .69292 .39584 .68726 .41145 Metetra
.579 .163 .218 r
.68726 .41145 .69292 .39584 .70906 .4183 .70267 .41861 Metetra
.779 .998 .832 r
.70267 .41861 .70906 .4183 .72442 .42266 .71708 .40584 Metetra
.878 .707 .665 r
.71708 .40584 .72442 .42266 .73861 .40708 .73032 .37464 Metetra
.835 .615 .606 r
.73032 .37464 .73861 .40708 .75152 .37363 .74246 .33005 Metetra
.809 .578 .587 r
.74246 .33005 .75152 .37363 .7633 .32775 .75384 .27931 Metetra
.789 .557 .585 r
.75384 .27931 .7633 .32775 .77435 .27684 .76498 .23018 Metetra
.767 .544 .595 r
.76498 .23018 .77435 .27684 .78526 .2286 .77649 .18955 Metetra
.736 .536 .622 r
.77649 .18955 .78526 .2286 .79668 .18973 .78892 .1626 Metetra
.797 .595 .629 r
.14876 .44225 .15425 .47452 .17043 .42936 .16448 .40165 Metetra
.777 .591 .648 r
.16448 .40165 .17043 .42936 .18542 .39327 .1787 .37313 Metetra
.726 .592 .705 r
.1787 .37313 .18542 .39327 .19883 .37094 .19116 .36015 Metetra
.286 .489 .881 r
.19116 .36015 .19883 .37094 .21055 .36491 .20191 .36395 Metetra
.85 .423 .213 r
.20191 .36395 .21055 .36491 .22073 .3755 .21122 .3835 Metetra
.842 .491 .389 r
.21122 .3835 .22073 .3755 .22973 .40073 .21958 .41554 Metetra
.826 .496 .429 r
.21958 .41554 .22973 .40073 .23806 .43646 .22759 .45475 Metetra
.812 .484 .435 r
.22759 .45475 .23806 .43646 .24635 .47667 .23595 .49429 Metetra
.792 .454 .416 r
.23595 .49429 .24635 .47667 .25524 .5141 .24527 .52666 Metetra
.744 .367 .338 r
.24527 .52666 .25524 .5141 .26527 .54143 .25602 .54519 Metetra
.263 0 0 r
.25602 .54519 .26527 .54143 .27676 .55275 .26839 .54548 Metetra
.868 .782 .764 r
.26839 .54548 .27676 .55275 .28976 .54503 .28224 .52661 Metetra
.849 .667 .656 r
.28224 .52661 .28976 .54503 .304 .51892 .29716 .49141 Metetra
.834 .629 .625 r
.29716 .49141 .304 .51892 .31903 .47858 .31259 .44564 Metetra
.822 .609 .615 r
.31259 .44564 .31903 .47858 .33429 .43064 .32797 .39664 Metetra
.809 .598 .617 r
.32797 .39664 .33429 .43064 .34928 .38258 .34283 .35176 Metetra
.792 .593 .632 r
.34283 .35176 .34928 .38258 .36365 .3414 .35688 .31722 Metetra
.756 .592 .673 r
.35688 .31722 .36365 .3414 .3772 .31258 .37003 .29732 Metetra
.611 .583 .798 r
.37003 .29732 .3772 .31258 .38995 .29955 .38234 .29423 Metetra
.686 .16 0 r
.38234 .29423 .38995 .29955 .40201 .30352 .39403 .30779 Metetra
.85 .45 .281 r
.39403 .30779 .40201 .30352 .41363 .32341 .40538 .33561 Metetra
.838 .477 .37 r
.40538 .33561 .41363 .32341 .42511 .35588 .41671 .37308 Metetra
.823 .473 .393 r
.41671 .37308 .42511 .35588 .43675 .39553 .42835 .4138 Metetra
.804 .45 .386 r
.42835 .4138 .43675 .39553 .44879 .43538 .44052 .45026 Metetra
.768 .389 .337 r
.44052 .45026 .44879 .43538 .46141 .46784 .45335 .47513 Metetra
.607 .127 .089 r
.45335 .47513 .46141 .46784 .4746 .48611 .46678 .48282 Metetra
.839 .92 .888 r
.46678 .48282 .4746 .48611 .48826 .48578 .48065 .4709 Metetra
.87 .707 .677 r
.48065 .4709 .48826 .48578 .50215 .46599 .49469 .44079 Metetra
.851 .645 .623 r
.49469 .44079 .50215 .46599 .51603 .42968 .50865 .39736 Metetra
.837 .618 .606 r
.50865 .39736 .51603 .42968 .52969 .38281 .52235 .34766 Metetra
.824 .603 .604 r
.52235 .34766 .52969 .38281 .54305 .33286 .53574 .29934 Metetra
.807 .595 .615 r
.53574 .29934 .54305 .33286 .55612 .28729 .54889 .25926 Metetra
.779 .592 .647 r
.54889 .25926 .55612 .28729 .56906 .25231 .56196 .23259 Metetra
.701 .592 .731 r
.56196 .23259 .56906 .25231 .58208 .23226 .57517 .22236 Metetra
.106 .406 .858 r
.57517 .22236 .58208 .23226 .59542 .22923 .58876 .22935 Metetra
.821 .345 .058 r
.58876 .22935 .59542 .22923 .60931 .24304 .60291 .25202 Metetra
.845 .44 .274 r
.60291 .25202 .60931 .24304 .62389 .27121 .61774 .28659 Metetra
.833 .451 .329 r
.61774 .28659 .62389 .27121 .63918 .30908 .63319 .32723 Metetra
.815 .436 .338 r
.63319 .32723 .63918 .30908 .65506 .35013 .64909 .36665 Metetra
.785 .391 .309 r
.64909 .36665 .65506 .35013 .67123 .38674 .66507 .39713 Metetra
.696 .245 .178 r
.66507 .39713 .67123 .38674 .68726 .41145 .6807 .41207 Metetra
.313 .803 .799 r
.6807 .41207 .68726 .41145 .70267 .41861 .69558 .40757 Metetra
.894 .775 .723 r
.69558 .40757 .70267 .41861 .71708 .40584 .7094 .38351 Metetra
.873 .67 .626 r
.7094 .38351 .71708 .40584 .73032 .37464 .72214 .3436 Metetra
.855 .63 .596 r
.72214 .3436 .73032 .37464 .74246 .33005 .734 .29438 Metetra
.84 .609 .589 r
.734 .29438 .74246 .33005 .75384 .27931 .74539 .24358 Metetra
.823 .598 .597 r
.74539 .24358 .75384 .27931 .76498 .23018 .75686 .19861 Metetra
.799 .593 .623 r
.75686 .19861 .76498 .23018 .77649 .18955 .76899 .16544 Metetra
.747 .594 .686 r
.76899 .16544 .77649 .18955 .78892 .1626 .78227 .14799 Metetra
.857 .672 .651 r
.14145 .42598 .14876 .44225 .16448 .40165 .15702 .38754 Metetra
.835 .679 .688 r
.15702 .38754 .16448 .40165 .1787 .37313 .17095 .36214 Metetra
.75 .692 .796 r
.17095 .36214 .1787 .37313 .19116 .36015 .18307 .35277 Metetra
0 .196 .679 r
.18307 .35277 .19116 .36015 .20191 .36395 .19345 .36017 Metetra
.883 .464 .202 r
.19345 .36017 .20191 .36395 .21122 .3835 .20242 .38283 Metetra
.898 .533 .339 r
.20242 .38283 .21122 .3835 .21958 .41554 .21053 .41699 Metetra
.895 .545 .372 r
.21053 .41699 .21958 .41554 .22759 .45475 .21842 .45695 Metetra
.889 .534 .366 r
.21842 .45695 .22759 .45475 .23595 .49429 .2268 .4956 Metetra
.874 .49 .311 r
.2268 .4956 .23595 .49429 .24527 .52666 .2363 .52548 Metetra
.784 .296 .058 r
.2363 .52548 .24527 .52666 .25602 .54519 .24736 .54028 Metetra
.624 .833 .981 r
.24736 .54028 .25602 .54519 .26839 .54548 .26009 .53629 Metetra
.87 .75 .728 r
.26009 .53629 .26839 .54548 .28224 .52661 .27431 .51341 Metetra
.885 .707 .656 r
.27431 .51341 .28224 .52661 .29716 .49141 .28954 .47522 Metetra
.886 .689 .631 r
.28954 .47522 .29716 .49141 .31259 .44564 .30518 .42798 Metetra
.882 .681 .625 r
.30518 .42798 .31259 .44564 .32797 .39664 .32066 .37917 Metetra
.875 .679 .634 r
.32066 .37917 .32797 .39664 .34283 .35176 .33552 .33599 Metetra
.858 .683 .664 r
.33552 .33599 .34283 .35176 .35688 .31722 .34949 .30429 Metetra
.808 .694 .74 r
.34949 .30429 .35688 .31722 .37003 .29732 .36251 .28792 Metetra
.457 .625 .924 r
.36251 .28792 .37003 .29732 .38234 .29423 .37467 .28854 Metetra
.771 .273 0 r
.37467 .28854 .38234 .29423 .39403 .30779 .38621 .30552 Metetra
.893 .48 .206 r
.38621 .30552 .39403 .30779 .40538 .33561 .39743 .33593 Metetra
.902 .517 .284 r
.39743 .33593 .40538 .33561 .41671 .37308 .40868 .37475 Metetra
.898 .515 .296 r
.40868 .37475 .41671 .37308 .42835 .4138 .42029 .41524 Metetra
.884 .483 .258 r
.42029 .41524 .42835 .4138 .44052 .45026 .4325 .44978 Metetra
.826 .36 .099 r
.4325 .44978 .44052 .45026 .45335 .47513 .44541 .47129 Metetra
0 .498 .825 r
.44541 .47129 .45335 .47513 .46678 .48282 .45896 .47474 Metetra
.855 .799 .796 r
.45896 .47474 .46678 .48282 .48065 .4709 .47295 .45852 Metetra
.899 .733 .667 r
.47295 .45852 .48065 .4709 .49469 .44079 .48712 .42488 Metetra
.904 .705 .624 r
.48712 .42488 .49469 .44079 .50865 .39736 .5012 .37931 Metetra
.902 .692 .61 r
.5012 .37931 .50865 .39736 .52235 .34766 .51502 .32916 Metetra
.895 .688 .614 r
.51502 .32916 .52235 .34766 .53574 .29934 .52851 .28201 Metetra
.882 .69 .638 r
.52851 .28201 .53574 .29934 .54889 .25926 .54176 .24441 Metetra
.847 .699 .698 r
.54176 .24441 .54889 .25926 .56196 .23259 .55492 .2211 Metetra
.694 .693 .845 r
.55492 .2211 .56196 .23259 .57517 .22236 .56823 .21462 Metetra
0 .181 .686 r
.56823 .21462 .57517 .22236 .58876 .22935 .58191 .22524 Metetra
.827 .357 0 r
.58191 .22524 .58876 .22935 .60291 .25202 .59614 .25092 Metetra
.887 .459 .143 r
.59614 .25092 .60291 .25202 .61774 .28659 .61101 .2874 Metetra
.893 .477 .187 r
.61101 .2874 .61774 .28659 .63319 .32723 .62648 .32847 Metetra
.882 .455 .168 r
.62648 .32847 .63319 .32723 .64909 .36665 .64233 .36661 Metetra
.835 .365 .057 r
.64233 .36661 .64909 .36665 .66507 .39713 .65821 .3942 Metetra
.501 0 0 r
.65821 .3942 .66507 .39713 .6807 .41207 .6737 .40508 Metetra
.761 .847 .916 r
.6737 .40508 .6807 .41207 .69558 .40757 .68841 .39611 Metetra
.909 .77 .695 r
.68841 .39611 .69558 .40757 .7094 .38351 .7021 .36805 Metetra
.923 .727 .619 r
.7021 .36805 .7094 .38351 .72214 .3436 .71476 .32537 Metetra
.923 .707 .592 r
.71476 .32537 .72214 .3436 .734 .29438 .72664 .27501 Metetra
.918 .699 .59 r
.72664 .27501 .734 .29438 .74539 .24358 .73817 .22479 Metetra
.907 .699 .609 r
.73817 .22479 .74539 .24358 .75686 .19861 .74988 .18187 Metetra
.881 .706 .66 r
.74988 .18187 .75686 .19861 .76899 .16544 .76233 .15181 Metetra
.791 .711 .775 r
.76233 .15181 .76899 .16544 .78227 .14799 .77598 .13806 Metetra
.944 .79 .659 r
.13216 .4258 .14145 .42598 .15702 .38754 .14811 .38535 Metetra
.927 .805 .706 r
.14811 .38535 .15702 .38754 .17095 .36214 .16247 .35719 Metetra
.841 .819 .828 r
.16247 .35719 .17095 .36214 .18307 .35277 .17498 .34471 Metetra
.091 .458 .886 r
.17498 .34471 .18307 .35277 .19345 .36017 .18568 .34906 Metetra
.817 .385 0 r
.18568 .34906 .19345 .36017 .20242 .38283 .19486 .36915 Metetra
.923 .549 .136 r
.19486 .36915 .20242 .38283 .21053 .41699 .20303 .40161 Metetra
.941 .587 .188 r
.20303 .40161 .21053 .41699 .21842 .45695 .21085 .44106 Metetra
.936 .58 .168 r
.21085 .44106 .21842 .45695 .2268 .4956 .21903 .48057 Metetra
.893 .515 .057 r
.21903 .48057 .2268 .4956 .2363 .52548 .22825 .51264 Metetra
.632 .213 0 r
.22825 .51264 .2363 .52548 .24736 .54028 .239 .53059 Metetra
.507 .655 .926 r
.239 .53059 .24736 .54028 .26009 .53629 .25147 .53012 Metetra
.882 .801 .765 r
.25147 .53012 .26009 .53629 .27431 .51341 .26553 .51046 Metetra
.944 .8 .672 r
.26553 .51046 .27431 .51341 .28954 .47522 .28073 .47455 Metetra
.962 .797 .632 r
.28073 .47455 .28954 .47522 .30518 .42798 .29649 .42829 Metetra
.968 .798 .619 r
.29649 .42829 .30518 .42798 .32066 .37917 .31218 .37906 Metetra
.967 .805 .628 r
.31218 .37906 .32066 .37917 .33552 .33599 .3273 .33425 Metetra
.956 .819 .667 r
.3273 .33425 .33552 .33599 .34949 .30429 .34156 .29999 Metetra
.907 .837 .765 r
.34156 .29999 .34949 .30429 .36251 .28792 .35482 .28055 Metetra
.587 .742 .95 r
.35482 .28055 .36251 .28792 .37467 .28854 .36717 .278 Metetra
0 0 .516 r
.36717 .278 .37467 .28854 .38621 .30552 .37881 .29212 Metetra
.803 .406 0 r
.37881 .29212 .38621 .30552 .39743 .33593 .39005 .32041 Metetra
.867 .495 .005 r
.39005 .32041 .39743 .33593 .40868 .37475 .40124 .35819 Metetra
.869 .505 .011 r
.40124 .35819 .40868 .37475 .42029 .41524 .41273 .39898 Metetra
.822 .45 0 r
.41273 .39898 .42029 .41524 .4325 .44978 .4248 .43523 Metetra
.631 .246 0 r
.4248 .43523 .4325 .44978 .44541 .47129 .43758 .4596 Metetra
.138 .405 .852 r
.43758 .4596 .44541 .47129 .45896 .47474 .45106 .46658 Metetra
.818 .8 .834 r
.45106 .46658 .45896 .47474 .47295 .45852 .46506 .45384 Metetra
.948 .824 .688 r
.46506 .45384 .47295 .45852 .48712 .42488 .47932 .42296 Metetra
.978 .817 .616 r
.47932 .42296 .48712 .42488 .5012 .37931 .49356 .37892 Metetra
.986 .815 .587 r
.49356 .37892 .5012 .37931 .51502 .32916 .50756 .32889 Metetra
.988 .819 .586 r
.50756 .32889 .51502 .32916 .52851 .28201 .52124 .28052 Metetra
.982 .833 .618 r
.52124 .28052 .52851 .28201 .54176 .24441 .53463 .24064 Metetra
.954 .854 .705 r
.53463 .24064 .54176 .24441 .55492 .2211 .54788 .21437 Metetra
.792 .833 .884 r
.54788 .21437 .55492 .2211 .56823 .21462 .5612 .20467 Metetra
.06 .378 .843 r
.5612 .20467 .56823 .21462 .58191 .22524 .57484 .21221 Metetra
0 0 .419 r
.57484 .21221 .58191 .22524 .59614 .25092 .58897 .23539 Metetra
.698 .333 0 r
.58897 .23539 .59614 .25092 .61101 .2874 .60373 .27033 Metetra
.727 .373 0 r
.60373 .27033 .61101 .2874 .62648 .32847 .6191 .31113 Metetra
.687 .337 0 r
.6191 .31113 .62648 .32847 .64233 .36661 .63491 .35044 Metetra
0 0 .395 r
.63491 .35044 .64233 .36661 .65821 .3942 .65084 .38052 Metetra
0 .203 .73 r
.65084 .38052 .65821 .3942 .6737 .40508 .66648 .39479 Metetra
.66 .732 .903 r
.66648 .39479 .6737 .40508 .68841 .39611 .68142 .38947 Metetra
.938 .848 .728 r
.68142 .38947 .68841 .39611 .7021 .36805 .6954 .36458 Metetra
.989 .84 .602 r
.6954 .36458 .7021 .36805 .71476 .32537 .70834 .32397 Metetra
.998 .829 .542 r
.70834 .32397 .71476 .32537 .72664 .27501 .72045 .2743 Metetra
1 .828 .525 r
.72045 .2743 .72664 .27501 .73817 .22479 .73212 .22334 Metetra
.998 .84 .548 r
.73212 .22334 .73817 .22479 .74988 .18187 .74385 .17848 Metetra
.987 .867 .629 r
.74385 .17848 .74988 .18187 .76233 .15181 .75621 .14565 Metetra
.902 .882 .804 r
.75621 .14565 .76233 .15181 .77598 .13806 .76968 .12869 Metetra
.989 .892 .597 r
.12073 .44186 .13216 .4258 .14811 .38535 .13748 .39667 Metetra
.982 .908 .638 r
.13748 .39667 .14811 .38535 .16247 .35719 .15287 .36101 Metetra
.949 .929 .748 r
.15287 .36101 .16247 .35719 .17498 .34471 .1665 .33944 Metetra
.691 .821 .945 r
.1665 .33944 .17498 .34471 .18568 .34906 .17824 .33438 Metetra
0 .103 .658 r
.17824 .33438 .18568 .34906 .19486 .36915 .18826 .34599 Metetra
0 0 .295 r
.18826 .34599 .19486 .36915 .20303 .40161 .19695 .37214 Metetra
0 0 .176 r
.19695 .37214 .20303 .40161 .21085 .44106 .20489 .40853 Metetra
0 0 .164 r
.20489 .40853 .21085 .44106 .21903 .48057 .2128 .449 Metetra
0 0 .23 r
.2128 .449 .21903 .48057 .22825 .51264 .2214 .48617 Metetra
0 0 .406 r
.2214 .48617 .22825 .51264 .239 .53059 .23129 .51272 Metetra
.112 .265 .742 r
.23129 .51272 .239 .53059 .25147 .53012 .24286 .52282 Metetra
.772 .795 .871 r
.24286 .52282 .25147 .53012 .26553 .51046 .25615 .51363 Metetra
.965 .906 .708 r
.25615 .51363 .26553 .51046 .28073 .47455 .27088 .48606 Metetra
.986 .899 .592 r
.27088 .48606 .28073 .47455 .29649 .42829 .2865 .44454 Metetra
.981 .888 .535 r
.2865 .44454 .29649 .42829 .31218 .37906 .30241 .39586 Metetra
.975 .888 .521 r
.30241 .39586 .31218 .37906 .3273 .33425 .318 .34757 Metetra
.973 .903 .551 r
.318 .34757 .3273 .33425 .34156 .29999 .33286 .30666 Metetra
.967 .937 .653 r
.33286 .30666 .34156 .29999 .35482 .28055 .34676 .27848 Metetra
.858 .927 .872 r
.34676 .27848 .35482 .28055 .36717 .278 .35967 .26637 Metetra
.245 .454 .866 r
.35967 .26637 .36717 .278 .37881 .29212 .37173 .27136 Metetra
0 0 .532 r
.37173 .27136 .37881 .29212 .39005 .32041 .38321 .29222 Metetra
0 0 .376 r
.38321 .29222 .39005 .32041 .40124 .35819 .39444 .32545 Metetra
0 0 .335 r
.39444 .32545 .40124 .35819 .41273 .39898 .40578 .36552 Metetra
0 0 .361 r
.40578 .36552 .41273 .39898 .4248 .43523 .41756 .4053 Metetra
0 0 .458 r
.41756 .4053 .4248 .43523 .43758 .4596 .43 .43715 Metetra
.002 .14 .656 r
.43 .43715 .43758 .4596 .45106 .46658 .44319 .45432 Metetra
.565 .636 .88 r
.44319 .45432 .45106 .46658 .46506 .45384 .45701 .45254 Metetra
.939 .917 .765 r
.45701 .45254 .46506 .45384 .47932 .42296 .47125 .43122 Metetra
.972 .909 .566 r
.47125 .43122 .47932 .42296 .49356 .37892 .48562 .39356 Metetra
.944 .871 .455 r
.48562 .39356 .49356 .37892 .50756 .32889 .49986 .34575 Metetra
.923 .854 .412 r
.49986 .34575 .50756 .32889 .52124 .28052 .5138 .29536 Metetra
.919 .863 .426 r
.5138 .29536 .52124 .28052 .53463 .24064 .52742 .24987 Metetra
.934 .907 .517 r
.52742 .24987 .53463 .24064 .54788 .21437 .5408 .21541 Metetra
.928 .971 .75 r
.5408 .21541 .54788 .21437 .5612 .20467 .55413 .19619 Metetra
.559 .714 .944 r
.55413 .19619 .5612 .20467 .57484 .21221 .56765 .19415 Metetra
.021 .194 .703 r
.56765 .19415 .57484 .21221 .58897 .23539 .58157 .20895 Metetra
0 0 .536 r
.58157 .20895 .58897 .23539 .60373 .27033 .59607 .23798 Metetra
0 0 .475 r
.59607 .23798 .60373 .27033 .6191 .31113 .61121 .2764 Metetra
0 0 .473 r
.61121 .2764 .6191 .31113 .63491 .35044 .62691 .31755 Metetra
0 0 .519 r
.62691 .31755 .63491 .35044 .65084 .38052 .64294 .35372 Metetra
.006 .113 .627 r
.64294 .35372 .65084 .38052 .66648 .39479 .6589 .37747 Metetra
.361 .445 .812 r
.6589 .37747 .66648 .39479 .68142 .38947 .67438 .38326 Metetra
.859 .882 .853 r
.67438 .38326 .68142 .38947 .6954 .36458 .68901 .3689 Metetra
.951 .921 .562 r
.68901 .3689 .6954 .36458 .70834 .32397 .7026 .33622 Metetra
.875 .83 .359 r
.7026 .33622 .70834 .32397 .72045 .2743 .7152 .29049 Metetra
.821 .777 .271 r
.7152 .29049 .72045 .2743 .73212 .22334 .72711 .23911 Metetra
.802 .769 .258 r
.72711 .23911 .73212 .22334 .74385 .17848 .73879 .18986 Metetra
.825 .814 .329 r
.73879 .18986 .74385 .17848 .75621 .14565 .7508 .1496 Metetra
.895 .932 .554 r
.7508 .1496 .75621 .14565 .76968 .12869 .76367 .12337 Metetra
.9 .882 .453 r
.10737 .4715 .12073 .44186 .13748 .39667 .1248 .42297 Metetra
.9 .89 .468 r
.1248 .42297 .13748 .39667 .15287 .36101 .14145 .37878 Metetra
.919 .926 .549 r
.14145 .37878 .15287 .36101 .1665 .33944 .15666 .34504 Metetra
.925 .974 .751 r
.15666 .34504 .1665 .33944 .17824 .33438 .17006 .32597 Metetra
.59 .706 .923 r
.17006 .32597 .17824 .33438 .18826 .34599 .18158 .32364 Metetra
.002 .117 .632 r
.18158 .32364 .18826 .34599 .19695 .37214 .19142 .33782 Metetra
0 0 .436 r
.19142 .33782 .19695 .37214 .20489 .40853 .20001 .36603 Metetra
0 0 .363 r
.20001 .36603 .20489 .40853 .2128 .449 .20798 .40361 Metetra
0 0 .356 r
.20798 .40361 .2128 .449 .2214 .48617 .21604 .44413 Metetra
0 0 .402 r
.21604 .44413 .2214 .48617 .23129 .51272 .22489 .48012 Metetra
0 0 .523 r
.22489 .48012 .23129 .51272 .24286 .52282 .23513 .50435 Metetra
.281 .367 .774 r
.23513 .50435 .24286 .52282 .25615 .51363 .24708 .51137 Metetra
.851 .917 .876 r
.24708 .51137 .25615 .51363 .27088 .48606 .26072 .49894 Metetra
.912 .939 .576 r
.26072 .49894 .27088 .48606 .2865 .44454 .27572 .46857 Metetra
.843 .855 .399 r
.27572 .46857 .2865 .44454 .30241 .39586 .29152 .4252 Metetra
.802 .812 .328 r
.29152 .4252 .30241 .39586 .318 .34757 .30748 .37588 Metetra
.793 .808 .322 r
.30748 .37588 .318 .34757 .33286 .30666 .32305 .32818 Metetra
.819 .847 .386 r
.32305 .32818 .33286 .30666 .34676 .27848 .33783 .28889 Metetra
.887 .943 .58 r
.33783 .28889 .34676 .27848 .35967 .26637 .35164 .26306 Metetra
.803 .908 .913 r
.35164 .26306 .35967 .26637 .37173 .27136 .36449 .25366 Metetra
.257 .35 .768 r
.36449 .25366 .37173 .27136 .38321 .29222 .37653 .26135 Metetra
0 .045 .564 r
.37653 .26135 .38321 .29222 .39444 .32545 .38805 .28454 Metetra
0 0 .478 r
.38805 .28454 .39444 .32545 .40578 .36552 .39939 .31936 Metetra
0 0 .454 r
.39939 .31936 .40578 .36552 .41756 .4053 .41091 .35995 Metetra
0 0 .472 r
.41091 .35995 .41756 .4053 .43 .43715 .42292 .39903 Metetra
0 .02 .536 r
.42292 .39903 .43 .43715 .44319 .45432 .43562 .42894 Metetra
.177 .234 .684 r
.43562 .42894 .44319 .45432 .45701 .45254 .44903 .44321 Metetra
.662 .744 .911 r
.44903 .44321 .45701 .45254 .47125 .43122 .46305 .43811 Metetra
.892 .96 .626 r
.46305 .43811 .47125 .43122 .48562 .39356 .47742 .41368 Metetra
.75 .797 .311 r
.47742 .41368 .48562 .39356 .49986 .34575 .49185 .37372 Metetra
.49185 .37372 .49986 .34575 .5138 .29536 .5061 .32476 Metetra
.5061 .32476 .5138 .29536 .52742 .24987 .52003 .27451 Metetra
.52003 .27451 .52742 .24987 .5408 .21541 .53365 .23028 Metetra
.743 .817 .348 r
.53365 .23028 .5408 .21541 .55413 .19619 .54707 .19796 Metetra
.878 .993 .765 r
.54707 .19796 .55413 .19619 .56765 .19415 .5605 .18138 Metetra
.483 .574 .871 r
.5605 .18138 .56765 .19415 .58157 .20895 .57417 .18212 Metetra
.152 .2 .659 r
.57417 .18212 .58157 .20895 .59607 .23798 .58831 .19947 Metetra
.039 .068 .563 r
.58831 .19947 .59607 .23798 .61121 .2764 .60308 .23043 Metetra
.005 .025 .528 r
.60308 .23043 .61121 .2764 .62691 .31755 .61851 .26983 Metetra
.011 .028 .529 r
.61851 .26983 .62691 .31755 .64294 .35372 .63448 .31077 Metetra
.055 .074 .561 r
.63448 .31077 .64294 .35372 .6589 .37747 .65071 .34543 Metetra
.164 .192 .644 r
.65071 .34543 .6589 .37747 .67438 .38326 .66679 .36656 Metetra
.453 .512 .829 r
.66679 .36656 .67438 .38326 .68901 .3689 .68229 .36905 Metetra
.883 .992 .779 r
.68229 .36905 .68901 .3689 .7026 .33622 .69686 .35137 Metetra
.69686 .35137 .7026 .33622 .7152 .29049 .71033 .31596 Metetra
.71033 .31596 .7152 .29049 .72711 .23911 .72282 .26858 Metetra
0 0 .007 r
.72282 .26858 .72711 .23911 .73879 .18986 .73467 .21683 Metetra
.73467 .21683 .73879 .18986 .7508 .1496 .74638 .16845 Metetra
.74638 .16845 .7508 .1496 .76367 .12337 .75853 .13006 Metetra
.803 .838 .373 r
.09323 .50479 .10737 .4715 .1248 .42297 .11063 .45888 Metetra
.786 .819 .342 r
.11063 .45888 .1248 .42297 .14145 .37878 .12813 .41018 Metetra
.8 .836 .369 r
.12813 .41018 .14145 .37878 .15666 .34504 .14484 .36598 Metetra
.85 .897 .477 r
.14484 .36598 .15666 .34504 .17006 .32597 .16009 .33236 Metetra
.911 .982 .739 r
.16009 .33236 .17006 .32597 .18158 .32364 .17353 .31352 Metetra
.582 .662 .892 r
.17353 .31352 .18158 .32364 .19142 .33782 .1851 .31147 Metetra
.099 .149 .627 r
.1851 .31147 .19142 .33782 .20001 .36603 .195 .32595 Metetra
0 0 .474 r
.195 .32595 .20001 .36603 .20798 .40361 .20368 .35442 Metetra
0 0 .414 r
.20368 .35442 .20798 .40361 .21604 .44413 .21175 .39219 Metetra
0 0 .406 r
.21175 .39219 .21604 .44413 .22489 .48012 .21993 .43277 Metetra
0 0 .44 r
.21993 .43277 .22489 .48012 .23513 .50435 .22892 .46866 Metetra
0 .027 .54 r
.22892 .46866 .23513 .50435 .24708 .51137 .23931 .49263 Metetra
.3 .377 .775 r
.23931 .49263 .24708 .51137 .26072 .49894 .2514 .49926 Metetra
.852 .972 .87 r
.2514 .49926 .26072 .49894 .27572 .46857 .26517 .48635 Metetra
.791 .878 .449 r
.26517 .48635 .27572 .46857 .29152 .4252 .28028 .45552 Metetra
.687 .755 .26 r
.28028 .45552 .29152 .4252 .30748 .37588 .29615 .41178 Metetra
.29615 .41178 .30748 .37588 .32305 .32818 .31217 .36222 Metetra
.31217 .36222 .32305 .32818 .33783 .28889 .32778 .31445 Metetra
.699 .77 .281 r
.32778 .31445 .33783 .28889 .35164 .26306 .34261 .27523 Metetra
.827 .917 .523 r
.34261 .27523 .35164 .26306 .36449 .25366 .35647 .24959 Metetra
.794 .89 .913 r
.35647 .24959 .36449 .25366 .37653 .26135 .36939 .24045 Metetra
.298 .34 .737 r
.36939 .24045 .37653 .26135 .38805 .28454 .38153 .24844 Metetra
.074 .089 .57 r
.38153 .24844 .38805 .28454 .39939 .31936 .39317 .27191 Metetra
0 0 .501 r
.39317 .27191 .39939 .31936 .41091 .35995 .40467 .30695 Metetra
0 0 .48 r
.40467 .30695 .41091 .35995 .42292 .39903 .41637 .34765 Metetra
0 0 .493 r
.41637 .34765 .42292 .39903 .43562 .42894 .42856 .38668 Metetra
.047 .058 .547 r
.42856 .38668 .43562 .42894 .44903 .44321 .44143 .41638 Metetra
.209 .246 .682 r
.44143 .41638 .44903 .44321 .46305 .43811 .45501 .43028 Metetra
.674 .79 .936 r
.45501 .43028 .46305 .43811 .47742 .41368 .46915 .42472 Metetra
.759 .891 .487 r
.46915 .42472 .47742 .41368 .49185 .37372 .48361 .39981 Metetra
.48361 .39981 .49185 .37372 .5061 .32476 .4981 .35942 Metetra
.4981 .35942 .5061 .32476 .52003 .27451 .51237 .31016 Metetra
.51237 .31016 .52003 .27451 .53365 .23028 .52632 .25976 Metetra
.52632 .25976 .53365 .23028 .54707 .19796 .53997 .21556 Metetra
.53997 .21556 .54707 .19796 .5605 .18138 .55344 .18338 Metetra
.863 .995 .76 r
.55344 .18338 .5605 .18138 .57417 .18212 .56696 .16704 Metetra
.486 .537 .834 r
.56696 .16704 .57417 .18212 .58831 .19947 .58076 .16807 Metetra
.211 .215 .645 r
.58076 .16807 .58831 .19947 .60308 .23043 .59508 .18571 Metetra
.117 .104 .566 r
.59508 .18571 .60308 .23043 .61851 .26983 .61006 .2169 Metetra
.085 .067 .537 r
.61006 .2169 .61851 .26983 .63448 .31077 .62573 .25645 Metetra
.086 .067 .537 r
.62573 .25645 .63448 .31077 .65071 .34543 .64195 .29739 Metetra
.117 .104 .565 r
.64195 .29739 .65071 .34543 .66679 .36656 .65841 .33189 Metetra
.202 .206 .64 r
.65841 .33189 .66679 .36656 .68229 .36905 .67469 .35269 Metetra
.461 .524 .836 r
.67469 .35269 .68229 .36905 .69686 .35137 .69033 .35474 Metetra
.79 .97 .671 r
.69033 .35474 .69686 .35137 .71033 .31596 .70497 .33655 Metetra
.70497 .33655 .71033 .31596 .72282 .26858 .71847 .30067 Metetra
0 0 .067 r
.71847 .30067 .72282 .26858 .73467 .21683 .73096 .25293 Metetra
0 0 .109 r
.73096 .25293 .73467 .21683 .74638 .16845 .74279 .20098 Metetra
0 0 .093 r
.74279 .20098 .74638 .16845 .75853 .13006 .7545 .15256 Metetra
.863 .902 .488 r
.08008 .52808 .09323 .50479 .11063 .45888 .09652 .49165 Metetra
.818 .846 .385 r
.09652 .49165 .11063 .45888 .12813 .41018 .11403 .44532 Metetra
.802 .829 .356 r
.11403 .44532 .12813 .41018 .14484 .36598 .1316 .39648 Metetra
.814 .845 .384 r
.1316 .39648 .14484 .36598 .16009 .33236 .14835 .3524 Metetra
.862 .905 .493 r
.14835 .3524 .16009 .33236 .17353 .31352 .16361 .31913 Metetra
.912 .981 .754 r
.16361 .31913 .17353 .31352 .1851 .31147 .17706 .3008 Metetra
.559 .642 .889 r
.17706 .3008 .1851 .31147 .195 .32595 .18865 .29934 Metetra
.076 .133 .619 r
.18865 .29934 .195 .32595 .20368 .35442 .19859 .31439 Metetra
0 0 .466 r
.19859 .31439 .20368 .35442 .21175 .39219 .20733 .34334 Metetra
0 0 .408 r
.20733 .34334 .21175 .39219 .21993 .43277 .2155 .3814 Metetra
0 0 .402 r
.2155 .3814 .21993 .43277 .22892 .46866 .22381 .42201 Metetra
0 0 .439 r
.22381 .42201 .22892 .46866 .23931 .49263 .23296 .45765 Metetra
0 .031 .544 r
.23296 .45765 .23931 .49263 .2514 .49926 .24352 .48109 Metetra
.319 .399 .788 r
.24352 .48109 .2514 .49926 .26517 .48635 .25578 .48698 Metetra
.863 .974 .858 r
.25578 .48698 .26517 .48635 .28028 .45552 .26971 .47326 Metetra
.804 .882 .455 r
.26971 .47326 .28028 .45552 .29615 .41178 .28494 .4417 Metetra
.705 .767 .273 r
.28494 .4417 .29615 .41178 .31217 .36222 .3009 .39741 Metetra
.3009 .39741 .31217 .36222 .32778 .31445 .31697 .34759 Metetra
.31697 .34759 .32778 .31445 .34261 .27523 .33262 .29985 Metetra
.717 .784 .299 r
.33262 .29985 .34261 .27523 .35647 .24959 .34748 .2609 Metetra
.84 .928 .544 r
.34748 .2609 .35647 .24959 .36939 .24045 .36138 .23572 Metetra
.778 .874 .918 r
.36138 .23572 .36939 .24045 .38153 .24844 .37435 .22715 Metetra
.279 .325 .731 r
.37435 .22715 .38153 .24844 .39317 .27191 .38658 .23573 Metetra
.059 .079 .565 r
.38658 .23573 .39317 .27191 .40467 .30695 .39835 .25972 Metetra
0 0 .497 r
.39835 .25972 .40467 .30695 .41637 .34765 .41 .29513 Metetra
0 0 .478 r
.41 .29513 .41637 .34765 .42856 .38668 .42188 .33596 Metetra
0 0 .493 r
.42188 .33596 .42856 .38668 .44143 .41638 .43427 .37484 Metetra
.044 .059 .549 r
.43427 .37484 .44143 .41638 .45501 .43028 .44733 .40409 Metetra
.217 .258 .69 r
.44733 .40409 .45501 .43028 .46915 .42472 .46108 .41731 Metetra
.696 .811 .936 r
.46108 .41731 .46915 .42472 .48361 .39981 .47535 .41093 Metetra
.769 .892 .486 r
.47535 .41093 .48361 .39981 .4981 .35942 .4899 .38521 Metetra
.4899 .38521 .4981 .35942 .51237 .31016 .50443 .34418 Metetra
.50443 .34418 .51237 .31016 .52632 .25976 .51873 .29454 Metetra
.51873 .29454 .52632 .25976 .53997 .21556 .5327 .24406 Metetra
.5327 .24406 .53997 .21556 .55344 .18338 .54637 .20004 Metetra
.54637 .20004 .55344 .18338 .56696 .16704 .5599 .16827 Metetra
.866 .996 .783 r
.5599 .16827 .56696 .16704 .58076 .16807 .57351 .15247 Metetra
.468 .52 .829 r
.57351 .15247 .58076 .16807 .59508 .18571 .58746 .15408 Metetra
.199 .206 .642 r
.58746 .15408 .59508 .18571 .61006 .2169 .60196 .17228 Metetra
.106 .098 .564 r
.60196 .17228 .61006 .2169 .62573 .25645 .61717 .2039 Metetra
.076 .062 .536 r
.61717 .2039 .62573 .25645 .64195 .29739 .63309 .24367 Metetra
.079 .064 .537 r
.63309 .24367 .64195 .29739 .65841 .33189 .64956 .28456 Metetra
.113 .103 .567 r
.64956 .28456 .65841 .33189 .67469 .35269 .66626 .31872 Metetra
.204 .212 .645 r
.66626 .31872 .67469 .35269 .69033 .35474 .68273 .3389 Metetra
.478 .544 .846 r
.68273 .3389 .69033 .35474 .70497 .33655 .69849 .34013 Metetra
.795 .965 .655 r
.69849 .34013 .70497 .33655 .71847 .30067 .71319 .3211 Metetra
.71319 .3211 .71847 .30067 .73096 .25293 .7267 .28448 Metetra
0 0 .057 r
.7267 .28448 .73096 .25293 .74279 .20098 .73915 .23625 Metetra
0 0 .099 r
.73915 .23625 .74279 .20098 .7545 .15256 .75096 .18409 Metetra
.951 .948 .727 r
.06887 .53505 .08008 .52808 .09652 .49165 .0839 .51063 Metetra
.954 .925 .574 r
.0839 .51063 .09652 .49165 .11403 .44532 .10075 .47136 Metetra
.936 .9 .502 r
.10075 .47136 .11403 .44532 .1316 .39648 .11846 .42368 Metetra
.925 .892 .482 r
.11846 .42368 .1316 .39648 .14835 .3524 .13603 .37509 Metetra
.927 .905 .509 r
.13603 .37509 .14835 .3524 .16361 .31913 .15259 .33272 Metetra
.94 .943 .607 r
.15259 .33272 .16361 .31913 .17706 .3008 .16758 .30224 Metetra
.897 .958 .828 r
.16758 .30224 .17706 .3008 .18865 .29934 .1807 .28734 Metetra
.396 .535 .878 r
.1807 .28734 .18865 .29934 .19859 .31439 .19198 .28946 Metetra
0 .002 .555 r
.19198 .28946 .19859 .31439 .20733 .34334 .2017 .30776 Metetra
0 0 .389 r
.2017 .30776 .20733 .34334 .2155 .3814 .21033 .33915 Metetra
0 0 .335 r
.21033 .33915 .2155 .3814 .22381 .42201 .21854 .37841 Metetra
0 0 .344 r
.21854 .37841 .22381 .42201 .23296 .45765 .22705 .41868 Metetra
0 0 .412 r
.22705 .41868 .23296 .45765 .24352 .48109 .23654 .45234 Metetra
0 .045 .574 r
.23654 .45234 .24352 .48109 .25578 .48698 .24754 .47241 Metetra
.445 .532 .852 r
.24754 .47241 .25578 .48698 .26971 .47326 .26026 .47414 Metetra
.915 .951 .805 r
.26026 .47414 .26971 .47326 .28494 .4417 .27459 .45625 Metetra
.922 .924 .546 r
.27459 .45625 .28494 .4417 .3009 .39741 .29012 .4213 Metetra
.87 .861 .411 r
.29012 .4213 .3009 .39741 .31697 .34759 .30625 .37502 Metetra
.84 .832 .36 r
.30625 .37502 .31697 .34759 .33262 .29985 .32235 .32483 Metetra
.837 .837 .368 r
.32235 .32483 .33262 .29985 .34748 .2609 .33793 .27828 Metetra
.866 .884 .452 r
.33793 .27828 .34748 .2609 .36138 .23572 .35267 .24178 Metetra
.914 .972 .681 r
.35267 .24178 .36138 .23572 .37435 .22715 .36644 .21988 Metetra
.669 .785 .936 r
.36644 .21988 .37435 .22715 .38658 .23573 .37933 .21493 Metetra
.127 .232 .704 r
.37933 .21493 .38658 .23573 .39835 .25972 .39153 .22699 Metetra
0 0 .526 r
.39153 .22699 .39835 .25972 .41 .29513 .40335 .25383 Metetra
0 0 .457 r
.40335 .25383 .41 .29513 .42188 .33596 .41513 .29099 Metetra
0 0 .445 r
.41513 .29099 .42188 .33596 .43427 .37484 .42723 .33211 Metetra
0 0 .476 r
.42723 .33211 .43427 .37484 .44733 .40409 .43988 .36962 Metetra
0 .049 .563 r
.43988 .36962 .44733 .40409 .46108 .41731 .45322 .39595 Metetra
.267 .336 .749 r
.45322 .39595 .46108 .41731 .47535 .41093 .46721 .40516 Metetra
.803 .874 .9 r
.46721 .40516 .47535 .41093 .4899 .38521 .48167 .39442 Metetra
.891 .931 .552 r
.48167 .39442 .4899 .38521 .50443 .34418 .49632 .36485 Metetra
.775 .799 .31 r
.49632 .36485 .50443 .34418 .51873 .29454 .51089 .32119 Metetra
.71 .732 .215 r
.51089 .32119 .51873 .29454 .5327 .24406 .52518 .27053 Metetra
.692 .719 .199 r
.52518 .27053 .5327 .24406 .54637 .20004 .53913 .22068 Metetra
.72 .76 .258 r
.53913 .22068 .54637 .20004 .5599 .16827 .55281 .17869 Metetra
.816 .886 .459 r
.55281 .17869 .5599 .16827 .57351 .15247 .5664 .14997 Metetra
.843 .961 .884 r
.5664 .14997 .57351 .15247 .58746 .15408 .58016 .13775 Metetra
.349 .44 .814 r
.58016 .13775 .58746 .15408 .60196 .17228 .59432 .14299 Metetra
.083 .142 .626 r
.59432 .14299 .60196 .17228 .61717 .2039 .60911 .16437 Metetra
0 .037 .547 r
.60911 .16437 .61717 .2039 .63309 .24367 .62464 .19825 Metetra
0 .007 .522 r
.62464 .19825 .63309 .24367 .64956 .28456 .64088 .23893 Metetra
0 .022 .531 r
.64088 .23893 .64956 .28456 .66626 .31872 .65763 .2791 Metetra
.055 .087 .577 r
.65763 .2791 .66626 .31872 .68273 .3389 .6745 .31086 Metetra
.205 .247 .684 r
.6745 .31086 .68273 .3389 .69849 .34013 .69102 .3273 Metetra
.591 .662 .887 r
.69102 .3273 .69849 .34013 .71319 .3211 .70671 .32413 Metetra
.882 .966 .642 r
.70671 .32413 .71319 .3211 .7267 .28448 .72125 .30087 Metetra
.72125 .30087 .7267 .28448 .73915 .23625 .73456 .26103 Metetra
.73456 .26103 .73915 .23625 .75096 .18409 .74687 .21111 Metetra
.866 .831 .811 r
.05906 .53066 .06887 .53505 .0839 .51063 .07301 .51491 Metetra
.964 .867 .693 r
.07301 .51491 .0839 .51063 .10075 .47136 .0892 .482 Metetra
.986 .869 .633 r
.0892 .482 .10075 .47136 .11846 .42368 .10676 .43732 Metetra
.991 .871 .609 r
.10676 .43732 .11846 .42368 .13603 .37509 .12465 .38806 Metetra
.991 .877 .611 r
.12465 .38806 .13603 .37509 .15259 .33272 .14191 .34173 Metetra
.984 .892 .647 r
.14191 .34173 .15259 .33272 .16758 .30224 .15783 .30481 Metetra
.95 .911 .744 r
.15783 .30481 .16758 .30224 .1807 .28734 .17195 .28198 Metetra
.72 .834 .935 r
.17195 .28198 .1807 .28734 .19198 .28946 .18416 .2758 Metetra
0 .13 .678 r
.18416 .2758 .19198 .28946 .2017 .30776 .19462 .28654 Metetra
0 0 .265 r
.19462 .28654 .2017 .30776 .21033 .33915 .20372 .31215 Metetra
.724 .453 0 r
.20372 .31215 .21033 .33915 .21854 .37841 .21205 .34843 Metetra
.727 .47 0 r
.21205 .34843 .21854 .37841 .22705 .41868 .22033 .3892 Metetra
0 0 .179 r
.22033 .3892 .22705 .41868 .23654 .45234 .22928 .42705 Metetra
0 0 .361 r
.22928 .42705 .23654 .45234 .24754 .47241 .23954 .45448 Metetra
.043 .228 .729 r
.23954 .45448 .24754 .47241 .26026 .47414 .25147 .46544 Metetra
.749 .774 .873 r
.25147 .46544 .26026 .47414 .27459 .45625 .26514 .45686 Metetra
.958 .887 .718 r
.26514 .45686 .27459 .45625 .29012 .4213 .28026 .42947 Metetra
.99 .886 .611 r
.28026 .42947 .29012 .4213 .30625 .37502 .29629 .38765 Metetra
.992 .88 .56 r
.29629 .38765 .30625 .37502 .32235 .32483 .31259 .33821 Metetra
.989 .881 .547 r
.31259 .33821 .32235 .32483 .33793 .27828 .32859 .28886 Metetra
.986 .895 .573 r
.32859 .28886 .33793 .27828 .35267 .24178 .34387 .24669 Metetra
.975 .923 .662 r
.34387 .24669 .35267 .24178 .36644 .21988 .3582 .21721 Metetra
.87 .92 .858 r
.3582 .21721 .36644 .21988 .37933 .21493 .37157 .20386 Metetra
.273 .498 .891 r
.37157 .20386 .37933 .21493 .39153 .22699 .38413 .20782 Metetra
0 0 .53 r
.38413 .20782 .39153 .22699 .40335 .25383 .39614 .22795 Metetra
0 0 .35 r
.39614 .22795 .40335 .25383 .41513 .29099 .40795 .26084 Metetra
0 0 .3 r
.40795 .26084 .41513 .29099 .42723 .33211 .4199 .30099 Metetra
0 0 .326 r
.4199 .30099 .42723 .33211 .43988 .36962 .4323 .34127 Metetra
0 0 .428 r
.4323 .34127 .43988 .36962 .45322 .39595 .44537 .37391 Metetra
0 .108 .643 r
.44537 .37391 .45322 .39595 .46721 .40516 .45913 .39195 Metetra
.533 .615 .88 r
.45913 .39195 .46721 .40516 .48167 .39442 .47348 .39088 Metetra
.928 .896 .776 r
.47348 .39088 .48167 .39442 .49632 .36485 .48817 .36991 Metetra
.985 .903 .595 r
.48817 .36991 .49632 .36485 .51089 .32119 .5029 .33212 Metetra
.972 .876 .494 r
.5029 .33212 .51089 .32119 .52518 .27053 .51744 .2837 Metetra
.958 .863 .453 r
.51744 .2837 .52518 .27053 .53913 .22068 .53165 .23234 Metetra
.954 .872 .464 r
.53165 .23234 .53913 .22068 .55281 .17869 .54553 .18563 Metetra
.961 .908 .545 r
.54553 .18563 .55281 .17869 .5664 .14997 .55923 .14985 Metetra
.94 .958 .747 r
.55923 .14985 .5664 .14997 .58016 .13775 .57295 .12932 Metetra
.591 .745 .95 r
.57295 .12932 .58016 .13775 .59432 .14299 .58697 .12611 Metetra
.006 .209 .721 r
.58697 .12611 .59432 .14299 .60911 .16437 .60151 .13999 Metetra
0 0 .531 r
.60151 .13999 .60911 .16437 .62464 .19825 .61677 .16844 Metetra
0 0 .46 r
.61677 .16844 .62464 .19825 .64088 .23893 .63277 .2067 Metetra
0 0 .456 r
.63277 .2067 .64088 .23893 .65763 .2791 .64941 .24812 Metetra
0 0 .505 r
.64941 .24812 .65763 .2791 .6745 .31086 .66639 .28494 Metetra
0 .089 .62 r
.66639 .28494 .6745 .31086 .69102 .3273 .68325 .30951 Metetra
.326 .428 .812 r
.68325 .30951 .69102 .3273 .70671 .32413 .6995 .31607 Metetra
.838 .856 .858 r
.6995 .31607 .70671 .32413 .72125 .30087 .71471 .3022 Metetra
.972 .921 .601 r
.71471 .3022 .72125 .30087 .73456 .26103 .72869 .26957 Metetra
.925 .853 .412 r
.72869 .26957 .73456 .26103 .74687 .21111 .74151 .22341 Metetra
.826 .778 .807 r
.04958 .52308 .05906 .53066 .07301 .51491 .06335 .50914 Metetra
.907 .768 .696 r
.06335 .50914 .07301 .51491 .0892 .482 .07948 .47761 Metetra
.927 .76 .655 r
.07948 .47761 .0892 .482 .10676 .43732 .09711 .43365 Metetra
.934 .758 .64 r
.09711 .43365 .10676 .43732 .12465 .38806 .11518 .38437 Metetra
.935 .761 .643 r
.11518 .38437 .12465 .38806 .14191 .34173 .13271 .33732 Metetra
.928 .77 .665 r
.13271 .33732 .14191 .34173 .15783 .30481 .14892 .29913 Metetra
.901 .785 .724 r
.14892 .29913 .15783 .30481 .17195 .28198 .16332 .2747 Metetra
.754 .786 .879 r
.16332 .2747 .17195 .28198 .18416 .2758 .17576 .26679 Metetra
0 .115 .627 r
.17576 .26679 .18416 .2758 .19462 .28654 .18638 .2759 Metetra
.874 .453 .03 r
.18638 .2759 .19462 .28654 .20372 .31215 .19555 .30022 Metetra
.932 .554 .181 r
.19555 .30022 .20372 .31215 .21205 .34843 .20385 .33573 Metetra
.941 .575 .212 r
.20385 .33573 .21205 .34843 .22033 .3892 .21202 .37642 Metetra
.933 .558 .178 r
.21202 .37642 .22033 .3892 .22928 .42705 .2208 .41495 Metetra
.879 .469 .034 r
.2208 .41495 .22928 .42705 .23954 .45448 .23085 .44373 Metetra
0 0 .535 r
.23085 .44373 .23954 .45448 .25147 .46544 .24261 .45649 Metetra
.707 .762 .895 r
.24261 .45649 .25147 .46544 .26514 .45686 .25617 .44981 Metetra
.905 .791 .724 r
.25617 .44981 .26514 .45686 .28026 .42947 .27127 .42403 Metetra
.942 .78 .653 r
.27127 .42403 .28026 .42947 .29629 .38765 .28739 .38322 Metetra
.953 .775 .624 r
.28739 .38322 .29629 .38765 .31259 .33821 .30385 .33406 Metetra
.956 .776 .619 r
.30385 .33406 .31259 .33821 .32859 .28886 .32007 .28424 Metetra
.953 .783 .635 r
.32007 .28424 .32859 .28886 .34387 .24669 .33557 .24097 Metetra
.935 .797 .684 r
.33557 .24097 .34387 .24669 .3582 .21721 .35011 .20997 Metetra
.855 .81 .805 r
.35011 .20997 .3582 .21721 .37157 .20386 .36364 .19489 Metetra
.316 .583 .938 r
.36364 .19489 .37157 .20386 .38413 .20782 .37629 .19713 Metetra
.65 .202 0 r
.37629 .19713 .38413 .20782 .39614 .22795 .38833 .21578 Metetra
.85 .442 0 r
.38833 .21578 .39614 .22795 .40795 .26084 .4001 .24765 Metetra
.888 .5 .047 r
.4001 .24765 .40795 .26084 .4199 .30099 .41197 .28741 Metetra
.883 .495 .035 r
.41197 .28741 .4199 .30099 .4323 .34127 .42427 .32807 Metetra
.827 .423 0 r
.42427 .32807 .4323 .34127 .44537 .37391 .43723 .36182 Metetra
0 0 .416 r
.43723 .36182 .44537 .37391 .45913 .39195 .45092 .38154 Metetra
.423 .624 .936 r
.45092 .38154 .45913 .39195 .47348 .39088 .46527 .38242 Metetra
.879 .812 .779 r
.46527 .38242 .47348 .39088 .48817 .36991 .48002 .36323 Metetra
.954 .804 .658 r
.48002 .36323 .48817 .36991 .5029 .33212 .49489 .32674 Metetra
.972 .795 .604 r
.49489 .32674 .5029 .33212 .51744 .2837 .50961 .2789 Metetra
.978 .792 .586 r
.50961 .2789 .51744 .2837 .53165 .23234 .524 .22735 Metetra
.977 .797 .595 r
.524 .22735 .53165 .23234 .54553 .18563 .53805 .17975 Metetra
.966 .811 .638 r
.53805 .17975 .54553 .18563 .55923 .14985 .55187 .14257 Metetra
.918 .83 .742 r
.55187 .14257 .55923 .14985 .57295 .12932 .56567 .12034 Metetra
.654 .757 .925 r
.56567 .12034 .57295 .12932 .58697 .12611 .5797 .11535 Metetra
0 .182 .711 r
.5797 .11535 .58697 .12611 .60151 .13999 .5942 .12761 Metetra
.643 .236 0 r
.5942 .12761 .60151 .13999 .61677 .16844 .60938 .1548 Metetra
.752 .361 0 r
.60938 .1548 .61677 .16844 .63277 .2067 .62529 .19238 Metetra
.766 .381 0 r
.62529 .19238 .63277 .2067 .64941 .24812 .64186 .23386 Metetra
.715 .327 0 r
.64186 .23386 .64941 .24812 .66639 .28494 .65881 .2715 Metetra
0 0 .438 r
.65881 .2715 .66639 .28494 .68325 .30951 .67572 .29758 Metetra
.098 .389 .847 r
.67572 .29758 .68325 .30951 .6995 .31607 .6921 .30604 Metetra
.794 .806 .862 r
.6921 .30604 .6995 .31607 .71471 .3022 .70751 .2941 Metetra
.957 .833 .679 r
.70751 .2941 .71471 .3022 .72869 .26957 .72171 .26302 Metetra
.988 .816 .582 r
.72171 .26302 .72869 .26957 .74151 .22341 .73477 .21774 Metetra
.853 .754 .753 r
.04017 .51442 .04958 .52308 .06335 .50914 .0548 .49473 Metetra
.866 .694 .666 r
.0548 .49473 .06335 .50914 .07948 .47761 .07165 .4587 Metetra
.865 .67 .638 r
.07165 .4587 .07948 .47761 .09711 .43365 .08972 .41222 Metetra
.86 .659 .629 r
.08972 .41222 .09711 .43365 .11518 .38437 .10795 .36274 Metetra
.853 .655 .634 r
.10795 .36274 .11518 .38437 .13271 .33732 .12534 .31764 Metetra
.839 .656 .654 r
.12534 .31764 .13271 .33732 .14892 .29913 .14118 .28311 Metetra
.804 .664 .708 r
.14118 .28311 .14892 .29913 .16332 .2747 .15508 .26343 Metetra
.599 .654 .875 r
.15508 .26343 .16332 .2747 .17576 .26679 .16695 .26069 Metetra
.754 .245 0 r
.16695 .26069 .17576 .26679 .18638 .2759 .17701 .27468 Metetra
.884 .486 .268 r
.17701 .27468 .18638 .2759 .19555 .30022 .18572 .30292 Metetra
.885 .52 .348 r
.18572 .30292 .19555 .30022 .20385 .33573 .19374 .34073 Metetra
.878 .52 .364 r
.19374 .34073 .20385 .33573 .21202 .37642 .20183 .38162 Metetra
.867 .497 .344 r
.20183 .38162 .21202 .37642 .2208 .41495 .21078 .41801 Metetra
.835 .42 .252 r
.21078 .41801 .2208 .41495 .23085 .44373 .22121 .44253 Metetra
.521 0 0 r
.22121 .44253 .23085 .44373 .24261 .45649 .23349 .44959 Metetra
.825 .821 .845 r
.23349 .44959 .24261 .45649 .25617 .44981 .24761 .43686 Metetra
.879 .722 .683 r
.24761 .43686 .25617 .44981 .27127 .42403 .26321 .40589 Metetra
.88 .686 .635 r
.26321 .40589 .27127 .42403 .28739 .38322 .27969 .36167 Metetra
.877 .67 .619 r
.27969 .36167 .28739 .38322 .30385 .33406 .29636 .31138 Metetra
.87 .662 .619 r
.29636 .31138 .30385 .33406 .32007 .28424 .3126 .26273 Metetra
.858 .661 .634 r
.3126 .26273 .32007 .28424 .33557 .24097 .32799 .22257 Metetra
.832 .666 .677 r
.32799 .22257 .33557 .24097 .35011 .20997 .34233 .19604 Metetra
.736 .673 .789 r
.34233 .19604 .35011 .20997 .36364 .19489 .35562 .18611 Metetra
0 .31 .79 r
.35562 .18611 .36364 .19489 .37629 .19713 .36802 .19349 Metetra
.845 .381 .052 r
.36802 .19349 .37629 .19713 .38833 .21578 .37985 .21657 Metetra
.886 .479 .237 r
.37985 .21657 .38833 .21578 .4001 .24765 .39147 .25149 Metetra
.886 .495 .284 r
.39147 .25149 .4001 .24765 .41197 .28741 .40327 .29235 Metetra
.876 .48 .279 r
.40327 .29235 .41197 .28741 .42427 .32807 .41559 .33177 Metetra
.849 .423 .215 r
.41559 .33177 .42427 .32807 .43723 .36182 .42865 .36198 Metetra
.711 .181 0 r
.42865 .36198 .43723 .36182 .45092 .38154 .44251 .37636 Metetra
.634 .864 .985 r
.44251 .37636 .45092 .38154 .46527 .38242 .45703 .37107 Metetra
.887 .764 .721 r
.45703 .37107 .46527 .38242 .48002 .36323 .47196 .34612 Metetra
.898 .708 .637 r
.47196 .34612 .48002 .36323 .49489 .32674 .48698 .30536 Metetra
.896 .683 .607 r
.48698 .30536 .49489 .32674 .50961 .2789 .50181 .25545 Metetra
.89 .672 .601 r
.50181 .25545 .50961 .2789 .524 .22735 .5163 .20422 Metetra
.879 .668 .612 r
.5163 .20422 .524 .22735 .53805 .17975 .53045 .15907 Metetra
.858 .67 .647 r
.53045 .15907 .53805 .17975 .55187 .14257 .54437 .12596 Metetra
.798 .678 .732 r
.54437 .12596 .55187 .14257 .56567 .12034 .55828 .10875 Metetra
.471 .608 .906 r
.55828 .10875 .56567 .12034 .5797 .11535 .57244 .10905 Metetra
.623 .112 0 r
.57244 .10905 .5797 .11535 .5942 .12761 .58707 .12615 Metetra
.85 .39 .049 r
.58707 .12615 .5942 .12761 .60938 .1548 .60235 .15705 Metetra
.877 .444 .158 r
.60235 .15705 .60938 .1548 .62529 .19238 .61834 .19659 Metetra
.873 .444 .178 r
.61834 .19659 .62529 .19238 .64186 .23386 .63492 .23777 Metetra
.85 .401 .136 r
.63492 .23777 .64186 .23386 .65881 .2715 .65178 .27271 Metetra
.759 .245 0 r
.65178 .27271 .65881 .2715 .67572 .29758 .66852 .29398 Metetra
.052 .58 .865 r
.66852 .29398 .67572 .29758 .6921 .30604 .68464 .29636 Metetra
.873 .826 .798 r
.68464 .29636 .6921 .30604 .70751 .2941 .69978 .27824 Metetra
.917 .739 .647 r
.69978 .27824 .70751 .2941 .72171 .26302 .71377 .24211 Metetra
.917 .701 .595 r
.71377 .24211 .72171 .26302 .73477 .21774 .72671 .19381 Metetra
.846 .681 .678 r
.03173 .49857 .04017 .51442 .0548 .49473 .04805 .4676 Metetra
.827 .628 .633 r
.04805 .4676 .0548 .49473 .07165 .4587 .06604 .42387 Metetra
.814 .604 .618 r
.06604 .42387 .07165 .4587 .08972 .41222 .08458 .37448 Metetra
.802 .59 .615 r
.08458 .37448 .08972 .41222 .10795 .36274 .1026 .327 Metetra
.787 .582 .623 r
.1026 .327 .10795 .36274 .12534 .31764 .11923 .28815 Metetra
.76 .578 .65 r
.11923 .28815 .12534 .31764 .14118 .28311 .13394 .26292 Metetra
.681 .575 .73 r
.13394 .26292 .14118 .28311 .15508 .26343 .14652 .25417 Metetra
0 .166 .676 r
.14652 .25417 .15508 .26343 .16695 .26069 .15709 .26251 Metetra
.847 .44 .268 r
.15709 .26251 .16695 .26069 .17701 .27468 .16604 .28623 Metetra
.831 .477 .385 r
.16604 .28623 .17701 .27468 .18572 .30292 .17398 .32139 Metetra
.815 .475 .413 r
.17398 .32139 .18572 .30292 .19374 .34073 .1817 .36206 Metetra
.797 .457 .412 r
.1817 .36206 .19374 .34073 .20183 .38162 .19001 .40092 Metetra
.769 .413 .381 r
.19001 .40092 .20183 .38162 .21078 .41801 .19967 .43033 Metetra
.687 .272 .254 r
.19967 .43033 .21078 .41801 .22121 .44253 .21118 .44391 Metetra
.486 .901 .867 r
.21118 .44391 .22121 .44253 .23349 .44959 .22469 .43805 Metetra
.869 .737 .715 r
.22469 .43805 .23349 .44959 .24761 .43686 .23995 .41293 Metetra
.845 .649 .637 r
.23995 .41293 .24761 .43686 .26321 .40589 .2564 .3725 Metetra
.828 .614 .612 r
.2564 .3725 .26321 .40589 .27969 .36167 .27333 .32335 Metetra
.815 .595 .605 r
.27333 .32335 .27969 .36167 .29636 .31138 .29003 .27321 Metetra
.8 .584 .61 r
.29003 .27321 .29636 .31138 .3126 .26273 .30597 .22936 Metetra
.778 .578 .63 r
.30597 .22936 .3126 .26273 .32799 .22257 .32084 .19759 Metetra
.728 .577 .685 r
.32084 .19759 .32799 .22257 .34233 .19604 .33454 .18166 Metetra
.449 .531 .849 r
.33454 .18166 .34233 .19604 .35562 .18611 .34718 .18307 Metetra
.794 .298 0 r
.34718 .18307 .35562 .18611 .36802 .19349 .35904 .20102 Metetra
.84 .441 .29 r
.35904 .20102 .36802 .19349 .37985 .21657 .37047 .23241 Metetra
.825 .456 .355 r
.37047 .23241 .37985 .21657 .39147 .25149 .38191 .272 Metetra
.808 .445 .37 r
.38191 .272 .39147 .25149 .40327 .29235 .39375 .31284 Metetra
.783 .411 .353 r
.39375 .31284 .40327 .29235 .41559 .33177 .40632 .34711 Metetra
.727 .32 .277 r
.40632 .34711 .41559 .33177 .42865 .36198 .41976 .36759 Metetra
.352 0 0 r
.41976 .36759 .42865 .36198 .44251 .37636 .43404 .36931 Metetra
.885 .841 .796 r
.43404 .36931 .44251 .37636 .45703 .37107 .44894 .35088 Metetra
.867 .681 .649 r
.44894 .35088 .45703 .37107 .47196 .34612 .46413 .3149 Metetra
.846 .628 .607 r
.46413 .3149 .47196 .34612 .48698 .30536 .47929 .26722 Metetra
.83 .602 .594 r
.47929 .26722 .48698 .30536 .50181 .25545 .49417 .21547 Metetra
.814 .588 .595 r
.49417 .21547 .50181 .25545 .5163 .20422 .50868 .16737 Metetra
.794 .58 .611 r
.50868 .16737 .5163 .20422 .53045 .15907 .52284 .12947 Metetra
.757 .577 .653 r
.52284 .12947 .53045 .15907 .54437 .12596 .53683 .10639 Metetra
.635 .571 .765 r
.53683 .10639 .54437 .12596 .55828 .10875 .55087 .10054 Metetra
0 .151 .657 r
.55087 .10054 .55828 .10875 .57244 .10905 .56522 .11201 Metetra
.825 .361 .11 r
.56522 .11201 .57244 .10905 .58707 .12615 .58008 .1386 Metetra
.831 .42 .264 r
.58008 .1386 .58707 .12615 .60235 .15705 .59559 .17586 Metetra
.816 .422 .305 r
.59559 .17586 .60235 .15705 .61834 .19659 .61173 .21736 Metetra
.793 .398 .305 r
.61173 .21736 .61834 .19659 .63492 .23777 .6283 .25538 Metetra
.749 .332 .258 r
.6283 .25538 .63492 .23777 .65178 .27271 .64495 .28214 Metetra
.586 .089 .04 r
.64495 .28214 .65178 .27271 .66852 .29398 .66126 .29144 Metetra
.768 .977 .916 r
.66126 .29144 .66852 .29398 .68464 .29636 .67681 .28032 Metetra
.894 .735 .677 r
.67681 .28032 .68464 .29636 .69978 .27824 .69134 .24986 Metetra
.868 .649 .604 r
.69134 .24986 .69978 .27824 .71377 .24211 .70484 .20488 Metetra
.848 .612 .581 r
.70484 .20488 .71377 .24211 .72671 .19381 .71754 .15268 Metetra
.811 .609 .63 r
.02556 .46741 .03173 .49857 .04805 .4676 .04366 .42463 Metetra
.791 .576 .611 r
.04366 .42463 .04805 .4676 .06604 .42387 .06248 .37541 Metetra
.774 .557 .605 r
.06248 .37541 .06604 .42387 .08458 .37448 .08087 .32733 Metetra
.757 .544 .609 r
.08087 .32733 .08458 .37448 .1026 .327 .09789 .28727 Metetra
.73 .535 .627 r
.09789 .28727 .1026 .327 .11923 .28815 .11294 .26041 Metetra
.667 .524 .68 r
.11294 .26041 .11923 .28815 .13394 .26292 .12576 .24987 Metetra
.08 .334 .81 r
.12576 .24987 .13394 .26292 .14652 .25417 .13643 .25646 Metetra
.836 .426 .264 r
.13643 .25646 .14652 .25417 .15709 .26251 .14532 .27873 Metetra
.805 .458 .399 r
.14532 .27873 .15709 .26251 .16604 .28623 .15306 .31296 Metetra
.782 .452 .43 r
.15306 .31296 .16604 .28623 .17398 .32139 .16043 .35341 Metetra
.76 .433 .432 r
.16043 .35341 .17398 .32139 .1817 .36206 .16833 .39284 Metetra
.73 .395 .412 r
.16833 .39284 .1817 .36206 .19001 .40092 .17756 .42358 Metetra
.663 .295 .338 r
.17756 .42358 .19001 .40092 .19967 .43033 .18871 .43902 Metetra
.109 0 0 r
.18871 .43902 .19967 .43033 .21118 .44391 .20199 .43521 Metetra
.882 .774 .737 r
.20199 .43521 .21118 .44391 .22469 .43805 .2172 .41193 Metetra
.831 .635 .637 r
.2172 .41193 .22469 .43805 .23995 .41293 .23377 .37275 Metetra
.805 .587 .607 r
.23377 .37275 .23995 .41293 .2564 .3725 .25095 .32409 Metetra
.786 .562 .597 r
.25095 .32409 .2564 .3725 .27333 .32335 .268 .27363 Metetra
.768 .546 .598 r
.268 .27363 .27333 .32335 .29003 .27321 .28429 .22876 Metetra
.745 .535 .611 r
.28429 .22876 .29003 .27321 .30597 .22936 .29945 .19548 Metetra
.701 .527 .649 r
.29945 .19548 .30597 .22936 .32084 .19759 .31333 .17777 Metetra
.524 .498 .77 r
.31333 .17777 .32084 .19759 .33454 .18166 .32602 .17736 Metetra
.763 .252 0 r
.32602 .17736 .33454 .18166 .34718 .18307 .33778 .19369 Metetra
.818 .426 .311 r
.33778 .19369 .34718 .18307 .35904 .20102 .34898 .2239 Metetra
.792 .435 .381 r
.34898 .2239 .35904 .20102 .37047 .23241 .36008 .26296 Metetra
.769 .423 .398 r
.36008 .26296 .37047 .23241 .38191 .272 .37154 .30404 Metetra
.742 .393 .39 r
.37154 .30404 .38191 .272 .39375 .31284 .38372 .33937 Metetra
.692 .324 .345 r
.38372 .33937 .39375 .31284 .40632 .34711 .39686 .36157 Metetra
.496 .054 .129 r
.39686 .36157 .40632 .34711 .41976 .36759 .41098 .36535 Metetra
.892 .943 .837 r
.41098 .36535 .41976 .36759 .43404 .36931 .42589 .34892 Metetra
.86 .678 .654 r
.42589 .34892 .43404 .36931 .44894 .35088 .44125 .31447 Metetra
.823 .603 .604 r
.44125 .31447 .44894 .35088 .46413 .3149 .45669 .2676 Metetra
.799 .568 .588 r
.45669 .2676 .46413 .3149 .47929 .26722 .47191 .21583 Metetra
.78 .549 .586 r
.47191 .21583 .47929 .26722 .49417 .21547 .48673 .16696 Metetra
.758 .536 .595 r
.48673 .16696 .49417 .21547 .50868 .16737 .50114 .1277 Metetra
.724 .527 .624 r
.50114 .1277 .50868 .16737 .52284 .12947 .51525 .1029 Metetra
.634 .518 .703 r
.51525 .1029 .52284 .12947 .53683 .10639 .52927 .09519 Metetra
0 .279 .782 r
.52927 .09519 .53683 .10639 .55087 .10054 .54346 .10491 Metetra
.812 .35 .131 r
.54346 .10491 .55087 .10054 .56522 .11201 .55803 .1301 Metetra
.801 .405 .303 r
.55803 .1301 .56522 .11201 .58008 .1386 .57317 .16652 Metetra
.778 .404 .347 r
.57317 .16652 .58008 .1386 .59559 .17586 .5889 .20794 Metetra
.752 .382 .354 r
.5889 .20794 .59559 .17586 .61173 .21736 .60512 .24671 Metetra
.711 .331 .329 r
.60512 .24671 .61173 .21736 .6283 .25538 .62153 .27496 Metetra
.603 .184 .22 r
.62153 .27496 .6283 .25538 .64495 .28214 .63776 .28627 Metetra
.353 .789 .613 r
.63776 .28627 .64495 .28214 .66126 .29144 .65341 .27726 Metetra
.9 .756 .693 r
.65341 .27726 .66126 .29144 .67681 .28032 .66819 .24858 Metetra
.847 .628 .605 r
.66819 .24858 .67681 .28032 .69134 .24986 .68204 .20474 Metetra
.817 .578 .578 r
.68204 .20474 .69134 .24986 .70484 .20488 .69511 .15284 Metetra
.794 .552 .571 r
.69511 .15284 .70484 .20488 .71754 .15268 .70777 .10091 Metetra
.782 .567 .608 r
.02178 .42123 .02556 .46741 .04366 .42463 .04088 .37197 Metetra
.764 .546 .602 r
.04088 .37197 .04366 .42463 .06248 .37541 .05956 .3238 Metetra
.746 .532 .604 r
.05956 .3238 .06248 .37541 .08087 .32733 .07682 .28361 Metetra
.719 .52 .62 r
.07682 .28361 .08087 .32733 .09789 .28727 .09202 .2566 Metetra
.657 .506 .667 r
.09202 .2566 .09789 .28727 .11294 .26041 .10487 .2459 Metetra
.137 .339 .801 r
.10487 .2459 .11294 .26041 .12576 .24987 .11546 .25236 Metetra
.834 .426 .269 r
.11546 .25236 .12576 .24987 .13643 .25646 .12414 .27452 Metetra
.796 .452 .405 r
.12414 .27452 .13643 .25646 .14532 .27873 .13158 .30869 Metetra
.77 .444 .435 r
.13158 .30869 .14532 .27873 .15306 .31296 .13861 .34914 Metetra
.747 .425 .437 r
.13861 .34914 .15306 .31296 .16043 .35341 .14616 .38862 Metetra
.717 .387 .419 r
.14616 .38862 .16043 .35341 .16833 .39284 .1551 .41947 Metetra
.65 .293 .353 r
.1551 .41947 .16833 .39284 .17756 .42358 .16605 .43505 Metetra
.196 0 0 r
.16605 .43505 .17756 .42358 .18871 .43902 .17928 .43137 Metetra
.889 .787 .742 r
.17928 .43137 .18871 .43902 .20199 .43521 .19458 .40819 Metetra
.827 .63 .636 r
.19458 .40819 .20199 .43521 .2172 .41193 .21136 .36906 Metetra
.797 .578 .605 r
.21136 .36906 .2172 .41193 .23377 .37275 .22884 .32038 Metetra
.776 .551 .594 r
.22884 .32038 .23377 .37275 .25095 .32409 .24618 .26985 Metetra
.756 .533 .594 r
.24618 .26985 .25095 .32409 .268 .27363 .26275 .22486 Metetra
.733 .521 .605 r
.26275 .22486 .268 .27363 .28429 .22876 .27809 .19143 Metetra
.69 .51 .639 r
.27809 .19143 .28429 .22876 .29945 .19548 .29206 .17356 Metetra
.527 .48 .747 r
.29206 .17356 .29945 .19548 .31333 .17777 .3047 .173 Metetra
.76 .25 0 r
.3047 .173 .31333 .17777 .32602 .17736 .31628 .18921 Metetra
.81 .423 .32 r
.31628 .18921 .32602 .17736 .33778 .19369 .32721 .21933 Metetra
.781 .429 .389 r
.32721 .21933 .33778 .19369 .34898 .2239 .33796 .25836 Metetra
.756 .415 .406 r
.33796 .25836 .34898 .2239 .36008 .26296 .34905 .29947 Metetra
.728 .385 .399 r
.34905 .29947 .36008 .26296 .37154 .30404 .3609 .33488 Metetra
.678 .32 .36 r
.3609 .33488 .37154 .30404 .38372 .33937 .37381 .35721 Metetra
.503 .085 .18 r
.37381 .35721 .38372 .33937 .39686 .36157 .38783 .36113 Metetra
.886 .972 .833 r
.38783 .36113 .39686 .36157 .41098 .36535 .40278 .34481 Metetra
.859 .677 .655 r
.40278 .34481 .41098 .36535 .42589 .34892 .41833 .31043 Metetra
.815 .594 .603 r
.41833 .31043 .42589 .34892 .44125 .31447 .43405 .26357 Metetra
.789 .557 .585 r
.43405 .26357 .44125 .31447 .45669 .2676 .44958 .21175 Metetra
.768 .535 .582 r
.44958 .21175 .45669 .2676 .47191 .21583 .46471 .16278 Metetra
.745 .521 .591 r
.46471 .16278 .47191 .21583 .48673 .16696 .47934 .12338 Metetra
.711 .511 .616 r
.47934 .12338 .48673 .16696 .50114 .1277 .49358 .09841 Metetra
.627 .499 .687 r
.49358 .09841 .50114 .1277 .51525 .1029 .50759 .09054 Metetra
0 .289 .788 r
.50759 .09054 .51525 .1029 .52927 .09519 .52164 .10012 Metetra
.81 .352 .144 r
.52164 .10012 .52927 .09519 .54346 .10491 .53596 .1252 Metetra
.791 .401 .316 r
.53596 .1252 .54346 .10491 .55803 .1301 .55075 .16157 Metetra
.765 .397 .359 r
.55075 .16157 .55803 .1301 .57317 .16652 .56611 .20298 Metetra
.737 .375 .366 r
.56611 .20298 .57317 .16652 .5889 .20794 .58196 .24181 Metetra
.696 .327 .345 r
.58196 .24181 .5889 .20794 .60512 .24671 .5981 .27018 Metetra
.595 .195 .253 r
.5981 .27018 .60512 .24671 .62153 .27496 .61417 .28162 Metetra
.61417 .28162 .62153 .27496 .63776 .28627 .62983 .27274 Metetra
.904 .764 .696 r
.62983 .27274 .63776 .28627 .65341 .27726 .64476 .24415 Metetra
.84 .62 .604 r
.64476 .24415 .65341 .27726 .66819 .24858 .65887 .20034 Metetra
.806 .566 .576 r
.65887 .20034 .66819 .24858 .68204 .20474 .67227 .14842 Metetra
.781 .538 .569 r
.67227 .14842 .68204 .20474 .69511 .15284 .68525 .09639 Metetra
.757 .521 .575 r
.68525 .09639 .69511 .15284 .70777 .10091 .69827 .05163 Metetra
.772 .555 .604 r
.01871 .37156 .02178 .42123 .04088 .37197 .03773 .323 Metetra
.755 .541 .607 r
.03773 .323 .04088 .37197 .05956 .3238 .05535 .28196 Metetra
.73 .531 .622 r
.05535 .28196 .05956 .3238 .07682 .28361 .07086 .25379 Metetra
.672 .519 .669 r
.07086 .25379 .07682 .28361 .09202 .2566 .08392 .24179 Metetra
.227 .391 .818 r
.08392 .24179 .09202 .2566 .10487 .2459 .09457 .24698 Metetra
.838 .42 .244 r
.09457 .24698 .10487 .2459 .11546 .25236 .10318 .26807 Metetra
.804 .456 .398 r
.10318 .26807 .11546 .25236 .12414 .27452 .1104 .30154 Metetra
.78 .451 .431 r
.1104 .30154 .12414 .27452 .13158 .30869 .1171 .34177 Metetra
.758 .432 .434 r
.1171 .34177 .13158 .30869 .13861 .34914 .12424 .38161 Metetra
.729 .396 .417 r
.12424 .38161 .13861 .34914 .14616 .38862 .13277 .41337 Metetra
.667 .306 .351 r
.13277 .41337 .14616 .38862 .1551 .41947 .1434 .43027 Metetra
.254 0 0 r
.1434 .43027 .1551 .41947 .16605 .43505 .15641 .42807 Metetra
.888 .799 .755 r
.15641 .42807 .16605 .43505 .17928 .43137 .17167 .40622 Metetra
.832 .639 .641 r
.17167 .40622 .17928 .43137 .19458 .40819 .18858 .36802 Metetra
.804 .587 .608 r
.18858 .36802 .19458 .40819 .21136 .36906 .20631 .31973 Metetra
.784 .56 .596 r
.20631 .31973 .21136 .36906 .22884 .32038 .22399 .26901 Metetra
.766 .543 .596 r
.22399 .26901 .22884 .32038 .24618 .26985 .24089 .22332 Metetra
.743 .531 .607 r
.24089 .22332 .24618 .26985 .26275 .22486 .25652 .18882 Metetra
.703 .522 .641 r
.25652 .18882 .26275 .22486 .27809 .19143 .27066 .16967 Metetra
.554 .498 .747 r
.27066 .16967 .27809 .19143 .29206 .17356 .28335 .16779 Metetra
.724 .206 0 r
.28335 .16779 .29206 .17356 .3047 .173 .29484 .18281 Metetra
.818 .424 .305 r
.29484 .18281 .3047 .173 .31628 .18921 .30554 .21204 Metetra
.791 .434 .382 r
.30554 .21204 .31628 .18921 .32721 .21933 .31596 .25064 Metetra
.767 .422 .4 r
.31596 .25064 .32721 .21933 .33796 .25836 .32665 .29187 Metetra
.74 .393 .394 r
.32665 .29187 .33796 .25836 .34905 .29947 .33812 .32799 Metetra
.693 .33 .354 r
.33812 .32799 .34905 .29947 .3609 .33488 .35072 .35152 Metetra
.529 .102 .175 r
.35072 .35152 .3609 .33488 .37381 .35721 .36456 .35691 Metetra
.862 .98 .853 r
.36456 .35691 .37381 .35721 .38783 .36113 .3795 .34204 Metetra
.863 .687 .662 r
.3795 .34204 .38783 .36113 .40278 .34481 .39519 .3088 Metetra
.822 .604 .607 r
.39519 .3088 .40278 .34481 .41833 .31043 .41119 .26256 Metetra
.798 .567 .588 r
.41119 .26256 .41833 .31043 .43405 .26357 .42706 .21077 Metetra
.778 .546 .584 r
.42706 .21077 .43405 .26357 .44958 .21175 .44251 .16127 Metetra
.756 .532 .592 r
.44251 .16127 .44958 .21175 .46471 .16278 .45741 .12091 Metetra
.723 .522 .618 r
.45741 .12091 .46471 .16278 .47934 .12338 .47179 .09471 Metetra
.644 .513 .689 r
.47179 .09471 .47934 .12338 .49358 .09841 .48582 .0855 Metetra
.068 .338 .815 r
.48582 .0855 .49358 .09841 .50759 .09054 .49974 .0938 Metetra
.81 .342 .111 r
.49974 .0938 .50759 .09054 .52164 .10012 .5138 .11783 Metetra
.8 .404 .303 r
.5138 .11783 .52164 .10012 .53596 .1252 .52824 .15355 Metetra
.776 .403 .35 r
.52824 .15355 .53596 .1252 .55075 .16157 .54319 .19485 Metetra
.749 .382 .358 r
.54319 .19485 .55075 .16157 .56611 .20298 .55867 .23416 Metetra
.71 .335 .336 r
.55867 .23416 .56611 .20298 .58196 .24181 .57452 .26357 Metetra
.614 .204 .243 r
.57452 .26357 .58196 .24181 .5981 .27018 .59047 .27642 Metetra
.59047 .27642 .5981 .27018 .61417 .28162 .60615 .26906 Metetra
.906 .777 .708 r
.60615 .26906 .61417 .28162 .62983 .27274 .62128 .24177 Metetra
.847 .631 .609 r
.62128 .24177 .62983 .27274 .64476 .24415 .6357 .19881 Metetra
.815 .577 .579 r
.6357 .19881 .64476 .24415 .65887 .20034 .64945 .14715 Metetra
.791 .549 .571 r
.64945 .14715 .65887 .20034 .67227 .14842 .66277 .09481 Metetra
.769 .532 .576 r
.66277 .09481 .67227 .14842 .68525 .09639 .67603 .04922 Metetra
.74 .521 .597 r
.67603 .04922 .68525 .09639 .69827 .05163 .68968 .01625 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-10)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(10)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.9.6"]
}, Open  ]],

Cell["\<\
Here is the same plot, with labels for the axes, and grids added to \
each face. \
\>", "MathCaption",
  CellTags->{"S1.9.6", "6.7"}],

Cell[CellGroupData[{

Cell["\<\
Show[%, AxesLabel -> {\"Time\", \"Depth\", \"Value\"}, FaceGrids -> \
All]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.1664e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -18 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -9.92245 -9 ]
[.68156 -0.01098 2.07755 0 ]
[.29165 .07573 -26.0713 -10.125 ]
[.29165 .07573 1.92873 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 18 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 12 3.14607 ]
[.91861 .21225 0 -6.57576 ]
[.91861 .21225 34 3.23674 ]
[.02411 .26511 -18 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -12 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -6 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -12 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[-0.05457 .39542 -34 -3.08918 ]
[-0.05457 .39542 0 6.72332 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-10)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(10)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -87.0713 -14.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Time) show
87.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-10)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(10)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -10.5758 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Depth) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(-10)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(-5)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(5)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(10)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
gsave
-0.05457 .39542 -95 -7.08918 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Value) show
93.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.4 g
.25 Mabswid
.03634 .26033 m
.40512 .60371 L
s
.02795 .31328 m
.40343 .65209 L
s
.01926 .36808 m
.40169 .70185 L
s
.01027 .42483 m
.3999 .75306 L
s
.00095 .48363 m
.39806 .80578 L
s
.03716 .25514 m
0 .48963 L
s
.14311 .35409 m
.1156 .58304 L
s
.23889 .44355 m
.21934 .66687 L
s
.3259 .52481 m
.31296 .74252 L
s
.40529 .59895 m
.39787 .81114 L
s
0 g
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.4 g
.68874 0 m
.70298 .24544 L
s
.7708 .12553 m
.79088 .36619 L
s
.84407 .23761 m
.86863 .47301 L
s
.9099 .3383 m
.9379 .56818 L
s
.96935 .42924 m
1 .6535 L
s
.68905 .00539 m
.97003 .43424 L
s
.69224 .06041 m
.97699 .48513 L
s
.69556 .11761 m
.98416 .53763 L
s
.69902 .17712 m
.99157 .59183 L
s
.70262 .2391 m
.99922 .6478 L
s
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.4 g
.03634 .26033 m
.68905 .00539 L
s
.02795 .31328 m
.69224 .06041 L
s
.01926 .36808 m
.69556 .11761 L
s
.01027 .42483 m
.69902 .17712 L
s
.00095 .48363 m
.70262 .2391 L
s
.03716 .25514 m
0 .48963 L
s
.18558 .19702 m
.15891 .43443 L
s
.34306 .13535 m
.3283 .37559 L
s
.51046 .06981 m
.50925 .31274 L
s
.68874 0 m
.70298 .24544 L
s
0 g
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.4 g
.40529 .59895 m
.39787 .81114 L
s
.53602 .55961 m
.53673 .77478 L
s
.67327 .51832 m
.68296 .7365 L
s
.81753 .47492 m
.83716 .69613 L
s
.96935 .42924 m
1 .6535 L
s
.40512 .60371 m
.97003 .43424 L
s
.40343 .65209 m
.97699 .48513 L
s
.40169 .70185 m
.98416 .53763 L
s
.3999 .75306 m
.99157 .59183 L
s
.39806 .80578 m
.99922 .6478 L
s
0 g
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.4 g
.03716 .25514 m
.40529 .59895 L
s
.18558 .19702 m
.53602 .55961 L
s
.34306 .13535 m
.67327 .51832 L
s
.51046 .06981 m
.81753 .47492 L
s
.68874 0 m
.96935 .42924 L
s
.03716 .25514 m
.68874 0 L
s
.14311 .35409 m
.7708 .12553 L
s
.23889 .44355 m
.84407 .23761 L
s
.3259 .52481 m
.9099 .3383 L
s
.40529 .59895 m
.96935 .42924 L
s
0 .48963 m
.39787 .81114 L
s
.15891 .43443 m
.53673 .77478 L
s
.3283 .37559 m
.68296 .7365 L
s
.50925 .31274 m
.83716 .69613 L
s
.70298 .24544 m
1 .6535 L
s
0 .48963 m
.70298 .24544 L
s
.1156 .58304 m
.79088 .36619 L
s
.21934 .66687 m
.86863 .47301 L
s
.31296 .74252 m
.9379 .56818 L
s
.39787 .81114 m
1 .6535 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.793 .598 .637 r
.3927 .76593 .39843 .79509 .41029 .76604 .40491 .72665 Metetra
.774 .572 .626 r
.40491 .72665 .41029 .76604 .42235 .72622 .41709 .68257 Metetra
.759 .557 .623 r
.41709 .68257 .42235 .72622 .43434 .68212 .42901 .64054 Metetra
.743 .547 .629 r
.42901 .64054 .43434 .68212 .44606 .64055 .44053 .60667 Metetra
.718 .538 .646 r
.44053 .60667 .44606 .64055 .45741 .60753 .45163 .58552 Metetra
.654 .528 .698 r
.45163 .58552 .45741 .60753 .46841 .58749 .46237 .57967 Metetra
0 .156 .686 r
.46237 .57967 .46841 .58749 .47914 .58284 .4729 .58954 Metetra
.826 .474 .391 r
.4729 .58954 .47914 .58284 .48974 .59383 .48339 .61333 Metetra
.79 .487 .476 r
.48339 .61333 .48974 .59383 .50038 .61852 .494 .64719 Metetra
.768 .481 .498 r
.494 .64719 .50038 .61852 .5112 .65289 .50487 .68546 Metetra
.75 .466 .501 r
.50487 .68546 .5112 .65289 .5223 .6912 .51606 .72138 Metetra
.725 .436 .489 r
.51606 .72138 .5223 .6912 .53371 .72663 .52754 .74814 Metetra
.67 .36 .44 r
.52754 .74814 .53371 .72663 .54535 .75244 .5392 .76019 Metetra
.166 0 0 r
.5392 .76019 .54535 .75244 .5571 .76323 .55088 .75461 Metetra
.866 .729 .709 r
.55088 .75461 .5571 .76323 .56877 .75633 .56242 .73181 Metetra
.81 .617 .641 r
.56242 .73181 .56877 .75633 .58021 .73239 .57369 .69545 Metetra
.785 .58 .622 r
.57369 .69545 .58021 .73239 .5913 .69529 .58465 .65151 Metetra
.768 .56 .617 r
.58465 .65151 .5913 .69529 .60206 .65112 .59538 .60697 Metetra
.752 .548 .62 r
.59538 .60697 .60206 .65112 .6126 .60687 .60602 .56847 Metetra
.731 .539 .633 r
.60602 .56847 .6126 .60687 .62309 .56909 .61678 .54131 Metetra
.689 .532 .668 r
.61678 .54131 .62309 .56909 .63377 .54297 .62788 .52892 Metetra
.483 .494 .792 r
.62788 .52892 .63377 .54297 .64488 .53179 .63952 .53259 Metetra
.837 .394 .175 r
.63952 .53259 .64488 .53179 .65662 .53665 .65182 .5514 Metetra
.805 .471 .424 r
.65182 .5514 .65662 .53665 .66909 .55648 .66482 .58223 Metetra
.779 .473 .469 r
.66482 .58223 .66909 .55648 .68231 .58801 .67841 .62002 Metetra
.759 .462 .482 r
.67841 .62002 .68231 .58801 .69616 .62603 .69237 .65823 Metetra
.736 .439 .478 r
.69237 .65823 .69616 .62603 .71033 .66396 .70633 .68979 Metetra
.697 .389 .451 r
.70633 .68979 .71033 .66396 .72445 .69473 .71987 .70835 Metetra
.544 .182 .304 r
.71987 .70835 .72445 .69473 .73805 .71211 .73261 .70974 Metetra
.92 .894 .787 r
.73261 .70974 .73805 .71211 .75075 .71214 .74431 .69298 Metetra
.835 .649 .651 r
.74431 .69298 .75075 .71214 .76231 .69412 .75494 .66059 Metetra
.8 .591 .62 r
.75494 .66059 .76231 .69412 .77274 .6608 .76469 .6179 Metetra
.779 .566 .611 r
.76469 .6179 .77274 .6608 .78226 .61766 .77396 .57181 Metetra
.761 .55 .612 r
.77396 .57181 .78226 .61766 .79132 .57167 .78325 .52934 Metetra
.742 .54 .622 r
.78325 .52934 .79132 .57167 .80046 .52978 .79308 .4965 Metetra
.71 .533 .647 r
.79308 .4965 .80046 .52978 .81023 .49789 .80391 .47756 Metetra
.62 .523 .722 r
.80391 .47756 .81023 .49789 .8211 .48013 .81611 .47469 Metetra
0 .058 .57 r
.81611 .47469 .8211 .48013 .83342 .47849 .82984 .48782 Metetra
.822 .437 .323 r
.82984 .48782 .83342 .47849 .84736 .49275 .84506 .51467 Metetra
.791 .459 .425 r
.84506 .51467 .84736 .49275 .86285 .52046 .86151 .55086 Metetra
.769 .454 .454 r
.86151 .55086 .86285 .52046 .87957 .55709 .87865 .59026 Metetra
.746 .437 .46 r
.87865 .59026 .87957 .55709 .89695 .59642 .89576 .62574 Metetra
.714 .401 .446 r
.89576 .62574 .89695 .59642 .91423 .63129 .91203 .65036 Metetra
.634 .295 .379 r
.91203 .65036 .91423 .63129 .93054 .65484 .92671 .65882 Metetra
.92671 .65882 .93054 .65484 .94514 .66196 .93934 .64873 Metetra
.875 .71 .675 r
.93934 .64873 .94514 .66196 .95758 .65052 .94984 .62131 Metetra
.819 .609 .619 r
.94984 .62131 .95758 .65052 .96783 .62199 .95856 .581 Metetra
.792 .573 .604 r
.95856 .581 .96783 .62199 .97628 .58102 .96623 .5344 Metetra
.772 .553 .602 r
.96623 .5344 .97628 .58102 .98371 .53431 .97374 .48877 Metetra
.769 .566 .625 r
.3875 .72439 .3927 .76593 .40491 .72665 .39986 .68027 Metetra
.753 .55 .622 r
.39986 .68027 .40491 .72665 .41709 .68257 .41196 .63815 Metetra
.736 .539 .626 r
.41196 .63815 .41709 .68257 .42901 .64054 .42362 .60416 Metetra
.712 .53 .642 r
.42362 .60416 .42901 .64054 .44053 .60667 .43479 .58288 Metetra
.65 .518 .69 r
.43479 .58288 .44053 .60667 .45163 .58552 .44554 .5769 Metetra
0 .194 .722 r
.44554 .5769 .45163 .58552 .46237 .57967 .45599 .58665 Metetra
.823 .474 .395 r
.45599 .58665 .46237 .57967 .4729 .58954 .46633 .61036 Metetra
.784 .484 .48 r
.46633 .61036 .4729 .58954 .48339 .61333 .47674 .64419 Metetra
.762 .477 .502 r
.47674 .64419 .48339 .61333 .494 .64719 .48739 .68248 Metetra
.742 .462 .505 r
.48739 .68248 .494 .64719 .50487 .68546 .49836 .71847 Metetra
.718 .433 .494 r
.49836 .71847 .50487 .68546 .51606 .72138 .50967 .74534 Metetra
.665 .362 .45 r
.50967 .74534 .51606 .72138 .52754 .74814 .52124 .75752 Metetra
.247 0 .051 r
.52124 .75752 .52754 .74814 .5392 .76019 .53292 .75207 Metetra
.87 .735 .712 r
.53292 .75207 .5392 .76019 .55088 .75461 .54454 .72935 Metetra
.806 .613 .641 r
.54454 .72935 .55088 .75461 .56242 .73181 .55595 .69303 Metetra
.78 .574 .622 r
.55595 .69303 .56242 .73181 .57369 .69545 .56711 .64907 Metetra
.762 .554 .616 r
.56711 .64907 .57369 .69545 .58465 .65151 .57803 .60446 Metetra
.745 .541 .619 r
.57803 .60446 .58465 .65151 .59538 .60697 .58883 .56584 Metetra
.724 .532 .63 r
.58883 .56584 .59538 .60697 .60602 .56847 .5997 .53855 Metetra
.684 .523 .662 r
.5997 .53855 .60602 .56847 .61678 .54131 .61083 .52602 Metetra
.495 .486 .776 r
.61083 .52602 .61678 .54131 .62788 .52892 .62241 .52957 Metetra
.837 .394 .174 r
.62241 .52957 .62788 .52892 .63952 .53259 .63458 .54828 Metetra
.8 .47 .43 r
.63458 .54828 .63952 .53259 .65182 .5514 .64738 .57905 Metetra
.772 .469 .474 r
.64738 .57905 .65182 .5514 .66482 .58223 .66075 .61684 Metetra
.751 .458 .487 r
.66075 .61684 .66482 .58223 .67841 .62002 .67448 .6551 Metetra
.728 .436 .484 r
.67448 .6551 .67841 .62002 .69237 .65823 .68825 .68676 Metetra
.69 .388 .459 r
.68825 .68676 .69237 .65823 .70633 .68979 .70167 .70545 Metetra
.551 .204 .334 r
.70167 .70545 .70633 .68979 .71987 .70835 .71438 .70697 Metetra
.925 .919 .789 r
.71438 .70697 .71987 .70835 .73261 .70974 .72614 .69032 Metetra
.833 .647 .651 r
.72614 .69032 .73261 .70974 .74431 .69298 .7369 .65798 Metetra
.794 .586 .619 r
.7369 .65798 .74431 .69298 .75494 .66059 .74684 .6153 Metetra
.772 .559 .61 r
.74684 .6153 .75494 .66059 .76469 .6179 .75631 .56915 Metetra
.754 .543 .61 r
.75631 .56915 .76469 .6179 .77396 .57181 .76578 .52658 Metetra
.735 .533 .619 r
.76578 .52658 .77396 .57181 .78325 .52934 .77574 .49361 Metetra
.704 .524 .643 r
.77574 .49361 .78325 .52934 .79308 .4965 .78663 .47453 Metetra
.619 .513 .711 r
.78663 .47453 .79308 .4965 .80391 .47756 .79879 .47152 Metetra
0 .085 .607 r
.79879 .47152 .80391 .47756 .81611 .47469 .81241 .48454 Metetra
.818 .437 .331 r
.81241 .48454 .81611 .47469 .82984 .48782 .82746 .51131 Metetra
.784 .456 .433 r
.82746 .51131 .82984 .48782 .84506 .51467 .84368 .54748 Metetra
.761 .451 .461 r
.84368 .54748 .84506 .51467 .86151 .55086 .86058 .5869 Metetra
.738 .434 .467 r
.86058 .5869 .86151 .55086 .87865 .59026 .87748 .62246 Metetra
.706 .399 .455 r
.87748 .62246 .87865 .59026 .89576 .62574 .8936 .64721 Metetra
.63 .302 .396 r
.8936 .64721 .89576 .62574 .91203 .65036 .90822 .6558 Metetra
.90822 .6558 .91203 .65036 .92671 .65882 .92088 .64583 Metetra
.876 .713 .676 r
.92088 .64583 .92671 .65882 .93934 .64873 .9315 .61849 Metetra
.814 .605 .619 r
.9315 .61849 .93934 .64873 .94984 .62131 .94041 .57821 Metetra
.785 .566 .604 r
.94041 .57821 .94984 .62131 .95856 .581 .94829 .53157 Metetra
.765 .546 .602 r
.94829 .53157 .95856 .581 .96623 .5344 .95599 .48586 Metetra
.745 .533 .608 r
.95599 .48586 .96623 .5344 .97374 .48877 .96443 .4477 Metetra
.763 .561 .624 r
.38241 .68194 .3875 .72439 .39986 .68027 .39472 .63925 Metetra
.748 .551 .629 r
.39472 .63925 .39986 .68027 .41196 .63815 .40656 .60413 Metetra
.725 .543 .644 r
.40656 .60413 .41196 .63815 .42362 .60416 .41787 .58134 Metetra
.668 .534 .691 r
.41787 .58134 .42362 .60416 .43479 .58288 .42866 .5737 Metetra
.024 .312 .801 r
.42866 .5737 .43479 .58288 .44554 .5769 .43907 .58186 Metetra
.832 .47 .369 r
.43907 .58186 .44554 .5769 .45599 .58665 .44928 .60428 Metetra
.795 .489 .471 r
.44928 .60428 .45599 .58665 .46633 .61036 .4595 .63732 Metetra
.774 .484 .495 r
.4595 .63732 .46633 .61036 .47674 .64419 .46991 .67548 Metetra
.755 .47 .499 r
.46991 .67548 .47674 .64419 .48739 .68248 .48065 .71207 Metetra
.732 .442 .489 r
.48065 .71207 .48739 .68248 .49836 .71847 .49176 .7402 Metetra
.683 .373 .444 r
.49176 .7402 .49836 .71847 .50967 .74534 .50322 .75411 Metetra
.319 0 .068 r
.50322 .75411 .50967 .74534 .52124 .75752 .51489 .75051 Metetra
.873 .752 .725 r
.51489 .75051 .52124 .75752 .53292 .75207 .52659 .72943 Metetra
.815 .625 .646 r
.52659 .72943 .53292 .75207 .54454 .72935 .53817 .69422 Metetra
.79 .585 .624 r
.53817 .69422 .54454 .72935 .55595 .69303 .54953 .65068 Metetra
.773 .565 .618 r
.54953 .65068 .55595 .69303 .56711 .64907 .56066 .60576 Metetra
.757 .553 .62 r
.56066 .60576 .56711 .64907 .57803 .60446 .57163 .56619 Metetra
.737 .544 .632 r
.57163 .56619 .57803 .60446 .58883 .56584 .58258 .53749 Metetra
.699 .537 .664 r
.58258 .53749 .58883 .56584 .5997 .53855 .59372 .52331 Metetra
.535 .51 .775 r
.59372 .52331 .5997 .53855 .61083 .52602 .60521 .52518 Metetra
.828 .361 .096 r
.60521 .52518 .61083 .52602 .62241 .52957 .6172 .54243 Metetra
.811 .472 .413 r
.6172 .54243 .62241 .52957 .63458 .54828 .62977 .57218 Metetra
.785 .475 .465 r
.62977 .57218 .63458 .54828 .64738 .57905 .64289 .60955 Metetra
.765 .465 .479 r
.64289 .60955 .64738 .57905 .66075 .61684 .65638 .64813 Metetra
.743 .444 .476 r
.65638 .64813 .66075 .61684 .67448 .6551 .66998 .68082 Metetra
.706 .397 .451 r
.66998 .68082 .67448 .6551 .68825 .68676 .68334 .70111 Metetra
.579 .22 .324 r
.68334 .70111 .68825 .68676 .70167 .70545 .69609 .70451 Metetra
.91 .942 .815 r
.69609 .70451 .70167 .70545 .71438 .70697 .708 .68966 Metetra
.841 .661 .658 r
.708 .68966 .71438 .70697 .72614 .69032 .71898 .6587 Metetra
.805 .598 .622 r
.71898 .6587 .72614 .69032 .7369 .65798 .72916 .61672 Metetra
.784 .571 .612 r
.72916 .61672 .7369 .65798 .74684 .6153 .73885 .57054 Metetra
.767 .555 .612 r
.73885 .57054 .74684 .6153 .75631 .56915 .74847 .52724 Metetra
.748 .545 .621 r
.74847 .52724 .75631 .56915 .76578 .52658 .75849 .493 Metetra
.718 .538 .645 r
.75849 .493 .76578 .52658 .77574 .49361 .76934 .4723 Metetra
.64 .529 .712 r
.76934 .4723 .77574 .49361 .78663 .47453 .78136 .46757 Metetra
0 .201 .72 r
.78136 .46757 .78663 .47453 .79879 .47152 .79474 .479 Metetra
.828 .43 .297 r
.79474 .479 .79879 .47152 .81241 .48454 .8095 .50453 Metetra
.797 .46 .417 r
.8095 .50453 .81241 .48454 .82746 .51131 .82542 .54 Metetra
.775 .457 .449 r
.82542 .54 .82746 .51131 .84368 .54748 .84207 .57944 Metetra
.753 .441 .456 r
.84207 .57944 .84368 .54748 .86058 .5869 .85881 .61577 Metetra
.723 .407 .444 r
.85881 .61577 .86058 .5869 .87748 .62246 .87489 .64194 Metetra
.651 .31 .383 r
.87489 .64194 .87748 .62246 .8936 .64721 .88962 .65238 Metetra
.88962 .65238 .8936 .64721 .90822 .6558 .90251 .64433 Metetra
.883 .73 .688 r
.90251 .64433 .90822 .6558 .92088 .64583 .91342 .61859 Metetra
.825 .618 .623 r
.91342 .61859 .92088 .64583 .9315 .61849 .92264 .57931 Metetra
.797 .579 .605 r
.92264 .57931 .9315 .61849 .94041 .57821 .93078 .53293 Metetra
.778 .558 .602 r
.93078 .53293 .94041 .57821 .94829 .53157 .93865 .48674 Metetra
.758 .546 .609 r
.93865 .48674 .94829 .53157 .95599 .48586 .94713 .44748 Metetra
.733 .538 .628 r
.94713 .44748 .95599 .48586 .96443 .4477 .95701 .42044 Metetra
.781 .584 .634 r
.37698 .64975 .38241 .68194 .39472 .63925 .38914 .61132 Metetra
.763 .579 .648 r
.38914 .61132 .39472 .63925 .40656 .60413 .40073 .58378 Metetra
.723 .577 .69 r
.40073 .58378 .40656 .60413 .41787 .58134 .41173 .57066 Metetra
.46 .534 .847 r
.41173 .57066 .41787 .58134 .42866 .5737 .42223 .5734 Metetra
.85 .429 .23 r
.42223 .5734 .42866 .5737 .43907 .58186 .4324 .59119 Metetra
.83 .5 .431 r
.4324 .59119 .43907 .58186 .44928 .60428 .44246 .62111 Metetra
.811 .504 .471 r
.44246 .62111 .44928 .60428 .4595 .63732 .45262 .65824 Metetra
.795 .495 .48 r
.45262 .65824 .4595 .63732 .46991 .67548 .46307 .69622 Metetra
.777 .472 .471 r
.46307 .69622 .46991 .67548 .48065 .71207 .47392 .72806 Metetra
.742 .415 .429 r
.47392 .72806 .48065 .71207 .49176 .7402 .48518 .74744 Metetra
.547 .109 .161 r
.48518 .74744 .49176 .7402 .50322 .75411 .49677 .75009 Metetra
.876 .821 .791 r
.49677 .75009 .50322 .75411 .51489 .75051 .50853 .73482 Metetra
.839 .663 .664 r
.50853 .73482 .51489 .75051 .52659 .72943 .52027 .7039 Metetra
.819 .62 .633 r
.52027 .7039 .52659 .72943 .53817 .69422 .53187 .66242 Metetra
.805 .599 .624 r
.53187 .66242 .53817 .69422 .54953 .65068 .54323 .61711 Metetra
.792 .588 .625 r
.54323 .61711 .54953 .65068 .56066 .60576 .5544 .57491 Metetra
.776 .581 .636 r
.5544 .57491 .56066 .60576 .57163 .56619 .56546 .54187 Metetra
.746 .577 .666 r
.56546 .54187 .57163 .56619 .58258 .53749 .57657 .52232 Metetra
.645 .572 .758 r
.57657 .52232 .58258 .53749 .59372 .52331 .58792 .51857 Metetra
.609 .083 0 r
.58792 .51857 .59372 .52331 .60521 .52518 .59966 .5307 Metetra
.844 .467 .336 r
.59966 .5307 .60521 .52518 .6172 .54243 .61192 .55659 Metetra
.823 .491 .425 r
.61192 .55659 .6172 .54243 .62977 .57218 .62471 .59201 Metetra
.806 .488 .45 r
.62471 .59201 .62977 .57218 .64289 .60955 .63794 .631 Metetra
.789 .471 .45 r
.63794 .631 .64289 .60955 .65638 .64813 .65139 .66657 Metetra
.761 .43 .425 r
.65139 .66657 .65638 .64813 .66998 .68082 .66476 .69183 Metetra
.674 .289 .309 r
.66476 .69183 .66998 .68082 .68334 .70111 .6777 .70143 Metetra
.733 .987 .89 r
.6777 .70143 .68334 .70111 .69609 .70451 .68995 .69282 Metetra
.864 .709 .688 r
.68995 .69282 .69609 .70451 .708 .68966 .70133 .66695 Metetra
.835 .636 .634 r
.70133 .66695 .708 .68966 .71898 .6587 .71191 .62801 Metetra
.818 .607 .617 r
.71191 .62801 .71898 .6587 .72916 .61672 .72189 .58239 Metetra
.804 .592 .615 r
.72189 .58239 .72916 .61672 .73885 .57054 .73164 .53725 Metetra
.788 .583 .623 r
.73164 .53725 .73885 .57054 .74847 .52724 .74161 .4992 Metetra
.764 .578 .647 r
.74161 .4992 .74847 .52724 .75849 .493 .75221 .47338 Metetra
.705 .576 .708 r
.75221 .47338 .75849 .493 .76934 .4723 .76382 .46294 Metetra
.299 .481 .87 r
.76382 .46294 .76934 .4723 .78136 .46757 .77668 .46887 Metetra
.832 .374 .123 r
.77668 .46887 .78136 .46757 .79474 .479 .79088 .48989 Metetra
.836 .465 .351 r
.79088 .48989 .79474 .479 .8095 .50453 .80631 .52253 Metetra
.818 .474 .405 r
.80631 .52253 .8095 .50453 .82542 .54 .82261 .56139 Metetra
.8 .463 .418 r
.82261 .56139 .82542 .54 .84207 .57944 .83924 .59967 Metetra
.775 .433 .406 r
.83924 .59967 .84207 .57944 .85881 .61577 .85552 .63014 Metetra
.72 .348 .343 r
.85552 .63014 .85881 .61577 .87489 .64194 .87071 .64652 Metetra
.278 0 0 r
.87071 .64652 .87489 .64194 .88962 .65238 .88427 .64497 Metetra
.896 .797 .742 r
.88427 .64497 .88962 .65238 .90251 .64433 .89592 .62501 Metetra
.857 .663 .639 r
.89592 .62501 .90251 .64433 .91342 .61859 .9058 .58972 Metetra
.834 .619 .611 r
.9058 .58972 .91342 .61859 .92264 .57931 .91438 .54492 Metetra
.818 .598 .605 r
.91438 .54492 .92264 .57931 .93078 .53293 .92242 .49777 Metetra
.801 .586 .61 r
.92242 .49777 .93078 .53293 .93865 .48674 .93074 .45534 Metetra
.779 .579 .629 r
.93074 .45534 .93865 .48674 .94713 .44748 .94016 .42353 Metetra
.738 .577 .674 r
.94016 .42353 .94713 .44748 .95701 .42044 .95135 .40635 Metetra
.834 .648 .651 r
.37094 .63238 .37698 .64975 .38914 .61132 .38305 .59667 Metetra
.813 .652 .682 r
.38305 .59667 .38914 .61132 .40073 .58378 .39453 .57316 Metetra
.739 .662 .774 r
.39453 .57316 .40073 .58378 .41173 .57066 .40539 .56476 Metetra
0 .218 .702 r
.40539 .56476 .41173 .57066 .42223 .5734 .41575 .57222 Metetra
.878 .476 .262 r
.41575 .57222 .42223 .5734 .4324 .59119 .42581 .59411 Metetra
.879 .533 .389 r
.42581 .59411 .4324 .59119 .44246 .62111 .43579 .62684 Metetra
.872 .541 .421 r
.43579 .62684 .44246 .62111 .45262 .65824 .44591 .665 Metetra
.863 .531 .42 r
.44591 .665 .45262 .65824 .46307 .69622 .45638 .70191 Metetra
.849 .496 .385 r
.45638 .70191 .46307 .69622 .47392 .72806 .46728 .73062 Metetra
.792 .361 .225 r
.46728 .73062 .47392 .72806 .48518 .74744 .47862 .74528 Metetra
.543 .866 .995 r
.47862 .74528 .48518 .74744 .49677 .75009 .49029 .74246 Metetra
.864 .743 .728 r
.49029 .74246 .49677 .75009 .50853 .73482 .50213 .72202 Metetra
.868 .689 .658 r
.50213 .72202 .50853 .73482 .52027 .7039 .51395 .68719 Metetra
.864 .668 .635 r
.51395 .68719 .52027 .7039 .53187 .66242 .52561 .64371 Metetra
.858 .658 .63 r
.52561 .64371 .53187 .66242 .54323 .61711 .53704 .59854 Metetra
.849 .654 .637 r
.53704 .59854 .54323 .61711 .5544 .57491 .54828 .55846 Metetra
.833 .655 .662 r
.54828 .55846 .5544 .57491 .56546 .54187 .55942 .52906 Metetra
.787 .662 .725 r
.55942 .52906 .56546 .54187 .57657 .52232 .57064 .51411 Metetra
.493 .618 .903 r
.57064 .51411 .57657 .52232 .58792 .51857 .58209 .51524 Metetra
.802 .311 0 r
.58209 .51524 .58792 .51857 .59966 .5307 .59395 .53186 Metetra
.886 .494 .283 r
.59395 .53186 .59966 .5307 .61192 .55659 .6063 .56119 Metetra
.884 .522 .355 r
.6063 .56119 .61192 .55659 .62471 .59201 .61914 .59843 Metetra
.876 .52 .37 r
.61914 .59843 .62471 .59201 .63794 .631 .63237 .6372 Metetra
.863 .494 .349 r
.63237 .6372 .63794 .631 .65139 .66657 .64576 .67038 Metetra
.825 .408 .25 r
.64576 .67038 .65139 .66657 .66476 .69183 .65899 .69139 Metetra
.36 0 0 r
.65899 .69139 .66476 .69183 .6777 .70143 .67175 .69558 Metetra
.856 .808 .801 r
.67175 .69558 .6777 .70143 .68995 .69282 .68379 .68145 Metetra
.883 .716 .669 r
.68379 .68145 .68995 .69282 .70133 .66695 .69501 .65099 Metetra
.881 .683 .63 r
.69501 .65099 .70133 .66695 .71191 .62801 .70549 .6092 Metetra
.875 .668 .618 r
.70549 .6092 .71191 .62801 .72189 .58239 .71549 .56288 Metetra
.867 .661 .622 r
.71549 .56288 .72189 .58239 .73164 .53725 .72539 .51915 Metetra
.852 .66 .641 r
.72539 .51915 .73164 .53725 .74161 .4992 .7356 .48426 Metetra
.82 .664 .69 r
.7356 .48426 .74161 .4992 .75221 .47338 .74654 .4628 Metetra
.693 .663 .817 r
.74654 .4628 .75221 .47338 .76382 .46294 .75853 .45729 Metetra
0 .167 .668 r
.75853 .45729 .76382 .46294 .77668 .46887 .77179 .46801 Metetra
.856 .401 .084 r
.77179 .46801 .77668 .46887 .79088 .48989 .78633 .49302 Metetra
.887 .483 .248 r
.78633 .49302 .79088 .48989 .80631 .52253 .80199 .52823 Metetra
.885 .496 .292 r
.80199 .52823 .80631 .52253 .82261 .56139 .81837 .56773 Metetra
.873 .48 .288 r
.81837 .56773 .82261 .56139 .83924 .59967 .8349 .60444 Metetra
.843 .418 .221 r
.8349 .60444 .83924 .59967 .85552 .63014 .85087 .63126 Metetra
.671 .128 0 r
.85087 .63126 .85552 .63014 .87071 .64652 .86561 .64249 Metetra
.752 .888 .94 r
.86561 .64249 .87071 .64652 .88427 .64497 .87864 .63522 Metetra
.897 .756 .697 r
.87864 .63522 .88427 .64497 .89592 .62501 .8898 .61009 Metetra
.9 .703 .627 r
.8898 .61009 .89592 .62501 .9058 .58972 .89933 .57113 Metetra
.895 .68 .605 r
.89933 .57113 .9058 .58972 .91438 .54492 .90779 .52474 Metetra
.887 .67 .603 r
.90779 .52474 .91438 .54492 .92242 .49777 .91594 .47821 Metetra
.874 .666 .619 r
.91594 .47821 .92242 .49777 .93074 .45534 .92462 .43837 Metetra
.848 .669 .66 r
.92462 .43837 .93074 .45534 .94016 .42353 .93459 .41058 Metetra
.772 .673 .754 r
.93459 .41058 .94016 .42353 .95135 .40635 .94645 .39825 Metetra
.93 .767 .658 r
.36419 .63016 .37094 .63238 .38305 .59667 .37644 .5934 Metetra
.911 .781 .706 r
.37644 .5934 .38305 .59667 .39453 .57316 .38805 .56846 Metetra
.818 .797 .832 r
.38805 .56846 .39453 .57316 .40539 .56476 .39902 .55847 Metetra
0 .371 .831 r
.39902 .55847 .40539 .56476 .41575 .57222 .40944 .5644 Metetra
.849 .412 0 r
.40944 .5644 .41575 .57222 .42581 .59411 .41951 .58502 Metetra
.929 .547 .176 r
.41951 .58502 .42581 .59411 .43579 .62684 .42945 .61695 Metetra
.943 .578 .221 r
.42945 .61695 .43579 .62684 .44591 .665 .43952 .65492 Metetra
.938 .569 .2 r
.43952 .65492 .44591 .665 .45638 .70191 .44992 .69233 Metetra
.902 .504 .089 r
.44992 .69233 .45638 .70191 .46728 .73062 .46075 .72219 Metetra
.645 .186 0 r
.46075 .72219 .46728 .73062 .47862 .74528 .47206 .73845 Metetra
.567 .703 .933 r
.47206 .73845 .47862 .74528 .49029 .74246 .48374 .73738 Metetra
.884 .79 .751 r
.48374 .73738 .49029 .74246 .50213 .72202 .49563 .71851 Metetra
.935 .78 .665 r
.49563 .71851 .50213 .72202 .51395 .68719 .50755 .68477 Metetra
.95 .774 .63 r
.50755 .68477 .51395 .68719 .52561 .64371 .51932 .64172 Metetra
.955 .774 .62 r
.51932 .64172 .52561 .64371 .53704 .59854 .53088 .59628 Metetra
.953 .78 .63 r
.53088 .59628 .53704 .59854 .54828 .55846 .54222 .55532 Metetra
.941 .793 .669 r
.54222 .55532 .54828 .55846 .55942 .52906 .55344 .52459 Metetra
.887 .811 .768 r
.55344 .52459 .55942 .52906 .57064 .51411 .56469 .50807 Metetra
.529 .707 .952 r
.56469 .50807 .57064 .51411 .58209 .51524 .57615 .50759 Metetra
0 0 .435 r
.57615 .50759 .58209 .51524 .59395 .53186 .58797 .52279 Metetra
.84 .426 0 r
.58797 .52279 .59395 .53186 .6063 .56119 .60026 .55109 Metetra
.891 .502 .054 r
.60026 .55109 .6063 .56119 .61914 .59843 .61305 .58787 Metetra
.892 .507 .056 r
.61305 .58787 .61914 .59843 .63237 .6372 .62623 .62687 Metetra
.852 .453 0 r
.62623 .62687 .63237 .6372 .64576 .67038 .63961 .66096 Metetra
.669 .242 0 r
.63961 .66096 .64576 .67038 .65899 .69139 .65288 .68345 Metetra
.189 .474 .892 r
.65288 .68345 .65899 .69139 .67175 .69558 .66573 .68941 Metetra
.835 .801 .819 r
.66573 .68941 .67175 .69558 .68379 .68145 .67791 .67699 Metetra
.942 .804 .679 r
.67791 .67699 .68379 .68145 .69501 .65099 .68928 .64786 Metetra
.967 .794 .616 r
.68928 .64786 .69501 .65099 .70549 .6092 .69991 .60678 Metetra
.975 .791 .591 r
.69991 .60678 .70549 .6092 .71549 .56288 .71003 .56046 Metetra
.976 .795 .593 r
.71003 .56046 .71549 .56288 .72539 .51915 .72 .51606 Metetra
.969 .807 .626 r
.72 .51606 .72539 .51915 .7356 .48426 .73024 .47998 Metetra
.937 .827 .711 r
.73024 .47998 .7356 .48426 .74654 .4628 .74116 .45699 Metetra
.759 .804 .888 r
.74116 .45699 .74654 .4628 .75853 .45729 .75308 .44982 Metetra
0 .324 .81 r
.75308 .44982 .75853 .45729 .77179 .46801 .76623 .459 Metetra
.613 .2 0 r
.76623 .459 .77179 .46801 .78633 .49302 .78067 .48278 Metetra
.755 .359 0 r
.78067 .48278 .78633 .49302 .80199 .52823 .79624 .51727 Metetra
.78 .393 0 r
.79624 .51727 .80199 .52823 .81837 .56773 .81259 .55671 Metetra
.743 .355 0 r
.81259 .55671 .81837 .56773 .8349 .60444 .82914 .59408 Metetra
0 0 .367 r
.82914 .59408 .8349 .60444 .85087 .63126 .84522 .6222 Metetra
0 .244 .759 r
.84522 .6222 .85087 .63126 .86561 .64249 .86015 .63515 Metetra
.7 .762 .9 r
.86015 .63515 .86561 .64249 .87864 .63522 .87341 .62968 Metetra
.937 .832 .714 r
.87341 .62968 .87864 .63522 .8898 .61009 .88481 .60609 Metetra
.982 .817 .602 r
.88481 .60609 .8898 .61009 .89933 .57113 .89455 .56812 Metetra
.993 .807 .552 r
.89455 .56812 .89933 .57113 .90779 .52474 .90316 .52201 Metetra
.995 .806 .54 r
.90316 .52201 .90779 .52474 .91594 .47821 .91138 .47506 Metetra
.993 .818 .565 r
.91138 .47506 .91594 .47821 .92462 .43837 .92005 .43418 Metetra
.976 .841 .644 r
.92005 .43418 .92462 .43837 .93459 .41058 .92993 .40495 Metetra
.878 .85 .812 r
.92993 .40495 .93459 .41058 .94645 .39825 .94163 .39096 Metetra
.989 .887 .563 r
.35663 .64326 .36419 .63016 .37644 .5934 .36922 .60236 Metetra
.982 .91 .616 r
.36922 .60236 .37644 .5934 .38805 .56846 .38122 .57111 Metetra
.941 .94 .761 r
.38122 .57111 .38805 .56846 .39902 .55847 .39254 .55359 Metetra
.584 .763 .964 r
.39254 .55359 .39902 .55847 .40944 .5644 .40325 .55183 Metetra
0 .072 .634 r
.40325 .55183 .40944 .5644 .41951 .58502 .4135 .56567 Metetra
0 0 .362 r
.4135 .56567 .41951 .58502 .42945 .61695 .42351 .59274 Metetra
0 0 .277 r
.42351 .59274 .42945 .61695 .43952 .65492 .43353 .62863 Metetra
0 0 .284 r
.43353 .62863 .43952 .65492 .44992 .69233 .44378 .66726 Metetra
0 0 .363 r
.44378 .66726 .44992 .69233 .46075 .72219 .45443 .70168 Metetra
0 0 .54 r
.45443 .70168 .46075 .72219 .47206 .73845 .46556 .72518 Metetra
.284 .403 .808 r
.46556 .72518 .47206 .73845 .48374 .73738 .47713 .73274 Metetra
.823 .822 .848 r
.47713 .73274 .48374 .73738 .49563 .71851 .489 .72224 Metetra
.977 .904 .673 r
.489 .72224 .49563 .71851 .50755 .68477 .50099 .69501 Metetra
.984 .888 .546 r
.50099 .69501 .50755 .68477 .51932 .64172 .51292 .6555 Metetra
.971 .871 .482 r
.51292 .6555 .51932 .64172 .53088 .59628 .52464 .61018 Metetra
.961 .869 .467 r
.52464 .61018 .53088 .59628 .54222 .55532 .53614 .56611 Metetra
.96 .891 .507 r
.53614 .56611 .54222 .55532 .55344 .52459 .54747 .52972 Metetra
.959 .942 .642 r
.54747 .52972 .55344 .52459 .56469 .50807 .55874 .5059 Metetra
.808 .916 .912 r
.55874 .5059 .56469 .50807 .57615 .50759 .57013 .49754 Metetra
.16 .383 .831 r
.57013 .49754 .57615 .50759 .58797 .52279 .58181 .50536 Metetra
0 0 .564 r
.58181 .50536 .58797 .52279 .60026 .55109 .59393 .52783 Metetra
0 0 .453 r
.59393 .52783 .60026 .55109 .61305 .58787 .60654 .56128 Metetra
0 0 .431 r
.60654 .56128 .61305 .58787 .62623 .62687 .61961 .60014 Metetra
0 0 .466 r
.61961 .60014 .62623 .62687 .63961 .66096 .63299 .63757 Metetra
0 .004 .56 r
.63299 .63757 .63961 .66096 .65288 .68345 .64642 .66647 Metetra
.152 .268 .73 r
.64642 .66647 .65288 .68345 .66573 .68941 .65958 .68085 Metetra
.654 .7 .88 r
.65958 .68085 .66573 .68941 .67791 .67699 .67217 .67727 Metetra
.959 .922 .724 r
.67217 .67727 .67791 .67699 .68928 .64786 .68399 .65569 Metetra
.961 .889 .503 r
.68399 .65569 .68928 .64786 .69991 .60678 .69502 .61949 Metetra
.915 .836 .38 r
.69502 .61949 .69991 .60678 .71003 .56046 .7054 .57466 Metetra
.884 .812 .332 r
.7054 .57466 .71003 .56046 .72 .51606 .71544 .52831 Metetra
.879 .825 .351 r
.71544 .52831 .72 .51606 .73024 .47998 .72555 .48738 Metetra
.907 .89 .47 r
.72555 .48738 .73024 .47998 .74116 .45699 .73614 .4575 Metetra
.908 .981 .779 r
.73614 .4575 .74116 .45699 .75308 .44982 .74759 .44244 Metetra
.46 .636 .931 r
.74759 .44244 .75308 .44982 .76623 .459 .7602 .44379 Metetra
.029 .198 .705 r
.7602 .44379 .76623 .459 .78067 .48278 .77409 .46089 Metetra
0 .034 .583 r
.77409 .46089 .78067 .48278 .79624 .51727 .78923 .49088 Metetra
0 0 .543 r
.78923 .49088 .79624 .51727 .81259 .55671 .80536 .52882 Metetra
0 0 .549 r
.80536 .52882 .81259 .55671 .82914 .59408 .82199 .56818 Metetra
0 .068 .595 r
.82199 .56818 .82914 .59408 .84522 .6222 .83849 .60167 Metetra
.125 .219 .691 r
.83849 .60167 .84522 .6222 .86015 .63515 .85414 .62256 Metetra
.464 .53 .84 r
.85414 .62256 .86015 .63515 .87341 .62968 .86833 .62615 Metetra
.902 .908 .818 r
.86833 .62615 .87341 .62968 .88481 .60609 .88069 .61097 Metetra
.93 .89 .48 r
.88069 .61097 .88481 .60609 .89455 .56812 .89124 .57915 Metetra
.818 .769 .259 r
.89124 .57915 .89455 .56812 .90316 .52201 .90035 .53594 Metetra
.748 .703 .165 r
.90035 .53594 .90316 .52201 .91138 .47506 .90868 .48832 Metetra
.725 .694 .155 r
.90868 .48832 .91138 .47506 .92005 .43418 .91706 .44358 Metetra
.758 .755 .242 r
.91706 .44358 .92005 .43418 .92993 .40495 .92631 .40804 Metetra
.865 .926 .538 r
.92631 .40804 .92993 .40495 .94163 .39096 .93712 .38631 Metetra
.763 .774 .271 r
.34825 .67011 .35663 .64326 .36922 .60236 .36122 .62549 Metetra
.768 .791 .297 r
.36122 .62549 .36922 .60236 .38122 .57111 .37375 .58608 Metetra
.822 .87 .427 r
.37375 .58608 .38122 .57111 .39254 .55359 .38566 .55736 Metetra
.889 .99 .77 r
.38566 .55736 .39254 .55359 .40325 .55183 .3969 .54304 Metetra
.47 .59 .891 r
.3969 .54304 .40325 .55183 .4135 .56567 .40756 .54467 Metetra
.076 .158 .648 r
.40756 .54467 .4135 .56567 .42351 .59274 .41781 .56161 Metetra
0 .006 .532 r
.41781 .56161 .42351 .59274 .43353 .62863 .42788 .59105 Metetra
0 0 .493 r
.42788 .59105 .43353 .62863 .44378 .66726 .43801 .62815 Metetra
0 0 .496 r
.43801 .62815 .44378 .66726 .45443 .70168 .44843 .66658 Metetra
0 .024 .537 r
.44843 .66658 .45443 .70168 .46556 .72518 .45927 .69927 Metetra
.118 .163 .634 r
.45927 .69927 .46556 .72518 .47713 .73274 .47059 .71976 Metetra
.444 .503 .825 r
.47059 .71976 .47713 .73274 .489 .72224 .48231 .72352 Metetra
.901 .97 .815 r
.48231 .72352 .489 .72224 .50099 .69501 .49429 .70916 Metetra
.799 .847 .389 r
.49429 .70916 .50099 .69501 .51292 .6555 .50633 .67873 Metetra
.50633 .67873 .51292 .6555 .52464 .61018 .51827 .63725 Metetra
.51827 .63725 .52464 .61018 .53614 .56611 .52998 .59144 Metetra
.52998 .59144 .53614 .56611 .54747 .52972 .54147 .54836 Metetra
.54147 .54836 .54747 .52972 .55874 .5059 .55282 .51418 Metetra
.796 .905 .503 r
.55282 .51418 .55874 .5059 .57013 .49754 .56415 .49339 Metetra
.705 .837 .946 r
.56415 .49339 .57013 .49754 .58181 .50536 .57566 .48845 Metetra
.255 .324 .743 r
.57566 .48845 .58181 .50536 .59393 .52783 .58751 .49959 Metetra
.095 .134 .612 r
.58751 .49959 .59393 .52783 .60654 .56128 .59983 .52481 Metetra
.046 .071 .563 r
.59983 .52481 .60654 .56128 .61961 .60014 .61266 .56 Metetra
.043 .061 .553 r
.61266 .56 .61961 .60014 .63299 .63757 .62594 .59924 Metetra
.073 .089 .571 r
.62594 .59924 .63299 .63757 .64642 .66647 .63948 .63552 Metetra
.148 .168 .624 r
.63948 .63552 .64642 .66647 .65958 .68085 .653 .66182 Metetra
.328 .362 .745 r
.653 .66182 .65958 .68085 .67217 .67727 .66616 .67257 Metetra
.767 .847 .912 r
.66616 .67257 .67217 .67727 .68399 .65569 .67868 .66498 Metetra
.765 .854 .41 r
.67868 .66498 .68399 .65569 .69502 .61949 .69038 .63979 Metetra
.69038 .63979 .69502 .61949 .7054 .57466 .70128 .60104 Metetra
0 0 .041 r
.70128 .60104 .7054 .57466 .71544 .52831 .71158 .5551 Metetra
0 0 .064 r
.71158 .5551 .71544 .52831 .72555 .48738 .72161 .5092 Metetra
0 0 .017 r
.72161 .5092 .72555 .48738 .73614 .4575 .73181 .47006 Metetra
.73181 .47006 .73614 .4575 .74759 .44244 .7426 .44299 Metetra
.83 .999 .825 r
.7426 .44299 .74759 .44244 .7602 .44379 .75434 .4313 Metetra
.419 .492 .828 r
.75434 .4313 .7602 .44379 .77409 .46089 .76731 .43611 Metetra
.218 .244 .674 r
.76731 .43611 .77409 .46089 .78923 .49088 .7816 .45629 Metetra
.156 .163 .615 r
.7816 .45629 .78923 .49088 .80536 .52882 .79713 .4885 Metetra
.142 .14 .595 r
.79713 .4885 .80536 .52882 .82199 .56818 .81357 .52741 Metetra
.154 .15 .6 r
.81357 .52741 .82199 .56818 .83849 .60167 .83041 .56621 Metetra
.196 .193 .628 r
.83041 .56621 .83849 .60167 .85414 .62256 .84695 .59761 Metetra
.294 .302 .698 r
.84695 .59761 .85414 .62256 .86833 .62615 .86247 .61514 Metetra
.566 .617 .863 r
.86247 .61514 .86833 .62615 .88069 .61097 .87639 .6147 Metetra
.802 .935 .571 r
.87639 .6147 .88069 .61097 .89124 .57915 .88841 .59558 Metetra
0 0 .008 r
.88841 .59558 .89124 .57915 .90035 .53594 .89864 .56068 Metetra
0 0 .161 r
.89864 .56068 .90035 .53594 .90868 .48832 .90752 .51574 Metetra
0 0 .204 r
.90752 .51574 .90868 .48832 .91706 .44358 .91578 .46797 Metetra
0 0 .188 r
.91578 .46797 .91706 .44358 .92631 .40804 .92428 .42455 Metetra
0 0 .083 r
.92428 .42455 .92631 .40804 .93712 .38631 .93382 .39151 Metetra
.33936 .70286 .34825 .67011 .36122 .62549 .35251 .6594 Metetra
.35251 .6594 .36122 .62549 .37375 .58608 .36551 .6147 Metetra
.36551 .6147 .37375 .58608 .38566 .55736 .37806 .57544 Metetra
.37806 .57544 .38566 .55736 .3969 .54304 .38999 .5471 Metetra
.865 .995 .762 r
.38999 .5471 .3969 .54304 .40756 .54467 .40127 .53328 Metetra
.482 .539 .839 r
.40127 .53328 .40756 .54467 .41781 .56161 .41198 .53549 Metetra
.198 .208 .644 r
.41198 .53549 .41781 .56161 .42788 .59105 .42231 .55298 Metetra
.101 .094 .562 r
.42231 .55298 .42788 .59105 .43801 .62815 .43249 .58286 Metetra
.069 .056 .533 r
.43249 .58286 .43801 .62815 .44843 .66658 .44275 .62022 Metetra
.071 .057 .534 r
.44275 .62022 .44843 .66658 .45927 .69927 .4533 .65865 Metetra
.105 .096 .562 r
.4533 .65865 .45927 .69927 .47059 .71976 .46429 .69108 Metetra
.195 .203 .64 r
.46429 .69108 .47059 .71976 .48231 .72352 .47573 .71105 Metetra
.461 .523 .835 r
.47573 .71105 .48231 .72352 .49429 .70916 .48756 .71413 Metetra
.814 .98 .696 r
.48756 .71413 .49429 .70916 .50633 .67873 .49961 .69904 Metetra
.49961 .69904 .50633 .67873 .51827 .63725 .5117 .66796 Metetra
0 0 .043 r
.5117 .66796 .51827 .63725 .52998 .59144 .52365 .62602 Metetra
0 0 .089 r
.52365 .62602 .52998 .59144 .54147 .54836 .53538 .58001 Metetra
0 0 .074 r
.53538 .58001 .54147 .54836 .55282 .51418 .54689 .537 Metetra
.54689 .537 .55282 .51418 .56415 .49339 .55826 .50311 Metetra
.675 .83 .399 r
.55826 .50311 .56415 .49339 .57566 .48845 .56965 .48279 Metetra
.687 .781 .922 r
.56965 .48279 .57566 .48845 .58751 .49959 .58124 .47842 Metetra
.322 .33 .713 r
.58124 .47842 .58751 .49959 .59983 .52481 .59321 .49013 Metetra
.205 .187 .616 r
.59321 .49013 .59983 .52481 .61266 .56 .60568 .51585 Metetra
.165 .137 .579 r
.60568 .51585 .61266 .56 .62594 .59924 .61868 .55138 Metetra
.157 .127 .571 r
.61868 .55138 .62594 .59924 .63948 .63552 .63214 .59073 Metetra
.173 .145 .584 r
.63214 .59073 .63948 .63552 .653 .66182 .64585 .62684 Metetra
.222 .205 .627 r
.64585 .62684 .653 .66182 .66616 .67257 .65951 .65271 Metetra
.357 .375 .741 r
.65951 .65271 .66616 .67257 .67868 .66498 .67277 .66281 Metetra
.78 .939 .932 r
.67277 .66281 .67868 .66498 .69038 .63979 .68535 .65447 Metetra
.68535 .65447 .69038 .63979 .70128 .60104 .69706 .62856 Metetra
0 0 .136 r
.69706 .62856 .70128 .60104 .71158 .5551 .70796 .58926 Metetra
0 0 .204 r
.70796 .58926 .71158 .5551 .72161 .5092 .71824 .54301 Metetra
0 0 .21 r
.71824 .54301 .72161 .5092 .73181 .47006 .72827 .49707 Metetra
0 0 .16 r
.72827 .49707 .73181 .47006 .7426 .44299 .73849 .45815 Metetra
.73849 .45815 .7426 .44299 .75434 .4313 .74934 .4315 Metetra
.821 .998 .843 r
.74934 .4315 .75434 .4313 .76731 .43611 .7612 .42035 Metetra
.444 .461 .783 r
.7612 .42035 .76731 .43611 .7816 .45629 .77433 .42574 Metetra
.292 .268 .66 r
.77433 .42574 .7816 .45629 .79713 .4885 .78882 .44646 Metetra
.243 .205 .615 r
.78882 .44646 .79713 .4885 .81357 .52741 .80457 .47908 Metetra
.229 .186 .6 r
.80457 .47908 .81357 .52741 .83041 .56621 .82125 .5182 Metetra
.234 .191 .604 r
.82125 .5182 .83041 .56621 .84695 .59761 .8383 .55695 Metetra
.26 .224 .627 r
.8383 .55695 .84695 .59761 .86247 .61514 .85502 .588 Metetra
.331 .317 .692 r
.85502 .588 .86247 .61514 .87639 .6147 .87065 .60494 Metetra
.579 .653 .887 r
.87065 .60494 .87639 .6147 .88841 .59558 .88462 .60376 Metetra
.88462 .60376 .88841 .59558 .89864 .56068 .89664 .58387 Metetra
0 0 .196 r
.89664 .58387 .89864 .56068 .90752 .51574 .90681 .54833 Metetra
0 0 .288 r
.90681 .54833 .90752 .51574 .91578 .46797 .91563 .50297 Metetra
0 0 .309 r
.91563 .50297 .91578 .46797 .92428 .42455 .92385 .45505 Metetra
0 0 .289 r
.92385 .45505 .92428 .42455 .93382 .39151 .93235 .41175 Metetra
.33065 .72868 .33936 .70286 .35251 .6594 .3436 .69303 Metetra
.3436 .69303 .35251 .6594 .36551 .6147 .35679 .64931 Metetra
.35679 .64931 .36551 .6147 .37806 .57544 .36982 .60448 Metetra
.36982 .60448 .37806 .57544 .38999 .5471 .3824 .56525 Metetra
.3824 .56525 .38999 .5471 .40127 .53328 .39436 .53705 Metetra
.865 .995 .772 r
.39436 .53705 .40127 .53328 .41198 .53549 .40568 .52348 Metetra
.476 .526 .829 r
.40568 .52348 .41198 .53549 .42231 .55298 .41647 .52597 Metetra
.205 .209 .641 r
.41647 .52597 .42231 .55298 .43249 .58286 .42689 .54377 Metetra
.112 .1 .563 r
.42689 .54377 .43249 .58286 .44275 .62022 .43718 .57391 Metetra
.081 .063 .535 r
.43718 .57391 .44275 .62022 .4533 .65865 .44757 .61145 Metetra
.083 .065 .536 r
.44757 .61145 .4533 .65865 .46429 .69108 .45826 .64992 Metetra
.115 .102 .565 r
.45826 .64992 .46429 .69108 .47573 .71105 .46938 .68225 Metetra
.203 .208 .642 r
.46938 .68225 .47573 .71105 .48756 .71413 .48094 .70196 Metetra
.47 .535 .842 r
.48094 .70196 .48756 .71413 .49961 .69904 .49287 .70466 Metetra
.788 .966 .659 r
.49287 .70466 .49961 .69904 .5117 .66796 .505 .68913 Metetra
.505 .68913 .5117 .66796 .52365 .62602 .51713 .65764 Metetra
0 0 .062 r
.51713 .65764 .52365 .62602 .53538 .58001 .5291 .61538 Metetra
0 0 .104 r
.5291 .61538 .53538 .58001 .54689 .537 .54084 .56919 Metetra
0 0 .087 r
.54084 .56919 .54689 .537 .55826 .50311 .55236 .52614 Metetra
.55236 .52614 .55826 .50311 .56965 .48279 .56376 .49235 Metetra
.672 .83 .402 r
.56376 .49235 .56965 .48279 .58124 .47842 .57521 .47224 Metetra
.677 .764 .916 r
.57521 .47224 .58124 .47842 .59321 .49013 .58689 .46814 Metetra
.325 .327 .707 r
.58689 .46814 .59321 .49013 .60568 .51585 .59898 .48016 Metetra
.213 .19 .614 r
.59898 .48016 .60568 .51585 .61868 .55138 .61159 .50616 Metetra
.174 .142 .579 r
.61159 .50616 .61868 .55138 .63214 .59073 .62476 .54191 Metetra
.166 .132 .572 r
.62476 .54191 .63214 .59073 .64585 .62684 .6384 .58136 Metetra
.181 .15 .585 r
.6384 .58136 .64585 .62684 .65951 .65271 .65228 .61742 Metetra
.229 .209 .628 r
.65228 .61742 .65951 .65271 .67277 .66281 .66609 .64307 Metetra
.363 .38 .744 r
.66609 .64307 .67277 .66281 .68535 .65447 .67947 .65283 Metetra
.783 .957 .925 r
.67947 .65283 .68535 .65447 .69706 .62856 .69211 .64406 Metetra
.69211 .64406 .69706 .62856 .70796 .58926 .70386 .61771 Metetra
0 0 .154 r
.70386 .61771 .70796 .58926 .71824 .54301 .71475 .57804 Metetra
0 0 .216 r
.71475 .57804 .71824 .54301 .72827 .49707 .72502 .53154 Metetra
0 0 .221 r
.72502 .53154 .72827 .49707 .73849 .45815 .73504 .4855 Metetra
0 0 .169 r
.73504 .4855 .73849 .45815 .74934 .4315 .74528 .44663 Metetra
.74528 .44663 .74934 .4315 .7612 .42035 .75619 .42015 Metetra
.822 .995 .858 r
.75619 .42015 .7612 .42035 .77433 .42574 .76814 .40925 Metetra
.442 .453 .776 r
.76814 .40925 .77433 .42574 .78882 .44646 .78141 .41495 Metetra
.297 .268 .657 r
.78141 .41495 .78882 .44646 .80457 .47908 .79609 .43596 Metetra
.25 .208 .614 r
.79609 .43596 .80457 .47908 .82125 .5182 .81206 .46883 Metetra
.235 .189 .6 r
.81206 .46883 .82125 .5182 .8383 .55695 .82897 .50809 Metetra
.24 .195 .604 r
.82897 .50809 .8383 .55695 .85502 .588 .84624 .54684 Metetra
.266 .228 .628 r
.84624 .54684 .85502 .588 .87065 .60494 .86315 .57774 Metetra
.336 .32 .693 r
.86315 .57774 .87065 .60494 .88462 .60376 .87892 .59438 Metetra
.587 .669 .896 r
.87892 .59438 .88462 .60376 .89664 .58387 .89297 .59277 Metetra
.89297 .59277 .89664 .58387 .90681 .54833 .90501 .57243 Metetra
0 0 .212 r
.90501 .57243 .90681 .54833 .91563 .50297 .91516 .53647 Metetra
0 0 .298 r
.91516 .53647 .91563 .50297 .92385 .45505 .92393 .4908 Metetra
0 0 .317 r
.92393 .4908 .92385 .45505 .93235 .41175 .93212 .44272 Metetra
.893 .943 .58 r
.32259 .73952 .33065 .72868 .3436 .69303 .33509 .71513 Metetra
.777 .811 .33 r
.33509 .71513 .3436 .69303 .35679 .64931 .34817 .67757 Metetra
.71 .741 .229 r
.34817 .67757 .35679 .64931 .36982 .60448 .36141 .63302 Metetra
.688 .723 .207 r
.36141 .63302 .36982 .60448 .3824 .56525 .37443 .58851 Metetra
.711 .758 .256 r
.37443 .58851 .3824 .56525 .39436 .53705 .38696 .55062 Metetra
.8 .873 .438 r
.38696 .55062 .39436 .53705 .40568 .52348 .39887 .52452 Metetra
.858 .978 .859 r
.39887 .52452 .40568 .52348 .41647 .52597 .41016 .51347 Metetra
.368 .458 .821 r
.41016 .51347 .41647 .52597 .42689 .54377 .42094 .51856 Metetra
.081 .134 .618 r
.42094 .51856 .42689 .54377 .43718 .57391 .43141 .53866 Metetra
0 .022 .533 r
.43141 .53866 .43718 .57391 .44757 .61145 .44179 .57045 Metetra
0 0 .506 r
.44179 .57045 .44757 .61145 .45826 .64992 .45232 .6087 Metetra
0 .005 .515 r
.45232 .6087 .45826 .64992 .46938 .68225 .46318 .64675 Metetra
.042 .067 .56 r
.46318 .64675 .46938 .68225 .48094 .70196 .47447 .67748 Metetra
.187 .222 .666 r
.47447 .67748 .48094 .70196 .49287 .70466 .4862 .69467 Metetra
.557 .625 .875 r
.4862 .69467 .49287 .70466 .505 .68913 .49826 .69436 Metetra
.886 .978 .683 r
.49826 .69436 .505 .68913 .51713 .65764 .51046 .67589 Metetra
.679 .749 .251 r
.51046 .67589 .51713 .65764 .5291 .61538 .52262 .64208 Metetra
.52262 .64208 .5291 .61538 .54084 .56919 .5346 .59852 Metetra
.5346 .59852 .54084 .56919 .55236 .52614 .54633 .5522 Metetra
.54633 .5522 .55236 .52614 .56376 .49235 .55786 .51013 Metetra
.55786 .51013 .56376 .49235 .57521 .47224 .56929 .47821 Metetra
.813 .947 .597 r
.56929 .47821 .57521 .47224 .58689 .46814 .58082 .46054 Metetra
.585 .689 .913 r
.58082 .46054 .58689 .46814 .59898 .48016 .59263 .45909 Metetra
.233 .274 .699 r
.59263 .45909 .59898 .48016 .61159 .50616 .6049 .4736 Metetra
.118 .135 .602 r
.6049 .4736 .61159 .50616 .62476 .54191 .61773 .50159 Metetra
.083 .089 .566 r
.61773 .50159 .62476 .54191 .6384 .58136 .63112 .53846 Metetra
.085 .086 .561 r
.63112 .53846 .6384 .58136 .65228 .61742 .64496 .57794 Metetra
.117 .119 .583 r
.64496 .57794 .65228 .61742 .66609 .64307 .659 .61284 Metetra
.196 .206 .643 r
.659 .61284 .66609 .64307 .67947 .65283 .67289 .63626 Metetra
.4 .437 .783 r
.67289 .63626 .67947 .65283 .69211 .64406 .68627 .64307 Metetra
.854 .97 .87 r
.68627 .64307 .69211 .64406 .70386 .61771 .69885 .6312 Metetra
.69885 .6312 .70386 .61771 .71475 .57804 .7105 .60217 Metetra
0 0 .03 r
.7105 .60217 .71475 .57804 .72502 .53154 .72129 .56074 Metetra
0 0 .106 r
.72129 .56074 .72502 .53154 .73504 .4855 .7315 .51364 Metetra
0 0 .111 r
.7315 .51364 .73504 .4855 .74528 .44663 .74153 .46818 Metetra
0 0 .043 r
.74153 .46818 .74528 .44663 .75619 .42015 .75187 .43089 Metetra
.75187 .43089 .75619 .42015 .76814 .40925 .76297 .40669 Metetra
.784 .938 .929 r
.76297 .40669 .76814 .40925 .78141 .41495 .7752 .39845 Metetra
.368 .409 .772 r
.7752 .39845 .78141 .41495 .79609 .43596 .78881 .40677 Metetra
.226 .23 .654 r
.78881 .40677 .79609 .43596 .81206 .46883 .80386 .43005 Metetra
.18 .17 .61 r
.80386 .43005 .81206 .46883 .82897 .50809 .82018 .46443 Metetra
.172 .156 .597 r
.82018 .46443 .82897 .50809 .84624 .54684 .83738 .50419 Metetra
.186 .17 .606 r
.83738 .50419 .84624 .54684 .86315 .57774 .85484 .54223 Metetra
.23 .218 .638 r
.85484 .54223 .86315 .57774 .87892 .59438 .87179 .57125 Metetra
.339 .346 .721 r
.87179 .57125 .87892 .59438 .89297 .59277 .88746 .5851 Metetra
.674 .757 .913 r
.88746 .5851 .89297 .59277 .90501 .57243 .90129 .58032 Metetra
.90129 .58032 .90501 .57243 .91516 .53647 .91305 .55701 Metetra
0 0 .117 r
.91305 .55701 .91516 .53647 .92393 .4908 .92295 .51885 Metetra
0 0 .219 r
.92295 .51885 .92393 .4908 .93212 .44272 .93156 .47209 Metetra
.895 .872 .807 r
.31512 .73821 .32259 .73952 .33509 .71513 .32719 .72295 Metetra
.981 .908 .647 r
.32719 .72295 .33509 .71513 .34817 .67757 .34007 .69194 Metetra
.982 .893 .551 r
.34007 .69194 .34817 .67757 .36141 .63302 .35335 .65029 Metetra
.972 .883 .507 r
.35335 .65029 .36141 .63302 .37443 .58851 .3666 .60474 Metetra
.965 .888 .506 r
.3666 .60474 .37443 .58851 .38696 .55062 .3795 .56229 Metetra
.964 .913 .561 r
.3795 .56229 .38696 .55062 .39887 .52452 .39183 .529 Metetra
.948 .957 .718 r
.39183 .529 .39887 .52452 .41016 .51347 .40352 .50924 Metetra
.671 .82 .955 r
.40352 .50924 .41016 .51347 .42094 .51856 .41461 .50532 Metetra
0 .19 .713 r
.41461 .50532 .42094 .51856 .43141 .53866 .42528 .51736 Metetra
0 0 .463 r
.42528 .51736 .43141 .53866 .44179 .57045 .43573 .54322 Metetra
0 0 .374 r
.43573 .54322 .44179 .57045 .45232 .6087 .4462 .5787 Metetra
0 0 .369 r
.4462 .5787 .45232 .6087 .46318 .64675 .45691 .61781 Metetra
0 0 .423 r
.45691 .61781 .46318 .64675 .47447 .67748 .46801 .65355 Metetra
0 0 .552 r
.46801 .65355 .47447 .67748 .4862 .69467 .47957 .67897 Metetra
.242 .346 .77 r
.47957 .67897 .4862 .69467 .49826 .69436 .49152 .68869 Metetra
.782 .806 .871 r
.49152 .68869 .49826 .69436 .51046 .67589 .50373 .68013 Metetra
.972 .928 .67 r
.50373 .68013 .51046 .67589 .52262 .64208 .516 .6542 Metetra
.955 .889 .496 r
.516 .6542 .52262 .64208 .5346 .59852 .52816 .61511 Metetra
.92 .852 .408 r
.52816 .61511 .5346 .59852 .54633 .5522 .54009 .56928 Metetra
.9 .84 .382 r
.54009 .56928 .54633 .5522 .55786 .51013 .55178 .52388 Metetra
.902 .863 .419 r
.55178 .52388 .55786 .51013 .56929 .47821 .5633 .48557 Metetra
.927 .931 .565 r
.5633 .48557 .56929 .47821 .58082 .46054 .57481 .4595 Metetra
.85 .955 .88 r
.57481 .4595 .58082 .46054 .59263 .45909 .5865 .44888 Metetra
.283 .463 .861 r
.5865 .44888 .59263 .45909 .6049 .4736 .59856 .45467 Metetra
0 .081 .621 r
.59856 .45467 .6049 .4736 .61773 .50159 .61114 .47563 Metetra
0 0 .516 r
.61114 .47563 .61773 .50159 .63112 .53846 .6243 .50829 Metetra
0 0 .488 r
.6243 .50829 .63112 .53846 .64496 .57794 .638 .54725 Metetra
0 0 .508 r
.638 .54725 .64496 .57794 .659 .61284 .65205 .58568 Metetra
0 .041 .574 r
.65205 .58568 .659 .61284 .67289 .63626 .66615 .61631 Metetra
.157 .245 .705 r
.66615 .61631 .67289 .63626 .68627 .64307 .67994 .63284 Metetra
.59 .645 .873 r
.67994 .63284 .68627 .64307 .69885 .6312 .69307 .63136 Metetra
.948 .943 .742 r
.69307 .63136 .69885 .6312 .7105 .60217 .70531 .61138 Metetra
.912 .876 .445 r
.70531 .61138 .7105 .60217 .72129 .56074 .7166 .57597 Metetra
.826 .785 .284 r
.7166 .57597 .72129 .56074 .7315 .51364 .72714 .53096 Metetra
.777 .743 .222 r
.72714 .53096 .7315 .51364 .74153 .46818 .73726 .48356 Metetra
.77 .751 .234 r
.73726 .48356 .74153 .46818 .75187 .43089 .74741 .44087 Metetra
.814 .827 .352 r
.74741 .44087 .75187 .43089 .76297 .40669 .75808 .40879 Metetra
.893 .98 .696 r
.75808 .40879 .76297 .40669 .7752 .39845 .7697 .39139 Metetra
.545 .7 .942 r
.7697 .39139 .7752 .39845 .78881 .40677 .78259 .39053 Metetra
.133 .262 .731 r
.78259 .39053 .78881 .40677 .80386 .43005 .79694 .40584 Metetra
0 .099 .616 r
.79694 .40584 .80386 .43005 .82018 .46443 .81269 .43468 Metetra
0 .049 .574 r
.81269 .43468 .82018 .46443 .83738 .50419 .82959 .47232 Metetra
0 .053 .573 r
.82959 .47232 .83738 .50419 .85484 .54223 .84712 .51231 Metetra
.031 .102 .605 r
.84712 .51231 .85484 .54223 .87179 .57125 .86457 .54728 Metetra
.154 .218 .678 r
.86457 .54728 .87179 .57125 .88746 .5851 .88115 .57022 Metetra
.42 .477 .813 r
.88115 .57022 .88746 .5851 .90129 .58032 .89616 .576 Metetra
.871 .906 .852 r
.89616 .576 .90129 .58032 .91305 .55701 .90914 .56267 Metetra
.869 .871 .428 r
.90914 .56267 .91305 .55701 .92295 .51885 .92007 .532 Metetra
.696 .69 .153 r
.92007 .532 .92295 .51885 .93156 .47209 .92934 .48899 Metetra
.826 .783 .812 r
.30783 .73258 .31512 .73821 .32719 .72295 .31978 .7205 Metetra
.923 .792 .698 r
.31978 .7205 .32719 .72295 .34007 .69194 .33262 .69198 Metetra
.949 .789 .65 r
.33262 .69198 .34007 .69194 .35335 .65029 .34595 .65168 Metetra
.958 .79 .632 r
.34595 .65168 .35335 .65029 .3666 .60474 .35935 .60619 Metetra
.96 .795 .633 r
.35935 .60619 .3666 .60474 .3795 .56229 .37243 .56256 Metetra
.954 .806 .658 r
.37243 .56256 .3795 .56229 .39183 .529 .38496 .5271 Metetra
.926 .825 .726 r
.38496 .5271 .39183 .529 .40352 .50924 .39683 .50456 Metetra
.764 .816 .894 r
.39683 .50456 .40352 .50924 .41461 .50532 .40807 .49763 Metetra
0 .172 .69 r
.40807 .49763 .41461 .50532 .42528 .51736 .41882 .50683 Metetra
.815 .401 0 r
.41882 .50683 .42528 .51736 .43573 .54322 .42929 .53045 Metetra
.897 .523 .066 r
.42929 .53045 .43573 .54322 .4462 .5787 .43972 .56462 Metetra
.909 .547 .094 r
.43972 .56462 .4462 .5787 .45691 .61781 .45035 .60364 Metetra
.886 .519 .044 r
.45035 .60364 .45691 .61781 .46801 .65355 .46136 .64059 Metetra
.783 .395 0 r
.46136 .64059 .46801 .65355 .47957 .67897 .47283 .66842 Metetra
0 .109 .659 r
.47283 .66842 .47957 .67897 .49152 .68869 .48475 .68132 Metetra
.7 .746 .887 r
.48475 .68132 .49152 .68869 .50373 .68013 .49697 .67611 Metetra
.917 .813 .728 r
.49697 .67611 .50373 .68013 .516 .6542 .50932 .65305 Metetra
.962 .81 .645 r
.50932 .65305 .516 .6542 .52816 .61511 .52159 .61583 Metetra
.976 .807 .609 r
.52159 .61583 .52816 .61511 .54009 .56928 .53367 .57057 Metetra
.98 .81 .6 r
.53367 .57057 .54009 .56928 .55178 .52388 .54549 .52444 Metetra
.978 .82 .618 r
.54549 .52444 .55178 .52388 .5633 .48557 .55712 .48428 Metetra
.961 .839 .676 r
.55712 .48428 .5633 .48557 .57481 .4595 .56869 .45559 Metetra
.876 .852 .816 r
.56869 .45559 .57481 .4595 .5865 .44888 .58039 .44194 Metetra
.332 .592 .94 r
.58039 .44194 .5865 .44888 .59856 .45467 .5924 .44473 Metetra
0 0 .449 r
.5924 .44473 .59856 .45467 .61114 .47563 .6049 .46312 Metetra
.751 .369 0 r
.6049 .46312 .61114 .47563 .6243 .50829 .61796 .49403 Metetra
.797 .432 0 r
.61796 .49403 .6243 .50829 .638 .54725 .63157 .53237 Metetra
.779 .419 0 r
.63157 .53237 .638 .54725 .65205 .58568 .64558 .57151 Metetra
.684 .322 0 r
.64558 .57151 .65205 .58568 .66615 .61631 .65972 .60414 Metetra
0 0 .562 r
.65972 .60414 .66615 .61631 .67994 .63284 .67363 .62366 Metetra
.45 .603 .911 r
.67363 .62366 .67994 .63284 .69307 .63136 .68694 .62561 Metetra
.884 .826 .785 r
.68694 .62561 .69307 .63136 .70531 .61138 .69942 .60882 Metetra
.972 .834 .648 r
.69942 .60882 .70531 .61138 .7166 .57597 .71096 .57576 Metetra
.991 .825 .58 r
.71096 .57576 .7166 .57597 .72714 .53096 .72169 .53186 Metetra
.996 .823 .553 r
.72169 .53186 .72714 .53096 .73726 .48356 .73194 .48421 Metetra
.996 .831 .561 r
.73194 .48421 .73726 .48356 .74741 .44087 .74213 .44004 Metetra
.989 .851 .612 r
.74213 .44004 .74741 .44087 .75808 .40879 .75274 .40557 Metetra
.944 .877 .74 r
.75274 .40557 .75808 .40879 .7697 .39139 .76422 .3852 Metetra
.658 .779 .938 r
.76422 .3852 .7697 .39139 .78259 .39053 .77691 .38123 Metetra
0 .231 .75 r
.77691 .38123 .78259 .39053 .79694 .40584 .79103 .3937 Metetra
0 0 .45 r
.79103 .3937 .79694 .40584 .81269 .43468 .80657 .42039 Metetra
0 0 .334 r
.80657 .42039 .81269 .43468 .82959 .47232 .82332 .45691 Metetra
0 0 .322 r
.82332 .45691 .82959 .47232 .84712 .51231 .84081 .49706 Metetra
0 0 .392 r
.84081 .49706 .84712 .51231 .86457 .54728 .85838 .53356 Metetra
0 0 .567 r
.85838 .53356 .86457 .54728 .88115 .57022 .87522 .5592 Metetra
.2 .409 .842 r
.87522 .5592 .88115 .57022 .89616 .576 .89062 .56837 Metetra
.788 .8 .862 r
.89062 .56837 .89616 .576 .90914 .56267 .90405 .55847 Metetra
.972 .862 .672 r
.90405 .55847 .90914 .56267 .92007 .532 .91541 .53059 Metetra
.999 .842 .546 r
.91541 .53059 .92007 .532 .92934 .48899 .925 .48923 Metetra
.848 .762 .768 r
.30052 .72623 .30783 .73258 .31978 .7205 .31275 .71024 Metetra
.87 .705 .675 r
.31275 .71024 .31978 .7205 .33262 .69198 .32584 .67857 Metetra
.871 .684 .646 r
.32584 .67857 .33262 .69198 .34595 .65168 .33936 .63644 Metetra
.869 .674 .637 r
.33936 .63644 .34595 .65168 .35935 .60619 .35286 .59065 Metetra
.863 .671 .641 r
.35286 .59065 .35935 .60619 .37243 .56256 .36597 .54823 Metetra
.851 .673 .66 r
.36597 .54823 .37243 .56256 .38496 .5271 .37846 .51519 Metetra
.82 .681 .711 r
.37846 .51519 .38496 .5271 .39683 .50456 .39025 .49586 Metetra
.655 .681 .863 r
.39025 .49586 .39683 .50456 .40807 .49763 .40138 .49248 Metetra
.704 .185 0 r
.40138 .49248 .40807 .49763 .41882 .50683 .41203 .50507 Metetra
.893 .497 .263 r
.41203 .50507 .41882 .50683 .42929 .53045 .4224 .53142 Metetra
.898 .539 .354 r
.4224 .53142 .42929 .53045 .43972 .56462 .43277 .56725 Metetra
.894 .543 .375 r
.43277 .56725 .43972 .56462 .45035 .60364 .44337 .60648 Metetra
.886 .526 .359 r
.44337 .60648 .45035 .60364 .46136 .64059 .45439 .64207 Metetra
.863 .463 .279 r
.45439 .64207 .46136 .64059 .47283 .66842 .46591 .66709 Metetra
.642 .083 0 r
.46591 .66709 .47283 .66842 .48475 .68132 .47789 .67618 Metetra
.799 .824 .871 r
.47789 .67618 .48475 .68132 .49697 .67611 .4902 .66686 Metetra
.88 .733 .695 r
.4902 .66686 .49697 .67611 .50932 .65305 .50263 .64021 Metetra
.887 .7 .644 r
.50263 .64021 .50932 .65305 .52159 .61583 .51499 .60055 Metetra
.885 .686 .627 r
.51499 .60055 .52159 .61583 .53367 .57057 .52715 .55437 Metetra
.88 .68 .627 r
.52715 .55437 .53367 .57057 .54549 .52444 .53905 .5089 Metetra
.87 .679 .641 r
.53905 .5089 .54549 .52444 .55712 .48428 .55077 .47076 Metetra
.847 .685 .681 r
.55077 .47076 .55712 .48428 .56869 .45559 .56243 .44507 Metetra
.764 .694 .785 r
.56243 .44507 .56869 .45559 .58039 .44194 .57422 .43494 Metetra
.042 .412 .861 r
.57422 .43494 .58039 .44194 .5924 .44473 .58633 .4413 Metetra
.843 .378 .025 r
.58633 .4413 .5924 .44473 .6049 .46312 .5989 .46278 Metetra
.898 .497 .238 r
.5989 .46278 .6049 .46312 .61796 .49403 .61202 .49586 Metetra
.901 .519 .293 r
.61202 .49586 .61796 .49403 .63157 .53237 .62565 .53503 Metetra
.895 .51 .293 r
.62565 .53503 .63157 .53237 .64558 .57151 .63964 .57342 Metetra
.875 .463 .237 r
.63964 .57342 .64558 .57151 .65972 .60414 .6537 .60373 Metetra
.77 .265 0 r
.6537 .60373 .65972 .60414 .67363 .62366 .66748 .61969 Metetra
.527 .817 .999 r
.66748 .61969 .67363 .62366 .68694 .62561 .68066 .61747 Metetra
.883 .775 .737 r
.68066 .61747 .68694 .62561 .69942 .60882 .69299 .59672 Metetra
.903 .722 .647 r
.69299 .59672 .69942 .60882 .71096 .57576 .70445 .56065 Metetra
.904 .7 .617 r
.70445 .56065 .71096 .57576 .72169 .53186 .71517 .51519 Metetra
.9 .69 .61 r
.71517 .51519 .72169 .53186 .73194 .48421 .7255 .4676 Metetra
.892 .688 .62 r
.7255 .4676 .73194 .48421 .74213 .44004 .73586 .42499 Metetra
.873 .691 .653 r
.73586 .42499 .74213 .44004 .75274 .40557 .74672 .39322 Metetra
.82 .7 .732 r
.74672 .39322 .75274 .40557 .76422 .3852 .7585 .37628 Metetra
.542 .647 .903 r
.7585 .37628 .76422 .3852 .77691 .38123 .77151 .37597 Metetra
.571 .07 0 r
.77151 .37597 .77691 .38123 .79103 .3937 .78592 .39183 Metetra
.856 .402 .04 r
.78592 .39183 .79103 .3937 .80657 .42039 .80171 .42114 Metetra
.891 .468 .163 r
.80171 .42114 .80657 .42039 .82332 .45691 .8186 .45908 Metetra
.892 .475 .189 r
.8186 .45908 .82332 .45691 .84081 .49706 .83611 .49912 Metetra
.874 .44 .154 r
.83611 .49912 .84081 .49706 .85838 .53356 .85353 .53387 Metetra
.801 .308 0 r
.85353 .53387 .85838 .53356 .87522 .5592 .87009 .55631 Metetra
0 .432 .782 r
.87009 .55631 .87522 .5592 .89062 .56837 .8851 .56139 Metetra
.856 .831 .821 r
.8851 .56139 .89062 .56837 .90405 .55847 .89813 .54727 Metetra
.919 .754 .66 r
.89813 .54727 .90405 .55847 .91541 .53059 .90916 .51586 Metetra
.925 .719 .606 r
.90916 .51586 .91541 .53059 .925 .48923 .91856 .47229 Metetra
.846 .694 .693 r
.29349 .71488 .30052 .72623 .31275 .71024 .30636 .68915 Metetra
.828 .638 .646 r
.30636 .68915 .31275 .71024 .32584 .67857 .3199 .65051 Metetra
.815 .614 .63 r
.3199 .65051 .32584 .67857 .33936 .63644 .33364 .60529 Metetra
.804 .601 .627 r
.33364 .60529 .33936 .63644 .35286 .59065 .34712 .56059 Metetra
.791 .594 .634 r
.34712 .56059 .35286 .59065 .36597 .54823 .36002 .52297 Metetra
.77 .59 .656 r
.36002 .52297 .36597 .54823 .37846 .51519 .3722 .49752 Metetra
.713 .591 .718 r
.3722 .49752 .37846 .51519 .39025 .49586 .38362 .48737 Metetra
.101 .405 .857 r
.38362 .48737 .39025 .49586 .40138 .49248 .3944 .49348 Metetra
.853 .448 .27 r
.3944 .49348 .40138 .49248 .41203 .50507 .40475 .51455 Metetra
.838 .499 .413 r
.40475 .51455 .41203 .50507 .4224 .53142 .41495 .54712 Metetra
.822 .501 .447 r
.41495 .54712 .4224 .53142 .43277 .56725 .42525 .58581 Metetra
.807 .489 .452 r
.42525 .58581 .43277 .56725 .44337 .60648 .43592 .62383 Metetra
.786 .459 .434 r
.43592 .62383 .44337 .60648 .45439 .64207 .44709 .65403 Metetra
.737 .37 .358 r
.44709 .65403 .45439 .64207 .46591 .66709 .45882 .67021 Metetra
.119 0 0 r
.45882 .67021 .46591 .66709 .47789 .67618 .47101 .66859 Metetra
.868 .759 .74 r
.47101 .66859 .47789 .67618 .4902 .66686 .48348 .64872 Metetra
.844 .659 .652 r
.48348 .64872 .4902 .66686 .50263 .64021 .49603 .61368 Metetra
.829 .624 .626 r
.49603 .61368 .50263 .64021 .51499 .60055 .50845 .56926 Metetra
.816 .607 .619 r
.50845 .56926 .51499 .60055 .52715 .55437 .52063 .52255 Metetra
.803 .597 .623 r
.52063 .52255 .52715 .55437 .53905 .5089 .53257 .48057 Metetra
.785 .592 .639 r
.53257 .48057 .53905 .5089 .55077 .47076 .54435 .44917 Metetra
.746 .591 .683 r
.54435 .44917 .55077 .47076 .56243 .44507 .55612 .43232 Metetra
.569 .575 .82 r
.55612 .43232 .56243 .44507 .57422 .43494 .56807 .43187 Metetra
.766 .257 0 r
.56807 .43187 .57422 .43494 .58633 .4413 .58036 .44739 Metetra
.849 .465 .321 r
.58036 .44739 .58633 .4413 .5989 .46278 .59312 .47625 Metetra
.834 .486 .396 r
.59312 .47625 .5989 .46278 .61202 .49586 .60639 .5137 Metetra
.818 .48 .416 r
.60639 .5137 .61202 .49586 .62565 .53503 .62009 .55334 Metetra
.799 .458 .409 r
.62009 .55334 .62565 .53503 .63964 .57342 .63401 .58789 Metetra
.763 .398 .363 r
.63401 .58789 .63964 .57342 .6537 .60373 .64785 .61045 Metetra
.587 .117 .106 r
.64785 .61045 .6537 .60373 .66748 .61969 .66129 .61601 Metetra
.871 .89 .845 r
.66129 .61601 .66748 .61969 .68066 .61747 .67403 .60271 Metetra
.866 .694 .667 r
.67403 .60271 .68066 .61747 .69299 .59672 .68595 .57233 Metetra
.845 .639 .624 r
.68595 .57233 .69299 .59672 .70445 .56065 .69711 .52984 Metetra
.831 .615 .61 r
.69711 .52984 .70445 .56065 .71517 .51519 .70773 .48215 Metetra
.817 .601 .611 r
.70773 .48215 .71517 .51519 .7255 .4676 .71819 .43659 Metetra
.8 .594 .624 r
.71819 .43659 .7255 .4676 .73586 .42499 .72892 .39967 Metetra
.77 .592 .657 r
.72892 .39967 .73586 .42499 .74672 .39322 .74036 .37619 Metetra
.682 .59 .746 r
.74036 .37619 .74672 .39322 .7585 .37628 .75285 .36889 Metetra
0 .311 .8 r
.75285 .36889 .7585 .37628 .77151 .37597 .76662 .37825 Metetra
.838 .384 .135 r
.76662 .37825 .77151 .37597 .78592 .39183 .78176 .40246 Metetra
.844 .456 .314 r
.78176 .40246 .78592 .39183 .80171 .42114 .79809 .43756 Metetra
.829 .463 .361 r
.79809 .43756 .80171 .42114 .8186 .45908 .81526 .47764 Metetra
.811 .448 .369 r
.81526 .47764 .8186 .45908 .83611 .49912 .83266 .51553 Metetra
.781 .404 .343 r
.83266 .51553 .83611 .49912 .85353 .53387 .84956 .54385 Metetra
.691 .258 .217 r
.84956 .54385 .85353 .53387 .87009 .55631 .86523 .55656 Metetra
.478 .897 .842 r
.86523 .55656 .87009 .55631 .8851 .56139 .87912 .55035 Metetra
.892 .754 .702 r
.87912 .55035 .8851 .56139 .89813 .54727 .89104 .52559 Metetra
.866 .662 .624 r
.89104 .52559 .89813 .54727 .90916 .51586 .90119 .4862 Metetra
.848 .625 .6 r
.90119 .4862 .90916 .51586 .91856 .47229 .91013 .43864 Metetra
.81 .619 .644 r
.28729 .69051 .29349 .71488 .30636 .68915 .30092 .65332 Metetra
.79 .586 .625 r
.30092 .65332 .30636 .68915 .3199 .65051 .31485 .60855 Metetra
.774 .568 .62 r
.31485 .60855 .3199 .65051 .33364 .60529 .32859 .56329 Metetra
.759 .556 .622 r
.32859 .56329 .33364 .60529 .34712 .56059 .34176 .52424 Metetra
.738 .548 .636 r
.34176 .52424 .34712 .56059 .36002 .52297 .35415 .49675 Metetra
.694 .54 .674 r
.35415 .49675 .36002 .52297 .3722 .49752 .36571 .48426 Metetra
.425 .483 .817 r
.36571 .48426 .3722 .49752 .38362 .48737 .37652 .48805 Metetra
.844 .427 .245 r
.37652 .48805 .38362 .48737 .3944 .49348 .3868 .50713 Metetra
.81 .481 .433 r
.3868 .50713 .3944 .49348 .40475 .51455 .39681 .53836 Metetra
.786 .48 .47 r
.39681 .53836 .40475 .51455 .41495 .54712 .40687 .57659 Metetra
.767 .467 .479 r
.40687 .57659 .41495 .54712 .42525 .58581 .41724 .61518 Metetra
.745 .442 .47 r
.41724 .61518 .42525 .58581 .43592 .62383 .42815 .64696 Metetra
.703 .383 .432 r
.42815 .64696 .43592 .62383 .44709 .65403 .43967 .66548 Metetra
.502 .098 .206 r
.43967 .66548 .44709 .65403 .45882 .67021 .45177 .66652 Metetra
.895 .838 .782 r
.45177 .66652 .45882 .67021 .47101 .66859 .46428 .64914 Metetra
.831 .648 .655 r
.46428 .64914 .47101 .66859 .48348 .64872 .47696 .61593 Metetra
.803 .597 .623 r
.47696 .61593 .48348 .64872 .49603 .61368 .4896 .57237 Metetra
.785 .573 .614 r
.4896 .57237 .49603 .61368 .50845 .56926 .50203 .52548 Metetra
.769 .559 .614 r
.50203 .52548 .50845 .56926 .52063 .52255 .51419 .48237 Metetra
.75 .549 .624 r
.51419 .48237 .52063 .52255 .53257 .48057 .52612 .4491 Metetra
.718 .542 .651 r
.52612 .4491 .53257 .48057 .54435 .44917 .53795 .42996 Metetra
.614 .53 .736 r
.53795 .42996 .54435 .44917 .55612 .43232 .54984 .4271 Metetra
.632 .112 0 r
.54984 .4271 .55612 .43232 .56807 .43187 .56198 .44043 Metetra
.826 .451 .345 r
.56198 .44043 .56807 .43187 .58036 .44739 .5745 .46763 Metetra
.798 .467 .428 r
.5745 .46763 .58036 .44739 .59312 .47625 .58748 .50423 Metetra
.777 .46 .451 r
.58748 .50423 .59312 .47625 .60639 .5137 .6009 .54403 Metetra
.756 .441 .452 r
.6009 .54403 .60639 .5137 .62009 .55334 .6146 .57979 Metetra
.722 .398 .43 r
.6146 .57979 .62009 .55334 .63401 .58789 .62832 .60446 Metetra
.628 .263 .331 r
.62832 .60446 .63401 .58789 .64785 .61045 .64176 .61267 Metetra
.69 .974 .783 r
.64176 .61267 .64785 .61045 .66129 .61601 .65464 .60203 Metetra
.863 .699 .678 r
.65464 .60203 .66129 .61601 .67403 .60271 .66679 .57383 Metetra
.821 .614 .623 r
.66679 .57383 .67403 .60271 .68595 .57233 .67822 .53263 Metetra
.798 .58 .607 r
.67822 .53263 .68595 .57233 .69711 .52984 .68911 .48516 Metetra
.78 .562 .604 r
.68911 .48516 .69711 .52984 .70773 .48215 .69978 .4388 Metetra
.761 .55 .612 r
.69978 .4388 .70773 .48215 .71819 .43659 .71061 .40024 Metetra
.734 .542 .633 r
.71061 .40024 .71819 .43659 .72892 .39967 .72202 .37457 Metetra
.674 .536 .689 r
.72202 .37457 .72892 .39967 .74036 .37619 .73435 .36483 Metetra
.277 .441 .844 r
.73435 .36483 .74036 .37619 .75285 .36889 .74787 .37183 Metetra
.824 .369 .145 r
.74787 .37183 .75285 .36889 .76662 .37825 .76267 .39411 Metetra
.811 .443 .361 r
.76267 .39411 .76662 .37825 .78176 .40246 .77865 .42798 Metetra
.788 .447 .41 r
.77865 .42798 .78176 .40246 .79809 .43756 .7955 .4678 Metetra
.766 .434 .424 r
.7955 .4678 .79809 .43756 .81526 .47764 .81268 .50649 Metetra
.737 .402 .414 r
.81268 .50649 .81526 .47764 .83266 .51553 .82952 .53663 Metetra
.676 .319 .362 r
.82952 .53663 .83266 .51553 .84956 .54385 .8453 .55187 Metetra
.291 0 0 r
.8453 .55187 .84956 .54385 .86523 .55656 .85946 .54844 Metetra
.91 .804 .73 r
.85946 .54844 .86523 .55656 .87912 .55035 .87174 .52615 Metetra
.845 .642 .628 r
.87174 .52615 .87912 .55035 .89104 .52559 .88228 .48845 Metetra
.814 .591 .601 r
.88228 .48845 .89104 .52559 .90119 .4862 .89155 .44155 Metetra
.792 .566 .594 r
.89155 .44155 .90119 .4862 .91013 .43864 .90031 .39288 Metetra
.779 .575 .623 r
.28217 .65103 .28729 .69051 .30092 .65332 .2963 .60626 Metetra
.762 .555 .617 r
.2963 .60626 .30092 .65332 .31485 .60855 .31026 .5609 Metetra
.746 .542 .618 r
.31026 .5609 .31485 .60855 .32859 .56329 .32362 .52167 Metetra
.725 .531 .629 r
.32362 .52167 .32859 .56329 .34176 .52424 .33614 .49395 Metetra
.683 .521 .661 r
.33614 .49395 .34176 .52424 .35415 .49675 .34774 .48122 Metetra
.458 .47 .783 r
.34774 .48122 .35415 .49675 .36571 .48426 .35851 .48476 Metetra
.844 .427 .242 r
.35851 .48476 .36571 .48426 .37652 .48805 .36865 .50364 Metetra
.799 .475 .441 r
.36865 .50364 .37652 .48805 .3868 .50713 .37845 .53475 Metetra
.772 .472 .478 r
.37845 .53475 .3868 .50713 .39681 .53836 .38825 .57294 Metetra
.752 .458 .486 r
.38825 .57294 .39681 .53836 .40687 .57659 .39837 .61161 Metetra
.729 .434 .48 r
.39837 .61161 .40687 .57659 .41724 .61518 .40905 .64356 Metetra
.688 .38 .448 r
.40905 .64356 .41724 .61518 .42815 .64696 .42043 .66232 Metetra
.524 .156 .283 r
.42043 .66232 .42815 .64696 .43967 .66548 .43247 .66362 Metetra
.91 .88 .792 r
.43247 .66362 .43967 .66548 .45177 .66652 .44503 .64647 Metetra
.828 .644 .654 r
.44503 .64647 .45177 .66652 .46428 .64914 .45786 .61341 Metetra
.793 .586 .622 r
.45786 .61341 .46428 .64914 .47696 .61593 .4707 .5699 Metetra
.772 .56 .611 r
.4707 .5699 .47696 .61593 .4896 .57237 .48336 .52295 Metetra
.755 .544 .61 r
.48336 .52295 .4896 .57237 .50203 .52548 .49572 .47969 Metetra
.736 .533 .618 r
.49572 .47969 .50203 .52548 .51419 .48237 .5078 .4462 Metetra
.704 .523 .641 r
.5078 .4462 .51419 .48237 .52612 .4491 .5197 .42681 Metetra
.611 .508 .713 r
.5197 .42681 .52612 .4491 .53795 .42996 .53157 .42369 Metetra
.57 .066 0 r
.53157 .42369 .53795 .42996 .54984 .4271 .54359 .4368 Metetra
.818 .449 .357 r
.54359 .4368 .54984 .4271 .56198 .44043 .55592 .46383 Metetra
.784 .46 .44 r
.55592 .46383 .56198 .44043 .5745 .46763 .56865 .50036 Metetra
.761 .452 .462 r
.56865 .50036 .5745 .46763 .58748 .50423 .5818 .54019 Metetra
.739 .433 .464 r
.5818 .54019 .58748 .50423 .6009 .54403 .59526 .57609 Metetra
.706 .393 .446 r
.59526 .57609 .6009 .54403 .6146 .57979 .6088 .60098 Metetra
.621 .279 .37 r
.6088 .60098 .6146 .57979 .62832 .60446 .62216 .60945 Metetra
.62216 .60945 .62832 .60446 .64176 .61267 .63507 .59907 Metetra
.865 .703 .68 r
.63507 .59907 .64176 .61267 .65464 .60203 .64735 .57105 Metetra
.811 .604 .622 r
.64735 .57105 .65464 .60203 .66679 .57383 .65898 .52994 Metetra
.785 .567 .605 r
.65898 .52994 .66679 .57383 .67822 .53263 .6701 .48245 Metetra
.765 .547 .602 r
.6701 .48245 .67822 .53263 .68911 .48516 .68098 .43598 Metetra
.746 .534 .607 r
.68098 .43598 .68911 .48516 .69978 .4388 .69199 .39721 Metetra
.719 .524 .625 r
.69199 .39721 .69978 .4388 .71061 .40024 .70349 .37129 Metetra
.664 .516 .673 r
.70349 .37129 .71061 .40024 .72202 .37457 .71583 .36129 Metetra
.334 .44 .821 r
.71583 .36129 .72202 .37457 .73435 .36483 .72925 .36805 Metetra
.823 .371 .156 r
.72925 .36805 .73435 .36483 .74787 .37183 .74387 .39013 Metetra
.798 .439 .378 r
.74387 .39013 .74787 .37183 .76267 .39411 .7596 .42389 Metetra
.771 .44 .426 r
.7596 .42389 .76267 .39411 .77865 .42798 .77618 .46369 Metetra
.748 .426 .439 r
.77618 .46369 .77865 .42798 .7955 .4678 .7931 .50248 Metetra
.719 .397 .433 r
.7931 .50248 .7955 .4678 .81268 .50649 .80974 .53281 Metetra
.662 .326 .392 r
.80974 .53281 .81268 .50649 .82952 .53663 .82541 .54831 Metetra
.38 0 .138 r
.82541 .54831 .82952 .53663 .8453 .55187 .83957 .54514 Metetra
.923 .83 .736 r
.83957 .54514 .8453 .55187 .85946 .54844 .85197 .52307 Metetra
.837 .634 .628 r
.85197 .52307 .85946 .54844 .87174 .52615 .86269 .48551 Metetra
.8 .578 .6 r
.86269 .48551 .87174 .52615 .88228 .48845 .8722 .43863 Metetra
.777 .551 .592 r
.8722 .43863 .88228 .48845 .89155 .44155 .8812 .38987 Metetra
.757 .535 .596 r
.8812 .38987 .89155 .44155 .90031 .39288 .89049 .34646 Metetra
.766 .559 .617 r
.27758 .60535 .28217 .65103 .2963 .60626 .29176 .5598 Metetra
.75 .546 .619 r
.29176 .5598 .2963 .60626 .31026 .5609 .30534 .52011 Metetra
.729 .536 .629 r
.30534 .52011 .31026 .5609 .32362 .52167 .31802 .49172 Metetra
.689 .526 .661 r
.31802 .49172 .32362 .52167 .33614 .49395 .3297 .47821 Metetra
.482 .482 .781 r
.3297 .47821 .33614 .49395 .34774 .48122 .34045 .48098 Metetra
.845 .419 .22 r
.34045 .48098 .34774 .48122 .35851 .48476 .35048 .49921 Metetra
.803 .476 .437 r
.35048 .49921 .35851 .48476 .36865 .50364 .36009 .52986 Metetra
.776 .474 .475 r
.36009 .52986 .36865 .50364 .37845 .53475 .36964 .56789 Metetra
.756 .461 .485 r
.36964 .56789 .37845 .53475 .38825 .57294 .37949 .60673 Metetra
.734 .437 .478 r
.37949 .60673 .38825 .57294 .39837 .61161 .38993 .63917 Metetra
.695 .384 .446 r
.38993 .63917 .39837 .61161 .40905 .64356 .40113 .65868 Metetra
.54 .169 .286 r
.40113 .65868 .40905 .64356 .42043 .66232 .4131 .66084 Metetra
.907 .892 .803 r
.4131 .66084 .42043 .66232 .43247 .66362 .42569 .64449 Metetra
.83 .649 .658 r
.42569 .64449 .43247 .66362 .44503 .64647 .43865 .61203 Metetra
.796 .591 .623 r
.43865 .61203 .44503 .64647 .45786 .61341 .4517 .5688 Metetra
.776 .564 .612 r
.4517 .5688 .45786 .61341 .4707 .5699 .46458 .52179 Metetra
.759 .548 .611 r
.46458 .52179 .4707 .5699 .48336 .52295 .47716 .47816 Metetra
.74 .537 .619 r
.47716 .47816 .48336 .52295 .49572 .47969 .48941 .44406 Metetra
.71 .528 .642 r
.48941 .44406 .49572 .47969 .5078 .4462 .50138 .42391 Metetra
.621 .515 .712 r
.50138 .42391 .5078 .4462 .5197 .42681 .51323 .42 Metetra
0 0 .496 r
.51323 .42 .5197 .42681 .53157 .42369 .52514 .43238 Metetra
.822 .448 .348 r
.52514 .43238 .53157 .42369 .54359 .4368 .53726 .45886 Metetra
.789 .462 .436 r
.53726 .45886 .54359 .4368 .55592 .46383 .54974 .49509 Metetra
.766 .455 .459 r
.54974 .49509 .55592 .46383 .56865 .50036 .56262 .53495 Metetra
.744 .436 .461 r
.56262 .53495 .56865 .50036 .5818 .54019 .57583 .57122 Metetra
.712 .397 .443 r
.57583 .57122 .5818 .54019 .59526 .57609 .58919 .59679 Metetra
.63 .285 .368 r
.58919 .59679 .59526 .57609 .6088 .60098 .60248 .6061 Metetra
.60248 .6061 .6088 .60098 .62216 .60945 .61543 .59658 Metetra
.867 .71 .685 r
.61543 .59658 .62216 .60945 .63507 .59907 .62785 .56927 Metetra
.815 .609 .624 r
.62785 .56927 .63507 .59907 .64735 .57105 .6397 .52858 Metetra
.789 .571 .606 r
.6397 .52858 .64735 .57105 .65898 .52994 .65106 .48117 Metetra
.77 .551 .602 r
.65106 .48117 .65898 .52994 .6701 .48245 .66217 .43443 Metetra
.751 .538 .608 r
.66217 .43443 .6701 .48245 .68098 .43598 .67334 .39513 Metetra
.725 .529 .625 r
.67334 .39513 .68098 .43598 .69199 .39721 .68492 .36848 Metetra
.671 .521 .672 r
.68492 .36848 .69199 .39721 .70349 .37129 .69724 .35768 Metetra
.366 .455 .82 r
.69724 .35768 .70349 .37129 .71583 .36129 .71053 .36366 Metetra
.821 .362 .131 r
.71053 .36366 .71583 .36129 .72925 .36805 .72493 .38509 Metetra
.802 .44 .371 r
.72493 .38509 .72925 .36805 .74387 .39013 .7404 .41843 Metetra
.776 .442 .422 r
.7404 .41843 .74387 .39013 .7596 .42389 .75668 .45812 Metetra
.753 .429 .435 r
.75668 .45812 .7596 .42389 .77618 .46369 .77335 .49715 Metetra
.725 .4 .429 r
.77335 .49715 .77618 .46369 .7931 .50248 .7898 .52806 Metetra
.67 .329 .388 r
.7898 .52806 .7931 .50248 .80974 .53281 .80541 .54437 Metetra
.4 0 .137 r
.80541 .54437 .80974 .53281 .82541 .54831 .81962 .54209 Metetra
.923 .841 .746 r
.81962 .54209 .82541 .54831 .83957 .54514 .83218 .52082 Metetra
.841 .64 .63 r
.83218 .52082 .83957 .54514 .85197 .52307 .84314 .48381 Metetra
.805 .583 .601 r
.84314 .48381 .85197 .52307 .86269 .48551 .85292 .43714 Metetra
.782 .555 .593 r
.85292 .43714 .86269 .48551 .8722 .43863 .86215 .38825 Metetra
.761 .539 .596 r
.86215 .38825 .8722 .43863 .8812 .38987 .87161 .34439 Metetra
.738 .529 .61 r
.87161 .34439 .8812 .38987 .89049 .34646 .88204 .31155 Metetra
.774 .571 .624 r
.27261 .56645 .27758 .60535 .29176 .5598 .28653 .52476 Metetra
.757 .563 .634 r
.28653 .52476 .29176 .5598 .30534 .52011 .29957 .49326 Metetra
.723 .557 .665 r
.29957 .49326 .30534 .52011 .31802 .49172 .31154 .47601 Metetra
.585 .541 .772 r
.31154 .47601 .31802 .49172 .3297 .47821 .32248 .47492 Metetra
.817 .337 .035 r
.32248 .47492 .3297 .47821 .34045 .48098 .33256 .4897 Metetra
.827 .482 .403 r
.33256 .4897 .34045 .48098 .35048 .49921 .34208 .51782 Metetra
.803 .489 .458 r
.34208 .51782 .35048 .49921 .36009 .52986 .35141 .55469 Metetra
.785 .48 .472 r
.35141 .55469 .36009 .52986 .36964 .56789 .36094 .59402 Metetra
.766 .459 .467 r
.36094 .59402 .36964 .56789 .37949 .60673 .37103 .62864 Metetra
.734 .412 .436 r
.37103 .62864 .37949 .60673 .38993 .63917 .3819 .65171 Metetra
.618 .233 .29 r
.3819 .65171 .38993 .63917 .40113 .65868 .39364 .6582 Metetra
.864 .948 .868 r
.39364 .6582 .40113 .65868 .4131 .66084 .40614 .64609 Metetra
.846 .679 .675 r
.40614 .64609 .4131 .66084 .42569 .64449 .41915 .61699 Metetra
.817 .616 .631 r
.41915 .61699 .42569 .64449 .43865 .61203 .43238 .57564 Metetra
.799 .589 .617 r
.43238 .57564 .43865 .61203 .4517 .5688 .44552 .52879 Metetra
.785 .574 .615 r
.44552 .52879 .4517 .5688 .46458 .52179 .45838 .48369 Metetra
.768 .564 .623 r
.45838 .48369 .46458 .52179 .47716 .47816 .47085 .44682 Metetra
.742 .558 .645 r
.47085 .44682 .47716 .47816 .48941 .44406 .48297 .42305 Metetra
.672 .552 .711 r
.48297 .42305 .48941 .44406 .50138 .42391 .49485 .4152 Metetra
0 .288 .787 r
.49485 .4152 .50138 .42391 .51323 .42 .50665 .42385 Metetra
.84 .435 .275 r
.50665 .42385 .51323 .42 .52514 .43238 .51858 .44733 Metetra
.816 .472 .406 r
.51858 .44733 .52514 .43238 .53726 .45886 .53077 .48179 Metetra
.796 .471 .439 r
.53077 .48179 .53726 .45886 .54974 .49509 .54334 .52145 Metetra
.776 .455 .444 r
.54334 .52145 .54974 .49509 .56262 .53495 .55628 .55927 Metetra
.749 .42 .426 r
.55628 .55927 .56262 .53495 .57583 .57122 .56946 .58796 Metetra
.683 .32 .351 r
.56946 .58796 .57583 .57122 .58919 .59679 .5827 .60147 Metetra
.5827 .60147 .58919 .59679 .60248 .6061 .59575 .59642 Metetra
.879 .748 .715 r
.59575 .59642 .60248 .6061 .61543 .59658 .6084 .57297 Metetra
.836 .638 .635 r
.6084 .57297 .61543 .59658 .62785 .56927 .62054 .53483 Metetra
.813 .599 .612 r
.62054 .53483 .62785 .56927 .6397 .52858 .6322 .48826 Metetra
.796 .578 .606 r
.6322 .48826 .6397 .52858 .65106 .48117 .64354 .44064 Metetra
.779 .566 .611 r
.64354 .44064 .65106 .48117 .66217 .43443 .65484 .39899 Metetra
.757 .559 .629 r
.65484 .39899 .66217 .43443 .67334 .39513 .66642 .36895 Metetra
.711 .554 .674 r
.66642 .36895 .67334 .39513 .68492 .36848 .67858 .35421 Metetra
.5 .524 .813 r
.67858 .35421 .68492 .36848 .69724 .35768 .69159 .35625 Metetra
.778 .273 0 r
.69159 .35625 .69724 .35768 .71053 .36366 .70562 .37429 Metetra
.828 .44 .317 r
.70562 .37429 .71053 .36366 .72493 .38509 .72068 .40527 Metetra
.807 .454 .389 r
.72068 .40527 .72493 .38509 .7404 .41843 .73659 .44408 Metetra
.787 .445 .409 r
.73659 .44408 .7404 .41843 .75668 .45812 .753 .48397 Metetra
.762 .419 .404 r
.753 .48397 .75668 .45812 .77335 .49715 .76938 .51746 Metetra
.715 .352 .361 r
.76938 .51746 .77335 .49715 .7898 .52806 .78512 .5377 Metetra
.5 .053 .12 r
.78512 .5377 .7898 .52806 .80541 .54437 .79966 .53997 Metetra
.909 .893 .802 r
.79966 .53997 .80541 .54437 .81962 .54209 .81268 .52297 Metetra
.862 .674 .646 r
.81268 .52297 .81962 .54209 .83218 .52082 .82413 .48915 Metetra
.831 .613 .607 r
.82413 .48915 .83218 .52082 .84314 .48381 .83432 .44404 Metetra
.81 .585 .596 r
.83432 .44404 .84314 .48381 .85292 .43714 .84383 .39492 Metetra
.792 .569 .598 r
.84383 .39492 .85292 .43714 .86215 .38825 .85336 .3492 Metetra
.771 .559 .612 r
.85336 .3492 .86215 .38825 .87161 .34439 .86365 .31327 Metetra
.736 .555 .648 r
.86365 .31327 .87161 .34439 .88204 .31155 .87533 .29166 Metetra
.812 .618 .641 r
.26663 .54181 .27261 .56645 .28653 .52476 .28032 .50401 Metetra
.791 .618 .666 r
.28032 .50401 .28653 .52476 .29957 .49326 .29298 .47848 Metetra
.73 .623 .74 r
.29298 .47848 .29957 .49326 .31154 .47601 .30451 .46836 Metetra
0 .357 .827 r
.30451 .46836 .31154 .47601 .32248 .47492 .315 .47458 Metetra
.863 .457 .261 r
.315 .47458 .32248 .47492 .33256 .4897 .3247 .49581 Metetra
.857 .512 .399 r
.3247 .49581 .33256 .4897 .34208 .51782 .33395 .52858 Metetra
.845 .518 .433 r
.33395 .52858 .34208 .51782 .35141 .55469 .34317 .56745 Metetra
.833 .507 .436 r
.34317 .56745 .35141 .55469 .36094 .59402 .35276 .60561 Metetra
.816 .474 .41 r
.35276 .60561 .36094 .59402 .37103 .62864 .36306 .63584 Metetra
.764 .368 .302 r
.36306 .63584 .37103 .62864 .3819 .65171 .37426 .65193 Metetra
.207 .734 .812 r
.37426 .65193 .3819 .65171 .39364 .6582 .38637 .65007 Metetra
.863 .75 .737 r
.38637 .65007 .39364 .6582 .40614 .64609 .3992 .62987 Metetra
.855 .673 .655 r
.3992 .62987 .40614 .64609 .41915 .61699 .41248 .59444 Metetra
.846 .644 .63 r
.41248 .59444 .41915 .61699 .43238 .57564 .42587 .54963 Metetra
.837 .63 .623 r
.42587 .54963 .43238 .57564 .44552 .52879 .43907 .5026 Metetra
.826 .623 .628 r
.43907 .5026 .44552 .52879 .45838 .48369 .45191 .4604 Metetra
.808 .62 .648 r
.45191 .4604 .45838 .48369 .47085 .44682 .46433 .42887 Metetra
.768 .623 .699 r
.46433 .42887 .47085 .44682 .48297 .42305 .47638 .41201 Metetra
.554 .603 .857 r
.47638 .41201 .48297 .42305 .49485 .4152 .4882 .41162 Metetra
.777 .274 0 r
.4882 .41162 .49485 .4152 .50665 .42385 .49998 .42729 Metetra
.866 .475 .299 r
.49998 .42729 .50665 .42385 .51858 .44733 .5119 .45632 Metetra
.857 .5 .374 r
.5119 .45632 .51858 .44733 .53077 .48179 .52411 .49397 Metetra
.846 .496 .392 r
.52411 .49397 .53077 .48179 .54334 .52145 .5367 .53376 Metetra
.829 .472 .38 r
.5367 .53376 .54334 .52145 .55628 .55927 .54964 .56837 Metetra
.793 .402 .313 r
.54964 .56837 .55628 .55927 .56946 .58796 .5628 .59088 Metetra
.54 0 0 r
.5628 .59088 .56946 .58796 .5827 .60147 .57596 .59625 Metetra
.858 .844 .83 r
.57596 .59625 .5827 .60147 .59575 .59642 .5889 .58263 Metetra
.873 .704 .67 r
.5889 .58263 .59575 .59642 .6084 .57297 .60143 .55186 Metetra
.862 .659 .627 r
.60143 .55186 .6084 .57297 .62054 .53483 .6135 .50897 Metetra
.852 .639 .613 r
.6135 .50897 .62054 .53483 .6322 .48826 .62516 .46092 Metetra
.841 .628 .615 r
.62516 .46092 .6322 .48826 .64354 .44064 .63661 .41509 Metetra
.825 .623 .63 r
.63661 .41509 .64354 .44064 .65484 .39899 .64812 .378 Metetra
.795 .624 .67 r
.64812 .378 .65484 .39899 .66642 .36895 .66001 .35446 Metetra
.695 .625 .774 r
.66001 .35446 .66642 .36895 .67858 .35421 .67255 .34719 Metetra
0 .263 .757 r
.67255 .34719 .67858 .35421 .69159 .35625 .68597 .35665 Metetra
.845 .387 .105 r
.68597 .35665 .69159 .35625 .70562 .37429 .70039 .38103 Metetra
.864 .466 .28 r
.70039 .38103 .70562 .37429 .72068 .40527 .71574 .4163 Metetra
.856 .476 .327 r
.71574 .4163 .72068 .40527 .73659 .44408 .73179 .45654 Metetra
.841 .46 .33 r
.73179 .45654 .73659 .44408 .753 .48397 .74813 .49452 Metetra
.812 .409 .287 r
.74813 .49452 .753 .48397 .76938 .51746 .7642 .52283 Metetra
.698 .211 .087 r
.7642 .52283 .76938 .51746 .78512 .5377 .77942 .53539 Metetra
.661 .938 .966 r
.77942 .53539 .78512 .5377 .79966 .53997 .79333 .52889 Metetra
.891 .754 .703 r
.79333 .52889 .79966 .53997 .81268 .52297 .80571 .50375 Metetra
.882 .681 .626 r
.80571 .50375 .81268 .52297 .82413 .48915 .81668 .46394 Metetra
.87 .65 .602 r
.81668 .46394 .82413 .48915 .83432 .44404 .82665 .41599 Metetra
.859 .635 .599 r
.82665 .41599 .83432 .44404 .84383 .39492 .83624 .36743 Metetra
.844 .628 .61 r
.83624 .36743 .84383 .39492 .85336 .3492 .84617 .32534 Metetra
.818 .627 .643 r
.84617 .32534 .85336 .3492 .86365 .31327 .85711 .29535 Metetra
.756 .629 .72 r
.85711 .29535 .86365 .31327 .87533 .29166 .86964 .28105 Metetra
.889 .714 .659 r
.25943 .53283 .26663 .54181 .28032 .50401 .27318 .49556 Metetra
.868 .725 .701 r
.27318 .49556 .28032 .50401 .29298 .47848 .28585 .47085 Metetra
.776 .74 .82 r
.28585 .47085 .29298 .47848 .30451 .46836 .29735 .46169 Metetra
0 .236 .717 r
.29735 .46169 .30451 .46836 .315 .47458 .30778 .46887 Metetra
.889 .463 .137 r
.30778 .46887 .315 .47458 .3247 .49581 .3174 .49096 Metetra
.924 .552 .292 r
.3174 .49096 .3247 .49581 .33395 .52858 .32657 .52432 Metetra
.927 .57 .328 r
.32657 .52432 .33395 .52858 .34317 .56745 .33572 .56341 Metetra
.925 .562 .317 r
.33572 .56341 .34317 .56745 .35276 .60561 .34527 .60134 Metetra
.909 .514 .241 r
.34527 .60134 .35276 .60561 .36306 .63584 .35557 .63091 Metetra
.772 .268 0 r
.35557 .63091 .36306 .63584 .37426 .65193 .3668 .64599 Metetra
.62 .775 .955 r
.3668 .64599 .37426 .65193 .38637 .65007 .37899 .64295 Metetra
.877 .765 .735 r
.37899 .64295 .38637 .65007 .3992 .62987 .39194 .62161 Metetra
.907 .738 .661 r
.39194 .62161 .3992 .62987 .41248 .59444 .40535 .58532 Metetra
.914 .726 .635 r
.40535 .58532 .41248 .59444 .42587 .54963 .41886 .54005 Metetra
.914 .722 .628 r
.41886 .54005 .42587 .54963 .43907 .5026 .43219 .493 Metetra
.91 .724 .639 r
.43219 .493 .43907 .5026 .45191 .4604 .44512 .45121 Metetra
.895 .732 .673 r
.44512 .45121 .45191 .4604 .46433 .42887 .45761 .42041 Metetra
.841 .747 .76 r
.45761 .42041 .46433 .42887 .47638 .41201 .4697 .40448 Metetra
.465 .654 .942 r
.4697 .40448 .47638 .41201 .4882 .41162 .48153 .40509 Metetra
.722 .232 0 r
.48153 .40509 .4882 .41162 .49998 .42729 .49329 .42168 Metetra
.898 .481 .127 r
.49329 .42168 .49998 .42729 .5119 .45632 .50518 .45143 Metetra
.922 .531 .214 r
.50518 .45143 .5119 .45632 .52411 .49397 .51735 .48945 Metetra
.923 .533 .222 r
.51735 .48945 .52411 .49397 .5367 .53376 .5299 .5292 Metetra
.906 .496 .166 r
.5299 .5292 .5367 .53376 .54964 .56837 .54281 .5633 Metetra
.815 .339 0 r
.54281 .5633 .54964 .56837 .5628 .59088 .55595 .5849 Metetra
.12 .527 .915 r
.55595 .5849 .5628 .59088 .57596 .59625 .56912 .58911 Metetra
.85 .798 .8 r
.56912 .58911 .57596 .59625 .5889 .58263 .5821 .57429 Metetra
.918 .762 .673 r
.5821 .57429 .5889 .58263 .60143 .55186 .59471 .54251 Metetra
.932 .744 .625 r
.59471 .54251 .60143 .55186 .6135 .50897 .60687 .49897 Metetra
.935 .736 .609 r
.60687 .49897 .6135 .50897 .62516 .46092 .61864 .45073 Metetra
.933 .736 .614 r
.61864 .45073 .62516 .46092 .63661 .41509 .63021 .40515 Metetra
.922 .743 .642 r
.63021 .40515 .63661 .41509 .64812 .378 .64183 .36868 Metetra
.886 .756 .713 r
.64183 .36868 .64812 .378 .66001 .35446 .65382 .34602 Metetra
.715 .741 .872 r
.65382 .34602 .66001 .35446 .67255 .34719 .66645 .33976 Metetra
0 .221 .728 r
.66645 .33976 .67255 .34719 .68597 .35665 .67994 .3502 Metetra
.78 .321 0 r
.67994 .3502 .68597 .35665 .70039 .38103 .6944 .37539 Metetra
.874 .447 .034 r
.6944 .37539 .70039 .38103 .71574 .4163 .70976 .4112 Metetra
.891 .473 .077 r
.70976 .4112 .71574 .4163 .73179 .45654 .7258 .45157 Metetra
.876 .447 .043 r
.7258 .45157 .73179 .45654 .74813 .49452 .7421 .48921 Metetra
.797 .331 0 r
.7421 .48921 .74813 .49452 .7642 .52283 .75812 .51674 Metetra
0 .179 .667 r
.75812 .51674 .7642 .52283 .77942 .53539 .77329 .52818 Metetra
.745 .808 .902 r
.77329 .52818 .77942 .53539 .79333 .52889 .78716 .52045 Metetra
.923 .794 .701 r
.78716 .52045 .79333 .52889 .80571 .50375 .79953 .49417 Metetra
.951 .767 .617 r
.79953 .49417 .80571 .50375 .81668 .46394 .81053 .45355 Metetra
.958 .753 .585 r
.81053 .45355 .81668 .46394 .82665 .41599 .82057 .40522 Metetra
.957 .75 .581 r
.82057 .40522 .82665 .41599 .83624 .36743 .83028 .35674 Metetra
.95 .755 .605 r
.83028 .35674 .83624 .36743 .84617 .32534 .84036 .31516 Metetra
.925 .768 .667 r
.84036 .31516 .84617 .32534 .85711 .29535 .85147 .28597 Metetra
.826 .772 .801 r
.85147 .28597 .85711 .29535 .86964 .28105 .86416 .27265 Metetra
.98 .846 .637 r
.2509 .53954 .25943 .53283 .27318 .49556 .26507 .49896 Metetra
.966 .863 .686 r
.26507 .49896 .27318 .49556 .28585 .47085 .2782 .46948 Metetra
.895 .879 .812 r
.2782 .46948 .28585 .47085 .29735 .46169 .29015 .45482 Metetra
.362 .623 .952 r
.29015 .45482 .29735 .46169 .30778 .46887 .30096 .45653 Metetra
0 0 .365 r
.30096 .45653 .30778 .46887 .3174 .49096 .31083 .4739 Metetra
.807 .461 0 r
.31083 .4739 .3174 .49096 .32657 .52432 .32011 .50404 Metetra
.845 .521 0 r
.32011 .50404 .32657 .52432 .33572 .56341 .32921 .54198 Metetra
.827 .511 0 r
.32921 .54198 .33572 .56341 .34527 .60134 .33857 .58118 Metetra
.741 .425 0 r
.33857 .58118 .34527 .60134 .35557 .63091 .34859 .6144 Metetra
0 0 .459 r
.34859 .6144 .35557 .63091 .3668 .64599 .35952 .63495 Metetra
.388 .533 .88 r
.35952 .63495 .3668 .64599 .37899 .64295 .37145 .6382 Metetra
.869 .823 .8 r
.37145 .6382 .37899 .64295 .39194 .62161 .38424 .62276 Metetra
.967 .851 .675 r
.38424 .62276 .39194 .62161 .40535 .58532 .39762 .59084 Metetra
.989 .849 .61 r
.39762 .59084 .40535 .58532 .41886 .54005 .41123 .54768 Metetra
.995 .85 .583 r
.41123 .54768 .41886 .54005 .43219 .493 .42474 .50027 Metetra
.995 .858 .586 r
.42474 .50027 .43219 .493 .44512 .45121 .43792 .45585 Metetra
.988 .875 .627 r
.43792 .45585 .44512 .45121 .45761 .42041 .45064 .4207 Metetra
.951 .901 .738 r
.45064 .4207 .45761 .42041 .4697 .40448 .46291 .39938 Metetra
.697 .821 .941 r
.46291 .39938 .4697 .40448 .48153 .40509 .47486 .39433 Metetra
0 .178 .714 r
.47486 .39433 .48153 .40509 .49329 .42168 .48666 .40573 Metetra
0 0 .352 r
.48666 .40573 .49329 .42168 .50518 .45143 .49852 .43152 Metetra
0 0 .228 r
.49852 .43152 .50518 .45143 .51735 .48945 .5106 .46747 Metetra
0 0 .217 r
.5106 .46747 .51735 .48945 .5299 .5292 .52304 .50751 Metetra
0 0 .288 r
.52304 .50751 .5299 .5292 .54281 .5633 .53586 .5444 Metetra
0 0 .47 r
.53586 .5444 .54281 .5633 .55595 .5849 .54898 .57093 Metetra
.13 .319 .786 r
.54898 .57093 .55595 .5849 .56912 .58911 .56223 .58135 Metetra
.761 .777 .866 r
.56223 .58135 .56912 .58911 .5821 .57429 .57536 .57285 Metetra
.962 .873 .701 r
.57536 .57285 .5821 .57429 .59471 .54251 .58818 .54624 Metetra
.995 .867 .585 r
.58818 .54624 .59471 .54251 .60687 .49897 .60057 .50581 Metetra
.996 .857 .527 r
.60057 .50581 .60687 .49897 .61864 .45073 .61254 .45816 Metetra
.993 .858 .513 r
.61254 .45816 .61864 .45073 .63021 .40515 .62424 .41076 Metetra
.991 .875 .543 r
.62424 .41076 .63021 .40515 .64183 .36868 .63589 .37048 Metetra
.981 .911 .646 r
.63589 .37048 .64183 .36868 .65382 .34602 .64779 .34268 Metetra
.861 .911 .864 r
.64779 .34268 .65382 .34602 .66645 .33976 .66024 .33067 Metetra
.269 .505 .897 r
.66024 .33067 .66645 .33976 .67994 .3502 .67348 .33557 Metetra
0 .024 .596 r
.67348 .33557 .67994 .3502 .6944 .37539 .68765 .35616 Metetra
0 0 .441 r
.68765 .35616 .6944 .37539 .70976 .4112 .70278 .38901 Metetra
0 0 .399 r
.70278 .38901 .70976 .4112 .7258 .45157 .71868 .42867 Metetra
0 0 .428 r
.71868 .42867 .7258 .45157 .7421 .48921 .73501 .46814 Metetra
0 0 .525 r
.73501 .46814 .7421 .48921 .75812 .51674 .75126 .49989 Metetra
.024 .204 .712 r
.75126 .49989 .75812 .51674 .77329 .52818 .76684 .51729 Metetra
.565 .643 .887 r
.76684 .51729 .77329 .52818 .78716 .52045 .78126 .5161 Metetra
.934 .886 .761 r
.78126 .5161 .78716 .52045 .79953 .49417 .79421 .49568 Metetra
.991 .883 .564 r
.79421 .49568 .79953 .49417 .81053 .45355 .80571 .45912 Metetra
.974 .849 .451 r
.80571 .45912 .81053 .45355 .82057 .40522 .81608 .4124 Metetra
.958 .833 .405 r
.81608 .4124 .82057 .40522 .83028 .35674 .82589 .36299 Metetra
.954 .844 .418 r
.82589 .36299 .83028 .35674 .84036 .31516 .83582 .31825 Metetra
.966 .89 .512 r
.83582 .31825 .84036 .31516 .85147 .28597 .84658 .28428 Metetra
.943 .953 .746 r
.84658 .28428 .85147 .28597 .86416 .27265 .85875 .26529 Metetra
.939 .887 .48 r
.24096 .56163 .2509 .53954 .26507 .49896 .2557 .51644 Metetra
.94 .906 .518 r
.2557 .51644 .26507 .49896 .2782 .46948 .26964 .47875 Metetra
.946 .951 .643 r
.26964 .47875 .2782 .46948 .29015 .45482 .28247 .45362 Metetra
.83 .926 .897 r
.28247 .45362 .29015 .45482 .30096 .45653 .2941 .44408 Metetra
.196 .373 .813 r
.2941 .44408 .30096 .45653 .31083 .4739 .30464 .45096 Metetra
0 0 .517 r
.30464 .45096 .31083 .4739 .32011 .50404 .31434 .47286 Metetra
0 0 .393 r
.31434 .47286 .32011 .50404 .32921 .54198 .32357 .50618 Metetra
0 0 .362 r
.32357 .50618 .32921 .54198 .33857 .58118 .33276 .54537 Metetra
0 0 .39 r
.33276 .54537 .33857 .58118 .34859 .6144 .34236 .58353 Metetra
0 0 .482 r
.34236 .58353 .34859 .6144 .35952 .63495 .35272 .61341 Metetra
.081 .18 .669 r
.35272 .61341 .35952 .63495 .37145 .6382 .36405 .62881 Metetra
.621 .683 .887 r
.36405 .62881 .37145 .6382 .38424 .62276 .37634 .62602 Metetra
.948 .948 .737 r
.37634 .62602 .38424 .62276 .39762 .59084 .38943 .60481 Metetra
.933 .905 .511 r
.38943 .60481 .39762 .59084 .41123 .54768 .40299 .56846 Metetra
.884 .851 .395 r
.40299 .56846 .41123 .54768 .42474 .50027 .41667 .52298 Metetra
.856 .827 .352 r
.41667 .52298 .42474 .50027 .43792 .45585 .43016 .4756 Metetra
.854 .839 .371 r
.43016 .4756 .43792 .45585 .45064 .4207 .44326 .43339 Metetra
.885 .898 .481 r
.44326 .43339 .45064 .4207 .46291 .39938 .4559 .40216 Metetra
.907 .983 .764 r
.4559 .40216 .46291 .39938 .47486 .39433 .46812 .38581 Metetra
.498 .644 .921 r
.46812 .38581 .47486 .39433 .48666 .40573 .48007 .38607 Metetra
.033 .159 .665 r
.48007 .38607 .48666 .40573 .49852 .43152 .49194 .40241 Metetra
0 0 .526 r
.49194 .40241 .49852 .43152 .5106 .46747 .50394 .43205 Metetra
0 0 .479 r
.50394 .43205 .5106 .46747 .52304 .50751 .51622 .4701 Metetra
0 0 .481 r
.51622 .4701 .52304 .50751 .53586 .5444 .52889 .51002 Metetra
0 0 .526 r
.52889 .51002 .53586 .5444 .54898 .57093 .54192 .54441 Metetra
.068 .14 .63 r
.54192 .54441 .54898 .57093 .56223 .58135 .5552 .56633 Metetra
.413 .48 .819 r
.5552 .56633 .56223 .58135 .57536 .57285 .56852 .57082 Metetra
.891 .93 .837 r
.56852 .57082 .57536 .57285 .58818 .54624 .58165 .55618 Metetra
.894 .901 .488 r
.58165 .55618 .58818 .54624 .60057 .50581 .59441 .52441 Metetra
.784 .782 .28 r
.59441 .52441 .60057 .50581 .61254 .45816 .60671 .48072 Metetra
.722 .723 .198 r
.60671 .48072 .61254 .45816 .62424 .41076 .61862 .43217 Metetra
.706 .716 .191 r
.61862 .43217 .62424 .41076 .63589 .37048 .63031 .3862 Metetra
.741 .772 .271 r
.63031 .3862 .63589 .37048 .64779 .34268 .64206 .34929 Metetra
.847 .924 .536 r
.64206 .34929 .64779 .34268 .66024 .33067 .65417 .32619 Metetra
.734 .873 .945 r
.65417 .32619 .66024 .33067 .67348 .33557 .66692 .31953 Metetra
.243 .349 .773 r
.66692 .31953 .67348 .33557 .68765 .35616 .68054 .32966 Metetra
.049 .125 .622 r
.68054 .32966 .68765 .35616 .70278 .38901 .69515 .35467 Metetra
0 .05 .563 r
.69515 .35467 .70278 .38901 .71868 .42867 .71068 .39044 Metetra
0 .037 .55 r
.71068 .39044 .71868 .42867 .73501 .46814 .72692 .43091 Metetra
.021 .066 .569 r
.72692 .43091 .73501 .46814 .75126 .49989 .74343 .46879 Metetra
.106 .15 .625 r
.74343 .46879 .75126 .49989 .76684 .51729 .75966 .49663 Metetra
.3 .348 .745 r
.75966 .49663 .76684 .51729 .78126 .5161 .77504 .50838 Metetra
.735 .796 .901 r
.77504 .50838 .78126 .5161 .79421 .49568 .7891 .50087 Metetra
.873 .921 .526 r
.7891 .50087 .79421 .49568 .80571 .45912 .80163 .47466 Metetra
.80163 .47466 .80571 .45912 .81608 .4124 .81276 .43394 Metetra
.81276 .43394 .81608 .4124 .82589 .36299 .8229 .38535 Metetra
.8229 .38535 .82589 .36299 .83582 .31825 .83269 .33651 Metetra
.83269 .33651 .83582 .31825 .84658 .28428 .84284 .29448 Metetra
.84284 .29448 .84658 .28428 .85875 .26529 .85404 .26484 Metetra
.737 .772 .273 r
.22992 .59396 .24096 .56163 .2557 .51644 .24503 .54746 Metetra
.732 .77 .271 r
.24503 .54746 .2557 .51644 .26964 .47875 .25978 .50252 Metetra
.768 .818 .343 r
.25978 .50252 .26964 .47875 .28247 .45362 .27369 .46563 Metetra
.861 .934 .558 r
.27369 .46563 .28247 .45362 .2941 .44408 .28648 .44168 Metetra
.796 .899 .915 r
.28648 .44168 .2941 .44408 .30464 .45096 .29808 .43354 Metetra
.269 .338 .749 r
.29808 .43354 .30464 .45096 .31434 .47286 .30861 .44183 Metetra
.019 .059 .562 r
.30861 .44183 .31434 .47286 .32357 .50618 .31834 .46495 Metetra
0 0 .485 r
.31834 .46495 .32357 .50618 .33276 .54537 .32765 .49909 Metetra
0 0 .463 r
.32765 .49909 .33276 .54537 .34236 .58353 .33697 .53857 Metetra
0 0 .479 r
.33697 .53857 .34236 .58353 .35272 .61341 .34674 .57637 Metetra
.008 .036 .539 r
.34674 .57637 .35272 .61341 .36405 .62881 .35728 .60525 Metetra
.194 .24 .683 r
.35728 .60525 .36405 .62881 .37634 .62602 .36879 .61916 Metetra
.673 .768 .922 r
.36879 .61916 .37634 .62602 .38943 .60481 .38126 .61465 Metetra
.842 .939 .571 r
.38126 .61465 .38943 .60481 .40299 .56846 .39447 .5918 Metetra
.67 .744 .246 r
.39447 .5918 .40299 .56846 .41667 .52298 .40812 .55422 Metetra
.40812 .55422 .41667 .52298 .43016 .4756 .42184 .50809 Metetra
.42184 .50809 .43016 .4756 .44326 .43339 .43534 .46071 Metetra
.43534 .46071 .44326 .43339 .4559 .40216 .44844 .41911 Metetra
.693 .785 .308 r
.44844 .41911 .4559 .40216 .46812 .38581 .46109 .38895 Metetra
.87 .994 .765 r
.46109 .38895 .46812 .38581 .48007 .38607 .47335 .37396 Metetra
.478 .55 .852 r
.47335 .37396 .48007 .38607 .49194 .40241 .48538 .37566 Metetra
.175 .201 .648 r
.48538 .37566 .49194 .40241 .50394 .43205 .49737 .39333 Metetra
.072 .08 .561 r
.49737 .39333 .50394 .43205 .51622 .4701 .50951 .42398 Metetra
.04 .04 .529 r
.50951 .42398 .51622 .4701 .52889 .51002 .52198 .46256 Metetra
.044 .043 .53 r
.52198 .46256 .52889 .51002 .54192 .54441 .53483 .50238 Metetra
.083 .085 .561 r
.53483 .50238 .54192 .54441 .5552 .56633 .54805 .53599 Metetra
.182 .198 .641 r
.54805 .53599 .5552 .56633 .56852 .57082 .56148 .55656 Metetra
.46 .52 .833 r
.56148 .55656 .56852 .57082 .58165 .55618 .5749 .55934 Metetra
.852 .992 .737 r
.5749 .55934 .58165 .55618 .59441 .52441 .58808 .54295 Metetra
.58808 .54295 .59441 .52441 .60671 .48072 .60085 .50973 Metetra
.60085 .50973 .60671 .48072 .61862 .43217 .61314 .46513 Metetra
0 0 .051 r
.61314 .46513 .61862 .43217 .63031 .3862 .62504 .41633 Metetra
0 0 .039 r
.62504 .41633 .63031 .3862 .64206 .34929 .63674 .37075 Metetra
.63674 .37075 .64206 .34929 .65417 .32619 .64854 .33476 Metetra
.705 .849 .424 r
.64854 .33476 .65417 .32619 .66692 .31953 .66075 .31294 Metetra
.689 .794 .93 r
.66075 .31294 .66692 .31953 .68054 .32966 .67367 .30773 Metetra
.31 .331 .721 r
.67367 .30773 .68054 .32966 .69515 .35467 .68751 .31928 Metetra
.185 .179 .618 r
.68751 .31928 .69515 .35467 .71068 .39044 .70236 .34546 Metetra
.143 .127 .579 r
.70236 .34546 .71068 .39044 .72692 .43091 .71816 .38196 Metetra
.136 .117 .57 r
.71816 .38196 .72692 .43091 .74343 .46879 .73465 .42259 Metetra
.155 .137 .584 r
.73465 .42259 .74343 .46879 .75966 .49663 .75137 .45994 Metetra
.209 .2 .629 r
.75137 .45994 .75966 .49663 .77504 .50838 .76774 .48661 Metetra
.354 .374 .743 r
.76774 .48661 .77504 .50838 .7891 .50087 .78316 .49672 Metetra
.783 .918 .929 r
.78316 .49672 .7891 .50087 .80163 .47466 .79719 .48739 Metetra
.79719 .48739 .80163 .47466 .81276 .43394 .80965 .45956 Metetra
0 0 .099 r
.80965 .45956 .81276 .43394 .8229 .38535 .82068 .41767 Metetra
0 0 .176 r
.82068 .41767 .8229 .38535 .83269 .33651 .83075 .36856 Metetra
0 0 .185 r
.83075 .36856 .83269 .33651 .84284 .29448 .84053 .31986 Metetra
0 0 .134 r
.84053 .31986 .84284 .29448 .85404 .26484 .85075 .27858 Metetra
.673 .746 .248 r
.21879 .62445 .22992 .59396 .24503 .54746 .23369 .58337 Metetra
.23369 .58337 .24503 .54746 .25978 .50252 .24886 .53668 Metetra
.24886 .53668 .25978 .50252 .27369 .46563 .26366 .4916 Metetra
.689 .764 .273 r
.26366 .4916 .27369 .46563 .28648 .44168 .27761 .45465 Metetra
.822 .915 .519 r
.27761 .45465 .28648 .44168 .29808 .43354 .29046 .4307 Metetra
.793 .887 .913 r
.29046 .4307 .29808 .43354 .30861 .44183 .30213 .42261 Metetra
.3 .338 .734 r
.30213 .42261 .30861 .44183 .31834 .46495 .31274 .431 Metetra
.08 .091 .569 r
.31274 .431 .31834 .46495 .32765 .49909 .32256 .45424 Metetra
.002 .002 .502 r
.32256 .45424 .32765 .49909 .33697 .53857 .33199 .48851 Metetra
0 0 .482 r
.33199 .48851 .33697 .53857 .34674 .57637 .34144 .52808 Metetra
0 0 .495 r
.34144 .52808 .34674 .57637 .35728 .60525 .35134 .56593 Metetra
.052 .061 .547 r
.35134 .56593 .35728 .60525 .36879 .61916 .36201 .59479 Metetra
.212 .248 .682 r
.36201 .59479 .36879 .61916 .38126 .61465 .37364 .60859 Metetra
.676 .796 .938 r
.37364 .60859 .38126 .61465 .39447 .5918 .38621 .60389 Metetra
.744 .881 .472 r
.38621 .60389 .39447 .5918 .40812 .55422 .3995 .58081 Metetra
.3995 .58081 .40812 .55422 .42184 .50809 .4132 .54298 Metetra
.4132 .54298 .42184 .50809 .43534 .46071 .42695 .49663 Metetra
.42695 .49663 .43534 .46071 .44844 .41911 .44048 .44909 Metetra
.44048 .44909 .44844 .41911 .46109 .38895 .45362 .40739 Metetra
.45362 .40739 .46109 .38895 .47335 .37396 .46631 .3772 Metetra
.863 .995 .761 r
.46631 .3772 .47335 .37396 .48538 .37566 .47864 .36224 Metetra
.486 .532 .83 r
.47864 .36224 .48538 .37566 .49737 .39333 .49077 .36403 Metetra
.215 .215 .643 r
.49077 .36403 .49737 .39333 .50951 .42398 .50288 .3818 Metetra
.122 .106 .566 r
.50288 .3818 .50951 .42398 .52198 .46256 .51518 .41257 Metetra
.091 .069 .538 r
.51518 .41257 .52198 .46256 .53483 .50238 .52782 .45126 Metetra
.091 .07 .538 r
.52782 .45126 .53483 .50238 .54805 .53599 .54085 .49114 Metetra
.121 .106 .565 r
.54085 .49114 .54805 .53599 .56148 .55656 .55424 .52475 Metetra
.205 .208 .64 r
.55424 .52475 .56148 .55656 .5749 .55934 .56782 .54524 Metetra
.462 .526 .838 r
.56782 .54524 .5749 .55934 .58808 .54295 .58137 .54786 Metetra
.777 .963 .657 r
.58137 .54786 .58808 .54295 .60085 .50973 .59463 .53124 Metetra
.59463 .53124 .60085 .50973 .61314 .46513 .60744 .49777 Metetra
0 0 .075 r
.60744 .49777 .61314 .46513 .62504 .41633 .61975 .45292 Metetra
0 0 .116 r
.61975 .45292 .62504 .41633 .63674 .37075 .63164 .40393 Metetra
0 0 .099 r
.63164 .40393 .63674 .37075 .64854 .33476 .64336 .35822 Metetra
.64336 .35822 .64854 .33476 .66075 .31294 .65519 .32217 Metetra
.656 .816 .382 r
.65519 .32217 .66075 .31294 .67367 .30773 .66746 .30036 Metetra
.685 .772 .917 r
.66746 .30036 .67367 .30773 .68751 .31928 .68048 .29521 Metetra
.333 .331 .708 r
.68048 .29521 .68751 .31928 .70236 .34546 .69447 .30685 Metetra
.22 .194 .615 r
.69447 .30685 .70236 .34546 .71816 .38196 .70951 .33314 Metetra
.181 .146 .58 r
.70951 .33314 .71816 .38196 .73465 .42259 .72554 .36976 Metetra
.173 .136 .572 r
.72554 .36976 .73465 .42259 .75137 .45994 .74226 .41046 Metetra
.186 .153 .585 r
.74226 .41046 .75137 .45994 .76774 .48661 .75921 .44783 Metetra
.231 .209 .627 r
.75921 .44783 .76774 .48661 .78316 .49672 .77579 .47444 Metetra
.36 .376 .741 r
.77579 .47444 .78316 .49672 .79719 .48739 .79137 .48441 Metetra
.775 .954 .931 r
.79137 .48441 .79719 .48739 .80965 .45956 .8055 .47487 Metetra
.8055 .47487 .80965 .45956 .82068 .41767 .81799 .44677 Metetra
0 0 .164 r
.81799 .44677 .82068 .41767 .83075 .36856 .82902 .40463 Metetra
0 0 .225 r
.82902 .40463 .83075 .36856 .84053 .31986 .83906 .3553 Metetra
0 0 .229 r
.83906 .3553 .84053 .31986 .85075 .27858 .84881 .30645 Metetra
.856 .908 .499 r
.20863 .64149 .21879 .62445 .23369 .58337 .22278 .61128 Metetra
.773 .811 .33 r
.22278 .61128 .23369 .58337 .24886 .53668 .2378 .56925 Metetra
.734 .769 .269 r
.2378 .56925 .24886 .53668 .26366 .4916 .25302 .52222 Metetra
.733 .772 .274 r
.25302 .52222 .26366 .4916 .27761 .45465 .26782 .47746 Metetra
.774 .825 .355 r
.26782 .47746 .27761 .45465 .29046 .4307 .28175 .44135 Metetra
.871 .948 .59 r
.28175 .44135 .29046 .4307 .30213 .42261 .29455 .41862 Metetra
.753 .854 .925 r
.29455 .41862 .30213 .42261 .31274 .431 .30619 .41195 Metetra
.233 .298 .725 r
.30619 .41195 .31274 .431 .32256 .45424 .3168 .42174 Metetra
.007 .046 .551 r
.3168 .42174 .32256 .45424 .33199 .48851 .32667 .44617 Metetra
0 0 .481 r
.32667 .44617 .33199 .48851 .34144 .52808 .33619 .48123 Metetra
0 0 .464 r
.33619 .48123 .34144 .52808 .35134 .56593 .34577 .52103 Metetra
0 0 .483 r
.34577 .52103 .35134 .56593 .36201 .59479 .35584 .55845 Metetra
.019 .048 .548 r
.35584 .55845 .36201 .59479 .37364 .60859 .36671 .58625 Metetra
.223 .273 .704 r
.36671 .58625 .37364 .60859 .38621 .60389 .37853 .59851 Metetra
.728 .828 .927 r
.37853 .59851 .38621 .60389 .3995 .58081 .39126 .59207 Metetra
.822 .917 .524 r
.39126 .59207 .3995 .58081 .4132 .54298 .40467 .56737 Metetra
.40467 .56737 .4132 .54298 .42695 .49663 .41844 .52834 Metetra
.41844 .52834 .42695 .49663 .44048 .44909 .43223 .4814 Metetra
.43223 .4814 .44048 .44909 .45362 .40739 .44578 .43393 Metetra
.44578 .43393 .45362 .40739 .46631 .3772 .45891 .39289 Metetra
.709 .804 .336 r
.45891 .39289 .46631 .3772 .47864 .36224 .47163 .36381 Metetra
.868 .993 .816 r
.47163 .36381 .47864 .36224 .49077 .36403 .48401 .35023 Metetra
.434 .5 .827 r
.48401 .35023 .49077 .36403 .50288 .3818 .49622 .35347 Metetra
.16 .184 .636 r
.49622 .35347 .50288 .3818 .51518 .41257 .50846 .37256 Metetra
.067 .074 .556 r
.50846 .37256 .51518 .41257 .52782 .45126 .52092 .40431 Metetra
.039 .04 .528 r
.52092 .40431 .52782 .45126 .54085 .49114 .53375 .44345 Metetra
.047 .045 .532 r
.53375 .44345 .54085 .49114 .55424 .52475 .54698 .48316 Metetra
.089 .092 .566 r
.54698 .48316 .55424 .52475 .56782 .54524 .56055 .51594 Metetra
.198 .216 .653 r
.56055 .51594 .56782 .54524 .58137 .54786 .57428 .53501 Metetra
.506 .574 .858 r
.57428 .53501 .58137 .54786 .59463 .53124 .58792 .53589 Metetra
.833 .973 .666 r
.58792 .53589 .59463 .53124 .60744 .49777 .60123 .51753 Metetra
.60123 .51753 .60744 .49777 .61975 .45292 .61404 .48264 Metetra
0 0 .008 r
.61404 .48264 .61975 .45292 .63164 .40393 .62633 .43693 Metetra
0 0 .053 r
.62633 .43693 .63164 .40393 .64336 .35822 .63821 .38776 Metetra
0 0 .035 r
.63821 .38776 .64336 .35822 .65519 .32217 .64994 .3425 Metetra
.64994 .3425 .65519 .32217 .66746 .30036 .66183 .30742 Metetra
.739 .888 .489 r
.66183 .30742 .66746 .30036 .68048 .29521 .67423 .28693 Metetra
.639 .731 .915 r
.67423 .28693 .68048 .29521 .69447 .30685 .68743 .28323 Metetra
.291 .308 .706 r
.68743 .28323 .69447 .30685 .70951 .33314 .70164 .29627 Metetra
.179 .172 .613 r
.70164 .29627 .70951 .33314 .72554 .36976 .71695 .32371 Metetra
.142 .125 .577 r
.71695 .32371 .72554 .36976 .74226 .41046 .73325 .36101 Metetra
.138 .118 .571 r
.73325 .36101 .74226 .41046 .75921 .44783 .75024 .4018 Metetra
.159 .141 .587 r
.75024 .4018 .75921 .44783 .77579 .47444 .7674 .43857 Metetra
.217 .21 .636 r
.7674 .43857 .77579 .47444 .79137 .48441 .7841 .46395 Metetra
.378 .404 .761 r
.7841 .46395 .79137 .48441 .8055 .47487 .79972 .47223 Metetra
.817 .968 .901 r
.79972 .47223 .8055 .47487 .81799 .44677 .81381 .46087 Metetra
.81381 .46087 .81799 .44677 .82902 .40463 .82621 .43116 Metetra
0 0 .112 r
.82621 .43116 .82902 .40463 .83906 .3553 .83713 .3879 Metetra
0 0 .179 r
.83713 .3879 .83906 .3553 .84881 .30645 .84711 .33811 Metetra
.933 .921 .777 r
.19969 .6436 .20863 .64149 .22278 .61128 .21296 .62433 Metetra
.971 .923 .605 r
.21296 .62433 .22278 .61128 .2378 .56925 .22754 .58955 Metetra
.954 .897 .512 r
.22754 .58955 .2378 .56925 .25302 .52222 .24279 .54497 Metetra
.939 .885 .476 r
.24279 .54497 .25302 .52222 .26782 .47746 .25802 .49773 Metetra
.935 .892 .487 r
.25802 .49773 .26782 .47746 .28175 .44135 .27266 .45496 Metetra
.943 .925 .563 r
.27266 .45496 .28175 .44135 .29455 .41862 .28632 .4226 Metetra
.927 .969 .759 r
.28632 .4226 .29455 .41862 .30619 .41195 .29881 .40475 Metetra
.558 .709 .942 r
.29881 .40475 .30619 .41195 .3168 .42174 .31016 .40336 Metetra
0 .111 .645 r
.31016 .40336 .3168 .42174 .32667 .44617 .32056 .41815 Metetra
0 0 .445 r
.32056 .41815 .32667 .44617 .33619 .48123 .33034 .44655 Metetra
0 0 .376 r
.33034 .44655 .33619 .48123 .34577 .52103 .33989 .4839 Metetra
0 0 .376 r
.33989 .4839 .34577 .52103 .35584 .55845 .34965 .52383 Metetra
0 0 .432 r
.34965 .52383 .35584 .55845 .36671 .58625 .36002 .559 Metetra
0 .026 .564 r
.36002 .559 .36671 .58625 .37853 .59851 .37126 .5824 Metetra
.326 .413 .798 r
.37126 .5824 .37853 .59851 .39126 .59207 .38346 .58885 Metetra
.856 .886 .858 r
.38346 .58885 .39126 .59207 .40467 .56737 .39652 .57626 Metetra
.953 .936 .604 r
.39652 .57626 .40467 .56737 .41844 .52834 .41016 .54628 Metetra
.901 .871 .434 r
.41016 .54628 .41844 .52834 .43223 .4814 .42404 .50379 Metetra
.861 .831 .358 r
.42404 .50379 .43223 .4814 .44578 .43393 .43785 .4557 Metetra
.846 .824 .346 r
.43785 .4557 .44578 .43393 .45891 .39289 .45133 .40943 Metetra
.861 .859 .406 r
.45133 .40943 .45891 .39289 .47163 .36381 .4644 .37157 Metetra
.907 .947 .594 r
.4644 .37157 .47163 .36381 .48401 .35023 .47706 .34707 Metetra
.785 .907 .925 r
.47706 .34707 .48401 .35023 .49622 .35347 .48943 .33878 Metetra
.218 .355 .789 r
.48943 .33878 .49622 .35347 .50846 .37256 .50171 .34728 Metetra
0 .05 .584 r
.50171 .34728 .50846 .37256 .52092 .40431 .51409 .37089 Metetra
0 0 .499 r
.51409 .37089 .52092 .40431 .53375 .44345 .52676 .40571 Metetra
0 0 .479 r
.52676 .40571 .53375 .44345 .54698 .48316 .53982 .44591 Metetra
0 0 .502 r
.53982 .44591 .54698 .48316 .56055 .51594 .55328 .48428 Metetra
0 .054 .572 r
.55328 .48428 .56055 .51594 .57428 .53501 .56703 .51338 Metetra
.209 .279 .716 r
.56703 .51338 .57428 .53501 .58792 .53589 .58086 .52698 Metetra
.682 .74 .895 r
.58086 .52698 .58792 .53589 .60123 .51753 .59451 .52158 Metetra
.937 .958 .655 r
.59451 .52158 .60123 .51753 .61404 .48264 .60775 .49735 Metetra
.826 .828 .353 r
.60775 .49735 .61404 .48264 .62633 .43693 .62045 .45812 Metetra
.738 .738 .218 r
.62045 .45812 .62633 .43693 .63821 .38776 .63263 .4103 Metetra
.7 .706 .177 r
.63263 .4103 .63821 .38776 .64994 .3425 .64448 .36144 Metetra
.708 .728 .21 r
.64448 .36144 .64994 .3425 .66183 .30742 .65627 .31869 Metetra
.781 .831 .365 r
.65627 .31869 .66183 .30742 .67423 .28693 .66834 .28779 Metetra
.878 .993 .779 r
.66834 .28779 .67423 .28693 .68743 .28323 .68104 .27245 Metetra
.456 .58 .89 r
.68104 .27245 .68743 .28323 .70164 .29627 .69463 .27419 Metetra
.126 .211 .683 r
.69463 .27419 .70164 .29627 .71695 .32371 .70931 .2922 Metetra
.017 .082 .588 r
.70931 .2922 .71695 .32371 .73325 .36101 .7251 .32341 Metetra
0 .043 .556 r
.7251 .32341 .73325 .36101 .75024 .4018 .74181 .36265 Metetra
.005 .051 .558 r
.74181 .36265 .75024 .4018 .7674 .43857 .75908 .40305 Metetra
.06 .103 .593 r
.75908 .40305 .7674 .43857 .7841 .46395 .77632 .43699 Metetra
.186 .23 .675 r
.77632 .43699 .7841 .46395 .79972 .47223 .79288 .45741 Metetra
.484 .538 .837 r
.79288 .45741 .79972 .47223 .81381 .46087 .80816 .45947 Metetra
.912 .974 .787 r
.80816 .45947 .81381 .46087 .82621 .43116 .82179 .44182 Metetra
.747 .787 .295 r
.82179 .44182 .82621 .43116 .83713 .3879 .83373 .40697 Metetra
.83373 .40697 .83713 .3879 .84711 .33811 .8443 .36061 Metetra
.838 .8 .815 r
.19135 .63809 .19969 .6436 .21296 .62433 .20414 .62483 Metetra
.946 .831 .699 r
.20414 .62483 .21296 .62433 .22754 .58955 .21844 .59464 Metetra
.974 .833 .643 r
.21844 .59464 .22754 .58955 .24279 .54497 .23365 .55247 Metetra
.983 .836 .62 r
.23365 .55247 .24279 .54497 .25802 .49773 .24907 .50516 Metetra
.984 .843 .621 r
.24907 .50516 .25802 .49773 .27266 .45496 .26408 .46002 Metetra
.978 .856 .65 r
.26408 .46002 .27266 .45496 .28632 .4226 .2782 .42347 Metetra
.948 .877 .732 r
.2782 .42347 .28632 .4226 .29881 .40475 .29117 .40032 Metetra
.76 .844 .915 r
.29117 .40032 .29881 .40475 .31016 .40336 .30294 .39327 Metetra
0 .186 .716 r
.30294 .39327 .31016 .40336 .32056 .41815 .31366 .40276 Metetra
.71 .347 0 r
.31366 .40276 .32056 .41815 .33034 .44655 .32361 .42702 Metetra
.81 .48 0 r
.32361 .42702 .33034 .44655 .33989 .4839 .33319 .46204 Metetra
.819 .503 0 r
.33319 .46204 .33989 .4839 .34965 .52383 .34283 .50196 Metetra
.773 .46 0 r
.34283 .50196 .34965 .52383 .36002 .559 .35296 .53963 Metetra
0 0 .292 r
.35296 .53963 .36002 .559 .37126 .5824 .3639 .56774 Metetra
0 .178 .709 r
.3639 .56774 .37126 .5824 .38346 .58885 .37581 .58031 Metetra
.709 .743 .878 r
.37581 .58031 .38346 .58885 .39652 .57626 .38866 .5741 Metetra
.938 .85 .729 r
.38866 .5741 .39652 .57626 .41016 .54628 .40222 .54949 Metetra
.984 .854 .632 r
.40222 .54949 .41016 .54628 .42404 .50379 .41616 .51038 Metetra
.995 .851 .585 r
.41616 .51038 .42404 .50379 .43785 .4557 .43013 .46319 Metetra
.996 .855 .572 r
.43013 .46319 .43785 .4557 .45133 .40943 .44385 .41536 Metetra
.994 .867 .592 r
.44385 .41536 .45133 .40943 .4644 .37157 .45715 .3739 Metetra
.979 .891 .664 r
.45715 .3739 .4644 .37157 .47706 .34707 .47002 .34438 Metetra
.887 .9 .833 r
.47002 .34438 .47706 .34707 .48943 .33878 .48253 .33038 Metetra
.325 .57 .928 r
.48253 .33038 .48943 .33878 .50171 .34728 .49487 .33327 Metetra
0 0 .528 r
.49487 .33327 .50171 .34728 .51409 .37089 .50723 .35212 Metetra
0 0 .307 r
.50723 .35212 .51409 .37089 .52676 .40571 .51981 .38376 Metetra
0 0 .246 r
.51981 .38376 .52676 .40571 .53982 .44591 .53276 .42295 Metetra
0 0 .272 r
.53276 .42295 .53982 .44591 .55328 .48428 .54612 .46285 Metetra
0 0 .384 r
.54612 .46285 .55328 .48428 .56703 .51338 .55983 .49591 Metetra
0 .068 .627 r
.55983 .49591 .56703 .51338 .58086 .52698 .57371 .51531 Metetra
.481 .589 .885 r
.57371 .51531 .58086 .52698 .59451 .52158 .58752 .51645 Metetra
.902 .856 .788 r
.58752 .51645 .59451 .52158 .60775 .49735 .60099 .49824 Metetra
.988 .876 .628 r
.60099 .49824 .60775 .49735 .62045 .45812 .61396 .46332 Metetra
.996 .862 .538 r
.61396 .46332 .62045 .45812 .63263 .4103 .62639 .41743 Metetra
.992 .855 .501 r
.62639 .41743 .63263 .4103 .64448 .36144 .63842 .36792 Metetra
.989 .863 .507 r
.63842 .36792 .64448 .36144 .65627 .31869 .65027 .32225 Metetra
.988 .891 .571 r
.65027 .32225 .65627 .31869 .66834 .28779 .66229 .28672 Metetra
.954 .931 .736 r
.66229 .28672 .66834 .28779 .68104 .27245 .6748 .26578 Metetra
.643 .786 .951 r
.6748 .26578 .68104 .27245 .69463 .27419 .68813 .26169 Metetra
0 .244 .754 r
.68813 .26169 .69463 .27419 .70931 .2922 .7025 .27443 Metetra
0 0 .526 r
.7025 .27443 .70931 .2922 .7251 .32341 .71798 .30169 Metetra
0 0 .438 r
.71798 .30169 .7251 .32341 .74181 .36265 .73447 .33896 Metetra
0 0 .431 r
.73447 .33896 .74181 .36265 .75908 .40305 .75167 .37986 Metetra
0 0 .486 r
.75167 .37986 .75908 .40305 .77632 .43699 .76906 .41688 Metetra
0 .063 .616 r
.76906 .41688 .77632 .43699 .79288 .45741 .786 .44256 Metetra
.273 .411 .819 r
.786 .44256 .79288 .45741 .80816 .45947 .80185 .45114 Metetra
.799 .813 .862 r
.80185 .45114 .80816 .45947 .82179 .44182 .81614 .43997 Metetra
.983 .901 .648 r
.81614 .43997 .82179 .44182 .83373 .40697 .8287 .4103 Metetra
.979 .863 .481 r
.8287 .4103 .83373 .40697 .8443 .36061 .83976 .3669 Metetra
.835 .773 .792 r
.18306 .63131 .19135 .63809 .20414 .62483 .19602 .61687 Metetra
.889 .736 .686 r
.19602 .61687 .20414 .62483 .21844 .59464 .2105 .58569 Metetra
.9 .721 .65 r
.2105 .58569 .21844 .59464 .23365 .55247 .22589 .54288 Metetra
.903 .715 .638 r
.22589 .54288 .23365 .55247 .24907 .50516 .24146 .49538 Metetra
.9 .715 .642 r
.24146 .49538 .24907 .50516 .26408 .46002 .25657 .45048 Metetra
.892 .72 .662 r
.25657 .45048 .26408 .46002 .2782 .42347 .27074 .41455 Metetra
.864 .732 .716 r
.27074 .41455 .2782 .42347 .29117 .40032 .28371 .39227 Metetra
.716 .737 .868 r
.28371 .39227 .29117 .40032 .30294 .39327 .29545 .38621 Metetra
.516 .005 0 r
.29545 .38621 .30294 .39327 .31366 .40276 .3061 .39668 Metetra
.897 .477 .147 r
.3061 .39668 .31366 .40276 .32361 .42702 .31596 .42175 Metetra
.925 .548 .271 r
.31596 .42175 .32361 .42702 .33319 .46204 .32545 .4573 Metetra
.928 .561 .298 r
.32545 .4573 .33319 .46204 .34283 .50196 .33502 .49735 Metetra
.923 .545 .274 r
.33502 .49735 .34283 .50196 .35296 .53963 .34511 .53468 Metetra
.894 .474 .164 r
.34511 .53468 .35296 .53963 .3639 .56774 .35605 .56203 Metetra
.589 .049 0 r
.35605 .56203 .3639 .56774 .37581 .58031 .36802 .57351 Metetra
.745 .796 .894 r
.36802 .57351 .37581 .58031 .38866 .5741 .38096 .56607 Metetra
.893 .763 .711 r
.38096 .56607 .38866 .5741 .40222 .54949 .39465 .54034 Metetra
.915 .739 .649 r
.39465 .54034 .40222 .54949 .41616 .51038 .40873 .50043 Metetra
.921 .729 .626 r
.40873 .50043 .41616 .51038 .43013 .46319 .42284 .45287 Metetra
.921 .727 .623 r
.42284 .45287 .43013 .46319 .44385 .41536 .43668 .40512 Metetra
.914 .73 .639 r
.43668 .40512 .44385 .41536 .45715 .3739 .45008 .36415 Metetra
.894 .74 .683 r
.45008 .36415 .45715 .3739 .47002 .34438 .46302 .33542 Metetra
.816 .753 .793 r
.46302 .33542 .47002 .34438 .48253 .33038 .47557 .3224 Metetra
.23 .53 .92 r
.47557 .3224 .48253 .33038 .49487 .33327 .48792 .32629 Metetra
.763 .287 0 r
.48792 .32629 .49487 .33327 .50723 .35212 .50026 .34604 Metetra
.895 .475 .104 r
.50026 .34604 .50723 .35212 .51981 .38376 .5128 .37835 Metetra
.916 .516 .175 r
.5128 .37835 .51981 .38376 .53276 .42295 .52571 .41784 Metetra
.914 .511 .17 r
.52571 .41784 .53276 .42295 .54612 .46285 .53902 .45759 Metetra
.885 .455 .088 r
.53902 .45759 .54612 .46285 .55983 .49591 .5527 .49003 Metetra
.713 .21 0 r
.5527 .49003 .55983 .49591 .57371 .51531 .56658 .50841 Metetra
.449 .705 .976 r
.56658 .50841 .57371 .51531 .58752 .51645 .5804 .50834 Metetra
.881 .795 .761 r
.5804 .50834 .58752 .51645 .60099 .49824 .59392 .48891 Metetra
.93 .763 .654 r
.59392 .48891 .60099 .49824 .61396 .46332 .60697 .45303 Metetra
.941 .747 .612 r
.60697 .45303 .61396 .46332 .62639 .41743 .61951 .40657 Metetra
.943 .741 .6 r
.61951 .40657 .62639 .41743 .63842 .36792 .63165 .35697 Metetra
.939 .742 .61 r
.63165 .35697 .63842 .36792 .65027 .32225 .64364 .31165 Metetra
.925 .751 .647 r
.64364 .31165 .65027 .32225 .66229 .28672 .65578 .27682 Metetra
.875 .764 .737 r
.65578 .27682 .66229 .28672 .6748 .26578 .66841 .25681 Metetra
.615 .709 .912 r
.66841 .25681 .6748 .26578 .68813 .26169 .68183 .25375 Metetra
0 .092 .621 r
.68183 .25375 .68813 .26169 .7025 .27443 .69626 .26745 Metetra
.774 .321 0 r
.69626 .26745 .7025 .27443 .71798 .30169 .71178 .29549 Metetra
.855 .424 0 r
.71178 .29549 .71798 .30169 .73447 .33896 .72829 .33321 Metetra
.867 .441 .013 r
.72829 .33321 .73447 .33896 .75167 .37986 .74547 .37415 Metetra
.839 .398 0 r
.74547 .37415 .75167 .37986 .76906 .41688 .76282 .41071 Metetra
.707 .228 0 r
.76282 .41071 .76906 .41688 .786 .44256 .77971 .4355 Metetra
.002 .417 .857 r
.77971 .4355 .786 .44256 .80185 .45114 .7955 .44289 Metetra
.82 .821 .85 r
.7955 .44289 .80185 .45114 .81614 .43997 .80974 .43045 Metetra
.94 .794 .672 r
.80974 .43045 .81614 .43997 .8287 .4103 .8223 .39968 Metetra
.962 .768 .597 r
.8223 .39968 .8287 .4103 .83976 .3669 .83339 .35553 Metetra
.855 .728 .721 r
.17496 .62195 .18306 .63131 .19602 .61687 .18876 .59947 Metetra
.848 .665 .655 r
.18876 .59947 .19602 .61687 .2105 .58569 .20388 .5622 Metetra
.839 .64 .633 r
.20388 .5622 .2105 .58569 .22589 .54288 .21962 .51628 Metetra
.831 .627 .627 r
.21962 .51628 .22589 .54288 .24146 .49538 .23525 .46899 Metetra
.821 .621 .633 r
.23525 .46899 .24146 .49538 .25657 .45048 .25015 .42735 Metetra
.803 .619 .653 r
.25015 .42735 .25657 .45048 .27074 .41455 .26392 .39704 Metetra
.759 .624 .71 r
.26392 .39704 .27074 .41455 .28371 .39227 .27639 .38183 Metetra
.449 .576 .89 r
.27639 .38183 .28371 .39227 .29545 .38621 .28759 .38328 Metetra
.838 .376 .095 r
.28759 .38328 .29545 .38621 .3061 .39668 .29776 .40069 Metetra
.863 .495 .349 r
.29776 .40069 .3061 .39668 .31596 .42175 .30726 .43113 Metetra
.853 .51 .403 r
.30726 .43113 .31596 .42175 .32545 .4573 .31656 .46957 Metetra
.841 .502 .413 r
.31656 .46957 .32545 .4573 .33502 .49735 .32613 .50937 Metetra
.825 .476 .395 r
.32613 .50937 .33502 .49735 .34511 .53468 .33642 .54311 Metetra
.786 .395 .314 r
.33642 .54311 .34511 .53468 .35605 .56203 .34773 .56392 Metetra
.401 0 0 r
.34773 .56392 .35605 .56203 .36802 .57351 .36013 .56704 Metetra
.86 .802 .793 r
.36013 .56704 .36802 .57351 .38096 .56607 .37351 .55103 Metetra
.864 .691 .666 r
.37351 .55103 .38096 .56607 .39465 .54034 .38755 .51816 Metetra
.854 .653 .63 r
.38755 .51816 .39465 .54034 .40873 .50043 .40187 .47381 Metetra
.845 .635 .618 r
.40187 .47381 .40873 .50043 .42284 .45287 .41608 .42515 Metetra
.835 .626 .62 r
.41608 .42515 .42284 .45287 .43668 .40512 .42991 .37958 Metetra
.82 .622 .636 r
.42991 .37958 .43668 .40512 .45008 .36415 .44324 .34348 Metetra
.788 .624 .678 r
.44324 .34348 .45008 .36415 .46302 .33542 .45607 .32147 Metetra
.666 .624 .797 r
.45607 .32147 .46302 .33542 .47557 .3224 .46852 .31601 Metetra
.485 0 0 r
.46852 .31601 .47557 .3224 .48792 .32629 .48079 .3273 Metetra
.861 .434 .204 r
.48079 .3273 .48792 .32629 .50026 .34604 .49309 .35325 Metetra
.863 .484 .326 r
.49309 .35325 .50026 .34604 .5128 .37835 .50562 .38958 Metetra
.853 .487 .358 r
.50562 .38958 .5128 .37835 .52571 .41784 .51854 .43015 Metetra
.838 .468 .353 r
.51854 .43015 .52571 .41784 .53902 .45759 .53189 .46757 Metetra
.807 .411 .301 r
.53189 .46757 .53902 .45759 .5527 .49003 .54557 .49444 Metetra
.666 .165 .045 r
.54557 .49444 .5527 .49003 .56658 .50841 .55941 .50487 Metetra
.776 .919 .933 r
.55941 .50487 .56658 .50841 .5804 .50834 .57315 .49593 Metetra
.881 .732 .692 r
.57315 .49593 .5804 .50834 .59392 .48891 .58658 .46847 Metetra
.872 .672 .629 r
.58658 .46847 .59392 .48891 .60697 .45303 .59956 .42689 Metetra
.862 .646 .608 r
.59956 .42689 .60697 .45303 .61951 .40657 .61209 .37797 Metetra
.851 .632 .605 r
.61209 .37797 .61951 .40657 .63165 .35697 .62431 .32933 Metetra
.837 .626 .617 r
.62431 .32933 .63165 .35697 .64364 .31165 .63649 .28799 Metetra
.811 .626 .651 r
.63649 .28799 .64364 .31165 .65578 .27682 .64891 .25936 Metetra
.742 .629 .735 r
.64891 .25936 .65578 .27682 .66841 .25681 .66191 .2468 Metetra
.291 .51 .895 r
.66191 .2468 .66841 .25681 .68183 .25375 .67575 .25141 Metetra
.776 .273 0 r
.67575 .25141 .68183 .25375 .69626 .26745 .69059 .272 Metetra
.86 .432 .199 r
.69059 .272 .69626 .26745 .71178 .29549 .70645 .30511 Metetra
.859 .457 .274 r
.70645 .30511 .71178 .29549 .72829 .33321 .72316 .3452 Metetra
.847 .448 .289 r
.72316 .3452 .72829 .33321 .74547 .37415 .74033 .38516 Metetra
.821 .406 .257 r
.74033 .38516 .74547 .37415 .76282 .41071 .75744 .4173 Metetra
.738 .261 .112 r
.75744 .4173 .76282 .41071 .77971 .4355 .77384 .4348 Metetra
.175 .709 .825 r
.77384 .4348 .77971 .4355 .7955 .44289 .78898 .43331 Metetra
.894 .8 .749 r
.78898 .43331 .7955 .44289 .80974 .43045 .80254 .41215 Metetra
.893 .7 .633 r
.80254 .41215 .80974 .43045 .8223 .39968 .81454 .3745 Metetra
.882 .66 .597 r
.81454 .3745 .8223 .39968 .83339 .35553 .82531 .32651 Metetra
.829 .648 .657 r
.16787 .60225 .17496 .62195 .18876 .59947 .18289 .56793 Metetra
.808 .605 .628 r
.18289 .56793 .18876 .59947 .20388 .5622 .19877 .52334 Metetra
.793 .583 .618 r
.19877 .52334 .20388 .5622 .21962 .51628 .21471 .47564 Metetra
.779 .57 .618 r
.21471 .47564 .21962 .51628 .23525 .46899 .23002 .43202 Metetra
.761 .562 .628 r
.23002 .43202 .23525 .46899 .25015 .42735 .24423 .39858 Metetra
.728 .556 .659 r
.24423 .39858 .25015 .42735 .26392 .39704 .25708 .37955 Metetra
.6 .542 .761 r
.25708 .37955 .26392 .39704 .27639 .38183 .26855 .37703 Metetra
.77 .263 0 r
.26855 .37703 .27639 .38183 .28759 .38328 .27883 .39086 Metetra
.831 .468 .367 r
.27883 .39086 .28759 .38328 .29776 .40069 .28827 .41862 Metetra
.807 .479 .433 r
.28827 .41862 .29776 .40069 .30726 .43113 .29734 .45576 Metetra
.789 .47 .45 r
.29734 .45576 .30726 .43113 .31656 .46957 .30657 .49593 Metetra
.769 .449 .445 r
.30657 .49593 .31656 .46957 .32613 .50937 .31643 .53178 Metetra
.735 .399 .411 r
.31643 .53178 .32613 .50937 .33642 .54311 .32732 .55619 Metetra
.617 .215 .259 r
.32732 .55619 .33642 .54311 .34773 .56392 .3394 .56374 Metetra
.838 .969 .885 r
.3394 .56374 .34773 .56392 .36013 .56704 .3526 .55214 Metetra
.853 .689 .678 r
.3526 .55214 .36013 .56704 .37351 .55103 .36665 .5228 Metetra
.823 .62 .628 r
.36665 .5228 .37351 .55103 .38755 .51816 .38113 .48049 Metetra
.805 .591 .612 r
.38113 .48049 .38755 .51816 .40187 .47381 .39562 .43209 Metetra
.79 .574 .608 r
.39562 .43209 .40187 .47381 .41608 .42515 .40978 .38509 Metetra
.773 .563 .616 r
.40978 .38509 .41608 .42515 .42991 .37958 .42341 .34621 Metetra
.746 .557 .639 r
.42341 .34621 .42991 .37958 .44324 .34348 .43646 .32053 Metetra
.678 .552 .704 r
.43646 .32053 .44324 .34348 .45607 .32147 .44901 .31104 Metetra
.076 .364 .832 r
.44901 .31104 .45607 .32147 .46852 .31601 .46122 .31847 Metetra
.837 .406 .209 r
.46122 .31847 .46852 .31601 .48079 .3273 .47334 .34128 Metetra
.82 .458 .371 r
.47334 .34128 .48079 .3273 .49309 .35325 .4856 .37568 Metetra
.8 .458 .41 r
.4856 .37568 .49309 .35325 .50562 .38958 .49817 .41591 Metetra
.779 .442 .416 r
.49817 .41591 .50562 .38958 .51854 .43015 .51118 .45479 Metetra
.751 .405 .397 r
.51118 .45479 .51854 .43015 .53189 .46757 .5246 .48478 Metetra
.681 .299 .317 r
.5246 .48478 .53189 .46757 .54557 .49444 .53832 .49949 Metetra
.004 0 0 r
.53832 .49949 .54557 .49444 .55941 .50487 .5521 .49516 Metetra
.887 .767 .725 r
.5521 .49516 .55941 .50487 .57315 .49593 .56571 .47174 Metetra
.844 .644 .633 r
.56571 .47174 .57315 .49593 .58658 .46847 .57898 .43287 Metetra
.82 .601 .606 r
.57898 .43287 .58658 .46847 .59956 .42689 .59183 .38492 Metetra
.803 .579 .598 r
.59183 .38492 .59956 .42689 .61209 .37797 .60434 .33548 Metetra
.785 .565 .603 r
.60434 .33548 .61209 .37797 .62431 .32933 .61671 .29179 Metetra
.762 .557 .621 r
.61671 .29179 .62431 .32933 .63649 .28799 .62918 .25972 Metetra
.716 .553 .667 r
.62918 .25972 .63649 .28799 .64891 .25936 .64208 .24316 Metetra
.525 .529 .802 r
.64208 .24316 .64891 .25936 .66191 .2468 .65567 .24373 Metetra
.712 .187 0 r
.65567 .24373 .66191 .2468 .67575 .25141 .67014 .26078 Metetra
.828 .415 .261 r
.67014 .26078 .67575 .25141 .69059 .272 .68557 .29137 Metetra
.81 .436 .349 r
.68557 .29137 .69059 .272 .70645 .30511 .70187 .33043 Metetra
.789 .429 .374 r
.70187 .33043 .70645 .30511 .72316 .3452 .71874 .37114 Metetra
.763 .401 .369 r
.71874 .37114 .72316 .3452 .74033 .38516 .7357 .40582 Metetra
.712 .329 .322 r
.7357 .40582 .74033 .38516 .75744 .4173 .75218 .42728 Metetra
.491 .024 .071 r
.75218 .42728 .75744 .4173 .77384 .4348 .76761 .43046 Metetra
.902 .92 .821 r
.76761 .43046 .77384 .4348 .78898 .43331 .78162 .41375 Metetra
.872 .685 .646 r
.78162 .41375 .78898 .43331 .80254 .41215 .79411 .37946 Metetra
.84 .616 .6 r
.79411 .37946 .80254 .41215 .81454 .3745 .80534 .33317 Metetra
.818 .585 .587 r
.80534 .33317 .81454 .3745 .82531 .32651 .81582 .28233 Metetra
.794 .589 .624 r
.16249 .56642 .16787 .60225 .18289 .56793 .17857 .5221 Metetra
.775 .563 .613 r
.17857 .5221 .18289 .56793 .19877 .52334 .19476 .47432 Metetra
.758 .547 .611 r
.19476 .47432 .19877 .52334 .21471 .47564 .21034 .43032 Metetra
.739 .536 .618 r
.21034 .43032 .21471 .47564 .23002 .43202 .22478 .39624 Metetra
.707 .526 .641 r
.22478 .39624 .23002 .43202 .24423 .39858 .23777 .37644 Metetra
.604 .508 .718 r
.23777 .37644 .24423 .39858 .25708 .37955 .24927 .37312 Metetra
.715 .204 0 r
.24927 .37312 .25708 .37955 .26855 .37703 .25948 .38622 Metetra
.819 .46 .377 r
.25948 .38622 .26855 .37703 .27883 .39086 .26874 .41343 Metetra
.787 .466 .445 r
.26874 .41343 .27883 .39086 .28827 .41862 .27755 .45027 Metetra
.765 .455 .462 r
.27755 .45027 .28827 .41862 .29734 .45576 .28647 .49049 Metetra
.743 .434 .459 r
.28647 .49049 .29734 .45576 .30657 .49593 .29603 .52674 Metetra
.709 .389 .435 r
.29603 .52674 .30657 .49593 .31643 .53178 .30667 .55183 Metetra
.613 .253 .335 r
.30667 .55183 .31643 .53178 .32732 .55619 .31859 .56025 Metetra
.673 .968 .774 r
.31859 .56025 .32732 .55619 .3394 .56374 .33177 .54952 Metetra
.855 .695 .683 r
.33177 .54952 .3394 .56374 .3526 .55214 .34591 .52089 Metetra
.81 .606 .626 r
.34591 .52089 .3526 .55214 .36665 .5228 .36059 .47898 Metetra
.787 .57 .608 r
.36059 .47898 .36665 .5228 .38113 .48049 .37534 .43064 Metetra
.769 .55 .603 r
.37534 .43064 .38113 .48049 .39562 .43209 .38977 .38336 Metetra
.75 .537 .607 r
.38977 .38336 .39562 .43209 .40978 .38509 .40362 .34392 Metetra
.723 .527 .625 r
.40362 .34392 .40978 .38509 .42341 .34621 .41681 .3175 Metetra
.664 .517 .674 r
.41681 .3175 .42341 .34621 .43646 .32053 .4294 .3072 Metetra
.24 .402 .824 r
.4294 .3072 .43646 .32053 .44901 .31104 .44154 .31384 Metetra
.831 .401 .214 r
.44154 .31384 .44901 .31104 .46122 .31847 .45347 .336 Metetra
.8 .447 .389 r
.45347 .336 .46122 .31847 .47334 .34128 .46546 .36999 Metetra
.775 .445 .428 r
.46546 .36999 .47334 .34128 .4856 .37568 .47773 .41012 Metetra
.752 .428 .436 r
.47773 .41012 .4856 .37568 .49817 .41591 .49042 .44926 Metetra
.723 .394 .423 r
.49042 .44926 .49817 .41591 .51118 .45479 .5036 .47984 Metetra
.661 .31 .368 r
.5036 .47984 .51118 .45479 .5246 .48478 .51716 .49537 Metetra
.282 0 0 r
.51716 .49537 .5246 .48478 .53832 .49949 .53092 .49195 Metetra
.902 .801 .739 r
.53092 .49195 .53832 .49949 .5521 .49516 .54464 .46933 Metetra
.834 .634 .632 r
.54464 .46933 .5521 .49516 .56571 .47174 .55811 .431 Metetra
.802 .581 .603 r
.55811 .431 .56571 .47174 .57898 .43287 .57123 .38325 Metetra
.78 .555 .594 r
.57123 .38325 .57898 .43287 .59183 .38492 .58402 .33365 Metetra
.761 .539 .596 r
.58402 .33365 .59183 .38492 .60434 .33548 .59661 .28949 Metetra
.737 .528 .61 r
.59661 .28949 .60434 .33548 .61671 .29179 .60923 .25674 Metetra
.695 .519 .646 r
.60923 .25674 .61671 .29179 .62918 .25972 .62216 .23936 Metetra
.548 .499 .753 r
.62216 .23936 .62918 .25972 .64208 .24316 .63566 .23911 Metetra
.677 .151 0 r
.63566 .23911 .64208 .24316 .65567 .24373 .64994 .25543 Metetra
.813 .41 .288 r
.64994 .25543 .65567 .24373 .67014 .26078 .6651 .2855 Metetra
.786 .426 .376 r
.6651 .2855 .67014 .26078 .68557 .29137 .68107 .32431 Metetra
.761 .417 .401 r
.68107 .32431 .68557 .29137 .70187 .33043 .69762 .36514 Metetra
.734 .391 .4 r
.69762 .36514 .70187 .33043 .71874 .37114 .71432 .40029 Metetra
.687 .333 .369 r
.71432 .40029 .71874 .37114 .7357 .40582 .73064 .42251 Metetra
.533 .13 .223 r
.73064 .42251 .7357 .40582 .75218 .42728 .74606 .4266 Metetra
.874 .992 .811 r
.74606 .4266 .75218 .42728 .76761 .43046 .76019 .41077 Metetra
.868 .683 .649 r
.76019 .41077 .76761 .43046 .78162 .41375 .77292 .37714 Metetra
.821 .597 .599 r
.77292 .37714 .78162 .41375 .79411 .37946 .78443 .33119 Metetra
.794 .561 .584 r
.78443 .33119 .79411 .37946 .80534 .33317 .7952 .28033 Metetra
.773 .541 .583 r
.7952 .28033 .80534 .33317 .81582 .28233 .80586 .23224 Metetra
.772 .56 .612 r
.15842 .51945 .16249 .56642 .17857 .5221 .17487 .47161 Metetra
.756 .544 .61 r
.17487 .47161 .17857 .5221 .19476 .47432 .19069 .42745 Metetra
.736 .532 .616 r
.19069 .42745 .19476 .47432 .21034 .43032 .2053 .39315 Metetra
.704 .522 .638 r
.2053 .39315 .21034 .43032 .22478 .39624 .21839 .3731 Metetra
.605 .502 .711 r
.21839 .3731 .22478 .39624 .23777 .37644 .2299 .36952 Metetra
.697 .188 0 r
.2299 .36952 .23777 .37644 .24927 .37312 .24 .38239 Metetra
.817 .459 .379 r
.24 .38239 .24927 .37312 .25948 .38622 .24906 .40943 Metetra
.784 .464 .447 r
.24906 .40943 .25948 .38622 .26874 .41343 .25759 .44619 Metetra
.761 .453 .463 r
.25759 .44619 .26874 .41343 .27755 .45027 .2662 .48643 Metetra
.739 .431 .461 r
.2662 .48643 .27755 .45027 .28647 .49049 .27548 .52282 Metetra
.705 .388 .438 r
.27548 .52282 .28647 .49049 .29603 .52674 .28589 .54813 Metetra
.613 .257 .343 r
.28589 .54813 .29603 .52674 .30667 .55183 .2977 .55682 Metetra
.606 .933 .721 r
.2977 .55682 .30667 .55183 .31859 .56025 .31087 .54635 Metetra
.856 .698 .685 r
.31087 .54635 .31859 .56025 .33177 .54952 .32513 .5179 Metetra
.809 .604 .626 r
.32513 .5179 .33177 .54952 .34591 .52089 .34002 .47609 Metetra
.784 .568 .607 r
.34002 .47609 .34591 .52089 .36059 .47898 .35503 .42773 Metetra
.765 .547 .602 r
.35503 .42773 .36059 .47898 .37534 .43064 .36971 .38032 Metetra
.746 .533 .606 r
.36971 .38032 .37534 .43064 .38977 .38336 .38378 .34069 Metetra
.72 .523 .622 r
.38378 .34069 .38977 .38336 .40362 .34392 .3971 .31402 Metetra
.662 .512 .669 r
.3971 .31402 .40362 .34392 .41681 .3175 .40971 .30344 Metetra
.266 .406 .817 r
.40971 .30344 .41681 .3175 .4294 .3072 .42177 .30984 Metetra
.831 .4 .213 r
.42177 .30984 .4294 .3072 .44154 .31384 .43352 .33179 Metetra
.798 .446 .391 r
.43352 .33179 .44154 .31384 .45347 .336 .44524 .36566 Metetra
.772 .443 .43 r
.44524 .36566 .45347 .336 .46546 .36999 .45719 .40578 Metetra
.748 .426 .438 r
.45719 .40578 .46546 .36999 .47773 .41012 .46959 .445 Metetra
.719 .393 .426 r
.46959 .445 .47773 .41012 .49042 .44926 .48251 .47578 Metetra
.658 .312 .374 r
.48251 .47578 .49042 .44926 .5036 .47984 .49591 .49156 Metetra
.312 0 .034 r
.49591 .49156 .5036 .47984 .51716 .49537 .50964 .48841 Metetra
.905 .81 .743 r
.50964 .48841 .51716 .49537 .53092 .49195 .52345 .46601 Metetra
.833 .633 .633 r
.52345 .46601 .53092 .49195 .54464 .46933 .53713 .42782 Metetra
.799 .578 .603 r
.53713 .42782 .54464 .46933 .55811 .431 .55051 .3801 Metetra
.777 .551 .593 r
.55051 .3801 .55811 .431 .57123 .38325 .56356 .33041 Metetra
.757 .535 .595 r
.56356 .33041 .57123 .38325 .58402 .33365 .57638 .28608 Metetra
.733 .523 .608 r
.57638 .28608 .58402 .33365 .59661 .28949 .58917 .25308 Metetra
.692 .514 .642 r
.58917 .25308 .59661 .28949 .60923 .25674 .60215 .23544 Metetra
.552 .494 .744 r
.60215 .23544 .60923 .25674 .62216 .23936 .6156 .23492 Metetra
.667 .142 0 r
.6156 .23492 .62216 .23936 .63566 .23911 .62971 .25101 Metetra
.811 .41 .291 r
.62971 .25101 .63566 .23911 .64994 .25543 .64461 .28091 Metetra
.782 .425 .379 r
.64461 .28091 .64994 .25543 .6651 .2855 .66027 .31966 Metetra
.757 .415 .404 r
.66027 .31966 .6651 .2855 .68107 .32431 .6765 .36053 Metetra
.73 .39 .404 r
.6765 .36053 .68107 .32431 .69762 .36514 .69292 .39584 Metetra
.684 .333 .375 r
.69292 .39584 .69762 .36514 .71432 .40029 .70906 .4183 Metetra
.537 .142 .24 r
.70906 .4183 .71432 .40029 .73064 .42251 .72442 .42266 Metetra
.853 .998 .799 r
.72442 .42266 .73064 .42251 .74606 .4266 .73861 .40708 Metetra
.868 .684 .651 r
.73861 .40708 .74606 .4266 .76019 .41077 .75152 .37363 Metetra
.819 .595 .599 r
.75152 .37363 .76019 .41077 .77292 .37714 .7633 .32775 Metetra
.791 .558 .584 r
.7633 .32775 .77292 .37714 .78443 .33119 .77435 .27684 Metetra
.769 .537 .583 r
.77435 .27684 .78443 .33119 .7952 .28033 .78526 .2286 Metetra
.746 .523 .593 r
.78526 .2286 .7952 .28033 .80586 .23224 .79668 .18973 Metetra
.771 .561 .614 r
.15425 .47452 .15842 .51945 .17487 .47161 .17043 .42936 Metetra
.754 .55 .62 r
.17043 .42936 .17487 .47161 .19069 .42745 .18542 .39327 Metetra
.726 .542 .642 r
.18542 .39327 .19069 .42745 .2053 .39315 .19883 .37094 Metetra
.642 .531 .712 r
.19883 .37094 .2053 .39315 .21839 .3731 .21055 .36491 Metetra
0 0 .492 r
.21055 .36491 .21839 .3731 .2299 .36952 .22073 .3755 Metetra
.831 .459 .35 r
.22073 .3755 .2299 .36952 .24 .38239 .22973 .40073 Metetra
.801 .473 .434 r
.22973 .40073 .24 .38239 .24906 .40943 .23806 .43646 Metetra
.78 .465 .455 r
.23806 .43646 .24906 .40943 .25759 .44619 .24635 .47667 Metetra
.76 .446 .454 r
.24635 .47667 .25759 .44619 .2662 .48643 .25524 .5141 Metetra
.73 .405 .431 r
.25524 .5141 .2662 .48643 .27548 .52282 .26527 .54143 Metetra
.65 .285 .339 r
.26527 .54143 .27548 .52282 .28589 .54813 .27676 .55275 Metetra
.429 .846 .681 r
.27676 .55275 .28589 .54813 .2977 .55682 .28976 .54503 Metetra
.862 .718 .701 r
.28976 .54503 .2977 .55682 .31087 .54635 .304 .51892 Metetra
.821 .622 .633 r
.304 .51892 .31087 .54635 .32513 .5179 .31903 .47858 Metetra
.799 .585 .612 r
.31903 .47858 .32513 .5179 .34002 .47609 .33429 .43064 Metetra
.782 .565 .606 r
.33429 .43064 .34002 .47609 .35503 .42773 .34928 .38258 Metetra
.765 .552 .61 r
.34928 .38258 .35503 .42773 .36971 .38032 .36365 .3414 Metetra
.741 .543 .626 r
.36365 .3414 .36971 .38032 .38378 .34069 .3772 .31258 Metetra
.689 .536 .673 r
.3772 .31258 .38378 .34069 .3971 .31402 .38995 .29955 Metetra
.384 .47 .825 r
.38995 .29955 .3971 .31402 .40971 .30344 .40201 .30352 Metetra
.83 .374 .139 r
.40201 .30352 .40971 .30344 .42177 .30984 .41363 .32341 Metetra
.814 .451 .369 r
.41363 .32341 .42177 .30984 .43352 .33179 .42511 .35588 Metetra
.791 .453 .416 r
.42511 .35588 .43352 .33179 .44524 .36566 .43675 .39553 Metetra
.77 .439 .427 r
.43675 .39553 .44524 .36566 .45719 .40578 .44879 .43538 Metetra
.743 .408 .416 r
.44879 .43538 .45719 .40578 .46959 .445 .46141 .46784 Metetra
.689 .331 .363 r
.46141 .46784 .46959 .445 .48251 .47578 .4746 .48611 Metetra
.392 0 .036 r
.4746 .48611 .48251 .47578 .49591 .49156 .48826 .48578 Metetra
.902 .837 .772 r
.48826 .48578 .49591 .49156 .50964 .48841 .50215 .46599 Metetra
.845 .652 .643 r
.50215 .46599 .50964 .48841 .52345 .46601 .51603 .42968 Metetra
.814 .597 .608 r
.51603 .42968 .52345 .46601 .53713 .42782 .52969 .38281 Metetra
.794 .57 .597 r
.52969 .38281 .53713 .42782 .55051 .3801 .54305 .33286 Metetra
.776 .554 .598 r
.54305 .33286 .55051 .3801 .56356 .33041 .55612 .28729 Metetra
.754 .543 .611 r
.55612 .28729 .56356 .33041 .57638 .28608 .56906 .25231 Metetra
.717 .537 .645 r
.56906 .25231 .57638 .28608 .58917 .25308 .58208 .23226 Metetra
.595 .524 .744 r
.58208 .23226 .58917 .25308 .60215 .23544 .59542 .22923 Metetra
.526 .014 0 r
.59542 .22923 .60215 .23544 .6156 .23492 .60931 .24304 Metetra
.823 .404 .247 r
.60931 .24304 .6156 .23492 .62971 .25101 .62389 .27121 Metetra
.801 .432 .357 r
.62389 .27121 .62971 .25101 .64461 .28091 .63918 .30908 Metetra
.779 .426 .387 r
.63918 .30908 .64461 .28091 .66027 .31966 .65506 .35013 Metetra
.754 .402 .388 r
.65506 .35013 .66027 .31966 .6765 .36053 .67123 .38674 Metetra
.711 .348 .357 r
.67123 .38674 .6765 .36053 .69292 .39584 .68726 .41145 Metetra
.579 .163 .218 r
.68726 .41145 .69292 .39584 .70906 .4183 .70267 .41861 Metetra
.779 .998 .832 r
.70267 .41861 .70906 .4183 .72442 .42266 .71708 .40584 Metetra
.878 .707 .665 r
.71708 .40584 .72442 .42266 .73861 .40708 .73032 .37464 Metetra
.835 .615 .606 r
.73032 .37464 .73861 .40708 .75152 .37363 .74246 .33005 Metetra
.809 .578 .587 r
.74246 .33005 .75152 .37363 .7633 .32775 .75384 .27931 Metetra
.789 .557 .585 r
.75384 .27931 .7633 .32775 .77435 .27684 .76498 .23018 Metetra
.767 .544 .595 r
.76498 .23018 .77435 .27684 .78526 .2286 .77649 .18955 Metetra
.736 .536 .622 r
.77649 .18955 .78526 .2286 .79668 .18973 .78892 .1626 Metetra
.797 .595 .629 r
.14876 .44225 .15425 .47452 .17043 .42936 .16448 .40165 Metetra
.777 .591 .648 r
.16448 .40165 .17043 .42936 .18542 .39327 .1787 .37313 Metetra
.726 .592 .705 r
.1787 .37313 .18542 .39327 .19883 .37094 .19116 .36015 Metetra
.286 .489 .881 r
.19116 .36015 .19883 .37094 .21055 .36491 .20191 .36395 Metetra
.85 .423 .213 r
.20191 .36395 .21055 .36491 .22073 .3755 .21122 .3835 Metetra
.842 .491 .389 r
.21122 .3835 .22073 .3755 .22973 .40073 .21958 .41554 Metetra
.826 .496 .429 r
.21958 .41554 .22973 .40073 .23806 .43646 .22759 .45475 Metetra
.812 .484 .435 r
.22759 .45475 .23806 .43646 .24635 .47667 .23595 .49429 Metetra
.792 .454 .416 r
.23595 .49429 .24635 .47667 .25524 .5141 .24527 .52666 Metetra
.744 .367 .338 r
.24527 .52666 .25524 .5141 .26527 .54143 .25602 .54519 Metetra
.263 0 0 r
.25602 .54519 .26527 .54143 .27676 .55275 .26839 .54548 Metetra
.868 .782 .764 r
.26839 .54548 .27676 .55275 .28976 .54503 .28224 .52661 Metetra
.849 .667 .656 r
.28224 .52661 .28976 .54503 .304 .51892 .29716 .49141 Metetra
.834 .629 .625 r
.29716 .49141 .304 .51892 .31903 .47858 .31259 .44564 Metetra
.822 .609 .615 r
.31259 .44564 .31903 .47858 .33429 .43064 .32797 .39664 Metetra
.809 .598 .617 r
.32797 .39664 .33429 .43064 .34928 .38258 .34283 .35176 Metetra
.792 .593 .632 r
.34283 .35176 .34928 .38258 .36365 .3414 .35688 .31722 Metetra
.756 .592 .673 r
.35688 .31722 .36365 .3414 .3772 .31258 .37003 .29732 Metetra
.611 .583 .798 r
.37003 .29732 .3772 .31258 .38995 .29955 .38234 .29423 Metetra
.686 .16 0 r
.38234 .29423 .38995 .29955 .40201 .30352 .39403 .30779 Metetra
.85 .45 .281 r
.39403 .30779 .40201 .30352 .41363 .32341 .40538 .33561 Metetra
.838 .477 .37 r
.40538 .33561 .41363 .32341 .42511 .35588 .41671 .37308 Metetra
.823 .473 .393 r
.41671 .37308 .42511 .35588 .43675 .39553 .42835 .4138 Metetra
.804 .45 .386 r
.42835 .4138 .43675 .39553 .44879 .43538 .44052 .45026 Metetra
.768 .389 .337 r
.44052 .45026 .44879 .43538 .46141 .46784 .45335 .47513 Metetra
.607 .127 .089 r
.45335 .47513 .46141 .46784 .4746 .48611 .46678 .48282 Metetra
.839 .92 .888 r
.46678 .48282 .4746 .48611 .48826 .48578 .48065 .4709 Metetra
.87 .707 .677 r
.48065 .4709 .48826 .48578 .50215 .46599 .49469 .44079 Metetra
.851 .645 .623 r
.49469 .44079 .50215 .46599 .51603 .42968 .50865 .39736 Metetra
.837 .618 .606 r
.50865 .39736 .51603 .42968 .52969 .38281 .52235 .34766 Metetra
.824 .603 .604 r
.52235 .34766 .52969 .38281 .54305 .33286 .53574 .29934 Metetra
.807 .595 .615 r
.53574 .29934 .54305 .33286 .55612 .28729 .54889 .25926 Metetra
.779 .592 .647 r
.54889 .25926 .55612 .28729 .56906 .25231 .56196 .23259 Metetra
.701 .592 .731 r
.56196 .23259 .56906 .25231 .58208 .23226 .57517 .22236 Metetra
.106 .406 .858 r
.57517 .22236 .58208 .23226 .59542 .22923 .58876 .22935 Metetra
.821 .345 .058 r
.58876 .22935 .59542 .22923 .60931 .24304 .60291 .25202 Metetra
.845 .44 .274 r
.60291 .25202 .60931 .24304 .62389 .27121 .61774 .28659 Metetra
.833 .451 .329 r
.61774 .28659 .62389 .27121 .63918 .30908 .63319 .32723 Metetra
.815 .436 .338 r
.63319 .32723 .63918 .30908 .65506 .35013 .64909 .36665 Metetra
.785 .391 .309 r
.64909 .36665 .65506 .35013 .67123 .38674 .66507 .39713 Metetra
.696 .245 .178 r
.66507 .39713 .67123 .38674 .68726 .41145 .6807 .41207 Metetra
.313 .803 .799 r
.6807 .41207 .68726 .41145 .70267 .41861 .69558 .40757 Metetra
.894 .775 .723 r
.69558 .40757 .70267 .41861 .71708 .40584 .7094 .38351 Metetra
.873 .67 .626 r
.7094 .38351 .71708 .40584 .73032 .37464 .72214 .3436 Metetra
.855 .63 .596 r
.72214 .3436 .73032 .37464 .74246 .33005 .734 .29438 Metetra
.84 .609 .589 r
.734 .29438 .74246 .33005 .75384 .27931 .74539 .24358 Metetra
.823 .598 .597 r
.74539 .24358 .75384 .27931 .76498 .23018 .75686 .19861 Metetra
.799 .593 .623 r
.75686 .19861 .76498 .23018 .77649 .18955 .76899 .16544 Metetra
.747 .594 .686 r
.76899 .16544 .77649 .18955 .78892 .1626 .78227 .14799 Metetra
.857 .672 .651 r
.14145 .42598 .14876 .44225 .16448 .40165 .15702 .38754 Metetra
.835 .679 .688 r
.15702 .38754 .16448 .40165 .1787 .37313 .17095 .36214 Metetra
.75 .692 .796 r
.17095 .36214 .1787 .37313 .19116 .36015 .18307 .35277 Metetra
0 .196 .679 r
.18307 .35277 .19116 .36015 .20191 .36395 .19345 .36017 Metetra
.883 .464 .202 r
.19345 .36017 .20191 .36395 .21122 .3835 .20242 .38283 Metetra
.898 .533 .339 r
.20242 .38283 .21122 .3835 .21958 .41554 .21053 .41699 Metetra
.895 .545 .372 r
.21053 .41699 .21958 .41554 .22759 .45475 .21842 .45695 Metetra
.889 .534 .366 r
.21842 .45695 .22759 .45475 .23595 .49429 .2268 .4956 Metetra
.874 .49 .311 r
.2268 .4956 .23595 .49429 .24527 .52666 .2363 .52548 Metetra
.784 .296 .058 r
.2363 .52548 .24527 .52666 .25602 .54519 .24736 .54028 Metetra
.624 .833 .981 r
.24736 .54028 .25602 .54519 .26839 .54548 .26009 .53629 Metetra
.87 .75 .728 r
.26009 .53629 .26839 .54548 .28224 .52661 .27431 .51341 Metetra
.885 .707 .656 r
.27431 .51341 .28224 .52661 .29716 .49141 .28954 .47522 Metetra
.886 .689 .631 r
.28954 .47522 .29716 .49141 .31259 .44564 .30518 .42798 Metetra
.882 .681 .625 r
.30518 .42798 .31259 .44564 .32797 .39664 .32066 .37917 Metetra
.875 .679 .634 r
.32066 .37917 .32797 .39664 .34283 .35176 .33552 .33599 Metetra
.858 .683 .664 r
.33552 .33599 .34283 .35176 .35688 .31722 .34949 .30429 Metetra
.808 .694 .74 r
.34949 .30429 .35688 .31722 .37003 .29732 .36251 .28792 Metetra
.457 .625 .924 r
.36251 .28792 .37003 .29732 .38234 .29423 .37467 .28854 Metetra
.771 .273 0 r
.37467 .28854 .38234 .29423 .39403 .30779 .38621 .30552 Metetra
.893 .48 .206 r
.38621 .30552 .39403 .30779 .40538 .33561 .39743 .33593 Metetra
.902 .517 .284 r
.39743 .33593 .40538 .33561 .41671 .37308 .40868 .37475 Metetra
.898 .515 .296 r
.40868 .37475 .41671 .37308 .42835 .4138 .42029 .41524 Metetra
.884 .483 .258 r
.42029 .41524 .42835 .4138 .44052 .45026 .4325 .44978 Metetra
.826 .36 .099 r
.4325 .44978 .44052 .45026 .45335 .47513 .44541 .47129 Metetra
0 .498 .825 r
.44541 .47129 .45335 .47513 .46678 .48282 .45896 .47474 Metetra
.855 .799 .796 r
.45896 .47474 .46678 .48282 .48065 .4709 .47295 .45852 Metetra
.899 .733 .667 r
.47295 .45852 .48065 .4709 .49469 .44079 .48712 .42488 Metetra
.904 .705 .624 r
.48712 .42488 .49469 .44079 .50865 .39736 .5012 .37931 Metetra
.902 .692 .61 r
.5012 .37931 .50865 .39736 .52235 .34766 .51502 .32916 Metetra
.895 .688 .614 r
.51502 .32916 .52235 .34766 .53574 .29934 .52851 .28201 Metetra
.882 .69 .638 r
.52851 .28201 .53574 .29934 .54889 .25926 .54176 .24441 Metetra
.847 .699 .698 r
.54176 .24441 .54889 .25926 .56196 .23259 .55492 .2211 Metetra
.694 .693 .845 r
.55492 .2211 .56196 .23259 .57517 .22236 .56823 .21462 Metetra
0 .181 .686 r
.56823 .21462 .57517 .22236 .58876 .22935 .58191 .22524 Metetra
.827 .357 0 r
.58191 .22524 .58876 .22935 .60291 .25202 .59614 .25092 Metetra
.887 .459 .143 r
.59614 .25092 .60291 .25202 .61774 .28659 .61101 .2874 Metetra
.893 .477 .187 r
.61101 .2874 .61774 .28659 .63319 .32723 .62648 .32847 Metetra
.882 .455 .168 r
.62648 .32847 .63319 .32723 .64909 .36665 .64233 .36661 Metetra
.835 .365 .057 r
.64233 .36661 .64909 .36665 .66507 .39713 .65821 .3942 Metetra
.501 0 0 r
.65821 .3942 .66507 .39713 .6807 .41207 .6737 .40508 Metetra
.761 .847 .916 r
.6737 .40508 .6807 .41207 .69558 .40757 .68841 .39611 Metetra
.909 .77 .695 r
.68841 .39611 .69558 .40757 .7094 .38351 .7021 .36805 Metetra
.923 .727 .619 r
.7021 .36805 .7094 .38351 .72214 .3436 .71476 .32537 Metetra
.923 .707 .592 r
.71476 .32537 .72214 .3436 .734 .29438 .72664 .27501 Metetra
.918 .699 .59 r
.72664 .27501 .734 .29438 .74539 .24358 .73817 .22479 Metetra
.907 .699 .609 r
.73817 .22479 .74539 .24358 .75686 .19861 .74988 .18187 Metetra
.881 .706 .66 r
.74988 .18187 .75686 .19861 .76899 .16544 .76233 .15181 Metetra
.791 .711 .775 r
.76233 .15181 .76899 .16544 .78227 .14799 .77598 .13806 Metetra
.944 .79 .659 r
.13216 .4258 .14145 .42598 .15702 .38754 .14811 .38535 Metetra
.927 .805 .706 r
.14811 .38535 .15702 .38754 .17095 .36214 .16247 .35719 Metetra
.841 .819 .828 r
.16247 .35719 .17095 .36214 .18307 .35277 .17498 .34471 Metetra
.091 .458 .886 r
.17498 .34471 .18307 .35277 .19345 .36017 .18568 .34906 Metetra
.817 .385 0 r
.18568 .34906 .19345 .36017 .20242 .38283 .19486 .36915 Metetra
.923 .549 .136 r
.19486 .36915 .20242 .38283 .21053 .41699 .20303 .40161 Metetra
.941 .587 .188 r
.20303 .40161 .21053 .41699 .21842 .45695 .21085 .44106 Metetra
.936 .58 .168 r
.21085 .44106 .21842 .45695 .2268 .4956 .21903 .48057 Metetra
.893 .515 .057 r
.21903 .48057 .2268 .4956 .2363 .52548 .22825 .51264 Metetra
.632 .213 0 r
.22825 .51264 .2363 .52548 .24736 .54028 .239 .53059 Metetra
.507 .655 .926 r
.239 .53059 .24736 .54028 .26009 .53629 .25147 .53012 Metetra
.882 .801 .765 r
.25147 .53012 .26009 .53629 .27431 .51341 .26553 .51046 Metetra
.944 .8 .672 r
.26553 .51046 .27431 .51341 .28954 .47522 .28073 .47455 Metetra
.962 .797 .632 r
.28073 .47455 .28954 .47522 .30518 .42798 .29649 .42829 Metetra
.968 .798 .619 r
.29649 .42829 .30518 .42798 .32066 .37917 .31218 .37906 Metetra
.967 .805 .628 r
.31218 .37906 .32066 .37917 .33552 .33599 .3273 .33425 Metetra
.956 .819 .667 r
.3273 .33425 .33552 .33599 .34949 .30429 .34156 .29999 Metetra
.907 .837 .765 r
.34156 .29999 .34949 .30429 .36251 .28792 .35482 .28055 Metetra
.587 .742 .95 r
.35482 .28055 .36251 .28792 .37467 .28854 .36717 .278 Metetra
0 0 .516 r
.36717 .278 .37467 .28854 .38621 .30552 .37881 .29212 Metetra
.803 .406 0 r
.37881 .29212 .38621 .30552 .39743 .33593 .39005 .32041 Metetra
.867 .495 .005 r
.39005 .32041 .39743 .33593 .40868 .37475 .40124 .35819 Metetra
.869 .505 .011 r
.40124 .35819 .40868 .37475 .42029 .41524 .41273 .39898 Metetra
.822 .45 0 r
.41273 .39898 .42029 .41524 .4325 .44978 .4248 .43523 Metetra
.631 .246 0 r
.4248 .43523 .4325 .44978 .44541 .47129 .43758 .4596 Metetra
.138 .405 .852 r
.43758 .4596 .44541 .47129 .45896 .47474 .45106 .46658 Metetra
.818 .8 .834 r
.45106 .46658 .45896 .47474 .47295 .45852 .46506 .45384 Metetra
.948 .824 .688 r
.46506 .45384 .47295 .45852 .48712 .42488 .47932 .42296 Metetra
.978 .817 .616 r
.47932 .42296 .48712 .42488 .5012 .37931 .49356 .37892 Metetra
.986 .815 .587 r
.49356 .37892 .5012 .37931 .51502 .32916 .50756 .32889 Metetra
.988 .819 .586 r
.50756 .32889 .51502 .32916 .52851 .28201 .52124 .28052 Metetra
.982 .833 .618 r
.52124 .28052 .52851 .28201 .54176 .24441 .53463 .24064 Metetra
.954 .854 .705 r
.53463 .24064 .54176 .24441 .55492 .2211 .54788 .21437 Metetra
.792 .833 .884 r
.54788 .21437 .55492 .2211 .56823 .21462 .5612 .20467 Metetra
.06 .378 .843 r
.5612 .20467 .56823 .21462 .58191 .22524 .57484 .21221 Metetra
0 0 .419 r
.57484 .21221 .58191 .22524 .59614 .25092 .58897 .23539 Metetra
.698 .333 0 r
.58897 .23539 .59614 .25092 .61101 .2874 .60373 .27033 Metetra
.727 .373 0 r
.60373 .27033 .61101 .2874 .62648 .32847 .6191 .31113 Metetra
.687 .337 0 r
.6191 .31113 .62648 .32847 .64233 .36661 .63491 .35044 Metetra
0 0 .395 r
.63491 .35044 .64233 .36661 .65821 .3942 .65084 .38052 Metetra
0 .203 .73 r
.65084 .38052 .65821 .3942 .6737 .40508 .66648 .39479 Metetra
.66 .732 .903 r
.66648 .39479 .6737 .40508 .68841 .39611 .68142 .38947 Metetra
.938 .848 .728 r
.68142 .38947 .68841 .39611 .7021 .36805 .6954 .36458 Metetra
.989 .84 .602 r
.6954 .36458 .7021 .36805 .71476 .32537 .70834 .32397 Metetra
.998 .829 .542 r
.70834 .32397 .71476 .32537 .72664 .27501 .72045 .2743 Metetra
1 .828 .525 r
.72045 .2743 .72664 .27501 .73817 .22479 .73212 .22334 Metetra
.998 .84 .548 r
.73212 .22334 .73817 .22479 .74988 .18187 .74385 .17848 Metetra
.987 .867 .629 r
.74385 .17848 .74988 .18187 .76233 .15181 .75621 .14565 Metetra
.902 .882 .804 r
.75621 .14565 .76233 .15181 .77598 .13806 .76968 .12869 Metetra
.989 .892 .597 r
.12073 .44186 .13216 .4258 .14811 .38535 .13748 .39667 Metetra
.982 .908 .638 r
.13748 .39667 .14811 .38535 .16247 .35719 .15287 .36101 Metetra
.949 .929 .748 r
.15287 .36101 .16247 .35719 .17498 .34471 .1665 .33944 Metetra
.691 .821 .945 r
.1665 .33944 .17498 .34471 .18568 .34906 .17824 .33438 Metetra
0 .103 .658 r
.17824 .33438 .18568 .34906 .19486 .36915 .18826 .34599 Metetra
0 0 .295 r
.18826 .34599 .19486 .36915 .20303 .40161 .19695 .37214 Metetra
0 0 .176 r
.19695 .37214 .20303 .40161 .21085 .44106 .20489 .40853 Metetra
0 0 .164 r
.20489 .40853 .21085 .44106 .21903 .48057 .2128 .449 Metetra
0 0 .23 r
.2128 .449 .21903 .48057 .22825 .51264 .2214 .48617 Metetra
0 0 .406 r
.2214 .48617 .22825 .51264 .239 .53059 .23129 .51272 Metetra
.112 .265 .742 r
.23129 .51272 .239 .53059 .25147 .53012 .24286 .52282 Metetra
.772 .795 .871 r
.24286 .52282 .25147 .53012 .26553 .51046 .25615 .51363 Metetra
.965 .906 .708 r
.25615 .51363 .26553 .51046 .28073 .47455 .27088 .48606 Metetra
.986 .899 .592 r
.27088 .48606 .28073 .47455 .29649 .42829 .2865 .44454 Metetra
.981 .888 .535 r
.2865 .44454 .29649 .42829 .31218 .37906 .30241 .39586 Metetra
.975 .888 .521 r
.30241 .39586 .31218 .37906 .3273 .33425 .318 .34757 Metetra
.973 .903 .551 r
.318 .34757 .3273 .33425 .34156 .29999 .33286 .30666 Metetra
.967 .937 .653 r
.33286 .30666 .34156 .29999 .35482 .28055 .34676 .27848 Metetra
.858 .927 .872 r
.34676 .27848 .35482 .28055 .36717 .278 .35967 .26637 Metetra
.245 .454 .866 r
.35967 .26637 .36717 .278 .37881 .29212 .37173 .27136 Metetra
0 0 .532 r
.37173 .27136 .37881 .29212 .39005 .32041 .38321 .29222 Metetra
0 0 .376 r
.38321 .29222 .39005 .32041 .40124 .35819 .39444 .32545 Metetra
0 0 .335 r
.39444 .32545 .40124 .35819 .41273 .39898 .40578 .36552 Metetra
0 0 .361 r
.40578 .36552 .41273 .39898 .4248 .43523 .41756 .4053 Metetra
0 0 .458 r
.41756 .4053 .4248 .43523 .43758 .4596 .43 .43715 Metetra
.002 .14 .656 r
.43 .43715 .43758 .4596 .45106 .46658 .44319 .45432 Metetra
.565 .636 .88 r
.44319 .45432 .45106 .46658 .46506 .45384 .45701 .45254 Metetra
.939 .917 .765 r
.45701 .45254 .46506 .45384 .47932 .42296 .47125 .43122 Metetra
.972 .909 .566 r
.47125 .43122 .47932 .42296 .49356 .37892 .48562 .39356 Metetra
.944 .871 .455 r
.48562 .39356 .49356 .37892 .50756 .32889 .49986 .34575 Metetra
.923 .854 .412 r
.49986 .34575 .50756 .32889 .52124 .28052 .5138 .29536 Metetra
.919 .863 .426 r
.5138 .29536 .52124 .28052 .53463 .24064 .52742 .24987 Metetra
.934 .907 .517 r
.52742 .24987 .53463 .24064 .54788 .21437 .5408 .21541 Metetra
.928 .971 .75 r
.5408 .21541 .54788 .21437 .5612 .20467 .55413 .19619 Metetra
.559 .714 .944 r
.55413 .19619 .5612 .20467 .57484 .21221 .56765 .19415 Metetra
.021 .194 .703 r
.56765 .19415 .57484 .21221 .58897 .23539 .58157 .20895 Metetra
0 0 .536 r
.58157 .20895 .58897 .23539 .60373 .27033 .59607 .23798 Metetra
0 0 .475 r
.59607 .23798 .60373 .27033 .6191 .31113 .61121 .2764 Metetra
0 0 .473 r
.61121 .2764 .6191 .31113 .63491 .35044 .62691 .31755 Metetra
0 0 .519 r
.62691 .31755 .63491 .35044 .65084 .38052 .64294 .35372 Metetra
.006 .113 .627 r
.64294 .35372 .65084 .38052 .66648 .39479 .6589 .37747 Metetra
.361 .445 .812 r
.6589 .37747 .66648 .39479 .68142 .38947 .67438 .38326 Metetra
.859 .882 .853 r
.67438 .38326 .68142 .38947 .6954 .36458 .68901 .3689 Metetra
.951 .921 .562 r
.68901 .3689 .6954 .36458 .70834 .32397 .7026 .33622 Metetra
.875 .83 .359 r
.7026 .33622 .70834 .32397 .72045 .2743 .7152 .29049 Metetra
.821 .777 .271 r
.7152 .29049 .72045 .2743 .73212 .22334 .72711 .23911 Metetra
.802 .769 .258 r
.72711 .23911 .73212 .22334 .74385 .17848 .73879 .18986 Metetra
.825 .814 .329 r
.73879 .18986 .74385 .17848 .75621 .14565 .7508 .1496 Metetra
.895 .932 .554 r
.7508 .1496 .75621 .14565 .76968 .12869 .76367 .12337 Metetra
.9 .882 .453 r
.10737 .4715 .12073 .44186 .13748 .39667 .1248 .42297 Metetra
.9 .89 .468 r
.1248 .42297 .13748 .39667 .15287 .36101 .14145 .37878 Metetra
.919 .926 .549 r
.14145 .37878 .15287 .36101 .1665 .33944 .15666 .34504 Metetra
.925 .974 .751 r
.15666 .34504 .1665 .33944 .17824 .33438 .17006 .32597 Metetra
.59 .706 .923 r
.17006 .32597 .17824 .33438 .18826 .34599 .18158 .32364 Metetra
.002 .117 .632 r
.18158 .32364 .18826 .34599 .19695 .37214 .19142 .33782 Metetra
0 0 .436 r
.19142 .33782 .19695 .37214 .20489 .40853 .20001 .36603 Metetra
0 0 .363 r
.20001 .36603 .20489 .40853 .2128 .449 .20798 .40361 Metetra
0 0 .356 r
.20798 .40361 .2128 .449 .2214 .48617 .21604 .44413 Metetra
0 0 .402 r
.21604 .44413 .2214 .48617 .23129 .51272 .22489 .48012 Metetra
0 0 .523 r
.22489 .48012 .23129 .51272 .24286 .52282 .23513 .50435 Metetra
.281 .367 .774 r
.23513 .50435 .24286 .52282 .25615 .51363 .24708 .51137 Metetra
.851 .917 .876 r
.24708 .51137 .25615 .51363 .27088 .48606 .26072 .49894 Metetra
.912 .939 .576 r
.26072 .49894 .27088 .48606 .2865 .44454 .27572 .46857 Metetra
.843 .855 .399 r
.27572 .46857 .2865 .44454 .30241 .39586 .29152 .4252 Metetra
.802 .812 .328 r
.29152 .4252 .30241 .39586 .318 .34757 .30748 .37588 Metetra
.793 .808 .322 r
.30748 .37588 .318 .34757 .33286 .30666 .32305 .32818 Metetra
.819 .847 .386 r
.32305 .32818 .33286 .30666 .34676 .27848 .33783 .28889 Metetra
.887 .943 .58 r
.33783 .28889 .34676 .27848 .35967 .26637 .35164 .26306 Metetra
.803 .908 .913 r
.35164 .26306 .35967 .26637 .37173 .27136 .36449 .25366 Metetra
.257 .35 .768 r
.36449 .25366 .37173 .27136 .38321 .29222 .37653 .26135 Metetra
0 .045 .564 r
.37653 .26135 .38321 .29222 .39444 .32545 .38805 .28454 Metetra
0 0 .478 r
.38805 .28454 .39444 .32545 .40578 .36552 .39939 .31936 Metetra
0 0 .454 r
.39939 .31936 .40578 .36552 .41756 .4053 .41091 .35995 Metetra
0 0 .472 r
.41091 .35995 .41756 .4053 .43 .43715 .42292 .39903 Metetra
0 .02 .536 r
.42292 .39903 .43 .43715 .44319 .45432 .43562 .42894 Metetra
.177 .234 .684 r
.43562 .42894 .44319 .45432 .45701 .45254 .44903 .44321 Metetra
.662 .744 .911 r
.44903 .44321 .45701 .45254 .47125 .43122 .46305 .43811 Metetra
.892 .96 .626 r
.46305 .43811 .47125 .43122 .48562 .39356 .47742 .41368 Metetra
.75 .797 .311 r
.47742 .41368 .48562 .39356 .49986 .34575 .49185 .37372 Metetra
.49185 .37372 .49986 .34575 .5138 .29536 .5061 .32476 Metetra
.5061 .32476 .5138 .29536 .52742 .24987 .52003 .27451 Metetra
.52003 .27451 .52742 .24987 .5408 .21541 .53365 .23028 Metetra
.743 .817 .348 r
.53365 .23028 .5408 .21541 .55413 .19619 .54707 .19796 Metetra
.878 .993 .765 r
.54707 .19796 .55413 .19619 .56765 .19415 .5605 .18138 Metetra
.483 .574 .871 r
.5605 .18138 .56765 .19415 .58157 .20895 .57417 .18212 Metetra
.152 .2 .659 r
.57417 .18212 .58157 .20895 .59607 .23798 .58831 .19947 Metetra
.039 .068 .563 r
.58831 .19947 .59607 .23798 .61121 .2764 .60308 .23043 Metetra
.005 .025 .528 r
.60308 .23043 .61121 .2764 .62691 .31755 .61851 .26983 Metetra
.011 .028 .529 r
.61851 .26983 .62691 .31755 .64294 .35372 .63448 .31077 Metetra
.055 .074 .561 r
.63448 .31077 .64294 .35372 .6589 .37747 .65071 .34543 Metetra
.164 .192 .644 r
.65071 .34543 .6589 .37747 .67438 .38326 .66679 .36656 Metetra
.453 .512 .829 r
.66679 .36656 .67438 .38326 .68901 .3689 .68229 .36905 Metetra
.883 .992 .779 r
.68229 .36905 .68901 .3689 .7026 .33622 .69686 .35137 Metetra
.69686 .35137 .7026 .33622 .7152 .29049 .71033 .31596 Metetra
.71033 .31596 .7152 .29049 .72711 .23911 .72282 .26858 Metetra
0 0 .007 r
.72282 .26858 .72711 .23911 .73879 .18986 .73467 .21683 Metetra
.73467 .21683 .73879 .18986 .7508 .1496 .74638 .16845 Metetra
.74638 .16845 .7508 .1496 .76367 .12337 .75853 .13006 Metetra
.803 .838 .373 r
.09323 .50479 .10737 .4715 .1248 .42297 .11063 .45888 Metetra
.786 .819 .342 r
.11063 .45888 .1248 .42297 .14145 .37878 .12813 .41018 Metetra
.8 .836 .369 r
.12813 .41018 .14145 .37878 .15666 .34504 .14484 .36598 Metetra
.85 .897 .477 r
.14484 .36598 .15666 .34504 .17006 .32597 .16009 .33236 Metetra
.911 .982 .739 r
.16009 .33236 .17006 .32597 .18158 .32364 .17353 .31352 Metetra
.582 .662 .892 r
.17353 .31352 .18158 .32364 .19142 .33782 .1851 .31147 Metetra
.099 .149 .627 r
.1851 .31147 .19142 .33782 .20001 .36603 .195 .32595 Metetra
0 0 .474 r
.195 .32595 .20001 .36603 .20798 .40361 .20368 .35442 Metetra
0 0 .414 r
.20368 .35442 .20798 .40361 .21604 .44413 .21175 .39219 Metetra
0 0 .406 r
.21175 .39219 .21604 .44413 .22489 .48012 .21993 .43277 Metetra
0 0 .44 r
.21993 .43277 .22489 .48012 .23513 .50435 .22892 .46866 Metetra
0 .027 .54 r
.22892 .46866 .23513 .50435 .24708 .51137 .23931 .49263 Metetra
.3 .377 .775 r
.23931 .49263 .24708 .51137 .26072 .49894 .2514 .49926 Metetra
.852 .972 .87 r
.2514 .49926 .26072 .49894 .27572 .46857 .26517 .48635 Metetra
.791 .878 .449 r
.26517 .48635 .27572 .46857 .29152 .4252 .28028 .45552 Metetra
.687 .755 .26 r
.28028 .45552 .29152 .4252 .30748 .37588 .29615 .41178 Metetra
.29615 .41178 .30748 .37588 .32305 .32818 .31217 .36222 Metetra
.31217 .36222 .32305 .32818 .33783 .28889 .32778 .31445 Metetra
.699 .77 .281 r
.32778 .31445 .33783 .28889 .35164 .26306 .34261 .27523 Metetra
.827 .917 .523 r
.34261 .27523 .35164 .26306 .36449 .25366 .35647 .24959 Metetra
.794 .89 .913 r
.35647 .24959 .36449 .25366 .37653 .26135 .36939 .24045 Metetra
.298 .34 .737 r
.36939 .24045 .37653 .26135 .38805 .28454 .38153 .24844 Metetra
.074 .089 .57 r
.38153 .24844 .38805 .28454 .39939 .31936 .39317 .27191 Metetra
0 0 .501 r
.39317 .27191 .39939 .31936 .41091 .35995 .40467 .30695 Metetra
0 0 .48 r
.40467 .30695 .41091 .35995 .42292 .39903 .41637 .34765 Metetra
0 0 .493 r
.41637 .34765 .42292 .39903 .43562 .42894 .42856 .38668 Metetra
.047 .058 .547 r
.42856 .38668 .43562 .42894 .44903 .44321 .44143 .41638 Metetra
.209 .246 .682 r
.44143 .41638 .44903 .44321 .46305 .43811 .45501 .43028 Metetra
.674 .79 .936 r
.45501 .43028 .46305 .43811 .47742 .41368 .46915 .42472 Metetra
.759 .891 .487 r
.46915 .42472 .47742 .41368 .49185 .37372 .48361 .39981 Metetra
.48361 .39981 .49185 .37372 .5061 .32476 .4981 .35942 Metetra
.4981 .35942 .5061 .32476 .52003 .27451 .51237 .31016 Metetra
.51237 .31016 .52003 .27451 .53365 .23028 .52632 .25976 Metetra
.52632 .25976 .53365 .23028 .54707 .19796 .53997 .21556 Metetra
.53997 .21556 .54707 .19796 .5605 .18138 .55344 .18338 Metetra
.863 .995 .76 r
.55344 .18338 .5605 .18138 .57417 .18212 .56696 .16704 Metetra
.486 .537 .834 r
.56696 .16704 .57417 .18212 .58831 .19947 .58076 .16807 Metetra
.211 .215 .645 r
.58076 .16807 .58831 .19947 .60308 .23043 .59508 .18571 Metetra
.117 .104 .566 r
.59508 .18571 .60308 .23043 .61851 .26983 .61006 .2169 Metetra
.085 .067 .537 r
.61006 .2169 .61851 .26983 .63448 .31077 .62573 .25645 Metetra
.086 .067 .537 r
.62573 .25645 .63448 .31077 .65071 .34543 .64195 .29739 Metetra
.117 .104 .565 r
.64195 .29739 .65071 .34543 .66679 .36656 .65841 .33189 Metetra
.202 .206 .64 r
.65841 .33189 .66679 .36656 .68229 .36905 .67469 .35269 Metetra
.461 .524 .836 r
.67469 .35269 .68229 .36905 .69686 .35137 .69033 .35474 Metetra
.79 .97 .671 r
.69033 .35474 .69686 .35137 .71033 .31596 .70497 .33655 Metetra
.70497 .33655 .71033 .31596 .72282 .26858 .71847 .30067 Metetra
0 0 .067 r
.71847 .30067 .72282 .26858 .73467 .21683 .73096 .25293 Metetra
0 0 .109 r
.73096 .25293 .73467 .21683 .74638 .16845 .74279 .20098 Metetra
0 0 .093 r
.74279 .20098 .74638 .16845 .75853 .13006 .7545 .15256 Metetra
.863 .902 .488 r
.08008 .52808 .09323 .50479 .11063 .45888 .09652 .49165 Metetra
.818 .846 .385 r
.09652 .49165 .11063 .45888 .12813 .41018 .11403 .44532 Metetra
.802 .829 .356 r
.11403 .44532 .12813 .41018 .14484 .36598 .1316 .39648 Metetra
.814 .845 .384 r
.1316 .39648 .14484 .36598 .16009 .33236 .14835 .3524 Metetra
.862 .905 .493 r
.14835 .3524 .16009 .33236 .17353 .31352 .16361 .31913 Metetra
.912 .981 .754 r
.16361 .31913 .17353 .31352 .1851 .31147 .17706 .3008 Metetra
.559 .642 .889 r
.17706 .3008 .1851 .31147 .195 .32595 .18865 .29934 Metetra
.076 .133 .619 r
.18865 .29934 .195 .32595 .20368 .35442 .19859 .31439 Metetra
0 0 .466 r
.19859 .31439 .20368 .35442 .21175 .39219 .20733 .34334 Metetra
0 0 .408 r
.20733 .34334 .21175 .39219 .21993 .43277 .2155 .3814 Metetra
0 0 .402 r
.2155 .3814 .21993 .43277 .22892 .46866 .22381 .42201 Metetra
0 0 .439 r
.22381 .42201 .22892 .46866 .23931 .49263 .23296 .45765 Metetra
0 .031 .544 r
.23296 .45765 .23931 .49263 .2514 .49926 .24352 .48109 Metetra
.319 .399 .788 r
.24352 .48109 .2514 .49926 .26517 .48635 .25578 .48698 Metetra
.863 .974 .858 r
.25578 .48698 .26517 .48635 .28028 .45552 .26971 .47326 Metetra
.804 .882 .455 r
.26971 .47326 .28028 .45552 .29615 .41178 .28494 .4417 Metetra
.705 .767 .273 r
.28494 .4417 .29615 .41178 .31217 .36222 .3009 .39741 Metetra
.3009 .39741 .31217 .36222 .32778 .31445 .31697 .34759 Metetra
.31697 .34759 .32778 .31445 .34261 .27523 .33262 .29985 Metetra
.717 .784 .299 r
.33262 .29985 .34261 .27523 .35647 .24959 .34748 .2609 Metetra
.84 .928 .544 r
.34748 .2609 .35647 .24959 .36939 .24045 .36138 .23572 Metetra
.778 .874 .918 r
.36138 .23572 .36939 .24045 .38153 .24844 .37435 .22715 Metetra
.279 .325 .731 r
.37435 .22715 .38153 .24844 .39317 .27191 .38658 .23573 Metetra
.059 .079 .565 r
.38658 .23573 .39317 .27191 .40467 .30695 .39835 .25972 Metetra
0 0 .497 r
.39835 .25972 .40467 .30695 .41637 .34765 .41 .29513 Metetra
0 0 .478 r
.41 .29513 .41637 .34765 .42856 .38668 .42188 .33596 Metetra
0 0 .493 r
.42188 .33596 .42856 .38668 .44143 .41638 .43427 .37484 Metetra
.044 .059 .549 r
.43427 .37484 .44143 .41638 .45501 .43028 .44733 .40409 Metetra
.217 .258 .69 r
.44733 .40409 .45501 .43028 .46915 .42472 .46108 .41731 Metetra
.696 .811 .936 r
.46108 .41731 .46915 .42472 .48361 .39981 .47535 .41093 Metetra
.769 .892 .486 r
.47535 .41093 .48361 .39981 .4981 .35942 .4899 .38521 Metetra
.4899 .38521 .4981 .35942 .51237 .31016 .50443 .34418 Metetra
.50443 .34418 .51237 .31016 .52632 .25976 .51873 .29454 Metetra
.51873 .29454 .52632 .25976 .53997 .21556 .5327 .24406 Metetra
.5327 .24406 .53997 .21556 .55344 .18338 .54637 .20004 Metetra
.54637 .20004 .55344 .18338 .56696 .16704 .5599 .16827 Metetra
.866 .996 .783 r
.5599 .16827 .56696 .16704 .58076 .16807 .57351 .15247 Metetra
.468 .52 .829 r
.57351 .15247 .58076 .16807 .59508 .18571 .58746 .15408 Metetra
.199 .206 .642 r
.58746 .15408 .59508 .18571 .61006 .2169 .60196 .17228 Metetra
.106 .098 .564 r
.60196 .17228 .61006 .2169 .62573 .25645 .61717 .2039 Metetra
.076 .062 .536 r
.61717 .2039 .62573 .25645 .64195 .29739 .63309 .24367 Metetra
.079 .064 .537 r
.63309 .24367 .64195 .29739 .65841 .33189 .64956 .28456 Metetra
.113 .103 .567 r
.64956 .28456 .65841 .33189 .67469 .35269 .66626 .31872 Metetra
.204 .212 .645 r
.66626 .31872 .67469 .35269 .69033 .35474 .68273 .3389 Metetra
.478 .544 .846 r
.68273 .3389 .69033 .35474 .70497 .33655 .69849 .34013 Metetra
.795 .965 .655 r
.69849 .34013 .70497 .33655 .71847 .30067 .71319 .3211 Metetra
.71319 .3211 .71847 .30067 .73096 .25293 .7267 .28448 Metetra
0 0 .057 r
.7267 .28448 .73096 .25293 .74279 .20098 .73915 .23625 Metetra
0 0 .099 r
.73915 .23625 .74279 .20098 .7545 .15256 .75096 .18409 Metetra
.951 .948 .727 r
.06887 .53505 .08008 .52808 .09652 .49165 .0839 .51063 Metetra
.954 .925 .574 r
.0839 .51063 .09652 .49165 .11403 .44532 .10075 .47136 Metetra
.936 .9 .502 r
.10075 .47136 .11403 .44532 .1316 .39648 .11846 .42368 Metetra
.925 .892 .482 r
.11846 .42368 .1316 .39648 .14835 .3524 .13603 .37509 Metetra
.927 .905 .509 r
.13603 .37509 .14835 .3524 .16361 .31913 .15259 .33272 Metetra
.94 .943 .607 r
.15259 .33272 .16361 .31913 .17706 .3008 .16758 .30224 Metetra
.897 .958 .828 r
.16758 .30224 .17706 .3008 .18865 .29934 .1807 .28734 Metetra
.396 .535 .878 r
.1807 .28734 .18865 .29934 .19859 .31439 .19198 .28946 Metetra
0 .002 .555 r
.19198 .28946 .19859 .31439 .20733 .34334 .2017 .30776 Metetra
0 0 .389 r
.2017 .30776 .20733 .34334 .2155 .3814 .21033 .33915 Metetra
0 0 .335 r
.21033 .33915 .2155 .3814 .22381 .42201 .21854 .37841 Metetra
0 0 .344 r
.21854 .37841 .22381 .42201 .23296 .45765 .22705 .41868 Metetra
0 0 .412 r
.22705 .41868 .23296 .45765 .24352 .48109 .23654 .45234 Metetra
0 .045 .574 r
.23654 .45234 .24352 .48109 .25578 .48698 .24754 .47241 Metetra
.445 .532 .852 r
.24754 .47241 .25578 .48698 .26971 .47326 .26026 .47414 Metetra
.915 .951 .805 r
.26026 .47414 .26971 .47326 .28494 .4417 .27459 .45625 Metetra
.922 .924 .546 r
.27459 .45625 .28494 .4417 .3009 .39741 .29012 .4213 Metetra
.87 .861 .411 r
.29012 .4213 .3009 .39741 .31697 .34759 .30625 .37502 Metetra
.84 .832 .36 r
.30625 .37502 .31697 .34759 .33262 .29985 .32235 .32483 Metetra
.837 .837 .368 r
.32235 .32483 .33262 .29985 .34748 .2609 .33793 .27828 Metetra
.866 .884 .452 r
.33793 .27828 .34748 .2609 .36138 .23572 .35267 .24178 Metetra
.914 .972 .681 r
.35267 .24178 .36138 .23572 .37435 .22715 .36644 .21988 Metetra
.669 .785 .936 r
.36644 .21988 .37435 .22715 .38658 .23573 .37933 .21493 Metetra
.127 .232 .704 r
.37933 .21493 .38658 .23573 .39835 .25972 .39153 .22699 Metetra
0 0 .526 r
.39153 .22699 .39835 .25972 .41 .29513 .40335 .25383 Metetra
0 0 .457 r
.40335 .25383 .41 .29513 .42188 .33596 .41513 .29099 Metetra
0 0 .445 r
.41513 .29099 .42188 .33596 .43427 .37484 .42723 .33211 Metetra
0 0 .476 r
.42723 .33211 .43427 .37484 .44733 .40409 .43988 .36962 Metetra
0 .049 .563 r
.43988 .36962 .44733 .40409 .46108 .41731 .45322 .39595 Metetra
.267 .336 .749 r
.45322 .39595 .46108 .41731 .47535 .41093 .46721 .40516 Metetra
.803 .874 .9 r
.46721 .40516 .47535 .41093 .4899 .38521 .48167 .39442 Metetra
.891 .931 .552 r
.48167 .39442 .4899 .38521 .50443 .34418 .49632 .36485 Metetra
.775 .799 .31 r
.49632 .36485 .50443 .34418 .51873 .29454 .51089 .32119 Metetra
.71 .732 .215 r
.51089 .32119 .51873 .29454 .5327 .24406 .52518 .27053 Metetra
.692 .719 .199 r
.52518 .27053 .5327 .24406 .54637 .20004 .53913 .22068 Metetra
.72 .76 .258 r
.53913 .22068 .54637 .20004 .5599 .16827 .55281 .17869 Metetra
.816 .886 .459 r
.55281 .17869 .5599 .16827 .57351 .15247 .5664 .14997 Metetra
.843 .961 .884 r
.5664 .14997 .57351 .15247 .58746 .15408 .58016 .13775 Metetra
.349 .44 .814 r
.58016 .13775 .58746 .15408 .60196 .17228 .59432 .14299 Metetra
.083 .142 .626 r
.59432 .14299 .60196 .17228 .61717 .2039 .60911 .16437 Metetra
0 .037 .547 r
.60911 .16437 .61717 .2039 .63309 .24367 .62464 .19825 Metetra
0 .007 .522 r
.62464 .19825 .63309 .24367 .64956 .28456 .64088 .23893 Metetra
0 .022 .531 r
.64088 .23893 .64956 .28456 .66626 .31872 .65763 .2791 Metetra
.055 .087 .577 r
.65763 .2791 .66626 .31872 .68273 .3389 .6745 .31086 Metetra
.205 .247 .684 r
.6745 .31086 .68273 .3389 .69849 .34013 .69102 .3273 Metetra
.591 .662 .887 r
.69102 .3273 .69849 .34013 .71319 .3211 .70671 .32413 Metetra
.882 .966 .642 r
.70671 .32413 .71319 .3211 .7267 .28448 .72125 .30087 Metetra
.72125 .30087 .7267 .28448 .73915 .23625 .73456 .26103 Metetra
.73456 .26103 .73915 .23625 .75096 .18409 .74687 .21111 Metetra
.866 .831 .811 r
.05906 .53066 .06887 .53505 .0839 .51063 .07301 .51491 Metetra
.964 .867 .693 r
.07301 .51491 .0839 .51063 .10075 .47136 .0892 .482 Metetra
.986 .869 .633 r
.0892 .482 .10075 .47136 .11846 .42368 .10676 .43732 Metetra
.991 .871 .609 r
.10676 .43732 .11846 .42368 .13603 .37509 .12465 .38806 Metetra
.991 .877 .611 r
.12465 .38806 .13603 .37509 .15259 .33272 .14191 .34173 Metetra
.984 .892 .647 r
.14191 .34173 .15259 .33272 .16758 .30224 .15783 .30481 Metetra
.95 .911 .744 r
.15783 .30481 .16758 .30224 .1807 .28734 .17195 .28198 Metetra
.72 .834 .935 r
.17195 .28198 .1807 .28734 .19198 .28946 .18416 .2758 Metetra
0 .13 .678 r
.18416 .2758 .19198 .28946 .2017 .30776 .19462 .28654 Metetra
0 0 .265 r
.19462 .28654 .2017 .30776 .21033 .33915 .20372 .31215 Metetra
.724 .453 0 r
.20372 .31215 .21033 .33915 .21854 .37841 .21205 .34843 Metetra
.727 .47 0 r
.21205 .34843 .21854 .37841 .22705 .41868 .22033 .3892 Metetra
0 0 .179 r
.22033 .3892 .22705 .41868 .23654 .45234 .22928 .42705 Metetra
0 0 .361 r
.22928 .42705 .23654 .45234 .24754 .47241 .23954 .45448 Metetra
.043 .228 .729 r
.23954 .45448 .24754 .47241 .26026 .47414 .25147 .46544 Metetra
.749 .774 .873 r
.25147 .46544 .26026 .47414 .27459 .45625 .26514 .45686 Metetra
.958 .887 .718 r
.26514 .45686 .27459 .45625 .29012 .4213 .28026 .42947 Metetra
.99 .886 .611 r
.28026 .42947 .29012 .4213 .30625 .37502 .29629 .38765 Metetra
.992 .88 .56 r
.29629 .38765 .30625 .37502 .32235 .32483 .31259 .33821 Metetra
.989 .881 .547 r
.31259 .33821 .32235 .32483 .33793 .27828 .32859 .28886 Metetra
.986 .895 .573 r
.32859 .28886 .33793 .27828 .35267 .24178 .34387 .24669 Metetra
.975 .923 .662 r
.34387 .24669 .35267 .24178 .36644 .21988 .3582 .21721 Metetra
.87 .92 .858 r
.3582 .21721 .36644 .21988 .37933 .21493 .37157 .20386 Metetra
.273 .498 .891 r
.37157 .20386 .37933 .21493 .39153 .22699 .38413 .20782 Metetra
0 0 .53 r
.38413 .20782 .39153 .22699 .40335 .25383 .39614 .22795 Metetra
0 0 .35 r
.39614 .22795 .40335 .25383 .41513 .29099 .40795 .26084 Metetra
0 0 .3 r
.40795 .26084 .41513 .29099 .42723 .33211 .4199 .30099 Metetra
0 0 .326 r
.4199 .30099 .42723 .33211 .43988 .36962 .4323 .34127 Metetra
0 0 .428 r
.4323 .34127 .43988 .36962 .45322 .39595 .44537 .37391 Metetra
0 .108 .643 r
.44537 .37391 .45322 .39595 .46721 .40516 .45913 .39195 Metetra
.533 .615 .88 r
.45913 .39195 .46721 .40516 .48167 .39442 .47348 .39088 Metetra
.928 .896 .776 r
.47348 .39088 .48167 .39442 .49632 .36485 .48817 .36991 Metetra
.985 .903 .595 r
.48817 .36991 .49632 .36485 .51089 .32119 .5029 .33212 Metetra
.972 .876 .494 r
.5029 .33212 .51089 .32119 .52518 .27053 .51744 .2837 Metetra
.958 .863 .453 r
.51744 .2837 .52518 .27053 .53913 .22068 .53165 .23234 Metetra
.954 .872 .464 r
.53165 .23234 .53913 .22068 .55281 .17869 .54553 .18563 Metetra
.961 .908 .545 r
.54553 .18563 .55281 .17869 .5664 .14997 .55923 .14985 Metetra
.94 .958 .747 r
.55923 .14985 .5664 .14997 .58016 .13775 .57295 .12932 Metetra
.591 .745 .95 r
.57295 .12932 .58016 .13775 .59432 .14299 .58697 .12611 Metetra
.006 .209 .721 r
.58697 .12611 .59432 .14299 .60911 .16437 .60151 .13999 Metetra
0 0 .531 r
.60151 .13999 .60911 .16437 .62464 .19825 .61677 .16844 Metetra
0 0 .46 r
.61677 .16844 .62464 .19825 .64088 .23893 .63277 .2067 Metetra
0 0 .456 r
.63277 .2067 .64088 .23893 .65763 .2791 .64941 .24812 Metetra
0 0 .505 r
.64941 .24812 .65763 .2791 .6745 .31086 .66639 .28494 Metetra
0 .089 .62 r
.66639 .28494 .6745 .31086 .69102 .3273 .68325 .30951 Metetra
.326 .428 .812 r
.68325 .30951 .69102 .3273 .70671 .32413 .6995 .31607 Metetra
.838 .856 .858 r
.6995 .31607 .70671 .32413 .72125 .30087 .71471 .3022 Metetra
.972 .921 .601 r
.71471 .3022 .72125 .30087 .73456 .26103 .72869 .26957 Metetra
.925 .853 .412 r
.72869 .26957 .73456 .26103 .74687 .21111 .74151 .22341 Metetra
.826 .778 .807 r
.04958 .52308 .05906 .53066 .07301 .51491 .06335 .50914 Metetra
.907 .768 .696 r
.06335 .50914 .07301 .51491 .0892 .482 .07948 .47761 Metetra
.927 .76 .655 r
.07948 .47761 .0892 .482 .10676 .43732 .09711 .43365 Metetra
.934 .758 .64 r
.09711 .43365 .10676 .43732 .12465 .38806 .11518 .38437 Metetra
.935 .761 .643 r
.11518 .38437 .12465 .38806 .14191 .34173 .13271 .33732 Metetra
.928 .77 .665 r
.13271 .33732 .14191 .34173 .15783 .30481 .14892 .29913 Metetra
.901 .785 .724 r
.14892 .29913 .15783 .30481 .17195 .28198 .16332 .2747 Metetra
.754 .786 .879 r
.16332 .2747 .17195 .28198 .18416 .2758 .17576 .26679 Metetra
0 .115 .627 r
.17576 .26679 .18416 .2758 .19462 .28654 .18638 .2759 Metetra
.874 .453 .03 r
.18638 .2759 .19462 .28654 .20372 .31215 .19555 .30022 Metetra
.932 .554 .181 r
.19555 .30022 .20372 .31215 .21205 .34843 .20385 .33573 Metetra
.941 .575 .212 r
.20385 .33573 .21205 .34843 .22033 .3892 .21202 .37642 Metetra
.933 .558 .178 r
.21202 .37642 .22033 .3892 .22928 .42705 .2208 .41495 Metetra
.879 .469 .034 r
.2208 .41495 .22928 .42705 .23954 .45448 .23085 .44373 Metetra
0 0 .535 r
.23085 .44373 .23954 .45448 .25147 .46544 .24261 .45649 Metetra
.707 .762 .895 r
.24261 .45649 .25147 .46544 .26514 .45686 .25617 .44981 Metetra
.905 .791 .724 r
.25617 .44981 .26514 .45686 .28026 .42947 .27127 .42403 Metetra
.942 .78 .653 r
.27127 .42403 .28026 .42947 .29629 .38765 .28739 .38322 Metetra
.953 .775 .624 r
.28739 .38322 .29629 .38765 .31259 .33821 .30385 .33406 Metetra
.956 .776 .619 r
.30385 .33406 .31259 .33821 .32859 .28886 .32007 .28424 Metetra
.953 .783 .635 r
.32007 .28424 .32859 .28886 .34387 .24669 .33557 .24097 Metetra
.935 .797 .684 r
.33557 .24097 .34387 .24669 .3582 .21721 .35011 .20997 Metetra
.855 .81 .805 r
.35011 .20997 .3582 .21721 .37157 .20386 .36364 .19489 Metetra
.316 .583 .938 r
.36364 .19489 .37157 .20386 .38413 .20782 .37629 .19713 Metetra
.65 .202 0 r
.37629 .19713 .38413 .20782 .39614 .22795 .38833 .21578 Metetra
.85 .442 0 r
.38833 .21578 .39614 .22795 .40795 .26084 .4001 .24765 Metetra
.888 .5 .047 r
.4001 .24765 .40795 .26084 .4199 .30099 .41197 .28741 Metetra
.883 .495 .035 r
.41197 .28741 .4199 .30099 .4323 .34127 .42427 .32807 Metetra
.827 .423 0 r
.42427 .32807 .4323 .34127 .44537 .37391 .43723 .36182 Metetra
0 0 .416 r
.43723 .36182 .44537 .37391 .45913 .39195 .45092 .38154 Metetra
.423 .624 .936 r
.45092 .38154 .45913 .39195 .47348 .39088 .46527 .38242 Metetra
.879 .812 .779 r
.46527 .38242 .47348 .39088 .48817 .36991 .48002 .36323 Metetra
.954 .804 .658 r
.48002 .36323 .48817 .36991 .5029 .33212 .49489 .32674 Metetra
.972 .795 .604 r
.49489 .32674 .5029 .33212 .51744 .2837 .50961 .2789 Metetra
.978 .792 .586 r
.50961 .2789 .51744 .2837 .53165 .23234 .524 .22735 Metetra
.977 .797 .595 r
.524 .22735 .53165 .23234 .54553 .18563 .53805 .17975 Metetra
.966 .811 .638 r
.53805 .17975 .54553 .18563 .55923 .14985 .55187 .14257 Metetra
.918 .83 .742 r
.55187 .14257 .55923 .14985 .57295 .12932 .56567 .12034 Metetra
.654 .757 .925 r
.56567 .12034 .57295 .12932 .58697 .12611 .5797 .11535 Metetra
0 .182 .711 r
.5797 .11535 .58697 .12611 .60151 .13999 .5942 .12761 Metetra
.643 .236 0 r
.5942 .12761 .60151 .13999 .61677 .16844 .60938 .1548 Metetra
.752 .361 0 r
.60938 .1548 .61677 .16844 .63277 .2067 .62529 .19238 Metetra
.766 .381 0 r
.62529 .19238 .63277 .2067 .64941 .24812 .64186 .23386 Metetra
.715 .327 0 r
.64186 .23386 .64941 .24812 .66639 .28494 .65881 .2715 Metetra
0 0 .438 r
.65881 .2715 .66639 .28494 .68325 .30951 .67572 .29758 Metetra
.098 .389 .847 r
.67572 .29758 .68325 .30951 .6995 .31607 .6921 .30604 Metetra
.794 .806 .862 r
.6921 .30604 .6995 .31607 .71471 .3022 .70751 .2941 Metetra
.957 .833 .679 r
.70751 .2941 .71471 .3022 .72869 .26957 .72171 .26302 Metetra
.988 .816 .582 r
.72171 .26302 .72869 .26957 .74151 .22341 .73477 .21774 Metetra
.853 .754 .753 r
.04017 .51442 .04958 .52308 .06335 .50914 .0548 .49473 Metetra
.866 .694 .666 r
.0548 .49473 .06335 .50914 .07948 .47761 .07165 .4587 Metetra
.865 .67 .638 r
.07165 .4587 .07948 .47761 .09711 .43365 .08972 .41222 Metetra
.86 .659 .629 r
.08972 .41222 .09711 .43365 .11518 .38437 .10795 .36274 Metetra
.853 .655 .634 r
.10795 .36274 .11518 .38437 .13271 .33732 .12534 .31764 Metetra
.839 .656 .654 r
.12534 .31764 .13271 .33732 .14892 .29913 .14118 .28311 Metetra
.804 .664 .708 r
.14118 .28311 .14892 .29913 .16332 .2747 .15508 .26343 Metetra
.599 .654 .875 r
.15508 .26343 .16332 .2747 .17576 .26679 .16695 .26069 Metetra
.754 .245 0 r
.16695 .26069 .17576 .26679 .18638 .2759 .17701 .27468 Metetra
.884 .486 .268 r
.17701 .27468 .18638 .2759 .19555 .30022 .18572 .30292 Metetra
.885 .52 .348 r
.18572 .30292 .19555 .30022 .20385 .33573 .19374 .34073 Metetra
.878 .52 .364 r
.19374 .34073 .20385 .33573 .21202 .37642 .20183 .38162 Metetra
.867 .497 .344 r
.20183 .38162 .21202 .37642 .2208 .41495 .21078 .41801 Metetra
.835 .42 .252 r
.21078 .41801 .2208 .41495 .23085 .44373 .22121 .44253 Metetra
.521 0 0 r
.22121 .44253 .23085 .44373 .24261 .45649 .23349 .44959 Metetra
.825 .821 .845 r
.23349 .44959 .24261 .45649 .25617 .44981 .24761 .43686 Metetra
.879 .722 .683 r
.24761 .43686 .25617 .44981 .27127 .42403 .26321 .40589 Metetra
.88 .686 .635 r
.26321 .40589 .27127 .42403 .28739 .38322 .27969 .36167 Metetra
.877 .67 .619 r
.27969 .36167 .28739 .38322 .30385 .33406 .29636 .31138 Metetra
.87 .662 .619 r
.29636 .31138 .30385 .33406 .32007 .28424 .3126 .26273 Metetra
.858 .661 .634 r
.3126 .26273 .32007 .28424 .33557 .24097 .32799 .22257 Metetra
.832 .666 .677 r
.32799 .22257 .33557 .24097 .35011 .20997 .34233 .19604 Metetra
.736 .673 .789 r
.34233 .19604 .35011 .20997 .36364 .19489 .35562 .18611 Metetra
0 .31 .79 r
.35562 .18611 .36364 .19489 .37629 .19713 .36802 .19349 Metetra
.845 .381 .052 r
.36802 .19349 .37629 .19713 .38833 .21578 .37985 .21657 Metetra
.886 .479 .237 r
.37985 .21657 .38833 .21578 .4001 .24765 .39147 .25149 Metetra
.886 .495 .284 r
.39147 .25149 .4001 .24765 .41197 .28741 .40327 .29235 Metetra
.876 .48 .279 r
.40327 .29235 .41197 .28741 .42427 .32807 .41559 .33177 Metetra
.849 .423 .215 r
.41559 .33177 .42427 .32807 .43723 .36182 .42865 .36198 Metetra
.711 .181 0 r
.42865 .36198 .43723 .36182 .45092 .38154 .44251 .37636 Metetra
.634 .864 .985 r
.44251 .37636 .45092 .38154 .46527 .38242 .45703 .37107 Metetra
.887 .764 .721 r
.45703 .37107 .46527 .38242 .48002 .36323 .47196 .34612 Metetra
.898 .708 .637 r
.47196 .34612 .48002 .36323 .49489 .32674 .48698 .30536 Metetra
.896 .683 .607 r
.48698 .30536 .49489 .32674 .50961 .2789 .50181 .25545 Metetra
.89 .672 .601 r
.50181 .25545 .50961 .2789 .524 .22735 .5163 .20422 Metetra
.879 .668 .612 r
.5163 .20422 .524 .22735 .53805 .17975 .53045 .15907 Metetra
.858 .67 .647 r
.53045 .15907 .53805 .17975 .55187 .14257 .54437 .12596 Metetra
.798 .678 .732 r
.54437 .12596 .55187 .14257 .56567 .12034 .55828 .10875 Metetra
.471 .608 .906 r
.55828 .10875 .56567 .12034 .5797 .11535 .57244 .10905 Metetra
.623 .112 0 r
.57244 .10905 .5797 .11535 .5942 .12761 .58707 .12615 Metetra
.85 .39 .049 r
.58707 .12615 .5942 .12761 .60938 .1548 .60235 .15705 Metetra
.877 .444 .158 r
.60235 .15705 .60938 .1548 .62529 .19238 .61834 .19659 Metetra
.873 .444 .178 r
.61834 .19659 .62529 .19238 .64186 .23386 .63492 .23777 Metetra
.85 .401 .136 r
.63492 .23777 .64186 .23386 .65881 .2715 .65178 .27271 Metetra
.759 .245 0 r
.65178 .27271 .65881 .2715 .67572 .29758 .66852 .29398 Metetra
.052 .58 .865 r
.66852 .29398 .67572 .29758 .6921 .30604 .68464 .29636 Metetra
.873 .826 .798 r
.68464 .29636 .6921 .30604 .70751 .2941 .69978 .27824 Metetra
.917 .739 .647 r
.69978 .27824 .70751 .2941 .72171 .26302 .71377 .24211 Metetra
.917 .701 .595 r
.71377 .24211 .72171 .26302 .73477 .21774 .72671 .19381 Metetra
.846 .681 .678 r
.03173 .49857 .04017 .51442 .0548 .49473 .04805 .4676 Metetra
.827 .628 .633 r
.04805 .4676 .0548 .49473 .07165 .4587 .06604 .42387 Metetra
.814 .604 .618 r
.06604 .42387 .07165 .4587 .08972 .41222 .08458 .37448 Metetra
.802 .59 .615 r
.08458 .37448 .08972 .41222 .10795 .36274 .1026 .327 Metetra
.787 .582 .623 r
.1026 .327 .10795 .36274 .12534 .31764 .11923 .28815 Metetra
.76 .578 .65 r
.11923 .28815 .12534 .31764 .14118 .28311 .13394 .26292 Metetra
.681 .575 .73 r
.13394 .26292 .14118 .28311 .15508 .26343 .14652 .25417 Metetra
0 .166 .676 r
.14652 .25417 .15508 .26343 .16695 .26069 .15709 .26251 Metetra
.847 .44 .268 r
.15709 .26251 .16695 .26069 .17701 .27468 .16604 .28623 Metetra
.831 .477 .385 r
.16604 .28623 .17701 .27468 .18572 .30292 .17398 .32139 Metetra
.815 .475 .413 r
.17398 .32139 .18572 .30292 .19374 .34073 .1817 .36206 Metetra
.797 .457 .412 r
.1817 .36206 .19374 .34073 .20183 .38162 .19001 .40092 Metetra
.769 .413 .381 r
.19001 .40092 .20183 .38162 .21078 .41801 .19967 .43033 Metetra
.687 .272 .254 r
.19967 .43033 .21078 .41801 .22121 .44253 .21118 .44391 Metetra
.486 .901 .867 r
.21118 .44391 .22121 .44253 .23349 .44959 .22469 .43805 Metetra
.869 .737 .715 r
.22469 .43805 .23349 .44959 .24761 .43686 .23995 .41293 Metetra
.845 .649 .637 r
.23995 .41293 .24761 .43686 .26321 .40589 .2564 .3725 Metetra
.828 .614 .612 r
.2564 .3725 .26321 .40589 .27969 .36167 .27333 .32335 Metetra
.815 .595 .605 r
.27333 .32335 .27969 .36167 .29636 .31138 .29003 .27321 Metetra
.8 .584 .61 r
.29003 .27321 .29636 .31138 .3126 .26273 .30597 .22936 Metetra
.778 .578 .63 r
.30597 .22936 .3126 .26273 .32799 .22257 .32084 .19759 Metetra
.728 .577 .685 r
.32084 .19759 .32799 .22257 .34233 .19604 .33454 .18166 Metetra
.449 .531 .849 r
.33454 .18166 .34233 .19604 .35562 .18611 .34718 .18307 Metetra
.794 .298 0 r
.34718 .18307 .35562 .18611 .36802 .19349 .35904 .20102 Metetra
.84 .441 .29 r
.35904 .20102 .36802 .19349 .37985 .21657 .37047 .23241 Metetra
.825 .456 .355 r
.37047 .23241 .37985 .21657 .39147 .25149 .38191 .272 Metetra
.808 .445 .37 r
.38191 .272 .39147 .25149 .40327 .29235 .39375 .31284 Metetra
.783 .411 .353 r
.39375 .31284 .40327 .29235 .41559 .33177 .40632 .34711 Metetra
.727 .32 .277 r
.40632 .34711 .41559 .33177 .42865 .36198 .41976 .36759 Metetra
.352 0 0 r
.41976 .36759 .42865 .36198 .44251 .37636 .43404 .36931 Metetra
.885 .841 .796 r
.43404 .36931 .44251 .37636 .45703 .37107 .44894 .35088 Metetra
.867 .681 .649 r
.44894 .35088 .45703 .37107 .47196 .34612 .46413 .3149 Metetra
.846 .628 .607 r
.46413 .3149 .47196 .34612 .48698 .30536 .47929 .26722 Metetra
.83 .602 .594 r
.47929 .26722 .48698 .30536 .50181 .25545 .49417 .21547 Metetra
.814 .588 .595 r
.49417 .21547 .50181 .25545 .5163 .20422 .50868 .16737 Metetra
.794 .58 .611 r
.50868 .16737 .5163 .20422 .53045 .15907 .52284 .12947 Metetra
.757 .577 .653 r
.52284 .12947 .53045 .15907 .54437 .12596 .53683 .10639 Metetra
.635 .571 .765 r
.53683 .10639 .54437 .12596 .55828 .10875 .55087 .10054 Metetra
0 .151 .657 r
.55087 .10054 .55828 .10875 .57244 .10905 .56522 .11201 Metetra
.825 .361 .11 r
.56522 .11201 .57244 .10905 .58707 .12615 .58008 .1386 Metetra
.831 .42 .264 r
.58008 .1386 .58707 .12615 .60235 .15705 .59559 .17586 Metetra
.816 .422 .305 r
.59559 .17586 .60235 .15705 .61834 .19659 .61173 .21736 Metetra
.793 .398 .305 r
.61173 .21736 .61834 .19659 .63492 .23777 .6283 .25538 Metetra
.749 .332 .258 r
.6283 .25538 .63492 .23777 .65178 .27271 .64495 .28214 Metetra
.586 .089 .04 r
.64495 .28214 .65178 .27271 .66852 .29398 .66126 .29144 Metetra
.768 .977 .916 r
.66126 .29144 .66852 .29398 .68464 .29636 .67681 .28032 Metetra
.894 .735 .677 r
.67681 .28032 .68464 .29636 .69978 .27824 .69134 .24986 Metetra
.868 .649 .604 r
.69134 .24986 .69978 .27824 .71377 .24211 .70484 .20488 Metetra
.848 .612 .581 r
.70484 .20488 .71377 .24211 .72671 .19381 .71754 .15268 Metetra
.811 .609 .63 r
.02556 .46741 .03173 .49857 .04805 .4676 .04366 .42463 Metetra
.791 .576 .611 r
.04366 .42463 .04805 .4676 .06604 .42387 .06248 .37541 Metetra
.774 .557 .605 r
.06248 .37541 .06604 .42387 .08458 .37448 .08087 .32733 Metetra
.757 .544 .609 r
.08087 .32733 .08458 .37448 .1026 .327 .09789 .28727 Metetra
.73 .535 .627 r
.09789 .28727 .1026 .327 .11923 .28815 .11294 .26041 Metetra
.667 .524 .68 r
.11294 .26041 .11923 .28815 .13394 .26292 .12576 .24987 Metetra
.08 .334 .81 r
.12576 .24987 .13394 .26292 .14652 .25417 .13643 .25646 Metetra
.836 .426 .264 r
.13643 .25646 .14652 .25417 .15709 .26251 .14532 .27873 Metetra
.805 .458 .399 r
.14532 .27873 .15709 .26251 .16604 .28623 .15306 .31296 Metetra
.782 .452 .43 r
.15306 .31296 .16604 .28623 .17398 .32139 .16043 .35341 Metetra
.76 .433 .432 r
.16043 .35341 .17398 .32139 .1817 .36206 .16833 .39284 Metetra
.73 .395 .412 r
.16833 .39284 .1817 .36206 .19001 .40092 .17756 .42358 Metetra
.663 .295 .338 r
.17756 .42358 .19001 .40092 .19967 .43033 .18871 .43902 Metetra
.109 0 0 r
.18871 .43902 .19967 .43033 .21118 .44391 .20199 .43521 Metetra
.882 .774 .737 r
.20199 .43521 .21118 .44391 .22469 .43805 .2172 .41193 Metetra
.831 .635 .637 r
.2172 .41193 .22469 .43805 .23995 .41293 .23377 .37275 Metetra
.805 .587 .607 r
.23377 .37275 .23995 .41293 .2564 .3725 .25095 .32409 Metetra
.786 .562 .597 r
.25095 .32409 .2564 .3725 .27333 .32335 .268 .27363 Metetra
.768 .546 .598 r
.268 .27363 .27333 .32335 .29003 .27321 .28429 .22876 Metetra
.745 .535 .611 r
.28429 .22876 .29003 .27321 .30597 .22936 .29945 .19548 Metetra
.701 .527 .649 r
.29945 .19548 .30597 .22936 .32084 .19759 .31333 .17777 Metetra
.524 .498 .77 r
.31333 .17777 .32084 .19759 .33454 .18166 .32602 .17736 Metetra
.763 .252 0 r
.32602 .17736 .33454 .18166 .34718 .18307 .33778 .19369 Metetra
.818 .426 .311 r
.33778 .19369 .34718 .18307 .35904 .20102 .34898 .2239 Metetra
.792 .435 .381 r
.34898 .2239 .35904 .20102 .37047 .23241 .36008 .26296 Metetra
.769 .423 .398 r
.36008 .26296 .37047 .23241 .38191 .272 .37154 .30404 Metetra
.742 .393 .39 r
.37154 .30404 .38191 .272 .39375 .31284 .38372 .33937 Metetra
.692 .324 .345 r
.38372 .33937 .39375 .31284 .40632 .34711 .39686 .36157 Metetra
.496 .054 .129 r
.39686 .36157 .40632 .34711 .41976 .36759 .41098 .36535 Metetra
.892 .943 .837 r
.41098 .36535 .41976 .36759 .43404 .36931 .42589 .34892 Metetra
.86 .678 .654 r
.42589 .34892 .43404 .36931 .44894 .35088 .44125 .31447 Metetra
.823 .603 .604 r
.44125 .31447 .44894 .35088 .46413 .3149 .45669 .2676 Metetra
.799 .568 .588 r
.45669 .2676 .46413 .3149 .47929 .26722 .47191 .21583 Metetra
.78 .549 .586 r
.47191 .21583 .47929 .26722 .49417 .21547 .48673 .16696 Metetra
.758 .536 .595 r
.48673 .16696 .49417 .21547 .50868 .16737 .50114 .1277 Metetra
.724 .527 .624 r
.50114 .1277 .50868 .16737 .52284 .12947 .51525 .1029 Metetra
.634 .518 .703 r
.51525 .1029 .52284 .12947 .53683 .10639 .52927 .09519 Metetra
0 .279 .782 r
.52927 .09519 .53683 .10639 .55087 .10054 .54346 .10491 Metetra
.812 .35 .131 r
.54346 .10491 .55087 .10054 .56522 .11201 .55803 .1301 Metetra
.801 .405 .303 r
.55803 .1301 .56522 .11201 .58008 .1386 .57317 .16652 Metetra
.778 .404 .347 r
.57317 .16652 .58008 .1386 .59559 .17586 .5889 .20794 Metetra
.752 .382 .354 r
.5889 .20794 .59559 .17586 .61173 .21736 .60512 .24671 Metetra
.711 .331 .329 r
.60512 .24671 .61173 .21736 .6283 .25538 .62153 .27496 Metetra
.603 .184 .22 r
.62153 .27496 .6283 .25538 .64495 .28214 .63776 .28627 Metetra
.353 .789 .613 r
.63776 .28627 .64495 .28214 .66126 .29144 .65341 .27726 Metetra
.9 .756 .693 r
.65341 .27726 .66126 .29144 .67681 .28032 .66819 .24858 Metetra
.847 .628 .605 r
.66819 .24858 .67681 .28032 .69134 .24986 .68204 .20474 Metetra
.817 .578 .578 r
.68204 .20474 .69134 .24986 .70484 .20488 .69511 .15284 Metetra
.794 .552 .571 r
.69511 .15284 .70484 .20488 .71754 .15268 .70777 .10091 Metetra
.782 .567 .608 r
.02178 .42123 .02556 .46741 .04366 .42463 .04088 .37197 Metetra
.764 .546 .602 r
.04088 .37197 .04366 .42463 .06248 .37541 .05956 .3238 Metetra
.746 .532 .604 r
.05956 .3238 .06248 .37541 .08087 .32733 .07682 .28361 Metetra
.719 .52 .62 r
.07682 .28361 .08087 .32733 .09789 .28727 .09202 .2566 Metetra
.657 .506 .667 r
.09202 .2566 .09789 .28727 .11294 .26041 .10487 .2459 Metetra
.137 .339 .801 r
.10487 .2459 .11294 .26041 .12576 .24987 .11546 .25236 Metetra
.834 .426 .269 r
.11546 .25236 .12576 .24987 .13643 .25646 .12414 .27452 Metetra
.796 .452 .405 r
.12414 .27452 .13643 .25646 .14532 .27873 .13158 .30869 Metetra
.77 .444 .435 r
.13158 .30869 .14532 .27873 .15306 .31296 .13861 .34914 Metetra
.747 .425 .437 r
.13861 .34914 .15306 .31296 .16043 .35341 .14616 .38862 Metetra
.717 .387 .419 r
.14616 .38862 .16043 .35341 .16833 .39284 .1551 .41947 Metetra
.65 .293 .353 r
.1551 .41947 .16833 .39284 .17756 .42358 .16605 .43505 Metetra
.196 0 0 r
.16605 .43505 .17756 .42358 .18871 .43902 .17928 .43137 Metetra
.889 .787 .742 r
.17928 .43137 .18871 .43902 .20199 .43521 .19458 .40819 Metetra
.827 .63 .636 r
.19458 .40819 .20199 .43521 .2172 .41193 .21136 .36906 Metetra
.797 .578 .605 r
.21136 .36906 .2172 .41193 .23377 .37275 .22884 .32038 Metetra
.776 .551 .594 r
.22884 .32038 .23377 .37275 .25095 .32409 .24618 .26985 Metetra
.756 .533 .594 r
.24618 .26985 .25095 .32409 .268 .27363 .26275 .22486 Metetra
.733 .521 .605 r
.26275 .22486 .268 .27363 .28429 .22876 .27809 .19143 Metetra
.69 .51 .639 r
.27809 .19143 .28429 .22876 .29945 .19548 .29206 .17356 Metetra
.527 .48 .747 r
.29206 .17356 .29945 .19548 .31333 .17777 .3047 .173 Metetra
.76 .25 0 r
.3047 .173 .31333 .17777 .32602 .17736 .31628 .18921 Metetra
.81 .423 .32 r
.31628 .18921 .32602 .17736 .33778 .19369 .32721 .21933 Metetra
.781 .429 .389 r
.32721 .21933 .33778 .19369 .34898 .2239 .33796 .25836 Metetra
.756 .415 .406 r
.33796 .25836 .34898 .2239 .36008 .26296 .34905 .29947 Metetra
.728 .385 .399 r
.34905 .29947 .36008 .26296 .37154 .30404 .3609 .33488 Metetra
.678 .32 .36 r
.3609 .33488 .37154 .30404 .38372 .33937 .37381 .35721 Metetra
.503 .085 .18 r
.37381 .35721 .38372 .33937 .39686 .36157 .38783 .36113 Metetra
.886 .972 .833 r
.38783 .36113 .39686 .36157 .41098 .36535 .40278 .34481 Metetra
.859 .677 .655 r
.40278 .34481 .41098 .36535 .42589 .34892 .41833 .31043 Metetra
.815 .594 .603 r
.41833 .31043 .42589 .34892 .44125 .31447 .43405 .26357 Metetra
.789 .557 .585 r
.43405 .26357 .44125 .31447 .45669 .2676 .44958 .21175 Metetra
.768 .535 .582 r
.44958 .21175 .45669 .2676 .47191 .21583 .46471 .16278 Metetra
.745 .521 .591 r
.46471 .16278 .47191 .21583 .48673 .16696 .47934 .12338 Metetra
.711 .511 .616 r
.47934 .12338 .48673 .16696 .50114 .1277 .49358 .09841 Metetra
.627 .499 .687 r
.49358 .09841 .50114 .1277 .51525 .1029 .50759 .09054 Metetra
0 .289 .788 r
.50759 .09054 .51525 .1029 .52927 .09519 .52164 .10012 Metetra
.81 .352 .144 r
.52164 .10012 .52927 .09519 .54346 .10491 .53596 .1252 Metetra
.791 .401 .316 r
.53596 .1252 .54346 .10491 .55803 .1301 .55075 .16157 Metetra
.765 .397 .359 r
.55075 .16157 .55803 .1301 .57317 .16652 .56611 .20298 Metetra
.737 .375 .366 r
.56611 .20298 .57317 .16652 .5889 .20794 .58196 .24181 Metetra
.696 .327 .345 r
.58196 .24181 .5889 .20794 .60512 .24671 .5981 .27018 Metetra
.595 .195 .253 r
.5981 .27018 .60512 .24671 .62153 .27496 .61417 .28162 Metetra
.61417 .28162 .62153 .27496 .63776 .28627 .62983 .27274 Metetra
.904 .764 .696 r
.62983 .27274 .63776 .28627 .65341 .27726 .64476 .24415 Metetra
.84 .62 .604 r
.64476 .24415 .65341 .27726 .66819 .24858 .65887 .20034 Metetra
.806 .566 .576 r
.65887 .20034 .66819 .24858 .68204 .20474 .67227 .14842 Metetra
.781 .538 .569 r
.67227 .14842 .68204 .20474 .69511 .15284 .68525 .09639 Metetra
.757 .521 .575 r
.68525 .09639 .69511 .15284 .70777 .10091 .69827 .05163 Metetra
.772 .555 .604 r
.01871 .37156 .02178 .42123 .04088 .37197 .03773 .323 Metetra
.755 .541 .607 r
.03773 .323 .04088 .37197 .05956 .3238 .05535 .28196 Metetra
.73 .531 .622 r
.05535 .28196 .05956 .3238 .07682 .28361 .07086 .25379 Metetra
.672 .519 .669 r
.07086 .25379 .07682 .28361 .09202 .2566 .08392 .24179 Metetra
.227 .391 .818 r
.08392 .24179 .09202 .2566 .10487 .2459 .09457 .24698 Metetra
.838 .42 .244 r
.09457 .24698 .10487 .2459 .11546 .25236 .10318 .26807 Metetra
.804 .456 .398 r
.10318 .26807 .11546 .25236 .12414 .27452 .1104 .30154 Metetra
.78 .451 .431 r
.1104 .30154 .12414 .27452 .13158 .30869 .1171 .34177 Metetra
.758 .432 .434 r
.1171 .34177 .13158 .30869 .13861 .34914 .12424 .38161 Metetra
.729 .396 .417 r
.12424 .38161 .13861 .34914 .14616 .38862 .13277 .41337 Metetra
.667 .306 .351 r
.13277 .41337 .14616 .38862 .1551 .41947 .1434 .43027 Metetra
.254 0 0 r
.1434 .43027 .1551 .41947 .16605 .43505 .15641 .42807 Metetra
.888 .799 .755 r
.15641 .42807 .16605 .43505 .17928 .43137 .17167 .40622 Metetra
.832 .639 .641 r
.17167 .40622 .17928 .43137 .19458 .40819 .18858 .36802 Metetra
.804 .587 .608 r
.18858 .36802 .19458 .40819 .21136 .36906 .20631 .31973 Metetra
.784 .56 .596 r
.20631 .31973 .21136 .36906 .22884 .32038 .22399 .26901 Metetra
.766 .543 .596 r
.22399 .26901 .22884 .32038 .24618 .26985 .24089 .22332 Metetra
.743 .531 .607 r
.24089 .22332 .24618 .26985 .26275 .22486 .25652 .18882 Metetra
.703 .522 .641 r
.25652 .18882 .26275 .22486 .27809 .19143 .27066 .16967 Metetra
.554 .498 .747 r
.27066 .16967 .27809 .19143 .29206 .17356 .28335 .16779 Metetra
.724 .206 0 r
.28335 .16779 .29206 .17356 .3047 .173 .29484 .18281 Metetra
.818 .424 .305 r
.29484 .18281 .3047 .173 .31628 .18921 .30554 .21204 Metetra
.791 .434 .382 r
.30554 .21204 .31628 .18921 .32721 .21933 .31596 .25064 Metetra
.767 .422 .4 r
.31596 .25064 .32721 .21933 .33796 .25836 .32665 .29187 Metetra
.74 .393 .394 r
.32665 .29187 .33796 .25836 .34905 .29947 .33812 .32799 Metetra
.693 .33 .354 r
.33812 .32799 .34905 .29947 .3609 .33488 .35072 .35152 Metetra
.529 .102 .175 r
.35072 .35152 .3609 .33488 .37381 .35721 .36456 .35691 Metetra
.862 .98 .853 r
.36456 .35691 .37381 .35721 .38783 .36113 .3795 .34204 Metetra
.863 .687 .662 r
.3795 .34204 .38783 .36113 .40278 .34481 .39519 .3088 Metetra
.822 .604 .607 r
.39519 .3088 .40278 .34481 .41833 .31043 .41119 .26256 Metetra
.798 .567 .588 r
.41119 .26256 .41833 .31043 .43405 .26357 .42706 .21077 Metetra
.778 .546 .584 r
.42706 .21077 .43405 .26357 .44958 .21175 .44251 .16127 Metetra
.756 .532 .592 r
.44251 .16127 .44958 .21175 .46471 .16278 .45741 .12091 Metetra
.723 .522 .618 r
.45741 .12091 .46471 .16278 .47934 .12338 .47179 .09471 Metetra
.644 .513 .689 r
.47179 .09471 .47934 .12338 .49358 .09841 .48582 .0855 Metetra
.068 .338 .815 r
.48582 .0855 .49358 .09841 .50759 .09054 .49974 .0938 Metetra
.81 .342 .111 r
.49974 .0938 .50759 .09054 .52164 .10012 .5138 .11783 Metetra
.8 .404 .303 r
.5138 .11783 .52164 .10012 .53596 .1252 .52824 .15355 Metetra
.776 .403 .35 r
.52824 .15355 .53596 .1252 .55075 .16157 .54319 .19485 Metetra
.749 .382 .358 r
.54319 .19485 .55075 .16157 .56611 .20298 .55867 .23416 Metetra
.71 .335 .336 r
.55867 .23416 .56611 .20298 .58196 .24181 .57452 .26357 Metetra
.614 .204 .243 r
.57452 .26357 .58196 .24181 .5981 .27018 .59047 .27642 Metetra
.59047 .27642 .5981 .27018 .61417 .28162 .60615 .26906 Metetra
.906 .777 .708 r
.60615 .26906 .61417 .28162 .62983 .27274 .62128 .24177 Metetra
.847 .631 .609 r
.62128 .24177 .62983 .27274 .64476 .24415 .6357 .19881 Metetra
.815 .577 .579 r
.6357 .19881 .64476 .24415 .65887 .20034 .64945 .14715 Metetra
.791 .549 .571 r
.64945 .14715 .65887 .20034 .67227 .14842 .66277 .09481 Metetra
.769 .532 .576 r
.66277 .09481 .67227 .14842 .68525 .09639 .67603 .04922 Metetra
.74 .521 .597 r
.67603 .04922 .68525 .09639 .69827 .05163 .68968 .01625 Metetra
.4 g
.25 Mabswid
.68874 0 m
.70298 .24544 L
s
.7708 .12553 m
.79088 .36619 L
s
.84407 .23761 m
.86863 .47301 L
s
.9099 .3383 m
.9379 .56818 L
s
.96935 .42924 m
1 .6535 L
s
.68905 .00539 m
.97003 .43424 L
s
.69224 .06041 m
.97699 .48513 L
s
.69556 .11761 m
.98416 .53763 L
s
.69902 .17712 m
.99157 .59183 L
s
.70262 .2391 m
.99922 .6478 L
s
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.4 g
.03634 .26033 m
.68905 .00539 L
s
.02795 .31328 m
.69224 .06041 L
s
.01926 .36808 m
.69556 .11761 L
s
.01027 .42483 m
.69902 .17712 L
s
.00095 .48363 m
.70262 .2391 L
s
.03716 .25514 m
0 .48963 L
s
.18558 .19702 m
.15891 .43443 L
s
.34306 .13535 m
.3283 .37559 L
s
.51046 .06981 m
.50925 .31274 L
s
.68874 0 m
.70298 .24544 L
s
0 g
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.4 g
0 .48963 m
.39787 .81114 L
s
.15891 .43443 m
.53673 .77478 L
s
.3283 .37559 m
.68296 .7365 L
s
.50925 .31274 m
.83716 .69613 L
s
.70298 .24544 m
1 .6535 L
s
0 .48963 m
.70298 .24544 L
s
.1156 .58304 m
.79088 .36619 L
s
.21934 .66687 m
.86863 .47301 L
s
.31296 .74252 m
.9379 .56818 L
s
.39787 .81114 m
1 .6535 L
s
0 g
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-10)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-5)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(5)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(10)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -87.0713 -14.125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 18.125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Time) show
87.000 11.562 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.9.6"]
}, Open  ]],

Cell[TextData[{
  "Probably the single most important issue in plotting a \
three\[Hyphen]dimensional surface is specifying where you want to look at the \
surface from. The ",
  StyleBox["ViewPoint", "MR"],
  " option for ",
  StyleBox["Plot3D", "MR"],
  " and ",
  StyleBox["Show", "MR"],
  " allows you to specify the point ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["}", "MR"],
  " in space from which you view a surface. The details of how the \
coordinates for this point are defined will be discussed in Section ",
  ButtonBox["2.10.10",
    ButtonData:>{"2.10.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  ". In many versions of ",
  StyleBox["Mathematica", "TI"],
  ", there are ways to choose three\[Hyphen]dimensional view points \
interactively, then get the coordinates to give as settings for the ",
  StyleBox["ViewPoint", "MR"],
  " option. "
}], "Text",
  CellTags->{"S1.9.6", "6.8"}],

Cell[TextData[{
  "Here is a surface, viewed from the default view point ",
  StyleBox["{1.3,", "MR"],
  " ",
  StyleBox["-2.4,", "MR"],
  " ",
  StyleBox["2}", "MR"],
  ". This view point is chosen to be \[OpenCurlyDoubleQuote]generic\
\[CloseCurlyDoubleQuote], so that visually confusing coincidental alignments \
between different parts of your object are unlikely. "
}], "MathCaption",
  CellTags->{"S1.9.6", "6.9"}],

Cell[CellGroupData[{

Cell["Plot3D[Sin[x y], {x, 0, 3}, {y, 0, 3}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.00289e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.22808 .16727 -5.79519 -9 ]
[.22808 .16727 .20481 0 ]
[.44535 .08183 -5.37821 -9 ]
[.44535 .08183 .62179 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.80849 .15988 0 -6.10118 ]
[.80849 .15988 6 2.89882 ]
[.90119 .30183 0 -5.96721 ]
[.90119 .30183 6 3.03279 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02412 .26508 -12 -2.74229 ]
[.02412 .26508 0 6.25771 ]
[.01569 .31793 -24 -2.78697 ]
[.01569 .31793 0 6.21303 ]
[.00696 .37262 -6 -2.83338 ]
[.00696 .37262 0 6.16662 ]
[-0.00208 .42926 -18 -2.8816 ]
[-0.00208 .42926 0 6.1184 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(2)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(3)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.79613 .16428 m
.78995 .16648 L
s
[(1)] .80849 .15988 -1 .35582 Mshowa
.88871 .30589 m
.88247 .30793 L
s
[(2)] .90119 .30183 -1 .32605 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(3)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.71157 .03492 m
.70789 .03634 L
s
.73369 .06877 m
.73001 .07015 L
s
.75514 .10158 m
.75145 .10294 L
s
.77594 .1334 m
.77224 .13474 L
s
.81573 .19425 m
.81201 .19555 L
s
.83476 .22337 m
.83104 .22465 L
s
.85326 .25166 m
.84953 .25292 L
s
.87123 .27915 m
.8675 .28039 L
s
.90572 .33191 m
.90197 .33311 L
s
.92227 .35722 m
.91851 .3584 L
s
.93838 .38186 m
.93462 .38303 L
s
.95406 .40586 m
.9503 .40701 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .2603 m
.04245 .25791 L
s
[(-1)] .02412 .26508 1 -0.3906 Mshowa
.02795 .31326 m
.03408 .31092 L
s
[(-0.5)] .01569 .31793 1 -0.38067 Mshowa
.01926 .36806 m
.02542 .36579 L
s
[(0)] .00696 .37262 1 -0.37036 Mshowa
.01027 .42482 m
.01644 .4226 L
s
[(0.5)] -0.00208 .42926 1 -0.35964 Mshowa
.00095 .48364 m
.00715 .48148 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03469 .27075 m
.03836 .26932 L
s
.03302 .28127 m
.03669 .27985 L
s
.03134 .29186 m
.03502 .29044 L
s
.02965 .30252 m
.03333 .30111 L
s
.02624 .32407 m
.02992 .32267 L
s
.02451 .33495 m
.0282 .33357 L
s
.02277 .34591 m
.02646 .34453 L
s
.02103 .35695 m
.02471 .35558 L
s
.01749 .37926 m
.02118 .3779 L
s
.0157 .39053 m
.0194 .38917 L
s
.01391 .40188 m
.01761 .40053 L
s
.01209 .41331 m
.0158 .41197 L
s
.00843 .43642 m
.01214 .43509 L
s
.00658 .44809 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.779 .289 0 r
.38853 .69035 .40169 .70184 .4226 .7331 .40946 .72017 Metetra
.648 .145 0 r
.40946 .72017 .4226 .7331 .44426 .75992 .43112 .7461 Metetra
0 .206 .707 r
.43112 .7461 .44426 .75992 .46667 .77729 .45355 .76366 Metetra
.338 .594 .94 r
.45355 .76366 .46667 .77729 .48971 .78143 .47664 .76934 Metetra
.678 .759 .912 r
.47664 .76934 .48971 .78143 .51313 .77058 .50018 .76129 Metetra
.825 .816 .841 r
.50018 .76129 .51313 .77058 .53664 .74539 .5239 .73966 Metetra
.897 .846 .786 r
.5239 .73966 .53664 .74539 .55998 .70879 .54755 .70663 Metetra
.936 .87 .748 r
.54755 .70663 .55998 .70879 .58301 .66536 .57095 .66594 Metetra
.955 .892 .727 r
.57095 .66594 .58301 .66536 .60571 .62048 .59402 .62222 Metetra
.958 .913 .728 r
.59402 .62222 .60571 .62048 .6282 .57941 .61684 .58025 Metetra
.943 .931 .76 r
.61684 .58025 .6282 .57941 .65072 .54663 .63957 .54433 Metetra
.896 .931 .832 r
.63957 .54433 .65072 .54663 .67358 .52537 .66248 .51783 Metetra
.778 .864 .913 r
.66248 .51783 .67358 .52537 .69713 .51739 .68587 .50297 Metetra
.58 .69 .917 r
.68587 .50297 .69713 .51739 .72166 .52288 .71006 .50062 Metetra
.401 .501 .846 r
.71006 .50062 .72166 .52288 .74737 .54044 .73529 .51035 Metetra
.305 .381 .777 r
.73529 .51035 .74737 .54044 .77434 .56715 .76171 .53038 Metetra
.273 .326 .736 r
.76171 .53038 .77434 .56715 .80242 .59873 .78933 .55768 Metetra
.281 .316 .72 r
.78933 .55768 .80242 .59873 .83129 .62995 .81798 .58815 Metetra
.312 .336 .725 r
.81798 .58815 .83129 .62995 .86041 .65524 .8473 .61702 Metetra
.365 .386 .749 r
.8473 .61702 .86041 .65524 .88913 .66958 .87677 .63936 Metetra
.446 .479 .8 r
.87677 .63936 .88913 .66958 .91682 .66943 .90578 .6509 Metetra
.581 .657 .89 r
.90578 .6509 .91682 .66943 .94298 .65357 .93374 .64878 Metetra
.76 .953 .938 r
.93374 .64878 .94298 .65357 .96742 .62328 .96022 .63209 Metetra
.96022 .63209 .96742 .62328 .99025 .58217 .98503 .60214 Metetra
.755 .257 0 r
.37518 .67869 .38853 .69035 .40946 .72017 .39612 .70705 Metetra
.62 .115 0 r
.39612 .70705 .40946 .72017 .43112 .7461 .41779 .73202 Metetra
0 .204 .707 r
.41779 .73202 .43112 .7461 .45355 .76366 .44024 .74962 Metetra
.287 .564 .932 r
.44024 .74962 .45355 .76366 .47664 .76934 .46337 .75664 Metetra
.632 .74 .926 r
.46337 .75664 .47664 .76934 .50018 .76129 .48701 .75118 Metetra
.796 .809 .862 r
.48701 .75118 .50018 .76129 .5239 .73966 .51092 .73302 Metetra
.879 .846 .807 r
.51092 .73302 .5239 .73966 .54755 .70663 .53484 .70367 Metetra
.926 .872 .766 r
.53484 .70367 .54755 .70663 .57095 .66594 .55859 .66609 Metetra
.95 .896 .739 r
.55859 .66609 .57095 .66594 .59402 .62222 .58205 .62419 Metetra
.957 .917 .729 r
.58205 .62419 .59402 .62222 .61684 .58025 .60523 .58219 Metetra
.949 .936 .745 r
.60523 .58219 .61684 .58025 .63957 .54433 .62823 .54412 Metetra
.92 .946 .798 r
.62823 .54412 .63957 .54433 .66248 .51783 .65128 .51336 Metetra
.849 .918 .879 r
.65128 .51336 .66248 .51783 .68587 .50297 .67463 .49238 Metetra
.701 .8 .927 r
.67463 .49238 .68587 .50297 .71006 .50062 .69858 .4826 Metetra
.518 .615 .889 r
.69858 .4826 .71006 .50062 .73529 .51035 .72339 .48432 Metetra
.387 .462 .816 r
.72339 .48432 .73529 .51035 .76171 .53038 .74927 .49672 Metetra
.323 .375 .76 r
.74927 .49672 .76171 .53038 .78933 .55768 .77634 .51787 Metetra
.306 .337 .73 r
.77634 .51787 .78933 .55768 .81798 .58815 .80455 .54483 Metetra
.316 .333 .719 r
.80455 .54483 .81798 .58815 .8473 .61702 .83372 .5738 Metetra
.345 .354 .726 r
.83372 .5738 .8473 .61702 .87677 .63936 .86349 .6005 Metetra
.391 .402 .751 r
.86349 .6005 .87677 .63936 .90578 .6509 .89336 .62063 Metetra
.464 .492 .803 r
.89336 .62063 .90578 .6509 .93374 .64878 .92275 .63051 Metetra
.586 .668 .896 r
.92275 .63051 .93374 .64878 .96022 .63209 .95114 .62769 Metetra
.739 .96 .941 r
.95114 .62769 .96022 .63209 .98503 .60214 .9781 .61144 Metetra
.726 .221 0 r
.36161 .66686 .37518 .67869 .39612 .70705 .38259 .69372 Metetra
.587 .082 0 r
.38259 .69372 .39612 .70705 .41779 .73202 .40428 .71766 Metetra
0 .208 .711 r
.40428 .71766 .41779 .73202 .44024 .74962 .42674 .73518 Metetra
.243 .535 .922 r
.42674 .73518 .44024 .74962 .46337 .75664 .4499 .74333 Metetra
.584 .718 .935 r
.4499 .74333 .46337 .75664 .48701 .75118 .47362 .74024 Metetra
.762 .798 .882 r
.47362 .74024 .48701 .75118 .51092 .73302 .49769 .72541 Metetra
.857 .842 .829 r
.49769 .72541 .51092 .73302 .53484 .70367 .52187 .69978 Metetra
.912 .874 .786 r
.52187 .69978 .53484 .70367 .55859 .66609 .54595 .66561 Metetra
.942 .899 .755 r
.54595 .66561 .55859 .66609 .58205 .62419 .56978 .62611 Metetra
.954 .921 .736 r
.56978 .62611 .58205 .62419 .60523 .58219 .59334 .58492 Metetra
.951 .94 .738 r
.59334 .58492 .60523 .58219 .62823 .54412 .61668 .54571 Metetra
.933 .954 .77 r
.61668 .54571 .62823 .54412 .65128 .51336 .63995 .51173 Metetra
.891 .95 .838 r
.63995 .51173 .65128 .51336 .67463 .49238 .66336 .48559 Metetra
.796 .887 .911 r
.66336 .48559 .67463 .49238 .69858 .4826 .68718 .46905 Metetra
.639 .736 .919 r
.68718 .46905 .69858 .4826 .72339 .48432 .71167 .46299 Metetra
.487 .565 .86 r
.71167 .46299 .72339 .48432 .74927 .49672 .73707 .46734 Metetra
.391 .444 .795 r
.73707 .46734 .74927 .49672 .77634 .51787 .76355 .48109 Metetra
.347 .377 .75 r
.76355 .48109 .77634 .51787 .80455 .54483 .7912 .50233 Metetra
.337 .349 .725 r
.7912 .50233 .80455 .54483 .83372 .5738 .81995 .52832 Metetra
.346 .347 .718 r
.81995 .52832 .83372 .5738 .86349 .6005 .84961 .55565 Metetra
.371 .367 .725 r
.84961 .55565 .86349 .6005 .89336 .62063 .87984 .58053 Metetra
.41 .411 .75 r
.87984 .58053 .89336 .62063 .92275 .63051 .91017 .59922 Metetra
.472 .494 .799 r
.91017 .59922 .92275 .63051 .95114 .62769 .94006 .60849 Metetra
.578 .658 .891 r
.94006 .60849 .95114 .62769 .9781 .61144 .96902 .60617 Metetra
.692 .18 0 r
.34784 .65483 .36161 .66686 .38259 .69372 .36886 .68018 Metetra
.549 .045 0 r
.36886 .68018 .38259 .69372 .40428 .71766 .39057 .70304 Metetra
0 .218 .719 r
.39057 .70304 .40428 .71766 .42674 .73518 .41305 .72032 Metetra
.206 .51 .911 r
.41305 .72032 .42674 .73518 .4499 .74333 .43624 .7294 Metetra
.535 .693 .94 r
.43624 .7294 .4499 .74333 .47362 .74024 .46003 .72845 Metetra
.723 .784 .9 r
.46003 .72845 .47362 .74024 .49769 .72541 .48423 .71676 Metetra
.83 .836 .852 r
.48423 .71676 .49769 .72541 .52187 .69978 .50862 .69482 Metetra
.894 .873 .809 r
.50862 .69482 .52187 .69978 .54595 .66561 .533 .66429 Metetra
.931 .902 .774 r
.533 .66429 .54595 .66561 .56978 .62611 .55721 .62768 Metetra
.948 .925 .749 r
.55721 .62768 .56978 .62611 .59334 .58492 .58116 .58808 Metetra
.95 .944 .738 r
.58116 .58808 .59334 .58492 .61668 .54571 .60487 .54871 Metetra
.938 .96 .751 r
.60487 .54871 .61668 .54571 .63995 .51173 .62843 .51261 Metetra
.912 .967 .799 r
.62843 .51261 .63995 .51173 .66336 .48559 .652 .48239 Metetra
.858 .944 .874 r
.652 .48239 .66336 .48559 .68718 .46905 .67581 .46002 Metetra
.748 .847 .924 r
.67581 .46002 .68718 .46905 .71167 .46299 .7001 .44676 Metetra
.6 .685 .901 r
.7001 .44676 .71167 .46299 .73707 .46734 .72511 .44312 Metetra
.478 .536 .838 r
.72511 .44312 .73707 .46734 .76355 .48109 .75106 .44882 Metetra
.406 .437 .78 r
.75106 .44882 .76355 .48109 .7912 .50233 .77808 .46284 Metetra
.373 .383 .742 r
.77808 .46284 .7912 .50233 .81995 .52832 .80625 .48338 Metetra
.364 .36 .722 r
.80625 .48338 .81995 .52832 .84961 .55565 .83549 .50799 Metetra
.372 .359 .715 r
.83549 .50799 .84961 .55565 .87984 .58053 .86562 .53367 Metetra
.392 .376 .722 r
.86562 .53367 .87984 .58053 .91017 .59922 .89633 .55712 Metetra
.424 .414 .745 r
.89633 .55712 .91017 .59922 .94006 .60849 .92718 .57507 Metetra
.475 .486 .79 r
.92718 .57507 .94006 .60849 .96902 .60617 .95769 .58466 Metetra
.652 .135 0 r
.33385 .64262 .34784 .65483 .36886 .68018 .35492 .66644 Metetra
.506 .003 0 r
.35492 .66644 .36886 .68018 .39057 .70304 .37667 .68814 Metetra
0 .232 .732 r
.37667 .68814 .39057 .70304 .41305 .72032 .39916 .70506 Metetra
.177 .49 .902 r
.39916 .70506 .41305 .72032 .43624 .7294 .42238 .71484 Metetra
.487 .666 .942 r
.42238 .71484 .43624 .7294 .46003 .72845 .44622 .71578 Metetra
.68 .765 .915 r
.44622 .71578 .46003 .72845 .48423 .71676 .47053 .70701 Metetra
.797 .825 .873 r
.47053 .70701 .48423 .71676 .50862 .69482 .49511 .68868 Metetra
.871 .869 .833 r
.49511 .68868 .50862 .69482 .533 .66429 .51976 .6619 Metetra
.916 .903 .797 r
.51976 .6619 .533 .66429 .55721 .62768 .54431 .6286 Metetra
.94 .93 .766 r
.54431 .6286 .55721 .62768 .58116 .58808 .56866 .59127 Metetra
.945 .949 .745 r
.56866 .59127 .58116 .58808 .60487 .54871 .59277 .55269 Metetra
.937 .964 .741 r
.59277 .55269 .60487 .54871 .62843 .51261 .61668 .51559 Metetra
.919 .975 .766 r
.61668 .51559 .62843 .51261 .652 .48239 .64051 .48245 Metetra
.889 .975 .827 r
.64051 .48245 .652 .48239 .67581 .46002 .66442 .45534 Metetra
.827 .931 .899 r
.66442 .45534 .67581 .46002 .7001 .44676 .68864 .43576 Metetra
.714 .811 .925 r
.68864 .43576 .7001 .44676 .72511 .44312 .71339 .42463 Metetra
.582 .652 .884 r
.71339 .42463 .72511 .44312 .75106 .44882 .73888 .42222 Metetra
.483 .522 .822 r
.73888 .42222 .75106 .44882 .77808 .46284 .76532 .4282 Metetra
.425 .439 .771 r
.76532 .4282 .77808 .46284 .80625 .48338 .79282 .44159 Metetra
.398 .392 .737 r
.79282 .44159 .80625 .48338 .83549 .50799 .82143 .46081 Metetra
.39 .372 .718 r
.82143 .46081 .83549 .50799 .86562 .53367 .85112 .48373 Metetra
.395 .369 .712 r
.85112 .48373 .86562 .53367 .89633 .55712 .8817 .50777 Metetra
.41 .382 .717 r
.8817 .50777 .89633 .55712 .92718 .57507 .9129 .5301 Metetra
.434 .413 .736 r
.9129 .5301 .92718 .57507 .95769 .58466 .94434 .54786 Metetra
.605 .083 0 r
.31964 .63022 .33385 .64262 .35492 .66644 .34077 .65248 Metetra
0 .042 .542 r
.34077 .65248 .35492 .66644 .37667 .68814 .36257 .67297 Metetra
0 .251 .748 r
.36257 .67297 .37667 .68814 .39916 .70506 .38508 .68939 Metetra
.158 .475 .895 r
.38508 .68939 .39916 .70506 .42238 .71484 .40832 .69967 Metetra
.443 .64 .94 r
.40832 .69967 .42238 .71484 .44622 .71578 .4322 .70222 Metetra
.635 .742 .926 r
.4322 .70222 .44622 .71578 .47053 .70701 .4566 .69613 Metetra
.759 .81 .893 r
.4566 .69613 .47053 .70701 .49511 .68868 .48133 .68125 Metetra
.842 .861 .857 r
.48133 .68125 .49511 .68868 .51976 .6619 .50622 .65827 Metetra
.896 .901 .822 r
.50622 .65827 .51976 .6619 .54431 .6286 .5311 .62856 Metetra
.927 .932 .789 r
.5311 .62856 .54431 .6286 .56866 .59127 .55583 .5941 Metetra
.937 .955 .759 r
.55583 .5941 .56866 .59127 .59277 .55269 .58035 .55716 Metetra
.932 .969 .74 r
.58035 .55716 .59277 .55269 .61668 .51559 .60465 .52014 Metetra
.916 .979 .743 r
.60465 .52014 .61668 .51559 .64051 .48245 .62881 .48532 Metetra
.896 .987 .78 r
.62881 .48532 .64051 .48245 .66442 .45534 .65294 .4547 Metetra
.867 .979 .849 r
.65294 .4547 .66442 .45534 .68864 .43576 .67722 .42991 Metetra
.803 .917 .915 r
.67722 .42991 .68864 .43576 .71339 .42463 .70184 .41214 Metetra
.694 .786 .921 r
.70184 .41214 .71339 .42463 .73888 .42222 .72702 .40206 Metetra
.579 .636 .872 r
.72702 .40206 .73888 .42222 .76532 .4282 .75295 .39985 Metetra
.496 .52 .812 r
.75295 .39985 .76532 .4282 .79282 .44159 .77981 .40517 Metetra
.447 .446 .765 r
.77981 .40517 .79282 .44159 .82143 .46081 .80772 .41718 Metetra
.422 .403 .733 r
.80772 .41718 .82143 .46081 .85112 .48373 .83673 .43454 Metetra
.413 .382 .715 r
.83673 .43454 .85112 .48373 .8817 .50777 .8668 .45547 Metetra
.415 .377 .708 r
.8668 .45547 .8817 .50777 .9129 .5301 .8978 .47781 Metetra
.425 .386 .711 r
.8978 .47781 .9129 .5301 .94434 .54786 .92949 .49915 Metetra
.549 .026 0 r
.3052 .61762 .31964 .63022 .34077 .65248 .32641 .63831 Metetra
0 .092 .592 r
.32641 .63831 .34077 .65248 .36257 .67297 .34826 .65752 Metetra
0 .274 .766 r
.34826 .65752 .36257 .67297 .38508 .68939 .37081 .67331 Metetra
.147 .466 .891 r
.37081 .67331 .38508 .68939 .40832 .69967 .39407 .68387 Metetra
.404 .615 .936 r
.39407 .68387 .40832 .69967 .4322 .70222 .41798 .68778 Metetra
.589 .717 .932 r
.41798 .68778 .4322 .70222 .4566 .69613 .44244 .68407 Metetra
.717 .79 .909 r
.44244 .68407 .4566 .69613 .48133 .68125 .4673 .67244 Metetra
.807 .847 .88 r
.4673 .67244 .48133 .68125 .50622 .65827 .49239 .65319 Metetra
.87 .894 .849 r
.49239 .65319 .50622 .65827 .5311 .62856 .51756 .62727 Metetra
.909 .932 .815 r
.51756 .62727 .5311 .62856 .55583 .5941 .54265 .59614 Metetra
.926 .959 .781 r
.54265 .59614 .55583 .5941 .58035 .55716 .56758 .56161 Metetra
.923 .975 .75 r
.56758 .56161 .58035 .55716 .60465 .52014 .59231 .52569 Metetra
.908 .983 .733 r
.59231 .52569 .60465 .52014 .62881 .48532 .61685 .49038 Metetra
.888 .989 .742 r
.61685 .49038 .62881 .48532 .65294 .4547 .64129 .45756 Metetra
.871 .995 .789 r
.64129 .45756 .65294 .4547 .67722 .42991 .66576 .42887 Metetra
.848 .982 .865 r
.66576 .42887 .67722 .42991 .70184 .41214 .6904 .40561 Metetra
.789 .911 .924 r
.6904 .40561 .70184 .41214 .72702 .40206 .71541 .38872 Metetra
.689 .776 .918 r
.71541 .38872 .72702 .40206 .75295 .39985 .74098 .37874 Metetra
.588 .635 .865 r
.74098 .37874 .75295 .39985 .77981 .40517 .7673 .37582 Metetra
.515 .527 .807 r
.7673 .37582 .77981 .40517 .80772 .41718 .79452 .37967 Metetra
.47 .457 .762 r
.79452 .37967 .80772 .41718 .83673 .43454 .82277 .38964 Metetra
.446 .416 .731 r
.82277 .38964 .83673 .43454 .8668 .45547 .85209 .40463 Metetra
.435 .393 .713 r
.85209 .40463 .8668 .45547 .8978 .47781 .88249 .42322 Metetra
.434 .385 .704 r
.88249 .42322 .8978 .47781 .92949 .49915 .91385 .44364 Metetra
.485 0 0 r
.29053 .60482 .3052 .61762 .32641 .63831 .31184 .62391 Metetra
0 .145 .644 r
.31184 .62391 .32641 .63831 .34826 .65752 .33375 .64179 Metetra
0 .302 .788 r
.33375 .64179 .34826 .65752 .37081 .67331 .35634 .65682 Metetra
.146 .462 .889 r
.35634 .65682 .37081 .67331 .39407 .68387 .37962 .66747 Metetra
.372 .593 .931 r
.37962 .66747 .39407 .68387 .41798 .68778 .40356 .67244 Metetra
.544 .69 .935 r
.40356 .67244 .41798 .68778 .44244 .68407 .42807 .67082 Metetra
.672 .766 .921 r
.42807 .67082 .44244 .68407 .4673 .67244 .45303 .66215 Metetra
.767 .828 .9 r
.45303 .66215 .4673 .67244 .49239 .65319 .47829 .6465 Metetra
.837 .882 .875 r
.47829 .6465 .49239 .65319 .51756 .62727 .5037 .62443 Metetra
.885 .927 .845 r
.5037 .62443 .51756 .62727 .54265 .59614 .52912 .59697 Metetra
.91 .96 .809 r
.52912 .59697 .54265 .59614 .56758 .56161 .55444 .56548 Metetra
.912 .98 .77 r
.55444 .56548 .56758 .56161 .59231 .52569 .5796 .53157 Metetra
.896 .986 .735 r
.5796 .53157 .59231 .52569 .61685 .49038 .60458 .49694 Metetra
.872 .987 .718 r
.60458 .49694 .61685 .49038 .64129 .45756 .62941 .46325 Metetra
.852 .991 .732 r
.62941 .46325 .64129 .45756 .66576 .42887 .65417 .43205 Metetra
.842 .998 .787 r
.65417 .43205 .66576 .42887 .6904 .40561 .67898 .40467 Metetra
.83 .988 .87 r
.67898 .40467 .6904 .40561 .71541 .38872 .704 .38218 Metetra
.784 .916 .928 r
.704 .38218 .71541 .38872 .74098 .37874 .72938 .36535 Metetra
.697 .784 .918 r
.72938 .36535 .74098 .37874 .7673 .37582 .7553 .35465 Metetra
.606 .647 .865 r
.7553 .35465 .7673 .37582 .79452 .37967 .78195 .35023 Metetra
.538 .543 .808 r
.78195 .35023 .79452 .37967 .82277 .38964 .80946 .35192 Metetra
.495 .474 .763 r
.80946 .35192 .82277 .38964 .85209 .40463 .83796 .35922 Metetra
.47 .431 .732 r
.83796 .35922 .85209 .40463 .88249 .42322 .86752 .37131 Metetra
.457 .406 .712 r
.86752 .37131 .88249 .42322 .91385 .44364 .89816 .3871 Metetra
0 .104 .582 r
.27563 .59181 .29053 .60482 .31184 .62391 .29703 .60928 Metetra
0 .201 .696 r
.29703 .60928 .31184 .62391 .33375 .64179 .31902 .62577 Metetra
0 .332 .81 r
.31902 .62577 .33375 .64179 .35634 .65682 .34166 .63993 Metetra
.153 .464 .889 r
.34166 .63993 .35634 .65682 .37962 .66747 .36497 .65045 Metetra
.348 .575 .926 r
.36497 .65045 .37962 .66747 .40356 .67244 .38893 .65621 Metetra
.504 .664 .933 r
.38893 .65621 .40356 .67244 .42807 .67082 .41348 .65634 Metetra
.626 .738 .927 r
.41348 .65634 .42807 .67082 .45303 .66215 .43851 .65034 Metetra
.722 .803 .915 r
.43851 .65034 .45303 .66215 .47829 .6465 .46391 .63806 Metetra
.797 .863 .898 r
.46391 .63806 .47829 .6465 .5037 .62443 .48953 .61979 Metetra
.853 .915 .874 r
.48953 .61979 .5037 .62443 .52912 .59697 .51524 .59618 Metetra
.887 .957 .842 r
.51524 .59618 .52912 .59697 .55444 .56548 .54094 .5682 Metetra
.896 .983 .799 r
.54094 .5682 .55444 .56548 .5796 .53157 .56652 .53708 Metetra
.882 .991 .752 r
.56652 .53708 .5796 .53157 .60458 .49694 .59196 .50417 Metetra
.853 .986 .711 r
.59196 .50417 .60458 .49694 .62941 .46325 .61723 .4709 Metetra
.822 .98 .691 r
.61723 .4709 .62941 .46325 .65417 .43205 .64238 .43863 Metetra
.804 .982 .708 r
.64238 .43863 .65417 .43205 .67898 .40467 .66749 .40862 Metetra
.805 .996 .77 r
.66749 .40862 .67898 .40467 .704 .38218 .69266 .38199 Metetra
.811 .995 .862 r
.69266 .38199 .704 .38218 .72938 .36535 .71804 .35961 Metetra
.785 .935 .929 r
.71804 .35961 .72938 .36535 .7553 .35465 .74377 .34215 Metetra
.714 .81 .925 r
.74377 .34215 .7553 .35465 .78195 .35023 .77001 .33006 Metetra
.632 .675 .873 r
.77001 .33006 .78195 .35023 .80946 .35192 .79693 .32349 Metetra
.566 .569 .816 r
.79693 .32349 .80946 .35192 .83796 .35922 .82467 .3224 Metetra
.522 .497 .769 r
.82467 .3224 .83796 .35922 .86752 .37131 .85334 .32645 Metetra
.495 .45 .736 r
.85334 .32645 .86752 .37131 .89816 .3871 .88304 .33509 Metetra
0 .175 .652 r
.26048 .5786 .27563 .59181 .29703 .60928 .282 .59442 Metetra
0 .26 .746 r
.282 .59442 .29703 .60928 .31902 .62577 .30408 .60947 Metetra
0 .366 .833 r
.30408 .60947 .31902 .62577 .34166 .63993 .32678 .62264 Metetra
.168 .471 .892 r
.32678 .62264 .34166 .63993 .36497 .65045 .35013 .63283 Metetra
.334 .562 .921 r
.35013 .63283 .36497 .65045 .38893 .65621 .37412 .6391 Metetra
.471 .64 .93 r
.37412 .6391 .38893 .65621 .41348 .65634 .39869 .64065 Metetra
.582 .709 .929 r
.39869 .64065 .41348 .65634 .43851 .65034 .42378 .63695 Metetra
.675 .773 .924 r
.42378 .63695 .43851 .65034 .46391 .63806 .44928 .62775 Metetra
.751 .835 .916 r
.44928 .62775 .46391 .63806 .48953 .61979 .47507 .61311 Metetra
.813 .894 .901 r
.47507 .61311 .48953 .61979 .51524 .59618 .50103 .59339 Metetra
.856 .946 .876 r
.50103 .59339 .51524 .59618 .54094 .5682 .52706 .56922 Metetra
.875 .981 .837 r
.52706 .56922 .54094 .5682 .56652 .53708 .55304 .54148 Metetra
.866 .996 .783 r
.55304 .54148 .56652 .53708 .59196 .50417 .57893 .5112 Metetra
.834 .989 .724 r
.57893 .5112 .59196 .50417 .61723 .4709 .60468 .47951 Metetra
.791 .971 .673 r
.60468 .47951 .61723 .4709 .64238 .43863 .63029 .44756 Metetra
.754 .956 .648 r
.63029 .44756 .64238 .43863 .66749 .40862 .65581 .41648 Metetra
.738 .957 .664 r
.65581 .41648 .66749 .40862 .69266 .38199 .68129 .38731 Metetra
.75 .978 .729 r
.68129 .38731 .69266 .38199 .71804 .35961 .70684 .36095 Metetra
.778 .998 .832 r
.70684 .36095 .71804 .35961 .74377 .34215 .73258 .33817 Metetra
.784 .965 .92 r
.73258 .33817 .74377 .34215 .77001 .33006 .75864 .31957 Metetra
.739 .857 .936 r
.75864 .31957 .77001 .33006 .79693 .32349 .78517 .30554 Metetra
.666 .722 .891 r
.78517 .30554 .79693 .32349 .82467 .3224 .81231 .29631 Metetra
.6 .609 .832 r
.81231 .29631 .82467 .3224 .85334 .32645 .84021 .29192 Metetra
.553 .529 .782 r
.84021 .29192 .85334 .32645 .88304 .33509 .86898 .29221 Metetra
0 .249 .719 r
.24509 .56516 .26048 .5786 .282 .59442 .26674 .57932 Metetra
0 .318 .792 r
.26674 .57932 .282 .59442 .30408 .60947 .28892 .59288 Metetra
.037 .401 .855 r
.28892 .59288 .30408 .60947 .32678 .62264 .3117 .60495 Metetra
.191 .482 .896 r
.3117 .60495 .32678 .62264 .35013 .63283 .33509 .61462 Metetra
.328 .554 .917 r
.33509 .61462 .35013 .63283 .37412 .6391 .3591 .62111 Metetra
.445 .619 .925 r
.3591 .62111 .37412 .6391 .39869 .64065 .3837 .62373 Metetra
.544 .68 .927 r
.3837 .62373 .39869 .64065 .42378 .63695 .40883 .62195 Metetra
.629 .74 .928 r
.40883 .62195 .42378 .63695 .44928 .62775 .4344 .61546 Metetra
.703 .801 .926 r
.4344 .61546 .44928 .62775 .47507 .61311 .46033 .60418 Metetra
.766 .864 .921 r
.46033 .60418 .47507 .61311 .50103 .59339 .4865 .58824 Metetra
.816 .923 .907 r
.4865 .58824 .50103 .59339 .52706 .56922 .51281 .56801 Metetra
.845 .971 .877 r
.51281 .56801 .52706 .56922 .55304 .54148 .53916 .54405 Metetra
.846 .997 .827 r
.53916 .54405 .55304 .54148 .57893 .5112 .56548 .51709 Metetra
.817 .995 .758 r
.56548 .51709 .57893 .5112 .60468 .47951 .59172 .48798 Metetra
.765 .969 .683 r
.59172 .48798 .60468 .47951 .63029 .44756 .61783 .45763 Metetra
.708 .935 .62 r
.61783 .45763 .63029 .44756 .65581 .41648 .64384 .42697 Metetra
.664 .909 .585 r
.64384 .42697 .65581 .41648 .68129 .38731 .66975 .39691 Metetra
.647 .907 .593 r
.66975 .39691 .68129 .38731 .70684 .36095 .69565 .3683 Metetra
.664 .933 .652 r
.69565 .3683 .70684 .36095 .73258 .33817 .7216 .34192 Metetra
.713 .977 .762 r
.7216 .34192 .73258 .33817 .75864 .31957 .74771 .31841 Metetra
.762 .992 .884 r
.74771 .31841 .75864 .31957 .78517 .30554 .7741 .2983 Metetra
.76 .923 .943 r
.7741 .2983 .78517 .30554 .81231 .29631 .80089 .28199 Metetra
.707 .795 .919 r
.80089 .28199 .81231 .29631 .84021 .29192 .82823 .26974 Metetra
.643 .671 .862 r
.82823 .26974 .84021 .29192 .86898 .29221 .85623 .26168 Metetra
0 .322 .781 r
.22944 .5515 .24509 .56516 .26674 .57932 .25123 .56398 Metetra
0 .376 .834 r
.25123 .56398 .26674 .57932 .28892 .59288 .27353 .576 Metetra
.094 .437 .876 r
.27353 .576 .28892 .59288 .3117 .60495 .2964 .58685 Metetra
.219 .497 .902 r
.2964 .58685 .3117 .60495 .33509 .61462 .31985 .59583 Metetra
.332 .552 .914 r
.31985 .59583 .33509 .61462 .3591 .62111 .3439 .60228 Metetra
.429 .603 .919 r
.3439 .60228 .3591 .62111 .3837 .62373 .36852 .6056 Metetra
.513 .654 .922 r
.36852 .6056 .3837 .62373 .40883 .62195 .39368 .60534 Metetra
.587 .707 .925 r
.39368 .60534 .40883 .62195 .4344 .61546 .41931 .60115 Metetra
.654 .763 .929 r
.41931 .60115 .4344 .61546 .46033 .60418 .44533 .59285 Metetra
.715 .824 .932 r
.44533 .59285 .46033 .60418 .4865 .58824 .47166 .58045 Metetra
.768 .887 .93 r
.47166 .58045 .4865 .58824 .51281 .56801 .49821 .56408 Metetra
.807 .945 .915 r
.49821 .56408 .51281 .56801 .53916 .54405 .52489 .54408 Metetra
.821 .987 .877 r
.52489 .54408 .53916 .54405 .56548 .51709 .55161 .52091 Metetra
.801 .999 .812 r
.55161 .52091 .56548 .51709 .59172 .48798 .57831 .49514 Metetra
.749 .977 .724 r
.57831 .49514 .59172 .48798 .61783 .45763 .60494 .46746 Metetra
.677 .93 .63 r
.60494 .46746 .61783 .45763 .64384 .42697 .63148 .43856 Metetra
.607 .878 .552 r
.63148 .43856 .64384 .42697 .66975 .39691 .65792 .4092 Metetra
.554 .839 .503 r
.65792 .4092 .66975 .39691 .69565 .3683 .68429 .3801 Metetra
.529 .826 .496 r
.68429 .3801 .69565 .3683 .7216 .34192 .71064 .35197 Metetra
.541 .848 .537 r
.71064 .35197 .7216 .34192 .74771 .31841 .73703 .32542 Metetra
.594 .903 .635 r
.73703 .32542 .74771 .31841 .7741 .2983 .76354 .30104 Metetra
.678 .97 .779 r
.76354 .30104 .7741 .2983 .80089 .28199 .79027 .27929 Metetra
.745 .983 .909 r
.79027 .27929 .80089 .28199 .82823 .26974 .81734 .26057 Metetra
.745 .898 .947 r
.81734 .26057 .82823 .26974 .85623 .26168 .84486 .24514 Metetra
0 .392 .835 r
.21353 .53762 .22944 .5515 .25123 .56398 .23548 .54839 Metetra
.048 .431 .87 r
.23548 .54839 .25123 .56398 .27353 .576 .25792 .55882 Metetra
.153 .473 .895 r
.25792 .55882 .27353 .576 .2964 .58685 .28088 .56837 Metetra
.253 .514 .907 r
.28088 .56837 .2964 .58685 .31985 .59583 .30441 .57647 Metetra
.343 .553 .912 r
.30441 .57647 .31985 .59583 .3439 .60228 .32851 .58261 Metetra
.421 .592 .914 r
.32851 .58261 .3439 .60228 .36852 .6056 .35316 .58629 Metetra
.491 .632 .915 r
.35316 .58629 .36852 .6056 .39368 .60534 .37834 .58712 Metetra
.553 .675 .919 r
.37834 .58712 .39368 .60534 .41931 .60115 .40401 .58477 Metetra
.611 .724 .926 r
.40401 .58477 .41931 .60115 .44533 .59285 .4301 .57902 Metetra
.666 .779 .934 r
.4301 .57902 .44533 .59285 .47166 .58045 .45656 .56976 Metetra
.716 .84 .941 r
.45656 .56976 .47166 .58045 .49821 .56408 .4833 .55702 Metetra
.759 .903 .941 r
.4833 .55702 .49821 .56408 .52489 .54408 .51024 .54093 Metetra
.785 .96 .923 r
.51024 .54093 .52489 .54408 .55161 .52091 .5373 .52175 Metetra
.783 .994 .876 r
.5373 .52175 .55161 .52091 .57831 .49514 .56443 .49982 Metetra
.742 .989 .794 r
.56443 .49982 .57831 .49514 .60494 .46746 .59156 .47559 Metetra
.667 .944 .684 r
.59156 .47559 .60494 .46746 .63148 .43856 .61865 .44957 Metetra
.577 .874 .571 r
.61865 .44957 .63148 .43856 .65792 .4092 .64567 .4223 Metetra
.64567 .4223 .65792 .4092 .68429 .3801 .67262 .39435 Metetra
.67262 .39435 .68429 .3801 .71064 .35197 .69951 .36631 Metetra
.69951 .36631 .71064 .35197 .73703 .32542 .72637 .33871 Metetra
.72637 .33871 .73703 .32542 .76354 .30104 .75325 .3121 Metetra
.75325 .3121 .76354 .30104 .79027 .27929 .78021 .28695 Metetra
.501 .847 .578 r
.78021 .28695 .79027 .27929 .81734 .26057 .80734 .26367 Metetra
.616 .943 .748 r
.80734 .26367 .81734 .26057 .84486 .24514 .83472 .24264 Metetra
.048 .458 .88 r
.19736 .5235 .21353 .53762 .23548 .54839 .21948 .53254 Metetra
.129 .483 .9 r
.21948 .53254 .23548 .54839 .25792 .55882 .24207 .54135 Metetra
.212 .508 .91 r
.24207 .54135 .25792 .55882 .28088 .56837 .26515 .54949 Metetra
.291 .534 .912 r
.26515 .54949 .28088 .56837 .30441 .57647 .28877 .55656 Metetra
.361 .559 .911 r
.28877 .55656 .30441 .57647 .32851 .58261 .31292 .56213 Metetra
.423 .586 .908 r
.31292 .56213 .32851 .58261 .35316 .58629 .33761 .56584 Metetra
.478 .615 .908 r
.33761 .56584 .35316 .58629 .37834 .58712 .36282 .56733 Metetra
.528 .648 .911 r
.36282 .56733 .37834 .58712 .40401 .58477 .38852 .56633 Metetra
.576 .687 .917 r
.38852 .56633 .40401 .58477 .4301 .57902 .41467 .56262 Metetra
.621 .733 .927 r
.41467 .56262 .4301 .57902 .45656 .56976 .44121 .55603 Metetra
.666 .786 .939 r
.44121 .55603 .45656 .56976 .4833 .55702 .46809 .54651 Metetra
.707 .847 .949 r
.46809 .54651 .4833 .55702 .51024 .54093 .49524 .53407 Metetra
.74 .91 .952 r
.49524 .53407 .51024 .54093 .5373 .52175 .5226 .51881 Metetra
.755 .964 .933 r
.5226 .51881 .5373 .52175 .56443 .49982 .5501 .5009 Metetra
.737 .99 .878 r
.5501 .5009 .56443 .49982 .59156 .47559 .57768 .4806 Metetra
.676 .97 .779 r
.57768 .4806 .59156 .47559 .61865 .44957 .6053 .45822 Metetra
.582 .904 .65 r
.6053 .45822 .61865 .44957 .64567 .4223 .63291 .43413 Metetra
.63291 .43413 .64567 .4223 .67262 .39435 .66048 .40872 Metetra
.66048 .40872 .67262 .39435 .69951 .36631 .68801 .38242 Metetra
.68801 .38242 .69951 .36631 .72637 .33871 .71549 .35567 Metetra
.71549 .35567 .72637 .33871 .75325 .3121 .74295 .3289 Metetra
.74295 .3289 .75325 .3121 .78021 .28695 .7704 .30253 Metetra
.7704 .30253 .78021 .28695 .80734 .26367 .79791 .27696 Metetra
.79791 .27696 .80734 .26367 .83472 .24264 .82552 .25254 Metetra
.141 .517 .915 r
.1809 .50914 .19736 .5235 .21948 .53254 .20322 .51644 Metetra
.207 .529 .922 r
.20322 .51644 .21948 .53254 .24207 .54135 .22597 .52358 Metetra
.271 .542 .921 r
.22597 .52358 .24207 .54135 .26515 .54949 .2492 .53023 Metetra
.331 .554 .916 r
.2492 .53023 .26515 .54949 .28877 .55656 .27293 .5361 Metetra
.384 .568 .909 r
.27293 .5361 .28877 .55656 .31292 .56213 .29716 .54088 Metetra
.431 .584 .904 r
.29716 .54088 .31292 .56213 .33761 .56584 .3219 .54427 Metetra
.474 .603 .9 r
.3219 .54427 .33761 .56584 .36282 .56733 .34714 .54602 Metetra
.513 .627 .901 r
.34714 .54602 .36282 .56733 .38852 .56633 .37286 .54588 Metetra
.55 .655 .905 r
.37286 .54588 .38852 .56633 .41467 .56262 .39905 .54365 Metetra
.586 .69 .914 r
.39905 .54365 .41467 .56262 .44121 .55603 .42565 .53917 Metetra
.622 .733 .926 r
.42565 .53917 .44121 .55603 .46809 .54651 .45263 .53234 Metetra
.657 .783 .941 r
.45263 .53234 .46809 .54651 .49524 .53407 .47994 .52309 Metetra
.69 .842 .956 r
.47994 .52309 .49524 .53407 .5226 .51881 .50753 .51143 Metetra
.714 .904 .963 r
.50753 .51143 .5226 .51881 .5501 .5009 .53534 .49741 Metetra
.72 .957 .947 r
.53534 .49741 .5501 .5009 .57768 .4806 .56331 .48114 Metetra
.692 .98 .891 r
.56331 .48114 .57768 .4806 .6053 .45822 .5914 .46279 Metetra
.618 .951 .782 r
.5914 .46279 .6053 .45822 .63291 .43413 .61957 .44255 Metetra
.509 .87 .637 r
.61957 .44255 .63291 .43413 .66048 .40872 .64777 .42068 Metetra
.64777 .42068 .66048 .40872 .68801 .38242 .67597 .39744 Metetra
.67597 .39744 .68801 .38242 .71549 .35567 .70416 .37314 Metetra
.70416 .37314 .71549 .35567 .74295 .3289 .73233 .34809 Metetra
.73233 .34809 .74295 .3289 .7704 .30253 .76048 .32261 Metetra
.76048 .32261 .7704 .30253 .79791 .27696 .78863 .29702 Metetra
.78863 .29702 .79791 .27696 .82552 .25254 .8168 .27163 Metetra
.229 .569 .939 r
.16417 .49454 .1809 .50914 .20322 .51644 .1867 .50008 Metetra
.28 .57 .936 r
.1867 .50008 .20322 .51644 .22597 .52358 .20964 .5055 Metetra
.329 .572 .929 r
.20964 .5055 .22597 .52358 .2492 .53023 .23302 .51058 Metetra
.373 .575 .918 r
.23302 .51058 .2492 .53023 .27293 .5361 .25687 .51512 Metetra
.412 .579 .908 r
.25687 .51512 .27293 .5361 .29716 .54088 .2812 .51888 Metetra
.447 .587 .899 r
.2812 .51888 .29716 .54088 .3219 .54427 .30601 .52166 Metetra
.478 .597 .893 r
.30601 .52166 .3219 .54427 .34714 .54602 .3313 .52325 Metetra
.508 .611 .89 r
.3313 .52325 .34714 .54602 .37286 .54588 .35706 .52348 Metetra
.535 .63 .892 r
.35706 .52348 .37286 .54588 .39905 .54365 .38327 .52217 Metetra
.562 .654 .898 r
.38327 .52217 .39905 .54365 .42565 .53917 .40992 .51917 Metetra
.589 .685 .908 r
.40992 .51917 .42565 .53917 .45263 .53234 .43697 .51439 Metetra
.616 .722 .922 r
.43697 .51439 .45263 .53234 .47994 .52309 .46439 .50772 Metetra
.643 .768 .939 r
.46439 .50772 .47994 .52309 .50753 .51143 .49215 .49912 Metetra
.668 .823 .958 r
.49215 .49912 .50753 .51143 .53534 .49741 .52019 .48856 Metetra
.687 .882 .971 r
.52019 .48856 .53534 .49741 .56331 .48114 .54848 .47608 Metetra
.689 .937 .965 r
.54848 .47608 .56331 .48114 .5914 .46279 .57697 .46172 Metetra
.66 .965 .92 r
.57697 .46172 .5914 .46279 .61957 .44255 .60562 .44556 Metetra
.584 .943 .818 r
.60562 .44556 .61957 .44255 .64777 .42068 .63439 .42773 Metetra
.469 .861 .667 r
.63439 .42773 .64777 .42068 .67597 .39744 .66325 .40837 Metetra
.66325 .40837 .67597 .39744 .70416 .37314 .69217 .38765 Metetra
.69217 .38765 .70416 .37314 .73233 .34809 .72111 .36577 Metetra
.72111 .36577 .73233 .34809 .76048 .32261 .75008 .34293 Metetra
.75008 .34293 .76048 .32261 .78863 .29702 .77905 .31935 Metetra
.77905 .31935 .78863 .29702 .8168 .27163 .80803 .29526 Metetra
.309 .612 .955 r
.14715 .47968 .16417 .49454 .1867 .50008 .1699 .48344 Metetra
.348 .606 .945 r
.1699 .48344 .1867 .50008 .20964 .5055 .19305 .48711 Metetra
.383 .6 .932 r
.19305 .48711 .20964 .5055 .23302 .51058 .21662 .49056 Metetra
.415 .595 .918 r
.21662 .49056 .23302 .51058 .25687 .51512 .24061 .49363 Metetra
.443 .592 .905 r
.24061 .49363 .25687 .51512 .2812 .51888 .26506 .49617 Metetra
.467 .592 .894 r
.26506 .49617 .2812 .51888 .30601 .52166 .28995 .49805 Metetra
.49 .595 .886 r
.28995 .49805 .30601 .52166 .3313 .52325 .3153 .49911 Metetra
.51 .601 .88 r
.3153 .49911 .3313 .52325 .35706 .52348 .34111 .49923 Metetra
.53 .611 .879 r
.34111 .49923 .35706 .52348 .38327 .52217 .36736 .49827 Metetra
.549 .626 .881 r
.36736 .49827 .38327 .52217 .40992 .51917 .39404 .49613 Metetra
.568 .645 .886 r
.39404 .49613 .40992 .51917 .43697 .51439 .42114 .49269 Metetra
.587 .67 .896 r
.42114 .49269 .43697 .51439 .46439 .50772 .44864 .48788 Metetra
.607 .702 .911 r
.44864 .48788 .46439 .50772 .49215 .49912 .47651 .48162 Metetra
.627 .741 .929 r
.47651 .48162 .49215 .49912 .52019 .48856 .50471 .47387 Metetra
.646 .788 .95 r
.50471 .47387 .52019 .48856 .54848 .47608 .53324 .4646 Metetra
.661 .842 .969 r
.53324 .4646 .54848 .47608 .57697 .46172 .56204 .45379 Metetra
.666 .898 .979 r
.56204 .45379 .57697 .46172 .60562 .44556 .59108 .44146 Metetra
.647 .941 .962 r
.59108 .44146 .60562 .44556 .63439 .42773 .62034 .42764 Metetra
.587 .946 .893 r
.62034 .42764 .63439 .42773 .66325 .40837 .64977 .41238 Metetra
.482 .89 .761 r
.64977 .41238 .66325 .40837 .69217 .38765 .67935 .39577 Metetra
.67935 .39577 .69217 .38765 .72111 .36577 .70905 .37787 Metetra
.70905 .37787 .72111 .36577 .75008 .34293 .73884 .35882 Metetra
.73884 .35882 .75008 .34293 .77905 .31935 .76871 .33871 Metetra
.76871 .33871 .77905 .31935 .80803 .29526 .79863 .31769 Metetra
.381 .648 .962 r
.12984 .46457 .14715 .47968 .1699 .48344 .15283 .46652 Metetra
.409 .636 .948 r
.15283 .46652 .1699 .48344 .19305 .48711 .17621 .46841 Metetra
.434 .624 .933 r
.17621 .46841 .19305 .48711 .21662 .49056 .19997 .47015 Metetra
.456 .614 .917 r
.19997 .47015 .21662 .49056 .24061 .49363 .22414 .47165 Metetra
.475 .605 .902 r
.22414 .47165 .24061 .49363 .26506 .49617 .24872 .4728 Metetra
.491 .6 .889 r
.24872 .4728 .26506 .49617 .28995 .49805 .27373 .47352 Metetra
.506 .597 .878 r
.27373 .47352 .28995 .49805 .3153 .49911 .29917 .4737 Metetra
.52 .596 .871 r
.29917 .4737 .3153 .49911 .34111 .49923 .32503 .47327 Metetra
.533 .599 .866 r
.32503 .47327 .34111 .49923 .36736 .49827 .35133 .47213 Metetra
.546 .606 .864 r
.35133 .47213 .36736 .49827 .39404 .49613 .37805 .4702 Metetra
.559 .616 .866 r
.37805 .4702 .39404 .49613 .42114 .49269 .40519 .4674 Metetra
.571 .629 .871 r
.40519 .4674 .42114 .49269 .44864 .48788 .43273 .46366 Metetra
.585 .648 .879 r
.43273 .46366 .44864 .48788 .47651 .48162 .46067 .45893 Metetra
.598 .671 .891 r
.46067 .45893 .47651 .48162 .50471 .47387 .48899 .45314 Metetra
.612 .701 .907 r
.48899 .45314 .50471 .47387 .53324 .4646 .51766 .44625 Metetra
.626 .738 .927 r
.51766 .44625 .53324 .4646 .56204 .45379 .54668 .43823 Metetra
.639 .782 .95 r
.54668 .43823 .56204 .45379 .59108 .44146 .57601 .42905 Metetra
.647 .833 .972 r
.57601 .42905 .59108 .44146 .62034 .42764 .60563 .4187 Metetra
.644 .885 .985 r
.60563 .4187 .62034 .42764 .64977 .41238 .63552 .40719 Metetra
.618 .926 .971 r
.63552 .40719 .64977 .41238 .67935 .39577 .66564 .39451 Metetra
.553 .93 .908 r
.66564 .39451 .67935 .39577 .70905 .37787 .69599 .3807 Metetra
.442 .873 .779 r
.69599 .3807 .70905 .37787 .73884 .35882 .72653 .36579 Metetra
.72653 .36579 .73884 .35882 .76871 .33871 .75724 .34981 Metetra
.75724 .34981 .76871 .33871 .79863 .31769 .78809 .33284 Metetra
.444 .677 .963 r
.11222 .44919 .12984 .46457 .15283 .46652 .13548 .44932 Metetra
.464 .661 .947 r
.13548 .44932 .15283 .46652 .17621 .46841 .1591 .4494 Metetra
.48 .645 .93 r
.1591 .4494 .17621 .46841 .19997 .47015 .18309 .44938 Metetra
.495 .631 .913 r
.18309 .44938 .19997 .47015 .22414 .47165 .20745 .4492 Metetra
.507 .619 .897 r
.20745 .4492 .22414 .47165 .24872 .4728 .2322 .4488 Metetra
.517 .609 .883 r
.2322 .4488 .24872 .4728 .27373 .47352 .25734 .44813 Metetra
.527 .601 .871 r
.25734 .44813 .27373 .47352 .29917 .4737 .28289 .44713 Metetra
.535 .596 .861 r
.28289 .44713 .29917 .4737 .32503 .47327 .30884 .44575 Metetra
.543 .593 .854 r
.30884 .44575 .32503 .47327 .35133 .47213 .33519 .44393 Metetra
.551 .593 .849 r
.33519 .44393 .35133 .47213 .37805 .4702 .36196 .44162 Metetra
.559 .595 .847 r
.36196 .44162 .37805 .4702 .40519 .4674 .38914 .43877 Metetra
.566 .601 .847 r
.38914 .43877 .40519 .4674 .43273 .46366 .41672 .43533 Metetra
.574 .609 .849 r
.41672 .43533 .43273 .46366 .46067 .45893 .4447 .43126 Metetra
.582 .62 .855 r
.4447 .43126 .46067 .45893 .48899 .45314 .47308 .42651 Metetra
.591 .635 .863 r
.47308 .42651 .48899 .45314 .51766 .44625 .50185 .42103 Metetra
.6 .654 .875 r
.50185 .42103 .51766 .44625 .54668 .43823 .53099 .41481 Metetra
.61 .678 .89 r
.53099 .41481 .54668 .43823 .57601 .42905 .56049 .4078 Metetra
.619 .708 .909 r
.56049 .4078 .57601 .42905 .60563 .4187 .59035 .39998 Metetra
.628 .745 .931 r
.59035 .39998 .60563 .4187 .63552 .40719 .62055 .39132 Metetra
.635 .788 .956 r
.62055 .39132 .63552 .40719 .66564 .39451 .65107 .38182 Metetra
.635 .837 .978 r
.65107 .38182 .66564 .39451 .69599 .3807 .68189 .37146 Metetra
.622 .884 .989 r
.68189 .37146 .69599 .3807 .72653 .36579 .71301 .36024 Metetra
.582 .916 .971 r
.71301 .36024 .72653 .36579 .75724 .34981 .7444 .34815 Metetra
.503 .908 .899 r
.7444 .34815 .75724 .34981 .78809 .33284 .77604 .33521 Metetra
.499 .701 .96 r
.09428 .43354 .11222 .44919 .13548 .44932 .11784 .43183 Metetra
.512 .681 .942 r
.11784 .43183 .13548 .44932 .1591 .4494 .14173 .43007 Metetra
.523 .663 .925 r
.14173 .43007 .1591 .4494 .18309 .44938 .16596 .42824 Metetra
.532 .646 .907 r
.16596 .42824 .18309 .44938 .20745 .4492 .19054 .42629 Metetra
.539 .631 .891 r
.19054 .42629 .20745 .4492 .2322 .4488 .21548 .42421 Metetra
.544 .618 .877 r
.21548 .42421 .2322 .4488 .25734 .44813 .24078 .42196 Metetra
.55 .607 .864 r
.24078 .42196 .25734 .44813 .28289 .44713 .26646 .41952 Metetra
.554 .598 .852 r
.26646 .41952 .28289 .44713 .30884 .44575 .29252 .41685 Metetra
.558 .591 .843 r
.29252 .41685 .30884 .44575 .33519 .44393 .31897 .41392 Metetra
.562 .586 .836 r
.31897 .41392 .33519 .44393 .36196 .44162 .3458 .41071 Metetra
.566 .583 .83 r
.3458 .41071 .36196 .44162 .38914 .43877 .37302 .40718 Metetra
.57 .582 .826 r
.37302 .40718 .38914 .43877 .41672 .43533 .40064 .40331 Metetra
.574 .583 .824 r
.40064 .40331 .41672 .43533 .4447 .43126 .42866 .39907 Metetra
.578 .585 .824 r
.42866 .39907 .4447 .43126 .47308 .42651 .45707 .39444 Metetra
.582 .59 .826 r
.45707 .39444 .47308 .42651 .50185 .42103 .48587 .38938 Metetra
.587 .597 .829 r
.48587 .38938 .50185 .42103 .53099 .41481 .51507 .38387 Metetra
.592 .607 .835 r
.51507 .38387 .53099 .41481 .56049 .4078 .54466 .37788 Metetra
.598 .619 .844 r
.54466 .37788 .56049 .4078 .59035 .39998 .57463 .3714 Metetra
.604 .635 .855 r
.57463 .3714 .59035 .39998 .62055 .39132 .60499 .36441 Metetra
.61 .654 .869 r
.60499 .36441 .62055 .39132 .65107 .38182 .63573 .35688 Metetra
.616 .678 .886 r
.63573 .35688 .65107 .38182 .68189 .37146 .66683 .34879 Metetra
.623 .707 .906 r
.66683 .34879 .68189 .37146 .71301 .36024 .6983 .34014 Metetra
.628 .742 .929 r
.6983 .34014 .71301 .36024 .7444 .34815 .73013 .3309 Metetra
.63 .783 .955 r
.73013 .3309 .7444 .34815 .77604 .33521 .76231 .32107 Metetra
.547 .719 .952 r
.07603 .41761 .09428 .43354 .11784 .43183 .0999 .41405 Metetra
.555 .698 .935 r
.0999 .41405 .11784 .43183 .14173 .43007 .12408 .41042 Metetra
.561 .678 .918 r
.12408 .41042 .14173 .43007 .16596 .42824 .14857 .40673 Metetra
.566 .66 .901 r
.14857 .40673 .16596 .42824 .19054 .42629 .1734 .40296 Metetra
.569 .643 .885 r
.1734 .40296 .19054 .42629 .21548 .42421 .19856 .39908 Metetra
.571 .628 .87 r
.19856 .39908 .21548 .42421 .24078 .42196 .22405 .3951 Metetra
.573 .615 .856 r
.22405 .3951 .24078 .42196 .26646 .41952 .2499 .391 Metetra
.575 .603 .844 r
.2499 .391 .26646 .41952 .29252 .41685 .2761 .38676 Metetra
.576 .593 .833 r
.2761 .38676 .29252 .41685 .31897 .41392 .30265 .38237 Metetra
.577 .585 .824 r
.30265 .38237 .31897 .41392 .3458 .41071 .32957 .37781 Metetra
.578 .577 .816 r
.32957 .37781 .3458 .41071 .37302 .40718 .35686 .37308 Metetra
.579 .572 .809 r
.35686 .37308 .37302 .40718 .40064 .40331 .38452 .36816 Metetra
.58 .567 .804 r
.38452 .36816 .40064 .40331 .42866 .39907 .41257 .36303 Metetra
.582 .564 .799 r
.41257 .36303 .42866 .39907 .45707 .39444 .44099 .35768 Metetra
.583 .562 .796 r
.44099 .35768 .45707 .39444 .48587 .38938 .46981 .3521 Metetra
.585 .562 .795 r
.46981 .3521 .48587 .38938 .51507 .38387 .49901 .34628 Metetra
.587 .562 .794 r
.49901 .34628 .51507 .38387 .54466 .37788 .52861 .34019 Metetra
.589 .565 .795 r
.52861 .34019 .54466 .37788 .57463 .3714 .5586 .33384 Metetra
.591 .568 .797 r
.5586 .33384 .57463 .3714 .60499 .36441 .589 .3272 Metetra
.594 .573 .8 r
.589 .3272 .60499 .36441 .63573 .35688 .61979 .32026 Metetra
.596 .58 .805 r
.61979 .32026 .63573 .35688 .66683 .34879 .65099 .31301 Metetra
.6 .588 .812 r
.65099 .31301 .66683 .34879 .6983 .34014 .68259 .30544 Metetra
.603 .599 .82 r
.68259 .30544 .6983 .34014 .73013 .3309 .71459 .29754 Metetra
.607 .612 .83 r
.71459 .29754 .73013 .3309 .76231 .32107 .747 .28929 Metetra
.589 .733 .943 r
.05745 .40139 .07603 .41761 .0999 .41405 .08165 .39595 Metetra
.593 .711 .926 r
.08165 .39595 .0999 .41405 .12408 .41042 .10614 .39045 Metetra
.595 .691 .909 r
.10614 .39045 .12408 .41042 .14857 .40673 .13093 .38487 Metetra
.597 .672 .893 r
.13093 .38487 .14857 .40673 .1734 .40296 .15603 .37921 Metetra
.597 .654 .877 r
.15603 .37921 .1734 .40296 .19856 .39908 .18143 .37347 Metetra
.597 .638 .862 r
.18143 .37347 .19856 .39908 .22405 .3951 .20714 .36764 Metetra
.597 .623 .849 r
.20714 .36764 .22405 .3951 .2499 .391 .23318 .36171 Metetra
.596 .61 .836 r
.23318 .36171 .2499 .391 .2761 .38676 .25955 .35569 Metetra
.595 .598 .824 r
.25955 .35569 .2761 .38676 .30265 .38237 .28624 .34957 Metetra
.594 .587 .814 r
.28624 .34957 .30265 .38237 .32957 .37781 .31328 .34333 Metetra
.593 .577 .804 r
.31328 .34333 .32957 .37781 .35686 .37308 .34065 .33699 Metetra
.592 .568 .796 r
.34065 .33699 .35686 .37308 .38452 .36816 .36838 .33052 Metetra
.592 .56 .788 r
.36838 .33052 .38452 .36816 .41257 .36303 .39646 .32393 Metetra
.591 .554 .781 r
.39646 .32393 .41257 .36303 .44099 .35768 .4249 .31721 Metetra
.59 .548 .775 r
.4249 .31721 .44099 .35768 .46981 .3521 .45371 .31036 Metetra
.59 .543 .77 r
.45371 .31036 .46981 .3521 .49901 .34628 .4829 .30337 Metetra
.589 .538 .765 r
.4829 .30337 .49901 .34628 .52861 .34019 .51246 .29622 Metetra
.589 .535 .762 r
.51246 .29622 .52861 .34019 .5586 .33384 .5424 .28893 Metetra
.589 .532 .758 r
.5424 .28893 .5586 .33384 .589 .3272 .57274 .28148 Metetra
.589 .53 .756 r
.57274 .28148 .589 .3272 .61979 .32026 .60347 .27386 Metetra
.589 .528 .754 r
.60347 .27386 .61979 .32026 .65099 .31301 .6346 .26608 Metetra
.59 .528 .753 r
.6346 .26608 .65099 .31301 .68259 .30544 .66614 .25812 Metetra
.59 .528 .753 r
.66614 .25812 .68259 .30544 .71459 .29754 .69809 .24998 Metetra
.591 .529 .753 r
.69809 .24998 .71459 .29754 .747 .28929 .73046 .24166 Metetra
.625 .743 .932 r
.03853 .38488 .05745 .40139 .08165 .39595 .06309 .37755 Metetra
.626 .722 .916 r
.06309 .37755 .08165 .39595 .10614 .39045 .08792 .37014 Metetra
.626 .701 .9 r
.08792 .37014 .10614 .39045 .13093 .38487 .11303 .36265 Metetra
.625 .682 .884 r
.11303 .36265 .13093 .38487 .15603 .37921 .13841 .35507 Metetra
.623 .664 .869 r
.13841 .35507 .15603 .37921 .18143 .37347 .16408 .3474 Metetra
.621 .647 .855 r
.16408 .3474 .18143 .37347 .20714 .36764 .19005 .33965 Metetra
.619 .632 .841 r
.19005 .33965 .20714 .36764 .23318 .36171 .2163 .3318 Metetra
.617 .617 .828 r
.2163 .3318 .23318 .36171 .25955 .35569 .24286 .32386 Metetra
.615 .604 .817 r
.24286 .32386 .25955 .35569 .28624 .34957 .26973 .31583 Metetra
.612 .592 .806 r
.26973 .31583 .28624 .34957 .31328 .34333 .2969 .3077 Metetra
.61 .58 .795 r
.2969 .3077 .31328 .34333 .34065 .33699 .32439 .29947 Metetra
.608 .57 .786 r
.32439 .29947 .34065 .33699 .36838 .33052 .3522 .29114 Metetra
.606 .56 .777 r
.3522 .29114 .36838 .33052 .39646 .32393 .38034 .28271 Metetra
.604 .551 .768 r
.38034 .28271 .39646 .32393 .4249 .31721 .40881 .27417 Metetra
.602 .543 .761 r
.40881 .27417 .4249 .31721 .45371 .31036 .43762 .26552 Metetra
.6 .535 .754 r
.43762 .26552 .45371 .31036 .4829 .30337 .46677 .25677 Metetra
.598 .528 .747 r
.46677 .25677 .4829 .30337 .51246 .29622 .49628 .2479 Metetra
.596 .521 .741 r
.49628 .2479 .51246 .29622 .5424 .28893 .52614 .23892 Metetra
.594 .515 .735 r
.52614 .23892 .5424 .28893 .57274 .28148 .55636 .22982 Metetra
.593 .51 .73 r
.55636 .22982 .57274 .28148 .60347 .27386 .58695 .2206 Metetra
.592 .505 .725 r
.58695 .2206 .60347 .27386 .6346 .26608 .61792 .21126 Metetra
.59 .5 .721 r
.61792 .21126 .6346 .26608 .66614 .25812 .64927 .20179 Metetra
.589 .496 .717 r
.64927 .20179 .66614 .25812 .69809 .24998 .68101 .1922 Metetra
.588 .492 .713 r
.68101 .1922 .69809 .24998 .73046 .24166 .71315 .18248 Metetra
.656 .751 .92 r
.01926 .36806 .03853 .38488 .06309 .37755 .04421 .35883 Metetra
.655 .73 .905 r
.04421 .35883 .06309 .37755 .08792 .37014 .0694 .3495 Metetra
.653 .71 .89 r
.0694 .3495 .08792 .37014 .11303 .36265 .09485 .34007 Metetra
.65 .691 .875 r
.09485 .34007 .11303 .36265 .13841 .35507 .12055 .33055 Metetra
.647 .673 .861 r
.12055 .33055 .13841 .35507 .16408 .3474 .14652 .32094 Metetra
.644 .656 .847 r
.14652 .32094 .16408 .3474 .19005 .33965 .17275 .31122 Metetra
.641 .64 .834 r
.17275 .31122 .19005 .33965 .2163 .3318 .19925 .3014 Metetra
.637 .625 .822 r
.19925 .3014 .2163 .3318 .24286 .32386 .22603 .29149 Metetra
.634 .611 .81 r
.22603 .29149 .24286 .32386 .26973 .31583 .25309 .28147 Metetra
.63 .598 .799 r
.25309 .28147 .26973 .31583 .2969 .3077 .28043 .27134 Metetra
.627 .586 .789 r
.28043 .27134 .2969 .3077 .32439 .29947 .30805 .26111 Metetra
.624 .575 .779 r
.30805 .26111 .32439 .29947 .3522 .29114 .33597 .25077 Metetra
.621 .564 .769 r
.33597 .25077 .3522 .29114 .38034 .28271 .36418 .24032 Metetra
.618 .554 .761 r
.36418 .24032 .38034 .28271 .40881 .27417 .3927 .22976 Metetra
.615 .545 .752 r
.3927 .22976 .40881 .27417 .43762 .26552 .42152 .21908 Metetra
.612 .536 .745 r
.42152 .21908 .43762 .26552 .46677 .25677 .45066 .20829 Metetra
.609 .528 .737 r
.45066 .20829 .46677 .25677 .49628 .2479 .48011 .19739 Metetra
.607 .52 .73 r
.48011 .19739 .49628 .2479 .52614 .23892 .50988 .18636 Metetra
.604 .512 .724 r
.50988 .18636 .52614 .23892 .55636 .22982 .53998 .17521 Metetra
.602 .505 .717 r
.53998 .17521 .55636 .22982 .58695 .2206 .57041 .16394 Metetra
.6 .499 .711 r
.57041 .16394 .58695 .2206 .61792 .21126 .60118 .15255 Metetra
.597 .493 .706 r
.60118 .15255 .61792 .21126 .64927 .20179 .63229 .14103 Metetra
.595 .487 .7 r
.63229 .14103 .64927 .20179 .68101 .1922 .66375 .12937 Metetra
.593 .481 .695 r
.66375 .12937 .68101 .1922 .71315 .18248 .69556 .11759 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(0)] .02757 .24618 1 .93395 Mshowa
.23703 .17687 m
.2415 .18167 L
s
[(1)] .22808 .16727 .93173 1 Mshowa
.4535 .09211 m
.45758 .09725 L
s
[(2)] .44535 .08183 .79274 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(3)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.0759 .23997 m
.07874 .24269 L
s
.11524 .22456 m
.11804 .22733 L
s
.1552 .20892 m
.15797 .21172 L
s
.19579 .19302 m
.19852 .19586 L
s
.27893 .16047 m
.28157 .16339 L
s
.32151 .14379 m
.32411 .14675 L
s
.36479 .12685 m
.36734 .12985 L
s
.40878 .10962 m
.41128 .11266 L
s
.49897 .07431 m
.50137 .07743 L
s
.54521 .0562 m
.54755 .05937 L
s
.59224 .03779 m
.59452 .041 L
s
.64007 .01906 m
.64229 .02231 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.9.6"]
}, Open  ]],

Cell["\<\
This redraws the picture, with the view point directly in front. \
Notice the perspective effect that makes the back of the box look much \
smaller than the front. \
\>", "MathCaption",
  CellTags->{"S1.9.6", "6.10"}],

Cell[CellGroupData[{

Cell["Show[%, ViewPoint -> {0, -2, 0}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .4 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 -0.3 1 [
[-0.01161 -0.00464 -6 -6.3 ]
[-0.01161 -0.00464 0 2.7 ]
[.32533 -0.0096 -5.5 -9 ]
[.32533 -0.0096 .5 0 ]
[.67467 -0.0096 -0.5 -9 ]
[.67467 -0.0096 5.5 0 ]
[1.01161 -0.00464 0 -6.3 ]
[1.01161 -0.00464 6 2.7 ]
[0 .3875 -3 -9 ]
[0 .3875 3 0 ]
[.09091 .35114 -3 -9 ]
[.09091 .35114 3 0 ]
[.15385 .32596 -3 -9 ]
[.15385 .32596 3 0 ]
[.2 .3075 -3 -9 ]
[.2 .3075 3 0 ]
[-0.0125 .00946 -12 -4.5 ]
[-0.0125 .00946 0 4.5 ]
[-0.0125 .10472 -24 -4.5 ]
[-0.0125 .10472 0 4.5 ]
[-0.0125 .19997 -6 -4.5 ]
[-0.0125 .19997 0 4.5 ]
[-0.0125 .29523 -18 -4.5 ]
[-0.0125 .29523 0 4.5 ]
[-0.0125 .39048 -6 -4.5 ]
[-0.0125 .39048 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .40625 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
.0058 .00232 L
s
[(0)] -0.01161 -0.00464 1 .4 Mshowa
.33333 0 m
.33733 .0048 L
s
[(1)] .32533 -0.0096 .83333 1 Mshowa
.66667 0 m
.66267 .0048 L
s
[(2)] .67467 -0.0096 -0.83333 1 Mshowa
1 0 m
.9942 .00232 L
s
[(3)] 1.01161 -0.00464 -1 .4 Mshowa
.125 Mabswid
.06667 0 m
.07007 .00157 L
s
.13333 0 m
.13663 .0018 L
s
.2 0 m
.20312 .00208 L
s
.26667 0 m
.26951 .00244 L
s
.4 0 m
.40168 .00335 L
s
.46667 0 m
.46728 .0037 L
s
.53333 0 m
.53272 .0037 L
s
.6 0 m
.59832 .00335 L
s
.73333 0 m
.73049 .00244 L
s
.8 0 m
.79688 .00208 L
s
.86667 0 m
.86337 .0018 L
s
.93333 0 m
.92993 .00157 L
s
.25 Mabswid
0 .4 m
.2 .32 L
s
0 .4 m
0 .40625 L
s
[(0)] 0 .3875 0 1 Mshowa
.09091 .36364 m
.09091 .36989 L
s
[(1)] .09091 .35114 0 1 Mshowa
.15385 .33846 m
.15385 .34471 L
s
[(2)] .15385 .32596 0 1 Mshowa
.2 .32 m
.2 .32625 L
s
[(3)] .2 .3075 0 1 Mshowa
.125 Mabswid
.02128 .39149 m
.02128 .39524 L
s
.04082 .38367 m
.04082 .38742 L
s
.05882 .37647 m
.05882 .38022 L
s
.07547 .36981 m
.07547 .37356 L
s
.10526 .35789 m
.10526 .36164 L
s
.11864 .35254 m
.11864 .35629 L
s
.13115 .34754 m
.13115 .35129 L
s
.14286 .34286 m
.14286 .34661 L
s
.16418 .33433 m
.16418 .33808 L
s
.17391 .33043 m
.17391 .33418 L
s
.1831 .32676 m
.1831 .33051 L
s
.19178 .32329 m
.19178 .32704 L
s
.25 Mabswid
0 0 m
0 .4 L
s
0 .00946 m
.00625 .00946 L
s
[(-1)] -0.0125 .00946 1 0 Mshowa
0 .10472 m
.00625 .10472 L
s
[(-0.5)] -0.0125 .10472 1 0 Mshowa
0 .19997 m
.00625 .19997 L
s
[(0)] -0.0125 .19997 1 0 Mshowa
0 .29523 m
.00625 .29523 L
s
[(0.5)] -0.0125 .29523 1 0 Mshowa
0 .39048 m
.00625 .39048 L
s
[(1)] -0.0125 .39048 1 0 Mshowa
.125 Mabswid
0 .02852 m
.00375 .02852 L
s
0 .04757 m
.00375 .04757 L
s
0 .06662 m
.00375 .06662 L
s
0 .08567 m
.00375 .08567 L
s
0 .12377 m
.00375 .12377 L
s
0 .14282 m
.00375 .14282 L
s
0 .16187 m
.00375 .16187 L
s
0 .18092 m
.00375 .18092 L
s
0 .21902 m
.00375 .21902 L
s
0 .23808 m
.00375 .23808 L
s
0 .25713 m
.00375 .25713 L
s
0 .27618 m
.00375 .27618 L
s
0 .31428 m
.00375 .31428 L
s
0 .33333 m
.00375 .33333 L
s
0 .35238 m
.00375 .35238 L
s
0 .37143 m
.00375 .37143 L
s
.25 Mabswid
0 0 m
0 .4 L
s
0 .4 m
.2 .32 L
s
.2 .32 m
.2 .08 L
s
.2 .08 m
0 0 L
s
1 0 m
.8 .08 L
s
.8 .08 m
.8 .32 L
s
.8 .32 m
1 .4 L
s
1 .4 m
1 0 L
s
0 0 m
0 .4 L
s
0 .4 m
1 .4 L
s
1 .4 m
1 0 L
s
1 0 m
0 0 L
s
.2 .08 m
.8 .08 L
s
.8 .08 m
.8 .32 L
s
.8 .32 m
.2 .32 L
s
.2 .32 m
.2 .08 L
s
0 0 m
1 0 L
1 .4 L
0 .4 L
closepath
clip
newpath
.5 Mabswid
.829 .396 0 r
.19492 .19998 .2 .19998 .225 .24185 .22034 .24087 Metetra
.762 .303 0 r
.22034 .24087 .225 .24185 .25 .2779 .24576 .27652 Metetra
.635 .122 0 r
.24576 .27652 .25 .2779 .275 .30312 .27119 .3024 Metetra
.39 0 0 r
.27119 .3024 .275 .30312 .3 .314 .29661 .3152 Metetra
.011 0 0 r
.29661 .3152 .3 .314 .325 .30904 .32203 .31327 Metetra
.32203 .31327 .325 .30904 .35 .28892 .34746 .29687 Metetra
.34746 .29687 .35 .28892 .375 .25644 .37288 .26809 Metetra
.37288 .26809 .375 .25644 .4 .21612 .39831 .23061 Metetra
0 0 .049 r
.39831 .23061 .4 .21612 .425 .17355 .42373 .18921 Metetra
0 0 .106 r
.42373 .18921 .425 .17355 .45 .13465 .44915 .1492 Metetra
.001 0 .107 r
.44915 .1492 .45 .13465 .475 .10484 .47458 .11567 Metetra
.055 0 .012 r
.47458 .11567 .475 .10484 .5 .08825 .5 .09291 Metetra
.433 .169 .413 r
.77966 .30652 .775 .28196 .8 .24709 .80508 .28335 Metetra
.363 0 .089 r
.75424 .31607 .75 .30544 .775 .28196 .77966 .30652 Metetra
.136 .634 .909 r
.72881 .31079 .725 .31426 .75 .30544 .75424 .31607 Metetra
.336 .536 .901 r
.70339 .29135 .7 .3072 .725 .31426 .72881 .31079 Metetra
.349 .463 .836 r
.67797 .26024 .675 .28524 .7 .3072 .70339 .29135 Metetra
.336 .426 .806 r
.65254 .22143 .65 .25143 .675 .28524 .67797 .26024 Metetra
.314 .406 .797 r
.62712 .17988 .625 .21046 .65 .25143 .65254 .22143 Metetra
.285 .4 .804 r
.60169 .1409 .6 .16805 .625 .21046 .62712 .17988 Metetra
.247 .416 .833 r
.57627 .10947 .575 .13007 .6 .16805 .60169 .1409 Metetra
.191 .478 .894 r
.55085 .0896 .55 .1018 .575 .13007 .57627 .10947 Metetra
.073 .595 .877 r
.52542 .08384 .525 .08719 .55 .1018 .55085 .0896 Metetra
.062 0 0 r
.5 .09291 .5 .08825 .525 .08719 .52542 .08384 Metetra
.82 .38 0 r
.18966 .19998 .19492 .19998 .22034 .24087 .21552 .23984 Metetra
.754 .289 0 r
.21552 .23984 .22034 .24087 .24576 .27652 .24138 .27502 Metetra
.633 .121 0 r
.24138 .27502 .24576 .27652 .27119 .3024 .26724 .30143 Metetra
.417 0 0 r
.26724 .30143 .27119 .3024 .29661 .3152 .2931 .31597 Metetra
.087 0 0 r
.2931 .31597 .29661 .3152 .32203 .31327 .31897 .31694 Metetra
.31897 .31694 .32203 .31327 .34746 .29687 .34483 .30422 Metetra
.34483 .30422 .34746 .29687 .37288 .26809 .37069 .27931 Metetra
.37069 .27931 .37288 .26809 .39831 .23061 .39655 .24511 Metetra
0 0 .041 r
.39655 .24511 .39831 .23061 .42373 .18921 .42241 .20564 Metetra
0 0 .113 r
.42241 .20564 .42373 .18921 .44915 .1492 .44828 .1655 Metetra
.012 0 .137 r
.44828 .1655 .44915 .1492 .47458 .11567 .47414 .1294 Metetra
.067 0 .095 r
.47414 .1294 .47458 .11567 .5 .09291 .5 .10156 Metetra
.391 0 .111 r
.78448 .31807 .77966 .30652 .80508 .28335 .81034 .30908 Metetra
.105 .623 .886 r
.75862 .31324 .75424 .31607 .77966 .30652 .78448 .31807 Metetra
.348 .555 .912 r
.73276 .29516 .72881 .31079 .75424 .31607 .75862 .31324 Metetra
.37 .484 .845 r
.7069 .26595 .70339 .29135 .72881 .31079 .73276 .29516 Metetra
.363 .448 .814 r
.68103 .22902 .67797 .26024 .70339 .29135 .7069 .26595 Metetra
.347 .429 .804 r
.65517 .18869 .65254 .22143 .67797 .26024 .68103 .22902 Metetra
.324 .422 .808 r
.62931 .14968 .62712 .17988 .65254 .22143 .65517 .18869 Metetra
.293 .432 .83 r
.60345 .11656 .60169 .1409 .62712 .17988 .62931 .14968 Metetra
.25 .474 .88 r
.57759 .09319 .57627 .10947 .60169 .1409 .60345 .11656 Metetra
.166 .578 .935 r
.55172 .08233 .55085 .0896 .57627 .10947 .57759 .09319 Metetra
.017 0 0 r
.52586 .08523 .52542 .08384 .55085 .0896 .55172 .08233 Metetra
.093 0 0 r
.5 .10156 .5 .09291 .52542 .08384 .52586 .08523 Metetra
.811 .363 0 r
.18421 .19998 .18966 .19998 .21552 .23984 .21053 .23876 Metetra
.745 .274 0 r
.21053 .23876 .21552 .23984 .24138 .27502 .23684 .2734 Metetra
.629 .117 0 r
.23684 .2734 .24138 .27502 .26724 .30143 .26316 .3002 Metetra
.437 0 0 r
.26316 .3002 .26724 .30143 .2931 .31597 .28947 .31631 Metetra
.153 0 0 r
.28947 .31631 .2931 .31597 .31897 .31694 .31579 .32001 Metetra
.31579 .32001 .31897 .31694 .34483 .30422 .34211 .3109 Metetra
.34211 .3109 .34483 .30422 .37069 .27931 .36842 .28996 Metetra
.36842 .28996 .37069 .27931 .39655 .24511 .39474 .25941 Metetra
0 0 .028 r
.39474 .25941 .39655 .24511 .42241 .20564 .42105 .22253 Metetra
0 0 .114 r
.42105 .22253 .42241 .20564 .44828 .1655 .44737 .18323 Metetra
.026 0 .156 r
.44737 .18323 .44828 .1655 .47414 .1294 .47368 .14573 Metetra
.081 0 .149 r
.47368 .14573 .47414 .1294 .5 .10156 .5 .11401 Metetra
.126 .627 .905 r
.78947 .31468 .78448 .31807 .81034 .30908 .81579 .32028 Metetra
.364 .565 .914 r
.76316 .29683 .75862 .31324 .78448 .31807 .78947 .31468 Metetra
.391 .5 .85 r
.73684 .26866 .73276 .29516 .75862 .31324 .76316 .29683 Metetra
.388 .467 .82 r
.71053 .23316 .7069 .26595 .73276 .29516 .73684 .26866 Metetra
.376 .449 .809 r
.68421 .19411 .68103 .22902 .7069 .26595 .71053 .23316 Metetra
.357 .443 .812 r
.65789 .1557 .65517 .18869 .68103 .22902 .68421 .19411 Metetra
.333 .45 .83 r
.63158 .12201 .62931 .14968 .65517 .18869 .65789 .1557 Metetra
.299 .482 .871 r
.60526 .09664 .60345 .11656 .62931 .14968 .63158 .12201 Metetra
.237 .563 .937 r
.57895 .08229 .57759 .09319 .60345 .11656 .60526 .09664 Metetra
.073 .627 .815 r
.55263 .08051 .55172 .08233 .57759 .09319 .57895 .08229 Metetra
.1 0 0 r
.52632 .09147 .52586 .08523 .55172 .08233 .55263 .08051 Metetra
.117 0 .058 r
.5 .11401 .5 .10156 .52586 .08523 .52632 .09147 Metetra
.8 .344 0 r
.17857 .19998 .18421 .19998 .21053 .23876 .20536 .23764 Metetra
.734 .257 0 r
.20536 .23764 .21053 .23876 .23684 .2734 .23214 .27164 Metetra
.624 .11 0 r
.23214 .27164 .23684 .2734 .26316 .3002 .25893 .2987 Metetra
.451 0 0 r
.25893 .2987 .26316 .3002 .28947 .31631 .28571 .31621 Metetra
.207 0 0 r
.28571 .31621 .28947 .31631 .31579 .32001 .3125 .32245 Metetra
.3125 .32245 .31579 .32001 .34211 .3109 .33929 .31683 Metetra
.33929 .31683 .34211 .3109 .36842 .28996 .36607 .29989 Metetra
.36607 .29989 .36842 .28996 .39474 .25941 .39286 .27328 Metetra
0 0 .007 r
.39286 .27328 .39474 .25941 .42105 .22253 .41964 .23956 Metetra
0 0 .109 r
.41964 .23956 .42105 .22253 .44737 .18323 .44643 .20202 Metetra
.042 0 .167 r
.44643 .20202 .44737 .18323 .47368 .14573 .47321 .16427 Metetra
.097 0 .184 r
.47321 .16427 .47368 .14573 .5 .11401 .5 .12998 Metetra
.386 .566 .907 r
.79464 .29624 .78947 .31468 .81579 .32028 .82143 .31486 Metetra
.412 .511 .85 r
.76786 .26831 .76316 .29683 .78947 .31468 .79464 .29624 Metetra
.411 .483 .823 r
.74107 .23375 .73684 .26866 .76316 .29683 .76786 .26831 Metetra
.402 .467 .813 r
.71429 .19592 .71053 .23316 .73684 .26866 .74107 .23375 Metetra
.387 .462 .816 r
.6875 .15849 .68421 .19411 .71053 .23316 .71429 .19592 Metetra
.368 .469 .832 r
.66071 .12507 .65789 .1557 .68421 .19411 .6875 .15849 Metetra
.34 .496 .868 r
.63393 .09891 .63158 .12201 .65789 .1557 .66071 .12507 Metetra
.293 .562 .93 r
.60714 .08254 .60526 .09664 .63158 .12201 .63393 .09891 Metetra
.164 .654 .92 r
.58036 .07755 .57895 .08229 .60526 .09664 .60714 .08254 Metetra
.072 0 0 r
.55357 .08442 .55263 .08051 .57895 .08229 .58036 .07755 Metetra
.149 0 .002 r
.52679 .10248 .52632 .09147 .55263 .08051 .55357 .08442 Metetra
.137 0 .146 r
.5 .12998 .5 .11401 .52632 .09147 .52679 .10248 Metetra
.789 .323 0 r
.17273 .19998 .17857 .19998 .20536 .23764 .2 .23646 Metetra
.723 .239 0 r
.2 .23646 .20536 .23764 .23214 .27164 .22727 .26975 Metetra
.616 .101 0 r
.22727 .26975 .23214 .27164 .25893 .2987 .25455 .29693 Metetra
.46 0 0 r
.25455 .29693 .25893 .2987 .28571 .31621 .28182 .31563 Metetra
.25 0 0 r
.28182 .31563 .28571 .31621 .3125 .32245 .30909 .32421 Metetra
.03 0 0 r
.30909 .32421 .3125 .32245 .33929 .31683 .33636 .32193 Metetra
.33636 .32193 .33929 .31683 .36607 .29989 .36364 .30897 Metetra
.36364 .30897 .36607 .29989 .39286 .27328 .39091 .28648 Metetra
.39091 .28648 .39286 .27328 .41964 .23956 .41818 .25642 Metetra
0 0 .096 r
.41818 .25642 .41964 .23956 .44643 .20202 .44545 .22143 Metetra
.061 0 .17 r
.44545 .22143 .44643 .20202 .47321 .16427 .47273 .18456 Metetra
.114 0 .205 r
.47273 .18456 .47321 .16427 .5 .12998 .5 .14903 Metetra
.434 .519 .846 r
.8 .26462 .79464 .29624 .82143 .31486 .82727 .29299 Metetra
.434 .496 .824 r
.77273 .2306 .76786 .26831 .79464 .29624 .8 .26462 Metetra
.427 .484 .816 r
.74545 .1939 .74107 .23375 .76786 .26831 .77273 .2306 Metetra
.415 .481 .819 r
.71818 .15773 .71429 .19592 .74107 .23375 .74545 .1939 Metetra
.398 .488 .835 r
.69091 .12526 .6875 .15849 .71429 .19592 .71818 .15773 Metetra
.376 .513 .868 r
.66364 .09932 .66071 .12507 .6875 .15849 .69091 .12526 Metetra
.337 .57 .925 r
.63636 .0822 .63393 .09891 .66071 .12507 .66364 .09932 Metetra
.234 .664 .958 r
.60909 .07537 .60714 .08254 .63393 .09891 .63636 .0822 Metetra
.022 0 0 r
.58182 .07945 .58036 .07755 .60714 .08254 .60909 .07537 Metetra
.166 0 0 r
.55455 .09408 .55357 .08442 .58036 .07755 .58182 .07945 Metetra
.18 0 .134 r
.52727 .11797 .52679 .10248 .55357 .08442 .55455 .09408 Metetra
.156 0 .2 r
.5 .14903 .5 .12998 .52679 .10248 .52727 .11797 Metetra
.775 .301 0 r
.16667 .19998 .17273 .19998 .2 .23646 .19444 .23523 Metetra
.709 .218 0 r
.19444 .23523 .2 .23646 .22727 .26975 .22222 .26772 Metetra
.607 .088 0 r
.22222 .26772 .22727 .26975 .25455 .29693 .25 .29487 Metetra
.463 0 0 r
.25 .29487 .25455 .29693 .28182 .31563 .27778 .31458 Metetra
.281 0 0 r
.27778 .31458 .28182 .31563 .30909 .32421 .30556 .32527 Metetra
.089 0 0 r
.30556 .32527 .30909 .32421 .33636 .32193 .33333 .32612 Metetra
.33333 .32612 .33636 .32193 .36364 .30897 .36111 .31706 Metetra
.36111 .31706 .36364 .30897 .39091 .28648 .38889 .2988 Metetra
.38889 .2988 .39091 .28648 .41818 .25642 .41667 .27278 Metetra
.023 0 .075 r
.41667 .27278 .41818 .25642 .44545 .22143 .44444 .24103 Metetra
.081 0 .164 r
.44444 .24103 .44545 .22143 .47273 .18456 .47222 .20606 Metetra
.133 0 .216 r
.47222 .20606 .47273 .18456 .5 .14903 .5 .17061 Metetra
.455 .507 .823 r
.80556 .22342 .8 .26462 .82727 .29299 .83333 .25714 Metetra
.449 .499 .818 r
.77778 .18785 .77273 .2306 .8 .26462 .80556 .22342 Metetra
.44 .498 .823 r
.75 .15324 .74545 .1939 .77273 .2306 .77778 .18785 Metetra
.426 .507 .839 r
.72222 .1223 .71818 .15773 .74545 .1939 .75 .15324 Metetra
.407 .532 .871 r
.69444 .09746 .69091 .12526 .71818 .15773 .72222 .1223 Metetra
.374 .586 .926 r
.66667 .08068 .66364 .09932 .69091 .12526 .69444 .09746 Metetra
.285 .676 .972 r
.63889 .07328 .63636 .0822 .66364 .09932 .66667 .08068 Metetra
.61111 .07583 .60909 .07537 .63636 .0822 .63889 .07328 Metetra
.174 0 0 r
.58333 .08814 .58182 .07945 .60909 .07537 .61111 .07583 Metetra
.216 0 .122 r
.55556 .10924 .55455 .09408 .58182 .07945 .58333 .08814 Metetra
.206 0 .211 r
.52778 .13747 .52727 .11797 .55455 .09408 .55556 .10924 Metetra
.175 0 .233 r
.5 .17061 .5 .14903 .52727 .11797 .52778 .13747 Metetra
.761 .276 0 r
.16038 .19998 .16667 .19998 .19444 .23523 .18868 .23395 Metetra
.694 .195 0 r
.18868 .23395 .19444 .23523 .22222 .26772 .21698 .26554 Metetra
.595 .073 0 r
.21698 .26554 .22222 .26772 .25 .29487 .24528 .29253 Metetra
.462 0 0 r
.24528 .29253 .25 .29487 .27778 .31458 .27358 .31302 Metetra
.303 0 0 r
.27358 .31302 .27778 .31458 .30556 .32527 .30189 .32559 Metetra
.138 0 0 r
.30189 .32559 .30556 .32527 .33333 .32612 .33019 .32935 Metetra
.015 0 0 r
.33019 .32935 .33333 .32612 .36111 .31706 .35849 .32403 Metetra
.35849 .32403 .36111 .31706 .38889 .2988 .38679 .31002 Metetra
.38679 .31002 .38889 .2988 .41667 .27278 .41509 .28828 Metetra
.048 0 .043 r
.41509 .28828 .41667 .27278 .44444 .24103 .4434 .26035 Metetra
.103 0 .149 r
.4434 .26035 .44444 .24103 .47222 .20606 .4717 .22819 Metetra
.153 0 .216 r
.4717 .22819 .47222 .20606 .5 .17061 .5 .19404 Metetra
.471 .514 .82 r
.81132 .1776 .80556 .22342 .83333 .25714 .83962 .21185 Metetra
.463 .516 .827 r
.78302 .14493 .77778 .18785 .80556 .22342 .81132 .1776 Metetra
.451 .528 .845 r
.75472 .11612 .75 .15324 .77778 .18785 .78302 .14493 Metetra
.434 .555 .878 r
.72642 .09319 .72222 .1223 .75 .15324 .75472 .11612 Metetra
.404 .609 .932 r
.69811 .07775 .69444 .09746 .72222 .1223 .72642 .09319 Metetra
.318 .694 .979 r
.66981 .07089 .66667 .08068 .69444 .09746 .69811 .07775 Metetra
.64151 .07308 .63889 .07328 .66667 .08068 .66981 .07089 Metetra
.183 0 0 r
.61321 .08417 .61111 .07583 .63889 .07328 .64151 .07308 Metetra
.246 0 .118 r
.58491 .10338 .58333 .08814 .61111 .07583 .61321 .08417 Metetra
.249 0 .222 r
.5566 .12937 .55556 .10924 .58333 .08814 .58491 .10338 Metetra
.228 0 .256 r
.5283 .16032 .52778 .13747 .55556 .10924 .5566 .12937 Metetra
.196 0 .251 r
.5 .19404 .5 .17061 .52778 .13747 .5283 .16032 Metetra
.744 .25 0 r
.15385 .19998 .16038 .19998 .18868 .23395 .18269 .23261 Metetra
.678 .17 0 r
.18269 .23261 .18868 .23395 .21698 .26554 .21154 .26321 Metetra
.581 .055 0 r
.21154 .26321 .21698 .26554 .24528 .29253 .24038 .28988 Metetra
.457 0 0 r
.24038 .28988 .24528 .29253 .27358 .31302 .26923 .31096 Metetra
.316 0 0 r
.26923 .31096 .27358 .31302 .30189 .32559 .29808 .32514 Metetra
.174 0 0 r
.29808 .32514 .30189 .32559 .33019 .32935 .32692 .33154 Metetra
.063 0 0 r
.32692 .33154 .33019 .32935 .35849 .32403 .35577 .32976 Metetra
.016 0 0 r
.35577 .32976 .35849 .32403 .38679 .31002 .38462 .31991 Metetra
.03 0 0 r
.38462 .31991 .38679 .31002 .41509 .28828 .41346 .3026 Metetra
.075 0 0 r
.41346 .3026 .41509 .28828 .4434 .26035 .44231 .27891 Metetra
.126 0 .123 r
.44231 .27891 .4434 .26035 .4717 .22819 .47115 .25032 Metetra
.175 0 .207 r
.47115 .25032 .4717 .22819 .5 .19404 .5 .21859 Metetra
.485 .535 .833 r
.81731 .13294 .81132 .1776 .83962 .21185 .84615 .16313 Metetra
.475 .55 .853 r
.78846 .10693 .78302 .14493 .81132 .1776 .81731 .13294 Metetra
.459 .581 .889 r
.75962 .0867 .75472 .11612 .78302 .14493 .78846 .10693 Metetra
.427 .639 .945 r
.73077 .07351 .72642 .09319 .75472 .11612 .75962 .0867 Metetra
.331 .719 .983 r
.70192 .06818 .69811 .07775 .72642 .09319 .73077 .07351 Metetra
.67308 .07105 .66981 .07089 .69811 .07775 .70192 .06818 Metetra
.205 0 0 r
.64423 .08194 .64151 .07308 .66981 .07089 .67308 .07105 Metetra
.277 0 .131 r
.61538 .10017 .61321 .08417 .64151 .07308 .64423 .08194 Metetra
.288 0 .238 r
.58654 .1246 .58491 .10338 .61321 .08417 .61538 .10017 Metetra
.275 0 .278 r
.55769 .15372 .5566 .12937 .58491 .10338 .58654 .1246 Metetra
.25 0 .281 r
.52885 .18571 .5283 .16032 .5566 .12937 .55769 .15372 Metetra
.217 0 .258 r
.5 .21859 .5 .19404 .5283 .16032 .52885 .18571 Metetra
.726 .22 0 r
.14706 .19998 .15385 .19998 .18269 .23261 .17647 .23121 Metetra
.658 .143 0 r
.17647 .23121 .18269 .23261 .21154 .26321 .20588 .26073 Metetra
.564 .034 0 r
.20588 .26073 .21154 .26321 .24038 .28988 .23529 .28693 Metetra
.448 0 0 r
.23529 .28693 .24038 .28988 .26923 .31096 .26471 .30838 Metetra
0 .249 .634 r
.26471 .30838 .26923 .31096 .29808 .32514 .29412 .3239 Metetra
0 .392 .681 r
.29412 .3239 .29808 .32514 .32692 .33154 .32353 .33264 Metetra
.101 0 0 r
.32353 .33264 .32692 .33154 .35577 .32976 .35294 .33413 Metetra
.055 0 0 r
.35294 .33413 .35577 .32976 .38462 .31991 .38235 .32828 Metetra
.062 0 0 r
.38235 .32828 .38462 .31991 .41346 .3026 .41176 .31542 Metetra
.101 0 0 r
.41176 .31542 .41346 .3026 .44231 .27891 .44118 .29625 Metetra
.15 0 .083 r
.44118 .29625 .44231 .27891 .47115 .25032 .47059 .27181 Metetra
.197 0 .185 r
.47059 .27181 .47115 .25032 .5 .21859 .5 .24344 Metetra
.496 .576 .866 r
.82353 .09527 .81731 .13294 .84615 .16313 .85294 .11772 Metetra
.479 .613 .906 r
.79412 .07854 .78846 .10693 .81731 .13294 .82353 .09527 Metetra
.441 .678 .964 r
.76471 .06844 .75962 .0867 .78846 .10693 .79412 .07854 Metetra
.312 .744 .97 r
.73529 .06555 .73077 .07351 .75962 .0867 .76471 .06844 Metetra
.018 0 0 r
.70588 .07 .70192 .06818 .73077 .07351 .73529 .06555 Metetra
.245 0 0 r
.67647 .08156 .67308 .07105 .70192 .06818 .70588 .07 Metetra
.312 0 .164 r
.64706 .09959 .64423 .08194 .67308 .07105 .67647 .08156 Metetra
.325 .006 .261 r
.61765 .12312 .61538 .10017 .64423 .08194 .64706 .09959 Metetra
.318 .025 .301 r
.58824 .15085 .58654 .1246 .61538 .10017 .61765 .12312 Metetra
.299 .018 .308 r
.55882 .18126 .55769 .15372 .58654 .1246 .58824 .15085 Metetra
.272 0 .292 r
.52941 .2127 .52885 .18571 .55769 .15372 .55882 .18126 Metetra
.238 0 .252 r
.5 .24344 .5 .21859 .52885 .18571 .52941 .2127 Metetra
.705 .189 0 r
.14 .19998 .14706 .19998 .17647 .23121 .17 .22975 Metetra
.637 .112 0 r
.17 .22975 .17647 .23121 .20588 .26073 .2 .2581 Metetra
.545 .009 0 r
.2 .2581 .20588 .26073 .23529 .28693 .23 .28367 Metetra
.435 0 0 r
.23 .28367 .23529 .28693 .26471 .30838 .26 .30526 Metetra
0 .245 .641 r
.26 .30526 .26471 .30838 .29412 .3239 .29 .32183 Metetra
0 .371 .693 r
.29 .32183 .29412 .3239 .32353 .33264 .32 .3326 Metetra
.127 0 0 r
.32 .3326 .32353 .33264 .35294 .33413 .35 .33704 Metetra
.084 0 0 r
.35 .33704 .35294 .33413 .38235 .32828 .38 .33495 Metetra
.089 0 0 r
.38 .33495 .38235 .32828 .41176 .31542 .41 .32643 Metetra
.125 0 0 r
.41 .32643 .41176 .31542 .44118 .29625 .44 .31188 Metetra
.173 0 .023 r
.44 .31188 .44118 .29625 .47059 .27181 .47 .292 Metetra
.219 0 .148 r
.47 .292 .47059 .27181 .5 .24344 .5 .26773 Metetra
.493 .656 .933 r
.83 .06973 .82353 .09527 .85294 .11772 .86 .08216 Metetra
.434 .729 .988 r
.8 .0635 .79412 .07854 .82353 .09527 .83 .06973 Metetra
.226 .733 .892 r
.77 .06378 .76471 .06844 .79412 .07854 .8 .0635 Metetra
.13 0 0 r
.74 .07055 .73529 .06555 .76471 .06844 .77 .06378 Metetra
.299 0 .037 r
.71 .08349 .70588 .07 .73529 .06555 .74 .07055 Metetra
.35 0 .214 r
.68 .10198 .67647 .08156 .70588 .07 .71 .08349 Metetra
.362 .049 .293 r
.65 .12514 .64706 .09959 .67647 .08156 .68 .10198 Metetra
.357 .066 .327 r
.62 .15187 .61765 .12312 .64706 .09959 .65 .12514 Metetra
.343 .061 .334 r
.59 .18089 .58824 .15085 .61765 .12312 .62 .15187 Metetra
.321 .04 .321 r
.56 .21082 .55882 .18126 .58824 .15085 .59 .18089 Metetra
.294 .003 .288 r
.53 .24023 .52941 .2127 .55882 .18126 .56 .21082 Metetra
.259 0 .233 r
.5 .26773 .5 .24344 .52941 .2127 .53 .24023 Metetra
.681 .154 0 r
.13265 .19998 .14 .19998 .17 .22975 .16327 .22822 Metetra
.613 .078 0 r
.16327 .22822 .17 .22975 .2 .2581 .19388 .25529 Metetra
.522 0 0 r
.19388 .25529 .2 .2581 .23 .28367 .22449 .28009 Metetra
.418 0 0 r
.22449 .28009 .23 .28367 .26 .30526 .2551 .3016 Metetra
0 .248 .652 r
.2551 .3016 .26 .30526 .29 .32183 .28571 .31893 Metetra
0 .359 .705 r
.28571 .31893 .29 .32183 .32 .3326 .31633 .33136 Metetra
0 .448 .707 r
.31633 .33136 .32 .3326 .35 .33704 .34694 .3384 Metetra
.102 0 0 r
.34694 .3384 .35 .33704 .38 .33495 .37755 .33974 Metetra
.106 0 0 r
.37755 .33974 .38 .33495 .41 .32643 .40816 .33534 Metetra
.142 0 0 r
.40816 .33534 .41 .32643 .44 .31188 .43878 .32537 Metetra
.191 0 0 r
.43878 .32537 .44 .31188 .47 .292 .46939 .31024 Metetra
.238 0 .089 r
.46939 .31024 .47 .292 .5 .26773 .5 .29059 Metetra
.364 .774 .981 r
.83673 .06013 .83 .06973 .86 .08216 .86735 .06186 Metetra
.80612 .06415 .8 .0635 .83 .06973 .83673 .06013 Metetra
.259 0 0 r
.77551 .07375 .77 .06378 .8 .0635 .80612 .06415 Metetra
.359 0 .154 r
.7449 .08855 .74 .07055 .77 .06378 .77551 .07375 Metetra
.391 .057 .273 r
.71429 .10792 .71 .08349 .74 .07055 .7449 .08855 Metetra
.399 .095 .33 r
.68367 .13108 .68 .10198 .71 .08349 .71429 .10792 Metetra
.394 .108 .355 r
.65306 .15708 .65 .12514 .68 .10198 .68367 .13108 Metetra
.383 .103 .359 r
.62245 .18484 .62 .15187 .65 .12514 .65306 .15708 Metetra
.365 .084 .346 r
.59184 .21322 .59 .18089 .62 .15187 .62245 .18484 Metetra
.343 .051 .317 r
.56122 .24105 .56 .21082 .59 .18089 .59184 .21322 Metetra
.314 .004 .269 r
.53061 .2672 .53 .24023 .56 .21082 .56122 .24105 Metetra
.28 0 .196 r
.5 .29059 .5 .26773 .53 .24023 .53061 .2672 Metetra
.654 .116 0 r
.125 .19998 .13265 .19998 .16327 .22822 .15625 .22661 Metetra
.585 .041 0 r
.15625 .22661 .16327 .22822 .19388 .25529 .1875 .25231 Metetra
.496 0 0 r
.1875 .25231 .19388 .25529 .22449 .28009 .21875 .27618 Metetra
0 .154 .586 r
.21875 .27618 .22449 .28009 .2551 .3016 .25 .29737 Metetra
0 .259 .666 r
.25 .29737 .2551 .3016 .28571 .31893 .28125 .31515 Metetra
0 .356 .72 r
.28125 .31515 .28571 .31893 .31633 .33136 .3125 .3289 Metetra
0 .437 .735 r
.3125 .3289 .31633 .33136 .34694 .3384 .34375 .33812 Metetra
.106 0 0 r
.34375 .33812 .34694 .3384 .37755 .33974 .375 .3425 Metetra
.11 0 0 r
.375 .3425 .37755 .33974 .40816 .33534 .40625 .34189 Metetra
.147 0 0 r
.40625 .34189 .40816 .33534 .43878 .32537 .4375 .3363 Metetra
.2 0 0 r
.4375 .3363 .43878 .32537 .46939 .31024 .46875 .32593 Metetra
.252 0 .003 r
.46875 .32593 .46939 .31024 .5 .29059 .5 .31115 Metetra
.23 0 0 r
.84375 .06837 .83673 .06013 .86735 .06186 .875 .06031 Metetra
.368 0 .116 r
.8125 .08105 .80612 .06415 .83673 .06013 .84375 .06837 Metetra
.415 .066 .261 r
.78125 .09789 .77551 .07375 .80612 .06415 .8125 .08105 Metetra
.432 .119 .333 r
.75 .11831 .7449 .08855 .77551 .07375 .78125 .09789 Metetra
.435 .143 .368 r
.71875 .1416 .71429 .10792 .7449 .08855 .75 .11831 Metetra
.43 .149 .383 r
.6875 .16693 .68367 .13108 .71429 .10792 .71875 .1416 Metetra
.42 .142 .382 r
.65625 .19342 .65306 .15708 .68367 .13108 .6875 .16693 Metetra
.405 .123 .369 r
.625 .22014 .62245 .18484 .65306 .15708 .65625 .19342 Metetra
.387 .094 .341 r
.59375 .24616 .59184 .21322 .62245 .18484 .625 .22014 Metetra
.363 .052 .297 r
.5625 .27055 .56122 .24105 .59184 .21322 .59375 .24616 Metetra
.333 0 .232 r
.53125 .29247 .53061 .2672 .56122 .24105 .5625 .27055 Metetra
.297 0 .137 r
.5 .31115 .5 .29059 .53061 .2672 .53125 .29247 Metetra
.624 .075 0 r
.11702 .19998 .125 .19998 .15625 .22661 .14894 .22494 Metetra
.554 .001 0 r
.14894 .22494 .15625 .22661 .1875 .25231 .18085 .24916 Metetra
.466 0 0 r
.18085 .24916 .1875 .25231 .21875 .27618 .21277 .27193 Metetra
0 .182 .608 r
.21277 .27193 .21875 .27618 .25 .29737 .24468 .29258 Metetra
0 .276 .683 r
.24468 .29258 .25 .29737 .28125 .31515 .2766 .31051 Metetra
0 .362 .736 r
.2766 .31051 .28125 .31515 .3125 .3289 .30851 .32517 Metetra
0 .434 .76 r
.30851 .32517 .3125 .3289 .34375 .33812 .34043 .33615 Metetra
0 .484 .743 r
.34043 .33615 .34375 .33812 .375 .3425 .37234 .34311 Metetra
.098 0 0 r
.37234 .34311 .375 .3425 .40625 .34189 .40426 .34586 Metetra
.133 0 0 r
.40426 .34586 .40625 .34189 .4375 .3363 .43617 .34431 Metetra
.191 0 0 r
.43617 .34431 .4375 .3363 .46875 .32593 .46809 .3385 Metetra
.252 0 0 r
.46809 .3385 .46875 .32593 .5 .31115 .5 .32861 Metetra
.444 .094 .276 r
.85106 .09414 .84375 .06837 .875 .06031 .88298 .07852 Metetra
.463 .149 .348 r
.81915 .11288 .8125 .08105 .84375 .06837 .85106 .09414 Metetra
.47 .177 .386 r
.78723 .13418 .78125 .09789 .8125 .08105 .81915 .11288 Metetra
.469 .188 .404 r
.75532 .15743 .75 .11831 .78125 .09789 .78723 .13418 Metetra
.463 .188 .409 r
.7234 .18193 .71875 .1416 .75 .11831 .75532 .15743 Metetra
.454 .178 .403 r
.69149 .20696 .6875 .16693 .71875 .1416 .7234 .18193 Metetra
.442 .159 .387 r
.65957 .23178 .65625 .19342 .6875 .16693 .69149 .20696 Metetra
.426 .131 .359 r
.62766 .25567 .625 .22014 .65625 .19342 .65957 .23178 Metetra
.405 .091 .316 r
.59574 .27792 .59375 .24616 .625 .22014 .62766 .25567 Metetra
.38 .038 .255 r
.56383 .29787 .5625 .27055 .59375 .24616 .59574 .27792 Metetra
.347 0 .167 r
.53191 .31494 .53125 .29247 .5625 .27055 .56383 .29787 Metetra
.305 0 .043 r
.5 .32861 .5 .31115 .53125 .29247 .53191 .31494 Metetra
.591 .03 0 r
.1087 .19998 .11702 .19998 .14894 .22494 .1413 .22318 Metetra
.519 0 0 r
.1413 .22318 .14894 .22494 .18085 .24916 .17391 .24582 Metetra
.432 0 0 r
.17391 .24582 .18085 .24916 .21277 .27193 .20652 .26734 Metetra
0 .216 .632 r
.20652 .26734 .21277 .27193 .24468 .29258 .23913 .28721 Metetra
0 .3 .703 r
.23913 .28721 .24468 .29258 .2766 .31051 .27174 .30497 Metetra
0 .377 .755 r
.27174 .30497 .2766 .31051 .30851 .32517 .30435 .32016 Metetra
0 .441 .784 r
.30435 .32016 .30851 .32517 .34043 .33615 .33696 .33243 Metetra
0 .488 .784 r
.33696 .33243 .34043 .33615 .37234 .34311 .36957 .34147 Metetra
0 .51 .744 r
.36957 .34147 .37234 .34311 .40426 .34586 .40217 .34706 Metetra
.099 0 0 r
.40217 .34706 .40426 .34586 .43617 .34431 .43478 .34907 Metetra
.158 0 0 r
.43478 .34907 .43617 .34431 .46809 .3385 .46739 .34744 Metetra
.229 0 0 r
.46739 .34744 .46809 .3385 .5 .32861 .5 .34223 Metetra
.503 .216 .411 r
.8587 .13484 .85106 .09414 .88298 .07852 .8913 .11476 Metetra
.503 .227 .428 r
.82609 .1565 .81915 .11288 .85106 .09414 .8587 .13484 Metetra
.5 .229 .434 r
.79348 .17923 .78723 .13418 .81915 .11288 .82609 .1565 Metetra
.495 .223 .431 r
.76087 .20245 .75532 .15743 .78723 .13418 .79348 .17923 Metetra
.486 .21 .42 r
.72826 .22562 .7234 .18193 .75532 .15743 .76087 .20245 Metetra
.475 .189 .4 r
.69565 .24816 .69149 .20696 .7234 .18193 .72826 .22562 Metetra
.46 .161 .37 r
.66304 .26953 .65957 .23178 .69149 .20696 .69565 .24816 Metetra
.442 .122 .326 r
.63043 .28921 .62766 .25567 .65957 .23178 .66304 .26953 Metetra
.419 .07 .265 r
.59783 .30671 .59574 .27792 .62766 .25567 .63043 .28921 Metetra
.389 .002 .179 r
.56522 .32161 .56383 .29787 .59574 .27792 .59783 .30671 Metetra
.349 0 .06 r
.53261 .33355 .53191 .31494 .56383 .29787 .56522 .32161 Metetra
.296 0 0 r
.5 .34223 .5 .32861 .53191 .31494 .53261 .33355 Metetra
.553 0 0 r
.1 .19998 .1087 .19998 .1413 .22318 .13333 .22134 Metetra
.48 0 0 r
.13333 .22134 .1413 .22318 .17391 .24582 .16667 .24228 Metetra
.394 0 0 r
.16667 .24228 .17391 .24582 .20652 .26734 .2 .26239 Metetra
0 .254 .659 r
.2 .26239 .20652 .26734 .23913 .28721 .23333 .28126 Metetra
0 .33 .726 r
.23333 .28126 .23913 .28721 .27174 .30497 .26667 .29853 Metetra
0 .398 .777 r
.26667 .29853 .27174 .30497 .30435 .32016 .3 .31385 Metetra
0 .455 .808 r
.3 .31385 .30435 .32016 .33696 .33243 .33333 .32692 Metetra
0 .5 .82 r
.33333 .32692 .33696 .33243 .36957 .34147 .36667 .33749 Metetra
0 .527 .805 r
.36667 .33749 .36957 .34147 .40217 .34706 .4 .34534 Metetra
0 .53 .753 r
.4 .34534 .40217 .34706 .43478 .34907 .43333 .35033 Metetra
.097 0 0 r
.43333 .35033 .43478 .34907 .46739 .34744 .46667 .35234 Metetra
.171 0 0 r
.46667 .35234 .46739 .34744 .5 .34223 .5 .35135 Metetra
.533 .267 .458 r
.86667 .18586 .8587 .13484 .8913 .11476 .9 .16473 Metetra
.529 .262 .455 r
.83333 .20727 .82609 .1565 .8587 .13484 .86667 .18586 Metetra
.523 .252 .445 r
.8 .22853 .79348 .17923 .82609 .1565 .83333 .20727 Metetra
.515 .236 .429 r
.76667 .24923 .76087 .20245 .79348 .17923 .8 .22853 Metetra
.504 .213 .405 r
.73333 .26896 .72826 .22562 .76087 .20245 .76667 .24923 Metetra
.491 .183 .371 r
.7 .28733 .69565 .24816 .72826 .22562 .73333 .26896 Metetra
.474 .143 .324 r
.66667 .30397 .66304 .26953 .69565 .24816 .7 .28733 Metetra
.452 .09 .26 r
.63333 .31856 .63043 .28921 .66304 .26953 .66667 .30397 Metetra
.422 .021 .171 r
.6 .33081 .59783 .30671 .63043 .28921 .63333 .31856 Metetra
.381 0 .051 r
.56667 .34048 .56522 .32161 .59783 .30671 .6 .33081 Metetra
.325 0 0 r
.53333 .34737 .53261 .33355 .56522 .32161 .56667 .34048 Metetra
.252 0 0 r
.5 .35135 .5 .34223 .53261 .33355 .53333 .34737 Metetra
.51 0 0 r
.09091 .19998 .1 .19998 .13333 .22134 .125 .21941 Metetra
.435 0 0 r
.125 .21941 .13333 .22134 .16667 .24228 .15909 .23854 Metetra
.351 0 0 r
.15909 .23854 .16667 .24228 .2 .26239 .19318 .25707 Metetra
0 .297 .687 r
.19318 .25707 .2 .26239 .23333 .28126 .22727 .27471 Metetra
0 .366 .752 r
.22727 .27471 .23333 .28126 .26667 .29853 .26136 .29118 Metetra
0 .427 .8 r
.26136 .29118 .26667 .29853 .3 .31385 .29545 .30623 Metetra
0 .478 .833 r
.29545 .30623 .3 .31385 .33333 .32692 .32955 .31962 Metetra
0 .518 .851 r
.32955 .31962 .33333 .32692 .36667 .33749 .36364 .33114 Metetra
.016 .547 .852 r
.36364 .33114 .36667 .33749 .4 .34534 .39773 .34062 Metetra
.013 .561 .832 r
.39773 .34062 .4 .34534 .43333 .35033 .43182 .3479 Metetra
0 .553 .779 r
.43182 .3479 .43333 .35033 .46667 .35234 .46591 .35287 Metetra
.076 0 0 r
.46591 .35287 .46667 .35234 .5 .35135 .5 .35546 Metetra
.554 .287 .465 r
.875 .24104 .86667 .18586 .9 .16473 .90909 .22198 Metetra
.548 .272 .449 r
.84091 .25947 .83333 .20727 .86667 .18586 .875 .24104 Metetra
.54 .253 .428 r
.80682 .27697 .8 .22853 .83333 .20727 .84091 .25947 Metetra
.529 .227 .398 r
.77273 .29326 .76667 .24923 .8 .22853 .80682 .27697 Metetra
.516 .193 .358 r
.73864 .3081 .73333 .26896 .76667 .24923 .77273 .29326 Metetra
.499 .149 .304 r
.70455 .32126 .7 .28733 .73333 .26896 .73864 .3081 Metetra
.475 .091 .232 r
.67045 .33252 .66667 .30397 .7 .28733 .70455 .32126 Metetra
.442 .017 .134 r
.63636 .34171 .63333 .31856 .66667 .30397 .67045 .33252 Metetra
.396 0 .004 r
.60227 .34869 .6 .33081 .63333 .31856 .63636 .34171 Metetra
.333 0 0 r
.56818 .35335 .56667 .34048 .6 .33081 .60227 .34869 Metetra
.25 0 0 r
.53409 .35562 .53333 .34737 .56667 .34048 .56818 .35335 Metetra
.159 0 0 r
.5 .35546 .5 .35135 .53333 .34737 .53409 .35562 Metetra
.462 0 0 r
.0814 .19998 .09091 .19998 .125 .21941 .11628 .21739 Metetra
.386 0 0 r
.11628 .21739 .125 .21941 .15909 .23854 .15116 .23459 Metetra
0 .274 .642 r
.15116 .23459 .15909 .23854 .19318 .25707 .18605 .25138 Metetra
0 .344 .717 r
.18605 .25138 .19318 .25707 .22727 .27471 .22093 .26755 Metetra
0 .408 .778 r
.22093 .26755 .22727 .27471 .26136 .29118 .25581 .28292 Metetra
0 .462 .825 r
.25581 .28292 .26136 .29118 .29545 .30623 .2907 .29729 Metetra
0 .507 .858 r
.2907 .29729 .29545 .30623 .32955 .31962 .32558 .31051 Metetra
.042 .544 .879 r
.32558 .31051 .32955 .31962 .36364 .33114 .36047 .3224 Metetra
.07 .572 .889 r
.36047 .3224 .36364 .33114 .39773 .34062 .39535 .33283 Metetra
.08 .591 .887 r
.39535 .33283 .39773 .34062 .43182 .3479 .43023 .34167 Metetra
.07 .598 .868 r
.43023 .34167 .43182 .3479 .46591 .35287 .46512 .34881 Metetra
.036 .589 .826 r
.46512 .34881 .46591 .35287 .5 .35546 .5 .35418 Metetra
.569 .281 .438 r
.88372 .29342 .875 .24104 .90909 .22198 .9186 .27876 Metetra
.56 .256 .409 r
.84884 .30697 .84091 .25947 .875 .24104 .88372 .29342 Metetra
.548 .224 .371 r
.81395 .31925 .80682 .27697 .84091 .25947 .84884 .30697 Metetra
.533 .183 .321 r
.77907 .33009 .77273 .29326 .80682 .27697 .81395 .31925 Metetra
.512 .131 .254 r
.74419 .33938 .73864 .3081 .77273 .29326 .77907 .33009 Metetra
.483 .063 .166 r
.7093 .34701 .70455 .32126 .73864 .3081 .74419 .33938 Metetra
.442 0 .05 r
.67442 .35288 .67045 .33252 .70455 .32126 .7093 .34701 Metetra
.383 0 0 r
.63953 .35692 .63636 .34171 .67045 .33252 .67442 .35288 Metetra
.304 0 0 r
.60465 .35909 .60227 .34869 .63636 .34171 .63953 .35692 Metetra
.208 0 0 r
.56977 .35935 .56818 .35335 .60227 .34869 .60465 .35909 Metetra
.109 0 0 r
.53488 .35771 .53409 .35562 .56818 .35335 .56977 .35935 Metetra
0 .554 .749 r
.5 .35418 .5 .35546 .53409 .35562 .53488 .35771 Metetra
.409 0 0 r
.07143 .19998 .0814 .19998 .11628 .21739 .10714 .21526 Metetra
.332 0 0 r
.10714 .21526 .11628 .21739 .15116 .23459 .14286 .23042 Metetra
0 .33 .676 r
.14286 .23042 .15116 .23459 .18605 .25138 .17857 .2453 Metetra
0 .396 .748 r
.17857 .2453 .18605 .25138 .22093 .26755 .21429 .25979 Metetra
0 .454 .806 r
.21429 .25979 .22093 .26755 .25581 .28292 .25 .27375 Metetra
0 .503 .85 r
.25 .27375 .25581 .28292 .2907 .29729 .28571 .28706 Metetra
.046 .543 .883 r
.28571 .28706 .2907 .29729 .32558 .31051 .32143 .29961 Metetra
.093 .575 .905 r
.32143 .29961 .32558 .31051 .36047 .3224 .35714 .31128 Metetra
.127 .601 .918 r
.35714 .31128 .36047 .3224 .39535 .33283 .39286 .32198 Metetra
.148 .621 .925 r
.39286 .32198 .39535 .33283 .43023 .34167 .42857 .33161 Metetra
.154 .634 .924 r
.42857 .33161 .43023 .34167 .46512 .34881 .46429 .34007 Metetra
.145 .64 .913 r
.46429 .34007 .46512 .34881 .5 .35418 .5 .34731 Metetra
.571 .233 .358 r
.89286 .33608 .88372 .29342 .9186 .27876 .92857 .32703 Metetra
.555 .191 .304 r
.85714 .34393 .84884 .30697 .88372 .29342 .89286 .33608 Metetra
.533 .136 .234 r
.82143 .35051 .81395 .31925 .84884 .30697 .85714 .34393 Metetra
.502 .065 .142 r
.78571 .35577 .77907 .33009 .81395 .31925 .82143 .35051 Metetra
.457 0 .024 r
.75 .35967 .74419 .33938 .77907 .33009 .78571 .35577 Metetra
.394 0 0 r
.71429 .36216 .7093 .34701 .74419 .33938 .75 .35967 Metetra
.31 0 0 r
.67857 .36323 .67442 .35288 .7093 .34701 .71429 .36216 Metetra
.208 0 0 r
.64286 .36286 .63953 .35692 .67442 .35288 .67857 .36323 Metetra
.101 0 0 r
.60714 .36107 .60465 .35909 .63953 .35692 .64286 .36286 Metetra
0 .569 .76 r
.57143 .35785 .56977 .35935 .60465 .35909 .60714 .36107 Metetra
.068 .614 .84 r
.53571 .35326 .53488 .35771 .56977 .35935 .57143 .35785 Metetra
.118 .635 .888 r
.5 .34731 .5 .35418 .53488 .35771 .53571 .35326 Metetra
.352 0 0 r
.06098 .19998 .07143 .19998 .10714 .21526 .09756 .21303 Metetra
.273 0 0 r
.09756 .21303 .10714 .21526 .14286 .23042 .13415 .22601 Metetra
0 .389 .709 r
.13415 .22601 .14286 .23042 .17857 .2453 .17073 .23882 Metetra
0 .45 .778 r
.17073 .23882 .17857 .2453 .21429 .25979 .20732 .2514 Metetra
0 .504 .834 r
.20732 .2514 .21429 .25979 .25 .27375 .2439 .26367 Metetra
.04 .548 .876 r
.2439 .26367 .25 .27375 .28571 .28706 .28049 .27555 Metetra
.099 .583 .906 r
.28049 .27555 .28571 .28706 .32143 .29961 .31707 .28696 Metetra
.148 .611 .928 r
.31707 .28696 .32143 .29961 .35714 .31128 .35366 .29785 Metetra
.186 .634 .942 r
.35366 .29785 .35714 .31128 .39286 .32198 .39024 .30814 Metetra
.214 .652 .952 r
.39024 .30814 .39286 .32198 .42857 .33161 .42683 .31777 Metetra
.232 .666 .957 r
.42683 .31777 .42857 .33161 .46429 .34007 .46341 .32668 Metetra
.24 .676 .959 r
.46341 .32668 .46429 .34007 .5 .34731 .5 .33482 Metetra
.525 .082 .14 r
.90244 .363 .89286 .33608 .92857 .32703 .93902 .35957 Metetra
.481 0 .027 r
.86585 .36543 .85714 .34393 .89286 .33608 .90244 .363 Metetra
.419 0 0 r
.82927 .36685 .82143 .35051 .85714 .34393 .86585 .36543 Metetra
.335 0 0 r
.79268 .36725 .78571 .35577 .82143 .35051 .82927 .36685 Metetra
.232 0 0 r
.7561 .36663 .75 .35967 .78571 .35577 .79268 .36725 Metetra
.119 0 0 r
.71951 .36499 .71429 .36216 .75 .35967 .7561 .36663 Metetra
0 .566 .744 r
.68293 .36235 .67857 .36323 .71429 .36216 .71951 .36499 Metetra
.079 .627 .836 r
.64634 .35872 .64286 .36286 .67857 .36323 .68293 .36235 Metetra
.147 .662 .894 r
.60976 .35412 .60714 .36107 .64286 .36286 .64634 .35872 Metetra
.194 .679 .928 r
.57317 .34858 .57143 .35785 .60714 .36107 .60976 .35412 Metetra
.223 .685 .947 r
.53659 .34213 .53571 .35326 .57143 .35785 .57317 .34858 Metetra
.238 .683 .956 r
.5 .33482 .5 .34731 .53571 .35326 .53659 .34213 Metetra
.289 0 0 r
.05 .19998 .06098 .19998 .09756 .21303 .0875 .21069 Metetra
.209 0 0 r
.0875 .21069 .09756 .21303 .13415 .22601 .125 .22135 Metetra
0 .449 .742 r
.125 .22135 .13415 .22601 .17073 .23882 .1625 .23194 Metetra
0 .507 .807 r
.1625 .23194 .17073 .23882 .20732 .2514 .2 .2424 Metetra
.029 .556 .86 r
.2 .2424 .20732 .2514 .2439 .26367 .2375 .25269 Metetra
.097 .595 .899 r
.2375 .25269 .2439 .26367 .28049 .27555 .275 .26278 Metetra
.155 .626 .928 r
.275 .26278 .28049 .27555 .31707 .28696 .3125 .27262 Metetra
.205 .651 .948 r
.3125 .27262 .31707 .28696 .35366 .29785 .35 .28218 Metetra
.245 .669 .962 r
.35 .28218 .35366 .29785 .39024 .30814 .3875 .29142 Metetra
.278 .684 .971 r
.3875 .29142 .39024 .30814 .42683 .31777 .425 .3003 Metetra
.303 .696 .977 r
.425 .3003 .42683 .31777 .46341 .32668 .4625 .30878 Metetra
.321 .705 .981 r
.4625 .30878 .46341 .32668 .5 .33482 .5 .31685 Metetra
.224 0 0 r
.9125 .36991 .90244 .363 .93902 .35957 .95 .371 Metetra
.107 0 0 r
.875 .36816 .86585 .36543 .90244 .363 .9125 .36991 Metetra
.007 .58 .756 r
.8375 .36575 .82927 .36685 .86585 .36543 .875 .36816 Metetra
.105 .646 .847 r
.8 .36269 .79268 .36725 .82927 .36685 .8375 .36575 Metetra
.183 .688 .907 r
.7625 .35899 .7561 .36663 .79268 .36725 .8 .36269 Metetra
.241 .711 .943 r
.725 .35468 .71951 .36499 .7561 .36663 .7625 .35899 Metetra
.283 .723 .964 r
.6875 .34976 .68293 .36235 .71951 .36499 .725 .35468 Metetra
.311 .727 .976 r
.65 .34425 .64634 .35872 .68293 .36235 .6875 .34976 Metetra
.328 .727 .981 r
.6125 .33819 .60976 .35412 .64634 .35872 .65 .34425 Metetra
.337 .724 .984 r
.575 .33158 .57317 .34858 .60976 .35412 .6125 .33819 Metetra
.338 .719 .984 r
.5375 .32446 .53659 .34213 .57317 .34858 .575 .33158 Metetra
.333 .713 .983 r
.5 .31685 .5 .33482 .53659 .34213 .5375 .32446 Metetra
.221 0 0 r
.03846 .19998 .05 .19998 .0875 .21069 .07692 .20822 Metetra
0 .449 .698 r
.07692 .20822 .0875 .21069 .125 .22135 .11538 .21644 Metetra
0 .511 .772 r
.11538 .21644 .125 .22135 .1625 .23194 .15385 .22462 Metetra
.018 .565 .834 r
.15385 .22462 .1625 .23194 .2 .2424 .19231 .23276 Metetra
.091 .609 .883 r
.19231 .23276 .2 .2424 .2375 .25269 .23077 .24082 Metetra
.156 .644 .92 r
.23077 .24082 .2375 .25269 .275 .26278 .26923 .24879 Metetra
.213 .671 .946 r
.26923 .24879 .275 .26278 .3125 .27262 .30769 .25665 Metetra
.262 .692 .965 r
.30769 .25665 .3125 .27262 .35 .28218 .34615 .26439 Metetra
.304 .707 .977 r
.34615 .26439 .35 .28218 .3875 .29142 .38462 .27198 Metetra
.338 .718 .984 r
.38462 .27198 .3875 .29142 .425 .3003 .42308 .27942 Metetra
.366 .726 .988 r
.42308 .27942 .425 .3003 .4625 .30878 .46154 .28669 Metetra
.389 .733 .991 r
.46154 .28669 .4625 .30878 .5 .31685 .5 .29376 Metetra
.346 .755 .981 r
.92308 .35492 .9125 .36991 .95 .371 .96154 .35864 Metetra
.38 .761 .99 r
.88462 .35085 .875 .36816 .9125 .36991 .92308 .35492 Metetra
.405 .762 .994 r
.84615 .34645 .8375 .36575 .875 .36816 .88462 .35085 Metetra
.422 .762 .996 r
.80769 .34173 .8 .36269 .8375 .36575 .84615 .34645 Metetra
.434 .76 .996 r
.76923 .3367 .7625 .35899 .8 .36269 .80769 .34173 Metetra
.441 .757 .995 r
.73077 .33136 .725 .35468 .7625 .35899 .76923 .3367 Metetra
.444 .755 .994 r
.69231 .32574 .6875 .34976 .725 .35468 .73077 .33136 Metetra
.444 .752 .994 r
.65385 .31984 .65 .34425 .6875 .34976 .69231 .32574 Metetra
.44 .749 .993 r
.61538 .31368 .6125 .33819 .65 .34425 .65385 .31984 Metetra
.433 .745 .993 r
.57692 .30727 .575 .33158 .6125 .33819 .61538 .31368 Metetra
.422 .742 .993 r
.53846 .30063 .5375 .32446 .575 .33158 .57692 .30727 Metetra
.408 .738 .992 r
.5 .29376 .5 .31685 .5375 .32446 .53846 .30063 Metetra
.15 0 0 r
.02632 .19998 .03846 .19998 .07692 .20822 .06579 .20561 Metetra
0 .513 .729 r
.06579 .20561 .07692 .20822 .11538 .21644 .10526 .21125 Metetra
.008 .572 .799 r
.10526 .21125 .11538 .21644 .15385 .22462 .14474 .21687 Metetra
.084 .621 .857 r
.14474 .21687 .15385 .22462 .19231 .23276 .18421 .22248 Metetra
.154 .661 .903 r
.18421 .22248 .19231 .23276 .23077 .24082 .22368 .22806 Metetra
.217 .693 .937 r
.22368 .22806 .23077 .24082 .26923 .24879 .26316 .23362 Metetra
.272 .716 .961 r
.26316 .23362 .26923 .24879 .30769 .25665 .30263 .23914 Metetra
.319 .733 .977 r
.30263 .23914 .30769 .25665 .34615 .26439 .34211 .24463 Metetra
.36 .744 .987 r
.34211 .24463 .34615 .26439 .38462 .27198 .38158 .25007 Metetra
.394 .752 .993 r
.38158 .25007 .38462 .27198 .42308 .27942 .42105 .25546 Metetra
.423 .757 .995 r
.42105 .25546 .42308 .27942 .46154 .28669 .46053 .2608 Metetra
.448 .76 .995 r
.46053 .2608 .46154 .28669 .5 .29376 .5 .26608 Metetra
.551 .764 .977 r
.93421 .31881 .92308 .35492 .96154 .35864 .97368 .323 Metetra
.55 .763 .976 r
.89474 .31451 .88462 .35085 .92308 .35492 .93421 .31881 Metetra
.549 .762 .976 r
.85526 .3101 .84615 .34645 .88462 .35085 .89474 .31451 Metetra
.546 .762 .977 r
.81579 .30557 .80769 .34173 .84615 .34645 .85526 .3101 Metetra
.542 .761 .978 r
.77632 .30095 .76923 .3367 .80769 .34173 .81579 .30557 Metetra
.537 .761 .98 r
.73684 .29623 .73077 .33136 .76923 .3367 .77632 .30095 Metetra
.53 .762 .982 r
.69737 .29141 .69231 .32574 .73077 .33136 .73684 .29623 Metetra
.522 .762 .984 r
.65789 .2865 .65385 .31984 .69231 .32574 .69737 .29141 Metetra
.512 .762 .987 r
.61842 .28151 .61538 .31368 .65385 .31984 .65789 .2865 Metetra
.5 .762 .989 r
.57895 .27644 .57692 .30727 .61538 .31368 .61842 .28151 Metetra
.485 .762 .992 r
.53947 .2713 .53846 .30063 .57692 .30727 .57895 .27644 Metetra
.468 .762 .994 r
.5 .26608 .5 .29376 .53846 .30063 .53947 .2713 Metetra
.076 0 0 r
.01351 .19997 .02632 .19998 .06579 .20561 .05405 .20287 Metetra
.002 .576 .756 r
.05405 .20287 .06579 .20561 .10526 .21125 .09459 .20577 Metetra
.078 .63 .822 r
.09459 .20577 .10526 .21125 .14474 .21687 .13514 .20866 Metetra
.151 .676 .876 r
.13514 .20866 .14474 .21687 .18421 .22248 .17568 .21155 Metetra
.217 .712 .918 r
.17568 .21155 .18421 .22248 .22368 .22806 .21622 .21444 Metetra
.276 .739 .95 r
.21622 .21444 .22368 .22806 .26316 .23362 .25676 .21733 Metetra
.329 .758 .972 r
.25676 .21733 .26316 .23362 .30263 .23914 .2973 .22021 Metetra
.374 .772 .986 r
.2973 .22021 .30263 .23914 .34211 .24463 .33784 .22308 Metetra
.412 .78 .994 r
.33784 .22308 .34211 .24463 .38158 .25007 .37838 .22595 Metetra
.445 .785 .998 r
.37838 .22595 .38158 .25007 .42105 .25546 .41892 .22882 Metetra
.473 .787 .999 r
.41892 .22882 .42105 .25546 .46053 .2608 .45946 .23168 Metetra
.497 .787 .997 r
.45946 .23168 .46053 .2608 .5 .26608 .5 .23453 Metetra
.62 .751 .94 r
.94595 .26516 .93421 .31881 .97368 .323 .98649 .26787 Metetra
.615 .754 .944 r
.90541 .26244 .89474 .31451 .93421 .31881 .94595 .26516 Metetra
.61 .757 .949 r
.86486 .25971 .85526 .3101 .89474 .31451 .90541 .26244 Metetra
.605 .76 .953 r
.82432 .25696 .81579 .30557 .85526 .3101 .86486 .25971 Metetra
.598 .764 .958 r
.78378 .2542 .77632 .30095 .81579 .30557 .82432 .25696 Metetra
.591 .767 .963 r
.74324 .25142 .73684 .29623 .77632 .30095 .78378 .2542 Metetra
.583 .77 .968 r
.7027 .24863 .69737 .29141 .73684 .29623 .74324 .25142 Metetra
.573 .774 .974 r
.66216 .24583 .65789 .2865 .69737 .29141 .7027 .24863 Metetra
.562 .777 .979 r
.62162 .24302 .61842 .28151 .65789 .2865 .66216 .24583 Metetra
.55 .781 .984 r
.58108 .2402 .57895 .27644 .61842 .28151 .62162 .24302 Metetra
.535 .784 .989 r
.54054 .23737 .53947 .2713 .57895 .27644 .58108 .2402 Metetra
.517 .786 .994 r
.5 .23453 .5 .26608 .53947 .2713 .54054 .23737 Metetra
0 .577 .707 r
0 .19997 .01351 .19997 .05405 .20287 .04167 .19997 Metetra
.075 .636 .778 r
.04167 .19997 .05405 .20287 .09459 .20577 .08333 .19997 Metetra
.148 .686 .84 r
.08333 .19997 .09459 .20577 .13514 .20866 .125 .19997 Metetra
.216 .726 .89 r
.125 .19997 .13514 .20866 .17568 .21155 .16667 .19997 Metetra
.278 .758 .928 r
.16667 .19997 .17568 .21155 .21622 .21444 .20833 .19997 Metetra
.334 .781 .957 r
.20833 .19997 .21622 .21444 .25676 .21733 .25 .19997 Metetra
.382 .798 .977 r
.25 .19997 .25676 .21733 .2973 .22021 .29167 .19997 Metetra
.424 .808 .99 r
.29167 .19997 .2973 .22021 .33784 .22308 .33333 .19997 Metetra
.46 .814 .997 r
.33333 .19997 .33784 .22308 .37838 .22595 .375 .19997 Metetra
.49 .816 1 r
.375 .19997 .37838 .22595 .41892 .22882 .41667 .19997 Metetra
.516 .816 .999 r
.41667 .19997 .41892 .22882 .45946 .23168 .45833 .19997 Metetra
.538 .814 .997 r
.45833 .19997 .45946 .23168 .5 .23453 .5 .19997 Metetra
.653 .754 .924 r
.95833 .19997 .94595 .26516 .98649 .26787 1 .19997 Metetra
.649 .759 .93 r
.91667 .19997 .90541 .26244 .94595 .26516 .95833 .19997 Metetra
.644 .764 .936 r
.875 .19997 .86486 .25971 .90541 .26244 .91667 .19997 Metetra
.639 .769 .942 r
.83333 .19997 .82432 .25696 .86486 .25971 .875 .19997 Metetra
.633 .774 .948 r
.79167 .19997 .78378 .2542 .82432 .25696 .83333 .19997 Metetra
.626 .78 .955 r
.75 .19997 .74324 .25142 .78378 .2542 .79167 .19997 Metetra
.618 .785 .961 r
.70833 .19997 .7027 .24863 .74324 .25142 .75 .19997 Metetra
.609 .791 .968 r
.66667 .19997 .66216 .24583 .7027 .24863 .70833 .19997 Metetra
.599 .796 .975 r
.625 .19997 .62162 .24302 .66216 .24583 .66667 .19997 Metetra
.587 .801 .981 r
.58333 .19997 .58108 .2402 .62162 .24302 .625 .19997 Metetra
.573 .806 .987 r
.54167 .19997 .54054 .23737 .58108 .2402 .58333 .19997 Metetra
.557 .81 .993 r
.5 .19997 .5 .23453 .54054 .23737 .54167 .19997 Metetra
0 g
.25 Mabswid
0 0 m
0 .4 L
s
0 .4 m
1 .4 L
s
1 .4 m
1 0 L
s
1 0 m
0 0 L
s
0 0 m
1 0 L
s
0 0 m
.0058 .00232 L
s
[(0)] -0.01161 -0.00464 1 .4 Mshowa
.33333 0 m
.33733 .0048 L
s
[(1)] .32533 -0.0096 .83333 1 Mshowa
.66667 0 m
.66267 .0048 L
s
[(2)] .67467 -0.0096 -0.83333 1 Mshowa
1 0 m
.9942 .00232 L
s
[(3)] 1.01161 -0.00464 -1 .4 Mshowa
.125 Mabswid
.06667 0 m
.07007 .00157 L
s
.13333 0 m
.13663 .0018 L
s
.2 0 m
.20312 .00208 L
s
.26667 0 m
.26951 .00244 L
s
.4 0 m
.40168 .00335 L
s
.46667 0 m
.46728 .0037 L
s
.53333 0 m
.53272 .0037 L
s
.6 0 m
.59832 .00335 L
s
.73333 0 m
.73049 .00244 L
s
.8 0 m
.79688 .00208 L
s
.86667 0 m
.86337 .0018 L
s
.93333 0 m
.92993 .00157 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.9.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.9.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{1.3,", "MR"],
              " ",
              StyleBox["-2.4,", "MR"],
              " ",
              StyleBox["2}", "MR"],
              " "
            }]], Cell["default view point "]},
          {Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["-2,", "MR"],
              " ",
              StyleBox["0}", "MR"],
              " "
            }]], Cell["directly in front "]},
          {Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["-2,", "MR"],
              " ",
              StyleBox["2}", "MR"],
              " "
            }]], Cell["in front and up "]},
          {Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["-2,", "MR"],
              " ",
              StyleBox["-2}", "MR"],
              " "
            }]], Cell["in front and down "]},
          {Cell[TextData[{
              StyleBox["{-2,", "MR"],
              " ",
              StyleBox["-2,", "MR"],
              " ",
              StyleBox["0}", "MR"],
              " "
            }]], Cell["left\[Hyphen]hand corner "]},
          {Cell[TextData[{
              StyleBox["{2,", "MR"],
              " ",
              StyleBox["-2,", "MR"],
              " ",
              StyleBox["0}", "MR"],
              " "
            }]], Cell["right\[Hyphen]hand corner "]},
          {Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["0,", "MR"],
              " ",
              StyleBox["2}", "MR"],
              " "
            }]], Cell["directly above "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.9.6"],

Cell[TextData[{
  "Typical choices for the ",
  StyleBox["ViewPoint", "MR"],
  " option. "
}], "Caption",
  CellTags->"S1.9.6"],

Cell["\<\
The human visual system is not particularly good at understanding \
complicated mathematical surfaces. As a result, you need to generate pictures \
that contain as many clues as possible about the form of the surface.  \
\>", \
"Text",
  CellTags->{"S1.9.6", "6.11"}],

Cell["\<\
View points slightly above the surface usually work best. It is \
generally a good idea to keep the view point close enough to the surface that \
there is some perspective effect. Having a box explicitly drawn around the \
surface is helpful in recognizing the orientation of the surface. \
\>", \
"Text",
  CellTags->{"S1.9.6", "6.12"}],

Cell["\<\
Here is a plot with the default settings for surface rendering \
options. \
\>", "MathCaption",
  CellTags->{"S1.9.6", "6.13"}],

Cell[CellGroupData[{

Cell["g = Plot3D[Exp[-(x^2+y^2)], {x, -2, 2}, {y, -2, 2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.9.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11727e-16 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -18 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -24 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0.25)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0.5)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.75)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.662 .742 .909 r
.39235 .59195 .40512 .60378 .4265 .59742 .41384 .58555 Metetra
.66 .742 .911 r
.41384 .58555 .4265 .59742 .44806 .59105 .43551 .57917 Metetra
.658 .743 .913 r
.43551 .57917 .44806 .59105 .46979 .58468 .45734 .57284 Metetra
.656 .745 .915 r
.45734 .57284 .46979 .58468 .49169 .57834 .47936 .5666 Metetra
.653 .747 .919 r
.47936 .5666 .49169 .57834 .51378 .57202 .50156 .56047 Metetra
.649 .751 .924 r
.50156 .56047 .51378 .57202 .53604 .56574 .52395 .55444 Metetra
.646 .756 .929 r
.52395 .55444 .53604 .56574 .5585 .55948 .54653 .5485 Metetra
.643 .763 .935 r
.54653 .5485 .5585 .55948 .58114 .5532 .56932 .54258 Metetra
.642 .77 .941 r
.56932 .54258 .58114 .5532 .60398 .54685 .5923 .53657 Metetra
.643 .779 .946 r
.5923 .53657 .60398 .54685 .62701 .54037 .61549 .53037 Metetra
.647 .787 .949 r
.61549 .53037 .62701 .54037 .65024 .5337 .63887 .52385 Metetra
.653 .794 .95 r
.63887 .52385 .65024 .5337 .67365 .52679 .66244 .51693 Metetra
.66 .797 .948 r
.66244 .51693 .67365 .52679 .69725 .51963 .68619 .50957 Metetra
.667 .798 .945 r
.68619 .50957 .69725 .51963 .72103 .51222 .71013 .5018 Metetra
.673 .795 .94 r
.71013 .5018 .72103 .51222 .745 .50462 .73424 .49371 Metetra
.676 .789 .934 r
.73424 .49371 .745 .50462 .76916 .49687 .75853 .48541 Metetra
.677 .781 .928 r
.75853 .48541 .76916 .49687 .79352 .48905 .78302 .47701 Metetra
.676 .773 .923 r
.78302 .47701 .79352 .48905 .81809 .48119 .80771 .46861 Metetra
.675 .765 .919 r
.80771 .46861 .81809 .48119 .84286 .47335 .83261 .46029 Metetra
.672 .758 .915 r
.83261 .46029 .84286 .47335 .86785 .46553 .85773 .45206 Metetra
.67 .753 .913 r
.85773 .45206 .86785 .46553 .89306 .45773 .88308 .44393 Metetra
.668 .748 .911 r
.88308 .44393 .89306 .45773 .91849 .44994 .90867 .43587 Metetra
.666 .746 .91 r
.90867 .43587 .91849 .44994 .94415 .44214 .93448 .42786 Metetra
.665 .744 .909 r
.93448 .42786 .94415 .44214 .97004 .43431 .96053 .41985 Metetra
.66 .742 .911 r
.3794 .57999 .39235 .59195 .41384 .58555 .40099 .57358 Metetra
.658 .743 .913 r
.40099 .57358 .41384 .58555 .43551 .57917 .42276 .56724 Metetra
.654 .744 .916 r
.42276 .56724 .43551 .57917 .45734 .57284 .4447 .56105 Metetra
.649 .747 .921 r
.4447 .56105 .45734 .57284 .47936 .5666 .46683 .55505 Metetra
.643 .751 .927 r
.46683 .55505 .47936 .5666 .50156 .56047 .48915 .54929 Metetra
.636 .757 .935 r
.48915 .54929 .50156 .56047 .52395 .55444 .51166 .54376 Metetra
.629 .765 .945 r
.51166 .54376 .52395 .55444 .54653 .5485 .53438 .53843 Metetra
.622 .776 .955 r
.53438 .53843 .54653 .5485 .56932 .54258 .55731 .53318 Metetra
.618 .79 .964 r
.55731 .53318 .56932 .54258 .5923 .53657 .58045 .52783 Metetra
.618 .804 .971 r
.58045 .52783 .5923 .53657 .61549 .53037 .60381 .52216 Metetra
.624 .819 .975 r
.60381 .52216 .61549 .53037 .63887 .52385 .62737 .51596 Metetra
.635 .831 .976 r
.62737 .51596 .63887 .52385 .66244 .51693 .65112 .50909 Metetra
.65 .838 .972 r
.65112 .50909 .66244 .51693 .68619 .50957 .67504 .50148 Metetra
.665 .839 .967 r
.67504 .50148 .68619 .50957 .71013 .5018 .69913 .49318 Metetra
.677 .834 .959 r
.69913 .49318 .71013 .5018 .73424 .49371 .72339 .48435 Metetra
.685 .824 .95 r
.72339 .48435 .73424 .49371 .75853 .48541 .74781 .47517 Metetra
.688 .81 .941 r
.74781 .47517 .75853 .48541 .78302 .47701 .77242 .46588 Metetra
.687 .796 .932 r
.77242 .46588 .78302 .47701 .80771 .46861 .79723 .45664 Metetra
.684 .782 .925 r
.79723 .45664 .80771 .46861 .83261 .46029 .82225 .44758 Metetra
.679 .77 .919 r
.82225 .44758 .83261 .46029 .85773 .45206 .84749 .43874 Metetra
.675 .761 .915 r
.84749 .43874 .85773 .45206 .88308 .44393 .87297 .43014 Metetra
.671 .754 .912 r
.87297 .43014 .88308 .44393 .90867 .43587 .8987 .42172 Metetra
.668 .749 .91 r
.8987 .42172 .90867 .43587 .93448 .42786 .92466 .41342 Metetra
.666 .746 .909 r
.92466 .41342 .93448 .42786 .96053 .41985 .95088 .40519 Metetra
.658 .742 .912 r
.36624 .5679 .3794 .57999 .40099 .57358 .38794 .56153 Metetra
.653 .743 .916 r
.38794 .56153 .40099 .57358 .42276 .56724 .40981 .55533 Metetra
.647 .746 .921 r
.40981 .55533 .42276 .56724 .4447 .56105 .43186 .5494 Metetra
.638 .749 .929 r
.43186 .5494 .4447 .56105 .46683 .55505 .45409 .54384 Metetra
.627 .755 .939 r
.45409 .54384 .46683 .55505 .48915 .54929 .47652 .53871 Metetra
.612 .764 .952 r
.47652 .53871 .48915 .54929 .51166 .54376 .49916 .53404 Metetra
.595 .776 .967 r
.49916 .53404 .51166 .54376 .53438 .53843 .52201 .52974 Metetra
.577 .792 .981 r
.52201 .52974 .53438 .53843 .55731 .53318 .5451 .52561 Metetra
.562 .811 .992 r
.5451 .52561 .55731 .53318 .58045 .52783 .56842 .52135 Metetra
.555 .832 .997 r
.56842 .52135 .58045 .52783 .60381 .52216 .59197 .5166 Metetra
.562 .854 .997 r
.59197 .5166 .60381 .52216 .62737 .51596 .61573 .51099 Metetra
.583 .874 .994 r
.61573 .51099 .62737 .51596 .65112 .50909 .63969 .50426 Metetra
.614 .889 .989 r
.63969 .50426 .65112 .50909 .67504 .50148 .66381 .49631 Metetra
.649 .895 .983 r
.66381 .49631 .67504 .50148 .69913 .49318 .68807 .48723 Metetra
.678 .89 .975 r
.68807 .48723 .69913 .49318 .72339 .48435 .71248 .47727 Metetra
.696 .875 .965 r
.71248 .47727 .72339 .48435 .74781 .47517 .73703 .46678 Metetra
.704 .853 .954 r
.73703 .46678 .74781 .47517 .77242 .46588 .76175 .45612 Metetra
.704 .83 .943 r
.76175 .45612 .77242 .46588 .79723 .45664 .78666 .44562 Metetra
.698 .807 .933 r
.78666 .44562 .79723 .45664 .82225 .44758 .81177 .43546 Metetra
.691 .788 .925 r
.81177 .43546 .82225 .44758 .84749 .43874 .83713 .42574 Metetra
.683 .772 .919 r
.83713 .42574 .84749 .43874 .87297 .43014 .86273 .41645 Metetra
.677 .761 .914 r
.86273 .41645 .87297 .43014 .8987 .42172 .88858 .40752 Metetra
.672 .753 .912 r
.88858 .40752 .8987 .42172 .92466 .41342 .9147 .39885 Metetra
.669 .748 .91 r
.9147 .39885 .92466 .41342 .95088 .40519 .94106 .39034 Metetra
.654 .743 .915 r
.35288 .5557 .36624 .5679 .38794 .56153 .37468 .54943 Metetra
.647 .744 .92 r
.37468 .54943 .38794 .56153 .40981 .55533 .39665 .54347 Metetra
.636 .747 .928 r
.39665 .54347 .40981 .55533 .43186 .5494 .4188 .53798 Metetra
.62 .751 .94 r
.4188 .53798 .43186 .5494 .45409 .54384 .44114 .53312 Metetra
.598 .758 .955 r
.44114 .53312 .45409 .54384 .47652 .53871 .46367 .52899 Metetra
.567 .768 .973 r
.46367 .52899 .47652 .53871 .49916 .53404 .48642 .52564 Metetra
.526 .781 .99 r
.48642 .52564 .49916 .53404 .52201 .52974 .50942 .52291 Metetra
.477 .794 .999 r
.50942 .52291 .52201 .52974 .5451 .52561 .53267 .52051 Metetra
.427 .806 .992 r
.53267 .52051 .5451 .52561 .56842 .52135 .55618 .51793 Metetra
.392 .816 .968 r
.55618 .51793 .56842 .52135 .59197 .5166 .57995 .51459 Metetra
.39 .833 .94 r
.57995 .51459 .59197 .5166 .61573 .51099 .60395 .50991 Metetra
.428 .862 .925 r
.60395 .50991 .61573 .51099 .63969 .50426 .62814 .50345 Metetra
.498 .9 .929 r
.62814 .50345 .63969 .50426 .66381 .49631 .65249 .49505 Metetra
.581 .932 .944 r
.65249 .49505 .66381 .49631 .68807 .48723 .67695 .48485 Metetra
.654 .945 .958 r
.67695 .48485 .68807 .48723 .71248 .47727 .70152 .47327 Metetra
.702 .935 .963 r
.70152 .47327 .71248 .47727 .73703 .46678 .7262 .46087 Metetra
.724 .908 .959 r
.7262 .46087 .73703 .46678 .76175 .45612 .75102 .44825 Metetra
.727 .874 .95 r
.75102 .44825 .76175 .45612 .78666 .44562 .77601 .43591 Metetra
.719 .841 .939 r
.77601 .43591 .78666 .44562 .81177 .43546 .80121 .42419 Metetra
.708 .811 .93 r
.80121 .42419 .81177 .43546 .83713 .42574 .82665 .41321 Metetra
.695 .788 .922 r
.82665 .41321 .83713 .42574 .86273 .41645 .85235 .40296 Metetra
.685 .771 .917 r
.85235 .40296 .86273 .41645 .88858 .40752 .87833 .39334 Metetra
.677 .759 .913 r
.87833 .39334 .88858 .40752 .9147 .39885 .90458 .38418 Metetra
.672 .752 .911 r
.90458 .38418 .9147 .39885 .94106 .39034 .9311 .37533 Metetra
.649 .743 .918 r
.33932 .5434 .35288 .5557 .37468 .54943 .36121 .53731 Metetra
.638 .744 .925 r
.36121 .53731 .37468 .54943 .39665 .54347 .38328 .53172 Metetra
.62 .747 .937 r
.38328 .53172 .39665 .54347 .4188 .53798 .40551 .52687 Metetra
.592 .751 .953 r
.40551 .52687 .4188 .53798 .44114 .53312 .42794 .52301 Metetra
.549 .757 .974 r
.42794 .52301 .44114 .53312 .46367 .52899 .45056 .52031 Metetra
.484 .761 .992 r
.45056 .52031 .46367 .52899 .48642 .52564 .47343 .51881 Metetra
.388 .755 .992 r
.47343 .51881 .48642 .52564 .50942 .52291 .49655 .51832 Metetra
.263 .727 .948 r
.49655 .51832 .50942 .52291 .53267 .52051 .51997 .51836 Metetra
.14 .676 .851 r
.51997 .51836 .53267 .52051 .55618 .51793 .54369 .51819 Metetra
.064 .628 .736 r
.54369 .51819 .55618 .51793 .57995 .51459 .56771 .51688 Metetra
.56771 .51688 .57995 .51459 .60395 .50991 .59198 .51354 Metetra
.59198 .51354 .60395 .50991 .62814 .50345 .61646 .5075 Metetra
.256 .751 .679 r
.61646 .5075 .62814 .50345 .65249 .49505 .64107 .49851 Metetra
.417 .857 .76 r
.64107 .49851 .65249 .49505 .67695 .48485 .66576 .48679 Metetra
.573 .94 .847 r
.66576 .48679 .67695 .48485 .70152 .47327 .69051 .47297 Metetra
.685 .974 .91 r
.69051 .47297 .70152 .47327 .7262 .46087 .71532 .45795 Metetra
.741 .962 .939 r
.71532 .45795 .7262 .46087 .75102 .44825 .74023 .44264 Metetra
.756 .924 .945 r
.74023 .44264 .75102 .44825 .77601 .43591 .76529 .42781 Metetra
.748 .88 .94 r
.76529 .42781 .77601 .43591 .80121 .42419 .79055 .41394 Metetra
.731 .84 .932 r
.79055 .41394 .80121 .42419 .82665 .41321 .81606 .40127 Metetra
.712 .807 .924 r
.81606 .40127 .82665 .41321 .85235 .40296 .84185 .38975 Metetra
.696 .783 .918 r
.84185 .38975 .85235 .40296 .87833 .39334 .86793 .37922 Metetra
.684 .767 .914 r
.86793 .37922 .87833 .39334 .90458 .38418 .89431 .36943 Metetra
.676 .756 .911 r
.89431 .36943 .90458 .38418 .9311 .37533 .92097 .36014 Metetra
.642 .742 .922 r
.32553 .531 .33932 .5434 .36121 .53731 .34752 .52516 Metetra
.625 .743 .932 r
.34752 .52516 .36121 .53731 .38328 .53172 .36967 .52007 Metetra
.597 .745 .947 r
.36967 .52007 .38328 .53172 .40551 .52687 .39198 .51608 Metetra
.55 .746 .968 r
.39198 .51608 .40551 .52687 .42794 .52301 .41448 .51353 Metetra
.471 .742 .987 r
.41448 .51353 .42794 .52301 .45056 .52031 .43719 .5127 Metetra
.339 .717 .984 r
.43719 .5127 .45056 .52031 .47343 .51881 .46014 .51364 Metetra
.143 .643 .908 r
.46014 .51364 .47343 .51881 .49655 .51832 .48338 .51608 Metetra
0 .512 .729 r
.48338 .51608 .49655 .51832 .51997 .51836 .50697 .51933 Metetra
.218 0 0 r
.50697 .51933 .51997 .51836 .54369 .51819 .53091 .52231 Metetra
.265 0 0 r
.53091 .52231 .54369 .51819 .56771 .51688 .55519 .52369 Metetra
.233 0 0 r
.55519 .52369 .56771 .51688 .59198 .51354 .57977 .52215 Metetra
.138 0 0 r
.57977 .52215 .59198 .51354 .61646 .5075 .60457 .51671 Metetra
.60457 .51671 .61646 .5075 .64107 .49851 .62949 .50698 Metetra
.62949 .50698 .64107 .49851 .66576 .48679 .65445 .49329 Metetra
.451 .847 .648 r
.65445 .49329 .66576 .48679 .69051 .47297 .6794 .47659 Metetra
.641 .96 .791 r
.6794 .47659 .69051 .47297 .71532 .45795 .70436 .45818 Metetra
.751 .991 .88 r
.70436 .45818 .71532 .45795 .74023 .44264 .72936 .4394 Metetra
.787 .966 .919 r
.72936 .4394 .74023 .44264 .76529 .42781 .75447 .42136 Metetra
.782 .918 .93 r
.75447 .42136 .76529 .42781 .79055 .41394 .77978 .40477 Metetra
.759 .869 .928 r
.77978 .40477 .79055 .41394 .81606 .40127 .80534 .38994 Metetra
.733 .828 .923 r
.80534 .38994 .81606 .40127 .84185 .38975 .8312 .37682 Metetra
.711 .797 .918 r
.8312 .37682 .84185 .38975 .86793 .37922 .85738 .36516 Metetra
.693 .775 .914 r
.85738 .36516 .86793 .37922 .89431 .36943 .88388 .3546 Metetra
.681 .761 .911 r
.88388 .3546 .89431 .36943 .92097 .36014 .91069 .34479 Metetra
.634 .741 .926 r
.31153 .51847 .32553 .531 .34752 .52516 .3336 .51295 Metetra
.609 .741 .939 r
.3336 .51295 .34752 .52516 .36967 .52007 .35583 .50848 Metetra
.567 .739 .957 r
.35583 .50848 .36967 .52007 .39198 .51608 .37821 .50552 Metetra
.491 .731 .979 r
.37821 .50552 .39198 .51608 .41448 .51353 .40076 .50456 Metetra
.355 .701 .984 r
.40076 .50456 .41448 .51353 .43719 .5127 .42352 .50597 Metetra
.127 .61 .915 r
.42352 .50597 .43719 .5127 .46014 .51364 .44654 .50985 Metetra
0 .428 .704 r
.44654 .50985 .46014 .51364 .48338 .51608 .46988 .51582 Metetra
.368 0 0 r
.46988 .51582 .48338 .51608 .50697 .51933 .49361 .52297 Metetra
.452 0 0 r
.49361 .52297 .50697 .51933 .53091 .52231 .51776 .52981 Metetra
.449 0 0 r
.51776 .52981 .53091 .52231 .55519 .52369 .54233 .53448 Metetra
.39 0 0 r
.54233 .53448 .55519 .52369 .57977 .52215 .56724 .53516 Metetra
.279 0 0 r
.56724 .53516 .57977 .52215 .60457 .51671 .5924 .53046 Metetra
.112 0 0 r
.5924 .53046 .60457 .51671 .62949 .50698 .61767 .51985 Metetra
.61767 .51985 .62949 .50698 .65445 .49329 .64293 .50379 Metetra
.64293 .50379 .65445 .49329 .6794 .47659 .66813 .4836 Metetra
.616 .923 .67 r
.66813 .4836 .6794 .47659 .70436 .45818 .69325 .4611 Metetra
.765 .995 .804 r
.69325 .4611 .70436 .45818 .72936 .4394 .71835 .43816 Metetra
.82 .988 .876 r
.71835 .43816 .72936 .4394 .75447 .42136 .74352 .41629 Metetra
.818 .944 .907 r
.74352 .41629 .75447 .42136 .77978 .40477 .76887 .39647 Metetra
.791 .892 .917 r
.76887 .39647 .77978 .40477 .80534 .38994 .79447 .37909 Metetra
.757 .845 .917 r
.79447 .37909 .80534 .38994 .8312 .37682 .8204 .36409 Metetra
.727 .809 .915 r
.8204 .36409 .8312 .37682 .85738 .36516 .84667 .3511 Metetra
.704 .783 .913 r
.84667 .3511 .85738 .36516 .88388 .3546 .87328 .33965 Metetra
.688 .765 .911 r
.87328 .33965 .88388 .3546 .91069 .34479 .90023 .32924 Metetra
.624 .739 .929 r
.2973 .50578 .31153 .51847 .3336 .51295 .31946 .50062 Metetra
.591 .736 .945 r
.31946 .50062 .3336 .51295 .35583 .50848 .34175 .49682 Metetra
.531 .729 .965 r
.34175 .49682 .35583 .50848 .37821 .50552 .36418 .495 Metetra
.419 .704 .981 r
.36418 .495 .37821 .50552 .40076 .50456 .38677 .49578 Metetra
.212 .629 .952 r
.38677 .49578 .40076 .50456 .42352 .50597 .40956 .49965 Metetra
0 .45 .786 r
.40956 .49965 .42352 .50597 .44654 .50985 .43261 .50675 Metetra
.392 0 0 r
.43261 .50675 .44654 .50985 .46988 .51582 .45603 .51664 Metetra
.537 0 0 r
.45603 .51664 .46988 .51582 .49361 .52297 .47988 .52811 Metetra
.572 .038 0 r
.47988 .52811 .49361 .52297 .51776 .52981 .50422 .53924 Metetra
.543 .041 .012 r
.50422 .53924 .51776 .52981 .54233 .53448 .52906 .54761 Metetra
.466 0 .031 r
.52906 .54761 .54233 .53448 .56724 .53516 .55432 .5508 Metetra
.338 0 0 r
.55432 .5508 .56724 .53516 .5924 .53046 .57986 .54695 Metetra
.146 0 0 r
.57986 .54695 .5924 .53046 .61767 .51985 .60551 .53536 Metetra
.60551 .53536 .61767 .51985 .64293 .50379 .63111 .51665 Metetra
.63111 .51665 .64293 .50379 .66813 .4836 .65658 .49257 Metetra
.658 .921 .621 r
.65658 .49257 .66813 .4836 .69325 .4611 .68189 .46554 Metetra
.805 .993 .755 r
.68189 .46554 .69325 .4611 .71835 .43816 .70711 .43799 Metetra
.858 .991 .835 r
.70711 .43799 .71835 .43816 .74352 .41629 .73236 .41191 Metetra
.853 .953 .878 r
.73236 .41191 .74352 .41629 .76887 .39647 .75776 .38854 Metetra
.821 .903 .898 r
.75776 .38854 .76887 .39647 .79447 .37909 .78342 .36839 Metetra
.781 .856 .907 r
.78342 .36839 .79447 .37909 .8204 .36409 .80941 .35134 Metetra
.744 .817 .909 r
.80941 .35134 .8204 .36409 .84667 .3511 .83577 .33692 Metetra
.715 .788 .909 r
.83577 .33692 .84667 .3511 .87328 .33965 .8625 .3245 Metetra
.694 .769 .909 r
.8625 .3245 .87328 .33965 .90023 .32924 .88959 .31346 Metetra
.615 .736 .932 r
.28285 .49288 .2973 .50578 .31946 .50062 .30508 .48806 Metetra
.572 .73 .949 r
.30508 .48806 .31946 .50062 .34175 .49682 .32743 .48492 Metetra
.494 .713 .969 r
.32743 .48492 .34175 .49682 .36418 .495 .3499 .4842 Metetra
.344 .667 .974 r
.3499 .4842 .36418 .495 .38677 .49578 .37251 .48668 Metetra
.076 .541 .901 r
.37251 .48668 .38677 .49578 .40956 .49965 .39531 .49297 Metetra
0 .302 .663 r
.39531 .49297 .40956 .49965 .43261 .50675 .41838 .50326 Metetra
.524 0 0 r
.41838 .50326 .43261 .50675 .45603 .51664 .44183 .51703 Metetra
.626 .074 0 r
.44183 .51703 .45603 .51664 .47988 .52811 .46576 .53281 Metetra
.639 .12 0 r
.46576 .53281 .47988 .52811 .50422 .53924 .49026 .54826 Metetra
.598 .101 .044 r
.49026 .54826 .50422 .53924 .52906 .54761 .51535 .56036 Metetra
.505 .022 .042 r
.51535 .56036 .52906 .54761 .55432 .5508 .54093 .56607 Metetra
.346 0 0 r
.54093 .56607 .55432 .5508 .57986 .54695 .56685 .56309 Metetra
.096 0 0 r
.56685 .56309 .57986 .54695 .60551 .53536 .59289 .55051 Metetra
.59289 .55051 .60551 .53536 .63111 .51665 .61886 .52911 Metetra
.556 .844 .514 r
.61886 .52911 .63111 .51665 .65658 .49257 .64463 .5011 Metetra
.771 .962 .657 r
.64463 .5011 .65658 .49257 .68189 .46554 .67018 .46951 Metetra
.871 .993 .75 r
.67018 .46951 .68189 .46554 .70711 .43799 .69556 .43736 Metetra
.897 .978 .81 r
.69556 .43736 .70711 .43799 .73236 .41191 .72092 .40709 Metetra
.881 .942 .85 r
.72092 .40709 .73236 .41191 .75776 .38854 .7464 .38022 Metetra
.844 .899 .876 r
.7464 .38022 .75776 .38854 .78342 .36839 .77213 .35732 Metetra
.8 .857 .892 r
.77213 .35732 .78342 .36839 .80941 .35134 .79821 .33825 Metetra
.759 .82 .9 r
.79821 .33825 .80941 .35134 .83577 .33692 .82467 .32242 Metetra
.725 .791 .904 r
.82467 .32242 .83577 .33692 .8625 .3245 .85153 .30905 Metetra
.701 .771 .906 r
.85153 .30905 .8625 .3245 .88959 .31346 .87876 .29739 Metetra
.607 .732 .934 r
.26817 .47969 .28285 .49288 .30508 .48806 .29048 .47514 Metetra
.557 .722 .951 r
.29048 .47514 .30508 .48806 .32743 .48492 .31289 .47254 Metetra
.463 .696 .968 r
.31289 .47254 .32743 .48492 .3499 .4842 .3354 .47275 Metetra
.287 .628 .962 r
.3354 .47275 .3499 .4842 .37251 .48668 .35803 .47667 Metetra
0 .467 .86 r
.35803 .47667 .37251 .48668 .39531 .49297 .38083 .48502 Metetra
.357 0 0 r
.38083 .48502 .39531 .49297 .41838 .50326 .40389 .49804 Metetra
.581 .007 0 r
.40389 .49804 .41838 .50326 .44183 .51703 .42734 .51513 Metetra
.67 .122 0 r
.42734 .51513 .44183 .51703 .46576 .53281 .45132 .53465 Metetra
.678 .152 0 r
.45132 .53465 .46576 .53281 .49026 .54826 .47593 .55384 Metetra
.63 .112 0 r
.47593 .55384 .49026 .54826 .51535 .56036 .5012 .5692 Metetra
.514 0 0 r
.5012 .5692 .51535 .56036 .54093 .56607 .52706 .57712 Metetra
.286 0 0 r
.52706 .57712 .54093 .56607 .56685 .56309 .55332 .57489 Metetra
.55332 .57489 .56685 .56309 .59289 .55051 .57974 .56141 Metetra
.517 .85 .567 r
.57974 .56141 .59289 .55051 .61886 .52911 .60608 .53762 Metetra
.78 .971 .679 r
.60608 .53762 .61886 .52911 .64463 .5011 .63218 .50615 Metetra
.891 .987 .731 r
.63218 .50615 .64463 .5011 .67018 .46951 .65799 .47055 Metetra
.925 .97 .765 r
.65799 .47055 .67018 .46951 .69556 .43736 .68358 .43437 Metetra
.922 .943 .796 r
.68358 .43437 .69556 .43736 .72092 .40709 .7091 .40046 Metetra
.896 .913 .827 r
.7091 .40046 .72092 .40709 .7464 .38022 .73471 .37053 Metetra
.857 .88 .854 r
.73471 .37053 .7464 .38022 .77213 .35732 .76055 .34525 Metetra
.812 .846 .875 r
.76055 .34525 .77213 .35732 .79821 .33825 .78674 .32444 Metetra
.769 .815 .889 r
.78674 .32444 .79821 .33825 .82467 .32242 .81333 .30738 Metetra
.733 .789 .898 r
.81333 .30738 .82467 .32242 .85153 .30905 .84034 .29317 Metetra
.705 .77 .903 r
.84034 .29317 .85153 .30905 .87876 .29739 .86773 .28094 Metetra
.602 .729 .934 r
.25327 .46614 .26817 .47969 .29048 .47514 .27566 .46174 Metetra
.547 .714 .95 r
.27566 .46174 .29048 .47514 .31289 .47254 .29814 .45947 Metetra
.447 .68 .964 r
.29814 .45947 .31289 .47254 .3354 .47275 .32069 .46027 Metetra
.263 .6 .952 r
.32069 .46027 .3354 .47275 .35803 .47667 .34334 .46514 Metetra
0 .431 .849 r
.34334 .46514 .35803 .47667 .38083 .48502 .36614 .47487 Metetra
0 .19 .624 r
.36614 .47487 .38083 .48502 .40389 .49804 .38919 .48973 Metetra
.571 .01 0 r
.38919 .48973 .40389 .49804 .42734 .51513 .41263 .50909 Metetra
.665 .114 0 r
.41263 .50909 .42734 .51513 .45132 .53465 .43662 .53116 Metetra
.678 .13 0 r
.43662 .53116 .45132 .53465 .47593 .55384 .46129 .55292 Metetra
.62 .058 0 r
.46129 .55292 .47593 .55384 .5012 .5692 .4867 .57051 Metetra
.447 0 0 r
.4867 .57051 .5012 .5692 .52706 .57712 .51277 .57995 Metetra
.04 0 0 r
.51277 .57995 .52706 .57712 .55332 .57489 .53931 .57819 Metetra
.518 .915 .82 r
.53931 .57819 .55332 .57489 .57974 .56141 .56606 .56405 Metetra
.817 1 .831 r
.56606 .56405 .57974 .56141 .60608 .53762 .59274 .53853 Metetra
.912 .972 .792 r
.59274 .53853 .60608 .53762 .63218 .50615 .61916 .50458 Metetra
.937 .937 .771 r
.61916 .50458 .63218 .50615 .65799 .47055 .64527 .46613 Metetra
.936 .91 .77 r
.64527 .46613 .65799 .47055 .68358 .43437 .67111 .42711 Metetra
.92 .889 .784 r
.67111 .42711 .68358 .43437 .7091 .40046 .69684 .39062 Metetra
.893 .87 .807 r
.69684 .39062 .7091 .40046 .73471 .37053 .72263 .35854 Metetra
.857 .849 .834 r
.72263 .35854 .73471 .37053 .76055 .34525 .74864 .33158 Metetra
.815 .827 .859 r
.74864 .33158 .76055 .34525 .78674 .32444 .77499 .30951 Metetra
.773 .804 .878 r
.77499 .30951 .78674 .32444 .81333 .30738 .80174 .29155 Metetra
.737 .784 .891 r
.80174 .29155 .81333 .30738 .84034 .29317 .82891 .27672 Metetra
.708 .768 .898 r
.82891 .27672 .84034 .29317 .86773 .28094 .85649 .26405 Metetra
.6 .726 .932 r
.23814 .45219 .25327 .46614 .27566 .46174 .26062 .44778 Metetra
.546 .708 .946 r
.26062 .44778 .27566 .46174 .29814 .45947 .28318 .44555 Metetra
.448 .67 .958 r
.28318 .44555 .29814 .45947 .32069 .46027 .3058 .4465 Metetra
.277 .589 .946 r
.3058 .4465 .32069 .46027 .34334 .46514 .3285 .45165 Metetra
.018 .435 .867 r
.3285 .45165 .34334 .46514 .36614 .47487 .35132 .46183 Metetra
0 .229 .701 r
.35132 .46183 .36614 .47487 .38919 .48973 .37437 .47732 Metetra
.473 0 0 r
.37437 .47732 .38919 .48973 .41263 .50909 .39781 .49748 Metetra
.569 .035 0 r
.39781 .49748 .41263 .50909 .43662 .53116 .4218 .52045 Metetra
.567 .025 0 r
.4218 .52045 .43662 .53116 .46129 .55292 .44649 .54313 Metetra
.445 0 0 r
.44649 .54313 .46129 .55292 .4867 .57051 .47196 .56151 Metetra
0 .421 .802 r
.47196 .56151 .4867 .57051 .51277 .57995 .49815 .57145 Metetra
.416 .768 .996 r
.49815 .57145 .51277 .57995 .53931 .57819 .52489 .5698 Metetra
.738 .882 .946 r
.52489 .5698 .53931 .57819 .56606 .56405 .55188 .55529 Metetra
.856 .878 .854 r
.55188 .55529 .56606 .56405 .59274 .53853 .57885 .52901 Metetra
.897 .858 .795 r
.57885 .52901 .59274 .53853 .61916 .50458 .60558 .49399 Metetra
.909 .843 .766 r
.60558 .49399 .61916 .50458 .64527 .46613 .63199 .45434 Metetra
.908 .833 .76 r
.63199 .45434 .64527 .46613 .67111 .42711 .65812 .41413 Metetra
.897 .827 .77 r
.65812 .41413 .67111 .42711 .69684 .39062 .68412 .37654 Metetra
.876 .821 .791 r
.68412 .37654 .69684 .39062 .72263 .35854 .71015 .34354 Metetra
.846 .813 .817 r
.71015 .34354 .72263 .35854 .74864 .33158 .73638 .31583 Metetra
.81 .802 .844 r
.73638 .31583 .74864 .33158 .77499 .30951 .76294 .29318 Metetra
.771 .789 .867 r
.76294 .29318 .77499 .30951 .80174 .29155 .78989 .27478 Metetra
.736 .775 .884 r
.78989 .27478 .80174 .29155 .82891 .27672 .81725 .2596 Metetra
.709 .763 .894 r
.81725 .2596 .82891 .27672 .85649 .26405 .84502 .24666 Metetra
.603 .723 .929 r
.22278 .43782 .23814 .45219 .26062 .44778 .24537 .43319 Metetra
.552 .705 .941 r
.24537 .43319 .26062 .44778 .28318 .44555 .26803 .43071 Metetra
.465 .667 .95 r
.26803 .43071 .28318 .44555 .3058 .4465 .29075 .43132 Metetra
.321 .593 .943 r
.29075 .43132 .3058 .4465 .3285 .45165 .31352 .43602 Metetra
.116 .467 .892 r
.31352 .43602 .3285 .45165 .35132 .46183 .33641 .44563 Metetra
0 .307 .791 r
.33641 .44563 .35132 .46183 .37437 .47732 .3595 .4604 Metetra
0 .172 .686 r
.3595 .4604 .37437 .47732 .39781 .49748 .38296 .47971 Metetra
0 .114 .64 r
.38296 .47971 .39781 .49748 .4218 .52045 .40695 .50176 Metetra
0 .157 .683 r
.40695 .50176 .4218 .52045 .44649 .54313 .43165 .5235 Metetra
0 .307 .799 r
.43165 .5235 .44649 .54313 .47196 .56151 .45714 .54103 Metetra
.277 .506 .896 r
.45714 .54103 .47196 .56151 .49815 .57145 .48338 .55034 Metetra
.553 .645 .895 r
.48338 .55034 .49815 .57145 .52489 .5698 .5102 .54836 Metetra
.714 .708 .844 r
.5102 .54836 .52489 .5698 .55188 .55529 .53735 .53386 Metetra
.796 .734 .794 r
.53735 .53386 .55188 .55529 .57885 .52901 .56453 .50789 Metetra
.838 .745 .762 r
.56453 .50789 .57885 .52901 .60558 .49399 .59152 .47341 Metetra
.858 .753 .746 r
.59152 .47341 .60558 .49399 .63199 .45434 .61822 .4344 Metetra
.865 .761 .745 r
.61822 .4344 .63199 .45434 .65812 .41413 .64465 .39482 Metetra
.862 .768 .757 r
.64465 .39482 .65812 .41413 .68412 .37654 .67094 .3578 Metetra
.849 .774 .778 r
.67094 .3578 .68412 .37654 .71015 .34354 .69726 .32523 Metetra
.827 .777 .805 r
.69726 .32523 .71015 .34354 .73638 .31583 .72376 .29781 Metetra
.797 .776 .834 r
.72376 .29781 .73638 .31583 .76294 .29318 .75057 .27533 Metetra
.764 .771 .859 r
.75057 .27533 .76294 .29318 .78989 .27478 .77775 .25698 Metetra
.733 .764 .878 r
.77775 .25698 .78989 .27478 .81725 .2596 .80534 .24177 Metetra
.707 .757 .891 r
.80534 .24177 .81725 .2596 .84502 .24666 .83332 .22874 Metetra
.609 .722 .926 r
.20719 .42302 .22278 .43782 .24537 .43319 .2299 .41802 Metetra
.565 .704 .935 r
.2299 .41802 .24537 .43319 .26803 .43071 .25269 .41499 Metetra
.492 .669 .942 r
.25269 .41499 .26803 .43071 .29075 .43132 .27553 .41481 Metetra
.381 .606 .937 r
.27553 .41481 .29075 .43132 .31352 .43602 .29843 .41838 Metetra
.231 .509 .907 r
.29843 .41838 .31352 .43602 .33641 .44563 .32142 .42646 Metetra
.077 .392 .851 r
.32142 .42646 .33641 .44563 .3595 .4604 .34461 .43927 Metetra
0 .297 .794 r
.34461 .43927 .3595 .4604 .38296 .47971 .36813 .45623 Metetra
0 .263 .771 r
.36813 .45623 .38296 .47971 .40695 .50176 .39217 .47565 Metetra
.059 .3 .787 r
.39217 .47565 .40695 .50176 .43165 .5235 .41688 .49475 Metetra
.233 .388 .814 r
.41688 .49475 .43165 .5235 .45714 .54103 .44235 .50994 Metetra
.423 .485 .819 r
.44235 .50994 .45714 .54103 .48338 .55034 .46858 .51758 Metetra
.574 .56 .8 r
.46858 .51758 .48338 .55034 .5102 .54836 .49541 .51487 Metetra
.677 .609 .773 r
.49541 .51487 .5102 .54836 .53735 .53386 .52261 .50071 Metetra
.743 .643 .749 r
.52261 .50071 .53735 .53386 .56453 .50789 .54991 .47604 Metetra
.784 .667 .734 r
.54991 .47604 .56453 .50789 .59152 .47341 .57709 .44355 Metetra
.809 .686 .729 r
.57709 .44355 .59152 .47341 .61822 .4344 .60404 .40688 Metetra
.823 .703 .733 r
.60404 .40688 .61822 .4344 .64465 .39482 .63077 .36964 Metetra
.826 .719 .747 r
.63077 .36964 .64465 .39482 .67094 .3578 .65738 .3347 Metetra
.82 .734 .77 r
.65738 .3347 .67094 .3578 .69726 .32523 .68401 .30383 Metetra
.804 .745 .798 r
.68401 .30383 .69726 .32523 .72376 .29781 .71082 .27767 Metetra
.781 .752 .827 r
.71082 .27767 .72376 .29781 .75057 .27533 .7379 .25603 Metetra
.753 .755 .854 r
.7379 .25603 .75057 .27533 .77775 .25698 .76535 .2382 Metetra
.726 .754 .875 r
.76535 .2382 .77775 .25698 .80534 .24177 .79318 .22326 Metetra
.703 .751 .889 r
.79318 .22326 .80534 .24177 .83332 .22874 .82139 .21031 Metetra
.617 .723 .922 r
.19136 .40784 .20719 .42302 .2299 .41802 .21421 .40234 Metetra
.581 .706 .928 r
.21421 .40234 .2299 .41802 .25269 .41499 .23714 .39853 Metetra
.524 .675 .932 r
.23714 .39853 .25269 .41499 .27553 .41481 .26014 .3972 Metetra
.442 .623 .929 r
.26014 .3972 .27553 .41481 .29843 .41838 .2832 .39913 Metetra
.338 .549 .91 r
.2832 .39913 .29843 .41838 .32142 .42646 .30636 .40496 Metetra
.238 .464 .875 r
.30636 .40496 .32142 .42646 .34461 .43927 .3297 .41487 Metetra
.178 .394 .836 r
.3297 .41487 .34461 .43927 .36813 .45623 .35335 .42834 Metetra
.186 .364 .808 r
.35335 .42834 .36813 .45623 .39217 .47565 .37747 .44388 Metetra
.259 .378 .794 r
.37747 .44388 .39217 .47565 .41688 .49475 .40221 .45907 Metetra
.369 .421 .784 r
.40221 .45907 .41688 .49475 .44235 .50994 .42767 .47084 Metetra
.483 .473 .769 r
.42767 .47084 .44235 .50994 .46858 .51758 .45385 .47605 Metetra
.58 .52 .752 r
.45385 .47605 .46858 .51758 .49541 .51487 .48063 .47232 Metetra
.653 .558 .735 r
.48063 .47232 .49541 .51487 .52261 .50071 .5078 .45874 Metetra
.706 .59 .723 r
.5078 .45874 .52261 .50071 .54991 .47604 .53514 .43609 Metetra
.744 .617 .717 r
.53514 .43609 .54991 .47604 .57709 .44355 .56245 .40666 Metetra
.77 .64 .718 r
.56245 .40666 .57709 .44355 .60404 .40688 .5896 .37358 Metetra
.786 .662 .727 r
.5896 .37358 .60404 .40688 .63077 .36964 .61659 .33993 Metetra
.793 .683 .743 r
.61659 .33993 .63077 .36964 .65738 .3347 .64351 .30822 Metetra
.791 .703 .767 r
.64351 .30822 .65738 .3347 .68401 .30383 .67046 .27999 Metetra
.781 .72 .796 r
.67046 .27999 .68401 .30383 .71082 .27767 .69758 .25582 Metetra
.763 .733 .826 r
.69758 .25582 .71082 .27767 .7379 .25603 .72497 .23556 Metetra
.74 .741 .853 r
.72497 .23556 .7379 .25603 .76535 .2382 .75269 .21859 Metetra
.717 .745 .874 r
.75269 .21859 .76535 .2382 .79318 .22326 .78077 .20413 Metetra
.697 .745 .888 r
.78077 .20413 .79318 .22326 .82139 .21031 .80923 .19139 Metetra
.626 .724 .918 r
.17529 .39233 .19136 .40784 .21421 .40234 .19828 .38624 Metetra
.598 .709 .922 r
.19828 .38624 .21421 .40234 .23714 .39853 .22138 .38154 Metetra
.556 .683 .924 r
.22138 .38154 .23714 .39853 .26014 .3972 .24456 .37886 Metetra
.497 .642 .921 r
.24456 .37886 .26014 .3972 .2832 .39913 .26782 .37885 Metetra
.426 .585 .906 r
.26782 .37885 .2832 .39913 .30636 .40496 .29118 .38202 Metetra
.361 .519 .879 r
.29118 .38202 .30636 .40496 .3297 .41487 .31472 .38851 Metetra
.324 .463 .846 r
.31472 .38851 .3297 .41487 .35335 .42834 .33855 .39786 Metetra
.33 .431 .814 r
.33855 .39786 .35335 .42834 .37747 .44388 .3628 .40885 Metetra
.376 .428 .787 r
.3628 .40885 .37747 .44388 .40221 .45907 .38762 .41949 Metetra
.445 .445 .765 r
.38762 .41949 .40221 .45907 .42767 .47084 .41308 .42727 Metetra
.518 .474 .747 r
.41308 .42727 .42767 .47084 .45385 .47605 .4392 .42967 Metetra
.584 .505 .731 r
.4392 .42967 .45385 .47605 .48063 .47232 .4659 .4248 Metetra
.639 .534 .719 r
.4659 .4248 .48063 .47232 .5078 .45874 .49301 .41191 Metetra
.682 .562 .712 r
.49301 .41191 .5078 .45874 .53514 .43609 .52033 .39163 Metetra
.715 .587 .711 r
.52033 .39163 .53514 .43609 .56245 .40666 .54769 .36581 Metetra
.74 .612 .716 r
.54769 .36581 .56245 .40666 .5896 .37358 .57499 .33695 Metetra
.756 .636 .728 r
.57499 .33695 .5896 .37358 .61659 .33993 .60221 .30756 Metetra
.765 .659 .746 r
.60221 .30756 .61659 .33993 .64351 .30822 .6294 .27969 Metetra
.766 .682 .771 r
.6294 .27969 .64351 .30822 .67046 .27999 .65667 .25462 Metetra
.758 .703 .799 r
.65667 .25462 .67046 .27999 .69758 .25582 .6841 .23284 Metetra
.744 .72 .829 r
.6841 .23284 .69758 .25582 .72497 .23556 .71179 .21426 Metetra
.726 .731 .855 r
.71179 .21426 .72497 .23556 .75269 .21859 .73979 .19836 Metetra
.707 .738 .875 r
.73979 .19836 .75269 .21859 .78077 .20413 .76814 .1845 Metetra
.691 .741 .889 r
.76814 .1845 .78077 .20413 .80923 .19139 .79684 .17204 Metetra
.635 .727 .914 r
.15895 .37656 .17529 .39233 .19828 .38624 .1821 .36986 Metetra
.614 .714 .917 r
.1821 .36986 .19828 .38624 .22138 .38154 .20537 .36423 Metetra
.583 .693 .917 r
.20537 .36423 .22138 .38154 .24456 .37886 .22875 .36015 Metetra
.542 .66 .913 r
.22875 .36015 .24456 .37886 .26782 .37885 .25223 .35814 Metetra
.494 .616 .901 r
.25223 .35814 .26782 .37885 .29118 .38202 .27583 .35857 Metetra
.45 .564 .879 r
.27583 .35857 .29118 .38202 .31472 .38851 .29961 .36154 Metetra
.424 .516 .849 r
.29961 .36154 .31472 .38851 .33855 .39786 .32366 .36669 Metetra
.425 .483 .816 r
.32366 .36669 .33855 .39786 .3628 .40885 .34809 .37304 Metetra
.451 .469 .786 r
.34809 .37304 .3628 .40885 .38762 .41949 .37301 .37906 Metetra
.494 .472 .761 r
.37301 .37906 .38762 .41949 .41308 .42727 .39851 .38282 Metetra
.543 .486 .741 r
.39851 .38282 .41308 .42727 .4392 .42967 .42459 .38241 Metetra
.59 .505 .727 r
.42459 .38241 .4392 .42967 .4659 .4248 .45121 .37638 Metetra
.632 .527 .717 r
.45121 .37638 .4659 .4248 .49301 .41191 .47823 .36418 Metetra
.667 .55 .713 r
.47823 .36418 .49301 .41191 .52033 .39163 .5055 .34629 Metetra
.695 .574 .714 r
.5055 .34629 .52033 .39163 .54769 .36581 .53288 .3241 Metetra
.717 .598 .722 r
.53288 .3241 .54769 .36581 .57499 .33695 .56029 .29951 Metetra
.732 .622 .735 r
.56029 .29951 .57499 .33695 .60221 .30756 .58769 .27445 Metetra
.741 .647 .755 r
.58769 .27445 .60221 .30756 .6294 .27969 .61513 .25051 Metetra
.743 .671 .78 r
.61513 .25051 .6294 .27969 .65667 .25462 .64268 .22868 Metetra
.738 .693 .808 r
.64268 .22868 .65667 .25462 .6841 .23284 .6704 .20937 Metetra
.727 .712 .836 r
.6704 .20937 .6841 .23284 .71179 .21426 .69838 .19251 Metetra
.712 .725 .86 r
.69838 .19251 .71179 .21426 .73979 .19836 .72666 .17771 Metetra
.698 .733 .878 r
.72666 .17771 .73979 .19836 .76814 .1845 .75527 .16448 Metetra
.685 .738 .891 r
.75527 .16448 .76814 .1845 .79684 .17204 .78422 .15232 Metetra
.643 .73 .912 r
.14234 .36056 .15895 .37656 .1821 .36986 .16564 .35328 Metetra
.628 .719 .913 r
.16564 .35328 .1821 .36986 .20537 .36423 .1891 .34677 Metetra
.606 .703 .912 r
.1891 .34677 .20537 .36423 .22875 .36015 .21268 .34139 Metetra
.578 .677 .908 r
.21268 .34139 .22875 .36015 .25223 .35814 .23639 .3375 Metetra
.546 .643 .897 r
.23639 .3375 .25223 .35814 .27583 .35857 .26024 .33537 Metetra
.515 .602 .879 r
.26024 .33537 .27583 .35857 .29961 .36154 .28428 .33509 Metetra
.496 .562 .853 r
.28428 .33509 .29961 .36154 .32366 .36669 .30857 .33636 Metetra
.492 .529 .823 r
.30857 .33636 .32366 .36669 .34809 .37304 .33321 .33846 Metetra
.506 .509 .794 r
.33321 .33846 .34809 .37304 .37301 .37906 .35827 .34026 Metetra
.532 .503 .769 r
.35827 .34026 .37301 .37906 .39851 .38282 .38384 .34036 Metetra
.565 .507 .749 r
.38384 .34036 .39851 .38282 .42459 .38241 .40992 .33739 Metetra
.599 .518 .734 r
.40992 .33739 .42459 .38241 .45121 .37638 .43647 .33031 Metetra
.63 .533 .726 r
.43647 .33031 .45121 .37638 .47823 .36418 .46342 .31871 Metetra
.658 .552 .723 r
.46342 .31871 .47823 .36418 .5055 .34629 .49063 .30295 Metetra
.682 .573 .726 r
.49063 .30295 .5055 .34629 .53288 .3241 .51802 .28402 Metetra
.701 .596 .735 r
.51802 .28402 .53288 .3241 .56029 .29951 .54551 .26329 Metetra
.714 .62 .75 r
.54551 .26329 .56029 .29951 .58769 .27445 .57307 .24217 Metetra
.722 .644 .771 r
.57307 .24217 .58769 .27445 .61513 .25051 .60072 .22181 Metetra
.724 .669 .795 r
.60072 .22181 .61513 .25051 .64268 .22868 .62852 .20296 Metetra
.72 .691 .821 r
.62852 .20296 .64268 .22868 .6704 .20937 .65652 .18591 Metetra
.711 .709 .846 r
.65652 .18591 .6704 .20937 .69838 .19251 .68477 .17063 Metetra
.7 .723 .867 r
.68477 .17063 .69838 .19251 .72666 .17771 .71332 .15685 Metetra
.689 .731 .883 r
.71332 .15685 .72666 .17771 .75527 .16448 .74218 .14418 Metetra
.679 .736 .894 r
.74218 .14418 .75527 .16448 .78422 .15232 .77136 .13227 Metetra
.649 .732 .91 r
.12544 .34437 .14234 .36056 .16564 .35328 .1489 .33658 Metetra
.639 .725 .91 r
.1489 .33658 .16564 .35328 .1891 .34677 .17253 .32929 Metetra
.625 .712 .909 r
.17253 .32929 .1891 .34677 .21268 .34139 .19631 .32277 Metetra
.606 .693 .905 r
.19631 .32277 .21268 .34139 .23639 .3375 .22025 .31725 Metetra
.584 .667 .896 r
.22025 .31725 .23639 .3375 .26024 .33537 .24435 .31295 Metetra
.563 .636 .881 r
.24435 .31295 .26024 .33537 .28428 .33509 .26865 .30988 Metetra
.548 .602 .86 r
.26865 .30988 .28428 .33509 .30857 .33636 .29319 .30786 Metetra
.543 .573 .835 r
.29319 .30786 .30857 .33636 .33321 .33846 .31805 .30637 Metetra
.549 .551 .808 r
.31805 .30637 .33321 .33846 .35827 .34026 .34328 .30462 Metetra
.564 .539 .785 r
.34328 .30462 .35827 .34026 .38384 .34036 .36895 .30166 Metetra
.585 .536 .766 r
.36895 .30166 .38384 .34036 .40992 .33739 .39506 .29654 Metetra
.609 .54 .752 r
.39506 .29654 .40992 .33739 .43647 .33031 .42159 .28855 Metetra
.633 .551 .744 r
.42159 .28855 .43647 .33031 .46342 .31871 .4485 .27742 Metetra
.655 .566 .743 r
.4485 .27742 .46342 .31871 .49063 .30295 .47568 .26339 Metetra
.674 .584 .747 r
.47568 .26339 .49063 .30295 .51802 .28402 .50308 .24714 Metetra
.689 .605 .756 r
.50308 .24714 .51802 .28402 .54551 .26329 .53064 .2296 Metetra
.7 .627 .772 r
.53064 .2296 .54551 .26329 .57307 .24217 .55833 .21174 Metetra
.707 .651 .791 r
.55833 .21174 .57307 .24217 .60072 .22181 .58618 .19435 Metetra
.708 .674 .814 r
.58618 .19435 .60072 .22181 .62852 .20296 .6142 .17797 Metetra
.705 .694 .837 r
.6142 .17797 .62852 .20296 .65652 .18591 .64244 .16281 Metetra
.698 .711 .858 r
.64244 .16281 .65652 .18591 .68477 .17063 .67095 .14884 Metetra
.69 .723 .875 r
.67095 .14884 .68477 .17063 .71332 .15685 .69975 .13587 Metetra
.681 .731 .888 r
.69975 .13587 .71332 .15685 .74218 .14418 .72885 .12366 Metetra
.675 .736 .897 r
.72885 .12366 .74218 .14418 .77136 .13227 .75828 .11193 Metetra
.654 .735 .909 r
.10824 .328 .12544 .34437 .1489 .33658 .13186 .31976 Metetra
.647 .729 .908 r
.13186 .31976 .1489 .33658 .17253 .32929 .15565 .31183 Metetra
.638 .72 .907 r
.15565 .31183 .17253 .32929 .19631 .32277 .17963 .30438 Metetra
.626 .707 .904 r
.17963 .30438 .19631 .32277 .22025 .31725 .20379 .29756 Metetra
.612 .688 .897 r
.20379 .29756 .22025 .31725 .24435 .31295 .22812 .2915 Metetra
.598 .664 .885 r
.22812 .2915 .24435 .31295 .26865 .30988 .25267 .28623 Metetra
.587 .638 .869 r
.25267 .28623 .26865 .30988 .29319 .30786 .27746 .2816 Metetra
.581 .613 .849 r
.27746 .2816 .29319 .30786 .31805 .30637 .30253 .27729 Metetra
.583 .592 .827 r
.30253 .27729 .31805 .30637 .34328 .30462 .32795 .27277 Metetra
.592 .578 .807 r
.32795 .27277 .34328 .30462 .36895 .30166 .35374 .2674 Metetra
.605 .571 .79 r
.35374 .2674 .36895 .30166 .39506 .29654 .37992 .26059 Metetra
.621 .571 .777 r
.37992 .26059 .39506 .29654 .42159 .28855 .40648 .25186 Metetra
.638 .578 .77 r
.40648 .25186 .42159 .28855 .4485 .27742 .43338 .24105 Metetra
.655 .589 .769 r
.43338 .24105 .4485 .27742 .47568 .26339 .46057 .2283 Metetra
.669 .604 .773 r
.46057 .2283 .47568 .26339 .50308 .24714 .488 .21406 Metetra
.681 .622 .783 r
.488 .21406 .50308 .24714 .53064 .2296 .51563 .19894 Metetra
.69 .643 .797 r
.51563 .19894 .53064 .2296 .55833 .21174 .54346 .18355 Metetra
.695 .664 .815 r
.54346 .18355 .55833 .21174 .58618 .19435 .57147 .16844 Metetra
.695 .684 .835 r
.57147 .16844 .58618 .19435 .6142 .17797 .5997 .15394 Metetra
.693 .701 .854 r
.5997 .15394 .6142 .17797 .64244 .16281 .62817 .14021 Metetra
.687 .716 .87 r
.62817 .14021 .64244 .16281 .67095 .14884 .65692 .12721 Metetra
.681 .726 .884 r
.65692 .12721 .67095 .14884 .69975 .13587 .68595 .11484 Metetra
.675 .733 .893 r
.68595 .11484 .69975 .13587 .72885 .12366 .71529 .10293 Metetra
.671 .737 .9 r
.71529 .10293 .72885 .12366 .75828 .11193 .74495 .09129 Metetra
.658 .737 .908 r
.09074 .31144 .10824 .328 .13186 .31976 .1145 .30283 Metetra
.654 .733 .908 r
.1145 .30283 .13186 .31976 .15565 .31183 .13846 .29439 Metetra
.648 .727 .907 r
.13846 .29439 .15565 .31183 .17963 .30438 .16262 .28621 Metetra
.64 .717 .904 r
.16262 .28621 .17963 .30438 .20379 .29756 .18697 .27839 Metetra
.631 .704 .899 r
.18697 .27839 .20379 .29756 .22812 .2915 .21153 .27101 Metetra
.622 .688 .89 r
.21153 .27101 .22812 .2915 .25267 .28623 .2363 .26409 Metetra
.615 .669 .879 r
.2363 .26409 .25267 .28623 .27746 .2816 .26132 .25753 Metetra
.61 .649 .864 r
.26132 .25753 .27746 .2816 .30253 .27729 .28661 .25112 Metetra
.61 .631 .847 r
.28661 .25112 .30253 .27729 .32795 .27277 .31221 .24454 Metetra
.615 .618 .831 r
.31221 .24454 .32795 .27277 .35374 .2674 .33814 .2374 Metetra
.623 .61 .817 r
.33814 .2374 .35374 .2674 .37992 .26059 .36442 .22932 Metetra
.633 .608 .806 r
.36442 .22932 .37992 .26059 .40648 .25186 .39104 .22001 Metetra
.645 .611 .801 r
.39104 .22001 .40648 .25186 .43338 .24105 .41799 .20937 Metetra
.657 .619 .8 r
.41799 .20937 .43338 .24105 .46057 .2283 .44522 .19749 Metetra
.667 .631 .804 r
.44522 .19749 .46057 .2283 .488 .21406 .47271 .18464 Metetra
.676 .646 .813 r
.47271 .18464 .488 .21406 .51563 .19894 .50044 .1712 Metetra
.682 .663 .825 r
.50044 .1712 .51563 .19894 .54346 .18355 .52839 .15755 Metetra
.685 .68 .839 r
.52839 .15755 .54346 .18355 .57147 .16844 .55658 .14402 Metetra
.685 .696 .855 r
.55658 .14402 .57147 .16844 .5997 .15394 .585 .13083 Metetra
.683 .71 .869 r
.585 .13083 .5997 .15394 .62817 .14021 .61369 .11807 Metetra
.679 .721 .881 r
.61369 .11807 .62817 .14021 .65692 .12721 .64265 .10574 Metetra
.675 .729 .891 r
.64265 .10574 .65692 .12721 .68595 .11484 .67191 .09374 Metetra
.671 .734 .898 r
.67191 .09374 .68595 .11484 .71529 .10293 .70149 .08198 Metetra
.668 .738 .902 r
.70149 .08198 .71529 .10293 .74495 .09129 .73138 .07036 Metetra
.66 .738 .908 r
.07292 .29467 .09074 .31144 .1145 .30283 .09682 .28576 Metetra
.658 .736 .907 r
.09682 .28576 .1145 .30283 .13846 .29439 .12094 .27691 Metetra
.654 .732 .906 r
.12094 .27691 .13846 .29439 .16262 .28621 .14526 .26818 Metetra
.65 .726 .905 r
.14526 .26818 .16262 .28621 .18697 .27839 .1698 .25963 Metetra
.644 .717 .901 r
.1698 .25963 .18697 .27839 .21153 .27101 .19456 .2513 Metetra
.639 .706 .895 r
.19456 .2513 .21153 .27101 .2363 .26409 .21954 .24319 Metetra
.634 .693 .887 r
.21954 .24319 .2363 .26409 .26132 .25753 .24477 .23526 Metetra
.631 .679 .877 r
.24477 .23526 .26132 .25753 .28661 .25112 .27026 .22738 Metetra
.63 .666 .866 r
.27026 .22738 .28661 .25112 .31221 .24454 .29604 .21935 Metetra
.632 .655 .854 r
.29604 .21935 .31221 .24454 .33814 .2374 .32212 .21095 Metetra
.637 .647 .843 r
.32212 .21095 .33814 .2374 .36442 .22932 .34853 .20196 Metetra
.644 .644 .836 r
.34853 .20196 .36442 .22932 .39104 .22001 .37525 .19219 Metetra
.651 .645 .831 r
.37525 .19219 .39104 .22001 .41799 .20937 .40227 .18161 Metetra
.659 .651 .831 r
.40227 .18161 .41799 .20937 .44522 .19749 .42958 .17024 Metetra
.666 .66 .834 r
.42958 .17024 .44522 .19749 .47271 .18464 .45717 .15826 Metetra
.672 .671 .841 r
.45717 .15826 .47271 .18464 .50044 .1712 .48501 .14589 Metetra
.676 .684 .85 r
.48501 .14589 .50044 .1712 .52839 .15755 .51311 .13334 Metetra
.677 .697 .861 r
.51311 .13334 .52839 .15755 .55658 .14402 .54146 .12082 Metetra
.677 .709 .872 r
.54146 .12082 .55658 .14402 .585 .13083 .57007 .10845 Metetra
.675 .719 .882 r
.57007 .10845 .585 .13083 .61369 .11807 .59896 .09629 Metetra
.673 .727 .89 r
.59896 .09629 .61369 .11807 .64265 .10574 .62814 .08432 Metetra
.67 .733 .897 r
.62814 .08432 .64265 .10574 .67191 .09374 .65763 .07251 Metetra
.668 .736 .901 r
.65763 .07251 .67191 .09374 .70149 .08198 .68742 .06079 Metetra
.666 .739 .904 r
.68742 .06079 .70149 .08198 .73138 .07036 .71754 .04909 Metetra
.662 .74 .908 r
.05479 .27766 .07292 .29467 .09682 .28576 .07883 .2685 Metetra
.66 .738 .907 r
.07883 .2685 .09682 .28576 .12094 .27691 .10308 .25934 Metetra
.658 .736 .907 r
.10308 .25934 .12094 .27691 .14526 .26818 .12757 .25019 Metetra
.656 .732 .905 r
.12757 .25019 .14526 .26818 .1698 .25963 .15227 .24111 Metetra
.653 .727 .903 r
.15227 .24111 .1698 .25963 .19456 .2513 .17721 .2321 Metetra
.649 .72 .9 r
.17721 .2321 .19456 .2513 .21954 .24319 .20238 .22318 Metetra
.647 .711 .895 r
.20238 .22318 .21954 .24319 .24477 .23526 .2278 .21431 Metetra
.645 .702 .888 r
.2278 .21431 .24477 .23526 .27026 .22738 .25348 .20542 Metetra
.644 .693 .881 r
.25348 .20542 .27026 .22738 .29604 .21935 .27943 .19641 Metetra
.645 .685 .873 r
.27943 .19641 .29604 .21935 .32212 .21095 .30568 .18714 Metetra
.648 .679 .866 r
.30568 .18714 .32212 .21095 .34853 .20196 .33222 .1775 Metetra
.652 .676 .861 r
.33222 .1775 .34853 .20196 .37525 .19219 .35907 .16738 Metetra
.656 .677 .858 r
.35907 .16738 .37525 .19219 .40227 .18161 .3862 .15675 Metetra
.661 .68 .857 r
.3862 .15675 .40227 .18161 .42958 .17024 .41363 .14563 Metetra
.666 .686 .86 r
.41363 .14563 .42958 .17024 .45717 .15826 .44133 .13413 Metetra
.669 .694 .865 r
.44133 .13413 .45