(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    788399,      13906]*)
(*NotebookOutlinePosition[    852310,      15717]*)
(*  CellTagsIndexPosition[    846574,      15501]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.10 ", "HeadingNumber"],
  "Input and Output in Notebooks"
}], "Section",
  CellTags->{"S1.10.0", "0.1"}],

Cell[CellGroupData[{

Cell["1.10.1 Entering Greek Letters", "Subsection",
  CellTags->{"S1.10.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "click on ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
              " "
            }]], Cell["use a button in a palette "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Alpha]", "MR"],
              " "
            }]], Cell["use a full name "]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["a\[EscapeKey]", "MR"],
              "  or  \[EscapeKey]",
              StyleBox["alpha\[EscapeKey]", "MR"],
              " "
            }]], Cell[TextData[{
              "use a standard alias (shown below as \[AliasIndicator]",
              StyleBox["a\[AliasIndicator]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["\\alpha\[EscapeKey]", "MR"],
              " "
            }]], Cell["use a TeX alias "]},
          {Cell[TextData[{
              "\[EscapeKey]",
              StyleBox["&agr\[EscapeKey]", "MR"],
              " "
            }]], Cell["use an SGML alias "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.1"],

Cell["Ways to enter Greek letters in a notebook. ", "Caption",
  CellTags->"S1.10.1"],

Cell["Here is a palette for entering common Greek letters.", "MathCaption",
  CellTags->{"S1.10.1", "1.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001b0000Tb000`400?l00000o`00003o00<0oooo
03<c<`0c<c<0K`0c<c<000030?ooo`3^k^h0k^k^06l0<c<c00000`3oool0k^k^09VIV@1]09VIV@80
<c<c00000`3oool0k^k^09VIV@1]09VIV@80<c<c00000`3oool0k^k^09VIV@1]09VIV@80<c<c0000
0`3oool0k^k^09VIV@0209VIVFL0k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c
<f@0000000<0k^k^09VIV@2IVIT00P2IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`03
0=gMg@1EEED0EEEE00l0EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A05EEE@03
0=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd000000>k^kP0409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1@3MgMd3000000<0gMgM0`0000030=gMg@0305EE
E@3MgMd0oooo00D0gMgM2@0000030=gMg@0305EEE@3MgMd0oooo00L0gMgM1P0000040=gMg@0305EE
E@3MgMd0oooo00L0gMgM1@0000050=gMg@0305EEE@3MgMd0oooo00L0gMgM0`0000000`3MgMd00000
0000000200000080gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd00`3MgMd00`000000gMgM0=gMg@020=gMg@0305EE
E@3MgMd0oooo00D0gMgM00<000000=gMg@3MgMd01@3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gM
g@3oool02@3MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3MgMd0oooo00T0gMgM00<000000=gM
g@3MgMd01@3MgMd00`1EEED0gMgM0?ooo`090=gMg@030000003MgMd0000000D0gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM00<000000=gM
g@3MgMd00`3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00D0gMgM00<000000=gM
g@3MgMd01@3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool01`3MgMd6000000@0gMgM00<0
EEEE0=gMg@3oool01`3MgMd4000000H0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM0=gM
g@02000000@0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<`L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo00L0gMgM
00D000000=gMg@3MgMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo00H0gMgM00@000000=gMg@3M
gMd000000`3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool01P3MgMd01@000000gMgM0=gM
g@000000gMgM00800000103MgMd00`1EEED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM00<0gMgM
00P000000=gMg@3MgMd0gMgM05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI
0080VIVI0P0c<c<70=gMg@050000003MgMd0gMgM0=gMg@0000001@3MgMd00`1EEED0gMgM0?ooo`07
0=gMg@D000001@3MgMd00`1EEED0gMgM0?ooo`060=gMg@040000003MgMd0gMgM000000<0gMgM00L0
00000=gMg@3MgMd0gMgM05EEE@3MgMd0oooo00H0gMgM00@000000=gMg@3MgMd000000P3MgMd00`00
0000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00L0gMgM00<000000=gMg@3MgMd0103MgMd01`00
0000gMgM0=gMg@1EEED0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT2
03<c<`L0gMgM00@000000=gMg@3MgMd000001P3MgMd00`1EEED0gMgM0?ooo`070=gMg@050000003M
gMd0gMgM0=gMg@0000001@3MgMd00`1EEED0gMgM0?ooo`070=gMg@H00000103MgMd00`1EEED0gMgM
0?ooo`060=gMg@040000003MgMd0gMgM00000080gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0
gMgM0?ooo`070=gMg@030000003MgMd0gMgM00@0gMgM00L000000=gMg@3MgMd0EEEE0=gMg@000000
k^k^00@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<80=gMg@030000003MgMd00000
00H0gMgM00<0EEEE0=gMg@3oool01@3MgMd00`000000gMgM0=gMg@050=gMg@070000003MgMd0gMgM
0=gMg@1EEED0gMgM0?ooo`090=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE0=gMg@3oool02@3M
gMd00`000000gMgM0=gMg@050=gMg@0305EEE@3MgMd0oooo00P0gMgM00@000000=gMg@3MgMd0gMgM
0P0000030=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<80=gMg@8000001`3MgMd00`1EEED0gMgM0?ooo`050=gMg@T000000`3MgMd00`1EEED0gMgM
0?ooo`070=gMg@H00000103MgMd00`1EEED0gMgM0?ooo`070=gMg@D000001@3MgMd00`1EEED0gMgM
0?ooo`090=gMg@<000001@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c2@3MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4P3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gMg@3oool0oooo0140oooo
00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gMg@000000k^k^00@0VIVI
0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c
<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3MgMd0EEEE05EEE@0?05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0
k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`P0
gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<80=gMg@030000003MgMd0gMgM00H0
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0
k^k^09VIV@0209VIV@80<c<c1`3MgMd4000000H0gMgM00<0EEEE0=gMg@3oool01P3MgMd200000080
gMgM0P0000050=gMg@0305EEE@3MgMd0oooo00H0gMgM100000070=gMg@0305EEE@3MgMd0oooo00D0
gMgM2@0000030=gMg@0305EEE@3MgMd0oooo00T0gMgM0`0000050=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@060000003MgMd0gMgM0000
003MgMd000001@3MgMd00`1EEED0gMgM0?ooo`050=gMg@030000003MgMd0gMgM008000000P3MgMd0
0`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3MgMd0
0`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd0
0`1EEED0gMgM0?ooo`080=gMg@040000003MgMd0gMgM0=gMg@8000000`3MgMd0101EEED0gMgM0000
003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1P3MgMd01P000000gMgM0=gM
g@000000gMgM000000D0gMgM00<0EEEE0=gMg@3oool01@3MgMd01@000000gMgM0=gMg@3MgMd00000
00<0gMgM00L000000=gMg@3MgMd0gMgM05EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3M
gMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3M
gMd00`1EEED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM00<0gMgM00P000000=gMg@3MgMd0gMgM
05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@06
0000003MgMd0gMgM0000003MgMd000001@3MgMd00`1EEED0gMgM0?ooo`050=gMg@050000003MgMd0
gMgM0=gMg@0000000`3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool0203MgMd00`000000
gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gM
g@0305EEE@3MgMd0oooo00L0gMgM0P0000030=gMg@030000003MgMd000000080gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`L0gMgM00<000000=gM
g@0000000P3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00H0gMgM00@000000=gM
g@3MgMd000000`3MgMd01`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool0203MgMd00`000000gMgM
0=gMg@060=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gMg@03
05EEE@3MgMd0oooo00L0gMgM1P000000203MgMd000000=gMg@3MgMd0EEEE0=gMg@000000k^k^102I
VIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`L0gMgM00<000000=gMg@0000000P3MgMd0
0`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd0103MgMd0
1`000000gMgM0=gMg@3MgMd0EEEE0=gMg@3oool0203MgMd01@000000gMgM0=gMg@3MgMd0000000@0
gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo00L0
gMgM0P0000030=gMg@030000003MgMd000000080gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c
<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM0P0000020=gMg@040000003MgMd000000000
00<0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM
0080gMgM00<0EEEE0=gMg@3oool0203MgMd01@000000gMgM0=gMg@3MgMd0000000@0gMgM00<0EEEE
0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo00L0gMgM00<00000
0=gMg@3MgMd00`3MgMd020000000gMgM0=gMg@3MgMd0EEEE0=gMg@000000k^k^102IVIT203<c<`00
00<0oooo0>k^kP2IVIT00P2IVIT203<c<`X0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00H0gMgM1`0000040=gMg@0305EEE@3MgMd0oooo00P0gMgM
0P0000070=gMg@0305EEE@3MgMd0oooo00P0gMgM1@0000040=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<:0=gMg@030000003MgMd0gMgM00@0gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00T0gMgM
00<000000=gMg@3MgMd01@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<:0=gMg@030000003MgMd0gMgM00@0gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^
09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=T000000030>k^kP2IVIT0VIVI0080VIVI
0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c
<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@030000003^k^h0VIVI00<0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3MgMd0EEEE05EEE@0?05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A05EEE@030=gMg@3oool0gMgM
0140EEEE00<0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0
k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^
kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140
gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40
gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`080=gMg@030000003MgMd0gMgM00H0
gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00H0
gMgM00<000000=gMg@3MgMd00`3MgMd2000000<0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c
<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0
gMgM0?ooo`080=gMg@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000
gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3MgMd0gMgM000000050=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<70=gM
g@@000001P3MgMd00`1EEED0gMgM0?ooo`090=gMg@8000001P3MgMd00`1EEED0gMgM0?ooo`070=gM
g@@000001P3MgMd00`1EEED0gMgM0?ooo`070=gMg@@000001P3MgMd00`1EEED0gMgM0?ooo`080=gM
g@040000003MgMd0gMgM000000D0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@03
0=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd00P0000040=gMg@0305EEE@3MgMd0
oooo00H0gMgM00H000000=gMg@3MgMd000000=gMg@0000050=gMg@0305EEE@3MgMd0oooo00H0gMgM
00H000000=gMg@3MgMd000000=gMg@0000050=gMg@0305EEE@3MgMd0oooo00T0gMgM0P0000060=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gM
g@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`080=gM
g@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@000002
0=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd01P000000gMgM0=gMg@00
0000gMgM000000D0gMgM00<0EEEE0=gMg@3oool02P3MgMd00`000000gMgM0=gMg@040=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@030000
003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`080=gMg@030000
003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@0000020=gMg@03
0000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@0000020=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool02P3MgMd00`000000gMgM0=gMg@040=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gM
g@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`080=gM
g@030000003MgMd0gMgM00H0gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@000002
0=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd010000000gMgM0=gMg@00
00020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool02@3MgMd00`000000gMgM0000
00050=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c
<c<70=gMg@050000003MgMd0gMgM0=gMg@0000001@3MgMd00`1EEED0gMgM0?ooo`090=gMg@030000
003MgMd0gMgM00D0gMgM00<0EEEE0=gMg@3oool01`3MgMd01@000000gMgM0000003MgMd0000000D0
gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM000000020=gMg@030000003MgMd0gMgM0080
gMgM00<0EEEE0=gMg@3oool02@3MgMd010000000gMgM0=gMg@0000040=gMg@0405EEE@3MgMd00000
0>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<80=gMg@H000000`3MgMd00`1E
EED0gMgM0?ooo`070=gMg@H00000103MgMd00`1EEED0gMgM0?ooo`080=gMg@<000001P3MgMd00`1E
EED0gMgM0?ooo`070=gMg@030000003MgMd0gMgM008000001@3MgMd00`1EEED0gMgM0?ooo`070=gM
g@800000103MgMd200000080gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0:0=gM
g@030000003MgMd0gMgM00@0gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool02P3MgMd00`000000gMgM0=gMg@040=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo00X0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4P3oool00`3MgMd0oooo0?ooo`0A0?oo
o`030=gMg@3oool0oooo0140oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?oo
o`030=gMg@000000k^k^00@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c=S0=gMg@03
0000003^k^h0VIVI00<0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<00`3MgMd0EEEE
05EEE@0?05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo
0=gMg@0A05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0000003^k^h0102IVIT203<c<`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000
003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c
<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0
oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?oo
o`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000
003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1@3MgMd00`000000gMgM0=gM
g@090=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool01`3MgMd4000000H0gMgM00<0
EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00P0gMgM00@0
EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM00<0
00000=gMg@3MgMd0203MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00L0gMgM00D0
00000=gMg@3MgMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
1P3MgMd00`000000gMgM0=gMg@080=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@@000000P3MgMd00`000000gMgM0=gMg@020=gMg@0305EE
E@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0gMgM0?ooo`080=gMg@<00000
1P3MgMd00`1EEED0gMgM0?ooo`050=gMg@030000003MgMd0gMgM00<0gMgM0P0000040=gMg@0305EE
E@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd00`0000050=gMg@0405EEE@3MgMd000000>k^kP@0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@040000003MgMd0gMgM0=gMg@80
00001@3MgMd00`1EEED0gMgM0?ooo`080=gMg@8000001`3MgMd00`1EEED0gMgM0?ooo`060=gMg@80
00002@3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM0080gMgM00<000000=gMg@3M
gMd00`3MgMd00`1EEED0gMgM0?ooo`070=gMg@8000000`3MgMd00`000000gMgM0=gMg@020=gMg@04
05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@03
0000003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0gMgM0?ooo`080=gMg@80
00001`3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00P0gMgM00<0EEEE0=gMg@3o
ool01`3MgMd01@000000gMgM0=gMg@3MgMd0000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`00
0000gMgM0=gMg@030=gMg@080000003MgMd0gMgM0=gMg@1EEED0gMgM0000003^k^h409VIV@80<c<c
00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3MgMd01@000000gMgM0=gMg@3MgMd0000000D0gMgM
00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo00H0gMgM
00<000000=gMg@3MgMd0203MgMd00`1EEED0gMgM0?ooo`080=gMg@040000003MgMd0gMgM000000D0
gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@030=gMg@080000003MgMd0gMgM0=gM
g@1EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3MgMd0
1@000000gMgM0=gMg@3MgMd0000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd01@000000gMgM0=gM
g@3MgMd0000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd2000000P0gMgM00<0EEEE0=gMg@3oool0
203MgMd010000000gMgM0=gMg@0000050=gMg@0305EEE@3MgMd0oooo00L0gMgM00<000000=gMg@3M
gMd00`3MgMd020000000gMgM0=gMg@3MgMd0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo
0>k^kP2IVIT00P2IVIT203<c<`L0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@02
0=gMg@0305EEE@3MgMd0oooo00H0gMgM00<000000=gMg@3MgMd00P3MgMd00`000000gMgM0=gMg@03
0=gMg@0305EEE@3MgMd0oooo00T0gMgM0`0000050=gMg@0305EEE@3MgMd0oooo00P0gMgM00@00000
0=gMg@3MgMd000001@3MgMd00`1EEED0gMgM0?ooo`080=gMg@050000003MgMd0gMgM0=gMg@000000
103MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c
1`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool0
1@3MgMd00`000000gMgM0=gMg@040=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool0
203MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo00H0gMgM200000030=gMg@0305EE
E@3MgMd0oooo00T0gMgM0`0000050=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
203MgMd00`000000gMgM0=gMg@060=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
4@3MgMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c
4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00T0gMgM100000040=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<C0=gMg@030?oo
o`3MgMd0gMgM0140gMgM00<0oooo0=gMg@3MgMd04@3MgMd00`3oool0gMgM0=gMg@0A0=gMg@030?oo
o`3MgMd0gMgM0140gMgM00<000000>k^kP2IVIT00`2IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<a80oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gMg@3o
ool0oooo0140oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd000000>k^kP0409VIV@80<c<c0000
0`3oool0k^k^09VIV@0209VIV@80<c<c00<0gMgM05EEE@1EEED03`1EEED00`3MgMd0oooo0=gMg@0A
05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A
05EEE@030=gMg@000000k^k^00@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo00X0gMgM00<000000=gMg@3MgMd0103MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3MgMd4000000H0gMgM00<0EEEE0=gM
g@3oool02P3MgMd00`000000gMgM0=gMg@040=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gM
g@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<50=gMg@800000103MgMd00`000000gMgM0=gMg@030=gM
g@0305EEE@3MgMd0oooo00/0gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c2@3MgMd2000000H0gMgM00<0EEEE0=gM
g@3oool01P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0=gM
g@3oool01`3MgMd3000000L0gMgM00<0EEEE0=gMg@3oool01@3MgMd2000000@0gMgM0P0000040=gM
g@0305EEE@3MgMd0oooo00L0gMgM0P0000040=gMg@8000000P3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1P3MgMd3000000P0gMgM00<0EEEE0=gM
g@3oool01P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0=gM
g@3oool01P3MgMd010000000gMgM0=gMg@3MgMd2000000D0gMgM00<0EEEE0=gMg@3oool01P3MgMd0
1@000000gMgM0=gMg@3MgMd0000000H0gMgM00<0EEEE0=gMg@3oool02@3MgMd01@000000gMgM0=gM
g@3MgMd0000000<0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<`H0gMgM00<000000=gMg@3MgMd0203MgMd00`1EEED0gMgM0?ooo`060=gMg@030000
003MgMd0gMgM0080gMgM00<000000=gMg@3MgMd00`3MgMd00`1EEED0gMgM0?ooo`050=gMg@030000
003MgMd0gMgM00@0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`070=gMg@040000
003MgMd0gMgM000000H0gMgM00<0EEEE0=gMg@3oool02@3MgMd010000000gMgM0=gMg@0000040=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gM
g@030000003MgMd0gMgM00P0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@020=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01@3MgMd00`000000gMgM0=gMg@040=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01`3MgMd3000000L0gMgM00<0EEEE0=gM
g@3oool02P3MgMd00`000000gMgM000000040=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@030000003MgMd0gMgM00P0gMgM00<0EEEE0=gM
g@3oool01`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE0=gM
g@3oool01@3MgMd9000000<0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM000000070=gM
g@0305EEE@3MgMd0oooo00/0gMgM0P0000040=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<0
00030?ooo`3^k^h0VIVI0080VIVI0P0c<c<70=gMg@030000003MgMd0gMgM00L0gMgM00<0EEEE0=gM
g@3oool01`3MgMd2000000<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`050=gM
g@030000003MgMd0gMgM00D0gMgM00L000000=gMg@3MgMd0gMgM05EEE@3MgMd0oooo00L0gMgM00<0
00000=gMg@3MgMd00P0000050=gMg@0305EEE@3MgMd0oooo00`0gMgM00<000000=gMg@3MgMd00P3M
gMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1`3M
gMd00`000000gMgM00000002000000D0gMgM00<0EEEE0=gMg@3oool01P3MgMd2000000040=gMg@00
00000000000000D0gMgM00<0EEEE0=gMg@3oool01P3MgMd2000000@0gMgM00<000000=gMg@3MgMd0
0P3MgMd00`1EEED0gMgM0?ooo`060=gMg@800000103MgMd2000000<0gMgM00<0EEEE0=gMg@3oool0
303MgMd00`000000gMgM0=gMg@020=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?oo
o`3^k^h0VIVI0080VIVI0P0c<c<70=gMg@<000000P3MgMd2000000<0gMgM00<0EEEE0=gMg@3oool0
4@3MgMd00`1EEED0gMgM0?ooo`080=gMg@@000001@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo00/0gMgM00<000000=gMg@3MgMd00`3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c2P3MgMd3000000@0gMgM00<0EEEE0=gMg@3oool0
4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool0
2@3MgMd2000000H0gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT0
0P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h409VIV@80
<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EE
E@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0405EE
E@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<B0?ooo`030=gM
g@3oool0oooo0140oooo00<0gMgM0?ooo`3oool04@3oool00`3MgMd0oooo0?ooo`0A0?ooo`030=gM
g@3oool0oooo0140oooo00<0gMgM0000003^k^h0102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2I
VIT203<c<f<0gMgM00<000000>k^kP2IVIT00`2IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT2
03<c<`030=gMg@1EEED0EEEE00l0EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd0oooo0=gMg@0A
05EEE@030=gMg@3oool0gMgM0140EEEE00<0gMgM0?ooo`3MgMd04@1EEED00`3MgMd000000>k^kP04
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`0000<0oooo0>k^
kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM0000003^k^h4
09VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM0?ooo`0A0=gM
g@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<A0=gM
g@0305EEE@3MgMd0oooo00D0gMgM00<000000=gMg@3MgMd02@3MgMd00`1EEED0gMgM0?ooo`080=gM
g@8000001`3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gM
g@3oool01@3MgMd00`000000gMgM0=gMg@090=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gM
g@0000001P3MgMd00`1EEED0gMgM0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gM
g@000000k^k^102IVIT203<c<`0000<0oooo0>k^kP2IVIT00P2IVIT203<c<`H0gMgM0`0000030=gM
g@030000003MgMd0gMgM0080gMgM00<0EEEE0=gMg@3oool01P3MgMd00`000000gMgM000000020000
00H0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM000000060=gMg@0305EEE@3MgMd0oooo
00L0gMgM0`0000070=gMg@0305EEE@3MgMd0oooo00P0gMgM1@0000040=gMg@0405EEE@3MgMd00000
0>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<50=gMg@070000003MgMd0gMgM
0=gMg@000000gMgM000000050=gMg@0305EEE@3MgMd0oooo00H0gMgM0P0000030=gMg@030000003M
gMd0gMgM00<0gMgM00<0EEEE0=gMg@3oool02@3MgMd2000000H0gMgM00<0EEEE0=gMg@3oool01P3M
gMd010000000gMgM0=gMg@3MgMd2000000D0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`000000gMgM
0=gMg@030=gMg@080000003MgMd0gMgM0=gMg@1EEED0gMgM0000003^k^h409VIV@80<c<c00000`3o
ool0k^k^09VIV@0209VIV@80<c<c1@3MgMd00`000000gMgM0=gMg@020=gMg@8000001@3MgMd00`1E
EED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1E
EED0gMgM0?ooo`090=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE0=gMg@3oool01P3MgMd00`00
0000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00<0gMgM00<0EEEE0=gMg@3oool01`3MgMd00`00
0000gMgM0=gMg@070=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI
0080VIVI0P0c<c<50=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00`3MgMd00`1E
EED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1E
EED0gMgM0?ooo`090=gMg@8000001P3MgMd00`1EEED0gMgM0?ooo`060=gMg@030000003MgMd0gMgM
00<0gMgM00<000000=gMg@3MgMd00P3MgMd00`1EEED0gMgM0?ooo`070=gMg@H00000103MgMd0101E
EED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c1@3MgMd00`00
0000gMgM0=gMg@020=gMg@8000001@3MgMd00`1EEED0gMgM0?ooo`070=gMg@040000003MgMd0gMgM
0=gMg@800000103MgMd00`1EEED0gMgM0?ooo`090=gMg@030000003MgMd0000000D0gMgM00<0EEEE
0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM0080gMgM00<0EEEE
0=gMg@3oool01`3MgMd00`000000gMgM0=gMg@070=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c
<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<60=gMg@070000003MgMd0gMgM0=gMg@000000gMgM
000000040=gMg@0305EEE@3MgMd0oooo00L0gMgM00@000000=gMg@00000000001P3MgMd00`1EEED0
gMgM0?ooo`070=gMg@8000000P3MgMd2000000@0gMgM00<0EEEE0=gMg@3oool0203MgMd200000003
0=gMg@000000gMgM00@0gMgM00<0EEEE0=gMg@3oool0203MgMd00`000000gMgM0=gMg@060=gMg@04
05EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI0P0c<c<70=gMg@<0
00000P3MgMd00`000000gMgM0=gMg@020=gMg@0305EEE@3MgMd0oooo00L0gMgM00D000000=gMg@3M
gMd0gMgM000000050=gMg@0305EEE@3MgMd0oooo00D0gMgM0P0000060=gMg@070000003MgMd0gMgM
0=gMg@1EEED0gMgM0?ooo`090=gMg@8000001P3MgMd00`1EEED0gMgM0?ooo`090=gMg@D000000`3M
gMd0101EEED0gMgM0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3M
gMd00`1EEED0gMgM0?ooo`080=gMg@050000003MgMd0gMgM0=gMg@000000103MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo00P0gMgM00<000000=gMg@3MgMd01P3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<A0=gMg@0305EEE@3MgMd0oooo00T0gMgM0`0000050=gMg@0305EEE@3MgMd0oooo0140gMgM
00<0EEEE0=gMg@3oool02@3MgMd4000000@0gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM
0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00@0EEEE0=gMg@000000k^k^102IVIT203<c<`00
00<0oooo0>k^kP2IVIT00P2IVIT203<c<a40gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd0101EEED0gMgM
0000003^k^h409VIV@80<c<c00000`3oool0k^k^09VIV@0209VIV@80<c<c4@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0305EEE@3MgMd0oooo0140gMgM00<0EEEE0=gMg@3oool04@3MgMd00`1EEED0gMgM
0?ooo`0A0=gMg@0405EEE@3MgMd000000>k^kP@0VIVI0P0c<c<000030?ooo`3^k^h0VIVI0080VIVI
0P0c<c<C0=gMg@030?ooo`3MgMd0gMgM0140gMgM00<0oooo0=gMg@3MgMd04@3MgMd00`3oool0gMgM
0=gMg@0A0=gMg@030?ooo`3MgMd0gMgM0140gMgM00<000000>k^kP2IVIT00`2IVIT203<c<`0000<0
oooo0>k^kP2IVIT00P2IVIUV03<c<`030>k^kP2IVIT0VIVI0080VIVI0P0c<c<000030?ooo`3^k^h0
VIVI06d0VIVI0P0c<c<000030?ooo`3^k^h0VIVI06d0VIVI0P0c<c<000030?ooo`3^k^h0VIVI06d0
VIVI0P0c<c<000030?ooo`3^k^h0VIVI06d0VIVI0P0c<c<000030?ooo`3^k^h0k^k^06h0k^k^0@0c
<c<00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{114, 147},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.1"],

Cell["\<\
You can use Greek letters just like the ordinary letters that you \
type on your keyboard. \
\>", "MathCaption",
  CellTags->{"S1.10.1", "1.3"}],

Cell[CellGroupData[{

Cell["Expand[(\[Alpha] + \[Beta])^3]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.1"],

Cell[BoxData[
    \(\[Alpha]\^3 + 3\ \[Alpha]\^2\ \[Beta] + 
      3\ \[Alpha]\ \[Beta]\^2 + \[Beta]\^3\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.1"]
}, Open  ]],

Cell["\<\
There are several ways to enter Greek letters. This input uses full \
names. \
\>", "MathCaption",
  CellTags->{"S1.10.1", "1.4"}],

Cell[CellGroupData[{

Cell["Expand[(\\[Alpha] + \\[Beta])^3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.1"],

Cell[BoxData[
    \(\[Alpha]\^3 + 3\ \[Alpha]\^2\ \[Beta] + 
      3\ \[Alpha]\ \[Beta]\^2 + \[Beta]\^3\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Alpha]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Alpha]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["alpha\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Beta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Beta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["b\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["beta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Gamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Gamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["g\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["gamma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Delta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Delta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["d\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["delta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Epsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Epsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["epsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Zeta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Zeta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["z\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["zeta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Eta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Eta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["h\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["et\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["eta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Theta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Theta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["q\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["th\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["theta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Kappa]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Kappa]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["k\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["kappa\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Lambda]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Lambda]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["l\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["lambda\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Mu]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Mu]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["m\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["mu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Nu]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Nu]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["n\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["nu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Xi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Xi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["x\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["xi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Pi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Pi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["p\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["pi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Rho]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Rho]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["r\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["rho\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["s\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["sigma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Tau]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Tau]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["t\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["tau\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Phi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Phi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["f\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ph\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["phi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CurlyPhi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CurlyPhi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["j\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cph\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["cphi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Chi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Chi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ch\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["chi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Psi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Psi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["y\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ps\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["psi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Omega]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Omega]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["w\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["omega\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["aliases", "SO10"],
                          " "
                        }]]},
                      {Cell["\[CapitalGamma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalGamma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["G\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Gamma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalDelta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalDelta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["D\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Delta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalTheta]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalTheta]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Q\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Th\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Theta\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalLambda]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalLambda]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["L\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Lambda\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalPi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalPi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["P\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Pi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalSigma]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalSigma]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["S\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Sigma\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUpsilon]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUpsilon]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Upsilon\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalPhi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalPhi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["F\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Ph\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Phi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalChi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalChi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["C\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Ch\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Chi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalPsi]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalPsi]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Y\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Ps\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Psi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalOmega]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalOmega]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["W\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["Omega\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S1.10.1"],

Cell[TextData[{
  "Commonly used Greek letters. In aliases ",
  Cell[BoxData[
      \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
  " stands for the key ",
  Cell[BoxData[
      \(TraditionalForm\`\[EscapeKey]\)], "InlineFormula"],
  ". TeX aliases are not listed explicitly."
}], "Caption",
  CellTags->"S1.10.1"],

Cell[TextData[{
  "Note that in ",
  StyleBox["Mathematica", "TI"],
  " the letter ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " stands for ",
  StyleBox["Pi", "MR"],
  ". None of the other Greek letters have special meanings. "
}], "Text",
  CellTags->{"S1.10.1", "1.5"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  " stands for ",
  StyleBox["Pi", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.1", "1.6"}],

Cell[CellGroupData[{

Cell["N[\[Pi]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.1"],

Cell[BoxData[
    \(3.141592653589793`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.10.1"]
}, Open  ]],

Cell["\<\
You can use Greek letters either on their own or with other \
letters. \
\>", "MathCaption",
  CellTags->{"S1.10.1", "1.7"}],

Cell[CellGroupData[{

Cell["Expand[(R\[Alpha]\[Beta] + \[CapitalXi])^4]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.10.1"],

Cell[BoxData[
    \(R\[Alpha]\[Beta]\^4 + 4\ R\[Alpha]\[Beta]\^3\ \[CapitalXi] + 
      6\ R\[Alpha]\[Beta]\^2\ \[CapitalXi]\^2 + 
      4\ R\[Alpha]\[Beta]\ \[CapitalXi]\^3 + \[CapitalXi]\^4\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.10.1"]
}, Open  ]],

Cell[TextData[{
  "The symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  " is not related to the symbol ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.1", "1.8"}],

Cell[CellGroupData[{

Cell["Factor[\[Pi]\[Alpha]^4 - 1]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.10.1"],

Cell[BoxData[
    \(\((\(-1\) + \[Pi]\[Alpha])\)\ \((1 + \[Pi]\[Alpha])\)\ \((1 + \[Pi]\
\[Alpha]\^2)\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.10.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.10.2 Entering Two\[Hyphen]Dimensional Input\
\>", "Subsection",
  CellTags->{"S1.10.2", "2.1"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " reads the text ",
  StyleBox["x^y", "MR"],
  ", it interprets it as ",
  StyleBox["x", "MR"],
  " raised to the power\[NonBreakingSpace]",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.2"}],

Cell[CellGroupData[{

Cell["x^y", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^y\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "In a notebook, you can also give the two\[Hyphen]dimensional input ",
  Cell[BoxData[
      \(x\^y\)], "InlineFormula"],
  " directly. ",
  StyleBox["Mathematica", "TI"],
  " again interprets this as a power. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^y\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^y\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "One way to enter a two\[Hyphen]dimensional form such as ",
  Cell[BoxData[
      \(x\^y\)], "InlineFormula"],
  " into a ",
  StyleBox["Mathematica", "TI"],
  " notebook is to copy this form from a palette by clicking the appropriate \
button in the palette. "
}], "Text",
  CellTags->{"S1.10.2", "2.4"}],

Cell["\<\
Here is a palette for entering some common two\[Hyphen]dimensional \
notations. \
\>", "MathCaption",
  CellTags->{"S1.10.2", "2.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000200000DB000`400?l00000o`00003oP03oool0
07l0<c<c0@3oool000030>k^kP0c<c<0<c<c07`0<c<c0@3oool007d0VIVI0P0c<c<10?ooo`00O@2I
VIT203<c<`40oooo001m09VIV@80<c<c0@3oool000<0VIVIM`3^k^h309VIV@80<c<c0@3oool000<0
VIVI0P0c<c=c0000000303<c<`3^k^h0VIVI0080VIVI0P0c<c<10?ooo`000`2IVIT203<c<aX0EEEE
0P3oool^05EEE@80oooo9`1EEED00`0c<c<0k^k^09VIV@0209VIV@80<c<c0@3oool000<0VIVI0P0c
<c<I0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool09P3MgMd00`1EEED0<c<c0>k^
kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE
0?ooo`3oool09P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gM
g@0305EEE@3oool0oooo00P0gMgM1000000Q0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c
<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`040=gMg@<0
000000D0gMgM0000003MgMd0gMgM0000000Q0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c
<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`030=gMg@03
0000003MgMd0gMgM00<000000P3MgMd00`000000gMgM0=gMg@0O0=gMg@0305EEE@3oool0oooo02H0
gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo
0?ooo`060=gMg@H000008@3MgMd00`1EEED0oooo0?ooo`0<0=gMg@@0000000<0gMgM000000000000
0P0000000`3MgMd0000000000002000000`0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo
000309VIV@80<c<c2P3MgMd4000000/0gMgM00<0EEEE0?ooo`3oool01P3MgMd2000002D0gMgM00<0
EEEE0?ooo`3oool00P3MgMd9000000050=gMg@000000gMgM0=gMg@0000001P3MgMd010000000gMgM
0=gMg@00000<0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<`X0gMgM
00@000000=gMg@3MgMd000002`3MgMd00`1EEED0oooo0?ooo`060=gMg@8000009@3MgMd00`1EEED0
oooo0?ooo`030=gMg@<00000103MgMd00`000000gMgM000000020=gMg@030000003MgMd0000000<0
000000D0gMgM0000003MgMd0gMgM0000000<0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?oo
o`000`2IVIT203<c<`@0gMgM0`0000030=gMg@040000003MgMd0gMgM000000<0gMgM1P0000020=gM
g@0305EEE@3oool0oooo00H0gMgM0P00000:0=gMg@H00000103MgMd6000000<0gMgM1P0000020=gM
g@0305EEE@3oool0oooo00@0gMgM0P0000040=gMg@030000003MgMd0000000<000001P3MgMd40000
00@0gMgM1P0000020=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<`<0
gMgM0P0000000`3MgMd00000000000020=gMg@@000000`3MgMd600000080gMgM00<0EEEE0?ooo`3o
ool01P3MgMd2000000X0gMgM1P0000030=gMg@80000000D0gMgM000000000000gMgM000000030=gM
g@030000003MgMd0gMgM0080gMgM00@000000=gMg@3MgMd0EEEE0P3oool50=gMg@8000005`3MgMd6
00000080gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c0`3MgMd20000
0080gMgM0P0000080=gMg@H000000P3MgMd00`1EEED0oooo0?ooo`060=gMg@8000002P3MgMd60000
00<0gMgM0P0000001@3MgMd000000000003MgMd0000000<0gMgM00<000000=gMg@3MgMd00P3MgMd0
10000000gMgM0=gMg@1EEED20?ooo`H0gMgM0P00000F0=gMg@H000000P3MgMd00`1EEED0<c<c0>k^
kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<30=gMg@8000000P3MgMd2000000P0gMgM1P000002
0=gMg@0305EEE@3oool0oooo00H0gMgM0P00000:0=gMg@H000000`3MgMd2000000050=gMg@000000
00000=gMg@0000000`3MgMd00`000000gMgM0=gMg@020=gMg@040000003MgMd0gMgM05EEE@80oooo
1`3MgMd2000001D0gMgM1P0000020=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2I
VIT203<c<`@0gMgM0P0000000`3MgMd00000000000080=gMg@H000000P3MgMd00`1EEED0oooo0?oo
o`060=gMg@8000002P3MgMd6000000<0gMgM0P0000001@3MgMd000000000003MgMd0000000<0gMgM
00<000000=gMg@3MgMd00P3MgMd010000000gMgM0=gMg@1EEED20?ooo`H0gMgM0P00000F0=gMg@H0
00000P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<50=gMg@@00000
203MgMd600000080gMgM00<0EEEE0?ooo`3oool01P3MgMd2000000X0gMgM1P0000040=gMg@@00000
00<0gMgM0000003MgMd00P3MgMd600000080gMgM00<0EEEE0?ooo`3oool01@3MgMd2000000<0gMgM
00<000000=gMg@0000000`00000>0=gMg@H000000P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c
0@3oool000<0VIVI0P0c<c<70=gMg@800000403MgMd00`1EEED0oooo0?ooo`060=gMg@800000103M
gMd4000000h0gMgM0P0000000`3MgMd000000=gMg@0:0=gMg@0305EEE@3oool0oooo00@0gMgM0P00
00040=gMg@030000003MgMd000000080gMgM00<000000=gMg@3MgMd0503MgMd00`1EEED0<c<c0>k^
kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<40=gMg@@000004@3MgMd00`1EEED0oooo0?ooo`06
0=gMg@800000103MgMd010000000gMgM0=gMg@00000=0=gMg@D000002`3MgMd00`1EEED0oooo0?oo
o`030=gMg@P0000000D0gMgM0000003MgMd0gMgM0000000F0=gMg@0305EEE@0c<c<0k^k^00<0VIVI
0P0c<c<10?ooo`000`2IVIT203<c<aT0gMgM00<0EEEE0?ooo`3oool01P3MgMd200000080gMgM00<0
00000=gMg@0000000P3MgMd00`000000gMgM0=gMg@0K0=gMg@0305EEE@3oool0oooo00`0gMgM1000
000F0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<aT0gMgM00<0EEEE
0?ooo`3oool01`3MgMd300000080gMgM1000000M0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE
03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`0]0=gM
g@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80
<c<c6@3MgMd00`1EEED0oooo0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c<`3^
k^h00`2IVIT203<c<`40oooo000309VIV@80<c<cL`3oool00`0c<c<0k^k^09VIV@0209VIV@80<c<c
0@3oool000<0VIVI0P0c<c=c0?ooo`0303<c<`3^k^h0VIVI0080VIVI0P0c<c<10?ooo`000`2IVIT2
03<c<aX0EEEE0P3oool^05EEE@80oooo9`1EEED00`0c<c<0k^k^09VIV@0209VIV@80<c<c0@3oool0
00<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool09P3MgMd00`1E
EED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo02d0
gMgM00<0EEEE0?ooo`3oool09P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI
0P0c<c<;0=gMg@@000002P3MgMd00`1EEED0oooo0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0gMgM
00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c2`3MgMd010000000gMgM0=gM
g@00000:0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool09P3MgMd00`1EEED0<c<c
0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<;0=gMg@040000003MgMd0gMgM000000X0gMgM
00<0EEEE0?ooo`3oool0;@3MgMd00`1EEED0oooo0?ooo`0V0=gMg@0305EEE@0c<c<0k^k^00<0VIVI
0P0c<c<10?ooo`000`2IVIT203<c<`/0gMgM1000000:0=gMg@0305EEE@3oool0oooo02d0gMgM00<0
EEEE0?ooo`3oool09P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I
0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool09P3MgMd00`1EEED0<c<c0>k^kP03
09VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?oo
o`3oool09P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@03
05EEE@3oool0oooo0140gMgM00<000000=gMg@3MgMd06@3MgMd00`1EEED0oooo0?ooo`0<0=gMg@03
0000003MgMd0gMgM01L0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c
6@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@030000003MgMd0gMgM01T0gMgM00<0EEEE0?ooo`3oool0
303MgMd00`000000gMgM0=gMg@0G0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2I
VIT203<c<aT0gMgM00<0EEEE0?ooo`3oool0403MgMd2000000L0gMgM1P00000>0=gMg@0305EEE@3o
ool0oooo00/0gMgM0P0000070=gMg@H00000303MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3o
ool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo0100gMgM0P0000070=gMg@H000003P3MgMd0
0`1EEED0oooo0?ooo`0;0=gMg@8000001`3MgMd6000000`0gMgM00<0EEEE03<c<`3^k^h00`2IVIT2
03<c<`40oooo000309VIV@80<c<c203MgMd8000000T0gMgM00<0EEEE0?ooo`3oool03`3MgMd01000
0000gMgM0=gMg@0000060=gMg@H000003P3MgMd00`1EEED0oooo0?ooo`0:0=gMg@040000003MgMd0
gMgM000000H0gMgM1P00000<0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT2
03<c<aT0gMgM00<0EEEE0?ooo`3oool03`3MgMd010000000gMgM0=gMg@0000060=gMg@H000003P3M
gMd00`1EEED0oooo0?ooo`0:0=gMg@040000003MgMd0gMgM000000H0gMgM1P00000<0=gMg@0305EE
E@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<aT0gMgM00<0EEEE0?ooo`3oool02`3M
gMd010000000gMgM0=gMg@0000030=gMg@030000003MgMd0gMgM00@0gMgM1P00000>0=gMg@0305EE
E@3oool0oooo00H0gMgM00@000000=gMg@3MgMd000000`3MgMd00`000000gMgM0=gMg@040=gMg@H0
0000303MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<;0=gMg@@00000
2P3MgMd00`1EEED0oooo0?ooo`0<0=gMg@<000000`3MgMd00`000000gMgM0=gMg@040=gMg@H00000
3P3MgMd00`1EEED0oooo0?ooo`070=gMg@<000000`3MgMd00`000000gMgM0=gMg@040=gMg@H00000
303MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<;0=gMg@@000002P3M
gMd00`1EEED0oooo0?ooo`0=0=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd05`3M
gMd00`1EEED0oooo0?ooo`080=gMg@030000003MgMd0gMgM00<0gMgM00<000000=gMg@3MgMd05@3M
gMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<;0=gMg@@000002P3MgMd0
0`1EEED0oooo0?ooo`0C0=gMg@030000003MgMd0gMgM01L0gMgM00<0EEEE0?ooo`3oool03P3MgMd0
0`000000gMgM0=gMg@0E0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c
<`/0gMgM1000000:0=gMg@0305EEE@3oool0oooo01<0gMgM00<000000=gMg@3MgMd05`3MgMd00`1E
EED0oooo0?ooo`0:0=gMg@D000005`3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0
VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo01@0gMgM00<000000=gMg@3MgMd05P3MgMd00`1EEED0
oooo0?ooo`0:0=gMg@060000003MgMd0gMgM0000003MgMd000005P3MgMd00`1EEED0<c<c0>k^kP03
09VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo01@0gMgM00<000000=gM
g@3MgMd05P3MgMd00`1EEED0oooo0?ooo`0:0=gMg@060000003MgMd0gMgM0000003MgMd000005P3M
gMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0
oooo01@0gMgM3000000=0=gMg@0305EEE@3oool0oooo00X0gMgM100000000`3MgMd000000000000=
000000P0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1E
EED0oooo0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c
<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0
gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo
0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo
000309VIV@80<c<cL`3oool00`0c<c<0k^k^09VIV@0209VIV@80<c<c0@3oool000<0VIVI0P0c<c=c
0?ooo`0303<c<`3^k^h0VIVI0080VIVI0P0c<c<10?ooo`000`2IVIT203<c<aX0EEEE0P3oool^05EE
E@80oooo9`1EEED00`0c<c<0k^k^09VIV@0209VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@03
05EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool09P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80
<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool0
9P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI0P0c<c<I0=gMg@0305EEE@3o
ool0oooo02d0gMgM00<0EEEE0?ooo`3oool0503MgMd4000000h0gMgM00<0EEEE03<c<`3^k^h00`2I
VIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`0H0=gMg@@000004@3MgMd0
0`1EEED0oooo0?ooo`0D0=gMg@040000003MgMd0gMgM000000h0gMgM00<0EEEE03<c<`3^k^h00`2I
VIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`0H0=gMg@040000003MgMd0
gMgM00000140gMgM00<0EEEE0?ooo`3oool0503MgMd010000000gMgM0=gMg@00000>0=gMg@0305EE
E@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<`L0gMgM1P00000<0=gMg@0305EEE@3o
ool0oooo0140gMgM1P0000001@3MgMd000000=gMg@3MgMd000000140gMgM00<0EEEE0?ooo`3oool0
3@3MgMd6000000030=gMg@0000000000008000003P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c
0@3oool000<0VIVI0P0c<c<70=gMg@H00000303MgMd00`1EEED0oooo0?ooo`0A0=gMg@H0000000<0
gMgM0000000000000P00000A0=gMg@0305EEE@3oool0oooo00d0gMgM1P00000C0=gMg@0305EEE@0c
<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<`L0gMgM1P00000<0=gMg@0305EEE@3oool0
oooo0140gMgM1P00000F0=gMg@0305EEE@3oool0oooo00d0gMgM1P00000C0=gMg@0305EEE@0c<c<0
k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<`L0gMgM1P00000<0=gMg@0305EEE@3oool0oooo
0140gMgM1P00000F0=gMg@0305EEE@3oool0oooo00d0gMgM1P00000C0=gMg@0305EEE@0c<c<0k^k^
00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c<`L0gMgM1P0000000`3MgMd0000000000002000000L0
gMgM00<0EEEE0?ooo`3oool04@3MgMd6000001H0gMgM00<0EEEE0?ooo`3oool03@3MgMd600000003
0=gMg@0000000000008000003P3MgMd00`1EEED0<c<c0>k^kP0309VIV@80<c<c0@3oool000<0VIVI
0P0c<c<70=gMg@H0000000D0gMgM0000003MgMd0gMgM000000070=gMg@0305EEE@3oool0oooo0140
gMgM1P00000F0=gMg@0305EEE@3oool0oooo00d0gMgM1P0000001@3MgMd000000=gMg@3MgMd00000
00h0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c3P3MgMd010000000
gMgM0=gMg@0000070=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool0503MgMd01000
0000gMgM0=gMg@00000>0=gMg@0305EEE@0c<c<0k^k^00<0VIVI0P0c<c<10?ooo`000`2IVIT203<c
<`h0gMgM100000070=gMg@0305EEE@3oool0oooo02d0gMgM00<0EEEE0?ooo`3oool0503MgMd40000
00h0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIV@80<c<c6@3MgMd00`1EEED0
oooo0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0gMgM00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40
oooo000309VIV@80<c<c6@3MgMd00`1EEED0oooo0?ooo`0]0=gMg@0305EEE@3oool0oooo02H0gMgM
00<0EEEE03<c<`3^k^h00`2IVIT203<c<`40oooo000309VIVGH0<c<c00@0k^k^09VIV@2IVIT0VIVI
0P0c<c<10?ooo`00O@2IVIT203<c<`40oooo001m09VIV@80<c<c0@3oool007d0VIVI0P0c<c<10?oo
o`00O@2IVIT203<c<`40oooo001n0>k^kP40<c<c0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{128, 81},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.2"],

Cell["\<\
There are also several ways to enter two\[Hyphen]dimensional forms \
directly from the keyboard. \
\>", "Text",
  CellTags->{"S1.10.2", "2.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]^\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell["use control keys that exist on most keyboards "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]6\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell[
            "use control keys that should exist on all keyboards "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["^", "MR"],
              StyleBox["y", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " followed by ",
              StyleBox["Make 2D", "SR"],
              " "
            }]], Cell["use only ordinary printable characters "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.2"],

Cell[TextData[{
  "Ways to enter a superscript directly from the keyboard. \[ControlKey]\
\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] stands for Control\[Hyphen]Space."
}], "Caption",
  CellTags->"S1.10.2"],

Cell[TextData[{
  "You type \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " by holding down the Control key, then hitting the ",
  StyleBox["^", "MR"],
  " key. As soon as you do this, your cursor will jump to a superscript \
position. You can then type anything you want and it will appear in that \
position.   "
}], "Text",
  CellTags->{"S1.10.2", "2.7"}],

Cell[TextData[{
  "When you have finished, press \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] to move back down from the superscript position. \
\[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] stands for Control\[Hyphen]Space; you type it by holding \
down the Control key, then pressing the space bar. "
}], "Text",
  CellTags->{"S1.10.2", "2.8"}],

Cell[TextData[{
  "This sequence of keystrokes enters ",
  Cell[BoxData[
      \(x\^y\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.9"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " y"
}], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^y\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "Here the whole expression ",
  StyleBox["y+z", "MR"],
  " is in the superscript. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.10"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " y + z"
}], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^\(y + z\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "Pressing \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] (Control\[Hyphen]Space) takes you down from the \
superscript. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.11"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " y \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] + z"
}], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^y + z\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "You can remember the fact that \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " gives you a superscript by thinking of \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " as just a more immediate form of ",
  StyleBox["^", "MR"],
  ". When you type ",
  StyleBox["x^y", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will leave this one\[Hyphen]dimensional form unchanged until you \
explicitly process it. But if you type ",
  StyleBox["x", "MR"],
  " \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " ",
  StyleBox["y", "MR"],
  " then ",
  StyleBox["Mathematica", "TI"],
  " will immediately give you a superscript. "
}], "Text",
  CellTags->{"S1.10.2", "2.12"}],

Cell[TextData[{
  "On a standard English\[Hyphen]language keyboard, the character ",
  StyleBox["^", "MR"],
  " appears as the shifted version of ",
  StyleBox["6", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " therefore accepts \[ControlKey]\[LeftModified]",
  StyleBox["6\[RightModified]", "MR"],
  " as an alternative to \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  ". Note that if you are using something other than a standard English\
\[Hyphen]language keyboard, ",
  StyleBox["Mathematica", "TI"],
  " will almost always accept \[ControlKey]\[LeftModified]",
  StyleBox["6\[RightModified]", "MR"],
  " but may not accept \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.10.2", "2.13"}],

Cell["\<\
This is an alternative input form that avoids the use of control \
characters. \
\>", "MathCaption",
  CellTags->{"S1.10.2", "2.14"}],

Cell[CellGroupData[{

Cell["\\!\\( x \\^ y \\)", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^y\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "With this input form, ",
  StyleBox["Mathematica", "TI"],
  " automatically understands that the ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z", "MR"],
  " does not go in the superscript. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.15"}],

Cell[CellGroupData[{

Cell["\\!\\( x \\^ y + z \\)", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\^y + z\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "Using control characters minimizes the number of keystrokes that you need \
to type in order to enter a superscript. But particularly if you want to save \
your input in a file, or send it to another program, it is often more \
convenient to use a form that does not involve control characters. You can do \
this using \[Backslash]",
  StyleBox["!", "MR"],
  " sequences.     "
}], "Text",
  CellTags->{"S1.10.2", "2.16"}],

Cell[TextData[{
  "If you copy a \[Backslash]",
  StyleBox["!", "MR"],
  " sequence into ",
  StyleBox["Mathematica", "TI"],
  ", it will automatically jump into two\[Hyphen]dimensional form. But if you \
enter the sequence directly from the keyboard, you explicitly need to choose \
the ",
  StyleBox["Make 2D", "SR"],
  " menu item in order to get the two\[Hyphen]dimensional form. "
}], "Text",
  CellTags->{"S1.10.2", "2.17"}],

Cell[TextData[{
  "When entered from the keyboard \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " sequences are shown in literal form."
}], "MathCaption",
  CellTags->{"S1.10.2", "2.18"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool`3oool50000
o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<f40oooo0P00000X0?ooo`@00000:`3oool200000?l0oooo>`3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cH03oool2000002X0oooo0P00000]0?ooo`800000o`3ooolj0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=20?ooo`8000001`3oool2000000`0oooo0P0000050?ooo`8000001`3oool6000000X0
oooo0P00000B0?ooo`800000303oool00`000000oooo0?ooo`080?ooo`H00000203oool2000000D0
oooo0P00003o0?ooocX0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<d80oooo0P0000070?ooo`800000303oool20000
00@0oooo0P0000090?ooo`@000002`3oool200000180oooo0P00000<0?ooo`030000003oool0oooo
00P0oooo0P0000020?ooo`800000203oool2000000H0oooo0P00003o0?ooocT0oooo00<0003o0?oo
o`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<d40oooo0P00000E0?ooo`8000001@3oool2000000X0oooo0P00000;0?ooo`8000004P3oool4
000000T0oooo1@0000090?ooo`8000002P3oool2000000L0oooo0P00003o0?ooocT0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<d40oooo0P0000080?ooo`8000002`3oool2000000D0oooo0P00000:0?ooo`8000002`3o
ool200000180oooo1000000;0?ooo`030000003oool0oooo00X0oooo0P0000090?ooo`8000001`3o
ool200000?l0oooo>@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c@03oool2000000T0oooo0P00000:0?ooo`800000
1P3oool2000000T0oooo100000090?ooo`8000004P3oool200000080oooo0P00000:0?ooo`030000
003oool0oooo00P0oooo0P0000000`3oool00000000000070?ooo`800000203oool200000?l0oooo
>@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c@03oool2000000T0oooo0P00000:0?ooo`8000001`3oool2000000L0
oooo1P0000080?ooo`8000001@3oool200000080oooo0P0000060?ooo`P00000503oool6000000H0
oooo0P0000070?ooo`800000o`3ooolj0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<o0?ooo`8000002P3oool20000
00T0oooo0P0000080?ooo`800000503oool2000000L0oooo1000000^0?ooo`800000203oool20000
0?l0oooo>@3oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<o0?ooo`8000002P3oool2000000T0oooo0P0000090?ooo`8000004`3oool2
000000P0oooo0P00000_0?ooo`8000001`3oool200000?l0oooo>@3oool00`000?l0oooo0000o`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
oood0?ooo`040000o`3oool0oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo00D0003o0?ooo`3oool0oooo0000o`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob
0?ooo`H0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0
VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI
1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3o
ool00?l0iNGUo`3UiND;0>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.2"],

Cell[TextData[{
  "Choosing the ",
  StyleBox["Make 2D", "SR"],
  " item in the ",
  StyleBox["Edit", "SR"],
  " menu converts these sequences into two\[Hyphen]dimensional forms."
}], "MathCaption",
  CellTags->{"S1.10.2", "2.19"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool`3o
ool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=@3oool60000
00h0oooo00<000000?ooo`3oool01@3oool600000?l0ooooX03oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool4
000000l0oooo00<000000?ooo`3oool01@3oool200000080oooo0P00003o0?oooj00oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<cL0oooo0P00000>0?ooo`D000001P3oool200000?l0ooooX`3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
=`3oool200000100oooo00<000000?ooo`3oool01`3oool200000?l0ooooXP3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c=P3oool4000000<0oooo0P00000:0?ooo`030000003oool0oooo00D0oooo0P0000000`3oool0
00000000003o0?oooj40oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cD0oooo1P0000030?ooo`8000004@3oool60000
0?l0ooooX03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c?P3oool200000?l0oooo]`3oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?@3o
ool400000?l0oooo]@3oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`@00000o`3ooond0?ooo`030000o`3oool0003o00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`H0
0000o`3ooonb0?ooo`040000o`3oool0oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo00D0003o0?ooo`3oool0oooo0000
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooob0?ooo`H0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0
VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI
1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT10>GUi@40<c<c0@3o
ool00?l0iNGUo`3UiND;0>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.2"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]_\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell["use control keys that exist on most keyboards "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]-\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell[
            "use control keys that should exist on all keyboards "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["_", "MR"],
              StyleBox["y", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " followed by ",
              StyleBox["Make 2D", "SR"],
              " "
            }]], Cell["use only ordinary printable characters "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.2"],

Cell["Ways to enter a subscript directly from the keyboard. ", "Caption",
  CellTags->"S1.10.2"],

Cell[TextData[{
  "Subscripts in ",
  StyleBox["Mathematica", "TI"],
  " work very much like superscripts. However, whereas ",
  StyleBox["Mathematica", "TI"],
  " automatically interprets ",
  Cell[BoxData[
      \(x\^y\)], "InlineFormula"],
  " as ",
  StyleBox["x", "MR"],
  " raised to the power ",
  StyleBox["y", "MR"],
  ", it has no similar interpretation for ",
  Cell[BoxData[
      \(x\_y\)], "InlineFormula"],
  ". Instead, it just treats ",
  Cell[BoxData[
      \(x\_y\)], "InlineFormula"],
  " as a purely symbolic object. "
}], "Text",
  CellTags->{"S1.10.2", "2.20"}],

Cell[TextData[{
  "This enters ",
  StyleBox["y", "MR"],
  " as a subscript. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.21"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["_\[RightModified]", "MR"],
  " y"
}], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\_y\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "Here is another way to enter ",
  StyleBox["y", "MR"],
  " as a subscript. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.22"}],

Cell[CellGroupData[{

Cell["\\!\\( x \\_ y \\)", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\_y\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]/\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell["use control keys "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["/", "MR"],
              StyleBox["y", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " followed by ",
              StyleBox["Make 2D", "SR"],
              " "
            }]], Cell["use only ordinary printable characters "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.2"],

Cell["\<\
Ways to enter a built\[Hyphen]up fraction directly from the \
keyboard. \
\>", "Caption",
  CellTags->"S1.10.2"],

Cell[TextData[{
  "This enters the built\[Hyphen]up fraction ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          StyleBox["x",
            "TI"], 
          StyleBox["y",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.23"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["/\[RightModified]", "MR"],
  " y"
}], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\/y\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "Here the whole ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z", "MR"],
  " goes into the denominator. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.24"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["/\[RightModified]", "MR"],
  " y + z"
}], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\/\(y + z\)\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "But pressing Control\[Hyphen]Space takes you out of the denominator, so \
the ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z", "MR"],
  " does not appear in the denominator. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.25"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["/\[RightModified]", "MR"],
  " y \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] + z"
}], "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\/y + z\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " automatically interprets a built\[Hyphen]up fraction as a division. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.26"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(8888\/2222\)], "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell["\<\
Here is another way to enter a built\[Hyphen]up fraction. \
\>", \
"MathCaption",
  CellTags->{"S1.10.2", "2.27"}],

Cell[CellGroupData[{

Cell["\\!\\( 8888 \\/ 2222 \\)", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["@\[RightModified]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell["use control keys that exist on most keyboards "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["2\[RightModified]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell[
            "use control keys that should exist on all keyboards "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](\[Backslash]@", "MR"],
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " followed by ",
              StyleBox["Make 2D", "SR"],
              " "
            }]], Cell["use only ordinary printable characters "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.2"],

Cell["Ways to enter a square root directly from the keyboard. ", "Caption",
  CellTags->"S1.10.2"],

Cell["This enters a square root. ", "MathCaption",
  CellTags->{"S1.10.2", "2.28"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[ControlKey]\[LeftModified]",
  StyleBox["@\[RightModified]", "MR"],
  " x + y"
}], "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(\@\(x + y\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell["\<\
Control\[Hyphen]Space takes you out of the square root. \
\>", \
"MathCaption",
  CellTags->{"S1.10.2", "2.29"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[ControlKey]\[LeftModified]",
  StyleBox["@\[RightModified]", "MR"],
  " x \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] + y"
}], "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(\@x + y\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell["Here is a form without control characters. ", "MathCaption",
  CellTags->{"S1.10.2", "2.30"}],

Cell[CellGroupData[{

Cell["\\!\\( \\@ x + y \\)", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(\@x + y\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "And here is the usual one\[Hyphen]dimensional ",
  StyleBox["Mathematica", "TI"],
  " input that gives the same output expression. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.31"}],

Cell[CellGroupData[{

Cell["Sqrt[x] + y", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(\@x + y\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["^\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["6\[RightModified]", "MR"],
              " "
            }]], Cell["go to the superscript position "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["_\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["-\[RightModified]", "MR"],
              " "
            }]], Cell["go to the subscript position "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["@\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["2\[RightModified]", "MR"],
              " "
            }]], Cell["go into a square root "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["%\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["5\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
go from subscript to superscript or vice versa, or to \
the exponent position in a root \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["/\[RightModified]", "MR"],
              " "
            }]], Cell["go to the denominator for a fraction "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], 
            Cell["\<\
return from a special position (Control\[Hyphen]Space) \
\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True}},
  CellTags->"S1.10.2"],

Cell["\<\
Special input forms based on control characters. The second forms \
given should work on any keyboard. \
\>", "Caption",
  CellTags->"S1.10.2"],

Cell[TextData[{
  "This puts both a subscript and a superscript on ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.32"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " y \[ControlKey]\[LeftModified]",
  StyleBox["%\[RightModified]", "MR"],
  " z"
}], "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\_z\%y\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell["Here is another way to enter the same expression. ", "MathCaption",
  CellTags->{"S1.10.2", "2.33"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["_\[RightModified]", "MR"],
  " z \[ControlKey]\[LeftModified]",
  StyleBox["%\[RightModified]", "MR"],
  " y"
}], "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(x\_z\%y\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]], 
            Cell["\<\
all two\[Hyphen]dimensional input and grouping within \
it\
\>"]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]^", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "superscript ",
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " within \[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "subscript ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " within \[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]^", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell[TextData[{
              "subscript and superscript ",
              Cell[BoxData[
                  FormBox[
                    SubsuperscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["z",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " within \[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["@", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              "square root ",
              Cell[BoxData[
                  FormBox[
                    SqrtBox[
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " within \[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]/", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "built\[Hyphen]up fraction ",
              Cell[BoxData[
                  FormBox[
                    FractionBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " within \[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash])", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.2"],

Cell["\<\
Special input forms that generate two\[Hyphen]dimensional input \
with the Make 2D menu item. \
\>", "Caption",
  CellTags->"S1.10.2"],

Cell[TextData[{
  "You must preface the outermost \[Backslash]",
  StyleBox["(", "MR"],
  " with \[Backslash]",
  StyleBox["!", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.34"}],

Cell[CellGroupData[{

Cell["\\!\\(a \\/ b + \\@ c \\) + d", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(a\/b + \@c + d\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "You can use \[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " to indicate the grouping of elements in an expression without introducing \
explicit parentheses. "
}], "MathCaption",
  CellTags->{"S1.10.2", "2.35"}],

Cell[CellGroupData[{

Cell["\\!\\(a \\/ \\( b + \\@ c \\) \\) + d", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S1.10.2"],

Cell[BoxData[
    \(a\/\(b + \@c\) + d\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[TextData[{
  "In addition to subscripts and superscripts, ",
  StyleBox["Mathematica", "TI"],
  " also supports the notion of underscripts and \
overscripts\[LongDash]elements that go directly underneath or above. Among \
other things, you can use underscripts and overscripts to enter the limits of \
sums and products. "
}], "Text",
  CellTags->{"S1.10.2", "2.36"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]+\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]=\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell[TextData[{
              "create an underscript ",
              Cell[BoxData[
                  UnderscriptBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["y",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["+", "MR"],
              StyleBox["y", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " followed by ",
              StyleBox["Make 2D", "SR"],
              " "
            }]], Cell[TextData[{
              "create an underscript ",
              Cell[BoxData[
                  UnderscriptBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["y",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]&\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified]  or  ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]7\[RightModified]", "MR"],
              
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["\[ControlKey]\[LeftModified]", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell[TextData[{
              "create an overscript ",
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["y",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["x", "TI"],
              "\[Backslash]",
              StyleBox["&", "MR"],
              StyleBox["y", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " followed by ",
              StyleBox["Make 2D", "SR"],
              " "
            }]], Cell[TextData[{
              "create an overscript ",
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["y",
                      "TI"]]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S1.10.2"],

Cell["Creating underscripts and overscripts.", "Caption",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.10.3 Editing and Evaluating Two\[Hyphen]Dimensional Expressions\
\
\>", "Subsection",
  CellTags->{"S1.10.3", "3.1"}],

Cell["\<\
When you see a two\[Hyphen]dimensional expression on the screen, \
you can edit it much as you would edit text. You can for example place your \
cursor somewhere and start typing. Or you can select a part of the \
expression, then remove it using the Delete key, or insert a new version by \
typing it in. \
\>", "Text",
  CellTags->{"S1.10.3", "3.2"}],

Cell["\<\
In addition to ordinary text editing features, there are some keys \
that you can use to move around in two\[Hyphen]dimensional expressions. \
\
\>", "Text",
  CellTags->{"S1.10.3", "3.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox[".\[RightModified]", "MR"],
              " "
            }]], Cell["select the next larger subexpression "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], Cell["move to the right of the current structure "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
              " "
            }]], Cell["move to the next character "]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftArrow] \)], "InlineFormula"],
              " "
            }]], Cell["move to the previous character "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.3"],

Cell["\<\
Ways to move around in two\[Hyphen]dimensional expressions. \
\>", \
"Caption",
  CellTags->"S1.10.3"],

Cell[TextData[{
  "This shows the sequence of subexpressions selected by repeatedly typing \
\[ControlKey]\[LeftModified]",
  StyleBox[".\[RightModified]", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S1.10.3", "3.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0001TB000`400?l00000o`00003o0P3ooooo
03<c<ol0<c<c2@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`0c<c?o03<c<`P0<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oooc00g]kN00<000000=kNgP3Ng]h0o`3Ng]j60=kN
gRX0oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<>0?oooc00g]kN00<000000=kNgP3Ng]h0o`3Ng]j60=kNgRh0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c3P3oool_0=kNgP800000203Ng]h300000?l0g]kNO@3Ng]h^0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`h0oooo;`3Ng]h00`000000g]kN000000060=kNgP050000003Ng]h0g]kN0=kNgP000000o`3Ng]il
0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool^0=kNgP040000003Ng]h0g]kN000000X0g]kN00<0
00000=kNgP3Ng]h0o`3Ng]ij0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool/0=kNgP030000003N
g]h000000080g]kN00<000000=kNgP3Ng]h0203Ng]h00`000000g]kN0=kNgP1G0=kNgP<00000H03N
g]h3000007T0g]kN0`0000100=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool]0=kNgP030000003N
g]h0g]kN0080g]kN00<000000=kNgP3Ng]h01@3Ng]h2000005T0g]kN00D000000=kNgP3Ng]h0g]kN
0000001N0=kNgP050000003Ng]h0g]kN0=kNgP000000N`3Ng]h00`000000g]kN0=kNgP0m0=kNgRh0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c3P3ooolb0=kNgP030000003Ng]h0g]kN00L0g]kN00<000000=kNgP3N
g]h0FP3Ng]h00`000000g]kN0=kNgP1L0=kNgP050000003Ng]h0g]kN0=kNgP000000O03Ng]h00`00
0000g]kN0=kNgP0l0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooolb0=kNgP030000003Ng]h0g]kN
00<0g]kN00D000000=kNgP3Ng]h0g]kN0000001L0=kNgP030000003Ng]h0g]kN05`0g]kN00D00000
0=kNgP3Ng]h0g]kN0000001i0=kNgP@00000?P3Ng]h^0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo<P3N
g]h00`000000g]kN0=kNgP040=kNgP<00000F`3Ng]h2000005l0g]kN1000001i0=kNgP050000003N
g]h0g]kN0=kNgP000000?P3Ng]h^0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo<`3Ng]h00`000000g]kN
0=kNgP1S0=kNgP030000003Ng]h0g]kN05`0g]kN00<000000=kNgP3Ng]h0NP3Ng]h01@000000g]kN
0=kNgP3Ng]h0000003h0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oooc<0g]kN00<000000=kNgP3N
g]h0G`3Ng]h01@000000g]kN0=kNgP3Ng]h0000005l0g]kN00<000000=kNgP3Ng]h0N@3Ng]h01@00
0000g]kN0=kNgP3Ng]h0000003h0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oooc<0g]kN3000001G
0=kNgP<00000H@3Ng]h3000007T0g]kN0`00000o0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooooo
0=kNg[T0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooool0g]kN^@3Ng]h^0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<`h0ooooJP3Ng]h00`000000g]kN0=kNgP330=kNgP030000003Ng]h0g]kN08D0g]kN;P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<>0?ooofX0g]kN00<000000=kNgP3Ng]h0``3Ng]h00`000000g]kN0=kNgP25
0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool00`3Ng]h0000000000003000000<0g]kNF0000007
0=kNgPD000001P3Ng]i9000000H0g]kN1@0000060=kNgU/000001P3Ng]h5000000H0g]kNO0000003
0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooomZ0=kNgP030000003Ng]h0g]kN0<<0g]kN00<00000
0=kNgP3Ng]h0Q@3Ng]h^0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooJP3Ng]h00`000000g]kN0=kNgP33
0=kNgP030000003Ng]h0g]kN08D0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooool0g]kN^@3Ng]h^
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`h0ooooAP3Ng]h00`000000g]kN0=kNgP3o0=kNgW00g]kN;P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<>0?ooodH0g]kN00<000000=kNgP3Ng]h0?03Ng]h3000005L0g]kN0`00001Y
0=kNgP<00000JP3Ng]h^0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooA@3Ng]h200000440g]kN00<00000
0=kNgP3Ng]h00P3Ng]h2000002L0g]kN0P00000Z0=kNgP030000003Ng]h0g]kN0080g]kN0P00000i
0=kNgP800000:P3Ng]h00`000000g]kN0=kNgP020=kNgP800000F`3Ng]h2000000H0g]kN;P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<>0?oood@0g]kN00<000000=kNgP000000@@3Ng]h00`000000g]kN0=kNgP02
0=kNgP030000003Ng]h0g]kN02L0g]kN00<000000=kNgP3Ng]h0:03Ng]h00`000000g]kN0=kNgP02
0=kNgP030000003Ng]h0g]kN03T0g]kN00<000000=kNgP3Ng]h0:03Ng]h00`000000g]kN0=kNgP02
0=kNgP030000003Ng]h0g]kN05/0g]kN00<000000=kNgP3Ng]h0103Ng]h^0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<`h0oooo@@3Ng]h01P000000g]kN0=kNgP000000g]kN000000H0g]kN0P00000V0=kNgPH00000
0`3Ng]h3000000@0g]kN100000040=kNgP030000003Ng]h0g]kN00X0g]kN1@00000>0=kNgP800000
0`3Ng]h2000000<0g]kN00<000000=kNgP3Ng]h05@3Ng]h6000000<0g]kN0`0000040=kNgP@00000
103Ng]h00`000000g]kN0=kNgP020=kNgPD000003P3Ng]h2000000<0g]kN0P00000=0=kNgP800000
0`3Ng]h2000000T0g]kN00<000000=kNgP3Ng]h05@3Ng]h6000000<0g]kN0`0000040=kNgP@00000
103Ng]h00`000000g]kN0=kNgP0:0=kNgPD000003P3Ng]h2000000<0g]kN0P00000=0=kNgP800000
0`3Ng]h2000001<0g]kN0P0000030=kNgP8000002@3Ng]h00`000000g]kN0=kNgP040=kNgRh0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c3P3ooom20=kNgP8000000`3Ng]h00`000000g]kN0=kNgP020=kNgP040000
003Ng]h0g]kN000002H0g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP050000003Ng]h0g]kN
0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kNgP3Ng]h0303N
g]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00D0g]kN00D000000=kNgP3Ng]h0g]kN
000000040=kNgP030000003Ng]h0g]kN01H0g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP05
0000003Ng]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<00000
0=kNgP3Ng]h0103Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00D0g]kN00D00000
0=kNgP3Ng]h0g]kN000000070=kNgP030000003Ng]h0g]kN00D0g]kN00D000000=kNgP3Ng]h0g]kN
0000000:0=kNgP030000003Ng]h0g]kN01H0g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP05
0000003Ng]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<00000
0=kNgP3Ng]h0303Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00D0g]kN00D00000
0=kNgP3Ng]h0g]kN000000070=kNgP030000003Ng]h0g]kN00D0g]kN00D000000=kNgP3Ng]h0g]kN
0000000=0=kNgP030000003Ng]h0g]kN00D0g]kN00D000000=kNgP3Ng]h0g]kN0000000:0=kNgP03
0000003Ng]h0g]kN00@0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oood<0g]kN00D000000=kNgP3N
g]h0g]kN000000070=kNgP030000003Ng]h0g]kN02@0g]kN00D000000=kNgP3Ng]h0g]kN00000002
0=kNgP050000003Ng]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN
00<000000=kNgP3Ng]h0303Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00H0g]kN
00<000000=kNgP0000001@3Ng]h00`000000g]kN0=kNgP0F0=kNgP050000003Ng]h0g]kN0=kNgP00
00000P3Ng]h01@000000g]kN0=kNgP3Ng]h000000080g]kN00D000000=kNgP3Ng]h0g]kN00000004
0=kNgP030000003Ng]h0g]kN00@0g]kN00<000000=kNgP3Ng]h01`3Ng]h00`000000g]kN0=kNgP06
0=kNgP030000003Ng]h0000000P0g]kN00<000000=kNgP3Ng]h01P3Ng]h00`000000g]kN0000000;
0=kNgP030000003Ng]h0g]kN01H0g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP050000003N
g]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kNgP3N
g]h0303Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00H0g]kN00<000000=kNgP00
0000203Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0000000h0g]kN00<000000=kNgP3N
g]h01P3Ng]h00`000000g]kN0000000;0=kNgP030000003Ng]h0g]kN00@0g]kN;P3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<>0?ooodL0g]kN00<000000=kNgP3Ng]h0103Ng]h00`000000g]kN0=kNgP0U0=kNgP03
0000003Ng]h0g]kN00@0g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP050000003Ng]h0g]kN
0=kNgP000000103Ng]h00`000000g]kN0=kNgP020=kNgPD000001@3Ng]h00`000000g]kN0=kNgP05
0=kNgPD000001`3Ng]h00`000000g]kN0=kNgP040=kNgP030000003Ng]h0g]kN01H0g]kN00<00000
0=kNgP3Ng]h0103Ng]h01@000000g]kN0=kNgP3Ng]h000000080g]kN00D000000=kNgP3Ng]h0g]kN
000000040=kNgP030000003Ng]h0g]kN00@0g]kN00<000000=kNgP3Ng]h01@3Ng]h5000000L0g]kN
00<000000=kNgP3Ng]h01@3Ng]h5000000L0g]kN00<000000=kNgP3Ng]h02P3Ng]h00`000000g]kN
0=kNgP0F0=kNgP030000003Ng]h0g]kN00@0g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP05
0000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP020=kNgPD000001@3Ng]h00`00
0000g]kN0=kNgP050=kNgPD000001`3Ng]h00`000000g]kN0=kNgP050=kNgPD000001`3Ng]h00`00
0000g]kN0=kNgP0;0=kNgPD000001`3Ng]h00`000000g]kN0=kNgP0:0=kNgP030000003Ng]h0g]kN
00@0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN0P00000=0=kNgP030000003Ng]h0g]kN
0080g]kN00@000000=kNgP3Ng]h000002`3Ng]h2000001T0g]kN00<000000=kNgP3Ng]h0103Ng]h0
1@000000g]kN0=kNgP3Ng]h000000080g]kN00D000000=kNgP3Ng]h0g]kN000000040=kNgP030000
003Ng]h0g]kN00`0g]kN00<000000=kNgP3Ng]h01`3Ng]h00`000000g]kN0=kNgP060=kNgP030000
003Ng]h0000000D0g]kN00<000000=kNgP3Ng]h05P3Ng]h00`000000g]kN0=kNgP040=kNgP050000
003Ng]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kN
gP3Ng]h0103Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00H0g]kN00<000000=kN
gP000000203Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0000000/0g]kN00<000000=kN
gP3Ng]h05P3Ng]h00`000000g]kN0=kNgP040=kNgP050000003Ng]h0g]kN0=kNgP0000000P3Ng]h0
1@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kNgP3Ng]h0303Ng]h00`000000g]kN0=kN
gP070=kNgP030000003Ng]h0g]kN00H0g]kN00<000000=kNgP000000203Ng]h00`000000g]kN0=kN
gP060=kNgP030000003Ng]h0000000h0g]kN00<000000=kNgP3Ng]h01P3Ng]h00`000000g]kN0000
000;0=kNgP030000003Ng]h0g]kN00@0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<0
00000=kNgP3Ng]h0303Ng]h00`000000g]kN0=kNgP030=kNgP8000003@3Ng]h00`000000g]kN0=kN
gP0G0=kNgP030000003Ng]h0g]kN00D0g]kN0`0000040=kNgP<0000000<0g]kN0000003Ng]h00P3N
g]h00`000000g]kN0=kNgP0<0=kNgP030000003Ng]h0g]kN00L0g]kN00<000000=kNgP3Ng]h0103N
g]h3000000040=kNgP0000000000000000<0g]kN00<000000=kNgP3Ng]h05P3Ng]h00`000000g]kN
0=kNgP050=kNgP<00000103Ng]h3000000030=kNgP000000g]kN0080g]kN00<000000=kNgP3Ng]h0
103Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00@0g]kN0`000000103Ng]h00000
0000000000060=kNgP030000003Ng]h0g]kN00@0g]kN0`0000000`3Ng]h0000000000005000000D0
g]kN00<000000=kNgP3Ng]h05P3Ng]h00`000000g]kN0=kNgP050=kNgP<00000103Ng]h300000003
0=kNgP000000g]kN0080g]kN00<000000=kNgP3Ng]h0303Ng]h00`000000g]kN0=kNgP070=kNgP03
0000003Ng]h0g]kN00@0g]kN0`000000103Ng]h000000000000000060=kNgP030000003Ng]h0g]kN
00@0g]kN0`0000000`3Ng]h0000000000005000000P0g]kN00<000000=kNgP3Ng]h0103Ng]h30000
00050=kNgP00000000000000003Ng]h00P0000060=kNgP030000003Ng]h0g]kN00@0g]kN;P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h0303Ng]h00`000000g]kN0=kNgP0B
0=kNgP030000003Ng]h0g]kN01L0g]kN00<000000=kNgP3Ng]h0503Ng]h00`000000g]kN0=kNgP0:
0=kNgP<000006P3Ng]h00`000000g]kN0=kNgP0F0=kNgP030000003Ng]h0g]kN01@0g]kN00<00000
0=kNgP3Ng]h00P3Ng]h3000002`0g]kN00<000000=kNgP3Ng]h01@3Ng]h00`000000g]kN0=kNgP0F
0=kNgP030000003Ng]h0g]kN01@0g]kN00<000000=kNgP3Ng]h02P3Ng]h3000002`0g]kN00<00000
0=kNgP3Ng]h05P3Ng]h010000000g]kN0=kNgP0000050=kNgP030000003Ng]h0g]kN00@0g]kN;P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h03@3Ng]h00`000000g]kN0=kN
gP0A0=kNgP030000003Ng]h0g]kN01H0g]kN0`00000E0=kNgP8000003@3Ng]h00`000000g]kN0=kN
gP0G0=kNgP8000005`3Ng]h3000001D0g]kN0P0000050=kNgP030000003Ng]h0g]kN02/0g]kN00<0
00000=kNgP3Ng]h00`3Ng]h2000001L0g]kN0`00000E0=kNgP8000003@3Ng]h00`000000g]kN0=kN
gP0[0=kNgP030000003Ng]h0g]kN01P0g]kN00<000000=kNgP3Ng]h00P3Ng]h2000000H0g]kN;P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h03@3Ng]h00`000000g]kN0=kN
gP0A0=kNgP030000003Ng]h0g]kN0;h0g]kN00<000000=kNgP3Ng]h0L@3Ng]h00`000000g]kN0=kN
gP0F0=kNgP030000003Ng]h0g]kN00/0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<0
00000=kNgP3Ng]h03@3Ng]h00`000000g]kN0=kNgP0A0=kNgP030000003Ng]h0g]kN0;/0g]kN00@0
00000=kNgP3Ng]h00000L03Ng]h010000000g]kN0=kNgP00000F0=kNgP040000003Ng]h0g]kN0000
00`0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h03@3Ng]h:0000
00X0g]kN00<000000=kNgP3Ng]h0_03Ng]h200000780g]kN0P00000H0=kNgP8000003@3Ng]h^0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`h0oooo2`3Ng]h3000000050=kNgP00000000000000003Ng]h010000004
0=kNgP<000000`3Ng]h5000000<0g]kN0`0000000`3Ng]h000000000000200000080g]kN0P000003
0=kNgP030000003Ng]h0g]kN0240g]kN00<000000=kNgP3Ng]h0o`3Ng]iJ0=kNgRh0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c3P3oool<0=kNgP050000003Ng]h0g]kN0=kNgP0000000`3Ng]h00`000000g]kN0=kN
gP030=kNgP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP020=kNgP050000
003Ng]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kN
gP3Ng]h08@3Ng]h00`000000g]kN0=kNgP3o0=kNgUX0g]kN;P3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oo
o``0g]kN00D000000=kNgP3Ng]h0g]kN000000030=kNgP030000003Ng]h0g]kN00<0g]kN00<00000
0=kNgP3Ng]h01P3Ng]h00`000000g]kN0=kNgP020=kNgP050000003Ng]h0g]kN0=kNgP0000000P3N
g]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kNgP3Ng]h00`3Ng]hI000000D0g]kN
00<000000=kNgP3Ng]h0o`3Ng]iJ0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool<0=kNgPD00000
0`3Ng]h00`000000g]kN0=kNgP030=kNgP030000003Ng]h0g]kN00H0g]kN00<000000=kNgP3Ng]h0
0`3Ng]h400000080g]kN00D000000=kNgP3Ng]h0g]kN000000040=kNgP030000003Ng]h0g]kN0240
g]kN00<000000=kNgP3Ng]h0o`3Ng]iJ0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool=0=kNgP03
0000003Ng]h0000000@0g]kN00<000000=kNgP3Ng]h00`3Ng]h01@000000g]kN0=kNgP3Ng]h00000
00@0g]kN00<000000=kNgP3Ng]h01P3Ng]h00`000000g]kN0=kNgP0200000080g]kN00<000000=kN
gP3Ng]h00P3Ng]h00`000000g]kN0=kNgP0Q0=kNgP030000003Ng]h0g]kN0?l0g]kNFP3Ng]h^0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`h0oooo3@3Ng]h00`000000g]kN000000030=kNgP030000003Ng]h00000
008000000`3Ng]h300000080g]kN00@000000=kNgP3Ng]h000000P3Ng]h00`000000g]kN00000003
00000080g]kN00<000000=kNgP0000000P0000050=kNgP030000003Ng]h0g]kN0240g]kN00<00000
0=kNgP3Ng]h0o`3Ng]iJ0=kNgRh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool>0=kNgP030000003Ng]h0
g]kN00l0g]kN00@000000=kNgP3Ng]h000000P3Ng]h00`000000g]kN0=kNgP0?0=kNgP030000003N
g]h0g]kN00H0g]kN0`0000030=kNgP030000003Ng]h0g]kN00@00000103Ng]h00`000000g]kN0000
00070=kNgP030000003Ng]h0g]kN0?l0g]kNFP3Ng]h^0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo303N
g]h300000140g]kN1`00000A0=kNgP030000003Ng]h0g]kN00L0g]kN00<000000=kNgP3Ng]h00P3N
g]h01@000000g]kN0=kNgP3Ng]h0000000L0g]kN00<000000=kNgP3Ng]h01P3Ng]h00`000000g]kN
0=kNgP3o0=kNgUX0g]kN;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h0
1`3Ng]h00`000000g]kN0=kNgP0500000080g]kN00<000000=kNgP3Ng]h0103Ng]h00`000000g]kN
0=kNgP060=kNgP030000003Ng]h0g]kN0?l0g]kNFP3Ng]h[0?ooo`@0003o1`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooolh0=kNgP030000
003Ng]h0g]kN00L0g]kN00<000000=kNgP3Ng]h00P3Ng]h00`000000g]kN0=kNgP030=kNgP030000
003Ng]h0g]kN0080g]kN00<000000=kNgP0000001`3Ng]h00`000000g]kN0=kNgP3o0=kNgUX0g]kN
;P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h01`3Ng]h00`000000g]kN
0=kNgP020=kNgP040000003Ng]h0g]kN00000080g]kN00<000000=kNgP3Ng]h0303Ng]h00`000000
g]kN0=kNgP3o0=kNgUX0g]kN;@3oool20000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h00`000000g]kN0=kNgP060=kNgP80
0000203Ng]h2000000l0g]kN00<000000=kNgP3Ng]h0o`3Ng]iJ0=kNgR`0oooo00<0003o0?ooo`00
0?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c3P3ooolh0=kNgP8000008@3Ng]h200000?l0g]kNG03Ng]h[0?ooo`040000o`3oool0oooo0000
o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooool@3oool01@000?l0oooo0?ooo`3oool0003o00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool60000o`L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo<03Ng]h0
0`000000g]kN0=kNgP0a0=kNg_l0ooooO`3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo<03Ng]h00`000000g]kN0=kNgP0a
0=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooobl0g]kN0P0000080=kNgP<00000:03Ng]ko
0?oooh<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool_0=kNgP030000003Ng]h0000000H0g]kN00D00000
0=kNgP3Ng]h0g]kN0000000W0=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooobh0g]kN00@0
00000=kNgP3Ng]h000002P3Ng]h00`000000g]kN0=kNgP0U0=kNg_l0ooooP`3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<>0?ooob`0g]kN00<000000=kNgP0000000P3Ng]h00`000000g]kN0=kNgP080=kNgP030000
003Ng]h0g]kN02D0g]kN<P3oool3000005l0oooo0`00001h0?ooo`<00000L03oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<>0?ooobd0g]kN00<000000=kNgP3Ng]h00P3Ng]h00`000000g]kN0=kNgP050=kNgP800000
:03Ng]ha0?ooo`050000003oool0oooo0?ooo`000000G@3oool01@000000oooo0?ooo`3oool00000
07X0oooo00<000000?ooo`3oool0K@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oooc80g]kN00<000000=kN
gP3Ng]h01`3Ng]h00`000000g]kN0=kNgP0U0=kNgSD0oooo00<000000?ooo`3oool0F`3oool01@00
0000oooo0?ooo`3oool0000007/0oooo00<000000?ooo`3oool0K03oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>
0?oooc80g]kN00<000000=kNgP3Ng]h00`3Ng]h01@000000g]kN0=kNgP3Ng]h0000002L0g]kN=@3o
ool00`000000oooo0?ooo`1K0?ooo`050000003oool0oooo0?ooo`000000N03oool4000006h0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c3P3ooolb0=kNgP030000003Ng]h0g]kN00@0g]kN0`00000X0=kNgS<0oooo
0P00001N0?ooo`@00000N03oool01@000000oooo0?ooo`3oool0000006h0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c3P3ooolc0=kNgP030000003Ng]h0g]kN02h0g]kN=@3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo07T0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`h0oooo<`3Ng]h00`000000g]kN0=kNgP0^0=kNgS40oooo00D000000?ooo`3oool0oooo0000001N
0?ooo`030000003oool0oooo07P0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`h0oooo<`3Ng]h<000002D0g]kN<P3oool300000600oooo0`00001h0?ooo`<00000K`3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<>0?ooof@0g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooI03N
g]ko0?oooh<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooomT0=kNgPH0oooo00<000000?ooo`3oool0`@3o
ool00`000000oooo0?ooo`2e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooI03Ng]h60?ooo`030000003o
ool0oooo0<40oooo00<000000?ooo`3oool0]@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`030=kNgP00
0000000000<000000`3Ng]iH000000<0g]kN103oool5000000H0ooooB00000060?ooo`D000001P3o
oomJ000000H0oooo1@0000060?ooog/00000=03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooof@0g]kN1P3o
ool00`000000oooo0?ooo`310?ooo`030000003oool0oooo0;D0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3o
oomT0=kNgPH0oooo00<000000?ooo`3oool0`@3oool00`000000oooo0?ooo`2e0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<`h0ooooI03Ng]ko0?oooh<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooom60=kNgP030000003N
g]h0g]kN01/0g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooAP3Ng]h00`000000g]kN0=kN
gP0K0=kNgR40oooo0`00001F0?ooo`<00000J03oool3000009X0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3o
oom50=kNgP8000007@3Ng]hT0?ooo`030000003oool0oooo0080oooo0P00000V0?ooo`800000:P3o
ool00`000000oooo0?ooo`020?ooo`800000>03oool2000002X0oooo00<000000?ooo`3oool00P3o
ool2000005X0oooo0P00000g0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooA03Ng]h00`000000g]kN0000
000M0=kNgR@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo02P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1J0?ooo`030000003o
ool0oooo03D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooom10=kNgP060000003Ng]h0g]kN0000003Ng]h0
00001P3Ng]h2000001D0g]kN4@3oool6000000<0oooo0`0000040?ooo`@00000103oool00`000000
oooo0?ooo`090?ooo`D000003P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo01D0
oooo1P0000030?ooo`<00000103oool4000000@0oooo00<000000?ooo`3oool00P3oool5000000d0
oooo0P0000030?ooo`8000003@3oool2000000<0oooo0P0000090?ooo`030000003oool0oooo01D0
oooo1P0000030?ooo`<00000103oool4000000@0oooo00<000000?ooo`3oool02P3oool5000000d0
oooo0P0000030?ooo`8000003@3oool2000000<0oooo0P00000C0?ooo`8000000`3oool2000000T0
oooo00<000000?ooo`3oool0=@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?oood80g]kN0P0000030=kNgP03
0000003Ng]h0g]kN0080g]kN00@000000=kNgP3Ng]h00000503Ng]hB0?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0F0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`0F0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo
0?ooo`050?ooo`050000003oool0oooo0?ooo`0000003@3oool00`000000oooo0?ooo`050?ooo`05
0000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`0e0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`h0oooo@`3Ng]h01@000000g]kN0=kNgP3Ng]h0000000L0g]kN00<000000=kNgP3Ng]h04P3Ng]hB
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool05P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo000000080?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`0000002`3oool00`000000oooo0?ooo`0F0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0000000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000002`3oool00`00
0000oooo0?ooo`0e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0ooooA`3Ng]h00`000000g]kN0=kNgP040=kN
gP030000003Ng]h0g]kN01<0g]kN4P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool00P3o
ool5000000@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo1@0000060?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`040?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool00P3oool5000000D0oooo00<000000?ooo`3oool0103oool5000000L0oooo00<00000
0?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool02`3oool5000000L0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h2
000000d0g]kN00<000000=kNgP3Ng]h00P3Ng]h010000000g]kN0=kNgP00000;0=kNgP8000001`3N
g]hB0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01P3oool00`000000oooo000000050?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0000000;0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0000000P0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000>0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`0000002`3oool00`000000oooo0?ooo`0e0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`h0oooo>03Ng]h00`000000g]kN0=kNgP0<0=kNgP030000003Ng]h0g]kN00<0g]kN
0P00000=0=kNgP030000003Ng]h0g]kN00D0g]kN4P3oool00`000000oooo0?ooo`050?ooo`<00000
103oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000103oool000000000000000030?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool01@3oool3000000@0oooo0`0000000`3oool0
00000?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`030?ooo`<0000000@0oooo00000000000000001P3oool00`000000oooo0?ooo`040?oo
o`<0000000<0oooo0000000000001@0000050?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool01@3oool3000000@0oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo0000
0000000000001P3oool00`000000oooo0?ooo`040?ooo`<0000000<0oooo0000000000001@000008
0?ooo`030000003oool0oooo00@0oooo0`0000001@3oool00000000000000000oooo008000001P3o
ool00`000000oooo0?ooo`0e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h00`000000g]kN0=kN
gP0<0=kNgP030000003Ng]h0g]kN0180g]kN00<000000=kNgP3Ng]h01@3Ng]hB0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool02@3oool3000001X0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo0`00000[0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo00X0oooo0`00000[0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000
1@3oool00`000000oooo0?ooo`0e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h00`000000g]kN
0=kNgP0=0=kNgP030000003Ng]h0g]kN0140g]kN00<000000=kNgP3Ng]h01@3Ng]hA0?ooo`<00000
5@3oool2000000`0oooo00<000000?ooo`3oool05`3oool2000001L0oooo0`00000E0?ooo`800000
1@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00<0oooo0P00000G0?ooo`<00000
5@3oool2000000d0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo0080oooo0P00000g0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h00`000000g]kN
0=kNgP0=0=kNgP030000003Ng]h0g]kN0140g]kN00<000000=kNgP3Ng]h01@3Ng]jg0?ooo`030000
003oool0oooo0700oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0l0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`h0oooo>03Ng]h00`000000g]kN0=kNgP0=0=kNgP030000003Ng]h0g]kN0140g]kN
00<000000=kNgP3Ng]h01@3Ng]jd0?ooo`040000003oool0oooo000006l0oooo00@000000?ooo`3o
ool000005P3oool010000000oooo0?ooo`00000m0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h0
0`000000g]kN0=kNgP0=0=kNgPX000002P3Ng]h00`000000g]kN0=kNgP050=kNg[D0oooo0P00001a
0?ooo`800000603oool2000003h0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool;0=kNgP<0000000D0g]kN
00000000000000000=kNgP04000000@0g]kN0`0000030=kNgPD000000`3Ng]h3000000030=kNgP00
00000000008000000P3Ng]h2000000<0g]kN00<000000=kNgP3Ng]h08@3Ng]h00`000000g]kN0=kN
gP050=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo``0g]kN00D000000=kNgP3Ng]h0g]kN
000000030=kNgP030000003Ng]h0g]kN00<0g]kN00D000000=kNgP3Ng]h0g]kN000000040=kNgP03
0000003Ng]h0g]kN0080g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP050000003Ng]h0g]kN
0=kNgP000000103Ng]h00`000000g]kN0=kNgP0Q0=kNgP030000003Ng]h0g]kN00D0g]kNo`3ooon3
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`h0oooo303Ng]h01@000000g]kN0=kNgP3Ng]h0000000<0g]kN00<0
00000=kNgP3Ng]h00`3Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0g]kN0080g]kN00D0
00000=kNgP3Ng]h0g]kN000000020=kNgP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000
g]kN0=kNgP030=kNgQT000001@3Ng]h00`000000g]kN0=kNgP050=kNg_l0ooooP`3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<>0?ooo``0g]kN1@0000030=kNgP030000003Ng]h0g]kN00<0g]kN00<000000=kNgP3N
g]h01P3Ng]h00`000000g]kN0=kNgP030=kNgP@000000P3Ng]h01@000000g]kN0=kNgP3Ng]h00000
00@0g]kN00<000000=kNgP3Ng]h08@3Ng]h00`000000g]kN0=kNgP050=kNg_l0ooooP`3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<>0?ooo`d0g]kN00<000000=kNgP000000103Ng]h00`000000g]kN0=kNgP030=kN
gP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0
g]kN008000000P3Ng]h00`000000g]kN0=kNgP020=kNgP030000003Ng]h0g]kN0240g]kN00<00000
0=kNgP3Ng]h01@3Ng]ko0?oooh<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool=0=kNgP030000003Ng]h0
000000<0g]kN00<000000=kNgP0000000P0000030=kNgP<000000P3Ng]h010000000g]kN0=kNgP00
00020=kNgP030000003Ng]h0000000<000000P3Ng]h00`000000g]kN00000002000000D0g]kN00<0
00000=kNgP3Ng]h08@3Ng]h00`000000g]kN0=kNgP050=kNg_l0ooooP`3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<>0?ooo`h0g]kN00<000000=kNgP3Ng]h03`3Ng]h010000000g]kN0=kNgP0000020=kNgP030000
003Ng]h0g]kN00l0g]kN00<000000=kNgP3Ng]h01P3Ng]h3000000<0g]kN00<000000=kNgP3Ng]h0
100000040=kNgP030000003Ng]h0000000L0g]kN00<000000=kNgP3Ng]h01@3Ng]ko0?oooh<0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c3P3oool<0=kNgP<000004@3Ng]h700000140g]kN00<000000=kNgP3Ng]h0
1`3Ng]h00`000000g]kN0=kNgP020=kNgP050000003Ng]h0g]kN0=kNgP0000001`3Ng]h00`000000
g]kN0=kNgP060=kNgP030000003Ng]h0g]kN00D0g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0
oooo>03Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN00D000000P3Ng]h00`000000
g]kN0=kNgP040=kNgP030000003Ng]h0g]kN00H0g]kN00<000000=kNgP3Ng]h01@3Ng]ko0?oooh00
oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<>0?ooocP0g]kN00<000000=kNgP3Ng]h01`3Ng]h00`000000g]kN0=kNgP020=kNgP03
0000003Ng]h0g]kN00<0g]kN00<000000=kNgP3Ng]h00P3Ng]h00`000000g]kN000000070=kNgP03
0000003Ng]h0g]kN00D0g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo>03Ng]h00`000000
g]kN0=kNgP070=kNgP030000003Ng]h0g]kN0080g]kN00@000000=kNgP3Ng]h000000P3Ng]h00`00
0000g]kN0=kNgP0<0=kNgP030000003Ng]h0g]kN00D0g]kNo`3ooon20?ooo`80003o1`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3ooolh0=kN
gP030000003Ng]h0g]kN00H0g]kN0P0000080=kNgP8000003`3Ng]h00`000000g]kN0=kNgP050=kN
g_l0ooooP@3oool00`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooocP0g]kN0P00000Q0=kNgP8000001`3Ng]ko0?oo
oh00oooo00@0003o0?ooo`3oool0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`050000o`3oool0oooo0?ooo`000?l01`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooo`0?ooo`H0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c5@3ooolY0=kNgP030000003Ng]h0g]kN0340g]kNo`3ooomo0?ooo`D0003o1`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3o
oolY0=kNgP030000003Ng]h0g]kN0340g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo:03N
g]h2000000P0g]kN0`00000X0=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooobP0g]kN00<0
00000=kNgP0000001P3Ng]h01@000000g]kN0=kNgP3Ng]h0000002L0g]kNo`3ooon30?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<aD0oooo9`3Ng]h010000000g]kN0=kNgP00000:0=kNgP030000003Ng]h0g]kN02D0
g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo9@3Ng]h00`000000g]kN000000020=kNgP03
0000003Ng]h0g]kN00P0g]kN00<000000=kNgP3Ng]h09@3Ng]ha0?ooo`<00000H03oool3000007P0
oooo0`00001`0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo9P3Ng]h00`000000g]kN0=kNgP020=kNgP03
0000003Ng]h0g]kN00D0g]kN0P00000X0=kNgS00oooo00D000000?ooo`3oool0oooo0000001N0?oo
o`050000003oool0oooo0?ooo`000000NP3oool00`000000oooo0?ooo`1]0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<aD0oooo:`3Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN02D0g]kN=03oool0
0`000000oooo0?ooo`1L0?ooo`050000003oool0oooo0?ooo`000000N`3oool00`000000oooo0?oo
o`1/0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo:`3Ng]h00`000000g]kN0=kNgP030=kNgP050000003N
g]h0g]kN0=kNgP0000009`3Ng]hd0?ooo`030000003oool0oooo05`0oooo00D000000?ooo`3oool0
oooo0000001h0?ooo`@00000KP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooob/0g]kN00<000000=kNgP3N
g]h0103Ng]h3000002P0g]kN<P3oool2000005l0oooo1000001h0?ooo`050000003oool0oooo0?oo
o`000000KP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooob`0g]kN00<000000=kNgP3Ng]h0;P3Ng]hd0?oo
o`030000003oool0oooo05`0oooo00<000000?ooo`3oool0N@3oool01@000000oooo0?ooo`3oool0
000006h0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool/0=kNgP030000003Ng]h0g]kN02h0g]kN<03oool0
1@000000oooo0?ooo`3oool0000005l0oooo00<000000?ooo`3oool0N03oool01@000000oooo0?oo
o`3oool0000006h0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool/0=kNgP`000009@3Ng]ha0?ooo`<00000
H@3oool3000007P0oooo0`00001_0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0ooooG@3Ng]ko0?oooh<0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c5@3ooomM0=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?oooed0g]kN
1P3oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo0;D0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
5@3ooomM0=kNgPH0oooo00<000000?ooo`3oool0`@3oool00`000000oooo0?ooo`2e0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`l0oooo1@0000000`3oool0g]kN0=kNgP1H000000<0g]kN103oool5000000H0oooo
B00000060?ooo`D000001P3ooomJ000000H0oooo1@0000060?ooog/00000=03oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<E0?oooed0g]kN1P3oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo0;D0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c5@3ooomM0=kNgPH0oooo00<000000?ooo`3oool0`@3oool00`000000oooo
0?ooo`2e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0ooooG@3Ng]ko0?oooh<0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
5@3ooolo0=kNgP030000003Ng]h0g]kN01/0g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo
?`3Ng]h00`000000g]kN0=kNgP0K0=kNgR00oooo0`00001G0?ooo`<00000J03oool3000009X0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c5@3oooln0=kNgP8000007@3Ng]hS0?ooo`030000003oool0oooo0080oooo
0P00000W0?ooo`800000:P3oool00`000000oooo0?ooo`020?ooo`800000>03oool2000002X0oooo
00<000000?ooo`3oool00P3oool2000005T0oooo0P00000h0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo
?@3Ng]h00`000000g]kN0000000M0=kNgR<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0h0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`1I0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3ooolj0=kNgP060000
003Ng]h0g]kN0000003Ng]h000001P3Ng]h2000001D0g]kN403oool6000000<0oooo0`0000040?oo
o`@00000103oool00`000000oooo0?ooo`0:0?ooo`D000003P3oool2000000<0oooo0P0000030?oo
o`030000003oool0oooo01D0oooo1P0000030?ooo`<00000103oool4000000@0oooo00<000000?oo
o`3oool00P3oool5000000d0oooo0P0000030?ooo`8000003@3oool2000000<0oooo0P0000090?oo
o`030000003oool0oooo01D0oooo1P0000030?ooo`<00000103oool4000000@0oooo00<000000?oo
o`3oool02@3oool5000000h0oooo0P0000030?ooo`8000003@3oool2000000<0oooo0P00000B0?oo
o`8000000`3oool2000000T0oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?oo
oc/0g]kN0P0000030=kNgP030000003Ng]h0g]kN0080g]kN00@000000=kNgP3Ng]h00000503Ng]hA
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`0F0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
00001`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002P3oool00`00
0000oooo0?ooo`0F0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`00
00001`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000003@3oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`0f
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<aD0oooo?03Ng]h01@000000g]kN0=kNgP3Ng]h0000000L0g]kN00<0
00000=kNgP3Ng]h04P3Ng]hA0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool05P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000002`3oool00`000000oooo
0?ooo`0F0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000P0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0000000>0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`0000002`3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo@03Ng]h0
0`000000g]kN0=kNgP040=kNgP030000003Ng]h0g]kN01<0g]kN4@3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool00P3oool5000000D0oooo00<000000?ooo`3oool01@3oool5000000L0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo1@0000070?ooo`030000003oool0oooo
00D0oooo1@0000070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000@0oooo00<000000?ooo`3oool00P3oool5000000@0oooo00<000000?ooo`3oool01@3o
ool5000000L0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool02`3o
ool5000000H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0f0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<aD0oooo<@3Ng]h2000000d0g]kN00<000000=kNgP3Ng]h00P3Ng]h010000000g]kN0=kN
gP00000;0=kNgP8000001`3Ng]hA0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo000000050?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000P0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0000000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000002`3oool00`000000
oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo<@3Ng]h00`000000g]kN0=kNgP0<0=kNgP03
0000003Ng]h0g]kN00<0g]kN0P00000=0=kNgP030000003Ng]h0g]kN00D0g]kN4@3oool00`000000
oooo0?ooo`050?ooo`<00000103oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000103oool0
00000000000000030?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01@3oool30000
00@0oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo00000000000000001P3oool0
0`000000oooo0?ooo`040?ooo`<0000000<0oooo0000000000001@0000050?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool01@3oool3000000@0oooo0`0000000`3oool000000?ooo`02
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`04
0?ooo`<0000000@0oooo00000000000000001P3oool00`000000oooo0?ooo`040?ooo`<0000000<0
oooo0000000000001@0000080?ooo`030000003oool0oooo00<0oooo0`0000001@3oool000000000
00000000oooo008000001P3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo
<@3Ng]h00`000000g]kN0=kNgP0<0=kNgP030000003Ng]h0g]kN0180g]kN00<000000=kNgP3Ng]h0
1@3Ng]hA0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02P3oool3000001X0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo
0`00000[0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo00T0oooo0`00000/0?ooo`030000003oool0oooo01D0oooo
00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0
oooo<@3Ng]h00`000000g]kN0=kNgP0=0=kNgP030000003Ng]h0g]kN0140g]kN00<000000=kNgP3N
g]h01@3Ng]h@0?ooo`<000005@3oool2000000d0oooo00<000000?ooo`3oool05`3oool2000001L0
oooo0`00000E0?ooo`8000001@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00<0
oooo0P00000G0?ooo`<000005@3oool2000000`0oooo00<000000?ooo`3oool0:`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo0080oooo0P00000h0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0
oooo<@3Ng]h00`000000g]kN0=kNgP0=0=kNgP030000003Ng]h0g]kN0140g]kN00<000000=kNgP3N
g]h01@3Ng]jg0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0m0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo<@3Ng]h00`000000g]kN0=kNgP0=0=kNgP03
0000003Ng]h0g]kN0140g]kN00<000000=kNgP3Ng]h01@3Ng]jd0?ooo`040000003oool0oooo0000
06l0oooo00@000000?ooo`3oool000005@3oool010000000oooo0?ooo`00000n0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<aD0oooo<@3Ng]h00`000000g]kN0=kNgP0=0=kNgPX000002P3Ng]h00`000000g]kN0=kN
gP050=kNg[D0oooo0P00001a0?ooo`8000005`3oool2000003l0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3o
ool40=kNgP<0000000D0g]kN00000000000000000=kNgP04000000@0g]kN0`0000030=kNgPD00000
0`3Ng]h3000000030=kNgP0000000000008000000P3Ng]h2000000<0g]kN00<000000=kNgP3Ng]h0
8@3Ng]h00`000000g]kN0=kNgP050=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`D0g]kN
00D000000=kNgP3Ng]h0g]kN000000030=kNgP030000003Ng]h0g]kN00<0g]kN00D000000=kNgP3N
g]h0g]kN000000040=kNgP030000003Ng]h0g]kN0080g]kN00D000000=kNgP3Ng]h0g]kN00000002
0=kNgP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP0Q0=kNgP030000003N
g]h0g]kN00D0g]kNo`3ooon30?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo1@3Ng]h01@000000g]kN0=kN
gP3Ng]h0000000<0g]kN00<000000=kNgP3Ng]h00`3Ng]h00`000000g]kN0=kNgP060=kNgP030000
003Ng]h0g]kN0080g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP050000003Ng]h0g]kN0=kN
gP000000103Ng]h00`000000g]kN0=kNgP030=kNgQT000001@3Ng]h00`000000g]kN0=kNgP050=kN
g_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`D0g]kN1@0000030=kNgP030000003Ng]h0g]kN
00<0g]kN00<000000=kNgP3Ng]h01P3Ng]h00`000000g]kN0=kNgP030=kNgP@000000P3Ng]h01@00
0000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kNgP3Ng]h08@3Ng]h00`000000g]kN0=kNgP05
0=kNg_l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`H0g]kN00<000000=kNgP000000103Ng]h0
0`000000g]kN0=kNgP030=kNgP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kN
gP060=kNgP030000003Ng]h0g]kN008000000P3Ng]h00`000000g]kN0=kNgP020=kNgP030000003N
g]h0g]kN0240g]kN00<000000=kNgP3Ng]h01@3Ng]ko0?oooh<0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3o
ool60=kNgP030000003Ng]h0000000<0g]kN00<000000=kNgP0000000P0000030=kNgP<000000P3N
g]h010000000g]kN0=kNgP0000020=kNgP030000003Ng]h0000000<000000P3Ng]h00`000000g]kN
00000002000000D0g]kN00<000000=kNgP3Ng]h08@3Ng]h00`000000g]kN0=kNgP050=kNg_l0oooo
P`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`L0g]kN00<000000=kNgP3Ng]h03`3Ng]h010000000g]kN
0=kNgP0000020=kNgP030000003Ng]h0g]kN00l0g]kN00<000000=kNgP3Ng]h01P3Ng]h3000000<0
g]kN00<000000=kNgP3Ng]h0100000040=kNgP030000003Ng]h0000000L0g]kN00<000000=kNgP3N
g]h01@3Ng]ko0?oooh<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool50=kNgP<000004@3Ng]h700000140
g]kN00<000000=kNgP3Ng]h01`3Ng]h00`000000g]kN0=kNgP020=kNgP050000003Ng]h0g]kN0=kN
gP0000001`3Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0g]kN00D0g]kNo`3ooon30?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<aD0oooo<@3Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN
00D000000P3Ng]h00`000000g]kN0=kNgP040=kNgP030000003Ng]h0g]kN00H0g]kN00<000000=kN
gP3Ng]h01@3Ng]ko0?oooh00oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?oooc40g]kN00<000000=kNgP3Ng]h01`3Ng]h00`00
0000g]kN0=kNgP020=kNgP030000003Ng]h0g]kN00<0g]kN00<000000=kNgP3Ng]h00P3Ng]h00`00
0000g]kN000000070=kNgP030000003Ng]h0g]kN00D0g]kNo`3ooon30?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<aD0oooo<@3Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN0080g]kN00@000000=kN
gP3Ng]h000000P3Ng]h00`000000g]kN0=kNgP0<0=kNgP030000003Ng]h0g]kN00D0g]kNo`3ooon2
0?ooo`80003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c5@3ooola0=kNgP030000003Ng]h0g]kN00H0g]kN0P0000080=kNgP8000003`3Ng]h0
0`000000g]kN0=kNgP050=kNg_l0ooooP@3oool00`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?oooc40g]kN0P00000Q
0=kNgP8000001`3Ng]ko0?oooh00oooo00@0003o0?ooo`3oool0003o1`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`050000o`3o
ool0oooo0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooo`0?ooo`H0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?P3oool00`000000oooo0?ooo`3o0?oook00oooo
1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<n0?ooo`030000003oool0oooo0?l0oooo]03oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<m0?ooo`800000
203oool300000?l0ooooZ`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<m0?ooo`030000003oool0000000H0oooo
00D000000?ooo`3oool0oooo0000003o0?ooojX0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?03oool010000000
oooo0?ooo`00000:0?ooo`030000003oool0oooo0?l0ooooZ03oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?oo
o`030000003oool000000080oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1F0?oo
o`<00000H03oool3000007P0oooo0`00001`0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`050?ooo`800000F03oool01@000000oooo0?ooo`3oool0
000005h0oooo00D000000?ooo`3oool0oooo0000001j0?ooo`030000003oool0oooo06d0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c@03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo05T0oooo00<0
00000?ooo`3oool0G03oool01@000000oooo0?ooo`3oool0000007/0oooo00<000000?ooo`3oool0
K03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c=00?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo0000001K0?ooo`030000003oool0oooo05`0oooo00D000000?ooo`3oool0oooo0000001h0?oo
o`@00000KP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c=00?ooo`030000003oool0oooo00@0oooo0`00001J0?oo
o`800000G`3oool4000007P0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<d40oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0
oooo07T0oooo00D000000?ooo`3oool0oooo0000001^0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d40oooo00<0
00000?ooo`3oool0GP3oool01@000000oooo0?ooo`3oool0000005l0oooo00<000000?ooo`3oool0
N03oool01@000000oooo0?ooo`3oool0000006h0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c@@3oool<000005H0
oooo0`00001Q0?ooo`<00000N03oool3000006l0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=h0?ooo`030000003oool0oooo0<40
oooo00<000000?ooo`3oool0]@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=h0?ooo`030000003oool0oooo0<40
oooo00<000000?ooo`3oool0]@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<?0?ooo`D000000`3ooomH000000L0
oooo1@0000060?ooodP000001P3oool5000000H0ooooFP0000060?ooo`D000001P3ooomk000003@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cN03oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo0;D0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cN03oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo0;D0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo>`3Ng]h00`000000
g]kN0=kNgP0G0=kNg_l0ooooQ`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?oooc/0g]kN00<000000=kNgP3N
g]h05`3Ng]hT0?ooo`<00000E`3oool3000006P0oooo0`00002J0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0
oooo>P3Ng]h2000001T0g]kN9`3oool00`000000oooo0?ooo`020?ooo`8000009`3oool2000002X0
oooo00<000000?ooo`3oool00P3oool2000003P0oooo0P00000Z0?ooo`030000003oool0oooo0080
oooo0P00001I0?ooo`800000>03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooocT0g]kN00<000000=kNgP00
00006@3Ng]hW0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09`3oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0F@3oool00`000000
oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo=P3Ng]h01P000000g]kN0=kNgP000000g]kN
000000H0g]kN0P00000A0=kNgQ@0oooo1P0000030?ooo`<00000103oool4000000@0oooo00<00000
0?ooo`3oool02P3oool5000000h0oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`0E
0?ooo`H000000`3oool3000000@0oooo100000040?ooo`030000003oool0oooo0080oooo1@00000=
0?ooo`8000000`3oool2000000d0oooo0P0000030?ooo`8000002@3oool00`000000oooo0?ooo`0E
0?ooo`H000000`3oool3000000@0oooo100000040?ooo`030000003oool0oooo00T0oooo1@00000>
0?ooo`8000000`3oool2000000d0oooo0P0000030?ooo`8000004P3oool2000000<0oooo0P000009
0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3ooolg0=kNgP8000000`3Ng]h0
0`000000g]kN0=kNgP020=kNgP040000003Ng]h0g]kN00000100g]kN5@3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`000000103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool05P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool01@3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool05P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?oo
o`3oool01@3oool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<I0?ooocP0g]kN00D000000=kNgP3Ng]h0g]kN000000070=kNgP030000003Ng]h0g]kN00h0g]kN
5@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo000000050?ooo`030000003oool0
oooo01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000203oool00`000000
oooo0?ooo`060?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool05P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo000000080?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`0000003P3oool00`000000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00<0
00000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?oooc`0g]kN00<000000=kNgP3Ng]h0103N
g]h00`000000g]kN0=kNgP0?0=kNgQD0oooo00<000000?ooo`3oool0103oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080
oooo1@0000050?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`D000001`3oool00`000000oooo0?ooo`050?ooo`D000001`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0103oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo0080oooo1@0000040?ooo`030000003oool0oooo00D0oooo1@0000070?ooo`030000
003oool0oooo00D0oooo1@0000070?ooo`030000003oool0oooo00/0oooo1@0000060?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooobd0g]kN
0P00000=0=kNgP030000003Ng]h0g]kN0080g]kN00@000000=kNgP3Ng]h000002`3Ng]h2000000<0
g]kN5@3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool01P3oool00`000000oooo000000080?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`0000002`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00@0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000003P3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool0=P3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<I0?ooobd0g]kN00<000000=kNgP3Ng]h0303Ng]h00`000000g]kN0=kNgP030=kN
gP8000003@3Ng]h010000000g]kN0=kNgP3Ng]hE0?ooo`030000003oool0oooo00D0oooo0`000004
0?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000<0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`050?ooo`<00000103oool3000000030?ooo`00
0000oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00@0oooo0`000000103oool000000000000000060?ooo`030000003oool0oooo00@0oooo
0`0000000`3oool0000000000005000000D0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`050?ooo`<00000103oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000103oool00000
0000000000060?ooo`030000003oool0oooo00@0oooo0`0000000`3oool0000000000005000000P0
oooo00<000000?ooo`3oool00`3oool3000000050?ooo`00000000000000003oool00P0000060?oo
o`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool]0=kNgP030000003Ng]h0g]kN
00`0g]kN00<000000=kNgP3Ng]h04P3Ng]h010000000g]kN0=kNgP3Ng]hE0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool02P3oool3000001X0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo0`00000[0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo00T0oooo0`00000/0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`3oool000001@3o
ool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo;@3Ng]h00`000000g]kN0=kN
gP0=0=kNgP030000003Ng]h0g]kN0140g]kN00@000000=kNgP3Ng]h0g]kN503oool3000001D0oooo
0P00000=0?ooo`030000003oool0oooo01L0oooo0P00000G0?ooo`<000005@3oool2000000D0oooo
00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`030?ooo`8000005`3oool3000001D0oooo
0P00000<0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`020?ooo`800000>03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooobd0g]kN00<000000=kNgP3Ng]h0
3@3Ng]h00`000000g]kN0=kNgP0A0=kNgP040000003Ng]h0g]kN0=kNg[/0oooo00<000000?ooo`3o
ool0L03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo03d0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c6@3oool]0=kNgP030000003Ng]h0g]kN00d0g]kN00<000000=kNgP3Ng]h04@3Ng]h010000000
g]kN0=kNgP3Ng]jh0?ooo`040000003oool0oooo000006l0oooo00@000000?ooo`3oool000005@3o
ool010000000oooo0?ooo`00000n0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo;@3Ng]h00`000000g]kN
0=kNgP0=0=kNgPX000002P3Ng]h010000000g]kN0=kNgP3Ng]ji0?ooo`800000L@3oool2000001L0
oooo0P00000o0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo0`0000001@3Ng]h00000000000000000g]kN
00@00000103Ng]h3000000<0g]kN1@0000030=kNgP<0000000<0g]kN0000000000000P0000020=kN
gP8000000`3Ng]h00`000000g]kN0=kNgP0Q0=kNgP040000003Ng]h0g]kN0=kNg_l0ooooQ`3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<I0?ooo`030=kNgP000000g]kN0080g]kN00D000000=kNgP3Ng]h0g]kN0000
00050=kNgP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP020=kNgP050000
003Ng]h0g]kN0=kNgP0000000P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000@0g]kN00<000000=kN
gP3Ng]h08@3Ng]h010000000g]kN0=kNgP3Ng]ko0?ooohL0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool0
0`3Ng]h000000=kNgP020=kNgP050000003Ng]h0g]kN0=kNgP0000001@3Ng]h00`000000g]kN0=kN
gP060=kNgP030000003Ng]h0g]kN0080g]kN00D000000=kNgP3Ng]h0g]kN000000020=kNgP050000
003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP030=kNgQT000001@3Ng]h010000000
g]kN0=kNgP3Ng]ko0?ooohL0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool00`3Ng]h00000000000030000
00<0g]kN00<000000=kNgP3Ng]h00`3Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0g]kN
00<0g]kN100000020=kNgP050000003Ng]h0g]kN0=kNgP000000103Ng]h00`000000g]kN0=kNgP0Q
0=kNgP040000003Ng]h0g]kN0=kNg_l0ooooQ`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`80g]kN00<0
00000=kNgP000000103Ng]h00`000000g]kN0=kNgP030=kNgP050000003Ng]h0g]kN0=kNgP000000
103Ng]h00`000000g]kN0=kNgP060=kNgP030000003Ng]h0g]kN008000000P3Ng]h00`000000g]kN
0=kNgP020=kNgP030000003Ng]h0g]kN0240g]kN00@000000=kNgP3Ng]h0g]kNo`3ooon70?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<aT0oooo0P3Ng]h00`000000g]kN000000030=kNgP030000003Ng]h000000080
00000`3Ng]h300000080g]kN00@000000=kNgP3Ng]h000000P3Ng]h00`000000g]kN000000030000
0080g]kN00<000000=kNgP0000000P0000050=kNgP030000003Ng]h0g]kN0240g]kN00@000000=kN
gP3Ng]h0g]kNo`3ooon70?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo0`3Ng]h00`000000g]kN0=kNgP0?
0=kNgP040000003Ng]h0g]kN00000080g]kN00<000000=kNgP3Ng]h03`3Ng]h00`000000g]kN0=kN
gP060=kNgP<000000`3Ng]h00`000000g]kN0=kNgP04000000@0g]kN00<000000=kNgP0000001`3N
g]h010000000g]kN0=kNgP3Ng]ko0?ooohL0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool0103Ng]h00000
00000000000A0=kNgPL000004@3Ng]h00`000000g]kN0=kNgP070=kNgP030000003Ng]h0g]kN0080
g]kN00D000000=kNgP3Ng]h0g]kN000000070=kNgP030000003Ng]h0g]kN00H0g]kN00@000000=kN
gP3Ng]h0g]kNo`3ooon70?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aT0oooo;@3Ng]h00`000000g]kN0=kNgP07
0=kNgP030000003Ng]h0g]kN00D000000P3Ng]h00`000000g]kN0=kNgP040=kNgP030000003Ng]h0
g]kN00H0g]kN00@000000=kNgP3Ng]h0g]kNo`3ooon40?ooo`@0003o1`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool]0=kNgP030000003N
g]h0g]kN00L0g]kN00<000000=kNgP3Ng]h00P3Ng]h00`000000g]kN0=kNgP030=kNgP030000003N
g]h0g]kN0080g]kN00<000000=kNgP0000001`3Ng]h010000000g]kN0=kNgP3Ng]ko0?ooohL0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c6@3oool]0=kNgP030000003Ng]h0g]kN00L0g]kN00<000000=kNgP3Ng]h0
0P3Ng]h010000000g]kN0=kNgP0000020=kNgP030000003Ng]h0g]kN00`0g]kN00@000000=kNgP3N
g]h0g]kNo`3ooon60?ooo`80003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c6@3oool]0=kNgP030000003Ng]h0g]kN00H0g]kN0P0000080=kN
gP8000003`3Ng]h010000000g]kN0=kNgP3Ng]ko0?ooohD0oooo00<0003o0?ooo`000?l01`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6@3oool]
0=kNgP8000008@3Ng]h2000000<0g]kNo`3ooon40?ooo`040000o`3oool0oooo0000o`L0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3o
ool01@000?l0oooo0?ooo`3oool0003o00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool60000o`L0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cd0oooo00<000000?ooo`3oool0
o`3ooona0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c?@3oool00`000000oooo0?ooo`3o0?oookD0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
?03oool2000000P0oooo0`00003o0?oooj`0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?03oool00`000000oooo
000000060?ooo`050000003oool0oooo0?ooo`000000o`3ooon[0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0
oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`3o0?ooojT0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c>@3oool00`000000oooo000000020?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0E`3oool3000005l0oooo0`00001h0?ooo`<00000L@3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool2000005T0oooo00D000000?oo
o`3oool0oooo0000001M0?ooo`050000003oool0oooo0?ooo`000000NP3oool00`000000oooo0?oo
o`1^0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`1J0?ooo`030000003oool0oooo05/0oooo00D000000?ooo`3oool0oooo0000001k0?ooo`030000
003oool0oooo06d0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool00`000000oooo0?ooo`030?ooo`050000
003oool0oooo0?ooo`000000G03oool00`000000oooo0?ooo`1K0?ooo`050000003oool0oooo0?oo
o`000000N03oool4000006l0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool00`000000oooo0?ooo`040?oo
o`<00000F`3oool2000005h0oooo1000001h0?ooo`050000003oool0oooo0?ooo`000000K`3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c=00?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0F`3oool0
0`000000oooo0?ooo`1i0?ooo`050000003oool0oooo0?ooo`000000K`3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=00?ooo`030000003oool0oooo05l0oooo00D000000?ooo`3oool0oooo0000001N0?ooo`030000
003oool0oooo07P0oooo00D000000?ooo`3oool0oooo0000001_0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d00
oooo3000001G0?ooo`<00000H03oool3000007P0oooo0`00001`0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN03oool00`000000
oooo0?ooo`310?ooo`030000003oool0oooo0;D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN03oool00`000000
oooo0?ooo`310?ooo`030000003oool0oooo0;D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool5000000<0
ooooF00000070?ooo`D000001@3ooom8000000L0oooo1@0000060?oooeX000001P3oool5000000H0
ooooN`00000d0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<gP0oooo00<000000?ooo`3oool0`@3oool00`000000
oooo0?ooo`2e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<gP0oooo00<000000?ooo`3oool0`@3oool00`000000
oooo0?ooo`2e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=:0?ooo`X0
g]kN00<000000=kNgP3Ng]h0403Ng]ko0?ooohh0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cBP3oool:0=kNgP03
0000003Ng]h0g]kN0100g]kN:`3oool3000005H0oooo0`00001X0?ooo`<00000V`3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=:0?ooo`T0g]kN0P00000B0=kNgRh0oooo00<000000?ooo`3oool00P3oool2000002H0
oooo0P00000Z0?ooo`030000003oool0oooo0080oooo0P00000h0?ooo`800000:P3oool00`000000
oooo0?ooo`020?ooo`800000FP3oool2000003P0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cBP3oool80=kNgP03
0000003Ng]h000000180g]kN;P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03P0
oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05X0
oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=:0?ooo`D0g]kN00H000000=kNgP3N
g]h000000=kNgP0000060=kNgP8000002P3Ng]hK0?ooo`H000000`3oool3000000@0oooo10000004
0?ooo`030000003oool0oooo00X0oooo1@00000=0?ooo`8000000`3oool2000000<0oooo00<00000
0?ooo`3oool05@3oool6000000<0oooo0`0000040?ooo`@00000103oool00`000000oooo0?ooo`02
0?ooo`D000003P3oool2000000<0oooo0P00000<0?ooo`8000000`3oool2000000T0oooo00<00000
0?ooo`3oool05@3oool6000000<0oooo0`0000040?ooo`@00000103oool00`000000oooo0?ooo`0:
0?ooo`D000003P3oool2000000<0oooo0P00000<0?ooo`8000000`3oool2000001<0oooo0P000003
0?ooo`8000002@3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dX0oooo1P3Ng]h2
000000<0g]kN00<000000=kNgP3Ng]h00P3Ng]h010000000g]kN0=kNgP0000090=kNgQ`0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000070?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0
oooo01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000060?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`030000003oool0
oooo00D0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo03H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cBP3oool70=kNgP050000003Ng]h0g]kN0=kNgP0000001`3Ng]h00`000000g]kN
0=kNgP070=kNgQ`0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`0F0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0000000;0?ooo`030000003oool0oooo01H0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000
000;0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cBP3oool;0=kNgP030000003N
g]h0g]kN00@0g]kN00<000000=kNgP3Ng]h0203Ng]hL0?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`020?ooo`D000001@3oool00`000000oooo0?ooo`040?ooo`D000001`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0103oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool01@3oool5
000000H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`020?ooo`D000001@3oool00`000000oooo0?ooo`050?ooo`D00000
1`3oool00`000000oooo0?ooo`040?ooo`D000001`3oool00`000000oooo0?ooo`0;0?ooo`D00000
1`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
AP3oool200000080oooo2`3Ng]h00`000000g]kN0=kNgP020=kNgP040000003Ng]h0g]kN000000T0
g]kN0P3oool2000001P0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000D0oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000203oool00`000000oooo
0?ooo`050?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`030000003oool00000
00h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`030000003oool0oooo
03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cAP3oool010000000oooo0?ooo`3oool;0=kNgP030000003Ng]h0
g]kN00<0g]kN0P00000:0=kNgP<0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`05
0?ooo`<00000103oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo0`000000103oool0000000000000
00030?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool01@3oool3000000@0oooo0`00
00000`3oool000000?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`040?ooo`<0000000@0oooo00000000000000001P3oool00`000000oooo
0?ooo`030?ooo`<0000000<0oooo0000000000001@0000050?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool01@3oool3000000@0oooo0`0000000`3oool000000?ooo`020?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`<00000
00@0oooo00000000000000001@3oool00`000000oooo0?ooo`040?ooo`<0000000<0oooo00000000
00001@0000080?ooo`030000003oool0oooo00@0oooo0`0000001@3oool00000000000000000oooo
008000001P3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dH0oooo00@000000?oo
o`3oool0oooo2`3Ng]h00`000000g]kN0=kNgP0?0=kNgP<0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00X0oooo0`00000I0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`020?ooo`<00000:`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0:0?ooo`<00000:`3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0
oooo000000D0oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=60?ooo`040000003o
ool0oooo0?ooo``0g]kN00<000000=kNgP3Ng]h03P3Ng]h30?ooo`030000003oool0oooo01D0oooo
0`00000E0?ooo`8000003@3oool00`000000oooo0?ooo`0F0?ooo`8000005`3oool3000001D0oooo
0P0000050?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool00`3oool2000001L0oooo
0`00000E0?ooo`8000003@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool00P3oool2000003P0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cAP3oool010000000oooo
0?ooo`3oool<0=kNgP030000003Ng]h0g]kN00h0g]kN0`3oool00`000000oooo0?ooo`2k0?ooo`03
0000003oool0oooo0700oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0m0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<dH0oooo00@000000?ooo`3oool0oooo303Ng]h00`000000g]kN0=kNgP0>0=kN
gP<0oooo00<000000?ooo`3oool0^03oool010000000oooo0?ooo`00001_0?ooo`040000003oool0
oooo000001H0oooo00@000000?ooo`3oool00000?P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=60?ooo`040000
003oool0oooo0?ooo``0g]kN2P0000070=kNgP<0oooo00<000000?ooo`3oool0^@3oool200000740
oooo0P00000H0?ooo`800000?`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`<0000000D0oooo00000000
000000000?ooo`04000000@0oooo0`0000030?ooo`D000000`3oool3000000030?ooo`0000000000
008000000P3oool2000000<0oooo00@000000?ooo`3oool0oooo7@3Ng]h30?ooo`030000003oool0
oooo0?l0ooooR03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool00000
00@0oooo00@000000?ooo`3oool0oooo7@3Ng]h30?ooo`030000003oool0oooo0?l0ooooR03oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<J0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`040000003oool0oooo0?oo
o`80g]kN6@0000020=kNgP<0oooo00<000000?ooo`3oool0o`3ooon80?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<aX0oooo1@0000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`030?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00@00000
0?ooo`3oool0oooo7@3Ng]h30?ooo`030000003oool0oooo0?l0ooooR03oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<K0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool0000000@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0200000080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`3ooolM0=kNgP<0oooo00<000000?ooo`3o
ool0o`3ooon80?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<000000?ooo`0000000`3oool00`000000
oooo00000002000000<0oooo0`0000020?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`0000000`0000020?ooo`030000003oool00000008000001@3oool010000000oooo0?ooo`3ooolM
0=kNgP<0oooo00<000000?ooo`3oool0o`3ooon80?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a`0oooo00<00000
0?ooo`3oool03`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00l0oooo00@0
00000?ooo`3oool0oooo103Ng]h3000000<0g]kN00<000000=kNgP3Ng]h0100000040=kNgP030000
003Ng]h0000000D0g]kN0`3oool00`000000oooo0?ooo`3o0?ooohP0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
6P3oool300000140oooo1`00000A0?ooo`040000003oool0oooo0?ooo`D0g]kN00<000000=kNgP3N
g]h00P3Ng]h01@000000g]kN0=kNgP3Ng]h0000000L0g]kN00<000000=kNgP3Ng]h0103Ng]h30?oo
o`030000003oool0oooo0?l0ooooR03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=60?ooo`040000003oool0oooo
0?ooo`D0g]kN00<000000=kNgP3Ng]h01@0000020=kNgP030000003Ng]h0g]kN00@0g]kN00<00000
0=kNgP3Ng]h0103Ng]h30?ooo`030000003oool0oooo0?l0ooooQ@3oool40000o`L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dH0oooo00@00000
0?ooo`3oool0oooo1@3Ng]h00`000000g]kN0=kNgP020=kNgP030000003Ng]h0g]kN00<0g]kN00<0
00000=kNgP3Ng]h00P3Ng]h00`000000g]kN000000050=kNgP<0oooo00<000000?ooo`3oool0o`3o
oon80?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<dH0oooo00@000000?ooo`3oool0oooo1@3Ng]h00`000000g]kN
0=kNgP020=kNgP040000003Ng]h0g]kN00000080g]kN00<000000=kNgP3Ng]h02P3Ng]h30?ooo`03
0000003oool0oooo0?l0ooooQ`3oool20000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dH0oooo00@000000?ooo`3oool0oooo103Ng]h20000
00P0g]kN0P00000=0=kNgP<0oooo00<000000?ooo`3oool0o`3ooon60?ooo`030000o`3oool0003o
00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<dH0oooo0P00000Q0?ooo`800000o`3ooon70?ooo`040000o`3oool0oooo0000o`L0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool0
1@000?l0oooo0?ooo`3oool0003o00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool60000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cd0oooo00<000000?ooo`3oool0o`3o
oona0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c?@3oool00`000000oooo0?ooo`3o0?oookD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?03o
ool2000000P0oooo0`00003o0?oooj`0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?03oool00`000000oooo0000
00060?ooo`050000003oool0oooo0?ooo`000000o`3ooon[0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo
00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`3o0?ooojT0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>@3oool00`000000oooo000000020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0E`3oool3000005l0oooo0`00001h0?ooo`<00000L@3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool2000005T0oooo00D000000?ooo`3o
ool0oooo0000001M0?ooo`050000003oool0oooo0?ooo`000000NP3oool00`000000oooo0?ooo`1^
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cl0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1J
0?ooo`030000003oool0oooo05/0oooo00D000000?ooo`3oool0oooo0000001k0?ooo`030000003o
ool0oooo06d0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`000000G03oool00`000000oooo0?ooo`1K0?ooo`050000003oool0oooo0?ooo`00
0000N03oool4000006l0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool00`000000oooo0?ooo`040?ooo`<0
0000F`3oool2000005h0oooo1000001h0?ooo`050000003oool0oooo0?ooo`000000K`3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c=00?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0F`3oool00`00
0000oooo0?ooo`1i0?ooo`050000003oool0oooo0?ooo`000000K`3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=0
0?ooo`030000003oool0oooo05l0oooo00D000000?ooo`3oool0oooo0000001N0?ooo`030000003o
ool0oooo07P0oooo00D000000?ooo`3oool0oooo0000001_0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d00oooo
3000001G0?ooo`<00000H03oool3000007P0oooo0`00001`0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN03oool00`000000oooo
0?ooo`310?ooo`030000003oool0oooo0;D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN03oool00`000000oooo
0?ooo`310?ooo`030000003oool0oooo0;D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3oool5000000<0oooo
F00000070?ooo`D000001@3ooom8000000L0oooo1@0000060?oooeX000001P3oool5000000H0oooo
N`00000d0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<gP0oooo00<000000?ooo`3oool0`@3oool00`000000oooo
0?ooo`2e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<gP0oooo00<000000?ooo`3oool0`@3oool00`000000oooo
0?ooo`2e0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=?0?ooo`D0g]kN
00<000000=kNgP3Ng]h02`3Ng]ko0?oooi<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC`3oool50=kNgP030000
003Ng]h0g]kN00/0g]kN<03oool3000005H0oooo0`00001X0?ooo`<00000V`3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c=?0?ooo`@0g]kN0P00000=0=kNgS<0oooo00<000000?ooo`3oool00P3oool2000002H0oooo
0P00000Z0?ooo`030000003oool0oooo0080oooo0P00000h0?ooo`800000:P3oool00`000000oooo
0?ooo`020?ooo`800000FP3oool2000003P0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC`3oool30=kNgP030000
003Ng]h0000000d0g]kN<`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03P0oooo
00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05X0oooo
00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=?0?ooo`060000003Ng]h0g]kN0000003N
g]h000001P3Ng]h2000000D0g]kN803oool6000000<0oooo0`0000040?ooo`@00000103oool00`00
0000oooo0?ooo`0:0?ooo`D000003@3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo
01D0oooo1P0000030?ooo`<00000103oool4000000@0oooo00<000000?ooo`3oool00P3oool50000
00h0oooo0P0000030?ooo`800000303oool2000000<0oooo0P0000090?ooo`030000003oool0oooo
01D0oooo1P0000030?ooo`<00000103oool4000000@0oooo00<000000?ooo`3oool02P3oool50000
00h0oooo0P0000030?ooo`800000303oool2000000<0oooo0P00000C0?ooo`8000000`3oool20000
00T0oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=?0?ooo`030=kNgP0000000000
00<0g]kN00<000000=kNgP3Ng]h00P3Ng]h010000000g]kN0=kNgP0000040=kNgR40oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000070?ooo`03
0000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo
01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000060?ooo`03
0000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000=0?ooo`030000003oool0oooo
00D0oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo03H0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cC`3oool20=kNgP050000003Ng]h0g]kN0=kNgP0000001`3Ng]h00`000000g]kN0=kN
gP020=kNgR40oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`0F0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000P0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0000000;0?ooo`030000003oool0oooo01H0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;
0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC`3oool60=kNgP030000003Ng]h0
g]kN00@0g]kN00<000000=kNgP3Ng]h00`3Ng]hQ0?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`020?ooo`D000001@3oool00`000000oooo0?ooo`040?ooo`D000001`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool01@3oool50000
00H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`D000001@3oool00`000000oooo0?ooo`050?ooo`D000001`3o
ool00`000000oooo0?ooo`040?ooo`D000001`3oool00`000000oooo0?ooo`0;0?ooo`D000001`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cAP3o
ool2000000L0oooo1P3Ng]h00`000000g]kN0=kNgP020=kNgP040000003Ng]h0g]kN000000@0g]kN
1`3oool2000001P0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000203oool00`000000oooo0?oo
o`050?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`0000001`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000h0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;0?ooo`030000003oool0oooo03H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cAP3oool00`000000oooo0?ooo`060?ooo`H0g]kN00<000000=kNgP3N
g]h00`3Ng]h2000000D0g]kN203oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0
oooo0`0000040?ooo`<0000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool3000000040?ooo`00000000000000
00<0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`050?ooo`<00000103oool30000
00030?ooo`000000oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo0`000000103oool000000000000000060?ooo`030000003oool0
oooo00<0oooo0`0000000`3oool0000000000005000000D0oooo00<000000?ooo`3oool05P3oool0
0`000000oooo0?ooo`050?ooo`<00000103oool3000000030?ooo`000000oooo0080oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0`000000
103oool000000000000000050?ooo`030000003oool0oooo00@0oooo0`0000000`3oool000000000
0005000000P0oooo00<000000?ooo`3oool0103oool3000000050?ooo`00000000000000003oool0
0P0000060?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cAP3oool00`000000oooo
0?ooo`060?ooo`H0g]kN00<000000=kNgP3Ng]h02P3Ng]h80?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0:0?ooo`<000006@3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool3000002/0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool02P3oool3000002/0oooo00<000000?ooo`3oool05P3oool010000000oooo
0?ooo`0000050?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cAP3oool00`000000
oooo0?ooo`060?ooo`L0g]kN00<000000=kNgP3Ng]h02@3Ng]h80?ooo`030000003oool0oooo01D0
oooo0`00000E0?ooo`8000003@3oool00`000000oooo0?ooo`0F0?ooo`8000005`3oool3000001D0
oooo0P0000050?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool00`3oool2000001L0
oooo0`00000E0?ooo`8000003@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool00P3oool2000003P0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cAP3oool00`000000
oooo0?ooo`060?ooo`L0g]kN00<000000=kNgP3Ng]h02@3Ng]h80?ooo`030000003oool0oooo0;/0
oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03d0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cAP3oool00`000000oooo0?ooo`060?ooo`L0g]kN00<000000=kNgP3N
g]h02@3Ng]h80?ooo`030000003oool0oooo0;P0oooo00@000000?ooo`3oool00000K`3oool01000
0000oooo0?ooo`00000F0?ooo`040000003oool0oooo000003h0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cAP3o
ool00`000000oooo0?ooo`060?ooo`L0g]kN2P0000020=kNgPP0oooo00<000000?ooo`3oool0^@3o
ool200000740oooo0P00000H0?ooo`800000?`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<I0?ooo`<0000000D0
oooo00000000000000000?ooo`04000000@0oooo0`0000030?ooo`D000000`3oool3000000030?oo
o`0000000000008000000P3oool2000000<0oooo00<000000?ooo`3oool01P3ooolC0=kNgPP0oooo
00<000000?ooo`3oool0o`3ooon80?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aX0oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0ooooR03o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<J0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00<0oooo6@0000050?ooo`030000003oool0oooo0?l0ooooR03oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?oo
o`D000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool00`3oool400000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0240oooo00<000000?ooo`3oool0o`3ooon80?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo00<00000
0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo008000000P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0o`3ooon80?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<a/0oooo00<000000?ooo`0000000`3oool00`000000oooo00000002000000<0oooo0`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`0000020?ooo`030000
003oool00000008000001@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0oooo
R03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<L0?ooo`030000003oool0oooo00l0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00D0oooo0`0000030?ooo`03
0000003oool0oooo00@00000103oool00`000000oooo000000080?ooo`030000003oool0oooo0?l0
ooooR03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooo`<000004@3oool700000140oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001`3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0?l0ooooR03oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=60?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooohD0oooo10000?l70?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=60?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`3o0?oo
ohP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<cAP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0?l0ooooQ`3oool20000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<dH0oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P00000@
0?ooo`030000003oool0oooo0?l0ooooQP3oool00`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=60?ooo`8000008@3oool2
00000?l0ooooQ`3oool010000?l0oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo00D0003o0?ooo`3oool0oooo
0000o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo00oooo1P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<c
o`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0<c<c
o`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI
1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VI
VOl0VIVI1P2IVIT10>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40
oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 401},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Shift\[Hyphen]Enter "], Cell[
            "evaluate the whole current cell "]},
          {
            Cell["\<\
Shift\[Hyphen]Control\[Hyphen]Enter  or  Command\
\[Hyphen]Return \
\>"], Cell["evaluate only the selected subexpression "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.3"],

Cell["\<\
Ways to evaluate two\[Hyphen]dimensional expressions. \
\>", \
"Caption",
  CellTags->"S1.10.3"],

Cell["\<\
In most computations, you will want to go from one step to the next \
by taking the whole expression that you have generated, and then evaluating \
it. But if for example you are trying to manipulate a single formula to put \
it into a particular form, you may instead find it more convenient to perform \
a sequence of operations separately on different parts of the expression.  \
\
\>", "Text",
  CellTags->{"S1.10.3", "3.5"}],

Cell["\<\
You do this by selecting each part you want to operate on, then \
inserting the operation you want to perform, then using Shift\[Hyphen]Control\
\[Hyphen]Enter or Command\[Hyphen]Return. \
\>", "Text",
  CellTags->{"S1.10.3", "3.6"}],

Cell["Here is an expression with one part selected.", "MathCaption",
  CellTags->{"S1.10.3", "3.7"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000CR000`400?l00000o`00003o00<0oooo
03<c<`0c<c<0o`0c<c?o03<c<`P0<c<c0@3oool00080iNGUo`0c<c?o03<c<`T0<c<c0@3oool00003
0>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooool0oooo0`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0ooooo`3oool309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cE`3oool4000002L0oooo100000030?ooo`<0
0000o`3ooomb0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<cE`3oool2000002/0oooo0P0000050?ooo`800000o`3oooma0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cE`3oool2000002/0oooo0P000005
0?ooo`800000o`3ooomU0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<eL0oooo0P00000[0?ooo`8000001@3oool200000?l0ooooJ@3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cE`3oool2000002/0oooo0P0000050?ooo`800000o`3ooomY0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<U0?ooo`D00000103oool6000000<0oooo100000050?ooo`<00000103oool4000000<0
oooo1@0000040?ooo`800000103oool6000001L0oooo1P0000040?ooo`8000001@3oool200000?l0
ooooJ@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c9P3oool2000000D0oooo0P0000020?ooo`8000000`3oool20000
0080oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000030?oo
o`8000001P3oool2000000D0oooo1000000J0?ooo`8000001P3oool2000000D0oooo0P00003o0?oo
ofT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<bH0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0P000007
0?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P00000?
0?ooo`D000001`3oool2000000H0oooo0P0000060?ooo`800000o`3ooomX0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<V0?ooo`@00000103oool5000000<0oooo0P0000070?ooo`8000001@3oool200000080oooo0P00
00030?ooo`8000001P3oool2000000H0oooo0P00000K0?ooo`8000001P3oool2000000D0oooo0P00
003o0?ooofT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<bH0oooo100000030?ooo`8000000P3oool2000000<0oooo
0P0000020?ooo`8000000`3oool2000000D0oooo0P0000020?ooo`8000000`3oool3000000D0oooo
0P0000050?ooo`@000006P3oool2000000H0oooo0P0000050?ooo`800000o`3ooomY0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<V0?ooo`@00000103oool4000000D0oooo100000030?ooo`D00000103oool4000000<0
oooo1P0000030?ooo`800000103oool600000080oooo0P00000C0?ooo`@000001P3oool2000000D0
oooo0P00003o0?ooofT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<bH0oooo0P0000020?ooo`8000004`3oool20000
01H0oooo0P00000<0?ooo`800000503oool3000000H0oooo0P0000050?ooo`800000o`3ooomY0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<U0?ooo`L000004`3oool2000001H0oooo0P00000=0?ooo`800000503oool2
000000H0oooo0P0000050?ooo`800000o`3ooomY0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=G0?ooo`8000003@3o
ool2000001`0oooo0P0000050?ooo`800000o`3ooomY0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=G0?ooo`@00000
2@3oool2000000030?ooo`000000000001T0oooo100000030?ooo`<00000o`3ooomZ0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=T0?ooo`D00000o`3ooon=0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<>0?ooo`<00000<`3oool4000002H0oooo1000000?0?oooc80g]kN1000000V0=kNgP@0
00000P3Ng]ho0?ooo`@000009P3oool400000:D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo0P00000e0?oo
o`800000:P3oool2000000l0oooo<P3Ng]h2000002X0g]kN0P0000020=kNgSl0oooo0P00000Z0?oo
o`800000Y@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool2000003D0oooo0P00000Z0?ooo`8000003`3ooolb
0=kNgP800000:P3Ng]h200000080g]kN?`3oool2000002X0oooo0P00002U0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<=0?ooo`800000=@3oool2000002X0oooo0P00000?0?oooc80g]kN0P00000Z0=kNgP8000000P3N
g]ho0?ooo`800000:P3oool200000:D0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo0P00000e0?ooo`800000
:P3oool2000000@0oooo0P0000090?oooc80g]kN0P00000Z0=kNgP8000000P3Ng]h20?ooo`800000
>`3oool2000002X0oooo0P0000040?ooo`800000W`3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool2000000<0
oooo1@0000040?ooo`H000000`3oool4000000D0oooo0`0000040?ooo`@000000`3oool5000000@0
oooo0P0000040?ooo`H000005P3oool6000000@0oooo0P0000050?ooo`800000203oool5000000@0
g]kN1P0000030=kNgP@000001@3Ng]h3000000@0g]kN100000030=kNgPD00000103Ng]h2000000@0
g]kN1P00000F0=kNgPH00000103Ng]h200000080g]kN0`3oool2000000P0oooo1@0000040?ooo`H0
00000`3oool4000000D0oooo0`0000040?ooo`@000000`3oool5000000@0oooo0P0000040?ooo`H0
00005P3oool6000000@0oooo0P0000050?ooo`800000WP3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool20000
00@0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`8000000`3oool20000
00030?ooo`00000000000080oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P0000050?oo
o`@000006@3oool2000000H0oooo0P00000?0?ooo`030=kNgP000000000000D0g]kN0P0000020=kN
gP8000000`3Ng]h200000080g]kN0P0000030=kNgP80000000<0g]kN0000000000000P3Ng]h20000
0080g]kN0P0000030=kNgP8000001P3Ng]h2000000D0g]kN1000000I0=kNgP8000001P3Ng]h20000
0080g]kN3P3oool2000000D0oooo0P0000020?ooo`8000000`3oool200000080oooo0P0000030?oo
o`80000000<0oooo0000000000000P3oool200000080oooo0P0000030?ooo`8000001P3oool20000
00D0oooo1000000I0?ooo`8000001P3oool200000:D0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo0P000005
0?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001`3oool2000000D0oooo0P000002
0?ooo`8000000`3oool2000000H0oooo0P0000060?ooo`8000003P3oool5000000L0oooo0P000006
0?ooo`8000003`3oool00`3Ng]h00000000000050=kNgP8000000P3Ng]h2000000<0g]kN0P000007
0=kNgP8000001@3Ng]h200000080g]kN0P0000030=kNgP8000001P3Ng]h2000000H0g]kN0P00000>
0=kNgPD000001`3Ng]h2000000H0g]kN0P0000020=kNgPh0oooo0P0000050?ooo`8000000P3oool2
000000<0oooo0P0000070?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001P3oool2
000000H0oooo0P00000>0?ooo`D000001`3oool2000000H0oooo0P00002U0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<=0?ooo`800000103oool4000000@0oooo1@0000030?ooo`8000001`3oool2000000D0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000060?ooo`8000006P3oool2000000H0oooo0P00
000?0?ooo`030=kNgP000000000000800000103Ng]h5000000<0g]kN0P0000070=kNgP8000001@3N
g]h200000080g]kN0P0000030=kNgP8000001P3Ng]h2000000H0g]kN0P00000J0=kNgP8000001P3N
g]h200000080g]kN3P3oool4000000@0oooo1@0000030?ooo`8000001`3oool2000000D0oooo0P00
00020?ooo`8000000`3oool2000000H0oooo0P0000060?ooo`8000006P3oool2000000H0oooo0P00
002U0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`800000103oool4000000<0oooo0P0000020?ooo`800000
0`3oool200000080oooo0P0000030?ooo`8000001@3oool200000080oooo0P0000030?ooo`<00000
1@3oool2000000D0oooo1000000I0?ooo`8000001P3oool2000000l0oooo00<0g]kN000000000000
0P0000030=kNgP8000000P3Ng]h2000000<0g]kN0P0000020=kNgP8000000`3Ng]h2000000D0g]kN
0P0000020=kNgP8000000`3Ng]h3000000D0g]kN0P0000050=kNgP@000006@3Ng]h2000000H0g]kN
0P0000020=kNgPh0oooo100000030?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`800000
0`3oool2000000D0oooo0P0000020?ooo`8000000`3oool3000000D0oooo0P0000050?ooo`@00000
6@3oool2000000H0oooo0P00002U0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`800000103oool4000000@0
oooo100000050?ooo`@000000`3oool5000000@0oooo100000030?ooo`H000000`3oool2000000@0
oooo1P0000040?ooo`800000403oool4000000H0oooo0P00000?0?ooo`030=kNgP00000000000080
0000103Ng]h4000000D0g]kN100000030=kNgPD00000103Ng]h4000000<0g]kN1P0000030=kNgP80
0000103Ng]h600000080g]kN0`00000A0=kNgP@000001P3Ng]h200000080g]kN3P3oool4000000@0
oooo100000050?ooo`@000000`3oool5000000@0oooo100000030?ooo`H000000`3oool2000000@0
oooo1P0000020?ooo`<000004@3oool4000000H0oooo0P00002U0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?oo
o`800000103oool200000080oooo0P00000C0?ooo`8000005P3oool2000000h0oooo0P00000A0?oo
o`<000001P3oool2000000l0oooo00<0g]kN0000000000000P3Ng]h2000001<0g]kN0P00000F0=kN
gP8000002`3Ng]h2000000030=kNgP00000000000140g]kN0`0000060=kNgP8000000P3Ng]h>0?oo
o`8000000P3oool2000001<0oooo0P00000F0?ooo`8000002`3oool2000000030?ooo`0000000000
0140oooo0`0000060?ooo`800000Y@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool2000000<0oooo1`00000C
0?ooo`8000005P3oool2000000/0oooo1@00000B0?ooo`8000001P3oool2000000l0oooo1`00000C
0=kNgP8000005P3Ng]h2000000h0g]kN0P00000B0=kNgP8000001P3Ng]h200000080g]kN3@3oool7
000001<0oooo0P00000F0?ooo`8000002`3oool2000000030?ooo`00000000000180oooo0P000006
0?ooo`800000Y@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool2000003D0oooo0P00000<0?ooo`@000006P3o
ool2000000l0oooo<P3Ng]h2000000/0g]kN1000000K0=kNgP8000000P3Ng]ho0?ooo`8000002`3o
ool4000001/0oooo0P00002T0?ooo`80003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<`h0oooo0`00000c0?ooo`@000002`3oool3000001P0oooo
1000000?0?oooc80g]kN100000090=kNgP8000006`3Ng]h400000080g]kN?`3oool4000000X0oooo
0P00000J0?ooo`@00000X`3oool00`000?l0oooo0000o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cE03oool2000002/0oooo?`3Ng]h5000001h0
g]kNCP3oool200000;l0oooo00@0003o0?ooo`3oool0003o1`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooolP3oool01@000?l0oooo0?ooo`3o
ool0003o00L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?oooo40oooo1P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00?l0iNGUo`3UiND:0>GUi@40<c<c0@3oool00?l0
iNGUo`3UiND;0>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 78},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.3"],

Cell["\<\
Pressing Shift\[Hyphen]Control\[Hyphen]Enter evaluates the selected \
part.\
\>", "MathCaption",
  CellTags->{"S1.10.3", "3.8"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooh0oooo0`2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooon0?ooo`<0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<eH0oooo1000
000V0?ooo`@000000`3oool300000?l0ooooJ03oool50000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<eH0oooo0P00000Z0?ooo`8000001@3o
ool200000?l0ooooJ`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=F0?ooo`800000:P3oool2000000D0oooo0P00
003o0?ooof/0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cEP3oool2000002X0oooo0P0000050?ooo`800000o`3o
oom[0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<eH0oooo0P00000Z0?ooo`8000001@3oool200000?l0ooooJ`3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<T0?ooo`D00000103oool6000000<0oooo100000050?ooo`<00000103o
ool4000000<0oooo1@0000040?ooo`800000103oool6000001H0oooo1P0000040?ooo`8000001@3o
ool200000?l0ooooJ`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<U0?ooo`8000001@3oool200000080oooo0P00
00030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000<0oooo0P0000060?ooo`8000001@3oool4000001T0oooo0P0000060?ooo`8000001@3o
ool200000?l0ooooJ`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<U0?ooo`8000001@3oool200000080oooo0P00
00030?ooo`8000001`3oool2000000D0oooo0P0000020?ooo`8000000`3oool2000000H0oooo0P00
00060?ooo`8000003P3oool5000000L0oooo0P0000060?ooo`8000001P3oool200000?l0ooooJP3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<U0?ooo`@00000103oool5000000<0oooo0P0000070?ooo`8000001@3o
ool200000080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P00000J0?ooo`8000001P3o
ool2000000D0oooo0P00003o0?ooof/0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c9@3oool4000000<0oooo0P00
00020?ooo`8000000`3oool200000080oooo0P0000030?ooo`8000001@3oool200000080oooo0P00
00030?ooo`<000001@3oool2000000D0oooo1000000I0?ooo`8000001P3oool2000000D0oooo0P00
003o0?ooof/0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c9@3oool4000000@0oooo100000050?ooo`@000000`3o
ool5000000@0oooo100000030?ooo`H000000`3oool2000000@0oooo1P0000020?ooo`8000004P3o
ool4000000H0oooo0P0000050?ooo`800000o`3ooom[0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bD0oooo0P00
00020?ooo`8000004`3oool2000001H0oooo0P00000<0?ooo`8000004`3oool3000000H0oooo0P00
00050?ooo`800000o`3ooom[0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b@0oooo1`00000C0?ooo`8000005P3o
ool2000000d0oooo0P00000C0?ooo`8000001P3oool2000000D0oooo0P00003o0?ooof/0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cEP3oool2000000d0oooo0P00000K0?ooo`8000001@3oool200000?l0ooooJ`3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=F0?ooo`@000002@3oool2000000030?ooo`000000000001P0oooo1000
00030?ooo`<00000o`3ooom/0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f<0oooo1@00003o0?ooohh0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`l0oooo0`00
000c0?ooo`@000009P3oool4000004T0oooo0P00001e0?ooo`800000@P3oool4000002L0oooo1000
001?0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P00000e0?ooo`800000:P3oool2000004P0oooo0P00
001g0?ooo`800000@@3oool2000002/0oooo0P00001?0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P00
000e0?ooo`800000:P3oool2000004P0oooo0P00001g0?ooo`800000@@3oool2000002/0oooo0P00
001?0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P00000e0?ooo`800000:P3oool2000001<0oooo0P00
000W0?ooo`8000002@3oool2000007T0oooo0P0000100?ooo`800000:`3oool2000004l0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c3P3oool2000003D0oooo0P00000Z0?ooo`800000103oool2000000`0oooo0P00
000Y0?ooo`800000203oool2000007T0oooo0P0000040?ooo`800000>P3oool2000002/0oooo0P00
00040?ooo`800000B@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`8000000`3oool5000000@0oooo1P00
00030?ooo`@000001@3oool3000000@0oooo100000030?ooo`D00000103oool2000000@0oooo1P00
000F0?ooo`H00000103oool2000000D0oooo0P00000;0?ooo`8000002`3oool6000000L0oooo00<0
00000?ooo`3oool01@3oool6000000<0oooo0P0000080?ooo`800000103oool6000000L0oooo00<0
00000?ooo`3oool01@3oool6000000P0oooo00<000000?ooo`3oool01@3oool6000000h0oooo00<0
00000?ooo`3oool01@3oool6000000h0oooo00<000000?ooo`3oool01P3oool6000000/0oooo0P00
00050?ooo`8000001`3oool5000000@0oooo1P0000030?ooo`@000001@3oool3000000@0oooo1000
00030?ooo`D00000103oool2000000@0oooo1P00000G0?ooo`H00000103oool2000000D0oooo0P00
00180?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P0000040?ooo`8000001@3oool200000080oooo0P00
00030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000<0oooo0P0000060?ooo`8000001@3oool4000001T0oooo0P0000060?ooo`8000004@3o
ool2000000h0oooo0P0000090?ooo`030000003oool0oooo00H0oooo100000050?ooo`8000001`3o
ool2000000H0oooo0P0000090?ooo`030000003oool0oooo00H0oooo100000090?ooo`030000003o
ool0oooo00H0oooo1000000?0?ooo`030000003oool0oooo00H0oooo1000000?0?ooo`030000003o
ool0oooo00L0oooo1000000<0?ooo`8000003`3oool2000000D0oooo0P0000020?ooo`8000000`3o
ool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P00
00030?ooo`8000001P3oool2000000D0oooo1000000J0?ooo`8000001P3oool2000004l0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c3@3oool2000000D0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0P00
00070?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P00
000>0?ooo`D000001`3oool2000000H0oooo0P00000A0?ooo`800000103oool5000000D0oooo0P00
00070?ooo`D000001`3oool2000000H0oooo0P0000070?ooo`8000001P3oool2000000L0oooo1@00
00070?ooo`800000203oool5000000L0oooo0P00000>0?ooo`D000001`3oool2000000h0oooo1@00
00080?ooo`8000003@3oool2000000l0oooo0P0000050?ooo`8000000P3oool2000000<0oooo0P00
00070?ooo`8000001@3oool200000080oooo0P0000030?ooo`8000001P3oool2000000H0oooo0P00
000?0?ooo`D000001`3oool2000000H0oooo0P00001?0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P00
00040?ooo`@00000103oool5000000<0oooo0P0000070?ooo`8000001@3oool200000080oooo0P00
00030?ooo`8000001P3oool2000000H0oooo0P00000J0?ooo`8000001P3oool200000140oooo0P00
000>0?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool2000000L0oooo0P00
00060?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000002P3oool00`000000oooo0?oo
o`070?ooo`800000403oool00`000000oooo0?ooo`070?ooo`800000403oool00`000000oooo0?oo
o`080?ooo`8000003@3oool2000000l0oooo100000040?ooo`D000000`3oool2000000L0oooo0P00
00050?ooo`8000000P3oool2000000<0oooo0P0000060?ooo`8000001P3oool2000001/0oooo0P00
00060?ooo`800000C`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`800000103oool4000000<0oooo0P00
00020?ooo`8000000`3oool200000080oooo0P0000030?ooo`8000001@3oool200000080oooo0P00
00030?ooo`<000001@3oool2000000D0oooo1000000I0?ooo`8000001P3oool200000140oooo0P00
000>0?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`@000001@3oool2000000L0oooo0P00
00060?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`@000002@3oool00`000000oooo0?oo
o`060?ooo`@000003`3oool00`000000oooo0?ooo`060?ooo`@000003`3oool00`000000oooo0?oo
o`070?ooo`@00000303oool2000000l0oooo100000030?ooo`8000000P3oool2000000<0oooo0P00
00020?ooo`8000000`3oool2000000D0oooo0P0000020?ooo`8000000`3oool3000000D0oooo0P00
00050?ooo`@000006P3oool2000000H0oooo0P00001?0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P00
00040?ooo`@00000103oool4000000D0oooo100000030?ooo`D00000103oool4000000<0oooo1P00
00030?ooo`800000103oool6000000@0oooo0P00000@0?ooo`@000001P3oool200000180oooo0P00
000;0?ooo`@000004@3oool6000000<0oooo0P0000080?ooo`800000103oool400000140oooo1P00
000@0?ooo`H0000000<0oooo0000000000000`00000@0?ooo`H000000P3oool300000180oooo1P00
00040?ooo`8000001@3oool2000000l0oooo100000040?ooo`@000001@3oool4000000<0oooo1@00
00040?ooo`@000000`3oool6000000<0oooo0P0000040?ooo`H000000P3oool300000180oooo1000
00060?ooo`800000C`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`800000103oool200000080oooo0P00
000C0?ooo`8000005P3oool2000000h0oooo0P00000A0?ooo`<000001P3oool200000180oooo0P00
000<0?ooo`<000006P3oool2000000P0oooo0P0000050?ooo`<00000;`3oool2000001T0oooo0P00
00000`3oool000000000000K0?ooo`8000001@3oool2000000l0oooo0P0000020?ooo`8000004`3o
ool2000001H0oooo0P00000;0?ooo`80000000<0oooo0000000000004P3oool3000000H0oooo0P00
001?0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P0000030?ooo`L000004`3oool2000001H0oooo0P00
000;0?ooo`D000004P3oool2000000H0oooo0P00000C0?ooo`800000303oool2000001T0oooo0P00
000:0?ooo`8000001@3oool200000300oooo0P00000K0?ooo`800000603oool5000000@0oooo0P00
000?0?ooo`L000004`3oool2000001H0oooo0P00000;0?ooo`80000000<0oooo0000000000004`3o
ool2000000H0oooo0P00001?0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo0P00000e0?ooo`800000303o
ool4000001X0oooo0P0000180?ooo`800000>03oool2000001T0oooo0P00000J0?ooo`@00000103o
ool200000440oooo0P00000;0?ooo`@00000703oool2000004l0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3`3o
ool3000003<0oooo1000000;0?ooo`<00000603oool4000004T0oooo0P00000d0?ooo`80000000<0
oooo0000000000005`3oool2000000030?ooo`000000000001X0oooo0`0000030?ooo`800000@P3o
ool4000000X0oooo0P00000K0?ooo`@00000CP3oool20000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<eD0oooo0P00002L0?ooo`<000006@3o
ool3000001`0oooo0P00001F0?ooo`800000J`3oool00`000?l0oooo0000o`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo<0oooo00@0
003o0?ooo`3oool0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooob0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooa0?ooo`H0
003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2I
VIT609VIV@80<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@40<c<c0@3oool0
00030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.4 Entering Formulas", "Subsection",
  CellTags->{"S1.10.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["character", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["short form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["long form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["symbol", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["p\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Pi]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Pi", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["inf\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Infinity]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Degree]\)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["deg\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Degree]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Degree", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.4"],

Cell[TextData[{
  "Special forms for some common symbols. ",
  Cell[BoxData[
      \(TraditionalForm\`\[AliasIndicator]\)], "InlineFormula"],
  " stands for the key ",
  Cell[BoxData[
      \(TraditionalForm\`\[EscapeKey]\)], "InlineFormula"],
  "."
}], "Caption",
  CellTags->"S1.10.4"],

Cell[TextData[{
  "This is equivalent to ",
  StyleBox["Sin[60", "MR"],
  " ",
  StyleBox["Degree]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.2"}],

Cell[CellGroupData[{

Cell["Sin[60\[Degree]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\@3\/2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["Here is the long form of the input. ", "MathCaption",
  CellTags->{"S1.10.4", "4.3"}],

Cell[CellGroupData[{

Cell["Sin[60 \\[Degree]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\@3\/2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["You can enter the same input like this. ", "MathCaption",
  CellTags->{"S1.10.4", "4.4"}],

Cell[CellGroupData[{

Cell[TextData[{
  "Sin[60 \[AliasIndicator]",
  StyleBox["deg\[AliasIndicator]", "MR"],
  "]"
}], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\@3\/2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["Here the angle is in radians. ", "MathCaption",
  CellTags->{"S1.10.4", "4.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[\[Pi]\/3]\)], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\@3\/2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["special characters", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["short form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["long form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["ordinary characters", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LessEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]<=\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][LessEqual]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["<=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]>=\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][GreaterEqual]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox[">=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]!=\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][NotEqual]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]el\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Element]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Element[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]->\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Rule]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False, False, False, True}},
  CellTags->"S1.10.4"],

Cell[TextData[{
  "Special forms for a few operators. Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.3"},
    ButtonStyle->"MainBookLink"],
  " gives a complete list. "
}], "Caption",
  CellTags->"S1.10.4"],

Cell[TextData[{
  "Here the replacement rule is entered using two ordinary characters, as ",
  StyleBox["->", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.6"}],

Cell[CellGroupData[{

Cell["x/(x+1) /. x -> 3 + y", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\(3 + y\)\/\(4 + y\)\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["This means exactly the same. ", "MathCaption",
  CellTags->{"S1.10.4", "4.7"}],

Cell[CellGroupData[{

Cell["x/(x+1) /. x \\[Rule] 3 + y", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\(3 + y\)\/\(4 + y\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["As does this. ", "MathCaption",
  CellTags->{"S1.10.4", "4.8"}],

Cell[CellGroupData[{

Cell["x/(x+1) /. x \[Rule] 3 + y", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\(3 + y\)\/\(4 + y\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["Or this. ", "MathCaption",
  CellTags->{"S1.10.4", "4.9"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x/(x+1) /. x \[AliasIndicator]",
  StyleBox["->\[AliasIndicator]", "MR"],
  " 3 + y"
}], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\(3 + y\)\/\(4 + y\)\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[TextData[{
  "The special arrow form ",
  Cell[BoxData[
      \(TraditionalForm\` \[Rule] \)], "InlineFormula"],
  " is by default also used for output. "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.10"}],

Cell[CellGroupData[{

Cell["Solve[x^2 == 1, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["special characters", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["short form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["long form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["ordinary characters", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]div\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Divide]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Times]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]*\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Times]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["*", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Cross]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]cross\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Cross]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Cross[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equal] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]==\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Equal]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LongEqual] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]l=\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][LongEqual]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[And] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]&&\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][And]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]||\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Or]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["||", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Not] \)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["!\[AliasIndicator]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Not]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Implies] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]=>\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Implies]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Implies[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Union]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]un\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Union]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Union[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Intersection]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator]inter\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][Intersection]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Intersection[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[InvisibleComma]\)], "InlineFormula"],
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[AliasIndicator],\[AliasIndicator]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][InvisibleComma]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[InvisibleApplication] \)], 
                "InlineFormula"],
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              " ",
              StyleBox["\[AliasIndicator]@\[AliasIndicator]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              " ",
              StyleBox["\[Backslash][InvisibleApplication]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\ \)], "InlineFormula"],
              StyleBox["@", "MR"],
              StyleBox["x", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox4Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, True, True, False, False, False, False, False, True, False, 
      True, False}},
  CellTags->"S1.10.4"],

Cell["\<\
Some operators with special forms used for input but not output. \
\
\>", "Caption",
  CellTags->"S1.10.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " understands ",
  Cell[BoxData[
      \(TraditionalForm\`\[Divide]\)], "InlineFormula"],
  ", but does not use it by default for output. "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.11"}],

Cell[CellGroupData[{

Cell["x \[Divide] y", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(x\/y\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[TextData[{
  "The forms of input discussed so far in this section use special \
characters, but otherwise just consist of ordinary one\[Hyphen]dimensional \
lines of text. ",
  StyleBox["Mathematica", "TI"],
  " notebooks, however, also make it possible to use two\[Hyphen]dimensional \
forms of input. "
}], "Text",
  CellTags->{"S1.10.4", "4.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["two-dimensional", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["one-dimensional", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["y",
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell["power "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  FractionBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["y",
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell["division "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  SqrtBox[
                    StyleBox["x",
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sqrt[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["square root "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RadicalBox[
                    StyleBox["x",
                      "TI"], 
                    StyleBox["n",
                      "TI"]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["(1/", "MR"],
              StyleBox["n", "TI"],
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " root "
            }]]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RowBox[{
                    UnderoverscriptBox["\[Sum]", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "=", 
                        StyleBox[\(i\_min\),
                          "TI"]}], 
                      StyleBox[\(i\_max\),
                        "TI"]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sum[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["sum "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RowBox[{
                    UnderoverscriptBox["\[Product]", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], "=", 
                        StyleBox[\(i\_min\),
                          "TI"]}], 
                      StyleBox[\(i\_max\),
                        "TI"]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Product[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["product "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RowBox[{"\[Integral]", 
                    RowBox[{
                      StyleBox["f",
                        "TI"], " ", 
                      RowBox[{"\[DifferentialD]", 
                        StyleBox["x",
                          "TI"]}]}]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["indefinite integral "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RowBox[{
                    SubsuperscriptBox["\[Integral]", 
                      StyleBox[\(x\_min\),
                        "TI"], 
                      StyleBox[\(x\_max\),
                        "TI"]], 
                    RowBox[{
                      StyleBox["f",
                        "TI"], " ", 
                      RowBox[{"\[DifferentialD]", 
                        StyleBox["x",
                          "TI"]}]}]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Integrate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["definite integral "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[PartialD]", 
                      StyleBox["x",
                        "TI"]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["partial derivative "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[PartialD]", 
                      RowBox[{
                        StyleBox["x",
                          "TI"], ",", 
                        StyleBox["y",
                          "TI"]}]], 
                    StyleBox["f",
                      "TI"]}]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["D[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["multivariate partial derivative "]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["z",
                      "TI"], "\[Conjugate]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Conjugate[", "MR"],
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["complex conjugate "]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["m",
                      "TI"], "\[Transpose]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["transpose "]},
          {Cell[TextData[{
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["m",
                      "TI"], "\[ConjugateTranspose]"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["ConjugateTranspose[", "MR"],
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["conjugate transpose "]},
          {Cell[TextData[{
              " ",
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["expr",
                      "TI"], 
                    RowBox[{"\[LeftDoubleBracket]", 
                      RowBox[{
                        StyleBox["i",
                          "TI"], ",", 
                        StyleBox["j",
                          "TI"], ",", "\[Ellipsis]"}], 
                      "\[RightDoubleBracket]"}]]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["part extraction "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.4"],

Cell[TextData[{
  "Some two\[Hyphen]dimensional forms that can be used in ",
  StyleBox["Mathematica", "SO"],
  " notebooks. "
}], "Caption",
  CellTags->"S1.10.4"],

Cell[TextData[{
  "You can enter two\[Hyphen]dimensional forms using any of the mechanisms \
discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.10.2",
    ButtonData:>{"1.10.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ". Note that upper and lower limits for sums and products must be entered \
as overscripts and underscripts\[LongDash]not superscripts and subscripts.  "
}], "Text",
  CellTags->{"S1.10.4", "4.13"}],

Cell[TextData[{
  "This enters an indefinite integral. Note the use of \[AliasIndicator]",
  StyleBox["dd\[AliasIndicator]", "MR"],
  " to enter the \[OpenCurlyDoubleQuote]differential \
d\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.14"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[AliasIndicator]",
  StyleBox["int\[AliasIndicator]", "MR"],
  " f[x] \[AliasIndicator]",
  StyleBox["dd\[AliasIndicator]", "MR"],
  " x"
}], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\[Integral]f[x] \[DifferentialD]x\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["\<\
Here is an indefinite integral that can be explicitly evaluated. \
\
\>", "MathCaption",
  CellTags->{"S1.10.4", "4.15"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]Exp[\(-x\^2\)] \[DifferentialD]x\)], "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(1\/2\ \@\[Pi]\ Erf[x]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the usual ",
  StyleBox["Mathematica", "TI"],
  " input for this integral. "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.16"}],

Cell[CellGroupData[{

Cell["Integrate[Exp[-x^2], x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(1\/2\ \@\[Pi]\ Erf[x]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["This enters exactly the same integral. ", "MathCaption",
  CellTags->{"S1.10.4", "4.17"}],

Cell[CellGroupData[{

Cell["\\!\\( \\[Integral] Exp[-x\\^2] \\[DifferentialD]x \\)", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(1\/2\ \@\[Pi]\ Erf[x]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["short form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["long form", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["sum\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Sum]", "MR"],
              " "
            }]], Cell[TextData[{
              "summation sign ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["prod\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Product]", "MR"],
              " "
            }]], Cell[TextData[{
              "product sign ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Product]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["int\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Integral]", "MR"],
              " "
            }]], Cell[TextData[{
              "integral sign ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["dd\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[DifferentialD]", "MR"],
              " "
            }]], Cell[TextData[{
              "special ",
              Cell[BoxData[
                  \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
              " for use in integrals "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["pd\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[PartialD]", "MR"],
              " "
            }]], Cell[TextData[{
              "partial derivative operator ",
              Cell[BoxData[
                  \(TraditionalForm\`\[PartialD]\)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["co\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Conjugate]", "MR"],
              " "
            }]], Cell[TextData[{
              "conjugate symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Conjugate] \)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["tr\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Transpose]", "MR"],
              " "
            }]], Cell[TextData[{
              "transpose symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Transpose] \)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["ct\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ConjugateTranspose]", "MR"],
              " "
            }]], Cell[TextData[{
              "conjugate transpose symbol ",
              Cell[BoxData[
                  \(TraditionalForm\`\[ConjugateTranspose] \)], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["[[\[AliasIndicator]", "MR"],
              ", \[ThinSpace]\[AliasIndicator]",
              StyleBox["]]\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[Backslash]",
              StyleBox["[LeftDoubleBracket]", "MR"],
              ", \[Backslash]",
              StyleBox["[RightDoubleBracket]", "MR"],
              " "
            }]], Cell["part brackets "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.4"],

Cell[TextData[{
  "Some special characters used in entering formulas. Section ",
  ButtonBox["3.10",
    ButtonData:>{"3.10"},
    ButtonStyle->"MainBookLink"],
  " gives a complete list. "
}], "Caption",
  CellTags->"S1.10.4"],

Cell[TextData[{
  "You should realize that even though a summation sign can look almost \
identical to a capital sigma it is treated in a very different way by ",
  StyleBox["Mathematica", "TI"],
  ". The point is that a sigma is just a letter; but a summation sign is an \
operator which tells ",
  StyleBox["Mathematica", "TI"],
  " to perform a ",
  StyleBox["Sum", "MR"],
  " operation.  "
}], "Text",
  CellTags->{"S1.10.4", "4.18"}],

Cell["Capital sigma is just a letter. ", "MathCaption",
  CellTags->{"S1.10.4", "4.19"}],

Cell[CellGroupData[{

Cell["a + \\[CapitalSigma]^2", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(a + \[CapitalSigma]\^2\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["A summation sign, on the other hand, is an operator. ", "MathCaption",
  CellTags->{"S1.10.4", "4.20"}],

Cell[CellGroupData[{

Cell[TextData[{
  "\[EscapeKey]",
  StyleBox["sum\[EscapeKey]", "MR"],
  " \[ControlKey]\[LeftModified]",
  StyleBox["+\[RightModified]", "MR"],
  " n=0 \[ControlKey]\[LeftModified]",
  StyleBox["%\[RightModified]", "MR"],
  " m \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified] 1/f[n]"
}], "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\[Sum]\+\(n = 0\)\%m 1\/f[n]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["Here is another way to enter the same input. ", "MathCaption",
  CellTags->{"S1.10.4", "4.21"}],

Cell[CellGroupData[{

Cell["\\!\\( \\[Sum] \\+ \\( n = 0 \\) \\% m 1 \\/ f[n] \\)", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\[Sum]\+\(n = 0\)\%m 1\/f[n]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell[TextData[{
  "Much as ",
  StyleBox["Mathematica", "TI"],
  " distinguishes between a summation sign and a capital sigma, it also \
distinguishes between an ordinary ",
  StyleBox["d", "MR"],
  " and the special \[OpenCurlyDoubleQuote]differential d\
\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " that is used in the standard notation for integrals. It is crucial that \
you use this differential ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  "\[LongDash]entered as \[EscapeKey]",
  StyleBox["dd\[EscapeKey]", "MR"],
  "\[LongDash]when you type in an integral. If you try to use an ordinary ",
  StyleBox["d", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will just interpret this as a symbol called ",
  StyleBox["d", "MR"],
  "\[LongDash]it will not understand that you are entering the second part of \
an integration operator. "
}], "Text",
  CellTags->{"S1.10.4", "4.22"}],

Cell[TextData[{
  "This computes the derivative of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.4", "4.23"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x x\^n\)], "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(n\ x\^\(\(-1\) + n\)\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["\<\
Here is the same derivative specified in ordinary \
one\[Hyphen]dimensional form. \
\>", "MathCaption",
  CellTags->{"S1.10.4", "4.24"}],

Cell[CellGroupData[{

Cell["D[x^n, x]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(n\ x\^\(\(-1\) + n\)\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["This computes the third derivative. ", "MathCaption",
  CellTags->{"S1.10.4", "4.25"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_\(x, x, x\)x\^n\)], "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\((\(-2\) + n)\)\ \((\(-1\) + n)\)\ n\ x\^\(\(-3\) + n\)\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S1.10.4"]
}, Open  ]],

Cell["\<\
Here is the equivalent one\[Hyphen]dimensional input form. \
\>", \
"MathCaption",
  CellTags->{"S1.10.4", "4.26"}],

Cell[CellGroupData[{

Cell["D[x^n, x, x, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S1.10.4"],

Cell[BoxData[
    \(\((\(-2\) + n)\)\ \((\(-1\) + n)\)\ n\ x\^\(\(-3\) + n\)\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S1.10.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.5 Entering Tables and Matrices", "Subsection",
  CellTags->{"S1.10.5", "5.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " front end typically provides a ",
  StyleBox["Create Table/Matrix/Palette", "SR"],
  " menu item which allows you to create a blank array with any specified \
number of rows and columns. Once you have such an array, you can then edit it \
to fill in whatever elements you want.   "
}], "Text",
  CellTags->{"S1.10.5", "5.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats an array like this as a matrix represented by a list of lists. "
}], "MathCaption",
  CellTags->{"S1.10.5", "5.3"}],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
        {"a", "b", "c"},
        {"1", "2", "3"}
        }]], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.5"],

Cell[BoxData[
    \({{a, b, c}, {1, 2, 3}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.5"]
}, Open  ]],

Cell["\<\
Putting parentheses around the array makes it look more like a \
matrix, but does not affect its interpretation. \
\>", "MathCaption",
  CellTags->{"S1.10.5", "5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"(", GridBox[{
          {"a", "b", "c"},
          {"1", "2", "3"}
          }], ")"}]], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.5"],

Cell[BoxData[
    \({{a, b, c}, {1, 2, 3}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.5"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["MatrixForm", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " to display the result of the ",
  StyleBox["Transpose", "MR"],
  " as a matrix. "
}], "MathCaption",
  CellTags->{"S1.10.5", "5.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"MatrixForm", "[", 
      RowBox[{"Transpose", "[", 
        RowBox[{"(", GridBox[{
              {"a", "b", "c"},
              {"1", "2", "3"}
              }], ")"}], "]"}], "]"}]], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"a", "1"},
            {"b", "2"},
            {"c", "3"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm= ",
  CellTags->"S1.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox[",\[RightModified]", "MR"],
              " "
            }]], Cell["add a column "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
              "\[RightModified] (Control\[Hyphen]Enter) "
            }]], Cell["add a row "]},
          {Cell["Tab "], Cell[TextData[{
              "go to the next ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Placeholder]\)], "InlineFormula"],
              " or ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SelectionPlaceholder]\)], 
                "InlineFormula"],
              " element "
            }]]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] (Control\[Hyphen]Space) "
            }]], Cell["move out of the table or matrix "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.5"],

Cell["Entering tables and matrices. ", "Caption",
  CellTags->"S1.10.5"],

Cell[TextData[{
  "Note that you can use \[ControlKey]\[LeftModified]",
  StyleBox[",\[RightModified]", "MR"],
  " and \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
  "\[RightModified] to start building up an array, and particularly for small \
arrays this is often more convenient than using the ",
  StyleBox["Create Table/Matrix/Palette", "SR"],
  " menu item. "
}], "Text",
  CellTags->{"S1.10.5", "5.6"}],

Cell[TextData[{
  "Section\[NonBreakingSpace]",
  ButtonBox["2.9.11",
    ButtonData:>{"2.9.11", "11.2"},
    ButtonStyle->"MainBookLink"],
  " will describe how to adjust many aspects of the appearance of arrays you \
create in ",
  StyleBox["Mathematica", "TI"],
  ". The ",
  StyleBox["Create Table/Matrix/Palette", "SR"],
  " menu item typically allows you to make basic adjustments, such as drawing \
lines between rows or columns. "
}], "Text",
  CellTags->{"S1.10.5", "5.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.6 Subscripts, Bars and Other Modifiers", "Subsection",
  CellTags->{"S1.10.6", "6.1"}],

Cell["Here is a typical palette of modifiers. ", "MathCaption",
  CellTags->{"S1.10.6", "6.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001S0000L2000`400?l00000o`00003oH`3oool0
068000000@3oool000030>k^kP0c<c<0<c<c05h0<c<c0@0000010?ooo`0000<0k^k^09VIV@2IVIT0
G@2IVIT103<c<`4000000@3oool000030>k^kP2IVIT0VIVI05d0VIVI0@0c<c<100000040oooo0000
0`3^k^h0VIVI09VIV@1M09VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVIF03^k^h4
09VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=E000000030>k^kP2IVIT0
VIVI0080VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a80EEEE0P3ooolE
05EEE@80oooo5@1EEED20?oooa80EEEE00<000000>k^kP2IVIT00`2IVIT103<c<`4000000@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@000001
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE
0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd0
0`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT1
03<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`08
0=gMg@@00000203MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE
0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd0
0`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd0
0`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A
0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A
0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo00`0gMgM00<00000
0=gMg@3MgMd01@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd0
0`1EEED0oooo0?ooo`0<0=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE0?ooo`3oool04@3MgMd0
0`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<6
0=gMg@D000001P3MgMd00`1EEED0oooo0?ooo`070=gMg@D00000203MgMd00`1EEED0oooo0?ooo`04
0=gMg@D0000000<0gMgM0000000000000`0000050=gMg@0305EEE@3oool0oooo00<0gMgM1@000002
0=gMg@@000000`3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<60=gMg@D000001P3MgMd00`1EEED0oooo0?ooo`070=gMg@D00000203MgMd0
0`1EEED0oooo0?ooo`040=gMg@D000000`3MgMd00`000000gMgM0=gMg@050=gMg@0305EEE@3oool0
oooo00<0gMgM1@0000090=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0oooo00L0gMgM1@000008
0=gMg@0305EEE@3oool0oooo00@0gMgM1@0000030=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE
0?ooo`3oool00`3MgMd5000000T0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c1P3MgMd5000000H0gMgM00<0EEEE0?ooo`3oool01`3MgMd5
000000P0gMgM00<0EEEE0?ooo`3oool0103MgMd5000000/0gMgM00<0EEEE0?ooo`3oool00`3MgMd5
000000T0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c1P3MgMd5000000H0gMgM00<0EEEE0?ooo`3oool01`3MgMd5000000P0gMgM00<0EEEE
0?ooo`3oool0103MgMd5000000/0gMgM00<0EEEE0?ooo`3oool00`3MgMd5000000T0gMgM00<0EEEE
0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c1P3MgMd5
000000H0gMgM00<0EEEE0?ooo`3oool01`3MgMd5000000P0gMgM00<0EEEE0?ooo`3oool0103MgMd5
000000/0gMgM00<0EEEE0?ooo`3oool00`3MgMd5000000T0gMgM00<0EEEE0000003^k^h0102IVIT1
03<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D
0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP04
09VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<80=gMg@030000003MgMd0
gMgM00H0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE
0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd0
0`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D
0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`000000k^k^09VIV@0309VIV@40<c<c0@000001
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=D0?ooo`030000003^k^h0VIVI00<0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a80EEEE0P3ooolE05EEE@80oooo5@1EEED2
0?oooa80EEEE00<000000>k^kP2IVIT00`2IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE
0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VI
V@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd0
0`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D
0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@000001
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE
0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0
oooo00L0gMgM1@0000080=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0
oooo00<0gMgM1@0000090=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0oooo00L0gMgM1@000008
0=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0oooo00<0gMgM1@000009
0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0oooo00L0gMgM1@0000080=gMg@0305EEE@3oool0
oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0oooo00<0gMgM1@0000090=gMg@0305EEE@000000
k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@000006
0=gMg@0305EEE@3oool0oooo00L0gMgM1@0000080=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;
0=gMg@0305EEE@3oool0oooo00<0gMgM1@0000090=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0
oooo00L0gMgM1@0000080=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0
oooo00<0gMgM1@0000090=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0oooo00L0gMgM1@000008
0=gMg@0305EEE@3oool0oooo00@0gMgM1@0000030=gMg@030000003MgMd0gMgM00D0gMgM00<0EEEE
0?ooo`3oool00`3MgMd5000000T0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo00`0gMgM00<000000=gMg@3MgMd01@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000
k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM00@00000
0=gMg@3MgMd000001`3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo00X0gMgM1@00
00050=gMg@0305EEE@3oool0oooo00X0gMgM100000030=gMg@0305EEE@000000k^k^00@0VIVI0@0c
<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM0P0000000`3MgMd000000=gM
g@050=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0303MgMd00`000000gMgM0=gM
g@050=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3o
ool0oooo00`0gMgM00<000000=gMg@3MgMd01@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0
EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0
EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3M
gMd00`1EEED0oooo0?ooo`080=gMg@@00000203MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3o
ool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0
VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0
EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503M
gMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?oo
o`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03oool00`000000k^k^09VIV@0309VIV@40<c<c0@00
00010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c=D0?ooo`030000003^k^h0VIVI00<0VIVI0@0c
<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a80EEEE0P3ooolE05EEE@80oooo5@1E
EED20?oooa80EEEE00<000000>k^kP2IVIT00`2IVIT103<c<`4000000@3oool000040>k^kP2IVIT0
VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0
EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^
09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503M
gMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000
103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?oo
o`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c1`3MgMd4000000H0gMgM00<0EEEE0?ooo`3oool0503M
gMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo00L0gMgM100000060=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM00@0
00000=gMg@3MgMd000001P3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM
00<0EEEE0?ooo`3oool01`3MgMd010000000gMgM0=gMg@0000060=gMg@0305EEE@000000k^k^00@0
VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM00@000000=gMg@3M
gMd000001P3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?oo
o`3oool01`3MgMd010000000gMgM0=gMg@0000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`L0gMgM100000060=gMg@0305EEE@3oool0
oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`070=gMg@@000001P3MgMd0
0`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A
0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A
0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo00<0gMgM1000000=
0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool0
00040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0
oooo00<0gMgM00@000000=gMg@3MgMd000003@3MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@00
00060=gMg@0305EEE@3oool0oooo00`0gMgM1@0000030=gMg@0305EEE@3oool0oooo00<0gMgM00@0
00000=gMg@3MgMd000001@3MgMd5000000<0gMgM00<0EEEE0?ooo`3oool01P3MgMd5000000H0gMgM
00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c
1P3MgMd5000000H0gMgM00<0EEEE0?ooo`3oool0303MgMd5000000<0gMgM00<0EEEE0?ooo`3oool0
0`3MgMd4000000D0gMgM1@0000030=gMg@0305EEE@3oool0oooo00H0gMgM1@0000060=gMg@0305EE
E@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM
1@0000060=gMg@0305EEE@3oool0oooo00`0gMgM1@0000030=gMg@0305EEE@3oool0oooo00`0gMgM
1@0000030=gMg@0305EEE@3oool0oooo00H0gMgM1@0000060=gMg@0305EEE@000000k^k^00@0VIVI
0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EE
E@3oool0oooo00`0gMgM1@0000030=gMg@0305EEE@3oool0oooo00`0gMgM1@0000030=gMg@0305EE
E@3oool0oooo00H0gMgM1@0000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo
0000103^k^h0VIVI09VIV@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0oooo00`0gMgM
1@0000030=gMg@0305EEE@3oool0oooo00`0gMgM1@0000030=gMg@0305EEE@3oool0oooo00H0gMgM
1@0000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VI
V@2IVIT203<c<`H0gMgM1@0000060=gMg@0305EEE@3oool0oooo00<0gMgM100000050=gMg@D00000
0`3MgMd00`1EEED0oooo0?ooo`0<0=gMg@D000000`3MgMd00`1EEED0oooo0?ooo`060=gMg@D00000
1P3MgMd00`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI
0P0c<c<A0=gMg@0305EEE@3oool0oooo00<0gMgM00@000000=gMg@3MgMd000003@3MgMd00`1EEED0
oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c<`40
00000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`030=gMg@04
0000003MgMd0gMgM000000d0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A0=gM
g@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<a40gMgM00<0EEEE0?ooo`3oool00`3MgMd4000000d0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1E
EED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gM
g@0305EEE@3oool0oooo00L0gMgM100000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<10000
0040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1E
EED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo00L0gMgM00@000000=gMg@3MgMd000001P3MgMd0
0`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A
0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`07
0=gMg@040000003MgMd0gMgM000000H0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3o
ool0oooo01@0gMgM00<0EEEE0?ooo`3oool01`3MgMd4000000H0gMgM00<0EEEE0000003^k^h0102I
VIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?oo
o`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^
kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3o
ool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0
EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0
EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<cE03o
ool00`000000k^k^09VIV@0309VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c
<c=D0?ooo`030000003^k^h0VIVI00<0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<a80EEEE0P3ooolE05EEE@80oooo5@1EEED20?oooa80EEEE00<000000>k^kP2IVIT00`2I
VIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?oo
o`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^
kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3o
ool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0
EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0;0=gMg@@000001@3MgMd00`1EEED0oooo0?oo
o`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2I
VIT203<c<a40gMgM00<0EEEE0?ooo`3oool02`3MgMd4000000D0gMgM00<0EEEE0?ooo`3oool02`3M
gMd010000000gMgM0=gMg@0000050=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0
102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo
0?ooo`0;0=gMg@040000003MgMd0gMgM000000D0gMgM00<0EEEE0?ooo`3oool02`3MgMd010000000
gMgM0=gMg@0000050=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000003^k^h0102IVIT103<c
<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd5000000T0gMgM00<0EEEE0?oo
o`3oool0103MgMd500000080gMgM00@000000=gMg@3MgMd000001@3MgMd00`1EEED0oooo0?ooo`04
0=gMg@D000000P3MgMd4000000D0gMgM00<0EEEE0?ooo`3oool01P3MgMd5000000H0gMgM00<0EEEE
0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd5
000000T0gMgM00<0EEEE0?ooo`3oool0103MgMd500000080gMgM100000050=gMg@0305EEE@3oool0
oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0oooo00H0gMgM1@0000060=gMg@0305EEE@000000
k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`<0gMgM1@000009
0=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;
0=gMg@0305EEE@3oool0oooo00H0gMgM1@0000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<1
00000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`<0gMgM1@0000090=gMg@0305EEE@3oool0
oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0
oooo00H0gMgM1@0000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<`<0gMgM1@0000090=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;
0=gMg@0305EEE@3oool0oooo00@0gMgM1@00000;0=gMg@0305EEE@3oool0oooo00H0gMgM1@000006
0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<`<0gMgM1@0000020=gMg@@000000`3MgMd00`1EEED0oooo0?ooo`040=gMg@D000002`3MgMd0
0`1EEED0oooo0?ooo`040=gMg@D000000P3MgMd4000000D0gMgM00<0EEEE0?ooo`3oool01P3MgMd5
000000H0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c2P3MgMd010000000gMgM0=gMg@0000030=gMg@0305EEE@3oool0oooo01@0gMgM00<0
EEEE0?ooo`3oool02`3MgMd010000000gMgM0=gMg@0000050=gMg@0305EEE@3oool0oooo0140gMgM
00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c
2P3MgMd010000000gMgM0=gMg@0000030=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3o
ool02`3MgMd010000000gMgM0=gMg@0000050=gMg@0305EEE@3oool0oooo0140gMgM00<0EEEE0000
003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c2P3MgMd40000
00<0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0;0=gMg@@000001@3MgMd00`1E
EED0oooo0?ooo`0A0=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0
VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gM
g@0305EEE@3oool0oooo00L0gMgM100000060=gMg@0305EEE@000000k^k^00@0VIVI0@0c<c<10000
0040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0EEEE0?ooo`3oool0503MgMd00`1E
EED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo00L0gMgM00@000000=gMg@3MgMd000001P3MgMd0
0`1EEED000000>k^kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A
0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`07
0=gMg@040000003MgMd0gMgM000000H0gMgM00<0EEEE0000003^k^h0102IVIT103<c<`4000000@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3o
ool0oooo01@0gMgM00<0EEEE0?ooo`3oool01`3MgMd4000000H0gMgM00<0EEEE0000003^k^h0102I
VIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c4@3MgMd00`1EEED0oooo0?oo
o`0D0=gMg@0305EEE@3oool0oooo01@0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`1EEED000000>k^
kP0409VIV@40<c<c0@0000010?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<A0=gMg@0305EEE@3o
ool0oooo01@0gMgM00<0EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0A0=gMg@0305EEE@00
0000k^k^00@0VIVI0@0c<c<100000040oooo0000103^k^h0VIVI09VIV@2IVIT203<c<a40gMgM00<0
EEEE0?ooo`3oool0503MgMd00`1EEED0oooo0?ooo`0D0=gMg@0305EEE@3oool0oooo0140gMgM00<0
EEEE0000003^k^h0102IVIT103<c<`4000000@3oool000040>k^kP2IVIT0VIVI09VIVEL0<c<c00<0
k^k^09VIV@2IVIT00P2IVIT103<c<`4000000@3oool000030>k^kP2IVIT0VIVI05d0VIVI0@0c<c<1
00000040oooo00000`3^k^h0VIVI09VIV@1M09VIV@40<c<c0@0000010?ooo`0000<0k^k^09VIV@2I
VIT0G@2IVIT103<c<`4000000@3oool000030>k^kP2IVIT0VIVI05d0VIVI0@0c<c<100000040oooo
001Q0>k^kP4000000@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{99, 112},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.6"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to use any expression as a subscript. "
}], "MathCaption",
  CellTags->{"S1.10.6", "6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[\((1 + x\_\(1 + n\))\)\^4]\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.6"],

Cell[BoxData[
    \(1 + 4\ x\_\(1 + n\) + 6\ x\_\(1 + n\)\%2 + 4\ x\_\(1 + n\)\%3 + 
      x\_\(1 + n\)\%4\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[TextData[{
  "Unless you specifically tell it otherwise, ",
  StyleBox["Mathematica", "TI"],
  " will interpret a superscript as a power. "
}], "MathCaption",
  CellTags->{"S1.10.6", "6.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[x\_n\%4 - 1]\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.6"],

Cell[BoxData[
    \(\((\(-1\) + x\_n)\)\ \((1 + x\_n)\)\ \((1 + x\_n\%2)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["_\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["-\[RightModified]", "MR"],
              " "
            }]], Cell["go to the position for a subscript"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["+\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["=\[RightModified]", "MR"],
              " "
            }]], Cell["go to the position underneath "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["^\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["6\[RightModified]", "MR"],
              " "
            }]], Cell["go to the position for a superscript "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["7\[RightModified]", "MR"],
              " "
            }]], Cell["go to the position on top "]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[RightModified] "
            }]], 
            Cell["\<\
return from a special position (Control\[Hyphen]Space) \
\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, True}},
  CellTags->"S1.10.6"],

Cell["\<\
Special input forms based on control characters. The second forms \
given should work on any keyboard. \
\>", "Caption",
  CellTags->"S1.10.6"],

Cell["This enters a subscript using control keys. ", "MathCaption",
  CellTags->{"S1.10.6", "6.5"}],

Cell[CellGroupData[{

Cell[TextData[{
  "Expand[(1 + x\[ControlKey]\[LeftModified]",
  StyleBox["_\[RightModified]", "MR"],
  "1+n\[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified])^4]"
}], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.6"],

Cell[BoxData[
    \(1 + 4\ x\_\(1 + n\) + 6\ x\_\(1 + n\)\%2 + 4\ x\_\(1 + n\)\%3 + 
      x\_\(1 + n\)\%4\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[TextData[{
  "Just as \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " and \[ControlKey]\[LeftModified]",
  StyleBox["_\[RightModified]", "MR"],
  " go to superscript and subscript positions, so also \[ControlKey]\
\[LeftModified]",
  StyleBox["&\[RightModified]", "MR"],
  " and \[ControlKey]\[LeftModified]",
  StyleBox["=\[RightModified]", "MR"],
  " can be used to go to positions directly above and below. With the layout \
of a standard English\[Hyphen]language keyboard \
\[ControlKey]\[LeftModified]",
  StyleBox["&\[RightModified]", "MR"],
  " is directly to the right of \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " while \[ControlKey]\[LeftModified]",
  StyleBox["=\[RightModified]", "MR"],
  " is directly to the right of \[ControlKey]\[LeftModified]",
  StyleBox["_\[RightModified]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.10.6", "6.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["key sequence", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["displayed form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["expression form", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified]_", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "_"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox[
              "&\[RightModified]\[AliasIndicator]vec\[AliasIndicator]", "MR"],
              
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "\[RightVector]"], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverVector[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified]~", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "~"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverTilde[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified]^", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "^"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverHat[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox["&\[RightModified].", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "."], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverDot[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              "\[ControlKey]\[LeftModified]",
              StyleBox["=\[RightModified]_", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    UnderscriptBox[
                      StyleBox["x",
                        "TI"], "_"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.6"],

Cell["Ways to enter some common modifiers using control keys. ", "Caption",
  CellTags->"S1.10.6"],

Cell[TextData[{
  "Here is ",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          StyleBox["x",
            "TI"], "_"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.6", "6.7"}],

Cell[CellGroupData[{

Cell[TextData[{
  "x \[ControlKey]\[LeftModified]",
  StyleBox["&\[RightModified]", "MR"],
  "_ \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  "\[RightModified]"
}], "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.10.6"],

Cell[BoxData[
    \(x\&_\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  Cell[BoxData[
      FormBox[
        OverscriptBox[
          StyleBox["x",
            "TI"], "_"], TraditionalForm]], "InlineFormula"],
  " as a variable. "
}], "MathCaption",
  CellTags->{"S1.10.6", "6.8"}],

Cell[CellGroupData[{

Cell["Solve[a^2 == %, a]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.10.6"],

Cell[BoxData[
    \({{a \[Rule] \(-\@x\&_\)}, {a \[Rule] \@x\&_}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["key sequence", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["displayed form", "SO10"],
              " "
            }]], Cell[TextData[StyleBox["expression form", "SO10"]]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Subscript[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    UnderscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"],
                      LimitsPositioning->False], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Underscript[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]^", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Superscript[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " (interpreted as ",
              StyleBox["Power[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]&", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["y",
                        "TI"],
                      LimitsPositioning->False], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["Overscript[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]&_", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "_"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]&\[Backslash][RightVector]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "\[RightVector]"], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverVector[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]&~", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "~"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverTilde[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]&^", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "^"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverHat[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]&.", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    OverscriptBox[
                      StyleBox["x",
                        "TI"], "."], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverDot[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash]+_", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    UnderscriptBox[
                      StyleBox["x",
                        "TI"], "_"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderBar[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.6"],

Cell[TextData[{
  "Ways to enter modifiers without control keys. All these forms can be used \
only inside \[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
1.10.7 Special Topic: Non\[Hyphen]English Characters and \
Keyboards\
\>", "Subsection",
  CellTags->{"S1.10.7", "7.1"}],

Cell[TextData[{
  "If you enter text in languages other than English, you will typically need \
to use various additional accented and other characters. If your computer \
system is set up in an appropriate way, then you will often be able to enter \
such characters directly using standard keys on your keyboard. But however \
your system is set up, ",
  StyleBox["Mathematica", "TI"],
  " always provides a uniform way to handle such characters.  "
}], "Text",
  CellTags->{"S1.10.7", "7.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[AGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[AGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ARing]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ARing]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["ao\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ADoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ADoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["a\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CCedilla]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CCedilla]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c,\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CHacek]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CHacek]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["cv\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["e`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[IAcute]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[IAcute]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["i'\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["n~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[OGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o`\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[OSlash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[OSlash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o/\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ODoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ODoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["o\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UGrave]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UGrave]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u`\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["u\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SZ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SZ]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sz\[AliasIndicator]", "MR"],
                          ", \[AliasIndicator]",
                          StyleBox["ss\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalARing]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalARing]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Ao\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalADoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalADoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["A\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalODoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalODoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["O\"\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CapitalUDoubleDot]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CapitalUDoubleDot]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["U\"\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S1.10.7"],

Cell["Some common European characters. ", "Caption",
  CellTags->"S1.10.7"],

Cell["\<\
Here is a function whose name involves an accented character. \
\
\>", "MathCaption",
  CellTags->{"S1.10.7", "7.3"}],

Cell[CellGroupData[{

Cell["Lam\\[EAcute][x, y]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.7"],

Cell[BoxData[
    \(Lam\[EAcute][x, y]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.7"]
}, Open  ]],

Cell["This is another way to enter the same input. ", "MathCaption",
  CellTags->{"S1.10.7", "7.4"}],

Cell[CellGroupData[{

Cell[TextData[{
  "Lam\[AliasIndicator]",
  StyleBox["e'\[AliasIndicator]", "MR"],
  "[x, y]"
}], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.7"],

Cell[BoxData[
    \(Lam\[EAcute][x, y]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.7"]
}, Open  ]],

Cell["\<\
You should realize that there is no uniform standard for computer \
keyboards around the world, and as a result it is inevitable that some \
details of what has been said in this chapter may not apply to your keyboard. \
\
\>", "Text",
  CellTags->{"S1.10.7", "7.5"}],

Cell[TextData[{
  "In particular, the identification for example of \[ControlKey]\
\[LeftModified]",
  StyleBox["6\[RightModified]", "MR"],
  " with \[ControlKey]\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  " is valid only for keyboards on which ",
  StyleBox["^", "MR"],
  " appears as Shift\[Hyphen]",
  StyleBox["6", "MR"],
  ". On other keyboards, ",
  StyleBox["Mathematica", "TI"],
  " uses \[ControlKey]\[LeftModified]",
  StyleBox["6\[RightModified]", "MR"],
  " to go to a superscript position, but not necessarily \[ControlKey]\
\[LeftModified]",
  StyleBox["^\[RightModified]", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.10.7", "7.6"}],

Cell[TextData[{
  "Regardless of how your keyboard is set up you can always use palettes or \
menu items to set up superscripts and other kinds of notation. And assuming \
you have some way to enter characters such as \[Backslash], you can always \
give input using full names such as \[Backslash]",
  StyleBox["[Infinity]", "MR"],
  " and textual forms such as \[Backslash]",
  StyleBox["(x\[Backslash]/y\[Backslash])", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.10.7", "7.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.8 Other Mathematical Notation", "Subsection",
  CellTags->{"S1.10.8", "8.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports an extremely wide range of mathematical notation, although often \
it does not assign a pre\[Hyphen]defined meaning to it. Thus, for example, \
you can enter an expression such as ",
  StyleBox["x", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " ",
  StyleBox["y", "MR"],
  ", but ",
  StyleBox["Mathematica", "TI"],
  " will not initially make any assumption about what you mean by ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S1.10.8", "8.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows that ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " is an operator, but it does not initially assign any specific meaning to \
it. "
}], "MathCaption",
  CellTags->{"S1.10.8", "8.3"}],

Cell[CellGroupData[{

Cell["{17 \[CirclePlus] 5, 8 \[CirclePlus] 3}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \({17\[CirclePlus]5, 8\[CirclePlus]3}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.8"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["Mathematica", "TI"],
  " a definition for what the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " operator does. "
}], "MathCaption",
  CellTags->{"S1.10.8", "8.4"}],

Cell["x_ \[CirclePlus] y_ := Mod[x + y, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.8"],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica", "TI"],
  " can evaluate ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " operations. "
}], "MathCaption",
  CellTags->{"S1.10.8", "8.5"}],

Cell[CellGroupData[{

Cell["{17 \[CirclePlus] 5, 8 \[CirclePlus] 3}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \({0, 1}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.10.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[CirclePlus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CirclePlus]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c+\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[CircleTimes]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[CircleTimes]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["c*\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[PlusMinus]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[PlusMinus]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["+-\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Wedge]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Wedge]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["^\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Vee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Vee]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["v\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[TildeEqual]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[TildeEqual]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["~=\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[TildeTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[TildeTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["~~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Tilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Tilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Proportional]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Proportional]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["prop\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Congruent]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Congruent]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["===\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GreaterTilde]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterTilde]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox[">~\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GreaterGreater]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GreaterGreater]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Succeeds]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Succeeds]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[RightTriangle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTriangle]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[LongRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LongRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["-->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[LeftRightArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[LeftRightArrow]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["<->\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[UpArrow]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[UpArrow]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Equilibrium]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Equilibrium]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["equi\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[RightTee]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[RightTee]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Superset]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Superset]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sup\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SquareIntersection]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SquareIntersection]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Element]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Element]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["elem\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[NotElement]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[NotElement]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["!elem\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[SmallCircle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[SmallCircle]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["sc\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Therefore]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Therefore]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[VerticalSeparator]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalSeparator]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[VerticalBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[VerticalBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          Cell[BoxData[
                              \(TraditionalForm\`\[SpaceIndicator]\)], 
                            "InlineFormula"],
                          StyleBox["|\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Backslash]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Backslash]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["\\\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S1.10.8"],

Cell[TextData[{
  "A few of the operators whose input is supported by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.10.8"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " assigns built\[Hyphen]in meanings to ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterEqual] \)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterSlantEqual] \)], "InlineFormula"],
  ", but not to ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterTilde] \)], "InlineFormula"],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\` \[GreaterGreater] \)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.8", "8.6"}],

Cell[CellGroupData[{

Cell["{3 \[GreaterEqual] 4, 3 \[GreaterSlantEqual] 4, 3 \[GreaterTilde] 4, 3 \
\[GreaterGreater] 4}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \({False, False, 3 \[GreaterTilde] 4, 3 \[GreaterGreater] 4}\)], "Output",\

  CellLabel->"Out[4]= ",
  CellTags->"S1.10.8"]
}, Open  ]],

Cell[TextData[{
  "There are some forms which look like characters on a standard keyboard, \
but which are interpreted in a different way by ",
  StyleBox["Mathematica", "TI"],
  ". Thus, for example, \[Backslash]",
  StyleBox["[Backslash]", "MR"],
  " or \[AliasIndicator]",
  StyleBox["\\\[AliasIndicator]", "MR"],
  " displays as \[Backslash] but is not interpreted in the same way as a \
\[Backslash] typed directly on the keyboard.  "
}], "Text",
  CellTags->{"S1.10.8", "8.7"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`\[Backslash]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Wedge]\)], "InlineFormula"],
  " characters used here are different from the \[Backslash] and ",
  StyleBox["^", "MR"],
  " you would type directly on a keyboard. "
}], "MathCaption",
  CellTags->{"S1.10.8", "8.8"}],

Cell[CellGroupData[{

Cell[TextData[{
  "{a \[AliasIndicator]",
  StyleBox["\\\[AliasIndicator]", "MR"],
  " b, a \[AliasIndicator]",
  StyleBox["^\[AliasIndicator]", "MR"],
  " b}"
}], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \({a\[Backslash]b, a\[Wedge]b}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.10.8"]
}, Open  ]],

Cell[TextData[{
  "Most operators work like ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " and go in between their operands. But some operators can go in other \
places. Thus, for example, \[AliasIndicator]",
  StyleBox["<\[AliasIndicator]", "MR"],
  " and \[AliasIndicator]",
  StyleBox[">\[AliasIndicator]", "MR"],
  " or \[Backslash]",
  StyleBox["[LeftAngleBracket]", "MR"],
  " and \[Backslash]",
  StyleBox["[RightAngleBracket]", "MR"],
  " are effectively operators which go around their operand.  "
}], "Text",
  CellTags->{"S1.10.8", "8.9"}],

Cell["\<\
The elements of the angle bracket operator go around their operand. \
\
\>", "MathCaption",
  CellTags->{"S1.10.8", "8.10"}],

Cell[CellGroupData[{

Cell["\\[LeftAngleBracket] 1 + x \\[RightAngleBracket]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \(\[LeftAngleBracket]1 + x\[RightAngleBracket]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.10.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[ScriptL]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ScriptL]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["scl\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[ScriptCapitalE]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[ScriptCapitalE]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["scE\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[GothicCapitalR]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[GothicCapitalR]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["goR\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[DoubleStruckCapitalZ]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[DoubleStruckCapitalZ]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dsZ\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Aleph]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Aleph]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["al\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[EmptySet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[EmptySet]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["es\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Micro]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Micro]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["mi\[AliasIndicator]", "MR"]
                        }]]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]], Cell[
            TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[""], Cell[TextData[{
                          StyleBox["full name", "SO10"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["alias", "SO10"],
                          " "
                        }]]},
                      {Cell["\[Angstrom]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Angstrom]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["Ang\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[HBar]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[HBar]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["hb\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Sterling]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Sterling]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Angle]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Angle]", "MR"]
                        }]], Cell[""]},
                      {Cell["\[Bullet]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Bullet]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["bu\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Dagger]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Dagger]", "MR"]
                        }]], Cell[TextData[{
                          "\[AliasIndicator]",
                          StyleBox["dg\[AliasIndicator]", "MR"]
                        }]]},
                      {Cell["\[Natural]"], Cell[TextData[{
                          "\[Backslash]",
                          StyleBox["[Natural]", "MR"]
                        }]], Cell[""]}
                      },
                    ColumnAlignments->{Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S1.10.8"],

Cell["\<\
Some additional letters and letter\[Hyphen]like forms. \
\>", \
"Caption",
  CellTags->"S1.10.8"],

Cell["\<\
You can use letters and letter\[Hyphen]like forms anywhere in \
symbol names. \
\>", "MathCaption",
  CellTags->{"S1.10.8", "8.11"}],

Cell[CellGroupData[{

Cell["{\[GothicCapitalR]\[EmptySet], \\[Angle]ABC}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \({\[GothicCapitalR]\[EmptySet], \[Angle]ABC}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S1.10.8"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[EmptySet]\)], "InlineFormula"],
  " is assumed to be a symbol, and so is just multiplied by ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.8", "8.12"}],

Cell[CellGroupData[{

Cell["a \[EmptySet] b", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.10.8"],

Cell[BoxData[
    \(a\ b\ \[EmptySet]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S1.10.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.9 Forms of Input and Output", "Subsection",
  CellTags->{"S1.10.9", "9.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " notebooks allow you to give input and get output in a variety of \
different forms. Typically the front end provides menu commands for \
converting cells from one form to another. "
}], "Text",
  CellTags->{"S1.10.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["InputForm", "MR"],
              " "
            }]], 
            Cell["\<\
a form that can be typed directly using characters on a \
standard keyboard \
\>"]},
          {Cell[TextData[{
              StyleBox["OutputForm", "MR"],
              " "
            }]], 
            Cell["\<\
a form for output only that uses just characters on a \
standard keyboard \
\>"]},
          {Cell[TextData[{
              StyleBox["StandardForm", "MR"],
              " "
            }]], 
            Cell["\<\
a form for input and output that makes use of special \
characters and positioning \
\>"]},
          {Cell[TextData[{
              StyleBox["TraditionalForm", "MR"],
              " "
            }]], 
            Cell["\<\
a form primarily for output that imitates all aspects \
of traditional mathematical notation \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S1.10.9"],

Cell["Forms of input and output. ", "Caption",
  CellTags->"S1.10.9"],

Cell[TextData[{
  "The input here works in both ",
  StyleBox["InputForm", "MR"],
  " and ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.3"}],

Cell[CellGroupData[{

Cell["x^2 + y^2/z", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(x\^2 + y\^2\/z\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "Here is a version of the input appropriate for ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 + y\^2\/z\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(x\^2 + y\^2\/z\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " is the most general form of input for ",
  StyleBox["Mathematica", "TI"],
  ": it works whether you are using a notebook interface or a \
text\[Hyphen]based interface.  "
}], "Text",
  CellTags->{"S1.10.9", "9.5"}],

Cell[TextData[{
  "With a notebook interface, output is by default produced in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.6"}],

Cell[CellGroupData[{

Cell["Sqrt[x] + 1/(2 + Sqrt[y])", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(\@x + 1\/\(2 + \@y\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "With a text\[Hyphen]based interface, ",
  StyleBox["OutputForm", "MR"],
  " is used instead. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.7"}],

Cell[CellGroupData[{

Cell["Sqrt[x] + 1/(2 + Sqrt[y]) // OutputForm", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.10.9"],

Cell["Sqrt[x] + (2 + Sqrt[y])^(-1)", "Output",
  CellLabel->"Out[4]//OutputForm= ",
  CellTags->"S1.10.9"],

Cell[OutputFormData["\<\
               1
Sqrt[x] + -----------
          2 + Sqrt[y]\
\>"], "Output",
  CellLabel->"Out[4]//OutputForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "With a notebook interface, the default form for both input and output is \
",
  StyleBox["StandardForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.10.9", "9.8"}],

Cell[TextData[{
  "The basic idea of ",
  StyleBox["StandardForm", "MR"],
  " is to provide a precise but elegant representation of ",
  StyleBox["Mathematica", "TI"],
  " expressions, making use of special characters, two\[Hyphen]dimensional \
positioning, and so on. "
}], "Text",
  CellTags->{"S1.10.9", "9.9"}],

Cell[TextData[{
  "Both input and output are given here in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.10"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(1\/\((x\^3 + 1)\)\) \[DifferentialD]x\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(ArcTan[\(\(-1\) + 2\ x\)\/\@3]\/\@3 + 1\/3\ Log[1 + x] - 
      1\/6\ Log[1 - x + x\^2]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "An important feature of ",
  StyleBox["StandardForm", "MR"],
  " is that any output you get in this form you can also directly use as \
input. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.11"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ArcTan[\(\(-1\) + 2  x\)\/\@3]\/\@3 + Log[1 + x]\/3 - 
      Log[1 - x + x\^2]\/6\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(ArcTan[\(\(-1\) + 2\ x\)\/\@3]\/\@3 + 1\/3\ Log[1 + x] - 
      1\/6\ Log[1 - x + x\^2]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "The precise nature of ",
  StyleBox["StandardForm", "MR"],
  " prevents it from following all of the somewhat haphazard conventions of \
traditional mathematical notation. ",
  StyleBox["Mathematica", "TI"],
  " however also supports ",
  StyleBox["TraditionalForm", "MR"],
  ", which uses a large collection of rules to give a rather complete \
rendition of traditional mathematical notation.     "
}], "Text",
  CellTags->{"S1.10.9", "9.12"}],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " uses lower\[Hyphen]case names for functions, and puts their arguments in \
parentheses rather than square brackets. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.13"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(1\/\((x\^3 + 1)\)\) \[DifferentialD]x // 
      TraditionalForm\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(TraditionalForm\`\(\(tan\^\(-1\)\)(\(2\ x - 1\)\/\@3)\)\/\@3 + 
      1\/3\ \(log(x + 1)\) - 1\/6\ \(log(x\^2 - x + 1)\)\)], "Output",
  CellLabel->"Out[7]//TraditionalForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "Here are a few transformations made by ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.14"}],

Cell[CellGroupData[{

Cell["\<\
{Abs[x], ArcTan[x], BesselJ[0, x], Binomial[i, j]} // \
TraditionalForm\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        RowBox[{\(\[LeftBracketingBar]x\[RightBracketingBar]\), 
          ",", \(\(tan\^\(-1\)\)(x)\), ",", \(\(J\_0\)(x)\), ",", 
          TagBox[
            RowBox[{"(", GridBox[{
                  {
                    TagBox["i",
                      Identity,
                      Editable->True]},
                  {
                    TagBox["j",
                      Identity,
                      Editable->True]}
                  }], ")"}],
            InterpretTemplate[ Binomial[ #, #2]&],
            Editable->False]}], "}"}], TraditionalForm]], "Output",
  CellLabel->"Out[8]//TraditionalForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " is often useful for generating output that can be inserted directly into \
documents which use traditional mathematical notation. But you should \
understand that ",
  StyleBox["TraditionalForm", "MR"],
  " is intended primarily for output: it does not have the kind of precision \
that is needed to provide reliable input to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.10.9", "9.15"}],

Cell[TextData[{
  "Thus, for example, in ",
  StyleBox["TraditionalForm", "MR"],
  ", ",
  StyleBox["Ci(", "MR"],
  StyleBox["x", "TI"],
  StyleBox[")", "MR"],
  " is the representation for both ",
  StyleBox["Ci[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["CosIntegral[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", so if this form appears on its own as input, ",
  StyleBox["Mathematica", "TI"],
  " will have no idea which of the two interpretations is the correct one.    \
"
}], "Text",
  CellTags->{"S1.10.9", "9.16"}],

Cell[TextData[{
  "In ",
  StyleBox["StandardForm", "MR"],
  ", these three expressions are all displayed in a unique and unambiguous \
way. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.17"}],

Cell[CellGroupData[{

Cell["{ Ci[1+x], CosIntegral[1+x], Ci(1+x) } // StandardForm", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \({Ci[1 + x], CosIntegral[1 + x], Ci\ \((1 + x)\)}\)], "Output",
  CellLabel->"Out[9]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["TraditionalForm", "MR"],
  ", however, the first two are impossible to distinguish, and the third \
differs only in the presence of an extra space. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.18"}],

Cell[CellGroupData[{

Cell["{ Ci[1+x], CosIntegral[1+x], Ci(1+x) } // TraditionalForm", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(TraditionalForm\`{Ci(x + 1), Ci(x + 1), Ci\ \((x + 1)\)}\)], "Output",
  CellLabel->"Out[10]//TraditionalForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "The ambiguities of ",
  StyleBox["TraditionalForm", "MR"],
  " make it in general unsuitable for specifying input to the ",
  StyleBox["Mathematica", "TI"],
  " kernel. But at least for sufficiently simple cases, ",
  StyleBox["Mathematica", "TI"],
  " does include various heuristic rules for trying to interpret ",
  StyleBox["TraditionalForm", "MR"],
  " expressions as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "Text",
  CellTags->{"S1.10.9", "9.19"}],

Cell[TextData[{
  "Cells intended for input to the kernel are assumed by default to contain \
",
  StyleBox["StandardForm", "MR"],
  " expressions. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.20"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000K2000`400?l00000o`00003o0P3ooooo
03<c<ol0<c<c2@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`0c<c?o03<c<`P0<c<c0@3oool00003
0?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GUi@40iNGU0`2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooojP3oool50000o`80oooo1@000?l70?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
onh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonh0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<l0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool0o`3oooml0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool00`00
0000oooo0?ooo`030?ooo`8000000`3oool2000002P0oooo00<000000?ooo`3oool0o`3ooomk0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`000000:@3oool00`000000oooo0?ooo`3o0?ooog/0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`000000:P3oool00`000000oooo0?ooo`3o0?ooog/0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<j0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0:P3oool0
0`000000oooo0?ooo`3o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`000000:`3oool00`000000oooo0?ooo`3o
0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?ooo`030000003oool0
oooo00@0oooo0`000000103oool0000000000000000Y0?ooo`030000003oool0oooo0?l0ooooNP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cX0oooo00<000000?ooo`3oool0=03o
ool00`000000oooo0?ooo`3o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<j0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0o`3ooomj0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c5`3oool20000o`H0oooo0P000?lI0?ooo`030000003o
ool0oooo03@0oooo00<000000?ooo`3oool0o`3ooomj0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c5`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo01L0oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0?l0ooooNP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0oooo0P000?l40?ooo`030000o`3o
ool0003o0080oooo00<0003o0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o00h0oooo
0`0000080?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0103oool2000000<0oooo
0P0000060?ooo`030000003oool0oooo00h0oooo0P0000030?ooo`8000000`3oool300000?l0oooo
G`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`T0oooo00@0003o0?ooo`3oool0
003o0P3oool01P000?l0oooo0000o`000?l0oooo0000o`80oooo00<0003o0?ooo`3oool00P3oool0
1P000?l0oooo0?ooo`3oool0003o0?ooo`@0003o203oool01@000000oooo0?ooo`3oool0000000L0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`070?ooo`8000001`3oool01@000000
oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?oo
o`050000003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`3o0?oooeh0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<80?ooo`030000o`3oool0oooo0080oooo00<0003o
0?ooo`000?l00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00D0003o
0?ooo`3oool0oooo0000o`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0000000L0oooo00<000000?ooo`000000203o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000001P3o
ool00`000000oooo0?ooo`3o0?oooeh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<80?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000
o`020?ooo`030000o`3oool0oooo0080oooo00H0003o0?ooo`3oool0oooo0000o`3oool40000o`P0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`X000001P3oool5000000H0
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00D0oooo1@0000070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooomN0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool00`000?l0oooo0?ooo`020?oo
o`030000o`3oool0003o0080oooo00H0003o0?ooo`000?l0003o0?ooo`000?l40?ooo`050000o`3o
ool0oooo0?ooo`000?l03@3oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`040?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool01@3oool00`000000oooo000000080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo000000060?ooo`030000003oool0oooo0?l0ooooGP3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`T0oooo00@0003o0?ooo`3oool0003o1`3oool01000
0?l0oooo0?ooo`000?l30?ooo`80003o0`3oool00`000?l0oooo0?ooo`0<0?ooo`<00000203oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`<0000000@0oooo00000000000000001P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00@0oooo0`000000103oool000000000000000040?ooo`050000
003oool0oooo0?ooo`000000o`3ooomL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c2P3oool20000o`/0oooo0P000?l30?ooo`030000o`3oool0oooo0080003o6@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06@3oool01@000000
oooo0?ooo`3oool000000?l0ooooG03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<cX0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01P0oooo1P00003o0?oooe`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3o0?oo
ogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<j0?ooo`030000003oool0oooo
00D0oooo1@00000I0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0o`3ooomj0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`3o0?oo
ogL0oooo10000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cX0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0I0?ooo``000001@3oool00`000000oooo0?ooo`3o0?ooogX0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`030000003oool0oooo00H0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`3o0?ooogX0oooo0P000?l60?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<c/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
0?l0ooooN@3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0?l0ooooN03oool01000
0?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c`0oooo00<000000?ooo`3oool00`3oool3
000002X0oooo00<000000?ooo`3oool0o`3ooomh0?ooo`050000o`3oool0oooo0?ooo`000?l01P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=40?ooo`030000003oool0oooo0?l0ooooXP3oool60000o`H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
oooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooojP3oool50000o`H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo^0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cI@3oool600000?l0ooooP`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<fH0oooo1000003o0?oooh@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=W0?ooo`800000o`3ooon50?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c=`3oool2000002h0oooo0P0000080?ooo`800000o`3ooomk0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool2000002h0oooo100000080?ooo`800000o`3o
oomj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool2000002d0oooo1P00
00070?ooo`800000o`3ooomj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3o
ool2000003X0oooo0P00003o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<e0?ooo`800000?03oool200000?l0ooooN@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<cD0oooo0P00000l0?ooo`800000o`3ooomi0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c503oool20000o`H0oooo0P000?lG0?ooo`8000002P3oool00`000000oooo0?oo
o`0_0?ooo`8000006`3oool2000000X0oooo0P00003o0?oooe00oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<D0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool05@3o
ool2000000X0oooo00<000000?ooo`3oool0;`3oool2000001X0oooo0P00000<0?ooo`800000o`3o
oom?0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3@3oool00`000?l0oooo0000
o`020?ooo`030000o`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`030000
o`3oool0oooo00X0oooo100000040?ooo`8000002@3oool2000000L0oooo1P00000:0?ooo`030000
003oool0oooo01L0oooo0P0000080?ooo`030000003oool0oooo00D0oooo100000060?ooo`800000
0`3oool6000000<0oooo0P00003o0?ooodl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<=0?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l0103oool01@000?l0oooo
0?ooo`3oool0003o00@0oooo10000?l60?ooo`8000000P3oool2000000<0oooo0P0000090?ooo`80
0000203oool4000000/0oooo00<000000?ooo`3oool05`3oool2000000P0oooo00<000000?ooo`3o
ool01P3oool2000000H0oooo0P0000050?ooo`@000001@3oool200000?l0ooooCP3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00<0003o0?ooo`000?l00P3oool00`000?l0
oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l03P3oool2000000L0oooo0P0000080?oo
o`040000003oool0oooo000000P0oooo0P00000:0?ooo`D000001P3oool;000000H0oooo0P000006
0?ooo`D000001P3oool2000000H0oooo0P0000060?ooo`8000001P3oool200000?l0ooooCP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`d0oooo00P0003o0?ooo`000?l0003o0?oo
o`000?l0oooo0000o`@0oooo00D0003o0?ooo`3oool0oooo0000o`040?ooo`@0003o1P3oool20000
00L0oooo0P0000080?ooo`040000003oool0oooo000000P0oooo0P00000<0?ooo`030000003oool0
oooo01L0oooo0P0000080?ooo`030000003oool0oooo00H0oooo0P0000060?ooo`8000001P3oool2
000000H0oooo0P00003o0?ooodh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<=
0?ooo`050000o`3oool0003o0?ooo`000?l00P3oool00`000?l0oooo0?ooo`020?ooo`050000o`3o
ool0oooo0?ooo`000?l00P3oool00`000?l0oooo0?ooo`090?ooo`8000000P3oool2000000<0oooo
0P0000040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01@3oool4000000/0
oooo00<000000?ooo`3oool05`3oool2000000P0oooo00<000000?ooo`3oool01P3oool2000000H0
oooo0P0000050?ooo`@000001@3oool200000?l0ooooCP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<`d0oooo00<0003o0?ooo`3oool0103oool010000?l0oooo0?ooo`3oool20000
o`<0oooo00<0003o0?ooo`3oool03@3oool4000000@0oooo0P0000050?ooo`<000000`3oool00`00
0000oooo0?ooo`040?ooo`H00000903oool200000140oooo0P0000020?ooo`8000000`3oool20000
00<0oooo1P0000030?ooo`800000o`3ooom?0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c3@3oool00`000?l0oooo0?ooo`040?ooo`80003o0`3oool00`000?l0oooo0?ooo`020000
oaL0oooo0P0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0;@3oool20000
0140oooo0P0000020?ooo`8000000`3oool2000000`0oooo0P00003o0?ooodl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<e0?ooo`800000303oool00`000000oooo0?ooo`0]0?oo
o`800000403oool7000000@0oooo0P00000:0?ooo`800000o`3ooom@0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c=@3oool2000000`0oooo00<000000?ooo`3oool07`3oool60000
00P0oooo0P00003o0?ooogT0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?oo
o`800000303oool00`000000oooo0?ooo`0P0?ooo`8000002@3oool200000?l0ooooNP3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo0P00000<0?ooo`030000003oool0oooo
0200oooo0P0000090?ooo`800000o`3ooomj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c=P3oool2000000`0oooo3@00000F0?ooo`8000002@3oool200000?l0ooooN@3oool20000
o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c=`3oool2000002h0oooo0P0000080?ooo`800000o`3ooomi0?oo
o`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cI@3oool400000?l0ooooPP3oool01000
0?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fH0oooo0`00003o0?oooh40oooo00D0003o
0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fL0oooo0P00003o0?oooh00oooo1P00
0?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c
<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c
<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2I
VIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0iNGU0?l0
iNGUo`3UiND70>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40oooo
0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 108},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.9"],

Cell[TextData[{
  "Here the front end was specifically told that input would be given in ",
  StyleBox["TraditionalForm", "MR"],
  ". The cell bracket has a jagged line to indicate the difficulties \
involved."
}], "MathCaption",
  CellTags->{"S1.10.9", "9.21"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000IR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool00080ooooo`0c<c?o03<c<`T0<c<c0@3oool000030?oo
o`3UiND0iNGU0?l0<c<co`0c<c<803<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0
iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooZ0?ooo`D0003o
0P3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d80oooo
0P0000030?ooo`800000o`3ooonU0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
@`3oool01@000000oooo0?ooo`3oool000000?l0ooooYP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<d@0oooo00<000000?ooo`000000o`3ooonW0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c>`3oool2000000P0oooo00<000000?ooo`3oool0:@3oool200000?l0
ooooN`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0000000[0?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?ooo`3oool0103oool300000004
0?ooo`0000000000000002T0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c>`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo
0?l0ooooN@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?oo
o`3oool0=03oool00`000000oooo0?ooo`3o0?ooogT0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<J0?ooo`80003o1P3oool20000oaL0oooo00<000000?ooo`3oool0=03oool00`00
0000oooo0?ooo`0d0?ooo`8000002`3oool200000?l0oooo=P3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<aX0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0E0?oo
o`030000003oool0oooo0200oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0d0?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooold0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<c3@3oool20000o`@0oooo00<0003o0?ooo`000?l00P3oool00`00
0?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l03`3oool3000000D0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`040?ooo`8000000`3oool2000000H0oooo00<00000
0?ooo`3oool0403oool3000000@0oooo0`0000001`3oool00000000000000000oooo0000003oool0
100000000`3oool000000?ooo`0200000080oooo0`0000000`3oool000000?ooo`020?ooo`040000
003oool0oooo0?ooo`8000000`3oool2000000<0oooo00<000000?ooo`3oool0o`3ooold0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool010000?l0oooo0?ooo`000?l20?oo
o`060000o`3oool0003o0000o`3oool0003o0P3oool00`000?l0oooo0?ooo`020?ooo`060000o`3o
ool0oooo0?ooo`000?l0oooo10000?l90?ooo`050000003oool0oooo0?ooo`000000103oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo00L0oooo0P0000070?ooo`050000003oool0oooo
0?ooo`0000001`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0000003oool000000080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`3o0?oooc@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<;0?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000
o`020?ooo`030000o`3oool0oooo0080oooo00D0003o0?ooo`3oool0oooo0000o`0>0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0000000L0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`000000oooo0000
00020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool0o`3ooold0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c2`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080oooo
00<0003o0?ooo`000?l00P3oool00`000?l0oooo0?ooo`020?ooo`060000o`3oool0oooo0?ooo`00
0?l0oooo10000?l90?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00`3oool:0000
00H0oooo1@0000060?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`050?ooo`D000001@3oool00`000000oooo0?ooo`02000000<0oooo10000002
0?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo0000003oool0000000<0oooo
100000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`3o0?oooc@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`030000
o`3oool0oooo0080oooo00<0003o0?ooo`000?l00P3oool01P000?l0oooo0000o`000?l0oooo0000
o`@0oooo00D0003o0?ooo`3oool0oooo0000o`0>0?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000P3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00P000000?ooo`3oool00000
0?ooo`000000oooo00000080oooo00D000000?ooo`000000oooo000000060?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0
oooo0?l0oooo=03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo00@0003o
0?ooo`3oool0003o1`3oool010000?l0oooo0?ooo`000?l30?ooo`80003o0`3oool00`000?l0oooo
0?ooo`0=0?ooo`<000001@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`<0000000@0oooo000000000000
00001P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`@000000P3oool3000000040?ooo`000000oooo0?ooo`<0000000<0oooo
0000003oool00P3oool4000000D0oooo00@000000?ooo`3oool0oooo0`000000103oool000000000
000000030?ooo`030000003oool0oooo0?l0oooo=03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`d0oooo0P000?l;0?ooo`80003o0`3oool00`000?l0oooo0?ooo`020000oaL0oooo
00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo
00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0o`3ooold0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0403oool300000240
oooo0P00000;0?ooo`800000o`3ooolf0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0o`3ooomi0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool00`000000
oooo0?ooo`050?ooo`D000006@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0?l0
ooooN@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool0o`3ooomi0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01T0oooo300000050?ooo`030000003oool0oooo0?l0
ooooMP3oool40000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>`3oool2000000P0oooo00<000000?ooo`3o
ool0:@3oool200000?l0ooooN`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dD0
oooo00<000000?ooo`3oool0o`3ooonU0?ooo`80003o1P3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=50?ooo`03
0000003oool0oooo0?l0ooooY03oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d<0
oooo0`00003o0?ooojD0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=50?oo
o`030000003oool0oooo0?l0ooooXP3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooooY0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooZ
0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon/0oooo00@0003o0?ooo`3oool0003o1P3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c=N0?ooo`80000000<0oooo000000000000o`3ooon90?ooo`030000o`3o
ool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cGP3oool2000000040?ooo`000000000000000?l0oooo
Q`3oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cL0oooo00<000000?ooo`3o
ool09P3oool2000000D0oooo00<000000?ooo`3oool0o`3ooon00?ooo`050000o`3oool0oooo0?oo
o`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<f0?ooo`030000003oool0oooo02L0oooo0P0000060?oo
o`030000003oool0oooo0?l0ooooP03oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<cD0oooo0P00000Y0?ooo`@00000103oool200000?l0ooooPP3oool00`000?l0oooo0000o`06
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cD0oooo00<000000?ooo`3oool09`3oool3000000030?ooo`000000
oooo00@0oooo00<000000?ooo`3oool0o`3ooomo0?ooo`040000o`3oool0oooo0000o`H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c=03oool2000003<0oooo0P00003o0?ooogl0oooo00D0003o0?ooo`3oool0oooo
0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<aL0oooo0P000?l60?ooo`80003o4`3oool2000003<0oooo
0P00000G0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooomO0?ooo`040000
o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5`3oool00`000?l0oooo0?ooo`060?ooo`03
0000o`3oool0oooo0140oooo0P0000080?ooo`030000003oool0oooo02P0oooo0P00000F0?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3ooomO0?ooo`030000o`3oool0003o00H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c403oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0
oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`030000o`3oool0oooo00T0oooo0P0000030?oo
o`800000203oool00`000000oooo0?ooo`040?ooo`80000000<0oooo0000000000002@3oool00`00
0000oooo0?ooo`0C0?ooo`8000001@3oool00`000000oooo0?ooo`050?ooo`@00000103oool20000
00040?ooo`00000000000?ooo`8000000P3oool200000?l0ooooG`3oool010000?l0oooo0?ooo`00
0?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000
o`040?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000o`D0oooo0P000000103oool00000
0?ooo`3oool2000000L0oooo0P0000060?ooo`80000000@0oooo0000000000000000203oool00`00
0000oooo0?ooo`0C0?ooo`8000001@3oool00`000000oooo0?ooo`060?ooo`8000001@3oool20000
00040?ooo`00000000000?ooo`<0000000<0oooo000000000000o`3ooomN0?ooo`050000o`3oool0
oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`030000o`3oool0003o0080oooo00<0
003o0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o00d0oooo0P0000040?ooo`800000
1`3oool2000000P0oooo0P00000:0?ooo`030000003oool0oooo01<0oooo0P0000050?ooo`030000
003oool0oooo00H0oooo0P0000050?ooo`8000000`3oool2000000<0oooo0P00003o0?oooel0oooo
00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<@0?ooo`080000o`3oool0003o0000
o`3oool0003o0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000o`D0oooo
0P0000040?ooo`8000001P3oool2000000030?ooo`000000oooo00H0oooo0P0000070?ooo`L00000
1@3oool8000000D0oooo0P0000020?ooo`L000001@3oool2000000D0oooo0P0000030?ooo`800000
0`3oool200000?l0ooooH03oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a00oooo
00D0003o0?ooo`000?l0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00D0003o0?ooo`3o
ool0oooo0000o`020?ooo`030000o`3oool0oooo00T0oooo00D000000?ooo`00000000000?ooo`02
000000H0oooo0P0000000`3oool000000?ooo`060?ooo`@00000203oool00`000000oooo0?ooo`0C
0?ooo`8000001@3oool00`000000oooo0?ooo`060?ooo`8000001@3oool2000000<0oooo10000000
0`3oool000000000003o0?oooel0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<@0?ooo`030000o`3oool0oooo00@0oooo00@0003o0?ooo`3oool0oooo0P000?l30?ooo`030000
o`3oool0oooo00d0oooo0`0000000`3oool00000000000050?ooo`8000000P3oool00`000000oooo
0?ooo`040?ooo`<0000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`0C0?ooo`800000
1@3oool00`000000oooo0?ooo`060?ooo`8000001@3oool200000080oooo0`0000000`3oool00000
0?ooo`0200000?l0ooooGP3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c403oool00`000?l0oooo0?ooo`040?ooo`80003o0`3oool00`000?l0oooo0?ooo`020000oa<0
oooo0P0000020?ooo`D000000`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01<0
oooo0P0000050?ooo`030000003oool0oooo00H0oooo0P0000030?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool0o`3ooomN0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c=03oool2000000@0oooo0P0000040?ooo`030000003oool0oooo02H0oooo0P00000=
0?ooo`L000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooH03oool0
0`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c@0oooo0P00000:0?ooo`030000003oool0
oooo02H0oooo0P00003o0?oooh00oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<e0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`3o0?ooogh0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo
0P00000:0?ooo`030000003oool0oooo01/0oooo100000050?ooo`800000o`3ooon10?ooo`040000
o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=P3oool00`000000oooo0?ooo`080?ooo`/0
0000503oool2000000H0oooo00<000000?ooo`3oool0o`3ooon10?ooo`030000o`3oool0003o00H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=`3oool00`000000oooo0?ooo`0V0?ooo`8000001@3oool00`000000
oooo0?ooo`3o0?oooh40oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=P0?oo
o`800000o`3ooon80?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=P
0?ooo`800000o`3ooon90?ooo`040000o`3oool0003o0000o`H0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cH03o
ool200000?l0ooooRP3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f00oooo0P00
003o0?ooohT0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=O0?ooo`<00000
o`3ooon80?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooonT0
oooo1P000?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@40iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001
\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 102},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.9"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] The input is a copy or simple edit \
of previous output. \
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] The input has been converted from ",
              StyleBox["StandardForm", "MR"],
              ", perhaps with simple edits. "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] The input contains explicit hidden \
information giving its interpretation. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] The input contains only the \
simplest and most familiar notations. \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.9"],

Cell[TextData[{
  "Some situations in which ",
  StyleBox["TraditionalForm", "MR"],
  " input can be expected to work. "
}], "Caption",
  CellTags->"S1.10.9"],

Cell[TextData[{
  "Whenever ",
  StyleBox["Mathematica", "TI"],
  " generates an expression in ",
  StyleBox["TraditionalForm", "MR"],
  ", it automatically inserts various hidden tags so that the expression can \
later be interpreted unambiguously if it is given as input. And even if you \
edit the expression, the tags will often be left sufficiently undisturbed \
that unambiguous interpretation will still be possible.   "
}], "Text",
  CellTags->{"S1.10.9", "9.22"}],

Cell[TextData[{
  "This generates output in ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.23"}],

Cell[CellGroupData[{

Cell["Exp[I Pi x] // TraditionalForm", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\[ImaginaryI]\ \[Pi]\ x\)\)], \
"Output",
  CellLabel->"Out[11]//TraditionalForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " was told to expect ",
  StyleBox["TraditionalForm", "MR"],
  " input here. The input was copied from the previous output line, and thus \
contains hidden tags that ensure the correct interpretation. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.24"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(\[ImaginaryI]  \[Pi]  x\) // 
      StandardForm\)], "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(\[ExponentialE]\^\(\[ImaginaryI]\ \[Pi]\ x\)\)], "Output",
  CellLabel->"Out[12]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell["Simple editing often does not disturb the hidden tags. ", "MathCaption",
  CellTags->{"S1.10.9", "9.25"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\[ExponentialE]\^\(2  \[ImaginaryI]  \[Pi]  x\) // 
      StandardForm\)], "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ x\)\)], "Output",
  CellLabel->"Out[13]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "If you enter a ",
  StyleBox["TraditionalForm", "MR"],
  " expression from scratch, or import it from outside ",
  StyleBox["Mathematica", "TI"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " will still do its best to guess what the expression means. When there are \
ambiguities, what it typically does is to assume that you are using notation \
in whatever way is more common in elementary mathematical applications. "
}], "Text",
  CellTags->{"S1.10.9", "9.26"}],

Cell[TextData[{
  "In ",
  StyleBox["TraditionalForm", "MR"],
  " input, this is interpreted as a derivative. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.27"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\(\[PartialD]y \((x)\)\)\/\[PartialD]x // 
      StandardForm\)], "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}]], "Output",
  CellLabel->"Out[14]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell["This is interpreted as an arc tangent. ", "MathCaption",
  CellTags->{"S1.10.9", "9.28"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\(tan\^\(-1\)\)(x) // StandardForm\)], "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(ArcTan[x]\)], "Output",
  CellLabel->"Out[15]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell["This is interpreted as the square of a tangent. ", "MathCaption",
  CellTags->{"S1.10.9", "9.29"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\(tan\^2\)(x) // StandardForm\)], "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(Tan[x]\^2\)], "Output",
  CellLabel->"Out[16]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "There is no particularly standard traditional interpretation for this; ",
  StyleBox["Mathematica", "TI"],
  " assumes that it is ",
  StyleBox["1/Tan[x]^2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.30"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\(tan\^\(-2\)\)(x) // StandardForm\)], "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(Cot[x]\^2\)], "Output",
  CellLabel->"Out[17]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "You should realize that ",
  StyleBox["TraditionalForm", "MR"],
  " does not provide any kind of precise or complete way of specifying ",
  StyleBox["Mathematica", "TI"],
  " expressions. Nevertheless, for some elementary purposes it may be \
sufficient, particularly if you use a few additional tricks. "
}], "Text",
  CellTags->{"S1.10.9", "9.31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Use ",
              StyleBox["x", "TI"],
              StyleBox["(", "MR"],
              StyleBox["y", "TI"],
              StyleBox[")", "MR"],
              " for functions; ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["y", "TI"],
              StyleBox[")", "MR"],
              " for multiplication "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use \[AliasIndicator]",
              StyleBox["ee\[AliasIndicator]", "MR"],
              " for the exponential constant ",
              StyleBox["E", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use \[AliasIndicator]",
              StyleBox["ii\[AliasIndicator]", "MR"],
              " or \[AliasIndicator]",
              StyleBox["jj\[AliasIndicator]", "MR"],
              " for the imaginary unit ",
              StyleBox["I", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use \[AliasIndicator]",
              StyleBox["dd\[AliasIndicator]", "MR"],
              " for differential operators in integrals and derivatives "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.9"],

Cell[TextData[{
  "A few tricks for ",
  StyleBox["TraditionalForm", "MR"],
  " input. "
}], "Caption",
  CellTags->"S1.10.9"],

Cell[TextData[{
  "With a space ",
  StyleBox["f", "MR"],
  " ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x)", "MR"],
  " is interpreted as multiplication. Without a space, ",
  StyleBox["g(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x)", "MR"],
  " is interpreted as a function. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.32"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`f\ \((1 + x)\) + g(1 + x) // StandardForm\)], "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \(f\ \((1 + x)\) + g[1 + x]\)], "Output",
  CellLabel->"Out[18]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]],

Cell[TextData[{
  "The ordinary ",
  StyleBox["e", "MR"],
  " is interpreted as a symbol ",
  StyleBox["e", "MR"],
  ". The special \[OpenCurlyDoubleQuote]exponential \
e\[CloseCurlyDoubleQuote], entered as \[AliasIndicator]",
  StyleBox["ee\[AliasIndicator]", "MR"],
  ", is interpreted as the exponential constant. "
}], "MathCaption",
  CellTags->{"S1.10.9", "9.33"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`{e\^3.7, \[ExponentialE]\^3.7} // 
      StandardForm\)], "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S1.10.9"],

Cell[BoxData[
    \({e\^3.7`, 40.4473043600674`}\)], "Output",
  CellLabel->"Out[19]//StandardForm= ",
  CellTags->"S1.10.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.10 Mixing Text and Formulas", "Subsection",
  CellTags->{"S1.10.10", "10.1"}],

Cell[TextData[{
  "The simplest way to mix text and formulas in a ",
  StyleBox["Mathematica", "TI"],
  " notebook is to put each kind of material in a separate cell. Sometimes, \
however, you may want to embed a formula within a cell of text, or vice \
versa.   "
}], "Text",
  CellTags->{"S1.10.10", "10.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox["(\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["9\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
begin entering a formula within text, or text within a \
formula \
\>"]},
          {Cell[TextData[{
              "\[ControlKey]\[LeftModified]",
              StyleBox[")\[RightModified]", "MR"],
              "  or  \[ControlKey]\[LeftModified]",
              StyleBox["0\[RightModified]", "MR"],
              " "
            }]], 
            Cell["\<\
end entering a formula within text, or text within a \
formula \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.10"],

Cell["Entering a formula within text, or vice versa. ", "Caption",
  CellTags->"S1.10.10"],

Cell["Here is a notebook with formulas embedded in a text cell.", \
"MathCaption",
  CellTags->{"S1.10.10", "10.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000PB000`400?l00000o`00003o00<0oooo
03<c<`0c<c<0o`0c<c?o03<c<`T0<c<c00020>GUiOl0<c<co`0c<c<:03<c<`0000<0iNGU09VIV@2I
VIT0o`2IVIWo09VIV@L0VIVI0P0c<c<000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c
00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1`2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVIo`3U
iNGo0>GUi@80iNGU102IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=a0?ooo`030000003o
ool0oooo0?l0ooooOP3oool50000o`L0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=`0?ooo`800000o`3ooon40?ooo`030000o`3oool0oooo00D0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=`0?ooo`800000o`3o
oon40?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=_0?ooo`<00000o`3ooon40?ooo`030000o`3oool0oooo00D0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=^0?ooo`@000001P3o
ool200000?l0ooooO03oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c
<c<000040>GUi@2IVIT0VIVI09VIV@80<c<cK03oool400000080oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`00003o0?ooog/0oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<fh0oooo00D000000?ooo`3oool0
oooo000000070?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?ooo`050?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c;P3oool200000480
oooo00<000000?ooo`3oool00`3oool2000003T0oooo0P00003o0?oood40oooo00<0003o0?ooo`3o
ool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<bd0
oooo00@000000?ooo`3oool00000@@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
03D0oooo00@000000?ooo`3oool00000o`3ooom00?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<]0?ooo`040000003oool0
oooo00000440oooo00<000000?ooo`3oool00P3oool3000003/0oooo00<000000?ooo`3oool0o`3o
ooln0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<]0?ooo`<00000@P3oool00`000000oooo0?ooo`0n0?ooo`800000o`3o
oom10?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<^0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0?`3o
ool00`000000oooo0?ooo`3o0?oooch0oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VI
V@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<bl0oooo0P0000120?ooo`030000003o
ool0oooo03`0oooo0`00003o0?oood40oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VI
V@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<g<0oooo00<000000?ooo`3oool0o`3o
oon00?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=c0?ooo`T000007P3oool00`000000oooo0?ooo`0]0?ooo`030000003o
ool0oooo00@0oooo0`0000020?ooo`<0000000@0oooo000000000000oooo0P0000050?ooo`<00000
0P3oool300000080oooo0`0000001@3oool00000000000000000oooo0080000000<0oooo00000000
00000`3oool2000000030?ooo`00000000000080000000@0oooo000000000000oooo100000050?oo
o`<0000000D0oooo00000000000000000?ooo`03000000D0oooo00<000000?ooo`0000002@3oool0
0`000000oooo000000030?ooo`<0000000<0oooo0000003oool00`0000000`3oool0000000000004
0?ooo`030000003oool000000080000000@0oooo000000000000oooo0P0000060?ooo`030000003o
ool0oooo008000000P3oool2000000030?ooo`00000000000080oooo00@000000?ooo`3oool00000
SP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2I
VIT0VIVI09VIV@80<c<cVP3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0080oooo
00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0oooo0000003oool000000P3oool0
0`000000oooo000000020?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000
003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000090?ooo`030000
003oool0000000@0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo
00<000000?ooo`3oool0T03oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI
0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<cVP3oool00`000000oooo0?ooo`0e0?ooo`030000
003oool0oooo0080oooo00H000000?ooo`3oool000000?ooo`0000080?ooo`040000003oool0oooo
000000<0oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@00000
0?ooo`3oool0oooo0P0000050?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`09
0000003oool0oooo0?ooo`000000oooo0000003oool0000000L0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool00000103oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`0000001`3oool010000000oooo0?ooo`000006
0?ooo`050000003oool0oooo0?ooo`000000TP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c3P3oool700000080oooo<000
00060?ooo`L00000103oooli000000H0oooo1`0000050?ooob<00000303oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0000003oool0100000050?ooo`040000003oool0oooo000000<0
oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`<0000000<0oooo000000000000
1`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool02@000000oooo0?ooo`3oool0
00000?ooo`000000oooo000000070?ooo`050000003oool000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0000000<00000103oool00`000000oooo0?ooo`04000000<0oooo00D00000
0?ooo`3oool0oooo0000002B0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2I
VIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>J0?ooo`030000003oool0oooo03D0oooo00<0
00000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo008000000P3oool01000
0000oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?oo
o`000000oooo00000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`060000003oool0oooo0000003oool00000
0`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000<0oooo00H000000?ooo`3oool0
00000?ooo`0000030?ooo`040000003oool0oooo000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`2@0?oo
o`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<V0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo00l0oooo0`00000S0?ooo`030000003oool0oooo
0080oooo0`0000030?ooo`8000001@3oool300000080oooo0`0000020?ooo`030000003oool00000
0080000000@0oooo000000000000oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool0
0`000000oooo0?ooo`02000000<0oooo0`0000040?ooo`<000000P3oool00`000000oooo0?ooo`03
00000080oooo0P000000103oool000000000003oool3000000<0oooo0P000000103oool000000000
003oool800000080oooo0`0000040?ooo`<000000P3oool3000000<0oooo0P0000040?ooo`<00000
0P3oool200000080oooo0P0000000`3oool000000000000300000940oooo00<0003o0?ooo`3oool0
1@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<b00oooo
0`0000020?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0=03oool2000001d0oooo
00<000000?ooo`3oool03P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00d0oooo00D000000?ooo`3o
ool0oooo0000000O0?ooo`050000003oool0oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3o
ool0000000`0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`2@0?ooo`030000o`3o
ool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<O0?ooo`070000003oool0oooo0?ooo`000000oooo0000000N0?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool01@3oool200000100oooo00<000000?ooo`3oool0503oool300000004
0?ooo`00000000000?ooo`@000000P3oool00`000000oooo000000020?ooo`030000003oool0oooo
00D0oooo0`0000020?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0000000=0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool03@3oool0
1@000000oooo0?ooo`3oool0000002<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`2[0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<H0?ooo`<0000000@0oooo000000000000oooo100000020?ooo`030000
003oool000000080oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo000000<0oooo0`0000000`3oool000000?ooo`0/0?ooo`030000003oool0oooo
00D0oooo0`00000A0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000000P3oool01000
0000oooo0000000000030?ooo`030000003oool0oooo008000002@3oool01@000000oooo0?ooo`3o
ool0000000/0oooo2@00000>0?ooo`8000006P3oool200000100oooo1000000M0?ooo`030000003o
ool0oooo0080oooo0P00000:0?ooo`800000[@3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c6@3oool00`000000oooo0000
00020?ooo`040000003oool00000000000<0oooo00<000000?ooo`3oool00P0000090?ooo`040000
003oool0oooo0?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0000
02d0oooo00<000000?ooo`3oool0103oool4000000H0oooo0P0000090?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`0000000P3oool200000080oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`04000000<0oooo00D000000?ooo`3oool0oooo0000003o0?oooc80oooo00<0
003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2I
VIT203<c<aT0oooo00<000000?ooo`0000000P3oool200000080oooo00@000000?ooo`3oool00000
0`3oool00`000000oooo0?ooo`050?ooo`D000000P3oool00`000000oooo0000000400000080oooo
00@000000?ooo`3oool00000;03oool00`000000oooo0?ooo`030?ooo`@000000P3oool00`000000
oooo0?ooo`020?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo000000020?ooo`8000000P3oool2000000070?ooo`000000oooo0?ooo`000000oooo0000
00080?ooo`050000003oool0oooo0?ooo`000000o`3ooolb0?ooo`030000o`3oool0oooo00D0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<I0?ooo`030000
003oool000000080oooo0P0000020?ooo`80000000L0oooo0000003oool0oooo0000003oool00000
00P0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`00000/0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0
oooo000000070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool04P3oool200000080
oooo0P0000020?ooo`8000000`3oool00`000000oooo0?ooo`0:0?ooo`8000000`3oool00`000000
oooo0?ooo`3o0?oooc00oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0000103UiND0VIVI09VIV@2IVIT203<c<aP0oooo0P0000020?ooo`8000000P3oool2000000<0
oooo00<000000?ooo`3oool00`3oool4000000@0oooo00<000000?ooo`3oool01P3oool010000000
oooo0?ooo`3oool200000080oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00<0oooo0P00000:0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`040000003oool0oooo00000?l0oooo<`3oool0
0`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI
09VIV@80<c<c6@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool04P3oool010000000oooo0?ooo`00000/0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0?l0ooooI03o
ool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0
VIVI09VIV@80<c<c9@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080oooo0`00
000:0?ooo`030000003oool0oooo0?l0ooooI03oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c9P3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3o
ool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<[0?ooo`040000003oool0oooo00000480oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0>0?ooo`030000003oool0oooo0?l0ooooI03oool00`000?l0oooo0?ooo`050?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c;03oool2000004<0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0?l0oooo
I03oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2I
VIT0VIVI09VIV@80<c<cL@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=a0?ooo`030000003oool0oooo00X0oooo
2@0000080?ooo`030000003oool0oooo0?l0ooooI03oool00`000?l0oooo0?ooo`050?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<cF`3oool2000000080?oo
o`00000000000000003oool000000?ooo`00000<0?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=K0?ooo`050000003oool000000?ooo`0000000P3o
ool00`000000oooo0000000<0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0o`3o
oomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=K0?ooo`030000003oool0oooo008000000P3oool00`000000oooo0000
000<0?ooo`030000003oool0oooo0080oooo5P0000030?ooo`030000003oool0oooo0?l0ooooI03o
ool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0
VIVI09VIV@80<c<cF`3oool01P000000oooo0?ooo`3oool000000?ooo`80000000<0oooo0000003o
ool02`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0?l0ooooI03oool00`000?l0
oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80
<c<cF`3oool4000000<0oooo0P0000080?ooo`<000000P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0?l0ooooI03oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<cF`3oool00`000000oooo0?ooo`0?0?ooo`05
0000003oool0oooo0?ooo`0000007@3oool00`000000oooo0?ooo`3o0?ooof@0oooo00<0003o0?oo
o`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c
<fH0oooo100000030?ooo`050000003oool0oooo0?ooo`0000001@3oool400000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`3oool3000000D0oooo00<000000?ooo`3oool0
o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c=]0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000
oooo0?ooo`030?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=/0?ooo`8000000`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000100000020?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=]0?ooo`05
0000003oool0oooo0?ooo`000000203oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3o
oomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=a0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`3oool2000000H0oooo00<000000?ooo`3oool0o`3ooomT0?ooo`03
0000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=a0?ooo`030000003oool0oooo00@0oooo0P00000>0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=a0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=a0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=a0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0o`3ooomT0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=b0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0o`3ooomU0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=b0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0o`3ooomU0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=c0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool0o`3ooomV0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooo503oool010000000oooo0?ooo`00000<0?ooo`<00000c`3oool00`000?l0oooo0?ooo`050?oo
o`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooolE0?oo
o`8000003P3oool00`000000oooo0?ooo`3>0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VI
V@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooaH0oooo00<000000?oo
o`3oool01@3oool4000000<0oooo00<000000?ooo`3oool0cP3oool00`000?l0oooo0?ooo`050?oo
o`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oool:0?oo
o`8000002@3oool010000000oooo0000003oool2000000X0oooo00<000000?ooo`3oool0cP3oool0
0`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oool:0?ooo`030000003oool0000000/0oooo00@000000?ooo`3oool00000203o
ool200000=00oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000
103UiND0VIVI09VIV@2IVIT203<c<e`0oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0cP3oool00`000?l0oooo0?oo
o`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<cG@3o
ool00`000000oooo0?ooo`2/0?ooo`030000003oool0oooo00T0oooo0P00003K0?ooo`030000o`3o
ool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<?0?ooo`<000000P3oool3000000030?ooo`000000000000H000001@3oool6000000H0oooo0P00
00000`3oool000000?ooo`030?ooo`030000003oool0oooo008000000P3oool2000000030?ooo`00
000000000080oooo00<000000?ooo`3oool00`3oool2000000<0oooo0P0000020?ooo`H0000000<0
oooo0000003oool0103oool3000000@0oooo0P000000103oool000000?ooo`0000040?ooo`<00000
00<0oooo0000003oool0103oool2000000<0oooo0P0000000`3oool0000000000002000000030?oo
o`000000000000@0oooo0P0000030?ooo`<000000P3oool3000000050?ooo`00000000000?ooo`00
00000P3oool2000000030?ooo`000000000000D0000000<0oooo0000000000000`3oool300000080
oooo0`0000020?ooo`<0000000D0oooo00000000000000000?ooo`02000000030?ooo`0000000000
00<0oooo0P0000000`3oool0000000000002000000040?ooo`00000000000?ooo`@000001@3oool3
000000@0oooo0P0000000`3oool000000?ooo`0200000080oooo0`0000000`3oool0000000000004
0?ooo`80000000<0oooo0000000000000P0000080?ooo`030000003oool0oooo00/0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0000000200000080oooo00<000000?ooo`3oool00P000005
0?ooo`<000000P3oool300000:l0oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT203<c<a00oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool000000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo000000020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
103oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3oool0
0`000000oooo0?ooo`030?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo
0?ooo`0000020?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`060000003oool0oooo0000003oool000001P3oool00`000000oooo000000050?ooo`060000003o
ool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo
0080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool0
00000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00H000000?oo
o`3oool000000?ooo`0000020?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool300000180oooo00L000000?ooo`000000oooo0000003oool000000080oooo00<000000?ooo`00
00001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0[P3oool00`00
0?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VI
V@80<c<c403oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool0oooo0P0000050?ooo`040000003oool0oooo0?ooo`800000103oool010000000oooo
0?ooo`0000040?ooo`040000003oool0oooo000000H0oooo00D000000?ooo`3oool0oooo00000005
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00070?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo0000
00H0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`060000003oool0oooo0000003oool00000
0P3oool010000000oooo0?ooo`3oool2000000H0oooo0P0000020?ooo`060000003oool0oooo0000
003oool000001@3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000000<0oooo
0P0000070?ooo`030000003oool0oooo01d0oooo00H000000?ooo`3oool000000?ooo`0000040?oo
o`8000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0[P3oool0
0`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI
09VIV@80<c<c403oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`00000000001`3oool010000000oooo0000000000070?ooo`<00000103oool00`000000
oooo0?ooo`04000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo
0080oooo100000020?ooo`040000003oool0oooo000000L0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`060000003oool0oooo0000003oool000001P3oool00`000000oooo000000050?ooo`03
0000003oool0oooo00<0oooo0`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00H000000?ooo`3oool000000?oo
o`0000030?ooo`<000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0
oooo00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0
oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080
oooo0`0000000`3oool00000000000060?ooo`800000103oool01P000000oooo0?ooo`000000oooo
000000D0oooo00@000000?ooo`3oool000001@3oool3000000030?ooo`000000000000T0oooo00<0
00000?ooo`3oool00P3ooolF000000D0oooo00H000000?ooo`3oool000000?ooo`0000040?ooo`03
0000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0:h0oooo00<0003o0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0
VIVI09VIV@2IVIT203<c<a00oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo00000002
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool010000000oooo0?oo
o`0000020?ooo`060000003oool0oooo0000003oool000000P3oool00`000000oooo0?ooo`030?oo
o`060000003oool0oooo0000003oool000000P3oool010000000oooo0?ooo`0000020?ooo`030000
003oool0oooo00D0oooo0P0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
00001P3oool00`000000oooo000000050?ooo`060000003oool0oooo0000003oool000000P3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00H000000?ooo`3oool00000
0?ooo`0000030?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo008000000P3oool010000000oooo
0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo0?ooo`000000
oooo00000080oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`040000003o
ool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00P3oool01P000000oooo0?ooo`000000oooo00000080oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0N0?ooo`050000003oool000000?ooo`00
0000103oool2000000D0oooo00D000000?ooo`3oool0oooo000000020?ooo`800000[`3oool00`00
0?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VI
V@80<c<c403oool00`000000oooo0?ooo`020?ooo`<000000P3oool200000080oooo0`0000040?oo
o`8000000P3oool3000000D0oooo0P0000040?ooo`<000000P3oool200000080oooo0P0000000`3o
ool0000000000003000000D0oooo0P0000030?ooo`8000000`3oool010000000oooo0?ooo`000007
0?ooo`040000003oool0000000000080oooo0P0000000`3oool0000000000003000000@0oooo1@00
00050?ooo`8000000`3oool200000080oooo00@000000?ooo`00000000001P3oool2000000<0oooo
0`0000020?ooo`050000003oool000000000003oool00`0000020?ooo`8000000P3oool200000003
0?ooo`000000oooo008000001@3oool300000080oooo0`0000020?ooo`030000003oool000000080
000000@0oooo000000000000oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool00`00
0000oooo0?ooo`02000000<0oooo0`0000050?ooo`<0000000@0oooo000000000000oooo0P000002
0?ooo`8000000`3oool3000000H0oooo0P0000030?ooo`<000001`3oool00`000000oooo0?ooo`0O
0?ooo`<0000000@0oooo0000003oool0oooo0P0000000`3oool000000?ooo`040?ooo`<000000P3o
ool010000000oooo00000000002^0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<@0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00h0oooo
00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0240
oooo00<000000?ooo`000000`P3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool000000440oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`1A
0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo00`0oooo0`00000A0?ooo`@00000`P3oool00`000?l0oooo0?ooo`05
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool9
000000D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0]0?ooo`80000000<0oooo
0000000000001P3oool200000180oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0:
0?ooo`8000006P3oool2000001h0oooo0P00000G0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0eP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oool>0?ooo`030000003oool0000000`0oooo00<00000
0?ooo`3oool0eP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oool?0?ooo`800000303oool00`000000oooo0?ooo`3F
0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?oooa`0oooo0P00003H0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooad0oooo00<00000
0?ooo`3oool0eP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo10000?l7
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof
0?ooo`030000o`3oool0oooo00D0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?oooo80oooo1@000?l70?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<0
00030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c00000`3UiND0VIVI09VIV@3o09VIVOl0
VIVI1`2IVIT203<c<`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@L0VIVI0P0c<c<000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT709VIV@80<c<c003o0>GUiOl0iNGU2`3UiND103<c<`00o`3ooooo0?oo
o``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 129},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.10"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " notebooks often contain both formulas that are intended for actual \
evaluation by ",
  StyleBox["Mathematica", "TI"],
  ", and ones that are intended just to be read in a more passive way. "
}], "Text",
  CellTags->{"S1.10.10", "10.4"}],

Cell[TextData[{
  "When you insert a formula in text, you can use the ",
  StyleBox["Convert to StandardForm", "SR"],
  " and ",
  StyleBox["Convert to TraditionalForm", "SR"],
  " menu items within the formula to convert it to ",
  StyleBox["StandardForm", "MR"],
  " or ",
  StyleBox["TraditionalForm", "MR"],
  ". ",
  StyleBox["StandardForm", "MR"],
  " is normally appropriate whenever the formula is thought of as a ",
  StyleBox["Mathematica", "TI"],
  " program fragment.  "
}], "Text",
  CellTags->{"S1.10.10", "10.5"}],

Cell[TextData[{
  "In general, however, you can use exactly the same mechanisms for entering \
formulas, whether or not they will ultimately be given as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "Text",
  CellTags->{"S1.10.10", "10.6"}],

Cell[TextData[{
  "You should realize, however, that to make the detailed typography of \
typical formulas look as good as possible, ",
  StyleBox["Mathematica", "TI"],
  " automatically does things such as inserting spaces around certain \
operators. But these kinds of adjustments can potentially be inappropriate if \
you use notation in very different ways from the ones ",
  StyleBox["Mathematica", "TI"],
  " is expecting. "
}], "Text",
  CellTags->{"S1.10.10", "10.7"}],

Cell[TextData[{
  "In such cases, you may have to make detailed typographical adjustments by \
hand, using the mechanisms discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.9.11",
    ButtonData:>{"2.9.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S1.10.10", "10.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.10.11 Displaying and Printing ",
  StyleBox["Mathematica", "SBO"],
  " Notebooks"
}], "Subsection",
  CellTags->{"S1.10.11", "11.1"}],

Cell[TextData[{
  "Depending on the purpose for which you are using a ",
  StyleBox["Mathematica", "TI"],
  " notebook, you may want to change its overall appearance. The front end \
allows you to specify independently the styles to be used for display on the \
screen and for printing. Typically you can do this by choosing appropriate \
items in the ",
  StyleBox["Format", "SR"],
  " menu. "
}], "Text",
  CellTags->{"S1.10.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ScreenStyleEnvironment", "MR"],
              " "
            }]], Cell["styles to be used for screen display "]},
          {Cell[TextData[{
              StyleBox["PrintingStyleEnvironment", "MR"],
              " "
            }]], Cell["styles to be used for printed output "]},
          {Cell[TextData[{
              StyleBox["Working", "MR"],
              " "
            }]], Cell["standard style definitions for screen display "]},
          {Cell[TextData[{
              StyleBox["Presentation", "MR"],
              " "
            }]], Cell["style definitions for presentations "]},
          {Cell[TextData[{
              StyleBox["Condensed", "MR"],
              " "
            }]], Cell["style definitions for high display density "]},
          {Cell[TextData[{
              StyleBox["Printout", "MR"],
              " "
            }]], Cell["style definitions for printed output "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S1.10.11"],

Cell["\<\
Front end settings that define the global appearance of a notebook. \
\
\>", "Caption",
  CellTags->"S1.10.11"],

Cell["\<\
Here is a typical notebook as it appears in working form on the \
screen. \
\>", "MathCaption",
  CellTags->{"S1.10.11", "11.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000nB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`000P3UiNGo03<c<ol0
<c<c2@0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GUi@80iNGU0`2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooojP3oool50000o`80oooo1@000?l80?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooooE`3oool3000009@0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooomH0?ooo`030000003oool0oooo09<0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3ooomD0?ooo`H00000U03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?oooe@0oooo00D000000?ooo`3oool0oooo0000002E0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0ooooE@3oool010000000oooo0?ooo`00002E0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooEP3oool00`000000oooo0000002E0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooooE`3oool2000009D0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooomH0?ooo`030000003oool0oooo09<0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cA03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo01/0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3W0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<d<0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0iP3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=20?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool5
000000L0oooo00<000000?ooo`3oool00P3oool5000000d0oooo0P0000000`3oool000000?ooo`02
000000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`D000003P3oool2
000000030?ooo`000000oooo008000000`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00<0oooo0`00000>0?ooo`80000000<0oooo0000003oool00P0000030?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool0103oool3000000h0oooo0P0000000`3oool000000?ooo`02
000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3U0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<d80oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003oool0000000@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000001`3oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000103oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo0000
00070?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000040?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00D0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3K0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<d80oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo00D0oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00D0
00000?ooo`000000oooo000000040?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0
oooo1P0000070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`000000oooo000000040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
og`00000F@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=20?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool5000000D0oooo00D000000?ooo`000000oooo0000
00040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`050?ooo`D000001@3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo1@0000040?ooo`050000
003oool000000?ooo`000000103oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`040?ooo`D000001@3oool01@000000oooo0000003oool0
000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`D00000f`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=20?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000
103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000103oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo0P0000080?ooo`030000003oool0oooo00@0
oooo00D000000?ooo`000000oooo000000040?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00D0oooo00D00000
0?ooo`000000oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`3K0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<d80oooo
00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool0103oool3000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`040?oo
o`<0000000<0oooo0000003oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`<0000000<0oooo0000
003oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`000000203oool00`000000oooo0?ooo`040?ooo`<0000000<0oooo0000003oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0f`3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=30?ooo`050000003oool0oooo0?ooo`0000000`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0
oooo0`00000H0?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00<0oooo0P00000H0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0iP3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=40?ooo`030000003oool0oooo00D000000`3o
ool3000000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo00/0oooo00@000000?ooo`3oool0oooo0`00000G0?ooo`030000003oool0oooo00/0oooo
00@000000?ooo`3oool0oooo0`00000F0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0:03oool400000;/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooola0?oo
o`030000003oool0oooo02P0oooo0P00000a0?ooo`800000G@3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?oooc40oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?oooaX0oooo100000050?ooo`<000000`3oool5000000@0oooo00<0
00000?ooo`3oool00`3oool4000000<0oooo0P0000000`3oool0000000000002000000030?ooo`00
0000oooo00@0000000<0oooo0000003oool00P0000020?ooo`80000000<0oooo0000000000000`3o
ool00`000000oooo0?ooo`020?ooo`D000000`3oool00`000000oooo0?ooo`070?ooo`@000003`3o
ool2000000030?ooo`000000oooo008000000`3oool00`000000oooo0?ooo`1K0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo6`3oool00`000000oooo0?ooo`040?ooo`050000
003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`<000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P0000020?ooo`050000003oool00000
0?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`3oool00P00
00040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`050?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0?ooo`1K0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo6`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool00000
0080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`080000003oool0
oooo0000003oool000000?ooo`0000020?ooo`050000003oool000000?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003o
ool0000000@0oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?oooa/0oooo100000020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000020?ooo`@000000P3oool4
00000080oooo00D000000?ooo`000000oooo000000020?ooo`050000003oool000000?ooo`000000
0`3oool4000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo00<0oooo1@0000050?ooo`050000003oool000000?ooo`000000103oool00`000000
oooo0?ooo`1K0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo6`3oool00`00
0000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000/0oooo00P000000?ooo`3oool0
00000?ooo`000000oooo00000080oooo00D000000?ooo`000000oooo000000060?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`@00000203o
ool00`000000oooo0?ooo`050?ooo`050000003oool000000?ooo`000000103oool00`000000oooo
0?ooo`1K0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo6`3oool01@000000
oooo0?ooo`3oool0000000<0oooo0`0000050?ooo`040000003oool0oooo0?ooo`<0000000<0oooo
0000000000000P0000040?ooo`030000003oool0oooo00@000000P3oool3000000040?ooo`000000
oooo0?ooo`<0000000<0oooo0000003oool00P3oool4000000D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103o
ool3000000030?ooo`000000oooo00@0oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooa/0oooo00<000000?ooo`3oool00P00000;0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool00P00000P0?ooo`030000003oool0oooo0080oooo
0`00000?0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooaX0oooo1@00000:0?ooo`<00000303oool200000003
0?ooo`000000oooo01l0oooo0P0000050?ooo`030000003oool0oooo00d0oooo1@00000G0?ooo`80
0000G@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonh0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooooI03oool00`000000oooo0?ooo`270?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0ooooI@3oool00`000000oooo0?ooo`260?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooooG03oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo08H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooomM0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0QP3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=@0?ooo`030000003oool0oooo0080oooo1@0000040?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool04`3oool500000080oooo100000040?ooo`<000001@3oool200000003
0?ooo`000000oooo008000000`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01<0
oooo1@0000030?ooo`<000000`3oool4000000D0oooo0P0000000`3oool000000?ooo`02000000T0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0D0?ooo`<00000103oool3000000D0
oooo0P0000000`3oool000000?ooo`02000000X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0D0?ooo`<000001@3oool2000000030?ooo`000000oooo008000002@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`250?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<e00oooo00<000000?oo
o`3oool00P3oool01@000000oooo0?ooo`3oool0000000D0oooo00@000000?ooo`3oool00000603o
ool01@000000oooo0?ooo`3oool0000000@0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`030?ooo`050000003oool000000?ooo`0000001@3oool010000000oooo0?ooo`00000H
0?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000@0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000/0oooo00@000000?ooo`3o
ool000005P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000
00050?ooo`050000003oool000000?ooo`000000303oool010000000oooo0?ooo`00000F0?ooo`05
0000003oool0oooo0?ooo`0000001@3oool01@000000oooo0000003oool0000000/0oooo00@00000
0?ooo`3oool00000303oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo08D0oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cD03oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`000000603oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool00000
00H0oooo00<000000?ooo`000000603oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo
0?ooo`0000001P3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`000000303o
ool00`000000oooo0000000J0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0000003oool0000000d0oooo00<000000?ooo`0000006P3oool00`000000
oooo0?ooo`030?ooo`050000003oool000000?ooo`000000303oool00`000000oooo0000000<0?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0Q03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=A0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0000000<0?ooo`D000001`3oool00`000000oooo0?ooo`060?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000H0oooo
00<000000?ooo`000000303oool5000000L0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool00000
00`0oooo00<000000?ooo`000000303oool5000000T0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000003@3oool00`000000oooo0000
000<0?ooo`D000002@3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`000000
303oool00`000000oooo0000000<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
Q03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=A0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000G0?ooo`030000003oool0oooo0080
oooo100000030?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000oooo0000003oool0
000000L0oooo00<000000?ooo`0000005`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool4000000H0oooo00D000000?ooo`000000oooo0000000=0?ooo`030000
003oool0000001L0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000001@3oool01@000000
oooo0000003oool0000000h0oooo00<000000?ooo`0000005`3oool2000000H0oooo00D000000?oo
o`000000oooo0000000=0?ooo`030000003oool0000000/0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`240?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<e40oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo1P00000F0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000@0
oooo0`0000000`3oool000000?ooo`050?ooo`H000005P3oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`060?ooo`<0000000<0oooo0000
003oool02`3oool6000001P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`02
0?ooo`<0000000<0oooo0000003oool0303oool6000001P0oooo00<000000?ooo`3oool00P3oool3
000000030?ooo`000000oooo00/0oooo1P00000:0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0P`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000`0oooo1000000?0?ooo`<0
0000103oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000005P3oool40000
00l0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0>
0?ooo`@00000303oool4000000l0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000002`3oool3000000l0oooo1000000?0?ooo`050000003oool0oooo0?ooo`00
00003@3oool3000000`0oooo100000040?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0P`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?ooo`D000000`3oool30000
00d0oooo0P00000C0?ooo`030000003oool0oooo0080oooo1@0000030?ooo`<000005`3oool20000
01<0oooo00<000000?ooo`3oool00`3oool3000000<0oooo1@00000<0?ooo`8000003P3oool20000
0180oooo0`0000040?ooo`<000003`3oool00`000000oooo0?ooo`0<0?ooo`8000004P3oool30000
00l0oooo00<000000?ooo`3oool02`3oool2000000D0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`220?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<fP0oooo00<00000
0?ooo`3oool0>@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool09P3oool200000140oooo00<000000?ooo`3oool07`3oool4000000h0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`220?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<fT0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`000000403oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo0880oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cIP3oool010000000oooo
0?ooo`00000h0?ooo`040000003oool0oooo000002h0oooo00@000000?ooo`3oool00000303oool0
10000000oooo0?ooo`00000V0?ooo`040000003oool0oooo000000h0oooo00@000000?ooo`3oool0
00008@3oool2000000d0oooo00@000000?ooo`3oool000004@3oool00`000000oooo0?ooo`210?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<fL0oooo0P00000j0?ooo`800000<03oool2
000000h0oooo0P00000X0?ooo`800000403oool2000002<0oooo00<000000?ooo`3oool0303oool2
000009H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cH0oooo00<000000?ooo`3oool0o`3ooone
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cD0oooo00<000000?ooo`3oool0o`3o
oonf0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c@0oooo00<000000?ooo`3oool0
0`3oool3000000<0oooo1@0000020?ooo`@000003`3oool5000000@0oooo0`0000030?ooo`<00000
0`3oool4000000D0oooo0P0000000`3oool000000?ooo`02000000h0oooo1@0000030?ooo`<00000
0`3oool3000000D0oooo0`0000050?ooo`80000000<0oooo0000003oool00P00000E0?ooo`<00000
103oool3000000<0oooo1@0000040?ooo`80000000<0oooo0000003oool00P00000E0?ooo`<00000
0`3oool4000000D0oooo0P0000000`3oool000000?ooo`0200000=h0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c=03oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`000000103oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000
003oool0000000L0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool00`3oool01@000000oooo0000003oool0000000d0oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000001@3oool01@000000oooo0000003oool0000000d0oooo00<000000?oo
o`3oool01@3oool01`000000oooo0?ooo`3oool000000?ooo`000000103oool00`000000oooo0?oo
o`030?ooo`050000003oool000000?ooo`000000g`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<d0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?oo
o`040000003oool0oooo0?ooo`H000001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00<0oooo00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000H0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000003@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo00000008
0?ooo`050000003oool000000?ooo`0000003@3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool000000=l0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=03oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
0080oooo1@0000070?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003o
ool0000000D0oooo1@0000070?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000030?ooo`@000000P3oool01@000000oooo0?ooo`3oool0000000D0oooo00D000000?ooo`00
0000oooo0000000;0?ooo`D000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool01@000000oooo0000003oool0000000/0oooo1@000009
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003o
ool0000000/0oooo1@00003?0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c@0oooo
00<000000?ooo`3oool00P3oool4000000D0oooo00<000000?ooo`3oool00P3oool4000000L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0
oooo0P0000030?ooo`@000001P3oool01@000000oooo0000003oool0000000L0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000050?ooo`050000
003oool000000?ooo`0000003@3oool00`000000oooo0?ooo`070?ooo`8000001@3oool2000000H0
oooo00<000000?ooo`3oool0103oool01@000000oooo0000003oool0000000d0oooo00<000000?oo
o`3oool01`3oool2000000<0oooo100000060?ooo`050000003oool000000?ooo`000000g`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<d0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0000000L0oooo00@0
00000?ooo`3oool00000203oool3000000030?ooo`000000oooo00L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`<0000000<0oooo
0000003oool03@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`020?ooo`<0000000<0oooo0000003oool03@3o
ool00`000000oooo0?ooo`090?ooo`040000003oool0oooo000000P0oooo0`0000000`3oool00000
0?ooo`3O0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cD0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo0?ooo`0@0?ooo`<0
00001P3oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
01/0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo0000000<0?ooo`@000003`3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000002`3oool300000140oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo00l0oooo0`00003F0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3oool00`000000oooo
0?ooo`020?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`D00000403oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0080oooo0`0000030?ooo`D000006`3oool00`000000oooo
0?ooo`030?ooo`<00000103oool3000000@0oooo0`00000=0?ooo`8000004P3oool3000000@0oooo
0`0000040?ooo`<000003`3oool00`000000oooo0?ooo`0?0?ooo`<000000`3oool5000000h0oooo
00<000000?ooo`3oool0f03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>e0?ooo`03
0000003oool0oooo02d0oooo0P00000Y0?ooo`@00000f03oool20000o`H0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<kH0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool00000
0=P0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c/`3oool010000000oooo0?ooo`00
000]0?ooo`040000003oool0oooo000002T0oooo0P00003G0?ooo`040000o`3oool0oooo0000o`H0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<k@0oooo0P00000_0?ooo`800000:`3oool00`000000oooo0?ooo`3D0?oo
o`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooY0?ooo`H0003o1P3o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3o
ool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?oo
o`D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<e00oooo0`00003o0?oooi/0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
D@3oool00`000000oooo0?ooo`3o0?oooiX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cD@3oool00`000000oooo0?ooo`3o0?oooiX0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c303oool300000080oooo0`0000020?ooo`8000000P3oool300000080oooo0P0000050?oo
o`H000001P3oool00`000000oooo00000002000000040?ooo`00000000000?ooo`8000001P3oool3
000000@0oooo0P0000001`3oool000000?ooo`000000oooo0000003oool00P0000040?ooo`800000
00@0oooo0000003oool000000P3oool00`000000oooo0?ooo`3o0?ooohX0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000
003oool000000080oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo0P0000020?ooo`040000003o
ool0oooo00000080oooo00<000000?ooo`000000o`3ooon@0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0oooo0P0000040?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo000000070?ooo`050000003oool0oooo0?ooo`00
00000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`060000003oool0oooo0000003oool00000o`3ooon@0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040000
0080oooo00<000000?ooo`3oool0100000050?ooo`040000003oool00000000000H0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0000000<00000103oool01@000000oooo0?oo
o`3oool000000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo00000?l0ooooT03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`H000000P3oool010000000oooo0?ooo`0000020?oo
o`80000000D0oooo0000003oool0oooo000000050?ooo`030000003oool000000080oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000P3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01P000000oooo
0?ooo`000000oooo00000080oooo0P0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`000000o`3ooon@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`3oool200000080oooo00D000000?ooo`000000
00000?ooo`02000000D0oooo0P0000020?ooo`<000000`3oool300000080oooo0`0000030?ooo`80
00001P3oool300000080oooo0P0000000`3oool0000000000005000000030?ooo`00000000000080
oooo0P0000000`3oool000000000000300000080oooo00<000000?ooo`3oool0o`3ooon:0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`d0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0L0?ooo`050000003oool0oooo0?ooo`000000603oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo0?l0ooooSP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`3o0?oookH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool300000080oooo
0`00000C0?ooo`030000003oool0oooo00X0oooo0P00003o0?oookP0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo^0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool50000o`H0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
oooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool50000o`H0
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0ooookP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c;`3oool2000000030?ooo`00
000000000080oooo100000000`3oool000000000000200000?l0oooo[`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<_0?ooo`80000000<0oooo000000000000203oool200000?l0oooo
/03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<_0?ooo`80000000<0oooo00000000
00000P3oool400000080oooo0P00000G0?ooo`8000007`3oool200000?l0ooooMP3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<_0?ooo`@000002@3oool2000001H0oooo0P00000Q0?oo
o`800000o`3ooome0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo0P000008
0?ooo`P000001P3oool200000080oooo200000060?ooo`030000003oool0oooo00L0oooo10000003
0?ooo`800000o`3ooome0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c/0oooo0`00
00090?ooo`8000000P3oool2000000H0oooo0P0000040?ooo`8000000P3oool2000000L0oooo00<0
00000?ooo`3oool0203oool2000000D0oooo0P00003o0?ooog@0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cA`3oool200000080oooo0P0000060?ooo`800000103oool200000080oooo
0P0000050?ooo`D00000203oool2000000D0oooo0P00003o0?ooog@0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cA`3oool200000080oooo0P0000060?ooo`800000103oool200000080
oooo0P0000070?ooo`030000003oool0oooo00D0oooo1P0000040?ooo`8000000P3oool500000?l0
ooooK@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<`0?ooo`l00000203oool30000
00030?ooo`000000000000H0oooo0P0000040?ooo`<0000000<0oooo0000000000001`3oool00`00
0000oooo0?ooo`050?ooo`80000000<0oooo0000000000001@3oool2000000<0oooo0P00003o0?oo
ofl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3oool2000000X0oooo0P000007
0?ooo`H00000203oool200000080oooo1P00000A0?ooo`@00000103oool2000000D0oooo0P00003o
0?ooofh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<P3oool2000000T0oooo0P00
000E0?ooo`8000006P3oool3000000@0oooo0P0000060?ooo`800000o`3ooom]0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<c<0oooo0P0000080?ooo`8000005P3oool2000001X0oooo
0P0000030?ooo`800000103oool2000000030?ooo`00000000000?l0ooooK@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<d0?ooo`8000001`3oool2000003h0oooo0`00003o0?ooofh0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=@3oool200000?l0oooo]`3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<f0?ooo`800000o`3ooonf0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<cL0oooo0P00003o0?oookD0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c>03oool2000000X0oooo@@00003o0?ooofT0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c>@3oool200000?l0oooo/`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<h0?ooo`800000o`3ooond0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<cL0oooo0P00003o0?oookD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=P3o
ool200000?l0oooo]P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<e0?ooo`800000
o`3ooong0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c@0oooo0P0000060?ooo`80
0000o`3ooon`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c<0oooo0P0000070?oo
o`800000903oool600000?l0ooooQP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<b
0?ooo`800000203oool2000002H0oooo0P00003o0?ooohP0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c<@3oool=000002H0oooo0P00003o0?ooohP0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<cI03oool200000?l0ooooR03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=T0?ooo`800000o`3ooon80?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<c@0oooo1P00000X0?ooo`@00000o`3ooon80?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<c@0oooo1P00000Y0?ooo`<00000o`3ooon70?ooo`80003o1P3oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c=03o
ool6000002X0oooo0P00003o0?ooohH0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?oo
o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
=03oool500000?l0oooo/P3oool010000?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
onX0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonT0oooo1P00
0?l60?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`D0003o1P3o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dX0
oooo0`00003o0?oooj40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cB`3oool00`00
0000oooo0?ooo`3o0?oooj00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cB`3oool0
0`000000oooo0?ooo`3o0?oooj00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303o
ool300000080oooo0`0000020?ooo`8000000P3oool300000080oooo0P0000050?ooo`H000001P3o
ool00`000000oooo00000002000000040?ooo`00000000000?ooo`8000001@3oool6000000050?oo
o`00000000000000003oool00P0000040?ooo`80000000@0oooo0000003oool000000P3oool00`00
0000oooo0?ooo`3o0?oooi00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000050?ooo`030000003oool000000080oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`0000000P3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00@000000?ooo`00000000000P3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool000000?l0ooooUP3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000001@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0?ooo`800000103o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`000000203oool010000000oooo
0?ooo`0000020?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0000003o0?oooiH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00@000000P3oool00`000000oooo0?ooo`04
000000D0oooo00@000000?ooo`00000000001P3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`0000000`0000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`00
00000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000?l0ooooUP3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`H000000P3oool010000000oooo0?ooo`00
00020?ooo`80000000D0oooo0000003oool0oooo000000050?ooo`030000003oool000000080oooo
00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`00
00000P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`00000000000P3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000?l0ooooUP3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool0oooo0P0000020?ooo`050000003oool000000000003oool00P0000050?oo
o`8000000P3oool3000000<0oooo0`0000020?ooo`<000000`3oool2000000D0oooo0P0000000`3o
ool000000?ooo`02000000040?ooo`00000000000?ooo`8000000P3oool2000000030?ooo`000000
000000<000000P3oool00`000000oooo0?ooo`3o0?oooi00oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c3@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01`0oooo00D0
00000?ooo`3oool0oooo0000000Q0?ooo`030000003oool0oooo0?l0ooooU03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`3o0?oookH0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c303oool300000080oooo0`00000C0?ooo`030000003oool0oooo00X0oooo0P00000=0?oo
o`030000003oool0oooo0?l0ooooZ03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooon/0oooo10000?l60?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`060?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`03
0000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
oooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom@3o
ool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3o
ool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooD0oooo00<0
003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`D0003o1P3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c>@3oool400000?l0oooo/@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<i
0?ooo`D00000o`3ooon`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo0`00
003o0?ooojl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool300000?l0oooo
[`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<90?ooo`/000001@3oool3000000L0
oooo0`0000090?ooo`D000001`3oool5000000@0oooo0`0000030?ooo`<000000`3oool300000080
oooo0`000000103oool000000000000000070?ooo`@000001@3oool300000080oooo0`0000040?oo
o`D00000303oool5000000H0oooo10000000103oool000000000000000020?ooo`<000000`3oool3
000000<0oooo0`00003o0?oood40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2@3o
ool;000000H0oooo0`0000050?ooo`<00000203oool9000000D0oooo1@0000040?ooo`<000000`3o
ool3000000<0oooo0`0000020?ooo`P00000103oool8000000<0oooo0`0000020?ooo`<000000`3o
ool7000000T0oooo2@0000030?ooo`T000000P3oool3000000<0oooo0`0000030?ooo`<00000o`3o
oom10?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`T0oooo2`0000060?ooo`<00000
1@3oool3000000L0oooo100000030?ooo`@000000`3oool3000000040?ooo`0000000000000000<0
oooo0`0000030?ooo`<000000`3oool300000080oooo100000000`3oool0000000000002000000<0
oooo0`0000020?ooo`<000000`3oool300000080oooo0`0000030?ooo`<000000P3oool3000000L0
oooo100000030?ooo`@000000P3oool300000080oooo100000020?ooo`<000000`3oool3000000<0
oooo0`00003o0?oood40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2@3oool;0000
00H0oooo2`0000070?ooo`<000001@3oool3000000<0oooo0`000000103oool00000000000000003
0?ooo`<000000`3oool3000000<0oooo0`0000020?ooo`<000000`3oool300000080oooo0`000004
0?ooo`<000000P3oool300000080oooo0`0000020?ooo`<000000`3oool3000000L0oooo0`000005
0?ooo`<000000P3oool3000000<0oooo0`0000020?ooo`<000000`3oool3000000<0oooo0`00003o
0?oood40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2@3oool;000000L0oooo2@00
000@0?ooo`<000000`3oool3000000040?ooo`0000000000000000<0oooo0`0000030?ooo`<00000
0`3oool300000080oooo0`0000030?ooo`<000000P3oool3000000@0oooo0`0000020?ooo`<00000
0P3oool300000080oooo0`00000E0?ooo`<000000P3oool3000000<0oooo0`0000020?ooo`<00000
0`3oool3000000<0oooo0`00003o0?oood40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c2@3oool;000000L0oooo0`0000030?ooo`<000003@3oool6000000<0oooo0`000000103oool0
00000000000000030?ooo`<000000`3oool3000000<0oooo0`0000020?ooo`<000000`3oool30000
0080oooo0`0000040?ooo`<000000P3oool300000080oooo0`0000020?ooo`<000004P3oool60000
0080oooo0`0000030?ooo`<000000P3oool3000000<0oooo0`0000030?ooo`<00000o`3ooom10?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`T0oooo2`0000070?ooo`<000000`3oool3
000000X0oooo200000030?ooo`<000000`3oool300000080oooo0`0000030?ooo`<000000`3oool3
00000080oooo0`0000030?ooo`<000000P3oool3000000@0oooo0`0000020?ooo`<000000P3oool3
00000080oooo0`0000030?ooo`<000002@3oool8000000<0oooo0`0000030?ooo`<000000P3oool3
000000<0oooo0`0000030?ooo`<00000o`3ooom10?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<`T0oooo2`0000080?ooo`<0000000@0oooo00000000000000002@3oool7000000H0oooo
0`0000030?ooo`<000000P3oool400000080oooo100000020?ooo`<000000P3oool4000000030?oo
o`0000000000008000000`3oool300000080oooo0`0000030?ooo`<000000P3oool3000000<0oooo
0`0000020?ooo`<000001`3oool7000000H0oooo0`0000030?ooo`<000000P3oool400000080oooo
100000020?ooo`<00000o`3ooom10?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`T0
oooo2`0000080?ooo`<0000000@0oooo00000000000000002@3oool3000000X0oooo0`0000030?oo
o`<000000P3oool?00000080oooo200000040?ooo`P000000`3oool300000080oooo0`0000030?oo
o`L00000203oool3000000X0oooo0`0000030?ooo`<000000P3oool?00000?l0oooo@@3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<90?ooo`/00000203oool3000000040?ooo`000000
0000000000T0oooo0`0000050?ooo`<0000000@0oooo00000000000000001@3oool3000000050?oo
o`00000000000000003oool0100000020?ooo`@000000`3oool3000000040?ooo`00000000000000
00L0oooo100000050?ooo`<000000P3oool3000000@0oooo1@0000090?ooo`<000001@3oool30000
0080oooo0`0000030?ooo`<000000P3oool3000000030?ooo`0000000000008000000P3oool40000
0?l0oooo@P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<M0?ooo`D000002P3oool4
000000<0oooo1000000N0?ooo`<00000503oool3000001L0oooo100000030?ooo`@00000o`3ooomM
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ad0oooo1@00000;0?ooo`T000007`3o
ool3000001@0oooo0`0000020?ooo`<000004`3oool900000?l0ooooGP3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<N0?ooo`<000003P3oool500000240oooo0`00000D0?ooo`<00000
0P3oool3000001D0oooo1@00003o0?ooof00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooo^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooookP3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo10000?l60?ooo`030000o`3oool0
oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooonh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`D0003o
0P3oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU
09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VI
V@H0VIVI0P0c<c<10?ooo`00o`3UiNGo0>GUi@X0iNGU0@0c<c<10?ooo`00o`3UiNGo0>GUi@/0iNGU
0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 249},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.11"],

Cell["Here is the same notebook with condensed styles. ", "MathCaption",
  CellTags->{"S1.10.11", "11.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000[2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030?ooo`0c<c<0<c<c0?l0<c<co`0c<c<803<c<`40
oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIVOl0
iNGUo`3UiND10>GUi@<0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l20?ooo`D0003o
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
@03oool00`000000oooo0?ooo`3o0?ooojd0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c=00?ooo`030000003oool0oooo0?l0oooo[@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<cd0oooo1@00003o0?ooojh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<m0?ooo`040000003oool0oooo00000?l0oooo[`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ch0oooo00<000000?ooo`000000o`3ooon_0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c?`3oool200000?l0oooo[`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<d00oooo00<000000?ooo`3oool0o`3ooon]0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c2`3ooom[00000?l0ooooNP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<al0oooo1000000R0?ooo`80
0000203oool00`000000oooo0?ooo`0M0?ooo`800000o`3ooomo0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c8@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`3o0?ooogd0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<=0?ooo`<000001@3oool300000080oooo1@0000030?ooo`04
0000003oool0oooo0?ooo`<000000`3oool20000000@0?ooo`00000000000?ooo`000000oooo0000
003oool000000?ooo`000000oooo0000003oool000000?ooo`80000000<0oooo0000000000000P3o
ool010000000oooo0?ooo`3oool500000080oooo00<000000?ooo`3oool01P3oool3000000L0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0000003oool000000080oooo00<000000?ooo`3o
ool0o`3ooomm0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`020?oo
o`8000000P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool200000080oooo00X0
00000?ooo`000000oooo0000003oool000000?ooo`000000oooo0P0000020?ooo`8000000`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo0?oo
o`3o0?ooogd0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`<000000`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000oooo
0000003oool000000080oooo0P0000020?ooo`@000000P3oool030000000oooo0000003oool00000
0?ooo`000000oooo0000003oool000000?ooo`@000000`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool00P3oool5000000<0oooo00D000000?ooo`00
0000oooo000000020?ooo`030000003oool0oooo0?l0ooooO@3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<`h0oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0000000T0oooo
00h000000?ooo`3oool000000?ooo`000000oooo0000003oool000000?ooo`000000oooo000000@0
oooo00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo00/0oooo0`0000070?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool0
oooo0?l0ooooO@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo00@00000
0?ooo`3oool000000`3oool3000000@0oooo00<000000?ooo`3oool00P0000000`3oool000000000
0002000000<0oooo00<000000?ooo`3oool00`0000020?ooo`<0000000<0oooo0000003oool00`00
0000103oool000000?ooo`3oool3000000@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00P3oool3000000030?oo
o`000000oooo0080oooo00<000000?ooo`3oool0o`3ooomm0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c3@3oool4000000/0oooo00<000000?ooo`3oool01`3oool4000001/0oooo
0P0000020?ooo`<000003@3oool00`000000oooo0?ooo`0C0?ooo`800000o`3ooomo0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6P3oool3000002h0oooo00<000000?ooo`3oool0
2`3oool400000?l0ooooT`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
l03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
l03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ih0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`340?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
W@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0<<0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c>=0?ooo`030000003oool0oooo0080oooo100000060?ooo`030000
003oool0oooo0080oooo1@0000050?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000
oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool4000000L0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000<0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`030?ooo`8000001`3oool00`000000oooo0?ooo`030?oo
o`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`050000003oool0
00000?ooo`0000000`3oool00`000000oooo0?ooo`320?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cS@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000H0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo
00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`000000oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`03
0000003oool0oooo0<80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>>0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00<0oooo1@0000040?ooo`050000003oool000000?ooo`0000000`3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool50000
00<0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`D000000`3oool01@000000oooo0000003o
ool0000000<0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`3oool5000000@0oooo
1@0000040?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`320?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cSP3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
00<0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool00`3oool2000000L0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003o
ool0000000<0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`00
00000`3oool00`000000oooo0?ooo`320?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cS`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo0`0000000`3oool0
00000?ooo`020?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0080oooo0`0000000`3oool000000?ooo`020?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0080oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00L0
oooo00L000000?ooo`3oool0oooo0000003oool0000000L0oooo00<000000?ooo`3oool00`3oool3
000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool0``3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<h`0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000080?ooo`030000003oool0oooo00<00000503oool00`000000oooo0?ooo`080?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`090?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`090?oo
o`040000003oool0oooo0?ooo`800000503oool00`000000oooo0?ooo`340?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<cS03oool4000000<0oooo0P00000>0?ooo`030000003oool0
oooo0240oooo0P00000T0?ooo`800000903oool00`000000oooo0?ooo`2T0?ooo`030000003oool0
oooo0380oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oook/0oooo00<00000
0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0ooooo`00002_
000000D0oooo1@00000b0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooonk
0?ooo`030000003oool0oooo0380oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oook/0oooo00<000000?ooo`3oool0<P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`T0oooo0P000003
0?ooo`D0000000@0oooo00000000000000001`3oool00`000000oooo0?ooo`030?ooo`D000000`3o
ool00`000000oooo0?ooo`020?ooo`8000000`3oool3000000H0oooo00D000000?ooo`000000oooo
000000050?ooo`030000003oool0oooo00<0oooo1@0000020?ooo`8000000`3oool2000000D0oooo
0P0000060?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo0?ooo`050?ooo`80
0000103oool2000000<0oooo100000040?ooo`050000003oool000000?ooo`0000002`3oool00`00
0000oooo0?ooo`040?ooo`8000000`3oool3000000H0oooo00D000000?ooo`000000oooo0000000B
0?ooo`030000003oool0oooo0080oooo100000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool03`3oool5000000040?ooo`0000000000000000@0oooo0P0000060?ooo`050000003o
ool000000?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo
1@0000020?ooo`8000000`3oool3000000H0oooo00D000000?ooo`000000oooo000000070?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0403oool2000000@0oooo0P0000060?ooo`05
0000003oool000000?ooo`000000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0100oooo0P0000050?ooo`050000003oool000000?ooo`000000203oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0440oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<8
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`050000
003oool000000?ooo`0000001@3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo0?oo
o`040?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`050000003oool000000?ooo`0000002`3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000
003oool000000180oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`04
0000003oool0oooo000001@0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000030?ooo`040000003o
ool0oooo000001@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000P0oooo00@000000?oo
o`3oool000004P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo
00D000000?ooo`000000oooo000000090?ooo`040000003oool0oooo00000180oooo00@000000?oo
o`3oool00000103oool01@000000oooo0000003oool0000000T0oooo00@000000?ooo`3oool00000
A03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`P0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo1@0000050?ooo`03
0000003oool0oooo00D000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`000000oooo000000030?ooo`D000001@3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`000000oooo000000080?ooo`D000001`3oool00`000000oooo
0?ooo`030?ooo`050000003oool0oooo0?ooo`0000001P3oool01@000000oooo0000003oool00000
00T0oooo1@0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0000003oool0000000P0oooo100000070?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0000000:0?ooo`@000001P3oool00`000000oooo0?ooo`04
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool01@000000oooo0000
003oool0000000@0oooo00<000000?ooo`0000002P3oool4000000H0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0000003oool0000000T0oooo00<000000?ooo`0000002P3oool4000000L0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000002P3o
ool00`000000oooo000000090?ooo`@00000203oool00`000000oooo0?ooo`020?ooo`050000003o
ool000000?ooo`0000002P3oool00`000000oooo000000110?ooo`@0003o1P3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<80?ooo`<000001@3oool010000000oooo0?ooo`3oool3000000L0oooo00<000000?ooo`3o
ool01@3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo0P0000030?oo
o`<000001P3oool01@000000oooo0000003oool0000000D0oooo00<000000?ooo`3oool01@3oool0
1@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0oooo0`0000020?ooo`040000
003oool0oooo000000D0oooo00D000000?ooo`000000oooo0000000:0?ooo`030000003oool0oooo
00D0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`050000003oool00000
0?ooo`0000002`3oool00`000000oooo0?ooo`040?ooo`8000000`3oool3000000H0oooo00D00000
0?ooo`000000oooo0000000C0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0000000D0?ooo`040000003oool0oooo0?ooo`<000000`3oool010000000oooo
0?ooo`0000050?ooo`050000003oool000000?ooo`000000103oool00`000000oooo0000000D0?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`03000000H0oooo00D00000
0?ooo`000000oooo000000090?ooo`030000003oool0000001<0oooo0P0000030?ooo`040000003o
ool0oooo000000D0oooo00D000000?ooo`000000oooo0000000:0?ooo`030000003oool0000001<0
oooo0P0000050?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo000000140?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool00`000000oooo0?ooo`050?oo
o`050000003oool0oooo0?ooo`0000002@3oool00`000000oooo0?ooo`050?ooo`070000003oool0
oooo0?ooo`000000oooo000000060?ooo`040000003oool0oooo000000L0oooo0`0000000`3oool0
00000?ooo`050?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`020?ooo`<0000000<0oooo0000003oool0100000060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`<00000
00@0oooo0000003oool0oooo0P0000080?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3o
ool000001`3oool3000000040?ooo`000000oooo0?ooo`<00000403oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0080oooo2@00000?0?ooo`050000003oool0oooo0?ooo`0000001@3o
ool010000000oooo0?ooo`0000040?ooo`<0000000<0oooo0000003oool00`3oool9000000l0oooo
00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000L0oooo0`0000000`3o
ool000000?ooo`04000000@0oooo2@00000@0?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00P3oool3000000040?ooo`000000oooo0?ooo`8000001P3oool900000100oooo00@0
00000?ooo`3oool0oooo0`000000103oool000000?ooo`3oool3000000D0oooo2@00000n0?ooo`80
003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<90?ooo`030000003oool0oooo0080oooo0`0000030?ooo`03
0000003oool0oooo00d0oooo0`0000040?ooo`8000000`3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo01H0oooo0`0000030?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`00000;0?ooo`8000003P3oool010000000oooo
0?ooo`0000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000303oool0
0`000000oooo0?ooo`0;0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool02`3o
ool4000000d0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000:0?ooo`80
00003P3oool3000000<0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000C0?oo
o`8000003P3oool3000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`0<
0?ooo`8000002`3oool2000000h0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`00000=0?ooo`030000003oool0oooo00T0oooo0P00000>0?ooo`040000003oool0oooo000000T0
oooo1000000;0?ooo`800000?P3oool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`X0
oooo0P0000040?ooo`040000003oool0oooo0?ooo`@000003P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo0P0000030?ooo`@000005`3oool00`000000oooo0?ooo`020?oo
o`800000103oool2000000@0oooo0P00000>0?ooo`030000003oool0oooo00`0oooo0P0000040?oo
o`800000103oool2000000`0oooo00<000000?ooo`3oool03@3oool2000000<0oooo1000000:0?oo
o`<000003P3oool4000000<0oooo0P00000=0?ooo`030000003oool0oooo00d0oooo00@000000?oo
o`3oool0oooo100000030?ooo`8000005P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo0080oooo0P0000030?ooo`@000003@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00`0oooo0P0000040?ooo`8000003@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00`0oooo0P00000:0?ooo`<000003P3oool00`000000oooo0?ooo`0j0?ooo`040000o`3oool0
oooo0000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cK`3oool3000002L0oooo0P00000U0?ooo`030000003o
ool0oooo01l0oooo0`00000`0?ooo`<00000:03oool3000000X0oooo0`00000R0?ooo`800000303o
ool3000001d0oooo00<000000?ooo`3oool02@3oool3000003`0oooo00D0003o0?ooo`3oool0oooo
0000o`060?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj`3oool60000o`H0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
l03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d@0oooo0`00003o0?ooojT0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=50?ooo`030000003oool0oooo0?l0oooo
Z03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`@0oooo0`0000020?ooo`<00000
00<0oooo0000000000001@0000020?ooo`@000000P3oool6000000H0oooo100000000`3oool00000
00000004000000@0oooo0`0000030?ooo`@000000P3oool00`000000oooo00000002000000<0oooo
100000020?ooo`030000003oool000000?l0ooooW03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`D0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000050?ooo`040000
003oool0oooo000000L0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo00000080oooo0P0000070?ooo`070000003oool0oooo0?ooo`000000oooo0000
00020?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000020?oo
o`040000003oool0oooo00000?l0ooooW`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<`D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0000000300000080oooo00<00000
0?ooo`3oool0100000040?ooo`030000003oool0oooo008000001@3oool010000000oooo0?ooo`00
00020?ooo`D00000103oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool010000000
oooo0?ooo`0000020?ooo`060000003oool0oooo0000003oool000000P3oool010000000oooo0?oo
o`00003o0?oooil0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`H00000
00D0oooo0000003oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?oo
o`3oool0oooo0P0000000`3oool000000?ooo`060?ooo`040000003oool0oooo00000080oooo0P00
00020?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool000000080
oooo00@000000?ooo`3oool000000P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@0
00000?ooo`3oool00000o`3ooonO0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000000P3oool4000000030?oo
o`000000000000D0oooo00<000000?ooo`3oool00`0000030?ooo`<0000000@0oooo000000000000
00000P3oool2000000H0oooo0`000000103oool000000000003oool2000000030?ooo`0000000000
00D0000000@0oooo000000000000oooo0P0000001P3oool00000000000000000oooo00000?l0oooo
W03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0J0?ooo`040000003oool0oooo000001L0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`3o0?oooid0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<50?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0703oool200000?l0
ooooa@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`@0oooo0`0000020?ooo`<0
00004@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0?l0oooo`03oool40000o`H0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooo/0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`@0oooo00@000000?ooo`000000oooo0P000000103o
ool0000000000000000B0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0o`3ooonc
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c103oool010000000oooo0000003o
ool200000080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo0?l0oooo/P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`@0oooo0P00
00060?ooo`030000003oool0oooo00@0oooo1`0000040?ooo`040000003oool0oooo0?ooo`L00000
103oool00`000000oooo0?ooo`050?ooo`@000000`3oool00`000000oooo0?ooo`3o0?oook40oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<;0?ooo`8000001`3oool2000000030?oo
o`000000000000D0oooo00<000000?ooo`3oool00P3oool2000000030?ooo`000000000000@0oooo
0`0000070?ooo`800000103oool00`000000oooo0?ooo`3o0?oook40oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<D0?ooo`80000000<0oooo0000000000001@3oool00`000000oooo
0?ooo`020?ooo`80000000<0oooo0000000000001@3oool00`000000oooo0?ooo`040?ooo`D00000
0`3oool00`000000oooo0?ooo`3o0?oook40oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<40?ooo`/00000103oool5000000H0oooo00@000000?ooo`3oool0oooo1@00000=0?ooo`@0
0000103oool00`000000oooo0?ooo`3o0?oook40oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<50?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0C0?ooo`<000000`3oool00`000000oooo0?ooo`0300000?l0oooo[`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`H0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo0P0000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0o`3ooon^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c1`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02d0oooo00<000000?ooo`00
0000o`3ooon_0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c203oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo0?l0oooo[P3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<`T0oooo00<000000?ooo`3oool0o`3ooooT0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c2P3oool00`000000oooo0?ooo`3o0?ooon<0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<:0?ooo`030000003oool0oooo00D0oooo<P00003o0?oooj`0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<90?ooo`030000003oool0oooo0?l0
ooooi03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`P0oooo00<000000?ooo`3o
ool0o`3ooooU0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1`3oool00`000000
oooo0?ooo`3o0?ooonH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<60?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooooP0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0
ooooh03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0oooo2@00000K0?ooo`@0
0000o`3oooo30?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:P3oool200000?l0
ooooa03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bX0oooo0P00003o0?oool@0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?ooo`<00000803oool200000?l0
oooo``3oool20000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1`3oool3000001h0oooo1000003o0?oool80
oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?ooo`030000003oool000000200
oooo0P00003o0?oool40oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
on`0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj`3oool6
0000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ch0oooo0`00003o0?ooojl0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<o0?ooo`030000003oool0oooo0?l0oooo[P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`@0oooo0`0000020?ooo`<0000000<0oooo0000000000001@000002
0?ooo`@000000P3oool6000000H0oooo100000000`3oool0000000000004000000<0oooo1P000000
0`3oool0000000000003000000@0oooo10000000103oool000000?ooo`00003o0?oooj80oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000001@3oool010000000oooo0?ooo`0000070?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`800000203oool010000000
oooo0?ooo`0000020?ooo`030000003oool000000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0000003o0?ooojD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<5
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`0000020?ooo`030000003oool0
oooo00@00000103oool00`000000oooo0?ooo`02000000D0oooo00@000000?ooo`3oool000000P3o
ool5000000D0oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`000000o`3ooonU0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c1@3oool6000000050?ooo`000000oooo0?ooo`0000000P3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo0?ooo`80000000<0oooo0000003oool01P3o
ool010000000oooo0?ooo`0000020?ooo`8000000P3oool00`000000oooo0?ooo`020?ooo`800000
0P3oool01P000000oooo0?ooo`000000oooo00000080oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0000003o0?ooojD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<5
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P0000020?ooo`@0000000<0oooo
0000000000001@3oool00`000000oooo0?ooo`03000000<0oooo0`000000103oool0000000000000
00020?ooo`8000001P3oool00`000000oooo00000003000000030?ooo`0000000000008000000P3o
ool2000000030?ooo`000000000000<0000000<0oooo0000003oool0o`3ooonQ0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01X0oooo00@000000?ooo`3oool000007`3oool00`000000oooo0?ooo`3o0?oooj<0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0703oool200000?l0oooo`P3oool40000o`H0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
103oool300000080oooo0`00000A0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`3o0?oookH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<bP0oooo0`00003o0?ooolD0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<Y0?ooo`800000o`3oooo50?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
:P3oool200000?l0ooooa03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0oooo
200000050?ooo`800000103oool2000000H0oooo1P0000040?ooo`8000000`3oool200000080oooo
0P0000020?ooo`80000000<0oooo0000000000000`0000030?ooo`@000000`3oool200000080oooo
0P0000020?ooo`@000001`3oool6000000<0oooo1@0000020?ooo`8000000P3oool200000080oooo
0P00003o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`P00000
1@3oool2000000@0oooo0P0000050?ooo`800000103oool2000000<0oooo0P0000030?ooo`800000
0P3oool200000080oooo0P0000001@3oool00000000000000000oooo0080000000<0oooo00000000
00000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000D0
oooo0P0000040?ooo`80000000@0oooo000000000000oooo0`0000020?ooo`8000000P3oool20000
0080oooo0P00003o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?oo
o`P000001P3oool200000080oooo0P0000060?ooo`800000103oool200000080oooo100000020?oo
o`8000000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000
000000000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool20000
00D0oooo0P0000040?ooo`80000000<0oooo0000000000000P3oool200000080oooo0P0000020?oo
o`8000000P3oool200000?l0ooooNP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`D0oooo200000060?ooo`H00000303oool200000080oooo100000020?ooo`8000000P3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000000000000P3oool20000
0080oooo0P0000020?ooo`80000000<0oooo0000000000003`3oool2000000030?ooo`0000000000
0080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?ooogX0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`P000001P3oool200000080oooo0P00000:0?oo
o`<000000`3oool400000080oooo0P0000020?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool200000080oooo0P0000000`3o
ool000000000000=0?ooo`<000000P3oool200000080oooo0P0000020?ooo`8000000P3oool20000
0080oooo0P00003o0?ooogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?oo
o`P000001`3oool4000000P0oooo100000050?ooo`@000000P3oool200000080oooo0P0000020?oo
o`80000000<0oooo0000000000000P3oool2000000030?ooo`00000000000080oooo0P0000020?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P0000060?ooo`@00000103oool20000
0080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?ooogX0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`P000001`3oool4000000L0oooo0P0000070?oo
o`8000000P3oool2000000050?ooo`00000000000000003oool00`000000103oool000000000003o
ool3000000040?ooo`00000000000?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool2000000D0oooo0P0000070?ooo`8000000P3oool200000080oooo
0`0000001@3oool00000000000000000oooo00800000o`3ooomj0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c1@3oool8000000L0oooo100000070?ooo`800000103oool200000003
0?ooo`00000000000080oooo0P0000000`3oool0000000000003000000040?ooo`00000000000000
0080oooo1@0000030?ooo`@000000`3oool200000080oooo0P0000020?ooo`@000001P3oool20000
00@0oooo0P0000000`3oool00000000000020?ooo`8000000P3oool5000000040?ooo`0000000000
00000?l0ooooN`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a@0oooo10000007
0?ooo`800000103oool2000001<0oooo0P00000=0?ooo`800000403oool2000000@0oooo0P00003o
0?ooohX0oooo10000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo0P0000090?ooo`H00000503oool2
000000d0oooo0P0000020?ooo`8000003@3oool600000?l0ooooSP3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool50000o`80oooo1@000?l50?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VI
V@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@L0iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3U
iNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 172},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.11"],

Cell["\<\
Here is a preview of how the notebook would appear when printed \
out. \
\>", "MathCaption",
  CellTags->{"S1.10.11", "11.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000bR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030?ooo`0c<c<0<c<c0?l0<c<co`0c<c<803<c<`40
oooo00000`3oool0iNGU03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2I
VIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooon`0oooo1@000?l20?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cI`3oool00`000000oooo0?ooo`3o0?ooohH0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=W0?ooo`030000003oool0oooo0?l0oooo
QP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<f@0oooo1@00003o0?ooohL0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=T0?ooo`040000003oool0oooo00000?l0
ooooR03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fD0oooo00<000000?ooo`00
0000o`3ooon80?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cIP3oool200000?l0
ooooR03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fL0oooo00<000000?ooo`3o
ool0o`3ooon60?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<P3ooom[00000?l0ooooD`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<dH0oooo1000000R0?ooo`800000203oool00`000000oooo0?ooo`0M0?ooo`80
0000o`3ooomH0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cB03oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`3o0?oooeH0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<d0?ooo`<0
00001@3oool300000080oooo1@0000030?ooo`040000003oool0oooo0?ooo`<000000`3oool20000
000@0?ooo`00000000000?ooo`000000oooo0000003oool000000?ooo`000000oooo0000003oool0
00000?ooo`80000000<0oooo0000000000000P3oool010000000oooo0?ooo`3oool500000080oooo
00<000000?ooo`3oool01P3oool3000000L0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0000003oool000000080oooo00<000000?ooo`3oool0o`3ooomF0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c=@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`020?ooo`8000000P3oool01`000000oooo0?ooo`3oool0
00000?ooo`0000000P3oool200000080oooo00X000000?ooo`000000oooo0000003oool000000?oo
o`000000oooo0P0000020?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`050000003oool0
00000?ooo`0000000P3oool00`000000oooo0?ooo`3o0?oooeH0oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<e0?ooo`<000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool00P3oool01@000000oooo0000003oool000000080oooo0P0000020?ooo`@0
00000P3oool030000000oooo0000003oool000000?ooo`000000oooo0000003oool000000?ooo`@0
00000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool00P3oool5000000<0oooo00D000000?ooo`000000oooo000000020?ooo`030000003oool0oooo
0?l0ooooEP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cD0oooo00@000000?oo
o`3oool000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0000000T0oooo00h000000?ooo`3oool000000?ooo`000000oooo
0000003oool000000?ooo`000000oooo000000@0oooo00D000000?ooo`3oool0oooo000000050?oo
o`030000003oool0oooo00/0oooo0`0000070?ooo`030000003oool0oooo00<0oooo00D000000?oo
o`000000oooo000000020?ooo`030000003oool0oooo0?l0ooooEP3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<cD0oooo00@000000?ooo`3oool000000`3oool3000000@0oooo00<0
00000?ooo`3oool00P0000000`3oool0000000000002000000<0oooo00<000000?ooo`3oool00`00
00020?ooo`<0000000<0oooo0000003oool00`000000103oool000000?ooo`3oool3000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool00P3oool3000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool0
o`3ooomF0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c=03oool4000000/0oooo
00<000000?ooo`3oool01`3oool4000001/0oooo0P0000020?ooo`<000003@3oool00`000000oooo
0?ooo`0C0?ooo`800000o`3ooomH0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
@@3oool3000002h0oooo00<000000?ooo`3oool02`3oool400000?l0ooooK03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
l03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<lD0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`2M0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<ca03oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo09`0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c>d0?ooo`030000
003oool0oooo0080oooo100000060?ooo`030000003oool0oooo0080oooo1@0000050?ooo`030000
003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool00P3oool4000000L0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0000003oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?oo
o`8000001`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`040?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?oo
o`2K0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c]03oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo000000H0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00@0oooo00D000000?ooo`000000oooo000000030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000070?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000060?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo
00D000000?ooo`000000oooo000000030?ooo`030000003oool0oooo09/0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c>e0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo1@0000040?ooo`05
0000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool01@3oool5000000<0oooo00D000000?ooo`000000oooo00000003
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02
0?ooo`D000000`3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool01@3o
ool010000000oooo0?ooo`3oool5000000@0oooo1@0000040?ooo`050000003oool000000?ooo`00
00000`3oool00`000000oooo0?ooo`2K0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c]@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00D000000?ooo`00
0000oooo000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo00000003
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool2000000L0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0000003oool0000000<0oooo00<000000?ooo`3oool01@3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`040?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`2K0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c]P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00<0oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080
oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo0`0000000`3oool0
00000?ooo`020?ooo`030000003oool0oooo00L0oooo00L000000?ooo`3oool0oooo0000003oool0
000000L0oooo00<000000?ooo`3oool00`3oool3000000030?ooo`000000oooo0080oooo00<00000
0?ooo`3oool0W03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<k<0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00<00000
503oool00`000000oooo0?ooo`080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo00000080oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo0?ooo`800000503oool0
0`000000oooo0?ooo`2M0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c/`3oool4
000000<0oooo0P00000>0?ooo`030000003oool0oooo0240oooo0P00000T0?ooo`800000903oool0
0`000000oooo0?ooo`2T0?ooo`030000003oool0oooo00/0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooon80oooo00<000000?ooo`3oool02`3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<b`0ooooo`00002_000000D0oooo1@00000;0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooR0?ooo`030000003oool0oooo00/0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon80oooo00<000000?ooo`3oool02`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<c00oooo0P0000030?ooo`D0000000@0oooo00000000000000001`3o
ool00`000000oooo0?ooo`030?ooo`D000000`3oool00`000000oooo0?ooo`020?ooo`8000000`3o
ool3000000H0oooo00D000000?ooo`000000oooo000000050?ooo`030000003oool0oooo00<0oooo
1@0000020?ooo`8000000`3oool2000000D0oooo0P0000060?ooo`050000003oool000000?ooo`00
00002P3oool00`000000oooo0?ooo`050?ooo`800000103oool2000000<0oooo100000040?ooo`05
0000003oool000000?ooo`0000002`3oool00`000000oooo0?ooo`040?ooo`8000000`3oool30000
00H0oooo00D000000?ooo`000000oooo0000000B0?ooo`030000003oool0oooo0080oooo10000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool5000000040?ooo`000000
0000000000@0oooo0P0000060?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00l0oooo1@0000020?ooo`8000000`3oool3000000H0oooo
00D000000?ooo`000000oooo000000070?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0403oool2000000@0oooo0P0000060?ooo`050000003oool000000?ooo`000000203oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0100oooo0P0000050?ooo`050000003oool00000
0?ooo`000000203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01X0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<_0?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000001@3oool00`000000
oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`050000003oool0
00000?ooo`0000002P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`050000003oool00000
0?ooo`0000002`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0000003oool000000180oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`0000040?ooo`040000003oool0oooo000001@0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00D00000
0?ooo`000000oooo000000030?ooo`040000003oool0oooo000001@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0000003oool0000000P0oooo00@000000?ooo`3oool000004P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`000000oooo000000090?ooo`04
0000003oool0oooo00000180oooo00@000000?ooo`3oool00000103oool01@000000oooo0000003o
ool0000000T0oooo00@000000?ooo`3oool000007@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<bl0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0080oooo1@0000050?ooo`030000003oool0oooo00D000001@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo000000030?oo
o`D000001@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool0
10000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00D000000?ooo`000000oooo
000000080?ooo`D000001`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00001P3oool01@000000oooo0000003oool0000000T0oooo1@0000060?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000P0oooo10000007
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0000000:
0?ooo`@000001P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`000000
2P3oool4000000H0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool01@000000oooo0000003oool0000000T0oooo00<000000?oo
o`0000002P3oool4000000L0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo000000090?ooo`@00000203o
ool00`000000oooo0?ooo`020?ooo`050000003oool000000?ooo`0000002P3oool00`000000oooo
0000000J0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<_0?ooo`<000001@3oool010000000oooo
0?ooo`3oool3000000L0oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo0080oooo0P0000030?ooo`<000001P3oool01@000000oooo0000003oool0
000000D0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool000000080oooo00@0
00000?ooo`3oool0oooo0`0000020?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`00
0000oooo0000000:0?ooo`030000003oool0oooo00D0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`030?ooo`050000003oool000000?ooo`0000002`3oool00`000000oooo0?ooo`04
0?ooo`8000000`3oool3000000H0oooo00D000000?ooo`000000oooo0000000C0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0000000D0?ooo`040000003o
ool0oooo0?ooo`<000000`3oool010000000oooo0?ooo`0000050?ooo`050000003oool000000?oo
o`000000103oool00`000000oooo0000000D0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`03000000H0oooo00D000000?ooo`000000oooo000000090?ooo`030000003o
ool0000001<0oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00D000000?ooo`000000
oooo0000000:0?ooo`030000003oool0000001<0oooo0P0000050?ooo`050000003oool000000?oo
o`0000002P3oool00`000000oooo0000000M0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c;`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000002@3oool0
0`000000oooo0?ooo`050?ooo`070000003oool0oooo0?ooo`000000oooo000000060?ooo`040000
003oool0oooo000000L0oooo0`0000000`3oool000000?ooo`050?ooo`030000003oool0oooo00D0
oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo00000080oooo00@00000
0?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`<0000000<0oooo0000003oool01000
00060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`040000003oool0oooo0?ooo`<0000000@0oooo0000003oool0oooo0P0000080?ooo`03
0000003oool0oooo00H0oooo00@000000?ooo`3oool000001`3oool3000000040?ooo`000000oooo
0?ooo`<00000403oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo2@00000?
0?ooo`050000003oool0oooo0?ooo`0000001@3oool010000000oooo0?ooo`0000040?ooo`<00000
00<0oooo0000003oool00`3oool9000000l0oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo000000L0oooo0`0000000`3oool000000?ooo`04000000@0oooo2@00000@0?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool3000000040?ooo`000000
oooo0?ooo`8000001P3oool900000100oooo00@000000?ooo`3oool0oooo0`000000103oool00000
0?ooo`3oool3000000D0oooo2@00000G0?ooo`80003o1P3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`03
0000003oool0oooo0080oooo0`0000030?ooo`030000003oool0oooo00d0oooo0`0000040?ooo`80
00000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo01H0oooo0`0000030?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`00000;0?ooo`8000003P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00@000000?ooo`3oool00000303oool00`000000oooo0?ooo`0;0?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool02`3oool4000000d0oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`00000:0?ooo`8000003P3oool3000000<0oooo00<000000?ooo`3o
ool00`3oool010000000oooo0?ooo`00000C0?ooo`8000003P3oool3000000<0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`0<0?ooo`8000002`3oool2000000h0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`00000=0?ooo`030000003oool0oooo00T0oooo
0P00000>0?ooo`040000003oool0oooo000000T0oooo1000000;0?ooo`8000005`3oool00`000?l0
oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40oooo0P0000040?ooo`040000003oool0oooo0?oo
o`@000003P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0P0000030?oo
o`@000005`3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000@0oooo0P00000>0?oo
o`030000003oool0oooo00`0oooo0P0000040?ooo`800000103oool2000000`0oooo00<000000?oo
o`3oool03@3oool2000000<0oooo1000000:0?ooo`<000003P3oool4000000<0oooo0P00000=0?oo
o`030000003oool0oooo00d0oooo00@000000?ooo`3oool0oooo100000030?ooo`8000005P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo0P0000030?ooo`@000003@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00`0oooo0P0000040?ooo`8000003@3oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo0P00000:0?ooo`<000003P3oool0
0`000000oooo0?ooo`0C0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cUP3o
ool3000002L0oooo0P00000U0?ooo`030000003oool0oooo01l0oooo0`00000`0?ooo`<00000:03o
ool3000000X0oooo0`00000R0?ooo`800000303oool3000001d0oooo00<000000?ooo`3oool02@3o
ool3000001D0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
j`3oool60000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooook03oool50000o`H0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooo`0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
A03oool300000?l0ooooZ@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dD0oooo
00<000000?ooo`3oool0o`3ooonX0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
103oool300000080oooo0`0000000`3oool000000000000500000080oooo100000020?ooo`H00000
1P3oool4000000030?ooo`000000000000@00000103oool3000000<0oooo100000020?ooo`030000
003oool00000008000000`3oool400000080oooo00<000000?ooo`000000o`3ooonL0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000D0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool2000000L0oooo00L000000?oo
o`3oool0oooo0000003oool000000080oooo00@000000?ooo`3oool000000P3oool01P000000oooo
0?ooo`000000oooo00000080oooo00@000000?ooo`3oool00000o`3ooonO0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
000000<000000P3oool00`000000oooo0?ooo`04000000@0oooo00<000000?ooo`3oool00P000005
0?ooo`040000003oool0oooo00000080oooo1@0000040?ooo`070000003oool0oooo0?ooo`000000
oooo000000020?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3oool000000?ooo`00
00020?ooo`040000003oool0oooo00000?l0ooooW`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`D0oooo1P0000001@3oool000000?ooo`3oool000000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`3oool2000000030?ooo`000000oooo00H0oooo00@00000
0?ooo`3oool000000P3oool200000080oooo00<000000?ooo`3oool00P3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000P3oool010000000oooo0?ooo`0000020?ooo`060000003oool0oooo
0000003oool000000P3oool010000000oooo0?ooo`00003o0?oooil0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<50?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0P0000020?ooo`@0000000<0oooo0000000000001@3oool00`000000oooo0?ooo`03000000<0oooo
0`000000103oool000000000000000020?ooo`8000001P3oool3000000040?ooo`00000000000?oo
o`80000000<0oooo0000000000001@000000103oool000000000003oool2000000060?ooo`000000
00000000003oool00000o`3ooonL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01X0oooo00@000000?ooo`3oool0
00005`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0?l0ooooW@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0L0?ooo`800000o`3oooo50?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c103oool300000080oooo0`00000A0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0o`3oooo00?ooo`@0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo00oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooon`0oooo1@000?l60?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b/0oooo00@000000?ooo`000000oooo0P000000103o
ool0000000000000000B0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0o`3ooon<
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:`3oool010000000oooo0000003o
ool200000080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo0?l0ooooR`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b/0oooo0P00
00060?ooo`030000003oool0oooo00@0oooo1`0000040?ooo`040000003oool0oooo0?ooo`L00000
103oool00`000000oooo0?ooo`050?ooo`@000000`3oool00`000000oooo0?ooo`3o0?ooohX0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<b0?ooo`8000001`3oool2000000030?oo
o`000000000000D0oooo00<000000?ooo`3oool00P3oool2000000030?ooo`000000000000@0oooo
0`0000070?ooo`800000103oool00`000000oooo0?ooo`3o0?ooohX0oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<k0?ooo`80000000<0oooo0000000000001@3oool00`000000oooo
0?ooo`020?ooo`80000000<0oooo0000000000001@3oool00`000000oooo0?ooo`040?ooo`D00000
0`3oool00`000000oooo0?ooo`3o0?ooohX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<[0?ooo`/00000103oool5000000H0oooo00@000000?ooo`3oool0oooo1@00000=0?ooo`@0
0000103oool00`000000oooo0?ooo`3o0?ooohX0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c</0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0C0?ooo`<000000`3oool00`000000oooo0?ooo`0300000?l0ooooR03oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bd0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo0P0000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0o`3ooon70?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c;P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02d0oooo00<000000?ooo`00
0000o`3ooon80?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;`3oool00`000000
oooo0?ooo`0d0?ooo`030000003oool0oooo0?l0ooooQ`3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<c00oooo00<000000?ooo`3oool0o`3ooonm0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c<@3oool00`000000oooo0?ooo`3o0?oook`0oooo00<0003o0?ooo`3o
ool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`030000003oool0oooo00D0oooo<P00003o0?ooohD0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`030000003oool0oooo0?l0
oooo_@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bl0oooo00<000000?ooo`3o
ool0o`3ooonn0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;P3oool00`000000
oooo0?ooo`3o0?oookl0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<]0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3oooni0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<c;03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?l0
oooo^@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b`0oooo2@00000K0?ooo`@0
0000o`3ooonL0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cD@3oool200000?l0
ooooW@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<e40oooo0P00003o0?oooid0
oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`<00000803oool200000?l0
ooooW03oool20000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c;P3oool3000001h0oooo1000003o0?oooi/0
oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<^0?ooo`030000003oool000000200
oooo0P00003o0?oooiX0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`030?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
on`0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooj`3oool6
0000o`H0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo/0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?oooo00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo00oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<n0?ooo`<00000o`3ooon_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool00`000000oooo0?ooo`3o0?ooojh0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<40?ooo`<000000P3oool3000000030?ooo`000000
000000D000000P3oool400000080oooo1P0000060?ooo`@0000000<0oooo00000000000010000003
0?ooo`H0000000<0oooo0000000000000`0000040?ooo`@0000000@0oooo0000003oool00000o`3o
oonR0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000D0oooo00@000000?ooo`3oool000001`3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool2000000P0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`000000o`3ooonU0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000<000000P3oool0
0`000000oooo0?ooo`04000000@0oooo00<000000?ooo`3oool00P0000050?ooo`040000003oool0
oooo00000080oooo1@0000050?ooo`040000003oool0oooo00000080oooo00<000000?ooo`000000
0P3oool010000000oooo0?ooo`0000020?ooo`030000003oool000000?l0ooooY@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0oooo1P0000001@3oool000000?ooo`3oool00000
0080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`3oool2000000030?ooo`00
0000oooo00H0oooo00@000000?ooo`3oool000000P3oool200000080oooo00<000000?ooo`3oool0
0P3oool200000080oooo00H000000?ooo`3oool000000?ooo`0000020?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`000000o`3ooonU0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c1@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo008000000P3oool4
000000030?ooo`000000000000D0oooo00<000000?ooo`3oool00`0000030?ooo`<0000000@0oooo
00000000000000000P3oool2000000H0oooo00<000000?ooo`0000000`0000000`3oool000000000
000200000080oooo0P0000000`3oool0000000000003000000030?ooo`000000oooo0?l0ooooX@3o
ool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0J0?ooo`040000003oool0oooo000001l0oooo00<000000?ooo`3oool0
o`3ooonS0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo01`0oooo0P00003o0?oool80oooo10000?l60?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<`@0oooo0`0000020?ooo`<000004@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0o`3ooonf0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooo/0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
m`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooog0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooog0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooL0oooo
00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooo/0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<X0?ooo`<00000
o`3oooo50?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c:@3oool200000?l0oooo
a@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bX0oooo0P00003o0?oool@0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`P000001@3oool2000000@0oooo
0P0000060?ooo`H00000103oool2000000<0oooo0P0000020?ooo`8000000P3oool2000000030?oo
o`000000000000<000000`3oool4000000<0oooo0P0000020?ooo`8000000P3oool4000000L0oooo
1P0000030?ooo`D000000P3oool200000080oooo0P0000020?ooo`800000o`3ooomj0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool8000000D0oooo0P0000040?ooo`800000
1@3oool2000000@0oooo0P0000030?ooo`8000000`3oool200000080oooo0P0000020?ooo`800000
00D0oooo00000000000000000?ooo`02000000030?ooo`00000000000080oooo0P0000020?ooo`80
00000P3oool2000000030?ooo`00000000000080oooo0P0000050?ooo`800000103oool200000004
0?ooo`00000000000?ooo`<000000P3oool200000080oooo0P0000020?ooo`800000o`3ooomj0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool8000000H0oooo0P0000020?oo
o`8000001P3oool2000000@0oooo0P0000020?ooo`@000000P3oool200000080oooo0P0000020?oo
o`80000000<0oooo0000000000000P3oool2000000030?ooo`00000000000080oooo0P0000020?oo
o`8000000P3oool2000000030?ooo`00000000000080oooo0P0000050?ooo`800000103oool20000
00030?ooo`00000000000080oooo0P0000020?ooo`8000000P3oool200000080oooo0P00003o0?oo
ogX0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<50?ooo`P000001P3oool60000
00`0oooo0P0000020?ooo`@000000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000
000000000P3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`8000000P3oool20000
00030?ooo`000000000000l0oooo0P0000000`3oool00000000000020?ooo`8000000P3oool20000
0080oooo0P0000020?ooo`800000o`3ooomj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c1@3oool8000000H0oooo0P0000020?ooo`8000002P3oool3000000<0oooo100000020?oo
o`8000000P3oool200000080oooo0P0000000`3oool00000000000020?ooo`80000000<0oooo0000
000000000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000003@3oool30000
0080oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`800000o`3ooomj0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1@3oool8000000L0oooo100000080?oo
o`@000001@3oool400000080oooo0P0000020?ooo`8000000P3oool2000000030?ooo`0000000000
0080oooo0P0000000`3oool00000000000020?ooo`8000000P3oool200000080oooo0P0000000`3o
ool00000000000020?ooo`8000001P3oool4000000@0oooo0P0000020?ooo`8000000P3oool20000
0080oooo0P0000020?ooo`800000o`3ooomj0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c1@3oool8000000L0oooo100000070?ooo`8000001`3oool200000080oooo0P0000001@3o
ool00000000000000000oooo00<0000000@0oooo000000000000oooo0`000000103oool000000000
003oool200000080oooo0P0000020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0P0000050?ooo`8000001`3oool200000080oooo0P0000020?ooo`<0000000D0oooo000000000000
00000?ooo`0200000?l0ooooNP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`D0
oooo200000070?ooo`@000001`3oool2000000@0oooo0P0000000`3oool00000000000020?ooo`80
000000<0oooo0000000000000`000000103oool000000000000000020?ooo`D000000`3oool40000
00<0oooo0P0000020?ooo`8000000P3oool4000000H0oooo0P0000040?ooo`80000000<0oooo0000
000000000P3oool200000080oooo1@000000103oool0000000000000003o0?ooog/0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<D0?ooo`@000001`3oool2000000@0oooo0P00000C
0?ooo`8000003@3oool200000100oooo0P0000040?ooo`800000o`3ooon:0?ooo`@0003o1P3oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<E0?ooo`8000002@3oool6000001@0oooo0P00000=0?ooo`8000000P3oool2
000000d0oooo1P00003o0?ooohh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooon`0oooo1@000?l20?ooo`D0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o
0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIWo03<c<ol0<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VI
V@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@3UiND0o`3UiNGo0>GUi@L0iNGU0@0c<c<10?ooo`0000<0oooo0>GUi@3UiND0o`3U
iNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 202},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.11"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.12 Creating Your Own Palettes", "Subsection",
  CellTags->{"S1.10.12", "12.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " notebook front end comes with a collection of standard palettes. But it \
also allows you to create your own palettes.  "
}], "Text",
  CellTags->{"S1.10.12", "12.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Set up a blank palette using ",
              StyleBox["Create Table/Matrix/Palette", "SR"],
              " under the ",
              StyleBox["Input", "SR"],
              " menu "
            }]]},
          {Cell["\[FilledSmallSquare] Fill in the contents "]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Make the palette active using ",
              StyleBox["Generate Palette from Selection", "SR"],
              " under the ",
              StyleBox["File", "SR"],
              " menu "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.12"],

Cell["The basic steps in creating a palette. ", "Caption",
  CellTags->"S1.10.12"],

Cell[TextData[{
  StyleBox["Create Table/Matrix/Palette", "SR"],
  " will create a blank palette."
}], "MathCaption",
  CellTags->{"S1.10.12", "12.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000@b000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o
0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?oooo80oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?oood400000o`3ooomi0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<l0?ooo``0E5AD00<0oooo05ADE01DE5@02P1DE5@00`3oool0E5AD05ADE00:05AD
E0030?ooo`1DE5@0E5AD00X0E5AD00<0oooo05ADE01DE5@02P1DE5@00`000000oooo0?ooo`3o0?oo
ogL0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<c`0oooo2`3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0
e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE0000000
oooo0?l0ooooN03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool;0=KFeP0305ADE03oool0e]KF00X0e]KF00<0
E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0
E5AD0000003oool0o`3ooomh0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`/0e]KF00<0E5AD0?ooo`3Fe]H0
2P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H0
2P3Fe]H00`1DE5@000000?ooo`3o0?ooogP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo2`3Fe]H00`1DE5@0
oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0
oooo0=KFeP0:0=KFeP0305ADE0000000oooo0?l0ooooN03oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool30=KF
ePH000000P3Fe]H00`1DE5@0oooo0=KFeP020=KFePH000000P3Fe]H00`1DE5@0oooo0=KFeP020=KF
ePH000000P3Fe]H00`1DE5@0oooo0=KFeP020=KFePH000000P3Fe]H00`1DE5@0oooo0=KFeP020=KF
ePH000000P3Fe]H00`1DE5@000000?ooo`3o0?ooogP0oooo00<0003o0?ooo`3oool01@3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo0`3Fe]H0
0`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF0=KF
eP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000
003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05AD
E03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05ADE0000000o`3ooomi
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<l0?ooo`<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KF
eP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo00<0
e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<000000=KF
eP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H0
1@000000e]KF0=KFeP1DE5@000000?l0ooooN@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool30=KFeP030000
003Fe]H0e]KF0080e]KF00D000000=KFeP3Fe]H0E5AD0?ooo`030=KFeP030000003Fe]H0e]KF0080
e]KF00D000000=KFeP3Fe]H0E5AD0?ooo`030=KFeP030000003Fe]H0e]KF0080e]KF00D000000=KF
eP3Fe]H0E5AD0?ooo`030=KFeP030000003Fe]H0e]KF0080e]KF00D000000=KFeP3Fe]H0E5AD0?oo
o`030=KFeP030000003Fe]H0e]KF0080e]KF00D000000=KFeP3Fe]H0E5AD0000003o0?ooogT0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<c`0oooo0`3Fe]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05AD
E03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3Fe]H0
0`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF0=KF
eP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000
003Fe]H0e]KF05ADE0000000o`3ooomi0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`<0e]KF1P0000020=KF
eP0305ADE03oool0e]KF0080e]KF1P0000020=KFeP0305ADE03oool0e]KF0080e]KF1P0000020=KF
eP0305ADE03oool0e]KF0080e]KF1P0000020=KFeP0305ADE03oool0e]KF0080e]KF1P0000020=KF
eP0305ADE0000000oooo0?l0ooooN03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool;0=KFeP0305ADE03oool0
e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0
e]KF00X0e]KF00<0E5AD0000003oool0o`3ooomh0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`/0e]KF00<0
E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0
E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@000000?ooo`3o0?ooogP0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo
2`3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H0
2P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE0000000oooo0?l0ooooN03oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c?03oool;0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0
oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0000003oool0o`3ooomh0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=l0?ooo`030000003oool0oooo0?l0ooooM`3oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool<
05ADE0030?ooo`1DE5@0E5AD00X0E5AD00<0oooo05ADE01DE5@02P1DE5@00`3oool0E5AD05ADE00:
05ADE0030?ooo`1DE5@0E5AD00X0E5AD00<000000?ooo`3oool0o`3ooomg0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<l0?ooo`/0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03o
ool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@000000?ooo`3o0?ooogP0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<c`0oooo2`3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF
00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE0000000oooo0?l0oooo
N03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c?03oool;0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3F
e]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0000003o
ool0o`3ooomh0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`/0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1D
E5@0oooo0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1D
E5@000000?ooo`3o0?ooogP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo0`3Fe]H600000080e]KF00<0E5AD
0?ooo`3Fe]H00P3Fe]H600000080e]KF00<0E5AD0?ooo`3Fe]H00P3Fe]H600000080e]KF00<0E5AD
0?ooo`3Fe]H00P3Fe]H600000080e]KF00<0E5AD0?ooo`3Fe]H00P3Fe]H600000080e]KF00<0E5AD
0000003oool0o`3ooomh0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`<0e]KF00<000000=KFeP3Fe]H00P3F
e]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF
0=KFeP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo
00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<00000
0=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@000000?l0ooooN@3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
?03oool30=KFeP030000003Fe]H0e]KF0080e]KF00D000000=KFeP3Fe]H0E5AD0?ooo`030=KFeP03
0000003Fe]H0e]KF0080e]KF00D000000=KFeP3Fe]H0E5AD0?ooo`030=KFeP030000003Fe]H0e]KF
0080e]KF00D000000=KFeP3Fe]H0E5AD0?ooo`030=KFeP030000003Fe]H0e]KF0080e]KF00D00000
0=KFeP3Fe]H0E5AD0?ooo`030=KFeP030000003Fe]H0e]KF0080e]KF00D000000=KFeP3Fe]H0E5AD
0000003o0?ooogT0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo0`3Fe]H00`000000e]KF0=KFeP020=KFeP05
0000003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF
05ADE03oool00`3Fe]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3F
e]H00`000000e]KF0=KFeP020=KFeP050000003Fe]H0e]KF05ADE03oool00`3Fe]H00`000000e]KF
0=KFeP020=KFeP050000003Fe]H0e]KF05ADE0000000o`3ooomi0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l0?oo
o`<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<00000
0=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3F
e]H01@000000e]KF0=KFeP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF
0=KFeP1DE5@0oooo00<0e]KF00<000000=KFeP3Fe]H00P3Fe]H01@000000e]KF0=KFeP1DE5@00000
0?l0ooooN@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool30=KFePH000000P3Fe]H00`1DE5@0oooo0=KFeP02
0=KFePH000000P3Fe]H00`1DE5@0oooo0=KFeP020=KFePH000000P3Fe]H00`1DE5@0oooo0=KFeP02
0=KFePH000000P3Fe]H00`1DE5@0oooo0=KFeP020=KFePH000000P3Fe]H00`1DE5@000000?ooo`3o
0?ooogP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<c`0oooo2`3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03o
ool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE000
0000oooo0?l0ooooM`3oool20000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<l0?ooo`/0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo
0=KFeP0:0=KFeP0305ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@00000
0?ooo`3o0?ooogH0oooo00<0003o0?ooo`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<c`0oooo2`3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP03
05ADE03oool0e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP03
05ADE0000000oooo0?l0ooooM@3oool010000?l0oooo0?ooo`000?l70?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?03oool;0=KFeP0305ADE03oool0
e]KF00X0e]KF00<0E5AD0?ooo`3Fe]H02P3Fe]H00`1DE5@0oooo0=KFeP0:0=KFeP0305ADE03oool0
e]KF00X0e]KF00<0E5AD0000003oool0o`3ooomd0?ooo`050000o`3oool0oooo0?ooo`000?l01`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
l@3oool60000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VI
V@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0
VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`00o`3U
iNGo0>GUi@X0iNGU0@0c<c<10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 67},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell["You can then insert whatever you want into each button.", "MathCaption",
  CellTags->{"S1.10.12", "12.4"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000AB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
ooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<l
0?oooh@00000o`3oooln0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<c?@3oool@05ADE0030=KFeP3oool0E5AD0240E5AD00<0e]KF0?ooo`1DE5@09`1D
E5@00`3Fe]H0oooo0=KFeP0?05ADE0030=KFeP3oool0E5AD00h0E5AD00<0e]KF0000003oool0o`3o
oolm0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
?@3oool?0=KFeP0305ADE03Fe]H0oooo0240e]KF00<0E5AD0=KFeP3oool09`3Fe]H00`1DE5@0e]KF
0?ooo`0?0=KFeP0305ADE03Fe]H0oooo00h0e]KF00<0E5AD0=KFeP000000o`3oooln0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?@3oool?0=KFeP03
05ADE03Fe]H0oooo0240e]KF00<0E5AD0=KFeP3oool09`3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP03
05ADE03Fe]H0oooo00h0e]KF00<0E5AD0=KFeP000000o`3ooolc0?ooo`D0003o1P3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cd0oooo3`3Fe]H00`1D
E5@0e]KF0?ooo`0Q0=KFeP0305ADE03Fe]H0oooo02L0e]KF00<0E5AD0=KFeP3oool03`3Fe]H00`1D
E5@0e]KF0?ooo`0>0=KFeP0305ADE03Fe]H000000?l0oooo=`3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?@3oool?
0=KFeP0305ADE03Fe]H0oooo0240e]KF00<0E5AD0=KFeP3oool09`3Fe]H00`1DE5@0e]KF0?ooo`0?
0=KFeP0305ADE03Fe]H0oooo00h0e]KF00<0E5AD0=KFeP000000o`3ooolg0?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool08@3Fe]H00`1DE5@0e]KF0?ooo`0W0=KFeP0305ADE03F
e]H0oooo00l0e]KF00<0E5AD0=KFeP3oool03P3Fe]H00`1DE5@0e]KF0000003o0?ooocL0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<cd0oooo1@3Fe]H6000000@0e]KF00<0E5AD0=KFeP3oool03P3Fe]H6000000d0e]KF
00<0E5AD0=KFeP3oool04@3Fe]H600000100e]KF00<0E5AD0=KFeP3oool01@3Fe]H6000000@0e]KF
00<0E5AD0=KFeP3oool01@3Fe]H6000000<0e]KF00<0E5AD0=KFeP000000o`3ooolg0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<m0?ooo`D0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP020=KFeP03
05ADE03Fe]H0oooo00h0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP0;0=KFeP03
05ADE03Fe]H0oooo0140e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP0>0=KFeP03
05ADE03Fe]H0oooo00D0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP020=KFeP03
05ADE03Fe]H0oooo00D0e]KF00<000000=KFeP3Fe]H00P3Fe]H01`000000e]KF0=KFeP3Fe]H0E5AD
0=KFeP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`D0e]KF00<000000=KFeP3Fe]H00P3F
e]H00`000000e]KF0=KFeP020=KFeP0305ADE03Fe]H0oooo00h0e]KF00<000000=KFeP3Fe]H00P3F
e]H00`000000e]KF0=KFeP0;0=KFeP0305ADE03Fe]H0oooo0140e]KF00<000000=KFeP3Fe]H00P3F
e]H00`000000e]KF0=KFeP0>0=KFeP0305ADE03Fe]H0oooo00D0e]KF00<000000=KFeP3Fe]H00P3F
e]H00`000000e]KF0=KFeP020=KFeP0305ADE03Fe]H0oooo00D0e]KF00<000000=KFeP3Fe]H00P3F
e]H01`000000e]KF0=KFeP3Fe]H0E5AD0=KFeP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?oo
o`D0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP020=KFeP0305ADE03Fe]H0oooo
00h0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP0;0=KFeP0305ADE03Fe]H0oooo
0140e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP0>0=KFeP0305ADE03Fe]H0oooo
00D0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP020=KFeP0305ADE03Fe]H0oooo
00D0e]KF00<000000=KFeP3Fe]H00P3Fe]H01`000000e]KF0=KFeP3Fe]H0E5AD0=KFeP000000o`3o
oolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`D0e]KF1P0000040=KFeP0305ADE03Fe]H0oooo00h0e]KF
1P00000=0=KFeP0305ADE03Fe]H0oooo0140e]KF1P00000@0=KFeP0305ADE03Fe]H0oooo00D0e]KF
1P0000040=KFeP0305ADE03Fe]H0oooo00D0e]KF1P0000030=KFeP0305ADE03Fe]H000000?l0oooo
=`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c?@3oool?0=KFeP0305ADE03Fe]H0oooo0240e]KF00<0E5AD0=KFeP3o
ool09`3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP0305ADE03Fe]H0oooo00h0e]KF00<0E5AD0=KFeP00
0000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool08@3Fe]H00`1D
E5@0e]KF0?ooo`0W0=KFeP0305ADE03Fe]H0oooo00l0e]KF00<0E5AD0=KFeP3oool03P3Fe]H00`1D
E5@0e]KF0000003o0?ooocL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cd0oooo3`3Fe]H00`1DE5@0e]KF0?ooo`0Q
0=KFeP0305ADE03Fe]H0oooo02L0e]KF00<0E5AD0=KFeP3oool03`3Fe]H00`1DE5@0e]KF0?ooo`0>
0=KFeP0305ADE03Fe]H000000?l0oooo=`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?@3oool?0=KFeP0305ADE03F
e]H0oooo0240e]KF00<0E5AD0=KFeP3oool09`3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP0305ADE03F
e]H0oooo00h0e]KF00<0E5AD0=KFeP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF
00<0E5AD0=KFeP3oool08@3Fe]H00`1DE5@0e]KF0?ooo`0W0=KFeP0305ADE03Fe]H0oooo00l0e]KF
00<0E5AD0=KFeP3oool03P3Fe]H00`1DE5@0e]KF0000003o0?ooocL0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cd0
oooo3`3Fe]H00`1DE5@0e]KF0?ooo`0Q0=KFeP0305ADE03Fe]H0oooo02L0e]KF00<0E5AD0=KFeP3o
ool03`3Fe]H00`1DE5@0e]KF0?ooo`0>0=KFeP0305ADE03Fe]H000000?l0oooo=`3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<cC@3oool00`3Fe]H0oooo0?ooo`0Q0?ooo`030=KFeP3oool0oooo02L0oooo00<0e]KF0?oo
o`3oool03`3oool00`3Fe]H0oooo0?ooo`0>0?ooo`030=KFeP000000oooo0?l0oooo=P3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c?03ooon30=KFeP030000003oool0oooo0?l0oooo=@3oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?@3o
ool@05ADE0030=KFeP3oool0E5AD0240E5AD00<0e]KF0?ooo`1DE5@09`1DE5@00`3Fe]H0oooo0=KF
eP0?05ADE0030=KFeP3oool0E5AD00h0E5AD00<0e]KF0000003oool0o`3ooolf0?ooo`030000o`3o
ool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool08@3Fe]H00`1DE5@0e]KF0?ooo`0W0=KFeP0305AD
E03Fe]H0oooo00l0e]KF00<0E5AD0=KFeP3oool03P3Fe]H00`1DE5@0e]KF0000003o0?ooocL0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<cd0oooo3`3Fe]H00`1DE5@0e]KF0?ooo`0Q0=KFeP0305ADE03Fe]H0oooo02L0
e]KF00<0E5AD0=KFeP3oool03`3Fe]H00`1DE5@0e]KF0?ooo`0>0=KFeP0305ADE03Fe]H000000?l0
oooo=`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<c?@3oool?0=KFeP0305ADE03Fe]H0oooo0240e]KF00<0E5AD0=KF
eP3oool09`3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP0305ADE03Fe]H0oooo00h0e]KF00<0E5AD0=KF
eP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool05`3Fe]H0
0`000000e]KF0=KFeP070=KFeP0305ADE03Fe]H0oooo01T0e]KF0P00000<0=KFeP0305ADE03Fe]H0
oooo00l0e]KF00<0E5AD0=KFeP3oool03P3Fe]H00`1DE5@0e]KF0000003o0?ooocL0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<cd0oooo3`3Fe]H00`1DE5@0e]KF0?ooo`0G0=KFeP030000003Fe]H0e]KF00L0e]KF00<0
E5AD0=KFeP3oool06@3Fe]H00`000000e]KF0000000;0=KFeP0305ADE03Fe]H0oooo00l0e]KF00<0
E5AD0=KFeP3oool03P3Fe]H00`1DE5@0e]KF0000003o0?ooocL0oooo00<0003o0?ooo`3oool0103o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cd0oooo
1P3Fe]H3000000030=KFeP000000000000<0e]KF00<0E5AD0=KFeP3oool01@3Fe]H5000000L0e]KF
00<000000=KFeP3Fe]H00`3Fe]H5000000D0e]KF00<0E5AD0=KFeP3oool0103Fe]H6000000L0e]KF
00<000000=KFeP3Fe]H01@3Fe]H00`000000e]KF0000000;0=KFeP0305ADE03Fe]H0oooo00D0e]KF
1P0000040=KFeP0305ADE03Fe]H0oooo00D0e]KF1P0000030=KFeP0305ADE03Fe]H000000?l0oooo
=`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c?@3oool60=KFeP030000003Fe]H0e]KF00800000103Fe]H00`1DE5@0
e]KF0?ooo`070=KFeP030000003Fe]H0e]KF00L0e]KF00<000000=KFeP3Fe]H0103Fe]H01@000000
e]KF0=KFeP3Fe]H0000000@0e]KF00<0E5AD0=KFeP3oool01@3Fe]H200000080e]KF00<000000=KF
eP3Fe]H01@3Fe]H00`000000e]KF0=KFeP050=KFeP<000002`3Fe]H00`1DE5@0e]KF0?ooo`050=KF
eP030000003Fe]H0e]KF0080e]KF00<000000=KFeP3Fe]H00P3Fe]H00`1DE5@0e]KF0?ooo`050=KF
eP030000003Fe]H0e]KF0080e]KF00L000000=KFeP3Fe]H0e]KF05ADE03Fe]H000000?l0oooo=`3o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c?@3oool60=KFeP050000003Fe]H0e]KF0=KFeP000000103Fe]H00`1DE5@0
e]KF0?ooo`070=KFeP030000003Fe]H0e]KF00D0e]KF1@0000040=KFeP030000003Fe]H0e]KF0080
0000103Fe]H00`1DE5@0e]KF0?ooo`060=KFeP<000001P3Fe]H5000000H0e]KF0P00000;0=KFeP03
05ADE03Fe]H0oooo00D0e]KF00<000000=KFeP3Fe]H00P3Fe]H00`000000e]KF0=KFeP020=KFeP03
05ADE03Fe]H0oooo00D0e]KF00<000000=KFeP3Fe]H00P3Fe]H01`000000e]KF0=KFeP3Fe]H0E5AD
0=KFeP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`H0e]KF0P0000020=KFeP030000003F
e]H0e]KF0080e]KF00<0E5AD0=KFeP3oool01`3Fe]H00`000000e]KF0=KFeP070=KFeP030000003F
e]H0e]KF00@0e]KF00@000000=KFeP00000000001@3Fe]H00`1DE5@0e]KF0?ooo`080=KFeP800000
1`3Fe]H00`000000e]KF0=KFeP040=KFePD000002P3Fe]H00`1DE5@0e]KF0?ooo`050=KFeP030000
003Fe]H0e]KF0080e]KF00<000000=KFeP3Fe]H00P3Fe]H00`1DE5@0e]KF0?ooo`050=KFeP030000
003Fe]H0e]KF0080e]KF00L000000=KFeP3Fe]H0e]KF05ADE03Fe]H000000?l0oooo=`3oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c?@3oool70=KFeP<0000000<0e]KF0000003Fe]H00P3Fe]H00`1DE5@0e]KF0?ooo`05
0=KFeP030000003Fe]H0000000T0e]KF00<000000=KFeP3Fe]H0103Fe]H2000000030=KFeP000000
000000@0e]KF00<0E5AD0=KFeP3oool02@3Fe]H00`000000e]KF0=KFeP050=KFeP030000003Fe]H0
e]KF00<0e]KF0P0000030=KFeP80000000@0e]KF00000000000000001@3Fe]H00`1DE5@0e]KF0?oo
o`050=KFePH00000103Fe]H00`1DE5@0e]KF0?ooo`050=KFePH000000`3Fe]H00`1DE5@0e]KF0000
003o0?ooocL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<cd0oooo3`3Fe]H00`1DE5@0e]KF0?ooo`040=KFeP@00000
4@3Fe]H010000000e]KF0=KFeP0000040=KFeP0305ADE03Fe]H0oooo00D0e]KF00D000000=KFeP3F
e]H0e]KF0000000E0=KFeP<000001@3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP0305ADE03Fe]H0oooo
00h0e]KF00<0E5AD0=KFeP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF00<0E5AD
0=KFeP3oool01P3Fe]H200000140e]KF0`0000050=KFeP0305ADE03Fe]H0oooo00D0e]KF1000000G
0=KFeP8000001@3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP0305ADE03Fe]H0oooo00h0e]KF00<0E5AD
0=KFeP000000o`3ooolg0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool08@3F
e]H00`1DE5@0e]KF0?ooo`0Q0=KFeP030000003Fe]H0e]KF00<0e]KF00<0E5AD0=KFeP3oool03`3F
e]H00`1DE5@0e]KF0?ooo`0>0=KFeP0305ADE03Fe]H000000?l0oooo=P3oool20000o`H0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF
00<0E5AD0=KFeP3oool08@3Fe]H00`1DE5@0e]KF0?ooo`0O0=KFeP8000001P3Fe]H00`1DE5@0e]KF
0?ooo`0?0=KFeP0305ADE03Fe]H0oooo00h0e]KF00<0E5AD0=KFeP000000o`3ooole0?ooo`030000
o`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool08@3Fe]H00`1DE5@0e]KF0?ooo`0W0=KFeP03
05ADE03Fe]H0oooo00l0e]KF00<0E5AD0=KFeP3oool03P3Fe]H00`1DE5@0e]KF0000003o0?oooc@0
oooo00@0003o0?ooo`3oool0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<cd0oooo3`3Fe]H00`1DE5@0e]KF0?ooo`0Q0=KFeP0305ADE03Fe]H0
oooo02L0e]KF00<0E5AD0=KFeP3oool03`3Fe]H00`1DE5@0e]KF0?ooo`0>0=KFeP0305ADE03Fe]H0
00000?l0oooo<`3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`l0e]KF00<0E5AD0=KFeP3oool0
8@3Fe]H00`1DE5@0e]KF0?ooo`0W0=KFeP0305ADE03Fe]H0oooo00l0e]KF00<0E5AD0=KFeP3oool0
3P3Fe]H00`1DE5@0e]KF0000003o0?oooc80oooo1P000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c?@3oool?0=KFeP0305ADE03Fe]H0oooo0240
e]KF00<0E5AD0=KFeP3oool09`3Fe]H00`1DE5@0e]KF0?ooo`0?0=KFeP0305ADE03Fe]H0oooo00h0
e]KF00<0E5AD0=KFeP000000o`3oooln0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cC@3oool00`3Fe]H0oooo0?ooo`0Q0?ooo`030=KFeP3oool0oooo
02L0oooo00<0e]KF0?ooo`3oool03`3oool00`3Fe]H0oooo0?ooo`0>0?ooo`030=KFeP000000oooo
0?l0oooo?@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o
09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c
<`40oooo003o0>GUiOl0iNGU2P3UiND103<c<`40oooo003o0>GUiOl0iNGU2`3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 69},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[TextData[{
  "The menu item ",
  StyleBox["Generate Palette from Selection", "SR"],
  " makes a separate active palette."
}], "MathCaption",
  CellTags->{"S1.10.12", "12.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000220000<2000`400?l00000o`00003oPP3oool0
0840<c<c0@3oool000030>k^kP0c<c<0<c<c07h0<c<c0@3oool000030>k^kP2IVIT0VIVI07`0VIVI
0P0c<c<10?ooo`0000<0k^k^09VIV@2IVIT0O02IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@1l
09VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIVGP0k^k^0`2IVIT203<c<`40oooo0000103^
k^h0VIVI09VIV@2IVIT203<c<g@000000P3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c301EEED00`3oool0EEEE05EEE@0O05EEE@80oooo:01EEED20?ooo``0EEEE00<0oooo
05EEE@1EEED02P1EEED00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI
09VIV@80<c<c2`3MgMd00`1EEED0oooo0=gMg@0O0=gMg@0305EEE@3oool0oooo02L0gMgM00<0EEEE
0?ooo`3oool02`3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c
<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<;0=gMg@0305EEE@3oool0gMgM01l0gMgM00<0
EEEE0?ooo`3oool09`3MgMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0gMgM00@0
EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`/0gMgM
00<0EEEE0?ooo`3MgMd07`3MgMd00`1EEED0oooo0?ooo`0W0=gMg@0305EEE@3oool0oooo00/0gMgM
00<0EEEE0?ooo`3MgMd02P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^
kP2IVIT0VIVI09VIV@80<c<c2`3MgMd00`1EEED0oooo0=gMg@0O0=gMg@0305EEE@3oool0oooo02L0
gMgM00<0EEEE0?ooo`3oool02`3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0405EEE@000000k^k^0>k^
kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<30=gMg@H000000P3MgMd00`1E
EED0oooo0=gMg@0=0=gMg@H00000303MgMd00`1EEED0oooo0?ooo`0A0=gMg@H00000403MgMd00`1E
EED0oooo0?ooo`030=gMg@H000000P3MgMd00`1EEED0oooo0=gMg@020=gMg@H000000P3MgMd0101E
EED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd0
0`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@3oool03P3MgMd00`000000gMgM0=gM
g@020=gMg@030000003MgMd0gMgM00X0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`000000gMgM0=gM
g@020=gMg@030000003MgMd0gMgM00h0gMgM00<0EEEE0?ooo`3oool00`3MgMd00`000000gMgM0=gM
g@020=gMg@050000003MgMd0gMgM05EEE@3oool00`3MgMd00`000000gMgM0=gMg@020=gMg@050000
003MgMd0gMgM05EEE@0000000P3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VIV@80
<c<c0`3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@3oool03P3MgMd00`00
0000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00X0gMgM00<0EEEE0?ooo`3oool04@3MgMd00`00
0000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00h0gMgM00<0EEEE0?ooo`3oool00`3MgMd00`00
0000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@3oool00`3MgMd00`000000gMgM0=gMg@02
0=gMg@050000003MgMd0gMgM05EEE@0000000P3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0
VIVI09VIV@80<c<c0`3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@3oool0
3P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00X0gMgM00<0EEEE0?ooo`3oool0
4@3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00h0gMgM00<0EEEE0?ooo`3oool0
0`3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@3oool00`3MgMd00`000000
gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@0000000P3^k^h309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM
05EEE@3oool03P3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00X0gMgM00<0EEEE
0?ooo`3oool04@3MgMd00`000000gMgM0=gMg@020=gMg@030000003MgMd0gMgM00h0gMgM00<0EEEE
0?ooo`3oool00`3MgMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@3oool00`3M
gMd00`000000gMgM0=gMg@020=gMg@050000003MgMd0gMgM05EEE@0000000P3^k^h309VIV@80<c<c
0@3oool000040>k^kP2IVIT0VIVI09VIV@80<c<c0`3MgMd600000080gMgM00<0EEEE0?ooo`3MgMd0
3@3MgMd6000000`0gMgM00<0EEEE0?ooo`3oool04@3MgMd600000100gMgM00<0EEEE0?ooo`3oool0
0`3MgMd600000080gMgM00<0EEEE0?ooo`3MgMd00P3MgMd600000080gMgM00@0EEEE0000003^k^h0
k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`/0gMgM00<0EEEE0?ooo`3M
gMd07`3MgMd00`1EEED0oooo0?ooo`0W0=gMg@0305EEE@3oool0oooo00/0gMgM00<0EEEE0?ooo`3M
gMd02P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0VIVI09VI
V@80<c<c2`3MgMd00`1EEED0oooo0=gMg@0O0=gMg@0305EEE@3oool0oooo02L0gMgM00<0EEEE0?oo
o`3oool02`3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0405EEE@000000k^k^0>k^kP<0VIVI0P0c<c<1
0?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<;0=gMg@0305EEE@3oool0gMgM01l0gMgM00<0EEEE
0?ooo`3oool09`3MgMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0gMgM00@0EEEE
0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`/0gMgM00<0
EEEE0?ooo`3MgMd07`3MgMd00`1EEED0oooo0?ooo`0W0=gMg@0305EEE@3oool0oooo00/0gMgM00<0
EEEE0?ooo`3MgMd02P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<cL`3oool00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<cL`3oool00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<c301EEED00`3oool0EEEE05EEE@0O05EEE@80oooo:01EEED20?ooo``0EEEE
00<0oooo05EEE@1EEED02P1EEED00`000000k^k^0>k^kP0309VIV@80<c<c0@3oool000040>k^kP2I
VIT0VIVI09VIV@80<c<c2`3MgMd00`1EEED0oooo0=gMg@0O0=gMg@0305EEE@3oool0oooo02L0gMgM
00<0EEEE0?ooo`3oool02`3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0405EEE@000000k^k^0>k^kP<0
VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<;0=gMg@0305EEE@3oool0gMgM01l0
gMgM00<0EEEE0?ooo`3oool09`3MgMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0
gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c
<`/0gMgM00<0EEEE0?ooo`3MgMd05P3MgMd2000000L0gMgM00<0EEEE0?ooo`3oool06P3MgMd20000
00/0gMgM00<0EEEE0?ooo`3oool02`3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0405EEE@000000k^k^
0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<;0=gMg@0305EEE@3oool0
gMgM01H0gMgM0P0000070=gMg@0305EEE@3oool0oooo01T0gMgM00@000000=gMg@00000000002P3M
gMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0gMgM00@0EEEE0000003^k^h0k^k^
0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`<0gMgM0`0000000`3MgMd00000
000000020=gMg@0305EEE@3oool0gMgM0080gMgM1P0000070=gMg@030000003MgMd0gMgM00D0gMgM
1@0000030=gMg@0305EEE@3oool0oooo00<0gMgM1P0000070=gMg@030000003MgMd0gMgM00H0gMgM
00@000000=gMg@00000000002P3MgMd00`1EEED0oooo0?ooo`030=gMg@H000000P3MgMd00`1EEED0
oooo0=gMg@020=gMg@H000000P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool00004
0>k^kP2IVIT0VIVI09VIV@80<c<c0P3MgMd2000000040=gMg@0000000000000000<0gMgM00<0EEEE
0?ooo`3MgMd0103MgMd2000000T0gMgM00<000000=gMg@3MgMd01@3MgMd200000080gMgM0P000002
0=gMg@0305EEE@3oool0oooo00<0gMgM0P0000020=gMg@8000001`3MgMd00`000000gMgM0=gMg@07
0=gMg@<000002P3MgMd00`1EEED0oooo0?ooo`030=gMg@030000003MgMd0gMgM0080gMgM00D00000
0=gMg@3MgMd0EEEE0?ooo`030=gMg@030000003MgMd0gMgM0080gMgM00D000000=gMg@3MgMd0EEEE
000000020>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<20=gMg@800000
0P3MgMd2000000<0gMgM00<0EEEE0?ooo`3MgMd0103MgMd2000000L0gMgM1@0000050=gMg@800000
0P3MgMd200000080gMgM00<0EEEE0?ooo`3oool0103MgMd2000000P0gMgM1@0000070=gMg@800000
2`3MgMd00`1EEED0oooo0?ooo`030=gMg@030000003MgMd0gMgM0080gMgM00D000000=gMg@3MgMd0
EEEE0?ooo`030=gMg@030000003MgMd0gMgM0080gMgM00D000000=gMg@3MgMd0EEEE000000020>k^
kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<20=gMg@8000000P3MgMd20000
00<0gMgM00<0EEEE0?ooo`3MgMd0103MgMd2000000T0gMgM00<000000=gMg@3MgMd01@3MgMd20000
0080gMgM0P0000020=gMg@0305EEE@3oool0oooo00D0gMgM0P0000090=gMg@030000003MgMd0gMgM
00H0gMgM1000000:0=gMg@0305EEE@3oool0oooo00<0gMgM00<000000=gMg@3MgMd00P3MgMd01@00
0000gMgM0=gMg@1EEED0oooo00<0gMgM00<000000=gMg@3MgMd00P3MgMd01@000000gMgM0=gMg@1E
EED000000080k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`<0gMgM1P00
00020=gMg@0305EEE@3oool0gMgM00@0gMgM0P0000090=gMg@030000003MgMd0gMgM00H0gMgM1000
00030=gMg@0305EEE@3oool0oooo00H0gMgM0P0000080=gMg@030000003MgMd0gMgM00D0gMgM0P00
00020=gMg@L00000103MgMd00`1EEED0oooo0?ooo`030=gMg@030000003MgMd0gMgM0080gMgM00D0
00000=gMg@3MgMd0EEEE0?ooo`030=gMg@030000003MgMd0gMgM0080gMgM00D000000=gMg@3MgMd0
EEEE000000020>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVI0P0c<c<40=gMg@80
00000P3MgMd01@000000gMgM0=gMg@1EEED0oooo00<0gMgM1000000B0=gMg@80000000<0gMgM0000
000000000P3MgMd00`1EEED0oooo0?ooo`070=gMg@8000003P3MgMd2000000@0gMgM00@000000=gM
g@00000000001P3MgMd00`1EEED0oooo0?ooo`030=gMg@H000000P3MgMd00`1EEED0oooo0=gMg@02
0=gMg@H000000P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3oool000040>k^kP2IVIT0
VIVI09VIV@80<c<c2`3MgMd00`1EEED0oooo0=gMg@030=gMg@<000004P3MgMd2000000030=gMg@00
000000000080gMgM00<0EEEE0?ooo`3oool00`3MgMd200000080gMgM0P00000G0=gMg@8000001@3M
gMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0gMgM00@0EEEE0000003^k^h0k^k^
0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`/0gMgM00<0EEEE0?ooo`3MgMd0
103MgMd2000001<0gMgM0`0000030=gMg@0305EEE@3oool0oooo00@0gMgM1000000I0=gMg@800000
103MgMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0gMgM00@0EEEE0000003^k^h0
k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`/0gMgM00<0EEEE0?ooo`3M
gMd07`3MgMd00`1EEED0oooo0?ooo`0N0=gMg@80000000<0gMgM000000000000103MgMd00`1EEED0
oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM00X0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c
<`40oooo0000103^k^h0VIVI09VIV@2IVIT203<c<`/0gMgM00<0EEEE0?ooo`3MgMd07`3MgMd00`1E
EED0oooo0?ooo`0O0=gMg@<000001@3MgMd00`1EEED0oooo0?ooo`0;0=gMg@0305EEE@3oool0gMgM
00X0gMgM00@0EEEE0000003^k^h0k^k^0`2IVIT203<c<`40oooo0000103^k^h0VIVI09VIV@2IVIT2
03<c<`/0gMgM00<0EEEE0?ooo`3MgMd07`3MgMd00`1EEED0oooo0?ooo`0W0=gMg@0305EEE@3oool0
oooo00/0gMgM00<0EEEE0?ooo`3MgMd02P3MgMd0101EEED000000>k^kP3^k^h309VIV@80<c<c0@3o
ool000040>k^kP2IVIT0VIVI09VIV@80<c<c2`3MgMd00`1EEED0oooo0=gMg@0O0=gMg@0305EEE@3o
ool0oooo02L0gMgM00<0EEEE0?ooo`3oool02`3MgMd00`1EEED0oooo0=gMg@0:0=gMg@0405EEE@00
0000k^k^0>k^kP<0VIVI0P0c<c<10?ooo`0000@0k^k^09VIV@2IVIT0VIVIMP0c<c<20>k^kP<0VIVI
0P0c<c<10?ooo`0000<0k^k^09VIV@2IVIT0O02IVIT203<c<`40oooo00000`3^k^h0VIVI09VIV@1l
09VIV@80<c<c0@3oool000030>k^kP2IVIT0VIVI07`0VIVI0P0c<c<10?ooo`00P03^k^h103<c<`40
oooo00200>k^kP80oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{130, 48},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell["\<\
Clicking on a button in the palette now inserts its contents into \
your notebook.\
\>", "MathCaption",
  CellTags->{"S1.10.12", "12.6"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=R000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo@0oooo1@000?l5
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
oooh0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c=i0?ooo`800000o`3ooomm0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=h0?ooo`04
0000003oool0000000000?l0ooooO03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cH@3oool6000000P0oooo00<00000
0?ooo`3oool01P3oool010000000oooo00000000003o0?ooog`0oooo00<0003o0?ooo`3oool00`3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<f40oooo
0P0000020?ooo`800000203oool00`000000oooo0?ooo`070?ooo`<00000o`3oooml0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=R0?ooo`8000002@3oool5000000L0oooo0P00003o0?ooogd0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<f<0oooo0P00000:0?ooo`030000003oool0oooo00H0oooo1000003o0?ooog`0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<f@0oooo0P0000090?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`L00000o`3ooomf
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=U0?ooo`8000003`3oool2000000@0oooo00@000000?ooo`0000000000
o`3ooomh0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c=Q0?ooo`8000000P3oool2000001P0oooo0P00003o0?ooogL0
oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<f80oooo1000000J0?ooo`800000o`3ooomf0?ooo`030000o`3oool0oooo
00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=m
0?ooo`80000000<0oooo000000000000o`3ooomf0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=80?ooo`@00000<P3o
ool300000?l0ooooM`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cB@3oool200000?l0oooo[@3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c<`3oool6000000L0oooo00<000000?ooo`3oool01`3oool2000000T0oooo00<000000?ooo`3o
ool0o`3ooonP0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<d0?ooo`@00000203oool00`000000oooo0?ooo`070?oo
o`8000002@3oool00`000000oooo0?ooo`3o0?oooj00oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cD0oooo0P000007
0?ooo`D000001P3oool4000000H0oooo1@0000070?ooobL00000o`3ooomb0?ooo`030000o`3oool0
oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<e0?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`@00000203oool00`000000oooo0?oo
o`3o0?oooj00oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<c@0oooo100000080?ooo`030000003oool0oooo00D0oooo
0P0000020?ooo`8000001`3oool00`000000oooo0?ooo`3o0?oooj00oooo00<0003o0?ooo`3oool0
0`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c<0
oooo1P00000>0?ooo`P00000o`3ooonY0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooP0oooo00<0003o0?oo
o`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cK`3oool600000?l0ooooP`3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
L@3oool200000?l0ooooQ@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cL@3oool200000?l0ooooQ@3oool00`000?l0
oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<cL@3oool200000?l0ooooQ@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cL@3oool200000?l0ooooQ03oool2
0000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c=_0?ooo`@00000o`3ooon30?ooo`030000o`3oool0003o00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=`0?ooo`<00000o`3ooon20?ooo`040000
o`3oool0oooo0000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=a0?ooo`800000o`3ooon10?ooo`050000o`3oool0oooo0?ooo`000?l01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool`3o
ool60000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0
iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?oo
o`00o`3UiNGo0>GUi@X0iNGU0@0c<c<10?ooo`00o`3UiNGo0>GUi@/0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 54},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Create Table/Matrix/Palette", "SR"],
              " "
            }]], Cell["set up a blank palette "]},
          {Cell[TextData[{
              StyleBox["Generate Palette from Selection", "SR"],
              " "
            }]], Cell["make a separate active palette "]},
          {Cell[TextData[{
              StyleBox["Generate Notebook from Palette", "SR"],
              " "
            }]], Cell["convert a palette back into an editable notebook "]},
          {Cell[TextData[{
              StyleBox["Edit Button", "SR"],
              " "
            }]], Cell[
            "edit the script associated with a palette or button "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.12"],

Cell["Menu items for setting up palettes. ", "Caption",
  CellTags->"S1.10.12"],

Cell[TextData[{
  "When you are creating a palette, you can use the same mechanisms to add \
columns and rows as you can when you are creating any other kind of table, \
matrix or grid. Thus \[ControlKey]\[LeftModified]",
  StyleBox[",\[RightModified]", "MR"],
  " will add a new column of buttons, and \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
  "\[RightModified] (Control\[Hyphen]Enter) will add a new row. "
}], "Text",
  CellTags->{"S1.10.12", "12.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["button contents", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["action", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["X", "TI"],
              " "
            }]], Cell[TextData[{
              "replace current selection by ",
              StyleBox["X", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              "text containing ",
              StyleBox["X", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SelectionPlaceholder]\)], 
                "InlineFormula"],
              "Y",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "replace current selection ",
              StyleBox["S", "TI"],
              " by ",
              StyleBox["XSY", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S1.10.12"],

Cell["Contents of buttons. ", "Caption",
  CellTags->"S1.10.12"],

Cell["\<\
In the simplest case, when you press a button in a palette what \
will happen is that the contents of the button will be inserted into your \
notebook, replacing whatever your current selection was. \
\>", "Text",
  CellTags->{"S1.10.12", "12.8"}],

Cell[TextData[{
  "Sometimes however you may not simply want to overwrite your current \
selection, but rather you may want to modify the selection in some way. As an \
example, you might want to wrap a function like ",
  StyleBox["Expand", "MR"],
  " around your current selection.  "
}], "Text",
  CellTags->{"S1.10.12", "12.9"}],

Cell[TextData[{
  "You can do this by setting up a button with contents ",
  StyleBox["Expand[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  StyleBox["]", "MR"],
  ". The ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  " can be entered as \[AliasIndicator]",
  StyleBox["spl\[AliasIndicator]", "MR"],
  " or \[Backslash]",
  StyleBox["[SelectionPlaceholder]", "MR"],
  ". In general, ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  " serves as a placeholder for your current selection. When you press a \
button that contains ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  ", the ",
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  " is first replaced by your current selection, and only then is the result \
inserted into your notebook.    "
}], "Text",
  CellTags->{"S1.10.12", "12.10"}],

Cell["\<\
Here is a cell in which the current selection is part of an \
expression.\
\>", "MathCaption",
  CellTags->{"S1.10.12", "12.11"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooool03oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=D0?ooo`80
00007`3oool2000001T0oooo103Ng]h2000001L0g]kN100000040=kNgP8000002`3Ng]ko0?oooc80
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cD`3oool200000240oooo0P00000H0?ooo`<0g]kN0P00000I0=kNgP80
00001P3Ng]h2000000X0g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo1P00000:0?ooo`03
0000003oool0oooo00X0oooo0P0000030?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H0
00000`3oool200000140oooo00<000000?ooo`3oool0103oool30=kNgP8000000`3Ng]h6000000L0
g]kN00<000000=kNgP3Ng]h01`3Ng]h2000000D0g]kN0P00000:0=kNg_l0oooo<P3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<h0?ooo`800000303oool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0
oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00@0
oooo0P3Ng]h2000000@0g]kN0P0000020=kNgP8000001`3Ng]h00`000000g]kN0=kNgP070=kNgP80
00001P3Ng]h2000000T0g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P00000:0?ooo`D0
00002@3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0oooo0P00000>0?ooo`D0
0000103oool20=kNgP8000001@3Ng]h2000000P0g]kN1@0000060=kNgP@000001@3Ng]h2000000T0
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P00000<0?ooo`030000003oool0oooo00T0
oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool200000100
oooo00<000000?ooo`3oool0103oool20=kNgP8000001P3Ng]h2000000T0g]kN00<000000=kNgP3N
g]h01P3Ng]h4000000D0g]kN0P0000090=kNg_l0oooo<P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`80
0000303oool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3o
ool01P3oool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00@0oooo0P3Ng]h2000000L0
g]kN0P0000080=kNgP030000003Ng]h0g]kN00D0g]kN0P0000020=kNgP800000103Ng]h2000000T0
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo1000000I0?ooo`8000000`3oool400000140
oooo1P0000030?ooo`8000001P3oool200000100oooo0`3Ng]h2000000L0g]kN0P00000>0=kNgPP0
00000P3Ng]h2000000@0g]kN0`0000030=kNg_l0oooo<P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`<0
00006@3oool2000000@0oooo0`00000J0?ooo`8000001P3oool200000100oooo0`3Ng]h2000000<0
g]kN0P0000020=kNgP800000603Ng]h2000000<0g]kN0P0000000`3Ng]h00000000000020=kNg_l0
oooo<P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`8000006P3oool2000000@0oooo0P00000I0?ooo`80
0000103oool500000100oooo103Ng]h2000000<0g]kN1000000H0=kNgP8000001`3Ng]h200000080
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<g`0oooo1000000@0?ooobd0g]kN0P0000030=kNg_l0
oooo<@3oool20000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<gd0oooo0`00000@0?ooob/0g]kN0P0000000`3Ng]h00000000000020=kNg_l0
oooo<03oool00`000?l0oooo0000o`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=n0?ooo`800000403oool/0=kNgP<000000`3Ng]ko0?ooobl0
oooo00@0003o0?ooo`3oool0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`050000o`3oool0oooo0?ooo`000?l0203oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo_
0?ooo`H0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0
oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[TextData[{
  "Pressing a button containing ",
  StyleBox["Expand[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  StyleBox["]", "MR"],
  " wraps ",
  StyleBox["Expand", "MR"],
  " around the current selection. "
}], "MathCaption",
  CellTags->{"S1.10.12", "12.12"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo1@000?l6
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooog0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<e<0oooo0P00000O0?ooo`80
0000:@3oool4000001h0oooo100000050?ooo`8000005`3oool4000000@0oooo0P00000<0?ooo`@0
0000n@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cDP3oool200000240oooo0P00000Y0?ooo`8000007`3oool20000
00H0oooo0P00000I0?ooo`8000001P3oool2000000d0oooo0P00003i0?ooo`030000o`3oool0oooo
00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<e
0?ooo`H000002P3oool00`000000oooo0?ooo`0:0?ooo`8000000`3oool6000000L0oooo00<00000
0?ooo`3oool01@3oool6000000<0oooo0P00000A0?ooo`030000003oool0oooo00@0oooo1`000002
0?ooo`H000000P3oool5000000<0oooo1P0000000`3oool0000000000006000000030?ooo`000000
000000@000000`3oool2000000H0oooo0P0000030?ooo`H000001`3oool00`000000oooo0?ooo`07
0?ooo`8000001@3oool2000000d0oooo0P00003i0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<g0?ooo`800000303o
ool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3oool01P3o
ool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`8000000`3o
ool4000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P0000050?ooo`800000103o
ool200000080oooo0P0000070?ooo`030000003oool0oooo00L0oooo0P0000060?ooo`800000303o
ool200000?T0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<cL0oooo0P00000:0?ooo`D000002@3oool2000000H0oooo
0P0000070?ooo`D000001`3oool2000000H0oooo0P00000>0?ooo`D000001@3oool2000000P0oooo
0P0000040?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
0P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`8000001@3oool2000000D0oooo
0P0000080?ooo`D000001P3oool4000000D0oooo0P00000<0?ooo`800000n@3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c=`3oool2000000`0oooo00<000000?ooo`3oool02@3oool2000000H0oooo0P0000090?ooo`03
0000003oool0oooo00L0oooo0P0000060?ooo`800000403oool00`000000oooo0?ooo`050?ooo`@0
00001P3oool2000000@0oooo0P0000020?ooo`8000000P3oool5000000<0oooo0P0000020?ooo`80
000000<0oooo0000000000000P3oool2000000@0oooo0P0000050?ooo`8000001P3oool2000000T0
oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00000<0?ooo`800000n@3oool00`000?l0
oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c=`3oool2000000`0oooo00<000000?ooo`3oool02@3oool2000000H0oooo0P0000090?oo
o`030000003oool0oooo00H0oooo100000050?ooo`800000403oool00`000000oooo0?ooo`050?oo
o`@000001@3oool4000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool20000
00<0oooo0`000000103oool000000000003oool200000080oooo0P0000040?ooo`8000001@3oool2
000000L0oooo0P0000080?ooo`030000003oool0oooo00D0oooo0P0000020?ooo`800000103oool2
000000`0oooo0P00003i0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<e0?ooo`@000006@3oool2000000<0oooo1000
000A0?ooo`H000000`3oool2000000H0oooo0P00000A0?ooo`@00000103oool6000000030?ooo`00
0000000000@000000`3oool4000000<0oooo1P0000030?ooo`D00000103oool2000000H0oooo0P00
00070?ooo`8000003P3oool800000080oooo0P0000040?ooo`<000001P3oool200000?T0oooo00<0
003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<cH0oooo0`00000I0?ooo`800000103oool3000001X0oooo0P0000060?ooo`800000
4@3oool200000080oooo0P00000U0?ooo`800000103oool2000000H0oooo0P0000030?ooo`800000
0P3oool2000001P0oooo0P0000030?ooo`80000000<0oooo0000000000001@3oool200000?T0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<cL0oooo0P00000J0?ooo`800000103oool2000001T0oooo0P0000040?ooo`D0
0000403oool7000002@0oooo0`0000040?ooo`@000001@3oool2000000<0oooo1000000H0?ooo`80
00001`3oool2000000<0oooo1000003h0?ooo`80003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<g/0oooo1000001d0?ooo`800000o`3oool00`00
0?l0oooo0000o`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<cO03oool300000780oooo0P0000000`3oool000000000003m0?ooo`040000o`3oool0
oooo0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=m0?ooo`800000L`3oool300000?d0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooob0?oo
o`H0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VI
VOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40
oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo003o0>GUiOl0iNGU2P3U
iND103<c<`40oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to associate any action you want with a button. You can set up \
some common actions by using the ",
  StyleBox["Edit Button", "SR"],
  " menu, having selected either a single button or a whole palette. "
}], "Text",
  CellTags->{"S1.10.12", "12.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Paste", "MR"],
              " "
            }]], Cell["paste the contents of the button (default) "]},
          {Cell[TextData[{
              StyleBox["Evaluate", "MR"],
              " "
            }]], Cell["paste then evaluate in place what has been pasted "]},
          {Cell[TextData[{
              StyleBox["EvaluateCell", "MR"],
              " "
            }]], Cell["paste then evaluate the whole cell "]},
          {Cell[TextData[{
              StyleBox["CopyEvaluate", "MR"],
              " "
            }]], 
            Cell["\<\
copy the current selection into a new cell, then paste \
and evaluate in place \
\>"]},
          {Cell[TextData[{
              StyleBox["CopyEvaluateCell", "MR"],
              " "
            }]], 
            Cell["\<\
copy the current selection into a new cell, then paste \
and evaluate the whole cell \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.12"],

Cell["Typical actions for buttons. ", "Caption",
  CellTags->"S1.10.12"],

Cell[TextData[{
  "With the default ",
  StyleBox["Paste", "MR"],
  " setting for a button action, pressing the button modifies the contents of \
a cell but does no evaluation. By choosing other button actions, however, you \
can tell ",
  StyleBox["Mathematica", "TI"],
  " to perform an evaluation every time you press the button. "
}], "Text",
  CellTags->{"S1.10.12", "12.14"}],

Cell[TextData[{
  "With the button action ",
  StyleBox["Evaluate", "MR"],
  " the result of this evaluation is made to overwrite your current \
selection. This is useful if you want to set up a button which modifies parts \
of an expression in place, say by applying ",
  StyleBox["Expand[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  StyleBox["]", "MR"],
  " to them. "
}], "Text",
  CellTags->{"S1.10.12", "12.15"}],

Cell[TextData[{
  "The button action ",
  StyleBox["Evaluate", "MR"],
  " performs evaluation only on whatever was pasted into your current cell. \
The button action ",
  StyleBox["EvaluateCell", "MR"],
  ", on the other hand, performs evaluation on the whole cell, generating a \
new cell to show the result. "
}], "Text",
  CellTags->{"S1.10.12", "12.16"}],

Cell["Here is an expression with a part selected. ", "MathCaption",
  CellTags->{"S1.10.12", "12.17"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooool03oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=D0?ooo`80
00007`3oool2000001T0oooo103Ng]h2000001L0g]kN100000040=kNgP8000002`3Ng]ko0?oooc80
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cD`3oool200000240oooo0P00000H0?ooo`<0g]kN0P00000I0=kNgP80
00001P3Ng]h2000000X0g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo1P00000:0?ooo`03
0000003oool0oooo00X0oooo0P0000030?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H0
00000`3oool200000140oooo00<000000?ooo`3oool0103oool30=kNgP8000000`3Ng]h6000000L0
g]kN00<000000=kNgP3Ng]h01`3Ng]h2000000D0g]kN0P00000:0=kNg_l0oooo<P3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<h0?ooo`800000303oool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0
oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00@0
oooo0P3Ng]h2000000@0g]kN0P0000020=kNgP8000001`3Ng]h00`000000g]kN0=kNgP070=kNgP80
00001P3Ng]h2000000T0g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P00000:0?ooo`D0
00002@3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0oooo0P00000>0?ooo`D0
0000103oool20=kNgP8000001@3Ng]h2000000P0g]kN1@0000060=kNgP@000001@3Ng]h2000000T0
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P00000<0?ooo`030000003oool0oooo00T0
oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool200000100
oooo00<000000?ooo`3oool0103oool20=kNgP8000001P3Ng]h2000000T0g]kN00<000000=kNgP3N
g]h01P3Ng]h4000000D0g]kN0P0000090=kNg_l0oooo<P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`80
0000303oool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3o
ool01P3oool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00@0oooo0P3Ng]h2000000L0
g]kN0P0000080=kNgP030000003Ng]h0g]kN00D0g]kN0P0000020=kNgP800000103Ng]h2000000T0
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo1000000I0?ooo`8000000`3oool400000140
oooo1P0000030?ooo`8000001P3oool200000100oooo0`3Ng]h2000000L0g]kN0P00000>0=kNgPP0
00000P3Ng]h2000000@0g]kN0`0000030=kNg_l0oooo<P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`<0
00006@3oool2000000@0oooo0`00000J0?ooo`8000001P3oool200000100oooo0`3Ng]h2000000<0
g]kN0P0000020=kNgP800000603Ng]h2000000<0g]kN0P0000000`3Ng]h00000000000020=kNg_l0
oooo<P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`8000006P3oool2000000@0oooo0P00000I0?ooo`80
0000103oool500000100oooo103Ng]h2000000<0g]kN1000000H0=kNgP8000001`3Ng]h200000080
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<g`0oooo1000000@0?ooobd0g]kN0P0000030=kNg_l0
oooo<@3oool20000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<gd0oooo0`00000@0?ooob/0g]kN0P0000000`3Ng]h00000000000020=kNg_l0
oooo<03oool00`000?l0oooo0000o`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=n0?ooo`800000403oool/0=kNgP<000000`3Ng]ko0?ooobl0
oooo00@0003o0?ooo`3oool0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`050000o`3oool0oooo0?ooo`000?l0203oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo_
0?ooo`H0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0
oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[TextData[{
  "This shows the result of pressing a button containing ",
  StyleBox["Expand[", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\[SelectionPlaceholder]\)], "InlineFormula"],
  StyleBox["]", "MR"],
  " with an ",
  StyleBox["EvaluateCell", "MR"],
  " button action. "
}], "MathCaption",
  CellTags->{"S1.10.12", "12.18"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000A2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon`0oooo1@000?l20?oo
o`D0003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>N0?ooo`800000703o
ool2000001P0oooo0P00003o0?oooaP0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
EP3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0?l0oooo5@3oool00`000?l0oooo
0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c=E0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0o`3ooolE0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cl0oooo0`00000B0?oo
o`030000003oool0oooo0080oooo1@00000>0?ooo`8000000`3oool2000000<0oooo00<000000?oo
o`3oool0503oool500000080oooo1@0000070?ooo`030000003oool0oooo0100oooo0`0000080?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0o`3ooolE0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<d80oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`05
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000H0oooo
0`0000080?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000060?ooo`<0
00003P3oool00`000000oooo0?ooo`060?ooo`<00000o`3ooolF0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<d<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo000000080?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0
000000h0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000003o0?oooaH0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c@03oool4000000@0oooo1@0000070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01@3oool5000000L0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0;0?ooo`D000001P3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00D000000?ooo`3oool0oooo000000050?ooo`D000001@3oool01@000000oooo
0?ooo`3oool0000000D0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`D000001@3oool01@00
0000oooo0?ooo`3oool000000?l0oooo5@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c<o0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?ooo`070?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000L0
oooo00<000000?ooo`3oool01@3oool4000000H0oooo00D000000?ooo`3oool0oooo0000000=0?oo
o`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000003o0?oooaD0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c?`3oool01@000000oooo0?ooo`3oool0000000H0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool00P3oool01@000000oooo0?ooo`3oool0000000@0oooo0`000000103oool00000000000000006
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool3000000030?ooo`000000
000000D00000203oool00`000000oooo0?ooo`040?ooo`<0000000D0oooo00000000000000000?oo
o`0200000?l0oooo3P3oool40000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cl0oooo00D000000?ooo`3oool0
oooo0000000A0?ooo`040000003oool0oooo0?ooo`<000006@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00d0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000006P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01H0oooo00@000000?ooo`3oool00000o`3o
ool@0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<d00oooo0`00000C0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`030?ooo`@00000
4@3oool00`000000oooo0?ooo`030?ooo`<00000703oool3000000d0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`3o0?ooo`d0oooo0P000?l60?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=k0?ooo`03
0000003oool0000004L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`3o0?ooo`d0
oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO03oool2000004@0oooo00@000000?oo
o`3oool000005P3oool010000000oooo0?ooo`00003o0?ooo`d0oooo00@0003o0?ooo`3oool0003o
1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cO@3oool00`000000oooo0?ooo`130?ooo`800000603oool200000?l0
oooo3@3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool6
0000o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooog0?ooo`030000
o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo0?ooo`040?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooog
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool00`000?l0oooo
0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooog0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooL0oooo00<0003o0?ooo`3oool0103oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooom`3oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooo/0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo`0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooool03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=E0?ooo`8000007`3oool2000002T0oooo1000000N0?ooo`@000001@3oool20000
01L0oooo100000040?ooo`800000303oool400000?00oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<cE03oool200000240oooo0P00000Y0?ooo`8000007`3oool2000000H0oooo0P00000I
0?ooo`8000001P3oool2000000d0oooo0P00003`0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<cd0oooo1P0000070?ooo`030000003oool0oooo00L0oooo0P0000030?ooo`H000001`3o
ool00`000000oooo0?ooo`050?ooo`H000000`3oool200000140oooo00<000000?ooo`3oool0103o
ool700000080oooo1P0000020?ooo`D000000`3oool6000000030?ooo`000000000000H0000000<0
oooo000000000000100000030?ooo`8000001P3oool2000000<0oooo1P0000070?ooo`030000003o
ool0oooo00L0oooo0P0000050?ooo`8000003@3oool200000?00oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c?`3oool2000000T0oooo00<000000?ooo`3oool01P3oool2000000H0oooo
0P0000090?ooo`030000003oool0oooo00H0oooo100000050?ooo`800000403oool00`000000oooo
0?ooo`050?ooo`8000000P3oool2000000<0oooo100000030?ooo`8000000P3oool2000000030?oo
o`00000000000080oooo0P0000030?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0P0000040?ooo`8000001@3oool2000000@0oooo0P0000020?ooo`8000001`3oool00`000000oooo
0?ooo`070?ooo`8000001P3oool2000000`0oooo0P00003`0?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<cl0oooo0P0000070?ooo`D000001P3oool2000000H0oooo0P0000070?ooo`D0
00001`3oool2000000H0oooo0P00000>0?ooo`D000001@3oool2000000P0oooo0P0000040?ooo`80
00000P3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`8000000P3oool200000003
0?ooo`00000000000080oooo0P0000040?ooo`8000001@3oool2000000D0oooo0P0000080?ooo`D0
00001P3oool4000000D0oooo0P00000<0?ooo`800000l03oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<o0?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`8000001P3oool20000
00T0oooo00<000000?ooo`3oool01`3oool2000000H0oooo0P00000@0?ooo`030000003oool0oooo
00D0oooo100000060?ooo`800000103oool200000080oooo0P0000020?ooo`D000000`3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`800000103oool2000000D0oooo0P0000060?oo
o`8000002@3oool00`000000oooo0?ooo`060?ooo`@000001@3oool2000000`0oooo0P00003`0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cl0oooo0P0000090?ooo`030000003oool0
oooo00H0oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`060?ooo`@000001@3oool2
00000100oooo00<000000?ooo`3oool01@3oool4000000D0oooo100000030?ooo`8000000P3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`<0000000@0oooo000000000000oooo0P00
00020?ooo`800000103oool2000000D0oooo0P0000070?ooo`800000203oool00`000000oooo0?oo
o`050?ooo`8000000P3oool2000000@0oooo0P00000<0?ooo`800000l03oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<m0?ooo`@000004`3oool2000000<0oooo1000000A0?ooo`H00000
0`3oool2000000H0oooo0P00000A0?ooo`@00000103oool6000000030?ooo`000000000000@00000
0`3oool4000000<0oooo1P0000030?ooo`D00000103oool2000000H0oooo0P0000070?ooo`800000
3P3oool800000080oooo0P0000040?ooo`<000001P3oool200000?00oooo00<0003o0?ooo`3oool0
103oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c?P3oool3000001<0oooo0P0000040?ooo`<000006P3oool2000000H0
oooo0P00000A0?ooo`8000000P3oool2000002D0oooo0P0000040?ooo`8000001P3oool2000000<0
oooo0P0000020?ooo`800000603oool2000000<0oooo0P0000000`3oool00000000000050?ooo`80
0000l03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<o0?ooo`800000503oool20000
00@0oooo0P00000I0?ooo`800000103oool500000100oooo1`00000T0?ooo`<00000103oool40000
00D0oooo0P0000030?ooo`@00000603oool2000000L0oooo0P0000030?ooo`@00000k`3oool20000
o`H0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<gd0oooo1000001d0?ooo`800000mP3oool00`000?l0oooo0000o`06
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=n0?ooo`<00000LP3oool2000000030?ooo`00000000000?@0oooo00@0
003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cO`3oool2000007<0oooo0`00003d0?ooo`05
0000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`H0003o0P3oool5
0000o`H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVIo`0c<c?o03<c<`40<c<c00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0
o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0@3U
iND103<c<`40oooo003o0>GUiOl0iNGU2`3UiND10?ooo`00o`3ooooo0?ooo``0oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 68},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[TextData[{
  "Sometimes it is useful to be able to extract the current selection from a \
cell, and then operate on it in a new cell. You can do this using the button \
actions ",
  StyleBox["CopyEvaluate", "MR"],
  " and ",
  StyleBox["CopyEvaluateCell", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.10.12", "12.19"}],

Cell["Here is an expression with a part selected. ", "MathCaption",
  CellTags->{"S1.10.12", "12.20"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000:2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooool03oool50000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom03oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=D0?ooo`80
00007`3oool2000001T0oooo103Ng]h2000001L0g]kN100000040=kNgP8000002`3Ng]ko0?oooc80
oooo00<0003o0?ooo`3oool01P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cD`3oool200000240oooo0P00000H0?ooo`<0g]kN0P00000I0=kNgP80
00001P3Ng]h2000000X0g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo1P00000:0?ooo`03
0000003oool0oooo00X0oooo0P0000030?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H0
00000`3oool200000140oooo00<000000?ooo`3oool0103oool30=kNgP8000000`3Ng]h6000000L0
g]kN00<000000=kNgP3Ng]h01`3Ng]h2000000D0g]kN0P00000:0=kNg_l0oooo<P3oool00`000?l0
oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<h0?ooo`800000303oool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0
oooo00<000000?ooo`3oool01P3oool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00@0
oooo0P3Ng]h2000000@0g]kN0P0000020=kNgP8000001`3Ng]h00`000000g]kN0=kNgP070=kNgP80
00001P3Ng]h2000000T0g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P00000:0?ooo`D0
00002@3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0oooo0P00000>0?ooo`D0
0000103oool20=kNgP8000001@3Ng]h2000000P0g]kN1@0000060=kNgP@000001@3Ng]h2000000T0
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cP0oooo0P00000<0?ooo`030000003oool0oooo00T0
oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool200000100
oooo00<000000?ooo`3oool0103oool20=kNgP8000001P3Ng]h2000000T0g]kN00<000000=kNgP3N
g]h01P3Ng]h4000000D0g]kN0P0000090=kNg_l0oooo<P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`80
0000303oool00`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3o
ool01P3oool4000000D0oooo0P00000@0?ooo`030000003oool0oooo00@0oooo0P3Ng]h2000000L0
g]kN0P0000080=kNgP030000003Ng]h0g]kN00D0g]kN0P0000020=kNgP800000103Ng]h2000000T0
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cH0oooo1000000I0?ooo`8000000`3oool400000140
oooo1P0000030?ooo`8000001P3oool200000100oooo0`3Ng]h2000000L0g]kN0P00000>0=kNgPP0
00000P3Ng]h2000000@0g]kN0`0000030=kNg_l0oooo<P3oool00`000?l0oooo0?ooo`060?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<g0?ooo`<0
00006@3oool2000000@0oooo0`00000J0?ooo`8000001P3oool200000100oooo0`3Ng]h2000000<0
g]kN0P0000020=kNgP800000603Ng]h2000000<0g]kN0P0000000`3Ng]h00000000000020=kNg_l0
oooo<P3oool00`000?l0oooo0?ooo`060?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<h0?ooo`8000006P3oool2000000@0oooo0P00000I0?ooo`80
0000103oool500000100oooo103Ng]h2000000<0g]kN1000000H0=kNgP8000001`3Ng]h200000080
g]kNo`3ooolb0?ooo`030000o`3oool0oooo00H0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<g`0oooo1000000@0?ooobd0g]kN0P0000030=kNg_l0
oooo<@3oool20000o`P0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<gd0oooo0`00000@0?ooob/0g]kN0P0000000`3Ng]h00000000000020=kNg_l0
oooo<03oool00`000?l0oooo0000o`080?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=n0?ooo`800000403oool/0=kNgP<000000`3Ng]ko0?ooobl0
oooo00@0003o0?ooo`3oool0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3oooo`0?ooo`050000o`3oool0oooo0?ooo`000?l0203oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooo_
0?ooo`H0003o203oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`0000<0
oooo0>GUi@3UiND0o`3UiNGo0>GUi@P0iNGU0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 40},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[TextData[{
  "A button with a ",
  StyleBox["CopyEvaluateCell", "MR"],
  " button action copies the current selection into a new cell, then pastes \
the contents of the button, and then performs an evaluation, putting the \
result into a new cell. "
}], "MathCaption",
  CellTags->{"S1.10.12", "12.21"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000Gb000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0oooo1@000?l20?oo
o`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=F0?ooo`800000703o
ool2000001L0oooo0P00003o0?ooof00oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
6P3oool20000o`H0oooo0P000?ld0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`3o0?oooed0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<c6P3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo0380oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0?l0ooooG@3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<=0?ooo`80003o103oool00`000?l0oooo0000o`020?oo
o`030000o`3oool0003o00@0oooo00D0003o0?ooo`3oool0oooo0000o`0?0?ooo`<000003`3oool5
00000080oooo1@0000070?ooo`030000003oool0oooo0100oooo0`0000080?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0o`3ooomM0?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<``0oooo00@0003o0?ooo`3oool0003o0P3oool01P000?l0oooo0000o`000?l0oooo0000
o`80oooo00<0003o0?ooo`3oool00P3oool01P000?l0oooo0?ooo`3oool0003o0?ooo`@0003o2@3o
ool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`0000001P3oool3000000P0oooo00<000000?ooo`3o
ool01@3oool01@000000oooo0?ooo`3oool0000000H0oooo0`00000>0?ooo`030000003oool0oooo
00D0oooo0`00003o0?oooeh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c2`3oool0
0`000?l0oooo0?ooo`020?ooo`030000o`3oool0003o0080oooo00<0003o0?ooo`000?l00P3oool0
0`000?l0oooo0?ooo`020?ooo`050000o`3oool0oooo0?ooo`000?l03P3oool01@000000oooo0?oo
o`3oool0000000H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00L0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`050?ooo`050000
003oool0oooo0?ooo`0000001P3oool00`000000oooo0000000>0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`000000o`3ooomN0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<`/0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o
0080oooo00<0003o0?ooo`3oool00P3oool01P000?l0oooo0?ooo`3oool0003o0?ooo`@0003o2@3o
ool01@000000oooo0?ooo`3oool0000000@0oooo1@0000070?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000D0oooo1@0000050?ooo`05
0000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000/0oooo1@000004
0?ooo`050000003oool0oooo0?ooo`000000o`3ooomM0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<`/0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0000o`020?ooo`060000
o`3oool0003o0000o`3oool0003o103oool01@000?l0oooo0?ooo`3oool0003o00l0oooo0`000007
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`@000001P3o
ool01@000000oooo0?ooo`3oool0000000d0oooo00<000000?ooo`3oool0103oool01@000000oooo
0?ooo`3oool000000?l0ooooG@3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?oo
o`040000o`3oool0oooo0000o`L0oooo00@0003o0?ooo`3oool0003o0`3oool20000o`<0oooo00<0
003o0?ooo`3oool0303oool01@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool300000004
0?ooo`0000000000000000H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?oo
o`<0000000<0oooo0000000000001@0000080?ooo`030000003oool0oooo00<0oooo0`0000001@3o
ool00000000000000000oooo00800000o`3ooomF0?ooo`@0003o1P3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3@3o
ool20000o`/0oooo0P000?l30?ooo`030000o`3oool0oooo0080003o3P3oool01@000000oooo0?oo
o`3oool0000000h0oooo0`0000040?ooo`050000003oool0oooo0?ooo`0000006P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo01D0oooo00@000000?ooo`3oool00000o`3ooomH0?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c<0oooo0`00000A0?ooo`030000003oool0
oooo00<0oooo0`00000L0?ooo`<000003@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo0?l0ooooE@3oool20000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<gd0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`3o0?oooeD0oooo00<0003o0?ooo`000?l01P3oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
NP3oool010000000oooo0?ooo`00000E0?ooo`040000003oool0oooo00000?l0ooooE@3oool01000
0?l0oooo0?ooo`000?l60?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=k0?ooo`8000005`3oool200000?l0ooooE@3o
ool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooojP3oool60000o`H0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0ooook`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<F0?ooo`80003o1P3oool20000oal0oooo1000000N0?ooo`@000001@3oool2000001L0oooo
100000040?ooo`800000303oool400000?l0ooooDP3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<F0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool07P3oool2000001l0
oooo0P0000060?ooo`8000006@3oool2000000H0oooo0P00000=0?ooo`800000o`3ooomB0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<0003o0?ooo`000?l00P3oool00`00
0?l0oooo0000o`040?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool00`000?l0oooo0?ooo`0:
0?ooo`L000000P3oool600000080oooo1@0000030?ooo`H0000000<0oooo0000000000001P000000
0`3oool0000000000004000000<0oooo0P0000060?ooo`8000000`3oool6000000L0oooo00<00000
0?ooo`3oool01`3oool2000000D0oooo0P00000=0?ooo`800000o`3ooomB0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<`l0oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000
o`040?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000o`P0oooo0P0000020?ooo`800000
0`3oool4000000<0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo
0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P0000050?ooo`800000
103oool200000080oooo0P0000070?ooo`030000003oool0oooo00L0oooo0P0000060?ooo`800000
303oool200000?l0ooooDP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`03
0000o`3oool0003o0080oooo00<0003o0?ooo`000?l0103oool01@000?l0oooo0?ooo`3oool0003o
0100oooo0P0000080?ooo`800000103oool200000080oooo0P0000000`3oool00000000000020?oo
o`8000000`3oool200000080oooo0P0000000`3oool00000000000020?ooo`800000103oool20000
00D0oooo0P0000050?ooo`800000203oool5000000H0oooo100000050?ooo`800000303oool20000
0?l0ooooDP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<?0?ooo`080000o`3oool0
003o0000o`3oool0003o0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`000?l0103oool40000
o`P0oooo100000060?ooo`800000103oool200000080oooo0P0000020?ooo`D000000`3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`800000103oool2000000D0oooo0P0000060?oo
o`8000002@3oool00`000000oooo0?ooo`060?ooo`@000001@3oool2000000`0oooo0P00003o0?oo
oe80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool01@000?l0oooo0000o`3o
ool0003o0080oooo00<0003o0?ooo`3oool00P3oool01@000?l0oooo0?ooo`3oool0003o0080oooo
00<0003o0?ooo`3oool02`3oool4000000D0oooo100000030?ooo`8000000P3oool2000000030?oo
o`00000000000080oooo0P0000030?ooo`<0000000@0oooo000000000000oooo0P0000020?ooo`80
0000103oool2000000D0oooo0P0000070?ooo`800000203oool00`000000oooo0?ooo`050?ooo`80
00000P3oool2000000@0oooo0P00000<0?ooo`800000o`3ooomB0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<`l0oooo00<0003o0?ooo`3oool0103oool010000?l0oooo0?ooo`3oool2
0000o`<0oooo00<0003o0?ooo`3oool03P3oool4000000@0oooo1P0000000`3oool0000000000004
000000<0oooo100000030?ooo`H000000`3oool5000000@0oooo0P0000060?ooo`8000001`3oool2
000000h0oooo200000020?ooo`800000103oool3000000H0oooo0P00003o0?oooe80oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c3`3oool00`000?l0oooo0?ooo`040?ooo`80003o0`3o
ool00`000?l0oooo0?ooo`020000oa00oooo0P0000020?ooo`8000009@3oool2000000@0oooo0P00
00060?ooo`8000000`3oool200000080oooo0P00000H0?ooo`8000000`3oool2000000030?ooo`00
0000000000D0oooo0P00003o0?oooe80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
;`3oool7000002@0oooo0`0000040?ooo`@000001@3oool2000000<0oooo1000000H0?ooo`800000
1`3oool2000000<0oooo1000003o0?oooe40oooo0P000?l60?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>C0?ooo`80
0000o`3ooomH0?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<i40oooo0P0000000`3o
ool000000000003o0?oooeH0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cTP3o
ool300000?l0ooooEP3oool01@000?l0oooo0?ooo`3oool0003o00H0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooojP3oool60000o`80oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0
VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooob0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=>0?oo
o`8000007`3oool2000001d0oooo0P00000G0?ooo`@00000103oool200000?l0ooooA@3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<cC@3oool200000240oooo0P00000K0?ooo`8000006@3oool2000000H0oooo0P00003o
0?oood@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<c00oooo1P00000:0?ooo`030000003oool0oooo00X0oooo0P00
00030?ooo`H000001`3oool00`000000oooo0?ooo`050?ooo`H000000`3oool200000140oooo00<0
00000?ooo`3oool01`3oool2000000<0oooo1P0000070?ooo`030000003oool0oooo00L0oooo0P00
00050?ooo`800000o`3ooom40?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<b0?ooo`800000303oool00`000000oooo
0?ooo`090?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3oool01P3oool4000000D0oooo
0P00000@0?ooo`030000003oool0oooo00H0oooo0P0000040?ooo`8000000P3oool2000000L0oooo
00<000000?ooo`3oool01`3oool2000000H0oooo0P00003o0?oood<0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c80
oooo0P00000:0?ooo`D000002@3oool2000000H0oooo0P0000070?ooo`D000001`3oool2000000H0
oooo0P00000>0?ooo`D000001P3oool2000000D0oooo0P0000080?ooo`D000001P3oool4000000D0
oooo0P00003o0?oood<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c80oooo0P00000<0?ooo`030000003oool0oooo
00T0oooo0P0000060?ooo`8000002@3oool00`000000oooo0?ooo`070?ooo`8000001P3oool20000
0100oooo00<000000?ooo`3oool01P3oool2000000H0oooo0P0000090?ooo`030000003oool0oooo
00H0oooo100000050?ooo`800000o`3ooom30?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<b0?ooo`800000303oool0
0`000000oooo0?ooo`090?ooo`8000001P3oool2000000T0oooo00<000000?ooo`3oool01P3oool4
000000D0oooo0P00000@0?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`800000203oool0
0`000000oooo0?ooo`050?ooo`8000000P3oool2000000@0oooo0P00003o0?oood<0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<c00oooo1000000I0?ooo`8000000`3oool400000140oooo1P0000030?ooo`8000001P3o
ool2000001<0oooo0P0000070?ooo`8000003P3oool800000080oooo0P0000040?ooo`<00000o`3o
oolm0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<a0?ooo`<000006@3oool2000000@0oooo0`00000J0?ooo`800000
1P3oool2000001<0oooo0P0000030?ooo`8000000P3oool2000001P0oooo0P0000030?ooo`800000
00<0oooo000000000000o`3oooll0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<b0?ooo`8000006P3oool2000000@0
oooo0P00000I0?ooo`800000103oool5000001@0oooo0P0000030?ooo`@00000603oool2000000L0
oooo0P00003o0?oooc/0oooo0P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<cMP3oool4000003d0oooo0P00003o0?oooc/0oooo00<0003o0?oo
o`000?l01`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<gL0oooo0`00000k0?ooo`80000000<0oooo000000000000o`3oooli0?ooo`040000o`3oool0
oooo0000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=h0?ooo`800000?03oool300000?l0oooo>@3oool01@000?l0oooo0?ooo`3oool0003o00L0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oo
oo40oooo1P000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI
0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00?l0iNGUo`3U
iND:0>GUi@40<c<c0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 95},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.12"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Create Table/Matrix/Palette", "SR"],
              " "
            }]], Cell["set up a blank palette "]},
          {Cell[TextData[{
              StyleBox["Create Button", "SR"],
              " "
            }]], Cell["set up a single button not in a palette "]},
          {Cell[TextData[{
              StyleBox["Generate Palette from Selection", "SR"],
              " "
            }]], Cell["make a separate window "]},
          {Cell[TextData[{
              StyleBox["Cell Active", "SR"],
              " "
            }]], Cell["activate buttons within a cell in a notebook "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S1.10.12"],

Cell["Ways to create active elements in the front end. ", "Caption",
  CellTags->"S1.10.12"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to set up a wide range of active elements in the notebook \
front end. In the most common case, you have a palette which consists of an \
array of buttons in a separate window. But you can also have arrays of \
buttons, or even single buttons, within the cells of an ordinary notebook. "
}], "Text",
  CellTags->{"S1.10.12", "12.22"}],

Cell[TextData[{
  "In addition, you can make a button execute any action you \
want\[LongDash]performing computations in the ",
  StyleBox["Mathematica", "TI"],
  " kernel, or changing the configuration of notebooks in the front end. \
Section ",
  ButtonBox["2.11.6",
    ButtonData:>{"2.11.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  " discusses how to do this. "
}], "Text",
  CellTags->{"S1.10.12", "12.23"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.13 Setting Up Hyperlinks", "Subsection",
  CellTags->{"S1.10.13", "13.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Create Hyperlink", "SR"],
              " "
            }]], Cell["make the selected object a hyperlink "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.13"],

Cell["Menu item for setting up hyperlinks. ", "Caption",
  CellTags->"S1.10.13"],

Cell[TextData[{
  "A hyperlink is a special kind of button which jumps to another part of a \
notebook when it is pressed. Typically hyperlinks are indicated in ",
  StyleBox["Mathematica", "TI"],
  " by blue or underlined text. "
}], "Text",
  CellTags->{"S1.10.13", "13.2"}],

Cell[TextData[{
  "To set up a hyperlink, just select the text or other object that you want \
to be a hyperlink. Then choose the menu item ",
  StyleBox["Create Hyperlink", "SR"],
  " and fill in the specification of where you want the destination of the \
hyperlink to be. "
}], "Text",
  CellTags->{"S1.10.13", "13.3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.10.14 Automatic Numbering", "Subsection",
  CellTags->{"S1.10.14", "14.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Choose a cell style such as ",
              StyleBox["NumberedEquation", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Use the ",
              StyleBox["Create Automatic Numbering Object", "SR"],
              " menu, with a counter name such as ",
              StyleBox["Section", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.10.14"],

Cell[TextData[{
  "Two ways to set up automatic numbering in a ",
  StyleBox["Mathematica", "SO"],
  " notebook. "
}], "Caption",
  CellTags->"S1.10.14"],

Cell["\<\
The input for each cell here is exactly the same, but the cells \
contain an element that displays as a progressively larger number as one goes \
through the notebook. \
\>", "MathCaption",
  CellTags->{"S1.10.14", "14.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000VB000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030?ooo`0c<c<0<c<c0?l0<c<co`0c<c<803<c<`40
oooo00000`3oool0iNGU03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2I
VIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIWo0>GUiOl0iNGU0@3UiND309VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
303oool9000000L0oooo0`0000040?ooo`800000303oool2000000H0oooo0P0000080?ooo`D00000
1@3oool3000000D0oooo0`0000040?ooo`8000000P3oool2000000@0oooo0`0000030?ooo`800000
0`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000001P3oool2000000030?oo
o`00000000000180oooo0P0000040?ooo`800000203oool2000000<0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
0`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000o`3ooon20?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<``0oooo2@0000050?ooo`8000000`3oool200000140oooo0P0000040?ooo`800000
1`3oool2000000D0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000
0`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?oo
o`000000000000<0oooo0P00003o0?oooh80oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000D0oooo
0P0000030?ooo`8000004@3oool2000000@0oooo0P0000070?ooo`8000001@3oool2000000030?oo
o`000000000000H0oooo0P0000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000
2P3oool200000180oooo1P00000?0?ooo`80000000<0oooo0000000000001@0000000`3oool00000
000000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`80000000<0oooo000000000000
0`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T000002@3oool2000001<0oooo
0P0000020?ooo`8000003P3oool200000080oooo0P0000030?ooo`80000000<0oooo000000000000
1P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo
0P00003o0?oooh80oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000L0oooo0`00000D0?ooo`800000
0P3oool2000000X0oooo1@0000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000030?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000
000000030?ooo`800000o`3ooon20?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000090?ooo`800000
503oool4000000X0oooo0P0000080?ooo`80000000<0oooo0000000000000`3oool200000080oooo
0P0000000`3oool00000000000030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo
0`0000020?ooo`800000o`3ooon20?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo2@0000050?ooo`800000
0`3oool2000001<0oooo100000090?ooo`8000001@3oool2000000<0oooo0`0000050?ooo`@00000
00<0oooo0000000000000P0000020?ooo`800000103oool3000000<0oooo1P00003o0?oooh<0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c6P3oool2000000<0oooo0P00000C0?ooo`@000002@3oool2000000D0oooo
0P00000A0?ooo`800000o`3ooonH0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<a/0oooo0P0000000`3oool00000
0000000E0?ooo`8000002`3oool2000000<0oooo0P00000B0?ooo`800000o`3ooonE0?ooo`@0003o
1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
703oool3000001H0oooo0P00000<0?ooo`D00000603oool200000?l0ooooT`3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooa0?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo
0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo
2@0000050?ooo`L000000P3oool2000000`0oooo0P0000060?ooo`800000203oool5000000D0oooo
0`0000050?ooo`<00000103oool200000080oooo0P0000040?ooo`<000000`3oool2000000<0oooo
0P00003o0?oooh80oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000D0oooo0P00000F0?ooo`800000
103oool2000000P0oooo0P0000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo
0P0000000`3oool00000000000020?ooo`8000000`3oool2000000<0oooo0P0000000`3oool00000
000000020?ooo`8000000`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000
1@3oool2000001H0oooo0P0000040?ooo`8000001`3oool2000000D0oooo0P0000000`3oool00000
000000030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oooh80oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c303oool9000000H0oooo0P00000E0?ooo`800000103oool2000000L0oooo
0P0000050?ooo`80000000<0oooo0000000000001P3oool2000000H0oooo0P0000030?ooo`800000
0P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooon20?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<``0oooo2@0000070?ooo`8000005@3oool6000000l0oooo0P0000000`3oool00000
00000005000000030?ooo`000000000000H0oooo0P0000030?ooo`8000000P3oool2000000<0oooo
0P0000000`3oool00000000000030?ooo`800000o`3ooon20?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<``0oooo
2@0000080?ooo`800000503oool200000080oooo0P00000>0?ooo`8000000P3oool2000000<0oooo
0P0000000`3oool00000000000060?ooo`8000000`3oool200000080oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000
2@3oool2000001<0oooo0P0000020?ooo`8000002P3oool5000000<0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`800000
0`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oooh80oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
303oool9000000X0oooo0P00000C0?ooo`@000002P3oool2000000P0oooo0P0000000`3oool00000
000000030?ooo`8000000P3oool2000000030?ooo`000000000000<0oooo0P0000030?ooo`800000
00<0oooo0000000000000P3oool300000080oooo0P00003o0?oooh80oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
303oool9000000D0oooo0P0000030?ooo`8000004`3oool4000000T0oooo0P0000050?ooo`800000
0`3oool3000000D0oooo100000000`3oool000000000000200000080oooo0P0000040?ooo`<00000
0`3oool600000?l0ooooP`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<J0?ooo`8000000`3oool2000001<0oooo
100000090?ooo`8000001@3oool200000140oooo0P00003o0?oooiP0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
6`3oool2000000030?ooo`000000000001D0oooo0P00000;0?ooo`8000000`3oool200000180oooo
0P00003o0?oooiD0oooo10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<L0?ooo`<000005P3oool2000000`0oooo1@00000H0?ooo`800000
o`3ooonC0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooooe0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooom@3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooD0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c303oool9000000P0oooo0P0000040?ooo`800000303oool2000000H0oooo
0P0000080?ooo`D000001@3oool3000000D0oooo0`0000040?ooo`8000000P3oool2000000@0oooo
0`0000030?ooo`8000000`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000
203oool2000001<0oooo0P0000040?ooo`800000203oool2000000<0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
0`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000o`3ooon20?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<``0oooo2@0000080?ooo`8000004`3oool2000000@0oooo0P0000070?ooo`800000
1@3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`800000
00<0oooo0000000000000`3oool200000080oooo0P0000030?ooo`80000000<0oooo000000000000
0`3oool200000?l0ooooPP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000203oool2000001<0oooo
0P0000040?ooo`8000001`3oool2000000D0oooo0P0000000`3oool00000000000060?ooo`800000
1P3oool2000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo
0P00003o0?oooh80oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c303oool9000000P0oooo0P00000D0?ooo`H00000
3`3oool2000000030?ooo`000000000000D0000000<0oooo0000000000001P3oool2000000<0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?oooh80oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c303oool9000000P0oooo0P00000D0?ooo`8000000P3oool2000000h0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`800000
0P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooon20?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<``0oooo2@0000080?ooo`800000503oool200000080oooo0P00000:0?ooo`D00000
0`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo000000000000
0`3oool200000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000?l0oooo
PP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000203oool2000001D0oooo1000000:0?ooo`800000
203oool2000000030?ooo`000000000000<0oooo0P0000020?ooo`80000000<0oooo000000000000
0`3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`<000000P3oool200000?l0oooo
PP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<<0?ooo`T00000203oool2000001D0oooo100000090?ooo`800000
1@3oool2000000<0oooo0`0000050?ooo`@0000000<0oooo0000000000000P0000020?ooo`800000
103oool3000000<0oooo1P00003o0?oooh<0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c6`3oool4000001D0oooo
100000090?ooo`8000001@3oool200000140oooo0P00003o0?oooiP0oooo00<0003o0?ooo`3oool0
1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
7@3oool2000001H0oooo0P00000;0?ooo`8000000`3oool200000180oooo0P00003o0?oooiD0oooo
10000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<M0?ooo`8000005P3oool2000000`0oooo1@00000H0?ooo`800000o`3ooonC0?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooool@3oool50000o`L0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
o`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
o`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVI
o`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0iNGU
0?l0iNGUo`3UiND70>GUi@40<c<c0@3oool000030?ooo`3UiND0iNGU0?l0iNGUo`3UiND80>GUi@40
oooo0000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 153},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.14"],

Cell[TextData[{
  "These cells are in ",
  StyleBox["NumberedEquation", "MR"],
  " style. "
}], "MathCaption",
  CellTags->{"S1.10.14", "14.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000S1000`40O003h00Oogooogoo37oo0000
1aS67>LHaQS67>LHaQcW008HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP04
7>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW
0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LH
aQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS6
00@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS6
7>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@L
iaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L2
6<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS6
6<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H0
11cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HL
i`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW
6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8H
aP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HH
aQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP04
7>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW
0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LH
aQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS6
00@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS6
7>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP087>LHaQS67>LHaQcW6<HLi`4HaP0000Mg_AS6
6<HLiaS67>LHaP027>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LL
iaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`04
6<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS6
0QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HL
iacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW
00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW
6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@H
aQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H2
7>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW
7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L0
11S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LH
aP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S6
7>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8L
i`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LL
iaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`04
6<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS6
0QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HL
iacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW
00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L00aS67>LLi`036<H17>L16<H16<H00003LiaBU4ic0?m>
Lom>L`=>L`05DYA>LdicCW<Li`016<H00005Mke>LdicCW=BU03oCW?oCW<3CW<00e:DCW<HaP016<H0
0003Lia>Ldic0?m>Lom>L`M>L`4HaP4Li`0000Eg_DicCW=>Lg>L0?mg_Omg_@5g_@A>L`4Li`4HaP00
00IcW5:DCW=>LacW6<KoOoonOol00gNmCW=>L`02CW<16<H17>L00006Mke>LdicCW<HaQcWogoooWoo
00=cW4icDY@00Tic0AcW0AS600001W>LCW=>Ldic7>LHa_moooioo`03Mke>Ldic009>L`4HaP4Li`00
00Ig_DicDYA>LaS67>OoOoonOol00gNmCW=>L`02CW<17>L16<H00006Lia>LdicCW<LiaS6ogoooWoo
00=g_DicCW<00Tic0QS600001WNmCW=>Ldic6<HLiomoooioo`03Mke>Ldic009>L`4Li`4HaP0000Ic
W4icCW=>LacW6<KoOoonOol01WNmCW=>LdicDY@HaP4Li`0000Ig_DicDYA>LaS67>OoOoonOol00g>L
CW=BU002CW<26<H00006Lia>LdicCW<LiaS6ogoooWoo00=g_DicCW<00Tic0AS60AcW00001WNmCW=>
Ldic6<HLiomoooioo`03Mke>Ldic009>L`4Li`4HaP0000IcW5:DCW=>LacW6<KoOoonOol01WNmCW=>
LdicDY@HaP4Li`0000Ig_DicCW=>LaS67>OoOoonOol00gNmCW=>L`02CW<26<H00006Lia>LdicCW<L
iaS6ogoooWoo00Ig_DicCW=BU4ic7>L16<H00006Mke>Le:DCW<HaQcWogoolgoo1@0O1Woo00=g_Dic
CW<00Tic0QS600001W>LCW=>Ldic7>LHa_moooMoo`0301moogoo00Aoo`03Mke>Ldic009>L`4HaP4L
i`0000Ig_DicCW=>LaS67>LSOol3000^Ool200000goo00000007Ool00`00Oomoo`05Ool5003oOon:
Ool00`0OOomoo`04Ool00g>LDYA>L`02CW<17>L16<H00006Lia>LdicCW<LiaS68Woo00D007ooOomo
o`0002ioo`03001oo`0000Qoo`03001oogoo00Moo`03001oogoo0?moohYoo`0301moogoo00Aoo`06
Mke>LdicCW=BU1S60AcW00001WNmCW=BU4ic6<HLibMoo`03001oogoo02aoo`03001oogoo00Eoo`D0
00Moo`03001oogoo0?moohYoo`0301moogoo00Eoo`A>L`8HaP0000IcW4icCW=>LacW6<HWOol00`00
Oomoo`0/Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`3oOon:Ool00`0OOomoo`05Ool0
1DicDYA>Ldic7>L00AS600001WNmCW=>Ldic6<HLibMoo`03001oogoo02]oo`03001oo`0000Qoo`03
001oogoo00Moo`03001oogoo0?moohYoo`0301moogoo00Eoo`A>L`8HaP0000IcW5:DCW=>LacW6<HW
Ool00`00Oomoo`0ZOol200000goo0000000?Ool00`00Ool0003oOon<Ool00`0OOomoo`05Ool2CW<0
0e:DCW<Li`016<H00006Mke>LdicCW<HaQcW9goo00<007ooOol0?goo0P00ogooS7oo00<07gooOol0
1Goo00ABU4icCW=>L`8HaP0000IcW4icCW=>LacW6<HWOol00`00Oomoo`10Ool00`00Oomoo`3oOom`
Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`0OOomoo`05Ool4CW<17>L16<H00006Mke>Le:DCW<H
aQcW9goo00<007ooOol0ogoo/Woo00<007ooOol02goo00<007ooOol02Woo00<07gooOol01Goo0dic
0E:D0AS60AS600001W>LCW=>Ldic7>LHaRMoo`03001oogoo0?mook9oo`03001oogoo00=oo`<000Eo
o`03001oogoo00Yoo`0301moogoo00Eoo`05CW=BU4icCW<Li`016<H00006Mke>LdicCW<HaQcW9goo
00<007ooOol0KWoo1`000goo0P0000=oo`000000ogoo=7oo00<007ooOol00goo00D007ooOomoo`00
00Eoo`03001oogoo00Uoo`0301moogoo00Eoo`A>L`8HaP0000IcW4icCW=>LacW6<HWOol00`00Oomo
o`1]Ool01`00Oomoogoo001oo`0000Eoo`03001oo`000?moocEoo`03001oogoo00Moo`03001oogoo
00=oo`03001oogoo00Uoo`0301moogoo00Eoo`05DYA>LdicCW<HaP017>L00006Mke>Le:DCW<HaQcW
9goo00<007ooOol01GooH`001Goo00L007ooOomoo`00Ool00006Ool00`00Oomoo`3oOoldOol00`00
Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`09Ool00`0OOomoo`05Ool4CW<17>L16<H00006Lia>
LdicCW<LiaS69goo00<007ooOol0KGoo00L007ooOomoo`00Ool00006Ool00`00Oomoo`3oOoldOol0
0`00Oomoo`05Ool20006Ool00`00Oomoo`09Ool00`0OOomoo`05Ool3CW<1DY@16<H17>L00006Mke>
LdicCW<HaQcW9goo00<007ooOol0KWoo100000=oo`00Ool017oo00<007oo0000ogoo=Woo00<007oo
Ool01Woo00<007ooOol00Woo00<007ooOol02Woo00<07gooOol01Goo14ic0QS600001W>LDYA>Ldic
7>LHaRMoo`03001oogoo075oo`03001oo`0000Aoo`800003Ool000000?moocEoo`03001oogoo009o
o`05001oogooOol00004Ool00`00Oomoo`0:Ool00`0OOomoo`05Ool01E:DCW=>Ldic7>L00AS60000
1WNmCW=>Ldic6<HLibMoo`03001oogoo075oo`03001oo`000?moocmoo`03001oogoo009oo`<000Ao
o`03001oogoo00]oo`0301moogoo00Eoo`9>L`03DYA>LaS6004HaP0000IcW4icCW=>LacW6<HWOol0
0`00Oomoo`0EOol30006Ool2000;Ool2000NOol30007Ool2000;Ool2000<Ool4003oOomIOol00`0O
Oomoo`05Ool4CW<17>L16<H00006Mke>Le:DCW<HaQcW9goo00<007ooOol067oo00<007ooOol00goo
00<007ooOol02goo00<007ooOol07Goo00<007ooOol01Woo00<007ooOol02goo00<007ooOol0ogoo
Igoo00<07gooOol01Goo0dic0E:D0AS60AS600001W>LCW=>Ldic7>LHaRMoo`03001oogoo00Ioo`H0
00=oo`<000=oo`@000Eoo`03001oogoo009oo`800003Ool0000000Aoo`03001oogoo00Moo`03001o
ogoo00Aoo`H0009oo`800003Ool00000009oo`@000Eoo`03001oogoo009oo`800003Ool0000000Ao
o`03001oogoo0?moofMoo`0301moogoo00Eoo`A>L`4Li`4HaP0000Ig_DicCW=>LaS67>LWOol00`00
Oomoo`07Ool01@00Oomoogoo00000Woo00L007ooOomoo`00Ool00003Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Ool00005Ool00`00Oomoo`07Ool00`00Oomoo`05Ool01@00Oomoogoo00000goo
00<007oo00000goo00D007ooOomoo`0000Aoo`03001oogoo00=oo`03001oo`0000Eoo`03001oogoo
0?moofMoo`0301moogoo00Eoo`04CW=BU4icCW<26<H00006Lia>LdicCW<LiaS69goo00<007ooOol0
1goo00D007ooOomoo`00009oo`07001oogooOol007oo00000goo00<007ooOol00goo00<007ooOol0
17oo00<007ooOol017oo00<007ooOol01Goo1@001Goo00<007ooOol01Woo00<007ooOol00Woo00D0
07ooOomoo`0000Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo0?moofAoo`@07`Moo`A>
L`4Li`4HaP0000Ig_DicDYA>LaS67>LWOol00`00Oomoo`07Ool00`00Oomoo`04Ool01`00Oomoogoo
001oo`0000=oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Moo`03
001oogoo00Eoo`03001oo`0000Ioo`03001oogoo009oo`05001oogooOol00004Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool00`00Oomoo`3oOomWOol00`0OOomoo`05Ool3CW<1DY@16<H16<H00006Lia>
LdicCW<LiaS69goo00<007ooOol01goo00<007ooOol017oo00L007ooOomoo`00Ool00003Ool00`00
Oomoo`03Ool00`00Oomoo`03Ool00`00Ool00005Ool00`00Oomoo`07Ool00`00Oomoo`05Ool30005
Ool00`00Ool00003Ool01@00Oomoogoo000017oo00<007ooOol00goo00<007oo00001Goo00<007oo
Ool0ogooIWoo0P0O1goo00EBU4icCW=>LacW004HaP0000Ig_DicCW=>LaS67>LXOol01@00Oomoogoo
000017oo00<007ooOol01Goo0`000goo1@0017oo00<007ooOol00Woo0P0000=oo`00000017oo00<0
07ooOol03goo00<007oo000017oo0P0000Aoo`00001oo`D000Eoo`03001oogoo009oo`800003Ool0
000000Aoo`03001oogoo0?moofEoo`0301moo`0O00Moo`A>L`8HaP0000IcW5:DCW=>LacW6<HYOol3
0005Ool00`00Oomoo`0DOol00`00Oomoo`0;Ool00`00Oomoo`0?Ool01@00Oomoogoo00004Woo00<0
07ooOol02goo00<007ooOol0ogooI7oo00@07gooOol07`Moo`9>L`03DYA>LacW004HaP0000Ig_Dic
CW=>LaS67>L`Ool3000EOol2000;Ool2000@Ool6000BOol2000;Ool2003oOomUOol01@0OOomoogoo
01l01goo14ic0QS600001W>LCW=>Ldic7>LHa_mooo9oo`H07`Moo`04DYA>LdicCW<27>L00006Mke>
Le:DCW<HaQcWogooogoo14ic0QS600001W>LCW=>Ldic7>LHa_mooomoo`05CW=BU4icCW<Li`016<H0
0006Mke>LdicCW<HaQcWogooogoo14ic0QS600001W>LCW=>Ldic7>LHa_mooomoo`9>L`03DYA>LacW
004HaP0000Ig_DicDYA>LaS67>OoOoooOol015:DCW=>Ldic0QS600001W>LCW=>Ldic7>LHa_mooomo
o`A>L`4Li`4HaP0000Ig_DicCW=>LaS67>OoOoooOol3CW<1DY@16<H16<H00006LiaBU4icCW<LiaS6
ogooogoo00E>Le:DCW=>LacW004HaP0000Ig_DicCW=>LaS67>OoOoocOol501l7Ool4CW<26<H00006
Lia>LdicCW<LiaS6ogoomgoo00<07gooOol01Goo00EBU4icCW=>LacW004HaP0000Ig_DicDYA>LaS6
7>LSOol3000COol200000goo00000007Ool00`00Oomoo`04Ool5003oOonVOol00`0OOomoo`05Ool4
CW<26<H00006Lia>LdicCW<LiaS68Woo00D007ooOomoo`0001=oo`03001oo`0000Qoo`03001oogoo
00Ioo`03001oogoo0?moojIoo`0301moogoo00Eoo`9>L`03DYA>LacW004HaP0000Ig_DicCW=>LaS6
7>LWOol00`00Oomoo`0AOol00`00Oomoo`05Ool50006Ool00`00Oomoo`3oOonVOol00`0OOomoo`05
Ool4CW<26<H00006Lia>LdicCW<LiaS69goo00<007ooOol04Goo00<007ooOol01goo00<007ooOol0
1Woo00<007ooOol0ogooYWoo00<07gooOol01Goo00EBU4icCW=>LacW004HaP0000Ig_DicDYA>LaS6
7>LWOol00`00Oomoo`0@Ool00`00Ool00008Ool00`00Oomoo`06Ool00`00Oomoo`3oOonVOol00`0O
Oomoo`05Ool3CW<1DY@16<H16<H00006Lia>LdicCW<LiaS69goo00<007ooOol03goo0P0000=oo`00
00003Woo00<007oo0000ogooZ7oo00<07gooOol01Goo14ic0AcW0AS600001WNmCW=>Ldic6<HLibMo
o`03001oogoo02=oo`800?moojQoo`0301moogoo00Eoo`9>L`03DYA>LaS6004HaP0000IcW5:DCW=>
LacW6<HWOol00`00Oomoo`0TOol00`00Oomoo`3oOon<Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool0
0`0OOomoo`05Ool4CW<27>L00006Mke>LdicCW<HaQcW9goo00<007ooOol0ogoo/Woo00<007ooOol0
2goo00<007ooOol02Woo00<07gooOol01Goo00A>Le:DCW=>L`8HaP0000IcW4icCW=>LacW6<HWOol0
0`00Oomoo`3oOonbOol00`00Oomoo`02Ool50004Ool00`00Oomoo`0:Ool00`0OOomoo`05Ool4CW<1
7>L16<H00006Mke>Le:DCW<HaQcW9goo00<007ooOol0>7oo1`000Woo0P0000=oo`000000ogooJgoo
00<007ooOol00goo00D007ooOomoo`0000Eoo`03001oogoo00Uoo`0301moogoo00Eoo`=>L`5BU04H
aP4HaP0000IcW4icCW=>LacW6<HWOol00`00Oomoo`0gOol01`00Oomoogoo001oo`0000Aoo`03001o
o`000?moofaoo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00Uoo`0301moogoo00Eoo`05
DYA>LdicCW<Li`016<H00006Mke>LdicCW<HaQcW9goo00<007ooOol01Goo;@001Goo00L007ooOomo
o`00Ool00005Ool00`00Oomoo`3oOom[Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`09
Ool00`0OOomoo`05Ool4CW<26<H00006Lia>LdicCW<LiaS69goo00<007ooOol0=goo00L007ooOomo
o`00Ool00005Ool00`00Oomoo`3oOom[Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`09
Ool00`0OOomoo`05Ool01DicDYA>Ldic7>L00AS600001WNmCW=BU4ic6<HLibMoo`03001oogoo03Qo
o`@00003Ool007oo00=oo`03001oo`000?moofeoo`03001oogoo00Ioo`03001oogoo009oo`03001o
ogoo00Yoo`0301moogoo00Eoo`A>L`8HaP0000IcW4icCW=>LacW6<HWOol00`00Oomoo`0kOol00`00
Ool00003Ool200000goo0000003oOom/Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00<007oo
Ool02Woo00<07gooOol01Goo0Tic00=BU4ic7>L00AS600001WNmCW=>Ldic6<HLibMoo`03001oogoo
03]oo`03001oo`000?moogEoo`03001oogoo009oo`<000Aoo`03001oogoo00]oo`0301moogoo00Eo
o`04DYA>LdicCW<26<H00006LiaBU4icCW<LiaS69goo00<007ooOol07Woo0P002goo0P003Goo1000
ogooSgoo00<07gooOol01Goo14ic0AcW0AS600001WNmCW=>Ldic6<HLibMoo`03001oogoo01ioo`03
001oogoo00]oo`03001oogoo0?mooiioo`0301moogoo00Eoo`=>L`5BU04HaP4HaP0000IcW4icCW=>
LacW6<HWOol00`00Oomoo`07Ool40003Ool500001Goo00000000Ool00`000goo00<007ooOol00Woo
0P0000=oo`00000017oo00<007ooOol0ogooWWoo00<07gooOol01Goo00E>Le:DCW=>LacW004HaP00
00Ig_DicDYA>LaS67>LWOol00`00Oomoo`07Ool01@00Oomoogoo000017oo00<007ooOol00Woo00D0
07ooOomoo`0000Aoo`03001oogoo00=oo`03001oo`0000Eoo`03001oogoo0?mooiioo`0301moogoo
00Eoo`A>L`8HaP0000IcW4icCW=>LacW6<HWOol00`00Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool01@00Oomoogoo000017oo00<007ooOol017oo00<007ooOol017oo00<007ooOol0ogooVgoo
100O1goo00EBU4icCW=>LaS6004Li`0000Ig_DicCW=>LaS67>LWOol00`00Oomoo`0;Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol0ogooWWoo00<07gooOol01Goo14ic0AcW0AS600001W>LCW=>Ldic7>LHaRMoo`03001oogoo
00Qoo`<000Eoo`03001oogoo009oo`80009oo`03001oogoo009oo`03001oogoo00=oo`03001oo`00
00Eoo`03001oogoo0?mooieoo`807`Moo`=>L`5BU04HaP4Li`0000Ig_DicDYA>LaS67>LXOol01@00
Oomoogoo000017oo00<007ooOol017oo0`000goo0P0000=oo`0000001Goo00<007ooOol00Woo0P00
00=oo`00000017oo00<007ooOol0ogooW7oo00<07goo01l01goo14ic0QS600001W>LCW=>Ldic7>LH
aRUoo`<000Eoo`05001oogooOol0000BOol00`00Oomoo`0;Ool00`00Oomoo`3oOonKOol0100OOomo
o`0O1goo00EBU4icCW=>LacW004HaP0000Ig_DicCW=>LaS67>LbOol40004Ool00`00Oomoo`0;Ool2
000;Ool2003oOonLOol01@0OOomoogoo01l01goo0Tic00=BU4ic6<H00AS600001W>LDYA>Ldic7>LH
a_mooo9oo`H07`Moo`A>L`4Li`4HaP0000Ig_DicCW=>LaS67>OoOoooOol3CW<1DY@16<H16<H00006
Lia>LdicCW<LiaS6ogooogoo14ic0AcW0AS600001WNmCW=BU4ic6<HLiomooomoo`04CW=BU4icCW<2
6<H00006Lia>LdicCW<LiaS6ogooogoo14ic0AcW0AS600001WNmCW=>Ldic6<HLiomooomoo`=>L`5B
U04HaP4HaP0000IcW4icCW=>LacW6<KoOoooOol01E:DCW=>Ldic7>L00AS600001WNmCW=BU4ic6<HL
iomooomoo`A>L`8HaP0000IcW4icCW=>LacW6<KoOoooOol2CW<00e:DCW<Li`016<H00006Mke>Ldic
CW<HaQcWogoolgoo1@0O1goo14ic0QS600001W>LDYA>Ldic7>LHa_moooMoo`0301moogoo00Eoo`04
DYA>LdicCW<27>L00006Mke>LdicCW<HaQcW8goo0`002goo0P0000=oo`0000001goo00<007ooOol0
1Goo1@00ogoo[Goo00<07gooOol01Goo14ic0QS600001W>LCW=>Ldic7>LHaR9oo`05001oogooOol0
000;Ool00`00Ool00008Ool00`00Oomoo`07Ool00`00Oomoo`3oOon]Ool00`0OOomoo`05Ool01Dic
DYA>Ldic7>L00AS600001WNmCW=BU4ic6<HLibMoo`03001oogoo00Uoo`03001oogoo00Eoo`D000Mo
o`03001oogoo0?moojeoo`0301moogoo00Eoo`A>L`8HaP0000IcW4icCW=>LacW6<HWOol00`00Oomo
o`09Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`3oOon]Ool00`0OOomoo`05Ool2CW<0
0e:DCW<Li`016<H00006Mke>LdicCW<HaQcW9goo00<007ooOol027oo00<007oo000027oo00<007oo
Ool01goo00<007ooOol0ogoo[Goo00<07gooOol01Goo00ABU4icCW=>L`8HaP0000IcW4icCW=>LacW
6<HWOol00`00Oomoo`07Ool200000goo0000000?Ool00`00Ool0003oOon_Ool00`0OOomoo`05Ool4
CW<17>L16<H00006Mke>Le:DCW<HaQcW9goo00<007ooOol077oo0P00ogoo[goo00<07gooOol01Goo
0dic0E:D0AS60AS600001W>LCW=>Ldic7>LHaRMoo`03001oogoo01eoo`03001oogoo0?mooi=oo`03
001oogoo00Uoo`03001oogoo00]oo`0301moogoo00Eoo`05CW=BU4icCW<Li`016<H00006Mke>Ldic
CW<HaQcW9goo00<007ooOol0ogoo/Woo00<007ooOol02goo00<007ooOol02Woo00<07gooOol01Goo
14ic0QS600001W>LDYA>Ldic7>LHaRMoo`03001oogoo0?mook9oo`03001oogoo009oo`D000Aoo`03
001oogoo00Yoo`0301moogoo00Eoo`05DYA>LdicCW<Li`016<H00006Mke>LdicCW<HaQcW9goo00<0
07ooOol0:7oo1`000goo0P0000=oo`000000ogooNWoo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol02Goo00<07gooOol01Goo14ic0QS600001W>LCW=>Ldic7>LHaRMoo`03001oogoo02Moo`07
001oogooOol007oo00001Goo00<007oo0000ogooNgoo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol02Goo00<07gooOol01Goo0Tic00=BU4ic7>L00AS600001WNmCW=BU4ic6<HLibMoo`03001o
ogoo00Eooad000Eoo`07001oogooOol007oo00001Woo00<007ooOol0ogooNWoo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol02Goo00<07gooOol01Goo14ic0QS600001W>LCW=>Ldic7>LHaRMo
o`03001oogoo02Moo`07001oogooOol007oo00001Woo00<007ooOol0ogooNWoo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol02Goo00<07gooOol01Goo00EBU4icCW=>LacW004HaP0000Ig_Dic
CW=>LaS67>LWOol00`00Oomoo`0XOol400000goo001oo`04Ool00`00Ool0003oOomlOol00`00Oomo
o`02Ool00`00Ool00006Ool00`00Oomoo`0:Ool00`0OOomoo`05Ool3CW<1DY@16<H16<H00006Lia>
LdicCW<LiaS69goo00<007ooOol0:goo00<007oo000017oo0P0000=oo`000000ogooNgoo00<007oo
Ool00goo0P001Woo00<007ooOol02Woo00<07gooOol01Goo14ic0AcW0AS600001WNmCW=BU4ic6<HL
ibMoo`03001oogoo02]oo`03001oo`000?moohEoo`03001oogoo00=oo`03001oogoo00=oo`03001o
ogoo00]oo`0301moogoo00Eoo`9>L`03DYA>LaS6004HaP0000IcW4icCW=>LacW6<HWOol00`00Oomo
o`0ZOol4003oOonOOol00`0OOomoo`05Ool4CW<27>L00006Mke>LdicCW<HaQcW9goo00<007ooOol0
ogoocGoo00<07gooOol01Goo00A>Le:DCW=>L`8HaP0000IcW5:DCW=>LacW6<HWOol00`00Oomoo`0A
Ool200000goo0000003oOongOol00`0OOomoo`05Ool4CW<17>L16<H00006Mke>LdicCW<HaQcW9goo
00<007ooOol04Woo00<007oo0000ogoo]Goo100O1goo0dic0E:D0AS60AS600001W>LCW=>Ldic7>LH
aRMoo`03001oogoo01=oo`03001oogoo0?mookMoo`0301moogoo00Eoo`05DYA>LdicCW<Li`016<H0
0006Mke>Le:DCW<HaQcW9goo00<007ooOol04goo00<007ooOol0ogoo]Woo0P0O1goo14ic0QS60000
1W>LCW=>Ldic7>LHaRMoo`03001oogoo019oo`03001oo`000?mookIoo`0301moo`0O00Moo`05CW=B
U4icCW<Li`016<H00006Mke>LdicCW<HaQcW:7oo00D007ooOomoo`0000ioo`800003Ool000000?mo
okAoo`0401moogoo01l7Ool4CW<26<H00006Lia>LdicCW<LiaS6:Goo0`00ogooagoo00D07gooOomo
o`0O00Moo`9>L`03DYA>LacW004HaP0000Ig_DicDYA>LaS67>OoOoobOol601l7Ool015:DCW=>Ldic
0QS600001W>LCW=>Ldic7>LHa_mooomoo`A>L`4Li`4HaP0000Ig_DicCW=>LaS67>OoOoooOol3CW<1
DY@16<H16<H00006LiaBU4icCW<LiaS6ogooogoo00E>Le:DCW=>LacW004HaP0000Ig_DicCW=>LaS6
7>OoOoonOol00gNmCW=>L`02CW<26<H00004Lia>Le:DCW<26<KoOoonOol00gNmCW=>L`02CW<17>L1
6<H00006Mke>LdicCW<HaQcWogoooWoo00Eg_DicCW=BU4ic008HaP0000IcW4icCW=>LacW6<KoOoon
Ool00gNmCW=>L`02CW<17>L16<H00006MkeBU4icCW<HaQcWogoooWoo00Eg_DicCW=>Le:D008HaP00
00EcW4icCW=>LacW008HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LH
aQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS6
00@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS6
7>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@L
iaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L2
6<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS6
6<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H0
11cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HL
i`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW
6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8H
aP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HH
aQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP04
7>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW
0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LH
aQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS6
00@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS6
7>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@L
iaS66<HLi`8HaP047>LHaQS67>L26<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP047>LHaQS67>L2
6<H011cW6<HHaQcW0QS600@LiaS66<HLi`8HaP057>LHaQcW6<Ig_@04CW<16<H17>L00005Mke>Ldic
DY@HaP027>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW
00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW
6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@H
aQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H2
7>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW
7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L0
11S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LH
aP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S6
7>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8L
i`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LL
iaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`04
6<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS6
0QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HL
iacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW
00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW
6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@H
aQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H2
7>L011S67>LLiaS60QcW00@HaQcW7>LHaP8Li`046<HLiacW6<H27>L011S67>LLiaS60QcW00@HaQcW
7>LHaP8Li`046<HLiacW6<H27>L01AS67>LHaQcWMkd014ic0AcW0AS600000g>LCW=>L`3oCW?oCW<7
CW<16<H17>L00003Mke>Ldic0?m>Lom>L`A>L`04DYA>Ldic7>L16<H00005LiaBU4icCW=BU002CW<0
15:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=B
U09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:D
CW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>
L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>
Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04
DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D
0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>
LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic
00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>Ldic
DY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00AB
U4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2
CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4ic
CW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<0
15:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=B
U09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:D
CW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>
L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>
Le:D0Tic00ABU4icCW=BU09>L`04DYA>LdicDY@2CW<015:DCW=>Le:D0Tic00ABU4icCW=BU09>L`04
DYA>LdicDY@2CW<015:DCW=>Le:D1Dic0AS60AcW00000gNmCW=>L`3oCW?oCW<7CW<17>L16<H0009c
W004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiac
W7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004
MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm
0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004Mkec
W7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L
00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>L
Mkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag
_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2
Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>L
Liag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`0
17NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag
_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017Nm
LiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9c
W004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiac
W7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004
MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm
0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004Mkec
W7>LMkd2Li`017NmLiacW7Nm0W>L00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L
00Ag_G>LLiag_@9cW004MkecW7>LMkd2Li`017NmLiacW7Nm0W>L00=g_G>LLi`00AS60000\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 140},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.10.14"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.10.15 Exposition in ",
  StyleBox["Mathematica", "SBO"],
  " Notebooks"
}], "Subsection",
  CellTags->{"S1.10.15", "15.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " notebooks provide the basic technology that you need to be able to create \
a very wide range of sophisticated interactive documents. But to get the best \
out of this technology you need to develop an appropriate style of \
exposition. "
}], "Text",
  CellTags->{"S1.10.15", "15.2"}],

Cell[TextData[{
  "Many people at first tend to use ",
  StyleBox["Mathematica", "TI"],
  " notebooks either as simple worksheets containing a sequence of input and \
output lines, or as on\[Hyphen]screen versions of traditional books and other \
printed material. But the most effective and productive uses of ",
  StyleBox["Mathematica", "TI"],
  " notebooks tend to lie at neither one of these extremes, and instead \
typically involve a fine\[Hyphen]grained mixing of ",
  StyleBox["Mathematica", "TI"],
  " input and output with explanatory text. In most cases the single most \
important factor in obtaining such fine\[Hyphen]grained mixing is uniform use \
of the ",
  StyleBox["Mathematica", "TI"],
  " language. "
}], "Text",
  CellTags->{"S1.10.15", "15.3"}],

Cell[TextData[{
  "One might think that there would tend to be three kinds of material in a \
",
  StyleBox["Mathematica", "TI"],
  " notebook: plain text, mathematical formulas, and computer code. But one \
of the key ideas of ",
  StyleBox["Mathematica", "TI"],
  " is to provide a single language that offers the best of both traditional \
mathematical formulas and computer code. "
}], "Text",
  CellTags->{"S1.10.15", "15.4"}],

Cell[TextData[{
  "In ",
  StyleBox["StandardForm", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " expressions have the same kind of compactness and elegance as traditional \
mathematical formulas. But unlike such formulas, ",
  StyleBox["Mathematica", "TI"],
  " expressions are set up in a completely consistent and uniform way. As a \
result, if you use ",
  StyleBox["Mathematica", "TI"],
  " expressions, then regardless of your subject matter, you never have to go \
back and reexplain your basic notation: it is always just the notation of the \
",
  StyleBox["Mathematica", "TI"],
  " language. In addition, if you set up your explanations in terms of ",
  StyleBox["Mathematica", "TI"],
  " expressions, then a reader of your notebook can immediately take what you \
have given, and actually execute it as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "Text",
  CellTags->{"S1.10.15", "15.5"}],

Cell[TextData[{
  "If one has spent many years working with traditional mathematical \
notation, then it takes a little time to get used to seeing mathematical \
facts presented as ",
  StyleBox["StandardForm", "MR"],
  " ",
  StyleBox["Mathematica", "TI"],
  " expressions. Indeed, at first one often has a tendency to try to use ",
  StyleBox["TraditionalForm", "MR"],
  " whenever possible, perhaps with hidden tags to indicate its \
interpretation. But quite soon one tends to evolve to a mixture of ",
  StyleBox["StandardForm", "MR"],
  " and ",
  StyleBox["TraditionalForm", "MR"],
  ". And in the end it becomes clear that ",
  StyleBox["StandardForm", "MR"],
  " alone is for most purposes the most effective form of presentation. "
}], "Text",
  CellTags->{"S1.10.15", "15.6"}],

Cell[TextData[{
  "In traditional mathematical exposition, there are many tricks for \
replacing chunks of text by fragments of formulas. In ",
  StyleBox["StandardForm", "MR"],
  " many of these same tricks can be used. But the fact that ",
  StyleBox["Mathematica", "TI"],
  " expressions can represent not only mathematical objects but also \
procedures and algorithms increases greatly the extent to which chunks of \
text can be replaced by shorter and more precise material. "
}], "Text",
  CellTags->{"S1.10.15", "15.7"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.10.0"->{
    Cell[1776, 53, 134, 4, 65, "Section",
      CellTags->{"S1.10.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 134, 4, 65, "Section",
      CellTags->{"S1.10.0", "0.1"}]},
  "S1.10.1"->{
    Cell[1935, 61, 83, 1, 70, "Subsection",
      CellTags->{"S1.10.1", "1.1"}],
    Cell[2021, 64, 1341, 38, 70, "DefinitionBox",
      CellTags->"S1.10.1"],
    Cell[3365, 104, 85, 1, 70, "Caption",
      CellTags->"S1.10.1"],
    Cell[3453, 107, 107, 1, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.2"}],
    Cell[3563, 110, 33973, 424, 70, 33836, 419, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.1"],
    Cell[37539, 536, 154, 4, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.3"}],
    Cell[37718, 544, 95, 2, 70, "Input",
      CellTags->"S1.10.1"],
    Cell[37816, 548, 165, 4, 70, "Output",
      CellTags->"S1.10.1"],
    Cell[37996, 555, 140, 4, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.4"}],
    Cell[38161, 563, 97, 2, 70, "Input",
      CellTags->"S1.10.1"],
    Cell[38261, 567, 165, 4, 70, "Output",
      CellTags->"S1.10.1"],
    Cell[38441, 574, 17500, 349, 70, "DoubleBox",
      CellTags->"S1.10.1"],
    Cell[55944, 925, 327, 9, 70, "Caption",
      CellTags->"S1.10.1"],
    Cell[56274, 936, 302, 10, 70, "Text",
      CellTags->{"S1.10.1", "1.5"}],
    Cell[56579, 948, 184, 7, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.6"}],
    Cell[56788, 959, 73, 2, 70, "Input",
      CellTags->"S1.10.1"],
    Cell[56864, 963, 100, 3, 70, "Output",
      CellTags->"S1.10.1"],
    Cell[56979, 969, 134, 4, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.7"}],
    Cell[57138, 977, 108, 2, 70, "Input",
      CellTags->"S1.10.1"],
    Cell[57249, 981, 253, 5, 70, "Output",
      CellTags->"S1.10.1"],
    Cell[57517, 989, 336, 11, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.8"}],
    Cell[57878, 1004, 92, 2, 70, "Input",
      CellTags->"S1.10.1"],
    Cell[57973, 1008, 165, 4, 70, "Output",
      CellTags->"S1.10.1"]},
  "1.1"->{
    Cell[1935, 61, 83, 1, 70, "Subsection",
      CellTags->{"S1.10.1", "1.1"}]},
  "1.2"->{
    Cell[3453, 107, 107, 1, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.2"}]},
  "1.3"->{
    Cell[37539, 536, 154, 4, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.3"}]},
  "1.4"->{
    Cell[37996, 555, 140, 4, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.4"}]},
  "1.5"->{
    Cell[56274, 936, 302, 10, 70, "Text",
      CellTags->{"S1.10.1", "1.5"}]},
  "1.6"->{
    Cell[56579, 948, 184, 7, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.6"}]},
  "1.7"->{
    Cell[56979, 969, 134, 4, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.7"}]},
  "1.8"->{
    Cell[57517, 989, 336, 11, 70, "MathCaption",
      CellTags->{"S1.10.1", "1.8"}]},
  "S1.10.2"->{
    Cell[58187, 1018, 107, 3, 70, "Subsection",
      CellTags->{"S1.10.2", "2.1"}],
    Cell[58297, 1023, 283, 11, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.2"}],
    Cell[58605, 1038, 68, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[58676, 1042, 86, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[58777, 1048, 280, 8, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.3"}],
    Cell[59082, 1060, 85, 3, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[59170, 1065, 86, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[59271, 1071, 323, 9, 70, "Text",
      CellTags->{"S1.10.2", "2.4"}],
    Cell[59597, 1082, 143, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.5"}],
    Cell[59743, 1088, 11984, 152, 70, 11848, 147, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.2"],
    Cell[71730, 1242, 153, 4, 70, "Text",
      CellTags->{"S1.10.2", "2.6"}],
    Cell[71886, 1248, 1732, 46, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[73621, 1296, 281, 7, 70, "Caption",
      CellTags->"S1.10.2"],
    Cell[73905, 1305, 384, 9, 70, "Text",
      CellTags->{"S1.10.2", "2.7"}],
    Cell[74292, 1316, 519, 11, 70, "Text",
      CellTags->{"S1.10.2", "2.8"}],
    Cell[74814, 1329, 165, 6, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.9"}],
    Cell[75004, 1339, 158, 6, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[75165, 1347, 86, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[75266, 1353, 153, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.10"}],
    Cell[75444, 1362, 162, 6, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[75609, 1370, 94, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[75718, 1376, 276, 7, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.11"}],
    Cell[76019, 1387, 294, 9, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[76316, 1398, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[76421, 1404, 760, 22, 70, "Text",
      CellTags->{"S1.10.2", "2.12"}],
    Cell[77184, 1428, 781, 20, 70, "Text",
      CellTags->{"S1.10.2", "2.13"}],
    Cell[77968, 1450, 143, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.14"}],
    Cell[78136, 1458, 83, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[78222, 1462, 86, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[78323, 1468, 261, 9, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.15"}],
    Cell[78609, 1481, 87, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[78699, 1485, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[78804, 1491, 441, 9, 70, "Text",
      CellTags->{"S1.10.2", "2.16"}],
    Cell[79248, 1502, 430, 11, 70, "Text",
      CellTags->{"S1.10.2", "2.17"}],
    Cell[79681, 1515, 247, 9, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.18"}],
    Cell[79931, 1526, 4921, 65, 70, 4785, 60, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.2"],
    Cell[84855, 1593, 231, 7, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.19"}],
    Cell[85089, 1602, 4030, 54, 70, 3894, 49, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.2"],
    Cell[89122, 1658, 1732, 46, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[90857, 1706, 96, 1, 70, "Caption",
      CellTags->"S1.10.2"],
    Cell[90956, 1709, 584, 20, 70, "Text",
      CellTags->{"S1.10.2", "2.20"}],
    Cell[91543, 1731, 130, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.21"}],
    Cell[91698, 1740, 158, 6, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[91859, 1748, 86, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[91960, 1754, 147, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.22"}],
    Cell[92132, 1763, 83, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[92218, 1767, 86, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[92319, 1773, 1161, 32, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[93483, 1807, 122, 4, 70, "Caption",
      CellTags->"S1.10.2"],
    Cell[93608, 1813, 299, 11, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.23"}],
    Cell[93932, 1828, 159, 6, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[94094, 1836, 87, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[94196, 1842, 204, 9, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.24"}],
    Cell[94425, 1855, 163, 6, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[94591, 1863, 95, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[94701, 1869, 246, 8, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.25"}],
    Cell[94972, 1881, 295, 9, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[95270, 1892, 91, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[95376, 1898, 174, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.26"}],
    Cell[95575, 1906, 92, 3, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[95670, 1911, 84, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[95769, 1917, 124, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.27"}],
    Cell[95918, 1925, 90, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[96011, 1929, 84, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[96110, 1935, 1543, 39, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[97656, 1976, 98, 1, 70, "Caption",
      CellTags->"S1.10.2"],
    Cell[97757, 1979, 83, 1, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.28"}],
    Cell[97865, 1984, 161, 6, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[98029, 1992, 94, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[98138, 1998, 122, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.29"}],
    Cell[98285, 2006, 293, 9, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[98581, 2017, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[98686, 2023, 99, 1, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.30"}],
    Cell[98810, 2028, 86, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[98899, 2032, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[99004, 2038, 203, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.31"}],
    Cell[99232, 2047, 77, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[99312, 2051, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[99417, 2057, 2042, 53, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[101462, 2112, 153, 4, 70, "Caption",
      CellTags->"S1.10.2"],
    Cell[101618, 2118, 151, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.32"}],
    Cell[101794, 2127, 235, 8, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[102032, 2137, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[102137, 2143, 106, 1, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.33"}],
    Cell[102268, 2148, 235, 8, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[102506, 2158, 90, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[102611, 2164, 4473, 142, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[107087, 2308, 144, 4, 70, "Caption",
      CellTags->"S1.10.2"],
    Cell[107234, 2314, 193, 7, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.34"}],
    Cell[107452, 2325, 95, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[107550, 2329, 97, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[107662, 2335, 270, 8, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.35"}],
    Cell[107957, 2347, 103, 2, 70, "Input",
      CellTags->"S1.10.2"],
    Cell[108063, 2351, 101, 3, 70, "Output",
      CellTags->"S1.10.2"],
    Cell[108179, 2357, 372, 8, 70, "Text",
      CellTags->{"S1.10.2", "2.36"}],
    Cell[108554, 2367, 4032, 116, 70, "DefinitionBox",
      CellTags->"S1.10.2"],
    Cell[112589, 2485, 80, 1, 70, "Caption",
      CellTags->"S1.10.2"]},
  "2.1"->{
    Cell[58187, 1018, 107, 3, 70, "Subsection",
      CellTags->{"S1.10.2", "2.1"}]},
  "2.2"->{
    Cell[58297, 1023, 283, 11, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.2"}]},
  "2.3"->{
    Cell[58777, 1048, 280, 8, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.3"}]},
  "2.4"->{
    Cell[59271, 1071, 323, 9, 70, "Text",
      CellTags->{"S1.10.2", "2.4"}]},
  "2.5"->{
    Cell[59597, 1082, 143, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.5"}]},
  "2.6"->{
    Cell[71730, 1242, 153, 4, 70, "Text",
      CellTags->{"S1.10.2", "2.6"}]},
  "2.7"->{
    Cell[73905, 1305, 384, 9, 70, "Text",
      CellTags->{"S1.10.2", "2.7"}]},
  "2.8"->{
    Cell[74292, 1316, 519, 11, 70, "Text",
      CellTags->{"S1.10.2", "2.8"}]},
  "2.9"->{
    Cell[74814, 1329, 165, 6, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.9"}]},
  "2.10"->{
    Cell[75266, 1353, 153, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.10"}]},
  "2.11"->{
    Cell[75718, 1376, 276, 7, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.11"}]},
  "2.12"->{
    Cell[76421, 1404, 760, 22, 70, "Text",
      CellTags->{"S1.10.2", "2.12"}]},
  "2.13"->{
    Cell[77184, 1428, 781, 20, 70, "Text",
      CellTags->{"S1.10.2", "2.13"}]},
  "2.14"->{
    Cell[77968, 1450, 143, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.14"}]},
  "2.15"->{
    Cell[78323, 1468, 261, 9, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.15"}]},
  "2.16"->{
    Cell[78804, 1491, 441, 9, 70, "Text",
      CellTags->{"S1.10.2", "2.16"}]},
  "2.17"->{
    Cell[79248, 1502, 430, 11, 70, "Text",
      CellTags->{"S1.10.2", "2.17"}]},
  "2.18"->{
    Cell[79681, 1515, 247, 9, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.18"}]},
  "2.19"->{
    Cell[84855, 1593, 231, 7, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.19"}]},
  "2.20"->{
    Cell[90956, 1709, 584, 20, 70, "Text",
      CellTags->{"S1.10.2", "2.20"}]},
  "2.21"->{
    Cell[91543, 1731, 130, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.21"}]},
  "2.22"->{
    Cell[91960, 1754, 147, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.22"}]},
  "2.23"->{
    Cell[93608, 1813, 299, 11, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.23"}]},
  "2.24"->{
    Cell[94196, 1842, 204, 9, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.24"}]},
  "2.25"->{
    Cell[94701, 1869, 246, 8, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.25"}]},
  "2.26"->{
    Cell[95376, 1898, 174, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.26"}]},
  "2.27"->{
    Cell[95769, 1917, 124, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.27"}]},
  "2.28"->{
    Cell[97757, 1979, 83, 1, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.28"}]},
  "2.29"->{
    Cell[98138, 1998, 122, 4, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.29"}]},
  "2.30"->{
    Cell[98686, 2023, 99, 1, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.30"}]},
  "2.31"->{
    Cell[99004, 2038, 203, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.31"}]},
  "2.32"->{
    Cell[101618, 2118, 151, 5, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.32"}]},
  "2.33"->{
    Cell[102137, 2143, 106, 1, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.33"}]},
  "2.34"->{
    Cell[107234, 2314, 193, 7, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.34"}]},
  "2.35"->{
    Cell[107662, 2335, 270, 8, 70, "MathCaption",
      CellTags->{"S1.10.2", "2.35"}]},
  "2.36"->{
    Cell[108179, 2357, 372, 8, 70, "Text",
      CellTags->{"S1.10.2", "2.36"}]},
  "S1.10.3"->{
    Cell[112706, 2491, 129, 4, 70, "Subsection",
      CellTags->{"S1.10.3", "3.1"}],
    Cell[112838, 2497, 362, 7, 70, "Text",
      CellTags->{"S1.10.3", "3.2"}],
    Cell[113203, 2506, 199, 5, 70, "Text",
      CellTags->{"S1.10.3", "3.3"}],
    Cell[113405, 2513, 1104, 27, 70, "DefinitionBox",
      CellTags->"S1.10.3"],
    Cell[114512, 2542, 112, 4, 70, "Caption",
      CellTags->"S1.10.3"],
    Cell[114627, 2548, 219, 6, 70, "MathCaption",
      CellTags->{"S1.10.3", "3.4"}],
    Cell[114849, 2556, 110704, 1371, 70, 110567, 1366, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.3"],
    Cell[225556, 3929, 462, 13, 70, "DefinitionBox",
      CellTags->"S1.10.3"],
    Cell[226021, 3944, 106, 4, 70, "Caption",
      CellTags->"S1.10.3"],
    Cell[226130, 3950, 439, 8, 70, "Text",
      CellTags->{"S1.10.3", "3.5"}],
    Cell[226572, 3960, 243, 5, 70, "Text",
      CellTags->{"S1.10.3", "3.6"}],
    Cell[226818, 3967, 100, 1, 70, "MathCaption",
      CellTags->{"S1.10.3", "3.7"}],
    Cell[226921, 3970, 13823, 175, 70, 13687, 170, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.3"],
    Cell[240747, 4147, 138, 4, 70, "MathCaption",
      CellTags->{"S1.10.3", "3.8"}],
    Cell[240888, 4153, 13604, 172, 70, 13468, 167, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.3"]},
  "3.1"->{
    Cell[112706, 2491, 129, 4, 70, "Subsection",
      CellTags->{"S1.10.3", "3.1"}]},
  "3.2"->{
    Cell[112838, 2497, 362, 7, 70, "Text",
      CellTags->{"S1.10.3", "3.2"}]},
  "3.3"->{
    Cell[113203, 2506, 199, 5, 70, "Text",
      CellTags->{"S1.10.3", "3.3"}]},
  "3.4"->{
    Cell[114627, 2548, 219, 6, 70, "MathCaption",
      CellTags->{"S1.10.3", "3.4"}]},
  "3.5"->{
    Cell[226130, 3950, 439, 8, 70, "Text",
      CellTags->{"S1.10.3", "3.5"}]},
  "3.6"->{
    Cell[226572, 3960, 243, 5, 70, "Text",
      CellTags->{"S1.10.3", "3.6"}]},
  "3.7"->{
    Cell[226818, 3967, 100, 1, 70, "MathCaption",
      CellTags->{"S1.10.3", "3.7"}]},
  "3.8"->{
    Cell[240747, 4147, 138, 4, 70, "MathCaption",
      CellTags->{"S1.10.3", "3.8"}]},
  "S1.10.4"->{
    Cell[254529, 4330, 78, 1, 70, "Subsection",
      CellTags->{"S1.10.4", "4.1"}],
    Cell[254610, 4333, 2138, 67, 70, "DefinitionBox4Col",
      CellTags->"S1.10.4"],
    Cell[256751, 4402, 287, 9, 70, "Caption",
      CellTags->"S1.10.4"],
    Cell[257041, 4413, 165, 7, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.2"}],
    Cell[257231, 4424, 81, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[257315, 4428, 88, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[257418, 4434, 91, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.3"}],
    Cell[257534, 4439, 83, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[257620, 4443, 88, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[257723, 4449, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.4"}],
    Cell[257843, 4454, 154, 6, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[258000, 4462, 88, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[258103, 4468, 85, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.5"}],
    Cell[258213, 4473, 94, 3, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[258310, 4478, 88, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[258413, 4484, 5258, 170, 70, "DefinitionBox4Col",
      CellTags->"S1.10.4"],
    Cell[263674, 4656, 238, 7, 70, "Caption",
      CellTags->"S1.10.4"],
    Cell[263915, 4665, 174, 5, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.6"}],
    Cell[264114, 4674, 86, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[264203, 4678, 102, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[264320, 4684, 84, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.7"}],
    Cell[264429, 4689, 92, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[264524, 4693, 102, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[264641, 4699, 69, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.8"}],
    Cell[264735, 4704, 91, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[264829, 4708, 102, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[264946, 4714, 64, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.9"}],
    Cell[265035, 4719, 164, 6, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[265202, 4727, 102, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[265319, 4733, 211, 6, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.10"}],
    Cell[265555, 4743, 83, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[265641, 4747, 117, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[265773, 4753, 12693, 408, 70, "DefinitionBox4Col",
      CellTags->"S1.10.4"],
    Cell[278469, 5163, 117, 4, 70, "Caption",
      CellTags->"S1.10.4"],
    Cell[278589, 5169, 242, 7, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.11"}],
    Cell[278856, 5180, 79, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[278938, 5184, 87, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[279040, 5190, 354, 8, 70, "Text",
      CellTags->{"S1.10.4", "4.12"}],
    Cell[279397, 5200, 11594, 347, 70, "DefinitionBox3Col",
      CellTags->"S1.10.4"],
    Cell[290994, 5549, 164, 5, 70, "Caption",
      CellTags->"S1.10.4"],
    Cell[291161, 5556, 426, 9, 70, "Text",
      CellTags->{"S1.10.4", "4.13"}],
    Cell[291590, 5567, 267, 6, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.14"}],
    Cell[291882, 5577, 219, 8, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[292104, 5587, 116, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[292235, 5593, 131, 4, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.15"}],
    Cell[292391, 5601, 125, 3, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[292519, 5606, 104, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[292638, 5612, 155, 5, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.16"}],
    Cell[292818, 5621, 89, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[292910, 5625, 104, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[293029, 5631, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.17"}],
    Cell[293149, 5636, 120, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[293272, 5640, 104, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[293391, 5646, 4680, 139, 70, "DefinitionBox3Col",
      CellTags->"S1.10.4"],
    Cell[298074, 5787, 227, 7, 70, "Caption",
      CellTags->"S1.10.4"],
    Cell[298304, 5796, 438, 11, 70, "Text",
      CellTags->{"S1.10.4", "4.18"}],
    Cell[298745, 5809, 88, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.19"}],
    Cell[298858, 5814, 88, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[298949, 5818, 105, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[299069, 5824, 109, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.20"}],
    Cell[299203, 5829, 430, 13, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[299636, 5844, 111, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[299762, 5850, 101, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.21"}],
    Cell[299888, 5855, 119, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[300010, 5859, 111, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[300136, 5865, 993, 25, 70, "Text",
      CellTags->{"S1.10.4", "4.22"}],
    Cell[301132, 5892, 292, 11, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.23"}],
    Cell[301449, 5907, 101, 3, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[301553, 5912, 103, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[301671, 5918, 146, 4, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.24"}],
    Cell[301842, 5926, 75, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[301920, 5930, 103, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[302038, 5936, 92, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.25"}],
    Cell[302155, 5941, 110, 3, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[302268, 5946, 139, 3, 70, "Output",
      CellTags->"S1.10.4"],
    Cell[302422, 5952, 125, 4, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.26"}],
    Cell[302572, 5960, 81, 2, 70, "Input",
      CellTags->"S1.10.4"],
    Cell[302656, 5964, 139, 3, 70, "Output",
      CellTags->"S1.10.4"]},
  "4.1"->{
    Cell[254529, 4330, 78, 1, 70, "Subsection",
      CellTags->{"S1.10.4", "4.1"}]},
  "4.2"->{
    Cell[257041, 4413, 165, 7, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.2"}]},
  "4.3"->{
    Cell[257418, 4434, 91, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.3"}]},
  "4.4"->{
    Cell[257723, 4449, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.4"}]},
  "4.5"->{
    Cell[258103, 4468, 85, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.5"}]},
  "4.6"->{
    Cell[263915, 4665, 174, 5, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.6"}]},
  "4.7"->{
    Cell[264320, 4684, 84, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.7"}]},
  "4.8"->{
    Cell[264641, 4699, 69, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.8"}]},
  "4.9"->{
    Cell[264946, 4714, 64, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.9"}]},
  "4.10"->{
    Cell[265319, 4733, 211, 6, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.10"}]},
  "4.11"->{
    Cell[278589, 5169, 242, 7, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.11"}]},
  "4.12"->{
    Cell[279040, 5190, 354, 8, 70, "Text",
      CellTags->{"S1.10.4", "4.12"}]},
  "4.13"->{
    Cell[291161, 5556, 426, 9, 70, "Text",
      CellTags->{"S1.10.4", "4.13"}]},
  "4.14"->{
    Cell[291590, 5567, 267, 6, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.14"}]},
  "4.15"->{
    Cell[292235, 5593, 131, 4, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.15"}]},
  "4.16"->{
    Cell[292638, 5612, 155, 5, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.16"}]},
  "4.17"->{
    Cell[293029, 5631, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.17"}]},
  "4.18"->{
    Cell[298304, 5796, 438, 11, 70, "Text",
      CellTags->{"S1.10.4", "4.18"}]},
  "4.19"->{
    Cell[298745, 5809, 88, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.19"}]},
  "4.20"->{
    Cell[299069, 5824, 109, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.20"}]},
  "4.21"->{
    Cell[299762, 5850, 101, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.21"}]},
  "4.22"->{
    Cell[300136, 5865, 993, 25, 70, "Text",
      CellTags->{"S1.10.4", "4.22"}]},
  "4.23"->{
    Cell[301132, 5892, 292, 11, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.23"}]},
  "4.24"->{
    Cell[301671, 5918, 146, 4, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.24"}]},
  "4.25"->{
    Cell[302038, 5936, 92, 1, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.25"}]},
  "4.26"->{
    Cell[302422, 5952, 125, 4, 70, "MathCaption",
      CellTags->{"S1.10.4", "4.26"}]},
  "S1.10.5"->{
    Cell[302844, 5973, 89, 1, 70, "Subsection",
      CellTags->{"S1.10.5", "5.1"}],
    Cell[302936, 5976, 388, 9, 70, "Text",
      CellTags->{"S1.10.5", "5.2"}],
    Cell[303327, 5987, 175, 4, 70, "MathCaption",
      CellTags->{"S1.10.5", "5.3"}],
    Cell[303527, 5995, 141, 5, 70, "Input",
      CellTags->"S1.10.5"],
    Cell[303671, 6002, 104, 3, 70, "Output",
      CellTags->"S1.10.5"],
    Cell[303790, 6008, 176, 4, 70, "MathCaption",
      CellTags->{"S1.10.5", "5.4"}],
    Cell[303991, 6016, 172, 6, 70, "Input",
      CellTags->"S1.10.5"],
    Cell[304166, 6024, 104, 3, 70, "Output",
      CellTags->"S1.10.5"],
    Cell[304285, 6030, 242, 9, 70, "MathCaption",
      CellTags->{"S1.10.5", "5.5"}],
    Cell[304552, 6043, 267, 8, 70, "Input",
      CellTags->"S1.10.5"],
    Cell[304822, 6053, 402, 13, 70, "Output",
      CellTags->"S1.10.5"],
    Cell[305239, 6069, 1329, 33, 70, "DefinitionBox",
      CellTags->"S1.10.5"],
    Cell[306571, 6104, 72, 1, 70, "Caption",
      CellTags->"S1.10.5"],
    Cell[306646, 6107, 476, 11, 70, "Text",
      CellTags->{"S1.10.5", "5.6"}],
    Cell[307125, 6120, 482, 13, 70, "Text",
      CellTags->{"S1.10.5", "5.7"}]},
  "5.1"->{
    Cell[302844, 5973, 89, 1, 70, "Subsection",
      CellTags->{"S1.10.5", "5.1"}]},
  "5.2"->{
    Cell[302936, 5976, 388, 9, 70, "Text",
      CellTags->{"S1.10.5", "5.2"}]},
  "5.3"->{
    Cell[303327, 5987, 175, 4, 70, "MathCaption",
      CellTags->{"S1.10.5", "5.3"}]},
  "5.4"->{
    Cell[303790, 6008, 176, 4, 70, "MathCaption",
      CellTags->{"S1.10.5", "5.4"}]},
  "5.5"->{
    Cell[304285, 6030, 242, 9, 70, "MathCaption",
      CellTags->{"S1.10.5", "5.5"}]},
  "5.6"->{
    Cell[306646, 6107, 476, 11, 70, "Text",
      CellTags->{"S1.10.5", "5.6"}]},
  "5.7"->{
    Cell[307125, 6120, 482, 13, 70, "Text",
      CellTags->{"S1.10.5", "5.7"}]},
  "S1.10.6"->{
    Cell[307644, 6138, 97, 1, 70, "Subsection",
      CellTags->{"S1.10.6", "6.1"}],
    Cell[307744, 6141, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.2"}],
    Cell[307842, 6144, 19412, 244, 70, 19276, 239, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.6"],
    Cell[327257, 6390, 154, 4, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.3"}],
    Cell[327436, 6398, 114, 3, 70, "Input",
      CellTags->"S1.10.6"],
    Cell[327553, 6403, 168, 4, 70, "Output",
      CellTags->"S1.10.6"],
    Cell[327736, 6410, 195, 5, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.4"}],
    Cell[327956, 6419, 100, 3, 70, "Input",
      CellTags->"S1.10.6"],
    Cell[328059, 6424, 136, 3, 70, "Output",
      CellTags->"S1.10.6"],
    Cell[328210, 6430, 1764, 44, 70, "DefinitionBox",
      CellTags->"S1.10.6"],
    Cell[329977, 6476, 153, 4, 70, "Caption",
      CellTags->"S1.10.6"],
    Cell[330133, 6482, 99, 1, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.5"}],
    Cell[330257, 6487, 305, 9, 70, "Input",
      CellTags->"S1.10.6"],
    Cell[330565, 6498, 168, 4, 70, "Output",
      CellTags->"S1.10.6"],
    Cell[330748, 6505, 913, 22, 70, "Text",
      CellTags->{"S1.10.6", "6.6"}],
    Cell[331664, 6529, 4287, 127, 70, "DefinitionBox3Col",
      CellTags->"S1.10.6"],
    Cell[335954, 6658, 98, 1, 70, "Caption",
      CellTags->"S1.10.6"],
    Cell[336055, 6661, 227, 9, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.7"}],
    Cell[336307, 6674, 289, 9, 70, "Input",
      CellTags->"S1.10.6"],
    Cell[336599, 6685, 86, 3, 70, "Output",
      CellTags->"S1.10.6"],
    Cell[336700, 6691, 245, 9, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.8"}],
    Cell[336970, 6704, 83, 2, 70, "Input",
      CellTags->"S1.10.6"],
    Cell[337056, 6708, 127, 3, 70, "Output",
      CellTags->"S1.10.6"],
    Cell[337198, 6714, 7525, 233, 70, "DefinitionBox3Col",
      CellTags->"S1.10.6"],
    Cell[344726, 6949, 268, 10, 70, "Caption",
      CellTags->"S1.10.6"]},
  "6.1"->{
    Cell[307644, 6138, 97, 1, 70, "Subsection",
      CellTags->{"S1.10.6", "6.1"}]},
  "6.2"->{
    Cell[307744, 6141, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.2"}]},
  "6.3"->{
    Cell[327257, 6390, 154, 4, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.3"}]},
  "6.4"->{
    Cell[327736, 6410, 195, 5, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.4"}]},
  "6.5"->{
    Cell[330133, 6482, 99, 1, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.5"}]},
  "6.6"->{
    Cell[330748, 6505, 913, 22, 70, "Text",
      CellTags->{"S1.10.6", "6.6"}]},
  "6.7"->{
    Cell[336055, 6661, 227, 9, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.7"}]},
  "6.8"->{
    Cell[336700, 6691, 245, 9, 70, "MathCaption",
      CellTags->{"S1.10.6", "6.8"}]},
  "S1.10.7"->{
    Cell[345031, 6964, 130, 4, 70, "Subsection",
      CellTags->{"S1.10.7", "7.1"}],
    Cell[345164, 6970, 494, 9, 70, "Text",
      CellTags->{"S1.10.7", "7.2"}],
    Cell[345661, 6981, 7765, 163, 70, "DoubleBox",
      CellTags->"S1.10.7"],
    Cell[353429, 7146, 75, 1, 70, "Caption",
      CellTags->"S1.10.7"],
    Cell[353507, 7149, 127, 4, 70, "MathCaption",
      CellTags->{"S1.10.7", "7.3"}],
    Cell[353659, 7157, 84, 2, 70, "Input",
      CellTags->"S1.10.7"],
    Cell[353746, 7161, 100, 3, 70, "Output",
      CellTags->"S1.10.7"],
    Cell[353861, 7167, 100, 1, 70, "MathCaption",
      CellTags->{"S1.10.7", "7.4"}],
    Cell[353986, 7172, 154, 6, 70, "Input",
      CellTags->"S1.10.7"],
    Cell[354143, 7180, 100, 3, 70, "Output",
      CellTags->"S1.10.7"],
    Cell[354258, 7186, 277, 6, 70, "Text",
      CellTags->{"S1.10.7", "7.5"}],
    Cell[354538, 7194, 660, 19, 70, "Text",
      CellTags->{"S1.10.7", "7.6"}],
    Cell[355201, 7215, 478, 10, 70, "Text",
      CellTags->{"S1.10.7", "7.7"}]},
  "7.1"->{
    Cell[345031, 6964, 130, 4, 70, "Subsection",
      CellTags->{"S1.10.7", "7.1"}]},
  "7.2"->{
    Cell[345164, 6970, 494, 9, 70, "Text",
      CellTags->{"S1.10.7", "7.2"}]},
  "7.3"->{
    Cell[353507, 7149, 127, 4, 70, "MathCaption",
      CellTags->{"S1.10.7", "7.3"}]},
  "7.4"->{
    Cell[353861, 7167, 100, 1, 70, "MathCaption",
      CellTags->{"S1.10.7", "7.4"}]},
  "7.5"->{
    Cell[354258, 7186, 277, 6, 70, "Text",
      CellTags->{"S1.10.7", "7.5"}]},
  "7.6"->{
    Cell[354538, 7194, 660, 19, 70, "Text",
      CellTags->{"S1.10.7", "7.6"}]},
  "7.7"->{
    Cell[355201, 7215, 478, 10, 70, "Text",
      CellTags->{"S1.10.7", "7.7"}]},
  "S1.10.8"->{
    Cell[355716, 7230, 88, 1, 70, "Subsection",
      CellTags->{"S1.10.8", "8.1"}],
    Cell[355807, 7233, 623, 18, 70, "Text",
      CellTags->{"S1.10.8", "8.2"}],
    Cell[356433, 7253, 279, 8, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.3"}],
    Cell[356737, 7265, 104, 2, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[356844, 7269, 117, 3, 70, "Output",
      CellTags->"S1.10.8"],
    Cell[356976, 7275, 247, 8, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.4"}],
    Cell[357226, 7285, 101, 2, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[357330, 7289, 224, 8, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.5"}],
    Cell[357579, 7301, 104, 2, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[357686, 7305, 88, 3, 70, "Output",
      CellTags->"S1.10.8"],
    Cell[357789, 7311, 9978, 206, 70, "DoubleBox",
      CellTags->"S1.10.8"],
    Cell[367770, 7519, 150, 5, 70, "Caption",
      CellTags->"S1.10.8"],
    Cell[367923, 7526, 521, 16, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.6"}],
    Cell[368469, 7546, 158, 3, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[368630, 7551, 142, 4, 70, "Output",
      CellTags->"S1.10.8"],
    Cell[368787, 7558, 483, 11, 70, "Text",
      CellTags->{"S1.10.8", "8.7"}],
    Cell[369273, 7571, 371, 11, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.8"}],
    Cell[369669, 7586, 220, 8, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[369892, 7596, 110, 3, 70, "Output",
      CellTags->"S1.10.8"],
    Cell[370017, 7602, 587, 15, 70, "Text",
      CellTags->{"S1.10.8", "8.9"}],
    Cell[370607, 7619, 134, 4, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.10"}],
    Cell[370766, 7627, 113, 2, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[370882, 7631, 126, 3, 70, "Output",
      CellTags->"S1.10.8"],
    Cell[371023, 7637, 5487, 117, 70, "DoubleBox",
      CellTags->"S1.10.8"],
    Cell[376513, 7756, 107, 4, 70, "Caption",
      CellTags->"S1.10.8"],
    Cell[376623, 7762, 142, 4, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.11"}],
    Cell[376790, 7770, 109, 2, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[376902, 7774, 125, 3, 70, "Output",
      CellTags->"S1.10.8"],
    Cell[377042, 7780, 269, 9, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.12"}],
    Cell[377336, 7793, 80, 2, 70, "Input",
      CellTags->"S1.10.8"],
    Cell[377419, 7797, 99, 3, 70, "Output",
      CellTags->"S1.10.8"]},
  "8.1"->{
    Cell[355716, 7230, 88, 1, 70, "Subsection",
      CellTags->{"S1.10.8", "8.1"}]},
  "8.2"->{
    Cell[355807, 7233, 623, 18, 70, "Text",
      CellTags->{"S1.10.8", "8.2"}]},
  "8.3"->{
    Cell[356433, 7253, 279, 8, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.3"}]},
  "8.4"->{
    Cell[356976, 7275, 247, 8, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.4"}]},
  "8.5"->{
    Cell[357330, 7289, 224, 8, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.5"}]},
  "8.6"->{
    Cell[367923, 7526, 521, 16, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.6"}]},
  "8.7"->{
    Cell[368787, 7558, 483, 11, 70, "Text",
      CellTags->{"S1.10.8", "8.7"}]},
  "8.8"->{
    Cell[369273, 7571, 371, 11, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.8"}]},
  "8.9"->{
    Cell[370017, 7602, 587, 15, 70, "Text",
      CellTags->{"S1.10.8", "8.9"}]},
  "8.10"->{
    Cell[370607, 7619, 134, 4, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.10"}]},
  "8.11"->{
    Cell[376623, 7762, 142, 4, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.11"}]},
  "8.12"->{
    Cell[377042, 7780, 269, 9, 70, "MathCaption",
      CellTags->{"S1.10.8", "8.12"}]},
  "S1.10.9"->{
    Cell[377567, 7806, 86, 1, 70, "Subsection",
      CellTags->{"S1.10.9", "9.1"}],
    Cell[377656, 7809, 278, 6, 70, "Text",
      CellTags->{"S1.10.9", "9.2"}],
    Cell[377937, 7817, 1104, 38, 70, "DefinitionBox",
      CellTags->"S1.10.9"],
    Cell[379044, 7857, 69, 1, 70, "Caption",
      CellTags->"S1.10.9"],
    Cell[379116, 7860, 184, 7, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.3"}],
    Cell[379325, 7871, 76, 2, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[379404, 7875, 96, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[379515, 7881, 160, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.4"}],
    Cell[379700, 7890, 95, 3, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[379798, 7895, 96, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[379909, 7901, 265, 7, 70, "Text",
      CellTags->{"S1.10.9", "9.5"}],
    Cell[380177, 7910, 173, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.6"}],
    Cell[380375, 7919, 90, 2, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[380468, 7923, 102, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[380585, 7929, 164, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.7"}],
    Cell[380774, 7938, 104, 2, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[380881, 7942, 106, 2, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[380990, 7946, 162, 6, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[381167, 7955, 181, 6, 70, "Text",
      CellTags->{"S1.10.9", "9.8"}],
    Cell[381351, 7963, 314, 8, 70, "Text",
      CellTags->{"S1.10.9", "9.9"}],
    Cell[381668, 7973, 154, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.10"}],
    Cell[381847, 7982, 131, 3, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[381981, 7987, 169, 4, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[382165, 7994, 215, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.11"}],
    Cell[382405, 8004, 162, 4, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[382570, 8010, 169, 4, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[382754, 8017, 463, 11, 70, "Text",
      CellTags->{"S1.10.9", "9.12"}],
    Cell[383220, 8030, 226, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.13"}],
    Cell[383471, 8039, 157, 4, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[383631, 8045, 219, 4, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[383865, 8052, 156, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.14"}],
    Cell[384046, 8061, 144, 5, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[384193, 8068, 691, 19, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[384899, 8090, 470, 11, 70, "Text",
      CellTags->{"S1.10.9", "9.15"}],
    Cell[385372, 8103, 572, 20, 70, "Text",
      CellTags->{"S1.10.9", "9.16"}],
    Cell[385947, 8125, 194, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.17"}],
    Cell[386166, 8135, 119, 2, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[386288, 8139, 144, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[386447, 8145, 238, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.18"}],
    Cell[386710, 8155, 123, 2, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[386836, 8159, 156, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[387007, 8165, 485, 13, 70, "Text",
      CellTags->{"S1.10.9", "9.19"}],
    Cell[387495, 8180, 201, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.20"}],
    Cell[387699, 8188, 19875, 250, 70, 19738, 245, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.9"],
    Cell[407577, 8440, 262, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.21"}],
    Cell[407842, 8448, 20600, 259, 70, 20463, 254, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.9"],
    Cell[428445, 8709, 797, 26, 70, "FramedBox",
      CellTags->"S1.10.9"],
    Cell[429245, 8737, 158, 5, 70, "Caption",
      CellTags->"S1.10.9"],
    Cell[429406, 8744, 472, 10, 70, "Text",
      CellTags->{"S1.10.9", "9.22"}],
    Cell[429881, 8756, 142, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.23"}],
    Cell[430048, 8765, 96, 2, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[430147, 8769, 163, 4, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[430325, 8776, 305, 7, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.24"}],
    Cell[430655, 8787, 166, 4, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[430824, 8793, 141, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[430980, 8799, 111, 1, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.25"}],
    Cell[431116, 8804, 169, 4, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[431288, 8810, 144, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[431447, 8816, 488, 11, 70, "Text",
      CellTags->{"S1.10.9", "9.26"}],
    Cell[431938, 8829, 163, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.27"}],
    Cell[432126, 8838, 160, 4, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[432289, 8844, 189, 5, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[432493, 8852, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.28"}],
    Cell[432613, 8857, 133, 3, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[432749, 8862, 106, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[432870, 8868, 104, 1, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.29"}],
    Cell[432999, 8873, 128, 3, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[433130, 8878, 106, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[433251, 8884, 242, 7, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.30"}],
    Cell[433518, 8895, 133, 3, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[433654, 8900, 106, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[433775, 8906, 369, 8, 70, "Text",
      CellTags->{"S1.10.9", "9.31"}],
    Cell[434147, 8916, 1488, 41, 70, "FramedBox",
      CellTags->"S1.10.9"],
    Cell[435638, 8959, 126, 5, 70, "Caption",
      CellTags->"S1.10.9"],
    Cell[435767, 8966, 381, 17, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.32"}],
    Cell[436173, 8987, 140, 3, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[436316, 8992, 122, 3, 70, "Output",
      CellTags->"S1.10.9"],
    Cell[436453, 8998, 370, 10, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.33"}],
    Cell[436848, 9012, 152, 4, 70, "Input",
      CellTags->"S1.10.9"],
    Cell[437003, 9018, 125, 3, 70, "Output",
      CellTags->"S1.10.9"]},
  "9.1"->{
    Cell[377567, 7806, 86, 1, 70, "Subsection",
      CellTags->{"S1.10.9", "9.1"}]},
  "9.2"->{
    Cell[377656, 7809, 278, 6, 70, "Text",
      CellTags->{"S1.10.9", "9.2"}]},
  "9.3"->{
    Cell[379116, 7860, 184, 7, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.3"}]},
  "9.4"->{
    Cell[379515, 7881, 160, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.4"}]},
  "9.5"->{
    Cell[379909, 7901, 265, 7, 70, "Text",
      CellTags->{"S1.10.9", "9.5"}]},
  "9.6"->{
    Cell[380177, 7910, 173, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.6"}]},
  "9.7"->{
    Cell[380585, 7929, 164, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.7"}]},
  "9.8"->{
    Cell[381167, 7955, 181, 6, 70, "Text",
      CellTags->{"S1.10.9", "9.8"}]},
  "9.9"->{
    Cell[381351, 7963, 314, 8, 70, "Text",
      CellTags->{"S1.10.9", "9.9"}]},
  "9.10"->{
    Cell[381668, 7973, 154, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.10"}]},
  "9.11"->{
    Cell[382165, 7994, 215, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.11"}]},
  "9.12"->{
    Cell[382754, 8017, 463, 11, 70, "Text",
      CellTags->{"S1.10.9", "9.12"}]},
  "9.13"->{
    Cell[383220, 8030, 226, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.13"}]},
  "9.14"->{
    Cell[383865, 8052, 156, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.14"}]},
  "9.15"->{
    Cell[384899, 8090, 470, 11, 70, "Text",
      CellTags->{"S1.10.9", "9.15"}]},
  "9.16"->{
    Cell[385372, 8103, 572, 20, 70, "Text",
      CellTags->{"S1.10.9", "9.16"}]},
  "9.17"->{
    Cell[385947, 8125, 194, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.17"}]},
  "9.18"->{
    Cell[386447, 8145, 238, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.18"}]},
  "9.19"->{
    Cell[387007, 8165, 485, 13, 70, "Text",
      CellTags->{"S1.10.9", "9.19"}]},
  "9.20"->{
    Cell[387495, 8180, 201, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.20"}]},
  "9.21"->{
    Cell[407577, 8440, 262, 6, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.21"}]},
  "9.22"->{
    Cell[429406, 8744, 472, 10, 70, "Text",
      CellTags->{"S1.10.9", "9.22"}]},
  "9.23"->{
    Cell[429881, 8756, 142, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.23"}]},
  "9.24"->{
    Cell[430325, 8776, 305, 7, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.24"}]},
  "9.25"->{
    Cell[430980, 8799, 111, 1, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.25"}]},
  "9.26"->{
    Cell[431447, 8816, 488, 11, 70, "Text",
      CellTags->{"S1.10.9", "9.26"}]},
  "9.27"->{
    Cell[431938, 8829, 163, 5, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.27"}]},
  "9.28"->{
    Cell[432493, 8852, 95, 1, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.28"}]},
  "9.29"->{
    Cell[432870, 8868, 104, 1, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.29"}]},
  "9.30"->{
    Cell[433251, 8884, 242, 7, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.30"}]},
  "9.31"->{
    Cell[433775, 8906, 369, 8, 70, "Text",
      CellTags->{"S1.10.9", "9.31"}]},
  "9.32"->{
    Cell[435767, 8966, 381, 17, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.32"}]},
  "9.33"->{
    Cell[436453, 8998, 370, 10, 70, "MathCaption",
      CellTags->{"S1.10.9", "9.33"}]},
  "S1.10.10"->{
    Cell[437177, 9027, 88, 1, 70, "Subsection",
      CellTags->{"S1.10.10", "10.1"}],
    Cell[437268, 9030, 310, 7, 70, "Text",
      CellTags->{"S1.10.10", "10.2"}],
    Cell[437581, 9039, 922, 28, 70, "DefinitionBox",
      CellTags->"S1.10.10"],
    Cell[438506, 9069, 90, 1, 70, "Caption",
      CellTags->"S1.10.10"],
    Cell[438599, 9072, 116, 2, 70, "MathCaption",
      CellTags->{"S1.10.10", "10.3"}],
    Cell[438718, 9076, 32034, 400, 70, 31896, 395, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.10"],
    Cell[470755, 9478, 290, 7, 70, "Text",
      CellTags->{"S1.10.10", "10.4"}],
    Cell[471048, 9487, 528, 15, 70, "Text",
      CellTags->{"S1.10.10", "10.5"}],
    Cell[471579, 9504, 247, 6, 70, "Text",
      CellTags->{"S1.10.10", "10.6"}],
    Cell[471829, 9512, 476, 10, 70, "Text",
      CellTags->{"S1.10.10", "10.7"}],
    Cell[472308, 9524, 308, 8, 70, "Text",
      CellTags->{"S1.10.10", "10.8"}]},
  "10.1"->{
    Cell[437177, 9027, 88, 1, 70, "Subsection",
      CellTags->{"S1.10.10", "10.1"}]},
  "10.2"->{
    Cell[437268, 9030, 310, 7, 70, "Text",
      CellTags->{"S1.10.10", "10.2"}]},
  "10.3"->{
    Cell[438599, 9072, 116, 2, 70, "MathCaption",
      CellTags->{"S1.10.10", "10.3"}]},
  "10.4"->{
    Cell[470755, 9478, 290, 7, 70, "Text",
      CellTags->{"S1.10.10", "10.4"}]},
  "10.5"->{
    Cell[471048, 9487, 528, 15, 70, "Text",
      CellTags->{"S1.10.10", "10.5"}]},
  "10.6"->{
    Cell[471579, 9504, 247, 6, 70, "Text",
      CellTags->{"S1.10.10", "10.6"}]},
  "10.7"->{
    Cell[471829, 9512, 476, 10, 70, "Text",
      CellTags->{"S1.10.10", "10.7"}]},
  "10.8"->{
    Cell[472308, 9524, 308, 8, 70, "Text",
      CellTags->{"S1.10.10", "10.8"}]},
  "S1.10.11"->{
    Cell[472653, 9537, 154, 5, 70, "Subsection",
      CellTags->{"S1.10.11", "11.1"}],
    Cell[472810, 9544, 440, 10, 70, "Text",
      CellTags->{"S1.10.11", "11.2"}],
    Cell[473253, 9556, 1181, 30, 70, "DefinitionBox",
      CellTags->"S1.10.11"],
    Cell[474437, 9588, 121, 4, 70, "Caption",
      CellTags->"S1.10.11"],
    Cell[474561, 9594, 139, 4, 70, "MathCaption",
      CellTags->{"S1.10.11", "11.3"}],
    Cell[474703, 9600, 60384, 750, 70, 60246, 745, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.11"],
    Cell[535090, 10352, 106, 1, 70, "MathCaption",
      CellTags->{"S1.10.11", "11.4"}],
    Cell[535199, 10355, 43957, 547, 70, 43819, 542, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.11"],
    Cell[579159, 10904, 136, 4, 70, "MathCaption",
      CellTags->{"S1.10.11", "11.5"}],
    Cell[579298, 10910, 47197, 587, 70, 47059, 582, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.11"]},
  "11.1"->{
    Cell[472653, 9537, 154, 5, 70, "Subsection",
      CellTags->{"S1.10.11", "11.1"}]},
  "11.2"->{
    Cell[472810, 9544, 440, 10, 70, "Text",
      CellTags->{"S1.10.11", "11.2"}]},
  "11.3"->{
    Cell[474561, 9594, 139, 4, 70, "MathCaption",
      CellTags->{"S1.10.11", "11.3"}]},
  "11.4"->{
    Cell[535090, 10352, 106, 1, 70, "MathCaption",
      CellTags->{"S1.10.11", "11.4"}]},
  "11.5"->{
    Cell[579159, 10904, 136, 4, 70, "MathCaption",
      CellTags->{"S1.10.11", "11.5"}]},
  "S1.10.12"->{
    Cell[626532, 11502, 90, 1, 70, "Subsection",
      CellTags->{"S1.10.12", "12.1"}],
    Cell[626625, 11505, 230, 6, 70, "Text",
      CellTags->{"S1.10.12", "12.2"}],
    Cell[626858, 11513, 793, 21, 70, "FramedBox",
      CellTags->"S1.10.12"],
    Cell[627654, 11536, 82, 1, 70, "Caption",
      CellTags->"S1.10.12"],
    Cell[627739, 11539, 151, 4, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.3"}],
    Cell[627893, 11545, 12475, 158, 70, 12338, 153, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[640371, 11705, 112, 1, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.4"}],
    Cell[640486, 11708, 14520, 183, 70, 14383, 178, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[655009, 11893, 179, 5, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.5"}],
    Cell[655191, 11900, 9608, 123, 70, 9471, 118, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[664802, 12025, 147, 4, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.6"}],
    Cell[664952, 12031, 6335, 82, 70, 6198, 77, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[671290, 12115, 901, 23, 70, "DefinitionBox",
      CellTags->"S1.10.12"],
    Cell[672194, 12140, 79, 1, 70, "Caption",
      CellTags->"S1.10.12"],
    Cell[672276, 12143, 527, 10, 70, "Text",
      CellTags->{"S1.10.12", "12.7"}],
    Cell[672806, 12155, 1136, 36, 70, "DefinitionBox",
      CellTags->"S1.10.12"],
    Cell[673945, 12193, 64, 1, 70, "Caption",
      CellTags->"S1.10.12"],
    Cell[674012, 12196, 257, 5, 70, "Text",
      CellTags->{"S1.10.12", "12.8"}],
    Cell[674272, 12203, 331, 7, 70, "Text",
      CellTags->{"S1.10.12", "12.9"}],
    Cell[674606, 12212, 1014, 26, 70, "Text",
      CellTags->{"S1.10.12", "12.10"}],
    Cell[675623, 12240, 139, 4, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.11"}],
    Cell[675765, 12246, 5744, 75, 70, 5607, 70, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[681512, 12323, 320, 10, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.12"}],
    Cell[681835, 12335, 6526, 85, 70, 6389, 80, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[688364, 12422, 315, 7, 70, "Text",
      CellTags->{"S1.10.12", "12.13"}],
    Cell[688682, 12431, 1128, 34, 70, "DefinitionBox",
      CellTags->"S1.10.12"],
    Cell[689813, 12467, 72, 1, 70, "Caption",
      CellTags->"S1.10.12"],
    Cell[689888, 12470, 381, 9, 70, "Text",
      CellTags->{"S1.10.12", "12.14"}],
    Cell[690272, 12481, 471, 12, 70, "Text",
      CellTags->{"S1.10.12", "12.15"}],
    Cell[690746, 12495, 358, 9, 70, "Text",
      CellTags->{"S1.10.12", "12.16"}],
    Cell[691107, 12506, 102, 1, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.17"}],
    Cell[691212, 12509, 5744, 75, 70, 5607, 70, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[696959, 12586, 338, 10, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.18"}],
    Cell[697300, 12598, 13949, 176, 70, 13812, 171, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[711252, 12776, 321, 9, 70, "Text",
      CellTags->{"S1.10.12", "12.19"}],
    Cell[711576, 12787, 102, 1, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.20"}],
    Cell[711681, 12790, 5744, 75, 70, 5607, 70, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[717428, 12867, 308, 7, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.21"}],
    Cell[717739, 12876, 18036, 227, 70, 17899, 222, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.12"],
    Cell[735778, 13105, 862, 22, 70, "DefinitionBox",
      CellTags->"S1.10.12"],
    Cell[736643, 13129, 92, 1, 70, "Caption",
      CellTags->"S1.10.12"],
    Cell[736738, 13132, 398, 7, 70, "Text",
      CellTags->{"S1.10.12", "12.22"}],
    Cell[737139, 13141, 416, 11, 70, "Text",
      CellTags->{"S1.10.12", "12.23"}]},
  "12.1"->{
    Cell[626532, 11502, 90, 1, 70, "Subsection",
      CellTags->{"S1.10.12", "12.1"}]},
  "12.2"->{
    Cell[626625, 11505, 230, 6, 70, "Text",
      CellTags->{"S1.10.12", "12.2"}]},
  "12.3"->{
    Cell[627739, 11539, 151, 4, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.3"}]},
  "12.4"->{
    Cell[640371, 11705, 112, 1, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.4"}]},
  "12.5"->{
    Cell[655009, 11893, 179, 5, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.5"}]},
  "12.6"->{
    Cell[664802, 12025, 147, 4, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.6"}]},
  "12.7"->{
    Cell[672276, 12143, 527, 10, 70, "Text",
      CellTags->{"S1.10.12", "12.7"}]},
  "12.8"->{
    Cell[674012, 12196, 257, 5, 70, "Text",
      CellTags->{"S1.10.12", "12.8"}]},
  "12.9"->{
    Cell[674272, 12203, 331, 7, 70, "Text",
      CellTags->{"S1.10.12", "12.9"}]},
  "12.10"->{
    Cell[674606, 12212, 1014, 26, 70, "Text",
      CellTags->{"S1.10.12", "12.10"}]},
  "12.11"->{
    Cell[675623, 12240, 139, 4, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.11"}]},
  "12.12"->{
    Cell[681512, 12323, 320, 10, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.12"}]},
  "12.13"->{
    Cell[688364, 12422, 315, 7, 70, "Text",
      CellTags->{"S1.10.12", "12.13"}]},
  "12.14"->{
    Cell[689888, 12470, 381, 9, 70, "Text",
      CellTags->{"S1.10.12", "12.14"}]},
  "12.15"->{
    Cell[690272, 12481, 471, 12, 70, "Text",
      CellTags->{"S1.10.12", "12.15"}]},
  "12.16"->{
    Cell[690746, 12495, 358, 9, 70, "Text",
      CellTags->{"S1.10.12", "12.16"}]},
  "12.17"->{
    Cell[691107, 12506, 102, 1, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.17"}]},
  "12.18"->{
    Cell[696959, 12586, 338, 10, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.18"}]},
  "12.19"->{
    Cell[711252, 12776, 321, 9, 70, "Text",
      CellTags->{"S1.10.12", "12.19"}]},
  "12.20"->{
    Cell[711576, 12787, 102, 1, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.20"}]},
  "12.21"->{
    Cell[717428, 12867, 308, 7, 70, "MathCaption",
      CellTags->{"S1.10.12", "12.21"}]},
  "12.22"->{
    Cell[736738, 13132, 398, 7, 70, "Text",
      CellTags->{"S1.10.12", "12.22"}]},
  "12.23"->{
    Cell[737139, 13141, 416, 11, 70, "Text",
      CellTags->{"S1.10.12", "12.23"}]},
  "S1.10.13"->{
    Cell[737592, 13157, 85, 1, 70, "Subsection",
      CellTags->{"S1.10.13", "13.1"}],
    Cell[737680, 13160, 366, 10, 70, "DefinitionBox",
      CellTags->"S1.10.13"],
    Cell[738049, 13172, 80, 1, 70, "Caption",
      CellTags->"S1.10.13"],
    Cell[738132, 13175, 276, 6, 70, "Text",
      CellTags->{"S1.10.13", "13.2"}],
    Cell[738411, 13183, 322, 7, 70, "Text",
      CellTags->{"S1.10.13", "13.3"}]},
  "13.1"->{
    Cell[737592, 13157, 85, 1, 70, "Subsection",
      CellTags->{"S1.10.13", "13.1"}]},
  "13.2"->{
    Cell[738132, 13175, 276, 6, 70, "Text",
      CellTags->{"S1.10.13", "13.2"}]},
  "13.3"->{
    Cell[738411, 13183, 322, 7, 70, "Text",
      CellTags->{"S1.10.13", "13.3"}]},
  "S1.10.14"->{
    Cell[738770, 13195, 83, 1, 70, "Subsection",
      CellTags->{"S1.10.14", "14.1"}],
    Cell[738856, 13198, 646, 18, 70, "FramedBox",
      CellTags->"S1.10.14"],
    Cell[739505, 13218, 153, 5, 70, "Caption",
      CellTags->"S1.10.14"],
    Cell[739661, 13225, 233, 5, 70, "MathCaption",
      CellTags->{"S1.10.14", "14.2"}],
    Cell[739897, 13232, 20771, 261, 70, 20633, 256, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.14"],
    Cell[760671, 13495, 144, 5, 40, "MathCaption",
      CellTags->{"S1.10.14", "14.3"}],
    Cell[760818, 13502, 23589, 295, 70, 23451, 290, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.10.14"]},
  "14.1"->{
    Cell[738770, 13195, 83, 1, 70, "Subsection",
      CellTags->{"S1.10.14", "14.1"}]},
  "14.2"->{
    Cell[739661, 13225, 233, 5, 70, "MathCaption",
      CellTags->{"S1.10.14", "14.2"}]},
  "14.3"->{
    Cell[760671, 13495, 144, 5, 40, "MathCaption",
      CellTags->{"S1.10.14", "14.3"}]},
  "S1.10.15"->{
    Cell[784444, 13802, 144, 5, 38, "Subsection",
      CellTags->{"S1.10.15", "15.1"}],
    Cell[784591, 13809, 337, 7, 56, "Text",
      CellTags->{"S1.10.15", "15.2"}],
    Cell[784931, 13818, 768, 16, 120, "Text",
      CellTags->{"S1.10.15", "15.3"}],
    Cell[785702, 13836, 431, 10, 72, "Text",
      CellTags->{"S1.10.15", "15.4"}],
    Cell[786136, 13848, 914, 22, 136, "Text",
      CellTags->{"S1.10.15", "15.5"}],
    Cell[787053, 13872, 787, 18, 120, "Text",
      CellTags->{"S1.10.15", "15.6"}],
    Cell[787843, 13892, 528, 10, 88, "Text",
      CellTags->{"S1.10.15", "15.7"}]},
  "15.1"->{
    Cell[784444, 13802, 144, 5, 38, "Subsection",
      CellTags->{"S1.10.15", "15.1"}]},
  "15.2"->{
    Cell[784591, 13809, 337, 7, 56, "Text",
      CellTags->{"S1.10.15", "15.2"}]},
  "15.3"->{
    Cell[784931, 13818, 768, 16, 120, "Text",
      CellTags->{"S1.10.15", "15.3"}]},
  "15.4"->{
    Cell[785702, 13836, 431, 10, 72, "Text",
      CellTags->{"S1.10.15", "15.4"}]},
  "15.5"->{
    Cell[786136, 13848, 914, 22, 136, "Text",
      CellTags->{"S1.10.15", "15.5"}]},
  "15.6"->{
    Cell[787053, 13872, 787, 18, 120, "Text",
      CellTags->{"S1.10.15", "15.6"}]},
  "15.7"->{
    Cell[787843, 13892, 528, 10, 88, "Text",
      CellTags->{"S1.10.15", "15.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.10.0", 789015, 13922},
  {"0.1", 789106, 13925},
  {"S1.10.1", 789201, 13928},
  {"1.1", 791028, 13977},
  {"1.2", 791121, 13980},
  {"1.3", 791217, 13983},
  {"1.4", 791314, 13986},
  {"1.5", 791411, 13989},
  {"1.6", 791502, 13992},
  {"1.7", 791599, 13995},
  {"1.8", 791696, 13998},
  {"S1.10.2", 791798, 14001},
  {"2.1", 799507, 14202},
  {"2.2", 799604, 14205},
  {"2.3", 799703, 14208},
  {"2.4", 799801, 14211},
  {"2.5", 799892, 14214},
  {"2.6", 799990, 14217},
  {"2.7", 800081, 14220},
  {"2.8", 800172, 14223},
  {"2.9", 800264, 14226},
  {"2.10", 800363, 14229},
  {"2.11", 800463, 14232},
  {"2.12", 800563, 14235},
  {"2.13", 800657, 14238},
  {"2.14", 800751, 14241},
  {"2.15", 800851, 14244},
  {"2.16", 800951, 14247},
  {"2.17", 801044, 14250},
  {"2.18", 801138, 14253},
  {"2.19", 801238, 14256},
  {"2.20", 801338, 14259},
  {"2.21", 801432, 14262},
  {"2.22", 801532, 14265},
  {"2.23", 801632, 14268},
  {"2.24", 801733, 14271},
  {"2.25", 801833, 14274},
  {"2.26", 801933, 14277},
  {"2.27", 802033, 14280},
  {"2.28", 802133, 14283},
  {"2.29", 802232, 14286},
  {"2.30", 802332, 14289},
  {"2.31", 802431, 14292},
  {"2.32", 802531, 14295},
  {"2.33", 802632, 14298},
  {"2.34", 802733, 14301},
  {"2.35", 802834, 14304},
  {"2.36", 802935, 14307},
  {"S1.10.3", 803032, 14310},
  {"3.1", 804467, 14347},
  {"3.2", 804565, 14350},
  {"3.3", 804657, 14353},
  {"3.4", 804749, 14356},
  {"3.5", 804848, 14359},
  {"3.6", 804940, 14362},
  {"3.7", 805032, 14365},
  {"3.8", 805131, 14368},
  {"S1.10.4", 805234, 14371},
  {"4.1", 811324, 14528},
  {"4.2", 811421, 14531},
  {"4.3", 811520, 14534},
  {"4.4", 811618, 14537},
  {"4.5", 811716, 14540},
  {"4.6", 811814, 14543},
  {"4.7", 811913, 14546},
  {"4.8", 812011, 14549},
  {"4.9", 812109, 14552},
  {"4.10", 812208, 14555},
  {"4.11", 812309, 14558},
  {"4.12", 812410, 14561},
  {"4.13", 812504, 14564},
  {"4.14", 812598, 14567},
  {"4.15", 812699, 14570},
  {"4.16", 812800, 14573},
  {"4.17", 812901, 14576},
  {"4.18", 813001, 14579},
  {"4.19", 813096, 14582},
  {"4.20", 813196, 14585},
  {"4.21", 813297, 14588},
  {"4.22", 813398, 14591},
  {"4.23", 813493, 14594},
  {"4.24", 813595, 14597},
  {"4.25", 813696, 14600},
  {"4.26", 813796, 14603},
  {"S1.10.5", 813900, 14606},
  {"5.1", 815091, 14637},
  {"5.2", 815188, 14640},
  {"5.3", 815280, 14643},
  {"5.4", 815379, 14646},
  {"5.5", 815478, 14649},
  {"5.6", 815577, 14652},
  {"5.7", 815670, 14655},
  {"S1.10.6", 815767, 14658},
  {"6.1", 817813, 14711},
  {"6.2", 817910, 14714},
  {"6.3", 818008, 14717},
  {"6.4", 818107, 14720},
  {"6.5", 818206, 14723},
  {"6.6", 818304, 14726},
  {"6.7", 818397, 14729},
  {"6.8", 818496, 14732},
  {"S1.10.7", 818599, 14735},
  {"7.1", 819634, 14762},
  {"7.2", 819732, 14765},
  {"7.3", 819824, 14768},
  {"7.4", 819923, 14771},
  {"7.5", 820022, 14774},
  {"7.6", 820114, 14777},
  {"7.7", 820207, 14780},
  {"S1.10.8", 820304, 14783},
  {"8.1", 822735, 14846},
  {"8.2", 822832, 14849},
  {"8.3", 822925, 14852},
  {"8.4", 823024, 14855},
  {"8.5", 823123, 14858},
  {"8.6", 823222, 14861},
  {"8.7", 823322, 14864},
  {"8.8", 823415, 14867},
  {"8.9", 823515, 14870},
  {"8.10", 823609, 14873},
  {"8.11", 823710, 14876},
  {"8.12", 823811, 14879},
  {"S1.10.9", 823915, 14882},
  {"9.1", 830325, 15047},
  {"9.2", 830422, 15050},
  {"9.3", 830514, 15053},
  {"9.4", 830613, 15056},
  {"9.5", 830712, 15059},
  {"9.6", 830804, 15062},
  {"9.7", 830903, 15065},
  {"9.8", 831002, 15068},
  {"9.9", 831094, 15071},
  {"9.10", 831187, 15074},
  {"9.11", 831288, 15077},
  {"9.12", 831389, 15080},
  {"9.13", 831484, 15083},
  {"9.14", 831585, 15086},
  {"9.15", 831686, 15089},
  {"9.16", 831781, 15092},
  {"9.17", 831876, 15095},
  {"9.18", 831977, 15098},
  {"9.19", 832078, 15101},
  {"9.20", 832173, 15104},
  {"9.21", 832274, 15107},
  {"9.22", 832375, 15110},
  {"9.23", 832470, 15113},
  {"9.24", 832571, 15116},
  {"9.25", 832672, 15119},
  {"9.26", 832773, 15122},
  {"9.27", 832868, 15125},
  {"9.28", 832969, 15128},
  {"9.29", 833069, 15131},
  {"9.30", 833170, 15134},
  {"9.31", 833271, 15137},
  {"9.32", 833365, 15140},
  {"9.33", 833467, 15143},
  {"S1.10.10", 833573, 15146},
  {"10.1", 834560, 15171},
  {"10.2", 834660, 15174},
  {"10.3", 834755, 15177},
  {"10.4", 834857, 15180},
  {"10.5", 834952, 15183},
  {"10.6", 835048, 15186},
  {"10.7", 835143, 15189},
  {"10.8", 835239, 15192},
  {"S1.10.11", 835338, 15195},
  {"11.1", 836395, 15222},
  {"11.2", 836496, 15225},
  {"11.3", 836592, 15228},
  {"11.4", 836694, 15231},
  {"11.5", 836797, 15234},
  {"S1.10.12", 836904, 15237},
  {"12.1", 841178, 15344},
  {"12.2", 841279, 15347},
  {"12.3", 841375, 15350},
  {"12.4", 841478, 15353},
  {"12.5", 841581, 15356},
  {"12.6", 841684, 15359},
  {"12.7", 841787, 15362},
  {"12.8", 841884, 15365},
  {"12.9", 841980, 15368},
  {"12.10", 842077, 15371},
  {"12.11", 842177, 15374},
  {"12.12", 842282, 15377},
  {"12.13", 842388, 15380},
  {"12.14", 842486, 15383},
  {"12.15", 842584, 15386},
  {"12.16", 842683, 15389},
  {"12.17", 842781, 15392},
  {"12.18", 842886, 15395},
  {"12.19", 842992, 15398},
  {"12.20", 843090, 15401},
  {"12.21", 843195, 15404},
  {"12.22", 843300, 15407},
  {"12.23", 843398, 15410},
  {"S1.10.13", 843500, 15413},
  {"13.1", 843925, 15424},
  {"13.2", 844026, 15427},
  {"13.3", 844122, 15430},
  {"S1.10.14", 844222, 15433},
  {"14.1", 844956, 15452},
  {"14.2", 845057, 15455},
  {"14.3", 845160, 15458},
  {"S1.10.15", 845267, 15461},
  {"15.1", 845875, 15476},
  {"15.2", 845977, 15479},
  {"15.3", 846073, 15482},
  {"15.4", 846171, 15485},
  {"15.5", 846268, 15488},
  {"15.6", 846366, 15491},
  {"15.7", 846464, 15494}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 4, 65, "Section",
  CellTags->{"S1.10.0", "0.1"}],

Cell[CellGroupData[{
Cell[1935, 61, 83, 1, 70, "Subsection",
  CellTags->{"S1.10.1", "1.1"}],
Cell[2021, 64, 1341, 38, 70, "DefinitionBox",
  CellTags->"S1.10.1"],
Cell[3365, 104, 85, 1, 70, "Caption",
  CellTags->"S1.10.1"],
Cell[3453, 107, 107, 1, 70, "MathCaption",
  CellTags->{"S1.10.1", "1.2"}],
Cell[3563, 110, 33973, 424, 70, 33836, 419, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.1"],
Cell[37539, 536, 154, 4, 70, "MathCaption",
  CellTags->{"S1.10.1", "1.3"}],

Cell[CellGroupData[{
Cell[37718, 544, 95, 2, 70, "Input",
  CellTags->"S1.10.1"],
Cell[37816, 548, 165, 4, 70, "Output",
  CellTags->"S1.10.1"]
}, Open  ]],
Cell[37996, 555, 140, 4, 70, "MathCaption",
  CellTags->{"S1.10.1", "1.4"}],

Cell[CellGroupData[{
Cell[38161, 563, 97, 2, 70, "Input",
  CellTags->"S1.10.1"],
Cell[38261, 567, 165, 4, 70, "Output",
  CellTags->"S1.10.1"]
}, Open  ]],
Cell[38441, 574, 17500, 349, 70, "DoubleBox",
  CellTags->"S1.10.1"],
Cell[55944, 925, 327, 9, 70, "Caption",
  CellTags->"S1.10.1"],
Cell[56274, 936, 302, 10, 70, "Text",
  CellTags->{"S1.10.1", "1.5"}],
Cell[56579, 948, 184, 7, 70, "MathCaption",
  CellTags->{"S1.10.1", "1.6"}],

Cell[CellGroupData[{
Cell[56788, 959, 73, 2, 70, "Input",
  CellTags->"S1.10.1"],
Cell[56864, 963, 100, 3, 70, "Output",
  CellTags->"S1.10.1"]
}, Open  ]],
Cell[56979, 969, 134, 4, 70, "MathCaption",
  CellTags->{"S1.10.1", "1.7"}],

Cell[CellGroupData[{
Cell[57138, 977, 108, 2, 70, "Input",
  CellTags->"S1.10.1"],
Cell[57249, 981, 253, 5, 70, "Output",
  CellTags->"S1.10.1"]
}, Open  ]],
Cell[57517, 989, 336, 11, 70, "MathCaption",
  CellTags->{"S1.10.1", "1.8"}],

Cell[CellGroupData[{
Cell[57878, 1004, 92, 2, 70, "Input",
  CellTags->"S1.10.1"],
Cell[57973, 1008, 165, 4, 70, "Output",
  CellTags->"S1.10.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58187, 1018, 107, 3, 70, "Subsection",
  CellTags->{"S1.10.2", "2.1"}],
Cell[58297, 1023, 283, 11, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.2"}],

Cell[CellGroupData[{
Cell[58605, 1038, 68, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[58676, 1042, 86, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[58777, 1048, 280, 8, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.3"}],

Cell[CellGroupData[{
Cell[59082, 1060, 85, 3, 70, "Input",
  CellTags->"S1.10.2"],
Cell[59170, 1065, 86, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[59271, 1071, 323, 9, 70, "Text",
  CellTags->{"S1.10.2", "2.4"}],
Cell[59597, 1082, 143, 4, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.5"}],
Cell[59743, 1088, 11984, 152, 70, 11848, 147, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.2"],
Cell[71730, 1242, 153, 4, 70, "Text",
  CellTags->{"S1.10.2", "2.6"}],
Cell[71886, 1248, 1732, 46, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[73621, 1296, 281, 7, 70, "Caption",
  CellTags->"S1.10.2"],
Cell[73905, 1305, 384, 9, 70, "Text",
  CellTags->{"S1.10.2", "2.7"}],
Cell[74292, 1316, 519, 11, 70, "Text",
  CellTags->{"S1.10.2", "2.8"}],
Cell[74814, 1329, 165, 6, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.9"}],

Cell[CellGroupData[{
Cell[75004, 1339, 158, 6, 70, "Input",
  CellTags->"S1.10.2"],
Cell[75165, 1347, 86, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[75266, 1353, 153, 5, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.10"}],

Cell[CellGroupData[{
Cell[75444, 1362, 162, 6, 70, "Input",
  CellTags->"S1.10.2"],
Cell[75609, 1370, 94, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[75718, 1376, 276, 7, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.11"}],

Cell[CellGroupData[{
Cell[76019, 1387, 294, 9, 70, "Input",
  CellTags->"S1.10.2"],
Cell[76316, 1398, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[76421, 1404, 760, 22, 70, "Text",
  CellTags->{"S1.10.2", "2.12"}],
Cell[77184, 1428, 781, 20, 70, "Text",
  CellTags->{"S1.10.2", "2.13"}],
Cell[77968, 1450, 143, 4, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.14"}],

Cell[CellGroupData[{
Cell[78136, 1458, 83, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[78222, 1462, 86, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[78323, 1468, 261, 9, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.15"}],

Cell[CellGroupData[{
Cell[78609, 1481, 87, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[78699, 1485, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[78804, 1491, 441, 9, 70, "Text",
  CellTags->{"S1.10.2", "2.16"}],
Cell[79248, 1502, 430, 11, 70, "Text",
  CellTags->{"S1.10.2", "2.17"}],
Cell[79681, 1515, 247, 9, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.18"}],
Cell[79931, 1526, 4921, 65, 70, 4785, 60, "GraphicsData", "Bitmap", "Picture",
  
  Evaluatable->False,
  CellTags->"S1.10.2"],
Cell[84855, 1593, 231, 7, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.19"}],
Cell[85089, 1602, 4030, 54, 70, 3894, 49, "GraphicsData", "Bitmap", "Picture",
  
  Evaluatable->False,
  CellTags->"S1.10.2"],
Cell[89122, 1658, 1732, 46, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[90857, 1706, 96, 1, 70, "Caption",
  CellTags->"S1.10.2"],
Cell[90956, 1709, 584, 20, 70, "Text",
  CellTags->{"S1.10.2", "2.20"}],
Cell[91543, 1731, 130, 5, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.21"}],

Cell[CellGroupData[{
Cell[91698, 1740, 158, 6, 70, "Input",
  CellTags->"S1.10.2"],
Cell[91859, 1748, 86, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[91960, 1754, 147, 5, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.22"}],

Cell[CellGroupData[{
Cell[92132, 1763, 83, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[92218, 1767, 86, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[92319, 1773, 1161, 32, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[93483, 1807, 122, 4, 70, "Caption",
  CellTags->"S1.10.2"],
Cell[93608, 1813, 299, 11, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.23"}],

Cell[CellGroupData[{
Cell[93932, 1828, 159, 6, 70, "Input",
  CellTags->"S1.10.2"],
Cell[94094, 1836, 87, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[94196, 1842, 204, 9, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.24"}],

Cell[CellGroupData[{
Cell[94425, 1855, 163, 6, 70, "Input",
  CellTags->"S1.10.2"],
Cell[94591, 1863, 95, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[94701, 1869, 246, 8, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.25"}],

Cell[CellGroupData[{
Cell[94972, 1881, 295, 9, 70, "Input",
  CellTags->"S1.10.2"],
Cell[95270, 1892, 91, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[95376, 1898, 174, 4, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.26"}],

Cell[CellGroupData[{
Cell[95575, 1906, 92, 3, 70, "Input",
  CellTags->"S1.10.2"],
Cell[95670, 1911, 84, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[95769, 1917, 124, 4, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.27"}],

Cell[CellGroupData[{
Cell[95918, 1925, 90, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[96011, 1929, 84, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[96110, 1935, 1543, 39, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[97656, 1976, 98, 1, 70, "Caption",
  CellTags->"S1.10.2"],
Cell[97757, 1979, 83, 1, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.28"}],

Cell[CellGroupData[{
Cell[97865, 1984, 161, 6, 70, "Input",
  CellTags->"S1.10.2"],
Cell[98029, 1992, 94, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[98138, 1998, 122, 4, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.29"}],

Cell[CellGroupData[{
Cell[98285, 2006, 293, 9, 70, "Input",
  CellTags->"S1.10.2"],
Cell[98581, 2017, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[98686, 2023, 99, 1, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.30"}],

Cell[CellGroupData[{
Cell[98810, 2028, 86, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[98899, 2032, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[99004, 2038, 203, 5, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.31"}],

Cell[CellGroupData[{
Cell[99232, 2047, 77, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[99312, 2051, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[99417, 2057, 2042, 53, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[101462, 2112, 153, 4, 70, "Caption",
  CellTags->"S1.10.2"],
Cell[101618, 2118, 151, 5, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.32"}],

Cell[CellGroupData[{
Cell[101794, 2127, 235, 8, 70, "Input",
  CellTags->"S1.10.2"],
Cell[102032, 2137, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[102137, 2143, 106, 1, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.33"}],

Cell[CellGroupData[{
Cell[102268, 2148, 235, 8, 70, "Input",
  CellTags->"S1.10.2"],
Cell[102506, 2158, 90, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[102611, 2164, 4473, 142, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[107087, 2308, 144, 4, 70, "Caption",
  CellTags->"S1.10.2"],
Cell[107234, 2314, 193, 7, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.34"}],

Cell[CellGroupData[{
Cell[107452, 2325, 95, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[107550, 2329, 97, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[107662, 2335, 270, 8, 70, "MathCaption",
  CellTags->{"S1.10.2", "2.35"}],

Cell[CellGroupData[{
Cell[107957, 2347, 103, 2, 70, "Input",
  CellTags->"S1.10.2"],
Cell[108063, 2351, 101, 3, 70, "Output",
  CellTags->"S1.10.2"]
}, Open  ]],
Cell[108179, 2357, 372, 8, 70, "Text",
  CellTags->{"S1.10.2", "2.36"}],
Cell[108554, 2367, 4032, 116, 70, "DefinitionBox",
  CellTags->"S1.10.2"],
Cell[112589, 2485, 80, 1, 70, "Caption",
  CellTags->"S1.10.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112706, 2491, 129, 4, 70, "Subsection",
  CellTags->{"S1.10.3", "3.1"}],
Cell[112838, 2497, 362, 7, 70, "Text",
  CellTags->{"S1.10.3", "3.2"}],
Cell[113203, 2506, 199, 5, 70, "Text",
  CellTags->{"S1.10.3", "3.3"}],
Cell[113405, 2513, 1104, 27, 70, "DefinitionBox",
  CellTags->"S1.10.3"],
Cell[114512, 2542, 112, 4, 70, "Caption",
  CellTags->"S1.10.3"],
Cell[114627, 2548, 219, 6, 70, "MathCaption",
  CellTags->{"S1.10.3", "3.4"}],
Cell[114849, 2556, 110704, 1371, 70, 110567, 1366, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.3"],
Cell[225556, 3929, 462, 13, 70, "DefinitionBox",
  CellTags->"S1.10.3"],
Cell[226021, 3944, 106, 4, 70, "Caption",
  CellTags->"S1.10.3"],
Cell[226130, 3950, 439, 8, 70, "Text",
  CellTags->{"S1.10.3", "3.5"}],
Cell[226572, 3960, 243, 5, 70, "Text",
  CellTags->{"S1.10.3", "3.6"}],
Cell[226818, 3967, 100, 1, 70, "MathCaption",
  CellTags->{"S1.10.3", "3.7"}],
Cell[226921, 3970, 13823, 175, 70, 13687, 170, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.3"],
Cell[240747, 4147, 138, 4, 70, "MathCaption",
  CellTags->{"S1.10.3", "3.8"}],
Cell[240888, 4153, 13604, 172, 70, 13468, 167, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[254529, 4330, 78, 1, 70, "Subsection",
  CellTags->{"S1.10.4", "4.1"}],
Cell[254610, 4333, 2138, 67, 70, "DefinitionBox4Col",
  CellTags->"S1.10.4"],
Cell[256751, 4402, 287, 9, 70, "Caption",
  CellTags->"S1.10.4"],
Cell[257041, 4413, 165, 7, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.2"}],

Cell[CellGroupData[{
Cell[257231, 4424, 81, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[257315, 4428, 88, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[257418, 4434, 91, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.3"}],

Cell[CellGroupData[{
Cell[257534, 4439, 83, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[257620, 4443, 88, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[257723, 4449, 95, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.4"}],

Cell[CellGroupData[{
Cell[257843, 4454, 154, 6, 70, "Input",
  CellTags->"S1.10.4"],
Cell[258000, 4462, 88, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[258103, 4468, 85, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.5"}],

Cell[CellGroupData[{
Cell[258213, 4473, 94, 3, 70, "Input",
  CellTags->"S1.10.4"],
Cell[258310, 4478, 88, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[258413, 4484, 5258, 170, 70, "DefinitionBox4Col",
  CellTags->"S1.10.4"],
Cell[263674, 4656, 238, 7, 70, "Caption",
  CellTags->"S1.10.4"],
Cell[263915, 4665, 174, 5, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.6"}],

Cell[CellGroupData[{
Cell[264114, 4674, 86, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[264203, 4678, 102, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[264320, 4684, 84, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.7"}],

Cell[CellGroupData[{
Cell[264429, 4689, 92, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[264524, 4693, 102, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[264641, 4699, 69, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.8"}],

Cell[CellGroupData[{
Cell[264735, 4704, 91, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[264829, 4708, 102, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[264946, 4714, 64, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.9"}],

Cell[CellGroupData[{
Cell[265035, 4719, 164, 6, 70, "Input",
  CellTags->"S1.10.4"],
Cell[265202, 4727, 102, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[265319, 4733, 211, 6, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.10"}],

Cell[CellGroupData[{
Cell[265555, 4743, 83, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[265641, 4747, 117, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[265773, 4753, 12693, 408, 70, "DefinitionBox4Col",
  CellTags->"S1.10.4"],
Cell[278469, 5163, 117, 4, 70, "Caption",
  CellTags->"S1.10.4"],
Cell[278589, 5169, 242, 7, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.11"}],

Cell[CellGroupData[{
Cell[278856, 5180, 79, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[278938, 5184, 87, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[279040, 5190, 354, 8, 70, "Text",
  CellTags->{"S1.10.4", "4.12"}],
Cell[279397, 5200, 11594, 347, 70, "DefinitionBox3Col",
  CellTags->"S1.10.4"],
Cell[290994, 5549, 164, 5, 70, "Caption",
  CellTags->"S1.10.4"],
Cell[291161, 5556, 426, 9, 70, "Text",
  CellTags->{"S1.10.4", "4.13"}],
Cell[291590, 5567, 267, 6, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.14"}],

Cell[CellGroupData[{
Cell[291882, 5577, 219, 8, 70, "Input",
  CellTags->"S1.10.4"],
Cell[292104, 5587, 116, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[292235, 5593, 131, 4, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.15"}],

Cell[CellGroupData[{
Cell[292391, 5601, 125, 3, 70, "Input",
  CellTags->"S1.10.4"],
Cell[292519, 5606, 104, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[292638, 5612, 155, 5, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.16"}],

Cell[CellGroupData[{
Cell[292818, 5621, 89, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[292910, 5625, 104, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[293029, 5631, 95, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.17"}],

Cell[CellGroupData[{
Cell[293149, 5636, 120, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[293272, 5640, 104, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[293391, 5646, 4680, 139, 70, "DefinitionBox3Col",
  CellTags->"S1.10.4"],
Cell[298074, 5787, 227, 7, 70, "Caption",
  CellTags->"S1.10.4"],
Cell[298304, 5796, 438, 11, 70, "Text",
  CellTags->{"S1.10.4", "4.18"}],
Cell[298745, 5809, 88, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.19"}],

Cell[CellGroupData[{
Cell[298858, 5814, 88, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[298949, 5818, 105, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[299069, 5824, 109, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.20"}],

Cell[CellGroupData[{
Cell[299203, 5829, 430, 13, 70, "Input",
  CellTags->"S1.10.4"],
Cell[299636, 5844, 111, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[299762, 5850, 101, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.21"}],

Cell[CellGroupData[{
Cell[299888, 5855, 119, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[300010, 5859, 111, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[300136, 5865, 993, 25, 70, "Text",
  CellTags->{"S1.10.4", "4.22"}],
Cell[301132, 5892, 292, 11, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.23"}],

Cell[CellGroupData[{
Cell[301449, 5907, 101, 3, 70, "Input",
  CellTags->"S1.10.4"],
Cell[301553, 5912, 103, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[301671, 5918, 146, 4, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.24"}],

Cell[CellGroupData[{
Cell[301842, 5926, 75, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[301920, 5930, 103, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[302038, 5936, 92, 1, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.25"}],

Cell[CellGroupData[{
Cell[302155, 5941, 110, 3, 70, "Input",
  CellTags->"S1.10.4"],
Cell[302268, 5946, 139, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]],
Cell[302422, 5952, 125, 4, 70, "MathCaption",
  CellTags->{"S1.10.4", "4.26"}],

Cell[CellGroupData[{
Cell[302572, 5960, 81, 2, 70, "Input",
  CellTags->"S1.10.4"],
Cell[302656, 5964, 139, 3, 70, "Output",
  CellTags->"S1.10.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[302844, 5973, 89, 1, 70, "Subsection",
  CellTags->{"S1.10.5", "5.1"}],
Cell[302936, 5976, 388, 9, 70, "Text",
  CellTags->{"S1.10.5", "5.2"}],
Cell[303327, 5987, 175, 4, 70, "MathCaption",
  CellTags->{"S1.10.5", "5.3"}],

Cell[CellGroupData[{
Cell[303527, 5995, 141, 5, 70, "Input",
  CellTags->"S1.10.5"],
Cell[303671, 6002, 104, 3, 70, "Output",
  CellTags->"S1.10.5"]
}, Open  ]],
Cell[303790, 6008, 176, 4, 70, "MathCaption",
  CellTags->{"S1.10.5", "5.4"}],

Cell[CellGroupData[{
Cell[303991, 6016, 172, 6, 70, "Input",
  CellTags->"S1.10.5"],
Cell[304166, 6024, 104, 3, 70, "Output",
  CellTags->"S1.10.5"]
}, Open  ]],
Cell[304285, 6030, 242, 9, 70, "MathCaption",
  CellTags->{"S1.10.5", "5.5"}],

Cell[CellGroupData[{
Cell[304552, 6043, 267, 8, 70, "Input",
  CellTags->"S1.10.5"],
Cell[304822, 6053, 402, 13, 70, "Output",
  CellTags->"S1.10.5"]
}, Open  ]],
Cell[305239, 6069, 1329, 33, 70, "DefinitionBox",
  CellTags->"S1.10.5"],
Cell[306571, 6104, 72, 1, 70, "Caption",
  CellTags->"S1.10.5"],
Cell[306646, 6107, 476, 11, 70, "Text",
  CellTags->{"S1.10.5", "5.6"}],
Cell[307125, 6120, 482, 13, 70, "Text",
  CellTags->{"S1.10.5", "5.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[307644, 6138, 97, 1, 70, "Subsection",
  CellTags->{"S1.10.6", "6.1"}],
Cell[307744, 6141, 95, 1, 70, "MathCaption",
  CellTags->{"S1.10.6", "6.2"}],
Cell[307842, 6144, 19412, 244, 70, 19276, 239, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.6"],
Cell[327257, 6390, 154, 4, 70, "MathCaption",
  CellTags->{"S1.10.6", "6.3"}],

Cell[CellGroupData[{
Cell[327436, 6398, 114, 3, 70, "Input",
  CellTags->"S1.10.6"],
Cell[327553, 6403, 168, 4, 70, "Output",
  CellTags->"S1.10.6"]
}, Open  ]],
Cell[327736, 6410, 195, 5, 70, "MathCaption",
  CellTags->{"S1.10.6", "6.4"}],

Cell[CellGroupData[{
Cell[327956, 6419, 100, 3, 70, "Input",
  CellTags->"S1.10.6"],
Cell[328059, 6424, 136, 3, 70, "Output",
  CellTags->"S1.10.6"]
}, Open  ]],
Cell[328210, 6430, 1764, 44, 70, "DefinitionBox",
  CellTags->"S1.10.6"],
Cell[329977, 6476, 153, 4, 70, "Caption",
  CellTags->"S1.10.6"],
Cell[330133, 6482, 99, 1, 70, "MathCaption",
  CellTags->{"S1.10.6", "6.5"}],

Cell[CellGroupData[{
Cell[330257, 6487, 305, 9, 70, "Input",
  CellTags->"S1.10.6"],
Cell[330565, 6498, 168, 4, 70, "Output",
  CellTags->"S1.10.6"]
}, Open  ]],
Cell[330748, 6505, 913, 22, 70, "Text",
  CellTags->{"S1.10.6", "6.6"}],
Cell[331664, 6529, 4287, 127, 70, "DefinitionBox3Col",
  CellTags->"S1.10.6"],
Cell[335954, 6658, 98, 1, 70, "Caption",
  CellTags->"S1.10.6"],
Cell[336055, 6661, 227, 9, 70, "MathCaption",
  CellTags->{"S1.10.6", "6.7"}],

Cell[CellGroupData[{
Cell[336307, 6674, 289, 9, 70, "Input",
  CellTags->"S1.10.6"],
Cell[336599, 6685, 86, 3, 70, "Output",
  CellTags->"S1.10.6"]
}, Open  ]],
Cell[336700, 6691, 245, 9, 70, "MathCaption",
  CellTags->{"S1.10.6", "6.8"}],

Cell[CellGroupData[{
Cell[336970, 6704, 83, 2, 70, "Input",
  CellTags->"S1.10.6"],
Cell[337056, 6708, 127, 3, 70, "Output",
  CellTags->"S1.10.6"]
}, Open  ]],
Cell[337198, 6714, 7525, 233, 70, "DefinitionBox3Col",
  CellTags->"S1.10.6"],
Cell[344726, 6949, 268, 10, 70, "Caption",
  CellTags->"S1.10.6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[345031, 6964, 130, 4, 70, "Subsection",
  CellTags->{"S1.10.7", "7.1"}],
Cell[345164, 6970, 494, 9, 70, "Text",
  CellTags->{"S1.10.7", "7.2"}],
Cell[345661, 6981, 7765, 163, 70, "DoubleBox",
  CellTags->"S1.10.7"],
Cell[353429, 7146, 75, 1, 70, "Caption",
  CellTags->"S1.10.7"],
Cell[353507, 7149, 127, 4, 70, "MathCaption",
  CellTags->{"S1.10.7", "7.3"}],

Cell[CellGroupData[{
Cell[353659, 7157, 84, 2, 70, "Input",
  CellTags->"S1.10.7"],
Cell[353746, 7161, 100, 3, 70, "Output",
  CellTags->"S1.10.7"]
}, Open  ]],
Cell[353861, 7167, 100, 1, 70, "MathCaption",
  CellTags->{"S1.10.7", "7.4"}],

Cell[CellGroupData[{
Cell[353986, 7172, 154, 6, 70, "Input",
  CellTags->"S1.10.7"],
Cell[354143, 7180, 100, 3, 70, "Output",
  CellTags->"S1.10.7"]
}, Open  ]],
Cell[354258, 7186, 277, 6, 70, "Text",
  CellTags->{"S1.10.7", "7.5"}],
Cell[354538, 7194, 660, 19, 70, "Text",
  CellTags->{"S1.10.7", "7.6"}],
Cell[355201, 7215, 478, 10, 70, "Text",
  CellTags->{"S1.10.7", "7.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[355716, 7230, 88, 1, 70, "Subsection",
  CellTags->{"S1.10.8", "8.1"}],
Cell[355807, 7233, 623, 18, 70, "Text",
  CellTags->{"S1.10.8", "8.2"}],
Cell[356433, 7253, 279, 8, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.3"}],

Cell[CellGroupData[{
Cell[356737, 7265, 104, 2, 70, "Input",
  CellTags->"S1.10.8"],
Cell[356844, 7269, 117, 3, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]],
Cell[356976, 7275, 247, 8, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.4"}],
Cell[357226, 7285, 101, 2, 70, "Input",
  CellTags->"S1.10.8"],
Cell[357330, 7289, 224, 8, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.5"}],

Cell[CellGroupData[{
Cell[357579, 7301, 104, 2, 70, "Input",
  CellTags->"S1.10.8"],
Cell[357686, 7305, 88, 3, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]],
Cell[357789, 7311, 9978, 206, 70, "DoubleBox",
  CellTags->"S1.10.8"],
Cell[367770, 7519, 150, 5, 70, "Caption",
  CellTags->"S1.10.8"],
Cell[367923, 7526, 521, 16, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.6"}],

Cell[CellGroupData[{
Cell[368469, 7546, 158, 3, 70, "Input",
  CellTags->"S1.10.8"],
Cell[368630, 7551, 142, 4, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]],
Cell[368787, 7558, 483, 11, 70, "Text",
  CellTags->{"S1.10.8", "8.7"}],
Cell[369273, 7571, 371, 11, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.8"}],

Cell[CellGroupData[{
Cell[369669, 7586, 220, 8, 70, "Input",
  CellTags->"S1.10.8"],
Cell[369892, 7596, 110, 3, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]],
Cell[370017, 7602, 587, 15, 70, "Text",
  CellTags->{"S1.10.8", "8.9"}],
Cell[370607, 7619, 134, 4, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.10"}],

Cell[CellGroupData[{
Cell[370766, 7627, 113, 2, 70, "Input",
  CellTags->"S1.10.8"],
Cell[370882, 7631, 126, 3, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]],
Cell[371023, 7637, 5487, 117, 70, "DoubleBox",
  CellTags->"S1.10.8"],
Cell[376513, 7756, 107, 4, 70, "Caption",
  CellTags->"S1.10.8"],
Cell[376623, 7762, 142, 4, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.11"}],

Cell[CellGroupData[{
Cell[376790, 7770, 109, 2, 70, "Input",
  CellTags->"S1.10.8"],
Cell[376902, 7774, 125, 3, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]],
Cell[377042, 7780, 269, 9, 70, "MathCaption",
  CellTags->{"S1.10.8", "8.12"}],

Cell[CellGroupData[{
Cell[377336, 7793, 80, 2, 70, "Input",
  CellTags->"S1.10.8"],
Cell[377419, 7797, 99, 3, 70, "Output",
  CellTags->"S1.10.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[377567, 7806, 86, 1, 70, "Subsection",
  CellTags->{"S1.10.9", "9.1"}],
Cell[377656, 7809, 278, 6, 70, "Text",
  CellTags->{"S1.10.9", "9.2"}],
Cell[377937, 7817, 1104, 38, 70, "DefinitionBox",
  CellTags->"S1.10.9"],
Cell[379044, 7857, 69, 1, 70, "Caption",
  CellTags->"S1.10.9"],
Cell[379116, 7860, 184, 7, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.3"}],

Cell[CellGroupData[{
Cell[379325, 7871, 76, 2, 70, "Input",
  CellTags->"S1.10.9"],
Cell[379404, 7875, 96, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[379515, 7881, 160, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.4"}],

Cell[CellGroupData[{
Cell[379700, 7890, 95, 3, 70, "Input",
  CellTags->"S1.10.9"],
Cell[379798, 7895, 96, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[379909, 7901, 265, 7, 70, "Text",
  CellTags->{"S1.10.9", "9.5"}],
Cell[380177, 7910, 173, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.6"}],

Cell[CellGroupData[{
Cell[380375, 7919, 90, 2, 70, "Input",
  CellTags->"S1.10.9"],
Cell[380468, 7923, 102, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[380585, 7929, 164, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.7"}],

Cell[CellGroupData[{
Cell[380774, 7938, 104, 2, 70, "Input",
  CellTags->"S1.10.9"],
Cell[380881, 7942, 106, 2, 70, "Output",
  CellTags->"S1.10.9"],
Cell[380990, 7946, 162, 6, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[381167, 7955, 181, 6, 70, "Text",
  CellTags->{"S1.10.9", "9.8"}],
Cell[381351, 7963, 314, 8, 70, "Text",
  CellTags->{"S1.10.9", "9.9"}],
Cell[381668, 7973, 154, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.10"}],

Cell[CellGroupData[{
Cell[381847, 7982, 131, 3, 70, "Input",
  CellTags->"S1.10.9"],
Cell[381981, 7987, 169, 4, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[382165, 7994, 215, 6, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.11"}],

Cell[CellGroupData[{
Cell[382405, 8004, 162, 4, 70, "Input",
  CellTags->"S1.10.9"],
Cell[382570, 8010, 169, 4, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[382754, 8017, 463, 11, 70, "Text",
  CellTags->{"S1.10.9", "9.12"}],
Cell[383220, 8030, 226, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.13"}],

Cell[CellGroupData[{
Cell[383471, 8039, 157, 4, 70, "Input",
  CellTags->"S1.10.9"],
Cell[383631, 8045, 219, 4, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[383865, 8052, 156, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.14"}],

Cell[CellGroupData[{
Cell[384046, 8061, 144, 5, 70, "Input",
  CellTags->"S1.10.9"],
Cell[384193, 8068, 691, 19, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[384899, 8090, 470, 11, 70, "Text",
  CellTags->{"S1.10.9", "9.15"}],
Cell[385372, 8103, 572, 20, 70, "Text",
  CellTags->{"S1.10.9", "9.16"}],
Cell[385947, 8125, 194, 6, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.17"}],

Cell[CellGroupData[{
Cell[386166, 8135, 119, 2, 70, "Input",
  CellTags->"S1.10.9"],
Cell[386288, 8139, 144, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[386447, 8145, 238, 6, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.18"}],

Cell[CellGroupData[{
Cell[386710, 8155, 123, 2, 70, "Input",
  CellTags->"S1.10.9"],
Cell[386836, 8159, 156, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[387007, 8165, 485, 13, 70, "Text",
  CellTags->{"S1.10.9", "9.19"}],
Cell[387495, 8180, 201, 6, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.20"}],
Cell[387699, 8188, 19875, 250, 70, 19738, 245, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.9"],
Cell[407577, 8440, 262, 6, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.21"}],
Cell[407842, 8448, 20600, 259, 70, 20463, 254, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.9"],
Cell[428445, 8709, 797, 26, 70, "FramedBox",
  CellTags->"S1.10.9"],
Cell[429245, 8737, 158, 5, 70, "Caption",
  CellTags->"S1.10.9"],
Cell[429406, 8744, 472, 10, 70, "Text",
  CellTags->{"S1.10.9", "9.22"}],
Cell[429881, 8756, 142, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.23"}],

Cell[CellGroupData[{
Cell[430048, 8765, 96, 2, 70, "Input",
  CellTags->"S1.10.9"],
Cell[430147, 8769, 163, 4, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[430325, 8776, 305, 7, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.24"}],

Cell[CellGroupData[{
Cell[430655, 8787, 166, 4, 70, "Input",
  CellTags->"S1.10.9"],
Cell[430824, 8793, 141, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[430980, 8799, 111, 1, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.25"}],

Cell[CellGroupData[{
Cell[431116, 8804, 169, 4, 70, "Input",
  CellTags->"S1.10.9"],
Cell[431288, 8810, 144, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[431447, 8816, 488, 11, 70, "Text",
  CellTags->{"S1.10.9", "9.26"}],
Cell[431938, 8829, 163, 5, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.27"}],

Cell[CellGroupData[{
Cell[432126, 8838, 160, 4, 70, "Input",
  CellTags->"S1.10.9"],
Cell[432289, 8844, 189, 5, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[432493, 8852, 95, 1, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.28"}],

Cell[CellGroupData[{
Cell[432613, 8857, 133, 3, 70, "Input",
  CellTags->"S1.10.9"],
Cell[432749, 8862, 106, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[432870, 8868, 104, 1, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.29"}],

Cell[CellGroupData[{
Cell[432999, 8873, 128, 3, 70, "Input",
  CellTags->"S1.10.9"],
Cell[433130, 8878, 106, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[433251, 8884, 242, 7, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.30"}],

Cell[CellGroupData[{
Cell[433518, 8895, 133, 3, 70, "Input",
  CellTags->"S1.10.9"],
Cell[433654, 8900, 106, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[433775, 8906, 369, 8, 70, "Text",
  CellTags->{"S1.10.9", "9.31"}],
Cell[434147, 8916, 1488, 41, 70, "FramedBox",
  CellTags->"S1.10.9"],
Cell[435638, 8959, 126, 5, 70, "Caption",
  CellTags->"S1.10.9"],
Cell[435767, 8966, 381, 17, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.32"}],

Cell[CellGroupData[{
Cell[436173, 8987, 140, 3, 70, "Input",
  CellTags->"S1.10.9"],
Cell[436316, 8992, 122, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]],
Cell[436453, 8998, 370, 10, 70, "MathCaption",
  CellTags->{"S1.10.9", "9.33"}],

Cell[CellGroupData[{
Cell[436848, 9012, 152, 4, 70, "Input",
  CellTags->"S1.10.9"],
Cell[437003, 9018, 125, 3, 70, "Output",
  CellTags->"S1.10.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[437177, 9027, 88, 1, 70, "Subsection",
  CellTags->{"S1.10.10", "10.1"}],
Cell[437268, 9030, 310, 7, 70, "Text",
  CellTags->{"S1.10.10", "10.2"}],
Cell[437581, 9039, 922, 28, 70, "DefinitionBox",
  CellTags->"S1.10.10"],
Cell[438506, 9069, 90, 1, 70, "Caption",
  CellTags->"S1.10.10"],
Cell[438599, 9072, 116, 2, 70, "MathCaption",
  CellTags->{"S1.10.10", "10.3"}],
Cell[438718, 9076, 32034, 400, 70, 31896, 395, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.10"],
Cell[470755, 9478, 290, 7, 70, "Text",
  CellTags->{"S1.10.10", "10.4"}],
Cell[471048, 9487, 528, 15, 70, "Text",
  CellTags->{"S1.10.10", "10.5"}],
Cell[471579, 9504, 247, 6, 70, "Text",
  CellTags->{"S1.10.10", "10.6"}],
Cell[471829, 9512, 476, 10, 70, "Text",
  CellTags->{"S1.10.10", "10.7"}],
Cell[472308, 9524, 308, 8, 70, "Text",
  CellTags->{"S1.10.10", "10.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[472653, 9537, 154, 5, 70, "Subsection",
  CellTags->{"S1.10.11", "11.1"}],
Cell[472810, 9544, 440, 10, 70, "Text",
  CellTags->{"S1.10.11", "11.2"}],
Cell[473253, 9556, 1181, 30, 70, "DefinitionBox",
  CellTags->"S1.10.11"],
Cell[474437, 9588, 121, 4, 70, "Caption",
  CellTags->"S1.10.11"],
Cell[474561, 9594, 139, 4, 70, "MathCaption",
  CellTags->{"S1.10.11", "11.3"}],
Cell[474703, 9600, 60384, 750, 70, 60246, 745, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.11"],
Cell[535090, 10352, 106, 1, 70, "MathCaption",
  CellTags->{"S1.10.11", "11.4"}],
Cell[535199, 10355, 43957, 547, 70, 43819, 542, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.11"],
Cell[579159, 10904, 136, 4, 70, "MathCaption",
  CellTags->{"S1.10.11", "11.5"}],
Cell[579298, 10910, 47197, 587, 70, 47059, 582, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.11"]
}, Open  ]],

Cell[CellGroupData[{
Cell[626532, 11502, 90, 1, 70, "Subsection",
  CellTags->{"S1.10.12", "12.1"}],
Cell[626625, 11505, 230, 6, 70, "Text",
  CellTags->{"S1.10.12", "12.2"}],
Cell[626858, 11513, 793, 21, 70, "FramedBox",
  CellTags->"S1.10.12"],
Cell[627654, 11536, 82, 1, 70, "Caption",
  CellTags->"S1.10.12"],
Cell[627739, 11539, 151, 4, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.3"}],
Cell[627893, 11545, 12475, 158, 70, 12338, 153, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[640371, 11705, 112, 1, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.4"}],
Cell[640486, 11708, 14520, 183, 70, 14383, 178, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[655009, 11893, 179, 5, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.5"}],
Cell[655191, 11900, 9608, 123, 70, 9471, 118, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[664802, 12025, 147, 4, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.6"}],
Cell[664952, 12031, 6335, 82, 70, 6198, 77, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[671290, 12115, 901, 23, 70, "DefinitionBox",
  CellTags->"S1.10.12"],
Cell[672194, 12140, 79, 1, 70, "Caption",
  CellTags->"S1.10.12"],
Cell[672276, 12143, 527, 10, 70, "Text",
  CellTags->{"S1.10.12", "12.7"}],
Cell[672806, 12155, 1136, 36, 70, "DefinitionBox",
  CellTags->"S1.10.12"],
Cell[673945, 12193, 64, 1, 70, "Caption",
  CellTags->"S1.10.12"],
Cell[674012, 12196, 257, 5, 70, "Text",
  CellTags->{"S1.10.12", "12.8"}],
Cell[674272, 12203, 331, 7, 70, "Text",
  CellTags->{"S1.10.12", "12.9"}],
Cell[674606, 12212, 1014, 26, 70, "Text",
  CellTags->{"S1.10.12", "12.10"}],
Cell[675623, 12240, 139, 4, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.11"}],
Cell[675765, 12246, 5744, 75, 70, 5607, 70, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[681512, 12323, 320, 10, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.12"}],
Cell[681835, 12335, 6526, 85, 70, 6389, 80, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[688364, 12422, 315, 7, 70, "Text",
  CellTags->{"S1.10.12", "12.13"}],
Cell[688682, 12431, 1128, 34, 70, "DefinitionBox",
  CellTags->"S1.10.12"],
Cell[689813, 12467, 72, 1, 70, "Caption",
  CellTags->"S1.10.12"],
Cell[689888, 12470, 381, 9, 70, "Text",
  CellTags->{"S1.10.12", "12.14"}],
Cell[690272, 12481, 471, 12, 70, "Text",
  CellTags->{"S1.10.12", "12.15"}],
Cell[690746, 12495, 358, 9, 70, "Text",
  CellTags->{"S1.10.12", "12.16"}],
Cell[691107, 12506, 102, 1, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.17"}],
Cell[691212, 12509, 5744, 75, 70, 5607, 70, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[696959, 12586, 338, 10, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.18"}],
Cell[697300, 12598, 13949, 176, 70, 13812, 171, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[711252, 12776, 321, 9, 70, "Text",
  CellTags->{"S1.10.12", "12.19"}],
Cell[711576, 12787, 102, 1, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.20"}],
Cell[711681, 12790, 5744, 75, 70, 5607, 70, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[717428, 12867, 308, 7, 70, "MathCaption",
  CellTags->{"S1.10.12", "12.21"}],
Cell[717739, 12876, 18036, 227, 70, 17899, 222, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.12"],
Cell[735778, 13105, 862, 22, 70, "DefinitionBox",
  CellTags->"S1.10.12"],
Cell[736643, 13129, 92, 1, 70, "Caption",
  CellTags->"S1.10.12"],
Cell[736738, 13132, 398, 7, 70, "Text",
  CellTags->{"S1.10.12", "12.22"}],
Cell[737139, 13141, 416, 11, 70, "Text",
  CellTags->{"S1.10.12", "12.23"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[737592, 13157, 85, 1, 70, "Subsection",
  CellTags->{"S1.10.13", "13.1"}],
Cell[737680, 13160, 366, 10, 70, "DefinitionBox",
  CellTags->"S1.10.13"],
Cell[738049, 13172, 80, 1, 70, "Caption",
  CellTags->"S1.10.13"],
Cell[738132, 13175, 276, 6, 70, "Text",
  CellTags->{"S1.10.13", "13.2"}],
Cell[738411, 13183, 322, 7, 70, "Text",
  CellTags->{"S1.10.13", "13.3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[738770, 13195, 83, 1, 70, "Subsection",
  CellTags->{"S1.10.14", "14.1"}],
Cell[738856, 13198, 646, 18, 70, "FramedBox",
  CellTags->"S1.10.14"],
Cell[739505, 13218, 153, 5, 70, "Caption",
  CellTags->"S1.10.14"],
Cell[739661, 13225, 233, 5, 70, "MathCaption",
  CellTags->{"S1.10.14", "14.2"}],
Cell[739897, 13232, 20771, 261, 70, 20633, 256, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.14"],
Cell[760671, 13495, 144, 5, 40, "MathCaption",
  CellTags->{"S1.10.14", "14.3"}],
Cell[760818, 13502, 23589, 295, 70, 23451, 290, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.10.14"]
}, Open  ]],

Cell[CellGroupData[{
Cell[784444, 13802, 144, 5, 38, "Subsection",
  CellTags->{"S1.10.15", "15.1"}],
Cell[784591, 13809, 337, 7, 56, "Text",
  CellTags->{"S1.10.15", "15.2"}],
Cell[784931, 13818, 768, 16, 120, "Text",
  CellTags->{"S1.10.15", "15.3"}],
Cell[785702, 13836, 431, 10, 72, "Text",
  CellTags->{"S1.10.15", "15.4"}],
Cell[786136, 13848, 914, 22, 136, "Text",
  CellTags->{"S1.10.15", "15.5"}],
Cell[787053, 13872, 787, 18, 120, "Text",
  CellTags->{"S1.10.15", "15.6"}],
Cell[787843, 13892, 528, 10, 88, "Text",
  CellTags->{"S1.10.15", "15.7"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

