(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    167802,       4148]*)
(*NotebookOutlinePosition[    198582,       5043]*)
(*  CellTagsIndexPosition[    195706,       4928]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["1.11 ", "HeadingNumber"],
  "Files and External Operations"
}], "Section",
  CellTags->{"S1.11.0", "0.1"}],

Cell[CellGroupData[{

Cell[TextData[{
  "1.11.1 Reading and Writing ",
  StyleBox["Mathematica", "SBO"],
  " Files"
}], "Subsection",
  CellTags->{"S1.11.1", "1.1"}],

Cell[TextData[{
  "You can use files on your computer system to store definitions and results \
from ",
  StyleBox["Mathematica", "TI"],
  ". The most general approach is to store everything as plain text that is \
appropriate for input to ",
  StyleBox["Mathematica", "TI"],
  ". With this approach, a version of ",
  StyleBox["Mathematica", "TI"],
  " running on one computer system produces files that can be read by a \
version running on any computer system. In addition, such files can be \
manipulated by other standard programs, such as text editors. "
}], "Text",
  CellTags->{"S1.11.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              " ",
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "read in a ",
              StyleBox["Mathematica", "TI"],
              " input file "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>", "MR"],
              " ",
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "output ",
              StyleBox["expr", "TI"],
              " to a file as plain text "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>>", "MR"],
              " ",
              StyleBox["name", "TI"],
              " "
            }]], Cell[TextData[{
              "append ",
              StyleBox["expr", "TI"],
              " to a file "
            }]]},
          {Cell[TextData[{
              StyleBox["!!", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["display the contents of a plain text file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.1"],

Cell["Reading and writing files. ", "Caption",
  CellTags->"S1.11.1"],

Cell[TextData[{
  "This expands ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "+", 
              StyleBox["y",
                "TI"]}], ")"}], "3"], TraditionalForm]], "InlineFormula"],
  ", and outputs the result to a file called ",
  StyleBox["tmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.3"}],

Cell["Expand[ (x + y)^3 ] >> tmp", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.1"],

Cell[TextData[{
  "Here are the contents of ",
  StyleBox["tmp", "MR"],
  ". They can be used directly as input for ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.4"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.1"],

Cell["x^3 + 3*x^2*y + 3*x*y^2 + y^3", "Print",
  CellTags->"S1.11.1"]
}, Open  ]],

Cell[TextData[{
  "This reads in ",
  StyleBox["tmp", "MR"],
  ", evaluating the ",
  StyleBox["Mathematica", "TI"],
  " input it contains. "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.5"}],

Cell[CellGroupData[{

Cell["<<tmp", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.1"],

Cell[BoxData[
    \(x\^3 + 3\ x\^2\ y + 3\ x\ y\^2 + y\^3\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.11.1"]
}, Open  ]],

Cell[TextData[{
  "If you are familiar with command\[Hyphen]line operating systems, you will \
recognize the ",
  StyleBox["Mathematica", "TI"],
  " redirection operators ",
  StyleBox[">>", "MR"],
  ", ",
  StyleBox[">>>", "MR"],
  " and ",
  StyleBox["<<", "MR"],
  " as being analogous to the command\[Hyphen]line operators ",
  StyleBox[">", "MR"],
  ", ",
  StyleBox[">>", "MR"],
  " and ",
  StyleBox["<", "MR"],
  ". "
}], "Text",
  CellTags->{"S1.11.1", "1.6"}],

Cell[TextData[{
  "The redirection operators ",
  StyleBox[">>", "MR"],
  " and ",
  StyleBox[">>>", "MR"],
  " are convenient for storing results you get from ",
  StyleBox["Mathematica", "TI"],
  ". The function ",
  StyleBox["Save[\"", "MR"],
  StyleBox["name", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["g", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " allows you to save definitions for variables and functions. "
}], "Text",
  CellTags->{"S1.11.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Save[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "save definitions for variables or functions in a file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.1"],

Cell["Saving definitions in plain text files. ", "Caption",
  CellTags->"S1.11.1"],

Cell[TextData[{
  "Here is a definition for a function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.8"}],

Cell["f[x_] := x^2 + c", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.11.1"],

Cell[TextData[{
  "This gives ",
  StyleBox["c", "MR"],
  " the value ",
  StyleBox["17", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.9"}],

Cell[CellGroupData[{

Cell["c = 17", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.11.1"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.11.1"]
}, Open  ]],

Cell[TextData[{
  "This saves the definition of ",
  StyleBox["f", "MR"],
  " in the file ",
  StyleBox["ftmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.10"}],

Cell["Save[\"ftmp\", f]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S1.11.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " automatically saves both the actual definition of ",
  StyleBox["f", "MR"],
  ", and the definition of ",
  StyleBox["c", "MR"],
  " on which it depends. "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.11"}],

Cell[CellGroupData[{

Cell["!!ftmp", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S1.11.1"],

Cell["\<\
f[x_] := x^2 + c
 
c = 17\
\>", "Print",
  CellTags->"S1.11.1"]
}, Open  ]],

Cell[TextData[{
  "This clears the definitions of ",
  StyleBox["f", "MR"],
  " and ",
  StyleBox["c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.12"}],

Cell["Clear[f, c]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S1.11.1"],

Cell[TextData[{
  "You can reinstate the definitions you saved simply by reading in the file \
",
  StyleBox["ftmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.13"}],

Cell[CellGroupData[{

Cell["<<ftmp", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S1.11.1"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S1.11.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["file", "TI"],
              StyleBox[".m", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " expression file in plain text format "
            }]]},
          {Cell[TextData[{
              StyleBox["file", "TI"],
              StyleBox[".nb", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " notebook file "
            }]]},
          {Cell[TextData[{
              StyleBox["file", "TI"],
              StyleBox[".mx", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              " definitions in ",
              StyleBox["DumpSave", "MR"],
              " format "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.1"],

Cell[TextData[{
  "Typical names of ",
  StyleBox["Mathematica", "SO"],
  " files. "
}], "Caption",
  CellTags->"S1.11.1"],

Cell[TextData[{
  "If you use a notebook interface to ",
  StyleBox["Mathematica", "TI"],
  ", then the ",
  StyleBox["Mathematica", "TI"],
  " front end allows you to save complete notebooks, including not only ",
  StyleBox["Mathematica", "TI"],
  " input and output, but also text, graphics and other material. "
}], "Text",
  CellTags->{"S1.11.1", "1.14"}],

Cell[TextData[{
  "It is conventional to give ",
  StyleBox["Mathematica", "TI"],
  " notebook files names that end in ",
  StyleBox[".nb", "MR"],
  ", and most versions of ",
  StyleBox["Mathematica", "TI"],
  " enforce this convention. "
}], "Text",
  CellTags->{"S1.11.1", "1.15"}],

Cell[TextData[{
  "When you open a notebook in the ",
  StyleBox["Mathematica", "TI"],
  " front end, ",
  StyleBox["Mathematica", "TI"],
  " will immediately display the contents of the notebook, but it will not \
normally send any of these contents to the kernel for evaluation until you \
explicitly request this to be done. "
}], "Text",
  CellTags->{"S1.11.1", "1.16"}],

Cell[TextData[{
  "Within a ",
  StyleBox["Mathematica", "TI"],
  " notebook, however, you can use the ",
  StyleBox["Cell", "SR"],
  " menu in the front end to identify certain cells as ",
  StyleBox["initialization cells", "TI"],
  ", and if you do this, then the contents of these cells will automatically \
be evaluated whenever you open the notebook. "
}], "Text",
  CellTags->{"S1.11.1", "1.17"}],

Cell[TextData[{
  "The ",
  StyleBox["I", "MR"],
  " in the cell bracket indicates that the second cell is an initialization \
cell that will be evaluated whenever the notebook is opened. "
}], "MathCaption",
  CellTags->{"S1.11.1", "1.18"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000ER000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool00?l0<c<co`0c<c<;03<c<`40oooo00000`3UiND0<c<c
03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c
<c<10?ooo`0000<0iNGU09VIV@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0iNGU09VI
V@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVIo`3UiNGo0>GU
i@80iNGU0`2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0ooooj`3oool50000o`80oooo1@000?l70?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cX0oooo100000090?ooo`P0000000<0oooo0000
000000000P00000Z0?ooo`@000001@3oool4000000X0oooo1000000P0?ooo`@000001@3oool40000
01l0oooo1000003o0?ooo`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c>P3oool2
000001H0oooo0P00000]0?ooo`800000103oool2000000h0oooo0P00000S0?ooo`800000103oool2
000002<0oooo0P00003o0?ooo`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<@3o
ool5000000@0oooo0P0000040?ooo`H00000303oool2000000T0oooo0P00000>0?ooo`L000000`3o
ool4000000<0oooo1@0000040?ooo`800000103oool6000000@0oooo0P0000080?ooo`030000003o
ool0oooo00@0oooo1`0000030?ooo`@000000`3oool5000000@0oooo0P0000040?ooo`H000003`3o
ool6000000@0oooo0P00003o0?ooo`H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
<P3oool2000000H0oooo0P0000050?ooo`@000003@3oool2000000l0oooo1@0000060?ooo`800000
0P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo
0P0000050?ooo`@000001@3oool2000000P0oooo00<000000?ooo`3oool01@3oool200000080oooo
0P0000020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`800000
1P3oool200000180oooo100000050?ooo`800000o`3oool60?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI
09VIV@2IVIT203<c<c80oooo0P0000060?ooo`8000001P3oool2000000h0oooo0P00000J0?ooo`80
00000P3oool200000080oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0
oooo0P0000060?ooo`8000001P3oool2000000H0oooo1@0000050?ooo`8000000P3oool200000080
oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P0000060?ooo`80
00001`3oool5000000L0oooo0P0000060?ooo`800000o`3oool60?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<c80oooo0P0000060?ooo`8000001P3oool2000000h0oooo0P00000?0?oo
o`D000001P3oool2000000H0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool20000
00@0oooo0P0000060?ooo`8000001P3oool2000000P0oooo00<000000?ooo`3oool01@3oool20000
00H0oooo0P0000020?ooo`80000000<0oooo0000000000000P3oool2000000@0oooo0P0000060?oo
o`8000004`3oool2000000H0oooo0P00003o0?ooo`@0oooo00<0003o0?ooo`000?l01P3oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<P3oool2000000H0oooo0P0000050?ooo`@000003@3oool2000001X0oooo0P000006
0?ooo`8000000P3oool2000000030?ooo`00000000000080oooo0P0000040?ooo`8000001@3oool4
000000D0oooo0P0000080?ooo`030000003oool0oooo00D0oooo0P0000060?ooo`8000000P3oool2
000000030?ooo`00000000000080oooo0P0000040?ooo`8000001P3oool200000180oooo10000005
0?ooo`800000o`3oool40?ooo`030000o`3oool0003o00H0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<c40oooo1@00
00040?ooo`800000103oool6000000`0oooo0P0000090?ooo`8000003`3oool2000000L0oooo1000
00030?ooo`H000000`3oool2000000@0oooo1P0000040?ooo`800000403oool2000000L0oooo1000
00030?ooo`H000000`3oool2000000@0oooo1000000A0?ooo`H00000103oool200000?l0oooo103o
ool00`000?l0oooo0000o`060?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<b0?ooo`8000001P3oool2000001H0oooo
0P00000J0?ooo`8000005`3oool2000000h0oooo0P00000@0?ooo`8000005`3oool2000000D0oooo
0`00000K0?ooo`800000o`3oool40?ooo`<0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<`3oool3000000@0
oooo1000000B0?ooo`@000006@3oool4000001H0oooo1000000:0?ooo`@000003`3oool4000001H0
oooo100000040?ooo`8000006@3oool400000?l0oooo103oool00`000?l0oooo0000o`060?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooon`0oooo00@0003o0?ooo`3oool0003o1P3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooo[0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3ooooZ0?ooo`H0
003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00004
0>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<b`0oooo0P00003o0?oool40oooo00<0003o0?ooo`3oool0103o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<c;03oool200000?l0oooo`@3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c</0?ooo`800000o`3oooo10?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<``0oooo2@0000070?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool50000
00<0oooo0P0000040?ooo`<000000`3oool200000080oooo0P0000020?ooo`800000103oool30000
00<0oooo0P0000030?ooo`8000000P3oool2000000<0oooo1`0000000`3oool00000000000020?oo
o`800000103oool3000000<0oooo0P0000030?ooo`800000o`3ooom^0?ooo`030000o`3oool0oooo
00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`8000000P3oool200000080oooo0P000002
0?ooo`8000000P3oool3000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo
0000000000000P3oool200000080oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000
00000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool200000080oooo0`000000
0`3oool00000000000030?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P000003
0?ooo`800000o`3ooom^0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@00
00070?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P00
00000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`00000000000080oooo0P00
00020?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0
oooo0000000000000`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000000P3o
ool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom^0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`8000000P3oool200000080oooo
0P0000020?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`800000
1P3oool200000080oooo0P0000020?ooo`8000000P3oool2000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000
0P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom^0?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`8000000P3oool200000080
oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?ooo`L0
000000<0oooo0000000000000P3oool200000080oooo0P0000020?ooo`L0000000<0oooo00000000
00000`3oool2000000030?ooo`000000000000@0oooo1P0000000`3oool00000000000030?ooo`80
00000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooom^0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`8000000P3oool20000
0080oooo0P0000020?ooo`8000000P3oool2000000<0oooo0P0000000`3oool00000000000020?oo
o`8000000`3oool2000000030?ooo`00000000000080oooo0P0000020?ooo`8000000P3oool20000
00<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo0000000000001`3oool30000
00030?ooo`000000000000<0oooo0P0000020?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P00003o0?ooofh0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9
000000L0oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000020?ooo`8000000`3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000P3oool2
00000080oooo0P0000020?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000000
0`3oool00000000000030?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P000002
0?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P00003o0?ooofh0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<c303oool9000000L0oooo0P0000020?ooo`<0000000D0
oooo00000000000000000?ooo`0200000080oooo0`0000000`3oool00000000000020?ooo`800000
0`3oool2000000030?ooo`00000000000080oooo0`0000001@3oool00000000000000000oooo0080
00000`3oool2000000030?ooo`00000000000080oooo0`0000020?ooo`80000000<0oooo00000000
00000`3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`8000000`3oool200000003
0?ooo`00000000000080oooo0`0000020?ooo`800000o`3ooom^0?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<``0oooo2@0000070?ooo`8000000P3oool5000000040?ooo`0000000000
000000<0oooo1@0000030?ooo`800000103oool3000000<0oooo1@000000103oool0000000000000
00050?ooo`<000000`3oool6000000030?ooo`0000000000008000000`3oool5000000030?ooo`00
00000000008000000P3oool2000000@0oooo0`0000030?ooo`H00000o`3ooom_0?ooo`030000o`3o
ool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<a`0oooo0P00000F0?ooo`8000009P3oool2000000/0oooo
0P00003o0?oooh@0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c703oool2000001H0
oooo0P00000V0?ooo`8000002`3oool200000?l0ooooP@3oool40000o`H0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<a`0oooo0P00000F0?ooo`800000>03oool200000?l0ooooO`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c?o0?ooon/0oooo1@000?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooo
oP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0
oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT2
03<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3UiND0VIVI
09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo003o0>GU
iOl0iNGU2P3UiND103<c<`40oooo003o0>GUiOl0iNGU2`3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 86},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.11.1"],

Cell[TextData[{
  "It is sometimes convenient to maintain ",
  StyleBox["Mathematica", "TI"],
  " material both in a notebook which contains explanatory text, and in a \
package which contains only raw ",
  StyleBox["Mathematica", "TI"],
  " definitions. You can do this by putting the ",
  StyleBox["Mathematica", "TI"],
  " definitions into initialization cells in the notebook. Every time you \
save the notebook, the front end will then allow you to save an associated ",
  StyleBox[".m", "MR"],
  " file which contains only the raw ",
  StyleBox["Mathematica", "TI"],
  " definitions. "
}], "Text",
  CellTags->{"S1.11.1", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.2 Advanced Topic: Finding and Manipulating Files", "Subsection",
  CellTags->{"S1.11.2", "2.1"}],

Cell[TextData[{
  "Although the details of how files are named and organized differ from one \
computer system to another, ",
  StyleBox["Mathematica", "TI"],
  " provides some fairly general mechanisms for finding and handling files. "
}], "Text",
  CellTags->{"S1.11.2", "2.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " assumes that files on your computer system are organized in a collection \
of ",
  StyleBox["directories", "TI"],
  ". At any point, you have a ",
  StyleBox["current working directory", "TI"],
  ". You can always refer to files in this directory just by giving their \
names. "
}], "Text",
  CellTags->{"S1.11.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Directory[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["give your current working directory "]},
          {Cell[TextData[{
              StyleBox["SetDirectory[\"", "MR"],
              StyleBox["dir", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["set your current working directory "]},
          {Cell[TextData[{
              StyleBox["FileNames[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["list the files in your current working directory "]},
          {Cell[TextData[{
              StyleBox["FileNames[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["list the files whose names match a certain form "]},
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["read in a file with the specified name "]},
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              " "
            }]], Cell[
            "read in a file corresponding to the specified context "]},
          {Cell[TextData[{
              StyleBox["CopyFile[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "copy ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["file",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DeleteFile[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["delete a file "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.2"],

Cell["Functions for finding and manipulating files. ", "Caption",
  CellTags->"S1.11.2"],

Cell["\<\
This is the current working directory. The form it has differs from \
one computer system to another. \
\>", "MathCaption",
  CellTags->{"S1.11.2", "2.4"}],

Cell[CellGroupData[{

Cell["Directory[ ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.2"],

Cell["/users/sw", "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.11.2"]
}, Open  ]],

Cell["This resets the current working directory. ", "MathCaption",
  CellTags->{"S1.11.2", "2.5"}],

Cell[CellGroupData[{

Cell["SetDirectory[\"Examples\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.2"],

Cell["/users/sw/Examples", "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.11.2"]
}, Open  ]],

Cell[TextData[{
  "This gives a list of all files in your current working directory whose \
names match the form ",
  StyleBox["Test*.m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.2", "2.6"}],

Cell[CellGroupData[{

Cell["FileNames[\"Test*.m\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.2"],

Cell["{Test1.m, Test2.m, TestFinal.m}", "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.11.2"]
}, Open  ]],

Cell[TextData[{
  "Although you usually want to create files only in your current working \
directory, you often need to read in files from other directories. As a \
result, when you ask ",
  StyleBox["Mathematica", "TI"],
  " to read in a file with a particular name, ",
  StyleBox["Mathematica", "TI"],
  " automatically searches a list of directories (specified by the value of \
the search path variable ",
  StyleBox["$Path", "MR"],
  ") to try and find a file with that name. "
}], "Text",
  CellTags->{"S1.11.2", "2.7"}],

Cell[TextData[{
  "One issue in handling files in ",
  StyleBox["Mathematica", "TI"],
  " is that the form of file and directory names varies between computer \
systems. This means for example that names of files which contain standard ",
  StyleBox["Mathematica", "TI"],
  " packages may be quite different on different systems. Through a sequence \
of conventions, it is however possible to read in a standard ",
  StyleBox["Mathematica", "TI"],
  " package with the same command on all systems. The way this works is that \
each package defines a so\[Hyphen]called ",
  StyleBox["Mathematica", "TI"],
  " context, of the form ",
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  ". On each system, all files are named in correspondence with the contexts \
they define. Then when you use the command ",
  StyleBox["<<", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  StyleBox["name", "TI"],
  StyleBox["`", "MR"],
  " ",
  StyleBox["Mathematica", "TI"],
  " automatically translates the context name into the file name appropriate \
for your particular computer system.  "
}], "Text",
  CellTags->{"S1.11.2", "2.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FindList[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
give a list of all lines in a file that contain the \
specified text \
\>"]},
          {Cell[TextData[{
              StyleBox["FindList[FileNames[", "MR"],
              " ",
              StyleBox["],", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["search in all files in your current directory "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.2"],

Cell["Searching for text in files. ", "Caption",
  CellTags->"S1.11.2"],

Cell[TextData[{
  "This searches for all lines in the file ",
  StyleBox["BookIndex", "MR"],
  " containing ",
  StyleBox["diagrams", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.2", "2.9"}],

Cell[CellGroupData[{

Cell["FindList[\"BookIndex\", \"diagrams\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.11.2"],

Cell[BoxData[
    \({"Ferrers diagrams: DiscreteMath`Combinatorica`", 
      "Hasse diagrams: DiscreteMath`Combinatorica`"}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.11.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.3 Importing and Exporting Data", "Subsection",
  CellTags->{"S1.11.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"Table\"]", "MR"],
              " "
            }]], Cell["import a table of data from a file "]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"Table\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "export ",
              StyleBox["list", "TI"],
              " to a file as a table of data "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.3"],

Cell["Importing and exporting tabular data. ", "Caption",
  CellTags->"S1.11.3"],

Cell[TextData[{
  "This exports an array of numbers to the file ",
  StyleBox["out.dat", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.3", "3.2"}],

Cell[CellGroupData[{

Cell["Export[\"out.dat\", {{5.7, 4.3}, {-1.2, 7.8}}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.3"],

Cell[BoxData[
    \("out.dat"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell[TextData[{
  "Here are the contents of the file ",
  StyleBox["out.dat", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.3", "3.3"}],

Cell[CellGroupData[{

Cell["!!out.dat", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.3"],

Cell["\<\
5.7   4.299999999999999
-1.2   7.799999999999999\
\>", "Print",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell[TextData[{
  "This imports the contents of ",
  StyleBox["out.dat", "MR"],
  " as a table of data. "
}], "MathCaption",
  CellTags->{"S1.11.3", "3.4"}],

Cell[CellGroupData[{

Cell["Import[\"out.dat\", \"Table\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.3"],

Cell[BoxData[
    \({{5.7`, 4.299999999999999`}, {\(-1.2`\), 
        7.799999999999999`}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Import[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["\"Table\"]", "MR"],
  " will handle many kinds of tabular data, automatically deducing the \
details of the format whenever possible. ",
  StyleBox["Export[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"Table\"]", "MR"],
  " writes out data separated by spaces, with numbers given in C or Fortran\
\[Hyphen]like form, as in ",
  StyleBox["2.3E5", "MR"],
  " and so on. "
}], "Text",
  CellTags->{"S1.11.3", "3.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox[".", "MR"],
              StyleBox["ext", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "import data assuming a format deduced from the file name "]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox[".", "MR"],
              StyleBox["ext", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["export data in a format deduced from the file name "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.3"],

Cell["Importing and exporting general data. ", "Caption",
  CellTags->"S1.11.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["table formats "], Cell[TextData[{
              StyleBox["\"CSV\"", "MR"],
              ", ",
              StyleBox["\"TSV\"", "MR"],
              ", ",
              StyleBox["\"XLS\"", "MR"],
              " "
            }]]},
          {Cell["matrix formats "], Cell[TextData[{
              StyleBox["\"HarwellBoeing\"", "MR"],
              ", ",
              StyleBox["\"MAT\"", "MR"],
              ", ",
              StyleBox["\"MTX\"", "MR"],
              " "
            }]]},
          {Cell["specialized data formats "], Cell[TextData[{
              StyleBox["\"DIF\"", "MR"],
              ", ",
              StyleBox["\"FITS\"", "MR"],
              ", ",
              StyleBox["\"HDF5\"", "MR"],
              ", ",
              StyleBox["\"MPS\"", "MR"],
              ", ",
              StyleBox["\"SDTS\"", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.3"],

Cell["Some common formats for tabular data. ", "Caption",
  CellTags->"S1.11.3"],

Cell[TextData[{
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " can handle not only tabular data, but also data corresponding to \
graphics, sounds, expressions and even whole documents. ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " can often deduce the appropriate format for data simply by looking at the \
extension of the file name for the file in which the data is being stored. \
Sections ",
  ButtonBox["2.10.19",
    ButtonData:>{"2.10.19", "19.1"},
    ButtonStyle->"MainBookLink"],
  " and ",
  ButtonBox["2.12.7",
    ButtonData:>{"2.12.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  " discuss in more detail how ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " work. Note that you can also use ",
  StyleBox["Import", "MR"],
  " and ",
  StyleBox["Export", "MR"],
  " to manipulate raw files of binary data. "
}], "Text",
  CellTags->{"S1.11.3", "3.6"}],

Cell["This imports a graphic in JPEG format. ", "MathCaption",
  CellTags->{"S1.11.3", "3.7"}],

Cell[CellGroupData[{

Cell["Import[\"turtle.jpg\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.11.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell["This displays the graphic. ", "MathCaption",
  CellTags->{"S1.11.3", "3.8"}],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.11.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .59296 
%%ImageSize: 200 119 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-7.37257e-18 0.00502513 -0.00502513 0.00502513 [
[ 0 0 0 0 ]
[ 1 .59296 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .59296 L
0 .59296 L
closepath
clip
newpath
% Start of gray image
p
0 -0.00503 translate
1.00503 .59799 scale
200 string
200 119 8 [200 0 0 119 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
7575767573727272727172737576787A7D7D7D7D7E808283868788898B8D8E8E8F90908E
8C8B898889898887868685848382828283838486898A8C8D8E8E90929393949597989A9C
9C9D9FA1A2A3A5A6A9ABAEB1B4B6B7B8BABBBBBBBCBDBEBFC1C4C6C5C5C6C7C7C7C7C6C6
C5C4C1C0C0C0C0C0C2C5C6C7C8C7C8C9C5C9CAC8C9CACAC8C7C7C8C8C8CACCCDCDCDCDCE
CDCDCFD1D1CFCDCDCDCDCECECDCBCBCBCCCCCCCCCBCAC8C7C6C5C4C4C4C4C4C4C2C1C0BE
BCBAB9B9B6B3B0AFADAAA8A8A6A6A6A6A6A5A4A4
737374737270707071707172747678797D7D7D7D7E7F8283868788898A8C8E8E8F90908E
8C8A88878889888785858483828181828283838488898B8D8E8E90939294959798999B9C
9D9E9FA0A2A3A4A6A8AAADB0B3B5B6B7B9BABABBBBBCBDBEC0C3C5C6C7C8C8C7C7C6C5C5
C4C3C1BFBFBFBFBFC1C4C6C7C7C6C8C8C4CAC8C9CACACAC8C6C7C8C8C9CBCDCFCFCFCFD0
CECFD0D1D1CFCECECECFCFCFCECCCBCBCBCBCBCCCCCBC9C8C6C5C4C4C4C4C4C4C2C1C0BE
BCBAB9B9B6B4B1B0AEABA9A8A6A5A5A6A6A5A4A4
7071706F6E6D6D6D6F6E6F71737576787C7C7D7D7E80828385868687898C8D8E8F908F8D
8B8988878787878684838281818080818282828386878A8C8E8F919292949698999A9B9B
9D9E9FA0A1A2A4A5A7A8ACAFB2B4B6B6B6B7B9BABBBBBCBDBFC2C4C6C8CACAC8C6C5C4C3
C2C1C0BFBEBEBEBEBFC1C4C6C7C7C5C5C7C7C5CACACACAC8C7C7C7C8CACCCECFD0D0D1D1
D0D0D0D1D1D0CFCFD0CFCFCFCFCDCCCBCACBCCCCCDCCCBCAC7C6C5C4C4C4C4C4C1C1C0BE
BBB9B9B9B7B5B3B1AFADAAA8A5A5A5A6A7A6A5A4
6E6D6C6B6A6A6A6B6C6C6E70727476777A7B7D7E7F81828383848587898B8D8E8F8F8E8C
8A898887868686858483828080808081818182828486898C8E8F9092919396989898999A
9C9D9E9FA0A1A3A4A6A7ABAFB2B4B5B6B4B6B8B9BBBCBDBDBFC2C4C6C8CACAC8C7C6C4C2
C1C0C0BFBDBDBCBCBDBFC2C4C7C5C4C4C7C5C8C7C8C9CACAC9C8C8C9CACBCDCECFCFD1D2
D2D2D1D1D0D0D0D0D0CECDCECECECCCBCBCBCDCECECDCBCAC8C7C6C5C4C4C4C4C1C1C1BF
BCBAB9B9B8B7B4B2B0AEABA9A6A5A6A7A7A6A5A4
6B6A6967676768686A6B6D6F71737577797A7C7E8081828383848587898C8D8E8D8E8D8B
8989888786868686848382807E7E7E7F808081818384878B8D8E90919294969797979899
9B9C9D9E9FA0A1A2A5A7ABAEB1B3B4B5B4B5B8BABBBDBEBFC0C2C4C4C6C8C8C7C7C6C5C3
C1C1C0C0BDBCBBBBBBBCBEC0C2BFC5C6C4C8CAC6C7C8C9CACACACACBCACBCCCDCECFD1D3
D4D4D3D1D1D1D1D1D0CDCBCCCDCDCCCBCCCDCECECECDCBCACAC9C7C6C6C5C4C3C1C1C1C0
BDBBBABAB8B7B5B2B1AFADAAA7A7A7A8A8A6A5A4
6968666565656666686A6C6F71727577797A7C7E7F818283838486888A8C8D8D8C8D8D8C
8A898887868787868483817F7D7D7D7D7E7F7F80838486898C8E90919395969796969798
999A9C9D9E9FA0A1A4A6AAADAFB1B2B3B5B6B8BABCBDBFC0C0C2C3C2C3C5C6C6C7C6C5C3
C2C1C0C0BDBBBABABABABBBDBEBEC3C6C5C9B9C8C6C7C8CACAC9CACBCACBCCCCCDCFD1D3
D5D6D5D3D2D2D2D1D0CDCCCCCCCCCCCDCDCDCDCECECDCCCBCBCAC9C8C7C5C4C3C1C1C1C1
BFBDBBBAB9B8B6B3B1B0AEACA9A8A8A9A8A6A5A4
686766646464656567696D6F71727578797A7C7D7F80818283848688898B8C8C8B8C8D8C
8B8A8887868686858482807E7D7C7C7D7E7F8081848486888B8D90929395969594949597
98999B9D9E9FA0A0A2A5A9ACADAEAFB0B5B6B8BABBBDBFC0C0C1C1C1C2C4C5C6C6C6C5C4
C2C0BFBFBEBBB9B9BAB9BABBBEC1C0C3C8C49EC6C6C6C7C8C8C7C8CACACACACBCBCDD1D3
D6D6D6D4D3D3D2D1D0CFCDCCCCCBCDCECDCDCDCDCECECECDCCCBCAC9C7C6C4C2C1C1C1C1
C0BEBCBBBABAB7B4B2B1AFADAAA9A9A9A8A6A4A4
656564636261626467696D6E6F70737477787A7C7E80818283858688898B8B8B8C8C8B8A
8B8B89878686858483817F7D7D7C7C7D7E7F80828486888A8D8F91929495959493949698
9898999B9C9E9F9FA1A3A6A9ACAFB0B1B3B6B9BBBBBBBDBFC0C1C1C2C2C3C4C5C5C4C3C2
C2C1BFBDBCB9B8B9BABABABABBBEC1C3C7C6B7C5C6C7C4C9C8BBC7C9C7CBC8CCCCCECDD3
D5D5D5D4D3D3D2D1D1D0CFCDCDCECECDCDCDCECECECECECECDCCCBCAC8C7C5C4C3C1C0C0
C0BFBEBCBBB9B7B5B3B1B0AFADACAAA8A6A5A4A3
6564636261616264686A6C6D6E6F70727475777A7C7F808182848687888A8B8B8B8B8A89
898A89878786848484827F7D7D7C7C7D7F7F81828788898C8E9192939494949493949596
9898999A9A9C9D9EA1A3A6A9ACAFB1B2B3B6B9BABABABCBEC0C0C0C1C1C2C2C2C3C2C2C1
C1C0BEBCBBB9B8BABBBCBCBDC0BDC3C5C5C4AFB5C5C8C9C5B6CAC4C7C7C5C9C5C8CAD4D0
D2D3D4D3D2D1D1D0D1D1D0CFCFCFCFCECDCECFCFCFCFCFD0CECDCCCBCAC8C6C5C4C1C0C0
BFBFBEBCBAB9B7B5B3B2B0B0AEADABA9A7A4A2A0
6463616060616365696A6B6C6C6D6E6E6F7174777A7D7F7F82848687898A8B8C8B8B8A88
88898988888684848483807D7D7C7D7E8081828387888A8C8F9193949494949494949595
9797989898999A9C9FA2A5A9ABAEB1B2B4B6B8B9B9B9BBBCBEBFC0C1C2C1C1C1C0BFC0C0
C0BEBCBAB9B8B8BABCBDBEBFC0B6B9C6C3B15861569D493446CAC4C3C6C28482C9CECBD1
D0D2D2D2D1D1D1D0D1D1D1D1D1D0CFCDCCCDCECFD0D0D0D0CECDCCCCCBCAC7C5C4C1BFBF
BDBEBEBCBAB9B7B5B4B3B1B0AFADABA9A7A5A2A0
636260616263646668696A6B6B6C6C6C6C6E7175787B7D7E82848687898A8C8D8C8C8B89
8888898A888785858583817E7D7D7E7F808182838687898B8E9194959695949494949494
959697979798999A9DA0A4A7AAACAFB2B3B4B6B7B8B8BABBBBBDBFC1C1C1BFBEBCBCBDBE
BEBDBAB9B7B7B8BABCBEBFC0C0C19C968DB2513D4460484667C6C8C8C173A5A6CCCDCACC
CFD0D1D1D1D1D1D1D1D2D2D2D1D0CECBCBCCCECFD0D1D1D1CECDCCCCCCCBC8C5C4C1C0BF
BEBEBEBCBAB8B7B6B5B4B2B1B0AEABAAA8A7A4A2
63616162646566676768686A6A6B6A6A6B6D707376797B7C8082848687898B8C8D8D8B89
8788898988888786848381807E7E7E80808182838687898C8F9294969896959494949493
949596979797999A9D9FA3A6A8ABAEB0B2B3B5B6B6B7B8B9B8BABDBFBFBEBBBAB8B9BABB
BCBBB9B8B7B8B9BABCBEBFC0C1B18258525437824F6162354A8D7A444F94CBC7C7CAC9D0
CDCFD0CFCFD0D1D1D2D3D3D3D2D0CDCBCBCCCDCFD0D1D1D1CECECDCDCDCBC8C5C3C1C1C0
BFBFBEBCBAB9B8B7B6B5B3B1B0AEABA9A9A7A5A4
636262646566666767676768686868686A6C6F717476797A7E80838486888B8C8C8C8B89
87878888888888868583828180808080818181828687898B8E9193959897959494949393
939395959698999B9DA0A3A5A7A9ACAEB1B2B4B5B6B7B7B7B8B9BBBCBCBAB8B6B5B6B7B8
B9B9B8B7B7B9BBBBBCBEC0C0C0A7525B42544B883958416260472B65AE6AC5C8C8CAC6CA
CCCECFCECECFD1D2D2D3D4D4D3D1CECBCCCCCDCFD0D1D2D2D0CFCFCECDCBC8C5C2C1C1C2
C0C0BFBDBBBAB9B8B8B6B4B2B0AEACAAA9A8A6A5
63636365666666666666666666666667696A6D6F717376787B7E818384878A8B8B8B8A89
8888888888888786858483838382818181818182858587898C8F92949796959594949393
9393939495979A9B9EA0A2A4A6A8A9ABAEAFB1B4B5B7B7B7B8B8B9B9B8B7B5B4B3B3B4B5
B6B6B7B7B7B9BBBCBCBEC0C0C2C11F48624F385D5E54357A3450346E4F4EC9C5CAA6CCC9
CCCDCECDCCCED0D2D2D3D3D3D2D1CFCCCCCCCCCECFD1D1D1D1D0D0CFCDCAC7C5C1C0C1C2
C1C1C0BEBCBBBABAB9B8B5B3B0AFADABAAA9A7A6
6464646565656565656565646465666767696B6D6F717577797C7F818285888A8A8A8A89
8989888888878686868684838584838281818182838486888C8F92949595959594949392
9393929294979A9C9E9FA1A3A4A6A7A8AAABAEB1B4B5B6B6B6B6B6B6B5B4B4B3B1B1B2B3
B4B5B6B6B6B9BBBBBCBEBFBFC0B93E485141537B876D4C4E3F533D7B7D6FB3AFA89AC4C9
CBCCCCCBCACCCFD1D1D2D2D2D2D1CFCDCCCBCCCDCED0D0D0D1D1D0CECCC9C6C4C1C0C1C2
C1C1C1BFBDBCBBBBBBB9B6B3B0AFAEADABAAA9A8
65646465666666666563636762626664656768686D707178787E7B828283878689888888
8888888888878786858484848484838281818283858687898B8E9294939494949492908E
8F8F90939597989A9C9EA0A2A4A5A5A6A6A9ACAFB1B3B4B6B5B5B5B5B4B4B3B3B2B2B2B2
B4B5B6B5B8B9BABCBCBDBDBEC0B65150515776846A505F334D4F54699C688ECEB1B1C7C8
CBCACAC9CACBCED0D0D1D2D2D1D0CECDCCCBCBCDCFD0D0D0D0D0CFCECCC9C7C5C2C2C1C1
C2C2C1C1BFBEBCBBBBBAB6B3B1B0AEAEAEADAAA8
626263656666666668666661676762626464676D6D6F7272777A7E7C8083818787878686
86878888888887868584848484848483838384868586888A8D9092949393939392908E8C
8C8D8F92949597989B9C9FA1A2A3A3A4A4A7AAADAFB0B2B3B4B4B4B4B4B3B3B3B2B3B4B4
B5B6B7B6B7B8B9BABBBCBCBCBCA5564755688292383D534F543B5B706E55AEA3B6C5C6C7
C8C8C8C8C8CACCCECECFD0D1D0CFCDCCCBCBCBCCCECFCFCFCECECDCCCAC8C6C5C3C2C2C1
C1C1C1C1C1BFBDBCBBB9B6B3B2B0AFAFAFAEABA9
61616365666565666267636A656060626167646A6D71717379787D7C8382808384848484
85868788888888878584838383848483838385868687898C8F91929292929292918F8C8B
8A8B8D9093949595989A9D9FA0A1A1A1A3A5A7AAACAEAFB0B2B2B3B3B2B2B2B3B3B5B5B5
B4B4B5B5B5B6B7B8BABABABABABC2D37527CA46F44623F486282445B4996C9C6C1C7C6C6
C7C7C6C6C7C8CACCCCCDCECFCFCECCCBCBCBCCCCCDCDCDCDCCCCCBCAC9C8C7C6C4C3C2C1
C1C1C1C1C1C0BEBBB9B7B6B5B3B2B1B1B1AFACAA
61626364646464646565696367696461656168696E6F6E7374777A78797B808081818283
848587888889898886848382828384848484858687888A8D9091919091919191908E8C8B
89898C8F9192939496989B9D9F9F9F9FA2A3A5A8ABADAEAFB0B1B2B1B0B0B1B2B3B4B6B5
B4B4B4B4B5B5B6B7B9BABBBABABF2B4F3152B976253E4C415A8A70635BC6C0C2C1C5C2C4
C6C6C6C6C6C7C9CACBCCCDCDCDCDCCCBCBCCCCCCCCCCCBCBCACAC9C8C8C8C7C7C4C3C2C1
C1C1C1C1C1C0BEBBB9B7B6B6B5B4B3B2B2B0ADAB
606061616161626364686367656463625F67686D686F74707972777B7A7E797D7E7F8183
84858788888989888785838282838586868687888A8A8C8D8F908F8F8F8F8F8F8F8E8C8B
89898A8D8F90929395979A9C9D9E9F9F9FA1A3A6A9ABADAEB0B0B1B0AFAFB0B1B2B3B5B5
B4B4B5B5B5B5B5B6B7B9BABABEBA233C463073A6204A472B70924028B9C1BFC4C7C3C7C6
C4C5C5C6C7C7C9C9CBCACACACBCBCBCBCBCBCCCBCBCACACAC7C7C6C6C7C7C6C6C3C2C1C0
C1C1C2C2C1C0BFBDBAB8B8B9B7B6B5B4B3B1AEAC
5F5F5E5F5F60626365626870646673787A7478706F72707A7B9076757B757B7B7B7D8082
8485868788888988878684838183858788898A8A8C8C8D8E8F8F8F8F8E8E8E8E8E8E8C8B
89898A8C8D8F91929596999B9C9D9E9E9EA0A2A5A8AAACAEAFAFB0AFAFAFB0B0B2B2B3B2
B2B2B2B1B3B3B3B4B5B6B7B7B7BF06535C4E5473463E4A4B67A14F6FBDC2C0BFC2C4C5C3
C2C3C4C5C6C7C8C8C9C8C8C7C7C8C9CACACACACACAC9C8C7C6C6C6C6C6C6C6C5C2C1C0C0
C1C1C2C2C1C1C0BFBDBBBBBBB9B8B6B5B4B3B1AF
5E5D5C5D5E6061636464807B7E756D73368E51707878797D9F79767772787778797C7E81
82848587888888888887858382838487898B8C8C8E8E8F8F909090908E8E8E8E8F8E8D8C
8B8B8B8C8E8F9192959698999A9B9C9D9D9FA1A4A6A9ABADAEAEAEAEAEAFB0B0B1B1B0B0
B1B2B1B0B0B1B2B3B4B5B6B7B7BD325E5655B44B41644A375DB3578ABEBDC2C1C0C3C2C3
C1C2C4C5C5C6C6C7C7C6C5C5C5C6C7C8C8C8C8C8C8C8C6C5C5C5C5C6C6C6C5C5C2C1C1C0
C1C1C2C2C2C1C1C0BFBEBCBBBAB9B7B6B5B5B4B3
5C5B5A5B5D5E60617B803546494C7ACB6D3D293A74A2817E778E927E79767677797A7D7F
81828586888887888888868484848486898B8C8D8E8F9091919191928F8F8F8F908F8E8D
8D8C8C8E8F90919395969798999A9B9B9C9EA0A2A4A6A9ABAEADADAEAEAFB0B1AFAFAFB0
B3B6B7B6AFB1B3B5B7B7B8B9B4B362466A70FD5D3B5B484498A14CBEC0BDBEC1BFC3BFC2
C2C3C4C5C5C5C5C5C5C5C4C4C4C5C6C6C7C6C6C6C7C6C5C3C4C4C4C5C5C5C4C3C2C2C1C1
C1C1C1C1C2C1C0C0C0BFBCBBBAB9B7B6B6B6B6B5
5B5B5A5B787D676E756C53394A4C5186A13D3A255DB8A55C68B3C57E7676737876797C7F
808284878988888888888787868586898B8C8D8C8D8F919392918F8E908F8F8E8F908E8E
8E8E8A90928F939494999398999799999CA0A19EA4A7A8A9AAADABADB0AFADB0AEADB4B1
B0BDE4CDB8B2A59DB1DBA6BAB8704046496A8D464D3F393D8EBFB7C0C0BDBFBAC2C1C0C3
C1C2C4C4C4C3C2C2C2C3C3C2C1C1C2C3C4C4C5C5C5C5C4C3C2C2C3C4C4C4C3C2C2C1C1C2
C2C2C1C1C1C2C1C0BFBFBEBDBBB8B7B6B5B6B6B3
595C5B5F641A325491B15E563A3F4663864F402C5597BE915198BA847375747577797C7E
808184858888888889888786878687898B8C8C8D8E8F91929191908F92908F908F928C92
918D928E9295929497979799989A99999D98A0A7A4A4AAAAA9A7AFAEB1B1AEAFAEAEACB5
36D1E5FAD3CEDDE4CCCDC0AEC26A4A393E54A251324246467B8AB6BDB9C0B9C0BDC0BFBF
C1C1C2C2C2C1C1C1C1C1C1C0BFBFC0C2C2C2C2C2C2C2C2C2C2C1C1C2C2C2C1C1C1C1C1C2
C3C2C1C1C1C2C2C1C0BFBEBCBAB7B6B6B4B4B3B1
5B5F5D5F5D7E425C4A58746052572D53714037352F6FA76335638B7E71777677797A7C7F
808283848686878889888786878788898B8B8C8D8F90919191919191919291918F8E948D
8D8F95929096989A9796999796999A989EA4A0A2A6A7A3A8ADB0B2B3B0B0B1B0ADAFABAF
787B9FB3A3B4CDDFDAE2D3D8D3674E535442624A38413D5F8F95A7B9BDBBBCBCBCBDC3C1
C1C1C1C0C0C0C0C1C0C0BFBEBDBDBEBFBFC0C0C0C0C1C2C2C2C2C1C1C1C1C1C1C1C1C1C2
C3C2C2C1C1C2C3C2C1C0BEBCB9B7B6B5B3B2B1AF
5C58615F5E68164967575C395D5725424E3F3E494B4C48464E237F717577717A7B7C7E7F
8182838384848687888887868787888A8B8B8D8E8F909192929292939093929494939690
929490979699979A9C9B98989A979A9D9D9CA29FA6B3A99D82201E1B1D3842557EB2B0B5
A891878B94939C86918FA8A7C7732F5078749A2F35593E279F8296C0B8BABCBDB9C2C0C1
C1C1BFBEBDBEBFC0C0C0BEBCBABABABBBDBDBEBEBFC0C1C2C3C2C1C1C2C2C2C2C2C2C2C2
C2C2C2C1C2C3C4C4C3C1BEBCB9B7B6B4B2B1B0AF
615D5C5F615F706151536360554E544B4538433B433A2C383D456E7E747778767C7D7E80
8182828282838486878786868687898A8B8C8D8F8F909192939393949595939695978C94
91959695989D9A9F9BA0A29FA7ABA3AAABACABACB17B817B76715E5A3D584C285F869B95
958D8A8674868289908E83899E9945483975AB3A363D3538A4893899B8BFBBC1BDBCBEBD
C0BFBDBCBBBBBDBEBEBDBBB9B7B6B7B8B9BABBBCBDBEBFC0C0C0C0C1C2C2C2C2C3C4C3C3
C3C3C4C3C3C4C5C5C4C2BFBDB9B7B5B3B0B0B0AF
5F5F5A5E580742505C57393E494545444942302D405867593B463E7B7373787C7C7D7E80
8181818181828385868786868687898B8C8D8E908E8F9193939495959897999998959A94
969598A4A09EA3584F4852555A584253688FA08960555E68567471737E5D47494A67A0A0
9F7589917D979799BCC49B868560514C328ABB162A413024978B4338323187C2BEBEBFBF
BEBDBCBBBABABBBCBBBAB8B6B5B5B5B5B5B6B8B9BABBBDBEBFBFC0C1C2C2C2C2C2C4C4C4
C4C5C6C5C4C5C6C5C4C2C0BEB9B6B4B2AFAFAFAE
5C605C5A5B5D701E3E4146534941323C3B3C3F494B51323A4940365484787D7B7C7D7F80
8181818181828385868787868687898C8D8E8F908F9092949596979898999F9D9E9B9B9D
9EA1A07D676561512F2D2C29283B343A616C5C473F4867541F242A304F564E7A705A6B74
7B9C8F9F988FAEB9ADA2AB98B9802E425E589A41354E4226817F66B3796D61A9BABEBCBB
BCBCBCBBBAB9B9B9B8B7B5B4B3B3B3B3B3B4B5B6B7B9BBBCBFBFC0C1C2C3C2C2C1C4C5C5
C5C6C6C5C5C6C6C5C4C3C1BFBAB6B4B2AFAFAFAD
605D5E595859596A6F7C6E5450373E35384B404C3E3E41253B51537E84887F7D7D7E8081
81818181818283858787878687888A8D8E8F8F8F919294959798999A9D9D9F9E9CA16CA2
B4A496A3927B6553715336453C4157707C5A29512742835D213C4A547186535056634E34
457F9CA88E84ACB0A0AE9E9FC36E2B442B5CBE2B1942401E727D4DABEBB267778CB4BEBC
BABABBBAB9B8B7B7B6B5B3B2B1B0B0B0B1B2B3B4B5B6B9BBBFBFC0C1C2C2C2C2C1C4C6C6
C6C7C6C4C5C6C6C5C4C2C1BFBBB7B4B3B0AFAEAC
5F5F5D5A5757575654584E43674F39373A4C323838464466685C474B384B8387857C7F7E
7F81827E83848486858B848B87898A8F8C93978F9088939896959D9BA09ED4FCFFFDFFFF
EED9D999C4D2B682C5FCFDEFFEFFFFFFFFFBEFE7EAD3B2D2FEFFFEFEFFFBFFFEFFF3DEC9
6A3466805E75A49FA19A87958E413D44335FAB31473B1951953E776676D3EDA45F5AA1BE
BBB9B9BBBBB8B7B5B6B5B3B2B1B0AFAEAFAFB0B2B4B4B7BABCBDBFC0C1C1C1C2C2C3C5C6
C7C6C5C5C4C6C7C5C3C1C0C0BCB9B5B4B2AFADAD
5F5F5D5A58575756575776023757434C432E2D37435C5D4A3F3D3A3F353350628788887D
827B84858189848A89868A868B8E908C908FB9DFCDCAD0C49C9694A0A0D1C092B0945C45
57514638514B404A4E466C949FB19B928B7876656763636A87866E9AE0FBFFC5DDDCE8EA
FEF2B0B6B285A46E7A69A3AF9F303843402D584A3B3C1F476137B1B19487A6CFE8923818
BDBCBBB1B7B7B7B9B5B4B3B2B1B0AFAFADADAEB0B1B2B4B7BABCBEBFBFC0C0C1C2C3C5C6
C7C6C6C5C5C5C5C4C3C2C1BFBFBBB8B6B3B0ADAD
605F5D5A585857565853585F687C4A4339314B4642384A2E32415A554E7D5F4C2D658987
8B89818286868D8B8F948F938F8EE4FEEBE09983605E564F5F38493A2775C3ACC4FFF1C7
B7A3563B344C5121373F3D74AFBC909A86A9A266534F514F2F1F225A498D875A57616297
4A49534F786DAD4E94FFD36159152C59686479721C282E3D2660AFA3AB959BA0CFFEB84E
7C18BBB8B9B6B3B4B5B4B3B2B1AFAFAEADADADAEAFB0B3B5B8BABCBDBEBEBFC0C1C2C4C6
C7C7C6C5C5C5C4C4C4C4C3C1C0BEBBB8B4B0AEAD
5F5E5B595857565654575755586778783630284F4D2E404B42623B4E4E4A503A515A5554
938A898D8F8D8DB0BED6B4C9E4E8D3B7747B75A46E444C4C693E5B6A5F469A899C938D86
869547373E443F424F4A456296BE82656C757F7545538183514985C2B499B4DD915C788F
396158375B5227463387F2FDD982352E1436BE7E182D2E474AB0C896A19B7F968C88C9EE
C25066BAB2B4B5B4B4B4B3B2B0AEAEADADADADADADAEB1B3B5B7BABBBCBDBEBFC0C1C3C5
C6C6C6C5C4C4C3C3C4C4C4C2C0BFBCB9B5B1AEAD
5E5C5A5857565555555A5558595B5D164A49573F30384B3B293E444F5046475B5B466948
2952402B5AC5D7D0CE59759088A2C9C2C0ACA08683482E686B3D4E46654D6F9296C1B98C
85464145444A3A423952A3CBF3FFFDECCEC1A6B4967C7B6F6D88E7BEB88FA1C7CAAD8677
6C646B6153442B2E4B507B7094FEFBE171077E5E23363E3B416E689776849483A5B4C2D9
E1DD88A712B6B7B4B3B3B2B1AFADACABABACABABABACAFB1B3B5B8BABBBCBEBFC0C1C3C4
C5C6C5C5C3C3C3C2C2C3C3C2C0BFBDBAB6B3B0AE
5C5B5958565555555556535C5C5F626B303B4936353D32273545394E4849493F5A543854
135F93B49AAEB5AB84493E4C7A90A591929FAA9C8477595F5D34504B5069BDFDFFFFD2DB
F5F0D9584F4B3B37418397C791777D8C7D8BB3D0E49FA878F3FFC9B49EABA9A49AC683A4
70588B827162583848849F499E5DCFFFFFFFB92A042B3C3294956C788B67628D8788828F
9BB2B0CC8B6BBCB0B2B2B0B0AFADACAAAAABABAAAAABADAFB0B3B6B9BBBCBEBFC0C1C2C3
C4C4C4C4C4C5C5C3C2C2C2C2C1C1BFBBB8B5B2AF
5B5A5857565454555856585A5A625F656D133D42324C374932315B2B4B555B636A3C3443
C7FDB9986744363D3B404946495696CCC999726A7780875A4223332E4A7C8DAD848C6E5D
4FA6C238415E3B3C559593C8A88E748AC89D7A949AB7F9C6E2FDC0A4CCEADEFFFFFA8F7B
A1836C52888A6A7B6D7E9585AC46C9FEB1B5FFFDAA1D2356C0A5C8C5B18F8B5E3C4C6B72
72758888A39557BAB1B0AFAFAFAEACAAAAABABAAAAABADAEAFB1B5B8BABCBEC0C1C1C1C2
C2C2C2C2C4C4C4C3C2C2C2C2C1C0BFBCBAB8B4B1
5B595857565454565558585D6060656668740B3F4D353A424434393832413F48323A6AFD
C73D34504E66703E2F5047475D758E836B7A958697585C6C3B6253384E7D766274B0D6C2
AE82739A664354988CB0A89FC3F8F7C6D9BE9ED8B799BAB1A2FEFFFDAC946EB7F9FAC894
748C904E7F95B3AA926E7EC37B7AFB914CD9B89FD2CA660376D1B4899395B0986F3F575E
6973787A787C9BA3B0AFAEAEAFAFADABA9ABABAAAAABADADAEB0B4B7BABCBEC0C1C1C1C1
C1C1C1C2C2C2C2C2C2C2C1C1BFBFBEBCBAB9B6B3
5C5958585856555658595B5E60616466666F761670363D4E41322B502F280B4A75B6E7F1
954F72653C51582F2C504142505D5852A9B08E5C477F717848CCF9D6E2E0B9CCE3DFA39C
9EC8A6949C8558EAFFFFF1E2DA8C8F5C5D7E8D7B95F3FEC6A0FFEB8978697CC7FF9F98CC
EFE79E7FA0D19977728CAB9893D7BA4EB49249615357FF85005D8D835E5A6D9CA49E594F
67665F7978828EA07CB6ACACADABB1A9AAA9A9AAAAAAAAABAEB0B3B7BABCBEC0C1C1C1C0
C0C0C1C1C2C2C2C3C3C2C0BFC0BFBDBCBBBAB7B4
5C5A595A5A5958595A5A5B5E60616365696A696F1C77434438374A452176C68B78927373
E2D05450655248652F1B3662475E565FB18A5D898D5792A68464C7C18796CDAB8B7E6457
3863A0B5EAE255EDE16A7683606C7C8EA5FFFDE4AB90D9D1E1FCF8FABEE9FBFFFEFDEDF1
FFAAACB9FD69A499AEB0858CC6B68D837C54647A615EA4FF4E014DBB726B4A67AB878A7F
5A778691A48F959B873CAEADACA9A7AEAAA9A9A9A9A9AAABAEB0B3B7B9BBBDBFC0C0C0C0
C0C0C1C2C2C2C1C1C1C1C0C0C1C0BEBDBCBAB7B4
5C5B5B5C5C5B5A5A5B5B5C5E6061636468686F6E6E61613F324B4331BDFDEC97734F7A61
5DBDA5773F4F63584D515360554A4580976957CAD96858E19A809D70849F724C3E78C6D1
FEA9475A6EE9526B58CA9C9ABCD7FFFEFEFEF18FF9A2B4C7C4CCE5FFF7F6CCBDCFC7BBF4
807E7B7A9064A5BBBC9792BCD082958A5E6B65697F846439C5FD700F6593677383767577
50547C888B8786747AADB0ABA9ABAEA8AAA9A9A9A9A9AAABAEB0B3B6B9BABDBFBFC0C1C1
C0C1C2C4C4C3C2C1C1C1C1C0BFBFBEBDBBB9B7B5
5E5D5D5E5E5C5B5B5C5B5C5F616263636569696F6D717D2E48401846FF680F4889785EAE
8F437EB25550696C52636A4641343BAF5E6292DAFF876B8DBD7A7A82737077ABF9FFFFFF
EF6266C380BF726A98A14B79DCC2A3815030305B89A0E991726A9773777E66637A95AF9E
86C8CD96707095B1E5FFFFEA8A6A63764E556A75696559747BA2FF850C7E77877B8A7D74
6D66456C748574829B88B3A9AFABA9A9AAA9A9A9A9AAABADAEB0B3B6B9BABDBFBFC1C3C3
C2C2C3C4C5C4C2C1C1C0C0BFBDBEBDBCBAB9B7B5
6261605F5F5E5D5C5C5C5D6062636363666A6A6B6E6F727E837273BF744530453979794E
898F6E9797415260603133343A517687426AFFFFFD9279C0C265CBE4E9F7FBDFAD916E7B
7390BDC0F6C09EE7CD5E6B8A908C616F6575938C8E5EBBE4988695AF909CA2EDFFEBD0FD
FFFEFFE7A3998F99CDFEFBEC754D837B344D836D654B5D5D336BC7B1DE0153A99EE7B060
66B2734B77899DA99F859EB1ACADADA9A9A9A9A9AAAAACADB0B2B4B7B9BBBDBFC0C2C5C5
C4C3C3C4C5C4C2C1C0BEBDBCBCBDBCBBB9B8B6B5
636261605F5F5F5E5E5E5F6263646465646D6D6C717274767880B28F4B4D5E4B2D367258
60856C75A36E534A4649626C60625B3A41B9FF7F4A3D5EC8AF51A6BE8D7237436F9486B7
A39A919C71799392AA97373F574B37596A7C7A915563B78F4B498D7274715D8CAB9AE5FC
CFD8CDC1E6F5FFB658CABF8D7E7E6D8D5C627D6A4559543759C6A564FC7E0171C5E9E1B0
7A7B817B72658297C3BDB0AAABAEA7AAA9A9A9AAABABADAEB2B4B6B8BABBBDBFC2C4C6C7
C6C5C4C4C4C3C2C0BFBDBBBABBBCBBBAB9B7B6B5
646462606060605F60616263646566676C68666E6C7173777784341C48675C7B71425245
4A8A625799BA5A57693E4C564D4358A7E1CB4345796677798D4D5056615C699E83403353
59452F426454CD49237C674A3C505D5142659B84AC736DD7C8CEFEB5E5FE72E9E5B0FF90
A8D4C09AABFFF7E5C19E596C78968A789B7D5D425A6E7A7ABDB581FF68E26B098C9B8990
9D987B535C48324DA3E8A4AFADAEABACA9AAABACADADAFB0B3B4B7B9BBBCBEC1C4C5C7C7
C7C6C5C5C3C2C1BFBDBCBAB9B8B9B9B8B8B7B6B5
66656462616261606363636465656769676A6D6D7174707680803F5951586C737B5B505C
555E4B56A4B792606C4354675B81707E66485787635C50605936424F614C5D44312C5F4F
4AA2D56CBE9DC6B07B96AF9E808AB9786B919DABC85E68D5FFCAF4B4FFF37BFEE4FED6E4
EBC6ABBFB5D2D8CDCAB0AF8E796651727F7A7F7B67ADB0B69C36BBF961A2FE4701729E46
6B7E647755415C674F6D4E89AFA9ACA8AAABADAEAFAFB0B2B3B4B6B9BBBDC0C2C5C6C7C7
C7C6C6C6C2C1BFBDBBBAB8B7B5B6B6B6B7B7B6B5
6766666564646464656565666667686A6D6A6B7071717578825049534C454B5953465772
574A683E8ED7833C428247556F5B576267676762445922426F80483A63396D4F4C9DF18E
5EFFFEBE8BACC5A4756DB9A5C0E3857989B0B87FD96D6043ED79797E89666CBE8BFDC3FF
DC81A9A0FDC7E9607F8F888A8E80685F6C667C9263626C7F9FADC77A5DEBFFFC9A029EC7
97AA957189A579625C51574FA35D60A1ADAFAEB0ADAFB3AFB4B5B4C0B9BDC0C1C1C6C6C5
C6C6C7C4C2C1BEBBBAB9B7B5B4B4B5B6B7B7B6B5
6767676767676665666666666667686A686C716F737073737D5A66506C6F3444733F5F5B
644E65426B9B593040706A5E535F654F424A391B4A525D2D436687675D6A677268B5C28B
89F4FFE37FAFA8935965C7FFFFA154CEDA69B47183787C93EEFEE6CBD3D0AAF8FEF2C5FC
ABFDFFB6F48CD6AD9D92AC88927F78785A5696816F879AAB96785E76FDFB7676AF650175
6772737C8D894F61854D51545263706D5D4BABB0B4ACAEACB2B7B4B5BCBDC1BFC1C3C4C5
C4C4C3C6C1C0BEBBBAB8B6B4B3B3B4B6B7B7B6B5
6868696A6A6A6867686867676767686A6C706E7473766F7D81B58E7879726C4449604B46
5750495238365A6F62557D6C3750473F151D494C46538E58414083A95F6C71857CAAC387
7BFEFFEF598CA09B4563FFFC976EAFF8DFC9D2957F5977A19CBC5F77AE8E697CC68DC6CC
7EFFFFFFCEA6CB7C6CABB086807A736E8E5B687D69775E4955B9D8F9FD5D6D80559D2C44
E09BACA280635041404E545A5F7F5B4A40598CBFB9B08C243A427D8C9FA9A6B9BDC2C2BC
C3C6C3C2C0BFBDBBBAB8B6B3B2B2B4B6B7B6B5B4
6A6A6A6B6C6C6B696A6969686868696A6D6A717073747C84777E8B95B0824F4D4B505635
3B2D3A6B484A606C5D4D4D472B54356374494C704961746C41614D7E635F7D88759BC685
42CEFFE08799CC7E4B67DE937F4EE190AAFFBA918155B0DD8B9B4E64D2AC7597E59CC08D
B0FFFFAC9BC3F49BB3A66761656B827C845D64BBBCA482C9FEFFC4797CADCC9360508422
C3EDDFE0D29C69523227504144385549385036B1F8EAFFCE7A627B597A5E6F7B96A4BAC2
BFC0C3BFBFBEBDBBBAB8B5B2B1B2B4B5B6B5B4B3
6C6C6C6D6E6F6E6D6B6B6A6A6A696A6B6E717575707C72566E93839361E3D364525D5467
413E24375F58518391605B3B35455964C3854B5F8464587A497D5B67904C517E7596BD92
629DFFC477C7AC643FADFF7A728AF77FBEFF939EFC80C3DFACB77D97FEB7BBBDF0B4A75E
F8FEE27EA6C4A8A8BF886A707C9273876F696182D4FEFFECAA55749CA58F8F7C57559D26
1258768A84B1CC9B3E37425D485A233757546B3E71E0899FB442408E94442F74D86F2A1C
B2C2BEBFBDBDBCBBB9B7B4B1B0B1B3B5B5B4B3B2
706F6F70717171706D6D6D6D6D6C6C6D726B6E70738238523B4FA47A6351B4AC65484B60
66302D33483F4F684D4D6D61594F765965BDB7528C9B546B49A581408D6552686DA3EDB2
60BDFFCD79C58E956FB4D76F84AFFF9DACFDB5CEFC91D98ED8BD6C8AFA8869B4E19DC279
E6FEC484A9AB9B7885776D6271697A6D6A62735C7AAEBC758B93B6BA72706C7C7C6FAAA7
1B9C997A715E6C8E97824847515554434A435743516F45303471944A332431296F7FAD94
0EA6BCC2BBBBBBB9B8B6B3B0AFB0B3B4B5B4B4B3
727272727373737370707171706F6E6E6E727372717C5B59634F5C7A8D823895AC4F5950
694F49433741693F3E5A4835464B4B75437DFBC851A88D5A5B969341695C517F8C95BDA6
6FA2FFDF77C4737852BCC68694F4FFCECBFEC2A4FF73B36AEC77377EC3817ABFFFB7BE67
F9FFA1A6969A77519E9071765B7CBF775785806A5453667B7682BE67536980847A4A6BBB
0F8CC09F8F705F6A5978876E4621505F4C41466B5B4F552C3B3B8DDA695F5F7070628EEB
640092BBB9B9B8B8B7B6B3B0AFB1B3B4B4B4B4B4
72727374747474747272737372706F6F6F706E707F844B3B5C8957568280614B949B5A6C
6F6C4B3F2849535A68777F3C44564D557B7E80E9936AB078776E9E5F61495F8790A3B4D3
6C83FDED74A6836458768C5256E7B15CC8FF99C9FC8AC48BAC515D81DB9989BCFE9EA3AD
FEFD859D77875A648A71919387C5AA7A7482605763726B6A71A46B48516B6C5C5F585368
E95313776580899D4E496B663551464D48484E716BA46C4132211478D3642B5B702D2351
A169127EB7B7B7B7B6B6B3B1B0B1B3B4B4B4B3B3
7374767676767575737474737271706F70706D767A3544524D6BB051567D603A54947B68
64644C40353F6F5E7DAFA089544C5061549C6A9DEF7697C28B5DA165686D536A8B99A7DB
9B75FFFA68E5986B6E6B515E51D9CC638BFC7FC0FFD6CF99B5A190A7D8829CC8D0B09A79
FEF38E9A88814C7C8741848BD0E67E6492857A835B6D62627895774F5A5966755C887D65
AAC1187D70517F5B5A59533A32444F403D5B375B5B4945607E685D2B4FC391473F845B18
9F71704796B6B5B7B4B9B4B4B5B2B1B2B4B4B4B4
7475767575767676747576747271706F6D6F6E6D7A494654454673863B66503C5455686D
58343C473C4072549376676F753C5160338CA33BFFB753B2BC5DA06654815551689D95C8
AA71FDFE7EB0A0A776869E7C8DCACF7E7BFF9C78EAA1E16990713DB5DE787893D2C58399
FFCA8C9A9762696E61649781D0916E5D606473676E5F5B553F54645C6195EE85475C6746
5AB03786AAA2A5645F686F313B5A5D5A4A57514B5239344D6E979F713D3FBFB0487A8F55
449A4792A39EB7B7B4B3B5B5B4B3B2B3B4B4B3B4
757575747475767775767775737170706F6F6A6B7AB48479625C63596540545D56574B79
595947464C425C7A89574D5C824F325B504DC37C92F27FA8CB858090556D5C5F739CB9FF
A279DBFF60BA646F6A768A7F91FEFE9482FFD16FFFC9B4589A5961A3D869657ED09883B3
FFAA8C9D93516A60486F658C9F7D695D50536255516472685772818F8798876939194054
858730395C7E949E7A564C345B6A6B5F506A6E56623E53614778898D6295C7AE82B0CE9F
427B892D8899AAB6B8BBB2B6B4B3B3B4B3B3B3B4
747575747375767675767675727170706E6C78827C788BA8937A797A546C4E6469566554
3C46594D3C3C5C8060575D5F7B934B3E56408CBA51DFE18BA8B3A27342505D6B7C86A7C3
D54ABDFE80B8805E6C466E603BADE49583FBF76CFFA9B17A875E5F8AA08091AFDB8398AF
E99895A3635C606061756F885C6274716C808D775647646E6F687D627680744E5B676286
9D712F82475569476FA246617F94888685A1B099B1815E73AA884F51CAE1A3BDFF9EB7D2
A15A518C3863AFB3AFB4B5B4B5B4B4B4B4B3B3B3
7475757474757676767777757271706F6E696A836482648FC7CB8E6060595F4D4856533F
444D585C5E4B486B4D615997627D7B48675C56A96B8EFF7C8FD98F5B4E61758A7E5AB192
FD5794FD8D7F935150487B634BC4EA908690FDA3FFA79A758378718C916DACC0D0AC67D8
F87F899F69615E4784757F6F627CB1BE7E51737173566C573B4B687D7778919389868F80
A3B52D3F6760474E5B62667873836E70768AA5939C9E8A90BCD2A287E4838691614C6B8F
E16C155AA842ABB4B7B6B5B5B5B5B4B4B5B5B4B3
75767675757676767778777573716F6D6D6B6B794E464A6D90AAD0AD72645450453D4649
625672505654536C5E715498A4519656445050818E60F2D96B9C8C6E576B746B7A71B78C
BB6758FFE485A58F6B789A6A28BEE6987769FFC1B0E78A7F505E7FAFA66D868E99A572C0
FC7A71854E58534D798E703F6AA7B1A1473035466478623E3A548270626D746E6D829EE1
F4FB5D45705F6A495542426975676B78777678858A7F877E648B9ACB8EBF7F001A091748
A7A25C3298729CB8B2AFB4B3B5B5B5B4B5B6B5B4
77777776767677777877767472706E6C6B69808455605E75668470AFB3646A6B574B564D
5A5D6B8868513C559B7E795BBD63607E4F516E46B35876FB7A956A7D624D67616E938788
C57A5EE3FE5E9DB98E637A885186FC9B8C80D1F081B1957854557075825A9EB7A6C86CB9
FF7C98764058666991895D5B818D74997D6C51595A4760633C5674785F557FA4C9C8A58F
5763C14654555D4A5259495355626A6971717F89826D706D515C4D5F9AE7912C77582466
B48BBA5E193E96B0B3B6B2B5B4B5B6B5B5B6B6B5
77787776757677777776757372706E6B6A6A667E4E505E827F827C5997B570566353684B
5A6B718682504A4789745C658FB5568D6440776F8D974BF4A47C616C74535260758986B4
C7C9838FFF95A28C7F59766A5665FFDC948C97FF9493978A5C5C5E6574668E91AED259D1
F65D9071626240626C3F78B46A6992888C80634E5C6C7A79626E978AA5BEA49D8194A396
8A71C3744657404A555B3547454C55596471746A6D4A314B58606E6D57A39A866D6A5563
B4733A37476E36AFB4B2B4B3B3B5B7B6B5B6B7B6
797877767576767777767572716F6C6A696678767C6D454192766E8F6B92607D45437165
3A5E80695C5456447EC16D7D6DBB936E8448588189A8576BD4847E6B71655C5C5F8490BF
96F88590FFB6B1A0566070625648C2FEF38381FFBFA388744A4C6B75776B5F86BABB37D0
F37A8D585442556145699285729CDAC3794C5E5167947C6D5B6D6EDEC495A99893898463
876297AB43734E4F4E503E35344B585535512A28393C383B5F434758554392847B5F799B
6BB8A32B466731B2B1B6B7B3B4B6B7B7B7B7B6B6
7978777676767676777573706F6D6A6866657C7F7D9E8C756361545D6E6F5F886A555C3F
475C7A867848575158D4955A5F6CA25D786A4C574EB88151D3BA636F5F6E635B619692B1
A6DAA673E8F27DA559514664664F7FF1FA986AE9DDAA8D5C734F465C5F76ACB2B3DA49C7
F7589D514C455C57518A784B9BDDD99070505768428F725F5674C1AB607465353031272B
56669EAC2A715A474D4841333546586D623E43425846495C5B45464B43515077A098674F
2C3B6356669413B3B9B4B5B8B6B7B8B8B8B8B7B6
7B797877777675757573706E6C6B6968646C667E6A917B9E9E885D566060576690575844
545A61A9A164576542AFD35C8C57A1A55F895B4C596BB75171FA9C6F635A5562617DA289
B287C057C7FD42A28D45425C504F71A2E7CB6DE3D8859A5A765382635EAADD8488F56397
FF99904D4B4348486D7E4C7ED0DBAC836D4E5259548D6C5E5A72A75242331D314E5E5179
6C486EAC3C1F64554A4B342E373B313E50333757414648453A414C516A5B534540534848
64695A9682A4B3B9B4B8B8B9B8B9BAB9B9B8B7B7
7D7B79787877767473716E6C6B6A68676A676667867B969D8D9372506150606A87866F48
42318D94C67653685167C2AE828275CF6D6B70505156AAA452AFA6694C6257474A819C5D
A992DB597CFF6F8A775A565B504B72B0F1FE6791FF91C43E69557F6C68BFB7A5A9E5979D
FEC06F4B45464B5E755C54A1C4B47C85593B676F7C99815C816F5F6678766E99A5B6A670
665B41A7D53613355A5343281C293C2D373F5449484F3B3837414C41485D5D5867594233
3382A5B1B6B7B4B8B6B7BDB7B9BABABAB9B8B7B6
807E7B7979787675716F6C6B6A68666667626768706983837E98AC6048505E56509F995E
3F475E84ABB9695B615281CAA0895785925563564B537ED47785D563414A8A9F478EDE7E
8D68CC9F3AEDE07F94595256576198A5C5F26865FEC9AC40545059635792B9E8A8C6AC7C
FFB1573755474C6957528CC0918170979878616A998C5A5E919A5D4C7EACB0BEB28E7747
4E517BC4C089443A48523CCECC50251D21373C44564450553E484740495B61665D979BAB
AFADB3B0B5B5B5B8B8BBB6BFBABBBBBAB9B9B7B6
82807D7B7B797775716E6B6A68666464636A636779766F6D92C99488635B61837879A67E
4B58427984B795555C5B6EB4D17D6A6ABD73795361505DB0DB85B8AE486CC79A4B60F9D6
796E87BB49E3FC53BD7F484B5E687C909EF7B64FFFB778494E74634FA0D3D0C27EAB8751
E5D4463C374062736CB1CB8A838971706A555057515F637B646761796C7E8C6E4E394A67
76837E5460BEB9A482775F87ABFDFFB9B89F85582933262C3641555B554FA094A1AEABA9
AEAFB0B6B4B6B6B8B7B8BAB9BBBBBBBABAB9B7B6
83817F7E7D7A7775716D6A6967656464686366656E83B28A827E769F8A82505D95859393
614E5555777DC582656C6A89A7C17C73A3917A5A455C5C82CBB979C0536CAB44525BCCC9
808379D1718AFF6E969C58345C5E5B699BE2AC3DDBC8A1555651508BFFACBC9DA9E2BF50
CAF335323840878CA4C9927A5B58616F665E576E663E59A2505793A283514E8E8676AEA8
725045495E687D7A7F73A586325280C0C0BDC0BCBFB7B8B9B7B5B2B1AAB0B3ACACABACAC
ADB2B1B7B6BAB6B5B7BAB6BDBBBBBBBAB9B9B7B5
828281807E7B7775716D6A68676565666862666766757E9D8D6962828165595358AD89A3
883C40505C8584A66A5C53858AC1BF7182B7937F405B74517BBE968BB9565359533B9FF3
837A70B67D72FF8E449B715655596B98BFDAC065BEEFC7922A51457FE5AC986388C9C15E
A5FF423C2C49708B9A6457555A5552575866589CA13F596C97BF9E90854C61919DA88770
777F748391A8A27F77588AAA83474312BFC2C4C0BFC2BBBBB7B9B7B6B5B5ADAFADAEADAC
B6B0B4B4B5B5B6B8B7B6BAB7BABABAB9B9B8B6B4
84828181807D7875716E6B686767666666656666666A7785A09B6F6E838663555598A784
B171485153557B999F8B5573899BBAC25690A256524E6C778083CA76D88F4D715B4B5BFD
978C917BBA34F5FC485A5B7471605491D9F0BF708DEFA0B73B4139AECD7862AEE4A66D6F
83FF92415374828F3B515954675E555C55526E946EA28C83A2B6E8D2988C6C46769C8899
84698CA38F8E8A7D6F7382A0715383BBC1C1C1C1C0BEBCB9B8B8B7B6B5B3B0AEAEAEADAE
B0B2B4B5B5B5B6B7B7B7B7B8BBBAB9B8B7B6B5B4
84838281807D7976716F6D6B6A696867656567686869707885998771808AA96B5A5AAB98
84B16C4A49554880A6A97D52C28A7CA9B074B5746B534B53A6979BCB96B6405C6D374CE4
8E7BA15BBB5979FC6B9150636C635A5396A7C38335FAA4925D3863EF7969C8DDB7775783
E0FFA82B27999F5560594C3D383C5B4C4B606996CB8D8F9C996595C791997C7197AF8684
9CA09997918A817A959CAC7C405ABDC1C0C0C0C0C0BEBCBAB9B9B8B7B6B4B2B0B0AFAEAE
B0B2B3B4B4B4B5B6B7B7B8B9BAB9B8B8B6B5B3B2
848483817F7D7A7873716F6D6C6B696867686A6B6B6B6C6E748080648F8C829D785961AE
7194A3503D524F518C9B89537DB09884A6957FA66156515074B095A08AAB7E7B764255C4
815F807BA48E3BE8BC4A4A485D63685F7DB4EED15EB1F9885A2D4CEA71BECA7A549CCFDF
B3584A635E757B495E497182A6CBDABBC5EEE6AD7F7D4F515F859BBABEA489738584929E
988B898E9A8C8A98B285B68DBDBAC2BDBFBFBFBFBFBEBDBCBABAB9B8B7B5B3B3B2B1B0B0
B2B3B3B2B4B4B4B5B6B7B8B9B9B8B7B6B5B3B1AF
838382817F7C7A79757472706F6D6B696A6B6C6D6D6D6D6C6E69808285A57F76A565497B
A9658EB260585D4B5C8096764CB191797D9A7DAC894D5D596C83A7688AA5BE847B6960DB
6B9692958ACC3AA5FF514A414D6A5577A0BF8FB6CE5DC0E6682845B6B9E16480BCD8BC57
374E6D7681957D6D75B6F3FFFFF3C3A1A7A08A5A4E6C9A709B8F868C9F81778A9699918D
7660659CADA6A37BB085B4BEBBC1BDC1BFBFBFBFBEBEBEBDBCBCBBBAB8B6B5B5B5B4B3B3
B4B4B3B3B3B3B3B4B6B6B6B7B7B6B6B5B4B2B0AF
828282817F7D7B7B7977747371706E6D6B6C6D6C6C6E6E6D6C6D6C778180B391898C645B
808F669F7E4E4155626C92B16C43BF9A88798E8CB665506A5860767E938AAFAD705734C8
AC929AB5B6AF7E6BFF79304439484F6D7D8C89BDFE906BCDCA363EB4A18BC3C99B413438
778B8472826FA46378FBFDCF8062606A8C76353CA4B076879F8B9B81818C73797083717F
8584A0A682B5B1BCBBB9BABABDC0C2BEC0C0BFBFBFBEBFBFBFBEBEBCBAB8B8B8B7B6B5B5
B5B5B4B3B3B2B3B5B6B6B6B5B5B4B4B3B2B1B0AF
81818181807E7D7C7A787675747372716C6D6D6D6C6D6D6D6E6D696A6F75797D8784895C
50AA9D6BA98C4B5255718DA492385FDF9B717A87AAA2466677545C6777877FBCAA5D3D66
BF908C847A95C5709CF05F3745574F8F65768091E3A25E6AFE6535AA9F8E844B284E81A2
9C819499728C9D7759AE9B5C76A083ADA64E5D9BC19C99AD8889908194A0927E6E737493
A9A37893A0BCB6B7BAB6BAC0BFBDBFC0C0C0C0BFBFBFBFC0C1C1C0BEBDBCBCBBB9B8B7B6
B6B5B4B4B3B3B4B5B6B5B4B4B3B2B1B1B1B0B0AF
80808080807F7E7D7B7A787776757473706F6E6D6D6C6C6C696E6E6C69726C7A7C8D6E8D
6E4DB8AE62A6986E6568857BA3762E6CD7CE9C8F998F64575F655C797C94928BC5804C39
B295856F63687D9C7BE1B8454B3B727B5061B7C7C48C593BE492285E5F8A4E5B87A8B49D
9A6E61944F37589FBB8367868C8393A06F7D928091A07B636069808F9076577E9892AB84
66A4B9B9BCB9B5B7B6BEB9B9C0BDBEC0C0C0C0BFBFBFC0C1C1C1C0C0BFBFBEBEBCBBBAB8
B6B5B5B4B4B4B5B5B4B2B1B1B1B0AFAEAEAFAFAE
7E7E7F80807F7E7D7E7C7A797877767573706E6D6C6C6C6C6C6D6A6B6C6B6D6D7A7DA480
914B40B5C093A39B8B7E7C8988AB69466D8C939B92A0A04654696466545E8176BACB4C2C
8BD5714C5C56566598708A673C446E769ACE9E655041488ADE7F426443564F729E928968
5045715F5E414290A78B5B6E83969187768D859A9A78545176888E868B73979D9891BEA7
BBBBBCBABDBABDB8BCB6BDBFBDC1C0BEBFBFBFBFBFC0C1C1C1C0C0C0C0C0C0BFBEBEBCBA
B7B6B5B5B6B5B5B4B2AFAEAEB0AEADADADADAEAE
7D7C7C7E7F7F7F7E7C7C7B7B7A78767571706F6D6C6C6D6D6D6D6E6E6D6D6D6D6E76837E
9992754A80957FA0B19393629BB17E7C4F4150566C6693625B777F737F68869388AB4C65
52B6DB9F9088747D787083983F485B9D92654C4E6E9DBBD9735B6F74A094889B87624A71
5B418E587D6875885F6A8B946C495D89979FB9977E5B57899D9FAFA595B8BF8CBAB0BEBF
BEBDBCBCBCBBBBBBBABBBDBEBFC0C0BFC0BFBFBFBFC0C0C1C0C0C0C0C1C1C1C0BFC0BEBA
B8B9B9B7B6B6B5B3B0AEAEAEADACACABAAAAACAD
7F7D7D7E7F7E7D7D7C7C7B7B7978757471706E6D6D6D6E6F6F707070706F6F6F70726D7F
807BAAA4744C6188979AA2C9AE82606D8E837B868F7162536D899B909F9D9A7E62958684
71586B8AAFA28D95858AA36E3C4F6F7B38688F9EA2A08B60649E674255838A624E5F694F
44909E74795AAA8C7A80888C6C6D8289A5B38D65566D969EB7B19FA8BE95B6AEC4C0BEBF
BEBDBCBCBCBCBCBDBEBEBEBFBFBFBFBFC0C0BFBEBFBFC0C0BFBFBFC0C1C1C1C1BFC0BFBC
BABABAB9B7B6B5B3B1AFAEAEACABABAAAAA9AAAB
807E7D7D7E7E7D7C7C7C7B7A7977747371706E6D6D6E6F7071717171717070706C6E726F
7180867F9CAB8D8998877F9B9374778185836C7180828E676B8A7C806A6F824E6BB88859
56653E4B414B53484E394A3D5E677258AB9273716155656C6842568E9F4A31496A6B4852
AF9C4A5C794A6E85886F7E7A91938A9FB388605F71AAACA4A5A5AE92AA99C4C8C3C2C2BD
BFBEBDBDBDBEBFC0C1C0C0BFBFBFBFC0C1C0BFBEBEBFBFBEBEBEBFC0C0C0C1C1C0C0BFBD
BCBBBABAB9B7B5B3B1B0AEADABAAAAA9A8A7A7A8
807E7D7D7E7E7D7D7B7B7B7A7876747272716F6E6E6F6F707171717170707070706E7070
75776F8285899B918784604D4D6B747A958AA799B09D8B89928A8E9FA8A7A1B1B2997B83
80646867635A64707E6F65736956898A7B4C4A65645B5659747EA07B3833546F7C4B67A1
743B3E7BA1644B697D8A917B7F96A18A5F54588D9D9495989E86ADB4C6C8C6C3C5C3C2C0
C1BFBEBEBFC0C1C2C1C1C0BFBFBFC0C0C1C0BFBEBEBEBDBCBCBDBFBFC0C0C0C1C1C0BFBE
BDBBBABAB9B8B5B3B1B0AEAEABAAA9A8A7A6A6A7
807E7D7D7D7D7C7C7A7A7A7978767371717070707070706F71717171706F6F6F716F6C6F
747577777883828483737D9090988E978EB0AE7E768180666C757665676C64867A5E786E
707A64878C7B958F828597A7A26848464E65615759646E8A92795E443B3A4B6847587531
4970584D828D4E52567A6D63868664605E83939B9095A37EAD8FCACBC9C7C6C7C9C4C1C7
C2C0BFBFC0C0C2C3C2C1C1C1C0C0C1C1C0C0C0BFBFBEBCBBBCBDBEBFBFBFBFC0C0BFBFBF
BDBBB9B9B8B8B6B4B1AFAFAEADABA9A8A7A6A6A6
807F7E7D7C7A797979797979787674727070707071717170707170706E6E6D6D6E6A706F
707376777B7D8184866562949E9D9F90927E738277817B83AB7A4D6A7D65718C82726E5F
57635F5F5B69817E83837151668C5B413C514C79787559584E555049474A57678A564634
5B675C526478766E6D59454E7C6D767F7F8AA4B79E85BFAACDD1D0CBCFCACBC9C6C9C9C3
C4C2C1C1C1C2C3C4C4C4C4C3C3C2C2C2C1C1C1C1C0BEBDBCBDBDBEBFBFBFBEBEBFBFBFBE
BDBCBAB9B7B7B6B4B2B0AFAFADABA9A8A7A6A6A6
8181807E7B7977787878787978767472717070707171717070706F6E6D6C6C6C69706C6E
75737775777A7A7D81858B887F969986685D448AB0826F9591717161737E76847B776E8C
A48B7C6559444F6C74815D3C6360684F436C559C863F5465694C3C35353B6B5C6C91544A
776B615D626871615B70736774637982949A8FC1ADC3D0CFCED3CED3CDD0CDCFCAC7CAC7
C8C6C5C4C4C4C5C5C6C6C5C5C4C4C4C4C2C3C3C2C0BFBEBEBEBEBFBFBFBFBEBDBDBEBFBE
BEBEBCBAB7B7B6B4B3B2B0AFADABA9A8A7A6A6A6
8282817F7C7877787777787878777573727170707171706F70706F6E6D6C6B6B6B6D6D6E
7170707979797C7D7C8381888987889A746E625C8F91669A906275656E8D95565C554791
7E443B3B413B616E7055366B713545584A494F718D4048513E312F396B4D535E64695166
7277766C5B5E515E7B8288B6A6A7C4B175BFBBD1D2D1D2D4D1D1D4D1D2D1CED0CDCECACA
CBC9C8C7C7C7C7C7C7C7C6C5C5C5C5C5C3C4C4C3C1C0C0C1BFBFBFBFBFBFBDBCBCBEBFBE
BFC0BEBBB7B6B5B5B4B3B1AFACABA9A8A7A6A5A5
8281817F7C7877787777777778787674727170707171707070706F6C6B6B6B6B6B6B6C6E
707273757878797A7D808384858A8A8C8B5B5B436E86679883646175646798915A52699B
48372C394E496A956C51756D3E48233D5032415679A22B1F2C3B4946393D3D3E4B4B675F
4F6A4C42566A6D77878DA8ABB29F549DC4D0D2D0D2D2D1D1D2D3D4D4D2D2D2D1D1CFCDCC
CCCCCCCBCBCBCAC9C8C8C7C7C6C6C5C6C5C6C6C3C1C0C1C1C0BFBFC0C1BFBFBFBEBFBFBF
BFBFBDBCB6B6B5B4B3B1AFAEACAAA8A8A8A7A5A4
8282817F7C7A78787878777777787776737272717171707070706F6C6B6B6B6B6B6B6C6E
70717273747577797C7F82848484888B8F8A8C8C6565636B5D3E4D5C58566179743D7A75
5669554F48515D6D46645C4D4746374D535A4B49607457353B44464F3F36232C2A263446
5050586467706B9D9B8A8673B88DC7D0CCD2D1D2D2D2D2D2D3D4D4D5D3D3D3D3D2D1CFCE
CFCFCFCFCECECCCBC9C9C9C9C8C8C7C7C6C6C6C4C3C2C2C2C1C0BFC1C1C1C0C0BFC0C0C0
C0BFBDBCB7B6B4B3B1B0AFAEABAAA9A8A7A6A4A3
8282817D7B7B7A797878777677777878757574737271707070706F6C6B6B6B6B6C6D6E70
71717171717376787B7D80828383888988908A8F8F948E6981796B6C60574E57674D7D83
4D5E543A28354A4C615536495B51645F537460405D5377744D454942444F3C3D43485A62
696A5657797EA2A59861A5BACDCACACFCCD1CDD4D1D2D3D4D4D5D5D5D5D5D4D4D4D4D3D2
D0D2D3D2D1D0CECDCCCCCCCCCBCAC9C8C7C7C6C6C5C4C4C3C1C0C0C2C3C2C1C1C1C2C2C2
C1C0BEBCB7B6B3B1B0AFAEADAAA9A9A8A6A4A3A2
8182817D7B7B7B7A787878777778797977767574737271706F6E6D6C6B6B6B6B6E6E6F71
71706F6E70727477797C7F81818487878A8C8E8D8D91929690947689998D887D626A7281
735B5B4A4E46486866665147504F5B473F50634549565D79766A6560616F756765534D49
51557281988482B2B0C2C5C8CBCFD1CED1CED2CFD2D3D4D5D5D5D5D6D6D6D6D6D6D6D6D6
D2D4D5D5D4D3D1D0CECECECDCDCCCBCAC8C8C7C7C6C5C5C4C3C2C2C3C5C5C4C2C3C3C4C3
C3C1BFBCB9B6B3B0AFAEAEADAAA9A8A7A6A4A2A1
8082817D7A7B7C7B787878777778797978777675737271706D6D6C6B6B6B6B6C6D6D6E6F
706F6D6C6F717376787B7E81828585868B878E8B938B939291999B999A9C9E9D59527E81
718C989C7E6D5D47425A7250625D56454A51523C494E4B4A4F57635E464F565C5567667D
8BA09D78B2AABBC2C1C4C8CDCCCFCDD2CFD3D2D3D3D4D6D6D6D5D5D5D6D7D7D8D8D8D8D9
D6D8D8D8D6D6D5D4D1D0CECECDCCCCCBCAC8C7C7C7C6C5C5C5C5C5C6C7C7C6C5C4C5C5C5
C4C2C0BEBAB7B3B1B0AFAEAEABA9A7A6A5A4A19F
7F80807D7B7B7C7C7879787878797A79787877757371706F6C6C6B6C6B6B6C6D6D6D6D6F
6F6F6E6D6F707275787B7F818283878A8B8C8C8D8A8E8D94949595979B9A9B9B9DA09A9E
9A9F9C67788271474645565B56574B5849555153534B37404945343D4C5E7780929D9884
67AFB2BABDBDBEC0C2C6C6C9CCCED2D3CECFCED5D5D6D6D7D6D6D5D5D6D7D8D9DADADBDB
DBDBDBDAD9D8D7D6D3D1CFCDCDCCCCCBCBC8C7C7C7C7C6C7C8C9C9C9CACAC8C7C6C7C7C6
C5C3C1BFBBB8B5B2B1B1B0AFADAAA8A6A5A4A19F
807F7E7D7C7C7C7C7A797979797B7B7A7978777572706E6E6D6C6C6C6C6C6D6E6F6E6D6E
6F6F6E6D6F707275787B7E8085858687878B8A8D8C8B8E9194939996959A99A09C9CA099
9C98A1A0A3A4A2A3A4A4A2A33F4F566C5A4E4D5D6455585454607D8C8E726B765BAFB4BD
C2BFC1BFBAC0BDC4C2C6C7CBCCD2CDD1D5D5D2D6D6D6D6D6D6D6D5D5D7D8DADBDCDCDCDD
DDDDDDDBDAD9D8D7D5D3D0CECDCCCCCBCBC8C7C8C8C7C8CACBCCCDCDCCCCCBC9C8C8C8C7
C5C4C1BFBCB9B6B4B4B3B1B0AEABA8A6A4A3A19F
817E7C7D7E7D7C7C7B7A79797A7B7C7B79797775716F6D6D6E6D6D6D6D6C6D6F706E6D6D
6E6D6D6C6F707275787B7D7E808587888B8A8E8A8A8D8F90929594969A9A989A9C9A9C9D
9A9E9C9A9F999C9E9DA09FA4A6ADA8A5AAACABABACAFACAFB4B3B6BAB7B9B9BABFC2C0BF
C2BFBFBEC0C1C0C1C2C6C7CBD0CDD5D2D3D7D5D4D6D6D6D6D7D6D6D5D7D9DBDCDDDDDDDE
DEDEDDDCDCDBDAD8D6D3D0CECDCDCCCBCBC8C7C8C8C8CACCCCCFD0CFCDCDCCCBCACAC9C7
C5C4C1BFBCBAB7B6B5B4B2B1AEACA9A6A4A2A0A0
7E7D7D7D7D7D7D7C7D7B79787A7C7C7C7B797674726F6D6D6D6D6D6D6C6C6D6F706E6D6C
6C6C6D6E6D6E7174777A7C7E81848787898B8B8A8A8C8F91939597979797999A9A999A9C
9C9C9C9D9E9E9D9C9D9FA1A2A4A6A9ABADAEAFB0B0B1B4B6B6B8BABDBEBEBFBFC0C0C1C1
C0C0C0C0C0C1C1C1C2C4C8CBD0D1D2D4D5D6D7D7D8D7D6D6D7D7D7D7D8D9DBDDDEDEDEDE
DFDFDEDEDDDBD9D8D7D5D3D1CFCECCCBC9C9C9C8C8CACCCECFCFCFCFCECDCCCCCBCBCAC8
C6C4C2C0BEBCB8B5B4B5B3B0AEABA8A5A4A3A2A2
7C7D7D7D7D7C7C7C7C7B79787A7C7D7D7B79777573706E6D6D6C6C6D6D6D6E6F6F6D6C6C
6D6C6C6C6C6E707376797C7E81848788898A8A898B8D909293959797979798999998999A
9C9C9C9C9D9D9D9D9FA0A2A4A6A8A9AAACAEB0B1B2B3B4B6B8B9BCBEBFBFBFBFC0C1C1C1
C1C0C0C0C1C2C2C3C3C6CACDD0D1D2D3D5D6D7D6D6D7D7D7D8D8D8D9D9DADBDDDEDEDDDD
DEDEDEDEDDDCDAD8D8D6D3D1D0CECDCBCBCAC9C8C8C9CCCDCFCFCECDCDCCCCCDCCCBCAC8
C6C4C1BFBEBCB9B6B5B5B3B0ADABA8A6A5A4A3A2
7A7C7D7D7D7C7C7C7C7B79787A7C7D7D7C7A787674716F6E6C6B6B6D6F6F6F6F6D6C6C6C
6C6C6B6B6B6D6F7275787C7E81848788888989888B8E9192939596979898989898989899
9B9B9C9C9C9C9D9E9FA0A3A5A8A9AAAAABAEB1B3B4B4B5B6B9BABCBFC0C0C0BFC0C1C2C2
C1C0C0C0C1C2C3C4C5C8CBCED1D1D1D3D5D6D6D6D5D7D8D9D9D9DADADADBDCDDDEDEDDDC
DCDCDDDEDDDCD9D8D8D6D3D2D0CFCECDCCCBCAC9C8CACCCDCFCECDCCCCCCCDCDCCCCCAC8
C6C4C1BFBDBCB9B7B6B5B2AFACAAA9A8A7A5A4A3
7A7B7C7D7D7C7D7D7D7C7B7A7B7D7D7D7C7A797775726F6E6C6C6C6E6F6F6E6E6D6C6C6C
6C6B6A6A6B6D6F7275787C7E80838687878889898B8E9192939496969897979798989899
9A9A9B9A9A9B9D9E9FA0A3A6A8A9AAAAABAEB1B4B5B6B7B8B9BABCBFC1C2C1BFC0C1C2C2
C1C0C0C0C0C1C3C4C6C9CCCFD0D1D2D3D4D5D6D6D5D6D8DADADBDBDBDCDCDCDDDEDEDCDB
DADBDCDDDDDBD8D7D7D5D3D2D1D1D0CFCDCCCBCACACBCCCDCFCECCCCCCCDCDCDCDCCCAC7
C5C3C1BFBDBBBAB8B7B5B1AEABABAAA9A9A7A5A4
7C7C7B7C7D7E7E7E7E7E7E7D7E7E7D7C7C7B797875726F6E6D6D6E6E6E6D6D6E6F6D6C6B
6B6A6A6A6B6D707275787C7E808285868687898B8C8F9293939495969696959596979898
98999999999A9C9E9EA1A4A5A6A7A9ABADAFB1B4B5B7B9BAB9BBBDC0C2C2C1C0C1C2C3C3
C2C1C1C1C1C2C4C6C8CACDCFCFD1D3D3D2D3D4D6D5D6D7D9DBDCDCDCDDDDDDDDDEDEDCDB
DBDBDCDDDCDAD8D6D5D4D3D2D2D2D1D0CECDCCCCCCCCCDCDCECDCCCCCDCDCDCDCDCCC9C6
C4C2C0BFBDBCBAB9B7B4B0AEACACACABAAA9A7A6
7E7D7C7C7D7F80808081818080807E7C7C7B7978767371706F6F6F6E6D6C6C6D6F6D6C6B
6B6A6A6B6C6E717476787B7D8081828385878A8C8D8F9294949595959595959596989897
97989898999A9C9E9FA1A4A4A4A5A8ABAEB0B2B4B6B8BABCBBBDBFC1C2C2C1C0C3C3C4C5
C4C3C3C3C2C4C6C8CACCCECFCFD1D3D3D2D2D3D5D5D5D6D7DADBDCDCDEDDDDDDDDDDDCDB
DCDCDCDCDBDAD8D6D4D4D3D3D4D3D2D1CFCECDCDCDCDCDCDCDCDCDCDCDCDCDCDCCCBC8C5
C3C2C0BFBEBCBAB9B7B4B1AFADADADACABAAA9A8
7E7E7D7D7E7F8182828383828281807E7C7B79787775737371706F6E6D6C6C6D6F6D6B6B
6B6B6B6B6D6F727476787A7C808081828486898C8D8F9293949494949495959596989897
97979898999B9D9FA0A1A3A4A4A6AAADAFB0B3B5B7B9BBBCBDBEC0C2C3C3C3C2C4C4C4C5
C5C5C4C4C3C5C7C9CBCCCECFD0D1D1D2D1D2D2D3D5D5D5D6D8D9DBDCDEDDDCDBDBDCDCDC
DDDCDBDADAD9D7D7D5D5D5D5D5D5D3D2D0CFCECDCDCDCDCDCCCCCDCDCDCCCDCDCBCAC8C6
C3C2C0BEBDBBB9B8B7B4B1B0AFAFAEADACABAAA9
7E7E7E7E7E7F8183848484838382817F7C7B79797877767573716E6D6D6C6C6D6E6C6B6B
6B6B6B6C6D7073757677797B7F7F80818385888B8D8F9192939493939395959596979796
979798999A9C9D9FA0A1A2A4A6A9ACAEAFB1B4B6B9BABBBCBEBFC1C3C4C4C4C5C4C4C4C4
C5C5C5C4C4C5C7C9CBCCCECED0D0D0D1D1D2D2D2D4D4D5D5D6D8DADCDDDCDCDBDADBDCDC
DCDBDAD9D8D7D7D6D6D6D6D7D7D6D4D2D2D0CECDCDCDCDCDCBCCCCCCCCCCCCCDCACAC8C6
C4C2C0BEBBB9B7B7B6B3B1B0B0AFAEADACABAAAA
818181818282828384858686868482807D7C7A79787877757572706F6E6D6D6E6E6C6B6B
6C6D6D6D707173757576797C7F7E7E7F8285888A8D8F9192939393939595959595959697
9798999A9C9D9E9F9EA0A3A6A9ABADAFB2B4B6B8B9BBBDBEC0C1C2C3C4C4C4C3C4C4C5C6
C6C6C5C4C4C5C7C8CACCCECFCFD0D0D1D2D2D1D1D3D3D3D5D7D9DADCDDDCDBDBDBDCDCDB
DDDBD9D7D7D7D7D7D7D6D6D6D7D6D4D2D2D1CFCFCFCDCDCECCCCCCCCCCCCCCCCCAC9C6C4
C2C0BFBEBAB8B6B6B6B4B1AFB0AFAFAEAEADABAA
828282838383838385858687878683827F7E7C7A7979787777757271706F6F6F6F6D6B6C
6D6F6F6E707072747576797C7E7E7E7F8184878A8C8E9091919293939494959595959696
98999A9C9D9E9F9F9FA2A5A9ABADAFB1B3B6B8BABBBDBFC0C1C2C3C4C4C4C4C3C4C4C5C6
C7C6C5C4C4C5C6C8CACCCDCECECFD0D1D1D1D1D1D2D2D3D5D7D8DADBDDDCDBDADADBDBDB
DBDAD8D7D7D7D7D7D6D6D5D5D5D5D3D2D2D1D0D0CFCDCCCDCDCDCDCCCBCCCCCBCAC8C6C4
C2BFBEBCBAB8B6B6B5B3B1AFB1B0B0AFAFAEABAA
8283848585848484848586878786848382817E7D7C7B7A797775737271707070706E6C6D
707171707171727375777A7D7E7E7E7E808286888B8C8E8E8F9193949494959596979797
9A9B9D9E9FA0A09FA0A3A7ABAEB0B2B3B5B8BABCBEC0C2C3C4C4C4C5C5C4C4C4C3C4C5C6
C7C6C5C4C4C5C6C7C9CACCCCCCCDCFD1D1D1D1D1D2D2D3D5D7D8D9DADCDCDAD9D9DBDBDB
D9D8D7D6D7D7D7D7D6D6D5D4D4D3D3D2D2D1D1D1CFCDCBCBCDCDCCCBCBCBCBCBCAC8C6C3
C0BEBBBAB8B6B5B5B5B3B1B0B0B0B0B0B0AEABA9
838485868686858483848586868684838382817F7F7E7C7A77757372717070706E6E6D6F
717373737473737476787B7D7E7E7E7E7F818486898A8C8C8D9092949595959798999A9A
9C9D9FA1A1A1A1A1A2A5A9ADB0B2B4B5B7BABDBFC0C2C4C5C6C6C6C6C5C5C5C4C3C4C6C7
C7C7C5C4C4C5C6C7C8C9CACBCACCCFD0D0D0D0D0D1D2D4D6D7D8D9DADBDBDADADADBDBDB
D9D8D7D7D7D7D7D7D6D6D5D4D2D2D2D3D2D2D1D0CFCDCCCBCDCDCCCBCACACBCACAC8C6C2
BFBCB9B7B6B5B5B5B5B4B1B0AFAFAFB0AFADABA9
838486868787858483838486868685848383828281807D7B7977757372706F6F6D6D6E6F
717375767776767677787B7D7E7E7E7E7E80828587898A8A8C8F929496969697999A9C9D
9EA0A2A3A3A3A2A2A4A7ABAFB2B5B7B8BABDC0C2C3C5C6C8C9C8C7C7C6C6C6C6C5C5C7C7
C7C7C6C5C5C5C6C7C8C9C9CACACCCECFCFCECECED0D1D3D5D6D7D8D9DADADBDBDBDBDCDB
DAD9D8D7D7D7D7D7D7D6D5D3D2D1D2D2D1D1D1D0CFCECDCCCCCCCBCAC9CACACAC9C7C4C1
BEBBB8B7B6B5B5B5B5B3B0AFADAEAEAFAFADABA9
828486858687868483838485868584838383838382817F7C7B79767573716F6E6C6E6F70
717376787979787878797B7D7F7F7E7E7E7F82838587898A8C8F929496979798999B9C9E
A0A2A3A4A4A4A5A5A6A9ADB0B3B6B9BABDC0C3C4C5C6C8C9CAC9C8C7C6C6C7C7C7C7C7C7
C7C6C6C6C6C6C7C7C8C8C9C9CACBCDCDCDCDCCCCCDCED1D3D4D5D6D7D8DADBDBDBDCDCDC
DBD9D8D7D7D6D6D6D7D6D5D2D1D0D0D1D0D1D1D0CFCFCECDCCCCCBC9C9C9C9C9C7C5C2BF
BDBAB8B7B6B5B4B4B3B1AFAEADADAEAEADACABAA
82848584858686858484858586858483848483838382807E7B7A777674716F6F6F6F7071
7275787A7C7B7B7B7A7A7C7F807F7E7E7E808183838588898C8F9294959698999A9B9EA0
A2A3A4A5A5A5A7A8A9ABAEB0B3B6BABCBFC2C5C6C6C7C8C9CAC9C8C7C7C7C8C8C9C9C8C7
C6C6C6C7C6C7C7C8C8C8C8C8CACACBCCCCCBCBCBCBCCCED1D2D3D5D6D7D9DADADBDBDCDC
DBD9D8D6D6D6D6D6D6D5D3D1D0CFCFCFCFD1D1D0D0D0CFCDCBCBCBC9C9C8C8C7C6C4C1BD
BBB9B7B6B5B4B2B1B0AFAEAEADADADACACABAAAA
8284858484868685868686878786858484848383838382807B7A78777573717071717171
7376787A7D7D7D7D7C7C7E81807F7E7E7F808182828587898C8F92939395989A9B9DA0A2
A3A4A5A5A5A6A8AAABADAFB1B4B8BBBEC1C4C7C8C7C8C9CACAC9C8C7C7C7C8C9CAC9C8C7
C5C5C6C7C7C7C7C8C8C8C8C7C9C9CACACBCBCBCACACBCED0D1D2D4D6D7D8D9D9DADBDCDD
DBD9D7D6D5D5D6D6D6D4D2D0CFCECDCDCFD1D2D1D1D0CFCDCBCCCBC9C8C8C7C6C6C3C0BC
B9B7B6B5B4B2B0AFAEAEAEAFADADACABAAAAA9A9
8384858686878787888686888887868786858484848382807D7B79777675747373737474
76787A7B7D7E7F7E7D7D7E807E7D7D7E80808181828487898C8F929495989A9A9B9EA1A3
A6A5A4A5A7A8A9AAABADB0B2B5B9BCBEC2C4C6C7C9CACBCBCBC9C7C7C7C6C8CACBCAC8C6
C6C6C7C8C9C8C7C7C8C8C8C7C7C8C9C8C9CACAC8C9CBCDCFCFD1D4D6D6D7D8D8D8D9DADB
D9D8D7D6D5D4D5D6D6D5D3D1CFCECECED0D0D1D1D1CFCECDCCCDCCCBC9C8C7C6C7C4BFBC
B9B7B6B6B3B1AFAEAEAEAEAFADADADACABAAA9A8
8585858688898988898888898988878787868584838281807D7C79787776767676767677
787A7C7D7D7E7F807F7F80817F7E7E80818181828384878A8D9092949597999A9B9EA1A3
A6A5A5A6A8A8A9AAACAEB0B3B5B9BCBFC2C4C6C7C8CACBCBCAC8C7C7C6C6C7C8CAC9C7C6
C6C7C8C9CAC9C8C7C7C7C7C7C7C8C8C7C8C9C8C8C8CACDCFD0D2D3D5D5D5D6D7D8D8D8D8
D6D5D4D4D3D3D4D5D6D5D3D2D1D0D0D0D0D1D1D2D1D0CECCCBCCCCCBCAC9C8C7C6C4C0BC
B9B7B5B5B3B1B0AFAFAFAEAFAEAEAEACABA9A8A7
868686878A8B8B8A8B8B8B8A8B8B8A89888785848382807F7E7D7B79797979797979797A
7B7D7E7F7D7E80818181818180808081828282838486888A8D909294959799999B9EA2A4
A5A5A5A7A8A9A9AAADAFB1B3B6B9BDC0C2C4C6C7C8C9CACAC7C8C7C6C5C5C6C6C8C7C6C5
C6C7CACBCBCAC9C8C7C6C7C7C9C7C7C7C7C7C7C7C8CACDD0D1D2D2D3D3D3D4D5D6D6D4D3
D3D2D2D2D2D1D3D4D5D4D3D2D2D2D2D1D0D0D1D1D1CFCDCBCBCCCCCBCACAC9C8C6C4C1BD
B9B7B5B4B3B2B0B0B0AFAFAFAFAFAEADABA9A6A5
878787898B8C8C8C8C8D8D8B8B8C8B89888785838281807F7F7E7D7C7B7B7B7C7C7C7C7D
7D7E7F807E7E80818282818181818283848484858687898B8D8F9193949698999B9EA1A4
A5A5A6A7A8A9AAABAEB0B2B5B7BBBEC1C3C5C6C7C7C8C8C7C6C7C7C4C3C4C5C5C7C6C5C5
C6C8CACCCCCBCAC9C7C6C7C8CAC8C7C7C7C6C6C7C8CACCCFD0D1D1D0D1D1D1D2D3D2D1D0
D1D1D1D1D1D1D2D4D3D2D2D2D3D4D3D2D1D0D0D0D0CECCCACBCCCCCBCAC9C8C7C5C4C2BF
BAB7B5B4B3B2B1B0B0B0AFB0B0B0AFADAAA8A5A3
8687898A8B8C8D8E8C8D8D8B8B8C8A888786848382818080807F7F7E7D7D7D7D7E7E7F7F
808081818080818182828181818283848686878888898A8B8C8E9091939496999B9EA0A3
A5A5A6A7A8A9ABADAEB0B3B6B9BCBFC1C4C6C8C8C8C8C7C6C6C7C5C3C2C4C5C5C6C6C5C5
C6C7C9CBCBCBCBC9C8C7C8C9CAC8C7C7C8C7C7C9C9CACCCDCFCFCFCECECFD0D0CFCFCFCF
CFCFCFD0D0D0D1D3D3D2D2D3D4D4D4D3D2D1D0CFCFCECCCACACBCBCAC9C8C7C7C5C4C3C0
BCB8B6B5B4B2B0B0B0AFAFB0B0B0AEABA9A7A4A2
8487898B8B8C8D8E8C8C8C8B8B8B8A898685848281818181818180807F7F7F7E80818182
828282828382828282828181818283858687888A8A8B8B8B8C8D8F90929396999B9D9FA1
A4A5A6A7A8A9ABADAEB0B4B7BABDC0C2C5C7C8C8C8C8C8C7C6C5C4C2C2C3C4C5C5C6C6C6
C6C7C9CACBCBCBCAC9C8C9CAC9C8C7C8C9C9CACBCBCBCBCCCCCDCDCDCCCDCDCDCCCCCDCE
CDCDCDCECFCFD0D1D3D3D2D3D3D4D4D3D3D2D1D0CFCECCCBC8C9C9C8C7C7C7C6C4C4C2C0
BDBAB7B6B5B3B1B0B0AFAFB0B0AEACA9A7A6A4A2
8486898B8C8C8C8D8C8B8B8B8B8A89888584838281818182828181818181808081828383
838383838383838382818181828283848687898B8B8B8C8C8C8D8E8F919396999C9D9EA0
A2A4A6A8A9A9ABADAEB1B4B8BBBEC2C4C6C7C8C7C7C8C8C7C6C4C2C2C3C3C3C4C5C6C7C7
C7C7C8CACACBCBCACAC9CACAC8C8C8C8C9CBCCCCCCCCCCCBCBCBCBCBCBCBCBCACACACACA
CBCBCBCDCFD0D1D1D3D3D2D2D2D2D2D2D2D1D1D0CFCDCBCAC7C7C7C6C5C5C5C5C3C3C2C0
BEBBB9B7B5B3B2B1B0AFAFAFAFADA9A6A5A5A3A2
8486888B8C8D8C8B8A89888A898786878584838281818282838281818182828181828383
848383838383838382818181828283848586898B8C8C8C8C8C8D8E909192959A9C9D9E9F
A1A3A7A9AAAAABADAFB1B4B7BBBFC2C5C7C7C7C6C6C6C6C6C6C3C1C2C3C3C3C4C5C6C7C7
C7C7C8CACACBCBCBCACACACAC8C9C9C8C9CBCCCBCDCDCCCBCACACACACBCAC9C8C9C9C8C8
CBCACACCCFD1D1D2D3D2D2D1D0D0D1D1D0D1D1D1CFCDCAC9C7C7C6C5C4C4C4C4C3C2C1C0
BEBCBAB8B5B4B3B2B1B0AFAFAEABA8A5A3A4A3A2
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.11.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$ImportFormats", "MR"],
              " "
            }]], Cell["import formats supported on your system "]},
          {Cell[TextData[{
              StyleBox["$ExportFormats", "MR"],
              " "
            }]], Cell["export formats supported on your system "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.3"],

Cell["\<\
Finding the complete list of supported import and export formats. \
\
\>", "Caption",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.4 Exporting Graphics and Sounds", "Subsection",
  CellTags->{"S1.11.4", "4.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to export graphics and sounds in a wide variety of formats. If \
you use the notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then you can typically just copy and paste graphics and sounds directly \
into other programs using the standard mechanism available on your computer \
system.   "
}], "Text",
  CellTags->{"S1.11.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox[".", "MR"],
              StyleBox["ext", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["graphics", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
export graphics to a file in a format deduced from the \
file name \
\>"]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["graphics", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["format", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["export graphics in the specified format "]},
          {Cell[TextData[{
              StyleBox["Export[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["graphics", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["format", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["export graphics to an external command "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.4"],

Cell[TextData[{
  "Exporting ",
  StyleBox["Mathematica", "SO"],
  " graphics and sounds. "
}], "Caption",
  CellTags->"S1.11.4"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["graphics formats "], Cell[TextData[{
              StyleBox["\"EPS\"", "MR"],
              ", ",
              StyleBox["\"TIFF\"", "MR"],
              ", ",
              StyleBox["\"GIF\"", "MR"],
              ", ",
              StyleBox["\"JPEG\"", "MR"],
              ", ",
              StyleBox["\"PNG\"", "MR"],
              ", ",
              StyleBox["\"PCX\"", "MR"],
              ", ",
              StyleBox["\"PDF\"", "MR"],
              ", ",
              StyleBox["\"SVG\"", "MR"],
              ", etc. "
            }]]},
          {Cell["sound formats "], Cell[TextData[{
              StyleBox["\"SND\"", "MR"],
              ", ",
              StyleBox["\"WAV\"", "MR"],
              ", ",
              StyleBox["\"AIFF\"", "MR"],
              ", ",
              StyleBox["\"AU\"", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.4"],

Cell[TextData[{
  "Some common formats for graphics and sounds. Section\[NonBreakingSpace]",
  ButtonBox["2.10.19",
    ButtonData:>{"2.10.19", "19.1"},
    ButtonStyle->"MainBookLink"],
  " gives a complete list. "
}], "Caption",
  CellTags->"S1.11.4"],

Cell["This generates a plot. ", "MathCaption",
  CellTags->{"S1.11.4", "4.3"}],

Cell[CellGroupData[{

Cell["Plot[Sin[x] + Sin[Sqrt[2] x], {x, 0, 10}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.26241 0.176645 [
[.21429 .24991 -3 -9 ]
[.21429 .24991 3 0 ]
[.40476 .24991 -3 -9 ]
[.40476 .24991 3 0 ]
[.59524 .24991 -3 -9 ]
[.59524 .24991 3 0 ]
[.78571 .24991 -3 -9 ]
[.78571 .24991 3 0 ]
[.97619 .24991 -6 -9 ]
[.97619 .24991 6 0 ]
[.01131 .08576 -12 -4.5 ]
[.01131 .08576 0 4.5 ]
[.01131 .17409 -24 -4.5 ]
[.01131 .17409 0 4.5 ]
[.01131 .35073 -18 -4.5 ]
[.01131 .35073 0 4.5 ]
[.01131 .43906 -6 -4.5 ]
[.01131 .43906 0 4.5 ]
[.01131 .52738 -18 -4.5 ]
[.01131 .52738 0 4.5 ]
[.01131 .6157 -6 -4.5 ]
[.01131 .6157 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .26241 m
.21429 .26866 L
s
[(2)] .21429 .24991 0 1 Mshowa
.40476 .26241 m
.40476 .26866 L
s
[(4)] .40476 .24991 0 1 Mshowa
.59524 .26241 m
.59524 .26866 L
s
[(6)] .59524 .24991 0 1 Mshowa
.78571 .26241 m
.78571 .26866 L
s
[(8)] .78571 .24991 0 1 Mshowa
.97619 .26241 m
.97619 .26866 L
s
[(10)] .97619 .24991 0 1 Mshowa
.125 Mabswid
.07143 .26241 m
.07143 .26616 L
s
.11905 .26241 m
.11905 .26616 L
s
.16667 .26241 m
.16667 .26616 L
s
.2619 .26241 m
.2619 .26616 L
s
.30952 .26241 m
.30952 .26616 L
s
.35714 .26241 m
.35714 .26616 L
s
.45238 .26241 m
.45238 .26616 L
s
.5 .26241 m
.5 .26616 L
s
.54762 .26241 m
.54762 .26616 L
s
.64286 .26241 m
.64286 .26616 L
s
.69048 .26241 m
.69048 .26616 L
s
.7381 .26241 m
.7381 .26616 L
s
.83333 .26241 m
.83333 .26616 L
s
.88095 .26241 m
.88095 .26616 L
s
.92857 .26241 m
.92857 .26616 L
s
.25 Mabswid
0 .26241 m
1 .26241 L
s
.02381 .08576 m
.03006 .08576 L
s
[(-1)] .01131 .08576 1 0 Mshowa
.02381 .17409 m
.03006 .17409 L
s
[(-0.5)] .01131 .17409 1 0 Mshowa
.02381 .35073 m
.03006 .35073 L
s
[(0.5)] .01131 .35073 1 0 Mshowa
.02381 .43906 m
.03006 .43906 L
s
[(1)] .01131 .43906 1 0 Mshowa
.02381 .52738 m
.03006 .52738 L
s
[(1.5)] .01131 .52738 1 0 Mshowa
.02381 .6157 m
.03006 .6157 L
s
[(2)] .01131 .6157 1 0 Mshowa
.125 Mabswid
.02381 .01511 m
.02756 .01511 L
s
.02381 .03277 m
.02756 .03277 L
s
.02381 .05044 m
.02756 .05044 L
s
.02381 .0681 m
.02756 .0681 L
s
.02381 .10343 m
.02756 .10343 L
s
.02381 .12109 m
.02756 .12109 L
s
.02381 .13876 m
.02756 .13876 L
s
.02381 .15642 m
.02756 .15642 L
s
.02381 .19175 m
.02756 .19175 L
s
.02381 .20942 m
.02756 .20942 L
s
.02381 .22708 m
.02756 .22708 L
s
.02381 .24475 m
.02756 .24475 L
s
.02381 .28007 m
.02756 .28007 L
s
.02381 .29774 m
.02756 .29774 L
s
.02381 .3154 m
.02756 .3154 L
s
.02381 .33307 m
.02756 .33307 L
s
.02381 .3684 m
.02756 .3684 L
s
.02381 .38606 m
.02756 .38606 L
s
.02381 .40373 m
.02756 .40373 L
s
.02381 .42139 m
.02756 .42139 L
s
.02381 .45672 m
.02756 .45672 L
s
.02381 .47438 m
.02756 .47438 L
s
.02381 .49205 m
.02756 .49205 L
s
.02381 .50971 m
.02756 .50971 L
s
.02381 .54504 m
.02756 .54504 L
s
.02381 .56271 m
.02756 .56271 L
s
.02381 .58037 m
.02756 .58037 L
s
.02381 .59804 m
.02756 .59804 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26241 m
.06244 .42799 L
.08255 .49987 L
.0932 .53149 L
.10458 .5595 L
.11531 .57988 L
.12038 .58737 L
.12507 .59303 L
.12977 .59748 L
.1322 .59929 L
.13488 .6009 L
.1372 .60196 L
.13938 .60268 L
.14058 .60296 L
.14168 .60315 L
.14295 .60328 L
.14415 .60332 L
.1454 .60327 L
.1461 .60321 L
.14674 .60312 L
.14793 .60291 L
.14918 .6026 L
.15135 .60184 L
.15374 .60071 L
.15629 .59916 L
.15902 .59709 L
.16396 .59233 L
.17358 .57935 L
.18234 .56344 L
.20143 .51678 L
.22219 .45075 L
.26297 .29616 L
.30224 .15267 L
.32193 .09491 L
.33999 .05446 L
.34941 .03874 L
.35934 .0264 L
.3645 .02173 L
.3693 .01845 L
.37206 .01703 L
.37456 .01603 L
.37595 .0156 L
.37746 .01523 L
.37815 .0151 L
.37888 .01497 L
.38019 .01481 L
.3814 .01473 L
.38272 .01472 L
.38397 .01477 L
.38512 .01488 L
Mistroke
.38627 .01504 L
.38731 .01524 L
.38963 .01585 L
.39214 .01676 L
.39485 .01803 L
.39977 .02109 L
.40441 .02486 L
.40931 .02971 L
.41808 .04053 L
.43776 .07344 L
.4561 .11237 L
.49506 .20641 L
.51491 .25243 L
.53648 .29555 L
.54654 .31227 L
.55721 .32726 L
.56722 .33856 L
.57638 .34651 L
.58087 .34956 L
.58577 .35226 L
.5907 .35433 L
.59339 .35518 L
.59589 .3558 L
.59703 .35603 L
.59827 .35624 L
.59937 .35639 L
.60053 .35652 L
.60157 .35661 L
.60272 .35668 L
.60376 .35671 L
.60474 .35671 L
.60596 .35669 L
.60712 .35663 L
.60816 .35655 L
.60929 .35643 L
.61183 .35607 L
.61418 .35559 L
.6188 .35431 L
.62379 .35243 L
.63282 .34781 L
.64356 .34057 L
.65341 .33261 L
.693 .29538 L
.71295 .27863 L
.72164 .27272 L
.73108 .26755 L
.73632 .26531 L
.74115 .26366 L
.74577 .26249 L
.7481 .26205 L
Mistroke
.75067 .26168 L
.75206 .26153 L
.75275 .26147 L
.75339 .26143 L
.75458 .26136 L
.75588 .26132 L
.75661 .26131 L
.7573 .26132 L
.75859 .26134 L
.75931 .26137 L
.75998 .26141 L
.76148 .26153 L
.7627 .26165 L
.76383 .2618 L
.76641 .26221 L
.76892 .26275 L
.77161 .26345 L
.7769 .26525 L
.78179 .26737 L
.79286 .27377 L
.80263 .2811 L
.81299 .29036 L
.85076 .33179 L
.87175 .35479 L
.88094 .36361 L
.89098 .37186 L
.89571 .37513 L
.90076 .37814 L
.90512 .38031 L
.90984 .38217 L
.91263 .38301 L
.9152 .38362 L
.91765 .38405 L
.91889 .3842 L
.91958 .38427 L
.92024 .38433 L
.92148 .3844 L
.9226 .38443 L
.92381 .38442 L
.92513 .38437 L
.92627 .38428 L
.9275 .38415 L
.92865 .38399 L
.92969 .38381 L
.93203 .38329 L
.93459 .38254 L
.93975 .38046 L
.94453 .37782 L
.94899 .37474 L
.95906 .36556 L
Mistroke
.96983 .35236 L
.97619 .34295 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S1.11.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.11.4"]
}, Open  ]],

Cell["\<\
This exports the plot to a file in Encapsulated PostScript format. \
\
\>", "MathCaption",
  CellTags->{"S1.11.4", "4.4"}],

Cell[CellGroupData[{

Cell["Export[\"sinplot.eps\", %]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.4"],

Cell[BoxData[
    \("sinplot.eps"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.11.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.5 Exporting Formulas from Notebooks", "Subsection",
  CellTags->{"S1.11.5", "5.1"}],

Cell["Here is a cell containing a formula.", "MathCaption",
  CellTags->{"S1.11.5", "5.2"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000BR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=?0?ooo`030000003o
ool0oooo0?l0ooooXP3oool50000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c=?0?ooo`030000003oool0oooo0?l0ooooYP3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cCP3oool2000000P0oooo0`00003o0?oooid0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dh0oooo00<000000?oo
o`0000001P3oool01@000000oooo0?ooo`3oool000000?l0ooooW03oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cC@3o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo0?l0ooooVP3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cB`3oool00`000000oooo000000020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0E`3oool3000005l0oooo0`00003M0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=<0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool2000005T0oooo00D000000?ooo`3oool0oooo0000001M
0?ooo`050000003oool0oooo0?ooo`000000g03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cD@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F`3oool01@000000oooo
0?ooo`3oool000000=`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<e40oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool0000005`0oooo00<000000?ooo`3oool0F`3oool01@000000oooo0?ooo`3o
ool000000=`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<e40oooo00<000000?ooo`3oool0103oool3000005/0oooo
0P00001N0?ooo`@00000g@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cDP3oool00`000000oooo0?ooo`1S0?ooo`03
0000003oool0oooo05/0oooo00<000000?ooo`3oool0gP3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cDP3oool00`00
0000oooo0?ooo`1O0?ooo`050000003oool0oooo0?ooo`000000GP3oool00`000000oooo0?ooo`3M
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=B0?ooo``00000E`3oool300000600oooo0`00003L0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cRP3oool00`00
0000oooo0?ooo`3o0?ooof/0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<hX0oooo00<000000?ooo`3oool0o`3ooom[
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<Q0?ooo`D000000`3ooomH000000L0oooo1@0000050?ooodP000001`3o
ool5000000H0ooooFP00002a0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>:0?ooo`030000003oool0oooo0?l0oooo
J`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cRP3oool00`000000oooo0?ooo`3o0?ooof/0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<cIP3oool00`000000oooo0?ooo`3o0?ooohl0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<fH0oooo00<000000?ooo`3oool0>`3oool3000005H0oooo0`00003g0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=U0?ooo`800000@03oool00`000000oooo0?ooo`020?ooo`8000009P3oool2000002X0oooo
00<000000?ooo`3oool00P3oool2000003P0oooo0P00002f0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=T0?ooo`03
0000003oool000000400oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo0;@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<f40oooo00H000000?ooo`3oool000000?ooo`00
00060?ooo`8000009@3oool6000000<0oooo0`0000040?ooo`@00000103oool00`000000oooo0?oo
o`0:0?ooo`D000003@3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo01D0oooo1P00
00030?ooo`<00000103oool4000000@0oooo00<000000?ooo`3oool00P3oool5000000h0oooo0P00
00030?ooo`800000303oool2000000<0oooo0P0000090?ooo`030000003oool0oooo0;@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<f80oooo0P0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00009@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool05P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000000L0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000X0oooo
00<000000?ooo`3oool0]03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cH`3oool01@000000oooo0?ooo`3oool00000
00L0oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
000000050?ooo`030000003oool0oooo01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`000000203oool00`000000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00<00000
0?ooo`3oool0]03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cI`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo1@0000050?ooo`03
0000003oool0oooo00@0oooo1@0000070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`D000001`3oool00`000000oooo0?ooo`050?ooo`D000001P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0;@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<eP0oooo0P00000=0?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000002`3oool2000001P0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`000000203oool00`000000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00<0
00000?ooo`3oool0]03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00<0oooo0P00000=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
1@3oool3000000@0oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo000000000000
00000`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0oooo0`0000040?ooo`<0
000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000H0oooo00<000000?oo
o`3oool00`3oool3000000030?ooo`000000000000D000001@3oool00`000000oooo0?ooo`2d0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=H0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02P3oool3
000001T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo0080oooo0`00000[0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0]03oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool05@3oool3000001D0oooo0P00000=0?ooo`030000003oool0oooo01H0oooo0P00
000G0?ooo`<000005@3oool2000000D0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`030?ooo`800000]P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`2j0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`2h0?ooo`040000003oool0oooo00000;`0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<eP0oooo00<00000
0?ooo`3oool03@3oool:000000X0oooo00<000000?ooo`3oool0^@3oool200000;d0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<b/0oooo0`0000001@3oool00000000000000000oooo00@00000103oool3000000<0oooo
1@0000030?ooo`<0000000<0oooo0000000000000P0000020?ooo`8000000`3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c;03oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
o`3ooomi0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c</0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00<0oooo6@0000050?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
;03oool5000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00<0oooo100000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c;@3oool00`00
0000oooo000000040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3o0?ooogT0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<bd0oooo00<000000?ooo`0000000`3oool00`000000oooo00000002000000<0oooo0`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`0000020?ooo`030000
003oool00000008000001@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0oooo
N@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c;P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`050?ooo`<000000`3oool00`00
0000oooo0?ooo`04000000@0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`3o0?oo
ogT0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<b`0oooo0`00000A0?ooo`L000004@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=H0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooogH0oooo10000?l50?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=H0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0o`3ooomh
0?ooo`80003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<eP0oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P00000@0?ooo`030000003o
ool0oooo0?l0ooooM`3oool00`000?l0oooo0000o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool200000240oooo0P00003o0?ooogP0oooo
00@0003o0?ooo`3oool0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooom03oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo1P00
0?l50?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`00o`3UiNGo0>GUi@/0iNGU
0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 74},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.11.5"],

Cell["\<\
This is what you get if you copy the formula and paste it into an \
external text\[Hyphen]based program. \
\>", "MathCaption",
  CellTags->{"S1.11.5", "5.3"}],

Cell["\<\
\\!\\(-\\(ArcTan[\\(1 + 2 x\\)\\/\\@3]\\/\\@3\\) + Log[-1 + x]\\/3
  - Log[1 + x + x\\^2]\\/6\\) \
\>", "Program",
  CellTags->{"S1.11.5", "5.4"}],

Cell["\<\
Pasting the text back into a notebook immediately reproduces the \
original formula. \
\>", "MathCaption",
  CellTags->{"S1.11.5", "5.5"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000BR000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o03<c<ol0<c<c2`0c<c<10?ooo`0000<0iNGU03<c<`0c<c<0o`0c<c?o03<c<`P0
<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIVOl0iNGUo`3UiND20>GUi@<0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooh0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=?0?ooo`030000003o
ool0oooo0?l0ooooXP3oool50000o`D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c=?0?ooo`030000003oool0oooo0?l0ooooYP3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cCP3oool2000000P0oooo0`00003o0?oooid0oooo00<0003o0?ooo`3oool00`3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<dh0oooo00<000000?oo
o`0000001P3oool01@000000oooo0?ooo`3oool000000?l0ooooW03oool00`000?l0oooo0?ooo`03
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cC@3o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo0?l0ooooVP3oool00`000?l0oooo
0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<cB`3oool00`000000oooo000000020?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool0E`3oool3000005l0oooo0`00003M0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=<0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool01@3oool2000005T0oooo00D000000?ooo`3oool0oooo0000001M
0?ooo`050000003oool0oooo0?ooo`000000g03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2I
VIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cD@3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0F`3oool01@000000oooo
0?ooo`3oool000000=`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<e40oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool0000005`0oooo00<000000?ooo`3oool0F`3oool01@000000oooo0?ooo`3o
ool000000=`0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<e40oooo00<000000?ooo`3oool0103oool3000005/0oooo
0P00001N0?ooo`@00000g@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cDP3oool00`000000oooo0?ooo`1S0?ooo`03
0000003oool0oooo05/0oooo00<000000?ooo`3oool0gP3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cDP3oool00`00
0000oooo0?ooo`1O0?ooo`050000003oool0oooo0?ooo`000000GP3oool00`000000oooo0?ooo`3M
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=B0?ooo``00000E`3oool300000600oooo0`00003L0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c?o0?ooooP0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cRP3oool00`00
0000oooo0?ooo`3o0?ooof/0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<hX0oooo00<000000?ooo`3oool0o`3ooom[
0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c<Q0?ooo`D000000`3ooomH000000L0oooo1@0000050?ooodP000001`3o
ool5000000H0ooooFP00002a0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c>:0?ooo`030000003oool0oooo0?l0oooo
J`3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<cRP3oool00`000000oooo0?ooo`3o0?ooof/0oooo00<0003o0?ooo`3o
ool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c
<ol0oooon03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<cIP3oool00`000000oooo0?ooo`3o0?ooohl0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<fH0oooo00<000000?ooo`3oool0>`3oool3000005H0oooo0`00003g0?ooo`030000o`3o
ool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c=U0?ooo`800000@03oool00`000000oooo0?ooo`020?ooo`8000009P3oool2000002X0oooo
00<000000?ooo`3oool00P3oool2000003P0oooo0P00002f0?ooo`030000o`3oool0oooo00<0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=T0?ooo`03
0000003oool000000400oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo0;@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<f40oooo00H000000?ooo`3oool000000?ooo`00
00060?ooo`8000009@3oool6000000<0oooo0`0000040?ooo`@00000103oool00`000000oooo0?oo
o`0:0?ooo`D000003@3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo01D0oooo1P00
00030?ooo`<00000103oool4000000@0oooo00<000000?ooo`3oool00P3oool5000000h0oooo0P00
00030?ooo`800000303oool2000000<0oooo0P0000090?ooo`030000003oool0oooo0;@0oooo00<0
003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<f80oooo0P0000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00009@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool05P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3o
ool0000000L0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool0000000X0oooo
00<000000?ooo`3oool0]03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cH`3oool01@000000oooo0?ooo`3oool00000
00L0oooo00<000000?ooo`3oool08`3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo
000000050?ooo`030000003oool0oooo01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`000000203oool00`000000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00<00000
0?ooo`3oool0]03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cI`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo1@0000050?ooo`03
0000003oool0oooo00@0oooo1@0000070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`D000001`3oool00`000000oooo0?ooo`050?ooo`D000001P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0;@0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<eP0oooo0P00000=0?ooo`030000003o
ool0oooo0080oooo00@000000?ooo`3oool000002`3oool2000001P0oooo00<000000?ooo`3oool0
103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`000000203oool00`000000oooo0?ooo`050?ooo`030000003oool0000000/0oooo00<0
00000?ooo`3oool0]03oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00<0oooo0P00000=0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0
1@3oool3000000@0oooo0`0000000`3oool000000?ooo`020?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`<0000000@0oooo000000000000
00000`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00D0oooo0`0000040?ooo`<0
000000<0oooo0000003oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0103oool3000000040?ooo`0000000000000000H0oooo00<000000?oo
o`3oool00`3oool3000000030?ooo`000000000000D000001@3oool00`000000oooo0?ooo`2d0?oo
o`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c=H0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02P3oool3
000001T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo0080oooo0`00000[0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0]03oool0
0`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool05@3oool3000001D0oooo0P00000=0?ooo`030000003oool0oooo01H0oooo0P00
000G0?ooo`<000005@3oool2000000D0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`030?ooo`800000]P3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`2j0?ooo`030000
o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c=H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`2h0?ooo`040000003oool0oooo00000;`0oooo00<0003o0?ooo`3oool00`3oool0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<eP0oooo00<00000
0?ooo`3oool03@3oool:000000X0oooo00<000000?ooo`3oool0^@3oool200000;d0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<b/0oooo0`0000001@3oool00000000000000000oooo00@00000103oool3000000<0oooo
1@0000030?ooo`<0000000<0oooo0000000000000P0000020?ooo`8000000`3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?ooo`030?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c;03oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
000000@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
o`3ooomi0?ooo`030000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00@0iNGU09VIV@2IVIT0VIVI0P0c<c</0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00<0oooo6@0000050?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?oo
o`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
;03oool5000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00<0oooo100000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0ooooN@3oool00`000?l0oooo0?ooo`030?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c;@3oool00`00
0000oooo000000040?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000004
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P0000020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3o0?ooogT0oooo00<0003o
0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<bd0oooo00<000000?ooo`0000000`3oool00`000000oooo00000002000000<0oooo0`00
00020?ooo`040000003oool0oooo00000080oooo00<000000?ooo`0000000`0000020?ooo`030000
003oool00000008000001@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0?l0oooo
N@3oool00`000?l0oooo0?ooo`030?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<c;P3oool00`000000oooo0?ooo`0?0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`050?ooo`<000000`3oool00`00
0000oooo0?ooo`04000000@0oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`3o0?oo
ogT0oooo00<0003o0?ooo`3oool00`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<b`0oooo0`00000A0?ooo`L000004@3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`030000o`3oool0oooo00<0oooo00@0
iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c=H0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3o0?ooogH0oooo10000?l50?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool0o`3ooomi0?ooo`03
0000o`3oool0oooo00<0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c=H0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0o`3ooomh
0?ooo`80003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<eP0oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P00000@0?ooo`030000003o
ool0oooo0?l0ooooM`3oool00`000?l0oooo0000o`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<cF03oool200000240oooo0P00003o0?ooogP0oooo
00@0003o0?ooo`3oool0003o1@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooom03oool01@000?l0oooo0?ooo`3oool0003o00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?oooo<0oooo1P00
0?l50?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIVOl0<c<co`0c<c<103<c<`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030>GUi@2I
VIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0>GUi@2IVIT0VIVI0?l0VIVIo`2IVIT609VIV@40iNGU0@0c<c<10?ooo`00o`3UiNGo0>GUi@/0iNGU
0@3oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 74},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S1.11.5"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to export formulas both textually and visually. You can use ",
  StyleBox["Export", "MR"],
  " to tell ",
  StyleBox["Mathematica", "TI"],
  " to write a visual representation of a formula into a file. "
}], "Text",
  CellTags->{"S1.11.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".eps\",", "MR"],
              " ",
              StyleBox["ToBoxes[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "save the visual form of ",
              StyleBox["expr", "TI"],
              " to a file in EPS format "
            }]]},
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["ToBoxes[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["format", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "save the visual form of ",
              StyleBox["expr", "TI"],
              " in the specified format "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.5"],

Cell["Exporting expressions in visual form. ", "Caption",
  CellTags->"S1.11.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.6 Generating and Importing TeX", "Subsection",
  CellTags->{"S1.11.6", "6.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " notebooks provide a sophisticated environment for creating technical \
documents. But particularly if you want to merge your work with existing \
material in TeX, you may find it convenient to use ",
  StyleBox["TeXForm", "MR"],
  " to convert expressions in ",
  StyleBox["Mathematica", "TI"],
  " into a form suitable for input to TeX.   "
}], "Text",
  CellTags->{"S1.11.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TeXForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print ",
              StyleBox["expr", "TI"],
              " in TeX input form"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.6"],

Cell[TextData[{
  StyleBox["Mathematica", "SO"],
  " output for TeX. "
}], "Caption",
  CellTags->"S1.11.6"],

Cell[TextData[{
  "Here is an expression, printed in standard ",
  StyleBox["Mathematica", "TI"],
  " form. "
}], "MathCaption",
  CellTags->{"S1.11.6", "6.3"}],

Cell[CellGroupData[{

Cell["(x + y)^2 / Sqrt[x y]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.6"],

Cell[BoxData[
    \(\((x + y)\)\^2\/\@\(x\ y\)\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.11.6"]
}, Open  ]],

Cell["Here is the expression in TeX input form. ", "MathCaption",
  CellTags->{"S1.11.6", "6.4"}],

Cell[CellGroupData[{

Cell["TeXForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.6"],

Cell["\\frac{(x+y)^2}{\\sqrt{x y}}", "Output",
  CellLabel->"Out[2]//TeXForm= ",
  CellTags->"S1.11.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToExpression[\"", "MR"],
              StyleBox["input", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["TeXForm]", "MR"],
              " "
            }]], Cell[TextData[{
              "convert TeX input to ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.6"],

Cell[TextData[{
  "Converting TeX strings to ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S1.11.6"],

Cell[TextData[{
  "This converts a TeX string to ",
  StyleBox["Mathematica", "TI"],
  ". Note the double backslashes needed in the string. "
}], "MathCaption",
  CellTags->{"S1.11.6", "6.5"}],

Cell[CellGroupData[{

Cell["ToExpression[\"\\\\sqrt{x y}\", TeXForm]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.6"],

Cell[BoxData[
    \(\@\(x\ y\)\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.11.6"]
}, Open  ]],

Cell[TextData[{
  "In addition to being able to convert individual expressions to TeX, ",
  StyleBox["Mathematica", "TI"],
  " also provides capabilities for translating complete notebooks. These \
capabilities can usually be accessed from the ",
  StyleBox["Save As Special", "SR"],
  " menu in the notebook front end, where various options can be set.  "
}], "Text",
  CellTags->{"S1.11.6", "6.6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.7 Exchanging Material with the Web", "Subsection",
  CellTags->{"S1.11.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["HTMLSave[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".html\"]", "MR"],
              " "
            }]], Cell["save your complete current notebook in HTML form "]},
          {Cell[TextData[{
              StyleBox["HTMLSave[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".html\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["source", "TI"],
              StyleBox[".nb\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "save an HTML version of the notebook ",
              StyleBox["source", "TI"],
              StyleBox[".nb", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.7"],

Cell["Converting notebooks to HTML. ", "Caption",
  CellTags->"S1.11.7"],

Cell[TextData[{
  StyleBox["HTMLSave", "MR"],
  " has many options that allow you to specify how notebooks should be \
converted for web browsers with different capabilities. You can find details \
in the Additional Information section of the online Reference Guide entry for \
",
  ButtonBox["HTMLSave",
    ButtonStyle->"RefGuideLink"],
  ". "
}], "Text",
  CellTags->{"S1.11.7", "7.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MathMLForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print ",
              StyleBox["expr", "TI"],
              " in MathML form "
            }]]},
          {Cell[TextData[{
              StyleBox["MathMLForm[StandardForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "use ",
              StyleBox["StandardForm", "MR"],
              " rather than traditional mathematical notation "
            }]]},
          {Cell[TextData[{
              StyleBox["ToExpression[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["MathMLForm]", "MR"],
              " "
            }]], Cell[TextData[{
              "interpret a string of MathML as ",
              StyleBox["Mathematica", "TI"],
              " input "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.7"],

Cell["Converting to and from MathML. ", "Caption",
  CellTags->"S1.11.7"],

Cell["Here is an expression printed in MathML form. ", "MathCaption",
  CellTags->{"S1.11.7", "7.3"}],

Cell[CellGroupData[{

Cell["MathMLForm[x^2/z]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.7"],

Cell["\<\
<math>
<mfrac>
  <msup>
    <mi>x</mi>
    <mn>2</mn>
  </msup>
  <mi>z</mi>
</mfrac>
</math>\
\>", "Output",
  CellLabel->"Out[1]//MathMLForm=",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell[TextData[{
  "If you paste MathML into a ",
  StyleBox["Mathematica", "TI"],
  " notebook, ",
  StyleBox["Mathematica", "TI"],
  " will automatically try to convert it to ",
  StyleBox["Mathematica", "TI"],
  " input. You can copy an expression from a notebook as MathML using the ",
  StyleBox["Copy As", "SR"],
  " menu in the notebook front end.   "
}], "Text",
  CellTags->{"S1.11.7", "7.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Export[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".xml\",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["export in XML format "]},
          {Cell[TextData[{
              StyleBox["Import[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".xml\"]", "MR"],
              " "
            }]], Cell["import from XML "]},
          {Cell[TextData[{
              StyleBox["ImportString[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"XML\"]", "MR"],
              " "
            }]], Cell["import data from a string of XML "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.7"],

Cell["XML importing and exporting. ", "Caption",
  CellTags->"S1.11.7"],

Cell[TextData[{
  "Somewhat like ",
  StyleBox["Mathematica", "TI"],
  " expressions, XML is a general format for representing data. ",
  StyleBox["Mathematica", "TI"],
  " automatically converts certain types of expressions to and from specific \
types of XML. MathML is one example. Other examples include NotebookML for \
notebook expressions, and SVG for graphics.    "
}], "Text",
  CellTags->{"S1.11.7", "7.5"}],

Cell[TextData[{
  "If you ask ",
  StyleBox["Mathematica", "TI"],
  " to import a generic piece of XML, it will produce a ",
  StyleBox["SymbolicXML", "TI"],
  " expression. Each XML element of the form ",
  StyleBox["<", "MR"],
  StyleBox["elem", "TI"],
  " ",
  StyleBox["attr", "TI"],
  StyleBox["='", "MR"],
  StyleBox["val", "TI"],
  StyleBox["'>", "MR"],
  StyleBox["data", "TI"],
  StyleBox["</", "MR"],
  StyleBox["elem", "TI"],
  StyleBox[">", "MR"],
  " is translated to a ",
  StyleBox["Mathematica", "TI"],
  " SymbolicXML expression of the form ",
  StyleBox["XMLElement[\"", "MR"],
  StyleBox["elem", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["{\"", "MR"],
  StyleBox["attr", "TI"],
  StyleBox["\"->\"", "MR"],
  StyleBox["val", "TI"],
  StyleBox["\"},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["data", "TI"],
  StyleBox["}]", "MR"],
  ". Once you have imported a piece of XML as SymbolicXML, you can use ",
  StyleBox["Mathematica", "TI"],
  "'s powerful symbolic programming capabilities to manipulate the expression \
you get. You can then use ",
  StyleBox["Export", "MR"],
  " to export the result in XML form.   "
}], "Text",
  CellTags->{"S1.11.7", "7.6"}],

Cell[TextData[{
  "This generates a SymbolicXML expression, with an ",
  StyleBox["XMLElement", "MR"],
  " representing the ",
  StyleBox["a", "MR"],
  " element in the XML string. "
}], "MathCaption",
  CellTags->{"S1.11.7", "7.7"}],

Cell[CellGroupData[{

Cell["ImportString[\"<a aa='va'>s</a>\", \"XML\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.7"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement["a", {"aa" \[Rule] "va"}, {"s"}], {}]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell["There are now two nested levels in the SymbolicXML. ", "MathCaption",
  CellTags->{"S1.11.7", "7.8"}],

Cell[CellGroupData[{

Cell["\<\
ImportString[ \"<a><b bb='1'>ss</b><b bb='2'>ss</b></a>\", \"XML\"]\
\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.7"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "a", {}, {XMLElement["b", {"bb" \[Rule] "1"}, {"ss"}], 
          XMLElement["b", {"bb" \[Rule] "2"}, {"ss"}]}], {}]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell["This does a simple transformation on the SymbolicXML. ", "MathCaption",
  CellTags->{"S1.11.7", "7.9"}],

Cell[CellGroupData[{

Cell["%/.\"ss\" -> XMLElement[\"c\",{},{\"xx\"}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.11.7"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "a", {}, {XMLElement[
            "b", {"bb" \[Rule] "1"}, {XMLElement["c", {}, {"xx"}]}], 
          XMLElement[
            "b", {"bb" \[Rule] "2"}, {XMLElement[
                "c", {}, {"xx"}]}]}], {}]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell["This shows the result as an XML string. ", "MathCaption",
  CellTags->{"S1.11.7", "7.10"}],

Cell[CellGroupData[{

Cell["ExportString[%, \"XML\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S1.11.7"],

Cell[BoxData[
    \("<a>\n <b bb='1'>\n  <c>xx</c>\n </b>\n <b bb='2'>\n  <c>xx</c>\n </b>\n\
</a>"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Import[\"http://", "MR"],
              StyleBox["url", "TI"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["import data from a website "]},
          {Cell[TextData[{
              StyleBox["Import[\"ftp://", "MR"],
              StyleBox["url", "TI"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["import data from an FTP server "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.7"],

Cell["Importing data from web sources. ", "Caption",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.8 Generating C and Fortran Expressions", "Subsection",
  CellTags->{"S1.11.8", "8.1"}],

Cell[TextData[{
  "If you have special\[Hyphen]purpose programs written in C or Fortran, you \
may want to take formulas you have generated in ",
  StyleBox["Mathematica", "TI"],
  " and insert them into the source code of your programs. ",
  StyleBox["Mathematica", "TI"],
  " allows you to convert mathematical expressions into C and Fortran \
expressions.   "
}], "Text",
  CellTags->{"S1.11.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write out ",
              StyleBox["expr", "TI"],
              " so it can be used in a C program "
            }]]},
          {Cell[TextData[{
              StyleBox["FortranForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "write out ",
              StyleBox["expr", "TI"],
              " for Fortran"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.8"],

Cell[TextData[{
  StyleBox["Mathematica", "SO"],
  " output for programming languages. "
}], "Caption",
  CellTags->"S1.11.8"],

Cell[TextData[{
  "Here is an expression, written out in standard ",
  StyleBox["Mathematica", "TI"],
  " form. "
}], "MathCaption",
  CellTags->{"S1.11.8", "8.3"}],

Cell[CellGroupData[{

Cell["Expand[(1 + x + y)^2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.8"],

Cell[BoxData[
    \(1 + 2\ x + x\^2 + 2\ y + 2\ x\ y + y\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S1.11.8"]
}, Open  ]],

Cell["Here is the expression in Fortran form. ", "MathCaption",
  CellTags->{"S1.11.8", "8.4"}],

Cell[CellGroupData[{

Cell["FortranForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.8"],

Cell["1 + 2*x + x**2 + 2*y + 2*x*y + y**2", "Output",
  CellLabel->"Out[2]//FortranForm= ",
  CellTags->"S1.11.8"]
}, Open  ]],

Cell[TextData[{
  "Here is the same expression in C form. Macros for objects like ",
  StyleBox["Power", "MR"],
  " are defined in the C header file ",
  StyleBox["mdefs.h", "MR"],
  " that comes with most versions of ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S1.11.8", "8.5"}],

Cell[CellGroupData[{

Cell["CForm[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.8"],

Cell["1 + 2*x + Power(x,2) + 2*y + 2*x*y + Power(y,2)", "Output",
  CellLabel->"Out[3]//CForm= ",
  CellTags->"S1.11.8"]
}, Open  ]],

Cell[TextData[{
  "You should realize that there are many differences between ",
  StyleBox["Mathematica", "TI"],
  " and C or Fortran. As a result, expressions you translate may not work \
exactly the same as they do in ",
  StyleBox["Mathematica", "TI"],
  ". In addition, there are so many differences in programming constructs \
that no attempt is made to translate these automatically. "
}], "Text",
  CellTags->{"S1.11.8", "8.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Compile[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["compile an expression into efficient internal code "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.8"],

Cell[TextData[{
  "A way to compile ",
  StyleBox["Mathematica", "SO"],
  " expressions. "
}], "Caption",
  CellTags->"S1.11.8"],

Cell[TextData[{
  "One of the common motivations for converting ",
  StyleBox["Mathematica", "TI"],
  " expressions into C or Fortran is to try to make them faster to evaluate \
numerically. But the single most important reason that C and Fortran can \
potentially be more efficient than ",
  StyleBox["Mathematica", "TI"],
  " is that in these languages one always specifies up front what type each \
variable one uses will be\[LongDash]integer, real number, array, and so on.   \
"
}], "Text",
  CellTags->{"S1.11.8", "8.7"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Compile", "MR"],
  " makes such assumptions within ",
  StyleBox["Mathematica", "TI"],
  ", and generates highly efficient internal code. Usually this code runs not \
much if at all slower than custom C or Fortran. "
}], "Text",
  CellTags->{"S1.11.8", "8.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.11.9 Splicing ",
  StyleBox["Mathematica", "SBO"],
  " Output into External Files"
}], "Subsection",
  CellTags->{"S1.11.9", "9.1"}],

Cell[TextData[{
  "If you want to make use of ",
  StyleBox["Mathematica", "TI"],
  " output in an external file such as a program or document, you will often \
find it useful to \[OpenCurlyDoubleQuote]splice\[CloseCurlyDoubleQuote] the \
output automatically into the file.  "
}], "Text",
  CellTags->{"S1.11.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Splice[\"", "MR"],
              StyleBox["file", "TI"],
              StyleBox[".m", "MR"],
              StyleBox["x", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "splice ",
              StyleBox["Mathematica", "TI"],
              " output into an external file named ",
              StyleBox["file", "TI"],
              StyleBox[".m", "MR"],
              StyleBox["x", "TI"],
              ", putting the results in the file ",
              StyleBox["file", "TI"],
              StyleBox[".", "MR"],
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Splice[\"", "MR"],
              StyleBox["infile", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["outfile", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "splice ",
              StyleBox["Mathematica", "TI"],
              " output into ",
              StyleBox["infile", "TI"],
              ", sending the output to ",
              StyleBox["outfile", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.9"],

Cell[TextData[{
  "Splicing ",
  StyleBox["Mathematica", "SO"],
  " output into files. "
}], "Caption",
  CellTags->"S1.11.9"],

Cell[TextData[{
  "The basic idea is to set up the definitions you need in a particular ",
  StyleBox["Mathematica", "TI"],
  " session, then run ",
  StyleBox["Splice", "MR"],
  " to use the definitions you have made to produce the appropriate output to \
insert into the external files. "
}], "Text",
  CellTags->{"S1.11.9", "9.3"}],

Cell[" ", "ProgramTop",
  CellTags->{"S1.11.9", "9.4"}],

Cell["\<\
#include \"mdefs.h\"

double f(x)
double x;
{
double y;

y = <* Integrate[Sin[x]^5, x] *> ;

return(2*y - 1) ;
}\
\>", "Program",
  CellTags->{"S1.11.9", "9.5"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S1.11.9", "9.6"}],

Cell[TextData[{
  "A simple C program containing a ",
  StyleBox["Mathematica", "SO"],
  " formula. "
}], "Caption",
  CellTags->"S1.11.9"],

Cell[" ", "ProgramTop",
  CellTags->{"S1.11.9", "9.7"}],

Cell["\<\
#include \"mdefs.h\"

double f(x)
double x;
{
double y;

y = -5*Cos(x)/8 + 5*Cos(3*x)/48 - Cos(5*x)/80 ;

return(2*y - 1) ;
}\
\>", "Program",
  CellTags->{"S1.11.9", "9.8"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S1.11.9", "9.9"}],

Cell[TextData[{
  "The C program after processing with ",
  StyleBox["Splice", "MR"],
  ". "
}], "Caption",
  CellTags->"S1.11.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.11.10 Running External Programs", "Subsection",
  CellTags->{"S1.11.10", "10.1"}],

Cell[TextData[{
  "Although ",
  StyleBox["Mathematica", "TI"],
  " does many things well, there are some things that are inevitably better \
done by external programs. You can use ",
  StyleBox["Mathematica", "TI"],
  " to control the external programs, or to analyze output they generate. "
}], "Text",
  CellTags->{"S1.11.10", "10.2"}],

Cell[TextData[{
  "On almost all computer systems, it is possible to run external programs \
directly from within ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " communicates with the external programs through interprocess \
communication mechanisms such as pipes. "
}], "Text",
  CellTags->{"S1.11.10", "10.3"}],

Cell[TextData[{
  "In the simplest cases, the only communication you need is to send and \
receive plain text. You can prepare input in ",
  StyleBox["Mathematica", "TI"],
  ", then give it as the standard input for the external program. Or you can \
take the standard output of the external program, and use it as input to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.11.10", "10.4"}],

Cell[TextData[{
  "In general, ",
  StyleBox["Mathematica", "TI"],
  " allows you to treat streams of data exchanged with external programs just \
like files. In place of a file name, you give the external command to run, \
prefaced by an exclamation point. "
}], "Text",
  CellTags->{"S1.11.10", "10.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["<<", "MR"],
              StyleBox["file", "TI"],
              " "
            }]], Cell["read in a file "]},
          {Cell[TextData[{
              StyleBox["<<\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[
            "run an external command, and read in the output it produces "]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox[">>", "MR"],
              " ",
              StyleBox["\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "feed the textual form of ",
              StyleBox["expr", "TI"],
              " to an external command "
            }]]},
          {Cell[TextData[{
              StyleBox["ReadList[\"!", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["Number]", "MR"],
              " "
            }]], 
            Cell["\<\
run an external command, and read in a list of the \
numbers it produces \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.10"],

Cell["Some ways to communicate with external programs. ", "Caption",
  CellTags->"S1.11.10"],

Cell[TextData[{
  "This feeds the expression ",
  StyleBox["x^2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y^2", "MR"],
  " as input to the external command ",
  StyleBox["lpr", "MR"],
  ", which, on a typical Berkeley Unix system, sends output to a printer. "
}], "MathCaption",
  CellTags->{"S1.11.10", "10.6"}],

Cell["x^2 + y^2 >> \"!lpr\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.10"],

Cell[TextData[{
  "With a text\[Hyphen]based interface, putting ",
  StyleBox["!", "MR"],
  " at the beginning of a line causes the remainder of the line to be \
executed as an external command. ",
  StyleBox["squares", "MR"],
  " is an external program which prints numbers and their squares. "
}], "MathCaption",
  CellTags->{"S1.11.10", "10.7"}],

Cell[CellGroupData[{

Cell["!squares 4", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.10"],

Cell[BoxData[
    \("1  1\n2  4\n3  9\n4  16\n"\)], "Print",
  CellTags->"S1.11.10"]
}, Open  ]],

Cell[TextData[{
  "This runs the external command ",
  StyleBox["squares", "MR"],
  " ",
  StyleBox["4", "MR"],
  ", then reads numbers from the output it produces. "
}], "MathCaption",
  CellTags->{"S1.11.10", "10.8"}],

Cell[CellGroupData[{

Cell["ReadList[\"!squares 4\", Number, RecordLists->True]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.10"],

Cell[BoxData[
    \({{1, 1}, {2, 4}, {3, 9}, {4, 16}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S1.11.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.11.11 ",
  StyleBox["MathLink", "SBO"]
}], "Subsection",
  CellTags->{"S1.11.11", "11.1"}],

Cell["\<\
The previous section discussed how to exchange plain text with \
external programs. In many cases, however, you will find it convenient to \
communicate with external programs at a higher level, and to exchange more \
structured data with them. \
\>", "Text",
  CellTags->{"S1.11.11", "11.2"}],

Cell[TextData[{
  "On almost all computer systems, ",
  StyleBox["Mathematica", "TI"],
  " supports the ",
  StyleBox["MathLink", "TI"],
  " communication standard, which allows higher\[Hyphen]level communication \
between ",
  StyleBox["Mathematica", "TI"],
  " and external programs. In order to use ",
  StyleBox["MathLink", "TI"],
  ", an external program has to include some special source code, which is \
usually distributed with ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.11.11", "11.3"}],

Cell[TextData[{
  StyleBox["MathLink", "TI"],
  " allows external programs both to call ",
  StyleBox["Mathematica", "TI"],
  ", and to be called by ",
  StyleBox["Mathematica", "TI"],
  ". Section ",
  ButtonBox["2.13",
    ButtonData:>{"2.13"},
    ButtonStyle->"MainBookLink"],
  " discusses some of the details of ",
  StyleBox["MathLink", "TI"],
  ". By using ",
  StyleBox["MathLink", "TI"],
  ", you can, for example, treat ",
  StyleBox["Mathematica", "TI"],
  " essentially like a subroutine embedded inside an external program. Or you \
can create a front end that implements your own user interface, and \
communicates with the ",
  StyleBox["Mathematica", "TI"],
  " kernel via ",
  StyleBox["MathLink", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.11.11", "11.4"}],

Cell[TextData[{
  "You can also use ",
  StyleBox["MathLink", "TI"],
  " to let ",
  StyleBox["Mathematica", "TI"],
  " call individual functions inside an external program. As described in \
Section ",
  ButtonBox["2.13",
    ButtonData:>{"2.13"},
    ButtonStyle->"MainBookLink"],
  ", you can set up a ",
  StyleBox["MathLink", "TI"],
  " template file to specify how particular functions in ",
  StyleBox["Mathematica", "TI"],
  " should call functions inside your external program. From the ",
  StyleBox["MathLink", "TI"],
  " template file, you can generate source code to include in your program. \
Then when you start your program, the appropriate ",
  StyleBox["Mathematica", "TI"],
  " definitions are automatically made, and when you call a particular ",
  StyleBox["Mathematica", "TI"],
  " function, code in your external program is executed. "
}], "Text",
  CellTags->{"S1.11.11", "11.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Install[\"", "MR"],
              StyleBox["command", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "start an external program and install ",
              StyleBox["Mathematica", "TI"],
              " definitions to call functions it contains "
            }]]},
          {Cell[TextData[{
              StyleBox["Uninstall[", "MR"],
              StyleBox["link", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
terminate an external program and uninstall definitions \
for functions in it \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S1.11.11"],

Cell["Calling functions in external programs. ", "Caption",
  CellTags->"S1.11.11"],

Cell[TextData[{
  "This starts the external program ",
  StyleBox["simul", "MR"],
  ", and installs ",
  StyleBox["Mathematica", "TI"],
  " definitions to call various functions in it. "
}], "MathCaption",
  CellTags->{"S1.11.11", "11.6"}],

Cell[CellGroupData[{

Cell["Install[\"simul\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S1.11.11"],

Cell["LinkObject[simul, 5, 4]", "Output",
  CellLabel->"Out[1]=",
  CellTags->"S1.11.11"]
}, Open  ]],

Cell[TextData[{
  "Here is a usage message for a function that was installed in ",
  StyleBox["Mathematica", "TI"],
  " to call a function in the external program. "
}], "MathCaption",
  CellTags->{"S1.11.11", "11.7"}],

Cell[CellGroupData[{

Cell["?srun", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S1.11.11"],

Cell["\<\
srun[{a, r, gamma}, x] performs a simulation with the
   specified parameters.\
\>", "Print",
  CellTags->"S1.11.11"]
}, Open  ]],

Cell["\<\
When you call this function, it executes code in the external \
program. \
\>", "MathCaption",
  CellTags->{"S1.11.11", "11.8"}],

Cell[CellGroupData[{

Cell["srun[{3, 0, 7}, 5]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S1.11.11"],

Cell["6.78124", "Output",
  CellLabel->"Out[3]=",
  CellTags->"S1.11.11"]
}, Open  ]],

Cell[TextData[{
  "This terminates the ",
  StyleBox["simul", "MR"],
  " program. "
}], "MathCaption",
  CellTags->{"S1.11.11", "11.9"}],

Cell[CellGroupData[{

Cell["Uninstall[\"simul\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S1.11.11"],

Cell["simul", "Output",
  CellLabel->"Out[4]=",
  CellTags->"S1.11.11"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["MathLink", "TI"],
  " to communicate with many types of programs, including with ",
  StyleBox["Mathematica", "TI"],
  " itself. There are versions of the ",
  StyleBox["MathLink", "TI"],
  " library for a variety of common programming languages. The ",
  StyleBox["J/Link", "TI"],
  " system provides a standard way to integrate ",
  StyleBox["Mathematica", "TI"],
  " with Java, based on ",
  StyleBox["MathLink", "TI"],
  ". With ",
  StyleBox["J/Link", "TI"],
  " you can take any Java class, and immediately make its methods accessible \
as functions in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S1.11.11", "11.10"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S1.11.0"->{
    Cell[1776, 53, 134, 4, 65, "Section",
      CellTags->{"S1.11.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 134, 4, 65, "Section",
      CellTags->{"S1.11.0", "0.1"}]},
  "S1.11.1"->{
    Cell[1935, 61, 143, 5, 70, "Subsection",
      CellTags->{"S1.11.1", "1.1"}],
    Cell[2081, 68, 604, 13, 70, "Text",
      CellTags->{"S1.11.1", "1.2"}],
    Cell[2688, 83, 1374, 45, 70, "DefinitionBox",
      CellTags->"S1.11.1"],
    Cell[4065, 130, 69, 1, 70, "Caption",
      CellTags->"S1.11.1"],
    Cell[4137, 133, 425, 15, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.3"}],
    Cell[4565, 150, 91, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[4659, 154, 209, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.4"}],
    Cell[4893, 165, 70, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[4966, 169, 69, 1, 70, "Print",
      CellTags->"S1.11.1"],
    Cell[5050, 173, 192, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.5"}],
    Cell[5267, 184, 70, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[5340, 188, 119, 3, 70, "Output",
      CellTags->"S1.11.1"],
    Cell[5474, 194, 469, 18, 70, "Text",
      CellTags->{"S1.11.1", "1.6"}],
    Cell[5946, 214, 566, 23, 70, "Text",
      CellTags->{"S1.11.1", "1.7"}],
    Cell[6515, 239, 741, 23, 70, "DefinitionBox",
      CellTags->"S1.11.1"],
    Cell[7259, 264, 82, 1, 70, "Caption",
      CellTags->"S1.11.1"],
    Cell[7344, 267, 138, 5, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.8"}],
    Cell[7485, 274, 81, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[7569, 278, 154, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.9"}],
    Cell[7748, 289, 71, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[7822, 293, 84, 3, 70, "Output",
      CellTags->"S1.11.1"],
    Cell[7921, 299, 177, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.10"}],
    Cell[8101, 308, 82, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[8186, 312, 260, 8, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.11"}],
    Cell[8471, 324, 71, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[8545, 328, 73, 5, 70, "Print",
      CellTags->"S1.11.1"],
    Cell[8633, 336, 168, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.12"}],
    Cell[8804, 345, 76, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[8883, 349, 182, 6, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.13"}],
    Cell[9090, 359, 71, 2, 70, "Input",
      CellTags->"S1.11.1"],
    Cell[9164, 363, 84, 3, 70, "Output",
      CellTags->"S1.11.1"],
    Cell[9263, 369, 1040, 32, 70, "DefinitionBox",
      CellTags->"S1.11.1"],
    Cell[10306, 403, 122, 5, 70, "Caption",
      CellTags->"S1.11.1"],
    Cell[10431, 410, 360, 9, 70, "Text",
      CellTags->{"S1.11.1", "1.14"}],
    Cell[10794, 421, 284, 9, 70, "Text",
      CellTags->{"S1.11.1", "1.15"}],
    Cell[11081, 432, 374, 9, 70, "Text",
      CellTags->{"S1.11.1", "1.16"}],
    Cell[11458, 443, 402, 10, 70, "Text",
      CellTags->{"S1.11.1", "1.17"}],
    Cell[11863, 455, 241, 6, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.18"}],
    Cell[12107, 463, 14989, 189, 70, 14853, 184, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.11.1"],
    Cell[27099, 654, 636, 15, 70, "Text",
      CellTags->{"S1.11.1", "1.19"}]},
  "1.1"->{
    Cell[1935, 61, 143, 5, 70, "Subsection",
      CellTags->{"S1.11.1", "1.1"}]},
  "1.2"->{
    Cell[2081, 68, 604, 13, 70, "Text",
      CellTags->{"S1.11.1", "1.2"}]},
  "1.3"->{
    Cell[4137, 133, 425, 15, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.3"}]},
  "1.4"->{
    Cell[4659, 154, 209, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.4"}]},
  "1.5"->{
    Cell[5050, 173, 192, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.5"}]},
  "1.6"->{
    Cell[5474, 194, 469, 18, 70, "Text",
      CellTags->{"S1.11.1", "1.6"}]},
  "1.7"->{
    Cell[5946, 214, 566, 23, 70, "Text",
      CellTags->{"S1.11.1", "1.7"}]},
  "1.8"->{
    Cell[7344, 267, 138, 5, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.8"}]},
  "1.9"->{
    Cell[7569, 278, 154, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.9"}]},
  "1.10"->{
    Cell[7921, 299, 177, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.10"}]},
  "1.11"->{
    Cell[8186, 312, 260, 8, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.11"}]},
  "1.12"->{
    Cell[8633, 336, 168, 7, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.12"}]},
  "1.13"->{
    Cell[8883, 349, 182, 6, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.13"}]},
  "1.14"->{
    Cell[10431, 410, 360, 9, 70, "Text",
      CellTags->{"S1.11.1", "1.14"}]},
  "1.15"->{
    Cell[10794, 421, 284, 9, 70, "Text",
      CellTags->{"S1.11.1", "1.15"}]},
  "1.16"->{
    Cell[11081, 432, 374, 9, 70, "Text",
      CellTags->{"S1.11.1", "1.16"}]},
  "1.17"->{
    Cell[11458, 443, 402, 10, 70, "Text",
      CellTags->{"S1.11.1", "1.17"}]},
  "1.18"->{
    Cell[11863, 455, 241, 6, 70, "MathCaption",
      CellTags->{"S1.11.1", "1.18"}]},
  "1.19"->{
    Cell[27099, 654, 636, 15, 70, "Text",
      CellTags->{"S1.11.1", "1.19"}]},
  "S1.11.2"->{
    Cell[27772, 674, 107, 1, 70, "Subsection",
      CellTags->{"S1.11.2", "2.1"}],
    Cell[27882, 677, 280, 6, 70, "Text",
      CellTags->{"S1.11.2", "2.2"}],
    Cell[28165, 685, 375, 10, 70, "Text",
      CellTags->{"S1.11.2", "2.3"}],
    Cell[28543, 697, 2893, 80, 70, "DefinitionBox",
      CellTags->"S1.11.2"],
    Cell[31439, 779, 88, 1, 70, "Caption",
      CellTags->"S1.11.2"],
    Cell[31530, 782, 165, 4, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.4"}],
    Cell[31720, 790, 77, 2, 70, "Input",
      CellTags->"S1.11.2"],
    Cell[31800, 794, 75, 2, 70, "Output",
      CellTags->"S1.11.2"],
    Cell[31890, 799, 98, 1, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.5"}],
    Cell[32013, 804, 91, 2, 70, "Input",
      CellTags->"S1.11.2"],
    Cell[32107, 808, 84, 2, 70, "Output",
      CellTags->"S1.11.2"],
    Cell[32206, 813, 202, 6, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.6"}],
    Cell[32433, 823, 87, 2, 70, "Input",
      CellTags->"S1.11.2"],
    Cell[32523, 827, 97, 2, 70, "Output",
      CellTags->"S1.11.2"],
    Cell[32635, 832, 527, 12, 70, "Text",
      CellTags->{"S1.11.2", "2.7"}],
    Cell[33165, 846, 1179, 29, 70, "Text",
      CellTags->{"S1.11.2", "2.8"}],
    Cell[34347, 877, 975, 30, 70, "DefinitionBox",
      CellTags->"S1.11.2"],
    Cell[35325, 909, 71, 1, 70, "Caption",
      CellTags->"S1.11.2"],
    Cell[35399, 912, 198, 7, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.9"}],
    Cell[35622, 923, 102, 2, 70, "Input",
      CellTags->"S1.11.2"],
    Cell[35727, 927, 185, 4, 70, "Output",
      CellTags->"S1.11.2"]},
  "2.1"->{
    Cell[27772, 674, 107, 1, 70, "Subsection",
      CellTags->{"S1.11.2", "2.1"}]},
  "2.2"->{
    Cell[27882, 677, 280, 6, 70, "Text",
      CellTags->{"S1.11.2", "2.2"}]},
  "2.3"->{
    Cell[28165, 685, 375, 10, 70, "Text",
      CellTags->{"S1.11.2", "2.3"}]},
  "2.4"->{
    Cell[31530, 782, 165, 4, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.4"}]},
  "2.5"->{
    Cell[31890, 799, 98, 1, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.5"}]},
  "2.6"->{
    Cell[32206, 813, 202, 6, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.6"}]},
  "2.7"->{
    Cell[32635, 832, 527, 12, 70, "Text",
      CellTags->{"S1.11.2", "2.7"}]},
  "2.8"->{
    Cell[33165, 846, 1179, 29, 70, "Text",
      CellTags->{"S1.11.2", "2.8"}]},
  "2.9"->{
    Cell[35399, 912, 198, 7, 70, "MathCaption",
      CellTags->{"S1.11.2", "2.9"}]},
  "S1.11.3"->{
    Cell[35961, 937, 89, 1, 70, "Subsection",
      CellTags->{"S1.11.3", "3.1"}],
    Cell[36053, 940, 973, 29, 70, "DefinitionBox",
      CellTags->"S1.11.3"],
    Cell[37029, 971, 80, 1, 70, "Caption",
      CellTags->"S1.11.3"],
    Cell[37112, 974, 153, 5, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.2"}],
    Cell[37290, 983, 111, 2, 70, "Input",
      CellTags->"S1.11.3"],
    Cell[37404, 987, 91, 3, 70, "Output",
      CellTags->"S1.11.3"],
    Cell[37510, 993, 142, 5, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.3"}],
    Cell[37677, 1002, 74, 2, 70, "Input",
      CellTags->"S1.11.3"],
    Cell[37754, 1006, 96, 4, 70, "Print",
      CellTags->"S1.11.3"],
    Cell[37865, 1013, 156, 5, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.4"}],
    Cell[38046, 1022, 95, 2, 70, "Input",
      CellTags->"S1.11.3"],
    Cell[38144, 1026, 152, 4, 70, "Output",
      CellTags->"S1.11.3"],
    Cell[38311, 1033, 624, 21, 70, "Text",
      CellTags->{"S1.11.3", "3.5"}],
    Cell[38938, 1056, 944, 26, 70, "DefinitionBox",
      CellTags->"S1.11.3"],
    Cell[39885, 1084, 80, 1, 70, "Caption",
      CellTags->"S1.11.3"],
    Cell[39968, 1087, 1108, 34, 70, "DefinitionBox",
      CellTags->"S1.11.3"],
    Cell[41079, 1123, 80, 1, 70, "Caption",
      CellTags->"S1.11.3"],
    Cell[41162, 1126, 942, 29, 70, "Text",
      CellTags->{"S1.11.3", "3.6"}],
    Cell[42107, 1157, 94, 1, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.7"}],
    Cell[42226, 1162, 87, 2, 70, "Input",
      CellTags->"S1.11.3"],
    Cell[42316, 1166, 178, 5, 70, "Output",
      CellTags->"S1.11.3"],
    Cell[42509, 1174, 82, 1, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.8"}],
    Cell[42616, 1179, 72, 2, 70, "Input",
      CellTags->"S1.11.3"],
    Cell[42691, 1183, 49201, 768, 70, 49127, 765, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S1.11.3"],
    Cell[91895, 1953, 178, 5, 70, "Output",
      CellTags->"S1.11.3"],
    Cell[92088, 1961, 527, 14, 70, "DefinitionBox",
      CellTags->"S1.11.3"],
    Cell[92618, 1977, 118, 4, 70, "Caption",
      CellTags->"S1.11.3"]},
  "3.1"->{
    Cell[35961, 937, 89, 1, 70, "Subsection",
      CellTags->{"S1.11.3", "3.1"}]},
  "3.2"->{
    Cell[37112, 974, 153, 5, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.2"}]},
  "3.3"->{
    Cell[37510, 993, 142, 5, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.3"}]},
  "3.4"->{
    Cell[37865, 1013, 156, 5, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.4"}]},
  "3.5"->{
    Cell[38311, 1033, 624, 21, 70, "Text",
      CellTags->{"S1.11.3", "3.5"}]},
  "3.6"->{
    Cell[41162, 1126, 942, 29, 70, "Text",
      CellTags->{"S1.11.3", "3.6"}]},
  "3.7"->{
    Cell[42107, 1157, 94, 1, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.7"}]},
  "3.8"->{
    Cell[42509, 1174, 82, 1, 70, "MathCaption",
      CellTags->{"S1.11.3", "3.8"}]},
  "S1.11.4"->{
    Cell[92773, 1986, 90, 1, 70, "Subsection",
      CellTags->{"S1.11.4", "4.1"}],
    Cell[92866, 1989, 412, 9, 70, "Text",
      CellTags->{"S1.11.4", "4.2"}],
    Cell[93281, 2000, 1573, 47, 70, "DefinitionBox",
      CellTags->"S1.11.4"],
    Cell[94857, 2049, 129, 5, 70, "Caption",
      CellTags->"S1.11.4"],
    Cell[94989, 2056, 1088, 34, 70, "DefinitionBox",
      CellTags->"S1.11.4"],
    Cell[96080, 2092, 253, 7, 70, "Caption",
      CellTags->"S1.11.4"],
    Cell[96336, 2101, 78, 1, 70, "MathCaption",
      CellTags->{"S1.11.4", "4.3"}],
    Cell[96439, 2106, 106, 2, 70, "Input",
      CellTags->"S1.11.4"],
    Cell[96548, 2110, 5927, 404, 70, 5853, 401, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S1.11.4"],
    Cell[102478, 2516, 178, 5, 70, "Output",
      CellTags->"S1.11.4"],
    Cell[102671, 2524, 132, 4, 70, "MathCaption",
      CellTags->{"S1.11.4", "4.4"}],
    Cell[102828, 2532, 91, 2, 70, "Input",
      CellTags->"S1.11.4"],
    Cell[102922, 2536, 95, 3, 70, "Output",
      CellTags->"S1.11.4"]},
  "4.1"->{
    Cell[92773, 1986, 90, 1, 70, "Subsection",
      CellTags->{"S1.11.4", "4.1"}]},
  "4.2"->{
    Cell[92866, 1989, 412, 9, 70, "Text",
      CellTags->{"S1.11.4", "4.2"}]},
  "4.3"->{
    Cell[96336, 2101, 78, 1, 70, "MathCaption",
      CellTags->{"S1.11.4", "4.3"}]},
  "4.4"->{
    Cell[102671, 2524, 132, 4, 70, "MathCaption",
      CellTags->{"S1.11.4", "4.4"}]},
  "S1.11.5"->{
    Cell[103066, 2545, 94, 1, 70, "Subsection",
      CellTags->{"S1.11.5", "5.1"}],
    Cell[103163, 2548, 91, 1, 70, "MathCaption",
      CellTags->{"S1.11.5", "5.2"}],
    Cell[103257, 2551, 15427, 195, 70, 15291, 190, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.11.5"],
    Cell[118687, 2748, 168, 4, 70, "MathCaption",
      CellTags->{"S1.11.5", "5.3"}],
    Cell[118858, 2754, 156, 4, 70, "Program",
      CellTags->{"S1.11.5", "5.4"}],
    Cell[119017, 2760, 148, 4, 70, "MathCaption",
      CellTags->{"S1.11.5", "5.5"}],
    Cell[119168, 2766, 15427, 195, 70, 15291, 190, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S1.11.5"],
    Cell[134598, 2963, 311, 8, 70, "Text",
      CellTags->{"S1.11.5", "5.6"}],
    Cell[134912, 2973, 1283, 38, 70, "DefinitionBox",
      CellTags->"S1.11.5"],
    Cell[136198, 3013, 80, 1, 70, "Caption",
      CellTags->"S1.11.5"]},
  "5.1"->{
    Cell[103066, 2545, 94, 1, 70, "Subsection",
      CellTags->{"S1.11.5", "5.1"}]},
  "5.2"->{
    Cell[103163, 2548, 91, 1, 70, "MathCaption",
      CellTags->{"S1.11.5", "5.2"}]},
  "5.3"->{
    Cell[118687, 2748, 168, 4, 70, "MathCaption",
      CellTags->{"S1.11.5", "5.3"}]},
  "5.4"->{
    Cell[118858, 2754, 156, 4, 70, "Program",
      CellTags->{"S1.11.5", "5.4"}]},
  "5.5"->{
    Cell[119017, 2760, 148, 4, 70, "MathCaption",
      CellTags->{"S1.11.5", "5.5"}]},
  "5.6"->{
    Cell[134598, 2963, 311, 8, 70, "Text",
      CellTags->{"S1.11.5", "5.6"}]},
  "S1.11.6"->{
    Cell[136315, 3019, 89, 1, 70, "Subsection",
      CellTags->{"S1.11.6", "6.1"}],
    Cell[136407, 3022, 438, 10, 70, "Text",
      CellTags->{"S1.11.6", "6.2"}],
    Cell[136848, 3034, 513, 16, 70, "DefinitionBox",
      CellTags->"S1.11.6"],
    Cell[137364, 3052, 108, 4, 70, "Caption",
      CellTags->"S1.11.6"],
    Cell[137475, 3058, 160, 5, 70, "MathCaption",
      CellTags->{"S1.11.6", "6.3"}],
    Cell[137660, 3067, 86, 2, 70, "Input",
      CellTags->"S1.11.6"],
    Cell[137749, 3071, 108, 3, 70, "Output",
      CellTags->"S1.11.6"],
    Cell[137872, 3077, 97, 1, 70, "MathCaption",
      CellTags->{"S1.11.6", "6.4"}],
    Cell[137994, 3082, 75, 2, 70, "Input",
      CellTags->"S1.11.6"],
    Cell[138072, 3086, 103, 2, 70, "Output",
      CellTags->"S1.11.6"],
    Cell[138190, 3091, 570, 17, 70, "DefinitionBox",
      CellTags->"S1.11.6"],
    Cell[138763, 3110, 125, 5, 70, "Caption",
      CellTags->"S1.11.6"],
    Cell[138891, 3117, 192, 5, 70, "MathCaption",
      CellTags->{"S1.11.6", "6.5"}],
    Cell[139108, 3126, 105, 2, 70, "Input",
      CellTags->"S1.11.6"],
    Cell[139216, 3130, 92, 3, 70, "Output",
      CellTags->"S1.11.6"],
    Cell[139323, 3136, 400, 8, 70, "Text",
      CellTags->{"S1.11.6", "6.6"}]},
  "6.1"->{
    Cell[136315, 3019, 89, 1, 70, "Subsection",
      CellTags->{"S1.11.6", "6.1"}]},
  "6.2"->{
    Cell[136407, 3022, 438, 10, 70, "Text",
      CellTags->{"S1.11.6", "6.2"}]},
  "6.3"->{
    Cell[137475, 3058, 160, 5, 70, "MathCaption",
      CellTags->{"S1.11.6", "6.3"}]},
  "6.4"->{
    Cell[137872, 3077, 97, 1, 70, "MathCaption",
      CellTags->{"S1.11.6", "6.4"}]},
  "6.5"->{
    Cell[138891, 3117, 192, 5, 70, "MathCaption",
      CellTags->{"S1.11.6", "6.5"}]},
  "6.6"->{
    Cell[139323, 3136, 400, 8, 70, "Text",
      CellTags->{"S1.11.6", "6.6"}]},
  "S1.11.7"->{
    Cell[139760, 3149, 93, 1, 70, "Subsection",
      CellTags->{"S1.11.7", "7.1"}],
    Cell[139856, 3152, 958, 27, 70, "DefinitionBox",
      CellTags->"S1.11.7"],
    Cell[140817, 3181, 72, 1, 70, "Caption",
      CellTags->"S1.11.7"],
    Cell[140892, 3184, 389, 10, 70, "Text",
      CellTags->{"S1.11.7", "7.2"}],
    Cell[141284, 3196, 1279, 38, 70, "DefinitionBox",
      CellTags->"S1.11.7"],
    Cell[142566, 3236, 73, 1, 70, "Caption",
      CellTags->"S1.11.7"],
    Cell[142642, 3239, 101, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.3"}],
    Cell[142768, 3244, 82, 2, 70, "Input",
      CellTags->"S1.11.7"],
    Cell[142853, 3248, 178, 12, 70, "Output",
      CellTags->"S1.11.7"],
    Cell[143046, 3263, 401, 11, 70, "Text",
      CellTags->{"S1.11.7", "7.4"}],
    Cell[143450, 3276, 1017, 29, 70, "DefinitionBox",
      CellTags->"S1.11.7"],
    Cell[144470, 3307, 71, 1, 70, "Caption",
      CellTags->"S1.11.7"],
    Cell[144544, 3310, 417, 9, 70, "Text",
      CellTags->{"S1.11.7", "7.5"}],
    Cell[144964, 3321, 1193, 40, 70, "Text",
      CellTags->{"S1.11.7", "7.6"}],
    Cell[146160, 3363, 233, 7, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.7"}],
    Cell[146418, 3374, 108, 2, 70, "Input",
      CellTags->"S1.11.7"],
    Cell[146529, 3378, 167, 4, 70, "Output",
      CellTags->"S1.11.7"],
    Cell[146711, 3385, 107, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.8"}],
    Cell[146843, 3390, 142, 5, 70, "Input",
      CellTags->"S1.11.7"],
    Cell[146988, 3397, 255, 6, 70, "Output",
      CellTags->"S1.11.7"],
    Cell[147258, 3406, 109, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.9"}],
    Cell[147392, 3411, 107, 2, 70, "Input",
      CellTags->"S1.11.7"],
    Cell[147502, 3415, 344, 9, 70, "Output",
      CellTags->"S1.11.7"],
    Cell[147861, 3427, 96, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.10"}],
    Cell[147982, 3432, 89, 2, 70, "Input",
      CellTags->"S1.11.7"],
    Cell[148074, 3436, 161, 4, 70, "Output",
      CellTags->"S1.11.7"],
    Cell[148250, 3443, 860, 26, 70, "DefinitionBox",
      CellTags->"S1.11.7"],
    Cell[149113, 3471, 75, 1, 70, "Caption",
      CellTags->"S1.11.7"]},
  "7.1"->{
    Cell[139760, 3149, 93, 1, 70, "Subsection",
      CellTags->{"S1.11.7", "7.1"}]},
  "7.2"->{
    Cell[140892, 3184, 389, 10, 70, "Text",
      CellTags->{"S1.11.7", "7.2"}]},
  "7.3"->{
    Cell[142642, 3239, 101, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.3"}]},
  "7.4"->{
    Cell[143046, 3263, 401, 11, 70, "Text",
      CellTags->{"S1.11.7", "7.4"}]},
  "7.5"->{
    Cell[144544, 3310, 417, 9, 70, "Text",
      CellTags->{"S1.11.7", "7.5"}]},
  "7.6"->{
    Cell[144964, 3321, 1193, 40, 70, "Text",
      CellTags->{"S1.11.7", "7.6"}]},
  "7.7"->{
    Cell[146160, 3363, 233, 7, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.7"}]},
  "7.8"->{
    Cell[146711, 3385, 107, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.8"}]},
  "7.9"->{
    Cell[147258, 3406, 109, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.9"}]},
  "7.10"->{
    Cell[147861, 3427, 96, 1, 70, "MathCaption",
      CellTags->{"S1.11.7", "7.10"}]},
  "S1.11.8"->{
    Cell[149225, 3477, 97, 1, 70, "Subsection",
      CellTags->{"S1.11.8", "8.1"}],
    Cell[149325, 3480, 406, 9, 70, "Text",
      CellTags->{"S1.11.8", "8.2"}],
    Cell[149734, 3491, 841, 26, 70, "DefinitionBox",
      CellTags->"S1.11.8"],
    Cell[150578, 3519, 126, 4, 70, "Caption",
      CellTags->"S1.11.8"],
    Cell[150707, 3525, 164, 5, 70, "MathCaption",
      CellTags->{"S1.11.8", "8.3"}],
    Cell[150896, 3534, 86, 2, 70, "Input",
      CellTags->"S1.11.8"],
    Cell[150985, 3538, 121, 3, 70, "Output",
      CellTags->"S1.11.8"],
    Cell[151121, 3544, 95, 1, 70, "MathCaption",
      CellTags->{"S1.11.8", "8.4"}],
    Cell[151241, 3549, 79, 2, 70, "Input",
      CellTags->"S1.11.8"],
    Cell[151323, 3553, 114, 2, 70, "Output",
      CellTags->"S1.11.8"],
    Cell[151452, 3558, 311, 9, 70, "MathCaption",
      CellTags->{"S1.11.8", "8.5"}],
    Cell[151788, 3571, 73, 2, 70, "Input",
      CellTags->"S1.11.8"],
    Cell[151864, 3575, 120, 2, 70, "Output",
      CellTags->"S1.11.8"],
    Cell[151999, 3580, 436, 9, 70, "Text",
      CellTags->{"S1.11.8", "8.6"}],
    Cell[152438, 3591, 533, 15, 70, "DefinitionBox",
      CellTags->"S1.11.8"],
    Cell[152974, 3608, 128, 5, 70, "Caption",
      CellTags->"S1.11.8"],
    Cell[153105, 3615, 527, 11, 70, "Text",
      CellTags->{"S1.11.8", "8.7"}],
    Cell[153635, 3628, 347, 10, 70, "Text",
      CellTags->{"S1.11.8", "8.8"}]},
  "8.1"->{
    Cell[149225, 3477, 97, 1, 70, "Subsection",
      CellTags->{"S1.11.8", "8.1"}]},
  "8.2"->{
    Cell[149325, 3480, 406, 9, 70, "Text",
      CellTags->{"S1.11.8", "8.2"}]},
  "8.3"->{
    Cell[150707, 3525, 164, 5, 70, "MathCaption",
      CellTags->{"S1.11.8", "8.3"}]},
  "8.4"->{
    Cell[151121, 3544, 95, 1, 70, "MathCaption",
      CellTags->{"S1.11.8", "8.4"}]},
  "8.5"->{
    Cell[151452, 3558, 311, 9, 70, "MathCaption",
      CellTags->{"S1.11.8", "8.5"}]},
  "8.6"->{
    Cell[151999, 3580, 436, 9, 70, "Text",
      CellTags->{"S1.11.8", "8.6"}]},
  "8.7"->{
    Cell[153105, 3615, 527, 11, 70, "Text",
      CellTags->{"S1.11.8", "8.7"}]},
  "8.8"->{
    Cell[153635, 3628, 347, 10, 70, "Text",
      CellTags->{"S1.11.8", "8.8"}]},
  "S1.11.9"->{
    Cell[154019, 3643, 153, 5, 70, "Subsection",
      CellTags->{"S1.11.9", "9.1"}],
    Cell[154175, 3650, 321, 7, 70, "Text",
      CellTags->{"S1.11.9", "9.2"}],
    Cell[154499, 3659, 1492, 44, 70, "DefinitionBox",
      CellTags->"S1.11.9"],
    Cell[155994, 3705, 126, 5, 70, "Caption",
      CellTags->"S1.11.9"],
    Cell[156123, 3712, 334, 8, 70, "Text",
      CellTags->{"S1.11.9", "9.3"}],
    Cell[156460, 3722, 55, 1, 70, "ProgramTop",
      CellTags->{"S1.11.9", "9.4"}],
    Cell[156518, 3725, 171, 13, 70, "Program",
      CellTags->{"S1.11.9", "9.5"}],
    Cell[156692, 3740, 58, 1, 70, "ProgramBottom",
      CellTags->{"S1.11.9", "9.6"}],
    Cell[156753, 3743, 139, 5, 70, "Caption",
      CellTags->"S1.11.9"],
    Cell[156895, 3750, 55, 1, 70, "ProgramTop",
      CellTags->{"S1.11.9", "9.7"}],
    Cell[156953, 3753, 184, 13, 70, "Program",
      CellTags->{"S1.11.9", "9.8"}],
    Cell[157140, 3768, 58, 1, 70, "ProgramBottom",
      CellTags->{"S1.11.9", "9.9"}],
    Cell[157201, 3771, 130, 5, 70, "Caption",
      CellTags->"S1.11.9"]},
  "9.1"->{
    Cell[154019, 3643, 153, 5, 70, "Subsection",
      CellTags->{"S1.11.9", "9.1"}]},
  "9.2"->{
    Cell[154175, 3650, 321, 7, 70, "Text",
      CellTags->{"S1.11.9", "9.2"}]},
  "9.3"->{
    Cell[156123, 3712, 334, 8, 70, "Text",
      CellTags->{"S1.11.9", "9.3"}]},
  "9.4"->{
    Cell[156460, 3722, 55, 1, 70, "ProgramTop",
      CellTags->{"S1.11.9", "9.4"}]},
  "9.5"->{
    Cell[156518, 3725, 171, 13, 70, "Program",
      CellTags->{"S1.11.9", "9.5"}]},
  "9.6"->{
    Cell[156692, 3740, 58, 1, 70, "ProgramBottom",
      CellTags->{"S1.11.9", "9.6"}]},
  "9.7"->{
    Cell[156895, 3750, 55, 1, 70, "ProgramTop",
      CellTags->{"S1.11.9", "9.7"}]},
  "9.8"->{
    Cell[156953, 3753, 184, 13, 70, "Program",
      CellTags->{"S1.11.9", "9.8"}]},
  "9.9"->{
    Cell[157140, 3768, 58, 1, 70, "ProgramBottom",
      CellTags->{"S1.11.9", "9.9"}]},
  "S1.11.10"->{
    Cell[157368, 3781, 89, 1, 70, "Subsection",
      CellTags->{"S1.11.10", "10.1"}],
    Cell[157460, 3784, 338, 8, 70, "Text",
      CellTags->{"S1.11.10", "10.2"}],
    Cell[157801, 3794, 345, 9, 70, "Text",
      CellTags->{"S1.11.10", "10.3"}],
    Cell[158149, 3805, 412, 9, 70, "Text",
      CellTags->{"S1.11.10", "10.4"}],
    Cell[158564, 3816, 305, 7, 70, "Text",
      CellTags->{"S1.11.10", "10.5"}],
    Cell[158872, 3825, 1425, 44, 70, "DefinitionBox",
      CellTags->"S1.11.10"],
    Cell[160300, 3871, 92, 1, 70, "Caption",
      CellTags->"S1.11.10"],
    Cell[160395, 3874, 328, 11, 70, "MathCaption",
      CellTags->{"S1.11.10", "10.6"}],
    Cell[160726, 3887, 87, 2, 70, "Input",
      CellTags->"S1.11.10"],
    Cell[160816, 3891, 348, 8, 70, "MathCaption",
      CellTags->{"S1.11.10", "10.7"}],
    Cell[161189, 3903, 76, 2, 70, "Input",
      CellTags->"S1.11.10"],
    Cell[161268, 3907, 84, 2, 70, "Print",
      CellTags->"S1.11.10"],
    Cell[161367, 3912, 219, 7, 70, "MathCaption",
      CellTags->{"S1.11.10", "10.8"}],
    Cell[161611, 3923, 117, 2, 70, "Input",
      CellTags->"S1.11.10"],
    Cell[161731, 3927, 116, 3, 70, "Output",
      CellTags->"S1.11.10"]},
  "10.1"->{
    Cell[157368, 3781, 89, 1, 70, "Subsection",
      CellTags->{"S1.11.10", "10.1"}]},
  "10.2"->{
    Cell[157460, 3784, 338, 8, 70, "Text",
      CellTags->{"S1.11.10", "10.2"}]},
  "10.3"->{
    Cell[157801, 3794, 345, 9, 70, "Text",
      CellTags->{"S1.11.10", "10.3"}]},
  "10.4"->{
    Cell[158149, 3805, 412, 9, 70, "Text",
      CellTags->{"S1.11.10", "10.4"}]},
  "10.5"->{
    Cell[158564, 3816, 305, 7, 70, "Text",
      CellTags->{"S1.11.10", "10.5"}]},
  "10.6"->{
    Cell[160395, 3874, 328, 11, 70, "MathCaption",
      CellTags->{"S1.11.10", "10.6"}]},
  "10.7"->{
    Cell[160816, 3891, 348, 8, 70, "MathCaption",
      CellTags->{"S1.11.10", "10.7"}]},
  "10.8"->{
    Cell[161367, 3912, 219, 7, 70, "MathCaption",
      CellTags->{"S1.11.10", "10.8"}]},
  "S1.11.11"->{
    Cell[161896, 3936, 111, 4, 70, "Subsection",
      CellTags->{"S1.11.11", "11.1"}],
    Cell[162010, 3942, 303, 6, 70, "Text",
      CellTags->{"S1.11.11", "11.2"}],
    Cell[162316, 3950, 525, 15, 70, "Text",
      CellTags->{"S1.11.11", "11.3"}],
    Cell[162844, 3967, 775, 24, 104, "Text",
      CellTags->{"S1.11.11", "11.4"}],
    Cell[163622, 3993, 904, 23, 70, "Text",
      CellTags->{"S1.11.11", "11.5"}],
    Cell[164529, 4018, 874, 26, 102, "DefinitionBox",
      CellTags->"S1.11.11"],
    Cell[165406, 4046, 83, 1, 16, "Caption",
      CellTags->"S1.11.11"],
    Cell[165492, 4049, 239, 7, 56, "MathCaption",
      CellTags->{"S1.11.11", "11.6"}],
    Cell[165756, 4060, 84, 2, 28, "Input",
      CellTags->"S1.11.11"],
    Cell[165843, 4064, 89, 2, 27, "Output",
      CellTags->"S1.11.11"],
    Cell[165947, 4069, 218, 5, 56, "MathCaption",
      CellTags->{"S1.11.11", "11.7"}],
    Cell[166190, 4078, 71, 2, 28, "Input",
      CellTags->"S1.11.11"],
    Cell[166264, 4082, 127, 4, 36, "Print",
      CellTags->"S1.11.11"],
    Cell[166406, 4089, 138, 4, 40, "MathCaption",
      CellTags->{"S1.11.11", "11.8"}],
    Cell[166569, 4097, 84, 2, 28, "Input",
      CellTags->"S1.11.11"],
    Cell[166656, 4101, 73, 2, 27, "Output",
      CellTags->"S1.11.11"],
    Cell[166744, 4106, 136, 5, 40, "MathCaption",
      CellTags->{"S1.11.11", "11.9"}],
    Cell[166905, 4115, 86, 2, 28, "Input",
      CellTags->"S1.11.11"],
    Cell[166994, 4119, 71, 2, 27, "Output",
      CellTags->"S1.11.11"],
    Cell[167080, 4124, 694, 20, 88, "Text",
      CellTags->{"S1.11.11", "11.10"}]},
  "11.1"->{
    Cell[161896, 3936, 111, 4, 70, "Subsection",
      CellTags->{"S1.11.11", "11.1"}]},
  "11.2"->{
    Cell[162010, 3942, 303, 6, 70, "Text",
      CellTags->{"S1.11.11", "11.2"}]},
  "11.3"->{
    Cell[162316, 3950, 525, 15, 70, "Text",
      CellTags->{"S1.11.11", "11.3"}]},
  "11.4"->{
    Cell[162844, 3967, 775, 24, 104, "Text",
      CellTags->{"S1.11.11", "11.4"}]},
  "11.5"->{
    Cell[163622, 3993, 904, 23, 70, "Text",
      CellTags->{"S1.11.11", "11.5"}]},
  "11.6"->{
    Cell[165492, 4049, 239, 7, 56, "MathCaption",
      CellTags->{"S1.11.11", "11.6"}]},
  "11.7"->{
    Cell[165947, 4069, 218, 5, 56, "MathCaption",
      CellTags->{"S1.11.11", "11.7"}]},
  "11.8"->{
    Cell[166406, 4089, 138, 4, 40, "MathCaption",
      CellTags->{"S1.11.11", "11.8"}]},
  "11.9"->{
    Cell[166744, 4106, 136, 5, 40, "MathCaption",
      CellTags->{"S1.11.11", "11.9"}]},
  "11.10"->{
    Cell[167080, 4124, 694, 20, 88, "Text",
      CellTags->{"S1.11.11", "11.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S1.11.0", 168418, 4164},
  {"0.1", 168509, 4167},
  {"S1.11.1", 168604, 4170},
  {"1.1", 171723, 4253},
  {"1.2", 171817, 4256},
  {"1.3", 171906, 4259},
  {"1.4", 172003, 4262},
  {"1.5", 172099, 4265},
  {"1.6", 172195, 4268},
  {"1.7", 172285, 4271},
  {"1.8", 172375, 4274},
  {"1.9", 172471, 4277},
  {"1.10", 172568, 4280},
  {"1.11", 172666, 4283},
  {"1.12", 172764, 4286},
  {"1.13", 172862, 4289},
  {"1.14", 172960, 4292},
  {"1.15", 173052, 4295},
  {"1.16", 173144, 4298},
  {"1.17", 173236, 4301},
  {"1.18", 173329, 4304},
  {"1.19", 173428, 4307},
  {"S1.11.2", 173524, 4310},
  {"2.1", 175134, 4353},
  {"2.2", 175230, 4356},
  {"2.3", 175320, 4359},
  {"2.4", 175411, 4362},
  {"2.5", 175508, 4365},
  {"2.6", 175604, 4368},
  {"2.7", 175701, 4371},
  {"2.8", 175792, 4374},
  {"2.9", 175884, 4377},
  {"S1.11.3", 175985, 4380},
  {"3.1", 178135, 4437},
  {"3.2", 178230, 4440},
  {"3.3", 178327, 4443},
  {"3.4", 178424, 4446},
  {"3.5", 178522, 4449},
  {"3.6", 178614, 4452},
  {"3.7", 178706, 4455},
  {"3.8", 178803, 4458},
  {"S1.11.4", 178904, 4461},
  {"4.1", 179999, 4490},
  {"4.2", 180095, 4493},
  {"4.3", 180186, 4496},
  {"4.4", 180283, 4499},
  {"S1.11.5", 180386, 4502},
  {"5.1", 181355, 4527},
  {"5.2", 181452, 4530},
  {"5.3", 181550, 4533},
  {"5.4", 181649, 4536},
  {"5.5", 181744, 4539},
  {"5.6", 181843, 4542},
  {"S1.11.6", 181939, 4545},
  {"6.1", 183199, 4578},
  {"6.2", 183296, 4581},
  {"6.3", 183389, 4584},
  {"6.4", 183488, 4587},
  {"6.5", 183586, 4590},
  {"6.6", 183685, 4593},
  {"S1.11.7", 183781, 4596},
  {"7.1", 185979, 4653},
  {"7.2", 186076, 4656},
  {"7.3", 186169, 4659},
  {"7.4", 186268, 4662},
  {"7.5", 186361, 4665},
  {"7.6", 186453, 4668},
  {"7.7", 186547, 4671},
  {"7.8", 186646, 4674},
  {"7.9", 186745, 4677},
  {"7.10", 186845, 4680},
  {"S1.11.8", 186948, 4683},
  {"8.1", 188369, 4720},
  {"8.2", 188466, 4723},
  {"8.3", 188558, 4726},
  {"8.4", 188657, 4729},
  {"8.5", 188755, 4732},
  {"8.6", 188854, 4735},
  {"8.7", 188946, 4738},
  {"8.8", 189039, 4741},
  {"S1.11.9", 189136, 4744},
  {"9.1", 190212, 4771},
  {"9.2", 190310, 4774},
  {"9.3", 190402, 4777},
  {"9.4", 190494, 4780},
  {"9.5", 190591, 4783},
  {"9.6", 190687, 4786},
  {"9.7", 190787, 4789},
  {"9.8", 190884, 4792},
  {"9.9", 190980, 4795},
  {"S1.11.10", 191085, 4798},
  {"10.1", 192301, 4829},
  {"10.2", 192401, 4832},
  {"10.3", 192496, 4835},
  {"10.4", 192591, 4838},
  {"10.5", 192686, 4841},
  {"10.6", 192781, 4844},
  {"10.7", 192884, 4847},
  {"10.8", 192986, 4850},
  {"S1.11.11", 193092, 4853},
  {"11.1", 194702, 4894},
  {"11.2", 194803, 4897},
  {"11.3", 194898, 4900},
  {"11.4", 194994, 4903},
  {"11.5", 195091, 4906},
  {"11.6", 195187, 4909},
  {"11.7", 195289, 4912},
  {"11.8", 195391, 4915},
  {"11.9", 195493, 4918},
  {"11.10", 195596, 4921}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 134, 4, 65, "Section",
  CellTags->{"S1.11.0", "0.1"}],

Cell[CellGroupData[{
Cell[1935, 61, 143, 5, 70, "Subsection",
  CellTags->{"S1.11.1", "1.1"}],
Cell[2081, 68, 604, 13, 70, "Text",
  CellTags->{"S1.11.1", "1.2"}],
Cell[2688, 83, 1374, 45, 70, "DefinitionBox",
  CellTags->"S1.11.1"],
Cell[4065, 130, 69, 1, 70, "Caption",
  CellTags->"S1.11.1"],
Cell[4137, 133, 425, 15, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.3"}],
Cell[4565, 150, 91, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[4659, 154, 209, 7, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.4"}],

Cell[CellGroupData[{
Cell[4893, 165, 70, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[4966, 169, 69, 1, 70, "Print",
  CellTags->"S1.11.1"]
}, Open  ]],
Cell[5050, 173, 192, 7, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.5"}],

Cell[CellGroupData[{
Cell[5267, 184, 70, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[5340, 188, 119, 3, 70, "Output",
  CellTags->"S1.11.1"]
}, Open  ]],
Cell[5474, 194, 469, 18, 70, "Text",
  CellTags->{"S1.11.1", "1.6"}],
Cell[5946, 214, 566, 23, 70, "Text",
  CellTags->{"S1.11.1", "1.7"}],
Cell[6515, 239, 741, 23, 70, "DefinitionBox",
  CellTags->"S1.11.1"],
Cell[7259, 264, 82, 1, 70, "Caption",
  CellTags->"S1.11.1"],
Cell[7344, 267, 138, 5, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.8"}],
Cell[7485, 274, 81, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[7569, 278, 154, 7, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.9"}],

Cell[CellGroupData[{
Cell[7748, 289, 71, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[7822, 293, 84, 3, 70, "Output",
  CellTags->"S1.11.1"]
}, Open  ]],
Cell[7921, 299, 177, 7, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.10"}],
Cell[8101, 308, 82, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[8186, 312, 260, 8, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.11"}],

Cell[CellGroupData[{
Cell[8471, 324, 71, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[8545, 328, 73, 5, 70, "Print",
  CellTags->"S1.11.1"]
}, Open  ]],
Cell[8633, 336, 168, 7, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.12"}],
Cell[8804, 345, 76, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[8883, 349, 182, 6, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.13"}],

Cell[CellGroupData[{
Cell[9090, 359, 71, 2, 70, "Input",
  CellTags->"S1.11.1"],
Cell[9164, 363, 84, 3, 70, "Output",
  CellTags->"S1.11.1"]
}, Open  ]],
Cell[9263, 369, 1040, 32, 70, "DefinitionBox",
  CellTags->"S1.11.1"],
Cell[10306, 403, 122, 5, 70, "Caption",
  CellTags->"S1.11.1"],
Cell[10431, 410, 360, 9, 70, "Text",
  CellTags->{"S1.11.1", "1.14"}],
Cell[10794, 421, 284, 9, 70, "Text",
  CellTags->{"S1.11.1", "1.15"}],
Cell[11081, 432, 374, 9, 70, "Text",
  CellTags->{"S1.11.1", "1.16"}],
Cell[11458, 443, 402, 10, 70, "Text",
  CellTags->{"S1.11.1", "1.17"}],
Cell[11863, 455, 241, 6, 70, "MathCaption",
  CellTags->{"S1.11.1", "1.18"}],
Cell[12107, 463, 14989, 189, 70, 14853, 184, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.11.1"],
Cell[27099, 654, 636, 15, 70, "Text",
  CellTags->{"S1.11.1", "1.19"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27772, 674, 107, 1, 70, "Subsection",
  CellTags->{"S1.11.2", "2.1"}],
Cell[27882, 677, 280, 6, 70, "Text",
  CellTags->{"S1.11.2", "2.2"}],
Cell[28165, 685, 375, 10, 70, "Text",
  CellTags->{"S1.11.2", "2.3"}],
Cell[28543, 697, 2893, 80, 70, "DefinitionBox",
  CellTags->"S1.11.2"],
Cell[31439, 779, 88, 1, 70, "Caption",
  CellTags->"S1.11.2"],
Cell[31530, 782, 165, 4, 70, "MathCaption",
  CellTags->{"S1.11.2", "2.4"}],

Cell[CellGroupData[{
Cell[31720, 790, 77, 2, 70, "Input",
  CellTags->"S1.11.2"],
Cell[31800, 794, 75, 2, 70, "Output",
  CellTags->"S1.11.2"]
}, Open  ]],
Cell[31890, 799, 98, 1, 70, "MathCaption",
  CellTags->{"S1.11.2", "2.5"}],

Cell[CellGroupData[{
Cell[32013, 804, 91, 2, 70, "Input",
  CellTags->"S1.11.2"],
Cell[32107, 808, 84, 2, 70, "Output",
  CellTags->"S1.11.2"]
}, Open  ]],
Cell[32206, 813, 202, 6, 70, "MathCaption",
  CellTags->{"S1.11.2", "2.6"}],

Cell[CellGroupData[{
Cell[32433, 823, 87, 2, 70, "Input",
  CellTags->"S1.11.2"],
Cell[32523, 827, 97, 2, 70, "Output",
  CellTags->"S1.11.2"]
}, Open  ]],
Cell[32635, 832, 527, 12, 70, "Text",
  CellTags->{"S1.11.2", "2.7"}],
Cell[33165, 846, 1179, 29, 70, "Text",
  CellTags->{"S1.11.2", "2.8"}],
Cell[34347, 877, 975, 30, 70, "DefinitionBox",
  CellTags->"S1.11.2"],
Cell[35325, 909, 71, 1, 70, "Caption",
  CellTags->"S1.11.2"],
Cell[35399, 912, 198, 7, 70, "MathCaption",
  CellTags->{"S1.11.2", "2.9"}],

Cell[CellGroupData[{
Cell[35622, 923, 102, 2, 70, "Input",
  CellTags->"S1.11.2"],
Cell[35727, 927, 185, 4, 70, "Output",
  CellTags->"S1.11.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35961, 937, 89, 1, 70, "Subsection",
  CellTags->{"S1.11.3", "3.1"}],
Cell[36053, 940, 973, 29, 70, "DefinitionBox",
  CellTags->"S1.11.3"],
Cell[37029, 971, 80, 1, 70, "Caption",
  CellTags->"S1.11.3"],
Cell[37112, 974, 153, 5, 70, "MathCaption",
  CellTags->{"S1.11.3", "3.2"}],

Cell[CellGroupData[{
Cell[37290, 983, 111, 2, 70, "Input",
  CellTags->"S1.11.3"],
Cell[37404, 987, 91, 3, 70, "Output",
  CellTags->"S1.11.3"]
}, Open  ]],
Cell[37510, 993, 142, 5, 70, "MathCaption",
  CellTags->{"S1.11.3", "3.3"}],

Cell[CellGroupData[{
Cell[37677, 1002, 74, 2, 70, "Input",
  CellTags->"S1.11.3"],
Cell[37754, 1006, 96, 4, 70, "Print",
  CellTags->"S1.11.3"]
}, Open  ]],
Cell[37865, 1013, 156, 5, 70, "MathCaption",
  CellTags->{"S1.11.3", "3.4"}],

Cell[CellGroupData[{
Cell[38046, 1022, 95, 2, 70, "Input",
  CellTags->"S1.11.3"],
Cell[38144, 1026, 152, 4, 70, "Output",
  CellTags->"S1.11.3"]
}, Open  ]],
Cell[38311, 1033, 624, 21, 70, "Text",
  CellTags->{"S1.11.3", "3.5"}],
Cell[38938, 1056, 944, 26, 70, "DefinitionBox",
  CellTags->"S1.11.3"],
Cell[39885, 1084, 80, 1, 70, "Caption",
  CellTags->"S1.11.3"],
Cell[39968, 1087, 1108, 34, 70, "DefinitionBox",
  CellTags->"S1.11.3"],
Cell[41079, 1123, 80, 1, 70, "Caption",
  CellTags->"S1.11.3"],
Cell[41162, 1126, 942, 29, 70, "Text",
  CellTags->{"S1.11.3", "3.6"}],
Cell[42107, 1157, 94, 1, 70, "MathCaption",
  CellTags->{"S1.11.3", "3.7"}],

Cell[CellGroupData[{
Cell[42226, 1162, 87, 2, 70, "Input",
  CellTags->"S1.11.3"],
Cell[42316, 1166, 178, 5, 70, "Output",
  CellTags->"S1.11.3"]
}, Open  ]],
Cell[42509, 1174, 82, 1, 70, "MathCaption",
  CellTags->{"S1.11.3", "3.8"}],

Cell[CellGroupData[{
Cell[42616, 1179, 72, 2, 70, "Input",
  CellTags->"S1.11.3"],
Cell[42691, 1183, 49201, 768, 70, 49127, 765, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S1.11.3"],
Cell[91895, 1953, 178, 5, 70, "Output",
  CellTags->"S1.11.3"]
}, Open  ]],
Cell[92088, 1961, 527, 14, 70, "DefinitionBox",
  CellTags->"S1.11.3"],
Cell[92618, 1977, 118, 4, 70, "Caption",
  CellTags->"S1.11.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[92773, 1986, 90, 1, 70, "Subsection",
  CellTags->{"S1.11.4", "4.1"}],
Cell[92866, 1989, 412, 9, 70, "Text",
  CellTags->{"S1.11.4", "4.2"}],
Cell[93281, 2000, 1573, 47, 70, "DefinitionBox",
  CellTags->"S1.11.4"],
Cell[94857, 2049, 129, 5, 70, "Caption",
  CellTags->"S1.11.4"],
Cell[94989, 2056, 1088, 34, 70, "DefinitionBox",
  CellTags->"S1.11.4"],
Cell[96080, 2092, 253, 7, 70, "Caption",
  CellTags->"S1.11.4"],
Cell[96336, 2101, 78, 1, 70, "MathCaption",
  CellTags->{"S1.11.4", "4.3"}],

Cell[CellGroupData[{
Cell[96439, 2106, 106, 2, 70, "Input",
  CellTags->"S1.11.4"],
Cell[96548, 2110, 5927, 404, 70, 5853, 401, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S1.11.4"],
Cell[102478, 2516, 178, 5, 70, "Output",
  CellTags->"S1.11.4"]
}, Open  ]],
Cell[102671, 2524, 132, 4, 70, "MathCaption",
  CellTags->{"S1.11.4", "4.4"}],

Cell[CellGroupData[{
Cell[102828, 2532, 91, 2, 70, "Input",
  CellTags->"S1.11.4"],
Cell[102922, 2536, 95, 3, 70, "Output",
  CellTags->"S1.11.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103066, 2545, 94, 1, 70, "Subsection",
  CellTags->{"S1.11.5", "5.1"}],
Cell[103163, 2548, 91, 1, 70, "MathCaption",
  CellTags->{"S1.11.5", "5.2"}],
Cell[103257, 2551, 15427, 195, 70, 15291, 190, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.11.5"],
Cell[118687, 2748, 168, 4, 70, "MathCaption",
  CellTags->{"S1.11.5", "5.3"}],
Cell[118858, 2754, 156, 4, 70, "Program",
  CellTags->{"S1.11.5", "5.4"}],
Cell[119017, 2760, 148, 4, 70, "MathCaption",
  CellTags->{"S1.11.5", "5.5"}],
Cell[119168, 2766, 15427, 195, 70, 15291, 190, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S1.11.5"],
Cell[134598, 2963, 311, 8, 70, "Text",
  CellTags->{"S1.11.5", "5.6"}],
Cell[134912, 2973, 1283, 38, 70, "DefinitionBox",
  CellTags->"S1.11.5"],
Cell[136198, 3013, 80, 1, 70, "Caption",
  CellTags->"S1.11.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[136315, 3019, 89, 1, 70, "Subsection",
  CellTags->{"S1.11.6", "6.1"}],
Cell[136407, 3022, 438, 10, 70, "Text",
  CellTags->{"S1.11.6", "6.2"}],
Cell[136848, 3034, 513, 16, 70, "DefinitionBox",
  CellTags->"S1.11.6"],
Cell[137364, 3052, 108, 4, 70, "Caption",
  CellTags->"S1.11.6"],
Cell[137475, 3058, 160, 5, 70, "MathCaption",
  CellTags->{"S1.11.6", "6.3"}],

Cell[CellGroupData[{
Cell[137660, 3067, 86, 2, 70, "Input",
  CellTags->"S1.11.6"],
Cell[137749, 3071, 108, 3, 70, "Output",
  CellTags->"S1.11.6"]
}, Open  ]],
Cell[137872, 3077, 97, 1, 70, "MathCaption",
  CellTags->{"S1.11.6", "6.4"}],

Cell[CellGroupData[{
Cell[137994, 3082, 75, 2, 70, "Input",
  CellTags->"S1.11.6"],
Cell[138072, 3086, 103, 2, 70, "Output",
  CellTags->"S1.11.6"]
}, Open  ]],
Cell[138190, 3091, 570, 17, 70, "DefinitionBox",
  CellTags->"S1.11.6"],
Cell[138763, 3110, 125, 5, 70, "Caption",
  CellTags->"S1.11.6"],
Cell[138891, 3117, 192, 5, 70, "MathCaption",
  CellTags->{"S1.11.6", "6.5"}],

Cell[CellGroupData[{
Cell[139108, 3126, 105, 2, 70, "Input",
  CellTags->"S1.11.6"],
Cell[139216, 3130, 92, 3, 70, "Output",
  CellTags->"S1.11.6"]
}, Open  ]],
Cell[139323, 3136, 400, 8, 70, "Text",
  CellTags->{"S1.11.6", "6.6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[139760, 3149, 93, 1, 70, "Subsection",
  CellTags->{"S1.11.7", "7.1"}],
Cell[139856, 3152, 958, 27, 70, "DefinitionBox",
  CellTags->"S1.11.7"],
Cell[140817, 3181, 72, 1, 70, "Caption",
  CellTags->"S1.11.7"],
Cell[140892, 3184, 389, 10, 70, "Text",
  CellTags->{"S1.11.7", "7.2"}],
Cell[141284, 3196, 1279, 38, 70, "DefinitionBox",
  CellTags->"S1.11.7"],
Cell[142566, 3236, 73, 1, 70, "Caption",
  CellTags->"S1.11.7"],
Cell[142642, 3239, 101, 1, 70, "MathCaption",
  CellTags->{"S1.11.7", "7.3"}],

Cell[CellGroupData[{
Cell[142768, 3244, 82, 2, 70, "Input",
  CellTags->"S1.11.7"],
Cell[142853, 3248, 178, 12, 70, "Output",
  CellTags->"S1.11.7"]
}, Open  ]],
Cell[143046, 3263, 401, 11, 70, "Text",
  CellTags->{"S1.11.7", "7.4"}],
Cell[143450, 3276, 1017, 29, 70, "DefinitionBox",
  CellTags->"S1.11.7"],
Cell[144470, 3307, 71, 1, 70, "Caption",
  CellTags->"S1.11.7"],
Cell[144544, 3310, 417, 9, 70, "Text",
  CellTags->{"S1.11.7", "7.5"}],
Cell[144964, 3321, 1193, 40, 70, "Text",
  CellTags->{"S1.11.7", "7.6"}],
Cell[146160, 3363, 233, 7, 70, "MathCaption",
  CellTags->{"S1.11.7", "7.7"}],

Cell[CellGroupData[{
Cell[146418, 3374, 108, 2, 70, "Input",
  CellTags->"S1.11.7"],
Cell[146529, 3378, 167, 4, 70, "Output",
  CellTags->"S1.11.7"]
}, Open  ]],
Cell[146711, 3385, 107, 1, 70, "MathCaption",
  CellTags->{"S1.11.7", "7.8"}],

Cell[CellGroupData[{
Cell[146843, 3390, 142, 5, 70, "Input",
  CellTags->"S1.11.7"],
Cell[146988, 3397, 255, 6, 70, "Output",
  CellTags->"S1.11.7"]
}, Open  ]],
Cell[147258, 3406, 109, 1, 70, "MathCaption",
  CellTags->{"S1.11.7", "7.9"}],

Cell[CellGroupData[{
Cell[147392, 3411, 107, 2, 70, "Input",
  CellTags->"S1.11.7"],
Cell[147502, 3415, 344, 9, 70, "Output",
  CellTags->"S1.11.7"]
}, Open  ]],
Cell[147861, 3427, 96, 1, 70, "MathCaption",
  CellTags->{"S1.11.7", "7.10"}],

Cell[CellGroupData[{
Cell[147982, 3432, 89, 2, 70, "Input",
  CellTags->"S1.11.7"],
Cell[148074, 3436, 161, 4, 70, "Output",
  CellTags->"S1.11.7"]
}, Open  ]],
Cell[148250, 3443, 860, 26, 70, "DefinitionBox",
  CellTags->"S1.11.7"],
Cell[149113, 3471, 75, 1, 70, "Caption",
  CellTags->"S1.11.7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[149225, 3477, 97, 1, 70, "Subsection",
  CellTags->{"S1.11.8", "8.1"}],
Cell[149325, 3480, 406, 9, 70, "Text",
  CellTags->{"S1.11.8", "8.2"}],
Cell[149734, 3491, 841, 26, 70, "DefinitionBox",
  CellTags->"S1.11.8"],
Cell[150578, 3519, 126, 4, 70, "Caption",
  CellTags->"S1.11.8"],
Cell[150707, 3525, 164, 5, 70, "MathCaption",
  CellTags->{"S1.11.8", "8.3"}],

Cell[CellGroupData[{
Cell[150896, 3534, 86, 2, 70, "Input",
  CellTags->"S1.11.8"],
Cell[150985, 3538, 121, 3, 70, "Output",
  CellTags->"S1.11.8"]
}, Open  ]],
Cell[151121, 3544, 95, 1, 70, "MathCaption",
  CellTags->{"S1.11.8", "8.4"}],

Cell[CellGroupData[{
Cell[151241, 3549, 79, 2, 70, "Input",
  CellTags->"S1.11.8"],
Cell[151323, 3553, 114, 2, 70, "Output",
  CellTags->"S1.11.8"]
}, Open  ]],
Cell[151452, 3558, 311, 9, 70, "MathCaption",
  CellTags->{"S1.11.8", "8.5"}],

Cell[CellGroupData[{
Cell[151788, 3571, 73, 2, 70, "Input",
  CellTags->"S1.11.8"],
Cell[151864, 3575, 120, 2, 70, "Output",
  CellTags->"S1.11.8"]
}, Open  ]],
Cell[151999, 3580, 436, 9, 70, "Text",
  CellTags->{"S1.11.8", "8.6"}],
Cell[152438, 3591, 533, 15, 70, "DefinitionBox",
  CellTags->"S1.11.8"],
Cell[152974, 3608, 128, 5, 70, "Caption",
  CellTags->"S1.11.8"],
Cell[153105, 3615, 527, 11, 70, "Text",
  CellTags->{"S1.11.8", "8.7"}],
Cell[153635, 3628, 347, 10, 70, "Text",
  CellTags->{"S1.11.8", "8.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[154019, 3643, 153, 5, 70, "Subsection",
  CellTags->{"S1.11.9", "9.1"}],
Cell[154175, 3650, 321, 7, 70, "Text",
  CellTags->{"S1.11.9", "9.2"}],
Cell[154499, 3659, 1492, 44, 70, "DefinitionBox",
  CellTags->"S1.11.9"],
Cell[155994, 3705, 126, 5, 70, "Caption",
  CellTags->"S1.11.9"],
Cell[156123, 3712, 334, 8, 70, "Text",
  CellTags->{"S1.11.9", "9.3"}],
Cell[156460, 3722, 55, 1, 70, "ProgramTop",
  CellTags->{"S1.11.9", "9.4"}],
Cell[156518, 3725, 171, 13, 70, "Program",
  CellTags->{"S1.11.9", "9.5"}],
Cell[156692, 3740, 58, 1, 70, "ProgramBottom",
  CellTags->{"S1.11.9", "9.6"}],
Cell[156753, 3743, 139, 5, 70, "Caption",
  CellTags->"S1.11.9"],
Cell[156895, 3750, 55, 1, 70, "ProgramTop",
  CellTags->{"S1.11.9", "9.7"}],
Cell[156953, 3753, 184, 13, 70, "Program",
  CellTags->{"S1.11.9", "9.8"}],
Cell[157140, 3768, 58, 1, 70, "ProgramBottom",
  CellTags->{"S1.11.9", "9.9"}],
Cell[157201, 3771, 130, 5, 70, "Caption",
  CellTags->"S1.11.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[157368, 3781, 89, 1, 70, "Subsection",
  CellTags->{"S1.11.10", "10.1"}],
Cell[157460, 3784, 338, 8, 70, "Text",
  CellTags->{"S1.11.10", "10.2"}],
Cell[157801, 3794, 345, 9, 70, "Text",
  CellTags->{"S1.11.10", "10.3"}],
Cell[158149, 3805, 412, 9, 70, "Text",
  CellTags->{"S1.11.10", "10.4"}],
Cell[158564, 3816, 305, 7, 70, "Text",
  CellTags->{"S1.11.10", "10.5"}],
Cell[158872, 3825, 1425, 44, 70, "DefinitionBox",
  CellTags->"S1.11.10"],
Cell[160300, 3871, 92, 1, 70, "Caption",
  CellTags->"S1.11.10"],
Cell[160395, 3874, 328, 11, 70, "MathCaption",
  CellTags->{"S1.11.10", "10.6"}],
Cell[160726, 3887, 87, 2, 70, "Input",
  CellTags->"S1.11.10"],
Cell[160816, 3891, 348, 8, 70, "MathCaption",
  CellTags->{"S1.11.10", "10.7"}],

Cell[CellGroupData[{
Cell[161189, 3903, 76, 2, 70, "Input",
  CellTags->"S1.11.10"],
Cell[161268, 3907, 84, 2, 70, "Print",
  CellTags->"S1.11.10"]
}, Open  ]],
Cell[161367, 3912, 219, 7, 70, "MathCaption",
  CellTags->{"S1.11.10", "10.8"}],

Cell[CellGroupData[{
Cell[161611, 3923, 117, 2, 70, "Input",
  CellTags->"S1.11.10"],
Cell[161731, 3927, 116, 3, 70, "Output",
  CellTags->"S1.11.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[161896, 3936, 111, 4, 70, "Subsection",
  CellTags->{"S1.11.11", "11.1"}],
Cell[162010, 3942, 303, 6, 70, "Text",
  CellTags->{"S1.11.11", "11.2"}],
Cell[162316, 3950, 525, 15, 70, "Text",
  CellTags->{"S1.11.11", "11.3"}],
Cell[162844, 3967, 775, 24, 104, "Text",
  CellTags->{"S1.11.11", "11.4"}],
Cell[163622, 3993, 904, 23, 70, "Text",
  CellTags->{"S1.11.11", "11.5"}],
Cell[164529, 4018, 874, 26, 102, "DefinitionBox",
  CellTags->"S1.11.11"],
Cell[165406, 4046, 83, 1, 16, "Caption",
  CellTags->"S1.11.11"],
Cell[165492, 4049, 239, 7, 56, "MathCaption",
  CellTags->{"S1.11.11", "11.6"}],

Cell[CellGroupData[{
Cell[165756, 4060, 84, 2, 28, "Input",
  CellTags->"S1.11.11"],
Cell[165843, 4064, 89, 2, 27, "Output",
  CellTags->"S1.11.11"]
}, Open  ]],
Cell[165947, 4069, 218, 5, 56, "MathCaption",
  CellTags->{"S1.11.11", "11.7"}],

Cell[CellGroupData[{
Cell[166190, 4078, 71, 2, 28, "Input",
  CellTags->"S1.11.11"],
Cell[166264, 4082, 127, 4, 36, "Print",
  CellTags->"S1.11.11"]
}, Open  ]],
Cell[166406, 4089, 138, 4, 40, "MathCaption",
  CellTags->{"S1.11.11", "11.8"}],

Cell[CellGroupData[{
Cell[166569, 4097, 84, 2, 28, "Input",
  CellTags->"S1.11.11"],
Cell[166656, 4101, 73, 2, 27, "Output",
  CellTags->"S1.11.11"]
}, Open  ]],
Cell[166744, 4106, 136, 5, 40, "MathCaption",
  CellTags->{"S1.11.11", "11.9"}],

Cell[CellGroupData[{
Cell[166905, 4115, 86, 2, 28, "Input",
  CellTags->"S1.11.11"],
Cell[166994, 4119, 71, 2, 27, "Output",
  CellTags->"S1.11.11"]
}, Open  ]],
Cell[167080, 4124, 694, 20, 88, "Text",
  CellTags->{"S1.11.11", "11.10"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

