(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     68166,       2676]*)
(*NotebookOutlinePosition[     98745,       3587]*)
(*  CellTagsIndexPosition[     95970,       3471]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.1 ", "HeadingNumber"],
  "Expressions"
}], "Section",
  CellTags->{"S2.1.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.1.1 Everything Is an Expression", "Subsection",
  CellTags->{"S2.1.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " handles many different kinds of things: mathematical formulas, lists and \
graphics, to name a few. Although they often look very different, ",
  StyleBox["Mathematica", "TI"],
  " represents all of these things in one uniform way. They are all ",
  StyleBox["expressions", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.1.1", "1.2"}],

Cell[TextData[{
  "A prototypical example of a ",
  StyleBox["Mathematica", "TI"],
  " expression is ",
  StyleBox["f[x,", "MR"],
  " ",
  StyleBox["y]", "MR"],
  ". You might use ",
  StyleBox["f[x,", "MR"],
  " ",
  StyleBox["y]", "MR"],
  " to represent a mathematical function ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], ",", 
              StyleBox["y",
                "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
  ". The function is named ",
  StyleBox["f", "MR"],
  ", and it has two arguments, ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.1.1", "1.3"}],

Cell[TextData[{
  "You do not always have to write expressions in the form ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". For example, ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " is also an expression. When you type in ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " converts it to the standard form ",
  StyleBox["Plus[x,", "MR"],
  " ",
  StyleBox["y]", "MR"],
  ". Then, when it prints it out again, it gives it as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.1.1", "1.4"}],

Cell[TextData[{
  "The same is true of other \[OpenCurlyDoubleQuote]operators\
\[CloseCurlyDoubleQuote], such as ",
  StyleBox["^", "MR"],
  " (",
  StyleBox["Power", "MR"],
  ") and ",
  StyleBox["/", "MR"],
  " (",
  StyleBox["Divide", "MR"],
  "). "
}], "Text",
  CellTags->{"S2.1.1", "1.5"}],

Cell[TextData[{
  "In fact, everything you type into ",
  StyleBox["Mathematica", "TI"],
  " is treated as an expression. "
}], "Text",
  CellTags->{"S2.1.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["z", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Plus[x,", "MR"],
              " ",
              StyleBox["y,", "MR"],
              " ",
              StyleBox["z]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "MR"],
              " ",
              StyleBox["y", "MR"],
              " ",
              StyleBox["z", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Times[x,", "MR"],
              " ",
              StyleBox["y,", "MR"],
              " ",
              StyleBox["z]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x^n", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Power[x,", "MR"],
              " ",
              StyleBox["n]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{a,", "MR"],
              " ",
              StyleBox["b,", "MR"],
              " ",
              StyleBox["c}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["List[a,", "MR"],
              " ",
              StyleBox["b,", "MR"],
              " ",
              StyleBox["c]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["a", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["b", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Rule[a,", "MR"],
              " ",
              StyleBox["b]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["a", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["b", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Set[a,", "MR"],
              " ",
              StyleBox["b]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.1.1"],

Cell[TextData[{
  "Some examples of ",
  StyleBox["Mathematica", "SO"],
  " expressions. "
}], "Caption",
  CellTags->"S2.1.1"],

Cell[TextData[{
  "You can see the full form of any expression by using ",
  StyleBox["FullForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.1.1", "1.7"}],

Cell["Here is an expression. ", "MathCaption",
  CellTags->{"S2.1.1", "1.8"}],

Cell[CellGroupData[{

Cell["x + y + z", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(x + y + z\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell["This is the full form of the expression. ", "MathCaption",
  CellTags->{"S2.1.1", "1.9"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[x, y, z]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[2]//FullForm= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell["Here is another expression. ", "MathCaption",
  CellTags->{"S2.1.1", "1.10"}],

Cell[CellGroupData[{

Cell["1 + x^2 + (y + z)^2", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(1 + x\^2 + \((y + z)\)\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell["Its full form has several nested pieces. ", "MathCaption",
  CellTags->{"S2.1.1", "1.11"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1, Power[x, 2], Power[Plus[y, z], 2]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[4]//FullForm= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell[TextData[{
  "The object ",
  StyleBox["f", "TI"],
  " in an expression ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " is known as the ",
  StyleBox["head", "TI"],
  " of the expression. You can extract it using ",
  StyleBox["Head[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". Particularly when you write programs in ",
  StyleBox["Mathematica", "TI"],
  ", you will often want to test the head of an expression to find out what \
kind of thing the expression is. "
}], "Text",
  CellTags->{"S2.1.1", "1.12"}],

Cell[TextData[{
  StyleBox["Head", "MR"],
  " gives the \[OpenCurlyDoubleQuote]function name\[CloseCurlyDoubleQuote] ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.1", "1.13"}],

Cell[CellGroupData[{

Cell["Head[f[x, y]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(f\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Head", "MR"],
  " gives the name of the \[OpenCurlyDoubleQuote]operator\
\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S2.1.1", "1.14"}],

Cell[CellGroupData[{

Cell["Head[a + b + c]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(Plus\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell["Everything has a head. ", "MathCaption",
  CellTags->{"S2.1.1", "1.15"}],

Cell[CellGroupData[{

Cell["Head[{a, b, c}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(List\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell["Numbers also have heads. ", "MathCaption",
  CellTags->{"S2.1.1", "1.16"}],

Cell[CellGroupData[{

Cell["Head[23432]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(Integer\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell["\<\
You can distinguish different kinds of numbers by their heads. \
\
\>", "MathCaption",
  CellTags->{"S2.1.1", "1.17"}],

Cell[CellGroupData[{

Cell["Head[345.6]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.1.1"],

Cell[BoxData[
    \(Real\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Head[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the head of an expression: the ",
              StyleBox["f", "TI"],
              " in ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FullForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "display an expression in the full form used by ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.1.1"],

Cell["Functions for manipulating expressions. ", "Caption",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.2 The Meaning of Expressions", "Subsection",
  CellTags->{"S2.1.2", "2.1"}],

Cell[TextData[{
  "The notion of expressions is a crucial unifying principle in ",
  StyleBox["Mathematica", "TI"],
  ". It is the fact that every object in ",
  StyleBox["Mathematica", "TI"],
  " has the same underlying structure that makes it possible for ",
  StyleBox["Mathematica", "TI"],
  " to cover so many areas with a comparatively small number of basic \
operations. "
}], "Text",
  CellTags->{"S2.1.2", "2.2"}],

Cell["\<\
Although all expressions have the same basic structure, there are \
many different ways that expressions can be used. Here are a few of the \
interpretations you can give to the parts of an expression.  \
\>", "Text",
  CellTags->{"S2.1.2", "2.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["meaning of ", "SO10"],
              StyleBox["f", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["meaning of ", "SO10"],
              StyleBox["x", "TI"],
              StyleBox[",  ", "SO10"],
              StyleBox["y", "TI"],
              StyleBox[",  ", "SO10"],
              Cell[BoxData[
                  \(TraditionalForm\` ... \)], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["examples", "SO10"],
              " "
            }]]},
          {Cell["Function "], Cell["arguments or parameters "], Cell[
            TextData[{
              StyleBox["Sin[x]", "MR"],
              ",  ",
              StyleBox["f[x,", "MR"],
              " ",
              StyleBox["y]", "MR"],
              " "
            }]]},
          {Cell["Command "], Cell["arguments or parameters "], Cell[
            TextData[{
              StyleBox["Expand[(x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["1)^2]", "MR"],
              " "
            }]]},
          {Cell["Operator "], Cell["operands "], Cell[TextData[{
              StyleBox["x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "MR"],
              ",  ",
              StyleBox["a", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["b", "MR"],
              " "
            }]]},
          {Cell["Head "], Cell["elements "], Cell[TextData[{
              StyleBox["{a,", "MR"],
              " ",
              StyleBox["b,", "MR"],
              " ",
              StyleBox["c}", "MR"],
              " "
            }]]},
          {Cell["Object type "], Cell["contents "], Cell[TextData[{
              StyleBox["RGBColor[r,", "MR"],
              " ",
              StyleBox["g,", "MR"],
              " ",
              StyleBox["b]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.1.2"],

Cell["Some interpretations of parts of expressions. ", "Caption",
  CellTags->"S2.1.2"],

Cell[TextData[{
  "Expressions in ",
  StyleBox["Mathematica", "TI"],
  " are often used to specify operations. So, for example, typing in ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["3", "MR"],
  " causes ",
  StyleBox["2", "MR"],
  " and ",
  StyleBox["3", "MR"],
  " to be added together, while ",
  StyleBox["Factor[x^6", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["1]", "MR"],
  " performs factorization. "
}], "Text",
  CellTags->{"S2.1.2", "2.4"}],

Cell[TextData[{
  "Perhaps an even more important use of expressions in ",
  StyleBox["Mathematica", "TI"],
  ", however, is to maintain a structure, which can then be acted on by other \
functions. An expression like ",
  StyleBox["{a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c}", "MR"],
  " does not specify an operation. It merely maintains a list structure, \
which contains a collection of three elements. Other functions, such as ",
  StyleBox["Reverse", "MR"],
  " or ",
  StyleBox["Dot", "MR"],
  ", can act on this structure. "
}], "Text",
  CellTags->{"S2.1.2", "2.5"}],

Cell[TextData[{
  "The full form of the expression ",
  StyleBox["{a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c}", "MR"],
  " is ",
  StyleBox["List[a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c]", "MR"],
  ". The head ",
  StyleBox["List", "MR"],
  " performs no operations. Instead, its purpose is to serve as a \
\[OpenCurlyDoubleQuote]tag\[CloseCurlyDoubleQuote] to specify the \
\[OpenCurlyDoubleQuote]type\[CloseCurlyDoubleQuote] of the structure. "
}], "Text",
  CellTags->{"S2.1.2", "2.6"}],

Cell[TextData[{
  "You can use expressions in ",
  StyleBox["Mathematica", "TI"],
  " to create your own structures. For example, you might want to represent \
points in three\[Hyphen]dimensional space, specified by three coordinates. \
You could give each point as ",
  StyleBox["point[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  ". The \[OpenCurlyDoubleQuote]function\[CloseCurlyDoubleQuote] ",
  StyleBox["point", "MR"],
  " again performs no operation. It serves merely to collect the three \
coordinates together, and to label the resulting object as a ",
  StyleBox["point", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.1.2", "2.7"}],

Cell[TextData[{
  "You can think of expressions like ",
  StyleBox["point[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox["]", "MR"],
  " as being \[OpenCurlyDoubleQuote]packets of data\[CloseCurlyDoubleQuote], \
tagged with a particular head. Even though all expressions have the same \
basic structure, you can distinguish different \[OpenCurlyDoubleQuote]types\
\[CloseCurlyDoubleQuote] of expressions by giving them different heads. You \
can then set up transformation rules and programs which treat different types \
of expressions in different ways. "
}], "Text",
  CellTags->{"S2.1.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.3 Special Ways to Input Expressions", "Subsection",
  CellTags->{"S2.1.3", "3.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to use special notation for many common operators. For \
example, although internally ",
  StyleBox["Mathematica", "TI"],
  " represents a sum of two terms as ",
  StyleBox["Plus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", you can enter this expression in the much more convenient form ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.1.3", "3.2"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " language has a definite grammar which specifies how your input should be \
converted to internal form. One aspect of the grammar is that it specifies \
how pieces of your input should be grouped. For example, if you enter an \
expression such as ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["c", "MR"],
  ", the ",
  StyleBox["Mathematica", "TI"],
  " grammar specifies that this should be considered, following standard \
mathematical notation, as ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["(b", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["c)", "MR"],
  " rather than ",
  StyleBox["(a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b)", "MR"],
  " ",
  StyleBox["^", "MR"],
  " ",
  StyleBox["c", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " chooses this grouping because it treats the operator ",
  StyleBox["^", "MR"],
  " as having a higher ",
  StyleBox["precedence", "TI"],
  " than ",
  StyleBox["+", "MR"],
  ". In general, the arguments of operators with higher precedence are \
grouped before those of operators with lower precedence. "
}], "Text",
  CellTags->{"S2.1.3", "3.3"}],

Cell[TextData[{
  "You should realize that absolutely every special input form in ",
  StyleBox["Mathematica", "TI"],
  " is assigned a definite precedence. This includes not only the traditional \
mathematical operators, but also forms such as ",
  StyleBox["->", "MR"],
  ", ",
  StyleBox[":=", "MR"],
  " or the semicolons used to separate expressions in a ",
  StyleBox["Mathematica", "TI"],
  " program. "
}], "Text",
  CellTags->{"S2.1.3", "3.4"}],

Cell[TextData[{
  "The table in Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.3"},
    ButtonStyle->"MainBookLink"],
  " gives all the operators of ",
  StyleBox["Mathematica", "TI"],
  " in order of decreasing precedence. The precedence is arranged, where \
possible, to follow standard mathematical usage, and to minimize the number \
of parentheses that are usually needed. "
}], "Text",
  CellTags->{"S2.1.3", "3.5"}],

Cell[TextData[{
  "You will find, for example, that relational operators such as ",
  StyleBox["<", "MR"],
  " have lower precedence than arithmetic operators such as ",
  StyleBox["+", "MR"],
  ". This means that you can write expressions such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["7", "MR"],
  " without using parentheses. "
}], "Text",
  CellTags->{"S2.1.3", "3.6"}],

Cell[TextData[{
  "There are nevertheless many cases where you do have to use parentheses. \
For example, since ",
  StyleBox[";", "MR"],
  " has a lower precedence than ",
  StyleBox["=", "MR"],
  ", you need to use parentheses to write ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["(", "MR"],
  " ",
  StyleBox["a", "MR"],
  " ",
  StyleBox[";", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox[")", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " interprets the expression \[ThinSpace]",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["a", "MR"],
  " ",
  StyleBox[";", "MR"],
  " ",
  StyleBox["b", "MR"],
  " \[ThinSpace]as \[ThinSpace]",
  StyleBox["(x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["a)", "MR"],
  " ",
  StyleBox[";", "MR"],
  " ",
  StyleBox["b", "MR"],
  ". In general, it can never hurt to include extra parentheses, but it can \
cause a great deal of trouble if you leave parentheses out, and ",
  StyleBox["Mathematica", "TI"],
  " interprets your input in a way you do not expect. "
}], "Text",
  CellTags->{"S2.1.3", "3.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "standard form for ",
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              " ",
              StyleBox["@", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              "prefix form for ",
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["//", "MR"],
              " ",
              StyleBox["f", "TI"],
              " "
            }]], Cell[TextData[{
              "postfix form for ",
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["f", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              "infix form for ",
              StyleBox["f", "TI"],
              "\[ThinSpace]",
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.1.3"],

Cell[TextData[{
  "Four ways to write expressions in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.1.3"],

Cell[TextData[{
  "There are several common types of operators in ",
  StyleBox["Mathematica", "TI"],
  ". The ",
  StyleBox["+", "MR"],
  " in ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "TI"],
  " is an \[OpenCurlyDoubleQuote]infix\[CloseCurlyDoubleQuote] operator. The \
",
  StyleBox["-", "MR"],
  " in ",
  StyleBox["-", "MR"],
  StyleBox["p", "TI"],
  " is a \[OpenCurlyDoubleQuote]prefix\[CloseCurlyDoubleQuote] operator. Even \
when you enter an expression such as ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " ",
  StyleBox["Mathematica", "TI"],
  " allows you to do it in ways that mimic infix, prefix and postfix forms.  \
"
}], "Text",
  CellTags->{"S2.1.3", "3.8"}],

Cell[TextData[{
  "This \[OpenCurlyDoubleQuote]postfix form\[CloseCurlyDoubleQuote] is \
exactly equivalent to ",
  StyleBox["f[x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.3", "3.9"}],

Cell[CellGroupData[{

Cell["x + y //f", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.1.3"],

Cell[BoxData[
    \(f[x + y]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.1.3"]
}, Open  ]],

Cell[TextData[{
  "You will often want to add functions like ",
  StyleBox["N", "MR"],
  " as \[OpenCurlyDoubleQuote]afterthoughts\[CloseCurlyDoubleQuote], and give \
them in postfix form. "
}], "MathCaption",
  CellTags->{"S2.1.3", "3.10"}],

Cell[CellGroupData[{

Cell["3^(1/4) + 1 //N", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.1.3"],

Cell[BoxData[
    \(2.3160740129524924`\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.1.3"]
}, Open  ]],

Cell["\<\
It is sometimes easier to understand what a function is doing when \
you write it in infix form. \
\>", "MathCaption",
  CellTags->{"S2.1.3", "3.11"}],

Cell[CellGroupData[{

Cell["{a, b, c} ~Join~ {d, e}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.1.3"],

Cell[BoxData[
    \({a, b, c, d, e}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.1.3"]
}, Open  ]],

Cell[TextData[{
  "You should notice that ",
  StyleBox["//", "MR"],
  " has very low precedence. If you put ",
  StyleBox["//", "MR"],
  StyleBox["f", "TI"],
  " at the end of any expression containing arithmetic or logical operators, \
the ",
  StyleBox["f", "TI"],
  " is applied to the ",
  StyleBox["whole expression", "TI"],
  ". So, for example, ",
  StyleBox["x+y", "MR"],
  " ",
  StyleBox["//f", "MR"],
  " means ",
  StyleBox["f[x+y]", "MR"],
  ", not ",
  StyleBox["x+f[y]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.1.3", "3.12"}],

Cell[TextData[{
  "The prefix form ",
  StyleBox["@", "MR"],
  " has a much higher precedence. ",
  StyleBox["f", "MR"],
  " ",
  StyleBox["@", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " is equivalent to ",
  StyleBox["f[x]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  ", not ",
  StyleBox["f[x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y]", "MR"],
  ". You can write ",
  StyleBox["f[x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y]", "MR"],
  " in prefix form as ",
  StyleBox["f", "MR"],
  " ",
  StyleBox["@", "MR"],
  " ",
  StyleBox["(x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y)", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.1.3", "3.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.4 Parts of Expressions", "Subsection",
  CellTags->{"S2.1.4", "4.1"}],

Cell["\<\
Since lists are just a particular kind of expression, it will come \
as no surprise that you can refer to parts of any expression much as you \
refer to parts of a list. \
\>", "Text",
  CellTags->{"S2.1.4", "4.2"}],

Cell[TextData[{
  "This gets the second element in the list ",
  StyleBox["{a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.3"}],

Cell[CellGroupData[{

Cell["{a, b, c}[[2]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(b\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "You can use the same method to get the second element in the sum ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.4"}],

Cell[CellGroupData[{

Cell["(x + y + z)[[2]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(y\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell["This gives the last element in the sum. ", "MathCaption",
  CellTags->{"S2.1.4", "4.5"}],

Cell[CellGroupData[{

Cell["(x + y + z)[[-1]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(z\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "Part ",
  StyleBox["0", "MR"],
  " is the head. "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.6"}],

Cell[CellGroupData[{

Cell["(x + y + z)[[0]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(Plus\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "You can refer to parts of an expression such as ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["a", "TI"],
  StyleBox["],", "MR"],
  " ",
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["b", "TI"],
  StyleBox["]]", "MR"],
  " just as you refer to parts of nested lists. "
}], "Text",
  CellTags->{"S2.1.4", "4.7"}],

Cell[TextData[{
  "This is part ",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.8"}],

Cell[CellGroupData[{

Cell["f[g[a], g[b]] [[1]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(g[a]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "This is part ",
  StyleBox["{1,1}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.9"}],

Cell[CellGroupData[{

Cell["f[g[a], g[b]] [[1, 1]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(a\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "This extracts part ",
  StyleBox["{2,1}", "MR"],
  " of the expression ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.10"}],

Cell[CellGroupData[{

Cell["(1 + x^2) [[2, 1]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "To see what part is ",
  StyleBox["{2,1}", "MR"],
  ", you can look at the full form of the expression. "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.11"}],

Cell[CellGroupData[{

Cell["FullForm[1 + x^2]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1, Power[x, 2]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[8]//FullForm= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "You should realize that the assignment of indices to parts of expressions \
is done on the basis of the internal ",
  StyleBox["Mathematica", "TI"],
  " forms of the expression, as shown by ",
  StyleBox["FullForm", "MR"],
  ". These forms do not always correspond directly with what you see printed \
out. This is particularly true for algebraic expressions, where ",
  StyleBox["Mathematica", "TI"],
  " uses a standard internal form, but prints the expressions in special \
ways. "
}], "Text",
  CellTags->{"S2.1.4", "4.12"}],

Cell[TextData[{
  "Here is the internal form of ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["/", "MR"],
  " ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.13"}],

Cell[CellGroupData[{

Cell["FullForm[x / y]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Times[x, Power[y, \(-1\)]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[9]//FullForm= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell["It is the internal form that is used in specifying parts. ", \
"MathCaption",
  CellTags->{"S2.1.4", "4.14"}],

Cell[CellGroupData[{

Cell["(x / y)[[2]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(1\/y\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell["\<\
You can manipulate parts of expressions just as you manipulate \
parts of lists. \
\>", "Text",
  CellTags->{"S2.1.4", "4.15"}],

Cell[TextData[{
  "This replaces the third part of ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["d", "MR"],
  " by ",
  StyleBox["x^2", "MR"],
  ". Note that the sum is automatically rearranged when the replacement is \
done. "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.16"}],

Cell[CellGroupData[{

Cell["ReplacePart[a + b + c + d, x^2, 3]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(a + b + d + x\^2\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell["Here is an expression. ", "MathCaption",
  CellTags->{"S2.1.4", "4.17"}],

Cell[CellGroupData[{

Cell["t = 1 + (3 + x)^2 / y", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(1 + \((3 + x)\)\^2\/y\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "This is the full form of ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.18"}],

Cell[CellGroupData[{

Cell["FullForm[ t ]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1, Times[Power[Plus[3, x], 2], Power[y, \(-1\)]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[13]//FullForm= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "This resets a part of the expression ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.19"}],

Cell[CellGroupData[{

Cell["t[[2, 1, 1]] = x", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "Now the form of ",
  StyleBox["t", "MR"],
  " has been changed. "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.20"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(1 + x\^2\/y\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["expr", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " part of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["expr", "TI"],
              StyleBox["[[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["a combination of parts of an expression "]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " part of ",
              StyleBox["expr", "TI"],
              " by ",
              StyleBox["elem", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.1.4"],

Cell["Functions for manipulating parts of expressions. ", "Caption",
  CellTags->"S2.1.4"],

Cell[TextData[{
  "Section ",
  ButtonBox["1.2.4",
    ButtonData:>{"1.2.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " discussed how you can use lists of indices to pick out several elements \
of a list at a time. You can use the same procedure to pick out several parts \
in an expression at a time. "
}], "Text",
  CellTags->{"S2.1.4", "4.21"}],

Cell["\<\
This picks out elements 2 and 4 in the list, and gives a list of \
these elements. \
\>", "MathCaption",
  CellTags->{"S2.1.4", "4.22"}],

Cell[CellGroupData[{

Cell["{a, b, c, d, e}[[{2, 4}]]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \({b, d}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell[TextData[{
  "This picks out parts 2 and 4 of the sum, and gives a ",
  StyleBox["sum", "TI"],
  " of these elements. "
}], "MathCaption",
  CellTags->{"S2.1.4", "4.23"}],

Cell[CellGroupData[{

Cell["(a + b + c + d + e)[[{2, 4}]]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.1.4"],

Cell[BoxData[
    \(b + d\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.1.4"]
}, Open  ]],

Cell["\<\
Any part in an expression can be viewed as being an argument of \
some function. When you pick out several parts by giving a list of indices, \
the parts are combined using the same function as in the expression. \
\>", \
"Text",
  CellTags->{"S2.1.4", "4.24"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.5 Manipulating Expressions like Lists", "Subsection",
  CellTags->{"S2.1.5", "5.1"}],

Cell[TextData[{
  "You can use most of the list operations discussed in Section\
\[NonBreakingSpace]",
  ButtonBox["1.8",
    ButtonData:>{"1.8"},
    ButtonStyle->"MainBookLink"],
  " on any kind of ",
  StyleBox["Mathematica", "TI"],
  " expression. By using these operations, you can manipulate the structure \
of expressions in many ways. "
}], "Text",
  CellTags->{"S2.1.5", "5.2"}],

Cell["Here is an expression that corresponds to a sum of terms. ", \
"MathCaption",
  CellTags->{"S2.1.5", "5.3"}],

Cell[CellGroupData[{

Cell["t = 1 + x + x^2 + y^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(1 + x + x\^2 + y\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Take[t,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  " takes the first two elements from ",
  StyleBox["t", "MR"],
  ", just as if ",
  StyleBox["t", "MR"],
  " were a list. "
}], "MathCaption",
  CellTags->{"S2.1.5", "5.4"}],

Cell[CellGroupData[{

Cell["Take[t, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(1 + x\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Length", "MR"],
  " gives the number of elements in ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.5", "5.5"}],

Cell[CellGroupData[{

Cell["Length[t]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["FreeQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " to test whether ",
  StyleBox["form", "TI"],
  " appears nowhere in ",
  StyleBox["expr", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.5", "5.6"}],

Cell[CellGroupData[{

Cell["FreeQ[t, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  "This gives a list of the positions at which ",
  StyleBox["x", "MR"],
  " appears in ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.5", "5.7"}],

Cell[CellGroupData[{

Cell["Position[t, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \({{2}, {3, 1}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  "You should remember that all functions which manipulate the structure of \
expressions act on the internal forms of these expressions. You can see these \
forms using ",
  StyleBox["FullForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". They may not be what you would expect from the printed versions of the \
expressions. "
}], "Text",
  CellTags->{"S2.1.5", "5.8"}],

Cell["Here is a function with four arguments. ", "MathCaption",
  CellTags->{"S2.1.5", "5.9"}],

Cell[CellGroupData[{

Cell["f[a, b, c, d]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(f[a, b, c, d]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  "You can add an argument using ",
  StyleBox["Append", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.5", "5.10"}],

Cell[CellGroupData[{

Cell["Append[%, e]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(f[a, b, c, d, e]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell["This reverses the arguments. ", "MathCaption",
  CellTags->{"S2.1.5", "5.11"}],

Cell[CellGroupData[{

Cell["Reverse[%]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.1.5"],

Cell[BoxData[
    \(f[e, d, c, b, a]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.1.5"]
}, Open  ]],

Cell[TextData[{
  "There are a few extra functions that can be used with expressions, as \
discussed in Section ",
  ButtonBox["2.2.10",
    ButtonData:>{"2.2.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.1.5", "5.12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.6 Expressions as Trees", "Subsection",
  CellTags->{"S2.1.6", "6.1"}],

Cell["Here is an expression in full form. ", "MathCaption",
  CellTags->{"S2.1.6", "6.2"}],

Cell[CellGroupData[{

Cell["FullForm[x^3 + (1 + x)^2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.1.6"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[Power[x, 3], Power[Plus[1, x], 2]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm= ",
  CellTags->"S2.1.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TreeForm", "MR"],
  " prints out expressions to show their \[OpenCurlyDoubleQuote]tree\
\[CloseCurlyDoubleQuote] structure.  "
}], "MathCaption",
  CellTags->{"S2.1.6", "6.3"}],

Cell[CellGroupData[{

Cell["TreeForm[x^3 + (1 + x)^2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.1.6"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"Plus\"\>", "[", 
        RowBox[{
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {\("Power"[x, 3]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "Power"[ x, 3]}],
            Editable->False], ",", 
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {
                  RowBox[{"\<\"Power\"\>", "[", 
                    RowBox[{GridBox[{
                          {"\<\"|\"\>"},
                          {\("Plus"[1, x]\)}
                          },
                        GridBaseline->{Baseline, {1, 1}},
                        ColumnAlignments->{Left}], ",", "2"}], "]"}]}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "Power"[ 
                ColumnForm[ {"|", 
                  "Plus"[ 1, x]}], 2]}],
            Editable->False]}], "]"}],
      TreeForm[ 
        Plus[ 
          Power[ x, 3], 
          Power[ 
            Plus[ 1, x], 2]]],
      Editable->False]], "Output",
  CellLabel->"Out[2]//TreeForm= ",
  CellTags->"S2.1.6"]
}, Open  ]],

Cell[TextData[{
  "You can think of any ",
  StyleBox["Mathematica", "TI"],
  " expression as a tree. In the expression above, the top node in the tree \
consists of a ",
  StyleBox["Plus", "MR"],
  ". From this node come two \[OpenCurlyDoubleQuote]branches\
\[CloseCurlyDoubleQuote], ",
  StyleBox["x^3", "MR"],
  " and ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x)^2", "MR"],
  ". From the ",
  StyleBox["x^3", "MR"],
  " node, there are then two branches, ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["3", "MR"],
  ", which can be viewed as \[OpenCurlyDoubleQuote]leaves\
\[CloseCurlyDoubleQuote] of the tree. "
}], "Text",
  CellTags->{"S2.1.6", "6.4"}],

Cell["This matrix is a simple tree with just two levels. ", "MathCaption",
  CellTags->{"S2.1.6", "6.5"}],

Cell[CellGroupData[{

Cell["TreeForm[{{a, b}, {c, d}}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.1.6"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"List\"\>", "[", 
        RowBox[{
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {\("List"[a, b]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "List"[ a, b]}],
            Editable->False], ",", 
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {\("List"[c, d]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "List"[ c, d]}],
            Editable->False]}], "]"}],
      TreeForm[ {{a, b}, {c, d}}],
      Editable->False]], "Output",
  CellLabel->"Out[3]//TreeForm= ",
  CellTags->"S2.1.6"]
}, Open  ]],

Cell["Here is a more complicated expression. ", "MathCaption",
  CellTags->{"S2.1.6", "6.6"}],

Cell[CellGroupData[{

Cell["{{a b, c d^2}, {x^3 y^4}}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.1.6"],

Cell[BoxData[
    \({{a\ b, c\ d\^2}, {x\^3\ y\^4}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.1.6"]
}, Open  ]],

Cell["\<\
The tree for this expression has several levels. The representation \
of the tree here was too long to fit on a single line, so it had to be broken \
onto two lines. \
\>", "MathCaption",
  CellTags->{"S2.1.6", "6.7"}],

Cell[CellGroupData[{

Cell["TreeForm[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.1.6"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"List\"\>", "[", 
        RowBox[{
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {
                  RowBox[{"\<\"List\"\>", "[", 
                    RowBox[{GridBox[{
                          {"\<\"|\"\>"},
                          {\("Times"[a, b]\)}
                          },
                        GridBaseline->{Baseline, {1, 1}},
                        ColumnAlignments->{Left}], ",", GridBox[{
                          {"\<\"|\"\>"},
                          {
                            RowBox[{"\<\"Times\"\>", "[", 
                              RowBox[{"c", ",", GridBox[{
                                    {"\<\"|\"\>"},
                                    {\("Power"[d, 2]\)}
                                    },
                                  GridBaseline->{Baseline, {1, 1}},
                                  ColumnAlignments->{Left}]}], "]"}]}
                          },
                        GridBaseline->{Baseline, {1, 1}},
                        ColumnAlignments->{Left}]}], "]"}]}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "List"[ 
                ColumnForm[ {"|", 
                  "Times"[ a, b]}], 
                ColumnForm[ {"|", 
                  "Times"[ c, 
                    ColumnForm[ {"|", 
                      "Power"[ d, 2]}]]}]]}],
            Editable->False], ",", 
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {
                  RowBox[{"\<\"List\"\>", "[", GridBox[{
                        {"\<\"|\"\>"},
                        {
                          RowBox[{"\<\"Times\"\>", "[", 
                            RowBox[{GridBox[{
                                  {"\<\"|\"\>"},
                                  {\("Power"[x, 3]\)}
                                  },
                                GridBaseline->{Baseline, {1, 1}},
                                ColumnAlignments->{Left}], ",", GridBox[{
                                  {"\<\"|\"\>"},
                                  {\("Power"[y, 4]\)}
                                  },
                                GridBaseline->{Baseline, {1, 1}},
                                ColumnAlignments->{Left}]}], "]"}]}
                        },
                      GridBaseline->{Baseline, {1, 1}},
                      ColumnAlignments->{Left}], "]"}]}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "List"[ 
                ColumnForm[ {"|", 
                  "Times"[ 
                    ColumnForm[ {"|", 
                      "Power"[ x, 3]}], 
                    ColumnForm[ {"|", 
                      "Power"[ y, 4]}]]}]]}],
            Editable->False]}], "]"}],
      TreeForm[ {{
        Times[ a, b], 
        Times[ c, 
          Power[ d, 2]]}, {
        Times[ 
          Power[ x, 3], 
          Power[ y, 4]]}}],
      Editable->False]], "Output",
  CellLabel->"Out[5]//TreeForm= ",
  CellTags->"S2.1.6"]
}, Open  ]],

Cell["\<\
The indices that label each part of an expression have a simple \
interpretation in terms of trees. Descending from the top node of the tree, \
each index specifies which branch to take in order to reach the part you \
want. \
\>", "Text",
  CellTags->{"S2.1.6", "6.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.1.7 Levels in Expressions", "Subsection",
  CellTags->{"S2.1.7", "7.1"}],

Cell[TextData[{
  "The ",
  StyleBox["Part", "MR"],
  " function allows you to access specific parts of ",
  StyleBox["Mathematica", "TI"],
  " expressions. But particularly when your expressions have fairly uniform \
structure, it is often convenient to be able to refer to a whole collection \
of parts at the same time. "
}], "Text",
  CellTags->{"S2.1.7", "7.2"}],

Cell[TextData[{
  StyleBox["Levels", "TI"],
  " provide a general way of specifying collections of parts in ",
  StyleBox["Mathematica", "TI"],
  " expressions. Many ",
  StyleBox["Mathematica", "TI"],
  " functions allow you to specify the levels in an expression on which they \
should act. "
}], "Text",
  CellTags->{"S2.1.7", "7.3"}],

Cell["Here is a simple expression, displayed in tree form. ", "MathCaption",
  CellTags->{"S2.1.7", "7.4"}],

Cell[CellGroupData[{

Cell["(t = {x, {x, y}, y}) // TreeForm", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"List\"\>", "[", 
        RowBox[{"x", ",", 
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {\("List"[x, y]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "List"[ x, y]}],
            Editable->False], ",", "y"}], "]"}],
      TreeForm[ {x, {x, y}, y}],
      Editable->False]], "Output",
  CellLabel->"Out[1]//TreeForm= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "This searches for ",
  StyleBox["x", "MR"],
  " in the expression ",
  StyleBox["t", "MR"],
  " down to level 1. It finds only one occurrence. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.5"}],

Cell[CellGroupData[{

Cell["Position[t, x, 1]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({{1}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "This searches down to level 2. Now it finds both occurrences of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.6"}],

Cell[CellGroupData[{

Cell["Position[t, x, 2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({{1}, {2, 1}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "This searches only at level 2. It finds just one occurrence of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.7"}],

Cell[CellGroupData[{

Cell["Position[t, x, {2}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({{2, 1}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Position[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the positions at which ",
              StyleBox["form", "TI"],
              " occurs in ",
              StyleBox["expr", "TI"],
              " down to level\[NonBreakingSpace]",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Position[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the positions exactly at level ",
              StyleBox["n", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.1.7"],

Cell[TextData[{
  "Controlling ",
  StyleBox["Position", "MR"],
  " using levels. "
}], "Caption",
  CellTags->"S2.1.7"],

Cell["\<\
You can think of levels in expressions in terms of trees. The level \
of a particular part in an expression is simply the distance down the tree at \
which that part appears, with the top of the tree considered as level 0. \
\
\>", "Text",
  CellTags->{"S2.1.7", "7.8"}],

Cell[TextData[{
  "It is equivalent to say that the parts which appear at level ",
  StyleBox["n", "TI"],
  " are those that can be specified by a sequence of exactly ",
  StyleBox["n", "TI"],
  " indices. "
}], "Text",
  CellTags->{"S2.1.7", "7.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "levels ",
              StyleBox["1", "MR"],
              " through ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell["all levels (except 0) "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "level ",
              StyleBox["n", "TI"],
              " only "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "levels ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Heads", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell["include heads "]},
          {Cell[TextData[{
              StyleBox["Heads", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["exclude heads "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, True, False}},
  CellTags->"S2.1.7"],

Cell["Level specifications. ", "Caption",
  CellTags->"S2.1.7"],

Cell["Here is an expression, displayed in tree form. ", "MathCaption",
  CellTags->{"S2.1.7", "7.10"}],

Cell[CellGroupData[{

Cell["(u = f[f[g[a], a], a, h[a], f]) // TreeForm", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"f\"\>", "[", 
        RowBox[{
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {
                  RowBox[{"\<\"f\"\>", "[", 
                    RowBox[{GridBox[{
                          {"\<\"|\"\>"},
                          {\("g"[a]\)}
                          },
                        GridBaseline->{Baseline, {1, 1}},
                        ColumnAlignments->{Left}], ",", "a"}], "]"}]}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "f"[ 
                ColumnForm[ {"|", 
                  "g"[ a]}], a]}],
            Editable->False], ",", "a", ",", 
          InterpretationBox[GridBox[{
                {"\<\"|\"\>"},
                {\("h"[a]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnAlignments->{Left}],
            ColumnForm[ {"|", 
              "h"[ a]}],
            Editable->False], ",", "f"}], "]"}],
      TreeForm[ 
        f[ 
          f[ 
            g[ a], a], a, 
          h[ a], f]],
      Editable->False]], "Output",
  CellLabel->"Out[5]//TreeForm= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "This searches for ",
  StyleBox["a", "MR"],
  " at levels from ",
  StyleBox["2", "MR"],
  " downwards. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.11"}],

Cell[CellGroupData[{

Cell["Position[u, a, {2, Infinity}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({{1, 1, 1}, {1, 2}, {3, 1}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "This shows where ",
  StyleBox["f", "MR"],
  " appears other than in the head of an expression. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.12"}],

Cell[CellGroupData[{

Cell["Position[u, f, Heads->False]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({{4}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "This includes occurrences of ",
  StyleBox["f", "MR"],
  " in heads of expressions. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.13"}],

Cell[CellGroupData[{

Cell["Position[u, f, Heads->True]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({{0}, {1, 0}, {4}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Level[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the parts of ",
              StyleBox["expr", "TI"],
              " at the levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Depth[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the total number of levels in ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.1.7"],

Cell["Testing and extracting levels. ", "Caption",
  CellTags->"S2.1.7"],

Cell[TextData[{
  "This gives a list of all parts of ",
  StyleBox["u", "MR"],
  " that occur down to level 2. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.14"}],

Cell[CellGroupData[{

Cell["Level[u, 2]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({g[a], a, f[g[a], a], a, a, h[a], f}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell["Here are the parts specifically at level\[NonBreakingSpace]2. ", \
"MathCaption",
  CellTags->{"S2.1.7", "7.15"}],

Cell[CellGroupData[{

Cell["Level[u, {2}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({g[a], a, a}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "When you have got the hang of ordinary levels, you can try thinking about \
",
  StyleBox["negative levels", "TI"],
  ". Negative levels label parts of expressions starting at the ",
  StyleBox["bottom", "TI"],
  " of the tree. Level ",
  StyleBox["-1", "MR"],
  " contains all the leaves of the tree: objects like symbols and numbers.   \
"
}], "Text",
  CellTags->{"S2.1.7", "7.16"}],

Cell[TextData[{
  "This shows the parts of ",
  StyleBox["u", "MR"],
  " at level ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.17"}],

Cell[CellGroupData[{

Cell["Level[u, {-1}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({a, a, a, a, f}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "You can think of expressions as having a \[OpenCurlyDoubleQuote]depth\
\[CloseCurlyDoubleQuote], which is equal to the maximum number of levels \
shown by ",
  StyleBox["TreeForm", "MR"],
  ". In general, level ",
  StyleBox["-", "MR"],
  StyleBox["n", "TI"],
  " in an expression is defined to consist of all subexpressions whose depth \
is ",
  StyleBox["n", "TI"],
  ".  "
}], "Text",
  CellTags->{"S2.1.7", "7.18"}],

Cell[TextData[{
  "The depth of ",
  StyleBox["g[a]", "MR"],
  " is 2. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.19"}],

Cell[CellGroupData[{

Cell["Depth[ g[a] ]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.1.7"]
}, Open  ]],

Cell[TextData[{
  "The parts of ",
  StyleBox["u", "MR"],
  " at level ",
  Cell[BoxData[
      \(TraditionalForm\`\(-2\)\)], "InlineFormula"],
  " are those that have depth exactly 2. "
}], "MathCaption",
  CellTags->{"S2.1.7", "7.20"}],

Cell[CellGroupData[{

Cell["Level[u, {-2}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.1.7"],

Cell[BoxData[
    \({g[a], h[a]}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.1.7"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{80, Automatic}, {Automatic, 59}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.1.0"->{
    Cell[1776, 53, 114, 4, 65, "Section",
      CellTags->{"S2.1.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 114, 4, 65, "Section",
      CellTags->{"S2.1.0", "0.1"}]},
  "S2.1.1"->{
    Cell[1915, 61, 86, 1, 70, "Subsection",
      CellTags->{"S2.1.1", "1.1"}],
    Cell[2004, 64, 383, 9, 70, "Text",
      CellTags->{"S2.1.1", "1.2"}],
    Cell[2390, 75, 770, 31, 70, "Text",
      CellTags->{"S2.1.1", "1.3"}],
    Cell[3163, 108, 842, 39, 70, "Text",
      CellTags->{"S2.1.1", "1.4"}],
    Cell[4008, 149, 295, 12, 70, "Text",
      CellTags->{"S2.1.1", "1.5"}],
    Cell[4306, 163, 166, 5, 70, "Text",
      CellTags->{"S2.1.1", "1.6"}],
    Cell[4475, 170, 2495, 90, 70, "DefinitionBox",
      CellTags->"S2.1.1"],
    Cell[6973, 262, 127, 5, 70, "Caption",
      CellTags->"S2.1.1"],
    Cell[7103, 269, 205, 7, 70, "Text",
      CellTags->{"S2.1.1", "1.7"}],
    Cell[7311, 278, 77, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.8"}],
    Cell[7413, 283, 73, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[7489, 287, 90, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[7594, 293, 95, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.9"}],
    Cell[7714, 298, 75, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[7792, 302, 246, 8, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[8053, 313, 83, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.10"}],
    Cell[8161, 318, 83, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[8247, 322, 106, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[8368, 328, 96, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.11"}],
    Cell[8489, 333, 75, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[8567, 337, 275, 8, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[8857, 348, 692, 26, 70, "Text",
      CellTags->{"S2.1.1", "1.12"}],
    Cell[9552, 376, 200, 6, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.13"}],
    Cell[9777, 386, 77, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[9857, 390, 82, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[9954, 396, 190, 6, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.14"}],
    Cell[10169, 406, 79, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[10251, 410, 85, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[10351, 416, 78, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.15"}],
    Cell[10454, 421, 79, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[10536, 425, 85, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[10636, 431, 80, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.16"}],
    Cell[10741, 436, 75, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[10819, 440, 88, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[10922, 446, 128, 4, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.17"}],
    Cell[11075, 454, 75, 2, 70, "Input",
      CellTags->"S2.1.1"],
    Cell[11153, 458, 85, 3, 70, "Output",
      CellTags->"S2.1.1"],
    Cell[11253, 464, 1091, 33, 70, "DefinitionBox",
      CellTags->"S2.1.1"],
    Cell[12347, 499, 81, 1, 70, "Caption",
      CellTags->"S2.1.1"]},
  "1.1"->{
    Cell[1915, 61, 86, 1, 70, "Subsection",
      CellTags->{"S2.1.1", "1.1"}]},
  "1.2"->{
    Cell[2004, 64, 383, 9, 70, "Text",
      CellTags->{"S2.1.1", "1.2"}]},
  "1.3"->{
    Cell[2390, 75, 770, 31, 70, "Text",
      CellTags->{"S2.1.1", "1.3"}]},
  "1.4"->{
    Cell[3163, 108, 842, 39, 70, "Text",
      CellTags->{"S2.1.1", "1.4"}]},
  "1.5"->{
    Cell[4008, 149, 295, 12, 70, "Text",
      CellTags->{"S2.1.1", "1.5"}]},
  "1.6"->{
    Cell[4306, 163, 166, 5, 70, "Text",
      CellTags->{"S2.1.1", "1.6"}]},
  "1.7"->{
    Cell[7103, 269, 205, 7, 70, "Text",
      CellTags->{"S2.1.1", "1.7"}]},
  "1.8"->{
    Cell[7311, 278, 77, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.8"}]},
  "1.9"->{
    Cell[7594, 293, 95, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.9"}]},
  "1.10"->{
    Cell[8053, 313, 83, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.10"}]},
  "1.11"->{
    Cell[8368, 328, 96, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.11"}]},
  "1.12"->{
    Cell[8857, 348, 692, 26, 70, "Text",
      CellTags->{"S2.1.1", "1.12"}]},
  "1.13"->{
    Cell[9552, 376, 200, 6, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.13"}]},
  "1.14"->{
    Cell[9954, 396, 190, 6, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.14"}]},
  "1.15"->{
    Cell[10351, 416, 78, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.15"}]},
  "1.16"->{
    Cell[10636, 431, 80, 1, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.16"}]},
  "1.17"->{
    Cell[10922, 446, 128, 4, 70, "MathCaption",
      CellTags->{"S2.1.1", "1.17"}]},
  "S2.1.2"->{
    Cell[12465, 505, 85, 1, 70, "Subsection",
      CellTags->{"S2.1.2", "2.1"}],
    Cell[12553, 508, 422, 10, 70, "Text",
      CellTags->{"S2.1.2", "2.2"}],
    Cell[12978, 520, 258, 5, 70, "Text",
      CellTags->{"S2.1.2", "2.3"}],
    Cell[13239, 527, 2265, 71, 70, "DefinitionBox3Col",
      CellTags->"S2.1.2"],
    Cell[15507, 600, 87, 1, 70, "Caption",
      CellTags->"S2.1.2"],
    Cell[15597, 603, 496, 21, 70, "Text",
      CellTags->{"S2.1.2", "2.4"}],
    Cell[16096, 626, 598, 17, 70, "Text",
      CellTags->{"S2.1.2", "2.5"}],
    Cell[16697, 645, 535, 19, 70, "Text",
      CellTags->{"S2.1.2", "2.6"}],
    Cell[17235, 666, 757, 22, 70, "Text",
      CellTags->{"S2.1.2", "2.7"}],
    Cell[17995, 690, 703, 18, 70, "Text",
      CellTags->{"S2.1.2", "2.8"}]},
  "2.1"->{
    Cell[12465, 505, 85, 1, 70, "Subsection",
      CellTags->{"S2.1.2", "2.1"}]},
  "2.2"->{
    Cell[12553, 508, 422, 10, 70, "Text",
      CellTags->{"S2.1.2", "2.2"}]},
  "2.3"->{
    Cell[12978, 520, 258, 5, 70, "Text",
      CellTags->{"S2.1.2", "2.3"}]},
  "2.4"->{
    Cell[15597, 603, 496, 21, 70, "Text",
      CellTags->{"S2.1.2", "2.4"}]},
  "2.5"->{
    Cell[16096, 626, 598, 17, 70, "Text",
      CellTags->{"S2.1.2", "2.5"}]},
  "2.6"->{
    Cell[16697, 645, 535, 19, 70, "Text",
      CellTags->{"S2.1.2", "2.6"}]},
  "2.7"->{
    Cell[17235, 666, 757, 22, 70, "Text",
      CellTags->{"S2.1.2", "2.7"}]},
  "2.8"->{
    Cell[17995, 690, 703, 18, 70, "Text",
      CellTags->{"S2.1.2", "2.8"}]},
  "S2.1.3"->{
    Cell[18735, 713, 92, 1, 70, "Subsection",
      CellTags->{"S2.1.3", "3.1"}],
    Cell[18830, 716, 555, 20, 70, "Text",
      CellTags->{"S2.1.3", "3.2"}],
    Cell[19388, 738, 1304, 50, 70, "Text",
      CellTags->{"S2.1.3", "3.3"}],
    Cell[20695, 790, 453, 12, 70, "Text",
      CellTags->{"S2.1.3", "3.4"}],
    Cell[21151, 804, 454, 11, 70, "Text",
      CellTags->{"S2.1.3", "3.5"}],
    Cell[21608, 817, 469, 17, 70, "Text",
      CellTags->{"S2.1.3", "3.6"}],
    Cell[22080, 836, 1128, 47, 70, "Text",
      CellTags->{"S2.1.3", "3.7"}],
    Cell[23211, 885, 2453, 83, 70, "DefinitionBox",
      CellTags->"S2.1.3"],
    Cell[25667, 970, 132, 5, 70, "Caption",
      CellTags->"S2.1.3"],
    Cell[25802, 977, 873, 35, 70, "Text",
      CellTags->{"S2.1.3", "3.8"}],
    Cell[26678, 1014, 256, 10, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.9"}],
    Cell[26959, 1028, 73, 2, 70, "Input",
      CellTags->"S2.1.3"],
    Cell[27035, 1032, 89, 3, 70, "Output",
      CellTags->"S2.1.3"],
    Cell[27139, 1038, 241, 6, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.10"}],
    Cell[27405, 1048, 79, 2, 70, "Input",
      CellTags->"S2.1.3"],
    Cell[27487, 1052, 100, 3, 70, "Output",
      CellTags->"S2.1.3"],
    Cell[27602, 1058, 160, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.11"}],
    Cell[27787, 1066, 87, 2, 70, "Input",
      CellTags->"S2.1.3"],
    Cell[27877, 1070, 96, 3, 70, "Output",
      CellTags->"S2.1.3"],
    Cell[27988, 1076, 544, 21, 70, "Text",
      CellTags->{"S2.1.3", "3.12"}],
    Cell[28535, 1099, 777, 43, 70, "Text",
      CellTags->{"S2.1.3", "3.13"}]},
  "3.1"->{
    Cell[18735, 713, 92, 1, 70, "Subsection",
      CellTags->{"S2.1.3", "3.1"}]},
  "3.2"->{
    Cell[18830, 716, 555, 20, 70, "Text",
      CellTags->{"S2.1.3", "3.2"}]},
  "3.3"->{
    Cell[19388, 738, 1304, 50, 70, "Text",
      CellTags->{"S2.1.3", "3.3"}]},
  "3.4"->{
    Cell[20695, 790, 453, 12, 70, "Text",
      CellTags->{"S2.1.3", "3.4"}]},
  "3.5"->{
    Cell[21151, 804, 454, 11, 70, "Text",
      CellTags->{"S2.1.3", "3.5"}]},
  "3.6"->{
    Cell[21608, 817, 469, 17, 70, "Text",
      CellTags->{"S2.1.3", "3.6"}]},
  "3.7"->{
    Cell[22080, 836, 1128, 47, 70, "Text",
      CellTags->{"S2.1.3", "3.7"}]},
  "3.8"->{
    Cell[25802, 977, 873, 35, 70, "Text",
      CellTags->{"S2.1.3", "3.8"}]},
  "3.9"->{
    Cell[26678, 1014, 256, 10, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.9"}]},
  "3.10"->{
    Cell[27139, 1038, 241, 6, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.10"}]},
  "3.11"->{
    Cell[27602, 1058, 160, 4, 70, "MathCaption",
      CellTags->{"S2.1.3", "3.11"}]},
  "3.12"->{
    Cell[27988, 1076, 544, 21, 70, "Text",
      CellTags->{"S2.1.3", "3.12"}]},
  "3.13"->{
    Cell[28535, 1099, 777, 43, 70, "Text",
      CellTags->{"S2.1.3", "3.13"}]},
  "S2.1.4"->{
    Cell[29349, 1147, 79, 1, 70, "Subsection",
      CellTags->{"S2.1.4", "4.1"}],
    Cell[29431, 1150, 225, 5, 70, "Text",
      CellTags->{"S2.1.4", "4.2"}],
    Cell[29659, 1157, 206, 9, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.3"}],
    Cell[29890, 1170, 78, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[29971, 1174, 82, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[30068, 1180, 286, 13, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.4"}],
    Cell[30379, 1197, 80, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[30462, 1201, 82, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[30559, 1207, 94, 1, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.5"}],
    Cell[30678, 1212, 81, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[30762, 1216, 82, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[30859, 1222, 118, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.6"}],
    Cell[31002, 1231, 80, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[31085, 1235, 85, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[31185, 1241, 401, 15, 70, "Text",
      CellTags->{"S2.1.4", "4.7"}],
    Cell[31589, 1258, 114, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.8"}],
    Cell[31728, 1267, 83, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[31814, 1271, 85, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[31914, 1277, 118, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.9"}],
    Cell[32057, 1286, 86, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[32146, 1290, 82, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[32243, 1296, 235, 11, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.10"}],
    Cell[32503, 1311, 82, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[32588, 1315, 82, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[32685, 1321, 175, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.11"}],
    Cell[32885, 1330, 81, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[32969, 1334, 253, 8, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[33237, 1345, 547, 12, 70, "Text",
      CellTags->{"S2.1.4", "4.12"}],
    Cell[33787, 1359, 191, 9, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.13"}],
    Cell[34003, 1372, 79, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[34085, 1376, 259, 8, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[34359, 1387, 115, 2, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.14"}],
    Cell[34499, 1393, 77, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[34579, 1397, 86, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[34680, 1403, 137, 4, 70, "Text",
      CellTags->{"S2.1.4", "4.15"}],
    Cell[34820, 1409, 427, 20, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.16"}],
    Cell[35272, 1433, 99, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[35374, 1437, 98, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[35487, 1443, 78, 1, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.17"}],
    Cell[35590, 1448, 86, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[35679, 1452, 103, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[35797, 1458, 127, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.18"}],
    Cell[35949, 1467, 78, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[36030, 1471, 288, 8, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[36333, 1482, 139, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.19"}],
    Cell[36497, 1491, 81, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[36581, 1495, 83, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[36679, 1501, 135, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.20"}],
    Cell[36839, 1510, 66, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[36908, 1514, 93, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[37016, 1520, 3215, 95, 70, "DefinitionBox",
      CellTags->"S2.1.4"],
    Cell[40234, 1617, 90, 1, 70, "Caption",
      CellTags->"S2.1.4"],
    Cell[40327, 1620, 350, 9, 70, "Text",
      CellTags->{"S2.1.4", "4.21"}],
    Cell[40680, 1631, 146, 4, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.22"}],
    Cell[40851, 1639, 90, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[40944, 1643, 88, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[41047, 1649, 175, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.23"}],
    Cell[41247, 1658, 94, 2, 70, "Input",
      CellTags->"S2.1.4"],
    Cell[41344, 1662, 87, 3, 70, "Output",
      CellTags->"S2.1.4"],
    Cell[41446, 1668, 271, 6, 70, "Text",
      CellTags->{"S2.1.4", "4.24"}]},
  "4.1"->{
    Cell[29349, 1147, 79, 1, 70, "Subsection",
      CellTags->{"S2.1.4", "4.1"}]},
  "4.2"->{
    Cell[29431, 1150, 225, 5, 70, "Text",
      CellTags->{"S2.1.4", "4.2"}]},
  "4.3"->{
    Cell[29659, 1157, 206, 9, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.3"}]},
  "4.4"->{
    Cell[30068, 1180, 286, 13, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.4"}]},
  "4.5"->{
    Cell[30559, 1207, 94, 1, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.5"}]},
  "4.6"->{
    Cell[30859, 1222, 118, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.6"}]},
  "4.7"->{
    Cell[31185, 1241, 401, 15, 70, "Text",
      CellTags->{"S2.1.4", "4.7"}]},
  "4.8"->{
    Cell[31589, 1258, 114, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.8"}]},
  "4.9"->{
    Cell[31914, 1277, 118, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.9"}]},
  "4.10"->{
    Cell[32243, 1296, 235, 11, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.10"}]},
  "4.11"->{
    Cell[32685, 1321, 175, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.11"}]},
  "4.12"->{
    Cell[33237, 1345, 547, 12, 70, "Text",
      CellTags->{"S2.1.4", "4.12"}]},
  "4.13"->{
    Cell[33787, 1359, 191, 9, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.13"}]},
  "4.14"->{
    Cell[34359, 1387, 115, 2, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.14"}]},
  "4.15"->{
    Cell[34680, 1403, 137, 4, 70, "Text",
      CellTags->{"S2.1.4", "4.15"}]},
  "4.16"->{
    Cell[34820, 1409, 427, 20, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.16"}]},
  "4.17"->{
    Cell[35487, 1443, 78, 1, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.17"}]},
  "4.18"->{
    Cell[35797, 1458, 127, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.18"}]},
  "4.19"->{
    Cell[36333, 1482, 139, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.19"}]},
  "4.20"->{
    Cell[36679, 1501, 135, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.20"}]},
  "4.21"->{
    Cell[40327, 1620, 350, 9, 70, "Text",
      CellTags->{"S2.1.4", "4.21"}]},
  "4.22"->{
    Cell[40680, 1631, 146, 4, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.22"}]},
  "4.23"->{
    Cell[41047, 1649, 175, 5, 70, "MathCaption",
      CellTags->{"S2.1.4", "4.23"}]},
  "4.24"->{
    Cell[41446, 1668, 271, 6, 70, "Text",
      CellTags->{"S2.1.4", "4.24"}]},
  "S2.1.5"->{
    Cell[41754, 1679, 94, 1, 70, "Subsection",
      CellTags->{"S2.1.5", "5.1"}],
    Cell[41851, 1682, 387, 11, 70, "Text",
      CellTags->{"S2.1.5", "5.2"}],
    Cell[42241, 1695, 114, 2, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.3"}],
    Cell[42380, 1701, 85, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[42468, 1705, 100, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[42583, 1711, 250, 10, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.4"}],
    Cell[42858, 1725, 74, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[42935, 1729, 86, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[43036, 1735, 162, 6, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.5"}],
    Cell[43223, 1745, 73, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[43299, 1749, 82, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[43396, 1755, 324, 14, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.6"}],
    Cell[43745, 1773, 75, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[43823, 1777, 86, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[43924, 1783, 186, 7, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.7"}],
    Cell[44135, 1794, 78, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[44216, 1798, 94, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[44325, 1804, 404, 10, 70, "Text",
      CellTags->{"S2.1.5", "5.8"}],
    Cell[44732, 1816, 94, 1, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.9"}],
    Cell[44851, 1821, 77, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[44931, 1825, 94, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[45040, 1831, 137, 5, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.10"}],
    Cell[45202, 1840, 76, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[45281, 1844, 97, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[45393, 1850, 84, 1, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.11"}],
    Cell[45502, 1855, 74, 2, 70, "Input",
      CellTags->"S2.1.5"],
    Cell[45579, 1859, 97, 3, 70, "Output",
      CellTags->"S2.1.5"],
    Cell[45691, 1865, 257, 8, 70, "Text",
      CellTags->{"S2.1.5", "5.12"}]},
  "5.1"->{
    Cell[41754, 1679, 94, 1, 70, "Subsection",
      CellTags->{"S2.1.5", "5.1"}]},
  "5.2"->{
    Cell[41851, 1682, 387, 11, 70, "Text",
      CellTags->{"S2.1.5", "5.2"}]},
  "5.3"->{
    Cell[42241, 1695, 114, 2, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.3"}]},
  "5.4"->{
    Cell[42583, 1711, 250, 10, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.4"}]},
  "5.5"->{
    Cell[43036, 1735, 162, 6, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.5"}]},
  "5.6"->{
    Cell[43396, 1755, 324, 14, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.6"}]},
  "5.7"->{
    Cell[43924, 1783, 186, 7, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.7"}]},
  "5.8"->{
    Cell[44325, 1804, 404, 10, 70, "Text",
      CellTags->{"S2.1.5", "5.8"}]},
  "5.9"->{
    Cell[44732, 1816, 94, 1, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.9"}]},
  "5.10"->{
    Cell[45040, 1831, 137, 5, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.10"}]},
  "5.11"->{
    Cell[45393, 1850, 84, 1, 70, "MathCaption",
      CellTags->{"S2.1.5", "5.11"}]},
  "5.12"->{
    Cell[45691, 1865, 257, 8, 70, "Text",
      CellTags->{"S2.1.5", "5.12"}]},
  "S2.1.6"->{
    Cell[45985, 1878, 79, 1, 70, "Subsection",
      CellTags->{"S2.1.6", "6.1"}],
    Cell[46067, 1881, 90, 1, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.2"}],
    Cell[46182, 1886, 89, 2, 70, "Input",
      CellTags->"S2.1.6"],
    Cell[46274, 1890, 272, 8, 70, "Output",
      CellTags->"S2.1.6"],
    Cell[46561, 1901, 204, 5, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.3"}],
    Cell[46790, 1910, 89, 2, 70, "Input",
      CellTags->"S2.1.6"],
    Cell[46882, 1914, 1294, 38, 70, "Output",
      CellTags->"S2.1.6"],
    Cell[48191, 1955, 693, 24, 70, "Text",
      CellTags->{"S2.1.6", "6.4"}],
    Cell[48887, 1981, 105, 1, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.5"}],
    Cell[49017, 1986, 90, 2, 70, "Input",
      CellTags->"S2.1.6"],
    Cell[49110, 1990, 839, 25, 70, "Output",
      CellTags->"S2.1.6"],
    Cell[49964, 2018, 93, 1, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.6"}],
    Cell[50082, 2023, 89, 2, 70, "Input",
      CellTags->"S2.1.6"],
    Cell[50174, 2027, 112, 3, 70, "Output",
      CellTags->"S2.1.6"],
    Cell[50301, 2033, 228, 5, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.7"}],
    Cell[50554, 2042, 75, 2, 70, "Input",
      CellTags->"S2.1.6"],
    Cell[50632, 2046, 3224, 80, 70, "Output",
      CellTags->"S2.1.6"],
    Cell[53871, 2129, 280, 6, 70, "Text",
      CellTags->{"S2.1.6", "6.8"}]},
  "6.1"->{
    Cell[45985, 1878, 79, 1, 70, "Subsection",
      CellTags->{"S2.1.6", "6.1"}]},
  "6.2"->{
    Cell[46067, 1881, 90, 1, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.2"}]},
  "6.3"->{
    Cell[46561, 1901, 204, 5, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.3"}]},
  "6.4"->{
    Cell[48191, 1955, 693, 24, 70, "Text",
      CellTags->{"S2.1.6", "6.4"}]},
  "6.5"->{
    Cell[48887, 1981, 105, 1, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.5"}]},
  "6.6"->{
    Cell[49964, 2018, 93, 1, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.6"}]},
  "6.7"->{
    Cell[50301, 2033, 228, 5, 70, "MathCaption",
      CellTags->{"S2.1.6", "6.7"}]},
  "6.8"->{
    Cell[53871, 2129, 280, 6, 70, "Text",
      CellTags->{"S2.1.6", "6.8"}]},
  "S2.1.7"->{
    Cell[54188, 2140, 80, 1, 70, "Subsection",
      CellTags->{"S2.1.7", "7.1"}],
    Cell[54271, 2143, 367, 9, 70, "Text",
      CellTags->{"S2.1.7", "7.2"}],
    Cell[54641, 2154, 337, 9, 70, "Text",
      CellTags->{"S2.1.7", "7.3"}],
    Cell[54981, 2165, 107, 1, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.4"}],
    Cell[55113, 2170, 96, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[55212, 2174, 547, 16, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[55774, 2193, 213, 7, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.5"}],
    Cell[56012, 2204, 81, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[56096, 2208, 86, 3, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[56197, 2214, 165, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.6"}],
    Cell[56387, 2223, 81, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[56471, 2227, 94, 3, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[56580, 2233, 164, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.7"}],
    Cell[56769, 2242, 83, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[56855, 2246, 89, 3, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[56959, 2252, 1388, 43, 70, "DefinitionBox",
      CellTags->"S2.1.7"],
    Cell[58350, 2297, 120, 5, 70, "Caption",
      CellTags->"S2.1.7"],
    Cell[58473, 2304, 280, 6, 70, "Text",
      CellTags->{"S2.1.7", "7.8"}],
    Cell[58756, 2312, 250, 7, 70, "Text",
      CellTags->{"S2.1.7", "7.9"}],
    Cell[59009, 2321, 2487, 77, 70, "DefinitionBox",
      CellTags->"S2.1.7"],
    Cell[61499, 2400, 63, 1, 70, "Caption",
      CellTags->"S2.1.7"],
    Cell[61565, 2403, 102, 1, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.10"}],
    Cell[61692, 2408, 107, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[61802, 2412, 1263, 38, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[63080, 2453, 175, 7, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.11"}],
    Cell[63280, 2464, 93, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[63376, 2468, 108, 3, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[63499, 2474, 167, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.12"}],
    Cell[63691, 2483, 92, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[63786, 2487, 86, 3, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[63887, 2493, 155, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.13"}],
    Cell[64067, 2502, 91, 2, 70, "Input",
      CellTags->"S2.1.7"],
    Cell[64161, 2506, 99, 3, 70, "Output",
      CellTags->"S2.1.7"],
    Cell[64275, 2512, 997, 31, 84, "DefinitionBox",
      CellTags->"S2.1.7"],
    Cell[65275, 2545, 72, 1, 70, "Caption",
      CellTags->"S2.1.7"],
    Cell[65350, 2548, 163, 5, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.14"}],
    Cell[65538, 2557, 75, 2, 28, "Input",
      CellTags->"S2.1.7"],
    Cell[65616, 2561, 117, 3, 25, "Output",
      CellTags->"S2.1.7"],
    Cell[65748, 2567, 119, 2, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.15"}],
    Cell[65892, 2573, 78, 2, 28, "Input",
      CellTags->"S2.1.7"],
    Cell[65973, 2577, 94, 3, 25, "Output",
      CellTags->"S2.1.7"],
    Cell[66082, 2583, 404, 11, 56, "Text",
      CellTags->{"S2.1.7", "7.16"}],
    Cell[66489, 2596, 212, 8, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.17"}],
    Cell[66726, 2608, 79, 2, 28, "Input",
      CellTags->"S2.1.7"],
    Cell[66808, 2612, 97, 3, 25, "Output",
      CellTags->"S2.1.7"],
    Cell[66920, 2618, 438, 13, 56, "Text",
      CellTags->{"S2.1.7", "7.18"}],
    Cell[67361, 2633, 123, 5, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.19"}],
    Cell[67509, 2642, 78, 2, 28, "Input",
      CellTags->"S2.1.7"],
    Cell[67590, 2646, 83, 3, 25, "Output",
      CellTags->"S2.1.7"],
    Cell[67688, 2652, 237, 8, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.20"}],
    Cell[67950, 2664, 79, 2, 28, "Input",
      CellTags->"S2.1.7"],
    Cell[68032, 2668, 94, 3, 25, "Output",
      CellTags->"S2.1.7"]},
  "7.1"->{
    Cell[54188, 2140, 80, 1, 70, "Subsection",
      CellTags->{"S2.1.7", "7.1"}]},
  "7.2"->{
    Cell[54271, 2143, 367, 9, 70, "Text",
      CellTags->{"S2.1.7", "7.2"}]},
  "7.3"->{
    Cell[54641, 2154, 337, 9, 70, "Text",
      CellTags->{"S2.1.7", "7.3"}]},
  "7.4"->{
    Cell[54981, 2165, 107, 1, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.4"}]},
  "7.5"->{
    Cell[55774, 2193, 213, 7, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.5"}]},
  "7.6"->{
    Cell[56197, 2214, 165, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.6"}]},
  "7.7"->{
    Cell[56580, 2233, 164, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.7"}]},
  "7.8"->{
    Cell[58473, 2304, 280, 6, 70, "Text",
      CellTags->{"S2.1.7", "7.8"}]},
  "7.9"->{
    Cell[58756, 2312, 250, 7, 70, "Text",
      CellTags->{"S2.1.7", "7.9"}]},
  "7.10"->{
    Cell[61565, 2403, 102, 1, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.10"}]},
  "7.11"->{
    Cell[63080, 2453, 175, 7, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.11"}]},
  "7.12"->{
    Cell[63499, 2474, 167, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.12"}]},
  "7.13"->{
    Cell[63887, 2493, 155, 5, 70, "MathCaption",
      CellTags->{"S2.1.7", "7.13"}]},
  "7.14"->{
    Cell[65350, 2548, 163, 5, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.14"}]},
  "7.15"->{
    Cell[65748, 2567, 119, 2, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.15"}]},
  "7.16"->{
    Cell[66082, 2583, 404, 11, 56, "Text",
      CellTags->{"S2.1.7", "7.16"}]},
  "7.17"->{
    Cell[66489, 2596, 212, 8, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.17"}]},
  "7.18"->{
    Cell[66920, 2618, 438, 13, 56, "Text",
      CellTags->{"S2.1.7", "7.18"}]},
  "7.19"->{
    Cell[67361, 2633, 123, 5, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.19"}]},
  "7.20"->{
    Cell[67688, 2652, 237, 8, 40, "MathCaption",
      CellTags->{"S2.1.7", "7.20"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.1.0", 68780, 2692},
  {"0.1", 68870, 2695},
  {"S2.1.1", 68963, 2698},
  {"1.1", 71864, 2777},
  {"1.2", 71956, 2780},
  {"1.3", 72043, 2783},
  {"1.4", 72131, 2786},
  {"1.5", 72220, 2789},
  {"1.6", 72309, 2792},
  {"1.7", 72397, 2795},
  {"1.8", 72485, 2798},
  {"1.9", 72579, 2801},
  {"1.10", 72674, 2804},
  {"1.11", 72770, 2807},
  {"1.12", 72866, 2810},
  {"1.13", 72957, 2813},
  {"1.14", 73054, 2816},
  {"1.15", 73151, 2819},
  {"1.16", 73248, 2822},
  {"1.17", 73345, 2825},
  {"S2.1.2", 73445, 2828},
  {"2.1", 74237, 2849},
  {"2.2", 74331, 2852},
  {"2.3", 74421, 2855},
  {"2.4", 74510, 2858},
  {"2.5", 74600, 2861},
  {"2.6", 74690, 2864},
  {"2.7", 74780, 2867},
  {"2.8", 74870, 2870},
  {"S2.1.3", 74963, 2873},
  {"3.1", 76591, 2916},
  {"3.2", 76685, 2919},
  {"3.3", 76775, 2922},
  {"3.4", 76866, 2925},
  {"3.5", 76956, 2928},
  {"3.6", 77046, 2931},
  {"3.7", 77136, 2934},
  {"3.8", 77227, 2937},
  {"3.9", 77317, 2940},
  {"3.10", 77416, 2943},
  {"3.11", 77515, 2946},
  {"3.12", 77614, 2949},
  {"3.13", 77707, 2952},
  {"S2.1.4", 77802, 2955},
  {"4.1", 82346, 3076},
  {"4.2", 82441, 3079},
  {"4.3", 82531, 3082},
  {"4.4", 82628, 3085},
  {"4.5", 82726, 3088},
  {"4.6", 82822, 3091},
  {"4.7", 82919, 3094},
  {"4.8", 83010, 3097},
  {"4.9", 83107, 3100},
  {"4.10", 83205, 3103},
  {"4.11", 83305, 3106},
  {"4.12", 83404, 3109},
  {"4.13", 83497, 3112},
  {"4.14", 83596, 3115},
  {"4.15", 83695, 3118},
  {"4.16", 83787, 3121},
  {"4.17", 83887, 3124},
  {"4.18", 83985, 3127},
  {"4.19", 84084, 3130},
  {"4.20", 84183, 3133},
  {"4.21", 84282, 3136},
  {"4.22", 84374, 3139},
  {"4.23", 84473, 3142},
  {"4.24", 84572, 3145},
  {"S2.1.5", 84666, 3148},
  {"5.1", 86793, 3205},
  {"5.2", 86888, 3208},
  {"5.3", 86979, 3211},
  {"5.4", 87076, 3214},
  {"5.5", 87174, 3217},
  {"5.6", 87271, 3220},
  {"5.7", 87369, 3223},
  {"5.8", 87466, 3226},
  {"5.9", 87557, 3229},
  {"5.10", 87654, 3232},
  {"5.11", 87753, 3235},
  {"5.12", 87851, 3238},
  {"S2.1.6", 87945, 3241},
  {"6.1", 89325, 3278},
  {"6.2", 89420, 3281},
  {"6.3", 89516, 3284},
  {"6.4", 89613, 3287},
  {"6.5", 89704, 3290},
  {"6.6", 89801, 3293},
  {"6.7", 89897, 3296},
  {"6.8", 89994, 3299},
  {"S2.1.7", 90087, 3302},
  {"7.1", 94036, 3407},
  {"7.2", 94131, 3410},
  {"7.3", 94221, 3413},
  {"7.4", 94311, 3416},
  {"7.5", 94408, 3419},
  {"7.6", 94505, 3422},
  {"7.7", 94602, 3425},
  {"7.8", 94699, 3428},
  {"7.9", 94789, 3431},
  {"7.10", 94880, 3434},
  {"7.11", 94979, 3437},
  {"7.12", 95078, 3440},
  {"7.13", 95177, 3443},
  {"7.14", 95276, 3446},
  {"7.15", 95375, 3449},
  {"7.16", 95474, 3452},
  {"7.17", 95567, 3455},
  {"7.18", 95666, 3458},
  {"7.19", 95759, 3461},
  {"7.20", 95858, 3464}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 114, 4, 65, "Section",
  CellTags->{"S2.1.0", "0.1"}],

Cell[CellGroupData[{
Cell[1915, 61, 86, 1, 70, "Subsection",
  CellTags->{"S2.1.1", "1.1"}],
Cell[2004, 64, 383, 9, 70, "Text",
  CellTags->{"S2.1.1", "1.2"}],
Cell[2390, 75, 770, 31, 70, "Text",
  CellTags->{"S2.1.1", "1.3"}],
Cell[3163, 108, 842, 39, 70, "Text",
  CellTags->{"S2.1.1", "1.4"}],
Cell[4008, 149, 295, 12, 70, "Text",
  CellTags->{"S2.1.1", "1.5"}],
Cell[4306, 163, 166, 5, 70, "Text",
  CellTags->{"S2.1.1", "1.6"}],
Cell[4475, 170, 2495, 90, 70, "DefinitionBox",
  CellTags->"S2.1.1"],
Cell[6973, 262, 127, 5, 70, "Caption",
  CellTags->"S2.1.1"],
Cell[7103, 269, 205, 7, 70, "Text",
  CellTags->{"S2.1.1", "1.7"}],
Cell[7311, 278, 77, 1, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.8"}],

Cell[CellGroupData[{
Cell[7413, 283, 73, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[7489, 287, 90, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[7594, 293, 95, 1, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.9"}],

Cell[CellGroupData[{
Cell[7714, 298, 75, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[7792, 302, 246, 8, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[8053, 313, 83, 1, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.10"}],

Cell[CellGroupData[{
Cell[8161, 318, 83, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[8247, 322, 106, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[8368, 328, 96, 1, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.11"}],

Cell[CellGroupData[{
Cell[8489, 333, 75, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[8567, 337, 275, 8, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[8857, 348, 692, 26, 70, "Text",
  CellTags->{"S2.1.1", "1.12"}],
Cell[9552, 376, 200, 6, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.13"}],

Cell[CellGroupData[{
Cell[9777, 386, 77, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[9857, 390, 82, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[9954, 396, 190, 6, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.14"}],

Cell[CellGroupData[{
Cell[10169, 406, 79, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[10251, 410, 85, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[10351, 416, 78, 1, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.15"}],

Cell[CellGroupData[{
Cell[10454, 421, 79, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[10536, 425, 85, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[10636, 431, 80, 1, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.16"}],

Cell[CellGroupData[{
Cell[10741, 436, 75, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[10819, 440, 88, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[10922, 446, 128, 4, 70, "MathCaption",
  CellTags->{"S2.1.1", "1.17"}],

Cell[CellGroupData[{
Cell[11075, 454, 75, 2, 70, "Input",
  CellTags->"S2.1.1"],
Cell[11153, 458, 85, 3, 70, "Output",
  CellTags->"S2.1.1"]
}, Open  ]],
Cell[11253, 464, 1091, 33, 70, "DefinitionBox",
  CellTags->"S2.1.1"],
Cell[12347, 499, 81, 1, 70, "Caption",
  CellTags->"S2.1.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12465, 505, 85, 1, 70, "Subsection",
  CellTags->{"S2.1.2", "2.1"}],
Cell[12553, 508, 422, 10, 70, "Text",
  CellTags->{"S2.1.2", "2.2"}],
Cell[12978, 520, 258, 5, 70, "Text",
  CellTags->{"S2.1.2", "2.3"}],
Cell[13239, 527, 2265, 71, 70, "DefinitionBox3Col",
  CellTags->"S2.1.2"],
Cell[15507, 600, 87, 1, 70, "Caption",
  CellTags->"S2.1.2"],
Cell[15597, 603, 496, 21, 70, "Text",
  CellTags->{"S2.1.2", "2.4"}],
Cell[16096, 626, 598, 17, 70, "Text",
  CellTags->{"S2.1.2", "2.5"}],
Cell[16697, 645, 535, 19, 70, "Text",
  CellTags->{"S2.1.2", "2.6"}],
Cell[17235, 666, 757, 22, 70, "Text",
  CellTags->{"S2.1.2", "2.7"}],
Cell[17995, 690, 703, 18, 70, "Text",
  CellTags->{"S2.1.2", "2.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18735, 713, 92, 1, 70, "Subsection",
  CellTags->{"S2.1.3", "3.1"}],
Cell[18830, 716, 555, 20, 70, "Text",
  CellTags->{"S2.1.3", "3.2"}],
Cell[19388, 738, 1304, 50, 70, "Text",
  CellTags->{"S2.1.3", "3.3"}],
Cell[20695, 790, 453, 12, 70, "Text",
  CellTags->{"S2.1.3", "3.4"}],
Cell[21151, 804, 454, 11, 70, "Text",
  CellTags->{"S2.1.3", "3.5"}],
Cell[21608, 817, 469, 17, 70, "Text",
  CellTags->{"S2.1.3", "3.6"}],
Cell[22080, 836, 1128, 47, 70, "Text",
  CellTags->{"S2.1.3", "3.7"}],
Cell[23211, 885, 2453, 83, 70, "DefinitionBox",
  CellTags->"S2.1.3"],
Cell[25667, 970, 132, 5, 70, "Caption",
  CellTags->"S2.1.3"],
Cell[25802, 977, 873, 35, 70, "Text",
  CellTags->{"S2.1.3", "3.8"}],
Cell[26678, 1014, 256, 10, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.9"}],

Cell[CellGroupData[{
Cell[26959, 1028, 73, 2, 70, "Input",
  CellTags->"S2.1.3"],
Cell[27035, 1032, 89, 3, 70, "Output",
  CellTags->"S2.1.3"]
}, Open  ]],
Cell[27139, 1038, 241, 6, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.10"}],

Cell[CellGroupData[{
Cell[27405, 1048, 79, 2, 70, "Input",
  CellTags->"S2.1.3"],
Cell[27487, 1052, 100, 3, 70, "Output",
  CellTags->"S2.1.3"]
}, Open  ]],
Cell[27602, 1058, 160, 4, 70, "MathCaption",
  CellTags->{"S2.1.3", "3.11"}],

Cell[CellGroupData[{
Cell[27787, 1066, 87, 2, 70, "Input",
  CellTags->"S2.1.3"],
Cell[27877, 1070, 96, 3, 70, "Output",
  CellTags->"S2.1.3"]
}, Open  ]],
Cell[27988, 1076, 544, 21, 70, "Text",
  CellTags->{"S2.1.3", "3.12"}],
Cell[28535, 1099, 777, 43, 70, "Text",
  CellTags->{"S2.1.3", "3.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[29349, 1147, 79, 1, 70, "Subsection",
  CellTags->{"S2.1.4", "4.1"}],
Cell[29431, 1150, 225, 5, 70, "Text",
  CellTags->{"S2.1.4", "4.2"}],
Cell[29659, 1157, 206, 9, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.3"}],

Cell[CellGroupData[{
Cell[29890, 1170, 78, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[29971, 1174, 82, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[30068, 1180, 286, 13, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.4"}],

Cell[CellGroupData[{
Cell[30379, 1197, 80, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[30462, 1201, 82, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[30559, 1207, 94, 1, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.5"}],

Cell[CellGroupData[{
Cell[30678, 1212, 81, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[30762, 1216, 82, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[30859, 1222, 118, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.6"}],

Cell[CellGroupData[{
Cell[31002, 1231, 80, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[31085, 1235, 85, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[31185, 1241, 401, 15, 70, "Text",
  CellTags->{"S2.1.4", "4.7"}],
Cell[31589, 1258, 114, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.8"}],

Cell[CellGroupData[{
Cell[31728, 1267, 83, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[31814, 1271, 85, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[31914, 1277, 118, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.9"}],

Cell[CellGroupData[{
Cell[32057, 1286, 86, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[32146, 1290, 82, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[32243, 1296, 235, 11, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.10"}],

Cell[CellGroupData[{
Cell[32503, 1311, 82, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[32588, 1315, 82, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[32685, 1321, 175, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.11"}],

Cell[CellGroupData[{
Cell[32885, 1330, 81, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[32969, 1334, 253, 8, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[33237, 1345, 547, 12, 70, "Text",
  CellTags->{"S2.1.4", "4.12"}],
Cell[33787, 1359, 191, 9, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.13"}],

Cell[CellGroupData[{
Cell[34003, 1372, 79, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[34085, 1376, 259, 8, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[34359, 1387, 115, 2, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.14"}],

Cell[CellGroupData[{
Cell[34499, 1393, 77, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[34579, 1397, 86, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[34680, 1403, 137, 4, 70, "Text",
  CellTags->{"S2.1.4", "4.15"}],
Cell[34820, 1409, 427, 20, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.16"}],

Cell[CellGroupData[{
Cell[35272, 1433, 99, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[35374, 1437, 98, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[35487, 1443, 78, 1, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.17"}],

Cell[CellGroupData[{
Cell[35590, 1448, 86, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[35679, 1452, 103, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[35797, 1458, 127, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.18"}],

Cell[CellGroupData[{
Cell[35949, 1467, 78, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[36030, 1471, 288, 8, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[36333, 1482, 139, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.19"}],

Cell[CellGroupData[{
Cell[36497, 1491, 81, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[36581, 1495, 83, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[36679, 1501, 135, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.20"}],

Cell[CellGroupData[{
Cell[36839, 1510, 66, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[36908, 1514, 93, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[37016, 1520, 3215, 95, 70, "DefinitionBox",
  CellTags->"S2.1.4"],
Cell[40234, 1617, 90, 1, 70, "Caption",
  CellTags->"S2.1.4"],
Cell[40327, 1620, 350, 9, 70, "Text",
  CellTags->{"S2.1.4", "4.21"}],
Cell[40680, 1631, 146, 4, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.22"}],

Cell[CellGroupData[{
Cell[40851, 1639, 90, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[40944, 1643, 88, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[41047, 1649, 175, 5, 70, "MathCaption",
  CellTags->{"S2.1.4", "4.23"}],

Cell[CellGroupData[{
Cell[41247, 1658, 94, 2, 70, "Input",
  CellTags->"S2.1.4"],
Cell[41344, 1662, 87, 3, 70, "Output",
  CellTags->"S2.1.4"]
}, Open  ]],
Cell[41446, 1668, 271, 6, 70, "Text",
  CellTags->{"S2.1.4", "4.24"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41754, 1679, 94, 1, 70, "Subsection",
  CellTags->{"S2.1.5", "5.1"}],
Cell[41851, 1682, 387, 11, 70, "Text",
  CellTags->{"S2.1.5", "5.2"}],
Cell[42241, 1695, 114, 2, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.3"}],

Cell[CellGroupData[{
Cell[42380, 1701, 85, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[42468, 1705, 100, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[42583, 1711, 250, 10, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.4"}],

Cell[CellGroupData[{
Cell[42858, 1725, 74, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[42935, 1729, 86, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[43036, 1735, 162, 6, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.5"}],

Cell[CellGroupData[{
Cell[43223, 1745, 73, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[43299, 1749, 82, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[43396, 1755, 324, 14, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.6"}],

Cell[CellGroupData[{
Cell[43745, 1773, 75, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[43823, 1777, 86, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[43924, 1783, 186, 7, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.7"}],

Cell[CellGroupData[{
Cell[44135, 1794, 78, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[44216, 1798, 94, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[44325, 1804, 404, 10, 70, "Text",
  CellTags->{"S2.1.5", "5.8"}],
Cell[44732, 1816, 94, 1, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.9"}],

Cell[CellGroupData[{
Cell[44851, 1821, 77, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[44931, 1825, 94, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[45040, 1831, 137, 5, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.10"}],

Cell[CellGroupData[{
Cell[45202, 1840, 76, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[45281, 1844, 97, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[45393, 1850, 84, 1, 70, "MathCaption",
  CellTags->{"S2.1.5", "5.11"}],

Cell[CellGroupData[{
Cell[45502, 1855, 74, 2, 70, "Input",
  CellTags->"S2.1.5"],
Cell[45579, 1859, 97, 3, 70, "Output",
  CellTags->"S2.1.5"]
}, Open  ]],
Cell[45691, 1865, 257, 8, 70, "Text",
  CellTags->{"S2.1.5", "5.12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[45985, 1878, 79, 1, 70, "Subsection",
  CellTags->{"S2.1.6", "6.1"}],
Cell[46067, 1881, 90, 1, 70, "MathCaption",
  CellTags->{"S2.1.6", "6.2"}],

Cell[CellGroupData[{
Cell[46182, 1886, 89, 2, 70, "Input",
  CellTags->"S2.1.6"],
Cell[46274, 1890, 272, 8, 70, "Output",
  CellTags->"S2.1.6"]
}, Open  ]],
Cell[46561, 1901, 204, 5, 70, "MathCaption",
  CellTags->{"S2.1.6", "6.3"}],

Cell[CellGroupData[{
Cell[46790, 1910, 89, 2, 70, "Input",
  CellTags->"S2.1.6"],
Cell[46882, 1914, 1294, 38, 70, "Output",
  CellTags->"S2.1.6"]
}, Open  ]],
Cell[48191, 1955, 693, 24, 70, "Text",
  CellTags->{"S2.1.6", "6.4"}],
Cell[48887, 1981, 105, 1, 70, "MathCaption",
  CellTags->{"S2.1.6", "6.5"}],

Cell[CellGroupData[{
Cell[49017, 1986, 90, 2, 70, "Input",
  CellTags->"S2.1.6"],
Cell[49110, 1990, 839, 25, 70, "Output",
  CellTags->"S2.1.6"]
}, Open  ]],
Cell[49964, 2018, 93, 1, 70, "MathCaption",
  CellTags->{"S2.1.6", "6.6"}],

Cell[CellGroupData[{
Cell[50082, 2023, 89, 2, 70, "Input",
  CellTags->"S2.1.6"],
Cell[50174, 2027, 112, 3, 70, "Output",
  CellTags->"S2.1.6"]
}, Open  ]],
Cell[50301, 2033, 228, 5, 70, "MathCaption",
  CellTags->{"S2.1.6", "6.7"}],

Cell[CellGroupData[{
Cell[50554, 2042, 75, 2, 70, "Input",
  CellTags->"S2.1.6"],
Cell[50632, 2046, 3224, 80, 70, "Output",
  CellTags->"S2.1.6"]
}, Open  ]],
Cell[53871, 2129, 280, 6, 70, "Text",
  CellTags->{"S2.1.6", "6.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[54188, 2140, 80, 1, 70, "Subsection",
  CellTags->{"S2.1.7", "7.1"}],
Cell[54271, 2143, 367, 9, 70, "Text",
  CellTags->{"S2.1.7", "7.2"}],
Cell[54641, 2154, 337, 9, 70, "Text",
  CellTags->{"S2.1.7", "7.3"}],
Cell[54981, 2165, 107, 1, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.4"}],

Cell[CellGroupData[{
Cell[55113, 2170, 96, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[55212, 2174, 547, 16, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[55774, 2193, 213, 7, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.5"}],

Cell[CellGroupData[{
Cell[56012, 2204, 81, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[56096, 2208, 86, 3, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[56197, 2214, 165, 5, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.6"}],

Cell[CellGroupData[{
Cell[56387, 2223, 81, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[56471, 2227, 94, 3, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[56580, 2233, 164, 5, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.7"}],

Cell[CellGroupData[{
Cell[56769, 2242, 83, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[56855, 2246, 89, 3, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[56959, 2252, 1388, 43, 70, "DefinitionBox",
  CellTags->"S2.1.7"],
Cell[58350, 2297, 120, 5, 70, "Caption",
  CellTags->"S2.1.7"],
Cell[58473, 2304, 280, 6, 70, "Text",
  CellTags->{"S2.1.7", "7.8"}],
Cell[58756, 2312, 250, 7, 70, "Text",
  CellTags->{"S2.1.7", "7.9"}],
Cell[59009, 2321, 2487, 77, 70, "DefinitionBox",
  CellTags->"S2.1.7"],
Cell[61499, 2400, 63, 1, 70, "Caption",
  CellTags->"S2.1.7"],
Cell[61565, 2403, 102, 1, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.10"}],

Cell[CellGroupData[{
Cell[61692, 2408, 107, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[61802, 2412, 1263, 38, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[63080, 2453, 175, 7, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.11"}],

Cell[CellGroupData[{
Cell[63280, 2464, 93, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[63376, 2468, 108, 3, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[63499, 2474, 167, 5, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.12"}],

Cell[CellGroupData[{
Cell[63691, 2483, 92, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[63786, 2487, 86, 3, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[63887, 2493, 155, 5, 70, "MathCaption",
  CellTags->{"S2.1.7", "7.13"}],

Cell[CellGroupData[{
Cell[64067, 2502, 91, 2, 70, "Input",
  CellTags->"S2.1.7"],
Cell[64161, 2506, 99, 3, 70, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[64275, 2512, 997, 31, 84, "DefinitionBox",
  CellTags->"S2.1.7"],
Cell[65275, 2545, 72, 1, 70, "Caption",
  CellTags->"S2.1.7"],
Cell[65350, 2548, 163, 5, 40, "MathCaption",
  CellTags->{"S2.1.7", "7.14"}],

Cell[CellGroupData[{
Cell[65538, 2557, 75, 2, 28, "Input",
  CellTags->"S2.1.7"],
Cell[65616, 2561, 117, 3, 25, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[65748, 2567, 119, 2, 40, "MathCaption",
  CellTags->{"S2.1.7", "7.15"}],

Cell[CellGroupData[{
Cell[65892, 2573, 78, 2, 28, "Input",
  CellTags->"S2.1.7"],
Cell[65973, 2577, 94, 3, 25, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[66082, 2583, 404, 11, 56, "Text",
  CellTags->{"S2.1.7", "7.16"}],
Cell[66489, 2596, 212, 8, 40, "MathCaption",
  CellTags->{"S2.1.7", "7.17"}],

Cell[CellGroupData[{
Cell[66726, 2608, 79, 2, 28, "Input",
  CellTags->"S2.1.7"],
Cell[66808, 2612, 97, 3, 25, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[66920, 2618, 438, 13, 56, "Text",
  CellTags->{"S2.1.7", "7.18"}],
Cell[67361, 2633, 123, 5, 40, "MathCaption",
  CellTags->{"S2.1.7", "7.19"}],

Cell[CellGroupData[{
Cell[67509, 2642, 78, 2, 28, "Input",
  CellTags->"S2.1.7"],
Cell[67590, 2646, 83, 3, 25, "Output",
  CellTags->"S2.1.7"]
}, Open  ]],
Cell[67688, 2652, 237, 8, 40, "MathCaption",
  CellTags->{"S2.1.7", "7.20"}],

Cell[CellGroupData[{
Cell[67950, 2664, 79, 2, 28, "Input",
  CellTags->"S2.1.7"],
Cell[68032, 2668, 94, 3, 25, "Output",
  CellTags->"S2.1.7"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

