(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    141668,       5373]*)
(*NotebookOutlinePosition[    203668,       7168]*)
(*  CellTagsIndexPosition[    198402,       6961]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.2 ", "HeadingNumber"],
  "Functional Operations"
}], "Section",
  CellTags->{"S2.2.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.2.1 Function Names as Expressions", "Subsection",
  CellTags->{"S2.2.1", "1.1"}],

Cell[TextData[{
  "In an expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", the \[OpenCurlyDoubleQuote]function name\[CloseCurlyDoubleQuote] ",
  StyleBox["f", "TI"],
  " is itself an expression, and you can treat it as you would any other \
expression. "
}], "Text",
  CellTags->{"S2.2.1", "1.2"}],

Cell["\<\
You can replace names of functions using transformation rules. \
\
\>", "MathCaption",
  CellTags->{"S2.2.1", "1.3"}],

Cell[CellGroupData[{

Cell["f[x] + f[1 - x] /. f -> g", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.1"],

Cell[BoxData[
    \(g[1 - x] + g[x]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.1"]
}, Open  ]],

Cell["Any assignments you have made are used on function names. ", \
"MathCaption",
  CellTags->{"S2.2.1", "1.4"}],

Cell[CellGroupData[{

Cell["p1 = p2; p1[x, y]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.1"],

Cell[BoxData[
    \(p2[x, y]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.1"]
}, Open  ]],

Cell["\<\
This defines a function which takes a function name as an argument. \
\
\>", "MathCaption",
  CellTags->{"S2.2.1", "1.5"}],

Cell["pf[f_, x_] := f[x] + f[1 - x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.1"],

Cell[TextData[{
  "This gives ",
  StyleBox["Log", "MR"],
  " as the function name to use. "
}], "MathCaption",
  CellTags->{"S2.2.1", "1.6"}],

Cell[CellGroupData[{

Cell["pf[Log, q]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.1"],

Cell[BoxData[
    \(Log[1 - q] + Log[q]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.1"]
}, Open  ]],

Cell[TextData[{
  "The ability to treat the names of functions just like other kinds of \
expressions is an important consequence of the symbolic nature of the ",
  StyleBox["Mathematica", "TI"],
  " language. It makes possible the whole range of ",
  StyleBox["functional operations", "TI"],
  " discussed in the sections that follow. "
}], "Text",
  CellTags->{"S2.2.1", "1.7"}],

Cell[TextData[{
  "Ordinary ",
  StyleBox["Mathematica", "TI"],
  " functions such as ",
  StyleBox["Log", "MR"],
  " or ",
  StyleBox["Integrate", "MR"],
  " typically operate on data such as numbers and algebraic expressions. ",
  StyleBox["Mathematica", "TI"],
  " functions that represent functional operations, however, can operate not \
only on ordinary data, but also on functions themselves. Thus, for example, \
the functional operation ",
  StyleBox["InverseFunction", "MR"],
  " takes a ",
  StyleBox["Mathematica", "TI"],
  " function name as an argument, and represents the inverse of that \
function. "
}], "Text",
  CellTags->{"S2.2.1", "1.8"}],

Cell[TextData[{
  StyleBox["InverseFunction", "MR"],
  " is a functional operation: it takes a ",
  StyleBox["Mathematica", "TI"],
  " function as an argument, and returns another function which represents \
its inverse. "
}], "MathCaption",
  CellTags->{"S2.2.1", "1.9"}],

Cell[CellGroupData[{

Cell["InverseFunction[ArcSin]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.1"],

Cell[BoxData[
    \(Sin\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.1"]
}, Open  ]],

Cell[TextData[{
  "The result obtained from ",
  StyleBox["InverseFunction", "MR"],
  " is a function which you can apply to data. "
}], "MathCaption",
  CellTags->{"S2.2.1", "1.10"}],

Cell[CellGroupData[{

Cell["%[x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.1"],

Cell[BoxData[
    \(Sin[x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.1"]
}, Open  ]],

Cell[TextData[{
  "You can also use ",
  StyleBox["InverseFunction", "MR"],
  " in a purely symbolic way. "
}], "MathCaption",
  CellTags->{"S2.2.1", "1.11"}],

Cell[CellGroupData[{

Cell["InverseFunction[f] [x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.1"],

Cell[BoxData[
    RowBox[{
      TagBox[\(f\^\((\(-1\))\)\),
        InverseFunction,
        Editable->False], "[", "x", "]"}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.1"]
}, Open  ]],

Cell[TextData[{
  "There are many kinds of functional operations in ",
  StyleBox["Mathematica", "TI"],
  ". Some represent mathematical operations; others represent various kinds \
of procedures and algorithms. "
}], "Text",
  CellTags->{"S2.2.1", "1.12"}],

Cell[TextData[{
  "Unless you are familiar with advanced symbolic languages, you will \
probably not recognize most of the functional operations discussed in the \
sections that follow. At first, the operations may seem difficult to \
understand. But it is worth persisting. Functional operations provide one of \
the most conceptually and practically efficient ways to use ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.2.1", "1.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.2 Applying Functions Repeatedly", "Subsection",
  CellTags->{"S2.2.2", "2.1"}],

Cell[TextData[{
  "Many programs you write will involve operations that need to be iterated \
several times. ",
  StyleBox["Nest", "MR"],
  " and ",
  StyleBox["NestList", "MR"],
  " are powerful constructs for doing this. "
}], "Text",
  CellTags->{"S2.2.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Nest[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply the function ",
              StyleBox["f", "TI"],
              " nested ",
              StyleBox["n", "TI"],
              " times to ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NestList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate the list ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              ", where ",
              StyleBox["f", "TI"],
              " is nested up to ",
              StyleBox["n", "TI"],
              " deep "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.2"],

Cell["Applying functions of one argument repeatedly. ", "Caption",
  CellTags->"S2.2.2"],

Cell[TextData[{
  StyleBox["Nest[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " takes the \[OpenCurlyDoubleQuote]name\[CloseCurlyDoubleQuote] ",
  StyleBox["f", "TI"],
  " of a function, and applies the function ",
  StyleBox["n", "TI"],
  " times to ",
  StyleBox["x", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.3"}],

Cell[CellGroupData[{

Cell["Nest[f, x, 4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \(f[f[f[f[x]]]]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell["This makes a list of each successive nesting. ", "MathCaption",
  CellTags->{"S2.2.2", "2.4"}],

Cell[CellGroupData[{

Cell["NestList[f, x, 4]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({x, f[x], f[f[x]], f[f[f[x]]], f[f[f[f[x]]]]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell["Here is a simple function. ", "MathCaption",
  CellTags->{"S2.2.2", "2.5"}],

Cell["recip[x_] := 1/(1 + x)", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.2"],

Cell[TextData[{
  "You can iterate the function using ",
  StyleBox["Nest", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.6"}],

Cell[CellGroupData[{

Cell["Nest[recip, x, 3]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \(1\/\(1 + 1\/\(1 + 1\/\(1 + x\)\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Nest", "MR"],
  " and ",
  StyleBox["NestList", "MR"],
  " allow you to apply functions a fixed number of times. Often you may want \
to apply functions until the result no longer changes. You can do this using \
",
  StyleBox["FixedPoint", "MR"],
  " and ",
  StyleBox["FixedPointList", "MR"],
  "."
}], "Text",
  CellTags->{"S2.2.2", "2.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FixedPoint[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply the function ",
              StyleBox["f", "TI"],
              " repeatedly until the result no longer changes "
            }]]},
          {Cell[TextData[{
              StyleBox["FixedPointList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate the list ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              ", stopping when the elements no longer change "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.2"],

Cell["Applying functions until the result no longer changes. ", "Caption",
  CellTags->"S2.2.2"],

Cell[TextData[{
  "Here is a function that takes one step in Newton's approximation to ",
  Cell[BoxData[
      \(TraditionalForm\`\@3\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.8"}],

Cell["newton3[x_] := N[ 1/2 ( x + 3/x ) ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.2"],

Cell[TextData[{
  "Here are five successive iterates of the function, starting at ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", "1"}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.9"}],

Cell[CellGroupData[{

Cell["NestList[newton3, 1.0, 5]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({1.`, 2.`, 1.75`, 1.7321428571428572`, 1.7320508100147274`, 
      1.7320508075688774`}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[TextData[{
  "Using the function ",
  StyleBox["FixedPoint", "MR"],
  ", you can automatically continue applying ",
  StyleBox["newton3", "MR"],
  " until the result no longer changes. "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.10"}],

Cell[CellGroupData[{

Cell["FixedPoint[newton3, 1.0]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \(1.7320508075688772`\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell["Here is the sequence of results. ", "MathCaption",
  CellTags->{"S2.2.2", "2.11"}],

Cell[CellGroupData[{

Cell["FixedPointList[newton3, 1.0]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({1.`, 2.`, 1.75`, 1.7321428571428572`, 1.7320508100147274`, 
      1.7320508075688774`, 1.7320508075688772`}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NestWhile[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply the function ",
              StyleBox["f", "TI"],
              " repeatedly until applying ",
              StyleBox["test", "TI"],
              " to the result no longer yields ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NestWhileList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate the list ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              ", stopping when applying ",
              StyleBox["test", "TI"],
              " to the result no longer yields ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NestWhile[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              ", \[ThinSpace]",
              StyleBox["NestWhileList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "supply the ",
              StyleBox["m", "TI"],
              " most recent results as arguments for ",
              StyleBox["test", "TI"],
              " at each step "
            }]]},
          {Cell[TextData[{
              StyleBox["NestWhile[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["All]", "MR"],
              ", \[ThinSpace]",
              StyleBox["NestWhileList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["All]", "MR"],
              " "
            }]], Cell[TextData[{
              "supply all results so far as arguments for ",
              StyleBox["test", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.2"],

Cell["Applying functions repeatedly until a test fails. ", "Caption",
  CellTags->"S2.2.2"],

Cell["Here is a function which divides a number by 2. ", "MathCaption",
  CellTags->{"S2.2.2", "2.12"}],

Cell["divide2[n_] := n/2", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.2.2"],

Cell[TextData[{
  "This repeatedly applies ",
  StyleBox["divide2", "MR"],
  " until the result is no longer an even number. "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.13"}],

Cell[CellGroupData[{

Cell["NestWhileList[divide2, 123456, EvenQ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({123456, 61728, 30864, 15432, 7716, 3858, 1929}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[TextData[{
  "This repeatedly applies ",
  StyleBox["newton3", "MR"],
  ", stopping when two successive results are no longer considered unequal, \
just as in ",
  StyleBox["FixedPointList", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.14"}],

Cell[CellGroupData[{

Cell["NestWhileList[newton3, 1.0, Unequal, 2]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({1.`, 2.`, 1.75`, 1.7321428571428572`, 1.7320508100147274`, 
      1.7320508075688774`, 1.7320508075688772`}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell["\<\
This goes on until the first time a result that has been seen \
before reappears. \
\>", "MathCaption",
  CellTags->{"S2.2.2", "2.15"}],

Cell[CellGroupData[{

Cell["NestWhileList[Mod[5 #, 7]&, 1, Unequal, All]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({1, 5, 4, 6, 2, 3, 1}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[TextData[{
  "Operations such as ",
  StyleBox["Nest", "MR"],
  " take a function ",
  StyleBox["f", "TI"],
  " of one argument, and apply it repeatedly. At each step, they use the \
result of the previous step as the new argument of ",
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.2.2", "2.16"}],

Cell["\<\
It is important to generalize this notion to functions of two \
arguments. You can again apply the function repeatedly, but now each result \
you get supplies only one of the new arguments you need. A convenient \
approach is to get the other argument at each step from the successive \
elements of a\[NonBreakingSpace]list. \
\>", "Text",
  CellTags->{"S2.2.2", "2.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FoldList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "create the list ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Fold[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the last element of the list produced by ",
              StyleBox["FoldList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.2"],

Cell["Ways to repeatedly apply functions of two arguments. ", "Caption",
  CellTags->"S2.2.2"],

Cell[TextData[{
  "Here is an example of what ",
  StyleBox["FoldList", "MR"],
  " does. "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.18"}],

Cell[CellGroupData[{

Cell["FoldList[f, x, {a, b, c}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({x, f[x, a], f[f[x, a], b], f[f[f[x, a], b], c]}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Fold", "MR"],
  " gives the last element of the list produced by ",
  StyleBox["FoldList", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.19"}],

Cell[CellGroupData[{

Cell["Fold[f, x, {a, b, c}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \(f[f[f[x, a], b], c]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell["This gives a list of cumulative sums. ", "MathCaption",
  CellTags->{"S2.2.2", "2.20"}],

Cell[CellGroupData[{

Cell["FoldList[Plus, 0, {a, b, c}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \({0, a, a + b, a + b + c}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.2.2"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Fold", "MR"],
  " and ",
  StyleBox["FoldList", "MR"],
  " you can write many elegant and efficient programs in ",
  StyleBox["Mathematica", "TI"],
  ". In some cases, you may find it helpful to think of ",
  StyleBox["Fold", "MR"],
  " and ",
  StyleBox["FoldList", "MR"],
  " as producing a simple nesting of a family of functions indexed by their \
second argument. "
}], "Text",
  CellTags->{"S2.2.2", "2.21"}],

Cell[TextData[{
  "This defines a function ",
  StyleBox["nextdigit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.22"}],

Cell["nextdigit[a_, b_] := 10 a + b", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.2.2"],

Cell[TextData[{
  "This is now like the built\[Hyphen]in function ",
  StyleBox["FromDigits", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.2", "2.23"}],

Cell["fromdigits[digits_] := Fold[nextdigit, 0, digits]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.2.2"],

Cell["Here is an example of the function in action. ", "MathCaption",
  CellTags->{"S2.2.2", "2.24"}],

Cell[CellGroupData[{

Cell["fromdigits[{1, 3, 7, 2, 9, 1}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.2.2"],

Cell[BoxData[
    \(137291\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.2.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.3 Applying Functions to Lists and Other Expressions", "Subsection",
  CellTags->{"S2.2.3", "3.1"}],

Cell[TextData[{
  "In an expression like ",
  StyleBox["f[{a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c}]", "MR"],
  " you are giving a list as the argument to a function. Often you need \
instead to apply a function directly to the elements of a list, rather than \
to the list as a whole. You can do this in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["Apply", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.2.3", "3.2"}],

Cell[TextData[{
  "This makes each element of the list an argument of the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.3"}],

Cell[CellGroupData[{

Cell["Apply[f, {a, b, c}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \(f[a, b, c]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.3"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["Plus[a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c]", "MR"],
  " which yields the sum of the elements in the list. "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.4"}],

Cell[CellGroupData[{

Cell["Apply[Plus, {a, b, c}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \(a + b + c\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the definition of the statistical mean, written using ",
  StyleBox["Apply", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.5"}],

Cell["mean[list_] := Apply[Plus, list] / Length[list]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Apply[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to a list, giving ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Apply[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              " ",
              StyleBox["@@", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to the top level of an expression "
            }]]},
          {Cell[TextData[{
              StyleBox["Apply[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{1}]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              " ",
              StyleBox["@@@", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " at the first level in an expression "
            }]]},
          {Cell[TextData[{
              StyleBox["Apply[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " at the specified levels in an expression "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.3"],

Cell["Applying functions to lists and other expressions. ", "Caption",
  CellTags->"S2.2.3"],

Cell[TextData[{
  "What ",
  StyleBox["Apply", "MR"],
  " does in general is to replace the head of an expression with the function \
you specify. Here it replaces ",
  StyleBox["Plus", "MR"],
  " by ",
  StyleBox["List", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.6"}],

Cell[CellGroupData[{

Cell["Apply[List, a + b + c]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \({a, b, c}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.3"]
}, Open  ]],

Cell["Here is a matrix. ", "MathCaption",
  CellTags->{"S2.2.3", "3.7"}],

Cell[CellGroupData[{

Cell["m = {{a, b, c}, {b, c, d}}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.3"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Apply", "MR"],
  " without an explicit level specification replaces the top\[Hyphen]level \
list with ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.8"}],

Cell[CellGroupData[{

Cell["Apply[f, m]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \(f[{a, b, c}, {b, c, d}]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.3"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " only to parts of ",
  StyleBox["m", "MR"],
  " at level 1. "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.9"}],

Cell[CellGroupData[{

Cell["Apply[f, m, {1}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \({f[a, b, c], f[b, c, d]}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.3"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " at levels 0 through 1. "
}], "MathCaption",
  CellTags->{"S2.2.3", "3.10"}],

Cell[CellGroupData[{

Cell["Apply[f, m, {0, 1}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.3"],

Cell[BoxData[
    \(f[f[a, b, c], f[b, c, d]]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.4 Applying Functions to Parts of Expressions", "Subsection",
  CellTags->{"S2.2.4", "4.1"}],

Cell[TextData[{
  "If you have a list of elements, it is often important to be able to apply \
a function separately to each of the elements. You can do this in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["Map", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.2.4", "4.2"}],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " separately to each element in a list. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.3"}],

Cell[CellGroupData[{

Cell["Map[f, {a, b, c}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[a], f[b], f[c]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell["\<\
This defines a function which takes the first two elements from a \
list. \
\>", "MathCaption",
  CellTags->{"S2.2.4", "4.4"}],

Cell["take2[list_] := Take[list, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.4"],

Cell[TextData[{
  "You can use ",
  StyleBox["Map", "MR"],
  " to apply ",
  StyleBox["take2", "MR"],
  " to each element of a list. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.5"}],

Cell[CellGroupData[{

Cell["Map[take2, {{1, 3, 4}, {5, 6, 7}, {2, 1, 6, 6}}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{1, 3}, {5, 6}, {2, 1}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Map[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to each element in a list, giving ",
              StyleBox["{", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["b", "TI"],
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.4"],

Cell["Applying a function to each element in a list. ", "Caption",
  CellTags->"S2.2.4"],

Cell[TextData[{
  "What ",
  StyleBox["Map[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " effectively does is to \
\[OpenCurlyDoubleQuote]wrap\[CloseCurlyDoubleQuote] the function ",
  StyleBox["f", "TI"],
  " around each element of the expression ",
  StyleBox["expr", "TI"],
  ". You can use ",
  StyleBox["Map", "MR"],
  " on any expression, not just a list. "
}], "Text",
  CellTags->{"S2.2.4", "4.6"}],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to each element in the sum. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.7"}],

Cell[CellGroupData[{

Cell["Map[f, a + b + c]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(f[a] + f[b] + f[c]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["Sqrt", "MR"],
  " to each argument of\[NonBreakingSpace]",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.8"}],

Cell[CellGroupData[{

Cell["Map[Sqrt, g[x^2, x^3]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(g[\@x\^2, \@x\^3]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " to the first level of parts in ",
  StyleBox["expr", "TI"],
  ". You can use ",
  StyleBox["MapAll[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " to apply ",
  StyleBox["f", "TI"],
  " to ",
  StyleBox["all", "TI"],
  " the parts of ",
  StyleBox["expr", "TI"],
  ".  "
}], "Text",
  CellTags->{"S2.2.4", "4.9"}],

Cell[TextData[{
  "This defines a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " matrix ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.10"}],

Cell[CellGroupData[{

Cell["m = {{a, b}, {c, d}}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map", "MR"],
  " applies ",
  StyleBox["f", "MR"],
  " to the first level of ",
  StyleBox["m", "MR"],
  ", in this case the rows of the matrix. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.11"}],

Cell[CellGroupData[{

Cell["Map[f, m]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[{a, b}], f[{c, d}]}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MapAll", "MR"],
  " applies ",
  StyleBox["f", "MR"],
  " at ",
  StyleBox["all", "TI"],
  " levels in ",
  StyleBox["m", "MR"],
  ". If you look carefully at this expression, you will see an ",
  StyleBox["f", "MR"],
  " wrapped around every part. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.12"}],

Cell[CellGroupData[{

Cell["MapAll[f, m]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(f[{f[{f[a], f[b]}], f[{f[c], f[d]}]}]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "In general, you can use level specifications as described in Section\
\[NonBreakingSpace]",
  ButtonBox["2.1.7",
    ButtonData:>{"2.1.7", "7.8"},
    ButtonStyle->"MainBookLink"],
  " to tell ",
  StyleBox["Map", "MR"],
  " to which parts of an expression to apply your function. "
}], "Text",
  CellTags->{"S2.2.4", "4.13"}],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " only to the parts of ",
  StyleBox["m", "MR"],
  " at level 2. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.14"}],

Cell[CellGroupData[{

Cell["Map[f, m, {2}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{f[a], f[b]}, {f[c], f[d]}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "Setting the option ",
  StyleBox["Heads->True", "MR"],
  " wraps ",
  StyleBox["f", "MR"],
  " around the head of each part, as well as its elements. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.15"}],

Cell[CellGroupData[{

Cell["Map[f, m, Heads->True]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(\(f[List]\)[f[{a, b}], f[{c, d}]]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Map[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              " ",
              StyleBox["/@", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to the first\[Hyphen]level parts of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MapAll[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              " ",
              StyleBox["//@", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to all parts of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Map[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to each part of ",
              StyleBox["expr", "TI"],
              " at levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.4"],

Cell["Ways to apply a function to different parts of expressions. ", "Caption",
  CellTags->"S2.2.4"],

Cell[TextData[{
  "Level specifications allow you to tell ",
  StyleBox["Map", "MR"],
  " to which levels of parts in an expression you want a function applied. \
With ",
  StyleBox["MapAt", "MR"],
  ", however, you can instead give an explicit list of parts where you want a \
function applied. You specify each part by giving its indices, as discussed \
in Section ",
  ButtonBox["2.1.4",
    ButtonData:>{"2.1.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.2.4", "4.16"}],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.17"}],

Cell[CellGroupData[{

Cell["mm = {{a, b, c}, {b, c, d}}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to parts ",
  StyleBox["{1,", "MR"],
  " ",
  StyleBox["2}", "MR"],
  " and ",
  StyleBox["{2,", "MR"],
  " ",
  StyleBox["3}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.18"}],

Cell[CellGroupData[{

Cell["MapAt[f, mm, {{1, 2}, {2, 3}}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{a, f[b], c}, {b, c, f[d]}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "This gives a list of the positions at which ",
  StyleBox["b", "MR"],
  " occurs in ",
  StyleBox["mm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.19"}],

Cell[CellGroupData[{

Cell["Position[mm, b]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{1, 2}, {2, 1}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "You can feed the list of positions you get from ",
  StyleBox["Position", "MR"],
  " directly into ",
  StyleBox["MapAt", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.20"}],

Cell[CellGroupData[{

Cell["MapAt[f, mm, %]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({{a, f[b], c}, {f[b], c, d}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell["\<\
To avoid ambiguity, you must put each part specification in a list, \
even when it involves only one index. \
\>", "MathCaption",
  CellTags->{"S2.2.4", "4.21"}],

Cell[CellGroupData[{

Cell["MapAt[f, {a, b, c, d}, {{2}, {3}}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({a, f[b], f[c], d}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MapAt[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["part",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["part",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to specified parts of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.4"],

Cell["Applying a function to specific parts of an expression. ", "Caption",
  CellTags->"S2.2.4"],

Cell["Here is an expression. ", "MathCaption",
  CellTags->{"S2.2.4", "4.22"}],

Cell[CellGroupData[{

Cell["t = 1 + (3 + x)^2 / x", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(1 + \((3 + x)\)\^2\/x\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "This is the full form of ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.23"}],

Cell[CellGroupData[{

Cell["FullForm[ t ]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[1, Times[Power[x, \(-1\)], Power[Plus[3, x], 2]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[17]//FullForm= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["MapAt", "MR"],
  " on any expression. Remember that parts are numbered on the basis of the \
full forms of expressions. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.24"}],

Cell[CellGroupData[{

Cell["MapAt[f, t, {{2, 1, 1}, {2, 2}}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(1 + f[\((3 + x)\)\^2]\/f[x]\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MapIndexed[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              
              " to the elements of an expression, giving the part \
specification of each element as a second argument to ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MapIndexed[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              
              " to parts at specified levels, giving the list of indices for \
each part as a second argument to ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.4"],

Cell["Applying a function to parts and their indices. ", "Caption",
  CellTags->"S2.2.4"],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to each element in a list, giving the index of the element as a second \
argument to ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.25"}],

Cell[CellGroupData[{

Cell["MapIndexed[f, {a, b, c}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[a, {1}], f[b, {2}], f[c, {3}]}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to both levels in a matrix. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.26"}],

Cell[CellGroupData[{

Cell["MapIndexed[f, {{a, b}, {c, d}}, 2]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[{f[a, {1, 1}], f[b, {1, 2}]}, {1}], 
      f[{f[c, {2, 1}], f[d, {2, 2}]}, {2}]}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map", "MR"],
  " allows you to apply a function of one argument to parts of an expression. \
Sometimes, however, you may instead want to apply a function of several \
arguments to corresponding parts of several different expressions. You can do \
this using ",
  StyleBox["MapThread", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.2.4", "4.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MapThread[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to corresponding elements in each of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MapThread[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to parts of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at the specified level "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.4"],

Cell["Applying a function to several expressions at once. ", "Caption",
  CellTags->"S2.2.4"],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to corresponding pairs of list elements. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.28"}],

Cell[CellGroupData[{

Cell["MapThread[f, {{a, b, c}, {ap, bp, cp}}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[a, ap], f[b, bp], f[c, cp]}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MapThread", "MR"],
  " works with any number of expressions, so long as they have the same \
structure. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.29"}],

Cell[CellGroupData[{

Cell["MapThread[f, {{a, b}, {ap, bp}, {app, bpp}}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[a, ap, app], f[b, bp, bpp]}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Map", "MR"],
  " allow you to create expressions with parts modified. Sometimes you simply \
want to go through an expression, and apply a particular function to some \
parts of it, without building a new expression. A typical case is when the \
function you apply has certain \[OpenCurlyDoubleQuote]side effects\
\[CloseCurlyDoubleQuote], such as making assignments, or generating output. "
}], "Text",
  CellTags->{"S2.2.4", "4.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Scan[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["f", "TI"],
              " applied to each element of ",
              StyleBox["expr", "TI"],
              " in turn "
            }]]},
          {Cell[TextData[{
              StyleBox["Scan[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["f", "TI"],
              " applied to parts of ",
              StyleBox["expr", "TI"],
              " on levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.4"],

Cell["Evaluating functions on parts of expressions. ", "Caption",
  CellTags->"S2.2.4"],

Cell[TextData[{
  StyleBox["Map", "MR"],
  " constructs a new list in which ",
  StyleBox["f", "MR"],
  " has been applied to each element of the list. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.31"}],

Cell[CellGroupData[{

Cell["Map[f, {a, b, c}]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \({f[a], f[b], f[c]}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Scan", "MR"],
  " evaluates the result of applying a function to each element, but does not \
construct a new expression. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.32"}],

Cell[CellGroupData[{

Cell["Scan[Print, {a, b, c}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(a\)], "Print",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(b\)], "Print",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(c\)], "Print",
  CellTags->"S2.2.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Scan", "MR"],
  " visits the parts of an expression in a depth\[Hyphen]first walk, with the \
leaves visited first. "
}], "MathCaption",
  CellTags->{"S2.2.4", "4.33"}],

Cell[CellGroupData[{

Cell["Scan[Print, 1 + x^2, Infinity]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(x\)], "Print",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.2.4"],

Cell[BoxData[
    \(x\^2\)], "Print",
  CellTags->"S2.2.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.5 Pure Functions", "Subsection",
  CellTags->{"S2.2.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Function[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pure function in which ",
              StyleBox["x", "TI"],
              " is replaced by any argument you provide "
            }]]},
          {Cell[TextData[{
              StyleBox["Function[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a pure function that takes several arguments "]},
          {Cell[TextData[{
              StyleBox["body", "TI"],
              " ",
              StyleBox["&", "MR"],
              " "
            }]], Cell[TextData[{
              "a pure function in which arguments are specified as ",
              StyleBox["#", "MR"],
              " or ",
              StyleBox["#1", "MR"],
              ", ",
              StyleBox["#2", "MR"],
              ", ",
              StyleBox["#3", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.5"],

Cell["Pure functions. ", "Caption",
  CellTags->"S2.2.5"],

Cell[TextData[{
  "When you use functional operations such as ",
  StyleBox["Nest", "MR"],
  " and ",
  StyleBox["Map", "MR"],
  ", you always have to specify a function to apply. In all the examples \
above, we have used the \[OpenCurlyDoubleQuote]name\[CloseCurlyDoubleQuote] \
of a function to specify the function. Pure functions allow you to give \
functions which can be applied to arguments, without having to define \
explicit names for the functions. "
}], "Text",
  CellTags->{"S2.2.5", "5.2"}],

Cell[TextData[{
  "This defines a function ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.3"}],

Cell["h[x_] := f[x] + g[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.5"],

Cell[TextData[{
  "Having defined ",
  StyleBox["h", "MR"],
  ", you can now use its name in ",
  StyleBox["Map", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.4"}],

Cell[CellGroupData[{

Cell["Map[h, {a, b, c}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \({f[a] + g[a], f[b] + g[b], f[c] + g[c]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell["Here is a way to get the same result using a pure function. ", \
"MathCaption",
  CellTags->{"S2.2.5", "5.5"}],

Cell[CellGroupData[{

Cell["Map[ f[#] + g[#] &, {a, b, c} ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \({f[a] + g[a], f[b] + g[b], f[c] + g[c]}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  "There are several equivalent ways to write pure functions in ",
  StyleBox["Mathematica", "TI"],
  ". The idea in all cases is to construct an object which, when supplied \
with appropriate arguments, computes a particular function. Thus, for \
example, if ",
  StyleBox["fun", "TI"],
  " is a pure function, then ",
  StyleBox["fun", "TI"],
  StyleBox["[", "MR"],
  StyleBox["a", "TI"],
  StyleBox["]", "MR"],
  " evaluates the function with argument ",
  StyleBox["a", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.2.5", "5.6"}],

Cell["\<\
Here is a pure function which represents the operation of squaring. \
\
\>", "MathCaption",
  CellTags->{"S2.2.5", "5.7"}],

Cell[CellGroupData[{

Cell["Function[x, x^2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(Function[x, x\^2]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  "Supplying the argument ",
  StyleBox["n", "MR"],
  " to the pure function yields the square of ",
  StyleBox["n", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.8"}],

Cell[CellGroupData[{

Cell["%[n]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(n\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell["\<\
You can use a pure function wherever you would usually give the \
name of a function. \
\>", "Text",
  CellTags->{"S2.2.5", "5.9"}],

Cell[TextData[{
  "You can use a pure function in ",
  StyleBox["Map", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.10"}],

Cell[CellGroupData[{

Cell["Map[ Function[x, x^2], a + b + c ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(a\^2 + b\^2 + c\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  "Or in ",
  StyleBox["Nest", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.11"}],

Cell[CellGroupData[{

Cell["Nest[ Function[q, 1/(1+q)], x, 3 ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(1\/\(1 + 1\/\(1 + 1\/\(1 + x\)\)\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  "This sets up a pure function with two arguments and then applies the \
function to the arguments ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.12"}],

Cell[CellGroupData[{

Cell["Function[{x, y}, x^2 + y^3] [a, b]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(a\^2 + b\^3\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  "If you are going to use a particular function repeatedly, then you can \
define the function using ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["body", "TI"],
  ", and refer to the function by its name ",
  StyleBox["f", "TI"],
  ". On the other hand, if you only intend to use a function once, you will \
probably find it better to give the function in pure function form, without \
ever naming it. "
}], "Text",
  CellTags->{"S2.2.5", "5.13"}],

Cell[TextData[{
  "If you are familiar with formal logic or the LISP programming language, \
you will recognize ",
  StyleBox["Mathematica", "TI"],
  " pure functions as being like ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " expressions or anonymous functions. Pure functions are also close to the \
pure mathematical notion of operators. "
}], "Text",
  CellTags->{"S2.2.5", "5.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["#", "MR"],
              " "
            }]], Cell["the first variable in a pure function "]},
          {Cell[TextData[{
              StyleBox["#", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " variable in a pure function "
            }]]},
          {Cell[TextData[{
              StyleBox["##", "MR"],
              " "
            }]], Cell["the sequence of all variables in a pure function "]},
          {Cell[TextData[{
              StyleBox["##", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the sequence of variables starting with the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " one "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.5"],

Cell["Short forms for pure functions. ", "Caption",
  CellTags->"S2.2.5"],

Cell[TextData[{
  "Just as the name of a function is irrelevant if you do not intend to refer \
to the function again, so also the names of arguments in a pure function are \
irrelevant. ",
  StyleBox["Mathematica", "TI"],
  " allows you to avoid using explicit names for the arguments of pure \
functions, and instead to specify the arguments by giving \
\[OpenCurlyDoubleQuote]slot numbers\[CloseCurlyDoubleQuote] ",
  StyleBox["#", "MR"],
  StyleBox["n", "TI"],
  ". In a ",
  StyleBox["Mathematica", "TI"],
  " pure function, ",
  StyleBox["#", "MR"],
  StyleBox["n", "TI"],
  " stands for the ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " argument you supply. ",
  StyleBox["#", "MR"],
  " stands for the first argument. "
}], "Text",
  CellTags->{"S2.2.5", "5.15"}],

Cell[TextData[{
  StyleBox["#^2", "MR"],
  " ",
  StyleBox["&", "MR"],
  " is a short form for a pure function that squares its argument. "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.16"}],

Cell[CellGroupData[{

Cell["Map[ #^2 &, a + b + c ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(a\^2 + b\^2 + c\^2\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell["\<\
This applies a function that takes the first two elements from each \
list. By using a pure function, you avoid having to define the function \
separately. \
\>", "MathCaption",
  CellTags->{"S2.2.5", "5.17"}],

Cell[CellGroupData[{

Cell["Map[Take[#, 2]&, {{2, 1, 7}, {4, 1, 5}, {3, 1, 2}}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \({{2, 1}, {4, 1}, {3, 1}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  "Using short forms for pure functions, you can simplify the definition of \
",
  StyleBox["fromdigits", "MR"],
  " given in Section\[NonBreakingSpace]",
  ButtonBox["2.2.2",
    ButtonData:>{"2.2.2", "2.22"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.18"}],

Cell["fromdigits[digits_] := Fold[(10 #1 + #2)&, 0, digits]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.2.5"],

Cell[TextData[{
  "When you use short forms for pure functions, it is very important that you \
do not forget the ampersand. If you leave the ampersand out, ",
  StyleBox["Mathematica", "TI"],
  " will not know that the expression you give is to be used as a pure \
function. "
}], "Text",
  CellTags->{"S2.2.5", "5.19"}],

Cell[TextData[{
  "When you use the ampersand notation for pure functions, you must be \
careful about the grouping of pieces in your input. As shown in Section\
\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.3"},
    ButtonStyle->"MainBookLink"],
  " the ampersand notation has fairly low precedence, which means that you \
can type expressions like ",
  StyleBox["#1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["#2", "MR"],
  " ",
  StyleBox["&", "MR"],
  " without parentheses. On the other hand, if you want, for example, to set \
an option to be a pure function, you need to use parentheses, as in ",
  StyleBox["option", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["(", "MR"],
  StyleBox["fun", "TI"],
  " ",
  StyleBox["&)", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.2.5", "5.20"}],

Cell[TextData[{
  "Pure functions in ",
  StyleBox["Mathematica", "TI"],
  " can take any number of arguments. You can use ",
  StyleBox["##", "MR"],
  " to stand for all the arguments that are given, and ",
  StyleBox["##", "MR"],
  StyleBox["n", "TI"],
  " to stand for the ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " and subsequent arguments. "
}], "Text",
  CellTags->{"S2.2.5", "5.21"}],

Cell[TextData[{
  StyleBox["##", "MR"],
  " stands for all arguments. "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.22"}],

Cell[CellGroupData[{

Cell["f[##, ##]& [x, y]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \(f[x, y, x, y]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.2.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["##2", "MR"],
  " stands for all arguments except the first one. "
}], "MathCaption",
  CellTags->{"S2.2.5", "5.23"}],

Cell[CellGroupData[{

Cell["Apply[f[##2, #1]&, {{a, b, c}, {ap, bp}}, {1}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.2.5"],

Cell[BoxData[
    \({f[b, c, a], f[bp, ap]}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.2.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.6 Building Lists from Functions", "Subsection",
  CellTags->{"S2.2.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a length ",
              StyleBox["n", "TI"],
              " list of the form ",
              StyleBox["{", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[1],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[2],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "..."}], TraditionalForm]],
                 "InlineFormula"],
              " nested list, each of whose entries consists of ",
              StyleBox["f", "TI"],
              " applied to its indices "
            }]]},
          {Cell[TextData[{
              StyleBox["NestList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a list of the form ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              ", where ",
              StyleBox["f", "TI"],
              " is nested up to ",
              StyleBox["n", "TI"],
              " deep "
            }]]},
          {Cell[TextData[{
              StyleBox["FoldList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a list of the form ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ComposeList[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a list of the form ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.6"],

Cell["Making lists from functions. ", "Caption",
  CellTags->"S2.2.6"],

Cell[TextData[{
  "This makes a list of 5 elements, each of the form ",
  StyleBox["p[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.6", "6.2"}],

Cell[CellGroupData[{

Cell["Array[p, 5]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.6"],

Cell[BoxData[
    \({p[1], p[2], p[3], p[4], p[5]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.6"]
}, Open  ]],

Cell["Here is another way to produce the same list. ", "MathCaption",
  CellTags->{"S2.2.6", "6.3"}],

Cell[CellGroupData[{

Cell["Table[p[i], {i, 5}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.6"],

Cell[BoxData[
    \({p[1], p[2], p[3], p[4], p[5]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.6"]
}, Open  ]],

Cell[TextData[{
  "This produces a list whose elements are ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["i",
            "TI"], "+", 
          SuperscriptBox[
            StyleBox["i",
              "TI"], "2"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.6", "6.4"}],

Cell[CellGroupData[{

Cell["Array[ # + #^2 &, 5]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.6"],

Cell[BoxData[
    \({2, 6, 12, 20, 30}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.6"]
}, Open  ]],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " matrix whose entries are ",
  StyleBox["m[", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["j", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.6", "6.5"}],

Cell[CellGroupData[{

Cell["Array[m, {2, 3}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.6"],

Cell[BoxData[
    \({{m[1, 1], m[1, 2], m[1, 3]}, {m[2, 1], m[2, 2], m[2, 3]}}\)], "Output",\

  CellLabel->"Out[4]= ",
  CellTags->"S2.2.6"]
}, Open  ]],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " matrix whose elements are the squares of the sums of their indices. "
}], "MathCaption",
  CellTags->{"S2.2.6", "6.6"}],

Cell[CellGroupData[{

Cell["Array[Plus[##]^2 &, {3, 3}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.6"],

Cell[BoxData[
    \({{4, 9, 16}, {9, 16, 25}, {16, 25, 36}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["NestList", "MR"],
  " and ",
  StyleBox["FoldList", "MR"],
  " were discussed in Section ",
  ButtonBox["2.2.2",
    ButtonData:>{"2.2.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ". Particularly by using them with pure functions, you can construct some \
very elegant and efficient ",
  StyleBox["Mathematica", "TI"],
  " programs. "
}], "Text",
  CellTags->{"S2.2.6", "6.7"}],

Cell[TextData[{
  "This gives a list of results obtained by successively differentiating ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " with respect to ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.6", "6.8"}],

Cell[CellGroupData[{

Cell["NestList[ D[#, x]&, x^n, 3 ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.6"],

Cell[BoxData[
    \({x\^n, 
      n\ x\^\(\(-1\) + n\), \((\(-1\) + 
            n)\)\ n\ x\^\(\(-2\) + n\), \((\(-2\) + n)\)\ \((\(-1\) + 
            n)\)\ n\ x\^\(\(-3\) + n\)}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.7 Selecting Parts of Expressions with Functions", "Subsection",
  CellTags->{"S2.2.7", "7.1"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.2.4",
    ButtonData:>{"1.2.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  " showed how you can pick out elements of lists based on their ",
  StyleBox["positions", "TI"],
  ". Often, however, you will need to select elements based not on ",
  StyleBox["where", "TI"],
  " they are, but rather on ",
  StyleBox["what", "TI"],
  " they are. "
}], "Text",
  CellTags->{"S2.2.7", "7.2"}],

Cell[TextData[{
  StyleBox["Select[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " selects elements of ",
  StyleBox["list", "TI"],
  " using the function ",
  StyleBox["f", "TI"],
  " as a criterion. ",
  StyleBox["Select", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " to each element of ",
  StyleBox["list", "TI"],
  " in turn, and keeps only those for which the result is ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.2.7", "7.3"}],

Cell[TextData[{
  "This selects the elements of the list for which the pure function yields \
",
  StyleBox["True", "MR"],
  ", i.e., those numerically greater than 4. "
}], "MathCaption",
  CellTags->{"S2.2.7", "7.4"}],

Cell[CellGroupData[{

Cell["Select[{2, 15, 1, a, 16, 17}, # > 4 &]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.7"],

Cell[BoxData[
    \({15, 16, 17}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.7"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Select", "MR"],
  " to pick out pieces of any expression, not just elements of a list. "
}], "Text",
  CellTags->{"S2.2.7", "7.5"}],

Cell[TextData[{
  "This gives a sum of terms involving ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["y", "MR"],
  " and ",
  StyleBox["z", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.7", "7.6"}],

Cell[CellGroupData[{

Cell["t = Expand[(x + y + z)^2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.7"],

Cell[BoxData[
    \(x\^2 + 2\ x\ y + y\^2 + 2\ x\ z + 2\ y\ z + z\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.7"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Select", "MR"],
  " to pick out only those terms in the sum that do not involve the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.7", "7.7"}],

Cell[CellGroupData[{

Cell["Select[t, FreeQ[#, x]&]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.7"],

Cell[BoxData[
    \(y\^2 + 2\ y\ z + z\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Select[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "select the elements in ",
              StyleBox["expr", "TI"],
              " for which the function ",
              StyleBox["f", "TI"],
              " gives ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Select[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "select the first ",
              StyleBox["n", "TI"],
              " elements in ",
              StyleBox["expr", "TI"],
              " for which the function ",
              StyleBox["f", "TI"],
              " gives ",
              StyleBox["True", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.7"],

Cell["Selecting pieces of expressions. ", "Caption",
  CellTags->"S2.2.7"],

Cell[TextData[{
  "Section ",
  ButtonBox["2.3.5",
    ButtonData:>{"2.3.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " discusses some \[OpenCurlyDoubleQuote]predicates\[CloseCurlyDoubleQuote] \
that are often used as criteria in ",
  StyleBox["Select", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.2.7", "7.8"}],

Cell["\<\
This gives the first element which satisfies the criterion you \
specify. \
\>", "MathCaption",
  CellTags->{"S2.2.7", "7.9"}],

Cell[CellGroupData[{

Cell["Select[{-1, 3, 10, 12, 14}, # > 3 &, 1]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.7"],

Cell[BoxData[
    \({10}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.8 Expressions with Heads That Are Not Symbols", "Subsection",
  CellTags->{"S2.2.8", "8.1"}],

Cell[TextData[{
  "In most cases, you want the head ",
  StyleBox["f", "TI"],
  " of a ",
  StyleBox["Mathematica", "TI"],
  " expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " to be a single symbol. There are, however, some important applications of \
heads that are not symbols. "
}], "Text",
  CellTags->{"S2.2.8", "8.2"}],

Cell[TextData[{
  "This expression has ",
  StyleBox["f[3]", "MR"],
  " as a head. You can use heads like this to represent \
\[OpenCurlyDoubleQuote]indexed functions\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.3"}],

Cell[CellGroupData[{

Cell["f[3][x, y]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    \(\(f[3]\)[x, y]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell["\<\
You can use any expression as a head. Remember to put in the \
necessary parentheses. \
\>", "MathCaption",
  CellTags->{"S2.2.8", "8.4"}],

Cell[CellGroupData[{

Cell["(a + b)[x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    \(\((a + b)\)[x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell[TextData[{
  "One case where we have already encountered the use of complicated \
expressions as heads is in working with pure functions in Section ",
  ButtonBox["2.2.5",
    ButtonData:>{"2.2.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ". By giving ",
  StyleBox["Function[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " as the head of an expression, you specify a function of the arguments to \
be evaluated. "
}], "Text",
  CellTags->{"S2.2.8", "8.5"}],

Cell[TextData[{
  "With the head ",
  StyleBox["Function[x,", "MR"],
  " ",
  StyleBox["x^2]", "MR"],
  ", the value of the expression is the square of the argument. "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.6"}],

Cell[CellGroupData[{

Cell["Function[x, x^2] [a + b]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    \(\((a + b)\)\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell[TextData[{
  "There are several constructs in ",
  StyleBox["Mathematica", "TI"],
  " which work much like pure functions, but which represent specific kinds \
of functions, typically numerical ones. In all cases, the basic mechanism \
involves giving a head which contains complete information about the function \
you want to use. "
}], "Text",
  CellTags->{"S2.2.8", "8.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Function[", "MR"],
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["][", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["pure function "]},
          {Cell[TextData[{
              StyleBox["InterpolatingFunction[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["][", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "approximate numerical function (generated by ",
              StyleBox["Interpolation", "MR"],
              " and ",
              StyleBox["NDSolve", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["CompiledFunction[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["][", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "compiled numerical function (generated by ",
              StyleBox["Compile", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["LinearSolveFunction[", "MR"],
              StyleBox["data", "TI"],
              StyleBox["][", "MR"],
              StyleBox["vec", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "matrix solution function (generated by ",
              StyleBox["LinearSolve", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.8"],

Cell["Some expressions which have heads that are not symbols. ", "Caption",
  CellTags->"S2.2.8"],

Cell[TextData[{
  StyleBox["NDSolve", "MR"],
  " returns a list of rules that give ",
  StyleBox["y", "MR"],
  " as an ",
  StyleBox["InterpolatingFunction", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.8"}],

Cell[CellGroupData[{

Cell["NDSolve[{y''[x] == y[x], y[0]==y'[0]==1}, y, {x, 0, 5}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"y", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell[TextData[{
  "Here is the ",
  StyleBox["InterpolatingFunction", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.9"}],

Cell[CellGroupData[{

Cell["y /. First[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell[TextData[{
  "You can use the ",
  StyleBox["InterpolatingFunction", "MR"],
  " object as a head to get numerical approximations to values of the \
function ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.10"}],

Cell[CellGroupData[{

Cell["% [3.8]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    \(44.70118814328359`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell[TextData[{
  "Another important use of more complicated expressions as heads is in \
implementing ",
  StyleBox["functionals", "TI"],
  " and ",
  StyleBox["functional operators", "TI"],
  " in mathematics. "
}], "Text",
  CellTags->{"S2.2.8", "8.11"}],

Cell[TextData[{
  "As one example, consider the operation of differentiation. As will be \
discussed in Section ",
  ButtonBox["3.5.4",
    ButtonData:>{"3.5.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ", an expression like ",
  StyleBox["f'", "MR"],
  " represents a ",
  StyleBox["derivative function", "TI"],
  ", obtained from ",
  StyleBox["f", "MR"],
  " by applying a functional operator to it. In ",
  StyleBox["Mathematica", "TI"],
  ", ",
  StyleBox["f'", "MR"],
  " is represented as ",
  StyleBox["Derivative[1][f]", "MR"],
  ": the \[OpenCurlyDoubleQuote]functional operator\[CloseCurlyDoubleQuote] \
",
  StyleBox["Derivative[1]", "MR"],
  " is applied to ",
  StyleBox["f", "MR"],
  " to give another function, represented as ",
  StyleBox["f'", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.2.8", "8.12"}],

Cell[TextData[{
  "This expression has a head which represents the application of the \
\[OpenCurlyDoubleQuote]functional operator\[CloseCurlyDoubleQuote] ",
  StyleBox["Derivative[1]", "MR"],
  " to the \[OpenCurlyDoubleQuote]function\[CloseCurlyDoubleQuote] ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.13"}],

Cell[CellGroupData[{

Cell["f'[x] // FullForm", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\(Derivative[1]\)[f]\)[x]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[7]//FullForm= ",
  CellTags->"S2.2.8"]
}, Open  ]],

Cell[TextData[{
  "You can replace the head ",
  StyleBox["f'", "MR"],
  " with another head, such as ",
  StyleBox["fp", "MR"],
  ". This effectively takes ",
  StyleBox["fp", "MR"],
  " to be a \[OpenCurlyDoubleQuote]derivative \
function\[CloseCurlyDoubleQuote] obtained from ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.8", "8.14"}],

Cell[CellGroupData[{

Cell["% /. f' -> fp", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.8"],

Cell[BoxData[
    \(fp[x]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.9 Advanced Topic: Working with Operators", "Subsection",
  CellTags->{"S2.2.9", "9.1"}],

Cell[TextData[{
  "You can think of an expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " as being formed by applying an ",
  StyleBox["operator", "TI"],
  " ",
  StyleBox["f", "TI"],
  " to the expression ",
  StyleBox["x", "TI"],
  ". You can think of an expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  " as the result of ",
  StyleBox["composing", "TI"],
  " the operators ",
  StyleBox["f", "TI"],
  " and ",
  StyleBox["g", "TI"],
  ", and applying the result to ",
  StyleBox["x", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.2.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Composition[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the composition of functions ",
              StyleBox["f", "TI"],
              ", ",
              StyleBox["g", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["InverseFunction[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the inverse of a function ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Identity", "MR"],
              " "
            }]], Cell["the identity function "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.9"],

Cell["Some functional operations. ", "Caption",
  CellTags->"S2.2.9"],

Cell[TextData[{
  "This represents the composition of the functions ",
  StyleBox["f", "MR"],
  ", ",
  StyleBox["g", "MR"],
  " and ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.3"}],

Cell[CellGroupData[{

Cell["Composition[f, g, h]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(Composition[f, g, h]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell["You can manipulate compositions of functions symbolically. ", \
"MathCaption",
  CellTags->{"S2.2.9", "9.4"}],

Cell[CellGroupData[{

Cell["InverseFunction[Composition[%, q]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    RowBox[{"Composition", "[", 
      RowBox[{
        TagBox[\(q\^\((\(-1\))\)\),
          InverseFunction,
          Editable->False], ",", 
        TagBox[\(h\^\((\(-1\))\)\),
          InverseFunction,
          Editable->False], ",", 
        TagBox[\(g\^\((\(-1\))\)\),
          InverseFunction,
          Editable->False], ",", 
        TagBox[\(f\^\((\(-1\))\)\),
          InverseFunction,
          Editable->False]}], "]"}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell["\<\
The composition is evaluated explicitly when you supply a specific \
argument. \
\>", "MathCaption",
  CellTags->{"S2.2.9", "9.5"}],

Cell[CellGroupData[{

Cell["%[x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    RowBox[{
      TagBox[\(q\^\((\(-1\))\)\),
        InverseFunction,
        Editable->False], "[", 
      RowBox[{
        TagBox[\(h\^\((\(-1\))\)\),
          InverseFunction,
          Editable->False], "[", 
        RowBox[{
          TagBox[\(g\^\((\(-1\))\)\),
            InverseFunction,
            Editable->False], "[", 
          RowBox[{
            TagBox[\(f\^\((\(-1\))\)\),
              InverseFunction,
              Editable->False], "[", "x", "]"}], "]"}], "]"}], 
      "]"}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "You can get the sum of two expressions in ",
  StyleBox["Mathematica", "TI"],
  " just by typing ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "TI"],
  ". Sometimes it is also worthwhile to consider performing operations like \
addition on ",
  StyleBox["operators", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.2.9", "9.6"}],

Cell[TextData[{
  "You can think of this as containing a sum of two operators ",
  StyleBox["f", "MR"],
  " and ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.7"}],

Cell[CellGroupData[{

Cell["(f + g)[x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\((f + g)\)[x]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Through", "MR"],
  ", you can convert the expression to a more explicit form. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.8"}],

Cell[CellGroupData[{

Cell["Through[%, Plus]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(f[x] + g[x]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "This corresponds to the mathematical operator ",
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "+", 
          FractionBox["\[PartialD]", 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                "TI"]}]]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.9"}],

Cell[CellGroupData[{

Cell["Identity + (D[#, x]&)", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(Identity + \((\[PartialD]\_x #1 &)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " does not automatically apply the separate pieces of the operator to an \
expression. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.10"}],

Cell[CellGroupData[{

Cell["% [x^2]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\((Identity + \((\[PartialD]\_x #1 &)\))\)[x\^2]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Through", "MR"],
  " to apply the operator. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.11"}],

Cell[CellGroupData[{

Cell["Through[%, Plus]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(2\ x + x\^2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Identity[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the identity function "]},
          {Cell[TextData[{
              StyleBox["Through[", "MR"],
              StyleBox["p", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["][", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["q", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["p", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["f",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]]", "MR"],
              " if ",
              StyleBox["p", "TI"],
              " is the same as ",
              StyleBox["q", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Operate[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["p", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["][", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Operate[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["p", "TI"],
              " at level ",
              StyleBox["n", "TI"],
              " in ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MapAll[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Heads->True]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["p", "TI"],
              " to all parts of ",
              StyleBox["expr", "TI"],
              ", including heads "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.9"],

Cell["Operations for working with operators. ", "Caption",
  CellTags->"S2.2.9"],

Cell["This has a complicated expression as a head. ", "MathCaption",
  CellTags->{"S2.2.9", "9.12"}],

Cell[CellGroupData[{

Cell["t = ((1 + a)(1 + b))[x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\((\((1 + a)\)\ \((1 + b)\))\)[x]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Expand", "MR"],
  " do not automatically go inside heads of expressions. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.13"}],

Cell[CellGroupData[{

Cell["Expand[%]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\((\((1 + a)\)\ \((1 + b)\))\)[x]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "With the ",
  StyleBox["Heads", "MR"],
  " option set to ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["MapAll", "MR"],
  " goes inside heads. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.14"}],

Cell[CellGroupData[{

Cell["MapAll[Expand, t, Heads->True]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\((1 + a + b + a\ b)\)[x]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "The replacement operator ",
  StyleBox["/.", "MR"],
  " does go inside heads of expressions. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.15"}],

Cell[CellGroupData[{

Cell["t /. a->1", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\((2\ \((1 + b)\))\)[x]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.2.9"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Operate", "MR"],
  " to apply a function specifically to the head of an expression. "
}], "MathCaption",
  CellTags->{"S2.2.9", "9.16"}],

Cell[CellGroupData[{

Cell["Operate[p, t]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.2.9"],

Cell[BoxData[
    \(\(p[\((1 + a)\)\ \((1 + b)\)]\)[x]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.2.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.10 Structural Operations", "Subsection",
  CellTags->{"S2.2.10", "10.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " contains some powerful primitives for making structural changes to \
expressions. You can use these primitives both to implement mathematical \
properties such as associativity and distributivity, and to provide the basis \
for some succinct and efficient programs. "
}], "Text",
  CellTags->{"S2.2.10", "10.2"}],

Cell[TextData[{
  "This section describes various operations that you can explicitly perform \
on expressions. Section ",
  ButtonBox["2.6.3",
    ButtonData:>{"2.6.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " will describe how some of these operations can be performed automatically \
on all expressions with a particular head by assigning appropriate attributes \
to that head. "
}], "Text",
  CellTags->{"S2.2.10", "10.3"}],

Cell[TextData[{
  "You can use the ",
  StyleBox["Mathematica", "TI"],
  " function ",
  StyleBox["Sort[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " to sort elements not only of lists, but of expressions with any head. In \
this way, you can implement the mathematical properties of commutativity or \
symmetry for arbitrary functions. "
}], "Text",
  CellTags->{"S2.2.10", "10.4"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Sort", "MR"],
  " to put the arguments of any function into a standard order. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.5"}],

Cell[CellGroupData[{

Cell["Sort[ f[c, a, b] ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(f[a, b, c]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sort[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
sort the elements of a list or other expression into a \
standard order \
\>"]},
          {Cell[TextData[{
              StyleBox["Sort[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["pred", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sort using the function ",
              StyleBox["pred", "TI"],
              " to determine whether pairs are in order "
            }]]},
          {Cell[TextData[{
              StyleBox["Ordering[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the ordering of elements when sorted "]},
          {Cell[TextData[{
              StyleBox["Ordering[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the ordering of the first ",
              StyleBox["n", "TI"],
              " elements when sorted "
            }]]},
          {Cell[TextData[{
              StyleBox["Ordering[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["pred", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use the function ",
              StyleBox["pred", "TI"],
              " to determine whether pairs are in order "
            }]]},
          {Cell[TextData[{
              StyleBox["OrderedQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if the elements of ",
              StyleBox["expr", "TI"],
              " are in standard order, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["Order[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["1", "MR"],
              " if ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " comes before ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " in standard order, and ",
              StyleBox["-1", "MR"],
              " if it comes after "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.10"],

Cell["Sorting into order. ", "Caption",
  CellTags->"S2.2.10"],

Cell[TextData[{
  "The second argument to ",
  StyleBox["Sort", "MR"],
  " is a function used to determine whether pairs are in order. This sorts \
numbers into descending order. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.6"}],

Cell[CellGroupData[{

Cell["Sort[ {5, 1, 8, 2}, (#2 < #1)& ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({8, 5, 2, 1}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "This sorting criterion puts elements that do not depend on ",
  StyleBox["x", "MR"],
  " before those that do. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.7"}],

Cell[CellGroupData[{

Cell["Sort[ {x^2, y, x+y, y-2}, FreeQ[#1, x]& ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({y, \(-2\) + y, x + y, x\^2}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten out all nested functions with the same head as ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten at most ",
              StyleBox["n", "TI"],
              " levels of nesting "
            }]]},
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten functions with head ",
              StyleBox["h", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FlattenAt[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten only the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.10"],

Cell["Flattening out expressions. ", "Caption",
  CellTags->"S2.2.10"],

Cell[TextData[{
  StyleBox["Flatten", "MR"],
  " removes nested occurrences of a function. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.8"}],

Cell[CellGroupData[{

Cell["Flatten[ f[a, f[b, c], f[f[d]]] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(f[a, b, c, d]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Flatten", "MR"],
  " to \[OpenCurlyDoubleQuote]splice\[CloseCurlyDoubleQuote] sequences of \
elements into lists or other expressions. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.9"}],

Cell[CellGroupData[{

Cell["Flatten[ {a, f[b, c], f[a, b, d]}, 1, f ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({a, b, c, a, b, d}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Flatten", "MR"],
  " to implement the mathematical property of associativity. The function ",
  StyleBox["Distribute", "MR"],
  " allows you to implement properties such as distributivity and linearity. \
"
}], "Text",
  CellTags->{"S2.2.10", "10.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Distribute[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "distribute ",
              StyleBox["f", "TI"],
              " over sums to give ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Distribute[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "distribute ",
              StyleBox["f", "TI"],
              " over any arguments which have head ",
              StyleBox["g", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Distribute[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "distribute only when the head is ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Distribute[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["gp", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["fp", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "distribute ",
              StyleBox["f", "TI"],
              " over ",
              StyleBox["g", "TI"],
              ", replacing them with ",
              StyleBox["fp", "TI"],
              " and ",
              StyleBox["gp", "TI"],
              ", respectively "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.10"],

Cell["Applying distributive laws. ", "Caption",
  CellTags->"S2.2.10"],

Cell[TextData[{
  "This \[OpenCurlyDoubleQuote]distributes\[CloseCurlyDoubleQuote] ",
  StyleBox["f", "MR"],
  " over ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.11"}],

Cell[CellGroupData[{

Cell["Distribute[ f[a + b] ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(f[a] + f[b]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell["Here is a more complicated example. ", "MathCaption",
  CellTags->{"S2.2.10", "10.12"}],

Cell[CellGroupData[{

Cell["Distribute[ f[a + b, c + d] ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(f[a, c] + f[a, d] + f[b, c] + f[b, d]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "In general, if ",
  StyleBox["f", "TI"],
  " is distributive over ",
  StyleBox["Plus", "MR"],
  ", then an expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["a", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " can be \[OpenCurlyDoubleQuote]expanded\[CloseCurlyDoubleQuote] to give ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["a", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  ". The function ",
  StyleBox["Expand", "MR"],
  " does this kind of expansion for standard algebraic operators such as ",
  StyleBox["Times", "MR"],
  ". ",
  StyleBox["Distribute", "MR"],
  " allows you to perform the same kind of expansion for arbitrary operators. \
"
}], "Text",
  CellTags->{"S2.2.10", "10.13"}],

Cell[TextData[{
  StyleBox["Expand", "MR"],
  " uses the distributivity of ",
  StyleBox["Times", "MR"],
  " over ",
  StyleBox["Plus", "MR"],
  " to perform algebraic expansions. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.14"}],

Cell[CellGroupData[{

Cell["Expand[ (a + b) (c + d) ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(a\ c + b\ c + a\ d + b\ d\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell["\<\
This applies distributivity over lists, rather than sums. The \
result contains all possible pairs of arguments. \
\>", "MathCaption",
  CellTags->{"S2.2.10", "10.15"}],

Cell[CellGroupData[{

Cell["Distribute[ f[{a, b}, {c, d}], List ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({f[a, c], f[a, d], f[b, c], f[b, d]}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "This distributes over lists, but does so only if the head of the whole \
expression is ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.16"}],

Cell[CellGroupData[{

Cell["Distribute[ f[{a, b}, {c, d}], List, f ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({f[a, c], f[a, d], f[b, c], f[b, d]}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "This distributes over lists, making sure that the head of the whole \
expression is ",
  StyleBox["f", "MR"],
  ". In the result, it uses ",
  StyleBox["gp", "MR"],
  " in place of ",
  StyleBox["List", "MR"],
  ", and ",
  StyleBox["fp", "MR"],
  " in place of ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.17"}],

Cell[CellGroupData[{

Cell["Distribute[ f[{a, b}, {c, d}], List, f, gp, fp ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(gp[fp[a, c], fp[a, d], fp[b, c], fp[b, d]]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "Related to ",
  StyleBox["Distribute", "MR"],
  " is the function ",
  StyleBox["Thread", "MR"],
  ". What ",
  StyleBox["Thread", "MR"],
  " effectively does is to apply a function in parallel to all the elements \
of a list or other expression. "
}], "Text",
  CellTags->{"S2.2.10", "10.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Thread[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]]", "MR"],
              " "
            }]], Cell[TextData[{
              "thread ",
              StyleBox["f", "TI"],
              " over lists to give ",
              StyleBox["{", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Thread[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "thread ",
              StyleBox["f", "TI"],
              " over objects with head ",
              StyleBox["g", "TI"],
              " in ",
              StyleBox["args", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.10"],

Cell["Functions for threading expressions. ", "Caption",
  CellTags->"S2.2.10"],

Cell["Here is a function whose arguments are lists. ", "MathCaption",
  CellTags->{"S2.2.10", "10.19"}],

Cell[CellGroupData[{

Cell["f[{a1, a2}, {b1, b2}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(f[{a1, a2}, {b1, b2}]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Thread", "MR"],
  " applies the function \[OpenCurlyDoubleQuote]in parallel\
\[CloseCurlyDoubleQuote] to each element of the lists. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.20"}],

Cell[CellGroupData[{

Cell["Thread[%]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({f[a1, b1], f[a2, b2]}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell["Arguments that are not lists get repeated. ", "MathCaption",
  CellTags->{"S2.2.10", "10.21"}],

Cell[CellGroupData[{

Cell["Thread[ f[{a1, a2}, {b1, b2}, c, d] ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({f[a1, b1, c, d], f[a2, b2, c, d]}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "As mentioned in Section ",
  ButtonBox["1.8.1",
    ButtonData:>{"1.8.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", and discussed in more detail in Section ",
  ButtonBox["2.6.3",
    ButtonData:>{"2.6.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ", many built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions have the property of being \[OpenCurlyDoubleQuote]listable\
\[CloseCurlyDoubleQuote], so that they are automatically threaded over any \
lists that appear as arguments. "
}], "Text",
  CellTags->{"S2.2.10", "10.22"}],

Cell[TextData[{
  "Built\[Hyphen]in mathematical functions such as ",
  StyleBox["Log", "MR"],
  " are listable, so that they are automatically threaded over lists. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.23"}],

Cell[CellGroupData[{

Cell["Log[{a, b, c}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({Log[a], Log[b], Log[c]}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Log", "MR"],
  " is, however, not automatically threaded over equations. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.24"}],

Cell[CellGroupData[{

Cell["Log[x == y]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(Log[x \[Equal] y]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Thread", "MR"],
  " to get functions applied to both sides of an equation. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.25"}],

Cell[CellGroupData[{

Cell["Thread[%, Equal]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(Log[x] \[Equal] Log[y]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Outer[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["generalized outer product "]},
          {Cell[TextData[{
              StyleBox["Inner[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["generalized inner product "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.10"],

Cell["Generalized outer and inner products. ", "Caption",
  CellTags->"S2.2.10"],

Cell[TextData[{
  StyleBox["Outer[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["]", "MR"],
  " takes all possible combinations of elements from ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", and combines them with ",
  StyleBox["f", "TI"],
  ". ",
  StyleBox["Outer", "MR"],
  " can be viewed as a generalization of a Cartesian product for tensors, as \
discussed in Section ",
  ButtonBox["3.7.11",
    ButtonData:>{"3.7.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.2.10", "10.26"}],

Cell[TextData[{
  StyleBox["Outer", "MR"],
  " forms all possible combinations of elements, and applies ",
  StyleBox["f", "MR"],
  " to them. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.27"}],

Cell[CellGroupData[{

Cell["Outer[f, {a, b}, {1, 2, 3}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({{f[a, 1], f[a, 2], f[a, 3]}, {f[b, 1], f[b, 2], f[b, 3]}}\)], "Output",\

  CellLabel->"Out[18]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Outer", "MR"],
  " produces a lower\[Hyphen]triangular Boolean matrix. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.28"}],

Cell[CellGroupData[{

Cell["Outer[ Greater, {1, 2, 3}, {1, 2, 3} ]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \({{False, False, False}, {True, False, False}, {True, True, 
        False}}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Outer", "MR"],
  " on any sequence of expressions with the same head. "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.29"}],

Cell[CellGroupData[{

Cell["Outer[ g, f[a, b], f[c, d] ]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(f[f[g[a, c], g[a, d]], f[g[b, c], g[b, d]]]\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Outer", "MR"],
  ", like ",
  StyleBox["Distribute", "MR"],
  ", constructs all possible combinations of elements. On the other hand, ",
  StyleBox["Inner", "MR"],
  ", like ",
  StyleBox["Thread", "MR"],
  ", constructs only combinations of elements that have corresponding \
positions in the expressions it acts on. "
}], "Text",
  CellTags->{"S2.2.10", "10.30"}],

Cell[TextData[{
  "Here is a structure built by ",
  StyleBox["Inner", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.31"}],

Cell[CellGroupData[{

Cell["Inner[f, {a, b}, {c, d}, g]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(g[f[a, c], f[b, d]]\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.2.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Inner", "MR"],
  " is a generalization of ",
  StyleBox["Dot", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.2.10", "10.32"}],

Cell[CellGroupData[{

Cell["Inner[Times, {a, b}, {c, d}, Plus]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.2.10"],

Cell[BoxData[
    \(a\ c + b\ d\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.2.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.2.11 Sequences", "Subsection",
  CellTags->{"S2.2.11", "11.1"}],

Cell[TextData[{
  "The function ",
  StyleBox["Flatten", "MR"],
  " allows you to explicitly flatten out all sublists. "
}], "MathCaption",
  CellTags->{"S2.2.11", "11.2"}],

Cell[CellGroupData[{

Cell["Flatten[{a, {b, c}, {d, e}}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.2.11"],

Cell[BoxData[
    \({a, b, c, d, e}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.2.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FlattenAt", "MR"],
  " lets you specify at what positions you want sublists flattened. "
}], "MathCaption",
  CellTags->{"S2.2.11", "11.3"}],

Cell[CellGroupData[{

Cell["FlattenAt[{a, {b, c}, {d, e}}, 2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.2.11"],

Cell[BoxData[
    \({a, b, c, {d, e}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.2.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Sequence", "MR"],
  " objects automatically get spliced in, and do not require any explicit \
flattening. "
}], "MathCaption",
  CellTags->{"S2.2.11", "11.4"}],

Cell[CellGroupData[{

Cell["{a, Sequence[b, c], Sequence[d, e]}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.2.11"],

Cell[BoxData[
    \({a, b, c, d, e}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.2.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sequence[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
a sequence of arguments that will automatically be \
spliced into any function \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.2.11"],

Cell["Representing sequences of arguments in functions. ", "Caption",
  CellTags->"S2.2.11"],

Cell[TextData[{
  StyleBox["Sequence", "MR"],
  " works in any function. "
}], "MathCaption",
  CellTags->{"S2.2.11", "11.5"}],

Cell[CellGroupData[{

Cell["f[Sequence[a, b], c]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.2.11"],

Cell[BoxData[
    \(f[a, b, c]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.2.11"]
}, Open  ]],

Cell["This includes functions with special input forms. ", "MathCaption",
  CellTags->{"S2.2.11", "11.6"}],

Cell[CellGroupData[{

Cell["a == Sequence[b, c]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.2.11"],

Cell[BoxData[
    \(a \[Equal] b \[Equal] c\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.2.11"]
}, Open  ]],

Cell[TextData[{
  "Here is a common way that ",
  StyleBox["Sequence", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.2.11", "11.7"}],

Cell[CellGroupData[{

Cell["{a, b, f[x, y], g[w], f[z, y]} /. f->Sequence", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.2.11"],

Cell[BoxData[
    \({a, b, x, y, g[w], z, y}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.2.11"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{110, Automatic}, {58, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.2.0"->{
    Cell[1776, 53, 124, 4, 65, "Section",
      CellTags->{"S2.2.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 124, 4, 65, "Section",
      CellTags->{"S2.2.0", "0.1"}]},
  "S2.2.1"->{
    Cell[1925, 61, 88, 1, 70, "Subsection",
      CellTags->{"S2.2.1", "1.1"}],
    Cell[2016, 64, 363, 11, 70, "Text",
      CellTags->{"S2.2.1", "1.2"}],
    Cell[2382, 77, 127, 4, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.3"}],
    Cell[2534, 85, 89, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[2626, 89, 96, 3, 70, "Output",
      CellTags->"S2.2.1"],
    Cell[2737, 95, 114, 2, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.4"}],
    Cell[2876, 101, 81, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[2960, 105, 89, 3, 70, "Output",
      CellTags->"S2.2.1"],
    Cell[3064, 111, 132, 4, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.5"}],
    Cell[3199, 117, 93, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[3295, 121, 142, 5, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.6"}],
    Cell[3462, 130, 74, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[3539, 134, 100, 3, 70, "Output",
      CellTags->"S2.2.1"],
    Cell[3654, 140, 380, 8, 70, "Text",
      CellTags->{"S2.2.1", "1.7"}],
    Cell[4037, 150, 659, 18, 70, "Text",
      CellTags->{"S2.2.1", "1.8"}],
    Cell[4699, 170, 272, 7, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.9"}],
    Cell[4996, 181, 87, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[5086, 185, 84, 3, 70, "Output",
      CellTags->"S2.2.1"],
    Cell[5185, 191, 183, 5, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.10"}],
    Cell[5393, 200, 68, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[5464, 204, 87, 3, 70, "Output",
      CellTags->"S2.2.1"],
    Cell[5566, 210, 158, 5, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.11"}],
    Cell[5749, 219, 86, 2, 70, "Input",
      CellTags->"S2.2.1"],
    Cell[5838, 223, 186, 6, 70, "Output",
      CellTags->"S2.2.1"],
    Cell[6039, 232, 257, 6, 70, "Text",
      CellTags->{"S2.2.1", "1.12"}],
    Cell[6299, 240, 460, 9, 70, "Text",
      CellTags->{"S2.2.1", "1.13"}]},
  "1.1"->{
    Cell[1925, 61, 88, 1, 70, "Subsection",
      CellTags->{"S2.2.1", "1.1"}]},
  "1.2"->{
    Cell[2016, 64, 363, 11, 70, "Text",
      CellTags->{"S2.2.1", "1.2"}]},
  "1.3"->{
    Cell[2382, 77, 127, 4, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.3"}]},
  "1.4"->{
    Cell[2737, 95, 114, 2, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.4"}]},
  "1.5"->{
    Cell[3064, 111, 132, 4, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.5"}]},
  "1.6"->{
    Cell[3295, 121, 142, 5, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.6"}]},
  "1.7"->{
    Cell[3654, 140, 380, 8, 70, "Text",
      CellTags->{"S2.2.1", "1.7"}]},
  "1.8"->{
    Cell[4037, 150, 659, 18, 70, "Text",
      CellTags->{"S2.2.1", "1.8"}]},
  "1.9"->{
    Cell[4699, 170, 272, 7, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.9"}]},
  "1.10"->{
    Cell[5185, 191, 183, 5, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.10"}]},
  "1.11"->{
    Cell[5566, 210, 158, 5, 70, "MathCaption",
      CellTags->{"S2.2.1", "1.11"}]},
  "1.12"->{
    Cell[6039, 232, 257, 6, 70, "Text",
      CellTags->{"S2.2.1", "1.12"}]},
  "1.13"->{
    Cell[6299, 240, 460, 9, 70, "Text",
      CellTags->{"S2.2.1", "1.13"}]},
  "S2.2.2"->{
    Cell[6796, 254, 88, 1, 70, "Subsection",
      CellTags->{"S2.2.2", "2.1"}],
    Cell[6887, 257, 267, 8, 70, "Text",
      CellTags->{"S2.2.2", "2.2"}],
    Cell[7157, 267, 1976, 64, 70, "DefinitionBox",
      CellTags->"S2.2.2"],
    Cell[9136, 333, 88, 1, 70, "Caption",
      CellTags->"S2.2.2"],
    Cell[9227, 336, 452, 18, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.3"}],
    Cell[9704, 358, 77, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[9784, 362, 94, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[9893, 368, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.4"}],
    Cell[10018, 373, 81, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[10102, 377, 126, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[10243, 383, 81, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.5"}],
    Cell[10327, 386, 86, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[10416, 390, 139, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.6"}],
    Cell[10580, 399, 81, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[10664, 403, 115, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[10794, 409, 371, 12, 70, "Text",
      CellTags->{"S2.2.2", "2.7"}],
    Cell[11168, 423, 1641, 50, 70, "DefinitionBox",
      CellTags->"S2.2.2"],
    Cell[12812, 475, 96, 1, 70, "Caption",
      CellTags->"S2.2.2"],
    Cell[12911, 478, 213, 6, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.8"}],
    Cell[13127, 486, 99, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[13229, 490, 281, 9, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.9"}],
    Cell[13535, 503, 89, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[13627, 507, 168, 4, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[13810, 514, 242, 7, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.10"}],
    Cell[14077, 525, 88, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[14168, 529, 100, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[14283, 535, 88, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.11"}],
    Cell[14396, 540, 92, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[14491, 544, 189, 4, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[14695, 551, 4114, 128, 70, "DefinitionBox",
      CellTags->"S2.2.2"],
    Cell[18812, 681, 91, 1, 70, "Caption",
      CellTags->"S2.2.2"],
    Cell[18906, 684, 103, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.12"}],
    Cell[19012, 687, 82, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[19097, 691, 177, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.13"}],
    Cell[19299, 700, 102, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[19404, 704, 129, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[19548, 710, 260, 8, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.14"}],
    Cell[19833, 722, 104, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[19940, 726, 190, 4, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[20145, 733, 145, 4, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.15"}],
    Cell[20315, 741, 109, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[20427, 745, 103, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[20545, 751, 315, 10, 70, "Text",
      CellTags->{"S2.2.2", "2.16"}],
    Cell[20863, 763, 381, 7, 70, "Text",
      CellTags->{"S2.2.2", "2.17"}],
    Cell[21247, 772, 2945, 97, 70, "DefinitionBox",
      CellTags->"S2.2.2"],
    Cell[24195, 871, 94, 1, 70, "Caption",
      CellTags->"S2.2.2"],
    Cell[24292, 874, 141, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.18"}],
    Cell[24458, 883, 90, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[24551, 887, 130, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[24696, 893, 183, 6, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.19"}],
    Cell[24904, 903, 86, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[24993, 907, 101, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[25109, 913, 93, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.20"}],
    Cell[25227, 918, 93, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[25323, 922, 106, 3, 70, "Output",
      CellTags->"S2.2.2"],
    Cell[25444, 928, 454, 14, 70, "Text",
      CellTags->{"S2.2.2", "2.21"}],
    Cell[25901, 944, 134, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.22"}],
    Cell[26038, 951, 94, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[26135, 955, 158, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.23"}],
    Cell[26296, 962, 114, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[26413, 966, 101, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.24"}],
    Cell[26539, 971, 95, 2, 70, "Input",
      CellTags->"S2.2.2"],
    Cell[26637, 975, 88, 3, 70, "Output",
      CellTags->"S2.2.2"]},
  "2.1"->{
    Cell[6796, 254, 88, 1, 70, "Subsection",
      CellTags->{"S2.2.2", "2.1"}]},
  "2.2"->{
    Cell[6887, 257, 267, 8, 70, "Text",
      CellTags->{"S2.2.2", "2.2"}]},
  "2.3"->{
    Cell[9227, 336, 452, 18, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.3"}]},
  "2.4"->{
    Cell[9893, 368, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.4"}]},
  "2.5"->{
    Cell[10243, 383, 81, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.5"}]},
  "2.6"->{
    Cell[10416, 390, 139, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.6"}]},
  "2.7"->{
    Cell[10794, 409, 371, 12, 70, "Text",
      CellTags->{"S2.2.2", "2.7"}]},
  "2.8"->{
    Cell[12911, 478, 213, 6, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.8"}]},
  "2.9"->{
    Cell[13229, 490, 281, 9, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.9"}]},
  "2.10"->{
    Cell[13810, 514, 242, 7, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.10"}]},
  "2.11"->{
    Cell[14283, 535, 88, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.11"}]},
  "2.12"->{
    Cell[18906, 684, 103, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.12"}]},
  "2.13"->{
    Cell[19097, 691, 177, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.13"}]},
  "2.14"->{
    Cell[19548, 710, 260, 8, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.14"}]},
  "2.15"->{
    Cell[20145, 733, 145, 4, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.15"}]},
  "2.16"->{
    Cell[20545, 751, 315, 10, 70, "Text",
      CellTags->{"S2.2.2", "2.16"}]},
  "2.17"->{
    Cell[20863, 763, 381, 7, 70, "Text",
      CellTags->{"S2.2.2", "2.17"}]},
  "2.18"->{
    Cell[24292, 874, 141, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.18"}]},
  "2.19"->{
    Cell[24696, 893, 183, 6, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.19"}]},
  "2.20"->{
    Cell[25109, 913, 93, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.20"}]},
  "2.21"->{
    Cell[25444, 928, 454, 14, 70, "Text",
      CellTags->{"S2.2.2", "2.21"}]},
  "2.22"->{
    Cell[25901, 944, 134, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.22"}]},
  "2.23"->{
    Cell[26135, 955, 158, 5, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.23"}]},
  "2.24"->{
    Cell[26413, 966, 101, 1, 70, "MathCaption",
      CellTags->{"S2.2.2", "2.24"}]},
  "S2.2.3"->{
    Cell[26774, 984, 108, 1, 70, "Subsection",
      CellTags->{"S2.2.3", "3.1"}],
    Cell[26885, 987, 454, 15, 70, "Text",
      CellTags->{"S2.2.3", "3.2"}],
    Cell[27342, 1004, 165, 5, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.3"}],
    Cell[27532, 1013, 83, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[27618, 1017, 91, 3, 70, "Output",
      CellTags->"S2.2.3"],
    Cell[27724, 1023, 229, 9, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.4"}],
    Cell[27978, 1036, 86, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[28067, 1040, 90, 3, 70, "Output",
      CellTags->"S2.2.3"],
    Cell[28172, 1046, 167, 5, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.5"}],
    Cell[28342, 1053, 111, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[28456, 1057, 2942, 95, 70, "DefinitionBox",
      CellTags->"S2.2.3"],
    Cell[31401, 1154, 92, 1, 70, "Caption",
      CellTags->"S2.2.3"],
    Cell[31496, 1157, 285, 10, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.6"}],
    Cell[31806, 1171, 86, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[31895, 1175, 90, 3, 70, "Output",
      CellTags->"S2.2.3"],
    Cell[32000, 1181, 72, 1, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.7"}],
    Cell[32097, 1186, 90, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[32190, 1190, 103, 3, 70, "Output",
      CellTags->"S2.2.3"],
    Cell[32308, 1196, 224, 8, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.8"}],
    Cell[32557, 1208, 75, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[32635, 1212, 104, 3, 70, "Output",
      CellTags->"S2.2.3"],
    Cell[32754, 1218, 172, 7, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.9"}],
    Cell[32951, 1229, 80, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[33034, 1233, 105, 3, 70, "Output",
      CellTags->"S2.2.3"],
    Cell[33154, 1239, 137, 5, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.10"}],
    Cell[33316, 1248, 83, 2, 70, "Input",
      CellTags->"S2.2.3"],
    Cell[33402, 1252, 106, 3, 70, "Output",
      CellTags->"S2.2.3"]},
  "3.1"->{
    Cell[26774, 984, 108, 1, 70, "Subsection",
      CellTags->{"S2.2.3", "3.1"}]},
  "3.2"->{
    Cell[26885, 987, 454, 15, 70, "Text",
      CellTags->{"S2.2.3", "3.2"}]},
  "3.3"->{
    Cell[27342, 1004, 165, 5, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.3"}]},
  "3.4"->{
    Cell[27724, 1023, 229, 9, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.4"}]},
  "3.5"->{
    Cell[28172, 1046, 167, 5, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.5"}]},
  "3.6"->{
    Cell[31496, 1157, 285, 10, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.6"}]},
  "3.7"->{
    Cell[32000, 1181, 72, 1, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.7"}]},
  "3.8"->{
    Cell[32308, 1196, 224, 8, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.8"}]},
  "3.9"->{
    Cell[32754, 1218, 172, 7, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.9"}]},
  "3.10"->{
    Cell[33154, 1239, 137, 5, 70, "MathCaption",
      CellTags->{"S2.2.3", "3.10"}]},
  "S2.2.4"->{
    Cell[33557, 1261, 101, 1, 70, "Subsection",
      CellTags->{"S2.2.4", "4.1"}],
    Cell[33661, 1264, 284, 8, 70, "Text",
      CellTags->{"S2.2.4", "4.2"}],
    Cell[33948, 1274, 151, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.3"}],
    Cell[34124, 1283, 81, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[34208, 1287, 99, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[34322, 1293, 136, 4, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.4"}],
    Cell[34461, 1299, 93, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[34557, 1303, 184, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.5"}],
    Cell[34766, 1314, 112, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[34881, 1318, 105, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[35001, 1324, 1292, 42, 70, "DefinitionBox",
      CellTags->"S2.2.4"],
    Cell[36296, 1368, 88, 1, 70, "Caption",
      CellTags->"S2.2.4"],
    Cell[36387, 1371, 475, 17, 70, "Text",
      CellTags->{"S2.2.4", "4.6"}],
    Cell[36865, 1390, 141, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.7"}],
    Cell[37031, 1399, 81, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[37115, 1403, 99, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[37229, 1409, 185, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.8"}],
    Cell[37439, 1420, 86, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[37528, 1424, 98, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[37641, 1430, 567, 26, 70, "Text",
      CellTags->{"S2.2.4", "4.9"}],
    Cell[38211, 1458, 205, 8, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.10"}],
    Cell[38441, 1470, 84, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[38528, 1474, 97, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[38640, 1480, 225, 8, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.11"}],
    Cell[38890, 1492, 73, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[38966, 1496, 103, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[39084, 1502, 329, 12, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.12"}],
    Cell[39438, 1518, 76, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[39517, 1522, 118, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[39650, 1528, 345, 10, 70, "Text",
      CellTags->{"S2.2.4", "4.13"}],
    Cell[39998, 1540, 177, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.14"}],
    Cell[40200, 1551, 78, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[40281, 1555, 109, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[40405, 1561, 221, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.15"}],
    Cell[40651, 1572, 87, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[40741, 1576, 115, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[40871, 1582, 2122, 68, 70, "DefinitionBox",
      CellTags->"S2.2.4"],
    Cell[42996, 1652, 101, 1, 70, "Caption",
      CellTags->"S2.2.4"],
    Cell[43100, 1655, 509, 14, 70, "Text",
      CellTags->{"S2.2.4", "4.16"}],
    Cell[43612, 1671, 170, 6, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.17"}],
    Cell[43807, 1681, 92, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[43902, 1685, 104, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[44021, 1691, 254, 13, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.18"}],
    Cell[44300, 1708, 95, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[44398, 1712, 110, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[44523, 1718, 187, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.19"}],
    Cell[44735, 1729, 80, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[44818, 1733, 98, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[44931, 1739, 205, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.20"}],
    Cell[45161, 1750, 80, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[45244, 1754, 110, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[45369, 1760, 171, 4, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.21"}],
    Cell[45565, 1768, 99, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[45667, 1772, 100, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[45782, 1778, 1308, 40, 70, "DefinitionBox",
      CellTags->"S2.2.4"],
    Cell[47093, 1820, 97, 1, 70, "Caption",
      CellTags->"S2.2.4"],
    Cell[47193, 1823, 78, 1, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.22"}],
    Cell[47296, 1828, 86, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[47385, 1832, 103, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[47503, 1838, 127, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.23"}],
    Cell[47655, 1847, 78, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[47736, 1851, 288, 8, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[48039, 1862, 218, 6, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.24"}],
    Cell[48282, 1872, 97, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[48382, 1876, 109, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[48506, 1882, 1396, 43, 70, "DefinitionBox",
      CellTags->"S2.2.4"],
    Cell[49905, 1927, 89, 1, 70, "Caption",
      CellTags->"S2.2.4"],
    Cell[49997, 1930, 230, 8, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.25"}],
    Cell[50252, 1942, 89, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[50344, 1946, 115, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[50474, 1952, 142, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.26"}],
    Cell[50641, 1961, 99, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[50743, 1965, 165, 4, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[50923, 1972, 370, 9, 70, "Text",
      CellTags->{"S2.2.4", "4.27"}],
    Cell[51296, 1983, 2817, 83, 70, "DefinitionBox",
      CellTags->"S2.2.4"],
    Cell[54116, 2068, 93, 1, 70, "Caption",
      CellTags->"S2.2.4"],
    Cell[54212, 2071, 155, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.28"}],
    Cell[54392, 2080, 104, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[54499, 2084, 112, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[54626, 2090, 184, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.29"}],
    Cell[54835, 2099, 109, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[54947, 2103, 112, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[55074, 2109, 484, 9, 70, "Text",
      CellTags->{"S2.2.4", "4.30"}],
    Cell[55561, 2120, 1297, 41, 70, "DefinitionBox",
      CellTags->"S2.2.4"],
    Cell[56861, 2163, 87, 1, 70, "Caption",
      CellTags->"S2.2.4"],
    Cell[56951, 2166, 204, 6, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.31"}],
    Cell[57180, 2176, 82, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[57265, 2180, 100, 3, 70, "Output",
      CellTags->"S2.2.4"],
    Cell[57380, 2186, 202, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.32"}],
    Cell[57607, 2195, 87, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[57697, 2199, 56, 2, 70, "Print",
      CellTags->"S2.2.4"],
    Cell[57756, 2203, 56, 2, 70, "Print",
      CellTags->"S2.2.4"],
    Cell[57815, 2207, 56, 2, 70, "Print",
      CellTags->"S2.2.4"],
    Cell[57886, 2212, 196, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.33"}],
    Cell[58107, 2221, 95, 2, 70, "Input",
      CellTags->"S2.2.4"],
    Cell[58205, 2225, 56, 2, 70, "Print",
      CellTags->"S2.2.4"],
    Cell[58264, 2229, 56, 2, 70, "Print",
      CellTags->"S2.2.4"],
    Cell[58323, 2233, 56, 2, 70, "Print",
      CellTags->"S2.2.4"],
    Cell[58382, 2237, 59, 2, 70, "Print",
      CellTags->"S2.2.4"]},
  "4.1"->{
    Cell[33557, 1261, 101, 1, 70, "Subsection",
      CellTags->{"S2.2.4", "4.1"}]},
  "4.2"->{
    Cell[33661, 1264, 284, 8, 70, "Text",
      CellTags->{"S2.2.4", "4.2"}]},
  "4.3"->{
    Cell[33948, 1274, 151, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.3"}]},
  "4.4"->{
    Cell[34322, 1293, 136, 4, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.4"}]},
  "4.5"->{
    Cell[34557, 1303, 184, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.5"}]},
  "4.6"->{
    Cell[36387, 1371, 475, 17, 70, "Text",
      CellTags->{"S2.2.4", "4.6"}]},
  "4.7"->{
    Cell[36865, 1390, 141, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.7"}]},
  "4.8"->{
    Cell[37229, 1409, 185, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.8"}]},
  "4.9"->{
    Cell[37641, 1430, 567, 26, 70, "Text",
      CellTags->{"S2.2.4", "4.9"}]},
  "4.10"->{
    Cell[38211, 1458, 205, 8, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.10"}]},
  "4.11"->{
    Cell[38640, 1480, 225, 8, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.11"}]},
  "4.12"->{
    Cell[39084, 1502, 329, 12, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.12"}]},
  "4.13"->{
    Cell[39650, 1528, 345, 10, 70, "Text",
      CellTags->{"S2.2.4", "4.13"}]},
  "4.14"->{
    Cell[39998, 1540, 177, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.14"}]},
  "4.15"->{
    Cell[40405, 1561, 221, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.15"}]},
  "4.16"->{
    Cell[43100, 1655, 509, 14, 70, "Text",
      CellTags->{"S2.2.4", "4.16"}]},
  "4.17"->{
    Cell[43612, 1671, 170, 6, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.17"}]},
  "4.18"->{
    Cell[44021, 1691, 254, 13, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.18"}]},
  "4.19"->{
    Cell[44523, 1718, 187, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.19"}]},
  "4.20"->{
    Cell[44931, 1739, 205, 7, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.20"}]},
  "4.21"->{
    Cell[45369, 1760, 171, 4, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.21"}]},
  "4.22"->{
    Cell[47193, 1823, 78, 1, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.22"}]},
  "4.23"->{
    Cell[47503, 1838, 127, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.23"}]},
  "4.24"->{
    Cell[48039, 1862, 218, 6, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.24"}]},
  "4.25"->{
    Cell[49997, 1930, 230, 8, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.25"}]},
  "4.26"->{
    Cell[50474, 1952, 142, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.26"}]},
  "4.27"->{
    Cell[50923, 1972, 370, 9, 70, "Text",
      CellTags->{"S2.2.4", "4.27"}]},
  "4.28"->{
    Cell[54212, 2071, 155, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.28"}]},
  "4.29"->{
    Cell[54626, 2090, 184, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.29"}]},
  "4.30"->{
    Cell[55074, 2109, 484, 9, 70, "Text",
      CellTags->{"S2.2.4", "4.30"}]},
  "4.31"->{
    Cell[56951, 2166, 204, 6, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.31"}]},
  "4.32"->{
    Cell[57380, 2186, 202, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.32"}]},
  "4.33"->{
    Cell[57886, 2212, 196, 5, 70, "MathCaption",
      CellTags->{"S2.2.4", "4.33"}]},
  "S2.2.5"->{
    Cell[58490, 2245, 73, 1, 70, "Subsection",
      CellTags->{"S2.2.5", "5.1"}],
    Cell[58566, 2248, 1972, 59, 70, "DefinitionBox",
      CellTags->"S2.2.5"],
    Cell[60541, 2309, 57, 1, 70, "Caption",
      CellTags->"S2.2.5"],
    Cell[60601, 2312, 504, 11, 70, "Text",
      CellTags->{"S2.2.5", "5.2"}],
    Cell[61108, 2325, 125, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.3"}],
    Cell[61236, 2332, 84, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[61323, 2336, 177, 7, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.4"}],
    Cell[61525, 2347, 81, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[61609, 2351, 120, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[61744, 2357, 116, 2, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.5"}],
    Cell[61885, 2363, 95, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[61983, 2367, 120, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[62118, 2373, 546, 16, 70, "Text",
      CellTags->{"S2.2.5", "5.6"}],
    Cell[62667, 2391, 132, 4, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.7"}],
    Cell[62824, 2399, 80, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[62907, 2403, 98, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[63020, 2409, 196, 7, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.8"}],
    Cell[63241, 2420, 68, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[63312, 2424, 85, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[63412, 2430, 141, 4, 70, "Text",
      CellTags->{"S2.2.5", "5.9"}],
    Cell[63556, 2436, 135, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.10"}],
    Cell[63716, 2445, 98, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[63817, 2449, 99, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[63931, 2455, 111, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.11"}],
    Cell[64067, 2464, 98, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[64168, 2468, 115, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[64298, 2474, 233, 8, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.12"}],
    Cell[64556, 2486, 98, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[64657, 2490, 92, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[64764, 2496, 564, 17, 70, "Text",
      CellTags->{"S2.2.5", "5.13"}],
    Cell[65331, 2515, 420, 10, 70, "Text",
      CellTags->{"S2.2.5", "5.14"}],
    Cell[65754, 2527, 1261, 36, 70, "DefinitionBox",
      CellTags->"S2.2.5"],
    Cell[67018, 2565, 73, 1, 70, "Caption",
      CellTags->"S2.2.5"],
    Cell[67094, 2568, 830, 23, 70, "Text",
      CellTags->{"S2.2.5", "5.15"}],
    Cell[67927, 2593, 190, 6, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.16"}],
    Cell[68142, 2603, 87, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[68232, 2607, 99, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[68346, 2613, 219, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.17"}],
    Cell[68590, 2622, 116, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[68709, 2626, 106, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[68830, 2632, 318, 10, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.18"}],
    Cell[69151, 2644, 118, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[69272, 2648, 321, 7, 70, "Text",
      CellTags->{"S2.2.5", "5.19"}],
    Cell[69596, 2657, 839, 28, 70, "Text",
      CellTags->{"S2.2.5", "5.20"}],
    Cell[70438, 2687, 452, 14, 70, "Text",
      CellTags->{"S2.2.5", "5.21"}],
    Cell[70893, 2703, 122, 4, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.22"}],
    Cell[71040, 2711, 82, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[71125, 2715, 95, 3, 70, "Output",
      CellTags->"S2.2.5"],
    Cell[71235, 2721, 144, 4, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.23"}],
    Cell[71404, 2729, 111, 2, 70, "Input",
      CellTags->"S2.2.5"],
    Cell[71518, 2733, 105, 3, 70, "Output",
      CellTags->"S2.2.5"]},
  "5.1"->{
    Cell[58490, 2245, 73, 1, 70, "Subsection",
      CellTags->{"S2.2.5", "5.1"}]},
  "5.2"->{
    Cell[60601, 2312, 504, 11, 70, "Text",
      CellTags->{"S2.2.5", "5.2"}]},
  "5.3"->{
    Cell[61108, 2325, 125, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.3"}]},
  "5.4"->{
    Cell[61323, 2336, 177, 7, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.4"}]},
  "5.5"->{
    Cell[61744, 2357, 116, 2, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.5"}]},
  "5.6"->{
    Cell[62118, 2373, 546, 16, 70, "Text",
      CellTags->{"S2.2.5", "5.6"}]},
  "5.7"->{
    Cell[62667, 2391, 132, 4, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.7"}]},
  "5.8"->{
    Cell[63020, 2409, 196, 7, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.8"}]},
  "5.9"->{
    Cell[63412, 2430, 141, 4, 70, "Text",
      CellTags->{"S2.2.5", "5.9"}]},
  "5.10"->{
    Cell[63556, 2436, 135, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.10"}]},
  "5.11"->{
    Cell[63931, 2455, 111, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.11"}]},
  "5.12"->{
    Cell[64298, 2474, 233, 8, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.12"}]},
  "5.13"->{
    Cell[64764, 2496, 564, 17, 70, "Text",
      CellTags->{"S2.2.5", "5.13"}]},
  "5.14"->{
    Cell[65331, 2515, 420, 10, 70, "Text",
      CellTags->{"S2.2.5", "5.14"}]},
  "5.15"->{
    Cell[67094, 2568, 830, 23, 70, "Text",
      CellTags->{"S2.2.5", "5.15"}]},
  "5.16"->{
    Cell[67927, 2593, 190, 6, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.16"}]},
  "5.17"->{
    Cell[68346, 2613, 219, 5, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.17"}]},
  "5.18"->{
    Cell[68830, 2632, 318, 10, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.18"}]},
  "5.19"->{
    Cell[69272, 2648, 321, 7, 70, "Text",
      CellTags->{"S2.2.5", "5.19"}]},
  "5.20"->{
    Cell[69596, 2657, 839, 28, 70, "Text",
      CellTags->{"S2.2.5", "5.20"}]},
  "5.21"->{
    Cell[70438, 2687, 452, 14, 70, "Text",
      CellTags->{"S2.2.5", "5.21"}]},
  "5.22"->{
    Cell[70893, 2703, 122, 4, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.22"}]},
  "5.23"->{
    Cell[71235, 2721, 144, 4, 70, "MathCaption",
      CellTags->{"S2.2.5", "5.23"}]},
  "S2.2.6"->{
    Cell[71672, 2742, 88, 1, 70, "Subsection",
      CellTags->{"S2.2.6", "6.1"}],
    Cell[71763, 2745, 7050, 217, 70, "DefinitionBox",
      CellTags->"S2.2.6"],
    Cell[78816, 2964, 70, 1, 70, "Caption",
      CellTags->"S2.2.6"],
    Cell[78889, 2967, 198, 7, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.2"}],
    Cell[79112, 2978, 75, 2, 70, "Input",
      CellTags->"S2.2.6"],
    Cell[79190, 2982, 111, 3, 70, "Output",
      CellTags->"S2.2.6"],
    Cell[79316, 2988, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.3"}],
    Cell[79441, 2993, 83, 2, 70, "Input",
      CellTags->"S2.2.6"],
    Cell[79527, 2997, 111, 3, 70, "Output",
      CellTags->"S2.2.6"],
    Cell[79653, 3003, 333, 12, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.4"}],
    Cell[80011, 3019, 84, 2, 70, "Input",
      CellTags->"S2.2.6"],
    Cell[80098, 3023, 99, 3, 70, "Output",
      CellTags->"S2.2.6"],
    Cell[80212, 3029, 324, 13, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.5"}],
    Cell[80561, 3046, 80, 2, 70, "Input",
      CellTags->"S2.2.6"],
    Cell[80644, 3050, 141, 4, 70, "Output",
      CellTags->"S2.2.6"],
    Cell[80800, 3057, 236, 6, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.6"}],
    Cell[81061, 3067, 91, 2, 70, "Input",
      CellTags->"S2.2.6"],
    Cell[81155, 3071, 120, 3, 70, "Output",
      CellTags->"S2.2.6"],
    Cell[81290, 3077, 408, 13, 70, "Text",
      CellTags->{"S2.2.6", "6.7"}],
    Cell[81701, 3092, 458, 16, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.8"}],
    Cell[82184, 3112, 92, 2, 70, "Input",
      CellTags->"S2.2.6"],
    Cell[82279, 3116, 240, 6, 70, "Output",
      CellTags->"S2.2.6"]},
  "6.1"->{
    Cell[71672, 2742, 88, 1, 70, "Subsection",
      CellTags->{"S2.2.6", "6.1"}]},
  "6.2"->{
    Cell[78889, 2967, 198, 7, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.2"}]},
  "6.3"->{
    Cell[79316, 2988, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.3"}]},
  "6.4"->{
    Cell[79653, 3003, 333, 12, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.4"}]},
  "6.5"->{
    Cell[80212, 3029, 324, 13, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.5"}]},
  "6.6"->{
    Cell[80800, 3057, 236, 6, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.6"}]},
  "6.7"->{
    Cell[81290, 3077, 408, 13, 70, "Text",
      CellTags->{"S2.2.6", "6.7"}]},
  "6.8"->{
    Cell[81701, 3092, 458, 16, 70, "MathCaption",
      CellTags->{"S2.2.6", "6.8"}]},
  "S2.2.7"->{
    Cell[82568, 3128, 104, 1, 70, "Subsection",
      CellTags->{"S2.2.7", "7.1"}],
    Cell[82675, 3131, 430, 13, 70, "Text",
      CellTags->{"S2.2.7", "7.2"}],
    Cell[83108, 3146, 526, 21, 70, "Text",
      CellTags->{"S2.2.7", "7.3"}],
    Cell[83637, 3169, 219, 6, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.4"}],
    Cell[83881, 3179, 102, 2, 70, "Input",
      CellTags->"S2.2.7"],
    Cell[83986, 3183, 93, 3, 70, "Output",
      CellTags->"S2.2.7"],
    Cell[84094, 3189, 177, 5, 70, "Text",
      CellTags->{"S2.2.7", "7.5"}],
    Cell[84274, 3196, 202, 9, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.6"}],
    Cell[84501, 3209, 89, 2, 70, "Input",
      CellTags->"S2.2.7"],
    Cell[84593, 3213, 129, 3, 70, "Output",
      CellTags->"S2.2.7"],
    Cell[84737, 3219, 219, 7, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.7"}],
    Cell[84981, 3230, 87, 2, 70, "Input",
      CellTags->"S2.2.7"],
    Cell[85071, 3234, 102, 3, 70, "Output",
      CellTags->"S2.2.7"],
    Cell[85188, 3240, 1425, 45, 70, "DefinitionBox",
      CellTags->"S2.2.7"],
    Cell[86616, 3287, 74, 1, 70, "Caption",
      CellTags->"S2.2.7"],
    Cell[86693, 3290, 313, 10, 70, "Text",
      CellTags->{"S2.2.7", "7.8"}],
    Cell[87009, 3302, 136, 4, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.9"}],
    Cell[87170, 3310, 103, 2, 70, "Input",
      CellTags->"S2.2.7"],
    Cell[87276, 3314, 85, 3, 70, "Output",
      CellTags->"S2.2.7"]},
  "7.1"->{
    Cell[82568, 3128, 104, 1, 70, "Subsection",
      CellTags->{"S2.2.7", "7.1"}]},
  "7.2"->{
    Cell[82675, 3131, 430, 13, 70, "Text",
      CellTags->{"S2.2.7", "7.2"}]},
  "7.3"->{
    Cell[83108, 3146, 526, 21, 70, "Text",
      CellTags->{"S2.2.7", "7.3"}]},
  "7.4"->{
    Cell[83637, 3169, 219, 6, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.4"}]},
  "7.5"->{
    Cell[84094, 3189, 177, 5, 70, "Text",
      CellTags->{"S2.2.7", "7.5"}]},
  "7.6"->{
    Cell[84274, 3196, 202, 9, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.6"}]},
  "7.7"->{
    Cell[84737, 3219, 219, 7, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.7"}]},
  "7.8"->{
    Cell[86693, 3290, 313, 10, 70, "Text",
      CellTags->{"S2.2.7", "7.8"}]},
  "7.9"->{
    Cell[87009, 3302, 136, 4, 70, "MathCaption",
      CellTags->{"S2.2.7", "7.9"}]},
  "S2.2.8"->{
    Cell[87410, 3323, 102, 1, 70, "Subsection",
      CellTags->{"S2.2.8", "8.1"}],
    Cell[87515, 3326, 390, 13, 70, "Text",
      CellTags->{"S2.2.8", "8.2"}],
    Cell[87908, 3341, 243, 6, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.3"}],
    Cell[88176, 3351, 74, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[88253, 3355, 95, 3, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[88363, 3361, 148, 4, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.4"}],
    Cell[88536, 3369, 74, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[88613, 3373, 95, 3, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[88723, 3379, 536, 16, 70, "Text",
      CellTags->{"S2.2.8", "8.5"}],
    Cell[89262, 3397, 217, 7, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.6"}],
    Cell[89504, 3408, 88, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[89595, 3412, 95, 3, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[89705, 3418, 382, 8, 70, "Text",
      CellTags->{"S2.2.8", "8.7"}],
    Cell[90090, 3428, 1896, 55, 70, "DefinitionBox",
      CellTags->"S2.2.8"],
    Cell[91989, 3485, 97, 1, 70, "Caption",
      CellTags->"S2.2.8"],
    Cell[92089, 3488, 228, 8, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.8"}],
    Cell[92342, 3500, 119, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[92464, 3504, 271, 8, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[92750, 3515, 140, 5, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.9"}],
    Cell[92915, 3524, 77, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[92995, 3528, 166, 5, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[93176, 3536, 245, 8, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.10"}],
    Cell[93446, 3548, 71, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[93520, 3552, 99, 3, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[93634, 3558, 257, 8, 70, "Text",
      CellTags->{"S2.2.8", "8.11"}],
    Cell[93894, 3568, 823, 27, 70, "Text",
      CellTags->{"S2.2.8", "8.12"}],
    Cell[94720, 3597, 343, 8, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.13"}],
    Cell[95088, 3609, 81, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[95172, 3613, 260, 8, 70, "Output",
      CellTags->"S2.2.8"],
    Cell[95447, 3624, 362, 12, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.14"}],
    Cell[95834, 3640, 77, 2, 70, "Input",
      CellTags->"S2.2.8"],
    Cell[95914, 3644, 86, 3, 70, "Output",
      CellTags->"S2.2.8"]},
  "8.1"->{
    Cell[87410, 3323, 102, 1, 70, "Subsection",
      CellTags->{"S2.2.8", "8.1"}]},
  "8.2"->{
    Cell[87515, 3326, 390, 13, 70, "Text",
      CellTags->{"S2.2.8", "8.2"}]},
  "8.3"->{
    Cell[87908, 3341, 243, 6, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.3"}]},
  "8.4"->{
    Cell[88363, 3361, 148, 4, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.4"}]},
  "8.5"->{
    Cell[88723, 3379, 536, 16, 70, "Text",
      CellTags->{"S2.2.8", "8.5"}]},
  "8.6"->{
    Cell[89262, 3397, 217, 7, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.6"}]},
  "8.7"->{
    Cell[89705, 3418, 382, 8, 70, "Text",
      CellTags->{"S2.2.8", "8.7"}]},
  "8.8"->{
    Cell[92089, 3488, 228, 8, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.8"}]},
  "8.9"->{
    Cell[92750, 3515, 140, 5, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.9"}]},
  "8.10"->{
    Cell[93176, 3536, 245, 8, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.10"}]},
  "8.11"->{
    Cell[93634, 3558, 257, 8, 70, "Text",
      CellTags->{"S2.2.8", "8.11"}]},
  "8.12"->{
    Cell[93894, 3568, 823, 27, 70, "Text",
      CellTags->{"S2.2.8", "8.12"}]},
  "8.13"->{
    Cell[94720, 3597, 343, 8, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.13"}]},
  "8.14"->{
    Cell[95447, 3624, 362, 12, 70, "MathCaption",
      CellTags->{"S2.2.8", "8.14"}]},
  "S2.2.9"->{
    Cell[96049, 3653, 97, 1, 70, "Subsection",
      CellTags->{"S2.2.9", "9.1"}],
    Cell[96149, 3656, 719, 29, 70, "Text",
      CellTags->{"S2.2.9", "9.2"}],
    Cell[96871, 3687, 1262, 41, 70, "DefinitionBox",
      CellTags->"S2.2.9"],
    Cell[98136, 3730, 69, 1, 70, "Caption",
      CellTags->"S2.2.9"],
    Cell[98208, 3733, 215, 9, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.3"}],
    Cell[98448, 3746, 84, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[98535, 3750, 101, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[98651, 3756, 115, 2, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.4"}],
    Cell[98791, 3762, 98, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[98892, 3766, 510, 16, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[99417, 3785, 141, 4, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.5"}],
    Cell[99583, 3793, 68, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[99654, 3797, 574, 19, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[100243, 3819, 375, 14, 70, "Text",
      CellTags->{"S2.2.9", "9.6"}],
    Cell[100621, 3835, 194, 7, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.7"}],
    Cell[100840, 3846, 74, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[100917, 3850, 95, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[101027, 3856, 169, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.8"}],
    Cell[101221, 3865, 80, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[101304, 3869, 92, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[101411, 3875, 349, 11, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.9"}],
    Cell[101785, 3890, 85, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[101873, 3894, 117, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[102005, 3900, 190, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.10"}],
    Cell[102220, 3909, 71, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[102294, 3913, 129, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[102438, 3919, 142, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.11"}],
    Cell[102605, 3928, 80, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[102688, 3932, 92, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[102795, 3938, 3942, 121, 70, "DefinitionBox",
      CellTags->"S2.2.9"],
    Cell[106740, 4061, 80, 1, 70, "Caption",
      CellTags->"S2.2.9"],
    Cell[106823, 4064, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.12"}],
    Cell[106948, 4069, 87, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[107038, 4073, 114, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[107167, 4079, 174, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.13"}],
    Cell[107366, 4088, 74, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[107443, 4092, 115, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[107573, 4098, 216, 9, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.14"}],
    Cell[107814, 4111, 95, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[107912, 4115, 107, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[108034, 4121, 164, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.15"}],
    Cell[108223, 4130, 74, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[108300, 4134, 105, 3, 70, "Output",
      CellTags->"S2.2.9"],
    Cell[108420, 4140, 182, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.16"}],
    Cell[108627, 4149, 78, 2, 70, "Input",
      CellTags->"S2.2.9"],
    Cell[108708, 4153, 116, 3, 70, "Output",
      CellTags->"S2.2.9"]},
  "9.1"->{
    Cell[96049, 3653, 97, 1, 70, "Subsection",
      CellTags->{"S2.2.9", "9.1"}]},
  "9.2"->{
    Cell[96149, 3656, 719, 29, 70, "Text",
      CellTags->{"S2.2.9", "9.2"}]},
  "9.3"->{
    Cell[98208, 3733, 215, 9, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.3"}]},
  "9.4"->{
    Cell[98651, 3756, 115, 2, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.4"}]},
  "9.5"->{
    Cell[99417, 3785, 141, 4, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.5"}]},
  "9.6"->{
    Cell[100243, 3819, 375, 14, 70, "Text",
      CellTags->{"S2.2.9", "9.6"}]},
  "9.7"->{
    Cell[100621, 3835, 194, 7, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.7"}]},
  "9.8"->{
    Cell[101027, 3856, 169, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.8"}]},
  "9.9"->{
    Cell[101411, 3875, 349, 11, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.9"}]},
  "9.10"->{
    Cell[102005, 3900, 190, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.10"}]},
  "9.11"->{
    Cell[102438, 3919, 142, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.11"}]},
  "9.12"->{
    Cell[106823, 4064, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.12"}]},
  "9.13"->{
    Cell[107167, 4079, 174, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.13"}]},
  "9.14"->{
    Cell[107573, 4098, 216, 9, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.14"}]},
  "9.15"->{
    Cell[108034, 4121, 164, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.15"}]},
  "9.16"->{
    Cell[108420, 4140, 182, 5, 70, "MathCaption",
      CellTags->{"S2.2.9", "9.16"}]},
  "S2.2.10"->{
    Cell[108873, 4162, 83, 1, 70, "Subsection",
      CellTags->{"S2.2.10", "10.1"}],
    Cell[108959, 4165, 365, 7, 70, "Text",
      CellTags->{"S2.2.10", "10.2"}],
    Cell[109327, 4174, 431, 10, 70, "Text",
      CellTags->{"S2.2.10", "10.3"}],
    Cell[109761, 4186, 400, 11, 70, "Text",
      CellTags->{"S2.2.10", "10.4"}],
    Cell[110164, 4199, 177, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.5"}],
    Cell[110366, 4208, 83, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[110452, 4212, 92, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[110559, 4218, 3821, 113, 70, "DefinitionBox",
      CellTags->"S2.2.10"],
    Cell[114383, 4333, 62, 1, 70, "Caption",
      CellTags->"S2.2.10"],
    Cell[114448, 4336, 232, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.6"}],
    Cell[114705, 4346, 97, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[114805, 4350, 94, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[114914, 4356, 183, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.7"}],
    Cell[115122, 4365, 106, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[115231, 4369, 110, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[115356, 4375, 1995, 62, 70, "DefinitionBox",
      CellTags->"S2.2.10"],
    Cell[117354, 4439, 70, 1, 70, "Caption",
      CellTags->"S2.2.10"],
    Cell[117427, 4442, 144, 4, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.8"}],
    Cell[117596, 4450, 98, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[117697, 4454, 95, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[117807, 4460, 234, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.9"}],
    Cell[118066, 4470, 106, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[118175, 4474, 100, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[118290, 4480, 298, 8, 70, "Text",
      CellTags->{"S2.2.10", "10.10"}],
    Cell[118591, 4490, 3518, 117, 70, "DefinitionBox",
      CellTags->"S2.2.10"],
    Cell[122112, 4609, 70, 1, 70, "Caption",
      CellTags->"S2.2.10"],
    Cell[122185, 4612, 263, 11, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.11"}],
    Cell[122473, 4627, 87, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[122563, 4631, 93, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[122671, 4637, 93, 1, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.12"}],
    Cell[122789, 4642, 94, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[122886, 4646, 119, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[123020, 4652, 916, 35, 70, "Text",
      CellTags->{"S2.2.10", "10.13"}],
    Cell[123939, 4689, 234, 8, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.14"}],
    Cell[124198, 4701, 90, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[124291, 4705, 107, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[124413, 4711, 178, 4, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.15"}],
    Cell[124616, 4719, 102, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[124721, 4723, 118, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[124854, 4729, 191, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.16"}],
    Cell[125070, 4739, 106, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[125179, 4743, 119, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[125313, 4749, 366, 14, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.17"}],
    Cell[125704, 4767, 114, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[125821, 4771, 125, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[125961, 4777, 313, 10, 70, "Text",
      CellTags->{"S2.2.10", "10.18"}],
    Cell[126277, 4789, 3315, 96, 70, "DefinitionBox",
      CellTags->"S2.2.10"],
    Cell[129595, 4887, 79, 1, 70, "Caption",
      CellTags->"S2.2.10"],
    Cell[129677, 4890, 103, 1, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.19"}],
    Cell[129805, 4895, 87, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[129895, 4899, 104, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[130014, 4905, 214, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.20"}],
    Cell[130253, 4914, 75, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[130331, 4918, 105, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[130451, 4924, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.21"}],
    Cell[130576, 4929, 103, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[130682, 4933, 117, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[130814, 4939, 565, 15, 70, "Text",
      CellTags->{"S2.2.10", "10.22"}],
    Cell[131382, 4956, 219, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.23"}],
    Cell[131626, 4965, 80, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[131709, 4969, 107, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[131831, 4975, 155, 4, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.24"}],
    Cell[132011, 4983, 77, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[132091, 4987, 100, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[132206, 4993, 175, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.25"}],
    Cell[132406, 5002, 82, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[132491, 5006, 105, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[132611, 5012, 1736, 49, 70, "DefinitionBox",
      CellTags->"S2.2.10"],
    Cell[134350, 5063, 80, 1, 70, "Caption",
      CellTags->"S2.2.10"],
    Cell[134433, 5066, 1121, 41, 70, "Text",
      CellTags->{"S2.2.10", "10.26"}],
    Cell[135557, 5109, 197, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.27"}],
    Cell[135779, 5119, 93, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[135875, 5123, 143, 4, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[136033, 5130, 164, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.28"}],
    Cell[136222, 5139, 104, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[136329, 5143, 158, 4, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[136502, 5150, 170, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.29"}],
    Cell[136697, 5159, 94, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[136794, 5163, 126, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[136935, 5169, 393, 11, 70, "Text",
      CellTags->{"S2.2.10", "10.30"}],
    Cell[137331, 5182, 137, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.31"}],
    Cell[137493, 5191, 93, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[137589, 5195, 102, 3, 70, "Output",
      CellTags->"S2.2.10"],
    Cell[137706, 5201, 157, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.32"}],
    Cell[137888, 5211, 100, 2, 70, "Input",
      CellTags->"S2.2.10"],
    Cell[137991, 5215, 94, 3, 70, "Output",
      CellTags->"S2.2.10"]},
  "10.1"->{
    Cell[108873, 4162, 83, 1, 70, "Subsection",
      CellTags->{"S2.2.10", "10.1"}]},
  "10.2"->{
    Cell[108959, 4165, 365, 7, 70, "Text",
      CellTags->{"S2.2.10", "10.2"}]},
  "10.3"->{
    Cell[109327, 4174, 431, 10, 70, "Text",
      CellTags->{"S2.2.10", "10.3"}]},
  "10.4"->{
    Cell[109761, 4186, 400, 11, 70, "Text",
      CellTags->{"S2.2.10", "10.4"}]},
  "10.5"->{
    Cell[110164, 4199, 177, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.5"}]},
  "10.6"->{
    Cell[114448, 4336, 232, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.6"}]},
  "10.7"->{
    Cell[114914, 4356, 183, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.7"}]},
  "10.8"->{
    Cell[117427, 4442, 144, 4, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.8"}]},
  "10.9"->{
    Cell[117807, 4460, 234, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.9"}]},
  "10.10"->{
    Cell[118290, 4480, 298, 8, 70, "Text",
      CellTags->{"S2.2.10", "10.10"}]},
  "10.11"->{
    Cell[122185, 4612, 263, 11, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.11"}]},
  "10.12"->{
    Cell[122671, 4637, 93, 1, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.12"}]},
  "10.13"->{
    Cell[123020, 4652, 916, 35, 70, "Text",
      CellTags->{"S2.2.10", "10.13"}]},
  "10.14"->{
    Cell[123939, 4689, 234, 8, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.14"}]},
  "10.15"->{
    Cell[124413, 4711, 178, 4, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.15"}]},
  "10.16"->{
    Cell[124854, 4729, 191, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.16"}]},
  "10.17"->{
    Cell[125313, 4749, 366, 14, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.17"}]},
  "10.18"->{
    Cell[125961, 4777, 313, 10, 70, "Text",
      CellTags->{"S2.2.10", "10.18"}]},
  "10.19"->{
    Cell[129677, 4890, 103, 1, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.19"}]},
  "10.20"->{
    Cell[130014, 4905, 214, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.20"}]},
  "10.21"->{
    Cell[130451, 4924, 100, 1, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.21"}]},
  "10.22"->{
    Cell[130814, 4939, 565, 15, 70, "Text",
      CellTags->{"S2.2.10", "10.22"}]},
  "10.23"->{
    Cell[131382, 4956, 219, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.23"}]},
  "10.24"->{
    Cell[131831, 4975, 155, 4, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.24"}]},
  "10.25"->{
    Cell[132206, 4993, 175, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.25"}]},
  "10.26"->{
    Cell[134433, 5066, 1121, 41, 70, "Text",
      CellTags->{"S2.2.10", "10.26"}]},
  "10.27"->{
    Cell[135557, 5109, 197, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.27"}]},
  "10.28"->{
    Cell[136033, 5130, 164, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.28"}]},
  "10.29"->{
    Cell[136502, 5150, 170, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.29"}]},
  "10.30"->{
    Cell[136935, 5169, 393, 11, 70, "Text",
      CellTags->{"S2.2.10", "10.30"}]},
  "10.31"->{
    Cell[137331, 5182, 137, 5, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.31"}]},
  "10.32"->{
    Cell[137706, 5201, 157, 6, 70, "MathCaption",
      CellTags->{"S2.2.10", "10.32"}]},
  "S2.2.11"->{
    Cell[138134, 5224, 71, 1, 70, "Subsection",
      CellTags->{"S2.2.11", "11.1"}],
    Cell[138208, 5227, 172, 5, 70, "MathCaption",
      CellTags->{"S2.2.11", "11.2"}],
    Cell[138405, 5236, 93, 2, 28, "Input",
      CellTags->"S2.2.11"],
    Cell[138501, 5240, 97, 3, 70, "Output",
      CellTags->"S2.2.11"],
    Cell[138613, 5246, 168, 4, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.3"}],
    Cell[138806, 5254, 98, 2, 28, "Input",
      CellTags->"S2.2.11"],
    Cell[138907, 5258, 99, 3, 25, "Output",
      CellTags->"S2.2.11"],
    Cell[139021, 5264, 187, 5, 56, "MathCaption",
      CellTags->{"S2.2.11", "11.4"}],
    Cell[139233, 5273, 100, 2, 28, "Input",
      CellTags->"S2.2.11"],
    Cell[139336, 5277, 97, 3, 25, "Output",
      CellTags->"S2.2.11"],
    Cell[139448, 5283, 1010, 31, 64, "DefinitionBox",
      CellTags->"S2.2.11"],
    Cell[140461, 5316, 92, 1, 16, "Caption",
      CellTags->"S2.2.11"],
    Cell[140556, 5319, 126, 4, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.5"}],
    Cell[140707, 5327, 85, 2, 28, "Input",
      CellTags->"S2.2.11"],
    Cell[140795, 5331, 92, 3, 25, "Output",
      CellTags->"S2.2.11"],
    Cell[140902, 5337, 106, 1, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.6"}],
    Cell[141033, 5342, 84, 2, 28, "Input",
      CellTags->"S2.2.11"],
    Cell[141120, 5346, 105, 3, 25, "Output",
      CellTags->"S2.2.11"],
    Cell[141240, 5352, 144, 5, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.7"}],
    Cell[141409, 5361, 110, 2, 28, "Input",
      CellTags->"S2.2.11"],
    Cell[141522, 5365, 106, 3, 25, "Output",
      CellTags->"S2.2.11"]},
  "11.1"->{
    Cell[138134, 5224, 71, 1, 70, "Subsection",
      CellTags->{"S2.2.11", "11.1"}]},
  "11.2"->{
    Cell[138208, 5227, 172, 5, 70, "MathCaption",
      CellTags->{"S2.2.11", "11.2"}]},
  "11.3"->{
    Cell[138613, 5246, 168, 4, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.3"}]},
  "11.4"->{
    Cell[139021, 5264, 187, 5, 56, "MathCaption",
      CellTags->{"S2.2.11", "11.4"}]},
  "11.5"->{
    Cell[140556, 5319, 126, 4, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.5"}]},
  "11.6"->{
    Cell[140902, 5337, 106, 1, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.6"}]},
  "11.7"->{
    Cell[141240, 5352, 144, 5, 40, "MathCaption",
      CellTags->{"S2.2.11", "11.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.2.0", 142283, 5389},
  {"0.1", 142373, 5392},
  {"S2.2.1", 142466, 5395},
  {"1.1", 144399, 5448},
  {"1.2", 144491, 5451},
  {"1.3", 144579, 5454},
  {"1.4", 144673, 5457},
  {"1.5", 144767, 5460},
  {"1.6", 144862, 5463},
  {"1.7", 144957, 5466},
  {"1.8", 145045, 5469},
  {"1.9", 145134, 5472},
  {"1.10", 145230, 5475},
  {"1.11", 145327, 5478},
  {"1.12", 145424, 5481},
  {"1.13", 145514, 5484},
  {"S2.2.2", 145606, 5487},
  {"2.1", 150338, 5614},
  {"2.2", 150431, 5617},
  {"2.3", 150519, 5620},
  {"2.4", 150615, 5623},
  {"2.5", 150710, 5626},
  {"2.6", 150805, 5629},
  {"2.7", 150901, 5632},
  {"2.8", 150991, 5635},
  {"2.9", 151087, 5638},
  {"2.10", 151184, 5641},
  {"2.11", 151282, 5644},
  {"2.12", 151379, 5647},
  {"2.13", 151477, 5650},
  {"2.14", 151575, 5653},
  {"2.15", 151673, 5656},
  {"2.16", 151771, 5659},
  {"2.17", 151863, 5662},
  {"2.18", 151954, 5665},
  {"2.19", 152052, 5668},
  {"2.20", 152150, 5671},
  {"2.21", 152247, 5674},
  {"2.22", 152339, 5677},
  {"2.23", 152437, 5680},
  {"2.24", 152535, 5683},
  {"S2.2.3", 152635, 5686},
  {"3.1", 154687, 5741},
  {"3.2", 154782, 5744},
  {"3.3", 154872, 5747},
  {"3.4", 154969, 5750},
  {"3.5", 155066, 5753},
  {"3.6", 155163, 5756},
  {"3.7", 155261, 5759},
  {"3.8", 155357, 5762},
  {"3.9", 155454, 5765},
  {"3.10", 155552, 5768},
  {"S2.2.4", 155653, 5771},
  {"4.1", 163124, 5970},
  {"4.2", 163220, 5973},
  {"4.3", 163310, 5976},
  {"4.4", 163407, 5979},
  {"4.5", 163504, 5982},
  {"4.6", 163601, 5985},
  {"4.7", 163692, 5988},
  {"4.8", 163789, 5991},
  {"4.9", 163886, 5994},
  {"4.10", 163978, 5997},
  {"4.11", 164077, 6000},
  {"4.12", 164176, 6003},
  {"4.13", 164276, 6006},
  {"4.14", 164369, 6009},
  {"4.15", 164468, 6012},
  {"4.16", 164567, 6015},
  {"4.17", 164660, 6018},
  {"4.18", 164759, 6021},
  {"4.19", 164859, 6024},
  {"4.20", 164958, 6027},
  {"4.21", 165057, 6030},
  {"4.22", 165156, 6033},
  {"4.23", 165254, 6036},
  {"4.24", 165353, 6039},
  {"4.25", 165452, 6042},
  {"4.26", 165551, 6045},
  {"4.27", 165650, 6048},
  {"4.28", 165742, 6051},
  {"4.29", 165841, 6054},
  {"4.30", 165940, 6057},
  {"4.31", 166032, 6060},
  {"4.32", 166131, 6063},
  {"4.33", 166230, 6066},
  {"S2.2.5", 166331, 6069},
  {"5.1", 170232, 6172},
  {"5.2", 170327, 6175},
  {"5.3", 170418, 6178},
  {"5.4", 170515, 6181},
  {"5.5", 170612, 6184},
  {"5.6", 170709, 6187},
  {"5.7", 170800, 6190},
  {"5.8", 170897, 6193},
  {"5.9", 170994, 6196},
  {"5.10", 171085, 6199},
  {"5.11", 171184, 6202},
  {"5.12", 171283, 6205},
  {"5.13", 171382, 6208},
  {"5.14", 171475, 6211},
  {"5.15", 171568, 6214},
  {"5.16", 171661, 6217},
  {"5.17", 171760, 6220},
  {"5.18", 171859, 6223},
  {"5.19", 171959, 6226},
  {"5.20", 172051, 6229},
  {"5.21", 172144, 6232},
  {"5.22", 172237, 6235},
  {"5.23", 172336, 6238},
  {"S2.2.6", 172437, 6241},
  {"6.1", 174115, 6286},
  {"6.2", 174210, 6289},
  {"6.3", 174307, 6292},
  {"6.4", 174404, 6295},
  {"6.5", 174502, 6298},
  {"6.6", 174600, 6301},
  {"6.7", 174697, 6304},
  {"6.8", 174788, 6307},
  {"S2.2.7", 174889, 6310},
  {"7.1", 176351, 6349},
  {"7.2", 176447, 6352},
  {"7.3", 176538, 6355},
  {"7.4", 176629, 6358},
  {"7.5", 176726, 6361},
  {"7.6", 176816, 6364},
  {"7.7", 176913, 6367},
  {"7.8", 177010, 6370},
  {"7.9", 177101, 6373},
  {"S2.2.8", 177201, 6376},
  {"8.1", 179643, 6441},
  {"8.2", 179739, 6444},
  {"8.3", 179830, 6447},
  {"8.4", 179927, 6450},
  {"8.5", 180024, 6453},
  {"8.6", 180115, 6456},
  {"8.7", 180212, 6459},
  {"8.8", 180302, 6462},
  {"8.9", 180399, 6465},
  {"8.10", 180497, 6468},
  {"8.11", 180596, 6471},
  {"8.12", 180688, 6474},
  {"8.13", 180781, 6477},
  {"8.14", 180880, 6480},
  {"S2.2.9", 180982, 6483},
  {"9.1", 184503, 6576},
  {"9.2", 184598, 6579},
  {"9.3", 184689, 6582},
  {"9.4", 184786, 6585},
  {"9.5", 184883, 6588},
  {"9.6", 184980, 6591},
  {"9.7", 185072, 6594},
  {"9.8", 185170, 6597},
  {"9.9", 185268, 6600},
  {"9.10", 185368, 6603},
  {"9.11", 185468, 6606},
  {"9.12", 185568, 6609},
  {"9.13", 185668, 6612},
  {"9.14", 185768, 6615},
  {"9.15", 185868, 6618},
  {"9.16", 185968, 6621},
  {"S2.2.10", 186071, 6624},
  {"10.1", 192815, 6797},
  {"10.2", 192914, 6800},
  {"10.3", 193008, 6803},
  {"10.4", 193103, 6806},
  {"10.5", 193198, 6809},
  {"10.6", 193299, 6812},
  {"10.7", 193400, 6815},
  {"10.8", 193501, 6818},
  {"10.9", 193602, 6821},
  {"10.10", 193704, 6824},
  {"10.11", 193800, 6827},
  {"10.12", 193904, 6830},
  {"10.13", 194006, 6833},
  {"10.14", 194103, 6836},
  {"10.15", 194206, 6839},
  {"10.16", 194309, 6842},
  {"10.17", 194412, 6845},
  {"10.18", 194516, 6848},
  {"10.19", 194613, 6851},
  {"10.20", 194716, 6854},
  {"10.21", 194819, 6857},
  {"10.22", 194922, 6860},
  {"10.23", 195019, 6863},
  {"10.24", 195122, 6866},
  {"10.25", 195225, 6869},
  {"10.26", 195328, 6872},
  {"10.27", 195426, 6875},
  {"10.28", 195529, 6878},
  {"10.29", 195632, 6881},
  {"10.30", 195735, 6884},
  {"10.31", 195832, 6887},
  {"10.32", 195935, 6890},
  {"S2.2.11", 196040, 6893},
  {"11.1", 197684, 6936},
  {"11.2", 197783, 6939},
  {"11.3", 197884, 6942},
  {"11.4", 197985, 6945},
  {"11.5", 198086, 6948},
  {"11.6", 198187, 6951},
  {"11.7", 198288, 6954}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 124, 4, 65, "Section",
  CellTags->{"S2.2.0", "0.1"}],

Cell[CellGroupData[{
Cell[1925, 61, 88, 1, 70, "Subsection",
  CellTags->{"S2.2.1", "1.1"}],
Cell[2016, 64, 363, 11, 70, "Text",
  CellTags->{"S2.2.1", "1.2"}],
Cell[2382, 77, 127, 4, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.3"}],

Cell[CellGroupData[{
Cell[2534, 85, 89, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[2626, 89, 96, 3, 70, "Output",
  CellTags->"S2.2.1"]
}, Open  ]],
Cell[2737, 95, 114, 2, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.4"}],

Cell[CellGroupData[{
Cell[2876, 101, 81, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[2960, 105, 89, 3, 70, "Output",
  CellTags->"S2.2.1"]
}, Open  ]],
Cell[3064, 111, 132, 4, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.5"}],
Cell[3199, 117, 93, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[3295, 121, 142, 5, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.6"}],

Cell[CellGroupData[{
Cell[3462, 130, 74, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[3539, 134, 100, 3, 70, "Output",
  CellTags->"S2.2.1"]
}, Open  ]],
Cell[3654, 140, 380, 8, 70, "Text",
  CellTags->{"S2.2.1", "1.7"}],
Cell[4037, 150, 659, 18, 70, "Text",
  CellTags->{"S2.2.1", "1.8"}],
Cell[4699, 170, 272, 7, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.9"}],

Cell[CellGroupData[{
Cell[4996, 181, 87, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[5086, 185, 84, 3, 70, "Output",
  CellTags->"S2.2.1"]
}, Open  ]],
Cell[5185, 191, 183, 5, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.10"}],

Cell[CellGroupData[{
Cell[5393, 200, 68, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[5464, 204, 87, 3, 70, "Output",
  CellTags->"S2.2.1"]
}, Open  ]],
Cell[5566, 210, 158, 5, 70, "MathCaption",
  CellTags->{"S2.2.1", "1.11"}],

Cell[CellGroupData[{
Cell[5749, 219, 86, 2, 70, "Input",
  CellTags->"S2.2.1"],
Cell[5838, 223, 186, 6, 70, "Output",
  CellTags->"S2.2.1"]
}, Open  ]],
Cell[6039, 232, 257, 6, 70, "Text",
  CellTags->{"S2.2.1", "1.12"}],
Cell[6299, 240, 460, 9, 70, "Text",
  CellTags->{"S2.2.1", "1.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6796, 254, 88, 1, 70, "Subsection",
  CellTags->{"S2.2.2", "2.1"}],
Cell[6887, 257, 267, 8, 70, "Text",
  CellTags->{"S2.2.2", "2.2"}],
Cell[7157, 267, 1976, 64, 70, "DefinitionBox",
  CellTags->"S2.2.2"],
Cell[9136, 333, 88, 1, 70, "Caption",
  CellTags->"S2.2.2"],
Cell[9227, 336, 452, 18, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.3"}],

Cell[CellGroupData[{
Cell[9704, 358, 77, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[9784, 362, 94, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[9893, 368, 100, 1, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.4"}],

Cell[CellGroupData[{
Cell[10018, 373, 81, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[10102, 377, 126, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[10243, 383, 81, 1, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.5"}],
Cell[10327, 386, 86, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[10416, 390, 139, 5, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.6"}],

Cell[CellGroupData[{
Cell[10580, 399, 81, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[10664, 403, 115, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[10794, 409, 371, 12, 70, "Text",
  CellTags->{"S2.2.2", "2.7"}],
Cell[11168, 423, 1641, 50, 70, "DefinitionBox",
  CellTags->"S2.2.2"],
Cell[12812, 475, 96, 1, 70, "Caption",
  CellTags->"S2.2.2"],
Cell[12911, 478, 213, 6, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.8"}],
Cell[13127, 486, 99, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[13229, 490, 281, 9, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.9"}],

Cell[CellGroupData[{
Cell[13535, 503, 89, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[13627, 507, 168, 4, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[13810, 514, 242, 7, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.10"}],

Cell[CellGroupData[{
Cell[14077, 525, 88, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[14168, 529, 100, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[14283, 535, 88, 1, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.11"}],

Cell[CellGroupData[{
Cell[14396, 540, 92, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[14491, 544, 189, 4, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[14695, 551, 4114, 128, 70, "DefinitionBox",
  CellTags->"S2.2.2"],
Cell[18812, 681, 91, 1, 70, "Caption",
  CellTags->"S2.2.2"],
Cell[18906, 684, 103, 1, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.12"}],
Cell[19012, 687, 82, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[19097, 691, 177, 5, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.13"}],

Cell[CellGroupData[{
Cell[19299, 700, 102, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[19404, 704, 129, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[19548, 710, 260, 8, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.14"}],

Cell[CellGroupData[{
Cell[19833, 722, 104, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[19940, 726, 190, 4, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[20145, 733, 145, 4, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.15"}],

Cell[CellGroupData[{
Cell[20315, 741, 109, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[20427, 745, 103, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[20545, 751, 315, 10, 70, "Text",
  CellTags->{"S2.2.2", "2.16"}],
Cell[20863, 763, 381, 7, 70, "Text",
  CellTags->{"S2.2.2", "2.17"}],
Cell[21247, 772, 2945, 97, 70, "DefinitionBox",
  CellTags->"S2.2.2"],
Cell[24195, 871, 94, 1, 70, "Caption",
  CellTags->"S2.2.2"],
Cell[24292, 874, 141, 5, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.18"}],

Cell[CellGroupData[{
Cell[24458, 883, 90, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[24551, 887, 130, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[24696, 893, 183, 6, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.19"}],

Cell[CellGroupData[{
Cell[24904, 903, 86, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[24993, 907, 101, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[25109, 913, 93, 1, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.20"}],

Cell[CellGroupData[{
Cell[25227, 918, 93, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[25323, 922, 106, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]],
Cell[25444, 928, 454, 14, 70, "Text",
  CellTags->{"S2.2.2", "2.21"}],
Cell[25901, 944, 134, 5, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.22"}],
Cell[26038, 951, 94, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[26135, 955, 158, 5, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.23"}],
Cell[26296, 962, 114, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[26413, 966, 101, 1, 70, "MathCaption",
  CellTags->{"S2.2.2", "2.24"}],

Cell[CellGroupData[{
Cell[26539, 971, 95, 2, 70, "Input",
  CellTags->"S2.2.2"],
Cell[26637, 975, 88, 3, 70, "Output",
  CellTags->"S2.2.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26774, 984, 108, 1, 70, "Subsection",
  CellTags->{"S2.2.3", "3.1"}],
Cell[26885, 987, 454, 15, 70, "Text",
  CellTags->{"S2.2.3", "3.2"}],
Cell[27342, 1004, 165, 5, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.3"}],

Cell[CellGroupData[{
Cell[27532, 1013, 83, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[27618, 1017, 91, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]],
Cell[27724, 1023, 229, 9, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.4"}],

Cell[CellGroupData[{
Cell[27978, 1036, 86, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[28067, 1040, 90, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]],
Cell[28172, 1046, 167, 5, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.5"}],
Cell[28342, 1053, 111, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[28456, 1057, 2942, 95, 70, "DefinitionBox",
  CellTags->"S2.2.3"],
Cell[31401, 1154, 92, 1, 70, "Caption",
  CellTags->"S2.2.3"],
Cell[31496, 1157, 285, 10, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.6"}],

Cell[CellGroupData[{
Cell[31806, 1171, 86, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[31895, 1175, 90, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]],
Cell[32000, 1181, 72, 1, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.7"}],

Cell[CellGroupData[{
Cell[32097, 1186, 90, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[32190, 1190, 103, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]],
Cell[32308, 1196, 224, 8, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.8"}],

Cell[CellGroupData[{
Cell[32557, 1208, 75, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[32635, 1212, 104, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]],
Cell[32754, 1218, 172, 7, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.9"}],

Cell[CellGroupData[{
Cell[32951, 1229, 80, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[33034, 1233, 105, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]],
Cell[33154, 1239, 137, 5, 70, "MathCaption",
  CellTags->{"S2.2.3", "3.10"}],

Cell[CellGroupData[{
Cell[33316, 1248, 83, 2, 70, "Input",
  CellTags->"S2.2.3"],
Cell[33402, 1252, 106, 3, 70, "Output",
  CellTags->"S2.2.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33557, 1261, 101, 1, 70, "Subsection",
  CellTags->{"S2.2.4", "4.1"}],
Cell[33661, 1264, 284, 8, 70, "Text",
  CellTags->{"S2.2.4", "4.2"}],
Cell[33948, 1274, 151, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.3"}],

Cell[CellGroupData[{
Cell[34124, 1283, 81, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[34208, 1287, 99, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[34322, 1293, 136, 4, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.4"}],
Cell[34461, 1299, 93, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[34557, 1303, 184, 7, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.5"}],

Cell[CellGroupData[{
Cell[34766, 1314, 112, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[34881, 1318, 105, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[35001, 1324, 1292, 42, 70, "DefinitionBox",
  CellTags->"S2.2.4"],
Cell[36296, 1368, 88, 1, 70, "Caption",
  CellTags->"S2.2.4"],
Cell[36387, 1371, 475, 17, 70, "Text",
  CellTags->{"S2.2.4", "4.6"}],
Cell[36865, 1390, 141, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.7"}],

Cell[CellGroupData[{
Cell[37031, 1399, 81, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[37115, 1403, 99, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[37229, 1409, 185, 7, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.8"}],

Cell[CellGroupData[{
Cell[37439, 1420, 86, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[37528, 1424, 98, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[37641, 1430, 567, 26, 70, "Text",
  CellTags->{"S2.2.4", "4.9"}],
Cell[38211, 1458, 205, 8, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.10"}],

Cell[CellGroupData[{
Cell[38441, 1470, 84, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[38528, 1474, 97, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[38640, 1480, 225, 8, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.11"}],

Cell[CellGroupData[{
Cell[38890, 1492, 73, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[38966, 1496, 103, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[39084, 1502, 329, 12, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.12"}],

Cell[CellGroupData[{
Cell[39438, 1518, 76, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[39517, 1522, 118, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[39650, 1528, 345, 10, 70, "Text",
  CellTags->{"S2.2.4", "4.13"}],
Cell[39998, 1540, 177, 7, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.14"}],

Cell[CellGroupData[{
Cell[40200, 1551, 78, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[40281, 1555, 109, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[40405, 1561, 221, 7, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.15"}],

Cell[CellGroupData[{
Cell[40651, 1572, 87, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[40741, 1576, 115, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[40871, 1582, 2122, 68, 70, "DefinitionBox",
  CellTags->"S2.2.4"],
Cell[42996, 1652, 101, 1, 70, "Caption",
  CellTags->"S2.2.4"],
Cell[43100, 1655, 509, 14, 70, "Text",
  CellTags->{"S2.2.4", "4.16"}],
Cell[43612, 1671, 170, 6, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.17"}],

Cell[CellGroupData[{
Cell[43807, 1681, 92, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[43902, 1685, 104, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[44021, 1691, 254, 13, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.18"}],

Cell[CellGroupData[{
Cell[44300, 1708, 95, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[44398, 1712, 110, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[44523, 1718, 187, 7, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.19"}],

Cell[CellGroupData[{
Cell[44735, 1729, 80, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[44818, 1733, 98, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[44931, 1739, 205, 7, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.20"}],

Cell[CellGroupData[{
Cell[45161, 1750, 80, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[45244, 1754, 110, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[45369, 1760, 171, 4, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.21"}],

Cell[CellGroupData[{
Cell[45565, 1768, 99, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[45667, 1772, 100, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[45782, 1778, 1308, 40, 70, "DefinitionBox",
  CellTags->"S2.2.4"],
Cell[47093, 1820, 97, 1, 70, "Caption",
  CellTags->"S2.2.4"],
Cell[47193, 1823, 78, 1, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.22"}],

Cell[CellGroupData[{
Cell[47296, 1828, 86, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[47385, 1832, 103, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[47503, 1838, 127, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.23"}],

Cell[CellGroupData[{
Cell[47655, 1847, 78, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[47736, 1851, 288, 8, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[48039, 1862, 218, 6, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.24"}],

Cell[CellGroupData[{
Cell[48282, 1872, 97, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[48382, 1876, 109, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[48506, 1882, 1396, 43, 70, "DefinitionBox",
  CellTags->"S2.2.4"],
Cell[49905, 1927, 89, 1, 70, "Caption",
  CellTags->"S2.2.4"],
Cell[49997, 1930, 230, 8, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.25"}],

Cell[CellGroupData[{
Cell[50252, 1942, 89, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[50344, 1946, 115, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[50474, 1952, 142, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.26"}],

Cell[CellGroupData[{
Cell[50641, 1961, 99, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[50743, 1965, 165, 4, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[50923, 1972, 370, 9, 70, "Text",
  CellTags->{"S2.2.4", "4.27"}],
Cell[51296, 1983, 2817, 83, 70, "DefinitionBox",
  CellTags->"S2.2.4"],
Cell[54116, 2068, 93, 1, 70, "Caption",
  CellTags->"S2.2.4"],
Cell[54212, 2071, 155, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.28"}],

Cell[CellGroupData[{
Cell[54392, 2080, 104, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[54499, 2084, 112, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[54626, 2090, 184, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.29"}],

Cell[CellGroupData[{
Cell[54835, 2099, 109, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[54947, 2103, 112, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[55074, 2109, 484, 9, 70, "Text",
  CellTags->{"S2.2.4", "4.30"}],
Cell[55561, 2120, 1297, 41, 70, "DefinitionBox",
  CellTags->"S2.2.4"],
Cell[56861, 2163, 87, 1, 70, "Caption",
  CellTags->"S2.2.4"],
Cell[56951, 2166, 204, 6, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.31"}],

Cell[CellGroupData[{
Cell[57180, 2176, 82, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[57265, 2180, 100, 3, 70, "Output",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[57380, 2186, 202, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.32"}],

Cell[CellGroupData[{
Cell[57607, 2195, 87, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[57697, 2199, 56, 2, 70, "Print",
  CellTags->"S2.2.4"],
Cell[57756, 2203, 56, 2, 70, "Print",
  CellTags->"S2.2.4"],
Cell[57815, 2207, 56, 2, 70, "Print",
  CellTags->"S2.2.4"]
}, Open  ]],
Cell[57886, 2212, 196, 5, 70, "MathCaption",
  CellTags->{"S2.2.4", "4.33"}],

Cell[CellGroupData[{
Cell[58107, 2221, 95, 2, 70, "Input",
  CellTags->"S2.2.4"],
Cell[58205, 2225, 56, 2, 70, "Print",
  CellTags->"S2.2.4"],
Cell[58264, 2229, 56, 2, 70, "Print",
  CellTags->"S2.2.4"],
Cell[58323, 2233, 56, 2, 70, "Print",
  CellTags->"S2.2.4"],
Cell[58382, 2237, 59, 2, 70, "Print",
  CellTags->"S2.2.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58490, 2245, 73, 1, 70, "Subsection",
  CellTags->{"S2.2.5", "5.1"}],
Cell[58566, 2248, 1972, 59, 70, "DefinitionBox",
  CellTags->"S2.2.5"],
Cell[60541, 2309, 57, 1, 70, "Caption",
  CellTags->"S2.2.5"],
Cell[60601, 2312, 504, 11, 70, "Text",
  CellTags->{"S2.2.5", "5.2"}],
Cell[61108, 2325, 125, 5, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.3"}],
Cell[61236, 2332, 84, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[61323, 2336, 177, 7, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.4"}],

Cell[CellGroupData[{
Cell[61525, 2347, 81, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[61609, 2351, 120, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[61744, 2357, 116, 2, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.5"}],

Cell[CellGroupData[{
Cell[61885, 2363, 95, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[61983, 2367, 120, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[62118, 2373, 546, 16, 70, "Text",
  CellTags->{"S2.2.5", "5.6"}],
Cell[62667, 2391, 132, 4, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.7"}],

Cell[CellGroupData[{
Cell[62824, 2399, 80, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[62907, 2403, 98, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[63020, 2409, 196, 7, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.8"}],

Cell[CellGroupData[{
Cell[63241, 2420, 68, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[63312, 2424, 85, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[63412, 2430, 141, 4, 70, "Text",
  CellTags->{"S2.2.5", "5.9"}],
Cell[63556, 2436, 135, 5, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.10"}],

Cell[CellGroupData[{
Cell[63716, 2445, 98, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[63817, 2449, 99, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[63931, 2455, 111, 5, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.11"}],

Cell[CellGroupData[{
Cell[64067, 2464, 98, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[64168, 2468, 115, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[64298, 2474, 233, 8, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.12"}],

Cell[CellGroupData[{
Cell[64556, 2486, 98, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[64657, 2490, 92, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[64764, 2496, 564, 17, 70, "Text",
  CellTags->{"S2.2.5", "5.13"}],
Cell[65331, 2515, 420, 10, 70, "Text",
  CellTags->{"S2.2.5", "5.14"}],
Cell[65754, 2527, 1261, 36, 70, "DefinitionBox",
  CellTags->"S2.2.5"],
Cell[67018, 2565, 73, 1, 70, "Caption",
  CellTags->"S2.2.5"],
Cell[67094, 2568, 830, 23, 70, "Text",
  CellTags->{"S2.2.5", "5.15"}],
Cell[67927, 2593, 190, 6, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.16"}],

Cell[CellGroupData[{
Cell[68142, 2603, 87, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[68232, 2607, 99, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[68346, 2613, 219, 5, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.17"}],

Cell[CellGroupData[{
Cell[68590, 2622, 116, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[68709, 2626, 106, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[68830, 2632, 318, 10, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.18"}],
Cell[69151, 2644, 118, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[69272, 2648, 321, 7, 70, "Text",
  CellTags->{"S2.2.5", "5.19"}],
Cell[69596, 2657, 839, 28, 70, "Text",
  CellTags->{"S2.2.5", "5.20"}],
Cell[70438, 2687, 452, 14, 70, "Text",
  CellTags->{"S2.2.5", "5.21"}],
Cell[70893, 2703, 122, 4, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.22"}],

Cell[CellGroupData[{
Cell[71040, 2711, 82, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[71125, 2715, 95, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]],
Cell[71235, 2721, 144, 4, 70, "MathCaption",
  CellTags->{"S2.2.5", "5.23"}],

Cell[CellGroupData[{
Cell[71404, 2729, 111, 2, 70, "Input",
  CellTags->"S2.2.5"],
Cell[71518, 2733, 105, 3, 70, "Output",
  CellTags->"S2.2.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71672, 2742, 88, 1, 70, "Subsection",
  CellTags->{"S2.2.6", "6.1"}],
Cell[71763, 2745, 7050, 217, 70, "DefinitionBox",
  CellTags->"S2.2.6"],
Cell[78816, 2964, 70, 1, 70, "Caption",
  CellTags->"S2.2.6"],
Cell[78889, 2967, 198, 7, 70, "MathCaption",
  CellTags->{"S2.2.6", "6.2"}],

Cell[CellGroupData[{
Cell[79112, 2978, 75, 2, 70, "Input",
  CellTags->"S2.2.6"],
Cell[79190, 2982, 111, 3, 70, "Output",
  CellTags->"S2.2.6"]
}, Open  ]],
Cell[79316, 2988, 100, 1, 70, "MathCaption",
  CellTags->{"S2.2.6", "6.3"}],

Cell[CellGroupData[{
Cell[79441, 2993, 83, 2, 70, "Input",
  CellTags->"S2.2.6"],
Cell[79527, 2997, 111, 3, 70, "Output",
  CellTags->"S2.2.6"]
}, Open  ]],
Cell[79653, 3003, 333, 12, 70, "MathCaption",
  CellTags->{"S2.2.6", "6.4"}],

Cell[CellGroupData[{
Cell[80011, 3019, 84, 2, 70, "Input",
  CellTags->"S2.2.6"],
Cell[80098, 3023, 99, 3, 70, "Output",
  CellTags->"S2.2.6"]
}, Open  ]],
Cell[80212, 3029, 324, 13, 70, "MathCaption",
  CellTags->{"S2.2.6", "6.5"}],

Cell[CellGroupData[{
Cell[80561, 3046, 80, 2, 70, "Input",
  CellTags->"S2.2.6"],
Cell[80644, 3050, 141, 4, 70, "Output",
  CellTags->"S2.2.6"]
}, Open  ]],
Cell[80800, 3057, 236, 6, 70, "MathCaption",
  CellTags->{"S2.2.6", "6.6"}],

Cell[CellGroupData[{
Cell[81061, 3067, 91, 2, 70, "Input",
  CellTags->"S2.2.6"],
Cell[81155, 3071, 120, 3, 70, "Output",
  CellTags->"S2.2.6"]
}, Open  ]],
Cell[81290, 3077, 408, 13, 70, "Text",
  CellTags->{"S2.2.6", "6.7"}],
Cell[81701, 3092, 458, 16, 70, "MathCaption",
  CellTags->{"S2.2.6", "6.8"}],

Cell[CellGroupData[{
Cell[82184, 3112, 92, 2, 70, "Input",
  CellTags->"S2.2.6"],
Cell[82279, 3116, 240, 6, 70, "Output",
  CellTags->"S2.2.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82568, 3128, 104, 1, 70, "Subsection",
  CellTags->{"S2.2.7", "7.1"}],
Cell[82675, 3131, 430, 13, 70, "Text",
  CellTags->{"S2.2.7", "7.2"}],
Cell[83108, 3146, 526, 21, 70, "Text",
  CellTags->{"S2.2.7", "7.3"}],
Cell[83637, 3169, 219, 6, 70, "MathCaption",
  CellTags->{"S2.2.7", "7.4"}],

Cell[CellGroupData[{
Cell[83881, 3179, 102, 2, 70, "Input",
  CellTags->"S2.2.7"],
Cell[83986, 3183, 93, 3, 70, "Output",
  CellTags->"S2.2.7"]
}, Open  ]],
Cell[84094, 3189, 177, 5, 70, "Text",
  CellTags->{"S2.2.7", "7.5"}],
Cell[84274, 3196, 202, 9, 70, "MathCaption",
  CellTags->{"S2.2.7", "7.6"}],

Cell[CellGroupData[{
Cell[84501, 3209, 89, 2, 70, "Input",
  CellTags->"S2.2.7"],
Cell[84593, 3213, 129, 3, 70, "Output",
  CellTags->"S2.2.7"]
}, Open  ]],
Cell[84737, 3219, 219, 7, 70, "MathCaption",
  CellTags->{"S2.2.7", "7.7"}],

Cell[CellGroupData[{
Cell[84981, 3230, 87, 2, 70, "Input",
  CellTags->"S2.2.7"],
Cell[85071, 3234, 102, 3, 70, "Output",
  CellTags->"S2.2.7"]
}, Open  ]],
Cell[85188, 3240, 1425, 45, 70, "DefinitionBox",
  CellTags->"S2.2.7"],
Cell[86616, 3287, 74, 1, 70, "Caption",
  CellTags->"S2.2.7"],
Cell[86693, 3290, 313, 10, 70, "Text",
  CellTags->{"S2.2.7", "7.8"}],
Cell[87009, 3302, 136, 4, 70, "MathCaption",
  CellTags->{"S2.2.7", "7.9"}],

Cell[CellGroupData[{
Cell[87170, 3310, 103, 2, 70, "Input",
  CellTags->"S2.2.7"],
Cell[87276, 3314, 85, 3, 70, "Output",
  CellTags->"S2.2.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[87410, 3323, 102, 1, 70, "Subsection",
  CellTags->{"S2.2.8", "8.1"}],
Cell[87515, 3326, 390, 13, 70, "Text",
  CellTags->{"S2.2.8", "8.2"}],
Cell[87908, 3341, 243, 6, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.3"}],

Cell[CellGroupData[{
Cell[88176, 3351, 74, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[88253, 3355, 95, 3, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[88363, 3361, 148, 4, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.4"}],

Cell[CellGroupData[{
Cell[88536, 3369, 74, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[88613, 3373, 95, 3, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[88723, 3379, 536, 16, 70, "Text",
  CellTags->{"S2.2.8", "8.5"}],
Cell[89262, 3397, 217, 7, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.6"}],

Cell[CellGroupData[{
Cell[89504, 3408, 88, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[89595, 3412, 95, 3, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[89705, 3418, 382, 8, 70, "Text",
  CellTags->{"S2.2.8", "8.7"}],
Cell[90090, 3428, 1896, 55, 70, "DefinitionBox",
  CellTags->"S2.2.8"],
Cell[91989, 3485, 97, 1, 70, "Caption",
  CellTags->"S2.2.8"],
Cell[92089, 3488, 228, 8, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.8"}],

Cell[CellGroupData[{
Cell[92342, 3500, 119, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[92464, 3504, 271, 8, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[92750, 3515, 140, 5, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.9"}],

Cell[CellGroupData[{
Cell[92915, 3524, 77, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[92995, 3528, 166, 5, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[93176, 3536, 245, 8, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.10"}],

Cell[CellGroupData[{
Cell[93446, 3548, 71, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[93520, 3552, 99, 3, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[93634, 3558, 257, 8, 70, "Text",
  CellTags->{"S2.2.8", "8.11"}],
Cell[93894, 3568, 823, 27, 70, "Text",
  CellTags->{"S2.2.8", "8.12"}],
Cell[94720, 3597, 343, 8, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.13"}],

Cell[CellGroupData[{
Cell[95088, 3609, 81, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[95172, 3613, 260, 8, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]],
Cell[95447, 3624, 362, 12, 70, "MathCaption",
  CellTags->{"S2.2.8", "8.14"}],

Cell[CellGroupData[{
Cell[95834, 3640, 77, 2, 70, "Input",
  CellTags->"S2.2.8"],
Cell[95914, 3644, 86, 3, 70, "Output",
  CellTags->"S2.2.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96049, 3653, 97, 1, 70, "Subsection",
  CellTags->{"S2.2.9", "9.1"}],
Cell[96149, 3656, 719, 29, 70, "Text",
  CellTags->{"S2.2.9", "9.2"}],
Cell[96871, 3687, 1262, 41, 70, "DefinitionBox",
  CellTags->"S2.2.9"],
Cell[98136, 3730, 69, 1, 70, "Caption",
  CellTags->"S2.2.9"],
Cell[98208, 3733, 215, 9, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.3"}],

Cell[CellGroupData[{
Cell[98448, 3746, 84, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[98535, 3750, 101, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[98651, 3756, 115, 2, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.4"}],

Cell[CellGroupData[{
Cell[98791, 3762, 98, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[98892, 3766, 510, 16, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[99417, 3785, 141, 4, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.5"}],

Cell[CellGroupData[{
Cell[99583, 3793, 68, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[99654, 3797, 574, 19, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[100243, 3819, 375, 14, 70, "Text",
  CellTags->{"S2.2.9", "9.6"}],
Cell[100621, 3835, 194, 7, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.7"}],

Cell[CellGroupData[{
Cell[100840, 3846, 74, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[100917, 3850, 95, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[101027, 3856, 169, 5, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.8"}],

Cell[CellGroupData[{
Cell[101221, 3865, 80, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[101304, 3869, 92, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[101411, 3875, 349, 11, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.9"}],

Cell[CellGroupData[{
Cell[101785, 3890, 85, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[101873, 3894, 117, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[102005, 3900, 190, 5, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.10"}],

Cell[CellGroupData[{
Cell[102220, 3909, 71, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[102294, 3913, 129, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[102438, 3919, 142, 5, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.11"}],

Cell[CellGroupData[{
Cell[102605, 3928, 80, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[102688, 3932, 92, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[102795, 3938, 3942, 121, 70, "DefinitionBox",
  CellTags->"S2.2.9"],
Cell[106740, 4061, 80, 1, 70, "Caption",
  CellTags->"S2.2.9"],
Cell[106823, 4064, 100, 1, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.12"}],

Cell[CellGroupData[{
Cell[106948, 4069, 87, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[107038, 4073, 114, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[107167, 4079, 174, 5, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.13"}],

Cell[CellGroupData[{
Cell[107366, 4088, 74, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[107443, 4092, 115, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[107573, 4098, 216, 9, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.14"}],

Cell[CellGroupData[{
Cell[107814, 4111, 95, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[107912, 4115, 107, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[108034, 4121, 164, 5, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.15"}],

Cell[CellGroupData[{
Cell[108223, 4130, 74, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[108300, 4134, 105, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]],
Cell[108420, 4140, 182, 5, 70, "MathCaption",
  CellTags->{"S2.2.9", "9.16"}],

Cell[CellGroupData[{
Cell[108627, 4149, 78, 2, 70, "Input",
  CellTags->"S2.2.9"],
Cell[108708, 4153, 116, 3, 70, "Output",
  CellTags->"S2.2.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[108873, 4162, 83, 1, 70, "Subsection",
  CellTags->{"S2.2.10", "10.1"}],
Cell[108959, 4165, 365, 7, 70, "Text",
  CellTags->{"S2.2.10", "10.2"}],
Cell[109327, 4174, 431, 10, 70, "Text",
  CellTags->{"S2.2.10", "10.3"}],
Cell[109761, 4186, 400, 11, 70, "Text",
  CellTags->{"S2.2.10", "10.4"}],
Cell[110164, 4199, 177, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.5"}],

Cell[CellGroupData[{
Cell[110366, 4208, 83, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[110452, 4212, 92, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[110559, 4218, 3821, 113, 70, "DefinitionBox",
  CellTags->"S2.2.10"],
Cell[114383, 4333, 62, 1, 70, "Caption",
  CellTags->"S2.2.10"],
Cell[114448, 4336, 232, 6, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.6"}],

Cell[CellGroupData[{
Cell[114705, 4346, 97, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[114805, 4350, 94, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[114914, 4356, 183, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.7"}],

Cell[CellGroupData[{
Cell[115122, 4365, 106, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[115231, 4369, 110, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[115356, 4375, 1995, 62, 70, "DefinitionBox",
  CellTags->"S2.2.10"],
Cell[117354, 4439, 70, 1, 70, "Caption",
  CellTags->"S2.2.10"],
Cell[117427, 4442, 144, 4, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.8"}],

Cell[CellGroupData[{
Cell[117596, 4450, 98, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[117697, 4454, 95, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[117807, 4460, 234, 6, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.9"}],

Cell[CellGroupData[{
Cell[118066, 4470, 106, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[118175, 4474, 100, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[118290, 4480, 298, 8, 70, "Text",
  CellTags->{"S2.2.10", "10.10"}],
Cell[118591, 4490, 3518, 117, 70, "DefinitionBox",
  CellTags->"S2.2.10"],
Cell[122112, 4609, 70, 1, 70, "Caption",
  CellTags->"S2.2.10"],
Cell[122185, 4612, 263, 11, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.11"}],

Cell[CellGroupData[{
Cell[122473, 4627, 87, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[122563, 4631, 93, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[122671, 4637, 93, 1, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.12"}],

Cell[CellGroupData[{
Cell[122789, 4642, 94, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[122886, 4646, 119, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[123020, 4652, 916, 35, 70, "Text",
  CellTags->{"S2.2.10", "10.13"}],
Cell[123939, 4689, 234, 8, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.14"}],

Cell[CellGroupData[{
Cell[124198, 4701, 90, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[124291, 4705, 107, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[124413, 4711, 178, 4, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.15"}],

Cell[CellGroupData[{
Cell[124616, 4719, 102, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[124721, 4723, 118, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[124854, 4729, 191, 6, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.16"}],

Cell[CellGroupData[{
Cell[125070, 4739, 106, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[125179, 4743, 119, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[125313, 4749, 366, 14, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.17"}],

Cell[CellGroupData[{
Cell[125704, 4767, 114, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[125821, 4771, 125, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[125961, 4777, 313, 10, 70, "Text",
  CellTags->{"S2.2.10", "10.18"}],
Cell[126277, 4789, 3315, 96, 70, "DefinitionBox",
  CellTags->"S2.2.10"],
Cell[129595, 4887, 79, 1, 70, "Caption",
  CellTags->"S2.2.10"],
Cell[129677, 4890, 103, 1, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.19"}],

Cell[CellGroupData[{
Cell[129805, 4895, 87, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[129895, 4899, 104, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[130014, 4905, 214, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.20"}],

Cell[CellGroupData[{
Cell[130253, 4914, 75, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[130331, 4918, 105, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[130451, 4924, 100, 1, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.21"}],

Cell[CellGroupData[{
Cell[130576, 4929, 103, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[130682, 4933, 117, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[130814, 4939, 565, 15, 70, "Text",
  CellTags->{"S2.2.10", "10.22"}],
Cell[131382, 4956, 219, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.23"}],

Cell[CellGroupData[{
Cell[131626, 4965, 80, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[131709, 4969, 107, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[131831, 4975, 155, 4, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.24"}],

Cell[CellGroupData[{
Cell[132011, 4983, 77, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[132091, 4987, 100, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[132206, 4993, 175, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.25"}],

Cell[CellGroupData[{
Cell[132406, 5002, 82, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[132491, 5006, 105, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[132611, 5012, 1736, 49, 70, "DefinitionBox",
  CellTags->"S2.2.10"],
Cell[134350, 5063, 80, 1, 70, "Caption",
  CellTags->"S2.2.10"],
Cell[134433, 5066, 1121, 41, 70, "Text",
  CellTags->{"S2.2.10", "10.26"}],
Cell[135557, 5109, 197, 6, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.27"}],

Cell[CellGroupData[{
Cell[135779, 5119, 93, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[135875, 5123, 143, 4, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[136033, 5130, 164, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.28"}],

Cell[CellGroupData[{
Cell[136222, 5139, 104, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[136329, 5143, 158, 4, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[136502, 5150, 170, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.29"}],

Cell[CellGroupData[{
Cell[136697, 5159, 94, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[136794, 5163, 126, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[136935, 5169, 393, 11, 70, "Text",
  CellTags->{"S2.2.10", "10.30"}],
Cell[137331, 5182, 137, 5, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.31"}],

Cell[CellGroupData[{
Cell[137493, 5191, 93, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[137589, 5195, 102, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]],
Cell[137706, 5201, 157, 6, 70, "MathCaption",
  CellTags->{"S2.2.10", "10.32"}],

Cell[CellGroupData[{
Cell[137888, 5211, 100, 2, 70, "Input",
  CellTags->"S2.2.10"],
Cell[137991, 5215, 94, 3, 70, "Output",
  CellTags->"S2.2.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[138134, 5224, 71, 1, 70, "Subsection",
  CellTags->{"S2.2.11", "11.1"}],
Cell[138208, 5227, 172, 5, 70, "MathCaption",
  CellTags->{"S2.2.11", "11.2"}],

Cell[CellGroupData[{
Cell[138405, 5236, 93, 2, 28, "Input",
  CellTags->"S2.2.11"],
Cell[138501, 5240, 97, 3, 70, "Output",
  CellTags->"S2.2.11"]
}, Open  ]],
Cell[138613, 5246, 168, 4, 40, "MathCaption",
  CellTags->{"S2.2.11", "11.3"}],

Cell[CellGroupData[{
Cell[138806, 5254, 98, 2, 28, "Input",
  CellTags->"S2.2.11"],
Cell[138907, 5258, 99, 3, 25, "Output",
  CellTags->"S2.2.11"]
}, Open  ]],
Cell[139021, 5264, 187, 5, 56, "MathCaption",
  CellTags->{"S2.2.11", "11.4"}],

Cell[CellGroupData[{
Cell[139233, 5273, 100, 2, 28, "Input",
  CellTags->"S2.2.11"],
Cell[139336, 5277, 97, 3, 25, "Output",
  CellTags->"S2.2.11"]
}, Open  ]],
Cell[139448, 5283, 1010, 31, 64, "DefinitionBox",
  CellTags->"S2.2.11"],
Cell[140461, 5316, 92, 1, 16, "Caption",
  CellTags->"S2.2.11"],
Cell[140556, 5319, 126, 4, 40, "MathCaption",
  CellTags->{"S2.2.11", "11.5"}],

Cell[CellGroupData[{
Cell[140707, 5327, 85, 2, 28, "Input",
  CellTags->"S2.2.11"],
Cell[140795, 5331, 92, 3, 25, "Output",
  CellTags->"S2.2.11"]
}, Open  ]],
Cell[140902, 5337, 106, 1, 40, "MathCaption",
  CellTags->{"S2.2.11", "11.6"}],

Cell[CellGroupData[{
Cell[141033, 5342, 84, 2, 28, "Input",
  CellTags->"S2.2.11"],
Cell[141120, 5346, 105, 3, 25, "Output",
  CellTags->"S2.2.11"]
}, Open  ]],
Cell[141240, 5352, 144, 5, 40, "MathCaption",
  CellTags->{"S2.2.11", "11.7"}],

Cell[CellGroupData[{
Cell[141409, 5361, 110, 2, 28, "Input",
  CellTags->"S2.2.11"],
Cell[141522, 5365, 106, 3, 25, "Output",
  CellTags->"S2.2.11"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

