(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    165101,       6217]*)
(*NotebookOutlinePosition[    234239,       8218]*)
(*  CellTagsIndexPosition[    228003,       7974]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.3 ", "HeadingNumber"],
  "Patterns"
}], "Section",
  CellTags->{"S2.3.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.3.1 Introduction", "Subsection",
  CellTags->{"S2.3.1", "1.1"}],

Cell[TextData[{
  "Patterns are used throughout ",
  StyleBox["Mathematica", "TI"],
  " to represent classes of expressions. A simple example of a pattern is the \
expression ",
  StyleBox["f[x_]", "MR"],
  ". This pattern represents the class of expressions with the form ",
  StyleBox["f[", "MR"],
  StyleBox["anything", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.1", "1.2"}],

Cell[TextData[{
  "The main power of patterns comes from the fact that many operations in ",
  StyleBox["Mathematica", "TI"],
  " can be done not only with single expressions, but also with patterns that \
represent whole classes of expressions. "
}], "Text",
  CellTags->{"S2.3.1", "1.3"}],

Cell["\<\
You can use patterns in transformation rules to specify how classes \
of expressions should be transformed. \
\>", "MathCaption",
  CellTags->{"S2.3.1", "1.4"}],

Cell[CellGroupData[{

Cell["f[a] + f[b] /. f[x_] -> x^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    \(a\^2 + b\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell["\<\
You can use patterns to find the positions of all expressions in a \
particular class. \
\>", "MathCaption",
  CellTags->{"S2.3.1", "1.5"}],

Cell[CellGroupData[{

Cell["Position[{f[a], g[b], f[c]}, f[x_]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    \({{1}, {3}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell[TextData[{
  "The basic object that appears in almost all ",
  StyleBox["Mathematica", "TI"],
  " patterns is ",
  StyleBox["_", "MR"],
  " (traditionally called \
\[OpenCurlyDoubleQuote]blank\[CloseCurlyDoubleQuote] by ",
  StyleBox["Mathematica", "TI"],
  " programmers). The fundamental rule is simply that ",
  StyleBox["_", "MR"],
  " ",
  StyleBox["stands for any expression", "TI"],
  ". On most keyboards the ",
  StyleBox["_", "MR"],
  " underscore character appears as the shifted version of the ",
  StyleBox["-", "MR"],
  " dash character. "
}], "Text",
  CellTags->{"S2.3.1", "1.6"}],

Cell[TextData[{
  "Thus, for example, the pattern ",
  StyleBox["f[_]", "MR"],
  " stands for any expression of the form ",
  StyleBox["f[", "MR"],
  StyleBox["anything", "TI"],
  StyleBox["]", "MR"],
  ". The pattern ",
  StyleBox["f[x_]", "MR"],
  " also stands for any expression of the form ",
  StyleBox["f[", "MR"],
  StyleBox["anything", "TI"],
  StyleBox["]", "MR"],
  ", but gives the name ",
  StyleBox["x", "MR"],
  " to the expression ",
  StyleBox["anything", "TI"],
  ", allowing you to refer to it on the right\[Hyphen]hand side of a \
transformation rule. "
}], "Text",
  CellTags->{"S2.3.1", "1.7"}],

Cell["\<\
You can put blanks anywhere in an expression. What you get is a \
pattern which matches all expressions that can be made by \
\[OpenCurlyDoubleQuote]filling in the blanks\[CloseCurlyDoubleQuote] in any \
way. \
\>", "Text",
  CellTags->{"S2.3.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f[n_]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "MR"],
              " with any argument, named ",
              StyleBox["n", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f[n_,", "MR"],
              " ",
              StyleBox["m_]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "MR"],
              " with two arguments, named ",
              StyleBox["n", "MR"],
              " and ",
              StyleBox["m", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x^n_", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "MR"],
              " to any power, with the power named ",
              StyleBox["n", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x_^n_", "MR"],
              " "
            }]], Cell["any expression to any power "]},
          {Cell[TextData[{
              StyleBox["a_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b_", "MR"],
              " "
            }]], Cell["a sum of two expressions "]},
          {Cell[TextData[{
              StyleBox["{a1_,", "MR"],
              " ",
              StyleBox["a2_}", "MR"],
              " "
            }]], Cell["a list of two expressions "]},
          {Cell[TextData[{
              StyleBox["f[n_,", "MR"],
              " ",
              StyleBox["n_]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "MR"],
              " with two ",
              StyleBox["identical", "TI"],
              " arguments "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.1"],

Cell["Some examples of patterns. ", "Caption",
  CellTags->"S2.3.1"],

Cell["\<\
You can construct patterns for expressions with any structure. \
\
\>", "MathCaption",
  CellTags->{"S2.3.1", "1.9"}],

Cell[CellGroupData[{

Cell["f[{a, b}] + f[c] /. f[{x_, y_}] -> p[x + y]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    \(f[c] + p[a + b]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell[TextData[{
  "One of the most common uses of patterns is for \
\[OpenCurlyDoubleQuote]destructuring\[CloseCurlyDoubleQuote] function \
arguments. If you make a definition for ",
  StyleBox["f[list_]", "MR"],
  ", then you need to use functions like ",
  StyleBox["Part", "MR"],
  " explicitly in order to pick out elements of the list. But if you know for \
example that the list will always have two elements, then it is usually much \
more convenient instead to give a definition instead for ",
  StyleBox["f[{x_,", "MR"],
  " ",
  StyleBox["y_}]", "MR"],
  ". Then you can refer to the elements of the list directly as ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". In addition, ",
  StyleBox["Mathematica", "TI"],
  " will not use the definition you have given unless the argument of ",
  StyleBox["f", "MR"],
  " really is of the required form of a list of two expressions. "
}], "Text",
  CellTags->{"S2.3.1", "1.10"}],

Cell["\<\
Here is one way to define a function which takes a list of two \
elements, and evaluates the first element raised to the power of the second \
element. \
\>", "MathCaption",
  CellTags->{"S2.3.1", "1.11"}],

Cell["g[list_] := Part[list, 1] ^ Part[list, 2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.1"],

Cell["\<\
Here is a much more elegant way to make the definition, using a \
pattern. \
\>", "MathCaption",
  CellTags->{"S2.3.1", "1.12"}],

Cell["h[{x_, y_}] := x ^ y", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.1"],

Cell[TextData[{
  "A crucial point to understand is that ",
  StyleBox["Mathematica", "TI"],
  " patterns represent classes of expressions with a given ",
  StyleBox["structure", "TI"],
  ". One pattern will match a particular expression if the structure of the \
pattern is the same as the structure of the expression, in the sense that by \
filling in blanks in the pattern you can get the expression. Even though two \
expressions may be ",
  StyleBox["mathematically equal", "TI"],
  ", they cannot be represented by the same ",
  StyleBox["Mathematica", "TI"],
  " pattern unless they have the same structure. "
}], "Text",
  CellTags->{"S2.3.1", "1.13"}],

Cell[TextData[{
  "Thus, for example, the pattern ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x_)^2", "MR"],
  " can stand for expressions like ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a)^2", "MR"],
  " or ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b^3)^2", "MR"],
  " that have the same ",
  StyleBox["structure", "TI"],
  ". However, it cannot stand for the expression ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a^2", "MR"],
  ". Although this expression is ",
  StyleBox["mathematically equal", "TI"],
  " to ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a)^2", "MR"],
  ", it does not have the same ",
  StyleBox["structure", "TI"],
  " as the pattern ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x_)^2", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.1", "1.14"}],

Cell[TextData[{
  "The fact that patterns in ",
  StyleBox["Mathematica", "TI"],
  " specify the ",
  StyleBox["structure", "TI"],
  " of expressions is crucial in making it possible to set up transformation \
rules which change the ",
  StyleBox["structure", "TI"],
  " of expressions, while leaving them mathematically equal. "
}], "Text",
  CellTags->{"S2.3.1", "1.15"}],

Cell[TextData[{
  "It is worth realizing that in general it would be quite impossible for ",
  StyleBox["Mathematica", "TI"],
  " to match patterns by mathematical, rather than structural, equivalence. \
In the case of expressions like ",
  StyleBox["(1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a)^2", "MR"],
  " and ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a^2", "MR"],
  ", you can determine equivalence just by using functions like ",
  StyleBox["Expand", "MR"],
  " and ",
  StyleBox["Factor", "MR"],
  ". But, as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.6.2",
    ButtonData:>{"2.6.2", "2.18"},
    ButtonStyle->"MainBookLink"],
  " there is no general way to find out whether an arbitrary pair of \
mathematical expressions are equal. "
}], "Text",
  CellTags->{"S2.3.1", "1.16"}],

Cell[TextData[{
  "As another example, the pattern ",
  StyleBox["x^_", "MR"],
  " will match the expression ",
  StyleBox["x^2", "MR"],
  ". It will not, however, match the expression ",
  StyleBox["1", "MR"],
  ", even though this could be considered as ",
  StyleBox["x^0", "MR"],
  ". Section ",
  ButtonBox["2.3.9",
    ButtonData:>{"2.3.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how to construct a pattern for which this particular case \
will match. But you should understand that in all cases pattern matching in \
",
  StyleBox["Mathematica", "TI"],
  " is fundamentally structural. "
}], "Text",
  CellTags->{"S2.3.1", "1.17"}],

Cell[TextData[{
  "The ",
  StyleBox["x^n_", "MR"],
  " matches only ",
  StyleBox["x^2", "MR"],
  " and ",
  StyleBox["x^3", "MR"],
  ". ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["x", "MR"],
  " can mathematically be written as ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ", but do not have the same structure."
}], "MathCaption",
  CellTags->{"S2.3.1", "1.18"}],

Cell[CellGroupData[{

Cell["{1, x, x^2, x^3} /. x^n_ -> r[n]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    \({1, x, r[2], r[3]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell[TextData[{
  "Another point to realize is that the structure ",
  StyleBox["Mathematica", "TI"],
  " uses in pattern matching is the full form of expressions printed by ",
  StyleBox["FullForm", "MR"],
  ". Thus, for example, an object such as ",
  StyleBox["1/x", "MR"],
  ", whose full form is ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["-1]", "MR"],
  " will be matched by the pattern ",
  StyleBox["x_^n_", "MR"],
  ", but not by the pattern ",
  StyleBox["x_/y_", "MR"],
  ", whose full form is ",
  StyleBox["Times[x_,", "MR"],
  " ",
  StyleBox["Power[y_,", "MR"],
  " ",
  StyleBox["-1]]", "MR"],
  ". Again, Section ",
  ButtonBox["2.3.9",
    ButtonData:>{"2.3.9", "9.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how you can construct patterns which can match all these \
cases. "
}], "Text",
  CellTags->{"S2.3.1", "1.19"}],

Cell[TextData[{
  "The expressions in the list contain explicit powers of ",
  StyleBox["b", "MR"],
  ", so the transformation rule can be applied. "
}], "MathCaption",
  CellTags->{"S2.3.1", "1.20"}],

Cell[CellGroupData[{

Cell["{a/b, 1/b^2, 2/b^2} /. b^n_ -> d[n]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    \({a\ d[\(-1\)], d[\(-2\)], 2\ d[\(-2\)]}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell["Here is the full form of the list. ", "MathCaption",
  CellTags->{"S2.3.1", "1.21"}],

Cell[CellGroupData[{

Cell["FullForm[{a/b, 1/b^2, 2/b^2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[Times[a, Power[b, \(-1\)]], Power[b, \(-2\)], 
          Times[2, Power[b, \(-2\)]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[8]//FullForm= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell[TextData[{
  "Although ",
  StyleBox["Mathematica", "TI"],
  " does not use mathematical equivalences such as ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "1"], "=", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " when matching patterns, it does use certain structural equivalences. \
Thus, for example, ",
  StyleBox["Mathematica", "TI"],
  " takes account of properties such as commutativity and associativity in \
pattern matching. "
}], "Text",
  CellTags->{"S2.3.1", "1.22"}],

Cell[TextData[{
  "To apply this transformation rule, ",
  StyleBox["Mathematica", "TI"],
  " makes use of the commutativity and associativity of addition. "
}], "MathCaption",
  CellTags->{"S2.3.1", "1.23"}],

Cell[CellGroupData[{

Cell["\<\
f[a + b] + f[a + c] + f[b + d] /. f[a + x_] + f[c + y_] -> p[x, \
y]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.1"],

Cell[BoxData[
    \(f[b + d] + p[b, a]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.3.1"]
}, Open  ]],

Cell[TextData[{
  "The discussion so far has considered only pattern objects such as ",
  StyleBox["x_", "MR"],
  " which can stand for any single expression. In later subsections, we \
discuss the constructs that ",
  StyleBox["Mathematica", "TI"],
  " uses to extend and restrict the classes of expressions represented by \
patterns. "
}], "Text",
  CellTags->{"S2.3.1", "1.24"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.2 Finding Expressions That Match a Pattern", "Subsection",
  CellTags->{"S2.3.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cases[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the elements of ",
              StyleBox["list", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Count[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the number of elements in ",
              StyleBox["list", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Position[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{1}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the positions of elements in ",
              StyleBox["list", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Select[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the elements of ",
              StyleBox["list", "TI"],
              " on which ",
              StyleBox["test", "TI"],
              " gives ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Pick[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the elements of ",
              StyleBox["list", "TI"],
              " for which the corresponding elements of ",
              StyleBox["sel", "TI"],
              " match ",
              StyleBox["form", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Finding elements that match a pattern. ", "Caption",
  CellTags->"S2.3.2"],

Cell[TextData[{
  "This gives the elements of the list which match the pattern ",
  StyleBox["x^_", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.2"}],

Cell[CellGroupData[{

Cell["Cases[ {3, 4, x, x^2, x^3}, x^_ ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({x\^2, x\^3}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell["\<\
Here is the total number of elements which match the pattern. \
\
\>", "MathCaption",
  CellTags->{"S2.3.2", "2.3"}],

Cell[CellGroupData[{

Cell["Count[ {3, 4, x, x^2, x^3}, x^_ ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[TextData[{
  "You can apply functions like ",
  StyleBox["Cases", "MR"],
  " not only to lists, but to expressions of any kind. In addition, you can \
specify the level of parts at which you want to look. "
}], "Text",
  CellTags->{"S2.3.2", "2.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cases[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              StyleBox["->", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find elements of ",
              StyleBox["expr", "TI"],
              " that match ",
              StyleBox["lhs", "TI"],
              
              ", and give a list of the results of applying the \
transformation rule to them "
            }]]},
          {Cell[TextData[{
              StyleBox["Cases[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              StyleBox["->", "MR"],
              StyleBox["rhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test parts of ",
              StyleBox["expr", "TI"],
              " at levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Count[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the total number of parts that match ",
              StyleBox["form", "TI"],
              " at levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Position[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the positions of parts that match ",
              StyleBox["form", "TI"],
              " at levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Searching for parts of expressions that match a pattern. ", "Caption",
  CellTags->"S2.3.2"],

Cell[TextData[{
  "This returns a list of the exponents ",
  StyleBox["n", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.5"}],

Cell[CellGroupData[{

Cell["Cases[ {3, 4, x, x^2, x^3}, x^n_ -> n]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({2, 3}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[TextData[{
  "The pattern ",
  StyleBox["_Integer", "MR"],
  " matches any integer. This gives a list of integers appearing at any \
level. "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.6"}],

Cell[CellGroupData[{

Cell["Cases[ {3, 4, x, x^2, x^3}, _Integer, Infinity]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({3, 4, 2, 3}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cases[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find only the first ",
              StyleBox["n", "TI"],
              " parts that match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Position[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the positions of the first ",
              StyleBox["n", "TI"],
              " parts that match ",
              StyleBox["form", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Limiting the number of parts to search for. ", "Caption",
  CellTags->"S2.3.2"],

Cell[TextData[{
  "This gives the positions of the first two powers of ",
  StyleBox["x", "MR"],
  " appearing at any level. "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.7"}],

Cell[CellGroupData[{

Cell["Position[ {4, 4 + x^a, x^b, 6 + x^5}, x^_, Infinity, 2]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({{2, 2}, {3}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[TextData[{
  "The positions are specified in exactly the form used by functions such as \
",
  StyleBox["Extract", "MR"],
  " and ",
  StyleBox["ReplacePart", "MR"],
  " discussed in Section ",
  ButtonBox["1.8",
    ButtonData:>{"1.8"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.8"}],

Cell[CellGroupData[{

Cell["ReplacePart[ {4, 4 + x^a, x^b, 6 + x^5}, zzz, % ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({4, 4 + zzz, zzz, 6 + x\^5}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DeleteCases[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "delete elements of ",
              StyleBox["expr", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DeleteCases[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lev", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "delete parts of ",
              StyleBox["expr", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              " at levels specified by ",
              StyleBox["lev", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Deleting parts of expressions that match a pattern. ", "Caption",
  CellTags->"S2.3.2"],

Cell[TextData[{
  "This deletes the elements which match ",
  StyleBox["x^n_", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.9"}],

Cell[CellGroupData[{

Cell["DeleteCases[ {3, 4, x, x^2, x^3}, x^n_ ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({3, 4, x}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell["This deletes all integers appearing at any level. ", "MathCaption",
  CellTags->{"S2.3.2", "2.10"}],

Cell[CellGroupData[{

Cell["DeleteCases[ {3, 4, x, 2+x, 3+x}, _Integer, Infinity ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({x, x, x}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReplaceList[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find all ways that ",
              StyleBox["expr", "TI"],
              " can match ",
              StyleBox["lhs", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.2"],

Cell["Finding arrangements of an expression that match a pattern. ", "Caption",
  CellTags->"S2.3.2"],

Cell["\<\
This finds all ways that the sum can be written in two parts. \
\
\>", "MathCaption",
  CellTags->{"S2.3.2", "2.11"}],

Cell[CellGroupData[{

Cell["ReplaceList[a + b + c, x_ + y_ -> g[x, y]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({g[a, b + c], g[b, a + c], g[c, a + b], g[a + b, c], g[a + c, b], 
      g[b + c, a]}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.3.2"]
}, Open  ]],

Cell[TextData[{
  "This finds all pairs of identical elements. The pattern ",
  StyleBox["___", "MR"],
  " stands for any sequence of elements. "
}], "MathCaption",
  CellTags->{"S2.3.2", "2.12"}],

Cell[CellGroupData[{

Cell["ReplaceList[{a, b, b, b, c, c, a}, {___, x_, x_, ___} -> x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.3.2"],

Cell[BoxData[
    \({b, b, c}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.3.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.3 Naming Pieces of Patterns", "Subsection",
  CellTags->{"S2.3.3", "3.1"}],

Cell[TextData[{
  "Particularly when you use transformation rules, you often need to name \
pieces of patterns. An object like ",
  StyleBox["x", "TI"],
  StyleBox["_", "MR"],
  " stands for any expression, but gives the expression the name ",
  StyleBox["x", "TI"],
  ". You can then, for example, use this name on the right\[Hyphen]hand side \
of a transformation rule. "
}], "Text",
  CellTags->{"S2.3.3", "3.2"}],

Cell[TextData[{
  "An important point is that when you use ",
  StyleBox["x", "TI"],
  StyleBox["_", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " requires that all occurrences of blanks with the same name ",
  StyleBox["x", "TI"],
  " in a particular expression must stand for the same expression. "
}], "Text",
  CellTags->{"S2.3.3", "3.3"}],

Cell[TextData[{
  "Thus ",
  StyleBox["f[x_,", "MR"],
  " ",
  StyleBox["x_]", "MR"],
  " can only stand for expressions in which the two arguments of ",
  StyleBox["f", "MR"],
  " are exactly the same. ",
  StyleBox["f[_,", "MR"],
  " ",
  StyleBox["_]", "MR"],
  ", on the other hand, can stand for any expression of the form ",
  StyleBox["f[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", where ",
  StyleBox["x", "TI"],
  " and ",
  StyleBox["y", "TI"],
  " need not be the same. "
}], "Text",
  CellTags->{"S2.3.3", "3.4"}],

Cell[TextData[{
  "The transformation rule applies only to cases where the two arguments of \
",
  StyleBox["f", "MR"],
  " are identical. "
}], "MathCaption",
  CellTags->{"S2.3.3", "3.5"}],

Cell[CellGroupData[{

Cell["{f[a, a], f[a, b]} /. f[x_, x_] -> p[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.3"],

Cell[BoxData[
    \({p[a], f[a, b]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to give names not just to single blanks, but to any piece of a \
pattern. The object ",
  StyleBox["x", "TI"],
  StyleBox[":", "MR"],
  StyleBox["pattern", "TI"],
  " in general represents a pattern which is assigned the name ",
  StyleBox["x", "TI"],
  ". In transformation rules, you can use this mechanism to name exactly \
those pieces of a pattern that you need to refer to on the right\[Hyphen]hand \
side of the rule. "
}], "Text",
  CellTags->{"S2.3.3", "3.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["_", "MR"],
              " "
            }]], Cell["any expression "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              "any expression, to be named ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox[":", "MR"],
              StyleBox["pattern", "TI"],
              " "
            }]], Cell[TextData[{
              "an expression to be named ",
              StyleBox["x", "TI"],
              ", matching ",
              StyleBox["pattern", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.3"],

Cell["Patterns with names. ", "Caption",
  CellTags->"S2.3.3"],

Cell[TextData[{
  "This gives a name to the complete form ",
  StyleBox["_^_", "MR"],
  " so you can refer to it as a whole on the right\[Hyphen]hand side of the \
transformation rule. "
}], "MathCaption",
  CellTags->{"S2.3.3", "3.7"}],

Cell[CellGroupData[{

Cell["f[a^b] /. f[x:_^_] -> p[x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.3"],

Cell[BoxData[
    \(p[a\^b]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.3"]
}, Open  ]],

Cell[TextData[{
  "Here the exponent is named ",
  StyleBox["n", "MR"],
  ", while the whole object is ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.3", "3.8"}],

Cell[CellGroupData[{

Cell["f[a^b] /. f[x:_^n_] -> p[x, n]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.3"],

Cell[BoxData[
    \(p[a\^b, b]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.3"]
}, Open  ]],

Cell["\<\
When you give the same name to two pieces of a pattern, you \
constrain the pattern to match only those expressions in which the \
corresponding pieces are identical. \
\>", "Text",
  CellTags->{"S2.3.3", "3.9"}],

Cell["Here the pattern matches both cases. ", "MathCaption",
  CellTags->{"S2.3.3", "3.10"}],

Cell[CellGroupData[{

Cell["{f[h[4], h[4]], f[h[4], h[5]]} /. f[h[_], h[_]] -> q", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.3"],

Cell[BoxData[
    \({q, q}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.3"]
}, Open  ]],

Cell[TextData[{
  "Now both arguments of ",
  StyleBox["f", "MR"],
  " are constrained to be the same, and only the first case matches. "
}], "MathCaption",
  CellTags->{"S2.3.3", "3.11"}],

Cell[CellGroupData[{

Cell["{f[h[4], h[4]], f[h[4], h[5]]} /. f[x:h[_], x_] -> r[x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.3"],

Cell[BoxData[
    \({r[h[4]], f[h[4], h[5]]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.4 Specifying Types of Expression in Patterns", "Subsection",
  CellTags->{"S2.3.4", "4.1"}],

Cell[TextData[{
  "You can tell a lot about what \[OpenCurlyDoubleQuote]type\
\[CloseCurlyDoubleQuote] of expression something is by looking at its head. \
Thus, for example, an integer has head ",
  StyleBox["Integer", "MR"],
  ", while a list has head ",
  StyleBox["List", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.4", "4.2"}],

Cell[TextData[{
  "In a pattern, ",
  StyleBox["_", "MR"],
  StyleBox["h", "TI"],
  " and ",
  StyleBox["x", "TI"],
  StyleBox["_", "MR"],
  StyleBox["h", "TI"],
  " represent expressions that are constrained to have head ",
  StyleBox["h", "TI"],
  ". Thus, for example, ",
  StyleBox["_Integer", "MR"],
  " represents any integer, while ",
  StyleBox["_List", "MR"],
  " represents any list. "
}], "Text",
  CellTags->{"S2.3.4", "4.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              "an expression with head ",
              StyleBox["h", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_Integer", "MR"],
              " "
            }]], Cell["an integer "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_Real", "MR"],
              " "
            }]], Cell["an approximate real number "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_Complex", "MR"],
              " "
            }]], Cell["a complex number "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_List", "MR"],
              " "
            }]], Cell["a list "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_Symbol", "MR"],
              " "
            }]], Cell["a symbol "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.4"],

Cell["Patterns for objects with specified heads. ", "Caption",
  CellTags->"S2.3.4"],

Cell["This replaces just those elements that are integers. ", "MathCaption",
  CellTags->{"S2.3.4", "4.4"}],

Cell[CellGroupData[{

Cell["{a, 4, 5, b} /. x_Integer -> p[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.4"],

Cell[BoxData[
    \({a, p[4], p[5], b}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.4"]
}, Open  ]],

Cell[TextData[{
  "You can think of making an assignment for ",
  StyleBox["f[x_Integer]", "MR"],
  " as like defining a function ",
  StyleBox["f", "MR"],
  " that must take an argument of \[OpenCurlyDoubleQuote]type\
\[CloseCurlyDoubleQuote] ",
  StyleBox["Integer", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.4", "4.5"}],

Cell[TextData[{
  "This defines a value for the function ",
  StyleBox["gamma", "MR"],
  " when its argument is an integer. "
}], "MathCaption",
  CellTags->{"S2.3.4", "4.6"}],

Cell["gamma[n_Integer] := (n - 1)!", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.4"],

Cell[TextData[{
  "The definition applies only when the argument of ",
  StyleBox["gamma", "MR"],
  " is an integer. "
}], "MathCaption",
  CellTags->{"S2.3.4", "4.7"}],

Cell[CellGroupData[{

Cell["gamma[4] + gamma[x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.4"],

Cell[BoxData[
    \(6 + gamma[x]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.4"]
}, Open  ]],

Cell[TextData[{
  "The object ",
  StyleBox["4.", "MR"],
  " has head ",
  StyleBox["Real", "MR"],
  ", so the definition does not apply. "
}], "MathCaption",
  CellTags->{"S2.3.4", "4.8"}],

Cell[CellGroupData[{

Cell["gamma[4.]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.4"],

Cell[BoxData[
    \(gamma[4.`]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.4"]
}, Open  ]],

Cell["This defines values for expressions with integer exponents. ", \
"MathCaption",
  CellTags->{"S2.3.4", "4.9"}],

Cell["d[x_^n_Integer] := n x^(n-1)", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.4"],

Cell["\<\
The definition is used only when the exponent is an integer. \
\>", \
"MathCaption",
  CellTags->{"S2.3.4", "4.10"}],

Cell[CellGroupData[{

Cell["d[x^4] + d[(a+b)^3] + d[x^(1/2)]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.4"],

Cell[BoxData[
    \(3\ \((a + b)\)\^2 + 4\ x\^3 + d[\@x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.5 Putting Constraints on Patterns", "Subsection",
  CellTags->{"S2.3.5", "5.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides a general mechanism for specifying constraints on patterns. All \
you need do is to put ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["condition", "TI"],
  " at the end of a pattern to signify that it applies only when the \
specified condition is ",
  StyleBox["True", "MR"],
  ". You can read the operator ",
  StyleBox["/;", "MR"],
  " as \[OpenCurlyDoubleQuote]slash\[Hyphen]semi\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]whenever\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]provided that\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.3.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["condition", "TI"],
              " "
            }]], Cell[
            "a pattern that matches only when a condition is satisfied "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["condition", "TI"],
              " "
            }]], Cell[
            "a rule that applies only when a condition is satisfied "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["condition", "TI"],
              " "
            }]], 
            Cell["\<\
a definition that applies only when a condition is \
satisfied \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.5"],

Cell["Putting conditions on patterns and transformation rules. ", "Caption",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "This gives a definition for ",
  StyleBox["fac", "MR"],
  " that applies only when its argument ",
  StyleBox["n", "MR"],
  " is positive. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.3"}],

Cell["fac[n_ /; n > 0] := n!", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "The definition for ",
  StyleBox["fac", "MR"],
  " is used only when the argument is positive. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.4"}],

Cell[CellGroupData[{

Cell["fac[6] + fac[-4]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(720 + fac[\(-4\)]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell["This gives the negative elements in the list. ", "MathCaption",
  CellTags->{"S2.3.5", "5.5"}],

Cell[CellGroupData[{

Cell["Cases[{3, -4, 5, -2}, x_ /; x < 0]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({\(-4\), \(-2\)}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["/;", "MR"],
  " on whole definitions and transformation rules, as well as on individual \
patterns. In general, you can put ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["condition", "TI"],
  " at the end of any ",
  StyleBox[":=", "MR"],
  " definition or ",
  StyleBox[":>", "MR"],
  " rule to tell ",
  StyleBox["Mathematica", "TI"],
  " that the definition or rule applies only when the specified condition \
holds. Note that ",
  StyleBox["/;", "MR"],
  " conditions should not usually be put at the end of ",
  StyleBox["=", "MR"],
  " definitions or ",
  StyleBox["->", "MR"],
  " rules, since they will then be evaluated immediately, as discussed in \
Section ",
  ButtonBox["2.5.8",
    ButtonData:>{"2.5.8", "8.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.3.5", "5.6"}],

Cell[TextData[{
  "Here is another way to give a definition which applies only when its \
argument ",
  StyleBox["n", "MR"],
  " is positive. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.7"}],

Cell["fac2[n_] := n! /; n > 0", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.5"],

Cell["\<\
Once again, the factorial functions evaluate only when their \
arguments are positive. \
\>", "MathCaption",
  CellTags->{"S2.3.5", "5.8"}],

Cell[CellGroupData[{

Cell["fac2[6] + fac2[-4]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(720 + fac2[\(-4\)]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "You can use the ",
  StyleBox["/;", "MR"],
  " operator to implement arbitrary mathematical constraints on the \
applicability of rules. In typical cases, you give patterns which ",
  StyleBox["structurally", "TI"],
  " match a wide range of expressions, but then use ",
  StyleBox["mathematical", "TI"],
  " constraints to reduce the range of expressions to a much smaller set. "
}], "Text",
  CellTags->{"S2.3.5", "5.9"}],

Cell[TextData[{
  "This rule applies only to expressions that have the structure ",
  StyleBox["v[x_,", "MR"],
  " ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["x_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.10"}],

Cell["v[x_, 1 - x_] := p[x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.5"],

Cell["\<\
This expression has the appropriate structure, so the rule applies. \
\
\>", "MathCaption",
  CellTags->{"S2.3.5", "5.11"}],

Cell[CellGroupData[{

Cell["v[a^2, 1 - a^2]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(p[a\^2]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell["\<\
This expression, while mathematically of the correct form, does not \
have the appropriate structure, so the rule does not apply. \
\>", \
"MathCaption",
  CellTags->{"S2.3.5", "5.12"}],

Cell[CellGroupData[{

Cell["v[4, -3]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(v[4, \(-3\)]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "This rule applies to any expression of the form ",
  StyleBox["w[x_,", "MR"],
  " ",
  StyleBox["y_]", "MR"],
  ", with the added restriction that ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.13"}],

Cell["w[x_, y_] := p[x] /; y == 1 - x", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.5"],

Cell["The new rule does apply to this expression. ", "MathCaption",
  CellTags->{"S2.3.5", "5.14"}],

Cell[CellGroupData[{

Cell["w[4, -3]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(p[4]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "In setting up patterns and transformation rules, there is often a choice \
of where to put ",
  StyleBox["/;", "MR"],
  " conditions. For example, you can put a ",
  StyleBox["/;", "MR"],
  " condition on the right\[Hyphen]hand side of a rule in the form ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox[":>", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["condition", "TI"],
  ", or you can put it on the left\[Hyphen]hand side in the form ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["condition", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ". You may also be able to insert the condition inside the expression ",
  StyleBox["lhs", "TI"],
  ". The only constraint is that all the names of patterns that you use in a \
particular condition must appear in the pattern to which the condition is \
attached. If this is not the case, then some of the names needed to evaluate \
the condition may not yet have been \[OpenCurlyDoubleQuote]bound\
\[CloseCurlyDoubleQuote] in the pattern\[Hyphen]matching process. If this \
happens, then ",
  StyleBox["Mathematica", "TI"],
  " uses the global values for the corresponding variables, rather than the \
values determined by pattern matching. "
}], "Text",
  CellTags->{"S2.3.5", "5.15"}],

Cell[TextData[{
  "Thus, for example, the condition in ",
  StyleBox["f[x_,", "MR"],
  " ",
  StyleBox["y_]", "MR"],
  " ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["(x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["2)", "MR"],
  " will use values for ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " that are found by matching ",
  StyleBox["f[x_,", "MR"],
  " ",
  StyleBox["y_]", "MR"],
  ", but the condition in ",
  StyleBox["f[x_", "MR"],
  " ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["2,", "MR"],
  " ",
  StyleBox["y_]", "MR"],
  " will use the global value for ",
  StyleBox["y", "MR"],
  ", rather than the one found by matching the pattern. "
}], "Text",
  CellTags->{"S2.3.5", "5.16"}],

Cell[TextData[{
  "As long as you make sure that the appropriate names are defined, it is \
usually most efficient to put ",
  StyleBox["/;", "MR"],
  " conditions on the smallest possible parts of patterns. The reason for \
this is that ",
  StyleBox["Mathematica", "TI"],
  " matches pieces of patterns sequentially, and the sooner it finds a ",
  StyleBox["/;", "MR"],
  " condition which fails, the sooner it can reject a match. "
}], "Text",
  CellTags->{"S2.3.5", "5.17"}],

Cell[TextData[{
  "Putting the ",
  StyleBox["/;", "MR"],
  " condition around the ",
  StyleBox["x_", "MR"],
  " is slightly more efficient than putting it around the whole pattern. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.18"}],

Cell[CellGroupData[{

Cell["Cases[{z[1, 1], z[-1, 1], z[-2, 2]}, z[x_ /; x < 0, y_]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({z[\(-1\), 1], z[\(-2\), 2]}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "You need to put parentheses around the ",
  StyleBox["/;", "MR"],
  " piece in a case like this. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.19"}],

Cell[CellGroupData[{

Cell["{1 + a, 2 + a, -3 + a} /. (x_ /; x < 0) + a -> p[x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({1 + a, 2 + a, p[\(-3\)]}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "It is common to use ",
  StyleBox["/;", "MR"],
  " to set up patterns and transformation rules that apply only to \
expressions with certain properties. There is a collection of functions built \
into ",
  StyleBox["Mathematica", "TI"],
  " for testing the properties of expressions. It is a convention that \
functions of this kind have names that end with the letter ",
  StyleBox["Q", "MR"],
  ", indicating that they \[OpenCurlyDoubleQuote]ask a question\
\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.3.5", "5.20"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["IntegerQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["integer "]},
          {Cell[TextData[{
              StyleBox["EvenQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["even number "]},
          {Cell[TextData[{
              StyleBox["OddQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["odd number "]},
          {Cell[TextData[{
              StyleBox["PrimeQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["prime number "]},
          {Cell[TextData[{
              StyleBox["NumberQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["explicit number of any kind "]},
          {Cell[TextData[{
              StyleBox["NumericQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["numeric quantity "]},
          {Cell[TextData[{
              StyleBox["PolynomialQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "polynomial in ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\` ... \)], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["VectorQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a list representing a vector "]},
          {Cell[TextData[{
              StyleBox["MatrixQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a list of lists representing a matrix "]},
          {Cell[TextData[{
              StyleBox["VectorQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumericQ]", "MR"],
              ",  ",
              StyleBox["MatrixQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumericQ]", "MR"],
              " "
            }]], Cell[
            "vectors and matrices where all elements are numeric "]},
          {Cell[TextData[{
              StyleBox["VectorQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["MatrixQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "vectors and matrices for which the function ",
              StyleBox["test", "TI"],
              " yields ",
              StyleBox["True", "MR"],
              " on every element "
            }]]},
          {Cell[TextData[{
              StyleBox["ArrayQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "full array with depth matching ",
              StyleBox["d", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.5"],

Cell["\<\
Some functions for testing mathematical properties of expressions. \
\
\>", "Caption",
  CellTags->"S2.3.5"],

Cell["\<\
The rule applies to all elements of the list that are numbers. \
\
\>", "MathCaption",
  CellTags->{"S2.3.5", "5.21"}],

Cell[CellGroupData[{

Cell["{2.3, 4, 7/8, a, b} /. (x_ /; NumberQ[x]) -> x^2", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({5.289999999999999`, 16, 49\/64, a, b}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell["This definition applies only to vectors of integers. ", "MathCaption",
  CellTags->{"S2.3.5", "5.22"}],

Cell["mi[list_] := list^2 /; VectorQ[list, IntegerQ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.3.5"],

Cell["The definition is now used only in the first case. ", "MathCaption",
  CellTags->{"S2.3.5", "5.23"}],

Cell[CellGroupData[{

Cell["{mi[{2, 3}], mi[{2.1, 2.2}], mi[{a, b}]}", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({{4, 9}, mi[{2.1`, 2.2`}], mi[{a, b}]}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "An important feature of all the ",
  StyleBox["Mathematica", "TI"],
  " property\[Hyphen]testing functions whose names end in ",
  StyleBox["Q", "MR"],
  " is that they always return ",
  StyleBox["False", "MR"],
  " if they cannot determine whether the expression you give has a particular \
property. "
}], "Text",
  CellTags->{"S2.3.5", "5.24"}],

Cell[TextData[{
  StyleBox["4561", "MR"],
  " is an integer, so this returns ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.25"}],

Cell[CellGroupData[{

Cell["IntegerQ[4561]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "This returns ",
  StyleBox["False", "MR"],
  ", since ",
  StyleBox["x", "MR"],
  " is not known to be an integer. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.26"}],

Cell[CellGroupData[{

Cell["IntegerQ[x]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "In some cases, you can explicitly specify the results that property\
\[Hyphen]testing functions should give. Thus, with a definition such as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["/:", "MR"],
  " ",
  StyleBox["IntegerQ[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", as discussed in Section ",
  ButtonBox["2.5.10",
    ButtonData:>{"2.5.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will assume that ",
  StyleBox["x", "TI"],
  " is an integer. This means that if you explicitly ask for ",
  StyleBox["IntegerQ[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", you will now get ",
  StyleBox["True", "MR"],
  ", rather than ",
  StyleBox["False", "MR"],
  ". However, ",
  StyleBox["Mathematica", "TI"],
  " does not automatically propagate assertions, so it cannot determine for \
example that ",
  StyleBox["IntegerQ[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["^2]", "MR"],
  " is ",
  StyleBox["True", "MR"],
  ". You must load an appropriate ",
  StyleBox["Mathematica", "TI"],
  " package to make this possible. "
}], "Text",
  CellTags->{"S2.3.5", "5.27"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SameQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["x", "TI"],
              " ",
              StyleBox["===", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " are identical "
            }]]},
          {Cell[TextData[{
              StyleBox["UnsameQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["x", "TI"],
              " ",
              StyleBox["=!=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " are not identical "
            }]]},
          {Cell[TextData[{
              StyleBox["OrderedQ[{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["a", "TI"],
              ", ",
              StyleBox["b", "TI"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\` ... \)], "InlineFormula"],
              " are in standard order "
            }]]},
          {Cell[TextData[{
              StyleBox["MemberQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["form", "TI"],
              " matches an element of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FreeQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["form", "TI"],
              " matches nothing in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MatchQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["expr", "TI"],
              " matches the pattern ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ValueQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a value has been defined for ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["AtomQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["expr", "TI"],
              " has no subexpressions "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.5"],

Cell["\<\
Some functions for testing structural properties of expressions. \
\
\>", "Caption",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "With ",
  StyleBox["==", "MR"],
  ", the equation remains in symbolic form; ",
  StyleBox["===", "MR"],
  " yields ",
  StyleBox["False", "MR"],
  " unless the expressions are manifestly equal. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.28"}],

Cell[CellGroupData[{

Cell["{x == y, x === y}", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({x \[Equal] y, False}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "The expression ",
  StyleBox["n", "MR"],
  " is not a ",
  StyleBox["member", "TI"],
  " of the list ",
  StyleBox["{x,", "MR"],
  " ",
  StyleBox["x^n}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.29"}],

Cell[CellGroupData[{

Cell["MemberQ[{x, x^n}, n]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "However, ",
  StyleBox["{x,", "MR"],
  " ",
  StyleBox["x^n}", "MR"],
  " is not completely free of ",
  StyleBox["n", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.30"}],

Cell[CellGroupData[{

Cell["FreeQ[{x, x^n}, n]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["FreeQ", "MR"],
  " to define a \[OpenCurlyDoubleQuote]linearity\[CloseCurlyDoubleQuote] rule \
for ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.31"}],

Cell["h[a_ b_, x_] := a h[b, x] /; FreeQ[a, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "Terms free of ",
  StyleBox["x", "MR"],
  " are pulled out of each\[NonBreakingSpace]",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.32"}],

Cell[CellGroupData[{

Cell["h[a b x, x] + h[2 (1+x) x^2, x]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(a\ b\ h[x, x] + 2\ h[x\^2\ \((1 + x)\), x]\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              " ",
              StyleBox["?", "MR"],
              " ",
              StyleBox["test", "TI"],
              " "
            }]], Cell[TextData[{
              "a pattern which matches an expression only if ",
              StyleBox["test", "TI"],
              " yields ",
              StyleBox["True", "MR"],
              " when applied to the expression "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.5"],

Cell["Another way to constrain patterns. ", "Caption",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "The construction ",
  StyleBox["pattern", "TI"],
  " ",
  StyleBox["/;", "MR"],
  " ",
  StyleBox["condition", "TI"],
  " allows you to evaluate a condition involving pattern names to determine \
whether there is a match. The construction ",
  StyleBox["pattern", "TI"],
  " ",
  StyleBox["?", "MR"],
  " ",
  StyleBox["test", "TI"],
  " instead applies a function ",
  StyleBox["test", "TI"],
  " to the whole expression matched by ",
  StyleBox["pattern", "TI"],
  " to determine whether there is a match. Using ",
  StyleBox["?", "MR"],
  " instead of ",
  StyleBox["/;", "MR"],
  " sometimes leads to more succinct definitions. "
}], "Text",
  CellTags->{"S2.3.5", "5.33"}],

Cell[TextData[{
  "With this definition matches for ",
  StyleBox["x_", "MR"],
  " are tested with the function ",
  StyleBox["NumberQ", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.34"}],

Cell["p[x_?NumberQ] := x^2", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "The definition applies only when ",
  StyleBox["p", "MR"],
  " has a numerical argument. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.35"}],

Cell[CellGroupData[{

Cell["p[4.5] + p[3/2] + p[u]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \(\(\(22.5`\)\(\[InvisibleSpace]\)\) + p[u]\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell["\<\
Here is a more complicated definition. Do not forget the \
parentheses around the pure function. \
\>", "MathCaption",
  CellTags->{"S2.3.5", "5.36"}],

Cell["\<\
q[{x_Integer, y_Integer} ? (Function[v, v.v > 4])] := qp[x + \
y]\
\>", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.3.5"],

Cell["The definition applies only in certain cases. ", "MathCaption",
  CellTags->{"S2.3.5", "5.37"}],

Cell[CellGroupData[{

Cell["{q[{3, 4}], q[{1, 1}], q[{-5, -7}]}", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({qp[7], q[{1, 1}], qp[\(-12\)]}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Except[", "MR"],
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pattern which matches any expression except ",
              StyleBox["c", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Except[", "MR"],
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pattern which matches ",
              StyleBox["patt", "TI"],
              " but not ",
              StyleBox["c", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.5"],

Cell["Patterns with exceptions. ", "Caption",
  CellTags->"S2.3.5"],

Cell[TextData[{
  "This gives all elements except ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.38"}],

Cell[CellGroupData[{

Cell["Cases[{1, 0, 2, 0, 3}, Except[0]]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Except", "MR"],
  " can take a pattern as an argument. "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.39"}],

Cell[CellGroupData[{

Cell["Cases[{a, b, 0, 1, 2, x, y}, Except[_Integer]]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({a, b, x, y}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  "This picks out integers that are not ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.5", "5.40"}],

Cell[CellGroupData[{

Cell["Cases[{a, b, 0, 1, 2, x, y}, Except[0, _Integer]]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.3.5"],

Cell[BoxData[
    \({1, 2}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S2.3.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Except[", "MR"],
  StyleBox["c", "TI"],
  StyleBox["]", "MR"],
  " is in a sense a very general pattern: it matches ",
  StyleBox["anything", "TI"],
  " except ",
  StyleBox["c", "TI"],
  ". In many situations you instead need to use ",
  StyleBox["Except[", "MR"],
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["patt", "TI"],
  StyleBox["]", "MR"],
  ", which starts from expressions matching ",
  StyleBox["patt", "TI"],
  ", then excludes ones that match ",
  StyleBox["c", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.3.5", "5.41"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.6 Patterns Involving Alternatives", "Subsection",
  CellTags->{"S2.3.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell["a pattern that can have one of several forms "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.6"],

Cell["Specifying patterns that involve alternatives. ", "Caption",
  CellTags->"S2.3.6"],

Cell[TextData[{
  "This defines ",
  StyleBox["h", "MR"],
  " to give ",
  StyleBox["p", "MR"],
  " when its argument is either ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.6", "6.2"}],

Cell["h[a | b] := p", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.6"],

Cell[TextData[{
  "The first two cases give ",
  StyleBox["p", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.6", "6.3"}],

Cell[CellGroupData[{

Cell["{h[a], h[b], h[c], h[d]}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.6"],

Cell[BoxData[
    \({p, p, h[c], h[d]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.6"]
}, Open  ]],

Cell["You can also use alternatives in transformation rules. ", "MathCaption",
  CellTags->{"S2.3.6", "6.4"}],

Cell[CellGroupData[{

Cell["{a, b, c, d} /. (a | b) -> p", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.6"],

Cell[BoxData[
    \({p, p, c, d}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.6"]
}, Open  ]],

Cell["\<\
Here is another example, in which one of the alternatives is itself \
a pattern. \
\>", "MathCaption",
  CellTags->{"S2.3.6", "6.5"}],

Cell[CellGroupData[{

Cell["{1, x, x^2, x^3, y^2} /. (x | x^_) -> q", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.6"],

Cell[BoxData[
    \({1, q, q, q, y\^2}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.6"]
}, Open  ]],

Cell[TextData[{
  "When you use alternatives in patterns, you should make sure that the same \
set of names appear in each alternative. When a pattern like ",
  StyleBox["(a[x_]", "MR"],
  " ",
  StyleBox["|", "MR"],
  " ",
  StyleBox["b[x_])", "MR"],
  " matches an expression, there will always be a definite expression that \
corresponds to the object ",
  StyleBox["x", "MR"],
  ". On the other hand, if you try to match a pattern like ",
  StyleBox["(a[x_]", "MR"],
  " ",
  StyleBox["|", "MR"],
  " ",
  StyleBox["b[y_])", "MR"],
  ", then there will be a definite expression corresponding either to ",
  StyleBox["x", "MR"],
  ", or to ",
  StyleBox["y", "MR"],
  ", but not to both. As a result, you cannot use ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " to refer to definite expressions, for example on the right\[Hyphen]hand \
side of a transformation rule. "
}], "Text",
  CellTags->{"S2.3.6", "6.6"}],

Cell[TextData[{
  "Here ",
  StyleBox["f", "MR"],
  " is used to name the head, which can be either ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.6", "6.7"}],

Cell[CellGroupData[{

Cell["{a[2], b[3], c[4], a[5]} /. (f:(a|b))[x_] -> r[f, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.6"],

Cell[BoxData[
    \({r[a, 2], r[b, 3], c[4], r[a, 5]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.7 Flat and Orderless Functions", "Subsection",
  CellTags->{"S2.3.7", "7.1"}],

Cell[TextData[{
  "Although ",
  StyleBox["Mathematica", "TI"],
  " matches patterns in a purely structural fashion, its notion of structural \
equivalence is quite sophisticated. In particular, it takes account of \
properties such as commutativity and associativity in functions like ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.7", "7.2"}],

Cell[TextData[{
  "This means, for example, that ",
  StyleBox["Mathematica", "TI"],
  " considers the expressions ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "TI"],
  " and ",
  StyleBox["y", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x", "TI"],
  " equivalent for the purposes of pattern matching. As a result, a pattern \
like ",
  StyleBox["g[x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y_,", "MR"],
  " ",
  StyleBox["x_]", "MR"],
  " can match not only ",
  StyleBox["g[a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["a]", "MR"],
  ", but also ",
  StyleBox["g[a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["b]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.7", "7.3"}],

Cell["This expression has exactly the same form as the pattern. ", \
"MathCaption",
  CellTags->{"S2.3.7", "7.4"}],

Cell[CellGroupData[{

Cell["g[a + b, a] /. g[x_ + y_, x_] -> p[x, y]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[a, b]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "In this case, the expression has to be put in the form ",
  StyleBox["g[b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a,", "MR"],
  " ",
  StyleBox["b]", "MR"],
  " in order to have the same structure as the pattern. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.5"}],

Cell[CellGroupData[{

Cell["g[a + b, b] /. g[x_ + y_, x_] -> p[x, y]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[b, a]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "Whenever ",
  StyleBox["Mathematica", "TI"],
  " encounters an ",
  StyleBox["orderless", "TI"],
  " or ",
  StyleBox["commutative", "TI"],
  " function such as ",
  StyleBox["Plus", "MR"],
  " or ",
  StyleBox["Times", "MR"],
  " in a pattern, it effectively tests all the possible orders of arguments \
to try and find a match. Sometimes, there may be several orderings that lead \
to matches. In such cases, ",
  StyleBox["Mathematica", "TI"],
  " just uses the first ordering it finds. For example, ",
  StyleBox["h[x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y_,", "MR"],
  " ",
  StyleBox["x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z_]", "MR"],
  " could match ",
  StyleBox["h[a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b]", "MR"],
  " with ",
  StyleBox["x", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["a", "MR"],
  ", ",
  StyleBox["y", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["b", "MR"],
  ", ",
  StyleBox["z", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["b", "MR"],
  " or with ",
  StyleBox["x", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["b", "MR"],
  ", ",
  StyleBox["y", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["a", "MR"],
  ", ",
  StyleBox["z", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["a", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " tries the case ",
  StyleBox["x", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["a", "MR"],
  ", ",
  StyleBox["y", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["b", "MR"],
  ", ",
  StyleBox["z", "MR"],
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  StyleBox["b", "MR"],
  " first, and so uses this match.   "
}], "Text",
  CellTags->{"S2.3.7", "7.6"}],

Cell[TextData[{
  "This can match either with ",
  StyleBox["x", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["a", "MR"],
  " or with ",
  StyleBox["x", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["b", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " tries ",
  StyleBox["x", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["a", "MR"],
  " first, and so uses this match. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.7"}],

Cell[CellGroupData[{

Cell["h[a + b, a + b] /. h[x_ + y_, x_ + z_] -> p[x, y, z]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[a, b, b]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ReplaceList", "MR"],
  " shows both possible matches. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.8"}],

Cell[CellGroupData[{

Cell["\<\
ReplaceList[h[a + b, a + b], h[x_ + y_, x_ + z_] -> p[x, y, \
z]]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \({p[a, b, b], p[b, a, a]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.6.3",
    ButtonData:>{"2.6.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " allows you to assign certain attributes to functions, which specify how \
those functions should be treated in evaluation and pattern matching. \
Functions can for example be assigned the attribute ",
  StyleBox["Orderless", "MR"],
  ", which specifies that they should be treated as commutative or symmetric, \
and allows their arguments to be rearranged in trying to match patterns. "
}], "Text",
  CellTags->{"S2.3.7", "7.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Orderless", "MR"],
              " "
            }]], Cell[TextData[{
              "commutative function: ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              ", etc., are equivalent to ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Flat", "MR"],
              " "
            }]], Cell[TextData[{
              "associative function: ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              ", etc., are equivalent to ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["OneIdentity", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["]]", "MR"],
              ", etc., are equivalent to ",
              StyleBox["a", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Attributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the attributes assigned to ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SetAttributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["attr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["attr", "TI"],
              " to the attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ClearAttributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["attr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove ",
              StyleBox["attr", "TI"],
              " from the attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.3.7"],

Cell["Some attributes that can be assigned to functions. ", "Caption",
  CellTags->"S2.3.7"],

Cell[TextData[{
  StyleBox["Plus", "MR"],
  " has attributes ",
  StyleBox["Orderless", "MR"],
  " and ",
  StyleBox["Flat", "MR"],
  ", as well as others. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.10"}],

Cell[CellGroupData[{

Cell["Attributes[Plus]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \({Flat, Listable, NumericFunction, OneIdentity, Orderless, 
      Protected}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "This defines ",
  StyleBox["q", "MR"],
  " to be an orderless or commutative function. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.11"}],

Cell["SetAttributes[q, Orderless]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.7"],

Cell[TextData[{
  "The arguments of ",
  StyleBox["q", "MR"],
  " are automatically sorted into order. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.12"}],

Cell[CellGroupData[{

Cell["q[b, a, c]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(q[a, b, c]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " rearranges the arguments of ",
  StyleBox["q", "MR"],
  " functions to find a match. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.13"}],

Cell[CellGroupData[{

Cell["f[q[a, b], q[b, c]] /. f[q[x_, y_], q[x_, z_]] -> p[x, y, z]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[b, a, c]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "In addition to being orderless, functions like ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  " also have the property of being ",
  StyleBox["flat", "TI"],
  " or ",
  StyleBox["associative", "TI"],
  ". This means that you can effectively \[OpenCurlyDoubleQuote]parenthesize\
\[CloseCurlyDoubleQuote] their arguments in any way, so that, for example, ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["(y", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z)", "MR"],
  " is equivalent to ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["z", "MR"],
  ", and so on.    "
}], "Text",
  CellTags->{"S2.3.7", "7.14"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " takes account of flatness in matching patterns. As a result, a pattern \
like ",
  StyleBox["g[x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y_]", "MR"],
  " can match ",
  StyleBox["g[a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c]", "MR"],
  ", with ",
  StyleBox["x", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["(b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c)", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.7", "7.15"}],

Cell[TextData[{
  "The argument of ",
  StyleBox["g", "MR"],
  " is written as ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["(b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c)", "MR"],
  " so as to match the pattern. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.16"}],

Cell[CellGroupData[{

Cell["g[a + b + c] /. g[x_ + y_] -> p[x, y]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[a, b + c]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "If there are no other constraints, ",
  StyleBox["Mathematica", "TI"],
  " will match ",
  StyleBox["x_", "MR"],
  " to the first element of the sum. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.17"}],

Cell[CellGroupData[{

Cell["g[a + b + c + d] /. g[x_ + y_] -> p[x, y]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[a, b + c + d]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell["This shows all the possible matches. ", "MathCaption",
  CellTags->{"S2.3.7", "7.18"}],

Cell[CellGroupData[{

Cell["ReplaceList[g[a + b + c], g[x_ + y_] -> p[x, y]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \({p[a, b + c], p[b, a + c], p[c, a + b], p[a + b, c], p[a + c, b], 
      p[b + c, a]}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["x_", "MR"],
  " is forced to match ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["d", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.19"}],

Cell[CellGroupData[{

Cell["g[a + b + c + d, b + d] /. g[x_ + y_, x_] -> p[x, y]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[b + d, a + c]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can usually apply a transformation rule to a function only if the pattern \
in the rule covers all the arguments in the function. However, if you have a \
flat function, it is sometimes possible to apply transformation rules even \
though not all the arguments are covered. "
}], "Text",
  CellTags->{"S2.3.7", "7.20"}],

Cell["\<\
This rule applies even though it does not cover all the terms in \
the sum. \
\>", "MathCaption",
  CellTags->{"S2.3.7", "7.21"}],

Cell[CellGroupData[{

Cell["a + b + c /. a + c -> p", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(b + p\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell["This combines two of the terms in the sum. ", "MathCaption",
  CellTags->{"S2.3.7", "7.22"}],

Cell[CellGroupData[{

Cell["u[a] + u[b] + v[c] + v[d] /. u[x_] + u[y_] -> u[x + y]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(u[a + b] + v[c] + v[d]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  " are both flat and orderless. There are, however, some functions, such as \
",
  StyleBox["Dot", "MR"],
  ", which are flat, but not orderless. "
}], "Text",
  CellTags->{"S2.3.7", "7.23"}],

Cell[TextData[{
  "Both ",
  StyleBox["x_", "MR"],
  " and ",
  StyleBox["y_", "MR"],
  " can match any sequence of terms in the dot product. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.24"}],

Cell[CellGroupData[{

Cell["a . b . c . d . a . b /. x_ . y_ . x_ -> p[x, y]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(p[a . b, c . d]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "This assigns the attribute ",
  StyleBox["Flat", "MR"],
  " to the function ",
  StyleBox["r", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.25"}],

Cell["SetAttributes[r, Flat]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.3.7"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " writes the expression in the form ",
  StyleBox["r[r[a,", "MR"],
  " ",
  StyleBox["b],", "MR"],
  " ",
  StyleBox["r[a,", "MR"],
  " ",
  StyleBox["b]]", "MR"],
  " to match the pattern. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.26"}],

Cell[CellGroupData[{

Cell["r[a, b, a, b] /. r[x_, x_] -> rp[x]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(rp[r[a, b]]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " writes this expression in the form ",
  StyleBox["r[a,", "MR"],
  " ",
  StyleBox["r[r[b],", "MR"],
  " ",
  StyleBox["r[b]],", "MR"],
  " ",
  StyleBox["c]", "MR"],
  " to match the pattern. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.27"}],

Cell[CellGroupData[{

Cell["r[a, b, b, c] /. r[x_, x_] -> rp[x]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(r[a, rp[r[b]], c]\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "In an ordinary function that is not flat, a pattern such as ",
  StyleBox["x_", "MR"],
  " matches an individual argument of the function. But in a function ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["a", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " that is flat, ",
  StyleBox["x_", "MR"],
  " can match objects such as ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["b", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["c", "TI"],
  StyleBox["]", "MR"],
  " which effectively correspond to a sequence of arguments. However, in the \
case where ",
  StyleBox["x_", "MR"],
  " matches a single argument in a flat function, the question comes up as to \
whether the object it matches is really just the argument ",
  StyleBox["a", "TI"],
  " itself, or ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["a", "TI"],
  StyleBox["]", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " chooses the first of these cases if the function carries the attribute ",
  StyleBox["OneIdentity", "MR"],
  ", and chooses the second case otherwise. "
}], "Text",
  CellTags->{"S2.3.7", "7.28"}],

Cell[TextData[{
  "This adds the attribute ",
  StyleBox["OneIdentity", "MR"],
  " to the function ",
  StyleBox["r", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.29"}],

Cell["SetAttributes[r, OneIdentity]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.3.7"],

Cell[TextData[{
  "Now ",
  StyleBox["x_", "MR"],
  " matches individual arguments, without ",
  StyleBox["r", "MR"],
  " wrapped around them. "
}], "MathCaption",
  CellTags->{"S2.3.7", "7.30"}],

Cell[CellGroupData[{

Cell["r[a, b, b, c] /. r[x_, x_] -> rp[x]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.3.7"],

Cell[BoxData[
    \(r[a, rp[b], c]\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.3.7"]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  StyleBox["Plus", "MR"],
  ", ",
  StyleBox["Times", "MR"],
  " and ",
  StyleBox["Dot", "MR"],
  " all have the attribute ",
  StyleBox["OneIdentity", "MR"],
  ", reflecting the fact that ",
  StyleBox["Plus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " is equivalent to ",
  StyleBox["x", "TI"],
  ", and so on. However, in representing mathematical objects, it is often \
convenient to deal with flat functions that do not have the attribute ",
  StyleBox["OneIdentity", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.7", "7.31"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.8 Functions with Variable Numbers of Arguments", "Subsection",
  CellTags->{"S2.3.8", "8.1"}],

Cell[TextData[{
  "Unless ",
  StyleBox["f", "TI"],
  " is a flat function, a pattern like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["_,", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["_]", "MR"],
  " stands only for instances of the function with exactly two arguments. \
Sometimes you need to set up patterns that can allow any number of arguments. \
"
}], "Text",
  CellTags->{"S2.3.8", "8.2"}],

Cell[TextData[{
  "You can do this using ",
  StyleBox["multiple blanks", "TI"],
  ". While a single blank such as ",
  StyleBox["x_", "MR"],
  " stands for a single ",
  StyleBox["Mathematica", "TI"],
  " expression, a double blank such as ",
  StyleBox["x__", "MR"],
  " stands for a sequence of one or more expressions. "
}], "Text",
  CellTags->{"S2.3.8", "8.3"}],

Cell[TextData[{
  "Here ",
  StyleBox["x__", "MR"],
  " stands for the sequence of expressions ",
  StyleBox["(a,", "MR"],
  " ",
  StyleBox["b,", "MR"],
  " ",
  StyleBox["c)", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.8", "8.4"}],

Cell[CellGroupData[{

Cell["f[a, b, c] /. f[x__] -> p[x, x, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.8"],

Cell[BoxData[
    \(p[a, b, c, a, b, c, a, b, c]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.8"]
}, Open  ]],

Cell[TextData[{
  "Here is a more complicated definition, which picks out pairs of duplicated \
elements in ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.8", "8.5"}],

Cell["h[a___, x_, b___, x_, c___] := hh[x] h[a, b, c]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.8"],

Cell["\<\
The definition is applied twice, picking out the two paired \
elements. \
\>", "MathCaption",
  CellTags->{"S2.3.8", "8.6"}],

Cell[CellGroupData[{

Cell["h[2, 3, 2, 4, 5, 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.8"],

Cell[BoxData[
    \(h[4, 5]\ hh[2]\ hh[3]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.8"]
}, Open  ]],

Cell[TextData[{
  "\[OpenCurlyDoubleQuote]Double blanks\[CloseCurlyDoubleQuote] ",
  StyleBox["__", "MR"],
  " stand for sequences of one or more expressions. \
\[OpenCurlyDoubleQuote]Triple blanks\[CloseCurlyDoubleQuote] ",
  StyleBox["___", "MR"],
  " stand for sequences of zero or more expressions. You should be very \
careful whenever you use triple blank patterns. It is easy to make a mistake \
that can lead to an infinite loop. For example, if you define ",
  StyleBox["p[x_,", "MR"],
  " ",
  StyleBox["y___]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["p[x]", "MR"],
  " ",
  StyleBox["q[y]", "MR"],
  ", then typing in ",
  StyleBox["p[a]", "MR"],
  " will lead to an infinite loop, with ",
  StyleBox["y", "MR"],
  " repeatedly matching a sequence with zero elements. Unless you are sure \
you want to include the case of zero elements, you should always use double \
blanks rather than triple blanks. "
}], "Text",
  CellTags->{"S2.3.8", "8.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["_", "MR"],
              " "
            }]], Cell["any single expression "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              "any single expression, to be named ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["__", "MR"],
              " "
            }]], Cell["any sequence of one or more expressions "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["__", "MR"],
              " "
            }]], Cell[TextData[{
              "sequence named ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["__", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              
              "sequence of expressions, all of whose heads are\
\[NonBreakingSpace]",
              StyleBox["h", "TI"]
            }]]},
          {Cell[TextData[{
              StyleBox["___", "MR"],
              " "
            }]], Cell["any sequence of zero or more expressions "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["___", "MR"],
              " "
            }]], Cell[TextData[{
              "sequence of zero or more expressions named ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["___", "MR"],
              StyleBox["h", "TI"],
              " "
            }]], Cell[TextData[{
              
              "sequence of zero or more expressions, all of whose heads are\
\[NonBreakingSpace]",
              StyleBox["h", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.8"],

Cell["More kinds of pattern objects. ", "Caption",
  CellTags->"S2.3.8"],

Cell[TextData[{
  "Notice that with flat functions such as ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " automatically handles variable numbers of arguments, so you do not \
explicitly need to use double or triple blanks, as discussed in Section ",
  ButtonBox["2.3.7",
    ButtonData:>{"2.3.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.3.8", "8.8"}],

Cell[TextData[{
  "When you use multiple blanks, there are often several matches that are \
possible for a particular expression. In general, ",
  StyleBox["Mathematica", "TI"],
  " tries first those matches that assign the shortest sequences of arguments \
to the first multiple blanks that appear in the pattern. "
}], "Text",
  CellTags->{"S2.3.8", "8.9"}],

Cell[TextData[{
  "This gives a list of all the matches that ",
  StyleBox["Mathematica", "TI"],
  " tries. "
}], "MathCaption",
  CellTags->{"S2.3.8", "8.10"}],

Cell[CellGroupData[{

Cell["ReplaceList[f[a, b, c, d], f[x__, y__] -> g[{x}, {y}]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.8"],

Cell[BoxData[
    \({g[{a}, {b, c, d}], g[{a, b}, {c, d}], g[{a, b, c}, {d}]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.8"]
}, Open  ]],

Cell[TextData[{
  "Many kinds of enumeration can be done by using ",
  StyleBox["ReplaceList", "MR"],
  " with various kinds of patterns. "
}], "MathCaption",
  CellTags->{"S2.3.8", "8.11"}],

Cell[CellGroupData[{

Cell["ReplaceList[f[a, b, c, d], f[___, x__] -> g[x]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.8"],

Cell[BoxData[
    \({g[a, b, c, d], g[b, c, d], g[c, d], g[d]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.8"]
}, Open  ]],

Cell["\<\
This effectively enumerates all sublists with at least one element. \
\
\>", "MathCaption",
  CellTags->{"S2.3.8", "8.12"}],

Cell[CellGroupData[{

Cell["ReplaceList[f[a, b, c, d], f[___, x__, ___] -> g[x]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.8"],

Cell[BoxData[
    \({g[a], g[a, b], g[b], g[a, b, c], g[b, c], g[c], g[a, b, c, d], 
      g[b, c, d], g[c, d], g[d]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.9 Optional and Default Arguments", "Subsection",
  CellTags->{"S2.3.9", "9.1"}],

Cell[TextData[{
  "Sometimes you may want to set up functions where certain arguments, if \
omitted, are given \[OpenCurlyDoubleQuote]default values\
\[CloseCurlyDoubleQuote]. The pattern ",
  StyleBox["x", "TI"],
  StyleBox["_:", "MR"],
  StyleBox["v", "TI"],
  " stands for an object that can be omitted, and if so, will be replaced by \
the default value ",
  StyleBox["v", "TI"],
  ".   "
}], "Text",
  CellTags->{"S2.3.9", "9.2"}],

Cell[TextData[{
  "This defines a function ",
  StyleBox["j", "MR"],
  " with a required argument ",
  StyleBox["x", "MR"],
  ", and optional arguments ",
  StyleBox["y", "MR"],
  " and ",
  StyleBox["z", "MR"],
  ", with default values ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["2", "MR"],
  ", respectively. "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.3"}],

Cell["j[x_, y_:1, z_:2] := jp[x, y, z]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.9"],

Cell[TextData[{
  "The default value of ",
  StyleBox["z", "MR"],
  " is used here. "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.4"}],

Cell[CellGroupData[{

Cell["j[a, b]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \(jp[a, b, 2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell[TextData[{
  "Now the default values of both ",
  StyleBox["y", "MR"],
  " and ",
  StyleBox["z", "MR"],
  " are used. "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.5"}],

Cell[CellGroupData[{

Cell["j[a]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \(jp[a, 1, 2]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_:", "MR"],
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              
              "an expression which, if omitted, is taken to have default \
value ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              StyleBox["h", "TI"],
              StyleBox[":", "MR"],
              StyleBox["v", "TI"],
              " "
            }]], Cell[TextData[{
              "an expression with head ",
              StyleBox["h", "TI"],
              " and default value ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_.", "MR"],
              " "
            }]], 
            Cell["\<\
an expression with a built\[Hyphen]in default value \
\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.9"],

Cell["Pattern objects with default values. ", "Caption",
  CellTags->"S2.3.9"],

Cell[TextData[{
  "Some common ",
  StyleBox["Mathematica", "TI"],
  " functions have built\[Hyphen]in default values for their arguments. In \
such cases, you need not explicitly give the default value in ",
  StyleBox["x", "TI"],
  StyleBox["_:", "MR"],
  StyleBox["v", "TI"],
  ", but instead you can use the more convenient notation ",
  StyleBox["x", "TI"],
  StyleBox["_.", "MR"],
  " in which a built\[Hyphen]in default value is assumed. "
}], "Text",
  CellTags->{"S2.3.9", "9.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y_.", "MR"],
              " "
            }]], Cell[TextData[{
              "default for ",
              StyleBox["y", "MR"],
              " is ",
              StyleBox["0", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x_", "MR"],
              " ",
              StyleBox["y_.", "MR"],
              " "
            }]], Cell[TextData[{
              "default for ",
              StyleBox["y", "MR"],
              " is ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x_^y_.", "MR"],
              " "
            }]], Cell[TextData[{
              "default for ",
              StyleBox["y", "MR"],
              " is ",
              StyleBox["1", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.9"],

Cell["Some patterns with optional pieces. ", "Caption",
  CellTags->"S2.3.9"],

Cell[TextData[{
  "Here ",
  StyleBox["a", "MR"],
  " matches the pattern ",
  StyleBox["x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y_.", "MR"],
  " with ",
  StyleBox["y", "MR"],
  " taken to have the default value\[NonBreakingSpace]",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.7"}],

Cell[CellGroupData[{

Cell["{f[a], f[a + b]} /. f[x_ + y_.] -> p[x, y]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \({p[a, 0], p[b, a]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell[TextData[{
  "Because ",
  StyleBox["Plus", "MR"],
  " is a flat function, a pattern such as ",
  StyleBox["x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y_", "MR"],
  " can match a sum with any number of terms. This pattern cannot, however, \
match a single term such as ",
  StyleBox["a", "MR"],
  ". However, the pattern ",
  StyleBox["x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y_.", "MR"],
  " contains an optional piece, and can match either an explicit sum of terms \
in which both ",
  StyleBox["x_", "MR"],
  " and ",
  StyleBox["y_", "MR"],
  " appear, or a single term ",
  StyleBox["x_", "MR"],
  ", with ",
  StyleBox["y", "MR"],
  " taken to be ",
  StyleBox["0", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.9", "9.8"}],

Cell[TextData[{
  "Using constructs such as ",
  StyleBox["x", "TI"],
  StyleBox["_.", "MR"],
  ", you can easily construct single patterns that match expressions with \
several different structures. This is particularly useful when you want to \
match several mathematically equal forms that do not have the same structure. \
"
}], "Text",
  CellTags->{"S2.3.9", "9.9"}],

Cell[TextData[{
  "The pattern matches ",
  StyleBox["g[a^2]", "MR"],
  ", but not ",
  StyleBox["g[a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.10"}],

Cell[CellGroupData[{

Cell["{g[a^2], g[a + b]} /. g[x_^n_] -> p[x, n]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \({p[a, 2], g[a + b]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell["\<\
By giving a pattern in which the exponent is optional, you can \
match both cases. \
\>", "MathCaption",
  CellTags->{"S2.3.9", "9.11"}],

Cell[CellGroupData[{

Cell["{g[a^2], g[a + b]} /. g[x_^n_.] -> p[x, n]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \({p[a, 2], p[a + b, 1]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell[TextData[{
  "The pattern ",
  StyleBox["a_.", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b_.", "MR"],
  " ",
  StyleBox["x_", "MR"],
  " matches any linear function of ",
  StyleBox["x_", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.12"}],

Cell["lin[a_. + b_. x_, x_] := p[a, b]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.9"],

Cell[TextData[{
  "In this case, ",
  StyleBox["b", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.13"}],

Cell[CellGroupData[{

Cell["lin[1 + x, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \(p[1, 1]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["b", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["1", "MR"],
  " and ",
  StyleBox["a", "MR"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  " ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.9", "9.14"}],

Cell[CellGroupData[{

Cell["lin[y, y]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.9"],

Cell[BoxData[
    \(p[0, 1]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.3.9"]
}, Open  ]],

Cell[TextData[{
  "Standard ",
  StyleBox["Mathematica", "TI"],
  " functions such as ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  " have built\[Hyphen]in default values for their arguments. You can also \
set up defaults for your own functions, as described in Section ",
  ButtonBox["A.5.1",
    ButtonData:>{"A.5.1", "1.6"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.3.9", "9.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.10 Setting Up Functions with Optional Arguments", "Subsection",
  CellTags->{"S2.3.10", "10.1"}],

Cell["\<\
When you define a complicated function, you will often want to let \
some of the arguments of the function be \[OpenCurlyDoubleQuote]optional\
\[CloseCurlyDoubleQuote]. If you do not give those arguments explicitly, you \
want them to take on certain \[OpenCurlyDoubleQuote]default\
\[CloseCurlyDoubleQuote] values.  \
\>", "Text",
  CellTags->{"S2.3.10", "10.2"}],

Cell[TextData[{
  "Built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions use two basic methods for dealing with optional arguments. You \
can choose between the same two methods when you define your own functions in \
",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.3.10", "10.3"}],

Cell[TextData[{
  "The first method is to have the meaning of each argument determined by its \
position, and then to allow one to drop arguments, replacing them by default \
values. Almost all built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions that use this method drop arguments from the end. For example, \
the built\[Hyphen]in function ",
  StyleBox["Flatten[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " allows you to drop the second argument, which is taken to have a default \
value of ",
  StyleBox["Infinity", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.10", "10.4"}],

Cell[TextData[{
  "You can implement this kind of \[OpenCurlyDoubleQuote]positional\
\[CloseCurlyDoubleQuote] argument using ",
  StyleBox["_:", "MR"],
  " patterns. "
}], "Text",
  CellTags->{"S2.3.10", "10.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["_:", "MR"],
              StyleBox["kdef", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              
              "a typical definition for a function whose second argument is \
optional, with default value ",
              StyleBox["kdef", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.10"],

Cell["Defining a function with positional arguments. ", "Caption",
  CellTags->"S2.3.10"],

Cell[TextData[{
  "This defines a function with an optional second argument. When the second \
argument is omitted, it is taken to have the default value ",
  StyleBox["Infinity", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.6"}],

Cell["f[list_, n_:Infinity] := f0[list, n]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.10"],

Cell["Here is a function with two optional arguments. ", "MathCaption",
  CellTags->{"S2.3.10", "10.7"}],

Cell["fx[list_, n1_:1, n2_:2] := fx0[list, n1, n2]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.10"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " assumes that arguments are dropped from the end. As a result ",
  StyleBox["m", "MR"],
  " here gives the value of ",
  StyleBox["n1", "MR"],
  ", while ",
  StyleBox["n2", "MR"],
  " has its default value of ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.8"}],

Cell[CellGroupData[{

Cell["fx[k, m]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.10"],

Cell[BoxData[
    \(fx0[k, m, 2]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.10"]
}, Open  ]],

Cell[TextData[{
  "The second method that built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions use for dealing with optional arguments is to give explicit \
names to the optional arguments, and then to allow their values to be given \
using transformation rules. This method is particularly convenient for \
functions like ",
  StyleBox["Plot", "MR"],
  " which have a very large number of optional parameters, only a few of \
which usually need to be set in any particular instance.  "
}], "Text",
  CellTags->{"S2.3.10", "10.9"}],

Cell[TextData[{
  "The typical arrangement is that values for \[OpenCurlyDoubleQuote]named\
\[CloseCurlyDoubleQuote] optional arguments can be specified by including the \
appropriate transformation rules at the end of the arguments to a particular \
function. Thus, for example, the rule ",
  StyleBox["PlotJoined->True", "MR"],
  ", which specifies the setting for the named optional argument ",
  StyleBox["PlotJoined", "MR"],
  ", could appear as ",
  StyleBox["ListPlot[", "MR"],
  StyleBox["list", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["PlotJoined->True]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.10", "10.10"}],

Cell[TextData[{
  "When you set up named optional arguments for a function ",
  StyleBox["f", "TI"],
  ", it is conventional to store the default values of these arguments as a \
list of transformation rules assigned to ",
  StyleBox["Options[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.3.10", "10.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["opts", "TI"],
              StyleBox["___]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], 
            Cell["\<\
a typical definition for a function with zero or more \
named optional arguments \
\>"]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["opts", "TI"],
              StyleBox["}", "MR"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["Options[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
replacements used to get the value of a named optional \
argument in the body of the function \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.10"],

Cell["Named arguments. ", "Caption",
  CellTags->"S2.3.10"],

Cell[TextData[{
  "This sets up default values for two named optional arguments ",
  StyleBox["opt1", "MR"],
  " and ",
  StyleBox["opt2", "MR"],
  " in the function ",
  StyleBox["fn", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.12"}],

Cell[CellGroupData[{

Cell["Options[fn] = { opt1 -> 1, opt2 -> 2 }", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.10"],

Cell[BoxData[
    \({opt1 \[Rule] 1, opt2 \[Rule] 2}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.10"]
}, Open  ]],

Cell[TextData[{
  "This gives the default value for ",
  StyleBox["opt1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.13"}],

Cell[CellGroupData[{

Cell["opt1 /. Options[fn]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.10"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.10"]
}, Open  ]],

Cell[TextData[{
  "The rule ",
  StyleBox["opt1->3", "MR"],
  " is applied first, so the default rule for ",
  StyleBox["opt1", "MR"],
  " in ",
  StyleBox["Options[fn]", "MR"],
  " is not used. "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.14"}],

Cell[CellGroupData[{

Cell["opt1 /. opt1->3 /. Options[fn]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.10"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.10"]
}, Open  ]],

Cell[TextData[{
  "Here is the definition for a function ",
  StyleBox["fn", "MR"],
  " which allows zero or more named optional arguments to be specified. "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.15"}],

Cell["fn[x_, opts___] := k[x, opt2/.{opts}/.Options[fn]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.10"],

Cell[TextData[{
  "With no optional arguments specified, the default rule for ",
  StyleBox["opt2", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.16"}],

Cell[CellGroupData[{

Cell["fn[4]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.10"],

Cell[BoxData[
    \(k[4, 2]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.10"]
}, Open  ]],

Cell[TextData[{
  "If you explicitly give a rule for ",
  StyleBox["opt2", "MR"],
  ", it will be used before the default rules stored in ",
  StyleBox["Options[fn]", "MR"],
  " are tried. "
}], "MathCaption",
  CellTags->{"S2.3.10", "10.17"}],

Cell[CellGroupData[{

Cell["fn[4, opt2->7]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.10"],

Cell[BoxData[
    \(k[4, 7]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.3.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.11 Repeated Patterns", "Subsection",
  CellTags->{"S2.3.11", "11.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["..", "MR"],
              " "
            }]], Cell[
            "a pattern or other expression repeated one or more times "]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              StyleBox["...", "MR"],
              " "
            }]], Cell[
            "a pattern or other expression repeated zero or more times "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.11"],

Cell["Repeated patterns. ", "Caption",
  CellTags->"S2.3.11"],

Cell[TextData[{
  "Multiple blanks such as ",
  StyleBox["x", "TI"],
  StyleBox["__", "MR"],
  " allow you to give patterns in which sequences of arbitrary expressions \
can occur. The ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["pattern repetition operators", "TI"],
  " ",
  StyleBox["..", "MR"],
  " and ",
  StyleBox["...", "MR"],
  " allow you to construct patterns in which particular forms can be repeated \
any number of times. Thus, for example, ",
  StyleBox["f[a..]", "MR"],
  " represents any expression of the form ",
  StyleBox["f[a]", "MR"],
  ", ",
  StyleBox["f[a,", "MR"],
  " ",
  StyleBox["a]", "MR"],
  ", ",
  StyleBox["f[a,", "MR"],
  " ",
  StyleBox["a,", "MR"],
  " ",
  StyleBox["a]", "MR"],
  " and so on. "
}], "Text",
  CellTags->{"S2.3.11", "11.2"}],

Cell[TextData[{
  "The pattern ",
  StyleBox["f[a..]", "MR"],
  " allows the argument ",
  StyleBox["a", "MR"],
  " to be repeated any number of times. "
}], "MathCaption",
  CellTags->{"S2.3.11", "11.3"}],

Cell[CellGroupData[{

Cell["Cases[{ f[a], f[a, b, a], f[a, a, a] }, f[a..]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.11"],

Cell[BoxData[
    \({f[a], f[a, a, a]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.11"]
}, Open  ]],

Cell[TextData[{
  "This pattern allows any number of ",
  StyleBox["a", "MR"],
  " arguments, followed by any number of ",
  StyleBox["b", "MR"],
  " arguments. "
}], "MathCaption",
  CellTags->{"S2.3.11", "11.4"}],

Cell[CellGroupData[{

Cell["\<\
Cases[{ f[a], f[a, a, b], f[a, b, a], f[a, b, b] }, f[a.., \
b..]]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.11"],

Cell[BoxData[
    \({f[a, a, b], f[a, b, b]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.11"]
}, Open  ]],

Cell[TextData[{
  "Here each argument can be either ",
  StyleBox["a", "MR"],
  " or\[NonBreakingSpace]",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.11", "11.5"}],

Cell[CellGroupData[{

Cell["Cases[{ f[a], f[a, b, a], f[a, c, a] }, f[(a | b)..]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.11"],

Cell[BoxData[
    \({f[a], f[a, b, a]}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.3.11"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["..", "MR"],
  " and ",
  StyleBox["...", "MR"],
  " to represent repetitions of any pattern. If the pattern contains named \
parts, then each instance of these parts must be identical. "
}], "Text",
  CellTags->{"S2.3.11", "11.6"}],

Cell["\<\
This defines a function whose argument must consist of a list of \
pairs. \
\>", "MathCaption",
  CellTags->{"S2.3.11", "11.7"}],

Cell["v[x:{{_, _}..}] := Transpose[x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.11"],

Cell["The definition applies in this case. ", "MathCaption",
  CellTags->{"S2.3.11", "11.8"}],

Cell[CellGroupData[{

Cell["v[{{a1, b1}, {a2, b2}, {a3, b3}}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.11"],

Cell[BoxData[
    \({{a1, a2, a3}, {b1, b2, b3}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.11"]
}, Open  ]],

Cell["\<\
With this definition, the second elements of all the pairs must be \
the same. \
\>", "MathCaption",
  CellTags->{"S2.3.11", "11.9"}],

Cell["vn[x:{{_, n_}..}] := Transpose[x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.11"],

Cell["The definition applies in this case. ", "MathCaption",
  CellTags->{"S2.3.11", "11.10"}],

Cell[CellGroupData[{

Cell["vn[{{a, 2}, {b, 2}, {c, 2}}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.11"],

Cell[BoxData[
    \({{a, b, c}, {2, 2, 2}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.3.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.12 Verbatim Patterns", "Subsection",
  CellTags->{"S2.3.12", "12.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Verbatim[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["an expression that must be matched verbatim "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.12"],

Cell["Verbatim patterns. ", "Caption",
  CellTags->"S2.3.12"],

Cell[TextData[{
  "Here the ",
  StyleBox["x_", "MR"],
  " in the rule matches any expression. "
}], "MathCaption",
  CellTags->{"S2.3.12", "12.2"}],

Cell[CellGroupData[{

Cell["{f[2], f[a], f[x_], f[y_]} /. f[x_] -> x^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.12"],

Cell[BoxData[
    \({4, a\^2, x_\^2, y_\^2}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.3.12"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Verbatim", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " that only the exact expression ",
  StyleBox["x_", "MR"],
  " should be matched. "
}], "MathCaption",
  CellTags->{"S2.3.12", "12.3"}],

Cell[CellGroupData[{

Cell["{f[2], f[a], f[x_], f[y_]} /. f[Verbatim[x_]] -> x^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.12"],

Cell[BoxData[
    \({f[2], f[a], x\^2, f[y_]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.13 Patterns for Some Common Types of Expression", "Subsection",
  CellTags->{"S2.3.13", "13.1"}],

Cell[TextData[{
  "Using the objects described above, you can set up patterns for many kinds \
of expressions. In all cases, you must remember that the patterns must \
represent the structure of the expressions in ",
  StyleBox["Mathematica", "TI"],
  " internal form, as shown by ",
  StyleBox["FullForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.13", "13.2"}],

Cell[TextData[{
  "Especially for some common kinds of expressions, the standard output \
format used by ",
  StyleBox["Mathematica", "TI"],
  " is not particularly close to the full internal form. But it is the \
internal form that you must use in setting up patterns. "
}], "Text",
  CellTags->{"S2.3.13", "13.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["n", "TI"],
              StyleBox["_Integer", "MR"],
              " "
            }]], Cell[TextData[{
              "an integer ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["n",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_Real", "MR"],
              " "
            }]], Cell[TextData[{
              "an approximate real number ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["z", "TI"],
              StyleBox["_Complex", "MR"],
              " "
            }]], Cell[TextData[{
              "a complex number ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["z",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Complex[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["_]", "MR"],
              " "
            }]], Cell[TextData[{
              "a complex number ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["x",
                        "TI"], "+", 
                      StyleBox["i",
                        "TI"], 
                      StyleBox["y",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Complex[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_Integer,", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["_Integer]", "MR"],
              " "
            }]], 
            Cell["\<\
a complex number where both real and imaginary parts \
are integers \
\>"]},
          {Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["r", "TI"],
              StyleBox["_Rational", "MR"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["_Integer)", "MR"],
              " "
            }]], Cell[TextData[{
              "rational number or integer ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["r",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Rational[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["_,", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["_]", "MR"],
              " "
            }]], Cell[TextData[{
              "a rational number ",
              Cell[BoxData[
                  FormBox[
                    FractionBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["d",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["NumberQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["Im[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]==0)", "MR"],
              " "
            }]], Cell["a real number of any kind "]},
          {Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["NumberQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["])", "MR"],
              " "
            }]], Cell["a number of any kind "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.13"],

Cell["Some typical patterns for numbers. ", "Caption",
  CellTags->"S2.3.13"],

Cell["Here are the full forms of some numbers. ", "MathCaption",
  CellTags->{"S2.3.13", "13.4"}],

Cell[CellGroupData[{

Cell["{2, 2.5, 2.5 + I, 2/7} // FullForm", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[2, 2.5`, Complex[2.5`, 1], Rational[2, 7]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell["The rule picks out each piece of the complex numbers. ", "MathCaption",
  CellTags->{"S2.3.13", "13.5"}],

Cell[CellGroupData[{

Cell["{2.5 - I, 3 + I} /. Complex[x_, y_] -> p[x, y]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    \({p[2.5`, \(-1\)], p[3, 1]}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell[TextData[{
  "The fact that these expressions have different full forms means that you \
cannot use ",
  StyleBox["x", "TI"],
  StyleBox["_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["I", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["_", "MR"],
  " to match a complex number. "
}], "MathCaption",
  CellTags->{"S2.3.13", "13.6"}],

Cell[CellGroupData[{

Cell["{2.5 - I, x + I y} // FullForm", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[Complex[2.5`, \(-1\)], 
          Plus[x, Times[Complex[0, 1], y]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell["\<\
The pattern here matches both ordinary integers, and complex \
numbers where both the real and imaginary parts are integers. \
\>", \
"MathCaption",
  CellTags->{"S2.3.13", "13.7"}],

Cell[CellGroupData[{

Cell["\<\
Cases[ {2.5 - I, 2, 3 + I, 2 - 0.5 I, 2 + 2 I}, _Integer | \
Complex[_Integer, _Integer] ]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    \({2, 3 + \[ImaginaryI], 2 + 2\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["1.4.1",
    ButtonData:>{"1.4.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " puts all algebraic expressions into a standard form, in which they are \
written essentially as a sum of products of powers. In addition, ratios are \
converted into products of powers, with denominator terms having negative \
exponents, and differences are converted into sums with negated terms. To \
construct patterns for algebraic expressions, you must use this standard \
form. This form often differs from the way ",
  StyleBox["Mathematica", "TI"],
  " prints out the algebraic expressions. But in all cases, you can find the \
full internal form using ",
  StyleBox["FullForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.3.13", "13.8"}],

Cell["Here is a typical algebraic expression. ", "MathCaption",
  CellTags->{"S2.3.13", "13.9"}],

Cell[CellGroupData[{

Cell["-1/z^2 - z/y + 2 (x z)^2 y", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    \(\(-\(1\/z\^2\)\) - z\/y + 2\ x\^2\ y\ z\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell["This is the full internal form of the expression. ", "MathCaption",
  CellTags->{"S2.3.13", "13.10"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[Times[\(-1\), Power[z, \(-2\)]], 
          Times[\(-1\), Power[y, \(-1\)], z], 
          Times[2, Power[x, 2], y, Power[z, 2]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[6]//FullForm= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell["\<\
This is what you get by applying a transformation rule to all \
powers in the expression. \
\>", "MathCaption",
  CellTags->{"S2.3.13", "13.11"}],

Cell[CellGroupData[{

Cell["% /. x_^n_ -> e[x, n]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    \(\(-z\)\ e[y, \(-1\)] - e[z, \(-2\)] + 
      2\ y\ e[x, 2]\ e[z, 2]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell["a sum of two or more terms "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["_.", "MR"],
              " "
            }]], Cell["a single term or a sum of terms "]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              StyleBox["_Integer", "MR"],
              "  ",
              StyleBox["x_", "MR"],
              " "
            }]], Cell["an expression with an explicit integer multiplier "]},
          {Cell[TextData[{
              StyleBox["a", "TI"],
              StyleBox["_.", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["_.", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              "a linear expression ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["a",
                        "TI"], "+", 
                      StyleBox["b",
                        "TI"], 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["_", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " with ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "\[NotEqual]", "0", \(\(,\)\(\ \)\), "1"}], 
                    TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["_.", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SuperscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["n",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " with ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "\[NotEqual]", "0"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["a", "TI"],
              StyleBox["_.", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["_.", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["_.", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["_^2", "MR"],
              " "
            }]], 
            Cell["\<\
a quadratic expression with non\[Hyphen]zero linear \
term\
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.13"],

Cell["Some typical patterns for algebraic expressions. ", "Caption",
  CellTags->"S2.3.13"],

Cell[TextData[{
  "This pattern picks out linear functions of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.13", "13.12"}],

Cell[CellGroupData[{

Cell["{1, a, x, 2 x, 1 + 2 x} /. a_. + b_. x -> p[a, b]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    \({1, a, p[0, 1], p[0, 2], p[1, 2]}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_List", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["x", "TI"],
              StyleBox[":{___}", "MR"],
              " "
            }]], Cell["a list "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_List", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["VectorQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a vector containing no sublists "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_List", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["VectorQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumberQ]", "MR"],
              " "
            }]], Cell["a vector of numbers "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox[":{___List}", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["x", "TI"],
              StyleBox[":{{___}...}", "MR"],
              " "
            }]], Cell["a list of lists "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_List", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["MatrixQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a matrix containing no sublists "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_List", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["MatrixQ[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["NumberQ]", "MR"],
              " "
            }]], Cell["a matrix of numbers "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox[":{{_,", "MR"],
              " ",
              StyleBox["_}...}", "MR"],
              " "
            }]], Cell["a list of pairs "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.3.13"],

Cell["Some typical patterns for lists. ", "Caption",
  CellTags->"S2.3.13"],

Cell["\<\
This defines a function whose argument must be a list containing \
lists with either one or two elements. \
\>", "MathCaption",
  CellTags->{"S2.3.13", "13.13"}],

Cell["h[x:{ ({_} | {_, _})... }] := q", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.13"],

Cell["The definition applies in the second and third cases. ", "MathCaption",
  CellTags->{"S2.3.13", "13.14"}],

Cell[CellGroupData[{

Cell["{h[{a, b}], h[{{a}, {b}}], h[{{a}, {b, c}}]}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.3.13"],

Cell[BoxData[
    \({h[{a, b}], q, q}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.3.13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.3.14 An Example: Defining Your Own Integration Function", "Subsection",
  CellTags->{"S2.3.14", "14.1"}],

Cell[TextData[{
  "Now that we have introduced the basic features of patterns in ",
  StyleBox["Mathematica", "TI"],
  ", we can use them to give a more or less complete example. We will show \
how you could define your own simple integration function in ",
  StyleBox["Mathematica", "TI"],
  ".    "
}], "Text",
  CellTags->{"S2.3.14", "14.2"}],

Cell[TextData[{
  "From a mathematical point of view, the integration function is defined by \
a sequence of mathematical relations. By setting up transformation rules for \
patterns, you can implement these mathematical relations quite directly in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.3.14", "14.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["mathematical form", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["Mathematica", "TI"],
              StyleBox[" definition", "SO10"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      RowBox[{"(", 
                        RowBox[{
                          StyleBox["y",
                            "TI"], "+", 
                          StyleBox["z",
                            "TI"]}], ")"}], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "=", "\[Integral]", 
                      StyleBox["y",
                        "TI"], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "+", "\[Integral]", 
                      StyleBox["z",
                        "TI"], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["integrate[y_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["z_,", "MR"],
              " ",
              StyleBox["x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " \n     ",
              StyleBox["integrate[y,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["integrate[z,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      StyleBox["c",
                        "TI"], " ", 
                      StyleBox["y",
                        "TI"], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "=", 
                      StyleBox["c",
                        "TI"], "\[Integral]", 
                      StyleBox["y",
                        "TI"], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " (",
              Cell[BoxData[
                  FormBox[
                    StyleBox["c",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " independent of ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ") "
            }]], Cell[TextData[{
              StyleBox["integrate[c_", "MR"],
              " ",
              StyleBox["y_,", "MR"],
              " ",
              StyleBox["x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " \n     ",
              StyleBox["c", "MR"],
              " ",
              StyleBox["integrate[y,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["FreeQ[c,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      StyleBox["c",
                        "TI"], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "=", 
                      StyleBox["c",
                        "TI"], " ", 
                      StyleBox["x",
                        "TI"]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["integrate[c_,", "MR"],
              " ",
              StyleBox["x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["c", "MR"],
              " ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["FreeQ[c,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      SuperscriptBox[
                        StyleBox["x",
                          "TI"], 
                        StyleBox["n",
                          "TI"]], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "=", 
                      FractionBox[
                        SuperscriptBox[
                          StyleBox["x",
                            "TI"], 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["n",
                                "TI"], "+", "1"}], ")"}]], 
                        RowBox[{
                          StyleBox["n",
                            "TI"], "+", "1"}]]}], TraditionalForm]], 
                "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        "TI"], "\[NotEqual]", "-", "1"}], TraditionalForm]], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["integrate[x_^n_.,", "MR"],
              " ",
              StyleBox["x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["x^(n+1)/(n+1)", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " \n     ",
              StyleBox["FreeQ[n,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["n", "MR"],
              " ",
              StyleBox["!=", "MR"],
              " ",
              StyleBox["-1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      FractionBox["1", 
                        RowBox[{
                          StyleBox["a",
                            "TI"], 
                          StyleBox["x",
                            "TI"], "+", 
                          StyleBox["b",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "=", 
                      FractionBox[
                        RowBox[{"log", 
                          RowBox[{"(", 
                            RowBox[{
                              StyleBox["a",
                                "TI"], 
                              StyleBox["x",
                                "TI"], "+", 
                              StyleBox["b",
                                "TI"]}], ")"}]}], 
                        StyleBox["a",
                          "TI"]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["integrate[1/(a_.", "MR"],
              " ",
              StyleBox["x_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b_.),", "MR"],
              " ",
              StyleBox["x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " \n     ",
              StyleBox["Log[a", "MR"],
              " ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b]/a", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["FreeQ[{a,b},", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{"\[Integral]", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["a",
                            "TI"], 
                          StyleBox["x",
                            "TI"], "+", 
                          StyleBox["b",
                            "TI"]}]], "\[DifferentialD]", 
                      StyleBox["x",
                        "TI"], "=", 
                      FractionBox["1", 
                        StyleBox["a",
                          "TI"]], " ", 
                      SuperscriptBox[
                        StyleBox["e",
                          "TI"], 
                        RowBox[{
                          StyleBox["a",
                            "TI"], 
                          StyleBox["x",
                            "TI"], "+", 
                          StyleBox["b",
                            "TI"]}]]}], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["integrate[Exp[a_.", "MR"],
              " ",
              StyleBox["x_", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b_.],", "MR"],
              " ",
              StyleBox["x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " \n     ",
              StyleBox["Exp[a", "MR"],
              " ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["b]/a", "MR"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["FreeQ[{a,b},", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.3.14"],

Cell["Definitions for an integration function. ", "Caption",
  CellTags->"S2.3.14"],

Cell[TextData[{
  "This implements the linearity relation for integrals: ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{"(", 
            RowBox[{
              StyleBox["y",
                "TI"], "+", 
              StyleBox["z",
                "TI"]}], ")"}], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], "=", "\[Integral]", 
          StyleBox["y",
            "TI"], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], "+", "\[Integral]", 
          StyleBox["z",
            "TI"], "\[DifferentialD]", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.4"}],

Cell["integrate[y_ + z_, x_] := integrate[y, x] + integrate[z, x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.3.14"],

Cell[TextData[{
  "The associativity of ",
  StyleBox["Plus", "MR"],
  " makes the linearity relation work with any number of terms in the sum. "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.5"}],

Cell[CellGroupData[{

Cell["integrate[a x + b x^2 + 3, x]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(integrate[3, x] + integrate[a\ x, x] + 
      integrate[b\ x\^2, x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell[TextData[{
  "This makes ",
  StyleBox["integrate", "MR"],
  " pull out factors that are independent of the integration variable ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.6"}],

Cell["integrate[c_ y_, x_] := c integrate[y, x] /; FreeQ[c, x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.3.14"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " tests each term in each product to see whether it satisfies the ",
  StyleBox["FreeQ", "MR"],
  " condition, and so can be pulled out. "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.7"}],

Cell[CellGroupData[{

Cell["integrate[a x + b x^2 + 3, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(integrate[3, x] + a\ integrate[x, x] + 
      b\ integrate[x\^2, x]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell[TextData[{
  "This gives the integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          StyleBox["c",
            "TI"], "\[DifferentialD]", 
          StyleBox["x",
            "TI"], "=", 
          StyleBox["c",
            "TI"], " ", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  " of a constant. "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.8"}],

Cell["integrate[c_, x_] := c x /; FreeQ[c, x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.3.14"],

Cell["Now the constant term in the sum can be integrated. ", "MathCaption",
  CellTags->{"S2.3.14", "14.9"}],

Cell[CellGroupData[{

Cell["integrate[a x + b x^2 + 3, x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(3\ x + a\ integrate[x, x] + b\ integrate[x\^2, x]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell[TextData[{
  "This gives the standard formula for the integral of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], 
          StyleBox["n",
            "TI"]], TraditionalForm]], "InlineFormula"],
  ". By using the pattern ",
  StyleBox["x_^n_.", "MR"],
  ", rather than ",
  StyleBox["x_^n_", "MR"],
  ", we include the case of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox[
            StyleBox["x",
              "TI"], "1"], "=", 
          StyleBox["x",
            "TI"]}], TraditionalForm]], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.10"}],

Cell["\<\
integrate[x_^n_., x_] := x^(n+1)/(n+1) /; FreeQ[n, x] && n != \
-1\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.3.14"],

Cell["Now this integral can be done completely. ", "MathCaption",
  CellTags->{"S2.3.14", "14.11"}],

Cell[CellGroupData[{

Cell["integrate[a x + b x^2 + 3, x]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(3\ x + \(a\ x\^2\)\/2 + \(b\ x\^3\)\/3\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell[TextData[{
  "Of course, the built\[Hyphen]in integration function ",
  StyleBox["Integrate", "MR"],
  " (with a capital ",
  StyleBox["I", "MR"],
  ") could have done the integral anyway. "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.12"}],

Cell[CellGroupData[{

Cell["Integrate[a x + b x^2 + 3, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(3\ x + \(a\ x\^2\)\/2 + \(b\ x\^3\)\/3\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell[TextData[{
  "Here is the rule for integrating the reciprocal of a linear function. The \
pattern ",
  StyleBox["a_.", "MR"],
  " ",
  StyleBox["x_", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b_.", "MR"],
  " stands for any linear function of ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.13"}],

Cell["\<\
integrate[1/(a_. x_ + b_.), x_] := Log[a x + b]/a /; FreeQ[{a,b}, \
x]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.3.14"],

Cell[TextData[{
  "Here both ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  " take on their default values. "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.14"}],

Cell[CellGroupData[{

Cell["integrate[1/x, x]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(Log[x]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell[TextData[{
  "Here is a more complicated case. The symbol ",
  StyleBox["a", "MR"],
  " now matches ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["p", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.3.14", "14.15"}],

Cell[CellGroupData[{

Cell["integrate[1/(2 p x - 1), x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.3.14"],

Cell[BoxData[
    \(Log[\(-1\) + 2\ p\ x]\/\(2\ p\)\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.3.14"]
}, Open  ]],

Cell["\<\
You can go on and add many more rules for integration. Here is a \
rule for integrating exponentials. \
\>", "MathCaption",
  CellTags->{"S2.3.14", "14.16"}],

Cell["\<\
integrate[Exp[a_. x_ + b_.], x_] := Exp[a x + b]/a /; FreeQ[{a,b}, \
x]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.3.14"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{140, Automatic}, {28, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.3.0"->{
    Cell[1776, 53, 111, 4, 65, "Section",
      CellTags->{"S2.3.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 111, 4, 65, "Section",
      CellTags->{"S2.3.0", "0.1"}]},
  "S2.3.1"->{
    Cell[1912, 61, 71, 1, 70, "Subsection",
      CellTags->{"S2.3.1", "1.1"}],
    Cell[1986, 64, 402, 12, 70, "Text",
      CellTags->{"S2.3.1", "1.2"}],
    Cell[2391, 78, 290, 6, 70, "Text",
      CellTags->{"S2.3.1", "1.3"}],
    Cell[2684, 86, 170, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.4"}],
    Cell[2879, 94, 91, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[2973, 98, 92, 3, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[3080, 104, 149, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.5"}],
    Cell[3254, 112, 99, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[3356, 116, 91, 3, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[3462, 122, 601, 18, 70, "Text",
      CellTags->{"S2.3.1", "1.6"}],
    Cell[4066, 142, 616, 20, 70, "Text",
      CellTags->{"S2.3.1", "1.7"}],
    Cell[4685, 164, 264, 6, 70, "Text",
      CellTags->{"S2.3.1", "1.8"}],
    Cell[4952, 172, 2032, 66, 70, "DefinitionBox",
      CellTags->"S2.3.1"],
    Cell[6987, 240, 68, 1, 70, "Caption",
      CellTags->"S2.3.1"],
    Cell[7058, 243, 127, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.9"}],
    Cell[7210, 251, 107, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[7320, 255, 96, 3, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[7431, 261, 947, 23, 70, "Text",
      CellTags->{"S2.3.1", "1.10"}],
    Cell[8381, 286, 215, 5, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.11"}],
    Cell[8599, 293, 105, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[8707, 297, 138, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.12"}],
    Cell[8848, 303, 84, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[8935, 307, 660, 14, 70, "Text",
      CellTags->{"S2.3.1", "1.13"}],
    Cell[9598, 323, 1049, 51, 70, "Text",
      CellTags->{"S2.3.1", "1.14"}],
    Cell[10650, 376, 373, 10, 70, "Text",
      CellTags->{"S2.3.1", "1.15"}],
    Cell[11026, 388, 943, 33, 70, "Text",
      CellTags->{"S2.3.1", "1.16"}],
    Cell[11972, 423, 658, 19, 70, "Text",
      CellTags->{"S2.3.1", "1.17"}],
    Cell[12633, 444, 510, 21, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.18"}],
    Cell[13168, 469, 96, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[13267, 473, 99, 3, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[13381, 479, 858, 28, 70, "Text",
      CellTags->{"S2.3.1", "1.19"}],
    Cell[14242, 509, 200, 5, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.20"}],
    Cell[14467, 518, 99, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[14569, 522, 120, 3, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[14704, 528, 90, 1, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.21"}],
    Cell[14819, 533, 93, 2, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[14915, 537, 322, 9, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[15252, 549, 603, 18, 70, "Text",
      CellTags->{"S2.3.1", "1.22"}],
    Cell[15858, 569, 208, 5, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.23"}],
    Cell[16091, 578, 140, 5, 70, "Input",
      CellTags->"S2.3.1"],
    Cell[16234, 585, 99, 3, 70, "Output",
      CellTags->"S2.3.1"],
    Cell[16348, 591, 381, 9, 70, "Text",
      CellTags->{"S2.3.1", "1.24"}]},
  "1.1"->{
    Cell[1912, 61, 71, 1, 70, "Subsection",
      CellTags->{"S2.3.1", "1.1"}]},
  "1.2"->{
    Cell[1986, 64, 402, 12, 70, "Text",
      CellTags->{"S2.3.1", "1.2"}]},
  "1.3"->{
    Cell[2391, 78, 290, 6, 70, "Text",
      CellTags->{"S2.3.1", "1.3"}]},
  "1.4"->{
    Cell[2684, 86, 170, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.4"}]},
  "1.5"->{
    Cell[3080, 104, 149, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.5"}]},
  "1.6"->{
    Cell[3462, 122, 601, 18, 70, "Text",
      CellTags->{"S2.3.1", "1.6"}]},
  "1.7"->{
    Cell[4066, 142, 616, 20, 70, "Text",
      CellTags->{"S2.3.1", "1.7"}]},
  "1.8"->{
    Cell[4685, 164, 264, 6, 70, "Text",
      CellTags->{"S2.3.1", "1.8"}]},
  "1.9"->{
    Cell[7058, 243, 127, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.9"}]},
  "1.10"->{
    Cell[7431, 261, 947, 23, 70, "Text",
      CellTags->{"S2.3.1", "1.10"}]},
  "1.11"->{
    Cell[8381, 286, 215, 5, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.11"}]},
  "1.12"->{
    Cell[8707, 297, 138, 4, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.12"}]},
  "1.13"->{
    Cell[8935, 307, 660, 14, 70, "Text",
      CellTags->{"S2.3.1", "1.13"}]},
  "1.14"->{
    Cell[9598, 323, 1049, 51, 70, "Text",
      CellTags->{"S2.3.1", "1.14"}]},
  "1.15"->{
    Cell[10650, 376, 373, 10, 70, "Text",
      CellTags->{"S2.3.1", "1.15"}]},
  "1.16"->{
    Cell[11026, 388, 943, 33, 70, "Text",
      CellTags->{"S2.3.1", "1.16"}]},
  "1.17"->{
    Cell[11972, 423, 658, 19, 70, "Text",
      CellTags->{"S2.3.1", "1.17"}]},
  "1.18"->{
    Cell[12633, 444, 510, 21, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.18"}]},
  "1.19"->{
    Cell[13381, 479, 858, 28, 70, "Text",
      CellTags->{"S2.3.1", "1.19"}]},
  "1.20"->{
    Cell[14242, 509, 200, 5, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.20"}]},
  "1.21"->{
    Cell[14704, 528, 90, 1, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.21"}]},
  "1.22"->{
    Cell[15252, 549, 603, 18, 70, "Text",
      CellTags->{"S2.3.1", "1.22"}]},
  "1.23"->{
    Cell[15858, 569, 208, 5, 70, "MathCaption",
      CellTags->{"S2.3.1", "1.23"}]},
  "1.24"->{
    Cell[16348, 591, 381, 9, 70, "Text",
      CellTags->{"S2.3.1", "1.24"}]},
  "S2.3.2"->{
    Cell[16766, 605, 99, 1, 70, "Subsection",
      CellTags->{"S2.3.2", "2.1"}],
    Cell[16868, 608, 2850, 90, 70, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[19721, 700, 80, 1, 70, "Caption",
      CellTags->"S2.3.2"],
    Cell[19804, 703, 163, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.2"}],
    Cell[19992, 712, 97, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[20092, 716, 93, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[20200, 722, 126, 4, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.3"}],
    Cell[20351, 730, 97, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[20451, 734, 82, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[20548, 740, 254, 6, 70, "Text",
      CellTags->{"S2.3.2", "2.4"}],
    Cell[20805, 748, 2633, 81, 70, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[23441, 831, 98, 1, 70, "Caption",
      CellTags->"S2.3.2"],
    Cell[23542, 834, 138, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.5"}],
    Cell[23705, 843, 102, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[23810, 847, 87, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[23912, 853, 196, 6, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.6"}],
    Cell[24133, 863, 111, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[24247, 867, 93, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[24355, 873, 1511, 48, 70, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[25869, 923, 85, 1, 70, "Caption",
      CellTags->"S2.3.2"],
    Cell[25957, 926, 176, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.7"}],
    Cell[26158, 935, 119, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[26280, 939, 94, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[26389, 945, 333, 12, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.8"}],
    Cell[26747, 961, 113, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[26863, 965, 108, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[26986, 971, 1307, 41, 70, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[28296, 1014, 93, 1, 70, "Caption",
      CellTags->"S2.3.2"],
    Cell[28392, 1017, 142, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.9"}],
    Cell[28559, 1026, 104, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[28666, 1030, 90, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[28771, 1036, 105, 1, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.10"}],
    Cell[28901, 1041, 118, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[29022, 1045, 90, 3, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[29127, 1051, 780, 25, 70, "DefinitionBox",
      CellTags->"S2.3.2"],
    Cell[29910, 1078, 101, 1, 70, "Caption",
      CellTags->"S2.3.2"],
    Cell[30014, 1081, 127, 4, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.11"}],
    Cell[30166, 1089, 106, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[30275, 1093, 166, 4, 70, "Output",
      CellTags->"S2.3.2"],
    Cell[30456, 1100, 196, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.12"}],
    Cell[30677, 1109, 124, 2, 70, "Input",
      CellTags->"S2.3.2"],
    Cell[30804, 1113, 91, 3, 70, "Output",
      CellTags->"S2.3.2"]},
  "2.1"->{
    Cell[16766, 605, 99, 1, 70, "Subsection",
      CellTags->{"S2.3.2", "2.1"}]},
  "2.2"->{
    Cell[19804, 703, 163, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.2"}]},
  "2.3"->{
    Cell[20200, 722, 126, 4, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.3"}]},
  "2.4"->{
    Cell[20548, 740, 254, 6, 70, "Text",
      CellTags->{"S2.3.2", "2.4"}]},
  "2.5"->{
    Cell[23542, 834, 138, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.5"}]},
  "2.6"->{
    Cell[23912, 853, 196, 6, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.6"}]},
  "2.7"->{
    Cell[25957, 926, 176, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.7"}]},
  "2.8"->{
    Cell[26389, 945, 333, 12, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.8"}]},
  "2.9"->{
    Cell[28392, 1017, 142, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.9"}]},
  "2.10"->{
    Cell[28771, 1036, 105, 1, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.10"}]},
  "2.11"->{
    Cell[30014, 1081, 127, 4, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.11"}]},
  "2.12"->{
    Cell[30456, 1100, 196, 5, 70, "MathCaption",
      CellTags->{"S2.3.2", "2.12"}]},
  "S2.3.3"->{
    Cell[30944, 1122, 84, 1, 70, "Subsection",
      CellTags->{"S2.3.3", "3.1"}],
    Cell[31031, 1125, 416, 10, 70, "Text",
      CellTags->{"S2.3.3", "3.2"}],
    Cell[31450, 1137, 349, 10, 70, "Text",
      CellTags->{"S2.3.3", "3.3"}],
    Cell[31802, 1149, 595, 24, 70, "Text",
      CellTags->{"S2.3.3", "3.4"}],
    Cell[32400, 1175, 190, 6, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.5"}],
    Cell[32615, 1185, 103, 2, 70, "Input",
      CellTags->"S2.3.3"],
    Cell[32721, 1189, 96, 3, 70, "Output",
      CellTags->"S2.3.3"],
    Cell[32832, 1195, 533, 13, 70, "Text",
      CellTags->{"S2.3.3", "3.6"}],
    Cell[33368, 1210, 966, 31, 70, "DefinitionBox",
      CellTags->"S2.3.3"],
    Cell[34337, 1243, 62, 1, 70, "Caption",
      CellTags->"S2.3.3"],
    Cell[34402, 1246, 236, 6, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.7"}],
    Cell[34663, 1256, 90, 2, 70, "Input",
      CellTags->"S2.3.3"],
    Cell[34756, 1260, 88, 3, 70, "Output",
      CellTags->"S2.3.3"],
    Cell[34859, 1266, 185, 7, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.8"}],
    Cell[35069, 1277, 94, 2, 70, "Input",
      CellTags->"S2.3.3"],
    Cell[35166, 1281, 91, 3, 70, "Output",
      CellTags->"S2.3.3"],
    Cell[35272, 1287, 222, 5, 70, "Text",
      CellTags->{"S2.3.3", "3.9"}],
    Cell[35497, 1294, 92, 1, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.10"}],
    Cell[35614, 1299, 116, 2, 70, "Input",
      CellTags->"S2.3.3"],
    Cell[35733, 1303, 87, 3, 70, "Output",
      CellTags->"S2.3.3"],
    Cell[35835, 1309, 188, 5, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.11"}],
    Cell[36048, 1318, 119, 2, 70, "Input",
      CellTags->"S2.3.3"],
    Cell[36170, 1322, 105, 3, 70, "Output",
      CellTags->"S2.3.3"]},
  "3.1"->{
    Cell[30944, 1122, 84, 1, 70, "Subsection",
      CellTags->{"S2.3.3", "3.1"}]},
  "3.2"->{
    Cell[31031, 1125, 416, 10, 70, "Text",
      CellTags->{"S2.3.3", "3.2"}]},
  "3.3"->{
    Cell[31450, 1137, 349, 10, 70, "Text",
      CellTags->{"S2.3.3", "3.3"}]},
  "3.4"->{
    Cell[31802, 1149, 595, 24, 70, "Text",
      CellTags->{"S2.3.3", "3.4"}]},
  "3.5"->{
    Cell[32400, 1175, 190, 6, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.5"}]},
  "3.6"->{
    Cell[32832, 1195, 533, 13, 70, "Text",
      CellTags->{"S2.3.3", "3.6"}]},
  "3.7"->{
    Cell[34402, 1246, 236, 6, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.7"}]},
  "3.8"->{
    Cell[34859, 1266, 185, 7, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.8"}]},
  "3.9"->{
    Cell[35272, 1287, 222, 5, 70, "Text",
      CellTags->{"S2.3.3", "3.9"}]},
  "3.10"->{
    Cell[35497, 1294, 92, 1, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.10"}]},
  "3.11"->{
    Cell[35835, 1309, 188, 5, 70, "MathCaption",
      CellTags->{"S2.3.3", "3.11"}]},
  "S2.3.4"->{
    Cell[36324, 1331, 101, 1, 70, "Subsection",
      CellTags->{"S2.3.4", "4.1"}],
    Cell[36428, 1334, 332, 9, 70, "Text",
      CellTags->{"S2.3.4", "4.2"}],
    Cell[36763, 1345, 438, 16, 70, "Text",
      CellTags->{"S2.3.4", "4.3"}],
    Cell[37204, 1363, 1314, 41, 70, "DefinitionBox",
      CellTags->"S2.3.4"],
    Cell[38521, 1406, 84, 1, 70, "Caption",
      CellTags->"S2.3.4"],
    Cell[38608, 1409, 107, 1, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.4"}],
    Cell[38740, 1414, 97, 2, 70, "Input",
      CellTags->"S2.3.4"],
    Cell[38840, 1418, 99, 3, 70, "Output",
      CellTags->"S2.3.4"],
    Cell[38954, 1424, 325, 10, 70, "Text",
      CellTags->{"S2.3.4", "4.5"}],
    Cell[39282, 1436, 175, 5, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.6"}],
    Cell[39460, 1443, 92, 2, 70, "Input",
      CellTags->"S2.3.4"],
    Cell[39555, 1447, 168, 5, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.7"}],
    Cell[39748, 1456, 83, 2, 70, "Input",
      CellTags->"S2.3.4"],
    Cell[39834, 1460, 93, 3, 70, "Output",
      CellTags->"S2.3.4"],
    Cell[39942, 1466, 189, 7, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.8"}],
    Cell[40156, 1477, 73, 2, 70, "Input",
      CellTags->"S2.3.4"],
    Cell[40232, 1481, 91, 3, 70, "Output",
      CellTags->"S2.3.4"],
    Cell[40338, 1487, 116, 2, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.9"}],
    Cell[40457, 1491, 92, 2, 70, "Input",
      CellTags->"S2.3.4"],
    Cell[40552, 1495, 126, 4, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.10"}],
    Cell[40703, 1503, 96, 2, 70, "Input",
      CellTags->"S2.3.4"],
    Cell[40802, 1507, 117, 3, 70, "Output",
      CellTags->"S2.3.4"]},
  "4.1"->{
    Cell[36324, 1331, 101, 1, 70, "Subsection",
      CellTags->{"S2.3.4", "4.1"}]},
  "4.2"->{
    Cell[36428, 1334, 332, 9, 70, "Text",
      CellTags->{"S2.3.4", "4.2"}]},
  "4.3"->{
    Cell[36763, 1345, 438, 16, 70, "Text",
      CellTags->{"S2.3.4", "4.3"}]},
  "4.4"->{
    Cell[38608, 1409, 107, 1, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.4"}]},
  "4.5"->{
    Cell[38954, 1424, 325, 10, 70, "Text",
      CellTags->{"S2.3.4", "4.5"}]},
  "4.6"->{
    Cell[39282, 1436, 175, 5, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.6"}]},
  "4.7"->{
    Cell[39555, 1447, 168, 5, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.7"}]},
  "4.8"->{
    Cell[39942, 1466, 189, 7, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.8"}]},
  "4.9"->{
    Cell[40338, 1487, 116, 2, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.9"}]},
  "4.10"->{
    Cell[40552, 1495, 126, 4, 70, "MathCaption",
      CellTags->{"S2.3.4", "4.10"}]},
  "S2.3.5"->{
    Cell[40968, 1516, 90, 1, 70, "Subsection",
      CellTags->{"S2.3.5", "5.1"}],
    Cell[41061, 1519, 639, 16, 70, "Text",
      CellTags->{"S2.3.5", "5.2"}],
    Cell[41703, 1537, 1334, 44, 70, "DefinitionBox",
      CellTags->"S2.3.5"],
    Cell[43040, 1583, 98, 1, 70, "Caption",
      CellTags->"S2.3.5"],
    Cell[43141, 1586, 209, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.3"}],
    Cell[43353, 1595, 86, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[43442, 1599, 165, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.4"}],
    Cell[43632, 1608, 80, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[43715, 1612, 98, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[43828, 1618, 100, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.5"}],
    Cell[43953, 1623, 98, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[44054, 1627, 97, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[44166, 1633, 854, 28, 70, "Text",
      CellTags->{"S2.3.5", "5.6"}],
    Cell[45023, 1663, 193, 6, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.7"}],
    Cell[45219, 1671, 87, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[45309, 1675, 149, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.8"}],
    Cell[45483, 1683, 82, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[45568, 1687, 99, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[45682, 1693, 442, 10, 70, "Text",
      CellTags->{"S2.3.5", "5.9"}],
    Cell[46127, 1705, 260, 11, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.10"}],
    Cell[46390, 1718, 85, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[46478, 1722, 133, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.11"}],
    Cell[46636, 1730, 79, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[46718, 1734, 88, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[46821, 1740, 195, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.12"}],
    Cell[47041, 1749, 72, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[47116, 1753, 93, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[47224, 1759, 370, 17, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.13"}],
    Cell[47597, 1778, 95, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[47695, 1782, 99, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.14"}],
    Cell[47819, 1787, 73, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[47895, 1791, 86, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[47996, 1797, 1347, 38, 70, "Text",
      CellTags->{"S2.3.5", "5.15"}],
    Cell[49346, 1837, 907, 45, 70, "Text",
      CellTags->{"S2.3.5", "5.16"}],
    Cell[50256, 1884, 478, 11, 70, "Text",
      CellTags->{"S2.3.5", "5.17"}],
    Cell[50737, 1897, 235, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.18"}],
    Cell[50997, 1908, 121, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[51121, 1912, 110, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[51246, 1918, 168, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.19"}],
    Cell[51439, 1927, 116, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[51558, 1931, 107, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[51680, 1937, 550, 13, 70, "Text",
      CellTags->{"S2.3.5", "5.20"}],
    Cell[52233, 1952, 4944, 146, 70, "DefinitionBox",
      CellTags->"S2.3.5"],
    Cell[57180, 2100, 118, 4, 70, "Caption",
      CellTags->"S2.3.5"],
    Cell[57301, 2106, 128, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.21"}],
    Cell[57454, 2114, 113, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[57570, 2118, 120, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[57705, 2124, 108, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.22"}],
    Cell[57816, 2127, 111, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[57930, 2131, 106, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.23"}],
    Cell[58061, 2136, 105, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[58169, 2140, 120, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[58304, 2146, 367, 10, 70, "Text",
      CellTags->{"S2.3.5", "5.24"}],
    Cell[58674, 2158, 163, 6, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.25"}],
    Cell[58862, 2168, 79, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[58944, 2172, 86, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[59045, 2178, 186, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.26"}],
    Cell[59256, 2189, 76, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[59335, 2193, 87, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[59437, 2199, 1224, 43, 70, "Text",
      CellTags->{"S2.3.5", "5.27"}],
    Cell[60664, 2244, 3983, 128, 70, "DefinitionBox",
      CellTags->"S2.3.5"],
    Cell[64650, 2374, 116, 4, 70, "Caption",
      CellTags->"S2.3.5"],
    Cell[64769, 2380, 265, 9, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.28"}],
    Cell[65059, 2393, 82, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[65144, 2397, 103, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[65262, 2403, 238, 11, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.29"}],
    Cell[65525, 2418, 85, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[65613, 2422, 87, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[65715, 2428, 202, 9, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.30"}],
    Cell[65942, 2441, 83, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[66028, 2445, 87, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[66130, 2451, 228, 8, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.31"}],
    Cell[66361, 2461, 105, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[66469, 2465, 187, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.32"}],
    Cell[66681, 2476, 96, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[66780, 2480, 124, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[66919, 2486, 667, 20, 70, "DefinitionBox",
      CellTags->"S2.3.5"],
    Cell[67589, 2508, 76, 1, 70, "Caption",
      CellTags->"S2.3.5"],
    Cell[67668, 2511, 696, 24, 70, "Text",
      CellTags->{"S2.3.5", "5.33"}],
    Cell[68367, 2537, 201, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.34"}],
    Cell[68571, 2546, 85, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[68659, 2550, 160, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.35"}],
    Cell[68844, 2559, 87, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[68934, 2563, 123, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[69072, 2569, 160, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.36"}],
    Cell[69235, 2575, 138, 5, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[69376, 2582, 101, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.37"}],
    Cell[69502, 2587, 100, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[69605, 2591, 113, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[69733, 2597, 987, 31, 70, "DefinitionBox",
      CellTags->"S2.3.5"],
    Cell[70723, 2630, 67, 1, 70, "Caption",
      CellTags->"S2.3.5"],
    Cell[70793, 2633, 133, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.38"}],
    Cell[70951, 2642, 98, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[71052, 2646, 91, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[71158, 2652, 135, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.39"}],
    Cell[71318, 2660, 111, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[71432, 2664, 94, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[71541, 2670, 139, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.40"}],
    Cell[71705, 2679, 114, 2, 70, "Input",
      CellTags->"S2.3.5"],
    Cell[71822, 2683, 88, 3, 70, "Output",
      CellTags->"S2.3.5"],
    Cell[71925, 2689, 580, 21, 70, "Text",
      CellTags->{"S2.3.5", "5.41"}]},
  "5.1"->{
    Cell[40968, 1516, 90, 1, 70, "Subsection",
      CellTags->{"S2.3.5", "5.1"}]},
  "5.2"->{
    Cell[41061, 1519, 639, 16, 70, "Text",
      CellTags->{"S2.3.5", "5.2"}]},
  "5.3"->{
    Cell[43141, 1586, 209, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.3"}]},
  "5.4"->{
    Cell[43442, 1599, 165, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.4"}]},
  "5.5"->{
    Cell[43828, 1618, 100, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.5"}]},
  "5.6"->{
    Cell[44166, 1633, 854, 28, 70, "Text",
      CellTags->{"S2.3.5", "5.6"}]},
  "5.7"->{
    Cell[45023, 1663, 193, 6, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.7"}]},
  "5.8"->{
    Cell[45309, 1675, 149, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.8"}]},
  "5.9"->{
    Cell[45682, 1693, 442, 10, 70, "Text",
      CellTags->{"S2.3.5", "5.9"}]},
  "5.10"->{
    Cell[46127, 1705, 260, 11, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.10"}]},
  "5.11"->{
    Cell[46478, 1722, 133, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.11"}]},
  "5.12"->{
    Cell[46821, 1740, 195, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.12"}]},
  "5.13"->{
    Cell[47224, 1759, 370, 17, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.13"}]},
  "5.14"->{
    Cell[47695, 1782, 99, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.14"}]},
  "5.15"->{
    Cell[47996, 1797, 1347, 38, 70, "Text",
      CellTags->{"S2.3.5", "5.15"}]},
  "5.16"->{
    Cell[49346, 1837, 907, 45, 70, "Text",
      CellTags->{"S2.3.5", "5.16"}]},
  "5.17"->{
    Cell[50256, 1884, 478, 11, 70, "Text",
      CellTags->{"S2.3.5", "5.17"}]},
  "5.18"->{
    Cell[50737, 1897, 235, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.18"}]},
  "5.19"->{
    Cell[51246, 1918, 168, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.19"}]},
  "5.20"->{
    Cell[51680, 1937, 550, 13, 70, "Text",
      CellTags->{"S2.3.5", "5.20"}]},
  "5.21"->{
    Cell[57301, 2106, 128, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.21"}]},
  "5.22"->{
    Cell[57705, 2124, 108, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.22"}]},
  "5.23"->{
    Cell[57930, 2131, 106, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.23"}]},
  "5.24"->{
    Cell[58304, 2146, 367, 10, 70, "Text",
      CellTags->{"S2.3.5", "5.24"}]},
  "5.25"->{
    Cell[58674, 2158, 163, 6, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.25"}]},
  "5.26"->{
    Cell[59045, 2178, 186, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.26"}]},
  "5.27"->{
    Cell[59437, 2199, 1224, 43, 70, "Text",
      CellTags->{"S2.3.5", "5.27"}]},
  "5.28"->{
    Cell[64769, 2380, 265, 9, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.28"}]},
  "5.29"->{
    Cell[65262, 2403, 238, 11, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.29"}]},
  "5.30"->{
    Cell[65715, 2428, 202, 9, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.30"}]},
  "5.31"->{
    Cell[66130, 2451, 228, 8, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.31"}]},
  "5.32"->{
    Cell[66469, 2465, 187, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.32"}]},
  "5.33"->{
    Cell[67668, 2511, 696, 24, 70, "Text",
      CellTags->{"S2.3.5", "5.33"}]},
  "5.34"->{
    Cell[68367, 2537, 201, 7, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.34"}]},
  "5.35"->{
    Cell[68659, 2550, 160, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.35"}]},
  "5.36"->{
    Cell[69072, 2569, 160, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.36"}]},
  "5.37"->{
    Cell[69376, 2582, 101, 1, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.37"}]},
  "5.38"->{
    Cell[70793, 2633, 133, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.38"}]},
  "5.39"->{
    Cell[71158, 2652, 135, 4, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.39"}]},
  "5.40"->{
    Cell[71541, 2670, 139, 5, 70, "MathCaption",
      CellTags->{"S2.3.5", "5.40"}]},
  "5.41"->{
    Cell[71925, 2689, 580, 21, 70, "Text",
      CellTags->{"S2.3.5", "5.41"}]},
  "S2.3.6"->{
    Cell[72542, 2715, 90, 1, 70, "Subsection",
      CellTags->{"S2.3.6", "6.1"}],
    Cell[72635, 2718, 920, 27, 70, "DefinitionBox",
      CellTags->"S2.3.6"],
    Cell[73558, 2747, 88, 1, 70, "Caption",
      CellTags->"S2.3.6"],
    Cell[73649, 2750, 243, 11, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.2"}],
    Cell[73895, 2763, 77, 2, 70, "Input",
      CellTags->"S2.3.6"],
    Cell[73975, 2767, 126, 5, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.3"}],
    Cell[74126, 2776, 88, 2, 70, "Input",
      CellTags->"S2.3.6"],
    Cell[74217, 2780, 99, 3, 70, "Output",
      CellTags->"S2.3.6"],
    Cell[74331, 2786, 109, 1, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.4"}],
    Cell[74465, 2791, 92, 2, 70, "Input",
      CellTags->"S2.3.6"],
    Cell[74560, 2795, 93, 3, 70, "Output",
      CellTags->"S2.3.6"],
    Cell[74668, 2801, 143, 4, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.5"}],
    Cell[74836, 2809, 103, 2, 70, "Input",
      CellTags->"S2.3.6"],
    Cell[74942, 2813, 99, 3, 70, "Output",
      CellTags->"S2.3.6"],
    Cell[75056, 2819, 932, 28, 70, "Text",
      CellTags->{"S2.3.6", "6.6"}],
    Cell[75991, 2849, 215, 9, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.7"}],
    Cell[76231, 2862, 116, 2, 70, "Input",
      CellTags->"S2.3.6"],
    Cell[76350, 2866, 114, 3, 70, "Output",
      CellTags->"S2.3.6"]},
  "6.1"->{
    Cell[72542, 2715, 90, 1, 70, "Subsection",
      CellTags->{"S2.3.6", "6.1"}]},
  "6.2"->{
    Cell[73649, 2750, 243, 11, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.2"}]},
  "6.3"->{
    Cell[73975, 2767, 126, 5, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.3"}]},
  "6.4"->{
    Cell[74331, 2786, 109, 1, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.4"}]},
  "6.5"->{
    Cell[74668, 2801, 143, 4, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.5"}]},
  "6.6"->{
    Cell[75056, 2819, 932, 28, 70, "Text",
      CellTags->{"S2.3.6", "6.6"}]},
  "6.7"->{
    Cell[75991, 2849, 215, 9, 70, "MathCaption",
      CellTags->{"S2.3.6", "6.7"}]},
  "S2.3.7"->{
    Cell[76513, 2875, 87, 1, 70, "Subsection",
      CellTags->{"S2.3.7", "7.1"}],
    Cell[76603, 2878, 402, 11, 70, "Text",
      CellTags->{"S2.3.7", "7.2"}],
    Cell[77008, 2891, 827, 42, 70, "Text",
      CellTags->{"S2.3.7", "7.3"}],
    Cell[77838, 2935, 114, 2, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.4"}],
    Cell[77977, 2941, 104, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[78084, 2945, 88, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[78187, 2951, 301, 11, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.5"}],
    Cell[78513, 2966, 104, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[78620, 2970, 88, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[78723, 2976, 2246, 88, 70, "Text",
      CellTags->{"S2.3.7", "7.6"}],
    Cell[80972, 3066, 621, 26, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.7"}],
    Cell[81618, 3096, 116, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[81737, 3100, 91, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[81843, 3106, 133, 4, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.8"}],
    Cell[82001, 3114, 137, 5, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[82141, 3121, 105, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[82261, 3127, 609, 14, 70, "Text",
      CellTags->{"S2.3.7", "7.9"}],
    Cell[82873, 3143, 3556, 112, 70, "DefinitionBox",
      CellTags->"S2.3.7"],
    Cell[86432, 3257, 92, 1, 70, "Caption",
      CellTags->"S2.3.7"],
    Cell[86527, 3260, 208, 8, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.10"}],
    Cell[86760, 3272, 80, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[86843, 3276, 156, 4, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[87014, 3283, 158, 5, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.11"}],
    Cell[87175, 3290, 91, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[87269, 3294, 155, 5, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.12"}],
    Cell[87449, 3303, 74, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[87526, 3307, 91, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[87632, 3313, 190, 6, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.13"}],
    Cell[87847, 3323, 124, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[87974, 3327, 91, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[88080, 3333, 773, 32, 70, "Text",
      CellTags->{"S2.3.7", "7.14"}],
    Cell[88856, 3367, 799, 39, 70, "Text",
      CellTags->{"S2.3.7", "7.15"}],
    Cell[89658, 3408, 311, 15, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.16"}],
    Cell[89994, 3427, 101, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[90098, 3431, 92, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[90205, 3437, 221, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.17"}],
    Cell[90451, 3448, 106, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[90560, 3452, 97, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[90672, 3458, 92, 1, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.18"}],
    Cell[90789, 3463, 113, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[90905, 3467, 167, 4, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[91087, 3474, 217, 11, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.19"}],
    Cell[91329, 3489, 117, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[91449, 3493, 97, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[91561, 3499, 372, 7, 70, "Text",
      CellTags->{"S2.3.7", "7.20"}],
    Cell[91936, 3508, 139, 4, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.21"}],
    Cell[92100, 3516, 88, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[92191, 3520, 87, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[92293, 3526, 98, 1, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.22"}],
    Cell[92416, 3531, 119, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[92538, 3535, 104, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[92657, 3541, 293, 10, 70, "Text",
      CellTags->{"S2.3.7", "7.23"}],
    Cell[92953, 3553, 194, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.24"}],
    Cell[93172, 3564, 113, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[93288, 3568, 97, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[93400, 3574, 178, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.25"}],
    Cell[93581, 3583, 87, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[93671, 3587, 293, 12, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.26"}],
    Cell[93989, 3603, 100, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[94092, 3607, 93, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[94200, 3613, 297, 12, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.27"}],
    Cell[94522, 3629, 100, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[94625, 3633, 99, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[94739, 3639, 1286, 45, 70, "Text",
      CellTags->{"S2.3.7", "7.28"}],
    Cell[96028, 3686, 182, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.29"}],
    Cell[96213, 3695, 94, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[96310, 3699, 195, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.30"}],
    Cell[96530, 3710, 100, 2, 70, "Input",
      CellTags->"S2.3.7"],
    Cell[96633, 3714, 96, 3, 70, "Output",
      CellTags->"S2.3.7"],
    Cell[96744, 3720, 582, 20, 70, "Text",
      CellTags->{"S2.3.7", "7.31"}]},
  "7.1"->{
    Cell[76513, 2875, 87, 1, 70, "Subsection",
      CellTags->{"S2.3.7", "7.1"}]},
  "7.2"->{
    Cell[76603, 2878, 402, 11, 70, "Text",
      CellTags->{"S2.3.7", "7.2"}]},
  "7.3"->{
    Cell[77008, 2891, 827, 42, 70, "Text",
      CellTags->{"S2.3.7", "7.3"}]},
  "7.4"->{
    Cell[77838, 2935, 114, 2, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.4"}]},
  "7.5"->{
    Cell[78187, 2951, 301, 11, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.5"}]},
  "7.6"->{
    Cell[78723, 2976, 2246, 88, 70, "Text",
      CellTags->{"S2.3.7", "7.6"}]},
  "7.7"->{
    Cell[80972, 3066, 621, 26, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.7"}]},
  "7.8"->{
    Cell[81843, 3106, 133, 4, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.8"}]},
  "7.9"->{
    Cell[82261, 3127, 609, 14, 70, "Text",
      CellTags->{"S2.3.7", "7.9"}]},
  "7.10"->{
    Cell[86527, 3260, 208, 8, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.10"}]},
  "7.11"->{
    Cell[87014, 3283, 158, 5, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.11"}]},
  "7.12"->{
    Cell[87269, 3294, 155, 5, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.12"}]},
  "7.13"->{
    Cell[87632, 3313, 190, 6, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.13"}]},
  "7.14"->{
    Cell[88080, 3333, 773, 32, 70, "Text",
      CellTags->{"S2.3.7", "7.14"}]},
  "7.15"->{
    Cell[88856, 3367, 799, 39, 70, "Text",
      CellTags->{"S2.3.7", "7.15"}]},
  "7.16"->{
    Cell[89658, 3408, 311, 15, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.16"}]},
  "7.17"->{
    Cell[90205, 3437, 221, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.17"}]},
  "7.18"->{
    Cell[90672, 3458, 92, 1, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.18"}]},
  "7.19"->{
    Cell[91087, 3474, 217, 11, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.19"}]},
  "7.20"->{
    Cell[91561, 3499, 372, 7, 70, "Text",
      CellTags->{"S2.3.7", "7.20"}]},
  "7.21"->{
    Cell[91936, 3508, 139, 4, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.21"}]},
  "7.22"->{
    Cell[92293, 3526, 98, 1, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.22"}]},
  "7.23"->{
    Cell[92657, 3541, 293, 10, 70, "Text",
      CellTags->{"S2.3.7", "7.23"}]},
  "7.24"->{
    Cell[92953, 3553, 194, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.24"}]},
  "7.25"->{
    Cell[93400, 3574, 178, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.25"}]},
  "7.26"->{
    Cell[93671, 3587, 293, 12, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.26"}]},
  "7.27"->{
    Cell[94200, 3613, 297, 12, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.27"}]},
  "7.28"->{
    Cell[94739, 3639, 1286, 45, 70, "Text",
      CellTags->{"S2.3.7", "7.28"}]},
  "7.29"->{
    Cell[96028, 3686, 182, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.29"}]},
  "7.30"->{
    Cell[96310, 3699, 195, 7, 70, "MathCaption",
      CellTags->{"S2.3.7", "7.30"}]},
  "7.31"->{
    Cell[96744, 3720, 582, 20, 70, "Text",
      CellTags->{"S2.3.7", "7.31"}]},
  "S2.3.8"->{
    Cell[97363, 3745, 103, 1, 70, "Subsection",
      CellTags->{"S2.3.8", "8.1"}],
    Cell[97469, 3748, 441, 15, 70, "Text",
      CellTags->{"S2.3.8", "8.2"}],
    Cell[97913, 3765, 367, 11, 70, "Text",
      CellTags->{"S2.3.8", "8.3"}],
    Cell[98283, 3778, 241, 11, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.4"}],
    Cell[98549, 3793, 98, 2, 70, "Input",
      CellTags->"S2.3.8"],
    Cell[98650, 3797, 109, 3, 70, "Output",
      CellTags->"S2.3.8"],
    Cell[98774, 3803, 190, 6, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.5"}],
    Cell[98967, 3811, 111, 2, 70, "Input",
      CellTags->"S2.3.8"],
    Cell[99081, 3815, 134, 4, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.6"}],
    Cell[99240, 3823, 83, 2, 70, "Input",
      CellTags->"S2.3.8"],
    Cell[99326, 3827, 102, 3, 70, "Output",
      CellTags->"S2.3.8"],
    Cell[99443, 3833, 974, 26, 70, "Text",
      CellTags->{"S2.3.8", "8.7"}],
    Cell[100420, 3861, 2129, 67, 70, "DefinitionBox",
      CellTags->"S2.3.8"],
    Cell[102552, 3930, 72, 1, 70, "Caption",
      CellTags->"S2.3.8"],
    Cell[102627, 3933, 453, 14, 70, "Text",
      CellTags->{"S2.3.8", "8.8"}],
    Cell[103083, 3949, 359, 7, 70, "Text",
      CellTags->{"S2.3.8", "8.9"}],
    Cell[103445, 3958, 160, 5, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.10"}],
    Cell[103630, 3967, 118, 2, 70, "Input",
      CellTags->"S2.3.8"],
    Cell[103751, 3971, 138, 3, 70, "Output",
      CellTags->"S2.3.8"],
    Cell[103904, 3977, 190, 5, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.11"}],
    Cell[104119, 3986, 111, 2, 70, "Input",
      CellTags->"S2.3.8"],
    Cell[104233, 3990, 123, 3, 70, "Output",
      CellTags->"S2.3.8"],
    Cell[104371, 3996, 133, 4, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.12"}],
    Cell[104529, 4004, 116, 2, 70, "Input",
      CellTags->"S2.3.8"],
    Cell[104648, 4008, 178, 4, 70, "Output",
      CellTags->"S2.3.8"]},
  "8.1"->{
    Cell[97363, 3745, 103, 1, 70, "Subsection",
      CellTags->{"S2.3.8", "8.1"}]},
  "8.2"->{
    Cell[97469, 3748, 441, 15, 70, "Text",
      CellTags->{"S2.3.8", "8.2"}]},
  "8.3"->{
    Cell[97913, 3765, 367, 11, 70, "Text",
      CellTags->{"S2.3.8", "8.3"}]},
  "8.4"->{
    Cell[98283, 3778, 241, 11, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.4"}]},
  "8.5"->{
    Cell[98774, 3803, 190, 6, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.5"}]},
  "8.6"->{
    Cell[99081, 3815, 134, 4, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.6"}]},
  "8.7"->{
    Cell[99443, 3833, 974, 26, 70, "Text",
      CellTags->{"S2.3.8", "8.7"}]},
  "8.8"->{
    Cell[102627, 3933, 453, 14, 70, "Text",
      CellTags->{"S2.3.8", "8.8"}]},
  "8.9"->{
    Cell[103083, 3949, 359, 7, 70, "Text",
      CellTags->{"S2.3.8", "8.9"}]},
  "8.10"->{
    Cell[103445, 3958, 160, 5, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.10"}]},
  "8.11"->{
    Cell[103904, 3977, 190, 5, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.11"}]},
  "8.12"->{
    Cell[104371, 3996, 133, 4, 70, "MathCaption",
      CellTags->{"S2.3.8", "8.12"}]},
  "S2.3.9"->{
    Cell[104875, 4018, 89, 1, 70, "Subsection",
      CellTags->{"S2.3.9", "9.1"}],
    Cell[104967, 4021, 435, 12, 70, "Text",
      CellTags->{"S2.3.9", "9.2"}],
    Cell[105405, 4035, 367, 15, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.3"}],
    Cell[105775, 4052, 96, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[105874, 4056, 135, 5, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.4"}],
    Cell[106034, 4065, 71, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[106108, 4069, 92, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[106215, 4075, 175, 7, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.5"}],
    Cell[106415, 4086, 68, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[106486, 4090, 92, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[106593, 4096, 1215, 41, 70, "DefinitionBox",
      CellTags->"S2.3.9"],
    Cell[107811, 4139, 78, 1, 70, "Caption",
      CellTags->"S2.3.9"],
    Cell[107892, 4142, 489, 13, 70, "Text",
      CellTags->{"S2.3.9", "9.6"}],
    Cell[108384, 4157, 1190, 42, 70, "DefinitionBox",
      CellTags->"S2.3.9"],
    Cell[109577, 4201, 77, 1, 70, "Caption",
      CellTags->"S2.3.9"],
    Cell[109657, 4204, 334, 15, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.7"}],
    Cell[110016, 4223, 106, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[110125, 4227, 99, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[110239, 4233, 772, 31, 70, "Text",
      CellTags->{"S2.3.9", "9.8"}],
    Cell[111014, 4266, 371, 9, 70, "Text",
      CellTags->{"S2.3.9", "9.9"}],
    Cell[111388, 4277, 229, 11, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.10"}],
    Cell[111642, 4292, 105, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[111750, 4296, 100, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[111865, 4302, 146, 4, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.11"}],
    Cell[112036, 4310, 106, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[112145, 4314, 103, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[112263, 4320, 271, 13, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.12"}],
    Cell[112537, 4335, 96, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[112636, 4339, 232, 10, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.13"}],
    Cell[112893, 4353, 77, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[112973, 4357, 88, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[113076, 4363, 373, 17, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.14"}],
    Cell[113474, 4384, 73, 2, 70, "Input",
      CellTags->"S2.3.9"],
    Cell[113550, 4388, 88, 3, 70, "Output",
      CellTags->"S2.3.9"],
    Cell[113653, 4394, 436, 14, 70, "Text",
      CellTags->{"S2.3.9", "9.15"}]},
  "9.1"->{
    Cell[104875, 4018, 89, 1, 70, "Subsection",
      CellTags->{"S2.3.9", "9.1"}]},
  "9.2"->{
    Cell[104967, 4021, 435, 12, 70, "Text",
      CellTags->{"S2.3.9", "9.2"}]},
  "9.3"->{
    Cell[105405, 4035, 367, 15, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.3"}]},
  "9.4"->{
    Cell[105874, 4056, 135, 5, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.4"}]},
  "9.5"->{
    Cell[106215, 4075, 175, 7, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.5"}]},
  "9.6"->{
    Cell[107892, 4142, 489, 13, 70, "Text",
      CellTags->{"S2.3.9", "9.6"}]},
  "9.7"->{
    Cell[109657, 4204, 334, 15, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.7"}]},
  "9.8"->{
    Cell[110239, 4233, 772, 31, 70, "Text",
      CellTags->{"S2.3.9", "9.8"}]},
  "9.9"->{
    Cell[111014, 4266, 371, 9, 70, "Text",
      CellTags->{"S2.3.9", "9.9"}]},
  "9.10"->{
    Cell[111388, 4277, 229, 11, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.10"}]},
  "9.11"->{
    Cell[111865, 4302, 146, 4, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.11"}]},
  "9.12"->{
    Cell[112263, 4320, 271, 13, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.12"}]},
  "9.13"->{
    Cell[112636, 4339, 232, 10, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.13"}]},
  "9.14"->{
    Cell[113076, 4363, 373, 17, 70, "MathCaption",
      CellTags->{"S2.3.9", "9.14"}]},
  "9.15"->{
    Cell[113653, 4394, 436, 14, 70, "Text",
      CellTags->{"S2.3.9", "9.15"}]},
  "S2.3.10"->{
    Cell[114126, 4413, 106, 1, 70, "Subsection",
      CellTags->{"S2.3.10", "10.1"}],
    Cell[114235, 4416, 374, 7, 70, "Text",
      CellTags->{"S2.3.10", "10.2"}],
    Cell[114612, 4425, 318, 9, 70, "Text",
      CellTags->{"S2.3.10", "10.3"}],
    Cell[114933, 4436, 663, 18, 70, "Text",
      CellTags->{"S2.3.10", "10.4"}],
    Cell[115599, 4456, 212, 6, 70, "Text",
      CellTags->{"S2.3.10", "10.5"}],
    Cell[115814, 4464, 899, 28, 70, "DefinitionBox",
      CellTags->"S2.3.10"],
    Cell[116716, 4494, 89, 1, 70, "Caption",
      CellTags->"S2.3.10"],
    Cell[116808, 4497, 245, 6, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.6"}],
    Cell[117056, 4505, 101, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[117160, 4509, 104, 1, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.7"}],
    Cell[117267, 4512, 109, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[117379, 4516, 346, 12, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.8"}],
    Cell[117750, 4532, 73, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[117826, 4536, 94, 3, 70, "Output",
      CellTags->"S2.3.10"],
    Cell[117935, 4542, 545, 11, 70, "Text",
      CellTags->{"S2.3.10", "10.9"}],
    Cell[118483, 4555, 632, 16, 70, "Text",
      CellTags->{"S2.3.10", "10.10"}],
    Cell[119118, 4573, 352, 10, 70, "Text",
      CellTags->{"S2.3.10", "10.11"}],
    Cell[119473, 4585, 1323, 44, 70, "DefinitionBox",
      CellTags->"S2.3.10"],
    Cell[120799, 4631, 59, 1, 70, "Caption",
      CellTags->"S2.3.10"],
    Cell[120861, 4634, 252, 9, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.12"}],
    Cell[121138, 4647, 103, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[121244, 4651, 114, 3, 70, "Output",
      CellTags->"S2.3.10"],
    Cell[121373, 4657, 140, 5, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.13"}],
    Cell[121538, 4666, 84, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[121625, 4670, 83, 3, 70, "Output",
      CellTags->"S2.3.10"],
    Cell[121723, 4676, 249, 9, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.14"}],
    Cell[121997, 4689, 95, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[122095, 4693, 83, 3, 70, "Output",
      CellTags->"S2.3.10"],
    Cell[122193, 4699, 210, 5, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.15"}],
    Cell[122406, 4706, 115, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[122524, 4710, 174, 5, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.16"}],
    Cell[122723, 4719, 70, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[122796, 4723, 89, 3, 70, "Output",
      CellTags->"S2.3.10"],
    Cell[122900, 4729, 243, 7, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.17"}],
    Cell[123168, 4740, 79, 2, 70, "Input",
      CellTags->"S2.3.10"],
    Cell[123250, 4744, 89, 3, 70, "Output",
      CellTags->"S2.3.10"]},
  "10.1"->{
    Cell[114126, 4413, 106, 1, 70, "Subsection",
      CellTags->{"S2.3.10", "10.1"}]},
  "10.2"->{
    Cell[114235, 4416, 374, 7, 70, "Text",
      CellTags->{"S2.3.10", "10.2"}]},
  "10.3"->{
    Cell[114612, 4425, 318, 9, 70, "Text",
      CellTags->{"S2.3.10", "10.3"}]},
  "10.4"->{
    Cell[114933, 4436, 663, 18, 70, "Text",
      CellTags->{"S2.3.10", "10.4"}]},
  "10.5"->{
    Cell[115599, 4456, 212, 6, 70, "Text",
      CellTags->{"S2.3.10", "10.5"}]},
  "10.6"->{
    Cell[116808, 4497, 245, 6, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.6"}]},
  "10.7"->{
    Cell[117160, 4509, 104, 1, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.7"}]},
  "10.8"->{
    Cell[117379, 4516, 346, 12, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.8"}]},
  "10.9"->{
    Cell[117935, 4542, 545, 11, 70, "Text",
      CellTags->{"S2.3.10", "10.9"}]},
  "10.10"->{
    Cell[118483, 4555, 632, 16, 70, "Text",
      CellTags->{"S2.3.10", "10.10"}]},
  "10.11"->{
    Cell[119118, 4573, 352, 10, 70, "Text",
      CellTags->{"S2.3.10", "10.11"}]},
  "10.12"->{
    Cell[120861, 4634, 252, 9, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.12"}]},
  "10.13"->{
    Cell[121373, 4657, 140, 5, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.13"}]},
  "10.14"->{
    Cell[121723, 4676, 249, 9, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.14"}]},
  "10.15"->{
    Cell[122193, 4699, 210, 5, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.15"}]},
  "10.16"->{
    Cell[122524, 4710, 174, 5, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.16"}]},
  "10.17"->{
    Cell[122900, 4729, 243, 7, 70, "MathCaption",
      CellTags->{"S2.3.10", "10.17"}]},
  "S2.3.11"->{
    Cell[123388, 4753, 79, 1, 70, "Subsection",
      CellTags->{"S2.3.11", "11.1"}],
    Cell[123470, 4756, 641, 18, 70, "DefinitionBox",
      CellTags->"S2.3.11"],
    Cell[124114, 4776, 61, 1, 70, "Caption",
      CellTags->"S2.3.11"],
    Cell[124178, 4779, 789, 30, 70, "Text",
      CellTags->{"S2.3.11", "11.2"}],
    Cell[124970, 4811, 205, 7, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.3"}],
    Cell[125200, 4822, 112, 2, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[125315, 4826, 100, 3, 70, "Output",
      CellTags->"S2.3.11"],
    Cell[125430, 4832, 214, 7, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.4"}],
    Cell[125669, 4843, 139, 5, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[125811, 4850, 106, 3, 70, "Output",
      CellTags->"S2.3.11"],
    Cell[125932, 4856, 187, 7, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.5"}],
    Cell[126144, 4867, 118, 2, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[126265, 4871, 100, 3, 70, "Output",
      CellTags->"S2.3.11"],
    Cell[126380, 4877, 277, 8, 70, "Text",
      CellTags->{"S2.3.11", "11.6"}],
    Cell[126660, 4887, 138, 4, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.7"}],
    Cell[126801, 4893, 96, 2, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[126900, 4897, 93, 1, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.8"}],
    Cell[127018, 4902, 98, 2, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[127119, 4906, 110, 3, 70, "Output",
      CellTags->"S2.3.11"],
    Cell[127244, 4912, 143, 4, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.9"}],
    Cell[127390, 4918, 98, 2, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[127491, 4922, 94, 1, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.10"}],
    Cell[127610, 4927, 93, 2, 70, "Input",
      CellTags->"S2.3.11"],
    Cell[127706, 4931, 104, 3, 70, "Output",
      CellTags->"S2.3.11"]},
  "11.1"->{
    Cell[123388, 4753, 79, 1, 70, "Subsection",
      CellTags->{"S2.3.11", "11.1"}]},
  "11.2"->{
    Cell[124178, 4779, 789, 30, 70, "Text",
      CellTags->{"S2.3.11", "11.2"}]},
  "11.3"->{
    Cell[124970, 4811, 205, 7, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.3"}]},
  "11.4"->{
    Cell[125430, 4832, 214, 7, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.4"}]},
  "11.5"->{
    Cell[125932, 4856, 187, 7, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.5"}]},
  "11.6"->{
    Cell[126380, 4877, 277, 8, 70, "Text",
      CellTags->{"S2.3.11", "11.6"}]},
  "11.7"->{
    Cell[126660, 4887, 138, 4, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.7"}]},
  "11.8"->{
    Cell[126900, 4897, 93, 1, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.8"}]},
  "11.9"->{
    Cell[127244, 4912, 143, 4, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.9"}]},
  "11.10"->{
    Cell[127491, 4922, 94, 1, 70, "MathCaption",
      CellTags->{"S2.3.11", "11.10"}]},
  "S2.3.12"->{
    Cell[127859, 4940, 79, 1, 70, "Subsection",
      CellTags->{"S2.3.12", "12.1"}],
    Cell[127941, 4943, 438, 12, 70, "DefinitionBox",
      CellTags->"S2.3.12"],
    Cell[128382, 4957, 61, 1, 70, "Caption",
      CellTags->"S2.3.12"],
    Cell[128446, 4960, 148, 5, 70, "MathCaption",
      CellTags->{"S2.3.12", "12.2"}],
    Cell[128619, 4969, 107, 2, 70, "Input",
      CellTags->"S2.3.12"],
    Cell[128729, 4973, 105, 3, 70, "Output",
      CellTags->"S2.3.12"],
    Cell[128849, 4979, 240, 9, 70, "MathCaption",
      CellTags->{"S2.3.12", "12.3"}],
    Cell[129114, 4992, 117, 2, 70, "Input",
      CellTags->"S2.3.12"],
    Cell[129234, 4996, 107, 3, 70, "Output",
      CellTags->"S2.3.12"]},
  "12.1"->{
    Cell[127859, 4940, 79, 1, 70, "Subsection",
      CellTags->{"S2.3.12", "12.1"}]},
  "12.2"->{
    Cell[128446, 4960, 148, 5, 70, "MathCaption",
      CellTags->{"S2.3.12", "12.2"}]},
  "12.3"->{
    Cell[128849, 4979, 240, 9, 70, "MathCaption",
      CellTags->{"S2.3.12", "12.3"}]},
  "S2.3.13"->{
    Cell[129390, 5005, 106, 1, 70, "Subsection",
      CellTags->{"S2.3.13", "13.1"}],
    Cell[129499, 5008, 365, 9, 70, "Text",
      CellTags->{"S2.3.13", "13.2"}],
    Cell[129867, 5019, 316, 7, 70, "Text",
      CellTags->{"S2.3.13", "13.3"}],
    Cell[130186, 5028, 4565, 143, 70, "DefinitionBox",
      CellTags->"S2.3.13"],
    Cell[134754, 5173, 77, 1, 70, "Caption",
      CellTags->"S2.3.13"],
    Cell[134834, 5176, 97, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.4"}],
    Cell[134956, 5181, 99, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[135058, 5185, 281, 8, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[135354, 5196, 110, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.5"}],
    Cell[135489, 5201, 111, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[135603, 5205, 108, 3, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[135726, 5211, 351, 14, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.6"}],
    Cell[136102, 5229, 95, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[136200, 5233, 306, 9, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[136521, 5245, 191, 5, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.7"}],
    Cell[136737, 5254, 163, 5, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[136903, 5261, 126, 3, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[137044, 5267, 875, 21, 70, "Text",
      CellTags->{"S2.3.13", "13.8"}],
    Cell[137922, 5290, 96, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.9"}],
    Cell[138043, 5295, 91, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[138137, 5299, 124, 3, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[138276, 5305, 107, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.10"}],
    Cell[138408, 5310, 76, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[138487, 5314, 368, 10, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[138870, 5327, 155, 4, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.11"}],
    Cell[139050, 5335, 86, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[139139, 5339, 149, 4, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[139303, 5346, 4282, 135, 70, "DefinitionBox",
      CellTags->"S2.3.13"],
    Cell[143588, 5483, 91, 1, 70, "Caption",
      CellTags->"S2.3.13"],
    Cell[143682, 5486, 147, 5, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.12"}],
    Cell[143854, 5495, 114, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[143971, 5499, 115, 3, 70, "Output",
      CellTags->"S2.3.13"],
    Cell[144101, 5505, 2554, 77, 70, "DefinitionBox",
      CellTags->"S2.3.13"],
    Cell[146658, 5584, 75, 1, 70, "Caption",
      CellTags->"S2.3.13"],
    Cell[146736, 5587, 171, 4, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.13"}],
    Cell[146910, 5593, 96, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[147009, 5597, 111, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.14"}],
    Cell[147145, 5602, 110, 2, 70, "Input",
      CellTags->"S2.3.13"],
    Cell[147258, 5606, 100, 3, 70, "Output",
      CellTags->"S2.3.13"]},
  "13.1"->{
    Cell[129390, 5005, 106, 1, 70, "Subsection",
      CellTags->{"S2.3.13", "13.1"}]},
  "13.2"->{
    Cell[129499, 5008, 365, 9, 70, "Text",
      CellTags->{"S2.3.13", "13.2"}]},
  "13.3"->{
    Cell[129867, 5019, 316, 7, 70, "Text",
      CellTags->{"S2.3.13", "13.3"}]},
  "13.4"->{
    Cell[134834, 5176, 97, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.4"}]},
  "13.5"->{
    Cell[135354, 5196, 110, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.5"}]},
  "13.6"->{
    Cell[135726, 5211, 351, 14, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.6"}]},
  "13.7"->{
    Cell[136521, 5245, 191, 5, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.7"}]},
  "13.8"->{
    Cell[137044, 5267, 875, 21, 70, "Text",
      CellTags->{"S2.3.13", "13.8"}]},
  "13.9"->{
    Cell[137922, 5290, 96, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.9"}]},
  "13.10"->{
    Cell[138276, 5305, 107, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.10"}]},
  "13.11"->{
    Cell[138870, 5327, 155, 4, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.11"}]},
  "13.12"->{
    Cell[143682, 5486, 147, 5, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.12"}]},
  "13.13"->{
    Cell[146736, 5587, 171, 4, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.13"}]},
  "13.14"->{
    Cell[147009, 5597, 111, 1, 70, "MathCaption",
      CellTags->{"S2.3.13", "13.14"}]},
  "S2.3.14"->{
    Cell[147407, 5615, 112, 1, 70, "Subsection",
      CellTags->{"S2.3.14", "14.1"}],
    Cell[147522, 5618, 345, 8, 70, "Text",
      CellTags->{"S2.3.14", "14.2"}],
    Cell[147870, 5628, 336, 7, 70, "Text",
      CellTags->{"S2.3.14", "14.3"}],
    Cell[148209, 5637, 10318, 305, 70, "DefinitionBox",
      CellTags->"S2.3.14"],
    Cell[158530, 5944, 83, 1, 70, "Caption",
      CellTags->"S2.3.14"],
    Cell[158616, 5947, 718, 23, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.4"}],
    Cell[159337, 5972, 124, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[159464, 5976, 197, 5, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.5"}],
    Cell[159686, 5985, 94, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[159783, 5989, 149, 4, 70, "Output",
      CellTags->"S2.3.14"],
    Cell[159947, 5996, 218, 7, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.6"}],
    Cell[160168, 6005, 121, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[160292, 6009, 241, 6, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.7"}],
    Cell[160558, 6019, 94, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[160655, 6023, 149, 4, 70, "Output",
      CellTags->"S2.3.14"],
    Cell[160819, 6030, 425, 15, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.8"}],
    Cell[161247, 6047, 104, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[161354, 6051, 108, 1, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.9"}],
    Cell[161487, 6056, 94, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[161584, 6060, 131, 3, 70, "Output",
      CellTags->"S2.3.14"],
    Cell[161730, 6066, 663, 24, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.10"}],
    Cell[162396, 6092, 139, 5, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[162538, 6099, 99, 1, 40, "MathCaption",
      CellTags->{"S2.3.14", "14.11"}],
    Cell[162662, 6104, 94, 2, 70, "Input",
      CellTags->"S2.3.14"],
    Cell[162759, 6108, 120, 3, 44, "Output",
      CellTags->"S2.3.14"],
    Cell[162894, 6114, 248, 7, 56, "MathCaption",
      CellTags->{"S2.3.14", "14.12"}],
    Cell[163167, 6125, 94, 2, 28, "Input",
      CellTags->"S2.3.14"],
    Cell[163264, 6129, 120, 3, 44, "Output",
      CellTags->"S2.3.14"],
    Cell[163399, 6135, 347, 14, 56, "MathCaption",
      CellTags->{"S2.3.14", "14.13"}],
    Cell[163749, 6151, 144, 5, 45, "Input",
      CellTags->"S2.3.14"],
    Cell[163896, 6158, 177, 7, 40, "MathCaption",
      CellTags->{"S2.3.14", "14.14"}],
    Cell[164098, 6169, 83, 2, 28, "Input",
      CellTags->"S2.3.14"],
    Cell[164184, 6173, 89, 3, 25, "Output",
      CellTags->"S2.3.14"],
    Cell[164288, 6179, 220, 9, 40, "MathCaption",
      CellTags->{"S2.3.14", "14.15"}],
    Cell[164533, 6192, 93, 2, 28, "Input",
      CellTags->"S2.3.14"],
    Cell[164629, 6196, 114, 3, 45, "Output",
      CellTags->"S2.3.14"],
    Cell[164758, 6202, 167, 4, 56, "MathCaption",
      CellTags->{"S2.3.14", "14.16"}],
    Cell[164928, 6208, 145, 5, 45, "Input",
      CellTags->"S2.3.14"]},
  "14.1"->{
    Cell[147407, 5615, 112, 1, 70, "Subsection",
      CellTags->{"S2.3.14", "14.1"}]},
  "14.2"->{
    Cell[147522, 5618, 345, 8, 70, "Text",
      CellTags->{"S2.3.14", "14.2"}]},
  "14.3"->{
    Cell[147870, 5628, 336, 7, 70, "Text",
      CellTags->{"S2.3.14", "14.3"}]},
  "14.4"->{
    Cell[158616, 5947, 718, 23, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.4"}]},
  "14.5"->{
    Cell[159464, 5976, 197, 5, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.5"}]},
  "14.6"->{
    Cell[159947, 5996, 218, 7, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.6"}]},
  "14.7"->{
    Cell[160292, 6009, 241, 6, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.7"}]},
  "14.8"->{
    Cell[160819, 6030, 425, 15, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.8"}]},
  "14.9"->{
    Cell[161354, 6051, 108, 1, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.9"}]},
  "14.10"->{
    Cell[161730, 6066, 663, 24, 70, "MathCaption",
      CellTags->{"S2.3.14", "14.10"}]},
  "14.11"->{
    Cell[162538, 6099, 99, 1, 40, "MathCaption",
      CellTags->{"S2.3.14", "14.11"}]},
  "14.12"->{
    Cell[162894, 6114, 248, 7, 56, "MathCaption",
      CellTags->{"S2.3.14", "14.12"}]},
  "14.13"->{
    Cell[163399, 6135, 347, 14, 56, "MathCaption",
      CellTags->{"S2.3.14", "14.13"}]},
  "14.14"->{
    Cell[163896, 6158, 177, 7, 40, "MathCaption",
      CellTags->{"S2.3.14", "14.14"}]},
  "14.15"->{
    Cell[164288, 6179, 220, 9, 40, "MathCaption",
      CellTags->{"S2.3.14", "14.15"}]},
  "14.16"->{
    Cell[164758, 6202, 167, 4, 56, "MathCaption",
      CellTags->{"S2.3.14", "14.16"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.3.0", 165716, 6233},
  {"0.1", 165806, 6236},
  {"S2.3.1", 165899, 6239},
  {"1.1", 169073, 6324},
  {"1.2", 169165, 6327},
  {"1.3", 169253, 6330},
  {"1.4", 169340, 6333},
  {"1.5", 169434, 6336},
  {"1.6", 169529, 6339},
  {"1.7", 169618, 6342},
  {"1.8", 169707, 6345},
  {"1.9", 169795, 6348},
  {"1.10", 169891, 6351},
  {"1.11", 169982, 6354},
  {"1.12", 170079, 6357},
  {"1.13", 170176, 6360},
  {"1.14", 170267, 6363},
  {"1.15", 170359, 6366},
  {"1.16", 170451, 6369},
  {"1.17", 170543, 6372},
  {"1.18", 170635, 6375},
  {"1.19", 170734, 6378},
  {"1.20", 170826, 6381},
  {"1.21", 170924, 6384},
  {"1.22", 171021, 6387},
  {"1.23", 171113, 6390},
  {"1.24", 171211, 6393},
  {"S2.3.2", 171304, 6396},
  {"2.1", 174459, 6481},
  {"2.2", 174553, 6484},
  {"2.3", 174649, 6487},
  {"2.4", 174745, 6490},
  {"2.5", 174834, 6493},
  {"2.6", 174930, 6496},
  {"2.7", 175026, 6499},
  {"2.8", 175122, 6502},
  {"2.9", 175219, 6505},
  {"2.10", 175317, 6508},
  {"2.11", 175416, 6511},
  {"2.12", 175515, 6514},
  {"S2.3.3", 175616, 6517},
  {"3.1", 177380, 6564},
  {"3.2", 177475, 6567},
  {"3.3", 177566, 6570},
  {"3.4", 177657, 6573},
  {"3.5", 177748, 6576},
  {"3.6", 177845, 6579},
  {"3.7", 177936, 6582},
  {"3.8", 178033, 6585},
  {"3.9", 178130, 6588},
  {"3.10", 178221, 6591},
  {"3.11", 178319, 6594},
  {"S2.3.4", 178420, 6597},
  {"4.1", 180109, 6642},
  {"4.2", 180205, 6645},
  {"4.3", 180295, 6648},
  {"4.4", 180386, 6651},
  {"4.5", 180483, 6654},
  {"4.6", 180574, 6657},
  {"4.7", 180671, 6660},
  {"4.8", 180768, 6663},
  {"4.9", 180865, 6666},
  {"4.10", 180963, 6669},
  {"S2.3.5", 181064, 6672},
  {"5.1", 188775, 6875},
  {"5.2", 188870, 6878},
  {"5.3", 188961, 6881},
  {"5.4", 189058, 6884},
  {"5.5", 189155, 6887},
  {"5.6", 189252, 6890},
  {"5.7", 189343, 6893},
  {"5.8", 189440, 6896},
  {"5.9", 189537, 6899},
  {"5.10", 189629, 6902},
  {"5.11", 189729, 6905},
  {"5.12", 189828, 6908},
  {"5.13", 189927, 6911},
  {"5.14", 190027, 6914},
  {"5.15", 190125, 6917},
  {"5.16", 190219, 6920},
  {"5.17", 190312, 6923},
  {"5.18", 190405, 6926},
  {"5.19", 190504, 6929},
  {"5.20", 190603, 6932},
  {"5.21", 190696, 6935},
  {"5.22", 190795, 6938},
  {"5.23", 190894, 6941},
  {"5.24", 190993, 6944},
  {"5.25", 191086, 6947},
  {"5.26", 191185, 6950},
  {"5.27", 191284, 6953},
  {"5.28", 191378, 6956},
  {"5.29", 191477, 6959},
  {"5.30", 191577, 6962},
  {"5.31", 191676, 6965},
  {"5.32", 191775, 6968},
  {"5.33", 191874, 6971},
  {"5.34", 191967, 6974},
  {"5.35", 192066, 6977},
  {"5.36", 192165, 6980},
  {"5.37", 192264, 6983},
  {"5.38", 192363, 6986},
  {"5.39", 192462, 6989},
  {"5.40", 192561, 6992},
  {"5.41", 192660, 6995},
  {"S2.3.6", 192755, 6998},
  {"6.1", 194133, 7035},
  {"6.2", 194228, 7038},
  {"6.3", 194326, 7041},
  {"6.4", 194423, 7044},
  {"6.5", 194520, 7047},
  {"6.6", 194617, 7050},
  {"6.7", 194708, 7053},
  {"S2.3.7", 194808, 7056},
  {"7.1", 200160, 7197},
  {"7.2", 200255, 7200},
  {"7.3", 200346, 7203},
  {"7.4", 200437, 7206},
  {"7.5", 200534, 7209},
  {"7.6", 200632, 7212},
  {"7.7", 200724, 7215},
  {"7.8", 200822, 7218},
  {"7.9", 200919, 7221},
  {"7.10", 201011, 7224},
  {"7.11", 201110, 7227},
  {"7.12", 201209, 7230},
  {"7.13", 201308, 7233},
  {"7.14", 201407, 7236},
  {"7.15", 201500, 7239},
  {"7.16", 201593, 7242},
  {"7.17", 201693, 7245},
  {"7.18", 201792, 7248},
  {"7.19", 201890, 7251},
  {"7.20", 201990, 7254},
  {"7.21", 202082, 7257},
  {"7.22", 202181, 7260},
  {"7.23", 202279, 7263},
  {"7.24", 202372, 7266},
  {"7.25", 202471, 7269},
  {"7.26", 202570, 7272},
  {"7.27", 202670, 7275},
  {"7.28", 202770, 7278},
  {"7.29", 202864, 7281},
  {"7.30", 202963, 7284},
  {"7.31", 203062, 7287},
  {"S2.3.8", 203157, 7290},
  {"8.1", 205098, 7341},
  {"8.2", 205194, 7344},
  {"8.3", 205285, 7347},
  {"8.4", 205376, 7350},
  {"8.5", 205474, 7353},
  {"8.6", 205571, 7356},
  {"8.7", 205668, 7359},
  {"8.8", 205759, 7362},
  {"8.9", 205851, 7365},
  {"8.10", 205943, 7368},
  {"8.11", 206043, 7371},
  {"8.12", 206143, 7374},
  {"S2.3.9", 206245, 7377},
  {"9.1", 208964, 7448},
  {"9.2", 209060, 7451},
  {"9.3", 209152, 7454},
  {"9.4", 209251, 7457},
  {"9.5", 209349, 7460},
  {"9.6", 209447, 7463},
  {"9.7", 209539, 7466},
  {"9.8", 209638, 7469},
  {"9.9", 209730, 7472},
  {"9.10", 209822, 7475},
  {"9.11", 209923, 7478},
  {"9.12", 210023, 7481},
  {"9.13", 210124, 7484},
  {"9.14", 210225, 7487},
  {"9.15", 210326, 7490},
  {"S2.3.10", 210423, 7493},
  {"10.1", 213280, 7566},
  {"10.2", 213380, 7569},
  {"10.3", 213474, 7572},
  {"10.4", 213568, 7575},
  {"10.5", 213663, 7578},
  {"10.6", 213757, 7581},
  {"10.7", 213858, 7584},
  {"10.8", 213959, 7587},
  {"10.9", 214061, 7590},
  {"10.10", 214157, 7593},
  {"10.11", 214254, 7596},
  {"10.12", 214351, 7599},
  {"10.13", 214454, 7602},
  {"10.14", 214557, 7605},
  {"10.15", 214660, 7608},
  {"10.16", 214763, 7611},
  {"10.17", 214866, 7614},
  {"S2.3.11", 214971, 7617},
  {"11.1", 216867, 7666},
  {"11.2", 216966, 7669},
  {"11.3", 217061, 7672},
  {"11.4", 217162, 7675},
  {"11.5", 217263, 7678},
  {"11.6", 217364, 7681},
  {"11.7", 217458, 7684},
  {"11.8", 217559, 7687},
  {"11.9", 217659, 7690},
  {"11.10", 217761, 7693},
  {"S2.3.12", 217865, 7696},
  {"12.1", 218584, 7715},
  {"12.2", 218683, 7718},
  {"12.3", 218784, 7721},
  {"S2.3.13", 218888, 7724},
  {"13.1", 221955, 7803},
  {"13.2", 222055, 7806},
  {"13.3", 222149, 7809},
  {"13.4", 222243, 7812},
  {"13.5", 222343, 7815},
  {"13.6", 222444, 7818},
  {"13.7", 222546, 7821},
  {"13.8", 222647, 7824},
  {"13.9", 222742, 7827},
  {"13.10", 222843, 7830},
  {"13.11", 222946, 7833},
  {"13.12", 223049, 7836},
  {"13.13", 223152, 7839},
  {"13.14", 223255, 7842},
  {"S2.3.14", 223360, 7845},
  {"14.1", 226372, 7922},
  {"14.2", 226472, 7925},
  {"14.3", 226566, 7928},
  {"14.4", 226660, 7931},
  {"14.5", 226762, 7934},
  {"14.6", 226863, 7937},
  {"14.7", 226964, 7940},
  {"14.8", 227065, 7943},
  {"14.9", 227167, 7946},
  {"14.10", 227269, 7949},
  {"14.11", 227373, 7952},
  {"14.12", 227475, 7955},
  {"14.13", 227578, 7958},
  {"14.14", 227682, 7961},
  {"14.15", 227785, 7964},
  {"14.16", 227888, 7967}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 111, 4, 65, "Section",
  CellTags->{"S2.3.0", "0.1"}],

Cell[CellGroupData[{
Cell[1912, 61, 71, 1, 70, "Subsection",
  CellTags->{"S2.3.1", "1.1"}],
Cell[1986, 64, 402, 12, 70, "Text",
  CellTags->{"S2.3.1", "1.2"}],
Cell[2391, 78, 290, 6, 70, "Text",
  CellTags->{"S2.3.1", "1.3"}],
Cell[2684, 86, 170, 4, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.4"}],

Cell[CellGroupData[{
Cell[2879, 94, 91, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[2973, 98, 92, 3, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[3080, 104, 149, 4, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.5"}],

Cell[CellGroupData[{
Cell[3254, 112, 99, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[3356, 116, 91, 3, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[3462, 122, 601, 18, 70, "Text",
  CellTags->{"S2.3.1", "1.6"}],
Cell[4066, 142, 616, 20, 70, "Text",
  CellTags->{"S2.3.1", "1.7"}],
Cell[4685, 164, 264, 6, 70, "Text",
  CellTags->{"S2.3.1", "1.8"}],
Cell[4952, 172, 2032, 66, 70, "DefinitionBox",
  CellTags->"S2.3.1"],
Cell[6987, 240, 68, 1, 70, "Caption",
  CellTags->"S2.3.1"],
Cell[7058, 243, 127, 4, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.9"}],

Cell[CellGroupData[{
Cell[7210, 251, 107, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[7320, 255, 96, 3, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[7431, 261, 947, 23, 70, "Text",
  CellTags->{"S2.3.1", "1.10"}],
Cell[8381, 286, 215, 5, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.11"}],
Cell[8599, 293, 105, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[8707, 297, 138, 4, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.12"}],
Cell[8848, 303, 84, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[8935, 307, 660, 14, 70, "Text",
  CellTags->{"S2.3.1", "1.13"}],
Cell[9598, 323, 1049, 51, 70, "Text",
  CellTags->{"S2.3.1", "1.14"}],
Cell[10650, 376, 373, 10, 70, "Text",
  CellTags->{"S2.3.1", "1.15"}],
Cell[11026, 388, 943, 33, 70, "Text",
  CellTags->{"S2.3.1", "1.16"}],
Cell[11972, 423, 658, 19, 70, "Text",
  CellTags->{"S2.3.1", "1.17"}],
Cell[12633, 444, 510, 21, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.18"}],

Cell[CellGroupData[{
Cell[13168, 469, 96, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[13267, 473, 99, 3, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[13381, 479, 858, 28, 70, "Text",
  CellTags->{"S2.3.1", "1.19"}],
Cell[14242, 509, 200, 5, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.20"}],

Cell[CellGroupData[{
Cell[14467, 518, 99, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[14569, 522, 120, 3, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[14704, 528, 90, 1, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.21"}],

Cell[CellGroupData[{
Cell[14819, 533, 93, 2, 70, "Input",
  CellTags->"S2.3.1"],
Cell[14915, 537, 322, 9, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[15252, 549, 603, 18, 70, "Text",
  CellTags->{"S2.3.1", "1.22"}],
Cell[15858, 569, 208, 5, 70, "MathCaption",
  CellTags->{"S2.3.1", "1.23"}],

Cell[CellGroupData[{
Cell[16091, 578, 140, 5, 70, "Input",
  CellTags->"S2.3.1"],
Cell[16234, 585, 99, 3, 70, "Output",
  CellTags->"S2.3.1"]
}, Open  ]],
Cell[16348, 591, 381, 9, 70, "Text",
  CellTags->{"S2.3.1", "1.24"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16766, 605, 99, 1, 70, "Subsection",
  CellTags->{"S2.3.2", "2.1"}],
Cell[16868, 608, 2850, 90, 70, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[19721, 700, 80, 1, 70, "Caption",
  CellTags->"S2.3.2"],
Cell[19804, 703, 163, 5, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.2"}],

Cell[CellGroupData[{
Cell[19992, 712, 97, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[20092, 716, 93, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[20200, 722, 126, 4, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.3"}],

Cell[CellGroupData[{
Cell[20351, 730, 97, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[20451, 734, 82, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[20548, 740, 254, 6, 70, "Text",
  CellTags->{"S2.3.2", "2.4"}],
Cell[20805, 748, 2633, 81, 70, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[23441, 831, 98, 1, 70, "Caption",
  CellTags->"S2.3.2"],
Cell[23542, 834, 138, 5, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.5"}],

Cell[CellGroupData[{
Cell[23705, 843, 102, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[23810, 847, 87, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[23912, 853, 196, 6, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.6"}],

Cell[CellGroupData[{
Cell[24133, 863, 111, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[24247, 867, 93, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[24355, 873, 1511, 48, 70, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[25869, 923, 85, 1, 70, "Caption",
  CellTags->"S2.3.2"],
Cell[25957, 926, 176, 5, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.7"}],

Cell[CellGroupData[{
Cell[26158, 935, 119, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[26280, 939, 94, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[26389, 945, 333, 12, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.8"}],

Cell[CellGroupData[{
Cell[26747, 961, 113, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[26863, 965, 108, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[26986, 971, 1307, 41, 70, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[28296, 1014, 93, 1, 70, "Caption",
  CellTags->"S2.3.2"],
Cell[28392, 1017, 142, 5, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.9"}],

Cell[CellGroupData[{
Cell[28559, 1026, 104, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[28666, 1030, 90, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[28771, 1036, 105, 1, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.10"}],

Cell[CellGroupData[{
Cell[28901, 1041, 118, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[29022, 1045, 90, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[29127, 1051, 780, 25, 70, "DefinitionBox",
  CellTags->"S2.3.2"],
Cell[29910, 1078, 101, 1, 70, "Caption",
  CellTags->"S2.3.2"],
Cell[30014, 1081, 127, 4, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.11"}],

Cell[CellGroupData[{
Cell[30166, 1089, 106, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[30275, 1093, 166, 4, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]],
Cell[30456, 1100, 196, 5, 70, "MathCaption",
  CellTags->{"S2.3.2", "2.12"}],

Cell[CellGroupData[{
Cell[30677, 1109, 124, 2, 70, "Input",
  CellTags->"S2.3.2"],
Cell[30804, 1113, 91, 3, 70, "Output",
  CellTags->"S2.3.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30944, 1122, 84, 1, 70, "Subsection",
  CellTags->{"S2.3.3", "3.1"}],
Cell[31031, 1125, 416, 10, 70, "Text",
  CellTags->{"S2.3.3", "3.2"}],
Cell[31450, 1137, 349, 10, 70, "Text",
  CellTags->{"S2.3.3", "3.3"}],
Cell[31802, 1149, 595, 24, 70, "Text",
  CellTags->{"S2.3.3", "3.4"}],
Cell[32400, 1175, 190, 6, 70, "MathCaption",
  CellTags->{"S2.3.3", "3.5"}],

Cell[CellGroupData[{
Cell[32615, 1185, 103, 2, 70, "Input",
  CellTags->"S2.3.3"],
Cell[32721, 1189, 96, 3, 70, "Output",
  CellTags->"S2.3.3"]
}, Open  ]],
Cell[32832, 1195, 533, 13, 70, "Text",
  CellTags->{"S2.3.3", "3.6"}],
Cell[33368, 1210, 966, 31, 70, "DefinitionBox",
  CellTags->"S2.3.3"],
Cell[34337, 1243, 62, 1, 70, "Caption",
  CellTags->"S2.3.3"],
Cell[34402, 1246, 236, 6, 70, "MathCaption",
  CellTags->{"S2.3.3", "3.7"}],

Cell[CellGroupData[{
Cell[34663, 1256, 90, 2, 70, "Input",
  CellTags->"S2.3.3"],
Cell[34756, 1260, 88, 3, 70, "Output",
  CellTags->"S2.3.3"]
}, Open  ]],
Cell[34859, 1266, 185, 7, 70, "MathCaption",
  CellTags->{"S2.3.3", "3.8"}],

Cell[CellGroupData[{
Cell[35069, 1277, 94, 2, 70, "Input",
  CellTags->"S2.3.3"],
Cell[35166, 1281, 91, 3, 70, "Output",
  CellTags->"S2.3.3"]
}, Open  ]],
Cell[35272, 1287, 222, 5, 70, "Text",
  CellTags->{"S2.3.3", "3.9"}],
Cell[35497, 1294, 92, 1, 70, "MathCaption",
  CellTags->{"S2.3.3", "3.10"}],

Cell[CellGroupData[{
Cell[35614, 1299, 116, 2, 70, "Input",
  CellTags->"S2.3.3"],
Cell[35733, 1303, 87, 3, 70, "Output",
  CellTags->"S2.3.3"]
}, Open  ]],
Cell[35835, 1309, 188, 5, 70, "MathCaption",
  CellTags->{"S2.3.3", "3.11"}],

Cell[CellGroupData[{
Cell[36048, 1318, 119, 2, 70, "Input",
  CellTags->"S2.3.3"],
Cell[36170, 1322, 105, 3, 70, "Output",
  CellTags->"S2.3.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36324, 1331, 101, 1, 70, "Subsection",
  CellTags->{"S2.3.4", "4.1"}],
Cell[36428, 1334, 332, 9, 70, "Text",
  CellTags->{"S2.3.4", "4.2"}],
Cell[36763, 1345, 438, 16, 70, "Text",
  CellTags->{"S2.3.4", "4.3"}],
Cell[37204, 1363, 1314, 41, 70, "DefinitionBox",
  CellTags->"S2.3.4"],
Cell[38521, 1406, 84, 1, 70, "Caption",
  CellTags->"S2.3.4"],
Cell[38608, 1409, 107, 1, 70, "MathCaption",
  CellTags->{"S2.3.4", "4.4"}],

Cell[CellGroupData[{
Cell[38740, 1414, 97, 2, 70, "Input",
  CellTags->"S2.3.4"],
Cell[38840, 1418, 99, 3, 70, "Output",
  CellTags->"S2.3.4"]
}, Open  ]],
Cell[38954, 1424, 325, 10, 70, "Text",
  CellTags->{"S2.3.4", "4.5"}],
Cell[39282, 1436, 175, 5, 70, "MathCaption",
  CellTags->{"S2.3.4", "4.6"}],
Cell[39460, 1443, 92, 2, 70, "Input",
  CellTags->"S2.3.4"],
Cell[39555, 1447, 168, 5, 70, "MathCaption",
  CellTags->{"S2.3.4", "4.7"}],

Cell[CellGroupData[{
Cell[39748, 1456, 83, 2, 70, "Input",
  CellTags->"S2.3.4"],
Cell[39834, 1460, 93, 3, 70, "Output",
  CellTags->"S2.3.4"]
}, Open  ]],
Cell[39942, 1466, 189, 7, 70, "MathCaption",
  CellTags->{"S2.3.4", "4.8"}],

Cell[CellGroupData[{
Cell[40156, 1477, 73, 2, 70, "Input",
  CellTags->"S2.3.4"],
Cell[40232, 1481, 91, 3, 70, "Output",
  CellTags->"S2.3.4"]
}, Open  ]],
Cell[40338, 1487, 116, 2, 70, "MathCaption",
  CellTags->{"S2.3.4", "4.9"}],
Cell[40457, 1491, 92, 2, 70, "Input",
  CellTags->"S2.3.4"],
Cell[40552, 1495, 126, 4, 70, "MathCaption",
  CellTags->{"S2.3.4", "4.10"}],

Cell[CellGroupData[{
Cell[40703, 1503, 96, 2, 70, "Input",
  CellTags->"S2.3.4"],
Cell[40802, 1507, 117, 3, 70, "Output",
  CellTags->"S2.3.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40968, 1516, 90, 1, 70, "Subsection",
  CellTags->{"S2.3.5", "5.1"}],
Cell[41061, 1519, 639, 16, 70, "Text",
  CellTags->{"S2.3.5", "5.2"}],
Cell[41703, 1537, 1334, 44, 70, "DefinitionBox",
  CellTags->"S2.3.5"],
Cell[43040, 1583, 98, 1, 70, "Caption",
  CellTags->"S2.3.5"],
Cell[43141, 1586, 209, 7, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.3"}],
Cell[43353, 1595, 86, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[43442, 1599, 165, 5, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.4"}],

Cell[CellGroupData[{
Cell[43632, 1608, 80, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[43715, 1612, 98, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[43828, 1618, 100, 1, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.5"}],

Cell[CellGroupData[{
Cell[43953, 1623, 98, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[44054, 1627, 97, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[44166, 1633, 854, 28, 70, "Text",
  CellTags->{"S2.3.5", "5.6"}],
Cell[45023, 1663, 193, 6, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.7"}],
Cell[45219, 1671, 87, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[45309, 1675, 149, 4, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.8"}],

Cell[CellGroupData[{
Cell[45483, 1683, 82, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[45568, 1687, 99, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[45682, 1693, 442, 10, 70, "Text",
  CellTags->{"S2.3.5", "5.9"}],
Cell[46127, 1705, 260, 11, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.10"}],
Cell[46390, 1718, 85, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[46478, 1722, 133, 4, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.11"}],

Cell[CellGroupData[{
Cell[46636, 1730, 79, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[46718, 1734, 88, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[46821, 1740, 195, 5, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.12"}],

Cell[CellGroupData[{
Cell[47041, 1749, 72, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[47116, 1753, 93, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[47224, 1759, 370, 17, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.13"}],
Cell[47597, 1778, 95, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[47695, 1782, 99, 1, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.14"}],

Cell[CellGroupData[{
Cell[47819, 1787, 73, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[47895, 1791, 86, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[47996, 1797, 1347, 38, 70, "Text",
  CellTags->{"S2.3.5", "5.15"}],
Cell[49346, 1837, 907, 45, 70, "Text",
  CellTags->{"S2.3.5", "5.16"}],
Cell[50256, 1884, 478, 11, 70, "Text",
  CellTags->{"S2.3.5", "5.17"}],
Cell[50737, 1897, 235, 7, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.18"}],

Cell[CellGroupData[{
Cell[50997, 1908, 121, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[51121, 1912, 110, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[51246, 1918, 168, 5, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.19"}],

Cell[CellGroupData[{
Cell[51439, 1927, 116, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[51558, 1931, 107, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[51680, 1937, 550, 13, 70, "Text",
  CellTags->{"S2.3.5", "5.20"}],
Cell[52233, 1952, 4944, 146, 70, "DefinitionBox",
  CellTags->"S2.3.5"],
Cell[57180, 2100, 118, 4, 70, "Caption",
  CellTags->"S2.3.5"],
Cell[57301, 2106, 128, 4, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.21"}],

Cell[CellGroupData[{
Cell[57454, 2114, 113, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[57570, 2118, 120, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[57705, 2124, 108, 1, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.22"}],
Cell[57816, 2127, 111, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[57930, 2131, 106, 1, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.23"}],

Cell[CellGroupData[{
Cell[58061, 2136, 105, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[58169, 2140, 120, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[58304, 2146, 367, 10, 70, "Text",
  CellTags->{"S2.3.5", "5.24"}],
Cell[58674, 2158, 163, 6, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.25"}],

Cell[CellGroupData[{
Cell[58862, 2168, 79, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[58944, 2172, 86, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[59045, 2178, 186, 7, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.26"}],

Cell[CellGroupData[{
Cell[59256, 2189, 76, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[59335, 2193, 87, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[59437, 2199, 1224, 43, 70, "Text",
  CellTags->{"S2.3.5", "5.27"}],
Cell[60664, 2244, 3983, 128, 70, "DefinitionBox",
  CellTags->"S2.3.5"],
Cell[64650, 2374, 116, 4, 70, "Caption",
  CellTags->"S2.3.5"],
Cell[64769, 2380, 265, 9, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.28"}],

Cell[CellGroupData[{
Cell[65059, 2393, 82, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[65144, 2397, 103, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[65262, 2403, 238, 11, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.29"}],

Cell[CellGroupData[{
Cell[65525, 2418, 85, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[65613, 2422, 87, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[65715, 2428, 202, 9, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.30"}],

Cell[CellGroupData[{
Cell[65942, 2441, 83, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[66028, 2445, 87, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[66130, 2451, 228, 8, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.31"}],
Cell[66361, 2461, 105, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[66469, 2465, 187, 7, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.32"}],

Cell[CellGroupData[{
Cell[66681, 2476, 96, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[66780, 2480, 124, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[66919, 2486, 667, 20, 70, "DefinitionBox",
  CellTags->"S2.3.5"],
Cell[67589, 2508, 76, 1, 70, "Caption",
  CellTags->"S2.3.5"],
Cell[67668, 2511, 696, 24, 70, "Text",
  CellTags->{"S2.3.5", "5.33"}],
Cell[68367, 2537, 201, 7, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.34"}],
Cell[68571, 2546, 85, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[68659, 2550, 160, 5, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.35"}],

Cell[CellGroupData[{
Cell[68844, 2559, 87, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[68934, 2563, 123, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[69072, 2569, 160, 4, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.36"}],
Cell[69235, 2575, 138, 5, 70, "Input",
  CellTags->"S2.3.5"],
Cell[69376, 2582, 101, 1, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.37"}],

Cell[CellGroupData[{
Cell[69502, 2587, 100, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[69605, 2591, 113, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[69733, 2597, 987, 31, 70, "DefinitionBox",
  CellTags->"S2.3.5"],
Cell[70723, 2630, 67, 1, 70, "Caption",
  CellTags->"S2.3.5"],
Cell[70793, 2633, 133, 5, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.38"}],

Cell[CellGroupData[{
Cell[70951, 2642, 98, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[71052, 2646, 91, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[71158, 2652, 135, 4, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.39"}],

Cell[CellGroupData[{
Cell[71318, 2660, 111, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[71432, 2664, 94, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[71541, 2670, 139, 5, 70, "MathCaption",
  CellTags->{"S2.3.5", "5.40"}],

Cell[CellGroupData[{
Cell[71705, 2679, 114, 2, 70, "Input",
  CellTags->"S2.3.5"],
Cell[71822, 2683, 88, 3, 70, "Output",
  CellTags->"S2.3.5"]
}, Open  ]],
Cell[71925, 2689, 580, 21, 70, "Text",
  CellTags->{"S2.3.5", "5.41"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[72542, 2715, 90, 1, 70, "Subsection",
  CellTags->{"S2.3.6", "6.1"}],
Cell[72635, 2718, 920, 27, 70, "DefinitionBox",
  CellTags->"S2.3.6"],
Cell[73558, 2747, 88, 1, 70, "Caption",
  CellTags->"S2.3.6"],
Cell[73649, 2750, 243, 11, 70, "MathCaption",
  CellTags->{"S2.3.6", "6.2"}],
Cell[73895, 2763, 77, 2, 70, "Input",
  CellTags->"S2.3.6"],
Cell[73975, 2767, 126, 5, 70, "MathCaption",
  CellTags->{"S2.3.6", "6.3"}],

Cell[CellGroupData[{
Cell[74126, 2776, 88, 2, 70, "Input",
  CellTags->"S2.3.6"],
Cell[74217, 2780, 99, 3, 70, "Output",
  CellTags->"S2.3.6"]
}, Open  ]],
Cell[74331, 2786, 109, 1, 70, "MathCaption",
  CellTags->{"S2.3.6", "6.4"}],

Cell[CellGroupData[{
Cell[74465, 2791, 92, 2, 70, "Input",
  CellTags->"S2.3.6"],
Cell[74560, 2795, 93, 3, 70, "Output",
  CellTags->"S2.3.6"]
}, Open  ]],
Cell[74668, 2801, 143, 4, 70, "MathCaption",
  CellTags->{"S2.3.6", "6.5"}],

Cell[CellGroupData[{
Cell[74836, 2809, 103, 2, 70, "Input",
  CellTags->"S2.3.6"],
Cell[74942, 2813, 99, 3, 70, "Output",
  CellTags->"S2.3.6"]
}, Open  ]],
Cell[75056, 2819, 932, 28, 70, "Text",
  CellTags->{"S2.3.6", "6.6"}],
Cell[75991, 2849, 215, 9, 70, "MathCaption",
  CellTags->{"S2.3.6", "6.7"}],

Cell[CellGroupData[{
Cell[76231, 2862, 116, 2, 70, "Input",
  CellTags->"S2.3.6"],
Cell[76350, 2866, 114, 3, 70, "Output",
  CellTags->"S2.3.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[76513, 2875, 87, 1, 70, "Subsection",
  CellTags->{"S2.3.7", "7.1"}],
Cell[76603, 2878, 402, 11, 70, "Text",
  CellTags->{"S2.3.7", "7.2"}],
Cell[77008, 2891, 827, 42, 70, "Text",
  CellTags->{"S2.3.7", "7.3"}],
Cell[77838, 2935, 114, 2, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.4"}],

Cell[CellGroupData[{
Cell[77977, 2941, 104, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[78084, 2945, 88, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[78187, 2951, 301, 11, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.5"}],

Cell[CellGroupData[{
Cell[78513, 2966, 104, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[78620, 2970, 88, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[78723, 2976, 2246, 88, 70, "Text",
  CellTags->{"S2.3.7", "7.6"}],
Cell[80972, 3066, 621, 26, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.7"}],

Cell[CellGroupData[{
Cell[81618, 3096, 116, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[81737, 3100, 91, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[81843, 3106, 133, 4, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.8"}],

Cell[CellGroupData[{
Cell[82001, 3114, 137, 5, 70, "Input",
  CellTags->"S2.3.7"],
Cell[82141, 3121, 105, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[82261, 3127, 609, 14, 70, "Text",
  CellTags->{"S2.3.7", "7.9"}],
Cell[82873, 3143, 3556, 112, 70, "DefinitionBox",
  CellTags->"S2.3.7"],
Cell[86432, 3257, 92, 1, 70, "Caption",
  CellTags->"S2.3.7"],
Cell[86527, 3260, 208, 8, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.10"}],

Cell[CellGroupData[{
Cell[86760, 3272, 80, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[86843, 3276, 156, 4, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[87014, 3283, 158, 5, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.11"}],
Cell[87175, 3290, 91, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[87269, 3294, 155, 5, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.12"}],

Cell[CellGroupData[{
Cell[87449, 3303, 74, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[87526, 3307, 91, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[87632, 3313, 190, 6, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.13"}],

Cell[CellGroupData[{
Cell[87847, 3323, 124, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[87974, 3327, 91, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[88080, 3333, 773, 32, 70, "Text",
  CellTags->{"S2.3.7", "7.14"}],
Cell[88856, 3367, 799, 39, 70, "Text",
  CellTags->{"S2.3.7", "7.15"}],
Cell[89658, 3408, 311, 15, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.16"}],

Cell[CellGroupData[{
Cell[89994, 3427, 101, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[90098, 3431, 92, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[90205, 3437, 221, 7, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.17"}],

Cell[CellGroupData[{
Cell[90451, 3448, 106, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[90560, 3452, 97, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[90672, 3458, 92, 1, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.18"}],

Cell[CellGroupData[{
Cell[90789, 3463, 113, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[90905, 3467, 167, 4, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[91087, 3474, 217, 11, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.19"}],

Cell[CellGroupData[{
Cell[91329, 3489, 117, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[91449, 3493, 97, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[91561, 3499, 372, 7, 70, "Text",
  CellTags->{"S2.3.7", "7.20"}],
Cell[91936, 3508, 139, 4, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.21"}],

Cell[CellGroupData[{
Cell[92100, 3516, 88, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[92191, 3520, 87, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[92293, 3526, 98, 1, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.22"}],

Cell[CellGroupData[{
Cell[92416, 3531, 119, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[92538, 3535, 104, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[92657, 3541, 293, 10, 70, "Text",
  CellTags->{"S2.3.7", "7.23"}],
Cell[92953, 3553, 194, 7, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.24"}],

Cell[CellGroupData[{
Cell[93172, 3564, 113, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[93288, 3568, 97, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[93400, 3574, 178, 7, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.25"}],
Cell[93581, 3583, 87, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[93671, 3587, 293, 12, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.26"}],

Cell[CellGroupData[{
Cell[93989, 3603, 100, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[94092, 3607, 93, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[94200, 3613, 297, 12, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.27"}],

Cell[CellGroupData[{
Cell[94522, 3629, 100, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[94625, 3633, 99, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[94739, 3639, 1286, 45, 70, "Text",
  CellTags->{"S2.3.7", "7.28"}],
Cell[96028, 3686, 182, 7, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.29"}],
Cell[96213, 3695, 94, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[96310, 3699, 195, 7, 70, "MathCaption",
  CellTags->{"S2.3.7", "7.30"}],

Cell[CellGroupData[{
Cell[96530, 3710, 100, 2, 70, "Input",
  CellTags->"S2.3.7"],
Cell[96633, 3714, 96, 3, 70, "Output",
  CellTags->"S2.3.7"]
}, Open  ]],
Cell[96744, 3720, 582, 20, 70, "Text",
  CellTags->{"S2.3.7", "7.31"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[97363, 3745, 103, 1, 70, "Subsection",
  CellTags->{"S2.3.8", "8.1"}],
Cell[97469, 3748, 441, 15, 70, "Text",
  CellTags->{"S2.3.8", "8.2"}],
Cell[97913, 3765, 367, 11, 70, "Text",
  CellTags->{"S2.3.8", "8.3"}],
Cell[98283, 3778, 241, 11, 70, "MathCaption",
  CellTags->{"S2.3.8", "8.4"}],

Cell[CellGroupData[{
Cell[98549, 3793, 98, 2, 70, "Input",
  CellTags->"S2.3.8"],
Cell[98650, 3797, 109, 3, 70, "Output",
  CellTags->"S2.3.8"]
}, Open  ]],
Cell[98774, 3803, 190, 6, 70, "MathCaption",
  CellTags->{"S2.3.8", "8.5"}],
Cell[98967, 3811, 111, 2, 70, "Input",
  CellTags->"S2.3.8"],
Cell[99081, 3815, 134, 4, 70, "MathCaption",
  CellTags->{"S2.3.8", "8.6"}],

Cell[CellGroupData[{
Cell[99240, 3823, 83, 2, 70, "Input",
  CellTags->"S2.3.8"],
Cell[99326, 3827, 102, 3, 70, "Output",
  CellTags->"S2.3.8"]
}, Open  ]],
Cell[99443, 3833, 974, 26, 70, "Text",
  CellTags->{"S2.3.8", "8.7"}],
Cell[100420, 3861, 2129, 67, 70, "DefinitionBox",
  CellTags->"S2.3.8"],
Cell[102552, 3930, 72, 1, 70, "Caption",
  CellTags->"S2.3.8"],
Cell[102627, 3933, 453, 14, 70, "Text",
  CellTags->{"S2.3.8", "8.8"}],
Cell[103083, 3949, 359, 7, 70, "Text",
  CellTags->{"S2.3.8", "8.9"}],
Cell[103445, 3958, 160, 5, 70, "MathCaption",
  CellTags->{"S2.3.8", "8.10"}],

Cell[CellGroupData[{
Cell[103630, 3967, 118, 2, 70, "Input",
  CellTags->"S2.3.8"],
Cell[103751, 3971, 138, 3, 70, "Output",
  CellTags->"S2.3.8"]
}, Open  ]],
Cell[103904, 3977, 190, 5, 70, "MathCaption",
  CellTags->{"S2.3.8", "8.11"}],

Cell[CellGroupData[{
Cell[104119, 3986, 111, 2, 70, "Input",
  CellTags->"S2.3.8"],
Cell[104233, 3990, 123, 3, 70, "Output",
  CellTags->"S2.3.8"]
}, Open  ]],
Cell[104371, 3996, 133, 4, 70, "MathCaption",
  CellTags->{"S2.3.8", "8.12"}],

Cell[CellGroupData[{
Cell[104529, 4004, 116, 2, 70, "Input",
  CellTags->"S2.3.8"],
Cell[104648, 4008, 178, 4, 70, "Output",
  CellTags->"S2.3.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104875, 4018, 89, 1, 70, "Subsection",
  CellTags->{"S2.3.9", "9.1"}],
Cell[104967, 4021, 435, 12, 70, "Text",
  CellTags->{"S2.3.9", "9.2"}],
Cell[105405, 4035, 367, 15, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.3"}],
Cell[105775, 4052, 96, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[105874, 4056, 135, 5, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.4"}],

Cell[CellGroupData[{
Cell[106034, 4065, 71, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[106108, 4069, 92, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[106215, 4075, 175, 7, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.5"}],

Cell[CellGroupData[{
Cell[106415, 4086, 68, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[106486, 4090, 92, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[106593, 4096, 1215, 41, 70, "DefinitionBox",
  CellTags->"S2.3.9"],
Cell[107811, 4139, 78, 1, 70, "Caption",
  CellTags->"S2.3.9"],
Cell[107892, 4142, 489, 13, 70, "Text",
  CellTags->{"S2.3.9", "9.6"}],
Cell[108384, 4157, 1190, 42, 70, "DefinitionBox",
  CellTags->"S2.3.9"],
Cell[109577, 4201, 77, 1, 70, "Caption",
  CellTags->"S2.3.9"],
Cell[109657, 4204, 334, 15, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.7"}],

Cell[CellGroupData[{
Cell[110016, 4223, 106, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[110125, 4227, 99, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[110239, 4233, 772, 31, 70, "Text",
  CellTags->{"S2.3.9", "9.8"}],
Cell[111014, 4266, 371, 9, 70, "Text",
  CellTags->{"S2.3.9", "9.9"}],
Cell[111388, 4277, 229, 11, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.10"}],

Cell[CellGroupData[{
Cell[111642, 4292, 105, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[111750, 4296, 100, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[111865, 4302, 146, 4, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.11"}],

Cell[CellGroupData[{
Cell[112036, 4310, 106, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[112145, 4314, 103, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[112263, 4320, 271, 13, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.12"}],
Cell[112537, 4335, 96, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[112636, 4339, 232, 10, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.13"}],

Cell[CellGroupData[{
Cell[112893, 4353, 77, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[112973, 4357, 88, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[113076, 4363, 373, 17, 70, "MathCaption",
  CellTags->{"S2.3.9", "9.14"}],

Cell[CellGroupData[{
Cell[113474, 4384, 73, 2, 70, "Input",
  CellTags->"S2.3.9"],
Cell[113550, 4388, 88, 3, 70, "Output",
  CellTags->"S2.3.9"]
}, Open  ]],
Cell[113653, 4394, 436, 14, 70, "Text",
  CellTags->{"S2.3.9", "9.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[114126, 4413, 106, 1, 70, "Subsection",
  CellTags->{"S2.3.10", "10.1"}],
Cell[114235, 4416, 374, 7, 70, "Text",
  CellTags->{"S2.3.10", "10.2"}],
Cell[114612, 4425, 318, 9, 70, "Text",
  CellTags->{"S2.3.10", "10.3"}],
Cell[114933, 4436, 663, 18, 70, "Text",
  CellTags->{"S2.3.10", "10.4"}],
Cell[115599, 4456, 212, 6, 70, "Text",
  CellTags->{"S2.3.10", "10.5"}],
Cell[115814, 4464, 899, 28, 70, "DefinitionBox",
  CellTags->"S2.3.10"],
Cell[116716, 4494, 89, 1, 70, "Caption",
  CellTags->"S2.3.10"],
Cell[116808, 4497, 245, 6, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.6"}],
Cell[117056, 4505, 101, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[117160, 4509, 104, 1, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.7"}],
Cell[117267, 4512, 109, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[117379, 4516, 346, 12, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.8"}],

Cell[CellGroupData[{
Cell[117750, 4532, 73, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[117826, 4536, 94, 3, 70, "Output",
  CellTags->"S2.3.10"]
}, Open  ]],
Cell[117935, 4542, 545, 11, 70, "Text",
  CellTags->{"S2.3.10", "10.9"}],
Cell[118483, 4555, 632, 16, 70, "Text",
  CellTags->{"S2.3.10", "10.10"}],
Cell[119118, 4573, 352, 10, 70, "Text",
  CellTags->{"S2.3.10", "10.11"}],
Cell[119473, 4585, 1323, 44, 70, "DefinitionBox",
  CellTags->"S2.3.10"],
Cell[120799, 4631, 59, 1, 70, "Caption",
  CellTags->"S2.3.10"],
Cell[120861, 4634, 252, 9, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.12"}],

Cell[CellGroupData[{
Cell[121138, 4647, 103, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[121244, 4651, 114, 3, 70, "Output",
  CellTags->"S2.3.10"]
}, Open  ]],
Cell[121373, 4657, 140, 5, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.13"}],

Cell[CellGroupData[{
Cell[121538, 4666, 84, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[121625, 4670, 83, 3, 70, "Output",
  CellTags->"S2.3.10"]
}, Open  ]],
Cell[121723, 4676, 249, 9, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.14"}],

Cell[CellGroupData[{
Cell[121997, 4689, 95, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[122095, 4693, 83, 3, 70, "Output",
  CellTags->"S2.3.10"]
}, Open  ]],
Cell[122193, 4699, 210, 5, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.15"}],
Cell[122406, 4706, 115, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[122524, 4710, 174, 5, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.16"}],

Cell[CellGroupData[{
Cell[122723, 4719, 70, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[122796, 4723, 89, 3, 70, "Output",
  CellTags->"S2.3.10"]
}, Open  ]],
Cell[122900, 4729, 243, 7, 70, "MathCaption",
  CellTags->{"S2.3.10", "10.17"}],

Cell[CellGroupData[{
Cell[123168, 4740, 79, 2, 70, "Input",
  CellTags->"S2.3.10"],
Cell[123250, 4744, 89, 3, 70, "Output",
  CellTags->"S2.3.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[123388, 4753, 79, 1, 70, "Subsection",
  CellTags->{"S2.3.11", "11.1"}],
Cell[123470, 4756, 641, 18, 70, "DefinitionBox",
  CellTags->"S2.3.11"],
Cell[124114, 4776, 61, 1, 70, "Caption",
  CellTags->"S2.3.11"],
Cell[124178, 4779, 789, 30, 70, "Text",
  CellTags->{"S2.3.11", "11.2"}],
Cell[124970, 4811, 205, 7, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.3"}],

Cell[CellGroupData[{
Cell[125200, 4822, 112, 2, 70, "Input",
  CellTags->"S2.3.11"],
Cell[125315, 4826, 100, 3, 70, "Output",
  CellTags->"S2.3.11"]
}, Open  ]],
Cell[125430, 4832, 214, 7, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.4"}],

Cell[CellGroupData[{
Cell[125669, 4843, 139, 5, 70, "Input",
  CellTags->"S2.3.11"],
Cell[125811, 4850, 106, 3, 70, "Output",
  CellTags->"S2.3.11"]
}, Open  ]],
Cell[125932, 4856, 187, 7, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.5"}],

Cell[CellGroupData[{
Cell[126144, 4867, 118, 2, 70, "Input",
  CellTags->"S2.3.11"],
Cell[126265, 4871, 100, 3, 70, "Output",
  CellTags->"S2.3.11"]
}, Open  ]],
Cell[126380, 4877, 277, 8, 70, "Text",
  CellTags->{"S2.3.11", "11.6"}],
Cell[126660, 4887, 138, 4, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.7"}],
Cell[126801, 4893, 96, 2, 70, "Input",
  CellTags->"S2.3.11"],
Cell[126900, 4897, 93, 1, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.8"}],

Cell[CellGroupData[{
Cell[127018, 4902, 98, 2, 70, "Input",
  CellTags->"S2.3.11"],
Cell[127119, 4906, 110, 3, 70, "Output",
  CellTags->"S2.3.11"]
}, Open  ]],
Cell[127244, 4912, 143, 4, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.9"}],
Cell[127390, 4918, 98, 2, 70, "Input",
  CellTags->"S2.3.11"],
Cell[127491, 4922, 94, 1, 70, "MathCaption",
  CellTags->{"S2.3.11", "11.10"}],

Cell[CellGroupData[{
Cell[127610, 4927, 93, 2, 70, "Input",
  CellTags->"S2.3.11"],
Cell[127706, 4931, 104, 3, 70, "Output",
  CellTags->"S2.3.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[127859, 4940, 79, 1, 70, "Subsection",
  CellTags->{"S2.3.12", "12.1"}],
Cell[127941, 4943, 438, 12, 70, "DefinitionBox",
  CellTags->"S2.3.12"],
Cell[128382, 4957, 61, 1, 70, "Caption",
  CellTags->"S2.3.12"],
Cell[128446, 4960, 148, 5, 70, "MathCaption",
  CellTags->{"S2.3.12", "12.2"}],

Cell[CellGroupData[{
Cell[128619, 4969, 107, 2, 70, "Input",
  CellTags->"S2.3.12"],
Cell[128729, 4973, 105, 3, 70, "Output",
  CellTags->"S2.3.12"]
}, Open  ]],
Cell[128849, 4979, 240, 9, 70, "MathCaption",
  CellTags->{"S2.3.12", "12.3"}],

Cell[CellGroupData[{
Cell[129114, 4992, 117, 2, 70, "Input",
  CellTags->"S2.3.12"],
Cell[129234, 4996, 107, 3, 70, "Output",
  CellTags->"S2.3.12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[129390, 5005, 106, 1, 70, "Subsection",
  CellTags->{"S2.3.13", "13.1"}],
Cell[129499, 5008, 365, 9, 70, "Text",
  CellTags->{"S2.3.13", "13.2"}],
Cell[129867, 5019, 316, 7, 70, "Text",
  CellTags->{"S2.3.13", "13.3"}],
Cell[130186, 5028, 4565, 143, 70, "DefinitionBox",
  CellTags->"S2.3.13"],
Cell[134754, 5173, 77, 1, 70, "Caption",
  CellTags->"S2.3.13"],
Cell[134834, 5176, 97, 1, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.4"}],

Cell[CellGroupData[{
Cell[134956, 5181, 99, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[135058, 5185, 281, 8, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[135354, 5196, 110, 1, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.5"}],

Cell[CellGroupData[{
Cell[135489, 5201, 111, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[135603, 5205, 108, 3, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[135726, 5211, 351, 14, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.6"}],

Cell[CellGroupData[{
Cell[136102, 5229, 95, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[136200, 5233, 306, 9, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[136521, 5245, 191, 5, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.7"}],

Cell[CellGroupData[{
Cell[136737, 5254, 163, 5, 70, "Input",
  CellTags->"S2.3.13"],
Cell[136903, 5261, 126, 3, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[137044, 5267, 875, 21, 70, "Text",
  CellTags->{"S2.3.13", "13.8"}],
Cell[137922, 5290, 96, 1, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.9"}],

Cell[CellGroupData[{
Cell[138043, 5295, 91, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[138137, 5299, 124, 3, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[138276, 5305, 107, 1, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.10"}],

Cell[CellGroupData[{
Cell[138408, 5310, 76, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[138487, 5314, 368, 10, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[138870, 5327, 155, 4, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.11"}],

Cell[CellGroupData[{
Cell[139050, 5335, 86, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[139139, 5339, 149, 4, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[139303, 5346, 4282, 135, 70, "DefinitionBox",
  CellTags->"S2.3.13"],
Cell[143588, 5483, 91, 1, 70, "Caption",
  CellTags->"S2.3.13"],
Cell[143682, 5486, 147, 5, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.12"}],

Cell[CellGroupData[{
Cell[143854, 5495, 114, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[143971, 5499, 115, 3, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]],
Cell[144101, 5505, 2554, 77, 70, "DefinitionBox",
  CellTags->"S2.3.13"],
Cell[146658, 5584, 75, 1, 70, "Caption",
  CellTags->"S2.3.13"],
Cell[146736, 5587, 171, 4, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.13"}],
Cell[146910, 5593, 96, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[147009, 5597, 111, 1, 70, "MathCaption",
  CellTags->{"S2.3.13", "13.14"}],

Cell[CellGroupData[{
Cell[147145, 5602, 110, 2, 70, "Input",
  CellTags->"S2.3.13"],
Cell[147258, 5606, 100, 3, 70, "Output",
  CellTags->"S2.3.13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[147407, 5615, 112, 1, 70, "Subsection",
  CellTags->{"S2.3.14", "14.1"}],
Cell[147522, 5618, 345, 8, 70, "Text",
  CellTags->{"S2.3.14", "14.2"}],
Cell[147870, 5628, 336, 7, 70, "Text",
  CellTags->{"S2.3.14", "14.3"}],
Cell[148209, 5637, 10318, 305, 70, "DefinitionBox",
  CellTags->"S2.3.14"],
Cell[158530, 5944, 83, 1, 70, "Caption",
  CellTags->"S2.3.14"],
Cell[158616, 5947, 718, 23, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.4"}],
Cell[159337, 5972, 124, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[159464, 5976, 197, 5, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.5"}],

Cell[CellGroupData[{
Cell[159686, 5985, 94, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[159783, 5989, 149, 4, 70, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[159947, 5996, 218, 7, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.6"}],
Cell[160168, 6005, 121, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[160292, 6009, 241, 6, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.7"}],

Cell[CellGroupData[{
Cell[160558, 6019, 94, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[160655, 6023, 149, 4, 70, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[160819, 6030, 425, 15, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.8"}],
Cell[161247, 6047, 104, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[161354, 6051, 108, 1, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.9"}],

Cell[CellGroupData[{
Cell[161487, 6056, 94, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[161584, 6060, 131, 3, 70, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[161730, 6066, 663, 24, 70, "MathCaption",
  CellTags->{"S2.3.14", "14.10"}],
Cell[162396, 6092, 139, 5, 70, "Input",
  CellTags->"S2.3.14"],
Cell[162538, 6099, 99, 1, 40, "MathCaption",
  CellTags->{"S2.3.14", "14.11"}],

Cell[CellGroupData[{
Cell[162662, 6104, 94, 2, 70, "Input",
  CellTags->"S2.3.14"],
Cell[162759, 6108, 120, 3, 44, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[162894, 6114, 248, 7, 56, "MathCaption",
  CellTags->{"S2.3.14", "14.12"}],

Cell[CellGroupData[{
Cell[163167, 6125, 94, 2, 28, "Input",
  CellTags->"S2.3.14"],
Cell[163264, 6129, 120, 3, 44, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[163399, 6135, 347, 14, 56, "MathCaption",
  CellTags->{"S2.3.14", "14.13"}],
Cell[163749, 6151, 144, 5, 45, "Input",
  CellTags->"S2.3.14"],
Cell[163896, 6158, 177, 7, 40, "MathCaption",
  CellTags->{"S2.3.14", "14.14"}],

Cell[CellGroupData[{
Cell[164098, 6169, 83, 2, 28, "Input",
  CellTags->"S2.3.14"],
Cell[164184, 6173, 89, 3, 25, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[164288, 6179, 220, 9, 40, "MathCaption",
  CellTags->{"S2.3.14", "14.15"}],

Cell[CellGroupData[{
Cell[164533, 6192, 93, 2, 28, "Input",
  CellTags->"S2.3.14"],
Cell[164629, 6196, 114, 3, 45, "Output",
  CellTags->"S2.3.14"]
}, Open  ]],
Cell[164758, 6202, 167, 4, 56, "MathCaption",
  CellTags->{"S2.3.14", "14.16"}],
Cell[164928, 6208, 145, 5, 45, "Input",
  CellTags->"S2.3.14"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

