(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    138791,       4959]*)
(*NotebookOutlinePosition[    188114,       6384]*)
(*  CellTagsIndexPosition[    184176,       6228]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.4 ", "HeadingNumber"],
  "Manipulating Lists"
}], "Section",
  CellTags->{"S2.4.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.4.1 Constructing Lists", "Subsection",
  CellTags->{"S2.4.1", "1.1"}],

Cell[TextData[{
  "Lists are widely used in ",
  StyleBox["Mathematica", "TI"],
  ", and there are many ways to construct them.   "
}], "Text",
  CellTags->{"S2.4.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Range[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the list ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["2,", "MR"],
              " ",
              StyleBox["3,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the values of ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " from ",
              StyleBox["1", "MR"],
              " to ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the list ",
              StyleBox["{", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[1],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[2],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NestList[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " with up to ",
              StyleBox["n", "TI"],
              " nestings "
            }]]},
          {Cell[TextData[{
              " ",
              StyleBox["Normal[SparseArray[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "->",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, ",
              StyleBox["n", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "a length ",
              StyleBox["n", "TI"],
              " list with element ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " being ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Apply[List,", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "the list ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }",
              StyleBox[" ", "TR"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.1"],

Cell["Some explicit ways to construct lists. ", "Caption",
  CellTags->"S2.4.1"],

Cell["This gives a table of the first five powers of two. ", "MathCaption",
  CellTags->{"S2.4.1", "1.3"}],

Cell[CellGroupData[{

Cell["Table[2^i, {i, 5}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({2, 4, 8, 16, 32}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell["Here is another way to get the same result. ", "MathCaption",
  CellTags->{"S2.4.1", "1.4"}],

Cell[CellGroupData[{

Cell["Array[2^# &, 5]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({2, 4, 8, 16, 32}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell["This gives a similar list. ", "MathCaption",
  CellTags->{"S2.4.1", "1.5"}],

Cell[CellGroupData[{

Cell["NestList[2 #&, 1, 5]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({1, 2, 4, 8, 16, 32}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["SparseArray", "MR"],
  " lets you specify values at particular positions. "
}], "MathCaption",
  CellTags->{"S2.4.1", "1.6"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{3->x, 4->y}, 5]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({0, 0, x, y, 0}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell["You can also use patterns to specify values. ", "MathCaption",
  CellTags->{"S2.4.1", "1.7"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{i_ -> 2^i}, 5]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({2, 4, 8, 16, 32}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell["\<\
Often you will know in advance how long a list is supposed to be, \
and how each of its elements should be generated. And often you may get one \
list from another. \
\>", "Text",
  CellTags->{"S2.4.1", "1.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Map[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to each element of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MapIndexed[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["elem", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox["}]", "MR"],
              " for the ",
              StyleBox["i", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " element "
            }]]},
          {Cell[TextData[{
              StyleBox["Cases[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give elements of ",
              StyleBox["list", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Select[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "select elements for which ",
              StyleBox["test", "TI"],
              StyleBox["[", "MR"],
              StyleBox["elem", "TI"],
              StyleBox["]", "MR"],
              " is ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Pick[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pick out elements of ",
              StyleBox["list", "TI"],
              " for which the corresponding elements of ",
              StyleBox["sel", "TI"],
              " match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["list", "TI"],
              StyleBox["[[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              "  or  ",
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the specified parts of ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.1"],

Cell["Constructing lists from other lists. ", "Caption",
  CellTags->"S2.4.1"],

Cell["This selects elements larger than 5. ", "MathCaption",
  CellTags->{"S2.4.1", "1.9"}],

Cell[CellGroupData[{

Cell["Select[{1, 3, 6, 8, 10}, # > 5&]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({6, 8, 10}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell["This explicitly gives numbered parts. ", "MathCaption",
  CellTags->{"S2.4.1", "1.10"}],

Cell[CellGroupData[{

Cell["{a, b, c, d}[[{2, 1, 4}]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({b, a, d}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell[TextData[{
  "This picks out elements indicated by a ",
  StyleBox["1", "MR"],
  " in the second list. "
}], "MathCaption",
  CellTags->{"S2.4.1", "1.11"}],

Cell[CellGroupData[{

Cell["Pick[{a, b, c, d}, {1, 0, 1, 1}, 1]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({a, c, d}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell[TextData[{
  "Sometimes you may want to accumulate a list of results during the \
execution of a program. You can do this using ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.4.1", "1.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sow[", "MR"],
              StyleBox["val", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sow the value ",
              StyleBox["val", "TI"],
              " for the nearest enclosing ",
              StyleBox["Reap", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reap[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              ", returning also a list of values sown by ",
              StyleBox["Sow", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.1"],

Cell[TextData[{
  "Using ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.4.1"],

Cell["This program iteratively squares a number. ", "MathCaption",
  CellTags->{"S2.4.1", "1.13"}],

Cell[CellGroupData[{

Cell["Nest[#^2&, 2, 6]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \(18446744073709551616\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell["\<\
This does the same computation, but accumulating a list of \
intermediate results above 1000. \
\>", "MathCaption",
  CellTags->{"S2.4.1", "1.14"}],

Cell[CellGroupData[{

Cell["Reap[Nest[(If[# > 1000, Sow[#]]; #^2) &, 2, 6]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.4.1"],

Cell[BoxData[
    \({18446744073709551616, {{65536, 4294967296}}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.4.1"]
}, Open  ]],

Cell[TextData[{
  "An alternative but less efficient approach involves introducing a \
temporary variable, then starting with ",
  StyleBox["t", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["{}", "MR"],
  ", and successively using ",
  StyleBox["AppendTo[", "MR"],
  StyleBox["t", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.4.1", "1.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.2 Manipulating Lists by Their Indices", "Subsection",
  CellTags->{"S2.4.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox["]", "MR"],
              "  or  ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["spec", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell["part or parts of a list "]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              "  or  ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell["part or parts of a nested list "]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " part from the beginning "
            }]]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " part from the end "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["a list of parts "]},
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["all parts "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.4.2"],

Cell["Getting parts of lists. ", "Caption",
  CellTags->"S2.4.2"],

Cell["This gives a list of parts 1 and 3. ", "MathCaption",
  CellTags->{"S2.4.2", "2.2"}],

Cell[CellGroupData[{

Cell["{a, b, c, d}[[{1, 3}]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({a, c}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["Here is a nested list. ", "MathCaption",
  CellTags->{"S2.4.2", "2.3"}],

Cell["m = {{a, b, c}, {d, e}, {f, g, h}};", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.4.2"],

Cell["This gives a list of its first and third parts. ", "MathCaption",
  CellTags->{"S2.4.2", "2.4"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{a, b, c}, {f, g, h}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This gives a list of the first part of each of these. ", "MathCaption",
  CellTags->{"S2.4.2", "2.5"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}, 1]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({a, f}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["And this gives a list of the first two parts. ", "MathCaption",
  CellTags->{"S2.4.2", "2.6"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}, {1, 2}]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{a, b}, {f, g}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This gives the second part of all sublists. ", "MathCaption",
  CellTags->{"S2.4.2", "2.7"}],

Cell[CellGroupData[{

Cell["m[[All, 2]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({b, e, g}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "You can always reset one or more pieces of a list by doing an assignment \
like ",
  StyleBox["m", "TI"],
  StyleBox["[[", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ".   "
}], "Text",
  CellTags->{"S2.4.2", "2.8"}],

Cell[TextData[{
  "This resets part 1,2 of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.9"}],

Cell[CellGroupData[{

Cell["m[[1, 2]] = x", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "This is now the form of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.10"}],

Cell[CellGroupData[{

Cell["m", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{a, x, c}, {d, e}, {f, g, h}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "This resets part 1 to ",
  StyleBox["x", "MR"],
  " and part 3 to ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.11"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}]] = {x, y}; m", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({x, {d, e}, y}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "This resets parts 1 and 3 both to ",
  StyleBox["p", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.12"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}]] = p; m", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({p, {d, e}, p}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "This restores the original form of ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.13"}],

Cell["m = {{a, b, c}, {d, e}, {f, g, h}};", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.4.2"],

Cell[TextData[{
  "This now resets all parts specified by ",
  StyleBox["m[[{1,", "MR"],
  " ",
  StyleBox["3},", "MR"],
  " ",
  StyleBox["{1,", "MR"],
  " ",
  StyleBox["2}]]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.14"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}, {1, 2}]] = x; m", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{x, x, c}, {d, e}, {x, x, h}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Range", "MR"],
  " to indicate all indices in a given range. "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.15"}],

Cell[CellGroupData[{

Cell["m[[Range[1, 3], 2]] = y; m", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{x, y, c}, {d, y}, {x, y, h}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "It is sometimes useful to think of a nested list as being laid out in \
space, with each element being at a coordinate position given by its indices. \
There is then a direct geometrical interpretation for ",
  StyleBox["list", "TI"],
  StyleBox["[[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]]", "MR"],
  ". If a given ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], 
          StyleBox["k",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " is a single integer, then it represents extracting a single slice in the \
",
  StyleBox["k", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " dimension, while if it is a list, it represents extracting a list of \
parallel slices. The final result for ",
  StyleBox["list", "TI"],
  StyleBox["[[", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["spec",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]]", "MR"],
  " is then the collection of elements obtained by slicing in each successive \
dimension. "
}], "Text",
  CellTags->{"S2.4.2", "2.16"}],

Cell["\<\
Here is a nested list laid out as a two\[Hyphen]dimensional array. \
\
\>", "MathCaption",
  CellTags->{"S2.4.2", "2.17"}],

Cell[CellGroupData[{

Cell["(m = {{a, b, c}, {d, e, f}, {g, h, i}}) // TableForm", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b", "c"},
          {"d", "e", "f"},
          {"g", "h", "i"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[14]//TableForm= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This picks out rows 1 and 3, then columns 1 and 2. ", "MathCaption",
  CellTags->{"S2.4.2", "2.18"}],

Cell[CellGroupData[{

Cell["m[[{1, 3}, {1, 2}]] // TableForm", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b"},
          {"g", "h"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[15]//TableForm= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Part", "MR"],
  " is set up to make it easy to pick out structured slices of nested lists. \
Sometimes, however, you may want to pick out arbitrary collections of \
individual parts. You can do this conveniently with ",
  StyleBox["Extract", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.4.2", "2.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the list ",
              StyleBox["{", "MR"],
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]],", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Extract[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the element ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Part[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["parts specified by successive slicing "]},
          {Cell[TextData[{
              StyleBox["Extract[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "the list of individual parts ",
              StyleBox["{", "MR"],
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]],", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.4.2"],

Cell["Getting slices versus lists of individual parts. ", "Caption",
  CellTags->"S2.4.2"],

Cell["This extracts the individual parts 1,3 and 1,2. ", "MathCaption",
  CellTags->{"S2.4.2", "2.20"}],

Cell[CellGroupData[{

Cell["Extract[m, {{1, 3}, {1, 2}}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({c, b}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "An important feature of ",
  StyleBox["Extract", "MR"],
  " is that it takes lists of part positions in the same form as they are \
returned by functions like ",
  StyleBox["Position", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.4.2", "2.21"}],

Cell["This sets up a nested list. ", "MathCaption",
  CellTags->{"S2.4.2", "2.22"}],

Cell["m = {{a[1], a[2], b[1]}, {b[2], c[1]}, {{b[3]}}};", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.4.2"],

Cell[TextData[{
  "This gives a list of positions in ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.23"}],

Cell[CellGroupData[{

Cell["Position[m, b[_]]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{1, 3}, {2, 1}, {3, 1, 1}}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This extracts the elements at those positions. ", "MathCaption",
  CellTags->{"S2.4.2", "2.24"}],

Cell[CellGroupData[{

Cell["Extract[m, %]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({b[1], b[2], b[3]}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["take the specified parts of a list "]},
          {Cell[TextData[{
              StyleBox["Drop[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["drop the specified parts of a list "]},
          {Cell[TextData[{
              StyleBox["Take[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["Drop[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["spec",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "take or drop specified parts at each level in nested lists "]},
          {Cell[TextData[{
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the first ",
              StyleBox["n", "TI"],
              " elements "
            }]]},
          {Cell[TextData[{
              StyleBox["-", "MR"],
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "the last ",
              StyleBox["n", "TI"],
              " elements "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "element ",
              StyleBox["n", "TI"],
              " only "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "elements ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " (inclusive) "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "elements ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " in steps of ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["All", "MR"],
              " "
            }]], Cell["all parts "]},
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["no parts "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.4.2"],

Cell["Taking and dropping sequences of elements in lists. ", "Caption",
  CellTags->"S2.4.2"],

Cell["This takes every second element starting at position 2. ", "MathCaption",
  CellTags->{"S2.4.2", "2.25"}],

Cell[CellGroupData[{

Cell["Take[{a, b, c, d, e, f, g}, {2, -1, 2}]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({b, d, f}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This drops every second element. ", "MathCaption",
  CellTags->{"S2.4.2", "2.26"}],

Cell[CellGroupData[{

Cell["Drop[{a, b, c, d, e, f, g}, {2, -1, 2}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({a, c, e, g}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "Much like ",
  StyleBox["Part", "MR"],
  ", ",
  StyleBox["Take", "MR"],
  " and ",
  StyleBox["Drop", "MR"],
  " can be viewed as picking out sequences of slices at successive levels in \
a nested list. You can use ",
  StyleBox["Take", "MR"],
  " and ",
  StyleBox["Drop", "MR"],
  " to work with blocks of elements in arrays. "
}], "Text",
  CellTags->{"S2.4.2", "2.27"}],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.28"}],

Cell[CellGroupData[{

Cell["(m = {{a, b, c}, {d, e, f}, {g, h, i}}) // TableForm", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b", "c"},
          {"d", "e", "f"},
          {"g", "h", "i"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[22]//TableForm= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "Here is the first ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " subarray. "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.29"}],

Cell[CellGroupData[{

Cell["Take[m, 2, 2] // TableForm", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b"},
          {"d", "e"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[23]//TableForm= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This takes all elements in the first two columns. ", "MathCaption",
  CellTags->{"S2.4.2", "2.30"}],

Cell[CellGroupData[{

Cell["Take[m, All, 2] // TableForm", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b"},
          {"d", "e"},
          {"g", "h"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[24]//TableForm= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This leaves no elements from the first two columns. ", "MathCaption",
  CellTags->{"S2.4.2", "2.31"}],

Cell[CellGroupData[{

Cell["Drop[m, None, 2] // TableForm", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    TagBox[GridBox[{
          {"c"},
          {"f"},
          {"i"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[25]//TableForm= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Prepend[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["element", "TI"],
              " at the beginning of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Append[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["element", "TI"],
              " at the end of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Insert[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert ",
              StyleBox["element", "TI"],
              " at position ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Insert[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert at position ",
              StyleBox["i", "TI"],
              ", ",
              StyleBox["j", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Delete[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "delete the element at position ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Delete[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "delete at position ",
              StyleBox["i", "TI"],
              ", ",
              StyleBox["j", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.2"],

Cell["Adding and deleting elements in lists. ", "Caption",
  CellTags->"S2.4.2"],

Cell[TextData[{
  "This makes the 2,1 element of the list be ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.32"}],

Cell[CellGroupData[{

Cell["Insert[{{a, b, c}, {d, e}}, x, {2, 1}]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{a, b, c}, {x, d, e}}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["This deletes the element again. ", "MathCaption",
  CellTags->{"S2.4.2", "2.33"}],

Cell[CellGroupData[{

Cell["Delete[%, {2, 1}]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{a, b, c}, {d, e}}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["new", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace the element at position ",
              StyleBox["i", "TI"],
              " in ",
              StyleBox["list", "TI"],
              " with ",
              StyleBox["new", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["new", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " with ",
              StyleBox["new", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["new", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "replace all parts ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " with ",
              StyleBox["new", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["new", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "replace part ",
              StyleBox["list", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " with ",
              StyleBox["new", "TI"],
              StyleBox["[[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["]]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.2"],

Cell["Replacing parts of lists. ", "Caption",
  CellTags->"S2.4.2"],

Cell[TextData[{
  "This replaces the third element in the list with ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.34"}],

Cell[CellGroupData[{

Cell["ReplacePart[{a, b, c, d}, x, 3]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({a, b, x, d}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell["\<\
This replaces the first and fourth parts of the list. Notice the \
need for double lists in specifying multiple parts to replace. \
\>", \
"MathCaption",
  CellTags->{"S2.4.2", "2.35"}],

Cell[CellGroupData[{

Cell["ReplacePart[{a, b, c, d}, x, {{1}, {4}}]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({x, b, c, x}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " identity matrix. "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.36"}],

Cell[CellGroupData[{

Cell["IdentityMatrix[3]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S2.4.2"]
}, Open  ]],

Cell[TextData[{
  "This replaces the 2,2 component of the matrix by ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.2", "2.37"}],

Cell[CellGroupData[{

Cell["ReplacePart[%, x, {2, 2}]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.4.2"],

Cell[BoxData[
    \({{1, 0, 0}, {0, x, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S2.4.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.3 Nested Lists", "Subsection",
  CellTags->{"S2.4.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["list of lists "]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], " ", \(\(\[Cross]\)\(\ \)\), 
                      StyleBox["n",
                        "TI"], 
                      " ", \(\(\[Cross]\)\(\ \)\), \(\(\[Ellipsis]\)\(\ \
\)\)}], TraditionalForm]], "InlineFormula"],
              " table of values of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Array[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], " ", \(\(\[Cross]\)\(\ \)\), 
                      StyleBox["n",
                        "TI"], 
                      " ", \(\(\[Cross]\)\(\ \)\), \(\(\[Ellipsis]\)\(\ \
\)\)}], TraditionalForm]], "InlineFormula"],
              " array of values ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["j", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Normal[SparseArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], " ", \(\(\[Cross]\)\(\ \)\), 
                      StyleBox["n",
                        "TI"], 
                      " ", \(\(\[Cross]\)\(\ \)\), \(\(\[Ellipsis]\)\(\ \
\)\)}], TraditionalForm]], "InlineFormula"],
              " array with element ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["i",
                        "TI"], 
                      StyleBox["s",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["j",
                        "TI"], 
                      StyleBox["s",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ",\[Ellipsis] }",
              StyleBox[" being ", "TR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["v",
                        "TI"], 
                      StyleBox["s",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Outer[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["list",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generalized outer product with elements combined using ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Tuples[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "all possible ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        "TI"], " ", \(\(\[Cross]\)\(\ \)\), 
                      StyleBox["n",
                        "TI"], 
                      " ", \(\(\[Cross]\)\(\ \)\), \(\(\[Ellipsis]\)\(\ \
\)\)}], TraditionalForm]], "InlineFormula"],
              " arrays of elements from ",
              StyleBox["list", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.3"],

Cell["Ways to construct nested lists. ", "Caption",
  CellTags->"S2.4.3"],

Cell[TextData[{
  "This generates a table corresponding to a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " nested list. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.2"}],

Cell[CellGroupData[{

Cell["Table[x^i + j, {i, 2}, {j, 3}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{1 + x, 2 + x, 3 + x}, {1 + x\^2, 2 + x\^2, 3 + x\^2}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell["\<\
This generates an array corresponding to the same nested list. \
\
\>", "MathCaption",
  CellTags->{"S2.4.3", "3.3"}],

Cell[CellGroupData[{

Cell["Array[x^#1 + #2 &, {2, 3}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{1 + x, 2 + x, 3 + x}, {1 + x\^2, 2 + x\^2, 3 + x\^2}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[TextData[{
  "Elements not explicitly specified in the sparse array are taken to be ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.4"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{{1, 3} -> 3 + x}, {2, 3}]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{0, 0, 3 + x}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell["\<\
Each element in the final list contains one element from each input \
list. \
\>", "MathCaption",
  CellTags->{"S2.4.3", "3.5"}],

Cell[CellGroupData[{

Cell["Outer[f, {a, b}, {c, d}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{f[a, c], f[a, d]}, {f[b, c], f[b, d]}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Array", "MR"],
  ", ",
  StyleBox["SparseArray", "MR"],
  " and ",
  StyleBox["Outer", "MR"],
  " always generate ",
  StyleBox["full arrays", "TI"],
  ", in which all sublists at a particular level are the same length. "
}], "Text",
  CellTags->{"S2.4.3", "3.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Dimensions[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the dimensions of a full array "]},
          {Cell[TextData[{
              StyleBox["ArrayQ[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
test whether all sublists at a given level are the same \
length \
\>"]},
          {Cell[TextData[{
              StyleBox["ArrayDepth[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "the depth to which all sublists are the same length "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.3"],

Cell["Functions for full arrays. ", "Caption",
  CellTags->"S2.4.3"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can handle arbitrary nested lists. There is no need for the lists to form \
a full array. You can easily generate ragged arrays using ",
  StyleBox["Table", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.4.3", "3.7"}],

Cell["This generates a triangular array. ", "MathCaption",
  CellTags->{"S2.4.3", "3.8"}],

Cell[CellGroupData[{

Cell["Table[x^i + j, {i, 3}, {j, i}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{1 + x}, {1 + x\^2, 2 + x\^2}, {1 + x\^3, 2 + x\^3, 
        3 + x\^3}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten out all levels of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "flatten out the top ",
              StyleBox["n", "TI"],
              " levels "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.3"],

Cell["Flattening out sublists. ", "Caption",
  CellTags->"S2.4.3"],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.9"}],

Cell[CellGroupData[{

Cell["Array[a, {2, 3}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{a[1, 1], a[1, 2], a[1, 3]}, {a[2, 1], a[2, 2], a[2, 3]}}\)], "Output",\

  CellLabel->"Out[6]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Flatten", "MR"],
  " in effect puts elements in lexicographic order of their indices. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.10"}],

Cell[CellGroupData[{

Cell["Flatten[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({a[1, 1], a[1, 2], a[1, 3], a[2, 1], a[2, 2], a[2, 3]}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "transpose the top two levels of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Transpose[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "put the ",
              StyleBox["k", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " level in ",
              StyleBox["list", "TI"],
              " at level ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.3"],

Cell["Transposing levels in nested lists. ", "Caption",
  CellTags->"S2.4.3"],

Cell[TextData[{
  "This generates a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\[Cross]2\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.11"}],

Cell[CellGroupData[{

Cell["Array[a, {2, 2, 2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{{a[1, 1, 1], a[1, 1, 2]}, {a[1, 2, 1], a[1, 2, 2]}}, {{a[2, 1, 1], 
          a[2, 1, 2]}, {a[2, 2, 1], a[2, 2, 2]}}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell["This permutes levels so that level 3 appears at level 1. ", \
"MathCaption",
  CellTags->{"S2.4.3", "3.12"}],

Cell[CellGroupData[{

Cell["Transpose[%, {3, 1, 2}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{{a[1, 1, 1], a[2, 1, 1]}, {a[1, 1, 2], a[2, 1, 2]}}, {{a[1, 2, 1], 
          a[2, 2, 1]}, {a[1, 2, 2], a[2, 2, 2]}}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell["This restores the original array. ", "MathCaption",
  CellTags->{"S2.4.3", "3.13"}],

Cell[CellGroupData[{

Cell["Transpose[%, {2, 3, 1}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{{a[1, 1, 1], a[1, 1, 2]}, {a[1, 2, 1], a[1, 2, 2]}}, {{a[2, 1, 1], 
          a[2, 1, 2]}, {a[2, 2, 1], a[2, 2, 2]}}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Map[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "map ",
              StyleBox["f", "TI"],
              " across elements at level ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Apply[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to the elements at level ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MapIndexed[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "map ",
              StyleBox["f", "TI"],
              " onto parts at level ",
              StyleBox["n", "TI"],
              " and their indices "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.3"],

Cell["Applying functions in nested lists. ", "Caption",
  CellTags->"S2.4.3"],

Cell["Here is a nested list. ", "MathCaption",
  CellTags->{"S2.4.3", "3.14"}],

Cell["m = {{{a, b}, {c, d}}, {{e, f}, {g, h}, {i}}};", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.4.3"],

Cell[TextData[{
  "This maps a function ",
  StyleBox["f", "MR"],
  " at level 2. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.15"}],

Cell[CellGroupData[{

Cell["Map[f, m, {2}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{f[{a, b}], f[{c, d}]}, {f[{e, f}], f[{g, h}], f[{i}]}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell["This applies the function at level 2. ", "MathCaption",
  CellTags->{"S2.4.3", "3.16"}],

Cell[CellGroupData[{

Cell["Apply[f, m, {2}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{f[a, b], f[c, d]}, {f[e, f], f[g, h], f[i]}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to both parts and their indices. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.17"}],

Cell[CellGroupData[{

Cell["MapIndexed[f, m, {2}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{f[{a, b}, {1, 1}], f[{c, d}, {1, 2}]}, {f[{e, f}, {2, 1}], 
        f[{g, h}, {2, 2}], f[{i}, {2, 3}]}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "partition into ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "\[Ellipsis]"}], 
                    TraditionalForm]], "InlineFormula"],
              " blocks "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad on the left to make an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "\[Ellipsis]"}], 
                    TraditionalForm]], "InlineFormula"],
              " array "
            }]]},
          {Cell[TextData[{
              StyleBox["PadRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad on the right to make an ",
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["n",
                          "TI"], "2"], "\[Cross]", "\[Ellipsis]"}], 
                    TraditionalForm]], "InlineFormula"],
              " array "
            }]]},
          {Cell[TextData[{
              StyleBox["RotateLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "rotate ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " places to the left at level ",
              StyleBox["k", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RotateRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "rotate ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " places to the right at level ",
              StyleBox["k", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.3"],

Cell["Operations on nested lists. ", "Caption",
  CellTags->"S2.4.3"],

Cell["Here is a nested list. ", "MathCaption",
  CellTags->{"S2.4.3", "3.18"}],

Cell["m = {{{a, b, c}, {d, e}}, {{f, g}, {h}, {i}}};", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.4.3"],

Cell["This rotates different amounts at each level. ", "MathCaption",
  CellTags->{"S2.4.3", "3.19"}],

Cell[CellGroupData[{

Cell["RotateLeft[m, {0, 1, -1}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{{e, d}, {c, a, b}}, {{h}, {i}, {g, f}}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.4.3"]
}, Open  ]],

Cell[TextData[{
  "This pads with zeros to make a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]3\[Cross]3\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.4.3", "3.20"}],

Cell[CellGroupData[{

Cell["PadRight[%, {2, 3, 3}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.4.3"],

Cell[BoxData[
    \({{{e, d, 0}, {c, a, b}, {0, 0, 0}}, {{h, 0, 0}, {i, 0, 0}, {g, f, 
          0}}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.4.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.4 Partitioning and Padding Lists", "Subsection",
  CellTags->{"S2.4.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "partition ",
              StyleBox["list", "TI"],
              " into sublists of length ",
              StyleBox["n", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "partition into sublists with offset ",
              StyleBox["d", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Split[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split ",
              StyleBox["list", "TI"],
              " into runs of identical elements "
            }]]},
          {Cell[TextData[{
              StyleBox["Split[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split into runs with adjacent elements satisfying ",
              StyleBox["test", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.4.4"],

Cell["Partitioning elements in a list. ", "Caption",
  CellTags->"S2.4.4"],

Cell["This partitions in blocks of 3. ", "MathCaption",
  CellTags->{"S2.4.4", "4.2"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e, f}, 3]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {d, e, f}}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["This partitions in blocks of 3 with offset 1. ", "MathCaption",
  CellTags->{"S2.4.4", "4.3"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e, f}, 3, 1]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}, {d, e, f}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["The offset can be larger than the block size. ", "MathCaption",
  CellTags->{"S2.4.4", "4.4"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e, f}, 2, 3]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b}, {d, e}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["This splits into runs of identical elements. ", "MathCaption",
  CellTags->{"S2.4.4", "4.5"}],

Cell[CellGroupData[{

Cell["Split[{1, 4, 1, 1, 1, 2, 2, 3, 3}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{1}, {4}, {1, 1, 1}, {2, 2}, {3, 3}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["This splits into runs where adjacent elements are unequal. ", \
"MathCaption",
  CellTags->{"S2.4.4", "4.6"}],

Cell[CellGroupData[{

Cell["Split[{1, 4, 1, 1, 1, 2, 2, 3, 3}, Unequal]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{1, 4, 1}, {1}, {1, 2}, {2, 3}, {3}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Partition", "MR"],
  " in effect goes through a list, grouping successive elements into \
sublists. By default it does not include any sublists that would \
\[OpenCurlyDoubleQuote]overhang\[CloseCurlyDoubleQuote] the original list. "
}], "Text",
  CellTags->{"S2.4.4", "4.7"}],

Cell["This stops before any overhang occurs. ", "MathCaption",
  CellTags->{"S2.4.4", "4.8"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e}, 2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b}, {c, d}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["The same is true here. ", "MathCaption",
  CellTags->{"S2.4.4", "4.9"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e}, 3, 1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "You can tell ",
  StyleBox["Partition", "MR"],
  " to include sublists that overhang the ends of the original list. By \
default, it fills in additional elements by treating the original list as \
cyclic. It can also treat it as being padded with elements that you specify. \
"
}], "Text",
  CellTags->{"S2.4.4", "4.10"}],

Cell["\<\
This includes additional sublists, treating the original list as \
cyclic. \
\>", "MathCaption",
  CellTags->{"S2.4.4", "4.11"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e}, 3, 1, {1, 1}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}, {d, e, a}, {e, a, b}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "Now the original list is treated as being padded with the element ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.12"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e}, 3, 1, {1, 1}, x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}, {d, e, x}, {e, x, x}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "This pads cyclically with elements ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.13"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e}, 3, 1, {1, 1}, {x, y}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}, {d, e, y}, {e, y, x}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["\<\
This introduces no padding, yielding sublists of differing lengths. \
\
\>", "MathCaption",
  CellTags->{"S2.4.4", "4.14"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d, e}, 3, 1, {1, 1}, {}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}, {d, e}, {e}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "You can think of ",
  StyleBox["Partition", "MR"],
  " as extracting sublists by sliding a template along and picking out \
elements from the original list. You can tell ",
  StyleBox["Partition", "MR"],
  " where to start and stop this process. "
}], "Text",
  CellTags->{"S2.4.4", "4.15"}],

Cell["This gives all sublists that overlap the original list. ", "MathCaption",
  CellTags->{"S2.4.4", "4.16"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d}, 3, 1, {-1, 1}, x]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, x, a}, {x, a, b}, {a, b, c}, {b, c, d}, {c, d, x}, {d, x, 
        x}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["This allows overlaps only at the beginning. ", "MathCaption",
  CellTags->{"S2.4.4", "4.17"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d}, 3, 1, {-1, -1}, x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, x, a}, {x, a, b}, {a, b, c}, {b, c, d}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["-1}]", "MR"],
              " "
            }]], Cell["keep only sublists with no overhangs "]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["1}]", "MR"],
              " "
            }]], Cell["allow an overhang at the end "]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{-1,", "MR"],
              " ",
              StyleBox["-1}]", "MR"],
              " "
            }]], Cell["allow an overhang at the beginning "]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{-1,", "MR"],
              " ",
              StyleBox["1}]", "MR"],
              " "
            }]], Cell["allow overhangs at both the beginning and end "]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["k",
                        "TI"], 
                      StyleBox["L",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["k",
                        "TI"], 
                      StyleBox["R",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["specify alignments of first and last sublists "]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad by cyclically repeating elements in ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad by repeating the element ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad by cyclically repeating the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Partition[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["d", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["spec", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{}]", "MR"],
              " "
            }]], Cell["use no padding "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False}},
  CellTags->"S2.4.4"],

Cell["Specifying alignment and padding. ", "Caption",
  CellTags->"S2.4.4"],

Cell[TextData[{
  "An alignment specification ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["L",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["R",
            "TI"]], TraditionalForm]], "InlineFormula"],
  StyleBox["}", "MR"],
  " tells ",
  StyleBox["Partition", "MR"],
  " to give the sequence of sublists in which the first element of the \
original list appears at position ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["L",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in the first sublist, and the last element of the original list appears \
at position ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["k",
            "TI"], 
          StyleBox["R",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in the last sublist. "
}], "Text",
  CellTags->{"S2.4.4", "4.18"}],

Cell[TextData[{
  "This makes ",
  StyleBox["a", "MR"],
  " appear at position 1 in the first sublist. "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.19"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d}, 3, 1, {1, 1}, x]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, x}, {d, x, x}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "This makes ",
  StyleBox["a", "MR"],
  " appear at position 2 in the first sublist. "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.20"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d}, 3, 1, {2, 1}, x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, a, b}, {a, b, c}, {b, c, d}, {c, d, x}, {d, x, x}}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["a", "MR"],
  " is in effect made to appear first at position 4. "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.21"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d}, 3, 1, {4, 1}, x]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, x, x}, {x, x, a}, {x, a, b}, {a, b, c}, {b, c, d}, {c, d, x}, {d, 
        x, x}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["This fills in padding cyclically from the list given. ", "MathCaption",
  CellTags->{"S2.4.4", "4.22"}],

Cell[CellGroupData[{

Cell["Partition[{a, b, c, d}, 3, 1, {4, 1}, {x, y}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{y, x, y}, {x, y, a}, {y, a, b}, {a, b, c}, {b, c, d}, {c, d, x}, {d, 
        x, y}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["ListConvolve", "MR"],
  " use the same alignment and padding specifications as ",
  StyleBox["Partition", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.4.4", "4.23"}],

Cell[TextData[{
  "In some cases it may be convenient to insert explicit padding into a list. \
You can do this using ",
  StyleBox["PadLeft", "MR"],
  " and ",
  StyleBox["PadRight", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.4.4", "4.24"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad to length ",
              StyleBox["n", "TI"],
              " by inserting zeros on the left "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad by repeating the element ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad by cyclically repeating the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "pad by cyclically repeating ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PadLeft[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["padding", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["m", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "leave a margin of ",
              StyleBox["m", "TI"],
              " elements on the right "
            }]]},
          {Cell[TextData[{
              StyleBox["PadRight[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["pad by inserting zeros on the right "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True}},
  CellTags->"S2.4.4"],

Cell["Padding a list. ", "Caption",
  CellTags->"S2.4.4"],

Cell["This pads the list to make it length 6. ", "MathCaption",
  CellTags->{"S2.4.4", "4.25"}],

Cell[CellGroupData[{

Cell["PadLeft[{a, b, c}, 6]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({0, 0, 0, a, b, c}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "This cyclically inserts ",
  StyleBox["{x,", "MR"],
  " ",
  StyleBox["y}", "MR"],
  " as the padding. "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.26"}],

Cell[CellGroupData[{

Cell["PadLeft[{a, b, c}, 6, {x, y}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({x, y, x, a, b, c}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["This also leaves a margin of 3 on the right. ", "MathCaption",
  CellTags->{"S2.4.4", "4.27"}],

Cell[CellGroupData[{

Cell["PadLeft[{a, b, c}, 10, {x, y}, 3]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({y, x, y, x, a, b, c, x, y, x}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["PadLeft", "MR"],
  ", ",
  StyleBox["PadRight", "MR"],
  " and ",
  StyleBox["Partition", "MR"],
  " can all be used on nested lists. "
}], "Text",
  CellTags->{"S2.4.4", "4.28"}],

Cell[TextData[{
  "This creates a ",
  Cell[BoxData[
      \(TraditionalForm\`3\[Cross]3\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.29"}],

Cell[CellGroupData[{

Cell["PadLeft[{{a, b}, {e}, {f}}, {3, 3}, x]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, a, b}, {x, x, e}, {x, x, f}}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell[TextData[{
  "This partitions the array into ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " blocks with offset 1. "
}], "MathCaption",
  CellTags->{"S2.4.4", "4.30"}],

Cell[CellGroupData[{

Cell["Partition[%, {2, 2}, {1, 1}]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{{{x, a}, {x, x}}, {{a, b}, {x, e}}}, {{{x, x}, {x, x}}, {{x, e}, {x, 
            f}}}}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["\<\
If you give a nested list as a padding specification, its elements \
are picked up cyclically at each level. \
\>", "Text",
  CellTags->{"S2.4.4", "4.31"}],

Cell["This cyclically fills in copies of the padding list. ", "MathCaption",
  CellTags->{"S2.4.4", "4.32"}],

Cell[CellGroupData[{

Cell["PadLeft[{{a, b}, {e}, {f}}, {4, 4}, {{x, y}, {z, w}}]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, y, x, y}, {z, w, a, b}, {x, y, x, e}, {z, w, z, f}}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.4.4"]
}, Open  ]],

Cell["Here is a list containing only padding. ", "MathCaption",
  CellTags->{"S2.4.4", "4.33"}],

Cell[CellGroupData[{

Cell["PadLeft[{{}}, {4, 4}, {{x, y}, {z, w}}]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.4.4"],

Cell[BoxData[
    \({{x, y, x, y}, {z, w, z, w}, {x, y, x, y}, {z, w, z, w}}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.4.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.4.5 Sparse Arrays", "Subsection",
  CellTags->{"S2.4.5", "5.1"}],

Cell[TextData[{
  "Lists are normally specified in ",
  StyleBox["Mathematica", "TI"],
  " just by giving explicit lists of their elements. But particularly in \
working with large arrays, it is often useful instead to be able to say what \
the values of elements are only at certain positions, with all other elements \
taken to have a default value, usually zero. You can do this in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["SparseArray", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S2.4.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              ", \[ThinSpace]",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["e",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }",
              StyleBox[", \[ThinSpace]\[Ellipsis]", "TR"],
              " ",
              " "
            }]], Cell["ordinary lists "]},
          {Cell[TextData[{
              StyleBox["SparseArray[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["sparse arrays "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.4.5"],

Cell["Ordinary lists and sparse arrays. ", "Caption",
  CellTags->"S2.4.5"],

Cell["This specifies a sparse array. ", "MathCaption",
  CellTags->{"S2.4.5", "5.3"}],

Cell[CellGroupData[{

Cell["SparseArray[{2->a, 5->b}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]2\[InvisibleSpace]">"\),
            SequenceForm[ "<", 2, ">"],
            Editable->False], ",", \({5}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here it is as an ordinary list. ", "MathCaption",
  CellTags->{"S2.4.5", "5.4"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({0, a, 0, 0, b}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["\<\
This specifies a two\[Hyphen]dimensional sparse array. \
\>", \
"MathCaption",
  CellTags->{"S2.4.5", "5.5"}],

Cell[CellGroupData[{

Cell["SparseArray[{{1,2}->a, {3,2}->b, {3,3}->c}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]3\[InvisibleSpace]">"\),
            SequenceForm[ "<", 3, ">"],
            Editable->False], ",", \({3, 3}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here it is an ordinary list of lists. ", "MathCaption",
  CellTags->{"S2.4.5", "5.6"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{0, a, 0}, {0, 0, 0}, {0, b, c}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SparseArray[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sparse array version of ",
              StyleBox["list", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SparseArray[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["->", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["->", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "sparse array with values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at positions ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SparseArray[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}->{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["val",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["the same sparse array "]},
          {Cell[TextData[{
              StyleBox["SparseArray[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["d",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    RowBox[{
                      SubscriptBox[
                        StyleBox["d",
                          "TI"], "1"], "\[Cross]", 
                      SubscriptBox[
                        StyleBox["d",
                          "TI"], "2"], "\[Cross]", "..."}], TraditionalForm]],
                 "InlineFormula"],
              " sparse array "
            }]]},
          {Cell[TextData[{
              StyleBox["SparseArray[", "MR"],
              StyleBox["data", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["dims", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["val", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sparse array with default value ",
              StyleBox["val", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Normal[", "MR"],
              StyleBox["array", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "ordinary list version of ",
              StyleBox["array", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ArrayRules[", "MR"],
              StyleBox["array", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "position\[Hyphen]value rules for ",
              StyleBox["array", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, False, False, True, False}},
  CellTags->"S2.4.5"],

Cell["Creating and converting sparse arrays. ", "Caption",
  CellTags->"S2.4.5"],

Cell["This generates a sparse array version of a list. ", "MathCaption",
  CellTags->{"S2.4.5", "5.7"}],

Cell[CellGroupData[{

Cell["SparseArray[{a, b, c, d}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]4\[InvisibleSpace]">"\),
            SequenceForm[ "<", 4, ">"],
            Editable->False], ",", \({4}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["This converts back to an ordinary list. ", "MathCaption",
  CellTags->{"S2.4.5", "5.8"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({a, b, c, d}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "This makes a length 7 sparse array with default value ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.9"}],

Cell[CellGroupData[{

Cell["SparseArray[{3->a, 5->b}, 7, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]2\[InvisibleSpace]">"\),
            SequenceForm[ "<", 2, ">"],
            Editable->False], ",", \({7}\), ",", "x"}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here is the corresponding ordinary list. ", "MathCaption",
  CellTags->{"S2.4.5", "5.10"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({x, x, a, x, b, x, x}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["This shows the rules used in the sparse array. ", "MathCaption",
  CellTags->{"S2.4.5", "5.11"}],

Cell[CellGroupData[{

Cell["ArrayRules[%%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{3} \[Rule] a, {5} \[Rule] b, {_} \[Rule] x}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "An important feature of ",
  StyleBox["SparseArray", "MR"],
  " is that the positions you specify can be patterns. "
}], "Text",
  CellTags->{"S2.4.5", "5.12"}],

Cell[TextData[{
  "This specifies a ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Cross]4\)], "InlineFormula"],
  " sparse array with ",
  StyleBox["1", "MR"],
  " at every position matching ",
  StyleBox["{i_,", "MR"],
  " ",
  StyleBox["i_}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.13"}],

Cell[CellGroupData[{

Cell["SparseArray[{i_, i_} -> 1, {4, 4}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]4\[InvisibleSpace]">"\),
            SequenceForm[ "<", 4, ">"],
            Editable->False], ",", \({4, 4}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "The result is a ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Cross]4\)], "InlineFormula"],
  " identity matrix. "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.14"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here is an identity matrix with an extra element. ", "MathCaption",
  CellTags->{"S2.4.5", "5.15"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{{1, 3}->a, {i_, i_}->1}, {4, 4}]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{1, 0, a, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "This makes the whole third column be\[NonBreakingSpace]",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.16"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{{_, 3}->a, {i_, i_}->1}, {4, 4}]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{1, 0, a, 0}, {0, 1, a, 0}, {0, 0, a, 0}, {0, 0, a, 1}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "You can think of ",
  StyleBox["SparseArray[", "MR"],
  StyleBox["rules", "TI"],
  StyleBox["]", "MR"],
  " as taking all possible position specifications, then applying ",
  StyleBox["rules", "TI"],
  " to determine values in each case. As usual, rules given earlier in the \
list will be tried first. "
}], "Text",
  CellTags->{"S2.4.5", "5.17"}],

Cell["This generates a random diagonal matrix. ", "MathCaption",
  CellTags->{"S2.4.5", "5.18"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{{i_, i_} :> Random[]}, {3, 3}]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{0.056070794834861534`, 0, 0}, {0, 0.630299795779359`, 0}, {0, 0, 
        0.3598942942214413`}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["You can have rules where values depend on indices. ", "MathCaption",
  CellTags->{"S2.4.5", "5.19"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[i_ -> i^2, 10]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "This fills in even\[Hyphen]numbered positions with ",
  StyleBox["p", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.20"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{_?EvenQ->p, i_->i^2}, 10]]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({1, p, 9, p, 25, p, 49, p, 81, p}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["You can use patterns involving alternatives. ", "MathCaption",
  CellTags->{"S2.4.5", "5.21"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[{1|3, 2|4}->a, {4, 4}]]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{0, a, 0, a}, {0, 0, 0, 0}, {0, a, 0, a}, {0, 0, 0, 0}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["You can also give conditions on patterns. ", "MathCaption",
  CellTags->{"S2.4.5", "5.22"}],

Cell[CellGroupData[{

Cell["Normal[SparseArray[i_/;3<i<7 -> p, 10]]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({0, 0, 0, p, p, p, 0, 0, 0, 0}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["\<\
This makes a band\[Hyphen]diagonal matrix. \
\>", "MathCaption",
  CellTags->{"S2.4.5", "5.23"}],

Cell[CellGroupData[{

Cell["\<\
Normal[SparseArray[{{i_, j_} /; Abs[i - j] < 2 -> i + j}, {5, \
5}]]\
\>", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({{2, 3, 0, 0, 0}, {3, 4, 5, 0, 0}, {0, 5, 6, 7, 0}, {0, 0, 7, 8, 
        9}, {0, 0, 0, 9, 10}}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "For many purposes, ",
  StyleBox["Mathematica", "TI"],
  " treats ",
  StyleBox["SparseArray", "MR"],
  " objects just like the ordinary lists to which they correspond. Thus, for \
example, if you ask for parts of a sparse array object, ",
  StyleBox["Mathematica", "TI"],
  " will operate as if you had asked for parts in the corresponding ordinary \
list. "
}], "Text",
  CellTags->{"S2.4.5", "5.24"}],

Cell["This generates a sparse array object. ", "MathCaption",
  CellTags->{"S2.4.5", "5.25"}],

Cell[CellGroupData[{

Cell["s = SparseArray[{2->a, 4->b, 5->c}, 10]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]3\[InvisibleSpace]">"\),
            SequenceForm[ "<", 3, ">"],
            Editable->False], ",", \({10}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here is the corresponding ordinary list. ", "MathCaption",
  CellTags->{"S2.4.5", "5.26"}],

Cell[CellGroupData[{

Cell["Normal[s]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({0, a, 0, b, c, 0, 0, 0, 0, 0}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["\<\
Parts of the sparse array are just like parts of the corresponding \
ordinary list. \
\>", "MathCaption",
  CellTags->{"S2.4.5", "5.27"}],

Cell[CellGroupData[{

Cell["s[[2]]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \(a\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["This part has the default value 0. ", "MathCaption",
  CellTags->{"S2.4.5", "5.28"}],

Cell[CellGroupData[{

Cell["s[[3]]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  "Many operations treat ",
  StyleBox["SparseArray", "MR"],
  " objects just like ordinary lists. When possible, they give sparse arrays \
as results. "
}], "Text",
  CellTags->{"S2.4.5", "5.29"}],

Cell["This gives a sparse array. ", "MathCaption",
  CellTags->{"S2.4.5", "5.30"}],

Cell[CellGroupData[{

Cell["3 s + x", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]3\[InvisibleSpace]">"\),
            SequenceForm[ "<", 3, ">"],
            Editable->False], ",", \({10}\), ",", "x"}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here is the corresponding ordinary list. ", "MathCaption",
  CellTags->{"S2.4.5", "5.31"}],

Cell[CellGroupData[{

Cell["Normal[%]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({x, 3\ a + x, x, 3\ b + x, 3\ c + x, x, x, x, x, x}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dot", "MR"],
  " works directly with sparse array objects. "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.32"}],

Cell[CellGroupData[{

Cell["s . s", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \(a\^2 + b\^2 + c\^2\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["You can mix sparse arrays and ordinary lists. ", "MathCaption",
  CellTags->{"S2.4.5", "5.33"}],

Cell[CellGroupData[{

Cell["s . Range[10]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \(2\ a + 4\ b + 5\ c\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " represents sparse arrays as expressions with head ",
  StyleBox["SparseArray", "MR"],
  ". Whenever a sparse array is evaluated, it is automatically converted to \
an optimized standard form with structure ",
  StyleBox["SparseArray[Automatic,", "MR"],
  " ",
  StyleBox["dims", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["val", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.4.5", "5.34"}],

Cell[TextData[{
  "This structure is, however, rarely evident, since even operations like ",
  StyleBox["Length", "MR"],
  " are set up to give results for the corresponding ordinary list, not for \
the raw ",
  StyleBox["SparseArray", "MR"],
  " expression structure. "
}], "Text",
  CellTags->{"S2.4.5", "5.35"}],

Cell["This generates a sparse array. ", "MathCaption",
  CellTags->{"S2.4.5", "5.36"}],

Cell[CellGroupData[{

Cell["t = SparseArray[{1->a, 5->b}, 10]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    TagBox[
      RowBox[{"SparseArray", "[", 
        RowBox[{
          InterpretationBox[\("<"\[InvisibleSpace]2\[InvisibleSpace]">"\),
            SequenceForm[ "<", 2, ">"],
            Editable->False], ",", \({10}\)}], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell["Here is the underlying optimized expression structure. ", "MathCaption",
  CellTags->{"S2.4.5", "5.37"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.4.5"],

Cell["\<\
SparseArray[Automatic, {10}, 0,   {1, {{0, 2}, {{1}, {5}}}, {a, \
b}}]\
\>", "Output",
  CellLabel->"Out[29]//InputForm= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Length", "MR"],
  " gives the length of the corresponding ordinary list. "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.38"}],

Cell[CellGroupData[{

Cell["Length[t]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S2.4.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Map", "MR"],
  " also operates on individual values. "
}], "MathCaption",
  CellTags->{"S2.4.5", "5.39"}],

Cell[CellGroupData[{

Cell["Normal[Map[f, t]]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.4.5"],

Cell[BoxData[
    \({f[a], f[0], f[0], f[0], f[b], f[0], f[0], f[0], f[0], 
      f[0]}\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S2.4.5"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 94}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.4.0"->{
    Cell[1776, 53, 121, 4, 65, "Section",
      CellTags->{"S2.4.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 121, 4, 65, "Section",
      CellTags->{"S2.4.0", "0.1"}]},
  "S2.4.1"->{
    Cell[1922, 61, 77, 1, 70, "Subsection",
      CellTags->{"S2.4.1", "1.1"}],
    Cell[2002, 64, 174, 5, 70, "Text",
      CellTags->{"S2.4.1", "1.2"}],
    Cell[2179, 71, 6084, 191, 70, "DefinitionBox",
      CellTags->"S2.4.1"],
    Cell[8266, 264, 80, 1, 70, "Caption",
      CellTags->"S2.4.1"],
    Cell[8349, 267, 106, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.3"}],
    Cell[8480, 272, 82, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[8565, 276, 98, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[8678, 282, 98, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.4"}],
    Cell[8801, 287, 79, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[8883, 291, 98, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[8996, 297, 81, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.5"}],
    Cell[9102, 302, 84, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[9189, 306, 101, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[9305, 312, 153, 4, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.6"}],
    Cell[9483, 320, 100, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[9586, 324, 96, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[9697, 330, 99, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.7"}],
    Cell[9821, 335, 99, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[9923, 339, 98, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[10036, 345, 220, 5, 70, "Text",
      CellTags->{"S2.4.1", "1.8"}],
    Cell[10259, 352, 4763, 147, 70, "DefinitionBox",
      CellTags->"S2.4.1"],
    Cell[15025, 501, 78, 1, 70, "Caption",
      CellTags->"S2.4.1"],
    Cell[15106, 504, 91, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.9"}],
    Cell[15222, 509, 96, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[15321, 513, 91, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[15427, 519, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.10"}],
    Cell[15545, 524, 89, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[15637, 528, 90, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[15742, 534, 160, 5, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.11"}],
    Cell[15927, 543, 99, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[16029, 547, 90, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[16134, 553, 248, 8, 70, "Text",
      CellTags->{"S2.4.1", "1.12"}],
    Cell[16385, 563, 968, 30, 70, "DefinitionBox",
      CellTags->"S2.4.1"],
    Cell[17356, 595, 133, 7, 70, "Caption",
      CellTags->"S2.4.1"],
    Cell[17492, 604, 98, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.13"}],
    Cell[17615, 609, 80, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[17698, 613, 101, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[17814, 619, 157, 4, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.14"}],
    Cell[17996, 627, 112, 2, 70, "Input",
      CellTags->"S2.4.1"],
    Cell[18111, 631, 127, 3, 70, "Output",
      CellTags->"S2.4.1"],
    Cell[18253, 637, 427, 17, 70, "Text",
      CellTags->{"S2.4.1", "1.15"}]},
  "1.1"->{
    Cell[1922, 61, 77, 1, 70, "Subsection",
      CellTags->{"S2.4.1", "1.1"}]},
  "1.2"->{
    Cell[2002, 64, 174, 5, 70, "Text",
      CellTags->{"S2.4.1", "1.2"}]},
  "1.3"->{
    Cell[8349, 267, 106, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.3"}]},
  "1.4"->{
    Cell[8678, 282, 98, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.4"}]},
  "1.5"->{
    Cell[8996, 297, 81, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.5"}]},
  "1.6"->{
    Cell[9305, 312, 153, 4, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.6"}]},
  "1.7"->{
    Cell[9697, 330, 99, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.7"}]},
  "1.8"->{
    Cell[10036, 345, 220, 5, 70, "Text",
      CellTags->{"S2.4.1", "1.8"}]},
  "1.9"->{
    Cell[15106, 504, 91, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.9"}]},
  "1.10"->{
    Cell[15427, 519, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.10"}]},
  "1.11"->{
    Cell[15742, 534, 160, 5, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.11"}]},
  "1.12"->{
    Cell[16134, 553, 248, 8, 70, "Text",
      CellTags->{"S2.4.1", "1.12"}]},
  "1.13"->{
    Cell[17492, 604, 98, 1, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.13"}]},
  "1.14"->{
    Cell[17814, 619, 157, 4, 70, "MathCaption",
      CellTags->{"S2.4.1", "1.14"}]},
  "1.15"->{
    Cell[18253, 637, 427, 17, 70, "Text",
      CellTags->{"S2.4.1", "1.15"}]},
  "S2.4.2"->{
    Cell[18717, 659, 94, 1, 70, "Subsection",
      CellTags->{"S2.4.2", "2.1"}],
    Cell[18814, 662, 3736, 110, 70, "DefinitionBox",
      CellTags->"S2.4.2"],
    Cell[22553, 774, 65, 1, 70, "Caption",
      CellTags->"S2.4.2"],
    Cell[22621, 777, 90, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.2"}],
    Cell[22736, 782, 86, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[22825, 786, 87, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[22927, 792, 77, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.3"}],
    Cell[23007, 795, 99, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[23109, 799, 102, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.4"}],
    Cell[23236, 804, 75, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[23314, 808, 103, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[23432, 814, 108, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.5"}],
    Cell[23565, 819, 78, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[23646, 823, 87, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[23748, 829, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.6"}],
    Cell[23873, 834, 83, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[23959, 838, 97, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[24071, 844, 98, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.7"}],
    Cell[24194, 849, 75, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[24272, 853, 90, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[24377, 859, 319, 15, 70, "Text",
      CellTags->{"S2.4.2", "2.8"}],
    Cell[24699, 876, 125, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.9"}],
    Cell[24849, 885, 77, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[24929, 889, 82, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[25026, 895, 126, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.10"}],
    Cell[25177, 904, 65, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[25245, 908, 111, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[25371, 914, 168, 7, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.11"}],
    Cell[25564, 925, 87, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[25654, 929, 95, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[25764, 935, 136, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.12"}],
    Cell[25925, 944, 83, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[26011, 948, 96, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[26122, 954, 137, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.13"}],
    Cell[26262, 961, 100, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[26365, 965, 243, 11, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.14"}],
    Cell[26633, 980, 91, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[26727, 984, 112, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[26854, 990, 159, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.15"}],
    Cell[27038, 999, 91, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[27132, 1003, 112, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[27259, 1009, 1744, 60, 70, "Text",
      CellTags->{"S2.4.2", "2.16"}],
    Cell[29006, 1071, 132, 4, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.17"}],
    Cell[29163, 1079, 117, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[29283, 1083, 379, 13, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[29677, 1099, 106, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.18"}],
    Cell[29808, 1104, 97, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[29908, 1108, 342, 12, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[30265, 1123, 328, 8, 70, "Text",
      CellTags->{"S2.4.2", "2.19"}],
    Cell[30596, 1133, 7240, 213, 70, "DefinitionBox",
      CellTags->"S2.4.2"],
    Cell[37839, 1348, 90, 1, 70, "Caption",
      CellTags->"S2.4.2"],
    Cell[37932, 1351, 103, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.20"}],
    Cell[38060, 1356, 93, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[38156, 1360, 88, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[38259, 1366, 261, 8, 70, "Text",
      CellTags->{"S2.4.2", "2.21"}],
    Cell[38523, 1376, 83, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.22"}],
    Cell[38609, 1379, 114, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[38726, 1383, 136, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.23"}],
    Cell[38887, 1392, 82, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[38972, 1396, 109, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[39096, 1402, 102, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.24"}],
    Cell[39223, 1407, 78, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[39304, 1411, 100, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[39419, 1417, 4500, 141, 70, "DefinitionBox",
      CellTags->"S2.4.2"],
    Cell[43922, 1560, 93, 1, 70, "Caption",
      CellTags->"S2.4.2"],
    Cell[44018, 1563, 111, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.25"}],
    Cell[44154, 1568, 104, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[44261, 1572, 91, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[44367, 1578, 88, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.26"}],
    Cell[44480, 1583, 104, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[44587, 1587, 94, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[44696, 1593, 393, 14, 70, "Text",
      CellTags->{"S2.4.2", "2.27"}],
    Cell[45092, 1609, 169, 6, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.28"}],
    Cell[45286, 1619, 117, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[45406, 1623, 379, 13, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[45800, 1639, 180, 6, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.29"}],
    Cell[46005, 1649, 91, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[46099, 1653, 342, 12, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[46456, 1668, 105, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.30"}],
    Cell[46586, 1673, 93, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[46682, 1677, 364, 13, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[47061, 1693, 107, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.31"}],
    Cell[47193, 1698, 94, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[47290, 1702, 349, 13, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[47654, 1718, 3595, 120, 70, "DefinitionBox",
      CellTags->"S2.4.2"],
    Cell[51252, 1840, 80, 1, 70, "Caption",
      CellTags->"S2.4.2"],
    Cell[51335, 1843, 144, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.32"}],
    Cell[51504, 1852, 103, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[51610, 1856, 104, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[51729, 1862, 87, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.33"}],
    Cell[51841, 1867, 82, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[51926, 1871, 101, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[52042, 1877, 6082, 187, 70, "DefinitionBox",
      CellTags->"S2.4.2"],
    Cell[58127, 2066, 67, 1, 70, "Caption",
      CellTags->"S2.4.2"],
    Cell[58197, 2069, 151, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.34"}],
    Cell[58373, 2078, 96, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[58472, 2082, 94, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[58581, 2088, 195, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.35"}],
    Cell[58801, 2097, 105, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[58909, 2101, 94, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[59018, 2107, 179, 6, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.36"}],
    Cell[59222, 2117, 82, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[59307, 2121, 115, 3, 70, "Output",
      CellTags->"S2.4.2"],
    Cell[59437, 2127, 151, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.37"}],
    Cell[59613, 2136, 90, 2, 70, "Input",
      CellTags->"S2.4.2"],
    Cell[59706, 2140, 115, 3, 70, "Output",
      CellTags->"S2.4.2"]},
  "2.1"->{
    Cell[18717, 659, 94, 1, 70, "Subsection",
      CellTags->{"S2.4.2", "2.1"}]},
  "2.2"->{
    Cell[22621, 777, 90, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.2"}]},
  "2.3"->{
    Cell[22927, 792, 77, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.3"}]},
  "2.4"->{
    Cell[23109, 799, 102, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.4"}]},
  "2.5"->{
    Cell[23432, 814, 108, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.5"}]},
  "2.6"->{
    Cell[23748, 829, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.6"}]},
  "2.7"->{
    Cell[24071, 844, 98, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.7"}]},
  "2.8"->{
    Cell[24377, 859, 319, 15, 70, "Text",
      CellTags->{"S2.4.2", "2.8"}]},
  "2.9"->{
    Cell[24699, 876, 125, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.9"}]},
  "2.10"->{
    Cell[25026, 895, 126, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.10"}]},
  "2.11"->{
    Cell[25371, 914, 168, 7, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.11"}]},
  "2.12"->{
    Cell[25764, 935, 136, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.12"}]},
  "2.13"->{
    Cell[26122, 954, 137, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.13"}]},
  "2.14"->{
    Cell[26365, 965, 243, 11, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.14"}]},
  "2.15"->{
    Cell[26854, 990, 159, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.15"}]},
  "2.16"->{
    Cell[27259, 1009, 1744, 60, 70, "Text",
      CellTags->{"S2.4.2", "2.16"}]},
  "2.17"->{
    Cell[29006, 1071, 132, 4, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.17"}]},
  "2.18"->{
    Cell[29677, 1099, 106, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.18"}]},
  "2.19"->{
    Cell[30265, 1123, 328, 8, 70, "Text",
      CellTags->{"S2.4.2", "2.19"}]},
  "2.20"->{
    Cell[37932, 1351, 103, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.20"}]},
  "2.21"->{
    Cell[38259, 1366, 261, 8, 70, "Text",
      CellTags->{"S2.4.2", "2.21"}]},
  "2.22"->{
    Cell[38523, 1376, 83, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.22"}]},
  "2.23"->{
    Cell[38726, 1383, 136, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.23"}]},
  "2.24"->{
    Cell[39096, 1402, 102, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.24"}]},
  "2.25"->{
    Cell[44018, 1563, 111, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.25"}]},
  "2.26"->{
    Cell[44367, 1578, 88, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.26"}]},
  "2.27"->{
    Cell[44696, 1593, 393, 14, 70, "Text",
      CellTags->{"S2.4.2", "2.27"}]},
  "2.28"->{
    Cell[45092, 1609, 169, 6, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.28"}]},
  "2.29"->{
    Cell[45800, 1639, 180, 6, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.29"}]},
  "2.30"->{
    Cell[46456, 1668, 105, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.30"}]},
  "2.31"->{
    Cell[47061, 1693, 107, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.31"}]},
  "2.32"->{
    Cell[51335, 1843, 144, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.32"}]},
  "2.33"->{
    Cell[51729, 1862, 87, 1, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.33"}]},
  "2.34"->{
    Cell[58197, 2069, 151, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.34"}]},
  "2.35"->{
    Cell[58581, 2088, 195, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.35"}]},
  "2.36"->{
    Cell[59018, 2107, 179, 6, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.36"}]},
  "2.37"->{
    Cell[59437, 2127, 151, 5, 70, "MathCaption",
      CellTags->{"S2.4.2", "2.37"}]},
  "S2.4.3"->{
    Cell[59870, 2149, 71, 1, 70, "Subsection",
      CellTags->{"S2.4.3", "3.1"}],
    Cell[59944, 2152, 7997, 238, 70, "DefinitionBox",
      CellTags->"S2.4.3"],
    Cell[67944, 2392, 73, 1, 70, "Caption",
      CellTags->"S2.4.3"],
    Cell[68020, 2395, 206, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.2"}],
    Cell[68251, 2405, 94, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[68348, 2409, 136, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[68499, 2415, 127, 4, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.3"}],
    Cell[68651, 2423, 90, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[68744, 2427, 136, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[68895, 2433, 171, 5, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.4"}],
    Cell[69091, 2442, 110, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[69204, 2446, 107, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[69326, 2452, 138, 4, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.5"}],
    Cell[69489, 2460, 88, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[69580, 2464, 121, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[69716, 2470, 313, 11, 70, "Text",
      CellTags->{"S2.4.3", "3.6"}],
    Cell[70032, 2483, 955, 29, 70, "DefinitionBox",
      CellTags->"S2.4.3"],
    Cell[70990, 2514, 68, 1, 70, "Caption",
      CellTags->"S2.4.3"],
    Cell[71061, 2517, 267, 7, 70, "Text",
      CellTags->{"S2.4.3", "3.7"}],
    Cell[71331, 2526, 89, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.8"}],
    Cell[71445, 2531, 94, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[71542, 2535, 153, 4, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[71710, 2542, 913, 29, 70, "DefinitionBox",
      CellTags->"S2.4.3"],
    Cell[72626, 2573, 66, 1, 70, "Caption",
      CellTags->"S2.4.3"],
    Cell[72695, 2576, 175, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.9"}],
    Cell[72895, 2586, 80, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[72978, 2590, 141, 4, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[73134, 2597, 166, 4, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.10"}],
    Cell[73325, 2605, 74, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[73402, 2609, 135, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[73552, 2615, 1914, 57, 70, "DefinitionBox",
      CellTags->"S2.4.3"],
    Cell[75469, 2674, 77, 1, 70, "Caption",
      CellTags->"S2.4.3"],
    Cell[75549, 2677, 185, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.11"}],
    Cell[75759, 2687, 83, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[75845, 2691, 200, 4, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[76060, 2698, 114, 2, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.12"}],
    Cell[76199, 2704, 87, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[76289, 2708, 200, 4, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[76504, 2715, 89, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.13"}],
    Cell[76618, 2720, 88, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[76709, 2724, 201, 4, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[76925, 2731, 1953, 63, 70, "DefinitionBox",
      CellTags->"S2.4.3"],
    Cell[78881, 2796, 77, 1, 70, "Caption",
      CellTags->"S2.4.3"],
    Cell[78961, 2799, 78, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.14"}],
    Cell[79042, 2802, 111, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[79156, 2806, 134, 5, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.15"}],
    Cell[79315, 2815, 79, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[79397, 2819, 138, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[79550, 2825, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.16"}],
    Cell[79668, 2830, 81, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[79752, 2834, 128, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[79895, 2840, 147, 5, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.17"}],
    Cell[80067, 2849, 86, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[80156, 2853, 187, 4, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[80358, 2860, 6691, 194, 70, "DefinitionBox",
      CellTags->"S2.4.3"],
    Cell[87052, 3056, 69, 1, 70, "Caption",
      CellTags->"S2.4.3"],
    Cell[87124, 3059, 78, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.18"}],
    Cell[87205, 3062, 111, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[87319, 3066, 101, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.19"}],
    Cell[87445, 3071, 90, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[87538, 3075, 123, 3, 70, "Output",
      CellTags->"S2.4.3"],
    Cell[87676, 3081, 199, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.20"}],
    Cell[87900, 3091, 87, 2, 70, "Input",
      CellTags->"S2.4.3"],
    Cell[87990, 3095, 163, 4, 70, "Output",
      CellTags->"S2.4.3"]},
  "3.1"->{
    Cell[59870, 2149, 71, 1, 70, "Subsection",
      CellTags->{"S2.4.3", "3.1"}]},
  "3.2"->{
    Cell[68020, 2395, 206, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.2"}]},
  "3.3"->{
    Cell[68499, 2415, 127, 4, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.3"}]},
  "3.4"->{
    Cell[68895, 2433, 171, 5, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.4"}]},
  "3.5"->{
    Cell[69326, 2452, 138, 4, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.5"}]},
  "3.6"->{
    Cell[69716, 2470, 313, 11, 70, "Text",
      CellTags->{"S2.4.3", "3.6"}]},
  "3.7"->{
    Cell[71061, 2517, 267, 7, 70, "Text",
      CellTags->{"S2.4.3", "3.7"}]},
  "3.8"->{
    Cell[71331, 2526, 89, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.8"}]},
  "3.9"->{
    Cell[72695, 2576, 175, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.9"}]},
  "3.10"->{
    Cell[73134, 2597, 166, 4, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.10"}]},
  "3.11"->{
    Cell[75549, 2677, 185, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.11"}]},
  "3.12"->{
    Cell[76060, 2698, 114, 2, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.12"}]},
  "3.13"->{
    Cell[76504, 2715, 89, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.13"}]},
  "3.14"->{
    Cell[78961, 2799, 78, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.14"}]},
  "3.15"->{
    Cell[79156, 2806, 134, 5, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.15"}]},
  "3.16"->{
    Cell[79550, 2825, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.16"}]},
  "3.17"->{
    Cell[79895, 2840, 147, 5, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.17"}]},
  "3.18"->{
    Cell[87124, 3059, 78, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.18"}]},
  "3.19"->{
    Cell[87319, 3066, 101, 1, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.19"}]},
  "3.20"->{
    Cell[87676, 3081, 199, 6, 70, "MathCaption",
      CellTags->{"S2.4.3", "3.20"}]},
  "S2.4.4"->{
    Cell[88202, 3105, 89, 1, 70, "Subsection",
      CellTags->{"S2.4.4", "4.1"}],
    Cell[88294, 3108, 1927, 60, 70, "DefinitionBox",
      CellTags->"S2.4.4"],
    Cell[90224, 3170, 74, 1, 70, "Caption",
      CellTags->"S2.4.4"],
    Cell[90301, 3173, 86, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.2"}],
    Cell[90412, 3178, 96, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[90511, 3182, 103, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[90629, 3188, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.3"}],
    Cell[90754, 3193, 99, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[90856, 3197, 125, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[90996, 3203, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.4"}],
    Cell[91121, 3208, 99, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[91223, 3212, 97, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[91335, 3218, 99, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.5"}],
    Cell[91459, 3223, 98, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[91560, 3227, 118, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[91693, 3233, 115, 2, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.6"}],
    Cell[91833, 3239, 107, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[91943, 3243, 118, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[92076, 3249, 304, 6, 70, "Text",
      CellTags->{"S2.4.4", "4.7"}],
    Cell[92383, 3257, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.8"}],
    Cell[92501, 3262, 93, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[92597, 3266, 97, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[92709, 3272, 77, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.9"}],
    Cell[92811, 3277, 96, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[92910, 3281, 114, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[93039, 3287, 340, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.10"}],
    Cell[93382, 3297, 138, 4, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.11"}],
    Cell[93545, 3305, 104, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[93652, 3309, 136, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[93803, 3315, 168, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.12"}],
    Cell[93996, 3324, 107, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[94106, 3328, 136, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[94257, 3334, 171, 7, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.13"}],
    Cell[94453, 3345, 113, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[94569, 3349, 137, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[94721, 3355, 133, 4, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.14"}],
    Cell[94879, 3363, 109, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[94991, 3367, 128, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[95134, 3373, 310, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.15"}],
    Cell[95447, 3383, 111, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.16"}],
    Cell[95583, 3388, 106, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[95692, 3392, 157, 4, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[95864, 3399, 99, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.17"}],
    Cell[95988, 3404, 107, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[96098, 3408, 126, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[96239, 3414, 6991, 213, 70, "DefinitionBox",
      CellTags->"S2.4.4"],
    Cell[103233, 3629, 75, 1, 70, "Caption",
      CellTags->"S2.4.4"],
    Cell[103311, 3632, 1154, 42, 70, "Text",
      CellTags->{"S2.4.4", "4.18"}],
    Cell[104468, 3676, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.19"}],
    Cell[104648, 3685, 105, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[104756, 3689, 126, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[104897, 3695, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.20"}],
    Cell[105077, 3704, 105, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[105185, 3708, 137, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[105337, 3714, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.21"}],
    Cell[105517, 3723, 105, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[105625, 3727, 168, 4, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[105808, 3734, 109, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.22"}],
    Cell[105942, 3739, 110, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[106055, 3743, 168, 4, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[106238, 3750, 212, 7, 70, "Text",
      CellTags->{"S2.4.4", "4.23"}],
    Cell[106453, 3759, 241, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.24"}],
    Cell[106697, 3769, 3815, 117, 70, "DefinitionBox",
      CellTags->"S2.4.4"],
    Cell[110515, 3888, 57, 1, 70, "Caption",
      CellTags->"S2.4.4"],
    Cell[110575, 3891, 95, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.25"}],
    Cell[110695, 3896, 86, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[110784, 3900, 100, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[110899, 3906, 174, 7, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.26"}],
    Cell[111098, 3917, 94, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[111195, 3921, 100, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[111310, 3927, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.27"}],
    Cell[111435, 3932, 98, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[111536, 3936, 112, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[111663, 3942, 207, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.28"}],
    Cell[111873, 3952, 174, 6, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.29"}],
    Cell[112072, 3962, 103, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[112178, 3966, 115, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[112308, 3972, 205, 6, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.30"}],
    Cell[112538, 3982, 93, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[112634, 3986, 171, 4, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[112820, 3993, 165, 4, 70, "Text",
      CellTags->{"S2.4.4", "4.31"}],
    Cell[112988, 3999, 108, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.32"}],
    Cell[113121, 4004, 118, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[113242, 4008, 138, 3, 70, "Output",
      CellTags->"S2.4.4"],
    Cell[113395, 4014, 95, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.33"}],
    Cell[113515, 4019, 104, 2, 70, "Input",
      CellTags->"S2.4.4"],
    Cell[113622, 4023, 138, 3, 70, "Output",
      CellTags->"S2.4.4"]},
  "4.1"->{
    Cell[88202, 3105, 89, 1, 70, "Subsection",
      CellTags->{"S2.4.4", "4.1"}]},
  "4.2"->{
    Cell[90301, 3173, 86, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.2"}]},
  "4.3"->{
    Cell[90629, 3188, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.3"}]},
  "4.4"->{
    Cell[90996, 3203, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.4"}]},
  "4.5"->{
    Cell[91335, 3218, 99, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.5"}]},
  "4.6"->{
    Cell[91693, 3233, 115, 2, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.6"}]},
  "4.7"->{
    Cell[92076, 3249, 304, 6, 70, "Text",
      CellTags->{"S2.4.4", "4.7"}]},
  "4.8"->{
    Cell[92383, 3257, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.8"}]},
  "4.9"->{
    Cell[92709, 3272, 77, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.9"}]},
  "4.10"->{
    Cell[93039, 3287, 340, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.10"}]},
  "4.11"->{
    Cell[93382, 3297, 138, 4, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.11"}]},
  "4.12"->{
    Cell[93803, 3315, 168, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.12"}]},
  "4.13"->{
    Cell[94257, 3334, 171, 7, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.13"}]},
  "4.14"->{
    Cell[94721, 3355, 133, 4, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.14"}]},
  "4.15"->{
    Cell[95134, 3373, 310, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.15"}]},
  "4.16"->{
    Cell[95447, 3383, 111, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.16"}]},
  "4.17"->{
    Cell[95864, 3399, 99, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.17"}]},
  "4.18"->{
    Cell[103311, 3632, 1154, 42, 70, "Text",
      CellTags->{"S2.4.4", "4.18"}]},
  "4.19"->{
    Cell[104468, 3676, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.19"}]},
  "4.20"->{
    Cell[104897, 3695, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.20"}]},
  "4.21"->{
    Cell[105337, 3714, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.21"}]},
  "4.22"->{
    Cell[105808, 3734, 109, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.22"}]},
  "4.23"->{
    Cell[106238, 3750, 212, 7, 70, "Text",
      CellTags->{"S2.4.4", "4.23"}]},
  "4.24"->{
    Cell[106453, 3759, 241, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.24"}]},
  "4.25"->{
    Cell[110575, 3891, 95, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.25"}]},
  "4.26"->{
    Cell[110899, 3906, 174, 7, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.26"}]},
  "4.27"->{
    Cell[111310, 3927, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.27"}]},
  "4.28"->{
    Cell[111663, 3942, 207, 8, 70, "Text",
      CellTags->{"S2.4.4", "4.28"}]},
  "4.29"->{
    Cell[111873, 3952, 174, 6, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.29"}]},
  "4.30"->{
    Cell[112308, 3972, 205, 6, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.30"}]},
  "4.31"->{
    Cell[112820, 3993, 165, 4, 70, "Text",
      CellTags->{"S2.4.4", "4.31"}]},
  "4.32"->{
    Cell[112988, 3999, 108, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.32"}]},
  "4.33"->{
    Cell[113395, 4014, 95, 1, 70, "MathCaption",
      CellTags->{"S2.4.4", "4.33"}]},
  "S2.4.5"->{
    Cell[113809, 4032, 72, 1, 70, "Subsection",
      CellTags->{"S2.4.5", "5.1"}],
    Cell[113884, 4035, 524, 12, 70, "Text",
      CellTags->{"S2.4.5", "5.2"}],
    Cell[114411, 4049, 2808, 80, 70, "DefinitionBox",
      CellTags->"S2.4.5"],
    Cell[117222, 4131, 75, 1, 70, "Caption",
      CellTags->"S2.4.5"],
    Cell[117300, 4134, 85, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.3"}],
    Cell[117410, 4139, 89, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[117502, 4143, 340, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[117857, 4156, 86, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.4"}],
    Cell[117968, 4161, 73, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[118044, 4165, 96, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[118155, 4171, 119, 4, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.5"}],
    Cell[118299, 4179, 107, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[118409, 4183, 343, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[118767, 4196, 92, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.6"}],
    Cell[118884, 4201, 73, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[118960, 4205, 114, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[119089, 4211, 6020, 173, 70, "DefinitionBox",
      CellTags->"S2.4.5"],
    Cell[125112, 4386, 80, 1, 70, "Caption",
      CellTags->"S2.4.5"],
    Cell[125195, 4389, 103, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.7"}],
    Cell[125323, 4394, 89, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[125415, 4398, 340, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[125770, 4411, 94, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.8"}],
    Cell[125889, 4416, 73, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[125965, 4420, 93, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[126073, 4426, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.9"}],
    Cell[126253, 4435, 95, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[126351, 4439, 350, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[126716, 4452, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.10"}],
    Cell[126837, 4457, 73, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[126913, 4461, 102, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[127030, 4467, 102, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.11"}],
    Cell[127157, 4472, 78, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[127238, 4476, 126, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[127379, 4482, 179, 5, 70, "Text",
      CellTags->{"S2.4.5", "5.12"}],
    Cell[127561, 4489, 310, 12, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.13"}],
    Cell[127896, 4505, 99, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[127998, 4509, 344, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[128357, 4522, 185, 6, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.14"}],
    Cell[128567, 4532, 74, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[128644, 4536, 138, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[128797, 4542, 105, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.15"}],
    Cell[128927, 4547, 118, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[129048, 4551, 138, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[129201, 4557, 157, 5, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.16"}],
    Cell[129383, 4566, 118, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[129504, 4570, 138, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[129657, 4576, 367, 10, 70, "Text",
      CellTags->{"S2.4.5", "5.17"}],
    Cell[130027, 4588, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.18"}],
    Cell[130148, 4593, 116, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[130267, 4597, 179, 4, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[130461, 4604, 106, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.19"}],
    Cell[130592, 4609, 99, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[130694, 4613, 120, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[130829, 4619, 153, 5, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.20"}],
    Cell[131007, 4628, 111, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[131121, 4632, 115, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[131251, 4638, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.21"}],
    Cell[131376, 4643, 107, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[131486, 4647, 138, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[131639, 4653, 97, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.22"}],
    Cell[131761, 4658, 104, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[131868, 4662, 112, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[131995, 4668, 106, 3, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.23"}],
    Cell[132126, 4675, 141, 5, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[132270, 4682, 177, 4, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[132462, 4689, 422, 11, 70, "Text",
      CellTags->{"S2.4.5", "5.24"}],
    Cell[132887, 4702, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.25"}],
    Cell[133005, 4707, 104, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[133112, 4711, 342, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[133469, 4724, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.26"}],
    Cell[133590, 4729, 74, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[133667, 4733, 112, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[133794, 4739, 147, 4, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.27"}],
    Cell[133966, 4747, 71, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[134040, 4751, 83, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[134138, 4757, 90, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.28"}],
    Cell[134253, 4762, 71, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[134327, 4766, 83, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[134425, 4772, 213, 6, 70, "Text",
      CellTags->{"S2.4.5", "5.29"}],
    Cell[134641, 4780, 82, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.30"}],
    Cell[134748, 4785, 72, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[134823, 4789, 352, 10, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[135190, 4802, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.31"}],
    Cell[135311, 4807, 74, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[135388, 4811, 133, 3, 70, "Output",
      CellTags->"S2.4.5"],
    Cell[135536, 4817, 139, 4, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.32"}],
    Cell[135700, 4825, 70, 2, 70, "Input",
      CellTags->"S2.4.5"],
    Cell[135773, 4829, 100, 3, 27, "Output",
      CellTags->"S2.4.5"],
    Cell[135888, 4835, 101, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.33"}],
    Cell[136014, 4840, 78, 2, 28, "Input",
      CellTags->"S2.4.5"],
    Cell[136095, 4844, 100, 3, 25, "Output",
      CellTags->"S2.4.5"],
    Cell[136210, 4850, 521, 19, 56, "Text",
      CellTags->{"S2.4.5", "5.34"}],
    Cell[136734, 4871, 314, 8, 56, "Text",
      CellTags->{"S2.4.5", "5.35"}],
    Cell[137051, 4881, 86, 1, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.36"}],
    Cell[137162, 4886, 98, 2, 28, "Input",
      CellTags->"S2.4.5"],
    Cell[137263, 4890, 342, 10, 25, "Output",
      CellTags->"S2.4.5"],
    Cell[137620, 4903, 110, 1, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.37"}],
    Cell[137755, 4908, 77, 2, 28, "Input",
      CellTags->"S2.4.5"],
    Cell[137835, 4912, 155, 5, 57, "Output",
      CellTags->"S2.4.5"],
    Cell[138005, 4920, 153, 4, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.38"}],
    Cell[138183, 4928, 74, 2, 28, "Input",
      CellTags->"S2.4.5"],
    Cell[138260, 4932, 84, 3, 25, "Output",
      CellTags->"S2.4.5"],
    Cell[138359, 4938, 133, 4, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.39"}],
    Cell[138517, 4946, 82, 2, 28, "Input",
      CellTags->"S2.4.5"],
    Cell[138602, 4950, 149, 4, 25, "Output",
      CellTags->"S2.4.5"]},
  "5.1"->{
    Cell[113809, 4032, 72, 1, 70, "Subsection",
      CellTags->{"S2.4.5", "5.1"}]},
  "5.2"->{
    Cell[113884, 4035, 524, 12, 70, "Text",
      CellTags->{"S2.4.5", "5.2"}]},
  "5.3"->{
    Cell[117300, 4134, 85, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.3"}]},
  "5.4"->{
    Cell[117857, 4156, 86, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.4"}]},
  "5.5"->{
    Cell[118155, 4171, 119, 4, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.5"}]},
  "5.6"->{
    Cell[118767, 4196, 92, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.6"}]},
  "5.7"->{
    Cell[125195, 4389, 103, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.7"}]},
  "5.8"->{
    Cell[125770, 4411, 94, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.8"}]},
  "5.9"->{
    Cell[126073, 4426, 155, 5, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.9"}]},
  "5.10"->{
    Cell[126716, 4452, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.10"}]},
  "5.11"->{
    Cell[127030, 4467, 102, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.11"}]},
  "5.12"->{
    Cell[127379, 4482, 179, 5, 70, "Text",
      CellTags->{"S2.4.5", "5.12"}]},
  "5.13"->{
    Cell[127561, 4489, 310, 12, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.13"}]},
  "5.14"->{
    Cell[128357, 4522, 185, 6, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.14"}]},
  "5.15"->{
    Cell[128797, 4542, 105, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.15"}]},
  "5.16"->{
    Cell[129201, 4557, 157, 5, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.16"}]},
  "5.17"->{
    Cell[129657, 4576, 367, 10, 70, "Text",
      CellTags->{"S2.4.5", "5.17"}]},
  "5.18"->{
    Cell[130027, 4588, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.18"}]},
  "5.19"->{
    Cell[130461, 4604, 106, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.19"}]},
  "5.20"->{
    Cell[130829, 4619, 153, 5, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.20"}]},
  "5.21"->{
    Cell[131251, 4638, 100, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.21"}]},
  "5.22"->{
    Cell[131639, 4653, 97, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.22"}]},
  "5.23"->{
    Cell[131995, 4668, 106, 3, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.23"}]},
  "5.24"->{
    Cell[132462, 4689, 422, 11, 70, "Text",
      CellTags->{"S2.4.5", "5.24"}]},
  "5.25"->{
    Cell[132887, 4702, 93, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.25"}]},
  "5.26"->{
    Cell[133469, 4724, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.26"}]},
  "5.27"->{
    Cell[133794, 4739, 147, 4, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.27"}]},
  "5.28"->{
    Cell[134138, 4757, 90, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.28"}]},
  "5.29"->{
    Cell[134425, 4772, 213, 6, 70, "Text",
      CellTags->{"S2.4.5", "5.29"}]},
  "5.30"->{
    Cell[134641, 4780, 82, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.30"}]},
  "5.31"->{
    Cell[135190, 4802, 96, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.31"}]},
  "5.32"->{
    Cell[135536, 4817, 139, 4, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.32"}]},
  "5.33"->{
    Cell[135888, 4835, 101, 1, 70, "MathCaption",
      CellTags->{"S2.4.5", "5.33"}]},
  "5.34"->{
    Cell[136210, 4850, 521, 19, 56, "Text",
      CellTags->{"S2.4.5", "5.34"}]},
  "5.35"->{
    Cell[136734, 4871, 314, 8, 56, "Text",
      CellTags->{"S2.4.5", "5.35"}]},
  "5.36"->{
    Cell[137051, 4881, 86, 1, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.36"}]},
  "5.37"->{
    Cell[137620, 4903, 110, 1, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.37"}]},
  "5.38"->{
    Cell[138005, 4920, 153, 4, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.38"}]},
  "5.39"->{
    Cell[138359, 4938, 133, 4, 40, "MathCaption",
      CellTags->{"S2.4.5", "5.39"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.4.0", 139405, 4975},
  {"0.1", 139495, 4978},
  {"S2.4.1", 139588, 4981},
  {"1.1", 142633, 5064},
  {"1.2", 142725, 5067},
  {"1.3", 142812, 5070},
  {"1.4", 142907, 5073},
  {"1.5", 143001, 5076},
  {"1.6", 143095, 5079},
  {"1.7", 143190, 5082},
  {"1.8", 143284, 5085},
  {"1.9", 143373, 5088},
  {"1.10", 143469, 5091},
  {"1.11", 143566, 5094},
  {"1.12", 143664, 5097},
  {"1.13", 143755, 5100},
  {"1.14", 143852, 5103},
  {"1.15", 143950, 5106},
  {"S2.4.2", 144044, 5109},
  {"2.1", 152040, 5322},
  {"2.2", 152134, 5325},
  {"2.3", 152229, 5328},
  {"2.4", 152324, 5331},
  {"2.5", 152420, 5334},
  {"2.6", 152516, 5337},
  {"2.7", 152612, 5340},
  {"2.8", 152707, 5343},
  {"2.9", 152797, 5346},
  {"2.10", 152894, 5349},
  {"2.11", 152992, 5352},
  {"2.12", 153090, 5355},
  {"2.13", 153188, 5358},
  {"2.14", 153286, 5361},
  {"2.15", 153385, 5364},
  {"2.16", 153483, 5367},
  {"2.17", 153577, 5370},
  {"2.18", 153676, 5373},
  {"2.19", 153775, 5376},
  {"2.20", 153867, 5379},
  {"2.21", 153966, 5382},
  {"2.22", 154058, 5385},
  {"2.23", 154156, 5388},
  {"2.24", 154255, 5391},
  {"2.25", 154354, 5394},
  {"2.26", 154453, 5397},
  {"2.27", 154551, 5400},
  {"2.28", 154644, 5403},
  {"2.29", 154743, 5406},
  {"2.30", 154842, 5409},
  {"2.31", 154941, 5412},
  {"2.32", 155040, 5415},
  {"2.33", 155139, 5418},
  {"2.34", 155237, 5421},
  {"2.35", 155336, 5424},
  {"2.36", 155435, 5427},
  {"2.37", 155534, 5430},
  {"S2.4.3", 155635, 5433},
  {"3.1", 160485, 5562},
  {"3.2", 160580, 5565},
  {"3.3", 160677, 5568},
  {"3.4", 160774, 5571},
  {"3.5", 160871, 5574},
  {"3.6", 160968, 5577},
  {"3.7", 161059, 5580},
  {"3.8", 161149, 5583},
  {"3.9", 161245, 5586},
  {"3.10", 161343, 5589},
  {"3.11", 161442, 5592},
  {"3.12", 161541, 5595},
  {"3.13", 161640, 5598},
  {"3.14", 161738, 5601},
  {"3.15", 161836, 5604},
  {"3.16", 161935, 5607},
  {"3.17", 162033, 5610},
  {"3.18", 162132, 5613},
  {"3.19", 162230, 5616},
  {"3.20", 162329, 5619},
  {"S2.4.4", 162430, 5622},
  {"4.1", 169076, 5797},
  {"4.2", 169171, 5800},
  {"4.3", 169267, 5803},
  {"4.4", 169364, 5806},
  {"4.5", 169461, 5809},
  {"4.6", 169557, 5812},
  {"4.7", 169654, 5815},
  {"4.8", 169744, 5818},
  {"4.9", 169840, 5821},
  {"4.10", 169937, 5824},
  {"4.11", 170029, 5827},
  {"4.12", 170128, 5830},
  {"4.13", 170227, 5833},
  {"4.14", 170326, 5836},
  {"4.15", 170425, 5839},
  {"4.16", 170517, 5842},
  {"4.17", 170616, 5845},
  {"4.18", 170714, 5848},
  {"4.19", 170809, 5851},
  {"4.20", 170909, 5854},
  {"4.21", 171009, 5857},
  {"4.22", 171109, 5860},
  {"4.23", 171209, 5863},
  {"4.24", 171302, 5866},
  {"4.25", 171395, 5869},
  {"4.26", 171494, 5872},
  {"4.27", 171594, 5875},
  {"4.28", 171694, 5878},
  {"4.29", 171787, 5881},
  {"4.30", 171887, 5884},
  {"4.31", 171987, 5887},
  {"4.32", 172080, 5890},
  {"4.33", 172180, 5893},
  {"S2.4.5", 172281, 5896},
  {"5.1", 180339, 6107},
  {"5.2", 180435, 6110},
  {"5.3", 180527, 6113},
  {"5.4", 180624, 6116},
  {"5.5", 180721, 6119},
  {"5.6", 180819, 6122},
  {"5.7", 180916, 6125},
  {"5.8", 181014, 6128},
  {"5.9", 181111, 6131},
  {"5.10", 181210, 6134},
  {"5.11", 181309, 6137},
  {"5.12", 181409, 6140},
  {"5.13", 181502, 6143},
  {"5.14", 181603, 6146},
  {"5.15", 181703, 6149},
  {"5.16", 181803, 6152},
  {"5.17", 181903, 6155},
  {"5.18", 181997, 6158},
  {"5.19", 182096, 6161},
  {"5.20", 182196, 6164},
  {"5.21", 182296, 6167},
  {"5.22", 182396, 6170},
  {"5.23", 182495, 6173},
  {"5.24", 182595, 6176},
  {"5.25", 182689, 6179},
  {"5.26", 182788, 6182},
  {"5.27", 182887, 6185},
  {"5.28", 182987, 6188},
  {"5.29", 183086, 6191},
  {"5.30", 183179, 6194},
  {"5.31", 183278, 6197},
  {"5.32", 183377, 6200},
  {"5.33", 183477, 6203},
  {"5.34", 183577, 6206},
  {"5.35", 183671, 6209},
  {"5.36", 183764, 6212},
  {"5.37", 183863, 6215},
  {"5.38", 183963, 6218},
  {"5.39", 184063, 6221}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 121, 4, 65, "Section",
  CellTags->{"S2.4.0", "0.1"}],

Cell[CellGroupData[{
Cell[1922, 61, 77, 1, 70, "Subsection",
  CellTags->{"S2.4.1", "1.1"}],
Cell[2002, 64, 174, 5, 70, "Text",
  CellTags->{"S2.4.1", "1.2"}],
Cell[2179, 71, 6084, 191, 70, "DefinitionBox",
  CellTags->"S2.4.1"],
Cell[8266, 264, 80, 1, 70, "Caption",
  CellTags->"S2.4.1"],
Cell[8349, 267, 106, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.3"}],

Cell[CellGroupData[{
Cell[8480, 272, 82, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[8565, 276, 98, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[8678, 282, 98, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.4"}],

Cell[CellGroupData[{
Cell[8801, 287, 79, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[8883, 291, 98, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[8996, 297, 81, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.5"}],

Cell[CellGroupData[{
Cell[9102, 302, 84, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[9189, 306, 101, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[9305, 312, 153, 4, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.6"}],

Cell[CellGroupData[{
Cell[9483, 320, 100, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[9586, 324, 96, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[9697, 330, 99, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.7"}],

Cell[CellGroupData[{
Cell[9821, 335, 99, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[9923, 339, 98, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[10036, 345, 220, 5, 70, "Text",
  CellTags->{"S2.4.1", "1.8"}],
Cell[10259, 352, 4763, 147, 70, "DefinitionBox",
  CellTags->"S2.4.1"],
Cell[15025, 501, 78, 1, 70, "Caption",
  CellTags->"S2.4.1"],
Cell[15106, 504, 91, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.9"}],

Cell[CellGroupData[{
Cell[15222, 509, 96, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[15321, 513, 91, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[15427, 519, 93, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.10"}],

Cell[CellGroupData[{
Cell[15545, 524, 89, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[15637, 528, 90, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[15742, 534, 160, 5, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.11"}],

Cell[CellGroupData[{
Cell[15927, 543, 99, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[16029, 547, 90, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[16134, 553, 248, 8, 70, "Text",
  CellTags->{"S2.4.1", "1.12"}],
Cell[16385, 563, 968, 30, 70, "DefinitionBox",
  CellTags->"S2.4.1"],
Cell[17356, 595, 133, 7, 70, "Caption",
  CellTags->"S2.4.1"],
Cell[17492, 604, 98, 1, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.13"}],

Cell[CellGroupData[{
Cell[17615, 609, 80, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[17698, 613, 101, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[17814, 619, 157, 4, 70, "MathCaption",
  CellTags->{"S2.4.1", "1.14"}],

Cell[CellGroupData[{
Cell[17996, 627, 112, 2, 70, "Input",
  CellTags->"S2.4.1"],
Cell[18111, 631, 127, 3, 70, "Output",
  CellTags->"S2.4.1"]
}, Open  ]],
Cell[18253, 637, 427, 17, 70, "Text",
  CellTags->{"S2.4.1", "1.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18717, 659, 94, 1, 70, "Subsection",
  CellTags->{"S2.4.2", "2.1"}],
Cell[18814, 662, 3736, 110, 70, "DefinitionBox",
  CellTags->"S2.4.2"],
Cell[22553, 774, 65, 1, 70, "Caption",
  CellTags->"S2.4.2"],
Cell[22621, 777, 90, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.2"}],

Cell[CellGroupData[{
Cell[22736, 782, 86, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[22825, 786, 87, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[22927, 792, 77, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.3"}],
Cell[23007, 795, 99, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[23109, 799, 102, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.4"}],

Cell[CellGroupData[{
Cell[23236, 804, 75, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[23314, 808, 103, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[23432, 814, 108, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.5"}],

Cell[CellGroupData[{
Cell[23565, 819, 78, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[23646, 823, 87, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[23748, 829, 100, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.6"}],

Cell[CellGroupData[{
Cell[23873, 834, 83, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[23959, 838, 97, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[24071, 844, 98, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.7"}],

Cell[CellGroupData[{
Cell[24194, 849, 75, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[24272, 853, 90, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[24377, 859, 319, 15, 70, "Text",
  CellTags->{"S2.4.2", "2.8"}],
Cell[24699, 876, 125, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.9"}],

Cell[CellGroupData[{
Cell[24849, 885, 77, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[24929, 889, 82, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[25026, 895, 126, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.10"}],

Cell[CellGroupData[{
Cell[25177, 904, 65, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[25245, 908, 111, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[25371, 914, 168, 7, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.11"}],

Cell[CellGroupData[{
Cell[25564, 925, 87, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[25654, 929, 95, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[25764, 935, 136, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.12"}],

Cell[CellGroupData[{
Cell[25925, 944, 83, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[26011, 948, 96, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[26122, 954, 137, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.13"}],
Cell[26262, 961, 100, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[26365, 965, 243, 11, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.14"}],

Cell[CellGroupData[{
Cell[26633, 980, 91, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[26727, 984, 112, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[26854, 990, 159, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.15"}],

Cell[CellGroupData[{
Cell[27038, 999, 91, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[27132, 1003, 112, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[27259, 1009, 1744, 60, 70, "Text",
  CellTags->{"S2.4.2", "2.16"}],
Cell[29006, 1071, 132, 4, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.17"}],

Cell[CellGroupData[{
Cell[29163, 1079, 117, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[29283, 1083, 379, 13, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[29677, 1099, 106, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.18"}],

Cell[CellGroupData[{
Cell[29808, 1104, 97, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[29908, 1108, 342, 12, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[30265, 1123, 328, 8, 70, "Text",
  CellTags->{"S2.4.2", "2.19"}],
Cell[30596, 1133, 7240, 213, 70, "DefinitionBox",
  CellTags->"S2.4.2"],
Cell[37839, 1348, 90, 1, 70, "Caption",
  CellTags->"S2.4.2"],
Cell[37932, 1351, 103, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.20"}],

Cell[CellGroupData[{
Cell[38060, 1356, 93, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[38156, 1360, 88, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[38259, 1366, 261, 8, 70, "Text",
  CellTags->{"S2.4.2", "2.21"}],
Cell[38523, 1376, 83, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.22"}],
Cell[38609, 1379, 114, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[38726, 1383, 136, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.23"}],

Cell[CellGroupData[{
Cell[38887, 1392, 82, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[38972, 1396, 109, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[39096, 1402, 102, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.24"}],

Cell[CellGroupData[{
Cell[39223, 1407, 78, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[39304, 1411, 100, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[39419, 1417, 4500, 141, 70, "DefinitionBox",
  CellTags->"S2.4.2"],
Cell[43922, 1560, 93, 1, 70, "Caption",
  CellTags->"S2.4.2"],
Cell[44018, 1563, 111, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.25"}],

Cell[CellGroupData[{
Cell[44154, 1568, 104, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[44261, 1572, 91, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[44367, 1578, 88, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.26"}],

Cell[CellGroupData[{
Cell[44480, 1583, 104, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[44587, 1587, 94, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[44696, 1593, 393, 14, 70, "Text",
  CellTags->{"S2.4.2", "2.27"}],
Cell[45092, 1609, 169, 6, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.28"}],

Cell[CellGroupData[{
Cell[45286, 1619, 117, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[45406, 1623, 379, 13, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[45800, 1639, 180, 6, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.29"}],

Cell[CellGroupData[{
Cell[46005, 1649, 91, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[46099, 1653, 342, 12, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[46456, 1668, 105, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.30"}],

Cell[CellGroupData[{
Cell[46586, 1673, 93, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[46682, 1677, 364, 13, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[47061, 1693, 107, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.31"}],

Cell[CellGroupData[{
Cell[47193, 1698, 94, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[47290, 1702, 349, 13, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[47654, 1718, 3595, 120, 70, "DefinitionBox",
  CellTags->"S2.4.2"],
Cell[51252, 1840, 80, 1, 70, "Caption",
  CellTags->"S2.4.2"],
Cell[51335, 1843, 144, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.32"}],

Cell[CellGroupData[{
Cell[51504, 1852, 103, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[51610, 1856, 104, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[51729, 1862, 87, 1, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.33"}],

Cell[CellGroupData[{
Cell[51841, 1867, 82, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[51926, 1871, 101, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[52042, 1877, 6082, 187, 70, "DefinitionBox",
  CellTags->"S2.4.2"],
Cell[58127, 2066, 67, 1, 70, "Caption",
  CellTags->"S2.4.2"],
Cell[58197, 2069, 151, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.34"}],

Cell[CellGroupData[{
Cell[58373, 2078, 96, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[58472, 2082, 94, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[58581, 2088, 195, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.35"}],

Cell[CellGroupData[{
Cell[58801, 2097, 105, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[58909, 2101, 94, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[59018, 2107, 179, 6, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.36"}],

Cell[CellGroupData[{
Cell[59222, 2117, 82, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[59307, 2121, 115, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]],
Cell[59437, 2127, 151, 5, 70, "MathCaption",
  CellTags->{"S2.4.2", "2.37"}],

Cell[CellGroupData[{
Cell[59613, 2136, 90, 2, 70, "Input",
  CellTags->"S2.4.2"],
Cell[59706, 2140, 115, 3, 70, "Output",
  CellTags->"S2.4.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59870, 2149, 71, 1, 70, "Subsection",
  CellTags->{"S2.4.3", "3.1"}],
Cell[59944, 2152, 7997, 238, 70, "DefinitionBox",
  CellTags->"S2.4.3"],
Cell[67944, 2392, 73, 1, 70, "Caption",
  CellTags->"S2.4.3"],
Cell[68020, 2395, 206, 6, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.2"}],

Cell[CellGroupData[{
Cell[68251, 2405, 94, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[68348, 2409, 136, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[68499, 2415, 127, 4, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.3"}],

Cell[CellGroupData[{
Cell[68651, 2423, 90, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[68744, 2427, 136, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[68895, 2433, 171, 5, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.4"}],

Cell[CellGroupData[{
Cell[69091, 2442, 110, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[69204, 2446, 107, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[69326, 2452, 138, 4, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.5"}],

Cell[CellGroupData[{
Cell[69489, 2460, 88, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[69580, 2464, 121, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[69716, 2470, 313, 11, 70, "Text",
  CellTags->{"S2.4.3", "3.6"}],
Cell[70032, 2483, 955, 29, 70, "DefinitionBox",
  CellTags->"S2.4.3"],
Cell[70990, 2514, 68, 1, 70, "Caption",
  CellTags->"S2.4.3"],
Cell[71061, 2517, 267, 7, 70, "Text",
  CellTags->{"S2.4.3", "3.7"}],
Cell[71331, 2526, 89, 1, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.8"}],

Cell[CellGroupData[{
Cell[71445, 2531, 94, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[71542, 2535, 153, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[71710, 2542, 913, 29, 70, "DefinitionBox",
  CellTags->"S2.4.3"],
Cell[72626, 2573, 66, 1, 70, "Caption",
  CellTags->"S2.4.3"],
Cell[72695, 2576, 175, 6, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.9"}],

Cell[CellGroupData[{
Cell[72895, 2586, 80, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[72978, 2590, 141, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[73134, 2597, 166, 4, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.10"}],

Cell[CellGroupData[{
Cell[73325, 2605, 74, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[73402, 2609, 135, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[73552, 2615, 1914, 57, 70, "DefinitionBox",
  CellTags->"S2.4.3"],
Cell[75469, 2674, 77, 1, 70, "Caption",
  CellTags->"S2.4.3"],
Cell[75549, 2677, 185, 6, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.11"}],

Cell[CellGroupData[{
Cell[75759, 2687, 83, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[75845, 2691, 200, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[76060, 2698, 114, 2, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.12"}],

Cell[CellGroupData[{
Cell[76199, 2704, 87, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[76289, 2708, 200, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[76504, 2715, 89, 1, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.13"}],

Cell[CellGroupData[{
Cell[76618, 2720, 88, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[76709, 2724, 201, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[76925, 2731, 1953, 63, 70, "DefinitionBox",
  CellTags->"S2.4.3"],
Cell[78881, 2796, 77, 1, 70, "Caption",
  CellTags->"S2.4.3"],
Cell[78961, 2799, 78, 1, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.14"}],
Cell[79042, 2802, 111, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[79156, 2806, 134, 5, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.15"}],

Cell[CellGroupData[{
Cell[79315, 2815, 79, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[79397, 2819, 138, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[79550, 2825, 93, 1, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.16"}],

Cell[CellGroupData[{
Cell[79668, 2830, 81, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[79752, 2834, 128, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[79895, 2840, 147, 5, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.17"}],

Cell[CellGroupData[{
Cell[80067, 2849, 86, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[80156, 2853, 187, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[80358, 2860, 6691, 194, 70, "DefinitionBox",
  CellTags->"S2.4.3"],
Cell[87052, 3056, 69, 1, 70, "Caption",
  CellTags->"S2.4.3"],
Cell[87124, 3059, 78, 1, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.18"}],
Cell[87205, 3062, 111, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[87319, 3066, 101, 1, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.19"}],

Cell[CellGroupData[{
Cell[87445, 3071, 90, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[87538, 3075, 123, 3, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]],
Cell[87676, 3081, 199, 6, 70, "MathCaption",
  CellTags->{"S2.4.3", "3.20"}],

Cell[CellGroupData[{
Cell[87900, 3091, 87, 2, 70, "Input",
  CellTags->"S2.4.3"],
Cell[87990, 3095, 163, 4, 70, "Output",
  CellTags->"S2.4.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88202, 3105, 89, 1, 70, "Subsection",
  CellTags->{"S2.4.4", "4.1"}],
Cell[88294, 3108, 1927, 60, 70, "DefinitionBox",
  CellTags->"S2.4.4"],
Cell[90224, 3170, 74, 1, 70, "Caption",
  CellTags->"S2.4.4"],
Cell[90301, 3173, 86, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.2"}],

Cell[CellGroupData[{
Cell[90412, 3178, 96, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[90511, 3182, 103, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[90629, 3188, 100, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.3"}],

Cell[CellGroupData[{
Cell[90754, 3193, 99, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[90856, 3197, 125, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[90996, 3203, 100, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.4"}],

Cell[CellGroupData[{
Cell[91121, 3208, 99, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[91223, 3212, 97, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[91335, 3218, 99, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.5"}],

Cell[CellGroupData[{
Cell[91459, 3223, 98, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[91560, 3227, 118, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[91693, 3233, 115, 2, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.6"}],

Cell[CellGroupData[{
Cell[91833, 3239, 107, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[91943, 3243, 118, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[92076, 3249, 304, 6, 70, "Text",
  CellTags->{"S2.4.4", "4.7"}],
Cell[92383, 3257, 93, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.8"}],

Cell[CellGroupData[{
Cell[92501, 3262, 93, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[92597, 3266, 97, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[92709, 3272, 77, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.9"}],

Cell[CellGroupData[{
Cell[92811, 3277, 96, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[92910, 3281, 114, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[93039, 3287, 340, 8, 70, "Text",
  CellTags->{"S2.4.4", "4.10"}],
Cell[93382, 3297, 138, 4, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.11"}],

Cell[CellGroupData[{
Cell[93545, 3305, 104, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[93652, 3309, 136, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[93803, 3315, 168, 5, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.12"}],

Cell[CellGroupData[{
Cell[93996, 3324, 107, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[94106, 3328, 136, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[94257, 3334, 171, 7, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.13"}],

Cell[CellGroupData[{
Cell[94453, 3345, 113, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[94569, 3349, 137, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[94721, 3355, 133, 4, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.14"}],

Cell[CellGroupData[{
Cell[94879, 3363, 109, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[94991, 3367, 128, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[95134, 3373, 310, 8, 70, "Text",
  CellTags->{"S2.4.4", "4.15"}],
Cell[95447, 3383, 111, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.16"}],

Cell[CellGroupData[{
Cell[95583, 3388, 106, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[95692, 3392, 157, 4, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[95864, 3399, 99, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.17"}],

Cell[CellGroupData[{
Cell[95988, 3404, 107, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[96098, 3408, 126, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[96239, 3414, 6991, 213, 70, "DefinitionBox",
  CellTags->"S2.4.4"],
Cell[103233, 3629, 75, 1, 70, "Caption",
  CellTags->"S2.4.4"],
Cell[103311, 3632, 1154, 42, 70, "Text",
  CellTags->{"S2.4.4", "4.18"}],
Cell[104468, 3676, 155, 5, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.19"}],

Cell[CellGroupData[{
Cell[104648, 3685, 105, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[104756, 3689, 126, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[104897, 3695, 155, 5, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.20"}],

Cell[CellGroupData[{
Cell[105077, 3704, 105, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[105185, 3708, 137, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[105337, 3714, 155, 5, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.21"}],

Cell[CellGroupData[{
Cell[105517, 3723, 105, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[105625, 3727, 168, 4, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[105808, 3734, 109, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.22"}],

Cell[CellGroupData[{
Cell[105942, 3739, 110, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[106055, 3743, 168, 4, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[106238, 3750, 212, 7, 70, "Text",
  CellTags->{"S2.4.4", "4.23"}],
Cell[106453, 3759, 241, 8, 70, "Text",
  CellTags->{"S2.4.4", "4.24"}],
Cell[106697, 3769, 3815, 117, 70, "DefinitionBox",
  CellTags->"S2.4.4"],
Cell[110515, 3888, 57, 1, 70, "Caption",
  CellTags->"S2.4.4"],
Cell[110575, 3891, 95, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.25"}],

Cell[CellGroupData[{
Cell[110695, 3896, 86, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[110784, 3900, 100, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[110899, 3906, 174, 7, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.26"}],

Cell[CellGroupData[{
Cell[111098, 3917, 94, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[111195, 3921, 100, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[111310, 3927, 100, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.27"}],

Cell[CellGroupData[{
Cell[111435, 3932, 98, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[111536, 3936, 112, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[111663, 3942, 207, 8, 70, "Text",
  CellTags->{"S2.4.4", "4.28"}],
Cell[111873, 3952, 174, 6, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.29"}],

Cell[CellGroupData[{
Cell[112072, 3962, 103, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[112178, 3966, 115, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[112308, 3972, 205, 6, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.30"}],

Cell[CellGroupData[{
Cell[112538, 3982, 93, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[112634, 3986, 171, 4, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[112820, 3993, 165, 4, 70, "Text",
  CellTags->{"S2.4.4", "4.31"}],
Cell[112988, 3999, 108, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.32"}],

Cell[CellGroupData[{
Cell[113121, 4004, 118, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[113242, 4008, 138, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]],
Cell[113395, 4014, 95, 1, 70, "MathCaption",
  CellTags->{"S2.4.4", "4.33"}],

Cell[CellGroupData[{
Cell[113515, 4019, 104, 2, 70, "Input",
  CellTags->"S2.4.4"],
Cell[113622, 4023, 138, 3, 70, "Output",
  CellTags->"S2.4.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[113809, 4032, 72, 1, 70, "Subsection",
  CellTags->{"S2.4.5", "5.1"}],
Cell[113884, 4035, 524, 12, 70, "Text",
  CellTags->{"S2.4.5", "5.2"}],
Cell[114411, 4049, 2808, 80, 70, "DefinitionBox",
  CellTags->"S2.4.5"],
Cell[117222, 4131, 75, 1, 70, "Caption",
  CellTags->"S2.4.5"],
Cell[117300, 4134, 85, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.3"}],

Cell[CellGroupData[{
Cell[117410, 4139, 89, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[117502, 4143, 340, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[117857, 4156, 86, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.4"}],

Cell[CellGroupData[{
Cell[117968, 4161, 73, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[118044, 4165, 96, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[118155, 4171, 119, 4, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.5"}],

Cell[CellGroupData[{
Cell[118299, 4179, 107, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[118409, 4183, 343, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[118767, 4196, 92, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.6"}],

Cell[CellGroupData[{
Cell[118884, 4201, 73, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[118960, 4205, 114, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[119089, 4211, 6020, 173, 70, "DefinitionBox",
  CellTags->"S2.4.5"],
Cell[125112, 4386, 80, 1, 70, "Caption",
  CellTags->"S2.4.5"],
Cell[125195, 4389, 103, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.7"}],

Cell[CellGroupData[{
Cell[125323, 4394, 89, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[125415, 4398, 340, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[125770, 4411, 94, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.8"}],

Cell[CellGroupData[{
Cell[125889, 4416, 73, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[125965, 4420, 93, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[126073, 4426, 155, 5, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.9"}],

Cell[CellGroupData[{
Cell[126253, 4435, 95, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[126351, 4439, 350, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[126716, 4452, 96, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.10"}],

Cell[CellGroupData[{
Cell[126837, 4457, 73, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[126913, 4461, 102, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[127030, 4467, 102, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.11"}],

Cell[CellGroupData[{
Cell[127157, 4472, 78, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[127238, 4476, 126, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[127379, 4482, 179, 5, 70, "Text",
  CellTags->{"S2.4.5", "5.12"}],
Cell[127561, 4489, 310, 12, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.13"}],

Cell[CellGroupData[{
Cell[127896, 4505, 99, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[127998, 4509, 344, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[128357, 4522, 185, 6, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.14"}],

Cell[CellGroupData[{
Cell[128567, 4532, 74, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[128644, 4536, 138, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[128797, 4542, 105, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.15"}],

Cell[CellGroupData[{
Cell[128927, 4547, 118, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[129048, 4551, 138, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[129201, 4557, 157, 5, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.16"}],

Cell[CellGroupData[{
Cell[129383, 4566, 118, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[129504, 4570, 138, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[129657, 4576, 367, 10, 70, "Text",
  CellTags->{"S2.4.5", "5.17"}],
Cell[130027, 4588, 96, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.18"}],

Cell[CellGroupData[{
Cell[130148, 4593, 116, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[130267, 4597, 179, 4, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[130461, 4604, 106, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.19"}],

Cell[CellGroupData[{
Cell[130592, 4609, 99, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[130694, 4613, 120, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[130829, 4619, 153, 5, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.20"}],

Cell[CellGroupData[{
Cell[131007, 4628, 111, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[131121, 4632, 115, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[131251, 4638, 100, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.21"}],

Cell[CellGroupData[{
Cell[131376, 4643, 107, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[131486, 4647, 138, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[131639, 4653, 97, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.22"}],

Cell[CellGroupData[{
Cell[131761, 4658, 104, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[131868, 4662, 112, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[131995, 4668, 106, 3, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.23"}],

Cell[CellGroupData[{
Cell[132126, 4675, 141, 5, 70, "Input",
  CellTags->"S2.4.5"],
Cell[132270, 4682, 177, 4, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[132462, 4689, 422, 11, 70, "Text",
  CellTags->{"S2.4.5", "5.24"}],
Cell[132887, 4702, 93, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.25"}],

Cell[CellGroupData[{
Cell[133005, 4707, 104, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[133112, 4711, 342, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[133469, 4724, 96, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.26"}],

Cell[CellGroupData[{
Cell[133590, 4729, 74, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[133667, 4733, 112, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[133794, 4739, 147, 4, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.27"}],

Cell[CellGroupData[{
Cell[133966, 4747, 71, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[134040, 4751, 83, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[134138, 4757, 90, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.28"}],

Cell[CellGroupData[{
Cell[134253, 4762, 71, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[134327, 4766, 83, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[134425, 4772, 213, 6, 70, "Text",
  CellTags->{"S2.4.5", "5.29"}],
Cell[134641, 4780, 82, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.30"}],

Cell[CellGroupData[{
Cell[134748, 4785, 72, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[134823, 4789, 352, 10, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[135190, 4802, 96, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.31"}],

Cell[CellGroupData[{
Cell[135311, 4807, 74, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[135388, 4811, 133, 3, 70, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[135536, 4817, 139, 4, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.32"}],

Cell[CellGroupData[{
Cell[135700, 4825, 70, 2, 70, "Input",
  CellTags->"S2.4.5"],
Cell[135773, 4829, 100, 3, 27, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[135888, 4835, 101, 1, 70, "MathCaption",
  CellTags->{"S2.4.5", "5.33"}],

Cell[CellGroupData[{
Cell[136014, 4840, 78, 2, 28, "Input",
  CellTags->"S2.4.5"],
Cell[136095, 4844, 100, 3, 25, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[136210, 4850, 521, 19, 56, "Text",
  CellTags->{"S2.4.5", "5.34"}],
Cell[136734, 4871, 314, 8, 56, "Text",
  CellTags->{"S2.4.5", "5.35"}],
Cell[137051, 4881, 86, 1, 40, "MathCaption",
  CellTags->{"S2.4.5", "5.36"}],

Cell[CellGroupData[{
Cell[137162, 4886, 98, 2, 28, "Input",
  CellTags->"S2.4.5"],
Cell[137263, 4890, 342, 10, 25, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[137620, 4903, 110, 1, 40, "MathCaption",
  CellTags->{"S2.4.5", "5.37"}],

Cell[CellGroupData[{
Cell[137755, 4908, 77, 2, 28, "Input",
  CellTags->"S2.4.5"],
Cell[137835, 4912, 155, 5, 57, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[138005, 4920, 153, 4, 40, "MathCaption",
  CellTags->{"S2.4.5", "5.38"}],

Cell[CellGroupData[{
Cell[138183, 4928, 74, 2, 28, "Input",
  CellTags->"S2.4.5"],
Cell[138260, 4932, 84, 3, 25, "Output",
  CellTags->"S2.4.5"]
}, Open  ]],
Cell[138359, 4938, 133, 4, 40, "MathCaption",
  CellTags->{"S2.4.5", "5.39"}],

Cell[CellGroupData[{
Cell[138517, 4946, 82, 2, 28, "Input",
  CellTags->"S2.4.5"],
Cell[138602, 4950, 149, 4, 25, "Output",
  CellTags->"S2.4.5"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

