(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    152542,       5967]*)
(*NotebookOutlinePosition[    226964,       8126]*)
(*  CellTagsIndexPosition[    220332,       7867]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.5 ", "HeadingNumber"],
  "Transformation Rules and Definitions"
}], "Section",
  CellTags->{"S2.5.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.5.1 Applying Transformation Rules", "Subsection",
  CellTags->{"S2.5.1", "1.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "apply a transformation rule to ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "try a sequence of rules on each part of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.1"],

Cell["Applying transformation rules. ", "Caption",
  CellTags->"S2.5.1"],

Cell[TextData[{
  "The replacement operator ",
  StyleBox["/.", "MR"],
  " (pronounced \[OpenCurlyDoubleQuote]slash\[Hyphen]dot\
\[CloseCurlyDoubleQuote]) applies rules to expressions. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.2"}],

Cell[CellGroupData[{

Cell["x + y /. x -> 3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(3 + y\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["\<\
You can give a list of rules to apply. Each rule will be tried once \
on each part of the expression. \
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.3"}],

Cell[CellGroupData[{

Cell["x + y /. {x -> a, y -> b}", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(a + b\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rules",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rules",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the results from applying each of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rules",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.1"],

Cell["Applying lists of transformation rules. ", "Caption",
  CellTags->"S2.5.1"],

Cell["\<\
If you give a list of lists of rules, you get a list of results. \
\
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.4"}],

Cell[CellGroupData[{

Cell["x + y /. {{x -> 1, y -> 2}, {x -> 4, y -> 2}}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({3, 6}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "Functions such as ",
  StyleBox["Solve", "MR"],
  " and ",
  StyleBox["NSolve", "MR"],
  " return lists whose elements are lists of rules, each representing a \
solution. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.5"}],

Cell[CellGroupData[{

Cell["Solve[x^3 - 5x^2 +2x + 8 == 0, x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 2}, {x \[Rule] 4}}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["\<\
When you apply these rules, you get a list of results, one \
corresponding to each solution. \
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.6"}],

Cell[CellGroupData[{

Cell["x^2 + 6 /. %", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({7, 10, 22}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox["/.", "MR"],
  " ",
  StyleBox["rules", "TI"],
  ", each rule is tried in turn on each part of ",
  StyleBox["expr", "TI"],
  ". As soon as a rule applies, the appropriate transformation is made, and \
the resulting part is returned. "
}], "Text",
  CellTags->{"S2.5.1", "1.7"}],

Cell[TextData[{
  "The rule for ",
  StyleBox["x^3", "MR"],
  " is tried first; if it does not apply, the rule for ",
  StyleBox["x^n_", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.8"}],

Cell[CellGroupData[{

Cell["{x^2, x^3, x^4} /. {x^3 -> u, x^n_ -> p[n]}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({p[2], u, p[4]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "A result is returned as soon as the rule has been applied, so the inner \
instance of ",
  StyleBox["h", "MR"],
  " is not replaced. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.9"}],

Cell[CellGroupData[{

Cell["h[x + h[y]] /. h[u_] -> u^2", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(\((x + h[y])\)\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "The replacement ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox["/.", "MR"],
  " ",
  StyleBox["rules", "TI"],
  " tries each rule just once on each part of ",
  StyleBox["expr", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.5.1", "1.10"}],

Cell[TextData[{
  "Since each rule is tried just once, this serves to swap ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.11"}],

Cell[CellGroupData[{

Cell["{x^2, y^3} /. {x -> y, y -> x}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({y\^2, x\^3}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["\<\
You can use this notation to apply one set of rules, followed by \
another. \
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.12"}],

Cell[CellGroupData[{

Cell["x^2 /. x -> (1 + y) /. y -> b", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(\((1 + b)\)\^2\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "Sometimes you may need to go on applying rules over and over again, until \
the expression you are working on no longer changes. You can do this using \
the repeated replacement operation ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox["//.", "MR"],
  " ",
  StyleBox["rules", "TI"],
  " (or ",
  StyleBox["ReplaceRepeated[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["rules", "TI"],
  StyleBox["]", "MR"],
  "). "
}], "Text",
  CellTags->{"S2.5.1", "1.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["rules", "TI"],
              " "
            }]], Cell[TextData[{
              "try rules once on each part of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["//.", "MR"],
              " ",
              StyleBox["rules", "TI"],
              " "
            }]], Cell[
            "try rules repeatedly until the result no longer changes "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.1"],

Cell["Single and repeated rule application. ", "Caption",
  CellTags->"S2.5.1"],

Cell[TextData[{
  "With the single replacement operator ",
  StyleBox["/.", "MR"],
  " each rule is tried only once on each part of the expression. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.14"}],

Cell[CellGroupData[{

Cell["x^2 + y^6 /. {x -> 2 + a, a -> 3}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(\((2 + a)\)\^2 + y\^6\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "With the repeated replacement operator ",
  StyleBox["//.", "MR"],
  " the rules are tried repeatedly until the expression no longer changes. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.15"}],

Cell[CellGroupData[{

Cell["x^2 + y^6 //. {x -> 2 + a, a -> 3}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(25 + y\^6\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["Here the rule is applied only once. ", "MathCaption",
  CellTags->{"S2.5.1", "1.16"}],

Cell[CellGroupData[{

Cell["log[a b c d] /. log[x_ y_] -> log[x] + log[y]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(log[a] + log[b\ c\ d]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["\<\
With the repeated replacement operator, the rule is applied \
repeatedly, until the result no longer changes. \
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.17"}],

Cell[CellGroupData[{

Cell["log[a b c d] //. log[x_ y_] -> log[x] + log[y]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(log[a] + log[b] + log[c] + log[d]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["//.", "MR"],
  " (pronounced \[OpenCurlyDoubleQuote]slash\[Hyphen]slash\[Hyphen]dot\
\[CloseCurlyDoubleQuote]), ",
  StyleBox["Mathematica", "TI"],
  " repeatedly passes through your expression, trying each of the rules \
given. It goes on doing this until it gets the same result on two successive \
passes. "
}], "Text",
  CellTags->{"S2.5.1", "1.18"}],

Cell[TextData[{
  "If you give a set of rules that is circular, then ",
  StyleBox["//.", "MR"],
  " can keep on getting different results forever. In practice, the maximum \
number of passes that ",
  StyleBox["//.", "MR"],
  " makes on a particular expression is determined by the setting for the \
option ",
  StyleBox["MaxIterations", "MR"],
  ". If you want to keep going for as long as possible, you can use ",
  StyleBox["ReplaceRepeated[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["rules", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["MaxIterations", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Infinity]", "MR"],
  ". You can always stop by explicitly interrupting ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.5.1", "1.19"}],

Cell[TextData[{
  "By setting the option ",
  StyleBox["MaxIterations", "MR"],
  ", you can explicitly tell ",
  StyleBox["ReplaceRepeated", "MR"],
  " how many times to try the rules you give. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.20"}],

Cell[CellGroupData[{

Cell["ReplaceRepeated[x, x -> x + 1, MaxIterations -> 1000]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(ReplaceRepeated::"rrlim" \(\(:\)\(\ \)\) 
      "Exiting after \!\(x\) scanned \!\(1000\) times."\)], "Message",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(1000 + x\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "The replacement operators ",
  StyleBox["/.", "MR"],
  " and ",
  StyleBox["//.", "MR"],
  " share the feature that they try each rule on every subpart of your \
expression. On the other hand, ",
  StyleBox["Replace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["rules", "TI"],
  StyleBox["]", "MR"],
  " tries the rules only on the whole of ",
  StyleBox["expr", "TI"],
  ", and not on any of its subparts. "
}], "Text",
  CellTags->{"S2.5.1", "1.21"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Replace", "MR"],
  ", together with functions like ",
  StyleBox["Map", "MR"],
  " and ",
  StyleBox["MapAt", "MR"],
  ", to control exactly which parts of an expression a replacement is applied \
to. Remember that you can use the function ",
  StyleBox["ReplacePart[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["new", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["pos", "TI"],
  StyleBox["]", "MR"],
  " to replace part of an expression with a specific object. "
}], "Text",
  CellTags->{"S2.5.1", "1.22"}],

Cell[TextData[{
  "The operator ",
  StyleBox["/.", "MR"],
  " applies rules to all subparts of an expression. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.23"}],

Cell[CellGroupData[{

Cell["x^2 /. x -> a", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(a\^2\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "Without a level specification, ",
  StyleBox["Replace", "MR"],
  " applies rules only to the whole expression. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.24"}],

Cell[CellGroupData[{

Cell["Replace[x^2, x^2 -> b]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(b\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["No replacement is done here. ", "MathCaption",
  CellTags->{"S2.5.1", "1.25"}],

Cell[CellGroupData[{

Cell["Replace[x^2, x -> a]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "This applies rules down to level 2, and so replaces ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.26"}],

Cell[CellGroupData[{

Cell["Replace[x^2, x -> a, 2]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(a\^2\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["rules", "TI"],
              " "
            }]], Cell[TextData[{
              "apply rules to all subparts of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Replace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply rules to the whole of ",
              StyleBox["expr", "TI"],
              " only "
            }]]},
          {Cell[TextData[{
              StyleBox["Replace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["levspec", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply rules to parts of ",
              StyleBox["expr", "TI"],
              " on levels specified by ",
              StyleBox["levspec", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.1"],

Cell["Applying rules to whole expressions. ", "Caption",
  CellTags->"S2.5.1"],

Cell[TextData[{
  StyleBox["Replace", "MR"],
  " returns the result from using the first rule that applies. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.27"}],

Cell[CellGroupData[{

Cell["Replace[f[u], {f[x_] -> x^2, f[x_] -> x^3}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \(u\^2\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ReplaceList", "MR"],
  " gives a list of the results from every rule that applies. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.28"}],

Cell[CellGroupData[{

Cell["ReplaceList[f[u], {f[x_] -> x^2, f[x_] -> x^3}]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({u\^2, u\^3}\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[TextData[{
  "If a single rule can be applied in several ways, ",
  StyleBox["ReplaceList", "MR"],
  " gives a list of all the results. "
}], "MathCaption",
  CellTags->{"S2.5.1", "1.29"}],

Cell[CellGroupData[{

Cell["ReplaceList[a + b + c, x_ + y_ -> g[x, y]]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({g[a, b + c], g[b, a + c], g[c, a + b], g[a + b, c], g[a + c, b], 
      g[b + c, a]}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["\<\
This gives a list of ways of breaking the original list in two. \
\
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.30"}],

Cell[CellGroupData[{

Cell["ReplaceList[{a, b, c, d}, {x__, y__} -> g[{x}, {y}]]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({g[{a}, {b, c, d}], g[{a, b}, {c, d}], g[{a, b, c}, {d}]}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell["\<\
This finds all sublists that are flanked by the same element. \
\
\>", "MathCaption",
  CellTags->{"S2.5.1", "1.31"}],

Cell[CellGroupData[{

Cell["\<\
ReplaceList[{a, b, c, a, d, b, d}, {___, x_, y__, x_, ___} -> g[x, \
{y}]]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.5.1"],

Cell[BoxData[
    \({g[a, {b, c}], g[b, {c, a, d}], g[d, {b}]}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Replace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["rules", "TI"],
              " in one way only "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplaceList[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["rules", "TI"],
              " in all possible ways "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.1"],

Cell["Applying rules in one way or all possible ways. ", "Caption",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.2 Manipulating Sets of Transformation Rules", "Subsection",
  CellTags->{"S2.5.2", "2.1"}],

Cell[TextData[{
  "You can manipulate lists of transformation rules in ",
  StyleBox["Mathematica", "TI"],
  " just like other symbolic expressions. It is common to assign a name to a \
rule or set of rules. "
}], "Text",
  CellTags->{"S2.5.2", "2.2"}],

Cell[TextData[{
  "This assigns the \[OpenCurlyDoubleQuote]name\[CloseCurlyDoubleQuote] ",
  StyleBox["sinexp", "MR"],
  " to the trigonometric expansion rule. "
}], "MathCaption",
  CellTags->{"S2.5.2", "2.3"}],

Cell[CellGroupData[{

Cell["sinexp = Sin[2 x_] -> 2 Sin[x] Cos[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.2"],

Cell[BoxData[
    \(Sin[2\ x_] \[Rule] 2\ Cos[x]\ Sin[x]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.2"]
}, Open  ]],

Cell["\<\
You can now request the rule \[OpenCurlyDoubleQuote]by name\
\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",
  CellTags->{"S2.5.2", "2.4"}],

Cell[CellGroupData[{

Cell["Sin[2 (1 + x)^2] /. sinexp", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.2"],

Cell[BoxData[
    \(2\ Cos[\((1 + x)\)\^2]\ Sin[\((1 + x)\)\^2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.2"]
}, Open  ]],

Cell["\<\
You can use lists of rules to represent mathematical and other \
relations. Typically you will find it convenient to give names to the lists, \
so that you can easily specify the list you want in a particular case. \
\>", \
"Text",
  CellTags->{"S2.5.2", "2.5"}],

Cell[TextData[{
  "In most situations, it is only one rule from any given list that actually \
applies to a particular expression. Nevertheless, the ",
  StyleBox["/.", "MR"],
  " operator tests each of the rules in the list in turn. If the list is very \
long, this process can take a long time. "
}], "Text",
  CellTags->{"S2.5.2", "2.6"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to preprocess lists of rules so that ",
  StyleBox["/.", "MR"],
  " can operate more quickly on them. You can take any list of rules and \
apply the function ",
  StyleBox["Dispatch", "MR"],
  " to them. The result is a representation of the original list of rules, \
but including dispatch tables which allow ",
  StyleBox["/.", "MR"],
  " to \[OpenCurlyDoubleQuote]dispatch\[CloseCurlyDoubleQuote] to potentially \
applicable rules immediately, rather than testing all the rules in turn. "
}], "Text",
  CellTags->{"S2.5.2", "2.7"}],

Cell["Here is a list of rules for the first five factorials. ", "MathCaption",
  CellTags->{"S2.5.2", "2.8"}],

Cell[CellGroupData[{

Cell["facs = Table[f[i] -> i!, {i, 5}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.2"],

Cell[BoxData[
    \({f[1] \[Rule] 1, f[2] \[Rule] 2, f[3] \[Rule] 6, f[4] \[Rule] 24, 
      f[5] \[Rule] 120}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.2"]
}, Open  ]],

Cell["\<\
This sets up dispatch tables that make the rules faster to use. \
\
\>", "MathCaption",
  CellTags->{"S2.5.2", "2.9"}],

Cell[CellGroupData[{

Cell["dfacs = Dispatch[facs]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.2"],

Cell[BoxData[
    TagBox[
      RowBox[{"Dispatch", "[", 
        RowBox[{\({f[1] \[Rule] 1, f[2] \[Rule] 2, f[3] \[Rule] 6, 
            f[4] \[Rule] 24, f[5] \[Rule] 120}\), ",", 
          TagBox[
            InterpretationBox[\(\(-DispatchTables\)\(-\)\),
              1],
            DisplayForm]}], "]"}],
      Function[ BoxForm`arg, 
        ReplacePart[ 
          HoldComplete[ 
            Dispatch[ ProgrammingDump`dumy]], 
          HoldComplete[ BoxForm`arg], {1, 1}, {1, 1}], {
        HoldAllComplete}]]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.2"]
}, Open  ]],

Cell[TextData[{
  "You can apply the rules using the ",
  StyleBox["/.", "MR"],
  " operator. "
}], "MathCaption",
  CellTags->{"S2.5.2", "2.10"}],

Cell[CellGroupData[{

Cell["f[4] /. dfacs", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.2"],

Cell[BoxData[
    \(24\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.5.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Dispatch[", "MR"],
              StyleBox["rules", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
create a representation of a list of rules that \
includes dispatch tables \
\>"]},
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["drules", "TI"],
              " "
            }]], Cell["apply rules that include dispatch tables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.2"],

Cell["Creating and using dispatch tables. ", "Caption",
  CellTags->"S2.5.2"],

Cell[TextData[{
  "For long lists of rules, you will find that setting up dispatch tables \
makes replacement operations much faster. This is particularly true when your \
rules are for individual symbols or other expressions that do not involve \
pattern objects. Once you have built dispatch tables in such cases, you will \
find that the ",
  StyleBox["/.", "MR"],
  " operator takes a time that is more or less independent of the number of \
rules you have. Without dispatch tables, however, ",
  StyleBox["/.", "MR"],
  " will take a time directly proportional to the total number of rules. "
}], "Text",
  CellTags->{"S2.5.2", "2.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.3 Making Definitions", "Subsection",
  CellTags->{"S2.5.3", "3.1"}],

Cell[TextData[{
  "The replacement operator ",
  StyleBox["/.", "MR"],
  " allows you to apply transformation rules to a specific expression. Often, \
however, you want to have transformation rules automatically applied whenever \
possible. "
}], "Text",
  CellTags->{"S2.5.3", "3.2"}],

Cell[TextData[{
  "You can do this by assigning explicit values to ",
  StyleBox["Mathematica", "TI"],
  " expressions and patterns. Each assignment specifies a transformation rule \
to be applied whenever an expression of the appropriate form occurs. "
}], "Text",
  CellTags->{"S2.5.3", "3.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[
            "apply a transformation rule to a specific expression "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], 
            Cell["\<\
assign a value which defines a transformation rule to \
be used whenever possible \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.3"],

Cell["Manual and automatic application of transformation rules. ", "Caption",
  CellTags->"S2.5.3"],

Cell[TextData[{
  "This applies a transformation rule for ",
  StyleBox["x", "MR"],
  " to a specific expression. "
}], "MathCaption",
  CellTags->{"S2.5.3", "3.4"}],

Cell[CellGroupData[{

Cell["(1 + x)^6 /. x -> 3 - a", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.3"],

Cell[BoxData[
    \(\((4 - a)\)\^6\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.3"]
}, Open  ]],

Cell[TextData[{
  "By assigning a value to ",
  StyleBox["x", "MR"],
  ", you tell ",
  StyleBox["Mathematica", "TI"],
  " to apply a transformation rule for ",
  StyleBox["x", "MR"],
  " whenever possible. "
}], "MathCaption",
  CellTags->{"S2.5.3", "3.5"}],

Cell[CellGroupData[{

Cell["x = 3 - a", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.3"],

Cell[BoxData[
    \(3 - a\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.3"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["x", "MR"],
  " is transformed automatically. "
}], "MathCaption",
  CellTags->{"S2.5.3", "3.6"}],

Cell[CellGroupData[{

Cell["(1 + x)^7", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.3"],

Cell[BoxData[
    \(\((4 - a)\)\^7\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.3"]
}, Open  ]],

Cell[TextData[{
  "You should realize that except inside constructs like ",
  StyleBox["Module", "MR"],
  " and ",
  StyleBox["Block", "MR"],
  ", all assignments you make in a ",
  StyleBox["Mathematica", "TI"],
  " session are ",
  StyleBox["permanent", "TI"],
  ". They continue to be used for the duration of the session, unless you \
explicitly clear or overwrite them. "
}], "Text",
  CellTags->{"S2.5.3", "3.7"}],

Cell[TextData[{
  "The fact that assignments are permanent means that they must be made with \
care. Probably the single most common mistake in using ",
  StyleBox["Mathematica", "TI"],
  " is to make an assignment for a variable like ",
  StyleBox["x", "MR"],
  " at one point in your session, and then later to use ",
  StyleBox["x", "MR"],
  " having forgotten about the assignment you made. "
}], "Text",
  CellTags->{"S2.5.3", "3.8"}],

Cell[TextData[{
  "There are several ways to avoid this kind of mistake. First, you should \
avoid using assignments whenever possible, and instead use more controlled \
constructs such as the ",
  StyleBox["/.", "MR"],
  " replacement operator. Second, you should explicitly use the deassignment \
operator ",
  StyleBox["=.", "MR"],
  " or the function ",
  StyleBox["Clear", "MR"],
  " to remove values you have assigned when you have finished with them. "
}], "Text",
  CellTags->{"S2.5.3", "3.9"}],

Cell[TextData[{
  "Another important way to avoid mistakes is to think particularly carefully \
before assigning values to variables with common or simple names. You will \
often want to use a variable such as ",
  StyleBox["x", "MR"],
  " as a symbolic parameter. But if you make an assignment such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["3", "MR"],
  ", then ",
  StyleBox["x", "MR"],
  " will be replaced by ",
  StyleBox["3", "MR"],
  " whenever it occurs, and you can no longer use ",
  StyleBox["x", "MR"],
  " as a symbolic parameter. "
}], "Text",
  CellTags->{"S2.5.3", "3.10"}],

Cell[TextData[{
  "In general, you should be sure not to assign permanent values to any \
variables that you might want to use for more than one purpose. If at one \
point in your session you wanted the variable ",
  StyleBox["c", "MR"],
  " to stand for the speed of light, you might assign it a value such as ",
  StyleBox["3.*10^8", "MR"],
  ". But then you cannot use ",
  StyleBox["c", "MR"],
  " later in your session to stand, say, for an undetermined coefficient. One \
way to avoid this kind of problem is to make assignments only for variables \
with more explicit names, such as ",
  StyleBox["SpeedOfLight", "MR"],
  "."
}], "Text",
  CellTags->{"S2.5.3", "3.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell[TextData[{
              "remove the value assigned to the object ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Clear[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "clear all the values of ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.3"],

Cell["Removing assignments. ", "Caption",
  CellTags->"S2.5.3"],

Cell[TextData[{
  "This does not give what you might expect, because ",
  StyleBox["x", "MR"],
  " still has the value you assigned it above. "
}], "MathCaption",
  CellTags->{"S2.5.3", "3.12"}],

Cell[CellGroupData[{

Cell["Factor[ x^2 - 1 ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.3"],

Cell[BoxData[
    \(\((\(-4\) + a)\)\ \((\(-2\) + a)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.3"]
}, Open  ]],

Cell[TextData[{
  "This removes any value assigned to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.3", "3.13"}],

Cell["Clear[x]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.3"],

Cell["Now this gives the result you expect. ", "MathCaption",
  CellTags->{"S2.5.3", "3.14"}],

Cell[CellGroupData[{

Cell["Factor[ x^2 - 1 ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.3"],

Cell[BoxData[
    \(\((\(-1\) + x)\)\ \((1 + x)\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.4 Special Forms of Assignment", "Subsection",
  CellTags->{"S2.5.4", "4.1"}],

Cell[TextData[{
  "Particularly when you write procedural programs in ",
  StyleBox["Mathematica", "TI"],
  ", you will often need to modify the value of a particular variable \
repeatedly. You can always do this by constructing the new value and \
explicitly performing an assignment such as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ". ",
  StyleBox["Mathematica", "TI"],
  ", however, provides special notations for incrementing the values of \
variables, and for some other common cases. "
}], "Text",
  CellTags->{"S2.5.4", "4.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["i", "TI"],
              StyleBox["++", "MR"],
              " "
            }]], Cell[TextData[{
              "increment the value of ",
              StyleBox["i", "TI"],
              " by ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["i", "TI"],
              StyleBox["--", "MR"],
              " "
            }]], Cell[TextData[{
              "decrement ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["++", "MR"],
              StyleBox["i", "TI"],
              " "
            }]], Cell[TextData[{
              "pre\[Hyphen]increment ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["--", "MR"],
              StyleBox["i", "TI"],
              " "
            }]], Cell[TextData[{
              "pre\[Hyphen]decrement ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["i", "TI"],
              " ",
              StyleBox["+=", "MR"],
              " ",
              StyleBox["di", "TI"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["di", "TI"],
              " to the value of ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["i", "TI"],
              " ",
              StyleBox["-=", "MR"],
              " ",
              StyleBox["di", "TI"],
              " "
            }]], Cell[TextData[{
              "subtract ",
              StyleBox["di", "TI"],
              " from ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["*=", "MR"],
              " ",
              StyleBox["c", "TI"],
              " "
            }]], Cell[TextData[{
              "multiply ",
              StyleBox["x", "TI"],
              " by ",
              StyleBox["c", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["/=", "MR"],
              " ",
              StyleBox["c", "TI"],
              " "
            }]], Cell[TextData[{
              "divide ",
              StyleBox["x", "TI"],
              " by ",
              StyleBox["c", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.4"],

Cell["Modifying values of variables. ", "Caption",
  CellTags->"S2.5.4"],

Cell[TextData[{
  "This assigns the value ",
  StyleBox["7x", "MR"],
  " to the variable ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.3"}],

Cell[CellGroupData[{

Cell["t = 7x", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(7\ x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "This increments the value of ",
  StyleBox["t", "MR"],
  " by ",
  StyleBox["18x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.4"}],

Cell[CellGroupData[{

Cell["t += 18x", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(25\ x\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "The value of ",
  StyleBox["t", "MR"],
  " has been modified. "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.5"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(25\ x\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "This sets ",
  StyleBox["t", "MR"],
  " to ",
  StyleBox["8", "MR"],
  ", multiplies its value by ",
  StyleBox["7", "MR"],
  ", then gives the final value of\[NonBreakingSpace]",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.6"}],

Cell[CellGroupData[{

Cell["t = 8; t *= 7; t", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(56\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "The value of ",
  StyleBox["i++", "MR"],
  " is the value of ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["before", "TI"],
  " the increment is done. "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.7"}],

Cell[CellGroupData[{

Cell["i=5; Print[i++]; Print[i]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(5\)], "Print",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "The value of ",
  StyleBox["++i", "MR"],
  " is the value of ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["after", "TI"],
  " the increment. "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.8"}],

Cell[CellGroupData[{

Cell["i=5; Print[++i]; Print[i]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "assign the same value to both ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["value",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["value",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "assign different values to ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "interchange the values of ",
              StyleBox["x", "TI"],
              " and ",
              StyleBox["y", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.4"],

Cell["Assigning values to several variables at a time. ", "Caption",
  CellTags->"S2.5.4"],

Cell[TextData[{
  "This assigns the value ",
  StyleBox["5", "MR"],
  " to ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["8", "MR"],
  " to\[NonBreakingSpace]",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.9"}],

Cell[CellGroupData[{

Cell["{x, y} = {5, 8}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({5, 8}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "This interchanges the values of ",
  StyleBox["x", "MR"],
  " and\[NonBreakingSpace]",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.10"}],

Cell[CellGroupData[{

Cell["{x, y} = {y, x}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({8, 5}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["x", "MR"],
  " has value ",
  StyleBox["8", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.11"}],

Cell[CellGroupData[{

Cell["x", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "And ",
  StyleBox["y", "MR"],
  " has value ",
  StyleBox["5", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.12"}],

Cell[CellGroupData[{

Cell["y", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell["\<\
You can use assignments to lists to permute values of variables in \
any way. \
\>", "MathCaption",
  CellTags->{"S2.5.4", "4.13"}],

Cell[CellGroupData[{

Cell["{a, b, c} = {1, 2, 3}; {b, a, c} = {a, c, b}; {a, b, c}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({3, 1, 2}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "When you write programs in ",
  StyleBox["Mathematica", "TI"],
  ", you will sometimes find it convenient to take a list, and successively \
add elements to it. You can do this using the functions ",
  StyleBox["PrependTo", "MR"],
  " and ",
  StyleBox["AppendTo", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.4", "4.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PrependTo[", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "prepend ",
              StyleBox["elem", "TI"],
              " to the value of ",
              StyleBox["v", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["AppendTo[", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "append ",
              StyleBox["elem", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["v", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["v", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["elem", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "make a nested list containing ",
              StyleBox["elem", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.4"],

Cell["Assignments for modifying lists. ", "Caption",
  CellTags->"S2.5.4"],

Cell[TextData[{
  "This assigns the value of ",
  StyleBox["v", "MR"],
  " to be the list ",
  StyleBox["{5,", "MR"],
  " ",
  StyleBox["7,", "MR"],
  " ",
  StyleBox["9}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.15"}],

Cell[CellGroupData[{

Cell["v = {5, 7, 9}", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({5, 7, 9}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "This appends the element ",
  StyleBox["11", "MR"],
  " to the value of ",
  StyleBox["v", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.16"}],

Cell[CellGroupData[{

Cell["AppendTo[v, 11]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({5, 7, 9, 11}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "Now the value of ",
  StyleBox["v", "MR"],
  " has been modified. "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.17"}],

Cell[CellGroupData[{

Cell["v", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({5, 7, 9, 11}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "Although ",
  StyleBox["AppendTo[", "MR"],
  StyleBox["v", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  " is always equivalent to ",
  StyleBox["v", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["Append[", "MR"],
  StyleBox["v", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["elem", "TI"],
  StyleBox["]", "MR"],
  ", it is often a convenient notation. However, you should realize that \
because of the way ",
  StyleBox["Mathematica", "TI"],
  " stores lists, it is usually less efficient to add a sequence of elements \
to a particular list than to create a nested structure that consists, for \
example, of lists of length 2 at each level. When you have built up such a \
structure, you can always reduce it to a single list using ",
  StyleBox["Flatten", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.4", "4.18"}],

Cell[TextData[{
  "This sets up a nested list structure for\[NonBreakingSpace]",
  StyleBox["w", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.19"}],

Cell[CellGroupData[{

Cell["w = {1}; Do[ w = {w, k^2}, {k, 1, 4} ]; w", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({{{{{1}, 1}, 4}, 9}, 16}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.5.4"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Flatten", "MR"],
  " to unravel the structure. "
}], "MathCaption",
  CellTags->{"S2.5.4", "4.20"}],

Cell[CellGroupData[{

Cell["Flatten[w]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.5.4"],

Cell[BoxData[
    \({1, 1, 4, 9, 16}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.5.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.5 Making Definitions for Indexed Objects", "Subsection",
  CellTags->{"S2.5.5", "5.1"}],

Cell[TextData[{
  "In many kinds of calculations, you need to set up \
\[OpenCurlyDoubleQuote]arrays\[CloseCurlyDoubleQuote] which contain sequences \
of expressions, each specified by a certain index. One way to implement \
arrays in ",
  StyleBox["Mathematica", "TI"],
  " is by using lists. You can define a list, say ",
  StyleBox["a", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["z", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  ", then access its elements using ",
  StyleBox["a", "TI"],
  StyleBox["[[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]]", "MR"],
  ", or modify them using ",
  StyleBox["a", "TI"],
  StyleBox["[[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ". This approach has a drawback, however, in that it requires you to fill \
in all the elements when you first create the list. "
}], "Text",
  CellTags->{"S2.5.5", "5.2"}],

Cell[TextData[{
  "Often, it is more convenient to set up arrays in which you can fill in \
only those elements that you need at a particular time. You can do this by \
making definitions for expressions such as ",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.5", "5.3"}],

Cell[TextData[{
  "This defines a value for ",
  StyleBox["a[1]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.4"}],

Cell[CellGroupData[{

Cell["a[1] = 9", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \(9\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "This defines a value for ",
  StyleBox["a[2]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.5"}],

Cell[CellGroupData[{

Cell["a[2] = 7", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "This shows all the values you have defined for expressions associated with \
",
  StyleBox["a", "MR"],
  " so far. "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.6"}],

Cell[CellGroupData[{

Cell["?a", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \("Global`a"\)], "Print",
  CellTags->"S2.5.5"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(a[1] = 9\)},
                {" "},
                {\(a[2] = 7\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ a],
      Editable->False]], "Print",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "You can define a value for ",
  StyleBox["a[5]", "MR"],
  ", even though you have not yet given values to ",
  StyleBox["a[3]", "MR"],
  " and ",
  StyleBox["a[4]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.7"}],

Cell[CellGroupData[{

Cell["a[5] = 0", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "This generates a list of the values of the ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.8"}],

Cell[CellGroupData[{

Cell["Table[a[i], {i, 5}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \({9, 7, a[3], a[4], 0}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "You can think of the expression ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  " as being like an \[OpenCurlyDoubleQuote]indexed\[CloseCurlyDoubleQuote] \
or \[OpenCurlyDoubleQuote]subscripted\[CloseCurlyDoubleQuote] variable.  "
}], "Text",
  CellTags->{"S2.5.5", "5.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell["add or overwrite a value "]},
          {Cell[TextData[{
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["access a value "]},
          {Cell[TextData[{
              StyleBox["a", "TI"],
              StyleBox["[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=.", "MR"],
              " "
            }]], Cell["remove a value "]},
          {Cell[TextData[{
              StyleBox["?", "MR"],
              StyleBox["a", "TI"],
              " "
            }]], Cell["show all defined values "]},
          {Cell[TextData[{
              StyleBox["Clear[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["clear all defined values "]},
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["[i],", "MR"],
              " ",
              StyleBox["{i,", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["Array[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "convert to an explicit ",
              StyleBox["List", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.5"],

Cell["Manipulating indexed variables. ", "Caption",
  CellTags->"S2.5.5"],

Cell[TextData[{
  "When you have an expression of the form ",
  StyleBox["a", "TI"],
  StyleBox["[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  ", there is no requirement that the \[OpenCurlyDoubleQuote]index\
\[CloseCurlyDoubleQuote] ",
  StyleBox["i", "TI"],
  " be a number. In fact, ",
  StyleBox["Mathematica", "TI"],
  " allows the index to be any expression whatsoever. By using indices that \
are symbols, you can for example build up simple databases in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.5.5", "5.10"}],

Cell[TextData[{
  "This defines the \[OpenCurlyDoubleQuote]object\[CloseCurlyDoubleQuote] ",
  StyleBox["area", "MR"],
  " with \[OpenCurlyDoubleQuote]index\[CloseCurlyDoubleQuote] ",
  StyleBox["square", "MR"],
  " to have value ",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.11"}],

Cell[CellGroupData[{

Cell["area[square] = 1", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "This adds another result to the ",
  StyleBox["area", "MR"],
  " \[OpenCurlyDoubleQuote]database\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.12"}],

Cell[CellGroupData[{

Cell["area[triangle] = 1/2", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \(1\/2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "Here are the entries in the ",
  StyleBox["area", "MR"],
  " database so far. "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.13"}],

Cell[CellGroupData[{

Cell["?area", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \("Global`area"\)], "Print",
  CellTags->"S2.5.5"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(area[square] = 1\)},
                {" "},
                {\(area[triangle] = 1\/2\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ area],
      Editable->False]], "Print",
  CellTags->"S2.5.5"]
}, Open  ]],

Cell[TextData[{
  "You can use these definitions wherever you want. You have not yet assigned \
a value for ",
  StyleBox["area[pentagon]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.5", "5.14"}],

Cell[CellGroupData[{

Cell["4 area[square] + area[pentagon]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.5"],

Cell[BoxData[
    \(4 + area[pentagon]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.6 Making Definitions for Functions", "Subsection",
  CellTags->{"S2.5.6", "6.1"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.7.1",
    ButtonData:>{"1.7.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  " discussed how you can define functions in ",
  StyleBox["Mathematica", "TI"],
  ". In a typical case, you would type in ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " to define a function ",
  StyleBox["f", "MR"],
  ". (Actually, the definitions in Section ",
  ButtonBox["1.7.1",
    ButtonData:>{"1.7.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  " used the ",
  StyleBox[":=", "MR"],
  " operator, rather than the ",
  StyleBox["=", "MR"],
  " one. Section ",
  ButtonBox["2.5.8",
    ButtonData:>{"2.5.8", "8.1"},
    ButtonStyle->"MainBookLink"],
  " will explain exactly when to use each of the ",
  StyleBox[":=", "MR"],
  " and ",
  StyleBox["=", "MR"],
  " operators.) "
}], "Text",
  CellTags->{"S2.5.6", "6.2"}],

Cell[TextData[{
  "The definition ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " specifies that whenever ",
  StyleBox["Mathematica", "TI"],
  " encounters an expression which matches the pattern ",
  StyleBox["f[x_]", "MR"],
  ", it should replace the expression by ",
  StyleBox["x^2", "MR"],
  ". Since the pattern ",
  StyleBox["f[x_]", "MR"],
  " matches all expressions of the form ",
  StyleBox["f[", "MR"],
  StyleBox["anything", "TI"],
  StyleBox["]", "MR"],
  ", the definition applies to functions ",
  StyleBox["f", "MR"],
  " with any \[OpenCurlyDoubleQuote]argument\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.5.6", "6.3"}],

Cell[TextData[{
  "Function definitions like ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " can be compared with definitions like ",
  StyleBox["f[a]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["b", "MR"],
  " for indexed variables discussed in the previous subsection. The \
definition ",
  StyleBox["f[a]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["b", "MR"],
  " specifies that whenever the ",
  StyleBox["particular", "TI"],
  " expression ",
  StyleBox["f[a]", "MR"],
  " occurs, it is to be replaced by ",
  StyleBox["b", "MR"],
  ". But the definition says nothing about expressions such as ",
  StyleBox["f[y]", "MR"],
  ", where ",
  StyleBox["f", "MR"],
  " appears with another \
\[OpenCurlyDoubleQuote]index\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.5.6", "6.4"}],

Cell[TextData[{
  "To define a \[OpenCurlyDoubleQuote]function\[CloseCurlyDoubleQuote], you \
need to specify values for expressions of the form ",
  StyleBox["f[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ", where the argument ",
  StyleBox["x", "TI"],
  " can be anything. You can do this by giving a definition for the pattern \
",
  StyleBox["f[x_]", "MR"],
  ", where the pattern object ",
  StyleBox["x_", "MR"],
  " stands for any expression. "
}], "Text",
  CellTags->{"S2.5.6", "6.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "definition for a ",
              StyleBox["specific expression", "TI"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "definition for ",
              StyleBox["any expression", "TI"],
              ", referred to as ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.6"],

Cell["\<\
The difference between defining an indexed variable and a function. \
\
\>", "Caption",
  CellTags->"S2.5.6"],

Cell[TextData[{
  "Making definitions for ",
  StyleBox["f[2]", "MR"],
  " or ",
  StyleBox["f[a]", "MR"],
  " can be thought of as being like giving values to various elements of an \
\[OpenCurlyDoubleQuote]array\[CloseCurlyDoubleQuote] named ",
  StyleBox["f", "MR"],
  ". Making a definition for ",
  StyleBox["f[x_]", "MR"],
  " is like giving a value for a set of \[OpenCurlyDoubleQuote]array elements\
\[CloseCurlyDoubleQuote] with arbitrary \[OpenCurlyDoubleQuote]indices\
\[CloseCurlyDoubleQuote]. In fact, you can actually think of any function as \
being like an array with an arbitrarily variable index.  "
}], "Text",
  CellTags->{"S2.5.6", "6.6"}],

Cell[TextData[{
  "In mathematical terms, you can think of ",
  StyleBox["f", "MR"],
  " as a ",
  StyleBox["mapping", "TI"],
  ". When you define values for, say, ",
  StyleBox["f[1]", "MR"],
  " and ",
  StyleBox["f[2]", "MR"],
  ", you specify the image of this mapping for various discrete points in its \
domain. Defining a value for ",
  StyleBox["f[x_]", "MR"],
  " specifies the image of ",
  StyleBox["f", "MR"],
  " on a continuum of points. "
}], "Text",
  CellTags->{"S2.5.6", "6.7"}],

Cell[TextData[{
  "This defines a transformation rule for the ",
  StyleBox["specific expression", "TI"],
  " ",
  StyleBox["f[x]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.6", "6.8"}],

Cell[CellGroupData[{

Cell["f[x] = u", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(u\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.6"]
}, Open  ]],

Cell[TextData[{
  "When the specific expression ",
  StyleBox["f[x]", "MR"],
  " appears, it is replaced by ",
  StyleBox["u", "MR"],
  ". Other expressions of the form ",
  StyleBox["f[", "MR"],
  StyleBox["argument", "TI"],
  StyleBox["]", "MR"],
  " are, however, not modified. "
}], "MathCaption",
  CellTags->{"S2.5.6", "6.9"}],

Cell[CellGroupData[{

Cell["f[x] + f[y]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(u + f[y]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.6"]
}, Open  ]],

Cell[TextData[{
  "This defines a value for ",
  StyleBox["f", "MR"],
  " with ",
  StyleBox["any expression", "TI"],
  " as an \[OpenCurlyDoubleQuote]argument\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S2.5.6", "6.10"}],

Cell[CellGroupData[{

Cell["f[x_] = x^2", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.6"]
}, Open  ]],

Cell[TextData[{
  "The old definition for the ",
  StyleBox["specific expression", "TI"],
  " ",
  StyleBox["f[x]", "MR"],
  " is still used, but the new general definition for ",
  StyleBox["f[x_]", "MR"],
  " is now used to find a value for ",
  StyleBox["f[y]", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S2.5.6", "6.11"}],

Cell[CellGroupData[{

Cell["f[x] + f[y]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(u + y\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.6"]
}, Open  ]],

Cell[TextData[{
  "This removes all definitions for ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.6", "6.12"}],

Cell["Clear[f]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.6"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to define transformation rules for any expression or pattern. \
You can mix definitions for specific expressions such as ",
  StyleBox["f[1]", "MR"],
  " or ",
  StyleBox["f[a]", "MR"],
  " with definitions for patterns such as ",
  StyleBox["f[x_]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.6", "6.13"}],

Cell[TextData[{
  "Many kinds of mathematical functions can be set up by mixing specific and \
general definitions in ",
  StyleBox["Mathematica", "TI"],
  ". As an example, consider the factorial function. This particular function \
is in fact built into ",
  StyleBox["Mathematica", "TI"],
  " (it is written ",
  StyleBox["n", "TI"],
  StyleBox["!", "MR"],
  "). But you can use ",
  StyleBox["Mathematica", "TI"],
  " definitions to set up the function for yourself. "
}], "Text",
  CellTags->{"S2.5.6", "6.14"}],

Cell[TextData[{
  "The standard mathematical definition for the factorial function can be \
entered almost directly into ",
  StyleBox["Mathematica", "TI"],
  ", in the form: ",
  StyleBox["f[n_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["n", "MR"],
  " ",
  StyleBox["f[n-1];", "MR"],
  " ",
  StyleBox["f[1]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["1", "MR"],
  ". This definition specifies that for any ",
  StyleBox["n", "TI"],
  ", ",
  StyleBox["f[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " should be replaced by ",
  StyleBox["n", "TI"],
  " ",
  StyleBox["f[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["-1]", "MR"],
  ", except that when ",
  StyleBox["n", "TI"],
  " is ",
  StyleBox["1", "MR"],
  ", ",
  StyleBox["f[1]", "MR"],
  " should simply be replaced by\[NonBreakingSpace]",
  StyleBox["1", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.6", "6.15"}],

Cell["\<\
Here is the value of the factorial function with argument 1. \
\>", \
"MathCaption",
  CellTags->{"S2.5.6", "6.16"}],

Cell[CellGroupData[{

Cell["f[1] = 1", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.6"]
}, Open  ]],

Cell["\<\
Here is the general recursion relation for the factorial function. \
\
\>", "MathCaption",
  CellTags->{"S2.5.6", "6.17"}],

Cell["f[n_] := n f[n-1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.6"],

Cell["\<\
Now you can use these definitions to find values for the factorial \
function. \
\>", "MathCaption",
  CellTags->{"S2.5.6", "6.18"}],

Cell[CellGroupData[{

Cell["f[10]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(3628800\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.5.6"]
}, Open  ]],

Cell["\<\
The results are the same as you get from the built\[Hyphen]in \
version of factorial. \
\>", "MathCaption",
  CellTags->{"S2.5.6", "6.19"}],

Cell[CellGroupData[{

Cell["10!", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.6"],

Cell[BoxData[
    \(3628800\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.7 The Ordering of Definitions", "Subsection",
  CellTags->{"S2.5.7", "7.1"}],

Cell[TextData[{
  "When you make a sequence of definitions in ",
  StyleBox["Mathematica", "TI"],
  ", some may be more general than others. ",
  StyleBox["Mathematica", "TI"],
  " follows the principle of trying to put more general definitions after \
more specific ones. This means that special cases of rules are typically \
tried before more general cases. "
}], "Text",
  CellTags->{"S2.5.7", "7.2"}],

Cell[TextData[{
  "This behavior is crucial to the factorial function example given in the \
previous section. Regardless of the order in which you entered them, ",
  StyleBox["Mathematica", "TI"],
  " will always put the rule for the special case ",
  StyleBox["f[1]", "MR"],
  " ahead of the rule for the general case ",
  StyleBox["f[n_]", "MR"],
  ". This means that when ",
  StyleBox["Mathematica", "TI"],
  " looks for the value of an expression of the form ",
  StyleBox["f[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", it tries the special case ",
  StyleBox["f[1]", "MR"],
  " first, and only if this does not apply, it tries the general case ",
  StyleBox["f[n_]", "MR"],
  ". As a result, when you ask for ",
  StyleBox["f[5]", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will keep on using the general rule until the \[OpenCurlyDoubleQuote]end \
condition\[CloseCurlyDoubleQuote] rule for ",
  StyleBox["f[1]", "MR"],
  " applies. "
}], "Text",
  CellTags->{"S2.5.7", "7.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["Mathematica", "TI"],
              
              " tries to put specific definitions before more general \
definitions. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.7"],

Cell[TextData[{
  "Treatment of definitions in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.5.7"],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica", "TI"],
  " did not follow the principle of putting special rules before more general \
ones, then the special rules would always be \[OpenCurlyDoubleQuote]shadowed\
\[CloseCurlyDoubleQuote] by more general ones. In the factorial example, if \
the rule for ",
  StyleBox["f[n_]", "MR"],
  " was ahead of the rule for ",
  StyleBox["f[1]", "MR"],
  ", then even when ",
  StyleBox["Mathematica", "TI"],
  " tried to evaluate ",
  StyleBox["f[1]", "MR"],
  ", it would use the general ",
  StyleBox["f[n_]", "MR"],
  " rule, and it would never find the special ",
  StyleBox["f[1]", "MR"],
  " rule. "
}], "Text",
  CellTags->{"S2.5.7", "7.4"}],

Cell[TextData[{
  "Here is a general definition for ",
  StyleBox["f[n_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.7", "7.5"}],

Cell["f[n_] := n f[n-1]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.7"],

Cell[TextData[{
  "Here is a definition for the special case ",
  StyleBox["f[1]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.7", "7.6"}],

Cell[CellGroupData[{

Cell["f[1] = 1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.7"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " puts the special case before the general one. "
}], "MathCaption",
  CellTags->{"S2.5.7", "7.7"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.7"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S2.5.7"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[1] = 1\)},
                {" "},
                {\(f[n_] := n\ f[n - 1]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.5.7"]
}, Open  ]],

Cell[TextData[{
  "In the factorial function example used above, it is clear which rule is \
more general. Often, however, there is no definite ordering in generality of \
the rules you give. In such cases, ",
  StyleBox["Mathematica", "TI"],
  " simply tries the rules in the order you give them. "
}], "Text",
  CellTags->{"S2.5.7", "7.8"}],

Cell["These rules have no definite ordering in generality. ", "MathCaption",
  CellTags->{"S2.5.7", "7.9"}],

Cell["log[x_ y_] := log[x] + log[y] ; log[x_^n_] := n log[x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.7"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " stores the rules in the order you gave them. "
}], "MathCaption",
  CellTags->{"S2.5.7", "7.10"}],

Cell[CellGroupData[{

Cell["?log", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.7"],

Cell[BoxData[
    \("Global`log"\)], "Print",
  CellTags->"S2.5.7"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(log[x_\ y_] := log[x] + log[y]\)},
                {" "},
                {\(log[x_\^n_] := n\ log[x]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ log],
      Editable->False]], "Print",
  CellTags->"S2.5.7"]
}, Open  ]],

Cell[TextData[{
  "This rule is a special case of the rule for ",
  StyleBox["log[x_", "MR"],
  " ",
  StyleBox["y_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.7", "7.11"}],

Cell["log[2 x_] := log[x] + log2", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.7"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " puts the special rule before the more general one. "
}], "MathCaption",
  CellTags->{"S2.5.7", "7.12"}],

Cell[CellGroupData[{

Cell["?log", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.7"],

Cell[BoxData[
    \("Global`log"\)], "Print",
  CellTags->"S2.5.7"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(log[2\ x_] := log[x] + log2\)},
                {" "},
                {\(log[x_\ y_] := log[x] + log[y]\)},
                {" "},
                {\(log[x_\^n_] := n\ log[x]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ log],
      Editable->False]], "Print",
  CellTags->"S2.5.7"]
}, Open  ]],

Cell[TextData[{
  "Although in many practical cases, ",
  StyleBox["Mathematica", "TI"],
  " can recognize when one rule is more general than another, you should \
realize that this is not always possible. For example, if two rules both \
contain complicated ",
  StyleBox["/;", "MR"],
  " conditions, it may not be possible to work out which is more general, \
and, in fact, there may not be a definite ordering. Whenever the appropriate \
ordering is not clear, ",
  StyleBox["Mathematica", "TI"],
  " stores rules in the order you give them. "
}], "Text",
  CellTags->{"S2.5.7", "7.13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.8 Immediate and Delayed Definitions", "Subsection",
  CellTags->{"S2.5.8", "8.1"}],

Cell[TextData[{
  "You may have noticed that there are two different ways to make assignments \
in ",
  StyleBox["Mathematica", "TI"],
  ": ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " and ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ". The basic difference between these forms is ",
  StyleBox["when", "TI"],
  " the expression ",
  StyleBox["rhs", "TI"],
  " is evaluated. ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " is an ",
  StyleBox["immediate assignment", "TI"],
  ", in which ",
  StyleBox["rhs", "TI"],
  " is evaluated at the time when the assignment is made. ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", on the other hand, is a ",
  StyleBox["delayed assignment", "TI"],
  ", in which ",
  StyleBox["rhs", "TI"],
  " is not evaluated when the assignment is made, but is instead evaluated \
each time the value of ",
  StyleBox["lhs", "TI"],
  " is requested. "
}], "Text",
  CellTags->{"S2.5.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " (immediate assignment) "
            }]], Cell[TextData[{
              StyleBox["rhs", "TI"],
              " is evaluated when the assignment is made"
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " (delayed assignment) "
            }]], Cell[TextData[{
              StyleBox["rhs", "TI"],
              " is evaluated each time the value of ",
              StyleBox["lhs", "TI"],
              " is requested"
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.8"],

Cell[TextData[{
  "The two types of assignments in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "This uses the ",
  StyleBox[":=", "MR"],
  " operator to define the function ",
  StyleBox["ex", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.3"}],

Cell["ex[x_] := Expand[(1 + x)^2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "Because ",
  StyleBox[":=", "MR"],
  " was used, the definition is maintained in an unevaluated form. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.4"}],

Cell[CellGroupData[{

Cell["?ex", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \("Global`ex"\)], "Print",
  CellTags->"S2.5.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(ex[x_] := Expand[\((1 + x)\)\^2]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ ex],
      Editable->False]], "Print",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "When you make an assignment with the ",
  StyleBox["=", "MR"],
  " operator, the right\[Hyphen]hand side is evaluated immediately. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.5"}],

Cell[CellGroupData[{

Cell["iex[x_] = Expand[(1 + x)^2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(1 + 2\ x + x\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "The definition now stored is the result of the ",
  StyleBox["Expand", "MR"],
  " command. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.6"}],

Cell[CellGroupData[{

Cell["?iex", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \("Global`iex"\)], "Print",
  CellTags->"S2.5.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(iex[x_] = 1 + 2\ x + x\^2\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ iex],
      Editable->False]], "Print",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "When you execute ",
  StyleBox["ex", "MR"],
  ", the ",
  StyleBox["Expand", "MR"],
  " is performed. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.7"}],

Cell[CellGroupData[{

Cell["ex[y + 2]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(9 + 6\ y + y\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["iex", "MR"],
  " simply substitutes its argument into the already expanded form, giving a \
different answer. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.8"}],

Cell[CellGroupData[{

Cell["iex[y + 2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(1 + 2\ \((2 + y)\) + \((2 + y)\)\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "As you can see from the example above, both ",
  StyleBox["=", "MR"],
  " and ",
  StyleBox[":=", "MR"],
  " can be useful in defining functions, but they have different meanings, \
and you must be careful about which one to use in a particular case. "
}], "Text",
  CellTags->{"S2.5.8", "8.9"}],

Cell[TextData[{
  "One rule of thumb is the following. If you think of an assignment as \
giving the final \[OpenCurlyDoubleQuote]value\[CloseCurlyDoubleQuote] of an \
expression, use the ",
  StyleBox["=", "MR"],
  " operator. If instead you think of the assignment as specifying a \
\[OpenCurlyDoubleQuote]command\[CloseCurlyDoubleQuote] for finding the value, \
use the ",
  StyleBox[":=", "MR"],
  " operator. If in doubt, it is usually better to use the ",
  StyleBox[":=", "MR"],
  " operator than the ",
  StyleBox["=", "MR"],
  " one. "
}], "Text",
  CellTags->{"S2.5.8", "8.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["rhs", "TI"],
              
              " is intended to be the \[OpenCurlyDoubleQuote]final value\
\[CloseCurlyDoubleQuote] of ",
              StyleBox["lhs", "TI"],
              " (e.g., ",
              StyleBox["f[x_]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["1", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["x^2", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["rhs", "TI"],
              
              " gives a \
\[OpenCurlyDoubleQuote]command\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]program\[CloseCurlyDoubleQuote] to be executed \
whenever you ask for the value of ",
              StyleBox["lhs", "TI"],
              " (e.g., ",
              StyleBox["f[x_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["Expand[1", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["x^2]", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.8"],

Cell[TextData[{
  "Interpretations of assignments with the ",
  StyleBox["=", "MR"],
  " and ",
  StyleBox[":=", "MR"],
  " operators. "
}], "Caption",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "Although ",
  StyleBox[":=", "MR"],
  " is probably used more often than ",
  StyleBox["=", "MR"],
  " in defining functions, there is one important case in which you must use \
",
  StyleBox["=", "MR"],
  " to define a function. If you do a calculation, and get an answer in terms \
of a symbolic parameter ",
  StyleBox["x", "TI"],
  ", you often want to go on and find results for various specific values of \
",
  StyleBox["x", "TI"],
  ". One way to do this is to use the ",
  StyleBox["/.", "MR"],
  " operator to apply appropriate rules for ",
  StyleBox["x", "TI"],
  " in each case. It is usually more convenient however, to use ",
  StyleBox["=", "MR"],
  " to define a function whose argument is ",
  StyleBox["x", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.5.8", "8.11"}],

Cell[TextData[{
  "Here is an expression involving ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.12"}],

Cell[CellGroupData[{

Cell["D[Log[Sin[x]]^2, x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(2\ Cot[x]\ Log[Sin[x]]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "This defines a function whose argument is the value to be taken for\
\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.13"}],

Cell[CellGroupData[{

Cell["dlog[x_] = %", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(2\ Cot[x]\ Log[Sin[x]]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here is the result when ",
  StyleBox["x", "MR"],
  " is taken to be ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.14"}],

Cell[CellGroupData[{

Cell["dlog[1 + a]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(2\ Cot[1 + a]\ Log[Sin[1 + a]]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "An important point to notice in the example above is that there is nothing \
special about the name ",
  StyleBox["x", "MR"],
  " that appears in the ",
  StyleBox["x_", "MR"],
  " pattern. It is just a symbol, indistinguishable from an ",
  StyleBox["x", "MR"],
  " that appears in any other expression. "
}], "Text",
  CellTags->{"S2.5.8", "8.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["expr", "TI"],
              " "
            }]], Cell[TextData[{
              "define a function which gives the value ",
              StyleBox["expr", "TI"],
              " for any particular value of ",
              StyleBox["x", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.8"],

Cell["Defining functions for evaluating expressions. ", "Caption",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "You can use ",
  StyleBox["=", "MR"],
  " and ",
  StyleBox[":=", "MR"],
  " not only to define functions, but also to assign values to variables. If \
you type ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ", then ",
  StyleBox["value", "TI"],
  " is immediately evaluated, and the result is assigned to ",
  StyleBox["x", "TI"],
  ". On the other hand, if you type ",
  StyleBox["x", "TI"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ", then ",
  StyleBox["value", "TI"],
  " is not immediately evaluated. Instead, it is maintained in an unevaluated \
form, and is evaluated afresh each time ",
  StyleBox["x", "TI"],
  " is used. "
}], "Text",
  CellTags->{"S2.5.8", "8.16"}],

Cell[TextData[{
  "This evaluates ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " to find a pseudorandom number, then assigns this number to ",
  StyleBox["r1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.17"}],

Cell[CellGroupData[{

Cell["r1 = Random[ ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(0.056070794834861534`\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is maintained in an unevaluated form, to be evaluated afresh each time ",
  StyleBox["r2", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.18"}],

Cell["r2 := Random[ ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "Here are values for ",
  StyleBox["r1", "MR"],
  " and ",
  StyleBox["r2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.19"}],

Cell[CellGroupData[{

Cell["{r1, r2}", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \({0.056070794834861534`, 0.630299795779359`}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "The value of ",
  StyleBox["r1", "MR"],
  " never changes. Every time ",
  StyleBox["r2", "MR"],
  " is used, however, a new pseudorandom number is generated. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.20"}],

Cell[CellGroupData[{

Cell["{r1, r2}", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \({0.056070794834861534`, 0.3598942942214413`}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell["\<\
The distinction between immediate and delayed assignments is \
particularly important when you set up chains of assignments. \
\>", "Text",
  CellTags->{"S2.5.8", "8.21"}],

Cell[TextData[{
  "This defines ",
  StyleBox["a", "MR"],
  " to be ",
  StyleBox["1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.22"}],

Cell[CellGroupData[{

Cell["a = 1", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " is evaluated to give ",
  StyleBox["3", "MR"],
  ", and the result is assigned to be the value of\[NonBreakingSpace]",
  StyleBox["ri", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.23"}],

Cell[CellGroupData[{

Cell["ri = a + 2", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  " is maintained in an unevaluated form, to be evaluated every time the \
value of ",
  StyleBox["rd", "MR"],
  " is requested. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.24"}],

Cell["rd := a + 2", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "In this case, ",
  StyleBox["ri", "MR"],
  " and ",
  StyleBox["rd", "MR"],
  " give the same values. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.25"}],

Cell[CellGroupData[{

Cell["{ri, rd}", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \({3, 3}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Now the value of ",
  StyleBox["a", "MR"],
  " is changed. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.26"}],

Cell[CellGroupData[{

Cell["a = 2", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["rd", "MR"],
  " uses the new value for ",
  StyleBox["a", "MR"],
  ", while ",
  StyleBox["ri", "MR"],
  " keeps its original value. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.27"}],

Cell[CellGroupData[{

Cell["{ri, rd}", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \({3, 4}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "You can use delayed assignments such as ",
  StyleBox["t", "TI"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " to set up variables whose values you can find in a variety of different \
\[OpenCurlyDoubleQuote]environments\[CloseCurlyDoubleQuote]. Every time you \
ask for ",
  StyleBox["t", "TI"],
  ", the expression ",
  StyleBox["rhs", "TI"],
  " is evaluated using the current values of the objects on which it depends. \
"
}], "Text",
  CellTags->{"S2.5.8", "8.28"}],

Cell["\<\
The right\[Hyphen]hand side of the delayed assignment is maintained \
in an unevaluated form. \
\>", "MathCaption",
  CellTags->{"S2.5.8", "8.29"}],

Cell["t := {a, Factor[x^a - 1]}", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "This sets ",
  StyleBox["a", "MR"],
  " to ",
  StyleBox["4", "MR"],
  ", then finds the value of\[NonBreakingSpace]",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.30"}],

Cell[CellGroupData[{

Cell["a = 4; t", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \({4, \((\(-1\) + x)\)\ \((1 + x)\)\ \((1 + x\^2)\)}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["a", "MR"],
  " is 6. "
}], "MathCaption",
  CellTags->{"S2.5.8", "8.31"}],

Cell[CellGroupData[{

Cell["a = 6; t", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \({6, \((\(-1\) + x)\)\ \((1 + x)\)\ \((1 - x + x\^2)\)\ \((1 + x + 
            x\^2)\)}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "In the example above, the symbol ",
  StyleBox["a", "MR"],
  " acts as a \[OpenCurlyDoubleQuote]global variable\[CloseCurlyDoubleQuote], \
whose value affects the value of ",
  StyleBox["t", "MR"],
  ". When you have a large number of parameters, many of which change only \
occasionally, you may find this kind of setup convenient. However, you should \
realize that implicit or hidden dependence of one variable on others can \
often become quite confusing. When possible, you should make all dependencies \
explicit, by defining functions which take all necessary parameters as \
arguments. "
}], "Text",
  CellTags->{"S2.5.8", "8.32"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["rhs", "TI"],
              " is evaluated when the rule is given "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["rhs", "TI"],
              " is evaluated when the rule is used "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.8"],

Cell[TextData[{
  "Two types of transformation rules in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.5.8"],

Cell[TextData[{
  "Just as you can make immediate and delayed assignments in ",
  StyleBox["Mathematica", "TI"],
  ", so you can also set up immediate and delayed transformation rules. "
}], "Text",
  CellTags->{"S2.5.8", "8.33"}],

Cell["\<\
The right\[Hyphen]hand side of this rule is evaluated when you give \
the rule. \
\>", "MathCaption",
  CellTags->{"S2.5.8", "8.34"}],

Cell[CellGroupData[{

Cell["f[x_] -> Expand[(1 + x)^2]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(f[x_] \[Rule] 1 + 2\ x + x\^2\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell["A rule like this is probably not particularly useful. ", "MathCaption",
  CellTags->{"S2.5.8", "8.35"}],

Cell[CellGroupData[{

Cell["f[x_] -> Expand[x]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(f[x_] \[Rule] x\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell["\<\
Here the right\[Hyphen]hand side of the rule is maintained in an \
unevaluated form, to be evaluated every time the rule is used. \
\>", \
"MathCaption",
  CellTags->{"S2.5.8", "8.36"}],

Cell[CellGroupData[{

Cell["f[x_] :> Expand[x]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(f[x_] \[RuleDelayed] Expand[x]\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell["Applying the rule causes the expansion to be done. ", "MathCaption",
  CellTags->{"S2.5.8", "8.37"}],

Cell[CellGroupData[{

Cell["f[(1 + p)^2] /. f[x_] :> Expand[x]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.5.8"],

Cell[BoxData[
    \(1 + 2\ p + p\^2\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.5.8"]
}, Open  ]],

Cell[TextData[{
  "In analogy with assignments, you should typically use ",
  StyleBox["->", "MR"],
  " when you want to replace an expression with a definite value, and you \
should use ",
  StyleBox[":>", "MR"],
  " when you want to give a command for finding the value. "
}], "Text",
  CellTags->{"S2.5.8", "8.38"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.9 Functions That Remember Values They Have Found", "Subsection",
  CellTags->{"S2.5.9", "9.1"}],

Cell[TextData[{
  "When you make a function definition using ",
  StyleBox[":=", "MR"],
  ", the value of the function is recomputed every time you ask for it. In \
some kinds of calculations, you may end up asking for the same function value \
many times. You can save time in these cases by having ",
  StyleBox["Mathematica", "TI"],
  " remember all the function values it finds. Here is an \
\[OpenCurlyDoubleQuote]idiom\[CloseCurlyDoubleQuote] for defining a function \
that does this. "
}], "Text",
  CellTags->{"S2.5.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["_]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["f[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[
            "define a function which remembers values that it finds"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.9"],

Cell["Defining a function that remembers values it finds. ", "Caption",
  CellTags->"S2.5.9"],

Cell[TextData[{
  "This defines a function ",
  StyleBox["f", "MR"],
  " which stores all values that it finds. "
}], "MathCaption",
  CellTags->{"S2.5.9", "9.3"}],

Cell["f[x_] := f[x] = f[x - 1] + f[x - 2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.9"],

Cell[TextData[{
  "Here are the end conditions for the recursive function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.9", "9.4"}],

Cell[CellGroupData[{

Cell["f[0] = f[1] = 1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.9"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.9"]
}, Open  ]],

Cell[TextData[{
  "Here is the original definition of ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.9", "9.5"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.9"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S2.5.9"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[0] = 1\)},
                {" "},
                {\(f[1] = 1\)},
                {" "},
                {\(f[x_] := \(f[x] = f[x - 1] + f[x - 2]\)\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.5.9"]
}, Open  ]],

Cell[TextData[{
  "This computes ",
  StyleBox["f[5]", "MR"],
  ". The computation involves finding the sequence of values ",
  StyleBox["f[5]", "MR"],
  ", ",
  StyleBox["f[4]", "MR"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\` ... \)], "InlineFormula"],
  " ",
  StyleBox["f[2]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.9", "9.6"}],

Cell[CellGroupData[{

Cell["f[5]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.9"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.9"]
}, Open  ]],

Cell[TextData[{
  "All the values of ",
  StyleBox["f", "MR"],
  " found so far are explicitly stored. "
}], "MathCaption",
  CellTags->{"S2.5.9", "9.7"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.9"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S2.5.9"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[0] = 1\)},
                {" "},
                {\(f[1] = 1\)},
                {" "},
                {\(f[2] = 2\)},
                {" "},
                {\(f[3] = 3\)},
                {" "},
                {\(f[4] = 5\)},
                {" "},
                {\(f[5] = 8\)},
                {" "},
                {\(f[x_] := \(f[x] = f[x - 1] + f[x - 2]\)\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.5.9"]
}, Open  ]],

Cell[TextData[{
  "If you ask for ",
  StyleBox["f[5]", "MR"],
  " again, ",
  StyleBox["Mathematica", "TI"],
  " can just look up the value immediately; it does not have to recompute it. \
 "
}], "MathCaption",
  CellTags->{"S2.5.9", "9.8"}],

Cell[CellGroupData[{

Cell["f[5]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.9"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.9"]
}, Open  ]],

Cell[TextData[{
  "You can see how a definition like ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["f[x]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["f[x-1]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["f[x-2]", "MR"],
  " works. The function ",
  StyleBox["f[x_]", "MR"],
  " is defined to be the \[OpenCurlyDoubleQuote]program\
\[CloseCurlyDoubleQuote] ",
  StyleBox["f[x]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["f[x-1]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["f[x-2]", "MR"],
  ". When you ask for a value of the function ",
  StyleBox["f", "MR"],
  ", the \[OpenCurlyDoubleQuote]program\[CloseCurlyDoubleQuote] is executed. \
The program first calculates the value of ",
  StyleBox["f[x-1]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["f[x-2]", "MR"],
  ", then saves the result as ",
  StyleBox["f[x]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.9", "9.9"}],

Cell[TextData[{
  "It is often a good idea to use functions that remember values when you \
implement mathematical ",
  StyleBox["recursion relations", "TI"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ". In a typical case, a recursion relation gives the value of a function ",
  Cell[BoxData[
      FormBox[
        StyleBox["f",
          "TI"], TraditionalForm]], "InlineFormula"],
  " with an integer argument ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " in terms of values of the same function with arguments ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "-", "2"}], TraditionalForm]], "InlineFormula"],
  ", etc. The Fibonacci function definition ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", "1"}], ")"}], "+", 
          StyleBox["f",
            "TI"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["x",
                "TI"], "-", "2"}], ")"}]}], TraditionalForm]], 
    "InlineFormula"],
  " used above is an example of this kind of recursion relation. The point is \
that if you calculate say ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], \((10)\)}], TraditionalForm]], "InlineFormula"],
  " by just applying the recursion relation over and over again, you end up \
having to recalculate quantities like ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], \((5)\)}], TraditionalForm]], "InlineFormula"],
  " many times. In a case like this, it is therefore better just to ",
  StyleBox["remember", "TI"],
  " the value of ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["f",
            "TI"], \((5)\)}], TraditionalForm]], "InlineFormula"],
  ", and look it up when you need it, rather than having to recalculate it. "
}], "Text",
  CellTags->{"S2.5.9", "9.10"}],

Cell["\<\
There is of course a trade\[Hyphen]off involved in remembering \
values. It is faster to find a particular value, but it takes more memory \
space to store all of them. You should usually define functions to remember \
values only if the total number of different values that will be produced is \
comparatively small, or the expense of recomputing them is very great. \
\>", \
"Text",
  CellTags->{"S2.5.9", "9.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.10 Associating Definitions with Different Symbols", "Subsection",
  CellTags->{"S2.5.10", "10.1"}],

Cell[TextData[{
  "When you make a definition in the form ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["args", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " or ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["args", "TI"],
  StyleBox["]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " associates your definition with the object ",
  StyleBox["f", "TI"],
  ". This means, for example, that such definitions are displayed when you \
type ",
  StyleBox["?", "MR"],
  StyleBox["f", "TI"],
  ". In general, definitions for expressions in which the symbol ",
  StyleBox["f", "TI"],
  " appears as the head are termed ",
  StyleBox["downvalues", "TI"],
  " of ",
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.5.10", "10.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " however also supports ",
  StyleBox["upvalues", "TI"],
  ", which allow definitions to be associated with symbols that do not appear \
directly as their head. "
}], "Text",
  CellTags->{"S2.5.10", "10.3"}],

Cell[TextData[{
  "Consider for example a definition like ",
  StyleBox["Exp[g[x_]]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ". One possibility is that this definition could be associated with the \
symbol ",
  StyleBox["Exp", "MR"],
  ", and considered as a downvalue of ",
  StyleBox["Exp", "MR"],
  ". This is however probably not the best thing either from the point of \
view of organization or efficiency. "
}], "Text",
  CellTags->{"S2.5.10", "10.4"}],

Cell[TextData[{
  "Better is to consider ",
  StyleBox["Exp[g[x_]]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " to be associated with ",
  StyleBox["g", "MR"],
  ", and to correspond to an upvalue of\[NonBreakingSpace]",
  StyleBox["g", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.10", "10.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "define a downvalue for ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox["^:=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "define an upvalue for ",
              StyleBox["g", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.10"],

Cell["Associating definitions with different symbols. ", "Caption",
  CellTags->"S2.5.10"],

Cell[TextData[{
  "This is taken to define a downvalue for\[NonBreakingSpace]",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.6"}],

Cell["f[g[x_]] := fg[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.10"],

Cell[TextData[{
  "You can see the definition when you ask about ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.7"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \("Global`f"\)], "Print",
  CellTags->"S2.5.10"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[g[x_]] := fg[x]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "This defines an upvalue for ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.8"}],

Cell["Exp[g[x_]] ^:= expg[x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.10"],

Cell[TextData[{
  "The definition is associated with ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.9"}],

Cell[CellGroupData[{

Cell["?g", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \("Global`g"\)], "Print",
  CellTags->"S2.5.10"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(\[ExponentialE]\^g[x_] ^:= expg[x]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ g],
      Editable->False]], "Print",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "It is not associated with ",
  StyleBox["Exp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.10"}],

Cell[CellGroupData[{

Cell["??Exp", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \("Exp[z] is the exponential function."\)], "Print",
  CellTags->"S2.5.10"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(Attributes[Exp] = {Listable, NumericFunction, Protected, 
                ReadProtected}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ Exp],
      Editable->False]], "Print",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell["The definition is used to evaluate this expression. ", "MathCaption",
  CellTags->{"S2.5.10", "10.11"}],

Cell[CellGroupData[{

Cell["Exp[g[5]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \(expg[5]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "In simple cases, you will get the same answers to calculations whether you \
give a definition for ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  " as a downvalue for ",
  StyleBox["f", "TI"],
  " or an upvalue for ",
  StyleBox["g", "TI"],
  ". However, one of the two choices is usually much more natural and \
efficient than the other. "
}], "Text",
  CellTags->{"S2.5.10", "10.12"}],

Cell[TextData[{
  "A good rule of thumb is that a definition for ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  " should be given as an upvalue for ",
  StyleBox["g", "TI"],
  " in cases where the function ",
  StyleBox["f", "TI"],
  " is more common than ",
  StyleBox["g", "TI"],
  ". Thus, for example, in the case of ",
  StyleBox["Exp[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  ", ",
  StyleBox["Exp", "MR"],
  " is a built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " function, while ",
  StyleBox["g", "TI"],
  " is presumably a function you have added. In such a case, you will \
typically think of definitions for ",
  StyleBox["Exp[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  " as giving relations satisfied by ",
  StyleBox["g", "TI"],
  ". As a result, it is more natural to treat the definitions as upvalues for \
",
  StyleBox["g", "TI"],
  " than as downvalues for ",
  StyleBox["Exp", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.10", "10.13"}],

Cell[TextData[{
  "This gives the definition as an upvalue for ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.14"}],

Cell["g/: g[x_] + g[y_] := gplus[x, y]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.10"],

Cell[TextData[{
  "Here are the definitions for ",
  StyleBox["g", "MR"],
  " so far. "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.15"}],

Cell[CellGroupData[{

Cell["?g", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \("Global`g"\)], "Print",
  CellTags->"S2.5.10"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(\[ExponentialE]\^g[x_] ^:= expg[x]\)},
                {" "},
                {\(g[x_] + g[y_] ^:= gplus[x, y]\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ g],
      Editable->False]], "Print",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "The definition for a sum of ",
  StyleBox["g", "MR"],
  "'s is used whenever possible. "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.16"}],

Cell[CellGroupData[{

Cell["g[5] + g[7]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \(gplus[5, 7]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "Since the full form of the pattern ",
  StyleBox["g[x_]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["g[y_]", "MR"],
  " is ",
  StyleBox["Plus[g[x_],", "MR"],
  " ",
  StyleBox["g[y_]]", "MR"],
  ", a definition for this pattern could be given as a downvalue for ",
  StyleBox["Plus", "MR"],
  ". It is almost always better, however, to give the definition as an \
upvalue for ",
  StyleBox["g", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.10", "10.17"}],

Cell[TextData[{
  "In general, whenever ",
  StyleBox["Mathematica", "TI"],
  " encounters a particular function, it tries all the definitions you have \
given for that function. If you had made the definition for ",
  StyleBox["g[x_]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["g[y_]", "MR"],
  " a downvalue for ",
  StyleBox["Plus", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " would have tried this definition whenever ",
  StyleBox["Plus", "MR"],
  " occurs. The definition would thus be tested every time ",
  StyleBox["Mathematica", "TI"],
  " added expressions together, making this very common operation slower in \
all cases. "
}], "Text",
  CellTags->{"S2.5.10", "10.18"}],

Cell[TextData[{
  "However, by giving a definition for ",
  StyleBox["g[x_]", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["g[y_]", "MR"],
  " as an upvalue for ",
  StyleBox["g", "MR"],
  ", you associate the definition with ",
  StyleBox["g", "MR"],
  ". In this case, ",
  StyleBox["Mathematica", "TI"],
  " only tries the definition when it finds a ",
  StyleBox["g", "MR"],
  " inside a function such as ",
  StyleBox["Plus", "MR"],
  ". Since ",
  StyleBox["g", "MR"],
  " presumably occurs much less frequently than ",
  StyleBox["Plus", "MR"],
  ", this is a much more efficient procedure. "
}], "Text",
  CellTags->{"S2.5.10", "10.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "make assignments to be associated with ",
              StyleBox["g", "TI"],
              ", rather than ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["^:=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["^:=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "make delayed assignments associated with ",
              StyleBox["g", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox["^=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "make assignments associated with the heads of ",
              StyleBox["all", "TI"],
              " the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.10"],

Cell["Shorter ways to define upvalues. ", "Caption",
  CellTags->"S2.5.10"],

Cell["\<\
A typical use of upvalues is in setting up a \
\[OpenCurlyDoubleQuote]database\[CloseCurlyDoubleQuote] of properties of a \
particular object. With upvalues, you can associate each definition you make \
with the object that it concerns, rather than with the property you are \
specifying. \
\>", "Text",
  CellTags->{"S2.5.10", "10.20"}],

Cell[TextData[{
  "This defines an upvalue for ",
  StyleBox["square", "MR"],
  " which gives its area. "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.21"}],

Cell[CellGroupData[{

Cell["area[square] ^= 1", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell["This adds a definition for the perimeter. ", "MathCaption",
  CellTags->{"S2.5.10", "10.22"}],

Cell[CellGroupData[{

Cell["perimeter[square] ^= 4", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "Both definitions are now associated with the object ",
  StyleBox["square", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.23"}],

Cell[CellGroupData[{

Cell["?square", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \("Global`square"\)], "Print",
  CellTags->"S2.5.10"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(area[square] ^= 1\)},
                {" "},
                {\(perimeter[square] ^= 4\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ square],
      Editable->False]], "Print",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "In general, you can associate definitions for an expression with any \
symbol that occurs at a sufficiently high level in the expression. With an \
expression of the form ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["args", "TI"],
  StyleBox["]", "MR"],
  ", you can define an upvalue for a symbol ",
  StyleBox["g", "TI"],
  " so long as either ",
  StyleBox["g", "TI"],
  " itself, or an object with head ",
  StyleBox["g", "TI"],
  ", occurs in ",
  StyleBox["args", "TI"],
  ". If ",
  StyleBox["g", "TI"],
  " occurs at a lower level in an expression, however, you cannot associate \
definitions with it. "
}], "Text",
  CellTags->{"S2.5.10", "10.24"}],

Cell[TextData[{
  StyleBox["g", "MR"],
  " occurs as the head of an argument, so you can associate a definition with \
it. "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.25"}],

Cell["g/: h[w[x_], g[y_]] := hwg[x, y]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.5.10"],

Cell[TextData[{
  "Here ",
  StyleBox["g", "MR"],
  " appears too deep in the left\[Hyphen]hand side for you to associate a \
definition with it. "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.26"}],

Cell[CellGroupData[{

Cell["g/: h[w[g[x_]], y_] := hw[x, y]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \(TagSetDelayed::"tagpos" \(\(:\)\(\ \)\) 
      "Tag \!\(g\) in \!\(h[\(\(\(\(w[\(\(g[x_]\)\)]\)\), y_\)\)]\) is too \
deep for an assigned rule to be found."\)], "Message",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "downvalue for ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]][", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "downvalue for ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["g", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "upvalue for ",
              StyleBox["g", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["g", "TI"],
              StyleBox["/:", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "upvalue for ",
              StyleBox["g", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.10"],

Cell["Possible positions for symbols in definitions. ", "Caption",
  CellTags->"S2.5.10"],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.1.2",
    ButtonData:>{"2.1.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ", you can use ",
  StyleBox["Mathematica", "TI"],
  " symbols as \[OpenCurlyDoubleQuote]tags\[CloseCurlyDoubleQuote], to \
indicate the \[OpenCurlyDoubleQuote]type\[CloseCurlyDoubleQuote] of an \
expression. For example, complex numbers in ",
  StyleBox["Mathematica", "TI"],
  " are represented internally in the form ",
  StyleBox["Complex[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", where the symbol ",
  StyleBox["Complex", "MR"],
  " serves as a tag to indicate that the object is a complex number. "
}], "Text",
  CellTags->{"S2.5.10", "10.27"}],

Cell[TextData[{
  "Upvalues provide a convenient mechanism for specifying how operations act \
on objects that are tagged to have a certain type. For example, you might \
want to introduce a class of abstract mathematical objects of type ",
  StyleBox["quat", "MR"],
  ". You can represent each object of this type by a ",
  StyleBox["Mathematica", "TI"],
  " expression of the form ",
  StyleBox["quat[", "MR"],
  StyleBox["data", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.10", "10.28"}],

Cell[TextData[{
  "In a typical case, you might want ",
  StyleBox["quat", "MR"],
  " objects to have special properties with respect to arithmetic operations \
such as addition and multiplication. You can set up such properties by \
defining upvalues for ",
  StyleBox["quat", "MR"],
  " with respect to ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.10", "10.29"}],

Cell[TextData[{
  "This defines an upvalue for ",
  StyleBox["quat", "MR"],
  " with respect to ",
  StyleBox["Plus", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.10", "10.30"}],

Cell["quat[x_] + quat[y_] ^:= quat[x + y]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.5.10"],

Cell["\<\
The upvalue you have defined is used to simplify this expression. \
\
\>", "MathCaption",
  CellTags->{"S2.5.10", "10.31"}],

Cell[CellGroupData[{

Cell["quat[a] + quat[b] + quat[c]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.5.10"],

Cell[BoxData[
    \(quat[a + b + c]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.5.10"]
}, Open  ]],

Cell[TextData[{
  "When you define an upvalue for ",
  StyleBox["quat", "MR"],
  " with respect to an operation like ",
  StyleBox["Plus", "MR"],
  ", what you are effectively doing is to extend the domain of the ",
  StyleBox["Plus", "MR"],
  " operation to include ",
  StyleBox["quat", "MR"],
  " objects. You are telling ",
  StyleBox["Mathematica", "TI"],
  " to use special rules for addition in the case where the things to be \
added together are ",
  StyleBox["quat", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S2.5.10", "10.32"}],

Cell[TextData[{
  "In defining addition for ",
  StyleBox["quat", "MR"],
  " objects, you could always have a special addition operation, say ",
  StyleBox["quatPlus", "MR"],
  ", to which you assign an appropriate downvalue. It is usually much more \
convenient, however, to use the standard ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Plus", "MR"],
  " operation to represent addition, but then to \
\[OpenCurlyDoubleQuote]overload\[CloseCurlyDoubleQuote] this operation by \
specifying special behavior when ",
  StyleBox["quat", "MR"],
  " objects are encountered. "
}], "Text",
  CellTags->{"S2.5.10", "10.33"}],

Cell[TextData[{
  "You can think of upvalues as a way to implement certain aspects of object\
\[Hyphen]oriented programming. A symbol like ",
  StyleBox["quat", "MR"],
  " represents a particular type of object. Then the various upvalues for ",
  StyleBox["quat", "MR"],
  " specify \[OpenCurlyDoubleQuote]methods\[CloseCurlyDoubleQuote] that \
define how ",
  StyleBox["quat", "MR"],
  " objects should behave under certain operations, or on receipt of certain \
\[OpenCurlyDoubleQuote]messages\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.5.10", "10.34"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.11 Defining Numerical Values", "Subsection",
  CellTags->{"S2.5.11", "11.1"}],

Cell[TextData[{
  "If you make a definition such as ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will use the value you give for any ",
  StyleBox["f", "MR"],
  " function it encounters. In some cases, however, you may want to define a \
value that is to be used specifically when you ask for numerical values. "
}], "Text",
  CellTags->{"S2.5.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["expr", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell["define a value to be used whenever possible "]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[
            "define a value to be used for numerical approximation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.11"],

Cell["Defining ordinary and numerical values. ", "Caption",
  CellTags->"S2.5.11"],

Cell[TextData[{
  "This defines a numerical value for the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.11", "11.3"}],

Cell["N[f[x_]] := Sum[x^-i/i^2, {i, 20}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.11"],

Cell[TextData[{
  "Defining the numerical value does not tell ",
  StyleBox["Mathematica", "TI"],
  " anything about the ordinary value of ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.11", "11.4"}],

Cell[CellGroupData[{

Cell["f[2] + f[5]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.11"],

Cell[BoxData[
    \(f[2] + f[5]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.11"]
}, Open  ]],

Cell[TextData[{
  "If you ask for a numerical approximation, however, ",
  StyleBox["Mathematica", "TI"],
  " uses the numerical values you have defined. "
}], "MathCaption",
  CellTags->{"S2.5.11", "11.5"}],

Cell[CellGroupData[{

Cell["N[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.11"],

Cell[BoxData[
    \(0.7932442999131621`\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.11"]
}, Open  ]],

Cell[TextData[{
  "You can define numerical values for both functions and symbols. The \
numerical values are used by all numerical ",
  StyleBox["Mathematica", "TI"],
  " functions, including ",
  StyleBox["NIntegrate", "MR"],
  ", ",
  StyleBox["FindRoot", "MR"],
  " and so on. "
}], "Text",
  CellTags->{"S2.5.11", "11.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], 
            Cell["\<\
define a numerical value to be used when default \
numerical precision is requested \
\>"]},
          {Cell[TextData[{
              StyleBox["N[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Infinity}]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "define a numerical value to be used when ",
              StyleBox["n", "TI"],
              "\[Hyphen]digit precision and any accuracy is requested "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.11"],

Cell["\<\
Defining numerical values that depend on numerical precision. \
\
\>", "Caption",
  CellTags->"S2.5.11"],

Cell[TextData[{
  "This defines a numerical value for the symbol ",
  StyleBox["const", "MR"],
  ", using ",
  StyleBox["4n", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["5", "MR"],
  " terms in the product for ",
  StyleBox["n", "MR"],
  "\[Hyphen]digit precision. "
}], "MathCaption",
  CellTags->{"S2.5.11", "11.7"}],

Cell["\<\
N[const, {n_, Infinity}] := Product[1 - 2^-i, {i, 2, 4n + 5}]\
\>", \
"Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.11"],

Cell[TextData[{
  "Here is the value of ",
  StyleBox["const", "MR"],
  ", computed to 30\[Hyphen]digit precision using the value you specified. "
}], "MathCaption",
  CellTags->{"S2.5.11", "11.8"}],

Cell[CellGroupData[{

Cell["N[const, 30]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.11"],

Cell[BoxData[
    \(0.577576190173204842557799443858461560191402560656`30. \)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.5.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats numerical values essentially like upvalues. When you define a \
numerical value for ",
  StyleBox["f", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " effectively enters your definition as an upvalue for ",
  StyleBox["f", "TI"],
  " with respect to the numerical evaluation operation ",
  StyleBox["N", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.11", "11.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.5.12 Modifying Built\[Hyphen]in Functions\
\>", "Subsection",
  CellTags->{"S2.5.12", "12.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to define transformation rules for any expression. You can \
define such rules not only for functions that you add to ",
  StyleBox["Mathematica", "TI"],
  ", but also for intrinsic functions that are already built into ",
  StyleBox["Mathematica", "TI"],
  ". As a result, you can enhance, or modify, the features of \
built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions. "
}], "Text",
  CellTags->{"S2.5.12", "12.2"}],

Cell[TextData[{
  "This capability is powerful, but potentially dangerous. ",
  StyleBox["Mathematica", "TI"],
  " will always follow the rules you give it. This means that if the rules \
you give are incorrect, then ",
  StyleBox["Mathematica", "TI"],
  " will give you incorrect answers. "
}], "Text",
  CellTags->{"S2.5.12", "12.3"}],

Cell[TextData[{
  "To avoid the possibility of changing built\[Hyphen]in functions by \
mistake, ",
  StyleBox["Mathematica", "TI"],
  " \[OpenCurlyDoubleQuote]protects\[CloseCurlyDoubleQuote] all \
built\[Hyphen]in functions from redefinition. If you want to give a \
definition for a built\[Hyphen]in function, you have to remove the protection \
first. After you give the definition, you should usually restore the \
protection, to prevent future mistakes. "
}], "Text",
  CellTags->{"S2.5.12", "12.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Unprotect[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["remove protection "]},
          {Cell[TextData[{
              StyleBox["Protect[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["add protection "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.12"],

Cell["Protection for functions. ", "Caption",
  CellTags->"S2.5.12"],

Cell["\<\
Built\[Hyphen]in functions are usually \
\[OpenCurlyDoubleQuote]protected\[CloseCurlyDoubleQuote], so you cannot \
redefine them. \
\>", "MathCaption",
  CellTags->{"S2.5.12", "12.5"}],

Cell[CellGroupData[{

Cell["Log[7] = 2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \(Set::"write" \(\(:\)\(\ \)\) 
      "Tag \!\(Log\) in \!\(Log[7]\) is Protected."\)], "Message",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.5.12"]
}, Open  ]],

Cell[TextData[{
  "This removes protection for ",
  StyleBox["Log", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.6"}],

Cell[CellGroupData[{

Cell["Unprotect[Log]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \({"Log"}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.12"]
}, Open  ]],

Cell[TextData[{
  "Now you can give your own definitions for ",
  StyleBox["Log", "MR"],
  ". This particular definition is not mathematically correct, but ",
  StyleBox["Mathematica", "TI"],
  " will still allow you to give it.  "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.7"}],

Cell[CellGroupData[{

Cell["Log[7] = 2", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.5.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will use your definitions whenever it can, whether they are \
mathematically correct or not. "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.8"}],

Cell[CellGroupData[{

Cell["Log[7] + Log[3]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \(2 + Log[3]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.12"]
}, Open  ]],

Cell[TextData[{
  "This removes the incorrect definition for ",
  StyleBox["Log", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.9"}],

Cell["Log[7] =.", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.12"],

Cell[TextData[{
  "This restores the protection for ",
  StyleBox["Log", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.10"}],

Cell[CellGroupData[{

Cell["Protect[Log]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \({"Log"}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.5.12"]
}, Open  ]],

Cell[TextData[{
  "Definitions you give can override built\[Hyphen]in features of ",
  StyleBox["Mathematica", "TI"],
  ". In general, ",
  StyleBox["Mathematica", "TI"],
  " tries to use your definitions before it uses built\[Hyphen]in \
definitions. "
}], "Text",
  CellTags->{"S2.5.12", "12.11"}],

Cell[TextData[{
  "The rules that are built into ",
  StyleBox["Mathematica", "TI"],
  " are intended to be appropriate for the broadest range of calculations. In \
specific cases, however, you may not like what the built\[Hyphen]in rules do. \
In such cases, you can give your own rules to override the ones that are \
built in. "
}], "Text",
  CellTags->{"S2.5.12", "12.12"}],

Cell[TextData[{
  "There is a built\[Hyphen]in rule for simplifying ",
  StyleBox["Exp[Log[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.13"}],

Cell[CellGroupData[{

Cell["Exp[Log[y]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \(y\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.5.12"]
}, Open  ]],

Cell[TextData[{
  "You can give your own rule for ",
  StyleBox["Exp[Log[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]]", "MR"],
  ", overriding the built\[Hyphen]in rule. "
}], "MathCaption",
  CellTags->{"S2.5.12", "12.14"}],

Cell["\<\
( Unprotect[Exp] ; Exp[Log[expr_]] := explog[expr] ; Protect[Exp] ; \
)\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.5.12"],

Cell["\<\
Now your rule is used, rather than the built\[Hyphen]in one. \
\>", \
"MathCaption",
  CellTags->{"S2.5.12", "12.15"}],

Cell[CellGroupData[{

Cell["Exp[Log[y]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.5.12"],

Cell[BoxData[
    \(explog[y]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.5.12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.5.13 Advanced Topic: Manipulating Value Lists", "Subsection",
  CellTags->{"S2.5.13", "13.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DownValues[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the list of downvalues of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["UpValues[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the list of upvalues of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DownValues[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rules", "TI"],
              " "
            }]], Cell[TextData[{
              "set the downvalues of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["UpValues[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rules", "TI"],
              " "
            }]], Cell[TextData[{
              "set the upvalues of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.5.13"],

Cell["Finding and setting values of symbols. ", "Caption",
  CellTags->"S2.5.13"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " effectively stores all definitions you give as lists of transformation \
rules. When a particular symbol is encountered, the lists of rules associated \
with it are tried. "
}], "Text",
  CellTags->{"S2.5.13", "13.2"}],

Cell[TextData[{
  "Under most circumstances, you do not need direct access to the actual \
transformation rules associated with definitions you have given. Instead, you \
can simply use ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " and ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["=.", "MR"],
  " to add and remove rules. In some cases, however, you may find it useful \
to have direct access to the actual rules. "
}], "Text",
  CellTags->{"S2.5.13", "13.3"}],

Cell[TextData[{
  "Here is a definition for ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.13", "13.4"}],

Cell["f[x_] := x^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.5.13"],

Cell[TextData[{
  "This gives the explicit rule corresponding to the definition you made for \
",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.13", "13.5"}],

Cell[CellGroupData[{

Cell["DownValues[f]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.5.13"],

Cell[BoxData[
    \({HoldPattern[f[x_]] \[RuleDelayed] x\^2}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.5.13"]
}, Open  ]],

Cell[TextData[{
  "Notice that the rules returned by ",
  StyleBox["DownValues", "MR"],
  " and ",
  StyleBox["UpValues", "MR"],
  " are set up so that neither their left\[Hyphen] nor right\[Hyphen]hand \
sides get evaluated. The left\[Hyphen]hand sides are wrapped in ",
  StyleBox["HoldPattern", "MR"],
  ", and the rules are delayed, so that the right\[Hyphen]hand sides are not \
immediately evaluated. "
}], "Text",
  CellTags->{"S2.5.13", "13.6"}],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.5.6",
    ButtonData:>{"2.5.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " tries to order definitions so that more specific ones appear before more \
general ones. In general, however, there is no unique way to make this \
ordering, and you may want to choose a different ordering from the one that \
",
  StyleBox["Mathematica", "TI"],
  " chooses by default. You can do this by reordering the list of rules \
obtained from ",
  StyleBox["DownValues", "MR"],
  " or ",
  StyleBox["UpValues", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.5.13", "13.7"}],

Cell[TextData[{
  "Here are some definitions for the object\[NonBreakingSpace]",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.13", "13.8"}],

Cell["g[x_ + y_] := gp[x, y] ; g[x_ y_] := gm[x, y]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.5.13"],

Cell["This shows the default ordering used for the definitions. ", \
"MathCaption",
  CellTags->{"S2.5.13", "13.9"}],

Cell[CellGroupData[{

Cell["DownValues[g]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.5.13"],

Cell[BoxData[
    \({HoldPattern[g[x_ + y_]] \[RuleDelayed] gp[x, y], 
      HoldPattern[g[x_\ y_]] \[RuleDelayed] gm[x, y]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.5.13"]
}, Open  ]],

Cell[TextData[{
  "This reverses the order of the definitions for ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.5.13", "13.10"}],

Cell[CellGroupData[{

Cell["DownValues[g] = Reverse[DownValues[g]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.5.13"],

Cell[BoxData[
    \({HoldPattern[g[x_\ y_]] \[RuleDelayed] gm[x, y], 
      HoldPattern[g[x_ + y_]] \[RuleDelayed] gp[x, y]}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.5.13"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{200, Automatic}, {Automatic, 59}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.5.0"->{
    Cell[1776, 53, 139, 4, 65, "Section",
      CellTags->{"S2.5.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 139, 4, 65, "Section",
      CellTags->{"S2.5.0", "0.1"}]},
  "S2.5.1"->{
    Cell[1940, 61, 88, 1, 70, "Subsection",
      CellTags->{"S2.5.1", "1.1"}],
    Cell[2031, 64, 2165, 67, 70, "DefinitionBox",
      CellTags->"S2.5.1"],
    Cell[4199, 133, 72, 1, 70, "Caption",
      CellTags->"S2.5.1"],
    Cell[4274, 136, 236, 6, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.2"}],
    Cell[4535, 146, 79, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[4617, 150, 86, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[4718, 156, 164, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.3"}],
    Cell[4907, 164, 89, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[4999, 168, 86, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[5100, 174, 1459, 43, 70, "DefinitionBox",
      CellTags->"S2.5.1"],
    Cell[6562, 219, 81, 1, 70, "Caption",
      CellTags->"S2.5.1"],
    Cell[6646, 222, 129, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.4"}],
    Cell[6800, 230, 109, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[6912, 234, 87, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[7014, 240, 241, 8, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.5"}],
    Cell[7280, 252, 97, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[7380, 256, 131, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[7526, 262, 155, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.6"}],
    Cell[7706, 270, 76, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[7785, 274, 92, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[7892, 280, 357, 12, 70, "Text",
      CellTags->{"S2.5.1", "1.7"}],
    Cell[8252, 294, 208, 7, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.8"}],
    Cell[8485, 305, 107, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[8595, 309, 96, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[8706, 315, 203, 6, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.9"}],
    Cell[8934, 325, 91, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[9028, 329, 98, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[9141, 335, 254, 11, 70, "Text",
      CellTags->{"S2.5.1", "1.10"}],
    Cell[9398, 348, 192, 7, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.11"}],
    Cell[9615, 359, 94, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[9712, 363, 93, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[9820, 369, 139, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.12"}],
    Cell[9984, 377, 93, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[10080, 381, 95, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[10190, 387, 508, 18, 70, "Text",
      CellTags->{"S2.5.1", "1.13"}],
    Cell[10701, 407, 850, 27, 70, "DefinitionBox",
      CellTags->"S2.5.1"],
    Cell[11554, 436, 79, 1, 70, "Caption",
      CellTags->"S2.5.1"],
    Cell[11636, 439, 200, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.14"}],
    Cell[11861, 448, 98, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[11962, 452, 103, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[12080, 458, 213, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.15"}],
    Cell[12318, 467, 99, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[12420, 471, 91, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[12526, 477, 91, 1, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.16"}],
    Cell[12642, 482, 110, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[12755, 486, 103, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[12873, 492, 173, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.17"}],
    Cell[13071, 500, 111, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[13185, 504, 115, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[13315, 510, 401, 10, 70, "Text",
      CellTags->{"S2.5.1", "1.18"}],
    Cell[13719, 522, 810, 26, 70, "Text",
      CellTags->{"S2.5.1", "1.19"}],
    Cell[14532, 550, 246, 7, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.20"}],
    Cell[14803, 561, 118, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[14924, 565, 154, 3, 70, "Message",
      CellTags->"S2.5.1"],
    Cell[15081, 570, 90, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[15186, 576, 503, 17, 70, "Text",
      CellTags->{"S2.5.1", "1.21"}],
    Cell[15692, 595, 588, 20, 70, "Text",
      CellTags->{"S2.5.1", "1.22"}],
    Cell[16283, 617, 163, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.23"}],
    Cell[16471, 626, 78, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[16552, 630, 86, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[16653, 636, 182, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.24"}],
    Cell[16860, 645, 87, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[16950, 649, 83, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[17048, 655, 84, 1, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.25"}],
    Cell[17157, 660, 85, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[17245, 664, 86, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[17346, 670, 154, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.26"}],
    Cell[17525, 679, 88, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[17616, 683, 86, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[17717, 689, 1547, 49, 70, "DefinitionBox",
      CellTags->"S2.5.1"],
    Cell[19267, 740, 78, 1, 70, "Caption",
      CellTags->"S2.5.1"],
    Cell[19348, 743, 160, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.27"}],
    Cell[19533, 751, 108, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[19644, 755, 86, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[19745, 761, 163, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.28"}],
    Cell[19933, 769, 112, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[20048, 773, 94, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[20157, 779, 193, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.29"}],
    Cell[20375, 788, 107, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[20485, 792, 167, 4, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[20667, 799, 129, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.30"}],
    Cell[20821, 807, 117, 2, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[20941, 811, 139, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[21095, 817, 127, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.31"}],
    Cell[21247, 825, 147, 5, 70, "Input",
      CellTags->"S2.5.1"],
    Cell[21397, 832, 124, 3, 70, "Output",
      CellTags->"S2.5.1"],
    Cell[21536, 838, 1015, 32, 70, "DefinitionBox",
      CellTags->"S2.5.1"],
    Cell[22554, 872, 89, 1, 70, "Caption",
      CellTags->"S2.5.1"]},
  "1.1"->{
    Cell[1940, 61, 88, 1, 70, "Subsection",
      CellTags->{"S2.5.1", "1.1"}]},
  "1.2"->{
    Cell[4274, 136, 236, 6, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.2"}]},
  "1.3"->{
    Cell[4718, 156, 164, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.3"}]},
  "1.4"->{
    Cell[6646, 222, 129, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.4"}]},
  "1.5"->{
    Cell[7014, 240, 241, 8, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.5"}]},
  "1.6"->{
    Cell[7526, 262, 155, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.6"}]},
  "1.7"->{
    Cell[7892, 280, 357, 12, 70, "Text",
      CellTags->{"S2.5.1", "1.7"}]},
  "1.8"->{
    Cell[8252, 294, 208, 7, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.8"}]},
  "1.9"->{
    Cell[8706, 315, 203, 6, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.9"}]},
  "1.10"->{
    Cell[9141, 335, 254, 11, 70, "Text",
      CellTags->{"S2.5.1", "1.10"}]},
  "1.11"->{
    Cell[9398, 348, 192, 7, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.11"}]},
  "1.12"->{
    Cell[9820, 369, 139, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.12"}]},
  "1.13"->{
    Cell[10190, 387, 508, 18, 70, "Text",
      CellTags->{"S2.5.1", "1.13"}]},
  "1.14"->{
    Cell[11636, 439, 200, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.14"}]},
  "1.15"->{
    Cell[12080, 458, 213, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.15"}]},
  "1.16"->{
    Cell[12526, 477, 91, 1, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.16"}]},
  "1.17"->{
    Cell[12873, 492, 173, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.17"}]},
  "1.18"->{
    Cell[13315, 510, 401, 10, 70, "Text",
      CellTags->{"S2.5.1", "1.18"}]},
  "1.19"->{
    Cell[13719, 522, 810, 26, 70, "Text",
      CellTags->{"S2.5.1", "1.19"}]},
  "1.20"->{
    Cell[14532, 550, 246, 7, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.20"}]},
  "1.21"->{
    Cell[15186, 576, 503, 17, 70, "Text",
      CellTags->{"S2.5.1", "1.21"}]},
  "1.22"->{
    Cell[15692, 595, 588, 20, 70, "Text",
      CellTags->{"S2.5.1", "1.22"}]},
  "1.23"->{
    Cell[16283, 617, 163, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.23"}]},
  "1.24"->{
    Cell[16653, 636, 182, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.24"}]},
  "1.25"->{
    Cell[17048, 655, 84, 1, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.25"}]},
  "1.26"->{
    Cell[17346, 670, 154, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.26"}]},
  "1.27"->{
    Cell[19348, 743, 160, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.27"}]},
  "1.28"->{
    Cell[19745, 761, 163, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.28"}]},
  "1.29"->{
    Cell[20157, 779, 193, 5, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.29"}]},
  "1.30"->{
    Cell[20667, 799, 129, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.30"}]},
  "1.31"->{
    Cell[21095, 817, 127, 4, 70, "MathCaption",
      CellTags->{"S2.5.1", "1.31"}]},
  "S2.5.2"->{
    Cell[22680, 878, 100, 1, 70, "Subsection",
      CellTags->{"S2.5.2", "2.1"}],
    Cell[22783, 881, 252, 6, 70, "Text",
      CellTags->{"S2.5.2", "2.2"}],
    Cell[23038, 889, 211, 5, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.3"}],
    Cell[23274, 898, 101, 2, 70, "Input",
      CellTags->"S2.5.2"],
    Cell[23378, 902, 117, 3, 70, "Output",
      CellTags->"S2.5.2"],
    Cell[23510, 908, 149, 4, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.4"}],
    Cell[23684, 916, 90, 2, 70, "Input",
      CellTags->"S2.5.2"],
    Cell[23777, 920, 124, 3, 70, "Output",
      CellTags->"S2.5.2"],
    Cell[23916, 926, 272, 6, 70, "Text",
      CellTags->{"S2.5.2", "2.5"}],
    Cell[24191, 934, 341, 7, 70, "Text",
      CellTags->{"S2.5.2", "2.6"}],
    Cell[24535, 943, 598, 13, 70, "Text",
      CellTags->{"S2.5.2", "2.7"}],
    Cell[25136, 958, 109, 1, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.8"}],
    Cell[25270, 963, 96, 2, 70, "Input",
      CellTags->"S2.5.2"],
    Cell[25369, 967, 171, 4, 70, "Output",
      CellTags->"S2.5.2"],
    Cell[25555, 974, 128, 4, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.9"}],
    Cell[25708, 982, 86, 2, 70, "Input",
      CellTags->"S2.5.2"],
    Cell[25797, 986, 579, 16, 70, "Output",
      CellTags->"S2.5.2"],
    Cell[26391, 1005, 146, 5, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.10"}],
    Cell[26562, 1014, 77, 2, 70, "Input",
      CellTags->"S2.5.2"],
    Cell[26642, 1018, 83, 3, 70, "Output",
      CellTags->"S2.5.2"],
    Cell[26740, 1024, 756, 24, 70, "DefinitionBox",
      CellTags->"S2.5.2"],
    Cell[27499, 1050, 77, 1, 70, "Caption",
      CellTags->"S2.5.2"],
    Cell[27579, 1053, 641, 12, 70, "Text",
      CellTags->{"S2.5.2", "2.11"}]},
  "2.1"->{
    Cell[22680, 878, 100, 1, 70, "Subsection",
      CellTags->{"S2.5.2", "2.1"}]},
  "2.2"->{
    Cell[22783, 881, 252, 6, 70, "Text",
      CellTags->{"S2.5.2", "2.2"}]},
  "2.3"->{
    Cell[23038, 889, 211, 5, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.3"}]},
  "2.4"->{
    Cell[23510, 908, 149, 4, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.4"}]},
  "2.5"->{
    Cell[23916, 926, 272, 6, 70, "Text",
      CellTags->{"S2.5.2", "2.5"}]},
  "2.6"->{
    Cell[24191, 934, 341, 7, 70, "Text",
      CellTags->{"S2.5.2", "2.6"}]},
  "2.7"->{
    Cell[24535, 943, 598, 13, 70, "Text",
      CellTags->{"S2.5.2", "2.7"}]},
  "2.8"->{
    Cell[25136, 958, 109, 1, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.8"}]},
  "2.9"->{
    Cell[25555, 974, 128, 4, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.9"}]},
  "2.10"->{
    Cell[26391, 1005, 146, 5, 70, "MathCaption",
      CellTags->{"S2.5.2", "2.10"}]},
  "2.11"->{
    Cell[27579, 1053, 641, 12, 70, "Text",
      CellTags->{"S2.5.2", "2.11"}]},
  "S2.5.3"->{
    Cell[28257, 1070, 77, 1, 70, "Subsection",
      CellTags->{"S2.5.3", "3.1"}],
    Cell[28337, 1073, 285, 7, 70, "Text",
      CellTags->{"S2.5.3", "3.2"}],
    Cell[28625, 1082, 296, 6, 70, "Text",
      CellTags->{"S2.5.3", "3.3"}],
    Cell[28924, 1090, 926, 31, 70, "DefinitionBox",
      CellTags->"S2.5.3"],
    Cell[29853, 1123, 99, 1, 70, "Caption",
      CellTags->"S2.5.3"],
    Cell[29955, 1126, 165, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.4"}],
    Cell[30145, 1135, 87, 2, 70, "Input",
      CellTags->"S2.5.3"],
    Cell[30235, 1139, 95, 3, 70, "Output",
      CellTags->"S2.5.3"],
    Cell[30345, 1145, 258, 9, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.5"}],
    Cell[30628, 1158, 73, 2, 70, "Input",
      CellTags->"S2.5.3"],
    Cell[30704, 1162, 86, 3, 70, "Output",
      CellTags->"S2.5.3"],
    Cell[30805, 1168, 134, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.6"}],
    Cell[30964, 1177, 73, 2, 70, "Input",
      CellTags->"S2.5.3"],
    Cell[31040, 1181, 95, 3, 70, "Output",
      CellTags->"S2.5.3"],
    Cell[31150, 1187, 419, 12, 70, "Text",
      CellTags->{"S2.5.3", "3.7"}],
    Cell[31572, 1201, 439, 10, 70, "Text",
      CellTags->{"S2.5.3", "3.8"}],
    Cell[32014, 1213, 502, 12, 70, "Text",
      CellTags->{"S2.5.3", "3.9"}],
    Cell[32519, 1227, 625, 19, 70, "Text",
      CellTags->{"S2.5.3", "3.10"}],
    Cell[33147, 1248, 676, 15, 70, "Text",
      CellTags->{"S2.5.3", "3.11"}],
    Cell[33826, 1265, 1098, 37, 70, "DefinitionBox",
      CellTags->"S2.5.3"],
    Cell[34927, 1304, 63, 1, 70, "Caption",
      CellTags->"S2.5.3"],
    Cell[34993, 1307, 194, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.12"}],
    Cell[35212, 1316, 81, 2, 70, "Input",
      CellTags->"S2.5.3"],
    Cell[35296, 1320, 115, 3, 70, "Output",
      CellTags->"S2.5.3"],
    Cell[35426, 1326, 137, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.13"}],
    Cell[35566, 1333, 72, 2, 70, "Input",
      CellTags->"S2.5.3"],
    Cell[35641, 1337, 93, 1, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.14"}],
    Cell[35759, 1342, 81, 2, 70, "Input",
      CellTags->"S2.5.3"],
    Cell[35843, 1346, 110, 3, 70, "Output",
      CellTags->"S2.5.3"]},
  "3.1"->{
    Cell[28257, 1070, 77, 1, 70, "Subsection",
      CellTags->{"S2.5.3", "3.1"}]},
  "3.2"->{
    Cell[28337, 1073, 285, 7, 70, "Text",
      CellTags->{"S2.5.3", "3.2"}]},
  "3.3"->{
    Cell[28625, 1082, 296, 6, 70, "Text",
      CellTags->{"S2.5.3", "3.3"}]},
  "3.4"->{
    Cell[29955, 1126, 165, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.4"}]},
  "3.5"->{
    Cell[30345, 1145, 258, 9, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.5"}]},
  "3.6"->{
    Cell[30805, 1168, 134, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.6"}]},
  "3.7"->{
    Cell[31150, 1187, 419, 12, 70, "Text",
      CellTags->{"S2.5.3", "3.7"}]},
  "3.8"->{
    Cell[31572, 1201, 439, 10, 70, "Text",
      CellTags->{"S2.5.3", "3.8"}]},
  "3.9"->{
    Cell[32014, 1213, 502, 12, 70, "Text",
      CellTags->{"S2.5.3", "3.9"}]},
  "3.10"->{
    Cell[32519, 1227, 625, 19, 70, "Text",
      CellTags->{"S2.5.3", "3.10"}]},
  "3.11"->{
    Cell[33147, 1248, 676, 15, 70, "Text",
      CellTags->{"S2.5.3", "3.11"}]},
  "3.12"->{
    Cell[34993, 1307, 194, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.12"}]},
  "3.13"->{
    Cell[35426, 1326, 137, 5, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.13"}]},
  "3.14"->{
    Cell[35641, 1337, 93, 1, 70, "MathCaption",
      CellTags->{"S2.5.3", "3.14"}]},
  "S2.5.4"->{
    Cell[36002, 1355, 86, 1, 70, "Subsection",
      CellTags->{"S2.5.4", "4.1"}],
    Cell[36091, 1358, 586, 16, 70, "Text",
      CellTags->{"S2.5.4", "4.2"}],
    Cell[36680, 1376, 2810, 100, 70, "DefinitionBox",
      CellTags->"S2.5.4"],
    Cell[39493, 1478, 72, 1, 70, "Caption",
      CellTags->"S2.5.4"],
    Cell[39568, 1481, 171, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.3"}],
    Cell[39764, 1492, 70, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[39837, 1496, 85, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[39937, 1502, 165, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.4"}],
    Cell[40127, 1513, 72, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[40202, 1517, 86, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[40303, 1523, 132, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.5"}],
    Cell[40460, 1532, 65, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[40528, 1536, 86, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[40629, 1542, 278, 11, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.6"}],
    Cell[40932, 1557, 80, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[41015, 1561, 83, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[41113, 1567, 219, 9, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.7"}],
    Cell[41357, 1580, 89, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[41449, 1584, 56, 2, 70, "Print",
      CellTags->"S2.5.4"],
    Cell[41508, 1588, 56, 2, 70, "Print",
      CellTags->"S2.5.4"],
    Cell[41579, 1593, 210, 9, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.8"}],
    Cell[41814, 1606, 89, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[41906, 1610, 56, 2, 70, "Print",
      CellTags->"S2.5.4"],
    Cell[41965, 1614, 56, 2, 70, "Print",
      CellTags->"S2.5.4"],
    Cell[42036, 1619, 2475, 80, 70, "DefinitionBox",
      CellTags->"S2.5.4"],
    Cell[44514, 1701, 90, 1, 70, "Caption",
      CellTags->"S2.5.4"],
    Cell[44607, 1704, 242, 11, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.9"}],
    Cell[44874, 1719, 79, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[44956, 1723, 87, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[45058, 1729, 186, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.10"}],
    Cell[45269, 1740, 79, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[45351, 1744, 87, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[45453, 1750, 146, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.11"}],
    Cell[45624, 1761, 65, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[45692, 1765, 82, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[45789, 1771, 146, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.12"}],
    Cell[45960, 1782, 66, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[46029, 1786, 83, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[46127, 1792, 141, 4, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.13"}],
    Cell[46293, 1800, 120, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[46416, 1804, 91, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[46522, 1810, 341, 10, 70, "Text",
      CellTags->{"S2.5.4", "4.14"}],
    Cell[46866, 1822, 1545, 51, 70, "DefinitionBox",
      CellTags->"S2.5.4"],
    Cell[48414, 1875, 74, 1, 70, "Caption",
      CellTags->"S2.5.4"],
    Cell[48491, 1878, 237, 11, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.15"}],
    Cell[48753, 1893, 78, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[48834, 1897, 91, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[48940, 1903, 174, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.16"}],
    Cell[49139, 1914, 80, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[49222, 1918, 95, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[49332, 1924, 137, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.17"}],
    Cell[49494, 1933, 66, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[49563, 1937, 95, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[49673, 1943, 889, 29, 70, "Text",
      CellTags->{"S2.5.4", "4.18"}],
    Cell[50565, 1974, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.19"}],
    Cell[50751, 1983, 106, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[50860, 1987, 106, 3, 70, "Output",
      CellTags->"S2.5.4"],
    Cell[50981, 1993, 145, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.20"}],
    Cell[51151, 2002, 75, 2, 70, "Input",
      CellTags->"S2.5.4"],
    Cell[51229, 2006, 98, 3, 70, "Output",
      CellTags->"S2.5.4"]},
  "4.1"->{
    Cell[36002, 1355, 86, 1, 70, "Subsection",
      CellTags->{"S2.5.4", "4.1"}]},
  "4.2"->{
    Cell[36091, 1358, 586, 16, 70, "Text",
      CellTags->{"S2.5.4", "4.2"}]},
  "4.3"->{
    Cell[39568, 1481, 171, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.3"}]},
  "4.4"->{
    Cell[39937, 1502, 165, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.4"}]},
  "4.5"->{
    Cell[40303, 1523, 132, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.5"}]},
  "4.6"->{
    Cell[40629, 1542, 278, 11, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.6"}]},
  "4.7"->{
    Cell[41113, 1567, 219, 9, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.7"}]},
  "4.8"->{
    Cell[41579, 1593, 210, 9, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.8"}]},
  "4.9"->{
    Cell[44607, 1704, 242, 11, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.9"}]},
  "4.10"->{
    Cell[45058, 1729, 186, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.10"}]},
  "4.11"->{
    Cell[45453, 1750, 146, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.11"}]},
  "4.12"->{
    Cell[45789, 1771, 146, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.12"}]},
  "4.13"->{
    Cell[46127, 1792, 141, 4, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.13"}]},
  "4.14"->{
    Cell[46522, 1810, 341, 10, 70, "Text",
      CellTags->{"S2.5.4", "4.14"}]},
  "4.15"->{
    Cell[48491, 1878, 237, 11, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.15"}]},
  "4.16"->{
    Cell[48940, 1903, 174, 7, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.16"}]},
  "4.17"->{
    Cell[49332, 1924, 137, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.17"}]},
  "4.18"->{
    Cell[49673, 1943, 889, 29, 70, "Text",
      CellTags->{"S2.5.4", "4.18"}]},
  "4.19"->{
    Cell[50565, 1974, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.19"}]},
  "4.20"->{
    Cell[50981, 1993, 145, 5, 70, "MathCaption",
      CellTags->{"S2.5.4", "4.20"}]},
  "S2.5.5"->{
    Cell[51376, 2015, 97, 1, 70, "Subsection",
      CellTags->{"S2.5.5", "5.1"}],
    Cell[51476, 2018, 1107, 41, 70, "Text",
      CellTags->{"S2.5.5", "5.2"}],
    Cell[52586, 2061, 356, 10, 70, "Text",
      CellTags->{"S2.5.5", "5.3"}],
    Cell[52945, 2073, 129, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.4"}],
    Cell[53099, 2082, 72, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[53174, 2086, 82, 3, 70, "Output",
      CellTags->"S2.5.5"],
    Cell[53271, 2092, 129, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.5"}],
    Cell[53425, 2101, 72, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[53500, 2105, 82, 3, 70, "Output",
      CellTags->"S2.5.5"],
    Cell[53597, 2111, 185, 6, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.6"}],
    Cell[53807, 2121, 66, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[53876, 2125, 65, 2, 70, "Print",
      CellTags->"S2.5.5"],
    Cell[53944, 2129, 463, 15, 70, "Print",
      CellTags->"S2.5.5"],
    Cell[54422, 2147, 247, 9, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.7"}],
    Cell[54694, 2160, 72, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[54769, 2164, 82, 3, 70, "Output",
      CellTags->"S2.5.5"],
    Cell[54866, 2170, 191, 7, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.8"}],
    Cell[55082, 2181, 83, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[55168, 2185, 102, 3, 70, "Output",
      CellTags->"S2.5.5"],
    Cell[55285, 2191, 319, 8, 70, "Text",
      CellTags->{"S2.5.5", "5.9"}],
    Cell[55607, 2201, 2192, 68, 70, "DefinitionBox",
      CellTags->"S2.5.5"],
    Cell[57802, 2271, 73, 1, 70, "Caption",
      CellTags->"S2.5.5"],
    Cell[57878, 2274, 561, 16, 70, "Text",
      CellTags->{"S2.5.5", "5.10"}],
    Cell[58442, 2292, 313, 9, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.11"}],
    Cell[58780, 2305, 80, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[58863, 2309, 82, 3, 70, "Output",
      CellTags->"S2.5.5"],
    Cell[58960, 2315, 193, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.12"}],
    Cell[59178, 2324, 84, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[59265, 2328, 85, 3, 70, "Output",
      CellTags->"S2.5.5"],
    Cell[59365, 2334, 149, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.13"}],
    Cell[59539, 2343, 69, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[59611, 2347, 68, 2, 70, "Print",
      CellTags->"S2.5.5"],
    Cell[59682, 2351, 487, 15, 70, "Print",
      CellTags->"S2.5.5"],
    Cell[60184, 2369, 204, 6, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.14"}],
    Cell[60413, 2379, 95, 2, 70, "Input",
      CellTags->"S2.5.5"],
    Cell[60511, 2383, 99, 3, 70, "Output",
      CellTags->"S2.5.5"]},
  "5.1"->{
    Cell[51376, 2015, 97, 1, 70, "Subsection",
      CellTags->{"S2.5.5", "5.1"}]},
  "5.2"->{
    Cell[51476, 2018, 1107, 41, 70, "Text",
      CellTags->{"S2.5.5", "5.2"}]},
  "5.3"->{
    Cell[52586, 2061, 356, 10, 70, "Text",
      CellTags->{"S2.5.5", "5.3"}]},
  "5.4"->{
    Cell[52945, 2073, 129, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.4"}]},
  "5.5"->{
    Cell[53271, 2092, 129, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.5"}]},
  "5.6"->{
    Cell[53597, 2111, 185, 6, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.6"}]},
  "5.7"->{
    Cell[54422, 2147, 247, 9, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.7"}]},
  "5.8"->{
    Cell[54866, 2170, 191, 7, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.8"}]},
  "5.9"->{
    Cell[55285, 2191, 319, 8, 70, "Text",
      CellTags->{"S2.5.5", "5.9"}]},
  "5.10"->{
    Cell[57878, 2274, 561, 16, 70, "Text",
      CellTags->{"S2.5.5", "5.10"}]},
  "5.11"->{
    Cell[58442, 2292, 313, 9, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.11"}]},
  "5.12"->{
    Cell[58960, 2315, 193, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.12"}]},
  "5.13"->{
    Cell[59365, 2334, 149, 5, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.13"}]},
  "5.14"->{
    Cell[60184, 2369, 204, 6, 70, "MathCaption",
      CellTags->{"S2.5.5", "5.14"}]},
  "S2.5.6"->{
    Cell[60659, 2392, 91, 1, 70, "Subsection",
      CellTags->{"S2.5.6", "6.1"}],
    Cell[60753, 2395, 896, 33, 70, "Text",
      CellTags->{"S2.5.6", "6.2"}],
    Cell[61652, 2430, 698, 23, 70, "Text",
      CellTags->{"S2.5.6", "6.3"}],
    Cell[62353, 2455, 865, 33, 70, "Text",
      CellTags->{"S2.5.6", "6.4"}],
    Cell[63221, 2490, 508, 15, 70, "Text",
      CellTags->{"S2.5.6", "6.5"}],
    Cell[63732, 2507, 1162, 38, 70, "DefinitionBox",
      CellTags->"S2.5.6"],
    Cell[64897, 2547, 119, 4, 70, "Caption",
      CellTags->"S2.5.6"],
    Cell[65019, 2553, 660, 15, 70, "Text",
      CellTags->{"S2.5.6", "6.6"}],
    Cell[65682, 2570, 496, 16, 70, "Text",
      CellTags->{"S2.5.6", "6.7"}],
    Cell[66181, 2588, 195, 7, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.8"}],
    Cell[66401, 2599, 72, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[66476, 2603, 82, 3, 70, "Output",
      CellTags->"S2.5.6"],
    Cell[66573, 2609, 332, 11, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.9"}],
    Cell[66930, 2624, 75, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[67008, 2628, 89, 3, 70, "Output",
      CellTags->"S2.5.6"],
    Cell[67112, 2634, 237, 7, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.10"}],
    Cell[67374, 2645, 75, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[67452, 2649, 85, 3, 70, "Output",
      CellTags->"S2.5.6"],
    Cell[67552, 2655, 330, 11, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.11"}],
    Cell[67907, 2670, 75, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[67985, 2674, 89, 3, 70, "Output",
      CellTags->"S2.5.6"],
    Cell[68089, 2680, 135, 5, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.12"}],
    Cell[68227, 2687, 72, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[68302, 2691, 372, 11, 70, "Text",
      CellTags->{"S2.5.6", "6.13"}],
    Cell[68677, 2704, 516, 14, 70, "Text",
      CellTags->{"S2.5.6", "6.14"}],
    Cell[69196, 2720, 916, 40, 70, "Text",
      CellTags->{"S2.5.6", "6.15"}],
    Cell[70115, 2762, 126, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.16"}],
    Cell[70266, 2770, 72, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[70341, 2774, 82, 3, 70, "Output",
      CellTags->"S2.5.6"],
    Cell[70438, 2780, 132, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.17"}],
    Cell[70573, 2786, 81, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[70657, 2790, 142, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.18"}],
    Cell[70824, 2798, 69, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[70896, 2802, 88, 3, 70, "Output",
      CellTags->"S2.5.6"],
    Cell[70999, 2808, 149, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.19"}],
    Cell[71173, 2816, 67, 2, 70, "Input",
      CellTags->"S2.5.6"],
    Cell[71243, 2820, 88, 3, 70, "Output",
      CellTags->"S2.5.6"]},
  "6.1"->{
    Cell[60659, 2392, 91, 1, 70, "Subsection",
      CellTags->{"S2.5.6", "6.1"}]},
  "6.2"->{
    Cell[60753, 2395, 896, 33, 70, "Text",
      CellTags->{"S2.5.6", "6.2"}]},
  "6.3"->{
    Cell[61652, 2430, 698, 23, 70, "Text",
      CellTags->{"S2.5.6", "6.3"}]},
  "6.4"->{
    Cell[62353, 2455, 865, 33, 70, "Text",
      CellTags->{"S2.5.6", "6.4"}]},
  "6.5"->{
    Cell[63221, 2490, 508, 15, 70, "Text",
      CellTags->{"S2.5.6", "6.5"}]},
  "6.6"->{
    Cell[65019, 2553, 660, 15, 70, "Text",
      CellTags->{"S2.5.6", "6.6"}]},
  "6.7"->{
    Cell[65682, 2570, 496, 16, 70, "Text",
      CellTags->{"S2.5.6", "6.7"}]},
  "6.8"->{
    Cell[66181, 2588, 195, 7, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.8"}]},
  "6.9"->{
    Cell[66573, 2609, 332, 11, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.9"}]},
  "6.10"->{
    Cell[67112, 2634, 237, 7, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.10"}]},
  "6.11"->{
    Cell[67552, 2655, 330, 11, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.11"}]},
  "6.12"->{
    Cell[68089, 2680, 135, 5, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.12"}]},
  "6.13"->{
    Cell[68302, 2691, 372, 11, 70, "Text",
      CellTags->{"S2.5.6", "6.13"}]},
  "6.14"->{
    Cell[68677, 2704, 516, 14, 70, "Text",
      CellTags->{"S2.5.6", "6.14"}]},
  "6.15"->{
    Cell[69196, 2720, 916, 40, 70, "Text",
      CellTags->{"S2.5.6", "6.15"}]},
  "6.16"->{
    Cell[70115, 2762, 126, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.16"}]},
  "6.17"->{
    Cell[70438, 2780, 132, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.17"}]},
  "6.18"->{
    Cell[70657, 2790, 142, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.18"}]},
  "6.19"->{
    Cell[70999, 2808, 149, 4, 70, "MathCaption",
      CellTags->{"S2.5.6", "6.19"}]},
  "S2.5.7"->{
    Cell[71380, 2829, 86, 1, 70, "Subsection",
      CellTags->{"S2.5.7", "7.1"}],
    Cell[71469, 2832, 405, 9, 70, "Text",
      CellTags->{"S2.5.7", "7.2"}],
    Cell[71877, 2843, 1011, 27, 70, "Text",
      CellTags->{"S2.5.7", "7.3"}],
    Cell[72891, 2872, 424, 13, 70, "FramedBox",
      CellTags->"S2.5.7"],
    Cell[73318, 2887, 126, 5, 70, "Caption",
      CellTags->"S2.5.7"],
    Cell[73447, 2894, 692, 20, 70, "Text",
      CellTags->{"S2.5.7", "7.4"}],
    Cell[74142, 2916, 138, 5, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.5"}],
    Cell[74283, 2923, 81, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[74367, 2927, 146, 5, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.6"}],
    Cell[74538, 2936, 72, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[74613, 2940, 82, 3, 70, "Output",
      CellTags->"S2.5.7"],
    Cell[74710, 2946, 150, 4, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.7"}],
    Cell[74885, 2954, 66, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[74954, 2958, 65, 2, 70, "Print",
      CellTags->"S2.5.7"],
    Cell[75022, 2962, 475, 15, 70, "Print",
      CellTags->"S2.5.7"],
    Cell[75512, 2980, 342, 7, 70, "Text",
      CellTags->{"S2.5.7", "7.8"}],
    Cell[75857, 2989, 107, 1, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.9"}],
    Cell[75967, 2992, 118, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[76088, 2996, 150, 4, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.10"}],
    Cell[76263, 3004, 68, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[76334, 3008, 67, 2, 70, "Print",
      CellTags->"S2.5.7"],
    Cell[76404, 3012, 503, 15, 70, "Print",
      CellTags->"S2.5.7"],
    Cell[76922, 3030, 183, 7, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.11"}],
    Cell[77108, 3039, 90, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[77201, 3043, 156, 4, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.12"}],
    Cell[77382, 3051, 68, 2, 70, "Input",
      CellTags->"S2.5.7"],
    Cell[77453, 3055, 67, 2, 70, "Print",
      CellTags->"S2.5.7"],
    Cell[77523, 3059, 577, 17, 70, "Print",
      CellTags->"S2.5.7"],
    Cell[78115, 3079, 590, 13, 70, "Text",
      CellTags->{"S2.5.7", "7.13"}]},
  "7.1"->{
    Cell[71380, 2829, 86, 1, 70, "Subsection",
      CellTags->{"S2.5.7", "7.1"}]},
  "7.2"->{
    Cell[71469, 2832, 405, 9, 70, "Text",
      CellTags->{"S2.5.7", "7.2"}]},
  "7.3"->{
    Cell[71877, 2843, 1011, 27, 70, "Text",
      CellTags->{"S2.5.7", "7.3"}]},
  "7.4"->{
    Cell[73447, 2894, 692, 20, 70, "Text",
      CellTags->{"S2.5.7", "7.4"}]},
  "7.5"->{
    Cell[74142, 2916, 138, 5, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.5"}]},
  "7.6"->{
    Cell[74367, 2927, 146, 5, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.6"}]},
  "7.7"->{
    Cell[74710, 2946, 150, 4, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.7"}]},
  "7.8"->{
    Cell[75512, 2980, 342, 7, 70, "Text",
      CellTags->{"S2.5.7", "7.8"}]},
  "7.9"->{
    Cell[75857, 2989, 107, 1, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.9"}]},
  "7.10"->{
    Cell[76088, 2996, 150, 4, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.10"}]},
  "7.11"->{
    Cell[76922, 3030, 183, 7, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.11"}]},
  "7.12"->{
    Cell[77201, 3043, 156, 4, 70, "MathCaption",
      CellTags->{"S2.5.7", "7.12"}]},
  "7.13"->{
    Cell[78115, 3079, 590, 13, 70, "Text",
      CellTags->{"S2.5.7", "7.13"}]},
  "S2.5.8"->{
    Cell[78742, 3097, 92, 1, 70, "Subsection",
      CellTags->{"S2.5.8", "8.1"}],
    Cell[78837, 3100, 1112, 45, 70, "Text",
      CellTags->{"S2.5.8", "8.2"}],
    Cell[79952, 3147, 989, 30, 70, "DefinitionBox",
      CellTags->"S2.5.8"],
    Cell[80944, 3179, 130, 5, 70, "Caption",
      CellTags->"S2.5.8"],
    Cell[81077, 3186, 179, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.3"}],
    Cell[81259, 3195, 91, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[81353, 3199, 172, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.4"}],
    Cell[81550, 3208, 67, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[81620, 3212, 66, 2, 70, "Print",
      CellTags->"S2.5.8"],
    Cell[81689, 3216, 433, 13, 70, "Print",
      CellTags->"S2.5.8"],
    Cell[82137, 3232, 201, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.5"}],
    Cell[82363, 3241, 91, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[82457, 3245, 96, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[82568, 3251, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.6"}],
    Cell[82754, 3260, 68, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[82825, 3264, 67, 2, 70, "Print",
      CellTags->"S2.5.8"],
    Cell[82895, 3268, 427, 13, 70, "Print",
      CellTags->"S2.5.8"],
    Cell[83337, 3284, 172, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.7"}],
    Cell[83534, 3295, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[83610, 3299, 96, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[83721, 3305, 189, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.8"}],
    Cell[83935, 3314, 74, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[84012, 3318, 116, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[84143, 3324, 314, 8, 70, "Text",
      CellTags->{"S2.5.8", "8.9"}],
    Cell[84460, 3334, 588, 15, 70, "Text",
      CellTags->{"S2.5.8", "8.10"}],
    Cell[85051, 3351, 1782, 58, 70, "DefinitionBox",
      CellTags->"S2.5.8"],
    Cell[86836, 3411, 173, 7, 70, "Caption",
      CellTags->"S2.5.8"],
    Cell[87012, 3420, 802, 24, 70, "Text",
      CellTags->{"S2.5.8", "8.11"}],
    Cell[87817, 3446, 134, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.12"}],
    Cell[87976, 3455, 83, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[88062, 3459, 103, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[88180, 3465, 190, 6, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.13"}],
    Cell[88395, 3475, 76, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[88474, 3479, 103, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[88592, 3485, 231, 11, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.14"}],
    Cell[88848, 3500, 75, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[88926, 3504, 111, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[89052, 3510, 369, 10, 70, "Text",
      CellTags->{"S2.5.8", "8.15"}],
    Cell[89424, 3522, 748, 23, 70, "DefinitionBox",
      CellTags->"S2.5.8"],
    Cell[90175, 3547, 88, 1, 70, "Caption",
      CellTags->"S2.5.8"],
    Cell[90266, 3550, 767, 29, 70, "Text",
      CellTags->{"S2.5.8", "8.16"}],
    Cell[91036, 3581, 243, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.17"}],
    Cell[91304, 3594, 79, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[91386, 3598, 103, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[91504, 3604, 253, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.18"}],
    Cell[91760, 3615, 80, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[91843, 3619, 158, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.19"}],
    Cell[92026, 3630, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[92102, 3634, 125, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[92242, 3640, 230, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.20"}],
    Cell[92497, 3651, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[92573, 3655, 126, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[92714, 3661, 181, 4, 70, "Text",
      CellTags->{"S2.5.8", "8.21"}],
    Cell[92898, 3667, 151, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.22"}],
    Cell[93074, 3678, 70, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[93147, 3682, 83, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[93245, 3688, 314, 13, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.23"}],
    Cell[93584, 3705, 75, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[93662, 3709, 83, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[93760, 3715, 291, 12, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.24"}],
    Cell[94054, 3729, 76, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[94133, 3733, 173, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.25"}],
    Cell[94331, 3744, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[94407, 3748, 88, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[94510, 3754, 130, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.26"}],
    Cell[94665, 3763, 70, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[94738, 3767, 83, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[94836, 3773, 223, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.27"}],
    Cell[95084, 3786, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[95160, 3790, 88, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[95263, 3796, 511, 16, 70, "Text",
      CellTags->{"S2.5.8", "8.28"}],
    Cell[95777, 3814, 157, 4, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.29"}],
    Cell[95937, 3820, 90, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[96030, 3824, 218, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.30"}],
    Cell[96273, 3837, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[96349, 3841, 132, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[96496, 3847, 112, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.31"}],
    Cell[96633, 3856, 73, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[96709, 3860, 169, 4, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[96893, 3867, 658, 13, 70, "Text",
      CellTags->{"S2.5.8", "8.32"}],
    Cell[97554, 3882, 873, 28, 70, "DefinitionBox",
      CellTags->"S2.5.8"],
    Cell[98430, 3912, 135, 5, 70, "Caption",
      CellTags->"S2.5.8"],
    Cell[98568, 3919, 230, 5, 70, "Text",
      CellTags->{"S2.5.8", "8.33"}],
    Cell[98801, 3926, 143, 4, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.34"}],
    Cell[98969, 3934, 91, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[99063, 3938, 111, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[99189, 3944, 109, 1, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.35"}],
    Cell[99323, 3949, 83, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[99409, 3953, 97, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[99521, 3959, 195, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.36"}],
    Cell[99741, 3968, 83, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[99827, 3972, 112, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[99954, 3978, 106, 1, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.37"}],
    Cell[100085, 3983, 99, 2, 70, "Input",
      CellTags->"S2.5.8"],
    Cell[100187, 3987, 97, 3, 70, "Output",
      CellTags->"S2.5.8"],
    Cell[100299, 3993, 318, 8, 70, "Text",
      CellTags->{"S2.5.8", "8.38"}]},
  "8.1"->{
    Cell[78742, 3097, 92, 1, 70, "Subsection",
      CellTags->{"S2.5.8", "8.1"}]},
  "8.2"->{
    Cell[78837, 3100, 1112, 45, 70, "Text",
      CellTags->{"S2.5.8", "8.2"}]},
  "8.3"->{
    Cell[81077, 3186, 179, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.3"}]},
  "8.4"->{
    Cell[81353, 3199, 172, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.4"}]},
  "8.5"->{
    Cell[82137, 3232, 201, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.5"}]},
  "8.6"->{
    Cell[82568, 3251, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.6"}]},
  "8.7"->{
    Cell[83337, 3284, 172, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.7"}]},
  "8.8"->{
    Cell[83721, 3305, 189, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.8"}]},
  "8.9"->{
    Cell[84143, 3324, 314, 8, 70, "Text",
      CellTags->{"S2.5.8", "8.9"}]},
  "8.10"->{
    Cell[84460, 3334, 588, 15, 70, "Text",
      CellTags->{"S2.5.8", "8.10"}]},
  "8.11"->{
    Cell[87012, 3420, 802, 24, 70, "Text",
      CellTags->{"S2.5.8", "8.11"}]},
  "8.12"->{
    Cell[87817, 3446, 134, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.12"}]},
  "8.13"->{
    Cell[88180, 3465, 190, 6, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.13"}]},
  "8.14"->{
    Cell[88592, 3485, 231, 11, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.14"}]},
  "8.15"->{
    Cell[89052, 3510, 369, 10, 70, "Text",
      CellTags->{"S2.5.8", "8.15"}]},
  "8.16"->{
    Cell[90266, 3550, 767, 29, 70, "Text",
      CellTags->{"S2.5.8", "8.16"}]},
  "8.17"->{
    Cell[91036, 3581, 243, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.17"}]},
  "8.18"->{
    Cell[91504, 3604, 253, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.18"}]},
  "8.19"->{
    Cell[91843, 3619, 158, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.19"}]},
  "8.20"->{
    Cell[92242, 3640, 230, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.20"}]},
  "8.21"->{
    Cell[92714, 3661, 181, 4, 70, "Text",
      CellTags->{"S2.5.8", "8.21"}]},
  "8.22"->{
    Cell[92898, 3667, 151, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.22"}]},
  "8.23"->{
    Cell[93245, 3688, 314, 13, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.23"}]},
  "8.24"->{
    Cell[93760, 3715, 291, 12, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.24"}]},
  "8.25"->{
    Cell[94133, 3733, 173, 7, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.25"}]},
  "8.26"->{
    Cell[94510, 3754, 130, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.26"}]},
  "8.27"->{
    Cell[94836, 3773, 223, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.27"}]},
  "8.28"->{
    Cell[95263, 3796, 511, 16, 70, "Text",
      CellTags->{"S2.5.8", "8.28"}]},
  "8.29"->{
    Cell[95777, 3814, 157, 4, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.29"}]},
  "8.30"->{
    Cell[96030, 3824, 218, 9, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.30"}]},
  "8.31"->{
    Cell[96496, 3847, 112, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.31"}]},
  "8.32"->{
    Cell[96893, 3867, 658, 13, 70, "Text",
      CellTags->{"S2.5.8", "8.32"}]},
  "8.33"->{
    Cell[98568, 3919, 230, 5, 70, "Text",
      CellTags->{"S2.5.8", "8.33"}]},
  "8.34"->{
    Cell[98801, 3926, 143, 4, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.34"}]},
  "8.35"->{
    Cell[99189, 3944, 109, 1, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.35"}]},
  "8.36"->{
    Cell[99521, 3959, 195, 5, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.36"}]},
  "8.37"->{
    Cell[99954, 3978, 106, 1, 70, "MathCaption",
      CellTags->{"S2.5.8", "8.37"}]},
  "8.38"->{
    Cell[100299, 3993, 318, 8, 70, "Text",
      CellTags->{"S2.5.8", "8.38"}]},
  "S2.5.9"->{
    Cell[100654, 4006, 105, 1, 70, "Subsection",
      CellTags->{"S2.5.9", "9.1"}],
    Cell[100762, 4009, 535, 11, 70, "Text",
      CellTags->{"S2.5.9", "9.2"}],
    Cell[101300, 4022, 741, 23, 70, "DefinitionBox",
      CellTags->"S2.5.9"],
    Cell[102044, 4047, 93, 1, 70, "Caption",
      CellTags->"S2.5.9"],
    Cell[102140, 4050, 163, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.3"}],
    Cell[102306, 4057, 99, 2, 70, "Input",
      CellTags->"S2.5.9"],
    Cell[102408, 4061, 156, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.4"}],
    Cell[102589, 4070, 79, 2, 70, "Input",
      CellTags->"S2.5.9"],
    Cell[102671, 4074, 82, 3, 70, "Output",
      CellTags->"S2.5.9"],
    Cell[102768, 4080, 136, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.5"}],
    Cell[102929, 4089, 66, 2, 70, "Input",
      CellTags->"S2.5.9"],
    Cell[102998, 4093, 65, 2, 70, "Print",
      CellTags->"S2.5.9"],
    Cell[103066, 4097, 549, 17, 70, "Print",
      CellTags->"S2.5.9"],
    Cell[103630, 4117, 352, 14, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.6"}],
    Cell[104007, 4135, 68, 2, 70, "Input",
      CellTags->"S2.5.9"],
    Cell[104078, 4139, 82, 3, 70, "Output",
      CellTags->"S2.5.9"],
    Cell[104175, 4145, 154, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.7"}],
    Cell[104354, 4154, 66, 2, 70, "Input",
      CellTags->"S2.5.9"],
    Cell[104423, 4158, 65, 2, 70, "Print",
      CellTags->"S2.5.9"],
    Cell[104491, 4162, 769, 25, 70, "Print",
      CellTags->"S2.5.9"],
    Cell[105275, 4190, 242, 8, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.8"}],
    Cell[105542, 4202, 68, 2, 70, "Input",
      CellTags->"S2.5.9"],
    Cell[105613, 4206, 82, 3, 70, "Output",
      CellTags->"S2.5.9"],
    Cell[105710, 4212, 969, 41, 70, "Text",
      CellTags->{"S2.5.9", "9.9"}],
    Cell[106682, 4255, 2355, 74, 70, "Text",
      CellTags->{"S2.5.9", "9.10"}],
    Cell[109040, 4331, 427, 8, 70, "Text",
      CellTags->{"S2.5.9", "9.11"}]},
  "9.1"->{
    Cell[100654, 4006, 105, 1, 70, "Subsection",
      CellTags->{"S2.5.9", "9.1"}]},
  "9.2"->{
    Cell[100762, 4009, 535, 11, 70, "Text",
      CellTags->{"S2.5.9", "9.2"}]},
  "9.3"->{
    Cell[102140, 4050, 163, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.3"}]},
  "9.4"->{
    Cell[102408, 4061, 156, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.4"}]},
  "9.5"->{
    Cell[102768, 4080, 136, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.5"}]},
  "9.6"->{
    Cell[103630, 4117, 352, 14, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.6"}]},
  "9.7"->{
    Cell[104175, 4145, 154, 5, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.7"}]},
  "9.8"->{
    Cell[105275, 4190, 242, 8, 70, "MathCaption",
      CellTags->{"S2.5.9", "9.8"}]},
  "9.9"->{
    Cell[105710, 4212, 969, 41, 70, "Text",
      CellTags->{"S2.5.9", "9.9"}]},
  "9.10"->{
    Cell[106682, 4255, 2355, 74, 70, "Text",
      CellTags->{"S2.5.9", "9.10"}]},
  "9.11"->{
    Cell[109040, 4331, 427, 8, 70, "Text",
      CellTags->{"S2.5.9", "9.11"}]},
  "S2.5.10"->{
    Cell[109504, 4344, 108, 1, 70, "Subsection",
      CellTags->{"S2.5.10", "10.1"}],
    Cell[109615, 4347, 876, 35, 70, "Text",
      CellTags->{"S2.5.10", "10.2"}],
    Cell[110494, 4384, 258, 7, 70, "Text",
      CellTags->{"S2.5.10", "10.3"}],
    Cell[110755, 4393, 491, 15, 70, "Text",
      CellTags->{"S2.5.10", "10.4"}],
    Cell[111249, 4410, 326, 13, 70, "Text",
      CellTags->{"S2.5.10", "10.5"}],
    Cell[111578, 4425, 1266, 42, 70, "DefinitionBox",
      CellTags->"S2.5.10"],
    Cell[112847, 4469, 90, 1, 70, "Caption",
      CellTags->"S2.5.10"],
    Cell[112940, 4472, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.6"}],
    Cell[113104, 4479, 82, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[113189, 4483, 149, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.7"}],
    Cell[113363, 4492, 67, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[113433, 4496, 66, 2, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[113502, 4500, 418, 13, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[113935, 4516, 131, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.8"}],
    Cell[114069, 4523, 87, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[114159, 4527, 137, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.9"}],
    Cell[114321, 4536, 67, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[114391, 4540, 66, 2, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[114460, 4544, 435, 13, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[114910, 4560, 132, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.10"}],
    Cell[115067, 4569, 70, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[115140, 4573, 93, 2, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[115236, 4577, 321, 9, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[115572, 4589, 109, 1, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.11"}],
    Cell[115706, 4594, 74, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[115783, 4598, 89, 3, 70, "Output",
      CellTags->"S2.5.10"],
    Cell[115887, 4604, 502, 16, 70, "Text",
      CellTags->{"S2.5.10", "10.12"}],
    Cell[116392, 4622, 1186, 42, 70, "Text",
      CellTags->{"S2.5.10", "10.13"}],
    Cell[117581, 4666, 148, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.14"}],
    Cell[117732, 4673, 97, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[117832, 4677, 140, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.15"}],
    Cell[117997, 4686, 67, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[118067, 4690, 66, 2, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[118136, 4694, 511, 15, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[118662, 4712, 160, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.16"}],
    Cell[118847, 4721, 76, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[118926, 4725, 93, 3, 70, "Output",
      CellTags->"S2.5.10"],
    Cell[119034, 4731, 487, 18, 70, "Text",
      CellTags->{"S2.5.10", "10.17"}],
    Cell[119524, 4751, 709, 21, 70, "Text",
      CellTags->{"S2.5.10", "10.18"}],
    Cell[120236, 4774, 655, 23, 70, "Text",
      CellTags->{"S2.5.10", "10.19"}],
    Cell[120894, 4799, 3218, 98, 70, "DefinitionBox",
      CellTags->"S2.5.10"],
    Cell[124115, 4899, 75, 1, 70, "Caption",
      CellTags->"S2.5.10"],
    Cell[124193, 4902, 347, 7, 70, "Text",
      CellTags->{"S2.5.10", "10.20"}],
    Cell[124543, 4911, 158, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.21"}],
    Cell[124726, 4920, 83, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[124812, 4924, 84, 3, 70, "Output",
      CellTags->"S2.5.10"],
    Cell[124911, 4930, 99, 1, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.22"}],
    Cell[125035, 4935, 88, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[125126, 4939, 84, 3, 70, "Output",
      CellTags->"S2.5.10"],
    Cell[125225, 4945, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.23"}],
    Cell[125411, 4954, 73, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[125487, 4958, 71, 2, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[125561, 4962, 492, 15, 70, "Print",
      CellTags->"S2.5.10"],
    Cell[126068, 4980, 691, 21, 70, "Text",
      CellTags->{"S2.5.10", "10.24"}],
    Cell[126762, 5003, 177, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.25"}],
    Cell[126942, 5010, 98, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[127043, 5014, 200, 6, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.26"}],
    Cell[127268, 5024, 97, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[127368, 5028, 215, 4, 70, "Message",
      CellTags->"S2.5.10"],
    Cell[127586, 5034, 90, 3, 70, "Output",
      CellTags->"S2.5.10"],
    Cell[127691, 5040, 2986, 107, 70, "DefinitionBox",
      CellTags->"S2.5.10"],
    Cell[130680, 5149, 89, 1, 70, "Caption",
      CellTags->"S2.5.10"],
    Cell[130772, 5152, 759, 22, 70, "Text",
      CellTags->{"S2.5.10", "10.27"}],
    Cell[131534, 5176, 514, 13, 70, "Text",
      CellTags->{"S2.5.10", "10.28"}],
    Cell[132051, 5191, 424, 13, 70, "Text",
      CellTags->{"S2.5.10", "10.29"}],
    Cell[132478, 5206, 184, 7, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.30"}],
    Cell[132665, 5215, 101, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[132769, 5219, 133, 4, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.31"}],
    Cell[132927, 5227, 93, 2, 70, "Input",
      CellTags->"S2.5.10"],
    Cell[133023, 5231, 98, 3, 70, "Output",
      CellTags->"S2.5.10"],
    Cell[133136, 5237, 544, 16, 70, "Text",
      CellTags->{"S2.5.10", "10.32"}],
    Cell[133683, 5255, 627, 16, 70, "Text",
      CellTags->{"S2.5.10", "10.33"}],
    Cell[134313, 5273, 568, 12, 70, "Text",
      CellTags->{"S2.5.10", "10.34"}]},
  "10.1"->{
    Cell[109504, 4344, 108, 1, 70, "Subsection",
      CellTags->{"S2.5.10", "10.1"}]},
  "10.2"->{
    Cell[109615, 4347, 876, 35, 70, "Text",
      CellTags->{"S2.5.10", "10.2"}]},
  "10.3"->{
    Cell[110494, 4384, 258, 7, 70, "Text",
      CellTags->{"S2.5.10", "10.3"}]},
  "10.4"->{
    Cell[110755, 4393, 491, 15, 70, "Text",
      CellTags->{"S2.5.10", "10.4"}]},
  "10.5"->{
    Cell[111249, 4410, 326, 13, 70, "Text",
      CellTags->{"S2.5.10", "10.5"}]},
  "10.6"->{
    Cell[112940, 4472, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.6"}]},
  "10.7"->{
    Cell[113189, 4483, 149, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.7"}]},
  "10.8"->{
    Cell[113935, 4516, 131, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.8"}]},
  "10.9"->{
    Cell[114159, 4527, 137, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.9"}]},
  "10.10"->{
    Cell[114910, 4560, 132, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.10"}]},
  "10.11"->{
    Cell[115572, 4589, 109, 1, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.11"}]},
  "10.12"->{
    Cell[115887, 4604, 502, 16, 70, "Text",
      CellTags->{"S2.5.10", "10.12"}]},
  "10.13"->{
    Cell[116392, 4622, 1186, 42, 70, "Text",
      CellTags->{"S2.5.10", "10.13"}]},
  "10.14"->{
    Cell[117581, 4666, 148, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.14"}]},
  "10.15"->{
    Cell[117832, 4677, 140, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.15"}]},
  "10.16"->{
    Cell[118662, 4712, 160, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.16"}]},
  "10.17"->{
    Cell[119034, 4731, 487, 18, 70, "Text",
      CellTags->{"S2.5.10", "10.17"}]},
  "10.18"->{
    Cell[119524, 4751, 709, 21, 70, "Text",
      CellTags->{"S2.5.10", "10.18"}]},
  "10.19"->{
    Cell[120236, 4774, 655, 23, 70, "Text",
      CellTags->{"S2.5.10", "10.19"}]},
  "10.20"->{
    Cell[124193, 4902, 347, 7, 70, "Text",
      CellTags->{"S2.5.10", "10.20"}]},
  "10.21"->{
    Cell[124543, 4911, 158, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.21"}]},
  "10.22"->{
    Cell[124911, 4930, 99, 1, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.22"}]},
  "10.23"->{
    Cell[125225, 4945, 161, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.23"}]},
  "10.24"->{
    Cell[126068, 4980, 691, 21, 70, "Text",
      CellTags->{"S2.5.10", "10.24"}]},
  "10.25"->{
    Cell[126762, 5003, 177, 5, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.25"}]},
  "10.26"->{
    Cell[127043, 5014, 200, 6, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.26"}]},
  "10.27"->{
    Cell[130772, 5152, 759, 22, 70, "Text",
      CellTags->{"S2.5.10", "10.27"}]},
  "10.28"->{
    Cell[131534, 5176, 514, 13, 70, "Text",
      CellTags->{"S2.5.10", "10.28"}]},
  "10.29"->{
    Cell[132051, 5191, 424, 13, 70, "Text",
      CellTags->{"S2.5.10", "10.29"}]},
  "10.30"->{
    Cell[132478, 5206, 184, 7, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.30"}]},
  "10.31"->{
    Cell[132769, 5219, 133, 4, 70, "MathCaption",
      CellTags->{"S2.5.10", "10.31"}]},
  "10.32"->{
    Cell[133136, 5237, 544, 16, 70, "Text",
      CellTags->{"S2.5.10", "10.32"}]},
  "10.33"->{
    Cell[133683, 5255, 627, 16, 70, "Text",
      CellTags->{"S2.5.10", "10.33"}]},
  "10.34"->{
    Cell[134313, 5273, 568, 12, 70, "Text",
      CellTags->{"S2.5.10", "10.34"}]},
  "S2.5.11"->{
    Cell[134918, 5290, 87, 1, 70, "Subsection",
      CellTags->{"S2.5.11", "11.1"}],
    Cell[135008, 5293, 452, 14, 70, "Text",
      CellTags->{"S2.5.11", "11.2"}],
    Cell[135463, 5309, 833, 25, 70, "DefinitionBox",
      CellTags->"S2.5.11"],
    Cell[136299, 5336, 82, 1, 70, "Caption",
      CellTags->"S2.5.11"],
    Cell[136384, 5339, 151, 5, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.3"}],
    Cell[136538, 5346, 99, 2, 70, "Input",
      CellTags->"S2.5.11"],
    Cell[136640, 5350, 223, 7, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.4"}],
    Cell[136888, 5361, 76, 2, 70, "Input",
      CellTags->"S2.5.11"],
    Cell[136967, 5365, 93, 3, 70, "Output",
      CellTags->"S2.5.11"],
    Cell[137075, 5371, 207, 5, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.5"}],
    Cell[137307, 5380, 69, 2, 70, "Input",
      CellTags->"S2.5.11"],
    Cell[137379, 5384, 101, 3, 70, "Output",
      CellTags->"S2.5.11"],
    Cell[137495, 5390, 327, 10, 70, "Text",
      CellTags->{"S2.5.11", "11.6"}],
    Cell[137825, 5402, 1274, 40, 70, "DefinitionBox",
      CellTags->"S2.5.11"],
    Cell[139102, 5444, 114, 4, 70, "Caption",
      CellTags->"S2.5.11"],
    Cell[139219, 5450, 330, 13, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.7"}],
    Cell[139552, 5465, 136, 5, 70, "Input",
      CellTags->"S2.5.11"],
    Cell[139691, 5472, 198, 5, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.8"}],
    Cell[139914, 5481, 77, 2, 70, "Input",
      CellTags->"S2.5.11"],
    Cell[139994, 5485, 137, 3, 70, "Output",
      CellTags->"S2.5.11"],
    Cell[140146, 5491, 426, 13, 70, "Text",
      CellTags->{"S2.5.11", "11.9"}]},
  "11.1"->{
    Cell[134918, 5290, 87, 1, 70, "Subsection",
      CellTags->{"S2.5.11", "11.1"}]},
  "11.2"->{
    Cell[135008, 5293, 452, 14, 70, "Text",
      CellTags->{"S2.5.11", "11.2"}]},
  "11.3"->{
    Cell[136384, 5339, 151, 5, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.3"}]},
  "11.4"->{
    Cell[136640, 5350, 223, 7, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.4"}]},
  "11.5"->{
    Cell[137075, 5371, 207, 5, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.5"}]},
  "11.6"->{
    Cell[137495, 5390, 327, 10, 70, "Text",
      CellTags->{"S2.5.11", "11.6"}]},
  "11.7"->{
    Cell[139219, 5450, 330, 13, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.7"}]},
  "11.8"->{
    Cell[139691, 5472, 198, 5, 70, "MathCaption",
      CellTags->{"S2.5.11", "11.8"}]},
  "11.9"->{
    Cell[140146, 5491, 426, 13, 70, "Text",
      CellTags->{"S2.5.11", "11.9"}]},
  "S2.5.12"->{
    Cell[140609, 5509, 106, 3, 70, "Subsection",
      CellTags->{"S2.5.12", "12.1"}],
    Cell[140718, 5514, 498, 12, 70, "Text",
      CellTags->{"S2.5.12", "12.2"}],
    Cell[141219, 5528, 336, 8, 70, "Text",
      CellTags->{"S2.5.12", "12.3"}],
    Cell[141558, 5538, 506, 10, 70, "Text",
      CellTags->{"S2.5.12", "12.4"}],
    Cell[142067, 5550, 610, 18, 70, "DefinitionBox",
      CellTags->"S2.5.12"],
    Cell[142680, 5570, 68, 1, 70, "Caption",
      CellTags->"S2.5.12"],
    Cell[142751, 5573, 194, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.5"}],
    Cell[142970, 5582, 75, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[143048, 5586, 139, 3, 70, "Message",
      CellTags->"S2.5.12"],
    Cell[143190, 5591, 83, 3, 70, "Output",
      CellTags->"S2.5.12"],
    Cell[143288, 5597, 133, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.6"}],
    Cell[143446, 5606, 79, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[143528, 5610, 89, 3, 70, "Output",
      CellTags->"S2.5.12"],
    Cell[143632, 5616, 283, 7, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.7"}],
    Cell[143940, 5627, 75, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[144018, 5631, 83, 3, 70, "Output",
      CellTags->"S2.5.12"],
    Cell[144116, 5637, 199, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.8"}],
    Cell[144340, 5646, 80, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[144423, 5650, 92, 3, 70, "Output",
      CellTags->"S2.5.12"],
    Cell[144530, 5656, 147, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.9"}],
    Cell[144680, 5663, 74, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[144757, 5667, 139, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.10"}],
    Cell[144921, 5676, 77, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[145001, 5680, 89, 3, 70, "Output",
      CellTags->"S2.5.12"],
    Cell[145105, 5686, 299, 8, 70, "Text",
      CellTags->{"S2.5.12", "12.11"}],
    Cell[145407, 5696, 377, 8, 70, "Text",
      CellTags->{"S2.5.12", "12.12"}],
    Cell[145787, 5706, 210, 7, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.13"}],
    Cell[146022, 5717, 76, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[146101, 5721, 83, 3, 70, "Output",
      CellTags->"S2.5.12"],
    Cell[146199, 5727, 230, 7, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.14"}],
    Cell[146432, 5736, 144, 5, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[146579, 5743, 128, 4, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.15"}],
    Cell[146732, 5751, 76, 2, 70, "Input",
      CellTags->"S2.5.12"],
    Cell[146811, 5755, 91, 3, 70, "Output",
      CellTags->"S2.5.12"]},
  "12.1"->{
    Cell[140609, 5509, 106, 3, 70, "Subsection",
      CellTags->{"S2.5.12", "12.1"}]},
  "12.2"->{
    Cell[140718, 5514, 498, 12, 70, "Text",
      CellTags->{"S2.5.12", "12.2"}]},
  "12.3"->{
    Cell[141219, 5528, 336, 8, 70, "Text",
      CellTags->{"S2.5.12", "12.3"}]},
  "12.4"->{
    Cell[141558, 5538, 506, 10, 70, "Text",
      CellTags->{"S2.5.12", "12.4"}]},
  "12.5"->{
    Cell[142751, 5573, 194, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.5"}]},
  "12.6"->{
    Cell[143288, 5597, 133, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.6"}]},
  "12.7"->{
    Cell[143632, 5616, 283, 7, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.7"}]},
  "12.8"->{
    Cell[144116, 5637, 199, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.8"}]},
  "12.9"->{
    Cell[144530, 5656, 147, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.9"}]},
  "12.10"->{
    Cell[144757, 5667, 139, 5, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.10"}]},
  "12.11"->{
    Cell[145105, 5686, 299, 8, 70, "Text",
      CellTags->{"S2.5.12", "12.11"}]},
  "12.12"->{
    Cell[145407, 5696, 377, 8, 70, "Text",
      CellTags->{"S2.5.12", "12.12"}]},
  "12.13"->{
    Cell[145787, 5706, 210, 7, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.13"}]},
  "12.14"->{
    Cell[146199, 5727, 230, 7, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.14"}]},
  "12.15"->{
    Cell[146579, 5743, 128, 4, 70, "MathCaption",
      CellTags->{"S2.5.12", "12.15"}]},
  "S2.5.13"->{
    Cell[146951, 5764, 102, 1, 70, "Subsection",
      CellTags->{"S2.5.13", "13.1"}],
    Cell[147056, 5767, 1655, 54, 70, "DefinitionBox",
      CellTags->"S2.5.13"],
    Cell[148714, 5823, 81, 1, 70, "Caption",
      CellTags->"S2.5.13"],
    Cell[148798, 5826, 271, 6, 40, "Text",
      CellTags->{"S2.5.13", "13.2"}],
    Cell[149072, 5834, 510, 16, 70, "Text",
      CellTags->{"S2.5.13", "13.3"}],
    Cell[149585, 5852, 128, 5, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.4"}],
    Cell[149716, 5859, 77, 2, 28, "Input",
      CellTags->"S2.5.13"],
    Cell[149796, 5863, 179, 6, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.5"}],
    Cell[150000, 5873, 78, 2, 28, "Input",
      CellTags->"S2.5.13"],
    Cell[150081, 5877, 122, 3, 27, "Output",
      CellTags->"S2.5.13"],
    Cell[150218, 5883, 453, 11, 72, "Text",
      CellTags->{"S2.5.13", "13.6"}],
    Cell[150674, 5896, 656, 19, 88, "Text",
      CellTags->{"S2.5.13", "13.7"}],
    Cell[151333, 5917, 162, 5, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.8"}],
    Cell[151498, 5924, 110, 2, 28, "Input",
      CellTags->"S2.5.13"],
    Cell[151611, 5928, 116, 2, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.9"}],
    Cell[151752, 5934, 78, 2, 28, "Input",
      CellTags->"S2.5.13"],
    Cell[151833, 5938, 186, 4, 41, "Output",
      CellTags->"S2.5.13"],
    Cell[152034, 5945, 151, 5, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.10"}],
    Cell[152210, 5954, 103, 2, 28, "Input",
      CellTags->"S2.5.13"],
    Cell[152316, 5958, 186, 4, 41, "Output",
      CellTags->"S2.5.13"]},
  "13.1"->{
    Cell[146951, 5764, 102, 1, 70, "Subsection",
      CellTags->{"S2.5.13", "13.1"}]},
  "13.2"->{
    Cell[148798, 5826, 271, 6, 40, "Text",
      CellTags->{"S2.5.13", "13.2"}]},
  "13.3"->{
    Cell[149072, 5834, 510, 16, 70, "Text",
      CellTags->{"S2.5.13", "13.3"}]},
  "13.4"->{
    Cell[149585, 5852, 128, 5, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.4"}]},
  "13.5"->{
    Cell[149796, 5863, 179, 6, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.5"}]},
  "13.6"->{
    Cell[150218, 5883, 453, 11, 72, "Text",
      CellTags->{"S2.5.13", "13.6"}]},
  "13.7"->{
    Cell[150674, 5896, 656, 19, 88, "Text",
      CellTags->{"S2.5.13", "13.7"}]},
  "13.8"->{
    Cell[151333, 5917, 162, 5, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.8"}]},
  "13.9"->{
    Cell[151611, 5928, 116, 2, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.9"}]},
  "13.10"->{
    Cell[152034, 5945, 151, 5, 40, "MathCaption",
      CellTags->{"S2.5.13", "13.10"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.5.0", 153157, 5983},
  {"0.1", 153247, 5986},
  {"S2.5.1", 153340, 5989},
  {"1.1", 159880, 6166},
  {"1.2", 159972, 6169},
  {"1.3", 160067, 6172},
  {"1.4", 160162, 6175},
  {"1.5", 160257, 6178},
  {"1.6", 160352, 6181},
  {"1.7", 160447, 6184},
  {"1.8", 160536, 6187},
  {"1.9", 160631, 6190},
  {"1.10", 160727, 6193},
  {"1.11", 160818, 6196},
  {"1.12", 160915, 6199},
  {"1.13", 161012, 6202},
  {"1.14", 161104, 6205},
  {"1.15", 161202, 6208},
  {"1.16", 161300, 6211},
  {"1.17", 161397, 6214},
  {"1.18", 161495, 6217},
  {"1.19", 161587, 6220},
  {"1.20", 161679, 6223},
  {"1.21", 161777, 6226},
  {"1.22", 161869, 6229},
  {"1.23", 161961, 6232},
  {"1.24", 162059, 6235},
  {"1.25", 162157, 6238},
  {"1.26", 162254, 6241},
  {"1.27", 162352, 6244},
  {"1.28", 162450, 6247},
  {"1.29", 162548, 6250},
  {"1.30", 162646, 6253},
  {"1.31", 162744, 6256},
  {"S2.5.2", 162844, 6259},
  {"2.1", 164593, 6306},
  {"2.2", 164688, 6309},
  {"2.3", 164777, 6312},
  {"2.4", 164873, 6315},
  {"2.5", 164969, 6318},
  {"2.6", 165058, 6321},
  {"2.7", 165147, 6324},
  {"2.8", 165237, 6327},
  {"2.9", 165333, 6330},
  {"2.10", 165430, 6333},
  {"2.11", 165529, 6336},
  {"S2.5.3", 165624, 6339},
  {"3.1", 167851, 6398},
  {"3.2", 167946, 6401},
  {"3.3", 168036, 6404},
  {"3.4", 168126, 6407},
  {"3.5", 168223, 6410},
  {"3.6", 168320, 6413},
  {"3.7", 168417, 6416},
  {"3.8", 168508, 6419},
  {"3.9", 168599, 6422},
  {"3.10", 168691, 6425},
  {"3.11", 168784, 6428},
  {"3.12", 168877, 6431},
  {"3.13", 168976, 6434},
  {"3.14", 169075, 6437},
  {"S2.5.4", 169175, 6440},
  {"4.1", 173698, 6561},
  {"4.2", 173793, 6564},
  {"4.3", 173884, 6567},
  {"4.4", 173981, 6570},
  {"4.5", 174078, 6573},
  {"4.6", 174175, 6576},
  {"4.7", 174273, 6579},
  {"4.8", 174370, 6582},
  {"4.9", 174467, 6585},
  {"4.10", 174566, 6588},
  {"4.11", 174665, 6591},
  {"4.12", 174764, 6594},
  {"4.13", 174863, 6597},
  {"4.14", 174962, 6600},
  {"4.15", 175055, 6603},
  {"4.16", 175155, 6606},
  {"4.17", 175254, 6609},
  {"4.18", 175353, 6612},
  {"4.19", 175446, 6615},
  {"4.20", 175545, 6618},
  {"S2.5.5", 175646, 6621},
  {"5.1", 178370, 6694},
  {"5.2", 178465, 6697},
  {"5.3", 178557, 6700},
  {"5.4", 178648, 6703},
  {"5.5", 178745, 6706},
  {"5.6", 178842, 6709},
  {"5.7", 178939, 6712},
  {"5.8", 179036, 6715},
  {"5.9", 179133, 6718},
  {"5.10", 179224, 6721},
  {"5.11", 179317, 6724},
  {"5.12", 179416, 6727},
  {"5.13", 179515, 6730},
  {"5.14", 179614, 6733},
  {"S2.5.6", 179715, 6736},
  {"6.1", 182561, 6811},
  {"6.2", 182656, 6814},
  {"6.3", 182747, 6817},
  {"6.4", 182838, 6820},
  {"6.5", 182929, 6823},
  {"6.6", 183020, 6826},
  {"6.7", 183111, 6829},
  {"6.8", 183202, 6832},
  {"6.9", 183299, 6835},
  {"6.10", 183398, 6838},
  {"6.11", 183497, 6841},
  {"6.12", 183597, 6844},
  {"6.13", 183696, 6847},
  {"6.14", 183789, 6850},
  {"6.15", 183882, 6853},
  {"6.16", 183975, 6856},
  {"6.17", 184074, 6859},
  {"6.18", 184173, 6862},
  {"6.19", 184272, 6865},
  {"S2.5.7", 184373, 6868},
  {"7.1", 186582, 6927},
  {"7.2", 186677, 6930},
  {"7.3", 186767, 6933},
  {"7.4", 186859, 6936},
  {"7.5", 186950, 6939},
  {"7.6", 187047, 6942},
  {"7.7", 187144, 6945},
  {"7.8", 187241, 6948},
  {"7.9", 187331, 6951},
  {"7.10", 187429, 6954},
  {"7.11", 187528, 6957},
  {"7.12", 187627, 6960},
  {"7.13", 187726, 6963},
  {"S2.5.8", 187821, 6966},
  {"8.1", 195116, 7159},
  {"8.2", 195211, 7162},
  {"8.3", 195303, 7165},
  {"8.4", 195400, 7168},
  {"8.5", 195497, 7171},
  {"8.6", 195594, 7174},
  {"8.7", 195691, 7177},
  {"8.8", 195788, 7180},
  {"8.9", 195885, 7183},
  {"8.10", 195976, 7186},
  {"8.11", 196069, 7189},
  {"8.12", 196162, 7192},
  {"8.13", 196261, 7195},
  {"8.14", 196360, 7198},
  {"8.15", 196460, 7201},
  {"8.16", 196553, 7204},
  {"8.17", 196646, 7207},
  {"8.18", 196745, 7210},
  {"8.19", 196844, 7213},
  {"8.20", 196943, 7216},
  {"8.21", 197042, 7219},
  {"8.22", 197134, 7222},
  {"8.23", 197233, 7225},
  {"8.24", 197333, 7228},
  {"8.25", 197433, 7231},
  {"8.26", 197532, 7234},
  {"8.27", 197631, 7237},
  {"8.28", 197730, 7240},
  {"8.29", 197823, 7243},
  {"8.30", 197922, 7246},
  {"8.31", 198021, 7249},
  {"8.32", 198120, 7252},
  {"8.33", 198213, 7255},
  {"8.34", 198305, 7258},
  {"8.35", 198404, 7261},
  {"8.36", 198503, 7264},
  {"8.37", 198602, 7267},
  {"8.38", 198701, 7270},
  {"S2.5.9", 198796, 7273},
  {"9.1", 200801, 7326},
  {"9.2", 200898, 7329},
  {"9.3", 200990, 7332},
  {"9.4", 201088, 7335},
  {"9.5", 201186, 7338},
  {"9.6", 201284, 7341},
  {"9.7", 201383, 7344},
  {"9.8", 201481, 7347},
  {"9.9", 201579, 7350},
  {"9.10", 201672, 7353},
  {"9.11", 201767, 7356},
  {"S2.5.10", 201863, 7359},
  {"10.1", 207616, 7506},
  {"10.2", 207716, 7509},
  {"10.3", 207811, 7512},
  {"10.4", 207905, 7515},
  {"10.5", 208000, 7518},
  {"10.6", 208095, 7521},
  {"10.7", 208196, 7524},
  {"10.8", 208297, 7527},
  {"10.9", 208398, 7530},
  {"10.10", 208500, 7533},
  {"10.11", 208603, 7536},
  {"10.12", 208706, 7539},
  {"10.13", 208803, 7542},
  {"10.14", 208901, 7545},
  {"10.15", 209004, 7548},
  {"10.16", 209107, 7551},
  {"10.17", 209210, 7554},
  {"10.18", 209307, 7557},
  {"10.19", 209404, 7560},
  {"10.20", 209501, 7563},
  {"10.21", 209597, 7566},
  {"10.22", 209700, 7569},
  {"10.23", 209802, 7572},
  {"10.24", 209905, 7575},
  {"10.25", 210002, 7578},
  {"10.26", 210105, 7581},
  {"10.27", 210208, 7584},
  {"10.28", 210305, 7587},
  {"10.29", 210402, 7590},
  {"10.30", 210499, 7593},
  {"10.31", 210602, 7596},
  {"10.32", 210705, 7599},
  {"10.33", 210802, 7602},
  {"10.34", 210899, 7605},
  {"S2.5.11", 210998, 7608},
  {"11.1", 212668, 7651},
  {"11.2", 212767, 7654},
  {"11.3", 212862, 7657},
  {"11.4", 212963, 7660},
  {"11.5", 213064, 7663},
  {"11.6", 213165, 7666},
  {"11.7", 213260, 7669},
  {"11.8", 213362, 7672},
  {"11.9", 213463, 7675},
  {"S2.5.12", 213561, 7678},
  {"12.1", 216238, 7747},
  {"12.2", 216338, 7750},
  {"12.3", 216433, 7753},
  {"12.4", 216527, 7756},
  {"12.5", 216622, 7759},
  {"12.6", 216723, 7762},
  {"12.7", 216824, 7765},
  {"12.8", 216925, 7768},
  {"12.9", 217026, 7771},
  {"12.10", 217128, 7774},
  {"12.11", 217231, 7777},
  {"12.12", 217327, 7780},
  {"12.13", 217423, 7783},
  {"12.14", 217526, 7786},
  {"12.15", 217629, 7789},
  {"S2.5.13", 217734, 7792},
  {"13.1", 219333, 7833},
  {"13.2", 219433, 7836},
  {"13.3", 219527, 7839},
  {"13.4", 219622, 7842},
  {"13.5", 219723, 7845},
  {"13.6", 219824, 7848},
  {"13.7", 219919, 7851},
  {"13.8", 220014, 7854},
  {"13.9", 220115, 7857},
  {"13.10", 220217, 7860}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 139, 4, 65, "Section",
  CellTags->{"S2.5.0", "0.1"}],

Cell[CellGroupData[{
Cell[1940, 61, 88, 1, 70, "Subsection",
  CellTags->{"S2.5.1", "1.1"}],
Cell[2031, 64, 2165, 67, 70, "DefinitionBox",
  CellTags->"S2.5.1"],
Cell[4199, 133, 72, 1, 70, "Caption",
  CellTags->"S2.5.1"],
Cell[4274, 136, 236, 6, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.2"}],

Cell[CellGroupData[{
Cell[4535, 146, 79, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[4617, 150, 86, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[4718, 156, 164, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.3"}],

Cell[CellGroupData[{
Cell[4907, 164, 89, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[4999, 168, 86, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[5100, 174, 1459, 43, 70, "DefinitionBox",
  CellTags->"S2.5.1"],
Cell[6562, 219, 81, 1, 70, "Caption",
  CellTags->"S2.5.1"],
Cell[6646, 222, 129, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.4"}],

Cell[CellGroupData[{
Cell[6800, 230, 109, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[6912, 234, 87, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[7014, 240, 241, 8, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.5"}],

Cell[CellGroupData[{
Cell[7280, 252, 97, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[7380, 256, 131, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[7526, 262, 155, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.6"}],

Cell[CellGroupData[{
Cell[7706, 270, 76, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[7785, 274, 92, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[7892, 280, 357, 12, 70, "Text",
  CellTags->{"S2.5.1", "1.7"}],
Cell[8252, 294, 208, 7, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.8"}],

Cell[CellGroupData[{
Cell[8485, 305, 107, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[8595, 309, 96, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[8706, 315, 203, 6, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.9"}],

Cell[CellGroupData[{
Cell[8934, 325, 91, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[9028, 329, 98, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[9141, 335, 254, 11, 70, "Text",
  CellTags->{"S2.5.1", "1.10"}],
Cell[9398, 348, 192, 7, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.11"}],

Cell[CellGroupData[{
Cell[9615, 359, 94, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[9712, 363, 93, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[9820, 369, 139, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.12"}],

Cell[CellGroupData[{
Cell[9984, 377, 93, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[10080, 381, 95, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[10190, 387, 508, 18, 70, "Text",
  CellTags->{"S2.5.1", "1.13"}],
Cell[10701, 407, 850, 27, 70, "DefinitionBox",
  CellTags->"S2.5.1"],
Cell[11554, 436, 79, 1, 70, "Caption",
  CellTags->"S2.5.1"],
Cell[11636, 439, 200, 5, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.14"}],

Cell[CellGroupData[{
Cell[11861, 448, 98, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[11962, 452, 103, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[12080, 458, 213, 5, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.15"}],

Cell[CellGroupData[{
Cell[12318, 467, 99, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[12420, 471, 91, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[12526, 477, 91, 1, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.16"}],

Cell[CellGroupData[{
Cell[12642, 482, 110, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[12755, 486, 103, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[12873, 492, 173, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.17"}],

Cell[CellGroupData[{
Cell[13071, 500, 111, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[13185, 504, 115, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[13315, 510, 401, 10, 70, "Text",
  CellTags->{"S2.5.1", "1.18"}],
Cell[13719, 522, 810, 26, 70, "Text",
  CellTags->{"S2.5.1", "1.19"}],
Cell[14532, 550, 246, 7, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.20"}],

Cell[CellGroupData[{
Cell[14803, 561, 118, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[14924, 565, 154, 3, 70, "Message",
  CellTags->"S2.5.1"],
Cell[15081, 570, 90, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[15186, 576, 503, 17, 70, "Text",
  CellTags->{"S2.5.1", "1.21"}],
Cell[15692, 595, 588, 20, 70, "Text",
  CellTags->{"S2.5.1", "1.22"}],
Cell[16283, 617, 163, 5, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.23"}],

Cell[CellGroupData[{
Cell[16471, 626, 78, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[16552, 630, 86, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[16653, 636, 182, 5, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.24"}],

Cell[CellGroupData[{
Cell[16860, 645, 87, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[16950, 649, 83, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[17048, 655, 84, 1, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.25"}],

Cell[CellGroupData[{
Cell[17157, 660, 85, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[17245, 664, 86, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[17346, 670, 154, 5, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.26"}],

Cell[CellGroupData[{
Cell[17525, 679, 88, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[17616, 683, 86, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[17717, 689, 1547, 49, 70, "DefinitionBox",
  CellTags->"S2.5.1"],
Cell[19267, 740, 78, 1, 70, "Caption",
  CellTags->"S2.5.1"],
Cell[19348, 743, 160, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.27"}],

Cell[CellGroupData[{
Cell[19533, 751, 108, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[19644, 755, 86, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[19745, 761, 163, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.28"}],

Cell[CellGroupData[{
Cell[19933, 769, 112, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[20048, 773, 94, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[20157, 779, 193, 5, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.29"}],

Cell[CellGroupData[{
Cell[20375, 788, 107, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[20485, 792, 167, 4, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[20667, 799, 129, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.30"}],

Cell[CellGroupData[{
Cell[20821, 807, 117, 2, 70, "Input",
  CellTags->"S2.5.1"],
Cell[20941, 811, 139, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[21095, 817, 127, 4, 70, "MathCaption",
  CellTags->{"S2.5.1", "1.31"}],

Cell[CellGroupData[{
Cell[21247, 825, 147, 5, 70, "Input",
  CellTags->"S2.5.1"],
Cell[21397, 832, 124, 3, 70, "Output",
  CellTags->"S2.5.1"]
}, Open  ]],
Cell[21536, 838, 1015, 32, 70, "DefinitionBox",
  CellTags->"S2.5.1"],
Cell[22554, 872, 89, 1, 70, "Caption",
  CellTags->"S2.5.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22680, 878, 100, 1, 70, "Subsection",
  CellTags->{"S2.5.2", "2.1"}],
Cell[22783, 881, 252, 6, 70, "Text",
  CellTags->{"S2.5.2", "2.2"}],
Cell[23038, 889, 211, 5, 70, "MathCaption",
  CellTags->{"S2.5.2", "2.3"}],

Cell[CellGroupData[{
Cell[23274, 898, 101, 2, 70, "Input",
  CellTags->"S2.5.2"],
Cell[23378, 902, 117, 3, 70, "Output",
  CellTags->"S2.5.2"]
}, Open  ]],
Cell[23510, 908, 149, 4, 70, "MathCaption",
  CellTags->{"S2.5.2", "2.4"}],

Cell[CellGroupData[{
Cell[23684, 916, 90, 2, 70, "Input",
  CellTags->"S2.5.2"],
Cell[23777, 920, 124, 3, 70, "Output",
  CellTags->"S2.5.2"]
}, Open  ]],
Cell[23916, 926, 272, 6, 70, "Text",
  CellTags->{"S2.5.2", "2.5"}],
Cell[24191, 934, 341, 7, 70, "Text",
  CellTags->{"S2.5.2", "2.6"}],
Cell[24535, 943, 598, 13, 70, "Text",
  CellTags->{"S2.5.2", "2.7"}],
Cell[25136, 958, 109, 1, 70, "MathCaption",
  CellTags->{"S2.5.2", "2.8"}],

Cell[CellGroupData[{
Cell[25270, 963, 96, 2, 70, "Input",
  CellTags->"S2.5.2"],
Cell[25369, 967, 171, 4, 70, "Output",
  CellTags->"S2.5.2"]
}, Open  ]],
Cell[25555, 974, 128, 4, 70, "MathCaption",
  CellTags->{"S2.5.2", "2.9"}],

Cell[CellGroupData[{
Cell[25708, 982, 86, 2, 70, "Input",
  CellTags->"S2.5.2"],
Cell[25797, 986, 579, 16, 70, "Output",
  CellTags->"S2.5.2"]
}, Open  ]],
Cell[26391, 1005, 146, 5, 70, "MathCaption",
  CellTags->{"S2.5.2", "2.10"}],

Cell[CellGroupData[{
Cell[26562, 1014, 77, 2, 70, "Input",
  CellTags->"S2.5.2"],
Cell[26642, 1018, 83, 3, 70, "Output",
  CellTags->"S2.5.2"]
}, Open  ]],
Cell[26740, 1024, 756, 24, 70, "DefinitionBox",
  CellTags->"S2.5.2"],
Cell[27499, 1050, 77, 1, 70, "Caption",
  CellTags->"S2.5.2"],
Cell[27579, 1053, 641, 12, 70, "Text",
  CellTags->{"S2.5.2", "2.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[28257, 1070, 77, 1, 70, "Subsection",
  CellTags->{"S2.5.3", "3.1"}],
Cell[28337, 1073, 285, 7, 70, "Text",
  CellTags->{"S2.5.3", "3.2"}],
Cell[28625, 1082, 296, 6, 70, "Text",
  CellTags->{"S2.5.3", "3.3"}],
Cell[28924, 1090, 926, 31, 70, "DefinitionBox",
  CellTags->"S2.5.3"],
Cell[29853, 1123, 99, 1, 70, "Caption",
  CellTags->"S2.5.3"],
Cell[29955, 1126, 165, 5, 70, "MathCaption",
  CellTags->{"S2.5.3", "3.4"}],

Cell[CellGroupData[{
Cell[30145, 1135, 87, 2, 70, "Input",
  CellTags->"S2.5.3"],
Cell[30235, 1139, 95, 3, 70, "Output",
  CellTags->"S2.5.3"]
}, Open  ]],
Cell[30345, 1145, 258, 9, 70, "MathCaption",
  CellTags->{"S2.5.3", "3.5"}],

Cell[CellGroupData[{
Cell[30628, 1158, 73, 2, 70, "Input",
  CellTags->"S2.5.3"],
Cell[30704, 1162, 86, 3, 70, "Output",
  CellTags->"S2.5.3"]
}, Open  ]],
Cell[30805, 1168, 134, 5, 70, "MathCaption",
  CellTags->{"S2.5.3", "3.6"}],

Cell[CellGroupData[{
Cell[30964, 1177, 73, 2, 70, "Input",
  CellTags->"S2.5.3"],
Cell[31040, 1181, 95, 3, 70, "Output",
  CellTags->"S2.5.3"]
}, Open  ]],
Cell[31150, 1187, 419, 12, 70, "Text",
  CellTags->{"S2.5.3", "3.7"}],
Cell[31572, 1201, 439, 10, 70, "Text",
  CellTags->{"S2.5.3", "3.8"}],
Cell[32014, 1213, 502, 12, 70, "Text",
  CellTags->{"S2.5.3", "3.9"}],
Cell[32519, 1227, 625, 19, 70, "Text",
  CellTags->{"S2.5.3", "3.10"}],
Cell[33147, 1248, 676, 15, 70, "Text",
  CellTags->{"S2.5.3", "3.11"}],
Cell[33826, 1265, 1098, 37, 70, "DefinitionBox",
  CellTags->"S2.5.3"],
Cell[34927, 1304, 63, 1, 70, "Caption",
  CellTags->"S2.5.3"],
Cell[34993, 1307, 194, 5, 70, "MathCaption",
  CellTags->{"S2.5.3", "3.12"}],

Cell[CellGroupData[{
Cell[35212, 1316, 81, 2, 70, "Input",
  CellTags->"S2.5.3"],
Cell[35296, 1320, 115, 3, 70, "Output",
  CellTags->"S2.5.3"]
}, Open  ]],
Cell[35426, 1326, 137, 5, 70, "MathCaption",
  CellTags->{"S2.5.3", "3.13"}],
Cell[35566, 1333, 72, 2, 70, "Input",
  CellTags->"S2.5.3"],
Cell[35641, 1337, 93, 1, 70, "MathCaption",
  CellTags->{"S2.5.3", "3.14"}],

Cell[CellGroupData[{
Cell[35759, 1342, 81, 2, 70, "Input",
  CellTags->"S2.5.3"],
Cell[35843, 1346, 110, 3, 70, "Output",
  CellTags->"S2.5.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36002, 1355, 86, 1, 70, "Subsection",
  CellTags->{"S2.5.4", "4.1"}],
Cell[36091, 1358, 586, 16, 70, "Text",
  CellTags->{"S2.5.4", "4.2"}],
Cell[36680, 1376, 2810, 100, 70, "DefinitionBox",
  CellTags->"S2.5.4"],
Cell[39493, 1478, 72, 1, 70, "Caption",
  CellTags->"S2.5.4"],
Cell[39568, 1481, 171, 7, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.3"}],

Cell[CellGroupData[{
Cell[39764, 1492, 70, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[39837, 1496, 85, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[39937, 1502, 165, 7, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.4"}],

Cell[CellGroupData[{
Cell[40127, 1513, 72, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[40202, 1517, 86, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[40303, 1523, 132, 5, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.5"}],

Cell[CellGroupData[{
Cell[40460, 1532, 65, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[40528, 1536, 86, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[40629, 1542, 278, 11, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.6"}],

Cell[CellGroupData[{
Cell[40932, 1557, 80, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[41015, 1561, 83, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[41113, 1567, 219, 9, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.7"}],

Cell[CellGroupData[{
Cell[41357, 1580, 89, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[41449, 1584, 56, 2, 70, "Print",
  CellTags->"S2.5.4"],
Cell[41508, 1588, 56, 2, 70, "Print",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[41579, 1593, 210, 9, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.8"}],

Cell[CellGroupData[{
Cell[41814, 1606, 89, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[41906, 1610, 56, 2, 70, "Print",
  CellTags->"S2.5.4"],
Cell[41965, 1614, 56, 2, 70, "Print",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[42036, 1619, 2475, 80, 70, "DefinitionBox",
  CellTags->"S2.5.4"],
Cell[44514, 1701, 90, 1, 70, "Caption",
  CellTags->"S2.5.4"],
Cell[44607, 1704, 242, 11, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.9"}],

Cell[CellGroupData[{
Cell[44874, 1719, 79, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[44956, 1723, 87, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[45058, 1729, 186, 7, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.10"}],

Cell[CellGroupData[{
Cell[45269, 1740, 79, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[45351, 1744, 87, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[45453, 1750, 146, 7, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.11"}],

Cell[CellGroupData[{
Cell[45624, 1761, 65, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[45692, 1765, 82, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[45789, 1771, 146, 7, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.12"}],

Cell[CellGroupData[{
Cell[45960, 1782, 66, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[46029, 1786, 83, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[46127, 1792, 141, 4, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.13"}],

Cell[CellGroupData[{
Cell[46293, 1800, 120, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[46416, 1804, 91, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[46522, 1810, 341, 10, 70, "Text",
  CellTags->{"S2.5.4", "4.14"}],
Cell[46866, 1822, 1545, 51, 70, "DefinitionBox",
  CellTags->"S2.5.4"],
Cell[48414, 1875, 74, 1, 70, "Caption",
  CellTags->"S2.5.4"],
Cell[48491, 1878, 237, 11, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.15"}],

Cell[CellGroupData[{
Cell[48753, 1893, 78, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[48834, 1897, 91, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[48940, 1903, 174, 7, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.16"}],

Cell[CellGroupData[{
Cell[49139, 1914, 80, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[49222, 1918, 95, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[49332, 1924, 137, 5, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.17"}],

Cell[CellGroupData[{
Cell[49494, 1933, 66, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[49563, 1937, 95, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[49673, 1943, 889, 29, 70, "Text",
  CellTags->{"S2.5.4", "4.18"}],
Cell[50565, 1974, 161, 5, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.19"}],

Cell[CellGroupData[{
Cell[50751, 1983, 106, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[50860, 1987, 106, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]],
Cell[50981, 1993, 145, 5, 70, "MathCaption",
  CellTags->{"S2.5.4", "4.20"}],

Cell[CellGroupData[{
Cell[51151, 2002, 75, 2, 70, "Input",
  CellTags->"S2.5.4"],
Cell[51229, 2006, 98, 3, 70, "Output",
  CellTags->"S2.5.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51376, 2015, 97, 1, 70, "Subsection",
  CellTags->{"S2.5.5", "5.1"}],
Cell[51476, 2018, 1107, 41, 70, "Text",
  CellTags->{"S2.5.5", "5.2"}],
Cell[52586, 2061, 356, 10, 70, "Text",
  CellTags->{"S2.5.5", "5.3"}],
Cell[52945, 2073, 129, 5, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.4"}],

Cell[CellGroupData[{
Cell[53099, 2082, 72, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[53174, 2086, 82, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[53271, 2092, 129, 5, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.5"}],

Cell[CellGroupData[{
Cell[53425, 2101, 72, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[53500, 2105, 82, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[53597, 2111, 185, 6, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.6"}],

Cell[CellGroupData[{
Cell[53807, 2121, 66, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[53876, 2125, 65, 2, 70, "Print",
  CellTags->"S2.5.5"],
Cell[53944, 2129, 463, 15, 70, "Print",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[54422, 2147, 247, 9, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.7"}],

Cell[CellGroupData[{
Cell[54694, 2160, 72, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[54769, 2164, 82, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[54866, 2170, 191, 7, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.8"}],

Cell[CellGroupData[{
Cell[55082, 2181, 83, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[55168, 2185, 102, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[55285, 2191, 319, 8, 70, "Text",
  CellTags->{"S2.5.5", "5.9"}],
Cell[55607, 2201, 2192, 68, 70, "DefinitionBox",
  CellTags->"S2.5.5"],
Cell[57802, 2271, 73, 1, 70, "Caption",
  CellTags->"S2.5.5"],
Cell[57878, 2274, 561, 16, 70, "Text",
  CellTags->{"S2.5.5", "5.10"}],
Cell[58442, 2292, 313, 9, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.11"}],

Cell[CellGroupData[{
Cell[58780, 2305, 80, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[58863, 2309, 82, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[58960, 2315, 193, 5, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.12"}],

Cell[CellGroupData[{
Cell[59178, 2324, 84, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[59265, 2328, 85, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[59365, 2334, 149, 5, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.13"}],

Cell[CellGroupData[{
Cell[59539, 2343, 69, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[59611, 2347, 68, 2, 70, "Print",
  CellTags->"S2.5.5"],
Cell[59682, 2351, 487, 15, 70, "Print",
  CellTags->"S2.5.5"]
}, Open  ]],
Cell[60184, 2369, 204, 6, 70, "MathCaption",
  CellTags->{"S2.5.5", "5.14"}],

Cell[CellGroupData[{
Cell[60413, 2379, 95, 2, 70, "Input",
  CellTags->"S2.5.5"],
Cell[60511, 2383, 99, 3, 70, "Output",
  CellTags->"S2.5.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60659, 2392, 91, 1, 70, "Subsection",
  CellTags->{"S2.5.6", "6.1"}],
Cell[60753, 2395, 896, 33, 70, "Text",
  CellTags->{"S2.5.6", "6.2"}],
Cell[61652, 2430, 698, 23, 70, "Text",
  CellTags->{"S2.5.6", "6.3"}],
Cell[62353, 2455, 865, 33, 70, "Text",
  CellTags->{"S2.5.6", "6.4"}],
Cell[63221, 2490, 508, 15, 70, "Text",
  CellTags->{"S2.5.6", "6.5"}],
Cell[63732, 2507, 1162, 38, 70, "DefinitionBox",
  CellTags->"S2.5.6"],
Cell[64897, 2547, 119, 4, 70, "Caption",
  CellTags->"S2.5.6"],
Cell[65019, 2553, 660, 15, 70, "Text",
  CellTags->{"S2.5.6", "6.6"}],
Cell[65682, 2570, 496, 16, 70, "Text",
  CellTags->{"S2.5.6", "6.7"}],
Cell[66181, 2588, 195, 7, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.8"}],

Cell[CellGroupData[{
Cell[66401, 2599, 72, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[66476, 2603, 82, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]],
Cell[66573, 2609, 332, 11, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.9"}],

Cell[CellGroupData[{
Cell[66930, 2624, 75, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[67008, 2628, 89, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]],
Cell[67112, 2634, 237, 7, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.10"}],

Cell[CellGroupData[{
Cell[67374, 2645, 75, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[67452, 2649, 85, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]],
Cell[67552, 2655, 330, 11, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.11"}],

Cell[CellGroupData[{
Cell[67907, 2670, 75, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[67985, 2674, 89, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]],
Cell[68089, 2680, 135, 5, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.12"}],
Cell[68227, 2687, 72, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[68302, 2691, 372, 11, 70, "Text",
  CellTags->{"S2.5.6", "6.13"}],
Cell[68677, 2704, 516, 14, 70, "Text",
  CellTags->{"S2.5.6", "6.14"}],
Cell[69196, 2720, 916, 40, 70, "Text",
  CellTags->{"S2.5.6", "6.15"}],
Cell[70115, 2762, 126, 4, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.16"}],

Cell[CellGroupData[{
Cell[70266, 2770, 72, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[70341, 2774, 82, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]],
Cell[70438, 2780, 132, 4, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.17"}],
Cell[70573, 2786, 81, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[70657, 2790, 142, 4, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.18"}],

Cell[CellGroupData[{
Cell[70824, 2798, 69, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[70896, 2802, 88, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]],
Cell[70999, 2808, 149, 4, 70, "MathCaption",
  CellTags->{"S2.5.6", "6.19"}],

Cell[CellGroupData[{
Cell[71173, 2816, 67, 2, 70, "Input",
  CellTags->"S2.5.6"],
Cell[71243, 2820, 88, 3, 70, "Output",
  CellTags->"S2.5.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71380, 2829, 86, 1, 70, "Subsection",
  CellTags->{"S2.5.7", "7.1"}],
Cell[71469, 2832, 405, 9, 70, "Text",
  CellTags->{"S2.5.7", "7.2"}],
Cell[71877, 2843, 1011, 27, 70, "Text",
  CellTags->{"S2.5.7", "7.3"}],
Cell[72891, 2872, 424, 13, 70, "FramedBox",
  CellTags->"S2.5.7"],
Cell[73318, 2887, 126, 5, 70, "Caption",
  CellTags->"S2.5.7"],
Cell[73447, 2894, 692, 20, 70, "Text",
  CellTags->{"S2.5.7", "7.4"}],
Cell[74142, 2916, 138, 5, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.5"}],
Cell[74283, 2923, 81, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[74367, 2927, 146, 5, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.6"}],

Cell[CellGroupData[{
Cell[74538, 2936, 72, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[74613, 2940, 82, 3, 70, "Output",
  CellTags->"S2.5.7"]
}, Open  ]],
Cell[74710, 2946, 150, 4, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.7"}],

Cell[CellGroupData[{
Cell[74885, 2954, 66, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[74954, 2958, 65, 2, 70, "Print",
  CellTags->"S2.5.7"],
Cell[75022, 2962, 475, 15, 70, "Print",
  CellTags->"S2.5.7"]
}, Open  ]],
Cell[75512, 2980, 342, 7, 70, "Text",
  CellTags->{"S2.5.7", "7.8"}],
Cell[75857, 2989, 107, 1, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.9"}],
Cell[75967, 2992, 118, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[76088, 2996, 150, 4, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.10"}],

Cell[CellGroupData[{
Cell[76263, 3004, 68, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[76334, 3008, 67, 2, 70, "Print",
  CellTags->"S2.5.7"],
Cell[76404, 3012, 503, 15, 70, "Print",
  CellTags->"S2.5.7"]
}, Open  ]],
Cell[76922, 3030, 183, 7, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.11"}],
Cell[77108, 3039, 90, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[77201, 3043, 156, 4, 70, "MathCaption",
  CellTags->{"S2.5.7", "7.12"}],

Cell[CellGroupData[{
Cell[77382, 3051, 68, 2, 70, "Input",
  CellTags->"S2.5.7"],
Cell[77453, 3055, 67, 2, 70, "Print",
  CellTags->"S2.5.7"],
Cell[77523, 3059, 577, 17, 70, "Print",
  CellTags->"S2.5.7"]
}, Open  ]],
Cell[78115, 3079, 590, 13, 70, "Text",
  CellTags->{"S2.5.7", "7.13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[78742, 3097, 92, 1, 70, "Subsection",
  CellTags->{"S2.5.8", "8.1"}],
Cell[78837, 3100, 1112, 45, 70, "Text",
  CellTags->{"S2.5.8", "8.2"}],
Cell[79952, 3147, 989, 30, 70, "DefinitionBox",
  CellTags->"S2.5.8"],
Cell[80944, 3179, 130, 5, 70, "Caption",
  CellTags->"S2.5.8"],
Cell[81077, 3186, 179, 7, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.3"}],
Cell[81259, 3195, 91, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[81353, 3199, 172, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.4"}],

Cell[CellGroupData[{
Cell[81550, 3208, 67, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[81620, 3212, 66, 2, 70, "Print",
  CellTags->"S2.5.8"],
Cell[81689, 3216, 433, 13, 70, "Print",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[82137, 3232, 201, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.5"}],

Cell[CellGroupData[{
Cell[82363, 3241, 91, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[82457, 3245, 96, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[82568, 3251, 161, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.6"}],

Cell[CellGroupData[{
Cell[82754, 3260, 68, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[82825, 3264, 67, 2, 70, "Print",
  CellTags->"S2.5.8"],
Cell[82895, 3268, 427, 13, 70, "Print",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[83337, 3284, 172, 7, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.7"}],

Cell[CellGroupData[{
Cell[83534, 3295, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[83610, 3299, 96, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[83721, 3305, 189, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.8"}],

Cell[CellGroupData[{
Cell[83935, 3314, 74, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[84012, 3318, 116, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[84143, 3324, 314, 8, 70, "Text",
  CellTags->{"S2.5.8", "8.9"}],
Cell[84460, 3334, 588, 15, 70, "Text",
  CellTags->{"S2.5.8", "8.10"}],
Cell[85051, 3351, 1782, 58, 70, "DefinitionBox",
  CellTags->"S2.5.8"],
Cell[86836, 3411, 173, 7, 70, "Caption",
  CellTags->"S2.5.8"],
Cell[87012, 3420, 802, 24, 70, "Text",
  CellTags->{"S2.5.8", "8.11"}],
Cell[87817, 3446, 134, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.12"}],

Cell[CellGroupData[{
Cell[87976, 3455, 83, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[88062, 3459, 103, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[88180, 3465, 190, 6, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.13"}],

Cell[CellGroupData[{
Cell[88395, 3475, 76, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[88474, 3479, 103, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[88592, 3485, 231, 11, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.14"}],

Cell[CellGroupData[{
Cell[88848, 3500, 75, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[88926, 3504, 111, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[89052, 3510, 369, 10, 70, "Text",
  CellTags->{"S2.5.8", "8.15"}],
Cell[89424, 3522, 748, 23, 70, "DefinitionBox",
  CellTags->"S2.5.8"],
Cell[90175, 3547, 88, 1, 70, "Caption",
  CellTags->"S2.5.8"],
Cell[90266, 3550, 767, 29, 70, "Text",
  CellTags->{"S2.5.8", "8.16"}],
Cell[91036, 3581, 243, 9, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.17"}],

Cell[CellGroupData[{
Cell[91304, 3594, 79, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[91386, 3598, 103, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[91504, 3604, 253, 9, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.18"}],
Cell[91760, 3615, 80, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[91843, 3619, 158, 7, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.19"}],

Cell[CellGroupData[{
Cell[92026, 3630, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[92102, 3634, 125, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[92242, 3640, 230, 7, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.20"}],

Cell[CellGroupData[{
Cell[92497, 3651, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[92573, 3655, 126, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[92714, 3661, 181, 4, 70, "Text",
  CellTags->{"S2.5.8", "8.21"}],
Cell[92898, 3667, 151, 7, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.22"}],

Cell[CellGroupData[{
Cell[93074, 3678, 70, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[93147, 3682, 83, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[93245, 3688, 314, 13, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.23"}],

Cell[CellGroupData[{
Cell[93584, 3705, 75, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[93662, 3709, 83, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[93760, 3715, 291, 12, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.24"}],
Cell[94054, 3729, 76, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[94133, 3733, 173, 7, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.25"}],

Cell[CellGroupData[{
Cell[94331, 3744, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[94407, 3748, 88, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[94510, 3754, 130, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.26"}],

Cell[CellGroupData[{
Cell[94665, 3763, 70, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[94738, 3767, 83, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[94836, 3773, 223, 9, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.27"}],

Cell[CellGroupData[{
Cell[95084, 3786, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[95160, 3790, 88, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[95263, 3796, 511, 16, 70, "Text",
  CellTags->{"S2.5.8", "8.28"}],
Cell[95777, 3814, 157, 4, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.29"}],
Cell[95937, 3820, 90, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[96030, 3824, 218, 9, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.30"}],

Cell[CellGroupData[{
Cell[96273, 3837, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[96349, 3841, 132, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[96496, 3847, 112, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.31"}],

Cell[CellGroupData[{
Cell[96633, 3856, 73, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[96709, 3860, 169, 4, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[96893, 3867, 658, 13, 70, "Text",
  CellTags->{"S2.5.8", "8.32"}],
Cell[97554, 3882, 873, 28, 70, "DefinitionBox",
  CellTags->"S2.5.8"],
Cell[98430, 3912, 135, 5, 70, "Caption",
  CellTags->"S2.5.8"],
Cell[98568, 3919, 230, 5, 70, "Text",
  CellTags->{"S2.5.8", "8.33"}],
Cell[98801, 3926, 143, 4, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.34"}],

Cell[CellGroupData[{
Cell[98969, 3934, 91, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[99063, 3938, 111, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[99189, 3944, 109, 1, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.35"}],

Cell[CellGroupData[{
Cell[99323, 3949, 83, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[99409, 3953, 97, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[99521, 3959, 195, 5, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.36"}],

Cell[CellGroupData[{
Cell[99741, 3968, 83, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[99827, 3972, 112, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[99954, 3978, 106, 1, 70, "MathCaption",
  CellTags->{"S2.5.8", "8.37"}],

Cell[CellGroupData[{
Cell[100085, 3983, 99, 2, 70, "Input",
  CellTags->"S2.5.8"],
Cell[100187, 3987, 97, 3, 70, "Output",
  CellTags->"S2.5.8"]
}, Open  ]],
Cell[100299, 3993, 318, 8, 70, "Text",
  CellTags->{"S2.5.8", "8.38"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[100654, 4006, 105, 1, 70, "Subsection",
  CellTags->{"S2.5.9", "9.1"}],
Cell[100762, 4009, 535, 11, 70, "Text",
  CellTags->{"S2.5.9", "9.2"}],
Cell[101300, 4022, 741, 23, 70, "DefinitionBox",
  CellTags->"S2.5.9"],
Cell[102044, 4047, 93, 1, 70, "Caption",
  CellTags->"S2.5.9"],
Cell[102140, 4050, 163, 5, 70, "MathCaption",
  CellTags->{"S2.5.9", "9.3"}],
Cell[102306, 4057, 99, 2, 70, "Input",
  CellTags->"S2.5.9"],
Cell[102408, 4061, 156, 5, 70, "MathCaption",
  CellTags->{"S2.5.9", "9.4"}],

Cell[CellGroupData[{
Cell[102589, 4070, 79, 2, 70, "Input",
  CellTags->"S2.5.9"],
Cell[102671, 4074, 82, 3, 70, "Output",
  CellTags->"S2.5.9"]
}, Open  ]],
Cell[102768, 4080, 136, 5, 70, "MathCaption",
  CellTags->{"S2.5.9", "9.5"}],

Cell[CellGroupData[{
Cell[102929, 4089, 66, 2, 70, "Input",
  CellTags->"S2.5.9"],
Cell[102998, 4093, 65, 2, 70, "Print",
  CellTags->"S2.5.9"],
Cell[103066, 4097, 549, 17, 70, "Print",
  CellTags->"S2.5.9"]
}, Open  ]],
Cell[103630, 4117, 352, 14, 70, "MathCaption",
  CellTags->{"S2.5.9", "9.6"}],

Cell[CellGroupData[{
Cell[104007, 4135, 68, 2, 70, "Input",
  CellTags->"S2.5.9"],
Cell[104078, 4139, 82, 3, 70, "Output",
  CellTags->"S2.5.9"]
}, Open  ]],
Cell[104175, 4145, 154, 5, 70, "MathCaption",
  CellTags->{"S2.5.9", "9.7"}],

Cell[CellGroupData[{
Cell[104354, 4154, 66, 2, 70, "Input",
  CellTags->"S2.5.9"],
Cell[104423, 4158, 65, 2, 70, "Print",
  CellTags->"S2.5.9"],
Cell[104491, 4162, 769, 25, 70, "Print",
  CellTags->"S2.5.9"]
}, Open  ]],
Cell[105275, 4190, 242, 8, 70, "MathCaption",
  CellTags->{"S2.5.9", "9.8"}],

Cell[CellGroupData[{
Cell[105542, 4202, 68, 2, 70, "Input",
  CellTags->"S2.5.9"],
Cell[105613, 4206, 82, 3, 70, "Output",
  CellTags->"S2.5.9"]
}, Open  ]],
Cell[105710, 4212, 969, 41, 70, "Text",
  CellTags->{"S2.5.9", "9.9"}],
Cell[106682, 4255, 2355, 74, 70, "Text",
  CellTags->{"S2.5.9", "9.10"}],
Cell[109040, 4331, 427, 8, 70, "Text",
  CellTags->{"S2.5.9", "9.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[109504, 4344, 108, 1, 70, "Subsection",
  CellTags->{"S2.5.10", "10.1"}],
Cell[109615, 4347, 876, 35, 70, "Text",
  CellTags->{"S2.5.10", "10.2"}],
Cell[110494, 4384, 258, 7, 70, "Text",
  CellTags->{"S2.5.10", "10.3"}],
Cell[110755, 4393, 491, 15, 70, "Text",
  CellTags->{"S2.5.10", "10.4"}],
Cell[111249, 4410, 326, 13, 70, "Text",
  CellTags->{"S2.5.10", "10.5"}],
Cell[111578, 4425, 1266, 42, 70, "DefinitionBox",
  CellTags->"S2.5.10"],
Cell[112847, 4469, 90, 1, 70, "Caption",
  CellTags->"S2.5.10"],
Cell[112940, 4472, 161, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.6"}],
Cell[113104, 4479, 82, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[113189, 4483, 149, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.7"}],

Cell[CellGroupData[{
Cell[113363, 4492, 67, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[113433, 4496, 66, 2, 70, "Print",
  CellTags->"S2.5.10"],
Cell[113502, 4500, 418, 13, 70, "Print",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[113935, 4516, 131, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.8"}],
Cell[114069, 4523, 87, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[114159, 4527, 137, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.9"}],

Cell[CellGroupData[{
Cell[114321, 4536, 67, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[114391, 4540, 66, 2, 70, "Print",
  CellTags->"S2.5.10"],
Cell[114460, 4544, 435, 13, 70, "Print",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[114910, 4560, 132, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.10"}],

Cell[CellGroupData[{
Cell[115067, 4569, 70, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[115140, 4573, 93, 2, 70, "Print",
  CellTags->"S2.5.10"],
Cell[115236, 4577, 321, 9, 70, "Print",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[115572, 4589, 109, 1, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.11"}],

Cell[CellGroupData[{
Cell[115706, 4594, 74, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[115783, 4598, 89, 3, 70, "Output",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[115887, 4604, 502, 16, 70, "Text",
  CellTags->{"S2.5.10", "10.12"}],
Cell[116392, 4622, 1186, 42, 70, "Text",
  CellTags->{"S2.5.10", "10.13"}],
Cell[117581, 4666, 148, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.14"}],
Cell[117732, 4673, 97, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[117832, 4677, 140, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.15"}],

Cell[CellGroupData[{
Cell[117997, 4686, 67, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[118067, 4690, 66, 2, 70, "Print",
  CellTags->"S2.5.10"],
Cell[118136, 4694, 511, 15, 70, "Print",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[118662, 4712, 160, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.16"}],

Cell[CellGroupData[{
Cell[118847, 4721, 76, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[118926, 4725, 93, 3, 70, "Output",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[119034, 4731, 487, 18, 70, "Text",
  CellTags->{"S2.5.10", "10.17"}],
Cell[119524, 4751, 709, 21, 70, "Text",
  CellTags->{"S2.5.10", "10.18"}],
Cell[120236, 4774, 655, 23, 70, "Text",
  CellTags->{"S2.5.10", "10.19"}],
Cell[120894, 4799, 3218, 98, 70, "DefinitionBox",
  CellTags->"S2.5.10"],
Cell[124115, 4899, 75, 1, 70, "Caption",
  CellTags->"S2.5.10"],
Cell[124193, 4902, 347, 7, 70, "Text",
  CellTags->{"S2.5.10", "10.20"}],
Cell[124543, 4911, 158, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.21"}],

Cell[CellGroupData[{
Cell[124726, 4920, 83, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[124812, 4924, 84, 3, 70, "Output",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[124911, 4930, 99, 1, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.22"}],

Cell[CellGroupData[{
Cell[125035, 4935, 88, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[125126, 4939, 84, 3, 70, "Output",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[125225, 4945, 161, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.23"}],

Cell[CellGroupData[{
Cell[125411, 4954, 73, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[125487, 4958, 71, 2, 70, "Print",
  CellTags->"S2.5.10"],
Cell[125561, 4962, 492, 15, 70, "Print",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[126068, 4980, 691, 21, 70, "Text",
  CellTags->{"S2.5.10", "10.24"}],
Cell[126762, 5003, 177, 5, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.25"}],
Cell[126942, 5010, 98, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[127043, 5014, 200, 6, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.26"}],

Cell[CellGroupData[{
Cell[127268, 5024, 97, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[127368, 5028, 215, 4, 70, "Message",
  CellTags->"S2.5.10"],
Cell[127586, 5034, 90, 3, 70, "Output",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[127691, 5040, 2986, 107, 70, "DefinitionBox",
  CellTags->"S2.5.10"],
Cell[130680, 5149, 89, 1, 70, "Caption",
  CellTags->"S2.5.10"],
Cell[130772, 5152, 759, 22, 70, "Text",
  CellTags->{"S2.5.10", "10.27"}],
Cell[131534, 5176, 514, 13, 70, "Text",
  CellTags->{"S2.5.10", "10.28"}],
Cell[132051, 5191, 424, 13, 70, "Text",
  CellTags->{"S2.5.10", "10.29"}],
Cell[132478, 5206, 184, 7, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.30"}],
Cell[132665, 5215, 101, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[132769, 5219, 133, 4, 70, "MathCaption",
  CellTags->{"S2.5.10", "10.31"}],

Cell[CellGroupData[{
Cell[132927, 5227, 93, 2, 70, "Input",
  CellTags->"S2.5.10"],
Cell[133023, 5231, 98, 3, 70, "Output",
  CellTags->"S2.5.10"]
}, Open  ]],
Cell[133136, 5237, 544, 16, 70, "Text",
  CellTags->{"S2.5.10", "10.32"}],
Cell[133683, 5255, 627, 16, 70, "Text",
  CellTags->{"S2.5.10", "10.33"}],
Cell[134313, 5273, 568, 12, 70, "Text",
  CellTags->{"S2.5.10", "10.34"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[134918, 5290, 87, 1, 70, "Subsection",
  CellTags->{"S2.5.11", "11.1"}],
Cell[135008, 5293, 452, 14, 70, "Text",
  CellTags->{"S2.5.11", "11.2"}],
Cell[135463, 5309, 833, 25, 70, "DefinitionBox",
  CellTags->"S2.5.11"],
Cell[136299, 5336, 82, 1, 70, "Caption",
  CellTags->"S2.5.11"],
Cell[136384, 5339, 151, 5, 70, "MathCaption",
  CellTags->{"S2.5.11", "11.3"}],
Cell[136538, 5346, 99, 2, 70, "Input",
  CellTags->"S2.5.11"],
Cell[136640, 5350, 223, 7, 70, "MathCaption",
  CellTags->{"S2.5.11", "11.4"}],

Cell[CellGroupData[{
Cell[136888, 5361, 76, 2, 70, "Input",
  CellTags->"S2.5.11"],
Cell[136967, 5365, 93, 3, 70, "Output",
  CellTags->"S2.5.11"]
}, Open  ]],
Cell[137075, 5371, 207, 5, 70, "MathCaption",
  CellTags->{"S2.5.11", "11.5"}],

Cell[CellGroupData[{
Cell[137307, 5380, 69, 2, 70, "Input",
  CellTags->"S2.5.11"],
Cell[137379, 5384, 101, 3, 70, "Output",
  CellTags->"S2.5.11"]
}, Open  ]],
Cell[137495, 5390, 327, 10, 70, "Text",
  CellTags->{"S2.5.11", "11.6"}],
Cell[137825, 5402, 1274, 40, 70, "DefinitionBox",
  CellTags->"S2.5.11"],
Cell[139102, 5444, 114, 4, 70, "Caption",
  CellTags->"S2.5.11"],
Cell[139219, 5450, 330, 13, 70, "MathCaption",
  CellTags->{"S2.5.11", "11.7"}],
Cell[139552, 5465, 136, 5, 70, "Input",
  CellTags->"S2.5.11"],
Cell[139691, 5472, 198, 5, 70, "MathCaption",
  CellTags->{"S2.5.11", "11.8"}],

Cell[CellGroupData[{
Cell[139914, 5481, 77, 2, 70, "Input",
  CellTags->"S2.5.11"],
Cell[139994, 5485, 137, 3, 70, "Output",
  CellTags->"S2.5.11"]
}, Open  ]],
Cell[140146, 5491, 426, 13, 70, "Text",
  CellTags->{"S2.5.11", "11.9"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[140609, 5509, 106, 3, 70, "Subsection",
  CellTags->{"S2.5.12", "12.1"}],
Cell[140718, 5514, 498, 12, 70, "Text",
  CellTags->{"S2.5.12", "12.2"}],
Cell[141219, 5528, 336, 8, 70, "Text",
  CellTags->{"S2.5.12", "12.3"}],
Cell[141558, 5538, 506, 10, 70, "Text",
  CellTags->{"S2.5.12", "12.4"}],
Cell[142067, 5550, 610, 18, 70, "DefinitionBox",
  CellTags->"S2.5.12"],
Cell[142680, 5570, 68, 1, 70, "Caption",
  CellTags->"S2.5.12"],
Cell[142751, 5573, 194, 5, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.5"}],

Cell[CellGroupData[{
Cell[142970, 5582, 75, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[143048, 5586, 139, 3, 70, "Message",
  CellTags->"S2.5.12"],
Cell[143190, 5591, 83, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]],
Cell[143288, 5597, 133, 5, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.6"}],

Cell[CellGroupData[{
Cell[143446, 5606, 79, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[143528, 5610, 89, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]],
Cell[143632, 5616, 283, 7, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.7"}],

Cell[CellGroupData[{
Cell[143940, 5627, 75, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[144018, 5631, 83, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]],
Cell[144116, 5637, 199, 5, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.8"}],

Cell[CellGroupData[{
Cell[144340, 5646, 80, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[144423, 5650, 92, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]],
Cell[144530, 5656, 147, 5, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.9"}],
Cell[144680, 5663, 74, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[144757, 5667, 139, 5, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.10"}],

Cell[CellGroupData[{
Cell[144921, 5676, 77, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[145001, 5680, 89, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]],
Cell[145105, 5686, 299, 8, 70, "Text",
  CellTags->{"S2.5.12", "12.11"}],
Cell[145407, 5696, 377, 8, 70, "Text",
  CellTags->{"S2.5.12", "12.12"}],
Cell[145787, 5706, 210, 7, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.13"}],

Cell[CellGroupData[{
Cell[146022, 5717, 76, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[146101, 5721, 83, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]],
Cell[146199, 5727, 230, 7, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.14"}],
Cell[146432, 5736, 144, 5, 70, "Input",
  CellTags->"S2.5.12"],
Cell[146579, 5743, 128, 4, 70, "MathCaption",
  CellTags->{"S2.5.12", "12.15"}],

Cell[CellGroupData[{
Cell[146732, 5751, 76, 2, 70, "Input",
  CellTags->"S2.5.12"],
Cell[146811, 5755, 91, 3, 70, "Output",
  CellTags->"S2.5.12"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[146951, 5764, 102, 1, 70, "Subsection",
  CellTags->{"S2.5.13", "13.1"}],
Cell[147056, 5767, 1655, 54, 70, "DefinitionBox",
  CellTags->"S2.5.13"],
Cell[148714, 5823, 81, 1, 70, "Caption",
  CellTags->"S2.5.13"],
Cell[148798, 5826, 271, 6, 40, "Text",
  CellTags->{"S2.5.13", "13.2"}],
Cell[149072, 5834, 510, 16, 70, "Text",
  CellTags->{"S2.5.13", "13.3"}],
Cell[149585, 5852, 128, 5, 40, "MathCaption",
  CellTags->{"S2.5.13", "13.4"}],
Cell[149716, 5859, 77, 2, 28, "Input",
  CellTags->"S2.5.13"],
Cell[149796, 5863, 179, 6, 40, "MathCaption",
  CellTags->{"S2.5.13", "13.5"}],

Cell[CellGroupData[{
Cell[150000, 5873, 78, 2, 28, "Input",
  CellTags->"S2.5.13"],
Cell[150081, 5877, 122, 3, 27, "Output",
  CellTags->"S2.5.13"]
}, Open  ]],
Cell[150218, 5883, 453, 11, 72, "Text",
  CellTags->{"S2.5.13", "13.6"}],
Cell[150674, 5896, 656, 19, 88, "Text",
  CellTags->{"S2.5.13", "13.7"}],
Cell[151333, 5917, 162, 5, 40, "MathCaption",
  CellTags->{"S2.5.13", "13.8"}],
Cell[151498, 5924, 110, 2, 28, "Input",
  CellTags->"S2.5.13"],
Cell[151611, 5928, 116, 2, 40, "MathCaption",
  CellTags->{"S2.5.13", "13.9"}],

Cell[CellGroupData[{
Cell[151752, 5934, 78, 2, 28, "Input",
  CellTags->"S2.5.13"],
Cell[151833, 5938, 186, 4, 41, "Output",
  CellTags->"S2.5.13"]
}, Open  ]],
Cell[152034, 5945, 151, 5, 40, "MathCaption",
  CellTags->{"S2.5.13", "13.10"}],

Cell[CellGroupData[{
Cell[152210, 5954, 103, 2, 28, "Input",
  CellTags->"S2.5.13"],
Cell[152316, 5958, 186, 4, 41, "Output",
  CellTags->"S2.5.13"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

