(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    363209,      13905]*)
(*NotebookOutlinePosition[    513150,      18168]*)
(*  CellTagsIndexPosition[    499747,      17672]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.6 ", "HeadingNumber"],
  "Evaluation of Expressions"
}], "Section",
  CellTags->{"S2.6.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.6.1 Principles of Evaluation", "Subsection",
  CellTags->{"S2.6.1", "1.1"}],

Cell[TextData[{
  "The fundamental operation that ",
  StyleBox["Mathematica", "TI"],
  " performs is ",
  StyleBox["evaluation", "TI"],
  ". Whenever you enter an expression, ",
  StyleBox["Mathematica", "TI"],
  " evaluates the expression, then returns the result. "
}], "Text",
  CellTags->{"S2.6.1", "1.2"}],

Cell[TextData[{
  "Evaluation in ",
  StyleBox["Mathematica", "TI"],
  " works by applying a sequence of definitions. The definitions can either \
be ones you explicitly entered, or ones that are built into ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.1", "1.3"}],

Cell[TextData[{
  "Thus, for example, ",
  StyleBox["Mathematica", "TI"],
  " evaluates the expression ",
  StyleBox["6", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["7", "MR"],
  " using a built\[Hyphen]in procedure for adding integers. Similarly, ",
  StyleBox["Mathematica", "TI"],
  " evaluates the algebraic expression ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " using a built\[Hyphen]in simplification procedure. If you had made the \
definition ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["5", "MR"],
  ", then ",
  StyleBox["Mathematica", "TI"],
  " would use this definition to reduce ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["-", "MR"],
  " ",
  StyleBox["3x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " to ",
  StyleBox["-9", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.1", "1.4"}],

Cell[TextData[{
  "The two most central concepts in ",
  StyleBox["Mathematica", "TI"],
  " are probably ",
  StyleBox["expressions", "TI"],
  " and ",
  StyleBox["evaluation", "TI"],
  ". Section\[NonBreakingSpace]",
  ButtonBox["2.1",
    ButtonData:>{"2.1"},
    ButtonStyle->"MainBookLink"],
  " discussed how all the different kinds of objects that ",
  StyleBox["Mathematica", "TI"],
  " handles are represented in a uniform way using expressions. This section \
describes how all the operations that ",
  StyleBox["Mathematica", "TI"],
  " can perform can also be viewed in a uniform way as examples of \
evaluation. "
}], "Text",
  CellTags->{"S2.6.1", "1.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Computation "], Cell[TextData[{
              StyleBox["5", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["6", "MR"],
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              "  ",
              StyleBox["11", "MR"],
              " "
            }]]},
          {Cell["Simplification "], Cell[TextData[{
              StyleBox["x", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["3x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["1", "MR"],
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              "  ",
              StyleBox["1", "MR"],
              " ",
              StyleBox["-", "MR"],
              " ",
              StyleBox["2x", "MR"],
              " "
            }]]},
          {Cell["Execution "], Cell[TextData[{
              StyleBox["x", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["5", "MR"],
              "  ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              "  ",
              StyleBox["5", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.1"],

Cell["Some interpretations of evaluation. ", "Caption",
  CellTags->"S2.6.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is an ",
  StyleBox["infinite evaluation", "TI"],
  " system. When you enter an expression, ",
  StyleBox["Mathematica", "TI"],
  " will keep on using definitions it knows until it gets a result to which \
no definitions apply. "
}], "Text",
  CellTags->{"S2.6.1", "1.6"}],

Cell[TextData[{
  "This defines ",
  StyleBox["x1", "MR"],
  " in terms of ",
  StyleBox["x2", "MR"],
  ", and then defines ",
  StyleBox["x2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.7"}],

Cell[CellGroupData[{

Cell["x1 = x2 + 2 ; x2 = 7", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell[TextData[{
  "If you ask for ",
  StyleBox["x1", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " uses all the definitions it knows to give you a result. "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.8"}],

Cell[CellGroupData[{

Cell["x1", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(9\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell["\<\
Here is a recursive definition in which the factorial function is \
defined in terms of itself. \
\>", "MathCaption",
  CellTags->{"S2.6.1", "1.9"}],

Cell["fac[1] = 1 ; fac[n_] := n fac[n-1]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.1"],

Cell[TextData[{
  "If you ask for ",
  StyleBox["fac[10]", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will keep on applying the definitions you have given until the result it \
gets no longer changes. "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.10"}],

Cell[CellGroupData[{

Cell["fac[10]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(3628800\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " has used all the definitions it knows, it gives whatever expression it \
has obtained as the result. Sometimes the result may be an object such as a \
number. But usually the result is an expression in which some objects are \
represented in a symbolic form. "
}], "Text",
  CellTags->{"S2.6.1", "1.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses its built\[Hyphen]in definitions for simplifying sums, but knows no \
definitions for ",
  StyleBox["f[3]", "MR"],
  ", so leaves this in symbolic form. "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.12"}],

Cell[CellGroupData[{

Cell["f[3] + 4f[3] + 1", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(1 + 5\ f[3]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " follows the principle of applying definitions until the result it gets no \
longer changes. This means that if you take the final result that ",
  StyleBox["Mathematica", "TI"],
  " gives, and enter it as ",
  StyleBox["Mathematica", "TI"],
  " input, you will get back the same result again. (There are some subtle \
cases discussed in Section ",
  ButtonBox["2.6.13",
    ButtonData:>{"2.6.13", "13.1"},
    ButtonStyle->"MainBookLink"],
  " in which this does not occur.) "
}], "Text",
  CellTags->{"S2.6.1", "1.13"}],

Cell[TextData[{
  "If you type in a result from ",
  StyleBox["Mathematica", "TI"],
  ", you get back the same expression again. "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.14"}],

Cell[CellGroupData[{

Cell["1 + 5 f[3]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(1 + 5\ f[3]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell[TextData[{
  "At any given time, ",
  StyleBox["Mathematica", "TI"],
  " can only use those definitions that it knows at that time. If you add \
more definitions later, however, ",
  StyleBox["Mathematica", "TI"],
  " will be able to use these. The results you get from ",
  StyleBox["Mathematica", "TI"],
  " may change in this case. "
}], "Text",
  CellTags->{"S2.6.1", "1.15"}],

Cell[TextData[{
  "Here is a new definition for the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.16"}],

Cell[CellGroupData[{

Cell["f[x_] = x^2", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell["With the new definition, the results you get can change. ", \
"MathCaption",
  CellTags->{"S2.6.1", "1.17"}],

Cell[CellGroupData[{

Cell["1 + 5 f[3]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(46\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.1"]
}, Open  ]],

Cell[TextData[{
  "The simplest examples of evaluation involve using definitions such as ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " which transform one expression directly into another. But evaluation is \
also the process used to execute programs written in ",
  StyleBox["Mathematica", "TI"],
  ". Thus, for example, if you have a procedure consisting of a sequence of \
",
  StyleBox["Mathematica", "TI"],
  " expressions, some perhaps representing conditionals and loops, the \
execution of this procedure corresponds to the evaluation of these \
expressions. Sometimes the evaluation process may involve evaluating a \
particular expression several times, as in a loop. "
}], "Text",
  CellTags->{"S2.6.1", "1.18"}],

Cell[TextData[{
  "The expression ",
  StyleBox["Print[zzzz]", "MR"],
  " is evaluated three times during the evaluation of the ",
  StyleBox["Do", "MR"],
  " expression. "
}], "MathCaption",
  CellTags->{"S2.6.1", "1.19"}],

Cell[CellGroupData[{

Cell["Do[Print[zzzz], {3}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(zzzz\)], "Print",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(zzzz\)], "Print",
  CellTags->"S2.6.1"],

Cell[BoxData[
    \(zzzz\)], "Print",
  CellTags->"S2.6.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.2 Reducing Expressions to Their Standard Form", "Subsection",
  CellTags->{"S2.6.2", "2.1"}],

Cell[TextData[{
  "The built\[Hyphen]in functions in ",
  StyleBox["Mathematica", "TI"],
  " operate in a wide variety of ways. But many of the mathematical functions \
share an important approach: they are set up so as to reduce classes of \
mathematical expressions to standard forms. "
}], "Text",
  CellTags->{"S2.6.2", "2.2"}],

Cell[TextData[{
  "The built\[Hyphen]in definitions for the ",
  StyleBox["Plus", "MR"],
  " function, for example, are set up to write any sum of terms in a standard \
unparenthesized form. The associativity of addition means that expressions \
like ",
  StyleBox["(a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b)", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  ", ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["(b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c)", "MR"],
  " and ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  " are all equivalent. But for many purposes it is convenient for all these \
forms to be reduced to the single standard form ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  ". The built\[Hyphen]in definitions for ",
  StyleBox["Plus", "MR"],
  " are set up to do this. "
}], "Text",
  CellTags->{"S2.6.2", "2.3"}],

Cell[TextData[{
  "Through the built\[Hyphen]in definitions for ",
  StyleBox["Plus", "MR"],
  ", this expression is reduced to a standard unparenthesized form. "
}], "MathCaption",
  CellTags->{"S2.6.2", "2.4"}],

Cell[CellGroupData[{

Cell["(a + b) + c", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.2"],

Cell[BoxData[
    \(a + b + c\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.2"]
}, Open  ]],

Cell[TextData[{
  "Whenever ",
  StyleBox["Mathematica", "TI"],
  " knows that a function is associative, it tries to remove parentheses (or \
nested invocations of the function) to get the function into a standard \
\[OpenCurlyDoubleQuote]flattened\[CloseCurlyDoubleQuote] form.  "
}], "Text",
  CellTags->{"S2.6.2", "2.5"}],

Cell[TextData[{
  "A function like addition is not only associative, but also commutative, \
which means that expressions like ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " and ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  " with terms in different orders are equal. Once again, ",
  StyleBox["Mathematica", "TI"],
  " tries to put all such expressions into a \[OpenCurlyDoubleQuote]standard\
\[CloseCurlyDoubleQuote] form. The standard form it chooses is the one in \
which all the terms are in a definite order, corresponding roughly to \
alphabetical order.  "
}], "Text",
  CellTags->{"S2.6.2", "2.6"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " sorts the terms in this sum into a standard order.  "
}], "MathCaption",
  CellTags->{"S2.6.2", "2.7"}],

Cell[CellGroupData[{

Cell["c + a + b", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.2"],

Cell[BoxData[
    \(a + b + c\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["flat (associative) "], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " is equivalent to ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              ", etc. "
            }]]},
          {Cell["orderless (commutative) "], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              " is equivalent to ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.2"],

Cell[TextData[{
  "Two important properties that ",
  StyleBox["Mathematica", "SO"],
  " uses in reducing certain functions to standard form."
}], "Caption",
  CellTags->"S2.6.2"],

Cell["\<\
There are several reasons to try to put expressions into standard \
forms. The most important is that if two expressions are really in standard \
form, it is obvious whether or not they are equal.  \
\>", "Text",
  CellTags->{"S2.6.2", "2.8"}],

Cell[TextData[{
  "When the two sums are put into standard order, they are immediately seen \
to be equal, so that two ",
  StyleBox["f", "MR"],
  "'s cancel, leaving the result ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.2", "2.9"}],

Cell[CellGroupData[{

Cell["f[a + c + b] - f[c + a + b]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.2"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.2"]
}, Open  ]],

Cell[TextData[{
  "You could imagine finding out whether ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["c", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " was equal to ",
  StyleBox["c", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  " by testing all possible orderings of each sum. It is clear that simply \
reducing both sums to standard form is a much more efficient procedure. "
}], "Text",
  CellTags->{"S2.6.2", "2.10"}],

Cell[TextData[{
  "One might think that ",
  StyleBox["Mathematica", "TI"],
  " should somehow automatically reduce ",
  StyleBox["all", "TI"],
  " mathematical expressions to a single standard canonical form. With all \
but the simplest kinds of expressions, however, it is quite easy to see that \
you do not want the ",
  StyleBox["same", "TI"],
  " standard form for all purposes. "
}], "Text",
  CellTags->{"S2.6.2", "2.11"}],

Cell[TextData[{
  "For polynomials, for example, there are two obvious standard forms, which \
are good for different purposes. The first standard form for a polynomial is \
a simple sum of terms, as would be generated in ",
  StyleBox["Mathematica", "TI"],
  " by applying the function ",
  StyleBox["Expand", "MR"],
  ". This standard form is most appropriate if you need to add and subtract \
polynomials. "
}], "Text",
  CellTags->{"S2.6.2", "2.12"}],

Cell[TextData[{
  "There is, however, another possible standard form that you can use for \
polynomials. By applying ",
  StyleBox["Factor", "MR"],
  ", you can write any polynomial as a product of irreducible factors. This \
canonical form is useful if you want to do operations like division. "
}], "Text",
  CellTags->{"S2.6.2", "2.13"}],

Cell[TextData[{
  "Expanded and factored forms are in a sense both equally good standard \
forms for polynomials. Which one you decide to use simply depends on what you \
want to use it for. As a result, ",
  StyleBox["Mathematica", "TI"],
  " does not automatically put polynomials into one of these two forms. \
Instead, it gives you functions like ",
  StyleBox["Expand", "MR"],
  " and ",
  StyleBox["Factor", "MR"],
  " that allow you explicitly to put polynomials in whatever form you want. "
}], "Text",
  CellTags->{"S2.6.2", "2.14"}],

Cell["\<\
Here is a list of two polynomials that are mathematically equal. \
\
\>", "MathCaption",
  CellTags->{"S2.6.2", "2.15"}],

Cell[CellGroupData[{

Cell["t = {x^2 - 1, (x + 1)(x - 1)}", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.2"],

Cell[BoxData[
    \({\(-1\) + x\^2, \((\(-1\) + x)\)\ \((1 + x)\)}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.2"]
}, Open  ]],

Cell[TextData[{
  "You can write both of them in expanded form just by applying ",
  StyleBox["Expand", "MR"],
  ". In this form, the equality of the polynomials is obvious. "
}], "MathCaption",
  CellTags->{"S2.6.2", "2.16"}],

Cell[CellGroupData[{

Cell["Expand[t]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.2"],

Cell[BoxData[
    \({\(-1\) + x\^2, \(-1\) + x\^2}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.2"]
}, Open  ]],

Cell["\<\
You can also see that the polynomials are equal by writing them \
both in factored form. \
\>", "MathCaption",
  CellTags->{"S2.6.2", "2.17"}],

Cell[CellGroupData[{

Cell["Factor[t]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.2"],

Cell[BoxData[
    \({\((\(-1\) + x)\)\ \((1 + x)\), \((\(-1\) + x)\)\ \((1 + 
            x)\)}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.2"]
}, Open  ]],

Cell[TextData[{
  "Although it is clear that you do not always want expressions reduced to \
the ",
  StyleBox["same", "TI"],
  " standard form, you may wonder whether it is at least ",
  StyleBox["possible", "TI"],
  " to reduce all expressions to ",
  StyleBox["some", "TI"],
  " standard form. "
}], "Text",
  CellTags->{"S2.6.2", "2.18"}],

Cell["\<\
There is a basic result in the mathematical theory of computation \
which shows that this is, in fact, not always possible. You cannot guarantee \
that any finite sequence of transformations will take any two arbitrarily \
chosen expressions to a standard form.  \
\>", "Text",
  CellTags->{"S2.6.2", "2.19"}],

Cell["\<\
In a sense, this is not particularly surprising. If you could in \
fact reduce all mathematical expressions to a standard form, then it would be \
quite easy to tell whether any two expressions were equal. The fact that so \
many of the difficult problems of mathematics can be stated as questions \
about the equality of expressions suggests that this can in fact be \
difficult. \
\>", "Text",
  CellTags->{"S2.6.2", "2.20"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.3 Attributes", "Subsection",
  CellTags->{"S2.6.3", "3.1"}],

Cell[TextData[{
  "Definitions such as ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  " specify ",
  StyleBox["values", "TI"],
  " for functions. Sometimes, however, you need to specify general properties \
of functions, without necessarily giving explicit values. "
}], "Text",
  CellTags->{"S2.6.3", "3.2"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides a selection of ",
  StyleBox["attributes", "TI"],
  " that you can use to specify various properties of functions. For example, \
you can use the attribute ",
  StyleBox["Flat", "MR"],
  " to specify that a particular function is \[OpenCurlyDoubleQuote]flat\
\[CloseCurlyDoubleQuote], so that nested invocations are automatically \
flattened, and it behaves as if it were associative. "
}], "Text",
  CellTags->{"S2.6.3", "3.3"}],

Cell[TextData[{
  "This assigns the attribute ",
  StyleBox["Flat", "MR"],
  " to the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.4"}],

Cell["SetAttributes[f, Flat]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Now ",
  StyleBox["f", "MR"],
  " behaves as a flat, or associative, function, so that nested invocations \
are automatically flattened. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.5"}],

Cell[CellGroupData[{

Cell["f[f[a, b], c]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(f[a, b, c]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "Attributes like ",
  StyleBox["Flat", "MR"],
  " can affect not only evaluation, but also operations such as pattern \
matching. If you give definitions or transformation rules for a function, you \
must be sure to have specified the attributes of the function first. "
}], "Text",
  CellTags->{"S2.6.3", "3.6"}],

Cell[TextData[{
  "Here is a definition for the flat function\[NonBreakingSpace]",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.7"}],

Cell["f[x_, x_] := f[x]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Because ",
  StyleBox["f", "MR"],
  " is flat, the definition is automatically applied to every subsequence of \
arguments. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.8"}],

Cell[CellGroupData[{

Cell["f[a, a, a, b, b, b, c, c]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(f[a, b, c]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Attributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Attributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["attr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["attr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "set the attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Attributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{}", "MR"],
              " "
            }]], Cell[TextData[{
              "set ",
              StyleBox["f", "TI"],
              " to have no attributes "
            }]]},
          {Cell[TextData[{
              StyleBox["SetAttributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["attr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "add ",
              StyleBox["attr", "TI"],
              " to the attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ClearAttributes[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["attr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove ",
              StyleBox["attr", "TI"],
              " from the attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.3"],

Cell["Manipulating attributes of symbols. ", "Caption",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "This shows the attributes assigned to ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.9"}],

Cell[CellGroupData[{

Cell["Attributes[f]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({Flat}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "This removes the attributes assigned to\[NonBreakingSpace]",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.10"}],

Cell[CellGroupData[{

Cell["Attributes[f] = { }", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Orderless", "MR"],
              " "
            }]], 
            Cell["\<\
orderless, commutative function (arguments are sorted \
into standard order) \
\>"]},
          {Cell[TextData[{
              StyleBox["Flat", "MR"],
              " "
            }]], 
            Cell["\<\
flat, associative function (arguments are \
\[OpenCurlyDoubleQuote]flattened out\[CloseCurlyDoubleQuote]) \
\>"]},
          {Cell[TextData[{
              StyleBox["OneIdentity", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["]]", "MR"],
              ", etc. are equivalent to ",
              StyleBox["a", "TI"],
              " for pattern matching "
            }]]},
          {Cell[TextData[{
              StyleBox["Listable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              
              " is automatically \[OpenCurlyDoubleQuote]threaded\
\[CloseCurlyDoubleQuote] over lists that appear as arguments (e.g., ",
              StyleBox["f", "TI"],
              StyleBox["[{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              StyleBox["b", "TI"],
              StyleBox["}]", "MR"],
              " becomes ",
              StyleBox["{", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["b", "TI"],
              StyleBox["]}", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["Constant", "MR"],
              " "
            }]], Cell[TextData[{
              "all derivatives of ",
              StyleBox["f", "TI"],
              " are zero "
            }]]},
          {Cell[TextData[{
              StyleBox["NumericFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              
              " is assumed to have a numerical value when its arguments are \
numeric quantities "
            }]]},
          {Cell[TextData[{
              StyleBox["Protected", "MR"],
              " "
            }]], Cell[TextData[{
              "values of ",
              StyleBox["f", "TI"],
              " cannot be changed "
            }]]},
          {Cell[TextData[{
              StyleBox["Locked", "MR"],
              " "
            }]], Cell[TextData[{
              "attributes of ",
              StyleBox["f", "TI"],
              " cannot be changed "
            }]]},
          {Cell[TextData[{
              StyleBox["ReadProtected", "MR"],
              " "
            }]], Cell[TextData[{
              "values of ",
              StyleBox["f", "TI"],
              " cannot be read "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldFirst", "MR"],
              " "
            }]], Cell[TextData[{
              "the first argument of ",
              StyleBox["f", "TI"],
              " is not evaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldRest", "MR"],
              " "
            }]], Cell[TextData[{
              "all but the first argument of ",
              StyleBox["f", "TI"],
              " is not evaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldAll", "MR"],
              " "
            }]], Cell[TextData[{
              "none of the arguments of ",
              StyleBox["f", "TI"],
              " are evaluated"
            }]]},
          {Cell[TextData[{
              StyleBox["HoldAllComplete", "MR"],
              " "
            }]], Cell[TextData[{
              "the arguments of ",
              StyleBox["f", "TI"],
              " are treated as completely inert "
            }]]},
          {Cell[TextData[{
              StyleBox["NHoldFirst", "MR"],
              " "
            }]], Cell[TextData[{
              "the first argument of ",
              StyleBox["f", "TI"],
              " is not affected by ",
              StyleBox["N", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NHoldRest", "MR"],
              " "
            }]], Cell[TextData[{
              "all but the first argument of ",
              StyleBox["f", "TI"],
              " is not affected by ",
              StyleBox["N", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["NHoldAll", "MR"],
              " "
            }]], Cell[TextData[{
              "none of the arguments of ",
              StyleBox["f", "TI"],
              " are affected by ",
              StyleBox["N", "MR"]
            }]]},
          {Cell[TextData[{
              StyleBox["SequenceHold", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sequence", "MR"],
              " objects appearing in the arguments of ",
              StyleBox["f", "TI"],
              " are not flattened out "
            }]]},
          {Cell[TextData[{
              StyleBox["Temporary", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              " is a local variable, removed when no longer used "
            }]]},
          {Cell[TextData[{
              StyleBox["Stub", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Needs", "MR"],
              " is automatically called if ",
              StyleBox["f", "TI"],
              " is ever explicitly input "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.3"],

Cell[TextData[{
  "The complete list of attributes for symbols in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Here are the attributes for the built\[Hyphen]in function ",
  StyleBox["Plus", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.11"}],

Cell[CellGroupData[{

Cell["Attributes[Plus]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({Flat, Listable, NumericFunction, OneIdentity, Orderless, 
      Protected}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "An important attribute assigned to built\[Hyphen]in mathematical functions \
in ",
  StyleBox["Mathematica", "TI"],
  " is the attribute ",
  StyleBox["Listable", "MR"],
  ". This attribute specifies that a function should automatically be \
distributed or \[OpenCurlyDoubleQuote]threaded\[CloseCurlyDoubleQuote] over \
lists that appear as its arguments. This means that the function effectively \
gets applied separately to each element in any lists that appear as its \
arguments. "
}], "Text",
  CellTags->{"S2.6.3", "3.12"}],

Cell[TextData[{
  "The built\[Hyphen]in ",
  StyleBox["Log", "MR"],
  " function is ",
  StyleBox["Listable", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.13"}],

Cell[CellGroupData[{

Cell["Log[{5, 8, 11}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({Log[5], Log[8], Log[11]}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "This defines the function ",
  StyleBox["p", "MR"],
  " to be listable. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.14"}],

Cell["SetAttributes[p, Listable]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Now ",
  StyleBox["p", "MR"],
  " is automatically threaded over lists that appear as its arguments. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.15"}],

Cell[CellGroupData[{

Cell["p[{a, b, c}, d]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({p[a, d], p[b, d], p[c, d]}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "Many of the attributes you can assign to functions in ",
  StyleBox["Mathematica", "TI"],
  " directly affect the evaluation of those functions. Some attributes, \
however, affect only other aspects of the treatment of functions. For \
example, the attribute ",
  StyleBox["OneIdentity", "MR"],
  " affects only pattern matching, as discussed in Section ",
  ButtonBox["2.3.7",
    ButtonData:>{"2.3.7", "7.1"},
    ButtonStyle->"MainBookLink"],
  ". Similarly, the attribute ",
  StyleBox["Constant", "MR"],
  " is only relevant in differentiation, and operations that rely on \
differentiation. "
}], "Text",
  CellTags->{"S2.6.3", "3.16"}],

Cell[TextData[{
  "The ",
  StyleBox["Protected", "MR"],
  " attribute affects assignments. ",
  StyleBox["Mathematica", "TI"],
  " does not allow you to make any definition associated with a symbol that \
carries this attribute. The functions ",
  StyleBox["Protect", "MR"],
  " and ",
  StyleBox["Unprotect", "MR"],
  " discussed in Section ",
  ButtonBox["2.5.12",
    ButtonData:>{"2.5.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  " can be used as alternatives to ",
  StyleBox["SetAttributes", "MR"],
  " and ",
  StyleBox["ClearAttributes", "MR"],
  " to set and clear this attribute. As discussed in Section ",
  ButtonBox["2.5.12",
    ButtonData:>{"2.5.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  " most built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " objects are initially protected so that you do not make definitions for \
them by mistake. "
}], "Text",
  CellTags->{"S2.6.3", "3.17"}],

Cell[TextData[{
  "Here is a definition for the function ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.18"}],

Cell[CellGroupData[{

Cell["g[x_] = x + 1", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(1 + x\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "This sets the ",
  StyleBox["Protected", "MR"],
  " attribute for\[NonBreakingSpace]",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.19"}],

Cell[CellGroupData[{

Cell["Protect[g]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({"g"}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "Now you cannot modify the definition of ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.20"}],

Cell[CellGroupData[{

Cell["g[x_] = x", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(Set::"write" \(\(:\)\(\ \)\) 
      "Tag \!\(g\) in \!\(g[x_]\) is Protected."\)], "Message",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "You can usually see the definitions you have made for a particular symbol \
by typing ",
  StyleBox["?", "MR"],
  StyleBox["f", "TI"],
  ", or by using a variety of built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions. However, if you set the attribute ",
  StyleBox["ReadProtected", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will not allow you to look at the definition of a particular symbol. It \
will nevertheless continue to use the definitions in performing evaluation. "
}], "Text",
  CellTags->{"S2.6.3", "3.21"}],

Cell[TextData[{
  "Although you cannot modify it, you can still look at the definition of ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.22"}],

Cell[CellGroupData[{

Cell["?g", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \("Global`g"\)], "Print",
  CellTags->"S2.6.3"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(Attributes[g] = {Protected}\)},
          {" "},
          {GridBox[{
                {\(g[x_] = 1 + x\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ g],
      Editable->False]], "Print",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "This sets the ",
  StyleBox["ReadProtected", "MR"],
  " attribute for ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.23"}],

Cell["SetAttributes[g, ReadProtected]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Now you can no longer read the definition of ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.24"}],

Cell[CellGroupData[{

Cell["?g", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \("Global`g"\)], "Print",
  CellTags->"S2.6.3"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(Attributes[g] = {Protected, ReadProtected}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ g],
      Editable->False]], "Print",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["SetAttributes", "MR"],
  " and ",
  StyleBox["ClearAttributes", "MR"],
  " usually allow you to modify the attributes of a symbol in any way. \
However, if you once set the ",
  StyleBox["Locked", "MR"],
  " attribute on a symbol, then ",
  StyleBox["Mathematica", "TI"],
  " will not allow you to modify the attributes of that symbol for the \
remainder of your ",
  StyleBox["Mathematica", "TI"],
  " session. Using the ",
  StyleBox["Locked", "MR"],
  " attribute in addition to ",
  StyleBox["Protected", "MR"],
  " or ",
  StyleBox["ReadProtected", "MR"],
  ", you can arrange for it to be impossible for users to modify or read \
definitions. "
}], "Text",
  CellTags->{"S2.6.3", "3.25"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Clear[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove values for ",
              StyleBox["f", "TI"],
              ", but not attributes "
            }]]},
          {Cell[TextData[{
              StyleBox["ClearAll[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove both values and attributes of ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.3"],

Cell["Clearing values and attributes. ", "Caption",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "This clears values and attributes of ",
  StyleBox["p", "MR"],
  " which was given attribute ",
  StyleBox["Listable", "MR"],
  " above. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.26"}],

Cell["ClearAll[p]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Now ",
  StyleBox["p", "MR"],
  " is no longer listable. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.27"}],

Cell[CellGroupData[{

Cell["p[{a, b, c}, d]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(p[{a, b, c}, d]\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "By defining attributes for a function you specify properties that ",
  StyleBox["Mathematica", "TI"],
  " should assume whenever that function appears. Often, however, you want to \
assume the properties only in a particular instance. In such cases, you will \
be better off not to use attributes, but instead to call a particular \
function to implement the transformation associated with the attributes. "
}], "Text",
  CellTags->{"S2.6.3", "3.28"}],

Cell[TextData[{
  "By explicitly calling ",
  StyleBox["Thread", "MR"],
  ", you can implement the transformation that would be done automatically if \
",
  StyleBox["p", "MR"],
  " were listable. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.29"}],

Cell[CellGroupData[{

Cell["Thread[p[{a, b, c}, d]]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({p[a, d], p[b, d], p[c, d]}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Orderless", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Sort[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Flat", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Flatten[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Listable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Thread[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Constant", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Dt[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Constants->", "MR"],
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.3"],

Cell["\<\
Functions that perform transformations associated with some \
attributes. \
\>", "Caption",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "Attributes in ",
  StyleBox["Mathematica", "TI"],
  " can only be permanently defined for single symbols. However, ",
  StyleBox["Mathematica", "TI"],
  " also allows you to set up pure functions which behave as if they carry \
attributes. "
}], "Text",
  CellTags->{"S2.6.3", "3.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Function[", "MR"],
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["attr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a pure function with attributes ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["attr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.3"],

Cell["Pure functions with attributes. ", "Caption",
  CellTags->"S2.6.3"],

Cell[TextData[{
  "This pure function applies ",
  StyleBox["p", "MR"],
  " to the whole list. "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.31"}],

Cell[CellGroupData[{

Cell["Function[{x}, p[x]] [{a, b, c}]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \(p[{a, b, c}]\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.6.3"]
}, Open  ]],

Cell[TextData[{
  "By adding the attribute ",
  StyleBox["Listable", "MR"],
  ", the function gets distributed over the elements of the list before \
applying ",
  StyleBox["p", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.3", "3.32"}],

Cell[CellGroupData[{

Cell["Function[{x}, p[x], {Listable}] [{a, b, c}]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.6.3"],

Cell[BoxData[
    \({p[a], p[b], p[c]}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.6.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.4 The Standard Evaluation Procedure", "Subsection",
  CellTags->{"S2.6.4", "4.1"}],

Cell[TextData[{
  "This section describes the standard procedure used by ",
  StyleBox["Mathematica", "TI"],
  " to evaluate expressions. This procedure is the one followed for most \
kinds of expressions. There are however some kinds of expressions, such as \
those used to represent ",
  StyleBox["Mathematica", "TI"],
  " programs and control structures, which are evaluated in a \
non\[Hyphen]standard way. The treatment of such expressions is discussed in \
the sections that follow this one. "
}], "Text",
  CellTags->{"S2.6.4", "4.2"}],

Cell[TextData[{
  "In the standard evaluation procedure, ",
  StyleBox["Mathematica", "TI"],
  " first evaluates the head of an expression, and then evaluates each \
element of the expressions. These elements are in general themselves \
expressions, to which the same evaluation procedure is recursively applied. "
}], "Text",
  CellTags->{"S2.6.4", "4.3"}],

Cell[TextData[{
  "The three ",
  StyleBox["Print", "MR"],
  " functions are evaluated in turn, each printing its argument, then \
returning the value ",
  StyleBox["Null", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.4"}],

Cell[CellGroupData[{

Cell["{Print[1], Print[2], Print[3]}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(3\)], "Print",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \({Null, Null, Null}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "This assigns the symbol ",
  StyleBox["ps", "MR"],
  " to be ",
  StyleBox["Plus", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.5"}],

Cell[CellGroupData[{

Cell["ps = Plus", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(Plus\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "The head ",
  StyleBox["ps", "MR"],
  " is evaluated first, so this expression behaves just like a sum of terms. \
"
}], "MathCaption",
  CellTags->{"S2.6.4", "4.6"}],

Cell[CellGroupData[{

Cell["ps[ps[a, b], c]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(a + b + c\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "As soon as ",
  StyleBox["Mathematica", "TI"],
  " has evaluated the head of an expression, it sees whether the head is a \
symbol that has attributes. If the symbol has the attributes ",
  StyleBox["Orderless", "MR"],
  ", ",
  StyleBox["Flat", "MR"],
  " or ",
  StyleBox["Listable", "MR"],
  ", then immediately after evaluating the elements of the expression ",
  StyleBox["Mathematica", "TI"],
  " performs the transformations associated with these attributes. "
}], "Text",
  CellTags->{"S2.6.4", "4.7"}],

Cell[TextData[{
  "The next step in the standard evaluation procedure is to use definitions \
that ",
  StyleBox["Mathematica", "TI"],
  " knows for the expression it is evaluating. ",
  StyleBox["Mathematica", "TI"],
  " first tries to use definitions that you have made, and if there are none \
that apply, it tries built\[Hyphen]in definitions. "
}], "Text",
  CellTags->{"S2.6.4", "4.8"}],

Cell[TextData[{
  "If ",
  StyleBox["Mathematica", "TI"],
  " finds a definition that applies, it performs the corresponding \
transformation on the expression. The result is another expression, which \
must then in turn be evaluated according to the standard evaluation \
procedure. "
}], "Text",
  CellTags->{"S2.6.4", "4.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Evaluate the head of the \
expression. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Evaluate each element in turn. \
\
\>"]},
          {Cell[TextData[{
              
              "\[FilledSmallSquare] Apply transformations associated with the \
attributes ",
              StyleBox["Orderless", "MR"],
              ", ",
              StyleBox["Listable", "MR"],
              " and ",
              StyleBox["Flat", "MR"],
              ". "
            }]]},
          {
            Cell["\<\
\[FilledSmallSquare] Apply any definitions that you \
have given. \
\>"]},
          {
            Cell["\<\
\[FilledSmallSquare] Apply any built\[Hyphen]in \
definitions. \
\>"]},
          {Cell["\[FilledSmallSquare] Evaluate the result. "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.4"],

Cell["The standard evaluation procedure. ", "Caption",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.6.1",
    ButtonData:>{"2.6.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " follows the principle that each expression is evaluated until no further \
definitions apply. This means that ",
  StyleBox["Mathematica", "TI"],
  " must continue re\[Hyphen]evaluating results until it gets an expression \
which remains unchanged through the evaluation procedure. "
}], "Text",
  CellTags->{"S2.6.4", "4.10"}],

Cell[TextData[{
  "Here is an example that shows how the standard evaluation procedure works \
on a simple expression. We assume that ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["7", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.4", "4.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["2", "MR"],
              " ",
              StyleBox["a", "MR"],
              " ",
              StyleBox["x", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["a^2", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["1", "MR"],
              " "
            }]], Cell["here is the original expression "]},
          {Cell[TextData[{
              StyleBox["Plus[Times[2,", "MR"],
              " ",
              StyleBox["a,", "MR"],
              " ",
              StyleBox["x],", "MR"],
              " ",
              StyleBox["Power[a,", "MR"],
              " ",
              StyleBox["2],", "MR"],
              " ",
              StyleBox["1]", "MR"],
              " "
            }]], Cell["this is the internal form "]},
          {Cell[TextData[{
              StyleBox["Times[2,", "MR"],
              " ",
              StyleBox["a,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]], Cell["this is evaluated first "]},
          {Cell[TextData[{
              StyleBox["Times[2,", "MR"],
              " ",
              StyleBox["7,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["a", "MR"],
              " is evaluated to give ",
              StyleBox["7", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Times[14,", "MR"],
              " ",
              StyleBox["x]", "MR"],
              " "
            }]], Cell[TextData[{
              "built\[Hyphen]in definitions for ",
              StyleBox["Times", "MR"],
              " give this result "
            }]]},
          {Cell[TextData[{
              StyleBox["Power[a,", "MR"],
              " ",
              StyleBox["2]", "MR"],
              " "
            }]], Cell["this is evaluated next "]},
          {Cell[TextData[{
              StyleBox["Power[7,", "MR"],
              " ",
              StyleBox["2]", "MR"],
              " "
            }]], Cell[TextData[{
              "here is the result after evaluating ",
              StyleBox["a", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["49", "MR"],
              " "
            }]], Cell[TextData[{
              "built\[Hyphen]in definitions for ",
              StyleBox["Power", "MR"],
              " give this result "
            }]]},
          {Cell[TextData[{
              StyleBox["Plus[Times[14,", "MR"],
              " ",
              StyleBox["x],", "MR"],
              " ",
              StyleBox["49,", "MR"],
              " ",
              StyleBox["1]", "MR"],
              " "
            }]], Cell[TextData[{
              "here is the result after the arguments of ",
              StyleBox["Plus", "MR"],
              " have been evaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["Plus[50,", "MR"],
              " ",
              StyleBox["Times[14,", "MR"],
              " ",
              StyleBox["x]]", "MR"],
              " "
            }]], Cell[TextData[{
              "built\[Hyphen]in definitions for ",
              StyleBox["Plus", "MR"],
              " give this result "
            }]]},
          {Cell[TextData[{
              StyleBox["50", "MR"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["14", "MR"],
              " ",
              StyleBox["x", "MR"],
              " "
            }]], Cell["the result is printed like this "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, True, False, False, True, False, False, True, False, True}},
  CellTags->"S2.6.4"],

Cell[TextData[{
  "A simple example of evaluation in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.6.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides various ways to \[OpenCurlyDoubleQuote]trace\
\[CloseCurlyDoubleQuote] the evaluation process, as discussed in Section ",
  ButtonBox["2.6.11",
    ButtonData:>{"2.6.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ". The function ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives a nested list showing each subexpression generated during \
evaluation. (Note that the standard evaluation traverses the expression tree \
in a depth\[Hyphen]first way, so that the smallest subparts of the expression \
appear first in the results of ",
  StyleBox["Trace", "MR"],
  ".) "
}], "Text",
  CellTags->{"S2.6.4", "4.12"}],

Cell[TextData[{
  "First set ",
  StyleBox["a", "MR"],
  " to ",
  StyleBox["7", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.13"}],

Cell[CellGroupData[{

Cell["a = 7", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell["\<\
This gives a nested list of all the subexpressions generated during \
the evaluation of the expression. \
\>", "MathCaption",
  CellTags->{"S2.6.4", "4.14"}],

Cell[CellGroupData[{

Cell["Trace[2 a x + a^2 + 1]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox["a",
                  HoldForm], ",", 
                TagBox["7",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(2\ 7\ x\),
              HoldForm], ",", 
            TagBox[\(14\ x\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox["a",
                  HoldForm], ",", 
                TagBox["7",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(7\^2\),
              HoldForm], ",", 
            TagBox["49",
              HoldForm]}], "}"}], ",", 
        TagBox[\(14\ x + 49 + 1\),
          HoldForm], ",", 
        TagBox[\(50 + 14\ x\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "The order in which ",
  StyleBox["Mathematica", "TI"],
  " applies different kinds of definitions is important. The fact that ",
  StyleBox["Mathematica", "TI"],
  " applies definitions you have given before it applies built\[Hyphen]in \
definitions means that you can give definitions which override the built\
\[Hyphen]in ones, as discussed in Section ",
  ButtonBox["2.5.12",
    ButtonData:>{"2.5.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.6.4", "4.15"}],

Cell[TextData[{
  "This expression is evaluated using the built\[Hyphen]in definition for ",
  StyleBox["ArcSin", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.16"}],

Cell[CellGroupData[{

Cell["ArcSin[1]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(\[Pi]\/2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "You can give your own definitions for ",
  StyleBox["ArcSin", "MR"],
  ". You need to remove the protection attribute first. "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.17"}],

Cell["Unprotect[ArcSin]; ArcSin[1] = 5Pi/2;", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.4"],

Cell["Your definition is used before the one that is built in. ", \
"MathCaption",
  CellTags->{"S2.6.4", "4.18"}],

Cell[CellGroupData[{

Cell["ArcSin[1]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(\(5\ \[Pi]\)\/2\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["2.5.10",
    ButtonData:>{"2.5.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  ", you can associate definitions with symbols either as upvalues or \
downvalues. ",
  StyleBox["Mathematica", "TI"],
  " always tries upvalue definitions before downvalue ones. "
}], "Text",
  CellTags->{"S2.6.4", "4.19"}],

Cell[TextData[{
  "If you have an expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  ", there are in general two sets of definitions that could apply: \
downvalues associated with ",
  StyleBox["f", "TI"],
  ", and upvalues associated with ",
  StyleBox["g", "TI"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " tries the definitions associated with ",
  StyleBox["g", "TI"],
  " before those associated with ",
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.4", "4.20"}],

Cell[TextData[{
  "This ordering follows the general strategy of trying specific definitions \
before more general ones. By applying upvalues associated with arguments \
before applying downvalues associated with a function, ",
  StyleBox["Mathematica", "TI"],
  " allows you to make definitions for special arguments which override the \
general definitions for the function with any arguments. "
}], "Text",
  CellTags->{"S2.6.4", "4.21"}],

Cell[TextData[{
  "This defines a rule for ",
  StyleBox["f[g[x_]]", "MR"],
  ", to be associated with ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.22"}],

Cell["f/: f[g[x_]] := frule[x]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "This defines a rule for ",
  StyleBox["f[g[x_]]", "MR"],
  ", to be associated with ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.23"}],

Cell["g/: f[g[x_]] := grule[x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "The rule associated with ",
  StyleBox["g", "MR"],
  " is tried before the rule associated with ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.24"}],

Cell[CellGroupData[{

Cell["f[g[2]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(grule[2]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "If you remove rules associated with ",
  StyleBox["g", "MR"],
  ", the rule associated with ",
  StyleBox["f", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.25"}],

Cell[CellGroupData[{

Cell["Clear[g] ; f[g[1]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(frule[1]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] Definitions associated with ",
              StyleBox["g", "TI"],
              " are applied before definitions associated with ",
              StyleBox["f", "TI"],
              " in the expression ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]]", "MR"],
              ". "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.4"],

Cell["The order in which definitions are applied. ", "Caption",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "Most functions such as ",
  StyleBox["Plus", "MR"],
  " that are built into ",
  StyleBox["Mathematica", "TI"],
  " have downvalues. There are, however, some objects in ",
  StyleBox["Mathematica", "TI"],
  " which have built\[Hyphen]in upvalues. For example, ",
  StyleBox["SeriesData", "MR"],
  " objects, which represent power series, have built\[Hyphen]in upvalues \
with respect to various mathematical operations. "
}], "Text",
  CellTags->{"S2.6.4", "4.26"}],

Cell[TextData[{
  "For an expression like ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  ", the complete sequence of definitions that are tried in the standard \
evaluation procedure is: "
}], "Text",
  CellTags->{"S2.6.4", "4.27"}],

Cell[TextData[{
  "\[FilledSmallSquare] Definitions you have given associated with ",
  StyleBox["g", "TI"],
  ";  \n\[FilledSmallSquare] Built\[Hyphen]in definitions associated with ",
  StyleBox["g", "TI"],
  ";  \n\[FilledSmallSquare] Definitions you have given associated with ",
  StyleBox["f", "TI"],
  ";  \n\[FilledSmallSquare] Built\[Hyphen]in definitions associated with ",
  StyleBox["f", "TI"],
  ".  "
}], "Notes",
  CellTags->{"S2.6.4", "4.28"}],

Cell["\<\
The fact that upvalues are used before downvalues is important in \
many situations. In a typical case, you might want to define an operation \
such as composition. If you give upvalues for various objects with respect to \
composition, these upvalues will be used whenever such objects appear. \
However, you can also give a general procedure for composition, to be used if \
no special objects are present. You can give this procedure as a downvalue \
for composition. Since downvalues are tried after upvalues, the general \
procedure will be used only if no objects with upvalues are present. \
\>", \
"Text",
  CellTags->{"S2.6.4", "4.29"}],

Cell[TextData[{
  "Here is a definition associated with ",
  StyleBox["q", "MR"],
  " for composition of \[OpenCurlyDoubleQuote]",
  StyleBox["q", "MR"],
  " objects\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.30"}],

Cell["q/: comp[q[x_], q[y_]] := qcomp[x, y]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "Here is a general rule for composition, associated with ",
  StyleBox["comp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.31"}],

Cell["comp[f_[x_], f_[y_]] := gencomp[f, x, y]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "If you compose two ",
  StyleBox["q", "MR"],
  " objects, the rule associated with ",
  StyleBox["q", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.32"}],

Cell[CellGroupData[{

Cell["comp[q[1], q[2]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(qcomp[1, 2]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "If you compose ",
  StyleBox["r", "MR"],
  " objects, the general rule associated with ",
  StyleBox["comp", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.33"}],

Cell[CellGroupData[{

Cell["comp[r[1], r[2]]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \(gencomp[r, 1, 2]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.6.4"]
}, Open  ]],

Cell[TextData[{
  "In general, there can be several objects that have upvalues in a \
particular expression. ",
  StyleBox["Mathematica", "TI"],
  " first looks at the head of the expression, and tries any upvalues \
associated with it. Then it successively looks at each element of the \
expression, trying any upvalues that exist. ",
  StyleBox["Mathematica", "TI"],
  " performs this procedure first for upvalues that you have explicitly \
defined, and then for upvalues that are built in. The procedure means that in \
a sequence of elements, upvalues associated with earlier elements take \
precedence over those associated with later elements. "
}], "Text",
  CellTags->{"S2.6.4", "4.34"}],

Cell[TextData[{
  "This defines an upvalue for ",
  StyleBox["p", "MR"],
  " with respect to ",
  StyleBox["c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.35"}],

Cell["p/: c[l___, p[x_], r___] := cp[x, {l, r}]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "This defines an upvalue for ",
  StyleBox["q", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.36"}],

Cell["q/: c[l___, q[x_], r___] := cq[x, {l, r}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.4"],

Cell[TextData[{
  "Which upvalue is used depends on which occurs first in the sequence of \
arguments to ",
  StyleBox["c", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.4", "4.37"}],

Cell[CellGroupData[{

Cell["{c[p[1], q[2]], c[q[1], p[2]]}", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.4"],

Cell[BoxData[
    \({cp[1, {q[2]}], cq[1, {p[2]}]}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.5 Non\[Hyphen]Standard Evaluation", "Subsection",
  CellTags->{"S2.6.5", "5.1"}],

Cell[TextData[{
  "While most built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions follow the standard evaluation procedure, some important ones \
do not. For example, most of the ",
  StyleBox["Mathematica", "TI"],
  " functions associated with the construction and execution of programs use \
non\[Hyphen]standard evaluation procedures. In typical cases, the functions \
either never evaluate some of their arguments, or do so in a special way \
under their own control. "
}], "Text",
  CellTags->{"S2.6.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], 
            Cell["\<\
do not evaluate the left\[Hyphen]hand side \
\>"]},
          {Cell[TextData[{
              StyleBox["If[", "MR"],
              StyleBox["p", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["a", "TI"],
              " if ",
              StyleBox["p", "TI"],
              " is ",
              StyleBox["True", "MR"],
              ", and ",
              StyleBox["b", "TI"],
              " if it is ",
              StyleBox["False", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Do[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " ",
              StyleBox["n", "TI"],
              " times "
            }]]},
          {Cell[TextData[{
              StyleBox["Plot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["f", "TI"],
              " with a sequence of numerical values for ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Function[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["do not evaluate until the function is applied "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.5"],

Cell["\<\
Some functions that use non\[Hyphen]standard evaluation procedures. \
\
\>", "Caption",
  CellTags->"S2.6.5"],

Cell[TextData[{
  "When you give a definition such as ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["1", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " does not evaluate the ",
  StyleBox["a", "MR"],
  " that appears on the left\[Hyphen]hand side. You can see that there would \
be trouble if the ",
  StyleBox["a", "MR"],
  " was evaluated. The reason is that if you had previously set ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["7", "MR"],
  ", then evaluating ",
  StyleBox["a", "MR"],
  " in the definition ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["1", "MR"],
  " would put the definition into the nonsensical form ",
  StyleBox["7", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["1", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.5", "5.3"}],

Cell[TextData[{
  "In the standard evaluation procedure, each argument of a function is \
evaluated in turn. This is prevented by setting the attributes ",
  StyleBox["HoldFirst", "MR"],
  ", ",
  StyleBox["HoldRest", "MR"],
  " and ",
  StyleBox["HoldAll", "MR"],
  ". These attributes make ",
  StyleBox["Mathematica", "TI"],
  " \[OpenCurlyDoubleQuote]hold\[CloseCurlyDoubleQuote] particular arguments \
in an unevaluated form.     "
}], "Text",
  CellTags->{"S2.6.5", "5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["HoldFirst", "MR"],
              " "
            }]], Cell["do not evaluate the first argument "]},
          {Cell[TextData[{
              StyleBox["HoldRest", "MR"],
              " "
            }]], Cell["evaluate only the first argument "]},
          {Cell[TextData[{
              StyleBox["HoldAll", "MR"],
              " "
            }]], Cell["evaluate none of the arguments "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.5"],

Cell["\<\
Attributes for holding function arguments in unevaluated form. \
\
\>", "Caption",
  CellTags->"S2.6.5"],

Cell["\<\
With the standard evaluation procedure, all arguments to a function \
are evaluated. \
\>", "MathCaption",
  CellTags->{"S2.6.5", "5.5"}],

Cell[CellGroupData[{

Cell["f[1 + 1, 2 + 4]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(f[2, 6]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "This assigns the attribute ",
  StyleBox["HoldFirst", "MR"],
  " to\[NonBreakingSpace]",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.6"}],

Cell["SetAttributes[h, HoldFirst]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.5"],

Cell[TextData[{
  "The first argument to ",
  StyleBox["h", "MR"],
  " is now held in an unevaluated form. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.7"}],

Cell[CellGroupData[{

Cell["h[1 + 1, 2 + 4]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(h[1 + 1, 6]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "When you use the first argument to ",
  StyleBox["h", "MR"],
  " like this, it will get evaluated. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.8"}],

Cell[CellGroupData[{

Cell["h[1 + 1, 2 + 4] /. h[x_, y_] -> x^y", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(64\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "Built\[Hyphen]in functions like ",
  StyleBox["Set", "MR"],
  " carry attributes such as ",
  StyleBox["HoldFirst", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.9"}],

Cell[CellGroupData[{

Cell["Attributes[Set]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \({HoldFirst, Protected, SequenceHold}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "Even though a function may have attributes which specify that it should \
hold certain arguments unevaluated, you can always explicitly tell ",
  StyleBox["Mathematica", "TI"],
  " to evaluate those arguments by giving the arguments in the form ",
  StyleBox["Evaluate[", "MR"],
  StyleBox["arg", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.5", "5.10"}],

Cell[TextData[{
  StyleBox["Evaluate", "MR"],
  " effectively overrides the ",
  StyleBox["HoldFirst", "MR"],
  " attribute, and causes the first argument to be evaluated. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.11"}],

Cell[CellGroupData[{

Cell["h[Evaluate[1 + 1], 2 + 4]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(h[2, 6]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[Evaluate[", "MR"],
              StyleBox["arg", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["arg", "TI"],
              " immediately, even though attributes of ",
              StyleBox["f", "TI"],
              " may specify that it should be held "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.5"],

Cell["Forcing the evaluation of function arguments. ", "Caption",
  CellTags->"S2.6.5"],

Cell[TextData[{
  "By holding its arguments, a function can control when those arguments are \
evaluated. By using ",
  StyleBox["Evaluate", "MR"],
  ", you can force the arguments to be evaluated immediately, rather than \
being evaluated under the control of the function. This capability is useful \
in a number of circumstances. "
}], "Text",
  CellTags->{"S2.6.5", "5.12"}],

Cell[TextData[{
  "One example discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.9.1",
    ButtonData:>{"1.9.1", "1.8"},
    ButtonStyle->"MainBookLink"],
  " occurs when plotting graphs of expressions. The ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Plot", "MR"],
  " function holds unevaluated the expression you are going to plot, then \
evaluates it at a sequence of numerical positions. In some cases, you may \
instead want to evaluate the expression immediately, and have ",
  StyleBox["Plot", "MR"],
  " work with the evaluated form. For example, if you want to plot a list of \
functions generated by ",
  StyleBox["Table", "MR"],
  ", then you will want the ",
  StyleBox["Table", "MR"],
  " operation done immediately, rather than being done every time a point is \
to be plotted. "
}], "Text",
  CellTags->{"S2.6.5", "5.13"}],

Cell[TextData[{
  StyleBox["Evaluate", "MR"],
  " causes the list of functions to be constructed immediately, rather than \
being constructed at each value of ",
  StyleBox["x", "MR"],
  " chosen by ",
  StyleBox["Plot", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.14"}],

Cell[CellGroupData[{

Cell["Plot[ Evaluate[Table[Sin[n x], {n, 1, 3}]], {x, 0, 2Pi} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309016 0.294303 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .38322 L
.10458 .45852 L
.14415 .51889 L
.18221 .56357 L
.20178 .58047 L
.21267 .58793 L
.22272 .59354 L
.23293 .59796 L
.23832 .59976 L
.24402 .60127 L
.24641 .60178 L
.24897 .60225 L
.25119 .60258 L
.25361 .60288 L
.25507 .60302 L
.25643 .60313 L
.25773 .60321 L
.2584 .60324 L
.25912 .60327 L
.25983 .60329 L
.26048 .60331 L
.26176 .60332 L
.26293 .60331 L
.26416 .60329 L
.26538 .60324 L
.26607 .60321 L
.26671 .60317 L
.26912 .60299 L
.27131 .60275 L
.27364 .60244 L
.27847 .60156 L
.2838 .60025 L
.29326 .59705 L
.30213 .59301 L
.32232 .58025 L
.34082 .56432 L
.38045 .51781 L
.41855 .45965 L
.45912 .38744 L
.49816 .31259 L
.53966 .23289 L
.57964 .1614 L
.61811 .10221 L
.63759 .07707 L
.65902 .05386 L
.67938 .03652 L
.69843 .02473 L
.70884 .02018 L
.71396 .01844 L
Mistroke
.71872 .01712 L
.72301 .01617 L
.72758 .01542 L
.7302 .01511 L
.73148 .01499 L
.73266 .0149 L
.73371 .01484 L
.73487 .01478 L
.73603 .01474 L
.73725 .01472 L
.73856 .01472 L
.73977 .01473 L
.7404 .01475 L
.7411 .01477 L
.74251 .01484 L
.74375 .01492 L
.74508 .01503 L
.74748 .01528 L
.74985 .0156 L
.75235 .01601 L
.7568 .01695 L
.76198 .01836 L
.7668 .01998 L
.77773 .02472 L
.78828 .0307 L
.79823 .03757 L
.81683 .05353 L
.85534 .09846 L
.89632 .16101 L
.93577 .23146 L
.97371 .3042 L
.97619 .30902 L
Mfstroke
.02381 .30902 m
.06244 .45263 L
.08255 .51497 L
.0932 .54236 L
.10458 .56657 L
.11009 .57624 L
.11531 .58409 L
.12038 .59047 L
.12507 .59525 L
.12951 .59877 L
.13178 .60018 L
.13422 .60141 L
.13549 .60193 L
.13666 .60234 L
.13784 .60268 L
.13895 .60293 L
.14022 .60314 L
.1409 .60322 L
.14161 .60328 L
.1423 .60331 L
.14295 .60332 L
.14415 .60328 L
.14531 .60316 L
.14656 .60297 L
.14773 .60271 L
.14881 .60241 L
.15143 .60144 L
.15392 .60019 L
.15886 .59679 L
.16423 .59169 L
.17383 .57909 L
.1827 .56357 L
.20137 .51989 L
.22197 .45702 L
.26217 .30798 L
.30086 .16432 L
.32051 .10346 L
.3309 .0766 L
.342 .05274 L
.35275 .03485 L
.35784 .0283 L
.36253 .02337 L
.36724 .01952 L
.36972 .01794 L
.37235 .01661 L
.37463 .01574 L
.37573 .01541 L
.37677 .01516 L
.37799 .01494 L
.37911 .0148 L
Mistroke
.38031 .01472 L
.38162 .01473 L
.38227 .01476 L
.38296 .01482 L
.38419 .01498 L
.38551 .01524 L
.38695 .01564 L
.38955 .0166 L
.39197 .01782 L
.39649 .02088 L
.40134 .02529 L
.40698 .0319 L
.41232 .03956 L
.42232 .05748 L
.44227 .1059 L
.4607 .16316 L
.50002 .3091 L
.53782 .44987 L
.55884 .51523 L
.56803 .53913 L
.57808 .56136 L
.58722 .57774 L
.59696 .59091 L
.60236 .59621 L
.60726 .59976 L
.60962 .60104 L
.61086 .6016 L
.61218 .60211 L
.61333 .60248 L
.61459 .60281 L
.61574 .60304 L
.61682 .60319 L
.61808 .60329 L
.61871 .60332 L
.61941 .60332 L
.62065 .60325 L
.62181 .60312 L
.62248 .60302 L
.62318 .60288 L
.62443 .60258 L
.62578 .60216 L
.62725 .6016 L
.62973 .6004 L
.63238 .59878 L
.63715 .59497 L
.64214 .58976 L
.64686 .58372 L
.6557 .56958 L
.67568 .52489 L
.69413 .47033 L
Mistroke
.7335 .32685 L
.77136 .18397 L
.79241 .1157 L
.81166 .06613 L
.82118 .04724 L
.8262 .0389 L
.83155 .03133 L
.8367 .02536 L
.84136 .02107 L
.84361 .01939 L
.84604 .01786 L
.84835 .01669 L
.85045 .01586 L
.85159 .0155 L
.85283 .01519 L
.85414 .01494 L
.85538 .01479 L
.85653 .01472 L
.85776 .01472 L
.85881 .01479 L
.85997 .01492 L
.86063 .01502 L
.86132 .01516 L
.86256 .01547 L
.86535 .01644 L
.86777 .0176 L
.87041 .01921 L
.87569 .02348 L
.88133 .02957 L
.89148 .0444 L
.90173 .06419 L
.91284 .09067 L
.933 .15021 L
.97393 .30026 L
.97619 .30902 L
Mfstroke
.02381 .30902 m
.04262 .41606 L
.06244 .51276 L
.07286 .5519 L
.08255 .57915 L
.08813 .59036 L
.09076 .59448 L
.0932 .5976 L
.096 .60036 L
.09748 .60145 L
.09824 .60191 L
.09905 .60234 L
.09976 .60265 L
.10041 .60288 L
.10168 .60319 L
.10239 .60328 L
.10317 .60332 L
.1039 .60329 L
.10458 .60321 L
.10587 .6029 L
.10651 .60268 L
.10722 .60237 L
.10848 .6017 L
.10966 .6009 L
.11231 .59853 L
.11515 .59509 L
.12035 .58647 L
.1251 .57604 L
.13466 .54801 L
.14371 .51358 L
.18204 .31193 L
.20142 .20156 L
.21172 .14833 L
.22282 .09846 L
.23339 .06036 L
.23801 .04701 L
.24307 .03492 L
.24787 .02599 L
.25234 .01998 L
.25481 .01761 L
.25705 .01607 L
.25829 .01546 L
.259 .0152 L
.25964 .01501 L
.26083 .01478 L
.26209 .01472 L
.2633 .01483 L
.26462 .01514 L
.26586 .01562 L
.26702 .01622 L
Mistroke
.2692 .01778 L
.27152 .02003 L
.27427 .02348 L
.27684 .02749 L
.28166 .03693 L
.29046 .06049 L
.29997 .09438 L
.31995 .1885 L
.34103 .30762 L
.36093 .42068 L
.37905 .50916 L
.3891 .54783 L
.3986 .57578 L
.40382 .58716 L
.40863 .59506 L
.41115 .59815 L
.41392 .60072 L
.41532 .60169 L
.41605 .60211 L
.41682 .60248 L
.41749 .60275 L
.41823 .60299 L
.41953 .60325 L
.42017 .60331 L
.42086 .60332 L
.42208 .6032 L
.42339 .60288 L
.42414 .60261 L
.42483 .6023 L
.42724 .6008 L
.4286 .59967 L
.42983 .59846 L
.43463 .5921 L
.43918 .58372 L
.44922 .55747 L
.46014 .51783 L
.47989 .42306 L
.50089 .30381 L
.52056 .19252 L
.53861 .10537 L
.54802 .06955 L
.55794 .04079 L
.56309 .02985 L
.56789 .02227 L
.57065 .01909 L
.57315 .01694 L
.57454 .01605 L
.57527 .01568 L
.57605 .01535 L
.57672 .01512 L
Mistroke
.57747 .01492 L
.57878 .01473 L
.58007 .01474 L
.58127 .01492 L
.58259 .01531 L
.58332 .01561 L
.58399 .01594 L
.58653 .01767 L
.58893 .01997 L
.59339 .02597 L
.59821 .03494 L
.6035 .04765 L
.60909 .06418 L
.61909 .10109 L
.65708 .29942 L
.67824 .41987 L
.69753 .51344 L
.70711 .54968 L
.71216 .56538 L
.71752 .57926 L
.7222 .58887 L
.72468 .59301 L
.72736 .5967 L
.72981 .59937 L
.73088 .60032 L
.73205 .60122 L
.73309 .60188 L
.7342 .60244 L
.73537 .60289 L
.73645 .60316 L
.73769 .60331 L
.73839 .60331 L
.73905 .60327 L
.73974 .60316 L
.74037 .60302 L
.7411 .6028 L
.74179 .60253 L
.74301 .60193 L
.74414 .60121 L
.74671 .59905 L
.74953 .59581 L
.75209 .5921 L
.75782 .58118 L
.76281 .5688 L
.7682 .55259 L
.77797 .51632 L
.81905 .29977 L
.83953 .18454 L
.84952 .13458 L
.85861 .09497 L
Mistroke
.86742 .06317 L
.87699 .03711 L
.88224 .02689 L
.88455 .02336 L
.88709 .02016 L
.88949 .01781 L
.89173 .01621 L
.89297 .01557 L
.8941 .01514 L
.89541 .01483 L
.89665 .01472 L
.89789 .01478 L
.89859 .01489 L
.89924 .01505 L
.90042 .01546 L
.90168 .01607 L
.90385 .01755 L
.90623 .0198 L
.90878 .02291 L
.91151 .02706 L
.91645 .03663 L
.92606 .06263 L
.93483 .09413 L
.95391 .18339 L
.97467 .30013 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.6.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "There are a number of built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions which, like ",
  StyleBox["Plot", "MR"],
  ", are set up to hold some of their arguments. You can always override this \
behavior using ",
  StyleBox["Evaluate", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.5", "5.15"}],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Set", "MR"],
  " function holds its first argument, so the symbol ",
  StyleBox["a", "MR"],
  " is not evaluated in this case. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.16"}],

Cell[CellGroupData[{

Cell["a = b", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(b\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "You can make ",
  StyleBox["Set", "MR"],
  " evaluate its first argument using ",
  StyleBox["Evaluate", "MR"],
  ". In this case, the result is the object which is the ",
  StyleBox["value", "TI"],
  " of ",
  StyleBox["a", "MR"],
  ", namely ",
  StyleBox["b", "MR"],
  " is set to ",
  StyleBox["6", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.17"}],

Cell[CellGroupData[{

Cell["Evaluate[a] = 6", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["b", "MR"],
  " has now been set to ",
  StyleBox["6", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.18"}],

Cell[CellGroupData[{

Cell["b", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "In most cases, you want all expressions you give to ",
  StyleBox["Mathematica", "TI"],
  " to be evaluated. Sometimes, however, you may want to prevent the \
evaluation of certain expressions. For example, if you want to manipulate \
pieces of a ",
  StyleBox["Mathematica", "TI"],
  " program symbolically, then you must prevent those pieces from being \
evaluated while you are manipulating them. "
}], "Text",
  CellTags->{"S2.6.5", "5.19"}],

Cell[TextData[{
  "You can use the functions ",
  StyleBox["Hold", "MR"],
  " and ",
  StyleBox["HoldForm", "MR"],
  " to keep expressions unevaluated. These functions work simply by carrying \
the attribute ",
  StyleBox["HoldAll", "MR"],
  ", which prevents their arguments from being evaluated. The functions \
provide \[OpenCurlyDoubleQuote]wrappers\[CloseCurlyDoubleQuote] inside which \
expressions remain unevaluated. "
}], "Text",
  CellTags->{"S2.6.5", "5.20"}],

Cell[TextData[{
  "The difference between ",
  StyleBox["Hold[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["HoldForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " is that in standard ",
  StyleBox["Mathematica", "TI"],
  " output format, ",
  StyleBox["Hold", "MR"],
  " is printed explicitly, while ",
  StyleBox["HoldForm", "MR"],
  " is not. If you look at the full internal ",
  StyleBox["Mathematica", "TI"],
  " form, you can however see both functions. "
}], "Text",
  CellTags->{"S2.6.5", "5.21"}],

Cell[TextData[{
  StyleBox["Hold", "MR"],
  " maintains expressions in an unevaluated form. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.22"}],

Cell[CellGroupData[{

Cell["Hold[1 + 1]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(Hold[1 + 1]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["HoldForm", "MR"],
  " also keeps expressions unevaluated, but is invisible in standard ",
  StyleBox["Mathematica", "TI"],
  " output format. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.23"}],

Cell[CellGroupData[{

Cell["HoldForm[1 + 1]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    TagBox[\(1 + 1\),
      HoldForm]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["HoldForm", "MR"],
  " is still present internally. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.24"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    TagBox[
      StyleBox[\(HoldForm[Plus[1, 1]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[13]//FullForm= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["ReleaseHold", "MR"],
  " removes ",
  StyleBox["Hold", "MR"],
  " and ",
  StyleBox["HoldForm", "MR"],
  ", so the expressions they contain get evaluated. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.25"}],

Cell[CellGroupData[{

Cell["ReleaseHold[%]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Hold[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "keep ",
              StyleBox["expr", "TI"],
              " unevaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldComplete[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "keep ",
              StyleBox["expr", "TI"],
              " unevaluated and prevent upvalues associated with ",
              StyleBox["expr", "TI"],
              " from being used "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "keep ",
              StyleBox["expr", "TI"],
              " unevaluated, and print without ",
              StyleBox["HoldForm", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ReleaseHold[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove ",
              StyleBox["Hold", "MR"],
              " and ",
              StyleBox["HoldForm", "MR"],
              " in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Extract[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["index", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Hold]", "MR"],
              " "
            }]], Cell[TextData[{
              "get a part of ",
              StyleBox["expr", "TI"],
              ", wrapping it with ",
              StyleBox["Hold", "MR"],
              " to prevent evaluation "
            }]]},
          {Cell[TextData[{
              StyleBox["ReplacePart[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Hold[", "MR"],
              StyleBox["value", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["index", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["1]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace part of ",
              StyleBox["expr", "TI"],
              ", extracting ",
              StyleBox["value", "TI"],
              " without evaluating it "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.5"],

Cell["Functions for handling unevaluated expressions. ", "Caption",
  CellTags->"S2.6.5"],

Cell["\<\
Parts of expressions are usually evaluated as soon as you extract \
them. \
\>", "MathCaption",
  CellTags->{"S2.6.5", "5.26"}],

Cell[CellGroupData[{

Cell["Extract[ Hold[1 + 1, 2 + 3], 2]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "This extracts a part and immediately wraps it with ",
  StyleBox["Hold", "MR"],
  ", so it does not get evaluated. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.27"}],

Cell[CellGroupData[{

Cell["Extract[ Hold[1 + 1, 2 + 3], 2, Hold]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(Hold[2 + 3]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "The last argument of ",
  StyleBox["1", "MR"],
  " tells ",
  StyleBox["ReplacePart", "MR"],
  " to extract the first part of ",
  StyleBox["Hold[7", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["8]", "MR"],
  " before inserting it. "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.28"}],

Cell[CellGroupData[{

Cell["ReplacePart[ Hold[1 + 1, 2 + 3], Hold[7 + 8], 2, 1]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(Hold[1 + 1, 7 + 8]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["Unevaluated[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["],", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["expr", "TI"],
              " unevaluated as an argument to ",
              StyleBox["f", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.5"],

Cell["Temporary prevention of argument evaluation. ", "Caption",
  CellTags->"S2.6.5"],

Cell[TextData[{
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " evaluates to ",
  StyleBox["2", "MR"],
  ", and ",
  StyleBox["Length[2]", "MR"],
  " gives ",
  StyleBox["0", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.29"}],

Cell[CellGroupData[{

Cell["Length[1 + 1]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  "This gives the unevaluated form ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " as the argument of ",
  StyleBox["Length", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.5", "5.30"}],

Cell[CellGroupData[{

Cell["Length[Unevaluated[1 + 1]]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.5"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Unevaluated[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " effectively works by temporarily giving a function an attribute like ",
  StyleBox["HoldFirst", "MR"],
  ", and then supplying ",
  StyleBox["expr", "TI"],
  " as an argument to the function. "
}], "Text",
  CellTags->{"S2.6.5", "5.31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SequenceHold", "MR"],
              " "
            }]], Cell[TextData[{
              "do not flatten out ",
              StyleBox["Sequence", "MR"],
              " objects that appear as arguments "
            }]]},
          {Cell[TextData[{
              StyleBox["HoldAllComplete", "MR"],
              " "
            }]], Cell["treat all arguments as completely inert "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.5"],

Cell["Attributes for preventing other aspects of evaluation. ", "Caption",
  CellTags->"S2.6.5"],

Cell[TextData[{
  "By setting the attribute ",
  StyleBox["HoldAll", "MR"],
  ", you can prevent ",
  StyleBox["Mathematica", "TI"],
  " from evaluating the arguments of a function. But even with this attribute \
set, ",
  StyleBox["Mathematica", "TI"],
  " will still do some transformations on the arguments. By setting ",
  StyleBox["SequenceHold", "MR"],
  " you can prevent it from flattening out ",
  StyleBox["Sequence", "MR"],
  " objects that appear in the arguments. And by setting ",
  StyleBox["HoldAllComplete", "MR"],
  " you can also inhibit the stripping of ",
  StyleBox["Unevaluated", "MR"],
  ", and prevent ",
  StyleBox["Mathematica", "TI"],
  " from using any upvalues it finds associated with the arguments.    "
}], "Text",
  CellTags->{"S2.6.5", "5.32"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.6 Evaluation in Patterns, Rules and Definitions", "Subsection",
  CellTags->{"S2.6.6", "6.1"}],

Cell[TextData[{
  "There are a number of important interactions in ",
  StyleBox["Mathematica", "TI"],
  " between evaluation and pattern matching. The first observation is that \
pattern matching is usually done on expressions that have already been at \
least partly evaluated. As a result, it is usually appropriate that the \
patterns to which these expressions are matched should themselves be \
evaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.2"}],

Cell["\<\
The fact that the pattern is evaluated means that it matches the \
expression given. \
\>", "MathCaption",
  CellTags->{"S2.6.6", "6.3"}],

Cell[CellGroupData[{

Cell["f[k^2] /. f[x_^(1 + 1)] -> p[x]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(p[k]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "The right\[Hyphen]hand side of the ",
  StyleBox["/;", "MR"],
  " condition is not evaluated until it is used during pattern matching. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.4"}],

Cell[CellGroupData[{

Cell["f[{a, b}] /. f[list_ /; Length[list] > 1] -> list^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \({a\^2, b\^2}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "There are some cases, however, where you may want to keep all or part of a \
pattern unevaluated. You can do this by wrapping the parts you do not want to \
evaluate with ",
  StyleBox["HoldPattern", "MR"],
  ". In general, whenever ",
  StyleBox["HoldPattern[", "MR"],
  StyleBox["patt", "TI"],
  StyleBox["]", "MR"],
  " appears within a pattern, this form is taken to be equivalent to ",
  StyleBox["patt", "TI"],
  " for the purpose of pattern matching, but the expression ",
  StyleBox["patt", "TI"],
  " is maintained unevaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["HoldPattern[", "MR"],
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "equivalent to ",
              StyleBox["patt", "TI"],
              " for pattern matching, with ",
              StyleBox["patt", "TI"],
              " kept unevaluated "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.6"],

Cell["Preventing evaluation in patterns. ", "Caption",
  CellTags->"S2.6.6"],

Cell[TextData[{
  "One application for ",
  StyleBox["HoldPattern", "MR"],
  " is in specifying patterns which can apply to unevaluated expressions, or \
expressions held in an unevaluated form. "
}], "Text",
  CellTags->{"S2.6.6", "6.6"}],

Cell[TextData[{
  StyleBox["HoldPattern", "MR"],
  " keeps the ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " from being evaluated, and allows it to match the ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " on the left\[Hyphen]hand side of the ",
  StyleBox["/.", "MR"],
  " operator. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.7"}],

Cell[CellGroupData[{

Cell["Hold[u[1 + 1]] /. HoldPattern[1 + 1] -> x", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(Hold[u[x]]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "Notice that while functions like ",
  StyleBox["Hold", "MR"],
  " prevent evaluation of expressions, they do not affect the manipulation of \
parts of those expressions with ",
  StyleBox["/.", "MR"],
  " and other operators. "
}], "Text",
  CellTags->{"S2.6.6", "6.8"}],

Cell[TextData[{
  "This defines values for ",
  StyleBox["r", "MR"],
  " whenever its argument is not an atomic object. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.9"}],

Cell["r[x_] := x^2 /; !AtomQ[x]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.6"],

Cell[TextData[{
  "According to the definition, expressions like ",
  StyleBox["r[3]", "MR"],
  " are left unchanged. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.10"}],

Cell[CellGroupData[{

Cell["r[3]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(r[3]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "However, the pattern ",
  StyleBox["r[x_]", "MR"],
  " is transformed according to the definition for ",
  StyleBox["r", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.11"}],

Cell[CellGroupData[{

Cell["r[x_]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(x_\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "You need to wrap ",
  StyleBox["HoldPattern", "MR"],
  " around ",
  StyleBox["r[x_]", "MR"],
  " to prevent it from being evaluated. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.12"}],

Cell[CellGroupData[{

Cell["{r[3], r[5]} /. HoldPattern[r[x_]] -> x", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \({3, 5}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "As illustrated above, the left\[Hyphen]hand sides of transformation rules \
such as ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " are usually evaluated immediately, since the rules are usually applied to \
expressions which have already been evaluated. The right\[Hyphen]hand side of \
",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " is also evaluated immediately. With the delayed rule ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox[":>", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", however, the expression ",
  StyleBox["rhs", "TI"],
  " is not evaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.13"}],

Cell[TextData[{
  "The right\[Hyphen]hand side is evaluated immediately in ",
  StyleBox["->", "MR"],
  " but not ",
  StyleBox[":>", "MR"],
  " rules. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.14"}],

Cell[CellGroupData[{

Cell["{{x -> 1 + 1}, {x :> 1 + 1}}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \({{x \[Rule] 2}, {x \[RuleDelayed] 1 + 1}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "Here are the results of applying the rules. The right\[Hyphen]hand side of \
the ",
  StyleBox[":>", "MR"],
  " rule gets inserted inside the ",
  StyleBox["Hold", "MR"],
  " without evaluation. "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.15"}],

Cell[CellGroupData[{

Cell["{x^2, Hold[x]} /. %", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \({{4, Hold[2]}, {4, Hold[1 + 1]}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "evaluate both ",
              StyleBox["lhs", "TI"],
              " and ",
              StyleBox["rhs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["lhs", "TI"],
              " but not ",
              StyleBox["rhs", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.6"],

Cell["Evaluation in transformation rules. ", "Caption",
  CellTags->"S2.6.6"],

Cell[TextData[{
  "While the left\[Hyphen]hand sides of transformation rules are usually \
evaluated, the left\[Hyphen]hand sides of definitions are usually not. The \
reason for the difference is as follows. Transformation rules are typically \
applied using ",
  StyleBox["/.", "MR"],
  " to expressions that have already been evaluated. Definitions, however, \
are used during the evaluation of expressions, and are applied to expressions \
that have not yet been completely evaluated. To work on such expressions, the \
left\[Hyphen]hand sides of definitions must be maintained in a form that is \
at least partially unevaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.16"}],

Cell[TextData[{
  "Definitions for symbols are the simplest case. As discussed in the \
previous section, a symbol on the left\[Hyphen]hand side of a definition such \
as ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  " is not evaluated. If ",
  StyleBox["x", "TI"],
  " had previously been assigned a value ",
  StyleBox["y", "TI"],
  ", then if the left\[Hyphen]hand side of ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  " were evaluated, it would turn into the quite unrelated definition ",
  StyleBox["y", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["value", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.6", "6.17"}],

Cell["\<\
Here is a definition. The symbol on the left\[Hyphen]hand side is \
not evaluated. \
\>", "MathCaption",
  CellTags->{"S2.6.6", "6.18"}],

Cell[CellGroupData[{

Cell["k = w[3]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(w[3]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell["This redefines the symbol. ", "MathCaption",
  CellTags->{"S2.6.6", "6.19"}],

Cell[CellGroupData[{

Cell["k = w[4]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(w[4]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "If you evaluate the left\[Hyphen]hand side, then you define not the symbol \
",
  StyleBox["k", "MR"],
  ", but the ",
  StyleBox["value", "TI"],
  " ",
  StyleBox["w[4]", "MR"],
  " of the symbol ",
  StyleBox["k", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.20"}],

Cell[CellGroupData[{

Cell["Evaluate[k] = w[5]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(w[5]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "Now ",
  StyleBox["w[4]", "MR"],
  " has value ",
  StyleBox["w[5]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.21"}],

Cell[CellGroupData[{

Cell["w[4]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(w[5]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "Although individual symbols that appear on the left\[Hyphen]hand sides of \
definitions are not evaluated, more complicated expressions are partially \
evaluated. In an expression such as ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["args", "TI"],
  StyleBox["]", "MR"],
  " on the left\[Hyphen]hand side of a definition, the ",
  StyleBox["args", "TI"],
  " are evaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.22"}],

Cell[TextData[{
  "The ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " is evaluated, so that a value is defined for ",
  StyleBox["g[2]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.23"}],

Cell[CellGroupData[{

Cell["g[1 + 1] = 5", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "This shows the value defined for ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.6", "6.24"}],

Cell[CellGroupData[{

Cell["?g", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.6"],

Cell[BoxData[
    \("Global`g"\)], "Print",
  CellTags->"S2.6.6"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(g[2] = 5\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ g],
      Editable->False]], "Print",
  CellTags->"S2.6.6"]
}, Open  ]],

Cell[TextData[{
  "You can see why the arguments of a function that appears on the left\
\[Hyphen]hand side of a definition must be evaluated by considering how the \
definition is used during the evaluation of an expression. As discussed in \
Section ",
  ButtonBox["2.6.1",
    ButtonData:>{"2.6.1", "1.1"},
    ButtonStyle->"MainBookLink"],
  ", when ",
  StyleBox["Mathematica", "TI"],
  " evaluates a function, it first evaluates each of the arguments, then \
tries to find definitions for the function. As a result, by the time ",
  StyleBox["Mathematica", "TI"],
  " applies any definition you have given for a function, the arguments of \
the function must already have been evaluated. An exception to this occurs \
when the function in question has attributes which specify that it should \
hold some of its arguments unevaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.25"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["symbol", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["symbol", "TI"],
              " is not evaluated; ",
              StyleBox["value", "TI"],
              " is evaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["symbol", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              "neither ",
              StyleBox["symbol", "TI"],
              " nor ",
              StyleBox["value", "TI"],
              " is evaluated "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["args", "TI"],
              " are evaluated; left\[Hyphen]hand side as a whole is not "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[HoldPattern[", "MR"],
              StyleBox["arg", "TI"],
              StyleBox["]]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["arg", "TI"],
              StyleBox["]", "MR"],
              " is assigned, without evaluating ",
              StyleBox["arg", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Evaluate[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              " "
            }]], 
            Cell["\<\
left\[Hyphen]hand side is evaluated completely \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.6"],

Cell["Evaluation in definitions. ", "Caption",
  CellTags->"S2.6.6"],

Cell[TextData[{
  "While in most cases it is appropriate for the arguments of a function that \
appears on the left\[Hyphen]hand side of a definition to be evaluated, there \
are some situations in which you do not want this to happen. In such cases, \
you can wrap ",
  StyleBox["HoldPattern", "MR"],
  " around the parts that you do not want to be evaluated. "
}], "Text",
  CellTags->{"S2.6.6", "6.26"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.7 Evaluation in Iteration Functions", "Subsection",
  CellTags->{"S2.6.7", "7.1"}],

Cell[TextData[{
  "The built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " iteration functions such as ",
  StyleBox["Table", "MR"],
  " and ",
  StyleBox["Sum", "MR"],
  ", as well as ",
  StyleBox["Plot", "MR"],
  " and ",
  StyleBox["Plot3D", "MR"],
  ", evaluate their arguments in a slightly special way. "
}], "Text",
  CellTags->{"S2.6.7", "7.2"}],

Cell[TextData[{
  "When evaluating an expression like ",
  StyleBox["Table[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["imax", "TI"],
  StyleBox["}]", "MR"],
  ", the first step, as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.7.6",
    ButtonData:>{"2.7.6", "6.16"},
    ButtonStyle->"MainBookLink"],
  ", is to make the value of ",
  StyleBox["i", "TI"],
  " local. Next, the limit ",
  StyleBox["imax", "TI"],
  " in the iterator specification is evaluated. The expression ",
  StyleBox["f", "TI"],
  " is maintained in an unevaluated form, but is repeatedly evaluated as a \
succession of values are assigned to ",
  StyleBox["i", "TI"],
  ". When this is finished, the global value of ",
  StyleBox["i", "TI"],
  " is restored. "
}], "Text",
  CellTags->{"S2.6.7", "7.3"}],

Cell[TextData[{
  "The function ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is evaluated four separate times here, so four different pseudorandom \
numbers are generated. "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.4"}],

Cell[CellGroupData[{

Cell["Table[Random[ ], {4}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \({0.056070794834861534`, 0.630299795779359`, 0.3598942942214413`, 
      0.8713770771750458`}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[TextData[{
  "This evaluates ",
  StyleBox["Random[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " before feeding it to ",
  StyleBox["Table", "MR"],
  ". The result is a list of four identical numbers. "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.5"}],

Cell[CellGroupData[{

Cell["Table[ Evaluate[Random[ ]], {4} ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \({0.8586451657320738`, 0.8586451657320738`, 0.8586451657320738`, 
      0.8586451657320738`}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[TextData[{
  "In most cases, it is convenient for the function ",
  StyleBox["f", "TI"],
  " in an expression like ",
  StyleBox["Table[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["imax", "TI"],
  StyleBox["}]", "MR"],
  " to be maintained in an unevaluated form until specific values have been \
assigned to ",
  StyleBox["i", "TI"],
  ". This is true in particular if a complete symbolic form for ",
  StyleBox["f", "TI"],
  " valid for any ",
  StyleBox["i", "TI"],
  " cannot be found. "
}], "Text",
  CellTags->{"S2.6.7", "7.6"}],

Cell[TextData[{
  "This defines ",
  StyleBox["fac", "MR"],
  " to give the factorial when it has an integer argument, and to give ",
  StyleBox["NaN", "MR"],
  " (standing for \[OpenCurlyDoubleQuote]Not a \
Number\[CloseCurlyDoubleQuote]) otherwise. "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.7"}],

Cell["fac[n_Integer] := n! ; fac[x_] := NaN", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.7"],

Cell[TextData[{
  "In this form, ",
  StyleBox["fac[i]", "MR"],
  " is not evaluated until an explicit integer value has been assigned to ",
  StyleBox["i", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.8"}],

Cell[CellGroupData[{

Cell["Table[fac[i], {i, 5}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \({1, 2, 6, 24, 120}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[TextData[{
  "Using ",
  StyleBox["Evaluate", "MR"],
  " forces ",
  StyleBox["fac[i]", "MR"],
  " to be evaluated with ",
  StyleBox["i", "MR"],
  " left as a symbolic object. "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.9"}],

Cell[CellGroupData[{

Cell["Table[Evaluate[fac[i]], {i, 5}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \({NaN, NaN, NaN, NaN, NaN}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[TextData[{
  "In cases where a complete symbolic form for ",
  StyleBox["f", "TI"],
  " with arbitrary ",
  StyleBox["i", "TI"],
  " in expressions such as ",
  StyleBox["Table[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["imax", "TI"],
  StyleBox["}]", "MR"],
  " ",
  StyleBox["can", "TI"],
  " be found, it is often more efficient to compute this form first, and then \
feed it to ",
  StyleBox["Table", "MR"],
  ". You can do this using ",
  StyleBox["Table[Evaluate[", "MR"],
  StyleBox["f", "TI"],
  StyleBox["],", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["imax", "TI"],
  StyleBox["}]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.7", "7.10"}],

Cell[TextData[{
  "The ",
  StyleBox["Sum", "MR"],
  " in this case is evaluated separately for each value of ",
  StyleBox["i", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.11"}],

Cell[CellGroupData[{

Cell["Table[Sum[i^k, {k, 4}], {i, 8}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \({4, 30, 120, 340, 780, 1554, 2800, 4680}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[TextData[{
  "It is however possible to get a symbolic formula for the sum, valid for \
any value of ",
  StyleBox["i", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.12"}],

Cell[CellGroupData[{

Cell["Sum[i^k, {k, 4}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \(i + i\^2 + i\^3 + i\^4\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[TextData[{
  "By inserting ",
  StyleBox["Evaluate", "MR"],
  ", you tell ",
  StyleBox["Mathematica", "TI"],
  " first to evaluate the sum symbolically, then to iterate over ",
  StyleBox["i", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.7", "7.13"}],

Cell[CellGroupData[{

Cell["Table[Evaluate[Sum[i^k, {k, 4}]], {i, 8}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.7"],

Cell[BoxData[
    \({4, 30, 120, 340, 780, 1554, 2800, 4680}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Table[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "keep ",
              StyleBox["f", "TI"],
              " unevaluated until specific values are assigned to ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Table[Evaluate[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["f", "TI"],
              " first with ",
              StyleBox["i", "TI"],
              " left symbolic "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.7"],

Cell["Evaluation in iteration functions. ", "Caption",
  CellTags->"S2.6.7"],

Cell[TextData[{
  "As discussed in Section\[NonBreakingSpace]",
  ButtonBox["1.9.1",
    ButtonData:>{"1.9.1", "1.8"},
    ButtonStyle->"MainBookLink"],
  ", it is convenient to use ",
  StyleBox["Evaluate", "MR"],
  " when you plot a graph of a function or a list of functions. This causes \
the symbolic form of the function or list to be found first, before the \
iteration begins. "
}], "Text",
  CellTags->{"S2.6.7", "7.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.8 Conditionals", "Subsection",
  CellTags->{"S2.6.8", "8.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides various ways to set up ",
  StyleBox["conditionals", "TI"],
  ", which specify that particular expressions should be evaluated only if \
certain conditions hold. "
}], "Text",
  CellTags->{"S2.6.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["test", "TI"],
              " "
            }]], Cell[TextData[{
              "use the definition only if ",
              StyleBox["test", "TI"],
              " evaluates to ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["If[", "MR"],
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["then", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["else", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["then", "TI"],
              " if ",
              StyleBox["test", "TI"],
              " is ",
              StyleBox["True", "MR"],
              ", and ",
              StyleBox["else", "TI"],
              " if it is ",
              StyleBox["False", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Which[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["test",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["value",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["test",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["test",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              
              " in turn, giving the value associated with the first one that \
is ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Switch[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["value",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "compare ",
              StyleBox["expr", "TI"],
              " with each of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", giving the value associated with the first form it matches "
            }]]},
          {Cell[TextData[{
              StyleBox["Switch[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["value",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["_,", "MR"],
              " ",
              StyleBox["def", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use ",
              StyleBox["def", "TI"],
              " as a default value "
            }]]},
          {Cell[TextData[{
              StyleBox["Piecewise[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["value",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["test",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["def", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the value corresponding to the first ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["test",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " which yields ",
              StyleBox["True", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.8"],

Cell["Conditional constructs. ", "Caption",
  CellTags->"S2.6.8"],

Cell[TextData[{
  "The test gives ",
  StyleBox["False", "MR"],
  ", so the \[OpenCurlyDoubleQuote]",
  StyleBox["else", "TI"],
  "\[CloseCurlyDoubleQuote] expression ",
  StyleBox["y", "MR"],
  " is returned. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.3"}],

Cell[CellGroupData[{

Cell["If[7 > 8, x, y]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(y\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "Only the \[OpenCurlyDoubleQuote]",
  StyleBox["else", "TI"],
  "\[CloseCurlyDoubleQuote] expression is evaluated in this case. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.4"}],

Cell[CellGroupData[{

Cell["If[7 > 8, Print[x], Print[y]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(y\)], "Print",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "When you write programs in ",
  StyleBox["Mathematica", "TI"],
  ", you will often have a choice between making a single definition whose \
right\[Hyphen]hand side involves several branches controlled by ",
  StyleBox["If", "MR"],
  " functions, or making several definitions, each controlled by an \
appropriate ",
  StyleBox["/;", "MR"],
  " condition. By using several definitions, you can often produce programs \
that are both clearer, and easier to modify. "
}], "Text",
  CellTags->{"S2.6.8", "8.5"}],

Cell[TextData[{
  "This defines a step function, with value ",
  StyleBox["1", "MR"],
  " for ",
  StyleBox["x", "MR"],
  " ",
  StyleBox[">", "MR"],
  " ",
  StyleBox["0", "MR"],
  ", and ",
  StyleBox["-1", "MR"],
  " otherwise. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.6"}],

Cell["f[x_] := If[x > 0, 1, -1]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.8"],

Cell[TextData[{
  "This defines the positive part of the step function using a ",
  StyleBox["/;", "MR"],
  " condition. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.7"}],

Cell["g[x_] := 1 /; x > 0", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.8"],

Cell["Here is the negative part of the step function. ", "MathCaption",
  CellTags->{"S2.6.8", "8.8"}],

Cell["g[x_] := -1 /; x <= 0", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.8"],

Cell[TextData[{
  "This shows the complete definition using ",
  StyleBox["/;", "MR"],
  " conditions. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.9"}],

Cell[CellGroupData[{

Cell["?g", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \("Global`g"\)], "Print",
  CellTags->"S2.6.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(g[x_] := 1 /; x > 0\)},
                {" "},
                {\(g[x_] := \(-1\) /; x \[LessEqual] 0\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ g],
      Editable->False]], "Print",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["If", "MR"],
  " provides a way to choose between two alternatives. Often, however, there \
will be more than two alternatives. One way to handle this is to use a nested \
set of ",
  StyleBox["If", "MR"],
  " functions. Usually, however, it is instead better to use functions like \
",
  StyleBox["Which", "MR"],
  " and ",
  StyleBox["Switch", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.8", "8.10"}],

Cell[TextData[{
  "This defines a function with three regions. Using ",
  StyleBox["True", "MR"],
  " as the third test makes this the default case. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.11"}],

Cell["h[x_] := Which[x < 0, x^2, x > 5, x^3, True, 0]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.8"],

Cell[TextData[{
  "This uses the first case in the ",
  StyleBox["Which", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.12"}],

Cell[CellGroupData[{

Cell["h[-5]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(25\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell["This uses the third case. ", "MathCaption",
  CellTags->{"S2.6.8", "8.13"}],

Cell[CellGroupData[{

Cell["h[2]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "This defines a function that depends on the values of its argument modulo \
",
  StyleBox["3", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.14"}],

Cell["r[x_] := Switch[Mod[x, 3], 0, a, 1, b, 2, c]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.8"],

Cell[TextData[{
  StyleBox["Mod[7,", "MR"],
  " ",
  StyleBox["3]", "MR"],
  " is ",
  StyleBox["1", "MR"],
  ", so this uses the second case in the ",
  StyleBox["Switch", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.15"}],

Cell[CellGroupData[{

Cell["r[7]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(b\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["17", "MR"],
  " matches neither ",
  StyleBox["0", "MR"],
  " nor ",
  StyleBox["1", "MR"],
  ", but does match ",
  StyleBox["_", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.16"}],

Cell[CellGroupData[{

Cell["Switch[17, 0, a, 1, b, _, q]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(q\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "An important point about symbolic systems such as ",
  StyleBox["Mathematica", "TI"],
  " is that the conditions you give may yield neither ",
  StyleBox["True", "MR"],
  " nor ",
  StyleBox["False", "MR"],
  ". Thus, for example, the condition ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["y", "MR"],
  " does not yield ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  " unless ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " have specific values, such as numerical ones. "
}], "Text",
  CellTags->{"S2.6.8", "8.17"}],

Cell[TextData[{
  "In this case, the test gives neither ",
  StyleBox["True", "MR"],
  " nor ",
  StyleBox["False", "MR"],
  ", so both branches in the ",
  StyleBox["If", "MR"],
  " remain unevaluated. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.18"}],

Cell[CellGroupData[{

Cell["If[x == y, a, b]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(If[x \[Equal] y, a, b]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "You can add a special fourth argument to ",
  StyleBox["If", "MR"],
  ", which is used if the test does not yield ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.19"}],

Cell[CellGroupData[{

Cell["If[x == y, a, b, c]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(c\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["If[", "MR"],
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["then", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["else", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["unknown", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a form of ",
              StyleBox["If", "MR"],
              " which includes the expression to use if ",
              StyleBox["test", "TI"],
              " is neither ",
              StyleBox["True", "MR"],
              " nor ",
              StyleBox["False", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TrueQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["expr", "TI"],
              " is ",
              StyleBox["True", "MR"],
              ", and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["===", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["SameQ[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["lhs", "TI"],
              " and ",
              StyleBox["rhs", "TI"],
              " are identical, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=!=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["UnsameQ[", "MR"],
              StyleBox["lhs", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if ",
              StyleBox["lhs", "TI"],
              " and ",
              StyleBox["rhs", "TI"],
              " are not identical, and ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]},
          {Cell[TextData[{
              StyleBox["MatchQ[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give ",
              StyleBox["True", "MR"],
              " if the pattern ",
              StyleBox["form", "TI"],
              " matches ",
              StyleBox["expr", "TI"],
              ", and give ",
              StyleBox["False", "MR"],
              " otherwise "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.8"],

Cell["Functions for dealing with symbolic conditions. ", "Caption",
  CellTags->"S2.6.8"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " leaves this as a symbolic equation. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.20"}],

Cell[CellGroupData[{

Cell["x == y", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(x \[Equal] y\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "Unless ",
  StyleBox["expr", "TI"],
  " is manifestly ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["TrueQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " effectively assumes that ",
  StyleBox["expr", "TI"],
  " is ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.21"}],

Cell[CellGroupData[{

Cell["TrueQ[x == y]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "Unlike ",
  StyleBox["==", "MR"],
  ", ",
  StyleBox["===", "MR"],
  " tests whether two expressions are manifestly identical. In this case, \
they are not. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.22"}],

Cell[CellGroupData[{

Cell["x === y", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "The main difference between ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["===", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " and ",
  StyleBox["lhs", "TI"],
  " ",
  StyleBox["==", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  " is that ",
  StyleBox["===", "MR"],
  " always returns ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ", whereas ",
  StyleBox["==", "MR"],
  " can leave its input in symbolic form, representing a symbolic equation, \
as discussed in Section ",
  ButtonBox["1.5.5",
    ButtonData:>{"1.5.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  ". You should typically use ",
  StyleBox["===", "MR"],
  " when you want to test the ",
  StyleBox["structure", "TI"],
  " of an expression, and ",
  StyleBox["==", "MR"],
  " if you want to test mathematical equality. The ",
  StyleBox["Mathematica", "TI"],
  " pattern matcher effectively uses ",
  StyleBox["===", "MR"],
  " to determine when one literal expression matches another. "
}], "Text",
  CellTags->{"S2.6.8", "8.23"}],

Cell[TextData[{
  "You can use ",
  StyleBox["===", "MR"],
  " to test the structure of expressions. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.24"}],

Cell[CellGroupData[{

Cell["Head[a + b + c] === Times", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["==", "MR"],
  " operator gives a less useful result. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.25"}],

Cell[CellGroupData[{

Cell["Head[a + b + c] == Times", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(Plus \[Equal] Times\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "In setting up conditionals, you will often need to use combinations of \
tests, such as ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["test",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["test",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  StyleBox["&&", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  ". An important point is that the result from this combination of tests \
will be ",
  StyleBox["False", "MR"],
  " if ",
  StyleBox["any", "TI"],
  " of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["test",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " yield ",
  StyleBox["False", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " always evaluates the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["test",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " in turn, stopping if any of the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["test",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " yield ",
  StyleBox["False", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.8", "8.26"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "evaluate until one of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " is found to be ",
              StyleBox["False", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["||", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["||", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "evaluate until one of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " is found to be ",
              StyleBox["True", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.8"],

Cell["Evaluation of logical expressions. ", "Caption",
  CellTags->"S2.6.8"],

Cell["This function involves a combination of two tests. ", "MathCaption",
  CellTags->{"S2.6.8", "8.27"}],

Cell["t[x_] := (x != 0 && 1/x < 3)", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.6.8"],

Cell["Here both tests are evaluated. ", "MathCaption",
  CellTags->{"S2.6.8", "8.28"}],

Cell[CellGroupData[{

Cell["t[2]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "Here the first test yields ",
  StyleBox["False", "MR"],
  ", so the second test is not tried. The second test would involve ",
  StyleBox["1/0", "MR"],
  ", and would generate an error. "
}], "MathCaption",
  CellTags->{"S2.6.8", "8.29"}],

Cell[CellGroupData[{

Cell["t[0]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.6.8"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.6.8"]
}, Open  ]],

Cell[TextData[{
  "The way that ",
  StyleBox["Mathematica", "TI"],
  " evaluates logical expressions allows you to combine sequences of tests \
where later tests may make sense only if the earlier ones are satisfied. The \
behavior, which is analogous to that found in languages such as C, is \
convenient in constructing many kinds of ",
  StyleBox["Mathematica", "TI"],
  " programs. "
}], "Text",
  CellTags->{"S2.6.8", "8.30"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.9 Loops and Control Structures", "Subsection",
  CellTags->{"S2.6.9", "9.1"}],

Cell[TextData[{
  "The execution of a ",
  StyleBox["Mathematica", "TI"],
  " program involves the evaluation of a sequence of ",
  StyleBox["Mathematica", "TI"],
  " expressions. In simple programs, the expressions to be evaluated may be \
separated by semicolons, and evaluated one after another. Often, however, you \
need to evaluate expressions several times, in some kind of \
\[OpenCurlyDoubleQuote]loop\[CloseCurlyDoubleQuote]. "
}], "Text",
  CellTags->{"S2.6.9", "9.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Do[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " repetitively, with ",
              StyleBox["i", "TI"],
              " varying from ",
              StyleBox["1", "MR"],
              " to ",
              StyleBox["imax", "TI"],
              " in steps of ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Do[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["i", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imin", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["imax", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["di", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " with ",
              StyleBox["i", "TI"],
              " varying from ",
              StyleBox["imin", "TI"],
              " to ",
              StyleBox["imax", "TI"],
              " in steps of ",
              StyleBox["di", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Do[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " ",
              StyleBox["n", "TI"],
              " times "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.9"],

Cell["Simple looping constructs. ", "Caption",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "This evaluates ",
  StyleBox["Print[i^2]", "MR"],
  ", with ",
  StyleBox["i", "MR"],
  " running from ",
  StyleBox["1", "MR"],
  " to ",
  StyleBox["4", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.3"}],

Cell[CellGroupData[{

Cell["Do[Print[i^2], {i, 4}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(4\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(9\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(16\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "This executes an assignment for ",
  StyleBox["t", "MR"],
  " in a loop with ",
  StyleBox["k", "MR"],
  " running from ",
  StyleBox["2", "MR"],
  " to ",
  StyleBox["6", "MR"],
  " in steps of ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.4"}],

Cell[CellGroupData[{

Cell["t = x; Do[t = 1/(1 + k t), {k, 2, 6, 2}]; t", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\/\(1 + 6\/\(1 + 4\/\(1 + 2\ x\)\)\)\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "The way iteration is specified in ",
  StyleBox["Do", "MR"],
  " is exactly the same as in functions like ",
  StyleBox["Table", "MR"],
  " and ",
  StyleBox["Sum", "MR"],
  ". Just as in those functions, you can set up several nested loops by \
giving a sequence of iteration specifications to ",
  StyleBox["Do", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.9", "9.5"}],

Cell[TextData[{
  "This loops over values of ",
  StyleBox["i", "MR"],
  " from ",
  StyleBox["1", "MR"],
  " to ",
  StyleBox["4", "MR"],
  ", and for each value of ",
  StyleBox["i", "MR"],
  ", loops over ",
  StyleBox["j", "MR"],
  " from ",
  StyleBox["1", "MR"],
  " to ",
  StyleBox["i-1", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.6"}],

Cell[CellGroupData[{

Cell["Do[Print[{i,j}], {i, 4}, {j, i-1}]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({2, 1}\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({3, 1}\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({3, 2}\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({4, 1}\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({4, 2}\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({4, 3}\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "Sometimes you may want to repeat a particular operation a certain number \
of times, without changing the value of an iteration variable. You can \
specify this kind of repetition in ",
  StyleBox["Do", "MR"],
  " just as you can in ",
  StyleBox["Table", "MR"],
  " and other iteration functions. "
}], "Text",
  CellTags->{"S2.6.9", "9.7"}],

Cell[TextData[{
  "This repeats the assignment ",
  StyleBox["t", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["1/(1+t)", "MR"],
  " three times. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.8"}],

Cell[CellGroupData[{

Cell["t = x; Do[t = 1/(1+t), {3}]; t", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\/\(1 + 1\/\(1 + 1\/\(1 + x\)\)\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "You can put a procedure inside ",
  StyleBox["Do", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.9"}],

Cell[CellGroupData[{

Cell["t = 67; Do[Print[t]; t = Floor[t/2], {3}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(67\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(33\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(16\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Nest[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to ",
              StyleBox["expr", "TI"],
              " ",
              StyleBox["n", "TI"],
              " times "
            }]]},
          {Cell[TextData[{
              StyleBox["FixedPoint[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "start with ",
              StyleBox["expr", "TI"],
              ", and apply ",
              StyleBox["f", "TI"],
              " repeatedly until the result no longer changes "
            }]]},
          {Cell[TextData[{
              StyleBox["NestWhile[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "start with ",
              StyleBox["expr", "TI"],
              ", and apply ",
              StyleBox["f", "TI"],
              " repeatedly until applying ",
              StyleBox["test", "TI"],
              " to the result no longer yields ",
              StyleBox["True", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.9"],

Cell["Applying functions repetitively. ", "Caption",
  CellTags->"S2.6.9"],

Cell[TextData[{
  StyleBox["Do", "MR"],
  " allows you to repeat operations by evaluating a particular expression \
many times with different values for iteration variables. Often, however, you \
can make more elegant and efficient programs using the functional programming \
constructs discussed in Section ",
  ButtonBox["2.2.2",
    ButtonData:>{"2.2.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ". ",
  StyleBox["Nest[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ", for example, allows you to apply a function repeatedly to an expression. \
"
}], "Text",
  CellTags->{"S2.6.9", "9.10"}],

Cell[TextData[{
  "This nests ",
  StyleBox["f", "MR"],
  " three times. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.11"}],

Cell[CellGroupData[{

Cell["Nest[f, x, 3]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(f[f[f[x]]]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "By nesting a pure function, you can get the same result as in the example \
with ",
  StyleBox["Do", "MR"],
  " above. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.12"}],

Cell[CellGroupData[{

Cell["Nest[ Function[t, 1/(1+t)], x, 3 ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\/\(1 + 1\/\(1 + 1\/\(1 + x\)\)\)\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Nest", "MR"],
  " allows you to apply a function a specified number of times. Sometimes, \
however, you may simply want to go on applying a function until the results \
you get no longer change. You can do this using ",
  StyleBox["FixedPoint[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.9", "9.13"}],

Cell[TextData[{
  StyleBox["FixedPoint", "MR"],
  " goes on applying a function until the result no longer changes. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.14"}],

Cell[CellGroupData[{

Cell["FixedPoint[Function[t, Print[t]; Floor[t/2]], 67]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(67\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(33\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(16\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(8\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(4\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(0\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["FixedPoint", "MR"],
  " to imitate the evaluation process in ",
  StyleBox["Mathematica", "TI"],
  ", or the operation of functions such as ",
  StyleBox["expr", "TI"],
  " ",
  StyleBox["//.", "MR"],
  " ",
  StyleBox["rules", "TI"],
  ". ",
  StyleBox["FixedPoint", "MR"],
  " goes on until two successive results it gets are the same. ",
  StyleBox["NestWhile", "MR"],
  " allows you to go on until an arbitrary function no longer yields ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.9", "9.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Catch[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " until ",
              StyleBox["Throw[", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " is encountered, then return ",
              StyleBox["value", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Catch[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " until ",
              StyleBox["Throw[", "MR"],
              StyleBox["value", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " is encountered, where ",
              StyleBox["form", "TI"],
              " matches ",
              StyleBox["tag", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Catch[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return ",
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["value", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " instead of ",
              StyleBox["value", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.9"],

Cell["\<\
Non\[Hyphen]local control of evaluation. \
\>", "Caption",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "When the ",
  StyleBox["Throw", "MR"],
  " is encountered, evaluation stops, and the current value of ",
  StyleBox["i", "MR"],
  " is returned as the value of the enclosing ",
  StyleBox["Catch", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.16"}],

Cell[CellGroupData[{

Cell["Catch[Do[Print[i]; If[i > 3, Throw[i]], {i, 10}]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(3\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(4\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  " provide a flexible way to control the process of evaluation in ",
  StyleBox["Mathematica", "TI"],
  ". The basic idea is that whenever a ",
  StyleBox["Throw", "MR"],
  " is encountered, the evaluation that is then being done is stopped, and ",
  StyleBox["Mathematica", "TI"],
  " immediately returns to the nearest appropriate enclosing ",
  StyleBox["Catch", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.6.9", "9.17"}],

Cell[TextData[{
  StyleBox["Scan", "MR"],
  " applies the function ",
  StyleBox["Print", "MR"],
  " to each successive element in the list, and in the end just returns ",
  StyleBox["Null", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.18"}],

Cell[CellGroupData[{

Cell["Scan[Print, {7, 6, 5, 4}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(7\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(4\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "The evaluation of ",
  StyleBox["Scan", "MR"],
  " stops as soon as ",
  StyleBox["Throw", "MR"],
  " is encountered, and the enclosing ",
  StyleBox["Catch", "MR"],
  " returns as its value the argument of ",
  StyleBox["Throw", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.19"}],

Cell[CellGroupData[{

Cell["Catch[Scan[(Print[#]; If[# < 6, Throw[#]])&, {7, 6, 5, 4}]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(7\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "The same result is obtained with ",
  StyleBox["Map", "MR"],
  ", even though ",
  StyleBox["Map", "MR"],
  " would have returned a list if its evaluation had not been stopped by \
encountering a ",
  StyleBox["Throw", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.20"}],

Cell[CellGroupData[{

Cell["Catch[Map[(Print[#]; If[# < 6, Throw[#]])&, {7, 6, 5, 4}]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(7\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  " to divert the operation of functional programming constructs, allowing \
for example the evaluation of such constructs to continue only until some \
condition has been met. Note that if you stop evaluation using ",
  StyleBox["Throw", "MR"],
  ", then the structure of the result you get may be quite different from \
what you would have got if you had allowed the evaluation to complete. "
}], "Text",
  CellTags->{"S2.6.9", "9.21"}],

Cell["\<\
Here is a list generated by repeated application of a function. \
\
\>", "MathCaption",
  CellTags->{"S2.6.9", "9.22"}],

Cell[CellGroupData[{

Cell["NestList[1/(# + 1)&, -2.5, 6]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({\(-2.5`\), \(-0.6666666666666666`\), 2.9999999999999996`, 0.25`, 0.8`, 
      0.5555555555555556`, 0.6428571428571428`}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "Since there is no ",
  StyleBox["Throw", "MR"],
  " encountered, the result here is just as before. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.23"}],

Cell[CellGroupData[{

Cell["Catch[ NestList[1/(# + 1)&, -2.5, 6] ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \({\(-2.5`\), \(-0.6666666666666666`\), 2.9999999999999996`, 0.25`, 0.8`, 
      0.5555555555555556`, 0.6428571428571428`}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "Now the evaluation of the ",
  StyleBox["NestList", "MR"],
  " is diverted, and the single number given as the argument of ",
  StyleBox["Throw", "MR"],
  " is returned."
}], "MathCaption",
  CellTags->{"S2.6.9", "9.24"}],

Cell[CellGroupData[{

Cell["Catch[ NestList [If[# > 1, Throw[#], 1/(# + 1)]&, -2.5, 6] ]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2.9999999999999996`\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  " operate in a completely global way: it does not matter how or where a ",
  StyleBox["Throw", "MR"],
  " is generated\[LongDash]it will always stop evaluation and return to the \
enclosing ",
  StyleBox["Catch", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.9", "9.25"}],

Cell[TextData[{
  "The ",
  StyleBox["Throw", "MR"],
  " stops the evaluation of ",
  StyleBox["f", "MR"],
  ", and causes the ",
  StyleBox["Catch", "MR"],
  " to return just ",
  StyleBox["a", "MR"],
  ", with no trace of ",
  StyleBox["f", "MR"],
  " left. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.26"}],

Cell[CellGroupData[{

Cell["Catch[ f[ Throw[ a ] ] ]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(a\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "This defines a function which generates a ",
  StyleBox["Throw", "MR"],
  " when its argument is larger than 10. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.27"}],

Cell["g[x_] := If[x > 10, Throw[overflow], x!]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "No ",
  StyleBox["Throw", "MR"],
  " is generated here. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.28"}],

Cell[CellGroupData[{

Cell["Catch[ g[4] ]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(24\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "But here the ",
  StyleBox["Throw", "MR"],
  " generated inside the evaluation of ",
  StyleBox["g", "MR"],
  " returns to the enclosing ",
  StyleBox["Catch", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.29"}],

Cell[CellGroupData[{

Cell["Catch[ g[40] ]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(overflow\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "In small programs, it is often adequate to use ",
  StyleBox["Throw[", "MR"],
  StyleBox["value", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Catch[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " in their simplest form. But particularly if you write larger programs \
that contain many separate pieces, it is usually much better to use ",
  StyleBox["Throw[", "MR"],
  StyleBox["value", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Catch[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  ". By keeping the expressions ",
  StyleBox["tag", "TI"],
  " and ",
  StyleBox["form", "TI"],
  " local to a particular piece of your program, you can then ensure that \
your ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  " will also operate only within that piece.  "
}], "Text",
  CellTags->{"S2.6.9", "9.30"}],

Cell[TextData[{
  "Here the ",
  StyleBox["Throw", "MR"],
  " is caught by the inner ",
  StyleBox["Catch", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.31"}],

Cell[CellGroupData[{

Cell["Catch[ f [ Catch[ Throw[x, a], a ] ], b ]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(f[x]\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "But here it is caught only by the outer ",
  StyleBox["Catch", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.32"}],

Cell[CellGroupData[{

Cell["Catch[ f [ Catch[ Throw[x, b], a ] ], b ]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "You can use patterns in specifying the tags which a particular ",
  StyleBox["Catch", "MR"],
  " should catch. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.33"}],

Cell[CellGroupData[{

Cell["Catch[ Throw[x, a], a | b ]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "This keeps the tag ",
  StyleBox["a", "MR"],
  " completely local. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.34"}],

Cell[CellGroupData[{

Cell["Module[{a}, Catch[ Throw[x, a], a] ]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "You should realize that there is no need for the tag that appears in ",
  StyleBox["Throw", "MR"],
  " to be a constant; in general it can be any expression.  "
}], "Text",
  CellTags->{"S2.6.9", "9.35"}],

Cell[TextData[{
  "Here the inner ",
  StyleBox["Catch", "MR"],
  " catches all throws with tags less than 4, and continues the ",
  StyleBox["Do", "MR"],
  ". But as soon as the tag reaches 4, the outer ",
  StyleBox["Catch", "MR"],
  " is needed. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.36"}],

Cell[CellGroupData[{

Cell["Catch[ Do[ Catch[ Throw[i^2, i], n_ /; n < 4], {i, 10} ], _]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(16\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["Catch[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " with ",
  StyleBox["Throw[", "MR"],
  StyleBox["value", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag", "TI"],
  StyleBox["]", "MR"],
  ", the value returned by ",
  StyleBox["Catch", "MR"],
  " is simply the expression ",
  StyleBox["value", "TI"],
  " given in the ",
  StyleBox["Throw", "MR"],
  ". If you use ",
  StyleBox["Catch[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  ", however, then the value returned by ",
  StyleBox["Catch", "MR"],
  " is instead ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["value", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.9", "9.37"}],

Cell[TextData[{
  "Here ",
  StyleBox["f", "MR"],
  " is applied to the value and tag in the ",
  StyleBox["Throw", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.38"}],

Cell[CellGroupData[{

Cell["Catch[ Throw[ x, a ], a, f ]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(f[x, a]\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "If there is no ",
  StyleBox["Throw", "MR"],
  ", ",
  StyleBox["f", "MR"],
  " is never used. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.39"}],

Cell[CellGroupData[{

Cell["Catch[ x, a, f ]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["While[", "MR"],
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["body", "TI"],
              " repetitively, so long as ",
              StyleBox["test", "TI"],
              " is ",
              StyleBox["True", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["For[", "MR"],
              StyleBox["start", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["test", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["incr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["start", "TI"],
              ", then repetitively evaluate ",
              StyleBox["body", "TI"],
              " and ",
              StyleBox["incr", "TI"],
              ", until ",
              StyleBox["test", "TI"],
              " fails "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.9"],

Cell["General loop constructs. ", "Caption",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "Functions like ",
  StyleBox["Do", "MR"],
  ", ",
  StyleBox["Nest", "MR"],
  " and ",
  StyleBox["FixedPoint", "MR"],
  " provide structured ways to make loops in ",
  StyleBox["Mathematica", "TI"],
  " programs, while ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  " provide opportunities for modifying this structure. Sometimes, however, \
you may want to create loops that even from the outset have less structure. \
And in such cases, you may find it convenient to use the functions ",
  StyleBox["While", "MR"],
  " and ",
  StyleBox["For", "MR"],
  ", which perform operations repeatedly, stopping when a specified condition \
fails to be true. "
}], "Text",
  CellTags->{"S2.6.9", "9.40"}],

Cell[TextData[{
  "The ",
  StyleBox["While", "MR"],
  " loop continues until the condition fails. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.41"}],

Cell[CellGroupData[{

Cell["n = 17; While[(n = Floor[n/2]) != 0, Print[n]]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(8\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(4\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  StyleBox["While", "MR"],
  " and ",
  StyleBox["For", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " are similar to the control structures ",
  StyleBox["while", "MR"],
  " and ",
  StyleBox["for", "MR"],
  " in languages such as C. Notice, however, that there are a number of \
important differences. For example, the roles of comma and semicolon are \
reversed in ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["For", "MR"],
  " loops relative to C language ones."
}], "Text",
  CellTags->{"S2.6.9", "9.42"}],

Cell[TextData[{
  "This is a very common form for a ",
  StyleBox["For", "MR"],
  " loop. ",
  StyleBox["i++", "MR"],
  " increments the value of ",
  StyleBox["i", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.43"}],

Cell[CellGroupData[{

Cell["For[i=1, i < 4, i++, Print[i]]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(3\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "Here is a more complicated ",
  StyleBox["For", "MR"],
  " loop. Notice that the loop terminates as soon as the test ",
  StyleBox["i^2", "MR"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["10", "MR"],
  " fails. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.44"}],

Cell[CellGroupData[{

Cell["For[i=1; t=x, i^2 < 10, i++, t = t^2 + i; Print[t]]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1 + x\^2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2 + \((1 + x\^2)\)\^2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(3 + \((2 + \((1 + x\^2)\)\^2)\)\^2\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", both ",
  StyleBox["While", "MR"],
  " and ",
  StyleBox["For", "MR"],
  " always evaluate the loop test before evaluating the body of the loop. As \
soon as the loop test fails to be ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["While", "MR"],
  " and ",
  StyleBox["For", "MR"],
  " terminate. The body of the loop is thus only evaluated in situations \
where the loop test is ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.9", "9.45"}],

Cell["\<\
The loop test fails immediately, so the body of the loop is never \
evaluated. \
\>", "MathCaption",
  CellTags->{"S2.6.9", "9.46"}],

Cell["While[False, Print[x]]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "In a ",
  StyleBox["While", "MR"],
  " or ",
  StyleBox["For", "MR"],
  " loop, or in general in any ",
  StyleBox["Mathematica", "TI"],
  " procedure, the ",
  StyleBox["Mathematica", "TI"],
  " expressions you give are evaluated in a definite sequence. You can think \
of this sequence as defining the \[OpenCurlyDoubleQuote]flow of control\
\[CloseCurlyDoubleQuote] in the execution of a ",
  StyleBox["Mathematica", "TI"],
  " program. "
}], "Text",
  CellTags->{"S2.6.9", "9.47"}],

Cell[TextData[{
  "In most cases, you should try to keep the flow of control in your ",
  StyleBox["Mathematica", "TI"],
  " programs as simple as possible. The more the flow of control depends for \
example on specific values generated during the execution of the program, the \
more difficult you will typically find it to understand the structure and \
operation of the program. "
}], "Text",
  CellTags->{"S2.6.9", "9.48"}],

Cell[TextData[{
  "Functional programming constructs typically involve very simple flow of \
control. ",
  StyleBox["While", "MR"],
  " and ",
  StyleBox["For", "MR"],
  " loops are always more complicated, since they are set up to make the flow \
of control depend on the values of the expressions given as tests. \
Nevertheless, even in such loops, the flow of control does not usually depend \
on the values of expressions given in the body of the loop. "
}], "Text",
  CellTags->{"S2.6.9", "9.49"}],

Cell[TextData[{
  "In some cases, however, you may need to construct ",
  StyleBox["Mathematica", "TI"],
  " programs in which the flow of control is affected by values generated \
during the execution of a procedure or of the body of a loop. One way to do \
this, which fits in with functional programming ideas, is to use ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  ". But ",
  StyleBox["Mathematica", "TI"],
  " also provides various functions for modifying the flow of control which \
work like in languages such as C. "
}], "Text",
  CellTags->{"S2.6.9", "9.50"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Break[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["exit the nearest enclosing loop "]},
          {Cell[TextData[{
              StyleBox["Continue[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["go to the next step in the current loop "]},
          {Cell[TextData[{
              StyleBox["Return[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return the value ",
              StyleBox["expr", "TI"],
              ", exiting all procedures and loops in a function "
            }]]},
          {Cell[TextData[{
              StyleBox["Goto[", "MR"],
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "go to the element ",
              StyleBox["Label[", "MR"],
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " in the current procedure "
            }]]},
          {Cell[TextData[{
              StyleBox["Throw[", "MR"],
              StyleBox["value", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "return ",
              StyleBox["value", "TI"],
              " as the value of the nearest enclosing ",
              StyleBox["Catch", "MR"],
              " (non\[Hyphen]local return) "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.9"],

Cell["Control flow functions. ", "Caption",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "The ",
  StyleBox["Break[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " causes the loop to terminate as soon as ",
  StyleBox["t", "MR"],
  " exceeds ",
  StyleBox["19", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.51"}],

Cell[CellGroupData[{

Cell["t = 1; Do[t *= k; Print[t]; If[t > 19, Break[]], {k, 10}]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(24\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["k", "MR"],
  " ",
  StyleBox["<", "MR"],
  " ",
  StyleBox["3", "MR"],
  ", the ",
  StyleBox["Continue[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " causes the loop to be continued, without executing ",
  StyleBox["t", "MR"],
  " ",
  StyleBox["+=", "MR"],
  " ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.52"}],

Cell[CellGroupData[{

Cell["\<\
t = 1; Do[t *= k; Print[t]; If[k < 3, Continue[]]; t += 2, {k, 10}]\
\
\>", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(6\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(32\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(170\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(1032\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(7238\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(57920\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(521298\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5213000\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Return[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " allows you to exit a particular function, returning a value. You can \
think of ",
  StyleBox["Throw", "MR"],
  " as a kind of non\[Hyphen]local return which allows you to exit a whole \
sequence of nested functions. Such behavior can be convenient for handling \
certain error conditions. "
}], "Text",
  CellTags->{"S2.6.9", "9.53"}],

Cell[TextData[{
  "Here is an example of the use of ",
  StyleBox["Return", "MR"],
  ". This particular procedure could equally well have been written without \
using ",
  StyleBox["Return", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.54"}],

Cell["f[x_] := (If[x > 5, Return[big]]; t = x^3; Return[t - 7])", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "When the argument is greater than 5, the first ",
  StyleBox["Return", "MR"],
  " in the procedure is used. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.55"}],

Cell[CellGroupData[{

Cell["f[10]", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(big\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "This function \[OpenCurlyDoubleQuote]throws\[CloseCurlyDoubleQuote] ",
  StyleBox["error", "MR"],
  " if its argument is negative. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.56"}],

Cell["h[x_] := If[x < 0, Throw[error], Sqrt[x]]", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S2.6.9"],

Cell[TextData[{
  "No ",
  StyleBox["Throw", "MR"],
  " is generated here. "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.57"}],

Cell[CellGroupData[{

Cell["Catch[ h[6] + 2 ]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2 + \@6\)], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "But in this case a ",
  StyleBox["Throw", "MR"],
  " is generated, and the whole ",
  StyleBox["Catch", "MR"],
  " returns the value ",
  StyleBox["error", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.58"}],

Cell[CellGroupData[{

Cell["Catch[ h[-6] + 2 ]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(error\)], "Output",
  CellLabel->"Out[37]= ",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["Continue[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Break[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " allow you to \[OpenCurlyDoubleQuote]transfer control\
\[CloseCurlyDoubleQuote] to the beginning or end of a loop in a ",
  StyleBox["Mathematica", "TI"],
  " program. Sometimes you may instead need to transfer control to a \
particular element in a ",
  StyleBox["Mathematica", "TI"],
  " procedure. If you give a ",
  StyleBox["Label", "MR"],
  " as an element in a procedure, you can use ",
  StyleBox["Goto", "MR"],
  " to transfer control to this element. "
}], "Text",
  CellTags->{"S2.6.9", "9.59"}],

Cell[TextData[{
  "This goes on looping until ",
  StyleBox["q", "MR"],
  " exceeds ",
  StyleBox["6", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.9", "9.60"}],

Cell[CellGroupData[{

Cell["\<\
(q = 2; Label[begin]; Print[q]; q += 3; If[q < 6, \
Goto[begin]])\
\>", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(2\)], "Print",
  CellTags->"S2.6.9"],

Cell[BoxData[
    \(5\)], "Print",
  CellTags->"S2.6.9"]
}, Open  ]],

Cell[TextData[{
  "Note that you can use ",
  StyleBox["Goto", "MR"],
  " in a particular ",
  StyleBox["Mathematica", "TI"],
  " procedure only when the ",
  StyleBox["Label", "MR"],
  " it specifies occurs as an element of the same ",
  StyleBox["Mathematica", "TI"],
  " procedure. In general, use of ",
  StyleBox["Goto", "MR"],
  " reduces the degree of structure that can readily be perceived in a \
program, and therefore makes the operation of the program more difficult to \
understand. "
}], "Text",
  CellTags->{"S2.6.9", "9.61"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.10 Collecting Expressions During Evaluation", "Subsection",
  CellTags->{"S2.6.10", "10.1"}],

Cell[TextData[{
  "In many computations one is concerned only with the final result of \
evaluating the expression given as input. But sometimes one also wants to \
collect expressions that were generated in the course of the evaluation. You \
can do this using ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.10", "10.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sow[", "MR"],
              StyleBox["val", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sow the value ",
              StyleBox["val", "TI"],
              " for the nearest enclosing ",
              StyleBox["Reap", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reap[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              ", returning also a list of values sown by ",
              StyleBox["Sow", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.10"],

Cell[TextData[{
  "Using ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.6.10"],

Cell["Here the output contains only the final result. ", "MathCaption",
  CellTags->{"S2.6.10", "10.3"}],

Cell[CellGroupData[{

Cell["a = 3; a += a^2 + 1; a = Sqrt[a + a^2]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \(\@182\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell["Here two intermediate results are also given. ", "MathCaption",
  CellTags->{"S2.6.10", "10.4"}],

Cell[CellGroupData[{

Cell["Reap[Sow[a = 3]; a += Sow[a^2 + 1]; a = Sqrt[a + a^2]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({\@182, {{3, 10}}}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell["This computes a sum, collecting all terms that are even. ", \
"MathCaption",
  CellTags->{"S2.6.10", "10.5"}],

Cell[CellGroupData[{

Cell["Reap[Sum[If[EvenQ[#], Sow[#], #]& [i^2 + 1], {i, 10}]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({395, {{2, 10, 26, 50, 82}}}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell[TextData[{
  "Like ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  ", ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  " can be used anywhere in a computation. "
}], "Text",
  CellTags->{"S2.6.10", "10.6"}],

Cell[TextData[{
  "This defines a function that can do a ",
  StyleBox["Sow", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.10", "10.7"}],

Cell["f[x_] := (If[x < 1/2, Sow[x]]; 3.5 x (1 - x))", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.10"],

Cell["This nests the function, reaping all cases below 1/2. ", "MathCaption",
  CellTags->{"S2.6.10", "10.8"}],

Cell[CellGroupData[{

Cell["Reap[Nest[f, 0.8, 10]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({0.8683116395335331`, {{0.41533183999999984`, 0.4464715508717464`, 
          0.4087853964906163`, 0.45628546999822267`}}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sow[", "MR"],
              StyleBox["val", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "sow ",
              StyleBox["val", "TI"],
              " with a tag to indicate when to reap "
            }]]},
          {Cell[TextData[{
              StyleBox["Sow[", "MR"],
              StyleBox["val", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["tag",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["tag",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "sow ",
              StyleBox["val", "TI"],
              " for each of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["tag",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reap[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "reap all values whose tags match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reap[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "make separate lists for each of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Reap[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["form",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "apply ",
              StyleBox["f", "TI"],
              " to each distinct tag and list of values "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False}},
  CellTags->"S2.6.10"],

Cell["Sowing and reaping with tags. ", "Caption",
  CellTags->"S2.6.10"],

Cell[TextData[{
  "This reaps only values sown with tag\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.10", "10.9"}],

Cell[CellGroupData[{

Cell["Reap[Sow[1, x]; Sow[2, y]; Sow[3, x], x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({3, {{1, 3}}}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["1", "MR"],
  " is sown twice with tag ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.10", "10.10"}],

Cell[CellGroupData[{

Cell["Reap[Sow[1, {x, x}]; Sow[2, y]; Sow[3, x], x]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({3, {{1, 1, 3}}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell["\<\
Values sown with different tags always appear in different \
sublists. \
\>", "MathCaption",
  CellTags->{"S2.6.10", "10.11"}],

Cell[CellGroupData[{

Cell["Reap[Sow[1, {x, x}]; Sow[2, y]; Sow[3, x]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({3, {{1, 1, 3}, {2}}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell["The makes a sublist for each form of tag being reaped. ", "MathCaption",
  CellTags->{"S2.6.10", "10.12"}],

Cell[CellGroupData[{

Cell["Reap[Sow[1, {x, x}]; Sow[2, y]; Sow[3, x], {x, x, y}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({3, {{{1, 1, 3}}, {{1, 1, 3}}, {{2}}}}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell[TextData[{
  "This applies ",
  StyleBox["f", "MR"],
  " to each distinct tag and list of values. "
}], "MathCaption",
  CellTags->{"S2.6.10", "10.13"}],

Cell[CellGroupData[{

Cell["Reap[Sow[1, {x, x}]; Sow[2, y]; Sow[3, x], _, f]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({3, {f[x, {1, 1, 3}], f[y, {2}]}}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.6.10"]
}, Open  ]],

Cell["The tags can be part of the computation. ", "MathCaption",
  CellTags->{"S2.6.10", "10.14"}],

Cell[CellGroupData[{

Cell["Reap[Do[Sow[i/j, GCD[i, j]], {i, 4}, {j, i}]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.10"],

Cell[BoxData[
    \({Null, {{1, 2, 3, 3\/2, 4, 4\/3}, {1, 2}, {1}, {1}}}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.11 Advanced Topic: Tracing Evaluation", "Subsection",
  CellTags->{"S2.6.11", "11.1"}],

Cell[TextData[{
  "The standard way in which ",
  StyleBox["Mathematica", "TI"],
  " works is to take any expression you give as input, evaluate the \
expression completely, and then return the result. When you are trying to \
understand what ",
  StyleBox["Mathematica", "TI"],
  " is doing, however, it is often worthwhile to look not just at the final \
result of evaluation, but also at intermediate steps in the evaluation \
process. "
}], "Text",
  CellTags->{"S2.6.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a list of all expressions used in the evaluation of ",
              
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "include only expressions which match the pattern ",
              StyleBox["form", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["Tracing the evaluation of expressions. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "The expression ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " is evaluated immediately to ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.3"}],

Cell[CellGroupData[{

Cell["Trace[1 + 1]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(1 + 1\),
          HoldForm], ",", 
        TagBox["2",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["2^3", "MR"],
  " is evaluated before the addition is done. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.4"}],

Cell[CellGroupData[{

Cell["Trace[2^3 + 4]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(2\^3\),
              HoldForm], ",", 
            TagBox["8",
              HoldForm]}], "}"}], ",", 
        TagBox[\(8 + 4\),
          HoldForm], ",", 
        TagBox["12",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["\<\
The evaluation of each subexpression is shown in a separate \
sublist. \
\>", "MathCaption",
  CellTags->{"S2.6.11", "11.5"}],

Cell[CellGroupData[{

Cell["Trace[2^3 + 4^2 + 1]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(2\^3\),
              HoldForm], ",", 
            TagBox["8",
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(4\^2\),
              HoldForm], ",", 
            TagBox["16",
              HoldForm]}], "}"}], ",", 
        TagBox[\(8 + 16 + 1\),
          HoldForm], ",", 
        TagBox["25",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " gives a list which includes ",
  StyleBox["all", "TI"],
  " the intermediate expressions involved in the evaluation of ",
  StyleBox["expr", "TI"],
  ". Except in rather simple cases, however, the number of intermediate \
expressions generated in this way is typically very large, and the list \
returned by ",
  StyleBox["Trace", "MR"],
  " is difficult to understand. "
}], "Text",
  CellTags->{"S2.6.11", "11.6"}],

Cell[TextData[{
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " allows you to \[OpenCurlyDoubleQuote]filter\[CloseCurlyDoubleQuote] the \
expressions that ",
  StyleBox["Trace", "MR"],
  " records, keeping only those which match the pattern ",
  StyleBox["form", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.7"}],

Cell["Here is a recursive definition of a factorial function. ", "MathCaption",
  CellTags->{"S2.6.11", "11.8"}],

Cell[CellGroupData[{

Cell["fac[n_] := n fac[n-1]; fac[1] = 1", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This gives ",
  StyleBox["all", "TI"],
  " the intermediate expressions generated in the evaluation of ",
  StyleBox["fac[3]", "MR"],
  ". The result is quite complicated. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.9"}],

Cell[CellGroupData[{

Cell["Trace[fac[3]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[3]\),
          HoldForm], ",", 
        TagBox[\(3\ fac[3 - 1]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox[\(3 - 1\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(fac[2]\),
              HoldForm], ",", 
            TagBox[\(2\ fac[2 - 1]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(2 - 1\),
                      HoldForm], ",", 
                    TagBox["1",
                      HoldForm]}], "}"}], ",", 
                TagBox[\(fac[1]\),
                  HoldForm], ",", 
                TagBox["1",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(2\ 1\),
              HoldForm], ",", 
            TagBox["2",
              HoldForm]}], "}"}], ",", 
        TagBox[\(3\ 2\),
          HoldForm], ",", 
        TagBox["6",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows only intermediate expressions of the form ",
  StyleBox["fac[n_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.10"}],

Cell[CellGroupData[{

Cell["Trace[fac[3], fac[n_]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[3]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[2]\),
              HoldForm], ",", 
            RowBox[{"{", 
              TagBox[\(fac[1]\),
                HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "You can specify any pattern in ",
  StyleBox["Trace", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.11"}],

Cell[CellGroupData[{

Cell["Trace[fac[10], fac[n_/;n > 5]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[10]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[9]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[8]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(fac[7]\),
                      HoldForm], ",", 
                    RowBox[{"{", 
                      TagBox[\(fac[6]\),
                        HoldForm], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
      "}"}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " effectively works by intercepting every expression that is about to be \
evaluated during the evaluation of ",
  StyleBox["expr", "TI"],
  ", and picking out those that match the pattern ",
  StyleBox["form", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.12"}],

Cell[TextData[{
  "If you want to trace \[OpenCurlyDoubleQuote]calls\[CloseCurlyDoubleQuote] \
to a function like ",
  StyleBox["fac", "MR"],
  ", you can do so simply by telling ",
  StyleBox["Trace", "MR"],
  " to pick out expressions of the form ",
  StyleBox["fac[n_]", "MR"],
  ". You can also use patterns like ",
  StyleBox["f[n_,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  " to pick out calls with particular argument structure. "
}], "Text",
  CellTags->{"S2.6.11", "11.13"}],

Cell[TextData[{
  "A typical ",
  StyleBox["Mathematica", "TI"],
  " program, however, consists not only of \[OpenCurlyDoubleQuote]function \
calls\[CloseCurlyDoubleQuote] like ",
  StyleBox["fac[n]", "MR"],
  ", but also of other elements, such as assignments to variables, control \
structures, and so on. All of these elements are represented as expressions. \
As a result, you can use patterns in ",
  StyleBox["Trace", "MR"],
  " to pick out any kind of ",
  StyleBox["Mathematica", "TI"],
  " program element. Thus, for example, you can use a pattern like ",
  StyleBox["k", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["_", "MR"],
  " to pick out all assignments to the symbol ",
  StyleBox["k", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.14"}],

Cell[TextData[{
  "This shows the sequence of assignments made for ",
  StyleBox["k", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.15"}],

Cell[CellGroupData[{

Cell["Trace[(k=2; For[i=1, i<4, i++, k = i/k]; k), k=_]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          TagBox[\(k = 2\),
            HoldForm], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              TagBox[\(k = 1\/2\),
                HoldForm], "}"}], ",", 
            RowBox[{"{", 
              TagBox[\(k = 4\),
                HoldForm], "}"}], ",", 
            RowBox[{"{", 
              TagBox[\(k = 3\/4\),
                HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " can pick out expressions that occur at any time in the evaluation of ",
  StyleBox["expr", "TI"],
  ". The expressions need not, for example, appear directly in the form of ",
  StyleBox["expr", "TI"],
  " that you give. They may instead occur, say, during the evaluation of \
functions that are called as part of the evaluation of ",
  StyleBox["expr", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.16"}],

Cell["Here is a function definition. ", "MathCaption",
  CellTags->{"S2.6.11", "11.17"}],

Cell["h[n_] := (k=n/2; Do[k = i/k, {i, n}]; k)", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "You can look for expressions generated during the evaluation of ",
  StyleBox["h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.18"}],

Cell[CellGroupData[{

Cell["Trace[h[3], k=_]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          TagBox[\(k = 3\/2\),
            HoldForm], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              TagBox[\(k = 2\/3\),
                HoldForm], "}"}], ",", 
            RowBox[{"{", 
              TagBox[\(k = 3\),
                HoldForm], "}"}], ",", 
            RowBox[{"{", 
              TagBox[\(k = 1\),
                HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Trace", "MR"],
  " allows you to monitor intermediate steps in the evaluation not only of \
functions that you define, but also of some functions that are built into ",
  StyleBox["Mathematica", "TI"],
  ". You should realize, however, that the specific sequence of intermediate \
steps followed by built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions depends in detail on their implementation and optimization in a \
particular version of ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["[___]]", "MR"],
              " "
            }]], Cell[TextData[{
              "show all calls to the function ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["i", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["_]", "MR"],
              " "
            }]], Cell[TextData[{
              "show assignments to ",
              StyleBox["i", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["_", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["_]", "MR"],
              " "
            }]], Cell["show all assignments "]},
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["Message[___]]", "MR"],
              " "
            }]], Cell["show messages generated "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell[TextData[{
  "Some ways to use ",
  StyleBox["Trace", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "The function ",
  StyleBox["Trace", "MR"],
  " returns a list that represents the \[OpenCurlyDoubleQuote]history\
\[CloseCurlyDoubleQuote] of a ",
  StyleBox["Mathematica", "TI"],
  " computation. The expressions in the list are given in the order that they \
were generated during the computation. In most cases, the list returned by ",
  StyleBox["Trace", "MR"],
  " has a nested structure, which represents the \
\[OpenCurlyDoubleQuote]structure\[CloseCurlyDoubleQuote] of the computation. \
"
}], "Text",
  CellTags->{"S2.6.11", "11.20"}],

Cell[TextData[{
  "The basic idea is that each sublist in the list returned by ",
  StyleBox["Trace", "MR"],
  " represents the \[OpenCurlyDoubleQuote]evaluation chain\
\[CloseCurlyDoubleQuote] for a particular ",
  StyleBox["Mathematica", "TI"],
  " expression. The elements of this chain correspond to different forms of \
the same expression. Usually, however, the evaluation of one expression \
requires the evaluation of a number of other expressions, often \
subexpressions. Each subsidiary evaluation is represented by a sublist in the \
structure returned by ",
  StyleBox["Trace", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.21"}],

Cell["Here is a sequence of assignments. ", "MathCaption",
  CellTags->{"S2.6.11", "11.22"}],

Cell[CellGroupData[{

Cell["a[1] = a[2]; a[2] = a[3]; a[3] = a[4]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(a[4]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This yields an evaluation chain reflecting the sequence of transformations \
for ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox["]", "MR"],
  " used. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.23"}],

Cell[CellGroupData[{

Cell["Trace[a[1]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(a[1]\),
          HoldForm], ",", 
        TagBox[\(a[2]\),
          HoldForm], ",", 
        TagBox[\(a[3]\),
          HoldForm], ",", 
        TagBox[\(a[4]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The successive forms generated in the simplification of ",
  StyleBox["y", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  " show up as successive elements in its evaluation chain. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.24"}],

Cell[CellGroupData[{

Cell["Trace[y + x + y]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(y + x + y\),
          HoldForm], ",", 
        TagBox[\(x + y + y\),
          HoldForm], ",", 
        TagBox[\(x + 2\ y\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "Each argument of the function ",
  StyleBox["f", "MR"],
  " has a separate evaluation chain, given in a sublist. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.25"}],

Cell[CellGroupData[{

Cell["Trace[f[1 + 1, 2 + 3, 4 + 5]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(1 + 1\),
              HoldForm], ",", 
            TagBox["2",
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(2 + 3\),
              HoldForm], ",", 
            TagBox["5",
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(4 + 5\),
              HoldForm], ",", 
            TagBox["9",
              HoldForm]}], "}"}], ",", 
        TagBox[\(f[2, 5, 9]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["\<\
The evaluation chain for each subexpression is given in a separate \
sublist. \
\>", "MathCaption",
  CellTags->{"S2.6.11", "11.26"}],

Cell[CellGroupData[{

Cell["Trace[x x + y y]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(x\ x\),
              HoldForm], ",", 
            TagBox[\(x\^2\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(y\ y\),
              HoldForm], ",", 
            TagBox[\(y\^2\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(x\^2 + y\^2\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["\<\
Tracing the evaluation of a nested expression yields a nested list. \
\
\>", "MathCaption",
  CellTags->{"S2.6.11", "11.27"}],

Cell[CellGroupData[{

Cell["Trace[f[f[f[1 + 1]]]]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(1 + 1\),
                      HoldForm], ",", 
                    TagBox["2",
                      HoldForm]}], "}"}], ",", 
                TagBox[\(f[2]\),
                  HoldForm]}], "}"}], ",", 
            TagBox[\(f[f[2]]\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(f[f[f[2]]]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "There are two basic ways that subsidiary evaluations can be required \
during the evaluation of a ",
  StyleBox["Mathematica", "TI"],
  " expression. The first way is that the expression may contain \
subexpressions, each of which has to be evaluated. The second way is that \
there may be rules for the evaluation of the expression that involve other \
expressions which themselves must be evaluated. Both kinds of subsidiary \
evaluations are represented by sublists in the structure returned by ",
  StyleBox["Trace", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.28"}],

Cell[TextData[{
  "The subsidiary evaluations here come from evaluation of the arguments of \
",
  StyleBox["f", "MR"],
  " and ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.29"}],

Cell[CellGroupData[{

Cell["Trace[f[g[1 + 1], 2 + 3]]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox[\(1 + 1\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(g[2]\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(2 + 3\),
              HoldForm], ",", 
            TagBox["5",
              HoldForm]}], "}"}], ",", 
        TagBox[\(f[g[2], 5]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["Here is a function with a condition attached. ", "MathCaption",
  CellTags->{"S2.6.11", "11.30"}],

Cell["fe[n_] := n + 1 /; EvenQ[n]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "The evaluation of ",
  StyleBox["fe[6]", "MR"],
  " involves a subsidiary evaluation associated with the condition. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.31"}],

Cell[CellGroupData[{

Cell["Trace[fe[6]]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fe[6]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox[\(EvenQ[6]\),
                  HoldForm], ",", 
                TagBox["True",
                  HoldForm]}], "}"}], ",", 
            
            TagBox[\(RuleCondition[$ConditionHold[$ConditionHold[6 + 1]], 
                True]\),
              HoldForm], ",", 
            TagBox[\($ConditionHold[$ConditionHold[6 + 1]]\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(6 + 1\),
          HoldForm], ",", 
        TagBox["7",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["\<\
You often get nested lists when you trace the evaluation of \
functions that are defined \[OpenCurlyDoubleQuote]recursively\
\[CloseCurlyDoubleQuote] in terms of other instances of themselves. The \
reason is typically that each new instance of the function appears as a \
subexpression in the expressions obtained by evaluating previous instances of \
the function. \
\>", "Text",
  CellTags->{"S2.6.11", "11.32"}],

Cell[TextData[{
  "Thus, for example, with the definition ",
  StyleBox["fac[n_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["n", "MR"],
  " ",
  StyleBox["fac[n-1]", "MR"],
  ", the evaluation of ",
  StyleBox["fac[6]", "MR"],
  " yields the expression ",
  StyleBox["6", "MR"],
  " ",
  StyleBox["fac[5]", "MR"],
  ", which contains ",
  StyleBox["fac[5]", "MR"],
  " as a subexpression. "
}], "Text",
  CellTags->{"S2.6.11", "11.33"}],

Cell[TextData[{
  "The successive instances of ",
  StyleBox["fac", "MR"],
  " generated appear in successively nested sublists. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.34"}],

Cell[CellGroupData[{

Cell["Trace[fac[6], fac[_]]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[6]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[5]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[4]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(fac[3]\),
                      HoldForm], ",", 
                    RowBox[{"{", 
                      RowBox[{
                        TagBox[\(fac[2]\),
                          HoldForm], ",", 
                        RowBox[{"{", 
                          TagBox[\(fac[1]\),
                            HoldForm], "}"}]}], "}"}]}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "With this definition, ",
  StyleBox["fp[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["-1]", "MR"],
  " is obtained directly as the value of ",
  StyleBox["fp[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.35"}],

Cell["fp[n_] := fp[n - 1] /; n > 1", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.6.11"],

Cell[TextData[{
  StyleBox["fp[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " never appears in a subexpression, so no sublists are generated. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.36"}],

Cell[CellGroupData[{

Cell["Trace[fp[6], fp[_]]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fp[6]\),
          HoldForm], ",", 
        TagBox[\(fp[6 - 1]\),
          HoldForm], ",", 
        TagBox[\(fp[5]\),
          HoldForm], ",", 
        TagBox[\(fp[5 - 1]\),
          HoldForm], ",", 
        TagBox[\(fp[4]\),
          HoldForm], ",", 
        TagBox[\(fp[4 - 1]\),
          HoldForm], ",", 
        TagBox[\(fp[3]\),
          HoldForm], ",", 
        TagBox[\(fp[3 - 1]\),
          HoldForm], ",", 
        TagBox[\(fp[2]\),
          HoldForm], ",", 
        TagBox[\(fp[2 - 1]\),
          HoldForm], ",", 
        TagBox[\(fp[1]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["Here is the recursive definition of the Fibonacci numbers. ", \
"MathCaption",
  CellTags->{"S2.6.11", "11.37"}],

Cell["fib[n_] := fib[n - 1] + fib[n - 2]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.6.11"],

Cell["Here are the end conditions for the recursion. ", "MathCaption",
  CellTags->{"S2.6.11", "11.38"}],

Cell[CellGroupData[{

Cell["fib[0] = fib[1] = 1", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows all the steps in the recursive evaluation of ",
  StyleBox["fib[5]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.39"}],

Cell[CellGroupData[{

Cell["Trace[fib[5], fib[_]]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fib[5]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fib[4]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fib[3]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(fib[2]\),
                      HoldForm], ",", 
                    RowBox[{"{", 
                      TagBox[\(fib[1]\),
                        HoldForm], "}"}], ",", 
                    RowBox[{"{", 
                      TagBox[\(fib[0]\),
                        HoldForm], "}"}]}], "}"}], ",", 
                RowBox[{"{", 
                  TagBox[\(fib[1]\),
                    HoldForm], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fib[2]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  TagBox[\(fib[1]\),
                    HoldForm], "}"}], ",", 
                RowBox[{"{", 
                  TagBox[\(fib[0]\),
                    HoldForm], "}"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fib[3]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fib[2]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  TagBox[\(fib[1]\),
                    HoldForm], "}"}], ",", 
                RowBox[{"{", 
                  TagBox[\(fib[0]\),
                    HoldForm], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              TagBox[\(fib[1]\),
                HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "Each step in the evaluation of any ",
  StyleBox["Mathematica", "TI"],
  " expression can be thought of as the result of applying a particular \
transformation rule. As discussed in Section ",
  ButtonBox["2.5.10",
    ButtonData:>{"2.5.10", "10.1"},
    ButtonStyle->"MainBookLink"],
  ", all the rules that ",
  StyleBox["Mathematica", "TI"],
  " knows are associated with specific symbols or \[OpenCurlyDoubleQuote]tags\
\[CloseCurlyDoubleQuote]. You can use ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["f", "TI"],
  StyleBox["]", "MR"],
  " to see all the steps in the evaluation of ",
  StyleBox["expr", "TI"],
  " that are performed using transformation rules associated with the symbol \
",
  StyleBox["f", "TI"],
  ". In this case, ",
  StyleBox["Trace", "MR"],
  " gives not only the expressions to which each rule is applied, but also \
the results of applying the rules. "
}], "Text",
  CellTags->{"S2.6.11", "11.40"}],

Cell[TextData[{
  "In general, ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " picks out all the steps in the evaluation of ",
  StyleBox["expr", "TI"],
  " where ",
  StyleBox["form", "TI"],
  " matches ",
  StyleBox["either", "TI"],
  " the expression about to be evaluated, ",
  StyleBox["or", "TI"],
  " the tag associated with the rule used. "
}], "Text",
  CellTags->{"S2.6.11", "11.41"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "show all evaluations which use transformation rules associated \
with the symbol ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["f", "TI"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "show all evaluations associated with either ",
              StyleBox["f", "TI"],
              " or ",
              StyleBox["g", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["Tracing evaluations associated with particular tags. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "This shows only intermediate expressions that match ",
  StyleBox["fac[_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.42"}],

Cell[CellGroupData[{

Cell["Trace[fac[3], fac[_]]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[3]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[2]\),
              HoldForm], ",", 
            RowBox[{"{", 
              TagBox[\(fac[1]\),
                HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows all evaluations that use transformation rules associated with \
the symbol ",
  StyleBox["fac", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.43"}],

Cell[CellGroupData[{

Cell["Trace[fac[3], fac]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[3]\),
          HoldForm], ",", 
        TagBox[\(3\ fac[3 - 1]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[2]\),
              HoldForm], ",", 
            TagBox[\(2\ fac[2 - 1]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[1]\),
                  HoldForm], ",", 
                TagBox["1",
                  HoldForm]}], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "Here is a rule for the ",
  StyleBox["log", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.44"}],

Cell["log[x_ y_] := log[x] + log[y]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "This traces the evaluation of ",
  StyleBox["log[a", "MR"],
  " ",
  StyleBox["b", "MR"],
  " ",
  StyleBox["c", "MR"],
  " ",
  StyleBox["d]", "MR"],
  ", showing all transformations associated with ",
  StyleBox["log", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.45"}],

Cell[CellGroupData[{

Cell["Trace[log[a b c d], log]", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(log[a\ b\ c\ d]\),
          HoldForm], ",", 
        TagBox[\(log[a] + log[b\ c\ d]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(log[b\ c\ d]\),
              HoldForm], ",", 
            TagBox[\(log[b] + log[c\ d]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(log[c\ d]\),
                  HoldForm], ",", 
                TagBox[\(log[c] + log[d]\),
                  HoldForm]}], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["TraceOn", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["oform", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "switch on tracing only within forms matching ",
              StyleBox["oform", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["TraceOff", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["oform", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "switch off tracing within any form matching ",
              StyleBox["oform", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["Switching off tracing inside certain forms. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " allows you to trace expressions matching ",
  StyleBox["form", "TI"],
  " generated at any point in the evaluation of ",
  StyleBox["expr", "TI"],
  ". Sometimes, you may want to trace only expressions generated during \
certain parts of the evaluation of ",
  StyleBox["expr", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.46"}],

Cell[TextData[{
  "By setting the option ",
  StyleBox["TraceOn", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["oform", "TI"],
  ", you can specify that tracing should be done only during the evaluation \
of forms which match ",
  StyleBox["oform", "TI"],
  ". Similarly, by setting ",
  StyleBox["TraceOff", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["oform", "TI"],
  ", you can specify that tracing should be switched off during the \
evaluation of forms which match ",
  StyleBox["oform", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.47"}],

Cell["This shows all steps in the evaluation. ", "MathCaption",
  CellTags->{"S2.6.11", "11.48"}],

Cell[CellGroupData[{

Cell["Trace[log[fac[2] x]]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[2]\),
                  HoldForm], ",", 
                TagBox[\(2\ fac[2 - 1]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"{", 
                      RowBox[{
                        TagBox[\(2 - 1\),
                          HoldForm], ",", 
                        TagBox["1",
                          HoldForm]}], "}"}], ",", 
                    TagBox[\(fac[1]\),
                      HoldForm], ",", 
                    TagBox["1",
                      HoldForm]}], "}"}], ",", 
                TagBox[\(2\ 1\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(2\ x\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(log[2\ x]\),
          HoldForm], ",", 
        TagBox[\(log[2] + log[x]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows only those steps that occur during the evaluation of ",
  StyleBox["fac", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.49"}],

Cell[CellGroupData[{

Cell["Trace[log[fac[2] x], TraceOn -> fac]", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[2]\),
              HoldForm], ",", 
            TagBox[\(2\ fac[2 - 1]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(2 - 1\),
                      HoldForm], ",", 
                    TagBox["1",
                      HoldForm]}], "}"}], ",", 
                TagBox[\(fac[1]\),
                  HoldForm], ",", 
                TagBox["1",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(2\ 1\),
              HoldForm], ",", 
            TagBox["2",
              HoldForm]}], "}"}], "}"}], "}"}]], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows only those steps that do not occur during the evaluation of ",
  StyleBox["fac", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.50"}],

Cell[CellGroupData[{

Cell["Trace[log[fac[2] x], TraceOff -> fac]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[2]\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(2\ x\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(log[2\ x]\),
          HoldForm], ",", 
        TagBox[\(log[2] + log[x]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "find all expressions matching ",
              StyleBox["lhs", "TI"],
              " that arise during the evaluation of ",
              StyleBox["expr", "TI"],
              ", and replace them with ",
              StyleBox["rhs", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["\<\
Applying rules to expressions encountered during evaluation. \
\>", \
"Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "This tells ",
  StyleBox["Trace", "MR"],
  " to return only the arguments of ",
  StyleBox["fib", "MR"],
  " used in the evaluation of ",
  StyleBox["fib[5]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.51"}],

Cell[CellGroupData[{

Cell["Trace[fib[5], fib[n_] -> n]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox["5",
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox["4",
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox["3",
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox["2",
                      HoldForm], ",", 
                    RowBox[{"{", 
                      TagBox["1",
                        HoldForm], "}"}], ",", 
                    RowBox[{"{", 
                      TagBox["0",
                        HoldForm], "}"}]}], "}"}], ",", 
                RowBox[{"{", 
                  TagBox["1",
                    HoldForm], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox["2",
                  HoldForm], ",", 
                RowBox[{"{", 
                  TagBox["1",
                    HoldForm], "}"}], ",", 
                RowBox[{"{", 
                  TagBox["0",
                    HoldForm], "}"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox["3",
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox["2",
                  HoldForm], ",", 
                RowBox[{"{", 
                  TagBox["1",
                    HoldForm], "}"}], ",", 
                RowBox[{"{", 
                  TagBox["0",
                    HoldForm], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
              TagBox["1",
                HoldForm], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "A powerful aspect of the ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Trace", "MR"],
  " function is that the object it returns is basically a standard ",
  StyleBox["Mathematica", "TI"],
  " expression which you can manipulate using other ",
  StyleBox["Mathematica", "TI"],
  " functions. One important point to realize, however, is that ",
  StyleBox["Trace", "MR"],
  " wraps all expressions that appear in the list it produces with ",
  StyleBox["HoldForm", "MR"],
  " to prevent them from being evaluated. The ",
  StyleBox["HoldForm", "MR"],
  " is not displayed in standard ",
  StyleBox["Mathematica", "TI"],
  " output format, but it is still present in the internal structure of the \
expression. "
}], "Text",
  CellTags->{"S2.6.11", "11.52"}],

Cell["\<\
This shows the expressions generated at intermediate stages in the \
evaluation process. \
\>", "MathCaption",
  CellTags->{"S2.6.11", "11.53"}],

Cell[CellGroupData[{

Cell["Trace[1 + 3^2]", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(3\^2\),
              HoldForm], ",", 
            TagBox["9",
              HoldForm]}], "}"}], ",", 
        TagBox[\(1 + 9\),
          HoldForm], ",", 
        TagBox["10",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The expressions are wrapped with ",
  StyleBox["HoldForm", "MR"],
  " to prevent them from evaluating. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.54"}],

Cell[CellGroupData[{

Cell["Trace[1 + 3^2] // InputForm", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S2.6.11"],

Cell["\<\
{{HoldForm[3^2], HoldForm[9]}, HoldForm[1 + 9],   \
HoldForm[10]}\
\>", "Output",
  CellLabel->"Out[35]//InputForm= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "In standard ",
  StyleBox["Mathematica", "TI"],
  " output format, it is sometimes difficult to tell which lists are \
associated with the structure returned by ",
  StyleBox["Trace", "MR"],
  ", and which are expressions being evaluated. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.55"}],

Cell[CellGroupData[{

Cell["Trace[{1 + 1, 2 + 3}]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(1 + 1\),
              HoldForm], ",", 
            TagBox["2",
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(2 + 3\),
              HoldForm], ",", 
            TagBox["5",
              HoldForm]}], "}"}], ",", 
        TagBox[\({2, 5}\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["Looking at the input form resolves any ambiguities. ", "MathCaption",
  CellTags->{"S2.6.11", "11.56"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S2.6.11"],

Cell["\<\
{{HoldForm[1 + 1], HoldForm[2]},   {HoldForm[2 + 3], HoldForm[5]}, \
HoldForm[{2, 5}]}\
\>", "Output",
  CellLabel->"Out[37]//InputForm= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "When you use a transformation rule in ",
  StyleBox["Trace", "MR"],
  ", the result is evaluated before being wrapped with ",
  StyleBox["HoldForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.57"}],

Cell[CellGroupData[{

Cell["Trace[fac[4], fac[n_] -> n + 1]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox["5",
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox["4",
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox["3",
                  HoldForm], ",", 
                RowBox[{"{", 
                  TagBox["2",
                    HoldForm], "}"}]}], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "For sophisticated computations, the list structures returned by ",
  StyleBox["Trace", "MR"],
  " can be quite complicated. When you use ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  ", ",
  StyleBox["Trace", "MR"],
  " will include as elements in the lists only those expressions "
}], "Text",
  CellTags->{"S2.6.11", "11.58"}],

Cell[TextData[{
  "which match the pattern ",
  StyleBox["form", "TI"],
  ". But whatever pattern you give, the nesting structure of the lists \
remains the same. "
}], "Text",
  CellTags->{"S2.6.11", "11.59"}],

Cell[TextData[{
  "This shows all occurrences of ",
  StyleBox["fib[_]", "MR"],
  " in the evaluation of ",
  StyleBox["fib[3]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.60"}],

Cell[CellGroupData[{

Cell["Trace[fib[3], fib[_]]", "Input",
  CellLabel->"In[39]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fib[3]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fib[2]\),
              HoldForm], ",", 
            RowBox[{"{", 
              TagBox[\(fib[1]\),
                HoldForm], "}"}], ",", 
            RowBox[{"{", 
              TagBox[\(fib[0]\),
                HoldForm], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
          TagBox[\(fib[1]\),
            HoldForm], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[39]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows only occurrences of ",
  StyleBox["fib[1]", "MR"],
  ", but the nesting of the lists is the same as for ",
  StyleBox["fib[_]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.61"}],

Cell[CellGroupData[{

Cell["Trace[fib[3], fib[1]]", "Input",
  CellLabel->"In[40]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"{", 
            TagBox[\(fib[1]\),
              HoldForm], "}"}], "}"}], ",", 
        RowBox[{"{", 
          TagBox[\(fib[1]\),
            HoldForm], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[40]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "You can set the option ",
  StyleBox["TraceDepth", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["n", "TI"],
  " to tell ",
  StyleBox["Trace", "MR"],
  " to include only lists nested at most ",
  StyleBox["n", "TI"],
  " levels deep. In this way, you can often pick out the \
\[OpenCurlyDoubleQuote]big steps\[CloseCurlyDoubleQuote] in a computation, \
without seeing the details. Note that by setting ",
  StyleBox["TraceDepth", "MR"],
  " or ",
  StyleBox["TraceOff", "MR"],
  " you can avoid looking at many of the steps in a computation, and thereby \
significantly speed up the operation of ",
  StyleBox["Trace", "MR"],
  " for that computation. "
}], "Text",
  CellTags->{"S2.6.11", "11.62"}],

Cell["\<\
This shows only steps that appear in lists nested at most two \
levels deep. \
\>", "MathCaption",
  CellTags->{"S2.6.11", "11.63"}],

Cell[CellGroupData[{

Cell["Trace[fib[3], fib[_], TraceDepth->2]", "Input",
  CellLabel->"In[41]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fib[3]\),
          HoldForm], ",", 
        RowBox[{"{", 
          TagBox[\(fib[1]\),
            HoldForm], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[41]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["TraceDepth", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "trace the evaluation of ",
              StyleBox["expr", "TI"],
              ", ignoring steps that lead to lists nested more than ",
              StyleBox["n", "TI"],
              " levels deep "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["Restricting the depth of tracing. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "When you use ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  ", you get a list of all the expressions which match ",
  StyleBox["form", "TI"],
  " produced during the evaluation of ",
  StyleBox["expr", "TI"],
  ". Sometimes it is useful to see not only these expressions, but also the \
results that were obtained by evaluating them. You can do this by setting the \
option ",
  StyleBox["TraceForward", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " in ",
  StyleBox["Trace", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.64"}],

Cell[TextData[{
  "This shows not only expressions which match ",
  StyleBox["fac[_]", "MR"],
  ", but also the results of evaluating those expressions. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.65"}],

Cell[CellGroupData[{

Cell["Trace[fac[4], fac[_], TraceForward->True]", "Input",
  CellLabel->"In[42]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[4]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[3]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[2]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(fac[1]\),
                      HoldForm], ",", 
                    TagBox["1",
                      HoldForm]}], "}"}], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox["6",
              HoldForm]}], "}"}], ",", 
        TagBox["24",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[42]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "Expressions picked out using ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " typically lie in the middle of an evaluation chain. By setting ",
  StyleBox["TraceForward", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", you tell ",
  StyleBox["Trace", "MR"],
  " to include also the expression obtained at the end of the evaluation \
chain. If you set ",
  StyleBox["TraceForward", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", ",
  StyleBox["Trace", "MR"],
  " will include ",
  StyleBox["all", "TI"],
  " the expressions that occur after the expression matching ",
  StyleBox["form", "TI"],
  " on the evaluation chain. "
}], "Text",
  CellTags->{"S2.6.11", "11.66"}],

Cell[TextData[{
  "With ",
  StyleBox["TraceForward->All", "MR"],
  ", all elements on the evaluation chain after the one that matches ",
  StyleBox["fac[_]", "MR"],
  " are included. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.67"}],

Cell[CellGroupData[{

Cell["Trace[fac[4], fac[_], TraceForward->All]", "Input",
  CellLabel->"In[43]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[4]\),
          HoldForm], ",", 
        TagBox[\(4\ fac[4 - 1]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[3]\),
              HoldForm], ",", 
            TagBox[\(3\ fac[3 - 1]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[2]\),
                  HoldForm], ",", 
                TagBox[\(2\ fac[2 - 1]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(fac[1]\),
                      HoldForm], ",", 
                    TagBox["1",
                      HoldForm]}], "}"}], ",", 
                TagBox[\(2\ 1\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox[\(3\ 2\),
              HoldForm], ",", 
            TagBox["6",
              HoldForm]}], "}"}], ",", 
        TagBox[\(4\ 6\),
          HoldForm], ",", 
        TagBox["24",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[43]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "By setting the option ",
  StyleBox["TraceForward", "MR"],
  ", you can effectively see what happens to a particular form of expression \
during an evaluation. Sometimes, however, you want to find out not what \
happens to a particular expression, but instead how that expression was \
generated. You can do this by setting the "
}], "Text",
  CellTags->{"S2.6.11", "11.68"}],

Cell[TextData[{
  "option ",
  StyleBox["TraceBackward", "MR"],
  ". What ",
  StyleBox["TraceBackward", "MR"],
  " does is to show you what ",
  StyleBox["preceded", "TI"],
  " a particular form of expression on an evaluation chain. "
}], "Text",
  CellTags->{"S2.6.11", "11.69"}],

Cell[TextData[{
  "This shows that the number ",
  StyleBox["120", "MR"],
  " came from the evaluation of ",
  StyleBox["fac[5]", "MR"],
  " during the evaluation of ",
  StyleBox["fac[10]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.70"}],

Cell[CellGroupData[{

Cell["Trace[fac[10], 120, TraceBackward->True]", "Input",
  CellLabel->"In[44]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"{", 
              RowBox[{"{", 
                RowBox[{
                  TagBox[\(fac[5]\),
                    HoldForm], ",", 
                  TagBox["120",
                    HoldForm]}], "}"}], "}"}], "}"}], "}"}], "}"}], 
      "}"}]], "Output",
  CellLabel->"Out[44]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "Here is the whole evaluation chain associated with the generation of the \
number ",
  StyleBox["120", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.71"}],

Cell[CellGroupData[{

Cell["Trace[fac[10], 120, TraceBackward->All]", "Input",
  CellLabel->"In[45]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"{", 
          RowBox[{"{", 
            RowBox[{"{", 
              RowBox[{"{", 
                RowBox[{
                  TagBox[\(fac[5]\),
                    HoldForm], ",", 
                  TagBox[\(5\ fac[5 - 1]\),
                    HoldForm], ",", 
                  TagBox[\(5\ 24\),
                    HoldForm], ",", 
                  TagBox["120",
                    HoldForm]}], "}"}], "}"}], "}"}], "}"}], "}"}], 
      "}"}]], "Output",
  CellLabel->"Out[45]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TraceForward", "MR"],
  " and ",
  StyleBox["TraceBackward", "MR"],
  " allow you to look forward and backward in a particular evaluation chain. \
Sometimes, you may also want to look at the evaluation chains within which \
the particular evaluation chain occurs. You can do this using ",
  StyleBox["TraceAbove", "MR"],
  ". If you set the option ",
  StyleBox["TraceAbove", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", then ",
  StyleBox["Trace", "MR"],
  " will include the initial and final expressions in all the relevant \
evaluation chains. With ",
  StyleBox["TraceAbove", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", ",
  StyleBox["Trace", "MR"],
  " includes all the expressions in all these evaluation chains."
}], "Text",
  CellTags->{"S2.6.11", "11.72"}],

Cell[TextData[{
  "This includes the initial and final expressions in all evaluation chains \
which contain the chain that contains ",
  StyleBox["120", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.73"}],

Cell[CellGroupData[{

Cell["Trace[fac[7], 120, TraceAbove->True]", "Input",
  CellLabel->"In[46]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[7]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[6]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[5]\),
                  HoldForm], ",", 
                TagBox["120",
                  HoldForm]}], "}"}], ",", 
            TagBox["720",
              HoldForm]}], "}"}], ",", 
        TagBox["5040",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[46]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This shows all the ways that ",
  StyleBox["fib[2]", "MR"],
  " is generated during the evaluation of ",
  StyleBox["fib[5]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.74"}],

Cell[CellGroupData[{

Cell["Trace[fib[5], fib[2], TraceAbove->True]", "Input",
  CellLabel->"In[47]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fib[5]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fib[4]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fib[3]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(fib[2]\),
                      HoldForm], ",", 
                    TagBox["2",
                      HoldForm]}], "}"}], ",", 
                TagBox["3",
                  HoldForm]}], "}"}], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fib[2]\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox["5",
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fib[3]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fib[2]\),
                  HoldForm], ",", 
                TagBox["2",
                  HoldForm]}], "}"}], ",", 
            TagBox["3",
              HoldForm]}], "}"}], ",", 
        TagBox["8",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[47]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["opts", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "trace the evaluation of ",
              StyleBox["expr", "TI"],
              " using the specified options "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceForward", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell[TextData[{
              
              "include the final expression in the evaluation chain \
containing ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceForward", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["All", "MR"],
              " "
            }]], Cell[TextData[{
              "include all expressions following ",
              StyleBox["form", "TI"],
              " in the evaluation chain "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceBackward", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell[TextData[{
              
              "include the first expression in the evaluation chain \
containing ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceBackward", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["All", "MR"],
              " "
            }]], Cell[TextData[{
              "include all expressions preceding ",
              StyleBox["form", "TI"],
              " in the evaluation chain "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceAbove", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell[TextData[{
              
              "include the first and last expressions in all evaluation \
chains which contain the chain containing ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceAbove", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["All", "MR"],
              " "
            }]], Cell[TextData[{
              
              "include all expressions in all evaluation chains which contain \
the chain containing ",
              StyleBox["form", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.6.11"],

Cell["Option settings for including extra steps in trace lists. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "The basic way that ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " works is to intercept each expression encountered during the evaluation \
of ",
  StyleBox["expr", "TI"],
  ", and then to use various criteria to determine whether this expression \
should be recorded. Normally, however, ",
  StyleBox["Trace", "MR"],
  " intercepts expressions only ",
  StyleBox["after", "TI"],
  " function arguments have been evaluated. By setting ",
  StyleBox["TraceOriginal", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", you can get ",
  StyleBox["Trace", "MR"],
  " also to look at expressions ",
  StyleBox["before", "TI"],
  " function arguments have been evaluated. "
}], "Text",
  CellTags->{"S2.6.11", "11.75"}],

Cell[TextData[{
  "This includes expressions which match ",
  StyleBox["fac[_]", "MR"],
  " both before and after argument evaluation. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.76"}],

Cell[CellGroupData[{

Cell["Trace[fac[3], fac[_], TraceOriginal -> True]", "Input",
  CellLabel->"In[48]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[3]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(fac[3 - 1]\),
              HoldForm], ",", 
            TagBox[\(fac[2]\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                TagBox[\(fac[2 - 1]\),
                  HoldForm], ",", 
                TagBox[\(fac[1]\),
                  HoldForm]}], "}"}]}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[48]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The list structure produced by ",
  StyleBox["Trace", "MR"],
  " normally includes only expressions that constitute steps in \
non\[Hyphen]trivial evaluation chains. Thus, for example, individual symbols \
that evaluate to themselves are not normally included. Nevertheless, if you \
set ",
  StyleBox["TraceOriginal", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", then ",
  StyleBox["Trace", "MR"],
  " looks at absolutely every expression involved in the evaluation process, \
including those that have trivial evaluation chains. "
}], "Text",
  CellTags->{"S2.6.11", "11.77"}],

Cell[TextData[{
  "In this case, ",
  StyleBox["Trace", "MR"],
  " includes absolutely all expressions, even those with trivial evaluation \
chains. "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.78"}],

Cell[CellGroupData[{

Cell["Trace[fac[1], TraceOriginal -> True]", "Input",
  CellLabel->"In[49]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fac[1]\),
          HoldForm], ",", 
        RowBox[{"{", 
          TagBox["fac",
            HoldForm], "}"}], ",", 
        RowBox[{"{", 
          TagBox["1",
            HoldForm], "}"}], ",", 
        TagBox[\(fac[1]\),
          HoldForm], ",", 
        TagBox["1",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[49]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["TraceForward", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell[TextData[{
              "whether to show expressions following ",
              StyleBox["form", "TI"],
              " in the evaluation chain "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceBackward", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell[TextData[{
              "whether to show expressions preceding ",
              StyleBox["form", "TI"],
              " in the evaluation chain "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceAbove", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell[TextData[{
              
              "whether to show evaluation chains leading to the evaluation \
chain containing ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceOriginal", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], 
            Cell["\<\
whether to look at expressions before their heads and \
arguments are evaluated \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.6.11"],

Cell[TextData[{
  "Additional options for ",
  StyleBox["Trace", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "When you use ",
  StyleBox["Trace", "MR"],
  " to study the execution of a program, there is an issue about how local \
variables in the program should be treated. As discussed in Section ",
  ButtonBox["2.7.3",
    ButtonData:>{"2.7.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " scoping constructs such as ",
  StyleBox["Module", "MR"],
  " create symbols with new names to represent local variables. Thus, even if \
you called a variable ",
  StyleBox["x", "MR"],
  " in the original code for your program, the variable may effectively be \
renamed ",
  StyleBox["x$", "MR"],
  StyleBox["nnn", "TI"],
  " when the program is executed. "
}], "Text",
  CellTags->{"S2.6.11", "11.79"}],

Cell[TextData[{
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  " is set up so that by default a symbol ",
  StyleBox["x", "TI"],
  " that appears in ",
  StyleBox["form", "TI"],
  " will match all symbols with names of the form ",
  StyleBox["x", "TI"],
  StyleBox["$", "MR"],
  StyleBox["nnn", "TI"],
  " that arise in the execution of ",
  StyleBox["expr", "TI"],
  ". As a result, you can for example use ",
  StyleBox["Trace[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["_]", "MR"],
  " to trace assignment to all variables, local and global, that were named \
",
  StyleBox["x", "TI"],
  " in your original program. "
}], "Text",
  CellTags->{"S2.6.11", "11.80"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["MatchLocalNames", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False]", "MR"],
              " "
            }]], Cell[TextData[{
              "include all steps in the execution of ",
              StyleBox["expr", "TI"],
              " that match ",
              StyleBox["form", "TI"],
              ", with no replacements for local variable names allowed "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["Preventing the matching of local variables. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "In some cases, you may want to trace only the global variable ",
  StyleBox["x", "TI"],
  ", and not any local variables that were originally named ",
  StyleBox["x", "TI"],
  ". You can do this by setting the option ",
  StyleBox["MatchLocalNames", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.81"}],

Cell[TextData[{
  "This traces assignments to all variables with names of the form ",
  StyleBox["x$", "MR"],
  StyleBox["nnn", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.82"}],

Cell[CellGroupData[{

Cell["Trace[Module[{x}, x = 5], x = _]", "Input",
  CellLabel->"In[50]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        TagBox[\(x$1 = 5\),
          HoldForm], "}"}], "}"}]], "Output",
  CellLabel->"Out[50]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This traces assignments only to the specific global variable ",
  StyleBox["x", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.83"}],

Cell[CellGroupData[{

Cell["Trace[Module[{x}, x = 5], x = _, MatchLocalNames -> False]", "Input",
  CellLabel->"In[51]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[51]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Trace", "MR"],
  " performs a complete computation, then returns a structure which \
represents the history of the computation. Particularly in very long \
computations, it is however sometimes useful to see traces of the computation \
as it proceeds. The function ",
  StyleBox["TracePrint", "MR"],
  " works essentially like ",
  StyleBox["Trace", "MR"],
  ", except that it prints expressions when it encounters them, rather than \
saving up all of the expressions to create a list structure. "
}], "Text",
  CellTags->{"S2.6.11", "11.84"}],

Cell[TextData[{
  "This prints expressions encountered in the evaluation of ",
  StyleBox["fib[3]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.85"}],

Cell[CellGroupData[{

Cell["TracePrint[fib[3], fib[_]]", "Input",
  CellLabel->"In[52]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{" ", "\[InvisibleSpace]", 
        TagBox[\(fib[3]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 1], 
        HoldForm[ 
          fib[ 3]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"  ", "\[InvisibleSpace]", 
        TagBox[\(fib[3 - 1]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 2], 
        HoldForm[ 
          fib[ 
            Plus[ 3, -1]]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"  ", "\[InvisibleSpace]", 
        TagBox[\(fib[2]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 2], 
        HoldForm[ 
          fib[ 2]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"   ", "\[InvisibleSpace]", 
        TagBox[\(fib[2 - 1]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 3], 
        HoldForm[ 
          fib[ 
            Plus[ 2, -1]]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"   ", "\[InvisibleSpace]", 
        TagBox[\(fib[1]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 3], 
        HoldForm[ 
          fib[ 1]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"   ", "\[InvisibleSpace]", 
        TagBox[\(fib[2 - 2]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 3], 
        HoldForm[ 
          fib[ 
            Plus[ 2, -2]]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"   ", "\[InvisibleSpace]", 
        TagBox[\(fib[0]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 3], 
        HoldForm[ 
          fib[ 0]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"  ", "\[InvisibleSpace]", 
        TagBox[\(fib[3 - 2]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 2], 
        HoldForm[ 
          fib[ 
            Plus[ 3, -2]]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"  ", "\[InvisibleSpace]", 
        TagBox[\(fib[1]\),
          HoldForm]}],
      SequenceForm[ 
        Indent[ 2], 
        HoldForm[ 
          fib[ 1]]],
      Editable->False]], "Print",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[52]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The sequence of expressions printed by ",
  StyleBox["TracePrint", "MR"],
  " corresponds to the sequence of expressions given in the list structure \
returned by ",
  StyleBox["Trace", "MR"],
  ". Indentation in the output from ",
  StyleBox["TracePrint", "MR"],
  " corresponds to nesting in the list structure from ",
  StyleBox["Trace", "MR"],
  ". You can use the ",
  StyleBox["Trace", "MR"],
  " options ",
  StyleBox["TraceOn", "MR"],
  ", ",
  StyleBox["TraceOff", "MR"],
  " and ",
  StyleBox["TraceForward", "MR"],
  " in ",
  StyleBox["TracePrint", "MR"],
  ". However, since ",
  StyleBox["TracePrint", "MR"],
  " produces output as it goes, it cannot support the option ",
  StyleBox["TraceBackward", "MR"],
  ". In addition, ",
  StyleBox["TracePrint", "MR"],
  " is set up so that ",
  StyleBox["TraceOriginal", "MR"],
  " is effectively always set to ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.11", "11.86"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Trace[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "trace the evaluation of ",
              StyleBox["expr", "TI"],
              
              ", returning a list structure containing the expressions \
encountered "
            }]]},
          {Cell[TextData[{
              StyleBox["TracePrint[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "trace the evaluation of ",
              StyleBox["expr", "TI"],
              ", printing the expressions encountered "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceDialog[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "trace the evaluation of ",
              StyleBox["expr", "TI"],
              
              ", initiating a dialog when each specified expression is \
encountered "
            }]]},
          {Cell[TextData[{
              StyleBox["TraceScan[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "trace the evaluation of ",
              StyleBox["expr", "TI"],
              ", applying ",
              StyleBox["f", "TI"],
              " to ",
              StyleBox["HoldForm", "MR"],
              " of each expression encountered "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.11"],

Cell["Functions for tracing evaluation. ", "Caption",
  CellTags->"S2.6.11"],

Cell[TextData[{
  "This enters a dialog when ",
  StyleBox["fac[5]", "MR"],
  " is encountered during the evaluation of ",
  StyleBox["fac[10]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.87"}],

Cell[CellGroupData[{

Cell["TraceDialog[fac[10], fac[5]]", "Input",
  CellLabel->"In[53]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(TraceDialog::"dgbgn" \(\(:\)\(\ \)\) 
      "Entering Dialog; use Return[] to exit."\)], "Message",
  CellTags->"S2.6.11"],

Cell[BoxData[
    TagBox[\(fac[5]\),
      HoldForm]], "Output",
  CellLabel->"Out[54]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell["\<\
Inside the dialog you can for example find out where you are by \
looking at the \[OpenCurlyDoubleQuote]stack\[CloseCurlyDoubleQuote]. \
\>", \
"MathCaption",
  CellTags->{"S2.6.11", "11.88"}],

Cell[CellGroupData[{

Cell["Stack[ ]", "Input",
  CellLabel->"In[54]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \({TraceDialog, Times, Times, Times}\)], "Output",
  CellLabel->"Out[55]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "This returns from the dialog, and gives the final result from the \
evaluation of ",
  StyleBox["fac[10]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.11", "11.89"}],

Cell[CellGroupData[{

Cell["Return[ ]", "Input",
  CellLabel->"In[55]:= ",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(TraceDialog::"dgend" \(\(:\)\(\ \)\) "Exiting Dialog."\)], "Message",
  CellTags->"S2.6.11"],

Cell[BoxData[
    \(3628800\)], "Output",
  CellLabel->"Out[53]= ",
  CellTags->"S2.6.11"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["TraceDialog", "MR"],
  " effectively allows you to stop in the middle of a computation, and \
interact with the ",
  StyleBox["Mathematica", "TI"],
  " environment that exists at that time. You can for example find values of \
intermediate variables in the computation, and even reset those values. There \
are however a number of subtleties, mostly associated with pattern and module \
variables. "
}], "Text",
  CellTags->{"S2.6.11", "11.90"}],

Cell[TextData[{
  "What ",
  StyleBox["TraceDialog", "MR"],
  " does is to call the function ",
  StyleBox["Dialog", "MR"],
  " on a sequence of expressions. The ",
  StyleBox["Dialog", "MR"],
  " function is discussed in detail in Section ",
  ButtonBox["2.14.2",
    ButtonData:>{"2.14.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ". When you call ",
  StyleBox["Dialog", "MR"],
  ", you are effectively starting a subsidiary ",
  StyleBox["Mathematica", "TI"],
  " session with its own sequence of input and output lines. "
}], "Text",
  CellTags->{"S2.6.11", "11.91"}],

Cell[TextData[{
  "In general, you may need to apply arbitrary functions to the expressions \
you get while tracing an evaluation. ",
  StyleBox["TraceScan[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " to each expression that arises. The expression is wrapped with ",
  StyleBox["HoldForm", "MR"],
  " to prevent it from evaluating. "
}], "Text",
  CellTags->{"S2.6.11", "11.92"}],

Cell[TextData[{
  "In ",
  StyleBox["TraceScan[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  ", the function ",
  StyleBox["f", "TI"],
  " is applied to expressions before they are evaluated. ",
  StyleBox["TraceScan[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["patt", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["fp", "TI"],
  StyleBox["]", "MR"],
  " applies ",
  StyleBox["f", "TI"],
  " before evaluation, and ",
  StyleBox["fp", "TI"],
  " after evaluation. "
}], "Text",
  CellTags->{"S2.6.11", "11.93"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.12 Advanced Topic: The Evaluation Stack", "Subsection",
  CellTags->{"S2.6.12", "12.1"}],

Cell[TextData[{
  "Throughout any computation, ",
  StyleBox["Mathematica", "TI"],
  " maintains an ",
  StyleBox["evaluation stack", "TI"],
  " containing the expressions it is currently evaluating. You can use the \
function ",
  StyleBox["Stack", "MR"],
  " to look at the stack. This means, for example, that if you interrupt ",
  StyleBox["Mathematica", "TI"],
  " in the middle of a computation, you can use ",
  StyleBox["Stack", "MR"],
  " to find out what ",
  StyleBox["Mathematica", "TI"],
  " is doing. "
}], "Text",
  CellTags->{"S2.6.12", "12.2"}],

Cell[TextData[{
  "The expression that ",
  StyleBox["Mathematica", "TI"],
  " most recently started to evaluate always appears as the last element of \
the evaluation stack. The previous elements of the stack are the other \
expressions whose evaluation is currently in progress. "
}], "Text",
  CellTags->{"S2.6.12", "12.3"}],

Cell[TextData[{
  "Thus at the point when ",
  StyleBox["x", "TI"],
  " is being evaluated, the stack associated with the evaluation of an \
expression like ",
  StyleBox["f", "TI"],
  "\[ThinSpace]",
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]]", "MR"],
  " will have the form ",
  StyleBox["{", "MR"],
  StyleBox["f", "TI"],
  "\[ThinSpace]",
  StyleBox["[", "MR"],
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]],", "MR"],
  " ",
  StyleBox["g", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["],", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox["}", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.12", "12.4"}],

Cell[TextData[{
  StyleBox["Stack[_]", "MR"],
  " gives the expressions that are being evaluated at the time when it is \
called, in this case including the ",
  StyleBox["Print", "MR"],
  " function. "
}], "MathCaption",
  CellTags->{"S2.6.12", "12.5"}],

Cell[CellGroupData[{

Cell["f[g[ Print[Stack[_]] ]] ;", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(f[g[Print[Stack[_]]]]; \),
          HoldForm], ",", 
        TagBox[\(f[g[Print[Stack[_]]]]\),
          HoldForm], ",", 
        TagBox[\(g[Print[Stack[_]]]\),
          HoldForm], ",", 
        TagBox[\(Print[Stack[_]]\),
          HoldForm]}], "}"}]], "Print",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Stack[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " gives the tags associated with the evaluations that are being done when \
it is called. "
}], "MathCaption",
  CellTags->{"S2.6.12", "12.6"}],

Cell[CellGroupData[{

Cell["f[g[ Print[Stack[ ]] ]] ;", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \({CompoundExpression, f, g, Print}\)], "Print",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell[TextData[{
  "In general, you can think of the evaluation stack as showing what \
functions called what other functions to get to the point ",
  StyleBox["Mathematica", "TI"],
  " is at in your computation. The sequence of expressions corresponds to the \
first elements in the successively nested lists returned by ",
  StyleBox["Trace", "MR"],
  " with the option ",
  StyleBox["TraceAbove", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.12", "12.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Stack[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
give a list of the tags associated with evaluations \
that are currently being done \
\>"]},
          {Cell[TextData[{
              StyleBox["Stack[_]", "MR"],
              " "
            }]], Cell[
            "give a list of all expressions currently being evaluated "]},
          {Cell[TextData[{
              StyleBox["Stack[", "MR"],
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "include only expressions which match ",
              StyleBox["form", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.12"],

Cell["Looking at the evaluation stack. ", "Caption",
  CellTags->"S2.6.12"],

Cell[TextData[{
  "It is rather rare to call ",
  StyleBox["Stack", "MR"],
  " directly in your main ",
  StyleBox["Mathematica", "TI"],
  " session. More often, you will want to call ",
  StyleBox["Stack", "MR"],
  " in the middle of a computation. Typically, you can do this from within a \
dialog, or subsidiary session, as discussed in Section ",
  ButtonBox["2.14.2",
    ButtonData:>{"2.14.2", "2.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.6.12", "12.8"}],

Cell["\<\
Here is the standard recursive definition of the factorial \
function. \
\>", "MathCaption",
  CellTags->{"S2.6.12", "12.9"}],

Cell["fac[1] = 1; fac[n_] := n fac[n-1]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.12"],

Cell[TextData[{
  "This evaluates ",
  StyleBox["fac[10]", "MR"],
  ", starting a dialog when it encounters ",
  StyleBox["fac[4]", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S2.6.12", "12.10"}],

Cell[CellGroupData[{

Cell["TraceDialog[fac[10], fac[4]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \(TraceDialog::"dgbgn" \(\(:\)\(\ \)\) 
      "Entering Dialog; use Return[] to exit."\)], "Message",
  CellTags->"S2.6.12"],

Cell[BoxData[
    TagBox[\(fac[4]\),
      HoldForm]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell["\<\
This shows what objects were being evaluated when the dialog was \
started. \
\>", "MathCaption",
  CellTags->{"S2.6.12", "12.11"}],

Cell[CellGroupData[{

Cell["Stack[ ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \({TraceDialog, Times, Times, Times, Times, Times, Times, 
      fac}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell["This ends the dialog. ", "MathCaption",
  CellTags->{"S2.6.12", "12.12"}],

Cell[CellGroupData[{

Cell["Return[ ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \(TraceDialog::"dgend" \(\(:\)\(\ \)\) "Exiting Dialog."\)], "Message",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \(3628800\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell[TextData[{
  "In the simplest cases, the ",
  StyleBox["Mathematica", "TI"],
  " evaluation stack is set up to record ",
  StyleBox["all", "TI"],
  " expressions currently being evaluated. Under some circumstances, however, \
this may be inconvenient. For example, executing ",
  StyleBox["Print[Stack[", "MR"],
  " ",
  StyleBox["]]", "MR"],
  " will always show a stack with ",
  StyleBox["Print", "MR"],
  " as the last function. "
}], "Text",
  CellTags->{"S2.6.12", "12.13"}],

Cell[TextData[{
  "The function ",
  StyleBox["StackInhibit", "MR"],
  " allows you to avoid this kind of problem. ",
  StyleBox["StackInhibit[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " evaluates ",
  StyleBox["expr", "TI"],
  " without modifying the stack. "
}], "Text",
  CellTags->{"S2.6.12", "12.14"}],

Cell[TextData[{
  StyleBox["StackInhibit", "MR"],
  " prevents ",
  StyleBox["Print", "MR"],
  " from being included on the stack. "
}], "MathCaption",
  CellTags->{"S2.6.12", "12.15"}],

Cell[CellGroupData[{

Cell["f[g[ StackInhibit[Print[Stack[ ]]] ]] ;", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \({CompoundExpression, f, g}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell[TextData[{
  "Functions like ",
  StyleBox["TraceDialog", "MR"],
  " automatically call ",
  StyleBox["StackInhibit", "MR"],
  " each time they start a dialog. This means that ",
  StyleBox["Stack", "MR"],
  " does not show functions that are called within the dialog, only those \
outside. "
}], "Text",
  CellTags->{"S2.6.12", "12.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StackInhibit[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " without modifying the stack "
            }]]},
          {Cell[TextData[{
              StyleBox["StackBegin[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " with a fresh stack "
            }]]},
          {Cell[TextData[{
              StyleBox["StackComplete[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              
              " with intermediate expressions in evaluation chains included \
on the stack "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.12"],

Cell["Controlling the evaluation stack. ", "Caption",
  CellTags->"S2.6.12"],

Cell[TextData[{
  "By using ",
  StyleBox["StackInhibit", "MR"],
  " and ",
  StyleBox["StackBegin", "MR"],
  ", you can control which parts of the evaluation process are recorded on \
the stack. ",
  StyleBox["StackBegin[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " evaluates ",
  StyleBox["expr", "TI"],
  ", starting a fresh stack. This means that during the evaluation of ",
  StyleBox["expr", "TI"],
  ", the stack does not include anything outside the ",
  StyleBox["StackBegin", "MR"],
  ". Functions like ",
  StyleBox["TraceDialog[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["]", "MR"],
  " call ",
  StyleBox["StackBegin", "MR"],
  " before they begin evaluating ",
  StyleBox["expr", "TI"],
  ", so that the stack shows how ",
  StyleBox["expr", "TI"],
  " is evaluated, but not how ",
  StyleBox["TraceDialog", "MR"],
  " was called. "
}], "Text",
  CellTags->{"S2.6.12", "12.17"}],

Cell[TextData[{
  StyleBox["StackBegin[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " uses a fresh stack in the evaluation of ",
  StyleBox["expr", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.12", "12.18"}],

Cell[CellGroupData[{

Cell["f[ StackBegin[ g[h[ StackInhibit[Print[Stack[ ]]] ]] ] ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \({g, h}\)], "Print",
  CellTags->"S2.6.12"],

Cell[BoxData[
    \(f[g[h[Null]]]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Stack", "MR"],
  " normally shows you only those expressions that are currently being \
evaluated. As a result, it includes only the latest form of each expression. \
Sometimes, however, you may find it useful also to see earlier forms of the \
expressions. You can do this using ",
  StyleBox["StackComplete", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.12", "12.19"}],

Cell[TextData[{
  "What ",
  StyleBox["StackComplete[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " effectively does is to keep on the stack the complete evaluation chain \
for each expression that is currently being evaluated. In this case, the \
stack corresponds to the sequence of expressions obtained from ",
  StyleBox["Trace", "MR"],
  " with the option ",
  StyleBox["TraceBackward", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  " as well as ",
  StyleBox["TraceAbove", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.12", "12.20"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.13 Advanced Topic: Controlling Infinite Evaluation", "Subsection",
  CellTags->{"S2.6.13", "13.1"}],

Cell[TextData[{
  "The general principle that ",
  StyleBox["Mathematica", "TI"],
  " follows in evaluating expressions is to go on applying transformation \
rules until the expressions no longer change. This means, for example, that \
if you make an assignment like ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " should go into an infinite loop. In fact, ",
  StyleBox["Mathematica", "TI"],
  " stops after a definite number of steps, determined by the value of the \
global variable ",
  StyleBox["$RecursionLimit", "MR"],
  ". You can always stop ",
  StyleBox["Mathematica", "TI"],
  " earlier by explicitly interrupting it. "
}], "Text",
  CellTags->{"S2.6.13", "13.2"}],

Cell[TextData[{
  "This assignment could cause an infinite loop. ",
  StyleBox["Mathematica", "TI"],
  " stops after a number of steps determined by ",
  StyleBox["$RecursionLimit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.13", "13.3"}],

Cell[CellGroupData[{

Cell["x = x + 1", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \(\(:\)\(\ \)\) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \(255 + Hold[1 + x]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " stops without finishing evaluation, it returns a held result. You can \
continue the evaluation by explicitly calling ",
  StyleBox["ReleaseHold", "MR"],
  ".  "
}], "MathCaption",
  CellTags->{"S2.6.13", "13.4"}],

Cell[CellGroupData[{

Cell["ReleaseHold[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \(\(:\)\(\ \)\) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \(510 + Hold[1 + x]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$RecursionLimit", "MR"],
              " "
            }]], Cell["maximum depth of the evaluation stack "]},
          {Cell[TextData[{
              StyleBox["$IterationLimit", "MR"],
              " "
            }]], Cell["maximum length of an evaluation chain "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.13"],

Cell["Global variables that limit infinite evaluation. ", "Caption",
  CellTags->"S2.6.13"],

Cell[TextData[{
  "Here is a circular definition, whose evaluation is stopped by ",
  StyleBox["$IterationLimit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.13", "13.5"}],

Cell[CellGroupData[{

Cell["{a, b} = {b, a}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($IterationLimit::"itlim" \(\(:\)\(\ \)\) 
      "Iteration limit of \!\(4096\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($IterationLimit::"itlim" \(\(:\)\(\ \)\) 
      "Iteration limit of \!\(4096\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \({Hold[b], Hold[a]}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell[TextData[{
  "The variables ",
  StyleBox["$RecursionLimit", "MR"],
  " and ",
  StyleBox["$IterationLimit", "MR"],
  " control the two basic ways that an evaluation can become infinite in ",
  StyleBox["Mathematica", "TI"],
  ". ",
  StyleBox["$RecursionLimit", "MR"],
  " limits the maximum depth of the evaluation stack, or equivalently, the \
maximum nesting depth that would occur in the list structure produced by ",
  StyleBox["Trace", "MR"],
  ". ",
  StyleBox["$IterationLimit", "MR"],
  " limits the maximum length of any particular evaluation chain, or the \
maximum length of any single list in the structure produced by ",
  StyleBox["Trace", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.13", "13.6"}],

Cell[TextData[{
  StyleBox["$RecursionLimit", "MR"],
  " and ",
  StyleBox["$IterationLimit", "MR"],
  " are by default set to values that are appropriate for most computations, \
and most computer systems. You can, however, reset these variables to any \
integer (above a lower limit), or to ",
  StyleBox["Infinity", "MR"],
  ". Note that on most computer systems, you should never set ",
  StyleBox["$RecursionLimit", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["Infinity", "MR"],
  ", as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.14.4",
    ButtonData:>{"2.14.4", "4.19"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.6.13", "13.7"}],

Cell[TextData[{
  "This resets ",
  StyleBox["$RecursionLimit", "MR"],
  " and ",
  StyleBox["$IterationLimit", "MR"],
  " to ",
  StyleBox["20", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.13", "13.8"}],

Cell[CellGroupData[{

Cell["$RecursionLimit = $IterationLimit = 20", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \(20\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell["\<\
Now infinite definitions like this are stopped after just 20 steps. \
\
\>", "MathCaption",
  CellTags->{"S2.6.13", "13.9"}],

Cell[CellGroupData[{

Cell["t = {t}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \(\(:\)\(\ \)\) 
      "Recursion depth of \!\(20\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \({{{{{{{{{{{{{{{{{{{Hold[{t}]}}}}}}}}}}}}}}}}}}}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell["\<\
Without an end condition, this recursive definition leads to \
infinite computations. \
\>", "MathCaption",
  CellTags->{"S2.6.13", "13.10"}],

Cell["fn[n_] := {fn[n-1], n}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.13"],

Cell["\<\
A fairly large structure is built up before the computation is \
stopped. \
\>", "MathCaption",
  CellTags->{"S2.6.13", "13.11"}],

Cell[CellGroupData[{

Cell["fn[10]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \(\(:\)\(\ \)\) 
      "Recursion depth of \!\(20\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \({{{{{{{{{{{{{{{{{{{Hold[fn[\(-8\) - 
                                        1]], \(-8\)}, \(-7\)}, \(-6\)}, \
\(-5\)}, \(-4\)}, \(-3\)}, \(-2\)}, \(-1\)}, 0}, 1}, 2}, 3}, 4}, 5}, 6}, 7}, 
          8}, 9}, 10}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell["Here is another recursive definition. ", "MathCaption",
  CellTags->{"S2.6.13", "13.12"}],

Cell["fm[n_] := fm[n - 1]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.13"],

Cell[TextData[{
  "In this case, no complicated structure is built up, and the computation is \
stopped by ",
  StyleBox["$IterationLimit", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.13", "13.13"}],

Cell[CellGroupData[{

Cell["fm[0]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \($IterationLimit::"itlim" \(\(:\)\(\ \)\) 
      "Iteration limit of \!\(20\) exceeded."\)], "Message",
  CellTags->"S2.6.13"],

Cell[BoxData[
    \(Hold[fm[\(-19\) - 1]]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.13"]
}, Open  ]],

Cell[TextData[{
  "It is important to realize that infinite loops can take up not only time \
but also computer memory. Computations limited by ",
  StyleBox["$IterationLimit", "MR"],
  " do not normally build up large intermediate structures. But those limited \
by ",
  StyleBox["$RecursionLimit", "MR"],
  " often do. In many cases, the size of the structures produced is a linear \
function of the value of ",
  StyleBox["$RecursionLimit", "MR"],
  ". But in some cases, the size can grow exponentially, or worse, with ",
  StyleBox["$RecursionLimit", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.13", "13.14"}],

Cell[TextData[{
  "An assignment like ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " is obviously circular. When you set up more complicated recursive \
definitions, however, it can be much more difficult to be sure that the \
recursion terminates, and that you will not end up in an infinite loop. The \
main thing to check is that the right\[Hyphen]hand sides of your \
transformation rules will always be different from the left\[Hyphen]hand \
sides. This ensures that evaluation will always \[OpenCurlyDoubleQuote]make \
progress\[CloseCurlyDoubleQuote], and ",
  StyleBox["Mathematica", "TI"],
  " will not simply end up applying the same transformation rule to the same \
expression over and over again. "
}], "Text",
  CellTags->{"S2.6.13", "13.15"}],

Cell[TextData[{
  "Some of the trickiest cases occur when you have rules that depend on \
complicated ",
  StyleBox["/;", "MR"],
  " conditions (see Section ",
  ButtonBox["2.3.5",
    ButtonData:>{"2.3.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  "). One particularly awkward case is when the condition involves a \
\[OpenCurlyDoubleQuote]global variable\[CloseCurlyDoubleQuote]. ",
  StyleBox["Mathematica", "TI"],
  " may think that the evaluation is finished because the expression did not \
change. However, a side effect of some other operation could change the value \
of the global variable, and so should lead to a new result in the evaluation. \
The best way to avoid this kind of difficulty is not to use global variables \
in ",
  StyleBox["/;", "MR"],
  " conditions. If all else fails, you can type ",
  StyleBox["Update[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " to tell ",
  StyleBox["Mathematica", "TI"],
  " to update all expressions involving ",
  StyleBox["s", "TI"],
  ". ",
  StyleBox["Update[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " to update absolutely all expressions. "
}], "Text",
  CellTags->{"S2.6.13", "13.16"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.14 Advanced Topic: Interrupts and Aborts", "Subsection",
  CellTags->{"S2.6.14", "14.1"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.3.12",
    ButtonData:>{"1.3.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  " described how you can interrupt a ",
  StyleBox["Mathematica", "TI"],
  " computation by pressing appropriate keys on your keyboard. "
}], "Text",
  CellTags->{"S2.6.14", "14.2"}],

Cell[TextData[{
  "In some cases, you may want to simulate such interrupts from within a ",
  StyleBox["Mathematica", "TI"],
  " program. In general, executing ",
  StyleBox["Interrupt[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " has the same effect as pressing interrupt keys. On a typical system, a \
menu of options is displayed, as discussed in Section ",
  ButtonBox["1.3.12",
    ButtonData:>{"1.3.12", "12.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.6.14", "14.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Interrupt[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["interrupt a computation "]},
          {Cell[TextData[{
              StyleBox["Abort[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["abort a computation "]},
          {Cell[TextData[{
              StyleBox["CheckAbort[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["failexpr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              " and return the result, or ",
              StyleBox["failexpr", "TI"],
              " if an abort occurs "
            }]]},
          {Cell[TextData[{
              StyleBox["AbortProtect[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["expr", "TI"],
              
              ", masking the effect of aborts until the evaluation is \
complete "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.14"],

Cell["Interrupts and aborts. ", "Caption",
  CellTags->"S2.6.14"],

Cell[TextData[{
  "The function ",
  StyleBox["Abort[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " has the same effect as interrupting a computation, and selecting the ",
  StyleBox["abort", "MR"],
  " option in the interrupt menu. "
}], "Text",
  CellTags->{"S2.6.14", "14.4"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Abort[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " to implement an \[OpenCurlyDoubleQuote]emergency stop\
\[CloseCurlyDoubleQuote] in a program. In almost all cases, however, you \
should try to use functions like ",
  StyleBox["Return", "MR"],
  " and ",
  StyleBox["Throw", "MR"],
  ", which lead to more controlled behavior. "
}], "Text",
  CellTags->{"S2.6.14", "14.5"}],

Cell[TextData[{
  StyleBox["Abort", "MR"],
  " terminates the computation, so only the first ",
  StyleBox["Print", "MR"],
  " is executed. "
}], "MathCaption",
  CellTags->{"S2.6.14", "14.6"}],

Cell[CellGroupData[{

Cell["Print[a]; Abort[ ]; Print[b]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(a\)], "Print",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.14"]
}, Open  ]],

Cell[TextData[{
  "If you abort at any point during the evaluation of a ",
  StyleBox["Mathematica", "TI"],
  " expression, ",
  StyleBox["Mathematica", "TI"],
  " normally abandons the evaluation of the whole expression, and returns the \
value ",
  StyleBox["$Aborted", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.14", "14.7"}],

Cell[TextData[{
  "You can, however, \[OpenCurlyDoubleQuote]catch\[CloseCurlyDoubleQuote] \
aborts using the function ",
  StyleBox["CheckAbort", "MR"],
  ". If an abort occurs during the evaluation of ",
  StyleBox["expr", "TI"],
  " in ",
  StyleBox["CheckAbort[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["failexpr", "TI"],
  StyleBox["]", "MR"],
  ", then ",
  StyleBox["CheckAbort", "MR"],
  " returns ",
  StyleBox["failexpr", "TI"],
  ", but the abort propagates no further. Functions like ",
  StyleBox["Dialog", "MR"],
  " use ",
  StyleBox["CheckAbort", "MR"],
  " in this way to contain the effect of aborts. "
}], "Text",
  CellTags->{"S2.6.14", "14.8"}],

Cell[TextData[{
  StyleBox["CheckAbort", "MR"],
  " catches the abort, prints ",
  StyleBox["c", "MR"],
  " and returns the value ",
  StyleBox["aborted", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.14", "14.9"}],

Cell[CellGroupData[{

Cell["CheckAbort[Print[a]; Abort[ ]; Print[b], Print[c]; aborted]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(a\)], "Print",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(c\)], "Print",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(aborted\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.14"]
}, Open  ]],

Cell[TextData[{
  "The effect of the ",
  StyleBox["Abort", "MR"],
  " is contained by ",
  StyleBox["CheckAbort", "MR"],
  ", so ",
  StyleBox["b", "MR"],
  " is printed. "
}], "MathCaption",
  CellTags->{"S2.6.14", "14.10"}],

Cell[CellGroupData[{

Cell["CheckAbort[Print[a]; Abort[ ], Print[c]; aborted]; Print[b]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(a\)], "Print",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(c\)], "Print",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(b\)], "Print",
  CellTags->"S2.6.14"]
}, Open  ]],

Cell[TextData[{
  "When you construct sophisticated programs in ",
  StyleBox["Mathematica", "TI"],
  ", you may sometimes want to guarantee that a particular section of code in \
a program cannot be aborted, either interactively or by calling ",
  StyleBox["Abort", "MR"],
  ". The function ",
  StyleBox["AbortProtect", "MR"],
  " allows you to evaluate an expression, saving up any aborts until after \
the evaluation of the expression is complete. "
}], "Text",
  CellTags->{"S2.6.14", "14.11"}],

Cell[TextData[{
  "The ",
  StyleBox["Abort", "MR"],
  " is saved up until ",
  StyleBox["AbortProtect", "MR"],
  " is finished. "
}], "MathCaption",
  CellTags->{"S2.6.14", "14.12"}],

Cell[CellGroupData[{

Cell["AbortProtect[Abort[ ]; Print[a]]; Print[b]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(a\)], "Print",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.14"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["CheckAbort", "MR"],
  " sees the abort, but does not propagate it further. "
}], "MathCaption",
  CellTags->{"S2.6.14", "14.13"}],

Cell[CellGroupData[{

Cell["AbortProtect[Abort[ ]; CheckAbort[Print[a], x]]; Print[b]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.14"],

Cell[BoxData[
    \(b\)], "Print",
  CellTags->"S2.6.14"]
}, Open  ]],

Cell[TextData[{
  "Even inside ",
  StyleBox["AbortProtect", "MR"],
  ", ",
  StyleBox["CheckAbort", "MR"],
  " will see any aborts that occur, and will return the appropriate ",
  StyleBox["failexpr", "TI"],
  ". Unless this ",
  StyleBox["failexpr", "TI"],
  " itself contains ",
  StyleBox["Abort[", "MR"],
  " ",
  StyleBox["]", "MR"],
  ", the aborts will be \[OpenCurlyDoubleQuote]absorbed\
\[CloseCurlyDoubleQuote] by the ",
  StyleBox["CheckAbort", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.14", "14.14"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.6.15 Compiling ",
  StyleBox["Mathematica", "SBO"],
  " Expressions"
}], "Subsection",
  CellTags->{"S2.6.15", "15.1"}],

Cell[TextData[{
  "If you make a definition like ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will store the expression ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  " in a form that can be evaluated for any ",
  StyleBox["x", "MR"],
  ". Then when you give a particular value for ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " substitutes this value into ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  ", and evaluates the result. The internal code that ",
  StyleBox["Mathematica", "TI"],
  " uses to perform this evaluation is set up to work equally well whether \
the value you give for ",
  StyleBox["x", "MR"],
  " is a number, a list, an algebraic object, or any other kind of \
expression. "
}], "Text",
  CellTags->{"S2.6.15", "15.2"}],

Cell[TextData[{
  "Having to take account of all these possibilities inevitably makes the \
evaluation process slower. However, if ",
  StyleBox["Mathematica", "TI"],
  " could ",
  StyleBox["assume", "TI"],
  " that ",
  StyleBox["x", "MR"],
  " will be a machine number, then it could avoid many steps, and potentially \
evaluate an expression like ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  " much more quickly. "
}], "Text",
  CellTags->{"S2.6.15", "15.3"}],

Cell[TextData[{
  "Using ",
  StyleBox["Compile", "MR"],
  ", you can construct ",
  StyleBox["compiled functions", "TI"],
  " in ",
  StyleBox["Mathematica", "TI"],
  ", which evaluate ",
  StyleBox["Mathematica", "TI"],
  " expressions assuming that all the parameters which appear are numbers (or \
logical variables). ",
  StyleBox["Compile[{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " takes an expression ",
  StyleBox["expr", "TI"],
  " and returns a \[OpenCurlyDoubleQuote]compiled function\
\[CloseCurlyDoubleQuote] which evaluates this expression when given arguments \
",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  ", \[Ellipsis]",
  " ",
  ". "
}], "Text",
  CellTags->{"S2.6.15", "15.4"}],

Cell[TextData[{
  "In general, ",
  StyleBox["Compile", "MR"],
  " creates a ",
  StyleBox["CompiledFunction", "MR"],
  " object which contains a sequence of simple instructions for evaluating \
the compiled function. The instructions are chosen to be close to those found \
in the machine code of a typical computer, and can thus be executed quickly. \
"
}], "Text",
  CellTags->{"S2.6.15", "15.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Compile[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a compiled function which evaluates ",
              StyleBox["expr", "TI"],
              " for numerical values of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.15"],

Cell["Creating compiled functions. ", "Caption",
  CellTags->"S2.6.15"],

Cell[TextData[{
  "This defines ",
  StyleBox["f", "MR"],
  " to be a pure function which evaluates ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  " for any ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.6"}],

Cell[CellGroupData[{

Cell["f = Function[{x}, x Sin[x]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(Function[{x}, x\ Sin[x]]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "This creates a compiled function for evaluating ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.7"}],

Cell[CellGroupData[{

Cell["fc = Compile[{x}, x Sin[x]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, x\ Sin[x], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  StyleBox["f", "MR"],
  " and ",
  StyleBox["fc", "MR"],
  " yield the same results, but ",
  StyleBox["fc", "MR"],
  " runs faster when the argument you give is a number. "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.8"}],

Cell[CellGroupData[{

Cell["{f[2.5], fc[2.5]}", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \({1.4961803602598913`, 1.4961803602598913`}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Compile", "MR"],
  " is useful in situations where you have to evaluate a particular numerical \
or logical expression many times. By taking the time to call ",
  StyleBox["Compile", "MR"],
  ", you can get a compiled function which can be executed more quickly than \
an ordinary ",
  StyleBox["Mathematica", "TI"],
  " function. "
}], "Text",
  CellTags->{"S2.6.15", "15.9"}],

Cell[TextData[{
  "For simple expressions such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["Sin[x]", "MR"],
  ", there is usually little difference between the execution speed for \
ordinary and compiled functions. However, as the size of the expressions \
involved increases, the advantage of compilation also increases. For large \
expressions, compilation can speed up execution by a factor as large as 20. "
}], "Text",
  CellTags->{"S2.6.15", "15.10"}],

Cell[TextData[{
  "Compilation makes the biggest difference for expressions containing a \
large number of simple, say arithmetic, functions. For more complicated \
functions, such as ",
  StyleBox["BesselK", "MR"],
  " or ",
  StyleBox["Eigenvalues", "MR"],
  ", most of the computation time is spent executing internal ",
  StyleBox["Mathematica", "TI"],
  " algorithms, on which compilation has no effect. "
}], "Text",
  CellTags->{"S2.6.15", "15.11"}],

Cell[TextData[{
  "This creates a compiled function for finding values of the tenth Legendre \
polynomial. The ",
  StyleBox["Evaluate", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " to construct the polynomial explicitly before doing compilation. "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.12"}],

Cell[CellGroupData[{

Cell["pc = Compile[{x}, Evaluate[LegendreP[10, x]]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, 
        1\/256\ \((\(-63\) + 3465\ x\^2 - 30030\ x\^4 + 90090\ x\^6 - 
              109395\ x\^8 + 46189\ x\^10)\), "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "This finds the value of the tenth Legendre polynomial with argument ",
  StyleBox["0.4", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.13"}],

Cell[CellGroupData[{

Cell["pc[0.4]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(0.09683906440000015`\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["\<\
This uses built\[Hyphen]in numerical code. \
\>", "MathCaption",
  CellTags->{"S2.6.15", "15.14"}],

Cell[CellGroupData[{

Cell["LegendreP[10, 0.4]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(0.0968390643999999`\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "Even though you can use compilation to speed up numerical functions that \
you write, you should still try to use built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions whenever possible. Built\[Hyphen]in functions will usually run \
faster than any compiled ",
  StyleBox["Mathematica", "TI"],
  " programs you can create. In addition, they typically use more extensive \
algorithms, with more complete control over numerical precision and so on. "
}], "Text",
  CellTags->{"S2.6.15", "15.15"}],

Cell[TextData[{
  "You should realize that built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions quite often themselves use ",
  StyleBox["Compile", "MR"],
  ". Thus, for example, ",
  StyleBox["NIntegrate", "MR"],
  " by default automatically uses ",
  StyleBox["Compile", "MR"],
  " on the expression you tell it to integrate. Similarly, functions like ",
  StyleBox["Plot", "MR"],
  " and ",
  StyleBox["Plot3D", "MR"],
  " use ",
  StyleBox["Compile", "MR"],
  " on the expressions you ask them to plot. Built\[Hyphen]in functions that \
use ",
  StyleBox["Compile", "MR"],
  " typically have the option ",
  StyleBox["Compiled", "MR"],
  ". Setting ",
  StyleBox["Compiled", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["False", "MR"],
  " tells the functions not to use ",
  StyleBox["Compile", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.15", "15.16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Compile[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "compile ",
              StyleBox["expr", "TI"],
              " assuming that ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " is of type ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Compile[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "compile ",
              StyleBox["expr", "TI"],
              " assuming that ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " is a rank ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " array of objects each of type ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Compile[", "MR"],
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "compile ",
              StyleBox["expr", "TI"],
              ", assuming that subexpressions which match ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " are of type ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pt",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["_Integer", "MR"],
              " "
            }]], Cell["machine\[Hyphen]size integer "]},
          {Cell[TextData[{
              StyleBox["_Real", "MR"],
              " "
            }]], 
            Cell["\<\
machine\[Hyphen]precision approximate real number \
\
\>"]},
          {Cell[TextData[{
              StyleBox["_Complex", "MR"],
              " "
            }]], 
            Cell["\<\
machine\[Hyphen]precision approximate complex number \
\
\>"]},
          {Cell[TextData[{
              StyleBox["True", "MR"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["logical variable "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, True, False}},
  CellTags->"S2.6.15"],

Cell["Specifying types for compilation. ", "Caption",
  CellTags->"S2.6.15"],

Cell[TextData[{
  StyleBox["Compile", "MR"],
  " works by making assumptions about the types of objects that occur in \
evaluating the expression you give. The default assumption is that all \
variables in the expression are approximate real numbers. "
}], "Text",
  CellTags->{"S2.6.15", "15.17"}],

Cell[TextData[{
  StyleBox["Compile", "MR"],
  " nevertheless also allows integers, complex numbers and logical variables \
(",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "), as well as arrays of numbers. You can specify the type of a particular \
variable by giving a pattern which matches only values that have that type. \
Thus, for example, you can use the pattern ",
  StyleBox["_Integer", "MR"],
  " to specify the integer type. Similarly, you can use ",
  StyleBox["True", "MR"],
  " ",
  StyleBox["|", "MR"],
  " ",
  StyleBox["False", "MR"],
  " to specify a logical variable that must be either ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.6.15", "15.18"}],

Cell[TextData[{
  "This compiles the expression ",
  StyleBox["5", "MR"],
  " ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["j", "MR"],
  " with the assumption that ",
  StyleBox["i", "MR"],
  " and ",
  StyleBox["j", "MR"],
  " are integers. "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.19"}],

Cell[CellGroupData[{

Cell["Compile[{{i, _Integer}, {j, _Integer}}, 5 i + j]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{i, j}, 5\ i + j, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["This yields an integer result. ", "MathCaption",
  CellTags->{"S2.6.15", "15.20"}],

Cell[CellGroupData[{

Cell["%[8, 7]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(47\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["\<\
This compiles an expression that performs an operation on a matrix \
of integers. \
\>", "MathCaption",
  CellTags->{"S2.6.15", "15.21"}],

Cell[CellGroupData[{

Cell["Compile[{{m, _Integer, 2}}, Apply[Plus, Flatten[m]]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{m}, Plus @@ Flatten[m], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["\<\
The list operations are now carried out in a compiled way, and the \
result is an integer. \
\>", "MathCaption",
  CellTags->{"S2.6.15", "15.22"}],

Cell[CellGroupData[{

Cell["%[{{1, 2, 3}, {7, 8, 9}}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(30\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "The types that ",
  StyleBox["Compile", "MR"],
  " handles correspond essentially to the types that computers typically \
handle at a machine\[Hyphen]code level. Thus, for example, ",
  StyleBox["Compile", "MR"],
  " can handle approximate real numbers that have machine precision, but it \
cannot handle arbitrary\[Hyphen]precision numbers. In addition, if you \
specify that a particular variable is an integer, ",
  StyleBox["Compile", "MR"],
  " generates code only for the case when the integer is of \
\[OpenCurlyDoubleQuote]machine size\[CloseCurlyDoubleQuote], typically \
between ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]2\^31\)\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S2.6.15", "15.23"}],

Cell[TextData[{
  "When the expression you ask to compile involves only standard arithmetic \
and logical operations, ",
  StyleBox["Compile", "MR"],
  " can deduce the types of objects generated at every step simply from the \
types of the input variables. However, if you call other functions, ",
  StyleBox["Compile", "MR"],
  " will typically not know what type of value they return. If you do not \
specify otherwise, ",
  StyleBox["Compile", "MR"],
  " assumes that any other function yields an approximate real number value. \
You can, however, also give an explicit list of patterns, specifying what \
type to assume for an expression that matches a particular pattern. "
}], "Text",
  CellTags->{"S2.6.15", "15.24"}],

Cell["\<\
This defines a function which yields an integer result when given \
an integer argument. \
\>", "MathCaption",
  CellTags->{"S2.6.15", "15.25"}],

Cell["com[i_] := Binomial[2i, i]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.6.15"],

Cell[TextData[{
  "This compiles ",
  StyleBox["x^com[i]", "MR"],
  " using the assumption that ",
  StyleBox["com[_]", "MR"],
  " is always an integer. "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.26"}],

Cell[CellGroupData[{

Cell["Compile[{x, {i, _Integer}}, x^com[i], {{com[_], _Integer}}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x, i}, x\^com[i], "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["This evaluates the compiled function. ", "MathCaption",
  CellTags->{"S2.6.15", "15.27"}],

Cell[CellGroupData[{

Cell["%[5.6, 1]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(31.359999999999996`\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "The idea of ",
  StyleBox["Compile", "MR"],
  " is to create a function which is optimized for certain types of \
arguments. ",
  StyleBox["Compile", "MR"],
  " is nevertheless set up so that the functions it creates work with \
whatever types of arguments they are given. When the optimization cannot be \
used, a standard ",
  StyleBox["Mathematica", "TI"],
  " expression is evaluated to find the value of the function. "
}], "Text",
  CellTags->{"S2.6.15", "15.28"}],

Cell["\<\
Here is a compiled function for taking the square root of a \
variable. \
\>", "MathCaption",
  CellTags->{"S2.6.15", "15.29"}],

Cell[CellGroupData[{

Cell["sq = Compile[{x}, Sqrt[x]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x}, \@x, "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["If you give a real number argument, optimized code is used. ", \
"MathCaption",
  CellTags->{"S2.6.15", "15.30"}],

Cell[CellGroupData[{

Cell["sq[4.5]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(2.1213203435596424`\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "The compiled code cannot be used, so ",
  StyleBox["Mathematica", "TI"],
  " prints a warning, then just evaluates the original symbolic expression. "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.31"}],

Cell[CellGroupData[{

Cell["sq[1 + u]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(CompiledFunction::"cfsa" \(\(:\)\(\ \)\) 
      "Argument \!\(1 + u\) at position \!\(1\) should be a \
\!\(\"machine-size real number\"\)."\)], "Message",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(\@\(1 + u\)\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "The compiled code generated by ",
  StyleBox["Compile", "MR"],
  " must make assumptions not only about the types of arguments you will \
supply, but also about the types of all objects that arise during the \
execution of the code. Sometimes these types depend on the actual ",
  StyleBox["values", "TI"],
  " of the arguments you specify. Thus, for example, ",
  StyleBox["Sqrt[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["]", "MR"],
  " yields a real number result for real ",
  StyleBox["x", "TI"],
  " if ",
  StyleBox["x", "TI"],
  " is not negative, but yields a complex number if ",
  StyleBox["x", "TI"],
  " is negative. "
}], "Text",
  CellTags->{"S2.6.15", "15.32"}],

Cell[TextData[{
  StyleBox["Compile", "MR"],
  " always makes a definite assumption about the type returned by a \
particular function. If this assumption turns out to be invalid in a \
particular case when the code generated by ",
  StyleBox["Compile", "MR"],
  " is executed, then ",
  StyleBox["Mathematica", "TI"],
  " simply abandons the compiled code in this case, and evaluates an ordinary \
",
  StyleBox["Mathematica", "TI"],
  " expression to get the result. "
}], "Text",
  CellTags->{"S2.6.15", "15.33"}],

Cell[TextData[{
  "The compiled code does not expect a complex number, so ",
  StyleBox["Mathematica", "TI"],
  " has to revert to explicitly evaluating the original symbolic expression. \
"
}], "MathCaption",
  CellTags->{"S2.6.15", "15.34"}],

Cell[CellGroupData[{

Cell["sq[-4.5]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(CompiledFunction::"cfn" \(\(:\)\(\ \)\) 
      "Numerical error encountered at instruction \!\(2\); proceeding with \
uncompiled evaluation."\)], "Message",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(\(\(0.`\)\(\[InvisibleSpace]\)\) + 
      2.1213203435596424`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell[TextData[{
  "An important feature of ",
  StyleBox["Compile", "MR"],
  " is that it can handle not only mathematical expressions, but also various \
simple ",
  StyleBox["Mathematica", "TI"],
  " programs. Thus, for example, ",
  StyleBox["Compile", "MR"],
  " can handle conditionals and control flow structures. "
}], "Text",
  CellTags->{"S2.6.15", "15.35"}],

Cell[TextData[{
  "In all cases, ",
  StyleBox["Compile[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " holds its arguments unevaluated. This means that you can explicitly give \
a \[OpenCurlyDoubleQuote]program\[CloseCurlyDoubleQuote] as the expression to \
compile. "
}], "Text",
  CellTags->{"S2.6.15", "15.36"}],

Cell[TextData[{
  "This creates a compiled version of a ",
  StyleBox["Mathematica", "TI"],
  " program which implements Newton's approximation to square roots. "
}], "MathCaption",
  CellTags->{"S2.6.15", "15.37"}],

Cell[CellGroupData[{

Cell["\<\
newt = Compile[ {x, {n, _Integer}}, Module[{t}, t = x; Do[t = (t + \
x/t)/2, {n}]; t] ]\
\>", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    TagBox[\(CompiledFunction[{x, n}, 
        Module[{t}, t = x; Do[t = 1\/2\ \((t + x\/t)\), {n}]; t], 
        "-CompiledCode-"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.6.15"]
}, Open  ]],

Cell["This executes the compiled code. ", "MathCaption",
  CellTags->{"S2.6.15", "15.38"}],

Cell[CellGroupData[{

Cell["newt[2.4, 6]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.6.15"],

Cell[BoxData[
    \(1.5491933384829668`\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.6.15"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.6.16 Advanced Topic: Manipulating Compiled Code", "Subsection",
  CellTags->{"S2.6.16", "16.1"}],

Cell[TextData[{
  "If you use compiled code created by ",
  StyleBox["Compile", "MR"],
  " only within ",
  StyleBox["Mathematica", "TI"],
  " itself, then you should never need to know the details of its internal \
form. Nevertheless, the compiled code can be represented by an ordinary ",
  StyleBox["Mathematica", "TI"],
  " expression, and it is sometimes useful to manipulate it. "
}], "Text",
  CellTags->{"S2.6.16", "16.2"}],

Cell[TextData[{
  "For example, you can take compiled code generated by ",
  StyleBox["Compile", "MR"],
  ", and feed it to external programs or devices. You can also create ",
  StyleBox["CompiledFunction", "MR"],
  " objects yourself, then execute them in ",
  StyleBox["Mathematica", "TI"],
  "."
}], "Text",
  CellTags->{"S2.6.16", "16.3"}],

Cell[TextData[{
  "In all of these cases, you need to know the internal form of ",
  StyleBox["CompiledFunction", "MR"],
  " objects. The first element of a ",
  StyleBox["CompiledFunction", "MR"],
  " object is always a list of patterns which specifies the types of \
arguments accepted by the object. The fifth element of a ",
  StyleBox["CompiledFunction", "MR"],
  " object is a ",
  StyleBox["Mathematica", "TI"],
  " pure function that is used if the compiled code instruction stream fails \
for any reason to give a result. "
}], "Text",
  CellTags->{"S2.6.16", "16.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CompiledFunction[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["reg",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["reg",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["l",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["r",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["c",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["t",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}, ",
              StyleBox["instr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["func", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "compiled code taking arguments of type ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["arg",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and executing the instruction stream ",
              StyleBox["instr", "TI"],
              " using ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], 
                      StyleBox["k",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " registers of type ",
              StyleBox["k", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.6.16"],

Cell["The structure of a compiled code object. ", "Caption",
  CellTags->"S2.6.16"],

Cell[TextData[{
  "This shows the explicit form of the compiled code generated by ",
  StyleBox["Compile", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.6.16", "16.5"}],

Cell[CellGroupData[{

Cell["Compile[{x}, x^2] // InputForm", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.6.16"],

Cell["\<\
CompiledFunction[{_Real}, {{3, 0, 0}, {3, 0, 1}},   {0, 1, 2, 0, \
0}, {{1, 5}, {4, 2, 0},    {89, 264, 3, 0, 0, 2, 0, 0, 3, 0, 1}, {2}},   \
Function[{x}, x^2], Evaluate]\
\>", "Output",
  CellLabel->"Out[1]//InputForm= ",
  CellTags->"S2.6.16"]
}, Open  ]],

Cell[TextData[{
  "The instruction stream in a ",
  StyleBox["CompiledFunction", "MR"],
  " object consists of a list of instructions for a simple idealized \
computer. The computer is assumed to have numbered \
\[OpenCurlyDoubleQuote]registers\[CloseCurlyDoubleQuote], on which operations \
can be performed. There are five basic types of registers: logical, integer, \
real, complex and tensor. For each of these basic types it is then possible \
to have either a single scalar register or an array of registers of any rank. \
A list of the total number of registers of each type required to evaluate a \
particular ",
  StyleBox["CompiledFunction", "MR"],
  " object is given as the second element of the object. "
}], "Text",
  CellTags->{"S2.6.16", "16.6"}],

Cell["\<\
The actual instructions in the compiled code object are given as \
lists. The first element is an integer \[OpenCurlyDoubleQuote]opcode\
\[CloseCurlyDoubleQuote] which specifies what operation should be performed. \
Subsequent elements are either the numbers of registers of particular types, \
or literal constants. Typically the last element of the list is the number of \
a \[OpenCurlyDoubleQuote]destination register\[CloseCurlyDoubleQuote], into \
which the result of the operation should be put. \
\>", "Text",
  CellTags->{"S2.6.16", "16.7"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 34}, {58, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.6.0"->{
    Cell[1776, 53, 128, 4, 65, "Section",
      CellTags->{"S2.6.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 128, 4, 65, "Section",
      CellTags->{"S2.6.0", "0.1"}]},
  "S2.6.1"->{
    Cell[1929, 61, 83, 1, 70, "Subsection",
      CellTags->{"S2.6.1", "1.1"}],
    Cell[2015, 64, 311, 9, 70, "Text",
      CellTags->{"S2.6.1", "1.2"}],
    Cell[2329, 75, 292, 8, 70, "Text",
      CellTags->{"S2.6.1", "1.3"}],
    Cell[2624, 85, 972, 44, 70, "Text",
      CellTags->{"S2.6.1", "1.4"}],
    Cell[3599, 131, 668, 19, 70, "Text",
      CellTags->{"S2.6.1", "1.5"}],
    Cell[4270, 152, 1648, 53, 70, "DefinitionBox",
      CellTags->"S2.6.1"],
    Cell[5921, 207, 77, 1, 70, "Caption",
      CellTags->"S2.6.1"],
    Cell[6001, 210, 325, 9, 70, "Text",
      CellTags->{"S2.6.1", "1.6"}],
    Cell[6329, 221, 207, 9, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.7"}],
    Cell[6561, 234, 84, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[6648, 238, 82, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[6745, 244, 213, 7, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.8"}],
    Cell[6983, 255, 66, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[7052, 259, 82, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[7149, 265, 158, 4, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.9"}],
    Cell[7310, 271, 98, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[7411, 275, 262, 8, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.10"}],
    Cell[7698, 287, 71, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[7772, 291, 88, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[7875, 297, 368, 8, 70, "Text",
      CellTags->{"S2.6.1", "1.11"}],
    Cell[8246, 307, 263, 7, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.12"}],
    Cell[8534, 318, 80, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[8617, 322, 92, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[8724, 328, 573, 14, 70, "Text",
      CellTags->{"S2.6.1", "1.13"}],
    Cell[9300, 344, 181, 5, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.14"}],
    Cell[9506, 353, 74, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[9583, 357, 92, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[9690, 363, 385, 10, 70, "Text",
      CellTags->{"S2.6.1", "1.15"}],
    Cell[10078, 375, 144, 5, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.16"}],
    Cell[10247, 384, 75, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[10325, 388, 85, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[10425, 394, 114, 2, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.17"}],
    Cell[10564, 400, 74, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[10641, 404, 83, 3, 70, "Output",
      CellTags->"S2.6.1"],
    Cell[10739, 410, 773, 18, 70, "Text",
      CellTags->{"S2.6.1", "1.18"}],
    Cell[11515, 430, 223, 7, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.19"}],
    Cell[11763, 441, 84, 2, 70, "Input",
      CellTags->"S2.6.1"],
    Cell[11850, 445, 59, 2, 70, "Print",
      CellTags->"S2.6.1"],
    Cell[11912, 449, 59, 2, 70, "Print",
      CellTags->"S2.6.1"],
    Cell[11974, 453, 59, 2, 70, "Print",
      CellTags->"S2.6.1"]},
  "1.1"->{
    Cell[1929, 61, 83, 1, 70, "Subsection",
      CellTags->{"S2.6.1", "1.1"}]},
  "1.2"->{
    Cell[2015, 64, 311, 9, 70, "Text",
      CellTags->{"S2.6.1", "1.2"}]},
  "1.3"->{
    Cell[2329, 75, 292, 8, 70, "Text",
      CellTags->{"S2.6.1", "1.3"}]},
  "1.4"->{
    Cell[2624, 85, 972, 44, 70, "Text",
      CellTags->{"S2.6.1", "1.4"}]},
  "1.5"->{
    Cell[3599, 131, 668, 19, 70, "Text",
      CellTags->{"S2.6.1", "1.5"}]},
  "1.6"->{
    Cell[6001, 210, 325, 9, 70, "Text",
      CellTags->{"S2.6.1", "1.6"}]},
  "1.7"->{
    Cell[6329, 221, 207, 9, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.7"}]},
  "1.8"->{
    Cell[6745, 244, 213, 7, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.8"}]},
  "1.9"->{
    Cell[7149, 265, 158, 4, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.9"}]},
  "1.10"->{
    Cell[7411, 275, 262, 8, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.10"}]},
  "1.11"->{
    Cell[7875, 297, 368, 8, 70, "Text",
      CellTags->{"S2.6.1", "1.11"}]},
  "1.12"->{
    Cell[8246, 307, 263, 7, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.12"}]},
  "1.13"->{
    Cell[8724, 328, 573, 14, 70, "Text",
      CellTags->{"S2.6.1", "1.13"}]},
  "1.14"->{
    Cell[9300, 344, 181, 5, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.14"}]},
  "1.15"->{
    Cell[9690, 363, 385, 10, 70, "Text",
      CellTags->{"S2.6.1", "1.15"}]},
  "1.16"->{
    Cell[10078, 375, 144, 5, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.16"}]},
  "1.17"->{
    Cell[10425, 394, 114, 2, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.17"}]},
  "1.18"->{
    Cell[10739, 410, 773, 18, 70, "Text",
      CellTags->{"S2.6.1", "1.18"}]},
  "1.19"->{
    Cell[11515, 430, 223, 7, 70, "MathCaption",
      CellTags->{"S2.6.1", "1.19"}]},
  "S2.6.2"->{
    Cell[12082, 461, 102, 1, 70, "Subsection",
      CellTags->{"S2.6.2", "2.1"}],
    Cell[12187, 464, 331, 7, 70, "Text",
      CellTags->{"S2.6.2", "2.2"}],
    Cell[12521, 473, 1121, 50, 70, "Text",
      CellTags->{"S2.6.2", "2.3"}],
    Cell[13645, 525, 212, 5, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.4"}],
    Cell[13882, 534, 75, 2, 70, "Input",
      CellTags->"S2.6.2"],
    Cell[13960, 538, 90, 3, 70, "Output",
      CellTags->"S2.6.2"],
    Cell[14065, 544, 325, 7, 70, "Text",
      CellTags->{"S2.6.2", "2.5"}],
    Cell[14393, 553, 812, 29, 70, "Text",
      CellTags->{"S2.6.2", "2.6"}],
    Cell[15208, 584, 156, 4, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.7"}],
    Cell[15389, 592, 73, 2, 70, "Input",
      CellTags->"S2.6.2"],
    Cell[15465, 596, 90, 3, 70, "Output",
      CellTags->"S2.6.2"],
    Cell[15570, 602, 1642, 50, 70, "DefinitionBox",
      CellTags->"S2.6.2"],
    Cell[17215, 654, 179, 5, 70, "Caption",
      CellTags->"S2.6.2"],
    Cell[17397, 661, 253, 5, 70, "Text",
      CellTags->{"S2.6.2", "2.8"}],
    Cell[17653, 668, 260, 8, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.9"}],
    Cell[17938, 680, 91, 2, 70, "Input",
      CellTags->"S2.6.2"],
    Cell[18032, 684, 82, 3, 70, "Output",
      CellTags->"S2.6.2"],
    Cell[18129, 690, 560, 24, 70, "Text",
      CellTags->{"S2.6.2", "2.10"}],
    Cell[18692, 716, 430, 11, 70, "Text",
      CellTags->{"S2.6.2", "2.11"}],
    Cell[19125, 729, 454, 10, 70, "Text",
      CellTags->{"S2.6.2", "2.12"}],
    Cell[19582, 741, 340, 7, 70, "Text",
      CellTags->{"S2.6.2", "2.13"}],
    Cell[19925, 750, 542, 12, 70, "Text",
      CellTags->{"S2.6.2", "2.14"}],
    Cell[20470, 764, 130, 4, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.15"}],
    Cell[20625, 772, 93, 2, 70, "Input",
      CellTags->"S2.6.2"],
    Cell[20721, 776, 127, 3, 70, "Output",
      CellTags->"S2.6.2"],
    Cell[20863, 782, 226, 5, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.16"}],
    Cell[21114, 791, 73, 2, 70, "Input",
      CellTags->"S2.6.2"],
    Cell[21190, 795, 111, 3, 70, "Output",
      CellTags->"S2.6.2"],
    Cell[21316, 801, 152, 4, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.17"}],
    Cell[21493, 809, 73, 2, 70, "Input",
      CellTags->"S2.6.2"],
    Cell[21569, 813, 156, 4, 70, "Output",
      CellTags->"S2.6.2"],
    Cell[21740, 820, 342, 10, 70, "Text",
      CellTags->{"S2.6.2", "2.18"}],
    Cell[22085, 832, 319, 6, 70, "Text",
      CellTags->{"S2.6.2", "2.19"}],
    Cell[22407, 840, 437, 8, 70, "Text",
      CellTags->{"S2.6.2", "2.20"}]},
  "2.1"->{
    Cell[12082, 461, 102, 1, 70, "Subsection",
      CellTags->{"S2.6.2", "2.1"}]},
  "2.2"->{
    Cell[12187, 464, 331, 7, 70, "Text",
      CellTags->{"S2.6.2", "2.2"}]},
  "2.3"->{
    Cell[12521, 473, 1121, 50, 70, "Text",
      CellTags->{"S2.6.2", "2.3"}]},
  "2.4"->{
    Cell[13645, 525, 212, 5, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.4"}]},
  "2.5"->{
    Cell[14065, 544, 325, 7, 70, "Text",
      CellTags->{"S2.6.2", "2.5"}]},
  "2.6"->{
    Cell[14393, 553, 812, 29, 70, "Text",
      CellTags->{"S2.6.2", "2.6"}]},
  "2.7"->{
    Cell[15208, 584, 156, 4, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.7"}]},
  "2.8"->{
    Cell[17397, 661, 253, 5, 70, "Text",
      CellTags->{"S2.6.2", "2.8"}]},
  "2.9"->{
    Cell[17653, 668, 260, 8, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.9"}]},
  "2.10"->{
    Cell[18129, 690, 560, 24, 70, "Text",
      CellTags->{"S2.6.2", "2.10"}]},
  "2.11"->{
    Cell[18692, 716, 430, 11, 70, "Text",
      CellTags->{"S2.6.2", "2.11"}]},
  "2.12"->{
    Cell[19125, 729, 454, 10, 70, "Text",
      CellTags->{"S2.6.2", "2.12"}]},
  "2.13"->{
    Cell[19582, 741, 340, 7, 70, "Text",
      CellTags->{"S2.6.2", "2.13"}]},
  "2.14"->{
    Cell[19925, 750, 542, 12, 70, "Text",
      CellTags->{"S2.6.2", "2.14"}]},
  "2.15"->{
    Cell[20470, 764, 130, 4, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.15"}]},
  "2.16"->{
    Cell[20863, 782, 226, 5, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.16"}]},
  "2.17"->{
    Cell[21316, 801, 152, 4, 70, "MathCaption",
      CellTags->{"S2.6.2", "2.17"}]},
  "2.18"->{
    Cell[21740, 820, 342, 10, 70, "Text",
      CellTags->{"S2.6.2", "2.18"}]},
  "2.19"->{
    Cell[22085, 832, 319, 6, 70, "Text",
      CellTags->{"S2.6.2", "2.19"}]},
  "2.20"->{
    Cell[22407, 840, 437, 8, 70, "Text",
      CellTags->{"S2.6.2", "2.20"}]},
  "S2.6.3"->{
    Cell[22881, 853, 69, 1, 70, "Subsection",
      CellTags->{"S2.6.3", "3.1"}],
    Cell[22953, 856, 356, 12, 70, "Text",
      CellTags->{"S2.6.3", "3.2"}],
    Cell[23312, 870, 491, 11, 70, "Text",
      CellTags->{"S2.6.3", "3.3"}],
    Cell[23806, 883, 177, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.4"}],
    Cell[23986, 892, 86, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[24075, 896, 207, 6, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.5"}],
    Cell[24307, 906, 77, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[24387, 910, 91, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[24493, 916, 331, 7, 70, "Text",
      CellTags->{"S2.6.3", "3.6"}],
    Cell[24827, 925, 162, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.7"}],
    Cell[24992, 932, 81, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[25076, 936, 194, 6, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.8"}],
    Cell[25295, 946, 89, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[25387, 950, 91, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[25493, 956, 2858, 91, 70, "DefinitionBox",
      CellTags->"S2.6.3"],
    Cell[28354, 1049, 77, 1, 70, "Caption",
      CellTags->"S2.6.3"],
    Cell[28434, 1052, 139, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.9"}],
    Cell[28598, 1061, 77, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[28678, 1065, 87, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[28780, 1071, 160, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.10"}],
    Cell[28965, 1080, 83, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[29051, 1084, 83, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[29149, 1090, 6065, 190, 70, "DefinitionBox",
      CellTags->"S2.6.3"],
    Cell[35217, 1282, 145, 5, 70, "Caption",
      CellTags->"S2.6.3"],
    Cell[35365, 1289, 163, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.11"}],
    Cell[35553, 1298, 80, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[35636, 1302, 156, 4, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[35807, 1309, 548, 12, 70, "Text",
      CellTags->{"S2.6.3", "3.12"}],
    Cell[36358, 1323, 174, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.13"}],
    Cell[36557, 1334, 79, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[36639, 1338, 106, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[36760, 1344, 143, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.14"}],
    Cell[36906, 1351, 90, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[36999, 1355, 172, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.15"}],
    Cell[37196, 1364, 80, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[37279, 1368, 109, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[37403, 1374, 661, 16, 70, "Text",
      CellTags->{"S2.6.3", "3.16"}],
    Cell[38067, 1392, 917, 27, 70, "Text",
      CellTags->{"S2.6.3", "3.17"}],
    Cell[38987, 1421, 140, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.18"}],
    Cell[39152, 1430, 78, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[39233, 1434, 87, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[39335, 1440, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.19"}],
    Cell[39546, 1451, 75, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[39624, 1455, 87, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[39726, 1461, 142, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.20"}],
    Cell[39893, 1470, 74, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[39970, 1474, 135, 3, 70, "Message",
      CellTags->"S2.6.3"],
    Cell[40108, 1479, 83, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[40206, 1485, 564, 14, 70, "Text",
      CellTags->{"S2.6.3", "3.21"}],
    Cell[40773, 1501, 173, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.22"}],
    Cell[40971, 1510, 67, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[41041, 1514, 65, 2, 70, "Print",
      CellTags->"S2.6.3"],
    Cell[41109, 1518, 475, 15, 70, "Print",
      CellTags->"S2.6.3"],
    Cell[41599, 1536, 172, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.23"}],
    Cell[41774, 1545, 96, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[41873, 1549, 147, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.24"}],
    Cell[42045, 1558, 67, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[42115, 1562, 65, 2, 70, "Print",
      CellTags->"S2.6.3"],
    Cell[42183, 1566, 272, 8, 70, "Print",
      CellTags->"S2.6.3"],
    Cell[42470, 1577, 743, 22, 70, "Text",
      CellTags->{"S2.6.3", "3.25"}],
    Cell[43216, 1601, 836, 26, 70, "DefinitionBox",
      CellTags->"S2.6.3"],
    Cell[44055, 1629, 73, 1, 70, "Caption",
      CellTags->"S2.6.3"],
    Cell[44131, 1632, 208, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.26"}],
    Cell[44342, 1641, 76, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[44421, 1645, 128, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.27"}],
    Cell[44574, 1654, 80, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[44657, 1658, 97, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[44769, 1664, 470, 8, 70, "Text",
      CellTags->{"S2.6.3", "3.28"}],
    Cell[45242, 1674, 249, 8, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.29"}],
    Cell[45516, 1686, 88, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[45607, 1690, 109, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[45731, 1696, 1623, 52, 70, "DefinitionBox",
      CellTags->"S2.6.3"],
    Cell[47357, 1750, 123, 4, 70, "Caption",
      CellTags->"S2.6.3"],
    Cell[47483, 1756, 304, 8, 70, "Text",
      CellTags->{"S2.6.3", "3.30"}],
    Cell[47790, 1766, 1222, 37, 70, "DefinitionBox",
      CellTags->"S2.6.3"],
    Cell[49015, 1805, 73, 1, 70, "Caption",
      CellTags->"S2.6.3"],
    Cell[49091, 1808, 147, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.31"}],
    Cell[49263, 1817, 96, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[49362, 1821, 94, 3, 70, "Output",
      CellTags->"S2.6.3"],
    Cell[49471, 1827, 242, 8, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.32"}],
    Cell[49738, 1839, 108, 2, 70, "Input",
      CellTags->"S2.6.3"],
    Cell[49849, 1843, 100, 3, 70, "Output",
      CellTags->"S2.6.3"]},
  "3.1"->{
    Cell[22881, 853, 69, 1, 70, "Subsection",
      CellTags->{"S2.6.3", "3.1"}]},
  "3.2"->{
    Cell[22953, 856, 356, 12, 70, "Text",
      CellTags->{"S2.6.3", "3.2"}]},
  "3.3"->{
    Cell[23312, 870, 491, 11, 70, "Text",
      CellTags->{"S2.6.3", "3.3"}]},
  "3.4"->{
    Cell[23806, 883, 177, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.4"}]},
  "3.5"->{
    Cell[24075, 896, 207, 6, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.5"}]},
  "3.6"->{
    Cell[24493, 916, 331, 7, 70, "Text",
      CellTags->{"S2.6.3", "3.6"}]},
  "3.7"->{
    Cell[24827, 925, 162, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.7"}]},
  "3.8"->{
    Cell[25076, 936, 194, 6, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.8"}]},
  "3.9"->{
    Cell[28434, 1052, 139, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.9"}]},
  "3.10"->{
    Cell[28780, 1071, 160, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.10"}]},
  "3.11"->{
    Cell[35365, 1289, 163, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.11"}]},
  "3.12"->{
    Cell[35807, 1309, 548, 12, 70, "Text",
      CellTags->{"S2.6.3", "3.12"}]},
  "3.13"->{
    Cell[36358, 1323, 174, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.13"}]},
  "3.14"->{
    Cell[36760, 1344, 143, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.14"}]},
  "3.15"->{
    Cell[36999, 1355, 172, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.15"}]},
  "3.16"->{
    Cell[37403, 1374, 661, 16, 70, "Text",
      CellTags->{"S2.6.3", "3.16"}]},
  "3.17"->{
    Cell[38067, 1392, 917, 27, 70, "Text",
      CellTags->{"S2.6.3", "3.17"}]},
  "3.18"->{
    Cell[38987, 1421, 140, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.18"}]},
  "3.19"->{
    Cell[39335, 1440, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.19"}]},
  "3.20"->{
    Cell[39726, 1461, 142, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.20"}]},
  "3.21"->{
    Cell[40206, 1485, 564, 14, 70, "Text",
      CellTags->{"S2.6.3", "3.21"}]},
  "3.22"->{
    Cell[40773, 1501, 173, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.22"}]},
  "3.23"->{
    Cell[41599, 1536, 172, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.23"}]},
  "3.24"->{
    Cell[41873, 1549, 147, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.24"}]},
  "3.25"->{
    Cell[42470, 1577, 743, 22, 70, "Text",
      CellTags->{"S2.6.3", "3.25"}]},
  "3.26"->{
    Cell[44131, 1632, 208, 7, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.26"}]},
  "3.27"->{
    Cell[44421, 1645, 128, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.27"}]},
  "3.28"->{
    Cell[44769, 1664, 470, 8, 70, "Text",
      CellTags->{"S2.6.3", "3.28"}]},
  "3.29"->{
    Cell[45242, 1674, 249, 8, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.29"}]},
  "3.30"->{
    Cell[47483, 1756, 304, 8, 70, "Text",
      CellTags->{"S2.6.3", "3.30"}]},
  "3.31"->{
    Cell[49091, 1808, 147, 5, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.31"}]},
  "3.32"->{
    Cell[49471, 1827, 242, 8, 70, "MathCaption",
      CellTags->{"S2.6.3", "3.32"}]},
  "S2.6.4"->{
    Cell[49998, 1852, 92, 1, 70, "Subsection",
      CellTags->{"S2.6.4", "4.1"}],
    Cell[50093, 1855, 542, 11, 70, "Text",
      CellTags->{"S2.6.4", "4.2"}],
    Cell[50638, 1868, 357, 7, 70, "Text",
      CellTags->{"S2.6.4", "4.3"}],
    Cell[50998, 1877, 236, 8, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.4"}],
    Cell[51259, 1889, 94, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[51356, 1893, 56, 2, 70, "Print",
      CellTags->"S2.6.4"],
    Cell[51415, 1897, 56, 2, 70, "Print",
      CellTags->"S2.6.4"],
    Cell[51474, 1901, 56, 2, 70, "Print",
      CellTags->"S2.6.4"],
    Cell[51533, 1905, 99, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[51647, 1911, 165, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.5"}],
    Cell[51837, 1922, 73, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[51913, 1926, 85, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[52013, 1932, 185, 6, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.6"}],
    Cell[52223, 1942, 79, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[52305, 1946, 90, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[52410, 1952, 529, 14, 70, "Text",
      CellTags->{"S2.6.4", "4.7"}],
    Cell[52942, 1968, 392, 9, 70, "Text",
      CellTags->{"S2.6.4", "4.8"}],
    Cell[53337, 1979, 328, 8, 70, "Text",
      CellTags->{"S2.6.4", "4.9"}],
    Cell[53668, 1989, 1011, 38, 70, "FramedBox",
      CellTags->"S2.6.4"],
    Cell[54682, 2029, 76, 1, 70, "Caption",
      CellTags->"S2.6.4"],
    Cell[54761, 2032, 507, 13, 70, "Text",
      CellTags->{"S2.6.4", "4.10"}],
    Cell[55271, 2047, 270, 10, 70, "Text",
      CellTags->{"S2.6.4", "4.11"}],
    Cell[55544, 2059, 3990, 128, 70, "DefinitionBox",
      CellTags->"S2.6.4"],
    Cell[59537, 2189, 132, 5, 70, "Caption",
      CellTags->"S2.6.4"],
    Cell[59672, 2196, 715, 18, 70, "Text",
      CellTags->{"S2.6.4", "4.12"}],
    Cell[60390, 2216, 145, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.13"}],
    Cell[60560, 2227, 69, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[60632, 2231, 82, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[60729, 2237, 167, 4, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.14"}],
    Cell[60921, 2245, 86, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[61010, 2249, 935, 32, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[61960, 2284, 518, 13, 70, "Text",
      CellTags->{"S2.6.4", "4.15"}],
    Cell[62481, 2299, 178, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.16"}],
    Cell[62684, 2308, 73, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[62760, 2312, 89, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[62864, 2318, 196, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.17"}],
    Cell[63063, 2325, 101, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[63167, 2329, 114, 2, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.18"}],
    Cell[63306, 2335, 73, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[63382, 2339, 96, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[63493, 2345, 363, 10, 70, "Text",
      CellTags->{"S2.6.4", "4.19"}],
    Cell[63859, 2357, 593, 21, 70, "Text",
      CellTags->{"S2.6.4", "4.20"}],
    Cell[64455, 2380, 441, 8, 70, "Text",
      CellTags->{"S2.6.4", "4.21"}],
    Cell[64899, 2390, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.22"}],
    Cell[65088, 2399, 88, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[65179, 2403, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.23"}],
    Cell[65368, 2412, 89, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[65460, 2416, 198, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.24"}],
    Cell[65683, 2427, 72, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[65758, 2431, 90, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[65863, 2437, 202, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.25"}],
    Cell[66090, 2448, 83, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[66176, 2452, 90, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[66281, 2458, 708, 20, 70, "FramedBox",
      CellTags->"S2.6.4"],
    Cell[66992, 2480, 85, 1, 70, "Caption",
      CellTags->"S2.6.4"],
    Cell[67080, 2483, 484, 12, 70, "Text",
      CellTags->{"S2.6.4", "4.26"}],
    Cell[67567, 2497, 329, 11, 70, "Text",
      CellTags->{"S2.6.4", "4.27"}],
    Cell[67899, 2510, 459, 11, 70, "Notes",
      CellTags->{"S2.6.4", "4.28"}],
    Cell[68361, 2523, 655, 11, 70, "Text",
      CellTags->{"S2.6.4", "4.29"}],
    Cell[69019, 2536, 243, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.30"}],
    Cell[69265, 2545, 102, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[69370, 2549, 161, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.31"}],
    Cell[69534, 2556, 105, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[69642, 2560, 193, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.32"}],
    Cell[69860, 2571, 81, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[69944, 2575, 93, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[70052, 2581, 200, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.33"}],
    Cell[70277, 2592, 81, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[70361, 2596, 98, 3, 70, "Output",
      CellTags->"S2.6.4"],
    Cell[70474, 2602, 695, 13, 70, "Text",
      CellTags->{"S2.6.4", "4.34"}],
    Cell[71172, 2617, 176, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.35"}],
    Cell[71351, 2626, 106, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[71460, 2630, 130, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.36"}],
    Cell[71593, 2637, 106, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[71702, 2641, 188, 6, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.37"}],
    Cell[71915, 2651, 95, 2, 70, "Input",
      CellTags->"S2.6.4"],
    Cell[72013, 2655, 112, 3, 70, "Output",
      CellTags->"S2.6.4"]},
  "4.1"->{
    Cell[49998, 1852, 92, 1, 70, "Subsection",
      CellTags->{"S2.6.4", "4.1"}]},
  "4.2"->{
    Cell[50093, 1855, 542, 11, 70, "Text",
      CellTags->{"S2.6.4", "4.2"}]},
  "4.3"->{
    Cell[50638, 1868, 357, 7, 70, "Text",
      CellTags->{"S2.6.4", "4.3"}]},
  "4.4"->{
    Cell[50998, 1877, 236, 8, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.4"}]},
  "4.5"->{
    Cell[51647, 1911, 165, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.5"}]},
  "4.6"->{
    Cell[52013, 1932, 185, 6, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.6"}]},
  "4.7"->{
    Cell[52410, 1952, 529, 14, 70, "Text",
      CellTags->{"S2.6.4", "4.7"}]},
  "4.8"->{
    Cell[52942, 1968, 392, 9, 70, "Text",
      CellTags->{"S2.6.4", "4.8"}]},
  "4.9"->{
    Cell[53337, 1979, 328, 8, 70, "Text",
      CellTags->{"S2.6.4", "4.9"}]},
  "4.10"->{
    Cell[54761, 2032, 507, 13, 70, "Text",
      CellTags->{"S2.6.4", "4.10"}]},
  "4.11"->{
    Cell[55271, 2047, 270, 10, 70, "Text",
      CellTags->{"S2.6.4", "4.11"}]},
  "4.12"->{
    Cell[59672, 2196, 715, 18, 70, "Text",
      CellTags->{"S2.6.4", "4.12"}]},
  "4.13"->{
    Cell[60390, 2216, 145, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.13"}]},
  "4.14"->{
    Cell[60729, 2237, 167, 4, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.14"}]},
  "4.15"->{
    Cell[61960, 2284, 518, 13, 70, "Text",
      CellTags->{"S2.6.4", "4.15"}]},
  "4.16"->{
    Cell[62481, 2299, 178, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.16"}]},
  "4.17"->{
    Cell[62864, 2318, 196, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.17"}]},
  "4.18"->{
    Cell[63167, 2329, 114, 2, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.18"}]},
  "4.19"->{
    Cell[63493, 2345, 363, 10, 70, "Text",
      CellTags->{"S2.6.4", "4.19"}]},
  "4.20"->{
    Cell[63859, 2357, 593, 21, 70, "Text",
      CellTags->{"S2.6.4", "4.20"}]},
  "4.21"->{
    Cell[64455, 2380, 441, 8, 70, "Text",
      CellTags->{"S2.6.4", "4.21"}]},
  "4.22"->{
    Cell[64899, 2390, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.22"}]},
  "4.23"->{
    Cell[65179, 2403, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.23"}]},
  "4.24"->{
    Cell[65460, 2416, 198, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.24"}]},
  "4.25"->{
    Cell[65863, 2437, 202, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.25"}]},
  "4.26"->{
    Cell[67080, 2483, 484, 12, 70, "Text",
      CellTags->{"S2.6.4", "4.26"}]},
  "4.27"->{
    Cell[67567, 2497, 329, 11, 70, "Text",
      CellTags->{"S2.6.4", "4.27"}]},
  "4.28"->{
    Cell[67899, 2510, 459, 11, 70, "Notes",
      CellTags->{"S2.6.4", "4.28"}]},
  "4.29"->{
    Cell[68361, 2523, 655, 11, 70, "Text",
      CellTags->{"S2.6.4", "4.29"}]},
  "4.30"->{
    Cell[69019, 2536, 243, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.30"}]},
  "4.31"->{
    Cell[69370, 2549, 161, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.31"}]},
  "4.32"->{
    Cell[69642, 2560, 193, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.32"}]},
  "4.33"->{
    Cell[70052, 2581, 200, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.33"}]},
  "4.34"->{
    Cell[70474, 2602, 695, 13, 70, "Text",
      CellTags->{"S2.6.4", "4.34"}]},
  "4.35"->{
    Cell[71172, 2617, 176, 7, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.35"}]},
  "4.36"->{
    Cell[71460, 2630, 130, 5, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.36"}]},
  "4.37"->{
    Cell[71702, 2641, 188, 6, 70, "MathCaption",
      CellTags->{"S2.6.4", "4.37"}]},
  "S2.6.5"->{
    Cell[72174, 2664, 90, 1, 70, "Subsection",
      CellTags->{"S2.6.5", "5.1"}],
    Cell[72267, 2667, 531, 11, 70, "Text",
      CellTags->{"S2.6.5", "5.2"}],
    Cell[72801, 2680, 2594, 86, 70, "DefinitionBox",
      CellTags->"S2.6.5"],
    Cell[75398, 2768, 119, 4, 70, "Caption",
      CellTags->"S2.6.5"],
    Cell[75520, 2774, 851, 36, 70, "Text",
      CellTags->{"S2.6.5", "5.3"}],
    Cell[76374, 2812, 479, 13, 70, "Text",
      CellTags->{"S2.6.5", "5.4"}],
    Cell[76856, 2827, 648, 18, 70, "DefinitionBox",
      CellTags->"S2.6.5"],
    Cell[77507, 2847, 114, 4, 70, "Caption",
      CellTags->"S2.6.5"],
    Cell[77624, 2853, 147, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.5"}],
    Cell[77796, 2861, 79, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[77878, 2865, 88, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[77981, 2871, 187, 7, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.6"}],
    Cell[78171, 2880, 91, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[78265, 2884, 158, 5, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.7"}],
    Cell[78448, 2893, 79, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[78530, 2897, 92, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[78637, 2903, 169, 5, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.8"}],
    Cell[78831, 2912, 99, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[78933, 2916, 83, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[79031, 2922, 198, 7, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.9"}],
    Cell[79254, 2933, 79, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[79336, 2937, 117, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[79468, 2943, 396, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.10"}],
    Cell[79867, 2955, 224, 6, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.11"}],
    Cell[80116, 2965, 89, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[80208, 2969, 88, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[80311, 2975, 662, 19, 70, "DefinitionBox",
      CellTags->"S2.6.5"],
    Cell[80976, 2996, 87, 1, 70, "Caption",
      CellTags->"S2.6.5"],
    Cell[81066, 2999, 378, 8, 70, "Text",
      CellTags->{"S2.6.5", "5.12"}],
    Cell[81447, 3009, 855, 21, 70, "Text",
      CellTags->{"S2.6.5", "5.13"}],
    Cell[82305, 3032, 285, 9, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.14"}],
    Cell[82615, 3045, 121, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[82739, 3049, 9637, 641, 70, 9564, 638, "GraphicsData", 
    "PostScript", "Graphics",
      ImageCacheValid->False,
      CellTags->"S2.6.5"],
    Cell[92379, 3692, 177, 5, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[92571, 3700, 327, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.15"}],
    Cell[92901, 3712, 257, 9, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.16"}],
    Cell[93183, 3725, 69, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[93255, 3729, 82, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[93352, 3735, 386, 15, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.17"}],
    Cell[93763, 3754, 79, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[93845, 3758, 82, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[93942, 3764, 146, 6, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.18"}],
    Cell[94113, 3774, 66, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[94182, 3778, 83, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[94280, 3784, 464, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.19"}],
    Cell[94747, 3796, 470, 12, 70, "Text",
      CellTags->{"S2.6.5", "5.20"}],
    Cell[95220, 3810, 558, 19, 70, "Text",
      CellTags->{"S2.6.5", "5.21"}],
    Cell[95781, 3831, 144, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.22"}],
    Cell[95950, 3839, 76, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[96029, 3843, 93, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[96137, 3849, 222, 6, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.23"}],
    Cell[96384, 3859, 80, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[96467, 3863, 111, 4, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[96593, 3870, 131, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.24"}],
    Cell[96749, 3878, 76, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[96828, 3882, 254, 8, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[97097, 3893, 254, 9, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.25"}],
    Cell[97376, 3906, 79, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[97458, 3910, 83, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[97556, 3916, 2949, 92, 70, "DefinitionBox",
      CellTags->"S2.6.5"],
    Cell[100508, 4010, 89, 1, 70, "Caption",
      CellTags->"S2.6.5"],
    Cell[100600, 4013, 137, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.26"}],
    Cell[100762, 4021, 96, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[100861, 4025, 83, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[100959, 4031, 186, 5, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.27"}],
    Cell[101170, 4040, 102, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[101275, 4044, 93, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[101383, 4050, 314, 13, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.28"}],
    Cell[101722, 4067, 116, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[101841, 4071, 100, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[101956, 4077, 876, 29, 70, "DefinitionBox",
      CellTags->"S2.6.5"],
    Cell[102835, 4108, 86, 1, 70, "Caption",
      CellTags->"S2.6.5"],
    Cell[102924, 4111, 278, 14, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.29"}],
    Cell[103227, 4129, 78, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[103308, 4133, 83, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[103406, 4139, 248, 11, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.30"}],
    Cell[103679, 4154, 91, 2, 70, "Input",
      CellTags->"S2.6.5"],
    Cell[103773, 4158, 83, 3, 70, "Output",
      CellTags->"S2.6.5"],
    Cell[103871, 4164, 340, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.31"}],
    Cell[104214, 4176, 638, 18, 70, "DefinitionBox",
      CellTags->"S2.6.5"],
    Cell[104855, 4196, 96, 1, 70, "Caption",
      CellTags->"S2.6.5"],
    Cell[104954, 4199, 779, 20, 70, "Text",
      CellTags->{"S2.6.5", "5.32"}]},
  "5.1"->{
    Cell[72174, 2664, 90, 1, 70, "Subsection",
      CellTags->{"S2.6.5", "5.1"}]},
  "5.2"->{
    Cell[72267, 2667, 531, 11, 70, "Text",
      CellTags->{"S2.6.5", "5.2"}]},
  "5.3"->{
    Cell[75520, 2774, 851, 36, 70, "Text",
      CellTags->{"S2.6.5", "5.3"}]},
  "5.4"->{
    Cell[76374, 2812, 479, 13, 70, "Text",
      CellTags->{"S2.6.5", "5.4"}]},
  "5.5"->{
    Cell[77624, 2853, 147, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.5"}]},
  "5.6"->{
    Cell[77981, 2871, 187, 7, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.6"}]},
  "5.7"->{
    Cell[78265, 2884, 158, 5, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.7"}]},
  "5.8"->{
    Cell[78637, 2903, 169, 5, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.8"}]},
  "5.9"->{
    Cell[79031, 2922, 198, 7, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.9"}]},
  "5.10"->{
    Cell[79468, 2943, 396, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.10"}]},
  "5.11"->{
    Cell[79867, 2955, 224, 6, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.11"}]},
  "5.12"->{
    Cell[81066, 2999, 378, 8, 70, "Text",
      CellTags->{"S2.6.5", "5.12"}]},
  "5.13"->{
    Cell[81447, 3009, 855, 21, 70, "Text",
      CellTags->{"S2.6.5", "5.13"}]},
  "5.14"->{
    Cell[82305, 3032, 285, 9, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.14"}]},
  "5.15"->{
    Cell[92571, 3700, 327, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.15"}]},
  "5.16"->{
    Cell[92901, 3712, 257, 9, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.16"}]},
  "5.17"->{
    Cell[93352, 3735, 386, 15, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.17"}]},
  "5.18"->{
    Cell[93942, 3764, 146, 6, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.18"}]},
  "5.19"->{
    Cell[94280, 3784, 464, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.19"}]},
  "5.20"->{
    Cell[94747, 3796, 470, 12, 70, "Text",
      CellTags->{"S2.6.5", "5.20"}]},
  "5.21"->{
    Cell[95220, 3810, 558, 19, 70, "Text",
      CellTags->{"S2.6.5", "5.21"}]},
  "5.22"->{
    Cell[95781, 3831, 144, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.22"}]},
  "5.23"->{
    Cell[96137, 3849, 222, 6, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.23"}]},
  "5.24"->{
    Cell[96593, 3870, 131, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.24"}]},
  "5.25"->{
    Cell[97097, 3893, 254, 9, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.25"}]},
  "5.26"->{
    Cell[100600, 4013, 137, 4, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.26"}]},
  "5.27"->{
    Cell[100959, 4031, 186, 5, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.27"}]},
  "5.28"->{
    Cell[101383, 4050, 314, 13, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.28"}]},
  "5.29"->{
    Cell[102924, 4111, 278, 14, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.29"}]},
  "5.30"->{
    Cell[103406, 4139, 248, 11, 70, "MathCaption",
      CellTags->{"S2.6.5", "5.30"}]},
  "5.31"->{
    Cell[103871, 4164, 340, 10, 70, "Text",
      CellTags->{"S2.6.5", "5.31"}]},
  "5.32"->{
    Cell[104954, 4199, 779, 20, 70, "Text",
      CellTags->{"S2.6.5", "5.32"}]},
  "S2.6.6"->{
    Cell[105770, 4224, 104, 1, 70, "Subsection",
      CellTags->{"S2.6.6", "6.1"}],
    Cell[105877, 4227, 456, 9, 70, "Text",
      CellTags->{"S2.6.6", "6.2"}],
    Cell[106336, 4238, 147, 4, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.3"}],
    Cell[106508, 4246, 95, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[106606, 4250, 85, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[106706, 4256, 205, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.4"}],
    Cell[106936, 4265, 115, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[107054, 4269, 93, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[107162, 4275, 600, 15, 70, "Text",
      CellTags->{"S2.6.6", "6.5"}],
    Cell[107765, 4292, 608, 18, 70, "DefinitionBox",
      CellTags->"S2.6.6"],
    Cell[108376, 4312, 76, 1, 70, "Caption",
      CellTags->"S2.6.6"],
    Cell[108455, 4315, 239, 6, 70, "Text",
      CellTags->{"S2.6.6", "6.6"}],
    Cell[108697, 4323, 421, 18, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.7"}],
    Cell[109143, 4345, 105, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[109251, 4349, 91, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[109357, 4355, 289, 8, 70, "Text",
      CellTags->{"S2.6.6", "6.8"}],
    Cell[109649, 4365, 171, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.9"}],
    Cell[109823, 4372, 89, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[109915, 4376, 170, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.10"}],
    Cell[110110, 4385, 68, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[110181, 4389, 85, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[110281, 4395, 204, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.11"}],
    Cell[110510, 4406, 69, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[110582, 4410, 86, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[110683, 4416, 205, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.12"}],
    Cell[110913, 4427, 103, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[111019, 4431, 87, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[111121, 4437, 717, 26, 70, "Text",
      CellTags->{"S2.6.6", "6.13"}],
    Cell[111841, 4465, 204, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.14"}],
    Cell[112070, 4476, 92, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[112165, 4480, 122, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[112302, 4486, 266, 8, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.15"}],
    Cell[112593, 4498, 83, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[112679, 4502, 113, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[112807, 4508, 985, 34, 70, "DefinitionBox",
      CellTags->"S2.6.6"],
    Cell[113795, 4544, 77, 1, 70, "Caption",
      CellTags->"S2.6.6"],
    Cell[113875, 4547, 679, 12, 70, "Text",
      CellTags->{"S2.6.6", "6.16"}],
    Cell[114557, 4561, 722, 27, 70, "Text",
      CellTags->{"S2.6.6", "6.17"}],
    Cell[115282, 4590, 146, 4, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.18"}],
    Cell[115453, 4598, 73, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[115529, 4602, 86, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[115630, 4608, 82, 1, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.19"}],
    Cell[115737, 4613, 73, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[115813, 4617, 86, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[115914, 4623, 299, 12, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.20"}],
    Cell[116238, 4639, 83, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[116324, 4643, 86, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[116425, 4649, 152, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.21"}],
    Cell[116602, 4660, 69, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[116674, 4664, 86, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[116775, 4670, 453, 12, 70, "Text",
      CellTags->{"S2.6.6", "6.22"}],
    Cell[117231, 4684, 244, 11, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.23"}],
    Cell[117500, 4699, 77, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[117580, 4703, 83, 3, 70, "Output",
      CellTags->"S2.6.6"],
    Cell[117678, 4709, 135, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.24"}],
    Cell[117838, 4718, 67, 2, 70, "Input",
      CellTags->"S2.6.6"],
    Cell[117908, 4722, 65, 2, 70, "Print",
      CellTags->"S2.6.6"],
    Cell[117976, 4726, 408, 13, 70, "Print",
      CellTags->"S2.6.6"],
    Cell[118399, 4742, 885, 18, 70, "Text",
      CellTags->{"S2.6.6", "6.25"}],
    Cell[119287, 4762, 2449, 79, 70, "DefinitionBox",
      CellTags->"S2.6.6"],
    Cell[121739, 4843, 68, 1, 70, "Caption",
      CellTags->"S2.6.6"],
    Cell[121810, 4846, 406, 8, 70, "Text",
      CellTags->{"S2.6.6", "6.26"}]},
  "6.1"->{
    Cell[105770, 4224, 104, 1, 70, "Subsection",
      CellTags->{"S2.6.6", "6.1"}]},
  "6.2"->{
    Cell[105877, 4227, 456, 9, 70, "Text",
      CellTags->{"S2.6.6", "6.2"}]},
  "6.3"->{
    Cell[106336, 4238, 147, 4, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.3"}]},
  "6.4"->{
    Cell[106706, 4256, 205, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.4"}]},
  "6.5"->{
    Cell[107162, 4275, 600, 15, 70, "Text",
      CellTags->{"S2.6.6", "6.5"}]},
  "6.6"->{
    Cell[108455, 4315, 239, 6, 70, "Text",
      CellTags->{"S2.6.6", "6.6"}]},
  "6.7"->{
    Cell[108697, 4323, 421, 18, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.7"}]},
  "6.8"->{
    Cell[109357, 4355, 289, 8, 70, "Text",
      CellTags->{"S2.6.6", "6.8"}]},
  "6.9"->{
    Cell[109649, 4365, 171, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.9"}]},
  "6.10"->{
    Cell[109915, 4376, 170, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.10"}]},
  "6.11"->{
    Cell[110281, 4395, 204, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.11"}]},
  "6.12"->{
    Cell[110683, 4416, 205, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.12"}]},
  "6.13"->{
    Cell[111121, 4437, 717, 26, 70, "Text",
      CellTags->{"S2.6.6", "6.13"}]},
  "6.14"->{
    Cell[111841, 4465, 204, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.14"}]},
  "6.15"->{
    Cell[112302, 4486, 266, 8, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.15"}]},
  "6.16"->{
    Cell[113875, 4547, 679, 12, 70, "Text",
      CellTags->{"S2.6.6", "6.16"}]},
  "6.17"->{
    Cell[114557, 4561, 722, 27, 70, "Text",
      CellTags->{"S2.6.6", "6.17"}]},
  "6.18"->{
    Cell[115282, 4590, 146, 4, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.18"}]},
  "6.19"->{
    Cell[115630, 4608, 82, 1, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.19"}]},
  "6.20"->{
    Cell[115914, 4623, 299, 12, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.20"}]},
  "6.21"->{
    Cell[116425, 4649, 152, 7, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.21"}]},
  "6.22"->{
    Cell[116775, 4670, 453, 12, 70, "Text",
      CellTags->{"S2.6.6", "6.22"}]},
  "6.23"->{
    Cell[117231, 4684, 244, 11, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.23"}]},
  "6.24"->{
    Cell[117678, 4709, 135, 5, 70, "MathCaption",
      CellTags->{"S2.6.6", "6.24"}]},
  "6.25"->{
    Cell[118399, 4742, 885, 18, 70, "Text",
      CellTags->{"S2.6.6", "6.25"}]},
  "6.26"->{
    Cell[121810, 4846, 406, 8, 70, "Text",
      CellTags->{"S2.6.6", "6.26"}]},
  "S2.6.7"->{
    Cell[122253, 4859, 92, 1, 70, "Subsection",
      CellTags->{"S2.6.7", "7.1"}],
    Cell[122348, 4862, 359, 13, 70, "Text",
      CellTags->{"S2.6.7", "7.2"}],
    Cell[122710, 4877, 895, 29, 70, "Text",
      CellTags->{"S2.6.7", "7.3"}],
    Cell[123608, 4908, 244, 8, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.4"}],
    Cell[123877, 4920, 85, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[123965, 4924, 173, 4, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[124153, 4931, 255, 9, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.5"}],
    Cell[124433, 4944, 97, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[124533, 4948, 172, 4, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[124720, 4955, 645, 23, 70, "Text",
      CellTags->{"S2.6.7", "7.6"}],
    Cell[125368, 4980, 302, 8, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.7"}],
    Cell[125673, 4990, 101, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[125777, 4994, 220, 7, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.8"}],
    Cell[126022, 5005, 85, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[126110, 5009, 99, 3, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[126224, 5015, 233, 9, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.9"}],
    Cell[126482, 5028, 95, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[126580, 5032, 106, 3, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[126701, 5038, 821, 34, 70, "Text",
      CellTags->{"S2.6.7", "7.10"}],
    Cell[127525, 5074, 193, 7, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.11"}],
    Cell[127743, 5085, 95, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[127841, 5089, 121, 3, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[127977, 5095, 189, 6, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.12"}],
    Cell[128191, 5105, 80, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[128274, 5109, 103, 3, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[128392, 5115, 263, 9, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.13"}],
    Cell[128680, 5128, 105, 2, 70, "Input",
      CellTags->"S2.6.7"],
    Cell[128788, 5132, 121, 3, 70, "Output",
      CellTags->"S2.6.7"],
    Cell[128924, 5138, 1399, 44, 70, "DefinitionBox",
      CellTags->"S2.6.7"],
    Cell[130326, 5184, 76, 1, 70, "Caption",
      CellTags->"S2.6.7"],
    Cell[130405, 5187, 430, 11, 70, "Text",
      CellTags->{"S2.6.7", "7.14"}]},
  "7.1"->{
    Cell[122253, 4859, 92, 1, 70, "Subsection",
      CellTags->{"S2.6.7", "7.1"}]},
  "7.2"->{
    Cell[122348, 4862, 359, 13, 70, "Text",
      CellTags->{"S2.6.7", "7.2"}]},
  "7.3"->{
    Cell[122710, 4877, 895, 29, 70, "Text",
      CellTags->{"S2.6.7", "7.3"}]},
  "7.4"->{
    Cell[123608, 4908, 244, 8, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.4"}]},
  "7.5"->{
    Cell[124153, 4931, 255, 9, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.5"}]},
  "7.6"->{
    Cell[124720, 4955, 645, 23, 70, "Text",
      CellTags->{"S2.6.7", "7.6"}]},
  "7.7"->{
    Cell[125368, 4980, 302, 8, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.7"}]},
  "7.8"->{
    Cell[125777, 4994, 220, 7, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.8"}]},
  "7.9"->{
    Cell[126224, 5015, 233, 9, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.9"}]},
  "7.10"->{
    Cell[126701, 5038, 821, 34, 70, "Text",
      CellTags->{"S2.6.7", "7.10"}]},
  "7.11"->{
    Cell[127525, 5074, 193, 7, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.11"}]},
  "7.12"->{
    Cell[127977, 5095, 189, 6, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.12"}]},
  "7.13"->{
    Cell[128392, 5115, 263, 9, 70, "MathCaption",
      CellTags->{"S2.6.7", "7.13"}]},
  "7.14"->{
    Cell[130405, 5187, 430, 11, 70, "Text",
      CellTags->{"S2.6.7", "7.14"}]},
  "S2.6.8"->{
    Cell[130872, 5203, 71, 1, 70, "Subsection",
      CellTags->{"S2.6.8", "8.1"}],
    Cell[130946, 5206, 268, 7, 70, "Text",
      CellTags->{"S2.6.8", "8.2"}],
    Cell[131217, 5215, 6984, 209, 70, "DefinitionBox",
      CellTags->"S2.6.8"],
    Cell[138204, 5426, 65, 1, 70, "Caption",
      CellTags->"S2.6.8"],
    Cell[138272, 5429, 261, 9, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.3"}],
    Cell[138558, 5442, 79, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[138640, 5446, 82, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[138737, 5452, 197, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.4"}],
    Cell[138959, 5461, 93, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[139055, 5465, 56, 2, 70, "Print",
      CellTags->"S2.6.8"],
    Cell[139126, 5470, 526, 12, 70, "Text",
      CellTags->{"S2.6.8", "8.5"}],
    Cell[139655, 5484, 282, 13, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.6"}],
    Cell[139940, 5499, 89, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[140032, 5503, 172, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.7"}],
    Cell[140207, 5510, 83, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[140293, 5514, 102, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.8"}],
    Cell[140398, 5517, 85, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[140486, 5521, 154, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.9"}],
    Cell[140665, 5530, 66, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[140734, 5534, 65, 2, 70, "Print",
      CellTags->"S2.6.8"],
    Cell[140802, 5538, 501, 15, 70, "Print",
      CellTags->"S2.6.8"],
    Cell[141318, 5556, 449, 14, 70, "Text",
      CellTags->{"S2.6.8", "8.10"}],
    Cell[141770, 5572, 201, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.11"}],
    Cell[141974, 5579, 111, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[142088, 5583, 138, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.12"}],
    Cell[142251, 5592, 69, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[142323, 5596, 83, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[142421, 5602, 81, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.13"}],
    Cell[142527, 5607, 68, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[142598, 5611, 82, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[142695, 5617, 178, 6, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.14"}],
    Cell[142876, 5625, 109, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[142988, 5629, 237, 10, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.15"}],
    Cell[143250, 5643, 69, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[143322, 5647, 83, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[143420, 5653, 223, 10, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.16"}],
    Cell[143668, 5667, 93, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[143764, 5671, 83, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[143862, 5677, 602, 23, 70, "Text",
      CellTags->{"S2.6.8", "8.17"}],
    Cell[144467, 5702, 255, 9, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.18"}],
    Cell[144747, 5715, 81, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[144831, 5719, 104, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[144950, 5725, 256, 9, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.19"}],
    Cell[145231, 5738, 84, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[145318, 5742, 83, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[145416, 5748, 3639, 116, 70, "DefinitionBox",
      CellTags->"S2.6.8"],
    Cell[149058, 5866, 89, 1, 70, "Caption",
      CellTags->"S2.6.8"],
    Cell[149150, 5869, 141, 4, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.20"}],
    Cell[149316, 5877, 71, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[149390, 5881, 94, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[149499, 5887, 339, 15, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.21"}],
    Cell[149863, 5906, 78, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[149944, 5910, 87, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[150046, 5916, 228, 8, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.22"}],
    Cell[150299, 5928, 72, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[150374, 5932, 87, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[150476, 5938, 1031, 38, 70, "Text",
      CellTags->{"S2.6.8", "8.23"}],
    Cell[151510, 5978, 153, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.24"}],
    Cell[151688, 5987, 90, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[151781, 5991, 87, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[151883, 5997, 143, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.25"}],
    Cell[152051, 6006, 89, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[152143, 6010, 101, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[152259, 6016, 1438, 58, 70, "Text",
      CellTags->{"S2.6.8", "8.26"}],
    Cell[153700, 6076, 2703, 78, 70, "DefinitionBox",
      CellTags->"S2.6.8"],
    Cell[156406, 6156, 76, 1, 70, "Caption",
      CellTags->"S2.6.8"],
    Cell[156485, 6159, 106, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.27"}],
    Cell[156594, 6162, 93, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[156690, 6166, 86, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.28"}],
    Cell[156801, 6171, 69, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[156873, 6175, 86, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[156974, 6181, 258, 7, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.29"}],
    Cell[157257, 6192, 69, 2, 70, "Input",
      CellTags->"S2.6.8"],
    Cell[157329, 6196, 87, 3, 70, "Output",
      CellTags->"S2.6.8"],
    Cell[157431, 6202, 432, 10, 70, "Text",
      CellTags->{"S2.6.8", "8.30"}]},
  "8.1"->{
    Cell[130872, 5203, 71, 1, 70, "Subsection",
      CellTags->{"S2.6.8", "8.1"}]},
  "8.2"->{
    Cell[130946, 5206, 268, 7, 70, "Text",
      CellTags->{"S2.6.8", "8.2"}]},
  "8.3"->{
    Cell[138272, 5429, 261, 9, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.3"}]},
  "8.4"->{
    Cell[138737, 5452, 197, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.4"}]},
  "8.5"->{
    Cell[139126, 5470, 526, 12, 70, "Text",
      CellTags->{"S2.6.8", "8.5"}]},
  "8.6"->{
    Cell[139655, 5484, 282, 13, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.6"}]},
  "8.7"->{
    Cell[140032, 5503, 172, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.7"}]},
  "8.8"->{
    Cell[140293, 5514, 102, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.8"}]},
  "8.9"->{
    Cell[140486, 5521, 154, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.9"}]},
  "8.10"->{
    Cell[141318, 5556, 449, 14, 70, "Text",
      CellTags->{"S2.6.8", "8.10"}]},
  "8.11"->{
    Cell[141770, 5572, 201, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.11"}]},
  "8.12"->{
    Cell[142088, 5583, 138, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.12"}]},
  "8.13"->{
    Cell[142421, 5602, 81, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.13"}]},
  "8.14"->{
    Cell[142695, 5617, 178, 6, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.14"}]},
  "8.15"->{
    Cell[142988, 5629, 237, 10, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.15"}]},
  "8.16"->{
    Cell[143420, 5653, 223, 10, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.16"}]},
  "8.17"->{
    Cell[143862, 5677, 602, 23, 70, "Text",
      CellTags->{"S2.6.8", "8.17"}]},
  "8.18"->{
    Cell[144467, 5702, 255, 9, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.18"}]},
  "8.19"->{
    Cell[144950, 5725, 256, 9, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.19"}]},
  "8.20"->{
    Cell[149150, 5869, 141, 4, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.20"}]},
  "8.21"->{
    Cell[149499, 5887, 339, 15, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.21"}]},
  "8.22"->{
    Cell[150046, 5916, 228, 8, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.22"}]},
  "8.23"->{
    Cell[150476, 5938, 1031, 38, 70, "Text",
      CellTags->{"S2.6.8", "8.23"}]},
  "8.24"->{
    Cell[151510, 5978, 153, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.24"}]},
  "8.25"->{
    Cell[151883, 5997, 143, 5, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.25"}]},
  "8.26"->{
    Cell[152259, 6016, 1438, 58, 70, "Text",
      CellTags->{"S2.6.8", "8.26"}]},
  "8.27"->{
    Cell[156485, 6159, 106, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.27"}]},
  "8.28"->{
    Cell[156690, 6166, 86, 1, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.28"}]},
  "8.29"->{
    Cell[156974, 6181, 258, 7, 70, "MathCaption",
      CellTags->{"S2.6.8", "8.29"}]},
  "8.30"->{
    Cell[157431, 6202, 432, 10, 70, "Text",
      CellTags->{"S2.6.8", "8.30"}]},
  "S2.6.9"->{
    Cell[157900, 6217, 87, 1, 70, "Subsection",
      CellTags->{"S2.6.9", "9.1"}],
    Cell[157990, 6220, 480, 10, 70, "Text",
      CellTags->{"S2.6.9", "9.2"}],
    Cell[158473, 6232, 2394, 78, 70, "DefinitionBox",
      CellTags->"S2.6.9"],
    Cell[160870, 6312, 68, 1, 70, "Caption",
      CellTags->"S2.6.9"],
    Cell[160941, 6315, 237, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.3"}],
    Cell[161203, 6330, 86, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[161292, 6334, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[161351, 6338, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[161410, 6342, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[161469, 6346, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[161541, 6351, 296, 13, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.4"}],
    Cell[161862, 6368, 107, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[161972, 6372, 118, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[162105, 6378, 390, 12, 70, "Text",
      CellTags->{"S2.6.9", "9.5"}],
    Cell[162498, 6392, 360, 17, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.6"}],
    Cell[162883, 6413, 98, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[162984, 6417, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[163048, 6421, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[163112, 6425, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[163176, 6429, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[163240, 6433, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[163304, 6437, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[163380, 6442, 361, 9, 70, "Text",
      CellTags->{"S2.6.9", "9.7"}],
    Cell[163744, 6453, 207, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.8"}],
    Cell[163976, 6466, 94, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[164073, 6470, 115, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[164203, 6476, 133, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.9"}],
    Cell[164361, 6485, 105, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[164469, 6489, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[164529, 6493, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[164589, 6497, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[164661, 6502, 2001, 63, 70, "DefinitionBox",
      CellTags->"S2.6.9"],
    Cell[166665, 6567, 74, 1, 70, "Caption",
      CellTags->"S2.6.9"],
    Cell[166742, 6570, 712, 22, 70, "Text",
      CellTags->{"S2.6.9", "9.10"}],
    Cell[167457, 6594, 125, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.11"}],
    Cell[167607, 6603, 77, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[167687, 6607, 91, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[167793, 6613, 190, 6, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.12"}],
    Cell[168008, 6623, 98, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[168109, 6627, 115, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[168239, 6633, 430, 13, 70, "Text",
      CellTags->{"S2.6.9", "9.13"}],
    Cell[168672, 6648, 168, 4, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.14"}],
    Cell[168865, 6656, 113, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[168981, 6660, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169041, 6664, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169101, 6668, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169161, 6672, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169220, 6676, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169279, 6680, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169338, 6684, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169397, 6688, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[169456, 6692, 82, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[169553, 6698, 566, 19, 70, "Text",
      CellTags->{"S2.6.9", "9.15"}],
    Cell[170122, 6719, 2215, 70, 70, "DefinitionBox",
      CellTags->"S2.6.9"],
    Cell[172340, 6791, 90, 3, 70, "Caption",
      CellTags->"S2.6.9"],
    Cell[172433, 6796, 280, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.16"}],
    Cell[172738, 6809, 113, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[172854, 6813, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[172913, 6817, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[172972, 6821, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[173031, 6825, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[173090, 6829, 82, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[173187, 6835, 506, 14, 70, "Text",
      CellTags->{"S2.6.9", "9.17"}],
    Cell[173696, 6851, 255, 8, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.18"}],
    Cell[173976, 6863, 90, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[174069, 6867, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174128, 6871, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174187, 6875, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174246, 6879, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174317, 6884, 313, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.19"}],
    Cell[174655, 6899, 124, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[174782, 6903, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174841, 6907, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174900, 6911, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[174959, 6915, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[175057, 6921, 302, 10, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.20"}],
    Cell[175384, 6935, 123, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[175510, 6939, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[175569, 6943, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[175628, 6947, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[175687, 6951, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[175785, 6957, 537, 12, 70, "Text",
      CellTags->{"S2.6.9", "9.21"}],
    Cell[176325, 6971, 129, 4, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.22"}],
    Cell[176479, 6979, 94, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[176576, 6983, 202, 4, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[176793, 6990, 171, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.23"}],
    Cell[176989, 6999, 103, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[177095, 7003, 202, 4, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[177312, 7010, 240, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.24"}],
    Cell[177577, 7021, 125, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[177705, 7025, 101, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[177821, 7031, 353, 11, 70, "Text",
      CellTags->{"S2.6.9", "9.25"}],
    Cell[178177, 7044, 312, 13, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.26"}],
    Cell[178514, 7061, 89, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[178606, 7065, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[178704, 7071, 184, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.27"}],
    Cell[178891, 7078, 105, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[178999, 7082, 127, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.28"}],
    Cell[179151, 7091, 78, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[179232, 7095, 84, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[179331, 7101, 243, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.29"}],
    Cell[179599, 7114, 79, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[179681, 7118, 90, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[179786, 7124, 997, 35, 70, "Text",
      CellTags->{"S2.6.9", "9.30"}],
    Cell[180786, 7161, 172, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.31"}],
    Cell[180983, 7172, 106, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[181092, 7176, 86, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[181193, 7182, 146, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.32"}],
    Cell[181364, 7191, 106, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[181473, 7195, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[181571, 7201, 182, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.33"}],
    Cell[181778, 7210, 92, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[181873, 7214, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[181971, 7220, 138, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.34"}],
    Cell[182134, 7229, 101, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[182238, 7233, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[182336, 7239, 223, 5, 70, "Text",
      CellTags->{"S2.6.9", "9.35"}],
    Cell[182562, 7246, 301, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.36"}],
    Cell[182888, 7259, 125, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[183016, 7263, 84, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[183115, 7269, 971, 43, 70, "Text",
      CellTags->{"S2.6.9", "9.37"}],
    Cell[184089, 7314, 180, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.38"}],
    Cell[184294, 7325, 93, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[184390, 7329, 89, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[184494, 7335, 166, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.39"}],
    Cell[184685, 7346, 81, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[184769, 7350, 83, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[184867, 7356, 1514, 48, 70, "DefinitionBox",
      CellTags->"S2.6.9"],
    Cell[186384, 7406, 66, 1, 70, "Caption",
      CellTags->"S2.6.9"],
    Cell[186453, 7409, 739, 22, 70, "Text",
      CellTags->{"S2.6.9", "9.40"}],
    Cell[187195, 7433, 151, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.41"}],
    Cell[187371, 7442, 111, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[187485, 7446, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[187544, 7450, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[187603, 7454, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[187662, 7458, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[187733, 7463, 562, 19, 70, "Text",
      CellTags->{"S2.6.9", "9.42"}],
    Cell[188298, 7484, 229, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.43"}],
    Cell[188552, 7497, 95, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[188650, 7501, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[188709, 7505, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[188768, 7509, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[188839, 7514, 288, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.44"}],
    Cell[189152, 7529, 116, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[189271, 7533, 63, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[189337, 7537, 76, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[189416, 7541, 89, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[189520, 7546, 524, 19, 70, "Text",
      CellTags->{"S2.6.9", "9.45"}],
    Cell[190047, 7567, 142, 4, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.46"}],
    Cell[190192, 7573, 87, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[190282, 7577, 504, 15, 70, "Text",
      CellTags->{"S2.6.9", "9.47"}],
    Cell[190789, 7594, 427, 8, 70, "Text",
      CellTags->{"S2.6.9", "9.48"}],
    Cell[191219, 7604, 502, 11, 70, "Text",
      CellTags->{"S2.6.9", "9.49"}],
    Cell[191724, 7617, 594, 14, 70, "Text",
      CellTags->{"S2.6.9", "9.50"}],
    Cell[192321, 7633, 1777, 52, 70, "DefinitionBox",
      CellTags->"S2.6.9"],
    Cell[194101, 7687, 65, 1, 70, "Caption",
      CellTags->"S2.6.9"],
    Cell[194169, 7690, 250, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.51"}],
    Cell[194444, 7705, 122, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[194569, 7709, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[194628, 7713, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[194687, 7717, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[194746, 7721, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[194818, 7726, 382, 19, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.52"}],
    Cell[195225, 7749, 142, 5, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[195370, 7756, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195429, 7760, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195488, 7764, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195547, 7768, 57, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195607, 7772, 58, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195668, 7776, 59, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195730, 7780, 59, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195792, 7784, 60, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195855, 7788, 61, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195919, 7792, 62, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[195996, 7797, 433, 11, 70, "Text",
      CellTags->{"S2.6.9", "9.53"}],
    Cell[196432, 7810, 255, 8, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.54"}],
    Cell[196690, 7820, 122, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[196815, 7824, 179, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.55"}],
    Cell[197019, 7833, 70, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[197092, 7837, 85, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[197192, 7843, 202, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.56"}],
    Cell[197397, 7850, 106, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[197506, 7854, 127, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.57"}],
    Cell[197658, 7863, 82, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[197743, 7867, 89, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[197847, 7873, 239, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.58"}],
    Cell[198111, 7886, 83, 2, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[198197, 7890, 87, 3, 70, "Output",
      CellTags->"S2.6.9"],
    Cell[198299, 7896, 676, 21, 70, "Text",
      CellTags->{"S2.6.9", "9.59"}],
    Cell[198978, 7919, 167, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.60"}],
    Cell[199170, 7930, 138, 5, 70, "Input",
      CellTags->"S2.6.9"],
    Cell[199311, 7937, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[199370, 7941, 56, 2, 70, "Print",
      CellTags->"S2.6.9"],
    Cell[199441, 7946, 541, 15, 70, "Text",
      CellTags->{"S2.6.9", "9.61"}]},
  "9.1"->{
    Cell[157900, 6217, 87, 1, 70, "Subsection",
      CellTags->{"S2.6.9", "9.1"}]},
  "9.2"->{
    Cell[157990, 6220, 480, 10, 70, "Text",
      CellTags->{"S2.6.9", "9.2"}]},
  "9.3"->{
    Cell[160941, 6315, 237, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.3"}]},
  "9.4"->{
    Cell[161541, 6351, 296, 13, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.4"}]},
  "9.5"->{
    Cell[162105, 6378, 390, 12, 70, "Text",
      CellTags->{"S2.6.9", "9.5"}]},
  "9.6"->{
    Cell[162498, 6392, 360, 17, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.6"}]},
  "9.7"->{
    Cell[163380, 6442, 361, 9, 70, "Text",
      CellTags->{"S2.6.9", "9.7"}]},
  "9.8"->{
    Cell[163744, 6453, 207, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.8"}]},
  "9.9"->{
    Cell[164203, 6476, 133, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.9"}]},
  "9.10"->{
    Cell[166742, 6570, 712, 22, 70, "Text",
      CellTags->{"S2.6.9", "9.10"}]},
  "9.11"->{
    Cell[167457, 6594, 125, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.11"}]},
  "9.12"->{
    Cell[167793, 6613, 190, 6, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.12"}]},
  "9.13"->{
    Cell[168239, 6633, 430, 13, 70, "Text",
      CellTags->{"S2.6.9", "9.13"}]},
  "9.14"->{
    Cell[168672, 6648, 168, 4, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.14"}]},
  "9.15"->{
    Cell[169553, 6698, 566, 19, 70, "Text",
      CellTags->{"S2.6.9", "9.15"}]},
  "9.16"->{
    Cell[172433, 6796, 280, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.16"}]},
  "9.17"->{
    Cell[173187, 6835, 506, 14, 70, "Text",
      CellTags->{"S2.6.9", "9.17"}]},
  "9.18"->{
    Cell[173696, 6851, 255, 8, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.18"}]},
  "9.19"->{
    Cell[174317, 6884, 313, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.19"}]},
  "9.20"->{
    Cell[175057, 6921, 302, 10, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.20"}]},
  "9.21"->{
    Cell[175785, 6957, 537, 12, 70, "Text",
      CellTags->{"S2.6.9", "9.21"}]},
  "9.22"->{
    Cell[176325, 6971, 129, 4, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.22"}]},
  "9.23"->{
    Cell[176793, 6990, 171, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.23"}]},
  "9.24"->{
    Cell[177312, 7010, 240, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.24"}]},
  "9.25"->{
    Cell[177821, 7031, 353, 11, 70, "Text",
      CellTags->{"S2.6.9", "9.25"}]},
  "9.26"->{
    Cell[178177, 7044, 312, 13, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.26"}]},
  "9.27"->{
    Cell[178704, 7071, 184, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.27"}]},
  "9.28"->{
    Cell[178999, 7082, 127, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.28"}]},
  "9.29"->{
    Cell[179331, 7101, 243, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.29"}]},
  "9.30"->{
    Cell[179786, 7124, 997, 35, 70, "Text",
      CellTags->{"S2.6.9", "9.30"}]},
  "9.31"->{
    Cell[180786, 7161, 172, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.31"}]},
  "9.32"->{
    Cell[181193, 7182, 146, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.32"}]},
  "9.33"->{
    Cell[181571, 7201, 182, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.33"}]},
  "9.34"->{
    Cell[181971, 7220, 138, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.34"}]},
  "9.35"->{
    Cell[182336, 7239, 223, 5, 70, "Text",
      CellTags->{"S2.6.9", "9.35"}]},
  "9.36"->{
    Cell[182562, 7246, 301, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.36"}]},
  "9.37"->{
    Cell[183115, 7269, 971, 43, 70, "Text",
      CellTags->{"S2.6.9", "9.37"}]},
  "9.38"->{
    Cell[184089, 7314, 180, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.38"}]},
  "9.39"->{
    Cell[184494, 7335, 166, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.39"}]},
  "9.40"->{
    Cell[186453, 7409, 739, 22, 70, "Text",
      CellTags->{"S2.6.9", "9.40"}]},
  "9.41"->{
    Cell[187195, 7433, 151, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.41"}]},
  "9.42"->{
    Cell[187733, 7463, 562, 19, 70, "Text",
      CellTags->{"S2.6.9", "9.42"}]},
  "9.43"->{
    Cell[188298, 7484, 229, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.43"}]},
  "9.44"->{
    Cell[188839, 7514, 288, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.44"}]},
  "9.45"->{
    Cell[189520, 7546, 524, 19, 70, "Text",
      CellTags->{"S2.6.9", "9.45"}]},
  "9.46"->{
    Cell[190047, 7567, 142, 4, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.46"}]},
  "9.47"->{
    Cell[190282, 7577, 504, 15, 70, "Text",
      CellTags->{"S2.6.9", "9.47"}]},
  "9.48"->{
    Cell[190789, 7594, 427, 8, 70, "Text",
      CellTags->{"S2.6.9", "9.48"}]},
  "9.49"->{
    Cell[191219, 7604, 502, 11, 70, "Text",
      CellTags->{"S2.6.9", "9.49"}]},
  "9.50"->{
    Cell[191724, 7617, 594, 14, 70, "Text",
      CellTags->{"S2.6.9", "9.50"}]},
  "9.51"->{
    Cell[194169, 7690, 250, 11, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.51"}]},
  "9.52"->{
    Cell[194818, 7726, 382, 19, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.52"}]},
  "9.53"->{
    Cell[195996, 7797, 433, 11, 70, "Text",
      CellTags->{"S2.6.9", "9.53"}]},
  "9.54"->{
    Cell[196432, 7810, 255, 8, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.54"}]},
  "9.55"->{
    Cell[196815, 7824, 179, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.55"}]},
  "9.56"->{
    Cell[197192, 7843, 202, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.56"}]},
  "9.57"->{
    Cell[197506, 7854, 127, 5, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.57"}]},
  "9.58"->{
    Cell[197847, 7873, 239, 9, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.58"}]},
  "9.59"->{
    Cell[198299, 7896, 676, 21, 70, "Text",
      CellTags->{"S2.6.9", "9.59"}]},
  "9.60"->{
    Cell[198978, 7919, 167, 7, 70, "MathCaption",
      CellTags->{"S2.6.9", "9.60"}]},
  "9.61"->{
    Cell[199441, 7946, 541, 15, 70, "Text",
      CellTags->{"S2.6.9", "9.61"}]},
  "S2.6.10"->{
    Cell[200019, 7966, 102, 1, 70, "Subsection",
      CellTags->{"S2.6.10", "10.1"}],
    Cell[200124, 7969, 378, 10, 70, "Text",
      CellTags->{"S2.6.10", "10.2"}],
    Cell[200505, 7981, 969, 30, 70, "DefinitionBox",
      CellTags->"S2.6.10"],
    Cell[201477, 8013, 134, 7, 70, "Caption",
      CellTags->"S2.6.10"],
    Cell[201614, 8022, 104, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.3"}],
    Cell[201743, 8027, 103, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[201849, 8031, 87, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[201951, 8037, 102, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.4"}],
    Cell[202078, 8042, 119, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[202200, 8046, 100, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[202315, 8052, 115, 2, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.5"}],
    Cell[202455, 8058, 119, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[202577, 8062, 110, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[202702, 8068, 251, 11, 70, "Text",
      CellTags->{"S2.6.10", "10.6"}],
    Cell[202956, 8081, 143, 5, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.7"}],
    Cell[203102, 8088, 110, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[203215, 8092, 110, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.8"}],
    Cell[203350, 8097, 87, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[203440, 8101, 204, 4, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[203659, 8108, 4270, 129, 70, "DefinitionBox",
      CellTags->"S2.6.10"],
    Cell[207932, 8239, 72, 1, 70, "Caption",
      CellTags->"S2.6.10"],
    Cell[208007, 8242, 158, 5, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.9"}],
    Cell[208190, 8251, 105, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[208298, 8255, 95, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[208408, 8261, 162, 7, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.10"}],
    Cell[208595, 8272, 110, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[208708, 8276, 98, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[208821, 8282, 136, 4, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.11"}],
    Cell[208982, 8290, 107, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[209092, 8294, 103, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[209210, 8300, 112, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.12"}],
    Cell[209347, 8305, 118, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[209468, 8309, 120, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[209603, 8315, 157, 5, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.13"}],
    Cell[209785, 8324, 114, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[209902, 8328, 116, 3, 70, "Output",
      CellTags->"S2.6.10"],
    Cell[210033, 8334, 98, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.14"}],
    Cell[210156, 8339, 111, 2, 70, "Input",
      CellTags->"S2.6.10"],
    Cell[210270, 8343, 135, 3, 70, "Output",
      CellTags->"S2.6.10"]},
  "10.1"->{
    Cell[200019, 7966, 102, 1, 70, "Subsection",
      CellTags->{"S2.6.10", "10.1"}]},
  "10.2"->{
    Cell[200124, 7969, 378, 10, 70, "Text",
      CellTags->{"S2.6.10", "10.2"}]},
  "10.3"->{
    Cell[201614, 8022, 104, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.3"}]},
  "10.4"->{
    Cell[201951, 8037, 102, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.4"}]},
  "10.5"->{
    Cell[202315, 8052, 115, 2, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.5"}]},
  "10.6"->{
    Cell[202702, 8068, 251, 11, 70, "Text",
      CellTags->{"S2.6.10", "10.6"}]},
  "10.7"->{
    Cell[202956, 8081, 143, 5, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.7"}]},
  "10.8"->{
    Cell[203215, 8092, 110, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.8"}]},
  "10.9"->{
    Cell[208007, 8242, 158, 5, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.9"}]},
  "10.10"->{
    Cell[208408, 8261, 162, 7, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.10"}]},
  "10.11"->{
    Cell[208821, 8282, 136, 4, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.11"}]},
  "10.12"->{
    Cell[209210, 8300, 112, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.12"}]},
  "10.13"->{
    Cell[209603, 8315, 157, 5, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.13"}]},
  "10.14"->{
    Cell[210033, 8334, 98, 1, 70, "MathCaption",
      CellTags->{"S2.6.10", "10.14"}]},
  "S2.6.11"->{
    Cell[210454, 8352, 96, 1, 70, "Subsection",
      CellTags->{"S2.6.11", "11.1"}],
    Cell[210553, 8355, 485, 11, 70, "Text",
      CellTags->{"S2.6.11", "11.2"}],
    Cell[211041, 8368, 988, 30, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[212032, 8400, 81, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[212116, 8403, 236, 11, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.3"}],
    Cell[212377, 8418, 77, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[212457, 8422, 208, 8, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[212680, 8433, 150, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.4"}],
    Cell[212855, 8442, 79, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[212937, 8446, 374, 14, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[213326, 8463, 135, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.5"}],
    Cell[213486, 8471, 85, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[213574, 8475, 545, 20, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[214134, 8498, 513, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.6"}],
    Cell[214650, 8514, 410, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.7"}],
    Cell[215063, 8530, 112, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.8"}],
    Cell[215200, 8535, 98, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[215301, 8539, 83, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[215399, 8545, 244, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.9"}],
    Cell[215668, 8556, 78, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[215749, 8560, 1213, 40, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[216977, 8603, 163, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.10"}],
    Cell[217165, 8612, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[217255, 8616, 373, 13, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[217643, 8632, 139, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.11"}],
    Cell[217807, 8641, 95, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[217905, 8645, 677, 22, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[218597, 8670, 421, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.12"}],
    Cell[219021, 8686, 483, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.13"}],
    Cell[219507, 8702, 772, 22, 70, "Text",
      CellTags->{"S2.6.11", "11.14"}],
    Cell[220282, 8726, 152, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.15"}],
    Cell[220459, 8735, 114, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[220576, 8739, 544, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[221135, 8760, 566, 16, 70, "Text",
      CellTags->{"S2.6.11", "11.16"}],
    Cell[221704, 8778, 88, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.17"}],
    Cell[221795, 8781, 105, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[221903, 8785, 168, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.18"}],
    Cell[222096, 8794, 82, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[222181, 8798, 545, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[222741, 8819, 570, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.19"}],
    Cell[223314, 8834, 1719, 55, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[225036, 8891, 110, 5, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[225149, 8898, 561, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.20"}],
    Cell[225713, 8913, 649, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.21"}],
    Cell[226365, 8929, 92, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.22"}],
    Cell[226482, 8934, 103, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[226588, 8938, 87, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[226690, 8944, 237, 8, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.23"}],
    Cell[226952, 8956, 77, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[227032, 8960, 317, 12, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[227364, 8975, 335, 13, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.24"}],
    Cell[227724, 8992, 82, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[227809, 8996, 279, 10, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[228103, 9009, 186, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.25"}],
    Cell[228314, 9018, 95, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[228412, 9022, 665, 24, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[229092, 9049, 143, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.26"}],
    Cell[229260, 9057, 82, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[229345, 9061, 508, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[229868, 9082, 135, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.27"}],
    Cell[230028, 9090, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[230118, 9094, 620, 20, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[230753, 9117, 599, 12, 70, "Text",
      CellTags->{"S2.6.11", "11.28"}],
    Cell[231355, 9131, 213, 8, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.29"}],
    Cell[231593, 9143, 91, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[231687, 9147, 633, 22, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[232335, 9172, 103, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.30"}],
    Cell[232441, 9175, 93, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[232537, 9179, 189, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.31"}],
    Cell[232751, 9188, 78, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[232832, 9192, 745, 24, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[233592, 9219, 425, 8, 70, "Text",
      CellTags->{"S2.6.11", "11.32"}],
    Cell[234020, 9229, 451, 19, 70, "Text",
      CellTags->{"S2.6.11", "11.33"}],
    Cell[234474, 9250, 183, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.34"}],
    Cell[234682, 9259, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[234772, 9263, 853, 26, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[235640, 9292, 291, 11, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.35"}],
    Cell[235934, 9305, 94, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[236031, 9309, 209, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.36"}],
    Cell[236265, 9319, 85, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[236353, 9323, 712, 26, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[237080, 9352, 118, 2, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.37"}],
    Cell[237201, 9356, 100, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[237304, 9360, 104, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.38"}],
    Cell[237433, 9365, 85, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[237521, 9369, 84, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[237620, 9375, 165, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.39"}],
    Cell[237810, 9384, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[237900, 9388, 1815, 54, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[239730, 9445, 1002, 28, 70, "Text",
      CellTags->{"S2.6.11", "11.40"}],
    Cell[240735, 9475, 486, 18, 70, "Text",
      CellTags->{"S2.6.11", "11.41"}],
    Cell[241224, 9495, 1248, 40, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[242475, 9537, 95, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[242573, 9540, 161, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.42"}],
    Cell[242759, 9549, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[242849, 9553, 374, 13, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[243238, 9569, 192, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.43"}],
    Cell[243455, 9579, 84, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[243542, 9583, 596, 20, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[244153, 9606, 138, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.44"}],
    Cell[244294, 9613, 95, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[244392, 9617, 306, 13, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.45"}],
    Cell[244723, 9634, 90, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[244816, 9638, 643, 20, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[245474, 9661, 1463, 46, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[246940, 9709, 86, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[247029, 9712, 490, 16, 70, "Text",
      CellTags->{"S2.6.11", "11.46"}],
    Cell[247522, 9730, 576, 21, 70, "Text",
      CellTags->{"S2.6.11", "11.47"}],
    Cell[248101, 9753, 97, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.48"}],
    Cell[248223, 9758, 86, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[248312, 9762, 1128, 34, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[249455, 9799, 170, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.49"}],
    Cell[249650, 9808, 102, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[249755, 9812, 820, 26, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[250590, 9841, 177, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.50"}],
    Cell[250792, 9850, 103, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[250898, 9854, 530, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[251443, 9875, 891, 27, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[252337, 9904, 113, 4, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[252453, 9910, 244, 9, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.51"}],
    Cell[252722, 9923, 93, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[252818, 9927, 1710, 54, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[254543, 9984, 784, 20, 70, "Text",
      CellTags->{"S2.6.11", "11.52"}],
    Cell[255330, 10006, 154, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.53"}],
    Cell[255509, 10014, 80, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[255592, 10018, 375, 14, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[255982, 10035, 176, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.54"}],
    Cell[256183, 10044, 93, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[256279, 10048, 151, 5, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[256445, 10056, 312, 8, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.55"}],
    Cell[256782, 10068, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[256872, 10072, 495, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[257382, 10093, 109, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.56"}],
    Cell[257516, 10098, 78, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[257597, 10102, 172, 5, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[257784, 10110, 234, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.57"}],
    Cell[258043, 10121, 97, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[258143, 10125, 486, 17, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[258644, 10145, 439, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.58"}],
    Cell[259086, 10161, 210, 6, 70, "Text",
      CellTags->{"S2.6.11", "11.59"}],
    Cell[259299, 10169, 195, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.60"}],
    Cell[259519, 10180, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[259609, 10184, 560, 19, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[260184, 10206, 224, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.61"}],
    Cell[260433, 10217, 87, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[260523, 10221, 318, 11, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[260856, 10235, 729, 22, 70, "Text",
      CellTags->{"S2.6.11", "11.62"}],
    Cell[261588, 10259, 142, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.63"}],
    Cell[261755, 10267, 102, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[261860, 10271, 250, 9, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[262125, 10283, 929, 28, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[263057, 10313, 76, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[263136, 10316, 674, 24, 70, "Text",
      CellTags->{"S2.6.11", "11.64"}],
    Cell[263813, 10342, 207, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.65"}],
    Cell[264045, 10351, 107, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[264155, 10355, 784, 26, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[264954, 10384, 835, 31, 70, "Text",
      CellTags->{"S2.6.11", "11.66"}],
    Cell[265792, 10417, 238, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.67"}],
    Cell[266055, 10428, 106, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[266164, 10432, 1171, 38, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[267350, 10473, 394, 8, 70, "Text",
      CellTags->{"S2.6.11", "11.68"}],
    Cell[267747, 10483, 281, 9, 70, "Text",
      CellTags->{"S2.6.11", "11.69"}],
    Cell[268031, 10494, 257, 9, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.70"}],
    Cell[268313, 10507, 106, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[268422, 10511, 424, 14, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[268861, 10528, 188, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.71"}],
    Cell[269074, 10538, 105, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[269182, 10542, 578, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[269775, 10563, 856, 27, 70, "Text",
      CellTags->{"S2.6.11", "11.72"}],
    Cell[270634, 10592, 219, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.73"}],
    Cell[270878, 10602, 102, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[270983, 10606, 575, 20, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[271573, 10629, 211, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.74"}],
    Cell[271809, 10640, 105, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[271917, 10644, 1332, 44, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[273264, 10691, 3190, 102, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[276457, 10795, 100, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[276560, 10798, 848, 29, 70, "Text",
      CellTags->{"S2.6.11", "11.75"}],
    Cell[277411, 10829, 189, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.76"}],
    Cell[277625, 10838, 110, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[277738, 10842, 543, 18, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[278296, 10863, 628, 17, 70, "Text",
      CellTags->{"S2.6.11", "11.77"}],
    Cell[278927, 10882, 203, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.78"}],
    Cell[279155, 10892, 102, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[279260, 10896, 426, 16, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[279701, 10915, 1876, 59, 70, "DefinitionBox3Col",
      CellTags->"S2.6.11"],
    Cell[281580, 10976, 116, 5, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[281699, 10983, 748, 21, 70, "Text",
      CellTags->{"S2.6.11", "11.79"}],
    Cell[282450, 11006, 848, 32, 70, "Text",
      CellTags->{"S2.6.11", "11.80"}],
    Cell[283301, 11040, 923, 27, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[284227, 11069, 86, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[284316, 11072, 393, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.81"}],
    Cell[284712, 11087, 194, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.82"}],
    Cell[284931, 11097, 98, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[285032, 11101, 174, 6, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[285221, 11110, 165, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.83"}],
    Cell[285411, 11119, 124, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[285538, 11123, 85, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[285638, 11129, 590, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.84"}],
    Cell[286231, 11144, 166, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.85"}],
    Cell[286422, 11153, 92, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[286517, 11157, 266, 10, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[286786, 11169, 295, 11, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[287084, 11182, 267, 10, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[287354, 11194, 296, 11, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[287653, 11207, 268, 10, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[287924, 11219, 296, 11, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[288223, 11232, 268, 10, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[288494, 11244, 295, 11, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[288792, 11257, 267, 10, 70, "Print",
      CellTags->"S2.6.11"],
    Cell[289062, 11269, 84, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[289161, 11275, 968, 32, 70, "Text",
      CellTags->{"S2.6.11", "11.86"}],
    Cell[290132, 11309, 2310, 73, 70, "DefinitionBox",
      CellTags->"S2.6.11"],
    Cell[292445, 11384, 76, 1, 70, "Caption",
      CellTags->"S2.6.11"],
    Cell[292524, 11387, 211, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.87"}],
    Cell[292760, 11398, 94, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[292857, 11402, 142, 3, 70, "Message",
      CellTags->"S2.6.11"],
    Cell[293002, 11407, 113, 4, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[293130, 11414, 202, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.88"}],
    Cell[293357, 11423, 74, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[293434, 11427, 117, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[293566, 11433, 192, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.89"}],
    Cell[293783, 11443, 75, 2, 70, "Input",
      CellTags->"S2.6.11"],
    Cell[293861, 11447, 112, 2, 70, "Message",
      CellTags->"S2.6.11"],
    Cell[293976, 11451, 90, 3, 70, "Output",
      CellTags->"S2.6.11"],
    Cell[294081, 11457, 492, 11, 70, "Text",
      CellTags->{"S2.6.11", "11.90"}],
    Cell[294576, 11470, 575, 17, 70, "Text",
      CellTags->{"S2.6.11", "11.91"}],
    Cell[295154, 11489, 542, 19, 70, "Text",
      CellTags->{"S2.6.11", "11.92"}],
    Cell[295699, 11510, 722, 33, 70, "Text",
      CellTags->{"S2.6.11", "11.93"}]},
  "11.1"->{
    Cell[210454, 8352, 96, 1, 70, "Subsection",
      CellTags->{"S2.6.11", "11.1"}]},
  "11.2"->{
    Cell[210553, 8355, 485, 11, 70, "Text",
      CellTags->{"S2.6.11", "11.2"}]},
  "11.3"->{
    Cell[212116, 8403, 236, 11, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.3"}]},
  "11.4"->{
    Cell[212680, 8433, 150, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.4"}]},
  "11.5"->{
    Cell[213326, 8463, 135, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.5"}]},
  "11.6"->{
    Cell[214134, 8498, 513, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.6"}]},
  "11.7"->{
    Cell[214650, 8514, 410, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.7"}]},
  "11.8"->{
    Cell[215063, 8530, 112, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.8"}]},
  "11.9"->{
    Cell[215399, 8545, 244, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.9"}]},
  "11.10"->{
    Cell[216977, 8603, 163, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.10"}]},
  "11.11"->{
    Cell[217643, 8632, 139, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.11"}]},
  "11.12"->{
    Cell[218597, 8670, 421, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.12"}]},
  "11.13"->{
    Cell[219021, 8686, 483, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.13"}]},
  "11.14"->{
    Cell[219507, 8702, 772, 22, 70, "Text",
      CellTags->{"S2.6.11", "11.14"}]},
  "11.15"->{
    Cell[220282, 8726, 152, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.15"}]},
  "11.16"->{
    Cell[221135, 8760, 566, 16, 70, "Text",
      CellTags->{"S2.6.11", "11.16"}]},
  "11.17"->{
    Cell[221704, 8778, 88, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.17"}]},
  "11.18"->{
    Cell[221903, 8785, 168, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.18"}]},
  "11.19"->{
    Cell[222741, 8819, 570, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.19"}]},
  "11.20"->{
    Cell[225149, 8898, 561, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.20"}]},
  "11.21"->{
    Cell[225713, 8913, 649, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.21"}]},
  "11.22"->{
    Cell[226365, 8929, 92, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.22"}]},
  "11.23"->{
    Cell[226690, 8944, 237, 8, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.23"}]},
  "11.24"->{
    Cell[227364, 8975, 335, 13, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.24"}]},
  "11.25"->{
    Cell[228103, 9009, 186, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.25"}]},
  "11.26"->{
    Cell[229092, 9049, 143, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.26"}]},
  "11.27"->{
    Cell[229868, 9082, 135, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.27"}]},
  "11.28"->{
    Cell[230753, 9117, 599, 12, 70, "Text",
      CellTags->{"S2.6.11", "11.28"}]},
  "11.29"->{
    Cell[231355, 9131, 213, 8, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.29"}]},
  "11.30"->{
    Cell[232335, 9172, 103, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.30"}]},
  "11.31"->{
    Cell[232537, 9179, 189, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.31"}]},
  "11.32"->{
    Cell[233592, 9219, 425, 8, 70, "Text",
      CellTags->{"S2.6.11", "11.32"}]},
  "11.33"->{
    Cell[234020, 9229, 451, 19, 70, "Text",
      CellTags->{"S2.6.11", "11.33"}]},
  "11.34"->{
    Cell[234474, 9250, 183, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.34"}]},
  "11.35"->{
    Cell[235640, 9292, 291, 11, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.35"}]},
  "11.36"->{
    Cell[236031, 9309, 209, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.36"}]},
  "11.37"->{
    Cell[237080, 9352, 118, 2, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.37"}]},
  "11.38"->{
    Cell[237304, 9360, 104, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.38"}]},
  "11.39"->{
    Cell[237620, 9375, 165, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.39"}]},
  "11.40"->{
    Cell[239730, 9445, 1002, 28, 70, "Text",
      CellTags->{"S2.6.11", "11.40"}]},
  "11.41"->{
    Cell[240735, 9475, 486, 18, 70, "Text",
      CellTags->{"S2.6.11", "11.41"}]},
  "11.42"->{
    Cell[242573, 9540, 161, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.42"}]},
  "11.43"->{
    Cell[243238, 9569, 192, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.43"}]},
  "11.44"->{
    Cell[244153, 9606, 138, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.44"}]},
  "11.45"->{
    Cell[244392, 9617, 306, 13, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.45"}]},
  "11.46"->{
    Cell[247029, 9712, 490, 16, 70, "Text",
      CellTags->{"S2.6.11", "11.46"}]},
  "11.47"->{
    Cell[247522, 9730, 576, 21, 70, "Text",
      CellTags->{"S2.6.11", "11.47"}]},
  "11.48"->{
    Cell[248101, 9753, 97, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.48"}]},
  "11.49"->{
    Cell[249455, 9799, 170, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.49"}]},
  "11.50"->{
    Cell[250590, 9841, 177, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.50"}]},
  "11.51"->{
    Cell[252453, 9910, 244, 9, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.51"}]},
  "11.52"->{
    Cell[254543, 9984, 784, 20, 70, "Text",
      CellTags->{"S2.6.11", "11.52"}]},
  "11.53"->{
    Cell[255330, 10006, 154, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.53"}]},
  "11.54"->{
    Cell[255982, 10035, 176, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.54"}]},
  "11.55"->{
    Cell[256445, 10056, 312, 8, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.55"}]},
  "11.56"->{
    Cell[257382, 10093, 109, 1, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.56"}]},
  "11.57"->{
    Cell[257784, 10110, 234, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.57"}]},
  "11.58"->{
    Cell[258644, 10145, 439, 14, 70, "Text",
      CellTags->{"S2.6.11", "11.58"}]},
  "11.59"->{
    Cell[259086, 10161, 210, 6, 70, "Text",
      CellTags->{"S2.6.11", "11.59"}]},
  "11.60"->{
    Cell[259299, 10169, 195, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.60"}]},
  "11.61"->{
    Cell[260184, 10206, 224, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.61"}]},
  "11.62"->{
    Cell[260856, 10235, 729, 22, 70, "Text",
      CellTags->{"S2.6.11", "11.62"}]},
  "11.63"->{
    Cell[261588, 10259, 142, 4, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.63"}]},
  "11.64"->{
    Cell[263136, 10316, 674, 24, 70, "Text",
      CellTags->{"S2.6.11", "11.64"}]},
  "11.65"->{
    Cell[263813, 10342, 207, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.65"}]},
  "11.66"->{
    Cell[264954, 10384, 835, 31, 70, "Text",
      CellTags->{"S2.6.11", "11.66"}]},
  "11.67"->{
    Cell[265792, 10417, 238, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.67"}]},
  "11.68"->{
    Cell[267350, 10473, 394, 8, 70, "Text",
      CellTags->{"S2.6.11", "11.68"}]},
  "11.69"->{
    Cell[267747, 10483, 281, 9, 70, "Text",
      CellTags->{"S2.6.11", "11.69"}]},
  "11.70"->{
    Cell[268031, 10494, 257, 9, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.70"}]},
  "11.71"->{
    Cell[268861, 10528, 188, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.71"}]},
  "11.72"->{
    Cell[269775, 10563, 856, 27, 70, "Text",
      CellTags->{"S2.6.11", "11.72"}]},
  "11.73"->{
    Cell[270634, 10592, 219, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.73"}]},
  "11.74"->{
    Cell[271573, 10629, 211, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.74"}]},
  "11.75"->{
    Cell[276560, 10798, 848, 29, 70, "Text",
      CellTags->{"S2.6.11", "11.75"}]},
  "11.76"->{
    Cell[277411, 10829, 189, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.76"}]},
  "11.77"->{
    Cell[278296, 10863, 628, 17, 70, "Text",
      CellTags->{"S2.6.11", "11.77"}]},
  "11.78"->{
    Cell[278927, 10882, 203, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.78"}]},
  "11.79"->{
    Cell[281699, 10983, 748, 21, 70, "Text",
      CellTags->{"S2.6.11", "11.79"}]},
  "11.80"->{
    Cell[282450, 11006, 848, 32, 70, "Text",
      CellTags->{"S2.6.11", "11.80"}]},
  "11.81"->{
    Cell[284316, 11072, 393, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.81"}]},
  "11.82"->{
    Cell[284712, 11087, 194, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.82"}]},
  "11.83"->{
    Cell[285221, 11110, 165, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.83"}]},
  "11.84"->{
    Cell[285638, 11129, 590, 13, 70, "Text",
      CellTags->{"S2.6.11", "11.84"}]},
  "11.85"->{
    Cell[286231, 11144, 166, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.85"}]},
  "11.86"->{
    Cell[289161, 11275, 968, 32, 70, "Text",
      CellTags->{"S2.6.11", "11.86"}]},
  "11.87"->{
    Cell[292524, 11387, 211, 7, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.87"}]},
  "11.88"->{
    Cell[293130, 11414, 202, 5, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.88"}]},
  "11.89"->{
    Cell[293566, 11433, 192, 6, 70, "MathCaption",
      CellTags->{"S2.6.11", "11.89"}]},
  "11.90"->{
    Cell[294081, 11457, 492, 11, 70, "Text",
      CellTags->{"S2.6.11", "11.90"}]},
  "11.91"->{
    Cell[294576, 11470, 575, 17, 70, "Text",
      CellTags->{"S2.6.11", "11.91"}]},
  "11.92"->{
    Cell[295154, 11489, 542, 19, 70, "Text",
      CellTags->{"S2.6.11", "11.92"}]},
  "11.93"->{
    Cell[295699, 11510, 722, 33, 70, "Text",
      CellTags->{"S2.6.11", "11.93"}]},
  "S2.6.12"->{
    Cell[296458, 11548, 98, 1, 70, "Subsection",
      CellTags->{"S2.6.12", "12.1"}],
    Cell[296559, 11551, 561, 16, 70, "Text",
      CellTags->{"S2.6.12", "12.2"}],
    Cell[297123, 11569, 327, 7, 70, "Text",
      CellTags->{"S2.6.12", "12.3"}],
    Cell[297453, 11578, 728, 31, 70, "Text",
      CellTags->{"S2.6.12", "12.4"}],
    Cell[298184, 11611, 254, 7, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.5"}],
    Cell[298463, 11622, 90, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[298556, 11626, 351, 11, 70, "Print",
      CellTags->"S2.6.12"],
    Cell[298922, 11640, 219, 7, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.6"}],
    Cell[299166, 11651, 90, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[299259, 11655, 89, 2, 70, "Print",
      CellTags->"S2.6.12"],
    Cell[299363, 11660, 497, 13, 70, "Text",
      CellTags->{"S2.6.12", "12.7"}],
    Cell[299863, 11675, 982, 31, 70, "DefinitionBox",
      CellTags->"S2.6.12"],
    Cell[300848, 11708, 75, 1, 70, "Caption",
      CellTags->"S2.6.12"],
    Cell[300926, 11711, 493, 14, 70, "Text",
      CellTags->{"S2.6.12", "12.8"}],
    Cell[301422, 11727, 135, 4, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.9"}],
    Cell[301560, 11733, 98, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[301661, 11737, 199, 7, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.10"}],
    Cell[301885, 11748, 93, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[301981, 11752, 142, 3, 70, "Message",
      CellTags->"S2.6.12"],
    Cell[302126, 11757, 112, 4, 70, "Output",
      CellTags->"S2.6.12"],
    Cell[302253, 11764, 141, 4, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.11"}],
    Cell[302419, 11772, 73, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[302495, 11776, 149, 4, 70, "Output",
      CellTags->"S2.6.12"],
    Cell[302659, 11783, 79, 1, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.12"}],
    Cell[302763, 11788, 74, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[302840, 11792, 112, 2, 70, "Message",
      CellTags->"S2.6.12"],
    Cell[302955, 11796, 89, 3, 70, "Output",
      CellTags->"S2.6.12"],
    Cell[303059, 11802, 485, 14, 70, "Text",
      CellTags->{"S2.6.12", "12.13"}],
    Cell[303547, 11818, 325, 11, 70, "Text",
      CellTags->{"S2.6.12", "12.14"}],
    Cell[303875, 11831, 185, 6, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.15"}],
    Cell[304085, 11841, 104, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[304192, 11845, 108, 3, 70, "Output",
      CellTags->"S2.6.12"],
    Cell[304315, 11851, 343, 10, 70, "Text",
      CellTags->{"S2.6.12", "12.16"}],
    Cell[304661, 11863, 1238, 38, 70, "DefinitionBox",
      CellTags->"S2.6.12"],
    Cell[305902, 11903, 76, 1, 70, "Caption",
      CellTags->"S2.6.12"],
    Cell[305981, 11906, 968, 34, 70, "Text",
      CellTags->{"S2.6.12", "12.17"}],
    Cell[306952, 11942, 230, 8, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.18"}],
    Cell[307207, 11954, 121, 2, 70, "Input",
      CellTags->"S2.6.12"],
    Cell[307331, 11958, 62, 2, 70, "Print",
      CellTags->"S2.6.12"],
    Cell[307396, 11962, 95, 3, 70, "Output",
      CellTags->"S2.6.12"],
    Cell[307506, 11968, 398, 9, 70, "Text",
      CellTags->{"S2.6.12", "12.19"}],
    Cell[307907, 11979, 644, 23, 70, "Text",
      CellTags->{"S2.6.12", "12.20"}]},
  "12.1"->{
    Cell[296458, 11548, 98, 1, 70, "Subsection",
      CellTags->{"S2.6.12", "12.1"}]},
  "12.2"->{
    Cell[296559, 11551, 561, 16, 70, "Text",
      CellTags->{"S2.6.12", "12.2"}]},
  "12.3"->{
    Cell[297123, 11569, 327, 7, 70, "Text",
      CellTags->{"S2.6.12", "12.3"}]},
  "12.4"->{
    Cell[297453, 11578, 728, 31, 70, "Text",
      CellTags->{"S2.6.12", "12.4"}]},
  "12.5"->{
    Cell[298184, 11611, 254, 7, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.5"}]},
  "12.6"->{
    Cell[298922, 11640, 219, 7, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.6"}]},
  "12.7"->{
    Cell[299363, 11660, 497, 13, 70, "Text",
      CellTags->{"S2.6.12", "12.7"}]},
  "12.8"->{
    Cell[300926, 11711, 493, 14, 70, "Text",
      CellTags->{"S2.6.12", "12.8"}]},
  "12.9"->{
    Cell[301422, 11727, 135, 4, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.9"}]},
  "12.10"->{
    Cell[301661, 11737, 199, 7, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.10"}]},
  "12.11"->{
    Cell[302253, 11764, 141, 4, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.11"}]},
  "12.12"->{
    Cell[302659, 11783, 79, 1, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.12"}]},
  "12.13"->{
    Cell[303059, 11802, 485, 14, 70, "Text",
      CellTags->{"S2.6.12", "12.13"}]},
  "12.14"->{
    Cell[303547, 11818, 325, 11, 70, "Text",
      CellTags->{"S2.6.12", "12.14"}]},
  "12.15"->{
    Cell[303875, 11831, 185, 6, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.15"}]},
  "12.16"->{
    Cell[304315, 11851, 343, 10, 70, "Text",
      CellTags->{"S2.6.12", "12.16"}]},
  "12.17"->{
    Cell[305981, 11906, 968, 34, 70, "Text",
      CellTags->{"S2.6.12", "12.17"}]},
  "12.18"->{
    Cell[306952, 11942, 230, 8, 70, "MathCaption",
      CellTags->{"S2.6.12", "12.18"}]},
  "12.19"->{
    Cell[307506, 11968, 398, 9, 70, "Text",
      CellTags->{"S2.6.12", "12.19"}]},
  "12.20"->{
    Cell[307907, 11979, 644, 23, 70, "Text",
      CellTags->{"S2.6.12", "12.20"}]},
  "S2.6.13"->{
    Cell[308588, 12007, 109, 1, 70, "Subsection",
      CellTags->{"S2.6.13", "13.1"}],
    Cell[308700, 12010, 819, 26, 70, "Text",
      CellTags->{"S2.6.13", "13.2"}],
    Cell[309522, 12038, 247, 7, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.3"}],
    Cell[309794, 12049, 74, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[309871, 12053, 147, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[310021, 12058, 99, 3, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[310135, 12064, 277, 8, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.4"}],
    Cell[310437, 12076, 79, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[310519, 12080, 147, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[310669, 12085, 99, 3, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[310783, 12091, 525, 14, 70, "DefinitionBox",
      CellTags->"S2.6.13"],
    Cell[311311, 12107, 91, 1, 70, "Caption",
      CellTags->"S2.6.13"],
    Cell[311405, 12110, 179, 5, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.5"}],
    Cell[311609, 12119, 80, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[311692, 12123, 147, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[311842, 12128, 147, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[311992, 12133, 100, 3, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[312107, 12139, 719, 19, 70, "Text",
      CellTags->{"S2.6.13", "13.6"}],
    Cell[312829, 12160, 688, 20, 70, "Text",
      CellTags->{"S2.6.13", "13.7"}],
    Cell[313520, 12182, 211, 9, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.8"}],
    Cell[313756, 12195, 103, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[313862, 12199, 84, 3, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[313961, 12205, 134, 4, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.9"}],
    Cell[314120, 12213, 72, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[314195, 12217, 146, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[314344, 12222, 129, 3, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[314488, 12228, 151, 4, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.10"}],
    Cell[314642, 12234, 87, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[314732, 12238, 139, 4, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.11"}],
    Cell[314896, 12246, 71, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[314970, 12250, 146, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[315119, 12255, 292, 6, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[315426, 12264, 95, 1, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.12"}],
    Cell[315524, 12267, 84, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[315611, 12271, 206, 6, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.13"}],
    Cell[315842, 12281, 70, 2, 70, "Input",
      CellTags->"S2.6.13"],
    Cell[315915, 12285, 145, 3, 70, "Message",
      CellTags->"S2.6.13"],
    Cell[316063, 12290, 103, 3, 70, "Output",
      CellTags->"S2.6.13"],
    Cell[316181, 12296, 615, 14, 70, "Text",
      CellTags->{"S2.6.13", "13.14"}],
    Cell[316799, 12312, 860, 22, 70, "Text",
      CellTags->{"S2.6.13", "13.15"}],
    Cell[317662, 12336, 1210, 33, 70, "Text",
      CellTags->{"S2.6.13", "13.16"}]},
  "13.1"->{
    Cell[308588, 12007, 109, 1, 70, "Subsection",
      CellTags->{"S2.6.13", "13.1"}]},
  "13.2"->{
    Cell[308700, 12010, 819, 26, 70, "Text",
      CellTags->{"S2.6.13", "13.2"}]},
  "13.3"->{
    Cell[309522, 12038, 247, 7, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.3"}]},
  "13.4"->{
    Cell[310135, 12064, 277, 8, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.4"}]},
  "13.5"->{
    Cell[311405, 12110, 179, 5, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.5"}]},
  "13.6"->{
    Cell[312107, 12139, 719, 19, 70, "Text",
      CellTags->{"S2.6.13", "13.6"}]},
  "13.7"->{
    Cell[312829, 12160, 688, 20, 70, "Text",
      CellTags->{"S2.6.13", "13.7"}]},
  "13.8"->{
    Cell[313520, 12182, 211, 9, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.8"}]},
  "13.9"->{
    Cell[313961, 12205, 134, 4, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.9"}]},
  "13.10"->{
    Cell[314488, 12228, 151, 4, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.10"}]},
  "13.11"->{
    Cell[314732, 12238, 139, 4, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.11"}]},
  "13.12"->{
    Cell[315426, 12264, 95, 1, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.12"}]},
  "13.13"->{
    Cell[315611, 12271, 206, 6, 70, "MathCaption",
      CellTags->{"S2.6.13", "13.13"}]},
  "13.14"->{
    Cell[316181, 12296, 615, 14, 70, "Text",
      CellTags->{"S2.6.13", "13.14"}]},
  "13.15"->{
    Cell[316799, 12312, 860, 22, 70, "Text",
      CellTags->{"S2.6.13", "13.15"}]},
  "13.16"->{
    Cell[317662, 12336, 1210, 33, 70, "Text",
      CellTags->{"S2.6.13", "13.16"}]},
  "S2.6.14"->{
    Cell[318909, 12374, 99, 1, 70, "Subsection",
      CellTags->{"S2.6.14", "14.1"}],
    Cell[319011, 12377, 305, 9, 70, "Text",
      CellTags->{"S2.6.14", "14.2"}],
    Cell[319319, 12388, 502, 14, 70, "Text",
      CellTags->{"S2.6.14", "14.3"}],
    Cell[319824, 12404, 1465, 45, 70, "DefinitionBox",
      CellTags->"S2.6.14"],
    Cell[321292, 12451, 65, 1, 70, "Caption",
      CellTags->"S2.6.14"],
    Cell[321360, 12454, 276, 9, 70, "Text",
      CellTags->{"S2.6.14", "14.4"}],
    Cell[321639, 12465, 419, 13, 70, "Text",
      CellTags->{"S2.6.14", "14.5"}],
    Cell[322061, 12480, 193, 6, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.6"}],
    Cell[322279, 12490, 93, 2, 70, "Input",
      CellTags->"S2.6.14"],
    Cell[322375, 12494, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[322435, 12498, 90, 3, 70, "Output",
      CellTags->"S2.6.14"],
    Cell[322540, 12504, 330, 10, 70, "Text",
      CellTags->{"S2.6.14", "14.7"}],
    Cell[322873, 12516, 699, 23, 70, "Text",
      CellTags->{"S2.6.14", "14.8"}],
    Cell[323575, 12541, 220, 8, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.9"}],
    Cell[323820, 12553, 124, 2, 70, "Input",
      CellTags->"S2.6.14"],
    Cell[323947, 12557, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[324007, 12561, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[324067, 12565, 89, 3, 70, "Output",
      CellTags->"S2.6.14"],
    Cell[324171, 12571, 226, 9, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.10"}],
    Cell[324422, 12584, 124, 2, 70, "Input",
      CellTags->"S2.6.14"],
    Cell[324549, 12588, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[324609, 12592, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[324669, 12596, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[324741, 12601, 499, 11, 70, "Text",
      CellTags->{"S2.6.14", "14.11"}],
    Cell[325243, 12614, 183, 7, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.12"}],
    Cell[325451, 12625, 107, 2, 70, "Input",
      CellTags->"S2.6.14"],
    Cell[325561, 12629, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[325621, 12633, 90, 3, 70, "Output",
      CellTags->"S2.6.14"],
    Cell[325726, 12639, 167, 5, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.13"}],
    Cell[325918, 12648, 122, 2, 70, "Input",
      CellTags->"S2.6.14"],
    Cell[326043, 12652, 57, 2, 70, "Print",
      CellTags->"S2.6.14"],
    Cell[326115, 12657, 516, 18, 70, "Text",
      CellTags->{"S2.6.14", "14.14"}]},
  "14.1"->{
    Cell[318909, 12374, 99, 1, 70, "Subsection",
      CellTags->{"S2.6.14", "14.1"}]},
  "14.2"->{
    Cell[319011, 12377, 305, 9, 70, "Text",
      CellTags->{"S2.6.14", "14.2"}]},
  "14.3"->{
    Cell[319319, 12388, 502, 14, 70, "Text",
      CellTags->{"S2.6.14", "14.3"}]},
  "14.4"->{
    Cell[321360, 12454, 276, 9, 70, "Text",
      CellTags->{"S2.6.14", "14.4"}]},
  "14.5"->{
    Cell[321639, 12465, 419, 13, 70, "Text",
      CellTags->{"S2.6.14", "14.5"}]},
  "14.6"->{
    Cell[322061, 12480, 193, 6, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.6"}]},
  "14.7"->{
    Cell[322540, 12504, 330, 10, 70, "Text",
      CellTags->{"S2.6.14", "14.7"}]},
  "14.8"->{
    Cell[322873, 12516, 699, 23, 70, "Text",
      CellTags->{"S2.6.14", "14.8"}]},
  "14.9"->{
    Cell[323575, 12541, 220, 8, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.9"}]},
  "14.10"->{
    Cell[324171, 12571, 226, 9, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.10"}]},
  "14.11"->{
    Cell[324741, 12601, 499, 11, 70, "Text",
      CellTags->{"S2.6.14", "14.11"}]},
  "14.12"->{
    Cell[325243, 12614, 183, 7, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.12"}]},
  "14.13"->{
    Cell[325726, 12639, 167, 5, 70, "MathCaption",
      CellTags->{"S2.6.14", "14.13"}]},
  "14.14"->{
    Cell[326115, 12657, 516, 18, 70, "Text",
      CellTags->{"S2.6.14", "14.14"}]},
  "S2.6.15"->{
    Cell[326668, 12680, 140, 5, 70, "Subsection",
      CellTags->{"S2.6.15", "15.1"}],
    Cell[326811, 12687, 927, 33, 70, "Text",
      CellTags->{"S2.6.15", "15.2"}],
    Cell[327741, 12722, 481, 15, 70, "Text",
      CellTags->{"S2.6.15", "15.3"}],
    Cell[328225, 12739, 1357, 52, 70, "Text",
      CellTags->{"S2.6.15", "15.4"}],
    Cell[329585, 12793, 400, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.5"}],
    Cell[329988, 12805, 1452, 42, 70, "DefinitionBox",
      CellTags->"S2.6.15"],
    Cell[331443, 12849, 71, 1, 70, "Caption",
      CellTags->"S2.6.15"],
    Cell[331517, 12852, 257, 11, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.6"}],
    Cell[331799, 12867, 92, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[331894, 12871, 106, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[332015, 12877, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.7"}],
    Cell[332226, 12888, 92, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[332321, 12892, 176, 5, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[332512, 12900, 242, 8, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.8"}],
    Cell[332779, 12912, 82, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[332864, 12916, 124, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[333003, 12922, 405, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.9"}],
    Cell[333411, 12934, 460, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.10"}],
    Cell[333874, 12946, 456, 11, 70, "Text",
      CellTags->{"S2.6.15", "15.11"}],
    Cell[334333, 12959, 313, 8, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.12"}],
    Cell[334671, 12971, 110, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[334784, 12975, 283, 7, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[335082, 12985, 174, 5, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.13"}],
    Cell[335281, 12994, 72, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[335356, 12998, 102, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[335473, 13004, 108, 3, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.14"}],
    Cell[335606, 13011, 83, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[335692, 13015, 101, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[335808, 13021, 526, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.15"}],
    Cell[336337, 13033, 884, 30, 70, "Text",
      CellTags->{"S2.6.15", "15.16"}],
    Cell[337224, 13065, 7519, 222, 70, "DefinitionBox",
      CellTags->"S2.6.15"],
    Cell[344746, 13289, 76, 1, 70, "Caption",
      CellTags->"S2.6.15"],
    Cell[344825, 13292, 298, 6, 70, "Text",
      CellTags->{"S2.6.15", "15.17"}],
    Cell[345126, 13300, 745, 23, 70, "Text",
      CellTags->{"S2.6.15", "15.18"}],
    Cell[345874, 13325, 325, 15, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.19"}],
    Cell[346224, 13344, 113, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[346340, 13348, 178, 5, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[346533, 13356, 88, 1, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.20"}],
    Cell[346646, 13361, 72, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[346721, 13365, 84, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[346820, 13371, 147, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.21"}],
    Cell[346992, 13379, 117, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[347112, 13383, 185, 5, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[347312, 13391, 156, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.22"}],
    Cell[347493, 13399, 91, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[347587, 13403, 85, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[347687, 13409, 748, 17, 70, "Text",
      CellTags->{"S2.6.15", "15.23"}],
    Cell[348438, 13428, 725, 14, 70, "Text",
      CellTags->{"S2.6.15", "15.24"}],
    Cell[349166, 13444, 154, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.25"}],
    Cell[349323, 13450, 92, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[349418, 13454, 207, 7, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.26"}],
    Cell[349650, 13465, 125, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[349778, 13469, 180, 5, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[349973, 13477, 95, 1, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.27"}],
    Cell[350093, 13482, 75, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[350171, 13486, 102, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[350288, 13492, 489, 12, 70, "Text",
      CellTags->{"S2.6.15", "15.28"}],
    Cell[350780, 13506, 137, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.29"}],
    Cell[350942, 13514, 92, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[351037, 13518, 171, 5, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[351223, 13526, 119, 2, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.30"}],
    Cell[351367, 13532, 73, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[351443, 13536, 102, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[351560, 13542, 222, 5, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.31"}],
    Cell[351807, 13551, 75, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[351885, 13555, 198, 4, 70, "Message",
      CellTags->"S2.6.15"],
    Cell[352086, 13561, 94, 3, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[352195, 13567, 697, 19, 70, "Text",
      CellTags->{"S2.6.15", "15.32"}],
    Cell[352895, 13588, 516, 13, 70, "Text",
      CellTags->{"S2.6.15", "15.33"}],
    Cell[353414, 13603, 243, 6, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.34"}],
    Cell[353682, 13613, 74, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[353759, 13617, 199, 4, 70, "Message",
      CellTags->"S2.6.15"],
    Cell[353961, 13623, 159, 4, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[354135, 13630, 367, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.35"}],
    Cell[354505, 13642, 386, 12, 70, "Text",
      CellTags->{"S2.6.15", "15.36"}],
    Cell[354894, 13656, 215, 5, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.37"}],
    Cell[355134, 13665, 161, 5, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[355298, 13672, 245, 7, 70, "Output",
      CellTags->"S2.6.15"],
    Cell[355558, 13682, 90, 1, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.38"}],
    Cell[355673, 13687, 78, 2, 70, "Input",
      CellTags->"S2.6.15"],
    Cell[355754, 13691, 102, 3, 25, "Output",
      CellTags->"S2.6.15"]},
  "15.1"->{
    Cell[326668, 12680, 140, 5, 70, "Subsection",
      CellTags->{"S2.6.15", "15.1"}]},
  "15.2"->{
    Cell[326811, 12687, 927, 33, 70, "Text",
      CellTags->{"S2.6.15", "15.2"}]},
  "15.3"->{
    Cell[327741, 12722, 481, 15, 70, "Text",
      CellTags->{"S2.6.15", "15.3"}]},
  "15.4"->{
    Cell[328225, 12739, 1357, 52, 70, "Text",
      CellTags->{"S2.6.15", "15.4"}]},
  "15.5"->{
    Cell[329585, 12793, 400, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.5"}]},
  "15.6"->{
    Cell[331517, 12852, 257, 11, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.6"}]},
  "15.7"->{
    Cell[332015, 12877, 186, 7, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.7"}]},
  "15.8"->{
    Cell[332512, 12900, 242, 8, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.8"}]},
  "15.9"->{
    Cell[333003, 12922, 405, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.9"}]},
  "15.10"->{
    Cell[333411, 12934, 460, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.10"}]},
  "15.11"->{
    Cell[333874, 12946, 456, 11, 70, "Text",
      CellTags->{"S2.6.15", "15.11"}]},
  "15.12"->{
    Cell[334333, 12959, 313, 8, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.12"}]},
  "15.13"->{
    Cell[335082, 12985, 174, 5, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.13"}]},
  "15.14"->{
    Cell[335473, 13004, 108, 3, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.14"}]},
  "15.15"->{
    Cell[335808, 13021, 526, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.15"}]},
  "15.16"->{
    Cell[336337, 13033, 884, 30, 70, "Text",
      CellTags->{"S2.6.15", "15.16"}]},
  "15.17"->{
    Cell[344825, 13292, 298, 6, 70, "Text",
      CellTags->{"S2.6.15", "15.17"}]},
  "15.18"->{
    Cell[345126, 13300, 745, 23, 70, "Text",
      CellTags->{"S2.6.15", "15.18"}]},
  "15.19"->{
    Cell[345874, 13325, 325, 15, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.19"}]},
  "15.20"->{
    Cell[346533, 13356, 88, 1, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.20"}]},
  "15.21"->{
    Cell[346820, 13371, 147, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.21"}]},
  "15.22"->{
    Cell[347312, 13391, 156, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.22"}]},
  "15.23"->{
    Cell[347687, 13409, 748, 17, 70, "Text",
      CellTags->{"S2.6.15", "15.23"}]},
  "15.24"->{
    Cell[348438, 13428, 725, 14, 70, "Text",
      CellTags->{"S2.6.15", "15.24"}]},
  "15.25"->{
    Cell[349166, 13444, 154, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.25"}]},
  "15.26"->{
    Cell[349418, 13454, 207, 7, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.26"}]},
  "15.27"->{
    Cell[349973, 13477, 95, 1, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.27"}]},
  "15.28"->{
    Cell[350288, 13492, 489, 12, 70, "Text",
      CellTags->{"S2.6.15", "15.28"}]},
  "15.29"->{
    Cell[350780, 13506, 137, 4, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.29"}]},
  "15.30"->{
    Cell[351223, 13526, 119, 2, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.30"}]},
  "15.31"->{
    Cell[351560, 13542, 222, 5, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.31"}]},
  "15.32"->{
    Cell[352195, 13567, 697, 19, 70, "Text",
      CellTags->{"S2.6.15", "15.32"}]},
  "15.33"->{
    Cell[352895, 13588, 516, 13, 70, "Text",
      CellTags->{"S2.6.15", "15.33"}]},
  "15.34"->{
    Cell[353414, 13603, 243, 6, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.34"}]},
  "15.35"->{
    Cell[354135, 13630, 367, 10, 70, "Text",
      CellTags->{"S2.6.15", "15.35"}]},
  "15.36"->{
    Cell[354505, 13642, 386, 12, 70, "Text",
      CellTags->{"S2.6.15", "15.36"}]},
  "15.37"->{
    Cell[354894, 13656, 215, 5, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.37"}]},
  "15.38"->{
    Cell[355558, 13682, 90, 1, 70, "MathCaption",
      CellTags->{"S2.6.15", "15.38"}]},
  "S2.6.16"->{
    Cell[355905, 13700, 104, 1, 70, "Subsection",
      CellTags->{"S2.6.16", "16.1"}],
    Cell[356012, 13703, 431, 10, 72, "Text",
      CellTags->{"S2.6.16", "16.2"}],
    Cell[356446, 13715, 344, 9, 56, "Text",
      CellTags->{"S2.6.16", "16.3"}],
    Cell[356793, 13726, 577, 13, 88, "Text",
      CellTags->{"S2.6.16", "16.4"}],
    Cell[357373, 13741, 3829, 108, 82, "DefinitionBox",
      CellTags->"S2.6.16"],
    Cell[361205, 13851, 83, 1, 16, "Caption",
      CellTags->"S2.6.16"],
    Cell[361291, 13854, 172, 5, 40, "MathCaption",
      CellTags->{"S2.6.16", "16.5"}],
    Cell[361488, 13863, 95, 2, 28, "Input",
      CellTags->"S2.6.16"],
    Cell[361586, 13867, 256, 6, 74, "Output",
      CellTags->"S2.6.16"],
    Cell[361857, 13876, 762, 14, 120, "Text",
      CellTags->{"S2.6.16", "16.6"}],
    Cell[362622, 13892, 559, 9, 88, "Text",
      CellTags->{"S2.6.16", "16.7"}]},
  "16.1"->{
    Cell[355905, 13700, 104, 1, 70, "Subsection",
      CellTags->{"S2.6.16", "16.1"}]},
  "16.2"->{
    Cell[356012, 13703, 431, 10, 72, "Text",
      CellTags->{"S2.6.16", "16.2"}]},
  "16.3"->{
    Cell[356446, 13715, 344, 9, 56, "Text",
      CellTags->{"S2.6.16", "16.3"}]},
  "16.4"->{
    Cell[356793, 13726, 577, 13, 88, "Text",
      CellTags->{"S2.6.16", "16.4"}]},
  "16.5"->{
    Cell[361291, 13854, 172, 5, 40, "MathCaption",
      CellTags->{"S2.6.16", "16.5"}]},
  "16.6"->{
    Cell[361857, 13876, 762, 14, 120, "Text",
      CellTags->{"S2.6.16", "16.6"}]},
  "16.7"->{
    Cell[362622, 13892, 559, 9, 88, "Text",
      CellTags->{"S2.6.16", "16.7"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.6.0", 363823, 13921},
  {"0.1", 363913, 13924},
  {"S2.6.1", 364006, 13927},
  {"1.1", 366980, 14008},
  {"1.2", 367072, 14011},
  {"1.3", 367159, 14014},
  {"1.4", 367246, 14017},
  {"1.5", 367334, 14020},
  {"1.6", 367423, 14023},
  {"1.7", 367511, 14026},
  {"1.8", 367606, 14029},
  {"1.9", 367701, 14032},
  {"1.10", 367797, 14035},
  {"1.11", 367894, 14038},
  {"1.12", 367984, 14041},
  {"1.13", 368081, 14044},
  {"1.14", 368172, 14047},
  {"1.15", 368269, 14050},
  {"1.16", 368360, 14053},
  {"1.17", 368458, 14056},
  {"1.18", 368556, 14059},
  {"1.19", 368648, 14062},
  {"S2.6.2", 368748, 14065},
  {"2.1", 371342, 14134},
  {"2.2", 371437, 14137},
  {"2.3", 371526, 14140},
  {"2.4", 371617, 14143},
  {"2.5", 371713, 14146},
  {"2.6", 371802, 14149},
  {"2.7", 371892, 14152},
  {"2.8", 371988, 14155},
  {"2.9", 372077, 14158},
  {"2.10", 372174, 14161},
  {"2.11", 372266, 14164},
  {"2.12", 372358, 14167},
  {"2.13", 372450, 14170},
  {"2.14", 372541, 14173},
  {"2.15", 372633, 14176},
  {"2.16", 372731, 14179},
  {"2.17", 372829, 14182},
  {"2.18", 372927, 14185},
  {"2.19", 373019, 14188},
  {"2.20", 373110, 14191},
  {"S2.6.3", 373203, 14194},
  {"3.1", 379421, 14359},
  {"3.2", 379515, 14362},
  {"3.3", 379605, 14365},
  {"3.4", 379695, 14368},
  {"3.5", 379791, 14371},
  {"3.6", 379887, 14374},
  {"3.7", 379976, 14377},
  {"3.8", 380072, 14380},
  {"3.9", 380168, 14383},
  {"3.10", 380266, 14386},
  {"3.11", 380365, 14389},
  {"3.12", 380464, 14392},
  {"3.13", 380557, 14395},
  {"3.14", 380656, 14398},
  {"3.15", 380755, 14401},
  {"3.16", 380854, 14404},
  {"3.17", 380947, 14407},
  {"3.18", 381040, 14410},
  {"3.19", 381139, 14413},
  {"3.20", 381238, 14416},
  {"3.21", 381337, 14419},
  {"3.22", 381430, 14422},
  {"3.23", 381529, 14425},
  {"3.24", 381628, 14428},
  {"3.25", 381727, 14431},
  {"3.26", 381820, 14434},
  {"3.27", 381919, 14437},
  {"3.28", 382018, 14440},
  {"3.29", 382110, 14443},
  {"3.30", 382209, 14446},
  {"3.31", 382301, 14449},
  {"3.32", 382400, 14452},
  {"S2.6.4", 382501, 14455},
  {"4.1", 388391, 14610},
  {"4.2", 388486, 14613},
  {"4.3", 388577, 14616},
  {"4.4", 388667, 14619},
  {"4.5", 388764, 14622},
  {"4.6", 388861, 14625},
  {"4.7", 388958, 14628},
  {"4.8", 389049, 14631},
  {"4.9", 389139, 14634},
  {"4.10", 389230, 14637},
  {"4.11", 389323, 14640},
  {"4.12", 389416, 14643},
  {"4.13", 389509, 14646},
  {"4.14", 389608, 14649},
  {"4.15", 389707, 14652},
  {"4.16", 389800, 14655},
  {"4.17", 389899, 14658},
  {"4.18", 389998, 14661},
  {"4.19", 390097, 14664},
  {"4.20", 390190, 14667},
  {"4.21", 390283, 14670},
  {"4.22", 390375, 14673},
  {"4.23", 390474, 14676},
  {"4.24", 390573, 14679},
  {"4.25", 390672, 14682},
  {"4.26", 390771, 14685},
  {"4.27", 390864, 14688},
  {"4.28", 390957, 14691},
  {"4.29", 391051, 14694},
  {"4.30", 391144, 14697},
  {"4.31", 391243, 14700},
  {"4.32", 391342, 14703},
  {"4.33", 391441, 14706},
  {"4.34", 391540, 14709},
  {"4.35", 391633, 14712},
  {"4.36", 391732, 14715},
  {"4.37", 391831, 14718},
  {"S2.6.5", 391932, 14721},
  {"5.1", 398273, 14888},
  {"5.2", 398368, 14891},
  {"5.3", 398459, 14894},
  {"5.4", 398550, 14897},
  {"5.5", 398641, 14900},
  {"5.6", 398738, 14903},
  {"5.7", 398835, 14906},
  {"5.8", 398932, 14909},
  {"5.9", 399029, 14912},
  {"5.10", 399127, 14915},
  {"5.11", 399220, 14918},
  {"5.12", 399319, 14921},
  {"5.13", 399411, 14924},
  {"5.14", 399504, 14927},
  {"5.15", 399603, 14930},
  {"5.16", 399696, 14933},
  {"5.17", 399795, 14936},
  {"5.18", 399895, 14939},
  {"5.19", 399994, 14942},
  {"5.20", 400087, 14945},
  {"5.21", 400180, 14948},
  {"5.22", 400273, 14951},
  {"5.23", 400372, 14954},
  {"5.24", 400471, 14957},
  {"5.25", 400570, 14960},
  {"5.26", 400669, 14963},
  {"5.27", 400769, 14966},
  {"5.28", 400869, 14969},
  {"5.29", 400970, 14972},
  {"5.30", 401071, 14975},
  {"5.31", 401172, 14978},
  {"5.32", 401266, 14981},
  {"S2.6.6", 401362, 14984},
  {"6.1", 406141, 15109},
  {"6.2", 406238, 15112},
  {"6.3", 406329, 15115},
  {"6.4", 406427, 15118},
  {"6.5", 406525, 15121},
  {"6.6", 406617, 15124},
  {"6.7", 406708, 15127},
  {"6.8", 406807, 15130},
  {"6.9", 406898, 15133},
  {"6.10", 406997, 15136},
  {"6.11", 407097, 15139},
  {"6.12", 407197, 15142},
  {"6.13", 407297, 15145},
  {"6.14", 407391, 15148},
  {"6.15", 407491, 15151},
  {"6.16", 407591, 15154},
  {"6.17", 407685, 15157},
  {"6.18", 407779, 15160},
  {"6.19", 407879, 15163},
  {"6.20", 407978, 15166},
  {"6.21", 408079, 15169},
  {"6.22", 408179, 15172},
  {"6.23", 408273, 15175},
  {"6.24", 408374, 15178},
  {"6.25", 408474, 15181},
  {"6.26", 408568, 15184},
  {"S2.6.7", 408663, 15187},
  {"7.1", 411070, 15250},
  {"7.2", 411166, 15253},
  {"7.3", 411258, 15256},
  {"7.4", 411350, 15259},
  {"7.5", 411448, 15262},
  {"7.6", 411546, 15265},
  {"7.7", 411638, 15268},
  {"7.8", 411736, 15271},
  {"7.9", 411834, 15274},
  {"7.10", 411933, 15277},
  {"7.11", 412027, 15280},
  {"7.12", 412127, 15283},
  {"7.13", 412227, 15286},
  {"7.14", 412327, 15289},
  {"S2.6.8", 412423, 15292},
  {"8.1", 418206, 15443},
  {"8.2", 418302, 15446},
  {"8.3", 418393, 15449},
  {"8.4", 418491, 15452},
  {"8.5", 418589, 15455},
  {"8.6", 418681, 15458},
  {"8.7", 418780, 15461},
  {"8.8", 418878, 15464},
  {"8.9", 418976, 15467},
  {"8.10", 419075, 15470},
  {"8.11", 419169, 15473},
  {"8.12", 419269, 15476},
  {"8.13", 419369, 15479},
  {"8.14", 419468, 15482},
  {"8.15", 419568, 15485},
  {"8.16", 419669, 15488},
  {"8.17", 419770, 15491},
  {"8.18", 419864, 15494},
  {"8.19", 419964, 15497},
  {"8.20", 420064, 15500},
  {"8.21", 420164, 15503},
  {"8.22", 420265, 15506},
  {"8.23", 420365, 15509},
  {"8.24", 420460, 15512},
  {"8.25", 420560, 15515},
  {"8.26", 420660, 15518},
  {"8.27", 420755, 15521},
  {"8.28", 420855, 15524},
  {"8.29", 420954, 15527},
  {"8.30", 421054, 15530},
  {"S2.6.9", 421150, 15533},
  {"9.1", 435757, 15922},
  {"9.2", 435853, 15925},
  {"9.3", 435945, 15928},
  {"9.4", 436044, 15931},
  {"9.5", 436143, 15934},
  {"9.6", 436235, 15937},
  {"9.7", 436334, 15940},
  {"9.8", 436425, 15943},
  {"9.9", 436523, 15946},
  {"9.10", 436622, 15949},
  {"9.11", 436716, 15952},
  {"9.12", 436816, 15955},
  {"9.13", 436916, 15958},
  {"9.14", 437010, 15961},
  {"9.15", 437110, 15964},
  {"9.16", 437204, 15967},
  {"9.17", 437304, 15970},
  {"9.18", 437398, 15973},
  {"9.19", 437498, 15976},
  {"9.20", 437599, 15979},
  {"9.21", 437700, 15982},
  {"9.22", 437794, 15985},
  {"9.23", 437894, 15988},
  {"9.24", 437994, 15991},
  {"9.25", 438094, 15994},
  {"9.26", 438188, 15997},
  {"9.27", 438289, 16000},
  {"9.28", 438389, 16003},
  {"9.29", 438489, 16006},
  {"9.30", 438589, 16009},
  {"9.31", 438683, 16012},
  {"9.32", 438783, 16015},
  {"9.33", 438883, 16018},
  {"9.34", 438983, 16021},
  {"9.35", 439083, 16024},
  {"9.36", 439176, 16027},
  {"9.37", 439276, 16030},
  {"9.38", 439370, 16033},
  {"9.39", 439470, 16036},
  {"9.40", 439570, 16039},
  {"9.41", 439664, 16042},
  {"9.42", 439764, 16045},
  {"9.43", 439858, 16048},
  {"9.44", 439958, 16051},
  {"9.45", 440059, 16054},
  {"9.46", 440153, 16057},
  {"9.47", 440253, 16060},
  {"9.48", 440347, 16063},
  {"9.49", 440440, 16066},
  {"9.50", 440534, 16069},
  {"9.51", 440628, 16072},
  {"9.52", 440729, 16075},
  {"9.53", 440830, 16078},
  {"9.54", 440924, 16081},
  {"9.55", 441024, 16084},
  {"9.56", 441124, 16087},
  {"9.57", 441224, 16090},
  {"9.58", 441324, 16093},
  {"9.59", 441424, 16096},
  {"9.60", 441518, 16099},
  {"9.61", 441618, 16102},
  {"S2.6.10", 441715, 16105},
  {"10.1", 444780, 16184},
  {"10.2", 444880, 16187},
  {"10.3", 444975, 16190},
  {"10.4", 445076, 16193},
  {"10.5", 445177, 16196},
  {"10.6", 445278, 16199},
  {"10.7", 445373, 16202},
  {"10.8", 445474, 16205},
  {"10.9", 445575, 16208},
  {"10.10", 445677, 16211},
  {"10.11", 445780, 16214},
  {"10.12", 445883, 16217},
  {"10.13", 445986, 16220},
  {"10.14", 446089, 16223},
  {"S2.6.11", 446193, 16226},
  {"11.1", 464322, 16685},
  {"11.2", 464421, 16688},
  {"11.3", 464516, 16691},
  {"11.4", 464618, 16694},
  {"11.5", 464719, 16697},
  {"11.6", 464820, 16700},
  {"11.7", 464915, 16703},
  {"11.8", 465010, 16706},
  {"11.9", 465111, 16709},
  {"11.10", 465213, 16712},
  {"11.11", 465316, 16715},
  {"11.12", 465419, 16718},
  {"11.13", 465516, 16721},
  {"11.14", 465613, 16724},
  {"11.15", 465710, 16727},
  {"11.16", 465813, 16730},
  {"11.17", 465910, 16733},
  {"11.18", 466012, 16736},
  {"11.19", 466115, 16739},
  {"11.20", 466212, 16742},
  {"11.21", 466309, 16745},
  {"11.22", 466406, 16748},
  {"11.23", 466508, 16751},
  {"11.24", 466611, 16754},
  {"11.25", 466715, 16757},
  {"11.26", 466818, 16760},
  {"11.27", 466921, 16763},
  {"11.28", 467024, 16766},
  {"11.29", 467121, 16769},
  {"11.30", 467224, 16772},
  {"11.31", 467327, 16775},
  {"11.32", 467430, 16778},
  {"11.33", 467526, 16781},
  {"11.34", 467623, 16784},
  {"11.35", 467726, 16787},
  {"11.36", 467830, 16790},
  {"11.37", 467933, 16793},
  {"11.38", 468036, 16796},
  {"11.39", 468139, 16799},
  {"11.40", 468242, 16802},
  {"11.41", 468340, 16805},
  {"11.42", 468437, 16808},
  {"11.43", 468540, 16811},
  {"11.44", 468643, 16814},
  {"11.45", 468746, 16817},
  {"11.46", 468850, 16820},
  {"11.47", 468947, 16823},
  {"11.48", 469044, 16826},
  {"11.49", 469146, 16829},
  {"11.50", 469249, 16832},
  {"11.51", 469352, 16835},
  {"11.52", 469455, 16838},
  {"11.53", 469552, 16841},
  {"11.54", 469656, 16844},
  {"11.55", 469760, 16847},
  {"11.56", 469864, 16850},
  {"11.57", 469968, 16853},
  {"11.58", 470072, 16856},
  {"11.59", 470170, 16859},
  {"11.60", 470267, 16862},
  {"11.61", 470371, 16865},
  {"11.62", 470475, 16868},
  {"11.63", 470573, 16871},
  {"11.64", 470677, 16874},
  {"11.65", 470775, 16877},
  {"11.66", 470879, 16880},
  {"11.67", 470977, 16883},
  {"11.68", 471081, 16886},
  {"11.69", 471178, 16889},
  {"11.70", 471275, 16892},
  {"11.71", 471379, 16895},
  {"11.72", 471483, 16898},
  {"11.73", 471581, 16901},
  {"11.74", 471685, 16904},
  {"11.75", 471789, 16907},
  {"11.76", 471887, 16910},
  {"11.77", 471991, 16913},
  {"11.78", 472089, 16916},
  {"11.79", 472193, 16919},
  {"11.80", 472291, 16922},
  {"11.81", 472389, 16925},
  {"11.82", 472487, 16928},
  {"11.83", 472591, 16931},
  {"11.84", 472695, 16934},
  {"11.85", 472793, 16937},
  {"11.86", 472897, 16940},
  {"11.87", 472995, 16943},
  {"11.88", 473099, 16946},
  {"11.89", 473203, 16949},
  {"11.90", 473307, 16952},
  {"11.91", 473405, 16955},
  {"11.92", 473503, 16958},
  {"11.93", 473601, 16961},
  {"S2.6.12", 473701, 16964},
  {"12.1", 477061, 17049},
  {"12.2", 477161, 17052},
  {"12.3", 477257, 17055},
  {"12.4", 477352, 17058},
  {"12.5", 477448, 17061},
  {"12.6", 477550, 17064},
  {"12.7", 477652, 17067},
  {"12.8", 477748, 17070},
  {"12.9", 477844, 17073},
  {"12.10", 477947, 17076},
  {"12.11", 478051, 17079},
  {"12.12", 478155, 17082},
  {"12.13", 478258, 17085},
  {"12.14", 478356, 17088},
  {"12.15", 478454, 17091},
  {"12.16", 478558, 17094},
  {"12.17", 478656, 17097},
  {"12.18", 478754, 17100},
  {"12.19", 478858, 17103},
  {"12.20", 478955, 17106},
  {"S2.6.13", 479055, 17109},
  {"13.1", 482307, 17192},
  {"13.2", 482408, 17195},
  {"13.3", 482504, 17198},
  {"13.4", 482606, 17201},
  {"13.5", 482708, 17204},
  {"13.6", 482810, 17207},
  {"13.7", 482906, 17210},
  {"13.8", 483002, 17213},
  {"13.9", 483104, 17216},
  {"13.10", 483207, 17219},
  {"13.11", 483311, 17222},
  {"13.12", 483415, 17225},
  {"13.13", 483518, 17228},
  {"13.14", 483622, 17231},
  {"13.15", 483720, 17234},
  {"13.16", 483818, 17237},
  {"S2.6.14", 483919, 17240},
  {"14.1", 486447, 17305},
  {"14.2", 486547, 17308},
  {"14.3", 486642, 17311},
  {"14.4", 486738, 17314},
  {"14.5", 486833, 17317},
  {"14.6", 486929, 17320},
  {"14.7", 487031, 17323},
  {"14.8", 487127, 17326},
  {"14.9", 487223, 17329},
  {"14.10", 487326, 17332},
  {"14.11", 487430, 17335},
  {"14.12", 487528, 17338},
  {"14.13", 487632, 17341},
  {"14.14", 487736, 17344},
  {"S2.6.15", 487836, 17347},
  {"15.1", 494317, 17510},
  {"15.2", 494418, 17513},
  {"15.3", 494514, 17516},
  {"15.4", 494610, 17519},
  {"15.5", 494707, 17522},
  {"15.6", 494803, 17525},
  {"15.7", 494906, 17528},
  {"15.8", 495008, 17531},
  {"15.9", 495110, 17534},
  {"15.10", 495207, 17537},
  {"15.11", 495305, 17540},
  {"15.12", 495403, 17543},
  {"15.13", 495507, 17546},
  {"15.14", 495611, 17549},
  {"15.15", 495715, 17552},
  {"15.16", 495813, 17555},
  {"15.17", 495911, 17558},
  {"15.18", 496008, 17561},
  {"15.19", 496106, 17564},
  {"15.20", 496211, 17567},
  {"15.21", 496314, 17570},
  {"15.22", 496418, 17573},
  {"15.23", 496522, 17576},
  {"15.24", 496620, 17579},
  {"15.25", 496718, 17582},
  {"15.26", 496822, 17585},
  {"15.27", 496926, 17588},
  {"15.28", 497029, 17591},
  {"15.29", 497127, 17594},
  {"15.30", 497231, 17597},
  {"15.31", 497335, 17600},
  {"15.32", 497439, 17603},
  {"15.33", 497537, 17606},
  {"15.34", 497635, 17609},
  {"15.35", 497739, 17612},
  {"15.36", 497837, 17615},
  {"15.37", 497935, 17618},
  {"15.38", 498039, 17621},
  {"S2.6.16", 498144, 17624},
  {"16.1", 499052, 17647},
  {"16.2", 499153, 17650},
  {"16.3", 499249, 17653},
  {"16.4", 499344, 17656},
  {"16.5", 499440, 17659},
  {"16.6", 499542, 17662},
  {"16.7", 499639, 17665}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 128, 4, 65, "Section",
  CellTags->{"S2.6.0", "0.1"}],

Cell[CellGroupData[{
Cell[1929, 61, 83, 1, 70, "Subsection",
  CellTags->{"S2.6.1", "1.1"}],
Cell[2015, 64, 311, 9, 70, "Text",
  CellTags->{"S2.6.1", "1.2"}],
Cell[2329, 75, 292, 8, 70, "Text",
  CellTags->{"S2.6.1", "1.3"}],
Cell[2624, 85, 972, 44, 70, "Text",
  CellTags->{"S2.6.1", "1.4"}],
Cell[3599, 131, 668, 19, 70, "Text",
  CellTags->{"S2.6.1", "1.5"}],
Cell[4270, 152, 1648, 53, 70, "DefinitionBox",
  CellTags->"S2.6.1"],
Cell[5921, 207, 77, 1, 70, "Caption",
  CellTags->"S2.6.1"],
Cell[6001, 210, 325, 9, 70, "Text",
  CellTags->{"S2.6.1", "1.6"}],
Cell[6329, 221, 207, 9, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.7"}],

Cell[CellGroupData[{
Cell[6561, 234, 84, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[6648, 238, 82, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[6745, 244, 213, 7, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.8"}],

Cell[CellGroupData[{
Cell[6983, 255, 66, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[7052, 259, 82, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[7149, 265, 158, 4, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.9"}],
Cell[7310, 271, 98, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[7411, 275, 262, 8, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.10"}],

Cell[CellGroupData[{
Cell[7698, 287, 71, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[7772, 291, 88, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[7875, 297, 368, 8, 70, "Text",
  CellTags->{"S2.6.1", "1.11"}],
Cell[8246, 307, 263, 7, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.12"}],

Cell[CellGroupData[{
Cell[8534, 318, 80, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[8617, 322, 92, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[8724, 328, 573, 14, 70, "Text",
  CellTags->{"S2.6.1", "1.13"}],
Cell[9300, 344, 181, 5, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.14"}],

Cell[CellGroupData[{
Cell[9506, 353, 74, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[9583, 357, 92, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[9690, 363, 385, 10, 70, "Text",
  CellTags->{"S2.6.1", "1.15"}],
Cell[10078, 375, 144, 5, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.16"}],

Cell[CellGroupData[{
Cell[10247, 384, 75, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[10325, 388, 85, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[10425, 394, 114, 2, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.17"}],

Cell[CellGroupData[{
Cell[10564, 400, 74, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[10641, 404, 83, 3, 70, "Output",
  CellTags->"S2.6.1"]
}, Open  ]],
Cell[10739, 410, 773, 18, 70, "Text",
  CellTags->{"S2.6.1", "1.18"}],
Cell[11515, 430, 223, 7, 70, "MathCaption",
  CellTags->{"S2.6.1", "1.19"}],

Cell[CellGroupData[{
Cell[11763, 441, 84, 2, 70, "Input",
  CellTags->"S2.6.1"],
Cell[11850, 445, 59, 2, 70, "Print",
  CellTags->"S2.6.1"],
Cell[11912, 449, 59, 2, 70, "Print",
  CellTags->"S2.6.1"],
Cell[11974, 453, 59, 2, 70, "Print",
  CellTags->"S2.6.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12082, 461, 102, 1, 70, "Subsection",
  CellTags->{"S2.6.2", "2.1"}],
Cell[12187, 464, 331, 7, 70, "Text",
  CellTags->{"S2.6.2", "2.2"}],
Cell[12521, 473, 1121, 50, 70, "Text",
  CellTags->{"S2.6.2", "2.3"}],
Cell[13645, 525, 212, 5, 70, "MathCaption",
  CellTags->{"S2.6.2", "2.4"}],

Cell[CellGroupData[{
Cell[13882, 534, 75, 2, 70, "Input",
  CellTags->"S2.6.2"],
Cell[13960, 538, 90, 3, 70, "Output",
  CellTags->"S2.6.2"]
}, Open  ]],
Cell[14065, 544, 325, 7, 70, "Text",
  CellTags->{"S2.6.2", "2.5"}],
Cell[14393, 553, 812, 29, 70, "Text",
  CellTags->{"S2.6.2", "2.6"}],
Cell[15208, 584, 156, 4, 70, "MathCaption",
  CellTags->{"S2.6.2", "2.7"}],

Cell[CellGroupData[{
Cell[15389, 592, 73, 2, 70, "Input",
  CellTags->"S2.6.2"],
Cell[15465, 596, 90, 3, 70, "Output",
  CellTags->"S2.6.2"]
}, Open  ]],
Cell[15570, 602, 1642, 50, 70, "DefinitionBox",
  CellTags->"S2.6.2"],
Cell[17215, 654, 179, 5, 70, "Caption",
  CellTags->"S2.6.2"],
Cell[17397, 661, 253, 5, 70, "Text",
  CellTags->{"S2.6.2", "2.8"}],
Cell[17653, 668, 260, 8, 70, "MathCaption",
  CellTags->{"S2.6.2", "2.9"}],

Cell[CellGroupData[{
Cell[17938, 680, 91, 2, 70, "Input",
  CellTags->"S2.6.2"],
Cell[18032, 684, 82, 3, 70, "Output",
  CellTags->"S2.6.2"]
}, Open  ]],
Cell[18129, 690, 560, 24, 70, "Text",
  CellTags->{"S2.6.2", "2.10"}],
Cell[18692, 716, 430, 11, 70, "Text",
  CellTags->{"S2.6.2", "2.11"}],
Cell[19125, 729, 454, 10, 70, "Text",
  CellTags->{"S2.6.2", "2.12"}],
Cell[19582, 741, 340, 7, 70, "Text",
  CellTags->{"S2.6.2", "2.13"}],
Cell[19925, 750, 542, 12, 70, "Text",
  CellTags->{"S2.6.2", "2.14"}],
Cell[20470, 764, 130, 4, 70, "MathCaption",
  CellTags->{"S2.6.2", "2.15"}],

Cell[CellGroupData[{
Cell[20625, 772, 93, 2, 70, "Input",
  CellTags->"S2.6.2"],
Cell[20721, 776, 127, 3, 70, "Output",
  CellTags->"S2.6.2"]
}, Open  ]],
Cell[20863, 782, 226, 5, 70, "MathCaption",
  CellTags->{"S2.6.2", "2.16"}],

Cell[CellGroupData[{
Cell[21114, 791, 73, 2, 70, "Input",
  CellTags->"S2.6.2"],
Cell[21190, 795, 111, 3, 70, "Output",
  CellTags->"S2.6.2"]
}, Open  ]],
Cell[21316, 801, 152, 4, 70, "MathCaption",
  CellTags->{"S2.6.2", "2.17"}],

Cell[CellGroupData[{
Cell[21493, 809, 73, 2, 70, "Input",
  CellTags->"S2.6.2"],
Cell[21569, 813, 156, 4, 70, "Output",
  CellTags->"S2.6.2"]
}, Open  ]],
Cell[21740, 820, 342, 10, 70, "Text",
  CellTags->{"S2.6.2", "2.18"}],
Cell[22085, 832, 319, 6, 70, "Text",
  CellTags->{"S2.6.2", "2.19"}],
Cell[22407, 840, 437, 8, 70, "Text",
  CellTags->{"S2.6.2", "2.20"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22881, 853, 69, 1, 70, "Subsection",
  CellTags->{"S2.6.3", "3.1"}],
Cell[22953, 856, 356, 12, 70, "Text",
  CellTags->{"S2.6.3", "3.2"}],
Cell[23312, 870, 491, 11, 70, "Text",
  CellTags->{"S2.6.3", "3.3"}],
Cell[23806, 883, 177, 7, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.4"}],
Cell[23986, 892, 86, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[24075, 896, 207, 6, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.5"}],

Cell[CellGroupData[{
Cell[24307, 906, 77, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[24387, 910, 91, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[24493, 916, 331, 7, 70, "Text",
  CellTags->{"S2.6.3", "3.6"}],
Cell[24827, 925, 162, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.7"}],
Cell[24992, 932, 81, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[25076, 936, 194, 6, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.8"}],

Cell[CellGroupData[{
Cell[25295, 946, 89, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[25387, 950, 91, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[25493, 956, 2858, 91, 70, "DefinitionBox",
  CellTags->"S2.6.3"],
Cell[28354, 1049, 77, 1, 70, "Caption",
  CellTags->"S2.6.3"],
Cell[28434, 1052, 139, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.9"}],

Cell[CellGroupData[{
Cell[28598, 1061, 77, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[28678, 1065, 87, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[28780, 1071, 160, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.10"}],

Cell[CellGroupData[{
Cell[28965, 1080, 83, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[29051, 1084, 83, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[29149, 1090, 6065, 190, 70, "DefinitionBox",
  CellTags->"S2.6.3"],
Cell[35217, 1282, 145, 5, 70, "Caption",
  CellTags->"S2.6.3"],
Cell[35365, 1289, 163, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.11"}],

Cell[CellGroupData[{
Cell[35553, 1298, 80, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[35636, 1302, 156, 4, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[35807, 1309, 548, 12, 70, "Text",
  CellTags->{"S2.6.3", "3.12"}],
Cell[36358, 1323, 174, 7, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.13"}],

Cell[CellGroupData[{
Cell[36557, 1334, 79, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[36639, 1338, 106, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[36760, 1344, 143, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.14"}],
Cell[36906, 1351, 90, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[36999, 1355, 172, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.15"}],

Cell[CellGroupData[{
Cell[37196, 1364, 80, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[37279, 1368, 109, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[37403, 1374, 661, 16, 70, "Text",
  CellTags->{"S2.6.3", "3.16"}],
Cell[38067, 1392, 917, 27, 70, "Text",
  CellTags->{"S2.6.3", "3.17"}],
Cell[38987, 1421, 140, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.18"}],

Cell[CellGroupData[{
Cell[39152, 1430, 78, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[39233, 1434, 87, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[39335, 1440, 186, 7, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.19"}],

Cell[CellGroupData[{
Cell[39546, 1451, 75, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[39624, 1455, 87, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[39726, 1461, 142, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.20"}],

Cell[CellGroupData[{
Cell[39893, 1470, 74, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[39970, 1474, 135, 3, 70, "Message",
  CellTags->"S2.6.3"],
Cell[40108, 1479, 83, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[40206, 1485, 564, 14, 70, "Text",
  CellTags->{"S2.6.3", "3.21"}],
Cell[40773, 1501, 173, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.22"}],

Cell[CellGroupData[{
Cell[40971, 1510, 67, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[41041, 1514, 65, 2, 70, "Print",
  CellTags->"S2.6.3"],
Cell[41109, 1518, 475, 15, 70, "Print",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[41599, 1536, 172, 7, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.23"}],
Cell[41774, 1545, 96, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[41873, 1549, 147, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.24"}],

Cell[CellGroupData[{
Cell[42045, 1558, 67, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[42115, 1562, 65, 2, 70, "Print",
  CellTags->"S2.6.3"],
Cell[42183, 1566, 272, 8, 70, "Print",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[42470, 1577, 743, 22, 70, "Text",
  CellTags->{"S2.6.3", "3.25"}],
Cell[43216, 1601, 836, 26, 70, "DefinitionBox",
  CellTags->"S2.6.3"],
Cell[44055, 1629, 73, 1, 70, "Caption",
  CellTags->"S2.6.3"],
Cell[44131, 1632, 208, 7, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.26"}],
Cell[44342, 1641, 76, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[44421, 1645, 128, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.27"}],

Cell[CellGroupData[{
Cell[44574, 1654, 80, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[44657, 1658, 97, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[44769, 1664, 470, 8, 70, "Text",
  CellTags->{"S2.6.3", "3.28"}],
Cell[45242, 1674, 249, 8, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.29"}],

Cell[CellGroupData[{
Cell[45516, 1686, 88, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[45607, 1690, 109, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[45731, 1696, 1623, 52, 70, "DefinitionBox",
  CellTags->"S2.6.3"],
Cell[47357, 1750, 123, 4, 70, "Caption",
  CellTags->"S2.6.3"],
Cell[47483, 1756, 304, 8, 70, "Text",
  CellTags->{"S2.6.3", "3.30"}],
Cell[47790, 1766, 1222, 37, 70, "DefinitionBox",
  CellTags->"S2.6.3"],
Cell[49015, 1805, 73, 1, 70, "Caption",
  CellTags->"S2.6.3"],
Cell[49091, 1808, 147, 5, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.31"}],

Cell[CellGroupData[{
Cell[49263, 1817, 96, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[49362, 1821, 94, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]],
Cell[49471, 1827, 242, 8, 70, "MathCaption",
  CellTags->{"S2.6.3", "3.32"}],

Cell[CellGroupData[{
Cell[49738, 1839, 108, 2, 70, "Input",
  CellTags->"S2.6.3"],
Cell[49849, 1843, 100, 3, 70, "Output",
  CellTags->"S2.6.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49998, 1852, 92, 1, 70, "Subsection",
  CellTags->{"S2.6.4", "4.1"}],
Cell[50093, 1855, 542, 11, 70, "Text",
  CellTags->{"S2.6.4", "4.2"}],
Cell[50638, 1868, 357, 7, 70, "Text",
  CellTags->{"S2.6.4", "4.3"}],
Cell[50998, 1877, 236, 8, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.4"}],

Cell[CellGroupData[{
Cell[51259, 1889, 94, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[51356, 1893, 56, 2, 70, "Print",
  CellTags->"S2.6.4"],
Cell[51415, 1897, 56, 2, 70, "Print",
  CellTags->"S2.6.4"],
Cell[51474, 1901, 56, 2, 70, "Print",
  CellTags->"S2.6.4"],
Cell[51533, 1905, 99, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[51647, 1911, 165, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.5"}],

Cell[CellGroupData[{
Cell[51837, 1922, 73, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[51913, 1926, 85, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[52013, 1932, 185, 6, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.6"}],

Cell[CellGroupData[{
Cell[52223, 1942, 79, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[52305, 1946, 90, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[52410, 1952, 529, 14, 70, "Text",
  CellTags->{"S2.6.4", "4.7"}],
Cell[52942, 1968, 392, 9, 70, "Text",
  CellTags->{"S2.6.4", "4.8"}],
Cell[53337, 1979, 328, 8, 70, "Text",
  CellTags->{"S2.6.4", "4.9"}],
Cell[53668, 1989, 1011, 38, 70, "FramedBox",
  CellTags->"S2.6.4"],
Cell[54682, 2029, 76, 1, 70, "Caption",
  CellTags->"S2.6.4"],
Cell[54761, 2032, 507, 13, 70, "Text",
  CellTags->{"S2.6.4", "4.10"}],
Cell[55271, 2047, 270, 10, 70, "Text",
  CellTags->{"S2.6.4", "4.11"}],
Cell[55544, 2059, 3990, 128, 70, "DefinitionBox",
  CellTags->"S2.6.4"],
Cell[59537, 2189, 132, 5, 70, "Caption",
  CellTags->"S2.6.4"],
Cell[59672, 2196, 715, 18, 70, "Text",
  CellTags->{"S2.6.4", "4.12"}],
Cell[60390, 2216, 145, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.13"}],

Cell[CellGroupData[{
Cell[60560, 2227, 69, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[60632, 2231, 82, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[60729, 2237, 167, 4, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.14"}],

Cell[CellGroupData[{
Cell[60921, 2245, 86, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[61010, 2249, 935, 32, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[61960, 2284, 518, 13, 70, "Text",
  CellTags->{"S2.6.4", "4.15"}],
Cell[62481, 2299, 178, 5, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.16"}],

Cell[CellGroupData[{
Cell[62684, 2308, 73, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[62760, 2312, 89, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[62864, 2318, 196, 5, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.17"}],
Cell[63063, 2325, 101, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[63167, 2329, 114, 2, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.18"}],

Cell[CellGroupData[{
Cell[63306, 2335, 73, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[63382, 2339, 96, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[63493, 2345, 363, 10, 70, "Text",
  CellTags->{"S2.6.4", "4.19"}],
Cell[63859, 2357, 593, 21, 70, "Text",
  CellTags->{"S2.6.4", "4.20"}],
Cell[64455, 2380, 441, 8, 70, "Text",
  CellTags->{"S2.6.4", "4.21"}],
Cell[64899, 2390, 186, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.22"}],
Cell[65088, 2399, 88, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[65179, 2403, 186, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.23"}],
Cell[65368, 2412, 89, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[65460, 2416, 198, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.24"}],

Cell[CellGroupData[{
Cell[65683, 2427, 72, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[65758, 2431, 90, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[65863, 2437, 202, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.25"}],

Cell[CellGroupData[{
Cell[66090, 2448, 83, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[66176, 2452, 90, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[66281, 2458, 708, 20, 70, "FramedBox",
  CellTags->"S2.6.4"],
Cell[66992, 2480, 85, 1, 70, "Caption",
  CellTags->"S2.6.4"],
Cell[67080, 2483, 484, 12, 70, "Text",
  CellTags->{"S2.6.4", "4.26"}],
Cell[67567, 2497, 329, 11, 70, "Text",
  CellTags->{"S2.6.4", "4.27"}],
Cell[67899, 2510, 459, 11, 70, "Notes",
  CellTags->{"S2.6.4", "4.28"}],
Cell[68361, 2523, 655, 11, 70, "Text",
  CellTags->{"S2.6.4", "4.29"}],
Cell[69019, 2536, 243, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.30"}],
Cell[69265, 2545, 102, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[69370, 2549, 161, 5, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.31"}],
Cell[69534, 2556, 105, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[69642, 2560, 193, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.32"}],

Cell[CellGroupData[{
Cell[69860, 2571, 81, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[69944, 2575, 93, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[70052, 2581, 200, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.33"}],

Cell[CellGroupData[{
Cell[70277, 2592, 81, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[70361, 2596, 98, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]],
Cell[70474, 2602, 695, 13, 70, "Text",
  CellTags->{"S2.6.4", "4.34"}],
Cell[71172, 2617, 176, 7, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.35"}],
Cell[71351, 2626, 106, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[71460, 2630, 130, 5, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.36"}],
Cell[71593, 2637, 106, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[71702, 2641, 188, 6, 70, "MathCaption",
  CellTags->{"S2.6.4", "4.37"}],

Cell[CellGroupData[{
Cell[71915, 2651, 95, 2, 70, "Input",
  CellTags->"S2.6.4"],
Cell[72013, 2655, 112, 3, 70, "Output",
  CellTags->"S2.6.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72174, 2664, 90, 1, 70, "Subsection",
  CellTags->{"S2.6.5", "5.1"}],
Cell[72267, 2667, 531, 11, 70, "Text",
  CellTags->{"S2.6.5", "5.2"}],
Cell[72801, 2680, 2594, 86, 70, "DefinitionBox",
  CellTags->"S2.6.5"],
Cell[75398, 2768, 119, 4, 70, "Caption",
  CellTags->"S2.6.5"],
Cell[75520, 2774, 851, 36, 70, "Text",
  CellTags->{"S2.6.5", "5.3"}],
Cell[76374, 2812, 479, 13, 70, "Text",
  CellTags->{"S2.6.5", "5.4"}],
Cell[76856, 2827, 648, 18, 70, "DefinitionBox",
  CellTags->"S2.6.5"],
Cell[77507, 2847, 114, 4, 70, "Caption",
  CellTags->"S2.6.5"],
Cell[77624, 2853, 147, 4, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.5"}],

Cell[CellGroupData[{
Cell[77796, 2861, 79, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[77878, 2865, 88, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[77981, 2871, 187, 7, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.6"}],
Cell[78171, 2880, 91, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[78265, 2884, 158, 5, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.7"}],

Cell[CellGroupData[{
Cell[78448, 2893, 79, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[78530, 2897, 92, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[78637, 2903, 169, 5, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.8"}],

Cell[CellGroupData[{
Cell[78831, 2912, 99, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[78933, 2916, 83, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[79031, 2922, 198, 7, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.9"}],

Cell[CellGroupData[{
Cell[79254, 2933, 79, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[79336, 2937, 117, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[79468, 2943, 396, 10, 70, "Text",
  CellTags->{"S2.6.5", "5.10"}],
Cell[79867, 2955, 224, 6, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.11"}],

Cell[CellGroupData[{
Cell[80116, 2965, 89, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[80208, 2969, 88, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[80311, 2975, 662, 19, 70, "DefinitionBox",
  CellTags->"S2.6.5"],
Cell[80976, 2996, 87, 1, 70, "Caption",
  CellTags->"S2.6.5"],
Cell[81066, 2999, 378, 8, 70, "Text",
  CellTags->{"S2.6.5", "5.12"}],
Cell[81447, 3009, 855, 21, 70, "Text",
  CellTags->{"S2.6.5", "5.13"}],
Cell[82305, 3032, 285, 9, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.14"}],

Cell[CellGroupData[{
Cell[82615, 3045, 121, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[82739, 3049, 9637, 641, 70, 9564, 638, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False,
  CellTags->"S2.6.5"],
Cell[92379, 3692, 177, 5, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[92571, 3700, 327, 10, 70, "Text",
  CellTags->{"S2.6.5", "5.15"}],
Cell[92901, 3712, 257, 9, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.16"}],

Cell[CellGroupData[{
Cell[93183, 3725, 69, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[93255, 3729, 82, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[93352, 3735, 386, 15, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.17"}],

Cell[CellGroupData[{
Cell[93763, 3754, 79, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[93845, 3758, 82, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[93942, 3764, 146, 6, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.18"}],

Cell[CellGroupData[{
Cell[94113, 3774, 66, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[94182, 3778, 83, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[94280, 3784, 464, 10, 70, "Text",
  CellTags->{"S2.6.5", "5.19"}],
Cell[94747, 3796, 470, 12, 70, "Text",
  CellTags->{"S2.6.5", "5.20"}],
Cell[95220, 3810, 558, 19, 70, "Text",
  CellTags->{"S2.6.5", "5.21"}],
Cell[95781, 3831, 144, 4, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.22"}],

Cell[CellGroupData[{
Cell[95950, 3839, 76, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[96029, 3843, 93, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[96137, 3849, 222, 6, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.23"}],

Cell[CellGroupData[{
Cell[96384, 3859, 80, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[96467, 3863, 111, 4, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[96593, 3870, 131, 4, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.24"}],

Cell[CellGroupData[{
Cell[96749, 3878, 76, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[96828, 3882, 254, 8, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[97097, 3893, 254, 9, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.25"}],

Cell[CellGroupData[{
Cell[97376, 3906, 79, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[97458, 3910, 83, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[97556, 3916, 2949, 92, 70, "DefinitionBox",
  CellTags->"S2.6.5"],
Cell[100508, 4010, 89, 1, 70, "Caption",
  CellTags->"S2.6.5"],
Cell[100600, 4013, 137, 4, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.26"}],

Cell[CellGroupData[{
Cell[100762, 4021, 96, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[100861, 4025, 83, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[100959, 4031, 186, 5, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.27"}],

Cell[CellGroupData[{
Cell[101170, 4040, 102, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[101275, 4044, 93, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[101383, 4050, 314, 13, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.28"}],

Cell[CellGroupData[{
Cell[101722, 4067, 116, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[101841, 4071, 100, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[101956, 4077, 876, 29, 70, "DefinitionBox",
  CellTags->"S2.6.5"],
Cell[102835, 4108, 86, 1, 70, "Caption",
  CellTags->"S2.6.5"],
Cell[102924, 4111, 278, 14, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.29"}],

Cell[CellGroupData[{
Cell[103227, 4129, 78, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[103308, 4133, 83, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[103406, 4139, 248, 11, 70, "MathCaption",
  CellTags->{"S2.6.5", "5.30"}],

Cell[CellGroupData[{
Cell[103679, 4154, 91, 2, 70, "Input",
  CellTags->"S2.6.5"],
Cell[103773, 4158, 83, 3, 70, "Output",
  CellTags->"S2.6.5"]
}, Open  ]],
Cell[103871, 4164, 340, 10, 70, "Text",
  CellTags->{"S2.6.5", "5.31"}],
Cell[104214, 4176, 638, 18, 70, "DefinitionBox",
  CellTags->"S2.6.5"],
Cell[104855, 4196, 96, 1, 70, "Caption",
  CellTags->"S2.6.5"],
Cell[104954, 4199, 779, 20, 70, "Text",
  CellTags->{"S2.6.5", "5.32"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[105770, 4224, 104, 1, 70, "Subsection",
  CellTags->{"S2.6.6", "6.1"}],
Cell[105877, 4227, 456, 9, 70, "Text",
  CellTags->{"S2.6.6", "6.2"}],
Cell[106336, 4238, 147, 4, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.3"}],

Cell[CellGroupData[{
Cell[106508, 4246, 95, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[106606, 4250, 85, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[106706, 4256, 205, 5, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.4"}],

Cell[CellGroupData[{
Cell[106936, 4265, 115, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[107054, 4269, 93, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[107162, 4275, 600, 15, 70, "Text",
  CellTags->{"S2.6.6", "6.5"}],
Cell[107765, 4292, 608, 18, 70, "DefinitionBox",
  CellTags->"S2.6.6"],
Cell[108376, 4312, 76, 1, 70, "Caption",
  CellTags->"S2.6.6"],
Cell[108455, 4315, 239, 6, 70, "Text",
  CellTags->{"S2.6.6", "6.6"}],
Cell[108697, 4323, 421, 18, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.7"}],

Cell[CellGroupData[{
Cell[109143, 4345, 105, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[109251, 4349, 91, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[109357, 4355, 289, 8, 70, "Text",
  CellTags->{"S2.6.6", "6.8"}],
Cell[109649, 4365, 171, 5, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.9"}],
Cell[109823, 4372, 89, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[109915, 4376, 170, 5, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.10"}],

Cell[CellGroupData[{
Cell[110110, 4385, 68, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[110181, 4389, 85, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[110281, 4395, 204, 7, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.11"}],

Cell[CellGroupData[{
Cell[110510, 4406, 69, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[110582, 4410, 86, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[110683, 4416, 205, 7, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.12"}],

Cell[CellGroupData[{
Cell[110913, 4427, 103, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[111019, 4431, 87, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[111121, 4437, 717, 26, 70, "Text",
  CellTags->{"S2.6.6", "6.13"}],
Cell[111841, 4465, 204, 7, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.14"}],

Cell[CellGroupData[{
Cell[112070, 4476, 92, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[112165, 4480, 122, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[112302, 4486, 266, 8, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.15"}],

Cell[CellGroupData[{
Cell[112593, 4498, 83, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[112679, 4502, 113, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[112807, 4508, 985, 34, 70, "DefinitionBox",
  CellTags->"S2.6.6"],
Cell[113795, 4544, 77, 1, 70, "Caption",
  CellTags->"S2.6.6"],
Cell[113875, 4547, 679, 12, 70, "Text",
  CellTags->{"S2.6.6", "6.16"}],
Cell[114557, 4561, 722, 27, 70, "Text",
  CellTags->{"S2.6.6", "6.17"}],
Cell[115282, 4590, 146, 4, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.18"}],

Cell[CellGroupData[{
Cell[115453, 4598, 73, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[115529, 4602, 86, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[115630, 4608, 82, 1, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.19"}],

Cell[CellGroupData[{
Cell[115737, 4613, 73, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[115813, 4617, 86, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[115914, 4623, 299, 12, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.20"}],

Cell[CellGroupData[{
Cell[116238, 4639, 83, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[116324, 4643, 86, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[116425, 4649, 152, 7, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.21"}],

Cell[CellGroupData[{
Cell[116602, 4660, 69, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[116674, 4664, 86, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[116775, 4670, 453, 12, 70, "Text",
  CellTags->{"S2.6.6", "6.22"}],
Cell[117231, 4684, 244, 11, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.23"}],

Cell[CellGroupData[{
Cell[117500, 4699, 77, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[117580, 4703, 83, 3, 70, "Output",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[117678, 4709, 135, 5, 70, "MathCaption",
  CellTags->{"S2.6.6", "6.24"}],

Cell[CellGroupData[{
Cell[117838, 4718, 67, 2, 70, "Input",
  CellTags->"S2.6.6"],
Cell[117908, 4722, 65, 2, 70, "Print",
  CellTags->"S2.6.6"],
Cell[117976, 4726, 408, 13, 70, "Print",
  CellTags->"S2.6.6"]
}, Open  ]],
Cell[118399, 4742, 885, 18, 70, "Text",
  CellTags->{"S2.6.6", "6.25"}],
Cell[119287, 4762, 2449, 79, 70, "DefinitionBox",
  CellTags->"S2.6.6"],
Cell[121739, 4843, 68, 1, 70, "Caption",
  CellTags->"S2.6.6"],
Cell[121810, 4846, 406, 8, 70, "Text",
  CellTags->{"S2.6.6", "6.26"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[122253, 4859, 92, 1, 70, "Subsection",
  CellTags->{"S2.6.7", "7.1"}],
Cell[122348, 4862, 359, 13, 70, "Text",
  CellTags->{"S2.6.7", "7.2"}],
Cell[122710, 4877, 895, 29, 70, "Text",
  CellTags->{"S2.6.7", "7.3"}],
Cell[123608, 4908, 244, 8, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.4"}],

Cell[CellGroupData[{
Cell[123877, 4920, 85, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[123965, 4924, 173, 4, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[124153, 4931, 255, 9, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.5"}],

Cell[CellGroupData[{
Cell[124433, 4944, 97, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[124533, 4948, 172, 4, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[124720, 4955, 645, 23, 70, "Text",
  CellTags->{"S2.6.7", "7.6"}],
Cell[125368, 4980, 302, 8, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.7"}],
Cell[125673, 4990, 101, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[125777, 4994, 220, 7, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.8"}],

Cell[CellGroupData[{
Cell[126022, 5005, 85, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[126110, 5009, 99, 3, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[126224, 5015, 233, 9, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.9"}],

Cell[CellGroupData[{
Cell[126482, 5028, 95, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[126580, 5032, 106, 3, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[126701, 5038, 821, 34, 70, "Text",
  CellTags->{"S2.6.7", "7.10"}],
Cell[127525, 5074, 193, 7, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.11"}],

Cell[CellGroupData[{
Cell[127743, 5085, 95, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[127841, 5089, 121, 3, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[127977, 5095, 189, 6, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.12"}],

Cell[CellGroupData[{
Cell[128191, 5105, 80, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[128274, 5109, 103, 3, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[128392, 5115, 263, 9, 70, "MathCaption",
  CellTags->{"S2.6.7", "7.13"}],

Cell[CellGroupData[{
Cell[128680, 5128, 105, 2, 70, "Input",
  CellTags->"S2.6.7"],
Cell[128788, 5132, 121, 3, 70, "Output",
  CellTags->"S2.6.7"]
}, Open  ]],
Cell[128924, 5138, 1399, 44, 70, "DefinitionBox",
  CellTags->"S2.6.7"],
Cell[130326, 5184, 76, 1, 70, "Caption",
  CellTags->"S2.6.7"],
Cell[130405, 5187, 430, 11, 70, "Text",
  CellTags->{"S2.6.7", "7.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[130872, 5203, 71, 1, 70, "Subsection",
  CellTags->{"S2.6.8", "8.1"}],
Cell[130946, 5206, 268, 7, 70, "Text",
  CellTags->{"S2.6.8", "8.2"}],
Cell[131217, 5215, 6984, 209, 70, "DefinitionBox",
  CellTags->"S2.6.8"],
Cell[138204, 5426, 65, 1, 70, "Caption",
  CellTags->"S2.6.8"],
Cell[138272, 5429, 261, 9, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.3"}],

Cell[CellGroupData[{
Cell[138558, 5442, 79, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[138640, 5446, 82, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[138737, 5452, 197, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.4"}],

Cell[CellGroupData[{
Cell[138959, 5461, 93, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[139055, 5465, 56, 2, 70, "Print",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[139126, 5470, 526, 12, 70, "Text",
  CellTags->{"S2.6.8", "8.5"}],
Cell[139655, 5484, 282, 13, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.6"}],
Cell[139940, 5499, 89, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[140032, 5503, 172, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.7"}],
Cell[140207, 5510, 83, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[140293, 5514, 102, 1, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.8"}],
Cell[140398, 5517, 85, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[140486, 5521, 154, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.9"}],

Cell[CellGroupData[{
Cell[140665, 5530, 66, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[140734, 5534, 65, 2, 70, "Print",
  CellTags->"S2.6.8"],
Cell[140802, 5538, 501, 15, 70, "Print",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[141318, 5556, 449, 14, 70, "Text",
  CellTags->{"S2.6.8", "8.10"}],
Cell[141770, 5572, 201, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.11"}],
Cell[141974, 5579, 111, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[142088, 5583, 138, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.12"}],

Cell[CellGroupData[{
Cell[142251, 5592, 69, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[142323, 5596, 83, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[142421, 5602, 81, 1, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.13"}],

Cell[CellGroupData[{
Cell[142527, 5607, 68, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[142598, 5611, 82, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[142695, 5617, 178, 6, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.14"}],
Cell[142876, 5625, 109, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[142988, 5629, 237, 10, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.15"}],

Cell[CellGroupData[{
Cell[143250, 5643, 69, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[143322, 5647, 83, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[143420, 5653, 223, 10, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.16"}],

Cell[CellGroupData[{
Cell[143668, 5667, 93, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[143764, 5671, 83, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[143862, 5677, 602, 23, 70, "Text",
  CellTags->{"S2.6.8", "8.17"}],
Cell[144467, 5702, 255, 9, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.18"}],

Cell[CellGroupData[{
Cell[144747, 5715, 81, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[144831, 5719, 104, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[144950, 5725, 256, 9, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.19"}],

Cell[CellGroupData[{
Cell[145231, 5738, 84, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[145318, 5742, 83, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[145416, 5748, 3639, 116, 70, "DefinitionBox",
  CellTags->"S2.6.8"],
Cell[149058, 5866, 89, 1, 70, "Caption",
  CellTags->"S2.6.8"],
Cell[149150, 5869, 141, 4, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.20"}],

Cell[CellGroupData[{
Cell[149316, 5877, 71, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[149390, 5881, 94, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[149499, 5887, 339, 15, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.21"}],

Cell[CellGroupData[{
Cell[149863, 5906, 78, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[149944, 5910, 87, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[150046, 5916, 228, 8, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.22"}],

Cell[CellGroupData[{
Cell[150299, 5928, 72, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[150374, 5932, 87, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[150476, 5938, 1031, 38, 70, "Text",
  CellTags->{"S2.6.8", "8.23"}],
Cell[151510, 5978, 153, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.24"}],

Cell[CellGroupData[{
Cell[151688, 5987, 90, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[151781, 5991, 87, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[151883, 5997, 143, 5, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.25"}],

Cell[CellGroupData[{
Cell[152051, 6006, 89, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[152143, 6010, 101, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[152259, 6016, 1438, 58, 70, "Text",
  CellTags->{"S2.6.8", "8.26"}],
Cell[153700, 6076, 2703, 78, 70, "DefinitionBox",
  CellTags->"S2.6.8"],
Cell[156406, 6156, 76, 1, 70, "Caption",
  CellTags->"S2.6.8"],
Cell[156485, 6159, 106, 1, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.27"}],
Cell[156594, 6162, 93, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[156690, 6166, 86, 1, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.28"}],

Cell[CellGroupData[{
Cell[156801, 6171, 69, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[156873, 6175, 86, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[156974, 6181, 258, 7, 70, "MathCaption",
  CellTags->{"S2.6.8", "8.29"}],

Cell[CellGroupData[{
Cell[157257, 6192, 69, 2, 70, "Input",
  CellTags->"S2.6.8"],
Cell[157329, 6196, 87, 3, 70, "Output",
  CellTags->"S2.6.8"]
}, Open  ]],
Cell[157431, 6202, 432, 10, 70, "Text",
  CellTags->{"S2.6.8", "8.30"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[157900, 6217, 87, 1, 70, "Subsection",
  CellTags->{"S2.6.9", "9.1"}],
Cell[157990, 6220, 480, 10, 70, "Text",
  CellTags->{"S2.6.9", "9.2"}],
Cell[158473, 6232, 2394, 78, 70, "DefinitionBox",
  CellTags->"S2.6.9"],
Cell[160870, 6312, 68, 1, 70, "Caption",
  CellTags->"S2.6.9"],
Cell[160941, 6315, 237, 11, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.3"}],

Cell[CellGroupData[{
Cell[161203, 6330, 86, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[161292, 6334, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[161351, 6338, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[161410, 6342, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[161469, 6346, 57, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[161541, 6351, 296, 13, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.4"}],

Cell[CellGroupData[{
Cell[161862, 6368, 107, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[161972, 6372, 118, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[162105, 6378, 390, 12, 70, "Text",
  CellTags->{"S2.6.9", "9.5"}],
Cell[162498, 6392, 360, 17, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.6"}],

Cell[CellGroupData[{
Cell[162883, 6413, 98, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[162984, 6417, 61, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[163048, 6421, 61, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[163112, 6425, 61, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[163176, 6429, 61, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[163240, 6433, 61, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[163304, 6437, 61, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[163380, 6442, 361, 9, 70, "Text",
  CellTags->{"S2.6.9", "9.7"}],
Cell[163744, 6453, 207, 9, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.8"}],

Cell[CellGroupData[{
Cell[163976, 6466, 94, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[164073, 6470, 115, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[164203, 6476, 133, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.9"}],

Cell[CellGroupData[{
Cell[164361, 6485, 105, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[164469, 6489, 57, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[164529, 6493, 57, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[164589, 6497, 57, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[164661, 6502, 2001, 63, 70, "DefinitionBox",
  CellTags->"S2.6.9"],
Cell[166665, 6567, 74, 1, 70, "Caption",
  CellTags->"S2.6.9"],
Cell[166742, 6570, 712, 22, 70, "Text",
  CellTags->{"S2.6.9", "9.10"}],
Cell[167457, 6594, 125, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.11"}],

Cell[CellGroupData[{
Cell[167607, 6603, 77, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[167687, 6607, 91, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[167793, 6613, 190, 6, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.12"}],

Cell[CellGroupData[{
Cell[168008, 6623, 98, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[168109, 6627, 115, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[168239, 6633, 430, 13, 70, "Text",
  CellTags->{"S2.6.9", "9.13"}],
Cell[168672, 6648, 168, 4, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.14"}],

Cell[CellGroupData[{
Cell[168865, 6656, 113, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[168981, 6660, 57, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169041, 6664, 57, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169101, 6668, 57, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169161, 6672, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169220, 6676, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169279, 6680, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169338, 6684, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169397, 6688, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[169456, 6692, 82, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[169553, 6698, 566, 19, 70, "Text",
  CellTags->{"S2.6.9", "9.15"}],
Cell[170122, 6719, 2215, 70, 70, "DefinitionBox",
  CellTags->"S2.6.9"],
Cell[172340, 6791, 90, 3, 70, "Caption",
  CellTags->"S2.6.9"],
Cell[172433, 6796, 280, 9, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.16"}],

Cell[CellGroupData[{
Cell[172738, 6809, 113, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[172854, 6813, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[172913, 6817, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[172972, 6821, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[173031, 6825, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[173090, 6829, 82, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[173187, 6835, 506, 14, 70, "Text",
  CellTags->{"S2.6.9", "9.17"}],
Cell[173696, 6851, 255, 8, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.18"}],

Cell[CellGroupData[{
Cell[173976, 6863, 90, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[174069, 6867, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[174128, 6871, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[174187, 6875, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[174246, 6879, 56, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[174317, 6884, 313, 11, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.19"}],

Cell[CellGroupData[{
Cell[174655, 6899, 124, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[174782, 6903, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[174841, 6907, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[174900, 6911, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[174959, 6915, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[175057, 6921, 302, 10, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.20"}],

Cell[CellGroupData[{
Cell[175384, 6935, 123, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[175510, 6939, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[175569, 6943, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[175628, 6947, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[175687, 6951, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[175785, 6957, 537, 12, 70, "Text",
  CellTags->{"S2.6.9", "9.21"}],
Cell[176325, 6971, 129, 4, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.22"}],

Cell[CellGroupData[{
Cell[176479, 6979, 94, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[176576, 6983, 202, 4, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[176793, 6990, 171, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.23"}],

Cell[CellGroupData[{
Cell[176989, 6999, 103, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[177095, 7003, 202, 4, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[177312, 7010, 240, 7, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.24"}],

Cell[CellGroupData[{
Cell[177577, 7021, 125, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[177705, 7025, 101, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[177821, 7031, 353, 11, 70, "Text",
  CellTags->{"S2.6.9", "9.25"}],
Cell[178177, 7044, 312, 13, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.26"}],

Cell[CellGroupData[{
Cell[178514, 7061, 89, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[178606, 7065, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[178704, 7071, 184, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.27"}],
Cell[178891, 7078, 105, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[178999, 7082, 127, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.28"}],

Cell[CellGroupData[{
Cell[179151, 7091, 78, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[179232, 7095, 84, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[179331, 7101, 243, 9, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.29"}],

Cell[CellGroupData[{
Cell[179599, 7114, 79, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[179681, 7118, 90, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[179786, 7124, 997, 35, 70, "Text",
  CellTags->{"S2.6.9", "9.30"}],
Cell[180786, 7161, 172, 7, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.31"}],

Cell[CellGroupData[{
Cell[180983, 7172, 106, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[181092, 7176, 86, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[181193, 7182, 146, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.32"}],

Cell[CellGroupData[{
Cell[181364, 7191, 106, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[181473, 7195, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[181571, 7201, 182, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.33"}],

Cell[CellGroupData[{
Cell[181778, 7210, 92, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[181873, 7214, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[181971, 7220, 138, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.34"}],

Cell[CellGroupData[{
Cell[182134, 7229, 101, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[182238, 7233, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[182336, 7239, 223, 5, 70, "Text",
  CellTags->{"S2.6.9", "9.35"}],
Cell[182562, 7246, 301, 9, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.36"}],

Cell[CellGroupData[{
Cell[182888, 7259, 125, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[183016, 7263, 84, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[183115, 7269, 971, 43, 70, "Text",
  CellTags->{"S2.6.9", "9.37"}],
Cell[184089, 7314, 180, 7, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.38"}],

Cell[CellGroupData[{
Cell[184294, 7325, 93, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[184390, 7329, 89, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[184494, 7335, 166, 7, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.39"}],

Cell[CellGroupData[{
Cell[184685, 7346, 81, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[184769, 7350, 83, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[184867, 7356, 1514, 48, 70, "DefinitionBox",
  CellTags->"S2.6.9"],
Cell[186384, 7406, 66, 1, 70, "Caption",
  CellTags->"S2.6.9"],
Cell[186453, 7409, 739, 22, 70, "Text",
  CellTags->{"S2.6.9", "9.40"}],
Cell[187195, 7433, 151, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.41"}],

Cell[CellGroupData[{
Cell[187371, 7442, 111, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[187485, 7446, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[187544, 7450, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[187603, 7454, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[187662, 7458, 56, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[187733, 7463, 562, 19, 70, "Text",
  CellTags->{"S2.6.9", "9.42"}],
Cell[188298, 7484, 229, 9, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.43"}],

Cell[CellGroupData[{
Cell[188552, 7497, 95, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[188650, 7501, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[188709, 7505, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[188768, 7509, 56, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[188839, 7514, 288, 11, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.44"}],

Cell[CellGroupData[{
Cell[189152, 7529, 116, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[189271, 7533, 63, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[189337, 7537, 76, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[189416, 7541, 89, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[189520, 7546, 524, 19, 70, "Text",
  CellTags->{"S2.6.9", "9.45"}],
Cell[190047, 7567, 142, 4, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.46"}],
Cell[190192, 7573, 87, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[190282, 7577, 504, 15, 70, "Text",
  CellTags->{"S2.6.9", "9.47"}],
Cell[190789, 7594, 427, 8, 70, "Text",
  CellTags->{"S2.6.9", "9.48"}],
Cell[191219, 7604, 502, 11, 70, "Text",
  CellTags->{"S2.6.9", "9.49"}],
Cell[191724, 7617, 594, 14, 70, "Text",
  CellTags->{"S2.6.9", "9.50"}],
Cell[192321, 7633, 1777, 52, 70, "DefinitionBox",
  CellTags->"S2.6.9"],
Cell[194101, 7687, 65, 1, 70, "Caption",
  CellTags->"S2.6.9"],
Cell[194169, 7690, 250, 11, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.51"}],

Cell[CellGroupData[{
Cell[194444, 7705, 122, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[194569, 7709, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[194628, 7713, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[194687, 7717, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[194746, 7721, 57, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[194818, 7726, 382, 19, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.52"}],

Cell[CellGroupData[{
Cell[195225, 7749, 142, 5, 70, "Input",
  CellTags->"S2.6.9"],
Cell[195370, 7756, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195429, 7760, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195488, 7764, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195547, 7768, 57, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195607, 7772, 58, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195668, 7776, 59, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195730, 7780, 59, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195792, 7784, 60, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195855, 7788, 61, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[195919, 7792, 62, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[195996, 7797, 433, 11, 70, "Text",
  CellTags->{"S2.6.9", "9.53"}],
Cell[196432, 7810, 255, 8, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.54"}],
Cell[196690, 7820, 122, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[196815, 7824, 179, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.55"}],

Cell[CellGroupData[{
Cell[197019, 7833, 70, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[197092, 7837, 85, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[197192, 7843, 202, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.56"}],
Cell[197397, 7850, 106, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[197506, 7854, 127, 5, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.57"}],

Cell[CellGroupData[{
Cell[197658, 7863, 82, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[197743, 7867, 89, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[197847, 7873, 239, 9, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.58"}],

Cell[CellGroupData[{
Cell[198111, 7886, 83, 2, 70, "Input",
  CellTags->"S2.6.9"],
Cell[198197, 7890, 87, 3, 70, "Output",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[198299, 7896, 676, 21, 70, "Text",
  CellTags->{"S2.6.9", "9.59"}],
Cell[198978, 7919, 167, 7, 70, "MathCaption",
  CellTags->{"S2.6.9", "9.60"}],

Cell[CellGroupData[{
Cell[199170, 7930, 138, 5, 70, "Input",
  CellTags->"S2.6.9"],
Cell[199311, 7937, 56, 2, 70, "Print",
  CellTags->"S2.6.9"],
Cell[199370, 7941, 56, 2, 70, "Print",
  CellTags->"S2.6.9"]
}, Open  ]],
Cell[199441, 7946, 541, 15, 70, "Text",
  CellTags->{"S2.6.9", "9.61"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[200019, 7966, 102, 1, 70, "Subsection",
  CellTags->{"S2.6.10", "10.1"}],
Cell[200124, 7969, 378, 10, 70, "Text",
  CellTags->{"S2.6.10", "10.2"}],
Cell[200505, 7981, 969, 30, 70, "DefinitionBox",
  CellTags->"S2.6.10"],
Cell[201477, 8013, 134, 7, 70, "Caption",
  CellTags->"S2.6.10"],
Cell[201614, 8022, 104, 1, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.3"}],

Cell[CellGroupData[{
Cell[201743, 8027, 103, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[201849, 8031, 87, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[201951, 8037, 102, 1, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.4"}],

Cell[CellGroupData[{
Cell[202078, 8042, 119, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[202200, 8046, 100, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[202315, 8052, 115, 2, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.5"}],

Cell[CellGroupData[{
Cell[202455, 8058, 119, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[202577, 8062, 110, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[202702, 8068, 251, 11, 70, "Text",
  CellTags->{"S2.6.10", "10.6"}],
Cell[202956, 8081, 143, 5, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.7"}],
Cell[203102, 8088, 110, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[203215, 8092, 110, 1, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.8"}],

Cell[CellGroupData[{
Cell[203350, 8097, 87, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[203440, 8101, 204, 4, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[203659, 8108, 4270, 129, 70, "DefinitionBox",
  CellTags->"S2.6.10"],
Cell[207932, 8239, 72, 1, 70, "Caption",
  CellTags->"S2.6.10"],
Cell[208007, 8242, 158, 5, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.9"}],

Cell[CellGroupData[{
Cell[208190, 8251, 105, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[208298, 8255, 95, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[208408, 8261, 162, 7, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.10"}],

Cell[CellGroupData[{
Cell[208595, 8272, 110, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[208708, 8276, 98, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[208821, 8282, 136, 4, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.11"}],

Cell[CellGroupData[{
Cell[208982, 8290, 107, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[209092, 8294, 103, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[209210, 8300, 112, 1, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.12"}],

Cell[CellGroupData[{
Cell[209347, 8305, 118, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[209468, 8309, 120, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[209603, 8315, 157, 5, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.13"}],

Cell[CellGroupData[{
Cell[209785, 8324, 114, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[209902, 8328, 116, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]],
Cell[210033, 8334, 98, 1, 70, "MathCaption",
  CellTags->{"S2.6.10", "10.14"}],

Cell[CellGroupData[{
Cell[210156, 8339, 111, 2, 70, "Input",
  CellTags->"S2.6.10"],
Cell[210270, 8343, 135, 3, 70, "Output",
  CellTags->"S2.6.10"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[210454, 8352, 96, 1, 70, "Subsection",
  CellTags->{"S2.6.11", "11.1"}],
Cell[210553, 8355, 485, 11, 70, "Text",
  CellTags->{"S2.6.11", "11.2"}],
Cell[211041, 8368, 988, 30, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[212032, 8400, 81, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[212116, 8403, 236, 11, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.3"}],

Cell[CellGroupData[{
Cell[212377, 8418, 77, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[212457, 8422, 208, 8, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[212680, 8433, 150, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.4"}],

Cell[CellGroupData[{
Cell[212855, 8442, 79, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[212937, 8446, 374, 14, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[213326, 8463, 135, 4, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.5"}],

Cell[CellGroupData[{
Cell[213486, 8471, 85, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[213574, 8475, 545, 20, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[214134, 8498, 513, 14, 70, "Text",
  CellTags->{"S2.6.11", "11.6"}],
Cell[214650, 8514, 410, 14, 70, "Text",
  CellTags->{"S2.6.11", "11.7"}],
Cell[215063, 8530, 112, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.8"}],

Cell[CellGroupData[{
Cell[215200, 8535, 98, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[215301, 8539, 83, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[215399, 8545, 244, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.9"}],

Cell[CellGroupData[{
Cell[215668, 8556, 78, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[215749, 8560, 1213, 40, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[216977, 8603, 163, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.10"}],

Cell[CellGroupData[{
Cell[217165, 8612, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[217255, 8616, 373, 13, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[217643, 8632, 139, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.11"}],

Cell[CellGroupData[{
Cell[217807, 8641, 95, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[217905, 8645, 677, 22, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[218597, 8670, 421, 14, 70, "Text",
  CellTags->{"S2.6.11", "11.12"}],
Cell[219021, 8686, 483, 14, 70, "Text",
  CellTags->{"S2.6.11", "11.13"}],
Cell[219507, 8702, 772, 22, 70, "Text",
  CellTags->{"S2.6.11", "11.14"}],
Cell[220282, 8726, 152, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.15"}],

Cell[CellGroupData[{
Cell[220459, 8735, 114, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[220576, 8739, 544, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[221135, 8760, 566, 16, 70, "Text",
  CellTags->{"S2.6.11", "11.16"}],
Cell[221704, 8778, 88, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.17"}],
Cell[221795, 8781, 105, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[221903, 8785, 168, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.18"}],

Cell[CellGroupData[{
Cell[222096, 8794, 82, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[222181, 8798, 545, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[222741, 8819, 570, 13, 70, "Text",
  CellTags->{"S2.6.11", "11.19"}],
Cell[223314, 8834, 1719, 55, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[225036, 8891, 110, 5, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[225149, 8898, 561, 13, 70, "Text",
  CellTags->{"S2.6.11", "11.20"}],
Cell[225713, 8913, 649, 14, 70, "Text",
  CellTags->{"S2.6.11", "11.21"}],
Cell[226365, 8929, 92, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.22"}],

Cell[CellGroupData[{
Cell[226482, 8934, 103, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[226588, 8938, 87, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[226690, 8944, 237, 8, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.23"}],

Cell[CellGroupData[{
Cell[226952, 8956, 77, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[227032, 8960, 317, 12, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[227364, 8975, 335, 13, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.24"}],

Cell[CellGroupData[{
Cell[227724, 8992, 82, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[227809, 8996, 279, 10, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[228103, 9009, 186, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.25"}],

Cell[CellGroupData[{
Cell[228314, 9018, 95, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[228412, 9022, 665, 24, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[229092, 9049, 143, 4, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.26"}],

Cell[CellGroupData[{
Cell[229260, 9057, 82, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[229345, 9061, 508, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[229868, 9082, 135, 4, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.27"}],

Cell[CellGroupData[{
Cell[230028, 9090, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[230118, 9094, 620, 20, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[230753, 9117, 599, 12, 70, "Text",
  CellTags->{"S2.6.11", "11.28"}],
Cell[231355, 9131, 213, 8, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.29"}],

Cell[CellGroupData[{
Cell[231593, 9143, 91, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[231687, 9147, 633, 22, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[232335, 9172, 103, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.30"}],
Cell[232441, 9175, 93, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[232537, 9179, 189, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.31"}],

Cell[CellGroupData[{
Cell[232751, 9188, 78, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[232832, 9192, 745, 24, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[233592, 9219, 425, 8, 70, "Text",
  CellTags->{"S2.6.11", "11.32"}],
Cell[234020, 9229, 451, 19, 70, "Text",
  CellTags->{"S2.6.11", "11.33"}],
Cell[234474, 9250, 183, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.34"}],

Cell[CellGroupData[{
Cell[234682, 9259, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[234772, 9263, 853, 26, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[235640, 9292, 291, 11, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.35"}],
Cell[235934, 9305, 94, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[236031, 9309, 209, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.36"}],

Cell[CellGroupData[{
Cell[236265, 9319, 85, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[236353, 9323, 712, 26, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[237080, 9352, 118, 2, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.37"}],
Cell[237201, 9356, 100, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[237304, 9360, 104, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.38"}],

Cell[CellGroupData[{
Cell[237433, 9365, 85, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[237521, 9369, 84, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[237620, 9375, 165, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.39"}],

Cell[CellGroupData[{
Cell[237810, 9384, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[237900, 9388, 1815, 54, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[239730, 9445, 1002, 28, 70, "Text",
  CellTags->{"S2.6.11", "11.40"}],
Cell[240735, 9475, 486, 18, 70, "Text",
  CellTags->{"S2.6.11", "11.41"}],
Cell[241224, 9495, 1248, 40, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[242475, 9537, 95, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[242573, 9540, 161, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.42"}],

Cell[CellGroupData[{
Cell[242759, 9549, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[242849, 9553, 374, 13, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[243238, 9569, 192, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.43"}],

Cell[CellGroupData[{
Cell[243455, 9579, 84, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[243542, 9583, 596, 20, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[244153, 9606, 138, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.44"}],
Cell[244294, 9613, 95, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[244392, 9617, 306, 13, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.45"}],

Cell[CellGroupData[{
Cell[244723, 9634, 90, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[244816, 9638, 643, 20, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[245474, 9661, 1463, 46, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[246940, 9709, 86, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[247029, 9712, 490, 16, 70, "Text",
  CellTags->{"S2.6.11", "11.46"}],
Cell[247522, 9730, 576, 21, 70, "Text",
  CellTags->{"S2.6.11", "11.47"}],
Cell[248101, 9753, 97, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.48"}],

Cell[CellGroupData[{
Cell[248223, 9758, 86, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[248312, 9762, 1128, 34, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[249455, 9799, 170, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.49"}],

Cell[CellGroupData[{
Cell[249650, 9808, 102, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[249755, 9812, 820, 26, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[250590, 9841, 177, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.50"}],

Cell[CellGroupData[{
Cell[250792, 9850, 103, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[250898, 9854, 530, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[251443, 9875, 891, 27, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[252337, 9904, 113, 4, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[252453, 9910, 244, 9, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.51"}],

Cell[CellGroupData[{
Cell[252722, 9923, 93, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[252818, 9927, 1710, 54, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[254543, 9984, 784, 20, 70, "Text",
  CellTags->{"S2.6.11", "11.52"}],
Cell[255330, 10006, 154, 4, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.53"}],

Cell[CellGroupData[{
Cell[255509, 10014, 80, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[255592, 10018, 375, 14, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[255982, 10035, 176, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.54"}],

Cell[CellGroupData[{
Cell[256183, 10044, 93, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[256279, 10048, 151, 5, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[256445, 10056, 312, 8, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.55"}],

Cell[CellGroupData[{
Cell[256782, 10068, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[256872, 10072, 495, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[257382, 10093, 109, 1, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.56"}],

Cell[CellGroupData[{
Cell[257516, 10098, 78, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[257597, 10102, 172, 5, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[257784, 10110, 234, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.57"}],

Cell[CellGroupData[{
Cell[258043, 10121, 97, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[258143, 10125, 486, 17, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[258644, 10145, 439, 14, 70, "Text",
  CellTags->{"S2.6.11", "11.58"}],
Cell[259086, 10161, 210, 6, 70, "Text",
  CellTags->{"S2.6.11", "11.59"}],
Cell[259299, 10169, 195, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.60"}],

Cell[CellGroupData[{
Cell[259519, 10180, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[259609, 10184, 560, 19, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[260184, 10206, 224, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.61"}],

Cell[CellGroupData[{
Cell[260433, 10217, 87, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[260523, 10221, 318, 11, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[260856, 10235, 729, 22, 70, "Text",
  CellTags->{"S2.6.11", "11.62"}],
Cell[261588, 10259, 142, 4, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.63"}],

Cell[CellGroupData[{
Cell[261755, 10267, 102, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[261860, 10271, 250, 9, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[262125, 10283, 929, 28, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[263057, 10313, 76, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[263136, 10316, 674, 24, 70, "Text",
  CellTags->{"S2.6.11", "11.64"}],
Cell[263813, 10342, 207, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.65"}],

Cell[CellGroupData[{
Cell[264045, 10351, 107, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[264155, 10355, 784, 26, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[264954, 10384, 835, 31, 70, "Text",
  CellTags->{"S2.6.11", "11.66"}],
Cell[265792, 10417, 238, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.67"}],

Cell[CellGroupData[{
Cell[266055, 10428, 106, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[266164, 10432, 1171, 38, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[267350, 10473, 394, 8, 70, "Text",
  CellTags->{"S2.6.11", "11.68"}],
Cell[267747, 10483, 281, 9, 70, "Text",
  CellTags->{"S2.6.11", "11.69"}],
Cell[268031, 10494, 257, 9, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.70"}],

Cell[CellGroupData[{
Cell[268313, 10507, 106, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[268422, 10511, 424, 14, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[268861, 10528, 188, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.71"}],

Cell[CellGroupData[{
Cell[269074, 10538, 105, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[269182, 10542, 578, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[269775, 10563, 856, 27, 70, "Text",
  CellTags->{"S2.6.11", "11.72"}],
Cell[270634, 10592, 219, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.73"}],

Cell[CellGroupData[{
Cell[270878, 10602, 102, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[270983, 10606, 575, 20, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[271573, 10629, 211, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.74"}],

Cell[CellGroupData[{
Cell[271809, 10640, 105, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[271917, 10644, 1332, 44, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[273264, 10691, 3190, 102, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[276457, 10795, 100, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[276560, 10798, 848, 29, 70, "Text",
  CellTags->{"S2.6.11", "11.75"}],
Cell[277411, 10829, 189, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.76"}],

Cell[CellGroupData[{
Cell[277625, 10838, 110, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[277738, 10842, 543, 18, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[278296, 10863, 628, 17, 70, "Text",
  CellTags->{"S2.6.11", "11.77"}],
Cell[278927, 10882, 203, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.78"}],

Cell[CellGroupData[{
Cell[279155, 10892, 102, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[279260, 10896, 426, 16, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[279701, 10915, 1876, 59, 70, "DefinitionBox3Col",
  CellTags->"S2.6.11"],
Cell[281580, 10976, 116, 5, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[281699, 10983, 748, 21, 70, "Text",
  CellTags->{"S2.6.11", "11.79"}],
Cell[282450, 11006, 848, 32, 70, "Text",
  CellTags->{"S2.6.11", "11.80"}],
Cell[283301, 11040, 923, 27, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[284227, 11069, 86, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[284316, 11072, 393, 13, 70, "Text",
  CellTags->{"S2.6.11", "11.81"}],
Cell[284712, 11087, 194, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.82"}],

Cell[CellGroupData[{
Cell[284931, 11097, 98, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[285032, 11101, 174, 6, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[285221, 11110, 165, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.83"}],

Cell[CellGroupData[{
Cell[285411, 11119, 124, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[285538, 11123, 85, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[285638, 11129, 590, 13, 70, "Text",
  CellTags->{"S2.6.11", "11.84"}],
Cell[286231, 11144, 166, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.85"}],

Cell[CellGroupData[{
Cell[286422, 11153, 92, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[286517, 11157, 266, 10, 70, "Print",
  CellTags->"S2.6.11"],
Cell[286786, 11169, 295, 11, 70, "Print",
  CellTags->"S2.6.11"],
Cell[287084, 11182, 267, 10, 70, "Print",
  CellTags->"S2.6.11"],
Cell[287354, 11194, 296, 11, 70, "Print",
  CellTags->"S2.6.11"],
Cell[287653, 11207, 268, 10, 70, "Print",
  CellTags->"S2.6.11"],
Cell[287924, 11219, 296, 11, 70, "Print",
  CellTags->"S2.6.11"],
Cell[288223, 11232, 268, 10, 70, "Print",
  CellTags->"S2.6.11"],
Cell[288494, 11244, 295, 11, 70, "Print",
  CellTags->"S2.6.11"],
Cell[288792, 11257, 267, 10, 70, "Print",
  CellTags->"S2.6.11"],
Cell[289062, 11269, 84, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[289161, 11275, 968, 32, 70, "Text",
  CellTags->{"S2.6.11", "11.86"}],
Cell[290132, 11309, 2310, 73, 70, "DefinitionBox",
  CellTags->"S2.6.11"],
Cell[292445, 11384, 76, 1, 70, "Caption",
  CellTags->"S2.6.11"],
Cell[292524, 11387, 211, 7, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.87"}],

Cell[CellGroupData[{
Cell[292760, 11398, 94, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[292857, 11402, 142, 3, 70, "Message",
  CellTags->"S2.6.11"],
Cell[293002, 11407, 113, 4, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[293130, 11414, 202, 5, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.88"}],

Cell[CellGroupData[{
Cell[293357, 11423, 74, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[293434, 11427, 117, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[293566, 11433, 192, 6, 70, "MathCaption",
  CellTags->{"S2.6.11", "11.89"}],

Cell[CellGroupData[{
Cell[293783, 11443, 75, 2, 70, "Input",
  CellTags->"S2.6.11"],
Cell[293861, 11447, 112, 2, 70, "Message",
  CellTags->"S2.6.11"],
Cell[293976, 11451, 90, 3, 70, "Output",
  CellTags->"S2.6.11"]
}, Open  ]],
Cell[294081, 11457, 492, 11, 70, "Text",
  CellTags->{"S2.6.11", "11.90"}],
Cell[294576, 11470, 575, 17, 70, "Text",
  CellTags->{"S2.6.11", "11.91"}],
Cell[295154, 11489, 542, 19, 70, "Text",
  CellTags->{"S2.6.11", "11.92"}],
Cell[295699, 11510, 722, 33, 70, "Text",
  CellTags->{"S2.6.11", "11.93"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[296458, 11548, 98, 1, 70, "Subsection",
  CellTags->{"S2.6.12", "12.1"}],
Cell[296559, 11551, 561, 16, 70, "Text",
  CellTags->{"S2.6.12", "12.2"}],
Cell[297123, 11569, 327, 7, 70, "Text",
  CellTags->{"S2.6.12", "12.3"}],
Cell[297453, 11578, 728, 31, 70, "Text",
  CellTags->{"S2.6.12", "12.4"}],
Cell[298184, 11611, 254, 7, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.5"}],

Cell[CellGroupData[{
Cell[298463, 11622, 90, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[298556, 11626, 351, 11, 70, "Print",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[298922, 11640, 219, 7, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.6"}],

Cell[CellGroupData[{
Cell[299166, 11651, 90, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[299259, 11655, 89, 2, 70, "Print",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[299363, 11660, 497, 13, 70, "Text",
  CellTags->{"S2.6.12", "12.7"}],
Cell[299863, 11675, 982, 31, 70, "DefinitionBox",
  CellTags->"S2.6.12"],
Cell[300848, 11708, 75, 1, 70, "Caption",
  CellTags->"S2.6.12"],
Cell[300926, 11711, 493, 14, 70, "Text",
  CellTags->{"S2.6.12", "12.8"}],
Cell[301422, 11727, 135, 4, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.9"}],
Cell[301560, 11733, 98, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[301661, 11737, 199, 7, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.10"}],

Cell[CellGroupData[{
Cell[301885, 11748, 93, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[301981, 11752, 142, 3, 70, "Message",
  CellTags->"S2.6.12"],
Cell[302126, 11757, 112, 4, 70, "Output",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[302253, 11764, 141, 4, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.11"}],

Cell[CellGroupData[{
Cell[302419, 11772, 73, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[302495, 11776, 149, 4, 70, "Output",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[302659, 11783, 79, 1, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.12"}],

Cell[CellGroupData[{
Cell[302763, 11788, 74, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[302840, 11792, 112, 2, 70, "Message",
  CellTags->"S2.6.12"],
Cell[302955, 11796, 89, 3, 70, "Output",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[303059, 11802, 485, 14, 70, "Text",
  CellTags->{"S2.6.12", "12.13"}],
Cell[303547, 11818, 325, 11, 70, "Text",
  CellTags->{"S2.6.12", "12.14"}],
Cell[303875, 11831, 185, 6, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.15"}],

Cell[CellGroupData[{
Cell[304085, 11841, 104, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[304192, 11845, 108, 3, 70, "Output",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[304315, 11851, 343, 10, 70, "Text",
  CellTags->{"S2.6.12", "12.16"}],
Cell[304661, 11863, 1238, 38, 70, "DefinitionBox",
  CellTags->"S2.6.12"],
Cell[305902, 11903, 76, 1, 70, "Caption",
  CellTags->"S2.6.12"],
Cell[305981, 11906, 968, 34, 70, "Text",
  CellTags->{"S2.6.12", "12.17"}],
Cell[306952, 11942, 230, 8, 70, "MathCaption",
  CellTags->{"S2.6.12", "12.18"}],

Cell[CellGroupData[{
Cell[307207, 11954, 121, 2, 70, "Input",
  CellTags->"S2.6.12"],
Cell[307331, 11958, 62, 2, 70, "Print",
  CellTags->"S2.6.12"],
Cell[307396, 11962, 95, 3, 70, "Output",
  CellTags->"S2.6.12"]
}, Open  ]],
Cell[307506, 11968, 398, 9, 70, "Text",
  CellTags->{"S2.6.12", "12.19"}],
Cell[307907, 11979, 644, 23, 70, "Text",
  CellTags->{"S2.6.12", "12.20"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[308588, 12007, 109, 1, 70, "Subsection",
  CellTags->{"S2.6.13", "13.1"}],
Cell[308700, 12010, 819, 26, 70, "Text",
  CellTags->{"S2.6.13", "13.2"}],
Cell[309522, 12038, 247, 7, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.3"}],

Cell[CellGroupData[{
Cell[309794, 12049, 74, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[309871, 12053, 147, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[310021, 12058, 99, 3, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[310135, 12064, 277, 8, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.4"}],

Cell[CellGroupData[{
Cell[310437, 12076, 79, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[310519, 12080, 147, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[310669, 12085, 99, 3, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[310783, 12091, 525, 14, 70, "DefinitionBox",
  CellTags->"S2.6.13"],
Cell[311311, 12107, 91, 1, 70, "Caption",
  CellTags->"S2.6.13"],
Cell[311405, 12110, 179, 5, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.5"}],

Cell[CellGroupData[{
Cell[311609, 12119, 80, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[311692, 12123, 147, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[311842, 12128, 147, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[311992, 12133, 100, 3, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[312107, 12139, 719, 19, 70, "Text",
  CellTags->{"S2.6.13", "13.6"}],
Cell[312829, 12160, 688, 20, 70, "Text",
  CellTags->{"S2.6.13", "13.7"}],
Cell[313520, 12182, 211, 9, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.8"}],

Cell[CellGroupData[{
Cell[313756, 12195, 103, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[313862, 12199, 84, 3, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[313961, 12205, 134, 4, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.9"}],

Cell[CellGroupData[{
Cell[314120, 12213, 72, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[314195, 12217, 146, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[314344, 12222, 129, 3, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[314488, 12228, 151, 4, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.10"}],
Cell[314642, 12234, 87, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[314732, 12238, 139, 4, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.11"}],

Cell[CellGroupData[{
Cell[314896, 12246, 71, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[314970, 12250, 146, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[315119, 12255, 292, 6, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[315426, 12264, 95, 1, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.12"}],
Cell[315524, 12267, 84, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[315611, 12271, 206, 6, 70, "MathCaption",
  CellTags->{"S2.6.13", "13.13"}],

Cell[CellGroupData[{
Cell[315842, 12281, 70, 2, 70, "Input",
  CellTags->"S2.6.13"],
Cell[315915, 12285, 145, 3, 70, "Message",
  CellTags->"S2.6.13"],
Cell[316063, 12290, 103, 3, 70, "Output",
  CellTags->"S2.6.13"]
}, Open  ]],
Cell[316181, 12296, 615, 14, 70, "Text",
  CellTags->{"S2.6.13", "13.14"}],
Cell[316799, 12312, 860, 22, 70, "Text",
  CellTags->{"S2.6.13", "13.15"}],
Cell[317662, 12336, 1210, 33, 70, "Text",
  CellTags->{"S2.6.13", "13.16"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[318909, 12374, 99, 1, 70, "Subsection",
  CellTags->{"S2.6.14", "14.1"}],
Cell[319011, 12377, 305, 9, 70, "Text",
  CellTags->{"S2.6.14", "14.2"}],
Cell[319319, 12388, 502, 14, 70, "Text",
  CellTags->{"S2.6.14", "14.3"}],
Cell[319824, 12404, 1465, 45, 70, "DefinitionBox",
  CellTags->"S2.6.14"],
Cell[321292, 12451, 65, 1, 70, "Caption",
  CellTags->"S2.6.14"],
Cell[321360, 12454, 276, 9, 70, "Text",
  CellTags->{"S2.6.14", "14.4"}],
Cell[321639, 12465, 419, 13, 70, "Text",
  CellTags->{"S2.6.14", "14.5"}],
Cell[322061, 12480, 193, 6, 70, "MathCaption",
  CellTags->{"S2.6.14", "14.6"}],

Cell[CellGroupData[{
Cell[322279, 12490, 93, 2, 70, "Input",
  CellTags->"S2.6.14"],
Cell[322375, 12494, 57, 2, 70, "Print",
  CellTags->"S2.6.14"],
Cell[322435, 12498, 90, 3, 70, "Output",
  CellTags->"S2.6.14"]
}, Open  ]],
Cell[322540, 12504, 330, 10, 70, "Text",
  CellTags->{"S2.6.14", "14.7"}],
Cell[322873, 12516, 699, 23, 70, "Text",
  CellTags->{"S2.6.14", "14.8"}],
Cell[323575, 12541, 220, 8, 70, "MathCaption",
  CellTags->{"S2.6.14", "14.9"}],

Cell[CellGroupData[{
Cell[323820, 12553, 124, 2, 70, "Input",
  CellTags->"S2.6.14"],
Cell[323947, 12557, 57, 2, 70, "Print",
  CellTags->"S2.6.14"],
Cell[324007, 12561, 57, 2, 70, "Print",
  CellTags->"S2.6.14"],
Cell[324067, 12565, 89, 3, 70, "Output",
  CellTags->"S2.6.14"]
}, Open  ]],
Cell[324171, 12571, 226, 9, 70, "MathCaption",
  CellTags->{"S2.6.14", "14.10"}],

Cell[CellGroupData[{
Cell[324422, 12584, 124, 2, 70, "Input",
  CellTags->"S2.6.14"],
Cell[324549, 12588, 57, 2, 70, "Print",
  CellTags->"S2.6.14"],
Cell[324609, 12592, 57, 2, 70, "Print",
  CellTags->"S2.6.14"],
Cell[324669, 12596, 57, 2, 70, "Print",
  CellTags->"S2.6.14"]
}, Open  ]],
Cell[324741, 12601, 499, 11, 70, "Text",
  CellTags->{"S2.6.14", "14.11"}],
Cell[325243, 12614, 183, 7, 70, "MathCaption",
  CellTags->{"S2.6.14", "14.12"}],

Cell[CellGroupData[{
Cell[325451, 12625, 107, 2, 70, "Input",
  CellTags->"S2.6.14"],
Cell[325561, 12629, 57, 2, 70, "Print",
  CellTags->"S2.6.14"],
Cell[325621, 12633, 90, 3, 70, "Output",
  CellTags->"S2.6.14"]
}, Open  ]],
Cell[325726, 12639, 167, 5, 70, "MathCaption",
  CellTags->{"S2.6.14", "14.13"}],

Cell[CellGroupData[{
Cell[325918, 12648, 122, 2, 70, "Input",
  CellTags->"S2.6.14"],
Cell[326043, 12652, 57, 2, 70, "Print",
  CellTags->"S2.6.14"]
}, Open  ]],
Cell[326115, 12657, 516, 18, 70, "Text",
  CellTags->{"S2.6.14", "14.14"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[326668, 12680, 140, 5, 70, "Subsection",
  CellTags->{"S2.6.15", "15.1"}],
Cell[326811, 12687, 927, 33, 70, "Text",
  CellTags->{"S2.6.15", "15.2"}],
Cell[327741, 12722, 481, 15, 70, "Text",
  CellTags->{"S2.6.15", "15.3"}],
Cell[328225, 12739, 1357, 52, 70, "Text",
  CellTags->{"S2.6.15", "15.4"}],
Cell[329585, 12793, 400, 10, 70, "Text",
  CellTags->{"S2.6.15", "15.5"}],
Cell[329988, 12805, 1452, 42, 70, "DefinitionBox",
  CellTags->"S2.6.15"],
Cell[331443, 12849, 71, 1, 70, "Caption",
  CellTags->"S2.6.15"],
Cell[331517, 12852, 257, 11, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.6"}],

Cell[CellGroupData[{
Cell[331799, 12867, 92, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[331894, 12871, 106, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[332015, 12877, 186, 7, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.7"}],

Cell[CellGroupData[{
Cell[332226, 12888, 92, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[332321, 12892, 176, 5, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[332512, 12900, 242, 8, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.8"}],

Cell[CellGroupData[{
Cell[332779, 12912, 82, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[332864, 12916, 124, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[333003, 12922, 405, 10, 70, "Text",
  CellTags->{"S2.6.15", "15.9"}],
Cell[333411, 12934, 460, 10, 70, "Text",
  CellTags->{"S2.6.15", "15.10"}],
Cell[333874, 12946, 456, 11, 70, "Text",
  CellTags->{"S2.6.15", "15.11"}],
Cell[334333, 12959, 313, 8, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.12"}],

Cell[CellGroupData[{
Cell[334671, 12971, 110, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[334784, 12975, 283, 7, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[335082, 12985, 174, 5, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.13"}],

Cell[CellGroupData[{
Cell[335281, 12994, 72, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[335356, 12998, 102, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[335473, 13004, 108, 3, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.14"}],

Cell[CellGroupData[{
Cell[335606, 13011, 83, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[335692, 13015, 101, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[335808, 13021, 526, 10, 70, "Text",
  CellTags->{"S2.6.15", "15.15"}],
Cell[336337, 13033, 884, 30, 70, "Text",
  CellTags->{"S2.6.15", "15.16"}],
Cell[337224, 13065, 7519, 222, 70, "DefinitionBox",
  CellTags->"S2.6.15"],
Cell[344746, 13289, 76, 1, 70, "Caption",
  CellTags->"S2.6.15"],
Cell[344825, 13292, 298, 6, 70, "Text",
  CellTags->{"S2.6.15", "15.17"}],
Cell[345126, 13300, 745, 23, 70, "Text",
  CellTags->{"S2.6.15", "15.18"}],
Cell[345874, 13325, 325, 15, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.19"}],

Cell[CellGroupData[{
Cell[346224, 13344, 113, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[346340, 13348, 178, 5, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[346533, 13356, 88, 1, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.20"}],

Cell[CellGroupData[{
Cell[346646, 13361, 72, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[346721, 13365, 84, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[346820, 13371, 147, 4, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.21"}],

Cell[CellGroupData[{
Cell[346992, 13379, 117, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[347112, 13383, 185, 5, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[347312, 13391, 156, 4, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.22"}],

Cell[CellGroupData[{
Cell[347493, 13399, 91, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[347587, 13403, 85, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[347687, 13409, 748, 17, 70, "Text",
  CellTags->{"S2.6.15", "15.23"}],
Cell[348438, 13428, 725, 14, 70, "Text",
  CellTags->{"S2.6.15", "15.24"}],
Cell[349166, 13444, 154, 4, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.25"}],
Cell[349323, 13450, 92, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[349418, 13454, 207, 7, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.26"}],

Cell[CellGroupData[{
Cell[349650, 13465, 125, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[349778, 13469, 180, 5, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[349973, 13477, 95, 1, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.27"}],

Cell[CellGroupData[{
Cell[350093, 13482, 75, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[350171, 13486, 102, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[350288, 13492, 489, 12, 70, "Text",
  CellTags->{"S2.6.15", "15.28"}],
Cell[350780, 13506, 137, 4, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.29"}],

Cell[CellGroupData[{
Cell[350942, 13514, 92, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[351037, 13518, 171, 5, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[351223, 13526, 119, 2, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.30"}],

Cell[CellGroupData[{
Cell[351367, 13532, 73, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[351443, 13536, 102, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[351560, 13542, 222, 5, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.31"}],

Cell[CellGroupData[{
Cell[351807, 13551, 75, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[351885, 13555, 198, 4, 70, "Message",
  CellTags->"S2.6.15"],
Cell[352086, 13561, 94, 3, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[352195, 13567, 697, 19, 70, "Text",
  CellTags->{"S2.6.15", "15.32"}],
Cell[352895, 13588, 516, 13, 70, "Text",
  CellTags->{"S2.6.15", "15.33"}],
Cell[353414, 13603, 243, 6, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.34"}],

Cell[CellGroupData[{
Cell[353682, 13613, 74, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[353759, 13617, 199, 4, 70, "Message",
  CellTags->"S2.6.15"],
Cell[353961, 13623, 159, 4, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[354135, 13630, 367, 10, 70, "Text",
  CellTags->{"S2.6.15", "15.35"}],
Cell[354505, 13642, 386, 12, 70, "Text",
  CellTags->{"S2.6.15", "15.36"}],
Cell[354894, 13656, 215, 5, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.37"}],

Cell[CellGroupData[{
Cell[355134, 13665, 161, 5, 70, "Input",
  CellTags->"S2.6.15"],
Cell[355298, 13672, 245, 7, 70, "Output",
  CellTags->"S2.6.15"]
}, Open  ]],
Cell[355558, 13682, 90, 1, 70, "MathCaption",
  CellTags->{"S2.6.15", "15.38"}],

Cell[CellGroupData[{
Cell[355673, 13687, 78, 2, 70, "Input",
  CellTags->"S2.6.15"],
Cell[355754, 13691, 102, 3, 25, "Output",
  CellTags->"S2.6.15"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[355905, 13700, 104, 1, 70, "Subsection",
  CellTags->{"S2.6.16", "16.1"}],
Cell[356012, 13703, 431, 10, 72, "Text",
  CellTags->{"S2.6.16", "16.2"}],
Cell[356446, 13715, 344, 9, 56, "Text",
  CellTags->{"S2.6.16", "16.3"}],
Cell[356793, 13726, 577, 13, 88, "Text",
  CellTags->{"S2.6.16", "16.4"}],
Cell[357373, 13741, 3829, 108, 82, "DefinitionBox",
  CellTags->"S2.6.16"],
Cell[361205, 13851, 83, 1, 16, "Caption",
  CellTags->"S2.6.16"],
Cell[361291, 13854, 172, 5, 40, "MathCaption",
  CellTags->{"S2.6.16", "16.5"}],

Cell[CellGroupData[{
Cell[361488, 13863, 95, 2, 28, "Input",
  CellTags->"S2.6.16"],
Cell[361586, 13867, 256, 6, 74, "Output",
  CellTags->"S2.6.16"]
}, Open  ]],
Cell[361857, 13876, 762, 14, 120, "Text",
  CellTags->{"S2.6.16", "16.6"}],
Cell[362622, 13892, 559, 9, 88, "Text",
  CellTags->{"S2.6.16", "16.7"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

