(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    153490,       5862]*)
(*NotebookOutlinePosition[    239338,       8359]*)
(*  CellTagsIndexPosition[    231412,       8050]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.7 ", "HeadingNumber"],
  "Modularity and the Naming of Things"
}], "Section",
  CellTags->{"S2.7.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.7.1 Modules and Local Variables", "Subsection",
  CellTags->{"S2.7.1", "1.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " normally assumes that all your variables are ",
  StyleBox["global", "TI"],
  ". This means that every time you use a name like ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " normally assumes that you are referring to the ",
  StyleBox["same", "TI"],
  " object. "
}], "Text",
  CellTags->{"S2.7.1", "1.2"}],

Cell[TextData[{
  "Particularly when you write programs, however, you may not want all your \
variables to be global. You may, for example, want to use the name ",
  StyleBox["x", "MR"],
  " to refer to two quite different variables in two different programs. In \
this case, you need the ",
  StyleBox["x", "MR"],
  " in each program to be treated as a ",
  StyleBox["local", "TI"],
  " variable. "
}], "Text",
  CellTags->{"S2.7.1", "1.3"}],

Cell[TextData[{
  "You can set up local variables in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["modules", "TI"],
  ". Within each module, you can give a list of variables which are to be \
treated as local to the module. "
}], "Text",
  CellTags->{"S2.7.1", "1.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Module[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a module with local variables ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.1"],

Cell[TextData[{
  "Creating modules in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.7.1"],

Cell[TextData[{
  "This defines the global variable ",
  StyleBox["t", "MR"],
  " to have value 17. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.5"}],

Cell[CellGroupData[{

Cell["t = 17", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["t", "MR"],
  " inside the module is local, so it can be treated independently of the \
global ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.6"}],

Cell[CellGroupData[{

Cell["Module[{t}, t=8; Print[t]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(8\)], "Print",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "The global ",
  StyleBox["t", "MR"],
  " still has value 17. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.7"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell["\<\
The most common way that modules are used is to set up temporary or \
intermediate variables inside functions you define. It is important to make \
sure that such variables are kept local. If they are not, then you will run \
into trouble whenever their names happen to coincide with the names of other \
variables. \
\>", "Text",
  CellTags->{"S2.7.1", "1.8"}],

Cell[TextData[{
  "The intermediate variable ",
  StyleBox["t", "MR"],
  " is specified to be local to the module. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.9"}],

Cell["f[v_] := Module[{t}, t = (1 + v)^2; t = Expand[t] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.1"],

Cell[TextData[{
  "This runs the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.10"}],

Cell[CellGroupData[{

Cell["f[a + b]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(1 + 2\ a + a\^2 + 2\ b + 2\ a\ b + b\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "The global ",
  StyleBox["t", "MR"],
  " still has value 17. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.11"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell["\<\
You can treat local variables in modules just like other symbols. \
Thus, for example, you can use them as names for local functions, you can \
assign attributes to them, and so on. \
\>", "Text",
  CellTags->{"S2.7.1", "1.12"}],

Cell[TextData[{
  "This sets up a module which defines a local function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.13"}],

Cell["\<\
gfac10[k_] := Module[{f, n}, f[1] = 1; f[n_] := k + n f[n-1]; \
f[10]]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.1"],

Cell[TextData[{
  "In this case, the local function ",
  StyleBox["f", "MR"],
  " is just an ordinary factorial. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.14"}],

Cell[CellGroupData[{

Cell["gfac10[0]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(3628800\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "In this case, ",
  StyleBox["f", "MR"],
  " is set up as a generalized factorial. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.15"}],

Cell[CellGroupData[{

Cell["gfac10[2]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(8841802\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "When you set up a local variable in a module, ",
  StyleBox["Mathematica", "TI"],
  " initially assigns no value to the variable. This means that you can use \
the variable in a purely symbolic way, even if there was a global value \
defined for the variable outside the module. "
}], "Text",
  CellTags->{"S2.7.1", "1.16"}],

Cell[TextData[{
  "This uses the global value of ",
  StyleBox["t", "MR"],
  " defined above, and so yields a number. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.17"}],

Cell[CellGroupData[{

Cell["Expand[(1 + t)^3]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(5832\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["Length", "MR"],
  " simply receives a number as its argument. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.18"}],

Cell[CellGroupData[{

Cell["Length[Expand[(1 + t)^3]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "The local variable ",
  StyleBox["t", "MR"],
  " has no value, so it acts as a symbol, and ",
  StyleBox["Expand", "MR"],
  " produces the anticipated algebraic result. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.19"}],

Cell[CellGroupData[{

Cell["Module[{t}, Length[Expand[(1 + t)^3]]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Module[{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a module with initial values for local variables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.1"],

Cell["Assigning initial values to local variables. ", "Caption",
  CellTags->"S2.7.1"],

Cell[TextData[{
  "This specifies ",
  StyleBox["t", "MR"],
  " to be a local variable, with initial value ",
  StyleBox["u", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.20"}],

Cell["g[u_] := Module[{ t = u }, t += t/(1 + u)]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.7.1"],

Cell[TextData[{
  "This uses the definition of ",
  StyleBox["g", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.21"}],

Cell[CellGroupData[{

Cell["g[a]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(a + a\/\(1 + a\)\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[TextData[{
  "You can define initial values for any of the local variables in a module. \
The initial values are always evaluated before the module is executed. As a \
result, even if a variable ",
  StyleBox["x", "MR"],
  " is defined as local to the module, the global ",
  StyleBox["x", "MR"],
  " will be used if it appears in an expression for an initial value. "
}], "Text",
  CellTags->{"S2.7.1", "1.22"}],

Cell[TextData[{
  "The initial value of ",
  StyleBox["u", "MR"],
  " is taken to be the global value of ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.23"}],

Cell[CellGroupData[{

Cell["Module[{t = 6, u = t}, u^2]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(289\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.7.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["Module[", "MR"],
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["cond", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "share local variables between ",
              StyleBox["rhs", "TI"],
              " and ",
              StyleBox["cond", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.1"],

Cell["Using local variables in definitions with conditions. ", "Caption",
  CellTags->"S2.7.1"],

Cell[TextData[{
  "When you set up ",
  StyleBox["/;", "MR"],
  " conditions for definitions, you often need to introduce temporary \
variables. In many cases, you may want to share these temporary variables \
with the body of the right\[Hyphen]hand side of the definition. ",
  StyleBox["Mathematica", "TI"],
  " allows you to enclose the whole right\[Hyphen]hand side of your \
definition in a module, including the condition. "
}], "Text",
  CellTags->{"S2.7.1", "1.24"}],

Cell["This defines a function with a condition attached. ", "MathCaption",
  CellTags->{"S2.7.1", "1.25"}],

Cell["h[x_] := Module[{t}, t^2 - 1 /; (t = x - 4) > 1]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.7.1"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " shares the value of the local variable ",
  StyleBox["t", "MR"],
  " between the condition and the body of the right\[Hyphen]hand side. "
}], "MathCaption",
  CellTags->{"S2.7.1", "1.26"}],

Cell[CellGroupData[{

Cell["h[10]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.7.1"],

Cell[BoxData[
    \(35\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.7.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.2 Local Constants", "Subsection",
  CellTags->{"S2.7.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["With[{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "define local constants ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.2"],

Cell["Defining local constants. ", "Caption",
  CellTags->"S2.7.2"],

Cell[TextData[{
  StyleBox["Module", "MR"],
  " allows you to set up local ",
  StyleBox["variables", "TI"],
  ", to which you can assign any sequence of values. Often, however, all you \
really need are local ",
  StyleBox["constants", "TI"],
  ", to which you assign a value only once. The ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["With", "MR"],
  " construct allows you to set up such local constants. "
}], "Text",
  CellTags->{"S2.7.2", "2.2"}],

Cell[TextData[{
  "This defines a global value for ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.3"}],

Cell[CellGroupData[{

Cell["t = 17", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "This defines a function using ",
  StyleBox["t", "MR"],
  " as a local constant. "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.4"}],

Cell["w[x_] := With[{t = x + 1}, t + t^3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.2"],

Cell[TextData[{
  "This uses the definition of ",
  StyleBox["w", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.5"}],

Cell[CellGroupData[{

Cell["w[a]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(1 + a + \((1 + a)\)\^3\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["t", "MR"],
  " still has its global value. "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.6"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "Just as in ",
  StyleBox["Module", "MR"],
  ", the initial values you define in ",
  StyleBox["With", "MR"],
  " are evaluated before the ",
  StyleBox["With", "MR"],
  " is executed. "
}], "Text",
  CellTags->{"S2.7.2", "2.7"}],

Cell[TextData[{
  "The expression ",
  StyleBox["t", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " which gives the value of the local constant ",
  StyleBox["t", "MR"],
  " is evaluated using the global ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.8"}],

Cell[CellGroupData[{

Cell["With[{t = t + 1}, t^2]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(324\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "The way ",
  StyleBox["With[{", "MR"],
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["},", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " works is to take ",
  StyleBox["body", "TI"],
  ", and replace every occurrence of ",
  StyleBox["x", "TI"],
  ", etc. in it by ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ", etc. You can think of ",
  StyleBox["With", "MR"],
  " as a generalization of the ",
  StyleBox["/.", "MR"],
  " operator, suitable for application to ",
  StyleBox["Mathematica", "TI"],
  " code instead of other expressions. "
}], "Text",
  CellTags->{"S2.7.2", "2.9"}],

Cell[TextData[{
  "This replaces ",
  StyleBox["x", "MR"],
  " with ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.10"}],

Cell[CellGroupData[{

Cell["With[{x = a}, x = 5]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "After the replacement, the body of the ",
  StyleBox["With", "MR"],
  " is ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["5", "MR"],
  ", so ",
  StyleBox["a", "MR"],
  " gets the global value ",
  StyleBox["5", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.11"}],

Cell[CellGroupData[{

Cell["a", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "This clears the value of ",
  StyleBox["a", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.12"}],

Cell["Clear[a]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.2"],

Cell[TextData[{
  "In some respects, ",
  StyleBox["With", "MR"],
  " is like a special case of ",
  StyleBox["Module", "MR"],
  ", in which each local variable is assigned a value exactly once. "
}], "Text",
  CellTags->{"S2.7.2", "2.13"}],

Cell[TextData[{
  "One of the main reasons for using ",
  StyleBox["With", "MR"],
  " rather than ",
  StyleBox["Module", "MR"],
  " is that it typically makes the ",
  StyleBox["Mathematica", "TI"],
  " programs you write easier to understand. In a module, if you see a local \
variable ",
  StyleBox["x", "TI"],
  " at a particular point, you potentially have to trace through all of the \
code in the module to work out the value of ",
  StyleBox["x", "TI"],
  " at that point. In a ",
  StyleBox["With", "MR"],
  " construct, however, you can always find out the value of a local constant \
simply by looking at the initial list of values, without having to trace \
through specific code. "
}], "Text",
  CellTags->{"S2.7.2", "2.14"}],

Cell[TextData[{
  "If you have several ",
  StyleBox["With", "MR"],
  " constructs, it is always the innermost one for a particular variable that \
is in effect. You can mix ",
  StyleBox["Module", "MR"],
  " and ",
  StyleBox["With", "MR"],
  ". The general rule is that the innermost one for a particular variable is \
the one that is in effect. "
}], "Text",
  CellTags->{"S2.7.2", "2.15"}],

Cell[TextData[{
  "With nested ",
  StyleBox["With", "MR"],
  " constructs, the innermost one is always the one in effect. "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.16"}],

Cell[CellGroupData[{

Cell["With[{t = 8}, With[{t = 9}, t^2]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(81\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "You can mix ",
  StyleBox["Module", "MR"],
  " and ",
  StyleBox["With", "MR"],
  " constructs. "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.17"}],

Cell[CellGroupData[{

Cell["Module[{t = 8}, With[{t = 9}, t^2]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(81\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell["\<\
Local variables in inner constructs do not mask ones outside unless \
the names conflict. \
\>", "MathCaption",
  CellTags->{"S2.7.2", "2.18"}],

Cell[CellGroupData[{

Cell["With[{t = a}, With[{u = b}, t + u]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(a + b\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.2"]
}, Open  ]],

Cell[TextData[{
  "Except for the question of when ",
  StyleBox["x", "TI"],
  " and ",
  StyleBox["body", "TI"],
  " are evaluated, ",
  StyleBox["With[{", "MR"],
  StyleBox["x", "TI"],
  " ",
  StyleBox["=", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " works essentially like ",
  StyleBox["body", "TI"],
  " ",
  StyleBox["/.", "MR"],
  " ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["->", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["x",
            "TI"], "0"], TraditionalForm]], "InlineFormula"],
  ". However, ",
  StyleBox["With", "MR"],
  " behaves in a special way when the expression ",
  StyleBox["body", "TI"],
  " itself contains ",
  StyleBox["With", "MR"],
  " or ",
  StyleBox["Module", "MR"],
  " constructs. The main issue is to prevent the local constants in the \
various ",
  StyleBox["With", "MR"],
  " constructs from conflicting with each other, or with global objects. The \
details of how this is done are discussed in Section ",
  ButtonBox["2.7.3",
    ButtonData:>{"2.7.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.7.2", "2.19"}],

Cell[TextData[{
  "The ",
  StyleBox["y", "MR"],
  " in the inner ",
  StyleBox["With", "MR"],
  " is renamed to prevent it from conflicting with the global ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.2", "2.20"}],

Cell[CellGroupData[{

Cell["With[{x = 2 + y}, Hold[With[{y = 4}, x + y]]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.2"],

Cell[BoxData[
    \(Hold[With[{y$ = 4}, \((2 + y)\) + y$]]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.7.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.3 How Modules Work", "Subsection",
  CellTags->{"S2.7.3", "3.1"}],

Cell[TextData[{
  "The way modules work in ",
  StyleBox["Mathematica", "TI"],
  " is basically very simple. Every time any module is used, a new symbol is \
created to represent each of its local variables. The new symbol is given a \
unique name which cannot conflict with any other names. The name is formed by \
taking the name you specify for the local variable, followed by ",
  StyleBox["$", "MR"],
  ", with a unique \[OpenCurlyDoubleQuote]serial number\
\[CloseCurlyDoubleQuote] appended. "
}], "Text",
  CellTags->{"S2.7.3", "3.2"}],

Cell[TextData[{
  "The serial number is found from the value of the global variable ",
  StyleBox["$ModuleNumber", "MR"],
  ". This variable counts the total number of times any ",
  StyleBox["Module", "MR"],
  " of any form has been used. "
}], "Text",
  CellTags->{"S2.7.3", "3.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[FilledSmallSquare] ",
              StyleBox["Module", "MR"],
              " generates symbols with names of the form ",
              StyleBox["x", "TI"],
              StyleBox["$", "MR"],
              StyleBox["nnn", "TI"],
              " to represent each local variable. "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.3"],

Cell[TextData[{
  "The basic principle of modules in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.7.3"],

Cell[TextData[{
  "This shows the symbol generated for ",
  StyleBox["t", "MR"],
  " within the module. "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.4"}],

Cell[CellGroupData[{

Cell["Module[{t}, Print[t]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(t$1\)], "Print",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["The symbols are different every time any module is used. ", \
"MathCaption",
  CellTags->{"S2.7.3", "3.5"}],

Cell[CellGroupData[{

Cell["Module[{t, u}, Print[t]; Print[u]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(t$2\)], "Print",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(u$2\)], "Print",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "For most purposes, you will never have to deal directly with the actual \
symbols generated inside modules. However, if for example you start up a \
dialog while a module is being executed, then you will see these symbols. The \
same is true whenever you use functions like ",
  StyleBox["Trace", "MR"],
  " to watch the evaluation of modules. "
}], "Text",
  CellTags->{"S2.7.3", "3.6"}],

Cell[TextData[{
  "You see the symbols that are generated inside modules when you use ",
  StyleBox["Trace", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.7"}],

Cell[CellGroupData[{

Cell["Trace[ Module[{t}, t = 3] ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(Module[{t}, t = 3]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{
            TagBox[\(t$3 = 3\),
              HoldForm], ",", 
            TagBox["3",
              HoldForm]}], "}"}], ",", 
        TagBox["3",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["This starts a dialog inside a module. ", "MathCaption",
  CellTags->{"S2.7.3", "3.8"}],

Cell["Module[{t}, t = 6; Dialog[ ]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.3"],

Cell[TextData[{
  "Inside the dialog, you see the symbols generated for local variables such \
as ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.9"}],

Cell[CellGroupData[{

Cell["Stack[_]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(Module[{t}, t = 6; Dialog[]]\),
          HoldForm], ",", 
        TagBox[\(t$4 = 6; Dialog[]\),
          HoldForm], ",", 
        TagBox[\(Dialog[]\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["\<\
You can work with these symbols as you would with any other \
symbols. \
\>", "MathCaption",
  CellTags->{"S2.7.3", "3.10"}],

Cell[CellGroupData[{

Cell["t$4 + 1", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["This returns from the dialog. ", "MathCaption",
  CellTags->{"S2.7.3", "3.11"}],

Cell[CellGroupData[{

Cell["Return[t$4 ^ 2]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(36\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["\<\
Under some circumstances, it is convenient explicitly to return \
symbols that are generated inside modules. \
\>", "Text",
  CellTags->{"S2.7.3", "3.12"}],

Cell["\<\
You can explicitly return symbols that are generated inside \
modules. \
\>", "MathCaption",
  CellTags->{"S2.7.3", "3.13"}],

Cell[CellGroupData[{

Cell["Module[{t}, t]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(t$6\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["You can treat these symbols as you would any others. ", "MathCaption",
  CellTags->{"S2.7.3", "3.14"}],

Cell[CellGroupData[{

Cell["%^2 + 1", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(1 + t$6\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Unique[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a new symbol with a unique name of the form ",
              StyleBox["x", "TI"],
              StyleBox["$", "MR"],
              StyleBox["nnn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Unique[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["generate a list of new symbols "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.3"],

Cell["Generating new symbols with unique names. ", "Caption",
  CellTags->"S2.7.3"],

Cell[TextData[{
  "The function ",
  StyleBox["Unique", "MR"],
  " allows you to generate new symbols in the same way as ",
  StyleBox["Module", "MR"],
  " does. Each time you call ",
  StyleBox["Unique", "MR"],
  ", ",
  StyleBox["$ModuleNumber", "MR"],
  " is incremented, so that the names of new symbols are guaranteed to be \
unique. "
}], "Text",
  CellTags->{"S2.7.3", "3.15"}],

Cell[TextData[{
  "This generates a unique new symbol whose name starts with ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.16"}],

Cell[CellGroupData[{

Cell["Unique[x]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(x$7\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "Each time you call ",
  StyleBox["Unique", "MR"],
  " you get a symbol with a larger serial number. "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.17"}],

Cell[CellGroupData[{

Cell["{Unique[x], Unique[x], Unique[x]}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \({x$8, x$9, x$10}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "If you call ",
  StyleBox["Unique", "MR"],
  " with a list of names, you get the same serial number for each of the \
symbols. "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.18"}],

Cell[CellGroupData[{

Cell["Unique[{x, xa, xb}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \({x$11, xa$11, xb$11}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "You can use the standard ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["?", "MR"],
  StyleBox["name", "TI"],
  " mechanism to get information on symbols that were generated inside \
modules or by the function ",
  StyleBox["Unique", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.3", "3.19"}],

Cell[TextData[{
  "Executing this module generates the symbol ",
  StyleBox["q$", "MR"],
  StyleBox["nnn", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.20"}],

Cell[CellGroupData[{

Cell["Module[{q}, q^2 + 1]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(1 + q$12\^2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["You can see the generated symbol here. ", "MathCaption",
  CellTags->{"S2.7.3", "3.21"}],

Cell[CellGroupData[{

Cell["?q*", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.7.3"],

Cell["q    q$12", "Print",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "Symbols generated by ",
  StyleBox["Module", "MR"],
  " behave in exactly the same way as other symbols for the purposes of \
evaluation. However, these symbols carry the attribute ",
  StyleBox["Temporary", "MR"],
  ", which specifies that they should be removed completely from the system \
when they are no longer used. Thus most symbols that are generated inside \
modules are removed when the execution of those modules is finished. The \
symbols survive only if they are explicitly returned. "
}], "Text",
  CellTags->{"S2.7.3", "3.22"}],

Cell[TextData[{
  "This shows a new ",
  StyleBox["q", "MR"],
  " variable generated inside a module. "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.23"}],

Cell[CellGroupData[{

Cell["Module[{q}, Print[q]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(q$13\)], "Print",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell["\<\
The new variable is removed when the execution of the module is \
finished, so it does not show up here. \
\>", "MathCaption",
  CellTags->{"S2.7.3", "3.24"}],

Cell[CellGroupData[{

Cell["?q*", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.7.3"],

Cell["q    q$12", "Print",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "You should realize that the use of names such as ",
  StyleBox["x", "TI"],
  StyleBox["$", "MR"],
  StyleBox["nnn", "TI"],
  " for generated symbols is purely a convention. You can in principle give \
any symbol a name of this form. But if you do, the symbol may collide with \
one that is produced by ",
  StyleBox["Module", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.3", "3.25"}],

Cell[TextData[{
  "An important point to note is that symbols generated by ",
  StyleBox["Module", "MR"],
  " are in general unique only within a particular ",
  StyleBox["Mathematica", "TI"],
  " session. The variable ",
  StyleBox["$ModuleNumber", "MR"],
  " which determines the serial numbers for these symbols is always reset at \
the beginning of each session. "
}], "Text",
  CellTags->{"S2.7.3", "3.26"}],

Cell["\<\
This means in particular that if you save expressions containing \
generated symbols in a file, and then read them into another session, there \
is no guarantee that conflicts will not occur. \
\>", "Text",
  CellTags->{"S2.7.3", "3.27"}],

Cell[TextData[{
  "One way to avoid such conflicts is explicitly to set ",
  StyleBox["$ModuleNumber", "MR"],
  " differently at the beginning of each session. In particular, if you set \
",
  StyleBox["$ModuleNumber", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["10^10", "MR"],
  " ",
  StyleBox["$SessionID", "MR"],
  ", you should avoid any conflicts. The global variable ",
  StyleBox["$SessionID", "MR"],
  " should give a unique number which characterizes a particular ",
  StyleBox["Mathematica", "TI"],
  " session on a particular computer. The value of this variable is \
determined from such quantities as the absolute date and time, the ID of your \
computer, and, if appropriate, the ID of the particular ",
  StyleBox["Mathematica", "TI"],
  " process. "
}], "Text",
  CellTags->{"S2.7.3", "3.28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$ModuleNumber", "MR"],
              " "
            }]], Cell[TextData[{
              "the serial number for symbols generated by ",
              StyleBox["Module", "MR"],
              " and ",
              StyleBox["Unique", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$SessionID", "MR"],
              " "
            }]], Cell[TextData[{
              "a number that should be different for every ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.3"],

Cell["\<\
Variables to be used in determining serial numbers for generated \
symbols. \
\>", "Caption",
  CellTags->"S2.7.3"],

Cell[TextData[{
  "Having generated appropriate symbols to represent the local variables you \
have specified, ",
  StyleBox["Module[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " then has to evaluate ",
  StyleBox["body", "TI"],
  " using these symbols. The first step is to take the actual expression ",
  StyleBox["body", "TI"],
  " as it appears inside the module, and effectively to use ",
  StyleBox["With", "MR"],
  " to replace all occurrences of each local variable name with the \
appropriate generated symbol. After this is done, ",
  StyleBox["Module", "MR"],
  " actually performs the evaluation of the resulting expression. "
}], "Text",
  CellTags->{"S2.7.3", "3.29"}],

Cell[TextData[{
  "An important point to note is that ",
  StyleBox["Module[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " inserts generated symbols only into the actual expression ",
  StyleBox["body", "TI"],
  ". It does not, for example, insert such symbols into code that is called \
from ",
  StyleBox["body", "TI"],
  ", but does not explicitly appear in ",
  StyleBox["body", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.7.3", "3.30"}],

Cell[TextData[{
  "Section ",
  ButtonBox["2.7.6",
    ButtonData:>{"2.7.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how you can use ",
  StyleBox["Block", "MR"],
  " to set up \[OpenCurlyDoubleQuote]local values\[CloseCurlyDoubleQuote] \
which work in a different way. "
}], "Text",
  CellTags->{"S2.7.3", "3.31"}],

Cell[TextData[{
  "Since ",
  StyleBox["x", "MR"],
  " does not appear explicitly in the body of the module, the local value is \
not used. "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.32"}],

Cell[CellGroupData[{

Cell["tmp = x^2 + 1; Module[{x = 4}, tmp]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(1 + x\^2\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.7.3"]
}, Open  ]],

Cell[TextData[{
  "Most of the time, you will probably set up modules by giving explicit ",
  StyleBox["Mathematica", "TI"],
  " input of the form ",
  StyleBox["Module[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  ". Since the function ",
  StyleBox["Module", "MR"],
  " has the attribute ",
  StyleBox["HoldAll", "MR"],
  ", the form of ",
  StyleBox["body", "TI"],
  " will usually be kept unevaluated until the module is executed. "
}], "Text",
  CellTags->{"S2.7.3", "3.33"}],

Cell[TextData[{
  "It is, however, possible to build modules dynamically in ",
  StyleBox["Mathematica", "TI"],
  ". The generation of new symbols, and their insertion into ",
  StyleBox["body", "TI"],
  " are always done only when a module is actually executed, not when the \
module is first given as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "Text",
  CellTags->{"S2.7.3", "3.34"}],

Cell[TextData[{
  "This evaluates the body of the module immediately, making ",
  StyleBox["x", "MR"],
  " appear explicitly. "
}], "MathCaption",
  CellTags->{"S2.7.3", "3.35"}],

Cell[CellGroupData[{

Cell["tmp = x^2 + 1; Module[{x = 4}, Evaluate[tmp]]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.7.3"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.7.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.4 Advanced Topic: Variables in Pure Functions and Rules", \
"Subsection",
  CellTags->{"S2.7.4", "4.1"}],

Cell[TextData[{
  StyleBox["Module", "MR"],
  " and ",
  StyleBox["With", "MR"],
  " allow you to give a specific list of symbols whose names you want to \
treat as local. In some situations, however, you want to automatically treat \
certain symbol names as local. "
}], "Text",
  CellTags->{"S2.7.4", "4.2"}],

Cell[TextData[{
  "For example, if you use a pure function such as ",
  StyleBox["Function[{x},", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["a]", "MR"],
  ", you want ",
  StyleBox["x", "MR"],
  " to be treated as a \[OpenCurlyDoubleQuote]formal parameter\
\[CloseCurlyDoubleQuote], whose specific name is local. The same is true of \
the ",
  StyleBox["x", "MR"],
  " that appears in a rule like ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  ", or a definition like ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["x^2", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.4", "4.3"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses a uniform scheme to make sure that the names of formal parameters \
which appear in constructs like pure functions and rules are kept local, and \
are never confused with global names. The basic idea is to replace formal \
parameters when necessary by symbols with names of the form ",
  StyleBox["x", "TI"],
  StyleBox["$", "MR"],
  ". By convention, ",
  StyleBox["x", "TI"],
  StyleBox["$", "MR"],
  " is never used as a global name. "
}], "Text",
  CellTags->{"S2.7.4", "4.4"}],

Cell["Here is a nested pure function. ", "MathCaption",
  CellTags->{"S2.7.4", "4.5"}],

Cell[CellGroupData[{

Cell["Function[{x}, Function[{y}, x + y]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x}, Function[{y}, x + y]]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " renames the formal parameter ",
  StyleBox["y", "MR"],
  " in the inner function to avoid conflict with the global object ",
  StyleBox["y", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.6"}],

Cell[CellGroupData[{

Cell["%[2y]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{y$}, 2\ y + y$]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["The resulting pure function behaves as it should. ", "MathCaption",
  CellTags->{"S2.7.4", "4.7"}],

Cell[CellGroupData[{

Cell["%[a]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(a + 2\ y\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "In general, ",
  StyleBox["Mathematica", "TI"],
  " renames the formal parameters in an object like ",
  StyleBox["Function[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " whenever ",
  StyleBox["body", "TI"],
  " is modified in any way by the action of another pure function. "
}], "Text",
  CellTags->{"S2.7.4", "4.8"}],

Cell[TextData[{
  "The formal parameter ",
  StyleBox["y", "MR"],
  " is renamed because the body of the inner pure function was changed. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.9"}],

Cell[CellGroupData[{

Cell["Function[{x}, Function[{y}, x + y]] [a]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{y$}, a + y$]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["\<\
Since the body of the inner function does not change, the formal \
parameter is not renamed. \
\>", "MathCaption",
  CellTags->{"S2.7.4", "4.10"}],

Cell[CellGroupData[{

Cell["Function[{x}, x + Function[{y}, y^2]] [a]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(a + Function[{y}, y\^2]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " renames formal parameters in pure functions more liberally than is \
strictly necessary. In principle, renaming could be avoided if the names of \
the formal parameters in a particular function do not actually conflict with \
parts of expressions substituted into the body of the pure function. For \
uniformity, however, ",
  StyleBox["Mathematica", "TI"],
  " still renames formal parameters even in such cases. "
}], "Text",
  CellTags->{"S2.7.4", "4.11"}],

Cell[TextData[{
  "In this case, the formal parameter ",
  StyleBox["x", "MR"],
  " in the inner function shields the body of the function, so no renaming is \
needed."
}], "MathCaption",
  CellTags->{"S2.7.4", "4.12"}],

Cell[CellGroupData[{

Cell["Function[{x}, Function[{x}, x + y]] [a]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x}, x + y]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["Here are three nested functions. ", "MathCaption",
  CellTags->{"S2.7.4", "4.13"}],

Cell[CellGroupData[{

Cell["Function[{x}, Function[{y}, Function[{z}, x + y + z]]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x}, Function[{y}, Function[{z}, x + y + z]]]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["Both inner functions are renamed in this case. ", "MathCaption",
  CellTags->{"S2.7.4", "4.14"}],

Cell[CellGroupData[{

Cell["%[a]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{y$}, Function[{z$}, a + y$ + z$]]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "As mentioned in Section\[NonBreakingSpace]",
  ButtonBox["2.2.5",
    ButtonData:>{"2.2.5", "5.14"},
    ButtonStyle->"MainBookLink"],
  ", pure functions in ",
  StyleBox["Mathematica", "TI"],
  " are like ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " expressions in formal logic. The renaming of formal parameters allows ",
  StyleBox["Mathematica", "TI"],
  " pure functions to reproduce all the semantics of standard ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda]\)], "InlineFormula"],
  " expressions faithfully. "
}], "Text",
  CellTags->{"S2.7.4", "4.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Function[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["local parameters "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":>", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell["local pattern names "]},
          {Cell[TextData[{
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " \[ThinSpace]and \[ThinSpace]",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              " "
            }]], Cell["local pattern names "]},
          {Cell[TextData[{
              StyleBox["With[{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["local constants "]},
          {Cell[TextData[{
              StyleBox["Module[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["local variables "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.4"],

Cell[TextData[{
  "Scoping constructs in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.7.4"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " has several \[OpenCurlyDoubleQuote]scoping constructs\
\[CloseCurlyDoubleQuote] in which certain names are treated as local. When \
you mix these constructs in any way, ",
  StyleBox["Mathematica", "TI"],
  " does appropriate renamings to avoid conflicts. "
}], "Text",
  CellTags->{"S2.7.4", "4.16"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " renames the formal parameter of the pure function to avoid a conflict. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.17"}],

Cell[CellGroupData[{

Cell["With[{x = a}, Function[{a}, a + x]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{a$}, a$ + a]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "Here the local constant in the inner ",
  StyleBox["With", "MR"],
  " is renamed to avoid a conflict. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.18"}],

Cell[CellGroupData[{

Cell["With[{x = y}, Hold[With[{y = 4}, x + y]]]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Hold[With[{y$ = 4}, y + y$]]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["\<\
There is no conflict between names in this case, so no renaming is \
done. \
\>", "MathCaption",
  CellTags->{"S2.7.4", "4.19"}],

Cell[CellGroupData[{

Cell["With[{x = y}, Hold[With[{z = x + 2}, z + 2]]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Hold[With[{z = y + 2}, z + 2]]\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "The local variable ",
  StyleBox["y", "MR"],
  " in the module is renamed to avoid a conflict. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.20"}],

Cell[CellGroupData[{

Cell["With[{x = y}, Hold[Module[{y}, x + y]]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Hold[Module[{y$}, y + y$]]\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["\<\
If you execute the module, however, the local variable is renamed \
again to make its name unique. \
\>", "MathCaption",
  CellTags->{"S2.7.4", "4.21"}],

Cell[CellGroupData[{

Cell["ReleaseHold[%]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(y + y$1\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats transformation rules as scoping constructs, in which the names you \
give to patterns are local. You can set up named patterns either using ",
  StyleBox["x", "TI"],
  StyleBox["_", "MR"],
  ", ",
  StyleBox["x", "TI"],
  StyleBox["__", "MR"],
  " and so on, or using ",
  StyleBox["x", "TI"],
  StyleBox[":", "MR"],
  StyleBox["patt", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.7.4", "4.22"}],

Cell[TextData[{
  "The ",
  StyleBox["x", "MR"],
  " in the ",
  StyleBox["h", "MR"],
  " goes with the ",
  StyleBox["x_", "MR"],
  ", and is considered local to the rule. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.23"}],

Cell[CellGroupData[{

Cell["With[{x = 5}, g[x_, x] -> h[x]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(g[x_, 5] \[Rule] h[x]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "In a rule like ",
  StyleBox["f[x_]", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "MR"],
  ", the ",
  StyleBox["x", "MR"],
  " which appears on the right\[Hyphen]hand side goes with the name of the ",
  StyleBox["x_", "MR"],
  " pattern. As a result, this ",
  StyleBox["x", "MR"],
  " is treated as a variable local to the rule, and cannot be modified by \
other scoping constructs. "
}], "Text",
  CellTags->{"S2.7.4", "4.24"}],

Cell[TextData[{
  "The ",
  StyleBox["y", "MR"],
  ", on the other hand, is not local to the rule, and ",
  StyleBox["can", "TI"],
  " be modified by other scoping constructs. When this happens, ",
  StyleBox["Mathematica", "TI"],
  " renames the patterns in the rule to prevent the possibility of a \
conflict. "
}], "Text",
  CellTags->{"S2.7.4", "4.25"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " renames the ",
  StyleBox["x", "MR"],
  " in the rule to prevent a conflict. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.26"}],

Cell[CellGroupData[{

Cell["With[{w = x}, f[x_] -> w + x]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(f[x$_] \[Rule] x + x$\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["With", "MR"],
  " on a scoping construct, ",
  StyleBox["Mathematica", "TI"],
  " automatically performs appropriate renamings. In some cases, however, you \
may want to make substitutions inside scoping constructs, without any \
renaming. You can do this using the ",
  StyleBox["/.", "MR"],
  " operator. "
}], "Text",
  CellTags->{"S2.7.4", "4.27"}],

Cell[TextData[{
  "When you substitute for ",
  StyleBox["y", "MR"],
  " using ",
  StyleBox["With", "MR"],
  ", the ",
  StyleBox["x", "MR"],
  " in the pure function is renamed to prevent a conflict. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.28"}],

Cell[CellGroupData[{

Cell["With[{y = x + a}, Function[{x}, x + y]]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x$}, x$ + \((a + x)\)]\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "If you use ",
  StyleBox["/.", "MR"],
  " rather than ",
  StyleBox["With", "MR"],
  ", no such renaming is done. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.29"}],

Cell[CellGroupData[{

Cell["Function[{x}, x + y] /. y -> a + x", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x}, x + \((a + x)\)]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell[TextData[{
  "When you apply a rule such as ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["_]", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", or use a definition such as ",
  StyleBox["f", "TI"],
  StyleBox["[", "MR"],
  StyleBox["x", "TI"],
  StyleBox["_]", "MR"],
  " ",
  StyleBox[":=", "MR"],
  " ",
  StyleBox["rhs", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " implicitly has to substitute for ",
  StyleBox["x", "TI"],
  " everywhere in the expression ",
  StyleBox["rhs", "TI"],
  ". It effectively does this using the ",
  StyleBox["/.", "MR"],
  " operator. As a result, such substitution does not respect scoping \
constructs. However, when the insides of a scoping construct are modified by \
the substitution, the other variables in the scoping construct are renamed. "
}], "Text",
  CellTags->{"S2.7.4", "4.30"}],

Cell["This defines a function for creating pure functions. ", "MathCaption",
  CellTags->{"S2.7.4", "4.31"}],

Cell["mkfun[var_, body_] := Function[{var}, body]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.7.4"],

Cell[TextData[{
  "The ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["x^2", "MR"],
  " are explicitly inserted into the pure function, effectively by using the \
",
  StyleBox["/.", "MR"],
  " operator. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.32"}],

Cell[CellGroupData[{

Cell["mkfun[x, x^2]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x}, x\^2]\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.7.4"]
}, Open  ]],

Cell["\<\
This defines a function that creates a pair of nested pure \
functions. \
\>", "MathCaption",
  CellTags->{"S2.7.4", "4.33"}],

Cell["\<\
mkfun2[var_, body_] := Function[{x}, Function[{var}, body + \
x]]\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.7.4"],

Cell[TextData[{
  "The ",
  StyleBox["x", "MR"],
  " in the outer pure function is renamed in this case. "
}], "MathCaption",
  CellTags->{"S2.7.4", "4.34"}],

Cell[CellGroupData[{

Cell["mkfun2[x, x^2]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.7.4"],

Cell[BoxData[
    \(Function[{x$}, Function[{x}, x\^2 + x$]]\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.7.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.5 Dummy Variables in Mathematics", "Subsection",
  CellTags->{"S2.7.5", "5.1"}],

Cell[TextData[{
  "When you set up mathematical formulas, you often have to introduce various \
kinds of local objects or \[OpenCurlyDoubleQuote]dummy variables\
\[CloseCurlyDoubleQuote]. You can treat such dummy variables using modules \
and other ",
  StyleBox["Mathematica", "TI"],
  " scoping constructs. "
}], "Text",
  CellTags->{"S2.7.5", "5.2"}],

Cell["\<\
Integration variables are a common example of dummy variables in \
mathematics. When you write down a formal integral, conventional notation \
requires you to introduce an integration variable with a definite name. This \
variable is essentially \[OpenCurlyDoubleQuote]local\[CloseCurlyDoubleQuote] \
to the integral, and its name, while arbitrary, must not conflict with any \
other names in your mathematical expression. \
\>", "Text",
  CellTags->{"S2.7.5", "5.3"}],

Cell["Here is a function for evaluating an integral. ", "MathCaption",
  CellTags->{"S2.7.5", "5.4"}],

Cell["p[n_] := Integrate[f[s] s^n, {s, 0, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.5"],

Cell[TextData[{
  "The ",
  StyleBox["s", "MR"],
  " here conflicts with the integration variable. "
}], "MathCaption",
  CellTags->{"S2.7.5", "5.5"}],

Cell[CellGroupData[{

Cell["p[s + 1]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.5"],

Cell[BoxData[
    \(\[Integral]\_0\%1\( s\^\(1 + s\)\ f[s]\) \[DifferentialD]s\)], "Output",\

  CellLabel->"Out[2]= ",
  CellTags->"S2.7.5"]
}, Open  ]],

Cell["\<\
Here is a definition with the integration variable specified as \
local to a module. \
\>", "MathCaption",
  CellTags->{"S2.7.5", "5.6"}],

Cell["pm[n_] := Module[{s}, Integrate[f[s] s^n, {s, 0, 1}]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.5"],

Cell[TextData[{
  "Since you have used a module, ",
  StyleBox["Mathematica", "TI"],
  " automatically renames the integration variable to avoid a conflict. "
}], "MathCaption",
  CellTags->{"S2.7.5", "5.7"}],

Cell[CellGroupData[{

Cell["pm[s + 1]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.5"],

Cell[BoxData[
    \(\[Integral]\_0\%1\( s$20\^\(1 + s\)\ f[
            s$20]\) \[DifferentialD]s$20\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.5"]
}, Open  ]],

Cell[TextData[{
  "In many cases, the most important issue is that dummy variables should be \
kept local, and should not interfere with other variables in your \
mathematical expression. In some cases, however, what is instead important is \
that different uses of the ",
  StyleBox["same", "TI"],
  " dummy variable should not conflict. "
}], "Text",
  CellTags->{"S2.7.5", "5.8"}],

Cell["\<\
Repeated dummy variables often appear in products of vectors and \
tensors. With the \[OpenCurlyDoubleQuote]summation convention\
\[CloseCurlyDoubleQuote], any vector or tensor index that appears exactly \
twice is summed over all its possible values. The actual name of the repeated \
index never matters, but if there are two separate repeated indices, it is \
essential that their names do not conflict. \
\>", "Text",
  CellTags->{"S2.7.5", "5.9"}],

Cell[TextData[{
  "This sets up the repeated index ",
  StyleBox["j", "MR"],
  " as a dummy variable. "
}], "MathCaption",
  CellTags->{"S2.7.5", "5.10"}],

Cell["q[i_] := Module[{j}, a[i, j] b[j]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.5"],

Cell["\<\
The module gives different instances of the dummy variable \
different names. \
\>", "MathCaption",
  CellTags->{"S2.7.5", "5.11"}],

Cell[CellGroupData[{

Cell["q[i1] q[i2]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.5"],

Cell[BoxData[
    \(a[i1, j$29]\ a[i2, j$30]\ b[j$29]\ b[j$30]\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.5"]
}, Open  ]],

Cell[TextData[{
  "There are many situations in mathematics where you need to have variables \
with unique names. One example is in representing solutions to equations. \
With an equation like ",
  Cell[BoxData[
      FormBox[
        RowBox[{"sin", 
          RowBox[{"(", 
            StyleBox["x",
              "TI"], ")"}], "=", "0"}], TraditionalForm]], "InlineFormula"],
  ", there are an infinite number of solutions, each of the form ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            "TI"], "=", 
          StyleBox["n",
            "TI"], "\[Pi]"}], TraditionalForm]], "InlineFormula"],
  ", where ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is a dummy variable that can be equal to any integer. If you generate \
solutions to the equation on two separate occasions, there is no guarantee \
that the value of ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " should be the same in both cases. As a result, you must set up the \
solution so that the object ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  " is different every time. "
}], "Text",
  CellTags->{"S2.7.5", "5.12"}],

Cell[TextData[{
  "This defines a value for ",
  StyleBox["sinsol", "MR"],
  ", with ",
  StyleBox["n", "MR"],
  " as a dummy variable. "
}], "MathCaption",
  CellTags->{"S2.7.5", "5.13"}],

Cell["sinsol := Module[{n}, n Pi]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.5"],

Cell["\<\
Different occurrences of the dummy variable are distinguished. \
\
\>", "MathCaption",
  CellTags->{"S2.7.5", "5.14"}],

Cell[CellGroupData[{

Cell["sinsol - sinsol", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.5"],

Cell[BoxData[
    \(n$31\ \[Pi] - n$32\ \[Pi]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.5"]
}, Open  ]],

Cell[TextData[{
  "Another place where unique objects are needed is in representing \
\[OpenCurlyDoubleQuote]constants of integration\[CloseCurlyDoubleQuote]. When \
you do an integral, you are effectively solving an equation for a derivative. \
In general, there are many possible solutions to the equation, differing by \
additive \[OpenCurlyDoubleQuote]constants of integration\
\[CloseCurlyDoubleQuote]. The standard ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["Integrate", "MR"],
  " function always returns a solution with no constant of integration. But \
if you were to introduce constants of integration, you would need to use \
modules to make sure that they are always unique. "
}], "Text",
  CellTags->{"S2.7.5", "5.15"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.6 Blocks and Local Values", "Subsection",
  CellTags->{"S2.7.6", "6.1"}],

Cell[TextData[{
  "Modules in ",
  StyleBox["Mathematica", "TI"],
  " allow you to treat the ",
  StyleBox["names", "TI"],
  " of variables as local. Sometimes, however, you want the names to be \
global, but ",
  StyleBox["values", "TI"],
  " to be local. You can do this in ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["Block", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Block[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "evaluate ",
              StyleBox["body", "TI"],
              " using local values for ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Block[{", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "0"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "assign initial values to ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.6"],

Cell["Setting up local values. ", "Caption",
  CellTags->"S2.7.6"],

Cell[TextData[{
  "Here is an expression involving ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.3"}],

Cell[CellGroupData[{

Cell["x^2 + 3", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(3 + x\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "This evaluates the previous expression, using a local value for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.4"}],

Cell[CellGroupData[{

Cell["Block[{x = a + 1}, %]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(3 + \((1 + a)\)\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "There is no global value for ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.5"}],

Cell[CellGroupData[{

Cell["x", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "As described in the sections above, the variable ",
  StyleBox["x", "TI"],
  " in a module such as ",
  StyleBox["Module[{", "MR"],
  StyleBox["x", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " is always set up to refer to a unique symbol, different each time the \
module is used, and distinct from the global symbol ",
  StyleBox["x", "TI"],
  ". The ",
  StyleBox["x", "TI"],
  " in a block such as ",
  StyleBox["Block[{", "MR"],
  StyleBox["x", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " is, however, taken to be the global symbol ",
  StyleBox["x", "TI"],
  ". What the block does is to make the ",
  StyleBox["value", "TI"],
  " of ",
  StyleBox["x", "TI"],
  " local. The value ",
  StyleBox["x", "TI"],
  " had when you entered the block is always restored when you exit the \
block. And during the execution of the block, ",
  StyleBox["x", "TI"],
  " can take on any value. "
}], "Text",
  CellTags->{"S2.7.6", "6.6"}],

Cell[TextData[{
  "This sets the symbol ",
  StyleBox["t", "MR"],
  " to have value\[NonBreakingSpace]",
  StyleBox["17", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.7"}],

Cell[CellGroupData[{

Cell["t = 17", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell["Variables in modules have unique local names. ", "MathCaption",
  CellTags->{"S2.7.6", "6.8"}],

Cell[CellGroupData[{

Cell["Module[{t}, Print[t]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(t$1\)], "Print",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell["\<\
In blocks, variables retain their global names, but can have local \
values. \
\>", "MathCaption",
  CellTags->{"S2.7.6", "6.9"}],

Cell[CellGroupData[{

Cell["Block[{t}, Print[t]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(t\)], "Print",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["t", "MR"],
  " is given a local value inside the block. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.10"}],

Cell[CellGroupData[{

Cell["Block[{t}, t = 6; t^4 + 1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(1297\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "When the execution of the block is over, the previous value of ",
  StyleBox["t", "MR"],
  " is restored. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.11"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "Blocks in ",
  StyleBox["Mathematica", "TI"],
  " effectively allow you to set up \[OpenCurlyDoubleQuote]environments\
\[CloseCurlyDoubleQuote] in which you can temporarily change the values of \
variables. Expressions you evaluate at any point during the execution of a \
block will use the values currently defined for variables in the block. This \
is true whether the expressions appear directly as part of the body of the \
block, or are produced at any point in its evaluation. "
}], "Text",
  CellTags->{"S2.7.6", "6.12"}],

Cell[TextData[{
  "This defines a delayed value for the symbol ",
  StyleBox["u", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.13"}],

Cell["u := x^2 + t^2", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.6"],

Cell[TextData[{
  "If you evaluate ",
  StyleBox["u", "MR"],
  " outside a block, the global value for ",
  StyleBox["t", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.14"}],

Cell[CellGroupData[{

Cell["u", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(289 + x\^2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "You can specify a temporary value for ",
  StyleBox["t", "MR"],
  " to use inside the block. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.15"}],

Cell[CellGroupData[{

Cell["Block[{t = 5}, u + 7]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(32 + x\^2\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "An important implicit use of ",
  StyleBox["Block", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " is for iteration constructs such as ",
  StyleBox["Do", "MR"],
  ", ",
  StyleBox["Sum", "MR"],
  " and ",
  StyleBox["Table", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " effectively uses ",
  StyleBox["Block", "MR"],
  " to set up local values for the iteration variables in all of these \
constructs. "
}], "Text",
  CellTags->{"S2.7.6", "6.16"}],

Cell[TextData[{
  StyleBox["Sum", "MR"],
  " automatically makes the value of the iterator ",
  StyleBox["t", "MR"],
  " local. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.17"}],

Cell[CellGroupData[{

Cell["Sum[t^2, {t, 10}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(385\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "The local values in iteration constructs are slightly more general than in \
",
  StyleBox["Block", "MR"],
  ". They handle variables such as ",
  StyleBox["a[1]", "MR"],
  ", as well as pure symbols. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.18"}],

Cell[CellGroupData[{

Cell["Sum[a[1]^2, {a[1], 10}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(385\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "When you set up functions in ",
  StyleBox["Mathematica", "TI"],
  ", it is sometimes convenient to have \[OpenCurlyDoubleQuote]global \
variables\[CloseCurlyDoubleQuote] which can affect the functions without \
being given explicitly as arguments. Thus, for example, ",
  StyleBox["Mathematica", "TI"],
  " itself has a global variable ",
  StyleBox["$RecursionLimit", "MR"],
  " which affects the evaluation of all functions, but is never explicitly \
given as an argument. "
}], "Text",
  CellTags->{"S2.7.6", "6.19"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will usually keep any value you define for a global variable until you \
explicitly change it. Often, however, you want to set up values which last \
only for the duration of a particular computation, or part of a computation. \
You can do this by making the values local to a ",
  StyleBox["Mathematica", "TI"],
  " block. "
}], "Text",
  CellTags->{"S2.7.6", "6.20"}],

Cell[TextData[{
  "This defines a function which depends on the \[OpenCurlyDoubleQuote]global \
variable\[CloseCurlyDoubleQuote] ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.21"}],

Cell["f[x_] := x^2 + t", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.7.6"],

Cell[TextData[{
  "In this case, the global value of ",
  StyleBox["t", "MR"],
  " is used. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.22"}],

Cell[CellGroupData[{

Cell["f[a]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(17 + a\^2\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "Inside a block, you can set up a local value for ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.23"}],

Cell[CellGroupData[{

Cell["Block[{t = 2}, f[b]]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(2 + b\^2\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell["\<\
You can use global variables not only to set parameters in \
functions, but also to accumulate results from functions. By setting up such \
variables to be local to a block, you can arrange to accumulate results only \
from functions called during the execution of the block. \
\>", "Text",
  CellTags->{"S2.7.6", "6.24"}],

Cell[TextData[{
  "This function increments the global variable ",
  StyleBox["t", "MR"],
  ", and returns its current value. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.25"}],

Cell["h[x_] := (t += x^2)", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.7.6"],

Cell[TextData[{
  "If you do not use a block, evaluating ",
  StyleBox["h[a]", "MR"],
  " changes the global value of ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.26"}],

Cell[CellGroupData[{

Cell["h[a]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(17 + a\^2\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "With a block, only the local value of ",
  StyleBox["t", "MR"],
  " is affected. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.27"}],

Cell[CellGroupData[{

Cell["Block[{t = 0}, h[c]]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(c\^2\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "The global value of ",
  StyleBox["t", "MR"],
  " remains unchanged. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.28"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(17 + a\^2\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "When you enter a block such as ",
  StyleBox["Block[{", "MR"],
  StyleBox["x", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  ", any value for ",
  StyleBox["x", "TI"],
  " is removed. This means that you can in principle treat ",
  StyleBox["x", "TI"],
  " as a \[OpenCurlyDoubleQuote]symbolic variable\[CloseCurlyDoubleQuote] \
inside the block. However, if you explicitly return ",
  StyleBox["x", "TI"],
  " from the block, it will be replaced by its value outside the block as \
soon as it is evaluated. "
}], "Text",
  CellTags->{"S2.7.6", "6.29"}],

Cell[TextData[{
  "The value of ",
  StyleBox["t", "MR"],
  " is removed when you enter the block. "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.30"}],

Cell[CellGroupData[{

Cell["Block[{t}, Print[Expand[(t + 1)^2]]]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(1 + 2\ t + t\^2\)], "Print",
  CellTags->"S2.7.6"]
}, Open  ]],

Cell[TextData[{
  "If you return an expression involving ",
  StyleBox["t", "MR"],
  ", however, it is evaluated using the global value for ",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.6", "6.31"}],

Cell[CellGroupData[{

Cell["Block[{t}, t^2 - 3]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.7.6"],

Cell[BoxData[
    \(\(-3\) + \((17 + a\^2)\)\^2\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.7.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.7 Blocks Compared with Modules", "Subsection",
  CellTags->{"S2.7.7", "7.1"}],

Cell[TextData[{
  "When you write a program in ",
  StyleBox["Mathematica", "TI"],
  ", you should always try to set it up so that its parts are as independent \
as possible. In this way, the program will be easier for you to understand, \
maintain and add to. "
}], "Text",
  CellTags->{"S2.7.7", "7.2"}],

Cell[TextData[{
  "One of the main ways to ensure that different parts of a program do not \
interfere is to give their variables only a certain \
\[OpenCurlyDoubleQuote]scope\[CloseCurlyDoubleQuote]. ",
  StyleBox["Mathematica", "TI"],
  " provides two basic mechanisms for limiting the scope of variables: \
modules and blocks. "
}], "Text",
  CellTags->{"S2.7.7", "7.3"}],

Cell["\<\
In writing actual programs, modules are far more common than \
blocks. When scoping is needed in interactive calculations, however, blocks \
are often convenient. \
\>", "Text",
  CellTags->{"S2.7.7", "7.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Module[", "MR"],
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["lexical scoping "]},
          {Cell[TextData[{
              StyleBox["Block[", "MR"],
              StyleBox["vars", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["body", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["dynamic scoping "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.7"],

Cell[TextData[{
  StyleBox["Mathematica", "SO"],
  " variable scoping mechanisms. "
}], "Caption",
  CellTags->"S2.7.7"],

Cell[TextData[{
  "Most traditional computer languages use a so\[Hyphen]called \
\[OpenCurlyDoubleQuote]lexical scoping\[CloseCurlyDoubleQuote] mechanism for \
variables, which is analogous to the module mechanism in ",
  StyleBox["Mathematica", "TI"],
  ". Some symbolic computer languages such as LISP also allow \
\[OpenCurlyDoubleQuote]dynamic scoping\[CloseCurlyDoubleQuote], analogous to \
",
  StyleBox["Mathematica", "TI"],
  " blocks. "
}], "Text",
  CellTags->{"S2.7.7", "7.5"}],

Cell[TextData[{
  "When lexical scoping is used, variables are treated as local to a \
particular section of the ",
  StyleBox["code", "TI"],
  " in a program. In dynamic scoping, the values of variables are local to a \
part of the ",
  StyleBox["execution history", "TI"],
  " of the program. "
}], "Text",
  CellTags->{"S2.7.7", "7.6"}],

Cell[TextData[{
  "In compiled languages like C and Java, there is a very clear distinction \
between \[OpenCurlyDoubleQuote]code\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]execution history\[CloseCurlyDoubleQuote]. The \
symbolic nature of ",
  StyleBox["Mathematica", "TI"],
  " makes this distinction slightly less clear, since \
\[OpenCurlyDoubleQuote]code\[CloseCurlyDoubleQuote] can in principle be built \
up dynamically during the execution of a program. "
}], "Text",
  CellTags->{"S2.7.7", "7.7"}],

Cell[TextData[{
  "What ",
  StyleBox["Module[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " does is to treat the form of the expression ",
  StyleBox["body", "TI"],
  " at the time when the module is executed as the \
\[OpenCurlyDoubleQuote]code\[CloseCurlyDoubleQuote] of a ",
  StyleBox["Mathematica", "TI"],
  " program. Then when any of the ",
  StyleBox["vars", "TI"],
  " explicitly appears in this \[OpenCurlyDoubleQuote]code\
\[CloseCurlyDoubleQuote], it is considered to be local. "
}], "Text",
  CellTags->{"S2.7.7", "7.8"}],

Cell[TextData[{
  StyleBox["Block[", "MR"],
  StyleBox["vars", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["body", "TI"],
  StyleBox["]", "MR"],
  " does not look at the ",
  StyleBox["form", "TI"],
  " of the expression ",
  StyleBox["body", "TI"],
  ". Instead, throughout the evaluation of ",
  StyleBox["body", "TI"],
  ", the block uses local values for the ",
  StyleBox["vars", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.7.7", "7.9"}],

Cell[TextData[{
  "This defines ",
  StyleBox["m", "MR"],
  " in terms of ",
  StyleBox["i", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.7", "7.10"}],

Cell[CellGroupData[{

Cell["m = i^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.7"],

Cell[BoxData[
    \(i\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.7"]
}, Open  ]],

Cell[TextData[{
  "The local value for ",
  StyleBox["i", "MR"],
  " in the block is used throughout the evaluation of ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["m", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.7", "7.11"}],

Cell[CellGroupData[{

Cell["Block[{i = a}, i + m]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.7"],

Cell[BoxData[
    \(a + a\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.7"]
}, Open  ]],

Cell[TextData[{
  "Here only the ",
  StyleBox["i", "MR"],
  " that appears explicitly in ",
  StyleBox["i", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["m", "MR"],
  " is treated as a local variable. "
}], "MathCaption",
  CellTags->{"S2.7.7", "7.12"}],

Cell[CellGroupData[{

Cell["Module[{i = a}, i + m]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.7"],

Cell[BoxData[
    \(a + i\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.8 Contexts", "Subsection",
  CellTags->{"S2.7.8", "8.1"}],

Cell["\<\
It is always a good idea to give variables and functions names that \
are as explicit as possible. Sometimes, however, such names may get \
inconveniently long. \
\>", "Text",
  CellTags->{"S2.7.8", "8.2"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  ", you can use the notion of \[OpenCurlyDoubleQuote]contexts\
\[CloseCurlyDoubleQuote] to organize the names of symbols. Contexts are \
particularly important in ",
  StyleBox["Mathematica", "TI"],
  " packages which introduce symbols whose names must not conflict with those \
of any other symbols. If you write ",
  StyleBox["Mathematica", "TI"],
  " packages, or make sophisticated use of packages that others have written, \
then you will need to know about contexts. "
}], "Text",
  CellTags->{"S2.7.8", "8.3"}],

Cell[TextData[{
  "The basic idea is that the ",
  StyleBox["full name", "TI"],
  " of any symbol is broken into two parts: a ",
  StyleBox["context", "TI"],
  " and a ",
  StyleBox["short name", "TI"],
  ". The full name is written as ",
  StyleBox["context", "TI"],
  StyleBox["`", "MR"],
  StyleBox["short", "TI"],
  ", where the ",
  StyleBox["`", "MR"],
  " is the backquote or grave accent character (ASCII decimal code 96), \
called a \[OpenCurlyDoubleQuote]context mark\[CloseCurlyDoubleQuote] in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.4"}],

Cell[TextData[{
  "Here is a symbol with short name ",
  StyleBox["x", "MR"],
  ", and context ",
  StyleBox["aaaa", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.5"}],

Cell[CellGroupData[{

Cell["aaaa`x", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(aaaa`x\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell["You can use this symbol just like any other symbol. ", "MathCaption",
  CellTags->{"S2.7.8", "8.6"}],

Cell[CellGroupData[{

Cell["%^2 - %", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(\(-aaaa`x\) + aaaa`x\^2\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell["You can for example define a value for the symbol. ", "MathCaption",
  CellTags->{"S2.7.8", "8.7"}],

Cell[CellGroupData[{

Cell["aaaa`x = 78", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(78\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats ",
  StyleBox["a`x", "MR"],
  " and ",
  StyleBox["b`x", "MR"],
  " as completely different symbols. "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.8"}],

Cell[CellGroupData[{

Cell["a`x == b`x", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(a`x \[Equal] b`x\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "It is typical to have all the symbols that relate a particular topic in a \
particular context. Thus, for example, symbols that represent physical units \
might have a context ",
  StyleBox["PhysicalUnits`", "MR"],
  ". Such symbols might have full names like ",
  StyleBox["PhysicalUnits`Joule", "MR"],
  " or ",
  StyleBox["PhysicalUnits`Mole", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.9"}],

Cell["\<\
Although you can always refer to a symbol by its full name, it is \
often convenient to use a shorter name. \
\>", "Text",
  CellTags->{"S2.7.8", "8.10"}],

Cell[TextData[{
  "At any given point in a ",
  StyleBox["Mathematica", "TI"],
  " session, there is always a ",
  StyleBox["current context", "TI"],
  " ",
  StyleBox["$Context", "MR"],
  ". You can refer to symbols that are in this context simply by giving their \
short names. "
}], "Text",
  CellTags->{"S2.7.8", "8.11"}],

Cell[TextData[{
  "The default context for ",
  StyleBox["Mathematica", "TI"],
  " sessions is ",
  StyleBox["Global`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.12"}],

Cell[CellGroupData[{

Cell["$Context", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell["\<\
Short names are sufficient for symbols that are in the current \
context. \
\>", "MathCaption",
  CellTags->{"S2.7.8", "8.13"}],

Cell[CellGroupData[{

Cell["{x, Global`x}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \({x, x}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "Contexts in ",
  StyleBox["Mathematica", "TI"],
  " work somewhat like file directories in many operating systems. You can \
always specify a particular file by giving its complete name, including its \
directory. But at any given point, there is usually a current working \
directory, analogous to the current ",
  StyleBox["Mathematica", "TI"],
  " context. Files that are in this directory can then be specified just by \
giving their short names. "
}], "Text",
  CellTags->{"S2.7.8", "8.14"}],

Cell[TextData[{
  "Like directories in many operating systems, contexts in ",
  StyleBox["Mathematica", "TI"],
  " can be hierarchical. Thus, for example, the full name of a symbol can \
involve a sequence of context names, as in ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["`", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["`", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "3"], TraditionalForm]], "InlineFormula"],
  StyleBox["`", "MR"],
  StyleBox["name", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["`", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["`", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["a symbol in an explicitly specified context "]},
          {Cell[TextData[{
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " "
            }]], Cell["a symbol in the current context "]},
          {Cell[TextData[{
              StyleBox["`", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              StyleBox["name", "TI"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["`", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "`",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "` \[Ellipsis] `",
              StyleBox["name", "TI"],
              " "
            }]], 
            Cell["\<\
a symbol in a specific context relative to the current \
context \
\>"]},
          {Cell[TextData[{
              StyleBox["name", "TI"],
              " "
            }]], 
            Cell["\<\
a symbol in the current context, or found on the \
context search path \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.8"],

Cell["Specifying symbols in various contexts. ", "Caption",
  CellTags->"S2.7.8"],

Cell[TextData[{
  "Here is a symbol in the context ",
  StyleBox["a`b`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.16"}],

Cell[CellGroupData[{

Cell["a`b`x", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(a`b`x\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "When you start a ",
  StyleBox["Mathematica", "TI"],
  " session, the default current context is ",
  StyleBox["Global`", "MR"],
  ". Symbols that you introduce will usually be in this context. However, \
built\[Hyphen]in symbols such as ",
  StyleBox["Pi", "MR"],
  " are in the context ",
  StyleBox["System`", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.17"}],

Cell[TextData[{
  "In order to let you easily access not only symbols in the context ",
  StyleBox["Global`", "MR"],
  ", but also in contexts such as ",
  StyleBox["System`", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " supports the notion of a ",
  StyleBox["context search path", "TI"],
  ". At any point in a ",
  StyleBox["Mathematica", "TI"],
  " session, there is both a current context ",
  StyleBox["$Context", "MR"],
  ", and also a current context search path ",
  StyleBox["$ContextPath", "MR"],
  ". The idea of the search path is to allow you to type in the short name of \
a symbol, then have ",
  StyleBox["Mathematica", "TI"],
  " search in a sequence of contexts to find a symbol with that short name. "
}], "Text",
  CellTags->{"S2.7.8", "8.18"}],

Cell[TextData[{
  "The context search path for symbols in ",
  StyleBox["Mathematica", "TI"],
  " is analogous to the \[OpenCurlyDoubleQuote]search path\
\[CloseCurlyDoubleQuote] for program files provided in operating systems. "
}], "Text",
  CellTags->{"S2.7.8", "8.19"}],

Cell["\<\
The default context path includes the contexts for \
system\[Hyphen]defined symbols. \
\>", "MathCaption",
  CellTags->{"S2.7.8", "8.20"}],

Cell[CellGroupData[{

Cell["$ContextPath", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \({"Global`", "System`"}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "When you type in ",
  StyleBox["Pi", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " interprets it as the symbol with full name ",
  StyleBox["System`Pi", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.21"}],

Cell[CellGroupData[{

Cell["Context[Pi]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \("System`"\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Context[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the context of a symbol "]},
          {Cell[TextData[{
              StyleBox["$Context", "MR"],
              " "
            }]], Cell[TextData[{
              "the current context in a ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]},
          {Cell[TextData[{
              StyleBox["$ContextPath", "MR"],
              " "
            }]], Cell["the current context search path "]},
          {Cell[TextData[{
              StyleBox["Contexts[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["a list of all contexts "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.8"],

Cell["Finding contexts and context search paths. ", "Caption",
  CellTags->"S2.7.8"],

Cell[TextData[{
  "When you use contexts in ",
  StyleBox["Mathematica", "TI"],
  ", there is no reason that two symbols which are in different contexts \
cannot have the same short name. Thus, for example, you can have symbols with \
the short name ",
  StyleBox["Mole", "MR"],
  " both in the context ",
  StyleBox["PhysicalUnits`", "MR"],
  " and in the context ",
  StyleBox["BiologicalOrganisms`", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.22"}],

Cell[TextData[{
  "There is, however, then the question of which symbol you actually get when \
you type in only the short name ",
  StyleBox["Mole", "MR"],
  ". The answer to this question is determined by which of the contexts comes \
first in the sequence of contexts listed in the context search path. "
}], "Text",
  CellTags->{"S2.7.8", "8.23"}],

Cell[TextData[{
  "This introduces two symbols, both with short name ",
  StyleBox["Mole", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.24"}],

Cell[CellGroupData[{

Cell["{PhysicalUnits`Mole, BiologicalOrganisms`Mole}", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \({PhysicalUnits`Mole, BiologicalOrganisms`Mole}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "This adds two additional contexts to ",
  StyleBox["$ContextPath", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.25"}],

Cell[CellGroupData[{

Cell["\<\
$ContextPath = Join[$ContextPath, {\"PhysicalUnits`\", \
\"BiologicalOrganisms`\"}]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \({"Global`", "System`", "PhysicalUnits`", 
      "BiologicalOrganisms`"}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "Now if you type in ",
  StyleBox["Mole", "MR"],
  ", you get the symbol in the context ",
  StyleBox["PhysicalUnits`", "MR"],
  "."
}], "MathCaption",
  CellTags->{"S2.7.8", "8.26"}],

Cell[CellGroupData[{

Cell["Context[Mole]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \("PhysicalUnits`"\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "In general, when you type in a short name for a symbol, ",
  StyleBox["Mathematica", "TI"],
  " assumes that you want the symbol with that name whose context appears \
earliest in the context search path. As a result, symbols with the same short \
name whose contexts appear later in the context search path are effectively \
\[OpenCurlyDoubleQuote]shadowed\[CloseCurlyDoubleQuote]. To refer to these \
symbols, you need to use their full names. "
}], "Text",
  CellTags->{"S2.7.8", "8.27"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " always warns you when you introduce new symbols that \
\[OpenCurlyDoubleQuote]shadow\[CloseCurlyDoubleQuote] existing symbols with \
your current choice for ",
  StyleBox["$ContextPath", "MR"],
  ". If you use a notebook front end, ",
  StyleBox["Mathematica", "TI"],
  " will typically let you select in such cases which symbol you want to \
keep. "
}], "Text",
  CellTags->{"S2.7.8", "8.28"}],

Cell[TextData[{
  "This introduces a symbol with short name ",
  StyleBox["Mole", "MR"],
  " in the context ",
  StyleBox["Global`", "MR"],
  ". ",
  StyleBox["Mathematica", "TI"],
  " warns you that the new symbol shadows existing symbols with short name ",
  StyleBox["Mole", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.29"}],

Cell[CellGroupData[{

Cell["Global`Mole", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(Mole::"shdw" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"Mole\"\) appears in multiple contexts \!\({\"Global`\", \
\"PhysicalUnits`\", \"BiologicalOrganisms`\"}\); definitions in context \
\!\(\"Global`\"\) may shadow or be shadowed by other definitions."\)], \
"Message",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(Mole\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "Now when you type in ",
  StyleBox["Mole", "MR"],
  ", you get the symbol in context ",
  StyleBox["Global`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.30"}],

Cell[CellGroupData[{

Cell["Context[Mole]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "If you once introduce a symbol which shadows existing symbols, it will \
continue to do so until you either rearrange ",
  StyleBox["$ContextPath", "MR"],
  ", or explicitly remove the symbol. You should realize that it is not \
sufficient to clear the ",
  StyleBox["value", "TI"],
  " of the symbol; you need to actually remove the symbol completely from ",
  StyleBox["Mathematica", "TI"],
  ". You can do this using the function ",
  StyleBox["Remove[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.31"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Clear[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["clear the values of a symbol "]},
          {Cell[TextData[{
              StyleBox["Remove[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["remove a symbol completely from the system "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.8"],

Cell[TextData[{
  "Clearing and removing symbols in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.7.8"],

Cell[TextData[{
  "This removes the symbol ",
  StyleBox["Global`Mole", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.32"}],

Cell["Remove[Mole]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.7.8"],

Cell[TextData[{
  "Now if you type in ",
  StyleBox["Mole", "MR"],
  ", you get the symbol ",
  StyleBox["PhysicalUnits`Mole", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.33"}],

Cell[CellGroupData[{

Cell["Context[Mole]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \("PhysicalUnits`"\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " prints out the name of a symbol, it has to choose whether to give the \
full name, or just the short name. What it does is to give whatever version \
of the name you would have to type in to get the particular symbol, given \
your current settings for ",
  StyleBox["$Context", "MR"],
  " and ",
  StyleBox["$ContextPath", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.34"}],

Cell["\<\
The short name is printed for the first symbol, so this would give \
that symbol if you typed it in. \
\>", "MathCaption",
  CellTags->{"S2.7.8", "8.35"}],

Cell[CellGroupData[{

Cell["{PhysicalUnits`Mole, BiologicalOrganisms`Mole}", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \({Mole, BiologicalOrganisms`Mole}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  "If you type in a short name for which there is no symbol either in the \
current context, or in any context on the context search path, then ",
  StyleBox["Mathematica", "TI"],
  " has to ",
  StyleBox["create", "TI"],
  " a new symbol with this name. It always puts new symbols of this kind in \
the current context, as specified by ",
  StyleBox["$Context", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.8", "8.36"}],

Cell[TextData[{
  "This introduces the new symbol with short name ",
  StyleBox["tree", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.37"}],

Cell[CellGroupData[{

Cell["tree", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \(tree\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.7.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " puts ",
  StyleBox["tree", "MR"],
  " in the current context ",
  StyleBox["Global`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.8", "8.38"}],

Cell[CellGroupData[{

Cell["Context[tree]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.7.8"],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.7.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.9 Contexts and Packages", "Subsection",
  CellTags->{"S2.7.9", "9.1"}],

Cell[TextData[{
  "A typical package written in ",
  StyleBox["Mathematica", "TI"],
  " introduces several new symbols intended for use outside the package. \
These symbols may correspond for example to new functions or new objects \
defined in the package. "
}], "Text",
  CellTags->{"S2.7.9", "9.2"}],

Cell[TextData[{
  "There is a general convention that all new symbols introduced in a \
particular package are put into a context whose name is related to the name \
of the package. When you read in the package, it adds this context at the \
beginning of your context search path ",
  StyleBox["$ContextPath", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.9", "9.3"}],

Cell["This reads in a package for finding Pad\[EAcute] approximants. ", \
"MathCaption",
  CellTags->{"S2.7.9", "9.4"}],

Cell["<<Calculus`Pade`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.9"],

Cell[TextData[{
  "The package prepends its context to ",
  StyleBox["$ContextPath", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.9", "9.5"}],

Cell[CellGroupData[{

Cell["$ContextPath", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \({"Calculus`Pade`", "Global`", "System`"}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[TextData[{
  "The symbol ",
  StyleBox["Pade", "MR"],
  " is in the context set up by the package. "
}], "MathCaption",
  CellTags->{"S2.7.9", "9.6"}],

Cell[CellGroupData[{

Cell["Context[Pade]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \("Calculus`Pade`"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell["You can refer to the symbol using its short name. ", "MathCaption",
  CellTags->{"S2.7.9", "9.7"}],

Cell[CellGroupData[{

Cell["Pade[Exp[x], {x, 0, 2, 4}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(\(1 + x\/3 + x\^2\/30\)\/\(1 - \(2\ x\)\/3 + x\^2\/5 - x\^3\/30 + \
x\^4\/360\)\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[TextData[{
  "The full names of symbols defined in packages are often quite long. In \
most cases, however, you will only need to use their short names. The reason \
for this is that after you have read in a package, its context is added to ",
  StyleBox["$ContextPath", "MR"],
  ", so the context is automatically searched whenever you type in a short \
name. "
}], "Text",
  CellTags->{"S2.7.9", "9.8"}],

Cell[TextData[{
  "There is a complication, however, when two symbols with the same short \
name appear in two different packages. In such a case, ",
  StyleBox["Mathematica", "TI"],
  " will warn you when you read in the second package. It will tell you which \
symbols will be \[OpenCurlyDoubleQuote]shadowed\[CloseCurlyDoubleQuote] by \
the new symbols that are being introduced. "
}], "Text",
  CellTags->{"S2.7.9", "9.9"}],

Cell[TextData[{
  "The symbol ",
  StyleBox["Pade", "MR"],
  " in the context ",
  StyleBox["Calculus`Pade`", "MR"],
  " is shadowed by the symbol with the same short name in the new package. "
}], "MathCaption",
  CellTags->{"S2.7.9", "9.10"}],

Cell[CellGroupData[{

Cell["<<NewPade`", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(Pade::"shdw" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"Pade\"\) appears in multiple contexts \!\({\"NewPade`\", \
\"Calculus`Pade`\"}\); definitions in context \!\(\"NewPade`\"\) may shadow \
or be shadowed by other definitions."\)], "Message",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell["You can access the shadowed symbol by giving its full name. ", \
"MathCaption",
  CellTags->{"S2.7.9", "9.11"}],

Cell[CellGroupData[{

Cell["Calculus`Pade`Pade[Exp[x], {x, 0, 2, 4}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(\(1 + x\/3 + x\^2\/30\)\/\(1 - \(2\ x\)\/3 + x\^2\/5 - x\^3\/30 + \
x\^4\/360\)\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[TextData[{
  "Conflicts can occur not only between symbols in different packages, but \
also between symbols in packages and symbols that you introduce directly in \
your ",
  StyleBox["Mathematica", "TI"],
  " session. If you define a symbol in your current context, then this symbol \
will shadow any other symbol with the same short name in packages that you \
read in. The reason for this is that ",
  StyleBox["Mathematica", "TI"],
  " always searches for symbols in the current context before looking in \
contexts on the context search path. "
}], "Text",
  CellTags->{"S2.7.9", "9.12"}],

Cell["This defines a function in the current context. ", "MathCaption",
  CellTags->{"S2.7.9", "9.13"}],

Cell[CellGroupData[{

Cell["Div[f_] = 1/f", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(1\/f\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[TextData[{
  "Any other functions with short name ",
  StyleBox["Div", "MR"],
  " will be shadowed by the one in your current context. "
}], "MathCaption",
  CellTags->{"S2.7.9", "9.14"}],

Cell[CellGroupData[{

Cell["<<Calculus`VectorAnalysis`", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(Div::"shdw" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"Div\"\) appears in multiple contexts \
\!\({\"Calculus`VectorAnalysis`\", \"Global`\"}\); definitions in context \
\!\(\"Calculus`VectorAnalysis`\"\) may shadow or be shadowed by other \
definitions."\)], "Message",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell["This sets up the coordinate system for vector analysis. ", "MathCaption",
  CellTags->{"S2.7.9", "9.15"}],

Cell[CellGroupData[{

Cell["SetCoordinates[Cartesian[x, y, z]]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(Cartesian[x, y, z]\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[TextData[{
  "This removes ",
  StyleBox["Div", "MR"],
  " completely from the current context. "
}], "MathCaption",
  CellTags->{"S2.7.9", "9.16"}],

Cell["Clear[Div]; Remove[Div]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.9"],

Cell[TextData[{
  "Now the ",
  StyleBox["Div", "MR"],
  " from the package is used. "
}], "MathCaption",
  CellTags->{"S2.7.9", "9.17"}],

Cell[CellGroupData[{

Cell["Div[{x, y^2, x}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.9"],

Cell[BoxData[
    \(1 + 2\ y\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[TextData[{
  "If you get into the situation where unwanted symbols are shadowing the \
symbols you want, the best thing to do is usually to get rid of the unwanted \
symbols using ",
  StyleBox["Remove[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  ". An alternative that is sometimes appropriate is to rearrange the entries \
in ",
  StyleBox["$ContextPath", "MR"],
  " and to reset the value of ",
  StyleBox["$Context", "MR"],
  " so as to make the contexts that contain the symbols you want be the ones \
that are searched first. "
}], "Text",
  CellTags->{"S2.7.9", "9.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Packages", "MR"],
              " "
            }]], Cell[TextData[{
              
              "a list of the contexts corresponding to all packages loaded \
into your ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.9"],

Cell["Getting a list of packages. ", "Caption",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.7.10 Setting Up ",
  StyleBox["Mathematica", "SBO"],
  " Packages"
}], "Subsection",
  CellTags->{"S2.7.10", "10.1"}],

Cell[TextData[{
  "In a typical ",
  StyleBox["Mathematica", "TI"],
  " package, there are generally two kinds of new symbols that are \
introduced. The first kind are ones that you want to \
\[OpenCurlyDoubleQuote]export\[CloseCurlyDoubleQuote] for use outside the \
package. The second kind are ones that you want to use only internally within \
the package. You can distinguish these two kinds of symbols by putting them \
in different contexts. "
}], "Text",
  CellTags->{"S2.7.10", "10.2"}],

Cell[TextData[{
  "The usual convention is to put symbols intended for export in a context \
with a name ",
  StyleBox["Package", "TI"],
  StyleBox["`", "MR"],
  " that corresponds to the name of the package. Whenever the package is read \
in, it adds this context to the context search path, so that the symbols in \
this context can be referred to by their short names. "
}], "Text",
  CellTags->{"S2.7.10", "10.3"}],

Cell[TextData[{
  "Symbols that are not intended for export, but are instead intended only \
for internal use within the package, are conventionally put into a context \
with the name ",
  StyleBox["Package", "TI"],
  StyleBox["`Private`", "MR"],
  ". This context is ",
  StyleBox["not", "TI"],
  " added to the context search path. As a result, the symbols in this \
context cannot be accessed except by giving their full names. "
}], "Text",
  CellTags->{"S2.7.10", "10.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Package", "TI"],
              StyleBox["`", "MR"],
              " "
            }]], Cell["symbols for export "]},
          {Cell[TextData[{
              StyleBox["Package", "TI"],
              StyleBox["`Private`", "MR"],
              " "
            }]], Cell["symbols for internal use only "]},
          {Cell[TextData[{
              StyleBox["System`", "MR"],
              " "
            }]], Cell[TextData[{
              "built\[Hyphen]in ",
              StyleBox["Mathematica", "TI"],
              " symbols "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["Needed",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["`", "MR"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["Needed",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["`", "MR"],
              ", \[Ellipsis]",
              " ",
              " "
            }]], Cell["other contexts needed in the package "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.10"],

Cell[TextData[{
  "Contexts conventionally used in ",
  StyleBox["Mathematica", "SO"],
  " packages. "
}], "Caption",
  CellTags->"S2.7.10"],

Cell[TextData[{
  "There is a standard sequence of ",
  StyleBox["Mathematica", "TI"],
  " commands that is typically used to set up the contexts in a package. \
These commands set the values of ",
  StyleBox["$Context", "MR"],
  " and ",
  StyleBox["$ContextPath", "MR"],
  " so that the new symbols which are introduced are created in the \
appropriate contexts. "
}], "Text",
  CellTags->{"S2.7.10", "10.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BeginPackage[\"", "MR"],
              StyleBox["Package", "TI"],
              StyleBox["`\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "set ",
              StyleBox["Package", "TI"],
              StyleBox["`", "MR"],
              " to be the current context, and put only ",
              StyleBox["System`", "MR"],
              " on the context search path "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::usage", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              ", \[Ellipsis]",
              " ",
              " "
            }]], Cell[
            "introduce the objects intended for export (and no others) "]},
          {Cell[TextData[{
              StyleBox["Begin[\"`Private`\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "set the current context to ",
              StyleBox["Package", "TI"],
              StyleBox["`Private`", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["args", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["value", "TI"],
              ", \[Ellipsis]",
              " ",
              " "
            }]], Cell["give the main body of definitions in the package "]},
          {Cell[TextData[{
              StyleBox["End[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "revert to the previous context (here ",
              StyleBox["Package", "TI"],
              StyleBox["`", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["EndPackage[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "end the package, prepending the ",
              StyleBox["Package", "TI"],
              StyleBox["`", "MR"],
              " to the context search path "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.10"],

Cell["\<\
The standard sequence of context control commands in a package. \
\
\>", "Caption",
  CellTags->"S2.7.10"],

Cell[" ", "ProgramTop",
  CellTags->{"S2.7.10", "10.6"}],

Cell["\<\
BeginPackage[\"Collatz`\"]

Collatz::usage =
        \"Collatz[n] gives a list of the iterates in the 3n+1 problem,
        starting from n. The conjecture is that this sequence always
        terminates.\"

Begin[\"`Private`\"]

Collatz[1] := {1}

Collatz[n_Integer]  := Prepend[Collatz[3 n + 1], n] /; OddQ[n] && n > 0

Collatz[n_Integer] := Prepend[Collatz[n/2], n] /; EvenQ[n] && n > 0

End[ ]

EndPackage[ ]\
\>", "Program",
  CellTags->{"S2.7.10", "10.7"}],

Cell[" ", "ProgramBottom",
  CellTags->{"S2.7.10", "10.8"}],

Cell[TextData[{
  "The sample package ",
  StyleBox["Collatz.m", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.7.10"],

Cell[TextData[{
  "Defining ",
  StyleBox["usage", "MR"],
  " messages at the beginning of a package is the standard way of making sure \
that symbols you want to export are created in the appropriate context. The \
way this works is that in defining these messages, the only symbols you \
mention are exactly the ones you want to export. These symbols are then \
created in the context ",
  StyleBox["Package", "TI"],
  StyleBox["`", "MR"],
  ", which is then current. "
}], "Text",
  CellTags->{"S2.7.10", "10.9"}],

Cell[TextData[{
  "In the actual definitions of the functions in a package, there are \
typically many new symbols, introduced as parameters, temporary variables, \
and so on. The convention is to put all these symbols in the context ",
  StyleBox["Package", "TI"],
  StyleBox["`Private`", "MR"],
  ", which is not put on the context search path when the package is read in. \
"
}], "Text",
  CellTags->{"S2.7.10", "10.10"}],

Cell["This reads in the sample package given above. ", "MathCaption",
  CellTags->{"S2.7.10", "10.11"}],

Cell["<<Collatz.m", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.10"],

Cell[TextData[{
  "The ",
  StyleBox["EndPackage", "MR"],
  " command in the package adds the context associated with the package to \
the context search path. "
}], "MathCaption",
  CellTags->{"S2.7.10", "10.12"}],

Cell[CellGroupData[{

Cell["$ContextPath", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.10"],

Cell[BoxData[
    \({"Collatz`", "Global`", "System`"}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.10"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Collatz", "MR"],
  " function was created in the context ",
  StyleBox["Collatz`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.10", "10.13"}],

Cell[CellGroupData[{

Cell["Context[Collatz]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.10"],

Cell[BoxData[
    \("Collatz`"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.7.10"]
}, Open  ]],

Cell[TextData[{
  "The parameter ",
  StyleBox["n", "MR"],
  " is put in the private context ",
  StyleBox["Collatz`Private`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.10", "10.14"}],

Cell[CellGroupData[{

Cell["?Collatz`Private`*", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.10"],

Cell[BoxData[
    \("Collatz`Private`n"\)], "Print",
  CellTags->"S2.7.10"]
}, Open  ]],

Cell[TextData[{
  "In the ",
  StyleBox["Collatz", "MR"],
  " package, the functions that are defined depend only on built\[Hyphen]in \
",
  StyleBox["Mathematica", "TI"],
  " functions. Often, however, the functions defined in one package may \
depend on functions defined in another package. "
}], "Text",
  CellTags->{"S2.7.10", "10.15"}],

Cell["\<\
Two things are needed to make this work. First, the other package \
must be read in, so that the functions needed are defined. And second, the \
context search path must include the context that these functions are in. \
\
\>", "Text",
  CellTags->{"S2.7.10", "10.16"}],

Cell[TextData[{
  "You can explicitly tell ",
  StyleBox["Mathematica", "TI"],
  " to read in a package at any point using the command ",
  StyleBox["<<", "MR"],
  StyleBox["context", "TI"],
  StyleBox["`", "MR"],
  ". (Section ",
  ButtonBox["2.12.5",
    ButtonData:>{"2.12.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " discusses the tricky issue of translation from system\[Hyphen]independent \
context names to system\[Hyphen]dependent file names.) Often, however, you \
want to set it up so that a particular package is read in only if it is \
needed. The command ",
  StyleBox["Needs[\"", "MR"],
  StyleBox["context", "TI"],
  StyleBox["`\"]", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " to read in a package if the context associated with that package is not \
already in the list ",
  StyleBox["$Packages", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.10", "10.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Get[\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`\"]", "MR"],
              " \[ThinSpace]or \[ThinSpace]",
              StyleBox["<<", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`", "MR"],
              " "
            }]], Cell[
            "read in the package corresponding to the specified context "]},
          {Cell[TextData[{
              StyleBox["Needs[\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`\"]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "read in the package if the specified context is not already in \
",
              StyleBox["$Packages", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["BeginPackage[\"", "MR"],
              StyleBox["Package", "TI"],
              StyleBox["`\",", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["Needed",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["`\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "begin a package, specifying that certain contexts in addition \
to ",
              StyleBox["System`", "MR"],
              " are needed "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.10"],

Cell["Functions for specifying interdependence of packages. ", "Caption",
  CellTags->"S2.7.10"],

Cell[TextData[{
  "If you use ",
  StyleBox["BeginPackage[\"", "MR"],
  StyleBox["Package", "TI"],
  StyleBox["`\"]", "MR"],
  " with a single argument, ",
  StyleBox["Mathematica", "TI"],
  " puts on the context search path only the ",
  StyleBox["Package", "TI"],
  StyleBox["`", "MR"],
  " context and the contexts for built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " symbols. If the definitions you give in your package involve functions \
from other packages, you must make sure that the contexts for these packages \
are also included in your context search path. You can do this by giving a \
list of the additional contexts as a second argument to ",
  StyleBox["BeginPackage", "MR"],
  ". ",
  StyleBox["BeginPackage", "MR"],
  " automatically calls ",
  StyleBox["Needs", "MR"],
  " on these contexts, reading in the corresponding packages if necessary, \
and then making sure that the contexts are on the context search path. "
}], "Text",
  CellTags->{"S2.7.10", "10.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Begin[\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`\"]", "MR"],
              " "
            }]], Cell["switch to a new current context "]},
          {Cell[TextData[{
              StyleBox["End[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["revert to the previous context "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.10"],

Cell["Context manipulation functions. ", "Caption",
  CellTags->"S2.7.10"],

Cell[TextData[{
  "Executing a function like ",
  StyleBox["Begin", "MR"],
  " which manipulates contexts changes the way that ",
  StyleBox["Mathematica", "TI"],
  " interprets names you type in. However, you should realize that the change \
is effective only in subsequent expressions that you type in. The point is \
that ",
  StyleBox["Mathematica", "TI"],
  " always reads in a complete input expression, and interprets the names in \
it, before it executes any part of the expression. As a result, by the time \
",
  StyleBox["Begin", "MR"],
  " is executed in a particular expression, the names in the expression have \
already been interpreted, and it is too late for ",
  StyleBox["Begin", "MR"],
  " to have an effect. "
}], "Text",
  CellTags->{"S2.7.10", "10.19"}],

Cell[TextData[{
  "The fact that context manipulation functions do not have an effect until \
the ",
  StyleBox["next", "TI"],
  " complete expression is read in means that you must be sure to give those \
functions as separate expressions, typically on separate lines, when you \
write ",
  StyleBox["Mathematica", "TI"],
  " packages. "
}], "Text",
  CellTags->{"S2.7.10", "10.20"}],

Cell[TextData[{
  "The name ",
  StyleBox["x", "MR"],
  " is interpreted before this expression is executed, so the ",
  StyleBox["Begin", "MR"],
  " has no effect. "
}], "MathCaption",
  CellTags->{"S2.7.10", "10.21"}],

Cell[CellGroupData[{

Cell["Begin[\"a`\"]; Print[Context[x]]; End[ ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.10"],

Cell[BoxData[
    \("Global`"\)], "Print",
  CellTags->"S2.7.10"],

Cell[BoxData[
    \("a`"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.10"]
}, Open  ]],

Cell[TextData[{
  "Context manipulation functions are used primarily as part of packages \
intended to be read into ",
  StyleBox["Mathematica", "TI"],
  ". Sometimes, however, you may find it convenient to use such functions \
interactively. "
}], "Text",
  CellTags->{"S2.7.10", "10.22"}],

Cell[TextData[{
  "This can happen, for example, if you go into a dialog, say using ",
  StyleBox["TraceDialog", "MR"],
  ", while executing a function defined in a package. The parameters and \
temporary variables in the function are typically in a private context \
associated with the package. Since this context is not on your context search \
path, ",
  StyleBox["Mathematica", "TI"],
  " will print out the full names of the symbols, and will require you to \
type in these full names in order to refer to the symbols. You can however \
use ",
  StyleBox["Begin[\"", "MR"],
  StyleBox["Package", "TI"],
  StyleBox["`Private`\"]", "MR"],
  " to make the private context of the package your current context. This \
will make ",
  StyleBox["Mathematica", "TI"],
  " print out short names for the symbols, and allow you to refer to the \
symbols by their short names."
}], "Text",
  CellTags->{"S2.7.10", "10.23"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.11 Automatic Loading of Packages", "Subsection",
  CellTags->{"S2.7.11", "11.1"}],

Cell[TextData[{
  "Previous sections have discussed explicit loading of ",
  StyleBox["Mathematica", "TI"],
  " packages using ",
  StyleBox["<<", "MR"],
  StyleBox["package", "TI"],
  " and ",
  StyleBox["Needs[", "MR"],
  StyleBox["package", "TI"],
  StyleBox["]", "MR"],
  ". Sometimes, however, you may want to set ",
  StyleBox["Mathematica", "TI"],
  " up so that it automatically loads a particular package when the package \
is needed. "
}], "Text",
  CellTags->{"S2.7.11", "11.2"}],

Cell[TextData[{
  "You can use ",
  StyleBox["DeclarePackage", "MR"],
  " to give the names of symbols which are defined in a particular package. \
Then, when one of these symbols is actually used, ",
  StyleBox["Mathematica", "TI"],
  " will automatically load the package where the symbol is defined. "
}], "Text",
  CellTags->{"S2.7.11", "11.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DeclarePackage[\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`\",", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "declare that a package should automatically be loaded if a \
symbol with any of the names ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["name",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " is used "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.11"],

Cell["Arranging for automatic loading of packages. ", "Caption",
  CellTags->"S2.7.11"],

Cell[TextData[{
  "This specifies that the symbols ",
  StyleBox["Div", "MR"],
  ", ",
  StyleBox["Grad", "MR"],
  " and ",
  StyleBox["Curl", "MR"],
  " are defined in ",
  StyleBox["Calculus`VectorAnalysis`", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.11", "11.4"}],

Cell[CellGroupData[{

Cell["\<\
DeclarePackage[\"Calculus`VectorAnalysis`\", {\"Div\", \"Grad\", \
\"Curl\"}]\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.11"],

Cell[BoxData[
    \("Calculus`VectorAnalysis`"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.7.11"]
}, Open  ]],

Cell[TextData[{
  "When you first use ",
  StyleBox["Grad", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " automatically loads the package that defines it. "
}], "MathCaption",
  CellTags->{"S2.7.11", "11.5"}],

Cell[CellGroupData[{

Cell["Grad[x^2 + y^2, Cartesian[x, y, z]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.11"],

Cell[BoxData[
    \({2\ x, 2\ y, 0}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.11"]
}, Open  ]],

Cell[TextData[{
  "When you set up a large collection of ",
  StyleBox["Mathematica", "TI"],
  " packages, it is often a good idea to create an additional \
\[OpenCurlyDoubleQuote]names file\[CloseCurlyDoubleQuote] which contains a \
sequence of ",
  StyleBox["DeclarePackage", "MR"],
  " commands, specifying packages to load when particular names are used. \
Within a particular ",
  StyleBox["Mathematica", "TI"],
  " session, you then need to load explicitly only the names file. When you \
have done this, all the other packages will automatically be loaded if and \
when they are needed. "
}], "Text",
  CellTags->{"S2.7.11", "11.6"}],

Cell[TextData[{
  StyleBox["DeclarePackage", "MR"],
  " works by immediately creating symbols with the names you specify, but \
giving each of these symbols the special attribute ",
  StyleBox["Stub", "MR"],
  ". Whenever ",
  StyleBox["Mathematica", "TI"],
  " finds a symbol with the ",
  StyleBox["Stub", "MR"],
  " attribute, it automatically loads the package corresponding to the \
context of the symbol, in an attempt to find the definition of the symbol. "
}], "Text",
  CellTags->{"S2.7.11", "11.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.7.12 Manipulating Symbols and Contexts by Name", "Subsection",
  CellTags->{"S2.7.12", "12.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Symbol[\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["construct a symbol with a given name "]},
          {Cell[TextData[{
              StyleBox["SymbolName[", "MR"],
              StyleBox["symb", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["find the name of a symbol "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.12"],

Cell["Converting between symbols and their names. ", "Caption",
  CellTags->"S2.7.12"],

Cell[TextData[{
  "Here is the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.2"}],

Cell[CellGroupData[{

Cell["x // InputForm", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.12"],

Cell["x", "Output",
  CellLabel->"Out[1]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell["Its name is a string. ", "MathCaption",
  CellTags->{"S2.7.12", "12.3"}],

Cell[CellGroupData[{

Cell["SymbolName[x] // InputForm", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.12"],

Cell["\"x\"", "Output",
  CellLabel->"Out[2]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "This gives the symbol ",
  StyleBox["x", "MR"],
  " again. "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.4"}],

Cell[CellGroupData[{

Cell["Symbol[\"x\"] // InputForm", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.12"],

Cell["x", "Output",
  CellLabel->"Out[3]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "Once you have made an assignment such as ",
  StyleBox["x", "MR"],
  " ",
  StyleBox["=", "MR"],
  " ",
  StyleBox["2", "MR"],
  ", then whenever ",
  StyleBox["x", "MR"],
  " is evaluated, it is replaced by ",
  StyleBox["2", "MR"],
  ". Sometimes, however, you may want to continue to refer to ",
  StyleBox["x", "MR"],
  " itself, without immediately getting the value of ",
  StyleBox["x", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.12", "12.5"}],

Cell[TextData[{
  "You can do this by referring to ",
  StyleBox["x", "MR"],
  " by name. The name of the symbol ",
  StyleBox["x", "MR"],
  " is the string ",
  StyleBox["\"x\"", "MR"],
  ", and even though ",
  StyleBox["x", "MR"],
  " itself may be replaced by a value, the string ",
  StyleBox["\"x\"", "MR"],
  " will always stay the same. "
}], "Text",
  CellTags->{"S2.7.12", "12.6"}],

Cell[TextData[{
  "The names of the symbols ",
  StyleBox["x", "MR"],
  " and ",
  StyleBox["xp", "MR"],
  " are the strings ",
  StyleBox["\"x\"", "MR"],
  " and ",
  StyleBox["\"xp\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.7"}],

Cell[CellGroupData[{

Cell["t = {SymbolName[x], SymbolName[xp]} // InputForm", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.12"],

Cell["{\"x\", \"xp\"}", "Output",
  CellLabel->"Out[4]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "This assigns a value to ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.8"}],

Cell[CellGroupData[{

Cell["x = 2", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.12"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "Whenever you enter ",
  StyleBox["x", "MR"],
  " it is now replaced by ",
  StyleBox["2", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.9"}],

Cell[CellGroupData[{

Cell["{x, xp} // InputForm", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.7.12"],

Cell["{2, xp}", "Output",
  CellLabel->"Out[6]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "The name ",
  StyleBox["\"x\"", "MR"],
  " is not affected, however. "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.10"}],

Cell[CellGroupData[{

Cell["t // InputForm", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.7.12"],

Cell["InputForm[{\"x\", \"xp\"}]", "Output",
  CellLabel->"Out[7]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NameQ[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether any symbol has a name which matches ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Names[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of all symbol names which match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Contexts[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["`\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of all context names which match ",
              StyleBox["form", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.7.12"],

Cell["Referring to symbols and contexts by name. ", "Caption",
  CellTags->"S2.7.12"],

Cell[TextData[{
  StyleBox["x", "MR"],
  " and ",
  StyleBox["xp", "MR"],
  " are symbols that have been created in this ",
  StyleBox["Mathematica", "TI"],
  " session; ",
  StyleBox["xpp", "MR"],
  " is not. "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.11"}],

Cell[CellGroupData[{

Cell["{NameQ[\"x\"], NameQ[\"xp\"], NameQ[\"xpp\"]}", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.7.12"],

Cell[BoxData[
    \({True, True, False}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "You can specify the form of symbol names using ",
  StyleBox["string patterns", "TI"],
  " of the kind discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.8.4",
    ButtonData:>{"2.8.4", "4.1"},
    ButtonStyle->"MainBookLink"],
  ". ",
  StyleBox["\"x*\"", "MR"],
  " stands, for example, for all names that start with ",
  StyleBox["x", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.7.12", "12.12"}],

Cell[TextData[{
  "This gives a list of all symbol names in this ",
  StyleBox["Mathematica", "TI"],
  " session that begin with\[NonBreakingSpace]",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.13"}],

Cell[CellGroupData[{

Cell["Names[\"x*\"] // InputForm", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.7.12"],

Cell["{\"x\", \"xp\"}", "Output",
  CellLabel->"Out[9]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "These names correspond to built\[Hyphen]in functions in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.14"}],

Cell[CellGroupData[{

Cell["Names[\"Qu*\"] // InputForm", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.7.12"],

Cell["\<\
{\"Quantile\", \"Quartics\", \"QuasiMonteCarlo\",   \
\"QuasiNewton\", \"Quit\", \"Quotient\"}\
\>", "Output",
  CellLabel->"Out[10]//InputForm= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "This asks for names \[OpenCurlyDoubleQuote]close\[CloseCurlyDoubleQuote] \
to ",
  StyleBox["WeierstrssP", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.15"}],

Cell[CellGroupData[{

Cell["Names[\"WeierstrssP\", SpellingCorrection->True]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.7.12"],

Cell[BoxData[
    \({"WeierstrassP"}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Clear[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "clear the values of all symbols whose names match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Clear[\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`*\"]", "MR"],
              " "
            }]], Cell[
            "clear the values of all symbols in the specified context "]},
          {Cell[TextData[{
              StyleBox["Remove[\"", "MR"],
              StyleBox["form", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove completely all symbols whose names match ",
              StyleBox["form", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Remove[\"", "MR"],
              StyleBox["context", "TI"],
              StyleBox["`*\"]", "MR"],
              " "
            }]], Cell[
            "remove completely all symbols in the specified context "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.12"],

Cell["Getting rid of symbols by name. ", "Caption",
  CellTags->"S2.7.12"],

Cell[TextData[{
  "This clears the values of all symbols whose names start with ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.16"}],

Cell["Clear[\"x*\"]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.7.12"],

Cell[TextData[{
  "The name ",
  StyleBox["\"x\"", "MR"],
  " is still known, however. "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.17"}],

Cell[CellGroupData[{

Cell["Names[\"x*\"]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.7.12"],

Cell[BoxData[
    \({"x", "xp"}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "But the value of ",
  StyleBox["x", "MR"],
  " has been cleared. "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.18"}],

Cell[CellGroupData[{

Cell["{x, xp}", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.7.12"],

Cell[BoxData[
    \({x, xp}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[TextData[{
  "This removes completely all symbols whose names start with ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.19"}],

Cell["Remove[\"x*\"]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.7.12"],

Cell[TextData[{
  "Now not even the name ",
  StyleBox["\"x\"", "MR"],
  " is known. "
}], "MathCaption",
  CellTags->{"S2.7.12", "12.20"}],

Cell[CellGroupData[{

Cell["Names[\"x*\"]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.7.12"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.7.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Remove[\"Global`*\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "remove completely all symbols in the ",
              StyleBox["Global`", "MR"],
              " context "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.12"],

Cell["Removing all symbols you have introduced. ", "Caption",
  CellTags->"S2.7.12"],

Cell[TextData[{
  "If you do not set up any additional contexts, then all the symbols that \
you introduce in a ",
  StyleBox["Mathematica", "TI"],
  " session will be placed in the ",
  StyleBox["Global`", "MR"],
  " context. You can remove these symbols completely using ",
  StyleBox["Remove[\"Global`*\"]", "MR"],
  ". Built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " objects are in the ",
  StyleBox["System`", "MR"],
  " context, and are thus unaffected by this.  "
}], "Text",
  CellTags->{"S2.7.12", "12.21"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.7.13 Advanced Topic: Intercepting the Creation of New \
Symbols\
\>", "Subsection",
  CellTags->{"S2.7.13", "13.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " creates a new symbol when you first enter a particular name. Sometimes it \
is useful to \[OpenCurlyDoubleQuote]intercept\[CloseCurlyDoubleQuote] the \
process of creating a new symbol. ",
  StyleBox["Mathematica", "TI"],
  " provides several ways to do this. "
}], "Text",
  CellTags->{"S2.7.13", "13.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["On[General::newsym]", "MR"],
              " "
            }]], Cell["print a message whenever a new symbol is created "]},
          {Cell[TextData[{
              StyleBox["Off[General::newsym]", "MR"],
              " "
            }]], Cell[
            "switch off the message printed when new symbols are created "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.13"],

Cell["Printing a message when new symbols are created. ", "Caption",
  CellTags->"S2.7.13"],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to print a message whenever a new symbol is created. "
}], "MathCaption",
  CellTags->{"S2.7.13", "13.3"}],

Cell["On[General::newsym]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.7.13"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " now prints a message about each new symbol that it creates. "
}], "MathCaption",
  CellTags->{"S2.7.13", "13.4"}],

Cell[CellGroupData[{

Cell["sin[k]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.7.13"],

Cell[BoxData[
    \(General::"newsym" \(\(:\)\(\ \)\) 
      "Symbol \!\(sin\) is new."\)], "Message",
  CellTags->"S2.7.13"],

Cell[BoxData[
    \(General::"newsym" \(\(:\)\(\ \)\) "Symbol \!\(k\) is new."\)], "Message",\

  CellTags->"S2.7.13"],

Cell[BoxData[
    \(sin[k]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.7.13"]
}, Open  ]],

Cell["This switches off the message. ", "MathCaption",
  CellTags->{"S2.7.13", "13.5"}],

Cell["Off[General::newsym]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.7.13"],

Cell[TextData[{
  "Generating a message when ",
  StyleBox["Mathematica", "TI"],
  " creates a new symbol is often a good way to catch typing mistakes. ",
  StyleBox["Mathematica", "TI"],
  " itself cannot tell the difference between an intentionally new name, and \
a misspelling of a name it already knows. But by reporting all new names it \
encounters, ",
  StyleBox["Mathematica", "TI"],
  " allows you to see whether any of them are mistakes. "
}], "Text",
  CellTags->{"S2.7.13", "13.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$NewSymbol", "MR"],
              " "
            }]], 
            Cell["\<\
a function to be applied to the name and context of new \
symbols which are created \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.7.13"],

Cell["Performing operations when new symbols are created. ", "Caption",
  CellTags->"S2.7.13"],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " creates a new symbol, you may want it not just to print a message, but \
instead to perform some other action. Any function you specify as the value \
of the global variable ",
  StyleBox["$NewSymbol", "MR"],
  " will automatically be applied to strings giving the name and context of \
each new symbol that ",
  StyleBox["Mathematica", "TI"],
  " creates. "
}], "Text",
  CellTags->{"S2.7.13", "13.7"}],

Cell["\<\
This defines a function to be applied to each new symbol which is \
created. \
\>", "MathCaption",
  CellTags->{"S2.7.13", "13.8"}],

Cell[CellGroupData[{

Cell["$NewSymbol = Print[\"Name: \", #1, \" Context: \", #2]&", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.7.13"],

Cell[BoxData[
    \(Print["Name: ", #1, "  Context: ", #2] &\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.7.13"]
}, Open  ]],

Cell[TextData[{
  "The function is applied once to ",
  StyleBox["v", "MR"],
  " and once to ",
  StyleBox["w", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.7.13", "13.9"}],

Cell[CellGroupData[{

Cell["v + w", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.7.13"],

Cell[BoxData[
    InterpretationBox[\("Name: "\[InvisibleSpace]"v"\[InvisibleSpace]"  \
Context: "\[InvisibleSpace]"Global`"\),
      SequenceForm[ "Name: ", "v", "  Context: ", "Global`"],
      Editable->False]], "Print",
  CellTags->"S2.7.13"],

Cell[BoxData[
    InterpretationBox[\("Name: "\[InvisibleSpace]"w"\[InvisibleSpace]"  \
Context: "\[InvisibleSpace]"Global`"\),
      SequenceForm[ "Name: ", "w", "  Context: ", "Global`"],
      Editable->False]], "Print",
  CellTags->"S2.7.13"],

Cell[BoxData[
    \(v + w\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.7.13"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.7.0"->{
    Cell[1776, 53, 138, 4, 65, "Section",
      CellTags->{"S2.7.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 138, 4, 65, "Section",
      CellTags->{"S2.7.0", "0.1"}]},
  "S2.7.1"->{
    Cell[1939, 61, 86, 1, 70, "Subsection",
      CellTags->{"S2.7.1", "1.1"}],
    Cell[2028, 64, 384, 12, 70, "Text",
      CellTags->{"S2.7.1", "1.2"}],
    Cell[2415, 78, 442, 11, 70, "Text",
      CellTags->{"S2.7.1", "1.3"}],
    Cell[2860, 91, 283, 8, 70, "Text",
      CellTags->{"S2.7.1", "1.4"}],
    Cell[3146, 101, 902, 30, 70, "DefinitionBox",
      CellTags->"S2.7.1"],
    Cell[4051, 133, 118, 5, 70, "Caption",
      CellTags->"S2.7.1"],
    Cell[4172, 140, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.5"}],
    Cell[4348, 149, 70, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[4421, 153, 83, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[4519, 159, 214, 8, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.6"}],
    Cell[4758, 171, 90, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[4851, 175, 56, 2, 70, "Print",
      CellTags->"S2.7.1"],
    Cell[4922, 180, 131, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.7"}],
    Cell[5078, 189, 65, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[5146, 193, 83, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[5244, 199, 371, 7, 70, "Text",
      CellTags->{"S2.7.1", "1.8"}],
    Cell[5618, 208, 166, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.9"}],
    Cell[5787, 215, 115, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[5905, 219, 125, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.10"}],
    Cell[6055, 228, 72, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[6130, 232, 120, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[6265, 238, 132, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.11"}],
    Cell[6422, 247, 65, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[6490, 251, 83, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[6588, 257, 238, 5, 70, "Text",
      CellTags->{"S2.7.1", "1.12"}],
    Cell[6829, 264, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.13"}],
    Cell[6987, 271, 142, 5, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[7132, 278, 165, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.14"}],
    Cell[7322, 287, 73, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[7398, 291, 88, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[7501, 297, 153, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.15"}],
    Cell[7679, 306, 73, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[7755, 310, 88, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[7858, 316, 343, 7, 70, "Text",
      CellTags->{"S2.7.1", "1.16"}],
    Cell[8204, 325, 170, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.17"}],
    Cell[8399, 334, 82, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[8484, 338, 86, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[8585, 344, 153, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.18"}],
    Cell[8763, 353, 90, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[8856, 357, 83, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[8954, 363, 240, 7, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.19"}],
    Cell[9219, 374, 103, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[9325, 378, 83, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[9423, 384, 1266, 38, 70, "DefinitionBox",
      CellTags->"S2.7.1"],
    Cell[10692, 424, 86, 1, 70, "Caption",
      CellTags->"S2.7.1"],
    Cell[10781, 427, 190, 7, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.20"}],
    Cell[10974, 436, 107, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[11084, 440, 130, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.21"}],
    Cell[11239, 449, 69, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[11311, 453, 98, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[11424, 459, 417, 9, 70, "Text",
      CellTags->{"S2.7.1", "1.22"}],
    Cell[11844, 470, 188, 7, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.23"}],
    Cell[12057, 481, 92, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[12152, 485, 85, 3, 70, "Output",
      CellTags->"S2.7.1"],
    Cell[12252, 491, 892, 29, 70, "DefinitionBox",
      CellTags->"S2.7.1"],
    Cell[13147, 522, 95, 1, 70, "Caption",
      CellTags->"S2.7.1"],
    Cell[13245, 525, 474, 10, 70, "Text",
      CellTags->{"S2.7.1", "1.24"}],
    Cell[13722, 537, 106, 1, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.25"}],
    Cell[13831, 540, 113, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[13947, 544, 241, 6, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.26"}],
    Cell[14213, 554, 70, 2, 70, "Input",
      CellTags->"S2.7.1"],
    Cell[14286, 558, 84, 3, 70, "Output",
      CellTags->"S2.7.1"]},
  "1.1"->{
    Cell[1939, 61, 86, 1, 70, "Subsection",
      CellTags->{"S2.7.1", "1.1"}]},
  "1.2"->{
    Cell[2028, 64, 384, 12, 70, "Text",
      CellTags->{"S2.7.1", "1.2"}]},
  "1.3"->{
    Cell[2415, 78, 442, 11, 70, "Text",
      CellTags->{"S2.7.1", "1.3"}]},
  "1.4"->{
    Cell[2860, 91, 283, 8, 70, "Text",
      CellTags->{"S2.7.1", "1.4"}]},
  "1.5"->{
    Cell[4172, 140, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.5"}]},
  "1.6"->{
    Cell[4519, 159, 214, 8, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.6"}]},
  "1.7"->{
    Cell[4922, 180, 131, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.7"}]},
  "1.8"->{
    Cell[5244, 199, 371, 7, 70, "Text",
      CellTags->{"S2.7.1", "1.8"}]},
  "1.9"->{
    Cell[5618, 208, 166, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.9"}]},
  "1.10"->{
    Cell[5905, 219, 125, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.10"}]},
  "1.11"->{
    Cell[6265, 238, 132, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.11"}]},
  "1.12"->{
    Cell[6588, 257, 238, 5, 70, "Text",
      CellTags->{"S2.7.1", "1.12"}]},
  "1.13"->{
    Cell[6829, 264, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.13"}]},
  "1.14"->{
    Cell[7132, 278, 165, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.14"}]},
  "1.15"->{
    Cell[7501, 297, 153, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.15"}]},
  "1.16"->{
    Cell[7858, 316, 343, 7, 70, "Text",
      CellTags->{"S2.7.1", "1.16"}]},
  "1.17"->{
    Cell[8204, 325, 170, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.17"}]},
  "1.18"->{
    Cell[8585, 344, 153, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.18"}]},
  "1.19"->{
    Cell[8954, 363, 240, 7, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.19"}]},
  "1.20"->{
    Cell[10781, 427, 190, 7, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.20"}]},
  "1.21"->{
    Cell[11084, 440, 130, 5, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.21"}]},
  "1.22"->{
    Cell[11424, 459, 417, 9, 70, "Text",
      CellTags->{"S2.7.1", "1.22"}]},
  "1.23"->{
    Cell[11844, 470, 188, 7, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.23"}]},
  "1.24"->{
    Cell[13245, 525, 474, 10, 70, "Text",
      CellTags->{"S2.7.1", "1.24"}]},
  "1.25"->{
    Cell[13722, 537, 106, 1, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.25"}]},
  "1.26"->{
    Cell[13947, 544, 241, 6, 70, "MathCaption",
      CellTags->{"S2.7.1", "1.26"}]},
  "S2.7.2"->{
    Cell[14419, 567, 74, 1, 70, "Subsection",
      CellTags->{"S2.7.2", "2.1"}],
    Cell[14496, 570, 1437, 46, 70, "DefinitionBox",
      CellTags->"S2.7.2"],
    Cell[15936, 618, 67, 1, 70, "Caption",
      CellTags->"S2.7.2"],
    Cell[16006, 621, 462, 13, 70, "Text",
      CellTags->{"S2.7.2", "2.2"}],
    Cell[16471, 636, 133, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.3"}],
    Cell[16629, 645, 70, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[16702, 649, 83, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[16800, 655, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.4"}],
    Cell[16954, 662, 99, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[17056, 666, 129, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.5"}],
    Cell[17210, 675, 68, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[17281, 679, 103, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[17399, 685, 122, 4, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.6"}],
    Cell[17546, 693, 65, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[17614, 697, 83, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[17712, 703, 247, 9, 70, "Text",
      CellTags->{"S2.7.2", "2.7"}],
    Cell[17962, 714, 310, 13, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.8"}],
    Cell[18297, 731, 86, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[18386, 735, 84, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[18485, 741, 940, 38, 70, "Text",
      CellTags->{"S2.7.2", "2.9"}],
    Cell[19428, 781, 151, 7, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.10"}],
    Cell[19604, 792, 84, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[19691, 796, 82, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[19788, 802, 323, 15, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.11"}],
    Cell[20136, 821, 65, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[20204, 825, 82, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[20301, 831, 127, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.12"}],
    Cell[20431, 838, 72, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[20506, 842, 240, 7, 70, "Text",
      CellTags->{"S2.7.2", "2.13"}],
    Cell[20749, 851, 738, 19, 70, "Text",
      CellTags->{"S2.7.2", "2.14"}],
    Cell[21490, 872, 393, 11, 70, "Text",
      CellTags->{"S2.7.2", "2.15"}],
    Cell[21886, 885, 175, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.16"}],
    Cell[22086, 894, 97, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[22186, 898, 83, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[22284, 904, 167, 7, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.17"}],
    Cell[22476, 915, 100, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[22579, 919, 84, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[22678, 925, 153, 4, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.18"}],
    Cell[22856, 933, 100, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[22959, 937, 87, 3, 70, "Output",
      CellTags->"S2.7.2"],
    Cell[23061, 943, 1330, 52, 70, "Text",
      CellTags->{"S2.7.2", "2.19"}],
    Cell[24394, 997, 240, 9, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.20"}],
    Cell[24659, 1010, 110, 2, 70, "Input",
      CellTags->"S2.7.2"],
    Cell[24772, 1014, 120, 3, 70, "Output",
      CellTags->"S2.7.2"]},
  "2.1"->{
    Cell[14419, 567, 74, 1, 70, "Subsection",
      CellTags->{"S2.7.2", "2.1"}]},
  "2.2"->{
    Cell[16006, 621, 462, 13, 70, "Text",
      CellTags->{"S2.7.2", "2.2"}]},
  "2.3"->{
    Cell[16471, 636, 133, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.3"}]},
  "2.4"->{
    Cell[16800, 655, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.4"}]},
  "2.5"->{
    Cell[17056, 666, 129, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.5"}]},
  "2.6"->{
    Cell[17399, 685, 122, 4, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.6"}]},
  "2.7"->{
    Cell[17712, 703, 247, 9, 70, "Text",
      CellTags->{"S2.7.2", "2.7"}]},
  "2.8"->{
    Cell[17962, 714, 310, 13, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.8"}]},
  "2.9"->{
    Cell[18485, 741, 940, 38, 70, "Text",
      CellTags->{"S2.7.2", "2.9"}]},
  "2.10"->{
    Cell[19428, 781, 151, 7, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.10"}]},
  "2.11"->{
    Cell[19788, 802, 323, 15, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.11"}]},
  "2.12"->{
    Cell[20301, 831, 127, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.12"}]},
  "2.13"->{
    Cell[20506, 842, 240, 7, 70, "Text",
      CellTags->{"S2.7.2", "2.13"}]},
  "2.14"->{
    Cell[20749, 851, 738, 19, 70, "Text",
      CellTags->{"S2.7.2", "2.14"}]},
  "2.15"->{
    Cell[21490, 872, 393, 11, 70, "Text",
      CellTags->{"S2.7.2", "2.15"}]},
  "2.16"->{
    Cell[21886, 885, 175, 5, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.16"}]},
  "2.17"->{
    Cell[22284, 904, 167, 7, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.17"}]},
  "2.18"->{
    Cell[22678, 925, 153, 4, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.18"}]},
  "2.19"->{
    Cell[23061, 943, 1330, 52, 70, "Text",
      CellTags->{"S2.7.2", "2.19"}]},
  "2.20"->{
    Cell[24394, 997, 240, 9, 70, "MathCaption",
      CellTags->{"S2.7.2", "2.20"}]},
  "S2.7.3"->{
    Cell[24941, 1023, 75, 1, 70, "Subsection",
      CellTags->{"S2.7.3", "3.1"}],
    Cell[25019, 1026, 542, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.2"}],
    Cell[25564, 1039, 284, 7, 70, "Text",
      CellTags->{"S2.7.3", "3.3"}],
    Cell[25851, 1048, 536, 15, 70, "FramedBox",
      CellTags->"S2.7.3"],
    Cell[26390, 1065, 132, 5, 70, "Caption",
      CellTags->"S2.7.3"],
    Cell[26525, 1072, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.4"}],
    Cell[26705, 1081, 85, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[26793, 1085, 58, 2, 70, "Print",
      CellTags->"S2.7.3"],
    Cell[26866, 1090, 113, 2, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.5"}],
    Cell[27004, 1096, 98, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[27105, 1100, 58, 2, 70, "Print",
      CellTags->"S2.7.3"],
    Cell[27166, 1104, 58, 2, 70, "Print",
      CellTags->"S2.7.3"],
    Cell[27239, 1109, 407, 8, 70, "Text",
      CellTags->{"S2.7.3", "3.6"}],
    Cell[27649, 1119, 172, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.7"}],
    Cell[27846, 1128, 91, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[27940, 1132, 388, 14, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[28343, 1149, 92, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.8"}],
    Cell[28438, 1152, 93, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[28534, 1156, 180, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.9"}],
    Cell[28739, 1166, 72, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[28814, 1170, 304, 10, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[29133, 1183, 134, 4, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.10"}],
    Cell[29292, 1191, 71, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[29366, 1195, 82, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[29463, 1201, 85, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.11"}],
    Cell[29573, 1206, 79, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[29655, 1210, 83, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[29753, 1216, 165, 4, 70, "Text",
      CellTags->{"S2.7.3", "3.12"}],
    Cell[29921, 1222, 134, 4, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.13"}],
    Cell[30080, 1230, 78, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[30161, 1234, 84, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[30260, 1240, 108, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.14"}],
    Cell[30393, 1245, 71, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[30467, 1249, 91, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[30573, 1255, 1015, 31, 70, "DefinitionBox",
      CellTags->"S2.7.3"],
    Cell[31591, 1288, 83, 1, 70, "Caption",
      CellTags->"S2.7.3"],
    Cell[31677, 1291, 384, 12, 70, "Text",
      CellTags->{"S2.7.3", "3.15"}],
    Cell[32064, 1305, 160, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.16"}],
    Cell[32249, 1314, 74, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[32326, 1318, 84, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[32425, 1324, 171, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.17"}],
    Cell[32621, 1333, 98, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[32722, 1337, 97, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[32834, 1343, 198, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.18"}],
    Cell[33057, 1353, 84, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[33144, 1357, 101, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[33260, 1363, 317, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.19"}],
    Cell[33580, 1376, 171, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.20"}],
    Cell[33776, 1386, 85, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[33864, 1390, 93, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[33972, 1396, 94, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.21"}],
    Cell[34091, 1401, 68, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[34162, 1405, 48, 1, 70, "Print",
      CellTags->"S2.7.3"],
    Cell[34225, 1409, 562, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.22"}],
    Cell[34790, 1422, 154, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.23"}],
    Cell[34969, 1431, 86, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[35058, 1435, 59, 2, 70, "Print",
      CellTags->"S2.7.3"],
    Cell[35132, 1440, 168, 4, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.24"}],
    Cell[35325, 1448, 68, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[35396, 1452, 48, 1, 70, "Print",
      CellTags->"S2.7.3"],
    Cell[35459, 1456, 402, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.25"}],
    Cell[35864, 1469, 412, 10, 70, "Text",
      CellTags->{"S2.7.3", "3.26"}],
    Cell[36279, 1481, 248, 5, 70, "Text",
      CellTags->{"S2.7.3", "3.27"}],
    Cell[36530, 1488, 822, 22, 70, "Text",
      CellTags->{"S2.7.3", "3.28"}],
    Cell[37355, 1512, 802, 24, 70, "DefinitionBox",
      CellTags->"S2.7.3"],
    Cell[38160, 1538, 125, 4, 70, "Caption",
      CellTags->"S2.7.3"],
    Cell[38288, 1544, 755, 20, 70, "Text",
      CellTags->{"S2.7.3", "3.29"}],
    Cell[39046, 1566, 512, 17, 70, "Text",
      CellTags->{"S2.7.3", "3.30"}],
    Cell[39561, 1585, 334, 10, 70, "Text",
      CellTags->{"S2.7.3", "3.31"}],
    Cell[39898, 1597, 192, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.32"}],
    Cell[40115, 1607, 100, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[40218, 1611, 90, 3, 70, "Output",
      CellTags->"S2.7.3"],
    Cell[40323, 1617, 551, 18, 70, "Text",
      CellTags->{"S2.7.3", "3.33"}],
    Cell[40877, 1637, 395, 10, 70, "Text",
      CellTags->{"S2.7.3", "3.34"}],
    Cell[41275, 1649, 178, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.35"}],
    Cell[41478, 1658, 110, 2, 70, "Input",
      CellTags->"S2.7.3"],
    Cell[41591, 1662, 84, 3, 70, "Output",
      CellTags->"S2.7.3"]},
  "3.1"->{
    Cell[24941, 1023, 75, 1, 70, "Subsection",
      CellTags->{"S2.7.3", "3.1"}]},
  "3.2"->{
    Cell[25019, 1026, 542, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.2"}]},
  "3.3"->{
    Cell[25564, 1039, 284, 7, 70, "Text",
      CellTags->{"S2.7.3", "3.3"}]},
  "3.4"->{
    Cell[26525, 1072, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.4"}]},
  "3.5"->{
    Cell[26866, 1090, 113, 2, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.5"}]},
  "3.6"->{
    Cell[27239, 1109, 407, 8, 70, "Text",
      CellTags->{"S2.7.3", "3.6"}]},
  "3.7"->{
    Cell[27649, 1119, 172, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.7"}]},
  "3.8"->{
    Cell[28343, 1149, 92, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.8"}]},
  "3.9"->{
    Cell[28534, 1156, 180, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.9"}]},
  "3.10"->{
    Cell[29133, 1183, 134, 4, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.10"}]},
  "3.11"->{
    Cell[29463, 1201, 85, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.11"}]},
  "3.12"->{
    Cell[29753, 1216, 165, 4, 70, "Text",
      CellTags->{"S2.7.3", "3.12"}]},
  "3.13"->{
    Cell[29921, 1222, 134, 4, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.13"}]},
  "3.14"->{
    Cell[30260, 1240, 108, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.14"}]},
  "3.15"->{
    Cell[31677, 1291, 384, 12, 70, "Text",
      CellTags->{"S2.7.3", "3.15"}]},
  "3.16"->{
    Cell[32064, 1305, 160, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.16"}]},
  "3.17"->{
    Cell[32425, 1324, 171, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.17"}]},
  "3.18"->{
    Cell[32834, 1343, 198, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.18"}]},
  "3.19"->{
    Cell[33260, 1363, 317, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.19"}]},
  "3.20"->{
    Cell[33580, 1376, 171, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.20"}]},
  "3.21"->{
    Cell[33972, 1396, 94, 1, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.21"}]},
  "3.22"->{
    Cell[34225, 1409, 562, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.22"}]},
  "3.23"->{
    Cell[34790, 1422, 154, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.23"}]},
  "3.24"->{
    Cell[35132, 1440, 168, 4, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.24"}]},
  "3.25"->{
    Cell[35459, 1456, 402, 11, 70, "Text",
      CellTags->{"S2.7.3", "3.25"}]},
  "3.26"->{
    Cell[35864, 1469, 412, 10, 70, "Text",
      CellTags->{"S2.7.3", "3.26"}]},
  "3.27"->{
    Cell[36279, 1481, 248, 5, 70, "Text",
      CellTags->{"S2.7.3", "3.27"}]},
  "3.28"->{
    Cell[36530, 1488, 822, 22, 70, "Text",
      CellTags->{"S2.7.3", "3.28"}]},
  "3.29"->{
    Cell[38288, 1544, 755, 20, 70, "Text",
      CellTags->{"S2.7.3", "3.29"}]},
  "3.30"->{
    Cell[39046, 1566, 512, 17, 70, "Text",
      CellTags->{"S2.7.3", "3.30"}]},
  "3.31"->{
    Cell[39561, 1585, 334, 10, 70, "Text",
      CellTags->{"S2.7.3", "3.31"}]},
  "3.32"->{
    Cell[39898, 1597, 192, 6, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.32"}]},
  "3.33"->{
    Cell[40323, 1617, 551, 18, 70, "Text",
      CellTags->{"S2.7.3", "3.33"}]},
  "3.34"->{
    Cell[40877, 1637, 395, 10, 70, "Text",
      CellTags->{"S2.7.3", "3.34"}]},
  "3.35"->{
    Cell[41275, 1649, 178, 5, 70, "MathCaption",
      CellTags->{"S2.7.3", "3.35"}]},
  "S2.7.4"->{
    Cell[41724, 1671, 114, 2, 70, "Subsection",
      CellTags->{"S2.7.4", "4.1"}],
    Cell[41841, 1675, 310, 8, 70, "Text",
      CellTags->{"S2.7.4", "4.2"}],
    Cell[42154, 1685, 701, 29, 70, "Text",
      CellTags->{"S2.7.4", "4.3"}],
    Cell[42858, 1716, 539, 13, 70, "Text",
      CellTags->{"S2.7.4", "4.4"}],
    Cell[43400, 1731, 86, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.5"}],
    Cell[43511, 1736, 99, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[43613, 1740, 116, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[43744, 1746, 257, 8, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.6"}],
    Cell[44026, 1758, 69, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[44098, 1762, 106, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[44219, 1768, 104, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.7"}],
    Cell[44348, 1773, 68, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[44419, 1777, 89, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[44523, 1783, 411, 14, 70, "Text",
      CellTags->{"S2.7.4", "4.8"}],
    Cell[44937, 1799, 189, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.9"}],
    Cell[45151, 1808, 103, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[45257, 1812, 103, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[45375, 1818, 156, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.10"}],
    Cell[45556, 1826, 105, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[45664, 1830, 104, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[45783, 1836, 512, 10, 70, "Text",
      CellTags->{"S2.7.4", "4.11"}],
    Cell[46298, 1848, 219, 6, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.12"}],
    Cell[46542, 1858, 103, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[46648, 1862, 101, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[46764, 1868, 88, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.13"}],
    Cell[46877, 1873, 118, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[46998, 1877, 135, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[47148, 1883, 102, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.14"}],
    Cell[47275, 1888, 68, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[47346, 1892, 124, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[47485, 1898, 623, 17, 70, "Text",
      CellTags->{"S2.7.4", "4.15"}],
    Cell[48111, 1917, 2536, 81, 70, "DefinitionBox",
      CellTags->"S2.7.4"],
    Cell[50650, 2000, 120, 5, 70, "Caption",
      CellTags->"S2.7.4"],
    Cell[50773, 2007, 354, 8, 70, "Text",
      CellTags->{"S2.7.4", "4.16"}],
    Cell[51130, 2017, 176, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.17"}],
    Cell[51331, 2025, 99, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[51433, 2029, 103, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[51551, 2035, 173, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.18"}],
    Cell[51749, 2044, 106, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[51858, 2048, 110, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[51983, 2054, 138, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.19"}],
    Cell[52146, 2062, 110, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[52259, 2066, 112, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[52386, 2072, 166, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.20"}],
    Cell[52577, 2081, 104, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[52684, 2085, 108, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[52807, 2091, 162, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.21"}],
    Cell[52994, 2099, 79, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[53076, 2103, 89, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[53180, 2109, 453, 15, 70, "Text",
      CellTags->{"S2.7.4", "4.22"}],
    Cell[53636, 2126, 225, 9, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.23"}],
    Cell[53886, 2139, 96, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[53985, 2143, 103, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[54103, 2149, 526, 20, 70, "Text",
      CellTags->{"S2.7.4", "4.24"}],
    Cell[54632, 2171, 357, 10, 70, "Text",
      CellTags->{"S2.7.4", "4.25"}],
    Cell[54992, 2183, 182, 6, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.26"}],
    Cell[55199, 2193, 94, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[55296, 2197, 103, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[55414, 2203, 399, 11, 70, "Text",
      CellTags->{"S2.7.4", "4.27"}],
    Cell[55816, 2216, 254, 9, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.28"}],
    Cell[56095, 2229, 104, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[56202, 2233, 114, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[56331, 2239, 185, 7, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.29"}],
    Cell[56541, 2250, 99, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[56643, 2254, 112, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[56770, 2260, 904, 31, 70, "Text",
      CellTags->{"S2.7.4", "4.30"}],
    Cell[57677, 2293, 108, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.31"}],
    Cell[57788, 2296, 108, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[57899, 2300, 257, 10, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.32"}],
    Cell[58181, 2314, 78, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[58262, 2318, 101, 3, 70, "Output",
      CellTags->"S2.7.4"],
    Cell[58378, 2324, 135, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.33"}],
    Cell[58516, 2330, 138, 5, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[58657, 2337, 157, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.34"}],
    Cell[58839, 2346, 79, 2, 70, "Input",
      CellTags->"S2.7.4"],
    Cell[58921, 2350, 122, 3, 70, "Output",
      CellTags->"S2.7.4"]},
  "4.1"->{
    Cell[41724, 1671, 114, 2, 70, "Subsection",
      CellTags->{"S2.7.4", "4.1"}]},
  "4.2"->{
    Cell[41841, 1675, 310, 8, 70, "Text",
      CellTags->{"S2.7.4", "4.2"}]},
  "4.3"->{
    Cell[42154, 1685, 701, 29, 70, "Text",
      CellTags->{"S2.7.4", "4.3"}]},
  "4.4"->{
    Cell[42858, 1716, 539, 13, 70, "Text",
      CellTags->{"S2.7.4", "4.4"}]},
  "4.5"->{
    Cell[43400, 1731, 86, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.5"}]},
  "4.6"->{
    Cell[43744, 1746, 257, 8, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.6"}]},
  "4.7"->{
    Cell[44219, 1768, 104, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.7"}]},
  "4.8"->{
    Cell[44523, 1783, 411, 14, 70, "Text",
      CellTags->{"S2.7.4", "4.8"}]},
  "4.9"->{
    Cell[44937, 1799, 189, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.9"}]},
  "4.10"->{
    Cell[45375, 1818, 156, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.10"}]},
  "4.11"->{
    Cell[45783, 1836, 512, 10, 70, "Text",
      CellTags->{"S2.7.4", "4.11"}]},
  "4.12"->{
    Cell[46298, 1848, 219, 6, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.12"}]},
  "4.13"->{
    Cell[46764, 1868, 88, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.13"}]},
  "4.14"->{
    Cell[47148, 1883, 102, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.14"}]},
  "4.15"->{
    Cell[47485, 1898, 623, 17, 70, "Text",
      CellTags->{"S2.7.4", "4.15"}]},
  "4.16"->{
    Cell[50773, 2007, 354, 8, 70, "Text",
      CellTags->{"S2.7.4", "4.16"}]},
  "4.17"->{
    Cell[51130, 2017, 176, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.17"}]},
  "4.18"->{
    Cell[51551, 2035, 173, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.18"}]},
  "4.19"->{
    Cell[51983, 2054, 138, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.19"}]},
  "4.20"->{
    Cell[52386, 2072, 166, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.20"}]},
  "4.21"->{
    Cell[52807, 2091, 162, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.21"}]},
  "4.22"->{
    Cell[53180, 2109, 453, 15, 70, "Text",
      CellTags->{"S2.7.4", "4.22"}]},
  "4.23"->{
    Cell[53636, 2126, 225, 9, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.23"}]},
  "4.24"->{
    Cell[54103, 2149, 526, 20, 70, "Text",
      CellTags->{"S2.7.4", "4.24"}]},
  "4.25"->{
    Cell[54632, 2171, 357, 10, 70, "Text",
      CellTags->{"S2.7.4", "4.25"}]},
  "4.26"->{
    Cell[54992, 2183, 182, 6, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.26"}]},
  "4.27"->{
    Cell[55414, 2203, 399, 11, 70, "Text",
      CellTags->{"S2.7.4", "4.27"}]},
  "4.28"->{
    Cell[55816, 2216, 254, 9, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.28"}]},
  "4.29"->{
    Cell[56331, 2239, 185, 7, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.29"}]},
  "4.30"->{
    Cell[56770, 2260, 904, 31, 70, "Text",
      CellTags->{"S2.7.4", "4.30"}]},
  "4.31"->{
    Cell[57677, 2293, 108, 1, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.31"}]},
  "4.32"->{
    Cell[57899, 2300, 257, 10, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.32"}]},
  "4.33"->{
    Cell[58378, 2324, 135, 4, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.33"}]},
  "4.34"->{
    Cell[58657, 2337, 157, 5, 70, "MathCaption",
      CellTags->{"S2.7.4", "4.34"}]},
  "S2.7.5"->{
    Cell[59092, 2359, 89, 1, 70, "Subsection",
      CellTags->{"S2.7.5", "5.1"}],
    Cell[59184, 2362, 353, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.2"}],
    Cell[59540, 2372, 478, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.3"}],
    Cell[60021, 2382, 101, 1, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.4"}],
    Cell[60125, 2385, 103, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[60231, 2389, 150, 5, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.5"}],
    Cell[60406, 2398, 72, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[60481, 2402, 141, 4, 70, "Output",
      CellTags->"S2.7.5"],
    Cell[60637, 2409, 147, 4, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.6"}],
    Cell[60787, 2415, 117, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[60907, 2419, 208, 5, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.7"}],
    Cell[61140, 2428, 73, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[61216, 2432, 161, 4, 70, "Output",
      CellTags->"S2.7.5"],
    Cell[61392, 2439, 383, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.8"}],
    Cell[61778, 2449, 462, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.9"}],
    Cell[62243, 2459, 154, 5, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.10"}],
    Cell[62400, 2466, 98, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[62501, 2470, 141, 4, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.11"}],
    Cell[62667, 2478, 75, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[62745, 2482, 123, 3, 70, "Output",
      CellTags->"S2.7.5"],
    Cell[62883, 2488, 1321, 38, 70, "Text",
      CellTags->{"S2.7.5", "5.12"}],
    Cell[64207, 2528, 188, 7, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.13"}],
    Cell[64398, 2537, 91, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[64492, 2541, 128, 4, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.14"}],
    Cell[64645, 2549, 79, 2, 70, "Input",
      CellTags->"S2.7.5"],
    Cell[64727, 2553, 106, 3, 70, "Output",
      CellTags->"S2.7.5"],
    Cell[64848, 2559, 743, 14, 70, "Text",
      CellTags->{"S2.7.5", "5.15"}]},
  "5.1"->{
    Cell[59092, 2359, 89, 1, 70, "Subsection",
      CellTags->{"S2.7.5", "5.1"}]},
  "5.2"->{
    Cell[59184, 2362, 353, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.2"}]},
  "5.3"->{
    Cell[59540, 2372, 478, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.3"}]},
  "5.4"->{
    Cell[60021, 2382, 101, 1, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.4"}]},
  "5.5"->{
    Cell[60231, 2389, 150, 5, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.5"}]},
  "5.6"->{
    Cell[60637, 2409, 147, 4, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.6"}]},
  "5.7"->{
    Cell[60907, 2419, 208, 5, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.7"}]},
  "5.8"->{
    Cell[61392, 2439, 383, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.8"}]},
  "5.9"->{
    Cell[61778, 2449, 462, 8, 70, "Text",
      CellTags->{"S2.7.5", "5.9"}]},
  "5.10"->{
    Cell[62243, 2459, 154, 5, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.10"}]},
  "5.11"->{
    Cell[62501, 2470, 141, 4, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.11"}]},
  "5.12"->{
    Cell[62883, 2488, 1321, 38, 70, "Text",
      CellTags->{"S2.7.5", "5.12"}]},
  "5.13"->{
    Cell[64207, 2528, 188, 7, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.13"}]},
  "5.14"->{
    Cell[64492, 2541, 128, 4, 70, "MathCaption",
      CellTags->{"S2.7.5", "5.14"}]},
  "5.15"->{
    Cell[64848, 2559, 743, 14, 70, "Text",
      CellTags->{"S2.7.5", "5.15"}]},
  "S2.7.6"->{
    Cell[65628, 2578, 82, 1, 70, "Subsection",
      CellTags->{"S2.7.6", "6.1"}],
    Cell[65713, 2581, 401, 14, 70, "Text",
      CellTags->{"S2.7.6", "6.2"}],
    Cell[66117, 2597, 2196, 72, 70, "DefinitionBox",
      CellTags->"S2.7.6"],
    Cell[68316, 2671, 66, 1, 70, "Caption",
      CellTags->"S2.7.6"],
    Cell[68385, 2674, 133, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.3"}],
    Cell[68543, 2683, 71, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[68617, 2687, 89, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[68721, 2693, 165, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.4"}],
    Cell[68911, 2702, 85, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[68999, 2706, 99, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[69113, 2712, 130, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.5"}],
    Cell[69268, 2721, 65, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[69336, 2725, 82, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[69433, 2731, 1041, 35, 70, "Text",
      CellTags->{"S2.7.6", "6.6"}],
    Cell[70477, 2768, 185, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.7"}],
    Cell[70687, 2779, 70, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[70760, 2783, 83, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[70858, 2789, 100, 1, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.8"}],
    Cell[70983, 2794, 85, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[71071, 2798, 58, 2, 70, "Print",
      CellTags->"S2.7.6"],
    Cell[71144, 2803, 139, 4, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.9"}],
    Cell[71308, 2811, 84, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[71395, 2815, 56, 2, 70, "Print",
      CellTags->"S2.7.6"],
    Cell[71466, 2820, 136, 4, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.10"}],
    Cell[71627, 2828, 90, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[71720, 2832, 85, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[71820, 2838, 177, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.11"}],
    Cell[72022, 2847, 65, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[72090, 2851, 83, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[72188, 2857, 548, 10, 70, "Text",
      CellTags->{"S2.7.6", "6.12"}],
    Cell[72739, 2869, 146, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.13"}],
    Cell[72888, 2876, 78, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[72969, 2880, 194, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.14"}],
    Cell[73188, 2891, 66, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[73257, 2895, 92, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[73364, 2901, 164, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.15"}],
    Cell[73553, 2910, 86, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[73642, 2914, 91, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[73748, 2920, 481, 18, 70, "Text",
      CellTags->{"S2.7.6", "6.16"}],
    Cell[74232, 2940, 180, 6, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.17"}],
    Cell[74437, 2950, 82, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[74522, 2954, 85, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[74622, 2960, 272, 8, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.18"}],
    Cell[74919, 2972, 88, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[75010, 2976, 85, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[75110, 2982, 540, 12, 70, "Text",
      CellTags->{"S2.7.6", "6.19"}],
    Cell[75653, 2996, 422, 9, 70, "Text",
      CellTags->{"S2.7.6", "6.20"}],
    Cell[76078, 3007, 212, 6, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.21"}],
    Cell[76293, 3015, 81, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[76377, 3019, 144, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.22"}],
    Cell[76546, 3028, 69, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[76618, 3032, 91, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[76724, 3038, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.23"}],
    Cell[76900, 3047, 85, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[76988, 3051, 90, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[77093, 3057, 332, 6, 70, "Text",
      CellTags->{"S2.7.6", "6.24"}],
    Cell[77428, 3065, 178, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.25"}],
    Cell[77609, 3072, 84, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[77696, 3076, 201, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.26"}],
    Cell[77922, 3087, 69, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[77994, 3091, 91, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[78100, 3097, 152, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.27"}],
    Cell[78277, 3106, 85, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[78365, 3110, 86, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[78466, 3116, 140, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.28"}],
    Cell[78631, 3125, 66, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[78700, 3129, 91, 3, 70, "Output",
      CellTags->"S2.7.6"],
    Cell[78806, 3135, 615, 18, 70, "Text",
      CellTags->{"S2.7.6", "6.29"}],
    Cell[79424, 3155, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.30"}],
    Cell[79600, 3164, 101, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[79704, 3168, 70, 2, 70, "Print",
      CellTags->"S2.7.6"],
    Cell[79789, 3173, 223, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.31"}],
    Cell[80037, 3184, 84, 2, 70, "Input",
      CellTags->"S2.7.6"],
    Cell[80124, 3188, 109, 3, 70, "Output",
      CellTags->"S2.7.6"]},
  "6.1"->{
    Cell[65628, 2578, 82, 1, 70, "Subsection",
      CellTags->{"S2.7.6", "6.1"}]},
  "6.2"->{
    Cell[65713, 2581, 401, 14, 70, "Text",
      CellTags->{"S2.7.6", "6.2"}]},
  "6.3"->{
    Cell[68385, 2674, 133, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.3"}]},
  "6.4"->{
    Cell[68721, 2693, 165, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.4"}]},
  "6.5"->{
    Cell[69113, 2712, 130, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.5"}]},
  "6.6"->{
    Cell[69433, 2731, 1041, 35, 70, "Text",
      CellTags->{"S2.7.6", "6.6"}]},
  "6.7"->{
    Cell[70477, 2768, 185, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.7"}]},
  "6.8"->{
    Cell[70858, 2789, 100, 1, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.8"}]},
  "6.9"->{
    Cell[71144, 2803, 139, 4, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.9"}]},
  "6.10"->{
    Cell[71466, 2820, 136, 4, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.10"}]},
  "6.11"->{
    Cell[71820, 2838, 177, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.11"}]},
  "6.12"->{
    Cell[72188, 2857, 548, 10, 70, "Text",
      CellTags->{"S2.7.6", "6.12"}]},
  "6.13"->{
    Cell[72739, 2869, 146, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.13"}]},
  "6.14"->{
    Cell[72969, 2880, 194, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.14"}]},
  "6.15"->{
    Cell[73364, 2901, 164, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.15"}]},
  "6.16"->{
    Cell[73748, 2920, 481, 18, 70, "Text",
      CellTags->{"S2.7.6", "6.16"}]},
  "6.17"->{
    Cell[74232, 2940, 180, 6, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.17"}]},
  "6.18"->{
    Cell[74622, 2960, 272, 8, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.18"}]},
  "6.19"->{
    Cell[75110, 2982, 540, 12, 70, "Text",
      CellTags->{"S2.7.6", "6.19"}]},
  "6.20"->{
    Cell[75653, 2996, 422, 9, 70, "Text",
      CellTags->{"S2.7.6", "6.20"}]},
  "6.21"->{
    Cell[76078, 3007, 212, 6, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.21"}]},
  "6.22"->{
    Cell[76377, 3019, 144, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.22"}]},
  "6.23"->{
    Cell[76724, 3038, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.23"}]},
  "6.24"->{
    Cell[77093, 3057, 332, 6, 70, "Text",
      CellTags->{"S2.7.6", "6.24"}]},
  "6.25"->{
    Cell[77428, 3065, 178, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.25"}]},
  "6.26"->{
    Cell[77696, 3076, 201, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.26"}]},
  "6.27"->{
    Cell[78100, 3097, 152, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.27"}]},
  "6.28"->{
    Cell[78466, 3116, 140, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.28"}]},
  "6.29"->{
    Cell[78806, 3135, 615, 18, 70, "Text",
      CellTags->{"S2.7.6", "6.29"}]},
  "6.30"->{
    Cell[79424, 3155, 151, 5, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.30"}]},
  "6.31"->{
    Cell[79789, 3173, 223, 7, 70, "MathCaption",
      CellTags->{"S2.7.6", "6.31"}]},
  "S2.7.7"->{
    Cell[80282, 3197, 87, 1, 70, "Subsection",
      CellTags->{"S2.7.7", "7.1"}],
    Cell[80372, 3200, 305, 7, 70, "Text",
      CellTags->{"S2.7.7", "7.2"}],
    Cell[80680, 3209, 374, 8, 70, "Text",
      CellTags->{"S2.7.7", "7.3"}],
    Cell[81057, 3219, 218, 5, 70, "Text",
      CellTags->{"S2.7.7", "7.4"}],
    Cell[81278, 3226, 793, 24, 70, "DefinitionBox",
      CellTags->"S2.7.7"],
    Cell[82074, 3252, 120, 4, 70, "Caption",
      CellTags->"S2.7.7"],
    Cell[82197, 3258, 488, 11, 70, "Text",
      CellTags->{"S2.7.7", "7.5"}],
    Cell[82688, 3271, 339, 9, 70, "Text",
      CellTags->{"S2.7.7", "7.6"}],
    Cell[83030, 3282, 517, 10, 70, "Text",
      CellTags->{"S2.7.7", "7.7"}],
    Cell[83550, 3294, 607, 18, 70, "Text",
      CellTags->{"S2.7.7", "7.8"}],
    Cell[84160, 3314, 445, 17, 70, "Text",
      CellTags->{"S2.7.7", "7.9"}],
    Cell[84608, 3333, 157, 7, 70, "MathCaption",
      CellTags->{"S2.7.7", "7.10"}],
    Cell[84790, 3344, 71, 2, 70, "Input",
      CellTags->"S2.7.7"],
    Cell[84864, 3348, 85, 3, 70, "Output",
      CellTags->"S2.7.7"],
    Cell[84964, 3354, 262, 11, 70, "MathCaption",
      CellTags->{"S2.7.7", "7.11"}],
    Cell[85251, 3369, 85, 2, 70, "Input",
      CellTags->"S2.7.7"],
    Cell[85339, 3373, 89, 3, 70, "Output",
      CellTags->"S2.7.7"],
    Cell[85443, 3379, 264, 11, 70, "MathCaption",
      CellTags->{"S2.7.7", "7.12"}],
    Cell[85732, 3394, 86, 2, 70, "Input",
      CellTags->"S2.7.7"],
    Cell[85821, 3398, 89, 3, 70, "Output",
      CellTags->"S2.7.7"]},
  "7.1"->{
    Cell[80282, 3197, 87, 1, 70, "Subsection",
      CellTags->{"S2.7.7", "7.1"}]},
  "7.2"->{
    Cell[80372, 3200, 305, 7, 70, "Text",
      CellTags->{"S2.7.7", "7.2"}]},
  "7.3"->{
    Cell[80680, 3209, 374, 8, 70, "Text",
      CellTags->{"S2.7.7", "7.3"}]},
  "7.4"->{
    Cell[81057, 3219, 218, 5, 70, "Text",
      CellTags->{"S2.7.7", "7.4"}]},
  "7.5"->{
    Cell[82197, 3258, 488, 11, 70, "Text",
      CellTags->{"S2.7.7", "7.5"}]},
  "7.6"->{
    Cell[82688, 3271, 339, 9, 70, "Text",
      CellTags->{"S2.7.7", "7.6"}]},
  "7.7"->{
    Cell[83030, 3282, 517, 10, 70, "Text",
      CellTags->{"S2.7.7", "7.7"}]},
  "7.8"->{
    Cell[83550, 3294, 607, 18, 70, "Text",
      CellTags->{"S2.7.7", "7.8"}]},
  "7.9"->{
    Cell[84160, 3314, 445, 17, 70, "Text",
      CellTags->{"S2.7.7", "7.9"}]},
  "7.10"->{
    Cell[84608, 3333, 157, 7, 70, "MathCaption",
      CellTags->{"S2.7.7", "7.10"}]},
  "7.11"->{
    Cell[84964, 3354, 262, 11, 70, "MathCaption",
      CellTags->{"S2.7.7", "7.11"}]},
  "7.12"->{
    Cell[85443, 3379, 264, 11, 70, "MathCaption",
      CellTags->{"S2.7.7", "7.12"}]},
  "S2.7.8"->{
    Cell[85959, 3407, 67, 1, 70, "Subsection",
      CellTags->{"S2.7.8", "8.1"}],
    Cell[86029, 3410, 216, 5, 70, "Text",
      CellTags->{"S2.7.8", "8.2"}],
    Cell[86248, 3417, 576, 13, 70, "Text",
      CellTags->{"S2.7.8", "8.3"}],
    Cell[86827, 3432, 590, 18, 70, "Text",
      CellTags->{"S2.7.8", "8.4"}],
    Cell[87420, 3452, 180, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.5"}],
    Cell[87625, 3463, 70, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[87698, 3467, 87, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[87800, 3473, 106, 1, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.6"}],
    Cell[87931, 3478, 71, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[88005, 3482, 104, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[88124, 3488, 105, 1, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.7"}],
    Cell[88254, 3493, 75, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[88332, 3497, 83, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[88430, 3503, 212, 8, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.8"}],
    Cell[88667, 3515, 74, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[88744, 3519, 97, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[88856, 3525, 422, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.9"}],
    Cell[89281, 3538, 164, 4, 70, "Text",
      CellTags->{"S2.7.8", "8.10"}],
    Cell[89448, 3544, 325, 10, 70, "Text",
      CellTags->{"S2.7.8", "8.11"}],
    Cell[89776, 3556, 184, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.12"}],
    Cell[89985, 3567, 72, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[90060, 3571, 90, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[90165, 3577, 137, 4, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.13"}],
    Cell[90327, 3585, 77, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[90407, 3589, 87, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[90509, 3595, 515, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.14"}],
    Cell[91027, 3608, 795, 26, 70, "Text",
      CellTags->{"S2.7.8", "8.15"}],
    Cell[91825, 3636, 2347, 69, 70, "DefinitionBox",
      CellTags->"S2.7.8"],
    Cell[94175, 3707, 81, 1, 70, "Caption",
      CellTags->"S2.7.8"],
    Cell[94259, 3710, 137, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.16"}],
    Cell[94421, 3719, 69, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[94493, 3723, 86, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[94594, 3729, 389, 12, 70, "Text",
      CellTags->{"S2.7.8", "8.17"}],
    Cell[94986, 3743, 772, 20, 70, "Text",
      CellTags->{"S2.7.8", "8.18"}],
    Cell[95761, 3765, 273, 6, 70, "Text",
      CellTags->{"S2.7.8", "8.19"}],
    Cell[96037, 3773, 148, 4, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.20"}],
    Cell[96210, 3781, 76, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[96289, 3785, 103, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[96407, 3791, 242, 9, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.21"}],
    Cell[96674, 3804, 75, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[96752, 3808, 90, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[96857, 3814, 1009, 30, 70, "DefinitionBox",
      CellTags->"S2.7.8"],
    Cell[97869, 3846, 84, 1, 70, "Caption",
      CellTags->"S2.7.8"],
    Cell[97956, 3849, 460, 13, 70, "Text",
      CellTags->{"S2.7.8", "8.22"}],
    Cell[98419, 3864, 351, 7, 70, "Text",
      CellTags->{"S2.7.8", "8.23"}],
    Cell[98773, 3873, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.24"}],
    Cell[98953, 3882, 111, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[99067, 3886, 128, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[99210, 3892, 150, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.25"}],
    Cell[99385, 3901, 156, 5, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[99544, 3908, 153, 4, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[99712, 3915, 201, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.26"}],
    Cell[99938, 3926, 78, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[100019, 3930, 98, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[100132, 3936, 510, 9, 70, "Text",
      CellTags->{"S2.7.8", "8.27"}],
    Cell[100645, 3947, 447, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.28"}],
    Cell[101095, 3960, 342, 11, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.29"}],
    Cell[101462, 3975, 76, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[101541, 3979, 307, 6, 70, "Message",
      CellTags->"S2.7.8"],
    Cell[101851, 3987, 86, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[101952, 3993, 193, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.30"}],
    Cell[102170, 4004, 78, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[102251, 4008, 91, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[102357, 4014, 580, 15, 70, "Text",
      CellTags->{"S2.7.8", "8.31"}],
    Cell[102940, 4031, 643, 18, 70, "DefinitionBox",
      CellTags->"S2.7.8"],
    Cell[103586, 4051, 131, 5, 70, "Caption",
      CellTags->"S2.7.8"],
    Cell[103720, 4058, 136, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.32"}],
    Cell[103859, 4065, 77, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[103939, 4069, 191, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.33"}],
    Cell[104155, 4080, 78, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[104236, 4084, 98, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[104349, 4090, 444, 12, 70, "Text",
      CellTags->{"S2.7.8", "8.34"}],
    Cell[104796, 4104, 164, 4, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.35"}],
    Cell[104985, 4112, 111, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[105099, 4116, 114, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[105228, 4122, 436, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.36"}],
    Cell[105667, 4135, 152, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.37"}],
    Cell[105844, 4144, 69, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[105916, 4148, 86, 3, 70, "Output",
      CellTags->"S2.7.8"],
    Cell[106017, 4154, 203, 8, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.38"}],
    Cell[106245, 4166, 78, 2, 70, "Input",
      CellTags->"S2.7.8"],
    Cell[106326, 4170, 91, 3, 70, "Output",
      CellTags->"S2.7.8"]},
  "8.1"->{
    Cell[85959, 3407, 67, 1, 70, "Subsection",
      CellTags->{"S2.7.8", "8.1"}]},
  "8.2"->{
    Cell[86029, 3410, 216, 5, 70, "Text",
      CellTags->{"S2.7.8", "8.2"}]},
  "8.3"->{
    Cell[86248, 3417, 576, 13, 70, "Text",
      CellTags->{"S2.7.8", "8.3"}]},
  "8.4"->{
    Cell[86827, 3432, 590, 18, 70, "Text",
      CellTags->{"S2.7.8", "8.4"}]},
  "8.5"->{
    Cell[87420, 3452, 180, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.5"}]},
  "8.6"->{
    Cell[87800, 3473, 106, 1, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.6"}]},
  "8.7"->{
    Cell[88124, 3488, 105, 1, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.7"}]},
  "8.8"->{
    Cell[88430, 3503, 212, 8, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.8"}]},
  "8.9"->{
    Cell[88856, 3525, 422, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.9"}]},
  "8.10"->{
    Cell[89281, 3538, 164, 4, 70, "Text",
      CellTags->{"S2.7.8", "8.10"}]},
  "8.11"->{
    Cell[89448, 3544, 325, 10, 70, "Text",
      CellTags->{"S2.7.8", "8.11"}]},
  "8.12"->{
    Cell[89776, 3556, 184, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.12"}]},
  "8.13"->{
    Cell[90165, 3577, 137, 4, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.13"}]},
  "8.14"->{
    Cell[90509, 3595, 515, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.14"}]},
  "8.15"->{
    Cell[91027, 3608, 795, 26, 70, "Text",
      CellTags->{"S2.7.8", "8.15"}]},
  "8.16"->{
    Cell[94259, 3710, 137, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.16"}]},
  "8.17"->{
    Cell[94594, 3729, 389, 12, 70, "Text",
      CellTags->{"S2.7.8", "8.17"}]},
  "8.18"->{
    Cell[94986, 3743, 772, 20, 70, "Text",
      CellTags->{"S2.7.8", "8.18"}]},
  "8.19"->{
    Cell[95761, 3765, 273, 6, 70, "Text",
      CellTags->{"S2.7.8", "8.19"}]},
  "8.20"->{
    Cell[96037, 3773, 148, 4, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.20"}]},
  "8.21"->{
    Cell[96407, 3791, 242, 9, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.21"}]},
  "8.22"->{
    Cell[97956, 3849, 460, 13, 70, "Text",
      CellTags->{"S2.7.8", "8.22"}]},
  "8.23"->{
    Cell[98419, 3864, 351, 7, 70, "Text",
      CellTags->{"S2.7.8", "8.23"}]},
  "8.24"->{
    Cell[98773, 3873, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.24"}]},
  "8.25"->{
    Cell[99210, 3892, 150, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.25"}]},
  "8.26"->{
    Cell[99712, 3915, 201, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.26"}]},
  "8.27"->{
    Cell[100132, 3936, 510, 9, 70, "Text",
      CellTags->{"S2.7.8", "8.27"}]},
  "8.28"->{
    Cell[100645, 3947, 447, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.28"}]},
  "8.29"->{
    Cell[101095, 3960, 342, 11, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.29"}]},
  "8.30"->{
    Cell[101952, 3993, 193, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.30"}]},
  "8.31"->{
    Cell[102357, 4014, 580, 15, 70, "Text",
      CellTags->{"S2.7.8", "8.31"}]},
  "8.32"->{
    Cell[103720, 4058, 136, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.32"}]},
  "8.33"->{
    Cell[103939, 4069, 191, 7, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.33"}]},
  "8.34"->{
    Cell[104349, 4090, 444, 12, 70, "Text",
      CellTags->{"S2.7.8", "8.34"}]},
  "8.35"->{
    Cell[104796, 4104, 164, 4, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.35"}]},
  "8.36"->{
    Cell[105228, 4122, 436, 11, 70, "Text",
      CellTags->{"S2.7.8", "8.36"}]},
  "8.37"->{
    Cell[105667, 4135, 152, 5, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.37"}]},
  "8.38"->{
    Cell[106017, 4154, 203, 8, 70, "MathCaption",
      CellTags->{"S2.7.8", "8.38"}]},
  "S2.7.9"->{
    Cell[106466, 4179, 80, 1, 70, "Subsection",
      CellTags->{"S2.7.9", "9.1"}],
    Cell[106549, 4182, 302, 7, 70, "Text",
      CellTags->{"S2.7.9", "9.2"}],
    Cell[106854, 4191, 366, 8, 70, "Text",
      CellTags->{"S2.7.9", "9.3"}],
    Cell[107223, 4201, 119, 2, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.4"}],
    Cell[107345, 4205, 80, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[107428, 4209, 148, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.5"}],
    Cell[107601, 4218, 76, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[107680, 4222, 121, 3, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[107816, 4228, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.6"}],
    Cell[107996, 4237, 77, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[108076, 4241, 97, 3, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[108188, 4247, 104, 1, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.7"}],
    Cell[108317, 4252, 90, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[108410, 4256, 160, 4, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[108585, 4263, 410, 8, 70, "Text",
      CellTags->{"S2.7.9", "9.8"}],
    Cell[108998, 4273, 427, 8, 70, "Text",
      CellTags->{"S2.7.9", "9.9"}],
    Cell[109428, 4283, 244, 7, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.10"}],
    Cell[109697, 4294, 74, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[109774, 4298, 281, 5, 70, "Message",
      CellTags->"S2.7.9"],
    Cell[110070, 4306, 117, 2, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.11"}],
    Cell[110212, 4312, 104, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[110319, 4316, 160, 4, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[110494, 4323, 599, 12, 70, "Text",
      CellTags->{"S2.7.9", "9.12"}],
    Cell[111096, 4337, 103, 1, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.13"}],
    Cell[111224, 4342, 77, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[111304, 4346, 85, 3, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[111404, 4352, 192, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.14"}],
    Cell[111621, 4361, 90, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[111714, 4365, 306, 6, 70, "Message",
      CellTags->"S2.7.9"],
    Cell[112035, 4374, 111, 1, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.15"}],
    Cell[112171, 4379, 98, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[112272, 4383, 99, 3, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[112386, 4389, 153, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.16"}],
    Cell[112542, 4396, 88, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[112633, 4400, 137, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.17"}],
    Cell[112795, 4409, 81, 2, 70, "Input",
      CellTags->"S2.7.9"],
    Cell[112879, 4413, 90, 3, 70, "Output",
      CellTags->"S2.7.9"],
    Cell[112984, 4419, 595, 15, 70, "Text",
      CellTags->{"S2.7.9", "9.18"}],
    Cell[113582, 4436, 519, 16, 70, "DefinitionBox",
      CellTags->"S2.7.9"],
    Cell[114104, 4454, 69, 1, 70, "Caption",
      CellTags->"S2.7.9"]},
  "9.1"->{
    Cell[106466, 4179, 80, 1, 70, "Subsection",
      CellTags->{"S2.7.9", "9.1"}]},
  "9.2"->{
    Cell[106549, 4182, 302, 7, 70, "Text",
      CellTags->{"S2.7.9", "9.2"}]},
  "9.3"->{
    Cell[106854, 4191, 366, 8, 70, "Text",
      CellTags->{"S2.7.9", "9.3"}]},
  "9.4"->{
    Cell[107223, 4201, 119, 2, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.4"}]},
  "9.5"->{
    Cell[107428, 4209, 148, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.5"}]},
  "9.6"->{
    Cell[107816, 4228, 155, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.6"}]},
  "9.7"->{
    Cell[108188, 4247, 104, 1, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.7"}]},
  "9.8"->{
    Cell[108585, 4263, 410, 8, 70, "Text",
      CellTags->{"S2.7.9", "9.8"}]},
  "9.9"->{
    Cell[108998, 4273, 427, 8, 70, "Text",
      CellTags->{"S2.7.9", "9.9"}]},
  "9.10"->{
    Cell[109428, 4283, 244, 7, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.10"}]},
  "9.11"->{
    Cell[110070, 4306, 117, 2, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.11"}]},
  "9.12"->{
    Cell[110494, 4323, 599, 12, 70, "Text",
      CellTags->{"S2.7.9", "9.12"}]},
  "9.13"->{
    Cell[111096, 4337, 103, 1, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.13"}]},
  "9.14"->{
    Cell[111404, 4352, 192, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.14"}]},
  "9.15"->{
    Cell[112035, 4374, 111, 1, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.15"}]},
  "9.16"->{
    Cell[112386, 4389, 153, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.16"}]},
  "9.17"->{
    Cell[112633, 4400, 137, 5, 70, "MathCaption",
      CellTags->{"S2.7.9", "9.17"}]},
  "9.18"->{
    Cell[112984, 4419, 595, 15, 70, "Text",
      CellTags->{"S2.7.9", "9.18"}]},
  "S2.7.10"->{
    Cell[114210, 4460, 138, 5, 70, "Subsection",
      CellTags->{"S2.7.10", "10.1"}],
    Cell[114351, 4467, 495, 10, 70, "Text",
      CellTags->{"S2.7.10", "10.2"}],
    Cell[114849, 4479, 418, 9, 70, "Text",
      CellTags->{"S2.7.10", "10.3"}],
    Cell[115270, 4490, 477, 11, 70, "Text",
      CellTags->{"S2.7.10", "10.4"}],
    Cell[115750, 4503, 1461, 42, 70, "DefinitionBox",
      CellTags->"S2.7.10"],
    Cell[117214, 4547, 140, 5, 70, "Caption",
      CellTags->"S2.7.10"],
    Cell[117357, 4554, 411, 11, 70, "Text",
      CellTags->{"S2.7.10", "10.5"}],
    Cell[117771, 4567, 2553, 77, 70, "DefinitionBox",
      CellTags->"S2.7.10"],
    Cell[120327, 4646, 116, 4, 70, "Caption",
      CellTags->"S2.7.10"],
    Cell[120446, 4652, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.7.10", "10.6"}],
    Cell[120505, 4655, 472, 20, 70, "Program",
      CellTags->{"S2.7.10", "10.7"}],
    Cell[120980, 4677, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.7.10", "10.8"}],
    Cell[121042, 4680, 116, 5, 70, "Caption",
      CellTags->"S2.7.10"],
    Cell[121161, 4687, 516, 12, 70, "Text",
      CellTags->{"S2.7.10", "10.9"}],
    Cell[121680, 4701, 424, 9, 70, "Text",
      CellTags->{"S2.7.10", "10.10"}],
    Cell[122107, 4712, 103, 1, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.11"}],
    Cell[122213, 4715, 76, 2, 70, "Input",
      CellTags->"S2.7.10"],
    Cell[122292, 4719, 214, 6, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.12"}],
    Cell[122531, 4729, 77, 2, 70, "Input",
      CellTags->"S2.7.10"],
    Cell[122611, 4733, 116, 3, 70, "Output",
      CellTags->"S2.7.10"],
    Cell[122742, 4739, 187, 7, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.13"}],
    Cell[122954, 4750, 81, 2, 70, "Input",
      CellTags->"S2.7.10"],
    Cell[123038, 4754, 92, 3, 70, "Output",
      CellTags->"S2.7.10"],
    Cell[123145, 4760, 193, 7, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.14"}],
    Cell[123363, 4771, 83, 2, 70, "Input",
      CellTags->"S2.7.10"],
    Cell[123449, 4775, 75, 2, 70, "Print",
      CellTags->"S2.7.10"],
    Cell[123539, 4780, 341, 9, 70, "Text",
      CellTags->{"S2.7.10", "10.15"}],
    Cell[123883, 4791, 279, 6, 70, "Text",
      CellTags->{"S2.7.10", "10.16"}],
    Cell[124165, 4799, 891, 25, 70, "Text",
      CellTags->{"S2.7.10", "10.17"}],
    Cell[125059, 4826, 1798, 53, 70, "DefinitionBox",
      CellTags->"S2.7.10"],
    Cell[126860, 4881, 96, 1, 70, "Caption",
      CellTags->"S2.7.10"],
    Cell[126959, 4884, 992, 24, 70, "Text",
      CellTags->{"S2.7.10", "10.18"}],
    Cell[127954, 4910, 627, 18, 70, "DefinitionBox",
      CellTags->"S2.7.10"],
    Cell[128584, 4930, 74, 1, 70, "Caption",
      CellTags->"S2.7.10"],
    Cell[128661, 4933, 776, 18, 70, "Text",
      CellTags->{"S2.7.10", "10.19"}],
    Cell[129440, 4953, 384, 10, 70, "Text",
      CellTags->{"S2.7.10", "10.20"}],
    Cell[129827, 4965, 219, 7, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.21"}],
    Cell[130071, 4976, 105, 2, 70, "Input",
      CellTags->"S2.7.10"],
    Cell[130179, 4980, 65, 2, 70, "Print",
      CellTags->"S2.7.10"],
    Cell[130247, 4984, 86, 3, 70, "Output",
      CellTags->"S2.7.10"],
    Cell[130348, 4990, 290, 7, 70, "Text",
      CellTags->{"S2.7.10", "10.22"}],
    Cell[130641, 4999, 916, 20, 70, "Text",
      CellTags->{"S2.7.10", "10.23"}]},
  "10.1"->{
    Cell[114210, 4460, 138, 5, 70, "Subsection",
      CellTags->{"S2.7.10", "10.1"}]},
  "10.2"->{
    Cell[114351, 4467, 495, 10, 70, "Text",
      CellTags->{"S2.7.10", "10.2"}]},
  "10.3"->{
    Cell[114849, 4479, 418, 9, 70, "Text",
      CellTags->{"S2.7.10", "10.3"}]},
  "10.4"->{
    Cell[115270, 4490, 477, 11, 70, "Text",
      CellTags->{"S2.7.10", "10.4"}]},
  "10.5"->{
    Cell[117357, 4554, 411, 11, 70, "Text",
      CellTags->{"S2.7.10", "10.5"}]},
  "10.6"->{
    Cell[120446, 4652, 56, 1, 70, "ProgramTop",
      CellTags->{"S2.7.10", "10.6"}]},
  "10.7"->{
    Cell[120505, 4655, 472, 20, 70, "Program",
      CellTags->{"S2.7.10", "10.7"}]},
  "10.8"->{
    Cell[120980, 4677, 59, 1, 70, "ProgramBottom",
      CellTags->{"S2.7.10", "10.8"}]},
  "10.9"->{
    Cell[121161, 4687, 516, 12, 70, "Text",
      CellTags->{"S2.7.10", "10.9"}]},
  "10.10"->{
    Cell[121680, 4701, 424, 9, 70, "Text",
      CellTags->{"S2.7.10", "10.10"}]},
  "10.11"->{
    Cell[122107, 4712, 103, 1, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.11"}]},
  "10.12"->{
    Cell[122292, 4719, 214, 6, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.12"}]},
  "10.13"->{
    Cell[122742, 4739, 187, 7, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.13"}]},
  "10.14"->{
    Cell[123145, 4760, 193, 7, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.14"}]},
  "10.15"->{
    Cell[123539, 4780, 341, 9, 70, "Text",
      CellTags->{"S2.7.10", "10.15"}]},
  "10.16"->{
    Cell[123883, 4791, 279, 6, 70, "Text",
      CellTags->{"S2.7.10", "10.16"}]},
  "10.17"->{
    Cell[124165, 4799, 891, 25, 70, "Text",
      CellTags->{"S2.7.10", "10.17"}]},
  "10.18"->{
    Cell[126959, 4884, 992, 24, 70, "Text",
      CellTags->{"S2.7.10", "10.18"}]},
  "10.19"->{
    Cell[128661, 4933, 776, 18, 70, "Text",
      CellTags->{"S2.7.10", "10.19"}]},
  "10.20"->{
    Cell[129440, 4953, 384, 10, 70, "Text",
      CellTags->{"S2.7.10", "10.20"}]},
  "10.21"->{
    Cell[129827, 4965, 219, 7, 70, "MathCaption",
      CellTags->{"S2.7.10", "10.21"}]},
  "10.22"->{
    Cell[130348, 4990, 290, 7, 70, "Text",
      CellTags->{"S2.7.10", "10.22"}]},
  "10.23"->{
    Cell[130641, 4999, 916, 20, 70, "Text",
      CellTags->{"S2.7.10", "10.23"}]},
  "S2.7.11"->{
    Cell[131594, 5024, 91, 1, 70, "Subsection",
      CellTags->{"S2.7.11", "11.1"}],
    Cell[131688, 5027, 490, 15, 70, "Text",
      CellTags->{"S2.7.11", "11.2"}],
    Cell[132181, 5044, 349, 8, 70, "Text",
      CellTags->{"S2.7.11", "11.3"}],
    Cell[132533, 5054, 1537, 44, 70, "DefinitionBox",
      CellTags->"S2.7.11"],
    Cell[134073, 5100, 87, 1, 70, "Caption",
      CellTags->"S2.7.11"],
    Cell[134163, 5103, 276, 11, 70, "MathCaption",
      CellTags->{"S2.7.11", "11.4"}],
    Cell[134464, 5118, 150, 5, 70, "Input",
      CellTags->"S2.7.11"],
    Cell[134617, 5125, 108, 3, 70, "Output",
      CellTags->"S2.7.11"],
    Cell[134740, 5131, 214, 7, 70, "MathCaption",
      CellTags->{"S2.7.11", "11.5"}],
    Cell[134979, 5142, 100, 2, 70, "Input",
      CellTags->"S2.7.11"],
    Cell[135082, 5146, 97, 3, 70, "Output",
      CellTags->"S2.7.11"],
    Cell[135194, 5152, 640, 14, 70, "Text",
      CellTags->{"S2.7.11", "11.6"}],
    Cell[135837, 5168, 509, 12, 70, "Text",
      CellTags->{"S2.7.11", "11.7"}]},
  "11.1"->{
    Cell[131594, 5024, 91, 1, 70, "Subsection",
      CellTags->{"S2.7.11", "11.1"}]},
  "11.2"->{
    Cell[131688, 5027, 490, 15, 70, "Text",
      CellTags->{"S2.7.11", "11.2"}]},
  "11.3"->{
    Cell[132181, 5044, 349, 8, 70, "Text",
      CellTags->{"S2.7.11", "11.3"}]},
  "11.4"->{
    Cell[134163, 5103, 276, 11, 70, "MathCaption",
      CellTags->{"S2.7.11", "11.4"}]},
  "11.5"->{
    Cell[134740, 5131, 214, 7, 70, "MathCaption",
      CellTags->{"S2.7.11", "11.5"}]},
  "11.6"->{
    Cell[135194, 5152, 640, 14, 70, "Text",
      CellTags->{"S2.7.11", "11.6"}]},
  "11.7"->{
    Cell[135837, 5168, 509, 12, 70, "Text",
      CellTags->{"S2.7.11", "11.7"}]},
  "S2.7.12"->{
    Cell[136383, 5185, 103, 1, 70, "Subsection",
      CellTags->{"S2.7.12", "12.1"}],
    Cell[136489, 5188, 650, 18, 70, "DefinitionBox",
      CellTags->"S2.7.12"],
    Cell[137142, 5208, 86, 1, 70, "Caption",
      CellTags->"S2.7.12"],
    Cell[137231, 5211, 122, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.2"}],
    Cell[137378, 5220, 79, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[137460, 5224, 78, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[137553, 5229, 78, 1, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.3"}],
    Cell[137656, 5234, 91, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[137750, 5238, 82, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[137847, 5243, 131, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.4"}],
    Cell[138003, 5252, 91, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[138097, 5256, 78, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[138190, 5261, 471, 17, 70, "Text",
      CellTags->{"S2.7.12", "12.5"}],
    Cell[138664, 5280, 391, 13, 70, "Text",
      CellTags->{"S2.7.12", "12.6"}],
    Cell[139058, 5295, 252, 11, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.7"}],
    Cell[139335, 5310, 113, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[139451, 5314, 92, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[139558, 5319, 127, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.8"}],
    Cell[139710, 5328, 70, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[139783, 5332, 83, 3, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[139881, 5338, 174, 7, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.9"}],
    Cell[140080, 5349, 85, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[140168, 5353, 84, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[140267, 5358, 142, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.10"}],
    Cell[140434, 5367, 79, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[140516, 5371, 103, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[140634, 5376, 1216, 36, 70, "DefinitionBox",
      CellTags->"S2.7.12"],
    Cell[141853, 5414, 85, 1, 70, "Caption",
      CellTags->"S2.7.12"],
    Cell[141941, 5417, 264, 10, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.11"}],
    Cell[142230, 5431, 110, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[142343, 5435, 101, 3, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[142459, 5441, 422, 13, 70, "Text",
      CellTags->{"S2.7.12", "12.12"}],
    Cell[142884, 5456, 232, 7, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.13"}],
    Cell[143141, 5467, 91, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[143235, 5471, 92, 2, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[143342, 5476, 170, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.14"}],
    Cell[143537, 5485, 93, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[143633, 5489, 180, 5, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[143828, 5497, 192, 6, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.15"}],
    Cell[144045, 5507, 114, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[144162, 5511, 99, 3, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[144276, 5517, 1407, 40, 70, "DefinitionBox",
      CellTags->"S2.7.12"],
    Cell[145686, 5559, 74, 1, 70, "Caption",
      CellTags->"S2.7.12"],
    Cell[145763, 5562, 165, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.16"}],
    Cell[145931, 5569, 79, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[146013, 5573, 141, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.17"}],
    Cell[146179, 5582, 79, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[146261, 5586, 94, 3, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[146370, 5592, 138, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.18"}],
    Cell[146533, 5601, 73, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[146609, 5605, 90, 3, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[146714, 5611, 163, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.19"}],
    Cell[146880, 5618, 80, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[146963, 5622, 139, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.20"}],
    Cell[147127, 5631, 79, 2, 70, "Input",
      CellTags->"S2.7.12"],
    Cell[147209, 5635, 85, 3, 70, "Output",
      CellTags->"S2.7.12"],
    Cell[147309, 5641, 477, 14, 70, "DefinitionBox",
      CellTags->"S2.7.12"],
    Cell[147789, 5657, 84, 1, 70, "Caption",
      CellTags->"S2.7.12"],
    Cell[147876, 5660, 525, 14, 70, "Text",
      CellTags->{"S2.7.12", "12.21"}]},
  "12.1"->{
    Cell[136383, 5185, 103, 1, 70, "Subsection",
      CellTags->{"S2.7.12", "12.1"}]},
  "12.2"->{
    Cell[137231, 5211, 122, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.2"}]},
  "12.3"->{
    Cell[137553, 5229, 78, 1, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.3"}]},
  "12.4"->{
    Cell[137847, 5243, 131, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.4"}]},
  "12.5"->{
    Cell[138190, 5261, 471, 17, 70, "Text",
      CellTags->{"S2.7.12", "12.5"}]},
  "12.6"->{
    Cell[138664, 5280, 391, 13, 70, "Text",
      CellTags->{"S2.7.12", "12.6"}]},
  "12.7"->{
    Cell[139058, 5295, 252, 11, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.7"}]},
  "12.8"->{
    Cell[139558, 5319, 127, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.8"}]},
  "12.9"->{
    Cell[139881, 5338, 174, 7, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.9"}]},
  "12.10"->{
    Cell[140267, 5358, 142, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.10"}]},
  "12.11"->{
    Cell[141941, 5417, 264, 10, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.11"}]},
  "12.12"->{
    Cell[142459, 5441, 422, 13, 70, "Text",
      CellTags->{"S2.7.12", "12.12"}]},
  "12.13"->{
    Cell[142884, 5456, 232, 7, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.13"}]},
  "12.14"->{
    Cell[143342, 5476, 170, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.14"}]},
  "12.15"->{
    Cell[143828, 5497, 192, 6, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.15"}]},
  "12.16"->{
    Cell[145763, 5562, 165, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.16"}]},
  "12.17"->{
    Cell[146013, 5573, 141, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.17"}]},
  "12.18"->{
    Cell[146370, 5592, 138, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.18"}]},
  "12.19"->{
    Cell[146714, 5611, 163, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.19"}]},
  "12.20"->{
    Cell[146963, 5622, 139, 5, 70, "MathCaption",
      CellTags->{"S2.7.12", "12.20"}]},
  "12.21"->{
    Cell[147876, 5660, 525, 14, 70, "Text",
      CellTags->{"S2.7.12", "12.21"}]},
  "S2.7.13"->{
    Cell[148438, 5679, 128, 4, 70, "Subsection",
      CellTags->{"S2.7.13", "13.1"}],
    Cell[148569, 5685, 359, 8, 70, "Text",
      CellTags->{"S2.7.13", "13.2"}],
    Cell[148931, 5695, 580, 15, 70, "DefinitionBox",
      CellTags->"S2.7.13"],
    Cell[149514, 5712, 91, 1, 70, "Caption",
      CellTags->"S2.7.13"],
    Cell[149608, 5715, 176, 5, 70, "MathCaption",
      CellTags->{"S2.7.13", "13.3"}],
    Cell[149787, 5722, 84, 2, 70, "Input",
      CellTags->"S2.7.13"],
    Cell[149874, 5726, 166, 4, 70, "MathCaption",
      CellTags->{"S2.7.13", "13.4"}],
    Cell[150065, 5734, 71, 2, 70, "Input",
      CellTags->"S2.7.13"],
    Cell[150139, 5738, 125, 3, 18, "Message",
      CellTags->"S2.7.13"],
    Cell[150267, 5743, 118, 3, 70, "Message",
      CellTags->"S2.7.13"],
    Cell[150388, 5748, 88, 3, 25, "Output",
      CellTags->"S2.7.13"],
    Cell[150491, 5754, 87, 1, 40, "MathCaption",
      CellTags->{"S2.7.13", "13.5"}],
    Cell[150581, 5757, 85, 2, 28, "Input",
      CellTags->"S2.7.13"],
    Cell[150669, 5761, 495, 11, 88, "Text",
      CellTags->{"S2.7.13", "13.6"}],
    Cell[151167, 5774, 427, 14, 64, "DefinitionBox",
      CellTags->"S2.7.13"],
    Cell[151597, 5790, 94, 1, 16, "Caption",
      CellTags->"S2.7.13"],
    Cell[151694, 5793, 467, 12, 72, "Text",
      CellTags->{"S2.7.13", "13.7"}],
    Cell[152164, 5807, 141, 4, 40, "MathCaption",
      CellTags->{"S2.7.13", "13.8"}],
    Cell[152330, 5815, 120, 2, 28, "Input",
      CellTags->"S2.7.13"],
    Cell[152453, 5819, 122, 3, 25, "Output",
      CellTags->"S2.7.13"],
    Cell[152590, 5825, 177, 7, 40, "MathCaption",
      CellTags->{"S2.7.13", "13.9"}],
    Cell[152792, 5836, 70, 2, 28, "Input",
      CellTags->"S2.7.13"],
    Cell[152865, 5840, 246, 5, 21, "Print",
      CellTags->"S2.7.13"],
    Cell[153114, 5847, 246, 5, 21, "Print",
      CellTags->"S2.7.13"],
    Cell[153363, 5854, 87, 3, 25, "Output",
      CellTags->"S2.7.13"]},
  "13.1"->{
    Cell[148438, 5679, 128, 4, 70, "Subsection",
      CellTags->{"S2.7.13", "13.1"}]},
  "13.2"->{
    Cell[148569, 5685, 359, 8, 70, "Text",
      CellTags->{"S2.7.13", "13.2"}]},
  "13.3"->{
    Cell[149608, 5715, 176, 5, 70, "MathCaption",
      CellTags->{"S2.7.13", "13.3"}]},
  "13.4"->{
    Cell[149874, 5726, 166, 4, 70, "MathCaption",
      CellTags->{"S2.7.13", "13.4"}]},
  "13.5"->{
    Cell[150491, 5754, 87, 1, 40, "MathCaption",
      CellTags->{"S2.7.13", "13.5"}]},
  "13.6"->{
    Cell[150669, 5761, 495, 11, 88, "Text",
      CellTags->{"S2.7.13", "13.6"}]},
  "13.7"->{
    Cell[151694, 5793, 467, 12, 72, "Text",
      CellTags->{"S2.7.13", "13.7"}]},
  "13.8"->{
    Cell[152164, 5807, 141, 4, 40, "MathCaption",
      CellTags->{"S2.7.13", "13.8"}]},
  "13.9"->{
    Cell[152590, 5825, 177, 7, 40, "MathCaption",
      CellTags->{"S2.7.13", "13.9"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.7.0", 154105, 5878},
  {"0.1", 154195, 5881},
  {"S2.7.1", 154288, 5884},
  {"1.1", 158902, 6009},
  {"1.2", 158994, 6012},
  {"1.3", 159082, 6015},
  {"1.4", 159170, 6018},
  {"1.5", 159257, 6021},
  {"1.6", 159352, 6024},
  {"1.7", 159447, 6027},
  {"1.8", 159542, 6030},
  {"1.9", 159630, 6033},
  {"1.10", 159726, 6036},
  {"1.11", 159823, 6039},
  {"1.12", 159920, 6042},
  {"1.13", 160010, 6045},
  {"1.14", 160107, 6048},
  {"1.15", 160204, 6051},
  {"1.16", 160301, 6054},
  {"1.17", 160391, 6057},
  {"1.18", 160488, 6060},
  {"1.19", 160585, 6063},
  {"1.20", 160682, 6066},
  {"1.21", 160780, 6069},
  {"1.22", 160878, 6072},
  {"1.23", 160969, 6075},
  {"1.24", 161067, 6078},
  {"1.25", 161159, 6081},
  {"1.26", 161257, 6084},
  {"S2.7.2", 161357, 6087},
  {"2.1", 164679, 6176},
  {"2.2", 164773, 6179},
  {"2.3", 164863, 6182},
  {"2.4", 164959, 6185},
  {"2.5", 165055, 6188},
  {"2.6", 165151, 6191},
  {"2.7", 165247, 6194},
  {"2.8", 165336, 6197},
  {"2.9", 165433, 6200},
  {"2.10", 165524, 6203},
  {"2.11", 165622, 6206},
  {"2.12", 165721, 6209},
  {"2.13", 165819, 6212},
  {"2.14", 165910, 6215},
  {"2.15", 166002, 6218},
  {"2.16", 166094, 6221},
  {"2.17", 166192, 6224},
  {"2.18", 166290, 6227},
  {"2.19", 166388, 6230},
  {"2.20", 166481, 6233},
  {"S2.7.3", 166581, 6236},
  {"3.1", 172441, 6391},
  {"3.2", 172536, 6394},
  {"3.3", 172627, 6397},
  {"3.4", 172717, 6400},
  {"3.5", 172814, 6403},
  {"3.6", 172911, 6406},
  {"3.7", 173001, 6409},
  {"3.8", 173098, 6412},
  {"3.9", 173194, 6415},
  {"3.10", 173292, 6418},
  {"3.11", 173391, 6421},
  {"3.12", 173489, 6424},
  {"3.13", 173581, 6427},
  {"3.14", 173680, 6430},
  {"3.15", 173779, 6433},
  {"3.16", 173872, 6436},
  {"3.17", 173971, 6439},
  {"3.18", 174070, 6442},
  {"3.19", 174169, 6445},
  {"3.20", 174262, 6448},
  {"3.21", 174361, 6451},
  {"3.22", 174459, 6454},
  {"3.23", 174552, 6457},
  {"3.24", 174651, 6460},
  {"3.25", 174750, 6463},
  {"3.26", 174843, 6466},
  {"3.27", 174936, 6469},
  {"3.28", 175028, 6472},
  {"3.29", 175121, 6475},
  {"3.30", 175214, 6478},
  {"3.31", 175307, 6481},
  {"3.32", 175400, 6484},
  {"3.33", 175499, 6487},
  {"3.34", 175592, 6490},
  {"3.35", 175685, 6493},
  {"S2.7.4", 175786, 6496},
  {"4.1", 181595, 6649},
  {"4.2", 181691, 6652},
  {"4.3", 181781, 6655},
  {"4.4", 181872, 6658},
  {"4.5", 181963, 6661},
  {"4.6", 182059, 6664},
  {"4.7", 182156, 6667},
  {"4.8", 182253, 6670},
  {"4.9", 182344, 6673},
  {"4.10", 182442, 6676},
  {"4.11", 182541, 6679},
  {"4.12", 182634, 6682},
  {"4.13", 182733, 6685},
  {"4.14", 182831, 6688},
  {"4.15", 182930, 6691},
  {"4.16", 183023, 6694},
  {"4.17", 183115, 6697},
  {"4.18", 183214, 6700},
  {"4.19", 183313, 6703},
  {"4.20", 183412, 6706},
  {"4.21", 183511, 6709},
  {"4.22", 183610, 6712},
  {"4.23", 183703, 6715},
  {"4.24", 183802, 6718},
  {"4.25", 183895, 6721},
  {"4.26", 183988, 6724},
  {"4.27", 184087, 6727},
  {"4.28", 184180, 6730},
  {"4.29", 184279, 6733},
  {"4.30", 184378, 6736},
  {"4.31", 184471, 6739},
  {"4.32", 184570, 6742},
  {"4.33", 184670, 6745},
  {"4.34", 184769, 6748},
  {"S2.7.5", 184870, 6751},
  {"5.1", 186960, 6806},
  {"5.2", 187055, 6809},
  {"5.3", 187145, 6812},
  {"5.4", 187235, 6815},
  {"5.5", 187332, 6818},
  {"5.6", 187429, 6821},
  {"5.7", 187526, 6824},
  {"5.8", 187623, 6827},
  {"5.9", 187713, 6830},
  {"5.10", 187804, 6833},
  {"5.11", 187903, 6836},
  {"5.12", 188002, 6839},
  {"5.13", 188096, 6842},
  {"5.14", 188195, 6845},
  {"5.15", 188294, 6848},
  {"S2.7.6", 188389, 6851},
  {"6.1", 194005, 7000},
  {"6.2", 194100, 7003},
  {"6.3", 194191, 7006},
  {"6.4", 194288, 7009},
  {"6.5", 194385, 7012},
  {"6.6", 194482, 7015},
  {"6.7", 194574, 7018},
  {"6.8", 194671, 7021},
  {"6.9", 194768, 7024},
  {"6.10", 194866, 7027},
  {"6.11", 194965, 7030},
  {"6.12", 195064, 7033},
  {"6.13", 195157, 7036},
  {"6.14", 195256, 7039},
  {"6.15", 195355, 7042},
  {"6.16", 195454, 7045},
  {"6.17", 195547, 7048},
  {"6.18", 195646, 7051},
  {"6.19", 195745, 7054},
  {"6.20", 195838, 7057},
  {"6.21", 195930, 7060},
  {"6.22", 196029, 7063},
  {"6.23", 196128, 7066},
  {"6.24", 196227, 7069},
  {"6.25", 196319, 7072},
  {"6.26", 196418, 7075},
  {"6.27", 196517, 7078},
  {"6.28", 196616, 7081},
  {"6.29", 196715, 7084},
  {"6.30", 196808, 7087},
  {"6.31", 196907, 7090},
  {"S2.7.7", 197008, 7093},
  {"7.1", 198559, 7134},
  {"7.2", 198654, 7137},
  {"7.3", 198744, 7140},
  {"7.4", 198834, 7143},
  {"7.5", 198924, 7146},
  {"7.6", 199015, 7149},
  {"7.7", 199105, 7152},
  {"7.8", 199196, 7155},
  {"7.9", 199287, 7158},
  {"7.10", 199379, 7161},
  {"7.11", 199478, 7164},
  {"7.12", 199578, 7167},
  {"S2.7.8", 199680, 7170},
  {"8.1", 205970, 7335},
  {"8.2", 206065, 7338},
  {"8.3", 206155, 7341},
  {"8.4", 206246, 7344},
  {"8.5", 206337, 7347},
  {"8.6", 206434, 7350},
  {"8.7", 206531, 7353},
  {"8.8", 206628, 7356},
  {"8.9", 206725, 7359},
  {"8.10", 206817, 7362},
  {"8.11", 206909, 7365},
  {"8.12", 207002, 7368},
  {"8.13", 207101, 7371},
  {"8.14", 207200, 7374},
  {"8.15", 207293, 7377},
  {"8.16", 207386, 7380},
  {"8.17", 207485, 7383},
  {"8.18", 207578, 7386},
  {"8.19", 207671, 7389},
  {"8.20", 207763, 7392},
  {"8.21", 207862, 7395},
  {"8.22", 207961, 7398},
  {"8.23", 208054, 7401},
  {"8.24", 208146, 7404},
  {"8.25", 208245, 7407},
  {"8.26", 208344, 7410},
  {"8.27", 208443, 7413},
  {"8.28", 208536, 7416},
  {"8.29", 208630, 7419},
  {"8.30", 208731, 7422},
  {"8.31", 208831, 7425},
  {"8.32", 208925, 7428},
  {"8.33", 209025, 7431},
  {"8.34", 209125, 7434},
  {"8.35", 209219, 7437},
  {"8.36", 209319, 7440},
  {"8.37", 209413, 7443},
  {"8.38", 209513, 7446},
  {"S2.7.9", 209615, 7449},
  {"9.1", 212711, 7530},
  {"9.2", 212807, 7533},
  {"9.3", 212898, 7536},
  {"9.4", 212989, 7539},
  {"9.5", 213087, 7542},
  {"9.6", 213185, 7545},
  {"9.7", 213283, 7548},
  {"9.8", 213381, 7551},
  {"9.9", 213472, 7554},
  {"9.10", 213564, 7557},
  {"9.11", 213664, 7560},
  {"9.12", 213764, 7563},
  {"9.13", 213858, 7566},
  {"9.14", 213958, 7569},
  {"9.15", 214058, 7572},
  {"9.16", 214158, 7575},
  {"9.17", 214258, 7578},
  {"9.18", 214358, 7581},
  {"S2.7.10", 214455, 7584},
  {"10.1", 217822, 7669},
  {"10.2", 217922, 7672},
  {"10.3", 218017, 7675},
  {"10.4", 218111, 7678},
  {"10.5", 218206, 7681},
  {"10.6", 218301, 7684},
  {"10.7", 218400, 7687},
  {"10.8", 218498, 7690},
  {"10.9", 218600, 7693},
  {"10.10", 218696, 7696},
  {"10.11", 218792, 7699},
  {"10.12", 218895, 7702},
  {"10.13", 218998, 7705},
  {"10.14", 219101, 7708},
  {"10.15", 219204, 7711},
  {"10.16", 219300, 7714},
  {"10.17", 219396, 7717},
  {"10.18", 219493, 7720},
  {"10.19", 219590, 7723},
  {"10.20", 219687, 7726},
  {"10.21", 219784, 7729},
  {"10.22", 219887, 7732},
  {"10.23", 219983, 7735},
  {"S2.7.11", 220082, 7738},
  {"11.1", 221129, 7765},
  {"11.2", 221228, 7768},
  {"11.3", 221323, 7771},
  {"11.4", 221417, 7774},
  {"11.5", 221519, 7777},
  {"11.6", 221620, 7780},
  {"11.7", 221715, 7783},
  {"S2.7.12", 221813, 7786},
  {"12.1", 226430, 7905},
  {"12.2", 226530, 7908},
  {"12.3", 226631, 7911},
  {"12.4", 226731, 7914},
  {"12.5", 226832, 7917},
  {"12.6", 226927, 7920},
  {"12.7", 227022, 7923},
  {"12.8", 227124, 7926},
  {"12.9", 227225, 7929},
  {"12.10", 227327, 7932},
  {"12.11", 227430, 7935},
  {"12.12", 227534, 7938},
  {"12.13", 227631, 7941},
  {"12.14", 227734, 7944},
  {"12.15", 227837, 7947},
  {"12.16", 227940, 7950},
  {"12.17", 228043, 7953},
  {"12.18", 228146, 7956},
  {"12.19", 228249, 7959},
  {"12.20", 228352, 7962},
  {"12.21", 228455, 7965},
  {"S2.7.13", 228554, 7968},
  {"13.1", 230511, 8019},
  {"13.2", 230611, 8022},
  {"13.3", 230705, 8025},
  {"13.4", 230806, 8028},
  {"13.5", 230907, 8031},
  {"13.6", 231007, 8034},
  {"13.7", 231102, 8037},
  {"13.8", 231197, 8040},
  {"13.9", 231298, 8043}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 138, 4, 65, "Section",
  CellTags->{"S2.7.0", "0.1"}],

Cell[CellGroupData[{
Cell[1939, 61, 86, 1, 70, "Subsection",
  CellTags->{"S2.7.1", "1.1"}],
Cell[2028, 64, 384, 12, 70, "Text",
  CellTags->{"S2.7.1", "1.2"}],
Cell[2415, 78, 442, 11, 70, "Text",
  CellTags->{"S2.7.1", "1.3"}],
Cell[2860, 91, 283, 8, 70, "Text",
  CellTags->{"S2.7.1", "1.4"}],
Cell[3146, 101, 902, 30, 70, "DefinitionBox",
  CellTags->"S2.7.1"],
Cell[4051, 133, 118, 5, 70, "Caption",
  CellTags->"S2.7.1"],
Cell[4172, 140, 151, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.5"}],

Cell[CellGroupData[{
Cell[4348, 149, 70, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[4421, 153, 83, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[4519, 159, 214, 8, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.6"}],

Cell[CellGroupData[{
Cell[4758, 171, 90, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[4851, 175, 56, 2, 70, "Print",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[4922, 180, 131, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.7"}],

Cell[CellGroupData[{
Cell[5078, 189, 65, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[5146, 193, 83, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[5244, 199, 371, 7, 70, "Text",
  CellTags->{"S2.7.1", "1.8"}],
Cell[5618, 208, 166, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.9"}],
Cell[5787, 215, 115, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[5905, 219, 125, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.10"}],

Cell[CellGroupData[{
Cell[6055, 228, 72, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[6130, 232, 120, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[6265, 238, 132, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.11"}],

Cell[CellGroupData[{
Cell[6422, 247, 65, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[6490, 251, 83, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[6588, 257, 238, 5, 70, "Text",
  CellTags->{"S2.7.1", "1.12"}],
Cell[6829, 264, 155, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.13"}],
Cell[6987, 271, 142, 5, 70, "Input",
  CellTags->"S2.7.1"],
Cell[7132, 278, 165, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.14"}],

Cell[CellGroupData[{
Cell[7322, 287, 73, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[7398, 291, 88, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[7501, 297, 153, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.15"}],

Cell[CellGroupData[{
Cell[7679, 306, 73, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[7755, 310, 88, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[7858, 316, 343, 7, 70, "Text",
  CellTags->{"S2.7.1", "1.16"}],
Cell[8204, 325, 170, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.17"}],

Cell[CellGroupData[{
Cell[8399, 334, 82, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[8484, 338, 86, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[8585, 344, 153, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.18"}],

Cell[CellGroupData[{
Cell[8763, 353, 90, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[8856, 357, 83, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[8954, 363, 240, 7, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.19"}],

Cell[CellGroupData[{
Cell[9219, 374, 103, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[9325, 378, 83, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[9423, 384, 1266, 38, 70, "DefinitionBox",
  CellTags->"S2.7.1"],
Cell[10692, 424, 86, 1, 70, "Caption",
  CellTags->"S2.7.1"],
Cell[10781, 427, 190, 7, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.20"}],
Cell[10974, 436, 107, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[11084, 440, 130, 5, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.21"}],

Cell[CellGroupData[{
Cell[11239, 449, 69, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[11311, 453, 98, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[11424, 459, 417, 9, 70, "Text",
  CellTags->{"S2.7.1", "1.22"}],
Cell[11844, 470, 188, 7, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.23"}],

Cell[CellGroupData[{
Cell[12057, 481, 92, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[12152, 485, 85, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]],
Cell[12252, 491, 892, 29, 70, "DefinitionBox",
  CellTags->"S2.7.1"],
Cell[13147, 522, 95, 1, 70, "Caption",
  CellTags->"S2.7.1"],
Cell[13245, 525, 474, 10, 70, "Text",
  CellTags->{"S2.7.1", "1.24"}],
Cell[13722, 537, 106, 1, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.25"}],
Cell[13831, 540, 113, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[13947, 544, 241, 6, 70, "MathCaption",
  CellTags->{"S2.7.1", "1.26"}],

Cell[CellGroupData[{
Cell[14213, 554, 70, 2, 70, "Input",
  CellTags->"S2.7.1"],
Cell[14286, 558, 84, 3, 70, "Output",
  CellTags->"S2.7.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14419, 567, 74, 1, 70, "Subsection",
  CellTags->{"S2.7.2", "2.1"}],
Cell[14496, 570, 1437, 46, 70, "DefinitionBox",
  CellTags->"S2.7.2"],
Cell[15936, 618, 67, 1, 70, "Caption",
  CellTags->"S2.7.2"],
Cell[16006, 621, 462, 13, 70, "Text",
  CellTags->{"S2.7.2", "2.2"}],
Cell[16471, 636, 133, 5, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.3"}],

Cell[CellGroupData[{
Cell[16629, 645, 70, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[16702, 649, 83, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[16800, 655, 151, 5, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.4"}],
Cell[16954, 662, 99, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[17056, 666, 129, 5, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.5"}],

Cell[CellGroupData[{
Cell[17210, 675, 68, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[17281, 679, 103, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[17399, 685, 122, 4, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.6"}],

Cell[CellGroupData[{
Cell[17546, 693, 65, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[17614, 697, 83, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[17712, 703, 247, 9, 70, "Text",
  CellTags->{"S2.7.2", "2.7"}],
Cell[17962, 714, 310, 13, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.8"}],

Cell[CellGroupData[{
Cell[18297, 731, 86, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[18386, 735, 84, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[18485, 741, 940, 38, 70, "Text",
  CellTags->{"S2.7.2", "2.9"}],
Cell[19428, 781, 151, 7, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.10"}],

Cell[CellGroupData[{
Cell[19604, 792, 84, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[19691, 796, 82, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[19788, 802, 323, 15, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.11"}],

Cell[CellGroupData[{
Cell[20136, 821, 65, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[20204, 825, 82, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[20301, 831, 127, 5, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.12"}],
Cell[20431, 838, 72, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[20506, 842, 240, 7, 70, "Text",
  CellTags->{"S2.7.2", "2.13"}],
Cell[20749, 851, 738, 19, 70, "Text",
  CellTags->{"S2.7.2", "2.14"}],
Cell[21490, 872, 393, 11, 70, "Text",
  CellTags->{"S2.7.2", "2.15"}],
Cell[21886, 885, 175, 5, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.16"}],

Cell[CellGroupData[{
Cell[22086, 894, 97, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[22186, 898, 83, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[22284, 904, 167, 7, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.17"}],

Cell[CellGroupData[{
Cell[22476, 915, 100, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[22579, 919, 84, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[22678, 925, 153, 4, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.18"}],

Cell[CellGroupData[{
Cell[22856, 933, 100, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[22959, 937, 87, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]],
Cell[23061, 943, 1330, 52, 70, "Text",
  CellTags->{"S2.7.2", "2.19"}],
Cell[24394, 997, 240, 9, 70, "MathCaption",
  CellTags->{"S2.7.2", "2.20"}],

Cell[CellGroupData[{
Cell[24659, 1010, 110, 2, 70, "Input",
  CellTags->"S2.7.2"],
Cell[24772, 1014, 120, 3, 70, "Output",
  CellTags->"S2.7.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24941, 1023, 75, 1, 70, "Subsection",
  CellTags->{"S2.7.3", "3.1"}],
Cell[25019, 1026, 542, 11, 70, "Text",
  CellTags->{"S2.7.3", "3.2"}],
Cell[25564, 1039, 284, 7, 70, "Text",
  CellTags->{"S2.7.3", "3.3"}],
Cell[25851, 1048, 536, 15, 70, "FramedBox",
  CellTags->"S2.7.3"],
Cell[26390, 1065, 132, 5, 70, "Caption",
  CellTags->"S2.7.3"],
Cell[26525, 1072, 155, 5, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.4"}],

Cell[CellGroupData[{
Cell[26705, 1081, 85, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[26793, 1085, 58, 2, 70, "Print",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[26866, 1090, 113, 2, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.5"}],

Cell[CellGroupData[{
Cell[27004, 1096, 98, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[27105, 1100, 58, 2, 70, "Print",
  CellTags->"S2.7.3"],
Cell[27166, 1104, 58, 2, 70, "Print",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[27239, 1109, 407, 8, 70, "Text",
  CellTags->{"S2.7.3", "3.6"}],
Cell[27649, 1119, 172, 5, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.7"}],

Cell[CellGroupData[{
Cell[27846, 1128, 91, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[27940, 1132, 388, 14, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[28343, 1149, 92, 1, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.8"}],
Cell[28438, 1152, 93, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[28534, 1156, 180, 6, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.9"}],

Cell[CellGroupData[{
Cell[28739, 1166, 72, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[28814, 1170, 304, 10, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[29133, 1183, 134, 4, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.10"}],

Cell[CellGroupData[{
Cell[29292, 1191, 71, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[29366, 1195, 82, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[29463, 1201, 85, 1, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.11"}],

Cell[CellGroupData[{
Cell[29573, 1206, 79, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[29655, 1210, 83, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[29753, 1216, 165, 4, 70, "Text",
  CellTags->{"S2.7.3", "3.12"}],
Cell[29921, 1222, 134, 4, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.13"}],

Cell[CellGroupData[{
Cell[30080, 1230, 78, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[30161, 1234, 84, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[30260, 1240, 108, 1, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.14"}],

Cell[CellGroupData[{
Cell[30393, 1245, 71, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[30467, 1249, 91, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[30573, 1255, 1015, 31, 70, "DefinitionBox",
  CellTags->"S2.7.3"],
Cell[31591, 1288, 83, 1, 70, "Caption",
  CellTags->"S2.7.3"],
Cell[31677, 1291, 384, 12, 70, "Text",
  CellTags->{"S2.7.3", "3.15"}],
Cell[32064, 1305, 160, 5, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.16"}],

Cell[CellGroupData[{
Cell[32249, 1314, 74, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[32326, 1318, 84, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[32425, 1324, 171, 5, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.17"}],

Cell[CellGroupData[{
Cell[32621, 1333, 98, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[32722, 1337, 97, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[32834, 1343, 198, 6, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.18"}],

Cell[CellGroupData[{
Cell[33057, 1353, 84, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[33144, 1357, 101, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[33260, 1363, 317, 11, 70, "Text",
  CellTags->{"S2.7.3", "3.19"}],
Cell[33580, 1376, 171, 6, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.20"}],

Cell[CellGroupData[{
Cell[33776, 1386, 85, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[33864, 1390, 93, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[33972, 1396, 94, 1, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.21"}],

Cell[CellGroupData[{
Cell[34091, 1401, 68, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[34162, 1405, 48, 1, 70, "Print",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[34225, 1409, 562, 11, 70, "Text",
  CellTags->{"S2.7.3", "3.22"}],
Cell[34790, 1422, 154, 5, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.23"}],

Cell[CellGroupData[{
Cell[34969, 1431, 86, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[35058, 1435, 59, 2, 70, "Print",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[35132, 1440, 168, 4, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.24"}],

Cell[CellGroupData[{
Cell[35325, 1448, 68, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[35396, 1452, 48, 1, 70, "Print",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[35459, 1456, 402, 11, 70, "Text",
  CellTags->{"S2.7.3", "3.25"}],
Cell[35864, 1469, 412, 10, 70, "Text",
  CellTags->{"S2.7.3", "3.26"}],
Cell[36279, 1481, 248, 5, 70, "Text",
  CellTags->{"S2.7.3", "3.27"}],
Cell[36530, 1488, 822, 22, 70, "Text",
  CellTags->{"S2.7.3", "3.28"}],
Cell[37355, 1512, 802, 24, 70, "DefinitionBox",
  CellTags->"S2.7.3"],
Cell[38160, 1538, 125, 4, 70, "Caption",
  CellTags->"S2.7.3"],
Cell[38288, 1544, 755, 20, 70, "Text",
  CellTags->{"S2.7.3", "3.29"}],
Cell[39046, 1566, 512, 17, 70, "Text",
  CellTags->{"S2.7.3", "3.30"}],
Cell[39561, 1585, 334, 10, 70, "Text",
  CellTags->{"S2.7.3", "3.31"}],
Cell[39898, 1597, 192, 6, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.32"}],

Cell[CellGroupData[{
Cell[40115, 1607, 100, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[40218, 1611, 90, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]],
Cell[40323, 1617, 551, 18, 70, "Text",
  CellTags->{"S2.7.3", "3.33"}],
Cell[40877, 1637, 395, 10, 70, "Text",
  CellTags->{"S2.7.3", "3.34"}],
Cell[41275, 1649, 178, 5, 70, "MathCaption",
  CellTags->{"S2.7.3", "3.35"}],

Cell[CellGroupData[{
Cell[41478, 1658, 110, 2, 70, "Input",
  CellTags->"S2.7.3"],
Cell[41591, 1662, 84, 3, 70, "Output",
  CellTags->"S2.7.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41724, 1671, 114, 2, 70, "Subsection",
  CellTags->{"S2.7.4", "4.1"}],
Cell[41841, 1675, 310, 8, 70, "Text",
  CellTags->{"S2.7.4", "4.2"}],
Cell[42154, 1685, 701, 29, 70, "Text",
  CellTags->{"S2.7.4", "4.3"}],
Cell[42858, 1716, 539, 13, 70, "Text",
  CellTags->{"S2.7.4", "4.4"}],
Cell[43400, 1731, 86, 1, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.5"}],

Cell[CellGroupData[{
Cell[43511, 1736, 99, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[43613, 1740, 116, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[43744, 1746, 257, 8, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.6"}],

Cell[CellGroupData[{
Cell[44026, 1758, 69, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[44098, 1762, 106, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[44219, 1768, 104, 1, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.7"}],

Cell[CellGroupData[{
Cell[44348, 1773, 68, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[44419, 1777, 89, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[44523, 1783, 411, 14, 70, "Text",
  CellTags->{"S2.7.4", "4.8"}],
Cell[44937, 1799, 189, 5, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.9"}],

Cell[CellGroupData[{
Cell[45151, 1808, 103, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[45257, 1812, 103, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[45375, 1818, 156, 4, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.10"}],

Cell[CellGroupData[{
Cell[45556, 1826, 105, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[45664, 1830, 104, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[45783, 1836, 512, 10, 70, "Text",
  CellTags->{"S2.7.4", "4.11"}],
Cell[46298, 1848, 219, 6, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.12"}],

Cell[CellGroupData[{
Cell[46542, 1858, 103, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[46648, 1862, 101, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[46764, 1868, 88, 1, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.13"}],

Cell[CellGroupData[{
Cell[46877, 1873, 118, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[46998, 1877, 135, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[47148, 1883, 102, 1, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.14"}],

Cell[CellGroupData[{
Cell[47275, 1888, 68, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[47346, 1892, 124, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[47485, 1898, 623, 17, 70, "Text",
  CellTags->{"S2.7.4", "4.15"}],
Cell[48111, 1917, 2536, 81, 70, "DefinitionBox",
  CellTags->"S2.7.4"],
Cell[50650, 2000, 120, 5, 70, "Caption",
  CellTags->"S2.7.4"],
Cell[50773, 2007, 354, 8, 70, "Text",
  CellTags->{"S2.7.4", "4.16"}],
Cell[51130, 2017, 176, 4, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.17"}],

Cell[CellGroupData[{
Cell[51331, 2025, 99, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[51433, 2029, 103, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[51551, 2035, 173, 5, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.18"}],

Cell[CellGroupData[{
Cell[51749, 2044, 106, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[51858, 2048, 110, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[51983, 2054, 138, 4, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.19"}],

Cell[CellGroupData[{
Cell[52146, 2062, 110, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[52259, 2066, 112, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[52386, 2072, 166, 5, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.20"}],

Cell[CellGroupData[{
Cell[52577, 2081, 104, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[52684, 2085, 108, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[52807, 2091, 162, 4, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.21"}],

Cell[CellGroupData[{
Cell[52994, 2099, 79, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[53076, 2103, 89, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[53180, 2109, 453, 15, 70, "Text",
  CellTags->{"S2.7.4", "4.22"}],
Cell[53636, 2126, 225, 9, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.23"}],

Cell[CellGroupData[{
Cell[53886, 2139, 96, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[53985, 2143, 103, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[54103, 2149, 526, 20, 70, "Text",
  CellTags->{"S2.7.4", "4.24"}],
Cell[54632, 2171, 357, 10, 70, "Text",
  CellTags->{"S2.7.4", "4.25"}],
Cell[54992, 2183, 182, 6, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.26"}],

Cell[CellGroupData[{
Cell[55199, 2193, 94, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[55296, 2197, 103, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[55414, 2203, 399, 11, 70, "Text",
  CellTags->{"S2.7.4", "4.27"}],
Cell[55816, 2216, 254, 9, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.28"}],

Cell[CellGroupData[{
Cell[56095, 2229, 104, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[56202, 2233, 114, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[56331, 2239, 185, 7, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.29"}],

Cell[CellGroupData[{
Cell[56541, 2250, 99, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[56643, 2254, 112, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[56770, 2260, 904, 31, 70, "Text",
  CellTags->{"S2.7.4", "4.30"}],
Cell[57677, 2293, 108, 1, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.31"}],
Cell[57788, 2296, 108, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[57899, 2300, 257, 10, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.32"}],

Cell[CellGroupData[{
Cell[58181, 2314, 78, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[58262, 2318, 101, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]],
Cell[58378, 2324, 135, 4, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.33"}],
Cell[58516, 2330, 138, 5, 70, "Input",
  CellTags->"S2.7.4"],
Cell[58657, 2337, 157, 5, 70, "MathCaption",
  CellTags->{"S2.7.4", "4.34"}],

Cell[CellGroupData[{
Cell[58839, 2346, 79, 2, 70, "Input",
  CellTags->"S2.7.4"],
Cell[58921, 2350, 122, 3, 70, "Output",
  CellTags->"S2.7.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59092, 2359, 89, 1, 70, "Subsection",
  CellTags->{"S2.7.5", "5.1"}],
Cell[59184, 2362, 353, 8, 70, "Text",
  CellTags->{"S2.7.5", "5.2"}],
Cell[59540, 2372, 478, 8, 70, "Text",
  CellTags->{"S2.7.5", "5.3"}],
Cell[60021, 2382, 101, 1, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.4"}],
Cell[60125, 2385, 103, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[60231, 2389, 150, 5, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.5"}],

Cell[CellGroupData[{
Cell[60406, 2398, 72, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[60481, 2402, 141, 4, 70, "Output",
  CellTags->"S2.7.5"]
}, Open  ]],
Cell[60637, 2409, 147, 4, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.6"}],
Cell[60787, 2415, 117, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[60907, 2419, 208, 5, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.7"}],

Cell[CellGroupData[{
Cell[61140, 2428, 73, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[61216, 2432, 161, 4, 70, "Output",
  CellTags->"S2.7.5"]
}, Open  ]],
Cell[61392, 2439, 383, 8, 70, "Text",
  CellTags->{"S2.7.5", "5.8"}],
Cell[61778, 2449, 462, 8, 70, "Text",
  CellTags->{"S2.7.5", "5.9"}],
Cell[62243, 2459, 154, 5, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.10"}],
Cell[62400, 2466, 98, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[62501, 2470, 141, 4, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.11"}],

Cell[CellGroupData[{
Cell[62667, 2478, 75, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[62745, 2482, 123, 3, 70, "Output",
  CellTags->"S2.7.5"]
}, Open  ]],
Cell[62883, 2488, 1321, 38, 70, "Text",
  CellTags->{"S2.7.5", "5.12"}],
Cell[64207, 2528, 188, 7, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.13"}],
Cell[64398, 2537, 91, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[64492, 2541, 128, 4, 70, "MathCaption",
  CellTags->{"S2.7.5", "5.14"}],

Cell[CellGroupData[{
Cell[64645, 2549, 79, 2, 70, "Input",
  CellTags->"S2.7.5"],
Cell[64727, 2553, 106, 3, 70, "Output",
  CellTags->"S2.7.5"]
}, Open  ]],
Cell[64848, 2559, 743, 14, 70, "Text",
  CellTags->{"S2.7.5", "5.15"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[65628, 2578, 82, 1, 70, "Subsection",
  CellTags->{"S2.7.6", "6.1"}],
Cell[65713, 2581, 401, 14, 70, "Text",
  CellTags->{"S2.7.6", "6.2"}],
Cell[66117, 2597, 2196, 72, 70, "DefinitionBox",
  CellTags->"S2.7.6"],
Cell[68316, 2671, 66, 1, 70, "Caption",
  CellTags->"S2.7.6"],
Cell[68385, 2674, 133, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.3"}],

Cell[CellGroupData[{
Cell[68543, 2683, 71, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[68617, 2687, 89, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[68721, 2693, 165, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.4"}],

Cell[CellGroupData[{
Cell[68911, 2702, 85, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[68999, 2706, 99, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[69113, 2712, 130, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.5"}],

Cell[CellGroupData[{
Cell[69268, 2721, 65, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[69336, 2725, 82, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[69433, 2731, 1041, 35, 70, "Text",
  CellTags->{"S2.7.6", "6.6"}],
Cell[70477, 2768, 185, 7, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.7"}],

Cell[CellGroupData[{
Cell[70687, 2779, 70, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[70760, 2783, 83, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[70858, 2789, 100, 1, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.8"}],

Cell[CellGroupData[{
Cell[70983, 2794, 85, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[71071, 2798, 58, 2, 70, "Print",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[71144, 2803, 139, 4, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.9"}],

Cell[CellGroupData[{
Cell[71308, 2811, 84, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[71395, 2815, 56, 2, 70, "Print",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[71466, 2820, 136, 4, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.10"}],

Cell[CellGroupData[{
Cell[71627, 2828, 90, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[71720, 2832, 85, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[71820, 2838, 177, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.11"}],

Cell[CellGroupData[{
Cell[72022, 2847, 65, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[72090, 2851, 83, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[72188, 2857, 548, 10, 70, "Text",
  CellTags->{"S2.7.6", "6.12"}],
Cell[72739, 2869, 146, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.13"}],
Cell[72888, 2876, 78, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[72969, 2880, 194, 7, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.14"}],

Cell[CellGroupData[{
Cell[73188, 2891, 66, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[73257, 2895, 92, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[73364, 2901, 164, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.15"}],

Cell[CellGroupData[{
Cell[73553, 2910, 86, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[73642, 2914, 91, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[73748, 2920, 481, 18, 70, "Text",
  CellTags->{"S2.7.6", "6.16"}],
Cell[74232, 2940, 180, 6, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.17"}],

Cell[CellGroupData[{
Cell[74437, 2950, 82, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[74522, 2954, 85, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[74622, 2960, 272, 8, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.18"}],

Cell[CellGroupData[{
Cell[74919, 2972, 88, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[75010, 2976, 85, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[75110, 2982, 540, 12, 70, "Text",
  CellTags->{"S2.7.6", "6.19"}],
Cell[75653, 2996, 422, 9, 70, "Text",
  CellTags->{"S2.7.6", "6.20"}],
Cell[76078, 3007, 212, 6, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.21"}],
Cell[76293, 3015, 81, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[76377, 3019, 144, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.22"}],

Cell[CellGroupData[{
Cell[76546, 3028, 69, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[76618, 3032, 91, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[76724, 3038, 151, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.23"}],

Cell[CellGroupData[{
Cell[76900, 3047, 85, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[76988, 3051, 90, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[77093, 3057, 332, 6, 70, "Text",
  CellTags->{"S2.7.6", "6.24"}],
Cell[77428, 3065, 178, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.25"}],
Cell[77609, 3072, 84, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[77696, 3076, 201, 7, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.26"}],

Cell[CellGroupData[{
Cell[77922, 3087, 69, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[77994, 3091, 91, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[78100, 3097, 152, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.27"}],

Cell[CellGroupData[{
Cell[78277, 3106, 85, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[78365, 3110, 86, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[78466, 3116, 140, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.28"}],

Cell[CellGroupData[{
Cell[78631, 3125, 66, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[78700, 3129, 91, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[78806, 3135, 615, 18, 70, "Text",
  CellTags->{"S2.7.6", "6.29"}],
Cell[79424, 3155, 151, 5, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.30"}],

Cell[CellGroupData[{
Cell[79600, 3164, 101, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[79704, 3168, 70, 2, 70, "Print",
  CellTags->"S2.7.6"]
}, Open  ]],
Cell[79789, 3173, 223, 7, 70, "MathCaption",
  CellTags->{"S2.7.6", "6.31"}],

Cell[CellGroupData[{
Cell[80037, 3184, 84, 2, 70, "Input",
  CellTags->"S2.7.6"],
Cell[80124, 3188, 109, 3, 70, "Output",
  CellTags->"S2.7.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[80282, 3197, 87, 1, 70, "Subsection",
  CellTags->{"S2.7.7", "7.1"}],
Cell[80372, 3200, 305, 7, 70, "Text",
  CellTags->{"S2.7.7", "7.2"}],
Cell[80680, 3209, 374, 8, 70, "Text",
  CellTags->{"S2.7.7", "7.3"}],
Cell[81057, 3219, 218, 5, 70, "Text",
  CellTags->{"S2.7.7", "7.4"}],
Cell[81278, 3226, 793, 24, 70, "DefinitionBox",
  CellTags->"S2.7.7"],
Cell[82074, 3252, 120, 4, 70, "Caption",
  CellTags->"S2.7.7"],
Cell[82197, 3258, 488, 11, 70, "Text",
  CellTags->{"S2.7.7", "7.5"}],
Cell[82688, 3271, 339, 9, 70, "Text",
  CellTags->{"S2.7.7", "7.6"}],
Cell[83030, 3282, 517, 10, 70, "Text",
  CellTags->{"S2.7.7", "7.7"}],
Cell[83550, 3294, 607, 18, 70, "Text",
  CellTags->{"S2.7.7", "7.8"}],
Cell[84160, 3314, 445, 17, 70, "Text",
  CellTags->{"S2.7.7", "7.9"}],
Cell[84608, 3333, 157, 7, 70, "MathCaption",
  CellTags->{"S2.7.7", "7.10"}],

Cell[CellGroupData[{
Cell[84790, 3344, 71, 2, 70, "Input",
  CellTags->"S2.7.7"],
Cell[84864, 3348, 85, 3, 70, "Output",
  CellTags->"S2.7.7"]
}, Open  ]],
Cell[84964, 3354, 262, 11, 70, "MathCaption",
  CellTags->{"S2.7.7", "7.11"}],

Cell[CellGroupData[{
Cell[85251, 3369, 85, 2, 70, "Input",
  CellTags->"S2.7.7"],
Cell[85339, 3373, 89, 3, 70, "Output",
  CellTags->"S2.7.7"]
}, Open  ]],
Cell[85443, 3379, 264, 11, 70, "MathCaption",
  CellTags->{"S2.7.7", "7.12"}],

Cell[CellGroupData[{
Cell[85732, 3394, 86, 2, 70, "Input",
  CellTags->"S2.7.7"],
Cell[85821, 3398, 89, 3, 70, "Output",
  CellTags->"S2.7.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[85959, 3407, 67, 1, 70, "Subsection",
  CellTags->{"S2.7.8", "8.1"}],
Cell[86029, 3410, 216, 5, 70, "Text",
  CellTags->{"S2.7.8", "8.2"}],
Cell[86248, 3417, 576, 13, 70, "Text",
  CellTags->{"S2.7.8", "8.3"}],
Cell[86827, 3432, 590, 18, 70, "Text",
  CellTags->{"S2.7.8", "8.4"}],
Cell[87420, 3452, 180, 7, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.5"}],

Cell[CellGroupData[{
Cell[87625, 3463, 70, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[87698, 3467, 87, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[87800, 3473, 106, 1, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.6"}],

Cell[CellGroupData[{
Cell[87931, 3478, 71, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[88005, 3482, 104, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[88124, 3488, 105, 1, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.7"}],

Cell[CellGroupData[{
Cell[88254, 3493, 75, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[88332, 3497, 83, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[88430, 3503, 212, 8, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.8"}],

Cell[CellGroupData[{
Cell[88667, 3515, 74, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[88744, 3519, 97, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[88856, 3525, 422, 11, 70, "Text",
  CellTags->{"S2.7.8", "8.9"}],
Cell[89281, 3538, 164, 4, 70, "Text",
  CellTags->{"S2.7.8", "8.10"}],
Cell[89448, 3544, 325, 10, 70, "Text",
  CellTags->{"S2.7.8", "8.11"}],
Cell[89776, 3556, 184, 7, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.12"}],

Cell[CellGroupData[{
Cell[89985, 3567, 72, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[90060, 3571, 90, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[90165, 3577, 137, 4, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.13"}],

Cell[CellGroupData[{
Cell[90327, 3585, 77, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[90407, 3589, 87, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[90509, 3595, 515, 11, 70, "Text",
  CellTags->{"S2.7.8", "8.14"}],
Cell[91027, 3608, 795, 26, 70, "Text",
  CellTags->{"S2.7.8", "8.15"}],
Cell[91825, 3636, 2347, 69, 70, "DefinitionBox",
  CellTags->"S2.7.8"],
Cell[94175, 3707, 81, 1, 70, "Caption",
  CellTags->"S2.7.8"],
Cell[94259, 3710, 137, 5, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.16"}],

Cell[CellGroupData[{
Cell[94421, 3719, 69, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[94493, 3723, 86, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[94594, 3729, 389, 12, 70, "Text",
  CellTags->{"S2.7.8", "8.17"}],
Cell[94986, 3743, 772, 20, 70, "Text",
  CellTags->{"S2.7.8", "8.18"}],
Cell[95761, 3765, 273, 6, 70, "Text",
  CellTags->{"S2.7.8", "8.19"}],
Cell[96037, 3773, 148, 4, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.20"}],

Cell[CellGroupData[{
Cell[96210, 3781, 76, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[96289, 3785, 103, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[96407, 3791, 242, 9, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.21"}],

Cell[CellGroupData[{
Cell[96674, 3804, 75, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[96752, 3808, 90, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[96857, 3814, 1009, 30, 70, "DefinitionBox",
  CellTags->"S2.7.8"],
Cell[97869, 3846, 84, 1, 70, "Caption",
  CellTags->"S2.7.8"],
Cell[97956, 3849, 460, 13, 70, "Text",
  CellTags->{"S2.7.8", "8.22"}],
Cell[98419, 3864, 351, 7, 70, "Text",
  CellTags->{"S2.7.8", "8.23"}],
Cell[98773, 3873, 155, 5, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.24"}],

Cell[CellGroupData[{
Cell[98953, 3882, 111, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[99067, 3886, 128, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[99210, 3892, 150, 5, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.25"}],

Cell[CellGroupData[{
Cell[99385, 3901, 156, 5, 70, "Input",
  CellTags->"S2.7.8"],
Cell[99544, 3908, 153, 4, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[99712, 3915, 201, 7, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.26"}],

Cell[CellGroupData[{
Cell[99938, 3926, 78, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[100019, 3930, 98, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[100132, 3936, 510, 9, 70, "Text",
  CellTags->{"S2.7.8", "8.27"}],
Cell[100645, 3947, 447, 11, 70, "Text",
  CellTags->{"S2.7.8", "8.28"}],
Cell[101095, 3960, 342, 11, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.29"}],

Cell[CellGroupData[{
Cell[101462, 3975, 76, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[101541, 3979, 307, 6, 70, "Message",
  CellTags->"S2.7.8"],
Cell[101851, 3987, 86, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[101952, 3993, 193, 7, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.30"}],

Cell[CellGroupData[{
Cell[102170, 4004, 78, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[102251, 4008, 91, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[102357, 4014, 580, 15, 70, "Text",
  CellTags->{"S2.7.8", "8.31"}],
Cell[102940, 4031, 643, 18, 70, "DefinitionBox",
  CellTags->"S2.7.8"],
Cell[103586, 4051, 131, 5, 70, "Caption",
  CellTags->"S2.7.8"],
Cell[103720, 4058, 136, 5, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.32"}],
Cell[103859, 4065, 77, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[103939, 4069, 191, 7, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.33"}],

Cell[CellGroupData[{
Cell[104155, 4080, 78, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[104236, 4084, 98, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[104349, 4090, 444, 12, 70, "Text",
  CellTags->{"S2.7.8", "8.34"}],
Cell[104796, 4104, 164, 4, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.35"}],

Cell[CellGroupData[{
Cell[104985, 4112, 111, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[105099, 4116, 114, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[105228, 4122, 436, 11, 70, "Text",
  CellTags->{"S2.7.8", "8.36"}],
Cell[105667, 4135, 152, 5, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.37"}],

Cell[CellGroupData[{
Cell[105844, 4144, 69, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[105916, 4148, 86, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]],
Cell[106017, 4154, 203, 8, 70, "MathCaption",
  CellTags->{"S2.7.8", "8.38"}],

Cell[CellGroupData[{
Cell[106245, 4166, 78, 2, 70, "Input",
  CellTags->"S2.7.8"],
Cell[106326, 4170, 91, 3, 70, "Output",
  CellTags->"S2.7.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[106466, 4179, 80, 1, 70, "Subsection",
  CellTags->{"S2.7.9", "9.1"}],
Cell[106549, 4182, 302, 7, 70, "Text",
  CellTags->{"S2.7.9", "9.2"}],
Cell[106854, 4191, 366, 8, 70, "Text",
  CellTags->{"S2.7.9", "9.3"}],
Cell[107223, 4201, 119, 2, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.4"}],
Cell[107345, 4205, 80, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[107428, 4209, 148, 5, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.5"}],

Cell[CellGroupData[{
Cell[107601, 4218, 76, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[107680, 4222, 121, 3, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[107816, 4228, 155, 5, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.6"}],

Cell[CellGroupData[{
Cell[107996, 4237, 77, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[108076, 4241, 97, 3, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[108188, 4247, 104, 1, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.7"}],

Cell[CellGroupData[{
Cell[108317, 4252, 90, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[108410, 4256, 160, 4, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[108585, 4263, 410, 8, 70, "Text",
  CellTags->{"S2.7.9", "9.8"}],
Cell[108998, 4273, 427, 8, 70, "Text",
  CellTags->{"S2.7.9", "9.9"}],
Cell[109428, 4283, 244, 7, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.10"}],

Cell[CellGroupData[{
Cell[109697, 4294, 74, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[109774, 4298, 281, 5, 70, "Message",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[110070, 4306, 117, 2, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.11"}],

Cell[CellGroupData[{
Cell[110212, 4312, 104, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[110319, 4316, 160, 4, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[110494, 4323, 599, 12, 70, "Text",
  CellTags->{"S2.7.9", "9.12"}],
Cell[111096, 4337, 103, 1, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.13"}],

Cell[CellGroupData[{
Cell[111224, 4342, 77, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[111304, 4346, 85, 3, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[111404, 4352, 192, 5, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.14"}],

Cell[CellGroupData[{
Cell[111621, 4361, 90, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[111714, 4365, 306, 6, 70, "Message",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[112035, 4374, 111, 1, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.15"}],

Cell[CellGroupData[{
Cell[112171, 4379, 98, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[112272, 4383, 99, 3, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[112386, 4389, 153, 5, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.16"}],
Cell[112542, 4396, 88, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[112633, 4400, 137, 5, 70, "MathCaption",
  CellTags->{"S2.7.9", "9.17"}],

Cell[CellGroupData[{
Cell[112795, 4409, 81, 2, 70, "Input",
  CellTags->"S2.7.9"],
Cell[112879, 4413, 90, 3, 70, "Output",
  CellTags->"S2.7.9"]
}, Open  ]],
Cell[112984, 4419, 595, 15, 70, "Text",
  CellTags->{"S2.7.9", "9.18"}],
Cell[113582, 4436, 519, 16, 70, "DefinitionBox",
  CellTags->"S2.7.9"],
Cell[114104, 4454, 69, 1, 70, "Caption",
  CellTags->"S2.7.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[114210, 4460, 138, 5, 70, "Subsection",
  CellTags->{"S2.7.10", "10.1"}],
Cell[114351, 4467, 495, 10, 70, "Text",
  CellTags->{"S2.7.10", "10.2"}],
Cell[114849, 4479, 418, 9, 70, "Text",
  CellTags->{"S2.7.10", "10.3"}],
Cell[115270, 4490, 477, 11, 70, "Text",
  CellTags->{"S2.7.10", "10.4"}],
Cell[115750, 4503, 1461, 42, 70, "DefinitionBox",
  CellTags->"S2.7.10"],
Cell[117214, 4547, 140, 5, 70, "Caption",
  CellTags->"S2.7.10"],
Cell[117357, 4554, 411, 11, 70, "Text",
  CellTags->{"S2.7.10", "10.5"}],
Cell[117771, 4567, 2553, 77, 70, "DefinitionBox",
  CellTags->"S2.7.10"],
Cell[120327, 4646, 116, 4, 70, "Caption",
  CellTags->"S2.7.10"],
Cell[120446, 4652, 56, 1, 70, "ProgramTop",
  CellTags->{"S2.7.10", "10.6"}],
Cell[120505, 4655, 472, 20, 70, "Program",
  CellTags->{"S2.7.10", "10.7"}],
Cell[120980, 4677, 59, 1, 70, "ProgramBottom",
  CellTags->{"S2.7.10", "10.8"}],
Cell[121042, 4680, 116, 5, 70, "Caption",
  CellTags->"S2.7.10"],
Cell[121161, 4687, 516, 12, 70, "Text",
  CellTags->{"S2.7.10", "10.9"}],
Cell[121680, 4701, 424, 9, 70, "Text",
  CellTags->{"S2.7.10", "10.10"}],
Cell[122107, 4712, 103, 1, 70, "MathCaption",
  CellTags->{"S2.7.10", "10.11"}],
Cell[122213, 4715, 76, 2, 70, "Input",
  CellTags->"S2.7.10"],
Cell[122292, 4719, 214, 6, 70, "MathCaption",
  CellTags->{"S2.7.10", "10.12"}],

Cell[CellGroupData[{
Cell[122531, 4729, 77, 2, 70, "Input",
  CellTags->"S2.7.10"],
Cell[122611, 4733, 116, 3, 70, "Output",
  CellTags->"S2.7.10"]
}, Open  ]],
Cell[122742, 4739, 187, 7, 70, "MathCaption",
  CellTags->{"S2.7.10", "10.13"}],

Cell[CellGroupData[{
Cell[122954, 4750, 81, 2, 70, "Input",
  CellTags->"S2.7.10"],
Cell[123038, 4754, 92, 3, 70, "Output",
  CellTags->"S2.7.10"]
}, Open  ]],
Cell[123145, 4760, 193, 7, 70, "MathCaption",
  CellTags->{"S2.7.10", "10.14"}],

Cell[CellGroupData[{
Cell[123363, 4771, 83, 2, 70, "Input",
  CellTags->"S2.7.10"],
Cell[123449, 4775, 75, 2, 70, "Print",
  CellTags->"S2.7.10"]
}, Open  ]],
Cell[123539, 4780, 341, 9, 70, "Text",
  CellTags->{"S2.7.10", "10.15"}],
Cell[123883, 4791, 279, 6, 70, "Text",
  CellTags->{"S2.7.10", "10.16"}],
Cell[124165, 4799, 891, 25, 70, "Text",
  CellTags->{"S2.7.10", "10.17"}],
Cell[125059, 4826, 1798, 53, 70, "DefinitionBox",
  CellTags->"S2.7.10"],
Cell[126860, 4881, 96, 1, 70, "Caption",
  CellTags->"S2.7.10"],
Cell[126959, 4884, 992, 24, 70, "Text",
  CellTags->{"S2.7.10", "10.18"}],
Cell[127954, 4910, 627, 18, 70, "DefinitionBox",
  CellTags->"S2.7.10"],
Cell[128584, 4930, 74, 1, 70, "Caption",
  CellTags->"S2.7.10"],
Cell[128661, 4933, 776, 18, 70, "Text",
  CellTags->{"S2.7.10", "10.19"}],
Cell[129440, 4953, 384, 10, 70, "Text",
  CellTags->{"S2.7.10", "10.20"}],
Cell[129827, 4965, 219, 7, 70, "MathCaption",
  CellTags->{"S2.7.10", "10.21"}],

Cell[CellGroupData[{
Cell[130071, 4976, 105, 2, 70, "Input",
  CellTags->"S2.7.10"],
Cell[130179, 4980, 65, 2, 70, "Print",
  CellTags->"S2.7.10"],
Cell[130247, 4984, 86, 3, 70, "Output",
  CellTags->"S2.7.10"]
}, Open  ]],
Cell[130348, 4990, 290, 7, 70, "Text",
  CellTags->{"S2.7.10", "10.22"}],
Cell[130641, 4999, 916, 20, 70, "Text",
  CellTags->{"S2.7.10", "10.23"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[131594, 5024, 91, 1, 70, "Subsection",
  CellTags->{"S2.7.11", "11.1"}],
Cell[131688, 5027, 490, 15, 70, "Text",
  CellTags->{"S2.7.11", "11.2"}],
Cell[132181, 5044, 349, 8, 70, "Text",
  CellTags->{"S2.7.11", "11.3"}],
Cell[132533, 5054, 1537, 44, 70, "DefinitionBox",
  CellTags->"S2.7.11"],
Cell[134073, 5100, 87, 1, 70, "Caption",
  CellTags->"S2.7.11"],
Cell[134163, 5103, 276, 11, 70, "MathCaption",
  CellTags->{"S2.7.11", "11.4"}],

Cell[CellGroupData[{
Cell[134464, 5118, 150, 5, 70, "Input",
  CellTags->"S2.7.11"],
Cell[134617, 5125, 108, 3, 70, "Output",
  CellTags->"S2.7.11"]
}, Open  ]],
Cell[134740, 5131, 214, 7, 70, "MathCaption",
  CellTags->{"S2.7.11", "11.5"}],

Cell[CellGroupData[{
Cell[134979, 5142, 100, 2, 70, "Input",
  CellTags->"S2.7.11"],
Cell[135082, 5146, 97, 3, 70, "Output",
  CellTags->"S2.7.11"]
}, Open  ]],
Cell[135194, 5152, 640, 14, 70, "Text",
  CellTags->{"S2.7.11", "11.6"}],
Cell[135837, 5168, 509, 12, 70, "Text",
  CellTags->{"S2.7.11", "11.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[136383, 5185, 103, 1, 70, "Subsection",
  CellTags->{"S2.7.12", "12.1"}],
Cell[136489, 5188, 650, 18, 70, "DefinitionBox",
  CellTags->"S2.7.12"],
Cell[137142, 5208, 86, 1, 70, "Caption",
  CellTags->"S2.7.12"],
Cell[137231, 5211, 122, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.2"}],

Cell[CellGroupData[{
Cell[137378, 5220, 79, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[137460, 5224, 78, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[137553, 5229, 78, 1, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.3"}],

Cell[CellGroupData[{
Cell[137656, 5234, 91, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[137750, 5238, 82, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[137847, 5243, 131, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.4"}],

Cell[CellGroupData[{
Cell[138003, 5252, 91, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[138097, 5256, 78, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[138190, 5261, 471, 17, 70, "Text",
  CellTags->{"S2.7.12", "12.5"}],
Cell[138664, 5280, 391, 13, 70, "Text",
  CellTags->{"S2.7.12", "12.6"}],
Cell[139058, 5295, 252, 11, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.7"}],

Cell[CellGroupData[{
Cell[139335, 5310, 113, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[139451, 5314, 92, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[139558, 5319, 127, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.8"}],

Cell[CellGroupData[{
Cell[139710, 5328, 70, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[139783, 5332, 83, 3, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[139881, 5338, 174, 7, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.9"}],

Cell[CellGroupData[{
Cell[140080, 5349, 85, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[140168, 5353, 84, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[140267, 5358, 142, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.10"}],

Cell[CellGroupData[{
Cell[140434, 5367, 79, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[140516, 5371, 103, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[140634, 5376, 1216, 36, 70, "DefinitionBox",
  CellTags->"S2.7.12"],
Cell[141853, 5414, 85, 1, 70, "Caption",
  CellTags->"S2.7.12"],
Cell[141941, 5417, 264, 10, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.11"}],

Cell[CellGroupData[{
Cell[142230, 5431, 110, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[142343, 5435, 101, 3, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[142459, 5441, 422, 13, 70, "Text",
  CellTags->{"S2.7.12", "12.12"}],
Cell[142884, 5456, 232, 7, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.13"}],

Cell[CellGroupData[{
Cell[143141, 5467, 91, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[143235, 5471, 92, 2, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[143342, 5476, 170, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.14"}],

Cell[CellGroupData[{
Cell[143537, 5485, 93, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[143633, 5489, 180, 5, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[143828, 5497, 192, 6, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.15"}],

Cell[CellGroupData[{
Cell[144045, 5507, 114, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[144162, 5511, 99, 3, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[144276, 5517, 1407, 40, 70, "DefinitionBox",
  CellTags->"S2.7.12"],
Cell[145686, 5559, 74, 1, 70, "Caption",
  CellTags->"S2.7.12"],
Cell[145763, 5562, 165, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.16"}],
Cell[145931, 5569, 79, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[146013, 5573, 141, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.17"}],

Cell[CellGroupData[{
Cell[146179, 5582, 79, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[146261, 5586, 94, 3, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[146370, 5592, 138, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.18"}],

Cell[CellGroupData[{
Cell[146533, 5601, 73, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[146609, 5605, 90, 3, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[146714, 5611, 163, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.19"}],
Cell[146880, 5618, 80, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[146963, 5622, 139, 5, 70, "MathCaption",
  CellTags->{"S2.7.12", "12.20"}],

Cell[CellGroupData[{
Cell[147127, 5631, 79, 2, 70, "Input",
  CellTags->"S2.7.12"],
Cell[147209, 5635, 85, 3, 70, "Output",
  CellTags->"S2.7.12"]
}, Open  ]],
Cell[147309, 5641, 477, 14, 70, "DefinitionBox",
  CellTags->"S2.7.12"],
Cell[147789, 5657, 84, 1, 70, "Caption",
  CellTags->"S2.7.12"],
Cell[147876, 5660, 525, 14, 70, "Text",
  CellTags->{"S2.7.12", "12.21"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[148438, 5679, 128, 4, 70, "Subsection",
  CellTags->{"S2.7.13", "13.1"}],
Cell[148569, 5685, 359, 8, 70, "Text",
  CellTags->{"S2.7.13", "13.2"}],
Cell[148931, 5695, 580, 15, 70, "DefinitionBox",
  CellTags->"S2.7.13"],
Cell[149514, 5712, 91, 1, 70, "Caption",
  CellTags->"S2.7.13"],
Cell[149608, 5715, 176, 5, 70, "MathCaption",
  CellTags->{"S2.7.13", "13.3"}],
Cell[149787, 5722, 84, 2, 70, "Input",
  CellTags->"S2.7.13"],
Cell[149874, 5726, 166, 4, 70, "MathCaption",
  CellTags->{"S2.7.13", "13.4"}],

Cell[CellGroupData[{
Cell[150065, 5734, 71, 2, 70, "Input",
  CellTags->"S2.7.13"],
Cell[150139, 5738, 125, 3, 18, "Message",
  CellTags->"S2.7.13"],
Cell[150267, 5743, 118, 3, 70, "Message",
  CellTags->"S2.7.13"],
Cell[150388, 5748, 88, 3, 25, "Output",
  CellTags->"S2.7.13"]
}, Open  ]],
Cell[150491, 5754, 87, 1, 40, "MathCaption",
  CellTags->{"S2.7.13", "13.5"}],
Cell[150581, 5757, 85, 2, 28, "Input",
  CellTags->"S2.7.13"],
Cell[150669, 5761, 495, 11, 88, "Text",
  CellTags->{"S2.7.13", "13.6"}],
Cell[151167, 5774, 427, 14, 64, "DefinitionBox",
  CellTags->"S2.7.13"],
Cell[151597, 5790, 94, 1, 16, "Caption",
  CellTags->"S2.7.13"],
Cell[151694, 5793, 467, 12, 72, "Text",
  CellTags->{"S2.7.13", "13.7"}],
Cell[152164, 5807, 141, 4, 40, "MathCaption",
  CellTags->{"S2.7.13", "13.8"}],

Cell[CellGroupData[{
Cell[152330, 5815, 120, 2, 28, "Input",
  CellTags->"S2.7.13"],
Cell[152453, 5819, 122, 3, 25, "Output",
  CellTags->"S2.7.13"]
}, Open  ]],
Cell[152590, 5825, 177, 7, 40, "MathCaption",
  CellTags->{"S2.7.13", "13.9"}],

Cell[CellGroupData[{
Cell[152792, 5836, 70, 2, 28, "Input",
  CellTags->"S2.7.13"],
Cell[152865, 5840, 246, 5, 21, "Print",
  CellTags->"S2.7.13"],
Cell[153114, 5847, 246, 5, 21, "Print",
  CellTags->"S2.7.13"],
Cell[153363, 5854, 87, 3, 25, "Output",
  CellTags->"S2.7.13"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

