(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    185117,       6593]*)
(*NotebookOutlinePosition[    258552,       8714]*)
(*  CellTagsIndexPosition[    252562,       8478]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.8 ", "HeadingNumber"],
  "Strings and Characters"
}], "Section",
  CellTags->{"S2.8.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.8.1 Properties of Strings", "Subsection",
  CellTags->{"S2.8.1", "1.1"}],

Cell[TextData[{
  "Much of what ",
  StyleBox["Mathematica", "TI"],
  " does revolves around manipulating structured expressions. But you can \
also use ",
  StyleBox["Mathematica", "TI"],
  " as a system for handling unstructured strings of text.  "
}], "Text",
  CellTags->{"S2.8.1", "1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a string containing arbitrary text "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.1"],

Cell["Text strings. ", "Caption",
  CellTags->"S2.8.1"],

Cell[TextData[{
  "When you input a string of text to ",
  StyleBox["Mathematica", "TI"],
  " you must always enclose it in quotes. However, when ",
  StyleBox["Mathematica", "TI"],
  " outputs the string it usually does not explicitly show the quotes.  "
}], "Text",
  CellTags->{"S2.8.1", "1.3"}],

Cell[TextData[{
  "You can see the quotes by asking for the input form of the string. In \
addition, in a ",
  StyleBox["Mathematica", "TI"],
  " notebook, quotes will typically appear automatically as soon as you start \
to edit a string. "
}], "Text",
  CellTags->{"S2.8.1", "1.4"}],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " outputs a string, it usually does not explicitly show the quotes. "
}], "MathCaption",
  CellTags->{"S2.8.1", "1.5"}],

Cell[CellGroupData[{

Cell["\"This is a string.\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    \("This is a string."\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell["\<\
You can see the quotes, however, by asking for the input form of \
the string. \
\>", "MathCaption",
  CellTags->{"S2.8.1", "1.6"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.1"],

Cell["\"This is a string.\"", "Output",
  CellLabel->"Out[2]//InputForm= ",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell[TextData[{
  "The fact that ",
  StyleBox["Mathematica", "TI"],
  " does not usually show explicit quotes around strings makes it possible \
for you to use strings to specify quite directly the textual output you want. \
"
}], "Text",
  CellTags->{"S2.8.1", "1.7"}],

Cell["The strings are printed out here without explicit quotes. ", \
"MathCaption",
  CellTags->{"S2.8.1", "1.8"}],

Cell[CellGroupData[{

Cell["Print[\"The value is \", 567, \".\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    InterpretationBox[\("The value is \
"\[InvisibleSpace]567\[InvisibleSpace]"."\),
      SequenceForm[ "The value is ", 567, "."],
      Editable->False]], "Print",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell[TextData[{
  "You should understand, however, that even though the string ",
  StyleBox["\"x\"", "MR"],
  " often appears as ",
  StyleBox["x", "MR"],
  " in output, it is still a quite different object from the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.1", "1.9"}],

Cell[TextData[{
  "The string ",
  StyleBox["\"x\"", "MR"],
  " is not the same as the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.1", "1.10"}],

Cell[CellGroupData[{

Cell["\"x\" === x", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell[TextData[{
  "You can test whether any particular expression is a string by looking at \
its head. The head of any string is always ",
  StyleBox["String", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.1", "1.11"}],

Cell[TextData[{
  "All strings have head ",
  StyleBox["String", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.1", "1.12"}],

Cell[CellGroupData[{

Cell["Head[\"x\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell[TextData[{
  "The pattern ",
  StyleBox["_String", "MR"],
  " matches any string. "
}], "MathCaption",
  CellTags->{"S2.8.1", "1.13"}],

Cell[CellGroupData[{

Cell["Cases[{\"ab\", x, \"a\", y}, _String]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    \({"ab", "a"}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell["\<\
You can use strings just like other expressions as elements of \
patterns and transformations. Note, however, that you cannot assign values \
directly to strings. \
\>", "Text",
  CellTags->{"S2.8.1", "1.14"}],

Cell["\<\
This gives a definition for an expression that involves a string. \
\
\>", "MathCaption",
  CellTags->{"S2.8.1", "1.15"}],

Cell[CellGroupData[{

Cell["z[\"gold\"] = 79", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    \(79\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.1"]
}, Open  ]],

Cell[TextData[{
  "This replaces each occurrence of the string ",
  StyleBox["\"aa\"", "MR"],
  " by the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.1", "1.16"}],

Cell[CellGroupData[{

Cell["{\"aaa\", \"aa\", \"bb\", \"aa\"} /. \"aa\" -> x", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.1"],

Cell[BoxData[
    \({"aaa", x, "bb", x}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.2 Operations on Strings", "Subsection",
  CellTags->{"S2.8.2", "2.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides a variety of functions for manipulating strings. Most of these \
functions are based on viewing strings as a sequence of characters, and many \
of the functions are analogous to ones for manipulating lists. "
}], "Text",
  CellTags->{"S2.8.2", "2.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["<>", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["<>", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              "  or  ",
              StyleBox["StringJoin[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["join several strings together "]},
          {Cell[TextData[{
              StyleBox["StringLength[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the number of characters in a string "]},
          {Cell[TextData[{
              StyleBox["StringReverse[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["reverse the characters in a string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Operations on complete strings. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  "You can join together any number of strings using ",
  StyleBox["<>", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.3"}],

Cell[CellGroupData[{

Cell["\"aaaaaaa\" <> \"bbb\" <> \"cccccccccc\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("aaaaaaabbbcccccccccc"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["StringLength", "MR"],
  " gives the number of characters in a string. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.4"}],

Cell[CellGroupData[{

Cell["StringLength[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \(20\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["StringReverse", "MR"],
  " reverses the characters in a string. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.5"}],

Cell[CellGroupData[{

Cell["StringReverse[\"A string.\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \(".gnirts A"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringTake[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a string by taking the first ",
              StyleBox["n", "TI"],
              " characters from ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringTake[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "take the ",
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " character from ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringTake[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "take characters ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringDrop[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "make a string by dropping the first ",
              StyleBox["n", "TI"],
              " characters in ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringDrop[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "drop characters ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " through ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Taking and dropping substrings. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  StyleBox["StringTake", "MR"],
  " and ",
  StyleBox["StringDrop", "MR"],
  " are the analogs for strings of ",
  StyleBox["Take", "MR"],
  " and ",
  StyleBox["Drop", "MR"],
  " for lists. Like ",
  StyleBox["Take", "MR"],
  " and ",
  StyleBox["Drop", "MR"],
  ", they use standard ",
  StyleBox["Mathematica", "TI"],
  " sequence specifications, so that, for example, negative numbers count \
character positions from the end of a string. Note that the first character \
of a string is taken to have position ",
  StyleBox["1", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.2", "2.6"}],

Cell["Here is a sample string. ", "MathCaption",
  CellTags->{"S2.8.2", "2.7"}],

Cell[CellGroupData[{

Cell["alpha = \"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("ABCDEFGHIJKLMNOPQRSTUVWXYZ"\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "This takes the first five characters from ",
  StyleBox["alpha", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.8"}],

Cell[CellGroupData[{

Cell["StringTake[alpha, 5]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("ABCDE"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "Here is the fifth character in ",
  StyleBox["alpha", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.9"}],

Cell[CellGroupData[{

Cell["StringTake[alpha, {5}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("E"\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell["\<\
This drops the characters 10 through 2, counting from the end of \
the string. \
\>", "MathCaption",
  CellTags->{"S2.8.2", "2.10"}],

Cell[CellGroupData[{

Cell["StringDrop[alpha, {-10, -2}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("ABCDEFGHIJKLMNOPZ"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringInsert[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["snew", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert the string ",
              StyleBox["snew", "TI"],
              " at position ",
              StyleBox["n", "TI"],
              " in ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringInsert[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["snew", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert several copies of ",
              StyleBox["snew", "TI"],
              " into ",
              StyleBox["s", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Inserting into a string. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  StyleBox["StringInsert[", "MR"],
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["snew", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " is set up to produce a string whose ",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " character is the first character of ",
  StyleBox["snew", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.8.2", "2.11"}],

Cell[TextData[{
  "This produces a new string whose fourth character is the first character \
of the string ",
  StyleBox["\"XX\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.12"}],

Cell[CellGroupData[{

Cell["StringInsert[\"abcdefgh\", \"XX\", 4]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("abcXXdefgh"\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell["Negative positions are counted from the end of the string. ", \
"MathCaption",
  CellTags->{"S2.8.2", "2.13"}],

Cell[CellGroupData[{

Cell["StringInsert[\"abcdefgh\", \"XXX\", -1]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("abcdefghXXX"\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "Each copy of ",
  StyleBox["\"XXX\"", "MR"],
  " is inserted at the specified position in the original string. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.14"}],

Cell[CellGroupData[{

Cell["StringInsert[\"abcdefgh\", \"XXX\", {2, 4, -1}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("aXXXbcXXXdefghXXX"\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringReplacePart[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["snew", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace the characters at positions ",
              StyleBox["m", "TI"],
              " through ",
              StyleBox["n", "TI"],
              " in ",
              StyleBox["s", "TI"],
              " by the string ",
              StyleBox["snew", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplacePart[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["snew", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace several substrings in ",
              StyleBox["s", "TI"],
              " by ",
              StyleBox["snew", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplacePart[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["snew",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["snew",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "}, {",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["m",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "}, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "replace substrings in ",
              StyleBox["s", "TI"],
              " by the corresponding ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["snew",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Replacing parts of a string. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  "This replaces characters 2 through 6 by the string ",
  StyleBox["\"XXX\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.15"}],

Cell[CellGroupData[{

Cell["StringReplacePart[\"abcdefgh\", \"XXX\", {2, 6}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("aXXXgh"\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "This replaces two runs of characters by the string ",
  StyleBox["\"XXX\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.16"}],

Cell[CellGroupData[{

Cell["StringReplacePart[\"abcdefgh\", \"XXX\", {{2, 3}, {5, -1}}]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("aXXXdXXX"\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell["\<\
Now the two runs of characters are replaced by different strings. \
\
\>", "MathCaption",
  CellTags->{"S2.8.2", "2.17"}],

Cell[CellGroupData[{

Cell["\<\
StringReplacePart[\"abcdefgh\", {\"XXX\", \"YYYY\"}, {{2, 3}, {5, \
-1}}]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("aXXXdYYYY"\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringPosition[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sub", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the starting and ending positions at which ",
              StyleBox["sub", "TI"],
              " appears as a substring of ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringPosition[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sub", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["k", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "include only the first ",
              StyleBox["k", "TI"],
              " occurrences of ",
              StyleBox["sub", "TI"],
              " in ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringPosition[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "include occurrences of any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Finding positions of substrings. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  "You can use ",
  StyleBox["StringPosition", "MR"],
  " to find where a particular substring appears within a given string. ",
  StyleBox["StringPosition", "MR"],
  " returns a list, each of whose elements corresponds to an occurrence of \
the substring. The elements consist of lists giving the starting and ending \
character positions for the substring. These lists are in the form used as \
sequence specifications in ",
  StyleBox["StringTake", "MR"],
  ", ",
  StyleBox["StringDrop", "MR"],
  " and ",
  StyleBox["StringReplacePart", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.2", "2.18"}],

Cell[TextData[{
  "This gives a list of the positions of the substring ",
  StyleBox["\"abc\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.19"}],

Cell[CellGroupData[{

Cell["StringPosition[\"abcdabcdaabcabcd\", \"abc\"]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({{1, 3}, {5, 7}, {10, 12}, {13, 15}}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "This gives only the first occurrence of ",
  StyleBox["\"abc\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.20"}],

Cell[CellGroupData[{

Cell["StringPosition[\"abcdabcdaabcabcd\", \"abc\", 1]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({{1, 3}}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "This shows where both ",
  StyleBox["\"abc\"", "MR"],
  " and ",
  StyleBox["\"cd\"", "MR"],
  " appear. By default, overlaps are included. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.21"}],

Cell[CellGroupData[{

Cell["StringPosition[\"abcdabcdcd\", {\"abc\", \"cd\"}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({{1, 3}, {3, 4}, {5, 7}, {7, 8}, {9, 10}}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell["This does not include overlaps. ", "MathCaption",
  CellTags->{"S2.8.2", "2.22"}],

Cell[CellGroupData[{

Cell["\<\
StringPosition[\"abcdabcdcd\", {\"abc\", \"cd\"}, Overlaps -> \
False]\
\>", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({{1, 3}, {5, 7}, {9, 10}}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringCount[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sub", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "count the occurrences of ",
              StyleBox["sub", "TI"],
              " in ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringCount[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "count occurrences of any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringFreeQ[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sub", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["s", "TI"],
              " is free of ",
              StyleBox["sub", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringFreeQ[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["s", "TI"],
              " is free of all the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sub",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Testing for substrings. ", "Caption",
  CellTags->"S2.8.2"],

Cell["\<\
This counts occurrences of either substring, by default not \
including overlaps. \
\>", "MathCaption",
  CellTags->{"S2.8.2", "2.23"}],

Cell[CellGroupData[{

Cell["StringCount[\"abcdabcdcd\", {\"abc\", \"cd\"}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringReplace[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sb", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["sbnew", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace ",
              StyleBox["sb", "TI"],
              " by ",
              StyleBox["sbnew", "TI"],
              " wherever it appears in ",
              StyleBox["s", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplace[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sb",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sbnew",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sb",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sbnew",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sb",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " by the corresponding ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sbnew",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplace[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "do at most ",
              StyleBox["n", "TI"],
              " replacements "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplaceList[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
give a list of the strings obtained by making each \
possible single replacement \
\>"]},
          {Cell[TextData[{
              StyleBox["StringReplaceList[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["rules", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give at most ",
              StyleBox["n", "TI"],
              " results "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Replacing substrings according to rules. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  "This replaces all occurrences of the character ",
  StyleBox["a", "MR"],
  " by the string ",
  StyleBox["XX", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.24"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abcdabcdaabcabcd\", \"a\" -> \"XX\"]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("XXbcdXXbcdXXXXbcXXbcd"\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "This replaces ",
  StyleBox["abc", "MR"],
  " by ",
  StyleBox["Y", "MR"],
  ", and ",
  StyleBox["d", "MR"],
  " by ",
  StyleBox["XXX", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.25"}],

Cell[CellGroupData[{

Cell["\<\
StringReplace[\"abcdabcdaabcabcd\", {\"abc\" -> \"Y\", \"d\" -> \
\"XXX\"}]\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("YXXXYXXXaYYXXX"\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "The first occurrence of ",
  StyleBox["cde", "MR"],
  " is not replaced because it overlaps with ",
  StyleBox["abc", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.26"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abcde abacde\", {\"abc\" -> \"X\", \"cde\" -> \"Y\"}]", \
"Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \("Xde abaY"\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["StringReplace", "MR"],
  " scans a string from left to right, doing all the replacements it can, and \
then returning the resulting string. Sometimes, however, it is useful to see \
what all possible single replacements would give. You can get a list of all \
these results using ",
  StyleBox["StringReplaceList", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.2", "2.27"}],

Cell[TextData[{
  "This gives a list of the results of replacing each of the ",
  StyleBox["a", "MR"],
  "'s. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.28"}],

Cell[CellGroupData[{

Cell["StringReplaceList[\"aaaaa\", \"a\" -> \"X\"]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"Xaaaa", "aXaaa", "aaXaa", "aaaXa", "aaaaX"}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell["This shows the results of all possible single replacements. ", \
"MathCaption",
  CellTags->{"S2.8.2", "2.29"}],

Cell[CellGroupData[{

Cell["\<\
StringReplaceList[\"abcde abacde\", {\"abc\" -> \"X\", \"cde\" -> \
\"Y\"}]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"Xde abacde", "abY abacde", "abcde abaY"}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringSplit[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split ",
              StyleBox["s", "TI"],
              " into substrings delimited by whitespace "
            }]]},
          {Cell[TextData[{
              StyleBox["StringSplit[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["del", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split at delimiter ",
              StyleBox["del", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringSplit[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["del",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["del",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "split at any of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["del",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringSplit[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["del", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split into at most ",
              StyleBox["n", "TI"],
              " substrings "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Splitting strings. ", "Caption",
  CellTags->"S2.8.2"],

Cell["This splits the string at every run of spaces. ", "MathCaption",
  CellTags->{"S2.8.2", "2.30"}],

Cell[CellGroupData[{

Cell["StringSplit[\"a b::c d::e f g\"]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"a", "b::c", "d::e", "f", "g"}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[TextData[{
  "This splits at each ",
  StyleBox["\"::\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.31"}],

Cell[CellGroupData[{

Cell["StringSplit[\"a b::c d::e f g\", \"::\"]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"a b", "c d", "e f  g"}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell["This splits at each colon or space. ", "MathCaption",
  CellTags->{"S2.8.2", "2.32"}],

Cell[CellGroupData[{

Cell["StringSplit[\"a b::c d::e f g\", {\":\", \" \"}]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"a", "b", \*"\<\"\"\>", "c", "d", \*"\<\"\"\>", "e", 
      "f", \*"\<\"\"\>", "g"}\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringSplit[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["del", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert ",
              StyleBox["rhs", "TI"],
              " at the position of each delimiter "
            }]]},
          {Cell[TextData[{
              StyleBox["StringSplit[", "MR"],
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["del",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["del",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["->", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "insert ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["rhs",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " at the position of the corresponding ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["del",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Splitting strings with replacements for delimiters. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  "This inserts ",
  StyleBox["{x,", "MR"],
  " ",
  StyleBox["y}", "MR"],
  " at each ",
  StyleBox["::", "MR"],
  " delimiter. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.33"}],

Cell[CellGroupData[{

Cell["StringSplit[\"a b::c d::e f g\", \"::\"->{x, y}]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"a b", {x, y}, "c d", {x, y}, "e f  g"}\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.8.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Sort[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["sort a list of strings "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.2"],

Cell["Sorting strings. ", "Caption",
  CellTags->"S2.8.2"],

Cell[TextData[{
  StyleBox["Sort", "MR"],
  " sorts strings into standard dictionary order. "
}], "MathCaption",
  CellTags->{"S2.8.2", "2.34"}],

Cell[CellGroupData[{

Cell["Sort[{\"cat\", \"fish\", \"catfish\", \"Cat\"}]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.8.2"],

Cell[BoxData[
    \({"cat", "Cat", "catfish", "fish"}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S2.8.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.3 Characters in Strings", "Subsection",
  CellTags->{"S2.8.3", "3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Characters[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["convert a string to a list of characters "]},
          {Cell[TextData[{
              StyleBox["StringJoin[{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["convert a list of characters to a string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.3"],

Cell["Converting between strings and lists of characters. ", "Caption",
  CellTags->"S2.8.3"],

Cell["This gives a list of the characters in the string. ", "MathCaption",
  CellTags->{"S2.8.3", "3.2"}],

Cell[CellGroupData[{

Cell["Characters[\"A string.\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \({"A", " ", "s", "t", "r", "i", "n", "g", "."}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell["\<\
You can apply standard list manipulation operations to this list. \
\
\>", "MathCaption",
  CellTags->{"S2.8.3", "3.3"}],

Cell[CellGroupData[{

Cell["RotateLeft[%, 3]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \({"t", "r", "i", "n", "g", ".", "A", " ", "s"}\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["StringJoin", "MR"],
  " converts the list of characters back to a single string. "
}], "MathCaption",
  CellTags->{"S2.8.3", "3.4"}],

Cell[CellGroupData[{

Cell["StringJoin[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \("tring.A s"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DigitQ[", "MR"],
              StyleBox["string", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "test whether all characters in a string are digits "]},
          {Cell[TextData[{
              StyleBox["LetterQ[", "MR"],
              StyleBox["string", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "test whether all characters in a string are letters "]},
          {Cell[TextData[{
              StyleBox["UpperCaseQ[", "MR"],
              StyleBox["string", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
test whether all characters in a string are upper\
\[Hyphen]case letters \
\>"]},
          {Cell[TextData[{
              StyleBox["LowerCaseQ[", "MR"],
              StyleBox["string", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
test whether all characters in a string are lower\
\[Hyphen]case letters \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.3"],

Cell["Testing characters in a string. ", "Caption",
  CellTags->"S2.8.3"],

Cell["All characters in the string given are letters. ", "MathCaption",
  CellTags->{"S2.8.3", "3.5"}],

Cell[CellGroupData[{

Cell["LetterQ[\"Mixed\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell[TextData[{
  "Not all the letters are upper case, so the result is ",
  StyleBox["False", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.3", "3.6"}],

Cell[CellGroupData[{

Cell["UpperCaseQ[\"Mixed\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToUpperCase[", "MR"],
              StyleBox["string", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "generate a string in which all letters are upper case "]},
          {Cell[TextData[{
              StyleBox["ToLowerCase[", "MR"],
              StyleBox["string", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "generate a string in which all letters are lower case "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.3"],

Cell["Converting between upper and lower case. ", "Caption",
  CellTags->"S2.8.3"],

Cell["This converts all letters to upper case. ", "MathCaption",
  CellTags->{"S2.8.3", "3.7"}],

Cell[CellGroupData[{

Cell["ToUpperCase[\"Mixed Form\"]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \("MIXED FORM"\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CharacterRange[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate a list of all characters from ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.3"],

Cell["Generating ranges of characters. ", "Caption",
  CellTags->"S2.8.3"],

Cell["\<\
This generates a list of lower\[Hyphen]case letters in alphabetical \
order. \
\>", "MathCaption",
  CellTags->{"S2.8.3", "3.8"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"a\", \"h\"]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \({"a", "b", "c", "d", "e", "f", "g", "h"}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell["\<\
Here is a list of upper\[Hyphen]case letters. \
\>", "MathCaption",
  CellTags->{"S2.8.3", "3.9"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"T\", \"Z\"]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \({"T", "U", "V", "W", "X", "Y", "Z"}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell["Here are some digits. ", "MathCaption",
  CellTags->{"S2.8.3", "3.10"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"0\", \"7\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \({"0", "1", "2", "3", "4", "5", "6", "7"}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CharacterRange", "MR"],
  " will usually give meaningful results for any range of characters that \
have a natural ordering. The way ",
  StyleBox["CharacterRange", "MR"],
  " works is by using the character codes that ",
  StyleBox["Mathematica", "TI"],
  " internally assigns to every character. "
}], "Text",
  CellTags->{"S2.8.3", "3.11"}],

Cell[TextData[{
  "This shows the ordering defined by the internal character codes used by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.3", "3.12"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"T\", \"e\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.3"],

Cell[BoxData[
    \({"T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", 
      "b", "c", "d", "e"}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.8.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.4 String Patterns", "Subsection",
  CellTags->{"S2.8.4", "4.1"}],

Cell[TextData[{
  "An important feature of string manipulation functions like ",
  StyleBox["StringReplace", "MR"],
  " is that they handle not only literal strings but also patterns for \
collections of strings. "
}], "Text",
  CellTags->{"S2.8.4", "4.2"}],

Cell[TextData[{
  "This replaces ",
  StyleBox["b", "MR"],
  " or ",
  StyleBox["c", "MR"],
  " by ",
  StyleBox["X", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.3"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abcd abcd\", \"b\" | \"c\" -> \"X\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("aXXd aXXd"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "This replaces any character by ",
  StyleBox["u", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.4"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abcd abcd\", _ -> \"u\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("uuuuuuuuu"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "You can specify patterns for strings by using ",
  StyleBox["string expressions", "TI"],
  " that contain ordinary strings mixed with ",
  StyleBox["Mathematica", "TI"],
  " symbolic pattern objects. "
}], "Text",
  CellTags->{"S2.8.4", "4.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              "  or  ",
              StyleBox["StringExpression[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] ]",
              StyleBox[" ", "TR"]
            }]], Cell["a sequence of strings and pattern objects "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.4"],

Cell["String expressions. ", "Caption",
  CellTags->"S2.8.4"],

Cell[TextData[{
  "Here is a string expression that represents the string ",
  StyleBox["ab", "MR"],
  " followed by any single character. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.6"}],

Cell[CellGroupData[{

Cell["\"ab\" ~~ _", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("ab" ~~ _\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["\<\
This makes a replacement for each occurrence of the string pattern. \
\
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.7"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abc abcb abdc\", \"ab\" ~~ _ -> \"X\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("X Xb Xc"\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringMatchQ[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\"", "MR"],
              " matches ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringFreeQ[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "test whether ",
              StyleBox["\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\"", "MR"],
              " is free of substrings matching ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringCases[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the substrings of ",
              StyleBox["\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\"", "MR"],
              " that match ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringCases[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace each case of ",
              StyleBox["lhs", "TI"],
              " by ",
              StyleBox["rhs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringPosition[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of the positions of substrings that match ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringCount[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "count how many substrings match ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplace[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "replace every substring that matches ",
              StyleBox["lhs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringReplaceList[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give a list of all ways of replacing ",
              StyleBox["lhs", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringSplit[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["patt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split ",
              StyleBox["s", "TI"],
              " at every substring that matches ",
              StyleBox["patt", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringSplit[\"", "MR"],
              StyleBox["s", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["lhs", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["rhs", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "split at ",
              StyleBox["lhs", "TI"],
              ", inserting ",
              StyleBox["rhs", "TI"],
              " in its place "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False, False, False, True, False, True, False}},
  CellTags->"S2.8.4"],

Cell["Functions that support string patterns. ", "Caption",
  CellTags->"S2.8.4"],

Cell["\<\
This gives all cases of the pattern that appear in the string. \
\
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.8"}],

Cell[CellGroupData[{

Cell["StringCases[\"abc abcb abdc\", \"ab\" ~~ _]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"abc", "abc", "abd"}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives each character that appears after an ",
  StyleBox["\"ab\"", "MR"],
  " string. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.9"}],

Cell[CellGroupData[{

Cell["StringCases[\"abc abcb abdc\", \"ab\" ~~ x_ -> x]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"c", "c", "d"}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This gives all pairs of identical characters in the string. ", \
"MathCaption",
  CellTags->{"S2.8.4", "4.10"}],

Cell[CellGroupData[{

Cell["StringCases[\"abbcbccaabbabccaa\", x_ ~~ x_]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"bb", "cc", "aa", "bb", "cc", "aa"}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "You can use all the standard ",
  StyleBox["Mathematica", "TI"],
  " pattern objects in string patterns. Single blanks (",
  StyleBox["_", "MR"],
  ") always stand for single characters. Double blanks (",
  StyleBox["__", "MR"],
  ") stand for sequences of one or more characters. "
}], "Text",
  CellTags->{"S2.8.4", "4.11"}],

Cell[TextData[{
  "Single blank (",
  StyleBox["_", "MR"],
  ") stands for any single character. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.12"}],

Cell[CellGroupData[{

Cell["StringReplace[{\"ab\", \"abc\", \"abcd\"}, \"b\" ~~ _ -> \"X\"]", \
"Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"ab", "aX", "aXd"}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "Double blank (",
  StyleBox["__", "MR"],
  ") stands for any sequence of one or more characters. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.13"}],

Cell[CellGroupData[{

Cell["StringReplace[{\"ab\", \"abc\", \"abcd\"}, \"b\" ~~ __ -> \"X\"]", \
"Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"ab", "aX", "aX"}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "Triple blank (",
  StyleBox["___", "MR"],
  ") stands for any sequence of zero or more characters. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.14"}],

Cell[CellGroupData[{

Cell["StringReplace[{\"ab\", \"abc\", \"abcd\"}, \"b\" ~~ ___ -> \"X\"]", \
"Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"aX", "aX", "aX"}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a literal string of characters "]},
          {Cell[TextData[{
              StyleBox["_", "MR"],
              " "
            }]], Cell["any single character "]},
          {Cell[TextData[{
              StyleBox["__", "MR"],
              " "
            }]], Cell["any sequence of one or more characters "]},
          {Cell[TextData[{
              StyleBox["___", "MR"],
              " "
            }]], Cell["any sequence of zero or more characters "]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              ", ",
              StyleBox["x", "TI"],
              StyleBox["__", "MR"],
              ", ",
              StyleBox["x", "TI"],
              StyleBox["___", "MR"],
              " "
            }]], Cell[TextData[{
              "substrings given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox[":", "MR"],
              StyleBox["pattern", "TI"],
              " "
            }]], Cell[TextData[{
              "pattern given the name ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              StyleBox["..", "MR"],
              " "
            }]], Cell["pattern repeated one or more times "]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              StyleBox["...", "MR"],
              " "
            }]], Cell["pattern repeated zero or more times "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              "  or  ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]], Cell[TextData[{
              "a pattern matching at least one of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["patt",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["patt", "TI"],
              " ",
              StyleBox["/;", "MR"],
              " ",
              StyleBox["cond", "TI"],
              " "
            }]], Cell[TextData[{
              "a pattern for which ",
              StyleBox["cond", "TI"],
              " evaluates to ",
              ButtonBox["True",
                ButtonStyle->"RefGuideLink"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["pattern", "TI"],
              " ",
              StyleBox["?", "MR"],
              " ",
              StyleBox["test", "TI"],
              " "
            }]], Cell[TextData[{
              "a pattern for which ",
              StyleBox["test", "TI"],
              " yields ",
              ButtonBox["True",
                ButtonStyle->"RefGuideLink"],
              " for each character "
            }]]},
          {Cell[TextData[{
              StyleBox["Whitespace", "MR"],
              " "
            }]], Cell["a sequence of whitespace characters "]},
          {Cell[TextData[{
              StyleBox["NumberString", "MR"],
              " "
            }]], Cell["the characters of a number "]},
          {Cell[TextData[{
              StyleBox["charobj", "TI"],
              " "
            }]], Cell[
            "an object representing a character class (see below) "]},
          {Cell[TextData[{
              StyleBox["RegularExpression[\"", "MR"],
              StyleBox["regexp", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["substring matching a regular expression "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.4"],

Cell["Objects in string patterns. ", "Caption",
  CellTags->"S2.8.4"],

Cell["This splits at either a colon or semicolon. ", "MathCaption",
  CellTags->{"S2.8.4", "4.15"}],

Cell[CellGroupData[{

Cell["StringSplit[\"a:b;c:d\", \":\" | \";\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"a", "b", "c", "d"}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "This finds all runs containing only ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.16"}],

Cell[CellGroupData[{

Cell["StringCases[\"aababbcccdbaa\", (\"a\" | \"b\") ..]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"aababb", "baa"}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["Alternatives can be given in lists in string patterns. ", "MathCaption",
  CellTags->{"S2.8.4", "4.17"}],

Cell[CellGroupData[{

Cell["StringCases[\"aababbcccdbaa\", {\"a\", \"b\"} ..]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"aababb", "baa"}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "You can use standard ",
  StyleBox["Mathematica", "TI"],
  " constructs such as ",
  StyleBox["Characters[\"", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\"]", "MR"],
  " and ",
  StyleBox["CharacterRange[\"", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox["\"]", "MR"],
  " to generate lists of alternative characters to use in string patterns. "
}], "Text",
  CellTags->{"S2.8.4", "4.18"}],

Cell["This gives a list of characters. ", "MathCaption",
  CellTags->{"S2.8.4", "4.19"}],

Cell[CellGroupData[{

Cell["Characters[\"aeiou\"]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"a", "e", "i", "o", "u"}\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This replaces the vowel characters. ", "MathCaption",
  CellTags->{"S2.8.4", "4.20"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abcdefghijklm\", Characters[\"aeiou\"]->\"X\"]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("XbcdXfghXjklm"\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "This gives characters in the range ",
  StyleBox["\"A\"", "MR"],
  " through ",
  StyleBox["\"H\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.21"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"A\", \"H\"]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"A", "B", "C", "D", "E", "F", "G", "H"}\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "In addition to allowing explicit lists of characters, ",
  StyleBox["Mathematica", "TI"],
  " provides symbolic specifications for several common classes of possible \
characters in string patterns. "
}], "Text",
  CellTags->{"S2.8.4", "4.22"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "any of the ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "\"",
              StyleBox[" ", "TR"]
            }]]},
          {Cell[TextData[{
              StyleBox["Characters[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "any of the ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "\"",
              StyleBox[" ", "TR"]
            }]]},
          {Cell[TextData[{
              StyleBox["CharacterRange[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "any character in the range ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "\"",
              StyleBox[" to ", "TR"],
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DigitCharacter", "MR"],
              " "
            }]], Cell["digit 0\[Dash]9 "]},
          {Cell[TextData[{
              StyleBox["LetterCharacter", "MR"],
              " "
            }]], Cell["letter "]},
          {Cell[TextData[{
              StyleBox["WhitespaceCharacter", "MR"],
              " "
            }]], Cell["space, newline, tab or other whitespace character "]},
          {Cell[TextData[{
              StyleBox["WordCharacter", "MR"],
              " "
            }]], Cell["letter or digit "]},
          {Cell[TextData[{
              StyleBox["Except[", "MR"],
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "any character except ones matching ",
              StyleBox["p", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.4"],

Cell["Specifications for classes of characters. ", "Caption",
  CellTags->"S2.8.4"],

Cell["This picks out the digit characters in a string. ", "MathCaption",
  CellTags->{"S2.8.4", "4.23"}],

Cell[CellGroupData[{

Cell["StringCases[\"a6;b23c456;\", DigitCharacter]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"6", "2", "3", "4", "5", "6"}\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This picks out all characters except digits. ", "MathCaption",
  CellTags->{"S2.8.4", "4.24"}],

Cell[CellGroupData[{

Cell["StringCases[\"a6;b23c456;\", Except[DigitCharacter]]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"a", ";", "b", "c", ";"}\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This picks out all runs of one or more digits. ", "MathCaption",
  CellTags->{"S2.8.4", "4.25"}],

Cell[CellGroupData[{

Cell["StringCases[\"a6;b23c456\", DigitCharacter..]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"6", "23", "456"}\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["The results are strings. ", "MathCaption",
  CellTags->{"S2.8.4", "4.26"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.8.4"],

Cell["{\"6\", \"23\", \"456\"}", "Output",
  CellLabel->"Out[20]//InputForm= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This converts the strings to numbers. ", "MathCaption",
  CellTags->{"S2.8.4", "4.27"}],

Cell[CellGroupData[{

Cell["ToExpression[%] + 1", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({7, 24, 457}\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["\<\
String patterns are often used as a way to extract structure from \
strings of textual data. Typically this works by having different parts of a \
string pattern match substrings that correspond to different parts of the \
structure. \
\>", "Text",
  CellTags->{"S2.8.4", "4.28"}],

Cell[TextData[{
  "This picks out each ",
  StyleBox["=", "MR"],
  " followed by a number. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.29"}],

Cell[CellGroupData[{

Cell["StringCases[\"a1=6.7, b2=8.87\", \"=\" ~~ NumberString]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"=6.7", "=8.87"}\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This gives the numbers alone. ", "MathCaption",
  CellTags->{"S2.8.4", "4.30"}],

Cell[CellGroupData[{

Cell["StringCases[\"a1=6.7, b2=8.87\", \"=\" ~~ x:NumberString -> x]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"6.7", "8.87"}\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["\<\
This extracts \[OpenCurlyDoubleQuote]variables\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]values\
\[CloseCurlyDoubleQuote] from the string. \
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.31"}],

Cell[CellGroupData[{

Cell["\<\
StringCases[\"a1=6.7, b2=8.87\", v:WordCharacter.. ~~ \"=\" ~~ \
x:NumberString -> {v, x}]\
\>", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({{"a1", "6.7"}, {"b2", "8.87"}}\)], "Output",
  CellLabel->"Out[24]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToExpression", "MR"],
  " converts them to ordinary symbols and numbers. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.32"}],

Cell[CellGroupData[{

Cell["ToExpression[%]^2", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({{a1\^2, 44.89`}, {b2\^2, 78.67689999999999`}}\)], "Output",
  CellLabel->"Out[25]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "In many situations, textual data may contain sequences of spaces, newlines \
or tabs that should be considered \[OpenCurlyDoubleQuote]whitespace\
\[CloseCurlyDoubleQuote], and perhaps ignored. In ",
  StyleBox["Mathematica", "TI"],
  ", the symbol ",
  StyleBox["Whitespace", "MR"],
  " stands for any such sequence. "
}], "Text",
  CellTags->{"S2.8.4", "4.33"}],

Cell["This removes all whitespace from the string. ", "MathCaption",
  CellTags->{"S2.8.4", "4.34"}],

Cell[CellGroupData[{

Cell["StringReplace[\"aa b cc d\", Whitespace -> \"\"]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("aabccd"\)], "Output",
  CellLabel->"Out[26]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This replaces each sequence of spaces by a single comma. ", \
"MathCaption",
  CellTags->{"S2.8.4", "4.35"}],

Cell[CellGroupData[{

Cell["StringReplace[\"aa b cc d\", Whitespace -> \",\"]", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("aa,b,cc,d"\)], "Output",
  CellLabel->"Out[27]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "String patterns normally apply to substrings that appear at any position \
in a given string. Sometimes, however, it is convenient to specify that \
patterns can apply only to substrings at particular positions. You can do \
this by including symbols such as ",
  StyleBox["StartOfString", "MR"],
  " in your string patterns. "
}], "Text",
  CellTags->{"S2.8.4", "4.36"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StartOfString", "MR"],
              " "
            }]], Cell["start of the whole string "]},
          {Cell[TextData[{
              StyleBox["EndOfString", "MR"],
              " "
            }]], Cell["end of the whole string "]},
          {Cell[TextData[{
              StyleBox["StartOfLine", "MR"],
              " "
            }]], Cell["start of a line "]},
          {Cell[TextData[{
              StyleBox["EndOfLine", "MR"],
              " "
            }]], Cell["end of a line "]},
          {Cell[TextData[{
              StyleBox["WordBoundary", "MR"],
              " "
            }]], Cell["boundary between word characters and others "]},
          {Cell[TextData[{
              StyleBox["Except[WordBoundary]", "MR"],
              " "
            }]], Cell["anywhere except a word boundary "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True, False, True, False}},
  CellTags->"S2.8.4"],

Cell["Constructs representing special positions in a string. ", "Caption",
  CellTags->"S2.8.4"],

Cell[TextData[{
  "This replaces ",
  StyleBox["\"a\"", "MR"],
  " wherever it appears in a string. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.37"}],

Cell[CellGroupData[{

Cell["StringReplace[{\"abc\", \"baca\"}, \"a\" -> \"XX\"]", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"XXbc", "bXXcXX"}\)], "Output",
  CellLabel->"Out[28]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "This replaces ",
  StyleBox["\"a\"", "MR"],
  " only when it immediately follows the start of a string. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.38"}],

Cell[CellGroupData[{

Cell["StringReplace[{\"abc\", \"baca\"}, StartOfString ~~ \"a\" -> \"XX\"]", \
"Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"XXbc", "baca"}\)], "Output",
  CellLabel->"Out[29]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "This replaces all occurrences of the substring ",
  StyleBox["\"the\"", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.39"}],

Cell[CellGroupData[{

Cell["StringReplace[\"the others\", \"the\" -> \"XX\"]", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("XX oXXrs"\)], "Output",
  CellLabel->"Out[30]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["\<\
This replaces only occurrences that have a word boundary on both \
sides. \
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.40"}],

Cell[CellGroupData[{

Cell["\<\
StringReplace[\"the others\", WordBoundary ~~ \"the\" ~~ \
WordBoundary -> \"XX\"]\
\>", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("XX others"\)], "Output",
  CellLabel->"Out[31]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "String patterns allow the same kind of ",
  StyleBox["/;", "MR"],
  " and other conditions as ordinary ",
  StyleBox["Mathematica", "TI"],
  " patterns. "
}], "Text",
  CellTags->{"S2.8.4", "4.41"}],

Cell["\<\
This gives cases of unequal successive characters in the string. \
\
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.42"}],

Cell[CellGroupData[{

Cell["StringCases[\"aaabbcaaaabaaa\", x_ ~~ y_ /; x != y]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"ab", "bc", "ab"}\)], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "When you give an object such as ",
  StyleBox["x", "TI"],
  StyleBox["__", "MR"],
  " or ",
  StyleBox["e", "TI"],
  StyleBox["..", "MR"],
  " in a string pattern, ",
  StyleBox["Mathematica", "TI"],
  " normally assumes that you want this to match the longest possible \
sequence of characters. Sometimes, however, you may instead want to match the \
shortest possible sequence of characters. You can specify this using ",
  StyleBox["ShortestMatch[", "MR"],
  StyleBox["p", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.4", "4.43"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["LongestMatch[", "MR"],
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the longest consistent match for ",
              StyleBox["p", "TI"],
              " (default) "
            }]]},
          {Cell[TextData[{
              StyleBox["ShortestMatch[", "MR"],
              StyleBox["p", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the shortest consistent match for ",
              StyleBox["p", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.4"],

Cell["Objects representing longest and shortest matches. ", "Caption",
  CellTags->"S2.8.4"],

Cell["\<\
The string pattern by default matches the longest possible sequence \
of characters. \
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.44"}],

Cell[CellGroupData[{

Cell["StringCases[\"-(a)--(bb)--(c)-\", \"(\" ~~ __ ~~ \")\"]", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"(a)--(bb)--(c)"}\)], "Output",
  CellLabel->"Out[33]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ShortestMatch", "MR"],
  " specifies that instead the shortest possible match should be found. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.45"}],

Cell[CellGroupData[{

Cell["\<\
StringCases[\"-(a)--(bb)--(c)-\", ShortestMatch[\"(\" ~~ __ ~~ \
\")\"]]\
\>", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"(a)", "(bb)", "(c)"}\)], "Output",
  CellLabel->"Out[34]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " by default treats characters such ",
  StyleBox["\"X\"", "MR"],
  " and ",
  StyleBox["\"x\"", "MR"],
  " as distinct. But by setting the option ",
  StyleBox["IgnoreCase", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " in string manipulation operations, you can tell ",
  StyleBox["Mathematica", "TI"],
  " to treat all such upper\[Hyphen] and lower\[Hyphen]case letters as \
equivalent. "
}], "Text",
  CellTags->{"S2.8.4", "4.46"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["IgnoreCase", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], 
            Cell["\<\
treat upper\[Hyphen] and lower\[Hyphen]case letters as \
equivalent \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.4"],

Cell["\<\
Specifying case\[Hyphen]independent string operations. \
\>", \
"Caption",
  CellTags->"S2.8.4"],

Cell[TextData[{
  "This replaces all occurrences of ",
  StyleBox["\"the\"", "MR"],
  ", independent of case. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.47"}],

Cell[CellGroupData[{

Cell["\<\
StringReplace[\"The cat in the hat.\", \"the\" -> \"a\", IgnoreCase \
-> True]\
\>", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \("a cat in a hat."\)], "Output",
  CellLabel->"Out[35]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  "In some string operations, one may have to specify whether to include \
overlaps between substrings. By default ",
  StyleBox["StringCases", "MR"],
  " and ",
  StyleBox["StringCount", "MR"],
  " do not include overlaps, but ",
  StyleBox["StringPosition", "MR"],
  " does. "
}], "Text",
  CellTags->{"S2.8.4", "4.48"}],

Cell["\<\
This picks out pairs of successive characters, by default omitting \
overlaps. \
\>", "MathCaption",
  CellTags->{"S2.8.4", "4.49"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcdefg\", _ ~~ _]", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"ab", "cd", "ef"}\)], "Output",
  CellLabel->"Out[36]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This includes the overlaps. ", "MathCaption",
  CellTags->{"S2.8.4", "4.50"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcdefg\", _ ~~ _, Overlaps -> True]", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"ab", "bc", "cd", "de", "ef", "fg"}\)], "Output",
  CellLabel->"Out[37]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["StringPosition", "MR"],
  " includes overlaps by default. "
}], "MathCaption",
  CellTags->{"S2.8.4", "4.51"}],

Cell[CellGroupData[{

Cell["StringPosition[\"abcdefg\", _ ~~ _]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}}\)], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Overlaps", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["All", "MR"],
              " "
            }]], Cell["include all overlaps "]},
          {Cell[TextData[{
              StyleBox["Overlaps", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell[
            "include at most one overlap beginning at each position "]},
          {Cell[TextData[{
              StyleBox["Overlaps", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["exclude all overlaps "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.4"],

Cell["Options for handling overlaps in strings. ", "Caption",
  CellTags->"S2.8.4"],

Cell["This yields only a single match. ", "MathCaption",
  CellTags->{"S2.8.4", "4.52"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcd\", __, Overlaps -> False]", "Input",
  CellLabel->"In[39]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"abcd"}\)], "Output",
  CellLabel->"Out[39]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This yields a succession of overlapping matches. ", "MathCaption",
  CellTags->{"S2.8.4", "4.53"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcd\", __, Overlaps -> True]", "Input",
  CellLabel->"In[40]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"abcd", "bcd", "cd", "d"}\)], "Output",
  CellLabel->"Out[40]= ",
  CellTags->"S2.8.4"]
}, Open  ]],

Cell["This includes all possible overlapping matches. ", "MathCaption",
  CellTags->{"S2.8.4", "4.54"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcd\", __, Overlaps -> All]", "Input",
  CellLabel->"In[41]:= ",
  CellTags->"S2.8.4"],

Cell[BoxData[
    \({"abcd", "abc", "ab", "a", "bcd", "bc", "b", "cd", "c", 
      "d"}\)], "Output",
  CellLabel->"Out[41]= ",
  CellTags->"S2.8.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.5 Advanced Topic: Regular Expressions", "Subsection",
  CellTags->{"S2.8.5", "5.1"}],

Cell[TextData[{
  "General ",
  StyleBox["Mathematica", "TI"],
  " patterns provide a powerful way to do string manipulation. But \
particularly if you are familiar with specialized string manipulation \
languages, you may sometimes find it convenient to specify string patterns \
using ",
  StyleBox["regular expression", "TI"],
  " notation. You can do this in ",
  StyleBox["Mathematica", "TI"],
  " with ",
  StyleBox["RegularExpression", "MR"],
  " objects.    "
}], "Text",
  CellTags->{"S2.8.5", "5.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["RegularExpression[\"", "MR"],
              StyleBox["regex", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "a regular expression specified by ",
              StyleBox["\"", "MR"],
              StyleBox["regex", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.5"],

Cell[TextData[{
  "Using regular expression notation in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.8.5"],

Cell[TextData[{
  "This replaces all occurrences of ",
  StyleBox["a", "MR"],
  " or ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.3"}],

Cell[CellGroupData[{

Cell["\<\
StringReplace[\"abcd acbd\", RegularExpression[\"[ab]\"] -> \"XX\"]\
\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \("XXXXcd XXcXXd"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "This specifies the same operation using a general ",
  StyleBox["Mathematica", "TI"],
  " string pattern. "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.4"}],

Cell[CellGroupData[{

Cell["StringReplace[\"abcd acbd\", \"a\" | \"b\" -> \"XX\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \("XXXXcd XXcXXd"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell["You can mix regular expressions with general patterns. ", "MathCaption",
  CellTags->{"S2.8.5", "5.5"}],

Cell[CellGroupData[{

Cell["\<\
StringReplace[\"abcd acbd\", RegularExpression[\"[ab]\"] ~~ _ -> \
\"YY\"]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \("YYcd YYYY"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RegularExpression", "MR"],
  " in ",
  StyleBox["Mathematica", "TI"],
  " supports all standard regular expression constructs. "
}], "Text",
  CellTags->{"S2.8.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["c", "TI"],
              " "
            }]], Cell[TextData[{
              "the literal character ",
              StyleBox["c", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox[".", "MR"],
              " "
            }]], Cell["any character except newline "]},
          {Cell[TextData[{
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "any of the characters ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["-", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "any character in the range ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "\[Dash]",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["[^", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "any character except the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["*", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["p", "TI"],
              " repeated zero or more times "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["+", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["p", "TI"],
              " repeated one or more times "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["?", "MR"],
              " "
            }]], Cell[TextData[{
              "zero or one occurrence of ",
              StyleBox["p", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["{", "MR"],
              StyleBox["m", "TI"],
              StyleBox[",", "MR"],
              StyleBox["n", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["p", "TI"],
              " repeated between ",
              StyleBox["m", "TI"],
              " and ",
              StyleBox["n", "TI"],
              " times "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["*?", "MR"],
              ", ",
              StyleBox["p", "TI"],
              StyleBox["+?", "MR"],
              ", ",
              StyleBox["p", "TI"],
              StyleBox["??", "MR"],
              " "
            }]], Cell["the shortest consistent strings that match "]},
          {Cell[TextData[{
              StyleBox["(", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              "strings matching the sequence ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["|", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "strings matching ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " or ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.5"],

Cell[TextData[{
  "Basic constructs in ",
  StyleBox["Mathematica", "SO"],
  " regular expressions. "
}], "Caption",
  CellTags->"S2.8.5"],

Cell["\<\
This finds substrings that match the specified regular expression. \
\
\>", "MathCaption",
  CellTags->{"S2.8.5", "5.7"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcddbbbacbbaa\", RegularExpression[\"(a|bb)+\"]]", \
"Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"a", "bb", "a", "bbaa"}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "This does the same operation with a general ",
  StyleBox["Mathematica", "TI"],
  " string pattern. "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.8"}],

Cell[CellGroupData[{

Cell["StringCases[\"abcddbbbacbbaa\", (\"a\" | \"bb\") ..]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"a", "bb", "a", "bbaa"}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "There is a close correspondence between many regular expression constructs \
and basic general ",
  StyleBox["Mathematica", "TI"],
  " string pattern constructs. "
}], "Text",
  CellTags->{"S2.8.5", "5.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox[".", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["_", "MR"],
              " (strictly ",
              StyleBox["Except[\"\[Backslash]", "MR"],
              StyleBox["n", "TI"],
              StyleBox["\"]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Characters[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["-", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["CharacterRange[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["[^", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Except[Characters[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox["\"]]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["*", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["...", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["+", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["..", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["?", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["|\"\"", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["p", "TI"],
              StyleBox["*?", "MR"],
              ", ",
              StyleBox["p", "TI"],
              StyleBox["+?", "MR"],
              ", ",
              StyleBox["p", "TI"],
              StyleBox["??", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["ShortestMatch[", "MR"],
              StyleBox["p", "TI"],
              StyleBox["...]", "MR"],
              ", ... "
            }]]},
          {Cell[TextData[{
              StyleBox["(", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              "\[Ellipsis]",
              " ",
              StyleBox[")", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["~~", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[")", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["|", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["|", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["p",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.5"],

Cell["\<\
Correspondences between regular expression and general string \
pattern constructs. \
\>", "Caption",
  CellTags->"S2.8.5"],

Cell[TextData[{
  "Just as in general ",
  StyleBox["Mathematica", "TI"],
  " string patterns, there are special notations in regular expressions for \
various common classes of characters. Note that you need to use double \
backslashes (\[Backslash]\[Backslash]) to enter most of these notations in ",
  StyleBox["Mathematica", "TI"],
  " regular expression strings. "
}], "Text",
  CellTags->{"S2.8.5", "5.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["d", "MR"],
              " "
            }]], Cell[TextData[{
              "digit 0\[Dash]9 (",
              StyleBox["DigitCharacter", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["D", "MR"],
              " "
            }]], Cell[TextData[{
              "non\[Hyphen]digit (",
              StyleBox["Except[DigitCharacter]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["s", "MR"],
              " "
            }]], Cell[TextData[{
              "space, newline, tab or other whitespace character (",
              StyleBox["WhitespaceCharacter", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["S", "MR"],
              " "
            }]], Cell[TextData[{
              "non\[Hyphen]whitespace character (",
              StyleBox["Except[WhitespaceCharacter]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["w", "MR"],
              " "
            }]], Cell[TextData[{
              "word character (letter, digit or ",
              StyleBox["_", "MR"],
              ") (",
              StyleBox["WordCharacter", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["W", "MR"],
              " "
            }]], Cell[TextData[{
              "non\[Hyphen]word character (",
              StyleBox["Except[WordCharacter]", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["[[:", "MR"],
              StyleBox["class", "TI"],
              StyleBox[":]]", "MR"],
              " "
            }]], Cell["characters in a named class "]},
          {Cell[TextData[{
              StyleBox["[^[:", "MR"],
              StyleBox["class", "TI"],
              StyleBox[":]]", "MR"],
              " "
            }]], Cell["characters not in a named class "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.5"],

Cell["Regular expression notations for classes of characters. ", "Caption",
  CellTags->"S2.8.5"],

Cell[TextData[{
  "This gives each occurrence of ",
  StyleBox["a", "MR"],
  " followed by digit characters. "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.11"}],

Cell[CellGroupData[{

Cell["StringCases[\"a10b6a77a3a#\", RegularExpression[\"a\\\\d+\"]]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"a10", "a77", "a3"}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "Here is the same thing done with a general ",
  StyleBox["Mathematica", "TI"],
  " string pattern. "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.12"}],

Cell[CellGroupData[{

Cell["StringCases[\"a10b6a77a3a#\", \"a\" ~~ DigitCharacter ..]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"a10", "a77", "a3"}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports the standard POSIX character classes ",
  StyleBox["alnum", "MR"],
  ", ",
  StyleBox["alpha", "MR"],
  ", ",
  StyleBox["ascii", "MR"],
  ", ",
  StyleBox["blank", "MR"],
  ", ",
  StyleBox["cntrl", "MR"],
  ", ",
  StyleBox["digit", "MR"],
  ", ",
  StyleBox["graph", "MR"],
  ", ",
  StyleBox["lower", "MR"],
  ", ",
  StyleBox["print", "MR"],
  ", ",
  StyleBox["punct", "MR"],
  ", ",
  StyleBox["space", "MR"],
  ", ",
  StyleBox["upper", "MR"],
  ", ",
  StyleBox["word", "MR"],
  ", ",
  StyleBox["xdigit", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.5", "5.13"}],

Cell["\<\
This finds runs of upper\[Hyphen]case letters. \
\>", "MathCaption",
  CellTags->{"S2.8.5", "5.14"}],

Cell[CellGroupData[{

Cell["\<\
StringCases[\"AaBBccDDeefG\", \
RegularExpression[\"[[:upper:]]+\"]]\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"A", "BB", "DD", "G"}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell["This does the same thing. ", "MathCaption",
  CellTags->{"S2.8.5", "5.15"}],

Cell[CellGroupData[{

Cell["StringCases[\"AaBBccDDeefG\", CharacterRange[\"A\", \"Z\"] ..]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"A", "BB", "DD", "G"}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["^", "MR"],
              " "
            }]], Cell[TextData[{
              "the beginning of the string (",
              StyleBox["StartOfString", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["$", "MR"],
              " "
            }]], Cell[TextData[{
              "the end of the string (",
              StyleBox["EndOfString", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["b", "MR"],
              " "
            }]], Cell[TextData[{
              "word boundary (",
              StyleBox["WordBoundary", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              "\[Backslash]\[Backslash]",
              StyleBox["B", "MR"],
              " "
            }]], Cell[TextData[{
              "anywhere except a word boundary (",
              StyleBox["Except[WordBoundary]", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.5"],

Cell["Regular expression notations for positions in strings. ", "Caption",
  CellTags->"S2.8.5"],

Cell[TextData[{
  "In general ",
  StyleBox["Mathematica", "TI"],
  " patterns, you can use constructs like ",
  StyleBox["x_", "MR"],
  " and ",
  StyleBox["x", "TI"],
  StyleBox[":", "MR"],
  StyleBox["patt", "TI"],
  " to give arbitrary names to objects that are matched. In regular \
expressions, there is a way to do something somewhat like this using \
numbering: the ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " parenthesized pattern object ",
  StyleBox["(", "MR"],
  StyleBox["p", "TI"],
  StyleBox[")", "MR"],
  " in a regular expression can be referred to as \[Backslash]\[Backslash]",
  StyleBox["n", "TI"],
  " within the body of the pattern, and ",
  StyleBox["$", "MR"],
  StyleBox["n", "TI"],
  " outside it. "
}], "Text",
  CellTags->{"S2.8.5", "5.16"}],

Cell["This finds pairs of identical letters that appear together. ", \
"MathCaption",
  CellTags->{"S2.8.5", "5.17"}],

Cell[CellGroupData[{

Cell["StringCases[\"aaabcccabbaacba\", RegularExpression[\"(.)\\\\1\"]]", \
"Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"aa", "cc", "bb", "aa"}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "This does the same thing using a general ",
  StyleBox["Mathematica", "TI"],
  " string pattern. "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.18"}],

Cell[CellGroupData[{

Cell["StringCases[\"aaabcccabbaacba\", x_ ~~ x_]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"aa", "cc", "bb", "aa"}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["$1", "MR"],
  " refers to the letter matched by ",
  StyleBox["(.)", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.19"}],

Cell[CellGroupData[{

Cell["\<\
StringCases[\"aaabcccabbaacba\", RegularExpression[\"(.)\\\\1\"] -> \
\"$1\"]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"a", "c", "b", "a"}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.8.5"]
}, Open  ]],

Cell[TextData[{
  "Here is the ",
  StyleBox["Mathematica", "TI"],
  " pattern version. "
}], "MathCaption",
  CellTags->{"S2.8.5", "5.20"}],

Cell[CellGroupData[{

Cell["StringCases[\"aaabcccabbaacba\", x_ ~~ x_ -> x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.8.5"],

Cell[BoxData[
    \({"a", "c", "b", "a"}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.8.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.6 Special Characters", "Subsection",
  CellTags->{"S2.8.6", "6.1"}],

Cell[TextData[{
  "In addition to the ordinary characters that appear on a standard keyboard, \
you can include in ",
  StyleBox["Mathematica", "TI"],
  " strings any of the special characters that are supported by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.8.6", "6.2"}],

Cell["Here is a string containing special characters. ", "MathCaption",
  CellTags->{"S2.8.6", "6.3"}],

Cell[CellGroupData[{

Cell["\"\[Alpha]\[CirclePlus]\[Beta]\[CirclePlus]\[Ellipsis]\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \("\[Alpha]\[CirclePlus]\[Beta]\[CirclePlus]\[Ellipsis]"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell["You can manipulate this string just as you would any other. ", \
"MathCaption",
  CellTags->{"S2.8.6", "6.4"}],

Cell[CellGroupData[{

Cell["\<\
StringReplace[%, \"\[CirclePlus]\" -> \" \[CircleDot]\[CircleDot] \
\"]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \("\[Alpha] \[CircleDot]\[CircleDot] \[Beta] \[CircleDot]\[CircleDot] \
\[Ellipsis]"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell["Here is the list of the characters in the string. ", "MathCaption",
  CellTags->{"S2.8.6", "6.5"}],

Cell[CellGroupData[{

Cell["Characters[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \({"\[Alpha]", " ", "\[CircleDot]", "\[CircleDot]", " ", "\[Beta]", " ", 
      "\[CircleDot]", "\[CircleDot]", " ", "\[Ellipsis]"}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[TextData[{
  "In a ",
  StyleBox["Mathematica", "TI"],
  " notebook, a special character such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  " can always be displayed directly. But if you use a text\[Hyphen]based \
interface, then typically the only characters that can readily be displayed \
are the ones that appear on your keyboard. "
}], "Text",
  CellTags->{"S2.8.6", "6.6"}],

Cell[TextData[{
  "As a result, what ",
  StyleBox["Mathematica", "TI"],
  " does in such situations is to try to approximate special characters by \
similar\[Hyphen]looking sequences of ordinary characters. And when this is \
not practical, ",
  StyleBox["Mathematica", "TI"],
  " just gives the full name of the special character. "
}], "Text",
  CellTags->{"S2.8.6", "6.7"}],

Cell[TextData[{
  "In a ",
  StyleBox["Mathematica", "TI"],
  " notebook using ",
  StyleBox["StandardForm", "MR"],
  ", special characters can be displayed directly. "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.8"}],

Cell[CellGroupData[{

Cell["\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\"", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \("Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+"\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["OutputForm", "MR"],
  ", however, the special characters are approximated when possible by \
sequences of ordinary ones. "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.9"}],

Cell[CellGroupData[{

Cell["% // OutputForm", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.6"],

Cell["\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\"", "Output",
  CellLabel->"Out[5]//OutputForm= ",
  CellTags->"S2.8.6"],

Cell[OutputFormData["\<\
Lam\[EAcute] \[LongRightArrow] \
\[Alpha]\[Beta]+\
\>"], "Output",
  CellLabel->"Out[5]//OutputForm= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " always uses full names for special characters in ",
  StyleBox["InputForm", "MR"],
  ". This means that when special characters are written out to files or \
external programs, they are by default represented purely as sequences of \
ordinary characters. "
}], "Text",
  CellTags->{"S2.8.6", "6.10"}],

Cell[TextData[{
  "This uniform representation is crucial in allowing special characters in \
",
  StyleBox["Mathematica", "TI"],
  " to be used in a way that does not depend on the details of particular \
computer systems. "
}], "Text",
  CellTags->{"S2.8.6", "6.11"}],

Cell[TextData[{
  "In ",
  StyleBox["InputForm", "MR"],
  " the full names of all special characters are always written out \
explicitly. "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.12"}],

Cell[CellGroupData[{

Cell["\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\" // InputForm", \
"Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.6"],

Cell["\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\"", "Output",
  CellLabel->"Out[6]//InputForm= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["a", "TI"],
              " "
            }]], Cell["a literal character "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[", "MR"],
              StyleBox["Name", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a character specified using its full name "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "a ",
              StyleBox["\"", "MR"],
              " to be included in a string "
            }]]},
          {Cell["\[Backslash]\[Backslash] "], 
            Cell["\<\
a \[Backslash] to be included in a string \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.6"],

Cell["Ways to enter characters in a string. ", "Caption",
  CellTags->"S2.8.6"],

Cell[TextData[{
  "You have to use \[Backslash] to \[OpenCurlyDoubleQuote]escape\
\[CloseCurlyDoubleQuote] any ",
  StyleBox["\"", "MR"],
  " or \[Backslash] characters in strings that you enter. "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.13"}],

Cell[CellGroupData[{

Cell["\"Strings can contain \\\"quotes\\\" and \\\\ characters.\"", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \("Strings can contain \"quotes\" and \\ characters."\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[TextData[{
  "\[Backslash]\[Backslash] produces a literal \[Backslash] rather than \
forming part of the specification of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.14"}],

Cell[CellGroupData[{

Cell["\"\\\\[Alpha] is \\[Alpha].\"", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \("\\[Alpha] is \[Alpha]."\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell["\<\
This breaks the string into a list of individual characters. \
\>", \
"MathCaption",
  CellTags->{"S2.8.6", "6.15"}],

Cell[CellGroupData[{

Cell["Characters[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \({"\\", "[", "A", "l", "p", "h", "a", "]", " ", "i", "s", " ", 
      "\[Alpha]", "."}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[TextData[{
  "This creates a list of the characters in the full name of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.16"}],

Cell[CellGroupData[{

Cell["\<\
Characters[ ToString[FullForm[\"\[Alpha]\"]] ]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \({"\"", "\\", "[", "A", "l", "p", "h", "a", "]", "\""}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.8.6"]
}, Open  ]],

Cell[TextData[{
  "And this produces a string consisting of an actual ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  " from its full name. "
}], "MathCaption",
  CellTags->{"S2.8.6", "6.17"}],

Cell[CellGroupData[{

Cell["ToExpression[ \"\\\"\\\\[\" <> \"Alpha\" <> \"]\\\"\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.6"],

Cell[BoxData[
    \("\[Alpha]"\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.8.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.7 Advanced Topic: Newlines and Tabs in Strings", "Subsection",
  CellTags->{"S2.8.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["n", "MR"],
              " "
            }]], Cell["a newline (line feed) to be included in a string "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["t", "MR"],
              " "
            }]], Cell["a tab to be included in a string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.7"],

Cell["Explicit representations of newlines and tabs in strings. ", "Caption",
  CellTags->"S2.8.7"],

Cell["This prints on two lines. ", "MathCaption",
  CellTags->{"S2.8.7", "7.2"}],

Cell[CellGroupData[{

Cell["\"First line.\\nSecond line.\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.7"],

Cell[BoxData[
    \("First line.\nSecond line."\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["InputForm", "MR"],
  " there is an explicit \[Backslash]",
  StyleBox["n", "MR"],
  " to represent the newline. "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.3"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.7"],

Cell["\"First line.\\nSecond line.\"", "Output",
  CellLabel->"Out[2]//InputForm= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "When you enter a long string in ",
  StyleBox["Mathematica", "TI"],
  ", it is often convenient to break your input across several lines. ",
  StyleBox["Mathematica", "TI"],
  " will by default ignore such breaks, so that if you subsequently output \
the string, it can then be broken in whatever way is appropriate. "
}], "Text",
  CellTags->{"S2.8.7", "7.4"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " ignores the line break and any tabs that follow it. "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.5"}],

Cell[CellGroupData[{

Cell["\"A string on two lines.\"", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.7"],

Cell[BoxData[
    \("A string on two lines."\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell["There is no newline in the string. ", "MathCaption",
  CellTags->{"S2.8.7", "7.6"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.7"],

Cell["\"A string on two lines.\"", "Output",
  CellLabel->"Out[4]//InputForm= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "line breaks in ",
              StyleBox["text", "TI"],
              " are ignored "
            }]]},
          {Cell[TextData[{
              StyleBox["\"\[Backslash]<", "MR"],
              StyleBox["text", "TI"],
              "\[Backslash]",
              StyleBox[">\"", "MR"],
              " "
            }]], Cell[TextData[{
              "line breaks in ",
              StyleBox["text", "TI"],
              " are stored explicitly as \[Backslash]",
              StyleBox["n", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.7"],

Cell["Input forms for strings. ", "Caption",
  CellTags->"S2.8.7"],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica", "TI"],
  " keeps the newline. "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.7"}],

Cell[CellGroupData[{

Cell["\"\\<A string on two lines.\\>\"", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.7"],

Cell[BoxData[
    \("A string on\ntwo lines."\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["InputForm", "MR"],
  ", the newline is shown as an explicit \[Backslash]",
  StyleBox["n", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.8"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.7"],

Cell["\"A string on\\ntwo lines.\"", "Output",
  CellLabel->"Out[6]//InputForm= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "You should realize that even though it is possible to achieve some \
formatting of ",
  StyleBox["Mathematica", "TI"],
  " output by creating strings which contain raw tabs and newlines, this is \
rarely a good idea. Typically a much better approach is to use the higher\
\[Hyphen]level ",
  StyleBox["Mathematica", "TI"],
  " formatting primitives to be discussed in the next two sections. These \
primitives will always yield consistent output, independent of such issues as \
the positions of tab settings on a particular device. "
}], "Text",
  CellTags->{"S2.8.7", "7.9"}],

Cell["\<\
In strings with newlines, text is always aligned on the left. \
\
\>", "MathCaption",
  CellTags->{"S2.8.7", "7.10"}],

Cell[CellGroupData[{

Cell["{\"Here is\\na string\\non several lines.\", \"Here is\\nanother\"}", \
"Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.7"],

Cell[BoxData[
    \({"Here is\na string\non several lines.", 
      "Here is\nanother"}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["ColumnForm", "MR"],
  " formatting primitive gives more control. Here text is aligned on the \
right. "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.11"}],

Cell[CellGroupData[{

Cell["ColumnForm[{\"First line\", \"Second\", \"Third\"}, Right]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.7"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"First line\"\>"},
          {"\<\"Second\"\>"},
          {"\<\"Third\"\>"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Right}],
      ColumnForm[ {"First line", "Second", "Third"}, Right],
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell["And here the text is centered. ", "MathCaption",
  CellTags->{"S2.8.7", "7.12"}],

Cell[CellGroupData[{

Cell["ColumnForm[{\"First line\", \"Second\", \"Third\"}, Center]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.7"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"First line\"\>"},
          {"\<\"Second\"\>"},
          {"\<\"Third\"\>"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Center}],
      ColumnForm[ {"First line", "Second", "Third"}, Center],
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "Within ",
  StyleBox["Mathematica", "TI"],
  " you can use formatting primitives to avoid raw tabs and newlines. But if \
you intend to send your output in textual form to external programs, then \
these programs will often expect to get raw tabs and newlines. "
}], "Text",
  CellTags->{"S2.8.7", "7.13"}],

Cell[TextData[{
  "Note that you must either use ",
  StyleBox["WriteString", "MR"],
  " or give your output in ",
  StyleBox["OutputForm", "MR"],
  " in order for the raw tabs and newlines to show up. In ",
  StyleBox["InputForm", "MR"],
  ", they will just be given as \[Backslash]",
  StyleBox["t", "MR"],
  " and \[Backslash]",
  StyleBox["n", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.8.7", "7.14"}],

Cell["This outputs a string to a file. ", "MathCaption",
  CellTags->{"S2.8.7", "7.15"}],

Cell["\"First line.\\nSecond line.\" >> test", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.7"],

Cell[TextData[{
  "Here are the contents of the file. By default, ",
  StyleBox[">>", "MR"],
  " generates output in ",
  StyleBox["InputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.16"}],

Cell[CellGroupData[{

Cell["!!test", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.7"],

Cell["\"First line.\\nSecond line.\"", "Print",
  CellTags->"S2.8.7"]
}, Open  ]],

Cell[TextData[{
  "This explicitly tells ",
  StyleBox["Mathematica", "TI"],
  " to use ",
  StyleBox["OutputForm", "MR"],
  " for the output. "
}], "MathCaption",
  CellTags->{"S2.8.7", "7.17"}],

Cell["OutputForm[\"First line.\\nSecond line.\"] >> test", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.8.7"],

Cell["Now there is a raw newline in the file. ", "MathCaption",
  CellTags->{"S2.8.7", "7.18"}],

Cell[CellGroupData[{

Cell["!!test", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.8.7"],

Cell["\<\
First line.
Second line.\
\>", "Print",
  CellTags->"S2.8.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.8 Advanced Topic: Character Codes", "Subsection",
  CellTags->{"S2.8.8", "8.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToCharacterCode[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
give a list of the character codes for the characters \
in a string \
\>"]},
          {Cell[TextData[{
              StyleBox["FromCharacterCode[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["construct a character from its character code "]},
          {Cell[TextData[{
              StyleBox["FromCharacterCode[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], 
            Cell["\<\
construct a string of characters from a list of \
character codes \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.8"],

Cell["Converting to and from character codes. ", "Caption",
  CellTags->"S2.8.8"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " assigns every character that can appear in a string a unique ",
  StyleBox["character code", "TI"],
  ". This code is used internally as a way to represent the character. "
}], "Text",
  CellTags->{"S2.8.8", "8.2"}],

Cell["\<\
This gives the character codes for the characters in the string. \
\
\>", "MathCaption",
  CellTags->{"S2.8.8", "8.3"}],

Cell[CellGroupData[{

Cell["ToCharacterCode[\"ABCD abcd\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \({65, 66, 67, 68, 32, 97, 98, 99, 100}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FromCharacterCode", "MR"],
  " reconstructs the original string. "
}], "MathCaption",
  CellTags->{"S2.8.8", "8.4"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("ABCD abcd"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell["Special characters also have character codes. ", "MathCaption",
  CellTags->{"S2.8.8", "8.5"}],

Cell[CellGroupData[{

Cell["ToCharacterCode[\"\[Alpha]\[CirclePlus]\[CapitalGamma]\[CircleMinus]\
\[EmptySet]\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \({945, 8853, 915, 8854, 8709}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["CharacterRange[\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["c",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
generate a list of characters with successive character \
codes \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.8"],

Cell["Generating sequences of characters. ", "Caption",
  CellTags->"S2.8.8"],

Cell["This gives part of the English alphabet. ", "MathCaption",
  CellTags->{"S2.8.8", "8.6"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"a\", \"k\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \({"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k"}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell["Here is the Greek alphabet. ", "MathCaption",
  CellTags->{"S2.8.8", "8.7"}],

Cell[CellGroupData[{

Cell["CharacterRange[\"\[Alpha]\", \"\[Omega]\"]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \({"\[Alpha]", "\[Beta]", "\[Gamma]", "\[Delta]", "\[CurlyEpsilon]", 
      "\[Zeta]", "\[Eta]", "\[Theta]", "\[Iota]", "\[Kappa]", "\[Lambda]", 
      "\[Mu]", "\[Nu]", "\[Xi]", "\[Omicron]", "\[Pi]", "\[Rho]", 
      "\[FinalSigma]", "\[Sigma]", "\[Tau]", "\[Upsilon]", "\[CurlyPhi]", 
      "\[Chi]", "\[Psi]", "\[Omega]"}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " assigns names such as \[Backslash]",
  StyleBox["[Alpha]", "MR"],
  " to a large number of special characters. This means that you can always \
refer to such characters just by giving their names, without ever having to \
know their character codes. "
}], "Text",
  CellTags->{"S2.8.8", "8.8"}],

Cell["\<\
This generates a string of special characters from their character \
codes. \
\>", "MathCaption",
  CellTags->{"S2.8.8", "8.9"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[{8706, 8709, 8711, 8712}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("\[PartialD]\[EmptySet]\[Del]\[Element]"\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell["\<\
You can always refer to these characters by their names, without \
knowing their character codes. \
\>", "MathCaption",
  CellTags->{"S2.8.8", "8.10"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.8"],

Cell["\"\[PartialD]\[EmptySet]\[Del]\[Element]\"", "Output",
  CellLabel->"Out[7]//InputForm= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " has names for all the common characters that are used in mathematical \
notation and in standard European languages. But for a language such as \
Japanese, there are more than 3,000 additional characters, and ",
  StyleBox["Mathematica", "TI"],
  " does not assign an explicit name to each of them. Instead, it refers to \
such characters by standardized character codes. "
}], "Text",
  CellTags->{"S2.8.8", "8.11"}],

Cell["Here is a string containing Japanese characters. ", "MathCaption",
  CellTags->{"S2.8.8", "8.12"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`"\<\:6570\:5b66    \>"\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("\:6570\:5b66    "\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["InputForm", "MR"],
  ", these characters are referred to by standardized character codes. The \
character codes are given in hexadecimal. "
}], "MathCaption",
  CellTags->{"S2.8.8", "8.13"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.8"],

Cell["\"\:6570\:5b66\"", "Output",
  CellLabel->"Out[9]//InputForm= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  "The notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " is typically set up so that when you enter a character in a particular \
font, ",
  StyleBox["Mathematica", "TI"],
  " will automatically work out the character code for that character. "
}], "Text",
  CellTags->{"S2.8.8", "8.14"}],

Cell["\<\
Sometimes, however, you may find it convenient to be able to enter \
characters directly using character codes. \
\>", "Text",
  CellTags->{"S2.8.8", "8.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["0", "MR"],
              " "
            }]], Cell["null byte (code 0) "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["nnn", "TI"],
              " "
            }]], Cell[TextData[{
              "a character with octal code ",
              StyleBox["nnn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox[".", "MR"],
              StyleBox["nn", "TI"],
              " "
            }]], Cell[TextData[{
              "a character with hexadecimal code ",
              StyleBox["nn", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox[":", "MR"],
              StyleBox["nnnn", "TI"],
              " "
            }]], Cell[TextData[{
              "a character with hexadecimal code ",
              StyleBox["nnnn", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.8"],

Cell["\<\
Ways to enter characters directly in terms of character codes. \
\
\>", "Caption",
  CellTags->"S2.8.8"],

Cell[TextData[{
  "For characters with character codes below 256, you can use \[Backslash]",
  StyleBox["nnn", "TI"],
  " or \[Backslash]",
  StyleBox[".", "MR"],
  StyleBox["nn", "TI"],
  ". For characters with character codes above 256, you must use \
\[Backslash]",
  StyleBox[":", "MR"],
  StyleBox["nnnn", "TI"],
  ". Note that in all cases you must give a fixed number of octal or \
hexadecimal digits, padding with leading ",
  StyleBox["0", "MR"],
  "s if necessary. "
}], "Text",
  CellTags->{"S2.8.8", "8.16"}],

Cell["\<\
This gives character codes in hexadecimal for a few characters. \
\
\>", "MathCaption",
  CellTags->{"S2.8.8", "8.17"}],

Cell[CellGroupData[{

Cell["\<\
BaseForm[ToCharacterCode[\"A\[AGrave]\[Alpha]\[Aleph]\"], 16]\
\>", \
"Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("41"\_"16"\),
            65,
            Editable->False], ",", 
          InterpretationBox[\("e0"\_"16"\),
            224,
            Editable->False], ",", 
          InterpretationBox[\("3b1"\_"16"\),
            945,
            Editable->False], ",", 
          InterpretationBox[\("2135"\_"16"\),
            8501,
            Editable->False]}], "}"}],
      (BaseForm[ #, 16]&)]], "Output",
  CellLabel->"Out[10]//BaseForm= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  "This enters the characters using their character codes. Note the leading \
",
  StyleBox["0", "MR"],
  " inserted in the character code for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.8", "8.18"}],

Cell[CellGroupData[{

Cell["\"\\.41\\.e0\\:03b1\\:2135\"", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("A\[AGrave]\[Alpha]\[Aleph]"\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell[TextData[{
  "In assigning codes to characters, ",
  StyleBox["Mathematica", "TI"],
  " follows three compatible standards: ASCII, ISO Latin\[Hyphen]1, and \
Unicode. ASCII covers the characters on a normal American English keyboard. \
ISO Latin\[Hyphen]1 covers characters in many European languages. Unicode is \
a more general standard which defines character codes for several tens of \
thousands of characters used in languages and notations around the world. "
}], "Text",
  CellTags->{"S2.8.8", "8.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "0 \[Dash] 127 (\[Backslash]",
              StyleBox["000", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["177", "MR"],
              ") "
            }]], Cell["ASCII characters "]},
          {Cell[TextData[{
              "1 \[Dash] 31 (\[Backslash]",
              StyleBox["001", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["037", "MR"],
              ") "
            }]], Cell["ASCII control characters "]},
          {Cell[TextData[{
              "32 \[Dash] 126 (\[Backslash]",
              StyleBox["040", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["176", "MR"],
              ") "
            }]], Cell["printable ASCII characters "]},
          {Cell[TextData[{
              "97 \[Dash] 122 (\[Backslash]",
              StyleBox["141", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["172", "MR"],
              ") "
            }]], Cell["lower\[Hyphen]case English letters "]},
          {Cell[TextData[{
              "129 \[Dash] 255 (\[Backslash]",
              StyleBox["201", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["377", "MR"],
              ") "
            }]], Cell["ISO Latin\[Hyphen]1 characters "]},
          {Cell[TextData[{
              "192 \[Dash] 255 (\[Backslash]",
              StyleBox["240", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox["377", "MR"],
              ") "
            }]], Cell["letters in European languages "]},
          {Cell[TextData[{
              "0 \[Dash] 59391 (\[Backslash]",
              StyleBox[":0000", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":e7ff", "MR"],
              ") "
            }]], Cell["Unicode standard public characters "]},
          {Cell[TextData[{
              "913 \[Dash] 1009 (\[Backslash]",
              StyleBox[":0391", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":03f1", "MR"],
              ") "
            }]], Cell["Greek letters "]},
          {Cell[TextData[{
              "12288 \[Dash] 35839 (\[Backslash]",
              StyleBox[":3000", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":8bff", "MR"],
              ") "
            }]], Cell["Chinese, Japanese and Korean characters "]},
          {Cell[TextData[{
              "8450 \[Dash] 8504 (\[Backslash]",
              StyleBox[":2102", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":2138", "MR"],
              ") "
            }]], Cell["modified letters used in mathematical notation "]},
          {Cell[TextData[{
              "8592 \[Dash] 8677 (\[Backslash]",
              StyleBox[":2190", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":21e5", "MR"],
              ") "
            }]], Cell["arrows "]},
          {Cell[TextData[{
              "8704 \[Dash] 8945 (\[Backslash]",
              StyleBox[":2200", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":22f1", "MR"],
              ") "
            }]], Cell["mathematical symbols and operators "]},
          {Cell[TextData[{
              "64256 \[Dash] 64300 (\[Backslash]",
              StyleBox[":fb00", "MR"],
              " \[Dash] \[Backslash]",
              StyleBox[":fb2c", "MR"],
              ") "
            }]], Cell[TextData[{
              "Unicode private characters defined specially by ",
              StyleBox["Mathematica", "TI"]
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, False, False, True, False, True, False, False, False, False, False,
       True}},
  CellTags->"S2.8.8"],

Cell[TextData[{
  "A few ranges of character codes used by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.8.8"],

Cell["Here are all the printable ASCII characters. ", "MathCaption",
  CellTags->{"S2.8.8", "8.20"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[Range[32, 126]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`\
abcdefghijklmnopqrstuvwxyz{|}~"\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell["\<\
Here are some ISO Latin\[Hyphen]1 letters. \
\>", "MathCaption",
  CellTags->{"S2.8.8", "8.21"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[Range[192, 255]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("\[CapitalAGrave]\[CapitalAAcute]\[CapitalAHat]\[CapitalATilde]\
\[CapitalADoubleDot]\[CapitalARing]\[CapitalAE]\[CapitalCCedilla]\
\[CapitalEGrave]\[CapitalEAcute]\[CapitalEHat]\[CapitalEDoubleDot]\
\[CapitalIGrave]\[CapitalIAcute]\[CapitalIHat]\[CapitalIDoubleDot]\
\[CapitalEth]\[CapitalNTilde]\[CapitalOGrave]\[CapitalOAcute]\[CapitalOHat]\
\[CapitalOTilde]\[CapitalODoubleDot]\[Times]\[CapitalOSlash]\[CapitalUGrave]\
\[CapitalUAcute]\[CapitalUHat]\[CapitalUDoubleDot]\[CapitalYAcute]\
\[CapitalThorn]\[SZ]\[AGrave]\[AAcute]\[AHat]\[ATilde]\[ADoubleDot]\[ARing]\
\[AE]\[CCedilla]\[EGrave]\[EAcute]\[EHat]\[EDoubleDot]\[IGrave]\[IAcute]\
\[IHat]\[IDoubleDot]\[Eth]\[NTilde]\[OGrave]\[OAcute]\[OHat]\[OTilde]\
\[ODoubleDot]\[Divide]\[OSlash]\[UGrave]\[UAcute]\[UHat]\[UDoubleDot]\[YAcute]\
\[Thorn]\[YDoubleDot]"\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell["\<\
Here are some special characters used in mathematical notation. The \
black blobs correspond to characters not available in the current font. \
\
\>", "MathCaption",
  CellTags->{"S2.8.8", "8.22"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[Range[8704, 8750]]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("\[ForAll]\:2201\[PartialD]\[Exists]\[NotExists]\[EmptySet]\:2206\[Del]\
\[Element]\[NotElement]\:220a\[ReverseElement]\[NotReverseElement]\[SuchThat]\
\:220e\[Product]\[Coproduct]\[Sum]\:2212\[MinusPlus]\:2214\:2215\[Backslash]\
\:2217\[SmallCircle]\:2219\[Sqrt]\:221b\:221c\[Proportional]\[Infinity]\
\[RightAngle]\[Angle]\[MeasuredAngle]\[SphericalAngle]\[VerticalBar]\
\[NotVerticalBar]\[DoubleVerticalBar]\[NotDoubleVerticalBar]\[And]\[Or]\:2229\
\:222a\[Integral]\:222c\:222d\[ContourIntegral]"\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.8.8"]
}, Open  ]],

Cell["Here are a few Japanese characters. ", "MathCaption",
  CellTags->{"S2.8.8", "8.23"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[Range[30000, 30030]]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.8.8"],

Cell[BoxData[
    \("\:7530\:7531\:7532\:7533\:7534\:7535\:7536\:7537\:7538\:7539\:753a\
\:753b\:753c\:753d\:753e\:753f\:7540\:7541\:7542\:7543\:7544\:7545\:7546\:7547\
\:7548\:7549\:754a\:754b\:754c\:754d\:754e"\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.8.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.8.9 Advanced Topic: Raw Character Encodings", "Subsection",
  CellTags->{"S2.8.9", "9.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " always allows you to refer to special characters by using names such as \
\[Backslash]",
  StyleBox["[Alpha]", "MR"],
  " or explicit hexadecimal codes such as \[Backslash]",
  StyleBox[":03b1", "MR"],
  ". And when ",
  StyleBox["Mathematica", "TI"],
  " writes out files, it by default uses these names or hexadecimal codes.    \
"
}], "Text",
  CellTags->{"S2.8.9", "9.2"}],

Cell["\<\
But sometimes you may find it convenient to use raw encodings for \
at least some special characters. What this means is that rather than \
representing special characters by names or explicit hexadecimal codes, you \
instead represent them by raw bit patterns appropriate for a particular \
computer system or particular font. \
\>", "Text",
  CellTags->{"S2.8.9", "9.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$CharacterEncoding", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["None", "MR"],
              " "
            }]], Cell[
            "use printable ASCII names for all special characters "]},
          {Cell[TextData[{
              StyleBox["$CharacterEncoding", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["name", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[TextData[{
              "use the raw character encoding specified by ",
              StyleBox["name", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["$SystemCharacterEncoding", "MR"],
              " "
            }]], 
            Cell["\<\
the default raw character encoding for your particular \
computer system \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, True}},
  CellTags->"S2.8.9"],

Cell["Setting up raw character encodings. ", "Caption",
  CellTags->"S2.8.9"],

Cell[TextData[{
  "When you press a key or combination of keys on your keyboard, the \
operating system of your computer sends a certain bit pattern to ",
  StyleBox["Mathematica", "TI"],
  ". How this bit pattern is interpreted as a character within ",
  StyleBox["Mathematica", "TI"],
  " will depend on the character encoding that has been set up. "
}], "Text",
  CellTags->{"S2.8.9", "9.4"}],

Cell[TextData[{
  "The notebook front end for ",
  StyleBox["Mathematica", "TI"],
  " typically takes care of setting up the appropriate character encoding \
automatically for whatever font you are using. But if you use ",
  StyleBox["Mathematica", "TI"],
  " with a text\[Hyphen]based interface or via files or pipes, then you may \
need to set ",
  StyleBox["$CharacterEncoding", "MR"],
  " explicitly. "
}], "Text",
  CellTags->{"S2.8.9", "9.5"}],

Cell[TextData[{
  "By specifying an appropriate value for ",
  StyleBox["$CharacterEncoding", "MR"],
  " you will typically be able to get ",
  StyleBox["Mathematica", "TI"],
  " to handle raw text generated by whatever language\[Hyphen]specific text \
editor or operating system you use. "
}], "Text",
  CellTags->{"S2.8.9", "9.6"}],

Cell[TextData[{
  "You should realize, however, that while the standard representation of \
special characters used in ",
  StyleBox["Mathematica", "TI"],
  " is completely portable across different computer systems, any \
representation that involves raw character encodings will inevitably not be. \
"
}], "Text",
  CellTags->{"S2.8.9", "9.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"PrintableASCII\"", "MR"],
              " "
            }]], Cell["printable ASCII characters only (default) "]},
          {Cell[TextData[{
              StyleBox["\"ASCII\"", "MR"],
              " "
            }]], Cell["all ASCII including control characters "]},
          {Cell[TextData[{
              StyleBox["\"ISOLatin1\"", "MR"],
              " "
            }]], Cell["characters for common western European languages "]},
          {Cell[TextData[{
              StyleBox["\"ISOLatin2\"", "MR"],
              " "
            }]], Cell[
            "characters for central and eastern European languages "]},
          {Cell[TextData[{
              StyleBox["\"ISOLatin3\"", "MR"],
              " "
            }]], 
            Cell["\<\
characters for additional European languages (e.g. \
Catalan, Turkish) \
\>"]},
          {Cell[TextData[{
              StyleBox["\"ISOLatin4\"", "MR"],
              " "
            }]], 
            Cell["\<\
characters for other additional European languages \
(e.g. Estonian, Lappish) \
\>"]},
          {Cell[TextData[{
              StyleBox["\"ISOLatinCyrillic\"", "MR"],
              " "
            }]], Cell["English and Cyrillic characters "]},
          {Cell[TextData[{
              StyleBox["\"AdobeStandard\"", "MR"],
              " "
            }]], Cell["Adobe standard PostScript font encoding "]},
          {Cell[TextData[{
              StyleBox["\"MacintoshRoman\"", "MR"],
              " "
            }]], Cell["Macintosh roman font encoding "]},
          {Cell[TextData[{
              StyleBox["\"WindowsANSI\"", "MR"],
              " "
            }]], Cell["Windows standard font encoding "]},
          {Cell[TextData[{
              StyleBox["\"Symbol\"", "MR"],
              " "
            }]], Cell["symbol font encoding "]},
          {Cell[TextData[{
              StyleBox["\"ZapfDingbats\"", "MR"],
              " "
            }]], Cell["Zapf dingbats font encoding "]},
          {Cell[TextData[{
              StyleBox["\"ShiftJIS\"", "MR"],
              " "
            }]], 
            Cell["\<\
shift\[Hyphen]JIS for Japanese (mixture of 8\[Hyphen] \
and 16\[Hyphen]bit) \
\>"]},
          {Cell[TextData[{
              StyleBox["\"EUC\"", "MR"],
              " "
            }]], 
            Cell["\<\
extended Unix code for Japanese (mixture of 8\[Hyphen] \
and 16\[Hyphen]bit) \
\>"]},
          {Cell[TextData[{
              StyleBox["\"UTF8\"", "MR"],
              " "
            }]], Cell["Unicode transformation format encoding "]},
          {Cell[TextData[{
              StyleBox["\"Unicode\"", "MR"],
              " "
            }]], Cell["\<\
raw 16\[Hyphen]bit Unicode bit patterns \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    False, True, False, False, False, False, False, False, False, False, 
      False, True, False, False, True}},
  CellTags->"S2.8.9"],

Cell[TextData[{
  "Some raw character encodings supported by ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.8.9"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " knows about various raw character encodings, appropriate for different \
computer systems and different languages. "
}], "Text",
  CellTags->{"S2.8.9", "9.8"}],

Cell[TextData[{
  "Any character that is included in a particular raw encoding will be \
written out in raw form by ",
  StyleBox["Mathematica", "TI"],
  " if you specify that encoding. But characters which are not included in \
the encoding will still be written out using standard ",
  StyleBox["Mathematica", "TI"],
  " full names or hexadecimal codes. "
}], "Text",
  CellTags->{"S2.8.9", "9.9"}],

Cell[TextData[{
  "In addition, any character included in a particular encoding can be given \
in raw form as input to ",
  StyleBox["Mathematica", "TI"],
  " if you specify that encoding. ",
  StyleBox["Mathematica", "TI"],
  " will automatically translate the character to its own standard internal \
form. "
}], "Text",
  CellTags->{"S2.8.9", "9.10"}],

Cell[TextData[{
  "This writes a string to the file ",
  StyleBox["tmp", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.9", "9.11"}],

Cell["\"a b c \\[EAcute] \\[Alpha] \\[Pi] \\:2766\" >> tmp", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.8.9"],

Cell["\<\
Special characters are by default written out using full names or \
explicit hexadecimal codes. \
\>", "MathCaption",
  CellTags->{"S2.8.9", "9.12"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.8.9"],

Cell["\"a b c \[EAcute] \[Alpha] \[Pi] \:2766\"", "Print",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to use a raw character encoding appropriate for Macintosh roman fonts. "
}], "MathCaption",
  CellTags->{"S2.8.9", "9.13"}],

Cell[CellGroupData[{

Cell["$CharacterEncoding = \"MacintoshRoman\"", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \("MacintoshRoman"\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell["\<\
Now those special characters that can will be written out in raw \
form. \
\>", "MathCaption",
  CellTags->{"S2.8.9", "9.14"}],

Cell["\"a b c \\[EAcute] \\[Alpha] \\[Pi] \\:2766\" >> tmp", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.8.9"],

Cell["\<\
You can only read the raw characters if you have a system that uses \
the Macintosh roman encoding. \
\>", "MathCaption",
  CellTags->{"S2.8.9", "9.15"}],

Cell[CellGroupData[{

Cell["!!tmp", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.8.9"],

Cell["\"a b c \[EAcute] \[Alpha] \[Pi] \:2766\"", "Print",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to use no raw encoding by default. "
}], "MathCaption",
  CellTags->{"S2.8.9", "9.16"}],

Cell[CellGroupData[{

Cell["$CharacterEncoding = None", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \(None\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell["\<\
You can still explicitly request raw encodings to be used in \
certain functions. \
\>", "MathCaption",
  CellTags->{"S2.8.9", "9.17"}],

Cell[CellGroupData[{

Cell["Get[\"tmp\", CharacterEncoding->\"MacintoshRoman\"]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \("a b c \[EAcute] \[Alpha] \[Pi] \:2766"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " supports both 8\[Hyphen] and 16\[Hyphen]bit raw character encodings. In \
an encoding such as ",
  StyleBox["\"ISOLatin1\"", "MR"],
  ", all characters are represented by bit patterns containing 8 bits. But in \
an encoding such as ",
  StyleBox["\"ShiftJIS\"", "MR"],
  " some characters instead involve bit patterns containing 16 bits.   "
}], "Text",
  CellTags->{"S2.8.9", "9.18"}],

Cell[TextData[{
  "Most of the raw character encodings supported by ",
  StyleBox["Mathematica", "TI"],
  " include basic ASCII as a subset. This means that even when you are using \
such encodings, you can still give ordinary ",
  StyleBox["Mathematica", "TI"],
  " input in the usual way, and you can specify special characters using \
\[Backslash]",
  StyleBox["[", "MR"],
  " and \[Backslash]",
  StyleBox[":", "MR"],
  " sequences. "
}], "Text",
  CellTags->{"S2.8.9", "9.19"}],

Cell[TextData[{
  "Some raw character encodings, however, do not include basic ASCII as a \
subset. An example is the ",
  StyleBox["\"Symbol\"", "MR"],
  " encoding, in which the character codes normally used for ",
  StyleBox["a", "MR"],
  " and ",
  StyleBox["b", "MR"],
  " are instead used for ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta]\)], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S2.8.9", "9.20"}],

Cell["\<\
This gives the usual ASCII character codes for a few English \
letters. \
\>", "MathCaption",
  CellTags->{"S2.8.9", "9.21"}],

Cell[CellGroupData[{

Cell["ToCharacterCode[\"abcdefgh\"]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \({97, 98, 99, 100, 101, 102, 103, 104}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[TextData[{
  "In the ",
  StyleBox["\"Symbol\"", "MR"],
  " encoding, these character codes are used for Greek letters. "
}], "MathCaption",
  CellTags->{"S2.8.9", "9.22"}],

Cell[CellGroupData[{

Cell["FromCharacterCode[%, \"Symbol\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \("\[Alpha]\[Beta]\[Chi]\[Delta]\[Epsilon]\[Phi]\[Gamma]\[Eta]"\)], \
"Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToCharacterCode[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate codes for characters using the standard ",
              StyleBox["Mathematica", "TI"],
              " encoding "
            }]]},
          {Cell[TextData[{
              StyleBox["ToCharacterCode[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["encoding", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "generate codes for characters using the specified encoding "]},
          {Cell[TextData[{
              StyleBox["FromCharacterCode[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "generate characters from codes using the standard ",
              StyleBox["Mathematica", "TI"],
              " encoding "
            }]]},
          {Cell[TextData[{
              StyleBox["FromCharacterCode[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["n",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["encoding", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[
            "generate characters from codes using the specified encoding "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.8.9"],

Cell["Handling character codes with different encodings. ", "Caption",
  CellTags->"S2.8.9"],

Cell[TextData[{
  "This gives the codes assigned to various characters by ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.8.9", "9.23"}],

Cell[CellGroupData[{

Cell["ToCharacterCode[\"abc\\[EAcute]\\[Pi]\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \({97, 98, 99, 233, 960}\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell["\<\
Here are the codes assigned to the same characters in the Macintosh \
roman encoding. \
\>", "MathCaption",
  CellTags->{"S2.8.9", "9.24"}],

Cell[CellGroupData[{

Cell["ToCharacterCode[\"abc\\[EAcute]\\[Pi]\", \"MacintoshRoman\"]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \({97, 98, 99, 142, 185}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[TextData[{
  "Here are the codes in the Windows standard encoding. There is no code for \
\[Backslash]",
  StyleBox["[Pi]", "MR"],
  " in that encoding. "
}], "MathCaption",
  CellTags->{"S2.8.9", "9.25"}],

Cell[CellGroupData[{

Cell["ToCharacterCode[\"abc\\[EAcute]\\[Pi]\", \"WindowsANSI\"]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.8.9"],

Cell[BoxData[
    \({97, 98, 99, 233, None}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.8.9"]
}, Open  ]],

Cell[TextData[{
  "The character codes used internally by ",
  StyleBox["Mathematica", "TI"],
  " are based on Unicode. But externally ",
  StyleBox["Mathematica", "TI"],
  " by default always uses plain ASCII sequences such as \[Backslash]",
  StyleBox["[", "MR"],
  StyleBox["Name", "TI"],
  StyleBox["]", "MR"],
  " or \[Backslash]",
  StyleBox[":", "MR"],
  StyleBox["xxxx", "TI"],
  " to refer to special characters. By telling it to use the raw ",
  StyleBox["\"Unicode\"", "MR"],
  " character encoding, however, you can get ",
  StyleBox["Mathematica", "TI"],
  " to read and write characters in raw 16\[Hyphen]bit Unicode form. "
}], "Text",
  CellTags->{"S2.8.9", "9.26"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 214}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.8.0"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S2.8.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 125, 4, 65, "Section",
      CellTags->{"S2.8.0", "0.1"}]},
  "S2.8.1"->{
    Cell[1926, 61, 80, 1, 70, "Subsection",
      CellTags->{"S2.8.1", "1.1"}],
    Cell[2009, 64, 293, 8, 70, "Text",
      CellTags->{"S2.8.1", "1.2"}],
    Cell[2305, 74, 422, 12, 70, "DefinitionBox",
      CellTags->"S2.8.1"],
    Cell[2730, 88, 55, 1, 70, "Caption",
      CellTags->"S2.8.1"],
    Cell[2788, 91, 298, 7, 70, "Text",
      CellTags->{"S2.8.1", "1.3"}],
    Cell[3089, 100, 284, 7, 70, "Text",
      CellTags->{"S2.8.1", "1.4"}],
    Cell[3376, 109, 181, 5, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.5"}],
    Cell[3582, 118, 85, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[3670, 122, 100, 3, 70, "Output",
      CellTags->"S2.8.1"],
    Cell[3785, 128, 141, 4, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.6"}],
    Cell[3951, 136, 76, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[4030, 140, 97, 2, 70, "Output",
      CellTags->"S2.8.1"],
    Cell[4142, 145, 270, 7, 70, "Text",
      CellTags->{"S2.8.1", "1.7"}],
    Cell[4415, 154, 114, 2, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.8"}],
    Cell[4554, 160, 100, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[4657, 164, 202, 5, 70, "Print",
      CellTags->"S2.8.1"],
    Cell[4874, 172, 299, 9, 70, "Text",
      CellTags->{"S2.8.1", "1.9"}],
    Cell[5176, 183, 177, 7, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.10"}],
    Cell[5378, 194, 75, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[5456, 198, 86, 3, 70, "Output",
      CellTags->"S2.8.1"],
    Cell[5557, 204, 218, 6, 70, "Text",
      CellTags->{"S2.8.1", "1.11"}],
    Cell[5778, 212, 129, 5, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.12"}],
    Cell[5932, 221, 75, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[6010, 225, 87, 3, 70, "Output",
      CellTags->"S2.8.1"],
    Cell[6112, 231, 139, 5, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.13"}],
    Cell[6276, 240, 101, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[6380, 244, 92, 3, 70, "Output",
      CellTags->"S2.8.1"],
    Cell[6487, 250, 219, 5, 70, "Text",
      CellTags->{"S2.8.1", "1.14"}],
    Cell[6709, 257, 131, 4, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.15"}],
    Cell[6865, 265, 80, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[6948, 269, 83, 3, 70, "Output",
      CellTags->"S2.8.1"],
    Cell[7046, 275, 195, 7, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.16"}],
    Cell[7266, 286, 112, 2, 70, "Input",
      CellTags->"S2.8.1"],
    Cell[7381, 290, 100, 3, 70, "Output",
      CellTags->"S2.8.1"]},
  "1.1"->{
    Cell[1926, 61, 80, 1, 70, "Subsection",
      CellTags->{"S2.8.1", "1.1"}]},
  "1.2"->{
    Cell[2009, 64, 293, 8, 70, "Text",
      CellTags->{"S2.8.1", "1.2"}]},
  "1.3"->{
    Cell[2788, 91, 298, 7, 70, "Text",
      CellTags->{"S2.8.1", "1.3"}]},
  "1.4"->{
    Cell[3089, 100, 284, 7, 70, "Text",
      CellTags->{"S2.8.1", "1.4"}]},
  "1.5"->{
    Cell[3376, 109, 181, 5, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.5"}]},
  "1.6"->{
    Cell[3785, 128, 141, 4, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.6"}]},
  "1.7"->{
    Cell[4142, 145, 270, 7, 70, "Text",
      CellTags->{"S2.8.1", "1.7"}]},
  "1.8"->{
    Cell[4415, 154, 114, 2, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.8"}]},
  "1.9"->{
    Cell[4874, 172, 299, 9, 70, "Text",
      CellTags->{"S2.8.1", "1.9"}]},
  "1.10"->{
    Cell[5176, 183, 177, 7, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.10"}]},
  "1.11"->{
    Cell[5557, 204, 218, 6, 70, "Text",
      CellTags->{"S2.8.1", "1.11"}]},
  "1.12"->{
    Cell[5778, 212, 129, 5, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.12"}]},
  "1.13"->{
    Cell[6112, 231, 139, 5, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.13"}]},
  "1.14"->{
    Cell[6487, 250, 219, 5, 70, "Text",
      CellTags->{"S2.8.1", "1.14"}]},
  "1.15"->{
    Cell[6709, 257, 131, 4, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.15"}]},
  "1.16"->{
    Cell[7046, 275, 195, 7, 70, "MathCaption",
      CellTags->{"S2.8.1", "1.16"}]},
  "S2.8.2"->{
    Cell[7530, 299, 80, 1, 70, "Subsection",
      CellTags->{"S2.8.2", "2.1"}],
    Cell[7613, 302, 313, 6, 70, "Text",
      CellTags->{"S2.8.2", "2.2"}],
    Cell[7929, 310, 1897, 53, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[9829, 365, 73, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[9905, 368, 152, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.3"}],
    Cell[10082, 377, 104, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[10189, 381, 103, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[10307, 387, 149, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.4"}],
    Cell[10481, 395, 79, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[10563, 399, 83, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[10661, 405, 143, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.5"}],
    Cell[10829, 413, 92, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[10924, 417, 92, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[11031, 423, 4198, 124, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[15232, 549, 73, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[15308, 552, 604, 20, 70, "Text",
      CellTags->{"S2.8.2", "2.6"}],
    Cell[15915, 574, 79, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.7"}],
    Cell[16019, 579, 102, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[16124, 583, 109, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[16248, 589, 147, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.8"}],
    Cell[16420, 598, 84, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[16507, 602, 88, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[16610, 608, 136, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.9"}],
    Cell[16771, 617, 86, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[16860, 621, 84, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[16959, 627, 142, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.10"}],
    Cell[17126, 635, 92, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[17221, 639, 100, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[17336, 645, 1920, 60, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[19259, 707, 66, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[19328, 710, 466, 18, 70, "Text",
      CellTags->{"S2.8.2", "2.11"}],
    Cell[19797, 730, 196, 6, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.12"}],
    Cell[20018, 740, 101, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[20122, 744, 93, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[20230, 750, 116, 2, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.13"}],
    Cell[20371, 756, 103, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[20477, 760, 94, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[20586, 766, 182, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.14"}],
    Cell[20793, 775, 112, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[20908, 779, 101, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[21024, 785, 4914, 144, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[25941, 931, 70, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[26014, 934, 159, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.15"}],
    Cell[26198, 943, 113, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[26314, 947, 90, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[26419, 953, 159, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.16"}],
    Cell[26603, 962, 124, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[26730, 966, 92, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[26837, 972, 131, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.17"}],
    Cell[26993, 980, 146, 5, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[27142, 987, 93, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[27250, 993, 2535, 76, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[29788, 1071, 74, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[29865, 1074, 615, 16, 70, "Text",
      CellTags->{"S2.8.2", "2.18"}],
    Cell[30483, 1092, 160, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.19"}],
    Cell[30668, 1101, 110, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[30781, 1105, 118, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[30914, 1111, 148, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.20"}],
    Cell[31087, 1120, 113, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[31203, 1124, 90, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[31308, 1130, 211, 7, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.21"}],
    Cell[31544, 1141, 114, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[31661, 1145, 123, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[31799, 1151, 87, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.22"}],
    Cell[31911, 1156, 143, 5, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[32057, 1163, 107, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[32179, 1169, 3554, 108, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[35736, 1279, 65, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[35804, 1282, 145, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.23"}],
    Cell[35974, 1290, 111, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[36088, 1294, 83, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[36186, 1300, 4239, 131, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[40428, 1433, 82, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[40513, 1436, 194, 7, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.24"}],
    Cell[40732, 1447, 117, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[40852, 1451, 105, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[40972, 1457, 221, 11, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.25"}],
    Cell[41218, 1472, 148, 5, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[41369, 1479, 98, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[41482, 1485, 201, 7, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.26"}],
    Cell[41708, 1496, 136, 3, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[41847, 1501, 92, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[41954, 1507, 400, 9, 70, "Text",
      CellTags->{"S2.8.2", "2.27"}],
    Cell[42357, 1518, 162, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.28"}],
    Cell[42544, 1527, 109, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[42656, 1531, 127, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[42798, 1537, 117, 2, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.29"}],
    Cell[42940, 1543, 148, 5, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[43091, 1550, 124, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[43230, 1556, 2601, 80, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[45834, 1638, 60, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[45897, 1641, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.30"}],
    Cell[46024, 1646, 97, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[46124, 1650, 113, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[46252, 1656, 127, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.31"}],
    Cell[46404, 1665, 105, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[46512, 1669, 106, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[46633, 1675, 91, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.32"}],
    Cell[46749, 1680, 113, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[46865, 1684, 166, 4, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[47046, 1691, 2769, 82, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[49818, 1775, 93, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[49914, 1778, 197, 9, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.33"}],
    Cell[50136, 1791, 113, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[50252, 1795, 122, 3, 70, "Output",
      CellTags->"S2.8.2"],
    Cell[50389, 1801, 1183, 34, 70, "DefinitionBox",
      CellTags->"S2.8.2"],
    Cell[51575, 1837, 58, 1, 70, "Caption",
      CellTags->"S2.8.2"],
    Cell[51636, 1840, 144, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.34"}],
    Cell[51805, 1848, 112, 2, 70, "Input",
      CellTags->"S2.8.2"],
    Cell[51920, 1852, 115, 3, 70, "Output",
      CellTags->"S2.8.2"]},
  "2.1"->{
    Cell[7530, 299, 80, 1, 70, "Subsection",
      CellTags->{"S2.8.2", "2.1"}]},
  "2.2"->{
    Cell[7613, 302, 313, 6, 70, "Text",
      CellTags->{"S2.8.2", "2.2"}]},
  "2.3"->{
    Cell[9905, 368, 152, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.3"}]},
  "2.4"->{
    Cell[10307, 387, 149, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.4"}]},
  "2.5"->{
    Cell[10661, 405, 143, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.5"}]},
  "2.6"->{
    Cell[15308, 552, 604, 20, 70, "Text",
      CellTags->{"S2.8.2", "2.6"}]},
  "2.7"->{
    Cell[15915, 574, 79, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.7"}]},
  "2.8"->{
    Cell[16248, 589, 147, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.8"}]},
  "2.9"->{
    Cell[16610, 608, 136, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.9"}]},
  "2.10"->{
    Cell[16959, 627, 142, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.10"}]},
  "2.11"->{
    Cell[19328, 710, 466, 18, 70, "Text",
      CellTags->{"S2.8.2", "2.11"}]},
  "2.12"->{
    Cell[19797, 730, 196, 6, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.12"}]},
  "2.13"->{
    Cell[20230, 750, 116, 2, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.13"}]},
  "2.14"->{
    Cell[20586, 766, 182, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.14"}]},
  "2.15"->{
    Cell[26014, 934, 159, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.15"}]},
  "2.16"->{
    Cell[26419, 953, 159, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.16"}]},
  "2.17"->{
    Cell[26837, 972, 131, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.17"}]},
  "2.18"->{
    Cell[29865, 1074, 615, 16, 70, "Text",
      CellTags->{"S2.8.2", "2.18"}]},
  "2.19"->{
    Cell[30483, 1092, 160, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.19"}]},
  "2.20"->{
    Cell[30914, 1111, 148, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.20"}]},
  "2.21"->{
    Cell[31308, 1130, 211, 7, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.21"}]},
  "2.22"->{
    Cell[31799, 1151, 87, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.22"}]},
  "2.23"->{
    Cell[35804, 1282, 145, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.23"}]},
  "2.24"->{
    Cell[40513, 1436, 194, 7, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.24"}]},
  "2.25"->{
    Cell[40972, 1457, 221, 11, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.25"}]},
  "2.26"->{
    Cell[41482, 1485, 201, 7, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.26"}]},
  "2.27"->{
    Cell[41954, 1507, 400, 9, 70, "Text",
      CellTags->{"S2.8.2", "2.27"}]},
  "2.28"->{
    Cell[42357, 1518, 162, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.28"}]},
  "2.29"->{
    Cell[42798, 1537, 117, 2, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.29"}]},
  "2.30"->{
    Cell[45897, 1641, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.30"}]},
  "2.31"->{
    Cell[46252, 1656, 127, 5, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.31"}]},
  "2.32"->{
    Cell[46633, 1675, 91, 1, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.32"}]},
  "2.33"->{
    Cell[49914, 1778, 197, 9, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.33"}]},
  "2.34"->{
    Cell[51636, 1840, 144, 4, 70, "MathCaption",
      CellTags->{"S2.8.2", "2.34"}]},
  "S2.8.3"->{
    Cell[52084, 1861, 80, 1, 70, "Subsection",
      CellTags->{"S2.8.3", "3.1"}],
    Cell[52167, 1864, 1234, 34, 70, "DefinitionBox",
      CellTags->"S2.8.3"],
    Cell[53404, 1900, 93, 1, 70, "Caption",
      CellTags->"S2.8.3"],
    Cell[53500, 1903, 105, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.2"}],
    Cell[53630, 1908, 89, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[53722, 1912, 126, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[53863, 1918, 130, 4, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.3"}],
    Cell[54018, 1926, 80, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[54101, 1930, 126, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[54242, 1936, 160, 4, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.4"}],
    Cell[54427, 1944, 77, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[54507, 1948, 92, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[54614, 1954, 1286, 40, 70, "DefinitionBox",
      CellTags->"S2.8.3"],
    Cell[55903, 1996, 73, 1, 70, "Caption",
      CellTags->"S2.8.3"],
    Cell[55979, 1999, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.5"}],
    Cell[56106, 2004, 82, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[56191, 2008, 85, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[56291, 2014, 158, 5, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.6"}],
    Cell[56474, 2023, 85, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[56562, 2027, 86, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[56663, 2033, 726, 20, 70, "DefinitionBox",
      CellTags->"S2.8.3"],
    Cell[57392, 2055, 82, 1, 70, "Caption",
      CellTags->"S2.8.3"],
    Cell[57477, 2058, 95, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.7"}],
    Cell[57597, 2063, 91, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[57691, 2067, 93, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[57799, 2073, 1374, 38, 70, "DefinitionBox",
      CellTags->"S2.8.3"],
    Cell[59176, 2113, 74, 1, 70, "Caption",
      CellTags->"S2.8.3"],
    Cell[59253, 2116, 139, 4, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.8"}],
    Cell[59417, 2124, 92, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[59512, 2128, 121, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[59648, 2134, 108, 3, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.9"}],
    Cell[59781, 2141, 92, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[59876, 2145, 116, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[60007, 2151, 77, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.10"}],
    Cell[60109, 2156, 92, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[60204, 2160, 121, 3, 70, "Output",
      CellTags->"S2.8.3"],
    Cell[60340, 2166, 371, 9, 70, "Text",
      CellTags->{"S2.8.3", "3.11"}],
    Cell[60714, 2177, 184, 5, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.12"}],
    Cell[60923, 2186, 93, 2, 70, "Input",
      CellTags->"S2.8.3"],
    Cell[61019, 2190, 180, 4, 70, "Output",
      CellTags->"S2.8.3"]},
  "3.1"->{
    Cell[52084, 1861, 80, 1, 70, "Subsection",
      CellTags->{"S2.8.3", "3.1"}]},
  "3.2"->{
    Cell[53500, 1903, 105, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.2"}]},
  "3.3"->{
    Cell[53863, 1918, 130, 4, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.3"}]},
  "3.4"->{
    Cell[54242, 1936, 160, 4, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.4"}]},
  "3.5"->{
    Cell[55979, 1999, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.5"}]},
  "3.6"->{
    Cell[56291, 2014, 158, 5, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.6"}]},
  "3.7"->{
    Cell[57477, 2058, 95, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.7"}]},
  "3.8"->{
    Cell[59253, 2116, 139, 4, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.8"}]},
  "3.9"->{
    Cell[59648, 2134, 108, 3, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.9"}]},
  "3.10"->{
    Cell[60007, 2151, 77, 1, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.10"}]},
  "3.11"->{
    Cell[60340, 2166, 371, 9, 70, "Text",
      CellTags->{"S2.8.3", "3.11"}]},
  "3.12"->{
    Cell[60714, 2177, 184, 5, 70, "MathCaption",
      CellTags->{"S2.8.3", "3.12"}]},
  "S2.8.4"->{
    Cell[61248, 2200, 74, 1, 70, "Subsection",
      CellTags->{"S2.8.4", "4.1"}],
    Cell[61325, 2203, 257, 6, 70, "Text",
      CellTags->{"S2.8.4", "4.2"}],
    Cell[61585, 2211, 181, 9, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.3"}],
    Cell[61791, 2224, 116, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[61910, 2228, 92, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[62017, 2234, 132, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.4"}],
    Cell[62174, 2243, 104, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[62281, 2247, 92, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[62388, 2253, 263, 7, 70, "Text",
      CellTags->{"S2.8.4", "4.5"}],
    Cell[62654, 2262, 1455, 41, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[64112, 2305, 61, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[64176, 2308, 190, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.6"}],
    Cell[64391, 2317, 75, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[64469, 2321, 90, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[64574, 2327, 132, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.7"}],
    Cell[64731, 2335, 118, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[64852, 2339, 90, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[64957, 2345, 5435, 170, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[70395, 2517, 81, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[70479, 2520, 127, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.8"}],
    Cell[70631, 2528, 107, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[70741, 2532, 102, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[70858, 2538, 161, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.9"}],
    Cell[71044, 2547, 113, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[71160, 2551, 96, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[71271, 2557, 117, 2, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.10"}],
    Cell[71413, 2563, 108, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[71524, 2567, 117, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[71656, 2573, 345, 9, 70, "Text",
      CellTags->{"S2.8.4", "4.11"}],
    Cell[72004, 2584, 149, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.12"}],
    Cell[72178, 2593, 129, 3, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[72310, 2598, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[72425, 2604, 168, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.13"}],
    Cell[72618, 2613, 130, 3, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[72751, 2618, 99, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[72865, 2624, 170, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.14"}],
    Cell[73060, 2633, 132, 3, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[73195, 2638, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[73310, 2644, 5292, 158, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[78605, 2804, 69, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[78677, 2807, 99, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.15"}],
    Cell[78801, 2812, 104, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[78908, 2816, 102, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[79025, 2822, 171, 7, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.16"}],
    Cell[79221, 2833, 115, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[79339, 2837, 99, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[79453, 2843, 110, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.17"}],
    Cell[79588, 2848, 114, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[79705, 2852, 99, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[79819, 2858, 1000, 37, 70, "Text",
      CellTags->{"S2.8.4", "4.18"}],
    Cell[80822, 2897, 88, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.19"}],
    Cell[80935, 2902, 86, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[81024, 2906, 107, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[81146, 2912, 91, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.20"}],
    Cell[81262, 2917, 127, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[81392, 2921, 97, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[81504, 2927, 183, 7, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.21"}],
    Cell[81712, 2938, 93, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[81808, 2942, 122, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[81945, 2948, 263, 6, 70, "Text",
      CellTags->{"S2.8.4", "4.22"}],
    Cell[82211, 2956, 4565, 132, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[86779, 3090, 83, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[86865, 3093, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.23"}],
    Cell[86994, 3098, 109, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[87106, 3102, 112, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[87233, 3108, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.24"}],
    Cell[87358, 3113, 117, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[87478, 3117, 107, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[87600, 3123, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.25"}],
    Cell[87727, 3128, 110, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[87840, 3132, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[87955, 3138, 80, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.26"}],
    Cell[88060, 3143, 77, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[88140, 3147, 101, 2, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[88256, 3152, 93, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.27"}],
    Cell[88374, 3157, 84, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[88461, 3161, 94, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[88570, 3167, 290, 6, 70, "Text",
      CellTags->{"S2.8.4", "4.28"}],
    Cell[88863, 3175, 143, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.29"}],
    Cell[89031, 3184, 120, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[89154, 3188, 99, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[89268, 3194, 85, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.30"}],
    Cell[89378, 3199, 127, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[89508, 3203, 97, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[89620, 3209, 213, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.31"}],
    Cell[89858, 3218, 163, 5, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[90024, 3225, 113, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[90152, 3231, 153, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.32"}],
    Cell[90330, 3239, 82, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[90415, 3243, 128, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[90558, 3249, 381, 9, 70, "Text",
      CellTags->{"S2.8.4", "4.33"}],
    Cell[90942, 3260, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.34"}],
    Cell[91067, 3265, 113, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[91183, 3269, 90, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[91288, 3275, 114, 2, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.35"}],
    Cell[91427, 3281, 114, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[91544, 3285, 93, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[91652, 3291, 390, 8, 70, "Text",
      CellTags->{"S2.8.4", "4.36"}],
    Cell[92045, 3301, 1106, 30, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[93154, 3333, 96, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[93253, 3336, 152, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.37"}],
    Cell[93430, 3345, 116, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[93549, 3349, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[93664, 3355, 175, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.38"}],
    Cell[93864, 3364, 135, 3, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[94002, 3369, 98, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[94115, 3375, 155, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.39"}],
    Cell[94295, 3384, 113, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[94411, 3388, 92, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[94518, 3394, 137, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.40"}],
    Cell[94680, 3402, 155, 5, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[94838, 3409, 93, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[94946, 3415, 217, 7, 70, "Text",
      CellTags->{"S2.8.4", "4.41"}],
    Cell[95166, 3424, 130, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.42"}],
    Cell[95321, 3432, 116, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[95440, 3436, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[95555, 3442, 575, 17, 70, "Text",
      CellTags->{"S2.8.4", "4.43"}],
    Cell[96133, 3461, 850, 26, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[96986, 3489, 92, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[97081, 3492, 148, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.44"}],
    Cell[97254, 3500, 120, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[97377, 3504, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[97492, 3510, 175, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.45"}],
    Cell[97692, 3518, 145, 5, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[97840, 3525, 104, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[97959, 3531, 515, 17, 70, "Text",
      CellTags->{"S2.8.4", "4.46"}],
    Cell[98477, 3550, 522, 18, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[99002, 3570, 106, 4, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[99111, 3576, 162, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.47"}],
    Cell[99298, 3585, 151, 5, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[99452, 3592, 99, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[99566, 3598, 338, 10, 70, "Text",
      CellTags->{"S2.8.4", "4.48"}],
    Cell[99907, 3610, 142, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.49"}],
    Cell[100074, 3618, 97, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[100174, 3622, 100, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[100289, 3628, 83, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.50"}],
    Cell[100397, 3633, 115, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[100515, 3637, 118, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[100648, 3643, 138, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.51"}],
    Cell[100811, 3651, 100, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[100914, 3655, 130, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[101059, 3661, 995, 31, 70, "DefinitionBox",
      CellTags->"S2.8.4"],
    Cell[102057, 3694, 83, 1, 70, "Caption",
      CellTags->"S2.8.4"],
    Cell[102143, 3697, 88, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.52"}],
    Cell[102256, 3702, 109, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[102368, 3706, 90, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[102473, 3712, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.53"}],
    Cell[102602, 3717, 108, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[102713, 3721, 108, 3, 70, "Output",
      CellTags->"S2.8.4"],
    Cell[102836, 3727, 103, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.54"}],
    Cell[102964, 3732, 107, 2, 70, "Input",
      CellTags->"S2.8.4"],
    Cell[103074, 3736, 149, 4, 70, "Output",
      CellTags->"S2.8.4"]},
  "4.1"->{
    Cell[61248, 2200, 74, 1, 70, "Subsection",
      CellTags->{"S2.8.4", "4.1"}]},
  "4.2"->{
    Cell[61325, 2203, 257, 6, 70, "Text",
      CellTags->{"S2.8.4", "4.2"}]},
  "4.3"->{
    Cell[61585, 2211, 181, 9, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.3"}]},
  "4.4"->{
    Cell[62017, 2234, 132, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.4"}]},
  "4.5"->{
    Cell[62388, 2253, 263, 7, 70, "Text",
      CellTags->{"S2.8.4", "4.5"}]},
  "4.6"->{
    Cell[64176, 2308, 190, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.6"}]},
  "4.7"->{
    Cell[64574, 2327, 132, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.7"}]},
  "4.8"->{
    Cell[70479, 2520, 127, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.8"}]},
  "4.9"->{
    Cell[70858, 2538, 161, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.9"}]},
  "4.10"->{
    Cell[71271, 2557, 117, 2, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.10"}]},
  "4.11"->{
    Cell[71656, 2573, 345, 9, 70, "Text",
      CellTags->{"S2.8.4", "4.11"}]},
  "4.12"->{
    Cell[72004, 2584, 149, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.12"}]},
  "4.13"->{
    Cell[72425, 2604, 168, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.13"}]},
  "4.14"->{
    Cell[72865, 2624, 170, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.14"}]},
  "4.15"->{
    Cell[78677, 2807, 99, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.15"}]},
  "4.16"->{
    Cell[79025, 2822, 171, 7, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.16"}]},
  "4.17"->{
    Cell[79453, 2843, 110, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.17"}]},
  "4.18"->{
    Cell[79819, 2858, 1000, 37, 70, "Text",
      CellTags->{"S2.8.4", "4.18"}]},
  "4.19"->{
    Cell[80822, 2897, 88, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.19"}]},
  "4.20"->{
    Cell[81146, 2912, 91, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.20"}]},
  "4.21"->{
    Cell[81504, 2927, 183, 7, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.21"}]},
  "4.22"->{
    Cell[81945, 2948, 263, 6, 70, "Text",
      CellTags->{"S2.8.4", "4.22"}]},
  "4.23"->{
    Cell[86865, 3093, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.23"}]},
  "4.24"->{
    Cell[87233, 3108, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.24"}]},
  "4.25"->{
    Cell[87600, 3123, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.25"}]},
  "4.26"->{
    Cell[87955, 3138, 80, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.26"}]},
  "4.27"->{
    Cell[88256, 3152, 93, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.27"}]},
  "4.28"->{
    Cell[88570, 3167, 290, 6, 70, "Text",
      CellTags->{"S2.8.4", "4.28"}]},
  "4.29"->{
    Cell[88863, 3175, 143, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.29"}]},
  "4.30"->{
    Cell[89268, 3194, 85, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.30"}]},
  "4.31"->{
    Cell[89620, 3209, 213, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.31"}]},
  "4.32"->{
    Cell[90152, 3231, 153, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.32"}]},
  "4.33"->{
    Cell[90558, 3249, 381, 9, 70, "Text",
      CellTags->{"S2.8.4", "4.33"}]},
  "4.34"->{
    Cell[90942, 3260, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.34"}]},
  "4.35"->{
    Cell[91288, 3275, 114, 2, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.35"}]},
  "4.36"->{
    Cell[91652, 3291, 390, 8, 70, "Text",
      CellTags->{"S2.8.4", "4.36"}]},
  "4.37"->{
    Cell[93253, 3336, 152, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.37"}]},
  "4.38"->{
    Cell[93664, 3355, 175, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.38"}]},
  "4.39"->{
    Cell[94115, 3375, 155, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.39"}]},
  "4.40"->{
    Cell[94518, 3394, 137, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.40"}]},
  "4.41"->{
    Cell[94946, 3415, 217, 7, 70, "Text",
      CellTags->{"S2.8.4", "4.41"}]},
  "4.42"->{
    Cell[95166, 3424, 130, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.42"}]},
  "4.43"->{
    Cell[95555, 3442, 575, 17, 70, "Text",
      CellTags->{"S2.8.4", "4.43"}]},
  "4.44"->{
    Cell[97081, 3492, 148, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.44"}]},
  "4.45"->{
    Cell[97492, 3510, 175, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.45"}]},
  "4.46"->{
    Cell[97959, 3531, 515, 17, 70, "Text",
      CellTags->{"S2.8.4", "4.46"}]},
  "4.47"->{
    Cell[99111, 3576, 162, 5, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.47"}]},
  "4.48"->{
    Cell[99566, 3598, 338, 10, 70, "Text",
      CellTags->{"S2.8.4", "4.48"}]},
  "4.49"->{
    Cell[99907, 3610, 142, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.49"}]},
  "4.50"->{
    Cell[100289, 3628, 83, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.50"}]},
  "4.51"->{
    Cell[100648, 3643, 138, 4, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.51"}]},
  "4.52"->{
    Cell[102143, 3697, 88, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.52"}]},
  "4.53"->{
    Cell[102473, 3712, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.53"}]},
  "4.54"->{
    Cell[102836, 3727, 103, 1, 70, "MathCaption",
      CellTags->{"S2.8.4", "4.54"}]},
  "S2.8.5"->{
    Cell[103272, 3746, 94, 1, 70, "Subsection",
      CellTags->{"S2.8.5", "5.1"}],
    Cell[103369, 3749, 510, 14, 70, "Text",
      CellTags->{"S2.8.5", "5.2"}],
    Cell[103882, 3765, 611, 18, 70, "DefinitionBox",
      CellTags->"S2.8.5"],
    Cell[104496, 3785, 135, 5, 70, "Caption",
      CellTags->"S2.8.5"],
    Cell[104634, 3792, 167, 7, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.3"}],
    Cell[104826, 3803, 141, 5, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[104970, 3810, 96, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[105081, 3816, 176, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.4"}],
    Cell[105282, 3825, 117, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[105402, 3829, 96, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[105513, 3835, 109, 1, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.5"}],
    Cell[105647, 3840, 146, 5, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[105796, 3847, 92, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[105903, 3853, 199, 6, 70, "Text",
      CellTags->{"S2.8.5", "5.6"}],
    Cell[106105, 3861, 7285, 215, 70, "DefinitionBox",
      CellTags->"S2.8.5"],
    Cell[113393, 4078, 138, 5, 70, "Caption",
      CellTags->"S2.8.5"],
    Cell[113534, 4085, 131, 4, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.7"}],
    Cell[113690, 4093, 129, 3, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[113822, 4098, 105, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[113942, 4104, 170, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.8"}],
    Cell[114137, 4113, 116, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[114256, 4117, 105, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[114376, 4123, 225, 6, 70, "Text",
      CellTags->{"S2.8.5", "5.9"}],
    Cell[114604, 4131, 7643, 227, 70, "DefinitionBox",
      CellTags->"S2.8.5"],
    Cell[122250, 4360, 133, 4, 70, "Caption",
      CellTags->"S2.8.5"],
    Cell[122386, 4366, 413, 9, 70, "Text",
      CellTags->{"S2.8.5", "5.10"}],
    Cell[122802, 4377, 2455, 74, 70, "DefinitionBox",
      CellTags->"S2.8.5"],
    Cell[125260, 4453, 97, 1, 70, "Caption",
      CellTags->"S2.8.5"],
    Cell[125360, 4456, 161, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.11"}],
    Cell[125546, 4465, 125, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[125674, 4469, 101, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[125790, 4475, 170, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.12"}],
    Cell[125985, 4484, 121, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[126109, 4488, 101, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[126225, 4494, 634, 32, 70, "Text",
      CellTags->{"S2.8.5", "5.13"}],
    Cell[126862, 4528, 110, 3, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.14"}],
    Cell[126997, 4535, 140, 5, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[127140, 4542, 103, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[127258, 4548, 81, 1, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.15"}],
    Cell[127364, 4553, 126, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[127493, 4557, 103, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[127611, 4563, 1252, 40, 70, "DefinitionBox",
      CellTags->"S2.8.5"],
    Cell[128866, 4605, 96, 1, 70, "Caption",
      CellTags->"S2.8.5"],
    Cell[128965, 4608, 914, 29, 70, "Text",
      CellTags->{"S2.8.5", "5.16"}],
    Cell[129882, 4639, 117, 2, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.17"}],
    Cell[130024, 4645, 132, 3, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[130159, 4650, 106, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[130280, 4656, 168, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.18"}],
    Cell[130473, 4665, 107, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[130583, 4669, 106, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[130704, 4675, 171, 7, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.19"}],
    Cell[130900, 4686, 150, 5, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[131053, 4693, 102, 3, 70, "Output",
      CellTags->"S2.8.5"],
    Cell[131170, 4699, 140, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.20"}],
    Cell[131335, 4708, 112, 2, 70, "Input",
      CellTags->"S2.8.5"],
    Cell[131450, 4712, 102, 3, 70, "Output",
      CellTags->"S2.8.5"]},
  "5.1"->{
    Cell[103272, 3746, 94, 1, 70, "Subsection",
      CellTags->{"S2.8.5", "5.1"}]},
  "5.2"->{
    Cell[103369, 3749, 510, 14, 70, "Text",
      CellTags->{"S2.8.5", "5.2"}]},
  "5.3"->{
    Cell[104634, 3792, 167, 7, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.3"}]},
  "5.4"->{
    Cell[105081, 3816, 176, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.4"}]},
  "5.5"->{
    Cell[105513, 3835, 109, 1, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.5"}]},
  "5.6"->{
    Cell[105903, 3853, 199, 6, 70, "Text",
      CellTags->{"S2.8.5", "5.6"}]},
  "5.7"->{
    Cell[113534, 4085, 131, 4, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.7"}]},
  "5.8"->{
    Cell[113942, 4104, 170, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.8"}]},
  "5.9"->{
    Cell[114376, 4123, 225, 6, 70, "Text",
      CellTags->{"S2.8.5", "5.9"}]},
  "5.10"->{
    Cell[122386, 4366, 413, 9, 70, "Text",
      CellTags->{"S2.8.5", "5.10"}]},
  "5.11"->{
    Cell[125360, 4456, 161, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.11"}]},
  "5.12"->{
    Cell[125790, 4475, 170, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.12"}]},
  "5.13"->{
    Cell[126225, 4494, 634, 32, 70, "Text",
      CellTags->{"S2.8.5", "5.13"}]},
  "5.14"->{
    Cell[126862, 4528, 110, 3, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.14"}]},
  "5.15"->{
    Cell[127258, 4548, 81, 1, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.15"}]},
  "5.16"->{
    Cell[128965, 4608, 914, 29, 70, "Text",
      CellTags->{"S2.8.5", "5.16"}]},
  "5.17"->{
    Cell[129882, 4639, 117, 2, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.17"}]},
  "5.18"->{
    Cell[130280, 4656, 168, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.18"}]},
  "5.19"->{
    Cell[130704, 4675, 171, 7, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.19"}]},
  "5.20"->{
    Cell[131170, 4699, 140, 5, 70, "MathCaption",
      CellTags->{"S2.8.5", "5.20"}]},
  "S2.8.6"->{
    Cell[131601, 4721, 77, 1, 70, "Subsection",
      CellTags->{"S2.8.6", "6.1"}],
    Cell[131681, 4724, 300, 8, 70, "Text",
      CellTags->{"S2.8.6", "6.2"}],
    Cell[131984, 4734, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.3"}],
    Cell[132111, 4739, 120, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[132234, 4743, 135, 3, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[132384, 4749, 116, 2, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.4"}],
    Cell[132525, 4755, 143, 5, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[132671, 4762, 163, 4, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[132849, 4769, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.5"}],
    Cell[132978, 4774, 77, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[133058, 4778, 210, 4, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[133283, 4785, 418, 10, 70, "Text",
      CellTags->{"S2.8.6", "6.6"}],
    Cell[133704, 4797, 377, 9, 70, "Text",
      CellTags->{"S2.8.6", "6.7"}],
    Cell[134084, 4808, 218, 7, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.8"}],
    Cell[134327, 4819, 115, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[134445, 4823, 130, 3, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[134590, 4829, 209, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.9"}],
    Cell[134824, 4839, 79, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[134906, 4843, 128, 2, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[135037, 4847, 150, 5, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[135202, 4855, 353, 8, 70, "Text",
      CellTags->{"S2.8.6", "6.10"}],
    Cell[135558, 4865, 269, 7, 70, "Text",
      CellTags->{"S2.8.6", "6.11"}],
    Cell[135830, 4874, 190, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.12"}],
    Cell[136045, 4884, 130, 3, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[136178, 4889, 127, 2, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[136320, 4894, 968, 30, 70, "DefinitionBox",
      CellTags->"S2.8.6"],
    Cell[137291, 4926, 79, 1, 70, "Caption",
      CellTags->"S2.8.6"],
    Cell[137373, 4929, 248, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.13"}],
    Cell[137646, 4939, 123, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[137772, 4943, 132, 3, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[137919, 4949, 259, 7, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.14"}],
    Cell[138203, 4960, 93, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[138299, 4964, 105, 3, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[138419, 4970, 126, 4, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.15"}],
    Cell[138570, 4978, 77, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[138650, 4982, 166, 4, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[138831, 4989, 209, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.16"}],
    Cell[139065, 4999, 119, 4, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[139187, 5005, 135, 3, 70, "Output",
      CellTags->"S2.8.6"],
    Cell[139337, 5011, 221, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.17"}],
    Cell[139583, 5021, 119, 2, 70, "Input",
      CellTags->"S2.8.6"],
    Cell[139705, 5025, 92, 3, 70, "Output",
      CellTags->"S2.8.6"]},
  "6.1"->{
    Cell[131601, 4721, 77, 1, 70, "Subsection",
      CellTags->{"S2.8.6", "6.1"}]},
  "6.2"->{
    Cell[131681, 4724, 300, 8, 70, "Text",
      CellTags->{"S2.8.6", "6.2"}]},
  "6.3"->{
    Cell[131984, 4734, 102, 1, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.3"}]},
  "6.4"->{
    Cell[132384, 4749, 116, 2, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.4"}]},
  "6.5"->{
    Cell[132849, 4769, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.5"}]},
  "6.6"->{
    Cell[133283, 4785, 418, 10, 70, "Text",
      CellTags->{"S2.8.6", "6.6"}]},
  "6.7"->{
    Cell[133704, 4797, 377, 9, 70, "Text",
      CellTags->{"S2.8.6", "6.7"}]},
  "6.8"->{
    Cell[134084, 4808, 218, 7, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.8"}]},
  "6.9"->{
    Cell[134590, 4829, 209, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.9"}]},
  "6.10"->{
    Cell[135202, 4855, 353, 8, 70, "Text",
      CellTags->{"S2.8.6", "6.10"}]},
  "6.11"->{
    Cell[135558, 4865, 269, 7, 70, "Text",
      CellTags->{"S2.8.6", "6.11"}]},
  "6.12"->{
    Cell[135830, 4874, 190, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.12"}]},
  "6.13"->{
    Cell[137373, 4929, 248, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.13"}]},
  "6.14"->{
    Cell[137919, 4949, 259, 7, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.14"}]},
  "6.15"->{
    Cell[138419, 4970, 126, 4, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.15"}]},
  "6.16"->{
    Cell[138831, 4989, 209, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.16"}]},
  "6.17"->{
    Cell[139337, 5011, 221, 6, 70, "MathCaption",
      CellTags->{"S2.8.6", "6.17"}]},
  "S2.8.7"->{
    Cell[139846, 5034, 103, 1, 70, "Subsection",
      CellTags->{"S2.8.7", "7.1"}],
    Cell[139952, 5037, 562, 16, 70, "DefinitionBox",
      CellTags->"S2.8.7"],
    Cell[140517, 5055, 99, 1, 70, "Caption",
      CellTags->"S2.8.7"],
    Cell[140619, 5058, 80, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.2"}],
    Cell[140724, 5063, 94, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[140821, 5067, 108, 3, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[140944, 5073, 200, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.3"}],
    Cell[141169, 5084, 76, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[141248, 5088, 106, 2, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[141369, 5093, 380, 8, 70, "Text",
      CellTags->{"S2.8.7", "7.4"}],
    Cell[141752, 5103, 156, 4, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.5"}],
    Cell[141933, 5111, 90, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[142026, 5115, 105, 3, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[142146, 5121, 89, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.6"}],
    Cell[142260, 5126, 76, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[142339, 5130, 102, 2, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[142456, 5135, 941, 29, 70, "DefinitionBox",
      CellTags->"S2.8.7"],
    Cell[143400, 5166, 66, 1, 70, "Caption",
      CellTags->"S2.8.7"],
    Cell[143469, 5169, 133, 5, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.7"}],
    Cell[143627, 5178, 96, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[143726, 5182, 106, 3, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[143847, 5188, 191, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.8"}],
    Cell[144063, 5199, 76, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[144142, 5203, 104, 2, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[144261, 5208, 596, 12, 70, "Text",
      CellTags->{"S2.8.7", "7.9"}],
    Cell[144860, 5222, 127, 4, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.10"}],
    Cell[145012, 5230, 133, 3, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[145148, 5235, 148, 4, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[145311, 5242, 192, 6, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.11"}],
    Cell[145528, 5252, 122, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[145653, 5256, 371, 11, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[146039, 5270, 86, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.12"}],
    Cell[146150, 5275, 123, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[146276, 5279, 373, 11, 70, "Output",
      CellTags->"S2.8.7"],
    Cell[146664, 5293, 325, 7, 70, "Text",
      CellTags->{"S2.8.7", "7.13"}],
    Cell[146992, 5302, 405, 13, 70, "Text",
      CellTags->{"S2.8.7", "7.14"}],
    Cell[147400, 5317, 88, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.15"}],
    Cell[147491, 5320, 103, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[147597, 5324, 208, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.16"}],
    Cell[147830, 5335, 71, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[147904, 5339, 69, 1, 70, "Print",
      CellTags->"S2.8.7"],
    Cell[147988, 5343, 195, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.17"}],
    Cell[148186, 5352, 115, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[148304, 5356, 95, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.18"}],
    Cell[148424, 5361, 71, 2, 70, "Input",
      CellTags->"S2.8.7"],
    Cell[148498, 5365, 71, 4, 70, "Print",
      CellTags->"S2.8.7"]},
  "7.1"->{
    Cell[139846, 5034, 103, 1, 70, "Subsection",
      CellTags->{"S2.8.7", "7.1"}]},
  "7.2"->{
    Cell[140619, 5058, 80, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.2"}]},
  "7.3"->{
    Cell[140944, 5073, 200, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.3"}]},
  "7.4"->{
    Cell[141369, 5093, 380, 8, 70, "Text",
      CellTags->{"S2.8.7", "7.4"}]},
  "7.5"->{
    Cell[141752, 5103, 156, 4, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.5"}]},
  "7.6"->{
    Cell[142146, 5121, 89, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.6"}]},
  "7.7"->{
    Cell[143469, 5169, 133, 5, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.7"}]},
  "7.8"->{
    Cell[143847, 5188, 191, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.8"}]},
  "7.9"->{
    Cell[144261, 5208, 596, 12, 70, "Text",
      CellTags->{"S2.8.7", "7.9"}]},
  "7.10"->{
    Cell[144860, 5222, 127, 4, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.10"}]},
  "7.11"->{
    Cell[145311, 5242, 192, 6, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.11"}]},
  "7.12"->{
    Cell[146039, 5270, 86, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.12"}]},
  "7.13"->{
    Cell[146664, 5293, 325, 7, 70, "Text",
      CellTags->{"S2.8.7", "7.13"}]},
  "7.14"->{
    Cell[146992, 5302, 405, 13, 70, "Text",
      CellTags->{"S2.8.7", "7.14"}]},
  "7.15"->{
    Cell[147400, 5317, 88, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.15"}]},
  "7.16"->{
    Cell[147597, 5324, 208, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.16"}]},
  "7.17"->{
    Cell[147988, 5343, 195, 7, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.17"}]},
  "7.18"->{
    Cell[148304, 5356, 95, 1, 70, "MathCaption",
      CellTags->{"S2.8.7", "7.18"}]},
  "S2.8.8"->{
    Cell[148618, 5375, 90, 1, 70, "Subsection",
      CellTags->{"S2.8.8", "8.1"}],
    Cell[148711, 5378, 1539, 47, 70, "DefinitionBox",
      CellTags->"S2.8.8"],
    Cell[150253, 5427, 81, 1, 70, "Caption",
      CellTags->"S2.8.8"],
    Cell[150337, 5430, 268, 6, 70, "Text",
      CellTags->{"S2.8.8", "8.2"}],
    Cell[150608, 5438, 129, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.3"}],
    Cell[150762, 5446, 94, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[150859, 5450, 118, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[150992, 5456, 144, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.4"}],
    Cell[151161, 5464, 84, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[151248, 5468, 92, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[151355, 5474, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.5"}],
    Cell[151480, 5479, 148, 3, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[151631, 5484, 109, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[151755, 5490, 940, 28, 70, "DefinitionBox",
      CellTags->"S2.8.8"],
    Cell[152698, 5520, 77, 1, 70, "Caption",
      CellTags->"S2.8.8"],
    Cell[152778, 5523, 95, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.6"}],
    Cell[152898, 5528, 92, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[152993, 5532, 136, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[153144, 5538, 82, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.7"}],
    Cell[153251, 5543, 106, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[153360, 5547, 404, 7, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[153779, 5557, 347, 8, 70, "Text",
      CellTags->{"S2.8.8", "8.8"}],
    Cell[154129, 5567, 138, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.9"}],
    Cell[154292, 5575, 107, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[154402, 5579, 121, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[154538, 5585, 161, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.10"}],
    Cell[154724, 5593, 76, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[154803, 5597, 118, 2, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[154936, 5602, 470, 9, 70, "Text",
      CellTags->{"S2.8.8", "8.11"}],
    Cell[155409, 5613, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.12"}],
    Cell[155538, 5618, 119, 3, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[155660, 5623, 99, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[155774, 5629, 227, 6, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.13"}],
    Cell[156026, 5639, 76, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[156105, 5643, 92, 2, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[156212, 5648, 317, 8, 70, "Text",
      CellTags->{"S2.8.8", "8.14"}],
    Cell[156532, 5658, 168, 4, 70, "Text",
      CellTags->{"S2.8.8", "8.15"}],
    Cell[156703, 5664, 1235, 40, 70, "DefinitionBox",
      CellTags->"S2.8.8"],
    Cell[157941, 5706, 114, 4, 70, "Caption",
      CellTags->"S2.8.8"],
    Cell[158058, 5712, 520, 15, 70, "Text",
      CellTags->{"S2.8.8", "8.16"}],
    Cell[158581, 5729, 129, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.17"}],
    Cell[158735, 5737, 136, 5, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[158874, 5744, 553, 18, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[159442, 5765, 291, 9, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.18"}],
    Cell[159758, 5778, 93, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[159854, 5782, 110, 3, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[159979, 5788, 515, 9, 70, "Text",
      CellTags->{"S2.8.8", "8.19"}],
    Cell[160497, 5799, 3846, 102, 70, "DefinitionBox",
      CellTags->"S2.8.8"],
    Cell[164346, 5903, 138, 5, 70, "Caption",
      CellTags->"S2.8.8"],
    Cell[164487, 5910, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.20"}],
    Cell[164612, 5915, 98, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[164713, 5919, 183, 4, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[164911, 5926, 106, 3, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.21"}],
    Cell[165042, 5933, 99, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[165144, 5937, 897, 14, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[166056, 5954, 207, 5, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.22"}],
    Cell[166288, 5963, 101, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[166392, 5967, 582, 9, 70, "Output",
      CellTags->"S2.8.8"],
    Cell[166989, 5979, 91, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.23"}],
    Cell[167105, 5984, 103, 2, 70, "Input",
      CellTags->"S2.8.8"],
    Cell[167211, 5988, 274, 5, 70, "Output",
      CellTags->"S2.8.8"]},
  "8.1"->{
    Cell[148618, 5375, 90, 1, 70, "Subsection",
      CellTags->{"S2.8.8", "8.1"}]},
  "8.2"->{
    Cell[150337, 5430, 268, 6, 70, "Text",
      CellTags->{"S2.8.8", "8.2"}]},
  "8.3"->{
    Cell[150608, 5438, 129, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.3"}]},
  "8.4"->{
    Cell[150992, 5456, 144, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.4"}]},
  "8.5"->{
    Cell[151355, 5474, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.5"}]},
  "8.6"->{
    Cell[152778, 5523, 95, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.6"}]},
  "8.7"->{
    Cell[153144, 5538, 82, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.7"}]},
  "8.8"->{
    Cell[153779, 5557, 347, 8, 70, "Text",
      CellTags->{"S2.8.8", "8.8"}]},
  "8.9"->{
    Cell[154129, 5567, 138, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.9"}]},
  "8.10"->{
    Cell[154538, 5585, 161, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.10"}]},
  "8.11"->{
    Cell[154936, 5602, 470, 9, 70, "Text",
      CellTags->{"S2.8.8", "8.11"}]},
  "8.12"->{
    Cell[155409, 5613, 104, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.12"}]},
  "8.13"->{
    Cell[155774, 5629, 227, 6, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.13"}]},
  "8.14"->{
    Cell[156212, 5648, 317, 8, 70, "Text",
      CellTags->{"S2.8.8", "8.14"}]},
  "8.15"->{
    Cell[156532, 5658, 168, 4, 70, "Text",
      CellTags->{"S2.8.8", "8.15"}]},
  "8.16"->{
    Cell[158058, 5712, 520, 15, 70, "Text",
      CellTags->{"S2.8.8", "8.16"}]},
  "8.17"->{
    Cell[158581, 5729, 129, 4, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.17"}]},
  "8.18"->{
    Cell[159442, 5765, 291, 9, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.18"}]},
  "8.19"->{
    Cell[159979, 5788, 515, 9, 70, "Text",
      CellTags->{"S2.8.8", "8.19"}]},
  "8.20"->{
    Cell[164487, 5910, 100, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.20"}]},
  "8.21"->{
    Cell[164911, 5926, 106, 3, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.21"}]},
  "8.22"->{
    Cell[166056, 5954, 207, 5, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.22"}]},
  "8.23"->{
    Cell[166989, 5979, 91, 1, 70, "MathCaption",
      CellTags->{"S2.8.8", "8.23"}]},
  "S2.8.9"->{
    Cell[167534, 5999, 98, 1, 70, "Subsection",
      CellTags->{"S2.8.9", "9.1"}],
    Cell[167635, 6002, 429, 12, 70, "Text",
      CellTags->{"S2.8.9", "9.2"}],
    Cell[168067, 6016, 383, 7, 70, "Text",
      CellTags->{"S2.8.9", "9.3"}],
    Cell[168453, 6025, 1188, 37, 70, "DefinitionBox",
      CellTags->"S2.8.9"],
    Cell[169644, 6064, 77, 1, 70, "Caption",
      CellTags->"S2.8.9"],
    Cell[169724, 6067, 395, 8, 70, "Text",
      CellTags->{"S2.8.9", "9.4"}],
    Cell[170122, 6077, 449, 11, 70, "Text",
      CellTags->{"S2.8.9", "9.5"}],
    Cell[170574, 6090, 333, 8, 70, "Text",
      CellTags->{"S2.8.9", "9.6"}],
    Cell[170910, 6100, 346, 8, 70, "Text",
      CellTags->{"S2.8.9", "9.7"}],
    Cell[171259, 6110, 3090, 91, 70, "DefinitionBox",
      CellTags->"S2.8.9"],
    Cell[174352, 6203, 140, 5, 70, "Caption",
      CellTags->"S2.8.9"],
    Cell[174495, 6210, 212, 5, 70, "Text",
      CellTags->{"S2.8.9", "9.8"}],
    Cell[174710, 6217, 400, 9, 70, "Text",
      CellTags->{"S2.8.9", "9.9"}],
    Cell[175113, 6228, 354, 9, 70, "Text",
      CellTags->{"S2.8.9", "9.10"}],
    Cell[175470, 6239, 137, 5, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.11"}],
    Cell[175610, 6246, 116, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[175729, 6250, 159, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.12"}],
    Cell[175913, 6258, 69, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[175985, 6262, 80, 1, 70, "Print",
      CellTags->"S2.8.9"],
    Cell[176080, 6266, 193, 5, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.13"}],
    Cell[176298, 6275, 103, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[176404, 6279, 97, 3, 70, "Output",
      CellTags->"S2.8.9"],
    Cell[176516, 6285, 136, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.14"}],
    Cell[176655, 6291, 116, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[176774, 6295, 163, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.15"}],
    Cell[176962, 6303, 69, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[177034, 6307, 80, 1, 70, "Print",
      CellTags->"S2.8.9"],
    Cell[177129, 6311, 157, 5, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.16"}],
    Cell[177311, 6320, 89, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[177403, 6324, 85, 3, 70, "Output",
      CellTags->"S2.8.9"],
    Cell[177503, 6330, 145, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.17"}],
    Cell[177673, 6338, 115, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[177791, 6342, 120, 3, 70, "Output",
      CellTags->"S2.8.9"],
    Cell[177926, 6348, 438, 10, 70, "Text",
      CellTags->{"S2.8.9", "9.18"}],
    Cell[178367, 6360, 482, 13, 70, "Text",
      CellTags->{"S2.8.9", "9.19"}],
    Cell[178852, 6375, 507, 16, 70, "Text",
      CellTags->{"S2.8.9", "9.20"}],
    Cell[179362, 6393, 135, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.21"}],
    Cell[179522, 6401, 93, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[179618, 6405, 118, 3, 70, "Output",
      CellTags->"S2.8.9"],
    Cell[179751, 6411, 177, 5, 40, "MathCaption",
      CellTags->{"S2.8.9", "9.22"}],
    Cell[179953, 6420, 96, 2, 70, "Input",
      CellTags->"S2.8.9"],
    Cell[180052, 6424, 144, 4, 25, "Output",
      CellTags->"S2.8.9"],
    Cell[180211, 6431, 2778, 78, 180, "DefinitionBox",
      CellTags->"S2.8.9"],
    Cell[182992, 6511, 92, 1, 16, "Caption",
      CellTags->"S2.8.9"],
    Cell[183087, 6514, 167, 5, 40, "MathCaption",
      CellTags->{"S2.8.9", "9.23"}],
    Cell[183279, 6523, 105, 2, 28, "Input",
      CellTags->"S2.8.9"],
    Cell[183387, 6527, 104, 3, 25, "Output",
      CellTags->"S2.8.9"],
    Cell[183506, 6533, 149, 4, 56, "MathCaption",
      CellTags->{"S2.8.9", "9.24"}],
    Cell[183680, 6541, 125, 2, 28, "Input",
      CellTags->"S2.8.9"],
    Cell[183808, 6545, 104, 3, 25, "Output",
      CellTags->"S2.8.9"],
    Cell[183927, 6551, 210, 6, 56, "MathCaption",
      CellTags->{"S2.8.9", "9.25"}],
    Cell[184162, 6561, 122, 2, 28, "Input",
      CellTags->"S2.8.9"],
    Cell[184287, 6565, 105, 3, 25, "Output",
      CellTags->"S2.8.9"],
    Cell[184407, 6571, 682, 18, 88, "Text",
      CellTags->{"S2.8.9", "9.26"}]},
  "9.1"->{
    Cell[167534, 5999, 98, 1, 70, "Subsection",
      CellTags->{"S2.8.9", "9.1"}]},
  "9.2"->{
    Cell[167635, 6002, 429, 12, 70, "Text",
      CellTags->{"S2.8.9", "9.2"}]},
  "9.3"->{
    Cell[168067, 6016, 383, 7, 70, "Text",
      CellTags->{"S2.8.9", "9.3"}]},
  "9.4"->{
    Cell[169724, 6067, 395, 8, 70, "Text",
      CellTags->{"S2.8.9", "9.4"}]},
  "9.5"->{
    Cell[170122, 6077, 449, 11, 70, "Text",
      CellTags->{"S2.8.9", "9.5"}]},
  "9.6"->{
    Cell[170574, 6090, 333, 8, 70, "Text",
      CellTags->{"S2.8.9", "9.6"}]},
  "9.7"->{
    Cell[170910, 6100, 346, 8, 70, "Text",
      CellTags->{"S2.8.9", "9.7"}]},
  "9.8"->{
    Cell[174495, 6210, 212, 5, 70, "Text",
      CellTags->{"S2.8.9", "9.8"}]},
  "9.9"->{
    Cell[174710, 6217, 400, 9, 70, "Text",
      CellTags->{"S2.8.9", "9.9"}]},
  "9.10"->{
    Cell[175113, 6228, 354, 9, 70, "Text",
      CellTags->{"S2.8.9", "9.10"}]},
  "9.11"->{
    Cell[175470, 6239, 137, 5, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.11"}]},
  "9.12"->{
    Cell[175729, 6250, 159, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.12"}]},
  "9.13"->{
    Cell[176080, 6266, 193, 5, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.13"}]},
  "9.14"->{
    Cell[176516, 6285, 136, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.14"}]},
  "9.15"->{
    Cell[176774, 6295, 163, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.15"}]},
  "9.16"->{
    Cell[177129, 6311, 157, 5, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.16"}]},
  "9.17"->{
    Cell[177503, 6330, 145, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.17"}]},
  "9.18"->{
    Cell[177926, 6348, 438, 10, 70, "Text",
      CellTags->{"S2.8.9", "9.18"}]},
  "9.19"->{
    Cell[178367, 6360, 482, 13, 70, "Text",
      CellTags->{"S2.8.9", "9.19"}]},
  "9.20"->{
    Cell[178852, 6375, 507, 16, 70, "Text",
      CellTags->{"S2.8.9", "9.20"}]},
  "9.21"->{
    Cell[179362, 6393, 135, 4, 70, "MathCaption",
      CellTags->{"S2.8.9", "9.21"}]},
  "9.22"->{
    Cell[179751, 6411, 177, 5, 40, "MathCaption",
      CellTags->{"S2.8.9", "9.22"}]},
  "9.23"->{
    Cell[183087, 6514, 167, 5, 40, "MathCaption",
      CellTags->{"S2.8.9", "9.23"}]},
  "9.24"->{
    Cell[183506, 6533, 149, 4, 56, "MathCaption",
      CellTags->{"S2.8.9", "9.24"}]},
  "9.25"->{
    Cell[183927, 6551, 210, 6, 56, "MathCaption",
      CellTags->{"S2.8.9", "9.25"}]},
  "9.26"->{
    Cell[184407, 6571, 682, 18, 88, "Text",
      CellTags->{"S2.8.9", "9.26"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.8.0", 185732, 6609},
  {"0.1", 185822, 6612},
  {"S2.8.1", 185915, 6615},
  {"1.1", 188437, 6684},
  {"1.2", 188529, 6687},
  {"1.3", 188616, 6690},
  {"1.4", 188703, 6693},
  {"1.5", 188791, 6696},
  {"1.6", 188886, 6699},
  {"1.7", 188981, 6702},
  {"1.8", 189069, 6705},
  {"1.9", 189164, 6708},
  {"1.10", 189253, 6711},
  {"1.11", 189350, 6714},
  {"1.12", 189440, 6717},
  {"1.13", 189537, 6720},
  {"1.14", 189634, 6723},
  {"1.15", 189724, 6726},
  {"1.16", 189821, 6729},
  {"S2.8.2", 189920, 6732},
  {"2.1", 198197, 6953},
  {"2.2", 198290, 6956},
  {"2.3", 198378, 6959},
  {"2.4", 198473, 6962},
  {"2.5", 198569, 6965},
  {"2.6", 198665, 6968},
  {"2.7", 198755, 6971},
  {"2.8", 198850, 6974},
  {"2.9", 198946, 6977},
  {"2.10", 199043, 6980},
  {"2.11", 199141, 6983},
  {"2.12", 199233, 6986},
  {"2.13", 199331, 6989},
  {"2.14", 199429, 6992},
  {"2.15", 199527, 6995},
  {"2.16", 199625, 6998},
  {"2.17", 199723, 7001},
  {"2.18", 199821, 7004},
  {"2.19", 199914, 7007},
  {"2.20", 200013, 7010},
  {"2.21", 200112, 7013},
  {"2.22", 200211, 7016},
  {"2.23", 200309, 7019},
  {"2.24", 200408, 7022},
  {"2.25", 200507, 7025},
  {"2.26", 200607, 7028},
  {"2.27", 200706, 7031},
  {"2.28", 200798, 7034},
  {"2.29", 200897, 7037},
  {"2.30", 200996, 7040},
  {"2.31", 201095, 7043},
  {"2.32", 201194, 7046},
  {"2.33", 201292, 7049},
  {"2.34", 201391, 7052},
  {"S2.8.3", 201492, 7055},
  {"3.1", 204515, 7136},
  {"3.2", 204610, 7139},
  {"3.3", 204707, 7142},
  {"3.4", 204804, 7145},
  {"3.5", 204901, 7148},
  {"3.6", 204998, 7151},
  {"3.7", 205095, 7154},
  {"3.8", 205191, 7157},
  {"3.9", 205288, 7160},
  {"3.10", 205386, 7163},
  {"3.11", 205484, 7166},
  {"3.12", 205576, 7169},
  {"S2.8.4", 205677, 7172},
  {"4.1", 217218, 7477},
  {"4.2", 217313, 7480},
  {"4.3", 217403, 7483},
  {"4.4", 217500, 7486},
  {"4.5", 217597, 7489},
  {"4.6", 217687, 7492},
  {"4.7", 217784, 7495},
  {"4.8", 217881, 7498},
  {"4.9", 217978, 7501},
  {"4.10", 218076, 7504},
  {"4.11", 218175, 7507},
  {"4.12", 218267, 7510},
  {"4.13", 218366, 7513},
  {"4.14", 218465, 7516},
  {"4.15", 218564, 7519},
  {"4.16", 218662, 7522},
  {"4.17", 218761, 7525},
  {"4.18", 218860, 7528},
  {"4.19", 218954, 7531},
  {"4.20", 219052, 7534},
  {"4.21", 219150, 7537},
  {"4.22", 219249, 7540},
  {"4.23", 219341, 7543},
  {"4.24", 219440, 7546},
  {"4.25", 219539, 7549},
  {"4.26", 219638, 7552},
  {"4.27", 219736, 7555},
  {"4.28", 219834, 7558},
  {"4.29", 219926, 7561},
  {"4.30", 220025, 7564},
  {"4.31", 220123, 7567},
  {"4.32", 220222, 7570},
  {"4.33", 220321, 7573},
  {"4.34", 220413, 7576},
  {"4.35", 220512, 7579},
  {"4.36", 220611, 7582},
  {"4.37", 220703, 7585},
  {"4.38", 220802, 7588},
  {"4.39", 220901, 7591},
  {"4.40", 221000, 7594},
  {"4.41", 221099, 7597},
  {"4.42", 221191, 7600},
  {"4.43", 221290, 7603},
  {"4.44", 221383, 7606},
  {"4.45", 221482, 7609},
  {"4.46", 221581, 7612},
  {"4.47", 221674, 7615},
  {"4.48", 221773, 7618},
  {"4.49", 221866, 7621},
  {"4.50", 221965, 7624},
  {"4.51", 222064, 7627},
  {"4.52", 222164, 7630},
  {"4.53", 222263, 7633},
  {"4.54", 222363, 7636},
  {"S2.8.5", 222465, 7639},
  {"5.1", 226791, 7752},
  {"5.2", 226887, 7755},
  {"5.3", 226979, 7758},
  {"5.4", 227077, 7761},
  {"5.5", 227175, 7764},
  {"5.6", 227273, 7767},
  {"5.7", 227364, 7770},
  {"5.8", 227462, 7773},
  {"5.9", 227560, 7776},
  {"5.10", 227652, 7779},
  {"5.11", 227745, 7782},
  {"5.12", 227845, 7785},
  {"5.13", 227945, 7788},
  {"5.14", 228039, 7791},
  {"5.15", 228139, 7794},
  {"5.16", 228238, 7797},
  {"5.17", 228332, 7800},
  {"5.18", 228432, 7803},
  {"5.19", 228532, 7806},
  {"5.20", 228632, 7809},
  {"S2.8.6", 228734, 7812},
  {"6.1", 231972, 7897},
  {"6.2", 232068, 7900},
  {"6.3", 232159, 7903},
  {"6.4", 232257, 7906},
  {"6.5", 232355, 7909},
  {"6.6", 232453, 7912},
  {"6.7", 232545, 7915},
  {"6.8", 232636, 7918},
  {"6.9", 232734, 7921},
  {"6.10", 232833, 7924},
  {"6.11", 232926, 7927},
  {"6.12", 233019, 7930},
  {"6.13", 233119, 7933},
  {"6.14", 233219, 7936},
  {"6.15", 233319, 7939},
  {"6.16", 233419, 7942},
  {"6.17", 233519, 7945},
  {"S2.8.7", 233621, 7948},
  {"7.1", 237167, 8041},
  {"7.2", 237264, 8044},
  {"7.3", 237361, 8047},
  {"7.4", 237459, 8050},
  {"7.5", 237550, 8053},
  {"7.6", 237648, 8056},
  {"7.7", 237745, 8059},
  {"7.8", 237843, 8062},
  {"7.9", 237941, 8065},
  {"7.10", 238034, 8068},
  {"7.11", 238134, 8071},
  {"7.12", 238234, 8074},
  {"7.13", 238333, 8077},
  {"7.14", 238426, 8080},
  {"7.15", 238520, 8083},
  {"7.16", 238619, 8086},
  {"7.17", 238719, 8089},
  {"7.18", 238819, 8092},
  {"S2.8.8", 238920, 8095},
  {"8.1", 243621, 8218},
  {"8.2", 243717, 8221},
  {"8.3", 243808, 8224},
  {"8.4", 243906, 8227},
  {"8.5", 244004, 8230},
  {"8.6", 244102, 8233},
  {"8.7", 244199, 8236},
  {"8.8", 244296, 8239},
  {"8.9", 244387, 8242},
  {"8.10", 244486, 8245},
  {"8.11", 244586, 8248},
  {"8.12", 244679, 8251},
  {"8.13", 244779, 8254},
  {"8.14", 244879, 8257},
  {"8.15", 244972, 8260},
  {"8.16", 245065, 8263},
  {"8.17", 245159, 8266},
  {"8.18", 245259, 8269},
  {"8.19", 245359, 8272},
  {"8.20", 245452, 8275},
  {"8.21", 245552, 8278},
  {"8.22", 245652, 8281},
  {"8.23", 245752, 8284},
  {"S2.8.9", 245853, 8287},
  {"9.1", 250053, 8396},
  {"9.2", 250149, 8399},
  {"9.3", 250241, 8402},
  {"9.4", 250332, 8405},
  {"9.5", 250423, 8408},
  {"9.6", 250515, 8411},
  {"9.7", 250606, 8414},
  {"9.8", 250697, 8417},
  {"9.9", 250788, 8420},
  {"9.10", 250880, 8423},
  {"9.11", 250973, 8426},
  {"9.12", 251073, 8429},
  {"9.13", 251173, 8432},
  {"9.14", 251273, 8435},
  {"9.15", 251373, 8438},
  {"9.16", 251473, 8441},
  {"9.17", 251573, 8444},
  {"9.18", 251673, 8447},
  {"9.19", 251767, 8450},
  {"9.20", 251861, 8453},
  {"9.21", 251955, 8456},
  {"9.22", 252055, 8459},
  {"9.23", 252155, 8462},
  {"9.24", 252255, 8465},
  {"9.25", 252355, 8468},
  {"9.26", 252455, 8471}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 125, 4, 65, "Section",
  CellTags->{"S2.8.0", "0.1"}],

Cell[CellGroupData[{
Cell[1926, 61, 80, 1, 70, "Subsection",
  CellTags->{"S2.8.1", "1.1"}],
Cell[2009, 64, 293, 8, 70, "Text",
  CellTags->{"S2.8.1", "1.2"}],
Cell[2305, 74, 422, 12, 70, "DefinitionBox",
  CellTags->"S2.8.1"],
Cell[2730, 88, 55, 1, 70, "Caption",
  CellTags->"S2.8.1"],
Cell[2788, 91, 298, 7, 70, "Text",
  CellTags->{"S2.8.1", "1.3"}],
Cell[3089, 100, 284, 7, 70, "Text",
  CellTags->{"S2.8.1", "1.4"}],
Cell[3376, 109, 181, 5, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.5"}],

Cell[CellGroupData[{
Cell[3582, 118, 85, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[3670, 122, 100, 3, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[3785, 128, 141, 4, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.6"}],

Cell[CellGroupData[{
Cell[3951, 136, 76, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[4030, 140, 97, 2, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[4142, 145, 270, 7, 70, "Text",
  CellTags->{"S2.8.1", "1.7"}],
Cell[4415, 154, 114, 2, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.8"}],

Cell[CellGroupData[{
Cell[4554, 160, 100, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[4657, 164, 202, 5, 70, "Print",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[4874, 172, 299, 9, 70, "Text",
  CellTags->{"S2.8.1", "1.9"}],
Cell[5176, 183, 177, 7, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.10"}],

Cell[CellGroupData[{
Cell[5378, 194, 75, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[5456, 198, 86, 3, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[5557, 204, 218, 6, 70, "Text",
  CellTags->{"S2.8.1", "1.11"}],
Cell[5778, 212, 129, 5, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.12"}],

Cell[CellGroupData[{
Cell[5932, 221, 75, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[6010, 225, 87, 3, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[6112, 231, 139, 5, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.13"}],

Cell[CellGroupData[{
Cell[6276, 240, 101, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[6380, 244, 92, 3, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[6487, 250, 219, 5, 70, "Text",
  CellTags->{"S2.8.1", "1.14"}],
Cell[6709, 257, 131, 4, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.15"}],

Cell[CellGroupData[{
Cell[6865, 265, 80, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[6948, 269, 83, 3, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]],
Cell[7046, 275, 195, 7, 70, "MathCaption",
  CellTags->{"S2.8.1", "1.16"}],

Cell[CellGroupData[{
Cell[7266, 286, 112, 2, 70, "Input",
  CellTags->"S2.8.1"],
Cell[7381, 290, 100, 3, 70, "Output",
  CellTags->"S2.8.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7530, 299, 80, 1, 70, "Subsection",
  CellTags->{"S2.8.2", "2.1"}],
Cell[7613, 302, 313, 6, 70, "Text",
  CellTags->{"S2.8.2", "2.2"}],
Cell[7929, 310, 1897, 53, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[9829, 365, 73, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[9905, 368, 152, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.3"}],

Cell[CellGroupData[{
Cell[10082, 377, 104, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[10189, 381, 103, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[10307, 387, 149, 4, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.4"}],

Cell[CellGroupData[{
Cell[10481, 395, 79, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[10563, 399, 83, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[10661, 405, 143, 4, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.5"}],

Cell[CellGroupData[{
Cell[10829, 413, 92, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[10924, 417, 92, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[11031, 423, 4198, 124, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[15232, 549, 73, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[15308, 552, 604, 20, 70, "Text",
  CellTags->{"S2.8.2", "2.6"}],
Cell[15915, 574, 79, 1, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.7"}],

Cell[CellGroupData[{
Cell[16019, 579, 102, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[16124, 583, 109, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[16248, 589, 147, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.8"}],

Cell[CellGroupData[{
Cell[16420, 598, 84, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[16507, 602, 88, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[16610, 608, 136, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.9"}],

Cell[CellGroupData[{
Cell[16771, 617, 86, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[16860, 621, 84, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[16959, 627, 142, 4, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.10"}],

Cell[CellGroupData[{
Cell[17126, 635, 92, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[17221, 639, 100, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[17336, 645, 1920, 60, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[19259, 707, 66, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[19328, 710, 466, 18, 70, "Text",
  CellTags->{"S2.8.2", "2.11"}],
Cell[19797, 730, 196, 6, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.12"}],

Cell[CellGroupData[{
Cell[20018, 740, 101, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[20122, 744, 93, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[20230, 750, 116, 2, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.13"}],

Cell[CellGroupData[{
Cell[20371, 756, 103, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[20477, 760, 94, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[20586, 766, 182, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.14"}],

Cell[CellGroupData[{
Cell[20793, 775, 112, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[20908, 779, 101, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[21024, 785, 4914, 144, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[25941, 931, 70, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[26014, 934, 159, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.15"}],

Cell[CellGroupData[{
Cell[26198, 943, 113, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[26314, 947, 90, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[26419, 953, 159, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.16"}],

Cell[CellGroupData[{
Cell[26603, 962, 124, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[26730, 966, 92, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[26837, 972, 131, 4, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.17"}],

Cell[CellGroupData[{
Cell[26993, 980, 146, 5, 70, "Input",
  CellTags->"S2.8.2"],
Cell[27142, 987, 93, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[27250, 993, 2535, 76, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[29788, 1071, 74, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[29865, 1074, 615, 16, 70, "Text",
  CellTags->{"S2.8.2", "2.18"}],
Cell[30483, 1092, 160, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.19"}],

Cell[CellGroupData[{
Cell[30668, 1101, 110, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[30781, 1105, 118, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[30914, 1111, 148, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.20"}],

Cell[CellGroupData[{
Cell[31087, 1120, 113, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[31203, 1124, 90, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[31308, 1130, 211, 7, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.21"}],

Cell[CellGroupData[{
Cell[31544, 1141, 114, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[31661, 1145, 123, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[31799, 1151, 87, 1, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.22"}],

Cell[CellGroupData[{
Cell[31911, 1156, 143, 5, 70, "Input",
  CellTags->"S2.8.2"],
Cell[32057, 1163, 107, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[32179, 1169, 3554, 108, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[35736, 1279, 65, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[35804, 1282, 145, 4, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.23"}],

Cell[CellGroupData[{
Cell[35974, 1290, 111, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[36088, 1294, 83, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[36186, 1300, 4239, 131, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[40428, 1433, 82, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[40513, 1436, 194, 7, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.24"}],

Cell[CellGroupData[{
Cell[40732, 1447, 117, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[40852, 1451, 105, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[40972, 1457, 221, 11, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.25"}],

Cell[CellGroupData[{
Cell[41218, 1472, 148, 5, 70, "Input",
  CellTags->"S2.8.2"],
Cell[41369, 1479, 98, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[41482, 1485, 201, 7, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.26"}],

Cell[CellGroupData[{
Cell[41708, 1496, 136, 3, 70, "Input",
  CellTags->"S2.8.2"],
Cell[41847, 1501, 92, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[41954, 1507, 400, 9, 70, "Text",
  CellTags->{"S2.8.2", "2.27"}],
Cell[42357, 1518, 162, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.28"}],

Cell[CellGroupData[{
Cell[42544, 1527, 109, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[42656, 1531, 127, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[42798, 1537, 117, 2, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.29"}],

Cell[CellGroupData[{
Cell[42940, 1543, 148, 5, 70, "Input",
  CellTags->"S2.8.2"],
Cell[43091, 1550, 124, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[43230, 1556, 2601, 80, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[45834, 1638, 60, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[45897, 1641, 102, 1, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.30"}],

Cell[CellGroupData[{
Cell[46024, 1646, 97, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[46124, 1650, 113, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[46252, 1656, 127, 5, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.31"}],

Cell[CellGroupData[{
Cell[46404, 1665, 105, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[46512, 1669, 106, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[46633, 1675, 91, 1, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.32"}],

Cell[CellGroupData[{
Cell[46749, 1680, 113, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[46865, 1684, 166, 4, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[47046, 1691, 2769, 82, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[49818, 1775, 93, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[49914, 1778, 197, 9, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.33"}],

Cell[CellGroupData[{
Cell[50136, 1791, 113, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[50252, 1795, 122, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]],
Cell[50389, 1801, 1183, 34, 70, "DefinitionBox",
  CellTags->"S2.8.2"],
Cell[51575, 1837, 58, 1, 70, "Caption",
  CellTags->"S2.8.2"],
Cell[51636, 1840, 144, 4, 70, "MathCaption",
  CellTags->{"S2.8.2", "2.34"}],

Cell[CellGroupData[{
Cell[51805, 1848, 112, 2, 70, "Input",
  CellTags->"S2.8.2"],
Cell[51920, 1852, 115, 3, 70, "Output",
  CellTags->"S2.8.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52084, 1861, 80, 1, 70, "Subsection",
  CellTags->{"S2.8.3", "3.1"}],
Cell[52167, 1864, 1234, 34, 70, "DefinitionBox",
  CellTags->"S2.8.3"],
Cell[53404, 1900, 93, 1, 70, "Caption",
  CellTags->"S2.8.3"],
Cell[53500, 1903, 105, 1, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.2"}],

Cell[CellGroupData[{
Cell[53630, 1908, 89, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[53722, 1912, 126, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[53863, 1918, 130, 4, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.3"}],

Cell[CellGroupData[{
Cell[54018, 1926, 80, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[54101, 1930, 126, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[54242, 1936, 160, 4, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.4"}],

Cell[CellGroupData[{
Cell[54427, 1944, 77, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[54507, 1948, 92, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[54614, 1954, 1286, 40, 70, "DefinitionBox",
  CellTags->"S2.8.3"],
Cell[55903, 1996, 73, 1, 70, "Caption",
  CellTags->"S2.8.3"],
Cell[55979, 1999, 102, 1, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.5"}],

Cell[CellGroupData[{
Cell[56106, 2004, 82, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[56191, 2008, 85, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[56291, 2014, 158, 5, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.6"}],

Cell[CellGroupData[{
Cell[56474, 2023, 85, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[56562, 2027, 86, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[56663, 2033, 726, 20, 70, "DefinitionBox",
  CellTags->"S2.8.3"],
Cell[57392, 2055, 82, 1, 70, "Caption",
  CellTags->"S2.8.3"],
Cell[57477, 2058, 95, 1, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.7"}],

Cell[CellGroupData[{
Cell[57597, 2063, 91, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[57691, 2067, 93, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[57799, 2073, 1374, 38, 70, "DefinitionBox",
  CellTags->"S2.8.3"],
Cell[59176, 2113, 74, 1, 70, "Caption",
  CellTags->"S2.8.3"],
Cell[59253, 2116, 139, 4, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.8"}],

Cell[CellGroupData[{
Cell[59417, 2124, 92, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[59512, 2128, 121, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[59648, 2134, 108, 3, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.9"}],

Cell[CellGroupData[{
Cell[59781, 2141, 92, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[59876, 2145, 116, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[60007, 2151, 77, 1, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.10"}],

Cell[CellGroupData[{
Cell[60109, 2156, 92, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[60204, 2160, 121, 3, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]],
Cell[60340, 2166, 371, 9, 70, "Text",
  CellTags->{"S2.8.3", "3.11"}],
Cell[60714, 2177, 184, 5, 70, "MathCaption",
  CellTags->{"S2.8.3", "3.12"}],

Cell[CellGroupData[{
Cell[60923, 2186, 93, 2, 70, "Input",
  CellTags->"S2.8.3"],
Cell[61019, 2190, 180, 4, 70, "Output",
  CellTags->"S2.8.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[61248, 2200, 74, 1, 70, "Subsection",
  CellTags->{"S2.8.4", "4.1"}],
Cell[61325, 2203, 257, 6, 70, "Text",
  CellTags->{"S2.8.4", "4.2"}],
Cell[61585, 2211, 181, 9, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.3"}],

Cell[CellGroupData[{
Cell[61791, 2224, 116, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[61910, 2228, 92, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[62017, 2234, 132, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.4"}],

Cell[CellGroupData[{
Cell[62174, 2243, 104, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[62281, 2247, 92, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[62388, 2253, 263, 7, 70, "Text",
  CellTags->{"S2.8.4", "4.5"}],
Cell[62654, 2262, 1455, 41, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[64112, 2305, 61, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[64176, 2308, 190, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.6"}],

Cell[CellGroupData[{
Cell[64391, 2317, 75, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[64469, 2321, 90, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[64574, 2327, 132, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.7"}],

Cell[CellGroupData[{
Cell[64731, 2335, 118, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[64852, 2339, 90, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[64957, 2345, 5435, 170, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[70395, 2517, 81, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[70479, 2520, 127, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.8"}],

Cell[CellGroupData[{
Cell[70631, 2528, 107, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[70741, 2532, 102, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[70858, 2538, 161, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.9"}],

Cell[CellGroupData[{
Cell[71044, 2547, 113, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[71160, 2551, 96, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[71271, 2557, 117, 2, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.10"}],

Cell[CellGroupData[{
Cell[71413, 2563, 108, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[71524, 2567, 117, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[71656, 2573, 345, 9, 70, "Text",
  CellTags->{"S2.8.4", "4.11"}],
Cell[72004, 2584, 149, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.12"}],

Cell[CellGroupData[{
Cell[72178, 2593, 129, 3, 70, "Input",
  CellTags->"S2.8.4"],
Cell[72310, 2598, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[72425, 2604, 168, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.13"}],

Cell[CellGroupData[{
Cell[72618, 2613, 130, 3, 70, "Input",
  CellTags->"S2.8.4"],
Cell[72751, 2618, 99, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[72865, 2624, 170, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.14"}],

Cell[CellGroupData[{
Cell[73060, 2633, 132, 3, 70, "Input",
  CellTags->"S2.8.4"],
Cell[73195, 2638, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[73310, 2644, 5292, 158, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[78605, 2804, 69, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[78677, 2807, 99, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.15"}],

Cell[CellGroupData[{
Cell[78801, 2812, 104, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[78908, 2816, 102, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[79025, 2822, 171, 7, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.16"}],

Cell[CellGroupData[{
Cell[79221, 2833, 115, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[79339, 2837, 99, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[79453, 2843, 110, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.17"}],

Cell[CellGroupData[{
Cell[79588, 2848, 114, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[79705, 2852, 99, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[79819, 2858, 1000, 37, 70, "Text",
  CellTags->{"S2.8.4", "4.18"}],
Cell[80822, 2897, 88, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.19"}],

Cell[CellGroupData[{
Cell[80935, 2902, 86, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[81024, 2906, 107, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[81146, 2912, 91, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.20"}],

Cell[CellGroupData[{
Cell[81262, 2917, 127, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[81392, 2921, 97, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[81504, 2927, 183, 7, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.21"}],

Cell[CellGroupData[{
Cell[81712, 2938, 93, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[81808, 2942, 122, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[81945, 2948, 263, 6, 70, "Text",
  CellTags->{"S2.8.4", "4.22"}],
Cell[82211, 2956, 4565, 132, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[86779, 3090, 83, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[86865, 3093, 104, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.23"}],

Cell[CellGroupData[{
Cell[86994, 3098, 109, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[87106, 3102, 112, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[87233, 3108, 100, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.24"}],

Cell[CellGroupData[{
Cell[87358, 3113, 117, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[87478, 3117, 107, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[87600, 3123, 102, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.25"}],

Cell[CellGroupData[{
Cell[87727, 3128, 110, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[87840, 3132, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[87955, 3138, 80, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.26"}],

Cell[CellGroupData[{
Cell[88060, 3143, 77, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[88140, 3147, 101, 2, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[88256, 3152, 93, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.27"}],

Cell[CellGroupData[{
Cell[88374, 3157, 84, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[88461, 3161, 94, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[88570, 3167, 290, 6, 70, "Text",
  CellTags->{"S2.8.4", "4.28"}],
Cell[88863, 3175, 143, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.29"}],

Cell[CellGroupData[{
Cell[89031, 3184, 120, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[89154, 3188, 99, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[89268, 3194, 85, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.30"}],

Cell[CellGroupData[{
Cell[89378, 3199, 127, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[89508, 3203, 97, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[89620, 3209, 213, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.31"}],

Cell[CellGroupData[{
Cell[89858, 3218, 163, 5, 70, "Input",
  CellTags->"S2.8.4"],
Cell[90024, 3225, 113, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[90152, 3231, 153, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.32"}],

Cell[CellGroupData[{
Cell[90330, 3239, 82, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[90415, 3243, 128, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[90558, 3249, 381, 9, 70, "Text",
  CellTags->{"S2.8.4", "4.33"}],
Cell[90942, 3260, 100, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.34"}],

Cell[CellGroupData[{
Cell[91067, 3265, 113, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[91183, 3269, 90, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[91288, 3275, 114, 2, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.35"}],

Cell[CellGroupData[{
Cell[91427, 3281, 114, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[91544, 3285, 93, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[91652, 3291, 390, 8, 70, "Text",
  CellTags->{"S2.8.4", "4.36"}],
Cell[92045, 3301, 1106, 30, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[93154, 3333, 96, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[93253, 3336, 152, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.37"}],

Cell[CellGroupData[{
Cell[93430, 3345, 116, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[93549, 3349, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[93664, 3355, 175, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.38"}],

Cell[CellGroupData[{
Cell[93864, 3364, 135, 3, 70, "Input",
  CellTags->"S2.8.4"],
Cell[94002, 3369, 98, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[94115, 3375, 155, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.39"}],

Cell[CellGroupData[{
Cell[94295, 3384, 113, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[94411, 3388, 92, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[94518, 3394, 137, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.40"}],

Cell[CellGroupData[{
Cell[94680, 3402, 155, 5, 70, "Input",
  CellTags->"S2.8.4"],
Cell[94838, 3409, 93, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[94946, 3415, 217, 7, 70, "Text",
  CellTags->{"S2.8.4", "4.41"}],
Cell[95166, 3424, 130, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.42"}],

Cell[CellGroupData[{
Cell[95321, 3432, 116, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[95440, 3436, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[95555, 3442, 575, 17, 70, "Text",
  CellTags->{"S2.8.4", "4.43"}],
Cell[96133, 3461, 850, 26, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[96986, 3489, 92, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[97081, 3492, 148, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.44"}],

Cell[CellGroupData[{
Cell[97254, 3500, 120, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[97377, 3504, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[97492, 3510, 175, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.45"}],

Cell[CellGroupData[{
Cell[97692, 3518, 145, 5, 70, "Input",
  CellTags->"S2.8.4"],
Cell[97840, 3525, 104, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[97959, 3531, 515, 17, 70, "Text",
  CellTags->{"S2.8.4", "4.46"}],
Cell[98477, 3550, 522, 18, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[99002, 3570, 106, 4, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[99111, 3576, 162, 5, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.47"}],

Cell[CellGroupData[{
Cell[99298, 3585, 151, 5, 70, "Input",
  CellTags->"S2.8.4"],
Cell[99452, 3592, 99, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[99566, 3598, 338, 10, 70, "Text",
  CellTags->{"S2.8.4", "4.48"}],
Cell[99907, 3610, 142, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.49"}],

Cell[CellGroupData[{
Cell[100074, 3618, 97, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[100174, 3622, 100, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[100289, 3628, 83, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.50"}],

Cell[CellGroupData[{
Cell[100397, 3633, 115, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[100515, 3637, 118, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[100648, 3643, 138, 4, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.51"}],

Cell[CellGroupData[{
Cell[100811, 3651, 100, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[100914, 3655, 130, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[101059, 3661, 995, 31, 70, "DefinitionBox",
  CellTags->"S2.8.4"],
Cell[102057, 3694, 83, 1, 70, "Caption",
  CellTags->"S2.8.4"],
Cell[102143, 3697, 88, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.52"}],

Cell[CellGroupData[{
Cell[102256, 3702, 109, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[102368, 3706, 90, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[102473, 3712, 104, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.53"}],

Cell[CellGroupData[{
Cell[102602, 3717, 108, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[102713, 3721, 108, 3, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]],
Cell[102836, 3727, 103, 1, 70, "MathCaption",
  CellTags->{"S2.8.4", "4.54"}],

Cell[CellGroupData[{
Cell[102964, 3732, 107, 2, 70, "Input",
  CellTags->"S2.8.4"],
Cell[103074, 3736, 149, 4, 70, "Output",
  CellTags->"S2.8.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103272, 3746, 94, 1, 70, "Subsection",
  CellTags->{"S2.8.5", "5.1"}],
Cell[103369, 3749, 510, 14, 70, "Text",
  CellTags->{"S2.8.5", "5.2"}],
Cell[103882, 3765, 611, 18, 70, "DefinitionBox",
  CellTags->"S2.8.5"],
Cell[104496, 3785, 135, 5, 70, "Caption",
  CellTags->"S2.8.5"],
Cell[104634, 3792, 167, 7, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.3"}],

Cell[CellGroupData[{
Cell[104826, 3803, 141, 5, 70, "Input",
  CellTags->"S2.8.5"],
Cell[104970, 3810, 96, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[105081, 3816, 176, 5, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.4"}],

Cell[CellGroupData[{
Cell[105282, 3825, 117, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[105402, 3829, 96, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[105513, 3835, 109, 1, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.5"}],

Cell[CellGroupData[{
Cell[105647, 3840, 146, 5, 70, "Input",
  CellTags->"S2.8.5"],
Cell[105796, 3847, 92, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[105903, 3853, 199, 6, 70, "Text",
  CellTags->{"S2.8.5", "5.6"}],
Cell[106105, 3861, 7285, 215, 70, "DefinitionBox",
  CellTags->"S2.8.5"],
Cell[113393, 4078, 138, 5, 70, "Caption",
  CellTags->"S2.8.5"],
Cell[113534, 4085, 131, 4, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.7"}],

Cell[CellGroupData[{
Cell[113690, 4093, 129, 3, 70, "Input",
  CellTags->"S2.8.5"],
Cell[113822, 4098, 105, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[113942, 4104, 170, 5, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.8"}],

Cell[CellGroupData[{
Cell[114137, 4113, 116, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[114256, 4117, 105, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[114376, 4123, 225, 6, 70, "Text",
  CellTags->{"S2.8.5", "5.9"}],
Cell[114604, 4131, 7643, 227, 70, "DefinitionBox",
  CellTags->"S2.8.5"],
Cell[122250, 4360, 133, 4, 70, "Caption",
  CellTags->"S2.8.5"],
Cell[122386, 4366, 413, 9, 70, "Text",
  CellTags->{"S2.8.5", "5.10"}],
Cell[122802, 4377, 2455, 74, 70, "DefinitionBox",
  CellTags->"S2.8.5"],
Cell[125260, 4453, 97, 1, 70, "Caption",
  CellTags->"S2.8.5"],
Cell[125360, 4456, 161, 5, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.11"}],

Cell[CellGroupData[{
Cell[125546, 4465, 125, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[125674, 4469, 101, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[125790, 4475, 170, 5, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.12"}],

Cell[CellGroupData[{
Cell[125985, 4484, 121, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[126109, 4488, 101, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[126225, 4494, 634, 32, 70, "Text",
  CellTags->{"S2.8.5", "5.13"}],
Cell[126862, 4528, 110, 3, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.14"}],

Cell[CellGroupData[{
Cell[126997, 4535, 140, 5, 70, "Input",
  CellTags->"S2.8.5"],
Cell[127140, 4542, 103, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[127258, 4548, 81, 1, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.15"}],

Cell[CellGroupData[{
Cell[127364, 4553, 126, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[127493, 4557, 103, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[127611, 4563, 1252, 40, 70, "DefinitionBox",
  CellTags->"S2.8.5"],
Cell[128866, 4605, 96, 1, 70, "Caption",
  CellTags->"S2.8.5"],
Cell[128965, 4608, 914, 29, 70, "Text",
  CellTags->{"S2.8.5", "5.16"}],
Cell[129882, 4639, 117, 2, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.17"}],

Cell[CellGroupData[{
Cell[130024, 4645, 132, 3, 70, "Input",
  CellTags->"S2.8.5"],
Cell[130159, 4650, 106, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[130280, 4656, 168, 5, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.18"}],

Cell[CellGroupData[{
Cell[130473, 4665, 107, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[130583, 4669, 106, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[130704, 4675, 171, 7, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.19"}],

Cell[CellGroupData[{
Cell[130900, 4686, 150, 5, 70, "Input",
  CellTags->"S2.8.5"],
Cell[131053, 4693, 102, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]],
Cell[131170, 4699, 140, 5, 70, "MathCaption",
  CellTags->{"S2.8.5", "5.20"}],

Cell[CellGroupData[{
Cell[131335, 4708, 112, 2, 70, "Input",
  CellTags->"S2.8.5"],
Cell[131450, 4712, 102, 3, 70, "Output",
  CellTags->"S2.8.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[131601, 4721, 77, 1, 70, "Subsection",
  CellTags->{"S2.8.6", "6.1"}],
Cell[131681, 4724, 300, 8, 70, "Text",
  CellTags->{"S2.8.6", "6.2"}],
Cell[131984, 4734, 102, 1, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.3"}],

Cell[CellGroupData[{
Cell[132111, 4739, 120, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[132234, 4743, 135, 3, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[132384, 4749, 116, 2, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.4"}],

Cell[CellGroupData[{
Cell[132525, 4755, 143, 5, 70, "Input",
  CellTags->"S2.8.6"],
Cell[132671, 4762, 163, 4, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[132849, 4769, 104, 1, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.5"}],

Cell[CellGroupData[{
Cell[132978, 4774, 77, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[133058, 4778, 210, 4, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[133283, 4785, 418, 10, 70, "Text",
  CellTags->{"S2.8.6", "6.6"}],
Cell[133704, 4797, 377, 9, 70, "Text",
  CellTags->{"S2.8.6", "6.7"}],
Cell[134084, 4808, 218, 7, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.8"}],

Cell[CellGroupData[{
Cell[134327, 4819, 115, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[134445, 4823, 130, 3, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[134590, 4829, 209, 6, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.9"}],

Cell[CellGroupData[{
Cell[134824, 4839, 79, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[134906, 4843, 128, 2, 70, "Output",
  CellTags->"S2.8.6"],
Cell[135037, 4847, 150, 5, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[135202, 4855, 353, 8, 70, "Text",
  CellTags->{"S2.8.6", "6.10"}],
Cell[135558, 4865, 269, 7, 70, "Text",
  CellTags->{"S2.8.6", "6.11"}],
Cell[135830, 4874, 190, 6, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.12"}],

Cell[CellGroupData[{
Cell[136045, 4884, 130, 3, 70, "Input",
  CellTags->"S2.8.6"],
Cell[136178, 4889, 127, 2, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[136320, 4894, 968, 30, 70, "DefinitionBox",
  CellTags->"S2.8.6"],
Cell[137291, 4926, 79, 1, 70, "Caption",
  CellTags->"S2.8.6"],
Cell[137373, 4929, 248, 6, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.13"}],

Cell[CellGroupData[{
Cell[137646, 4939, 123, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[137772, 4943, 132, 3, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[137919, 4949, 259, 7, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.14"}],

Cell[CellGroupData[{
Cell[138203, 4960, 93, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[138299, 4964, 105, 3, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[138419, 4970, 126, 4, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.15"}],

Cell[CellGroupData[{
Cell[138570, 4978, 77, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[138650, 4982, 166, 4, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[138831, 4989, 209, 6, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.16"}],

Cell[CellGroupData[{
Cell[139065, 4999, 119, 4, 70, "Input",
  CellTags->"S2.8.6"],
Cell[139187, 5005, 135, 3, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]],
Cell[139337, 5011, 221, 6, 70, "MathCaption",
  CellTags->{"S2.8.6", "6.17"}],

Cell[CellGroupData[{
Cell[139583, 5021, 119, 2, 70, "Input",
  CellTags->"S2.8.6"],
Cell[139705, 5025, 92, 3, 70, "Output",
  CellTags->"S2.8.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[139846, 5034, 103, 1, 70, "Subsection",
  CellTags->{"S2.8.7", "7.1"}],
Cell[139952, 5037, 562, 16, 70, "DefinitionBox",
  CellTags->"S2.8.7"],
Cell[140517, 5055, 99, 1, 70, "Caption",
  CellTags->"S2.8.7"],
Cell[140619, 5058, 80, 1, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.2"}],

Cell[CellGroupData[{
Cell[140724, 5063, 94, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[140821, 5067, 108, 3, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[140944, 5073, 200, 7, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.3"}],

Cell[CellGroupData[{
Cell[141169, 5084, 76, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[141248, 5088, 106, 2, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[141369, 5093, 380, 8, 70, "Text",
  CellTags->{"S2.8.7", "7.4"}],
Cell[141752, 5103, 156, 4, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.5"}],

Cell[CellGroupData[{
Cell[141933, 5111, 90, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[142026, 5115, 105, 3, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[142146, 5121, 89, 1, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.6"}],

Cell[CellGroupData[{
Cell[142260, 5126, 76, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[142339, 5130, 102, 2, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[142456, 5135, 941, 29, 70, "DefinitionBox",
  CellTags->"S2.8.7"],
Cell[143400, 5166, 66, 1, 70, "Caption",
  CellTags->"S2.8.7"],
Cell[143469, 5169, 133, 5, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.7"}],

Cell[CellGroupData[{
Cell[143627, 5178, 96, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[143726, 5182, 106, 3, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[143847, 5188, 191, 7, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.8"}],

Cell[CellGroupData[{
Cell[144063, 5199, 76, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[144142, 5203, 104, 2, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[144261, 5208, 596, 12, 70, "Text",
  CellTags->{"S2.8.7", "7.9"}],
Cell[144860, 5222, 127, 4, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.10"}],

Cell[CellGroupData[{
Cell[145012, 5230, 133, 3, 70, "Input",
  CellTags->"S2.8.7"],
Cell[145148, 5235, 148, 4, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[145311, 5242, 192, 6, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.11"}],

Cell[CellGroupData[{
Cell[145528, 5252, 122, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[145653, 5256, 371, 11, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[146039, 5270, 86, 1, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.12"}],

Cell[CellGroupData[{
Cell[146150, 5275, 123, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[146276, 5279, 373, 11, 70, "Output",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[146664, 5293, 325, 7, 70, "Text",
  CellTags->{"S2.8.7", "7.13"}],
Cell[146992, 5302, 405, 13, 70, "Text",
  CellTags->{"S2.8.7", "7.14"}],
Cell[147400, 5317, 88, 1, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.15"}],
Cell[147491, 5320, 103, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[147597, 5324, 208, 7, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.16"}],

Cell[CellGroupData[{
Cell[147830, 5335, 71, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[147904, 5339, 69, 1, 70, "Print",
  CellTags->"S2.8.7"]
}, Open  ]],
Cell[147988, 5343, 195, 7, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.17"}],
Cell[148186, 5352, 115, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[148304, 5356, 95, 1, 70, "MathCaption",
  CellTags->{"S2.8.7", "7.18"}],

Cell[CellGroupData[{
Cell[148424, 5361, 71, 2, 70, "Input",
  CellTags->"S2.8.7"],
Cell[148498, 5365, 71, 4, 70, "Print",
  CellTags->"S2.8.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148618, 5375, 90, 1, 70, "Subsection",
  CellTags->{"S2.8.8", "8.1"}],
Cell[148711, 5378, 1539, 47, 70, "DefinitionBox",
  CellTags->"S2.8.8"],
Cell[150253, 5427, 81, 1, 70, "Caption",
  CellTags->"S2.8.8"],
Cell[150337, 5430, 268, 6, 70, "Text",
  CellTags->{"S2.8.8", "8.2"}],
Cell[150608, 5438, 129, 4, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.3"}],

Cell[CellGroupData[{
Cell[150762, 5446, 94, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[150859, 5450, 118, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[150992, 5456, 144, 4, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.4"}],

Cell[CellGroupData[{
Cell[151161, 5464, 84, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[151248, 5468, 92, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[151355, 5474, 100, 1, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.5"}],

Cell[CellGroupData[{
Cell[151480, 5479, 148, 3, 70, "Input",
  CellTags->"S2.8.8"],
Cell[151631, 5484, 109, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[151755, 5490, 940, 28, 70, "DefinitionBox",
  CellTags->"S2.8.8"],
Cell[152698, 5520, 77, 1, 70, "Caption",
  CellTags->"S2.8.8"],
Cell[152778, 5523, 95, 1, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.6"}],

Cell[CellGroupData[{
Cell[152898, 5528, 92, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[152993, 5532, 136, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[153144, 5538, 82, 1, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.7"}],

Cell[CellGroupData[{
Cell[153251, 5543, 106, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[153360, 5547, 404, 7, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[153779, 5557, 347, 8, 70, "Text",
  CellTags->{"S2.8.8", "8.8"}],
Cell[154129, 5567, 138, 4, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.9"}],

Cell[CellGroupData[{
Cell[154292, 5575, 107, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[154402, 5579, 121, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[154538, 5585, 161, 4, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.10"}],

Cell[CellGroupData[{
Cell[154724, 5593, 76, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[154803, 5597, 118, 2, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[154936, 5602, 470, 9, 70, "Text",
  CellTags->{"S2.8.8", "8.11"}],
Cell[155409, 5613, 104, 1, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.12"}],

Cell[CellGroupData[{
Cell[155538, 5618, 119, 3, 70, "Input",
  CellTags->"S2.8.8"],
Cell[155660, 5623, 99, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[155774, 5629, 227, 6, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.13"}],

Cell[CellGroupData[{
Cell[156026, 5639, 76, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[156105, 5643, 92, 2, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[156212, 5648, 317, 8, 70, "Text",
  CellTags->{"S2.8.8", "8.14"}],
Cell[156532, 5658, 168, 4, 70, "Text",
  CellTags->{"S2.8.8", "8.15"}],
Cell[156703, 5664, 1235, 40, 70, "DefinitionBox",
  CellTags->"S2.8.8"],
Cell[157941, 5706, 114, 4, 70, "Caption",
  CellTags->"S2.8.8"],
Cell[158058, 5712, 520, 15, 70, "Text",
  CellTags->{"S2.8.8", "8.16"}],
Cell[158581, 5729, 129, 4, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.17"}],

Cell[CellGroupData[{
Cell[158735, 5737, 136, 5, 70, "Input",
  CellTags->"S2.8.8"],
Cell[158874, 5744, 553, 18, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[159442, 5765, 291, 9, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.18"}],

Cell[CellGroupData[{
Cell[159758, 5778, 93, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[159854, 5782, 110, 3, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[159979, 5788, 515, 9, 70, "Text",
  CellTags->{"S2.8.8", "8.19"}],
Cell[160497, 5799, 3846, 102, 70, "DefinitionBox",
  CellTags->"S2.8.8"],
Cell[164346, 5903, 138, 5, 70, "Caption",
  CellTags->"S2.8.8"],
Cell[164487, 5910, 100, 1, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.20"}],

Cell[CellGroupData[{
Cell[164612, 5915, 98, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[164713, 5919, 183, 4, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[164911, 5926, 106, 3, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.21"}],

Cell[CellGroupData[{
Cell[165042, 5933, 99, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[165144, 5937, 897, 14, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[166056, 5954, 207, 5, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.22"}],

Cell[CellGroupData[{
Cell[166288, 5963, 101, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[166392, 5967, 582, 9, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]],
Cell[166989, 5979, 91, 1, 70, "MathCaption",
  CellTags->{"S2.8.8", "8.23"}],

Cell[CellGroupData[{
Cell[167105, 5984, 103, 2, 70, "Input",
  CellTags->"S2.8.8"],
Cell[167211, 5988, 274, 5, 70, "Output",
  CellTags->"S2.8.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[167534, 5999, 98, 1, 70, "Subsection",
  CellTags->{"S2.8.9", "9.1"}],
Cell[167635, 6002, 429, 12, 70, "Text",
  CellTags->{"S2.8.9", "9.2"}],
Cell[168067, 6016, 383, 7, 70, "Text",
  CellTags->{"S2.8.9", "9.3"}],
Cell[168453, 6025, 1188, 37, 70, "DefinitionBox",
  CellTags->"S2.8.9"],
Cell[169644, 6064, 77, 1, 70, "Caption",
  CellTags->"S2.8.9"],
Cell[169724, 6067, 395, 8, 70, "Text",
  CellTags->{"S2.8.9", "9.4"}],
Cell[170122, 6077, 449, 11, 70, "Text",
  CellTags->{"S2.8.9", "9.5"}],
Cell[170574, 6090, 333, 8, 70, "Text",
  CellTags->{"S2.8.9", "9.6"}],
Cell[170910, 6100, 346, 8, 70, "Text",
  CellTags->{"S2.8.9", "9.7"}],
Cell[171259, 6110, 3090, 91, 70, "DefinitionBox",
  CellTags->"S2.8.9"],
Cell[174352, 6203, 140, 5, 70, "Caption",
  CellTags->"S2.8.9"],
Cell[174495, 6210, 212, 5, 70, "Text",
  CellTags->{"S2.8.9", "9.8"}],
Cell[174710, 6217, 400, 9, 70, "Text",
  CellTags->{"S2.8.9", "9.9"}],
Cell[175113, 6228, 354, 9, 70, "Text",
  CellTags->{"S2.8.9", "9.10"}],
Cell[175470, 6239, 137, 5, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.11"}],
Cell[175610, 6246, 116, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[175729, 6250, 159, 4, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.12"}],

Cell[CellGroupData[{
Cell[175913, 6258, 69, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[175985, 6262, 80, 1, 70, "Print",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[176080, 6266, 193, 5, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.13"}],

Cell[CellGroupData[{
Cell[176298, 6275, 103, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[176404, 6279, 97, 3, 70, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[176516, 6285, 136, 4, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.14"}],
Cell[176655, 6291, 116, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[176774, 6295, 163, 4, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.15"}],

Cell[CellGroupData[{
Cell[176962, 6303, 69, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[177034, 6307, 80, 1, 70, "Print",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[177129, 6311, 157, 5, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.16"}],

Cell[CellGroupData[{
Cell[177311, 6320, 89, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[177403, 6324, 85, 3, 70, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[177503, 6330, 145, 4, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.17"}],

Cell[CellGroupData[{
Cell[177673, 6338, 115, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[177791, 6342, 120, 3, 70, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[177926, 6348, 438, 10, 70, "Text",
  CellTags->{"S2.8.9", "9.18"}],
Cell[178367, 6360, 482, 13, 70, "Text",
  CellTags->{"S2.8.9", "9.19"}],
Cell[178852, 6375, 507, 16, 70, "Text",
  CellTags->{"S2.8.9", "9.20"}],
Cell[179362, 6393, 135, 4, 70, "MathCaption",
  CellTags->{"S2.8.9", "9.21"}],

Cell[CellGroupData[{
Cell[179522, 6401, 93, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[179618, 6405, 118, 3, 70, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[179751, 6411, 177, 5, 40, "MathCaption",
  CellTags->{"S2.8.9", "9.22"}],

Cell[CellGroupData[{
Cell[179953, 6420, 96, 2, 70, "Input",
  CellTags->"S2.8.9"],
Cell[180052, 6424, 144, 4, 25, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[180211, 6431, 2778, 78, 180, "DefinitionBox",
  CellTags->"S2.8.9"],
Cell[182992, 6511, 92, 1, 16, "Caption",
  CellTags->"S2.8.9"],
Cell[183087, 6514, 167, 5, 40, "MathCaption",
  CellTags->{"S2.8.9", "9.23"}],

Cell[CellGroupData[{
Cell[183279, 6523, 105, 2, 28, "Input",
  CellTags->"S2.8.9"],
Cell[183387, 6527, 104, 3, 25, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[183506, 6533, 149, 4, 56, "MathCaption",
  CellTags->{"S2.8.9", "9.24"}],

Cell[CellGroupData[{
Cell[183680, 6541, 125, 2, 28, "Input",
  CellTags->"S2.8.9"],
Cell[183808, 6545, 104, 3, 25, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[183927, 6551, 210, 6, 56, "MathCaption",
  CellTags->{"S2.8.9", "9.25"}],

Cell[CellGroupData[{
Cell[184162, 6561, 122, 2, 28, "Input",
  CellTags->"S2.8.9"],
Cell[184287, 6565, 105, 3, 25, "Output",
  CellTags->"S2.8.9"]
}, Open  ]],
Cell[184407, 6571, 682, 18, 88, "Text",
  CellTags->{"S2.8.9", "9.26"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

