(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    513207,      16091]*)
(*NotebookOutlinePosition[    676601,      20678]*)
(*  CellTagsIndexPosition[    662437,      20157]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.9 ", "HeadingNumber"],
  "Textual Input and Output"
}], "Section",
  CellTags->{"S2.9.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.9.1 Forms of Input and Output", "Subsection",
  CellTags->{"S2.9.1", "1.1"}],

Cell["Here is one way to enter a particular expression. ", "MathCaption",
  CellTags->{"S2.9.1", "1.2"}],

Cell[CellGroupData[{

Cell["x^2 + Sqrt[y]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.1"],

Cell[BoxData[
    \(x\^2 + \@y\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell["Here is another way to enter the same expression. ", "MathCaption",
  CellTags->{"S2.9.1", "1.3"}],

Cell[CellGroupData[{

Cell["Plus[Power[x, 2], Sqrt[y]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.1"],

Cell[BoxData[
    \(x\^2 + \@y\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell["\<\
With a notebook front end, you can also enter the expression \
directly in this way. \
\>", "MathCaption",
  CellTags->{"S2.9.1", "1.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 + \@y\)], "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.1"],

Cell[BoxData[
    \(x\^2 + \@y\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to output expressions in many different ways. "
}], "Text",
  CellTags->{"S2.9.1", "1.5"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica", "TI"],
  " notebooks, expressions are by default output in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.6"}],

Cell[CellGroupData[{

Cell["x^2 + Sqrt[y]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.1"],

Cell[BoxData[
    \(x\^2 + \@y\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["OutputForm", "MR"],
  " uses only ordinary keyboard characters and is the default for text\
\[Hyphen]based interfaces to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.7"}],

Cell[CellGroupData[{

Cell["OutputForm[ x^2 + Sqrt[y] ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.1"],

Cell["x^2 + Sqrt[y]", "Output",
  CellLabel->"Out[5]//OutputForm= ",
  CellTags->"S2.9.1"],

Cell[OutputFormData["\<\
 2
x  + Sqrt[y]\
\>"], "Output",
  CellLabel->"Out[5]//OutputForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " yields a form that can be typed directly on a keyboard. "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.8"}],

Cell[CellGroupData[{

Cell["InputForm[ x^2 + Sqrt[y] ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.1"],

Cell["x^2 + Sqrt[y]", "Output",
  CellLabel->"Out[6]//InputForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullForm", "MR"],
  " shows the internal form of an expression in explicit functional notation. \
"
}], "MathCaption",
  CellTags->{"S2.9.1", "1.9"}],

Cell[CellGroupData[{

Cell["FullForm[ x^2 + Sqrt[y] ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.1"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[Power[x, 2], Power[y, Rational[1, 2]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[7]//FullForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FullForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["the internal form of an expression "]},
          {Cell[TextData[{
              StyleBox["InputForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["a form suitable for direct keyboard input "]},
          {Cell[TextData[{
              StyleBox["OutputForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
a two\[Hyphen]dimensional form using only keyboard \
characters \
\>"]},
          {Cell[TextData[{
              StyleBox["StandardForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "the default form used in ",
              StyleBox["Mathematica", "TI"],
              " notebooks "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.1"],

Cell["Some output forms for expressions. ", "Caption",
  CellTags->"S2.9.1"],

Cell[TextData[{
  "Output forms provide textual representations of ",
  StyleBox["Mathematica", "TI"],
  " expressions. In some cases these textual representations are also \
suitable for input to ",
  StyleBox["Mathematica", "TI"],
  ". But in other cases they are intended just to be looked at, or to be \
exported to other programs, rather than to be used as input to ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.9.1", "1.10"}],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " uses a large collection of ad hoc rules to produce an approximation to \
traditional mathematical notation. "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.11"}],

Cell[CellGroupData[{

Cell["TraditionalForm[ x^2 + Sqrt[y] + Gamma[z] EllipticK[z] ]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.1"],

Cell[BoxData[
    \(TraditionalForm\`x\^2 + \(K(z)\)\ \(\[CapitalGamma](
          z)\) + \@y\)], "Output",
  CellLabel->"Out[8]//TraditionalForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TeXForm", "MR"],
  " yields output suitable for export to TeX. "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.12"}],

Cell[CellGroupData[{

Cell["TeXForm[ x^2 + Sqrt[y] ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.1"],

Cell["x^2+\\sqrt{y}", "Output",
  CellLabel->"Out[9]//TeXForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["CForm", "MR"],
  " yields output that can be included in a C program. Macros for objects \
like ",
  StyleBox["Power", "MR"],
  " are included in the header file ",
  StyleBox["mdefs.h", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.13"}],

Cell[CellGroupData[{

Cell["CForm[ x^2 + Sqrt[y] ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.1"],

Cell["Power(x,2) + Sqrt(y)", "Output",
  CellLabel->"Out[10]//CForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FortranForm", "MR"],
  " yields output suitable for export to Fortran. "
}], "MathCaption",
  CellTags->{"S2.9.1", "1.14"}],

Cell[CellGroupData[{

Cell["FortranForm[ x^2 + Sqrt[y] ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.1"],

Cell["x**2 + Sqrt(y)", "Output",
  CellLabel->"Out[11]//FortranForm= ",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TraditionalForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["traditional mathematical notation "]},
          {Cell[TextData[{
              StyleBox["TeXForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["output suitable for export to TeX"]},
          {Cell[TextData[{
              StyleBox["MathMLForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["output suitable for use with MathML on the web "]},
          {Cell[TextData[{
              StyleBox["CForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["output suitable for export to C "]},
          {Cell[TextData[{
              StyleBox["FortranForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["output suitable for export to Fortran "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.1"],

Cell[TextData[{
  "Output forms not normally used for ",
  StyleBox["Mathematica", "SO"],
  " input. "
}], "Caption",
  CellTags->"S2.9.1"],

Cell[TextData[{
  "Section ",
  ButtonBox["2.9.17",
    ButtonData:>{"2.9.17", "17.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how you can create your own output forms. You should realize \
however that in communicating with external programs it is often better to \
use ",
  StyleBox["MathLink", "TI"],
  " to send expressions directly than to generate a textual representation \
for these expressions. "
}], "Text",
  CellTags->{"S2.9.1", "1.15"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            Cell["\<\
\[FilledSmallSquare] Exchange textual representations \
of expressions. \
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Exchange expressions directly via ",
              StyleBox["MathLink", "TI"],
              ". "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.1"],

Cell[TextData[{
  "Two ways to communicate between ",
  StyleBox["Mathematica", "SO"],
  " and other programs. "
}], "Caption",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.2 How Input and Output Work", "Subsection",
  CellTags->{"S2.9.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Input "], Cell[
            "convert from a textual form to an expression "]},
          {Cell["Processing "], Cell["do computations on the expression "]},
          {Cell["Output "], Cell[
            "convert the resulting expression to textual form "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.2"],

Cell[TextData[{
  "Steps in the operation of ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.9.2"],

Cell[TextData[{
  "When you type something like ",
  StyleBox["x^2", "MR"],
  " what ",
  StyleBox["Mathematica", "TI"],
  " at first sees is just the string of characters ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["^", "MR"],
  ", ",
  StyleBox["2", "MR"],
  ". But with the usual way that ",
  StyleBox["Mathematica", "TI"],
  " is set up, it immediately knows to convert this string of characters into \
the expression ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.2", "2.2"}],

Cell[TextData[{
  "Then, after whatever processing is possible has been done, ",
  StyleBox["Mathematica", "TI"],
  " takes the expression ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  " and converts it into some kind of textual representation for output. "
}], "Text",
  CellTags->{"S2.9.2", "2.3"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " reads the string of characters ",
  StyleBox["x", "MR"],
  ", ",
  StyleBox["^", "MR"],
  ", ",
  StyleBox["2", "MR"],
  " and converts it to the expression ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.2", "2.4"}],

Cell[CellGroupData[{

Cell["x ^ 2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.2"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.2"]
}, Open  ]],

Cell["This shows the expression in Fortran form. ", "MathCaption",
  CellTags->{"S2.9.2", "2.5"}],

Cell[CellGroupData[{

Cell["FortranForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.2"],

Cell["x**2", "Output",
  CellLabel->"Out[2]//FortranForm= ",
  CellTags->"S2.9.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FortranForm", "MR"],
  " is just a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote]: the \
value of ",
  StyleBox["Out[2]", "MR"],
  " is still the expression ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.2", "2.6"}],

Cell[CellGroupData[{

Cell["%", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.2"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.2"]
}, Open  ]],

Cell[TextData[{
  "It is important to understand that in a typical ",
  StyleBox["Mathematica", "TI"],
  " session ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " record only the underlying expressions that are processed, not the \
textual representations that happen to be used for their input or output. "
}], "Text",
  CellTags->{"S2.9.2", "2.7"}],

Cell[TextData[{
  "If you explicitly request a particular kind of output, say by using ",
  StyleBox["TraditionalForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ", then what you get will be labeled with ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]//TraditionalForm", "MR"],
  ". This indicates that what you are seeing is ",
  StyleBox["expr", "TI"],
  StyleBox["//TraditionalForm", "MR"],
  ", even though the value of ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " itself is just ",
  StyleBox["expr", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.9.2", "2.8"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " also allows you to specify globally that you want output to be displayed \
in a particular form. And if you do this, then the form will no longer be \
indicated explicitly in the label for each line. But it is still the case \
that ",
  StyleBox["In[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " and ",
  StyleBox["Out[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  " will record only underlying expressions, not the textual representations \
used for their input and output. "
}], "Text",
  CellTags->{"S2.9.2", "2.9"}],

Cell[TextData[{
  "This sets ",
  StyleBox["t", "MR"],
  " to be an expression with ",
  StyleBox["FortranForm", "MR"],
  " explicitly wrapped around it. "
}], "MathCaption",
  CellTags->{"S2.9.2", "2.10"}],

Cell[CellGroupData[{

Cell["t = FortranForm[x^2 + y^2]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.2"],

Cell["x**2 + y**2", "Output",
  CellLabel->"Out[4]//FortranForm= ",
  CellTags->"S2.9.2"]
}, Open  ]],

Cell["The result on the previous line is just the expression. ", "MathCaption",
  CellTags->{"S2.9.2", "2.11"}],

Cell[CellGroupData[{

Cell["%", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.2"],

Cell[BoxData[
    \(x\^2 + y\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.2"]
}, Open  ]],

Cell[TextData[{
  "But ",
  StyleBox["t", "MR"],
  " contains the ",
  StyleBox["FortranForm", "MR"],
  " wrapper, and so is displayed in ",
  StyleBox["FortranForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.2", "2.12"}],

Cell[CellGroupData[{

Cell["t", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.2"],

Cell["x**2 + y**2", "Output",
  CellLabel->"Out[6]//FortranForm= ",
  CellTags->"S2.9.2"]
}, Open  ]],

Cell[TextData[{
  "Wherever ",
  StyleBox["t", "MR"],
  " appears, it is formatted in ",
  StyleBox["FortranForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.2", "2.13"}],

Cell[CellGroupData[{

Cell["{t^2, 1/t}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.2"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        SuperscriptBox[
          InterpretationBox[
            StyleBox[\(x ** 2\  + \ y ** 2\),
              ShowStringCharacters->True,
              NumberMarks->True],
            FortranForm[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]]],
            Editable->True,
            AutoDelete->True], "2"], ",", 
        FractionBox["1", 
          InterpretationBox[
            StyleBox[\(x ** 2\  + \ y ** 2\),
              ShowStringCharacters->True,
              NumberMarks->True],
            FortranForm[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]]],
            Editable->True,
            AutoDelete->True]]}], "}"}]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.3 The Representation of Textual Forms", "Subsection",
  CellTags->{"S2.9.3", "3.1"}],

Cell[TextData[{
  "Like everything else in ",
  StyleBox["Mathematica", "TI"],
  " the textual forms of expressions can themselves be represented as \
expressions. Textual forms that consist of one\[Hyphen]dimensional sequences \
of characters can be represented directly as ordinary ",
  StyleBox["Mathematica", "TI"],
  " strings. Textual forms that involve subscripts, superscripts and other \
two\[Hyphen]dimensional constructs, however, can be represented by nested \
collections of two\[Hyphen]dimensional boxes.  "
}], "Text",
  CellTags->{"S2.9.3", "3.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["One\[Hyphen]dimensional strings "], Cell[TextData[{
              StyleBox["InputForm", "MR"],
              ", ",
              StyleBox["FullForm", "MR"],
              ", etc. "
            }]]},
          {Cell["Two\[Hyphen]dimensional boxes "], Cell[TextData[{
              StyleBox["StandardForm", "MR"],
              ", ",
              StyleBox["TraditionalForm", "MR"],
              ", etc. "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.3"],

Cell["Typical representations of textual forms. ", "Caption",
  CellTags->"S2.9.3"],

Cell[TextData[{
  "This generates the string corresponding to the textual representation of \
the expression in ",
  StyleBox["InputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.3", "3.3"}],

Cell[CellGroupData[{

Cell["ToString[x^2 + y^3, InputForm]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.3"],

Cell[BoxData[
    \("x^2 + y^3"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullForm", "MR"],
  " shows the string explicitly. "
}], "MathCaption",
  CellTags->{"S2.9.3", "3.4"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.3"],

Cell[BoxData[
    TagBox[
      StyleBox["\"\<x^2 + y^3\>\"",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[2]//FullForm= ",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell["Here are the individual characters in the string. ", "MathCaption",
  CellTags->{"S2.9.3", "3.5"}],

Cell[CellGroupData[{

Cell["Characters[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.3"],

Cell[BoxData[
    \({"x", "^", "2", " ", "+", " ", "y", "^", "3"}\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the box structure corresponding to the expression in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.3", "3.6"}],

Cell[CellGroupData[{

Cell["ToBoxes[x^2 + y^3, StandardForm]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.3"],

Cell[BoxData[
    \(RowBox[{SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "3"]}]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell[TextData[{
  "Here is the ",
  StyleBox["InputForm", "MR"],
  " of the box structure. In this form the structure is effectively \
represented by an ordinary string. "
}], "MathCaption",
  CellTags->{"S2.9.3", "3.7"}],

Cell[CellGroupData[{

Cell["ToBoxes[x^2 + y^3, StandardForm] // InputForm", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.3"],

Cell["\\(x\\^2 + y\\^3\\)", "Output",
  CellLabel->"Out[5]//InputForm= ",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell[TextData[{
  "If you use the notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then you can see the expression that corresponds to the textual form of \
each cell by using the ",
  StyleBox["Show Expression", "SR"],
  " menu item.  "
}], "Text",
  CellTags->{"S2.9.3", "3.8"}],

Cell[TextData[{
  "Here is a cell containing an expression in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.3", "3.9"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000=B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo40
oooo1@000?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooooe0?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dH0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`3o0?ooohP0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cA@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0?l0ooooQ`3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c<h0?ooo`D000001`3oool00`000000oooo0?ooo`020?ooo`D000003P3oool2000000<0
oooo0P0000090?ooo`030000003oool0oooo06/0oooo1@00003o0?oooaH0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c>03oool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo0000000:
0?ooo`030000003oool0oooo06/0oooo00D000000?ooo`3oool0oooo0000003o0?oooaH0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c>@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0000000/0oooo00<0
00000?ooo`3oool0K03oool00`000000oooo0?ooo`3o0?oooaL0oooo00<0003o0?ooo`3oool01@3o
ool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3o
ool5000000L0oooo00@000000?ooo`3oool0oooo100000050?ooo`030000003oool0oooo06d0oooo
00<000000?ooo`3oool0o`3ooolF0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c/0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
KP3oool00`000000oooo0?ooo`3o0?oooaD0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c>03oool01@000000oooo
0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00@0oooo0`000000103oool000000000000000020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0J`3oool01@000000oooo0?ooo`3oool000000?l0oooo5P3oool0
0`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<h0?ooo`050000003oool0oooo0?ooo`000000203oool010000000oooo0?oo
o`3oool3000001X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1/0?ooo`050000
003oool0oooo0?ooo`000000o`3ooolF0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cT0oooo0`00000:0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool05@3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo02<0oooo0`0000180?ooo`<00000o`3ooolG0?ooo`030000o`3oool0oooo
00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<f@0oooo0P00000]0?ooo`030000003oool0oooo0080oooo0P00000;0?ooo`800000o`3ooom>0?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<i<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0?l0ooooC03oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=i0?ooo`030000003oool0oooo
00@0oooo1P0000030?ooo`<00000103oool4000000@0oooo00@000000?ooo`3oool0oooo0P000003
0?ooo`8000000`3oool00`000000oooo0?ooo`3o0?oood`0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN@3oool0
0`000000oooo0?ooo`050?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080
oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0?l0ooooC03oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c<f0?oooc/000001P3oool5000000D0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0oooo00D0oooo
1@0000060?ooodH00000m@3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=i0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`3o0?oood`0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cN@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool0o`3ooom<0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h40oooo00<000000?ooo`3oool01@3o
ool3000000@0oooo0`0000000`3oool000000?ooo`020?ooo`040000003oool0oooo0?ooo`<00000
00@0oooo00000000000000000`3oool00`000000oooo0?ooo`3o0?oood`0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cP@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0o`3ooom<0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<h00oooo0`00000E0?ooo`8000002`3oool2000002<0
oooo0`00003o0?ooobP0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cc@3oool00`000000oooo0?ooo`020?ooo`80
00009@3oool200000?T0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cc@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0m`3oool00`000?l0oooo0?ooo`050?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=A0?ooo`D0
0000I03oool6000000<0oooo0`0000040?ooo`@00000103oool00`000000oooo0?ooo`020?ooo`D0
00003P3oool2000000<0oooo0P0000090?ooo`030000003oool0oooo0?L0oooo00<0003o0?ooo`3o
ool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cD`3oool00`000000oooo0?ooo`1U0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`050?ooo`050000003o
ool0oooo0?ooo`0000002P3oool00`000000oooo0?ooo`3g0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<e<0oooo
00<000000?ooo`3oool0I@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0000000;
0?ooo`030000003oool0oooo0?L0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cD`3oool00`000000oooo0?ooo`1U
0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo
1@0000070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0m03oool40000o`L0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<e<0oooo
00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`0000000P3oool40000
00D0oooo00<000000?ooo`3oool0m`3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=C0?ooo`030000003oool0oooo
06D0oooo00<000000?ooo`3oool01@3oool3000000@0oooo0`0000000`3oool000000?ooo`020?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?oo
o`<0000000H0oooo00000000000000000?ooo`0000070?ooo`030000003oool0oooo0?H0oooo0P00
0?l70?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=A0?ooo`<00000I`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo0`00
000I0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0m@3oool00`000?l0oooo0000
o`070?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=C0?ooo`030000003oool0oooo06@0oooo0`00000E0?ooo`8000001@3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo0080oooo0P00003f0?ooo`040000o`3oool0oooo0000o`L0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<o40oooo
00@000000?ooo`3oool00000n`3oool01@000?l0oooo0?ooo`3oool0003o00L0oooo00@0iNGU09VI
V@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<o80oooo0P00003k0?oo
o`H0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIVOl0<c<co`0c<c<0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0
VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo
00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU1`3UiND103<c<`40oooo003o0?ooool0oooo303oool0
0001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.9.3"],

Cell[TextData[{
  "Here is the underlying representation of that expression in terms of \
boxes, displayed using the ",
  StyleBox["Show Expression", "SR"],
  " menu item. "
}], "MathCaption",
  CellTags->{"S2.9.3", "3.10"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000f2000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00020?ooool0<c<co`0c<c<903<c<`40oooo00000`3oool0iNGU0>GUi@3o03<c<ol0
<c<c200c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT0o`2IVIWo09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0o`2IVIWo
09VIV@H0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo0>GUiOl0iNGU102IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0003o1@3oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?oo
o`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?oooj00oooo0`00001C0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cFP3oool3000002h0oooo
0`00003o0?oooa<0oooo00<000000?ooo`3oool06P3oool2000003H0oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=K0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool08P3oool2000003`0oooo0P00
00050?ooo`030000003oool0oooo00@0oooo0P00000J0?ooo`800000303oool00`000000oooo0?oo
o`040?ooo`800000:03oool2000000D0oooo00<000000?ooo`3oool0103oool2000000D0oooo0P00
000a0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=03oool00`000?l0oooo0?oo
o`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<e/0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0280oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0F0?ooo`<00000103oool3
000000030?ooo`000000oooo0080oooo0`0000020?ooo`@00000103oool3000000030?ooo`000000
oooo0080oooo0`00000;0?ooo`030000003oool0oooo03@0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c==0?oo
o`@00000103oool3000000030?ooo`000000oooo00@00000103oool3000000<0oooo100000040?oo
o`<00000103oool3000000<0oooo100000030?ooo`D000000P3oool4000000D0oooo0`0000000`3o
ool0000000000003000000@0oooo0`0000020?ooo`8000000`3oool2000000<0oooo00<000000?oo
o`3oool0203oool2000000<0oooo0P0000090?ooo`030000003oool0oooo0140oooo1@00000;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool04@3oool5000000/0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`0d0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC@3oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`3o
ool000000`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool04@3o
ool01@000000oooo0?ooo`3oool0000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0A0?ooo`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01@0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0d0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<cD@3oool010000000oooo0?ooo`0000030?ooo`040000
003oool0oooo000000<0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`070?oo
o`040000003oool0oooo000000L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool000000200oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01X0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0d0?ooo`030000o`3oool0oooo00<0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC`3o
ool300000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
00000P3oool5000000<0oooo00<000000?ooo`3oool0103oool3000000<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool06P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo03@0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c==0?ooo`<00000103oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool000000280oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo00<000000?ooo`0000000`3o
ool01P000000oooo0?ooo`3oool000000?ooo`8000000P3oool200000080oooo1@0000000`3oool0
00000?ooo`0300000080oooo0P0000020?ooo`8000000P3oool5000000<0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`0d0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC@3oool00`000000oooo
0?ooo`030?ooo`8000000P3oool2000000030?ooo`000000oooo00<00000103oool3000000<0oooo
00<000000?ooo`0000000P0000030?ooo`<00000103oool3000000<0oooo00<000000?ooo`000000
0P0000020?ooo`<000000`3oool00`000000oooo00000002000000<0oooo1@0000020?ooo`050000
003oool0oooo0?ooo`0000000`3oool300000080oooo0`000000103oool000000000000000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3oool3000000040?ooo`0000000000
00000080oooo00<000000?ooo`0000004P3oool00`000000oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo00<000000?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0=03oool00`000?l0
oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<dd0oooo00D000000?ooo`3oool0oooo000000120?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`0000002`3oool00`000000oooo0000000B0?ooo`030000003oool0000000<0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0140oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool00`000000oooo0000
00040?ooo`<000002`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`000000103oool2000003H0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VI
V@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=>0?ooo`@00000=@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo1@00000C0?ooo`800000103oool0
0`000000oooo0000000;0?ooo`030000003oool000000180oooo00<000000?ooo`000000103oool3
000000@0oooo00<000000?ooo`000000103oool2000000D0oooo00<000000?ooo`3oool0103oool2
000001<0oooo00<000000?ooo`000000103oool2000000D0oooo00<000000?ooo`000000103oool0
0`000000oooo0?ooo`040?ooo`8000004`3oool00`000000oooo000000040?ooo`<00000103oool0
0`000000oooo000000040?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`8000001@3oool2
000008H0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=[0?ooo`8000001P3oool00`00
0000oooo0?ooo`3o0?oooh00oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=[0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0?l0
ooooA03oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ch0oooo0`0000020?ooo`8000000P3oool3000000@0oooo
00<000000?ooo`0000000P3oool5000000@0oooo0`0000020?ooo`8000000`3oool2000000<0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`D000002P3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo0?l0oooo@`3oool00`000?l0oooo0?ooo`030?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`3o0?oood<0oooo00<0003o0?ooo`3oool00`3o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`3o
0?oooe00oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool0
00030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`040000003oool0oooo000000<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
01h0oooo1@00003o0?oooe00oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`@000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`@000000`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`3o0?oooe00oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool300000080oooo0`0000001P3oool00000000000000000oooo000000<0oooo00@000000?ooo`3o
ool0oooo0`0000020?ooo`<0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool000000180oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool000000?l0ooooBP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<cl0oooo00D000000?oo
o`3oool0oooo0000000@0?ooo`050000003oool0oooo0?ooo`0000004P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool3000000D0oooo00<0
00000?ooo`0000004P3oool00`000000oooo0000000;0?ooo`030000003oool000000?l0ooooBP3o
ool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<ch0oooo1@00000@0?ooo`D000004`3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo000000050?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000004P3oool00`000000oooo0000000;0?ooo`030000003oool000000?l0ooooBP3oool0
0`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI
0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI
0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?oo
o`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<gl0oooo0`00003o0?ooog@0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=M0?ooo`8000001P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo01h0oooo0P00003o0?oooe40oooo00<0003o0?oo
o`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c=M0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`3o0?oood@0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`<000000P3oool200000080oooo
0`0000040?ooo`030000003oool000000080oooo1@0000040?ooo`<000000P3oool2000000<0oooo
0P0000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0203oool6000000<0oooo
0`0000040?ooo`@000002P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0o`3ooom30?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`090?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool02P3oool00`000000oooo0?ooo`3o0?oood<0oooo00<0003o0?ooo`3oool00`3oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000200oooo00<000000?ooo`3oool0o`3o
oom@0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool010000000oooo0?ooo`0000030?ooo`050000003o
ool0oooo0?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000200oooo
00<000000?ooo`3oool0o`3ooom@0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool4000000<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool4000000<0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00D000000?oo
o`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000803oool00`000000oooo0?oo
o`3o0?oooe00oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`050000003oool0oooo0?ooo`0000000`3o
ool300000080oooo0`0000001P3oool00000000000000000oooo000000<0oooo00@000000?ooo`3o
ool0oooo0`0000020?ooo`<0000000@0oooo00000000000000000`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`05
0?ooo`<00000103oool3000000070?ooo`000000oooo0?ooo`000000oooo0000000B0?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000003o0?ooodX0oooo
00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<a0?ooo`050000003oool0oooo0?ooo`000000403oool01@000000oooo
0?ooo`3oool000000180oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0000000B0?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000003o0?ooodX0
oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c<`0?ooo`D00000403oool5000001<0oooo0P0000060?ooo`030000
003oool0oooo0080oooo00<000000?ooo`0000000P3oool3000001@0oooo00<000000?ooo`000000
4P3oool00`000000oooo000000050?ooo`800000103oool00`000000oooo0000003o0?ooodX0oooo
00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VI
V@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3o
ool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=b0?ooo`800000o`3ooon20?ooo`030000o`3o
ool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cLP3oool00`000000oooo0?ooo`3o0?oooh40oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<R0?oo
o`@00000103oool4000000@0oooo0`000000103oool000000?ooo`3oool3000000D0oooo0`000002
0?ooo`D000000`3oool300000080oooo0`0000020?ooo`L00000103oool300000080oooo0P000003
0?ooo`8000000`3oool00`000000oooo0?ooo`3o0?oooh40oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<S0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
o`3ooon10?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003o
ool0oooo0?l0ooooP@3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b<0oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`040?ooo`@000000P3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oo
oh40oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<S0?ooo`<000001@3oool00`000000oooo0?ooo`070?ooo`04
0000003oool0oooo000000<0oooo00D000000?ooo`3oool0oooo000000070?ooo`030000003oool0
oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`8000000P3oool00`000000oooo0?oo
o`04000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool0o`3ooon10?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool01@000000oooo0000
003oool000000080oooo00<000000?ooo`0000000P0000020?ooo`@00000103oool3000000<0oooo
1@0000020?ooo`<000001@3oool300000080oooo00<000000?ooo`0000000P0000030?ooo`050000
003oool0oooo0?ooo`0000000`3oool300000080oooo0`000000103oool000000000000000030?oo
o`030000003oool0oooo0?l0ooooP@3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI
0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b<0oooo00D000000?ooo`3o
ool0oooo0000000H0?ooo`030000003oool0oooo01P0oooo00D000000?ooo`3oool0oooo0000000B
0?ooo`030000003oool0oooo0?l0ooooP@3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b80oooo1P00000H0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool03`3oool5000001<0oooo0P00003o0?oo
oh80oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0
VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo
00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VI
V@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o
0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI
0080VIVI0P0c<c=a0?ooo`<00000o`3ooon20?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VI
V@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC`3oool2000000H0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0N0?ooo`800000@`3oool2000000`0
oooo00<000000?ooo`3oool0103oool200000?l0oooo1@3oool00`000?l0oooo0?ooo`030?ooo`03
0>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<dl0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0=X0oooo
00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c<R0?ooo`<000000P3oool200000080oooo0`0000040?ooo`030000003o
ool000000080oooo1@0000040?ooo`<000000P3oool2000000<0oooo0P0000030?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0203oool6000000<0oooo0`0000040?ooo`@000002P3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0403o
ool2000000<0oooo0P0000090?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0803o
ool00`000000oooo0?ooo`3I0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`09
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0A0?ooo`050000003oool0oooo0?ooo`0000002P3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0f@3oool00`00
0?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<b<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool00000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000803o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool000000240oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0oooo0`3oool00`000?l0oooo0?oo
o`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<b<0oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0103oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000003oool0oooo0200oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool05`3oool500000>H0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<S0?ooo`@000000`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`@0
00000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool01@00
0000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000P0?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`0000008@3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0o`3oool30?ooo`030000o`3oool0oooo00<0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo0`0000020?ooo`<0000000H0oooo0000000000000000
0?ooo`0000030?ooo`040000003oool0oooo0?ooo`<000000P3oool3000000040?ooo`0000000000
000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0
000000<0oooo00<000000?ooo`3oool01@3oool3000000@0oooo0`0000001`3oool000000?ooo`3o
ool000000?ooo`0000004P3oool00`000000oooo000000050?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000004P3oool00`000000oooo000000020?ooo`<0000000@0oooo000000000000
00000P3oool00`000000oooo0000000B0?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0000000;0?ooo`030000003oool000000>00oooo00<0003o0?ooo`3o
ool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c<S0?ooo`050000003oool0oooo0?ooo`000000403oool01@000000oooo0?ooo`3oool00000
0180oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0000000B0?ooo`030000003oool00000
00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000B0?ooo`030000003oool00000
00/0oooo00<000000?ooo`0000004P3oool00`000000oooo000000050?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0140oooo00<000000?ooo`0000002`3oool00`000000oooo0000003P0?ooo`030000o`3oool0oooo
00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c8P3oool500000100oooo1@00000C0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool000000080oooo0`00000D0?ooo`030000003oool000000180oooo00<000000?ooo`00
00001@3oool2000000@0oooo00<000000?ooo`0000004P3oool00`000000oooo0000000;0?ooo`03
0000003oool000000180oooo00<000000?ooo`000000103oool2000000D0oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`8000004`3oool00`000000oooo0000000;0?ooo`03
0000003oool000000>00oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oo
ooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c=X0?ooo`<00000;P3oool300000?l0ooooFP3oool00`000?l0
oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<fT0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0R0?ooo`800000
?03oool2000000D0oooo00<000000?ooo`3oool0103oool2000001T0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`040?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`800000
1@3oool200000:80oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=Y0?ooo`030000003oool0oooo02h0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo07P0oooo00<0
003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c=K0?ooo`@00000103oool3000000030?ooo`000000oooo00@00000103oool3
000000<0oooo100000040?ooo`<00000103oool3000000<0oooo100000030?ooo`D000000P3oool4
000000D0oooo0`0000000`3oool0000000000003000000@0oooo0`0000020?ooo`8000000`3oool2
000000<0oooo00<000000?ooo`3oool0203oool2000000<0oooo0P0000090?ooo`030000003oool0
oooo0140oooo1@00000;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`1g0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cF`3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`3oool000000`3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool02@3oool0
1@000000oooo0?ooo`3oool0000000X0oooo00<000000?ooo`3oool04@3oool01@000000oooo0?oo
o`3oool0000000/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0M`3oool00`000?l0oooo0?ooo`030?ooo`030>GU
i@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<el0oooo00@0
00000?ooo`3oool000000`3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo0000
00L0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000070?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0000000P0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0Q03oool00`000?l0
oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ed0oooo0`0000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo1@0000030?ooo`030000003oool0oooo00@0oooo0`0000030?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
2`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
5`3oool5000008@0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=K0?ooo`<00000103oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`@00000
0`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool000000280oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`240?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cF`3oool00`000000oooo0?ooo`030?ooo`800000
0P3oool2000000030?ooo`000000oooo00<00000103oool3000000<0oooo00<000000?ooo`000000
0P0000030?ooo`<00000103oool3000000<0oooo00<000000?ooo`0000000P0000020?ooo`<00000
0`3oool00`000000oooo00000002000000<0oooo1@0000020?ooo`050000003oool0oooo0?ooo`00
00000`3oool300000080oooo0`000000103oool000000000000000030?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`0000000P3oool3000000040?ooo`000000000000000080oooo00<00000
0?ooo`0000004P3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo000000050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`000000OP3o
ool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<e/0oooo00D000000?ooo`3oool0oooo000000120?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000B0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`0000002`3oool00`000000oooo0000000B0?ooo`030000003oool0000000<0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0140oooo00<000000?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0000000D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`0A0?ooo`030000003oool0000000/0oooo00<000000?ooo`00
0000OP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<e`0oooo1000000e0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool00P3oool5000001<0oooo0P0000040?ooo`030000003oool0000000/0oooo
00<000000?ooo`0000004P3oool00`000000oooo000000040?ooo`<00000103oool00`000000oooo
000000040?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`8000004`3oool00`000000oooo
000000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000103oool00`000000oooo
0?ooo`040?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`8000001@3oool2000001<0oooo
00<000000?ooo`0000002`3oool00`000000oooo0000001n0?ooo`030000o`3oool0oooo00<0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2I
VIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000
o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<cN@3oool2000000H0oooo00<000000?ooo`3oool0o`3ooomb0?ooo`030000o`3o
ool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cN@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0803oool00`000000oooo0?ooo`3o0?ooocH0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=<0?oo
o`<000000P3oool200000080oooo0`0000040?ooo`030000003oool000000080oooo1@0000040?oo
o`<000000P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool02@3oool5000000X0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`3o0?oo
ocD0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c==0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0o`3ooole0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC@3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool0o`3ooom20?ooo`030000o`3oool0oooo00<0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cC@3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0N0?ooo`D00000o`3ooom20?ooo`030000o`3o
ool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<cC@3oool4000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool4000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0o`3ooom20?ooo`030000o`3oool0oooo00<0
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
C@3oool01@000000oooo0?ooo`3oool0000000<0oooo0`0000020?ooo`<0000000H0oooo00000000
000000000?ooo`0000030?ooo`040000003oool0oooo0?ooo`<000000P3oool3000000040?ooo`00
00000000000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000000B0?ooo`030000
003oool0000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0000003o0?oooc`0oooo
00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0080VIVI0P0c<c==0?ooo`050000003oool0oooo0?ooo`000000403oool01@000000oooo
0?ooo`3oool000000180oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000<0oooo0`0000050?ooo`030000003oool000000180oooo00<000000?ooo`00
00002`3oool00`000000oooo0000003o0?oooc`0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0
VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c=<0?ooo`D00000
403oool5000001<0oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000
1@3oool00`000000oooo0?ooo`030?ooo`030000003oool000000180oooo00<000000?ooo`000000
2`3oool00`000000oooo0000003o0?oooc`0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?oo
o`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=[0?ooo`8000001P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0?l0ooooL@3o
ool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<f/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0o`3ooomW0?ooo`030000o`3oool0
oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VI
V@80<c<c?P3oool300000080oooo0P0000020?ooo`<00000103oool00`000000oooo000000020?oo
o`D00000103oool300000080oooo0P0000030?ooo`8000000`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`3o0?oo
ofH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`3o0?ooofH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0
VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooomc0?ooo`030000o`3oool0oooo00<0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`3o0?ooog<0oooo00<0003o0?ooo`3oool00`3o
ool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o
0?ooo`@000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`@000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0o`3ooomc0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c?`3oool01@000000oooo0?ooo`3oool0000000<0
oooo0`0000020?ooo`<0000000H0oooo00000000000000000?ooo`0000030?ooo`040000003oool0
oooo0?ooo`<000000P3oool3000000040?ooo`0000000000000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0000003o0?ooofd0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<o0?ooo`050000003o
ool0oooo0?ooo`000000403oool01@000000oooo0?ooo`3oool000000180oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0000000H0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0000003o0?ooofd0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0
VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<n0?ooo`D00000
403oool5000001<0oooo0P0000060?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000
1`3oool01`000000oooo0?ooo`3oool000000?ooo`000000o`3ooom]0?ooo`030000o`3oool0oooo
00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00<0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU
09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooof0?oo
o`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<cG@3oool2000000H0oooo00<000000?ooo`3oool0o`3ooon>0?ooo`03
0000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<cG@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`3o0?oooe80oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c<`0?ooo`<000000P3oool200000080oooo0`0000040?ooo`030000003oool000000080oooo1@00
00040?ooo`<000000P3oool2000000<0oooo0P0000030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02@3oool5000000X0oooo00<000000?ooo`3oool0803oool00`000000oooo0?oo
o`3o0?oooe40oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<a0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`000000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00D00000
0?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0o`3o
oomA0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo000000020?ooo`050000003oool000000?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0?l0ooooPP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<c40oooo00@000000?ooo`3oool000000`3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`000000oooo000000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0o`3ooon10?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c<@3oool4000000<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool4000000<0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0?l0ooooP03oool00`000?l0oooo0?oo
o`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT2
03<c<c40oooo00D000000?ooo`3oool0oooo000000030?ooo`<000000P3oool3000000060?ooo`00
000000000000003oool000000`3oool010000000oooo0?ooo`3oool300000080oooo0`000000103o
ool000000000000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0000
000B0?ooo`030000003oool0000000/0oooo00<000000?ooo`000000o`3ooomH0?ooo`030000o`3o
ool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c<@3oool01@000000oooo0?ooo`3oool000000100oooo00D000000?ooo`3oool0oooo
0000000B0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0000000B0?ooo`03
0000003oool0000000/0oooo00<000000?ooo`000000o`3ooomH0?ooo`030000o`3oool0oooo00<0
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
<03oool500000100oooo1@00000C0?ooo`8000001P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000@0oooo0`0000040?ooo`030000003oool000000180oooo00<000000?ooo`000000
2`3oool00`000000oooo0000003o0?oooeP0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI
09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0
003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@02
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?oo
o`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool0
0`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c
<c=b0?ooo`800000o`3ooon20?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cLP3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0?l0ooooI`3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b80oooo100000040?oo
o`@00000103oool3000000040?ooo`000000oooo0?ooo`<000001@3oool300000080oooo1@000003
0?ooo`<000000P3oool300000080oooo1`0000040?ooo`<000000P3oool2000000<0oooo0P000003
0?ooo`030000003oool0oooo00T0oooo1@00000:0?ooo`030000003oool0oooo0?l0ooooIP3oool0
0`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GU
i@2IVIT00P2IVIT203<c<b<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0
00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
o`3ooomV0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo
00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0o`3ooomc0?ooo`030000o`3oool0oooo00<0oooo00<0
iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool0
0`000000oooo000000050?ooo`030000003oool0oooo00@0oooo100000020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00/0oooo00<000000?ooo`3oool0o`3ooomc0?ooo`030000o`3oool0oooo
00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<c8`3oool3000000D0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000030?oo
o`050000003oool0oooo0?ooo`0000001`3oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool200000080oooo00<000000?ooo`3oool0100000030?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0o`3ooomc0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8`3oool01@000000oooo0000
003oool000000080oooo00<000000?ooo`0000000P0000020?ooo`@00000103oool3000000<0oooo
1@0000020?ooo`<000001@3oool300000080oooo00<000000?ooo`0000000P0000030?ooo`050000
003oool0oooo0?ooo`0000000`3oool300000080oooo0`000000103oool000000000000000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`030?oo
o`030000003oool000000?l0ooooK@3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI
0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b<0oooo00D000000?ooo`3o
ool0oooo0000000H0?ooo`030000003oool0oooo01P0oooo00D000000?ooo`3oool0oooo0000000B
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool3000000D0oooo00<00000
0?ooo`000000o`3ooom]0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c8P3oool6000001P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0?0?ooo`D000004`3oool2000000@0oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`030?ooo`030000003oool000000?l0ooooK@3oool00`00
0?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`03
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<d40oooo0P0000060?ooo`030000003oool0oooo0?l0
ooooZP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<d40oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`3o0?oooj/0oooo00<0003o0?ooo`3oool00`3oool00`3UiND0VIVI09VIV@0209VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<D0?ooo`<000000P3oool200000080oooo0`00
00040?ooo`030000003oool000000080oooo1@0000040?ooo`<000000P3oool2000000<0oooo0P00
00030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o`3ooon[0?ooo`030000o`3o
ool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@02
09VIV@80<c<c5@3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooj/0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?oo
o`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0?l0ooooZ`3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI
0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo00@000000?ooo`3o
ool000000`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`000000oooo0000
00020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0
oooo[03oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<aD0oooo100000030?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo100000030?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0o`3ooon[0?ooo`030000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT2
03<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c5@3oool01@000000oooo0?ooo`3oool0
000000<0oooo0`0000020?ooo`<0000000H0oooo00000000000000000?ooo`0000030?ooo`040000
003oool0oooo0?ooo`<000000P3oool3000000040?ooo`0000000000000000<0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`3o0?oooj/0oooo00<0003o0?ooo`3oool00`3oool00`3U
iND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<E0?ooo`05
0000003oool0oooo0?ooo`000000403oool01@000000oooo0?ooo`3oool000000180oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`3o0?oooj/0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<D0?oo
o`D00000403oool5000001<0oooo0P0000060?ooo`030000003oool0oooo0?l0ooooZP3oool00`00
0?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo
0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`03
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<ol0oooomP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<bD0oooo0P00000f0?ooo`800000o`3ooonG0?ooo`03
0000o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<c9@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0?l0oooo
UP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0
oooo0>GUi@2IVIT00P2IVIT203<c<`P0oooo0`0000040?ooo`<000000`3oool6000000030?ooo`00
0000000000@000000`3oool010000000oooo0?ooo`3oool5000000@0oooo0`0000020?ooo`800000
0`3oool7000000@0oooo0`0000000`3oool000000?ooo`020?ooo`<000000`3oool3000000030?oo
o`000000oooo0080oooo00<000000?ooo`3oool0o`3ooonF0?ooo`030000o`3oool0oooo00<0oooo
00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c1`3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool000000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`3o0?oooiH0oooo00<0003o0?ooo`3oool00`3oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<70?oo
o`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`050000003oool0
oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`000000
0`3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0
oooo0?l0ooooUP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<1
0?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo00<000000?ooo`3oool0103oool50000
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000103o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool4000000<0oooo
00<000000?ooo`3oool0103oool4000000@0oooo00<000000?ooo`3oool0o`3ooonF0?ooo`030000
o`3oool0oooo00<0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VI
V@0209VIV@80<c<c1`3oool00`000000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`000000
103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0P3oool4000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0
oooo00D000000?ooo`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000002@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0ooooUP3oool00`000?l0oooo0?ooo`03
0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c
<`L0oooo00D000000?ooo`3oool0oooo000000030?ooo`<000001@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo0`0000020?ooo`<0000000H0oooo00000000000000000?ooo`0000030?ooo`03
0000003oool0oooo00@000000`3oool500000080oooo100000050?ooo`030000003oool0oooo0?l0
ooooUP3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<`L0oooo00D000000?ooo`3oool0oooo0000000;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`05
0000003oool0oooo0?ooo`000000403oool01@000000oooo0?ooo`3oool0000000X0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`3o0?oooi<0oooo10000?l50?ooo`030>GUi@2IVIT0
VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`P0oooo0`00000:0?oo
o`<00000103oool3000000H0oooo0P0000020?ooo`D00000403oool5000000/0oooo00<000000?oo
o`3oool0303oool200000?l0ooooU`3oool00`000?l0oooo0?ooo`030?ooo`030>GUi@2IVIT0VIVI
0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooolP3oool50000o`D0
oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2I
VIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3o
ool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool00`3UiND0VIVI09VIV@0209VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?oooo`0oooo00<0iNGU09VIV@2IVIT0
0P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3ooool0?ooo`030>GUi@2I
VIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo03oool0
0`3UiND0VIVI09VIV@0209VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?n03<c
<`030>GUi@2IVIT0VIVI0080VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIWo03<c<oh0
<c<c00<0iNGU09VIV@2IVIT00P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI
1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo0000
0`3oool0iNGU09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@3o09VI
VOl0VIVI1P2IVIT203<c<`40oooo00000`3oool0iNGU0>GUi@3o0>GUiOl0iNGU1`3UiND103<c<`40
oooo003o0?ooool0oooo303oool00001\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 216},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.9.3"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToString[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a string representing the specified textual form of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ToBoxes[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "create a box structure representing the specified textual form \
of ",
              StyleBox["expr", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.3"],

Cell["Creating strings and boxes from expressions. ", "Caption",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.4 The Interpretation of Textual Forms", "Subsection",
  CellTags->{"S2.9.4", "4.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToExpression[", "MR"],
              StyleBox["input", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "create an expression by interpreting strings or boxes "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.4"],

Cell["Converting from strings or boxes to expressions. ", "Caption",
  CellTags->"S2.9.4"],

Cell["This takes a string and interprets it as an expression. ", "MathCaption",
  CellTags->{"S2.9.4", "4.2"}],

Cell[CellGroupData[{

Cell["ToExpression[\"2 + 3 + x/y\"]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(5 + x\/y\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the box structure corresponding to the textual form of an \
expression in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.3"}],

Cell[CellGroupData[{

Cell["ToBoxes[2 + x^2, StandardForm]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(RowBox[{"2", "+", SuperscriptBox["x", "2"]}]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToExpression", "MR"],
  " interprets this box structure and yields the original expression again. "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.4"}],

Cell[CellGroupData[{

Cell["ToExpression[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(2 + x\^2\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "In any ",
  StyleBox["Mathematica", "TI"],
  " session, ",
  StyleBox["Mathematica", "TI"],
  " is always effectively using ",
  StyleBox["ToExpression", "MR"],
  " to interpret the textual form of your input as an actual expression to \
evaluate. "
}], "Text",
  CellTags->{"S2.9.4", "4.5"}],

Cell[TextData[{
  "If you use the notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then the interpretation only takes place when the contents of a cell are \
sent to the kernel, say for evaluation. This means that within a notebook \
there is no need for the textual forms you set up to correspond to meaningful \
",
  StyleBox["Mathematica", "TI"],
  " expressions; this is only necessary if you want to send these forms to \
the kernel. "
}], "Text",
  CellTags->{"S2.9.4", "4.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FullForm", "MR"],
              " "
            }]], Cell["explicit functional notation "]},
          {Cell[TextData[{
              StyleBox["InputForm", "MR"],
              " "
            }]], Cell["one\[Hyphen]dimensional notation "]},
          {Cell[TextData[{
              StyleBox["StandardForm", "MR"],
              " "
            }]], Cell["two\[Hyphen]dimensional notation "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.4"],

Cell[TextData[{
  "The hierarchy of forms for standard ",
  StyleBox["Mathematica", "SO"],
  " input. "
}], "Caption",
  CellTags->"S2.9.4"],

Cell[TextData[{
  "Here is an expression entered in ",
  StyleBox["FullForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.7"}],

Cell[CellGroupData[{

Cell["Plus[1, Power[x, 2]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(1 + x\^2\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "Here is the same expression entered in ",
  StyleBox["InputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.8"}],

Cell[CellGroupData[{

Cell["1 + x^2", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(1 + x\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "And here is the expression entered in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.9"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 + x\^2\)], "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(1 + x\^2\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "Built into ",
  StyleBox["Mathematica", "TI"],
  " is a collection of standard rules for use by ",
  StyleBox["ToExpression", "MR"],
  " in converting textual forms to expressions. "
}], "Text",
  CellTags->{"S2.9.4", "4.10"}],

Cell[TextData[{
  "These rules define the ",
  StyleBox["grammar", "TI"],
  " of ",
  StyleBox["Mathematica", "TI"],
  ". They state, for example, that ",
  StyleBox["x", "TI"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["y", "TI"],
  " should be interpreted as ",
  StyleBox["Plus[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ", and that ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], 
        StyleBox["y",
          "TI"]]], "InlineFormula"],
  " should be interpreted as ",
  StyleBox["Power[", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["]", "MR"],
  ". If the input you give is in ",
  StyleBox["FullForm", "MR"],
  ", then the rules for interpretation are very straightforward: every \
expression consists just of a head followed by a sequence of elements \
enclosed in brackets. The rules for ",
  StyleBox["InputForm", "MR"],
  " are slightly more sophisticated: they allow operators such as ",
  StyleBox["+", "MR"],
  ", ",
  StyleBox["=", "MR"],
  ", and ",
  StyleBox["->", "MR"],
  ", and understand the meaning of expressions where these operators appear \
between operands. ",
  StyleBox["StandardForm", "MR"],
  " involves still more sophisticated rules, which allow operators and \
operands to be arranged not just in a one\[Hyphen]dimensional sequence, but \
in a full two\[Hyphen]dimensional structure.  "
}], "Text",
  CellTags->{"S2.9.4", "4.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " is set up so that ",
  StyleBox["FullForm", "MR"],
  ", ",
  StyleBox["InputForm", "MR"],
  " and ",
  StyleBox["StandardForm", "MR"],
  " form a strict hierarchy: anything you can enter in ",
  StyleBox["FullForm", "MR"],
  " will also work in ",
  StyleBox["InputForm", "MR"],
  ", and anything you can enter in ",
  StyleBox["InputForm", "MR"],
  " will also work in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.4", "4.12"}],

Cell[TextData[{
  "If you use a notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then you will typically want to use all the features of ",
  StyleBox["StandardForm", "MR"],
  ". If you use a text\[Hyphen]based interface, however, then you will \
typically be able to use only features of ",
  StyleBox["InputForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.4", "4.13"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x^2", "MR"],
              " "
            }]], Cell[TextData[{
              "ordinary ",
              StyleBox["InputForm", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](x\[Backslash]^2\[Backslash])", "MR"],
              " "
            }]], Cell[TextData[{
              "one\[Hyphen]dimensional representation of ",
              StyleBox["StandardForm", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.4"],

Cell[TextData[{
  "Two versions of ",
  StyleBox["InputForm", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.9.4"],

Cell[TextData[{
  "When you use ",
  StyleBox["StandardForm", "MR"],
  " in a ",
  StyleBox["Mathematica", "TI"],
  " notebook, you can enter directly two\[Hyphen]dimensional forms such as ",
  Cell[BoxData[
      \(x\^2\)], "InlineFormula"],
  ". But ",
  StyleBox["InputForm", "MR"],
  " allows only one\[Hyphen]dimensional forms. Nevertheless, even though the \
actual text you give in ",
  StyleBox["InputForm", "MR"],
  " must be one\[Hyphen]dimensional, it is still possible to make it \
represent a two\[Hyphen]dimensional form. Thus, for example, \[Backslash]",
  StyleBox["!\[Backslash](x\[Backslash]^2\[Backslash])", "MR"],
  " represents the two\[Hyphen]dimensional form ",
  Cell[BoxData[
      \(x\^2\)], "InlineFormula"],
  ", and is interpreted by ",
  StyleBox["Mathematica", "TI"],
  " as ",
  StyleBox["Power[x,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.4", "4.14"}],

Cell["\<\
Here is ordinary one\[Hyphen]dimensional input. \
\>", "MathCaption",
  CellTags->{"S2.9.4", "4.15"}],

Cell[CellGroupData[{

Cell["x^2 + 1/y", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(x\^2 + 1\/y\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell["\<\
Here is input that represents a two\[Hyphen]dimensional form. \
\
\>", "MathCaption",
  CellTags->{"S2.9.4", "4.16"}],

Cell[CellGroupData[{

Cell["\\!\\( x\\^2 + 1\\/y \\)", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(x\^2 + 1\/y\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell["\<\
Even though the input is given differently, the expressions \
obtained on the last two lines are exactly the same. \
\>", "MathCaption",
  CellTags->{"S2.9.4", "4.17"}],

Cell[CellGroupData[{

Cell["% == %%", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "If you copy a two\[Hyphen]dimensional form out of ",
  StyleBox["Mathematica", "TI"],
  ", it is normally given in \[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " form. When you paste this one\[Hyphen]dimensional form back into a ",
  StyleBox["Mathematica", "TI"],
  " notebook, it will automatically \[OpenCurlyDoubleQuote]snap\
\[CloseCurlyDoubleQuote] into two\[Hyphen]dimensional form. If you simply \
type a \[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " form into a notebook, you can get it to snap into two\[Hyphen]dimensional \
form using the ",
  StyleBox["Make 2D", "SR"],
  " menu item.       "
}], "Text",
  CellTags->{"S2.9.4", "4.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToExpression[", "MR"],
              StyleBox["input", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "attempt to create an expression assuming that ",
              StyleBox["input", "TI"],
              " is given in the specified textual form "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.4"],

Cell["Importing from other textual forms. ", "Caption",
  CellTags->"S2.9.4"],

Cell[TextData[{
  StyleBox["StandardForm", "MR"],
  " and its subsets ",
  StyleBox["FullForm", "MR"],
  " and ",
  StyleBox["InputForm", "MR"],
  " provide precise ways to represent any ",
  StyleBox["Mathematica", "TI"],
  " expression in textual form. And given such a textual form, it is always \
possible to convert it unambiguously to the expression it represents. "
}], "Text",
  CellTags->{"S2.9.4", "4.19"}],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " is an example of a textual form intended primarily for output. It is \
possible to take any ",
  StyleBox["Mathematica", "TI"],
  " expression and display it in ",
  StyleBox["TraditionalForm", "MR"],
  ". But ",
  StyleBox["TraditionalForm", "MR"],
  " does not have the precision of ",
  StyleBox["StandardForm", "MR"],
  ", and as a result there is in general no unambiguous way to go back from a \
",
  StyleBox["TraditionalForm", "MR"],
  " representation and get the expression it represents.  "
}], "Text",
  CellTags->{"S2.9.4", "4.20"}],

Cell[TextData[{
  "Nevertheless, ",
  StyleBox["ToExpression[", "MR"],
  StyleBox["input", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["TraditionalForm]", "MR"],
  " takes text in ",
  StyleBox["TraditionalForm", "MR"],
  " and attempts to interpret it as an expression. "
}], "Text",
  CellTags->{"S2.9.4", "4.21"}],

Cell[TextData[{
  "This takes a string and interprets it as ",
  StyleBox["TraditionalForm", "MR"],
  " input. "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.22"}],

Cell[CellGroupData[{

Cell["ToExpression[\"f(6)\", TraditionalForm]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(f[6]\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["StandardForm", "MR"],
  " the same string would mean a product of terms. "
}], "MathCaption",
  CellTags->{"S2.9.4", "4.23"}],

Cell[CellGroupData[{

Cell["ToExpression[\"f(6)\", StandardForm]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.4"],

Cell[BoxData[
    \(6\ f\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.9.4"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["TraditionalForm", "MR"],
  " output is generated as the result of a computation, the actual collection \
of boxes that represent the output typically contains special ",
  StyleBox["InterpretationBox", "MR"],
  " and ",
  StyleBox["TagBox", "MR"],
  " objects which specify how an expression can be reconstructed from the ",
  StyleBox["TraditionalForm", "MR"],
  " output. "
}], "Text",
  CellTags->{"S2.9.4", "4.24"}],

Cell[TextData[{
  "The same is true of ",
  StyleBox["TraditionalForm", "MR"],
  " that is obtained by explicit conversion from ",
  StyleBox["StandardForm", "MR"],
  ". But if you edit ",
  StyleBox["TraditionalForm", "MR"],
  " extensively, or enter it from scratch, then ",
  StyleBox["Mathematica", "TI"],
  " will have to try to interpret it without the benefit of any additional \
embedded information.  "
}], "Text",
  CellTags->{"S2.9.4", "4.25"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.5 Short and Shallow Output", "Subsection",
  CellTags->{"S2.9.5", "5.1"}],

Cell[TextData[{
  "When you generate a very large output expression in ",
  StyleBox["Mathematica", "TI"],
  ", you often do not want to see the whole expression at once. Rather, you \
would first like to get an idea of the general structure of the expression, \
and then, perhaps, go in and look at particular parts in more detail. "
}], "Text",
  CellTags->{"S2.9.5", "5.2"}],

Cell[TextData[{
  "The functions ",
  StyleBox["Short", "MR"],
  " and ",
  StyleBox["Shallow", "MR"],
  " allow you to see \[OpenCurlyDoubleQuote]outlines\[CloseCurlyDoubleQuote] \
of large ",
  StyleBox["Mathematica", "TI"],
  " expressions. "
}], "Text",
  CellTags->{"S2.9.5", "5.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Short[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "show a one\[Hyphen]line outline of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Short[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "show an ",
              StyleBox["n", "TI"],
              "\[Hyphen]line outline of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Shallow[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "show the \[OpenCurlyDoubleQuote]top parts\
\[CloseCurlyDoubleQuote] of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Shallow[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["depth", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["length", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "show the parts of ",
              StyleBox["expr", "TI"],
              " to the specified depth and length "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.5"],

Cell["Showing outlines of expressions. ", "Caption",
  CellTags->"S2.9.5"],

Cell["\<\
This generates a long expression. If the whole expression were \
printed out here, it would go on for 23 lines. \
\>", "MathCaption",
  CellTags->{"S2.9.5", "5.4"}],

Cell["t = Expand[(1 + x + y)^12] ;", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.5"],

Cell[TextData[{
  "This gives a one\[Hyphen]line \[OpenCurlyDoubleQuote]outline\
\[CloseCurlyDoubleQuote] of ",
  StyleBox["t", "MR"],
  ". The ",
  StyleBox["<<87>>", "MR"],
  " indicates that 87 terms are omitted. "
}], "MathCaption",
  CellTags->{"S2.9.5", "5.5"}],

Cell[CellGroupData[{

Cell["Short[t]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    TagBox[\(1 + 12\ x + \[LeftSkeleton]87\[RightSkeleton] + 12\ x\ y\^11 + 
        y\^12\),
      Short]], "Output",
  CellLabel->"Out[2]//Short= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " generates output, it first effectively writes the output in one long row. \
Then it looks at the width of text you have asked for, and it chops the row \
of output into a sequence of separate \[OpenCurlyDoubleQuote]lines\
\[CloseCurlyDoubleQuote]. Each of the \[OpenCurlyDoubleQuote]lines\
\[CloseCurlyDoubleQuote] may of course contain superscripts and \
built\[Hyphen]up fractions, and so may take up more than one actual line on \
your output device. When you specify a particular number of lines in ",
  StyleBox["Short", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " takes this to be the number of \[OpenCurlyDoubleQuote]logical lines\
\[CloseCurlyDoubleQuote] that you want, not the number of actual physical \
lines on your particular output device.  "
}], "Text",
  CellTags->{"S2.9.5", "5.6"}],

Cell[TextData[{
  "Here is a four\[Hyphen]line version of ",
  StyleBox["t", "MR"],
  ". More terms are shown in this case. "
}], "MathCaption",
  CellTags->{"S2.9.5", "5.7"}],

Cell[CellGroupData[{

Cell["Short[t, 4]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    TagBox[\(1 + 12\ x + 66\ x\^2 + 220\ x\^3 + 495\ x\^4 + 792\ x\^5 + 
        924\ x\^6 + 792\ x\^7 + 495\ x\^8 + 220\ x\^9 + 66\ x\^10 + 
        12\ x\^11 + \[LeftSkeleton]68\[RightSkeleton] + 495\ x\^4\ y\^8 + 
        220\ y\^9 + 660\ x\ y\^9 + 660\ x\^2\ y\^9 + 220\ x\^3\ y\^9 + 
        66\ y\^10 + 132\ x\ y\^10 + 66\ x\^2\ y\^10 + 12\ y\^11 + 
        12\ x\ y\^11 + y\^12\),
      (Short[ #, 4]&)]], "Output",
  CellLabel->"Out[3]//Short= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["Short", "MR"],
  " with other output forms, such as ",
  StyleBox["InputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.5", "5.8"}],

Cell[CellGroupData[{

Cell["Short[InputForm[t]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    TagBox[
      FrameBox["\<\"1 + 12*x + 66*x^2 + 220*x^3 + <<85>> + 12*x*y^11 + y^12\"\
\>",
        BoxFrame->False,
        BoxMargins->False],
      Short]], "Output",
  CellLabel->"Out[4]//Short= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Short", "MR"],
  " works by removing a sequence of parts from an expression until the output \
form of the result fits on the number of lines you specify. Sometimes, \
however, you may find it better to specify not how many final output lines \
you want, but which parts of the expression to drop. ",
  StyleBox["Shallow[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["depth", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["length", "TI"],
  StyleBox["}]", "MR"],
  " includes only ",
  StyleBox["length", "TI"],
  " arguments to any function, and drops all subexpressions that are below \
the specified depth. "
}], "Text",
  CellTags->{"S2.9.5", "5.9"}],

Cell[TextData[{
  StyleBox["Shallow", "MR"],
  " shows a different outline of\[NonBreakingSpace]",
  StyleBox["t", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.5", "5.10"}],

Cell[CellGroupData[{

Cell["Shallow[t]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    \(1 + 12\ x + 66\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      220\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      495\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      792\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      924\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      792\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      495\ Power[\[LeftSkeleton]2\[RightSkeleton]] + 
      220\ Power[\[LeftSkeleton]2\[RightSkeleton]] + \[LeftSkeleton]81\
\[RightSkeleton]\)], "Output",
  CellLabel->"Out[5]//Shallow= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell["\<\
This includes only 10 arguments to each function, but allows any \
depth. \
\>", "MathCaption",
  CellTags->{"S2.9.5", "5.11"}],

Cell[CellGroupData[{

Cell["Shallow[t, {Infinity, 10}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    \(1 + 12\ x + 66\ x\^2 + 220\ x\^3 + 495\ x\^4 + 792\ x\^5 + 924\ x\^6 + 
      792\ x\^7 + 495\ x\^8 + 
      220\ x\^9 + \[LeftSkeleton]81\[RightSkeleton]\)], "Output",
  CellLabel->"Out[6]//Shallow= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Shallow", "MR"],
  " is particularly useful when you want to drop parts in a uniform way \
throughout a highly nested expression, such as a large list structure \
returned by ",
  StyleBox["Trace", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.5", "5.12"}],

Cell["Here is the recursive definition of the Fibonacci function. ", \
"MathCaption",
  CellTags->{"S2.9.5", "5.13"}],

Cell[CellGroupData[{

Cell["fib[n_] := fib[n-1] + fib[n-2] ; fib[0] = fib[1] = 1", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell["This generates a large list structure. ", "MathCaption",
  CellTags->{"S2.9.5", "5.14"}],

Cell["tr = Trace[fib[8]] ;", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.5"],

Cell[TextData[{
  "You can use ",
  StyleBox["Shallow", "MR"],
  " to see an outline of the structure. "
}], "MathCaption",
  CellTags->{"S2.9.5", "5.15"}],

Cell[CellGroupData[{

Cell["Shallow[tr]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(fib[\[LeftSkeleton]1\[RightSkeleton]]\),
          HoldForm], ",", 
        TagBox[\(Plus[\[LeftSkeleton]2\[RightSkeleton]]\),
          HoldForm], ",", 
        RowBox[{"{", 
          RowBox[{\({\[LeftSkeleton]2\[RightSkeleton]}\), ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm], ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm], ",", \({\[LeftSkeleton]7\[RightSkeleton]}\), 
            ",", \({\[LeftSkeleton]7\[RightSkeleton]}\), ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm], ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\({\[LeftSkeleton]2\[RightSkeleton]}\), ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm], ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm], ",", \({\[LeftSkeleton]7\[RightSkeleton]}\), 
            ",", \({\[LeftSkeleton]7\[RightSkeleton]}\), ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm], ",", 
            TagBox[\(\[LeftSkeleton]1\[RightSkeleton]\),
              HoldForm]}], "}"}], ",", 
        TagBox[\(Plus[\[LeftSkeleton]2\[RightSkeleton]]\),
          HoldForm], ",", 
        TagBox["34",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[9]//Shallow= ",
  CellTags->"S2.9.5"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Short", "MR"],
  " gives you a less uniform outline, which can be more difficult to \
understand. "
}], "MathCaption",
  CellTags->{"S2.9.5", "5.16"}],

Cell[CellGroupData[{

Cell["Short[tr, 4]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.5"],

Cell[BoxData[
    TagBox[\({fib[8], 
        fib[8 - 1] + fib[8 - 2], {{8 - 1, 7}, 
          fib[7], \[LeftSkeleton]3\[RightSkeleton], 13 + 8, 
          21}, {\[LeftSkeleton]1\[RightSkeleton]}, 21 + 13, 34}\),
      (Short[ #, 3]&)]], "Output",
  CellLabel->"Out[10]//Short= ",
  CellTags->"S2.9.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.9.6 String\[Hyphen]Oriented Output Formats\
\>", "Subsection",
  CellTags->{"S2.9.6", "6.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["a string containing arbitrary text "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.6"],

Cell["Text strings. ", "Caption",
  CellTags->"S2.9.6"],

Cell[TextData[{
  "The quotes are not included in standard ",
  StyleBox["Mathematica", "TI"],
  " output form. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.2"}],

Cell[CellGroupData[{

Cell["\"This is a string.\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    \("This is a string."\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell["In input form, the quotes are included. ", "MathCaption",
  CellTags->{"S2.9.6", "6.3"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.6"],

Cell["\"This is a string.\"", "Output",
  CellLabel->"Out[2]//InputForm= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "You can put any kind of text into a ",
  StyleBox["Mathematica", "TI"],
  " string. This includes non\[Hyphen]English characters, as well as newlines \
and other control information. Section ",
  ButtonBox["2.8",
    ButtonData:>{"2.8"},
    ButtonStyle->"MainBookLink"],
  " discusses in more detail how strings work. "
}], "Text",
  CellTags->{"S2.9.6", "6.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StringForm[\"", "MR"],
              StyleBox["cccc", "TI"],
              StyleBox["``", "MR"],
              StyleBox["cccc", "TI"],
              StyleBox["\",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "output a string in which successive ",
              StyleBox["``", "MR"],
              " are replaced by successive ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["StringForm[\"", "MR"],
              StyleBox["cccc", "TI"],
              StyleBox["`", "MR"],
              StyleBox["i", "TI"],
              StyleBox["`", "MR"],
              StyleBox["cccc", "TI"],
              StyleBox["\",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "output a string in which each ",
              StyleBox["`", "MR"],
              StyleBox["i", "TI"],
              StyleBox["`", "MR"],
              " is replaced by the corresponding ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.6"],

Cell["Using format strings. ", "Caption",
  CellTags->"S2.9.6"],

Cell[TextData[{
  "In many situations, you may want to generate output using a string as a \
\[OpenCurlyDoubleQuote]template\[CloseCurlyDoubleQuote], but \
\[OpenCurlyDoubleQuote]splicing\[CloseCurlyDoubleQuote] in various ",
  StyleBox["Mathematica", "TI"],
  " expressions. You can do this using ",
  StyleBox["StringForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.6", "6.5"}],

Cell[TextData[{
  "This generates output with each successive ",
  StyleBox["``", "MR"],
  " replaced by an expression. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.6"}],

Cell[CellGroupData[{

Cell["StringForm[\"x = ``, y = ``\", 3, (1 + u)^2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    InterpretationBox["\<\"x = \\!\\(3\\), y = \\!\\(\\((1 + \
u)\\)\\^2\\)\"\>",
      StringForm[ "x = ``, y = ``", 3, 
        Power[ 
          Plus[ 1, u], 2]],
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell["You can use numbers to pick out expressions in any order. ", \
"MathCaption",
  CellTags->{"S2.9.6", "6.7"}],

Cell[CellGroupData[{

Cell["StringForm[\"{`1`, `2`, `1`}\", a, b]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    InterpretationBox["\<\"{\\!\\(a\\), \\!\\(b\\), \\!\\(a\\)}\"\>",
      StringForm[ "{`1`, `2`, `1`}", a, b],
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "The string in ",
  StyleBox["StringForm", "MR"],
  " acts somewhat like a \[OpenCurlyDoubleQuote]format directive\
\[CloseCurlyDoubleQuote] in the formatted output statements of languages such \
as C and Fortran. You can determine how the expressions in ",
  StyleBox["StringForm", "MR"],
  " will be formatted by wrapping them with standard output format functions. \
"
}], "Text",
  CellTags->{"S2.9.6", "6.8"}],

Cell[TextData[{
  "You can specify how the expressions in ",
  StyleBox["StringForm", "MR"],
  " are formatted using standard output format functions. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.9"}],

Cell[CellGroupData[{

Cell["\<\
StringForm[\"The `` of `` is ``.\", TeXForm, a/b, \
TeXForm[a/b]]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    InterpretationBox["\<\"The \\!\\(TeXForm\\) of \\!\\(a\\/b\\) is \
\\!\\(\\*StyleBox[\\\"\\\\\\\\frac{a}{b}\\\", Rule[ShowStringCharacters, \
True], Rule[NumberMarks, True]]\\).\"\>",
      StringForm[ "The `` of `` is ``.", TeXForm, 
        Times[ a, 
          Power[ b, -1]], 
        TeXForm[ 
          Times[ a, 
            Power[ b, -1]]]],
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "You should realize that ",
  StyleBox["StringForm", "MR"],
  " is only an output format. It does not evaluate in any way. You can use \
the function ",
  StyleBox["ToString", "MR"],
  " to create an ordinary string from a ",
  StyleBox["StringForm", "MR"],
  " object. "
}], "Text",
  CellTags->{"S2.9.6", "6.10"}],

Cell[TextData[{
  StyleBox["StringForm", "MR"],
  " generates formatted output in standard ",
  StyleBox["Mathematica", "TI"],
  " output form. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.11"}],

Cell[CellGroupData[{

Cell["StringForm[\"Q: `` -> ``\", a, b]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    InterpretationBox["\<\"Q: \\!\\(a\\) -> \\!\\(b\\)\"\>",
      StringForm[ "Q: `` -> ``", a, b],
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "In input form, you can see the actual ",
  StyleBox["StringForm", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.12"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.6"],

Cell["StringForm[\"Q: `` -> ``\", a, b]", "Output",
  CellLabel->"Out[7]//InputForm= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "This creates an ordinary string from the ",
  StyleBox["StringForm", "MR"],
  " object. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.13"}],

Cell[CellGroupData[{

Cell["InputForm[ToString[%]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.6"],

Cell["\"Q: a -> b\"", "Output",
  CellLabel->"Out[8]//InputForm= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["StringForm", "MR"],
  " allows you to specify a \[OpenCurlyDoubleQuote]template string\
\[CloseCurlyDoubleQuote], then fill in various expressions. Sometimes all you \
want to do is to concatenate together the output forms for a sequence of \
expressions. You can do this using ",
  StyleBox["SequenceForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.6", "6.14"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SequenceForm[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the output forms of the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " concatenated together "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.6"],

Cell["Output of sequences of expressions. ", "Caption",
  CellTags->"S2.9.6"],

Cell[TextData[{
  StyleBox["SequenceForm", "MR"],
  " prints as a sequence of expressions concatenated together. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.15"}],

Cell[CellGroupData[{

Cell["SequenceForm[\"[x = \", 56, \"]\"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    InterpretationBox[\("[x = "\[InvisibleSpace]56\[InvisibleSpace]"]"\),
      SequenceForm[ "[x = ", 56, "]"],
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ColumnForm[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["\<\
a left\[Hyphen]aligned column of objects \
\>"]},
          {Cell[TextData[{
              StyleBox["ColumnForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["v", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a column with horizontal alignment ",
              StyleBox["h", "TI"],
              " (",
              StyleBox["Left", "MR"],
              ", ",
              StyleBox["Center", "MR"],
              " or ",
              StyleBox["Right", "MR"],
              "), and vertical alignment ",
              StyleBox["v", "TI"],
              " (",
              StyleBox["Below", "MR"],
              ", ",
              StyleBox["Center", "MR"],
              " or ",
              StyleBox["Above", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.6"],

Cell["Output of columns of expressions. ", "Caption",
  CellTags->"S2.9.6"],

Cell["This arranges the two expressions in a column. ", "MathCaption",
  CellTags->{"S2.9.6", "6.16"}],

Cell[CellGroupData[{

Cell["ColumnForm[{a + b, x^2}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(a + b\)},
          {\(x\^2\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        Plus[ a, b], 
        Power[ x, 2]}],
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["HoldForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give the output form of ",
              StyleBox["expr", "TI"],
              ", with ",
              StyleBox["expr", "TI"],
              " maintained unevaluated "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.6"],

Cell["Output of unevaluated expressions. ", "Caption",
  CellTags->"S2.9.6"],

Cell[TextData[{
  "Using text strings and functions like ",
  StyleBox["StringForm", "MR"],
  ", you can generate pieces of output that do not necessarily correspond to \
valid ",
  StyleBox["Mathematica", "TI"],
  " expressions. Sometimes, however, you want to generate output that \
corresponds to a valid ",
  StyleBox["Mathematica", "TI"],
  " expression, but only so long as the expression is not evaluated. The \
function ",
  StyleBox["HoldForm", "MR"],
  " maintains its argument unevaluated, but allows it to be formatted in the \
standard ",
  StyleBox["Mathematica", "TI"],
  " output form. "
}], "Text",
  CellTags->{"S2.9.6", "6.17"}],

Cell[TextData[{
  StyleBox["HoldForm", "MR"],
  " maintains ",
  StyleBox["1", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["1", "MR"],
  " unevaluated. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.18"}],

Cell[CellGroupData[{

Cell["HoldForm[1 + 1]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    TagBox[\(1 + 1\),
      HoldForm]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["HoldForm", "MR"],
  " prevents the actual assignment from being done. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.19"}],

Cell[CellGroupData[{

Cell["HoldForm[x = 3]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    TagBox[\(x = 3\),
      HoldForm]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.9.6"]
}, Open  ]],

Cell[TextData[{
  "If it was not for the ",
  StyleBox["HoldForm", "MR"],
  ", the power would be evaluated. "
}], "MathCaption",
  CellTags->{"S2.9.6", "6.20"}],

Cell[CellGroupData[{

Cell["HoldForm[34^78]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.6"],

Cell[BoxData[
    TagBox[\(34\^78\),
      HoldForm]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.9.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.7 Output Formats for Numbers", "Subsection",
  CellTags->{"S2.9.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ScientificForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["print all numbers in scientific notation "]},
          {Cell[TextData[{
              StyleBox["EngineeringForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
print all numbers in engineering notation (exponents \
divisible by 3) \
\>"]},
          {Cell[TextData[{
              StyleBox["AccountingForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["print all numbers in standard accounting format "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.7"],

Cell["Output formats for numbers. ", "Caption",
  CellTags->"S2.9.7"],

Cell["\<\
These numbers are given in the default output format. Large numbers \
are given in scientific notation. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.2"}],

Cell[CellGroupData[{

Cell["{6.7^-4, 6.7^6, 6.7^8}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    \({0.0004962503078612847`, 90458.38216900002`, 
      4.0606767755664107`*^6}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["This gives all numbers in scientific notation. ", "MathCaption",
  CellTags->{"S2.9.7", "7.3"}],

Cell[CellGroupData[{

Cell["ScientificForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("4.9625"\[Times]10\^"-4"\),
            0.0004962503078612847,
            AutoDelete->True], ",", 
          InterpretationBox[\("9.04584"\[Times]10\^"4"\),
            90458.382169000019,
            AutoDelete->True], ",", 
          InterpretationBox[\("4.06068"\[Times]10\^"6"\),
            4060676.7755664107,
            AutoDelete->True]}], "}"}],
      ScientificForm]], "Output",
  CellLabel->"Out[2]//ScientificForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
This gives the numbers in engineering notation, with exponents \
arranged to be multiples of three. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.4"}],

Cell[CellGroupData[{

Cell["EngineeringForm[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("496.25"\[Times]10\^"-6"\),
            0.0004962503078612847,
            AutoDelete->True], ",", 
          InterpretationBox[\("90.4584"\[Times]10\^"3"\),
            90458.382169000019,
            AutoDelete->True], ",", 
          InterpretationBox[\("4.06068"\[Times]10\^"6"\),
            4060676.7755664107,
            AutoDelete->True]}], "}"}],
      EngineeringForm]], "Output",
  CellLabel->"Out[3]//EngineeringForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
In accounting form, negative numbers are given in parentheses, and \
scientific notation is never used. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.5"}],

Cell[CellGroupData[{

Cell["AccountingForm[{5.6, -6.7, 10.^7}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"5.6\"\>",
            5.5999999999999996,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"(6.7)\"\>",
            -6.7000000000000002,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"10000000.\"\>",
            10000000,
            AutoDelete->True]}], "}"}],
      AccountingForm]], "Output",
  CellLabel->"Out[4]//AccountingForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["NumberForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print at most ",
              StyleBox["tot", "TI"],
              " digits of all approximate real numbers in ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ScientificForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use scientific notation with at most ",
              StyleBox["tot", "TI"],
              " digits "
            }]]},
          {Cell[TextData[{
              StyleBox["EngineeringForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use engineering notation with at most ",
              StyleBox["tot", "TI"],
              " digits "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.7"],

Cell["Controlling the printed precision of real numbers. ", "Caption",
  CellTags->"S2.9.7"],

Cell[TextData[{
  "Here is ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^9\)], "InlineFormula"],
  " to 30 decimal places. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.6"}],

Cell[CellGroupData[{

Cell["N[Pi^9, 30]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    \(29809.09933344621166650940240123965536386788`30. \)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "This prints just 10 digits of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\^9\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.7"}],

Cell[CellGroupData[{

Cell["NumberForm[%, 10]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"29809.09933\"\>",
        29809.09933344621166650940240123965536386788`42.47434885424721,
        AutoDelete->True],
      (NumberForm[ #, 10]&)]], "Output",
  CellLabel->"Out[6]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["This gives 12 digits, in engineering notation. ", "MathCaption",
  CellTags->{"S2.9.7", "7.8"}],

Cell[CellGroupData[{

Cell["EngineeringForm[%, 12]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("29.8090993334"\[Times]10\^"3"\),
        29809.09933344621166650940240123965536386788`42.47434885424721,
        AutoDelete->True],
      (EngineeringForm[ #, 12]&)]], "Output",
  CellLabel->"Out[7]//EngineeringForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["DigitBlock", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell["maximum length of blocks of digits between breaks "]},
          {Cell[TextData[{
              StyleBox["NumberSeparator", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\",\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              " ",
              StyleBox["\"}", "MR"],
              " "
            }]], 
            Cell["\<\
strings to insert at breaks between blocks of digits to \
the left and right of a decimal point \
\>"]},
          {Cell[TextData[{
              StyleBox["NumberPoint", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\".\"", "MR"],
              " "
            }]], Cell["string to use for a decimal point "]},
          {Cell[TextData[{
              StyleBox["NumberMultiplier", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"\[Backslash][Times]\"", "MR"],
              " "
            }]], 
            Cell["\<\
string to use for the multiplication sign in scientific \
notation \
\>"]},
          {Cell[TextData[{
              StyleBox["NumberSigns", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\"-\",", "MR"],
              " ",
              StyleBox["\"\"}", "MR"],
              " "
            }]], Cell[
            "strings to use for signs of negative and positive numbers "]},
          {Cell[TextData[{
              StyleBox["NumberPadding", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{\"\",", "MR"],
              " ",
              StyleBox["\"\"}", "MR"],
              " "
            }]], Cell["strings to use for padding on the left and right "]},
          {Cell[TextData[{
              StyleBox["SignPadding", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to insert padding after the sign "]},
          {Cell[TextData[{
              StyleBox["NumberFormat", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["function to generate final format of number "]},
          {Cell[TextData[{
              StyleBox["ExponentFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["function to determine the exponent to use "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.7"],

Cell["Options for number formatting. ", "Caption",
  CellTags->"S2.9.7"],

Cell["\<\
All the options in the table except the last one apply to both \
integers and approximate real numbers. \
\>", "Text",
  CellTags->{"S2.9.7", "7.9"}],

Cell[TextData[{
  "All the options can be used in any of the functions ",
  StyleBox["NumberForm", "MR"],
  ", ",
  StyleBox["ScientificForm", "MR"],
  ", ",
  StyleBox["EngineeringForm", "MR"],
  " and ",
  StyleBox["AccountingForm", "MR"],
  ". In fact, you can in principle reproduce the behavior of any one of these \
functions simply by giving appropriate option settings in one of the others. \
The default option settings listed in the table are those for ",
  StyleBox["NumberForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.7", "7.10"}],

Cell[TextData[{
  "Setting ",
  StyleBox["DigitBlock->", "MR"],
  StyleBox["n", "TI"],
  " breaks digits into blocks of length ",
  StyleBox["n", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.11"}],

Cell[CellGroupData[{

Cell["NumberForm[30!, DigitBlock->3]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"265,252,859,812,191,058,636,308,480,000,000\"\>",
        
        265252859812191058636308480000000,
        Editable->False],
      (NumberForm[ #, DigitBlock -> 3]&)]], "Output",
  CellLabel->"Out[8]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
You can specify any string to use as a separator between blocks of \
digits. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.12"}],

Cell[CellGroupData[{

Cell["NumberForm[30!, DigitBlock->5, NumberSeparator->\" \"]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"265 25285 98121 91058 63630 84800 00000\"\>",
        265252859812191058636308480000000,
        Editable->False],
      (NumberForm[ #, DigitBlock -> 5, NumberSeparator -> " "]&)]], "Output",
  CellLabel->"Out[9]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "This gives an explicit plus sign for positive numbers, and uses ",
  StyleBox["|", "MR"],
  " in place of a decimal point. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.13"}],

Cell[CellGroupData[{

Cell["\<\
NumberForm[{4.5, -6.8}, NumberSigns->{\"-\", \"+\"}, \
NumberPoint->\"|\"]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"+4|5\"\>",
            4.5,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"-6|8\"\>",
            -6.7999999999999998,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, NumberSigns -> {"-", "+"}, NumberPoint -> 
        "|"]&)]], "Output",
  CellLabel->"Out[10]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " prints an approximate real number, it has to choose whether scientific \
notation should be used, and if so, how many digits should appear to the left \
of the decimal point. What ",
  StyleBox["Mathematica", "TI"],
  " does is first to find out what the exponent would be if scientific \
notation were used, and one digit were given to the left of the decimal \
point. Then it takes this exponent, and applies any function given as the \
setting for the option ",
  StyleBox["ExponentFunction", "MR"],
  ". This function should return the actual exponent to be used, or ",
  StyleBox["Null", "MR"],
  " if scientific notation should not be used. "
}], "Text",
  CellTags->{"S2.9.7", "7.14"}],

Cell[TextData[{
  "The default is to use scientific notation for all numbers with exponents \
outside the range ",
  Cell[BoxData[
      \(TraditionalForm\`\(-5\)\)], "InlineFormula"],
  " to 5. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.15"}],

Cell[CellGroupData[{

Cell["{8.^5, 11.^7, 13.^9}", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    \({32768.`, 1.9487171`*^7, 1.0604499373`*^10}\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
This uses scientific notation only for numbers with exponents of 10 \
or more. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.16"}],

Cell[CellGroupData[{

Cell["\<\
NumberForm[%, ExponentFunction -> (If[-10 < # < 10, Null, \
#]&)]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"32768.\"\>",
            32768,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"19487171.\"\>",
            19487171,
            AutoDelete->True], ",", 
          InterpretationBox[\("1.06045"\[Times]10\^"10"\),
            10604499373,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, ExponentFunction -> (If[ 
          Less[ -10, #, 10], Null, #]&)]&)]], "Output",
  CellLabel->"Out[12]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["This forces all exponents to be multiples of 3. ", "MathCaption",
  CellTags->{"S2.9.7", "7.17"}],

Cell[CellGroupData[{

Cell["NumberForm[%, ExponentFunction -> (3 Quotient[#, 3]&)]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("32.768"\[Times]10\^"3"\),
            32768,
            AutoDelete->True], ",", 
          InterpretationBox[\("19.4872"\[Times]10\^"6"\),
            19487171,
            AutoDelete->True], ",", 
          InterpretationBox[\("10.6045"\[Times]10\^"9"\),
            10604499373,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, ExponentFunction -> (Times[ 3, 
          Quotient[ #, 3]]&)]&)]], "Output",
  CellLabel->"Out[13]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "Having determined what the mantissa and exponent for a number should be, \
the final step is to assemble these into the object to print. The option ",
  StyleBox["NumberFormat", "MR"],
  " allows you to give an arbitrary function which specifies the print form \
for the number. The function takes as arguments three strings: the mantissa, \
the base, and the exponent for the number. If there is no exponent, it is \
given as ",
  StyleBox["\"\"", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.7", "7.18"}],

Cell["\<\
This gives the exponents in Fortran\[Hyphen]like \
\[OpenCurlyDoubleQuote]e\[CloseCurlyDoubleQuote] format. \
\>", "MathCaption",\

  CellTags->{"S2.9.7", "7.19"}],

Cell[CellGroupData[{

Cell["\<\
NumberForm[{5.6^10, 7.8^20}, NumberFormat -> (SequenceForm[#1, \
\"e\", #3]&) ]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[
            
            InterpretationBox[\("3.03305"\[InvisibleSpace]"e"\[InvisibleSpace]\
"7"\),
              SequenceForm[ "3.03305", "e", "7"],
              Editable->False],
            30330548.909611396,
            Editable->False], ",", 
          InterpretationBox[
            
            InterpretationBox[\("6.94852"\[InvisibleSpace]"e"\[InvisibleSpace]\
"17"\),
              SequenceForm[ "6.94852", "e", "17"],
              Editable->False],
            6.9485158708621517*^+17,
            Editable->False]}], "}"}],
      (NumberForm[ #, NumberFormat -> (
        SequenceForm[ #, "e", #3]&)]&)]], "Output",
  CellLabel->"Out[14]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["FortranForm", "MR"],
  " to print individual numbers in Fortran format. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.20"}],

Cell[CellGroupData[{

Cell["FortranForm[7.8^20]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.7"],

Cell["6.948515870862152e17", "Output",
  CellLabel->"Out[15]//FortranForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PaddedForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with all numbers having room for ",
              StyleBox["tot", "TI"],
              " digits, padding with leading spaces if necessary "
            }]]},
          {Cell[TextData[{
              StyleBox["PaddedForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["tot", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["frac", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with all numbers having room for ",
              StyleBox["tot", "TI"],
              " digits, with exactly ",
              StyleBox["frac", "TI"],
              " digits to the right of the decimal point "
            }]]},
          {Cell[TextData[{
              StyleBox["NumberForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["tot", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["frac", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with all numbers having at most ",
              StyleBox["tot", "TI"],
              " digits, exactly ",
              StyleBox["frac", "TI"],
              " of them to the right of the decimal point "
            }]]},
          {Cell[TextData[{
              StyleBox["ColumnForm[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " left aligned in a column "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.7"],

Cell["Controlling the alignment of numbers in output. ", "Caption",
  CellTags->"S2.9.7"],

Cell["\<\
Whenever you print a collection of numbers in a column or some \
other definite arrangement, you typically need to be able to align the \
numbers in a definite way. Usually you want all the numbers to be set up so \
that the digit corresponding to a particular power of 10 always appears at \
the same position within the region used to print a number. \
\>", "Text",
  CellTags->{"S2.9.7", "7.21"}],

Cell["\<\
You can change the positions of digits in the printed form of a \
number by \[OpenCurlyDoubleQuote]padding\[CloseCurlyDoubleQuote] it in \
various ways. You can pad on the right, typically adding zeros somewhere \
after the decimal. Or you can pad on the left, typically inserting spaces in \
place of leading zeros. \
\>", "Text",
  CellTags->{"S2.9.7", "7.22"}],

Cell["\<\
This pads with spaces to make room for up to 7 digits in each \
integer. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.23"}],

Cell[CellGroupData[{

Cell["PaddedForm[{456, 12345, 12}, 7]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"     456\"\>",
            456,
            Editable->False], ",", 
          InterpretationBox["\<\"   12345\"\>",
            12345,
            Editable->False], ",", 
          InterpretationBox["\<\"      12\"\>",
            12,
            Editable->False]}], "}"}],
      (PaddedForm[ #, 7]&)]], "Output",
  CellLabel->"Out[16]//PaddedForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["This creates a column of integers. ", "MathCaption",
  CellTags->{"S2.9.7", "7.24"}],

Cell[CellGroupData[{

Cell["PaddedForm[ColumnForm[{456, 12345, 12}], 7]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {"\<\"     456\"\>"},
            {"\<\"   12345\"\>"},
            {"\<\"      12\"\>"}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {456, 12345, 12}],
        Editable->False],
      (PaddedForm[ #, 7]&)]], "Output",
  CellLabel->"Out[17]//PaddedForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
This prints each number with room for a total of 7 digits, and with \
4 digits to the right of the decimal point. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.25"}],

Cell[CellGroupData[{

Cell["PaddedForm[{-6.7, 6.888, 6.99999}, {7, 4}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"  -6.7000\"\>",
            -6.7000000000000002,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"   6.8880\"\>",
            6.8879999999999999,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"   7.0000\"\>",
            6.9999900000000004,
            AutoDelete->True]}], "}"}],
      (PaddedForm[ #, {7, 4}]&)]], "Output",
  CellLabel->"Out[18]//PaddedForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["NumberForm", "MR"],
  ", the 7 specifies the maximum precision, but does not make ",
  StyleBox["Mathematica", "TI"],
  " pad with spaces. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.26"}],

Cell[CellGroupData[{

Cell["NumberForm[{-6.7, 6.888, 6.99999}, {7, 4}]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"-6.7\"\>",
            -6.7000000000000002,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"6.888\"\>",
            6.8879999999999999,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"7.\"\>",
            6.9999900000000004,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, {7, 4}]&)]], "Output",
  CellLabel->"Out[19]//NumberForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "If you set the option ",
  StyleBox["SignPadding->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will insert leading spaces ",
  StyleBox["after", "TI"],
  " the sign. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.27"}],

Cell[CellGroupData[{

Cell["\<\
PaddedForm[{-6.7, 6.888, 6.99999}, {7, 4}, SignPadding->True]\
\>", \
"Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"-  6.7000\"\>",
            -6.7000000000000002,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"   6.8880\"\>",
            6.8879999999999999,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"   7.0000\"\>",
            6.9999900000000004,
            AutoDelete->True]}], "}"}],
      (PaddedForm[ #, {7, 4}, SignPadding -> True]&)]], "Output",
  CellLabel->"Out[20]//PaddedForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
Only the mantissa portion is aligned when scientific notation is \
used. \
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.28"}],

Cell[CellGroupData[{

Cell["\<\
PaddedForm[ ColumnForm[{6.7 10^8, 48.7, -2.3 10^-16}], {4, \
2}]\
\>", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {\("  6.70"\[Times]10\^"8"\)},
            {"\<\" 48.70\"\>"},
            {\(" -2.30"\[Times]10\^"-16"\)}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {670000000, 
          48.700000000000003, -2.2999999999999999*^-16}],
        Editable->False],
      (PaddedForm[ #, {4, 2}]&)]], "Output",
  CellLabel->"Out[21]//PaddedForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "With the default setting for the option ",
  StyleBox["NumberPadding", "MR"],
  ", both ",
  StyleBox["NumberForm", "MR"],
  " and ",
  StyleBox["PaddedForm", "MR"],
  " insert trailing zeros when they pad a number on the right. You can use \
spaces for padding on both the left and the right by setting ",
  StyleBox["NumberPadding", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{\"", "MR"],
  " ",
  StyleBox["\",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  " ",
  StyleBox["\"}", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.7", "7.29"}],

Cell["This uses spaces instead of zeros for padding on the right. ", \
"MathCaption",
  CellTags->{"S2.9.7", "7.30"}],

Cell[CellGroupData[{

Cell["\<\
PaddedForm[{-6.7, 6.888, 6.99999}, {7, 4}, NumberPadding -> {\" \", \
\" \"}]\
\>", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"  -6.7   \"\>",
            -6.7000000000000002,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"   6.888 \"\>",
            6.8879999999999999,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"   7.    \"\>",
            6.9999900000000004,
            AutoDelete->True]}], "}"}],
      (PaddedForm[ #, {7, 4}, NumberPadding -> {" ", " "}]&)]], "Output",
  CellLabel->"Out[22]//PaddedForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BaseForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print with all numbers given in base ",
              StyleBox["b", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.7"],

Cell["Printing numbers in other bases. ", "Caption",
  CellTags->"S2.9.7"],

Cell["This prints a number in base 2. ", "MathCaption",
  CellTags->{"S2.9.7", "7.31"}],

Cell[CellGroupData[{

Cell["BaseForm[2342424, 2]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1000111011111000011000"\_"2"\),
        2342424,
        Editable->False],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[23]//BaseForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell["\<\
In bases higher than 10, letters are used for the extra digits. \
\
\>", "MathCaption",
  CellTags->{"S2.9.7", "7.32"}],

Cell[CellGroupData[{

Cell["BaseForm[242345341, 16]", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("e71e57d"\_"16"\),
        242345341,
        Editable->False],
      (BaseForm[ #, 16]&)]], "Output",
  CellLabel->"Out[24]//BaseForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  StyleBox["BaseForm", "MR"],
  " also works with approximate real numbers. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.33"}],

Cell[CellGroupData[{

Cell["BaseForm[2.3, 2]", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("10.010011001100110011"\_2\),
        2.2999999999999998,
        AutoDelete->True],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[25]//BaseForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "You can even use ",
  StyleBox["BaseForm", "MR"],
  " for numbers printed in scientific notation. "
}], "MathCaption",
  CellTags->{"S2.9.7", "7.34"}],

Cell[CellGroupData[{

Cell["BaseForm[2.3 10^8, 2]", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.9.7"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1.1011011010110000101"\_2\[Times]2\^"27"\),
        229999999.99999997,
        AutoDelete->True],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[26]//BaseForm= ",
  CellTags->"S2.9.7"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["3.1.3",
    ButtonData:>{"3.1.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " discusses how to enter numbers in arbitrary bases, and also how to get \
lists of the digits in a number. "
}], "Text",
  CellTags->{"S2.9.7", "7.35"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.8 Tables and Matrices", "Subsection",
  CellTags->{"S2.9.8", "8.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["TableForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["print in tabular form "]},
          {Cell[TextData[{
              StyleBox["MatrixForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["print in matrix form "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.8"],

Cell["Formatting lists as tables and matrices. ", "Caption",
  CellTags->"S2.9.8"],

Cell["Here is a list. ", "MathCaption",
  CellTags->{"S2.9.8", "8.2"}],

Cell[CellGroupData[{

Cell["Table[(i + 45)^j, {i, 3}, {j, 3}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    \({{46, 2116, 97336}, {47, 2209, 103823}, {48, 2304, 110592}}\)], "Output",\

  CellLabel->"Out[1]= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TableForm", "MR"],
  " displays the list in a tabular format. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.3"}],

Cell[CellGroupData[{

Cell["TableForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[GridBox[{
          {"46", "2116", "97336"},
          {"47", "2209", "103823"},
          {"48", "2304", "110592"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " displays the list as a matrix. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.4"}],

Cell[CellGroupData[{

Cell["MatrixForm[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"46", "2116", "97336"},
            {"47", "2209", "103823"},
            {"48", "2304", "110592"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[3]//MatrixForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell["\<\
This displays an array of algebraic expressions as a matrix. \
\>", \
"MathCaption",
  CellTags->{"S2.9.8", "8.5"}],

Cell[CellGroupData[{

Cell["MatrixForm[ Table[x^i - y^j, {i, 3}, {j, 3}] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(x - y\), \(x - y\^2\), \(x - y\^3\)},
            {\(x\^2 - y\), \(x\^2 - y\^2\), \(x\^2 - y\^3\)},
            {\(x\^3 - y\), \(x\^3 - y\^2\), \(x\^3 - y\^3\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[4]//MatrixForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PaddedForm[TableForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["tot", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print a table with all numbers padded to have room for ",
              StyleBox["tot", "TI"],
              " digits "
            }]]},
          {Cell[TextData[{
              StyleBox["PaddedForm[TableForm[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["tot", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["frac", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "put ",
              StyleBox["frac", "TI"],
              
              " digits to the right of the decimal point in all approximate \
real numbers "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.8"],

Cell["Printing tables of numbers. ", "Caption",
  CellTags->"S2.9.8"],

Cell["Here is a list of numbers. ", "MathCaption",
  CellTags->{"S2.9.8", "8.6"}],

Cell[CellGroupData[{

Cell["fac = {10!, 15!, 20!}", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    \({3628800, 1307674368000, 2432902008176640000}\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["TableForm", "MR"],
  " displays the list in a column. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.7"}],

Cell[CellGroupData[{

Cell["TableForm[fac]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"3628800"},
          {"1307674368000"},
          {"2432902008176640000"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {3628800, 1307674368000, 2432902008176640000}]]], "Output",
  CellLabel->"Out[6]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell["\<\
This aligns the numbers by padding each one to leave room for up to \
20 digits. \
\>", "MathCaption",
  CellTags->{"S2.9.8", "8.8"}],

Cell[CellGroupData[{

Cell["PaddedForm[TableForm[fac], 20]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {
              InterpretationBox["\<\"              3628800\"\>",
                3628800,
                Editable->False]},
            {
              InterpretationBox["\<\"        1307674368000\"\>",
                1307674368000,
                Editable->False]},
            {
              InterpretationBox["\<\"  2432902008176640000\"\>",
                2432902008176640000,
                Editable->False]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {3628800, 1307674368000, 2432902008176640000}]],
      (PaddedForm[ #, 20]&)]], "Output",
  CellLabel->"Out[7]//PaddedForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "In this particular case, you could also align the numbers using the ",
  StyleBox["TableAlignments", "MR"],
  " option. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.9"}],

Cell[CellGroupData[{

Cell["TableForm[fac, TableAlignments -> {Right}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"3628800"},
          {"1307674368000"},
          {"2432902008176640000"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Right}],
      TableForm[ {3628800, 1307674368000, 2432902008176640000}, 
        TableAlignments -> {Right}]]], "Output",
  CellLabel->"Out[8]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell["\<\
This lines up the numbers, padding each one to have room for 8 \
digits, with 5 digits to the right of the decimal point. \
\>", "MathCaption",\

  CellTags->{"S2.9.8", "8.10"}],

Cell[CellGroupData[{

Cell["PaddedForm[TableForm[{6.7, 6.888, 6.99999}], {8, 5}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {
              InterpretationBox["\<\"   6.70000\"\>",
                6.7000000000000002,
                AutoDelete->True]},
            {
              InterpretationBox["\<\"   6.88800\"\>",
                6.8879999999999999,
                AutoDelete->True]},
            {
              InterpretationBox["\<\"   6.99999\"\>",
                6.9999900000000004,
                AutoDelete->True]}
            },
          RowSpacings->1,
          ColumnSpacings->3,
          RowAlignments->Baseline,
          ColumnAlignments->{Left}],
        TableForm[ {6.7000000000000002, 6.8879999999999999, 
          6.9999900000000004}]],
      (PaddedForm[ #, {8, 5}]&)]], "Output",
  CellLabel->"Out[9]//PaddedForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["TableForm", "MR"],
  " and ",
  StyleBox["MatrixForm", "MR"],
  " to format lists that are nested to any depth, corresponding to arrays \
with any number of dimensions. "
}], "Text",
  CellTags->{"S2.9.8", "8.11"}],

Cell[TextData[{
  "Here is the format for a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\)], "InlineFormula"],
  " array of elements ",
  StyleBox["a[", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["j", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.12"}],

Cell[CellGroupData[{

Cell["TableForm[ Array[a, {2, 2}] ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(a[1, 1]\), \(a[1, 2]\)},
          {\(a[2, 1]\), \(a[2, 2]\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[10]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\[Cross]2\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.13"}],

Cell[CellGroupData[{

Cell["TableForm[ { Array[a, {2, 2}], Array[b, {2, 2}] } ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(a[1, 1]\)},
                {\(a[1, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(a[2, 1]\)},
                {\(a[2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {\(b[1, 1]\)},
                {\(b[1, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(b[2, 1]\)},
                {\(b[2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{
        a[ 1, 1], 
        a[ 1, 2]}, {
        a[ 2, 1], 
        a[ 2, 2]}}, {{
        b[ 1, 1], 
        b[ 1, 2]}, {
        b[ 2, 1], 
        b[ 2, 2]}}}]]], "Output",
  CellLabel->"Out[11]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "And here is a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\[Cross]2\[Cross]2\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.14"}],

Cell[CellGroupData[{

Cell["\<\
TableForm[ { {Array[a, {2, 2}], Array[b, {2, 2}]}, {Array[c, {2, \
2}], Array[d, {2, 2}]} } ]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(a[1, 1]\), \(a[1, 2]\)},
                {\(a[2, 1]\), \(a[2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(b[1, 1]\), \(b[1, 2]\)},
                {\(b[2, 1]\), \(b[2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {\(c[1, 1]\), \(c[1, 2]\)},
                {\(c[2, 1]\), \(c[2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(d[1, 1]\), \(d[1, 2]\)},
                {\(d[2, 1]\), \(d[2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{{
        a[ 1, 1], 
        a[ 1, 2]}, {
        a[ 2, 1], 
        a[ 2, 2]}}, {{
        b[ 1, 1], 
        b[ 1, 2]}, {
        b[ 2, 1], 
        b[ 2, 2]}}}, {{{
        c[ 1, 1], 
        c[ 1, 2]}, {
        c[ 2, 1], 
        c[ 2, 2]}}, {{
        d[ 1, 1], 
        d[ 1, 2]}, {
        d[ 2, 1], 
        d[ 2, 2]}}}}]]], "Output",
  CellLabel->"Out[12]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "In general, when you print an ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          "TI"], TraditionalForm]], "InlineFormula"],
  "\[Hyphen]dimensional table, successive dimensions are alternately given as \
columns and rows. By setting the option ",
  StyleBox["TableDirections", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  ", where the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["dir",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " are ",
  StyleBox["Column", "MR"],
  " or ",
  StyleBox["Row", "MR"],
  ", you can specify explicitly which way each dimension should be given. By \
default, the option is effectively set to ",
  StyleBox["{Column,", "MR"],
  " ",
  StyleBox["Row,", "MR"],
  " ",
  StyleBox["Column,", "MR"],
  " ",
  StyleBox["Row,", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.8", "8.15"}],

Cell[TextData[{
  "The option ",
  StyleBox["TableDirections", "MR"],
  " allows you to specify explicitly how each dimension in a multidimensional \
table should be given. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.16"}],

Cell[CellGroupData[{

Cell["\<\
TableForm[ { Array[a, {2, 2}], Array[b, {2, 2}] }, TableDirections \
-> {Row, Row, Column} ]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {GridBox[{
                      {\(a[1, 1]\)},
                      {\(a[1, 2]\)}
                      },
                    RowSpacings->0.25,
                    ColumnSpacings->1,
                    RowAlignments->Baseline,
                    ColumnAlignments->{Left}], GridBox[{
                      {\(a[2, 1]\)},
                      {\(a[2, 2]\)}
                      },
                    RowSpacings->0.25,
                    ColumnSpacings->1,
                    RowAlignments->Baseline,
                    ColumnAlignments->{Left}]}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {GridBox[{
                      {\(b[1, 1]\)},
                      {\(b[1, 2]\)}
                      },
                    RowSpacings->0.25,
                    ColumnSpacings->1,
                    RowAlignments->Baseline,
                    ColumnAlignments->{Left}], GridBox[{
                      {\(b[2, 1]\)},
                      {\(b[2, 2]\)}
                      },
                    RowSpacings->0.25,
                    ColumnSpacings->1,
                    RowAlignments->Baseline,
                    ColumnAlignments->{Left}]}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{
        a[ 1, 1], 
        a[ 1, 2]}, {
        a[ 2, 1], 
        a[ 2, 2]}}, {{
        b[ 1, 1], 
        b[ 1, 2]}, {
        b[ 2, 1], 
        b[ 2, 2]}}}, TableDirections -> {Row, Row, Column}]]], "Output",
  CellLabel->"Out[13]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "Whenever you make a table from a nested list such as ",
  StyleBox["{", "MR"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], "1"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  StyleBox[",", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["}", "MR"],
  ", there is a question of whether it should be the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            "TI"], 
          StyleBox["i",
            "TI"]], TraditionalForm]], "InlineFormula"],
  " or their elements which appear as the basic entries in the table. The \
default behavior is slightly different for ",
  StyleBox["MatrixForm", "MR"],
  " and ",
  StyleBox["TableForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.8", "8.17"}],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " handles only arrays that are \[OpenCurlyDoubleQuote]rectangular\
\[CloseCurlyDoubleQuote]. Thus, for example, to consider an array as two\
\[Hyphen]dimensional, all the rows must have the same length. If they do not, \
",
  StyleBox["MatrixForm", "MR"],
  " treats the array as one\[Hyphen]dimensional, with elements that are \
lists. "
}], "Text",
  CellTags->{"S2.9.8", "8.18"}],

Cell[TextData[{
  StyleBox["MatrixForm", "MR"],
  " treats this as a one\[Hyphen]dimensional array, since the rows are of \
differing lengths. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.19"}],

Cell[CellGroupData[{

Cell["MatrixForm[{{a, a, a}, {b, b}}]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", 
        TagBox[GridBox[{
              {\({a, a, a}\)},
              {\({b, b}\)}
              },
            RowSpacings->1,
            ColumnAlignments->{Left}],
          Column], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[14]//MatrixForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "While ",
  StyleBox["MatrixForm", "MR"],
  " can handle only \[OpenCurlyDoubleQuote]rectangular arrays\
\[CloseCurlyDoubleQuote], ",
  StyleBox["TableForm", "MR"],
  " can handle arbitrary \
\[OpenCurlyDoubleQuote]ragged\[CloseCurlyDoubleQuote] arrays. It leaves \
blanks wherever there are no elements supplied. "
}], "Text",
  CellTags->{"S2.9.8", "8.20"}],

Cell[TextData[{
  StyleBox["TableForm", "MR"],
  " can handle \[OpenCurlyDoubleQuote]ragged\[CloseCurlyDoubleQuote] arrays. \
"
}], "MathCaption",
  CellTags->{"S2.9.8", "8.21"}],

Cell[CellGroupData[{

Cell["TableForm[{{a, a, a}, {b, b}}]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"a", "a", "a"},
          {"b", "b", "\<\"\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{a, a, a}, {b, b}}]]], "Output",
  CellLabel->"Out[15]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell["\<\
You can include objects that behave as \
\[OpenCurlyDoubleQuote]subtables\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",\

  CellTags->{"S2.9.8", "8.22"}],

Cell[CellGroupData[{

Cell["TableForm[{{a, {{p, q}, {r, s}}, a, a}, {{x, y}, b, b}}]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"a", GridBox[{
                {"p", "q"},
                {"r", "s"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], "a", "a"},
          {GridBox[{
                {"x"},
                {"y"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], "b", "b", "\<\"\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{a, {{p, q}, {r, s}}, a, a}, {{x, y}, b, b}}]]], "Output",
  CellLabel->"Out[16]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "You can control the number of levels in a nested list to which both ",
  StyleBox["TableForm", "MR"],
  " and ",
  StyleBox["MatrixForm", "MR"],
  " go by setting the option ",
  StyleBox["TableDepth", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.8", "8.23"}],

Cell[TextData[{
  "This tells ",
  StyleBox["TableForm", "MR"],
  " only to go down to depth 2. As a result ",
  StyleBox["{x,", "MR"],
  " ",
  StyleBox["y}", "MR"],
  " is treated as a single table entry. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.24"}],

Cell[CellGroupData[{

Cell["TableForm[{{a, {x, y}}, {c, d}}, TableDepth -> 2]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", \({x, y}\)},
          {"c", "d"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableDepth -> 2]]]], "Output",
  CellLabel->"Out[17]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["TableDepth", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Infinity", "MR"],
              " "
            }]], Cell["maximum number of levels to include in the table "]},
          {Cell[TextData[{
              StyleBox["TableDirections", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{Column,", "MR"],
              " ",
              StyleBox["Row,", "MR"],
              " ",
              StyleBox["Column,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["whether to arrange dimensions as rows or columns "]},
          {Cell[TextData[{
              StyleBox["TableAlignments", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{Left,", "MR"],
              " ",
              StyleBox["Bottom,", "MR"],
              " ",
              StyleBox["Left,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["how to align the entries in each dimension "]},
          {Cell[TextData[{
              StyleBox["TableSpacing", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["3,", "MR"],
              " ",
              StyleBox["0,", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["0,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[
            "how many spaces to put between entries in each dimension "]},
          {Cell[TextData[{
              StyleBox["TableHeadings", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{None,", "MR"],
              " ",
              StyleBox["None,", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["how to label the entries in each dimension "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.8"],

Cell[TextData[{
  "Options for ",
  StyleBox["TableForm", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.9.8"],

Cell[TextData[{
  "With the option ",
  StyleBox["TableAlignments", "MR"],
  ", you can specify how each entry in the table should be aligned with its \
row or column. For columns, you can specify ",
  StyleBox["Left", "MR"],
  ", ",
  StyleBox["Center", "MR"],
  " or ",
  StyleBox["Right", "MR"],
  ". For rows, you can specify ",
  StyleBox["Bottom", "MR"],
  ", ",
  StyleBox["Center", "MR"],
  " or ",
  StyleBox["Top", "MR"],
  ". If you set ",
  StyleBox["TableAlignments", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Center", "MR"],
  ", all entries will be centered both horizontally and vertically. ",
  StyleBox["TableAlignments", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " uses the default choice of alignments. "
}], "Text",
  CellTags->{"S2.9.8", "8.25"}],

Cell["Entries in columns are by default aligned on the left. ", "MathCaption",
  CellTags->{"S2.9.8", "8.26"}],

Cell[CellGroupData[{

Cell["TableForm[{a, bbbb, cccccccc}]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"a"},
          {"bbbb"},
          {"cccccccc"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {a, bbbb, cccccccc}]]], "Output",
  CellLabel->"Out[18]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell["This centers all entries. ", "MathCaption",
  CellTags->{"S2.9.8", "8.27"}],

Cell[CellGroupData[{

Cell["TableForm[{a, bbbb, cccccccc}, TableAlignments -> Center]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"a"},
          {"bbbb"},
          {"cccccccc"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Center}],
      TableForm[ {a, bbbb, cccccccc}, TableAlignments -> Center]]], "Output",
  CellLabel->"Out[19]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "You can use the option ",
  StyleBox["TableSpacing", "MR"],
  " to specify how much horizontal space there should be between successive \
columns, or how much vertical space there should be between successive rows. \
A setting of 0 specifies that successive objects should abut. "
}], "Text",
  CellTags->{"S2.9.8", "8.28"}],

Cell["\<\
This leaves 6 spaces between the entries in each row, and no space \
between successive rows. \
\>", "MathCaption",
  CellTags->{"S2.9.8", "8.29"}],

Cell[CellGroupData[{

Cell["TableForm[{{a, b}, {ccc, d}}, TableSpacing -> {0, 6}]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b"},
          {"ccc", "d"}
          },
        RowSpacings->0,
        ColumnSpacings->6,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableSpacing -> {0, 6}]]]], "Output",
  CellLabel->"Out[20]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["no labels in any dimension "]},
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["successive integer labels in each dimension "]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lab",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lab",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["explicit labels "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.8"],

Cell[TextData[{
  "Settings for the option ",
  StyleBox["TableHeadings", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.9.8"],

Cell[TextData[{
  "This puts integer labels in a ",
  Cell[BoxData[
      \(TraditionalForm\`2\[Cross]2\[Cross]2\)], "InlineFormula"],
  " array. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.30"}],

Cell[CellGroupData[{

Cell["TableForm[Array[a, {2, 2, 2}], TableHeadings -> Automatic]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"\"\>", "1", "2"},
          {"1", GridBox[{
                {"1", \(a[1, 1, 1]\)},
                {"2", \(a[1, 1, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(a[1, 2, 1]\)},
                {\(a[1, 2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {"2", GridBox[{
                {"1", \(a[2, 1, 1]\)},
                {"2", \(a[2, 1, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {\(a[2, 2, 1]\)},
                {\(a[2, 2, 2]\)}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Center}],
      TableForm[ {{{
        a[ 1, 1, 1], 
        a[ 1, 1, 2]}, {
        a[ 1, 2, 1], 
        a[ 1, 2, 2]}}, {{
        a[ 2, 1, 1], 
        a[ 2, 1, 2]}, {
        a[ 2, 2, 1], 
        a[ 2, 2, 2]}}}, TableHeadings -> Automatic]]], "Output",
  CellLabel->"Out[21]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell["\<\
This gives a table in which the rows are labeled by integers, and \
the columns by a list of strings. \
\>", "MathCaption",
  CellTags->{"S2.9.8", "8.31"}],

Cell[CellGroupData[{

Cell["\<\
TableForm[{{a, b, c}, {ap, bp, cp}}, TableHeadings -> {Automatic, {\
\"first\", \"middle\", \"last\"}}]\
\>", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"\"\>", "\<\"first\"\>", "\<\"middle\"\>", "\<\"last\"\>"},
          {"1", "a", "b", "c"},
          {"2", "ap", "bp", "cp"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ 
        BoxForm`e$, TableHeadings -> {Automatic, {"first", "middle", 
          "last"}}]]]], "Output",
  CellLabel->"Out[22]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]],

Cell[TextData[{
  "This labels the rows but not the columns. ",
  StyleBox["TableForm", "MR"],
  " automatically inserts a blank row to go with the third label. "
}], "MathCaption",
  CellTags->{"S2.9.8", "8.32"}],

Cell[CellGroupData[{

Cell["\<\
TableForm[{{2, 3, 4}, {5, 6, 1}}, TableHeadings -> {{\"row a\", \
\"row b\", \"row c\"}, None}]\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.9.8"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"row a\"\>", "2", "3", "4"},
          {"\<\"row b\"\>", "5", "6", "1"},
          {"\<\"row c\"\>", "", "", ""}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ 
        BoxForm`e$, TableHeadings -> {{"row a", "row b", "row c"}, 
          None}]]]], "Output",
  CellLabel->"Out[23]//TableForm= ",
  CellTags->"S2.9.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.9 Styles and Fonts in Output", "Subsection",
  CellTags->{"S2.9.9", "9.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StyleForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["print with the specified style options "]},
          {Cell[TextData[{
              StyleBox["StyleForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["print with the specified cell style "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.9"],

Cell["Specifying output styles. ", "Caption",
  CellTags->"S2.9.9"],

Cell[TextData[{
  "The second ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            "TI"], "2"], TraditionalForm]], "InlineFormula"],
  " is here shown in boldface. "
}], "MathCaption",
  CellTags->{"S2.9.9", "9.2"}],

Cell[CellGroupData[{

Cell["{x^2, StyleForm[x^2, FontWeight->\"Bold\"]}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.9"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(x\^2\), ",", 
        TagBox[
          StyleBox[\(x\^2\),
            FontWeight->"Bold"],
          (StyleForm[ #, FontWeight -> "Bold"]&)]}], "}"}]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.9"]
}, Open  ]],

Cell[TextData[{
  "This shows the word ",
  StyleBox["text", "MR"],
  " in font sizes from 10 to 20 points. "
}], "MathCaption",
  CellTags->{"S2.9.9", "9.3"}],

Cell[CellGroupData[{

Cell["Table[StyleForm[\"text\", FontSize->s], {s, 10, 20}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.9"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->10],
          (StyleForm[ #, FontSize -> 10]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->11],
          (StyleForm[ #, FontSize -> 11]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->12],
          (StyleForm[ #, FontSize -> 12]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->13],
          (StyleForm[ #, FontSize -> 13]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->14],
          (StyleForm[ #, FontSize -> 14]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->15],
          (StyleForm[ #, FontSize -> 15]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->16],
          (StyleForm[ #, FontSize -> 16]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->17],
          (StyleForm[ #, FontSize -> 17]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->18],
          (StyleForm[ #, FontSize -> 18]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->19],
          (StyleForm[ #, FontSize -> 19]&)], ",", 
        TagBox[
          StyleBox["\<\"text\"\>",
            FontSize->20],
          (StyleForm[ #, FontSize -> 20]&)]}], "}"}]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.9"]
}, Open  ]],

Cell["This shows the text in the Tekton font. ", "MathCaption",
  CellTags->{"S2.9.9", "9.4"}],

Cell[CellGroupData[{

Cell["StyleForm[\"some text\", FontFamily->\"Tekton\"]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.9"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008E000041P00`40o`000?l0003o
oooooooooolGoooo003ooooooooooaOoool00?oooooooooo5oooo`00oooooooooolG
oooo003ooooooooooaOoool000?oool300000oooo`@00003oooo0@00007oool00ooo
o`000?ooo`000oooo`000?ooo`01oooo0@0000400001oooo1Oooo`800004oooo0P00
00;oool100000Oooo`;oool00`000?ooo`00000100000OoooooooooRoooo0002oooo
0@00007oool2oooo00@0003oool0003oool3oooo0@00007oool00oooo`000?ooo`00
0oooo`000?ooo`001Oooo`000?ooo`000?ooo`000oooo`000?ooo`04oooo00@0003o
ool0003oool00oooo`000?ooo`000oooo`000?ooo`001Oooo`000?ooo`000?ooo`00
1Oooo`000?ooo`000?ooo`3ooooohOooo`001_ooo`040000oooo0000oooo0oooo`40
0001oooo00?oool0003oool000?oool0003oool000Coool0003oool0000100000Ooo
o`03oooo0000oooo00?oool100000Oooo`7oool100000`0000;oool100000Oooo`03
oooo0000oooo00;oool100000Oooo`03oooo0000oooo0?oooooPoooo0003oooo0`00
00;oool100000Oooo`?oool100000Oooo`03oooo0000oooo0003oooo0000oooo0007
oooo0000oooo0000oooo0000oooo00Goool100000Oooo`?oool010000?ooo`000?oo
o`?oool100000Oooo`;oool100000OoooooooooSoooo0002oooo0@00007oool5oooo
0@00007oool2oooo0@00007oool1oooo0@0000030000oooo000000040000oooo0000
oooo00Goool0003oool0003oool00oooo`<00004oooo00@0003oool0003oool01_oo
o`000?ooo`000?ooo`000080003ooooohoooo`000oooo`<00004oooo0`0000?oool0
0`000?ooo`0000000`000?ooo`00000100000Oooo`;oool200001Oooo`040000oooo
0000oooo0oooo`8000000oooo`000?ooo`02oooo00H0003oool0003oool0003ooooo
oooohOooo`008Oooo`400001oooo3_ooo`400001ooooooooon?oool0027oool10000
0Oooo`koool100000OoooooooooSoooo003ooooooooooaOoool00?oooooooooo5ooo
o`00oooooooooolGoooo00000@00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{533, 16},
  ImageMargins->{{0, 0}, {0, 0}},
  CellTags->"S2.9.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["typical setting(s)", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["FontSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["12", "MR"],
              " "
            }]], Cell["size of characters in printer's points "]},
          {Cell[TextData[{
              StyleBox["FontWeight", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"Plain\"", "MR"],
              " or ",
              StyleBox["\"Bold\"", "MR"],
              " "
            }]], Cell["weight of characters "]},
          {Cell[TextData[{
              StyleBox["FontSlant", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"Plain\"", "MR"],
              " or ",
              StyleBox["\"Italic\"", "MR"],
              " "
            }]], Cell["slant of characters "]},
          {Cell[TextData[{
              StyleBox["FontFamily", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"Courier\"", "MR"],
              ", ",
              StyleBox["\"Times\"", "MR"],
              ", ",
              StyleBox["\"Helvetica\"", "MR"],
              " "
            }]], Cell["font family "]},
          {Cell[TextData[{
              StyleBox["FontColor", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["GrayLevel[0]", "MR"],
              " "
            }]], Cell["color of characters "]},
          {Cell[TextData[{
              StyleBox["Background", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["GrayLevel[1]", "MR"],
              " "
            }]], Cell["background color for characters "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.9"],

Cell[TextData[{
  "A few options that can be used in ",
  StyleBox["StyleForm", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.9.9"],

Cell[TextData[{
  "If you use the notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then each piece of output that is generated will by default be in the \
style of the cell in which the output appears. By using ",
  StyleBox["StyleForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  StyleBox["style", "TI"],
  StyleBox["\"]", "MR"],
  ", however, you can tell ",
  StyleBox["Mathematica", "TI"],
  " to output a particular expression in a different style. "
}], "Text",
  CellTags->{"S2.9.9", "9.5"}],

Cell["\<\
Here is an expression output in the style normally used for section \
headings. \
\>", "MathCaption",
  CellTags->{"S2.9.9", "9.6"}],

Cell[CellGroupData[{

Cell["StyleForm[x^2 + y^2, \"Section\"]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.9"],

Cell[BoxData[
    TagBox[
      StyleBox[\(x\^2 + y\^2\),
        "Section"],
      (StyleForm[ #, "Section"]&)]], "Output",
  CellLabel->"Out[4]//StyleForm= ",
  CellTags->"S2.9.9"]
}, Open  ]],

Cell[TextData[{
  "Section\[NonBreakingSpace]",
  ButtonBox["2.11.1",
    ButtonData:>{"2.11.1", "1.5"},
    ButtonStyle->"MainBookLink"],
  " describes in more detail how cell styles work. By using ",
  StyleBox["StyleForm[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["\"", "MR"],
  StyleBox["style", "TI"],
  StyleBox["\",", "MR"],
  " ",
  StyleBox["options", "TI"],
  StyleBox["]", "MR"],
  " you can generate output that is in a particular style, but with certain \
options modified. "
}], "Text",
  CellTags->{"S2.9.9", "9.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.10 Representing Textual Forms by Boxes", "Subsection",
  CellTags->{"S2.9.10", "10.1"}],

Cell[TextData[{
  "All textual forms in ",
  StyleBox["Mathematica", "TI"],
  " are ultimately represented in terms of nested collections of ",
  StyleBox["boxes", "TI"],
  ". Typically the elements of these boxes correspond to objects that are to \
be placed at definite relative positions in two dimensions.   "
}], "Text",
  CellTags->{"S2.9.10", "10.2"}],

Cell[TextData[{
  "Here are the boxes corresponding to the expression ",
  StyleBox["a", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["b", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.3"}],

Cell[CellGroupData[{

Cell["ToBoxes[a + b]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    \(RowBox[{"a", "+", "b"}]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["DisplayForm", "MR"],
  " shows how these boxes would be displayed. "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.4"}],

Cell[CellGroupData[{

Cell["DisplayForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(a + b\),
      DisplayForm]], "Output",
  CellLabel->"Out[2]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DisplayForm[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "show ",
              StyleBox["boxes", "TI"],
              " as they would be displayed "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.10"],

Cell["Showing the displayed form of boxes. ", "Caption",
  CellTags->"S2.9.10"],

Cell["This displays three strings in a row. ", "MathCaption",
  CellTags->{"S2.9.10", "10.5"}],

Cell[CellGroupData[{

Cell["RowBox[{\"a\", \"+\", \"b\"}] // DisplayForm", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(a + b\),
      DisplayForm]], "Output",
  CellLabel->"Out[3]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["This displays one string as a subscript of another. ", "MathCaption",
  CellTags->{"S2.9.10", "10.6"}],

Cell[CellGroupData[{

Cell["SubscriptBox[\"a\", \"i\"] // DisplayForm", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(a\_i\),
      DisplayForm]], "Output",
  CellLabel->"Out[4]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["This puts two subscript boxes in a row. ", "MathCaption",
  CellTags->{"S2.9.10", "10.7"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{SubscriptBox[\"a\", \"1\"], SubscriptBox[\"b\", \"2\"]}] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(\(a\_1\) b\_2\),
      DisplayForm]], "Output",
  CellLabel->"Out[5]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["literal text "]},
          {Cell[TextData[{
              StyleBox["RowBox[{", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a row of boxes or strings ",
              StyleBox["a", "TI"],
              " ",
              StyleBox["b", "TI"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GridBox[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["b",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "a grid of boxes ",
              Cell[BoxData[GridBox[{
                      {
                        StyleBox[\(a\_1\),
                          "TI"], 
                        StyleBox[\(b\_1\),
                          "TI"], "\[Ellipsis]"},
                      {
                        StyleBox[\(a\_2\),
                          "TI"], 
                        StyleBox[\(b\_2\),
                          "TI"], "\[Ellipsis]"},
                      {"\[VerticalEllipsis]", "\[VerticalEllipsis]", " "}
                      },
                    ColumnWidths->Automatic]], "InlineFormula"]
            }]]},
          {Cell[TextData[{
              StyleBox["SubscriptBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "subscript ",
              Cell[BoxData[
                  SubscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SuperscriptBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "superscript ",
              Cell[BoxData[
                  SuperscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SubsuperscriptBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "subscript and superscript ",
              Cell[BoxData[
                  SubsuperscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"], 
                    StyleBox["c",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["UnderscriptBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "underscript ",
              Cell[BoxData[
                  UnderscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["OverscriptBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "overscript ",
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["UnderoverscriptBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["c", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "underscript and overscript ",
              Cell[BoxData[
                  UnderoverscriptBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"], 
                    StyleBox["c",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["FractionBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "fraction ",
              Cell[BoxData[
                  FractionBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SqrtBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "square root ",
              Cell[BoxData[
                  SqrtBox[
                    StyleBox["a",
                      "TI"]]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RadicalBox[", "MR"],
              StyleBox["a", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["b", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " root ",
              Cell[BoxData[
                  RadicalBox[
                    StyleBox["a",
                      "TI"], 
                    StyleBox["b",
                      "TI"]]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.10"],

Cell["Some basic box types. ", "Caption",
  CellTags->"S2.9.10"],

Cell["This nests a fraction inside a radical. ", "MathCaption",
  CellTags->{"S2.9.10", "10.8"}],

Cell[CellGroupData[{

Cell["RadicalBox[FractionBox[x, y], n] // DisplayForm", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(\@\(x\/y\)\%n\),
      DisplayForm]], "Output",
  CellLabel->"Out[6]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["This puts a superscript on a subscripted object. ", "MathCaption",
  CellTags->{"S2.9.10", "10.9"}],

Cell[CellGroupData[{

Cell["SuperscriptBox[SubscriptBox[a, b], c] // DisplayForm", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(a\_b\^c\),
      DisplayForm]], "Output",
  CellLabel->"Out[7]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["\<\
This puts both a subscript and a superscript on the same object. \
\
\>", "MathCaption",
  CellTags->{"S2.9.10", "10.10"}],

Cell[CellGroupData[{

Cell["SubsuperscriptBox[a, b, c] // DisplayForm", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(a\_b\%c\),
      DisplayForm]], "Output",
  CellLabel->"Out[8]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FrameBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "render ",
              StyleBox["box", "TI"],
              " with a frame drawn around it "
            }]]},
          {Cell[TextData[{
              StyleBox["GridBox[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["RowLines->True]", "MR"],
              " "
            }]], Cell[TextData[{
              "put lines between rows in a ",
              StyleBox["GridBox", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GridBox[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ColumnLines->True]", "MR"],
              " "
            }]], Cell[TextData[{
              "put lines between columns in a ",
              StyleBox["GridBox", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["GridBox[", "MR"],
              StyleBox["list", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["RowLines->{True,", "MR"],
              " ",
              StyleBox["False}]", "MR"],
              " "
            }]], Cell[
            "put a line below the first row, but not subsequent ones "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.10"],

Cell["Inserting frames and grid lines. ", "Caption",
  CellTags->"S2.9.10"],

Cell["This shows a fraction with a frame drawn around it. ", "MathCaption",
  CellTags->{"S2.9.10", "10.11"}],

Cell[CellGroupData[{

Cell["FrameBox[FractionBox[\"x\", \"y\"]] // DisplayForm", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[
      FrameBox[\(x\/y\)],
      DisplayForm]], "Output",
  CellLabel->"Out[9]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["This puts lines between rows and columns of an array. ", "MathCaption",
  CellTags->{"S2.9.10", "10.12"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[Table[i+j, {i, 3}, {j, 3}], RowLines->True, \
ColumnLines->True] // DisplayForm\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[GridBox[{
          {"2", "3", "4"},
          {"3", "4", "5"},
          {"4", "5", "6"}
          },
        RowLines->True,
        ColumnLines->True],
      DisplayForm]], "Output",
  CellLabel->"Out[10]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["And this also puts a frame around the outside. ", "MathCaption",
  CellTags->{"S2.9.10", "10.13"}],

Cell[CellGroupData[{

Cell["FrameBox[%] // DisplayForm", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[
      FrameBox[GridBox[{
            {"2", "3", "4"},
            {"3", "4", "5"},
            {"4", "5", "6"}
            },
          RowLines->True,
          ColumnLines->True]],
      DisplayForm]], "Output",
  CellLabel->"Out[11]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StyleBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["options", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "render ",
              StyleBox["boxes", "TI"],
              " with the specified option settings "
            }]]},
          {Cell[TextData[{
              StyleBox["StyleBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "render ",
              StyleBox["boxes", "TI"],
              " in the specified style "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.10"],

Cell["Modifying the appearance of boxes. ", "Caption",
  CellTags->"S2.9.10"],

Cell[TextData[{
  StyleBox["StyleBox", "MR"],
  " takes the same options as ",
  StyleBox["StyleForm", "MR"],
  ". The difference is that ",
  StyleBox["StyleForm", "MR"],
  " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote] for any \
expression, while ",
  StyleBox["StyleBox", "MR"],
  " represents underlying box structure. "
}], "Text",
  CellTags->{"S2.9.10", "10.14"}],

Cell[TextData[{
  "This shows the string ",
  StyleBox["\"name\"", "MR"],
  " in italics. "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.15"}],

Cell[CellGroupData[{

Cell["StyleBox[\"name\", FontSlant->\"Italic\"] // DisplayForm", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[
      StyleBox["name",
        FontSlant->"Italic"],
      DisplayForm]], "Output",
  CellLabel->"Out[12]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[TextData[{
  "This shows ",
  StyleBox["\"name\"", "MR"],
  " in the style used for section headings in your current notebook. "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.16"}],

Cell[CellGroupData[{

Cell["StyleBox[\"name\", \"Section\"] // DisplayForm", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[
      StyleBox["name",
        "Section"],
      DisplayForm]], "Output",
  CellLabel->"Out[13]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["\<\
This uses section heading style, but with characters shown in gray. \
\
\>", "MathCaption",
  CellTags->{"S2.9.10", "10.17"}],

Cell[CellGroupData[{

Cell["\<\
StyleBox[\"name\", \"Section\", FontColor->GrayLevel[0.5]] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[
      StyleBox["name",
        "Section",
        FontColor->GrayLevel[0.500008]],
      DisplayForm]], "Output",
  CellLabel->"Out[14]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[TextData[{
  "If you use a notebook front end for ",
  StyleBox["Mathematica", "TI"],
  ", then you will be able to change the style and appearance of what you see \
on the screen directly by using menu items. Internally, however, these \
changes will still be recorded by the insertion of appropriate ",
  StyleBox["StyleBox", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S2.9.10", "10.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FormBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "interpret ",
              StyleBox["boxes", "TI"],
              " using rules associated with the specified form "
            }]]},
          {Cell[TextData[{
              StyleBox["InterpretationBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "interpret ",
              StyleBox["boxes", "TI"],
              " as representing the expression ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["TagBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use ",
              StyleBox["tag", "TI"],
              " to guide the interpretation of ",
              StyleBox["boxes", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ErrorBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "indicate an error and do not attempt further interpretation of \
",
              StyleBox["boxes", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.10"],

Cell["Controlling the interpretation of boxes. ", "Caption",
  CellTags->"S2.9.10"],

Cell[TextData[{
  "This prints as ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " with a superscript. "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.19"}],

Cell[CellGroupData[{

Cell["SuperscriptBox[\"x\", \"2\"] // DisplayForm", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[\(x\^2\),
      DisplayForm]], "Output",
  CellLabel->"Out[15]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell["It is normally interpreted as a power. ", "MathCaption",
  CellTags->{"S2.9.10", "10.20"}],

Cell[CellGroupData[{

Cell["ToExpression[%] // InputForm", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.10"],

Cell["x^2", "Output",
  CellLabel->"Out[16]//InputForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[TextData[{
  "This again prints as ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " with a superscript. "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.21"}],

Cell[CellGroupData[{

Cell["\<\
InterpretationBox[SuperscriptBox[\"x\", \"2\"], vec[x, 2]] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    TagBox[
      InterpretationBox[\(x\^2\),
        vec[ x, 2]],
      DisplayForm]], "Output",
  CellLabel->"Out[17]//DisplayForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[TextData[{
  "But now it is interpreted as ",
  StyleBox["vec[x,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ", following the specification given in the ",
  StyleBox["InterpretationBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.22"}],

Cell[CellGroupData[{

Cell["ToExpression[%] // InputForm", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.10"],

Cell["vec[x, 2]", "Output",
  CellLabel->"Out[18]//InputForm= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[TextData[{
  "If you edit the boxes given in an ",
  StyleBox["InterpretationBox", "MR"],
  ", then there is no guarantee that the interpretation specified by the \
interpretation box will still be correct. As a result, ",
  StyleBox["Mathematica", "TI"],
  " provides various options that allow you to control the selection and \
editing of ",
  StyleBox["InterpretationBox", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S2.9.10", "10.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["Editable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["whether to allow the contents to be edited "]},
          {Cell[TextData[{
              StyleBox["Selectable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to allow the contents to be selected "]},
          {Cell[TextData[{
              StyleBox["Deletable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to allow the box to be deleted "]},
          {Cell[TextData[{
              StyleBox["DeletionWarning", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to issue a warning if the box is deleted "]},
          {Cell[TextData[{
              StyleBox["BoxAutoDelete", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell[
            "whether to strip the box if its contents are modified "]},
          {Cell[TextData[{
              StyleBox["StripWrapperBoxes", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell[TextData[{
              "whether to remove ",
              StyleBox["StyleBox", "MR"],
              " etc. from within ",
              StyleBox["boxes", "TI"],
              " in ",
              StyleBox["TagBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.10"],

Cell[TextData[{
  "Options for ",
  StyleBox["InterpretationBox", "MR"],
  " and related boxes. "
}], "Caption",
  CellTags->"S2.9.10"],

Cell[TextData[{
  StyleBox["TagBox", "MR"],
  " objects are used to store information that will not be displayed but \
which can nevertheless be used by the rules that interpret boxes. Typically \
the ",
  StyleBox["tag", "TI"],
  " in ",
  StyleBox["TagBox[", "MR"],
  StyleBox["boxes", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["tag", "TI"],
  StyleBox["]", "MR"],
  " is a symbol which gives the head of the expression corresponding to ",
  StyleBox["boxes", "TI"],
  ". If you edit only the arguments of this expression then there is a good \
chance that the interpretation specified by the ",
  StyleBox["TagBox", "MR"],
  " will still be appropriate. As a result, ",
  StyleBox["Editable->True", "MR"],
  " is effectively the default setting for a ",
  StyleBox["TagBox", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.10", "10.24"}],

Cell[TextData[{
  "The rules that ",
  StyleBox["Mathematica", "TI"],
  " uses for interpreting boxes are in general set up to ignore details of \
formatting, such as those defined by ",
  StyleBox["StyleBox", "MR"],
  " objects. Thus, unless ",
  StyleBox["StripWrapperBoxes->False", "MR"],
  ", a red ",
  StyleBox["x", "MR"],
  ", for example, will normally not be distinguished from an ordinary black \
",
  StyleBox["x", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.10", "10.25"}],

Cell[TextData[{
  "A red ",
  StyleBox["x", "MR"],
  " is usually treated as identical to an ordinary one. "
}], "MathCaption",
  CellTags->{"S2.9.10", "10.26"}],

Cell[CellGroupData[{

Cell["ToExpression[ StyleBox[x, FontColor->RGBColor[1,0,0]]] == x", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.10"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.9.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ButtonBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "display like ",
              StyleBox["boxes", "TI"],
              " but perform an action whenever ",
              StyleBox["boxes", "TI"],
              " are clicked on "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.10"],

Cell["Setting up active elements. ", "Caption",
  CellTags->"S2.9.10"],

Cell[TextData[{
  "In a ",
  StyleBox["Mathematica", "TI"],
  " notebook it is possible to set up elements which perform an action \
whenever you click on them. These elements are represented internally by ",
  StyleBox["ButtonBox", "MR"],
  " objects. When you create an expression containing a ",
  StyleBox["ButtonBox", "MR"],
  ", you will be able to edit the contents of the ",
  StyleBox["ButtonBox", "MR"],
  " directly so long as the ",
  StyleBox["Active", "MR"],
  " option is ",
  StyleBox["False", "MR"],
  " for the cell containing the expression. As soon as you set ",
  StyleBox["Active->True", "MR"],
  ", the ",
  StyleBox["ButtonBox", "MR"],
  " will perform its action whenever you click on it. "
}], "Text",
  CellTags->{"S2.9.10", "10.27"}],

Cell[TextData[{
  "Section ",
  ButtonBox["2.11.6",
    ButtonData:>{"2.11.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  " discusses how to set up actions for ",
  StyleBox["ButtonBox", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S2.9.10", "10.28"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.11 Adjusting Details of Formatting", "Subsection",
  CellTags->{"S2.9.11", "11.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides a large number of options for adjusting the details of how \
expressions are formatted. In most cases, the default settings for these \
options will be quite adequate. But sometimes special features in the \
expressions you are dealing with may require you to change the options.  "
}], "Text",
  CellTags->{"S2.9.11", "11.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["ColumnAlignments", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Center", "MR"],
              " "
            }]], Cell["how to align columns "]},
          {Cell[TextData[{
              StyleBox["RowAlignments", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Baseline", "MR"],
              " "
            }]], Cell["how to align rows "]},
          {Cell[TextData[{
              StyleBox["ColumnSpacings", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0.8", "MR"],
              " "
            }]], Cell["spacings between columns in ems "]},
          {Cell[TextData[{
              StyleBox["RowSpacings", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["1.0", "MR"],
              " "
            }]], 
            Cell["\<\
spacings between rows in x\[Hyphen]heights \
\>"]},
          {Cell[TextData[{
              StyleBox["ColumnsEqual", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to make all columns equal width "]},
          {Cell[TextData[{
              StyleBox["RowsEqual", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to make all rows equal total height "]},
          {Cell[TextData[{
              StyleBox["ColumnWidths", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["the actual width of each column in ems "]},
          {Cell[TextData[{
              StyleBox["RowMinHeight", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["1", "MR"],
              " "
            }]], 
            Cell["\<\
the minimum total height in units of font size assigned \
to each row \
\>"]},
          {Cell[TextData[{
              StyleBox["GridBaseline", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Axis", "MR"],
              " "
            }]], 
            Cell["\<\
with what part of the whole grid the baselines of boxes \
around it should be aligned \
\>"]},
          {Cell[TextData[{
              StyleBox["ColumnLines", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to draw lines between columns "]},
          {Cell[TextData[{
              StyleBox["RowLines", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["False", "MR"],
              " "
            }]], Cell["whether to draw lines between rows "]},
          {Cell[TextData[{
              StyleBox["GridDefaultElement", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Placeholder]\)], "InlineFormula"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[
            "what to insert when a new element is interactively created "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, False, False, False, False, True, 
      False}},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Options to ",
  StyleBox["GridBox", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.9.11"],

Cell["This sets up an array of numbers. ", "MathCaption",
  CellTags->{"S2.9.11", "11.3"}],

Cell["t = Table[{i, (2i)!, (3i)!}, {i, 4}] ;", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Here is how the array is displayed with the default settings for all ",
  StyleBox["GridBox", "MR"],
  " options. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.4"}],

Cell[CellGroupData[{

Cell["GridBox[t] // DisplayForm", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "6"},
          {"2", "24", "720"},
          {"3", "720", "362880"},
          {"4", "40320", "479001600"}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[2]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["This right justifies all the columns. ", "MathCaption",
  CellTags->{"S2.9.11", "11.5"}],

Cell[CellGroupData[{

Cell["GridBox[t, ColumnAlignments->Right] // DisplayForm", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "6"},
          {"2", "24", "720"},
          {"3", "720", "362880"},
          {"4", "40320", "479001600"}
          },
        ColumnAlignments->{Right}],
      DisplayForm]], "Output",
  CellLabel->"Out[3]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
This left justifies the first two columns and right justifies the \
last one. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.6"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[t, ColumnAlignments->{Left, Left, Right}] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "6"},
          {"2", "24", "720"},
          {"3", "720", "362880"},
          {"4", "40320", "479001600"}
          },
        ColumnAlignments->{Left, Left, Right}],
      DisplayForm]], "Output",
  CellLabel->"Out[4]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["This sets the gutters between columns. ", "MathCaption",
  CellTags->{"S2.9.11", "11.7"}],

Cell[CellGroupData[{

Cell["GridBox[t, ColumnSpacings->{5, 10}] // DisplayForm", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "6"},
          {"2", "24", "720"},
          {"3", "720", "362880"},
          {"4", "40320", "479001600"}
          },
        ColumnSpacings->{5, 10}],
      DisplayForm]], "Output",
  CellLabel->"Out[5]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["This forces all columns to be the same width. ", "MathCaption",
  CellTags->{"S2.9.11", "11.8"}],

Cell[CellGroupData[{

Cell["GridBox[t, ColumnsEqual->True] // DisplayForm", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "6"},
          {"2", "24", "720"},
          {"3", "720", "362880"},
          {"4", "40320", "479001600"}
          },
        ColumnsEqual->True],
      DisplayForm]], "Output",
  CellLabel->"Out[6]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Usually a ",
  StyleBox["GridBox", "MR"],
  " leaves room for any character in the current font to appear in each row. \
But with ",
  StyleBox["RowMinHeight->0", "MR"],
  " it packs rows in more tightly. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.9"}],

Cell[CellGroupData[{

Cell["\<\
{GridBox[{{x, x}, {x, x}}], GridBox[{{x, x}, {x, x}}, \
RowMinHeight->0]} // DisplayForm\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{GridBox[{
              {"x", "x"},
              {"x", "x"}
              }], ",", GridBox[{
              {"x", "x"},
              {"x", "x"}
              },
            RowMinHeight->0]}], "}"}],
      DisplayForm]], "Output",
  CellLabel->"Out[7]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Center", "MR"],
              " "
            }]], Cell["centered (default) "]},
          {Cell[TextData[{
              StyleBox["Left", "MR"],
              " "
            }]], Cell["left justified (aligned on left edge) "]},
          {Cell[TextData[{
              StyleBox["Right", "MR"],
              " "
            }]], Cell["right justified (aligned on right edge) "]},
          {Cell[TextData[{
              StyleBox["\".\"", "MR"],
              " "
            }]], Cell["aligned at decimal points "]},
          {Cell[TextData[{
              StyleBox["\"", "MR"],
              StyleBox["c", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell[
            "aligned at the first occurrence of the specified character "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[
            "separate specifications for each column in the grid "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Settings for the ",
  StyleBox["ColumnAlignments", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "In formatting complicated tables, it is often important to be able to \
control in detail the alignment of table entries. By setting ",
  StyleBox["ColumnAlignments->\"", "MR"],
  StyleBox["c", "TI"],
  StyleBox["\"", "MR"],
  " you tell ",
  StyleBox["Mathematica", "TI"],
  " to arrange the elements in each column so that the first occurrence of \
the character ",
  StyleBox["\"", "MR"],
  StyleBox["c", "TI"],
  StyleBox["\"", "MR"],
  " in each entry is aligned. "
}], "Text",
  CellTags->{"S2.9.11", "11.10"}],

Cell[TextData[{
  "Choosing ",
  StyleBox["ColumnAlignments->\".\"", "MR"],
  " will therefore align numbers according to the positions of their decimal \
points. ",
  StyleBox["Mathematica", "TI"],
  " also provides a special \[Backslash]",
  StyleBox["[AlignmentMarker]", "MR"],
  " character, which can be entered as \[AliasIndicator]",
  StyleBox["am\[AliasIndicator]", "MR"],
  ". This character does not display explicitly, but can be inserted in \
entries in a table to mark which point in these entries should be lined up.   \
 "
}], "Text",
  CellTags->{"S2.9.11", "11.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Center", "MR"],
              " "
            }]], Cell["centered "]},
          {Cell[TextData[{
              StyleBox["Top", "MR"],
              " "
            }]], Cell["tops aligned "]},
          {Cell[TextData[{
              StyleBox["Bottom", "MR"],
              " "
            }]], Cell["bottoms aligned "]},
          {Cell[TextData[{
              StyleBox["Baseline", "MR"],
              " "
            }]], Cell["baselines aligned (default) "]},
          {Cell[TextData[{
              StyleBox["Axis", "MR"],
              " "
            }]], Cell["axes aligned "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["pos",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["separate specifications for each row in the grid "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Settings for the ",
  StyleBox["RowAlignments", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "This is the default alignment of elements in a row of a ",
  StyleBox["GridBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.12"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{SuperscriptBox[x, 2], FractionBox[y, z]}}] // DisplayForm\
\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x\^2\), \(y\/z\)}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[8]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
Here is what happens if the bottom of each element is aligned. \
\
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.13"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{SuperscriptBox[x, 2], FractionBox[y, z]}}, \
RowAlignments->Bottom] // DisplayForm\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(x\^2\), \(y\/z\)}
          },
        RowAlignments->Bottom],
      DisplayForm]], "Output",
  CellLabel->"Out[9]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "In a piece of ordinary text, successive characters are normally positioned \
so that their baselines are aligned. For many characters, such as ",
  StyleBox["m", "MR"],
  " and ",
  StyleBox["x", "MR"],
  ", the baseline coincides with the bottom of the character. But in general \
the baseline is the bottom of the main part of the character, and for \
example, in most fonts ",
  StyleBox["g", "MR"],
  " and ",
  StyleBox["y", "MR"],
  " have \[OpenCurlyDoubleQuote]descenders\[CloseCurlyDoubleQuote] that \
extend below the baseline.   "
}], "Text",
  CellTags->{"S2.9.11", "11.14"}],

Cell[TextData[{
  "This shows the alignment of characters with the default setting ",
  StyleBox["RowAlignments->Baseline", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.15"}],

Cell[CellGroupData[{

Cell["GridBox[{{\"x\", \"m\", \"g\", \"y\"}}] // DisplayForm", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"x", "m", "g", "y"}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[10]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
This is what happens if instead the bottom of each character is \
aligned. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.16"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{\"x\", \"m\", \"g\", \"y\"}}, RowAlignments->Bottom] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"x", "m", "g", "y"}
          },
        RowAlignments->Bottom],
      DisplayForm]], "Output",
  CellLabel->"Out[11]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Like characters in ordinary text, ",
  StyleBox["Mathematica", "TI"],
  " will normally position sequences of boxes so that their baselines are \
aligned. For many kinds of boxes the baseline is simply taken to be the \
baseline of the main element of the box. Thus, for example, the baseline of a \
",
  StyleBox["SuperScript", "MR"],
  " box ",
  Cell[BoxData[
      SuperscriptBox[
        StyleBox["x",
          "TI"], 
        StyleBox["y",
          "TI"]]], "InlineFormula"],
  " is taken to be the baseline of ",
  StyleBox["x", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.9.11", "11.17"}],

Cell[TextData[{
  "For a ",
  StyleBox["FractionBox", "MR"],
  " ",
  Cell[BoxData[
      FractionBox[
        StyleBox["x",
          "TI"], 
        StyleBox["y",
          "TI"]]], "InlineFormula"],
  ", the fraction bar defines the ",
  StyleBox["axis", "TI"],
  " of the box. In text in a particular font, one can also define an axis\
\[LongDash]a line going through the centers of symmetrical characters such as \
",
  StyleBox["+", "MR"],
  " and ",
  StyleBox["(", "MR"],
  ". The baseline for a ",
  StyleBox["FractionBox", "MR"],
  " is then taken to be the same distance below its axis as the baseline for \
text in the current font is below its axis.  "
}], "Text",
  CellTags->{"S2.9.11", "11.18"}],

Cell[TextData[{
  "For a ",
  StyleBox["GridBox", "MR"],
  ", you can use the option ",
  StyleBox["GridBaseline", "MR"],
  " to specify where the baseline should be taken to lie. The possible \
settings are the same as the ones for ",
  StyleBox["RowAlignments", "MR"],
  ". The default is ",
  StyleBox["Axis", "MR"],
  ", which makes the center of the ",
  StyleBox["GridBox", "MR"],
  " be aligned with the axis of text around it. "
}], "Text",
  CellTags->{"S2.9.11", "11.19"}],

Cell[TextData[{
  "The ",
  StyleBox["GridBaseline", "MR"],
  " option specifies where the baseline of the ",
  StyleBox["GridBox", "MR"],
  " should be assumed to be. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.20"}],

Cell[CellGroupData[{

Cell["\<\
{GridBox[{{x,x},{x,x}}, GridBaseline->Top], GridBox[{{x,x},{x,x}}, \
GridBaseline->Bottom]} // DisplayForm\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{GridBox[{
              {"x", "x"},
              {"x", "x"}
              },
            GridBaseline->Top], ",", GridBox[{
              {"x", "x"},
              {"x", "x"}
              },
            GridBaseline->Bottom]}], "}"}],
      DisplayForm]], "Output",
  CellLabel->"Out[12]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["Background", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["GrayLevel[0.8]", "MR"],
              " "
            }]], Cell["button background color "]},
          {Cell[TextData[{
              StyleBox["ButtonFrame", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"Palette\"", "MR"],
              " "
            }]], Cell["the type of frame for the button "]},
          {Cell[TextData[{
              StyleBox["ButtonExpandable", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[TextData[{
              "whether a button should expand to fill a position in a ",
              StyleBox["GridBox", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ButtonMargins", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["3", "MR"],
              " "
            }]], 
            Cell["\<\
the margin in printer's points around the contents of a \
button \
\>"]},
          {Cell[TextData[{
              StyleBox["ButtonMinHeight", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["1", "MR"],
              " "
            }]], Cell[
            "the minimum total height of a button in units of font size "]},
          {Cell[TextData[{
              StyleBox["ButtonStyle", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["\"Paste\"", "MR"],
              " "
            }]], 
            Cell["\<\
the style from which properties of the button not \
explicitly specified should be inherited \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Formatting options for ",
  StyleBox["ButtonBox", "MR"],
  " objects. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell["\<\
This makes a button that looks like an element of a dialog box.  \
\
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.21"}],

Cell[CellGroupData[{

Cell["ButtonBox[\"abcd\", ButtonFrame->\"DialogBox\"] // DisplayForm", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      ButtonBox["abcd",
        ButtonFrame->"DialogBox"],
      DisplayForm]], "Output",
  CellLabel->"Out[13]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Palettes are typically constructed using grids of ",
  StyleBox["ButtonBox", "MR"],
  " objects with zero row and column spacing. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.22"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{ButtonBox[\"abc\"], ButtonBox[\"xyz\"]}}, \
ColumnSpacings->0] // DisplayForm\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            ButtonBox["abc"], 
            ButtonBox["xyz"]}
          },
        ColumnSpacings->0],
      DisplayForm]], "Output",
  CellLabel->"Out[14]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Buttons usually expand to be aligned in a ",
  StyleBox["GridBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.23"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{ButtonBox[\"abcd\"]}, {ButtonBox[\"x\"]}}] // DisplayForm\
\
\>", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            ButtonBox["abcd"]},
          {
            ButtonBox["x"]}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[15]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["Here the lower button is made not to expand. ", "MathCaption",
  CellTags->{"S2.9.11", "11.24"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{ButtonBox[\"abcd\"]}, {ButtonBox[\"x\", \
ButtonExpandable->False]}}] // DisplayForm\
\>", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            ButtonBox["abcd"]},
          {
            ButtonBox["x",
              ButtonExpandable->False]}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[16]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Section ",
  ButtonBox["2.11.6",
    ButtonData:>{"2.11.6", "6.1"},
    ButtonStyle->"MainBookLink"],
  " will discuss how to set up actions for ",
  StyleBox["ButtonBox", "MR"],
  " objects. "
}], "Text",
  CellTags->{"S2.9.11", "11.25"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["printer's point "], 
            Cell["\<\
approximately 1/72 inch (or sometimes the size of a \
pixel on a display) \
\>"]},
          {Cell["pica "], Cell["12 printer's points, or 1/6 inch "]},
          {Cell["font point size "], 
            Cell["\<\
the maximum distance in printer's points between the \
top and bottom of any character in a particular font \
\>"]},
          {Cell["em "], 
            Cell["\<\
a width equal to the point font \
size\[LongDash]approximately the width of an \[OpenCurlyDoubleQuote]M\
\[CloseCurlyDoubleQuote] \
\>"]},
          {Cell["en "], Cell["half an em "]},
          {Cell["x\[Hyphen]height "], 
            Cell["\<\
the height of an \[OpenCurlyDoubleQuote]x\
\[CloseCurlyDoubleQuote] character in the current font \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell["Units of distance. ", "Caption",
  CellTags->"S2.9.11"],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["full name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["alias", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[InvisibleSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["is\[AliasIndicator]", "MR"],
              " "
            }]], Cell["zero\[Hyphen]width space "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[VeryThinSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              "1/18 em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[VeryThinSpace]\)], "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ThinSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              "3/18 em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[ThinSpace]\)], "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[MediumSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              "4/18 em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[MediumSpace]\)], "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[ThickSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              "5/18 em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[ThickSpace]\)], "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NegativeVeryThinSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["-", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(-1\)/18\)], "InlineFormula"],
              " em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[NegativeVeryThinSpace]\)], 
                "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NegativeThinSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["-", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(-3\)/18\)], "InlineFormula"],
              " em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[NegativeThinSpace]\)], 
                "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NegativeMediumSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["-", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(-4\)/18\)], "InlineFormula"],
              " em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[NegativeMediumSpace]\)], 
                "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NegativeThickSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["-", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              "\[AliasIndicator] "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\(-5\)/18\)], "InlineFormula"],
              " em (",
              StyleBox["x", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[NegativeThickSpace]\)], 
                "InlineFormula"],
              "x",
              StyleBox[") ", "TR"]
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[RawSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              " "
            }]], Cell["keyboard space character "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[SpaceIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["space\[AliasIndicator]", "MR"],
              " "
            }]], Cell[TextData[{
              "the ",
              Cell[BoxData[
                  \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
              " character indicating a space "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{
    True, False, False, False, False, True, False, False, False, True, 
      False}},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Spacing characters of various widths. ",
  Cell[BoxData[
      \(TraditionalForm\`\[SpaceIndicator]\)], "InlineFormula"],
  " indicates the space key on your keyboard. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "When you enter input such as ",
  StyleBox["x+y", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will automatically convert this to ",
  StyleBox["RowBox[{\"x\",\"+\",\"y\"}]", "MR"],
  ". When the ",
  StyleBox["RowBox", "MR"],
  " is output, ",
  StyleBox["Mathematica", "TI"],
  " will then try to insert appropriate space between each element. \
Typically, it will put more space around characters such as ",
  StyleBox["+", "MR"],
  " that are usually used as operators, and less space around characters such \
as ",
  StyleBox["x", "MR"],
  " that are not. You can however always modify spacing by inserting explicit \
spacing characters. Positive spacing characters will move successive elements \
further apart, while negative ones will bring them closer together.  "
}], "Text",
  CellTags->{"S2.9.11", "11.26"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " by default leaves more space around characters such as ",
  StyleBox["+", "MR"],
  " and ",
  StyleBox["-", "MR"],
  " that are usually used as operators. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.27"}],

Cell[CellGroupData[{

Cell["RowBox[{\"a\", \"b\", \"+\", \"c\", \"-\", \"+\"}] // DisplayForm", \
"Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[\(a  b + c - +\),
      DisplayForm]], "Output",
  CellLabel->"Out[17]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
You can explicitly insert positive and negative spacing characters \
to change spacing. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.28"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{\"a\", \"\\[ThickSpace]\", \"b\", \"+\", \
\"\\[NegativeMediumSpace]\", \"c\", \"-\", \"+\"}] // DisplayForm\
\>", \
"Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[\(a\[ThickSpace]b + \[NegativeMediumSpace]c - +\),
      DisplayForm]], "Output",
  CellLabel->"Out[18]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StyleBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["AutoSpacing->False]", "MR"],
              " "
            }]], Cell[TextData[{
              "leave the same space around every character in ",
              StyleBox["boxes", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Inhibiting automatic spacing in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "This makes ",
  StyleBox["Mathematica", "TI"],
  " leave the same space between successive characters. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.29"}],

Cell[CellGroupData[{

Cell["\<\
StyleBox[RowBox[{\"a\", \"b\", \"+\", \"c\", \"-\", \"+\"}], \
AutoSpacing->False] // DisplayForm\
\>", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      StyleBox[\(a  b + c - +\),
        AutoSpacing->False],
      DisplayForm]], "Output",
  CellLabel->"Out[19]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "When you have an expression displayed on the screen, the notebook front \
end allows you interactively to make detailed adjustments to the positions of \
elements. Typically \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\` \[LeftArrow] \)], "InlineFormula"],
  "\[RightModified], \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\` \[RightArrow] \)], "InlineFormula"],
  "\[RightModified], \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[UpArrow]\)], "InlineFormula"],
  "\[RightModified], \[ControlKey]\[LeftModified]",
  Cell[BoxData[
      \(TraditionalForm\`\[DownArrow]\)], "InlineFormula"],
  "\[RightModified] \[OpenCurlyDoubleQuote]nudge\[CloseCurlyDoubleQuote] \
whatever you have selected by one pixel at your current screen magnification. \
Such adjustments are represented within ",
  StyleBox["Mathematica", "TI"],
  " using ",
  StyleBox["AdjustmentBox", "MR"],
  " objects.    "
}], "Text",
  CellTags->{"S2.9.11", "11.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["AdjustmentBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["BoxMargins->{{", "MR"],
              StyleBox["left", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["right", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["bottom", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["top", "TI"],
              StyleBox["}}]", "MR"],
              " "
            }]], Cell[TextData[{
              "draw margins of the specified widths around ",
              StyleBox["box", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["AdjustmentBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["BoxBaselineShift->", "MR"],
              StyleBox["up", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "shift the height at which baselines of boxes around ",
              StyleBox["box", "TI"],
              " should be aligned "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell["Adjusting the position of a box. ", "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "This adds space to the left of the ",
  StyleBox["B", "MR"],
  " and removes space to its right. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.31"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{\"A\", AdjustmentBox[\"B\", BoxMargins-> {{1, -0.3}, {0, \
0}}], \"C\", \"D\"}] // DisplayForm\
\>", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"A", 
        AdjustmentBox["B",
          BoxMargins->{{1, -0.3}, {0, 0}}], "C", "D"}],
      DisplayForm]], "Output",
  CellLabel->"Out[20]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
By careful adjustment, you can set things up to put two characters \
on top of each other.      \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.32"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{\"C\", AdjustmentBox[\"/\", BoxMargins->{{-.8, .8}, {0, \
0}}]}] // DisplayForm\
\>", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"C", 
        AdjustmentBox["/",
          BoxMargins->{{-0.8, 0.8}, {0, 0}}]}],
      DisplayForm]], "Output",
  CellLabel->"Out[21]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "The left and right margins in an ",
  StyleBox["AdjustmentBox", "MR"],
  " are given in ems; the bottom and top ones in x\[Hyphen]heights. By giving \
positive values for margins you can force there to be space around a box. By \
giving negative values you can effectively trim space away, and force other \
boxes to be closer. Note that in a ",
  StyleBox["RowBox", "MR"],
  ", vertical alignment is determined by the position of the baseline; in a \
",
  StyleBox["FractionBox", "MR"],
  " or an ",
  StyleBox["OverscriptBox", "MR"],
  ", for example, it is instead determined by top and bottom margins. "
}], "Text",
  CellTags->{"S2.9.11", "11.33"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StyleBox[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ShowContents->False]", "MR"],
              " "
            }]], Cell[TextData[{
              "leave space for ",
              StyleBox["boxes", "TI"],
              " but do not display them "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell["Leaving space for boxes without displaying them. ", "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "If you are trying to line up different elements of your output, you can \
use ",
  StyleBox["ShowContents->False", "MR"],
  " in ",
  StyleBox["StyleBox", "MR"],
  " to leave space for boxes without actually displaying them. "
}], "Text",
  CellTags->{"S2.9.11", "11.34"}],

Cell[TextData[{
  "This leaves space for the ",
  StyleBox["Y", "MR"],
  ", but does not display it. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.35"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{\"X\", StyleBox[\"Y\", ShowContents->False], \"Z\"}] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"X", 
        StyleBox["Y",
          ShowContents->False], "Z"}],
      DisplayForm]], "Output",
  CellLabel->"Out[22]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "The sizes of most characters are determined solely by what font they are \
in, as specified for example by the ",
  StyleBox["FontSize", "MR"],
  " option in ",
  StyleBox["StyleBox", "MR"],
  ". But there are some special expandable characters whose size can change \
even within a particular font. Examples are parentheses, which by default are \
taken to expand so as to span any expression they contain. "
}], "Text",
  CellTags->{"S2.9.11", "11.36"}],

Cell["\<\
Parentheses by default expand to span whatever expressions they \
contain. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.37"}],

Cell[CellGroupData[{

Cell["\<\
{RowBox[{\"(\", \"X\", \")\"}], RowBox[{\"(\", FractionBox[\"X\", \
\"Y\"], \")\"}]} // DisplayForm\
\>", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[\({\((X)\), \((X\/Y)\)}\),
      DisplayForm]], "Output",
  CellLabel->"Out[23]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["SpanMinSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "minimum size of expandable characters in units of font size "]},
          {Cell[TextData[{
              StyleBox["SpanMaxSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "maximum size of expandable characters in units of font size "]},
          {Cell[TextData[{
              StyleBox["SpanSymmetric", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], 
            Cell["\<\
whether vertically expandable characters should be \
symmetric about the axis of the box they are in \
\>"]},
          {Cell[TextData[{
              StyleBox["SpanLineThickness", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "thickness in printer's points of fraction lines etc. "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.11"],

Cell[TextData[{
  StyleBox["StyleBox", "MR"],
  " options for controlling expandable characters. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "Parentheses within a single ",
  StyleBox["RowBox", "MR"],
  " by default grow to span whatever other objects appear in the ",
  StyleBox["RowBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.38"}],

Cell[CellGroupData[{

Cell["RowBox[{\"(\", \"(\", GridBox[{{X},{Y},{Z}}]}] // DisplayForm", "Input",
  CellLabel->"In[24]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "(", GridBox[{
            {"X"},
            {"Y"},
            {"Z"}
            }]}],
      DisplayForm]], "Output",
  CellLabel->"Out[24]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
Some expandable characters, however, grow by default only to a \
limited extent. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.39"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{\"{\", \"[\", \"(\", GridBox[{{X},{Y},{Z}}]}] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[25]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", "[", "(", GridBox[{
            {"X"},
            {"Y"},
            {"Z"}
            }]}],
      DisplayForm]], "Output",
  CellLabel->"Out[25]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "This specifies that all characters inside the ",
  StyleBox["StyleBox", "MR"],
  " should be allowed to grow as large as they need. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.40"}],

Cell[CellGroupData[{

Cell["StyleBox[%, SpanMaxSize->Infinity] // DisplayForm", "Input",
  CellLabel->"In[26]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      StyleBox[
        RowBox[{"{", "[", "(", GridBox[{
              {"X"},
              {"Y"},
              {"Z"}
              }]}],
        SpanMaxSize->Infinity],
      DisplayForm]], "Output",
  CellLabel->"Out[26]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["By default, expandable characters grow symmetrically. ", "MathCaption",
  CellTags->{"S2.9.11", "11.41"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{\"(\", GridBox[{{X},{Y}}, GridBaseline->Bottom], \")\"}] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[27]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"X"},
            {"Y"}
            },
          GridBaseline->Bottom], ")"}],
      DisplayForm]], "Output",
  CellLabel->"Out[27]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Setting ",
  StyleBox["SpanSymmetric->False", "MR"],
  " allows expandable characters to grow asymmetrically. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.42"}],

Cell[CellGroupData[{

Cell["{X, StyleBox[%, SpanSymmetric->False]} // DisplayForm", "Input",
  CellLabel->"In[28]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{"X", ",", 
          StyleBox[
            RowBox[{"(", GridBox[{
                  {"X"},
                  {"Y"}
                  },
                GridBaseline->Bottom], ")"}],
            SpanSymmetric->False]}], "}"}],
      DisplayForm]], "Output",
  CellLabel->"Out[28]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "The notebook front end typically provides a ",
  StyleBox["Spanning Characters", "SR"],
  " menu which allows you to change the spanning characteristics of all \
characters within your current selection. "
}], "Text",
  CellTags->{"S2.9.11", "11.43"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["parentheses, arrows, bracketing bars "], Cell[
            "grow without bound "]},
          {Cell["brackets, braces, slash "], Cell["grow to limited size "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.11"],

Cell["Default characteristics of expandable characters. ", "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "The top bracket by default grows to span the ",
  StyleBox["OverscriptBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.44"}],

Cell[CellGroupData[{

Cell["OverscriptBox[\"xxxxxx\", \"\\[OverBracket]\"] // DisplayForm", "Input",
  CellLabel->"In[29]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[\(xxxxxx\&\[OverBracket]\),
      DisplayForm]], "Output",
  CellLabel->"Out[29]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
The right arrow by default grows horizontally to span the column it \
is in. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.45"}],

Cell[CellGroupData[{

Cell["\<\
GridBox[{{\"a\", \"xxxxxxx\", \"b\"}, {\"a\", \"\\[RightArrow]\", \
\"b\"}}] // DisplayForm\
\>", "Input",
  CellLabel->"In[30]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "xxxxxxx", "b"},
          {"a", "\[RightArrow]", "b"}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[30]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
The up arrow similarly grows vertically to span the row it is in. \
\
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.46"}],

Cell[CellGroupData[{

Cell["GridBox[{{FractionBox[X, Y], \"\\[UpArrow]\"}}] // DisplayForm", "Input",
  CellLabel->"In[31]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(X\/Y\), "\[UpArrow]"}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[31]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["ScriptSizeMultipliers", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["0.71", "MR"],
              " "
            }]], Cell[
            "how much smaller to make each level of subscripts, etc. "]},
          {Cell[TextData[{
              StyleBox["ScriptMinSize", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["4", "MR"],
              " "
            }]], Cell[
            "the minimum point size to use for subscripts, etc. "]},
          {Cell[TextData[{
              StyleBox["ScriptBaselineShifts", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{Automatic,", "MR"],
              " ",
              StyleBox["Automatic}", "MR"],
              " "
            }]], 
            Cell["\<\
the distance in x\[Hyphen]heights to shift subscripts \
and superscripts \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.11"],

Cell[TextData[{
  StyleBox["StyleBox", "MR"],
  " options for controlling the size and positioning of subscripts, etc. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "This sets up a collection of nested ",
  StyleBox["SuperscriptBox", "MR"],
  " objects. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.47"}],

Cell[CellGroupData[{

Cell["b = ToBoxes[X^X^X^X^X]", "Input",
  CellLabel->"In[32]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \(SuperscriptBox["X", 
      SuperscriptBox["X", 
        SuperscriptBox["X", SuperscriptBox["X", "X"]]]]\)], "Output",
  CellLabel->"Out[32]= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
By default, successive superscripts get progressively smaller. \
\
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.48"}],

Cell[CellGroupData[{

Cell["b // DisplayForm", "Input",
  CellLabel->"In[33]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[\(X\^\(X\^\(X\^\(X\^X\)\)\)\),
      DisplayForm]], "Output",
  CellLabel->"Out[33]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to make all levels of superscripts the same size. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.49"}],

Cell[CellGroupData[{

Cell["StyleBox[b, ScriptSizeMultipliers->1] // DisplayForm", "Input",
  CellLabel->"In[34]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      StyleBox[\(X\^\(X\^\(X\^\(X\^X\)\)\)\),
        ScriptSizeMultipliers->1],
      DisplayForm]], "Output",
  CellLabel->"Out[34]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
Here successive levels of superscripts are smaller, but only down \
to 5\[Hyphen]point size. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.50"}],

Cell[CellGroupData[{

Cell["StyleBox[b, ScriptMinSize->5] // DisplayForm", "Input",
  CellLabel->"In[35]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      StyleBox[\(X\^\(X\^\(X\^\(X\^X\)\)\)\),
        ScriptMinSize->5],
      DisplayForm]], "Output",
  CellLabel->"Out[35]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will usually optimize the position of subscripts and superscripts in a \
way that depends on their environment. If you want to line up several \
different subscripts or superscripts you therefore typically have to use the \
option ",
  StyleBox["ScriptBaselineShifts", "MR"],
  " to specify an explicit distance to shift each one. "
}], "Text",
  CellTags->{"S2.9.11", "11.51"}],

Cell["\<\
The second subscript is by default shifted down slightly more than \
the first. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.52"}],

Cell[CellGroupData[{

Cell["\<\
RowBox[{SubscriptBox[\"x\", \"0\"], \"+\", SubsuperscriptBox[\"x\", \
\"0\", \"2\"]}] // DisplayForm\
\>", "Input",
  CellLabel->"In[36]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[\(x\_0 + x\_0\%2\),
      DisplayForm]], "Output",
  CellLabel->"Out[36]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to apply exactly the same shift to both subscripts. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.53"}],

Cell[CellGroupData[{

Cell["\<\
StyleBox[%, ScriptBaselineShifts->{1, Automatic}] // \
DisplayForm\
\>", "Input",
  CellLabel->"In[37]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      StyleBox[\(x\_0 + x\_0\%2\),
        ScriptBaselineShifts->{1, Automatic}],
      DisplayForm]], "Output",
  CellLabel->"Out[37]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["LimitsPositioning", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], 
            Cell["\<\
whether to change positioning in the way conventional \
for limits \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S2.9.11"],

Cell[TextData[{
  "An option to ",
  StyleBox["UnderoverscriptBox", "MR"],
  " and related boxes. "
}], "Caption",
  CellTags->"S2.9.11"],

Cell["\<\
The limits of a sum are usually displayed as underscripts and \
overscripts. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.54"}],

Cell[CellGroupData[{

Cell["Sum[f[i], {i, 0, n}]", "Input",
  CellLabel->"In[38]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \(\[Sum]\+\(i = 0\)\%n f[i]\)], "Output",
  CellLabel->"Out[38]= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["\<\
When the sum is shown smaller, however, it is conventional for the \
limits to be displayed as subscripts and superscripts. \
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.55"}],

Cell[CellGroupData[{

Cell["1/%", "Input",
  CellLabel->"In[39]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \(1\/\(\[Sum]\+\(i = 0\)\%n f[i]\)\)], "Output",
  CellLabel->"Out[39]= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["low", "MR"],
  " and ",
  StyleBox["high", "MR"],
  " still display directly above and below ",
  StyleBox["XX", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.56"}],

Cell[CellGroupData[{

Cell["\<\
UnderoverscriptBox[\"XX\", \"low\", \"high\", \
LimitsPositioning->True] // DisplayForm\
\>", "Input",
  CellLabel->"In[40]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      UnderoverscriptBox["XX", "low", "high",
        LimitsPositioning->True],
      DisplayForm]], "Output",
  CellLabel->"Out[40]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "But now ",
  StyleBox["low", "MR"],
  " and ",
  StyleBox["high", "MR"],
  " are moved to subscript and superscript positions. "
}], "MathCaption",
  CellTags->{"S2.9.11", "11.57"}],

Cell[CellGroupData[{

Cell["FractionBox[\"a\", %] // DisplayForm", "Input",
  CellLabel->"In[41]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    TagBox[
      FractionBox["a", 
        UnderoverscriptBox["XX", "low", "high",
          LimitsPositioning->True]],
      DisplayForm]], "Output",
  CellLabel->"Out[41]//DisplayForm= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  StyleBox["LimitsPositioning->Automatic", "MR"],
  " will act as if ",
  StyleBox["LimitsPositioning->True", "MR"],
  " when the first argument of the box is an object such as \[Backslash]",
  StyleBox["[Sum]", "MR"],
  " or \[Backslash]",
  StyleBox["[Product]", "MR"],
  ". You can specify the list of such characters by setting the option ",
  StyleBox["LimitsPositioningTokens", "MR"],
  ".   "
}], "Text",
  CellTags->{"S2.9.11", "11.58"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], "\[Null]"},
          {Cell[TextData[{
              StyleBox["MultilineFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["what to do when a box breaks across several lines "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->True},
  CellTags->"S2.9.11"],

Cell["Line breaking option for boxes. ", "Caption",
  CellTags->"S2.9.11"],

Cell["\<\
When you are dealing with long expressions it is inevitable that \
they will continue beyond the length of a single line. Many kinds of boxes \
change their display characteristics when they break across several lines. \
\
\>", "Text",
  CellTags->{"S2.9.11", "11.59"}],

Cell["\<\
This displays as a built\[Hyphen]up fraction on a single line. \
\
\>", "MathCaption",
  CellTags->{"S2.9.11", "11.60"}],

Cell[CellGroupData[{

Cell["Expand[(1 + x)^5]/Expand[(1 + y)^5]", "Input",
  CellLabel->"In[42]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \(\(1 + 5\ x + 10\ x\^2 + 10\ x\^3 + 5\ x\^4 + x\^5\)\/\(1 + 5\ y + 10\ y\
\^2 + 10\ y\^3 + 5\ y\^4 + y\^5\)\)], "Output",
  CellLabel->"Out[42]= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["This breaks across several lines. ", "MathCaption",
  CellTags->{"S2.9.11", "11.61"}],

Cell[CellGroupData[{

Cell["Expand[(1 + x)^10]/Expand[(1 + y)^5]", "Input",
  CellLabel->"In[43]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \(\((1 + 10\ x + 45\ x\^2 + 120\ x\^3 + 210\ x\^4 + 252\ x\^5 + 
          210\ x\^6 + 120\ x\^7 + 45\ x\^8 + 10\ x\^9 + x\^10)\)/\((1 + 
          5\ y + 10\ y\^2 + 10\ y\^3 + 5\ y\^4 + y\^5)\)\)], "Output",
  CellLabel->"Out[43]= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell[TextData[{
  "You can use the option ",
  StyleBox["MultilineFunction", "MR"],
  " to specify how a particular box should be displayed if it breaks across \
several lines. The setting ",
  StyleBox["MultilineFunction->None", "MR"],
  " prevents the box from breaking at all. "
}], "Text",
  CellTags->{"S2.9.11", "11.62"}],

Cell[TextData[{
  "You can to some extent control where expressions break across lines by \
inserting \[Backslash]",
  StyleBox["[NoBreak]", "MR"],
  " and \[Backslash]",
  StyleBox["[NonBreakingSpace]", "MR"],
  " characters. ",
  StyleBox["Mathematica", "TI"],
  " will try to avoid ever breaking an expression at the position of such \
characters.      "
}], "Text",
  CellTags->{"S2.9.11", "11.63"}],

Cell[TextData[{
  "You can force ",
  StyleBox["Mathematica", "TI"],
  " to break a line by explicitly inserting a \[Backslash]",
  StyleBox["[NewLine]", "MR"],
  " character, obtained in the standard notebook front end simply by typing \
Return. With default settings for options, ",
  StyleBox["Mathematica", "TI"],
  " will automatically indent the next line after you type a Return. However, \
the level of indenting used will be fixed as soon as the line is started, and \
will not change when you edit around it. By inserting an \[Backslash]",
  StyleBox["[IndentingNewLine]", "MR"],
  " character, you can tell ",
  StyleBox["Mathematica", "TI"],
  " always to maintain the correct level of indenting based on the actual \
environment in which a line occurs.    "
}], "Text",
  CellTags->{"S2.9.11", "11.64"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["full name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["alias", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NoBreak]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["nb\[AliasIndicator]", "MR"],
              " "
            }]], Cell["inhibit a line break "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NonBreakingSpace]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["nbs\[AliasIndicator]", "MR"],
              " "
            }]], 
            Cell["\<\
insert a space, inhibiting a line break on either side \
of it \
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[NewLine]", "MR"],
              " "
            }]], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[ReturnIndicator]\)], "InlineFormula"],
              " "
            }]], 
            Cell["\<\
insert a line break, setting the indenting level at the \
time the new line is started \
\>"]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[IndentingNewLine]", "MR"],
              " "
            }]], Cell[TextData[{
              "\[AliasIndicator]",
              StyleBox["nl\[AliasIndicator]", "MR"],
              " "
            }]], 
            Cell["\<\
insert a line break, always maintaining the correct \
indenting level \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.9.11"],

Cell["Characters for controlling line breaking. ", "Caption",
  CellTags->"S2.9.11"],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " breaks an expression across several lines, it indents intermediate lines \
by an amount proportional to the nesting level in the expression at which the \
break occurred. "
}], "Text",
  CellTags->{"S2.9.11", "11.65"}],

Cell["The line breaks here occur only at level\[NonBreakingSpace]1. ", \
"MathCaption",
  CellTags->{"S2.9.11", "11.66"}],

Cell[CellGroupData[{

Cell["Range[30]", "Input",
  CellLabel->"In[44]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30}\)], "Output",
  CellLabel->"Out[44]= ",
  CellTags->"S2.9.11"]
}, Open  ]],

Cell["But here the break is at a much deeper level. ", "MathCaption",
  CellTags->{"S2.9.11", "11.67"}],

Cell[CellGroupData[{

Cell["Nest[List, x+y, 30]", "Input",
  CellLabel->"In[45]:= ",
  CellTags->"S2.9.11"],

Cell[BoxData[
    \({{{{{{{{{{{{{{{{{{{{{{{{{{{{{{x + 
                                        y}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}\)], \
"Output",
  CellLabel->"Out[45]= ",
  CellTags->"S2.9.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.12 String Representation of Boxes", "Subsection",
  CellTags->{"S2.9.12", "12.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides a compact way of representing boxes in terms of strings. This is \
particularly convenient when you want to import or export specifications of \
boxes as ordinary text.    "
}], "Text",
  CellTags->{"S2.9.12", "12.2"}],

Cell[TextData[{
  "This generates an ",
  StyleBox["InputForm", "MR"],
  " string that represents the ",
  StyleBox["SuperscriptBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.3"}],

Cell[CellGroupData[{

Cell["ToString[SuperscriptBox[\"x\", \"2\"], InputForm]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \("\\(x\\^2\\)"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "This creates the ",
  StyleBox["SuperscriptBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.4"}],

Cell[CellGroupData[{

Cell["\\( x \\^ 2 \\)", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \(SuperscriptBox["x", "2"]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToExpression", "MR"],
  " interprets the ",
  StyleBox["SuperscriptBox", "MR"],
  " as a power. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.5"}],

Cell[CellGroupData[{

Cell["ToExpression[%] // FullForm", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Power[x, 2]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "It is important to distinguish between forms that represent just raw \
boxes, and forms that represent the ",
  StyleBox["meaning", "TI"],
  " of the boxes. "
}], "Text",
  CellTags->{"S2.9.12", "12.6"}],

Cell[TextData[{
  "This corresponds to a raw ",
  StyleBox["SuperscriptBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.7"}],

Cell[CellGroupData[{

Cell["\\( x \\^ 2 \\)", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \(SuperscriptBox["x", "2"]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "This corresponds to the power that the ",
  StyleBox["SuperscriptBox", "MR"],
  " represents. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.8"}],

Cell[CellGroupData[{

Cell["\\!\\( x \\^ 2 \\)", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell["The expression generated here is a power. ", "MathCaption",
  CellTags->{"S2.9.12", "12.9"}],

Cell[CellGroupData[{

Cell["FullForm[ \\!\\( x \\^ 2 \\) ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Power[x, 2]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[6]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["(", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["raw boxes "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["the meaning of the boxes "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.12"],

Cell["\<\
Distinguishing raw boxes from the expressions they represent. \
\
\>", "Caption",
  CellTags->"S2.9.12"],

Cell[TextData[{
  "If you copy the contents of a ",
  StyleBox["StandardForm", "MR"],
  " cell into another program, such as a text editor, ",
  StyleBox["Mathematica", "TI"],
  " will automatically generate a \[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " form. This is done so that if you subsequently paste the form back into \
",
  StyleBox["Mathematica", "TI"],
  ", the original contents of the ",
  StyleBox["StandardForm", "MR"],
  " cell will automatically be re\[Hyphen]created. Without the \[Backslash]",
  StyleBox["!", "MR"],
  ", only the raw boxes corresponding to these contents would be obtained.  "
}], "Text",
  CellTags->{"S2.9.12", "12.10"}],

Cell[TextData[{
  "With default settings for options, \[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " forms pasted into ",
  StyleBox["Mathematica", "TI"],
  " notebooks are automatically displayed in two\[Hyphen]dimensional form. \
\[Backslash]",
  StyleBox["!\[Backslash](", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " forms entered directly from the keyboard can be displayed in \
two\[Hyphen]dimensional form using the ",
  StyleBox["Make 2D", "SR"],
  " item in the ",
  StyleBox["Edit", "SR"],
  " menu.  "
}], "Text",
  CellTags->{"S2.9.12", "12.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["\"\[Backslash](", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")\"", "MR"],
              " "
            }]], Cell["a raw character string "]},
          {Cell[TextData[{
              StyleBox["\"\[Backslash]!\[Backslash](", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")\"", "MR"],
              " "
            }]], Cell["a string containing boxes "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.12"],

Cell["\<\
Embedding two\[Hyphen]dimensional box structures in strings. \
\>", \
"Caption",
  CellTags->"S2.9.12"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " will usually treat a \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " form that appears within a string just like any other sequence of \
characters. But by inserting a \[Backslash]",
  StyleBox["!", "MR"],
  " you can tell ",
  StyleBox["Mathematica", "TI"],
  " instead to treat this form like the boxes it represents. In this way you \
can therefore embed box structures within ordinary character strings.  "
}], "Text",
  CellTags->{"S2.9.12", "12.12"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " treats this as an ordinary character string. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.13"}],

Cell[CellGroupData[{

Cell["\"\\( x \\^ 2 \\)\"", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \("\( x \^ 2 \)"\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "The \[Backslash]",
  StyleBox["!", "MR"],
  " tells ",
  StyleBox["Mathematica", "TI"],
  " that this string contains boxes. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.14"}],

Cell[CellGroupData[{

Cell["\"\\!\\( x \\^ 2 \\)\"", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \("\!\( x \^ 2 \)"\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell["You can mix boxes with ordinary text. ", "MathCaption",
  CellTags->{"S2.9.12", "12.15"}],

Cell[CellGroupData[{

Cell["\"box 1: \\!\\(x\\^2\\); box 2: \\!\\(y\\^3\\)\"", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \("box 1: \!\(x\^2\); box 2: \!\(y\^3\)"\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["(", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] \[Backslash])",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              StyleBox["RowBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]^", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SuperscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]_", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["SubsuperscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]&", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]+", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]%", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["UnderoverscriptBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "3"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " ",
              StyleBox["\[Backslash]/", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["FractionBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["@", "MR"],
              " ",
              StyleBox["box", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["SqrtBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["@", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " \[Backslash]% ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["RadicalBox[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["box",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["form", "TI"],
              " ",
              StyleBox["\[Backslash]`", "MR"],
              " ",
              StyleBox["box", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["FormBox[", "MR"],
              StyleBox["box", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["*", "MR"],
              " ",
              StyleBox["input", "TI"],
              " "
            }]], Cell[TextData[{
              "construct boxes from ",
              StyleBox["input", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.12"],

Cell["Input forms for boxes. ", "Caption",
  CellTags->"S2.9.12"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " requires that any input forms you give for boxes be enclosed within \
\[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  ". But within these outermost \[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " you can use additional \[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " to specify grouping. "
}], "Text",
  CellTags->{"S2.9.12", "12.16"}],

Cell["Here ordinary parentheses are used to indicate grouping. ", \
"MathCaption",
  CellTags->{"S2.9.12", "12.17"}],

Cell[CellGroupData[{

Cell["\\( x \\/ (y + z) \\) // DisplayForm", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[\(x\/\((y + z)\)\),
      DisplayForm]], "Output",
  CellLabel->"Out[10]//DisplayForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell["Without the parentheses, the grouping would be different. ", \
"MathCaption",
  CellTags->{"S2.9.12", "12.18"}],

Cell[CellGroupData[{

Cell["\\( x \\/ y + z \\) // DisplayForm", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[\(x\/y + z\),
      DisplayForm]], "Output",
  CellLabel->"Out[11]//DisplayForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " specify grouping, but are not displayed as explicit parentheses. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.19"}],

Cell[CellGroupData[{

Cell["\\( x \\/ \\(y + z\\) \\) // DisplayForm", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[\(x\/\(y + z\)\),
      DisplayForm]], "Output",
  CellLabel->"Out[12]//DisplayForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "The inner \[Backslash]",
  StyleBox["(", "MR"],
  " and \[Backslash]",
  StyleBox[")", "MR"],
  " lead to the construction of a ",
  StyleBox["RowBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.20"}],

Cell[CellGroupData[{

Cell["\\( x \\/ \\(y + z\\) \\)", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \(FractionBox["x", RowBox[{"y", "+", "z"}]]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "When you type ",
  StyleBox["aa+bb", "MR"],
  " as input to ",
  StyleBox["Mathematica", "TI"],
  ", the first thing that happens is that ",
  StyleBox["aa", "MR"],
  ", ",
  StyleBox["+", "MR"],
  " and ",
  StyleBox["bb", "MR"],
  " are recognized as being separate \[OpenCurlyDoubleQuote]tokens\
\[CloseCurlyDoubleQuote]. The same separation into tokens is done when boxes \
are constructed from input enclosed in \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ". However, inside the boxes each token is given as a string, rather than \
in its raw form.  "
}], "Text",
  CellTags->{"S2.9.12", "12.21"}],

Cell[TextData[{
  "The ",
  StyleBox["RowBox", "MR"],
  " has ",
  StyleBox["aa", "MR"],
  ", ",
  StyleBox["+", "MR"],
  " and ",
  StyleBox["bb", "MR"],
  " broken into separate strings. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.22"}],

Cell[CellGroupData[{

Cell["\\( aa+bb \\) // FullForm", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(RowBox[List["\<aa\>", "\<+\>", "\<bb\>"]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[14]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "The spaces around the ",
  StyleBox["+", "MR"],
  " are by default discarded. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.23"}],

Cell[CellGroupData[{

Cell["\\( aa + bb \\) // FullForm", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(RowBox[List["\<aa\>", "\<+\>", "\<bb\>"]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[15]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell["\<\
Backslash\[Hyphen]space inserts a literal space. \
\>", \
"MathCaption",
  CellTags->{"S2.9.12", "12.24"}],

Cell[CellGroupData[{

Cell["\\( aa \\ + \\ bb \\) // FullForm", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(RowBox[
          List["\<aa\>", "\< \>", "\<+\>", "\< \>", "\<bb\>"]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[16]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "Here two nested ",
  StyleBox["RowBox", "MR"],
  " objects are formed. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.25"}],

Cell[CellGroupData[{

Cell["\\( aa+bb/cc \\) // FullForm", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(RowBox[
          List["\<aa\>", "\<+\>", 
            RowBox[List["\<bb\>", "\</\>", "\<cc\>"]]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[17]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "The same box structure is formed even when the string given does not \
correspond to a complete ",
  StyleBox["Mathematica", "TI"],
  " expression. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.26"}],

Cell[CellGroupData[{

Cell["\\( aa+bb/ \\) // FullForm", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox[\(RowBox[
          List["\<aa\>", "\<+\>", RowBox[List["\<bb\>", "\</\>"]]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[18]//FullForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "Within \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " sequences, you can set up certain kinds of boxes by using backslash \
notations such as \[Backslash]",
  StyleBox["^", "MR"],
  " and \[Backslash]",
  StyleBox["@", "MR"],
  ". But for other kinds of boxes, you need to give ordinary ",
  StyleBox["Mathematica", "TI"],
  " input, prefaced by\[NonBreakingSpace]\[Backslash]",
  StyleBox["*", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.9.12", "12.27"}],

Cell[TextData[{
  "This constructs a ",
  StyleBox["GridBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.28"}],

Cell[CellGroupData[{

Cell["\\( \\*GridBox[{{\"a\", \"b\"}, {\"c\", \"d\"}}] \\) // DisplayForm", \
"Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[GridBox[{
          {"a", "b"},
          {"c", "d"}
          }],
      DisplayForm]], "Output",
  CellLabel->"Out[19]//DisplayForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "This constructs a ",
  StyleBox["StyleBox", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.29"}],

Cell[CellGroupData[{

Cell["\\( \\*StyleBox[\"text\", FontWeight->\"Bold\"] \\) // DisplayForm", \
"Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      StyleBox["text",
        FontWeight->"Bold"],
      DisplayForm]], "Output",
  CellLabel->"Out[20]//DisplayForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["*", "MR"],
  " in effect acts like an escape: it allows you to enter ordinary ",
  StyleBox["Mathematica", "TI"],
  " syntax even within a \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " sequence. Note that the input you give after a \[Backslash]",
  StyleBox["*", "MR"],
  " can itself in turn contain \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  " sequences. "
}], "Text",
  CellTags->{"S2.9.12", "12.30"}],

Cell[TextData[{
  "You can alternate nested \[Backslash]",
  StyleBox["*", "MR"],
  " and \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ". Explicit quotes are needed outside of \[Backslash]",
  StyleBox["(", "MR"],
  " ",
  "\[Ellipsis]",
  " ",
  StyleBox["\[Backslash])", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.31"}],

Cell[CellGroupData[{

Cell["\<\
\\( x + \\*GridBox[{{\"a\", \"b\"}, {\\(c \\^ 2\\), \\(d \\/ \
\\*GridBox[{{\"x\",\"y\"},{\"x\",\"y\"}}] \\)}}] \\) // DisplayForm\
\>", \
"Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    TagBox[
      RowBox[{"x", "+", GridBox[{
            {"a", "b"},
            {\(c\^2\), 
              FractionBox["d", GridBox[{
                    {"x", "y"},
                    {"x", "y"}
                    }]]}
            }]}],
      DisplayForm]], "Output",
  CellLabel->"Out[21]//DisplayForm= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "In the notebook front end, you can typically use \[ControlKey]\
\[LeftModified]",
  StyleBox["*\[RightModified]", "MR"],
  " or \[ControlKey]\[LeftModified]",
  StyleBox["8\[RightModified]", "MR"],
  " to get a dialog box in which you can enter raw boxes\[LongDash]just as \
you do after \[Backslash]",
  StyleBox["*", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.9.12", "12.32"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["interpret input in the current form "]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["!\[Backslash](", "MR"],
              StyleBox["form", "TI"],
              " ",
              StyleBox["\[Backslash]`", "MR"],
              " ",
              StyleBox["input", "TI"],
              "\[Backslash]",
              StyleBox[")", "MR"],
              " "
            }]], Cell["interpret input using the specified form "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.12"],

Cell["Controlling the way input is interpreted. ", "Caption",
  CellTags->"S2.9.12"],

Cell[TextData[{
  "In a ",
  StyleBox["StandardForm", "MR"],
  " cell, this will be interpreted in ",
  StyleBox["StandardForm", "MR"],
  ", yielding a product. "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.33"}],

Cell[CellGroupData[{

Cell["\\!\\( c(1+x) \\)", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \(c\ \((1 + x)\)\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell[TextData[{
  "The backslash backquote sequence tells ",
  StyleBox["Mathematica", "TI"],
  " to interpret this in ",
  StyleBox["TraditionalForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.12", "12.34"}],

Cell[CellGroupData[{

Cell["\\!\\(TraditionalForm\\` c(1+x) \\)", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.9.12"],

Cell[BoxData[
    \(c[1 + x]\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.9.12"]
}, Open  ]],

Cell["\<\
When you copy the contents of a cell from a notebook into a program \
such as a text editor, no explicit backslash backquote sequence is usually \
included. But if you expect to paste what you get back into a cell of a \
different type from the one it came from, then you will typically need to \
include a backslash backquote sequence in order to ensure that everything is \
interpreted correctly.  \
\>", "Text",
  CellTags->{"S2.9.12", "12.35"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.13 Converting between Strings, Boxes and Expressions", "Subsection",
  CellTags->{"S2.9.13", "13.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToString[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a string representing the specified textual form of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ToBoxes[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create boxes representing the specified textual form of ",
              StyleBox["expr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ToExpression[", "MR"],
              StyleBox["input", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
create an expression by interpreting a string or boxes \
as input in the specified textual form \
\>"]},
          {Cell[TextData[{
              StyleBox["ToString[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a string using ",
              StyleBox["OutputForm", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ToBoxes[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create boxes using ",
              StyleBox["StandardForm", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ToExpression[", "MR"],
              StyleBox["input", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create an expression using ",
              StyleBox["StandardForm", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{False, False, True, False}},
  CellTags->"S2.9.13"],

Cell["Converting between strings, boxes and expressions. ", "Caption",
  CellTags->"S2.9.13"],

Cell["Here is a simple expression. ", "MathCaption",
  CellTags->{"S2.9.13", "13.2"}],

Cell[CellGroupData[{

Cell["x^2 + y^2", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(x\^2 + y\^2\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "This gives the ",
  StyleBox["InputForm", "MR"],
  " of the expression as a string. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.3"}],

Cell[CellGroupData[{

Cell["ToString[x^2 + y^2, InputForm]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \("x^2 + y^2"\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["FullForm", "MR"],
  " explicit quotes are shown around the string. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.4"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    TagBox[
      StyleBox["\"\<x^2 + y^2\>\"",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "This gives a string representation for the ",
  StyleBox["StandardForm", "MR"],
  " boxes that correspond to the expression. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.5"}],

Cell[CellGroupData[{

Cell["ToString[x^2 + y^2, StandardForm] // FullForm", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    TagBox[
      StyleBox["\"\<\\!\\(x\\^2 + y\\^2\\)\>\"",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[4]//FullForm= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToBoxes", "MR"],
  " yields the boxes themselves. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.6"}],

Cell[CellGroupData[{

Cell["ToBoxes[x^2 + y^2, StandardForm]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(RowBox[{SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "In generating data for files and external programs, it is sometimes \
necessary to produce two\[Hyphen]dimensional forms which use only ordinary \
keyboard characters. You can do this using ",
  StyleBox["OutputForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.13", "13.7"}],

Cell["\<\
This produces a string which gives a two\[Hyphen]dimensional \
rendering of the expression, using only ordinary keyboard characters. \
\>", \
"MathCaption",
  CellTags->{"S2.9.13", "13.8"}],

Cell[CellGroupData[{

Cell["ToString[x^2 + y^2, OutputForm]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(" 2    2\nx  + y"\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "The string consists of two lines, separated by an explicit \[Backslash]",
  StyleBox["n", "MR"],
  " newline. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.9"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    TagBox[
      StyleBox["\"\< 2    2\\nx  + y\>\"",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[7]//FullForm= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell["The string looks right only in a monospaced font. ", "MathCaption",
  CellTags->{"S2.9.13", "13.10"}],

Cell[CellGroupData[{

Cell["StyleBox[%, FontFamily->\"Times\"] // DisplayForm", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    TagBox[
      StyleBox[\(\(\ \)\(2\ \ \ \ 2\ x\ \  + \ y\)\),
        FontFamily->"Times"],
      DisplayForm]], "Output",
  CellLabel->"Out[8]//DisplayForm= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "If you operate only with one\[Hyphen]dimensional structures, you can \
effectively use ",
  StyleBox["ToString", "MR"],
  " to do string manipulation with formatting functions. "
}], "Text",
  CellTags->{"S2.9.13", "13.11"}],

Cell[TextData[{
  "This generates a string corresponding to the ",
  StyleBox["OutputForm", "MR"],
  " of ",
  StyleBox["StringForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.12"}],

Cell[CellGroupData[{

Cell["ToString[StringForm[\"``^10 = ``\", 4, 4^10]] // InputForm", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.13"],

Cell["\"4^10 = 1048576\"", "Output",
  CellLabel->"Out[9]//InputForm= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["InputForm", "MR"],
              " "
            }]], Cell["strings corresponding to keyboard input "]},
          {Cell[TextData[{
              StyleBox["StandardForm", "MR"],
              " "
            }]], 
            Cell["\<\
strings or boxes corresponding to standard \
two\[Hyphen]dimensional input (default) \
\>"]},
          {Cell[TextData[{
              StyleBox["TraditionalForm", "MR"],
              " "
            }]], Cell[
            "strings or boxes mimicking traditional mathematical notation"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.13"],

Cell[TextData[{
  "Some forms handled by ",
  StyleBox["ToExpression", "MR"],
  ". "
}], "Caption",
  CellTags->"S2.9.13"],

Cell[TextData[{
  "This creates an expression from an ",
  StyleBox["InputForm", "MR"],
  " string. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.13"}],

Cell[CellGroupData[{

Cell["ToExpression[\"x^2 + y^2\"]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(x\^2 + y\^2\)], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "This creates the same expression from ",
  StyleBox["StandardForm", "MR"],
  " boxes. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.14"}],

Cell[CellGroupData[{

Cell["\<\
ToExpression[RowBox[{SuperscriptBox[\"x\", \"2\"], \"+\", \
SuperscriptBox[\"y\", \"2\"]}]]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(x\^2 + y\^2\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "Here the boxes are represented in ",
  StyleBox["InputForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.15"}],

Cell[CellGroupData[{

Cell["ToExpression[\\(x\\^2 + y\\^2\\)]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(x\^2 + y\^2\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell["This returns raw boxes. ", "MathCaption",
  CellTags->{"S2.9.13", "13.16"}],

Cell[CellGroupData[{

Cell["ToExpression[\"\\(x\\^2 + y\\^2\\)\"]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(RowBox[{SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell["This interprets the boxes. ", "MathCaption",
  CellTags->{"S2.9.13", "13.17"}],

Cell[CellGroupData[{

Cell["ToExpression[\"\\!\\(x\\^2 + y\\^2\\)\"]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(x\^2 + y\^2\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["TraditionalForm", "MR"],
  " these are interpreted as functions. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.18"}],

Cell[CellGroupData[{

Cell["ToExpression[\"c(1 + x) + log(x)\", TraditionalForm]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(c[1 + x] + Log[x]\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["ToExpression[", "MR"],
              StyleBox["input", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "create an expression, then wrap it with head ",
              StyleBox["h", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.13"],

Cell["Creating expressions wrapped with special heads. ", "Caption",
  CellTags->"S2.9.13"],

Cell["This creates an expression, then immediately evaluates it. ", \
"MathCaption",
  CellTags->{"S2.9.13", "13.19"}],

Cell[CellGroupData[{

Cell["ToExpression[\"1 + 1\"]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "This creates an expression using ",
  StyleBox["StandardForm", "MR"],
  " rules, then wraps it in ",
  StyleBox["Hold", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.20"}],

Cell[CellGroupData[{

Cell["ToExpression[\"1 + 1\", StandardForm, Hold]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(Hold[1 + 1]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "You can get rid of the ",
  StyleBox["Hold", "MR"],
  " using ",
  StyleBox["ReleaseHold", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.21"}],

Cell[CellGroupData[{

Cell["ReleaseHold[%]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["SyntaxQ[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "determine whether a string represents syntactically correct ",
              StyleBox["Mathematica", "TI"],
              " input "
            }]]},
          {Cell[TextData[{
              StyleBox["SyntaxLength[\"", "MR"],
              StyleBox["string", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], 
            Cell["\<\
find out how long a sequence of characters starting at \
the beginning of a string is syntactically correct \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.13"],

Cell["Testing correctness of strings as input. ", "Caption",
  CellTags->"S2.9.13"],

Cell[TextData[{
  StyleBox["ToExpression", "MR"],
  " will attempt to interpret any string as ",
  StyleBox["Mathematica", "TI"],
  " input. But if you give it a string that does not correspond to \
syntactically correct input, then it will print a message, and return ",
  StyleBox["$Failed", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.13", "13.22"}],

Cell[TextData[{
  "This is not syntactically correct input, so ",
  StyleBox["ToExpression", "MR"],
  " does not convert it to an expression. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.23"}],

Cell[CellGroupData[{

Cell["ToExpression[\"1 +/+ 2\"]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.13"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"1 +/+ 2\".          \
                                          ^\
\>", "Message",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToExpression", "MR"],
  " requires that the string correspond to a ",
  StyleBox["complete", "TI"],
  " ",
  StyleBox["Mathematica", "TI"],
  " expression. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.24"}],

Cell[CellGroupData[{

Cell["ToExpression[\"1 + 2 + \"]", "Input",
  CellLabel->"In[20]:= ",
  CellTags->"S2.9.13"],

Cell["\<\
ToExpression::sntxi:     Incomplete expression; more input is \
needed. \
\>", "Message",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[20]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "You can use the function ",
  StyleBox["SyntaxQ", "MR"],
  " to test whether a particular string corresponds to syntactically correct \
",
  StyleBox["Mathematica", "TI"],
  " input. If ",
  StyleBox["SyntaxQ", "MR"],
  " returns ",
  StyleBox["False", "MR"],
  ", you can find out where the error occurred using ",
  StyleBox["SyntaxLength", "MR"],
  ". ",
  StyleBox["SyntaxLength", "MR"],
  " returns the number of characters which were successfully processed before \
a syntax error was detected. "
}], "Text",
  CellTags->{"S2.9.13", "13.25"}],

Cell[TextData[{
  StyleBox["SyntaxQ", "MR"],
  " shows that this string does not correspond to syntactically correct ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.26"}],

Cell[CellGroupData[{

Cell["SyntaxQ[\"1 +/+ 2\"]", "Input",
  CellLabel->"In[21]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[21]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  StyleBox["SyntaxLength", "MR"],
  " reveals that an error was detected after the third character in the \
string. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.27"}],

Cell[CellGroupData[{

Cell["SyntaxLength[\"1 +/+ 2\"]", "Input",
  CellLabel->"In[22]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[22]= ",
  CellTags->"S2.9.13"]
}, Open  ]],

Cell[TextData[{
  "Here ",
  StyleBox["SyntaxLength", "MR"],
  " returns a value greater than the length of the string, indicating that \
the input was correct so far as it went, but needs to be continued. "
}], "MathCaption",
  CellTags->{"S2.9.13", "13.28"}],

Cell[CellGroupData[{

Cell["SyntaxLength[\"1 + 2 + \"]", "Input",
  CellLabel->"In[23]:= ",
  CellTags->"S2.9.13"],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[23]= ",
  CellTags->"S2.9.13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "2.9.14 The Syntax of the ",
  StyleBox["Mathematica", "SBO"],
  " Language"
}], "Subsection",
  CellTags->{"S2.9.14", "14.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " uses various syntactic rules to interpret input that you give, and to \
convert strings and boxes into expressions. The version of these rules that \
is used for ",
  StyleBox["StandardForm", "MR"],
  " and ",
  StyleBox["InputForm", "MR"],
  " in effect defines the basic ",
  StyleBox["Mathematica", "TI"],
  " language. The rules used for other forms, such as ",
  StyleBox["TraditionalForm", "MR"],
  ", follow the same overall principles, but differ in many details.  "
}], "Text",
  CellTags->{"S2.9.14", "14.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["a", "MR"],
              ", ",
              StyleBox["xyz", "MR"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Beta]\)], "InlineFormula"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Gamma]\)], "InlineFormula"],
              " "
            }]], Cell["symbols "]},
          {Cell[TextData[{
              StyleBox["\"some", "MR"],
              " ",
              StyleBox["text\"", "MR"],
              ", ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Alpha]\)], "InlineFormula"],
              " ",
              StyleBox["+", "MR"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Beta]\)], "InlineFormula"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["strings "]},
          {Cell[TextData[{
              StyleBox["123.456", "MR"],
              ", ",
              StyleBox["3*^45", "MR"],
              " "
            }]], Cell["numbers "]},
          {Cell[TextData[{
              StyleBox["+", "MR"],
              ", ",
              StyleBox["->", "MR"],
              ", ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NotEqual] \)], "InlineFormula"],
              " "
            }]], Cell["operators "]},
          {Cell[TextData[{
              StyleBox["(*", "MR"],
              " ",
              StyleBox["comment", "MR"],
              " ",
              StyleBox["*)", "MR"],
              " "
            }]], Cell["input to be ignored "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.14"],

Cell[TextData[{
  "Types of tokens in the ",
  StyleBox["Mathematica", "SO"],
  " language. "
}], "Caption",
  CellTags->"S2.9.14"],

Cell[TextData[{
  "When you give text as input to ",
  StyleBox["Mathematica", "TI"],
  ", the first thing that ",
  StyleBox["Mathematica", "TI"],
  " does is to break the text into a sequence of ",
  StyleBox["tokens", "TI"],
  ", with each token representing a separate syntactic unit. "
}], "Text",
  CellTags->{"S2.9.14", "14.3"}],

Cell[TextData[{
  "Thus, for example, if you give the input ",
  StyleBox["xx+yy-zzzz", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will break this into the sequence of tokens ",
  StyleBox["xx", "MR"],
  ", ",
  StyleBox["+", "MR"],
  ", ",
  StyleBox["yy", "MR"],
  ", ",
  StyleBox["-", "MR"],
  " and ",
  StyleBox["zzzz", "MR"],
  ". Here ",
  StyleBox["xx", "MR"],
  ", ",
  StyleBox["yy", "MR"],
  " and ",
  StyleBox["zzzz", "MR"],
  " are tokens that correspond to symbols, while ",
  StyleBox["+", "MR"],
  " and ",
  StyleBox["-", "MR"],
  " are operators.  "
}], "Text",
  CellTags->{"S2.9.14", "14.4"}],

Cell[TextData[{
  "Operators are ultimately what determine the structure of the expression \
formed from a particular piece of input. The ",
  StyleBox["Mathematica", "TI"],
  " language involves several general classes of operators, distinguished by \
the different positions in which they appear with respect to their operands. \
"
}], "Text",
  CellTags->{"S2.9.14", "14.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["prefix "], Cell[TextData[{
              StyleBox["!", "MR"],
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Not[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell["postfix "], Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["!", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Factorial[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell["infix "], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Plus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell["matchfix "], Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["List[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell["compound "], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["/:", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["TagSet[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell["overfix "], Cell[TextData[{
              Cell[BoxData[
                  OverscriptBox[
                    StyleBox["x",
                      "TI"], "^"]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["OverHat[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.14"],

Cell[TextData[{
  "Examples of classes of operators in the ",
  StyleBox["Mathematica", "SO"],
  " language. "
}], "Caption",
  CellTags->"S2.9.14"],

Cell["\<\
Operators typically work by picking up operands from definite \
positions around them. But when a string contains more than one operator, the \
result can in general depend on which operator picks up its operands first. \
\
\>", "Text",
  CellTags->{"S2.9.14", "14.6"}],

Cell[TextData[{
  "Thus, for example, ",
  StyleBox["a*b+c", "MR"],
  " could potentially be interpreted either as ",
  StyleBox["(a*b)+c", "MR"],
  " or as ",
  StyleBox["a*(b+c)", "MR"],
  " depending on whether ",
  StyleBox["*", "MR"],
  " or ",
  StyleBox["+", "MR"],
  " picks up its operands first. "
}], "Text",
  CellTags->{"S2.9.14", "14.7"}],

Cell[TextData[{
  "To avoid such ambiguities, ",
  StyleBox["Mathematica", "TI"],
  " assigns a ",
  StyleBox["precedence", "TI"],
  " to each operator that can appear. Operators with higher precedence are \
then taken to pick up their operands first.    "
}], "Text",
  CellTags->{"S2.9.14", "14.8"}],

Cell[TextData[{
  "Thus, for example, the multiplication operator ",
  StyleBox["*", "MR"],
  " is assigned higher precedence than ",
  StyleBox["+", "MR"],
  ", so that it picks up its operands first, and ",
  StyleBox["a*b+c", "MR"],
  " is interpreted as ",
  StyleBox["(a*b)+c", "MR"],
  " rather than ",
  StyleBox["a*(b+c)", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.14", "14.9"}],

Cell[TextData[{
  "The ",
  StyleBox["*", "MR"],
  " operator has higher precedence than ",
  StyleBox["+", "MR"],
  ", so in both cases ",
  StyleBox["Times", "MR"],
  " is the innermost function. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.10"}],

Cell[CellGroupData[{

Cell["{FullForm[a * b + c], FullForm[a + b * c]}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          StyleBox[\(Plus[Times[a, b], c]\),
            ShowSpecialCharacters->False,
            ShowStringCharacters->True,
            NumberMarks->True],
          FullForm], ",", 
        TagBox[
          StyleBox[\(Plus[a, Times[b, c]]\),
            ShowSpecialCharacters->False,
            ShowStringCharacters->True,
            NumberMarks->True],
          FullForm]}], "}"}]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["//", "MR"],
  " operator has rather low precedence. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.11"}],

Cell[CellGroupData[{

Cell["a * b + c // f", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(f[a\ b + c]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["@", "MR"],
  " operator has high precedence. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.12"}],

Cell[CellGroupData[{

Cell["f @ a * b + c", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(c + b\ f[a]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell["\<\
Whatever the precedence of the operators you are using, you can \
always specify the structure of the expressions you want to form by \
explicitly inserting appropriate parentheses.  \
\>", "Text",
  CellTags->{"S2.9.14", "14.13"}],

Cell[TextData[{
  "Inserting parentheses makes ",
  StyleBox["Plus", "MR"],
  " rather than ",
  StyleBox["Times", "MR"],
  " the innermost function. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.14"}],

Cell[CellGroupData[{

Cell["FullForm[a * (b + c)]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Times[a, Plus[b, c]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[4]//FullForm= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Extensions of symbol names "], Cell[TextData[{
              StyleBox["x", "TI"],
              StyleBox["_", "MR"],
              ",  ",
              StyleBox["#2", "MR"],
              ",  ",
              StyleBox["e", "TI"],
              StyleBox["::", "MR"],
              StyleBox["s", "TI"],
              ",  etc. "
            }]]},
          {Cell["Function application variants "], Cell[TextData[{
              StyleBox["e", "TI"],
              StyleBox["[", "MR"],
              StyleBox["e", "TI"],
              StyleBox["]", "MR"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["@@", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Power\[Hyphen]related operators "], Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Sqrt]\)], "InlineFormula"],
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              StyleBox["^", "MR"],
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["\<\
Multiplication\[Hyphen]related operators \
\>"], Cell[
            TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Del]\)], "InlineFormula"],
              StyleBox["e", "TI"],
              ", ",
              StyleBox["e", "TI"],
              StyleBox["/", "MR"],
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
              "e",
              StyleBox[", ", "TR"],
              StyleBox["e", "TI"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Addition\[Hyphen]related operators "], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[Union]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Relational operators "], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["==", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Tilde] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[NestedLessLess] \)], "InlineFormula"],
              
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftTriangleBar] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Element] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Arrow and vector operators "], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[LongRightArrow]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[UpperRightArrow] \)], 
                "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Equilibrium] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightVectorBar]\)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Logic operators "], Cell[TextData[{
              Cell[BoxData[
                  RowBox[{
                    SubscriptBox["\[ForAll]", 
                      StyleBox["e",
                        "TI"]], 
                    StyleBox["e",
                      "TI"]}]], "InlineFormula"],
              ", ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["&&", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Or] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[RightTee] \)], "InlineFormula"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Pattern and rule operators "], Cell[TextData[{
              StyleBox["e", "TI"],
              StyleBox["..", "MR"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["|", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["e", "TI"],
              ", ",
              StyleBox["e", "TI"],
              " ",
              StyleBox["/.", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Pure function operator "], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["&", "MR"],
              " "
            }]]},
          {Cell["Assignment operators "], Cell[TextData[{
              StyleBox["e", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  ",
              StyleBox["e", "TI"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              StyleBox["e", "TI"],
              ",  etc. "
            }]]},
          {Cell["Compound expression "], Cell[TextData[{
              StyleBox["e", "TI"],
              StyleBox[";", "MR"],
              " ",
              StyleBox["e", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.14"],

Cell["Outline of operators in order of decreasing precedence. ", "Caption",
  CellTags->"S2.9.14"],

Cell[TextData[{
  "The table in Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.3"},
    ButtonStyle->"MainBookLink"],
  " gives the complete ordering by precedence of all operators in ",
  StyleBox["Mathematica", "TI"],
  ". Much of this ordering, as in the case of ",
  StyleBox["*", "MR"],
  " and ",
  StyleBox["+", "MR"],
  ", is determined directly by standard mathematical usage. But in general \
the ordering is simply set up to make it less likely for explicit parentheses \
to have to be inserted in typical pieces of input. "
}], "Text",
  CellTags->{"S2.9.14", "14.15"}],

Cell["\<\
Operator precedences are such that this requires no parentheses. \
\
\>", "MathCaption",
  CellTags->{"S2.9.14", "14.16"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[ForAll] \_x\(\[Exists] \_y x\[CircleTimes]y \[Succeeds] y\) \[And] 
        m \[NotEqual] 0 \[Implies] n \[NotRightTriangleBar] m\)], "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(Implies[\[ForAll] \_x\((\[Exists] \_y x\[CircleTimes]y \[Succeeds] 
                y)\) && m \[NotEqual] 0, 
      n \[NotRightTriangleBar] m]\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullForm", "MR"],
  " shows the structure of the expression that was constructed. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.17"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Implies[
          And[ForAll[x, Exists[y, Succeeds[CircleTimes[x, y], y]]], 
            Unequal[m, 0]], NotRightTriangleBar[n, m]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[6]//FullForm= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell["\<\
Note that the first and second forms here are identical; the third \
requires explicit parentheses. \
\>", "MathCaption",
  CellTags->{"S2.9.14", "14.18"}],

Cell[CellGroupData[{

Cell["{x -> #^2 &, (x -> #^2)&, x -> (#^2 &)}", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \({x \[Rule] #1\^2 &, x \[Rule] #1\^2 &, 
      x \[Rule] \((#1\^2 &)\)}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["flat "], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["+", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]]},
          {Cell["left grouping "], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["(", "MR"],
              StyleBox["x", "TI"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[")", "MR"],
              " ",
              StyleBox["/", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]]},
          {Cell["right grouping "], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["z", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["(", "MR"],
              StyleBox["y", "TI"],
              " ",
              StyleBox["^", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox[")", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.14"],

Cell["Types of grouping for infix operators. ", "Caption",
  CellTags->"S2.9.14"],

Cell[TextData[{
  StyleBox["Plus", "MR"],
  " is a ",
  StyleBox["Flat", "MR"],
  " function, so no grouping is necessary here. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.19"}],

Cell[CellGroupData[{

Cell["FullForm[a + b + c + d]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Plus[a, b, c, d]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[8]//FullForm= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Power", "MR"],
  " is not ",
  StyleBox["Flat", "MR"],
  ", so the operands have to be grouped in pairs. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.20"}],

Cell[CellGroupData[{

Cell["FullForm[a ^ b ^ c ^ d]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Power[a, Power[b, Power[c, d]]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[9]//FullForm= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "The syntax of the ",
  StyleBox["Mathematica", "TI"],
  " language is defined not only for characters that you can type on a \
typical keyboard, but also for all the various special characters that ",
  StyleBox["Mathematica", "TI"],
  " supports. "
}], "Text",
  CellTags->{"S2.9.14", "14.21"}],

Cell[TextData[{
  "Letters such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[ScriptCapitalL]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Aleph]\)], "InlineFormula"],
  " from any alphabet are treated just like ordinary English letters, and can \
for example appear in the names of symbols. The same is true of letter\
\[Hyphen]like forms such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[Infinity]\)], "InlineFormula"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[HBar]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Angle]\)], "InlineFormula"],
  ". "
}], "Text",
  CellTags->{"S2.9.14", "14.22"}],

Cell[TextData[{
  "But many other special characters are treated as operators. Thus, for \
example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[UnionPlus]\)], "InlineFormula"],
  " are infix operators, while ",
  Cell[BoxData[
      \(TraditionalForm\`\[Not] \)], "InlineFormula"],
  " is a prefix operator, and ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[RightAngleBracket]\)], "InlineFormula"],
  " are matchfix operators.  "
}], "Text",
  CellTags->{"S2.9.14", "14.23"}],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " is an infix operator. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.24"}],

Cell[CellGroupData[{

Cell["a \[CirclePlus] b \[CirclePlus] c // FullForm", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    TagBox[
      StyleBox[\(CirclePlus[a, b, c]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[10]//FullForm= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Times]\)], "InlineFormula"],
  " is an infix operator which means the same as ",
  StyleBox["*", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.25"}],

Cell[CellGroupData[{

Cell["a \[Times] a \[Times] a \[Times] b \[Times] b \[Times] c", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(a\^3\ b\^2\ c\)], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "Some special characters form elements of fairly complicated compound \
operators. Thus, for example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  "\[ThinSpace]",
  StyleBox["f", "TI"],
  "\[ThinSpace]",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  "\[ThinSpace]",
  StyleBox["x", "TI"],
  " contains the compound operator with elements ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  ".  "
}], "Text",
  CellTags->{"S2.9.14", "14.26"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " form parts of a compound operator. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.27"}],

Cell[CellGroupData[{

Cell["\[Integral] k[x] \[DifferentialD]x // FullForm", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Integrate[k[x], x]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[12]//FullForm= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "No parentheses are needed here: the \[OpenCurlyDoubleQuote]inner \
precedence\[CloseCurlyDoubleQuote] of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\)], "InlineFormula"],
  " ",
  "\[Ellipsis]",
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\)], "InlineFormula"],
  " is lower than ",
  StyleBox["Times", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.28"}],

Cell[CellGroupData[{

Cell["\[Integral] a[x] b[x] \[DifferentialD]x + c[x]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(c[x] + \[Integral]\(a[x]\ b[x]\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell["Parentheses are needed here, however. ", "MathCaption",
  CellTags->{"S2.9.14", "14.29"}],

Cell[CellGroupData[{

Cell["\[Integral] (a[x] + b[x]) \[DifferentialD]x + c[x]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(c[x] + \[Integral]\((a[x] + b[x])\) \[DifferentialD]x\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "Input to ",
  StyleBox["Mathematica", "TI"],
  " can be given not only in the form of one\[Hyphen]dimensional strings, but \
also in the form of two\[Hyphen]dimensional boxes. The syntax of the ",
  StyleBox["Mathematica", "TI"],
  " language covers not only one\[Hyphen]dimensional constructs but also two\
\[Hyphen]dimensional ones.   "
}], "Text",
  CellTags->{"S2.9.14", "14.30"}],

Cell["This superscript is interpreted as a power. ", "MathCaption",
  CellTags->{"S2.9.14", "14.31"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^\(a + b\)\)], "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(x\^\(a + b\)\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      RowBox[{
        SubscriptBox["\[PartialD]", 
          StyleBox["x",
            "TI"]], 
        StyleBox["f",
          "TI"]}]], "InlineFormula"],
  " is a two\[Hyphen]dimensional compound operator. "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.32"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x x\^n\)], "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(n\ x\^\(\(-1\) + n\)\)], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
  " is part of a more complicated two\[Hyphen]dimensional compound operator. \
"
}], "MathCaption",
  CellTags->{"S2.9.14", "14.33"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Sum]\+\(n = 1\)\%\[Infinity] 1\/n\^s\)], "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(Zeta[s]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.9.14"]
}, Open  ]],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\)], "InlineFormula"],
  " operator has higher precedence than ",
  StyleBox["+", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.14", "14.34"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Sum]\+\(n = 1\)\%\[Infinity] 1\/n\^s + n\)], "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.14"],

Cell[BoxData[
    \(n + Zeta[s]\)], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.9.14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.9.15 Operators without Built\[Hyphen]in Meanings\
\>", \
"Subsection",
  CellTags->{"S2.9.15", "15.1"}],

Cell[TextData[{
  "When you enter a piece of input such as ",
  StyleBox["2", "MR"],
  " ",
  StyleBox["+", "MR"],
  " ",
  StyleBox["2", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " first recognizes the ",
  StyleBox["+", "MR"],
  " as an operator and constructs the expression ",
  StyleBox["Plus[2,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  ", then uses the built\[Hyphen]in rules for ",
  StyleBox["Plus", "MR"],
  " to evaluate the expression and get the result ",
  StyleBox["4", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.15", "15.2"}],

Cell[TextData[{
  "But not all operators recognized by ",
  StyleBox["Mathematica", "TI"],
  " are associated with functions that have built\[Hyphen]in meanings. ",
  StyleBox["Mathematica", "TI"],
  " also supports several hundred additional operators that can be used in \
constructing expressions, but for which no evaluation rules are initially \
defined. "
}], "Text",
  CellTags->{"S2.9.15", "15.3"}],

Cell[TextData[{
  "You can use these operators as a way to build up your own notation within \
the ",
  StyleBox["Mathematica", "TI"],
  " language. "
}], "Text",
  CellTags->{"S2.9.15", "15.4"}],

Cell[TextData[{
  "The ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " is recognized as an infix operator, but has no predefined value. "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\[CirclePlus]3 // FullForm\)], "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.15"],

Cell[BoxData[
    TagBox[
      StyleBox[\(CirclePlus[2, 3]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[TextData[{
  "In ",
  StyleBox["StandardForm", "MR"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " prints as an infix operator. "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\[CirclePlus]3\)], "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.15"],

Cell[BoxData[
    \(2\[CirclePlus]3\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[TextData[{
  "You can define a value for ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.7"}],

Cell["x_ \[CirclePlus] y_ := Mod[x + y, 2]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.15"],

Cell[TextData[{
  "Now ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " is not only recognized as an operator, but can also be evaluated. "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.8"}],

Cell[CellGroupData[{

Cell["2 \[CirclePlus] 3", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.15"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["CirclePlus[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[TildeTilde] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["TildeTilde[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[Therefore] \)], "InlineFormula"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Therefore[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              Cell[BoxData[
                  \(TraditionalForm\` \[LeftRightArrow] \)], "InlineFormula"],
              
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["LeftRightArrow[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Del]\)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Del[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[Square]\)], "InlineFormula"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["Square[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              Cell[BoxData[
                  \(TraditionalForm\`\[LeftAngleBracket]\)], "InlineFormula"],
              
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              Cell[BoxData[
                  \(TraditionalForm\`\[RightAngleBracket]\)], 
                "InlineFormula"],
              " "
            }]], Cell[TextData[{
              StyleBox["AngleBracket[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.15"],

Cell[TextData[{
  "A few ",
  StyleBox["Mathematica", "SO"],
  " operators corresponding to functions without predefined values. "
}], "Caption",
  CellTags->"S2.9.15"],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " follows the general convention that the function associated with a \
particular operator should have the same name as the special character that \
represents that operator.   "
}], "Text",
  CellTags->{"S2.9.15", "15.9"}],

Cell[TextData[{
  "\[Backslash]",
  StyleBox["[Congruent]", "MR"],
  " is displayed as ",
  Cell[BoxData[
      \(TraditionalForm\` \[Congruent] \)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.10"}],

Cell[CellGroupData[{

Cell["x \\[Congruent] y", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.15"],

Cell[BoxData[
    \(x \[Congruent] y\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[TextData[{
  "It corresponds to the function ",
  StyleBox["Congruent", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.11"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.15"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Congruent[x, y]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[6]//FullForm= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["x", "TI"],
              " ",
              StyleBox["\[Backslash][", "MR"],
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["y", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[", "MR"],
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]], Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              "\[Backslash]",
              StyleBox["[Left", "MR"],
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["\[Backslash][Right", "MR"],
              StyleBox["name", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["name", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.15"],

Cell[TextData[{
  "The conventional correspondence in ",
  StyleBox["Mathematica", "SO"],
  " between operator names and function names. "
}], "Caption",
  CellTags->"S2.9.15"],

Cell[TextData[{
  "You should realize that even though the functions ",
  StyleBox["CirclePlus", "MR"],
  " and ",
  StyleBox["CircleTimes", "MR"],
  " do not have built\[Hyphen]in evaluation rules, the operators ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
  " do have built\[Hyphen]in precedences. Section\[NonBreakingSpace]",
  ButtonBox["A.2.7",
    ButtonData:>{"A.2.7", "7.3"},
    ButtonStyle->"MainBookLink"],
  " lists all the operators recognized by ",
  StyleBox["Mathematica", "TI"],
  ", in order of their precedence. "
}], "Text",
  CellTags->{"S2.9.15", "15.12"}],

Cell[TextData[{
  "The operators ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " have definite precedences\[LongDash]with ",
  Cell[BoxData[
      \(TraditionalForm\`\[CircleTimes]\)], "InlineFormula"],
  " higher than ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.13"}],

Cell[CellGroupData[{

Cell["x \[CircleTimes] y \[CirclePlus] z // FullForm", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.15"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Mod[Plus[z, CircleTimes[x, y]], 2]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[7]//FullForm= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Subscript[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], "+"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SubPlus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], "-"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SubMinus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SubscriptBox[
                                StyleBox["x",
                                  "TI"], "*"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SubStar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "+"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperPlus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "-"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperMinus[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "*"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperStar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              SuperscriptBox[
                                StyleBox["x",
                                  "TI"], "\[Dagger]"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["SuperDagger[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]], 
            Cell[TextData[Cell[BoxData[
                FormBox[GridBox[{
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Overscript[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              UnderscriptBox[
                                StyleBox["x",
                                  "TI"], 
                                StyleBox["y",
                                  "TI"]]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["Underscript[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox[",", "MR"],
                          " ",
                          StyleBox["y", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "_"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverBar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "\[RightVector]"]], "InlineFormula"],
                          
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverVector[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "~"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverTilde[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "^"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverHat[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              OverscriptBox[
                                StyleBox["x",
                                  "TI"], "."]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["OverDot[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]},
                      {Cell[TextData[{
                          Cell[BoxData[
                              UnderscriptBox[
                                StyleBox["x",
                                  "TI"], "_"]], "InlineFormula"],
                          " "
                        }]], Cell[TextData[{
                          StyleBox["UnderBar[", "MR"],
                          StyleBox["x", "TI"],
                          StyleBox["]", "MR"],
                          " "
                        }]]}
                      },
                    ColumnAlignments->{Right, Left}], TraditionalForm]]]]]}
          },
        RowAlignments->Top,
        ColumnAlignments->{Center}], TraditionalForm]], "DoubleBox",
  CellFrame->0.5,
  CellTags->"S2.9.15"],

Cell["\<\
Some two\[Hyphen]dimensional forms without built\[Hyphen]in \
meanings. \
\>", "Caption",
  CellTags->"S2.9.15"],

Cell[TextData[{
  "Subscripts have no built\[Hyphen]in meaning in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.14"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\_2 + y\_2 // InputForm\)], "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.15"],

Cell["Subscript[x, 2] + Subscript[y, 2]", "Output",
  CellLabel->"Out[8]//InputForm= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell["\<\
Most superscripts are however interpreted as powers by default. \
\
\>", "MathCaption",
  CellTags->{"S2.9.15", "15.15"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 + y\^2 // InputForm\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.15"],

Cell["x^2 + y^2", "Output",
  CellLabel->"Out[9]//InputForm= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell["A few special superscripts are not interpreted as powers. ", \
"MathCaption",
  CellTags->{"S2.9.15", "15.16"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^\[Dagger] + \(y\^+\) // InputForm\)], "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.15"],

Cell["SuperDagger[x] + SuperPlus[y]", "Output",
  CellLabel->"Out[10]//InputForm= ",
  CellTags->"S2.9.15"]
}, Open  ]],

Cell[TextData[{
  "Bar and hat are interpreted as ",
  StyleBox["OverBar", "MR"],
  " and ",
  StyleBox["OverHat", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.15", "15.17"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\&_ + \(y\&^\) // InputForm\)], "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.15"],

Cell["OverBar[x] + OverHat[y]", "Output",
  CellLabel->"Out[11]//InputForm= ",
  CellTags->"S2.9.15"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.16 Defining Output Formats", "Subsection",
  CellTags->{"S2.9.16", "16.1"}],

Cell[TextData[{
  "Just as ",
  StyleBox["Mathematica", "TI"],
  " allows you to define how expressions should be evaluated, so also it \
allows you to define how expressions should be formatted for output. The \
basic idea is that whenever ",
  StyleBox["Mathematica", "TI"],
  " is given an expression to format for output, it first calls ",
  StyleBox["Format[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " to find out whether any special rules for formatting the expression have \
been defined. By assigning a value to ",
  StyleBox["Format[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " you can therefore tell ",
  StyleBox["Mathematica", "TI"],
  " that you want a particular kind of expression to be output in a special \
way. "
}], "Text",
  CellTags->{"S2.9.16", "16.2"}],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to format ",
  StyleBox["bin", "MR"],
  " objects in a special way. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.3"}],

Cell["Format[bin[x_, y_]] := MatrixForm[{{x}, {y}}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.16"],

Cell[TextData[{
  "Now ",
  StyleBox["bin", "MR"],
  " objects are output to look like binomial coefficients. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.4"}],

Cell[CellGroupData[{

Cell["bin[i + j, k]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(i + j\)},
            {"k"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[TextData[{
  "Internally, however, ",
  StyleBox["bin", "MR"],
  " objects are still exactly the same. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.5"}],

Cell[CellGroupData[{

Cell["FullForm[%]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    TagBox[
      StyleBox[\(bin[Plus[i, j], k]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[3]//FullForm= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Format[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[TextData[{
              "define ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              " to be formatted like ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Format[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " ",
              StyleBox[":=", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              " "
            }]], Cell[
            "give a definition only for a particular output form "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.16"],

Cell["Defining your own rules for formatting. ", "Caption",
  CellTags->"S2.9.16"],

Cell[TextData[{
  "By making definitions for ",
  StyleBox["Format", "MR"],
  ", you can tell ",
  StyleBox["Mathematica", "TI"],
  " to format a particular expression so as to look like another expression. \
You can also tell ",
  StyleBox["Mathematica", "TI"],
  " to run a program to determine how a particular expression should be \
formatted. "
}], "Text",
  CellTags->{"S2.9.16", "16.6"}],

Cell[TextData[{
  "This specifies that ",
  StyleBox["Mathematica", "TI"],
  " should run a simple program to determine how ",
  StyleBox["xrep", "MR"],
  " objects should be formatted."
}], "MathCaption",
  CellTags->{"S2.9.16", "16.7"}],

Cell["Format[xrep[n_]] := StringJoin[Table[\"x\", {n}]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.16"],

Cell[TextData[{
  "The strings are created when each ",
  StyleBox["xrep", "MR"],
  " is formatted. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.8"}],

Cell[CellGroupData[{

Cell["xrep[1] + xrep[4] + xrep[9]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    \("x" + "xxxx" + "xxxxxxxxx"\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[TextData[{
  "Internally however the expression still contains ",
  StyleBox["xrep", "MR"],
  " objects. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.9"}],

Cell[CellGroupData[{

Cell["% /. xrep[n_] -> x^n", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    \(x + x\^4 + x\^9\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Prefix[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "prefix form ",
              StyleBox["h", "TI"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Postfix[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["],", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "postfix form ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["h", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Infix[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["],", "MR"],
              " ",
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "infix form ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["h", "TI"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["h", "TI"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Prefix[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "standard prefix form ",
              StyleBox["f", "TI"],
              " ",
              StyleBox["@", "MR"],
              " ",
              StyleBox["x", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Postfix[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "standard postfix form ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["//", "MR"],
              " ",
              StyleBox["f", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Infix[", "MR"],
              StyleBox["f", "TI"],
              StyleBox["[", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]]", "MR"],
              " "
            }]], Cell[TextData[{
              "standard infix form ",
              StyleBox["x", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["f", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["y", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              StyleBox["f", "TI"],
              " ",
              StyleBox["~", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PrecedenceForm[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "an object to be parenthesized with a precedence level ",
              StyleBox["n", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.16"],

Cell["Output forms for operators. ", "Caption",
  CellTags->"S2.9.16"],

Cell[TextData[{
  "This prints with ",
  StyleBox["f", "MR"],
  " represented by the \[OpenCurlyDoubleQuote]prefix operator\
\[CloseCurlyDoubleQuote] ",
  StyleBox["<>", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.10"}],

Cell[CellGroupData[{

Cell["Prefix[f[x], \"<>\"]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    InterpretationBox[\(\(<>\)\(x\)\),
      Prefix[ 
        f[ x], "<>"],
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[TextData[{
  "Here is output with the \[OpenCurlyDoubleQuote]infix operator\
\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      \(TraditionalForm\` \[Precedes] \)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\` \[Succeeds] \)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.11"}],

Cell[CellGroupData[{

Cell["s = Infix[{a, b, c}, \"\[Precedes]\[Succeeds]\"]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    InterpretationBox[\(a "\[Precedes]\[Succeeds]" b "\[Precedes]\[Succeeds]" 
        c\),
      Infix[ {a, b, c}, "\[Precedes]\[Succeeds]"],
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[TextData[{
  "By default, the \[OpenCurlyDoubleQuote]infix operator\
\[CloseCurlyDoubleQuote] ",
  Cell[BoxData[
      \(TraditionalForm\` \[Precedes] \)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\` \[Succeeds] \)], "InlineFormula"],
  " is assumed to have \[OpenCurlyDoubleQuote]higher precedence\
\[CloseCurlyDoubleQuote] than ",
  StyleBox["^", "MR"],
  ", so no parentheses are inserted. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.12"}],

Cell[CellGroupData[{

Cell["s^2", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    SuperscriptBox[
      RowBox[{"(", 
        InterpretationBox[\(a "\[Precedes]\[Succeeds]" b 
            "\[Precedes]\[Succeeds]" c\),
          Infix[ {a, b, c}, "\[Precedes]\[Succeeds]"],
          Editable->False], ")"}], "2"]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[TextData[{
  "When you have an output form involving operators, the question arises of \
whether the arguments of some of them should be parenthesized. As discussed \
in Section ",
  ButtonBox["2.1.3",
    ButtonData:>{"2.1.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  ", this depends on the \[OpenCurlyDoubleQuote]precedence\
\[CloseCurlyDoubleQuote] of the operators. When you set up output forms \
involving operators, you can use ",
  StyleBox["PrecedenceForm", "MR"],
  " to specify the precedence to assign to each operator. ",
  StyleBox["Mathematica", "TI"],
  " uses integers from 1 to 1000 to represent \
\[OpenCurlyDoubleQuote]precedence levels\[CloseCurlyDoubleQuote]. The higher \
the precedence level for an operator, the less it needs to be parenthesized.  \
"
}], "Text",
  CellTags->{"S2.9.16", "16.13"}],

Cell[TextData[{
  "Here ",
  Cell[BoxData[
      \(TraditionalForm\` \[Precedes] \)], "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\` \[Succeeds] \)], "InlineFormula"],
  " is treated as an operator with precedence ",
  StyleBox["100", "MR"],
  ". This precedence turns out to be low enough that parentheses are \
inserted.  "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.14"}],

Cell[CellGroupData[{

Cell["PrecedenceForm[s, 100]^2", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.16"],

Cell[BoxData[
    SuperscriptBox[
      RowBox[{"(", 
        TagBox[
          
          InterpretationBox[\(a "\[Precedes]\[Succeeds]" b 
              "\[Precedes]\[Succeeds]" c\),
            Infix[ {a, b, c}, "\[Precedes]\[Succeeds]"],
            Editable->False],
          (PrecedenceForm[ #, 100]&)], ")"}], "2"]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.9.16"]
}, Open  ]],

Cell[TextData[{
  "When you make an assignment for ",
  StyleBox["Format[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  ", you are defining the output format for ",
  StyleBox["expr", "TI"],
  " in all standard types of ",
  StyleBox["Mathematica", "TI"],
  " output. By making definitions for ",
  StyleBox["Format[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["form", "TI"],
  StyleBox["]", "MR"],
  ", you can specify formats to be used in specific output forms.  "
}], "Text",
  CellTags->{"S2.9.16", "16.15"}],

Cell[TextData[{
  "This specifies the ",
  StyleBox["TeXForm", "MR"],
  " for the symbol ",
  StyleBox["x", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.16"}],

Cell["Format[x, TeXForm] := \"{\\\\bf x}\"", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.16"],

Cell[TextData[{
  "The output format for ",
  StyleBox["x", "MR"],
  " that you specified is now used whenever the TeX form is needed. "
}], "MathCaption",
  CellTags->{"S2.9.16", "16.17"}],

Cell[CellGroupData[{

Cell["TeXForm[1 + x^2]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.16"],

Cell["x^2+1", "Output",
  CellLabel->"Out[12]//TeXForm= ",
  CellTags->"S2.9.16"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.9.17 Advanced Topic: Low\[Hyphen]Level Input and Output \
Rules\
\>", "Subsection",
  CellTags->{"S2.9.17", "17.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["MakeBoxes[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "construct boxes to represent ",
              StyleBox["expr", "TI"],
              " in the specified form "
            }]]},
          {Cell[TextData[{
              StyleBox["MakeExpression[", "MR"],
              StyleBox["boxes", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["form", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "construct an expression corresponding to ",
              StyleBox["boxes", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.17"],

Cell["\<\
Low\[Hyphen]level functions for converting between expressions and \
boxes. \
\>", "Caption",
  CellTags->"S2.9.17"],

Cell[TextData[{
  StyleBox["MakeBoxes", "MR"],
  " generates boxes without evaluating its input. "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.2"}],

Cell[CellGroupData[{

Cell["MakeBoxes[2 + 2, StandardForm]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    \(RowBox[{"2", "+", "2"}]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  StyleBox["MakeExpression", "MR"],
  " interprets boxes but uses ",
  StyleBox["HoldComplete", "MR"],
  " to prevent the resulting expression from being evaluated. "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.3"}],

Cell[CellGroupData[{

Cell["MakeExpression[%, StandardForm]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    \(HoldComplete[2 + 2]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  "Built into ",
  StyleBox["Mathematica", "TI"],
  " are a large number of rules for generating output and interpreting input. \
Particularly in ",
  StyleBox["StandardForm", "MR"],
  ", these rules are carefully set up to be consistent, and to allow input \
and output to be used interchangeably. "
}], "Text",
  CellTags->{"S2.9.17", "17.4"}],

Cell[TextData[{
  "It is fairly rare that you will need to modify these rules. The main \
reason is that ",
  StyleBox["Mathematica", "TI"],
  " already has built\[Hyphen]in rules for the input and output of many \
operators to which it does not itself assign specific meanings. "
}], "Text",
  CellTags->{"S2.9.17", "17.5"}],

Cell[TextData[{
  "Thus, if you want to add, for example, a generalized form of addition, you \
can usually just use an operator like ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " for which ",
  StyleBox["Mathematica", "TI"],
  " already has built\[Hyphen]in input and output rules. "
}], "Text",
  CellTags->{"S2.9.17", "17.6"}],

Cell[TextData[{
  "This outputs using the ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " operator. "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.7"}],

Cell[CellGroupData[{

Cell["CirclePlus[u, v, w]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    \(u\[CirclePlus]v\[CirclePlus]w\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " understands ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " on input. "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.8"}],

Cell[CellGroupData[{

Cell["u \[CirclePlus] v \[CirclePlus] w // FullForm", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    TagBox[
      StyleBox[\(CirclePlus[u, v, w]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[4]//FullForm= ",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  "In dealing with output, you can make definitions for ",
  StyleBox["Format[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " to change the way that a particular expression will be formatted. You \
should realize, however, that as soon as you do this, there is no guarantee \
that the output form of your expression will be interpreted correctly if it \
is given as ",
  StyleBox["Mathematica", "TI"],
  " input. "
}], "Text",
  CellTags->{"S2.9.17", "17.9"}],

Cell[TextData[{
  "If you want to, ",
  StyleBox["Mathematica", "TI"],
  " allows you to redefine the basic rules that it uses for the input and \
output of all expressions. You can do this by making definitions for ",
  StyleBox["MakeBoxes", "MR"],
  " and ",
  StyleBox["MakeExpression", "MR"],
  ". You should realize, however, that unless you make such definitions with \
great care, you are likely to end up with inconsistent results. "
}], "Text",
  CellTags->{"S2.9.17", "17.10"}],

Cell[TextData[{
  "This defines how ",
  StyleBox["gplus", "MR"],
  " objects should be output in ",
  StyleBox["StandardForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.11"}],

Cell["\<\
gplus /: MakeBoxes[gplus[x_, y_, n_], StandardForm] := RowBox[ \
{MakeBoxes[x, StandardForm], SubscriptBox[\"\\[CirclePlus]\", MakeBoxes[n, \
StandardForm]], MakeBoxes[y, StandardForm]} ]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.17"],

Cell[TextData[{
  StyleBox["gplus", "MR"],
  " is now output using a subscripted ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.12"}],

Cell[CellGroupData[{

Cell["gplus[a, b, m+n]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    \(a\(\[CirclePlus]\_\(m + n\)\)b\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " cannot however interpret this as input. "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.13"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\(\[CirclePlus]\_\(m + n\)\)b\)], "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    \(Syntax::"sntxi" \(\(:\)\(\ \)\) 
      "Incomplete expression; more input is needed.\!\(\"\"\)"\)], "Message",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to interpret a subscripted ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " as a specific piece of ",
  StyleBox["FullForm", "MR"],
  " input. "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.14"}],

Cell["\<\
MakeExpression[RowBox[{x_, SubscriptBox[ \"\\[CirclePlus]\", n_], \
y_}], StandardForm] := MakeExpression[RowBox[ {\"gplus\", \"[\", x, \",\", y, \
\",\", n, \"]\"}], StandardForm]\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.17"],

Cell[TextData[{
  "Now the subscripted ",
  Cell[BoxData[
      \(TraditionalForm\`\[CirclePlus]\)], "InlineFormula"],
  " is interpreted as a ",
  StyleBox["gplus", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.17", "17.15"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(a\(\[CirclePlus]\_\(m + n\)\)b // FullForm\)], "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.17"],

Cell[BoxData[
    TagBox[
      StyleBox[\(gplus[a, b, Plus[m, n]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[8]//FullForm= ",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[TextData[{
  "When you give definitions for ",
  StyleBox["MakeBoxes", "MR"],
  ", you can think of this as essentially a lower\[Hyphen]level version of \
giving definitions for ",
  StyleBox["Format", "MR"],
  ". An important difference is that ",
  StyleBox["MakeBoxes", "MR"],
  " does not evaluate its argument, so you can define rules for formatting \
expressions without being concerned about how these expressions would \
evaluate. "
}], "Text",
  CellTags->{"S2.9.17", "17.16"}],

Cell[TextData[{
  "In addition, while ",
  StyleBox["Format", "MR"],
  " is automatically called again on any results obtained by applying it, the \
same is not true of ",
  StyleBox["MakeBoxes", "MR"],
  ". This means that in giving definitions for ",
  StyleBox["MakeBoxes", "MR"],
  " you explicitly have to call ",
  StyleBox["MakeBoxes", "MR"],
  " again on any subexpressions that still need to be formatted. "
}], "Text",
  CellTags->{"S2.9.17", "17.17"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["\[FilledSmallSquare] Break input into tokens. "]},
          {Cell["\[FilledSmallSquare] Strip spacing characters. "]},
          {
            Cell["\<\
\[FilledSmallSquare] Construct boxes using built\
\[Hyphen]in operator precedences. \
\>"]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Strip ",
              StyleBox["StyleBox", "MR"],
              " and other boxes not intended for interpretation. "
            }]]},
          {Cell[TextData[{
              "\[FilledSmallSquare] Apply rules defined for ",
              StyleBox["MakeExpression", "MR"],
              ". "
            }]]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "FramedBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.17"],

Cell[TextData[{
  "Operations done on ",
  StyleBox["Mathematica", "SO"],
  " input. "
}], "Caption",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.18 Generating Unstructured Output", "Subsection",
  CellTags->{"S2.9.18", "18.1"}],

Cell[TextData[{
  "The functions described so far in this section determine ",
  StyleBox["how", "TI"],
  " expressions should be formatted when they are printed, but they do not \
actually cause anything to be printed. "
}], "Text",
  CellTags->{"S2.9.18", "18.2"}],

Cell[TextData[{
  "In the most common way of using ",
  StyleBox["Mathematica", "TI"],
  " you never in fact explicitly have to issue a command to generate output. \
Usually, ",
  StyleBox["Mathematica", "TI"],
  " automatically prints out the final result that it gets from processing \
input you gave. Sometimes, however, you may want to get ",
  StyleBox["Mathematica", "TI"],
  " to print out expressions at intermediate stages in its operation. You can \
do this using the function ",
  StyleBox["Print", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.18", "18.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Print[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              
              ", with no spaces in between, but with a newline (line feed) at \
the end "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.18"],

Cell["Printing expressions. ", "Caption",
  CellTags->"S2.9.18"],

Cell[TextData[{
  StyleBox["Print", "MR"],
  " prints its arguments, with no spaces in between, but with a newline (line \
feed) at the end. "
}], "MathCaption",
  CellTags->{"S2.9.18", "18.4"}],

Cell[CellGroupData[{

Cell["Print[a, b]; Print[c]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[\(a\[InvisibleSpace]b\),
      SequenceForm[ a, b],
      Editable->False]], "Print",
  CellTags->"S2.9.18"],

Cell[BoxData[
    \(c\)], "Print",
  CellTags->"S2.9.18"]
}, Open  ]],

Cell["\<\
This prints a table of the first five integers and their squares. \
\
\>", "MathCaption",
  CellTags->{"S2.9.18", "18.5"}],

Cell[CellGroupData[{

Cell["Do[Print[i, \" \", i^2], {i, 5}]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]"  "\[InvisibleSpace]1\),
      SequenceForm[ 1, "  ", 1],
      Editable->False]], "Print",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]"  "\[InvisibleSpace]4\),
      SequenceForm[ 2, "  ", 4],
      Editable->False]], "Print",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]"  "\[InvisibleSpace]9\),
      SequenceForm[ 3, "  ", 9],
      Editable->False]], "Print",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]"  "\[InvisibleSpace]16\),
      SequenceForm[ 4, "  ", 16],
      Editable->False]], "Print",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[\(5\[InvisibleSpace]"  "\[InvisibleSpace]25\),
      SequenceForm[ 5, "  ", 25],
      Editable->False]], "Print",
  CellTags->"S2.9.18"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Print", "MR"],
  " simply takes the arguments you give, and prints them out one after the \
other, with no spaces in between. In many cases, you will need to print \
output in a more complicated format. You can do this by giving an output form \
as an argument to ",
  StyleBox["Print", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.9.18", "18.6"}],

Cell["This prints the matrix in the form of a table. ", "MathCaption",
  CellTags->{"S2.9.18", "18.7"}],

Cell[CellGroupData[{

Cell["Print[TableForm[{{1, 2}, {3, 4}}]]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.18"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2"},
          {"3", "4"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Print",
  CellTags->"S2.9.18"]
}, Open  ]],

Cell[TextData[{
  "Here the output format is specified using ",
  StyleBox["StringForm", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.18", "18.8"}],

Cell[CellGroupData[{

Cell["Print[StringForm[\"x = ``, y = ``\", a^2, b^2]]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox["\<\"x = \\!\\(a\\^2\\), y = \\!\\(b\\^2\\)\"\>",
      StringForm[ "x = ``, y = ``", 
        Power[ a, 2], 
        Power[ b, 2]],
      Editable->False]], "Print",
  CellTags->"S2.9.18"]
}, Open  ]],

Cell[TextData[{
  "The output generated by ",
  StyleBox["Print", "MR"],
  " is usually given in the standard ",
  StyleBox["Mathematica", "TI"],
  " output format. You can however explicitly specify that some other output \
format should be used. "
}], "Text",
  CellTags->{"S2.9.18", "18.9"}],

Cell[TextData[{
  "This prints output in ",
  StyleBox["Mathematica", "TI"],
  " input form. "
}], "MathCaption",
  CellTags->{"S2.9.18", "18.10"}],

Cell[CellGroupData[{

Cell["Print[InputForm[a^2 + b^2]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.18"],

Cell[BoxData[
    InterpretationBox[
      StyleBox[\(a^2\  + \ b^2\),
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Plus[ 
          Power[ a, 2], 
          Power[ b, 2]]],
      Editable->True,
      AutoDelete->True]], "Print",
  CellTags->"S2.9.18"]
}, Open  ]],

Cell[TextData[{
  "You should realize that ",
  StyleBox["Print", "MR"],
  " is only one of several mechanisms available in ",
  StyleBox["Mathematica", "TI"],
  " for generating output. Another is the function ",
  StyleBox["Message", "MR"],
  " described in Section ",
  ButtonBox["2.9.21",
    ButtonData:>{"2.9.21", "21.1"},
    ButtonStyle->"MainBookLink"],
  ", used for generating named messages. There are also a variety of lower\
\[Hyphen]level functions described in Section ",
  ButtonBox["2.12.3",
    ButtonData:>{"2.12.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " which allow you to produce output in various formats both as part of an \
interactive session, and for files and external programs. "
}], "Text",
  CellTags->{"S2.9.18", "18.11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.19 Generating Styled Output in Notebooks", "Subsection",
  CellTags->{"S2.9.19", "19.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["StylePrint[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["style", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell[TextData[{
              "create a new cell containing ",
              StyleBox["expr", "TI"],
              " in the specified style "
            }]]},
          {Cell[TextData[{
              StyleBox["StylePrint[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["use the default style for the notebook "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.19"],

Cell["Generating styled output in notebooks. ", "Caption",
  CellTags->"S2.9.19"],

Cell["This generates a cell in section heading style. ", "MathCaption",
  CellTags->{"S2.9.19", "19.2"}],

Cell[CellGroupData[{

Cell["StylePrint[\"The heading\", \"Section\"];", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.19"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000>B000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo00000`3oool0<c<c03<c<`3o03<c<ol0<c<c200c<c<10?ooo`0000<0oooo0>GUi@0c
<c<0o`0c<c?o03<c<`P0<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c
0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`3UiNGo0>GU
i@40iNGU0`2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`04
0>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0
ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080
VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0
iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VI
V@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooob0?ooo`D0
003o1P3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<co`3oooof0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?oo
o`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<fP0oooo1000003o0?ooohX0oooo00<0003o0?ooo`3o
ool0103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80
<c<cI`3oool200000080oooo0P00003o0?ooohT0oooo00<0003o0?ooo`3oool0103oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<cK03oool200000?l0
ooooR03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool00003
0?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80
00000`3oool3000000P0oooo0P0000030?ooo`8000000`3oool3000000@0oooo1`0000020?ooo`D0
000000<0oooo0000000000000P3oool2000000<0oooo0P0000030?ooo`D00000o`3ooon80?ooo`03
0000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2I
VIT00P2IVIT203<c<`h0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000020?ooo`80
000000<0oooo0000000000001`3oool2000000<0oooo0P0000020?ooo`80000000<0oooo00000000
00000P3oool200000080oooo0`0000020?ooo`80000000D0oooo00000000000000000?ooo`020000
0080oooo0P0000030?ooo`8000000P3oool2000000040?ooo`000000000000000?l0ooooR03oool0
0`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0
VIVI0080VIVI0P0c<c<>0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo
0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo
0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooon8
0?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo
0>GUi@2IVIT00P2IVIT203<c<`h0oooo2@0000090?ooo`800000103oool2000000<0oooo0P000000
0`3oool000000000000;0?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P000003
0?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P000003
0?ooo`80000000<0oooo0000000000000`3oool200000?l0ooooR03oool00`000?l0oooo0?ooo`04
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>
0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo0000000000001@000006
0?ooo`8000000`3oool2000000030?ooo`000000000000D000000P3oool6000000030?ooo`000000
000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool2000000030?ooo`000000
000000<0oooo0P00003o0?ooohP0oooo00<0003o0?ooo`3oool0103oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c3P3oool9000000T0oooo0P000004
0?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000060?ooo`8000000`3oool2
000000030?ooo`000000000000<0oooo0P0000050?ooo`<0000000<0oooo0000000000000`3oool2
000000030?ooo`00000000000080oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2
00000?l0ooooR03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`T000002@3oool2000000@0oooo0P000003
0?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo
0000000000000`3oool2000000030?ooo`000000000000<0oooo0P0000000`3oool0000000000003
0?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000000`3oool0000000000003
0?ooo`800000o`3ooon80?ooo`030000o`3oool0oooo00@0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<`h0oooo2@0000090?ooo`800000103oool3
00000080oooo0P0000020?ooo`80000000<0oooo0000000000001`3oool300000080oooo0P000002
0?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`80000000D0oooo
00000000000000000?ooo`0200000080oooo0`0000020?ooo`8000000P3oool2000000040?ooo`00
0000000000000?l0ooooR03oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c<>0?ooo`T000002@3oool2000000@0oooo
1P0000040?ooo`<00000203oool6000000@0oooo0`0000040?ooo`D00000103oool5000000030?oo
o`00000000000080oooo1P0000040?ooo`D00000o`3ooon80?ooo`030000o`3oool0oooo00@0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<b00oooo
0P0000040?ooo`8000004`3oool2000001/0oooo0P00003o0?oooi`0oooo00<0003o0?ooo`3oool0
103oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
803oool2000000@0oooo0P00000C0?ooo`8000006`3oool200000?l0ooooV@3oool40000o`H0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ad0oooo
200000000`3oool000000000000C0?ooo`8000006`3oool2000000030?ooo`00000000000?l0oooo
V@3oool00`000?l0oooo0?ooo`040?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?oooo80oooo1@000?l60?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0
VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0oooo
o@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU09VIV@0209VIV@80<c<c
o`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVI
0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000<0oooo0>GUi@2IVIT0
0P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo00000`3oool0iNGU
09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000030?oo
o`3UiND0VIVI0080VIVI0P0c<c?o0?ooood0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`00
00<0oooo0>GUi@2IVIT00P2IVIT203<c<ol0ooooo@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo00000`3oool0iNGU09VIV@0209VIV@80<c<co`3oooom0?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0080VIVIo`0c<c?o03<c<`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3U
iND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT6
09VIV@80<c<c0@3oool000030?ooo`3UiND0VIVI0?l0VIVIo`2IVIT609VIV@80<c<c0@3oool00003
0?ooo`3UiND0iNGU0?l0iNGUo`3UiND70>GUi@40<c<c0@3oool00?l0ooooo`3oool<0?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 57},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.9.19"]
}, Open  ]],

Cell["This generates a cell in input style. ", "MathCaption",
  CellTags->{"S2.9.19", "19.3"}],

Cell[CellGroupData[{

Cell["StylePrint[x^2 + y^2, \"Input\"]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.19"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008:0000Db000`400?l00000o`00003oo`3ooooo
0?ooo``0oooo003o0?ooool0oooo303oool000030?ooo`0c<c<0<c<c0?l0<c<co`0c<c<803<c<`40
oooo00020>GUiOl0<c<co`0c<c<903<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2I
VIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3U
iND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo0>GU
iOl0iNGU0P3UiND309VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon0?oo
o`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooon
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c
o`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80
<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0
VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooon0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GU
i@2IVIT0VIVI09VIV@80<c<co`3oooo[0?ooo`D0003o0P3oool50000o`L0oooo00@0iNGU09VIV@2I
VIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooonl0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<cC@3oool400000?l0ooooWP3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU
09VIV@2IVIT0VIVI0P0c<c=>0?ooo`800000o`3ooonO0?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<c40oooo1P00000>0?ooo`030000003oool0oooo00L0oooo0P00003o0?oooih0oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80
<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c<P3oool4000000l0oooo00<000000?ooo`3o
ool01`3oool200000?l0ooooWP3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<c0?oo
o`8000003P3oool5000000H0oooo1000003o0?oooid0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI
09VIV@80<c<c<`3oool200000100oooo00<000000?ooo`3oool01P3oool400000?l0ooooW@3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c
<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<b0?ooo`@000003`3oool00`000000oooo0?oo
o`050?ooo`8000000P3oool200000?l0ooooW03oool00`000?l0oooo0?ooo`040?ooo`030000o`3o
ool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI
0P0c<c<a0?ooo`H000005@3oool800000?l0ooooV`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<h0?ooo`D000005`3oool500000?l0ooooUP3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c<i0?ooo`8000006P3oool200000?l0ooooV03oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<j0?ooo`8000006P3oool200000?l0ooooUP3oool20000o`H0oooo00<0003o
0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2I
VIT203<c<c/0oooo0P00000J0?ooo`800000o`3ooonD0?ooo`030000o`3oool0003o00H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<cP0oooo0P0000000`3oool000000000000G0?ooo`80000000<0oooo000000000000
o`3ooonC0?ooo`040000o`3oool0oooo0000o`H0oooo00<0003o0?ooo`3oool01@3oool0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<cT0oooo0`00000I0?oo
o`<00000o`3ooonC0?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
oooZ0?ooo`H0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c
0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0
oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI
09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`030000o`3oool0
oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c
<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooof0?ooo`03
0000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2I
VIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3o
ooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<co`3oooof0?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<1
0?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooooH0oooo00<0003o0?ooo`3oool01@3oool0
103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooomP3o
ool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2I
VIT0VIVI09VIV@80<c<co`3oooo[0?ooo`D0003o1P3oool00`000?l0oooo0?ooo`050?ooo`040>GU
i@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<co`3oooo_0?ooo`03
0000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<fH0oooo1000003o0?ooohD0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool0
00040>GUi@2IVIT0VIVI09VIV@80<c<cI@3oool200000080oooo0P00003o0?oooh@0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3o
ool000040>GUi@2IVIT0VIVI09VIV@80<c<cJP3oool200000?l0ooooP`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0
iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`800000
0`3oool3000000P0oooo0P0000030?ooo`8000000`3oool3000000@0oooo1`0000020?ooo`D00000
00<0oooo0000000000000P3oool2000000<0oooo0P0000030?ooo`D00000o`3ooon30?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000090?ooo`800000103oool2000000<0
oooo0P0000020?ooo`80000000<0oooo0000000000001`3oool2000000<0oooo0P0000020?ooo`80
000000<0oooo0000000000000P3oool200000080oooo0`0000020?ooo`80000000D0oooo00000000
000000000?ooo`0200000080oooo0P0000030?ooo`8000000P3oool2000000040?ooo`0000000000
00000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00@0iNGU
09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?ooo`T000002@3o
ool2000000@0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2000000H0oooo0P00
00030?ooo`80000000<0oooo0000000000000`3oool2000000030?ooo`000000000000<0oooo0P00
00000`3oool00000000000030?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P00
00000`3oool00000000000030?ooo`800000o`3ooon30?ooo`030000o`3oool0oooo00@0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<``0oooo2@0000090?ooo`800000103oool2000000<0oooo0P0000000`3oool00000
0000000;0?ooo`8000000`3oool2000000030?ooo`000000000000H0oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?ooo`800000
00<0oooo0000000000000`3oool200000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000
o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0
VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo00000000
00001@0000060?ooo`8000000`3oool2000000030?ooo`000000000000D000000P3oool600000003
0?ooo`000000000000<0oooo0P0000000`3oool00000000000020?ooo`8000000`3oool200000003
0?ooo`000000000000<0oooo0P00003o0?oooh<0oooo00<0003o0?ooo`3oool0103oool00`000?l0
oooo0?ooo`050?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VI
V@80<c<c303oool9000000T0oooo0P0000040?ooo`8000000`3oool2000000030?ooo`0000000000
00<0oooo0P0000060?ooo`8000000`3oool2000000030?ooo`000000000000<0oooo0P0000050?oo
o`<0000000<0oooo0000000000000`3oool2000000030?ooo`00000000000080oooo0P0000030?oo
o`80000000<0oooo0000000000000`3oool200000?l0ooooP`3oool00`000?l0oooo0?ooo`040?oo
o`030000o`3oool0oooo00D0oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VI
V@2IVIT0VIVI0P0c<c<<0?ooo`T000002@3oool2000000@0oooo0P0000030?ooo`80000000<0oooo
0000000000000`3oool2000000H0oooo0P0000030?ooo`80000000<0oooo0000000000000`3oool2
000000030?ooo`000000000000<0oooo0P0000000`3oool00000000000030?ooo`80000000<0oooo
0000000000000P3oool2000000<0oooo0P0000000`3oool00000000000030?ooo`800000o`3ooon3
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<``0oooo2@0000090?ooo`800000103o
ool300000080oooo0P0000020?ooo`80000000<0oooo0000000000001`3oool300000080oooo0P00
00020?ooo`80000000<0oooo0000000000000P3oool2000000<0oooo0P0000020?ooo`80000000D0
oooo00000000000000000?ooo`0200000080oooo0`0000020?ooo`8000000P3oool2000000040?oo
o`000000000000000?l0ooooP`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0
oooo00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c<<0?oo
o`T000002@3oool2000000@0oooo1P0000040?ooo`<00000203oool6000000@0oooo0`0000040?oo
o`D00000103oool5000000030?ooo`00000000000080oooo1P0000040?ooo`D00000o`3ooon30?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ah0oooo0P0000040?ooo`8000004`3oool2
000001/0oooo0P00003o0?oooiL0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`05
0?ooo`040>GUi@2IVIT0VIVI09VIV@80<c<c0@3oool000040>GUi@2IVIT0VIVI09VIV@80<c<c7P3o
ool2000000@0oooo0P00000C0?ooo`8000006`3oool200000?l0ooooU03oool40000o`H0oooo00<0
003o0?ooo`3oool01@3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VI
V@2IVIT203<c<a/0oooo200000000`3oool000000000000C0?ooo`8000006`3oool2000000030?oo
o`00000000000?l0ooooU03oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo
00@0iNGU09VIV@2IVIT0VIVI0P0c<c<10?ooo`0000@0iNGU09VIV@2IVIT0VIVI0P0c<c?o0?ooon/0
oooo1@000?l20?ooo`D0003o1`3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0
VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000103U
iND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo0000
103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40oooo
0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c<`40
oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT203<c
<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2IVIT2
03<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VIV@2I
VIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI09VI
V@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIT203<c<ol0oooooP3oool0103UiND0VIVI
09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103UiND0
VIVI09VIV@2IVIT203<c<`40oooo0000103UiND0VIVI09VIV@2IVIWo03<c<ol0<c<c0@0c<c<0103U
iND0VIVI09VIV@2IVIT203<c<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c
<`40oooo00000`3UiND0VIVI09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo00000`3UiND0VIVI
09VIV@3o09VIVOl0VIVI1P2IVIT203<c<`40oooo003o0>GUiOl0iNGU2P3UiND103<c<`40oooo003o
0>GUiOl0iNGU2`3UiND10?ooo`00\
\>"], "Picture",
  Evaluatable->False,
  ImageSize->{522, 83},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"S2.9.19"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides many capabilities for manipulating the contents of notebooks, as \
discussed in Section ",
  ButtonBox["2.11",
    ButtonData:>{"2.11"},
    ButtonStyle->"MainBookLink"],
  ". ",
  StyleBox["StylePrint", "MR"],
  " handles the simple case when all you want to do is to add a cell of a \
particular style. "
}], "Text",
  CellTags->{"S2.9.19", "19.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.20 Requesting Input", "Subsection",
  CellTags->{"S2.9.20", "20.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " usually works by taking whatever input you give, and then processing it. \
Sometimes, however, you may want to have a program you write explicitly \
request more input. You can do this using ",
  StyleBox["Input", "MR"],
  " and ",
  StyleBox["InputString", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.20", "20.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Input[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["read an expression as input "]},
          {Cell[TextData[{
              StyleBox["InputString[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["read a string as input "]},
          {Cell[TextData[{
              StyleBox["Input[\"", "MR"],
              StyleBox["prompt", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["issue a prompt, then read an expression "]},
          {Cell[TextData[{
              StyleBox["InputString[\"", "MR"],
              StyleBox["prompt", "TI"],
              StyleBox["\"]", "MR"],
              " "
            }]], Cell["issue a prompt then read a string "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.20"],

Cell["Interactive input. ", "Caption",
  CellTags->"S2.9.20"],

Cell[TextData[{
  "Exactly how ",
  StyleBox["Input", "MR"],
  " and ",
  StyleBox["InputString", "MR"],
  " work depends on the computer system and ",
  StyleBox["Mathematica", "TI"],
  " interface you are using. With a text\[Hyphen]based interface, they \
typically just wait for standard input, terminated with a newline. With a \
notebook interface, however, they typically get the front end to put up a \
\[OpenCurlyDoubleQuote]dialog box\[CloseCurlyDoubleQuote], in which the user \
can enter input. "
}], "Text",
  CellTags->{"S2.9.20", "20.3"}],

Cell[TextData[{
  "In general, ",
  StyleBox["Input", "MR"],
  " is intended for reading complete ",
  StyleBox["Mathematica", "TI"],
  " expressions. ",
  StyleBox["InputString", "MR"],
  ", on the other hand, is for reading arbitrary strings. "
}], "Text",
  CellTags->{"S2.9.20", "20.4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.21 Messages", "Subsection",
  CellTags->{"S2.9.21", "21.1"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " has a general mechanism for handling messages generated during \
computations. Many built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions use this mechanism to produce error and warning messages. You \
can also use the mechanism for messages associated with functions you write. \
"
}], "Text",
  CellTags->{"S2.9.21", "21.2"}],

Cell[TextData[{
  "The basic idea is that every message has a definite name, of the form ",
  StyleBox["symbol", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  ". You can use this name to refer to the message. (The object ",
  StyleBox["symbol", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  " has head ",
  StyleBox["MessageName", "MR"],
  ".) "
}], "Text",
  CellTags->{"S2.9.21", "21.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Off[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["switch off a message, so it is not printed "]},
          {Cell[TextData[{
              StyleBox["On[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["switch on a message "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.21"],

Cell["Controlling the printing of messages. ", "Caption",
  CellTags->"S2.9.21"],

Cell[TextData[{
  "As discussed in Section ",
  ButtonBox["1.3.11",
    ButtonData:>{"1.3.11", "11.1"},
    ButtonStyle->"MainBookLink"],
  ", you can use ",
  StyleBox["On", "MR"],
  " and ",
  StyleBox["Off", "MR"],
  " to control the printing of particular messages. Most messages associated \
with built\[Hyphen]in functions are switched on by default. You can use ",
  StyleBox["Off", "MR"],
  " to switch them off if you do not want to see them. "
}], "Text",
  CellTags->{"S2.9.21", "21.4"}],

Cell["This prints a warning message. ", "MathCaption",
  CellTags->{"S2.9.21", "21.5"}],

Cell[CellGroupData[{

Cell["Log[a, b, c]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Log::"argt" \(\(:\)\(\ \)\) 
      "\!\(Log\) called with \!\(3\) arguments; \!\(1\) or \!\(2\) arguments \
are expected."\)], "Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Log[a, b, c]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["You can switch off the message like this. ", "MathCaption",
  CellTags->{"S2.9.21", "21.6"}],

Cell["Off[Log::argt]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.21"],

Cell["Now no warning message is produced. ", "MathCaption",
  CellTags->{"S2.9.21", "21.7"}],

Cell[CellGroupData[{

Cell["Log[a, b, c]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Log[a, b, c]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "Although most messages associated with built\[Hyphen]in functions are \
switched on by default, there are some which are switched off by default, and \
which you will see only if you explicitly switch them on. An example is the \
message ",
  StyleBox["General::newsym", "MR"],
  ", discussed in Section ",
  ButtonBox["2.7.13",
    ButtonData:>{"2.7.13", "13.1"},
    ButtonStyle->"MainBookLink"],
  ", which tells you every time a new symbol is created. "
}], "Text",
  CellTags->{"S2.9.21", "21.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["s", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              " "
            }]], Cell["give the text of a message "]},
          {Cell[TextData[{
              StyleBox["s", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["string", "TI"],
              " "
            }]], Cell["set the text of a message "]},
          {Cell[TextData[{
              StyleBox["Messages[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "show all messages associated with ",
              StyleBox["s", "TI"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.21"],

Cell["Manipulating messages. ", "Caption",
  CellTags->"S2.9.21"],

Cell[TextData[{
  "The text of a message with the name ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  " is stored simply as the value of ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  ", associated with the symbol ",
  StyleBox["s", "TI"],
  ". You can therefore see the text of a message simply by asking for ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  ". You can set the text by assigning a value to ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.9.21", "21.9"}],

Cell[TextData[{
  "If you give ",
  StyleBox["LinearSolve", "MR"],
  " a singular matrix, it prints a warning message. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.10"}],

Cell[CellGroupData[{

Cell["LinearSolve[{{1, 1}, {2, 2}}, {3, 5}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(LinearSolve::"nosol" \(\(:\)\(\ \)\) 
      "Linear equation encountered which has no solution."\)], "Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(LinearSolve[{{1, 1}, {2, 2}}, {3, 5}]\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["Here is the text of the message. ", "MathCaption",
  CellTags->{"S2.9.21", "21.11"}],

Cell[CellGroupData[{

Cell["LinearSolve::nosol", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \("Linear equation encountered which has no solution."\)], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["This redefines the message. ", "MathCaption",
  CellTags->{"S2.9.21", "21.12"}],

Cell[CellGroupData[{

Cell["LinearSolve::nosol = \"Matrix encountered is not invertible.\"", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \("Matrix encountered is not invertible."\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["Now the new form will be used. ", "MathCaption",
  CellTags->{"S2.9.21", "21.13"}],

Cell[CellGroupData[{

Cell["LinearSolve[{{1, 1}, {2, 2}}, {3, 5}]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(LinearSolve::"nosol" \(\(:\)\(\ \)\) 
      "Matrix encountered is not invertible."\)], "Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(LinearSolve[{{1, 1}, {2, 2}}, {3, 5}]\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "Messages are always stored as strings suitable for use with ",
  StyleBox["StringForm", "MR"],
  ". When the message is printed, the appropriate expressions are \
\[OpenCurlyDoubleQuote]spliced\[CloseCurlyDoubleQuote] into it. The \
expressions are wrapped with ",
  StyleBox["HoldForm", "MR"],
  " to prevent evaluation. In addition, any function that is assigned as the \
value of the global variable ",
  StyleBox["$MessagePrePrint", "MR"],
  " is applied to the resulting expressions before they are given to ",
  StyleBox["StringForm", "MR"],
  ". The default for ",
  StyleBox["$MessagePrePrint", "MR"],
  " is effectively ",
  StyleBox["Short", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.21", "21.14"}],

Cell["\<\
Most messages are associated directly with the functions that \
generate them. There are, however, some \[OpenCurlyDoubleQuote]general\
\[CloseCurlyDoubleQuote] messages, which can be produced by a variety of \
functions. \
\>", "Text",
  CellTags->{"S2.9.21", "21.15"}],

Cell[TextData[{
  "If you give the wrong number of arguments to a function ",
  StyleBox["F", "TI"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will warn you by printing a message such as ",
  StyleBox["F", "TI"],
  StyleBox["::argx", "MR"],
  ". If ",
  StyleBox["Mathematica", "TI"],
  " cannot find a message named ",
  StyleBox["F", "TI"],
  StyleBox["::argx", "MR"],
  ", it will use the text of the \[OpenCurlyDoubleQuote]general\
\[CloseCurlyDoubleQuote] message ",
  StyleBox["General::argx", "MR"],
  " instead. You can use ",
  StyleBox["Off[", "MR"],
  StyleBox["F", "TI"],
  StyleBox["::argx]", "MR"],
  " to switch off the argument count message specifically for the function ",
  StyleBox["F", "TI"],
  ". You can also use ",
  StyleBox["Off[General::argx]", "MR"],
  " to switch off all messages that use the text of the general message.  "
}], "Text",
  CellTags->{"S2.9.21", "21.16"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " prints a message if you give the wrong number of arguments to a built\
\[Hyphen]in function. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.17"}],

Cell[CellGroupData[{

Cell["Sqrt[a, b]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Sqrt::"argx" \(\(:\)\(\ \)\) 
      "\!\(Sqrt\) called with \!\(2\) arguments; 1 argument is expected."\)], \
"Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Sqrt[a, b]\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["\<\
This argument count message is a general one, used by many \
different functions.\
\>", "MathCaption",
  CellTags->{"S2.9.21", "21.18"}],

Cell[CellGroupData[{

Cell["General::argx", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \("`1` called with `2` arguments; 1 argument is expected."\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "If something goes very wrong with a calculation you are doing, it is \
common to find that the same warning message is generated over and over \
again. This is usually more confusing than useful. As a result, ",
  StyleBox["Mathematica", "TI"],
  " keeps track of all messages that are produced during a particular \
calculation, and stops printing a particular message if it comes up more than \
three times. Whenever this happens, ",
  StyleBox["Mathematica", "TI"],
  " prints the message ",
  StyleBox["General::stop", "MR"],
  " to let you know. If you really want to see all the messages that ",
  StyleBox["Mathematica", "TI"],
  " tries to print, you can do this by switching off ",
  StyleBox["General::stop", "MR"],
  ".  "
}], "Text",
  CellTags->{"S2.9.21", "21.19"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$MessageList", "MR"],
              " "
            }]], 
            Cell["\<\
a list of the messages produced during a particular \
computation \
\>"]},
          {Cell[TextData[{
              StyleBox["MessageList[", "MR"],
              StyleBox["n", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a list of the messages produced during the processing of the ",
              
              StyleBox["n", "TI"],
              Cell[BoxData[
                  \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
              " input line in a ",
              StyleBox["Mathematica", "TI"],
              " session "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.21"],

Cell["\<\
Finding out what messages were produced during a computation. \
\
\>", "Caption",
  CellTags->"S2.9.21"],

Cell[TextData[{
  "In every computation you do, ",
  StyleBox["Mathematica", "TI"],
  " maintains a list ",
  StyleBox["$MessageList", "MR"],
  " of all the messages that are produced. In a standard ",
  StyleBox["Mathematica", "TI"],
  " session, this list is cleared after each line of output is generated. \
However, during a computation, you can access the list. In addition, when the \
",
  StyleBox["n", "TI"],
  Cell[BoxData[
      \(TraditionalForm\`\[Null]\^th\)], "InlineFormula"],
  " output line in a session is generated, the value of ",
  StyleBox["$MessageList", "MR"],
  " is assigned to ",
  StyleBox["MessageList[", "MR"],
  StyleBox["n", "TI"],
  StyleBox["]", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.21", "21.20"}],

Cell[TextData[{
  "This returns ",
  StyleBox["$MessageList", "MR"],
  ", which gives a list of the messages produced. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.21"}],

Cell[CellGroupData[{

Cell["Sqrt[a, b, c]; Exp[a, b]; $MessageList", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Sqrt::"argx" \(\(:\)\(\ \)\) 
      "\!\(Sqrt\) called with \!\(3\) arguments; 1 argument is expected."\)], \
"Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Exp::"argx" \(\(:\)\(\ \)\) 
      "\!\(Exp\) called with \!\(2\) arguments; 1 argument is expected."\)], \
"Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(Sqrt::"argx"\),
          HoldForm], ",", 
        TagBox[\(Exp::"argx"\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "The message names are wrapped in ",
  StyleBox["HoldForm", "MR"],
  " to stop them from evaluating. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.22"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.9.21"],

Cell["{HoldForm[Sqrt::argx], HoldForm[Exp::argx]}", "Output",
  CellLabel->"Out[11]//InputForm= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["\<\
In writing programs, it is often important to be able to check \
automatically whether any messages were generated during a particular \
calculation. If messages were generated, say as a consequence of producing \
indeterminate numerical results, then the result of the calculation may be \
meaningless.  \
\>", "Text",
  CellTags->{"S2.9.21", "21.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Check[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["failexpr", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "if no messages are generated during the evaluation of ",
              StyleBox["expr", "TI"],
              ", then return ",
              StyleBox["expr", "TI"],
              ", otherwise return ",
              StyleBox["failexpr", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Check[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["failexpr", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["::", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["::", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "check only for the messages ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["s",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["::", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["t",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.21"],

Cell["Checking for warning messages. ", "Caption",
  CellTags->"S2.9.21"],

Cell[TextData[{
  "Evaluating ",
  StyleBox["1^0", "MR"],
  " produces no messages, so the result of the evaluation is returned. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.24"}],

Cell[CellGroupData[{

Cell["Check[1^0, err]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "Evaluating ",
  StyleBox["0^0", "MR"],
  " produces a message, so the second argument of ",
  StyleBox["Check", "MR"],
  " is returned. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.25"}],

Cell[CellGroupData[{

Cell["Check[0^0, err]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Power::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0\^0\) encountered."\)], "Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(err\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Check[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["failexpr", "TI"],
  StyleBox["]", "MR"],
  " tests for all messages that are actually printed out. It does not test \
for messages whose output has been suppressed using ",
  StyleBox["Off", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.21", "21.26"}],

Cell[TextData[{
  "In some cases you may want to test only for a specific set of messages, \
say ones associated with numerical overflow. You can do this by explicitly \
telling ",
  StyleBox["Check", "MR"],
  " the names of the messages you want to look for. "
}], "Text",
  CellTags->{"S2.9.21", "21.27"}],

Cell[TextData[{
  "The message generated by ",
  StyleBox["Sin[1,", "MR"],
  " ",
  StyleBox["2]", "MR"],
  " is ignored by ",
  StyleBox["Check", "MR"],
  ", since it is not the one specified. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.28"}],

Cell[CellGroupData[{

Cell["Check[Sin[1, 2], err, General::ind]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Sin::"argx" \(\(:\)\(\ \)\) 
      "\!\(Sin\) called with \!\(2\) arguments; 1 argument is expected."\)], \
"Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(Sin[1, 2]\)], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Message[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["print a message "]},
          {Cell[TextData[{
              StyleBox["Message[", "MR"],
              StyleBox["s", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "print a message, with the ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["expr",
                        "TI"], 
                      StyleBox["i",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " spliced into its string form "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.21"],

Cell["Generating messages. ", "Caption",
  CellTags->"S2.9.21"],

Cell[TextData[{
  "By using the function ",
  StyleBox["Message", "MR"],
  ", you can mimic all aspects of the way in which built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions generate messages. You can for example switch on and off \
messages using ",
  StyleBox["On", "MR"],
  " and ",
  StyleBox["Off", "MR"],
  ", and ",
  StyleBox["Message", "MR"],
  " will automatically look for ",
  StyleBox["General::", "MR"],
  StyleBox["tag", "TI"],
  " if it does not find the specific message ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["tag", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.9.21", "21.29"}],

Cell[TextData[{
  "This defines the text of a message associated with ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.30"}],

Cell[CellGroupData[{

Cell["f::overflow = \"Factorial argument `1` too large.\"", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \("Factorial argument `1` too large."\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "Here is the function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.31"}],

Cell["f[x_] := If[x > 10, (Message[f::overflow, x]; Infinity), x!]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.9.21"],

Cell[TextData[{
  "When the argument of ",
  StyleBox["f", "MR"],
  " is greater than 10, the message is generated. "
}], "MathCaption",
  CellTags->{"S2.9.21", "21.32"}],

Cell[CellGroupData[{

Cell["f[20]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(f::"overflow" \(\(:\)\(\ \)\) 
      "Factorial argument \!\(20\) too large."\)], "Message",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(\[Infinity]\)], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell["This switches off the message. ", "MathCaption",
  CellTags->{"S2.9.21", "21.33"}],

Cell["Off[f::overflow]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.9.21"],

Cell["Now the message is no longer generated. ", "MathCaption",
  CellTags->{"S2.9.21", "21.34"}],

Cell[CellGroupData[{

Cell["f[20]", "Input",
  CellLabel->"In[19]:= ",
  CellTags->"S2.9.21"],

Cell[BoxData[
    \(\[Infinity]\)], "Output",
  CellLabel->"Out[19]= ",
  CellTags->"S2.9.21"]
}, Open  ]],

Cell[TextData[{
  "When you call ",
  StyleBox["Message", "MR"],
  ", it first tries to find a message with the explicit name you have \
specified. If this fails, it tries to find a message with the appropriate tag \
associated with the symbol ",
  StyleBox["General", "MR"],
  ". If this too fails, then ",
  StyleBox["Mathematica", "TI"],
  " takes any function you have defined as the value of the global variable \
",
  StyleBox["$NewMessage", "MR"],
  ", and applies this function to the symbol and tag of the message you have \
requested. "
}], "Text",
  CellTags->{"S2.9.21", "21.35"}],

Cell[TextData[{
  "By setting up the value of ",
  StyleBox["$NewMessage", "MR"],
  " appropriately, you can, for example, get ",
  StyleBox["Mathematica", "TI"],
  " to read in the text of a message from a file when that message is first \
needed. "
}], "Text",
  CellTags->{"S2.9.21", "21.36"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.22 International Messages", "Subsection",
  CellTags->{"S2.9.22", "22.1"}],

Cell[TextData[{
  "The standard set of messages for built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions are written in American English. In some versions of ",
  StyleBox["Mathematica", "TI"],
  ", messages are also available in other languages. In addition, if you set \
up messages yourself, you can give ones in other languages. "
}], "Text",
  CellTags->{"S2.9.22", "22.2"}],

Cell[TextData[{
  "Languages in ",
  StyleBox["Mathematica", "TI"],
  " are conventionally specified by strings. The languages are given in \
English, in order to avoid the possibility of needing special characters. \
Thus, for example, the French language is specified in ",
  StyleBox["Mathematica", "TI"],
  " as ",
  StyleBox["\"French\"", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.9.22", "22.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["$Language", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["lang", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["set the language to use "]},
          {Cell[TextData[{
              StyleBox["$Language", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["{\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lang",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              StyleBox["\"", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["lang",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["\",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["set a sequence of languages to try "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.22"],

Cell["Setting the language to use for messages. ", "Caption",
  CellTags->"S2.9.22"],

Cell[TextData[{
  "This tells ",
  StyleBox["Mathematica", "TI"],
  " to use French\[Hyphen]language versions of messages. "
}], "MathCaption",
  CellTags->{"S2.9.22", "22.4"}],

Cell[CellGroupData[{

Cell["$Language = \"French\"", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.22"],

Cell[BoxData[
    \("French"\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.22"]
}, Open  ]],

Cell[TextData[{
  "If your version of ",
  StyleBox["Mathematica", "TI"],
  " has French\[Hyphen]language messages, the message generated here will be \
in French. "
}], "MathCaption",
  CellTags->{"S2.9.22", "22.5"}],

Cell[CellGroupData[{

Cell["Sqrt[a, b, c]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.22"],

Cell[BoxData[
    \(Sqrt::"argx" \(\(:\)\(\ \)\) 
      "\!\(Sqrt\) est appel\nelax\\parskip\\z@$$EAcute]e avec \!\(3\) \
arguments; il faut y avoir 1."\)], "Message",
  CellTags->"S2.9.22"],

Cell[BoxData[
    \(Sqrt[a, b, c]\)], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.9.22"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["symbol", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              " "
            }]], Cell["the default form of a message "]},
          {Cell[TextData[{
              StyleBox["symbol", "TI"],
              StyleBox["::", "MR"],
              StyleBox["tag", "TI"],
              StyleBox["::", "MR"],
              StyleBox["Language", "TI"],
              " "
            }]], Cell["a message in a particular language "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.22"],

Cell["Messages in different languages. ", "Caption",
  CellTags->"S2.9.22"],

Cell[TextData[{
  "When built\[Hyphen]in ",
  StyleBox["Mathematica", "TI"],
  " functions generate messages, they look first for messages of the form ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["t", "TI"],
  StyleBox["::", "MR"],
  StyleBox["Language", "TI"],
  ", in the language specified by ",
  StyleBox["$Language", "MR"],
  ". If they fail to find any such messages, then they use instead the form \
",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["t", "TI"],
  " without an explicit language specification. "
}], "Text",
  CellTags->{"S2.9.22", "22.6"}],

Cell[TextData[{
  "The procedure used by built\[Hyphen]in functions will also be followed by \
functions you define if you call ",
  StyleBox["Message", "MR"],
  " with message names of the form ",
  StyleBox["s", "TI"],
  StyleBox["::", "MR"],
  StyleBox["t", "TI"],
  ". If you give explicit languages in message names, however, only those \
languages will be used. "
}], "Text",
  CellTags->{"S2.9.22", "22.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.9.23 Documentation Constructs", "Subsection",
  CellTags->{"S2.9.23", "23.1"}],

Cell[TextData[{
  "When you write programs in ",
  StyleBox["Mathematica", "TI"],
  ", there are various ways to document your code. As always, by far the best \
thing is to write clear code, and to name the objects you define as \
explicitly as possible. "
}], "Text",
  CellTags->{"S2.9.23", "23.2"}],

Cell[TextData[{
  "Sometimes, however, you may want to add some \
\[OpenCurlyDoubleQuote]commentary text\[CloseCurlyDoubleQuote] to your code, \
to make it easier to understand. You can add such text at any point in your \
code simply by enclosing it in matching ",
  StyleBox["(*", "MR"],
  " and ",
  StyleBox["*)", "MR"],
  ". Notice that in ",
  StyleBox["Mathematica", "TI"],
  ", \[OpenCurlyDoubleQuote]comments\[CloseCurlyDoubleQuote] enclosed in ",
  StyleBox["(*", "MR"],
  " and ",
  StyleBox["*)", "MR"],
  " can be nested in any way. "
}], "Text",
  CellTags->{"S2.9.23", "23.3"}],

Cell[TextData[{
  "You can use comments anywhere in the ",
  StyleBox["Mathematica", "TI"],
  " code you write. "
}], "MathCaption",
  CellTags->{"S2.9.23", "23.4"}],

Cell[CellGroupData[{

Cell["If[a > b, (* then *) p, (* else *) q]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.9.23"],

Cell[BoxData[
    \(If[a > b, p, q]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.9.23"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["(*", "MR"],
              " ",
              StyleBox["text", "TI"],
              " ",
              StyleBox["*)", "MR"],
              " "
            }]], Cell[TextData[{
              "a comment that can be inserted anywhere in ",
              StyleBox["Mathematica", "TI"],
              " code "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.23"],

Cell[TextData[{
  "Comments in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.9.23"],

Cell[TextData[{
  "There is a convention in ",
  StyleBox["Mathematica", "TI"],
  " that all functions intended for later use should be given a definite \
\[OpenCurlyDoubleQuote]usage message\[CloseCurlyDoubleQuote], which documents \
their basic usage. This message is defined as the value of ",
  StyleBox["f", "TI"],
  StyleBox["::usage", "MR"],
  ", and is retrieved when you type ",
  StyleBox["?", "MR"],
  StyleBox["f", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.9.23", "23.5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::usage", "MR"],
              " ",
              StyleBox["=", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["define the usage message for a function "]},
          {Cell[TextData[{
              StyleBox["?", "MR"],
              StyleBox["f", "TI"],
              " "
            }]], Cell["get information about a function "]},
          {Cell[TextData[{
              StyleBox["??", "MR"],
              StyleBox["f", "TI"],
              " "
            }]], Cell["get more information about a function "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.23"],

Cell["Usage messages for functions. ", "Caption",
  CellTags->"S2.9.23"],

Cell[TextData[{
  "Here is the definition of a function ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.23", "23.6"}],

Cell["f[x_] := x^2", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.9.23"],

Cell[TextData[{
  "Here is a \[OpenCurlyDoubleQuote]usage message\[CloseCurlyDoubleQuote] for \
",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.23", "23.7"}],

Cell[CellGroupData[{

Cell["f::usage = \"f[x] gives the square of x.\"", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.9.23"],

Cell[BoxData[
    \("f[x] gives the square of x."\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.9.23"]
}, Open  ]],

Cell[TextData[{
  "This gives the usage message for ",
  StyleBox["f", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.9.23", "23.8"}],

Cell[CellGroupData[{

Cell["?f", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.9.23"],

Cell[BoxData[
    \("f[x] gives the square of x."\)], "Print",
  CellTags->"S2.9.23"]
}, Open  ]],

Cell[TextData[{
  StyleBox["??f", "MR"],
  " gives all the information ",
  StyleBox["Mathematica", "TI"],
  " has about ",
  StyleBox["f", "MR"],
  ", including the actual definition. "
}], "MathCaption",
  CellTags->{"S2.9.23", "23.9"}],

Cell[CellGroupData[{

Cell["??f", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.9.23"],

Cell[BoxData[
    \("f[x] gives the square of x."\)], "Print",
  CellTags->"S2.9.23"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(f[x_] := x\^2\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ f],
      Editable->False]], "Print",
  CellTags->"S2.9.23"]
}, Open  ]],

Cell[TextData[{
  "When you define a function ",
  StyleBox["f", "TI"],
  ", you can usually display its value using ",
  StyleBox["?", "MR"],
  StyleBox["f", "TI"],
  ". However, if you give a usage message for ",
  StyleBox["f", "TI"],
  ", then ",
  StyleBox["?", "MR"],
  StyleBox["f", "TI"],
  " just gives the usage message. Only when you type ",
  StyleBox["??", "MR"],
  StyleBox["f", "TI"],
  " do you get all the details about ",
  StyleBox["f", "TI"],
  ", including its actual definition. "
}], "Text",
  CellTags->{"S2.9.23", "23.10"}],

Cell[TextData[{
  "If you ask for information using ",
  StyleBox["?", "MR"],
  " about just one function, ",
  StyleBox["Mathematica", "TI"],
  " will print out the complete usage messages for the function. If you ask \
for information on several functions at the same time, however, ",
  StyleBox["Mathematica", "TI"],
  " will give the name of each function, if possible with a link to its usage \
information. "
}], "Text",
  CellTags->{"S2.9.23", "23.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::usage", "MR"],
              " "
            }]], Cell["main usage message "]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::notes", "MR"],
              " "
            }]], Cell["notes about the function "]},
          {Cell[TextData[{
              StyleBox["f", "TI"],
              StyleBox["::usage::", "MR"],
              StyleBox["Language", "TI"],
              ",  etc. "
            }]], Cell["messages in a particular language "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.9.23"],

Cell["Some typical documentation messages. ", "Caption",
  CellTags->"S2.9.23"],

Cell[TextData[{
  "In addition to the usage message, there are some messages such as ",
  StyleBox["notes", "MR"],
  " and ",
  StyleBox["qv", "MR"],
  " that are often defined to document functions. "
}], "Text",
  CellTags->{"S2.9.23", "23.12"}],

Cell[TextData[{
  "If you use ",
  StyleBox["Mathematica", "TI"],
  " with a text\[Hyphen]based interface, then messages and comments are the \
primary mechanisms for documenting your definitions. However, if you use ",
  StyleBox["Mathematica", "TI"],
  " with a notebook interface, then you will be able to give much more \
extensive documentation in text cells in the notebook. "
}], "Text",
  CellTags->{"S2.9.23", "23.13"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{252, Automatic}, {Automatic, 84}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.9.0"->{
    Cell[1776, 53, 127, 4, 65, "Section",
      CellTags->{"S2.9.0", "0.1"}]},
  "0.1"->{
    Cell[1776, 53, 127, 4, 65, "Section",
      CellTags->{"S2.9.0", "0.1"}]},
  "S2.9.1"->{
    Cell[1928, 61, 84, 1, 70, "Subsection",
      CellTags->{"S2.9.1", "1.1"}],
    Cell[2015, 64, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.2"}],
    Cell[2144, 69, 77, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[2224, 73, 91, 3, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[2330, 79, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.3"}],
    Cell[2459, 84, 90, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[2552, 88, 91, 3, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[2658, 94, 147, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.4"}],
    Cell[2830, 102, 90, 3, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[2923, 107, 91, 3, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[3029, 113, 154, 4, 70, "Text",
      CellTags->{"S2.9.1", "1.5"}],
    Cell[3186, 119, 203, 7, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.6"}],
    Cell[3414, 130, 77, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[3494, 134, 91, 3, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[3600, 140, 241, 7, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.7"}],
    Cell[3866, 151, 91, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[3960, 155, 90, 2, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[4053, 159, 116, 5, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[4184, 167, 158, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.8"}],
    Cell[4367, 175, 90, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[4460, 179, 89, 2, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[4564, 184, 177, 5, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.9"}],
    Cell[4766, 193, 89, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[4858, 197, 276, 8, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[5149, 208, 1268, 38, 70, "DefinitionBox",
      CellTags->"S2.9.1"],
    Cell[6420, 248, 76, 1, 70, "Caption",
      CellTags->"S2.9.1"],
    Cell[6499, 251, 457, 11, 70, "Text",
      CellTags->{"S2.9.1", "1.10"}],
    Cell[6959, 264, 217, 5, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.11"}],
    Cell[7201, 273, 120, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[7324, 277, 171, 4, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[7510, 284, 143, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.12"}],
    Cell[7678, 292, 88, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[7769, 296, 87, 2, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[7871, 301, 279, 9, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.13"}],
    Cell[8175, 314, 87, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[8265, 318, 93, 2, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[8373, 323, 151, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.14"}],
    Cell[8549, 331, 93, 2, 70, "Input",
      CellTags->"S2.9.1"],
    Cell[8645, 335, 93, 2, 70, "Output",
      CellTags->"S2.9.1"],
    Cell[8753, 340, 1341, 36, 70, "DefinitionBox",
      CellTags->"S2.9.1"],
    Cell[10097, 378, 139, 5, 70, "Caption",
      CellTags->"S2.9.1"],
    Cell[10239, 385, 461, 12, 70, "Text",
      CellTags->{"S2.9.1", "1.15"}],
    Cell[10703, 399, 487, 16, 70, "FramedBox",
      CellTags->"S2.9.1"],
    Cell[11193, 417, 149, 5, 70, "Caption",
      CellTags->"S2.9.1"]},
  "1.1"->{
    Cell[1928, 61, 84, 1, 70, "Subsection",
      CellTags->{"S2.9.1", "1.1"}]},
  "1.2"->{
    Cell[2015, 64, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.2"}]},
  "1.3"->{
    Cell[2330, 79, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.3"}]},
  "1.4"->{
    Cell[2658, 94, 147, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.4"}]},
  "1.5"->{
    Cell[3029, 113, 154, 4, 70, "Text",
      CellTags->{"S2.9.1", "1.5"}]},
  "1.6"->{
    Cell[3186, 119, 203, 7, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.6"}]},
  "1.7"->{
    Cell[3600, 140, 241, 7, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.7"}]},
  "1.8"->{
    Cell[4184, 167, 158, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.8"}]},
  "1.9"->{
    Cell[4564, 184, 177, 5, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.9"}]},
  "1.10"->{
    Cell[6499, 251, 457, 11, 70, "Text",
      CellTags->{"S2.9.1", "1.10"}]},
  "1.11"->{
    Cell[6959, 264, 217, 5, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.11"}]},
  "1.12"->{
    Cell[7510, 284, 143, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.12"}]},
  "1.13"->{
    Cell[7871, 301, 279, 9, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.13"}]},
  "1.14"->{
    Cell[8373, 323, 151, 4, 70, "MathCaption",
      CellTags->{"S2.9.1", "1.14"}]},
  "1.15"->{
    Cell[10239, 385, 461, 12, 70, "Text",
      CellTags->{"S2.9.1", "1.15"}]},
  "S2.9.2"->{
    Cell[11379, 427, 84, 1, 70, "Subsection",
      CellTags->{"S2.9.2", "2.1"}],
    Cell[11466, 430, 478, 11, 70, "DefinitionBox",
      CellTags->"S2.9.2"],
    Cell[11947, 443, 124, 5, 70, "Caption",
      CellTags->"S2.9.2"],
    Cell[12074, 450, 537, 20, 70, "Text",
      CellTags->{"S2.9.2", "2.2"}],
    Cell[12614, 472, 320, 9, 70, "Text",
      CellTags->{"S2.9.2", "2.3"}],
    Cell[12937, 483, 330, 14, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.4"}],
    Cell[13292, 501, 69, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[13364, 505, 85, 3, 70, "Output",
      CellTags->"S2.9.2"],
    Cell[13464, 511, 97, 1, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.5"}],
    Cell[13586, 516, 78, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[13667, 520, 82, 2, 70, "Output",
      CellTags->"S2.9.2"],
    Cell[13764, 525, 313, 11, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.6"}],
    Cell[14102, 540, 65, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[14170, 544, 85, 3, 70, "Output",
      CellTags->"S2.9.2"],
    Cell[14270, 550, 463, 14, 70, "Text",
      CellTags->{"S2.9.2", "2.7"}],
    Cell[14736, 566, 631, 20, 70, "Text",
      CellTags->{"S2.9.2", "2.8"}],
    Cell[15370, 588, 598, 16, 70, "Text",
      CellTags->{"S2.9.2", "2.9"}],
    Cell[15971, 606, 206, 7, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.10"}],
    Cell[16202, 617, 90, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[16295, 621, 89, 2, 70, "Output",
      CellTags->"S2.9.2"],
    Cell[16399, 626, 111, 1, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.11"}],
    Cell[16535, 631, 65, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[16603, 635, 92, 3, 70, "Output",
      CellTags->"S2.9.2"],
    Cell[16710, 641, 231, 9, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.12"}],
    Cell[16966, 654, 65, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[17034, 658, 89, 2, 70, "Output",
      CellTags->"S2.9.2"],
    Cell[17138, 663, 179, 7, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.13"}],
    Cell[17342, 674, 74, 2, 70, "Input",
      CellTags->"S2.9.2"],
    Cell[17419, 678, 816, 26, 70, "Output",
      CellTags->"S2.9.2"]},
  "2.1"->{
    Cell[11379, 427, 84, 1, 70, "Subsection",
      CellTags->{"S2.9.2", "2.1"}]},
  "2.2"->{
    Cell[12074, 450, 537, 20, 70, "Text",
      CellTags->{"S2.9.2", "2.2"}]},
  "2.3"->{
    Cell[12614, 472, 320, 9, 70, "Text",
      CellTags->{"S2.9.2", "2.3"}]},
  "2.4"->{
    Cell[12937, 483, 330, 14, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.4"}]},
  "2.5"->{
    Cell[13464, 511, 97, 1, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.5"}]},
  "2.6"->{
    Cell[13764, 525, 313, 11, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.6"}]},
  "2.7"->{
    Cell[14270, 550, 463, 14, 70, "Text",
      CellTags->{"S2.9.2", "2.7"}]},
  "2.8"->{
    Cell[14736, 566, 631, 20, 70, "Text",
      CellTags->{"S2.9.2", "2.8"}]},
  "2.9"->{
    Cell[15370, 588, 598, 16, 70, "Text",
      CellTags->{"S2.9.2", "2.9"}]},
  "2.10"->{
    Cell[15971, 606, 206, 7, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.10"}]},
  "2.11"->{
    Cell[16399, 626, 111, 1, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.11"}]},
  "2.12"->{
    Cell[16710, 641, 231, 9, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.12"}]},
  "2.13"->{
    Cell[17138, 663, 179, 7, 70, "MathCaption",
      CellTags->{"S2.9.2", "2.13"}]},
  "S2.9.3"->{
    Cell[18284, 710, 94, 1, 70, "Subsection",
      CellTags->{"S2.9.3", "3.1"}],
    Cell[18381, 713, 564, 11, 70, "Text",
      CellTags->{"S2.9.3", "3.2"}],
    Cell[18948, 726, 644, 18, 70, "DefinitionBox",
      CellTags->"S2.9.3"],
    Cell[19595, 746, 83, 1, 70, "Caption",
      CellTags->"S2.9.3"],
    Cell[19681, 749, 202, 6, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.3"}],
    Cell[19908, 759, 94, 2, 70, "Input",
      CellTags->"S2.9.3"],
    Cell[20005, 763, 92, 3, 70, "Output",
      CellTags->"S2.9.3"],
    Cell[20112, 769, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.4"}],
    Cell[20267, 777, 75, 2, 70, "Input",
      CellTags->"S2.9.3"],
    Cell[20345, 781, 248, 8, 70, "Output",
      CellTags->"S2.9.3"],
    Cell[20608, 792, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.5"}],
    Cell[20737, 797, 77, 2, 70, "Input",
      CellTags->"S2.9.3"],
    Cell[20817, 801, 126, 3, 70, "Output",
      CellTags->"S2.9.3"],
    Cell[20958, 807, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.6"}],
    Cell[21156, 816, 96, 2, 70, "Input",
      CellTags->"S2.9.3"],
    Cell[21255, 820, 155, 4, 70, "Output",
      CellTags->"S2.9.3"],
    Cell[21425, 827, 221, 6, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.7"}],
    Cell[21671, 837, 109, 2, 70, "Input",
      CellTags->"S2.9.3"],
    Cell[21783, 841, 95, 2, 70, "Output",
      CellTags->"S2.9.3"],
    Cell[21893, 846, 295, 8, 70, "Text",
      CellTags->{"S2.9.3", "3.8"}],
    Cell[22191, 856, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.9"}],
    Cell[22349, 863, 10315, 132, 70, 10180, 127, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S2.9.3"],
    Cell[32667, 997, 224, 6, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.10"}],
    Cell[32894, 1005, 65991, 819, 70, 65855, 814, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S2.9.3"],
    Cell[98888, 1826, 1101, 34, 70, "DefinitionBox",
      CellTags->"S2.9.3"],
    Cell[99992, 1862, 86, 1, 70, "Caption",
      CellTags->"S2.9.3"]},
  "3.1"->{
    Cell[18284, 710, 94, 1, 70, "Subsection",
      CellTags->{"S2.9.3", "3.1"}]},
  "3.2"->{
    Cell[18381, 713, 564, 11, 70, "Text",
      CellTags->{"S2.9.3", "3.2"}]},
  "3.3"->{
    Cell[19681, 749, 202, 6, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.3"}]},
  "3.4"->{
    Cell[20112, 769, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.4"}]},
  "3.5"->{
    Cell[20608, 792, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.5"}]},
  "3.6"->{
    Cell[20958, 807, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.6"}]},
  "3.7"->{
    Cell[21425, 827, 221, 6, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.7"}]},
  "3.8"->{
    Cell[21893, 846, 295, 8, 70, "Text",
      CellTags->{"S2.9.3", "3.8"}]},
  "3.9"->{
    Cell[22191, 856, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.9"}]},
  "3.10"->{
    Cell[32667, 997, 224, 6, 70, "MathCaption",
      CellTags->{"S2.9.3", "3.10"}]},
  "S2.9.4"->{
    Cell[100115, 1868, 94, 1, 70, "Subsection",
      CellTags->{"S2.9.4", "4.1"}],
    Cell[100212, 1871, 465, 13, 70, "DefinitionBox",
      CellTags->"S2.9.4"],
    Cell[100680, 1886, 90, 1, 70, "Caption",
      CellTags->"S2.9.4"],
    Cell[100773, 1889, 110, 1, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.2"}],
    Cell[100908, 1894, 93, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[101004, 1898, 89, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[101108, 1904, 194, 6, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.3"}],
    Cell[101327, 1914, 94, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[101424, 1918, 125, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[101564, 1924, 177, 4, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.4"}],
    Cell[101766, 1932, 79, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[101848, 1936, 89, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[101952, 1942, 311, 10, 70, "Text",
      CellTags->{"S2.9.4", "4.5"}],
    Cell[102266, 1954, 498, 11, 70, "Text",
      CellTags->{"S2.9.4", "4.6"}],
    Cell[102767, 1967, 649, 18, 70, "DefinitionBox",
      CellTags->"S2.9.4"],
    Cell[103419, 1987, 140, 5, 70, "Caption",
      CellTags->"S2.9.4"],
    Cell[103562, 1994, 141, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.7"}],
    Cell[103728, 2003, 84, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[103815, 2007, 89, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[103919, 2013, 148, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.8"}],
    Cell[104092, 2022, 71, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[104166, 2026, 89, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[104270, 2032, 150, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.9"}],
    Cell[104445, 2041, 88, 3, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[104536, 2046, 89, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[104640, 2052, 245, 7, 70, "Text",
      CellTags->{"S2.9.4", "4.10"}],
    Cell[104888, 2061, 1524, 51, 70, "Text",
      CellTags->{"S2.9.4", "4.11"}],
    Cell[106415, 2114, 510, 18, 70, "Text",
      CellTags->{"S2.9.4", "4.12"}],
    Cell[106928, 2134, 388, 10, 70, "Text",
      CellTags->{"S2.9.4", "4.13"}],
    Cell[107319, 2146, 751, 23, 70, "DefinitionBox",
      CellTags->"S2.9.4"],
    Cell[108073, 2171, 112, 5, 70, "Caption",
      CellTags->"S2.9.4"],
    Cell[108188, 2178, 920, 27, 70, "Text",
      CellTags->{"S2.9.4", "4.14"}],
    Cell[109111, 2207, 111, 3, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.15"}],
    Cell[109247, 2214, 73, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[109323, 2218, 92, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[109430, 2224, 127, 4, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.16"}],
    Cell[109582, 2232, 88, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[109673, 2236, 92, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[109780, 2242, 178, 4, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.17"}],
    Cell[109983, 2250, 71, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[110057, 2254, 85, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[110157, 2260, 816, 24, 70, "Text",
      CellTags->{"S2.9.4", "4.18"}],
    Cell[110976, 2286, 673, 19, 70, "DefinitionBox",
      CellTags->"S2.9.4"],
    Cell[111652, 2307, 77, 1, 70, "Caption",
      CellTags->"S2.9.4"],
    Cell[111732, 2310, 416, 11, 70, "Text",
      CellTags->{"S2.9.4", "4.19"}],
    Cell[112151, 2323, 602, 16, 70, "Text",
      CellTags->{"S2.9.4", "4.20"}],
    Cell[112756, 2341, 320, 11, 70, "Text",
      CellTags->{"S2.9.4", "4.21"}],
    Cell[113079, 2354, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.22"}],
    Cell[113267, 2363, 104, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[113374, 2367, 86, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[113475, 2373, 162, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.23"}],
    Cell[113662, 2382, 101, 2, 70, "Input",
      CellTags->"S2.9.4"],
    Cell[113766, 2386, 86, 3, 70, "Output",
      CellTags->"S2.9.4"],
    Cell[113867, 2392, 458, 12, 70, "Text",
      CellTags->{"S2.9.4", "4.24"}],
    Cell[114328, 2406, 455, 12, 70, "Text",
      CellTags->{"S2.9.4", "4.25"}]},
  "4.1"->{
    Cell[100115, 1868, 94, 1, 70, "Subsection",
      CellTags->{"S2.9.4", "4.1"}]},
  "4.2"->{
    Cell[100773, 1889, 110, 1, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.2"}]},
  "4.3"->{
    Cell[101108, 1904, 194, 6, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.3"}]},
  "4.4"->{
    Cell[101564, 1924, 177, 4, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.4"}]},
  "4.5"->{
    Cell[101952, 1942, 311, 10, 70, "Text",
      CellTags->{"S2.9.4", "4.5"}]},
  "4.6"->{
    Cell[102266, 1954, 498, 11, 70, "Text",
      CellTags->{"S2.9.4", "4.6"}]},
  "4.7"->{
    Cell[103562, 1994, 141, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.7"}]},
  "4.8"->{
    Cell[103919, 2013, 148, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.8"}]},
  "4.9"->{
    Cell[104270, 2032, 150, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.9"}]},
  "4.10"->{
    Cell[104640, 2052, 245, 7, 70, "Text",
      CellTags->{"S2.9.4", "4.10"}]},
  "4.11"->{
    Cell[104888, 2061, 1524, 51, 70, "Text",
      CellTags->{"S2.9.4", "4.11"}]},
  "4.12"->{
    Cell[106415, 2114, 510, 18, 70, "Text",
      CellTags->{"S2.9.4", "4.12"}]},
  "4.13"->{
    Cell[106928, 2134, 388, 10, 70, "Text",
      CellTags->{"S2.9.4", "4.13"}]},
  "4.14"->{
    Cell[108188, 2178, 920, 27, 70, "Text",
      CellTags->{"S2.9.4", "4.14"}]},
  "4.15"->{
    Cell[109111, 2207, 111, 3, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.15"}]},
  "4.16"->{
    Cell[109430, 2224, 127, 4, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.16"}]},
  "4.17"->{
    Cell[109780, 2242, 178, 4, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.17"}]},
  "4.18"->{
    Cell[110157, 2260, 816, 24, 70, "Text",
      CellTags->{"S2.9.4", "4.18"}]},
  "4.19"->{
    Cell[111732, 2310, 416, 11, 70, "Text",
      CellTags->{"S2.9.4", "4.19"}]},
  "4.20"->{
    Cell[112151, 2323, 602, 16, 70, "Text",
      CellTags->{"S2.9.4", "4.20"}]},
  "4.21"->{
    Cell[112756, 2341, 320, 11, 70, "Text",
      CellTags->{"S2.9.4", "4.21"}]},
  "4.22"->{
    Cell[113079, 2354, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.22"}]},
  "4.23"->{
    Cell[113475, 2373, 162, 5, 70, "MathCaption",
      CellTags->{"S2.9.4", "4.23"}]},
  "4.24"->{
    Cell[113867, 2392, 458, 12, 70, "Text",
      CellTags->{"S2.9.4", "4.24"}]},
  "4.25"->{
    Cell[114328, 2406, 455, 12, 70, "Text",
      CellTags->{"S2.9.4", "4.25"}]},
  "S2.9.5"->{
    Cell[114820, 2423, 83, 1, 70, "Subsection",
      CellTags->{"S2.9.5", "5.1"}],
    Cell[114906, 2426, 377, 7, 70, "Text",
      CellTags->{"S2.9.5", "5.2"}],
    Cell[115286, 2435, 288, 10, 70, "Text",
      CellTags->{"S2.9.5", "5.3"}],
    Cell[115577, 2447, 1911, 60, 70, "DefinitionBox",
      CellTags->"S2.9.5"],
    Cell[117491, 2509, 74, 1, 70, "Caption",
      CellTags->"S2.9.5"],
    Cell[117568, 2512, 174, 4, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.4"}],
    Cell[117745, 2518, 92, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[117840, 2522, 267, 8, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.5"}],
    Cell[118132, 2534, 72, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[118207, 2538, 186, 5, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[118408, 2546, 872, 17, 70, "Text",
      CellTags->{"S2.9.5", "5.6"}],
    Cell[119283, 2565, 175, 5, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.7"}],
    Cell[119483, 2574, 75, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[119561, 2578, 490, 9, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[120066, 2590, 188, 7, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.8"}],
    Cell[120279, 2601, 83, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[120365, 2605, 241, 8, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[120621, 2616, 738, 21, 70, "Text",
      CellTags->{"S2.9.5", "5.9"}],
    Cell[121362, 2639, 179, 6, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.10"}],
    Cell[121566, 2649, 74, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[121643, 2653, 561, 11, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[122219, 2667, 137, 4, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.11"}],
    Cell[122381, 2675, 90, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[122474, 2679, 244, 5, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[122733, 2687, 283, 8, 70, "Text",
      CellTags->{"S2.9.5", "5.12"}],
    Cell[123019, 2697, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.13"}],
    Cell[123161, 2703, 116, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[123280, 2707, 82, 3, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[123377, 2713, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.14"}],
    Cell[123474, 2716, 84, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[123561, 2720, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.15"}],
    Cell[123741, 2729, 75, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[123819, 2733, 1521, 34, 70, "Output",
      CellTags->"S2.9.5"],
    Cell[125355, 2770, 178, 5, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.16"}],
    Cell[125558, 2779, 77, 2, 70, "Input",
      CellTags->"S2.9.5"],
    Cell[125638, 2783, 301, 7, 70, "Output",
      CellTags->"S2.9.5"]},
  "5.1"->{
    Cell[114820, 2423, 83, 1, 70, "Subsection",
      CellTags->{"S2.9.5", "5.1"}]},
  "5.2"->{
    Cell[114906, 2426, 377, 7, 70, "Text",
      CellTags->{"S2.9.5", "5.2"}]},
  "5.3"->{
    Cell[115286, 2435, 288, 10, 70, "Text",
      CellTags->{"S2.9.5", "5.3"}]},
  "5.4"->{
    Cell[117568, 2512, 174, 4, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.4"}]},
  "5.5"->{
    Cell[117840, 2522, 267, 8, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.5"}]},
  "5.6"->{
    Cell[118408, 2546, 872, 17, 70, "Text",
      CellTags->{"S2.9.5", "5.6"}]},
  "5.7"->{
    Cell[119283, 2565, 175, 5, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.7"}]},
  "5.8"->{
    Cell[120066, 2590, 188, 7, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.8"}]},
  "5.9"->{
    Cell[120621, 2616, 738, 21, 70, "Text",
      CellTags->{"S2.9.5", "5.9"}]},
  "5.10"->{
    Cell[121362, 2639, 179, 6, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.10"}]},
  "5.11"->{
    Cell[122219, 2667, 137, 4, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.11"}]},
  "5.12"->{
    Cell[122733, 2687, 283, 8, 70, "Text",
      CellTags->{"S2.9.5", "5.12"}]},
  "5.13"->{
    Cell[123019, 2697, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.13"}]},
  "5.14"->{
    Cell[123377, 2713, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.14"}]},
  "5.15"->{
    Cell[123561, 2720, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.15"}]},
  "5.16"->{
    Cell[125355, 2770, 178, 5, 70, "MathCaption",
      CellTags->{"S2.9.5", "5.16"}]},
  "S2.9.6"->{
    Cell[125988, 2796, 105, 3, 70, "Subsection",
      CellTags->{"S2.9.6", "6.1"}],
    Cell[126096, 2801, 422, 12, 70, "DefinitionBox",
      CellTags->"S2.9.6"],
    Cell[126521, 2815, 55, 1, 70, "Caption",
      CellTags->"S2.9.6"],
    Cell[126579, 2818, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.2"}],
    Cell[126767, 2827, 85, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[126855, 2831, 100, 3, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[126970, 2837, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.3"}],
    Cell[127089, 2842, 76, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[127168, 2846, 97, 2, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[127280, 2851, 382, 10, 70, "Text",
      CellTags->{"S2.9.6", "6.4"}],
    Cell[127665, 2863, 2974, 86, 70, "DefinitionBox",
      CellTags->"S2.9.6"],
    Cell[130642, 2951, 63, 1, 70, "Caption",
      CellTags->"S2.9.6"],
    Cell[130708, 2954, 382, 9, 70, "Text",
      CellTags->{"S2.9.6", "6.5"}],
    Cell[131093, 2965, 171, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.6"}],
    Cell[131289, 2974, 108, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[131400, 2978, 261, 8, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[131676, 2989, 114, 2, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.7"}],
    Cell[131815, 2995, 101, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[131919, 2999, 209, 5, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[132143, 3007, 432, 10, 70, "Text",
      CellTags->{"S2.9.6", "6.8"}],
    Cell[132578, 3019, 202, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.9"}],
    Cell[132805, 3028, 137, 5, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[132945, 3035, 449, 12, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[133409, 3050, 333, 10, 70, "Text",
      CellTags->{"S2.9.6", "6.10"}],
    Cell[133745, 3062, 196, 6, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.11"}],
    Cell[133966, 3072, 97, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[134066, 3076, 196, 5, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[134277, 3084, 156, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.12"}],
    Cell[134458, 3093, 76, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[134537, 3097, 109, 2, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[134661, 3102, 159, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.13"}],
    Cell[134845, 3111, 86, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[134934, 3115, 89, 2, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[135038, 3120, 393, 9, 70, "Text",
      CellTags->{"S2.9.6", "6.14"}],
    Cell[135434, 3131, 1294, 37, 70, "DefinitionBox",
      CellTags->"S2.9.6"],
    Cell[136731, 3170, 77, 1, 70, "Caption",
      CellTags->"S2.9.6"],
    Cell[136811, 3173, 165, 4, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.15"}],
    Cell[137001, 3181, 98, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[137102, 3185, 208, 5, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[137325, 3193, 1905, 59, 70, "DefinitionBox",
      CellTags->"S2.9.6"],
    Cell[139233, 3254, 75, 1, 70, "Caption",
      CellTags->"S2.9.6"],
    Cell[139311, 3257, 102, 1, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.16"}],
    Cell[139438, 3262, 89, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[139530, 3266, 328, 12, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[139873, 3281, 600, 18, 70, "DefinitionBox",
      CellTags->"S2.9.6"],
    Cell[140476, 3301, 76, 1, 70, "Caption",
      CellTags->"S2.9.6"],
    Cell[140555, 3304, 647, 17, 70, "Text",
      CellTags->{"S2.9.6", "6.17"}],
    Cell[141205, 3323, 215, 10, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.18"}],
    Cell[141445, 3337, 80, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[141528, 3341, 111, 4, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[141654, 3348, 160, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.19"}],
    Cell[141839, 3357, 80, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[141922, 3361, 111, 4, 70, "Output",
      CellTags->"S2.9.6"],
    Cell[142048, 3368, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.20"}],
    Cell[142234, 3377, 80, 2, 70, "Input",
      CellTags->"S2.9.6"],
    Cell[142317, 3381, 112, 4, 70, "Output",
      CellTags->"S2.9.6"]},
  "6.1"->{
    Cell[125988, 2796, 105, 3, 70, "Subsection",
      CellTags->{"S2.9.6", "6.1"}]},
  "6.2"->{
    Cell[126579, 2818, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.2"}]},
  "6.3"->{
    Cell[126970, 2837, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.3"}]},
  "6.4"->{
    Cell[127280, 2851, 382, 10, 70, "Text",
      CellTags->{"S2.9.6", "6.4"}]},
  "6.5"->{
    Cell[130708, 2954, 382, 9, 70, "Text",
      CellTags->{"S2.9.6", "6.5"}]},
  "6.6"->{
    Cell[131093, 2965, 171, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.6"}]},
  "6.7"->{
    Cell[131676, 2989, 114, 2, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.7"}]},
  "6.8"->{
    Cell[132143, 3007, 432, 10, 70, "Text",
      CellTags->{"S2.9.6", "6.8"}]},
  "6.9"->{
    Cell[132578, 3019, 202, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.9"}]},
  "6.10"->{
    Cell[133409, 3050, 333, 10, 70, "Text",
      CellTags->{"S2.9.6", "6.10"}]},
  "6.11"->{
    Cell[133745, 3062, 196, 6, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.11"}]},
  "6.12"->{
    Cell[134277, 3084, 156, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.12"}]},
  "6.13"->{
    Cell[134661, 3102, 159, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.13"}]},
  "6.14"->{
    Cell[135038, 3120, 393, 9, 70, "Text",
      CellTags->{"S2.9.6", "6.14"}]},
  "6.15"->{
    Cell[136811, 3173, 165, 4, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.15"}]},
  "6.16"->{
    Cell[139311, 3257, 102, 1, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.16"}]},
  "6.17"->{
    Cell[140555, 3304, 647, 17, 70, "Text",
      CellTags->{"S2.9.6", "6.17"}]},
  "6.18"->{
    Cell[141205, 3323, 215, 10, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.18"}]},
  "6.19"->{
    Cell[141654, 3348, 160, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.19"}]},
  "6.20"->{
    Cell[142048, 3368, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.6", "6.20"}]},
  "S2.9.7"->{
    Cell[142478, 3391, 85, 1, 70, "Subsection",
      CellTags->{"S2.9.7", "7.1"}],
    Cell[142566, 3394, 971, 28, 70, "DefinitionBox",
      CellTags->"S2.9.7"],
    Cell[143540, 3424, 69, 1, 70, "Caption",
      CellTags->"S2.9.7"],
    Cell[143612, 3427, 166, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.2"}],
    Cell[143803, 3435, 86, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[143892, 3439, 156, 4, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[144063, 3446, 101, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.3"}],
    Cell[144189, 3451, 81, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[144273, 3455, 546, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[144834, 3473, 162, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.4"}],
    Cell[145021, 3481, 82, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[145106, 3485, 548, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[145669, 3503, 166, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.5"}],
    Cell[145860, 3511, 98, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[145961, 3515, 497, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[146473, 3533, 1549, 47, 70, "DefinitionBox",
      CellTags->"S2.9.7"],
    Cell[148025, 3582, 92, 1, 70, "Caption",
      CellTags->"S2.9.7"],
    Cell[148120, 3585, 179, 6, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.6"}],
    Cell[148324, 3595, 75, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[148402, 3599, 130, 3, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[148547, 3605, 180, 6, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.7"}],
    Cell[148752, 3615, 81, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[148836, 3619, 271, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[149122, 3629, 101, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.8"}],
    Cell[149248, 3634, 86, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[149337, 3638, 294, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[149646, 3648, 3114, 93, 70, "DefinitionBox3Col",
      CellTags->"S2.9.7"],
    Cell[152763, 3743, 72, 1, 70, "Caption",
      CellTags->"S2.9.7"],
    Cell[152838, 3746, 159, 4, 70, "Text",
      CellTags->{"S2.9.7", "7.9"}],
    Cell[153000, 3752, 548, 15, 70, "Text",
      CellTags->{"S2.9.7", "7.10"}],
    Cell[153551, 3769, 210, 8, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.11"}],
    Cell[153786, 3781, 94, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[153883, 3785, 295, 8, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[154193, 3796, 140, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.12"}],
    Cell[154358, 3804, 118, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[154479, 3808, 306, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[154800, 3818, 194, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.13"}],
    Cell[155019, 3827, 147, 5, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[155169, 3834, 430, 13, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[155614, 3850, 756, 16, 70, "Text",
      CellTags->{"S2.9.7", "7.14"}],
    Cell[156373, 3868, 247, 7, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.15"}],
    Cell[156645, 3879, 85, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[156733, 3883, 125, 3, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[156873, 3889, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.16"}],
    Cell[157040, 3897, 138, 5, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[157181, 3904, 560, 16, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[157756, 3923, 103, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.17"}],
    Cell[157884, 3928, 119, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[158006, 3932, 574, 16, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[158595, 3951, 525, 11, 70, "Text",
      CellTags->{"S2.9.7", "7.18"}],
    Cell[159123, 3964, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.19"}],
    Cell[159321, 3973, 152, 5, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[159476, 3980, 782, 23, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[160273, 4006, 170, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.20"}],
    Cell[160468, 4015, 84, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[160555, 4019, 99, 2, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[160669, 4024, 3072, 88, 70, "DefinitionBox",
      CellTags->"S2.9.7"],
    Cell[163744, 4114, 89, 1, 70, "Caption",
      CellTags->"S2.9.7"],
    Cell[163836, 4117, 409, 7, 70, "Text",
      CellTags->{"S2.9.7", "7.21"}],
    Cell[164248, 4126, 373, 7, 70, "Text",
      CellTags->{"S2.9.7", "7.22"}],
    Cell[164624, 4135, 136, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.23"}],
    Cell[164785, 4143, 96, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[164884, 4147, 469, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[165368, 4165, 90, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.24"}],
    Cell[165483, 4170, 108, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[165594, 4174, 421, 13, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[166030, 4190, 177, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.25"}],
    Cell[166232, 4198, 107, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[166342, 4202, 525, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[166882, 4220, 228, 7, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.26"}],
    Cell[167135, 4231, 107, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[167245, 4235, 509, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[167769, 4253, 280, 11, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.27"}],
    Cell[168074, 4268, 136, 5, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[168213, 4275, 546, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[168774, 4293, 136, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.28"}],
    Cell[168935, 4301, 137, 5, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[169075, 4308, 496, 14, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[169586, 4325, 569, 22, 70, "Text",
      CellTags->{"S2.9.7", "7.29"}],
    Cell[170158, 4349, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.30"}],
    Cell[170300, 4355, 150, 5, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[170453, 4362, 554, 15, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[171022, 4380, 613, 19, 70, "DefinitionBox",
      CellTags->"S2.9.7"],
    Cell[171638, 4401, 74, 1, 70, "Caption",
      CellTags->"S2.9.7"],
    Cell[171715, 4404, 87, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.31"}],
    Cell[171827, 4409, 85, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[171915, 4413, 223, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[172153, 4423, 129, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.32"}],
    Cell[172307, 4431, 88, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[172398, 4435, 212, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[172625, 4445, 144, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.33"}],
    Cell[172794, 4453, 81, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[172878, 4457, 232, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[173125, 4467, 169, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.34"}],
    Cell[173319, 4476, 86, 2, 70, "Input",
      CellTags->"S2.9.7"],
    Cell[173408, 4480, 247, 7, 70, "Output",
      CellTags->"S2.9.7"],
    Cell[173670, 4490, 274, 8, 70, "Text",
      CellTags->{"S2.9.7", "7.35"}]},
  "7.1"->{
    Cell[142478, 3391, 85, 1, 70, "Subsection",
      CellTags->{"S2.9.7", "7.1"}]},
  "7.2"->{
    Cell[143612, 3427, 166, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.2"}]},
  "7.3"->{
    Cell[144063, 3446, 101, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.3"}]},
  "7.4"->{
    Cell[144834, 3473, 162, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.4"}]},
  "7.5"->{
    Cell[145669, 3503, 166, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.5"}]},
  "7.6"->{
    Cell[148120, 3585, 179, 6, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.6"}]},
  "7.7"->{
    Cell[148547, 3605, 180, 6, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.7"}]},
  "7.8"->{
    Cell[149122, 3629, 101, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.8"}]},
  "7.9"->{
    Cell[152838, 3746, 159, 4, 70, "Text",
      CellTags->{"S2.9.7", "7.9"}]},
  "7.10"->{
    Cell[153000, 3752, 548, 15, 70, "Text",
      CellTags->{"S2.9.7", "7.10"}]},
  "7.11"->{
    Cell[153551, 3769, 210, 8, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.11"}]},
  "7.12"->{
    Cell[154193, 3796, 140, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.12"}]},
  "7.13"->{
    Cell[154800, 3818, 194, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.13"}]},
  "7.14"->{
    Cell[155614, 3850, 756, 16, 70, "Text",
      CellTags->{"S2.9.7", "7.14"}]},
  "7.15"->{
    Cell[156373, 3868, 247, 7, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.15"}]},
  "7.16"->{
    Cell[156873, 3889, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.16"}]},
  "7.17"->{
    Cell[157756, 3923, 103, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.17"}]},
  "7.18"->{
    Cell[158595, 3951, 525, 11, 70, "Text",
      CellTags->{"S2.9.7", "7.18"}]},
  "7.19"->{
    Cell[159123, 3964, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.19"}]},
  "7.20"->{
    Cell[160273, 4006, 170, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.20"}]},
  "7.21"->{
    Cell[163836, 4117, 409, 7, 70, "Text",
      CellTags->{"S2.9.7", "7.21"}]},
  "7.22"->{
    Cell[164248, 4126, 373, 7, 70, "Text",
      CellTags->{"S2.9.7", "7.22"}]},
  "7.23"->{
    Cell[164624, 4135, 136, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.23"}]},
  "7.24"->{
    Cell[165368, 4165, 90, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.24"}]},
  "7.25"->{
    Cell[166030, 4190, 177, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.25"}]},
  "7.26"->{
    Cell[166882, 4220, 228, 7, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.26"}]},
  "7.27"->{
    Cell[167769, 4253, 280, 11, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.27"}]},
  "7.28"->{
    Cell[168774, 4293, 136, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.28"}]},
  "7.29"->{
    Cell[169586, 4325, 569, 22, 70, "Text",
      CellTags->{"S2.9.7", "7.29"}]},
  "7.30"->{
    Cell[170158, 4349, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.30"}]},
  "7.31"->{
    Cell[171715, 4404, 87, 1, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.31"}]},
  "7.32"->{
    Cell[172153, 4423, 129, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.32"}]},
  "7.33"->{
    Cell[172625, 4445, 144, 4, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.33"}]},
  "7.34"->{
    Cell[173125, 4467, 169, 5, 70, "MathCaption",
      CellTags->{"S2.9.7", "7.34"}]},
  "7.35"->{
    Cell[173670, 4490, 274, 8, 70, "Text",
      CellTags->{"S2.9.7", "7.35"}]},
  "S2.9.8"->{
    Cell[173981, 4503, 78, 1, 70, "Subsection",
      CellTags->{"S2.9.8", "8.1"}],
    Cell[174062, 4506, 628, 18, 70, "DefinitionBox",
      CellTags->"S2.9.8"],
    Cell[174693, 4526, 82, 1, 70, "Caption",
      CellTags->"S2.9.8"],
    Cell[174778, 4529, 70, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.2"}],
    Cell[174873, 4534, 97, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[174973, 4538, 142, 4, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[175130, 4545, 141, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.3"}],
    Cell[175296, 4553, 76, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[175375, 4557, 404, 13, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[175794, 4573, 134, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.4"}],
    Cell[175953, 4581, 77, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[176033, 4585, 442, 13, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[176490, 4601, 125, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.5"}],
    Cell[176640, 4609, 110, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[176753, 4613, 506, 13, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[177274, 4629, 1267, 38, 70, "DefinitionBox",
      CellTags->"S2.9.8"],
    Cell[178544, 4669, 69, 1, 70, "Caption",
      CellTags->"S2.9.8"],
    Cell[178616, 4672, 81, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.6"}],
    Cell[178722, 4677, 85, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[178810, 4681, 126, 3, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[178951, 4687, 133, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.7"}],
    Cell[179109, 4695, 78, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[179190, 4699, 398, 12, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[179603, 4714, 143, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.8"}],
    Cell[179771, 4722, 94, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[179868, 4726, 803, 23, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[180686, 4752, 190, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.9"}],
    Cell[180901, 4761, 106, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[181010, 4765, 436, 13, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[181461, 4781, 187, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.10"}],
    Cell[181673, 4790, 116, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[181792, 4794, 818, 24, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[182625, 4821, 260, 8, 70, "Text",
      CellTags->{"S2.9.8", "8.11"}],
    Cell[182888, 4831, 326, 13, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.12"}],
    Cell[183239, 4848, 94, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[183336, 4852, 374, 12, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[183725, 4867, 178, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.13"}],
    Cell[183928, 4877, 116, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[184047, 4881, 1399, 47, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[185461, 4931, 191, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.14"}],
    Cell[185677, 4941, 166, 5, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[185846, 4948, 1671, 55, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[187532, 5006, 1401, 57, 70, "Text",
      CellTags->{"S2.9.8", "8.15"}],
    Cell[188936, 5065, 225, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.16"}],
    Cell[189186, 5075, 165, 5, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[189354, 5082, 1972, 58, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[191341, 5143, 972, 35, 70, "Text",
      CellTags->{"S2.9.8", "8.17"}],
    Cell[192316, 5180, 432, 10, 70, "Text",
      CellTags->{"S2.9.8", "8.18"}],
    Cell[192751, 5192, 195, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.19"}],
    Cell[192971, 5201, 96, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[193070, 5205, 401, 13, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[193486, 5221, 377, 10, 70, "Text",
      CellTags->{"S2.9.8", "8.20"}],
    Cell[193866, 5233, 178, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.21"}],
    Cell[194069, 5242, 95, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[194167, 5246, 347, 11, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[194529, 5260, 164, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.22"}],
    Cell[194718, 5269, 121, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[194842, 5273, 823, 25, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[195680, 5301, 278, 9, 70, "Text",
      CellTags->{"S2.9.8", "8.23"}],
    Cell[195961, 5312, 259, 9, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.24"}],
    Cell[196245, 5325, 114, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[196362, 5329, 366, 12, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[196743, 5344, 2660, 83, 70, "DefinitionBox3Col",
      CellTags->"S2.9.8"],
    Cell[199406, 5429, 108, 5, 70, "Caption",
      CellTags->"S2.9.8"],
    Cell[199517, 5436, 819, 30, 70, "Text",
      CellTags->{"S2.9.8", "8.25"}],
    Cell[200339, 5468, 110, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.26"}],
    Cell[200474, 5473, 95, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[200572, 5477, 347, 12, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[200934, 5492, 81, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.27"}],
    Cell[201040, 5497, 122, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[201165, 5501, 376, 12, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[201556, 5516, 343, 7, 70, "Text",
      CellTags->{"S2.9.8", "8.28"}],
    Cell[201902, 5525, 157, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.29"}],
    Cell[202084, 5533, 118, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[202205, 5537, 368, 12, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[202588, 5552, 1325, 39, 70, "DefinitionBox",
      CellTags->"S2.9.8"],
    Cell[203916, 5593, 124, 5, 70, "Caption",
      CellTags->"S2.9.8"],
    Cell[204043, 5600, 198, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.30"}],
    Cell[204266, 5610, 123, 2, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[204392, 5614, 1541, 48, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[205948, 5665, 165, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.31"}],
    Cell[206138, 5673, 176, 5, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[206317, 5680, 519, 15, 70, "Output",
      CellTags->"S2.9.8"],
    Cell[206851, 5698, 213, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.32"}],
    Cell[207089, 5707, 168, 5, 70, "Input",
      CellTags->"S2.9.8"],
    Cell[207260, 5714, 501, 15, 70, "Output",
      CellTags->"S2.9.8"]},
  "8.1"->{
    Cell[173981, 4503, 78, 1, 70, "Subsection",
      CellTags->{"S2.9.8", "8.1"}]},
  "8.2"->{
    Cell[174778, 4529, 70, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.2"}]},
  "8.3"->{
    Cell[175130, 4545, 141, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.3"}]},
  "8.4"->{
    Cell[175794, 4573, 134, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.4"}]},
  "8.5"->{
    Cell[176490, 4601, 125, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.5"}]},
  "8.6"->{
    Cell[178616, 4672, 81, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.6"}]},
  "8.7"->{
    Cell[178951, 4687, 133, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.7"}]},
  "8.8"->{
    Cell[179603, 4714, 143, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.8"}]},
  "8.9"->{
    Cell[180686, 4752, 190, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.9"}]},
  "8.10"->{
    Cell[181461, 4781, 187, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.10"}]},
  "8.11"->{
    Cell[182625, 4821, 260, 8, 70, "Text",
      CellTags->{"S2.9.8", "8.11"}]},
  "8.12"->{
    Cell[182888, 4831, 326, 13, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.12"}]},
  "8.13"->{
    Cell[183725, 4867, 178, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.13"}]},
  "8.14"->{
    Cell[185461, 4931, 191, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.14"}]},
  "8.15"->{
    Cell[187532, 5006, 1401, 57, 70, "Text",
      CellTags->{"S2.9.8", "8.15"}]},
  "8.16"->{
    Cell[188936, 5065, 225, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.16"}]},
  "8.17"->{
    Cell[191341, 5143, 972, 35, 70, "Text",
      CellTags->{"S2.9.8", "8.17"}]},
  "8.18"->{
    Cell[192316, 5180, 432, 10, 70, "Text",
      CellTags->{"S2.9.8", "8.18"}]},
  "8.19"->{
    Cell[192751, 5192, 195, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.19"}]},
  "8.20"->{
    Cell[193486, 5221, 377, 10, 70, "Text",
      CellTags->{"S2.9.8", "8.20"}]},
  "8.21"->{
    Cell[193866, 5233, 178, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.21"}]},
  "8.22"->{
    Cell[194529, 5260, 164, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.22"}]},
  "8.23"->{
    Cell[195680, 5301, 278, 9, 70, "Text",
      CellTags->{"S2.9.8", "8.23"}]},
  "8.24"->{
    Cell[195961, 5312, 259, 9, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.24"}]},
  "8.25"->{
    Cell[199517, 5436, 819, 30, 70, "Text",
      CellTags->{"S2.9.8", "8.25"}]},
  "8.26"->{
    Cell[200339, 5468, 110, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.26"}]},
  "8.27"->{
    Cell[200934, 5492, 81, 1, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.27"}]},
  "8.28"->{
    Cell[201556, 5516, 343, 7, 70, "Text",
      CellTags->{"S2.9.8", "8.28"}]},
  "8.29"->{
    Cell[201902, 5525, 157, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.29"}]},
  "8.30"->{
    Cell[204043, 5600, 198, 6, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.30"}]},
  "8.31"->{
    Cell[205948, 5665, 165, 4, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.31"}]},
  "8.32"->{
    Cell[206851, 5698, 213, 5, 70, "MathCaption",
      CellTags->{"S2.9.8", "8.32"}]},
  "S2.9.9"->{
    Cell[207810, 5735, 85, 1, 70, "Subsection",
      CellTags->{"S2.9.9", "9.1"}],
    Cell[207898, 5738, 885, 25, 70, "DefinitionBox",
      CellTags->"S2.9.9"],
    Cell[208786, 5765, 67, 1, 70, "Caption",
      CellTags->"S2.9.9"],
    Cell[208856, 5768, 256, 9, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.2"}],
    Cell[209137, 5781, 107, 2, 70, "Input",
      CellTags->"S2.9.9"],
    Cell[209247, 5785, 257, 8, 70, "Output",
      CellTags->"S2.9.9"],
    Cell[209519, 5796, 159, 5, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.3"}],
    Cell[209703, 5805, 116, 2, 70, "Input",
      CellTags->"S2.9.9"],
    Cell[209822, 5809, 1526, 48, 70, "Output",
      CellTags->"S2.9.9"],
    Cell[211363, 5860, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.4"}],
    Cell[211482, 5865, 112, 2, 70, "Input",
      CellTags->"S2.9.9"],
    Cell[211597, 5869, 1699, 28, 70, 1597, 24, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S2.9.9"],
    Cell[213311, 5900, 2096, 63, 70, "DefinitionBox3Col",
      CellTags->"S2.9.9"],
    Cell[215410, 5965, 130, 5, 70, "Caption",
      CellTags->"S2.9.9"],
    Cell[215543, 5972, 560, 16, 70, "Text",
      CellTags->{"S2.9.9", "9.5"}],
    Cell[216106, 5990, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.6"}],
    Cell[216273, 5998, 97, 2, 70, "Input",
      CellTags->"S2.9.9"],
    Cell[216373, 6002, 182, 6, 70, "Output",
      CellTags->"S2.9.9"],
    Cell[216570, 6011, 565, 19, 70, "Text",
      CellTags->{"S2.9.9", "9.7"}]},
  "9.1"->{
    Cell[207810, 5735, 85, 1, 70, "Subsection",
      CellTags->{"S2.9.9", "9.1"}]},
  "9.2"->{
    Cell[208856, 5768, 256, 9, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.2"}]},
  "9.3"->{
    Cell[209519, 5796, 159, 5, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.3"}]},
  "9.4"->{
    Cell[211363, 5860, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.4"}]},
  "9.5"->{
    Cell[215543, 5972, 560, 16, 70, "Text",
      CellTags->{"S2.9.9", "9.5"}]},
  "9.6"->{
    Cell[216106, 5990, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.9", "9.6"}]},
  "9.7"->{
    Cell[216570, 6011, 565, 19, 70, "Text",
      CellTags->{"S2.9.9", "9.7"}]},
  "S2.9.10"->{
    Cell[217172, 6035, 97, 1, 70, "Subsection",
      CellTags->{"S2.9.10", "10.1"}],
    Cell[217272, 6038, 358, 8, 70, "Text",
      CellTags->{"S2.9.10", "10.2"}],
    Cell[217633, 6048, 214, 9, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.3"}],
    Cell[217872, 6061, 79, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[217954, 6065, 105, 3, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[218074, 6071, 148, 4, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.4"}],
    Cell[218247, 6079, 79, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[218329, 6083, 127, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[218471, 6090, 528, 16, 70, "DefinitionBox",
      CellTags->"S2.9.10"],
    Cell[219002, 6108, 79, 1, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[219084, 6111, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.5"}],
    Cell[219203, 6116, 109, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[219315, 6120, 127, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[219457, 6127, 108, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.6"}],
    Cell[219590, 6132, 106, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[219699, 6136, 126, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[219840, 6143, 96, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.7"}],
    Cell[219961, 6148, 154, 5, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[220118, 6155, 135, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[220268, 6162, 8239, 255, 70, "DefinitionBox",
      CellTags->"S2.9.10"],
    Cell[228510, 6419, 64, 1, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[228577, 6422, 96, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.8"}],
    Cell[228698, 6427, 112, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[228813, 6431, 135, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[228963, 6438, 105, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.9"}],
    Cell[229093, 6443, 117, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[229213, 6447, 129, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[229357, 6454, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.10"}],
    Cell[229514, 6462, 106, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[229623, 6466, 129, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[229767, 6473, 1685, 51, 70, "DefinitionBox",
      CellTags->"S2.9.10"],
    Cell[231455, 6526, 75, 1, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[231533, 6529, 109, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.11"}],
    Cell[231667, 6534, 115, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[231785, 6538, 143, 5, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[231943, 6546, 111, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.12"}],
    Cell[232079, 6551, 161, 5, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[232243, 6558, 272, 10, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[232530, 6571, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.13"}],
    Cell[232659, 6576, 92, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[232754, 6580, 301, 11, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[233070, 6594, 1079, 33, 70, "DefinitionBox",
      CellTags->"S2.9.10"],
    Cell[234152, 6629, 77, 1, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[234232, 6632, 390, 11, 70, "Text",
      CellTags->{"S2.9.10", "10.14"}],
    Cell[234625, 6645, 144, 5, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.15"}],
    Cell[234794, 6654, 122, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[234919, 6658, 171, 6, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[235105, 6667, 186, 5, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.16"}],
    Cell[235316, 6676, 112, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[235431, 6680, 161, 6, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[235607, 6689, 135, 4, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.17"}],
    Cell[235767, 6697, 149, 5, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[235919, 6704, 201, 7, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[236135, 6714, 400, 9, 70, "Text",
      CellTags->{"S2.9.10", "10.18"}],
    Cell[236538, 6725, 1964, 61, 70, "DefinitionBox",
      CellTags->"S2.9.10"],
    Cell[238505, 6788, 83, 1, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[238591, 6791, 222, 8, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.19"}],
    Cell[238838, 6803, 109, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[238950, 6807, 127, 4, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[239092, 6814, 96, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.20"}],
    Cell[239213, 6819, 94, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[239310, 6823, 81, 2, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[239406, 6828, 228, 8, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.21"}],
    Cell[239659, 6840, 149, 5, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[239811, 6847, 173, 6, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[239999, 6856, 257, 9, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.22"}],
    Cell[240281, 6869, 94, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[240378, 6873, 87, 2, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[240480, 6878, 449, 11, 70, "Text",
      CellTags->{"S2.9.10", "10.23"}],
    Cell[240932, 6891, 2357, 70, 70, "DefinitionBox3Col",
      CellTags->"S2.9.10"],
    Cell[243292, 6963, 135, 5, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[243430, 6970, 843, 24, 70, "Text",
      CellTags->{"S2.9.10", "10.24"}],
    Cell[244276, 6996, 485, 15, 70, "Text",
      CellTags->{"S2.9.10", "10.25"}],
    Cell[244764, 7013, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.26"}],
    Cell[244950, 7022, 125, 2, 70, "Input",
      CellTags->"S2.9.10"],
    Cell[245078, 7026, 87, 3, 70, "Output",
      CellTags->"S2.9.10"],
    Cell[245180, 7032, 611, 18, 70, "DefinitionBox",
      CellTags->"S2.9.10"],
    Cell[245794, 7052, 70, 1, 70, "Caption",
      CellTags->"S2.9.10"],
    Cell[245867, 7055, 761, 20, 70, "Text",
      CellTags->{"S2.9.10", "10.27"}],
    Cell[246631, 7077, 255, 9, 70, "Text",
      CellTags->{"S2.9.10", "10.28"}]},
  "10.1"->{
    Cell[217172, 6035, 97, 1, 70, "Subsection",
      CellTags->{"S2.9.10", "10.1"}]},
  "10.2"->{
    Cell[217272, 6038, 358, 8, 70, "Text",
      CellTags->{"S2.9.10", "10.2"}]},
  "10.3"->{
    Cell[217633, 6048, 214, 9, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.3"}]},
  "10.4"->{
    Cell[218074, 6071, 148, 4, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.4"}]},
  "10.5"->{
    Cell[219084, 6111, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.5"}]},
  "10.6"->{
    Cell[219457, 6127, 108, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.6"}]},
  "10.7"->{
    Cell[219840, 6143, 96, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.7"}]},
  "10.8"->{
    Cell[228577, 6422, 96, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.8"}]},
  "10.9"->{
    Cell[228963, 6438, 105, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.9"}]},
  "10.10"->{
    Cell[229357, 6454, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.10"}]},
  "10.11"->{
    Cell[231533, 6529, 109, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.11"}]},
  "10.12"->{
    Cell[231943, 6546, 111, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.12"}]},
  "10.13"->{
    Cell[232530, 6571, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.13"}]},
  "10.14"->{
    Cell[234232, 6632, 390, 11, 70, "Text",
      CellTags->{"S2.9.10", "10.14"}]},
  "10.15"->{
    Cell[234625, 6645, 144, 5, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.15"}]},
  "10.16"->{
    Cell[235105, 6667, 186, 5, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.16"}]},
  "10.17"->{
    Cell[235607, 6689, 135, 4, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.17"}]},
  "10.18"->{
    Cell[236135, 6714, 400, 9, 70, "Text",
      CellTags->{"S2.9.10", "10.18"}]},
  "10.19"->{
    Cell[238591, 6791, 222, 8, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.19"}]},
  "10.20"->{
    Cell[239092, 6814, 96, 1, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.20"}]},
  "10.21"->{
    Cell[239406, 6828, 228, 8, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.21"}]},
  "10.22"->{
    Cell[239999, 6856, 257, 9, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.22"}]},
  "10.23"->{
    Cell[240480, 6878, 449, 11, 70, "Text",
      CellTags->{"S2.9.10", "10.23"}]},
  "10.24"->{
    Cell[243430, 6970, 843, 24, 70, "Text",
      CellTags->{"S2.9.10", "10.24"}]},
  "10.25"->{
    Cell[244276, 6996, 485, 15, 70, "Text",
      CellTags->{"S2.9.10", "10.25"}]},
  "10.26"->{
    Cell[244764, 7013, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.10", "10.26"}]},
  "10.27"->{
    Cell[245867, 7055, 761, 20, 70, "Text",
      CellTags->{"S2.9.10", "10.27"}]},
  "10.28"->{
    Cell[246631, 7077, 255, 9, 70, "Text",
      CellTags->{"S2.9.10", "10.28"}]},
  "S2.9.11"->{
    Cell[246923, 7091, 93, 1, 70, "Subsection",
      CellTags->{"S2.9.11", "11.1"}],
    Cell[247019, 7094, 389, 7, 70, "Text",
      CellTags->{"S2.9.11", "11.2"}],
    Cell[247411, 7103, 3747, 114, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[251161, 7219, 106, 5, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[251270, 7226, 90, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.3"}],
    Cell[251363, 7229, 103, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[251469, 7233, 186, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.4"}],
    Cell[251680, 7242, 90, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[251773, 7246, 269, 9, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[252057, 7258, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.5"}],
    Cell[252176, 7263, 115, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[252294, 7267, 304, 10, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[252613, 7280, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.6"}],
    Cell[252780, 7288, 139, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[252922, 7295, 316, 10, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[253253, 7308, 95, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.7"}],
    Cell[253373, 7313, 115, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[253491, 7317, 302, 10, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[253808, 7330, 102, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.8"}],
    Cell[253935, 7335, 110, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[254048, 7339, 297, 10, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[254360, 7352, 277, 8, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.9"}],
    Cell[254662, 7364, 161, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[254826, 7371, 354, 13, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[255195, 7387, 1794, 51, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[256992, 7440, 128, 5, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[257123, 7447, 535, 15, 70, "Text",
      CellTags->{"S2.9.11", "11.10"}],
    Cell[257661, 7464, 583, 14, 70, "Text",
      CellTags->{"S2.9.11", "11.11"}],
    Cell[258247, 7480, 1596, 47, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[259846, 7529, 125, 5, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[259974, 7536, 166, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.12"}],
    Cell[260165, 7545, 142, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[260310, 7552, 171, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[260496, 7561, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.13"}],
    Cell[260651, 7569, 165, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[260819, 7576, 202, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[261036, 7586, 606, 15, 70, "Text",
      CellTags->{"S2.9.11", "11.14"}],
    Cell[261645, 7603, 190, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.15"}],
    Cell[261860, 7612, 120, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[261983, 7616, 172, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[262170, 7625, 140, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.16"}],
    Cell[262335, 7633, 153, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[262491, 7640, 203, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[262709, 7650, 616, 19, 70, "Text",
      CellTags->{"S2.9.11", "11.17"}],
    Cell[263328, 7671, 711, 23, 70, "Text",
      CellTags->{"S2.9.11", "11.18"}],
    Cell[264042, 7696, 482, 14, 70, "Text",
      CellTags->{"S2.9.11", "11.19"}],
    Cell[264527, 7712, 222, 7, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.20"}],
    Cell[264774, 7723, 180, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[264957, 7730, 391, 14, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[265363, 7747, 2178, 68, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[267544, 7817, 128, 5, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[267675, 7824, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.21"}],
    Cell[267832, 7832, 128, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[267963, 7836, 177, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[268155, 7845, 203, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.22"}],
    Cell[268383, 7854, 161, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[268547, 7861, 241, 9, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[268803, 7873, 152, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.23"}],
    Cell[268980, 7882, 143, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[269126, 7889, 225, 9, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[269366, 7901, 102, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.24"}],
    Cell[269493, 7906, 168, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[269664, 7913, 264, 10, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[269943, 7926, 258, 9, 70, "Text",
      CellTags->{"S2.9.11", "11.25"}],
    Cell[270204, 7937, 995, 29, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[271202, 7968, 61, 1, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[271266, 7971, 8322, 223, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[279591, 8196, 226, 6, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[279820, 8204, 845, 21, 70, "Text",
      CellTags->{"S2.9.11", "11.26"}],
    Cell[280668, 8227, 262, 8, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.27"}],
    Cell[280955, 8239, 133, 3, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[281091, 8244, 135, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[281241, 8251, 153, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.28"}],
    Cell[281419, 8259, 192, 6, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[281614, 8267, 168, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[281797, 8274, 612, 18, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[282412, 8294, 131, 5, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[282546, 8301, 176, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.29"}],
    Cell[282747, 8310, 171, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[282921, 8317, 180, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[283116, 8326, 1029, 23, 70, "Text",
      CellTags->{"S2.9.11", "11.30"}],
    Cell[284148, 8351, 1495, 44, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[285646, 8397, 75, 1, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[285724, 8400, 170, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.31"}],
    Cell[285919, 8409, 176, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[286098, 8416, 221, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[286334, 8426, 161, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.32"}],
    Cell[286520, 8434, 161, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[286684, 8441, 213, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[286912, 8451, 672, 15, 70, "Text",
      CellTags->{"S2.9.11", "11.33"}],
    Cell[287587, 8468, 606, 18, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[288196, 8488, 91, 1, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[288290, 8491, 291, 8, 70, "Text",
      CellTags->{"S2.9.11", "11.34"}],
    Cell[288584, 8501, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.35"}],
    Cell[288764, 8510, 151, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[288918, 8517, 199, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[289132, 8527, 474, 10, 70, "Text",
      CellTags->{"S2.9.11", "11.36"}],
    Cell[289609, 8539, 140, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.37"}],
    Cell[289774, 8547, 173, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[289950, 8554, 144, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[290109, 8561, 1610, 48, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[291722, 8611, 136, 4, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[291861, 8617, 233, 7, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.38"}],
    Cell[292119, 8628, 127, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[292249, 8632, 226, 9, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[292490, 8644, 146, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.39"}],
    Cell[292661, 8652, 144, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[292808, 8659, 231, 9, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[293054, 8671, 205, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.40"}],
    Cell[293284, 8680, 115, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[293402, 8684, 289, 11, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[293706, 8698, 111, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.41"}],
    Cell[293842, 8703, 155, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[294000, 8710, 239, 9, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[294254, 8722, 183, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.42"}],
    Cell[294462, 8731, 119, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[294584, 8735, 380, 13, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[294979, 8751, 270, 6, 70, "Text",
      CellTags->{"S2.9.11", "11.43"}],
    Cell[295252, 8759, 383, 9, 70, "DefinitionBox",
      CellTags->"S2.9.11"],
    Cell[295638, 8770, 92, 1, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[295733, 8773, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.44"}],
    Cell[295919, 8782, 127, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[296049, 8786, 145, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[296209, 8793, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.45"}],
    Cell[296376, 8801, 165, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[296544, 8808, 212, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[296771, 8818, 133, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.46"}],
    Cell[296929, 8826, 128, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[297060, 8830, 176, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[297251, 8839, 1362, 42, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[298616, 8883, 158, 4, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[298777, 8889, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.47"}],
    Cell[298963, 8898, 88, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[299054, 8902, 186, 5, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[299255, 8910, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.48"}],
    Cell[299410, 8918, 82, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[299495, 8922, 148, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[299658, 8929, 174, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.49"}],
    Cell[299857, 8938, 118, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[299978, 8942, 199, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[300192, 8951, 158, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.50"}],
    Cell[300375, 8959, 110, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[300488, 8963, 191, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[300694, 8972, 431, 9, 70, "Text",
      CellTags->{"S2.9.11", "11.51"}],
    Cell[301128, 8983, 145, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.52"}],
    Cell[301298, 8991, 174, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[301475, 8998, 137, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[301627, 9005, 176, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.53"}],
    Cell[301828, 9014, 140, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[301971, 9021, 200, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[302186, 9030, 723, 24, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[302912, 9056, 137, 5, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[303052, 9063, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.54"}],
    Cell[303219, 9071, 86, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[303308, 9075, 108, 3, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[303431, 9081, 189, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.55"}],
    Cell[303645, 9089, 69, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[303717, 9093, 115, 3, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[303847, 9099, 218, 9, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.56"}],
    Cell[304090, 9112, 161, 5, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[304254, 9119, 198, 6, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[304467, 9128, 200, 7, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.57"}],
    Cell[304692, 9139, 102, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[304797, 9143, 227, 7, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[305039, 9153, 461, 12, 70, "Text",
      CellTags->{"S2.9.11", "11.58"}],
    Cell[305503, 9167, 685, 20, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[306191, 9189, 74, 1, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[306268, 9192, 279, 6, 70, "Text",
      CellTags->{"S2.9.11", "11.59"}],
    Cell[306550, 9200, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.60"}],
    Cell[306705, 9208, 101, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[306809, 9212, 189, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[307013, 9219, 91, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.61"}],
    Cell[307129, 9224, 102, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[307234, 9228, 275, 5, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[307524, 9236, 327, 8, 70, "Text",
      CellTags->{"S2.9.11", "11.62"}],
    Cell[307854, 9246, 403, 11, 70, "Text",
      CellTags->{"S2.9.11", "11.63"}],
    Cell[308260, 9259, 816, 17, 70, "Text",
      CellTags->{"S2.9.11", "11.64"}],
    Cell[309079, 9278, 1901, 61, 70, "DefinitionBox3Col",
      CellTags->"S2.9.11"],
    Cell[310983, 9341, 84, 1, 70, "Caption",
      CellTags->"S2.9.11"],
    Cell[311070, 9344, 282, 7, 70, "Text",
      CellTags->{"S2.9.11", "11.65"}],
    Cell[311355, 9353, 121, 2, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.66"}],
    Cell[311501, 9359, 75, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[311579, 9363, 201, 4, 70, "Output",
      CellTags->"S2.9.11"],
    Cell[311795, 9370, 103, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.67"}],
    Cell[311923, 9375, 85, 2, 70, "Input",
      CellTags->"S2.9.11"],
    Cell[312011, 9379, 191, 5, 70, "Output",
      CellTags->"S2.9.11"]},
  "11.1"->{
    Cell[246923, 7091, 93, 1, 70, "Subsection",
      CellTags->{"S2.9.11", "11.1"}]},
  "11.2"->{
    Cell[247019, 7094, 389, 7, 70, "Text",
      CellTags->{"S2.9.11", "11.2"}]},
  "11.3"->{
    Cell[251270, 7226, 90, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.3"}]},
  "11.4"->{
    Cell[251469, 7233, 186, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.4"}]},
  "11.5"->{
    Cell[252057, 7258, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.5"}]},
  "11.6"->{
    Cell[252613, 7280, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.6"}]},
  "11.7"->{
    Cell[253253, 7308, 95, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.7"}]},
  "11.8"->{
    Cell[253808, 7330, 102, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.8"}]},
  "11.9"->{
    Cell[254360, 7352, 277, 8, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.9"}]},
  "11.10"->{
    Cell[257123, 7447, 535, 15, 70, "Text",
      CellTags->{"S2.9.11", "11.10"}]},
  "11.11"->{
    Cell[257661, 7464, 583, 14, 70, "Text",
      CellTags->{"S2.9.11", "11.11"}]},
  "11.12"->{
    Cell[259974, 7536, 166, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.12"}]},
  "11.13"->{
    Cell[260496, 7561, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.13"}]},
  "11.14"->{
    Cell[261036, 7586, 606, 15, 70, "Text",
      CellTags->{"S2.9.11", "11.14"}]},
  "11.15"->{
    Cell[261645, 7603, 190, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.15"}]},
  "11.16"->{
    Cell[262170, 7625, 140, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.16"}]},
  "11.17"->{
    Cell[262709, 7650, 616, 19, 70, "Text",
      CellTags->{"S2.9.11", "11.17"}]},
  "11.18"->{
    Cell[263328, 7671, 711, 23, 70, "Text",
      CellTags->{"S2.9.11", "11.18"}]},
  "11.19"->{
    Cell[264042, 7696, 482, 14, 70, "Text",
      CellTags->{"S2.9.11", "11.19"}]},
  "11.20"->{
    Cell[264527, 7712, 222, 7, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.20"}]},
  "11.21"->{
    Cell[267675, 7824, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.21"}]},
  "11.22"->{
    Cell[268155, 7845, 203, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.22"}]},
  "11.23"->{
    Cell[268803, 7873, 152, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.23"}]},
  "11.24"->{
    Cell[269366, 7901, 102, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.24"}]},
  "11.25"->{
    Cell[269943, 7926, 258, 9, 70, "Text",
      CellTags->{"S2.9.11", "11.25"}]},
  "11.26"->{
    Cell[279820, 8204, 845, 21, 70, "Text",
      CellTags->{"S2.9.11", "11.26"}]},
  "11.27"->{
    Cell[280668, 8227, 262, 8, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.27"}]},
  "11.28"->{
    Cell[281241, 8251, 153, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.28"}]},
  "11.29"->{
    Cell[282546, 8301, 176, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.29"}]},
  "11.30"->{
    Cell[283116, 8326, 1029, 23, 70, "Text",
      CellTags->{"S2.9.11", "11.30"}]},
  "11.31"->{
    Cell[285724, 8400, 170, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.31"}]},
  "11.32"->{
    Cell[286334, 8426, 161, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.32"}]},
  "11.33"->{
    Cell[286912, 8451, 672, 15, 70, "Text",
      CellTags->{"S2.9.11", "11.33"}]},
  "11.34"->{
    Cell[288290, 8491, 291, 8, 70, "Text",
      CellTags->{"S2.9.11", "11.34"}]},
  "11.35"->{
    Cell[288584, 8501, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.35"}]},
  "11.36"->{
    Cell[289132, 8527, 474, 10, 70, "Text",
      CellTags->{"S2.9.11", "11.36"}]},
  "11.37"->{
    Cell[289609, 8539, 140, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.37"}]},
  "11.38"->{
    Cell[291861, 8617, 233, 7, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.38"}]},
  "11.39"->{
    Cell[292490, 8644, 146, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.39"}]},
  "11.40"->{
    Cell[293054, 8671, 205, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.40"}]},
  "11.41"->{
    Cell[293706, 8698, 111, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.41"}]},
  "11.42"->{
    Cell[294254, 8722, 183, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.42"}]},
  "11.43"->{
    Cell[294979, 8751, 270, 6, 70, "Text",
      CellTags->{"S2.9.11", "11.43"}]},
  "11.44"->{
    Cell[295733, 8773, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.44"}]},
  "11.45"->{
    Cell[296209, 8793, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.45"}]},
  "11.46"->{
    Cell[296771, 8818, 133, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.46"}]},
  "11.47"->{
    Cell[298777, 8889, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.47"}]},
  "11.48"->{
    Cell[299255, 8910, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.48"}]},
  "11.49"->{
    Cell[299658, 8929, 174, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.49"}]},
  "11.50"->{
    Cell[300192, 8951, 158, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.50"}]},
  "11.51"->{
    Cell[300694, 8972, 431, 9, 70, "Text",
      CellTags->{"S2.9.11", "11.51"}]},
  "11.52"->{
    Cell[301128, 8983, 145, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.52"}]},
  "11.53"->{
    Cell[301627, 9005, 176, 5, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.53"}]},
  "11.54"->{
    Cell[303052, 9063, 142, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.54"}]},
  "11.55"->{
    Cell[303431, 9081, 189, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.55"}]},
  "11.56"->{
    Cell[303847, 9099, 218, 9, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.56"}]},
  "11.57"->{
    Cell[304467, 9128, 200, 7, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.57"}]},
  "11.58"->{
    Cell[305039, 9153, 461, 12, 70, "Text",
      CellTags->{"S2.9.11", "11.58"}]},
  "11.59"->{
    Cell[306268, 9192, 279, 6, 70, "Text",
      CellTags->{"S2.9.11", "11.59"}]},
  "11.60"->{
    Cell[306550, 9200, 130, 4, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.60"}]},
  "11.61"->{
    Cell[307013, 9219, 91, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.61"}]},
  "11.62"->{
    Cell[307524, 9236, 327, 8, 70, "Text",
      CellTags->{"S2.9.11", "11.62"}]},
  "11.63"->{
    Cell[307854, 9246, 403, 11, 70, "Text",
      CellTags->{"S2.9.11", "11.63"}]},
  "11.64"->{
    Cell[308260, 9259, 816, 17, 70, "Text",
      CellTags->{"S2.9.11", "11.64"}]},
  "11.65"->{
    Cell[311070, 9344, 282, 7, 70, "Text",
      CellTags->{"S2.9.11", "11.65"}]},
  "11.66"->{
    Cell[311355, 9353, 121, 2, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.66"}]},
  "11.67"->{
    Cell[311795, 9370, 103, 1, 70, "MathCaption",
      CellTags->{"S2.9.11", "11.67"}]},
  "S2.9.12"->{
    Cell[312251, 9390, 92, 1, 70, "Subsection",
      CellTags->{"S2.9.12", "12.1"}],
    Cell[312346, 9393, 280, 6, 70, "Text",
      CellTags->{"S2.9.12", "12.2"}],
    Cell[312629, 9401, 199, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.3"}],
    Cell[312853, 9412, 114, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[312970, 9416, 95, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[313080, 9422, 133, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.4"}],
    Cell[313238, 9431, 80, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[313321, 9435, 106, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[313442, 9441, 177, 6, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.5"}],
    Cell[313644, 9451, 92, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[313739, 9455, 245, 8, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[313999, 9466, 222, 6, 70, "Text",
      CellTags->{"S2.9.12", "12.6"}],
    Cell[314224, 9474, 142, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.7"}],
    Cell[314391, 9483, 80, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[314474, 9487, 106, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[314595, 9493, 166, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.8"}],
    Cell[314786, 9502, 83, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[314872, 9506, 86, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[314973, 9512, 98, 1, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.9"}],
    Cell[315096, 9517, 95, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[315194, 9521, 245, 8, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[315454, 9532, 737, 22, 70, "DefinitionBox",
      CellTags->"S2.9.12"],
    Cell[316194, 9556, 114, 4, 70, "Caption",
      CellTags->"S2.9.12"],
    Cell[316311, 9562, 736, 20, 70, "Text",
      CellTags->{"S2.9.12", "12.10"}],
    Cell[317050, 9584, 664, 23, 70, "Text",
      CellTags->{"S2.9.12", "12.11"}],
    Cell[317717, 9609, 723, 20, 70, "DefinitionBox",
      CellTags->"S2.9.12"],
    Cell[318443, 9631, 113, 4, 70, "Caption",
      CellTags->"S2.9.12"],
    Cell[318559, 9637, 569, 16, 70, "Text",
      CellTags->{"S2.9.12", "12.12"}],
    Cell[319131, 9655, 152, 4, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.13"}],
    Cell[319308, 9663, 84, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[319395, 9667, 96, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[319506, 9673, 198, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.14"}],
    Cell[319729, 9684, 87, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[319819, 9688, 98, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[319932, 9694, 95, 1, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.15"}],
    Cell[320052, 9699, 113, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[320168, 9703, 120, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[320303, 9709, 12884, 369, 70, "DefinitionBox",
      CellTags->"S2.9.12"],
    Cell[333190, 10080, 65, 1, 70, "Caption",
      CellTags->"S2.9.12"],
    Cell[333258, 10083, 506, 17, 70, "Text",
      CellTags->{"S2.9.12", "12.16"}],
    Cell[333767, 10102, 116, 2, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.17"}],
    Cell[333908, 10108, 102, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[334013, 10112, 137, 4, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[334165, 10119, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.18"}],
    Cell[334307, 10125, 100, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[334410, 10129, 131, 4, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[334556, 10136, 226, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.19"}],
    Cell[334807, 10147, 106, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[334916, 10151, 135, 4, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[335066, 10158, 237, 9, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.20"}],
    Cell[335328, 10171, 91, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[335422, 10175, 124, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[335561, 10181, 683, 22, 70, "Text",
      CellTags->{"S2.9.12", "12.21"}],
    Cell[336247, 10205, 243, 11, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.22"}],
    Cell[336515, 10220, 91, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[336609, 10224, 276, 8, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[336900, 10235, 151, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.23"}],
    Cell[337076, 10244, 93, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[337172, 10248, 276, 8, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[337463, 10259, 116, 4, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.24"}],
    Cell[337604, 10267, 99, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[337706, 10271, 305, 9, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[338026, 10283, 144, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.25"}],
    Cell[338195, 10292, 94, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[338292, 10296, 333, 10, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[338640, 10309, 221, 6, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.26"}],
    Cell[338886, 10319, 92, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[338981, 10323, 310, 9, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[339306, 10335, 535, 18, 70, "Text",
      CellTags->{"S2.9.12", "12.27"}],
    Cell[339844, 10355, 128, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.28"}],
    Cell[339997, 10364, 135, 3, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[340135, 10369, 184, 7, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[340334, 10379, 129, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.29"}],
    Cell[340488, 10388, 134, 3, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[340625, 10393, 170, 6, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[340810, 10402, 575, 21, 70, "Text",
      CellTags->{"S2.9.12", "12.30"}],
    Cell[341388, 10425, 400, 17, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.31"}],
    Cell[341813, 10446, 206, 6, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[342022, 10454, 347, 12, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[342384, 10469, 398, 11, 70, "Text",
      CellTags->{"S2.9.12", "12.32"}],
    Cell[342785, 10482, 915, 26, 70, "DefinitionBox",
      CellTags->"S2.9.12"],
    Cell[343703, 10510, 84, 1, 70, "Caption",
      CellTags->"S2.9.12"],
    Cell[343790, 10513, 215, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.33"}],
    Cell[344030, 10524, 83, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[344116, 10528, 97, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[344228, 10534, 218, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.34"}],
    Cell[344471, 10545, 101, 2, 70, "Input",
      CellTags->"S2.9.12"],
    Cell[344575, 10549, 91, 3, 70, "Output",
      CellTags->"S2.9.12"],
    Cell[344681, 10555, 458, 8, 70, "Text",
      CellTags->{"S2.9.12", "12.35"}]},
  "12.1"->{
    Cell[312251, 9390, 92, 1, 70, "Subsection",
      CellTags->{"S2.9.12", "12.1"}]},
  "12.2"->{
    Cell[312346, 9393, 280, 6, 70, "Text",
      CellTags->{"S2.9.12", "12.2"}]},
  "12.3"->{
    Cell[312629, 9401, 199, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.3"}]},
  "12.4"->{
    Cell[313080, 9422, 133, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.4"}]},
  "12.5"->{
    Cell[313442, 9441, 177, 6, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.5"}]},
  "12.6"->{
    Cell[313999, 9466, 222, 6, 70, "Text",
      CellTags->{"S2.9.12", "12.6"}]},
  "12.7"->{
    Cell[314224, 9474, 142, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.7"}]},
  "12.8"->{
    Cell[314595, 9493, 166, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.8"}]},
  "12.9"->{
    Cell[314973, 9512, 98, 1, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.9"}]},
  "12.10"->{
    Cell[316311, 9562, 736, 20, 70, "Text",
      CellTags->{"S2.9.12", "12.10"}]},
  "12.11"->{
    Cell[317050, 9584, 664, 23, 70, "Text",
      CellTags->{"S2.9.12", "12.11"}]},
  "12.12"->{
    Cell[318559, 9637, 569, 16, 70, "Text",
      CellTags->{"S2.9.12", "12.12"}]},
  "12.13"->{
    Cell[319131, 9655, 152, 4, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.13"}]},
  "12.14"->{
    Cell[319506, 9673, 198, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.14"}]},
  "12.15"->{
    Cell[319932, 9694, 95, 1, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.15"}]},
  "12.16"->{
    Cell[333258, 10083, 506, 17, 70, "Text",
      CellTags->{"S2.9.12", "12.16"}]},
  "12.17"->{
    Cell[333767, 10102, 116, 2, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.17"}]},
  "12.18"->{
    Cell[334165, 10119, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.18"}]},
  "12.19"->{
    Cell[334556, 10136, 226, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.19"}]},
  "12.20"->{
    Cell[335066, 10158, 237, 9, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.20"}]},
  "12.21"->{
    Cell[335561, 10181, 683, 22, 70, "Text",
      CellTags->{"S2.9.12", "12.21"}]},
  "12.22"->{
    Cell[336247, 10205, 243, 11, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.22"}]},
  "12.23"->{
    Cell[336900, 10235, 151, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.23"}]},
  "12.24"->{
    Cell[337463, 10259, 116, 4, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.24"}]},
  "12.25"->{
    Cell[338026, 10283, 144, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.25"}]},
  "12.26"->{
    Cell[338640, 10309, 221, 6, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.26"}]},
  "12.27"->{
    Cell[339306, 10335, 535, 18, 70, "Text",
      CellTags->{"S2.9.12", "12.27"}]},
  "12.28"->{
    Cell[339844, 10355, 128, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.28"}]},
  "12.29"->{
    Cell[340334, 10379, 129, 5, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.29"}]},
  "12.30"->{
    Cell[340810, 10402, 575, 21, 70, "Text",
      CellTags->{"S2.9.12", "12.30"}]},
  "12.31"->{
    Cell[341388, 10425, 400, 17, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.31"}]},
  "12.32"->{
    Cell[342384, 10469, 398, 11, 70, "Text",
      CellTags->{"S2.9.12", "12.32"}]},
  "12.33"->{
    Cell[343790, 10513, 215, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.33"}]},
  "12.34"->{
    Cell[344228, 10534, 218, 7, 70, "MathCaption",
      CellTags->{"S2.9.12", "12.34"}]},
  "12.35"->{
    Cell[344681, 10555, 458, 8, 70, "Text",
      CellTags->{"S2.9.12", "12.35"}]},
  "S2.9.13"->{
    Cell[345176, 10568, 111, 1, 70, "Subsection",
      CellTags->{"S2.9.13", "13.1"}],
    Cell[345290, 10571, 2452, 75, 70, "DefinitionBox",
      CellTags->"S2.9.13"],
    Cell[347745, 10648, 93, 1, 70, "Caption",
      CellTags->"S2.9.13"],
    Cell[347841, 10651, 85, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.2"}],
    Cell[347951, 10656, 74, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[348028, 10660, 93, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[348136, 10666, 156, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.3"}],
    Cell[348317, 10675, 95, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[348415, 10679, 93, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[348523, 10685, 157, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.4"}],
    Cell[348705, 10694, 76, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[348784, 10698, 249, 8, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[349048, 10709, 197, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.5"}],
    Cell[349270, 10718, 110, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[349383, 10722, 262, 8, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[349660, 10733, 131, 4, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.6"}],
    Cell[349816, 10741, 97, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[349916, 10745, 156, 4, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[350087, 10752, 295, 7, 70, "Text",
      CellTags->{"S2.9.13", "13.7"}],
    Cell[350385, 10761, 199, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.8"}],
    Cell[350609, 10770, 96, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[350708, 10774, 99, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[350822, 10780, 182, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.9"}],
    Cell[351029, 10789, 76, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[351108, 10793, 256, 8, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[351379, 10804, 107, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.10"}],
    Cell[351511, 10809, 114, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[351628, 10813, 201, 6, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[351844, 10822, 243, 6, 70, "Text",
      CellTags->{"S2.9.13", "13.11"}],
    Cell[352090, 10830, 200, 7, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.12"}],
    Cell[352315, 10841, 123, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[352441, 10845, 95, 2, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[352551, 10850, 781, 23, 70, "DefinitionBox",
      CellTags->"S2.9.13"],
    Cell[353335, 10875, 122, 5, 70, "Caption",
      CellTags->"S2.9.13"],
    Cell[353460, 10882, 154, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.13"}],
    Cell[353639, 10891, 93, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[353735, 10895, 94, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[353844, 10901, 159, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.14"}],
    Cell[354028, 10910, 165, 5, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[354196, 10917, 94, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[354305, 10923, 146, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.15"}],
    Cell[354476, 10932, 99, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[354578, 10936, 94, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[354687, 10942, 81, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.16"}],
    Cell[354793, 10947, 103, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[354899, 10951, 157, 4, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[355071, 10958, 84, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.17"}],
    Cell[355180, 10963, 106, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[355289, 10967, 94, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[355398, 10973, 156, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.18"}],
    Cell[355579, 10982, 118, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[355700, 10986, 100, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[355815, 10992, 719, 22, 70, "DefinitionBox",
      CellTags->"S2.9.13"],
    Cell[356537, 11016, 91, 1, 70, "Caption",
      CellTags->"S2.9.13"],
    Cell[356631, 11019, 118, 2, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.19"}],
    Cell[356774, 11025, 89, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[356866, 11029, 84, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[356965, 11035, 205, 7, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.20"}],
    Cell[357195, 11046, 109, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[357307, 11050, 94, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[357416, 11056, 176, 7, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.21"}],
    Cell[357617, 11067, 80, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[357700, 11071, 84, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[357799, 11077, 897, 26, 70, "DefinitionBox",
      CellTags->"S2.9.13"],
    Cell[358699, 11105, 83, 1, 70, "Caption",
      CellTags->"S2.9.13"],
    Cell[358785, 11108, 353, 9, 70, "Text",
      CellTags->{"S2.9.13", "13.22"}],
    Cell[359141, 11119, 196, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.23"}],
    Cell[359362, 11128, 91, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[359456, 11132, 163, 4, 70, "Message",
      CellTags->"S2.9.13"],
    Cell[359622, 11138, 90, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[359727, 11144, 238, 8, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.24"}],
    Cell[359990, 11156, 92, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[360085, 11160, 122, 4, 70, "Message",
      CellTags->"S2.9.13"],
    Cell[360210, 11166, 90, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[360315, 11172, 567, 17, 70, "Text",
      CellTags->{"S2.9.13", "13.25"}],
    Cell[360885, 11191, 218, 6, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.26"}],
    Cell[361128, 11201, 86, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[361217, 11205, 88, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[361320, 11211, 186, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.27"}],
    Cell[361531, 11220, 91, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[361625, 11224, 84, 3, 70, "Output",
      CellTags->"S2.9.13"],
    Cell[361724, 11230, 260, 6, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.28"}],
    Cell[362009, 11240, 92, 2, 70, "Input",
      CellTags->"S2.9.13"],
    Cell[362104, 11244, 85, 3, 70, "Output",
      CellTags->"S2.9.13"]},
  "13.1"->{
    Cell[345176, 10568, 111, 1, 70, "Subsection",
      CellTags->{"S2.9.13", "13.1"}]},
  "13.2"->{
    Cell[347841, 10651, 85, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.2"}]},
  "13.3"->{
    Cell[348136, 10666, 156, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.3"}]},
  "13.4"->{
    Cell[348523, 10685, 157, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.4"}]},
  "13.5"->{
    Cell[349048, 10709, 197, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.5"}]},
  "13.6"->{
    Cell[349660, 10733, 131, 4, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.6"}]},
  "13.7"->{
    Cell[350087, 10752, 295, 7, 70, "Text",
      CellTags->{"S2.9.13", "13.7"}]},
  "13.8"->{
    Cell[350385, 10761, 199, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.8"}]},
  "13.9"->{
    Cell[350822, 10780, 182, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.9"}]},
  "13.10"->{
    Cell[351379, 10804, 107, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.10"}]},
  "13.11"->{
    Cell[351844, 10822, 243, 6, 70, "Text",
      CellTags->{"S2.9.13", "13.11"}]},
  "13.12"->{
    Cell[352090, 10830, 200, 7, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.12"}]},
  "13.13"->{
    Cell[353460, 10882, 154, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.13"}]},
  "13.14"->{
    Cell[353844, 10901, 159, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.14"}]},
  "13.15"->{
    Cell[354305, 10923, 146, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.15"}]},
  "13.16"->{
    Cell[354687, 10942, 81, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.16"}]},
  "13.17"->{
    Cell[355071, 10958, 84, 1, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.17"}]},
  "13.18"->{
    Cell[355398, 10973, 156, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.18"}]},
  "13.19"->{
    Cell[356631, 11019, 118, 2, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.19"}]},
  "13.20"->{
    Cell[356965, 11035, 205, 7, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.20"}]},
  "13.21"->{
    Cell[357416, 11056, 176, 7, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.21"}]},
  "13.22"->{
    Cell[358785, 11108, 353, 9, 70, "Text",
      CellTags->{"S2.9.13", "13.22"}]},
  "13.23"->{
    Cell[359141, 11119, 196, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.23"}]},
  "13.24"->{
    Cell[359727, 11144, 238, 8, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.24"}]},
  "13.25"->{
    Cell[360315, 11172, 567, 17, 70, "Text",
      CellTags->{"S2.9.13", "13.25"}]},
  "13.26"->{
    Cell[360885, 11191, 218, 6, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.26"}]},
  "13.27"->{
    Cell[361320, 11211, 186, 5, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.27"}]},
  "13.28"->{
    Cell[361724, 11230, 260, 6, 70, "MathCaption",
      CellTags->{"S2.9.13", "13.28"}]},
  "S2.9.14"->{
    Cell[362238, 11253, 145, 5, 70, "Subsection",
      CellTags->{"S2.9.14", "14.1"}],
    Cell[362386, 11260, 572, 14, 70, "Text",
      CellTags->{"S2.9.14", "14.2"}],
    Cell[362961, 11276, 1941, 58, 70, "DefinitionBox",
      CellTags->"S2.9.14"],
    Cell[364905, 11336, 131, 5, 70, "Caption",
      CellTags->"S2.9.14"],
    Cell[365039, 11343, 335, 9, 70, "Text",
      CellTags->{"S2.9.14", "14.3"}],
    Cell[365377, 11354, 623, 27, 70, "Text",
      CellTags->{"S2.9.14", "14.4"}],
    Cell[366003, 11383, 378, 8, 70, "Text",
      CellTags->{"S2.9.14", "14.5"}],
    Cell[366384, 11393, 3265, 107, 70, "DefinitionBox3Col",
      CellTags->"S2.9.14"],
    Cell[369652, 11502, 148, 5, 70, "Caption",
      CellTags->"S2.9.14"],
    Cell[369803, 11509, 279, 6, 70, "Text",
      CellTags->{"S2.9.14", "14.6"}],
    Cell[370085, 11517, 352, 13, 70, "Text",
      CellTags->{"S2.9.14", "14.7"}],
    Cell[370440, 11532, 301, 8, 70, "Text",
      CellTags->{"S2.9.14", "14.8"}],
    Cell[370744, 11542, 389, 13, 70, "Text",
      CellTags->{"S2.9.14", "14.9"}],
    Cell[371136, 11557, 252, 9, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.10"}],
    Cell[371413, 11570, 107, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[371523, 11574, 512, 16, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[372050, 11593, 144, 5, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.11"}],
    Cell[372219, 11602, 79, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[372301, 11606, 93, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[372409, 11612, 137, 5, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.12"}],
    Cell[372571, 11621, 78, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[372652, 11625, 93, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[372760, 11631, 241, 5, 70, "Text",
      CellTags->{"S2.9.14", "14.13"}],
    Cell[373004, 11638, 204, 7, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.14"}],
    Cell[373233, 11649, 86, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[373322, 11653, 254, 8, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[373591, 11664, 7458, 233, 70, "DefinitionBox",
      CellTags->"S2.9.14"],
    Cell[381052, 11899, 98, 1, 70, "Caption",
      CellTags->"S2.9.14"],
    Cell[381153, 11902, 613, 15, 70, "Text",
      CellTags->{"S2.9.14", "14.15"}],
    Cell[381769, 11919, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.16"}],
    Cell[381926, 11927, 212, 4, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[382141, 11933, 225, 5, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[382381, 11941, 164, 4, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.17"}],
    Cell[382570, 11949, 76, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[382649, 11953, 366, 10, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[383030, 11966, 165, 4, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.18"}],
    Cell[383220, 11974, 104, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[383327, 11978, 152, 4, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[383494, 11985, 2254, 79, 70, "DefinitionBox3Col",
      CellTags->"S2.9.14"],
    Cell[385751, 12066, 81, 1, 70, "Caption",
      CellTags->"S2.9.14"],
    Cell[385835, 12069, 182, 6, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.19"}],
    Cell[386042, 12079, 88, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[386133, 12083, 250, 8, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[386398, 12094, 187, 6, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.20"}],
    Cell[386610, 12104, 88, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[386701, 12108, 265, 8, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[386981, 12119, 314, 8, 70, "Text",
      CellTags->{"S2.9.14", "14.21"}],
    Cell[387298, 12129, 754, 23, 70, "Text",
      CellTags->{"S2.9.14", "14.22"}],
    Cell[388055, 12154, 659, 19, 70, "Text",
      CellTags->{"S2.9.14", "14.23"}],
    Cell[388717, 12175, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.24"}],
    Cell[388915, 12184, 111, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[389029, 12188, 254, 8, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[389298, 12199, 222, 7, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.25"}],
    Cell[389545, 12210, 122, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[389670, 12214, 96, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[389781, 12220, 649, 20, 70, "Text",
      CellTags->{"S2.9.14", "14.26"}],
    Cell[390433, 12242, 285, 9, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.27"}],
    Cell[390743, 12255, 112, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[390858, 12259, 253, 8, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[391126, 12270, 421, 14, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.28"}],
    Cell[391572, 12288, 112, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[391687, 12292, 133, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[391835, 12298, 95, 1, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.29"}],
    Cell[391955, 12303, 116, 2, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[392074, 12307, 136, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[392225, 12313, 403, 9, 70, "Text",
      CellTags->{"S2.9.14", "14.30"}],
    Cell[392631, 12324, 101, 1, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.31"}],
    Cell[392757, 12329, 94, 3, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[392854, 12334, 95, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[392964, 12340, 295, 10, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.32"}],
    Cell[393284, 12354, 101, 3, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[393388, 12359, 103, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[393506, 12365, 219, 6, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.33"}],
    Cell[393750, 12375, 120, 3, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[393873, 12380, 90, 3, 70, "Output",
      CellTags->"S2.9.14"],
    Cell[393978, 12386, 221, 8, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.34"}],
    Cell[394224, 12398, 124, 3, 70, "Input",
      CellTags->"S2.9.14"],
    Cell[394351, 12403, 94, 3, 70, "Output",
      CellTags->"S2.9.14"]},
  "14.1"->{
    Cell[362238, 11253, 145, 5, 70, "Subsection",
      CellTags->{"S2.9.14", "14.1"}]},
  "14.2"->{
    Cell[362386, 11260, 572, 14, 70, "Text",
      CellTags->{"S2.9.14", "14.2"}]},
  "14.3"->{
    Cell[365039, 11343, 335, 9, 70, "Text",
      CellTags->{"S2.9.14", "14.3"}]},
  "14.4"->{
    Cell[365377, 11354, 623, 27, 70, "Text",
      CellTags->{"S2.9.14", "14.4"}]},
  "14.5"->{
    Cell[366003, 11383, 378, 8, 70, "Text",
      CellTags->{"S2.9.14", "14.5"}]},
  "14.6"->{
    Cell[369803, 11509, 279, 6, 70, "Text",
      CellTags->{"S2.9.14", "14.6"}]},
  "14.7"->{
    Cell[370085, 11517, 352, 13, 70, "Text",
      CellTags->{"S2.9.14", "14.7"}]},
  "14.8"->{
    Cell[370440, 11532, 301, 8, 70, "Text",
      CellTags->{"S2.9.14", "14.8"}]},
  "14.9"->{
    Cell[370744, 11542, 389, 13, 70, "Text",
      CellTags->{"S2.9.14", "14.9"}]},
  "14.10"->{
    Cell[371136, 11557, 252, 9, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.10"}]},
  "14.11"->{
    Cell[372050, 11593, 144, 5, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.11"}]},
  "14.12"->{
    Cell[372409, 11612, 137, 5, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.12"}]},
  "14.13"->{
    Cell[372760, 11631, 241, 5, 70, "Text",
      CellTags->{"S2.9.14", "14.13"}]},
  "14.14"->{
    Cell[373004, 11638, 204, 7, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.14"}]},
  "14.15"->{
    Cell[381153, 11902, 613, 15, 70, "Text",
      CellTags->{"S2.9.14", "14.15"}]},
  "14.16"->{
    Cell[381769, 11919, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.16"}]},
  "14.17"->{
    Cell[382381, 11941, 164, 4, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.17"}]},
  "14.18"->{
    Cell[383030, 11966, 165, 4, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.18"}]},
  "14.19"->{
    Cell[385835, 12069, 182, 6, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.19"}]},
  "14.20"->{
    Cell[386398, 12094, 187, 6, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.20"}]},
  "14.21"->{
    Cell[386981, 12119, 314, 8, 70, "Text",
      CellTags->{"S2.9.14", "14.21"}]},
  "14.22"->{
    Cell[387298, 12129, 754, 23, 70, "Text",
      CellTags->{"S2.9.14", "14.22"}]},
  "14.23"->{
    Cell[388055, 12154, 659, 19, 70, "Text",
      CellTags->{"S2.9.14", "14.23"}]},
  "14.24"->{
    Cell[388717, 12175, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.24"}]},
  "14.25"->{
    Cell[389298, 12199, 222, 7, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.25"}]},
  "14.26"->{
    Cell[389781, 12220, 649, 20, 70, "Text",
      CellTags->{"S2.9.14", "14.26"}]},
  "14.27"->{
    Cell[390433, 12242, 285, 9, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.27"}]},
  "14.28"->{
    Cell[391126, 12270, 421, 14, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.28"}]},
  "14.29"->{
    Cell[391835, 12298, 95, 1, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.29"}]},
  "14.30"->{
    Cell[392225, 12313, 403, 9, 70, "Text",
      CellTags->{"S2.9.14", "14.30"}]},
  "14.31"->{
    Cell[392631, 12324, 101, 1, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.31"}]},
  "14.32"->{
    Cell[392964, 12340, 295, 10, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.32"}]},
  "14.33"->{
    Cell[393506, 12365, 219, 6, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.33"}]},
  "14.34"->{
    Cell[393978, 12386, 221, 8, 70, "MathCaption",
      CellTags->{"S2.9.14", "14.34"}]},
  "S2.9.15"->{
    Cell[394494, 12412, 115, 4, 70, "Subsection",
      CellTags->{"S2.9.15", "15.1"}],
    Cell[394612, 12418, 551, 21, 70, "Text",
      CellTags->{"S2.9.15", "15.2"}],
    Cell[395166, 12441, 406, 9, 70, "Text",
      CellTags->{"S2.9.15", "15.3"}],
    Cell[395575, 12452, 195, 6, 70, "Text",
      CellTags->{"S2.9.15", "15.4"}],
    Cell[395773, 12460, 225, 6, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.5"}],
    Cell[396023, 12470, 108, 3, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[396134, 12475, 250, 8, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[396399, 12486, 230, 8, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.6"}],
    Cell[396654, 12498, 96, 3, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[396753, 12503, 97, 3, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[396865, 12509, 184, 6, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.7"}],
    Cell[397052, 12517, 101, 2, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[397156, 12521, 226, 6, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.8"}],
    Cell[397407, 12531, 82, 2, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[397492, 12535, 83, 3, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[397590, 12541, 3962, 127, 70, "DefinitionBox",
      CellTags->"S2.9.15"],
    Cell[401555, 12670, 168, 5, 70, "Caption",
      CellTags->"S2.9.15"],
    Cell[401726, 12677, 274, 6, 70, "Text",
      CellTags->{"S2.9.15", "15.9"}],
    Cell[402003, 12685, 227, 8, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.10"}],
    Cell[402255, 12697, 82, 2, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[402340, 12701, 98, 3, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[402453, 12707, 143, 5, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.11"}],
    Cell[402621, 12716, 76, 2, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[402700, 12720, 249, 8, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[402964, 12731, 2188, 72, 70, "DefinitionBox",
      CellTags->"S2.9.15"],
    Cell[405155, 12805, 176, 5, 70, "Caption",
      CellTags->"S2.9.15"],
    Cell[405334, 12812, 702, 19, 70, "Text",
      CellTags->{"S2.9.15", "15.12"}],
    Cell[406039, 12833, 483, 15, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.13"}],
    Cell[406547, 12852, 111, 2, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[406661, 12856, 268, 8, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[406944, 12867, 9539, 222, 70, "DoubleBox",
      CellTags->"S2.9.15"],
    Cell[416486, 13091, 122, 4, 70, "Caption",
      CellTags->"S2.9.15"],
    Cell[416611, 13097, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.14"}],
    Cell[416797, 13106, 105, 3, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[416905, 13111, 110, 2, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[417030, 13116, 131, 4, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.15"}],
    Cell[417186, 13124, 105, 3, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[417294, 13129, 86, 2, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[417395, 13134, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.16"}],
    Cell[417537, 13140, 118, 3, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[417658, 13145, 107, 2, 70, "Output",
      CellTags->"S2.9.15"],
    Cell[417780, 13150, 181, 7, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.17"}],
    Cell[417986, 13161, 110, 3, 70, "Input",
      CellTags->"S2.9.15"],
    Cell[418099, 13166, 101, 2, 70, "Output",
      CellTags->"S2.9.15"]},
  "15.1"->{
    Cell[394494, 12412, 115, 4, 70, "Subsection",
      CellTags->{"S2.9.15", "15.1"}]},
  "15.2"->{
    Cell[394612, 12418, 551, 21, 70, "Text",
      CellTags->{"S2.9.15", "15.2"}]},
  "15.3"->{
    Cell[395166, 12441, 406, 9, 70, "Text",
      CellTags->{"S2.9.15", "15.3"}]},
  "15.4"->{
    Cell[395575, 12452, 195, 6, 70, "Text",
      CellTags->{"S2.9.15", "15.4"}]},
  "15.5"->{
    Cell[395773, 12460, 225, 6, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.5"}]},
  "15.6"->{
    Cell[396399, 12486, 230, 8, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.6"}]},
  "15.7"->{
    Cell[396865, 12509, 184, 6, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.7"}]},
  "15.8"->{
    Cell[397156, 12521, 226, 6, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.8"}]},
  "15.9"->{
    Cell[401726, 12677, 274, 6, 70, "Text",
      CellTags->{"S2.9.15", "15.9"}]},
  "15.10"->{
    Cell[402003, 12685, 227, 8, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.10"}]},
  "15.11"->{
    Cell[402453, 12707, 143, 5, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.11"}]},
  "15.12"->{
    Cell[405334, 12812, 702, 19, 70, "Text",
      CellTags->{"S2.9.15", "15.12"}]},
  "15.13"->{
    Cell[406039, 12833, 483, 15, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.13"}]},
  "15.14"->{
    Cell[416611, 13097, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.14"}]},
  "15.15"->{
    Cell[417030, 13116, 131, 4, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.15"}]},
  "15.16"->{
    Cell[417395, 13134, 117, 2, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.16"}]},
  "15.17"->{
    Cell[417780, 13150, 181, 7, 70, "MathCaption",
      CellTags->{"S2.9.15", "15.17"}]},
  "S2.9.16"->{
    Cell[418249, 13174, 85, 1, 70, "Subsection",
      CellTags->{"S2.9.16", "16.1"}],
    Cell[418337, 13177, 812, 21, 70, "Text",
      CellTags->{"S2.9.16", "16.2"}],
    Cell[419152, 13200, 191, 7, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.3"}],
    Cell[419346, 13209, 110, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[419459, 13213, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.4"}],
    Cell[419647, 13222, 78, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[419728, 13226, 362, 12, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[420105, 13241, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.5"}],
    Cell[420291, 13250, 76, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[420370, 13254, 252, 8, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[420637, 13265, 2126, 60, 70, "DefinitionBox",
      CellTags->"S2.9.16"],
    Cell[422766, 13327, 82, 1, 70, "Caption",
      CellTags->"S2.9.16"],
    Cell[422851, 13330, 394, 11, 70, "Text",
      CellTags->{"S2.9.16", "16.6"}],
    Cell[423248, 13343, 238, 7, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.7"}],
    Cell[423489, 13352, 114, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[423606, 13356, 153, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.8"}],
    Cell[423784, 13365, 92, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[423879, 13369, 108, 3, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[424002, 13375, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.9"}],
    Cell[424190, 13384, 85, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[424278, 13388, 97, 3, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[424390, 13394, 4478, 152, 70, "DefinitionBox",
      CellTags->"S2.9.16"],
    Cell[428871, 13548, 70, 1, 70, "Caption",
      CellTags->"S2.9.16"],
    Cell[428944, 13551, 236, 8, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.10"}],
    Cell[429205, 13563, 85, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[429293, 13567, 172, 6, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[429480, 13576, 323, 9, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.11"}],
    Cell[429828, 13589, 113, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[429944, 13593, 239, 6, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[430198, 13602, 468, 12, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.12"}],
    Cell[430691, 13618, 68, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[430762, 13622, 308, 8, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[431085, 13633, 829, 18, 70, "Text",
      CellTags->{"S2.9.16", "16.13"}],
    Cell[431917, 13653, 391, 11, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.14"}],
    Cell[432333, 13668, 90, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[432426, 13672, 383, 11, 70, "Output",
      CellTags->"S2.9.16"],
    Cell[432824, 13686, 559, 18, 70, "Text",
      CellTags->{"S2.9.16", "16.15"}],
    Cell[433386, 13706, 174, 7, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.16"}],
    Cell[433563, 13715, 102, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[433668, 13719, 189, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.17"}],
    Cell[433882, 13728, 82, 2, 70, "Input",
      CellTags->"S2.9.16"],
    Cell[433967, 13732, 81, 2, 70, "Output",
      CellTags->"S2.9.16"]},
  "16.1"->{
    Cell[418249, 13174, 85, 1, 70, "Subsection",
      CellTags->{"S2.9.16", "16.1"}]},
  "16.2"->{
    Cell[418337, 13177, 812, 21, 70, "Text",
      CellTags->{"S2.9.16", "16.2"}]},
  "16.3"->{
    Cell[419152, 13200, 191, 7, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.3"}]},
  "16.4"->{
    Cell[419459, 13213, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.4"}]},
  "16.5"->{
    Cell[420105, 13241, 161, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.5"}]},
  "16.6"->{
    Cell[422851, 13330, 394, 11, 70, "Text",
      CellTags->{"S2.9.16", "16.6"}]},
  "16.7"->{
    Cell[423248, 13343, 238, 7, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.7"}]},
  "16.8"->{
    Cell[423606, 13356, 153, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.8"}]},
  "16.9"->{
    Cell[424002, 13375, 163, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.9"}]},
  "16.10"->{
    Cell[428944, 13551, 236, 8, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.10"}]},
  "16.11"->{
    Cell[429480, 13576, 323, 9, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.11"}]},
  "16.12"->{
    Cell[430198, 13602, 468, 12, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.12"}]},
  "16.13"->{
    Cell[431085, 13633, 829, 18, 70, "Text",
      CellTags->{"S2.9.16", "16.13"}]},
  "16.14"->{
    Cell[431917, 13653, 391, 11, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.14"}]},
  "16.15"->{
    Cell[432824, 13686, 559, 18, 70, "Text",
      CellTags->{"S2.9.16", "16.15"}]},
  "16.16"->{
    Cell[433386, 13706, 174, 7, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.16"}]},
  "16.17"->{
    Cell[433668, 13719, 189, 5, 70, "MathCaption",
      CellTags->{"S2.9.16", "16.17"}]},
  "S2.9.17"->{
    Cell[434097, 13740, 128, 4, 70, "Subsection",
      CellTags->{"S2.9.17", "17.1"}],
    Cell[434228, 13746, 1062, 32, 70, "DefinitionBox",
      CellTags->"S2.9.17"],
    Cell[435293, 13780, 126, 4, 70, "Caption",
      CellTags->"S2.9.17"],
    Cell[435422, 13786, 150, 4, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.2"}],
    Cell[435597, 13794, 95, 2, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[435695, 13798, 105, 3, 70, "Output",
      CellTags->"S2.9.17"],
    Cell[435815, 13804, 234, 6, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.3"}],
    Cell[436074, 13814, 96, 2, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[436173, 13818, 101, 3, 70, "Output",
      CellTags->"S2.9.17"],
    Cell[436289, 13824, 361, 9, 70, "Text",
      CellTags->{"S2.9.17", "17.4"}],
    Cell[436653, 13835, 325, 7, 70, "Text",
      CellTags->{"S2.9.17", "17.5"}],
    Cell[436981, 13844, 367, 9, 70, "Text",
      CellTags->{"S2.9.17", "17.6"}],
    Cell[437351, 13855, 189, 6, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.7"}],
    Cell[437565, 13865, 84, 2, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[437652, 13869, 111, 3, 70, "Output",
      CellTags->"S2.9.17"],
    Cell[437778, 13875, 212, 7, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.8"}],
    Cell[438015, 13886, 110, 2, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[438128, 13890, 253, 8, 70, "Output",
      CellTags->"S2.9.17"],
    Cell[438396, 13901, 490, 12, 70, "Text",
      CellTags->{"S2.9.17", "17.9"}],
    Cell[438889, 13915, 487, 11, 70, "Text",
      CellTags->{"S2.9.17", "17.10"}],
    Cell[439379, 13928, 194, 7, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.11"}],
    Cell[439576, 13937, 260, 6, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[439839, 13945, 220, 7, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.12"}],
    Cell[440084, 13956, 81, 2, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[440168, 13960, 112, 3, 70, "Output",
      CellTags->"S2.9.17"],
    Cell[440295, 13966, 147, 4, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.13"}],
    Cell[440467, 13974, 111, 3, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[440581, 13979, 153, 3, 70, "Message",
      CellTags->"S2.9.17"],
    Cell[440749, 13985, 302, 10, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.14"}],
    Cell[441054, 13997, 253, 6, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[441310, 14005, 232, 8, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.15"}],
    Cell[441567, 14017, 123, 3, 70, "Input",
      CellTags->"S2.9.17"],
    Cell[441693, 14022, 257, 8, 70, "Output",
      CellTags->"S2.9.17"],
    Cell[441965, 14033, 491, 12, 70, "Text",
      CellTags->{"S2.9.17", "17.16"}],
    Cell[442459, 14047, 462, 12, 70, "Text",
      CellTags->{"S2.9.17", "17.17"}],
    Cell[442924, 14061, 832, 23, 70, "FramedBox",
      CellTags->"S2.9.17"],
    Cell[443759, 14086, 124, 5, 70, "Caption",
      CellTags->"S2.9.17"]},
  "17.1"->{
    Cell[434097, 13740, 128, 4, 70, "Subsection",
      CellTags->{"S2.9.17", "17.1"}]},
  "17.2"->{
    Cell[435422, 13786, 150, 4, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.2"}]},
  "17.3"->{
    Cell[435815, 13804, 234, 6, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.3"}]},
  "17.4"->{
    Cell[436289, 13824, 361, 9, 70, "Text",
      CellTags->{"S2.9.17", "17.4"}]},
  "17.5"->{
    Cell[436653, 13835, 325, 7, 70, "Text",
      CellTags->{"S2.9.17", "17.5"}]},
  "17.6"->{
    Cell[436981, 13844, 367, 9, 70, "Text",
      CellTags->{"S2.9.17", "17.6"}]},
  "17.7"->{
    Cell[437351, 13855, 189, 6, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.7"}]},
  "17.8"->{
    Cell[437778, 13875, 212, 7, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.8"}]},
  "17.9"->{
    Cell[438396, 13901, 490, 12, 70, "Text",
      CellTags->{"S2.9.17", "17.9"}]},
  "17.10"->{
    Cell[438889, 13915, 487, 11, 70, "Text",
      CellTags->{"S2.9.17", "17.10"}]},
  "17.11"->{
    Cell[439379, 13928, 194, 7, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.11"}]},
  "17.12"->{
    Cell[439839, 13945, 220, 7, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.12"}]},
  "17.13"->{
    Cell[440295, 13966, 147, 4, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.13"}]},
  "17.14"->{
    Cell[440749, 13985, 302, 10, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.14"}]},
  "17.15"->{
    Cell[441310, 14005, 232, 8, 70, "MathCaption",
      CellTags->{"S2.9.17", "17.15"}]},
  "17.16"->{
    Cell[441965, 14033, 491, 12, 70, "Text",
      CellTags->{"S2.9.17", "17.16"}]},
  "17.17"->{
    Cell[442459, 14047, 462, 12, 70, "Text",
      CellTags->{"S2.9.17", "17.17"}]},
  "S2.9.18"->{
    Cell[443920, 14096, 92, 1, 70, "Subsection",
      CellTags->{"S2.9.18", "18.1"}],
    Cell[444015, 14099, 266, 6, 70, "Text",
      CellTags->{"S2.9.18", "18.2"}],
    Cell[444284, 14107, 568, 14, 70, "Text",
      CellTags->{"S2.9.18", "18.3"}],
    Cell[444855, 14123, 1334, 39, 70, "DefinitionBox",
      CellTags->"S2.9.18"],
    Cell[446192, 14164, 64, 1, 70, "Caption",
      CellTags->"S2.9.18"],
    Cell[446259, 14167, 194, 5, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.4"}],
    Cell[446478, 14176, 86, 2, 70, "Input",
      CellTags->"S2.9.18"],
    Cell[446567, 14180, 144, 4, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[446714, 14186, 57, 2, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[446786, 14191, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.5"}],
    Cell[446943, 14199, 97, 2, 70, "Input",
      CellTags->"S2.9.18"],
    Cell[447043, 14203, 171, 4, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[447217, 14209, 171, 4, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[447391, 14215, 171, 4, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[447565, 14221, 173, 4, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[447741, 14227, 173, 4, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[447929, 14234, 374, 9, 70, "Text",
      CellTags->{"S2.9.18", "18.6"}],
    Cell[448306, 14245, 103, 1, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.7"}],
    Cell[448434, 14250, 99, 2, 70, "Input",
      CellTags->"S2.9.18"],
    Cell[448536, 14254, 305, 11, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[448856, 14268, 154, 5, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.8"}],
    Cell[449035, 14277, 112, 2, 70, "Input",
      CellTags->"S2.9.18"],
    Cell[449150, 14281, 225, 6, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[449390, 14290, 294, 8, 70, "Text",
      CellTags->{"S2.9.18", "18.9"}],
    Cell[449687, 14300, 147, 5, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.10"}],
    Cell[449859, 14309, 92, 2, 70, "Input",
      CellTags->"S2.9.18"],
    Cell[449954, 14313, 298, 11, 70, "Print",
      CellTags->"S2.9.18"],
    Cell[450267, 14327, 762, 19, 70, "Text",
      CellTags->{"S2.9.18", "18.11"}]},
  "18.1"->{
    Cell[443920, 14096, 92, 1, 70, "Subsection",
      CellTags->{"S2.9.18", "18.1"}]},
  "18.2"->{
    Cell[444015, 14099, 266, 6, 70, "Text",
      CellTags->{"S2.9.18", "18.2"}]},
  "18.3"->{
    Cell[444284, 14107, 568, 14, 70, "Text",
      CellTags->{"S2.9.18", "18.3"}]},
  "18.4"->{
    Cell[446259, 14167, 194, 5, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.4"}]},
  "18.5"->{
    Cell[446786, 14191, 132, 4, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.5"}]},
  "18.6"->{
    Cell[447929, 14234, 374, 9, 70, "Text",
      CellTags->{"S2.9.18", "18.6"}]},
  "18.7"->{
    Cell[448306, 14245, 103, 1, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.7"}]},
  "18.8"->{
    Cell[448856, 14268, 154, 5, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.8"}]},
  "18.9"->{
    Cell[449390, 14290, 294, 8, 70, "Text",
      CellTags->{"S2.9.18", "18.9"}]},
  "18.10"->{
    Cell[449687, 14300, 147, 5, 70, "MathCaption",
      CellTags->{"S2.9.18", "18.10"}]},
  "18.11"->{
    Cell[450267, 14327, 762, 19, 70, "Text",
      CellTags->{"S2.9.18", "18.11"}]},
  "S2.9.19"->{
    Cell[451066, 14351, 99, 1, 70, "Subsection",
      CellTags->{"S2.9.19", "19.1"}],
    Cell[451168, 14354, 906, 26, 70, "DefinitionBox",
      CellTags->"S2.9.19"],
    Cell[452077, 14382, 81, 1, 70, "Caption",
      CellTags->"S2.9.19"],
    Cell[452161, 14385, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.19", "19.2"}],
    Cell[452290, 14390, 106, 2, 70, "Input",
      CellTags->"S2.9.19"],
    Cell[452399, 14394, 7796, 100, 70, 7660, 95, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S2.9.19"],
    Cell[460210, 14497, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.19", "19.3"}],
    Cell[460329, 14502, 97, 2, 70, "Input",
      CellTags->"S2.9.19"],
    Cell[460429, 14506, 12122, 154, 70, 11986, 149, "GraphicsData", 
    "Bitmap", "Picture",
      Evaluatable->False,
      CellTags->"S2.9.19"],
    Cell[472566, 14663, 413, 12, 70, "Text",
      CellTags->{"S2.9.19", "19.4"}]},
  "19.1"->{
    Cell[451066, 14351, 99, 1, 70, "Subsection",
      CellTags->{"S2.9.19", "19.1"}]},
  "19.2"->{
    Cell[452161, 14385, 104, 1, 70, "MathCaption",
      CellTags->{"S2.9.19", "19.2"}]},
  "19.3"->{
    Cell[460210, 14497, 94, 1, 70, "MathCaption",
      CellTags->{"S2.9.19", "19.3"}]},
  "19.4"->{
    Cell[472566, 14663, 413, 12, 70, "Text",
      CellTags->{"S2.9.19", "19.4"}]},
  "S2.9.20"->{
    Cell[473016, 14680, 78, 1, 70, "Subsection",
      CellTags->{"S2.9.20", "20.1"}],
    Cell[473097, 14683, 369, 10, 70, "Text",
      CellTags->{"S2.9.20", "20.2"}],
    Cell[473469, 14695, 1060, 30, 70, "DefinitionBox",
      CellTags->"S2.9.20"],
    Cell[474532, 14727, 61, 1, 70, "Caption",
      CellTags->"S2.9.20"],
    Cell[474596, 14730, 552, 13, 70, "Text",
      CellTags->{"S2.9.20", "20.3"}],
    Cell[475151, 14745, 291, 9, 70, "Text",
      CellTags->{"S2.9.20", "20.4"}]},
  "20.1"->{
    Cell[473016, 14680, 78, 1, 70, "Subsection",
      CellTags->{"S2.9.20", "20.1"}]},
  "20.2"->{
    Cell[473097, 14683, 369, 10, 70, "Text",
      CellTags->{"S2.9.20", "20.2"}]},
  "20.3"->{
    Cell[474596, 14730, 552, 13, 70, "Text",
      CellTags->{"S2.9.20", "20.3"}]},
  "20.4"->{
    Cell[475151, 14745, 291, 9, 70, "Text",
      CellTags->{"S2.9.20", "20.4"}]},
  "S2.9.21"->{
    Cell[475479, 14759, 70, 1, 70, "Subsection",
      CellTags->{"S2.9.21", "21.1"}],
    Cell[475552, 14762, 393, 9, 70, "Text",
      CellTags->{"S2.9.21", "21.2"}],
    Cell[475948, 14773, 414, 13, 70, "Text",
      CellTags->{"S2.9.21", "21.3"}],
    Cell[476365, 14788, 775, 22, 70, "DefinitionBox",
      CellTags->"S2.9.21"],
    Cell[477143, 14812, 80, 1, 70, "Caption",
      CellTags->"S2.9.21"],
    Cell[477226, 14815, 498, 14, 70, "Text",
      CellTags->{"S2.9.21", "21.4"}],
    Cell[477727, 14831, 87, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.5"}],
    Cell[477839, 14836, 77, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[477919, 14840, 180, 4, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[478102, 14846, 94, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[478211, 14852, 98, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.6"}],
    Cell[478312, 14855, 79, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[478394, 14859, 92, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.7"}],
    Cell[478511, 14864, 77, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[478591, 14868, 94, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[478700, 14874, 521, 12, 70, "Text",
      CellTags->{"S2.9.21", "21.8"}],
    Cell[479224, 14888, 1047, 32, 70, "DefinitionBox",
      CellTags->"S2.9.21"],
    Cell[480274, 14922, 65, 1, 70, "Caption",
      CellTags->"S2.9.21"],
    Cell[480342, 14925, 621, 21, 70, "Text",
      CellTags->{"S2.9.21", "21.9"}],
    Cell[480966, 14948, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.10"}],
    Cell[481164, 14957, 102, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[481269, 14961, 154, 3, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[481426, 14966, 119, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[481560, 14972, 90, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.11"}],
    Cell[481675, 14977, 83, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[481761, 14981, 134, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[481910, 14987, 85, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.12"}],
    Cell[482020, 14992, 127, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[482150, 14996, 121, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[482286, 15002, 88, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.13"}],
    Cell[482399, 15007, 102, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[482504, 15011, 141, 3, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[482648, 15016, 119, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[482782, 15022, 730, 18, 70, "Text",
      CellTags->{"S2.9.21", "21.14"}],
    Cell[483515, 15042, 280, 6, 70, "Text",
      CellTags->{"S2.9.21", "21.15"}],
    Cell[483798, 15050, 903, 26, 70, "Text",
      CellTags->{"S2.9.21", "21.16"}],
    Cell[484704, 15078, 200, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.17"}],
    Cell[484929, 15087, 75, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[485007, 15091, 163, 4, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[485173, 15097, 92, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[485280, 15103, 146, 4, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.18"}],
    Cell[485451, 15111, 78, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[485532, 15115, 138, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[485685, 15121, 798, 17, 70, "Text",
      CellTags->{"S2.9.21", "21.19"}],
    Cell[486486, 15140, 957, 29, 70, "DefinitionBox",
      CellTags->"S2.9.21"],
    Cell[487446, 15171, 114, 4, 70, "Caption",
      CellTags->"S2.9.21"],
    Cell[487563, 15177, 739, 21, 70, "Text",
      CellTags->{"S2.9.21", "21.20"}],
    Cell[488305, 15200, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.21"}],
    Cell[488503, 15209, 104, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[488610, 15213, 163, 4, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[488776, 15219, 161, 4, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[488940, 15225, 228, 8, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[489183, 15236, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.22"}],
    Cell[489381, 15245, 78, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[489462, 15249, 121, 2, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[489598, 15254, 363, 7, 70, "Text",
      CellTags->{"S2.9.21", "21.23"}],
    Cell[489964, 15263, 2794, 80, 70, "DefinitionBox",
      CellTags->"S2.9.21"],
    Cell[492761, 15345, 73, 1, 70, "Caption",
      CellTags->"S2.9.21"],
    Cell[492837, 15348, 183, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.24"}],
    Cell[493045, 15357, 81, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[493129, 15361, 84, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[493228, 15367, 209, 7, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.25"}],
    Cell[493462, 15378, 81, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[493546, 15382, 146, 3, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[493695, 15387, 86, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[493796, 15393, 362, 12, 70, "Text",
      CellTags->{"S2.9.21", "21.26"}],
    Cell[494161, 15407, 307, 7, 70, "Text",
      CellTags->{"S2.9.21", "21.27"}],
    Cell[494471, 15416, 248, 9, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.28"}],
    Cell[494744, 15429, 101, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[494848, 15433, 161, 4, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[495012, 15439, 92, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[495119, 15445, 1474, 43, 70, "DefinitionBox",
      CellTags->"S2.9.21"],
    Cell[496596, 15490, 63, 1, 70, "Caption",
      CellTags->"S2.9.21"],
    Cell[496662, 15493, 632, 21, 70, "Text",
      CellTags->{"S2.9.21", "21.29"}],
    Cell[497297, 15516, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.30"}],
    Cell[497477, 15525, 117, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[497597, 15529, 118, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[497730, 15535, 125, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.31"}],
    Cell[497858, 15542, 126, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[497987, 15546, 170, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.32"}],
    Cell[498182, 15555, 71, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[498256, 15559, 135, 3, 70, "Message",
      CellTags->"S2.9.21"],
    Cell[498394, 15564, 94, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[498503, 15570, 88, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.33"}],
    Cell[498594, 15573, 82, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[498679, 15577, 97, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.34"}],
    Cell[498801, 15582, 71, 2, 70, "Input",
      CellTags->"S2.9.21"],
    Cell[498875, 15586, 94, 3, 70, "Output",
      CellTags->"S2.9.21"],
    Cell[498984, 15592, 592, 15, 70, "Text",
      CellTags->{"S2.9.21", "21.35"}],
    Cell[499579, 15609, 296, 8, 70, "Text",
      CellTags->{"S2.9.21", "21.36"}]},
  "21.1"->{
    Cell[475479, 14759, 70, 1, 70, "Subsection",
      CellTags->{"S2.9.21", "21.1"}]},
  "21.2"->{
    Cell[475552, 14762, 393, 9, 70, "Text",
      CellTags->{"S2.9.21", "21.2"}]},
  "21.3"->{
    Cell[475948, 14773, 414, 13, 70, "Text",
      CellTags->{"S2.9.21", "21.3"}]},
  "21.4"->{
    Cell[477226, 14815, 498, 14, 70, "Text",
      CellTags->{"S2.9.21", "21.4"}]},
  "21.5"->{
    Cell[477727, 14831, 87, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.5"}]},
  "21.6"->{
    Cell[478211, 14852, 98, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.6"}]},
  "21.7"->{
    Cell[478394, 14859, 92, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.7"}]},
  "21.8"->{
    Cell[478700, 14874, 521, 12, 70, "Text",
      CellTags->{"S2.9.21", "21.8"}]},
  "21.9"->{
    Cell[480342, 14925, 621, 21, 70, "Text",
      CellTags->{"S2.9.21", "21.9"}]},
  "21.10"->{
    Cell[480966, 14948, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.10"}]},
  "21.11"->{
    Cell[481560, 14972, 90, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.11"}]},
  "21.12"->{
    Cell[481910, 14987, 85, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.12"}]},
  "21.13"->{
    Cell[482286, 15002, 88, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.13"}]},
  "21.14"->{
    Cell[482782, 15022, 730, 18, 70, "Text",
      CellTags->{"S2.9.21", "21.14"}]},
  "21.15"->{
    Cell[483515, 15042, 280, 6, 70, "Text",
      CellTags->{"S2.9.21", "21.15"}]},
  "21.16"->{
    Cell[483798, 15050, 903, 26, 70, "Text",
      CellTags->{"S2.9.21", "21.16"}]},
  "21.17"->{
    Cell[484704, 15078, 200, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.17"}]},
  "21.18"->{
    Cell[485280, 15103, 146, 4, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.18"}]},
  "21.19"->{
    Cell[485685, 15121, 798, 17, 70, "Text",
      CellTags->{"S2.9.21", "21.19"}]},
  "21.20"->{
    Cell[487563, 15177, 739, 21, 70, "Text",
      CellTags->{"S2.9.21", "21.20"}]},
  "21.21"->{
    Cell[488305, 15200, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.21"}]},
  "21.22"->{
    Cell[489183, 15236, 173, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.22"}]},
  "21.23"->{
    Cell[489598, 15254, 363, 7, 70, "Text",
      CellTags->{"S2.9.21", "21.23"}]},
  "21.24"->{
    Cell[492837, 15348, 183, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.24"}]},
  "21.25"->{
    Cell[493228, 15367, 209, 7, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.25"}]},
  "21.26"->{
    Cell[493796, 15393, 362, 12, 70, "Text",
      CellTags->{"S2.9.21", "21.26"}]},
  "21.27"->{
    Cell[494161, 15407, 307, 7, 70, "Text",
      CellTags->{"S2.9.21", "21.27"}]},
  "21.28"->{
    Cell[494471, 15416, 248, 9, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.28"}]},
  "21.29"->{
    Cell[496662, 15493, 632, 21, 70, "Text",
      CellTags->{"S2.9.21", "21.29"}]},
  "21.30"->{
    Cell[497297, 15516, 155, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.30"}]},
  "21.31"->{
    Cell[497730, 15535, 125, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.31"}]},
  "21.32"->{
    Cell[497987, 15546, 170, 5, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.32"}]},
  "21.33"->{
    Cell[498503, 15570, 88, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.33"}]},
  "21.34"->{
    Cell[498679, 15577, 97, 1, 70, "MathCaption",
      CellTags->{"S2.9.21", "21.34"}]},
  "21.35"->{
    Cell[498984, 15592, 592, 15, 70, "Text",
      CellTags->{"S2.9.21", "21.35"}]},
  "21.36"->{
    Cell[499579, 15609, 296, 8, 70, "Text",
      CellTags->{"S2.9.21", "21.36"}]},
  "S2.9.22"->{
    Cell[499912, 15622, 84, 1, 70, "Subsection",
      CellTags->{"S2.9.22", "22.1"}],
    Cell[499999, 15625, 393, 8, 70, "Text",
      CellTags->{"S2.9.22", "22.2"}],
    Cell[500395, 15635, 402, 11, 70, "Text",
      CellTags->{"S2.9.22", "22.3"}],
    Cell[500800, 15648, 1424, 42, 70, "DefinitionBox",
      CellTags->"S2.9.22"],
    Cell[502227, 15692, 84, 1, 70, "Caption",
      CellTags->"S2.9.22"],
    Cell[502314, 15695, 176, 5, 70, "MathCaption",
      CellTags->{"S2.9.22", "22.4"}],
    Cell[502515, 15704, 87, 2, 70, "Input",
      CellTags->"S2.9.22"],
    Cell[502605, 15708, 90, 3, 70, "Output",
      CellTags->"S2.9.22"],
    Cell[502710, 15714, 217, 6, 70, "MathCaption",
      CellTags->{"S2.9.22", "22.5"}],
    Cell[502952, 15724, 78, 2, 70, "Input",
      CellTags->"S2.9.22"],
    Cell[503033, 15728, 190, 4, 70, "Message",
      CellTags->"S2.9.22"],
    Cell[503226, 15734, 95, 3, 70, "Output",
      CellTags->"S2.9.22"],
    Cell[503336, 15740, 720, 20, 70, "DefinitionBox",
      CellTags->"S2.9.22"],
    Cell[504059, 15762, 75, 1, 70, "Caption",
      CellTags->"S2.9.22"],
    Cell[504137, 15765, 591, 18, 70, "Text",
      CellTags->{"S2.9.22", "22.6"}],
    Cell[504731, 15785, 414, 11, 70, "Text",
      CellTags->{"S2.9.22", "22.7"}]},
  "22.1"->{
    Cell[499912, 15622, 84, 1, 70, "Subsection",
      CellTags->{"S2.9.22", "22.1"}]},
  "22.2"->{
    Cell[499999, 15625, 393, 8, 70, "Text",
      CellTags->{"S2.9.22", "22.2"}]},
  "22.3"->{
    Cell[500395, 15635, 402, 11, 70, "Text",
      CellTags->{"S2.9.22", "22.3"}]},
  "22.4"->{
    Cell[502314, 15695, 176, 5, 70, "MathCaption",
      CellTags->{"S2.9.22", "22.4"}]},
  "22.5"->{
    Cell[502710, 15714, 217, 6, 70, "MathCaption",
      CellTags->{"S2.9.22", "22.5"}]},
  "22.6"->{
    Cell[504137, 15765, 591, 18, 70, "Text",
      CellTags->{"S2.9.22", "22.6"}]},
  "22.7"->{
    Cell[504731, 15785, 414, 11, 70, "Text",
      CellTags->{"S2.9.22", "22.7"}]},
  "S2.9.23"->{
    Cell[505182, 15801, 86, 1, 70, "Subsection",
      CellTags->{"S2.9.23", "23.1"}],
    Cell[505271, 15804, 302, 7, 70, "Text",
      CellTags->{"S2.9.23", "23.2"}],
    Cell[505576, 15813, 592, 16, 70, "Text",
      CellTags->{"S2.9.23", "23.3"}],
    Cell[506171, 15831, 165, 5, 70, "MathCaption",
      CellTags->{"S2.9.23", "23.4"}],
    Cell[506361, 15840, 102, 2, 70, "Input",
      CellTags->"S2.9.23"],
    Cell[506466, 15844, 97, 3, 70, "Output",
      CellTags->"S2.9.23"],
    Cell[506578, 15850, 578, 18, 70, "DefinitionBox",
      CellTags->"S2.9.23"],
    Cell[507159, 15870, 111, 5, 70, "Caption",
      CellTags->"S2.9.23"],
    Cell[507273, 15877, 485, 13, 70, "Text",
      CellTags->{"S2.9.23", "23.5"}],
    Cell[507761, 15892, 935, 27, 70, "DefinitionBox",
      CellTags->"S2.9.23"],
    Cell[508699, 15921, 72, 1, 70, "Caption",
      CellTags->"S2.9.23"],
    Cell[508774, 15924, 140, 5, 70, "MathCaption",
      CellTags->{"S2.9.23", "23.6"}],
    Cell[508917, 15931, 77, 2, 28, "Input",
      CellTags->"S2.9.23"],
    Cell[508997, 15935, 180, 6, 70, "MathCaption",
      CellTags->{"S2.9.23", "23.7"}],
    Cell[509202, 15945, 107, 2, 28, "Input",
      CellTags->"S2.9.23"],
    Cell[509312, 15949, 111, 3, 25, "Output",
      CellTags->"S2.9.23"],
    Cell[509438, 15955, 136, 5, 40, "MathCaption",
      CellTags->{"S2.9.23", "23.8"}],
    Cell[509599, 15964, 67, 2, 28, "Input",
      CellTags->"S2.9.23"],
    Cell[509669, 15968, 85, 2, 21, "Print",
      CellTags->"S2.9.23"],
    Cell[509769, 15973, 238, 8, 56, "MathCaption",
      CellTags->{"S2.9.23", "23.9"}],
    Cell[510032, 15985, 68, 2, 28, "Input",
      CellTags->"S2.9.23"],
    Cell[510103, 15989, 85, 2, 21, "Print",
      CellTags->"S2.9.23"],
    Cell[510191, 15993, 414, 13, 23, "Print",
      CellTags->"S2.9.23"],
    Cell[510620, 16009, 548, 18, 56, "Text",
      CellTags->{"S2.9.23", "23.10"}],
    Cell[511171, 16029, 461, 11, 72, "Text",
      CellTags->{"S2.9.23", "23.11"}],
    Cell[511635, 16042, 781, 22, 88, "DefinitionBox",
      CellTags->"S2.9.23"],
    Cell[512419, 16066, 79, 1, 16, "Caption",
      CellTags->"S2.9.23"],
    Cell[512501, 16069, 247, 7, 40, "Text",
      CellTags->{"S2.9.23", "23.12"}],
    Cell[512751, 16078, 428, 9, 72, "Text",
      CellTags->{"S2.9.23", "23.13"}]},
  "23.1"->{
    Cell[505182, 15801, 86, 1, 70, "Subsection",
      CellTags->{"S2.9.23", "23.1"}]},
  "23.2"->{
    Cell[505271, 15804, 302, 7, 70, "Text",
      CellTags->{"S2.9.23", "23.2"}]},
  "23.3"->{
    Cell[505576, 15813, 592, 16, 70, "Text",
      CellTags->{"S2.9.23", "23.3"}]},
  "23.4"->{
    Cell[506171, 15831, 165, 5, 70, "MathCaption",
      CellTags->{"S2.9.23", "23.4"}]},
  "23.5"->{
    Cell[507273, 15877, 485, 13, 70, "Text",
      CellTags->{"S2.9.23", "23.5"}]},
  "23.6"->{
    Cell[508774, 15924, 140, 5, 70, "MathCaption",
      CellTags->{"S2.9.23", "23.6"}]},
  "23.7"->{
    Cell[508997, 15935, 180, 6, 70, "MathCaption",
      CellTags->{"S2.9.23", "23.7"}]},
  "23.8"->{
    Cell[509438, 15955, 136, 5, 40, "MathCaption",
      CellTags->{"S2.9.23", "23.8"}]},
  "23.9"->{
    Cell[509769, 15973, 238, 8, 56, "MathCaption",
      CellTags->{"S2.9.23", "23.9"}]},
  "23.10"->{
    Cell[510620, 16009, 548, 18, 56, "Text",
      CellTags->{"S2.9.23", "23.10"}]},
  "23.11"->{
    Cell[511171, 16029, 461, 11, 72, "Text",
      CellTags->{"S2.9.23", "23.11"}]},
  "23.12"->{
    Cell[512501, 16069, 247, 7, 40, "Text",
      CellTags->{"S2.9.23", "23.12"}]},
  "23.13"->{
    Cell[512751, 16078, 428, 9, 72, "Text",
      CellTags->{"S2.9.23", "23.13"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.9.0", 513822, 16107},
  {"0.1", 513912, 16110},
  {"S2.9.1", 514005, 16113},
  {"1.1", 517238, 16202},
  {"1.2", 517330, 16205},
  {"1.3", 517424, 16208},
  {"1.4", 517518, 16211},
  {"1.5", 517612, 16214},
  {"1.6", 517700, 16217},
  {"1.7", 517795, 16220},
  {"1.8", 517890, 16223},
  {"1.9", 517985, 16226},
  {"1.10", 518081, 16229},
  {"1.11", 518172, 16232},
  {"1.12", 518269, 16235},
  {"1.13", 518366, 16238},
  {"1.14", 518463, 16241},
  {"1.15", 518560, 16244},
  {"S2.9.2", 518654, 16247},
  {"2.1", 520840, 16306},
  {"2.2", 520934, 16309},
  {"2.3", 521024, 16312},
  {"2.4", 521113, 16315},
  {"2.5", 521210, 16318},
  {"2.6", 521305, 16321},
  {"2.7", 521402, 16324},
  {"2.8", 521492, 16327},
  {"2.9", 521582, 16330},
  {"2.10", 521673, 16333},
  {"2.11", 521771, 16336},
  {"2.12", 521869, 16339},
  {"2.13", 521967, 16342},
  {"S2.9.3", 522067, 16345},
  {"3.1", 524182, 16402},
  {"3.2", 524276, 16405},
  {"3.3", 524366, 16408},
  {"3.4", 524462, 16411},
  {"3.5", 524558, 16414},
  {"3.6", 524654, 16417},
  {"3.7", 524750, 16420},
  {"3.8", 524846, 16423},
  {"3.9", 524935, 16426},
  {"3.10", 525032, 16429},
  {"S2.9.4", 525132, 16432},
  {"4.1", 529394, 16543},
  {"4.2", 529490, 16546},
  {"4.3", 529588, 16549},
  {"4.4", 529686, 16552},
  {"4.5", 529784, 16555},
  {"4.6", 529876, 16558},
  {"4.7", 529968, 16561},
  {"4.8", 530066, 16564},
  {"4.9", 530164, 16567},
  {"4.10", 530263, 16570},
  {"4.11", 530356, 16573},
  {"4.12", 530451, 16576},
  {"4.13", 530545, 16579},
  {"4.14", 530639, 16582},
  {"4.15", 530733, 16585},
  {"4.16", 530833, 16588},
  {"4.17", 530933, 16591},
  {"4.18", 531033, 16594},
  {"4.19", 531127, 16597},
  {"4.20", 531221, 16600},
  {"4.21", 531315, 16603},
  {"4.22", 531409, 16606},
  {"4.23", 531509, 16609},
  {"4.24", 531609, 16612},
  {"4.25", 531703, 16615},
  {"S2.9.5", 531799, 16618},
  {"5.1", 534591, 16691},
  {"5.2", 534687, 16694},
  {"5.3", 534778, 16697},
  {"5.4", 534870, 16700},
  {"5.5", 534968, 16703},
  {"5.6", 535066, 16706},
  {"5.7", 535158, 16709},
  {"5.8", 535256, 16712},
  {"5.9", 535354, 16715},
  {"5.10", 535447, 16718},
  {"5.11", 535547, 16721},
  {"5.12", 535647, 16724},
  {"5.13", 535740, 16727},
  {"5.14", 535840, 16730},
  {"5.15", 535939, 16733},
  {"5.16", 536039, 16736},
  {"S2.9.6", 536141, 16739},
  {"6.1", 540457, 16852},
  {"6.2", 540554, 16855},
  {"6.3", 540652, 16858},
  {"6.4", 540749, 16861},
  {"6.5", 540841, 16864},
  {"6.6", 540932, 16867},
  {"6.7", 541030, 16870},
  {"6.8", 541128, 16873},
  {"6.9", 541220, 16876},
  {"6.10", 541319, 16879},
  {"6.11", 541413, 16882},
  {"6.12", 541513, 16885},
  {"6.13", 541613, 16888},
  {"6.14", 541713, 16891},
  {"6.15", 541806, 16894},
  {"6.16", 541906, 16897},
  {"6.17", 542006, 16900},
  {"6.18", 542100, 16903},
  {"6.19", 542201, 16906},
  {"6.20", 542301, 16909},
  {"S2.9.7", 542403, 16912},
  {"7.1", 549879, 17107},
  {"7.2", 549975, 17110},
  {"7.3", 550073, 17113},
  {"7.4", 550171, 17116},
  {"7.5", 550269, 17119},
  {"7.6", 550367, 17122},
  {"7.7", 550465, 17125},
  {"7.8", 550563, 17128},
  {"7.9", 550661, 17131},
  {"7.10", 550753, 17134},
  {"7.11", 550847, 17137},
  {"7.12", 550947, 17140},
  {"7.13", 551047, 17143},
  {"7.14", 551147, 17146},
  {"7.15", 551241, 17149},
  {"7.16", 551341, 17152},
  {"7.17", 551441, 17155},
  {"7.18", 551541, 17158},
  {"7.19", 551635, 17161},
  {"7.20", 551735, 17164},
  {"7.21", 551835, 17167},
  {"7.22", 551928, 17170},
  {"7.23", 552021, 17173},
  {"7.24", 552121, 17176},
  {"7.25", 552220, 17179},
  {"7.26", 552320, 17182},
  {"7.27", 552420, 17185},
  {"7.28", 552521, 17188},
  {"7.29", 552621, 17191},
  {"7.30", 552715, 17194},
  {"7.31", 552815, 17197},
  {"7.32", 552914, 17200},
  {"7.33", 553014, 17203},
  {"7.34", 553114, 17206},
  {"7.35", 553214, 17209},
  {"S2.9.8", 553309, 17212},
  {"8.1", 559963, 17385},
  {"8.2", 560059, 17388},
  {"8.3", 560156, 17391},
  {"8.4", 560254, 17394},
  {"8.5", 560352, 17397},
  {"8.6", 560450, 17400},
  {"8.7", 560547, 17403},
  {"8.8", 560645, 17406},
  {"8.9", 560743, 17409},
  {"8.10", 560842, 17412},
  {"8.11", 560942, 17415},
  {"8.12", 561035, 17418},
  {"8.13", 561136, 17421},
  {"8.14", 561236, 17424},
  {"8.15", 561336, 17427},
  {"8.16", 561431, 17430},
  {"8.17", 561531, 17433},
  {"8.18", 561625, 17436},
  {"8.19", 561719, 17439},
  {"8.20", 561819, 17442},
  {"8.21", 561913, 17445},
  {"8.22", 562013, 17448},
  {"8.23", 562113, 17451},
  {"8.24", 562206, 17454},
  {"8.25", 562306, 17457},
  {"8.26", 562400, 17460},
  {"8.27", 562500, 17463},
  {"8.28", 562599, 17466},
  {"8.29", 562692, 17469},
  {"8.30", 562792, 17472},
  {"8.31", 562892, 17475},
  {"8.32", 562992, 17478},
  {"S2.9.9", 563094, 17481},
  {"9.1", 564646, 17522},
  {"9.2", 564742, 17525},
  {"9.3", 564840, 17528},
  {"9.4", 564938, 17531},
  {"9.5", 565035, 17534},
  {"9.6", 565127, 17537},
  {"9.7", 565225, 17540},
  {"S2.9.10", 565321, 17543},
  {"10.1", 571598, 17704},
  {"10.2", 571697, 17707},
  {"10.3", 571791, 17710},
  {"10.4", 571892, 17713},
  {"10.5", 571993, 17716},
  {"10.6", 572093, 17719},
  {"10.7", 572194, 17722},
  {"10.8", 572294, 17725},
  {"10.9", 572394, 17728},
  {"10.10", 572496, 17731},
  {"10.11", 572599, 17734},
  {"10.12", 572702, 17737},
  {"10.13", 572805, 17740},
  {"10.14", 572908, 17743},
  {"10.15", 573005, 17746},
  {"10.16", 573108, 17749},
  {"10.17", 573211, 17752},
  {"10.18", 573314, 17755},
  {"10.19", 573410, 17758},
  {"10.20", 573513, 17761},
  {"10.21", 573615, 17764},
  {"10.22", 573718, 17767},
  {"10.23", 573821, 17770},
  {"10.24", 573918, 17773},
  {"10.25", 574015, 17776},
  {"10.26", 574112, 17779},
  {"10.27", 574215, 17782},
  {"10.28", 574312, 17785},
  {"S2.9.11", 574410, 17788},
  {"11.1", 589053, 18161},
  {"11.2", 589152, 18164},
  {"11.3", 589246, 18167},
  {"11.4", 589346, 18170},
  {"11.5", 589447, 18173},
  {"11.6", 589547, 18176},
  {"11.7", 589648, 18179},
  {"11.8", 589748, 18182},
  {"11.9", 589849, 18185},
  {"11.10", 589951, 18188},
  {"11.11", 590048, 18191},
  {"11.12", 590145, 18194},
  {"11.13", 590248, 18197},
  {"11.14", 590351, 18200},
  {"11.15", 590448, 18203},
  {"11.16", 590551, 18206},
  {"11.17", 590654, 18209},
  {"11.18", 590751, 18212},
  {"11.19", 590848, 18215},
  {"11.20", 590945, 18218},
  {"11.21", 591048, 18221},
  {"11.22", 591151, 18224},
  {"11.23", 591254, 18227},
  {"11.24", 591357, 18230},
  {"11.25", 591460, 18233},
  {"11.26", 591556, 18236},
  {"11.27", 591653, 18239},
  {"11.28", 591756, 18242},
  {"11.29", 591859, 18245},
  {"11.30", 591962, 18248},
  {"11.31", 592060, 18251},
  {"11.32", 592163, 18254},
  {"11.33", 592266, 18257},
  {"11.34", 592363, 18260},
  {"11.35", 592459, 18263},
  {"11.36", 592562, 18266},
  {"11.37", 592659, 18269},
  {"11.38", 592762, 18272},
  {"11.39", 592865, 18275},
  {"11.40", 592968, 18278},
  {"11.41", 593071, 18281},
  {"11.42", 593174, 18284},
  {"11.43", 593277, 18287},
  {"11.44", 593373, 18290},
  {"11.45", 593476, 18293},
  {"11.46", 593579, 18296},
  {"11.47", 593682, 18299},
  {"11.48", 593785, 18302},
  {"11.49", 593888, 18305},
  {"11.50", 593991, 18308},
  {"11.51", 594094, 18311},
  {"11.52", 594190, 18314},
  {"11.53", 594293, 18317},
  {"11.54", 594396, 18320},
  {"11.55", 594499, 18323},
  {"11.56", 594602, 18326},
  {"11.57", 594705, 18329},
  {"11.58", 594808, 18332},
  {"11.59", 594905, 18335},
  {"11.60", 595001, 18338},
  {"11.61", 595104, 18341},
  {"11.62", 595206, 18344},
  {"11.63", 595302, 18347},
  {"11.64", 595399, 18350},
  {"11.65", 595496, 18353},
  {"11.66", 595592, 18356},
  {"11.67", 595695, 18359},
  {"S2.9.12", 595800, 18362},
  {"12.1", 602837, 18541},
  {"12.2", 602936, 18544},
  {"12.3", 603030, 18547},
  {"12.4", 603131, 18550},
  {"12.5", 603232, 18553},
  {"12.6", 603333, 18556},
  {"12.7", 603427, 18559},
  {"12.8", 603528, 18562},
  {"12.9", 603629, 18565},
  {"12.10", 603730, 18568},
  {"12.11", 603827, 18571},
  {"12.12", 603924, 18574},
  {"12.13", 604021, 18577},
  {"12.14", 604124, 18580},
  {"12.15", 604227, 18583},
  {"12.16", 604329, 18586},
  {"12.17", 604427, 18589},
  {"12.18", 604531, 18592},
  {"12.19", 604635, 18595},
  {"12.20", 604739, 18598},
  {"12.21", 604843, 18601},
  {"12.22", 604941, 18604},
  {"12.23", 605046, 18607},
  {"12.24", 605150, 18610},
  {"12.25", 605254, 18613},
  {"12.26", 605358, 18616},
  {"12.27", 605462, 18619},
  {"12.28", 605560, 18622},
  {"12.29", 605664, 18625},
  {"12.30", 605768, 18628},
  {"12.31", 605866, 18631},
  {"12.32", 605971, 18634},
  {"12.33", 606069, 18637},
  {"12.34", 606173, 18640},
  {"12.35", 606277, 18643},
  {"S2.9.13", 606376, 18646},
  {"13.1", 612995, 18815},
  {"13.2", 613096, 18818},
  {"13.3", 613197, 18821},
  {"13.4", 613299, 18824},
  {"13.5", 613401, 18827},
  {"13.6", 613503, 18830},
  {"13.7", 613605, 18833},
  {"13.8", 613700, 18836},
  {"13.9", 613802, 18839},
  {"13.10", 613905, 18842},
  {"13.11", 614009, 18845},
  {"13.12", 614106, 18848},
  {"13.13", 614210, 18851},
  {"13.14", 614314, 18854},
  {"13.15", 614418, 18857},
  {"13.16", 614522, 18860},
  {"13.17", 614625, 18863},
  {"13.18", 614728, 18866},
  {"13.19", 614832, 18869},
  {"13.20", 614936, 18872},
  {"13.21", 615040, 18875},
  {"13.22", 615144, 18878},
  {"13.23", 615241, 18881},
  {"13.24", 615345, 18884},
  {"13.25", 615449, 18887},
  {"13.26", 615547, 18890},
  {"13.27", 615651, 18893},
  {"13.28", 615755, 18896},
  {"S2.9.14", 615861, 18899},
  {"14.1", 622103, 19056},
  {"14.2", 622204, 19059},
  {"14.3", 622300, 19062},
  {"14.4", 622395, 19065},
  {"14.5", 622491, 19068},
  {"14.6", 622586, 19071},
  {"14.7", 622681, 19074},
  {"14.8", 622777, 19077},
  {"14.9", 622872, 19080},
  {"14.10", 622969, 19083},
  {"14.11", 623073, 19086},
  {"14.12", 623177, 19089},
  {"14.13", 623281, 19092},
  {"14.14", 623378, 19095},
  {"14.15", 623482, 19098},
  {"14.16", 623580, 19101},
  {"14.17", 623684, 19104},
  {"14.18", 623788, 19107},
  {"14.19", 623892, 19110},
  {"14.20", 623996, 19113},
  {"14.21", 624100, 19116},
  {"14.22", 624197, 19119},
  {"14.23", 624295, 19122},
  {"14.24", 624393, 19125},
  {"14.25", 624497, 19128},
  {"14.26", 624601, 19131},
  {"14.27", 624699, 19134},
  {"14.28", 624803, 19137},
  {"14.29", 624908, 19140},
  {"14.30", 625011, 19143},
  {"14.31", 625108, 19146},
  {"14.32", 625212, 19149},
  {"14.33", 625317, 19152},
  {"14.34", 625421, 19155},
  {"S2.9.15", 625527, 19158},
  {"15.1", 629035, 19247},
  {"15.2", 629136, 19250},
  {"15.3", 629232, 19253},
  {"15.4", 629327, 19256},
  {"15.5", 629422, 19259},
  {"15.6", 629524, 19262},
  {"15.7", 629626, 19265},
  {"15.8", 629728, 19268},
  {"15.9", 629830, 19271},
  {"15.10", 629926, 19274},
  {"15.11", 630030, 19277},
  {"15.12", 630134, 19280},
  {"15.13", 630232, 19283},
  {"15.14", 630337, 19286},
  {"15.15", 630441, 19289},
  {"15.16", 630545, 19292},
  {"15.17", 630649, 19295},
  {"S2.9.16", 630755, 19298},
  {"16.1", 634114, 19383},
  {"16.2", 634214, 19386},
  {"16.3", 634310, 19389},
  {"16.4", 634412, 19392},
  {"16.5", 634514, 19395},
  {"16.6", 634616, 19398},
  {"16.7", 634712, 19401},
  {"16.8", 634814, 19404},
  {"16.9", 634916, 19407},
  {"16.10", 635019, 19410},
  {"16.11", 635123, 19413},
  {"16.12", 635227, 19416},
  {"16.13", 635332, 19419},
  {"16.14", 635430, 19422},
  {"16.15", 635535, 19425},
  {"16.16", 635633, 19428},
  {"16.17", 635737, 19431},
  {"S2.9.17", 635843, 19434},
  {"17.1", 638815, 19509},
  {"17.2", 638916, 19512},
  {"17.3", 639018, 19515},
  {"17.4", 639120, 19518},
  {"17.5", 639215, 19521},
  {"17.6", 639310, 19524},
  {"17.7", 639405, 19527},
  {"17.8", 639507, 19530},
  {"17.9", 639609, 19533},
  {"17.10", 639706, 19536},
  {"17.11", 639804, 19539},
  {"17.12", 639908, 19542},
  {"17.13", 640012, 19545},
  {"17.14", 640116, 19548},
  {"17.15", 640221, 19551},
  {"17.16", 640325, 19554},
  {"17.17", 640423, 19557},
  {"S2.9.18", 640523, 19560},
  {"18.1", 642731, 19617},
  {"18.2", 642831, 19620},
  {"18.3", 642926, 19623},
  {"18.4", 643022, 19626},
  {"18.5", 643124, 19629},
  {"18.6", 643226, 19632},
  {"18.7", 643321, 19635},
  {"18.8", 643423, 19638},
  {"18.9", 643525, 19641},
  {"18.10", 643621, 19644},
  {"18.11", 643725, 19647},
  {"S2.9.19", 643825, 19650},
  {"19.1", 644779, 19675},
  {"19.2", 644879, 19678},
  {"19.3", 644981, 19681},
  {"19.4", 645082, 19684},
  {"S2.9.20", 645181, 19687},
  {"20.1", 645686, 19700},
  {"20.2", 645786, 19703},
  {"20.3", 645882, 19706},
  {"20.4", 645978, 19709},
  {"S2.9.21", 646076, 19712},
  {"21.1", 653219, 19893},
  {"21.2", 653319, 19896},
  {"21.3", 653414, 19899},
  {"21.4", 653510, 19902},
  {"21.5", 653606, 19905},
  {"21.6", 653707, 19908},
  {"21.7", 653808, 19911},
  {"21.8", 653909, 19914},
  {"21.9", 654005, 19917},
  {"21.10", 654102, 19920},
  {"21.11", 654206, 19923},
  {"21.12", 654309, 19926},
  {"21.13", 654412, 19929},
  {"21.14", 654515, 19932},
  {"21.15", 654613, 19935},
  {"21.16", 654710, 19938},
  {"21.17", 654808, 19941},
  {"21.18", 654912, 19944},
  {"21.19", 655016, 19947},
  {"21.20", 655114, 19950},
  {"21.21", 655212, 19953},
  {"21.22", 655316, 19956},
  {"21.23", 655420, 19959},
  {"21.24", 655517, 19962},
  {"21.25", 655621, 19965},
  {"21.26", 655725, 19968},
  {"21.27", 655823, 19971},
  {"21.28", 655920, 19974},
  {"21.29", 656024, 19977},
  {"21.30", 656122, 19980},
  {"21.31", 656226, 19983},
  {"21.32", 656330, 19986},
  {"21.33", 656434, 19989},
  {"21.34", 656537, 19992},
  {"21.35", 656640, 19995},
  {"21.36", 656738, 19998},
  {"S2.9.22", 656837, 20001},
  {"22.1", 658124, 20034},
  {"22.2", 658224, 20037},
  {"22.3", 658319, 20040},
  {"22.4", 658415, 20043},
  {"22.5", 658517, 20046},
  {"22.6", 658619, 20049},
  {"22.7", 658715, 20052},
  {"S2.9.23", 658814, 20055},
  {"23.1", 661137, 20114},
  {"23.2", 661237, 20117},
  {"23.3", 661332, 20120},
  {"23.4", 661428, 20123},
  {"23.5", 661530, 20126},
  {"23.6", 661626, 20129},
  {"23.7", 661728, 20132},
  {"23.8", 661830, 20135},
  {"23.9", 661932, 20138},
  {"23.10", 662035, 20141},
  {"23.11", 662133, 20144},
  {"23.12", 662231, 20147},
  {"23.13", 662328, 20150}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 127, 4, 65, "Section",
  CellTags->{"S2.9.0", "0.1"}],

Cell[CellGroupData[{
Cell[1928, 61, 84, 1, 70, "Subsection",
  CellTags->{"S2.9.1", "1.1"}],
Cell[2015, 64, 104, 1, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.2"}],

Cell[CellGroupData[{
Cell[2144, 69, 77, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[2224, 73, 91, 3, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[2330, 79, 104, 1, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.3"}],

Cell[CellGroupData[{
Cell[2459, 84, 90, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[2552, 88, 91, 3, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[2658, 94, 147, 4, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.4"}],

Cell[CellGroupData[{
Cell[2830, 102, 90, 3, 70, "Input",
  CellTags->"S2.9.1"],
Cell[2923, 107, 91, 3, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[3029, 113, 154, 4, 70, "Text",
  CellTags->{"S2.9.1", "1.5"}],
Cell[3186, 119, 203, 7, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.6"}],

Cell[CellGroupData[{
Cell[3414, 130, 77, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[3494, 134, 91, 3, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[3600, 140, 241, 7, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.7"}],

Cell[CellGroupData[{
Cell[3866, 151, 91, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[3960, 155, 90, 2, 70, "Output",
  CellTags->"S2.9.1"],
Cell[4053, 159, 116, 5, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[4184, 167, 158, 4, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.8"}],

Cell[CellGroupData[{
Cell[4367, 175, 90, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[4460, 179, 89, 2, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[4564, 184, 177, 5, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.9"}],

Cell[CellGroupData[{
Cell[4766, 193, 89, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[4858, 197, 276, 8, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[5149, 208, 1268, 38, 70, "DefinitionBox",
  CellTags->"S2.9.1"],
Cell[6420, 248, 76, 1, 70, "Caption",
  CellTags->"S2.9.1"],
Cell[6499, 251, 457, 11, 70, "Text",
  CellTags->{"S2.9.1", "1.10"}],
Cell[6959, 264, 217, 5, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.11"}],

Cell[CellGroupData[{
Cell[7201, 273, 120, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[7324, 277, 171, 4, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[7510, 284, 143, 4, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.12"}],

Cell[CellGroupData[{
Cell[7678, 292, 88, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[7769, 296, 87, 2, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[7871, 301, 279, 9, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.13"}],

Cell[CellGroupData[{
Cell[8175, 314, 87, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[8265, 318, 93, 2, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[8373, 323, 151, 4, 70, "MathCaption",
  CellTags->{"S2.9.1", "1.14"}],

Cell[CellGroupData[{
Cell[8549, 331, 93, 2, 70, "Input",
  CellTags->"S2.9.1"],
Cell[8645, 335, 93, 2, 70, "Output",
  CellTags->"S2.9.1"]
}, Open  ]],
Cell[8753, 340, 1341, 36, 70, "DefinitionBox",
  CellTags->"S2.9.1"],
Cell[10097, 378, 139, 5, 70, "Caption",
  CellTags->"S2.9.1"],
Cell[10239, 385, 461, 12, 70, "Text",
  CellTags->{"S2.9.1", "1.15"}],
Cell[10703, 399, 487, 16, 70, "FramedBox",
  CellTags->"S2.9.1"],
Cell[11193, 417, 149, 5, 70, "Caption",
  CellTags->"S2.9.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11379, 427, 84, 1, 70, "Subsection",
  CellTags->{"S2.9.2", "2.1"}],
Cell[11466, 430, 478, 11, 70, "DefinitionBox",
  CellTags->"S2.9.2"],
Cell[11947, 443, 124, 5, 70, "Caption",
  CellTags->"S2.9.2"],
Cell[12074, 450, 537, 20, 70, "Text",
  CellTags->{"S2.9.2", "2.2"}],
Cell[12614, 472, 320, 9, 70, "Text",
  CellTags->{"S2.9.2", "2.3"}],
Cell[12937, 483, 330, 14, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.4"}],

Cell[CellGroupData[{
Cell[13292, 501, 69, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[13364, 505, 85, 3, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]],
Cell[13464, 511, 97, 1, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.5"}],

Cell[CellGroupData[{
Cell[13586, 516, 78, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[13667, 520, 82, 2, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]],
Cell[13764, 525, 313, 11, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.6"}],

Cell[CellGroupData[{
Cell[14102, 540, 65, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[14170, 544, 85, 3, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]],
Cell[14270, 550, 463, 14, 70, "Text",
  CellTags->{"S2.9.2", "2.7"}],
Cell[14736, 566, 631, 20, 70, "Text",
  CellTags->{"S2.9.2", "2.8"}],
Cell[15370, 588, 598, 16, 70, "Text",
  CellTags->{"S2.9.2", "2.9"}],
Cell[15971, 606, 206, 7, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.10"}],

Cell[CellGroupData[{
Cell[16202, 617, 90, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[16295, 621, 89, 2, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]],
Cell[16399, 626, 111, 1, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.11"}],

Cell[CellGroupData[{
Cell[16535, 631, 65, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[16603, 635, 92, 3, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]],
Cell[16710, 641, 231, 9, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.12"}],

Cell[CellGroupData[{
Cell[16966, 654, 65, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[17034, 658, 89, 2, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]],
Cell[17138, 663, 179, 7, 70, "MathCaption",
  CellTags->{"S2.9.2", "2.13"}],

Cell[CellGroupData[{
Cell[17342, 674, 74, 2, 70, "Input",
  CellTags->"S2.9.2"],
Cell[17419, 678, 816, 26, 70, "Output",
  CellTags->"S2.9.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18284, 710, 94, 1, 70, "Subsection",
  CellTags->{"S2.9.3", "3.1"}],
Cell[18381, 713, 564, 11, 70, "Text",
  CellTags->{"S2.9.3", "3.2"}],
Cell[18948, 726, 644, 18, 70, "DefinitionBox",
  CellTags->"S2.9.3"],
Cell[19595, 746, 83, 1, 70, "Caption",
  CellTags->"S2.9.3"],
Cell[19681, 749, 202, 6, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.3"}],

Cell[CellGroupData[{
Cell[19908, 759, 94, 2, 70, "Input",
  CellTags->"S2.9.3"],
Cell[20005, 763, 92, 3, 70, "Output",
  CellTags->"S2.9.3"]
}, Open  ]],
Cell[20112, 769, 130, 4, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.4"}],

Cell[CellGroupData[{
Cell[20267, 777, 75, 2, 70, "Input",
  CellTags->"S2.9.3"],
Cell[20345, 781, 248, 8, 70, "Output",
  CellTags->"S2.9.3"]
}, Open  ]],
Cell[20608, 792, 104, 1, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.5"}],

Cell[CellGroupData[{
Cell[20737, 797, 77, 2, 70, "Input",
  CellTags->"S2.9.3"],
Cell[20817, 801, 126, 3, 70, "Output",
  CellTags->"S2.9.3"]
}, Open  ]],
Cell[20958, 807, 173, 5, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.6"}],

Cell[CellGroupData[{
Cell[21156, 816, 96, 2, 70, "Input",
  CellTags->"S2.9.3"],
Cell[21255, 820, 155, 4, 70, "Output",
  CellTags->"S2.9.3"]
}, Open  ]],
Cell[21425, 827, 221, 6, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.7"}],

Cell[CellGroupData[{
Cell[21671, 837, 109, 2, 70, "Input",
  CellTags->"S2.9.3"],
Cell[21783, 841, 95, 2, 70, "Output",
  CellTags->"S2.9.3"]
}, Open  ]],
Cell[21893, 846, 295, 8, 70, "Text",
  CellTags->{"S2.9.3", "3.8"}],
Cell[22191, 856, 155, 5, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.9"}],
Cell[22349, 863, 10315, 132, 70, 10180, 127, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S2.9.3"],
Cell[32667, 997, 224, 6, 70, "MathCaption",
  CellTags->{"S2.9.3", "3.10"}],
Cell[32894, 1005, 65991, 819, 70, 65855, 814, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S2.9.3"],
Cell[98888, 1826, 1101, 34, 70, "DefinitionBox",
  CellTags->"S2.9.3"],
Cell[99992, 1862, 86, 1, 70, "Caption",
  CellTags->"S2.9.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100115, 1868, 94, 1, 70, "Subsection",
  CellTags->{"S2.9.4", "4.1"}],
Cell[100212, 1871, 465, 13, 70, "DefinitionBox",
  CellTags->"S2.9.4"],
Cell[100680, 1886, 90, 1, 70, "Caption",
  CellTags->"S2.9.4"],
Cell[100773, 1889, 110, 1, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.2"}],

Cell[CellGroupData[{
Cell[100908, 1894, 93, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[101004, 1898, 89, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[101108, 1904, 194, 6, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.3"}],

Cell[CellGroupData[{
Cell[101327, 1914, 94, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[101424, 1918, 125, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[101564, 1924, 177, 4, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.4"}],

Cell[CellGroupData[{
Cell[101766, 1932, 79, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[101848, 1936, 89, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[101952, 1942, 311, 10, 70, "Text",
  CellTags->{"S2.9.4", "4.5"}],
Cell[102266, 1954, 498, 11, 70, "Text",
  CellTags->{"S2.9.4", "4.6"}],
Cell[102767, 1967, 649, 18, 70, "DefinitionBox",
  CellTags->"S2.9.4"],
Cell[103419, 1987, 140, 5, 70, "Caption",
  CellTags->"S2.9.4"],
Cell[103562, 1994, 141, 5, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.7"}],

Cell[CellGroupData[{
Cell[103728, 2003, 84, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[103815, 2007, 89, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[103919, 2013, 148, 5, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.8"}],

Cell[CellGroupData[{
Cell[104092, 2022, 71, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[104166, 2026, 89, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[104270, 2032, 150, 5, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.9"}],

Cell[CellGroupData[{
Cell[104445, 2041, 88, 3, 70, "Input",
  CellTags->"S2.9.4"],
Cell[104536, 2046, 89, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[104640, 2052, 245, 7, 70, "Text",
  CellTags->{"S2.9.4", "4.10"}],
Cell[104888, 2061, 1524, 51, 70, "Text",
  CellTags->{"S2.9.4", "4.11"}],
Cell[106415, 2114, 510, 18, 70, "Text",
  CellTags->{"S2.9.4", "4.12"}],
Cell[106928, 2134, 388, 10, 70, "Text",
  CellTags->{"S2.9.4", "4.13"}],
Cell[107319, 2146, 751, 23, 70, "DefinitionBox",
  CellTags->"S2.9.4"],
Cell[108073, 2171, 112, 5, 70, "Caption",
  CellTags->"S2.9.4"],
Cell[108188, 2178, 920, 27, 70, "Text",
  CellTags->{"S2.9.4", "4.14"}],
Cell[109111, 2207, 111, 3, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.15"}],

Cell[CellGroupData[{
Cell[109247, 2214, 73, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[109323, 2218, 92, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[109430, 2224, 127, 4, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.16"}],

Cell[CellGroupData[{
Cell[109582, 2232, 88, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[109673, 2236, 92, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[109780, 2242, 178, 4, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.17"}],

Cell[CellGroupData[{
Cell[109983, 2250, 71, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[110057, 2254, 85, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[110157, 2260, 816, 24, 70, "Text",
  CellTags->{"S2.9.4", "4.18"}],
Cell[110976, 2286, 673, 19, 70, "DefinitionBox",
  CellTags->"S2.9.4"],
Cell[111652, 2307, 77, 1, 70, "Caption",
  CellTags->"S2.9.4"],
Cell[111732, 2310, 416, 11, 70, "Text",
  CellTags->{"S2.9.4", "4.19"}],
Cell[112151, 2323, 602, 16, 70, "Text",
  CellTags->{"S2.9.4", "4.20"}],
Cell[112756, 2341, 320, 11, 70, "Text",
  CellTags->{"S2.9.4", "4.21"}],
Cell[113079, 2354, 163, 5, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.22"}],

Cell[CellGroupData[{
Cell[113267, 2363, 104, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[113374, 2367, 86, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[113475, 2373, 162, 5, 70, "MathCaption",
  CellTags->{"S2.9.4", "4.23"}],

Cell[CellGroupData[{
Cell[113662, 2382, 101, 2, 70, "Input",
  CellTags->"S2.9.4"],
Cell[113766, 2386, 86, 3, 70, "Output",
  CellTags->"S2.9.4"]
}, Open  ]],
Cell[113867, 2392, 458, 12, 70, "Text",
  CellTags->{"S2.9.4", "4.24"}],
Cell[114328, 2406, 455, 12, 70, "Text",
  CellTags->{"S2.9.4", "4.25"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[114820, 2423, 83, 1, 70, "Subsection",
  CellTags->{"S2.9.5", "5.1"}],
Cell[114906, 2426, 377, 7, 70, "Text",
  CellTags->{"S2.9.5", "5.2"}],
Cell[115286, 2435, 288, 10, 70, "Text",
  CellTags->{"S2.9.5", "5.3"}],
Cell[115577, 2447, 1911, 60, 70, "DefinitionBox",
  CellTags->"S2.9.5"],
Cell[117491, 2509, 74, 1, 70, "Caption",
  CellTags->"S2.9.5"],
Cell[117568, 2512, 174, 4, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.4"}],
Cell[117745, 2518, 92, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[117840, 2522, 267, 8, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.5"}],

Cell[CellGroupData[{
Cell[118132, 2534, 72, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[118207, 2538, 186, 5, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[118408, 2546, 872, 17, 70, "Text",
  CellTags->{"S2.9.5", "5.6"}],
Cell[119283, 2565, 175, 5, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.7"}],

Cell[CellGroupData[{
Cell[119483, 2574, 75, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[119561, 2578, 490, 9, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[120066, 2590, 188, 7, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.8"}],

Cell[CellGroupData[{
Cell[120279, 2601, 83, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[120365, 2605, 241, 8, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[120621, 2616, 738, 21, 70, "Text",
  CellTags->{"S2.9.5", "5.9"}],
Cell[121362, 2639, 179, 6, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.10"}],

Cell[CellGroupData[{
Cell[121566, 2649, 74, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[121643, 2653, 561, 11, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[122219, 2667, 137, 4, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.11"}],

Cell[CellGroupData[{
Cell[122381, 2675, 90, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[122474, 2679, 244, 5, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[122733, 2687, 283, 8, 70, "Text",
  CellTags->{"S2.9.5", "5.12"}],
Cell[123019, 2697, 117, 2, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.13"}],

Cell[CellGroupData[{
Cell[123161, 2703, 116, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[123280, 2707, 82, 3, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[123377, 2713, 94, 1, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.14"}],
Cell[123474, 2716, 84, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[123561, 2720, 155, 5, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.15"}],

Cell[CellGroupData[{
Cell[123741, 2729, 75, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[123819, 2733, 1521, 34, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]],
Cell[125355, 2770, 178, 5, 70, "MathCaption",
  CellTags->{"S2.9.5", "5.16"}],

Cell[CellGroupData[{
Cell[125558, 2779, 77, 2, 70, "Input",
  CellTags->"S2.9.5"],
Cell[125638, 2783, 301, 7, 70, "Output",
  CellTags->"S2.9.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[125988, 2796, 105, 3, 70, "Subsection",
  CellTags->{"S2.9.6", "6.1"}],
Cell[126096, 2801, 422, 12, 70, "DefinitionBox",
  CellTags->"S2.9.6"],
Cell[126521, 2815, 55, 1, 70, "Caption",
  CellTags->"S2.9.6"],
Cell[126579, 2818, 163, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.2"}],

Cell[CellGroupData[{
Cell[126767, 2827, 85, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[126855, 2831, 100, 3, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[126970, 2837, 94, 1, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.3"}],

Cell[CellGroupData[{
Cell[127089, 2842, 76, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[127168, 2846, 97, 2, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[127280, 2851, 382, 10, 70, "Text",
  CellTags->{"S2.9.6", "6.4"}],
Cell[127665, 2863, 2974, 86, 70, "DefinitionBox",
  CellTags->"S2.9.6"],
Cell[130642, 2951, 63, 1, 70, "Caption",
  CellTags->"S2.9.6"],
Cell[130708, 2954, 382, 9, 70, "Text",
  CellTags->{"S2.9.6", "6.5"}],
Cell[131093, 2965, 171, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.6"}],

Cell[CellGroupData[{
Cell[131289, 2974, 108, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[131400, 2978, 261, 8, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[131676, 2989, 114, 2, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.7"}],

Cell[CellGroupData[{
Cell[131815, 2995, 101, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[131919, 2999, 209, 5, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[132143, 3007, 432, 10, 70, "Text",
  CellTags->{"S2.9.6", "6.8"}],
Cell[132578, 3019, 202, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.9"}],

Cell[CellGroupData[{
Cell[132805, 3028, 137, 5, 70, "Input",
  CellTags->"S2.9.6"],
Cell[132945, 3035, 449, 12, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[133409, 3050, 333, 10, 70, "Text",
  CellTags->{"S2.9.6", "6.10"}],
Cell[133745, 3062, 196, 6, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.11"}],

Cell[CellGroupData[{
Cell[133966, 3072, 97, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[134066, 3076, 196, 5, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[134277, 3084, 156, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.12"}],

Cell[CellGroupData[{
Cell[134458, 3093, 76, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[134537, 3097, 109, 2, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[134661, 3102, 159, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.13"}],

Cell[CellGroupData[{
Cell[134845, 3111, 86, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[134934, 3115, 89, 2, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[135038, 3120, 393, 9, 70, "Text",
  CellTags->{"S2.9.6", "6.14"}],
Cell[135434, 3131, 1294, 37, 70, "DefinitionBox",
  CellTags->"S2.9.6"],
Cell[136731, 3170, 77, 1, 70, "Caption",
  CellTags->"S2.9.6"],
Cell[136811, 3173, 165, 4, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.15"}],

Cell[CellGroupData[{
Cell[137001, 3181, 98, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[137102, 3185, 208, 5, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[137325, 3193, 1905, 59, 70, "DefinitionBox",
  CellTags->"S2.9.6"],
Cell[139233, 3254, 75, 1, 70, "Caption",
  CellTags->"S2.9.6"],
Cell[139311, 3257, 102, 1, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.16"}],

Cell[CellGroupData[{
Cell[139438, 3262, 89, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[139530, 3266, 328, 12, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[139873, 3281, 600, 18, 70, "DefinitionBox",
  CellTags->"S2.9.6"],
Cell[140476, 3301, 76, 1, 70, "Caption",
  CellTags->"S2.9.6"],
Cell[140555, 3304, 647, 17, 70, "Text",
  CellTags->{"S2.9.6", "6.17"}],
Cell[141205, 3323, 215, 10, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.18"}],

Cell[CellGroupData[{
Cell[141445, 3337, 80, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[141528, 3341, 111, 4, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[141654, 3348, 160, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.19"}],

Cell[CellGroupData[{
Cell[141839, 3357, 80, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[141922, 3361, 111, 4, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]],
Cell[142048, 3368, 161, 5, 70, "MathCaption",
  CellTags->{"S2.9.6", "6.20"}],

Cell[CellGroupData[{
Cell[142234, 3377, 80, 2, 70, "Input",
  CellTags->"S2.9.6"],
Cell[142317, 3381, 112, 4, 70, "Output",
  CellTags->"S2.9.6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[142478, 3391, 85, 1, 70, "Subsection",
  CellTags->{"S2.9.7", "7.1"}],
Cell[142566, 3394, 971, 28, 70, "DefinitionBox",
  CellTags->"S2.9.7"],
Cell[143540, 3424, 69, 1, 70, "Caption",
  CellTags->"S2.9.7"],
Cell[143612, 3427, 166, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.2"}],

Cell[CellGroupData[{
Cell[143803, 3435, 86, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[143892, 3439, 156, 4, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[144063, 3446, 101, 1, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.3"}],

Cell[CellGroupData[{
Cell[144189, 3451, 81, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[144273, 3455, 546, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[144834, 3473, 162, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.4"}],

Cell[CellGroupData[{
Cell[145021, 3481, 82, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[145106, 3485, 548, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[145669, 3503, 166, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.5"}],

Cell[CellGroupData[{
Cell[145860, 3511, 98, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[145961, 3515, 497, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[146473, 3533, 1549, 47, 70, "DefinitionBox",
  CellTags->"S2.9.7"],
Cell[148025, 3582, 92, 1, 70, "Caption",
  CellTags->"S2.9.7"],
Cell[148120, 3585, 179, 6, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.6"}],

Cell[CellGroupData[{
Cell[148324, 3595, 75, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[148402, 3599, 130, 3, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[148547, 3605, 180, 6, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.7"}],

Cell[CellGroupData[{
Cell[148752, 3615, 81, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[148836, 3619, 271, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[149122, 3629, 101, 1, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.8"}],

Cell[CellGroupData[{
Cell[149248, 3634, 86, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[149337, 3638, 294, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[149646, 3648, 3114, 93, 70, "DefinitionBox3Col",
  CellTags->"S2.9.7"],
Cell[152763, 3743, 72, 1, 70, "Caption",
  CellTags->"S2.9.7"],
Cell[152838, 3746, 159, 4, 70, "Text",
  CellTags->{"S2.9.7", "7.9"}],
Cell[153000, 3752, 548, 15, 70, "Text",
  CellTags->{"S2.9.7", "7.10"}],
Cell[153551, 3769, 210, 8, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.11"}],

Cell[CellGroupData[{
Cell[153786, 3781, 94, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[153883, 3785, 295, 8, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[154193, 3796, 140, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.12"}],

Cell[CellGroupData[{
Cell[154358, 3804, 118, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[154479, 3808, 306, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[154800, 3818, 194, 5, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.13"}],

Cell[CellGroupData[{
Cell[155019, 3827, 147, 5, 70, "Input",
  CellTags->"S2.9.7"],
Cell[155169, 3834, 430, 13, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[155614, 3850, 756, 16, 70, "Text",
  CellTags->{"S2.9.7", "7.14"}],
Cell[156373, 3868, 247, 7, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.15"}],

Cell[CellGroupData[{
Cell[156645, 3879, 85, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[156733, 3883, 125, 3, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[156873, 3889, 142, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.16"}],

Cell[CellGroupData[{
Cell[157040, 3897, 138, 5, 70, "Input",
  CellTags->"S2.9.7"],
Cell[157181, 3904, 560, 16, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[157756, 3923, 103, 1, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.17"}],

Cell[CellGroupData[{
Cell[157884, 3928, 119, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[158006, 3932, 574, 16, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[158595, 3951, 525, 11, 70, "Text",
  CellTags->{"S2.9.7", "7.18"}],
Cell[159123, 3964, 173, 5, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.19"}],

Cell[CellGroupData[{
Cell[159321, 3973, 152, 5, 70, "Input",
  CellTags->"S2.9.7"],
Cell[159476, 3980, 782, 23, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[160273, 4006, 170, 5, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.20"}],

Cell[CellGroupData[{
Cell[160468, 4015, 84, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[160555, 4019, 99, 2, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[160669, 4024, 3072, 88, 70, "DefinitionBox",
  CellTags->"S2.9.7"],
Cell[163744, 4114, 89, 1, 70, "Caption",
  CellTags->"S2.9.7"],
Cell[163836, 4117, 409, 7, 70, "Text",
  CellTags->{"S2.9.7", "7.21"}],
Cell[164248, 4126, 373, 7, 70, "Text",
  CellTags->{"S2.9.7", "7.22"}],
Cell[164624, 4135, 136, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.23"}],

Cell[CellGroupData[{
Cell[164785, 4143, 96, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[164884, 4147, 469, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[165368, 4165, 90, 1, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.24"}],

Cell[CellGroupData[{
Cell[165483, 4170, 108, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[165594, 4174, 421, 13, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[166030, 4190, 177, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.25"}],

Cell[CellGroupData[{
Cell[166232, 4198, 107, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[166342, 4202, 525, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[166882, 4220, 228, 7, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.26"}],

Cell[CellGroupData[{
Cell[167135, 4231, 107, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[167245, 4235, 509, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[167769, 4253, 280, 11, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.27"}],

Cell[CellGroupData[{
Cell[168074, 4268, 136, 5, 70, "Input",
  CellTags->"S2.9.7"],
Cell[168213, 4275, 546, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[168774, 4293, 136, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.28"}],

Cell[CellGroupData[{
Cell[168935, 4301, 137, 5, 70, "Input",
  CellTags->"S2.9.7"],
Cell[169075, 4308, 496, 14, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[169586, 4325, 569, 22, 70, "Text",
  CellTags->{"S2.9.7", "7.29"}],
Cell[170158, 4349, 117, 2, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.30"}],

Cell[CellGroupData[{
Cell[170300, 4355, 150, 5, 70, "Input",
  CellTags->"S2.9.7"],
Cell[170453, 4362, 554, 15, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[171022, 4380, 613, 19, 70, "DefinitionBox",
  CellTags->"S2.9.7"],
Cell[171638, 4401, 74, 1, 70, "Caption",
  CellTags->"S2.9.7"],
Cell[171715, 4404, 87, 1, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.31"}],

Cell[CellGroupData[{
Cell[171827, 4409, 85, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[171915, 4413, 223, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[172153, 4423, 129, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.32"}],

Cell[CellGroupData[{
Cell[172307, 4431, 88, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[172398, 4435, 212, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[172625, 4445, 144, 4, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.33"}],

Cell[CellGroupData[{
Cell[172794, 4453, 81, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[172878, 4457, 232, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[173125, 4467, 169, 5, 70, "MathCaption",
  CellTags->{"S2.9.7", "7.34"}],

Cell[CellGroupData[{
Cell[173319, 4476, 86, 2, 70, "Input",
  CellTags->"S2.9.7"],
Cell[173408, 4480, 247, 7, 70, "Output",
  CellTags->"S2.9.7"]
}, Open  ]],
Cell[173670, 4490, 274, 8, 70, "Text",
  CellTags->{"S2.9.7", "7.35"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[173981, 4503, 78, 1, 70, "Subsection",
  CellTags->{"S2.9.8", "8.1"}],
Cell[174062, 4506, 628, 18, 70, "DefinitionBox",
  CellTags->"S2.9.8"],
Cell[174693, 4526, 82, 1, 70, "Caption",
  CellTags->"S2.9.8"],
Cell[174778, 4529, 70, 1, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.2"}],

Cell[CellGroupData[{
Cell[174873, 4534, 97, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[174973, 4538, 142, 4, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[175130, 4545, 141, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.3"}],

Cell[CellGroupData[{
Cell[175296, 4553, 76, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[175375, 4557, 404, 13, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[175794, 4573, 134, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.4"}],

Cell[CellGroupData[{
Cell[175953, 4581, 77, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[176033, 4585, 442, 13, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[176490, 4601, 125, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.5"}],

Cell[CellGroupData[{
Cell[176640, 4609, 110, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[176753, 4613, 506, 13, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[177274, 4629, 1267, 38, 70, "DefinitionBox",
  CellTags->"S2.9.8"],
Cell[178544, 4669, 69, 1, 70, "Caption",
  CellTags->"S2.9.8"],
Cell[178616, 4672, 81, 1, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.6"}],

Cell[CellGroupData[{
Cell[178722, 4677, 85, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[178810, 4681, 126, 3, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[178951, 4687, 133, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.7"}],

Cell[CellGroupData[{
Cell[179109, 4695, 78, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[179190, 4699, 398, 12, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[179603, 4714, 143, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.8"}],

Cell[CellGroupData[{
Cell[179771, 4722, 94, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[179868, 4726, 803, 23, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[180686, 4752, 190, 5, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.9"}],

Cell[CellGroupData[{
Cell[180901, 4761, 106, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[181010, 4765, 436, 13, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[181461, 4781, 187, 5, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.10"}],

Cell[CellGroupData[{
Cell[181673, 4790, 116, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[181792, 4794, 818, 24, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[182625, 4821, 260, 8, 70, "Text",
  CellTags->{"S2.9.8", "8.11"}],
Cell[182888, 4831, 326, 13, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.12"}],

Cell[CellGroupData[{
Cell[183239, 4848, 94, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[183336, 4852, 374, 12, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[183725, 4867, 178, 6, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.13"}],

Cell[CellGroupData[{
Cell[183928, 4877, 116, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[184047, 4881, 1399, 47, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[185461, 4931, 191, 6, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.14"}],

Cell[CellGroupData[{
Cell[185677, 4941, 166, 5, 70, "Input",
  CellTags->"S2.9.8"],
Cell[185846, 4948, 1671, 55, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[187532, 5006, 1401, 57, 70, "Text",
  CellTags->{"S2.9.8", "8.15"}],
Cell[188936, 5065, 225, 6, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.16"}],

Cell[CellGroupData[{
Cell[189186, 5075, 165, 5, 70, "Input",
  CellTags->"S2.9.8"],
Cell[189354, 5082, 1972, 58, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[191341, 5143, 972, 35, 70, "Text",
  CellTags->{"S2.9.8", "8.17"}],
Cell[192316, 5180, 432, 10, 70, "Text",
  CellTags->{"S2.9.8", "8.18"}],
Cell[192751, 5192, 195, 5, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.19"}],

Cell[CellGroupData[{
Cell[192971, 5201, 96, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[193070, 5205, 401, 13, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[193486, 5221, 377, 10, 70, "Text",
  CellTags->{"S2.9.8", "8.20"}],
Cell[193866, 5233, 178, 5, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.21"}],

Cell[CellGroupData[{
Cell[194069, 5242, 95, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[194167, 5246, 347, 11, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[194529, 5260, 164, 5, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.22"}],

Cell[CellGroupData[{
Cell[194718, 5269, 121, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[194842, 5273, 823, 25, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[195680, 5301, 278, 9, 70, "Text",
  CellTags->{"S2.9.8", "8.23"}],
Cell[195961, 5312, 259, 9, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.24"}],

Cell[CellGroupData[{
Cell[196245, 5325, 114, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[196362, 5329, 366, 12, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[196743, 5344, 2660, 83, 70, "DefinitionBox3Col",
  CellTags->"S2.9.8"],
Cell[199406, 5429, 108, 5, 70, "Caption",
  CellTags->"S2.9.8"],
Cell[199517, 5436, 819, 30, 70, "Text",
  CellTags->{"S2.9.8", "8.25"}],
Cell[200339, 5468, 110, 1, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.26"}],

Cell[CellGroupData[{
Cell[200474, 5473, 95, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[200572, 5477, 347, 12, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[200934, 5492, 81, 1, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.27"}],

Cell[CellGroupData[{
Cell[201040, 5497, 122, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[201165, 5501, 376, 12, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[201556, 5516, 343, 7, 70, "Text",
  CellTags->{"S2.9.8", "8.28"}],
Cell[201902, 5525, 157, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.29"}],

Cell[CellGroupData[{
Cell[202084, 5533, 118, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[202205, 5537, 368, 12, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[202588, 5552, 1325, 39, 70, "DefinitionBox",
  CellTags->"S2.9.8"],
Cell[203916, 5593, 124, 5, 70, "Caption",
  CellTags->"S2.9.8"],
Cell[204043, 5600, 198, 6, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.30"}],

Cell[CellGroupData[{
Cell[204266, 5610, 123, 2, 70, "Input",
  CellTags->"S2.9.8"],
Cell[204392, 5614, 1541, 48, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[205948, 5665, 165, 4, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.31"}],

Cell[CellGroupData[{
Cell[206138, 5673, 176, 5, 70, "Input",
  CellTags->"S2.9.8"],
Cell[206317, 5680, 519, 15, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]],
Cell[206851, 5698, 213, 5, 70, "MathCaption",
  CellTags->{"S2.9.8", "8.32"}],

Cell[CellGroupData[{
Cell[207089, 5707, 168, 5, 70, "Input",
  CellTags->"S2.9.8"],
Cell[207260, 5714, 501, 15, 70, "Output",
  CellTags->"S2.9.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[207810, 5735, 85, 1, 70, "Subsection",
  CellTags->{"S2.9.9", "9.1"}],
Cell[207898, 5738, 885, 25, 70, "DefinitionBox",
  CellTags->"S2.9.9"],
Cell[208786, 5765, 67, 1, 70, "Caption",
  CellTags->"S2.9.9"],
Cell[208856, 5768, 256, 9, 70, "MathCaption",
  CellTags->{"S2.9.9", "9.2"}],

Cell[CellGroupData[{
Cell[209137, 5781, 107, 2, 70, "Input",
  CellTags->"S2.9.9"],
Cell[209247, 5785, 257, 8, 70, "Output",
  CellTags->"S2.9.9"]
}, Open  ]],
Cell[209519, 5796, 159, 5, 70, "MathCaption",
  CellTags->{"S2.9.9", "9.3"}],

Cell[CellGroupData[{
Cell[209703, 5805, 116, 2, 70, "Input",
  CellTags->"S2.9.9"],
Cell[209822, 5809, 1526, 48, 70, "Output",
  CellTags->"S2.9.9"]
}, Open  ]],
Cell[211363, 5860, 94, 1, 70, "MathCaption",
  CellTags->{"S2.9.9", "9.4"}],

Cell[CellGroupData[{
Cell[211482, 5865, 112, 2, 70, "Input",
  CellTags->"S2.9.9"],
Cell[211597, 5869, 1699, 28, 70, 1597, 24, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S2.9.9"]
}, Open  ]],
Cell[213311, 5900, 2096, 63, 70, "DefinitionBox3Col",
  CellTags->"S2.9.9"],
Cell[215410, 5965, 130, 5, 70, "Caption",
  CellTags->"S2.9.9"],
Cell[215543, 5972, 560, 16, 70, "Text",
  CellTags->{"S2.9.9", "9.5"}],
Cell[216106, 5990, 142, 4, 70, "MathCaption",
  CellTags->{"S2.9.9", "9.6"}],

Cell[CellGroupData[{
Cell[216273, 5998, 97, 2, 70, "Input",
  CellTags->"S2.9.9"],
Cell[216373, 6002, 182, 6, 70, "Output",
  CellTags->"S2.9.9"]
}, Open  ]],
Cell[216570, 6011, 565, 19, 70, "Text",
  CellTags->{"S2.9.9", "9.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[217172, 6035, 97, 1, 70, "Subsection",
  CellTags->{"S2.9.10", "10.1"}],
Cell[217272, 6038, 358, 8, 70, "Text",
  CellTags->{"S2.9.10", "10.2"}],
Cell[217633, 6048, 214, 9, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.3"}],

Cell[CellGroupData[{
Cell[217872, 6061, 79, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[217954, 6065, 105, 3, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[218074, 6071, 148, 4, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.4"}],

Cell[CellGroupData[{
Cell[218247, 6079, 79, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[218329, 6083, 127, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[218471, 6090, 528, 16, 70, "DefinitionBox",
  CellTags->"S2.9.10"],
Cell[219002, 6108, 79, 1, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[219084, 6111, 94, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.5"}],

Cell[CellGroupData[{
Cell[219203, 6116, 109, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[219315, 6120, 127, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[219457, 6127, 108, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.6"}],

Cell[CellGroupData[{
Cell[219590, 6132, 106, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[219699, 6136, 126, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[219840, 6143, 96, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.7"}],

Cell[CellGroupData[{
Cell[219961, 6148, 154, 5, 70, "Input",
  CellTags->"S2.9.10"],
Cell[220118, 6155, 135, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[220268, 6162, 8239, 255, 70, "DefinitionBox",
  CellTags->"S2.9.10"],
Cell[228510, 6419, 64, 1, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[228577, 6422, 96, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.8"}],

Cell[CellGroupData[{
Cell[228698, 6427, 112, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[228813, 6431, 135, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[228963, 6438, 105, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.9"}],

Cell[CellGroupData[{
Cell[229093, 6443, 117, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[229213, 6447, 129, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[229357, 6454, 132, 4, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.10"}],

Cell[CellGroupData[{
Cell[229514, 6462, 106, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[229623, 6466, 129, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[229767, 6473, 1685, 51, 70, "DefinitionBox",
  CellTags->"S2.9.10"],
Cell[231455, 6526, 75, 1, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[231533, 6529, 109, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.11"}],

Cell[CellGroupData[{
Cell[231667, 6534, 115, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[231785, 6538, 143, 5, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[231943, 6546, 111, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.12"}],

Cell[CellGroupData[{
Cell[232079, 6551, 161, 5, 70, "Input",
  CellTags->"S2.9.10"],
Cell[232243, 6558, 272, 10, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[232530, 6571, 104, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.13"}],

Cell[CellGroupData[{
Cell[232659, 6576, 92, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[232754, 6580, 301, 11, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[233070, 6594, 1079, 33, 70, "DefinitionBox",
  CellTags->"S2.9.10"],
Cell[234152, 6629, 77, 1, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[234232, 6632, 390, 11, 70, "Text",
  CellTags->{"S2.9.10", "10.14"}],
Cell[234625, 6645, 144, 5, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.15"}],

Cell[CellGroupData[{
Cell[234794, 6654, 122, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[234919, 6658, 171, 6, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[235105, 6667, 186, 5, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.16"}],

Cell[CellGroupData[{
Cell[235316, 6676, 112, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[235431, 6680, 161, 6, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[235607, 6689, 135, 4, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.17"}],

Cell[CellGroupData[{
Cell[235767, 6697, 149, 5, 70, "Input",
  CellTags->"S2.9.10"],
Cell[235919, 6704, 201, 7, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[236135, 6714, 400, 9, 70, "Text",
  CellTags->{"S2.9.10", "10.18"}],
Cell[236538, 6725, 1964, 61, 70, "DefinitionBox",
  CellTags->"S2.9.10"],
Cell[238505, 6788, 83, 1, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[238591, 6791, 222, 8, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.19"}],

Cell[CellGroupData[{
Cell[238838, 6803, 109, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[238950, 6807, 127, 4, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[239092, 6814, 96, 1, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.20"}],

Cell[CellGroupData[{
Cell[239213, 6819, 94, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[239310, 6823, 81, 2, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[239406, 6828, 228, 8, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.21"}],

Cell[CellGroupData[{
Cell[239659, 6840, 149, 5, 70, "Input",
  CellTags->"S2.9.10"],
Cell[239811, 6847, 173, 6, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[239999, 6856, 257, 9, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.22"}],

Cell[CellGroupData[{
Cell[240281, 6869, 94, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[240378, 6873, 87, 2, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[240480, 6878, 449, 11, 70, "Text",
  CellTags->{"S2.9.10", "10.23"}],
Cell[240932, 6891, 2357, 70, 70, "DefinitionBox3Col",
  CellTags->"S2.9.10"],
Cell[243292, 6963, 135, 5, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[243430, 6970, 843, 24, 70, "Text",
  CellTags->{"S2.9.10", "10.24"}],
Cell[244276, 6996, 485, 15, 70, "Text",
  CellTags->{"S2.9.10", "10.25"}],
Cell[244764, 7013, 161, 5, 70, "MathCaption",
  CellTags->{"S2.9.10", "10.26"}],

Cell[CellGroupData[{
Cell[244950, 7022, 125, 2, 70, "Input",
  CellTags->"S2.9.10"],
Cell[245078, 7026, 87, 3, 70, "Output",
  CellTags->"S2.9.10"]
}, Open  ]],
Cell[245180, 7032, 611, 18, 70, "DefinitionBox",
  CellTags->"S2.9.10"],
Cell[245794, 7052, 70, 1, 70, "Caption",
  CellTags->"S2.9.10"],
Cell[245867, 7055, 761, 20, 70, "Text",
  CellTags->{"S2.9.10", "10.27"}],
Cell[246631, 7077, 255, 9, 70, "Text",
  CellTags->{"S2.9.10", "10.28"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[246923, 7091, 93, 1, 70, "Subsection",
  CellTags->{"S2.9.11", "11.1"}],
Cell[247019, 7094, 389, 7, 70, "Text",
  CellTags->{"S2.9.11", "11.2"}],
Cell[247411, 7103, 3747, 114, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[251161, 7219, 106, 5, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[251270, 7226, 90, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.3"}],
Cell[251363, 7229, 103, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[251469, 7233, 186, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.4"}],

Cell[CellGroupData[{
Cell[251680, 7242, 90, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[251773, 7246, 269, 9, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[252057, 7258, 94, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.5"}],

Cell[CellGroupData[{
Cell[252176, 7263, 115, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[252294, 7267, 304, 10, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[252613, 7280, 142, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.6"}],

Cell[CellGroupData[{
Cell[252780, 7288, 139, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[252922, 7295, 316, 10, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[253253, 7308, 95, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.7"}],

Cell[CellGroupData[{
Cell[253373, 7313, 115, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[253491, 7317, 302, 10, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[253808, 7330, 102, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.8"}],

Cell[CellGroupData[{
Cell[253935, 7335, 110, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[254048, 7339, 297, 10, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[254360, 7352, 277, 8, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.9"}],

Cell[CellGroupData[{
Cell[254662, 7364, 161, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[254826, 7371, 354, 13, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[255195, 7387, 1794, 51, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[256992, 7440, 128, 5, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[257123, 7447, 535, 15, 70, "Text",
  CellTags->{"S2.9.11", "11.10"}],
Cell[257661, 7464, 583, 14, 70, "Text",
  CellTags->{"S2.9.11", "11.11"}],
Cell[258247, 7480, 1596, 47, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[259846, 7529, 125, 5, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[259974, 7536, 166, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.12"}],

Cell[CellGroupData[{
Cell[260165, 7545, 142, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[260310, 7552, 171, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[260496, 7561, 130, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.13"}],

Cell[CellGroupData[{
Cell[260651, 7569, 165, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[260819, 7576, 202, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[261036, 7586, 606, 15, 70, "Text",
  CellTags->{"S2.9.11", "11.14"}],
Cell[261645, 7603, 190, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.15"}],

Cell[CellGroupData[{
Cell[261860, 7612, 120, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[261983, 7616, 172, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[262170, 7625, 140, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.16"}],

Cell[CellGroupData[{
Cell[262335, 7633, 153, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[262491, 7640, 203, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[262709, 7650, 616, 19, 70, "Text",
  CellTags->{"S2.9.11", "11.17"}],
Cell[263328, 7671, 711, 23, 70, "Text",
  CellTags->{"S2.9.11", "11.18"}],
Cell[264042, 7696, 482, 14, 70, "Text",
  CellTags->{"S2.9.11", "11.19"}],
Cell[264527, 7712, 222, 7, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.20"}],

Cell[CellGroupData[{
Cell[264774, 7723, 180, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[264957, 7730, 391, 14, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[265363, 7747, 2178, 68, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[267544, 7817, 128, 5, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[267675, 7824, 132, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.21"}],

Cell[CellGroupData[{
Cell[267832, 7832, 128, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[267963, 7836, 177, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[268155, 7845, 203, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.22"}],

Cell[CellGroupData[{
Cell[268383, 7854, 161, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[268547, 7861, 241, 9, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[268803, 7873, 152, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.23"}],

Cell[CellGroupData[{
Cell[268980, 7882, 143, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[269126, 7889, 225, 9, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[269366, 7901, 102, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.24"}],

Cell[CellGroupData[{
Cell[269493, 7906, 168, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[269664, 7913, 264, 10, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[269943, 7926, 258, 9, 70, "Text",
  CellTags->{"S2.9.11", "11.25"}],
Cell[270204, 7937, 995, 29, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[271202, 7968, 61, 1, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[271266, 7971, 8322, 223, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[279591, 8196, 226, 6, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[279820, 8204, 845, 21, 70, "Text",
  CellTags->{"S2.9.11", "11.26"}],
Cell[280668, 8227, 262, 8, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.27"}],

Cell[CellGroupData[{
Cell[280955, 8239, 133, 3, 70, "Input",
  CellTags->"S2.9.11"],
Cell[281091, 8244, 135, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[281241, 8251, 153, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.28"}],

Cell[CellGroupData[{
Cell[281419, 8259, 192, 6, 70, "Input",
  CellTags->"S2.9.11"],
Cell[281614, 8267, 168, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[281797, 8274, 612, 18, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[282412, 8294, 131, 5, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[282546, 8301, 176, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.29"}],

Cell[CellGroupData[{
Cell[282747, 8310, 171, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[282921, 8317, 180, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[283116, 8326, 1029, 23, 70, "Text",
  CellTags->{"S2.9.11", "11.30"}],
Cell[284148, 8351, 1495, 44, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[285646, 8397, 75, 1, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[285724, 8400, 170, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.31"}],

Cell[CellGroupData[{
Cell[285919, 8409, 176, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[286098, 8416, 221, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[286334, 8426, 161, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.32"}],

Cell[CellGroupData[{
Cell[286520, 8434, 161, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[286684, 8441, 213, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[286912, 8451, 672, 15, 70, "Text",
  CellTags->{"S2.9.11", "11.33"}],
Cell[287587, 8468, 606, 18, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[288196, 8488, 91, 1, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[288290, 8491, 291, 8, 70, "Text",
  CellTags->{"S2.9.11", "11.34"}],
Cell[288584, 8501, 155, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.35"}],

Cell[CellGroupData[{
Cell[288764, 8510, 151, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[288918, 8517, 199, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[289132, 8527, 474, 10, 70, "Text",
  CellTags->{"S2.9.11", "11.36"}],
Cell[289609, 8539, 140, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.37"}],

Cell[CellGroupData[{
Cell[289774, 8547, 173, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[289950, 8554, 144, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[290109, 8561, 1610, 48, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[291722, 8611, 136, 4, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[291861, 8617, 233, 7, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.38"}],

Cell[CellGroupData[{
Cell[292119, 8628, 127, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[292249, 8632, 226, 9, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[292490, 8644, 146, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.39"}],

Cell[CellGroupData[{
Cell[292661, 8652, 144, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[292808, 8659, 231, 9, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[293054, 8671, 205, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.40"}],

Cell[CellGroupData[{
Cell[293284, 8680, 115, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[293402, 8684, 289, 11, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[293706, 8698, 111, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.41"}],

Cell[CellGroupData[{
Cell[293842, 8703, 155, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[294000, 8710, 239, 9, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[294254, 8722, 183, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.42"}],

Cell[CellGroupData[{
Cell[294462, 8731, 119, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[294584, 8735, 380, 13, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[294979, 8751, 270, 6, 70, "Text",
  CellTags->{"S2.9.11", "11.43"}],
Cell[295252, 8759, 383, 9, 70, "DefinitionBox",
  CellTags->"S2.9.11"],
Cell[295638, 8770, 92, 1, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[295733, 8773, 161, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.44"}],

Cell[CellGroupData[{
Cell[295919, 8782, 127, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[296049, 8786, 145, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[296209, 8793, 142, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.45"}],

Cell[CellGroupData[{
Cell[296376, 8801, 165, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[296544, 8808, 212, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[296771, 8818, 133, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.46"}],

Cell[CellGroupData[{
Cell[296929, 8826, 128, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[297060, 8830, 176, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[297251, 8839, 1362, 42, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[298616, 8883, 158, 4, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[298777, 8889, 161, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.47"}],

Cell[CellGroupData[{
Cell[298963, 8898, 88, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[299054, 8902, 186, 5, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[299255, 8910, 130, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.48"}],

Cell[CellGroupData[{
Cell[299410, 8918, 82, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[299495, 8922, 148, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[299658, 8929, 174, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.49"}],

Cell[CellGroupData[{
Cell[299857, 8938, 118, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[299978, 8942, 199, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[300192, 8951, 158, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.50"}],

Cell[CellGroupData[{
Cell[300375, 8959, 110, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[300488, 8963, 191, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[300694, 8972, 431, 9, 70, "Text",
  CellTags->{"S2.9.11", "11.51"}],
Cell[301128, 8983, 145, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.52"}],

Cell[CellGroupData[{
Cell[301298, 8991, 174, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[301475, 8998, 137, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[301627, 9005, 176, 5, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.53"}],

Cell[CellGroupData[{
Cell[301828, 9014, 140, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[301971, 9021, 200, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[302186, 9030, 723, 24, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[302912, 9056, 137, 5, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[303052, 9063, 142, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.54"}],

Cell[CellGroupData[{
Cell[303219, 9071, 86, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[303308, 9075, 108, 3, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[303431, 9081, 189, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.55"}],

Cell[CellGroupData[{
Cell[303645, 9089, 69, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[303717, 9093, 115, 3, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[303847, 9099, 218, 9, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.56"}],

Cell[CellGroupData[{
Cell[304090, 9112, 161, 5, 70, "Input",
  CellTags->"S2.9.11"],
Cell[304254, 9119, 198, 6, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[304467, 9128, 200, 7, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.57"}],

Cell[CellGroupData[{
Cell[304692, 9139, 102, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[304797, 9143, 227, 7, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[305039, 9153, 461, 12, 70, "Text",
  CellTags->{"S2.9.11", "11.58"}],
Cell[305503, 9167, 685, 20, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[306191, 9189, 74, 1, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[306268, 9192, 279, 6, 70, "Text",
  CellTags->{"S2.9.11", "11.59"}],
Cell[306550, 9200, 130, 4, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.60"}],

Cell[CellGroupData[{
Cell[306705, 9208, 101, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[306809, 9212, 189, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[307013, 9219, 91, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.61"}],

Cell[CellGroupData[{
Cell[307129, 9224, 102, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[307234, 9228, 275, 5, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[307524, 9236, 327, 8, 70, "Text",
  CellTags->{"S2.9.11", "11.62"}],
Cell[307854, 9246, 403, 11, 70, "Text",
  CellTags->{"S2.9.11", "11.63"}],
Cell[308260, 9259, 816, 17, 70, "Text",
  CellTags->{"S2.9.11", "11.64"}],
Cell[309079, 9278, 1901, 61, 70, "DefinitionBox3Col",
  CellTags->"S2.9.11"],
Cell[310983, 9341, 84, 1, 70, "Caption",
  CellTags->"S2.9.11"],
Cell[311070, 9344, 282, 7, 70, "Text",
  CellTags->{"S2.9.11", "11.65"}],
Cell[311355, 9353, 121, 2, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.66"}],

Cell[CellGroupData[{
Cell[311501, 9359, 75, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[311579, 9363, 201, 4, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]],
Cell[311795, 9370, 103, 1, 70, "MathCaption",
  CellTags->{"S2.9.11", "11.67"}],

Cell[CellGroupData[{
Cell[311923, 9375, 85, 2, 70, "Input",
  CellTags->"S2.9.11"],
Cell[312011, 9379, 191, 5, 70, "Output",
  CellTags->"S2.9.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[312251, 9390, 92, 1, 70, "Subsection",
  CellTags->{"S2.9.12", "12.1"}],
Cell[312346, 9393, 280, 6, 70, "Text",
  CellTags->{"S2.9.12", "12.2"}],
Cell[312629, 9401, 199, 7, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.3"}],

Cell[CellGroupData[{
Cell[312853, 9412, 114, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[312970, 9416, 95, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[313080, 9422, 133, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.4"}],

Cell[CellGroupData[{
Cell[313238, 9431, 80, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[313321, 9435, 106, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[313442, 9441, 177, 6, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.5"}],

Cell[CellGroupData[{
Cell[313644, 9451, 92, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[313739, 9455, 245, 8, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[313999, 9466, 222, 6, 70, "Text",
  CellTags->{"S2.9.12", "12.6"}],
Cell[314224, 9474, 142, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.7"}],

Cell[CellGroupData[{
Cell[314391, 9483, 80, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[314474, 9487, 106, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[314595, 9493, 166, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.8"}],

Cell[CellGroupData[{
Cell[314786, 9502, 83, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[314872, 9506, 86, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[314973, 9512, 98, 1, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.9"}],

Cell[CellGroupData[{
Cell[315096, 9517, 95, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[315194, 9521, 245, 8, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[315454, 9532, 737, 22, 70, "DefinitionBox",
  CellTags->"S2.9.12"],
Cell[316194, 9556, 114, 4, 70, "Caption",
  CellTags->"S2.9.12"],
Cell[316311, 9562, 736, 20, 70, "Text",
  CellTags->{"S2.9.12", "12.10"}],
Cell[317050, 9584, 664, 23, 70, "Text",
  CellTags->{"S2.9.12", "12.11"}],
Cell[317717, 9609, 723, 20, 70, "DefinitionBox",
  CellTags->"S2.9.12"],
Cell[318443, 9631, 113, 4, 70, "Caption",
  CellTags->"S2.9.12"],
Cell[318559, 9637, 569, 16, 70, "Text",
  CellTags->{"S2.9.12", "12.12"}],
Cell[319131, 9655, 152, 4, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.13"}],

Cell[CellGroupData[{
Cell[319308, 9663, 84, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[319395, 9667, 96, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[319506, 9673, 198, 7, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.14"}],

Cell[CellGroupData[{
Cell[319729, 9684, 87, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[319819, 9688, 98, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[319932, 9694, 95, 1, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.15"}],

Cell[CellGroupData[{
Cell[320052, 9699, 113, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[320168, 9703, 120, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[320303, 9709, 12884, 369, 70, "DefinitionBox",
  CellTags->"S2.9.12"],
Cell[333190, 10080, 65, 1, 70, "Caption",
  CellTags->"S2.9.12"],
Cell[333258, 10083, 506, 17, 70, "Text",
  CellTags->{"S2.9.12", "12.16"}],
Cell[333767, 10102, 116, 2, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.17"}],

Cell[CellGroupData[{
Cell[333908, 10108, 102, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[334013, 10112, 137, 4, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[334165, 10119, 117, 2, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.18"}],

Cell[CellGroupData[{
Cell[334307, 10125, 100, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[334410, 10129, 131, 4, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[334556, 10136, 226, 7, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.19"}],

Cell[CellGroupData[{
Cell[334807, 10147, 106, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[334916, 10151, 135, 4, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[335066, 10158, 237, 9, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.20"}],

Cell[CellGroupData[{
Cell[335328, 10171, 91, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[335422, 10175, 124, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[335561, 10181, 683, 22, 70, "Text",
  CellTags->{"S2.9.12", "12.21"}],
Cell[336247, 10205, 243, 11, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.22"}],

Cell[CellGroupData[{
Cell[336515, 10220, 91, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[336609, 10224, 276, 8, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[336900, 10235, 151, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.23"}],

Cell[CellGroupData[{
Cell[337076, 10244, 93, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[337172, 10248, 276, 8, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[337463, 10259, 116, 4, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.24"}],

Cell[CellGroupData[{
Cell[337604, 10267, 99, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[337706, 10271, 305, 9, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[338026, 10283, 144, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.25"}],

Cell[CellGroupData[{
Cell[338195, 10292, 94, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[338292, 10296, 333, 10, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[338640, 10309, 221, 6, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.26"}],

Cell[CellGroupData[{
Cell[338886, 10319, 92, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[338981, 10323, 310, 9, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[339306, 10335, 535, 18, 70, "Text",
  CellTags->{"S2.9.12", "12.27"}],
Cell[339844, 10355, 128, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.28"}],

Cell[CellGroupData[{
Cell[339997, 10364, 135, 3, 70, "Input",
  CellTags->"S2.9.12"],
Cell[340135, 10369, 184, 7, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[340334, 10379, 129, 5, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.29"}],

Cell[CellGroupData[{
Cell[340488, 10388, 134, 3, 70, "Input",
  CellTags->"S2.9.12"],
Cell[340625, 10393, 170, 6, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[340810, 10402, 575, 21, 70, "Text",
  CellTags->{"S2.9.12", "12.30"}],
Cell[341388, 10425, 400, 17, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.31"}],

Cell[CellGroupData[{
Cell[341813, 10446, 206, 6, 70, "Input",
  CellTags->"S2.9.12"],
Cell[342022, 10454, 347, 12, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[342384, 10469, 398, 11, 70, "Text",
  CellTags->{"S2.9.12", "12.32"}],
Cell[342785, 10482, 915, 26, 70, "DefinitionBox",
  CellTags->"S2.9.12"],
Cell[343703, 10510, 84, 1, 70, "Caption",
  CellTags->"S2.9.12"],
Cell[343790, 10513, 215, 7, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.33"}],

Cell[CellGroupData[{
Cell[344030, 10524, 83, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[344116, 10528, 97, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[344228, 10534, 218, 7, 70, "MathCaption",
  CellTags->{"S2.9.12", "12.34"}],

Cell[CellGroupData[{
Cell[344471, 10545, 101, 2, 70, "Input",
  CellTags->"S2.9.12"],
Cell[344575, 10549, 91, 3, 70, "Output",
  CellTags->"S2.9.12"]
}, Open  ]],
Cell[344681, 10555, 458, 8, 70, "Text",
  CellTags->{"S2.9.12", "12.35"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[345176, 10568, 111, 1, 70, "Subsection",
  CellTags->{"S2.9.13", "13.1"}],
Cell[345290, 10571, 2452, 75, 70, "DefinitionBox",
  CellTags->"S2.9.13"],
Cell[347745, 10648, 93, 1, 70, "Caption",
  CellTags->"S2.9.13"],
Cell[347841, 10651, 85, 1, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.2"}],

Cell[CellGroupData[{
Cell[347951, 10656, 74, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[348028, 10660, 93, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[348136, 10666, 156, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.3"}],

Cell[CellGroupData[{
Cell[348317, 10675, 95, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[348415, 10679, 93, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[348523, 10685, 157, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.4"}],

Cell[CellGroupData[{
Cell[348705, 10694, 76, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[348784, 10698, 249, 8, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[349048, 10709, 197, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.5"}],

Cell[CellGroupData[{
Cell[349270, 10718, 110, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[349383, 10722, 262, 8, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[349660, 10733, 131, 4, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.6"}],

Cell[CellGroupData[{
Cell[349816, 10741, 97, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[349916, 10745, 156, 4, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[350087, 10752, 295, 7, 70, "Text",
  CellTags->{"S2.9.13", "13.7"}],
Cell[350385, 10761, 199, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.8"}],

Cell[CellGroupData[{
Cell[350609, 10770, 96, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[350708, 10774, 99, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[350822, 10780, 182, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.9"}],

Cell[CellGroupData[{
Cell[351029, 10789, 76, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[351108, 10793, 256, 8, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[351379, 10804, 107, 1, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.10"}],

Cell[CellGroupData[{
Cell[351511, 10809, 114, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[351628, 10813, 201, 6, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[351844, 10822, 243, 6, 70, "Text",
  CellTags->{"S2.9.13", "13.11"}],
Cell[352090, 10830, 200, 7, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.12"}],

Cell[CellGroupData[{
Cell[352315, 10841, 123, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[352441, 10845, 95, 2, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[352551, 10850, 781, 23, 70, "DefinitionBox",
  CellTags->"S2.9.13"],
Cell[353335, 10875, 122, 5, 70, "Caption",
  CellTags->"S2.9.13"],
Cell[353460, 10882, 154, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.13"}],

Cell[CellGroupData[{
Cell[353639, 10891, 93, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[353735, 10895, 94, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[353844, 10901, 159, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.14"}],

Cell[CellGroupData[{
Cell[354028, 10910, 165, 5, 70, "Input",
  CellTags->"S2.9.13"],
Cell[354196, 10917, 94, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[354305, 10923, 146, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.15"}],

Cell[CellGroupData[{
Cell[354476, 10932, 99, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[354578, 10936, 94, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[354687, 10942, 81, 1, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.16"}],

Cell[CellGroupData[{
Cell[354793, 10947, 103, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[354899, 10951, 157, 4, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[355071, 10958, 84, 1, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.17"}],

Cell[CellGroupData[{
Cell[355180, 10963, 106, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[355289, 10967, 94, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[355398, 10973, 156, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.18"}],

Cell[CellGroupData[{
Cell[355579, 10982, 118, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[355700, 10986, 100, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[355815, 10992, 719, 22, 70, "DefinitionBox",
  CellTags->"S2.9.13"],
Cell[356537, 11016, 91, 1, 70, "Caption",
  CellTags->"S2.9.13"],
Cell[356631, 11019, 118, 2, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.19"}],

Cell[CellGroupData[{
Cell[356774, 11025, 89, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[356866, 11029, 84, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[356965, 11035, 205, 7, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.20"}],

Cell[CellGroupData[{
Cell[357195, 11046, 109, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[357307, 11050, 94, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[357416, 11056, 176, 7, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.21"}],

Cell[CellGroupData[{
Cell[357617, 11067, 80, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[357700, 11071, 84, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[357799, 11077, 897, 26, 70, "DefinitionBox",
  CellTags->"S2.9.13"],
Cell[358699, 11105, 83, 1, 70, "Caption",
  CellTags->"S2.9.13"],
Cell[358785, 11108, 353, 9, 70, "Text",
  CellTags->{"S2.9.13", "13.22"}],
Cell[359141, 11119, 196, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.23"}],

Cell[CellGroupData[{
Cell[359362, 11128, 91, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[359456, 11132, 163, 4, 70, "Message",
  CellTags->"S2.9.13"],
Cell[359622, 11138, 90, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[359727, 11144, 238, 8, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.24"}],

Cell[CellGroupData[{
Cell[359990, 11156, 92, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[360085, 11160, 122, 4, 70, "Message",
  CellTags->"S2.9.13"],
Cell[360210, 11166, 90, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[360315, 11172, 567, 17, 70, "Text",
  CellTags->{"S2.9.13", "13.25"}],
Cell[360885, 11191, 218, 6, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.26"}],

Cell[CellGroupData[{
Cell[361128, 11201, 86, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[361217, 11205, 88, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[361320, 11211, 186, 5, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.27"}],

Cell[CellGroupData[{
Cell[361531, 11220, 91, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[361625, 11224, 84, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]],
Cell[361724, 11230, 260, 6, 70, "MathCaption",
  CellTags->{"S2.9.13", "13.28"}],

Cell[CellGroupData[{
Cell[362009, 11240, 92, 2, 70, "Input",
  CellTags->"S2.9.13"],
Cell[362104, 11244, 85, 3, 70, "Output",
  CellTags->"S2.9.13"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[362238, 11253, 145, 5, 70, "Subsection",
  CellTags->{"S2.9.14", "14.1"}],
Cell[362386, 11260, 572, 14, 70, "Text",
  CellTags->{"S2.9.14", "14.2"}],
Cell[362961, 11276, 1941, 58, 70, "DefinitionBox",
  CellTags->"S2.9.14"],
Cell[364905, 11336, 131, 5, 70, "Caption",
  CellTags->"S2.9.14"],
Cell[365039, 11343, 335, 9, 70, "Text",
  CellTags->{"S2.9.14", "14.3"}],
Cell[365377, 11354, 623, 27, 70, "Text",
  CellTags->{"S2.9.14", "14.4"}],
Cell[366003, 11383, 378, 8, 70, "Text",
  CellTags->{"S2.9.14", "14.5"}],
Cell[366384, 11393, 3265, 107, 70, "DefinitionBox3Col",
  CellTags->"S2.9.14"],
Cell[369652, 11502, 148, 5, 70, "Caption",
  CellTags->"S2.9.14"],
Cell[369803, 11509, 279, 6, 70, "Text",
  CellTags->{"S2.9.14", "14.6"}],
Cell[370085, 11517, 352, 13, 70, "Text",
  CellTags->{"S2.9.14", "14.7"}],
Cell[370440, 11532, 301, 8, 70, "Text",
  CellTags->{"S2.9.14", "14.8"}],
Cell[370744, 11542, 389, 13, 70, "Text",
  CellTags->{"S2.9.14", "14.9"}],
Cell[371136, 11557, 252, 9, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.10"}],

Cell[CellGroupData[{
Cell[371413, 11570, 107, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[371523, 11574, 512, 16, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[372050, 11593, 144, 5, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.11"}],

Cell[CellGroupData[{
Cell[372219, 11602, 79, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[372301, 11606, 93, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[372409, 11612, 137, 5, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.12"}],

Cell[CellGroupData[{
Cell[372571, 11621, 78, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[372652, 11625, 93, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[372760, 11631, 241, 5, 70, "Text",
  CellTags->{"S2.9.14", "14.13"}],
Cell[373004, 11638, 204, 7, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.14"}],

Cell[CellGroupData[{
Cell[373233, 11649, 86, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[373322, 11653, 254, 8, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[373591, 11664, 7458, 233, 70, "DefinitionBox",
  CellTags->"S2.9.14"],
Cell[381052, 11899, 98, 1, 70, "Caption",
  CellTags->"S2.9.14"],
Cell[381153, 11902, 613, 15, 70, "Text",
  CellTags->{"S2.9.14", "14.15"}],
Cell[381769, 11919, 132, 4, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.16"}],

Cell[CellGroupData[{
Cell[381926, 11927, 212, 4, 70, "Input",
  CellTags->"S2.9.14"],
Cell[382141, 11933, 225, 5, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[382381, 11941, 164, 4, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.17"}],

Cell[CellGroupData[{
Cell[382570, 11949, 76, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[382649, 11953, 366, 10, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[383030, 11966, 165, 4, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.18"}],

Cell[CellGroupData[{
Cell[383220, 11974, 104, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[383327, 11978, 152, 4, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[383494, 11985, 2254, 79, 70, "DefinitionBox3Col",
  CellTags->"S2.9.14"],
Cell[385751, 12066, 81, 1, 70, "Caption",
  CellTags->"S2.9.14"],
Cell[385835, 12069, 182, 6, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.19"}],

Cell[CellGroupData[{
Cell[386042, 12079, 88, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[386133, 12083, 250, 8, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[386398, 12094, 187, 6, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.20"}],

Cell[CellGroupData[{
Cell[386610, 12104, 88, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[386701, 12108, 265, 8, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[386981, 12119, 314, 8, 70, "Text",
  CellTags->{"S2.9.14", "14.21"}],
Cell[387298, 12129, 754, 23, 70, "Text",
  CellTags->{"S2.9.14", "14.22"}],
Cell[388055, 12154, 659, 19, 70, "Text",
  CellTags->{"S2.9.14", "14.23"}],
Cell[388717, 12175, 173, 5, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.24"}],

Cell[CellGroupData[{
Cell[388915, 12184, 111, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[389029, 12188, 254, 8, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[389298, 12199, 222, 7, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.25"}],

Cell[CellGroupData[{
Cell[389545, 12210, 122, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[389670, 12214, 96, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[389781, 12220, 649, 20, 70, "Text",
  CellTags->{"S2.9.14", "14.26"}],
Cell[390433, 12242, 285, 9, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.27"}],

Cell[CellGroupData[{
Cell[390743, 12255, 112, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[390858, 12259, 253, 8, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[391126, 12270, 421, 14, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.28"}],

Cell[CellGroupData[{
Cell[391572, 12288, 112, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[391687, 12292, 133, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[391835, 12298, 95, 1, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.29"}],

Cell[CellGroupData[{
Cell[391955, 12303, 116, 2, 70, "Input",
  CellTags->"S2.9.14"],
Cell[392074, 12307, 136, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[392225, 12313, 403, 9, 70, "Text",
  CellTags->{"S2.9.14", "14.30"}],
Cell[392631, 12324, 101, 1, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.31"}],

Cell[CellGroupData[{
Cell[392757, 12329, 94, 3, 70, "Input",
  CellTags->"S2.9.14"],
Cell[392854, 12334, 95, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[392964, 12340, 295, 10, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.32"}],

Cell[CellGroupData[{
Cell[393284, 12354, 101, 3, 70, "Input",
  CellTags->"S2.9.14"],
Cell[393388, 12359, 103, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[393506, 12365, 219, 6, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.33"}],

Cell[CellGroupData[{
Cell[393750, 12375, 120, 3, 70, "Input",
  CellTags->"S2.9.14"],
Cell[393873, 12380, 90, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]],
Cell[393978, 12386, 221, 8, 70, "MathCaption",
  CellTags->{"S2.9.14", "14.34"}],

Cell[CellGroupData[{
Cell[394224, 12398, 124, 3, 70, "Input",
  CellTags->"S2.9.14"],
Cell[394351, 12403, 94, 3, 70, "Output",
  CellTags->"S2.9.14"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[394494, 12412, 115, 4, 70, "Subsection",
  CellTags->{"S2.9.15", "15.1"}],
Cell[394612, 12418, 551, 21, 70, "Text",
  CellTags->{"S2.9.15", "15.2"}],
Cell[395166, 12441, 406, 9, 70, "Text",
  CellTags->{"S2.9.15", "15.3"}],
Cell[395575, 12452, 195, 6, 70, "Text",
  CellTags->{"S2.9.15", "15.4"}],
Cell[395773, 12460, 225, 6, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.5"}],

Cell[CellGroupData[{
Cell[396023, 12470, 108, 3, 70, "Input",
  CellTags->"S2.9.15"],
Cell[396134, 12475, 250, 8, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[396399, 12486, 230, 8, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.6"}],

Cell[CellGroupData[{
Cell[396654, 12498, 96, 3, 70, "Input",
  CellTags->"S2.9.15"],
Cell[396753, 12503, 97, 3, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[396865, 12509, 184, 6, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.7"}],
Cell[397052, 12517, 101, 2, 70, "Input",
  CellTags->"S2.9.15"],
Cell[397156, 12521, 226, 6, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.8"}],

Cell[CellGroupData[{
Cell[397407, 12531, 82, 2, 70, "Input",
  CellTags->"S2.9.15"],
Cell[397492, 12535, 83, 3, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[397590, 12541, 3962, 127, 70, "DefinitionBox",
  CellTags->"S2.9.15"],
Cell[401555, 12670, 168, 5, 70, "Caption",
  CellTags->"S2.9.15"],
Cell[401726, 12677, 274, 6, 70, "Text",
  CellTags->{"S2.9.15", "15.9"}],
Cell[402003, 12685, 227, 8, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.10"}],

Cell[CellGroupData[{
Cell[402255, 12697, 82, 2, 70, "Input",
  CellTags->"S2.9.15"],
Cell[402340, 12701, 98, 3, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[402453, 12707, 143, 5, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.11"}],

Cell[CellGroupData[{
Cell[402621, 12716, 76, 2, 70, "Input",
  CellTags->"S2.9.15"],
Cell[402700, 12720, 249, 8, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[402964, 12731, 2188, 72, 70, "DefinitionBox",
  CellTags->"S2.9.15"],
Cell[405155, 12805, 176, 5, 70, "Caption",
  CellTags->"S2.9.15"],
Cell[405334, 12812, 702, 19, 70, "Text",
  CellTags->{"S2.9.15", "15.12"}],
Cell[406039, 12833, 483, 15, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.13"}],

Cell[CellGroupData[{
Cell[406547, 12852, 111, 2, 70, "Input",
  CellTags->"S2.9.15"],
Cell[406661, 12856, 268, 8, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[406944, 12867, 9539, 222, 70, "DoubleBox",
  CellTags->"S2.9.15"],
Cell[416486, 13091, 122, 4, 70, "Caption",
  CellTags->"S2.9.15"],
Cell[416611, 13097, 161, 5, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.14"}],

Cell[CellGroupData[{
Cell[416797, 13106, 105, 3, 70, "Input",
  CellTags->"S2.9.15"],
Cell[416905, 13111, 110, 2, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[417030, 13116, 131, 4, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.15"}],

Cell[CellGroupData[{
Cell[417186, 13124, 105, 3, 70, "Input",
  CellTags->"S2.9.15"],
Cell[417294, 13129, 86, 2, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[417395, 13134, 117, 2, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.16"}],

Cell[CellGroupData[{
Cell[417537, 13140, 118, 3, 70, "Input",
  CellTags->"S2.9.15"],
Cell[417658, 13145, 107, 2, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]],
Cell[417780, 13150, 181, 7, 70, "MathCaption",
  CellTags->{"S2.9.15", "15.17"}],

Cell[CellGroupData[{
Cell[417986, 13161, 110, 3, 70, "Input",
  CellTags->"S2.9.15"],
Cell[418099, 13166, 101, 2, 70, "Output",
  CellTags->"S2.9.15"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[418249, 13174, 85, 1, 70, "Subsection",
  CellTags->{"S2.9.16", "16.1"}],
Cell[418337, 13177, 812, 21, 70, "Text",
  CellTags->{"S2.9.16", "16.2"}],
Cell[419152, 13200, 191, 7, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.3"}],
Cell[419346, 13209, 110, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[419459, 13213, 163, 5, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.4"}],

Cell[CellGroupData[{
Cell[419647, 13222, 78, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[419728, 13226, 362, 12, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[420105, 13241, 161, 5, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.5"}],

Cell[CellGroupData[{
Cell[420291, 13250, 76, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[420370, 13254, 252, 8, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[420637, 13265, 2126, 60, 70, "DefinitionBox",
  CellTags->"S2.9.16"],
Cell[422766, 13327, 82, 1, 70, "Caption",
  CellTags->"S2.9.16"],
Cell[422851, 13330, 394, 11, 70, "Text",
  CellTags->{"S2.9.16", "16.6"}],
Cell[423248, 13343, 238, 7, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.7"}],
Cell[423489, 13352, 114, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[423606, 13356, 153, 5, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.8"}],

Cell[CellGroupData[{
Cell[423784, 13365, 92, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[423879, 13369, 108, 3, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[424002, 13375, 163, 5, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.9"}],

Cell[CellGroupData[{
Cell[424190, 13384, 85, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[424278, 13388, 97, 3, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[424390, 13394, 4478, 152, 70, "DefinitionBox",
  CellTags->"S2.9.16"],
Cell[428871, 13548, 70, 1, 70, "Caption",
  CellTags->"S2.9.16"],
Cell[428944, 13551, 236, 8, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.10"}],

Cell[CellGroupData[{
Cell[429205, 13563, 85, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[429293, 13567, 172, 6, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[429480, 13576, 323, 9, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.11"}],

Cell[CellGroupData[{
Cell[429828, 13589, 113, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[429944, 13593, 239, 6, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[430198, 13602, 468, 12, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.12"}],

Cell[CellGroupData[{
Cell[430691, 13618, 68, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[430762, 13622, 308, 8, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[431085, 13633, 829, 18, 70, "Text",
  CellTags->{"S2.9.16", "16.13"}],
Cell[431917, 13653, 391, 11, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.14"}],

Cell[CellGroupData[{
Cell[432333, 13668, 90, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[432426, 13672, 383, 11, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]],
Cell[432824, 13686, 559, 18, 70, "Text",
  CellTags->{"S2.9.16", "16.15"}],
Cell[433386, 13706, 174, 7, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.16"}],
Cell[433563, 13715, 102, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[433668, 13719, 189, 5, 70, "MathCaption",
  CellTags->{"S2.9.16", "16.17"}],

Cell[CellGroupData[{
Cell[433882, 13728, 82, 2, 70, "Input",
  CellTags->"S2.9.16"],
Cell[433967, 13732, 81, 2, 70, "Output",
  CellTags->"S2.9.16"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[434097, 13740, 128, 4, 70, "Subsection",
  CellTags->{"S2.9.17", "17.1"}],
Cell[434228, 13746, 1062, 32, 70, "DefinitionBox",
  CellTags->"S2.9.17"],
Cell[435293, 13780, 126, 4, 70, "Caption",
  CellTags->"S2.9.17"],
Cell[435422, 13786, 150, 4, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.2"}],

Cell[CellGroupData[{
Cell[435597, 13794, 95, 2, 70, "Input",
  CellTags->"S2.9.17"],
Cell[435695, 13798, 105, 3, 70, "Output",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[435815, 13804, 234, 6, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.3"}],

Cell[CellGroupData[{
Cell[436074, 13814, 96, 2, 70, "Input",
  CellTags->"S2.9.17"],
Cell[436173, 13818, 101, 3, 70, "Output",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[436289, 13824, 361, 9, 70, "Text",
  CellTags->{"S2.9.17", "17.4"}],
Cell[436653, 13835, 325, 7, 70, "Text",
  CellTags->{"S2.9.17", "17.5"}],
Cell[436981, 13844, 367, 9, 70, "Text",
  CellTags->{"S2.9.17", "17.6"}],
Cell[437351, 13855, 189, 6, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.7"}],

Cell[CellGroupData[{
Cell[437565, 13865, 84, 2, 70, "Input",
  CellTags->"S2.9.17"],
Cell[437652, 13869, 111, 3, 70, "Output",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[437778, 13875, 212, 7, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.8"}],

Cell[CellGroupData[{
Cell[438015, 13886, 110, 2, 70, "Input",
  CellTags->"S2.9.17"],
Cell[438128, 13890, 253, 8, 70, "Output",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[438396, 13901, 490, 12, 70, "Text",
  CellTags->{"S2.9.17", "17.9"}],
Cell[438889, 13915, 487, 11, 70, "Text",
  CellTags->{"S2.9.17", "17.10"}],
Cell[439379, 13928, 194, 7, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.11"}],
Cell[439576, 13937, 260, 6, 70, "Input",
  CellTags->"S2.9.17"],
Cell[439839, 13945, 220, 7, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.12"}],

Cell[CellGroupData[{
Cell[440084, 13956, 81, 2, 70, "Input",
  CellTags->"S2.9.17"],
Cell[440168, 13960, 112, 3, 70, "Output",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[440295, 13966, 147, 4, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.13"}],

Cell[CellGroupData[{
Cell[440467, 13974, 111, 3, 70, "Input",
  CellTags->"S2.9.17"],
Cell[440581, 13979, 153, 3, 70, "Message",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[440749, 13985, 302, 10, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.14"}],
Cell[441054, 13997, 253, 6, 70, "Input",
  CellTags->"S2.9.17"],
Cell[441310, 14005, 232, 8, 70, "MathCaption",
  CellTags->{"S2.9.17", "17.15"}],

Cell[CellGroupData[{
Cell[441567, 14017, 123, 3, 70, "Input",
  CellTags->"S2.9.17"],
Cell[441693, 14022, 257, 8, 70, "Output",
  CellTags->"S2.9.17"]
}, Open  ]],
Cell[441965, 14033, 491, 12, 70, "Text",
  CellTags->{"S2.9.17", "17.16"}],
Cell[442459, 14047, 462, 12, 70, "Text",
  CellTags->{"S2.9.17", "17.17"}],
Cell[442924, 14061, 832, 23, 70, "FramedBox",
  CellTags->"S2.9.17"],
Cell[443759, 14086, 124, 5, 70, "Caption",
  CellTags->"S2.9.17"]
}, Open  ]],

Cell[CellGroupData[{
Cell[443920, 14096, 92, 1, 70, "Subsection",
  CellTags->{"S2.9.18", "18.1"}],
Cell[444015, 14099, 266, 6, 70, "Text",
  CellTags->{"S2.9.18", "18.2"}],
Cell[444284, 14107, 568, 14, 70, "Text",
  CellTags->{"S2.9.18", "18.3"}],
Cell[444855, 14123, 1334, 39, 70, "DefinitionBox",
  CellTags->"S2.9.18"],
Cell[446192, 14164, 64, 1, 70, "Caption",
  CellTags->"S2.9.18"],
Cell[446259, 14167, 194, 5, 70, "MathCaption",
  CellTags->{"S2.9.18", "18.4"}],

Cell[CellGroupData[{
Cell[446478, 14176, 86, 2, 70, "Input",
  CellTags->"S2.9.18"],
Cell[446567, 14180, 144, 4, 70, "Print",
  CellTags->"S2.9.18"],
Cell[446714, 14186, 57, 2, 70, "Print",
  CellTags->"S2.9.18"]
}, Open  ]],
Cell[446786, 14191, 132, 4, 70, "MathCaption",
  CellTags->{"S2.9.18", "18.5"}],

Cell[CellGroupData[{
Cell[446943, 14199, 97, 2, 70, "Input",
  CellTags->"S2.9.18"],
Cell[447043, 14203, 171, 4, 70, "Print",
  CellTags->"S2.9.18"],
Cell[447217, 14209, 171, 4, 70, "Print",
  CellTags->"S2.9.18"],
Cell[447391, 14215, 171, 4, 70, "Print",
  CellTags->"S2.9.18"],
Cell[447565, 14221, 173, 4, 70, "Print",
  CellTags->"S2.9.18"],
Cell[447741, 14227, 173, 4, 70, "Print",
  CellTags->"S2.9.18"]
}, Open  ]],
Cell[447929, 14234, 374, 9, 70, "Text",
  CellTags->{"S2.9.18", "18.6"}],
Cell[448306, 14245, 103, 1, 70, "MathCaption",
  CellTags->{"S2.9.18", "18.7"}],

Cell[CellGroupData[{
Cell[448434, 14250, 99, 2, 70, "Input",
  CellTags->"S2.9.18"],
Cell[448536, 14254, 305, 11, 70, "Print",
  CellTags->"S2.9.18"]
}, Open  ]],
Cell[448856, 14268, 154, 5, 70, "MathCaption",
  CellTags->{"S2.9.18", "18.8"}],

Cell[CellGroupData[{
Cell[449035, 14277, 112, 2, 70, "Input",
  CellTags->"S2.9.18"],
Cell[449150, 14281, 225, 6, 70, "Print",
  CellTags->"S2.9.18"]
}, Open  ]],
Cell[449390, 14290, 294, 8, 70, "Text",
  CellTags->{"S2.9.18", "18.9"}],
Cell[449687, 14300, 147, 5, 70, "MathCaption",
  CellTags->{"S2.9.18", "18.10"}],

Cell[CellGroupData[{
Cell[449859, 14309, 92, 2, 70, "Input",
  CellTags->"S2.9.18"],
Cell[449954, 14313, 298, 11, 70, "Print",
  CellTags->"S2.9.18"]
}, Open  ]],
Cell[450267, 14327, 762, 19, 70, "Text",
  CellTags->{"S2.9.18", "18.11"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[451066, 14351, 99, 1, 70, "Subsection",
  CellTags->{"S2.9.19", "19.1"}],
Cell[451168, 14354, 906, 26, 70, "DefinitionBox",
  CellTags->"S2.9.19"],
Cell[452077, 14382, 81, 1, 70, "Caption",
  CellTags->"S2.9.19"],
Cell[452161, 14385, 104, 1, 70, "MathCaption",
  CellTags->{"S2.9.19", "19.2"}],

Cell[CellGroupData[{
Cell[452290, 14390, 106, 2, 70, "Input",
  CellTags->"S2.9.19"],
Cell[452399, 14394, 7796, 100, 70, 7660, 95, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S2.9.19"]
}, Open  ]],
Cell[460210, 14497, 94, 1, 70, "MathCaption",
  CellTags->{"S2.9.19", "19.3"}],

Cell[CellGroupData[{
Cell[460329, 14502, 97, 2, 70, "Input",
  CellTags->"S2.9.19"],
Cell[460429, 14506, 12122, 154, 70, 11986, 149, "GraphicsData", "Bitmap", \
"Picture",
  Evaluatable->False,
  CellTags->"S2.9.19"]
}, Open  ]],
Cell[472566, 14663, 413, 12, 70, "Text",
  CellTags->{"S2.9.19", "19.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[473016, 14680, 78, 1, 70, "Subsection",
  CellTags->{"S2.9.20", "20.1"}],
Cell[473097, 14683, 369, 10, 70, "Text",
  CellTags->{"S2.9.20", "20.2"}],
Cell[473469, 14695, 1060, 30, 70, "DefinitionBox",
  CellTags->"S2.9.20"],
Cell[474532, 14727, 61, 1, 70, "Caption",
  CellTags->"S2.9.20"],
Cell[474596, 14730, 552, 13, 70, "Text",
  CellTags->{"S2.9.20", "20.3"}],
Cell[475151, 14745, 291, 9, 70, "Text",
  CellTags->{"S2.9.20", "20.4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[475479, 14759, 70, 1, 70, "Subsection",
  CellTags->{"S2.9.21", "21.1"}],
Cell[475552, 14762, 393, 9, 70, "Text",
  CellTags->{"S2.9.21", "21.2"}],
Cell[475948, 14773, 414, 13, 70, "Text",
  CellTags->{"S2.9.21", "21.3"}],
Cell[476365, 14788, 775, 22, 70, "DefinitionBox",
  CellTags->"S2.9.21"],
Cell[477143, 14812, 80, 1, 70, "Caption",
  CellTags->"S2.9.21"],
Cell[477226, 14815, 498, 14, 70, "Text",
  CellTags->{"S2.9.21", "21.4"}],
Cell[477727, 14831, 87, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.5"}],

Cell[CellGroupData[{
Cell[477839, 14836, 77, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[477919, 14840, 180, 4, 70, "Message",
  CellTags->"S2.9.21"],
Cell[478102, 14846, 94, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[478211, 14852, 98, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.6"}],
Cell[478312, 14855, 79, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[478394, 14859, 92, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.7"}],

Cell[CellGroupData[{
Cell[478511, 14864, 77, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[478591, 14868, 94, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[478700, 14874, 521, 12, 70, "Text",
  CellTags->{"S2.9.21", "21.8"}],
Cell[479224, 14888, 1047, 32, 70, "DefinitionBox",
  CellTags->"S2.9.21"],
Cell[480274, 14922, 65, 1, 70, "Caption",
  CellTags->"S2.9.21"],
Cell[480342, 14925, 621, 21, 70, "Text",
  CellTags->{"S2.9.21", "21.9"}],
Cell[480966, 14948, 173, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.10"}],

Cell[CellGroupData[{
Cell[481164, 14957, 102, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[481269, 14961, 154, 3, 70, "Message",
  CellTags->"S2.9.21"],
Cell[481426, 14966, 119, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[481560, 14972, 90, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.11"}],

Cell[CellGroupData[{
Cell[481675, 14977, 83, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[481761, 14981, 134, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[481910, 14987, 85, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.12"}],

Cell[CellGroupData[{
Cell[482020, 14992, 127, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[482150, 14996, 121, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[482286, 15002, 88, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.13"}],

Cell[CellGroupData[{
Cell[482399, 15007, 102, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[482504, 15011, 141, 3, 70, "Message",
  CellTags->"S2.9.21"],
Cell[482648, 15016, 119, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[482782, 15022, 730, 18, 70, "Text",
  CellTags->{"S2.9.21", "21.14"}],
Cell[483515, 15042, 280, 6, 70, "Text",
  CellTags->{"S2.9.21", "21.15"}],
Cell[483798, 15050, 903, 26, 70, "Text",
  CellTags->{"S2.9.21", "21.16"}],
Cell[484704, 15078, 200, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.17"}],

Cell[CellGroupData[{
Cell[484929, 15087, 75, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[485007, 15091, 163, 4, 70, "Message",
  CellTags->"S2.9.21"],
Cell[485173, 15097, 92, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[485280, 15103, 146, 4, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.18"}],

Cell[CellGroupData[{
Cell[485451, 15111, 78, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[485532, 15115, 138, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[485685, 15121, 798, 17, 70, "Text",
  CellTags->{"S2.9.21", "21.19"}],
Cell[486486, 15140, 957, 29, 70, "DefinitionBox",
  CellTags->"S2.9.21"],
Cell[487446, 15171, 114, 4, 70, "Caption",
  CellTags->"S2.9.21"],
Cell[487563, 15177, 739, 21, 70, "Text",
  CellTags->{"S2.9.21", "21.20"}],
Cell[488305, 15200, 173, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.21"}],

Cell[CellGroupData[{
Cell[488503, 15209, 104, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[488610, 15213, 163, 4, 70, "Message",
  CellTags->"S2.9.21"],
Cell[488776, 15219, 161, 4, 70, "Message",
  CellTags->"S2.9.21"],
Cell[488940, 15225, 228, 8, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[489183, 15236, 173, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.22"}],

Cell[CellGroupData[{
Cell[489381, 15245, 78, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[489462, 15249, 121, 2, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[489598, 15254, 363, 7, 70, "Text",
  CellTags->{"S2.9.21", "21.23"}],
Cell[489964, 15263, 2794, 80, 70, "DefinitionBox",
  CellTags->"S2.9.21"],
Cell[492761, 15345, 73, 1, 70, "Caption",
  CellTags->"S2.9.21"],
Cell[492837, 15348, 183, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.24"}],

Cell[CellGroupData[{
Cell[493045, 15357, 81, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[493129, 15361, 84, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[493228, 15367, 209, 7, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.25"}],

Cell[CellGroupData[{
Cell[493462, 15378, 81, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[493546, 15382, 146, 3, 70, "Message",
  CellTags->"S2.9.21"],
Cell[493695, 15387, 86, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[493796, 15393, 362, 12, 70, "Text",
  CellTags->{"S2.9.21", "21.26"}],
Cell[494161, 15407, 307, 7, 70, "Text",
  CellTags->{"S2.9.21", "21.27"}],
Cell[494471, 15416, 248, 9, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.28"}],

Cell[CellGroupData[{
Cell[494744, 15429, 101, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[494848, 15433, 161, 4, 70, "Message",
  CellTags->"S2.9.21"],
Cell[495012, 15439, 92, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[495119, 15445, 1474, 43, 70, "DefinitionBox",
  CellTags->"S2.9.21"],
Cell[496596, 15490, 63, 1, 70, "Caption",
  CellTags->"S2.9.21"],
Cell[496662, 15493, 632, 21, 70, "Text",
  CellTags->{"S2.9.21", "21.29"}],
Cell[497297, 15516, 155, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.30"}],

Cell[CellGroupData[{
Cell[497477, 15525, 117, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[497597, 15529, 118, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[497730, 15535, 125, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.31"}],
Cell[497858, 15542, 126, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[497987, 15546, 170, 5, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.32"}],

Cell[CellGroupData[{
Cell[498182, 15555, 71, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[498256, 15559, 135, 3, 70, "Message",
  CellTags->"S2.9.21"],
Cell[498394, 15564, 94, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[498503, 15570, 88, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.33"}],
Cell[498594, 15573, 82, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[498679, 15577, 97, 1, 70, "MathCaption",
  CellTags->{"S2.9.21", "21.34"}],

Cell[CellGroupData[{
Cell[498801, 15582, 71, 2, 70, "Input",
  CellTags->"S2.9.21"],
Cell[498875, 15586, 94, 3, 70, "Output",
  CellTags->"S2.9.21"]
}, Open  ]],
Cell[498984, 15592, 592, 15, 70, "Text",
  CellTags->{"S2.9.21", "21.35"}],
Cell[499579, 15609, 296, 8, 70, "Text",
  CellTags->{"S2.9.21", "21.36"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[499912, 15622, 84, 1, 70, "Subsection",
  CellTags->{"S2.9.22", "22.1"}],
Cell[499999, 15625, 393, 8, 70, "Text",
  CellTags->{"S2.9.22", "22.2"}],
Cell[500395, 15635, 402, 11, 70, "Text",
  CellTags->{"S2.9.22", "22.3"}],
Cell[500800, 15648, 1424, 42, 70, "DefinitionBox",
  CellTags->"S2.9.22"],
Cell[502227, 15692, 84, 1, 70, "Caption",
  CellTags->"S2.9.22"],
Cell[502314, 15695, 176, 5, 70, "MathCaption",
  CellTags->{"S2.9.22", "22.4"}],

Cell[CellGroupData[{
Cell[502515, 15704, 87, 2, 70, "Input",
  CellTags->"S2.9.22"],
Cell[502605, 15708, 90, 3, 70, "Output",
  CellTags->"S2.9.22"]
}, Open  ]],
Cell[502710, 15714, 217, 6, 70, "MathCaption",
  CellTags->{"S2.9.22", "22.5"}],

Cell[CellGroupData[{
Cell[502952, 15724, 78, 2, 70, "Input",
  CellTags->"S2.9.22"],
Cell[503033, 15728, 190, 4, 70, "Message",
  CellTags->"S2.9.22"],
Cell[503226, 15734, 95, 3, 70, "Output",
  CellTags->"S2.9.22"]
}, Open  ]],
Cell[503336, 15740, 720, 20, 70, "DefinitionBox",
  CellTags->"S2.9.22"],
Cell[504059, 15762, 75, 1, 70, "Caption",
  CellTags->"S2.9.22"],
Cell[504137, 15765, 591, 18, 70, "Text",
  CellTags->{"S2.9.22", "22.6"}],
Cell[504731, 15785, 414, 11, 70, "Text",
  CellTags->{"S2.9.22", "22.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[505182, 15801, 86, 1, 70, "Subsection",
  CellTags->{"S2.9.23", "23.1"}],
Cell[505271, 15804, 302, 7, 70, "Text",
  CellTags->{"S2.9.23", "23.2"}],
Cell[505576, 15813, 592, 16, 70, "Text",
  CellTags->{"S2.9.23", "23.3"}],
Cell[506171, 15831, 165, 5, 70, "MathCaption",
  CellTags->{"S2.9.23", "23.4"}],

Cell[CellGroupData[{
Cell[506361, 15840, 102, 2, 70, "Input",
  CellTags->"S2.9.23"],
Cell[506466, 15844, 97, 3, 70, "Output",
  CellTags->"S2.9.23"]
}, Open  ]],
Cell[506578, 15850, 578, 18, 70, "DefinitionBox",
  CellTags->"S2.9.23"],
Cell[507159, 15870, 111, 5, 70, "Caption",
  CellTags->"S2.9.23"],
Cell[507273, 15877, 485, 13, 70, "Text",
  CellTags->{"S2.9.23", "23.5"}],
Cell[507761, 15892, 935, 27, 70, "DefinitionBox",
  CellTags->"S2.9.23"],
Cell[508699, 15921, 72, 1, 70, "Caption",
  CellTags->"S2.9.23"],
Cell[508774, 15924, 140, 5, 70, "MathCaption",
  CellTags->{"S2.9.23", "23.6"}],
Cell[508917, 15931, 77, 2, 28, "Input",
  CellTags->"S2.9.23"],
Cell[508997, 15935, 180, 6, 70, "MathCaption",
  CellTags->{"S2.9.23", "23.7"}],

Cell[CellGroupData[{
Cell[509202, 15945, 107, 2, 28, "Input",
  CellTags->"S2.9.23"],
Cell[509312, 15949, 111, 3, 25, "Output",
  CellTags->"S2.9.23"]
}, Open  ]],
Cell[509438, 15955, 136, 5, 40, "MathCaption",
  CellTags->{"S2.9.23", "23.8"}],

Cell[CellGroupData[{
Cell[509599, 15964, 67, 2, 28, "Input",
  CellTags->"S2.9.23"],
Cell[509669, 15968, 85, 2, 21, "Print",
  CellTags->"S2.9.23"]
}, Open  ]],
Cell[509769, 15973, 238, 8, 56, "MathCaption",
  CellTags->{"S2.9.23", "23.9"}],

Cell[CellGroupData[{
Cell[510032, 15985, 68, 2, 28, "Input",
  CellTags->"S2.9.23"],
Cell[510103, 15989, 85, 2, 21, "Print",
  CellTags->"S2.9.23"],
Cell[510191, 15993, 414, 13, 23, "Print",
  CellTags->"S2.9.23"]
}, Open  ]],
Cell[510620, 16009, 548, 18, 56, "Text",
  CellTags->{"S2.9.23", "23.10"}],
Cell[511171, 16029, 461, 11, 72, "Text",
  CellTags->{"S2.9.23", "23.11"}],
Cell[511635, 16042, 781, 22, 88, "DefinitionBox",
  CellTags->"S2.9.23"],
Cell[512419, 16066, 79, 1, 16, "Caption",
  CellTags->"S2.9.23"],
Cell[512501, 16069, 247, 7, 40, "Text",
  CellTags->{"S2.9.23", "23.12"}],
Cell[512751, 16078, 428, 9, 72, "Text",
  CellTags->{"S2.9.23", "23.13"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

