(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3692286,     146794]*)
(*NotebookOutlinePosition[   3826272,     150461]*)
(*  CellTagsIndexPosition[   3815129,     150076]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["2.10 ", "HeadingNumber"],
  "The Structure of Graphics and Sound"
}], "Section",
  CellTags->{"S2.10.0", "0.1"}],

Cell[CellGroupData[{

Cell["2.10.1 The Structure of Graphics", "Subsection",
  CellTags->{"S2.10.1", "1.1"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.9",
    ButtonData:>{"1.9"},
    ButtonStyle->"MainBookLink"],
  " discussed how to use functions like ",
  StyleBox["Plot", "MR"],
  " and ",
  StyleBox["ListPlot", "MR"],
  " to plot graphs of functions and data. In this section, we discuss how ",
  StyleBox["Mathematica", "TI"],
  " represents such graphics, and how you can program ",
  StyleBox["Mathematica", "TI"],
  " to create more complicated images. "
}], "Text",
  CellTags->{"S2.10.1", "1.2"}],

Cell[TextData[{
  "The basic idea is that ",
  StyleBox["Mathematica", "TI"],
  " represents all graphics in terms of a collection of ",
  StyleBox["graphics primitives", "TI"],
  ". The primitives are objects like ",
  StyleBox["Point", "MR"],
  ", ",
  StyleBox["Line", "MR"],
  " and ",
  StyleBox["Polygon", "MR"],
  ", that represent elements of a graphical image, as well as directives such \
as ",
  StyleBox["RGBColor", "MR"],
  ", ",
  StyleBox["Thickness", "MR"],
  " and ",
  StyleBox["SurfaceColor", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.1", "1.3"}],

Cell["This generates a plot of a list of points. ", "MathCaption",
  CellTags->{"S2.10.1", "1.4"}],

Cell[CellGroupData[{

Cell["ListPlot[ Table[Prime[n], {n, 20}] ]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0147151 0.00829019 [
[.2619 .00222 -3 -9 ]
[.2619 .00222 3 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .09762 -12 -4.5 ]
[.01131 .09762 0 4.5 ]
[.01131 .18052 -12 -4.5 ]
[.01131 .18052 0 4.5 ]
[.01131 .26342 -12 -4.5 ]
[.01131 .26342 0 4.5 ]
[.01131 .34632 -12 -4.5 ]
[.01131 .34632 0 4.5 ]
[.01131 .42922 -12 -4.5 ]
[.01131 .42922 0 4.5 ]
[.01131 .51213 -12 -4.5 ]
[.01131 .51213 0 4.5 ]
[.01131 .59503 -12 -4.5 ]
[.01131 .59503 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(10)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(15)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(20)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09762 m
.03006 .09762 L
s
[(10)] .01131 .09762 1 0 Mshowa
.02381 .18052 m
.03006 .18052 L
s
[(20)] .01131 .18052 1 0 Mshowa
.02381 .26342 m
.03006 .26342 L
s
[(30)] .01131 .26342 1 0 Mshowa
.02381 .34632 m
.03006 .34632 L
s
[(40)] .01131 .34632 1 0 Mshowa
.02381 .42922 m
.03006 .42922 L
s
[(50)] .01131 .42922 1 0 Mshowa
.02381 .51213 m
.03006 .51213 L
s
[(60)] .01131 .51213 1 0 Mshowa
.02381 .59503 m
.03006 .59503 L
s
[(70)] .01131 .59503 1 0 Mshowa
.125 Mabswid
.02381 .0313 m
.02756 .0313 L
s
.02381 .04788 m
.02756 .04788 L
s
.02381 .06446 m
.02756 .06446 L
s
.02381 .08104 m
.02756 .08104 L
s
.02381 .1142 m
.02756 .1142 L
s
.02381 .13078 m
.02756 .13078 L
s
.02381 .14736 m
.02756 .14736 L
s
.02381 .16394 m
.02756 .16394 L
s
.02381 .1971 m
.02756 .1971 L
s
.02381 .21368 m
.02756 .21368 L
s
.02381 .23026 m
.02756 .23026 L
s
.02381 .24684 m
.02756 .24684 L
s
.02381 .28 m
.02756 .28 L
s
.02381 .29658 m
.02756 .29658 L
s
.02381 .31316 m
.02756 .31316 L
s
.02381 .32974 m
.02756 .32974 L
s
.02381 .3629 m
.02756 .3629 L
s
.02381 .37948 m
.02756 .37948 L
s
.02381 .39606 m
.02756 .39606 L
s
.02381 .41264 m
.02756 .41264 L
s
.02381 .44581 m
.02756 .44581 L
s
.02381 .46239 m
.02756 .46239 L
s
.02381 .47897 m
.02756 .47897 L
s
.02381 .49555 m
.02756 .49555 L
s
.02381 .52871 m
.02756 .52871 L
s
.02381 .54529 m
.02756 .54529 L
s
.02381 .56187 m
.02756 .56187 L
s
.02381 .57845 m
.02756 .57845 L
s
.02381 .61161 m
.02756 .61161 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.07143 .0313 Mdot
.11905 .03959 Mdot
.16667 .05617 Mdot
.21429 .07275 Mdot
.2619 .10591 Mdot
.30952 .12249 Mdot
.35714 .15565 Mdot
.40476 .17223 Mdot
.45238 .20539 Mdot
.5 .25513 Mdot
.54762 .27171 Mdot
.59524 .32145 Mdot
.64286 .35461 Mdot
.69048 .37119 Mdot
.7381 .40435 Mdot
.78571 .4541 Mdot
.83333 .50384 Mdot
.88095 .52042 Mdot
.92857 .57016 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " shows how ",
  StyleBox["Mathematica", "TI"],
  " represents the graphics. Each point is represented as a ",
  StyleBox["Point", "MR"],
  " graphics primitive. All the various graphics options used in this case \
are also given. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.5"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.1"],

Cell["\<\
Graphics[{Point[{1, 2}], Point[{2, 3}],    Point[{3, 5}], Point[{4, \
7}], Point[{5, 11}],    Point[{6, 13}], Point[{7, 17}], Point[{8, 19}],    \
Point[{9, 23}], Point[{10, 29}],    Point[{11, 31}], Point[{12, 37}],    \
Point[{13, 41}], Point[{14, 43}],    Point[{15, 47}], Point[{16, 53}],    \
Point[{17, 59}], Point[{18, 61}],    Point[{19, 67}], Point[{20, 71}]},   \
{PlotRange -> Automatic, AspectRatio ->     GoldenRatio^(-1), DisplayFunction \
:>     $DisplayFunction, ColorOutput -> Automatic,    Axes -> Automatic, \
AxesOrigin -> Automatic,    PlotLabel -> None, AxesLabel -> None,    Ticks -> \
Automatic, GridLines -> None,    Prolog -> {}, Epilog -> {},    AxesStyle -> \
Automatic, Background ->     Automatic, DefaultColor -> Automatic,    \
DefaultFont :> $DefaultFont,    RotateLabel -> True, Frame -> False,    \
FrameStyle -> Automatic, FrameTicks ->     Automatic, FrameLabel -> None,    \
PlotRegion -> Automatic, ImageSize ->     Automatic, TextStyle :> $TextStyle, \
   FormatType :> $FormatType}]\
\>", "Output",
  CellLabel->"Out[2]//InputForm= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "Each complete piece of graphics in ",
  StyleBox["Mathematica", "TI"],
  " is represented as a ",
  StyleBox["graphics object", "TI"],
  ". There are several different kinds of graphics object, corresponding to \
different types of graphics. Each kind of graphics object has a definite head \
which identifies its type. "
}], "Text",
  CellTags->{"S2.10.1", "1.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Graphics[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["\<\
general two\[Hyphen]dimensional graphics \
\>"]},
          {Cell[TextData[{
              StyleBox["DensityGraphics[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["density plot "]},
          {Cell[TextData[{
              StyleBox["ContourGraphics[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["contour plot "]},
          {Cell[TextData[{
              StyleBox["SurfaceGraphics[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["three\[Hyphen]dimensional surface "]},
          {Cell[TextData[{
              StyleBox["Graphics3D[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
general three\[Hyphen]dimensional graphics \
\>"]},
          {Cell[TextData[{
              StyleBox["GraphicsArray[", "MR"],
              StyleBox["list", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["array of other graphics objects "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell[TextData[{
  "Graphics objects in ",
  StyleBox["Mathematica", "SO"],
  ". "
}], "Caption",
  CellTags->"S2.10.1"],

Cell[TextData[{
  "The functions like ",
  StyleBox["Plot", "MR"],
  " and ",
  StyleBox["ListPlot", "MR"],
  " discussed in Section ",
  ButtonBox["1.9",
    ButtonData:>{"1.9"},
    ButtonStyle->"MainBookLink"],
  " all work by building up ",
  StyleBox["Mathematica", "TI"],
  " graphics objects, and then displaying them. "
}], "Text",
  CellTags->{"S2.10.1", "1.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Graphics", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Plot", "MR"],
              ", ",
              StyleBox["ListPlot", "MR"],
              ", ",
              StyleBox["ParametricPlot", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["DensityGraphics", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["DensityPlot", "MR"],
              ", ",
              StyleBox["ListDensityPlot", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["ContourGraphics", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["ContourPlot", "MR"],
              ", ",
              StyleBox["ListContourPlot", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["SurfaceGraphics", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Plot3D", "MR"],
              ", ",
              StyleBox["ListPlot3D", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Graphics3D", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["ParametricPlot3D", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell["Generating graphics objects by plotting functions and data. ", "Caption",
  CellTags->"S2.10.1"],

Cell[TextData[{
  "You can create other kinds of graphical images in ",
  StyleBox["Mathematica", "TI"],
  " by building up your own graphics objects. Since graphics objects in ",
  StyleBox["Mathematica", "TI"],
  " are just symbolic expressions, you can use all the standard ",
  StyleBox["Mathematica", "TI"],
  " functions to manipulate them. "
}], "Text",
  CellTags->{"S2.10.1", "1.8"}],

Cell[TextData[{
  "Once you have created a graphics object, you must then display it. The \
function ",
  StyleBox["Show", "MR"],
  " allows you to display any ",
  StyleBox["Mathematica", "TI"],
  " graphics object. "
}], "Text",
  CellTags->{"S2.10.1", "1.9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Show[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["display a graphics object "]},
          {Cell[TextData[{
              StyleBox["Show[", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["display several graphics objects combined "]},
          {Cell[TextData[{
              StyleBox["Show[GraphicsArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["display an array of graphics objects "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell["Displaying graphics objects. ", "Caption",
  CellTags->"S2.10.1"],

Cell[TextData[{
  "This uses ",
  StyleBox["Table", "MR"],
  " to generate a polygon graphics primitive. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.10"}],

Cell[CellGroupData[{

Cell["\<\
poly = Polygon[ Table[N[{Cos[n Pi/5], Sin[n Pi/5]}], {n, 0, 5}] ]\
\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    \(Polygon[{{1.`, 0.`}, {0.8090169943749475`, 
          0.5877852522924731`}, {0.30901699437494745`, 
          0.9510565162951535`}, {\(-0.30901699437494745`\), 
          0.9510565162951535`}, {\(-0.8090169943749475`\), 
          0.5877852522924731`}, {\(-1.`\), 0.`}}]\)], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "This creates a two\[Hyphen]dimensional graphics object that contains the \
polygon graphics primitive. In standard output format, the graphics object is \
given simply as ",
  StyleBox["-Graphics-", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.11"}],

Cell[CellGroupData[{

Cell["Graphics[ poly ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " shows the complete graphics object. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.12"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.1"],

Cell["\<\
Graphics[Polygon[{{1., 0.}, {0.8090169943749475,      \
0.5877852522924731}, {0.30901699437494745,      0.9510565162951535}, \
{-0.30901699437494745,      0.9510565162951535}, {-0.8090169943749475,      \
0.5877852522924731}, {-1., 0.}}]]\
\>", "Output",
  CellLabel->"Out[5]//InputForm= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell["This displays the graphics object you have created. ", "MathCaption",
  CellTags->{"S2.10.1", "1.13"}],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.0147151 0.618895 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.97619 .01472 m
.88525 .37849 L
.64715 .60332 L
.35285 .60332 L
.11475 .37849 L
.02381 .01472 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Graphics directives "], Cell[TextData[{
              "Examples: ",
              StyleBox["RGBColor", "MR"],
              ", ",
              StyleBox["Thickness", "MR"],
              ", ",
              StyleBox["SurfaceColor", "MR"],
              " "
            }]]},
          {Cell["Graphics options "], Cell[TextData[{
              "Examples: ",
              StyleBox["PlotRange", "MR"],
              ", ",
              StyleBox["Ticks", "MR"],
              ", ",
              StyleBox["AspectRatio", "MR"],
              ", ",
              StyleBox["ViewPoint", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell["Local and global ways to modify graphics. ", "Caption",
  CellTags->"S2.10.1"],

Cell[TextData[{
  "Given a particular list of graphics primitives, ",
  StyleBox["Mathematica", "TI"],
  " provides two basic mechanisms for modifying the final form of graphics \
you get. First, you can insert into the list of graphics primitives certain \
",
  StyleBox["graphics directives", "TI"],
  ", such as ",
  StyleBox["RGBColor", "MR"],
  ", which modify the subsequent graphical elements in the list. In this way, \
you can specify how a particular set of graphical elements should be \
rendered. "
}], "Text",
  CellTags->{"S2.10.1", "1.14"}],

Cell[TextData[{
  "This takes the list of graphics primitives created above, and adds the \
graphics directive ",
  StyleBox["GrayLevel[0.3]", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.15"}],

Cell[CellGroupData[{

Cell["Graphics[ {GrayLevel[0.3], poly} ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell["Now the polygon is rendered in gray. ", "MathCaption",
  CellTags->{"S2.10.1", "1.16"}],

Cell[CellGroupData[{

Cell["Show[%]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.0147151 0.618895 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.3 g
.97619 .01472 m
.88525 .37849 L
.64715 .60332 L
.35285 .60332 L
.11475 .37849 L
.02381 .01472 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "By inserting graphics directives, you can specify how particular graphical \
elements should be rendered. Often, however, you want to make global \
modifications to the way a whole graphics object is rendered. You can do this \
using ",
  StyleBox["graphics options", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.10.1", "1.17"}],

Cell[TextData[{
  "By adding the graphics option ",
  StyleBox["Frame", "MR"],
  " you can modify the overall appearance of the graphics. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.18"}],

Cell[CellGroupData[{

Cell["Show[%, Frame -> True]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.0147151 0.618895 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.2619 -0.0125 -12 -9 ]
[.2619 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7381 -0.0125 -9 -9 ]
[.7381 -0.0125 9 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13849 -18 -4.5 ]
[-0.0125 .13849 0 4.5 ]
[-0.0125 .26227 -18 -4.5 ]
[-0.0125 .26227 0 4.5 ]
[-0.0125 .38605 -18 -4.5 ]
[-0.0125 .38605 0 4.5 ]
[-0.0125 .50983 -18 -4.5 ]
[-0.0125 .50983 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-1)] .02381 -0.0125 0 1 Mshowa
.2619 0 m
.2619 .00625 L
s
[(-0.5)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(0.5)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(1)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13849 m
.00625 .13849 L
s
[(0.2)] -0.0125 .13849 1 0 Mshowa
0 .26227 m
.00625 .26227 L
s
[(0.4)] -0.0125 .26227 1 0 Mshowa
0 .38605 m
.00625 .38605 L
s
[(0.6)] -0.0125 .38605 1 0 Mshowa
0 .50983 m
.00625 .50983 L
s
[(0.8)] -0.0125 .50983 1 0 Mshowa
.125 Mabswid
0 .04566 m
.00375 .04566 L
s
0 .0766 m
.00375 .0766 L
s
0 .10755 m
.00375 .10755 L
s
0 .16944 m
.00375 .16944 L
s
0 .20038 m
.00375 .20038 L
s
0 .23133 m
.00375 .23133 L
s
0 .29322 m
.00375 .29322 L
s
0 .32416 m
.00375 .32416 L
s
0 .35511 m
.00375 .35511 L
s
0 .417 m
.00375 .417 L
s
0 .44794 m
.00375 .44794 L
s
0 .47889 m
.00375 .47889 L
s
0 .54078 m
.00375 .54078 L
s
0 .57172 m
.00375 .57172 L
s
0 .60267 m
.00375 .60267 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.2619 .61178 m
.2619 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.7381 .61178 m
.7381 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .13849 m
1 .13849 L
s
.99375 .26227 m
1 .26227 L
s
.99375 .38605 m
1 .38605 L
s
.99375 .50983 m
1 .50983 L
s
.125 Mabswid
.99625 .04566 m
1 .04566 L
s
.99625 .0766 m
1 .0766 L
s
.99625 .10755 m
1 .10755 L
s
.99625 .16944 m
1 .16944 L
s
.99625 .20038 m
1 .20038 L
s
.99625 .23133 m
1 .23133 L
s
.99625 .29322 m
1 .29322 L
s
.99625 .32416 m
1 .32416 L
s
.99625 .35511 m
1 .35511 L
s
.99625 .417 m
1 .417 L
s
.99625 .44794 m
1 .44794 L
s
.99625 .47889 m
1 .47889 L
s
.99625 .54078 m
1 .54078 L
s
.99625 .57172 m
1 .57172 L
s
.99625 .60267 m
1 .60267 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.3 g
.97619 .01472 m
.88525 .37849 L
.64715 .60332 L
.35285 .60332 L
.11475 .37849 L
.02381 .01472 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Show", "MR"],
  " returns a graphics object with the options in it. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.19"}],

Cell[CellGroupData[{

Cell["InputForm[%]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.1"],

Cell["\<\
Graphics[{GrayLevel[0.3],    Polygon[{{1., 0.}, \
{0.8090169943749475,       0.5877852522924731}, {0.30901699437494745,       \
0.9510565162951535}, {-0.30901699437494745,       0.9510565162951535}, \
{-0.8090169943749475,       0.5877852522924731}, {-1., 0.}}]},   {Frame -> \
True}]\
\>", "Output",
  CellLabel->"Out[10]//InputForm= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "You can specify graphics options in ",
  StyleBox["Show", "MR"],
  ". As a result, it is straightforward to take a single graphics object, and \
show it with many different choices of graphics options. "
}], "Text",
  CellTags->{"S2.10.1", "1.20"}],

Cell[TextData[{
  "Notice however that ",
  StyleBox["Show", "MR"],
  " always returns the graphics objects it has displayed. If you specify \
graphics options in ",
  StyleBox["Show", "MR"],
  ", then these options are automatically inserted into the graphics objects \
that ",
  StyleBox["Show", "MR"],
  " returns. As a result, if you call ",
  StyleBox["Show", "MR"],
  " again on the same objects, the same graphics options will be used, unless \
you explicitly specify other ones. Note that in all cases new options you \
specify will overwrite ones already there. "
}], "Text",
  CellTags->{"S2.10.1", "1.21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "give a list of all graphics options for a graphics object "]},
          {Cell[TextData[{
              StyleBox["Options[", "MR"],
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["opt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["give the setting for a particular option "]},
          {Cell[TextData[{
              StyleBox["AbsoluteOptions[", "MR"],
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["opt", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "give the absolute value used for a particular option, even if \
the setting is ",
              StyleBox["Automatic", "MR"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell["Finding the options for a graphics object. ", "Caption",
  CellTags->"S2.10.1"],

Cell[TextData[{
  "Some graphics options work by requiring you to specify a particular value \
for a parameter related to a piece of graphics. Other options allow you to \
give the setting ",
  StyleBox["Automatic", "MR"],
  ", which makes ",
  StyleBox["Mathematica", "TI"],
  " use internal algorithms to choose appropriate values for parameters. In \
such cases, you can find out the values that ",
  StyleBox["Mathematica", "TI"],
  " actually used by applying the function ",
  StyleBox["AbsoluteOptions", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.1", "1.22"}],

Cell["Here is a plot. ", "MathCaption",
  CellTags->{"S2.10.1", "1.23"}],

Cell[CellGroupData[{

Cell["zplot = Plot[Abs[Zeta[1/2 + I x]], {x, 0, 10}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 -0.288094 0.575404 [
[.21429 .27481 -3 -9 ]
[.21429 .27481 3 0 ]
[.40476 .27481 -3 -9 ]
[.40476 .27481 3 0 ]
[.59524 .27481 -3 -9 ]
[.59524 .27481 3 0 ]
[.78571 .27481 -3 -9 ]
[.78571 .27481 3 0 ]
[.97619 .27481 -6 -9 ]
[.97619 .27481 6 0 ]
[.01131 .05715 -18 -4.5 ]
[.01131 .05715 0 4.5 ]
[.01131 .17223 -18 -4.5 ]
[.01131 .17223 0 4.5 ]
[.01131 .40239 -18 -4.5 ]
[.01131 .40239 0 4.5 ]
[.01131 .51747 -18 -4.5 ]
[.01131 .51747 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .28731 m
.21429 .29356 L
s
[(2)] .21429 .27481 0 1 Mshowa
.40476 .28731 m
.40476 .29356 L
s
[(4)] .40476 .27481 0 1 Mshowa
.59524 .28731 m
.59524 .29356 L
s
[(6)] .59524 .27481 0 1 Mshowa
.78571 .28731 m
.78571 .29356 L
s
[(8)] .78571 .27481 0 1 Mshowa
.97619 .28731 m
.97619 .29356 L
s
[(10)] .97619 .27481 0 1 Mshowa
.125 Mabswid
.07143 .28731 m
.07143 .29106 L
s
.11905 .28731 m
.11905 .29106 L
s
.16667 .28731 m
.16667 .29106 L
s
.2619 .28731 m
.2619 .29106 L
s
.30952 .28731 m
.30952 .29106 L
s
.35714 .28731 m
.35714 .29106 L
s
.45238 .28731 m
.45238 .29106 L
s
.5 .28731 m
.5 .29106 L
s
.54762 .28731 m
.54762 .29106 L
s
.64286 .28731 m
.64286 .29106 L
s
.69048 .28731 m
.69048 .29106 L
s
.7381 .28731 m
.7381 .29106 L
s
.83333 .28731 m
.83333 .29106 L
s
.88095 .28731 m
.88095 .29106 L
s
.92857 .28731 m
.92857 .29106 L
s
.25 Mabswid
0 .28731 m
1 .28731 L
s
.02381 .05715 m
.03006 .05715 L
s
[(0.6)] .01131 .05715 1 0 Mshowa
.02381 .17223 m
.03006 .17223 L
s
[(0.8)] .01131 .17223 1 0 Mshowa
.02381 .40239 m
.03006 .40239 L
s
[(1.2)] .01131 .40239 1 0 Mshowa
.02381 .51747 m
.03006 .51747 L
s
[(1.4)] .01131 .51747 1 0 Mshowa
.125 Mabswid
.02381 .08592 m
.02756 .08592 L
s
.02381 .11469 m
.02756 .11469 L
s
.02381 .14346 m
.02756 .14346 L
s
.02381 .201 m
.02756 .201 L
s
.02381 .22977 m
.02756 .22977 L
s
.02381 .25854 m
.02756 .25854 L
s
.02381 .31608 m
.02756 .31608 L
s
.02381 .34485 m
.02756 .34485 L
s
.02381 .37362 m
.02756 .37362 L
s
.02381 .43116 m
.02756 .43116 L
s
.02381 .45993 m
.02756 .45993 L
s
.02381 .4887 m
.02756 .4887 L
s
.02381 .02838 m
.02756 .02838 L
s
.02381 .54624 m
.02756 .54624 L
s
.02381 .57501 m
.02756 .57501 L
s
.02381 .60378 m
.02756 .60378 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .5522 m
.06244 .37804 L
.08255 .26659 L
.0932 .21944 L
.10458 .1777 L
.11531 .14543 L
.12507 .12107 L
.14415 .08428 L
.1633 .05829 L
.1741 .04725 L
.18408 .03894 L
.20281 .02736 L
.21346 .02272 L
.22343 .01946 L
.2284 .01818 L
.23381 .01704 L
.23859 .01623 L
.24368 .01557 L
.24627 .01531 L
.24872 .01511 L
.25091 .01496 L
.25204 .0149 L
.25329 .01485 L
.25438 .0148 L
.25554 .01477 L
.25678 .01474 L
.25793 .01472 L
.25908 .01472 L
.26017 .01472 L
.26114 .01472 L
.2622 .01474 L
.26342 .01476 L
.26454 .01479 L
.26705 .01489 L
.26927 .01501 L
.2716 .01516 L
.27656 .0156 L
.28198 .01623 L
.29286 .01798 L
.30299 .02014 L
.32344 .02594 L
.34203 .03273 L
.38201 .05173 L
.42048 .07506 L
.4614 .10478 L
.5008 .13776 L
.53869 .17317 L
.57903 .21441 L
.61785 .25707 L
.65913 .30488 L
Mistroke
.69889 .35244 L
.73714 .39857 L
.77783 .4467 L
.81701 .49055 L
.85865 .53249 L
.89877 .56614 L
.91718 .57871 L
.93737 .59002 L
.95626 .59798 L
.96657 .60115 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "The option ",
  StyleBox["PlotRange", "MR"],
  " is set to its default value of ",
  StyleBox["Automatic", "MR"],
  ", specifying that ",
  StyleBox["Mathematica", "TI"],
  " should use internal algorithms to determine the actual plot range. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.24"}],

Cell[CellGroupData[{

Cell["Options[zplot, PlotRange]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    \({PlotRange \[Rule] Automatic}\)], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["AbsoluteOptions", "MR"],
  " gives the actual plot range determined by ",
  StyleBox["Mathematica", "TI"],
  " in this case. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.25"}],

Cell[CellGroupData[{

Cell["AbsoluteOptions[zplot, PlotRange]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    \({PlotRange \[Rule] {{\(-0.24999998958333333`\), 
            10.249999572916666`}, {0.5006812308688274`, 
            1.574768028678299`}}}\)], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FullGraphics[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
translate objects specified by graphics options into \
lists of explicit graphics primitives \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell["Finding the complete form of a piece of graphics. ", "Caption",
  CellTags->"S2.10.1"],

Cell[TextData[{
  "When you use a graphics option such as ",
  StyleBox["Axes", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " effectively has to construct a list of graphics elements to represent the \
objects such as axes that you have requested. Usually ",
  StyleBox["Mathematica", "TI"],
  " does not explicitly return the list it constructs in this way. Sometimes, \
however, you may find it useful to get this list. The function ",
  StyleBox["FullGraphics", "MR"],
  " gives the complete list of graphics primitives needed to generate a \
particular plot, without any options being used. "
}], "Text",
  CellTags->{"S2.10.1", "1.26"}],

Cell["This plots a list of values. ", "MathCaption",
  CellTags->{"S2.10.1", "1.27"}],

Cell[CellGroupData[{

Cell["ListPlot[ Table[EulerPhi[n], {n, 10}] ]", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0820106 0.10582 -0.103006 0.117721 [
[.34127 .00222 -3 -9 ]
[.34127 .00222 3 0 ]
[.55291 .00222 -3 -9 ]
[.55291 .00222 3 0 ]
[.76455 .00222 -3 -9 ]
[.76455 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.11713 .13244 -6 -4.5 ]
[.11713 .13244 0 4.5 ]
[.11713 .25016 -6 -4.5 ]
[.11713 .25016 0 4.5 ]
[.11713 .36788 -6 -4.5 ]
[.11713 .36788 0 4.5 ]
[.11713 .4856 -6 -4.5 ]
[.11713 .4856 0 4.5 ]
[.11713 .60332 -6 -4.5 ]
[.11713 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.34127 .01472 m
.34127 .02097 L
s
[(4)] .34127 .00222 0 1 Mshowa
.55291 .01472 m
.55291 .02097 L
s
[(6)] .55291 .00222 0 1 Mshowa
.76455 .01472 m
.76455 .02097 L
s
[(8)] .76455 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.18254 .01472 m
.18254 .01847 L
s
.23545 .01472 m
.23545 .01847 L
s
.28836 .01472 m
.28836 .01847 L
s
.39418 .01472 m
.39418 .01847 L
s
.44709 .01472 m
.44709 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.60582 .01472 m
.60582 .01847 L
s
.65873 .01472 m
.65873 .01847 L
s
.71164 .01472 m
.71164 .01847 L
s
.81746 .01472 m
.81746 .01847 L
s
.87037 .01472 m
.87037 .01847 L
s
.92328 .01472 m
.92328 .01847 L
s
.07672 .01472 m
.07672 .01847 L
s
.02381 .01472 m
.02381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.12963 .13244 m
.13588 .13244 L
s
[(2)] .11713 .13244 1 0 Mshowa
.12963 .25016 m
.13588 .25016 L
s
[(3)] .11713 .25016 1 0 Mshowa
.12963 .36788 m
.13588 .36788 L
s
[(4)] .11713 .36788 1 0 Mshowa
.12963 .4856 m
.13588 .4856 L
s
[(5)] .11713 .4856 1 0 Mshowa
.12963 .60332 m
.13588 .60332 L
s
[(6)] .11713 .60332 1 0 Mshowa
.125 Mabswid
.12963 .03826 m
.13338 .03826 L
s
.12963 .0618 m
.13338 .0618 L
s
.12963 .08535 m
.13338 .08535 L
s
.12963 .10889 m
.13338 .10889 L
s
.12963 .15598 m
.13338 .15598 L
s
.12963 .17952 m
.13338 .17952 L
s
.12963 .20307 m
.13338 .20307 L
s
.12963 .22661 m
.13338 .22661 L
s
.12963 .2737 m
.13338 .2737 L
s
.12963 .29724 m
.13338 .29724 L
s
.12963 .32079 m
.13338 .32079 L
s
.12963 .34433 m
.13338 .34433 L
s
.12963 .39142 m
.13338 .39142 L
s
.12963 .41497 m
.13338 .41497 L
s
.12963 .43851 m
.13338 .43851 L
s
.12963 .46205 m
.13338 .46205 L
s
.12963 .50914 m
.13338 .50914 L
s
.12963 .53269 m
.13338 .53269 L
s
.12963 .55623 m
.13338 .55623 L
s
.12963 .57977 m
.13338 .57977 L
s
.25 Mabswid
.12963 0 m
.12963 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.12963 .01472 Mdot
.23545 .13244 Mdot
.34127 .13244 Mdot
.44709 .36788 Mdot
.55291 .13244 Mdot
.65873 .60332 Mdot
.76455 .36788 Mdot
.87037 .60332 Mdot
.97619 .36788 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FullGraphics", "MR"],
  " yields a graphics object that includes graphics primitives representing \
axes and so on. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.28"}],

Cell[CellGroupData[{

Cell["Short[ InputForm[ FullGraphics[%] ], 6]", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[
      FrameBox[\("Graphics[{{Point[{1, 1}], Point[{2, 1}], Point[{3, 2}], \
Point[{4, 2}], Point[{5, 4}], Point[{6, 2}], Point[{7, 6}], Point[{8, 4}], \
Point[{9, 6}], Point[{10, 4}]}, {{GrayLevel[0.], AbsoluteThickness[0.25], \
Line[{{4., 1.}, {4., 1.053091740255856}}]}, <<52>>, {GrayLevel[0.], \
<<2>>}}}]"\),
        BoxFrame->False,
        BoxMargins->False],
      (Short[ #, 6]&)]], "Output",
  CellLabel->"Out[15]//Short= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "With their default option settings, functions like ",
  StyleBox["Plot", "MR"],
  " and ",
  StyleBox["Show", "MR"],
  " actually cause ",
  StyleBox["Mathematica", "TI"],
  " to generate graphical output. In general, the actual generation of \
graphical output is controlled by the graphics option ",
  StyleBox["DisplayFunction", "MR"],
  ". The default setting for this option is the value of the global variable \
",
  StyleBox["$DisplayFunction", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.1", "1.29"}],

Cell[TextData[{
  "In most cases, ",
  StyleBox["$DisplayFunction", "MR"],
  " and the ",
  StyleBox["DisplayFunction", "MR"],
  " option are set to use the lower\[Hyphen]level rendering function ",
  StyleBox["Display", "MR"],
  " to produce output, perhaps after some preprocessing. Sometimes, however, \
you may want to get a function like ",
  StyleBox["Plot", "MR"],
  " to produce a graphics object, but you may not immediately want that \
graphics object actually rendered as output. You can tell ",
  StyleBox["Mathematica", "TI"],
  " to generate the object, but not render it, by setting the option ",
  StyleBox["DisplayFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Identity", "MR"],
  ". Section ",
  ButtonBox["2.10.14",
    ButtonData:>{"2.10.14", "14.1"},
    ButtonStyle->"MainBookLink"],
  " will explain exactly how this works. "
}], "Text",
  CellTags->{"S2.10.1", "1.30"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Plot[", "MR"],
              StyleBox["f", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox[",", "MR"],
              " ",
              StyleBox["DisplayFunction", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Identity]", "MR"],
              ",  etc. "
            }]], 
            Cell["\<\
generate a graphics object for a plot, but do not \
actually display it \
\>"]},
          {Cell[TextData[{
              StyleBox["Show[", "MR"],
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["DisplayFunction", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["$DisplayFunction]", "MR"],
              " "
            }]], Cell[
            "show a graphics object using the default display function "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.1"],

Cell["Generating and displaying graphics objects. ", "Caption",
  CellTags->"S2.10.1"],

Cell["\<\
This generates a graphics object, but does not actually display it. \
\
\>", "MathCaption",
  CellTags->{"S2.10.1", "1.31"}],

Cell[CellGroupData[{

Cell["Plot[BesselJ[0, x], {x, 0, 10}, DisplayFunction -> Identity]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell["\<\
This modifies the graphics object, but still does not actually \
display it. \
\>", "MathCaption",
  CellTags->{"S2.10.1", "1.32"}],

Cell[CellGroupData[{

Cell["Show[%, Frame -> True]", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.10.1"]
}, Open  ]],

Cell[TextData[{
  "To display the graphic, you explicitly have to tell ",
  StyleBox["Mathematica", "TI"],
  " to use the default display function. "
}], "MathCaption",
  CellTags->{"S2.10.1", "1.33"}],

Cell[CellGroupData[{

Cell["Show[%, DisplayFunction -> $DisplayFunction]", "Input",
  CellLabel->"In[18]:= ",
  CellTags->"S2.10.1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.183713 0.419605 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01587 -24 -4.5 ]
[-0.0125 .01587 0 4.5 ]
[-0.0125 .09979 -24 -4.5 ]
[-0.0125 .09979 0 4.5 ]
[-0.0125 .18371 -6 -4.5 ]
[-0.0125 .18371 0 4.5 ]
[-0.0125 .26763 -18 -4.5 ]
[-0.0125 .26763 0 4.5 ]
[-0.0125 .35156 -18 -4.5 ]
[-0.0125 .35156 0 4.5 ]
[-0.0125 .43548 -18 -4.5 ]
[-0.0125 .43548 0 4.5 ]
[-0.0125 .5194 -18 -4.5 ]
[-0.0125 .5194 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01587 m
.00625 .01587 L
s
[(-0.4)] -0.0125 .01587 1 0 Mshowa
0 .09979 m
.00625 .09979 L
s
[(-0.2)] -0.0125 .09979 1 0 Mshowa
0 .18371 m
.00625 .18371 L
s
[(0)] -0.0125 .18371 1 0 Mshowa
0 .26763 m
.00625 .26763 L
s
[(0.2)] -0.0125 .26763 1 0 Mshowa
0 .35156 m
.00625 .35156 L
s
[(0.4)] -0.0125 .35156 1 0 Mshowa
0 .43548 m
.00625 .43548 L
s
[(0.6)] -0.0125 .43548 1 0 Mshowa
0 .5194 m
.00625 .5194 L
s
[(0.8)] -0.0125 .5194 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .03685 m
.00375 .03685 L
s
0 .05783 m
.00375 .05783 L
s
0 .07881 m
.00375 .07881 L
s
0 .12077 m
.00375 .12077 L
s
0 .14175 m
.00375 .14175 L
s
0 .16273 m
.00375 .16273 L
s
0 .20469 m
.00375 .20469 L
s
0 .22567 m
.00375 .22567 L
s
0 .24665 m
.00375 .24665 L
s
0 .28861 m
.00375 .28861 L
s
0 .3096 m
.00375 .3096 L
s
0 .33058 m
.00375 .33058 L
s
0 .37254 m
.00375 .37254 L
s
0 .39352 m
.00375 .39352 L
s
0 .4145 m
.00375 .4145 L
s
0 .45646 m
.00375 .45646 L
s
0 .47744 m
.00375 .47744 L
s
0 .49842 m
.00375 .49842 L
s
0 .54038 m
.00375 .54038 L
s
0 .56136 m
.00375 .56136 L
s
0 .58234 m
.00375 .58234 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01587 m
1 .01587 L
s
.99375 .09979 m
1 .09979 L
s
.99375 .18371 m
1 .18371 L
s
.99375 .26763 m
1 .26763 L
s
.99375 .35156 m
1 .35156 L
s
.99375 .43548 m
1 .43548 L
s
.99375 .5194 m
1 .5194 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .03685 m
1 .03685 L
s
.99625 .05783 m
1 .05783 L
s
.99625 .07881 m
1 .07881 L
s
.99625 .12077 m
1 .12077 L
s
.99625 .14175 m
1 .14175 L
s
.99625 .16273 m
1 .16273 L
s
.99625 .20469 m
1 .20469 L
s
.99625 .22567 m
1 .22567 L
s
.99625 .24665 m
1 .24665 L
s
.99625 .28861 m
1 .28861 L
s
.99625 .3096 m
1 .3096 L
s
.99625 .33058 m
1 .33058 L
s
.99625 .37254 m
1 .37254 L
s
.99625 .39352 m
1 .39352 L
s
.99625 .4145 m
1 .4145 L
s
.99625 .45646 m
1 .45646 L
s
.99625 .47744 m
1 .47744 L
s
.99625 .49842 m
1 .49842 L
s
.99625 .54038 m
1 .54038 L
s
.99625 .56136 m
1 .56136 L
s
.99625 .58234 m
1 .58234 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .18371 m
1 .18371 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60326 L
.02729 .60318 L
.02846 .60307 L
.03053 .6028 L
.03279 .60239 L
.03527 .6018 L
.0379 .60103 L
.04262 .59924 L
.04749 .59686 L
.05205 .59414 L
.06244 .58623 L
.07305 .57575 L
.08274 .5641 L
.10458 .53119 L
.14429 .45151 L
.18248 .35892 L
.22313 .25533 L
.26226 .16264 L
.28223 .12146 L
.30384 .08336 L
.32471 .05395 L
.33464 .04272 L
.34391 .03392 L
.35375 .02637 L
.36273 .02113 L
.36785 .01884 L
.3727 .01714 L
.37518 .01644 L
.37782 .01583 L
.3792 .01557 L
.38072 .01532 L
.3821 .01513 L
.38339 .01498 L
.38453 .01488 L
.38574 .0148 L
.38643 .01476 L
.38709 .01474 L
.38831 .01472 L
.3896 .01472 L
.39079 .01475 L
.3921 .01482 L
.39276 .01486 L
.39349 .01492 L
.39579 .01517 L
.39827 .01555 L
.40274 .01651 L
.40833 .01822 L
.41364 .02033 L
Mistroke
.4236 .02558 L
.43321 .03214 L
.44344 .04062 L
.46184 .05938 L
.50348 .11424 L
.54359 .17477 L
.5822 .2303 L
.60178 .2547 L
.62325 .27711 L
.63313 .28565 L
.64371 .29343 L
.65363 .29938 L
.66279 .3037 L
.66764 .30551 L
.67299 .30713 L
.67837 .30835 L
.68131 .30885 L
.68407 .30921 L
.68654 .30944 L
.68778 .30952 L
.68849 .30956 L
.68913 .30959 L
.6903 .30962 L
.69154 .30964 L
.69268 .30964 L
.69377 .30962 L
.69504 .30958 L
.69567 .30955 L
.69638 .30951 L
.69878 .30932 L
.70013 .30918 L
.70158 .309 L
.70421 .30861 L
.70948 .30754 L
.71436 .30621 L
.72542 .30208 L
.73517 .29717 L
.74553 .29073 L
.78325 .25826 L
.82342 .21319 L
.86208 .16705 L
.90319 .12332 L
.92369 .10592 L
.94278 .09326 L
.95893 .08554 L
.96797 .08248 L
.97619 .08052 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[18]= ",
  CellTags->"S2.10.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.10.2 Two\[Hyphen]Dimensional Graphics Elements\
\>", "Subsection",
  CellTags->{"S2.10.2", "2.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Point[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "point at position ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Line[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "line through the points ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[", ", "TR"],
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Rectangle[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["filled rectangle "]},
          {Cell[TextData[{
              StyleBox["Polygon[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["filled polygon with the specified list of corners "]},
          {Cell[TextData[{
              StyleBox["Circle[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "circle with radius ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["r",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " centered at ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Disk[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "filled disk with radius ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["r",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " centered at ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Raster[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              "rectangular array of gray levels between ",
              StyleBox["0", "MR"],
              " and ",
              StyleBox["1", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Text[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "the text of ",
              StyleBox["expr", "TI"],
              ", centered at ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              " (see Section\[NonBreakingSpace]",
              ButtonBox["2.10.16",
                ButtonData:>{"2.10.16", "16.1"},
                ButtonStyle->"MainBookLink"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.2"],

Cell["\<\
Basic two\[Hyphen]dimensional graphics elements. \
\>", "Caption",
  CellTags->"S2.10.2"],

Cell["Here is a line primitive. ", "MathCaption",
  CellTags->{"S2.10.2", "2.2"}],

Cell[CellGroupData[{

Cell["sawline = Line[Table[{n, (-1)^n}, {n, 6}]]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.2"],

Cell[BoxData[
    \(Line[{{1, \(-1\)}, {2, 1}, {3, \(-1\)}, {4, 1}, {5, \(-1\)}, {6, 
          1}}]\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["\<\
This shows the line as a two\[Hyphen]dimensional graphics object. \
\
\>", "MathCaption",
  CellTags->{"S2.10.2", "2.3"}],

Cell[CellGroupData[{

Cell["sawgraph = Show[ Graphics[sawline] ]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .01472 m
.21429 .60332 L
.40476 .01472 L
.59524 .60332 L
.78571 .01472 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["This redisplays the line, with axes added. ", "MathCaption",
  CellTags->{"S2.10.2", "2.4"}],

Cell[CellGroupData[{

Cell["Show[ %, Axes -> True ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 0.309017 0.294302 [
[.21429 .29652 -3 -9 ]
[.21429 .29652 3 0 ]
[.40476 .29652 -3 -9 ]
[.40476 .29652 3 0 ]
[.59524 .29652 -3 -9 ]
[.59524 .29652 3 0 ]
[.78571 .29652 -3 -9 ]
[.78571 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(3)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(4)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(5)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(6)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.21429 .60332 L
.40476 .01472 L
.59524 .60332 L
.78571 .01472 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  "You can combine graphics objects that you have created explicitly from \
graphics primitives with ones that are produced by functions like ",
  StyleBox["Plot", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.2", "2.5"}],

Cell[TextData[{
  "This produces an ordinary ",
  StyleBox["Mathematica", "TI"],
  " plot. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.6"}],

Cell[CellGroupData[{

Cell["Plot[Sin[Pi x], {x, 0, 6}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0.309016 0.294303 [
[.18254 .29652 -3 -9 ]
[.18254 .29652 3 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16186 -24 -4.5 ]
[.01131 .16186 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(1)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(2)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(3)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(4)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(6)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16186 m
.03006 .16186 L
s
[(-0.5)] .01131 .16186 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07357 m
.02756 .07357 L
s
.02381 .103 m
.02756 .103 L
s
.02381 .13243 m
.02756 .13243 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.04262 .41606 L
.06244 .51276 L
.07286 .5519 L
.08255 .57915 L
.08813 .59036 L
.09076 .59448 L
.0932 .5976 L
.096 .60036 L
.09748 .60145 L
.09824 .60191 L
.09905 .60234 L
.09976 .60265 L
.10041 .60288 L
.10168 .60319 L
.10239 .60328 L
.10317 .60332 L
.1039 .60329 L
.10458 .60321 L
.10587 .6029 L
.10651 .60268 L
.10722 .60237 L
.10848 .6017 L
.10966 .6009 L
.11231 .59853 L
.11515 .59509 L
.12035 .58647 L
.1251 .57604 L
.13466 .54801 L
.14371 .51358 L
.18204 .31193 L
.20142 .20156 L
.21172 .14833 L
.22282 .09846 L
.23339 .06036 L
.23801 .04701 L
.24307 .03492 L
.24787 .02599 L
.25234 .01998 L
.25481 .01761 L
.25705 .01607 L
.25829 .01546 L
.259 .0152 L
.25964 .01501 L
.26083 .01478 L
.26209 .01472 L
.2633 .01483 L
.26462 .01514 L
.26586 .01562 L
.26702 .01622 L
Mistroke
.2692 .01778 L
.27152 .02003 L
.27427 .02348 L
.27684 .02749 L
.28166 .03693 L
.29046 .06049 L
.29997 .09438 L
.31995 .1885 L
.34103 .30762 L
.36093 .42068 L
.37905 .50916 L
.3891 .54783 L
.3986 .57578 L
.40382 .58716 L
.40863 .59506 L
.41115 .59815 L
.41392 .60072 L
.41532 .60169 L
.41605 .60211 L
.41682 .60248 L
.41749 .60275 L
.41823 .60299 L
.41953 .60325 L
.42017 .60331 L
.42086 .60332 L
.42208 .6032 L
.42339 .60288 L
.42414 .60261 L
.42483 .6023 L
.42724 .6008 L
.4286 .59967 L
.42983 .59846 L
.43463 .5921 L
.43918 .58372 L
.44922 .55747 L
.46014 .51783 L
.47989 .42306 L
.50089 .30381 L
.52056 .19252 L
.53861 .10537 L
.54802 .06955 L
.55794 .04079 L
.56309 .02985 L
.56789 .02227 L
.57065 .01909 L
.57315 .01693 L
.57454 .01605 L
.57527 .01568 L
.57605 .01535 L
.57672 .01512 L
Mistroke
.57747 .01492 L
.57878 .01473 L
.58007 .01474 L
.58127 .01492 L
.58259 .01531 L
.58332 .01561 L
.58399 .01594 L
.58653 .01767 L
.58893 .01997 L
.59339 .02597 L
.59821 .03494 L
.6035 .04765 L
.60909 .06418 L
.61909 .10109 L
.65708 .29942 L
.67824 .41987 L
.69753 .51344 L
.70711 .54968 L
.71216 .56538 L
.71752 .57926 L
.7222 .58887 L
.72468 .59301 L
.72736 .5967 L
.72981 .59937 L
.73088 .60032 L
.73205 .60122 L
.73309 .60188 L
.7342 .60244 L
.73537 .60289 L
.73645 .60316 L
.73769 .60331 L
.73839 .60331 L
.73905 .60327 L
.73974 .60316 L
.74037 .60302 L
.7411 .6028 L
.74179 .60253 L
.74301 .60193 L
.74414 .60121 L
.74671 .59905 L
.74953 .59581 L
.75209 .5921 L
.75782 .58118 L
.76281 .5688 L
.7682 .55259 L
.77797 .51632 L
.81905 .29977 L
.83953 .18454 L
.84952 .13458 L
.85861 .09497 L
Mistroke
.86742 .06317 L
.87699 .03711 L
.88224 .02689 L
.88455 .02336 L
.88709 .02016 L
.88949 .01781 L
.89173 .01621 L
.89297 .01557 L
.8941 .01514 L
.89541 .01483 L
.89665 .01472 L
.89789 .01478 L
.89859 .01489 L
.89924 .01505 L
.90042 .01546 L
.90168 .01607 L
.90385 .01755 L
.90623 .0198 L
.90878 .02291 L
.91151 .02706 L
.91645 .03663 L
.92606 .06263 L
.93483 .09413 L
.95391 .18339 L
.97467 .30013 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["\<\
This combines the plot with the sawtooth picture made above. \
\>", \
"MathCaption",
  CellTags->{"S2.10.2", "2.7"}],

Cell[CellGroupData[{

Cell["Show[%, sawgraph]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0.309017 0.294302 [
[.18254 .29652 -3 -9 ]
[.18254 .29652 3 0 ]
[.34127 .29652 -3 -9 ]
[.34127 .29652 3 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.01131 .01472 -12 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(1)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(2)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(3)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(4)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(6)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-1)] .01131 .01472 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.04262 .41606 L
.06244 .51276 L
.07286 .5519 L
.08255 .57915 L
.08813 .59036 L
.09076 .59448 L
.0932 .5976 L
.096 .60036 L
.09748 .60145 L
.09824 .60191 L
.09905 .60234 L
.09976 .60265 L
.10041 .60288 L
.10168 .60319 L
.10239 .60328 L
.10317 .60332 L
.1039 .60329 L
.10458 .60321 L
.10587 .6029 L
.10651 .60268 L
.10722 .60237 L
.10848 .6017 L
.10966 .6009 L
.11231 .59853 L
.11515 .59509 L
.12035 .58647 L
.1251 .57604 L
.13466 .54801 L
.14371 .51358 L
.18204 .31193 L
.20142 .20156 L
.21172 .14833 L
.22282 .09846 L
.23339 .06036 L
.23801 .04701 L
.24307 .03492 L
.24787 .02599 L
.25234 .01998 L
.25481 .01761 L
.25705 .01607 L
.25829 .01547 L
.259 .0152 L
.25964 .01501 L
.26083 .01478 L
.26209 .01472 L
.2633 .01483 L
.26462 .01514 L
.26586 .01562 L
.26702 .01622 L
Mistroke
.2692 .01778 L
.27152 .02003 L
.27427 .02348 L
.27684 .02749 L
.28166 .03693 L
.29046 .06049 L
.29997 .09438 L
.31995 .1885 L
.34103 .30762 L
.36093 .42068 L
.37905 .50916 L
.3891 .54783 L
.3986 .57578 L
.40382 .58716 L
.40863 .59506 L
.41115 .59815 L
.41392 .60072 L
.41532 .60169 L
.41605 .60211 L
.41682 .60248 L
.41749 .60275 L
.41823 .60299 L
.41953 .60325 L
.42017 .60331 L
.42086 .60332 L
.42208 .6032 L
.42339 .60288 L
.42414 .60261 L
.42483 .6023 L
.42724 .6008 L
.4286 .59967 L
.42983 .59846 L
.43463 .5921 L
.43918 .58372 L
.44922 .55747 L
.46014 .51783 L
.47989 .42306 L
.50089 .30381 L
.52056 .19252 L
.53861 .10537 L
.54802 .06955 L
.55794 .04079 L
.56309 .02985 L
.56789 .02228 L
.57065 .01909 L
.57315 .01694 L
.57454 .01606 L
.57527 .01568 L
.57605 .01535 L
.57672 .01512 L
Mistroke
.57747 .01492 L
.57878 .01473 L
.58007 .01474 L
.58127 .01492 L
.58259 .01531 L
.58332 .01562 L
.58399 .01594 L
.58653 .01767 L
.58893 .01997 L
.59339 .02598 L
.59821 .03494 L
.6035 .04765 L
.60909 .06418 L
.61909 .10109 L
.65708 .29942 L
.67824 .41987 L
.69753 .51344 L
.70711 .54968 L
.71216 .56538 L
.71752 .57926 L
.7222 .58887 L
.72468 .59301 L
.72736 .5967 L
.72981 .59937 L
.73088 .60032 L
.73205 .60122 L
.73309 .60188 L
.7342 .60244 L
.73537 .60289 L
.73645 .60316 L
.73769 .60331 L
.73839 .60331 L
.73905 .60327 L
.73974 .60316 L
.74037 .60302 L
.7411 .6028 L
.74179 .60253 L
.74301 .60193 L
.74414 .60121 L
.74671 .59905 L
.74953 .59581 L
.75209 .5921 L
.75782 .58118 L
.76281 .5688 L
.7682 .55259 L
.77797 .51632 L
.81905 .29977 L
.83953 .18454 L
.84952 .13458 L
.85861 .09497 L
Mistroke
.86742 .06317 L
.87699 .03711 L
.88224 .02689 L
.88455 .02336 L
.88709 .02016 L
.88949 .01781 L
.89173 .01621 L
.89297 .01557 L
.8941 .01514 L
.89541 .01483 L
.89665 .01472 L
.89789 .01478 L
.89859 .0149 L
.89924 .01505 L
.90042 .01546 L
.90168 .01607 L
.90385 .01755 L
.90623 .0198 L
.90878 .02292 L
.91151 .02706 L
.91645 .03663 L
.92606 .06263 L
.93483 .09413 L
.95391 .18339 L
.97467 .30013 L
.97619 .30902 L
Mfstroke
.18254 .01472 m
.34127 .60332 L
.5 .01472 L
.65873 .60332 L
.81746 .01472 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  "You can combine different graphical elements simply by giving them in a \
list. In two\[Hyphen]dimensional graphics, ",
  StyleBox["Mathematica", "TI"],
  " will render the elements in exactly the order you give them. Later \
elements are therefore effectively drawn on top of earlier ones. "
}], "Text",
  CellTags->{"S2.10.2", "2.8"}],

Cell[TextData[{
  "Here is a list of two ",
  StyleBox["Rectangle", "MR"],
  " graphics elements. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.9"}],

Cell[CellGroupData[{

Cell["{Rectangle[{1, -1}, {2, -0.6}], Rectangle[{4, .3}, {5, .8}]}", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.2"],

Cell[BoxData[
    \({Rectangle[{1, \(-1\)}, {2, \(-0.6`\)}], 
      Rectangle[{4, 0.3`}, {5, 0.8`}]}\)], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["\<\
This draws the rectangles on top of the line that was defined \
above. \
\>", "MathCaption",
  CellTags->{"S2.10.2", "2.10"}],

Cell[CellGroupData[{

Cell["Show[ Graphics[ {sawline, %} ]]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.02381 .01472 m
.21429 .60332 L
.40476 .01472 L
.59524 .60332 L
.78571 .01472 L
.97619 .60332 L
s
.02381 .01472 m
.02381 .13244 L
.21429 .13244 L
.21429 .01472 L
F
.59524 .39731 m
.59524 .54446 L
.78571 .54446 L
.78571 .39731 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Polygon", "MR"],
  " graphics primitive takes a list of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " coordinates, corresponding to the corners of a polygon. ",
  StyleBox["Mathematica", "TI"],
  " joins the last corner with the first one, and then fills the resulting \
area. "
}], "Text",
  CellTags->{"S2.10.2", "2.11"}],

Cell["\<\
Here are the coordinates of the corners of a regular pentagon. \
\
\>", "MathCaption",
  CellTags->{"S2.10.2", "2.12"}],

Cell[CellGroupData[{

Cell["pentagon = Table[{Sin[2 Pi n/5], Cos[2 Pi n/5]}, {n, 5}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.2"],

Cell[BoxData[
    \({{1\/2\ \@\(1\/2\ \((5 + \@5)\)\), 
        1\/4\ \((\(-1\) + \@5)\)}, {1\/2\ \@\(1\/2\ \((5 - \@5)\)\), 
        1\/4\ \((\(-1\) - \@5)\)}, {\(-\(1\/2\)\)\ \@\(1\/2\ \((5 - \@5)\)\), 
        1\/4\ \((\(-1\) - \@5)\)}, {\(-\(1\/2\)\)\ \@\(1\/2\ \((5 + \@5)\)\), 
        1\/4\ \((\(-1\) + \@5)\)}, {0, 1}}\)], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["\<\
This displays the pentagon. With the default choice of aspect \
ratio, the pentagon looks somewhat squashed. \
\>", "MathCaption",
  CellTags->{"S2.10.2", "2.13"}],

Cell[CellGroupData[{

Cell["Show[ Graphics[ Polygon[pentagon] ] ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.500696 0.277947 0.325372 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.97619 .37849 m
.7943 .01472 L
.2057 .01472 L
.02381 .37849 L
.5 .60332 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["\<\
This chooses the aspect ratio so that the shape of the pentagon is \
preserved. \
\>", "MathCaption",
  CellTags->{"S2.10.2", "2.14"}],

Cell[CellGroupData[{

Cell["Show[%, AspectRatio -> Automatic]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95106 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.500696 0.427716 0.500696 [
[ 0 0 0 0 ]
[ 1 .95106 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95106 L
0 .95106 L
closepath
clip
newpath
0 g
.97619 .58244 m
.7943 .02264 L
.2057 .02264 L
.02381 .58244 L
.5 .92841 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can handle polygons which fold over themselves. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.15"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[ Polygon[ {{-1, -1}, {1, 1}, {1, -1}, {-1, 1}} ] ]]\
\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.02381 .01472 m
.97619 .60332 L
.97619 .01472 L
.02381 .60332 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Circle[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "a circle with radius ",
              StyleBox["r", "TI"],
              " centered at the point ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Circle[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "an ellipse with semi\[Hyphen]axes ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Circle[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["theta",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["theta",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["a circular arc "]},
          {Cell[TextData[{
              StyleBox["Circle[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["x",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["r",
                        "TI"], 
                      StyleBox["y",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["theta",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["theta",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["an elliptical arc "]},
          {Cell[TextData[{
              StyleBox["Disk[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["r", "TI"],
              StyleBox["]", "MR"],
              ",  etc. "
            }]], Cell["filled disks "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.2"],

Cell["Circles and disks. ", "Caption",
  CellTags->"S2.10.2"],

Cell[TextData[{
  "This shows two circles with radius 2. Setting the option ",
  StyleBox["AspectRatio", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " makes the circles come out with their natural aspect ratio. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.16"}],

Cell[CellGroupData[{

Cell["\<\
Show[ Graphics[ {Circle[{0, 0}, 2], Circle[{1, 1}, 2]} ], \
AspectRatio -> Automatic ]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.190476 0.404762 0.190476 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
newpath
.40476 .40476 .38095 0 365.73 arc
s
newpath
.59524 .59524 .38095 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  "This shows a sequence of disks with progressively larger semi\[Hyphen]axes \
in the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " direction, and progressively smaller ones in the ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " direction. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.17"}],

Cell[CellGroupData[{

Cell["\<\
Show[ Graphics[ Table[Disk[{3n, 0}, {n/4, 2-n/4}], {n, 4}] ], \
AspectRatio -> Automatic ]\
\>", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .34146 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.231707 0.0929152 0.170732 0.0929152 [
[ 0 0 0 0 ]
[ 1 .34146 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .34146 L
0 .34146 L
closepath
clip
newpath
0 g
.04704 .17073 m
matrix currentmatrix
0.0232288 0.162602 scale
2.02507 1.04999 1 0 365.73 arc
setmatrix F
.32578 .17073 m
matrix currentmatrix
0.0464576 0.139373 scale
7.01241 1.22499 1 0 365.73 arc
setmatrix F
.60453 .17073 m
matrix currentmatrix
0.0696864 0.116144 scale
8.67501 1.46999 1 0 365.73 arc
setmatrix F
.88328 .17073 m
.88328 .17073 .09292 0 365.73 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows you to generate arcs of circles, and segments of ellipses. In both \
cases, the objects are specified by starting and finishing angles. The angles \
are measured counterclockwise in radians with zero corresponding to the \
positive ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " direction. "
}], "Text",
  CellTags->{"S2.10.2", "2.18"}],

Cell[TextData[{
  "This draws a ",
  Cell[BoxData[
      \(TraditionalForm\`140\^\[EmptySmallCircle]\)], "InlineFormula"],
  " wedge centered at the origin. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.19"}],

Cell[CellGroupData[{

Cell["\<\
Show[ Graphics[ Disk[{0, 0}, 1, {0, 140 Degree}] ], AspectRatio -> \
Automatic ]\
\>", "Input",
  CellLabel->"In[14]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .56624 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.436917 0.539273 0.0134818 0.539273 [
[ 0 0 0 0 ]
[ 1 .56624 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .56624 L
0 .56624 L
closepath
clip
newpath
0 g
.43692 .01348 m
.43692 .01348 .53927 0 140 arc
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[14]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Raster[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["a",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell["array of gray levels between 0 and 1 "]},
          {Cell[TextData[{
              StyleBox["Raster[", "MR"],
              StyleBox["array", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "array of gray levels between ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " drawn in the rectangle defined by ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[" and ", "TR"],
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["RasterArray[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "11"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "12"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], "21"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis] }, \[Ellipsis] }]",
              StyleBox[" ", "TR"]
            }]], Cell[TextData[{
              
              "rectangular array of cells colored according to the graphics \
directives ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["g",
                        "TI"], 
                      StyleBox["ij",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.2"],

Cell["\<\
Raster\[Hyphen]based graphics elements. \
\>", "Caption",
  CellTags->"S2.10.2"],

Cell[TextData[{
  "Here is a ",
  Cell[BoxData[
      \(TraditionalForm\`4\[Cross]4\)], "InlineFormula"],
  " array of values between 0 and 1. "
}], "MathCaption",
  CellTags->{"S2.10.2", "2.20"}],

Cell[CellGroupData[{

Cell["modtab = Table[Mod[i, j]/3, {i, 4}, {j, 4}] // N", "Input",
  CellLabel->"In[15]:= ",
  CellTags->"S2.10.2"],

Cell[BoxData[
    \({{0.`, 0.3333333333333333`, 0.3333333333333333`, 
        0.3333333333333333`}, {0.`, 0.`, 0.6666666666666666`, 
        0.6666666666666666`}, {0.`, 0.3333333333333333`, 0.`, 1.`}, {0.`, 
        0.`, 0.3333333333333333`, 0.`}}\)], "Output",
  CellLabel->"Out[15]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["This uses the array of values as gray levels in a raster. ", \
"MathCaption",
  CellTags->{"S2.10.2", "2.21"}],

Cell[CellGroupData[{

Cell["Show[ Graphics[ Raster[%] ] ]", "Input",
  CellLabel->"In[16]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0147151 0.147151 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01472 translate
.95238 .5886 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00555555
0000AAAA
005500FF
00005500
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[16]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell["This shows two overlapping copies of the raster. ", "MathCaption",
  CellTags->{"S2.10.2", "2.22"}],

Cell[CellGroupData[{

Cell["\<\
Show[ Graphics[ {Raster[modtab, {{0, 0}, {2, 2}}], Raster[modtab, \
{{1.5, 1.5}, {3, 2}}]} ] ]\
\>", "Input",
  CellLabel->"In[17]:= ",
  CellTags->"S2.10.2"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.0147151 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of gray image
p
.02381 .01472 translate
.63492 .5886 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00555555
0000AAAA
005500FF
00005500
pop
P
% End of image
% Start of gray image
p
.5 .45617 translate
.47619 .14715 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00555555
0000AAAA
005500FF
00005500
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.2"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]= ",
  CellTags->"S2.10.2"]
}, Open  ]],

Cell[TextData[{
  "In the default case, ",
  StyleBox["Raster", "MR"],
  " always generates an array of gray cells. As described in Section\
\[NonBreakingSpace]",
  ButtonBox["2.10.7",
    ButtonData:>{"2.10.7", "7.4"},
    ButtonStyle->"MainBookLink"],
  ", you can use the option ",
  StyleBox["ColorFunction", "MR"],
  " to apply a \[OpenCurlyDoubleQuote]coloring function\
\[CloseCurlyDoubleQuote] to all the cells. "
}], "Text",
  CellTags->{"S2.10.2", "2.23"}],

Cell[TextData[{
  "You can also use the graphics primitive ",
  StyleBox["RasterArray", "MR"],
  ". While ",
  StyleBox["Raster", "MR"],
  " takes an array of ",
  StyleBox["values", "TI"],
  ", ",
  StyleBox["RasterArray", "MR"],
  " takes an array of ",
  StyleBox["Mathematica", "TI"],
  " ",
  StyleBox["graphics directives", "TI"],
  ". The directives associated with each cell are taken to determine the \
color of that cell. Typically the directives are chosen from the set ",
  StyleBox["GrayLevel", "MR"],
  ", ",
  StyleBox["RGBColor", "MR"],
  " or ",
  StyleBox["Hue", "MR"],
  ". By using ",
  StyleBox["RGBColor", "MR"],
  " and ",
  StyleBox["Hue", "MR"],
  " directives, you can create color rasters using ",
  StyleBox["RasterArray", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.2", "2.24"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.10.3 Graphics Directives and Options", "Subsection",
  CellTags->{"S2.10.3", "3.1"}],

Cell[TextData[{
  "When you set up a graphics object in ",
  StyleBox["Mathematica", "TI"],
  ", you typically give a list of graphical elements. You can include in that \
list ",
  StyleBox["graphics directives", "TI"],
  " which specify how subsequent elements in the list should be rendered. "
}], "Text",
  CellTags->{"S2.10.3", "3.2"}],

Cell["\<\
In general, the graphical elements in a particular graphics object \
can be given in a collection of nested lists. When you insert graphics \
directives in this kind of structure, the rule is that a particular graphics \
directive affects all subsequent elements of the list it is in, together with \
all elements of sublists that may occur. The graphics directive does not, \
however, have any effect outside the list it is in. \
\>", "Text",
  CellTags->{"S2.10.3", "3.3"}],

Cell[TextData[{
  "The first sublist contains the graphics directive ",
  StyleBox["GrayLevel", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.3", "3.4"}],

Cell[CellGroupData[{

Cell["\<\
{{GrayLevel[0.5], Rectangle[{0, 0}, {1, 1}]}, Rectangle[{1, 1}, {2, \
2}]}\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.3"],

Cell[BoxData[
    \({{GrayLevel[0.5`], Rectangle[{0, 0}, {1, 1}]}, 
      Rectangle[{1, 1}, {2, 2}]}\)], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[TextData[{
  "Only the rectangle in the first sublist is affected by the ",
  StyleBox["GrayLevel", "MR"],
  " directive. "
}], "MathCaption",
  CellTags->{"S2.10.3", "3.5"}],

Cell[CellGroupData[{

Cell["Show[Graphics[ % ]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 g
.02381 .01472 m
.02381 .30902 L
.5 .30902 L
.5 .01472 L
F
0 g
.5 .30902 m
.5 .60332 L
.97619 .60332 L
.97619 .30902 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " provides various kinds of graphics directives. One important set is those \
for specifying the colors of graphical elements. Even if you have a black\
\[Hyphen]and\[Hyphen]white display device, you can still give color graphics \
directives. The colors you specify will be converted to gray levels at the \
last step in the graphics rendering process. Note that you can get gray\
\[Hyphen]level display even on a color device by setting the option ",
  StyleBox["ColorOutput", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["GrayLevel", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.3", "3.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["GrayLevel[", "MR"],
              StyleBox["i", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["gray level between 0 (black) and 1 (white) "]},
          {Cell[TextData[{
              StyleBox["RGBColor[", "MR"],
              StyleBox["r", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["g", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
color with specified red, green and blue components, \
each between 0 and 1 \
\>"]},
          {Cell[TextData[{
              StyleBox["Hue[", "MR"],
              StyleBox["h", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "color with hue ",
              StyleBox["h", "TI"],
              " between 0 and 1 "
            }]]},
          {Cell[TextData[{
              StyleBox["Hue[", "MR"],
              StyleBox["h", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["s", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["b", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], 
            Cell["\<\
color with specified hue, saturation and brightness, \
each between 0 and 1 \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.3"],

Cell[TextData[{
  "Basic ",
  StyleBox["Mathematica", "SO"],
  " color specifications. "
}], "Caption",
  CellTags->"S2.10.3"],

Cell["\<\
On a color display, the two curves are shown in color. In black and \
white they are shown in gray. \
\>", "MathCaption",
  CellTags->{"S2.10.3", "3.7"}],

Cell[CellGroupData[{

Cell["\<\
Plot[{BesselI[1, x], BesselI[2, x]}, {x, 0, 5}, PlotStyle -> \
{{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 0]}}]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.0147151 0.0241869 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13565 -6 -4.5 ]
[.01131 .13565 0 4.5 ]
[.01131 .25658 -12 -4.5 ]
[.01131 .25658 0 4.5 ]
[.01131 .37752 -12 -4.5 ]
[.01131 .37752 0 4.5 ]
[.01131 .49845 -12 -4.5 ]
[.01131 .49845 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(1)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(2)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(3)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(4)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.0619 .01472 m
.0619 .01847 L
s
.1 .01472 m
.1 .01847 L
s
.1381 .01472 m
.1381 .01847 L
s
.17619 .01472 m
.17619 .01847 L
s
.25238 .01472 m
.25238 .01847 L
s
.29048 .01472 m
.29048 .01847 L
s
.32857 .01472 m
.32857 .01847 L
s
.36667 .01472 m
.36667 .01847 L
s
.44286 .01472 m
.44286 .01847 L
s
.48095 .01472 m
.48095 .01847 L
s
.51905 .01472 m
.51905 .01847 L
s
.55714 .01472 m
.55714 .01847 L
s
.63333 .01472 m
.63333 .01847 L
s
.67143 .01472 m
.67143 .01847 L
s
.70952 .01472 m
.70952 .01847 L
s
.74762 .01472 m
.74762 .01847 L
s
.82381 .01472 m
.82381 .01847 L
s
.8619 .01472 m
.8619 .01847 L
s
.9 .01472 m
.9 .01847 L
s
.9381 .01472 m
.9381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13565 m
.03006 .13565 L
s
[(5)] .01131 .13565 1 0 Mshowa
.02381 .25658 m
.03006 .25658 L
s
[(10)] .01131 .25658 1 0 Mshowa
.02381 .37752 m
.03006 .37752 L
s
[(15)] .01131 .37752 1 0 Mshowa
.02381 .49845 m
.03006 .49845 L
s
[(20)] .01131 .49845 1 0 Mshowa
.125 Mabswid
.02381 .0389 m
.02756 .0389 L
s
.02381 .06309 m
.02756 .06309 L
s
.02381 .08728 m
.02756 .08728 L
s
.02381 .11146 m
.02756 .11146 L
s
.02381 .15984 m
.02756 .15984 L
s
.02381 .18402 m
.02756 .18402 L
s
.02381 .20821 m
.02756 .20821 L
s
.02381 .2324 m
.02756 .2324 L
s
.02381 .28077 m
.02756 .28077 L
s
.02381 .30496 m
.02756 .30496 L
s
.02381 .32914 m
.02756 .32914 L
s
.02381 .35333 m
.02756 .35333 L
s
.02381 .40171 m
.02756 .40171 L
s
.02381 .42589 m
.02756 .42589 L
s
.02381 .45008 m
.02756 .45008 L
s
.02381 .47427 m
.02756 .47427 L
s
.02381 .52264 m
.02756 .52264 L
s
.02381 .54683 m
.02756 .54683 L
s
.02381 .57101 m
.02756 .57101 L
s
.02381 .5952 m
.02756 .5952 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.06244 .01718 L
.10458 .01996 L
.14415 .02274 L
.18221 .02567 L
.22272 .02915 L
.26171 .03296 L
.30316 .03767 L
.34309 .04299 L
.3815 .04902 L
.42237 .05664 L
.46172 .06541 L
.49955 .07546 L
.53984 .08827 L
.57861 .1031 L
.61984 .12214 L
.65954 .14435 L
.69774 .17007 L
.73838 .20315 L
.77751 .24172 L
.81909 .29153 L
.85916 .35001 L
.89771 .41811 L
.93871 .50603 L
.97619 .60332 L
s
0 1 0 r
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.03053 .01472 L
.03279 .01472 L
.03527 .01473 L
.0379 .01473 L
.04262 .01474 L
.04749 .01476 L
.05205 .01478 L
.06244 .01484 L
.07305 .01492 L
.08274 .01501 L
.10458 .01527 L
.12357 .01556 L
.14429 .01597 L
.18493 .01701 L
.22406 .01838 L
.26565 .02028 L
.30571 .02263 L
.34426 .02548 L
.38527 .02926 L
.42475 .0338 L
.46273 .03916 L
.50315 .04619 L
.54206 .05452 L
.58342 .06544 L
.62326 .07843 L
.66159 .09371 L
.70238 .11366 L
.74164 .13725 L
.77939 .16488 L
.8196 .20081 L
.85828 .24313 L
.89942 .29832 L
.93905 .36365 L
.97619 .43812 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " provides a convenient way to specify a range of colors using just one \
parameter. As ",
  StyleBox["h", "TI"],
  " varies from 0 to 1, ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox["]", "MR"],
  " runs through red, yellow, green, cyan, blue, magenta, and back to red \
again. ",
  StyleBox["Hue[", "MR"],
  StyleBox["h", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["s", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["b", "TI"],
  StyleBox["]", "MR"],
  " allows you to specify not only the \[OpenCurlyDoubleQuote]hue\
\[CloseCurlyDoubleQuote], but also the \[OpenCurlyDoubleQuote]saturation\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]brightness\
\[CloseCurlyDoubleQuote] of a color. Taking the saturation to be equal to one \
gives the deepest colors; decreasing the saturation toward zero leads to \
progressively more \[OpenCurlyDoubleQuote]washed out\[CloseCurlyDoubleQuote] \
colors. "
}], "Text",
  CellTags->{"S2.10.3", "3.8"}],

Cell[TextData[{
  "For most purposes, you will be able to specify the colors you need simply \
by giving appropriate ",
  StyleBox["RGBColor", "MR"],
  " or ",
  StyleBox["Hue", "MR"],
  " directives. However, if you need very precise or repeatable colors, \
particularly for color printing, there are a number of subtleties which \
arise, as discussed in Section ",
  ButtonBox["2.10.17",
    ButtonData:>{"2.10.17", "17.1"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.10.3", "3.9"}],

Cell[TextData[{
  "When you give a graphics directive such as ",
  StyleBox["RGBColor", "MR"],
  ", it affects ",
  StyleBox["all", "TI"],
  " subsequent graphical elements that appear in a particular list. ",
  StyleBox["Mathematica", "TI"],
  " also supports various graphics directives which affect only specific \
types of graphical elements. "
}], "Text",
  CellTags->{"S2.10.3", "3.10"}],

Cell[TextData[{
  "The graphics directive ",
  StyleBox["PointSize[", "MR"],
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  " specifies that all ",
  StyleBox["Point", "MR"],
  " elements which appear in a graphics object should be drawn as circles \
with diameter ",
  StyleBox["d", "TI"],
  ". In ",
  StyleBox["PointSize", "MR"],
  ", the diameter ",
  StyleBox["d", "TI"],
  " is measured as a fraction of the width of your whole plot. "
}], "Text",
  CellTags->{"S2.10.3", "3.11"}],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " also provides the graphics directive ",
  StyleBox["AbsolutePointSize[", "MR"],
  StyleBox["d", "TI"],
  StyleBox["]", "MR"],
  ", which allows you to specify the \[OpenCurlyDoubleQuote]absolute\
\[CloseCurlyDoubleQuote] diameter of points, measured in fixed units. The \
units are ",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula"],
  " of an inch, approximately printer's points. "
}], "Text",
  CellTags->{"S2.10.3", "3.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PointSize[", "MR"],
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give all points a diameter ",
              StyleBox["d", "TI"],
              " as a fraction of the width of the whole plot "
            }]]},
          {Cell[TextData[{
              StyleBox["AbsolutePointSize[", "MR"],
              StyleBox["d", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give all points a diameter ",
              StyleBox["d", "TI"],
              " measured in absolute units "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.3"],

Cell["Graphics directives for points. ", "Caption",
  CellTags->"S2.10.3"],

Cell["Here is a list of points. ", "MathCaption",
  CellTags->{"S2.10.3", "3.13"}],

Cell[CellGroupData[{

Cell["Table[Point[{n, Prime[n]}], {n, 6}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.3"],

Cell[BoxData[
    \({Point[{1, 2}], Point[{2, 3}], Point[{3, 5}], Point[{4, 7}], 
      Point[{5, 11}], Point[{6, 13}]}\)], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell["\<\
This makes each point have a diameter equal to one\[Hyphen]tenth of \
the width of the plot. \
\>", "MathCaption",
  CellTags->{"S2.10.3", "3.14"}],

Cell[CellGroupData[{

Cell["Show[Graphics[{PointSize[0.1], %}], PlotRange -> All]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.166667 0.190476 -0.0923038 0.0535094 [
[ -0.02619 -0.03528 0 0 ]
[ 1.02619 .65332 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.1 w
.02381 .01472 Mdot
.21429 .06822 Mdot
.40476 .17524 Mdot
.59524 .28226 Mdot
.78571 .4963 Mdot
.97619 .60332 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell["Here each point has size 3 in absolute units. ", "MathCaption",
  CellTags->{"S2.10.3", "3.15"}],

Cell[CellGroupData[{

Cell["\<\
ListPlot[Table[Prime[n], {n, 20}], Prolog -> \
AbsolutePointSize[3]]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0.0147151 0.00829019 [
[.2619 .00222 -3 -9 ]
[.2619 .00222 3 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .09762 -12 -4.5 ]
[.01131 .09762 0 4.5 ]
[.01131 .18052 -12 -4.5 ]
[.01131 .18052 0 4.5 ]
[.01131 .26342 -12 -4.5 ]
[.01131 .26342 0 4.5 ]
[.01131 .34632 -12 -4.5 ]
[.01131 .34632 0 4.5 ]
[.01131 .42922 -12 -4.5 ]
[.01131 .42922 0 4.5 ]
[.01131 .51213 -12 -4.5 ]
[.01131 .51213 0 4.5 ]
[.01131 .59503 -12 -4.5 ]
[.01131 .59503 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(10)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(15)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(20)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09762 m
.03006 .09762 L
s
[(10)] .01131 .09762 1 0 Mshowa
.02381 .18052 m
.03006 .18052 L
s
[(20)] .01131 .18052 1 0 Mshowa
.02381 .26342 m
.03006 .26342 L
s
[(30)] .01131 .26342 1 0 Mshowa
.02381 .34632 m
.03006 .34632 L
s
[(40)] .01131 .34632 1 0 Mshowa
.02381 .42922 m
.03006 .42922 L
s
[(50)] .01131 .42922 1 0 Mshowa
.02381 .51213 m
.03006 .51213 L
s
[(60)] .01131 .51213 1 0 Mshowa
.02381 .59503 m
.03006 .59503 L
s
[(70)] .01131 .59503 1 0 Mshowa
.125 Mabswid
.02381 .0313 m
.02756 .0313 L
s
.02381 .04788 m
.02756 .04788 L
s
.02381 .06446 m
.02756 .06446 L
s
.02381 .08104 m
.02756 .08104 L
s
.02381 .1142 m
.02756 .1142 L
s
.02381 .13078 m
.02756 .13078 L
s
.02381 .14736 m
.02756 .14736 L
s
.02381 .16394 m
.02756 .16394 L
s
.02381 .1971 m
.02756 .1971 L
s
.02381 .21368 m
.02756 .21368 L
s
.02381 .23026 m
.02756 .23026 L
s
.02381 .24684 m
.02756 .24684 L
s
.02381 .28 m
.02756 .28 L
s
.02381 .29658 m
.02756 .29658 L
s
.02381 .31316 m
.02756 .31316 L
s
.02381 .32974 m
.02756 .32974 L
s
.02381 .3629 m
.02756 .3629 L
s
.02381 .37948 m
.02756 .37948 L
s
.02381 .39606 m
.02756 .39606 L
s
.02381 .41264 m
.02756 .41264 L
s
.02381 .44581 m
.02756 .44581 L
s
.02381 .46239 m
.02756 .46239 L
s
.02381 .47897 m
.02756 .47897 L
s
.02381 .49555 m
.02756 .49555 L
s
.02381 .52871 m
.02756 .52871 L
s
.02381 .54529 m
.02756 .54529 L
s
.02381 .56187 m
.02756 .56187 L
s
.02381 .57845 m
.02756 .57845 L
s
.02381 .61161 m
.02756 .61161 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
3 Mabswid
.07143 .0313 Mdot
.11905 .03959 Mdot
.16667 .05617 Mdot
.21429 .07275 Mdot
.2619 .10591 Mdot
.30952 .12249 Mdot
.35714 .15565 Mdot
.40476 .17223 Mdot
.45238 .20539 Mdot
.5 .25513 Mdot
.54762 .27171 Mdot
.59524 .32145 Mdot
.64286 .35461 Mdot
.69048 .37119 Mdot
.7381 .40435 Mdot
.78571 .4541 Mdot
.83333 .50384 Mdot
.88095 .52042 Mdot
.92857 .57016 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Thickness[", "MR"],
              StyleBox["w", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give all lines a thickness ",
              StyleBox["w", "TI"],
              " as a fraction of the width of the whole plot "
            }]]},
          {Cell[TextData[{
              StyleBox["AbsoluteThickness[", "MR"],
              StyleBox["w", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "give all lines a thickness ",
              StyleBox["w", "TI"],
              " measured in absolute units "
            }]]},
          {Cell[TextData[{
              StyleBox["Dashing[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["w",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["w",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              
              "show all lines as a sequence of dashed segments, with lengths \
",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["w",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["w",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["AbsoluteDashing[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["w",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["w",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["use absolute units to measure dashed segments "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.3"],

Cell["Graphics directives for lines. ", "Caption",
  CellTags->"S2.10.3"],

Cell["\<\
This generates a list of lines with different absolute thicknesses. \
\
\>", "MathCaption",
  CellTags->{"S2.10.3", "3.16"}],

Cell[CellGroupData[{

Cell["\<\
Table[ {AbsoluteThickness[n], Line[{{0, 0}, {n, 1}}]}, {n, \
4}]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.3"],

Cell[BoxData[
    \({{AbsoluteThickness[1], Line[{{0, 0}, {1, 1}}]}, {AbsoluteThickness[2], 
        Line[{{0, 0}, {2, 1}}]}, {AbsoluteThickness[3], 
        Line[{{0, 0}, {3, 1}}]}, {AbsoluteThickness[4], 
        Line[{{0, 0}, {4, 1}}]}}\)], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell["Here is a picture of the lines. ", "MathCaption",
  CellTags->{"S2.10.3", "3.17"}],

Cell[CellGroupData[{

Cell["Show[Graphics[%]]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.238095 0.0147151 0.588604 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
1 Mabswid
[ ] 0 setdash
.02381 .01472 m
.2619 .60332 L
s
2 Mabswid
.02381 .01472 m
.5 .60332 L
s
3 Mabswid
.02381 .01472 m
.7381 .60332 L
s
4 Mabswid
.02381 .01472 m
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Dashing", "MR"],
  " graphics directive allows you to create lines with various kinds of \
dashing. The basic idea is to break lines into segments which are alternately \
drawn and omitted. By changing the lengths of the segments, you can get \
different line styles. ",
  StyleBox["Dashing", "MR"],
  " allows you to specify a sequence of segment lengths. This sequence is \
repeated as many times as necessary in drawing the whole line. "
}], "Text",
  CellTags->{"S2.10.3", "3.18"}],

Cell["\<\
This gives a dashed line with a succession of equal\[Hyphen]length \
segments. \
\>", "MathCaption",
  CellTags->{"S2.10.3", "3.19"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[ {Dashing[{0.05, 0.05}], Line[{{-1, -1}, {1, 1}}]} ]]\
\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ .05 .05 ] 0 setdash
.02381 .01472 m
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell["This gives a dot\[Hyphen]dashed line. ", "MathCaption",
  CellTags->{"S2.10.3", "3.20"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[{Dashing[{0.01, 0.05, 0.05, 0.05}], Line[{{-1, -1}, \
{1, 1}}]}]]\
\>", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.309017 0.294302 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.5 Mabswid
[ .01 .05 .05 .05 ] 0 setdash
.02381 .01472 m
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[TextData[{
  "One way to use ",
  StyleBox["Mathematica", "TI"],
  " graphics directives is to insert them directly into the lists of graphics \
primitives used by graphics objects. Sometimes, however, you want the \
graphics directives to be applied more globally, and for example to determine \
the overall \[OpenCurlyDoubleQuote]style\[CloseCurlyDoubleQuote] with which a \
particular type of graphical element should be rendered. There are typically \
graphics options which can be set to specify such styles in terms of lists of \
graphics directives. "
}], "Text",
  CellTags->{"S2.10.3", "3.21"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PlotStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["style", "TI"],
              " "
            }]], Cell[TextData[{
              "specify a style to be used for all curves in ",
              StyleBox["Plot", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["PlotStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["style",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["style",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              
              "specify styles to be used (cyclically) for a sequence of \
curves in ",
              StyleBox["Plot", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["MeshStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["style", "TI"],
              " "
            }]], 
            Cell["\<\
specify a style to be used for a mesh in density and \
surface graphics \
\>"]},
          {Cell[TextData[{
              StyleBox["BoxStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["style", "TI"],
              " "
            }]], 
            Cell["\<\
specify a style to be used for the bounding box in \
three\[Hyphen]dimensional graphics \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.3"],

Cell["Some graphics options for specifying styles. ", "Caption",
  CellTags->"S2.10.3"],

Cell["\<\
This generates a plot in which the curve is given in a style \
specified by graphics directives. \
\>", "MathCaption",
  CellTags->{"S2.10.3", "3.22"}],

Cell[CellGroupData[{

Cell["\<\
Plot[BesselJ[2, x], {x, 0, 10}, PlotStyle -> {{Thickness[0.02], \
GrayLevel[0.5]}}]\
\>", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.21429 .23289 -3 -9 ]
[.21429 .23289 3 0 ]
[.40476 .23289 -3 -9 ]
[.40476 .23289 3 0 ]
[.59524 .23289 -3 -9 ]
[.59524 .23289 3 0 ]
[.78571 .23289 -3 -9 ]
[.78571 .23289 3 0 ]
[.97619 .23289 -6 -9 ]
[.97619 .23289 6 0 ]
[.01131 .09824 -24 -4.5 ]
[.01131 .09824 0 4.5 ]
[.01131 .39254 -18 -4.5 ]
[.01131 .39254 0 4.5 ]
[.01131 .53968 -18 -4.5 ]
[.01131 .53968 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .24539 m
.21429 .25164 L
s
[(2)] .21429 .23289 0 1 Mshowa
.40476 .24539 m
.40476 .25164 L
s
[(4)] .40476 .23289 0 1 Mshowa
.59524 .24539 m
.59524 .25164 L
s
[(6)] .59524 .23289 0 1 Mshowa
.78571 .24539 m
.78571 .25164 L
s
[(8)] .78571 .23289 0 1 Mshowa
.97619 .24539 m
.97619 .25164 L
s
[(10)] .97619 .23289 0 1 Mshowa
.125 Mabswid
.07143 .24539 m
.07143 .24914 L
s
.11905 .24539 m
.11905 .24914 L
s
.16667 .24539 m
.16667 .24914 L
s
.2619 .24539 m
.2619 .24914 L
s
.30952 .24539 m
.30952 .24914 L
s
.35714 .24539 m
.35714 .24914 L
s
.45238 .24539 m
.45238 .24914 L
s
.5 .24539 m
.5 .24914 L
s
.54762 .24539 m
.54762 .24914 L
s
.64286 .24539 m
.64286 .24914 L
s
.69048 .24539 m
.69048 .24914 L
s
.7381 .24539 m
.7381 .24914 L
s
.83333 .24539 m
.83333 .24914 L
s
.88095 .24539 m
.88095 .24914 L
s
.92857 .24539 m
.92857 .24914 L
s
.25 Mabswid
0 .24539 m
1 .24539 L
s
.02381 .09824 m
.03006 .09824 L
s
[(-0.2)] .01131 .09824 1 0 Mshowa
.02381 .39254 m
.03006 .39254 L
s
[(0.2)] .01131 .39254 1 0 Mshowa
.02381 .53968 m
.03006 .53968 L
s
[(0.4)] .01131 .53968 1 0 Mshowa
.125 Mabswid
.02381 .13503 m
.02756 .13503 L
s
.02381 .17182 m
.02756 .17182 L
s
.02381 .2086 m
.02756 .2086 L
s
.02381 .28218 m
.02756 .28218 L
s
.02381 .31896 m
.02756 .31896 L
s
.02381 .35575 m
.02756 .35575 L
s
.02381 .42932 m
.02756 .42932 L
s
.02381 .46611 m
.02756 .46611 L
s
.02381 .50289 m
.02756 .50289 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .02467 m
.02756 .02467 L
s
.02381 .57647 m
.02756 .57647 L
s
.02381 .61325 m
.02756 .61325 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 g
.02 w
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["GrayLevel[0.5]", "MR"],
              " "
            }]], Cell["gray "]},
          {Cell[TextData[{
              StyleBox["RGBColor[1,", "MR"],
              " ",
              StyleBox["0,", "MR"],
              " ",
              StyleBox["0]", "MR"],
              ",  etc. "
            }]], Cell["red, etc. "]},
          {Cell[TextData[{
              StyleBox["Thickness[0.05]", "MR"],
              " "
            }]], Cell["thick "]},
          {Cell[TextData[{
              StyleBox["Dashing[{0.05,", "MR"],
              " ",
              StyleBox["0.05}]", "MR"],
              " "
            }]], Cell["dashed "]},
          {Cell[TextData[{
              StyleBox["Dashing[{0.01,", "MR"],
              " ",
              StyleBox["0.05,", "MR"],
              " ",
              StyleBox["0.05,", "MR"],
              " ",
              StyleBox["0.05}]", "MR"],
              " "
            }]], Cell["dot\[Hyphen]dashed "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.3"],

Cell["Some typical styles. ", "Caption",
  CellTags->"S2.10.3"],

Cell[TextData[{
  "The various \[OpenCurlyDoubleQuote]style options\[CloseCurlyDoubleQuote] \
allow you to specify how particular graphical elements in a plot should be \
rendered. ",
  StyleBox["Mathematica", "TI"],
  " also provides options that affect the rendering of the whole plot. "
}], "Text",
  CellTags->{"S2.10.3", "3.23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Background", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["color", "TI"],
              " "
            }]], Cell["specify the background color for a plot "]},
          {Cell[TextData[{
              StyleBox["DefaultColor", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["color", "TI"],
              " "
            }]], Cell["specify the default color for a plot "]},
          {Cell[TextData[{
              StyleBox["Prolog", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["g", "TI"],
              " "
            }]], Cell["give graphics to render before a plot is started "]},
          {Cell[TextData[{
              StyleBox["Epilog", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["g", "TI"],
              " "
            }]], Cell["give graphics to render after a plot is finished "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.3"],

Cell["Graphics options that affect whole plots. ", "Caption",
  CellTags->"S2.10.3"],

Cell["This draws the whole plot on a gray background. ", "MathCaption",
  CellTags->{"S2.10.3", "3.24"}],

Cell[CellGroupData[{

Cell["Plot[Sin[Sin[x]], {x, 0, 10}, Background -> GrayLevel[0.6]]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.6 g
MFill
% Scaling calculations
0.0238095 0.0952381 0.309017 0.349749 [
[.21429 .29652 -3 -9 ]
[.21429 .29652 3 0 ]
[.40476 .29652 -3 -9 ]
[.40476 .29652 3 0 ]
[.59524 .29652 -3 -9 ]
[.59524 .29652 3 0 ]
[.78571 .29652 -3 -9 ]
[.78571 .29652 3 0 ]
[.97619 .29652 -6 -9 ]
[.97619 .29652 6 0 ]
[.01131 .04671 -30 -4.5 ]
[.01131 .04671 0 4.5 ]
[.01131 .13414 -24 -4.5 ]
[.01131 .13414 0 4.5 ]
[.01131 .22158 -30 -4.5 ]
[.01131 .22158 0 4.5 ]
[.01131 .39645 -24 -4.5 ]
[.01131 .39645 0 4.5 ]
[.01131 .48389 -18 -4.5 ]
[.01131 .48389 0 4.5 ]
[.01131 .57133 -24 -4.5 ]
[.01131 .57133 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(10)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .04671 m
.03006 .04671 L
s
[(-0.75)] .01131 .04671 1 0 Mshowa
.02381 .13414 m
.03006 .13414 L
s
[(-0.5)] .01131 .13414 1 0 Mshowa
.02381 .22158 m
.03006 .22158 L
s
[(-0.25)] .01131 .22158 1 0 Mshowa
.02381 .39645 m
.03006 .39645 L
s
[(0.25)] .01131 .39645 1 0 Mshowa
.02381 .48389 m
.03006 .48389 L
s
[(0.5)] .01131 .48389 1 0 Mshowa
.02381 .57133 m
.03006 .57133 L
s
[(0.75)] .01131 .57133 1 0 Mshowa
.125 Mabswid
.02381 .06419 m
.02756 .06419 L
s
.02381 .08168 m
.02756 .08168 L
s
.02381 .09917 m
.02756 .09917 L
s
.02381 .11666 m
.02756 .11666 L
s
.02381 .15163 m
.02756 .15163 L
s
.02381 .16912 m
.02756 .16912 L
s
.02381 .1866 m
.02756 .1866 L
s
.02381 .20409 m
.02756 .20409 L
s
.02381 .23907 m
.02756 .23907 L
s
.02381 .25655 m
.02756 .25655 L
s
.02381 .27404 m
.02756 .27404 L
s
.02381 .29153 m
.02756 .29153 L
s
.02381 .3265 m
.02756 .3265 L
s
.02381 .34399 m
.02756 .34399 L
s
.02381 .36148 m
.02756 .36148 L
s
.02381 .37897 m
.02756 .37897 L
s
.02381 .41394 m
.02756 .41394 L
s
.02381 .43143 m
.02756 .43143 L
s
.02381 .44892 m
.02756 .44892 L
s
.02381 .4664 m
.02756 .4664 L
s
.02381 .50138 m
.02756 .50138 L
s
.02381 .51887 m
.02756 .51887 L
s
.02381 .53635 m
.02756 .53635 L
s
.02381 .55384 m
.02756 .55384 L
s
.02381 .02922 m
.02756 .02922 L
s
.02381 .01173 m
.02756 .01173 L
s
.02381 .58882 m
.02756 .58882 L
s
.02381 .6063 m
.02756 .6063 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .44348 L
.08255 .50023 L
.0932 .52505 L
.10458 .54742 L
.11531 .56464 L
.12507 .57722 L
.13488 .58712 L
.14415 .59415 L
.14877 .59687 L
.15385 .59928 L
.1564 .60028 L
.15915 .60119 L
.16153 .60184 L
.16413 .60242 L
.16536 .60264 L
.16669 .60285 L
.16783 .603 L
.16906 .60312 L
.17033 .60322 L
.17152 .60328 L
.17269 .60331 L
.17376 .60332 L
.17481 .6033 L
.1758 .60326 L
.17688 .60319 L
.17804 .6031 L
.17926 .60296 L
.18041 .60281 L
.18257 .60244 L
.18493 .60193 L
.18715 .60134 L
.19222 .59959 L
.19715 .59734 L
.20248 .59428 L
.21208 .587 L
.2209 .57819 L
.23982 .55163 L
.25054 .53153 L
.26052 .50939 L
.29956 .3934 L
.34106 .2435 L
.36186 .17386 L
.38104 .11959 L
.39973 .07808 L
.40927 .06135 L
.41951 .04659 L
.42974 .03496 L
.43908 .02685 L
.44358 .02373 L
Mistroke
.44848 .02089 L
.45277 .01887 L
.4574 .01714 L
.46018 .01633 L
.46273 .01573 L
.46517 .01529 L
.46641 .01511 L
.46774 .01496 L
.46895 .01485 L
.47006 .01478 L
.47116 .01474 L
.47221 .01472 L
.47343 .01472 L
.47456 .01475 L
.4758 .01482 L
.47711 .01492 L
.4784 .01506 L
.47959 .01522 L
.48226 .01569 L
.48462 .01622 L
.48709 .01691 L
.49235 .01883 L
.4981 .02163 L
.5084 .0286 L
.51774 .03729 L
.52854 .05034 L
.53871 .06588 L
.55876 .10637 L
.57723 .15534 L
.61668 .28875 L
.65462 .42361 L
.67574 .48672 L
.69501 .53222 L
.70457 .55021 L
.71497 .56643 L
.72472 .57864 L
.73389 .58766 L
.74327 .59461 L
.74826 .59744 L
.75364 .59984 L
.75897 .60159 L
.76166 .60224 L
.76319 .60255 L
.76459 .60278 L
.7658 .60294 L
.76711 .60309 L
.76783 .60315 L
.76849 .60321 L
.7698 .60328 L
.77091 .60331 L
Mistroke
.77215 .60332 L
.77343 .60329 L
.77464 .60324 L
.77589 .60315 L
.77722 .60301 L
.77961 .60268 L
.78245 .60214 L
.78503 .60149 L
.79012 .59979 L
.7949 .59767 L
.80381 .5923 L
.81343 .58428 L
.82295 .5739 L
.83339 .55946 L
.85446 .51971 L
.87398 .4698 L
.8949 .40391 L
.93628 .25484 L
.97615 .12811 L
.97619 .12799 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.10.3"]
}, Open  ]],

Cell["This makes the default color white. ", "MathCaption",
  CellTags->{"S2.10.3", "3.25"}],

Cell[CellGroupData[{

Cell["Show[%, DefaultColor -> GrayLevel[1]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.10.3"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
.6 g
MFill
% Scaling calculations
0.0238095 0.0952381 0.309017 0.349749 [
[.21429 .29652 -3 -9 ]
[.21429 .29652 3 0 ]
[.40476 .29652 -3 -9 ]
[.40476 .29652 3 0 ]
[.59524 .29652 -3 -9 ]
[.59524 .29652 3 0 ]
[.78571 .29652 -3 -9 ]
[.78571 .29652 3 0 ]
[.97619 .29652 -6 -9 ]
[.97619 .29652 6 0 ]
[.01131 .04671 -30 -4.5 ]
[.01131 .04671 0 4.5 ]
[.01131 .13414 -24 -4.5 ]
[.01131 .13414 0 4.5 ]
[.01131 .22158 -30 -4.5 ]
[.01131 .22158 0 4.5 ]
[.01131 .39645 -24 -4.5 ]
[.01131 .39645 0 4.5 ]
[.01131 .48389 -18 -4.5 ]
[.01131 .48389 0 4.5 ]
[.01131 .57133 -24 -4.5 ]
[.01131 .57133 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 g
.25 Mabswid
[ ] 0 setdash
.21429 .30902 m
.21429 .31527 L
s
[(2)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(4)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(6)] .59524 .29652 0 1 Mshowa
.78571 .30902 m
.78571 .31527 L
s
[(8)] .78571 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(10)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.5 .30902 m
.5 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .04671 m
.03006 .04671 L
s
[(-0.75)] .01131 .04671 1 0 Mshowa
.02381 .13414 m
.03006 .13414 L
s
[(-0.5)] .01131 .13414 1 0 Mshowa
.02381 .22158 m
.03006 .22158 L
s
[(-0.25)] .01131 .22158 1 0 Mshowa
.02381 .39645 m
.03006 .39645 L
s
[(0.25)] .01131 .39645 1 0 Mshowa
.02381 .48389 m
.03006 .48389 L
s
[(0.5)] .01131 .48389 1 0 Mshowa
.02381 .57133 m
.03006 .57133 L
s
[(0.75)] .01131 .57133 1 0 Mshowa
.125 Mabswid
.02381 .06419 m
.02756 .06419 L
s
.02381 .08168 m
.02756 .08168 L
s
.02381 .09917 m
.02756 .09917 L
s
.02381 .11666 m
.02756 .11666 L
s
.02381 .15163 m
.02756 .15163 L
s
.02381 .16912 m
.02756 .16912 L
s
.02381 .1866 m
.02756 .1866 L
s
.02381 .20409 m
.02756 .20409 L
s
.02381 .23907 m
.02756 .23907 L
s
.02381 .25655 m
.02756 .25655 L
s
.02381 .27404 m
.02756 .27404 L
s
.02381 .29153 m
.02756 .29153 L
s
.02381 .3265 m
.02756 .3265 L
s
.02381 .34399 m
.02756 .34399 L
s
.02381 .36148 m
.02756 .36148 L
s
.02381 .37897 m
.02756 .37897 L
s
.02381 .41394 m
.02756 .41394 L
s
.02381 .43143 m
.02756 .43143 L
s
.02381 .44892 m
.02756 .44892 L
s
.02381 .4664 m
.02756 .4664 L
s
.02381 .50138 m
.02756 .50138 L
s
.02381 .51887 m
.02756 .51887 L
s
.02381 .53635 m
.02756 .53635 L
s
.02381 .55384 m
.02756 .55384 L
s
.02381 .02922 m
.02756 .02922 L
s
.02381 .01173 m
.02756 .01173 L
s
.02381 .58882 m
.02756 .58882 L
s
.02381 .6063 m
.02756 .6063 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .44348 L
.08255 .50023 L
.0932 .52505 L
.10458 .54742 L
.11531 .56464 L
.12507 .57722 L
.13488 .58712 L
.14415 .59415 L
.14877 .59687 L
.15385 .59928 L
.1564 .60028 L
.15915 .60119 L
.16153 .60184 L
.16413 .60242 L
.16536 .60264 L
.16669 .60285 L
.16783 .603 L
.16906 .60312 L
.17033 .60322 L
.17152 .60328 L
.17269 .60331 L
.17376 .60332 L
.17481 .6033 L
.1758 .60326 L
.17688 .60319 L
.17804 .6031 L
.17926 .60296 L
.18041 .60281 L
.18257 .60244 L
.18493 .60193 L
.18715 .60134 L
.19222 .59959 L
.19715 .59734 L
.20248 .59428 L
.21208 .587 L
.2209 .57819 L
.23982 .55163 L
.25054 .53153 L
.26052 .50939 L
.29956 .3934 L
.34106 .2435 L
.36186 .17386 L
.38104 .11959 L
.39973 .07808 L
.40927 .06135 L
.41951 .04659 L
.42974 .03496 L
.43908 .02685 L
.44358 .02373 L
Mistroke
.44848 .02089 L
.45277 .01887 L
.4574 .01714 L
.46018 .01633 L
.46273 .01573 L
.46517 .01529 L
.46641 .01511 L
.46774 .01496 L
.46895 .01485 L
.47006 .01478 L
.47116 .01474 L
.47221 .01472 L
.47343 .01472 L
.47456 .01475 L
.4758 .01482 L
.47711 .01492 L
.4784 .01506 L
.47959 .01522 L
.48226 .01569 L
.48462 .01622 L
.48709 .01691 L
.49235 .01883 L
.4981 .02163 L
.5084 .0286 L
.51774 .03729 L
.52854 .05034 L
.53871 .06588 L
.55876 .10637 L
.57723 .15534 L
.61668 .28875 L
.65462 .42361 L
.67574 .48672 L
.69501 .53222 L
.70457 .55021 L
.71497 .56643 L
.72472 .57864 L
.73389 .58766 L
.74327 .59461 L
.74826 .59744 L
.75364 .59984 L
.75897 .60159 L
.76166 .60224 L
.76319 .60255 L
.76459 .60278 L
.7658 .60294 L
.76711 .60309 L
.76783 .60315 L
.76849 .60321 L
.7698 .60328 L
.77091 .60331 L
Mistroke
.77215 .60332 L
.77343 .60329 L
.77464 .60324 L
.77589 .60315 L
.77722 .60301 L
.77961 .60268 L
.78245 .60214 L
.78503 .60149 L
.79012 .59979 L
.7949 .59767 L
.80381 .5923 L
.81343 .58428 L
.82295 .5739 L
.83339 .55946 L
.85446 .51971 L
.87398 .4698 L
.8949 .40391 L
.93628 .25484 L
.97615 .12811 L
.97619 .12799 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.3"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.10.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.10.4 Coordinate Systems for Two\[Hyphen]Dimensional \
Graphics\
\>", "Subsection",
  CellTags->{"S2.10.4", "4.1"}],

Cell[TextData[{
  "When you set up a graphics object in ",
  StyleBox["Mathematica", "TI"],
  ", you give coordinates for the various graphical elements that appear. \
When ",
  StyleBox["Mathematica", "TI"],
  " renders the graphics object, it has to translate the original coordinates \
you gave into \[OpenCurlyDoubleQuote]display coordinates\
\[CloseCurlyDoubleQuote] which specify where each element should be placed in \
the final display area. "
}], "Text",
  CellTags->{"S2.10.4", "4.2"}],

Cell[TextData[{
  "Sometimes, you may find it convenient to specify the display coordinates \
for a graphical element directly. You can do this by using \
\[OpenCurlyDoubleQuote]scaled coordinates\[CloseCurlyDoubleQuote] ",
  StyleBox["Scaled[{", "MR"],
  StyleBox["sx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["sy", "TI"],
  StyleBox["}]", "MR"],
  " rather than ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}", "MR"],
  ". The scaled coordinates are defined to run from 0 to 1 in ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", with the origin taken to be at the lower\[Hyphen]left corner of the \
display area."
}], "Text",
  CellTags->{"S2.10.4", "4.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["original coordinates "]},
          {Cell[TextData[{
              StyleBox["Scaled[{", "MR"],
              StyleBox["sx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sy", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["scaled coordinates "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.4"],

Cell["\<\
Coordinate systems for two\[Hyphen]dimensional graphics. \
\>", \
"Caption",
  CellTags->"S2.10.4"],

Cell["\<\
The rectangle is drawn at a fixed position relative to the display \
area, independent of the original coordinates used for the plot. \
\>", \
"MathCaption",
  CellTags->{"S2.10.4", "4.4"}],

Cell[CellGroupData[{

Cell["\<\
Plot[Tan[x], {x, 0, 2Pi}, Prolog -> Rectangle[Scaled[{0.7, 0.7}], \
Scaled[{1, 1}]]]\
\>", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.304543 0.00648486 [
[.17539 .29204 -3 -9 ]
[.17539 .29204 3 0 ]
[.32696 .29204 -3 -9 ]
[.32696 .29204 3 0 ]
[.47854 .29204 -3 -9 ]
[.47854 .29204 3 0 ]
[.63011 .29204 -3 -9 ]
[.63011 .29204 3 0 ]
[.78169 .29204 -3 -9 ]
[.78169 .29204 3 0 ]
[.93327 .29204 -3 -9 ]
[.93327 .29204 3 0 ]
[.01131 .04515 -18 -4.5 ]
[.01131 .04515 0 4.5 ]
[.01131 .17485 -18 -4.5 ]
[.01131 .17485 0 4.5 ]
[.01131 .43424 -12 -4.5 ]
[.01131 .43424 0 4.5 ]
[.01131 .56394 -12 -4.5 ]
[.01131 .56394 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30454 m
.17539 .31079 L
s
[(1)] .17539 .29204 0 1 Mshowa
.32696 .30454 m
.32696 .31079 L
s
[(2)] .32696 .29204 0 1 Mshowa
.47854 .30454 m
.47854 .31079 L
s
[(3)] .47854 .29204 0 1 Mshowa
.63011 .30454 m
.63011 .31079 L
s
[(4)] .63011 .29204 0 1 Mshowa
.78169 .30454 m
.78169 .31079 L
s
[(5)] .78169 .29204 0 1 Mshowa
.93327 .30454 m
.93327 .31079 L
s
[(6)] .93327 .29204 0 1 Mshowa
.125 Mabswid
.05412 .30454 m
.05412 .30829 L
s
.08444 .30454 m
.08444 .30829 L
s
.11476 .30454 m
.11476 .30829 L
s
.14507 .30454 m
.14507 .30829 L
s
.2057 .30454 m
.2057 .30829 L
s
.23602 .30454 m
.23602 .30829 L
s
.26633 .30454 m
.26633 .30829 L
s
.29665 .30454 m
.29665 .30829 L
s
.35728 .30454 m
.35728 .30829 L
s
.38759 .30454 m
.38759 .30829 L
s
.41791 .30454 m
.41791 .30829 L
s
.44822 .30454 m
.44822 .30829 L
s
.50885 .30454 m
.50885 .30829 L
s
.53917 .30454 m
.53917 .30829 L
s
.56948 .30454 m
.56948 .30829 L
s
.5998 .30454 m
.5998 .30829 L
s
.66043 .30454 m
.66043 .30829 L
s
.69074 .30454 m
.69074 .30829 L
s
.72106 .30454 m
.72106 .30829 L
s
.75138 .30454 m
.75138 .30829 L
s
.81201 .30454 m
.81201 .30829 L
s
.84232 .30454 m
.84232 .30829 L
s
.87264 .30454 m
.87264 .30829 L
s
.90295 .30454 m
.90295 .30829 L
s
.96358 .30454 m
.96358 .30829 L
s
.9939 .30454 m
.9939 .30829 L
s
.25 Mabswid
0 .30454 m
1 .30454 L
s
.02381 .04515 m
.03006 .04515 L
s
[(-40)] .01131 .04515 1 0 Mshowa
.02381 .17485 m
.03006 .17485 L
s
[(-20)] .01131 .17485 1 0 Mshowa
.02381 .43424 m
.03006 .43424 L
s
[(20)] .01131 .43424 1 0 Mshowa
.02381 .56394 m
.03006 .56394 L
s
[(40)] .01131 .56394 1 0 Mshowa
.125 Mabswid
.02381 .07757 m
.02756 .07757 L
s
.02381 .11 m
.02756 .11 L
s
.02381 .14242 m
.02756 .14242 L
s
.02381 .20727 m
.02756 .20727 L
s
.02381 .23969 m
.02756 .23969 L
s
.02381 .27212 m
.02756 .27212 L
s
.02381 .33697 m
.02756 .33697 L
s
.02381 .36939 m
.02756 .36939 L
s
.02381 .40182 m
.02756 .40182 L
s
.02381 .46666 m
.02756 .46666 L
s
.02381 .49909 m
.02756 .49909 L
s
.02381 .53151 m
.02756 .53151 L
s
.02381 .01272 m
.02756 .01272 L
s
.02381 .59636 m
.02756 .59636 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.7 .43262 m
.7 .61803 L
1 .61803 L
1 .43262 L
F
.5 Mabswid
.02381 .30454 m
.06244 .30623 L
.10458 .30837 L
.12507 .30966 L
.14415 .31114 L
.16254 .31298 L
.18221 .31572 L
.19242 .31769 L
.19781 .31895 L
.20351 .32054 L
.2085 .32218 L
.21399 .32437 L
.21861 .32663 L
.22365 .32969 L
.22885 .33381 L
.23379 .3391 L
.23612 .34229 L
.2386 .34638 L
.24092 .35109 L
.24306 .35644 L
.24577 .36524 L
.2472 .37116 L
.2487 .3788 L
.24992 .38641 L
.25123 .3965 L
.25267 .41086 L
.25401 .42898 L
.25529 .45305 L
.25601 .47126 L
.25668 .49259 L
.2579 .55021 L
s
.2579 .55021 m
.25865 .61803 L
s
.2621 .61803 m
.26231 0 L
s
.26516 0 m
.2652 .00603 L
.26634 .0829 L
.26766 .1337 L
.2689 .16411 L
.27005 .18399 L
.27111 .19792 L
.27228 .20994 L
.27351 .22003 L
.27475 .22823 L
.27609 .23544 L
.2785 .24554 L
.28136 .25431 L
.28398 .26033 L
.28916 .26887 L
.29209 .27241 L
.29481 .27514 L
.30016 .2794 L
.30508 .2824 L
.31017 .28487 L
.31568 .28704 L
.32564 .29004 L
.3347 .2921 L
.34426 .29381 L
.36394 .29641 L
.38229 .29817 L
.42125 .30083 L
.46266 .30291 L
.50256 .30465 L
.54094 .30634 L
.58177 .30843 L
.60207 .30972 L
.62109 .31121 L
.6393 .31304 L
.6589 .3158 L
.66849 .31766 L
.67898 .32032 L
.68427 .32203 L
.68992 .32425 L
.69486 .32666 L
.70009 .32986 L
.70543 .33417 L
.71036 .33958 L
.7131 .3435 L
.71565 .34803 L
.71846 .35433 L
.72147 .36345 L
.72407 .3744 L
.72553 .38259 L
.72689 .39208 L
Mistroke
.72807 .40243 L
.72937 .41712 L
.73003 .42629 L
.73074 .43801 L
.73202 .46618 L
.73318 .5046 L
.73446 .5749 L
Mfstroke
.73446 .5749 m
.73494 .61803 L
s
.73715 .61803 m
.73727 0 L
s
.7414 0 m
.74164 .02714 L
.74287 .09859 L
.74399 .13786 L
.74529 .16795 L
.74652 .18796 L
.74765 .20182 L
.7487 .21203 L
.75109 .22907 L
.75245 .23626 L
.75373 .24189 L
.75612 .25028 L
.7587 .25714 L
.76149 .26286 L
.76682 .27073 L
.7695 .2737 L
.77245 .27642 L
.77728 .28002 L
.78252 .28306 L
.78777 .28547 L
.79274 .28734 L
.80205 .2901 L
.81292 .29249 L
.82297 .2942 L
.84165 .29658 L
.86225 .29848 L
.90248 .30112 L
.94119 .30302 L
.97619 .30454 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "When you use ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}", "MR"],
  " or ",
  StyleBox["Scaled[{", "MR"],
  StyleBox["sx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["sy", "TI"],
  StyleBox["}]", "MR"],
  ", you are specifying position either completely in original coordinates, \
or completely in scaled coordinates. Sometimes, however, you may need to use \
a combination of these coordinate systems. For example, if you want to draw a \
line at a particular point whose length is a definite fraction of the width \
of the plot, you will have to use original coordinates to specify the basic \
position of the line, and scaled coordinates to specify its length. "
}], "Text",
  CellTags->{"S2.10.4", "4.5"}],

Cell[TextData[{
  "You can use ",
  StyleBox["Scaled[{", "MR"],
  StyleBox["dsx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["dsy", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}]", "MR"],
  " to specify a position using a mixture of original and scaled coordinates. \
In this case, ",
  StyleBox["{", "MR"],
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["y", "TI"],
  StyleBox["}", "MR"],
  " gives a position in original coordinates, and ",
  StyleBox["{", "MR"],
  StyleBox["dsx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["dsy", "TI"],
  StyleBox["}", "MR"],
  " gives the offset from the position in scaled coordinates."
}], "Text",
  CellTags->{"S2.10.4", "4.6"}],

Cell[TextData[{
  "Note that you can use ",
  StyleBox["Scaled", "MR"],
  " with either one or two arguments to specify radii in ",
  StyleBox["Disk", "MR"],
  " and ",
  StyleBox["Circle", "MR"],
  " graphics elements. "
}], "Text",
  CellTags->{"S2.10.4", "4.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Scaled[{", "MR"],
              StyleBox["sdx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sdy", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["scaled offset from original coordinates "]},
          {Cell[TextData[{
              StyleBox["Offset[{", "MR"],
              StyleBox["adx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ady", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["absolute offset from original coordinates "]},
          {Cell[TextData[{
              StyleBox["Offset[{", "MR"],
              StyleBox["adx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ady", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["Scaled[{", "MR"],
              StyleBox["sx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sy", "TI"],
              StyleBox["}]]", "MR"],
              " "
            }]], Cell["absolute offset from scaled coordinates "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.4"],

Cell["Positions specified as offsets. ", "Caption",
  CellTags->"S2.10.4"],

Cell["\<\
Each line drawn here has an absolute length of 6 printer's points. \
\
\>", "MathCaption",
  CellTags->{"S2.10.4", "4.8"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[Table[ Line[{{x, x^2}, Offset[{0, 6}, {x, x^2}]}], \
{x, 10}], Frame->True]]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.00588604 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13244 -12 -4.5 ]
[-0.0125 .13244 0 4.5 ]
[-0.0125 .25016 -12 -4.5 ]
[-0.0125 .25016 0 4.5 ]
[-0.0125 .36788 -12 -4.5 ]
[-0.0125 .36788 0 4.5 ]
[-0.0125 .4856 -12 -4.5 ]
[-0.0125 .4856 0 4.5 ]
[-0.0125 .60332 -18 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13244 m
.00625 .13244 L
s
[(20)] -0.0125 .13244 1 0 Mshowa
0 .25016 m
.00625 .25016 L
s
[(40)] -0.0125 .25016 1 0 Mshowa
0 .36788 m
.00625 .36788 L
s
[(60)] -0.0125 .36788 1 0 Mshowa
0 .4856 m
.00625 .4856 L
s
[(80)] -0.0125 .4856 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(100)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04415 m
.00375 .04415 L
s
0 .07358 m
.00375 .07358 L
s
0 .10301 m
.00375 .10301 L
s
0 .16187 m
.00375 .16187 L
s
0 .1913 m
.00375 .1913 L
s
0 .22073 m
.00375 .22073 L
s
0 .27959 m
.00375 .27959 L
s
0 .30902 m
.00375 .30902 L
s
0 .33845 m
.00375 .33845 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .45617 m
.00375 .45617 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .13244 m
1 .13244 L
s
.99375 .25016 m
1 .25016 L
s
.99375 .36788 m
1 .36788 L
s
.99375 .4856 m
1 .4856 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04415 m
1 .04415 L
s
.99625 .07358 m
1 .07358 L
s
.99625 .10301 m
1 .10301 L
s
.99625 .16187 m
1 .16187 L
s
.99625 .1913 m
1 .1913 L
s
.99625 .22073 m
1 .22073 L
s
.99625 .27959 m
1 .27959 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .45617 m
1 .45617 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .0206 m
.11905 .0206 0 6 Mabsadd L s
.21429 .03826 m
.21429 .03826 0 6 Mabsadd L s
.30952 .06769 m
.30952 .06769 0 6 Mabsadd L s
.40476 .10889 m
.40476 .10889 0 6 Mabsadd L s
.5 .16187 m
.5 .16187 0 6 Mabsadd L s
.59524 .22661 m
.59524 .22661 0 6 Mabsadd L s
.69048 .30313 m
.69048 .30313 0 6 Mabsadd L s
.78571 .39142 m
.78571 .39142 0 6 Mabsadd L s
.88095 .49148 m
.88095 .49148 0 6 Mabsadd L s
.97619 .60332 m
.97619 .60332 0 6 Mabsadd L s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "You can also use ",
  StyleBox["Offset", "MR"],
  " inside ",
  StyleBox["Circle", "MR"],
  " with just one argument to create a circle with a certain absolute radius. \
"
}], "MathCaption",
  CellTags->{"S2.10.4", "4.9"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[Table[ Circle[{x, x^2}, Offset[{2, 2}]], {x, 10}], \
Frame->True]]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.00588604 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13244 -12 -4.5 ]
[-0.0125 .13244 0 4.5 ]
[-0.0125 .25016 -12 -4.5 ]
[-0.0125 .25016 0 4.5 ]
[-0.0125 .36788 -12 -4.5 ]
[-0.0125 .36788 0 4.5 ]
[-0.0125 .4856 -12 -4.5 ]
[-0.0125 .4856 0 4.5 ]
[-0.0125 .60332 -18 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13244 m
.00625 .13244 L
s
[(20)] -0.0125 .13244 1 0 Mshowa
0 .25016 m
.00625 .25016 L
s
[(40)] -0.0125 .25016 1 0 Mshowa
0 .36788 m
.00625 .36788 L
s
[(60)] -0.0125 .36788 1 0 Mshowa
0 .4856 m
.00625 .4856 L
s
[(80)] -0.0125 .4856 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(100)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .04415 m
.00375 .04415 L
s
0 .07358 m
.00375 .07358 L
s
0 .10301 m
.00375 .10301 L
s
0 .16187 m
.00375 .16187 L
s
0 .1913 m
.00375 .1913 L
s
0 .22073 m
.00375 .22073 L
s
0 .27959 m
.00375 .27959 L
s
0 .30902 m
.00375 .30902 L
s
0 .33845 m
.00375 .33845 L
s
0 .39731 m
.00375 .39731 L
s
0 .42674 m
.00375 .42674 L
s
0 .45617 m
.00375 .45617 L
s
0 .51503 m
.00375 .51503 L
s
0 .54446 m
.00375 .54446 L
s
0 .57389 m
.00375 .57389 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .13244 m
1 .13244 L
s
.99375 .25016 m
1 .25016 L
s
.99375 .36788 m
1 .36788 L
s
.99375 .4856 m
1 .4856 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .04415 m
1 .04415 L
s
.99625 .07358 m
1 .07358 L
s
.99625 .10301 m
1 .10301 L
s
.99625 .16187 m
1 .16187 L
s
.99625 .1913 m
1 .1913 L
s
.99625 .22073 m
1 .22073 L
s
.99625 .27959 m
1 .27959 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .33845 m
1 .33845 L
s
.99625 .39731 m
1 .39731 L
s
.99625 .42674 m
1 .42674 L
s
.99625 .45617 m
1 .45617 L
s
.99625 .51503 m
1 .51503 L
s
.99625 .54446 m
1 .54446 L
s
.99625 .57389 m
1 .57389 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
newpath
.11905 .0206 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.21429 .03826 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.30952 .06769 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.40476 .10889 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.5 .16187 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.59524 .22661 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.69048 .30313 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.78571 .39142 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.88095 .49148 0 0 2 2 Mabsadd pop 0 365.73 arc
s
newpath
.97619 .60332 0 0 2 2 Mabsadd pop 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell["\<\
In most kinds of graphics, you typically want the relative \
positions of different objects to adjust automatically when you change the \
coordinates or the overall size of your plot. But sometimes you may instead \
want the offset from one object to another to be constrained to remain fixed. \
This can be the case, for example, when you are making a collection of plots \
in which you want certain features to remain consistent, even though the \
different plots have different forms.   \
\>", "Text",
  CellTags->{"S2.10.4", "4.10"}],

Cell[TextData[{
  StyleBox["Offset[{", "MR"],
  StyleBox["adx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["ady", "TI"],
  StyleBox["},", "MR"],
  " ",
  StyleBox["position", "TI"],
  StyleBox["]", "MR"],
  " allows you to specify the position of an object by giving an absolute \
offset from a position that is specified in original or scaled coordinates. \
The units for the offset are printer's points, equal to ",
  Cell[BoxData[
      \(TraditionalForm\`1\/72\)], "InlineFormula"],
  " of an inch.  "
}], "Text",
  CellTags->{"S2.10.4", "4.11"}],

Cell[TextData[{
  "When you give text in a plot, the size of the font that is used is also \
specified in printer's points. A 10\[Hyphen]point font, for example, \
therefore has letters whose basic height is 10 printer's points. You can use \
",
  StyleBox["Offset", "MR"],
  " to move text around in a plot, and to create plotting symbols or icons \
which match the size of text.   "
}], "Text",
  CellTags->{"S2.10.4", "4.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["PlotRange", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}}", "MR"],
              " "
            }]], Cell[
            "the range of original coordinates to include in the plot "]},
          {Cell[TextData[{
              StyleBox["PlotRegion", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sx",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sx",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sy",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["sy",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}}", "MR"],
              " "
            }]], 
            Cell["\<\
the region of the display specified in scaled \
coordinates which the plot fills \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.4"],

Cell["\<\
Options which determine translation from original to display \
coordinates. \
\>", "Caption",
  CellTags->"S2.10.4"],

Cell[TextData[{
  "When ",
  StyleBox["Mathematica", "TI"],
  " renders a graphics object, one of the first things it has to do is to \
work out what range of original ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " coordinates it should actually display. Any graphical elements that are \
outside this range will be \[OpenCurlyDoubleQuote]clipped\
\[CloseCurlyDoubleQuote], and not shown. "
}], "Text",
  CellTags->{"S2.10.4", "4.13"}],

Cell[TextData[{
  "The option ",
  StyleBox["PlotRange", "MR"],
  " specifies the range of original coordinates to include. As discussed in \
Section\[NonBreakingSpace]",
  ButtonBox["1.9.2",
    ButtonData:>{"1.9.2", "2.11"},
    ButtonStyle->"MainBookLink"],
  ", the default setting is ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", which makes ",
  StyleBox["Mathematica", "TI"],
  " try to choose a range which includes all \
\[OpenCurlyDoubleQuote]interesting\[CloseCurlyDoubleQuote] parts of a plot, \
while dropping \[OpenCurlyDoubleQuote]outliers\[CloseCurlyDoubleQuote]. By \
setting ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", you can tell ",
  StyleBox["Mathematica", "TI"],
  " to include everything. You can also give explicit ranges of coordinates \
to include. "
}], "Text",
  CellTags->{"S2.10.4", "4.14"}],

Cell[TextData[{
  "This sets up a polygonal object whose corners have coordinates between \
roughly ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]1\)\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.4", "4.15"}],

Cell["\<\
obj = Polygon[ Table[{Sin[n Pi/10], Cos[n Pi/10]} + 0.05 (-1)^n, \
{n, 20}]] ;\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.4"],

Cell["\<\
In this case, the polygonal object fills almost the whole display \
area. \
\>", "MathCaption",
  CellTags->{"S2.10.4", "4.16"}],

Cell[CellGroupData[{

Cell["Show[Graphics[obj]]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.511363 0.464337 0.301994 0.286976 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.63163 .56058 m
.80751 .54851 L
.8638 .45633 L
.97619 .40502 L
.95248 .28765 L
.97619 .22766 L
.8638 .11897 L
.80751 .08417 L
.63163 .01472 L
.53458 .02937 L
.34466 .01472 L
.26165 .08417 L
.11249 .11897 L
.09297 .22766 L
.02381 .28765 L
.09297 .40502 L
.11249 .45633 L
.26165 .54851 L
.34466 .56058 L
.53458 .60332 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "With the default ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", the outlying point is not included, but does affect the range of \
coordinates chosen. "
}], "MathCaption",
  CellTags->{"S2.10.4", "4.17"}],

Cell[CellGroupData[{

Cell["Show[ Graphics[{obj, Point[{20, 20}]}] ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.235965 0.202053 0.148867 0.13401 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
.2883 .26962 m
.36483 .26398 L
.38933 .22094 L
.43823 .19698 L
.42792 .14217 L
.43823 .11416 L
.38933 .0634 L
.36483 .04715 L
.2883 .01472 L
.24607 .02156 L
.16342 .01472 L
.1273 .04715 L
.0624 .0634 L
.0539 .11416 L
.02381 .14217 L
.0539 .19698 L
.0624 .22094 L
.1273 .26398 L
.16342 .26962 L
.24607 .28958 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", the outlying point is included, and the coordinate system is \
correspondingly modified. "
}], "MathCaption",
  CellTags->{"S2.10.4", "4.18"}],

Cell[CellGroupData[{

Cell["Show[%, PlotRange -> All]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0713155 0.0452438 0.042772 0.0280273 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.08303 .06803 m
.10017 .06685 L
.10566 .05784 L
.11661 .05283 L
.1143 .04137 L
.11661 .03551 L
.10566 .0249 L
.10017 .0215 L
.08303 .01472 L
.07358 .01615 L
.05507 .01472 L
.04698 .0215 L
.03245 .0249 L
.03055 .03551 L
.02381 .04137 L
.03055 .05283 L
.03245 .05784 L
.04698 .06685 L
.05507 .06803 L
.07358 .0722 L
F
.008 w
.97619 .60332 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "The option ",
  StyleBox["PlotRange", "MR"],
  " allows you to specify a rectangular region in the original coordinate \
system, and to drop any graphical elements that lie outside this region. In \
order to render the remaining elements, however, ",
  StyleBox["Mathematica", "TI"],
  " then has to determine how to position this rectangular region with \
respect to the final display area. "
}], "Text",
  CellTags->{"S2.10.4", "4.19"}],

Cell[TextData[{
  "The option ",
  StyleBox["PlotRegion", "MR"],
  " allows you to specify where the corners of the rectangular region lie \
within the final display area. The positions of the corners are specified in \
scaled coordinates, which are defined to run from 0 to 1 across the display \
area. The default is ",
  StyleBox["PlotRegion", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{{0,", "MR"],
  " ",
  StyleBox["1},", "MR"],
  " ",
  StyleBox["{0,", "MR"],
  " ",
  StyleBox["1}}", "MR"],
  ", which specifies that the rectangular region should fill the whole \
display area. "
}], "Text",
  CellTags->{"S2.10.4", "4.20"}],

Cell[TextData[{
  "By specifying ",
  StyleBox["PlotRegion", "MR"],
  ", you can effectively add \[OpenCurlyDoubleQuote]margins\
\[CloseCurlyDoubleQuote] around your plot. "
}], "MathCaption",
  CellTags->{"S2.10.4", "4.21"}],

Cell[CellGroupData[{

Cell["\<\
Plot[ArcTan[x], {x, 0, 10}, PlotRegion -> {{0.2, 0.8}, {0.3, 0.7}}]\
\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% PlotRegion
.2 .8 .3 .7 MPlotRegion
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.400104 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .09474 -18 -4.5 ]
[.01131 .09474 0 4.5 ]
[.01131 .17476 -18 -4.5 ]
[.01131 .17476 0 4.5 ]
[.01131 .25478 -18 -4.5 ]
[.01131 .25478 0 4.5 ]
[.01131 .3348 -18 -4.5 ]
[.01131 .3348 0 4.5 ]
[.01131 .41482 -6 -4.5 ]
[.01131 .41482 0 4.5 ]
[.01131 .49484 -18 -4.5 ]
[.01131 .49484 0 4.5 ]
[.01131 .57486 -18 -4.5 ]
[.01131 .57486 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09474 m
.03006 .09474 L
s
[(0.2)] .01131 .09474 1 0 Mshowa
.02381 .17476 m
.03006 .17476 L
s
[(0.4)] .01131 .17476 1 0 Mshowa
.02381 .25478 m
.03006 .25478 L
s
[(0.6)] .01131 .25478 1 0 Mshowa
.02381 .3348 m
.03006 .3348 L
s
[(0.8)] .01131 .3348 1 0 Mshowa
.02381 .41482 m
.03006 .41482 L
s
[(1)] .01131 .41482 1 0 Mshowa
.02381 .49484 m
.03006 .49484 L
s
[(1.2)] .01131 .49484 1 0 Mshowa
.02381 .57486 m
.03006 .57486 L
s
[(1.4)] .01131 .57486 1 0 Mshowa
.125 Mabswid
.02381 .03472 m
.02756 .03472 L
s
.02381 .05473 m
.02756 .05473 L
s
.02381 .07473 m
.02756 .07473 L
s
.02381 .11474 m
.02756 .11474 L
s
.02381 .13475 m
.02756 .13475 L
s
.02381 .15475 m
.02756 .15475 L
s
.02381 .19476 m
.02756 .19476 L
s
.02381 .21477 m
.02756 .21477 L
s
.02381 .23477 m
.02756 .23477 L
s
.02381 .27478 m
.02756 .27478 L
s
.02381 .29479 m
.02756 .29479 L
s
.02381 .31479 m
.02756 .31479 L
s
.02381 .3548 m
.02756 .3548 L
s
.02381 .37481 m
.02756 .37481 L
s
.02381 .39481 m
.02756 .39481 L
s
.02381 .43482 m
.02756 .43482 L
s
.02381 .45483 m
.02756 .45483 L
s
.02381 .47483 m
.02756 .47483 L
s
.02381 .51484 m
.02756 .51484 L
s
.02381 .53485 m
.02756 .53485 L
s
.02381 .55486 m
.02756 .55486 L
s
.02381 .59487 m
.02756 .59487 L
s
.02381 .61487 m
.02756 .61487 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .16891 L
.08255 .23585 L
.10458 .29614 L
.14415 .37534 L
.16372 .40408 L
.18466 .42931 L
.22611 .46715 L
.26604 .49331 L
.30445 .5123 L
.34532 .52797 L
.38467 .53995 L
.4225 .54938 L
.46279 .55772 L
.50156 .56447 L
.54279 .57058 L
.58249 .57564 L
.62069 .57989 L
.66133 .58386 L
.70046 .58725 L
.74205 .59045 L
.78211 .59321 L
.82066 .5956 L
.86167 .59791 L
.90115 .59993 L
.93912 .60172 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["AspectRatio", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["r", "TI"],
              " "
            }]], Cell[TextData[{
              
              "make the ratio of height to width for the display area equal \
to ",
              StyleBox["r", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["AspectRatio", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], 
            Cell["\<\
determine the shape of the display area from the \
original coordinate system \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.4"],

Cell["Specifying the shape of the display area. ", "Caption",
  CellTags->"S2.10.4"],

Cell[TextData[{
  "What we have discussed so far is how ",
  StyleBox["Mathematica", "TI"],
  " translates the original coordinates you specify into positions in the \
final display area. What remains to discuss, however, is what the final \
display area is like. "
}], "Text",
  CellTags->{"S2.10.4", "4.22"}],

Cell[TextData[{
  "On most computer systems, there is a certain fixed region of screen or \
paper into which the ",
  StyleBox["Mathematica", "TI"],
  " display area must fit. How it fits into this region is determined by its \
\[OpenCurlyDoubleQuote]shape\[CloseCurlyDoubleQuote] or aspect ratio. In \
general, the option ",
  StyleBox["AspectRatio", "MR"],
  " specifies the ratio of height to width for the final display area. "
}], "Text",
  CellTags->{"S2.10.4", "4.23"}],

Cell[TextData[{
  "It is important to note that the setting of ",
  StyleBox["AspectRatio", "MR"],
  " does not affect the meaning of the scaled or display coordinates. These \
coordinates always run from 0 to 1 across the display area. What ",
  StyleBox["AspectRatio", "MR"],
  " does is to change the shape of this display area. "
}], "Text",
  CellTags->{"S2.10.4", "4.24"}],

Cell["This generates a graphic object corresponding to a hexagon. ", \
"MathCaption",
  CellTags->{"S2.10.4", "4.25"}],

Cell["\<\
hex = Graphics[Polygon[ Table[{Sin[n Pi/3], Cos[n Pi/3]}, {n, 6}] \
]] ;\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.4"],

Cell["\<\
This renders the hexagon in a display area whose height is three \
times its width. \
\>", "MathCaption",
  CellTags->{"S2.10.4", "4.26"}],

Cell[CellGroupData[{

Cell["Show[hex, AspectRatio -> 3]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 3 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.549857 1.5 1.42857 [
[ 0 0 0 0 ]
[ 1 3 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 3 L
0 3 L
closepath
clip
newpath
0 g
.97619 2.21429 m
.97619 .78571 L
.5 .07143 L
.02381 .78571 L
.02381 2.21429 L
.5 2.92857 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "For two\[Hyphen]dimensional graphics, ",
  StyleBox["AspectRatio", "MR"],
  " is set by default to the fixed value of ",
  StyleBox["1/GoldenRatio", "MR"],
  ". Sometimes, however, you may want to determine the aspect ratio for a \
plot from the original coordinate system used in the plot. Typically what you \
want is for one unit in the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " direction in the original coordinate system to correspond to the same \
distance in the final display as one unit in the ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " direction. In this way, objects that you define in the original \
coordinate system are displayed with their \[OpenCurlyDoubleQuote]natural \
shape\[CloseCurlyDoubleQuote]. You can make this happen by setting the option \
",
  StyleBox["AspectRatio", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.4", "4.27"}],

Cell[TextData[{
  "With ",
  StyleBox["AspectRatio", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", the aspect ratio of the final display area is determined from the \
original coordinate system, and the hexagon is shown with its \
\[OpenCurlyDoubleQuote]natural shape\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
  CellTags->{"S2.10.4", "4.28"}],

Cell[CellGroupData[{

Cell["Show[hex, AspectRatio -> Automatic]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.4"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1547 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.549857 0.57735 0.549857 [
[ 0 0 0 0 ]
[ 1 1.1547 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1547 L
0 1.1547 L
closepath
clip
newpath
0 g
.97619 .85228 m
.97619 .30242 L
.5 .02749 L
.02381 .30242 L
.02381 .85228 L
.5 1.12721 L
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.4"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.4"]
}, Open  ]],

Cell[TextData[{
  "Using scaled coordinates, you can specify the sizes of graphical elements \
as fractions of the size of the display area. You cannot, however, tell ",
  StyleBox["Mathematica", "TI"],
  " the actual physical size at which a particular graphical element should \
be rendered. Of course, this size ultimately depends on the details of your \
graphics output device, and cannot be determined for certain within ",
  StyleBox["Mathematica", "TI"],
  ". Nevertheless, graphics directives such as ",
  StyleBox["AbsoluteThickness", "MR"],
  " discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.10.3",
    ButtonData:>{"2.10.3", "3.15"},
    ButtonStyle->"MainBookLink"],
  " do allow you to indicate \[OpenCurlyDoubleQuote]absolute sizes\
\[CloseCurlyDoubleQuote] to use for particular graphical elements. The sizes \
you request in this way will be respected by most, but not all, output \
devices. (For example, if you optically project an image, it is neither \
possible nor desirable to maintain the same absolute size for a graphical \
element within it.) "
}], "Text",
  CellTags->{"S2.10.4", "4.29"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.10.5 Labeling Two\[Hyphen]Dimensional Graphics\
\>", "Subsection",
  CellTags->{"S2.10.5", "5.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Axes", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell["give a pair of axes "]},
          {Cell[TextData[{
              StyleBox["GridLines", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["draw grid lines on the plot "]},
          {Cell[TextData[{
              StyleBox["Frame", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell["put axes on a frame around the plot "]},
          {Cell[TextData[{
              StyleBox["PlotLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["\"", "MR"],
              StyleBox["text", "TI"],
              StyleBox["\"", "MR"],
              " "
            }]], Cell["give an overall label for the plot "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.5"],

Cell["\<\
Ways to label two\[Hyphen]dimensional plots. \
\>", "Caption",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "Here is a plot, using the default ",
  StyleBox["Axes", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.2"}],

Cell[CellGroupData[{

Cell["bp = Plot[BesselJ[2, x], {x, 0, 10}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.21429 .23289 -3 -9 ]
[.21429 .23289 3 0 ]
[.40476 .23289 -3 -9 ]
[.40476 .23289 3 0 ]
[.59524 .23289 -3 -9 ]
[.59524 .23289 3 0 ]
[.78571 .23289 -3 -9 ]
[.78571 .23289 3 0 ]
[.97619 .23289 -6 -9 ]
[.97619 .23289 6 0 ]
[.01131 .09824 -24 -4.5 ]
[.01131 .09824 0 4.5 ]
[.01131 .39254 -18 -4.5 ]
[.01131 .39254 0 4.5 ]
[.01131 .53968 -18 -4.5 ]
[.01131 .53968 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .24539 m
.21429 .25164 L
s
[(2)] .21429 .23289 0 1 Mshowa
.40476 .24539 m
.40476 .25164 L
s
[(4)] .40476 .23289 0 1 Mshowa
.59524 .24539 m
.59524 .25164 L
s
[(6)] .59524 .23289 0 1 Mshowa
.78571 .24539 m
.78571 .25164 L
s
[(8)] .78571 .23289 0 1 Mshowa
.97619 .24539 m
.97619 .25164 L
s
[(10)] .97619 .23289 0 1 Mshowa
.125 Mabswid
.07143 .24539 m
.07143 .24914 L
s
.11905 .24539 m
.11905 .24914 L
s
.16667 .24539 m
.16667 .24914 L
s
.2619 .24539 m
.2619 .24914 L
s
.30952 .24539 m
.30952 .24914 L
s
.35714 .24539 m
.35714 .24914 L
s
.45238 .24539 m
.45238 .24914 L
s
.5 .24539 m
.5 .24914 L
s
.54762 .24539 m
.54762 .24914 L
s
.64286 .24539 m
.64286 .24914 L
s
.69048 .24539 m
.69048 .24914 L
s
.7381 .24539 m
.7381 .24914 L
s
.83333 .24539 m
.83333 .24914 L
s
.88095 .24539 m
.88095 .24914 L
s
.92857 .24539 m
.92857 .24914 L
s
.25 Mabswid
0 .24539 m
1 .24539 L
s
.02381 .09824 m
.03006 .09824 L
s
[(-0.2)] .01131 .09824 1 0 Mshowa
.02381 .39254 m
.03006 .39254 L
s
[(0.2)] .01131 .39254 1 0 Mshowa
.02381 .53968 m
.03006 .53968 L
s
[(0.4)] .01131 .53968 1 0 Mshowa
.125 Mabswid
.02381 .13503 m
.02756 .13503 L
s
.02381 .17182 m
.02756 .17182 L
s
.02381 .2086 m
.02756 .2086 L
s
.02381 .28218 m
.02756 .28218 L
s
.02381 .31896 m
.02756 .31896 L
s
.02381 .35575 m
.02756 .35575 L
s
.02381 .42932 m
.02756 .42932 L
s
.02381 .46611 m
.02756 .46611 L
s
.02381 .50289 m
.02756 .50289 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .02467 m
.02756 .02467 L
s
.02381 .57647 m
.02756 .57647 L
s
.02381 .61325 m
.02756 .61325 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell[TextData[{
  "Setting ",
  StyleBox["Frame", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " generates a frame with axes, and removes tick marks from the ordinary \
axes. "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.3"}],

Cell[CellGroupData[{

Cell["Show[bp, Frame -> True]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .09824 -24 -4.5 ]
[-0.0125 .09824 0 4.5 ]
[-0.0125 .24539 -6 -4.5 ]
[-0.0125 .24539 0 4.5 ]
[-0.0125 .39254 -18 -4.5 ]
[-0.0125 .39254 0 4.5 ]
[-0.0125 .53968 -18 -4.5 ]
[-0.0125 .53968 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .09824 m
.00625 .09824 L
s
[(-0.2)] -0.0125 .09824 1 0 Mshowa
0 .24539 m
.00625 .24539 L
s
[(0)] -0.0125 .24539 1 0 Mshowa
0 .39254 m
.00625 .39254 L
s
[(0.2)] -0.0125 .39254 1 0 Mshowa
0 .53968 m
.00625 .53968 L
s
[(0.4)] -0.0125 .53968 1 0 Mshowa
.125 Mabswid
0 .13503 m
.00375 .13503 L
s
0 .17182 m
.00375 .17182 L
s
0 .2086 m
.00375 .2086 L
s
0 .28218 m
.00375 .28218 L
s
0 .31896 m
.00375 .31896 L
s
0 .35575 m
.00375 .35575 L
s
0 .42932 m
.00375 .42932 L
s
0 .46611 m
.00375 .46611 L
s
0 .50289 m
.00375 .50289 L
s
0 .06146 m
.00375 .06146 L
s
0 .02467 m
.00375 .02467 L
s
0 .57647 m
.00375 .57647 L
s
0 .61325 m
.00375 .61325 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .09824 m
1 .09824 L
s
.99375 .24539 m
1 .24539 L
s
.99375 .39254 m
1 .39254 L
s
.99375 .53968 m
1 .53968 L
s
.125 Mabswid
.99625 .13503 m
1 .13503 L
s
.99625 .17182 m
1 .17182 L
s
.99625 .2086 m
1 .2086 L
s
.99625 .28218 m
1 .28218 L
s
.99625 .31896 m
1 .31896 L
s
.99625 .35575 m
1 .35575 L
s
.99625 .42932 m
1 .42932 L
s
.99625 .46611 m
1 .46611 L
s
.99625 .50289 m
1 .50289 L
s
.99625 .06146 m
1 .06146 L
s
.99625 .02467 m
1 .02467 L
s
.99625 .57647 m
1 .57647 L
s
.99625 .61325 m
1 .61325 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .24539 m
1 .24539 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell["\<\
This includes grid lines, which are shown in light blue on color \
displays. \
\>", "MathCaption",
  CellTags->{"S2.10.5", "5.4"}],

Cell[CellGroupData[{

Cell["Show[%, GridLines -> Automatic]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .09824 -24 -4.5 ]
[-0.0125 .09824 0 4.5 ]
[-0.0125 .24539 -6 -4.5 ]
[-0.0125 .24539 0 4.5 ]
[-0.0125 .39254 -18 -4.5 ]
[-0.0125 .39254 0 4.5 ]
[-0.0125 .53968 -18 -4.5 ]
[-0.0125 .53968 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .61803 L
s
.40476 0 m
.40476 .61803 L
s
.59524 0 m
.59524 .61803 L
s
.78571 0 m
.78571 .61803 L
s
0 .09824 m
1 .09824 L
s
0 .24539 m
1 .24539 L
s
0 .39254 m
1 .39254 L
s
0 .53968 m
1 .53968 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .09824 m
.00625 .09824 L
s
[(-0.2)] -0.0125 .09824 1 0 Mshowa
0 .24539 m
.00625 .24539 L
s
[(0)] -0.0125 .24539 1 0 Mshowa
0 .39254 m
.00625 .39254 L
s
[(0.2)] -0.0125 .39254 1 0 Mshowa
0 .53968 m
.00625 .53968 L
s
[(0.4)] -0.0125 .53968 1 0 Mshowa
.125 Mabswid
0 .13503 m
.00375 .13503 L
s
0 .17182 m
.00375 .17182 L
s
0 .2086 m
.00375 .2086 L
s
0 .28218 m
.00375 .28218 L
s
0 .31896 m
.00375 .31896 L
s
0 .35575 m
.00375 .35575 L
s
0 .42932 m
.00375 .42932 L
s
0 .46611 m
.00375 .46611 L
s
0 .50289 m
.00375 .50289 L
s
0 .06146 m
.00375 .06146 L
s
0 .02467 m
.00375 .02467 L
s
0 .57647 m
.00375 .57647 L
s
0 .61325 m
.00375 .61325 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .09824 m
1 .09824 L
s
.99375 .24539 m
1 .24539 L
s
.99375 .39254 m
1 .39254 L
s
.99375 .53968 m
1 .53968 L
s
.125 Mabswid
.99625 .13503 m
1 .13503 L
s
.99625 .17182 m
1 .17182 L
s
.99625 .2086 m
1 .2086 L
s
.99625 .28218 m
1 .28218 L
s
.99625 .31896 m
1 .31896 L
s
.99625 .35575 m
1 .35575 L
s
.99625 .42932 m
1 .42932 L
s
.99625 .46611 m
1 .46611 L
s
.99625 .50289 m
1 .50289 L
s
.99625 .06146 m
1 .06146 L
s
.99625 .02467 m
1 .02467 L
s
.99625 .57647 m
1 .57647 L
s
.99625 .61325 m
1 .61325 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .24539 m
1 .24539 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Axes", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["draw no axes "]},
          {Cell[TextData[{
              StyleBox["Axes", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell[TextData[{
              "draw both ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axes "
            }]]},
          {Cell[TextData[{
              StyleBox["Axes", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{False,", "MR"],
              " ",
              StyleBox["True}", "MR"],
              " "
            }]], Cell[TextData[{
              "draw a ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axis but no ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axis "
            }]]},
          {Cell[TextData[{
              StyleBox["AxesOrigin", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[
            "choose the crossing point for the axes automatically "]},
          {Cell[TextData[{
              StyleBox["AxesOrigin", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["specify the crossing point "]},
          {Cell[TextData[{
              StyleBox["AxesStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["style", "TI"],
              " "
            }]], Cell["specify the style for axes "]},
          {Cell[TextData[{
              StyleBox["AxesStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{", "MR"],
              StyleBox["xstyle", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["ystyle", "TI"],
              StyleBox["}}", "MR"],
              " "
            }]], Cell["specify individual styles for axes "]},
          {Cell[TextData[{
              StyleBox["AxesLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["None", "MR"],
              " "
            }]], Cell["give no axis labels "]},
          {Cell[TextData[{
              StyleBox["AxesLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["ylabel", "TI"],
              " "
            }]], Cell[TextData[{
              "put a label on the ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axis "
            }]]},
          {Cell[TextData[{
              StyleBox["AxesLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["xlabel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ylabel", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "put labels on both ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["x",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " and ",
              Cell[BoxData[
                  FormBox[
                    StyleBox["y",
                      "TI"], TraditionalForm]], "InlineFormula"],
              " axes "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.5"],

Cell["Options for axes. ", "Caption",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "This makes the axes cross at the point ",
  StyleBox["{5,", "MR"],
  " ",
  StyleBox["0}", "MR"],
  ", and puts a label on each axis. "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.5"}],

Cell[CellGroupData[{

Cell["Show[bp, AxesOrigin->{5, 0}, AxesLabel->{\"x\", \"y\"}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.02381 .23289 -3 -9 ]
[.02381 .23289 3 0 ]
[.21429 .23289 -3 -9 ]
[.21429 .23289 3 0 ]
[.40476 .23289 -3 -9 ]
[.40476 .23289 3 0 ]
[.59524 .23289 -3 -9 ]
[.59524 .23289 3 0 ]
[.78571 .23289 -3 -9 ]
[.78571 .23289 3 0 ]
[.97619 .23289 -6 -9 ]
[.97619 .23289 6 0 ]
[1.025 .24539 0 -4.90625 ]
[1.025 .24539 10 4.90625 ]
[.4875 .09824 -24 -4.5 ]
[.4875 .09824 0 4.5 ]
[.4875 .39254 -18 -4.5 ]
[.4875 .39254 0 4.5 ]
[.4875 .53968 -18 -4.5 ]
[.4875 .53968 0 4.5 ]
[.5 .64303 -5.03125 0 ]
[.5 .64303 5.03125 9.8125 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24539 m
.02381 .25164 L
s
[(0)] .02381 .23289 0 1 Mshowa
.21429 .24539 m
.21429 .25164 L
s
[(2)] .21429 .23289 0 1 Mshowa
.40476 .24539 m
.40476 .25164 L
s
[(4)] .40476 .23289 0 1 Mshowa
.59524 .24539 m
.59524 .25164 L
s
[(6)] .59524 .23289 0 1 Mshowa
.78571 .24539 m
.78571 .25164 L
s
[(8)] .78571 .23289 0 1 Mshowa
.97619 .24539 m
.97619 .25164 L
s
[(10)] .97619 .23289 0 1 Mshowa
.125 Mabswid
.07143 .24539 m
.07143 .24914 L
s
.11905 .24539 m
.11905 .24914 L
s
.16667 .24539 m
.16667 .24914 L
s
.2619 .24539 m
.2619 .24914 L
s
.30952 .24539 m
.30952 .24914 L
s
.35714 .24539 m
.35714 .24914 L
s
.45238 .24539 m
.45238 .24914 L
s
.54762 .24539 m
.54762 .24914 L
s
.64286 .24539 m
.64286 .24914 L
s
.69048 .24539 m
.69048 .24914 L
s
.7381 .24539 m
.7381 .24914 L
s
.83333 .24539 m
.83333 .24914 L
s
.88095 .24539 m
.88095 .24914 L
s
.92857 .24539 m
.92857 .24914 L
s
.25 Mabswid
0 .24539 m
1 .24539 L
s
gsave
1.025 .24539 -61 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 .09824 m
.50625 .09824 L
s
[(-0.2)] .4875 .09824 1 0 Mshowa
.5 .39254 m
.50625 .39254 L
s
[(0.2)] .4875 .39254 1 0 Mshowa
.5 .53968 m
.50625 .53968 L
s
[(0.4)] .4875 .53968 1 0 Mshowa
.125 Mabswid
.5 .13503 m
.50375 .13503 L
s
.5 .17182 m
.50375 .17182 L
s
.5 .2086 m
.50375 .2086 L
s
.5 .28218 m
.50375 .28218 L
s
.5 .31896 m
.50375 .31896 L
s
.5 .35575 m
.50375 .35575 L
s
.5 .42932 m
.50375 .42932 L
s
.5 .46611 m
.50375 .46611 L
s
.5 .50289 m
.50375 .50289 L
s
.5 .06146 m
.50375 .06146 L
s
.5 .02467 m
.50375 .02467 L
s
.5 .57647 m
.50375 .57647 L
s
.5 .61325 m
.50375 .61325 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .64303 -66.0312 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Ticks", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["None", "MR"],
              " "
            }]], Cell["draw no tick marks "]},
          {Cell[TextData[{
              StyleBox["Ticks", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["place tick marks automatically "]},
          {Cell[TextData[{
              StyleBox["Ticks", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["xticks", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["yticks", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["tick mark specifications for each axis "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.5"],

Cell[TextData[{
  "Settings for the ",
  StyleBox["Ticks", "MR"],
  " option. "
}], "Caption",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "With the default setting ",
  StyleBox["Ticks", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " creates a certain number of major and minor tick marks, and places them \
on axes at positions which yield the minimum number of decimal digits in the \
tick labels. In some cases, however, you may want to specify the positions \
and properties of tick marks explicitly. You will need to do this, for \
example, if you want to have tick marks at multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)], "InlineFormula"],
  ", or if you want to put a nonlinear scale on an axis. "
}], "Text",
  CellTags->{"S2.10.5", "5.6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["None", "MR"],
              " "
            }]], Cell["draw no tick marks "]},
          {Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["place tick marks automatically "]},
          {Cell[TextData[{
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["draw tick marks at the specified positions "]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["label",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["label",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["draw tick marks with the specified labels "]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["label",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["len",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["draw tick marks with the specified scaled lengths "]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["label",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["plen",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["mlen",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["}},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], 
            Cell["\<\
draw tick marks with the specified lengths in the \
positive and negative directions \
\>"]},
          {Cell[TextData[{
              StyleBox["{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["label",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["len",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["style",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["draw tick marks with the specified styles "]},
          {Cell[TextData[{
              StyleBox["func", "TI"],
              " "
            }]], Cell[TextData[{
              "a function to be applied to ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              " to get the tick mark option "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.5"],

Cell["Tick mark options for each axis. ", "Caption",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "This gives tick marks at specified positions on the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis, and chooses the tick marks automatically on the ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis. "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.7"}],

Cell[CellGroupData[{

Cell["Show[bp, Ticks -> {{0, Pi, 2Pi, 3Pi}, Automatic}]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.32301 .23289 -5 -9.8125 ]
[.32301 .23289 5 0 ]
[.62221 .23289 -9.3125 -9.8125 ]
[.62221 .23289 9.3125 0 ]
[.92141 .23289 -9.3125 -9.8125 ]
[.92141 .23289 9.3125 0 ]
[.01131 .09824 -24 -4.5 ]
[.01131 .09824 0 4.5 ]
[.01131 .39254 -18 -4.5 ]
[.01131 .39254 0 4.5 ]
[.01131 .53968 -18 -4.5 ]
[.01131 .53968 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.32301 .24539 m
.32301 .25164 L
s
gsave
.32301 .23289 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
.62221 .24539 m
.62221 .25164 L
s
gsave
.62221 .23289 -70.3125 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
71.625 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
.92141 .24539 m
.92141 .25164 L
s
gsave
.92141 .23289 -70.3125 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
71.625 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
0 .24539 m
1 .24539 L
s
.02381 .09824 m
.03006 .09824 L
s
[(-0.2)] .01131 .09824 1 0 Mshowa
.02381 .39254 m
.03006 .39254 L
s
[(0.2)] .01131 .39254 1 0 Mshowa
.02381 .53968 m
.03006 .53968 L
s
[(0.4)] .01131 .53968 1 0 Mshowa
.125 Mabswid
.02381 .13503 m
.02756 .13503 L
s
.02381 .17182 m
.02756 .17182 L
s
.02381 .2086 m
.02756 .2086 L
s
.02381 .28218 m
.02756 .28218 L
s
.02381 .31896 m
.02756 .31896 L
s
.02381 .35575 m
.02756 .35575 L
s
.02381 .42932 m
.02756 .42932 L
s
.02381 .46611 m
.02756 .46611 L
s
.02381 .50289 m
.02756 .50289 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .02467 m
.02756 .02467 L
s
.02381 .57647 m
.02756 .57647 L
s
.02381 .61325 m
.02756 .61325 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell[TextData[{
  "This adds tick marks with no labels at multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]/2\)], "InlineFormula"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.8"}],

Cell[CellGroupData[{

Cell["\<\
Show[bp, Ticks -> {{0, {Pi/2, \"\"}, Pi, {3Pi/2, \"\"}, 2Pi, \
{5Pi/2, \"\"}, 3Pi}, Automatic}]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.32301 .23289 -5 -9.8125 ]
[.32301 .23289 5 0 ]
[.62221 .23289 -9.3125 -9.8125 ]
[.62221 .23289 9.3125 0 ]
[.92141 .23289 -9.3125 -9.8125 ]
[.92141 .23289 9.3125 0 ]
[.01131 .09824 -24 -4.5 ]
[.01131 .09824 0 4.5 ]
[.01131 .39254 -18 -4.5 ]
[.01131 .39254 0 4.5 ]
[.01131 .53968 -18 -4.5 ]
[.01131 .53968 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17341 .24539 m
.17341 .25164 L
s
.32301 .24539 m
.32301 .25164 L
s
gsave
.32301 .23289 -66 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
.47261 .24539 m
.47261 .25164 L
s
.62221 .24539 m
.62221 .25164 L
s
gsave
.62221 .23289 -70.3125 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
71.625 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
.77181 .24539 m
.77181 .25164 L
s
.92141 .24539 m
.92141 .25164 L
s
gsave
.92141 .23289 -70.3125 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
71.625 11.250 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
1.000 setlinewidth
grestore
0 .24539 m
1 .24539 L
s
.02381 .09824 m
.03006 .09824 L
s
[(-0.2)] .01131 .09824 1 0 Mshowa
.02381 .39254 m
.03006 .39254 L
s
[(0.2)] .01131 .39254 1 0 Mshowa
.02381 .53968 m
.03006 .53968 L
s
[(0.4)] .01131 .53968 1 0 Mshowa
.125 Mabswid
.02381 .13503 m
.02756 .13503 L
s
.02381 .17182 m
.02756 .17182 L
s
.02381 .2086 m
.02756 .2086 L
s
.02381 .28218 m
.02756 .28218 L
s
.02381 .31896 m
.02756 .31896 L
s
.02381 .35575 m
.02756 .35575 L
s
.02381 .42932 m
.02756 .42932 L
s
.02381 .46611 m
.02756 .46611 L
s
.02381 .50289 m
.02756 .50289 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .02467 m
.02756 .02467 L
s
.02381 .57647 m
.02756 .57647 L
s
.02381 .61325 m
.02756 .61325 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell["\<\
Particularly when you want to create complicated tick mark \
specifications, it is often convenient to define a \
\[OpenCurlyDoubleQuote]tick mark function\[CloseCurlyDoubleQuote] which \
creates the appropriate tick mark specification given the minimum and maximum \
values on a particular axis. \
\>", "Text",
  CellTags->{"S2.10.5", "5.9"}],

Cell["\<\
This defines a function which gives a list of tick mark positions \
with a spacing of 1. \
\>", "MathCaption",
  CellTags->{"S2.10.5", "5.10"}],

Cell["units[xmin_, xmax_] := Range[Floor[xmin], Floor[xmax], 1]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "This uses the ",
  StyleBox["units", "MR"],
  " function to specify tick marks for the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis. "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.11"}],

Cell[CellGroupData[{

Cell["Show[bp, Ticks -> {units, Automatic}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.11905 .23289 -3 -9 ]
[.11905 .23289 3 0 ]
[.21429 .23289 -3 -9 ]
[.21429 .23289 3 0 ]
[.30952 .23289 -3 -9 ]
[.30952 .23289 3 0 ]
[.40476 .23289 -3 -9 ]
[.40476 .23289 3 0 ]
[.5 .23289 -3 -9 ]
[.5 .23289 3 0 ]
[.59524 .23289 -3 -9 ]
[.59524 .23289 3 0 ]
[.69048 .23289 -3 -9 ]
[.69048 .23289 3 0 ]
[.78571 .23289 -3 -9 ]
[.78571 .23289 3 0 ]
[.88095 .23289 -3 -9 ]
[.88095 .23289 3 0 ]
[.97619 .23289 -6 -9 ]
[.97619 .23289 6 0 ]
[.01131 .09824 -24 -4.5 ]
[.01131 .09824 0 4.5 ]
[.01131 .39254 -18 -4.5 ]
[.01131 .39254 0 4.5 ]
[.01131 .53968 -18 -4.5 ]
[.01131 .53968 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .24539 m
.11905 .25164 L
s
[(1)] .11905 .23289 0 1 Mshowa
.21429 .24539 m
.21429 .25164 L
s
[(2)] .21429 .23289 0 1 Mshowa
.30952 .24539 m
.30952 .25164 L
s
[(3)] .30952 .23289 0 1 Mshowa
.40476 .24539 m
.40476 .25164 L
s
[(4)] .40476 .23289 0 1 Mshowa
.5 .24539 m
.5 .25164 L
s
[(5)] .5 .23289 0 1 Mshowa
.59524 .24539 m
.59524 .25164 L
s
[(6)] .59524 .23289 0 1 Mshowa
.69048 .24539 m
.69048 .25164 L
s
[(7)] .69048 .23289 0 1 Mshowa
.78571 .24539 m
.78571 .25164 L
s
[(8)] .78571 .23289 0 1 Mshowa
.88095 .24539 m
.88095 .25164 L
s
[(9)] .88095 .23289 0 1 Mshowa
.97619 .24539 m
.97619 .25164 L
s
[(10)] .97619 .23289 0 1 Mshowa
0 .24539 m
1 .24539 L
s
.02381 .09824 m
.03006 .09824 L
s
[(-0.2)] .01131 .09824 1 0 Mshowa
.02381 .39254 m
.03006 .39254 L
s
[(0.2)] .01131 .39254 1 0 Mshowa
.02381 .53968 m
.03006 .53968 L
s
[(0.4)] .01131 .53968 1 0 Mshowa
.125 Mabswid
.02381 .13503 m
.02756 .13503 L
s
.02381 .17182 m
.02756 .17182 L
s
.02381 .2086 m
.02756 .2086 L
s
.02381 .28218 m
.02756 .28218 L
s
.02381 .31896 m
.02756 .31896 L
s
.02381 .35575 m
.02756 .35575 L
s
.02381 .42932 m
.02756 .42932 L
s
.02381 .46611 m
.02756 .46611 L
s
.02381 .50289 m
.02756 .50289 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .02467 m
.02756 .02467 L
s
.02381 .57647 m
.02756 .57647 L
s
.02381 .61325 m
.02756 .61325 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell[TextData[{
  "Sometimes you may want to generate tick marks which differ only slightly \
from those produced automatically with the setting ",
  StyleBox["Ticks", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ". You can get the complete specification for tick marks that were \
generated automatically in a particular plot by using ",
  StyleBox["AbsoluteOptions[", "MR"],
  StyleBox["g", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["Ticks]", "MR"],
  ", as discussed in Section\[NonBreakingSpace]",
  ButtonBox["2.10.1",
    ButtonData:>{"2.10.1", "1.21"},
    ButtonStyle->"MainBookLink"],
  ". "
}], "Text",
  CellTags->{"S2.10.5", "5.12"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Frame", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["draw no frame "]},
          {Cell[TextData[{
              StyleBox["Frame", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell["draw a frame around the plot "]},
          {Cell[TextData[{
              StyleBox["FrameStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["style", "TI"],
              " "
            }]], Cell["specify a style for the frame "]},
          {Cell[TextData[{
              StyleBox["FrameStyle", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{", "MR"],
              StyleBox["xmstyle", "TI"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["ymstyle", "TI"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["specify styles for each edge of the frame "]},
          {Cell[TextData[{
              StyleBox["FrameLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["None", "MR"],
              " "
            }]], Cell["give no frame labels "]},
          {Cell[TextData[{
              StyleBox["FrameLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["xmlabel", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ymlabel", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell["put labels on edges of the frame "]},
          {Cell[TextData[{
              StyleBox["RotateLabel", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["do not rotate text in labels "]},
          {Cell[TextData[{
              StyleBox["FrameTicks", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["None", "MR"],
              " "
            }]], Cell["draw no tick marks on frame edges "]},
          {Cell[TextData[{
              StyleBox["FrameTicks", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["position tick marks automatically "]},
          {Cell[TextData[{
              StyleBox["FrameTicks", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{{", "MR"],
              StyleBox["xmticks", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ymticks", "TI"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}}", "MR"],
              " "
            }]], Cell["specify tick marks for frame edges "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.5"],

Cell["Options for frame axes. ", "Caption",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "The ",
  StyleBox["Axes", "MR"],
  " option allows you to draw a single pair of axes in a plot. Sometimes, \
however, you may instead want to show the scales for a plot on a frame, \
typically drawn around the whole plot. The option ",
  StyleBox["Frame", "MR"],
  " allows you effectively to draw four axes, corresponding to the four edges \
of the frame around a plot. These four axes are ordered clockwise, starting \
from the one at the bottom. "
}], "Text",
  CellTags->{"S2.10.5", "5.13"}],

Cell["This draws frame axes, and labels each of them. ", "MathCaption",
  CellTags->{"S2.10.5", "5.14"}],

Cell[CellGroupData[{

Cell["\<\
Show[bp, Frame -> True, FrameLabel -> {\"label 1\", \"label 2\", \
\"label 3\", \"label 4\"}]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -23 -18.8125 ]
[.5 -0.0125 23 -9 ]
[-0.0125 .09824 -24 -4.5 ]
[-0.0125 .09824 0 4.5 ]
[-0.0125 .24539 -6 -4.5 ]
[-0.0125 .24539 0 4.5 ]
[-0.0125 .39254 -18 -4.5 ]
[-0.0125 .39254 0 4.5 ]
[-0.0125 .53968 -18 -4.5 ]
[-0.0125 .53968 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -33.8125 -23 ]
[-0.01875 .30902 -24 23 ]
[ 0 .61803 .125 0 ]
[.5 .63053 -23 0 ]
[.5 .63053 23 9.8125 ]
[ 1 0 .125 0 ]
[1.0125 .30902 0 -23 ]
[1.0125 .30902 9.8125 23 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -84 -22.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(label) show
99.000 11.250 moveto
(1) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .09824 m
.00625 .09824 L
s
[(-0.2)] -0.0125 .09824 1 0 Mshowa
0 .24539 m
.00625 .24539 L
s
[(0)] -0.0125 .24539 1 0 Mshowa
0 .39254 m
.00625 .39254 L
s
[(0.2)] -0.0125 .39254 1 0 Mshowa
0 .53968 m
.00625 .53968 L
s
[(0.4)] -0.0125 .53968 1 0 Mshowa
.125 Mabswid
0 .13503 m
.00375 .13503 L
s
0 .17182 m
.00375 .17182 L
s
0 .2086 m
.00375 .2086 L
s
0 .28218 m
.00375 .28218 L
s
0 .31896 m
.00375 .31896 L
s
0 .35575 m
.00375 .35575 L
s
0 .42932 m
.00375 .42932 L
s
0 .46611 m
.00375 .46611 L
s
0 .50289 m
.00375 .50289 L
s
0 .06146 m
.00375 .06146 L
s
0 .02467 m
.00375 .02467 L
s
0 .57647 m
.00375 .57647 L
s
0 .61325 m
.00375 .61325 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -112.906 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
84 8.90625 translate
90 rotate
-84 -8.90625 translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(label) show
99.000 11.250 moveto
(2) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.21429 .61178 m
.21429 .61803 L
s
.40476 .61178 m
.40476 .61803 L
s
.59524 .61178 m
.59524 .61803 L
s
.78571 .61178 m
.78571 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
gsave
.5 .63053 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(label) show
99.000 11.250 moveto
(3) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.99375 .09824 m
1 .09824 L
s
.99375 .24539 m
1 .24539 L
s
.99375 .39254 m
1 .39254 L
s
.99375 .53968 m
1 .53968 L
s
.125 Mabswid
.99625 .13503 m
1 .13503 L
s
.99625 .17182 m
1 .17182 L
s
.99625 .2086 m
1 .2086 L
s
.99625 .28218 m
1 .28218 L
s
.99625 .31896 m
1 .31896 L
s
.99625 .35575 m
1 .35575 L
s
.99625 .42932 m
1 .42932 L
s
.99625 .46611 m
1 .46611 L
s
.99625 .50289 m
1 .50289 L
s
.99625 .06146 m
1 .06146 L
s
.99625 .02467 m
1 .02467 L
s
.99625 .57647 m
1 .57647 L
s
.99625 .61325 m
1 .61325 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
1.0125 .30902 -79.0938 -8.90625 Mabsadd m
1 1 Mabs scale
currentpoint translate
84 8.90625 translate
90 rotate
-84 -8.90625 translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(label) show
99.000 11.250 moveto
(4) show
105.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .24539 m
1 .24539 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.5"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["GridLines", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["None", "MR"],
              " "
            }]], Cell["draw no grid lines "]},
          {Cell[TextData[{
              StyleBox["GridLines", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["position grid lines automatically "]},
          {Cell[TextData[{
              StyleBox["GridLines", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["xgrid", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["ygrid", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["specify grid lines in analogy with tick marks "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.5"],

Cell["Options for grid lines. ", "Caption",
  CellTags->"S2.10.5"],

Cell[TextData[{
  "Grid lines in ",
  StyleBox["Mathematica", "TI"],
  " work very much like tick marks. As with tick marks, you can specify \
explicit positions for grid lines. There is no label or length to specify for \
grid lines. However, you can specify a style. "
}], "Text",
  CellTags->{"S2.10.5", "5.15"}],

Cell[TextData[{
  "This generates ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " but not ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " grid lines. "
}], "MathCaption",
  CellTags->{"S2.10.5", "5.16"}],

Cell[CellGroupData[{

Cell["Show[bp, GridLines -> {Automatic, None}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.5"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.245389 0.735733 [
[.21429 .23289 -3 -9 ]
[.21429 .23289 3 0 ]
[.40476 .23289 -3 -9 ]
[.40476 .23289 3 0 ]
[.59524 .23289 -3 -9 ]
[.59524 .23289 3 0 ]
[.78571 .23289 -3 -9 ]
[.78571 .23289 3 0 ]
[.97619 .23289 -6 -9 ]
[.97619 .23289 6 0 ]
[.01131 .09824 -24 -4.5 ]
[.01131 .09824 0 4.5 ]
[.01131 .39254 -18 -4.5 ]
[.01131 .39254 0 4.5 ]
[.01131 .53968 -18 -4.5 ]
[.01131 .53968 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .61803 L
s
.21429 0 m
.21429 .61803 L
s
.40476 0 m
.40476 .61803 L
s
.59524 0 m
.59524 .61803 L
s
.78571 0 m
.78571 .61803 L
s
.97619 0 m
.97619 .61803 L
s
0 g
.21429 .24539 m
.21429 .25164 L
s
[(2)] .21429 .23289 0 1 Mshowa
.40476 .24539 m
.40476 .25164 L
s
[(4)] .40476 .23289 0 1 Mshowa
.59524 .24539 m
.59524 .25164 L
s
[(6)] .59524 .23289 0 1 Mshowa
.78571 .24539 m
.78571 .25164 L
s
[(8)] .78571 .23289 0 1 Mshowa
.97619 .24539 m
.97619 .25164 L
s
[(10)] .97619 .23289 0 1 Mshowa
.125 Mabswid
.07143 .24539 m
.07143 .24914 L
s
.11905 .24539 m
.11905 .24914 L
s
.16667 .24539 m
.16667 .24914 L
s
.2619 .24539 m
.2619 .24914 L
s
.30952 .24539 m
.30952 .24914 L
s
.35714 .24539 m
.35714 .24914 L
s
.45238 .24539 m
.45238 .24914 L
s
.5 .24539 m
.5 .24914 L
s
.54762 .24539 m
.54762 .24914 L
s
.64286 .24539 m
.64286 .24914 L
s
.69048 .24539 m
.69048 .24914 L
s
.7381 .24539 m
.7381 .24914 L
s
.83333 .24539 m
.83333 .24914 L
s
.88095 .24539 m
.88095 .24914 L
s
.92857 .24539 m
.92857 .24914 L
s
.25 Mabswid
0 .24539 m
1 .24539 L
s
.02381 .09824 m
.03006 .09824 L
s
[(-0.2)] .01131 .09824 1 0 Mshowa
.02381 .39254 m
.03006 .39254 L
s
[(0.2)] .01131 .39254 1 0 Mshowa
.02381 .53968 m
.03006 .53968 L
s
[(0.4)] .01131 .53968 1 0 Mshowa
.125 Mabswid
.02381 .13503 m
.02756 .13503 L
s
.02381 .17182 m
.02756 .17182 L
s
.02381 .2086 m
.02756 .2086 L
s
.02381 .28218 m
.02756 .28218 L
s
.02381 .31896 m
.02756 .31896 L
s
.02381 .35575 m
.02756 .35575 L
s
.02381 .42932 m
.02756 .42932 L
s
.02381 .46611 m
.02756 .46611 L
s
.02381 .50289 m
.02756 .50289 L
s
.02381 .06146 m
.02756 .06146 L
s
.02381 .02467 m
.02756 .02467 L
s
.02381 .57647 m
.02756 .57647 L
s
.02381 .61325 m
.02756 .61325 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24539 m
.02499 .2454 L
.02605 .24544 L
.02729 .24551 L
.02846 .24561 L
.03053 .24585 L
.03279 .2462 L
.03527 .24672 L
.0379 .2474 L
.04262 .24896 L
.04749 .25104 L
.05205 .25342 L
.06244 .26032 L
.07305 .26942 L
.08274 .27949 L
.10458 .30766 L
.14429 .37389 L
.18248 .44651 L
.22313 .51989 L
.24192 .54861 L
.26226 .57395 L
.27341 .58483 L
.28367 .59275 L
.29348 .59833 L
.29842 .60037 L
.30101 .60123 L
.30384 .602 L
.30656 .60258 L
.30776 .60278 L
.30908 .60297 L
.31024 .6031 L
.31149 .60321 L
.31281 .60328 L
.31404 .60332 L
.31517 .60332 L
.31641 .60329 L
.3177 .60322 L
.3189 .60312 L
.32003 .603 L
.32105 .60286 L
.32335 .60247 L
.32603 .60186 L
.32851 .60115 L
.33411 .59904 L
.33904 .59658 L
.34426 .59337 L
.3537 .586 L
.36384 .57587 L
.38215 .55198 L
.40332 .51603 L
Mistroke
.42343 .47471 L
.46167 .38181 L
.50237 .27332 L
.54155 .17331 L
.56157 .1282 L
.58319 .08635 L
.60409 .05411 L
.61404 .04196 L
.6233 .03258 L
.63241 .02525 L
.63709 .02223 L
.64217 .01952 L
.64506 .01825 L
.64773 .01725 L
.65023 .01646 L
.65299 .01576 L
.65546 .01529 L
.65659 .01512 L
.65777 .01497 L
.65905 .01485 L
.66021 .01477 L
.66147 .01473 L
.66218 .01472 L
.66284 .01472 L
.66413 .01475 L
.66477 .01477 L
.66548 .01482 L
.66674 .01492 L
.66791 .01505 L
.67056 .01546 L
.67339 .01608 L
.6786 .01769 L
.68334 .01969 L
.69289 .02521 L
.70194 .03223 L
.72183 .05339 L
.74024 .07926 L
.77947 .14971 L
.81719 .228 L
.85736 .30984 L
.89602 .37519 L
.91603 .40064 L
.92623 .41094 L
.93713 .41984 L
.94243 .42336 L
.94745 .42618 L
.95234 .42845 L
.95684 .43012 L
.96112 .43134 L
.96327 .43182 L
Mistroke
.96565 .43223 L
.96803 .43254 L
.96936 .43266 L
.97058 .43274 L
.97171 .43279 L
.97295 .43281 L
.97412 .43281 L
.9752 .43278 L
.97619 .43273 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.5"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.10.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.10.6 Making Plots within Plots", "Subsection",
  CellTags->{"S2.10.6", "6.1"}],

Cell[TextData[{
  "Section ",
  ButtonBox["1.9.3",
    ButtonData:>{"1.9.3", "3.1"},
    ButtonStyle->"MainBookLink"],
  " described how you can make regular arrays of plots using ",
  StyleBox["GraphicsArray", "MR"],
  ". Using the ",
  StyleBox["Rectangle", "MR"],
  " graphics primitive, however, you can combine and superimpose plots in any \
way. "
}], "Text",
  CellTags->{"S2.10.6", "6.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Rectangle[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["graphics", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[
            "render a graphics object within the specified rectangle "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.6"],

Cell["Creating a subplot. ", "Caption",
  CellTags->"S2.10.6"],

Cell["\<\
Here is a three\[Hyphen]dimensional plot. \
\>", "MathCaption",
  CellTags->{"S2.10.6", "6.3"}],

Cell[CellGroupData[{

Cell["p3 = Plot3D[Sin[x] Exp[y], {x, -5, 5}, {y, -2, 2}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.3209e-17 1.04977 -0.0679587 1.04977 [
[.08608 .22315 -12 -8.87306 ]
[.08608 .22315 0 .12694 ]
[.20731 .17545 -11.6738 -9 ]
[.20731 .17545 .32622 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.46808 .07289 -5.33651 -9 ]
[.46808 .07289 .66349 0 ]
[.60856 .01769 -5.08632 -9 ]
[.60856 .01769 .91368 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.0226 .27459 -12 -2.75033 ]
[.0226 .27459 0 6.24967 ]
[.0149 .32285 -12 -2.79114 ]
[.0149 .32285 0 6.20886 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00124 .42403 -6 -2.87714 ]
[-0.00124 .42403 0 6.12286 ]
[-0.00971 .47711 -6 -2.92248 ]
[-0.00971 .47711 0 6.07752 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03483 .26984 m
.04095 .26746 L
s
[(-4)] .0226 .27459 1 -0.38882 Mshowa
.02717 .31819 m
.0333 .31586 L
s
[(-2)] .0149 .32285 1 -0.37975 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.0111 .41958 m
.01727 .41735 L
s
[(2)] -0.00124 .42403 1 -0.36063 Mshowa
.00267 .47277 m
.00886 .4706 L
s
[(4)] -0.00971 .47711 1 -0.35056 Mshowa
.125 Mabswid
.03294 .28179 m
.03661 .28037 L
s
.03103 .29383 m
.0347 .29242 L
s
.02911 .30596 m
.03278 .30456 L
s
.02521 .33052 m
.0289 .32913 L
s
.02325 .34294 m
.02693 .34156 L
s
.02126 .35546 m
.02495 .35409 L
s
.01725 .3808 m
.02094 .37944 L
s
.01521 .39362 m
.01891 .39227 L
s
.01317 .40655 m
.01687 .40521 L
s
.00902 .43272 m
.01273 .43139 L
s
.00692 .44596 m
.01063 .44464 L
s
.0048 .45931 m
.00852 .458 L
s
.03671 .25798 m
.04038 .25655 L
s
.00052 .48634 m
.00424 .48505 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.645 .763 .934 r
.38427 .80015 .39787 .81114 .42053 .8052 .40705 .79412 Metetra
.645 .763 .934 r
.40705 .79412 .42053 .8052 .44337 .79922 .43002 .78805 Metetra
.855 .774 .771 r
.43002 .78805 .44337 .79922 .46657 .78346 .45369 .75629 Metetra
.849 .677 .667 r
.45369 .75629 .46657 .78346 .49041 .70966 .47766 .69282 Metetra
.89 .722 .666 r
.47766 .69282 .49041 .70966 .51358 .63251 .50111 .62616 Metetra
.93 .786 .679 r
.50111 .62616 .51358 .63251 .53604 .56396 .52395 .56651 Metetra
.892 .976 .819 r
.52395 .56651 .53604 .56396 .55843 .55287 .54648 .54028 Metetra
.664 .741 .907 r
.54648 .54028 .55843 .55287 .58103 .54607 .5692 .53338 Metetra
.664 .741 .907 r
.5692 .53338 .58103 .54607 .6038 .53922 .5921 .52642 Metetra
.664 .741 .907 r
.5921 .52642 .6038 .53922 .62677 .53231 .61519 .5194 Metetra
.764 .298 0 r
.61519 .5194 .62677 .53231 .65128 .56179 .64008 .55937 Metetra
.88 .453 .178 r
.64008 .55937 .65128 .56179 .67796 .62396 .66632 .61126 Metetra
.845 .404 0 r
.66632 .61126 .67796 .62396 .70599 .68929 .69374 .66547 Metetra
0 0 .481 r
.69374 .66547 .70599 .68929 .73344 .72328 .72177 .71087 Metetra
.645 .763 .934 r
.72177 .71087 .73344 .72328 .75902 .71659 .74752 .70406 Metetra
.645 .763 .934 r
.74752 .70406 .75902 .71659 .78483 .70983 .77349 .69719 Metetra
.645 .763 .934 r
.77349 .69719 .78483 .70983 .81088 .70301 .7997 .69026 Metetra
.859 .809 .799 r
.7997 .69026 .81088 .70301 .83671 .69107 .82423 .66089 Metetra
.872 .691 .654 r
.82423 .66089 .83671 .69107 .85649 .61468 .84525 .59513 Metetra
.924 .746 .643 r
.84525 .59513 .85649 .61468 .87498 .53394 .86518 .5253 Metetra
.969 .821 .641 r
.86518 .5253 .87498 .53394 .89346 .46136 .88507 .46206 Metetra
.902 .986 .749 r
.88507 .46206 .89346 .46136 .91786 .44473 .90803 .43044 Metetra
.664 .741 .907 r
.90803 .43044 .91786 .44473 .94349 .43702 .93382 .4226 Metetra
.664 .741 .907 r
.93382 .4226 .94349 .43702 .96935 .42924 .95984 .4147 Metetra
.645 .763 .934 r
.37046 .78898 .38427 .80015 .40705 .79412 .39336 .78287 Metetra
.686 .772 .917 r
.39336 .78287 .40705 .79412 .43002 .78805 .41652 .77434 Metetra
.869 .746 .725 r
.41652 .77434 .43002 .78805 .45369 .75629 .44067 .73134 Metetra
.845 .684 .682 r
.44067 .73134 .45369 .75629 .47766 .69282 .46474 .67655 Metetra
.884 .728 .683 r
.46474 .67655 .47766 .69282 .50111 .62616 .48841 .6188 Metetra
.92 .79 .701 r
.48841 .6188 .50111 .62616 .52395 .56651 .51157 .56678 Metetra
.944 .893 .748 r
.51157 .56678 .52395 .56651 .54648 .54028 .53435 .52764 Metetra
.666 .744 .908 r
.53435 .52764 .54648 .54028 .5692 .53338 .55719 .52049 Metetra
.664 .741 .907 r
.55719 .52049 .5692 .53338 .5921 .52642 .58021 .51342 Metetra
.221 .53 .921 r
.58021 .51342 .5921 .52642 .61519 .5194 .60381 .52198 Metetra
.811 .358 .16 r
.60381 .52198 .61519 .5194 .64008 .55937 .62857 .55526 Metetra
.851 .394 .087 r
.62857 .55526 .64008 .55937 .66632 .61126 .6545 .59836 Metetra
.78 .317 0 r
.6545 .59836 .66632 .61126 .69374 .66547 .68144 .64314 Metetra
0 .006 .578 r
.68144 .64314 .69374 .66547 .72177 .71087 .70897 .68044 Metetra
.441 .474 .798 r
.70897 .68044 .72177 .71087 .74752 .70406 .73581 .69133 Metetra
.645 .763 .934 r
.73581 .69133 .74752 .70406 .77349 .69719 .76196 .68434 Metetra
.648 .764 .934 r
.76196 .68434 .77349 .69719 .7997 .69026 .78832 .67713 Metetra
.908 .8 .73 r
.78832 .67713 .7997 .69026 .82423 .66089 .81188 .63313 Metetra
.866 .699 .673 r
.81188 .63313 .82423 .66089 .84525 .59513 .83395 .57627 Metetra
.915 .753 .666 r
.83395 .57627 .84525 .59513 .86518 .5253 .8551 .5157 Metetra
.957 .826 .674 r
.8551 .5157 .86518 .5253 .88507 .46206 .87622 .46047 Metetra
.964 .932 .703 r
.87622 .46047 .88507 .46206 .90803 .43044 .89828 .41808 Metetra
.696 .788 .922 r
.89828 .41808 .90803 .43044 .93382 .4226 .92399 .40795 Metetra
.664 .741 .907 r
.92399 .40795 .93382 .4226 .95984 .4147 .95018 .39992 Metetra
.597 .639 .863 r
.3568 .76968 .37046 .78898 .39336 .78287 .37962 .76707 Metetra
.788 .731 .8 r
.37962 .76707 .39336 .78287 .41652 .77434 .40333 .74563 Metetra
.795 .654 .708 r
.40333 .74563 .41652 .77434 .44067 .73134 .42748 .70823 Metetra
.84 .691 .698 r
.42748 .70823 .44067 .73134 .46474 .67655 .45164 .66073 Metetra
.876 .733 .701 r
.45164 .66073 .46474 .67655 .48841 .6188 .47549 .61053 Metetra
.908 .793 .722 r
.47549 .61053 .48841 .6188 .51157 .56678 .49892 .56505 Metetra
.925 .888 .777 r
.49892 .56505 .51157 .56678 .53435 .52764 .52201 .53045 Metetra
.786 .997 .858 r
.52201 .53045 .53435 .52764 .55719 .52049 .54501 .51095 Metetra
.539 .762 .979 r
.54501 .51095 .55719 .52049 .58021 .51342 .56825 .50843 Metetra
.45 0 0 r
.56825 .50843 .58021 .51342 .60381 .52198 .59209 .52234 Metetra
.773 .28 .049 r
.59209 .52234 .60381 .52198 .62857 .55526 .61679 .54969 Metetra
.803 .312 0 r
.61679 .54969 .62857 .55526 .6545 .59836 .64248 .58525 Metetra
.684 .204 0 r
.64248 .58525 .6545 .59836 .68144 .64314 .66907 .62204 Metetra
0 .121 .671 r
.66907 .62204 .68144 .64314 .70897 .68044 .69621 .65232 Metetra
.32 .418 .806 r
.69621 .65232 .70897 .68044 .73581 .69133 .72338 .66896 Metetra
.582 .617 .852 r
.72338 .66896 .73581 .69133 .76196 .68434 .74996 .66717 Metetra
.788 .751 .819 r
.74996 .66717 .76196 .68434 .78832 .67713 .77545 .64573 Metetra
.802 .662 .708 r
.77545 .64573 .78832 .67713 .81188 .63313 .79961 .60735 Metetra
.859 .707 .692 r
.79961 .60735 .81188 .63313 .83395 .57627 .82256 .55797 Metetra
.905 .76 .689 r
.82256 .55797 .83395 .57627 .8551 .5157 .84477 .50524 Metetra
.942 .83 .705 r
.84477 .50524 .8551 .5157 .87622 .46047 .86694 .45685 Metetra
.947 .931 .75 r
.86694 .45685 .87622 .46047 .89828 .41808 .88991 .41932 Metetra
.752 .992 .797 r
.88991 .41932 .89828 .41808 .92399 .40795 .91449 .3971 Metetra
.586 .778 .971 r
.91449 .3971 .92399 .40795 .95018 .39992 .94132 .39232 Metetra
.607 .575 .792 r
.3434 .74187 .3568 .76968 .37962 .76707 .36626 .73854 Metetra
.726 .628 .748 r
.36626 .73854 .37962 .76707 .40333 .74563 .38995 .71934 Metetra
.79 .663 .724 r
.38995 .71934 .40333 .74563 .42748 .70823 .41411 .68662 Metetra
.833 .698 .714 r
.41411 .68662 .42748 .70823 .45164 .66073 .43834 .64526 Metetra
.867 .739 .719 r
.43834 .64526 .45164 .66073 .47549 .61053 .46235 .60147 Metetra
.895 .795 .743 r
.46235 .60147 .47549 .61053 .49892 .56505 .48601 .56156 Metetra
.904 .881 .802 r
.48601 .56156 .49892 .56505 .52201 .53045 .50938 .53086 Metetra
.79 .982 .901 r
.50938 .53086 .52201 .53045 .54501 .51095 .53265 .51305 Metetra
.53265 .51305 .54501 .51095 .56825 .50843 .5561 .50979 Metetra
.532 0 0 r
.5561 .50979 .56825 .50843 .59209 .52234 .58005 .52059 Metetra
.706 .17 0 r
.58005 .52059 .59209 .52234 .61679 .54969 .60473 .54281 Metetra
.724 .201 0 r
.60473 .54281 .61679 .54969 .64248 .58525 .63027 .57192 Metetra
.554 .068 0 r
.63027 .57192 .64248 .58525 .66907 .62204 .6566 .60193 Metetra
0 .231 .751 r
.6566 .60193 .66907 .62204 .69621 .65232 .68346 .62628 Metetra
.362 .463 .829 r
.68346 .62628 .69621 .65232 .72338 .66896 .71041 .63905 Metetra
.597 .57 .794 r
.71041 .63905 .72338 .66896 .74996 .66717 .73696 .63625 Metetra
.72 .628 .754 r
.73696 .63625 .74996 .66717 .77545 .64573 .76268 .61689 Metetra
.796 .672 .727 r
.76268 .61689 .77545 .64573 .79961 .60735 .78736 .5832 Metetra
.851 .715 .713 r
.78736 .5832 .79961 .60735 .82256 .55797 .81107 .5401 Metetra
.894 .765 .713 r
.81107 .5401 .82256 .55797 .84477 .50524 .83418 .494 Metetra
.925 .832 .734 r
.83418 .494 .84477 .50524 .86694 .45685 .85728 .45146 Metetra
.926 .923 .789 r
.85728 .45146 .86694 .45685 .88991 .41932 .88105 .41808 Metetra
.777 .995 .871 r
.88105 .41808 .88991 .41932 .91449 .3971 .90619 .39778 Metetra
.195 .724 .759 r
.90619 .39778 .91449 .3971 .94132 .39232 .93327 .39241 Metetra
.613 .595 .808 r
.32978 .71634 .3434 .74187 .36626 .73854 .35268 .7124 Metetra
.723 .64 .765 r
.35268 .7124 .36626 .73854 .38995 .71934 .37638 .69505 Metetra
.785 .673 .74 r
.37638 .69505 .38995 .71934 .41411 .68662 .40055 .66625 Metetra
.826 .705 .731 r
.40055 .66625 .41411 .68662 .43834 .64526 .42483 .63005 Metetra
.858 .744 .737 r
.42483 .63005 .43834 .64526 .46235 .60147 .44898 .59169 Metetra
.88 .797 .763 r
.44898 .59169 .46235 .60147 .48601 .56156 .47284 .55654 Metetra
.882 .872 .823 r
.47284 .55654 .48601 .56156 .50938 .53086 .49646 .52918 Metetra
.784 .958 .925 r
.49646 .52918 .50938 .53086 .53265 .51305 .51998 .51281 Metetra
.258 .766 .851 r
.51998 .51281 .53265 .51305 .5561 .50979 .54364 .50889 Metetra
.375 0 0 r
.54364 .50889 .5561 .50979 .58005 .52059 .56771 .51698 Metetra
.595 .023 0 r
.56771 .51698 .58005 .52059 .60473 .54281 .59241 .53479 Metetra
.602 .057 0 r
.59241 .53479 .60473 .54281 .63027 .57192 .61786 .55837 Metetra
0 .083 .597 r
.61786 .55837 .63027 .57192 .6566 .60193 .64401 .58262 Metetra
.035 .33 .813 r
.64401 .58262 .6566 .60193 .68346 .62628 .67066 .60196 Metetra
.401 .503 .848 r
.67066 .60196 .68346 .62628 .71041 .63905 .69747 .61145 Metetra
.604 .59 .81 r
.69747 .61145 .71041 .63905 .73696 .63625 .72402 .60779 Metetra
.717 .641 .771 r
.72402 .60779 .73696 .63625 .76268 .61689 .74996 .59014 Metetra
.79 .681 .745 r
.74996 .59014 .76268 .61689 .78736 .5832 .77509 .56036 Metetra
.841 .723 .733 r
.77509 .56036 .78736 .5832 .81107 .5401 .79946 .52254 Metetra
.881 .77 .736 r
.79946 .52254 .81107 .5401 .83418 .494 .82335 .48206 Metetra
.907 .832 .761 r
.82335 .48206 .83418 .494 .85728 .45146 .84725 .4445 Metetra
.902 .912 .82 r
.84725 .4445 .85728 .45146 .88105 .41808 .87173 .41468 Metetra
.781 .977 .912 r
.87173 .41468 .88105 .41808 .90619 .39778 .89738 .39601 Metetra
.353 .823 .9 r
.89738 .39601 .90619 .39778 .93327 .39241 .9247 .39011 Metetra
.619 .613 .823 r
.31592 .6927 .32978 .71634 .35268 .7124 .33888 .68822 Metetra
.72 .652 .781 r
.33888 .68822 .35268 .7124 .37638 .69505 .36259 .67241 Metetra
.779 .682 .756 r
.36259 .67241 .37638 .69505 .40055 .66625 .38678 .64688 Metetra
.818 .712 .748 r
.38678 .64688 .40055 .66625 .42483 .63005 .41112 .61503 Metetra
.847 .749 .755 r
.41112 .61503 .42483 .63005 .44898 .59169 .43538 .58127 Metetra
.865 .797 .782 r
.43538 .58127 .44898 .59169 .47284 .55654 .45943 .55016 Metetra
.86 .863 .84 r
.45943 .55016 .47284 .55654 .49646 .52918 .48327 .52565 Metetra
.772 .931 .937 r
.48327 .52565 .49646 .52918 .51998 .51281 .50701 .51051 Metetra
.395 .833 .948 r
.50701 .51051 .51998 .51281 .54364 .50889 .53088 .506 Metetra
.171 0 0 r
.53088 .506 .54364 .50889 .56771 .51698 .55508 .51174 Metetra
.43 0 0 r
.55508 .51174 .56771 .51698 .59241 .53479 .57983 .52575 Metetra
.434 0 0 r
.57983 .52575 .59241 .53479 .61786 .55837 .60524 .5446 Metetra
0 .231 .728 r
.60524 .5446 .61786 .55837 .64401 .58262 .63128 .56393 Metetra
.143 .414 .858 r
.63128 .56393 .64401 .58262 .67066 .60196 .6578 .57904 Metetra
.436 .54 .864 r
.6578 .57904 .67066 .60196 .69747 .61145 .68451 .58576 Metetra
.61 .609 .824 r
.68451 .58576 .69747 .61145 .72402 .60779 .71109 .58135 Metetra
.714 .653 .787 r
.71109 .58135 .72402 .60779 .74996 .59014 .73724 .56512 Metetra
.782 .691 .763 r
.73724 .56512 .74996 .59014 .77509 .56036 .76277 .5386 Metetra
.831 .729 .753 r
.76277 .5386 .77509 .56036 .79946 .52254 .78771 .50521 Metetra
.866 .774 .758 r
.78771 .50521 .79946 .52254 .82335 .48206 .81228 .46948 Metetra
.887 .83 .785 r
.81228 .46948 .82335 .48206 .84725 .4445 .83688 .43615 Metetra
.877 .898 .843 r
.83688 .43615 .84725 .4445 .87173 .41468 .86199 .40937 Metetra
.773 .951 .933 r
.86199 .40937 .87173 .41468 .89738 .39601 .88811 .39207 Metetra
.462 .861 .968 r
.88811 .39207 .89738 .39601 .9247 .39011 .91567 .3857 Metetra
.624 .63 .837 r
.30182 .67059 .31592 .6927 .33888 .68822 .32485 .66565 Metetra
.717 .663 .796 r
.32485 .66565 .33888 .68822 .36259 .67241 .34859 .65111 Metetra
.772 .69 .773 r
.34859 .65111 .36259 .67241 .38678 .64688 .37279 .62832 Metetra
.809 .719 .765 r
.37279 .62832 .38678 .64688 .41112 .61503 .39719 .60013 Metetra
.835 .753 .773 r
.39719 .60013 .41112 .61503 .43538 .58127 .42156 .57026 Metetra
.849 .797 .8 r
.42156 .57026 .43538 .58127 .45943 .55016 .44577 .54259 Metetra
.839 .853 .855 r
.44577 .54259 .45943 .55016 .48327 .52565 .46981 .5205 Metetra
.759 .906 .941 r
.46981 .5205 .48327 .52565 .50701 .51051 .49377 .50639 Metetra
.485 .853 .988 r
.49377 .50639 .50701 .51051 .53088 .506 .51782 .50136 Metetra
.039 .578 .849 r
.51782 .50136 .53088 .506 .55508 .51174 .54218 .50507 Metetra
0 .337 .707 r
.54218 .50507 .55508 .51174 .57983 .52575 .567 .5158 Metetra
0 .278 .721 r
.567 .5158 .57983 .52575 .60524 .5446 .5924 .5306 Metetra
0 .359 .825 r
.5924 .5306 .60524 .5446 .63128 .56393 .61839 .54575 Metetra
.235 .482 .889 r
.61839 .54575 .63128 .56393 .6578 .57904 .64483 .55725 Metetra
.467 .572 .877 r
.64483 .55725 .6578 .57904 .68451 .58576 .67151 .56161 Metetra
.616 .626 .838 r
.67151 .56161 .68451 .58576 .71109 .58135 .69814 .55655 Metetra
.711 .665 .803 r
.69814 .55655 .71109 .58135 .73724 .56512 .72448 .54148 Metetra
.774 .7 .781 r
.72448 .54148 .73724 .56512 .76277 .5386 .75036 .51769 Metetra
.82 .736 .772 r
.75036 .51769 .76277 .5386 .78771 .50521 .77581 .48803 Metetra
.851 .777 .779 r
.77581 .48803 .78771 .50521 .81228 .46948 .80098 .45631 Metetra
.867 .827 .806 r
.80098 .45631 .81228 .46948 .83688 .43615 .82619 .42658 Metetra
.852 .884 .862 r
.82619 .42658 .83688 .43615 .86199 .40937 .85186 .40237 Metetra
.762 .923 .942 r
.85186 .40237 .86199 .40937 .88811 .39207 .87841 .38624 Metetra
.53 .867 .993 r
.87841 .38624 .88811 .39207 .91567 .3857 .90621 .37943 Metetra
.628 .646 .849 r
.28746 .64975 .30182 .67059 .32485 .66565 .31057 .6444 Metetra
.713 .674 .811 r
.31057 .6444 .32485 .66565 .34859 .65111 .33435 .6309 Metetra
.765 .698 .789 r
.33435 .6309 .34859 .65111 .37279 .62832 .35859 .61041 Metetra
.8 .725 .782 r
.35859 .61041 .37279 .62832 .39719 .60013 .38304 .5853 Metetra
.822 .756 .79 r
.38304 .5853 .39719 .60013 .42156 .57026 .40751 .55872 Metetra
.832 .796 .816 r
.40751 .55872 .42156 .57026 .44577 .54259 .43186 .53396 Metetra
.818 .843 .867 r
.43186 .53396 .44577 .54259 .46981 .5205 .45608 .51393 Metetra
.745 .883 .942 r
.45608 .51393 .46981 .5205 .49377 .50639 .48025 .50069 Metetra
.54 .851 .998 r
.48025 .50069 .49377 .50639 .51782 .50136 .50449 .49519 Metetra
.211 .676 .943 r
.50449 .49519 .51782 .50136 .54218 .50507 .529 .49713 Metetra
0 .486 .85 r
.529 .49713 .54218 .50507 .567 .5158 .55392 .50503 Metetra
0 .419 .841 r
.55392 .50503 .567 .5158 .5924 .5306 .57936 .51636 Metetra
.097 .46 .888 r
.57936 .51636 .5924 .5306 .61839 .54575 .60533 .52794 Metetra
.311 .537 .909 r
.60533 .52794 .61839 .54575 .64483 .55725 .63174 .53637 Metetra
.495 .599 .887 r
.63174 .53637 .64483 .55725 .67151 .56161 .65841 .53873 Metetra
.622 .642 .85 r
.65841 .53873 .67151 .56161 .69814 .55655 .68512 .53309 Metetra
.707 .676 .818 r
.68512 .53309 .69814 .55655 .72448 .54148 .71164 .51898 Metetra
.766 .708 .797 r
.71164 .51898 .72448 .54148 .75036 .51769 .73785 .49746 Metetra
.808 .741 .79 r
.73785 .49746 .75036 .51769 .77581 .48803 .76374 .47092 Metetra
.835 .779 .798 r
.76374 .47092 .77581 .48803 .80098 .45631 .78943 .4426 Metetra
.847 .823 .825 r
.78943 .4426 .80098 .45631 .82619 .42658 .8152 .4159 Metetra
.828 .869 .875 r
.8152 .4159 .82619 .42658 .85186 .40237 .84137 .39388 Metetra
.749 .898 .945 r
.84137 .39388 .85186 .40237 .87841 .38624 .86832 .37872 Metetra
.571 .858 .996 r
.86832 .37872 .87841 .38624 .90621 .37943 .89634 .37151 Metetra
.632 .66 .859 r
.27285 .62994 .28746 .64975 .31057 .6444 .29604 .62421 Metetra
.708 .684 .824 r
.29604 .62421 .31057 .6444 .33435 .6309 .31987 .61158 Metetra
.757 .706 .804 r
.31987 .61158 .33435 .6309 .35859 .61041 .34415 .59301 Metetra
.789 .73 .798 r
.34415 .59301 .35859 .61041 .38304 .5853 .36866 .57049 Metetra
.81 .759 .806 r
.36866 .57049 .38304 .5853 .40751 .55872 .39322 .54668 Metetra
.816 .794 .831 r
.39322 .54668 .40751 .55872 .43186 .53396 .41771 .52439 Metetra
.799 .833 .877 r
.41771 .52439 .43186 .53396 .45608 .51393 .4421 .5061 Metetra
.733 .863 .941 r
.4421 .5061 .45608 .51393 .48025 .50069 .46646 .49358 Metetra
.575 .842 .995 r
.46646 .49358 .48025 .50069 .50449 .49519 .49089 .48765 Metetra
.336 .728 .983 r
.49089 .48765 .50449 .49519 .529 .49713 .51555 .48807 Metetra
.149 .59 .931 r
.51555 .48807 .529 .49713 .55392 .50503 .54058 .49353 Metetra
.114 .524 .913 r
.54058 .49353 .55392 .50503 .57936 .51636 .56609 .50188 Metetra
.215 .536 .924 r
.56609 .50188 .57936 .51636 .60533 .52794 .59208 .5104 Metetra
.374 .58 .922 r
.59208 .5104 .60533 .52794 .63174 .53637 .6185 .51622 Metetra
.518 .623 .895 r
.6185 .51622 .63174 .53637 .65841 .53873 .6452 .51686 Metetra
.626 .657 .86 r
.6452 .51686 .65841 .53873 .68512 .53309 .67199 .51071 Metetra
.703 .686 .831 r
.67199 .51071 .68512 .53309 .71164 .51898 .6987 .49738 Metetra
.757 .715 .813 r
.6987 .49738 .71164 .51898 .73785 .49746 .72521 .47775 Metetra
.795 .745 .807 r
.72521 .47775 .73785 .49746 .76374 .47092 .75149 .45384 Metetra
.819 .779 .815 r
.75149 .45384 .76374 .47092 .78943 .4426 .77766 .42837 Metetra
.827 .818 .841 r
.77766 .42837 .78943 .4426 .8152 .4159 .80391 .40424 Metetra
.806 .855 .886 r
.80391 .40424 .8152 .4159 .84137 .39388 .83054 .38406 Metetra
.736 .875 .945 r
.83054 .38406 .84137 .39388 .86832 .37872 .85785 .36972 Metetra
.597 .845 .991 r
.85785 .36972 .86832 .37872 .89634 .37151 .88611 .36214 Metetra
.636 .673 .869 r
.25797 .61095 .27285 .62994 .29604 .62421 .28126 .60489 Metetra
.704 .693 .837 r
.28126 .60489 .29604 .62421 .31987 .61158 .30514 .59298 Metetra
.749 .713 .818 r
.30514 .59298 .31987 .61158 .34415 .59301 .32946 .576 Metetra
.779 .735 .812 r
.32946 .576 .34415 .59301 .36866 .57049 .35403 .55566 Metetra
.796 .761 .82 r
.35403 .55566 .36866 .57049 .39322 .54668 .37868 .53419 Metetra
.8 .791 .844 r
.37868 .53419 .39322 .54668 .41771 .52439 .40331 .51398 Metetra
.782 .823 .885 r
.40331 .51398 .41771 .52439 .4421 .5061 .42786 .49715 Metetra
.722 .845 .94 r
.42786 .49715 .4421 .5061 .46646 .49358 .4524 .48523 Metetra
.598 .83 .988 r
.4524 .48523 .46646 .49358 .49089 .48765 .47701 .47892 Metetra
.421 .753 .995 r
.47701 .47892 .49089 .48765 .51555 .48807 .50184 .478 Metetra
.277 .654 .968 r
.50184 .478 .51555 .48807 .54058 .49353 .527 .48136 Metetra
.241 .595 .95 r
.527 .48136 .54058 .49353 .56609 .50188 .55259 .48716 Metetra
.308 .59 .943 r
.55259 .48716 .56609 .50188 .59208 .5104 .57864 .49305 Metetra
.424 .614 .929 r
.57864 .49305 .59208 .5104 .6185 .51622 .60509 .49663 Metetra
.539 .643 .901 r
.60509 .49663 .6185 .51622 .6452 .51686 .63185 .4958 Metetra
.631 .67 .87 r
.63185 .4958 .6452 .51686 .67199 .51071 .65875 .4892 Metetra
.698 .695 .843 r
.65875 .4892 .67199 .51071 .6987 .49738 .68564 .47649 Metetra
.748 .721 .827 r
.68564 .47649 .6987 .49738 .72521 .47775 .71241 .45844 Metetra
.783 .749 .822 r
.71241 .45844 .72521 .47775 .75149 .45384 .73906 .43673 Metetra
.804 .779 .83 r
.73906 .43673 .75149 .45384 .77766 .42837 .76564 .41366 Metetra
.808 .812 .854 r
.76564 .41366 .77766 .42837 .80391 .40424 .79234 .39169 Metetra
.787 .842 .894 r
.79234 .39169 .80391 .40424 .83054 .38406 .81939 .37306 Metetra
.725 .855 .943 r
.81939 .37306 .83054 .38406 .85785 .36972 .84704 .35939 Metetra
.614 .831 .983 r
.84704 .35939 .85785 .36972 .88611 .36214 .87552 .35147 Metetra
.639 .684 .877 r
.24282 .59263 .25797 .61095 .28126 .60489 .26621 .58627 Metetra
.699 .701 .848 r
.26621 .58627 .28126 .60489 .30514 .59298 .29016 .57493 Metetra
.741 .719 .831 r
.29016 .57493 .30514 .59298 .32946 .576 .31454 .55929 Metetra
.768 .739 .826 r
.31454 .55929 .32946 .576 .35403 .55566 .33917 .54076 Metetra
.783 .762 .834 r
.33917 .54076 .35403 .55566 .37868 .53419 .36391 .52126 Metetra
.785 .788 .855 r
.36391 .52126 .37868 .53419 .40331 .51398 .38866 .50281 Metetra
.766 .814 .891 r
.38866 .50281 .40331 .51398 .42786 .49715 .41337 .48721 Metetra
.713 .83 .938 r
.41337 .48721 .42786 .49715 .4524 .48523 .43808 .47578 Metetra
.613 .818 .979 r
.43808 .47578 .4524 .48523 .47701 .47892 .46287 .46912 Metetra
.48 .764 .993 r
.46287 .46912 .47701 .47892 .50184 .478 .48786 .46703 Metetra
.37 .692 .981 r
.48786 .46703 .50184 .478 .527 .48136 .51316 .46858 Metetra
.336 .642 .965 r
.51316 .46858 .527 .48136 .55259 .48716 .53886 .47217 Metetra
.38 .63 .952 r
.53886 .47217 .55259 .48716 .57864 .49305 .56498 .47582 Metetra
.466 .641 .933 r
.56498 .47582 .57864 .49305 .60509 .49663 .59151 .47748 Metetra
.557 .661 .906 r
.59151 .47748 .60509 .49663 .63185 .4958 .61834 .47537 Metetra
.634 .682 .878 r
.61834 .47537 .63185 .4958 .65875 .4892 .64535 .46836 Metetra
.694 .704 .854 r
.64535 .46836 .65875 .4892 .68564 .47649 .67242 .45617 Metetra
.739 .726 .84 r
.67242 .45617 .68564 .47649 .71241 .45844 .69945 .43942 Metetra
.77 .751 .836 r
.69945 .43942 .71241 .45844 .73906 .43673 .72642 .41954 Metetra
.788 .778 .844 r
.72642 .41954 .73906 .43673 .76564 .41366 .75339 .39848 Metetra
.79 .806 .865 r
.75339 .39848 .76564 .41366 .79234 .39169 .78049 .37834 Metetra
.769 .83 .9 r
.78049 .37834 .79234 .39169 .81939 .37306 .80792 .361 Metetra
.715 .839 .941 r
.80792 .361 .81939 .37306 .84704 .35939 .83589 .34787 Metetra
.626 .819 .975 r
.83589 .34787 .84704 .35939 .87552 .35147 .86461 .33963 Metetra
.641 .694 .884 r
.2274 .57483 .24282 .59263 .26621 .58627 .25089 .56819 Metetra
.695 .709 .858 r
.25089 .56819 .26621 .58627 .29016 .57493 .27491 .55732 Metetra
.733 .724 .843 r
.27491 .55732 .29016 .57493 .31454 .55929 .29935 .54278 Metetra
.757 .742 .839 r
.29935 .54278 .31454 .55929 .33917 .54076 .32405 .52579 Metetra
.771 .763 .846 r
.32405 .52579 .33917 .54076 .36391 .52126 .34888 .50793 Metetra
.77 .785 .865 r
.34888 .50793 .36391 .52126 .38866 .50281 .37375 .49095 Metetra
.751 .806 .896 r
.37375 .49095 .38866 .50281 .41337 .48721 .39861 .47638 Metetra
.705 .818 .935 r
.39861 .47638 .41337 .48721 .43808 .47578 .4235 .46534 Metetra
.624 .807 .97 r
.4235 .46534 .43808 .47578 .46287 .46912 .44847 .45836 Metetra
.522 .768 .987 r
.44847 .45836 .46287 .46912 .48786 .46703 .47362 .45526 Metetra
.437 .714 .983 r
.47362 .45526 .48786 .46703 .51316 .46858 .49907 .45524 Metetra
.407 .674 .97 r
.49907 .45524 .51316 .46858 .53886 .47217 .52489 .45693 Metetra
.435 .658 .954 r
.52489 .45693 .53886 .47217 .56498 .47582 .55111 .45865 Metetra
.499 .662 .934 r
.55111 .45865 .56498 .47582 .59151 .47748 .57772 .45865 Metetra
.572 .675 .909 r
.57772 .45865 .59151 .47748 .61834 .47537 .60465 .45544 Metetra
.637 .692 .884 r
.60465 .45544 .61834 .47537 .64535 .46836 .63179 .44806 Metetra
.69 .711 .864 r
.63179 .44806 .64535 .46836 .67242 .45617 .65904 .43626 Metetra
.73 .731 .851 r
.65904 .43626 .67242 .45617 .69945 .43942 .68631 .42059 Metetra
.758 .753 .848 r
.68631 .42059 .69945 .43942 .72642 .41954 .71358 .40225 Metetra
.774 .777 .856 r
.71358 .40225 .72642 .41954 .75339 .39848 .7409 .38287 Metetra
.774 .801 .875 r
.7409 .38287 .75339 .39848 .78049 .37834 .76837 .36424 Metetra
.753 .819 .904 r
.76837 .36424 .78049 .37834 .80792 .361 .79615 .34799 Metetra
.707 .825 .938 r
.79615 .34799 .80792 .361 .83589 .34787 .82443 .33529 Metetra
.634 .808 .967 r
.82443 .33529 .83589 .34787 .86461 .33963 .85337 .32675 Metetra
.643 .703 .89 r
.2117 .55742 .2274 .57483 .25089 .56819 .2353 .55053 Metetra
.691 .715 .867 r
.2353 .55053 .25089 .56819 .27491 .55732 .2594 .54004 Metetra
.725 .729 .854 r
.2594 .54004 .27491 .55732 .29935 .54278 .2839 .52642 Metetra
.747 .745 .85 r
.2839 .52642 .29935 .54278 .32405 .52579 .30868 .51069 Metetra
.758 .763 .857 r
.30868 .51069 .32405 .52579 .34888 .50793 .3336 .49422 Metetra
.757 .782 .874 r
.3336 .49422 .34888 .50793 .37375 .49095 .35859 .47846 Metetra
.739 .799 .901 r
.35859 .47846 .37375 .49095 .39861 .47638 .3836 .46475 Metetra
.698 .807 .933 r
.3836 .46475 .39861 .47638 .4235 .46534 .40865 .45403 Metetra
.632 .798 .963 r
.40865 .45403 .4235 .46534 .44847 .45836 .43379 .44674 Metetra
.552 .769 .979 r
.43379 .44674 .44847 .45836 .47362 .45526 .45912 .44275 Metetra
.486 .728 .978 r
.45912 .44275 .47362 .45526 .49907 .45524 .48472 .44136 Metetra
.459 .695 .969 r
.48472 .44136 .49907 .45524 .52489 .45693 .51067 .44141 Metetra
.478 .679 .954 r
.51067 .44141 .52489 .45693 .55111 .45865 .53701 .44147 Metetra
.526 .679 .935 r
.53701 .44147 .55111 .45865 .57772 .45865 .56372 .44004 Metetra
.585 .687 .912 r
.56372 .44004 .57772 .45865 .60465 .45544 .59076 .43587 Metetra
.64 .701 .89 r
.59076 .43587 .60465 .45544 .63179 .44806 .61804 .42814 Metetra
.686 .717 .872 r
.61804 .42814 .63179 .44806 .65904 .43626 .64546 .41666 Metetra
.722 .735 .861 r
.64546 .41666 .65904 .43626 .68631 .42059 .67297 .40188 Metetra
.747 .755 .859 r
.67297 .40188 .68631 .42059 .71358 .40225 .70052 .3848 Metetra
.76 .775 .866 r
.70052 .3848 .71358 .40225 .7409 .38287 .72816 .36682 Metetra
.759 .795 .882 r
.72816 .36682 .7409 .38287 .76837 .36424 .75597 .34946 Metetra
.74 .81 .907 r
.75597 .34946 .76837 .36424 .79615 .34799 .78408 .3341 Metetra
.699 .813 .936 r
.78408 .3341 .79615 .34799 .82443 .33529 .81266 .32175 Metetra
.639 .799 .959 r
.81266 .32175 .82443 .33529 .85337 .32675 .84183 .31292 Metetra
.645 .71 .895 r
.19571 .54032 .2117 .55742 .2353 .55053 .21942 .53319 Metetra
.687 .72 .875 r
.21942 .53319 .2353 .55053 .2594 .54004 .24361 .52299 Metetra
.717 .733 .863 r
.24361 .52299 .2594 .54004 .2839 .52642 .26819 .51012 Metetra
.737 .747 .86 r
.26819 .51012 .2839 .52642 .30868 .51069 .29304 .49545 Metetra
.747 .763 .866 r
.29304 .49545 .30868 .51069 .3336 .49422 .31806 .48013 Metetra
.745 .779 .881 r
.31806 .48013 .3336 .49422 .35859 .47846 .34316 .4654 Metetra
.727 .793 .904 r
.34316 .4654 .35859 .47846 .3836 .46475 .36832 .45239 Metetra
.691 .799 .931 r
.36832 .45239 .3836 .46475 .40865 .45403 .39353 .44191 Metetra
.637 .791 .956 r
.39353 .44191 .40865 .45403 .43379 .44674 .41884 .43434 Metetra
.574 .768 .97 r
.41884 .43434 .43379 .44674 .45912 .44275 .44434 .42957 Metetra
.522 .736 .972 r
.44434 .42957 .45912 .44275 .48472 .44136 .4701 .427 Metetra
.499 .709 .965 r
.4701 .427 .48472 .44136 .51067 .44141 .4962 .42562 Metetra
.511 .695 .951 r
.4962 .42562 .51067 .44141 .53701 .44147 .52266 .42423 Metetra
.548 .692 .934 r
.52266 .42423 .53701 .44147 .56372 .44004 .5495 .42157 Metetra
.595 .698 .914 r
.5495 .42157 .56372 .44004 .59076 .43587 .57666 .41656 Metetra
.642 .708 .895 r
.57666 .41656 .59076 .43587 .61804 .42814 .60408 .40851 Metetra
.682 .722 .88 r
.60408 .40851 .61804 .42814 .64546 .41666 .63169 .39727 Metetra
.714 .738 .87 r
.63169 .39727 .64546 .41666 .67297 .40188 .65941 .38321 Metetra
.736 .755 .868 r
.65941 .38321 .67297 .40188 .70052 .3848 .68724 .36718 Metetra
.747 .773 .874 r
.68724 .36718 .70052 .3848 .72816 .36682 .71518 .35036 Metetra
.745 .79 .889 r
.71518 .35036 .72816 .36682 .75597 .34946 .7433 .33405 Metetra
.728 .801 .91 r
.7433 .33405 .75597 .34946 .78408 .3341 .77173 .31942 Metetra
.693 .803 .934 r
.77173 .31942 .78408 .3341 .81266 .32175 .80058 .30733 Metetra
.643 .791 .953 r
.80058 .30733 .81266 .32175 .84183 .31292 .82998 .29822 Metetra
.647 .716 .899 r
.17943 .52343 .19571 .54032 .21942 .53319 .20325 .51608 Metetra
.683 .725 .882 r
.20325 .51608 .21942 .53319 .24361 .52299 .22754 .5061 Metetra
.71 .736 .872 r
.22754 .5061 .24361 .52299 .26819 .51012 .25219 .49385 Metetra
.728 .749 .869 r
.25219 .49385 .26819 .51012 .29304 .49545 .27713 .48005 Metetra
.736 .762 .874 r
.27713 .48005 .29304 .49545 .31806 .48013 .30225 .46568 Metetra
.733 .776 .887 r
.30225 .46568 .31806 .48013 .34316 .4654 .32747 .4518 Metetra
.717 .787 .907 r
.32747 .4518 .34316 .4654 .36832 .45239 .35277 .43936 Metetra
.686 .791 .93 r
.35277 .43936 .36832 .45239 .39353 .44191 .37814 .42907 Metetra
.641 .784 .95 r
.37814 .42907 .39353 .44191 .41884 .43434 .40362 .42124 Metetra
.59 .766 .963 r
.40362 .42124 .41884 .43434 .44434 .42957 .4293 .41577 Metetra
.549 .742 .966 r
.4293 .41577 .44434 .42957 .4701 .427 .45522 .41216 Metetra
.53 .719 .96 r
.45522 .41216 .4701 .427 .4962 .42562 .48147 .40955 Metetra
.538 .706 .948 r
.48147 .40955 .4962 .42562 .52266 .42423 .50807 .40691 Metetra
.566 .703 .933 r
.50807 .40691 .52266 .42423 .5495 .42157 .53504 .40317 Metetra
.605 .706 .916 r
.53504 .40317 .5495 .42157 .57666 .41656 .56234 .39741 Metetra
.644 .715 .899 r
.56234 .39741 .57666 .41656 .60408 .40851 .58991 .38907 Metetra
.679 .727 .886 r
.58991 .38907 .60408 .40851 .63169 .39727 .6177 .378 Metetra
.707 .741 .878 r
.6177 .378 .63169 .39727 .65941 .38321 .64564 .36452 Metetra
.726 .756 .876 r
.64564 .36452 .65941 .38321 .68724 .36718 .67371 .34935 Metetra
.736 .771 .882 r
.67371 .34935 .68724 .36718 .71518 .35036 .70194 .33349 Metetra
.733 .785 .894 r
.70194 .33349 .71518 .35036 .7433 .33405 .73037 .31804 Metetra
.717 .794 .912 r
.73037 .31804 .7433 .33405 .77173 .31942 .75909 .304 Metetra
.687 .795 .932 r
.75909 .304 .77173 .31942 .80058 .30733 .78821 .29211 Metetra
.646 .785 .948 r
.78821 .29211 .80058 .30733 .82998 .29822 .81784 .28273 Metetra
.648 .722 .902 r
.16285 .50668 .17943 .52343 .20325 .51608 .18679 .49911 Metetra
.679 .729 .888 r
.18679 .49911 .20325 .51608 .22754 .5061 .21117 .4893 Metetra
.703 .739 .879 r
.21117 .4893 .22754 .5061 .25219 .49385 .23592 .47755 Metetra
.719 .75 .876 r
.23592 .47755 .25219 .49385 .27713 .48005 .26094 .46446 Metetra
.726 .762 .881 r
.26094 .46446 .27713 .48005 .30225 .46568 .28616 .45088 Metetra
.723 .773 .892 r
.28616 .45088 .30225 .46568 .32747 .4518 .3115 .43769 Metetra
.709 .782 .909 r
.3115 .43769 .32747 .4518 .35277 .43936 .33694 .42572 Metetra
.682 .785 .928 r
.33694 .42572 .35277 .43936 .37814 .42907 .36247 .41556 Metetra
.644 .779 .945 r
.36247 .41556 .37814 .42907 .40362 .42124 .38813 .40748 Metetra
.603 .764 .957 r
.38813 .40748 .40362 .42124 .4293 .41577 .41397 .4014 Metetra
.569 .745 .959 r
.41397 .4014 .4293 .41577 .45522 .41216 .44007 .39687 Metetra
.554 .727 .955 r
.44007 .39687 .45522 .41216 .48147 .40955 .46647 .39319 Metetra
.559 .715 .945 r
.46647 .39319 .48147 .40955 .50807 .40691 .49323 .38946 Metetra
.581 .711 .932 r
.49323 .38946 .50807 .40691 .53504 .40317 .52034 .38477 Metetra
.612 .714 .917 r
.52034 .38477 .53504 .40317 .56234 .39741 .54778 .37836 Metetra
.646 .721 .903 r
.54778 .37836 .56234 .39741 .58991 .38907 .57551 .36973 Metetra
.676 .731 .891 r
.57551 .36973 .58991 .38907 .6177 .378 .60348 .35878 Metetra
.7 .743 .884 r
.60348 .35878 .6177 .378 .64564 .36452 .63163 .34576 Metetra
.717 .756 .883 r
.63163 .34576 .64564 .36452 .67371 .34935 .65995 .33129 Metetra
.725 .769 .888 r
.65995 .33129 .67371 .34935 .70194 .33349 .68844 .31621 Metetra
.723 .781 .899 r
.68844 .31621 .70194 .33349 .73037 .31804 .71715 .30147 Metetra
.708 .788 .914 r
.71715 .30147 .73037 .31804 .75909 .304 .74616 .28789 Metetra
.683 .788 .93 r
.74616 .28789 .75909 .304 .78821 .29211 .77555 .27613 Metetra
.648 .779 .943 r
.77555 .27613 .78821 .29211 .81784 .28273 .80541 .2665 Metetra
.649 .726 .905 r
.14597 .49 .16285 .50668 .18679 .49911 .17003 .48222 Metetra
.676 .733 .893 r
.17003 .48222 .18679 .49911 .21117 .4893 .19451 .47253 Metetra
.697 .741 .885 r
.19451 .47253 .21117 .4893 .23592 .47755 .21935 .46118 Metetra
.711 .751 .883 r
.21935 .46118 .23592 .47755 .26094 .46446 .24447 .44868 Metetra
.717 .761 .887 r
.24447 .44868 .26094 .46446 .28616 .45088 .26979 .43573 Metetra
.714 .771 .897 r
.26979 .43573 .28616 .45088 .3115 .43769 .29525 .42312 Metetra
.701 .778 .911 r
.29525 .42312 .3115 .43769 .33694 .42572 .32083 .41152 Metetra
.678 .78 .927 r
.32083 .41152 .33694 .42572 .36247 .41556 .34652 .40144 Metetra
.647 .775 .941 r
.34652 .40144 .36247 .41556 .38813 .40748 .37235 .39312 Metetra
.613 .763 .951 r
.37235 .39312 .38813 .40748 .41397 .4014 .39836 .38648 Metetra
.586 .747 .954 r
.39836 .38648 .41397 .4014 .44007 .39687 .42463 .38116 Metetra
.572 .732 .95 r
.42463 .38116 .44007 .39687 .46647 .39319 .4512 .37653 Metetra
.576 .722 .942 r
.4512 .37653 .46647 .39319 .49323 .38946 .47811 .37184 Metetra
.593 .718 .931 r
.47811 .37184 .49323 .38946 .52034 .38477 .50537 .36632 Metetra
.619 .72 .918 r
.50537 .36632 .52034 .38477 .54778 .37836 .53297 .35932 Metetra
.647 .725 .906 r
.53297 .35932 .54778 .37836 .57551 .36973 .56086 .35043 Metetra
.673 .734 .896 r
.56086 .35043 .57551 .36973 .60348 .35878 .58901 .33954 Metetra
.695 .744 .89 r
.58901 .33954 .60348 .35878 .63163 .34576 .61738 .32688 Metetra
.709 .756 .889 r
.61738 .32688 .63163 .34576 .65995 .33129 .64593 .31297 Metetra
.716 .767 .893 r
.64593 .31297 .65995 .33129 .68844 .31621 .67468 .29853 Metetra
.713 .777 .902 r
.67468 .29853 .68844 .31621 .71715 .30147 .70367 .28435 Metetra
.701 .783 .915 r
.70367 .28435 .71715 .30147 .74616 .28789 .73295 .27115 Metetra
.679 .782 .928 r
.73295 .27115 .74616 .28789 .77555 .27613 .7626 .25947 Metetra
.65 .775 .94 r
.7626 .25947 .77555 .27613 .80541 .2665 .79269 .24957 Metetra
.65 .73 .908 r
.12878 .47334 .14597 .49 .17003 .48222 .15297 .46536 Metetra
.673 .736 .897 r
.15297 .46536 .17003 .48222 .19451 .47253 .17755 .45575 Metetra
.692 .743 .89 r
.17755 .45575 .19451 .47253 .21935 .46118 .20248 .4447 Metetra
.704 .751 .889 r
.20248 .4447 .21935 .46118 .24447 .44868 .2277 .43267 Metetra
.709 .76 .892 r
.2277 .43267 .24447 .44868 .26979 .43573 .25313 .42025 Metetra
.706 .768 .9 r
.25313 .42025 .26979 .43573 .29525 .42312 .27872 .40809 Metetra
.695 .774 .912 r
.27872 .40809 .29525 .42312 .32083 .41152 .30443 .39678 Metetra
.675 .775 .926 r
.30443 .39678 .32083 .41152 .34652 .40144 .33028 .38674 Metetra
.648 .771 .938 r
.33028 .38674 .34652 .40144 .37235 .39312 .35628 .37819 Metetra
.621 .761 .946 r
.35628 .37819 .37235 .39312 .39836 .38648 .38247 .37106 Metetra
.598 .748 .949 r
.38247 .37106 .39836 .38648 .42463 .38116 .40891 .36502 Metetra
.587 .736 .946 r
.40891 .36502 .42463 .38116 .4512 .37653 .43565 .35956 Metetra
.59 .728 .939 r
.43565 .35956 .4512 .37653 .47811 .37184 .46272 .35403 Metetra
.604 .724 .93 r
.46272 .35403 .47811 .37184 .50537 .36632 .49014 .34777 Metetra
.625 .725 .919 r
.49014 .34777 .50537 .36632 .53297 .35932 .5179 .34025 Metetra
.648 .729 .908 r
.5179 .34025 .53297 .35932 .56086 .35043 .54596 .3311 Metetra
.671 .737 .9 r
.54596 .3311 .56086 .35043 .58901 .33954 .5743 .32023 Metetra
.689 .746 .895 r
.5743 .32023 .58901 .33954 .61738 .32688 .60287 .30785 Metetra
.702 .756 .894 r
.60287 .30785 .61738 .32688 .64593 .31297 .63165 .29438 Metetra
.708 .765 .897 r
.63165 .29438 .64593 .31297 .67468 .29853 .66065 .28045 Metetra
.705 .773 .905 r
.66065 .28045 .67468 .29853 .70367 .28435 .6899 .26671 Metetra
.694 .778 .916 r
.6899 .26671 .70367 .28435 .73295 .27115 .71945 .25379 Metetra
.675 .777 .927 r
.71945 .25379 .73295 .27115 .7626 .25947 .74935 .24215 Metetra
.651 .771 .937 r
.74935 .24215 .7626 .25947 .79269 .24957 .77968 .232 Metetra
.651 .734 .91 r
.11128 .45664 .12878 .47334 .15297 .46536 .13558 .44847 Metetra
.671 .738 .901 r
.13558 .44847 .15297 .46536 .17755 .45575 .16028 .43889 Metetra
.687 .744 .895 r
.16028 .43889 .17755 .45575 .20248 .4447 .18531 .42809 Metetra
.698 .752 .893 r
.18531 .42809 .20248 .4447 .2277 .43267 .21063 .41643 Metetra
.702 .759 .896 r
.21063 .41643 .2277 .43267 .25313 .42025 .23617 .40442 Metetra
.699 .766 .903 r
.23617 .40442 .25313 .42025 .27872 .40809 .26188 .39262 Metetra
.689 .77 .914 r
.26188 .39262 .27872 .40809 .30443 .39678 .28774 .38153 Metetra
.672 .771 .925 r
.28774 .38153 .30443 .39678 .33028 .38674 .31374 .37151 Metetra
.65 .768 .935 r
.31374 .37151 .33028 .38674 .35628 .37819 .33991 .36273 Metetra
.627 .76 .942 r
.33991 .36273 .35628 .37819 .38247 .37106 .36628 .35514 Metetra
.609 .749 .944 r
.36628 .35514 .38247 .37106 .40891 .36502 .3929 .34847 Metetra
.599 .739 .942 r
.3929 .34847 .40891 .36502 .43565 .35956 .41981 .34227 Metetra
.601 .732 .937 r
.41981 .34227 .43565 .35956 .46272 .35403 .44705 .336 Metetra
.612 .728 .928 r
.44705 .336 .46272 .35403 .49014 .34777 .47464 .32909 Metetra
.629 .729 .919 r
.47464 .32909 .49014 .34777 .5179 .34025 .50256 .32108 Metetra
.649 .733 .91 r
.50256 .32108 .5179 .34025 .54596 .3311 .53079 .31168 Metetra
.669 .739 .903 r
.53079 .31168 .54596 .3311 .5743 .32023 .55932 .3008 Metetra
.685 .747 .899 r
.55932 .3008 .5743 .32023 .60287 .30785 .58809 .28862 Metetra
.696 .756 .898 r
.58809 .28862 .60287 .30785 .63165 .29438 .6171 .2755 Metetra
.7 .764 .901 r
.6171 .2755 .63165 .29438 .66065 .28045 .64635 .26196 Metetra
.698 .77 .908 r
.64635 .26196 .66065 .28045 .6899 .26671 .67585 .24857 Metetra
.688 .774 .916 r
.67585 .24857 .6899 .26671 .71945 .25379 .70566 .23585 Metetra
.672 .773 .926 r
.70566 .23585 .71945 .25379 .74935 .24215 .73581 .2242 Metetra
.652 .768 .934 r
.73581 .2242 .74935 .24215 .77968 .232 .76638 .2138 Metetra
.651 .736 .912 r
.09345 .43987 .11128 .45664 .13558 .44847 .11788 .43151 Metetra
.669 .74 .904 r
.11788 .43151 .13558 .44847 .16028 .43889 .14268 .42194 Metetra
.683 .746 .899 r
.14268 .42194 .16028 .43889 .18531 .42809 .16783 .41131 Metetra
.692 .752 .898 r
.16783 .41131 .18531 .42809 .21063 .41643 .19325 .39994 Metetra
.696 .758 .9 r
.19325 .39994 .21063 .41643 .23617 .40442 .2189 .38826 Metetra
.693 .764 .906 r
.2189 .38826 .23617 .40442 .26188 .39262 .24474 .37674 Metetra
.684 .768 .915 r
.24474 .37674 .26188 .39262 .28774 .38153 .27075 .3658 Metetra
.669 .768 .924 r
.27075 .3658 .28774 .38153 .31374 .37151 .29691 .35576 Metetra
.651 .765 .933 r
.29691 .35576 .31374 .37151 .33991 .36273 .32324 .34676 Metetra
.632 .758 .939 r
.32324 .34676 .33991 .36273 .36628 .35514 .34979 .33876 Metetra
.617 .75 .941 r
.34979 .33876 .36628 .35514 .3929 .34847 .37658 .33152 Metetra
.609 .741 .939 r
.37658 .33152 .3929 .34847 .41981 .34227 .40367 .32466 Metetra
.61 .735 .934 r
.40367 .32466 .41981 .34227 .44705 .336 .43109 .31772 Metetra
.619 .732 .927 r
.43109 .31772 .44705 .336 .47464 .32909 .45884 .31023 Metetra
.633 .733 .919 r
.45884 .31023 .47464 .32909 .50256 .32108 .48693 .30178 Metetra
.65 .736 .912 r
.48693 .30178 .50256 .32108 .53079 .31168 .51535 .29213 Metetra
.667 .741 .906 r
.51535 .29213 .53079 .31168 .55932 .3008 .54406 .28121 Metetra
.681 .748 .902 r
.54406 .28121 .55932 .3008 .58809 .28862 .57304 .26916 Metetra
.69 .755 .901 r
.57304 .26916 .58809 .28862 .6171 .2755 .60227 .2563 Metetra
.694 .762 .904 r
.60227 .2563 .6171 .2755 .64635 .26196 .63176 .24306 Metetra
.692 .768 .91 r
.63176 .24306 .64635 .26196 .67585 .24857 .66151 .22993 Metetra
.684 .771 .917 r
.66151 .22993 .67585 .24857 .70566 .23585 .69157 .21735 Metetra
.67 .77 .925 r
.69157 .21735 .70566 .23585 .73581 .2242 .72198 .20566 Metetra
.653 .765 .932 r
.72198 .20566 .73581 .2242 .76638 .2138 .75278 .19501 Metetra
.652 .739 .913 r
.07529 .42299 .09345 .43987 .11788 .43151 .09985 .41444 Metetra
.667 .742 .906 r
.09985 .41444 .11788 .43151 .14268 .42194 .12477 .40485 Metetra
.679 .747 .902 r
.12477 .40485 .14268 .42194 .16783 .41131 .15002 .39434 Metetra
.687 .752 .901 r
.15002 .39434 .16783 .41131 .19325 .39994 .17555 .38319 Metetra
.69 .758 .903 r
.17555 .38319 .19325 .39994 .2189 .38826 .20132 .37176 Metetra
.688 .762 .908 r
.20132 .37176 .2189 .38826 .24474 .37674 .22729 .36044 Metetra
.68 .765 .915 r
.22729 .36044 .24474 .37674 .27075 .3658 .25344 .34961 Metetra
.667 .766 .923 r
.25344 .34961 .27075 .3658 .29691 .35576 .27976 .33953 Metetra
.652 .763 .931 r
.27976 .33953 .29691 .35576 .32324 .34676 .30626 .33031 Metetra
.636 .757 .936 r
.30626 .33031 .32324 .34676 .34979 .33876 .33298 .32192 Metetra
.623 .75 .938 r
.33298 .32192 .34979 .33876 .37658 .33152 .35996 .31417 Metetra
.617 .743 .936 r
.35996 .31417 .37658 .33152 .40367 .32466 .38723 .30672 Metetra
.617 .738 .932 r
.38723 .30672 .40367 .32466 .43109 .31772 .41482 .29918 Metetra
.625 .735 .926 r
.41482 .29918 .43109 .31772 .45884 .31023 .44275 .29115 Metetra
.637 .736 .92 r
.44275 .29115 .45884 .31023 .48693 .30178 .47102 .2823 Metetra
.651 .738 .913 r
.47102 .2823 .48693 .30178 .51535 .29213 .49961 .27241 Metetra
.665 .743 .908 r
.49961 .27241 .51535 .29213 .54406 .28121 .52852 .26142 Metetra
.677 .749 .905 r
.52852 .26142 .54406 .28121 .57304 .26916 .5577 .24945 Metetra
.685 .755 .904 r
.5577 .24945 .57304 .26916 .60227 .2563 .58716 .23677 Metetra
.689 .761 .907 r
.58716 .23677 .60227 .2563 .63176 .24306 .61688 .22375 Metetra
.687 .765 .911 r
.61688 .22375 .63176 .24306 .66151 .22993 .64688 .21081 Metetra
.679 .768 .918 r
.64688 .21081 .66151 .22993 .69157 .21735 .67719 .19831 Metetra
.668 .767 .924 r
.67719 .19831 .69157 .21735 .72198 .20566 .70784 .18654 Metetra
.653 .763 .93 r
.70784 .18654 .72198 .20566 .75278 .19501 .73889 .17564 Metetra
.653 .741 .914 r
.05679 .40597 .07529 .42299 .09985 .41444 .08147 .39723 Metetra
.665 .744 .909 r
.08147 .39723 .09985 .41444 .12477 .40485 .10651 .38759 Metetra
.676 .748 .905 r
.10651 .38759 .12477 .40485 .15002 .39434 .13188 .37716 Metetra
.683 .752 .904 r
.13188 .37716 .15002 .39434 .17555 .38319 .15753 .36616 Metetra
.685 .757 .906 r
.15753 .36616 .17555 .38319 .20132 .37176 .18342 .35491 Metetra
.683 .761 .91 r
.18342 .35491 .20132 .37176 .22729 .36044 .20952 .34375 Metetra
.676 .763 .916 r
.20952 .34375 .22729 .36044 .25344 .34961 .23581 .33297 Metetra
.666 .763 .923 r
.23581 .33297 .25344 .34961 .27976 .33953 .26229 .32282 Metetra
.653 .761 .929 r
.26229 .32282 .27976 .33953 .30626 .33031 .28896 .31339 Metetra
.639 .756 .933 r
.28896 .31339 .30626 .33031 .33298 .32192 .31586 .30464 Metetra
.629 .751 .935 r
.31586 .30464 .33298 .32192 .35996 .31417 .34302 .29641 Metetra
.623 .745 .934 r
.34302 .29641 .35996 .31417 .38723 .30672 .37047 .28843 Metetra
.624 .74 .931 r
.37047 .28843 .38723 .30672 .41482 .29918 .39824 .28035 Metetra
.63 .738 .926 r
.39824 .28035 .41482 .29918 .44275 .29115 .42635 .27184 Metetra
.64 .738 .92 r
.42635 .27184 .44275 .29115 .47102 .2823 .4548 .26261 Metetra
.652 .74 .914 r
.4548 .26261 .47102 .2823 .49961 .27241 .48358 .25247 Metetra
.664 .744 .91 r
.48358 .25247 .49961 .27241 .52852 .26142 .51268 .24139 Metetra
.674 .749 .907 r
.51268 .24139 .52852 .26142 .5577 .24945 .54207 .22945 Metetra
.681 .755 .907 r
.54207 .22945 .5577 .24945 .58716 .23677 .57174 .21689 Metetra
.684 .76 .909 r
.57174 .21689 .58716 .23677 .61688 .22375 .60169 .20402 Metetra
.682 .763 .913 r
.60169 .20402 .61688 .22375 .64688 .21081 .63194 .1912 Metetra
.676 .765 .918 r
.63194 .1912 .64688 .21081 .67719 .19831 .6625 .17873 Metetra
.666 .764 .924 r
.6625 .17873 .67719 .19831 .70784 .18654 .6934 .16686 Metetra
.654 .761 .928 r
.6934 .16686 .70784 .18654 .73889 .17564 .72469 .1557 Metetra
.653 .742 .915 r
.03794 .38877 .05679 .40597 .08147 .39723 .06276 .37984 Metetra
.664 .745 .91 r
.06276 .37984 .08147 .39723 .10651 .38759 .08792 .37013 Metetra
.673 .748 .907 r
.08792 .37013 .10651 .38759 .13188 .37716 .1134 .35974 Metetra
.679 .752 .907 r
.1134 .35974 .13188 .37716 .15753 .36616 .13917 .34884 Metetra
.681 .756 .908 r
.13917 .34884 .15753 .36616 .18342 .35491 .16519 .33772 Metetra
.679 .759 .912 r
.16519 .33772 .18342 .35491 .20952 .34375 .19142 .32665 Metetra
.673 .761 .917 r
.19142 .32665 .20952 .34375 .23581 .33297 .21786 .3159 Metetra
.664 .761 .922 r
.21786 .3159 .23581 .33297 .26229 .32282 .24449 .30565 Metetra
.653 .759 .928 r
.24449 .30565 .26229 .32282 .28896 .31339 .27134 .296 Metetra
.642 .756 .931 r
.27134 .296 .28896 .31339 .31586 .30464 .29841 .28692 Metetra
.633 .751 .933 r
.29841 .28692 .31586 .30464 .34302 .29641 .32575 .27826 Metetra
.629 .746 .932 r
.32575 .27826 .34302 .29641 .37047 .28843 .35339 .26979 Metetra
.629 .742 .929 r
.35339 .26979 .37047 .28843 .39824 .28035 .38134 .26122 Metetra
.634 .74 .925 r
.38134 .26122 .39824 .28035 .42635 .27184 .40963 .25226 Metetra
.642 .74 .92 r
.40963 .25226 .42635 .27184 .4548 .26261 .43827 .24267 Metetra
.652 .742 .915 r
.43827 .24267 .4548 .26261 .48358 .25247 .46724 .23229 Metetra
.663 .745 .912 r
.46724 .23229 .48358 .25247 .51268 .24139 .49653 .22109 Metetra
.671 .75 .909 r
.49653 .22109 .51268 .24139 .54207 .22945 .52613 .20914 Metetra
.677 .754 .909 r
.52613 .20914 .54207 .22945 .57174 .21689 .55602 .19665 Metetra
.68 .758 .911 r
.55602 .19665 .57174 .21689 .60169 .20402 .5862 .18387 Metetra
.678 .762 .914 r
.5862 .18387 .60169 .20402 .63194 .1912 .61669 .1711 Metetra
.673 .763 .918 r
.61669 .1711 .63194 .1912 .6625 .17873 .6475 .15862 Metetra
.664 .762 .923 r
.6475 .15862 .6625 .17873 .6934 .16686 .67865 .14662 Metetra
.654 .759 .927 r
.67865 .14662 .6934 .16686 .72469 .1557 .71019 .13521 Metetra
.653 .744 .916 r
.01874 .37137 .03794 .38877 .06276 .37984 .04369 .36225 Metetra
.663 .746 .912 r
.04369 .36225 .06276 .37984 .08792 .37013 .06897 .35246 Metetra
.67 .749 .909 r
.06897 .35246 .08792 .37013 .1134 .35974 .09458 .34206 Metetra
.675 .752 .909 r
.09458 .34206 .1134 .35974 .13917 .34884 .12046 .33123 Metetra
.677 .756 .91 r
.12046 .33123 .13917 .34884 .16519 .33772 .14661 .32018 Metetra
.676 .758 .913 r
.14661 .32018 .16519 .33772 .19142 .32665 .17298 .30916 Metetra
.671 .76 .917 r
.17298 .30916 .19142 .32665 .21786 .3159 .19957 .29839 Metetra
.663 .76 .922 r
.19957 .29839 .21786 .3159 .24449 .30565 .22636 .28804 Metetra
.654 .758 .926 r
.22636 .28804 .24449 .30565 .27134 .296 .25338 .27817 Metetra
.644 .755 .929 r
.25338 .27817 .27134 .296 .29841 .28692 .28063 .26877 Metetra
.637 .751 .931 r
.28063 .26877 .29841 .28692 .32575 .27826 .30815 .25971 Metetra
.633 .747 .93 r
.30815 .25971 .32575 .27826 .35339 .26979 .33597 .25079 Metetra
.633 .744 .928 r
.33597 .25079 .35339 .26979 .38134 .26122 .36411 .24176 Metetra
.637 .742 .924 r
.36411 .24176 .38134 .26122 .40963 .25226 .39259 .23239 Metetra
.644 .742 .92 r
.39259 .23239 .40963 .25226 .43827 .24267 .42141 .22246 Metetra
.653 .744 .916 r
.42141 .22246 .43827 .24267 .46724 .23229 .45057 .21184 Metetra
.661 .746 .913 r
.45057 .21184 .46724 .23229 .49653 .22109 .48006 .2005 Metetra
.669 .75 .911 r
.48006 .2005 .49653 .22109 .52613 .20914 .50987 .1885 Metetra
.674 .754 .911 r
.50987 .1885 .52613 .20914 .55602 .19665 .53998 .17602 Metetra
.676 .757 .912 r
.53998 .17602 .55602 .19665 .5862 .18387 .5704 .16328 Metetra
.675 .76 .915 r
.5704 .16328 .5862 .18387 .61669 .1711 .60112 .15052 Metetra
.67 .761 .919 r
.60112 .15052 .61669 .1711 .6475 .15862 .63218 .13799 Metetra
.663 .761 .923 r
.63218 .13799 .6475 .15862 .67865 .14662 .66358 .12584 Metetra
.655 .758 .926 r
.66358 .12584 .67865 .14662 .71019 .13521 .69536 .11417 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.6"]
}, Open  ]],

Cell["\<\
This creates a two\[Hyphen]dimensional graphics object which \
contains two copies of the three\[Hyphen]dimensional plot. \
\>", \
"MathCaption",
  CellTags->{"S2.10.6", "6.4"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics[ {Rectangle[{0, 0}, {1, 1}, p3], Rectangle[{0.8, \
0.8}, {1.2, 1.4}, p3]} ]]\
\>", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.6"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.0147151 0.420431 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0147151 0.81746 0.435146 MathSubStart
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.3209e-17 1.04977 -0.0679587 1.04977 [
[.08608 .22315 -12 -8.87306 ]
[.08608 .22315 0 .12694 ]
[.20731 .17545 -11.6738 -9 ]
[.20731 .17545 .32622 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.46808 .07289 -5.33651 -9 ]
[.46808 .07289 .66349 0 ]
[.60856 .01769 -5.08632 -9 ]
[.60856 .01769 .91368 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.0226 .27459 -12 -2.75033 ]
[.0226 .27459 0 6.24967 ]
[.0149 .32285 -12 -2.79114 ]
[.0149 .32285 0 6.20886 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00124 .42403 -6 -2.87714 ]
[-0.00124 .42403 0 6.12286 ]
[-0.00971 .47711 -6 -2.92248 ]
[-0.00971 .47711 0 6.07752 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03483 .26984 m
.04095 .26746 L
s
[(-4)] .0226 .27459 1 -0.38882 Mshowa
.02717 .31819 m
.0333 .31586 L
s
[(-2)] .0149 .32285 1 -0.37975 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.0111 .41958 m
.01727 .41735 L
s
[(2)] -0.00124 .42403 1 -0.36063 Mshowa
.00267 .47277 m
.00886 .4706 L
s
[(4)] -0.00971 .47711 1 -0.35056 Mshowa
.125 Mabswid
.03294 .28179 m
.03661 .28037 L
s
.03103 .29383 m
.0347 .29242 L
s
.02911 .30596 m
.03278 .30456 L
s
.02521 .33052 m
.0289 .32913 L
s
.02325 .34294 m
.02693 .34156 L
s
.02126 .35546 m
.02495 .35409 L
s
.01725 .3808 m
.02094 .37944 L
s
.01521 .39362 m
.01891 .39227 L
s
.01317 .40655 m
.01687 .40521 L
s
.00902 .43272 m
.01273 .43139 L
s
.00692 .44596 m
.01063 .44464 L
s
.0048 .45931 m
.00852 .458 L
s
.03671 .25798 m
.04038 .25655 L
s
.00052 .48634 m
.00424 .48505 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.645 .763 .934 r
.38427 .80015 .39787 .81114 .42053 .8052 .40705 .79412 Metetra
.645 .763 .934 r
.40705 .79412 .42053 .8052 .44337 .79922 .43002 .78805 Metetra
.855 .774 .771 r
.43002 .78805 .44337 .79922 .46657 .78346 .45369 .75629 Metetra
.849 .677 .667 r
.45369 .75629 .46657 .78346 .49041 .70966 .47766 .69282 Metetra
.89 .722 .666 r
.47766 .69282 .49041 .70966 .51358 .63251 .50111 .62616 Metetra
.93 .786 .679 r
.50111 .62616 .51358 .63251 .53604 .56396 .52395 .56651 Metetra
.892 .976 .819 r
.52395 .56651 .53604 .56396 .55843 .55287 .54648 .54028 Metetra
.664 .741 .907 r
.54648 .54028 .55843 .55287 .58103 .54607 .5692 .53338 Metetra
.664 .741 .907 r
.5692 .53338 .58103 .54607 .6038 .53922 .5921 .52642 Metetra
.664 .741 .907 r
.5921 .52642 .6038 .53922 .62677 .53231 .61519 .5194 Metetra
.764 .298 0 r
.61519 .5194 .62677 .53231 .65128 .56179 .64008 .55937 Metetra
.88 .453 .178 r
.64008 .55937 .65128 .56179 .67796 .62396 .66632 .61126 Metetra
.845 .404 0 r
.66632 .61126 .67796 .62396 .70599 .68929 .69374 .66547 Metetra
0 0 .481 r
.69374 .66547 .70599 .68929 .73344 .72328 .72177 .71087 Metetra
.645 .763 .934 r
.72177 .71087 .73344 .72328 .75902 .71659 .74752 .70406 Metetra
.645 .763 .934 r
.74752 .70406 .75902 .71659 .78483 .70983 .77349 .69719 Metetra
.645 .763 .934 r
.77349 .69719 .78483 .70983 .81088 .70301 .7997 .69026 Metetra
.859 .809 .799 r
.7997 .69026 .81088 .70301 .83671 .69107 .82423 .66089 Metetra
.872 .691 .654 r
.82423 .66089 .83671 .69107 .85649 .61468 .84525 .59513 Metetra
.924 .746 .643 r
.84525 .59513 .85649 .61468 .87498 .53394 .86518 .5253 Metetra
.969 .821 .641 r
.86518 .5253 .87498 .53394 .89346 .46136 .88507 .46206 Metetra
.902 .986 .749 r
.88507 .46206 .89346 .46136 .91786 .44473 .90803 .43044 Metetra
.664 .741 .907 r
.90803 .43044 .91786 .44473 .94349 .43702 .93382 .4226 Metetra
.664 .741 .907 r
.93382 .4226 .94349 .43702 .96935 .42924 .95984 .4147 Metetra
.645 .763 .934 r
.37046 .78898 .38427 .80015 .40705 .79412 .39336 .78287 Metetra
.686 .772 .917 r
.39336 .78287 .40705 .79412 .43002 .78805 .41652 .77434 Metetra
.869 .746 .725 r
.41652 .77434 .43002 .78805 .45369 .75629 .44067 .73134 Metetra
.845 .684 .682 r
.44067 .73134 .45369 .75629 .47766 .69282 .46474 .67655 Metetra
.884 .728 .683 r
.46474 .67655 .47766 .69282 .50111 .62616 .48841 .6188 Metetra
.92 .79 .701 r
.48841 .6188 .50111 .62616 .52395 .56651 .51157 .56678 Metetra
.944 .893 .748 r
.51157 .56678 .52395 .56651 .54648 .54028 .53435 .52764 Metetra
.666 .744 .908 r
.53435 .52764 .54648 .54028 .5692 .53338 .55719 .52049 Metetra
.664 .741 .907 r
.55719 .52049 .5692 .53338 .5921 .52642 .58021 .51342 Metetra
.221 .53 .921 r
.58021 .51342 .5921 .52642 .61519 .5194 .60381 .52198 Metetra
.811 .358 .16 r
.60381 .52198 .61519 .5194 .64008 .55937 .62857 .55526 Metetra
.851 .394 .087 r
.62857 .55526 .64008 .55937 .66632 .61126 .6545 .59836 Metetra
.78 .317 0 r
.6545 .59836 .66632 .61126 .69374 .66547 .68144 .64314 Metetra
0 .006 .578 r
.68144 .64314 .69374 .66547 .72177 .71087 .70897 .68044 Metetra
.441 .474 .798 r
.70897 .68044 .72177 .71087 .74752 .70406 .73581 .69133 Metetra
.645 .763 .934 r
.73581 .69133 .74752 .70406 .77349 .69719 .76196 .68434 Metetra
.648 .764 .934 r
.76196 .68434 .77349 .69719 .7997 .69026 .78832 .67713 Metetra
.908 .8 .73 r
.78832 .67713 .7997 .69026 .82423 .66089 .81188 .63313 Metetra
.866 .699 .673 r
.81188 .63313 .82423 .66089 .84525 .59513 .83395 .57627 Metetra
.915 .753 .666 r
.83395 .57627 .84525 .59513 .86518 .5253 .8551 .5157 Metetra
.957 .826 .674 r
.8551 .5157 .86518 .5253 .88507 .46206 .87622 .46047 Metetra
.964 .932 .703 r
.87622 .46047 .88507 .46206 .90803 .43044 .89828 .41808 Metetra
.696 .788 .922 r
.89828 .41808 .90803 .43044 .93382 .4226 .92399 .40795 Metetra
.664 .741 .907 r
.92399 .40795 .93382 .4226 .95984 .4147 .95018 .39992 Metetra
.597 .639 .863 r
.3568 .76968 .37046 .78898 .39336 .78287 .37962 .76707 Metetra
.788 .731 .8 r
.37962 .76707 .39336 .78287 .41652 .77434 .40333 .74563 Metetra
.795 .654 .708 r
.40333 .74563 .41652 .77434 .44067 .73134 .42748 .70823 Metetra
.84 .691 .698 r
.42748 .70823 .44067 .73134 .46474 .67655 .45164 .66073 Metetra
.876 .733 .701 r
.45164 .66073 .46474 .67655 .48841 .6188 .47549 .61053 Metetra
.908 .793 .722 r
.47549 .61053 .48841 .6188 .51157 .56678 .49892 .56505 Metetra
.925 .888 .777 r
.49892 .56505 .51157 .56678 .53435 .52764 .52201 .53045 Metetra
.786 .997 .858 r
.52201 .53045 .53435 .52764 .55719 .52049 .54501 .51095 Metetra
.539 .762 .979 r
.54501 .51095 .55719 .52049 .58021 .51342 .56825 .50843 Metetra
.45 0 0 r
.56825 .50843 .58021 .51342 .60381 .52198 .59209 .52234 Metetra
.773 .28 .049 r
.59209 .52234 .60381 .52198 .62857 .55526 .61679 .54969 Metetra
.803 .312 0 r
.61679 .54969 .62857 .55526 .6545 .59836 .64248 .58525 Metetra
.684 .204 0 r
.64248 .58525 .6545 .59836 .68144 .64314 .66907 .62204 Metetra
0 .121 .671 r
.66907 .62204 .68144 .64314 .70897 .68044 .69621 .65232 Metetra
.32 .418 .806 r
.69621 .65232 .70897 .68044 .73581 .69133 .72338 .66896 Metetra
.582 .617 .852 r
.72338 .66896 .73581 .69133 .76196 .68434 .74996 .66717 Metetra
.788 .751 .819 r
.74996 .66717 .76196 .68434 .78832 .67713 .77545 .64573 Metetra
.802 .662 .708 r
.77545 .64573 .78832 .67713 .81188 .63313 .79961 .60735 Metetra
.859 .707 .692 r
.79961 .60735 .81188 .63313 .83395 .57627 .82256 .55797 Metetra
.905 .76 .689 r
.82256 .55797 .83395 .57627 .8551 .5157 .84477 .50524 Metetra
.942 .83 .705 r
.84477 .50524 .8551 .5157 .87622 .46047 .86694 .45685 Metetra
.947 .931 .75 r
.86694 .45685 .87622 .46047 .89828 .41808 .88991 .41932 Metetra
.752 .992 .797 r
.88991 .41932 .89828 .41808 .92399 .40795 .91449 .3971 Metetra
.586 .778 .971 r
.91449 .3971 .92399 .40795 .95018 .39992 .94132 .39232 Metetra
.607 .575 .792 r
.3434 .74187 .3568 .76968 .37962 .76707 .36626 .73854 Metetra
.726 .628 .748 r
.36626 .73854 .37962 .76707 .40333 .74563 .38995 .71934 Metetra
.79 .663 .724 r
.38995 .71934 .40333 .74563 .42748 .70823 .41411 .68662 Metetra
.833 .698 .714 r
.41411 .68662 .42748 .70823 .45164 .66073 .43834 .64526 Metetra
.867 .739 .719 r
.43834 .64526 .45164 .66073 .47549 .61053 .46235 .60147 Metetra
.895 .795 .743 r
.46235 .60147 .47549 .61053 .49892 .56505 .48601 .56156 Metetra
.904 .881 .802 r
.48601 .56156 .49892 .56505 .52201 .53045 .50938 .53086 Metetra
.79 .982 .901 r
.50938 .53086 .52201 .53045 .54501 .51095 .53265 .51305 Metetra
.53265 .51305 .54501 .51095 .56825 .50843 .5561 .50979 Metetra
.532 0 0 r
.5561 .50979 .56825 .50843 .59209 .52234 .58005 .52059 Metetra
.706 .17 0 r
.58005 .52059 .59209 .52234 .61679 .54969 .60473 .54281 Metetra
.724 .201 0 r
.60473 .54281 .61679 .54969 .64248 .58525 .63027 .57192 Metetra
.554 .068 0 r
.63027 .57192 .64248 .58525 .66907 .62204 .6566 .60193 Metetra
0 .231 .751 r
.6566 .60193 .66907 .62204 .69621 .65232 .68346 .62628 Metetra
.362 .463 .829 r
.68346 .62628 .69621 .65232 .72338 .66896 .71041 .63905 Metetra
.597 .57 .794 r
.71041 .63905 .72338 .66896 .74996 .66717 .73696 .63625 Metetra
.72 .628 .754 r
.73696 .63625 .74996 .66717 .77545 .64573 .76268 .61689 Metetra
.796 .672 .727 r
.76268 .61689 .77545 .64573 .79961 .60735 .78736 .5832 Metetra
.851 .715 .713 r
.78736 .5832 .79961 .60735 .82256 .55797 .81107 .5401 Metetra
.894 .765 .713 r
.81107 .5401 .82256 .55797 .84477 .50524 .83418 .494 Metetra
.925 .832 .734 r
.83418 .494 .84477 .50524 .86694 .45685 .85728 .45146 Metetra
.926 .923 .789 r
.85728 .45146 .86694 .45685 .88991 .41932 .88105 .41808 Metetra
.777 .995 .871 r
.88105 .41808 .88991 .41932 .91449 .3971 .90619 .39778 Metetra
.195 .724 .759 r
.90619 .39778 .91449 .3971 .94132 .39232 .93327 .39241 Metetra
.613 .595 .808 r
.32978 .71634 .3434 .74187 .36626 .73854 .35268 .7124 Metetra
.723 .64 .765 r
.35268 .7124 .36626 .73854 .38995 .71934 .37638 .69505 Metetra
.785 .673 .74 r
.37638 .69505 .38995 .71934 .41411 .68662 .40055 .66625 Metetra
.826 .705 .731 r
.40055 .66625 .41411 .68662 .43834 .64526 .42483 .63005 Metetra
.858 .744 .737 r
.42483 .63005 .43834 .64526 .46235 .60147 .44898 .59169 Metetra
.88 .797 .763 r
.44898 .59169 .46235 .60147 .48601 .56156 .47284 .55654 Metetra
.882 .872 .823 r
.47284 .55654 .48601 .56156 .50938 .53086 .49646 .52918 Metetra
.784 .958 .925 r
.49646 .52918 .50938 .53086 .53265 .51305 .51998 .51281 Metetra
.258 .766 .851 r
.51998 .51281 .53265 .51305 .5561 .50979 .54364 .50889 Metetra
.375 0 0 r
.54364 .50889 .5561 .50979 .58005 .52059 .56771 .51698 Metetra
.595 .023 0 r
.56771 .51698 .58005 .52059 .60473 .54281 .59241 .53479 Metetra
.602 .057 0 r
.59241 .53479 .60473 .54281 .63027 .57192 .61786 .55837 Metetra
0 .083 .597 r
.61786 .55837 .63027 .57192 .6566 .60193 .64401 .58262 Metetra
.035 .33 .813 r
.64401 .58262 .6566 .60193 .68346 .62628 .67066 .60196 Metetra
.401 .503 .848 r
.67066 .60196 .68346 .62628 .71041 .63905 .69747 .61145 Metetra
.604 .59 .81 r
.69747 .61145 .71041 .63905 .73696 .63625 .72402 .60779 Metetra
.717 .641 .771 r
.72402 .60779 .73696 .63625 .76268 .61689 .74996 .59014 Metetra
.79 .681 .745 r
.74996 .59014 .76268 .61689 .78736 .5832 .77509 .56036 Metetra
.841 .723 .733 r
.77509 .56036 .78736 .5832 .81107 .5401 .79946 .52254 Metetra
.881 .77 .736 r
.79946 .52254 .81107 .5401 .83418 .494 .82335 .48206 Metetra
.907 .832 .761 r
.82335 .48206 .83418 .494 .85728 .45146 .84725 .4445 Metetra
.902 .912 .82 r
.84725 .4445 .85728 .45146 .88105 .41808 .87173 .41468 Metetra
.781 .977 .912 r
.87173 .41468 .88105 .41808 .90619 .39778 .89738 .39601 Metetra
.353 .823 .9 r
.89738 .39601 .90619 .39778 .93327 .39241 .9247 .39011 Metetra
.619 .613 .823 r
.31592 .6927 .32978 .71634 .35268 .7124 .33888 .68822 Metetra
.72 .652 .781 r
.33888 .68822 .35268 .7124 .37638 .69505 .36259 .67241 Metetra
.779 .682 .756 r
.36259 .67241 .37638 .69505 .40055 .66625 .38678 .64688 Metetra
.818 .712 .748 r
.38678 .64688 .40055 .66625 .42483 .63005 .41112 .61503 Metetra
.847 .749 .755 r
.41112 .61503 .42483 .63005 .44898 .59169 .43538 .58127 Metetra
.865 .797 .782 r
.43538 .58127 .44898 .59169 .47284 .55654 .45943 .55016 Metetra
.86 .863 .84 r
.45943 .55016 .47284 .55654 .49646 .52918 .48327 .52565 Metetra
.772 .931 .937 r
.48327 .52565 .49646 .52918 .51998 .51281 .50701 .51051 Metetra
.395 .833 .948 r
.50701 .51051 .51998 .51281 .54364 .50889 .53088 .506 Metetra
.171 0 0 r
.53088 .506 .54364 .50889 .56771 .51698 .55508 .51174 Metetra
.43 0 0 r
.55508 .51174 .56771 .51698 .59241 .53479 .57983 .52575 Metetra
.434 0 0 r
.57983 .52575 .59241 .53479 .61786 .55837 .60524 .5446 Metetra
0 .231 .728 r
.60524 .5446 .61786 .55837 .64401 .58262 .63128 .56393 Metetra
.143 .414 .858 r
.63128 .56393 .64401 .58262 .67066 .60196 .6578 .57904 Metetra
.436 .54 .864 r
.6578 .57904 .67066 .60196 .69747 .61145 .68451 .58576 Metetra
.61 .609 .824 r
.68451 .58576 .69747 .61145 .72402 .60779 .71109 .58135 Metetra
.714 .653 .787 r
.71109 .58135 .72402 .60779 .74996 .59014 .73724 .56512 Metetra
.782 .691 .763 r
.73724 .56512 .74996 .59014 .77509 .56036 .76277 .5386 Metetra
.831 .729 .753 r
.76277 .5386 .77509 .56036 .79946 .52254 .78771 .50521 Metetra
.866 .774 .758 r
.78771 .50521 .79946 .52254 .82335 .48206 .81228 .46948 Metetra
.887 .83 .785 r
.81228 .46948 .82335 .48206 .84725 .4445 .83688 .43615 Metetra
.877 .898 .843 r
.83688 .43615 .84725 .4445 .87173 .41468 .86199 .40937 Metetra
.773 .951 .933 r
.86199 .40937 .87173 .41468 .89738 .39601 .88811 .39207 Metetra
.462 .861 .968 r
.88811 .39207 .89738 .39601 .9247 .39011 .91567 .3857 Metetra
.624 .63 .837 r
.30182 .67059 .31592 .6927 .33888 .68822 .32485 .66565 Metetra
.717 .663 .796 r
.32485 .66565 .33888 .68822 .36259 .67241 .34859 .65111 Metetra
.772 .69 .773 r
.34859 .65111 .36259 .67241 .38678 .64688 .37279 .62832 Metetra
.809 .719 .765 r
.37279 .62832 .38678 .64688 .41112 .61503 .39719 .60013 Metetra
.835 .753 .773 r
.39719 .60013 .41112 .61503 .43538 .58127 .42156 .57026 Metetra
.849 .797 .8 r
.42156 .57026 .43538 .58127 .45943 .55016 .44577 .54259 Metetra
.839 .853 .855 r
.44577 .54259 .45943 .55016 .48327 .52565 .46981 .5205 Metetra
.759 .906 .941 r
.46981 .5205 .48327 .52565 .50701 .51051 .49377 .50639 Metetra
.485 .853 .988 r
.49377 .50639 .50701 .51051 .53088 .506 .51782 .50136 Metetra
.039 .578 .849 r
.51782 .50136 .53088 .506 .55508 .51174 .54218 .50507 Metetra
0 .337 .707 r
.54218 .50507 .55508 .51174 .57983 .52575 .567 .5158 Metetra
0 .278 .721 r
.567 .5158 .57983 .52575 .60524 .5446 .5924 .5306 Metetra
0 .359 .825 r
.5924 .5306 .60524 .5446 .63128 .56393 .61839 .54575 Metetra
.235 .482 .889 r
.61839 .54575 .63128 .56393 .6578 .57904 .64483 .55725 Metetra
.467 .572 .877 r
.64483 .55725 .6578 .57904 .68451 .58576 .67151 .56161 Metetra
.616 .626 .838 r
.67151 .56161 .68451 .58576 .71109 .58135 .69814 .55655 Metetra
.711 .665 .803 r
.69814 .55655 .71109 .58135 .73724 .56512 .72448 .54148 Metetra
.774 .7 .781 r
.72448 .54148 .73724 .56512 .76277 .5386 .75036 .51769 Metetra
.82 .736 .772 r
.75036 .51769 .76277 .5386 .78771 .50521 .77581 .48803 Metetra
.851 .777 .779 r
.77581 .48803 .78771 .50521 .81228 .46948 .80098 .45631 Metetra
.867 .827 .806 r
.80098 .45631 .81228 .46948 .83688 .43615 .82619 .42658 Metetra
.852 .884 .862 r
.82619 .42658 .83688 .43615 .86199 .40937 .85186 .40237 Metetra
.762 .923 .942 r
.85186 .40237 .86199 .40937 .88811 .39207 .87841 .38624 Metetra
.53 .867 .993 r
.87841 .38624 .88811 .39207 .91567 .3857 .90621 .37943 Metetra
.628 .646 .849 r
.28746 .64975 .30182 .67059 .32485 .66565 .31057 .6444 Metetra
.713 .674 .811 r
.31057 .6444 .32485 .66565 .34859 .65111 .33435 .6309 Metetra
.765 .698 .789 r
.33435 .6309 .34859 .65111 .37279 .62832 .35859 .61041 Metetra
.8 .725 .782 r
.35859 .61041 .37279 .62832 .39719 .60013 .38304 .5853 Metetra
.822 .756 .79 r
.38304 .5853 .39719 .60013 .42156 .57026 .40751 .55872 Metetra
.832 .796 .816 r
.40751 .55872 .42156 .57026 .44577 .54259 .43186 .53396 Metetra
.818 .843 .867 r
.43186 .53396 .44577 .54259 .46981 .5205 .45608 .51393 Metetra
.745 .883 .942 r
.45608 .51393 .46981 .5205 .49377 .50639 .48025 .50069 Metetra
.54 .851 .998 r
.48025 .50069 .49377 .50639 .51782 .50136 .50449 .49519 Metetra
.211 .676 .943 r
.50449 .49519 .51782 .50136 .54218 .50507 .529 .49713 Metetra
0 .486 .85 r
.529 .49713 .54218 .50507 .567 .5158 .55392 .50503 Metetra
0 .419 .841 r
.55392 .50503 .567 .5158 .5924 .5306 .57936 .51636 Metetra
.097 .46 .888 r
.57936 .51636 .5924 .5306 .61839 .54575 .60533 .52794 Metetra
.311 .537 .909 r
.60533 .52794 .61839 .54575 .64483 .55725 .63174 .53637 Metetra
.495 .599 .887 r
.63174 .53637 .64483 .55725 .67151 .56161 .65841 .53873 Metetra
.622 .642 .85 r
.65841 .53873 .67151 .56161 .69814 .55655 .68512 .53309 Metetra
.707 .676 .818 r
.68512 .53309 .69814 .55655 .72448 .54148 .71164 .51898 Metetra
.766 .708 .797 r
.71164 .51898 .72448 .54148 .75036 .51769 .73785 .49746 Metetra
.808 .741 .79 r
.73785 .49746 .75036 .51769 .77581 .48803 .76374 .47092 Metetra
.835 .779 .798 r
.76374 .47092 .77581 .48803 .80098 .45631 .78943 .4426 Metetra
.847 .823 .825 r
.78943 .4426 .80098 .45631 .82619 .42658 .8152 .4159 Metetra
.828 .869 .875 r
.8152 .4159 .82619 .42658 .85186 .40237 .84137 .39388 Metetra
.749 .898 .945 r
.84137 .39388 .85186 .40237 .87841 .38624 .86832 .37872 Metetra
.571 .858 .996 r
.86832 .37872 .87841 .38624 .90621 .37943 .89634 .37151 Metetra
.632 .66 .859 r
.27285 .62994 .28746 .64975 .31057 .6444 .29604 .62421 Metetra
.708 .684 .824 r
.29604 .62421 .31057 .6444 .33435 .6309 .31987 .61158 Metetra
.757 .706 .804 r
.31987 .61158 .33435 .6309 .35859 .61041 .34415 .59301 Metetra
.789 .73 .798 r
.34415 .59301 .35859 .61041 .38304 .5853 .36866 .57049 Metetra
.81 .759 .806 r
.36866 .57049 .38304 .5853 .40751 .55872 .39322 .54668 Metetra
.816 .794 .831 r
.39322 .54668 .40751 .55872 .43186 .53396 .41771 .52439 Metetra
.799 .833 .877 r
.41771 .52439 .43186 .53396 .45608 .51393 .4421 .5061 Metetra
.733 .863 .941 r
.4421 .5061 .45608 .51393 .48025 .50069 .46646 .49358 Metetra
.575 .842 .995 r
.46646 .49358 .48025 .50069 .50449 .49519 .49089 .48765 Metetra
.336 .728 .983 r
.49089 .48765 .50449 .49519 .529 .49713 .51555 .48807 Metetra
.149 .59 .931 r
.51555 .48807 .529 .49713 .55392 .50503 .54058 .49353 Metetra
.114 .524 .913 r
.54058 .49353 .55392 .50503 .57936 .51636 .56609 .50188 Metetra
.215 .536 .924 r
.56609 .50188 .57936 .51636 .60533 .52794 .59208 .5104 Metetra
.374 .58 .922 r
.59208 .5104 .60533 .52794 .63174 .53637 .6185 .51622 Metetra
.518 .623 .895 r
.6185 .51622 .63174 .53637 .65841 .53873 .6452 .51686 Metetra
.626 .657 .86 r
.6452 .51686 .65841 .53873 .68512 .53309 .67199 .51071 Metetra
.703 .686 .831 r
.67199 .51071 .68512 .53309 .71164 .51898 .6987 .49738 Metetra
.757 .715 .813 r
.6987 .49738 .71164 .51898 .73785 .49746 .72521 .47775 Metetra
.795 .745 .807 r
.72521 .47775 .73785 .49746 .76374 .47092 .75149 .45384 Metetra
.819 .779 .815 r
.75149 .45384 .76374 .47092 .78943 .4426 .77766 .42837 Metetra
.827 .818 .841 r
.77766 .42837 .78943 .4426 .8152 .4159 .80391 .40424 Metetra
.806 .855 .886 r
.80391 .40424 .8152 .4159 .84137 .39388 .83054 .38406 Metetra
.736 .875 .945 r
.83054 .38406 .84137 .39388 .86832 .37872 .85785 .36972 Metetra
.597 .845 .991 r
.85785 .36972 .86832 .37872 .89634 .37151 .88611 .36214 Metetra
.636 .673 .869 r
.25797 .61095 .27285 .62994 .29604 .62421 .28126 .60489 Metetra
.704 .693 .837 r
.28126 .60489 .29604 .62421 .31987 .61158 .30514 .59298 Metetra
.749 .713 .818 r
.30514 .59298 .31987 .61158 .34415 .59301 .32946 .576 Metetra
.779 .735 .812 r
.32946 .576 .34415 .59301 .36866 .57049 .35403 .55566 Metetra
.796 .761 .82 r
.35403 .55566 .36866 .57049 .39322 .54668 .37868 .53419 Metetra
.8 .791 .844 r
.37868 .53419 .39322 .54668 .41771 .52439 .40331 .51398 Metetra
.782 .823 .885 r
.40331 .51398 .41771 .52439 .4421 .5061 .42786 .49715 Metetra
.722 .845 .94 r
.42786 .49715 .4421 .5061 .46646 .49358 .4524 .48523 Metetra
.598 .83 .988 r
.4524 .48523 .46646 .49358 .49089 .48765 .47701 .47892 Metetra
.421 .753 .995 r
.47701 .47892 .49089 .48765 .51555 .48807 .50184 .478 Metetra
.277 .654 .968 r
.50184 .478 .51555 .48807 .54058 .49353 .527 .48136 Metetra
.241 .595 .95 r
.527 .48136 .54058 .49353 .56609 .50188 .55259 .48716 Metetra
.308 .59 .943 r
.55259 .48716 .56609 .50188 .59208 .5104 .57864 .49305 Metetra
.424 .614 .929 r
.57864 .49305 .59208 .5104 .6185 .51622 .60509 .49663 Metetra
.539 .643 .901 r
.60509 .49663 .6185 .51622 .6452 .51686 .63185 .4958 Metetra
.631 .67 .87 r
.63185 .4958 .6452 .51686 .67199 .51071 .65875 .4892 Metetra
.698 .695 .843 r
.65875 .4892 .67199 .51071 .6987 .49738 .68564 .47649 Metetra
.748 .721 .827 r
.68564 .47649 .6987 .49738 .72521 .47775 .71241 .45844 Metetra
.783 .749 .822 r
.71241 .45844 .72521 .47775 .75149 .45384 .73906 .43673 Metetra
.804 .779 .83 r
.73906 .43673 .75149 .45384 .77766 .42837 .76564 .41366 Metetra
.808 .812 .854 r
.76564 .41366 .77766 .42837 .80391 .40424 .79234 .39169 Metetra
.787 .842 .894 r
.79234 .39169 .80391 .40424 .83054 .38406 .81939 .37306 Metetra
.725 .855 .943 r
.81939 .37306 .83054 .38406 .85785 .36972 .84704 .35939 Metetra
.614 .831 .983 r
.84704 .35939 .85785 .36972 .88611 .36214 .87552 .35147 Metetra
.639 .684 .877 r
.24282 .59263 .25797 .61095 .28126 .60489 .26621 .58627 Metetra
.699 .701 .848 r
.26621 .58627 .28126 .60489 .30514 .59298 .29016 .57493 Metetra
.741 .719 .831 r
.29016 .57493 .30514 .59298 .32946 .576 .31454 .55929 Metetra
.768 .739 .826 r
.31454 .55929 .32946 .576 .35403 .55566 .33917 .54076 Metetra
.783 .762 .834 r
.33917 .54076 .35403 .55566 .37868 .53419 .36391 .52126 Metetra
.785 .788 .855 r
.36391 .52126 .37868 .53419 .40331 .51398 .38866 .50281 Metetra
.766 .814 .891 r
.38866 .50281 .40331 .51398 .42786 .49715 .41337 .48721 Metetra
.713 .83 .938 r
.41337 .48721 .42786 .49715 .4524 .48523 .43808 .47578 Metetra
.613 .818 .979 r
.43808 .47578 .4524 .48523 .47701 .47892 .46287 .46912 Metetra
.48 .764 .993 r
.46287 .46912 .47701 .47892 .50184 .478 .48786 .46703 Metetra
.37 .692 .981 r
.48786 .46703 .50184 .478 .527 .48136 .51316 .46858 Metetra
.336 .642 .965 r
.51316 .46858 .527 .48136 .55259 .48716 .53886 .47217 Metetra
.38 .63 .952 r
.53886 .47217 .55259 .48716 .57864 .49305 .56498 .47582 Metetra
.466 .641 .933 r
.56498 .47582 .57864 .49305 .60509 .49663 .59151 .47748 Metetra
.557 .661 .906 r
.59151 .47748 .60509 .49663 .63185 .4958 .61834 .47537 Metetra
.634 .682 .878 r
.61834 .47537 .63185 .4958 .65875 .4892 .64535 .46836 Metetra
.694 .704 .854 r
.64535 .46836 .65875 .4892 .68564 .47649 .67242 .45617 Metetra
.739 .726 .84 r
.67242 .45617 .68564 .47649 .71241 .45844 .69945 .43942 Metetra
.77 .751 .836 r
.69945 .43942 .71241 .45844 .73906 .43673 .72642 .41954 Metetra
.788 .778 .844 r
.72642 .41954 .73906 .43673 .76564 .41366 .75339 .39848 Metetra
.79 .806 .865 r
.75339 .39848 .76564 .41366 .79234 .39169 .78049 .37834 Metetra
.769 .83 .9 r
.78049 .37834 .79234 .39169 .81939 .37306 .80792 .361 Metetra
.715 .839 .941 r
.80792 .361 .81939 .37306 .84704 .35939 .83589 .34787 Metetra
.626 .819 .975 r
.83589 .34787 .84704 .35939 .87552 .35147 .86461 .33963 Metetra
.641 .694 .884 r
.2274 .57483 .24282 .59263 .26621 .58627 .25089 .56819 Metetra
.695 .709 .858 r
.25089 .56819 .26621 .58627 .29016 .57493 .27491 .55732 Metetra
.733 .724 .843 r
.27491 .55732 .29016 .57493 .31454 .55929 .29935 .54278 Metetra
.757 .742 .839 r
.29935 .54278 .31454 .55929 .33917 .54076 .32405 .52579 Metetra
.771 .763 .846 r
.32405 .52579 .33917 .54076 .36391 .52126 .34888 .50793 Metetra
.77 .785 .865 r
.34888 .50793 .36391 .52126 .38866 .50281 .37375 .49095 Metetra
.751 .806 .896 r
.37375 .49095 .38866 .50281 .41337 .48721 .39861 .47638 Metetra
.705 .818 .935 r
.39861 .47638 .41337 .48721 .43808 .47578 .4235 .46534 Metetra
.624 .807 .97 r
.4235 .46534 .43808 .47578 .46287 .46912 .44847 .45836 Metetra
.522 .768 .987 r
.44847 .45836 .46287 .46912 .48786 .46703 .47362 .45526 Metetra
.437 .714 .983 r
.47362 .45526 .48786 .46703 .51316 .46858 .49907 .45524 Metetra
.407 .674 .97 r
.49907 .45524 .51316 .46858 .53886 .47217 .52489 .45693 Metetra
.435 .658 .954 r
.52489 .45693 .53886 .47217 .56498 .47582 .55111 .45865 Metetra
.499 .662 .934 r
.55111 .45865 .56498 .47582 .59151 .47748 .57772 .45865 Metetra
.572 .675 .909 r
.57772 .45865 .59151 .47748 .61834 .47537 .60465 .45544 Metetra
.637 .692 .884 r
.60465 .45544 .61834 .47537 .64535 .46836 .63179 .44806 Metetra
.69 .711 .864 r
.63179 .44806 .64535 .46836 .67242 .45617 .65904 .43626 Metetra
.73 .731 .851 r
.65904 .43626 .67242 .45617 .69945 .43942 .68631 .42059 Metetra
.758 .753 .848 r
.68631 .42059 .69945 .43942 .72642 .41954 .71358 .40225 Metetra
.774 .777 .856 r
.71358 .40225 .72642 .41954 .75339 .39848 .7409 .38287 Metetra
.774 .801 .875 r
.7409 .38287 .75339 .39848 .78049 .37834 .76837 .36424 Metetra
.753 .819 .904 r
.76837 .36424 .78049 .37834 .80792 .361 .79615 .34799 Metetra
.707 .825 .938 r
.79615 .34799 .80792 .361 .83589 .34787 .82443 .33529 Metetra
.634 .808 .967 r
.82443 .33529 .83589 .34787 .86461 .33963 .85337 .32675 Metetra
.643 .703 .89 r
.2117 .55742 .2274 .57483 .25089 .56819 .2353 .55053 Metetra
.691 .715 .867 r
.2353 .55053 .25089 .56819 .27491 .55732 .2594 .54004 Metetra
.725 .729 .854 r
.2594 .54004 .27491 .55732 .29935 .54278 .2839 .52642 Metetra
.747 .745 .85 r
.2839 .52642 .29935 .54278 .32405 .52579 .30868 .51069 Metetra
.758 .763 .857 r
.30868 .51069 .32405 .52579 .34888 .50793 .3336 .49422 Metetra
.757 .782 .874 r
.3336 .49422 .34888 .50793 .37375 .49095 .35859 .47846 Metetra
.739 .799 .901 r
.35859 .47846 .37375 .49095 .39861 .47638 .3836 .46475 Metetra
.698 .807 .933 r
.3836 .46475 .39861 .47638 .4235 .46534 .40865 .45403 Metetra
.632 .798 .963 r
.40865 .45403 .4235 .46534 .44847 .45836 .43379 .44674 Metetra
.552 .769 .979 r
.43379 .44674 .44847 .45836 .47362 .45526 .45912 .44275 Metetra
.486 .728 .978 r
.45912 .44275 .47362 .45526 .49907 .45524 .48472 .44136 Metetra
.459 .695 .969 r
.48472 .44136 .49907 .45524 .52489 .45693 .51067 .44141 Metetra
.478 .679 .954 r
.51067 .44141 .52489 .45693 .55111 .45865 .53701 .44147 Metetra
.526 .679 .935 r
.53701 .44147 .55111 .45865 .57772 .45865 .56372 .44004 Metetra
.585 .687 .912 r
.56372 .44004 .57772 .45865 .60465 .45544 .59076 .43587 Metetra
.64 .701 .89 r
.59076 .43587 .60465 .45544 .63179 .44806 .61804 .42814 Metetra
.686 .717 .872 r
.61804 .42814 .63179 .44806 .65904 .43626 .64546 .41666 Metetra
.722 .735 .861 r
.64546 .41666 .65904 .43626 .68631 .42059 .67297 .40188 Metetra
.747 .755 .859 r
.67297 .40188 .68631 .42059 .71358 .40225 .70052 .3848 Metetra
.76 .775 .866 r
.70052 .3848 .71358 .40225 .7409 .38287 .72816 .36682 Metetra
.759 .795 .882 r
.72816 .36682 .7409 .38287 .76837 .36424 .75597 .34946 Metetra
.74 .81 .907 r
.75597 .34946 .76837 .36424 .79615 .34799 .78408 .3341 Metetra
.699 .813 .936 r
.78408 .3341 .79615 .34799 .82443 .33529 .81266 .32175 Metetra
.639 .799 .959 r
.81266 .32175 .82443 .33529 .85337 .32675 .84183 .31292 Metetra
.645 .71 .895 r
.19571 .54032 .2117 .55742 .2353 .55053 .21942 .53319 Metetra
.687 .72 .875 r
.21942 .53319 .2353 .55053 .2594 .54004 .24361 .52299 Metetra
.717 .733 .863 r
.24361 .52299 .2594 .54004 .2839 .52642 .26819 .51012 Metetra
.737 .747 .86 r
.26819 .51012 .2839 .52642 .30868 .51069 .29304 .49545 Metetra
.747 .763 .866 r
.29304 .49545 .30868 .51069 .3336 .49422 .31806 .48013 Metetra
.745 .779 .881 r
.31806 .48013 .3336 .49422 .35859 .47846 .34316 .4654 Metetra
.727 .793 .904 r
.34316 .4654 .35859 .47846 .3836 .46475 .36832 .45239 Metetra
.691 .799 .931 r
.36832 .45239 .3836 .46475 .40865 .45403 .39353 .44191 Metetra
.637 .791 .956 r
.39353 .44191 .40865 .45403 .43379 .44674 .41884 .43434 Metetra
.574 .768 .97 r
.41884 .43434 .43379 .44674 .45912 .44275 .44434 .42957 Metetra
.522 .736 .972 r
.44434 .42957 .45912 .44275 .48472 .44136 .4701 .427 Metetra
.499 .709 .965 r
.4701 .427 .48472 .44136 .51067 .44141 .4962 .42562 Metetra
.511 .695 .951 r
.4962 .42562 .51067 .44141 .53701 .44147 .52266 .42423 Metetra
.548 .692 .934 r
.52266 .42423 .53701 .44147 .56372 .44004 .5495 .42157 Metetra
.595 .698 .914 r
.5495 .42157 .56372 .44004 .59076 .43587 .57666 .41656 Metetra
.642 .708 .895 r
.57666 .41656 .59076 .43587 .61804 .42814 .60408 .40851 Metetra
.682 .722 .88 r
.60408 .40851 .61804 .42814 .64546 .41666 .63169 .39727 Metetra
.714 .738 .87 r
.63169 .39727 .64546 .41666 .67297 .40188 .65941 .38321 Metetra
.736 .755 .868 r
.65941 .38321 .67297 .40188 .70052 .3848 .68724 .36718 Metetra
.747 .773 .874 r
.68724 .36718 .70052 .3848 .72816 .36682 .71518 .35036 Metetra
.745 .79 .889 r
.71518 .35036 .72816 .36682 .75597 .34946 .7433 .33405 Metetra
.728 .801 .91 r
.7433 .33405 .75597 .34946 .78408 .3341 .77173 .31942 Metetra
.693 .803 .934 r
.77173 .31942 .78408 .3341 .81266 .32175 .80058 .30733 Metetra
.643 .791 .953 r
.80058 .30733 .81266 .32175 .84183 .31292 .82998 .29822 Metetra
.647 .716 .899 r
.17943 .52343 .19571 .54032 .21942 .53319 .20325 .51608 Metetra
.683 .725 .882 r
.20325 .51608 .21942 .53319 .24361 .52299 .22754 .5061 Metetra
.71 .736 .872 r
.22754 .5061 .24361 .52299 .26819 .51012 .25219 .49385 Metetra
.728 .749 .869 r
.25219 .49385 .26819 .51012 .29304 .49545 .27713 .48005 Metetra
.736 .762 .874 r
.27713 .48005 .29304 .49545 .31806 .48013 .30225 .46568 Metetra
.733 .776 .887 r
.30225 .46568 .31806 .48013 .34316 .4654 .32747 .4518 Metetra
.717 .787 .907 r
.32747 .4518 .34316 .4654 .36832 .45239 .35277 .43936 Metetra
.686 .791 .93 r
.35277 .43936 .36832 .45239 .39353 .44191 .37814 .42907 Metetra
.641 .784 .95 r
.37814 .42907 .39353 .44191 .41884 .43434 .40362 .42124 Metetra
.59 .766 .963 r
.40362 .42124 .41884 .43434 .44434 .42957 .4293 .41577 Metetra
.549 .742 .966 r
.4293 .41577 .44434 .42957 .4701 .427 .45522 .41216 Metetra
.53 .719 .96 r
.45522 .41216 .4701 .427 .4962 .42562 .48147 .40955 Metetra
.538 .706 .948 r
.48147 .40955 .4962 .42562 .52266 .42423 .50807 .40691 Metetra
.566 .703 .933 r
.50807 .40691 .52266 .42423 .5495 .42157 .53504 .40317 Metetra
.605 .706 .916 r
.53504 .40317 .5495 .42157 .57666 .41656 .56234 .39741 Metetra
.644 .715 .899 r
.56234 .39741 .57666 .41656 .60408 .40851 .58991 .38907 Metetra
.679 .727 .886 r
.58991 .38907 .60408 .40851 .63169 .39727 .6177 .378 Metetra
.707 .741 .878 r
.6177 .378 .63169 .39727 .65941 .38321 .64564 .36452 Metetra
.726 .756 .876 r
.64564 .36452 .65941 .38321 .68724 .36718 .67371 .34935 Metetra
.736 .771 .882 r
.67371 .34935 .68724 .36718 .71518 .35036 .70194 .33349 Metetra
.733 .785 .894 r
.70194 .33349 .71518 .35036 .7433 .33405 .73037 .31804 Metetra
.717 .794 .912 r
.73037 .31804 .7433 .33405 .77173 .31942 .75909 .304 Metetra
.687 .795 .932 r
.75909 .304 .77173 .31942 .80058 .30733 .78821 .29211 Metetra
.646 .785 .948 r
.78821 .29211 .80058 .30733 .82998 .29822 .81784 .28273 Metetra
.648 .722 .902 r
.16285 .50668 .17943 .52343 .20325 .51608 .18679 .49911 Metetra
.679 .729 .888 r
.18679 .49911 .20325 .51608 .22754 .5061 .21117 .4893 Metetra
.703 .739 .879 r
.21117 .4893 .22754 .5061 .25219 .49385 .23592 .47755 Metetra
.719 .75 .876 r
.23592 .47755 .25219 .49385 .27713 .48005 .26094 .46446 Metetra
.726 .762 .881 r
.26094 .46446 .27713 .48005 .30225 .46568 .28616 .45088 Metetra
.723 .773 .892 r
.28616 .45088 .30225 .46568 .32747 .4518 .3115 .43769 Metetra
.709 .782 .909 r
.3115 .43769 .32747 .4518 .35277 .43936 .33694 .42572 Metetra
.682 .785 .928 r
.33694 .42572 .35277 .43936 .37814 .42907 .36247 .41556 Metetra
.644 .779 .945 r
.36247 .41556 .37814 .42907 .40362 .42124 .38813 .40748 Metetra
.603 .764 .957 r
.38813 .40748 .40362 .42124 .4293 .41577 .41397 .4014 Metetra
.569 .745 .959 r
.41397 .4014 .4293 .41577 .45522 .41216 .44007 .39687 Metetra
.554 .727 .955 r
.44007 .39687 .45522 .41216 .48147 .40955 .46647 .39319 Metetra
.559 .715 .945 r
.46647 .39319 .48147 .40955 .50807 .40691 .49323 .38946 Metetra
.581 .711 .932 r
.49323 .38946 .50807 .40691 .53504 .40317 .52034 .38477 Metetra
.612 .714 .917 r
.52034 .38477 .53504 .40317 .56234 .39741 .54778 .37836 Metetra
.646 .721 .903 r
.54778 .37836 .56234 .39741 .58991 .38907 .57551 .36973 Metetra
.676 .731 .891 r
.57551 .36973 .58991 .38907 .6177 .378 .60348 .35878 Metetra
.7 .743 .884 r
.60348 .35878 .6177 .378 .64564 .36452 .63163 .34576 Metetra
.717 .756 .883 r
.63163 .34576 .64564 .36452 .67371 .34935 .65995 .33129 Metetra
.725 .769 .888 r
.65995 .33129 .67371 .34935 .70194 .33349 .68844 .31621 Metetra
.723 .781 .899 r
.68844 .31621 .70194 .33349 .73037 .31804 .71715 .30147 Metetra
.708 .788 .914 r
.71715 .30147 .73037 .31804 .75909 .304 .74616 .28789 Metetra
.683 .788 .93 r
.74616 .28789 .75909 .304 .78821 .29211 .77555 .27613 Metetra
.648 .779 .943 r
.77555 .27613 .78821 .29211 .81784 .28273 .80541 .2665 Metetra
.649 .726 .905 r
.14597 .49 .16285 .50668 .18679 .49911 .17003 .48222 Metetra
.676 .733 .893 r
.17003 .48222 .18679 .49911 .21117 .4893 .19451 .47253 Metetra
.697 .741 .885 r
.19451 .47253 .21117 .4893 .23592 .47755 .21935 .46118 Metetra
.711 .751 .883 r
.21935 .46118 .23592 .47755 .26094 .46446 .24447 .44868 Metetra
.717 .761 .887 r
.24447 .44868 .26094 .46446 .28616 .45088 .26979 .43573 Metetra
.714 .771 .897 r
.26979 .43573 .28616 .45088 .3115 .43769 .29525 .42312 Metetra
.701 .778 .911 r
.29525 .42312 .3115 .43769 .33694 .42572 .32083 .41152 Metetra
.678 .78 .927 r
.32083 .41152 .33694 .42572 .36247 .41556 .34652 .40144 Metetra
.647 .775 .941 r
.34652 .40144 .36247 .41556 .38813 .40748 .37235 .39312 Metetra
.613 .763 .951 r
.37235 .39312 .38813 .40748 .41397 .4014 .39836 .38648 Metetra
.586 .747 .954 r
.39836 .38648 .41397 .4014 .44007 .39687 .42463 .38116 Metetra
.572 .732 .95 r
.42463 .38116 .44007 .39687 .46647 .39319 .4512 .37653 Metetra
.576 .722 .942 r
.4512 .37653 .46647 .39319 .49323 .38946 .47811 .37184 Metetra
.593 .718 .931 r
.47811 .37184 .49323 .38946 .52034 .38477 .50537 .36632 Metetra
.619 .72 .918 r
.50537 .36632 .52034 .38477 .54778 .37836 .53297 .35932 Metetra
.647 .725 .906 r
.53297 .35932 .54778 .37836 .57551 .36973 .56086 .35043 Metetra
.673 .734 .896 r
.56086 .35043 .57551 .36973 .60348 .35878 .58901 .33954 Metetra
.695 .744 .89 r
.58901 .33954 .60348 .35878 .63163 .34576 .61738 .32688 Metetra
.709 .756 .889 r
.61738 .32688 .63163 .34576 .65995 .33129 .64593 .31297 Metetra
.716 .767 .893 r
.64593 .31297 .65995 .33129 .68844 .31621 .67468 .29853 Metetra
.713 .777 .902 r
.67468 .29853 .68844 .31621 .71715 .30147 .70367 .28435 Metetra
.701 .783 .915 r
.70367 .28435 .71715 .30147 .74616 .28789 .73295 .27115 Metetra
.679 .782 .928 r
.73295 .27115 .74616 .28789 .77555 .27613 .7626 .25947 Metetra
.65 .775 .94 r
.7626 .25947 .77555 .27613 .80541 .2665 .79269 .24957 Metetra
.65 .73 .908 r
.12878 .47334 .14597 .49 .17003 .48222 .15297 .46536 Metetra
.673 .736 .897 r
.15297 .46536 .17003 .48222 .19451 .47253 .17755 .45575 Metetra
.692 .743 .89 r
.17755 .45575 .19451 .47253 .21935 .46118 .20248 .4447 Metetra
.704 .751 .889 r
.20248 .4447 .21935 .46118 .24447 .44868 .2277 .43267 Metetra
.709 .76 .892 r
.2277 .43267 .24447 .44868 .26979 .43573 .25313 .42025 Metetra
.706 .768 .9 r
.25313 .42025 .26979 .43573 .29525 .42312 .27872 .40809 Metetra
.695 .774 .912 r
.27872 .40809 .29525 .42312 .32083 .41152 .30443 .39678 Metetra
.675 .775 .926 r
.30443 .39678 .32083 .41152 .34652 .40144 .33028 .38674 Metetra
.648 .771 .938 r
.33028 .38674 .34652 .40144 .37235 .39312 .35628 .37819 Metetra
.621 .761 .946 r
.35628 .37819 .37235 .39312 .39836 .38648 .38247 .37106 Metetra
.598 .748 .949 r
.38247 .37106 .39836 .38648 .42463 .38116 .40891 .36502 Metetra
.587 .736 .946 r
.40891 .36502 .42463 .38116 .4512 .37653 .43565 .35956 Metetra
.59 .728 .939 r
.43565 .35956 .4512 .37653 .47811 .37184 .46272 .35403 Metetra
.604 .724 .93 r
.46272 .35403 .47811 .37184 .50537 .36632 .49014 .34777 Metetra
.625 .725 .919 r
.49014 .34777 .50537 .36632 .53297 .35932 .5179 .34025 Metetra
.648 .729 .908 r
.5179 .34025 .53297 .35932 .56086 .35043 .54596 .3311 Metetra
.671 .737 .9 r
.54596 .3311 .56086 .35043 .58901 .33954 .5743 .32023 Metetra
.689 .746 .895 r
.5743 .32023 .58901 .33954 .61738 .32688 .60287 .30785 Metetra
.702 .756 .894 r
.60287 .30785 .61738 .32688 .64593 .31297 .63165 .29438 Metetra
.708 .765 .897 r
.63165 .29438 .64593 .31297 .67468 .29853 .66065 .28045 Metetra
.705 .773 .905 r
.66065 .28045 .67468 .29853 .70367 .28435 .6899 .26671 Metetra
.694 .778 .916 r
.6899 .26671 .70367 .28435 .73295 .27115 .71945 .25379 Metetra
.675 .777 .927 r
.71945 .25379 .73295 .27115 .7626 .25947 .74935 .24215 Metetra
.651 .771 .937 r
.74935 .24215 .7626 .25947 .79269 .24957 .77968 .232 Metetra
.651 .734 .91 r
.11128 .45664 .12878 .47334 .15297 .46536 .13558 .44847 Metetra
.671 .738 .901 r
.13558 .44847 .15297 .46536 .17755 .45575 .16028 .43889 Metetra
.687 .744 .895 r
.16028 .43889 .17755 .45575 .20248 .4447 .18531 .42809 Metetra
.698 .752 .893 r
.18531 .42809 .20248 .4447 .2277 .43267 .21063 .41643 Metetra
.702 .759 .896 r
.21063 .41643 .2277 .43267 .25313 .42025 .23617 .40442 Metetra
.699 .766 .903 r
.23617 .40442 .25313 .42025 .27872 .40809 .26188 .39262 Metetra
.689 .77 .914 r
.26188 .39262 .27872 .40809 .30443 .39678 .28774 .38153 Metetra
.672 .771 .925 r
.28774 .38153 .30443 .39678 .33028 .38674 .31374 .37151 Metetra
.65 .768 .935 r
.31374 .37151 .33028 .38674 .35628 .37819 .33991 .36273 Metetra
.627 .76 .942 r
.33991 .36273 .35628 .37819 .38247 .37106 .36628 .35514 Metetra
.609 .749 .944 r
.36628 .35514 .38247 .37106 .40891 .36502 .3929 .34847 Metetra
.599 .739 .942 r
.3929 .34847 .40891 .36502 .43565 .35956 .41981 .34227 Metetra
.601 .732 .937 r
.41981 .34227 .43565 .35956 .46272 .35403 .44705 .336 Metetra
.612 .728 .928 r
.44705 .336 .46272 .35403 .49014 .34777 .47464 .32909 Metetra
.629 .729 .919 r
.47464 .32909 .49014 .34777 .5179 .34025 .50256 .32108 Metetra
.649 .733 .91 r
.50256 .32108 .5179 .34025 .54596 .3311 .53079 .31168 Metetra
.669 .739 .903 r
.53079 .31168 .54596 .3311 .5743 .32023 .55932 .3008 Metetra
.685 .747 .899 r
.55932 .3008 .5743 .32023 .60287 .30785 .58809 .28862 Metetra
.696 .756 .898 r
.58809 .28862 .60287 .30785 .63165 .29438 .6171 .2755 Metetra
.7 .764 .901 r
.6171 .2755 .63165 .29438 .66065 .28045 .64635 .26196 Metetra
.698 .77 .908 r
.64635 .26196 .66065 .28045 .6899 .26671 .67585 .24857 Metetra
.688 .774 .916 r
.67585 .24857 .6899 .26671 .71945 .25379 .70566 .23585 Metetra
.672 .773 .926 r
.70566 .23585 .71945 .25379 .74935 .24215 .73581 .2242 Metetra
.652 .768 .934 r
.73581 .2242 .74935 .24215 .77968 .232 .76638 .2138 Metetra
.651 .736 .912 r
.09345 .43987 .11128 .45664 .13558 .44847 .11788 .43151 Metetra
.669 .74 .904 r
.11788 .43151 .13558 .44847 .16028 .43889 .14268 .42194 Metetra
.683 .746 .899 r
.14268 .42194 .16028 .43889 .18531 .42809 .16783 .41131 Metetra
.692 .752 .898 r
.16783 .41131 .18531 .42809 .21063 .41643 .19325 .39994 Metetra
.696 .758 .9 r
.19325 .39994 .21063 .41643 .23617 .40442 .2189 .38826 Metetra
.693 .764 .906 r
.2189 .38826 .23617 .40442 .26188 .39262 .24474 .37674 Metetra
.684 .768 .915 r
.24474 .37674 .26188 .39262 .28774 .38153 .27075 .3658 Metetra
.669 .768 .924 r
.27075 .3658 .28774 .38153 .31374 .37151 .29691 .35576 Metetra
.651 .765 .933 r
.29691 .35576 .31374 .37151 .33991 .36273 .32324 .34676 Metetra
.632 .758 .939 r
.32324 .34676 .33991 .36273 .36628 .35514 .34979 .33876 Metetra
.617 .75 .941 r
.34979 .33876 .36628 .35514 .3929 .34847 .37658 .33152 Metetra
.609 .741 .939 r
.37658 .33152 .3929 .34847 .41981 .34227 .40367 .32466 Metetra
.61 .735 .934 r
.40367 .32466 .41981 .34227 .44705 .336 .43109 .31772 Metetra
.619 .732 .927 r
.43109 .31772 .44705 .336 .47464 .32909 .45884 .31023 Metetra
.633 .733 .919 r
.45884 .31023 .47464 .32909 .50256 .32108 .48693 .30178 Metetra
.65 .736 .912 r
.48693 .30178 .50256 .32108 .53079 .31168 .51535 .29213 Metetra
.667 .741 .906 r
.51535 .29213 .53079 .31168 .55932 .3008 .54406 .28121 Metetra
.681 .748 .902 r
.54406 .28121 .55932 .3008 .58809 .28862 .57304 .26916 Metetra
.69 .755 .901 r
.57304 .26916 .58809 .28862 .6171 .2755 .60227 .2563 Metetra
.694 .762 .904 r
.60227 .2563 .6171 .2755 .64635 .26196 .63176 .24306 Metetra
.692 .768 .91 r
.63176 .24306 .64635 .26196 .67585 .24857 .66151 .22993 Metetra
.684 .771 .917 r
.66151 .22993 .67585 .24857 .70566 .23585 .69157 .21735 Metetra
.67 .77 .925 r
.69157 .21735 .70566 .23585 .73581 .2242 .72198 .20566 Metetra
.653 .765 .932 r
.72198 .20566 .73581 .2242 .76638 .2138 .75278 .19501 Metetra
.652 .739 .913 r
.07529 .42299 .09345 .43987 .11788 .43151 .09985 .41444 Metetra
.667 .742 .906 r
.09985 .41444 .11788 .43151 .14268 .42194 .12477 .40485 Metetra
.679 .747 .902 r
.12477 .40485 .14268 .42194 .16783 .41131 .15002 .39434 Metetra
.687 .752 .901 r
.15002 .39434 .16783 .41131 .19325 .39994 .17555 .38319 Metetra
.69 .758 .903 r
.17555 .38319 .19325 .39994 .2189 .38826 .20132 .37176 Metetra
.688 .762 .908 r
.20132 .37176 .2189 .38826 .24474 .37674 .22729 .36044 Metetra
.68 .765 .915 r
.22729 .36044 .24474 .37674 .27075 .3658 .25344 .34961 Metetra
.667 .766 .923 r
.25344 .34961 .27075 .3658 .29691 .35576 .27976 .33953 Metetra
.652 .763 .931 r
.27976 .33953 .29691 .35576 .32324 .34676 .30626 .33031 Metetra
.636 .757 .936 r
.30626 .33031 .32324 .34676 .34979 .33876 .33298 .32192 Metetra
.623 .75 .938 r
.33298 .32192 .34979 .33876 .37658 .33152 .35996 .31417 Metetra
.617 .743 .936 r
.35996 .31417 .37658 .33152 .40367 .32466 .38723 .30672 Metetra
.617 .738 .932 r
.38723 .30672 .40367 .32466 .43109 .31772 .41482 .29918 Metetra
.625 .735 .926 r
.41482 .29918 .43109 .31772 .45884 .31023 .44275 .29115 Metetra
.637 .736 .92 r
.44275 .29115 .45884 .31023 .48693 .30178 .47102 .2823 Metetra
.651 .738 .913 r
.47102 .2823 .48693 .30178 .51535 .29213 .49961 .27241 Metetra
.665 .743 .908 r
.49961 .27241 .51535 .29213 .54406 .28121 .52852 .26142 Metetra
.677 .749 .905 r
.52852 .26142 .54406 .28121 .57304 .26916 .5577 .24945 Metetra
.685 .755 .904 r
.5577 .24945 .57304 .26916 .60227 .2563 .58716 .23677 Metetra
.689 .761 .907 r
.58716 .23677 .60227 .2563 .63176 .24306 .61688 .22375 Metetra
.687 .765 .911 r
.61688 .22375 .63176 .24306 .66151 .22993 .64688 .21081 Metetra
.679 .768 .918 r
.64688 .21081 .66151 .22993 .69157 .21735 .67719 .19831 Metetra
.668 .767 .924 r
.67719 .19831 .69157 .21735 .72198 .20566 .70784 .18654 Metetra
.653 .763 .93 r
.70784 .18654 .72198 .20566 .75278 .19501 .73889 .17564 Metetra
.653 .741 .914 r
.05679 .40597 .07529 .42299 .09985 .41444 .08147 .39723 Metetra
.665 .744 .909 r
.08147 .39723 .09985 .41444 .12477 .40485 .10651 .38759 Metetra
.676 .748 .905 r
.10651 .38759 .12477 .40485 .15002 .39434 .13188 .37716 Metetra
.683 .752 .904 r
.13188 .37716 .15002 .39434 .17555 .38319 .15753 .36616 Metetra
.685 .757 .906 r
.15753 .36616 .17555 .38319 .20132 .37176 .18342 .35491 Metetra
.683 .761 .91 r
.18342 .35491 .20132 .37176 .22729 .36044 .20952 .34375 Metetra
.676 .763 .916 r
.20952 .34375 .22729 .36044 .25344 .34961 .23581 .33297 Metetra
.666 .763 .923 r
.23581 .33297 .25344 .34961 .27976 .33953 .26229 .32282 Metetra
.653 .761 .929 r
.26229 .32282 .27976 .33953 .30626 .33031 .28896 .31339 Metetra
.639 .756 .933 r
.28896 .31339 .30626 .33031 .33298 .32192 .31586 .30464 Metetra
.629 .751 .935 r
.31586 .30464 .33298 .32192 .35996 .31417 .34302 .29641 Metetra
.623 .745 .934 r
.34302 .29641 .35996 .31417 .38723 .30672 .37047 .28843 Metetra
.624 .74 .931 r
.37047 .28843 .38723 .30672 .41482 .29918 .39824 .28035 Metetra
.63 .738 .926 r
.39824 .28035 .41482 .29918 .44275 .29115 .42635 .27184 Metetra
.64 .738 .92 r
.42635 .27184 .44275 .29115 .47102 .2823 .4548 .26261 Metetra
.652 .74 .914 r
.4548 .26261 .47102 .2823 .49961 .27241 .48358 .25247 Metetra
.664 .744 .91 r
.48358 .25247 .49961 .27241 .52852 .26142 .51268 .24139 Metetra
.674 .749 .907 r
.51268 .24139 .52852 .26142 .5577 .24945 .54207 .22945 Metetra
.681 .755 .907 r
.54207 .22945 .5577 .24945 .58716 .23677 .57174 .21689 Metetra
.684 .76 .909 r
.57174 .21689 .58716 .23677 .61688 .22375 .60169 .20402 Metetra
.682 .763 .913 r
.60169 .20402 .61688 .22375 .64688 .21081 .63194 .1912 Metetra
.676 .765 .918 r
.63194 .1912 .64688 .21081 .67719 .19831 .6625 .17873 Metetra
.666 .764 .924 r
.6625 .17873 .67719 .19831 .70784 .18654 .6934 .16686 Metetra
.654 .761 .928 r
.6934 .16686 .70784 .18654 .73889 .17564 .72469 .1557 Metetra
.653 .742 .915 r
.03794 .38877 .05679 .40597 .08147 .39723 .06276 .37984 Metetra
.664 .745 .91 r
.06276 .37984 .08147 .39723 .10651 .38759 .08792 .37013 Metetra
.673 .748 .907 r
.08792 .37013 .10651 .38759 .13188 .37716 .1134 .35974 Metetra
.679 .752 .907 r
.1134 .35974 .13188 .37716 .15753 .36616 .13917 .34884 Metetra
.681 .756 .908 r
.13917 .34884 .15753 .36616 .18342 .35491 .16519 .33772 Metetra
.679 .759 .912 r
.16519 .33772 .18342 .35491 .20952 .34375 .19142 .32665 Metetra
.673 .761 .917 r
.19142 .32665 .20952 .34375 .23581 .33297 .21786 .3159 Metetra
.664 .761 .922 r
.21786 .3159 .23581 .33297 .26229 .32282 .24449 .30565 Metetra
.653 .759 .928 r
.24449 .30565 .26229 .32282 .28896 .31339 .27134 .296 Metetra
.642 .756 .931 r
.27134 .296 .28896 .31339 .31586 .30464 .29841 .28692 Metetra
.633 .751 .933 r
.29841 .28692 .31586 .30464 .34302 .29641 .32575 .27826 Metetra
.629 .746 .932 r
.32575 .27826 .34302 .29641 .37047 .28843 .35339 .26979 Metetra
.629 .742 .929 r
.35339 .26979 .37047 .28843 .39824 .28035 .38134 .26122 Metetra
.634 .74 .925 r
.38134 .26122 .39824 .28035 .42635 .27184 .40963 .25226 Metetra
.642 .74 .92 r
.40963 .25226 .42635 .27184 .4548 .26261 .43827 .24267 Metetra
.652 .742 .915 r
.43827 .24267 .4548 .26261 .48358 .25247 .46724 .23229 Metetra
.663 .745 .912 r
.46724 .23229 .48358 .25247 .51268 .24139 .49653 .22109 Metetra
.671 .75 .909 r
.49653 .22109 .51268 .24139 .54207 .22945 .52613 .20914 Metetra
.677 .754 .909 r
.52613 .20914 .54207 .22945 .57174 .21689 .55602 .19665 Metetra
.68 .758 .911 r
.55602 .19665 .57174 .21689 .60169 .20402 .5862 .18387 Metetra
.678 .762 .914 r
.5862 .18387 .60169 .20402 .63194 .1912 .61669 .1711 Metetra
.673 .763 .918 r
.61669 .1711 .63194 .1912 .6625 .17873 .6475 .15862 Metetra
.664 .762 .923 r
.6475 .15862 .6625 .17873 .6934 .16686 .67865 .14662 Metetra
.654 .759 .927 r
.67865 .14662 .6934 .16686 .72469 .1557 .71019 .13521 Metetra
.653 .744 .916 r
.01874 .37137 .03794 .38877 .06276 .37984 .04369 .36225 Metetra
.663 .746 .912 r
.04369 .36225 .06276 .37984 .08792 .37013 .06897 .35246 Metetra
.67 .749 .909 r
.06897 .35246 .08792 .37013 .1134 .35974 .09458 .34206 Metetra
.675 .752 .909 r
.09458 .34206 .1134 .35974 .13917 .34884 .12046 .33123 Metetra
.677 .756 .91 r
.12046 .33123 .13917 .34884 .16519 .33772 .14661 .32018 Metetra
.676 .758 .913 r
.14661 .32018 .16519 .33772 .19142 .32665 .17298 .30916 Metetra
.671 .76 .917 r
.17298 .30916 .19142 .32665 .21786 .3159 .19957 .29839 Metetra
.663 .76 .922 r
.19957 .29839 .21786 .3159 .24449 .30565 .22636 .28804 Metetra
.654 .758 .926 r
.22636 .28804 .24449 .30565 .27134 .296 .25338 .27817 Metetra
.644 .755 .929 r
.25338 .27817 .27134 .296 .29841 .28692 .28063 .26877 Metetra
.637 .751 .931 r
.28063 .26877 .29841 .28692 .32575 .27826 .30815 .25971 Metetra
.633 .747 .93 r
.30815 .25971 .32575 .27826 .35339 .26979 .33597 .25079 Metetra
.633 .744 .928 r
.33597 .25079 .35339 .26979 .38134 .26122 .36411 .24176 Metetra
.637 .742 .924 r
.36411 .24176 .38134 .26122 .40963 .25226 .39259 .23239 Metetra
.644 .742 .92 r
.39259 .23239 .40963 .25226 .43827 .24267 .42141 .22246 Metetra
.653 .744 .916 r
.42141 .22246 .43827 .24267 .46724 .23229 .45057 .21184 Metetra
.661 .746 .913 r
.45057 .21184 .46724 .23229 .49653 .22109 .48006 .2005 Metetra
.669 .75 .911 r
.48006 .2005 .49653 .22109 .52613 .20914 .50987 .1885 Metetra
.674 .754 .911 r
.50987 .1885 .52613 .20914 .55602 .19665 .53998 .17602 Metetra
.676 .757 .912 r
.53998 .17602 .55602 .19665 .5862 .18387 .5704 .16328 Metetra
.675 .76 .915 r
.5704 .16328 .5862 .18387 .61669 .1711 .60112 .15052 Metetra
.67 .761 .919 r
.60112 .15052 .61669 .1711 .6475 .15862 .63218 .13799 Metetra
.663 .761 .923 r
.63218 .13799 .6475 .15862 .67865 .14662 .66358 .12584 Metetra
.655 .758 .926 r
.66358 .12584 .67865 .14662 .71019 .13521 .69536 .11417 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.65873 0.35106 0.97619 0.603319 MathSubStart
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.3209e-17 1.04977 -0.0679587 1.04977 [
[.08608 .22315 -12 -8.87306 ]
[.08608 .22315 0 .12694 ]
[.20731 .17545 -11.6738 -9 ]
[.20731 .17545 .32622 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.46808 .07289 -5.33651 -9 ]
[.46808 .07289 .66349 0 ]
[.60856 .01769 -5.08632 -9 ]
[.60856 .01769 .91368 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.0226 .27459 -12 -2.75033 ]
[.0226 .27459 0 6.24967 ]
[.0149 .32285 -12 -2.79114 ]
[.0149 .32285 0 6.20886 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00124 .42403 -6 -2.87714 ]
[-0.00124 .42403 0 6.12286 ]
[-0.00971 .47711 -6 -2.92248 ]
[-0.00971 .47711 0 6.07752 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03483 .26984 m
.04095 .26746 L
s
[(-4)] .0226 .27459 1 -0.38882 Mshowa
.02717 .31819 m
.0333 .31586 L
s
[(-2)] .0149 .32285 1 -0.37975 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.0111 .41958 m
.01727 .41735 L
s
[(2)] -0.00124 .42403 1 -0.36063 Mshowa
.00267 .47277 m
.00886 .4706 L
s
[(4)] -0.00971 .47711 1 -0.35056 Mshowa
.125 Mabswid
.03294 .28179 m
.03661 .28037 L
s
.03103 .29383 m
.0347 .29242 L
s
.02911 .30596 m
.03278 .30456 L
s
.02521 .33052 m
.0289 .32913 L
s
.02325 .34294 m
.02693 .34156 L
s
.02126 .35546 m
.02495 .35409 L
s
.01725 .3808 m
.02094 .37944 L
s
.01521 .39362 m
.01891 .39227 L
s
.01317 .40655 m
.01687 .40521 L
s
.00902 .43272 m
.01273 .43139 L
s
.00692 .44596 m
.01063 .44464 L
s
.0048 .45931 m
.00852 .458 L
s
.03671 .25798 m
.04038 .25655 L
s
.00052 .48634 m
.00424 .48505 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.645 .763 .934 r
.38427 .80015 .39787 .81114 .42053 .8052 .40705 .79412 Metetra
.645 .763 .934 r
.40705 .79412 .42053 .8052 .44337 .79922 .43002 .78805 Metetra
.855 .774 .771 r
.43002 .78805 .44337 .79922 .46657 .78346 .45369 .75629 Metetra
.849 .677 .667 r
.45369 .75629 .46657 .78346 .49041 .70966 .47766 .69282 Metetra
.89 .722 .666 r
.47766 .69282 .49041 .70966 .51358 .63251 .50111 .62616 Metetra
.93 .786 .679 r
.50111 .62616 .51358 .63251 .53604 .56396 .52395 .56651 Metetra
.892 .976 .819 r
.52395 .56651 .53604 .56396 .55843 .55287 .54648 .54028 Metetra
.664 .741 .907 r
.54648 .54028 .55843 .55287 .58103 .54607 .5692 .53338 Metetra
.664 .741 .907 r
.5692 .53338 .58103 .54607 .6038 .53922 .5921 .52642 Metetra
.664 .741 .907 r
.5921 .52642 .6038 .53922 .62677 .53231 .61519 .5194 Metetra
.764 .298 0 r
.61519 .5194 .62677 .53231 .65128 .56179 .64008 .55937 Metetra
.88 .453 .178 r
.64008 .55937 .65128 .56179 .67796 .62396 .66632 .61126 Metetra
.845 .404 0 r
.66632 .61126 .67796 .62396 .70599 .68929 .69374 .66547 Metetra
0 0 .481 r
.69374 .66547 .70599 .68929 .73344 .72328 .72177 .71087 Metetra
.645 .763 .934 r
.72177 .71087 .73344 .72328 .75902 .71659 .74752 .70406 Metetra
.645 .763 .934 r
.74752 .70406 .75902 .71659 .78483 .70983 .77349 .69719 Metetra
.645 .763 .934 r
.77349 .69719 .78483 .70983 .81088 .70301 .7997 .69026 Metetra
.859 .809 .799 r
.7997 .69026 .81088 .70301 .83671 .69107 .82423 .66089 Metetra
.872 .691 .654 r
.82423 .66089 .83671 .69107 .85649 .61468 .84525 .59513 Metetra
.924 .746 .643 r
.84525 .59513 .85649 .61468 .87498 .53394 .86518 .5253 Metetra
.969 .821 .641 r
.86518 .5253 .87498 .53394 .89346 .46136 .88507 .46206 Metetra
.902 .986 .749 r
.88507 .46206 .89346 .46136 .91786 .44473 .90803 .43044 Metetra
.664 .741 .907 r
.90803 .43044 .91786 .44473 .94349 .43702 .93382 .4226 Metetra
.664 .741 .907 r
.93382 .4226 .94349 .43702 .96935 .42924 .95984 .4147 Metetra
.645 .763 .934 r
.37046 .78898 .38427 .80015 .40705 .79412 .39336 .78287 Metetra
.686 .772 .917 r
.39336 .78287 .40705 .79412 .43002 .78805 .41652 .77434 Metetra
.869 .746 .725 r
.41652 .77434 .43002 .78805 .45369 .75629 .44067 .73134 Metetra
.845 .684 .682 r
.44067 .73134 .45369 .75629 .47766 .69282 .46474 .67655 Metetra
.884 .728 .683 r
.46474 .67655 .47766 .69282 .50111 .62616 .48841 .6188 Metetra
.92 .79 .701 r
.48841 .6188 .50111 .62616 .52395 .56651 .51157 .56678 Metetra
.944 .893 .748 r
.51157 .56678 .52395 .56651 .54648 .54028 .53435 .52764 Metetra
.666 .744 .908 r
.53435 .52764 .54648 .54028 .5692 .53338 .55719 .52049 Metetra
.664 .741 .907 r
.55719 .52049 .5692 .53338 .5921 .52642 .58021 .51342 Metetra
.221 .53 .921 r
.58021 .51342 .5921 .52642 .61519 .5194 .60381 .52198 Metetra
.811 .358 .16 r
.60381 .52198 .61519 .5194 .64008 .55937 .62857 .55526 Metetra
.851 .394 .087 r
.62857 .55526 .64008 .55937 .66632 .61126 .6545 .59836 Metetra
.78 .317 0 r
.6545 .59836 .66632 .61126 .69374 .66547 .68144 .64314 Metetra
0 .006 .578 r
.68144 .64314 .69374 .66547 .72177 .71087 .70897 .68044 Metetra
.441 .474 .798 r
.70897 .68044 .72177 .71087 .74752 .70406 .73581 .69133 Metetra
.645 .763 .934 r
.73581 .69133 .74752 .70406 .77349 .69719 .76196 .68434 Metetra
.648 .764 .934 r
.76196 .68434 .77349 .69719 .7997 .69026 .78832 .67713 Metetra
.908 .8 .73 r
.78832 .67713 .7997 .69026 .82423 .66089 .81188 .63313 Metetra
.866 .699 .673 r
.81188 .63313 .82423 .66089 .84525 .59513 .83395 .57627 Metetra
.915 .753 .666 r
.83395 .57627 .84525 .59513 .86518 .5253 .8551 .5157 Metetra
.957 .826 .674 r
.8551 .5157 .86518 .5253 .88507 .46206 .87622 .46047 Metetra
.964 .932 .703 r
.87622 .46047 .88507 .46206 .90803 .43044 .89828 .41808 Metetra
.696 .788 .922 r
.89828 .41808 .90803 .43044 .93382 .4226 .92399 .40795 Metetra
.664 .741 .907 r
.92399 .40795 .93382 .4226 .95984 .4147 .95018 .39992 Metetra
.597 .639 .863 r
.3568 .76968 .37046 .78898 .39336 .78287 .37962 .76707 Metetra
.788 .731 .8 r
.37962 .76707 .39336 .78287 .41652 .77434 .40333 .74563 Metetra
.795 .654 .708 r
.40333 .74563 .41652 .77434 .44067 .73134 .42748 .70823 Metetra
.84 .691 .698 r
.42748 .70823 .44067 .73134 .46474 .67655 .45164 .66073 Metetra
.876 .733 .701 r
.45164 .66073 .46474 .67655 .48841 .6188 .47549 .61053 Metetra
.908 .793 .722 r
.47549 .61053 .48841 .6188 .51157 .56678 .49892 .56505 Metetra
.925 .888 .777 r
.49892 .56505 .51157 .56678 .53435 .52764 .52201 .53045 Metetra
.786 .997 .858 r
.52201 .53045 .53435 .52764 .55719 .52049 .54501 .51095 Metetra
.539 .762 .979 r
.54501 .51095 .55719 .52049 .58021 .51342 .56825 .50843 Metetra
.45 0 0 r
.56825 .50843 .58021 .51342 .60381 .52198 .59209 .52234 Metetra
.773 .28 .049 r
.59209 .52234 .60381 .52198 .62857 .55526 .61679 .54969 Metetra
.803 .312 0 r
.61679 .54969 .62857 .55526 .6545 .59836 .64248 .58525 Metetra
.684 .204 0 r
.64248 .58525 .6545 .59836 .68144 .64314 .66907 .62204 Metetra
0 .121 .671 r
.66907 .62204 .68144 .64314 .70897 .68044 .69621 .65232 Metetra
.32 .418 .806 r
.69621 .65232 .70897 .68044 .73581 .69133 .72338 .66896 Metetra
.582 .617 .852 r
.72338 .66896 .73581 .69133 .76196 .68434 .74996 .66717 Metetra
.788 .751 .819 r
.74996 .66717 .76196 .68434 .78832 .67713 .77545 .64573 Metetra
.802 .662 .708 r
.77545 .64573 .78832 .67713 .81188 .63313 .79961 .60735 Metetra
.859 .707 .692 r
.79961 .60735 .81188 .63313 .83395 .57627 .82256 .55797 Metetra
.905 .76 .689 r
.82256 .55797 .83395 .57627 .8551 .5157 .84477 .50524 Metetra
.942 .83 .705 r
.84477 .50524 .8551 .5157 .87622 .46047 .86694 .45685 Metetra
.947 .931 .75 r
.86694 .45685 .87622 .46047 .89828 .41808 .88991 .41932 Metetra
.752 .992 .797 r
.88991 .41932 .89828 .41808 .92399 .40795 .91449 .3971 Metetra
.586 .778 .971 r
.91449 .3971 .92399 .40795 .95018 .39992 .94132 .39232 Metetra
.607 .575 .792 r
.3434 .74187 .3568 .76968 .37962 .76707 .36626 .73854 Metetra
.726 .628 .748 r
.36626 .73854 .37962 .76707 .40333 .74563 .38995 .71934 Metetra
.79 .663 .724 r
.38995 .71934 .40333 .74563 .42748 .70823 .41411 .68662 Metetra
.833 .698 .714 r
.41411 .68662 .42748 .70823 .45164 .66073 .43834 .64526 Metetra
.867 .739 .719 r
.43834 .64526 .45164 .66073 .47549 .61053 .46235 .60147 Metetra
.895 .795 .743 r
.46235 .60147 .47549 .61053 .49892 .56505 .48601 .56156 Metetra
.904 .881 .802 r
.48601 .56156 .49892 .56505 .52201 .53045 .50938 .53086 Metetra
.79 .982 .901 r
.50938 .53086 .52201 .53045 .54501 .51095 .53265 .51305 Metetra
.53265 .51305 .54501 .51095 .56825 .50843 .5561 .50979 Metetra
.532 0 0 r
.5561 .50979 .56825 .50843 .59209 .52234 .58005 .52059 Metetra
.706 .17 0 r
.58005 .52059 .59209 .52234 .61679 .54969 .60473 .54281 Metetra
.724 .201 0 r
.60473 .54281 .61679 .54969 .64248 .58525 .63027 .57192 Metetra
.554 .068 0 r
.63027 .57192 .64248 .58525 .66907 .62204 .6566 .60193 Metetra
0 .231 .751 r
.6566 .60193 .66907 .62204 .69621 .65232 .68346 .62628 Metetra
.362 .463 .829 r
.68346 .62628 .69621 .65232 .72338 .66896 .71041 .63905 Metetra
.597 .57 .794 r
.71041 .63905 .72338 .66896 .74996 .66717 .73696 .63625 Metetra
.72 .628 .754 r
.73696 .63625 .74996 .66717 .77545 .64573 .76268 .61689 Metetra
.796 .672 .727 r
.76268 .61689 .77545 .64573 .79961 .60735 .78736 .5832 Metetra
.851 .715 .713 r
.78736 .5832 .79961 .60735 .82256 .55797 .81107 .5401 Metetra
.894 .765 .713 r
.81107 .5401 .82256 .55797 .84477 .50524 .83418 .494 Metetra
.925 .832 .734 r
.83418 .494 .84477 .50524 .86694 .45685 .85728 .45146 Metetra
.926 .923 .789 r
.85728 .45146 .86694 .45685 .88991 .41932 .88105 .41808 Metetra
.777 .995 .871 r
.88105 .41808 .88991 .41932 .91449 .3971 .90619 .39778 Metetra
.195 .724 .759 r
.90619 .39778 .91449 .3971 .94132 .39232 .93327 .39241 Metetra
.613 .595 .808 r
.32978 .71634 .3434 .74187 .36626 .73854 .35268 .7124 Metetra
.723 .64 .765 r
.35268 .7124 .36626 .73854 .38995 .71934 .37638 .69505 Metetra
.785 .673 .74 r
.37638 .69505 .38995 .71934 .41411 .68662 .40055 .66625 Metetra
.826 .705 .731 r
.40055 .66625 .41411 .68662 .43834 .64526 .42483 .63005 Metetra
.858 .744 .737 r
.42483 .63005 .43834 .64526 .46235 .60147 .44898 .59169 Metetra
.88 .797 .763 r
.44898 .59169 .46235 .60147 .48601 .56156 .47284 .55654 Metetra
.882 .872 .823 r
.47284 .55654 .48601 .56156 .50938 .53086 .49646 .52918 Metetra
.784 .958 .925 r
.49646 .52918 .50938 .53086 .53265 .51305 .51998 .51281 Metetra
.258 .766 .851 r
.51998 .51281 .53265 .51305 .5561 .50979 .54364 .50889 Metetra
.375 0 0 r
.54364 .50889 .5561 .50979 .58005 .52059 .56771 .51698 Metetra
.595 .023 0 r
.56771 .51698 .58005 .52059 .60473 .54281 .59241 .53479 Metetra
.602 .057 0 r
.59241 .53479 .60473 .54281 .63027 .57192 .61786 .55837 Metetra
0 .083 .597 r
.61786 .55837 .63027 .57192 .6566 .60193 .64401 .58262 Metetra
.035 .33 .813 r
.64401 .58262 .6566 .60193 .68346 .62628 .67066 .60196 Metetra
.401 .503 .848 r
.67066 .60196 .68346 .62628 .71041 .63905 .69747 .61145 Metetra
.604 .59 .81 r
.69747 .61145 .71041 .63905 .73696 .63625 .72402 .60779 Metetra
.717 .641 .771 r
.72402 .60779 .73696 .63625 .76268 .61689 .74996 .59014 Metetra
.79 .681 .745 r
.74996 .59014 .76268 .61689 .78736 .5832 .77509 .56036 Metetra
.841 .723 .733 r
.77509 .56036 .78736 .5832 .81107 .5401 .79946 .52254 Metetra
.881 .77 .736 r
.79946 .52254 .81107 .5401 .83418 .494 .82335 .48206 Metetra
.907 .832 .761 r
.82335 .48206 .83418 .494 .85728 .45146 .84725 .4445 Metetra
.902 .912 .82 r
.84725 .4445 .85728 .45146 .88105 .41808 .87173 .41468 Metetra
.781 .977 .912 r
.87173 .41468 .88105 .41808 .90619 .39778 .89738 .39601 Metetra
.353 .823 .9 r
.89738 .39601 .90619 .39778 .93327 .39241 .9247 .39011 Metetra
.619 .613 .823 r
.31592 .6927 .32978 .71634 .35268 .7124 .33888 .68822 Metetra
.72 .652 .781 r
.33888 .68822 .35268 .7124 .37638 .69505 .36259 .67241 Metetra
.779 .682 .756 r
.36259 .67241 .37638 .69505 .40055 .66625 .38678 .64688 Metetra
.818 .712 .748 r
.38678 .64688 .40055 .66625 .42483 .63005 .41112 .61503 Metetra
.847 .749 .755 r
.41112 .61503 .42483 .63005 .44898 .59169 .43538 .58127 Metetra
.865 .797 .782 r
.43538 .58127 .44898 .59169 .47284 .55654 .45943 .55016 Metetra
.86 .863 .84 r
.45943 .55016 .47284 .55654 .49646 .52918 .48327 .52565 Metetra
.772 .931 .937 r
.48327 .52565 .49646 .52918 .51998 .51281 .50701 .51051 Metetra
.395 .833 .948 r
.50701 .51051 .51998 .51281 .54364 .50889 .53088 .506 Metetra
.171 0 0 r
.53088 .506 .54364 .50889 .56771 .51698 .55508 .51174 Metetra
.43 0 0 r
.55508 .51174 .56771 .51698 .59241 .53479 .57983 .52575 Metetra
.434 0 0 r
.57983 .52575 .59241 .53479 .61786 .55837 .60524 .5446 Metetra
0 .231 .728 r
.60524 .5446 .61786 .55837 .64401 .58262 .63128 .56393 Metetra
.143 .414 .858 r
.63128 .56393 .64401 .58262 .67066 .60196 .6578 .57904 Metetra
.436 .54 .864 r
.6578 .57904 .67066 .60196 .69747 .61145 .68451 .58576 Metetra
.61 .609 .824 r
.68451 .58576 .69747 .61145 .72402 .60779 .71109 .58135 Metetra
.714 .653 .787 r
.71109 .58135 .72402 .60779 .74996 .59014 .73724 .56512 Metetra
.782 .691 .763 r
.73724 .56512 .74996 .59014 .77509 .56036 .76277 .5386 Metetra
.831 .729 .753 r
.76277 .5386 .77509 .56036 .79946 .52254 .78771 .50521 Metetra
.866 .774 .758 r
.78771 .50521 .79946 .52254 .82335 .48206 .81228 .46948 Metetra
.887 .83 .785 r
.81228 .46948 .82335 .48206 .84725 .4445 .83688 .43615 Metetra
.877 .898 .843 r
.83688 .43615 .84725 .4445 .87173 .41468 .86199 .40937 Metetra
.773 .951 .933 r
.86199 .40937 .87173 .41468 .89738 .39601 .88811 .39207 Metetra
.462 .861 .968 r
.88811 .39207 .89738 .39601 .9247 .39011 .91567 .3857 Metetra
.624 .63 .837 r
.30182 .67059 .31592 .6927 .33888 .68822 .32485 .66565 Metetra
.717 .663 .796 r
.32485 .66565 .33888 .68822 .36259 .67241 .34859 .65111 Metetra
.772 .69 .773 r
.34859 .65111 .36259 .67241 .38678 .64688 .37279 .62832 Metetra
.809 .719 .765 r
.37279 .62832 .38678 .64688 .41112 .61503 .39719 .60013 Metetra
.835 .753 .773 r
.39719 .60013 .41112 .61503 .43538 .58127 .42156 .57026 Metetra
.849 .797 .8 r
.42156 .57026 .43538 .58127 .45943 .55016 .44577 .54259 Metetra
.839 .853 .855 r
.44577 .54259 .45943 .55016 .48327 .52565 .46981 .5205 Metetra
.759 .906 .941 r
.46981 .5205 .48327 .52565 .50701 .51051 .49377 .50639 Metetra
.485 .853 .988 r
.49377 .50639 .50701 .51051 .53088 .506 .51782 .50136 Metetra
.039 .578 .849 r
.51782 .50136 .53088 .506 .55508 .51174 .54218 .50507 Metetra
0 .337 .707 r
.54218 .50507 .55508 .51174 .57983 .52575 .567 .5158 Metetra
0 .278 .721 r
.567 .5158 .57983 .52575 .60524 .5446 .5924 .5306 Metetra
0 .359 .825 r
.5924 .5306 .60524 .5446 .63128 .56393 .61839 .54575 Metetra
.235 .482 .889 r
.61839 .54575 .63128 .56393 .6578 .57904 .64483 .55725 Metetra
.467 .572 .877 r
.64483 .55725 .6578 .57904 .68451 .58576 .67151 .56161 Metetra
.616 .626 .838 r
.67151 .56161 .68451 .58576 .71109 .58135 .69814 .55655 Metetra
.711 .665 .803 r
.69814 .55655 .71109 .58135 .73724 .56512 .72448 .54148 Metetra
.774 .7 .781 r
.72448 .54148 .73724 .56512 .76277 .5386 .75036 .51769 Metetra
.82 .736 .772 r
.75036 .51769 .76277 .5386 .78771 .50521 .77581 .48803 Metetra
.851 .777 .779 r
.77581 .48803 .78771 .50521 .81228 .46948 .80098 .45631 Metetra
.867 .827 .806 r
.80098 .45631 .81228 .46948 .83688 .43615 .82619 .42658 Metetra
.852 .884 .862 r
.82619 .42658 .83688 .43615 .86199 .40937 .85186 .40237 Metetra
.762 .923 .942 r
.85186 .40237 .86199 .40937 .88811 .39207 .87841 .38624 Metetra
.53 .867 .993 r
.87841 .38624 .88811 .39207 .91567 .3857 .90621 .37943 Metetra
.628 .646 .849 r
.28746 .64975 .30182 .67059 .32485 .66565 .31057 .6444 Metetra
.713 .674 .811 r
.31057 .6444 .32485 .66565 .34859 .65111 .33435 .6309 Metetra
.765 .698 .789 r
.33435 .6309 .34859 .65111 .37279 .62832 .35859 .61041 Metetra
.8 .725 .782 r
.35859 .61041 .37279 .62832 .39719 .60013 .38304 .5853 Metetra
.822 .756 .79 r
.38304 .5853 .39719 .60013 .42156 .57026 .40751 .55872 Metetra
.832 .796 .816 r
.40751 .55872 .42156 .57026 .44577 .54259 .43186 .53396 Metetra
.818 .843 .867 r
.43186 .53396 .44577 .54259 .46981 .5205 .45608 .51393 Metetra
.745 .883 .942 r
.45608 .51393 .46981 .5205 .49377 .50639 .48025 .50069 Metetra
.54 .851 .998 r
.48025 .50069 .49377 .50639 .51782 .50136 .50449 .49519 Metetra
.211 .676 .943 r
.50449 .49519 .51782 .50136 .54218 .50507 .529 .49713 Metetra
0 .486 .85 r
.529 .49713 .54218 .50507 .567 .5158 .55392 .50503 Metetra
0 .419 .841 r
.55392 .50503 .567 .5158 .5924 .5306 .57936 .51636 Metetra
.097 .46 .888 r
.57936 .51636 .5924 .5306 .61839 .54575 .60533 .52794 Metetra
.311 .537 .909 r
.60533 .52794 .61839 .54575 .64483 .55725 .63174 .53637 Metetra
.495 .599 .887 r
.63174 .53637 .64483 .55725 .67151 .56161 .65841 .53873 Metetra
.622 .642 .85 r
.65841 .53873 .67151 .56161 .69814 .55655 .68512 .53309 Metetra
.707 .676 .818 r
.68512 .53309 .69814 .55655 .72448 .54148 .71164 .51898 Metetra
.766 .708 .797 r
.71164 .51898 .72448 .54148 .75036 .51769 .73785 .49746 Metetra
.808 .741 .79 r
.73785 .49746 .75036 .51769 .77581 .48803 .76374 .47092 Metetra
.835 .779 .798 r
.76374 .47092 .77581 .48803 .80098 .45631 .78943 .4426 Metetra
.847 .823 .825 r
.78943 .4426 .80098 .45631 .82619 .42658 .8152 .4159 Metetra
.828 .869 .875 r
.8152 .4159 .82619 .42658 .85186 .40237 .84137 .39388 Metetra
.749 .898 .945 r
.84137 .39388 .85186 .40237 .87841 .38624 .86832 .37872 Metetra
.571 .858 .996 r
.86832 .37872 .87841 .38624 .90621 .37943 .89634 .37151 Metetra
.632 .66 .859 r
.27285 .62994 .28746 .64975 .31057 .6444 .29604 .62421 Metetra
.708 .684 .824 r
.29604 .62421 .31057 .6444 .33435 .6309 .31987 .61158 Metetra
.757 .706 .804 r
.31987 .61158 .33435 .6309 .35859 .61041 .34415 .59301 Metetra
.789 .73 .798 r
.34415 .59301 .35859 .61041 .38304 .5853 .36866 .57049 Metetra
.81 .759 .806 r
.36866 .57049 .38304 .5853 .40751 .55872 .39322 .54668 Metetra
.816 .794 .831 r
.39322 .54668 .40751 .55872 .43186 .53396 .41771 .52439 Metetra
.799 .833 .877 r
.41771 .52439 .43186 .53396 .45608 .51393 .4421 .5061 Metetra
.733 .863 .941 r
.4421 .5061 .45608 .51393 .48025 .50069 .46646 .49358 Metetra
.575 .842 .995 r
.46646 .49358 .48025 .50069 .50449 .49519 .49089 .48765 Metetra
.336 .728 .983 r
.49089 .48765 .50449 .49519 .529 .49713 .51555 .48807 Metetra
.149 .59 .931 r
.51555 .48807 .529 .49713 .55392 .50503 .54058 .49353 Metetra
.114 .524 .913 r
.54058 .49353 .55392 .50503 .57936 .51636 .56609 .50188 Metetra
.215 .536 .924 r
.56609 .50188 .57936 .51636 .60533 .52794 .59208 .5104 Metetra
.374 .58 .922 r
.59208 .5104 .60533 .52794 .63174 .53637 .6185 .51622 Metetra
.518 .623 .895 r
.6185 .51622 .63174 .53637 .65841 .53873 .6452 .51686 Metetra
.626 .657 .86 r
.6452 .51686 .65841 .53873 .68512 .53309 .67199 .51071 Metetra
.703 .686 .831 r
.67199 .51071 .68512 .53309 .71164 .51898 .6987 .49738 Metetra
.757 .715 .813 r
.6987 .49738 .71164 .51898 .73785 .49746 .72521 .47775 Metetra
.795 .745 .807 r
.72521 .47775 .73785 .49746 .76374 .47092 .75149 .45384 Metetra
.819 .779 .815 r
.75149 .45384 .76374 .47092 .78943 .4426 .77766 .42837 Metetra
.827 .818 .841 r
.77766 .42837 .78943 .4426 .8152 .4159 .80391 .40424 Metetra
.806 .855 .886 r
.80391 .40424 .8152 .4159 .84137 .39388 .83054 .38406 Metetra
.736 .875 .945 r
.83054 .38406 .84137 .39388 .86832 .37872 .85785 .36972 Metetra
.597 .845 .991 r
.85785 .36972 .86832 .37872 .89634 .37151 .88611 .36214 Metetra
.636 .673 .869 r
.25797 .61095 .27285 .62994 .29604 .62421 .28126 .60489 Metetra
.704 .693 .837 r
.28126 .60489 .29604 .62421 .31987 .61158 .30514 .59298 Metetra
.749 .713 .818 r
.30514 .59298 .31987 .61158 .34415 .59301 .32946 .576 Metetra
.779 .735 .812 r
.32946 .576 .34415 .59301 .36866 .57049 .35403 .55566 Metetra
.796 .761 .82 r
.35403 .55566 .36866 .57049 .39322 .54668 .37868 .53419 Metetra
.8 .791 .844 r
.37868 .53419 .39322 .54668 .41771 .52439 .40331 .51398 Metetra
.782 .823 .885 r
.40331 .51398 .41771 .52439 .4421 .5061 .42786 .49715 Metetra
.722 .845 .94 r
.42786 .49715 .4421 .5061 .46646 .49358 .4524 .48523 Metetra
.598 .83 .988 r
.4524 .48523 .46646 .49358 .49089 .48765 .47701 .47892 Metetra
.421 .753 .995 r
.47701 .47892 .49089 .48765 .51555 .48807 .50184 .478 Metetra
.277 .654 .968 r
.50184 .478 .51555 .48807 .54058 .49353 .527 .48136 Metetra
.241 .595 .95 r
.527 .48136 .54058 .49353 .56609 .50188 .55259 .48716 Metetra
.308 .59 .943 r
.55259 .48716 .56609 .50188 .59208 .5104 .57864 .49305 Metetra
.424 .614 .929 r
.57864 .49305 .59208 .5104 .6185 .51622 .60509 .49663 Metetra
.539 .643 .901 r
.60509 .49663 .6185 .51622 .6452 .51686 .63185 .4958 Metetra
.631 .67 .87 r
.63185 .4958 .6452 .51686 .67199 .51071 .65875 .4892 Metetra
.698 .695 .843 r
.65875 .4892 .67199 .51071 .6987 .49738 .68564 .47649 Metetra
.748 .721 .827 r
.68564 .47649 .6987 .49738 .72521 .47775 .71241 .45844 Metetra
.783 .749 .822 r
.71241 .45844 .72521 .47775 .75149 .45384 .73906 .43673 Metetra
.804 .779 .83 r
.73906 .43673 .75149 .45384 .77766 .42837 .76564 .41366 Metetra
.808 .812 .854 r
.76564 .41366 .77766 .42837 .80391 .40424 .79234 .39169 Metetra
.787 .842 .894 r
.79234 .39169 .80391 .40424 .83054 .38406 .81939 .37306 Metetra
.725 .855 .943 r
.81939 .37306 .83054 .38406 .85785 .36972 .84704 .35939 Metetra
.614 .831 .983 r
.84704 .35939 .85785 .36972 .88611 .36214 .87552 .35147 Metetra
.639 .684 .877 r
.24282 .59263 .25797 .61095 .28126 .60489 .26621 .58627 Metetra
.699 .701 .848 r
.26621 .58627 .28126 .60489 .30514 .59298 .29016 .57493 Metetra
.741 .719 .831 r
.29016 .57493 .30514 .59298 .32946 .576 .31454 .55929 Metetra
.768 .739 .826 r
.31454 .55929 .32946 .576 .35403 .55566 .33917 .54076 Metetra
.783 .762 .834 r
.33917 .54076 .35403 .55566 .37868 .53419 .36391 .52126 Metetra
.785 .788 .855 r
.36391 .52126 .37868 .53419 .40331 .51398 .38866 .50281 Metetra
.766 .814 .891 r
.38866 .50281 .40331 .51398 .42786 .49715 .41337 .48721 Metetra
.713 .83 .938 r
.41337 .48721 .42786 .49715 .4524 .48523 .43808 .47578 Metetra
.613 .818 .979 r
.43808 .47578 .4524 .48523 .47701 .47892 .46287 .46912 Metetra
.48 .764 .993 r
.46287 .46912 .47701 .47892 .50184 .478 .48786 .46703 Metetra
.37 .692 .981 r
.48786 .46703 .50184 .478 .527 .48136 .51316 .46858 Metetra
.336 .642 .965 r
.51316 .46858 .527 .48136 .55259 .48716 .53886 .47217 Metetra
.38 .63 .952 r
.53886 .47217 .55259 .48716 .57864 .49305 .56498 .47582 Metetra
.466 .641 .933 r
.56498 .47582 .57864 .49305 .60509 .49663 .59151 .47748 Metetra
.557 .661 .906 r
.59151 .47748 .60509 .49663 .63185 .4958 .61834 .47537 Metetra
.634 .682 .878 r
.61834 .47537 .63185 .4958 .65875 .4892 .64535 .46836 Metetra
.694 .704 .854 r
.64535 .46836 .65875 .4892 .68564 .47649 .67242 .45617 Metetra
.739 .726 .84 r
.67242 .45617 .68564 .47649 .71241 .45844 .69945 .43942 Metetra
.77 .751 .836 r
.69945 .43942 .71241 .45844 .73906 .43673 .72642 .41954 Metetra
.788 .778 .844 r
.72642 .41954 .73906 .43673 .76564 .41366 .75339 .39848 Metetra
.79 .806 .865 r
.75339 .39848 .76564 .41366 .79234 .39169 .78049 .37834 Metetra
.769 .83 .9 r
.78049 .37834 .79234 .39169 .81939 .37306 .80792 .361 Metetra
.715 .839 .941 r
.80792 .361 .81939 .37306 .84704 .35939 .83589 .34787 Metetra
.626 .819 .975 r
.83589 .34787 .84704 .35939 .87552 .35147 .86461 .33963 Metetra
.641 .694 .884 r
.2274 .57483 .24282 .59263 .26621 .58627 .25089 .56819 Metetra
.695 .709 .858 r
.25089 .56819 .26621 .58627 .29016 .57493 .27491 .55732 Metetra
.733 .724 .843 r
.27491 .55732 .29016 .57493 .31454 .55929 .29935 .54278 Metetra
.757 .742 .839 r
.29935 .54278 .31454 .55929 .33917 .54076 .32405 .52579 Metetra
.771 .763 .846 r
.32405 .52579 .33917 .54076 .36391 .52126 .34888 .50793 Metetra
.77 .785 .865 r
.34888 .50793 .36391 .52126 .38866 .50281 .37375 .49095 Metetra
.751 .806 .896 r
.37375 .49095 .38866 .50281 .41337 .48721 .39861 .47638 Metetra
.705 .818 .935 r
.39861 .47638 .41337 .48721 .43808 .47578 .4235 .46534 Metetra
.624 .807 .97 r
.4235 .46534 .43808 .47578 .46287 .46912 .44847 .45836 Metetra
.522 .768 .987 r
.44847 .45836 .46287 .46912 .48786 .46703 .47362 .45526 Metetra
.437 .714 .983 r
.47362 .45526 .48786 .46703 .51316 .46858 .49907 .45524 Metetra
.407 .674 .97 r
.49907 .45524 .51316 .46858 .53886 .47217 .52489 .45693 Metetra
.435 .658 .954 r
.52489 .45693 .53886 .47217 .56498 .47582 .55111 .45865 Metetra
.499 .662 .934 r
.55111 .45865 .56498 .47582 .59151 .47748 .57772 .45865 Metetra
.572 .675 .909 r
.57772 .45865 .59151 .47748 .61834 .47537 .60465 .45544 Metetra
.637 .692 .884 r
.60465 .45544 .61834 .47537 .64535 .46836 .63179 .44806 Metetra
.69 .711 .864 r
.63179 .44806 .64535 .46836 .67242 .45617 .65904 .43626 Metetra
.73 .731 .851 r
.65904 .43626 .67242 .45617 .69945 .43942 .68631 .42059 Metetra
.758 .753 .848 r
.68631 .42059 .69945 .43942 .72642 .41954 .71358 .40225 Metetra
.774 .777 .856 r
.71358 .40225 .72642 .41954 .75339 .39848 .7409 .38287 Metetra
.774 .801 .875 r
.7409 .38287 .75339 .39848 .78049 .37834 .76837 .36424 Metetra
.753 .819 .904 r
.76837 .36424 .78049 .37834 .80792 .361 .79615 .34799 Metetra
.707 .825 .938 r
.79615 .34799 .80792 .361 .83589 .34787 .82443 .33529 Metetra
.634 .808 .967 r
.82443 .33529 .83589 .34787 .86461 .33963 .85337 .32675 Metetra
.643 .703 .89 r
.2117 .55742 .2274 .57483 .25089 .56819 .2353 .55053 Metetra
.691 .715 .867 r
.2353 .55053 .25089 .56819 .27491 .55732 .2594 .54004 Metetra
.725 .729 .854 r
.2594 .54004 .27491 .55732 .29935 .54278 .2839 .52642 Metetra
.747 .745 .85 r
.2839 .52642 .29935 .54278 .32405 .52579 .30868 .51069 Metetra
.758 .763 .857 r
.30868 .51069 .32405 .52579 .34888 .50793 .3336 .49422 Metetra
.757 .782 .874 r
.3336 .49422 .34888 .50793 .37375 .49095 .35859 .47846 Metetra
.739 .799 .901 r
.35859 .47846 .37375 .49095 .39861 .47638 .3836 .46475 Metetra
.698 .807 .933 r
.3836 .46475 .39861 .47638 .4235 .46534 .40865 .45403 Metetra
.632 .798 .963 r
.40865 .45403 .4235 .46534 .44847 .45836 .43379 .44674 Metetra
.552 .769 .979 r
.43379 .44674 .44847 .45836 .47362 .45526 .45912 .44275 Metetra
.486 .728 .978 r
.45912 .44275 .47362 .45526 .49907 .45524 .48472 .44136 Metetra
.459 .695 .969 r
.48472 .44136 .49907 .45524 .52489 .45693 .51067 .44141 Metetra
.478 .679 .954 r
.51067 .44141 .52489 .45693 .55111 .45865 .53701 .44147 Metetra
.526 .679 .935 r
.53701 .44147 .55111 .45865 .57772 .45865 .56372 .44004 Metetra
.585 .687 .912 r
.56372 .44004 .57772 .45865 .60465 .45544 .59076 .43587 Metetra
.64 .701 .89 r
.59076 .43587 .60465 .45544 .63179 .44806 .61804 .42814 Metetra
.686 .717 .872 r
.61804 .42814 .63179 .44806 .65904 .43626 .64546 .41666 Metetra
.722 .735 .861 r
.64546 .41666 .65904 .43626 .68631 .42059 .67297 .40188 Metetra
.747 .755 .859 r
.67297 .40188 .68631 .42059 .71358 .40225 .70052 .3848 Metetra
.76 .775 .866 r
.70052 .3848 .71358 .40225 .7409 .38287 .72816 .36682 Metetra
.759 .795 .882 r
.72816 .36682 .7409 .38287 .76837 .36424 .75597 .34946 Metetra
.74 .81 .907 r
.75597 .34946 .76837 .36424 .79615 .34799 .78408 .3341 Metetra
.699 .813 .936 r
.78408 .3341 .79615 .34799 .82443 .33529 .81266 .32175 Metetra
.639 .799 .959 r
.81266 .32175 .82443 .33529 .85337 .32675 .84183 .31292 Metetra
.645 .71 .895 r
.19571 .54032 .2117 .55742 .2353 .55053 .21942 .53319 Metetra
.687 .72 .875 r
.21942 .53319 .2353 .55053 .2594 .54004 .24361 .52299 Metetra
.717 .733 .863 r
.24361 .52299 .2594 .54004 .2839 .52642 .26819 .51012 Metetra
.737 .747 .86 r
.26819 .51012 .2839 .52642 .30868 .51069 .29304 .49545 Metetra
.747 .763 .866 r
.29304 .49545 .30868 .51069 .3336 .49422 .31806 .48013 Metetra
.745 .779 .881 r
.31806 .48013 .3336 .49422 .35859 .47846 .34316 .4654 Metetra
.727 .793 .904 r
.34316 .4654 .35859 .47846 .3836 .46475 .36832 .45239 Metetra
.691 .799 .931 r
.36832 .45239 .3836 .46475 .40865 .45403 .39353 .44191 Metetra
.637 .791 .956 r
.39353 .44191 .40865 .45403 .43379 .44674 .41884 .43434 Metetra
.574 .768 .97 r
.41884 .43434 .43379 .44674 .45912 .44275 .44434 .42957 Metetra
.522 .736 .972 r
.44434 .42957 .45912 .44275 .48472 .44136 .4701 .427 Metetra
.499 .709 .965 r
.4701 .427 .48472 .44136 .51067 .44141 .4962 .42562 Metetra
.511 .695 .951 r
.4962 .42562 .51067 .44141 .53701 .44147 .52266 .42423 Metetra
.548 .692 .934 r
.52266 .42423 .53701 .44147 .56372 .44004 .5495 .42157 Metetra
.595 .698 .914 r
.5495 .42157 .56372 .44004 .59076 .43587 .57666 .41656 Metetra
.642 .708 .895 r
.57666 .41656 .59076 .43587 .61804 .42814 .60408 .40851 Metetra
.682 .722 .88 r
.60408 .40851 .61804 .42814 .64546 .41666 .63169 .39727 Metetra
.714 .738 .87 r
.63169 .39727 .64546 .41666 .67297 .40188 .65941 .38321 Metetra
.736 .755 .868 r
.65941 .38321 .67297 .40188 .70052 .3848 .68724 .36718 Metetra
.747 .773 .874 r
.68724 .36718 .70052 .3848 .72816 .36682 .71518 .35036 Metetra
.745 .79 .889 r
.71518 .35036 .72816 .36682 .75597 .34946 .7433 .33405 Metetra
.728 .801 .91 r
.7433 .33405 .75597 .34946 .78408 .3341 .77173 .31942 Metetra
.693 .803 .934 r
.77173 .31942 .78408 .3341 .81266 .32175 .80058 .30733 Metetra
.643 .791 .953 r
.80058 .30733 .81266 .32175 .84183 .31292 .82998 .29822 Metetra
.647 .716 .899 r
.17943 .52343 .19571 .54032 .21942 .53319 .20325 .51608 Metetra
.683 .725 .882 r
.20325 .51608 .21942 .53319 .24361 .52299 .22754 .5061 Metetra
.71 .736 .872 r
.22754 .5061 .24361 .52299 .26819 .51012 .25219 .49385 Metetra
.728 .749 .869 r
.25219 .49385 .26819 .51012 .29304 .49545 .27713 .48005 Metetra
.736 .762 .874 r
.27713 .48005 .29304 .49545 .31806 .48013 .30225 .46568 Metetra
.733 .776 .887 r
.30225 .46568 .31806 .48013 .34316 .4654 .32747 .4518 Metetra
.717 .787 .907 r
.32747 .4518 .34316 .4654 .36832 .45239 .35277 .43936 Metetra
.686 .791 .93 r
.35277 .43936 .36832 .45239 .39353 .44191 .37814 .42907 Metetra
.641 .784 .95 r
.37814 .42907 .39353 .44191 .41884 .43434 .40362 .42124 Metetra
.59 .766 .963 r
.40362 .42124 .41884 .43434 .44434 .42957 .4293 .41577 Metetra
.549 .742 .966 r
.4293 .41577 .44434 .42957 .4701 .427 .45522 .41216 Metetra
.53 .719 .96 r
.45522 .41216 .4701 .427 .4962 .42562 .48147 .40955 Metetra
.538 .706 .948 r
.48147 .40955 .4962 .42562 .52266 .42423 .50807 .40691 Metetra
.566 .703 .933 r
.50807 .40691 .52266 .42423 .5495 .42157 .53504 .40317 Metetra
.605 .706 .916 r
.53504 .40317 .5495 .42157 .57666 .41656 .56234 .39741 Metetra
.644 .715 .899 r
.56234 .39741 .57666 .41656 .60408 .40851 .58991 .38907 Metetra
.679 .727 .886 r
.58991 .38907 .60408 .40851 .63169 .39727 .6177 .378 Metetra
.707 .741 .878 r
.6177 .378 .63169 .39727 .65941 .38321 .64564 .36452 Metetra
.726 .756 .876 r
.64564 .36452 .65941 .38321 .68724 .36718 .67371 .34935 Metetra
.736 .771 .882 r
.67371 .34935 .68724 .36718 .71518 .35036 .70194 .33349 Metetra
.733 .785 .894 r
.70194 .33349 .71518 .35036 .7433 .33405 .73037 .31804 Metetra
.717 .794 .912 r
.73037 .31804 .7433 .33405 .77173 .31942 .75909 .304 Metetra
.687 .795 .932 r
.75909 .304 .77173 .31942 .80058 .30733 .78821 .29211 Metetra
.646 .785 .948 r
.78821 .29211 .80058 .30733 .82998 .29822 .81784 .28273 Metetra
.648 .722 .902 r
.16285 .50668 .17943 .52343 .20325 .51608 .18679 .49911 Metetra
.679 .729 .888 r
.18679 .49911 .20325 .51608 .22754 .5061 .21117 .4893 Metetra
.703 .739 .879 r
.21117 .4893 .22754 .5061 .25219 .49385 .23592 .47755 Metetra
.719 .75 .876 r
.23592 .47755 .25219 .49385 .27713 .48005 .26094 .46446 Metetra
.726 .762 .881 r
.26094 .46446 .27713 .48005 .30225 .46568 .28616 .45088 Metetra
.723 .773 .892 r
.28616 .45088 .30225 .46568 .32747 .4518 .3115 .43769 Metetra
.709 .782 .909 r
.3115 .43769 .32747 .4518 .35277 .43936 .33694 .42572 Metetra
.682 .785 .928 r
.33694 .42572 .35277 .43936 .37814 .42907 .36247 .41556 Metetra
.644 .779 .945 r
.36247 .41556 .37814 .42907 .40362 .42124 .38813 .40748 Metetra
.603 .764 .957 r
.38813 .40748 .40362 .42124 .4293 .41577 .41397 .4014 Metetra
.569 .745 .959 r
.41397 .4014 .4293 .41577 .45522 .41216 .44007 .39687 Metetra
.554 .727 .955 r
.44007 .39687 .45522 .41216 .48147 .40955 .46647 .39319 Metetra
.559 .715 .945 r
.46647 .39319 .48147 .40955 .50807 .40691 .49323 .38946 Metetra
.581 .711 .932 r
.49323 .38946 .50807 .40691 .53504 .40317 .52034 .38477 Metetra
.612 .714 .917 r
.52034 .38477 .53504 .40317 .56234 .39741 .54778 .37836 Metetra
.646 .721 .903 r
.54778 .37836 .56234 .39741 .58991 .38907 .57551 .36973 Metetra
.676 .731 .891 r
.57551 .36973 .58991 .38907 .6177 .378 .60348 .35878 Metetra
.7 .743 .884 r
.60348 .35878 .6177 .378 .64564 .36452 .63163 .34576 Metetra
.717 .756 .883 r
.63163 .34576 .64564 .36452 .67371 .34935 .65995 .33129 Metetra
.725 .769 .888 r
.65995 .33129 .67371 .34935 .70194 .33349 .68844 .31621 Metetra
.723 .781 .899 r
.68844 .31621 .70194 .33349 .73037 .31804 .71715 .30147 Metetra
.708 .788 .914 r
.71715 .30147 .73037 .31804 .75909 .304 .74616 .28789 Metetra
.683 .788 .93 r
.74616 .28789 .75909 .304 .78821 .29211 .77555 .27613 Metetra
.648 .779 .943 r
.77555 .27613 .78821 .29211 .81784 .28273 .80541 .2665 Metetra
.649 .726 .905 r
.14597 .49 .16285 .50668 .18679 .49911 .17003 .48222 Metetra
.676 .733 .893 r
.17003 .48222 .18679 .49911 .21117 .4893 .19451 .47253 Metetra
.697 .741 .885 r
.19451 .47253 .21117 .4893 .23592 .47755 .21935 .46118 Metetra
.711 .751 .883 r
.21935 .46118 .23592 .47755 .26094 .46446 .24447 .44868 Metetra
.717 .761 .887 r
.24447 .44868 .26094 .46446 .28616 .45088 .26979 .43573 Metetra
.714 .771 .897 r
.26979 .43573 .28616 .45088 .3115 .43769 .29525 .42312 Metetra
.701 .778 .911 r
.29525 .42312 .3115 .43769 .33694 .42572 .32083 .41152 Metetra
.678 .78 .927 r
.32083 .41152 .33694 .42572 .36247 .41556 .34652 .40144 Metetra
.647 .775 .941 r
.34652 .40144 .36247 .41556 .38813 .40748 .37235 .39312 Metetra
.613 .763 .951 r
.37235 .39312 .38813 .40748 .41397 .4014 .39836 .38648 Metetra
.586 .747 .954 r
.39836 .38648 .41397 .4014 .44007 .39687 .42463 .38116 Metetra
.572 .732 .95 r
.42463 .38116 .44007 .39687 .46647 .39319 .4512 .37653 Metetra
.576 .722 .942 r
.4512 .37653 .46647 .39319 .49323 .38946 .47811 .37184 Metetra
.593 .718 .931 r
.47811 .37184 .49323 .38946 .52034 .38477 .50537 .36632 Metetra
.619 .72 .918 r
.50537 .36632 .52034 .38477 .54778 .37836 .53297 .35932 Metetra
.647 .725 .906 r
.53297 .35932 .54778 .37836 .57551 .36973 .56086 .35043 Metetra
.673 .734 .896 r
.56086 .35043 .57551 .36973 .60348 .35878 .58901 .33954 Metetra
.695 .744 .89 r
.58901 .33954 .60348 .35878 .63163 .34576 .61738 .32688 Metetra
.709 .756 .889 r
.61738 .32688 .63163 .34576 .65995 .33129 .64593 .31297 Metetra
.716 .767 .893 r
.64593 .31297 .65995 .33129 .68844 .31621 .67468 .29853 Metetra
.713 .777 .902 r
.67468 .29853 .68844 .31621 .71715 .30147 .70367 .28435 Metetra
.701 .783 .915 r
.70367 .28435 .71715 .30147 .74616 .28789 .73295 .27115 Metetra
.679 .782 .928 r
.73295 .27115 .74616 .28789 .77555 .27613 .7626 .25947 Metetra
.65 .775 .94 r
.7626 .25947 .77555 .27613 .80541 .2665 .79269 .24957 Metetra
.65 .73 .908 r
.12878 .47334 .14597 .49 .17003 .48222 .15297 .46536 Metetra
.673 .736 .897 r
.15297 .46536 .17003 .48222 .19451 .47253 .17755 .45575 Metetra
.692 .743 .89 r
.17755 .45575 .19451 .47253 .21935 .46118 .20248 .4447 Metetra
.704 .751 .889 r
.20248 .4447 .21935 .46118 .24447 .44868 .2277 .43267 Metetra
.709 .76 .892 r
.2277 .43267 .24447 .44868 .26979 .43573 .25313 .42025 Metetra
.706 .768 .9 r
.25313 .42025 .26979 .43573 .29525 .42312 .27872 .40809 Metetra
.695 .774 .912 r
.27872 .40809 .29525 .42312 .32083 .41152 .30443 .39678 Metetra
.675 .775 .926 r
.30443 .39678 .32083 .41152 .34652 .40144 .33028 .38674 Metetra
.648 .771 .938 r
.33028 .38674 .34652 .40144 .37235 .39312 .35628 .37819 Metetra
.621 .761 .946 r
.35628 .37819 .37235 .39312 .39836 .38648 .38247 .37106 Metetra
.598 .748 .949 r
.38247 .37106 .39836 .38648 .42463 .38116 .40891 .36502 Metetra
.587 .736 .946 r
.40891 .36502 .42463 .38116 .4512 .37653 .43565 .35956 Metetra
.59 .728 .939 r
.43565 .35956 .4512 .37653 .47811 .37184 .46272 .35403 Metetra
.604 .724 .93 r
.46272 .35403 .47811 .37184 .50537 .36632 .49014 .34777 Metetra
.625 .725 .919 r
.49014 .34777 .50537 .36632 .53297 .35932 .5179 .34025 Metetra
.648 .729 .908 r
.5179 .34025 .53297 .35932 .56086 .35043 .54596 .3311 Metetra
.671 .737 .9 r
.54596 .3311 .56086 .35043 .58901 .33954 .5743 .32023 Metetra
.689 .746 .895 r
.5743 .32023 .58901 .33954 .61738 .32688 .60287 .30785 Metetra
.702 .756 .894 r
.60287 .30785 .61738 .32688 .64593 .31297 .63165 .29438 Metetra
.708 .765 .897 r
.63165 .29438 .64593 .31297 .67468 .29853 .66065 .28045 Metetra
.705 .773 .905 r
.66065 .28045 .67468 .29853 .70367 .28435 .6899 .26671 Metetra
.694 .778 .916 r
.6899 .26671 .70367 .28435 .73295 .27115 .71945 .25379 Metetra
.675 .777 .927 r
.71945 .25379 .73295 .27115 .7626 .25947 .74935 .24215 Metetra
.651 .771 .937 r
.74935 .24215 .7626 .25947 .79269 .24957 .77968 .232 Metetra
.651 .734 .91 r
.11128 .45664 .12878 .47334 .15297 .46536 .13558 .44847 Metetra
.671 .738 .901 r
.13558 .44847 .15297 .46536 .17755 .45575 .16028 .43889 Metetra
.687 .744 .895 r
.16028 .43889 .17755 .45575 .20248 .4447 .18531 .42809 Metetra
.698 .752 .893 r
.18531 .42809 .20248 .4447 .2277 .43267 .21063 .41643 Metetra
.702 .759 .896 r
.21063 .41643 .2277 .43267 .25313 .42025 .23617 .40442 Metetra
.699 .766 .903 r
.23617 .40442 .25313 .42025 .27872 .40809 .26188 .39262 Metetra
.689 .77 .914 r
.26188 .39262 .27872 .40809 .30443 .39678 .28774 .38153 Metetra
.672 .771 .925 r
.28774 .38153 .30443 .39678 .33028 .38674 .31374 .37151 Metetra
.65 .768 .935 r
.31374 .37151 .33028 .38674 .35628 .37819 .33991 .36273 Metetra
.627 .76 .942 r
.33991 .36273 .35628 .37819 .38247 .37106 .36628 .35514 Metetra
.609 .749 .944 r
.36628 .35514 .38247 .37106 .40891 .36502 .3929 .34847 Metetra
.599 .739 .942 r
.3929 .34847 .40891 .36502 .43565 .35956 .41981 .34227 Metetra
.601 .732 .937 r
.41981 .34227 .43565 .35956 .46272 .35403 .44705 .336 Metetra
.612 .728 .928 r
.44705 .336 .46272 .35403 .49014 .34777 .47464 .32909 Metetra
.629 .729 .919 r
.47464 .32909 .49014 .34777 .5179 .34025 .50256 .32108 Metetra
.649 .733 .91 r
.50256 .32108 .5179 .34025 .54596 .3311 .53079 .31168 Metetra
.669 .739 .903 r
.53079 .31168 .54596 .3311 .5743 .32023 .55932 .3008 Metetra
.685 .747 .899 r
.55932 .3008 .5743 .32023 .60287 .30785 .58809 .28862 Metetra
.696 .756 .898 r
.58809 .28862 .60287 .30785 .63165 .29438 .6171 .2755 Metetra
.7 .764 .901 r
.6171 .2755 .63165 .29438 .66065 .28045 .64635 .26196 Metetra
.698 .77 .908 r
.64635 .26196 .66065 .28045 .6899 .26671 .67585 .24857 Metetra
.688 .774 .916 r
.67585 .24857 .6899 .26671 .71945 .25379 .70566 .23585 Metetra
.672 .773 .926 r
.70566 .23585 .71945 .25379 .74935 .24215 .73581 .2242 Metetra
.652 .768 .934 r
.73581 .2242 .74935 .24215 .77968 .232 .76638 .2138 Metetra
.651 .736 .912 r
.09345 .43987 .11128 .45664 .13558 .44847 .11788 .43151 Metetra
.669 .74 .904 r
.11788 .43151 .13558 .44847 .16028 .43889 .14268 .42194 Metetra
.683 .746 .899 r
.14268 .42194 .16028 .43889 .18531 .42809 .16783 .41131 Metetra
.692 .752 .898 r
.16783 .41131 .18531 .42809 .21063 .41643 .19325 .39994 Metetra
.696 .758 .9 r
.19325 .39994 .21063 .41643 .23617 .40442 .2189 .38826 Metetra
.693 .764 .906 r
.2189 .38826 .23617 .40442 .26188 .39262 .24474 .37674 Metetra
.684 .768 .915 r
.24474 .37674 .26188 .39262 .28774 .38153 .27075 .3658 Metetra
.669 .768 .924 r
.27075 .3658 .28774 .38153 .31374 .37151 .29691 .35576 Metetra
.651 .765 .933 r
.29691 .35576 .31374 .37151 .33991 .36273 .32324 .34676 Metetra
.632 .758 .939 r
.32324 .34676 .33991 .36273 .36628 .35514 .34979 .33876 Metetra
.617 .75 .941 r
.34979 .33876 .36628 .35514 .3929 .34847 .37658 .33152 Metetra
.609 .741 .939 r
.37658 .33152 .3929 .34847 .41981 .34227 .40367 .32466 Metetra
.61 .735 .934 r
.40367 .32466 .41981 .34227 .44705 .336 .43109 .31772 Metetra
.619 .732 .927 r
.43109 .31772 .44705 .336 .47464 .32909 .45884 .31023 Metetra
.633 .733 .919 r
.45884 .31023 .47464 .32909 .50256 .32108 .48693 .30178 Metetra
.65 .736 .912 r
.48693 .30178 .50256 .32108 .53079 .31168 .51535 .29213 Metetra
.667 .741 .906 r
.51535 .29213 .53079 .31168 .55932 .3008 .54406 .28121 Metetra
.681 .748 .902 r
.54406 .28121 .55932 .3008 .58809 .28862 .57304 .26916 Metetra
.69 .755 .901 r
.57304 .26916 .58809 .28862 .6171 .2755 .60227 .2563 Metetra
.694 .762 .904 r
.60227 .2563 .6171 .2755 .64635 .26196 .63176 .24306 Metetra
.692 .768 .91 r
.63176 .24306 .64635 .26196 .67585 .24857 .66151 .22993 Metetra
.684 .771 .917 r
.66151 .22993 .67585 .24857 .70566 .23585 .69157 .21735 Metetra
.67 .77 .925 r
.69157 .21735 .70566 .23585 .73581 .2242 .72198 .20566 Metetra
.653 .765 .932 r
.72198 .20566 .73581 .2242 .76638 .2138 .75278 .19501 Metetra
.652 .739 .913 r
.07529 .42299 .09345 .43987 .11788 .43151 .09985 .41444 Metetra
.667 .742 .906 r
.09985 .41444 .11788 .43151 .14268 .42194 .12477 .40485 Metetra
.679 .747 .902 r
.12477 .40485 .14268 .42194 .16783 .41131 .15002 .39434 Metetra
.687 .752 .901 r
.15002 .39434 .16783 .41131 .19325 .39994 .17555 .38319 Metetra
.69 .758 .903 r
.17555 .38319 .19325 .39994 .2189 .38826 .20132 .37176 Metetra
.688 .762 .908 r
.20132 .37176 .2189 .38826 .24474 .37674 .22729 .36044 Metetra
.68 .765 .915 r
.22729 .36044 .24474 .37674 .27075 .3658 .25344 .34961 Metetra
.667 .766 .923 r
.25344 .34961 .27075 .3658 .29691 .35576 .27976 .33953 Metetra
.652 .763 .931 r
.27976 .33953 .29691 .35576 .32324 .34676 .30626 .33031 Metetra
.636 .757 .936 r
.30626 .33031 .32324 .34676 .34979 .33876 .33298 .32192 Metetra
.623 .75 .938 r
.33298 .32192 .34979 .33876 .37658 .33152 .35996 .31417 Metetra
.617 .743 .936 r
.35996 .31417 .37658 .33152 .40367 .32466 .38723 .30672 Metetra
.617 .738 .932 r
.38723 .30672 .40367 .32466 .43109 .31772 .41482 .29918 Metetra
.625 .735 .926 r
.41482 .29918 .43109 .31772 .45884 .31023 .44275 .29115 Metetra
.637 .736 .92 r
.44275 .29115 .45884 .31023 .48693 .30178 .47102 .2823 Metetra
.651 .738 .913 r
.47102 .2823 .48693 .30178 .51535 .29213 .49961 .27241 Metetra
.665 .743 .908 r
.49961 .27241 .51535 .29213 .54406 .28121 .52852 .26142 Metetra
.677 .749 .905 r
.52852 .26142 .54406 .28121 .57304 .26916 .5577 .24945 Metetra
.685 .755 .904 r
.5577 .24945 .57304 .26916 .60227 .2563 .58716 .23677 Metetra
.689 .761 .907 r
.58716 .23677 .60227 .2563 .63176 .24306 .61688 .22375 Metetra
.687 .765 .911 r
.61688 .22375 .63176 .24306 .66151 .22993 .64688 .21081 Metetra
.679 .768 .918 r
.64688 .21081 .66151 .22993 .69157 .21735 .67719 .19831 Metetra
.668 .767 .924 r
.67719 .19831 .69157 .21735 .72198 .20566 .70784 .18654 Metetra
.653 .763 .93 r
.70784 .18654 .72198 .20566 .75278 .19501 .73889 .17564 Metetra
.653 .741 .914 r
.05679 .40597 .07529 .42299 .09985 .41444 .08147 .39723 Metetra
.665 .744 .909 r
.08147 .39723 .09985 .41444 .12477 .40485 .10651 .38759 Metetra
.676 .748 .905 r
.10651 .38759 .12477 .40485 .15002 .39434 .13188 .37716 Metetra
.683 .752 .904 r
.13188 .37716 .15002 .39434 .17555 .38319 .15753 .36616 Metetra
.685 .757 .906 r
.15753 .36616 .17555 .38319 .20132 .37176 .18342 .35491 Metetra
.683 .761 .91 r
.18342 .35491 .20132 .37176 .22729 .36044 .20952 .34375 Metetra
.676 .763 .916 r
.20952 .34375 .22729 .36044 .25344 .34961 .23581 .33297 Metetra
.666 .763 .923 r
.23581 .33297 .25344 .34961 .27976 .33953 .26229 .32282 Metetra
.653 .761 .929 r
.26229 .32282 .27976 .33953 .30626 .33031 .28896 .31339 Metetra
.639 .756 .933 r
.28896 .31339 .30626 .33031 .33298 .32192 .31586 .30464 Metetra
.629 .751 .935 r
.31586 .30464 .33298 .32192 .35996 .31417 .34302 .29641 Metetra
.623 .745 .934 r
.34302 .29641 .35996 .31417 .38723 .30672 .37047 .28843 Metetra
.624 .74 .931 r
.37047 .28843 .38723 .30672 .41482 .29918 .39824 .28035 Metetra
.63 .738 .926 r
.39824 .28035 .41482 .29918 .44275 .29115 .42635 .27184 Metetra
.64 .738 .92 r
.42635 .27184 .44275 .29115 .47102 .2823 .4548 .26261 Metetra
.652 .74 .914 r
.4548 .26261 .47102 .2823 .49961 .27241 .48358 .25247 Metetra
.664 .744 .91 r
.48358 .25247 .49961 .27241 .52852 .26142 .51268 .24139 Metetra
.674 .749 .907 r
.51268 .24139 .52852 .26142 .5577 .24945 .54207 .22945 Metetra
.681 .755 .907 r
.54207 .22945 .5577 .24945 .58716 .23677 .57174 .21689 Metetra
.684 .76 .909 r
.57174 .21689 .58716 .23677 .61688 .22375 .60169 .20402 Metetra
.682 .763 .913 r
.60169 .20402 .61688 .22375 .64688 .21081 .63194 .1912 Metetra
.676 .765 .918 r
.63194 .1912 .64688 .21081 .67719 .19831 .6625 .17873 Metetra
.666 .764 .924 r
.6625 .17873 .67719 .19831 .70784 .18654 .6934 .16686 Metetra
.654 .761 .928 r
.6934 .16686 .70784 .18654 .73889 .17564 .72469 .1557 Metetra
.653 .742 .915 r
.03794 .38877 .05679 .40597 .08147 .39723 .06276 .37984 Metetra
.664 .745 .91 r
.06276 .37984 .08147 .39723 .10651 .38759 .08792 .37013 Metetra
.673 .748 .907 r
.08792 .37013 .10651 .38759 .13188 .37716 .1134 .35974 Metetra
.679 .752 .907 r
.1134 .35974 .13188 .37716 .15753 .36616 .13917 .34884 Metetra
.681 .756 .908 r
.13917 .34884 .15753 .36616 .18342 .35491 .16519 .33772 Metetra
.679 .759 .912 r
.16519 .33772 .18342 .35491 .20952 .34375 .19142 .32665 Metetra
.673 .761 .917 r
.19142 .32665 .20952 .34375 .23581 .33297 .21786 .3159 Metetra
.664 .761 .922 r
.21786 .3159 .23581 .33297 .26229 .32282 .24449 .30565 Metetra
.653 .759 .928 r
.24449 .30565 .26229 .32282 .28896 .31339 .27134 .296 Metetra
.642 .756 .931 r
.27134 .296 .28896 .31339 .31586 .30464 .29841 .28692 Metetra
.633 .751 .933 r
.29841 .28692 .31586 .30464 .34302 .29641 .32575 .27826 Metetra
.629 .746 .932 r
.32575 .27826 .34302 .29641 .37047 .28843 .35339 .26979 Metetra
.629 .742 .929 r
.35339 .26979 .37047 .28843 .39824 .28035 .38134 .26122 Metetra
.634 .74 .925 r
.38134 .26122 .39824 .28035 .42635 .27184 .40963 .25226 Metetra
.642 .74 .92 r
.40963 .25226 .42635 .27184 .4548 .26261 .43827 .24267 Metetra
.652 .742 .915 r
.43827 .24267 .4548 .26261 .48358 .25247 .46724 .23229 Metetra
.663 .745 .912 r
.46724 .23229 .48358 .25247 .51268 .24139 .49653 .22109 Metetra
.671 .75 .909 r
.49653 .22109 .51268 .24139 .54207 .22945 .52613 .20914 Metetra
.677 .754 .909 r
.52613 .20914 .54207 .22945 .57174 .21689 .55602 .19665 Metetra
.68 .758 .911 r
.55602 .19665 .57174 .21689 .60169 .20402 .5862 .18387 Metetra
.678 .762 .914 r
.5862 .18387 .60169 .20402 .63194 .1912 .61669 .1711 Metetra
.673 .763 .918 r
.61669 .1711 .63194 .1912 .6625 .17873 .6475 .15862 Metetra
.664 .762 .923 r
.6475 .15862 .6625 .17873 .6934 .16686 .67865 .14662 Metetra
.654 .759 .927 r
.67865 .14662 .6934 .16686 .72469 .1557 .71019 .13521 Metetra
.653 .744 .916 r
.01874 .37137 .03794 .38877 .06276 .37984 .04369 .36225 Metetra
.663 .746 .912 r
.04369 .36225 .06276 .37984 .08792 .37013 .06897 .35246 Metetra
.67 .749 .909 r
.06897 .35246 .08792 .37013 .1134 .35974 .09458 .34206 Metetra
.675 .752 .909 r
.09458 .34206 .1134 .35974 .13917 .34884 .12046 .33123 Metetra
.677 .756 .91 r
.12046 .33123 .13917 .34884 .16519 .33772 .14661 .32018 Metetra
.676 .758 .913 r
.14661 .32018 .16519 .33772 .19142 .32665 .17298 .30916 Metetra
.671 .76 .917 r
.17298 .30916 .19142 .32665 .21786 .3159 .19957 .29839 Metetra
.663 .76 .922 r
.19957 .29839 .21786 .3159 .24449 .30565 .22636 .28804 Metetra
.654 .758 .926 r
.22636 .28804 .24449 .30565 .27134 .296 .25338 .27817 Metetra
.644 .755 .929 r
.25338 .27817 .27134 .296 .29841 .28692 .28063 .26877 Metetra
.637 .751 .931 r
.28063 .26877 .29841 .28692 .32575 .27826 .30815 .25971 Metetra
.633 .747 .93 r
.30815 .25971 .32575 .27826 .35339 .26979 .33597 .25079 Metetra
.633 .744 .928 r
.33597 .25079 .35339 .26979 .38134 .26122 .36411 .24176 Metetra
.637 .742 .924 r
.36411 .24176 .38134 .26122 .40963 .25226 .39259 .23239 Metetra
.644 .742 .92 r
.39259 .23239 .40963 .25226 .43827 .24267 .42141 .22246 Metetra
.653 .744 .916 r
.42141 .22246 .43827 .24267 .46724 .23229 .45057 .21184 Metetra
.661 .746 .913 r
.45057 .21184 .46724 .23229 .49653 .22109 .48006 .2005 Metetra
.669 .75 .911 r
.48006 .2005 .49653 .22109 .52613 .20914 .50987 .1885 Metetra
.674 .754 .911 r
.50987 .1885 .52613 .20914 .55602 .19665 .53998 .17602 Metetra
.676 .757 .912 r
.53998 .17602 .55602 .19665 .5862 .18387 .5704 .16328 Metetra
.675 .76 .915 r
.5704 .16328 .5862 .18387 .61669 .1711 .60112 .15052 Metetra
.67 .761 .919 r
.60112 .15052 .61669 .1711 .6475 .15862 .63218 .13799 Metetra
.663 .761 .923 r
.63218 .13799 .6475 .15862 .67865 .14662 .66358 .12584 Metetra
.655 .758 .926 r
.66358 .12584 .67865 .14662 .71019 .13521 .69536 .11417 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.09549 .2323 m
.1002 .23687 L
s
[(-4)] .08608 .22315 1 .97179 Mshowa
.21633 .18498 m
.22084 .18975 L
s
[(-2)] .20731 .17545 .94563 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.47614 .08324 m
.48017 .08842 L
s
[(2)] .46808 .07289 .77884 1 Mshowa
.61605 .02846 m
.6198 .03385 L
s
[(4)] .60856 .01769 .69544 1 Mshowa
.125 Mabswid
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.18558 .19702 m
.18832 .19985 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.51046 .06981 m
.51284 .07294 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.06616 .24378 m
.06901 .2465 L
s
.65216 .01432 m
.65436 .01759 L
s
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.6"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " can render any graphics object within a ",
  StyleBox["Rectangle", "MR"],
  ". In all cases, what it puts in the rectangle is a scaled down version of \
what would be obtained if you displayed the graphics object on its own. \
Notice that in general the display area for the graphics object will be sized \
so as to touch at least one pair of edges of the rectangle. "
}], "Text",
  CellTags->{"S2.10.6", "6.5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.10.7 Density and Contour Plots", "Subsection",
  CellTags->{"S2.10.7", "7.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["DensityGraphics[", "MR"],
              StyleBox["array", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["density plot "]},
          {Cell[TextData[{
              StyleBox["ContourGraphics[", "MR"],
              StyleBox["array", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell["contour plot "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.7"],

Cell["Graphics objects that represent density and contour plots. ", "Caption",
  CellTags->"S2.10.7"],

Cell[TextData[{
  "The functions ",
  StyleBox["DensityPlot", "MR"],
  " and ",
  StyleBox["ContourPlot", "MR"],
  " discussed in Section ",
  ButtonBox["1.9.5",
    ButtonData:>{"1.9.5", "5.1"},
    ButtonStyle->"MainBookLink"],
  " work by creating ",
  StyleBox["ContourGraphics", "MR"],
  " and ",
  StyleBox["DensityGraphics", "MR"],
  " objects containing arrays of values. "
}], "Text",
  CellTags->{"S2.10.7", "7.2"}],

Cell["\<\
Most of the options for density and contour plots are the same as \
those for ordinary two\[Hyphen]dimensional plots. There are, however, a few \
additional options. \
\>", "Text",
  CellTags->{"S2.10.7", "7.3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ColorFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["how to assign colors to each cell "]},
          {Cell[TextData[{
              StyleBox["ColorFunctionScaling", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[
            "whether to scale values before applying a color function "]},
          {Cell[TextData[{
              StyleBox["Mesh", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to draw a mesh "]},
          {Cell[TextData[{
              StyleBox["MeshStyle", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["a style for the mesh "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.10.7"],

Cell["Additional options for density plots. ", "Caption",
  CellTags->"S2.10.7"],

Cell[TextData[{
  "In a density plot, the color of each cell represents its value. By \
default, each cell is assigned a gray level, running from black to white as \
the value of the cell increases. In general, however, you can specify other \
\[OpenCurlyDoubleQuote]color maps\[CloseCurlyDoubleQuote] for the relation \
between the value of a cell and its color. The option ",
  StyleBox["ColorFunction", "MR"],
  " allows you to specify a function which is applied to each cell value to \
find the color of the cell. With ",
  StyleBox["ColorFunctionScaling->True", "MR"],
  " the cell values are scaled so as to run between 0 and 1 in a particular \
density plot; with ",
  StyleBox["ColorFunctionScaling->False", "MR"],
  " no such scaling is performed. The function you give as the setting for ",
  StyleBox["ColorFunction", "MR"],
  " may return any ",
  StyleBox["Mathematica", "TI"],
  " color directive, such as ",
  StyleBox["GrayLevel", "MR"],
  ", ",
  StyleBox["Hue", "MR"],
  " or ",
  StyleBox["RGBColor", "MR"],
  ". A common setting to use is ",
  StyleBox["ColorFunction", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Hue", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.7", "7.4"}],

Cell[TextData[{
  "Here is a density plot with the default ",
  StyleBox["ColorFunction", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.7", "7.5"}],

Cell[CellGroupData[{

Cell["DensityPlot[Sin[x y], {x, -1, 1}, {y, -1, 1}]", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.480769 0.5 0.480769 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -12 -9 ]
[.25962 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -24 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-1)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(0.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-1)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-0.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(0.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
25 string
25 25 8 [25 0 0 25 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFF8F0E7DED3C8BDB1A5998C7F73665A4E42372C21180F0700
F8F1E9E0D7CDC3B8ADA2978B7F74685D52473C32281F160E07
F0E9E1D9D0C7BDB3A99F958A7F756A60564C42382F261E160F
E7E0D9D1C8C0B7AEA59C928980766D635A51483F372E261F18
DED7D0C8C1B9B1A9A199908880776F665E564E463E372F2821
D3CDC7C0B9B2ABA49D968E8780787169625B544D463F38322C
C8C3BDB7B1ABA59F99928C868079736D66605A544E48423C37
BDB8B3AEA9A49F9A958F8A85807A75706A65605B56514C4742
B1ADA9A5A19D9995908C8884807B77736F6A66625E5A56524E
A5A29F9C9996928F8C898683807C797673706D696663605D5A
99979592908E8C8A88868482807D7B79777573716F6D6A6866
8C8B8A898887868584838281807E7D7C7B7A79787776757473
7F7F7F80808080808080808080808080808080808080808080
737475767778797A7B7C7D7E808182838485868788898A8B8C
66686A6D6F71737577797B7D80828486888A8C8E9092959799
5A5D606366696D707376797C808386898C8F9296999C9FA2A5
4E52565A5E62666A6F73777B8084888C9095999DA1A5A9ADB1
42474C51565B60656A70757A80858A8F959A9FA4A9AEB3B8BD
373C42484E545A60666D737980868C92999FA5ABB1B7BDC3C8
2C32383F464D545B6269717880878E969DA4ABB2B9C0C7CDD3
21282F373E464E565E666F7780889099A1A9B1B9C1C8D0D7DE
181F262E373F48515A636D768089929CA5AEB7C0C8D1D9E0E7
0F161E262F38424C56606A75808A959FA9B3BDC7D0D9E1E9F0
070E161F28323C47525D6874808B97A2ADB8C3CDD7E0E9F1F8
00070F18212C37424E5A6673808C99A5B1BDC8D3DEE7F0F8FF
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.05769 .01923 m
.05769 .98077 L
s
.09615 .01923 m
.09615 .98077 L
s
.13462 .01923 m
.13462 .98077 L
s
.17308 .01923 m
.17308 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.25 .01923 m
.25 .98077 L
s
.28846 .01923 m
.28846 .98077 L
s
.32692 .01923 m
.32692 .98077 L
s
.36538 .01923 m
.36538 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.44231 .01923 m
.44231 .98077 L
s
.48077 .01923 m
.48077 .98077 L
s
.51923 .01923 m
.51923 .98077 L
s
.55769 .01923 m
.55769 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.63462 .01923 m
.63462 .98077 L
s
.67308 .01923 m
.67308 .98077 L
s
.71154 .01923 m
.71154 .98077 L
s
.75 .01923 m
.75 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.82692 .01923 m
.82692 .98077 L
s
.86538 .01923 m
.86538 .98077 L
s
.90385 .01923 m
.90385 .98077 L
s
.94231 .01923 m
.94231 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .05769 m
.98077 .05769 L
s
.01923 .09615 m
.98077 .09615 L
s
.01923 .13462 m
.98077 .13462 L
s
.01923 .17308 m
.98077 .17308 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .25 m
.98077 .25 L
s
.01923 .28846 m
.98077 .28846 L
s
.01923 .32692 m
.98077 .32692 L
s
.01923 .36538 m
.98077 .36538 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .44231 m
.98077 .44231 L
s
.01923 .48077 m
.98077 .48077 L
s
.01923 .51923 m
.98077 .51923 L
s
.01923 .55769 m
.98077 .55769 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .63462 m
.98077 .63462 L
s
.01923 .67308 m
.98077 .67308 L
s
.01923 .71154 m
.98077 .71154 L
s
.01923 .75 m
.98077 .75 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .82692 m
.98077 .82692 L
s
.01923 .86538 m
.98077 .86538 L
s
.01923 .90385 m
.98077 .90385 L
s
.01923 .94231 m
.98077 .94231 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]= ",
  CellTags->"S2.10.7"]
}, Open  ]],

Cell["\<\
This gives a density plot with a different \
\[OpenCurlyDoubleQuote]color map\[CloseCurlyDoubleQuote]. \
\>", "MathCaption",\

  CellTags->{"S2.10.7", "7.6"}],

Cell[CellGroupData[{

Cell["Show[%, ColorFunction -> (GrayLevel[#^3]&)]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.480769 0.5 0.480769 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -12 -9 ]
[.25962 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -24 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-1)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(0.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-1)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-0.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(0.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
25 string
25 25 8 [25 0 0 25 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFEAD4BDA7907B675545362A1F17100B070402010000000000
EAD6C1AC98847160504134291F18110C080503010100000000
D4C1AE9B897867584A3D32281F18120D090604020100000000
BDAC9B8B7B6C5E51453A30272019130F0B0805030201000000
A798897B6E61554A40362E26201A14100C0907050302010100
9084786C61574D443B332C25201A16120E0B09070503020101
7B71675E554D453D36302A24201B1713100D0B090705040302
676058514A443D38322D2824201C181512100D0B0908060504
55504A45403B36322E2A2623201C1A171412100E0C0B090807
45413D3A3633302D2A272422201D1B1917151312100F0D0C0B
363432302E2C2A2826242321201E1C1B1A1817161413121110
2A2928272625242423222120201F1E1D1C1C1B1A1A19181817
1F1F1F20202020202020202020202020202020202020202020
171818191A1A1B1C1C1D1E1F2020212223242425262728292A
10111213141617181A1B1C1E2021232426282A2C2E30323436
0B0C0D0F1012131517191B1D202224272A2D3033363A3D4145
0708090B0C0E101214171A1C2023262A2E32363B40454A5055
04050608090B0D101215181C2024282D32383D444A51586067
0203040507090B0D1013171B20242A30363D454D555E67717B
010102030507090B0E12161A20252C333B444D57616C788490
00010102030507090C10141A20262E36404A55616E7B8998A7
00000001020305080B0F13192027303A45515E6C7B8B9BACBD
0000000001020406090D12182028323D4A586778899BAEC1D4
0000000001010305080C1118202934415060718498ACC1D6EA
0000000000010204070B1017202A364555677B90A7BDD4EAFF
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.05769 .01923 m
.05769 .98077 L
s
.09615 .01923 m
.09615 .98077 L
s
.13462 .01923 m
.13462 .98077 L
s
.17308 .01923 m
.17308 .98077 L
s
.21154 .01923 m
.21154 .98077 L
s
.25 .01923 m
.25 .98077 L
s
.28846 .01923 m
.28846 .98077 L
s
.32692 .01923 m
.32692 .98077 L
s
.36538 .01923 m
.36538 .98077 L
s
.40385 .01923 m
.40385 .98077 L
s
.44231 .01923 m
.44231 .98077 L
s
.48077 .01923 m
.48077 .98077 L
s
.51923 .01923 m
.51923 .98077 L
s
.55769 .01923 m
.55769 .98077 L
s
.59615 .01923 m
.59615 .98077 L
s
.63462 .01923 m
.63462 .98077 L
s
.67308 .01923 m
.67308 .98077 L
s
.71154 .01923 m
.71154 .98077 L
s
.75 .01923 m
.75 .98077 L
s
.78846 .01923 m
.78846 .98077 L
s
.82692 .01923 m
.82692 .98077 L
s
.86538 .01923 m
.86538 .98077 L
s
.90385 .01923 m
.90385 .98077 L
s
.94231 .01923 m
.94231 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .05769 m
.98077 .05769 L
s
.01923 .09615 m
.98077 .09615 L
s
.01923 .13462 m
.98077 .13462 L
s
.01923 .17308 m
.98077 .17308 L
s
.01923 .21154 m
.98077 .21154 L
s
.01923 .25 m
.98077 .25 L
s
.01923 .28846 m
.98077 .28846 L
s
.01923 .32692 m
.98077 .32692 L
s
.01923 .36538 m
.98077 .36538 L
s
.01923 .40385 m
.98077 .40385 L
s
.01923 .44231 m
.98077 .44231 L
s
.01923 .48077 m
.98077 .48077 L
s
.01923 .51923 m
.98077 .51923 L
s
.01923 .55769 m
.98077 .55769 L
s
.01923 .59615 m
.98077 .59615 L
s
.01923 .63462 m
.98077 .63462 L
s
.01923 .67308 m
.98077 .67308 L
s
.01923 .71154 m
.98077 .71154 L
s
.01923 .75 m
.98077 .75 L
s
.01923 .78846 m
.98077 .78846 L
s
.01923 .82692 m
.98077 .82692 L
s
.01923 .86538 m
.98077 .86538 L
s
.01923 .90385 m
.98077 .90385 L
s
.01923 .94231 m
.98077 .94231 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.7"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["Contours", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["10", "MR"],
              " "
            }]], Cell["what contours to use "]},
          {Cell[TextData[{
              StyleBox["ContourLines", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to draw contour lines "]},
          {Cell[TextData[{
              StyleBox["ContourStyle", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["style to use for contour lines "]},
          {Cell[TextData[{
              StyleBox["ContourShading", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell["whether to shade regions in the plot "]},
          {Cell[TextData[{
              StyleBox["ColorFunction", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell["how to assign colors to contour levels "]},
          {Cell[TextData[{
              StyleBox["ColorFunctionScaling", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["True", "MR"],
              " "
            }]], Cell[
            "whether to scale values before applying a color function "]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.10.7"],

Cell["Options for contour plots. ", "Caption",
  CellTags->"S2.10.7"],

Cell[TextData[{
  "In constructing a contour plot, the first issue is what contours to use. \
With the default setting ",
  StyleBox["Contours", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["10", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " uses a sequence of 10 contour levels equally spaced between the minimum \
and maximum values defined by the ",
  StyleBox["PlotRange", "MR"],
  " option. "
}], "Text",
  CellTags->{"S2.10.7", "7.7"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Contours", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["n", "TI"],
              " "
            }]], Cell[TextData[{
              "use a sequence of ",
              StyleBox["n", "TI"],
              " equally spaced contours "
            }]]},
          {Cell[TextData[{
              StyleBox["Contours", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}", "MR"],
              " "
            }]], Cell[TextData[{
              "use contours with values ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.7"],

Cell["Specifying contours. ", "Caption",
  CellTags->"S2.10.7"],

Cell["This creates a contour plot with two contours. ", "MathCaption",
  CellTags->{"S2.10.7", "7.8"}],

Cell[CellGroupData[{

Cell["\<\
ContourPlot[Sin[x y], {x, -1, 1}, {y, -1, 1}, Contours -> {-.5, \
.5}]\
\>", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.7"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.480769 0.5 0.480769 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -12 -9 ]
[.25962 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -9 -9 ]
[.74038 -0.0125 9 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -24 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -18 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-1)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-0.5)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(0.5)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(1)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-1)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-0.5)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(0.5)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(1)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
1 g
.01923 .24827 m
.05929 .22539 L
.06846 .21955 L
.09936 .19793 L
.12241 .17949 L
.13942 .16436 L
.16436 .13942 L
.17949 .12241 L
.19793 .09936 L
.21955 .06846 L
.22539 .05929 L
.24827 .01923 L
.01923 .01923 L
F
0 g
.01923 .24827 m
.05929 .22539 L
.06846 .21955 L
.09936 .19793 L
.12241 .17949 L
.13942 .16436 L
.16436 .13942 L
.17949 .12241 L
.19793 .09936 L
.21955 .06846 L
.22539 .05929 L
.24827 .01923 L
s
.01923 .75173 m
.05929 .77461 L
.06846 .78045 L
.09936 .80207 L
.12241 .82051 L
.13942 .83564 L
.16436 .86058 L
.17949 .87759 L
.19793 .90064 L
.21955 .93154 L
.22539 .94071 L
.24827 .98077 L
.01923 .98077 L
F
.01923 .75173 m
.05929 .77461 L
.06846 .78045 L
.09936 .80207 L
.12241 .82051 L
.13942 .83564 L
.16436 .86058 L
.17949 .87759 L
.19793 .90064 L
.21955 .93154 L
.22539 .94071 L
.24827 .98077 L
s
.98077 .24827 m
.94071 .22539 L
.93154 .21955 L
.90064 .19793 L
.87759 .17949 L
.86058 .16436 L
.83564 .13942 L
.82051 .12241 L
.80207 .09936 L
.78045 .06846 L
.77461 .05929 L
.75173 .01923 L
.98077 .01923 L
F
.98077 .24827 m
.94071 .22539 L
.93154 .21955 L
.90064 .19793 L
.87759 .17949 L
.86058 .16436 L
.83564 .13942 L
.82051 .12241 L
.80207 .09936 L
.78045 .06846 L
.77461 .05929 L
.75173 .01923 L
s
1 g
.98077 .75173 m
.94071 .77461 L
.93154 .78045 L
.90064 .80207 L
.87759 .82051 L
.86058 .83564 L
.83564 .86058 L
.82051 .87759 L
.80207 .90064 L
.78045 .93154 L
.77461 .94071 L
.75173 .98077 L
.98077 .98077 L
F
0 g
.98077 .75173 m
.94071 .77461 L
.93154 .78045 L
.90064 .80207 L
.87759 .82051 L
.86058 .83564 L
.83564 .86058 L
.82051 .87759 L
.80207 .90064 L
.78045 .93154 L
.77461 .94071 L
.75173 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.7"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  ContourGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.7"]
}, Open  ]],

Cell[TextData[{
  "There are some slight subtleties associated with labeling density and \
contour plots. Both the ",
  StyleBox["Axes", "MR"],
  " and ",
  StyleBox["Frame", "MR"],
  " options from ordinary two\[Hyphen]dimensional graphics can be used. But \
setting ",
  StyleBox["AxesOrigin", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  " keeps the axes outside the plot in both cases. "
}], "Text",
  CellTags->{"S2.10.7", "7.9"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.10.8 Three\[Hyphen]Dimensional Graphics Primitives\
\>", \
"Subsection",
  CellTags->{"S2.10.8", "8.1"}],

Cell[TextData[{
  "One of the most powerful aspects of graphics in ",
  StyleBox["Mathematica", "TI"],
  " is the availability of three\[Hyphen]dimensional as well as \
two\[Hyphen]dimensional graphics primitives. By combining \
three\[Hyphen]dimensional graphics primitives, you can represent and render \
three\[Hyphen]dimensional objects in ",
  StyleBox["Mathematica", "TI"],
  ". "
}], "Text",
  CellTags->{"S2.10.8", "8.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Point[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "point with coordinates ",
              StyleBox["x", "TI"],
              ", ",
              StyleBox["y", "TI"],
              ", ",
              StyleBox["z", "TI"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Line[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "line through the points ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              ", ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              "}",
              StyleBox[", ", "TR"],
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["}", "MR"],
              ", \[Ellipsis]",
              " ",
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Polygon[{{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "1"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], "2"], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              "\[Ellipsis]",
              " ",
              StyleBox["}]", "MR"],
              " "
            }]], Cell["filled polygon with the specified list of corners "]},
          {Cell[TextData[{
              StyleBox["Cuboid[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell["cuboid "]},
          {Cell[TextData[{
              StyleBox["Text[", "MR"],
              StyleBox["expr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "text at position ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}", "MR"],
              " (see Section ",
              ButtonBox["2.10.16",
                ButtonData:>{"2.10.16", "16.1"},
                ButtonStyle->"MainBookLink"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.8"],

Cell["\<\
Three\[Hyphen]dimensional graphics elements. \
\>", "Caption",
  CellTags->"S2.10.8"],

Cell[TextData[{
  "Every time you evaluate ",
  StyleBox["rcoord", "MR"],
  ", it generates a random coordinate in three dimensions. "
}], "MathCaption",
  CellTags->{"S2.10.8", "8.3"}],

Cell["rcoord := {Random[ ], Random[ ], Random[ ]}", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.8"],

Cell["\<\
This generates a list of 20 random points in \
three\[Hyphen]dimensional space. \
\>", "MathCaption",
  CellTags->{"S2.10.8", "8.4"}],

Cell["pts = Table[Point[rcoord], {20}] ;", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.8"],

Cell["Here is a plot of the points. ", "MathCaption",
  CellTags->{"S2.10.8", "8.5"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ pts ] ]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08326 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0554539 1.16767 1.4859e-16 1.16767 [
[ 0 0 0 0 ]
[ 1 1.08326 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08171 .24016 m
0 .77813 L
s
0 .77813 m
.417 1.08326 L
s
.417 1.08326 m
.43131 .59727 L
s
.43131 .59727 m
.08171 .24016 L
s
.65859 0 m
.9338 .43476 L
s
.9338 .43476 m
1 .94671 L
s
1 .94671 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.08171 .24016 m
0 .77813 L
s
0 .77813 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.65859 0 m
.08171 .24016 L
s
.43131 .59727 m
.9338 .43476 L
s
.9338 .43476 m
1 .94671 L
s
1 .94671 m
.417 1.08326 L
s
.417 1.08326 m
.43131 .59727 L
s
0 0 m
1 0 L
1 1.08326 L
0 1.08326 L
closepath
clip
newpath
.01 w
.57938 .51056 Mdot
.63475 .61502 Mdot
.5223 .84453 Mdot
.35814 .67288 Mdot
.62942 .62632 Mdot
.91477 .57034 Mdot
.65551 .41317 Mdot
.37048 .50384 Mdot
.49773 .84322 Mdot
.93085 .77677 Mdot
.93513 .73083 Mdot
.66413 .28458 Mdot
.4403 .6895 Mdot
.95476 .91992 Mdot
.66701 .17489 Mdot
.57298 .28337 Mdot
.70249 .44539 Mdot
.3004 .47703 Mdot
.77833 .65378 Mdot
.72652 .57506 Mdot
.25 Mabswid
.65859 0 m
.9338 .43476 L
s
.9338 .43476 m
1 .94671 L
s
1 .94671 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.08171 .24016 m
0 .77813 L
s
0 .77813 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.65859 0 m
.08171 .24016 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell["\<\
This gives a plot showing a line through 10 random points in three \
dimensions. \
\>", "MathCaption",
  CellTags->{"S2.10.8", "8.6"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ Line[ Table[rcoord, {10}] ] ] ]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.43083 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.208652 1.50056 -1.05547e-16 1.50056 [
[ 0 0 0 0 ]
[ 1 1.43083 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.09094 .18159 m
0 .98833 L
s
0 .98833 m
.55738 1.43083 L
s
.55738 1.43083 m
.55519 .7014 L
s
.55519 .7014 m
.09094 .18159 L
s
.52427 0 m
.93314 .57821 L
s
.93314 .57821 m
1 1.32866 L
s
1 1.32866 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.09094 .18159 m
0 .98833 L
s
0 .98833 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.52427 0 m
.09094 .18159 L
s
.55519 .7014 m
.93314 .57821 L
s
.93314 .57821 m
1 1.32866 L
s
1 1.32866 m
.55738 1.43083 L
s
.55738 1.43083 m
.55519 .7014 L
s
0 0 m
1 0 L
1 1.43083 L
0 1.43083 L
closepath
clip
newpath
.5 Mabswid
.50764 .67631 m
.30347 .36319 L
s
.30856 .4273 m
.50764 .67631 L
s
.30347 .36319 m
.80946 .99315 L
s
.65641 1.37643 m
.40962 .72556 L
s
.46595 .81082 m
.71104 .84733 L
s
.34077 1.01409 m
.46595 .81082 L
s
.28837 .3884 m
.34077 1.01409 L
s
.80946 .99315 m
.28837 .3884 L
s
.40962 .72556 m
.30856 .4273 L
s
.25 Mabswid
.52427 0 m
.93314 .57821 L
s
.93314 .57821 m
1 1.32866 L
s
1 1.32866 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.09094 .18159 m
0 .98833 L
s
0 .98833 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.52427 0 m
.09094 .18159 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell[TextData[{
  "If you give a list of graphics elements in two dimensions, ",
  StyleBox["Mathematica", "TI"],
  " simply draws each element in turn, with later elements obscuring earlier \
ones. In three dimensions, however, ",
  StyleBox["Mathematica", "TI"],
  " collects together all the graphics elements you specify, then displays \
them as three\[Hyphen]dimensional objects, with the ones in front in three\
\[Hyphen]dimensional space obscuring those behind. "
}], "Text",
  CellTags->{"S2.10.8", "8.7"}],

Cell[TextData[{
  "Every time you evaluate ",
  StyleBox["rantri", "MR"],
  ", it generates a random triangle in three\[Hyphen]dimensional space. "
}], "MathCaption",
  CellTags->{"S2.10.8", "8.8"}],

Cell["rantri := Polygon[ Table[ rcoord, {3} ] ]", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.8"],

Cell["This draws a single random triangle. ", "MathCaption",
  CellTags->{"S2.10.8", "8.9"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ rantri ] ]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1216 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0717489 1.20242 1.16985e-16 1.20242 [
[ 0 0 0 0 ]
[ 1 1.1216 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08593 .23625 m
0 .8124 L
s
0 .8124 m
.42472 1.1216 L
s
.42472 1.1216 m
.43884 .60121 L
s
.43884 .60121 m
.08593 .23625 L
s
.65047 0 m
.93088 .44109 L
s
.93088 .44109 m
1 .98839 L
s
1 .98839 m
.67705 .60121 L
s
.67705 .60121 m
.65047 0 L
s
.08593 .23625 m
0 .8124 L
s
0 .8124 m
.67705 .60121 L
s
.67705 .60121 m
.65047 0 L
s
.65047 0 m
.08593 .23625 L
s
.43884 .60121 m
.93088 .44109 L
s
.93088 .44109 m
1 .98839 L
s
1 .98839 m
.42472 1.1216 L
s
.42472 1.1216 m
.43884 .60121 L
s
0 0 m
1 0 L
1 1.1216 L
0 1.1216 L
closepath
clip
newpath
.5 Mabswid
.797 .607 .645 r
.89786 .42291 m .06254 .56376 L .74326 1.02447 L closepath p F P
0 g
s
.25 Mabswid
.65047 0 m
.93088 .44109 L
s
.93088 .44109 m
1 .98839 L
s
1 .98839 m
.67705 .60121 L
s
.67705 .60121 m
.65047 0 L
s
.08593 .23625 m
0 .8124 L
s
0 .8124 m
.67705 .60121 L
s
.67705 .60121 m
.65047 0 L
s
.65047 0 m
.08593 .23625 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell["\<\
This draws a collection of 5 random triangles. The triangles in \
front obscure those behind. \
\>", "MathCaption",
  CellTags->{"S2.10.8", "8.10"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ Table[rantri, {5}] ] ]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.09167 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0593183 1.17066 -6.60821e-17 1.17066 [
[ 0 0 0 0 ]
[ 1 1.09167 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08836 .24494 m
0 .80957 L
s
0 .80957 m
.39985 1.09167 L
s
.39985 1.09167 m
.41752 .58133 L
s
.41752 .58133 m
.08836 .24494 L
s
.67186 0 m
.92704 .41437 L
s
.92704 .41437 m
1 .95398 L
s
1 .95398 m
.70569 .59196 L
s
.70569 .59196 m
.67186 0 L
s
.08836 .24494 m
0 .80957 L
s
0 .80957 m
.70569 .59196 L
s
.70569 .59196 m
.67186 0 L
s
.67186 0 m
.08836 .24494 L
s
.41752 .58133 m
.92704 .41437 L
s
.92704 .41437 m
1 .95398 L
s
1 .95398 m
.39985 1.09167 L
s
.39985 1.09167 m
.41752 .58133 L
s
0 0 m
1 0 L
1 1.09167 L
0 1.09167 L
closepath
clip
newpath
.5 Mabswid
.624 .786 .959 r
.42704 .628 m .69423 .40341 L .39495 .38374 L p F P
0 g
s
.624 .786 .959 r
.37181 .55426 m .42704 .628 L p .39495 .38374 L F P
0 g
s
.321 .494 .873 r
.70905 .55349 m .41242 .64906 L .36822 .58073 L p F P
0 g
s
.321 .494 .873 r
.36822 .58073 m .25387 .40397 L .3863 .44747 L p F P
0 g
s
.717 .751 .879 r
.6021 .38566 m .76564 .53268 L .48855 .53516 L p F P
0 g
s
.321 .494 .873 r
.3863 .44747 m .46702 .47399 L p .36822 .58073 L F P
0 g
s
.321 .494 .873 r
.46702 .47399 m .50086 .57013 L .36822 .58073 L F
.624 .786 .959 r
.39495 .38374 m .23631 .37332 L .37181 .55426 L p F P
0 g
s
.717 .751 .879 r
.48855 .53516 m .22874 .53749 L .45673 .44477 L p F P
0 g
s
.717 .751 .879 r
.45673 .44477 m .6021 .38566 L p .48855 .53516 L F P
0 g
s
.321 .494 .873 r
.46702 .47399 m .70905 .55349 L p .50086 .57013 L F P
0 g
s
.282 0 .006 r
.79345 .61469 m .89601 .50421 L .61358 .61635 L closepath p F P
0 g
s
.802 .538 .539 r
.77719 .9823 m .38542 .7136 L .59135 .7666 L closepath p F P
0 g
s
.25 Mabswid
.67186 0 m
.92704 .41437 L
s
.92704 .41437 m
1 .95398 L
s
1 .95398 m
.70569 .59196 L
s
.70569 .59196 m
.67186 0 L
s
.08836 .24494 m
0 .80957 L
s
0 .80957 m
.70569 .59196 L
s
.70569 .59196 m
.67186 0 L
s
.67186 0 m
.08836 .24494 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell[TextData[{
  "By creating an appropriate list of polygons, you can build up any three\
\[Hyphen]dimensional object in ",
  StyleBox["Mathematica", "TI"],
  ". Thus, for example, all the surfaces produced by ",
  StyleBox["ParametricPlot3D", "MR"],
  " are represented simply as lists of polygons. "
}], "Text",
  CellTags->{"S2.10.8", "8.11"}],

Cell[TextData[{
  "The package ",
  StyleBox["Graphics`Polyhedra`", "MR"],
  " contains examples of lists of polygons which correspond to polyhedra in \
three dimensions. "
}], "Text",
  CellTags->{"S2.10.8", "8.12"}],

Cell["This loads a package which defines various polyhedra. ", "MathCaption",
  CellTags->{"S2.10.8", "8.13"}],

Cell["<<Graphics`Polyhedra`", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.8"],

Cell["\<\
Here is the list of polygons corresponding to a tetrahedron \
centered at the origin. \
\>", "MathCaption",
  CellTags->{"S2.10.8", "8.14"}],

Cell[CellGroupData[{

Cell["Tetrahedron[ ]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.8"],

Cell[BoxData[
    \({Polygon[{{0.`, 0.`, 1.7320508075688772`}, {0.`, 
            1.632993161855452`, \(-0.5773502691896257`\)}, \
{\(-1.4142135623730951`\), \(-0.816496580927726`\), \
\(-0.5773502691896257`\)}}], 
      Polygon[{{0.`, 0.`, 
            1.7320508075688772`}, {\(-1.4142135623730951`\), \
\(-0.816496580927726`\), \(-0.5773502691896257`\)}, {1.4142135623730951`, \
\(-0.816496580927726`\), \(-0.5773502691896257`\)}}], 
      Polygon[{{0.`, 0.`, 
            1.7320508075688772`}, {1.4142135623730951`, \(-0.816496580927726`\
\), \(-0.5773502691896257`\)}, {0.`, 
            1.632993161855452`, \(-0.5773502691896257`\)}}], 
      Polygon[{{0.`, 
            1.632993161855452`, \(-0.5773502691896257`\)}, \
{1.4142135623730951`, \(-0.816496580927726`\), \(-0.5773502691896257`\)}, \
{\(-1.4142135623730951`\), \(-0.816496580927726`\), \
\(-0.5773502691896257`\)}}]}\)], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell["\<\
This displays the tetrahedron as a three\[Hyphen]dimensional \
object. \
\>", "MathCaption",
  CellTags->{"S2.10.8", "8.15"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ % ] ]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00395 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.021936 1.08048 3.06829e-17 1.08048 [
[ 0 0 0 0 ]
[ 1 1.00395 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07126 .25397 m
0 .73686 L
s
0 .73686 m
.36259 1.00395 L
s
.36259 1.00395 m
.38081 .56173 L
s
.38081 .56173 m
.07126 .25397 L
s
.69971 0 m
.93785 .38108 L
s
.93785 .38108 m
1 .84869 L
s
1 .84869 m
.73283 .5067 L
s
.73283 .5067 m
.69971 0 L
s
.07126 .25397 m
0 .73686 L
s
0 .73686 m
.73283 .5067 L
s
.73283 .5067 m
.69971 0 L
s
.69971 0 m
.07126 .25397 L
s
.38081 .56173 m
.93785 .38108 L
s
.93785 .38108 m
1 .84869 L
s
1 .84869 m
.36259 1.00395 L
s
.36259 1.00395 m
.38081 .56173 L
s
0 0 m
1 0 L
1 1.00395 L
0 1.00395 L
closepath
clip
newpath
.5 Mabswid
.67 .732 .896 r
.64047 .47848 m .69039 .02774 L .09182 .26714 L closepath p F P
0 g
s
.808 .424 .328 r
.46626 .73274 m .64047 .47848 L .09182 .26714 L closepath p F P
0 g
s
.932 .907 .516 r
.46626 .73274 m .69039 .02774 L .64047 .47848 L closepath p F P
0 g
s
.578 .425 .637 r
.46626 .73274 m .09182 .26714 L .69039 .02774 L closepath p F P
0 g
s
.25 Mabswid
.69971 0 m
.93785 .38108 L
s
.93785 .38108 m
1 .84869 L
s
1 .84869 m
.73283 .5067 L
s
.73283 .5067 m
.69971 0 L
s
.07126 .25397 m
0 .73686 L
s
0 .73686 m
.73283 .5067 L
s
.73283 .5067 m
.69971 0 L
s
.69971 0 m
.07126 .25397 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Dodecahedron[", "MR"],
  " ",
  StyleBox["]", "MR"],
  " is another three\[Hyphen]dimensional object defined in the polyhedra \
package. "
}], "MathCaption",
  CellTags->{"S2.10.8", "8.16"}],

Cell[CellGroupData[{

Cell["Show[ Graphics3D[ Dodecahedron[ ] ] ]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 3.61581e-17 1.08755 [
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.5 Mabswid
.67 .732 .896 r
.33115 .32429 m .44491 .44907 L .65615 .42467 L p F P
0 g
s
.889 .75 .702 r
.44491 .44907 m .33115 .32429 L p .24235 .68284 L F P
0 g
s
.889 .75 .702 r
.24235 .68284 m .39521 .65616 L .44491 .44907 L p F P
0 g
s
.675 .526 .675 r
.44491 .44907 m .39521 .65616 L .57791 .76621 L p F P
0 g
s
.675 .526 .675 r
.65615 .42467 m .44491 .44907 L p .57791 .76621 L F P
0 g
s
.762 .372 .314 r
.39521 .65616 m .24235 .68284 L p .56015 .87859 L F P
0 g
s
.762 .372 .314 r
.56015 .87859 m .57791 .76621 L .39521 .65616 L p F P
0 g
s
.67 .732 .896 r
.48589 .20782 m .33115 .32429 L p .65615 .42467 L F P
0 g
s
.67 .732 .896 r
.65615 .42467 m .69731 .27878 L .48589 .20782 L p F P
0 g
s
.675 .526 .675 r
.57791 .76621 m .74263 .62049 L .65615 .42467 L p F P
0 g
s
.273 .313 .722 r
.65615 .42467 m .74263 .62049 L .85199 .62068 L p F P
0 g
s
.273 .313 .722 r
.69731 .27878 m .65615 .42467 L p .85199 .62068 L F P
0 g
s
.244 0 .208 r
.57791 .76621 m .56015 .87859 L .73868 .79032 L p F P
0 g
s
.244 0 .208 r
.74263 .62049 m .57791 .76621 L p .73868 .79032 L F P
0 g
s
.244 0 .208 r
.73868 .79032 m .85199 .62068 L .74263 .62049 L p F P
0 g
s
.889 .75 .702 r
.33115 .32429 m .19481 .46702 L .24235 .68284 L p F P
0 g
s
0 0 0 r
.33115 .32429 m .48589 .20782 L p .25792 .45112 L F P
0 g
s
0 0 0 r
.25792 .45112 m .19481 .46702 L .33115 .32429 L p F P
0 g
s
.762 .372 .314 r
.24235 .68284 m .33664 .82736 L .56015 .87859 L p F P
0 g
s
0 .109 .635 r
.33664 .82736 m .24235 .68284 L .19481 .46702 L p F P
0 g
s
.273 .313 .722 r
.85199 .62068 m .82611 .39367 L .69731 .27878 L p F P
0 g
s
.709 .208 .046 r
.69731 .27878 m .82611 .39367 L .68527 .40123 L p F P
0 g
s
.709 .208 .046 r
.48589 .20782 m .69731 .27878 L p .68527 .40123 L F P
0 g
s
.633 .775 .949 r
.73868 .79032 m .56015 .87859 L .33664 .82736 L p F P
0 g
s
0 .109 .635 r
.19481 .46702 m .25792 .45112 L p .33664 .82736 L F P
0 g
s
.939 .801 .68 r
.82611 .39367 m .85199 .62068 L .73868 .79032 L p F P
0 g
s
.709 .208 .046 r
.68527 .40123 m .45664 .27423 L .48589 .20782 L p F P
0 g
s
0 0 0 r
.48589 .20782 m .45664 .27423 L .25792 .45112 L p F P
0 g
s
0 .109 .635 r
.25792 .45112 m .35521 .69402 L .33664 .82736 L p F P
0 g
s
.633 .775 .949 r
.33664 .82736 m .35521 .69402 L p .73868 .79032 L F P
0 g
s
.939 .801 .68 r
.68527 .40123 m .82611 .39367 L p .73868 .79032 L F P
0 g
s
.939 .801 .68 r
.73868 .79032 m .62474 .66693 L .68527 .40123 L p F P
0 g
s
.633 .775 .949 r
.35521 .69402 m .62474 .66693 L .73868 .79032 L p F P
0 g
s
.666 .512 .666 r
.62474 .66693 m .35521 .69402 L .25792 .45112 L p F P
0 g
s
.666 .512 .666 r
.68527 .40123 m .62474 .66693 L p .25792 .45112 L F P
0 g
s
.666 .512 .666 r
.25792 .45112 m .45664 .27423 L .68527 .40123 L p F P
0 g
s
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell["This shows four intersecting dodecahedra. ", "MathCaption",
  CellTags->{"S2.10.8", "8.17"}],

Cell[CellGroupData[{

Cell["\<\
Show[ Graphics3D[ Table[Dodecahedron[0.8 {k, k, k}], {k, 0, 3}] ] ]\
\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.04729 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0405499 1.13068 -8.09899e-17 1.13068 [
[ 0 0 0 0 ]
[ 1 1.04729 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08075 .248 m
0 .76374 L
s
0 .76374 m
.3939 1.04729 L
s
.3939 1.04729 m
.41072 .5804 L
s
.41072 .5804 m
.08075 .248 L
s
.67833 0 m
.93281 .41109 L
s
.93281 .41109 m
1 .90496 L
s
1 .90496 m
.71041 .54083 L
s
.71041 .54083 m
.67833 0 L
s
.08075 .248 m
0 .76374 L
s
0 .76374 m
.71041 .54083 L
s
.71041 .54083 m
.67833 0 L
s
.67833 0 m
.08075 .248 L
s
.41072 .5804 m
.93281 .41109 L
s
.93281 .41109 m
1 .90496 L
s
1 .90496 m
.3939 1.04729 L
s
.3939 1.04729 m
.41072 .5804 L
s
0 0 m
1 0 L
1 1.04729 L
0 1.04729 L
closepath
clip
newpath
.5 Mabswid
.671 .73 .894 r
.21157 .2908 m .27 .35245 L .36937 .34006 L p F P
0 g
s
.882 .743 .704 r
.27 .35245 m .21157 .2908 L p .16976 .45459 L F P
0 g
s
.882 .743 .704 r
.16976 .45459 m .24537 .45048 L .27 .35245 L p F P
0 g
s
.672 .522 .673 r
.27 .35245 m .24537 .45048 L .32999 .50014 L p F P
0 g
s
.672 .522 .673 r
.36937 .34006 m .27 .35245 L p .32999 .50014 L F P
0 g
s
.754 .331 .245 r
.24537 .45048 m .16976 .45459 L p .3113 .53847 L F P
0 g
s
.754 .331 .245 r
.3113 .53847 m .32999 .50014 L .24537 .45048 L p F P
0 g
s
.671 .73 .894 r
.27759 .23691 m .21157 .2908 L p .36937 .34006 L F P
0 g
s
.671 .73 .894 r
.36937 .34006 m .37765 .26934 L .27759 .23691 L p F P
0 g
s
.666 .738 .903 r
.41352 .46286 m .51508 .45104 L p .4912 .44385 L F P
0 g
s
.672 .522 .673 r
.40741 .43129 m .36937 .34006 L p .33947 .4616 L F P
0 g
s
.672 .522 .673 r
.37845 .45704 m .40741 .43129 L p .33947 .4616 L F P
0 g
s
.143 .227 .693 r
.36937 .34006 m .40741 .43129 L .42 .428 L p F P
0 g
s
.666 .738 .903 r
.4912 .44385 m .4256 .42409 L .4163 .45261 L F
.4256 .42409 m .42081 .42265 L .42 .428 L F
.4256 .42409 m .42 .428 L .4163 .45261 L F
.4163 .45261 m .40207 .44054 L .40523 .45391 L F
0 0 0 r
.40741 .43129 m .37845 .45704 L p .39647 .44445 L F P
0 g
s
0 0 0 r
.40398 .4392 m .40661 .43314 L .39647 .44445 L F
.40661 .43314 m .40741 .43129 L .39647 .44445 L F
.894 .755 .701 r
.41352 .46286 m .39647 .44445 L p .31802 .57099 L F P
0 g
s
.894 .755 .701 r
.31802 .57099 m .39647 .44445 L .33123 .51724 L F
.666 .738 .903 r
.39647 .44445 m .40523 .45391 L p .40207 .44054 L F P
0 g
s
0 0 0 r
.42 .428 m .40741 .43129 L p .40398 .4392 L F P
0 g
s
.143 .227 .693 r
.42394 .40181 m .36937 .34006 L .42 .428 L F
.666 .738 .903 r
.42081 .42265 m .35905 .40404 L .4163 .45261 L F
0 0 0 r
.38188 .49012 m .40398 .4392 L .39326 .44803 L F
.35002 .49627 m .39326 .44803 L .32999 .50014 L F
.38188 .49012 m .39326 .44803 L .35002 .49627 L F
.894 .755 .701 r
.31155 .53919 m .31802 .57099 L p .32393 .54696 L F P
0 g
s
.894 .755 .701 r
.32393 .54696 m .33123 .51724 L .31362 .53689 L F
.32393 .54696 m .31362 .53689 L .31155 .53919 L F
.754 .331 .245 r
.16976 .45459 m .20865 .51001 L .3113 .53847 L p F P
0 g
s
.659 .747 .915 r
.3113 .53847 m .20865 .51001 L p .27794 .50205 L F P
0 g
s
0 0 0 r
.32999 .50014 m .31257 .53587 L p .38188 .49012 L F P
0 g
s
0 0 0 r
.31257 .53587 m .3113 .53847 L p .38188 .49012 L F P
0 g
s
.659 .747 .915 r
.31362 .53689 m .3113 .53847 L p .31013 .53719 L F P
0 g
s
.659 .747 .915 r
.31045 .5338 m .31013 .53719 L .27794 .50205 L F
.31362 .53689 m .31013 .53719 L .31045 .5338 L F
.894 .755 .701 r
.31155 .53919 m .35905 .40404 L .31045 .5338 L F
.35905 .40404 m .29756 .47046 L .31045 .5338 L p F P
0 g
s
0 0 0 r
.37845 .45704 m .32999 .50014 L p .40398 .4392 L F P
0 g
s
.672 .522 .673 r
.32999 .50014 m .37845 .45704 L p .33947 .4616 L F P
0 g
s
.894 .755 .701 r
.33123 .51724 m .35905 .40404 L .31155 .53919 L F
.31802 .57099 m .38936 .56272 L .41352 .46286 L p F P
0 g
s
.756 .338 .257 r
.38936 .56272 m .31802 .57099 L p .46395 .65794 L F P
0 g
s
.756 .338 .257 r
.31802 .57099 m .36247 .6311 L .46395 .65794 L p F P
0 g
s
.043 .16 .662 r
.36247 .6311 m .31802 .57099 L .31045 .5338 L p F P
0 g
s
.043 .16 .662 r
.31045 .5338 m .29756 .47046 L p .31289 .5084 L F P
0 g
s
.894 .755 .701 r
.39647 .44445 m .35905 .40404 L p .33123 .51724 L F P
0 g
s
.659 .747 .915 r
.38188 .49012 m .31362 .53689 L p .31045 .5338 L F P
0 g
s
.043 .16 .662 r
.29756 .47046 m .317 .46569 L p .31289 .5084 L F P
0 g
s
.659 .747 .915 r
.3139 .49793 m .31045 .5338 L .27794 .50205 L F
.38188 .49012 m .31045 .5338 L .3139 .49793 L F
0 0 0 r
.29756 .47046 m .35905 .40404 L p .33368 .4538 L F P
0 g
s
0 0 0 r
.317 .46569 m .29756 .47046 L p .33368 .4538 L F P
0 g
s
.659 .747 .915 r
.20865 .51001 m .21117 .4409 L p .31127 .46976 L F P
0 g
s
.659 .747 .915 r
.38188 .49012 m .26365 .5037 L .31127 .46976 L F
.26365 .5037 m .20865 .51001 L .31127 .46976 L F
0 0 0 r
.33368 .4538 m .35905 .40404 L .34463 .44486 L F
.902 .763 .698 r
.38188 .49012 m .34164 .44813 L p .36836 .41897 L F P
0 g
s
0 0 0 r
.34164 .44813 m .34463 .44486 L .3441 .44638 L F
.33368 .4538 m .34463 .44486 L .34164 .44813 L F
.666 .738 .903 r
.35905 .40404 m .39647 .44445 L p .40207 .44054 L F P
0 g
s
.143 .227 .693 r
.37765 .26934 m .36937 .34006 L p .42394 .40181 L F P
0 g
s
.666 .738 .903 r
.51508 .45104 m .43115 .35388 L .43056 .3578 L F
.50997 .4495 m .43056 .3578 L .42081 .42265 L F
.51508 .45104 m .43056 .3578 L .50997 .4495 L F
.143 .227 .693 r
.44201 .42226 m .42643 .38524 L .42394 .40181 L F
.42643 .38524 m .37765 .26934 L .42394 .40181 L F
.44201 .42226 m .4236 .31865 L .37765 .26934 L p F P
0 g
s
.902 .763 .698 r
.42956 .35219 m .43056 .3578 L p .42758 .35436 L F P
0 g
s
.666 .738 .903 r
.43003 .35258 m .37773 .40967 L p .42081 .42265 L F P
0 g
s
.666 .738 .903 r
.43003 .35258 m .35905 .40404 L p .37732 .40954 L F P
0 g
s
0 0 0 r
.35905 .40404 m .42758 .35436 L p .34463 .44486 L F P
0 g
s
.666 .738 .903 r
.43115 .35388 m .43003 .35258 L .42081 .42265 L F
.40523 .45391 m .41352 .46286 L p .4912 .44385 L F P
0 g
s
0 0 0 r
.38188 .49012 m .44201 .42226 L .42 .428 L p F P
0 g
s
0 0 0 r
.38188 .49012 m .42 .428 L .40398 .4392 L F
.143 .227 .693 r
.42 .428 m .44201 .42226 L p .42394 .40181 L F P
0 g
s
.902 .763 .698 r
.44201 .42226 m .38188 .49012 L p .41769 .34294 L F P
0 g
s
.902 .763 .698 r
.43056 .3578 m .44201 .42226 L p .41769 .34294 L F P
0 g
s
.902 .763 .698 r
.34918 .31796 m .4236 .31865 L p .38188 .49012 L F P
0 g
s
0 0 0 r
.3441 .44638 m .34463 .44486 L .43003 .35258 L F
.42758 .35436 m .43003 .35258 L p .34463 .44486 L F P
0 g
s
.902 .763 .698 r
.4236 .31865 m .42956 .35219 L p .41769 .34294 L F P
0 g
s
.902 .763 .698 r
.41769 .34294 m .42956 .35219 L .42758 .35436 L F
.32203 .42767 m .34918 .31796 L p .36836 .41897 L F P
0 g
s
.902 .763 .698 r
.34164 .44813 m .32203 .42767 L p .36836 .41897 L F P
0 g
s
.659 .747 .915 r
.21117 .4409 m .32203 .42767 L .34164 .44813 L p F P
0 g
s
.659 .747 .915 r
.34164 .44813 m .38188 .49012 L p .31127 .46976 L F P
0 g
s
.659 .747 .915 r
.31127 .46976 m .21117 .4409 L .34164 .44813 L F
0 0 0 r
.32914 .4627 m .33368 .4538 L .3441 .44638 L F
.32914 .4627 m .317 .46569 L p .33368 .4538 L F P
0 g
s
.043 .16 .662 r
.36247 .6311 m .31289 .5084 L .32914 .4627 L F
.317 .46569 m .32914 .4627 L p .31289 .5084 L F P
0 g
s
.043 .16 .662 r
.36247 .6311 m .31045 .5338 L .31289 .5084 L F
.673 .523 .673 r
.41352 .46286 m .38936 .56272 L .47649 .61414 L p F P
0 g
s
.673 .523 .673 r
.51508 .45104 m .41352 .46286 L p .47649 .61414 L F P
0 g
s
.756 .338 .257 r
.46395 .65794 m .47649 .61414 L .38936 .56272 L p F P
0 g
s
.666 .738 .903 r
.51508 .45104 m .52891 .38355 L .43003 .35258 L p F P
0 g
s
.66 .746 .914 r
.56066 .57606 m .6645 .56485 L p .64091 .55802 L F P
0 g
s
.673 .523 .673 r
.555 .54449 m .51508 .45104 L p .48578 .57487 L F P
0 g
s
.673 .523 .673 r
.52563 .57054 m .555 .54449 L p .48578 .57487 L F P
0 g
s
.192 .26 .705 r
.51508 .45104 m .555 .54449 L .57012 .54298 L p F P
0 g
s
.66 .746 .914 r
.64091 .55802 m .57612 .53927 L .56433 .56634 L F
.57612 .53927 m .57139 .5379 L .57012 .54298 L F
.57612 .53927 m .57012 .54298 L .56433 .56634 L F
.56433 .56634 m .55092 .55488 L .55301 .56757 L F
.103 0 .06 r
.555 .54449 m .52563 .57054 L p .54492 .55859 L F P
0 g
s
.103 0 .06 r
.55296 .55361 m .55452 .54662 L .54492 .55859 L F
.55452 .54662 m .555 .54449 L .54492 .55859 L F
.908 .769 .696 r
.56066 .57606 m .54492 .55859 L p .47019 .69044 L F P
0 g
s
.908 .769 .696 r
.47019 .69044 m .54492 .55859 L .48312 .63564 L F
.66 .746 .914 r
.54492 .55859 m .55301 .56757 L p .55092 .55488 L F P
0 g
s
.103 0 .06 r
.57012 .54298 m .555 .54449 L p .55296 .55361 L F P
0 g
s
.192 .26 .705 r
.57629 .51811 m .51508 .45104 L .57012 .54298 L F
.66 .746 .914 r
.57139 .5379 m .51036 .52023 L .56433 .56634 L F
.908 .769 .696 r
.47019 .69044 m .537 .67781 L .56066 .57606 L p F P
0 g
s
.103 0 .06 r
.53983 .61234 m .55296 .55361 L .54189 .56238 L F
.50093 .61344 m .54189 .56238 L .47649 .61414 L F
.53983 .61234 m .54189 .56238 L .50093 .61344 L F
.52563 .57054 m .47649 .61414 L p .55296 .55361 L F P
0 g
s
.673 .523 .673 r
.47649 .61414 m .52563 .57054 L p .48578 .57487 L F P
0 g
s
.908 .769 .696 r
.46447 .65889 m .47019 .69044 L p .47597 .66594 L F P
0 g
s
.908 .769 .696 r
.47597 .66594 m .48312 .63564 L .46643 .65645 L F
.47597 .66594 m .46643 .65645 L .46447 .65889 L F
.651 .757 .927 r
.46395 .65794 m .36247 .6311 L p .43341 .6236 L F P
0 g
s
.103 0 .06 r
.47504 .61919 m .53983 .61234 L p .47649 .61414 L F P
0 g
s
.103 0 .06 r
.46483 .65486 m .46395 .65794 L p .46643 .65645 L F P
0 g
s
.651 .757 .927 r
.46643 .65645 m .46395 .65794 L p .46287 .65673 L F P
0 g
s
.651 .757 .927 r
.46351 .65354 m .46287 .65673 L .43341 .6236 L F
.46643 .65645 m .46287 .65673 L .46351 .65354 L F
.908 .769 .696 r
.46447 .65889 m .51036 .52023 L .46351 .65354 L F
.51036 .52023 m .45212 .59066 L .46351 .65354 L p F P
0 g
s
.908 .769 .696 r
.48312 .63564 m .51036 .52023 L .46447 .65889 L F
.758 .345 .268 r
.537 .67781 m .47019 .69044 L p .62067 .78061 L F P
0 g
s
.758 .345 .268 r
.47019 .69044 m .52048 .75549 L .62067 .78061 L p F P
0 g
s
.106 .203 .682 r
.52048 .75549 m .47019 .69044 L .46351 .65354 L p F P
0 g
s
.106 .203 .682 r
.46351 .65354 m .45212 .59066 L p .46826 .62959 L F P
0 g
s
.908 .769 .696 r
.54492 .55859 m .51036 .52023 L p .48312 .63564 L F P
0 g
s
.651 .757 .927 r
.53983 .61234 m .46643 .65645 L p .46351 .65354 L F P
0 g
s
.106 .203 .682 r
.45212 .59066 m .47627 .58928 L p .46826 .62959 L F P
0 g
s
.651 .757 .927 r
.47023 .6197 m .46351 .65354 L .43341 .6236 L F
.53983 .61234 m .46351 .65354 L .47023 .6197 L F
.054 0 .009 r
.45212 .59066 m .51036 .52023 L p .49425 .57806 L F P
0 g
s
.054 0 .009 r
.47627 .58928 m .45212 .59066 L p .49425 .57806 L F P
0 g
s
.651 .757 .927 r
.36247 .6311 m .3712 .56588 L p .4701 .59313 L F P
0 g
s
.651 .757 .927 r
.53983 .61234 m .41878 .62514 L .4701 .59313 L F
.41878 .62514 m .36247 .6311 L .4701 .59313 L F
.054 0 .009 r
.49425 .57806 m .51036 .52023 L .50566 .56923 L F
.916 .777 .693 r
.53983 .61234 m .50283 .5727 L p .52806 .5417 L F P
0 g
s
.054 0 .009 r
.50283 .5727 m .50566 .56923 L .50548 .57105 L F
.49425 .57806 m .50566 .56923 L .50283 .5727 L F
.66 .746 .914 r
.51036 .52023 m .54492 .55859 L p .55092 .55488 L F P
0 g
s
.192 .26 .705 r
.52891 .38355 m .51508 .45104 L p .57629 .51811 L F P
0 g
s
.66 .746 .914 r
.6645 .56485 m .58758 .47259 L .58665 .47631 L F
.65944 .56339 m .58665 .47631 L .57139 .5379 L F
.6645 .56485 m .58665 .47631 L .65944 .56339 L F
.192 .26 .705 r
.59657 .54034 m .58019 .50238 L .57629 .51811 L F
.58019 .50238 m .52891 .38355 L .57629 .51811 L F
.59657 .54034 m .58063 .43741 L .52891 .38355 L p F P
0 g
s
.916 .777 .693 r
.58579 .47074 m .58665 .47631 L p .58392 .47304 L F P
0 g
s
.66 .746 .914 r
.58655 .47135 m .53986 .52877 L p .57139 .5379 L F P
0 g
s
.66 .746 .914 r
.58655 .47135 m .51036 .52023 L p .53924 .52859 L F P
0 g
s
.054 0 .009 r
.51036 .52023 m .58392 .47304 L p .50566 .56923 L F P
0 g
s
.66 .746 .914 r
.58758 .47259 m .58655 .47135 L .57139 .5379 L F
.55301 .56757 m .56066 .57606 L p .64091 .55802 L F P
0 g
s
.673 .523 .673 r
.56066 .57606 m .537 .67781 L .62674 .73105 L p F P
0 g
s
.673 .523 .673 r
.6645 .56485 m .56066 .57606 L p .62674 .73105 L F P
0 g
s
.103 0 .06 r
.53983 .61234 m .59657 .54034 L .57012 .54298 L p F P
0 g
s
.103 0 .06 r
.53983 .61234 m .57012 .54298 L .55296 .55361 L F
.192 .26 .705 r
.57012 .54298 m .59657 .54034 L p .57629 .51811 L F P
0 g
s
.916 .777 .693 r
.59657 .54034 m .53983 .61234 L p .57485 .46219 L F P
0 g
s
.916 .777 .693 r
.58665 .47631 m .59657 .54034 L p .57485 .46219 L F P
0 g
s
.916 .777 .693 r
.51134 .44138 m .58063 .43741 L p .53983 .61234 L F P
0 g
s
.054 0 .009 r
.50548 .57105 m .50566 .56923 L .58655 .47135 L F
.58392 .47304 m .58655 .47135 L p .50566 .56923 L F P
0 g
s
.916 .777 .693 r
.58063 .43741 m .58579 .47074 L p .57485 .46219 L F P
0 g
s
.916 .777 .693 r
.57485 .46219 m .58579 .47074 L .58392 .47304 L F
.4848 .55339 m .51134 .44138 L p .52806 .5417 L F P
0 g
s
.916 .777 .693 r
.50283 .5727 m .4848 .55339 L p .52806 .5417 L F P
0 g
s
.651 .757 .927 r
.3712 .56588 m .4848 .55339 L .50283 .5727 L p F P
0 g
s
.651 .757 .927 r
.50283 .5727 m .53983 .61234 L p .4701 .59313 L F P
0 g
s
.651 .757 .927 r
.4701 .59313 m .3712 .56588 L .50283 .5727 L F
.054 0 .009 r
.49136 .58841 m .49425 .57806 L .50548 .57105 L F
.49136 .58841 m .47627 .58928 L p .49425 .57806 L F P
0 g
s
.106 .203 .682 r
.52048 .75549 m .46826 .62959 L .49136 .58841 L F
.47627 .58928 m .49136 .58841 L p .46826 .62959 L F P
0 g
s
.106 .203 .682 r
.52048 .75549 m .46351 .65354 L .46826 .62959 L F
.758 .345 .268 r
.62067 .78061 m .62674 .73105 L .537 .67781 L p F P
0 g
s
.66 .746 .914 r
.6645 .56485 m .68416 .50078 L .58655 .47135 L p F P
0 g
s
.652 .756 .925 r
.71157 .69216 m .81775 .68158 L p .79449 .67515 L F P
0 g
s
.673 .523 .673 r
.70637 .6606 m .6645 .56485 L p .63583 .69103 L F P
0 g
s
.673 .523 .673 r
.67659 .68695 m .70637 .6606 L p .63583 .69103 L F P
0 g
s
.235 .289 .715 r
.6645 .56485 m .70637 .6606 L .72416 .66096 L p F P
0 g
s
.652 .756 .925 r
.79449 .67515 m .73057 .65745 L .71617 .68299 L F
.73057 .65745 m .7259 .65616 L .72416 .66096 L F
.73057 .65745 m .72416 .66096 L .71617 .68299 L F
.70459 .68415 m .71157 .69216 L p .79449 .67515 L F P
0 g
s
.673 .523 .674 r
.71157 .69216 m .68843 .79586 L .7809 .851 L p F P
0 g
s
.673 .523 .674 r
.81775 .68158 m .71157 .69216 L p .7809 .851 L F P
0 g
s
.235 .289 .715 r
.73267 .63749 m .6645 .56485 L .72416 .66096 L F
.68416 .50078 m .6645 .56485 L p .73267 .63749 L F P
0 g
s
.235 .289 .715 r
.73805 .62265 m .68416 .50078 L .73267 .63749 L F
.652 .756 .925 r
.81775 .68158 m .74825 .59452 L .74698 .59804 L F
.81277 .6802 m .74698 .59804 L .7259 .65616 L F
.81775 .68158 m .74698 .59804 L .81277 .6802 L F
.235 .289 .715 r
.75527 .66158 m .74194 .55941 L .68416 .50078 L p F P
0 g
s
.932 .794 .685 r
.74194 .55941 m .74626 .5925 L p .7363 .5847 L F P
0 g
s
.932 .794 .685 r
.74626 .5925 m .74698 .59804 L p .7445 .59494 L F P
0 g
s
.932 .794 .685 r
.7363 .5847 m .74626 .5925 L .7445 .59494 L F
.652 .756 .925 r
.74732 .59335 m .70621 .65071 L p .7259 .65616 L F P
0 g
s
.652 .756 .925 r
.74732 .59335 m .66567 .63949 L p .70552 .65052 L F P
0 g
s
.652 .756 .925 r
.71617 .68299 m .70362 .67218 L .70459 .68415 L F
.218 0 .181 r
.70637 .6606 m .67659 .68695 L p .69721 .67568 L F P
0 g
s
.218 0 .181 r
.7058 .67099 m .70624 .66303 L .69721 .67568 L F
.70624 .66303 m .70637 .6606 L .69721 .67568 L F
.923 .784 .69 r
.71157 .69216 m .69721 .67568 L p .62641 .81308 L F P
0 g
s
.923 .784 .69 r
.62641 .81308 m .69721 .67568 L .63905 .75718 L F
.652 .756 .925 r
.69721 .67568 m .70459 .68415 L p .70362 .67218 L F P
0 g
s
.218 0 .181 r
.72416 .66096 m .70637 .6606 L p .7058 .67099 L F P
0 g
s
.652 .756 .925 r
.7259 .65616 m .66567 .63949 L .71617 .68299 L F
.923 .784 .69 r
.62641 .81308 m .68843 .79586 L .71157 .69216 L p F P
0 g
s
.218 0 .181 r
.70212 .73792 m .7058 .67099 L .69435 .67968 L F
.65581 .7337 m .69435 .67968 L .62674 .73105 L F
.70212 .73792 m .69435 .67968 L .65581 .7337 L F
.67659 .68695 m .62674 .73105 L p .7058 .67099 L F P
0 g
s
.673 .523 .673 r
.62674 .73105 m .67659 .68695 L p .63583 .69103 L F P
0 g
s
.923 .784 .69 r
.6215 .78179 m .62641 .81308 L p .63206 .78809 L F P
0 g
s
.923 .784 .69 r
.63206 .78809 m .63905 .75718 L .62334 .77921 L F
.63206 .78809 m .62334 .77921 L .6215 .78179 L F
.641 .767 .939 r
.62067 .78061 m .52048 .75549 L p .59313 .74846 L F P
0 g
s
.218 0 .181 r
.62499 .74538 m .70212 .73792 L p .62674 .73105 L F P
0 g
s
.218 0 .181 r
.62112 .77695 m .62067 .78061 L p .62334 .77921 L F P
0 g
s
.641 .767 .939 r
.62334 .77921 m .62067 .78061 L p .6197 .77947 L F P
0 g
s
.641 .767 .939 r
.62066 .77649 m .6197 .77947 L .59313 .74846 L F
.62334 .77921 m .6197 .77947 L .62066 .77649 L F
.923 .784 .69 r
.6215 .78179 m .66567 .63949 L .62066 .77649 L F
.66567 .63949 m .61086 .71412 L .62066 .77649 L p F P
0 g
s
.923 .784 .69 r
.63905 .75718 m .66567 .63949 L .6215 .78179 L F
.759 .352 .28 r
.68843 .79586 m .62641 .81308 L p .78165 .9066 L F P
0 g
s
.759 .352 .28 r
.62641 .81308 m .68285 .8833 L .78165 .9066 L p F P
0 g
s
.161 .24 .698 r
.68285 .8833 m .62641 .81308 L .62066 .77649 L p F P
0 g
s
.161 .24 .698 r
.62066 .77649 m .61086 .71412 L p .62786 .75407 L F P
0 g
s
.923 .784 .69 r
.69721 .67568 m .66567 .63949 L p .63905 .75718 L F P
0 g
s
.641 .767 .939 r
.70212 .73792 m .62334 .77921 L p .62066 .77649 L F P
0 g
s
.161 .24 .698 r
.61086 .71412 m .63998 .71632 L p .62786 .75407 L F P
0 g
s
.641 .767 .939 r
.63083 .74481 m .62066 .77649 L .59313 .74846 L F
.70212 .73792 m .62066 .77649 L .63083 .74481 L F
.181 0 .143 r
.61086 .71412 m .66567 .63949 L p .65933 .70581 L F P
0 g
s
.181 0 .143 r
.63998 .71632 m .61086 .71412 L p .65933 .70581 L F P
0 g
s
.641 .767 .939 r
.52048 .75549 m .53575 .6944 L p .63334 .71993 L F P
0 g
s
.641 .767 .939 r
.70212 .73792 m .57815 .74991 L .63334 .71993 L F
.57815 .74991 m .52048 .75549 L .63334 .71993 L F
.652 .756 .925 r
.66567 .63949 m .69721 .67568 L p .70362 .67218 L F P
0 g
s
.181 0 .143 r
.66567 .63949 m .7445 .59494 L p .66857 .70079 L F P
0 g
s
.641 .767 .939 r
.66857 .70079 m .70212 .73792 L p .63334 .71993 L F P
0 g
s
.181 0 .143 r
.65847 .71488 m .65933 .70581 L .66857 .70079 L F
.65933 .70581 m .66567 .63949 L .66857 .70079 L F
.641 .767 .939 r
.53575 .6944 m .65221 .68269 L .66857 .70079 L p F P
0 g
s
.641 .767 .939 r
.63334 .71993 m .53575 .6944 L .66857 .70079 L F
.181 0 .143 r
.6582 .7177 m .63998 .71632 L p .65933 .70581 L F P
0 g
s
.161 .24 .698 r
.68285 .8833 m .62786 .75407 L .6582 .7177 L F
.63998 .71632 m .6582 .7177 L p .62786 .75407 L F P
0 g
s
.161 .24 .698 r
.68285 .8833 m .62066 .77649 L .62786 .75407 L F
.652 .756 .925 r
.74825 .59452 m .74732 .59335 L .7259 .65616 L F
.932 .794 .685 r
.73126 .60729 m .7363 .5847 L .75527 .66158 L F
.235 .289 .715 r
.75527 .66158 m .73805 .62265 L .73267 .63749 L F
.218 0 .181 r
.70212 .73792 m .75527 .66158 L .72416 .66096 L p F P
0 g
s
.218 0 .181 r
.70212 .73792 m .72416 .66096 L .7058 .67099 L F
.235 .289 .715 r
.72416 .66096 m .75527 .66158 L p .73267 .63749 L F P
0 g
s
.932 .794 .685 r
.75527 .66158 m .70212 .73792 L p .73126 .60729 L F P
0 g
s
.932 .794 .685 r
.74698 .59804 m .75527 .66158 L p .7363 .5847 L F P
0 g
s
.932 .794 .685 r
.6781 .56831 m .74194 .55941 L p .70212 .73792 L F P
0 g
s
.932 .794 .685 r
.70212 .73792 m .65221 .68269 L .6781 .56831 L p F P
0 g
s
.181 0 .143 r
.6582 .7177 m .65847 .71488 L .74732 .59335 L F
.7445 .59494 m .74732 .59335 L p .65847 .71488 L F P
0 g
s
.882 .743 .704 r
.21157 .2908 m .14704 .35339 L .16976 .45459 L p F P
0 g
s
0 0 0 r
.21157 .2908 m .27759 .23691 L p .17134 .34042 L F P
0 g
s
0 0 0 r
.17134 .34042 m .14704 .35339 L .21157 .2908 L p F P
0 g
s
0 .109 .635 r
.20865 .51001 m .16976 .45459 L .14704 .35339 L p F P
0 g
s
.728 .251 .114 r
.37765 .26934 m .4236 .31865 L .34918 .31796 L p F P
0 g
s
.728 .251 .114 r
.27759 .23691 m .37765 .26934 L p .34918 .31796 L F P
0 g
s
.759 .352 .28 r
.78165 .9066 m .7809 .851 L .68843 .79586 L p F P
0 g
s
.652 .756 .925 r
.81775 .68158 m .84356 .62113 L .74732 .59335 L p F P
0 g
s
.673 .523 .674 r
.7809 .851 m .86168 .77972 L .81775 .68158 L p F P
0 g
s
.272 .313 .722 r
.81775 .68158 m .86168 .77972 L .91828 .78612 L p F P
0 g
s
.272 .313 .722 r
.84356 .62113 m .81775 .68158 L p .91828 .78612 L F P
0 g
s
.303 0 .271 r
.7809 .851 m .78165 .9066 L .86895 .867 L p F P
0 g
s
.303 0 .271 r
.86168 .77972 m .7809 .851 L p .86895 .867 L F P
0 g
s
.303 0 .271 r
.86895 .867 m .91828 .78612 L .86168 .77972 L p F P
0 g
s
.733 .263 .132 r
.52891 .38355 m .58063 .43741 L .51134 .44138 L p F P
0 g
s
.733 .263 .132 r
.43003 .35258 m .52891 .38355 L p .51134 .44138 L F P
0 g
s
0 .109 .635 r
.14704 .35339 m .17134 .34042 L p .20865 .51001 L F P
0 g
s
.728 .251 .114 r
.34918 .31796 m .25568 .26517 L .27759 .23691 L p F P
0 g
s
0 0 0 r
.27759 .23691 m .25568 .26517 L .17134 .34042 L p F P
0 g
s
.737 .273 .149 r
.68416 .50078 m .74194 .55941 L .6781 .56831 L p F P
0 g
s
.737 .273 .149 r
.58655 .47135 m .68416 .50078 L p .6781 .56831 L F P
0 g
s
.733 .263 .132 r
.51134 .44138 m .41477 .38652 L .43003 .35258 L p F P
0 g
s
0 0 0 r
.43003 .35258 m .41477 .38652 L .32914 .4627 L p F P
0 g
s
0 .109 .635 r
.17134 .34042 m .21117 .4409 L .20865 .51001 L p F P
0 g
s
.272 .313 .722 r
.91828 .78612 m .90771 .68479 L .84356 .62113 L p F P
0 g
s
.74 .283 .166 r
.84356 .62113 m .90771 .68479 L .84966 .69888 L p F P
0 g
s
.74 .283 .166 r
.74732 .59335 m .84356 .62113 L p .84966 .69888 L F P
0 g
s
.737 .273 .149 r
.6781 .56831 m .57833 .51126 L .58655 .47135 L p F P
0 g
s
.054 0 .009 r
.58655 .47135 m .57833 .51126 L .49136 .58841 L p F P
0 g
s
.043 .16 .662 r
.32914 .4627 m .3712 .56588 L .36247 .6311 L p F P
0 g
s
.629 .778 .952 r
.86895 .867 m .78165 .9066 L .68285 .8833 L p F P
0 g
s
.95 .812 .673 r
.90771 .68479 m .91828 .78612 L .86895 .867 L p F P
0 g
s
.74 .283 .166 r
.84966 .69888 m .74653 .63955 L .74732 .59335 L p F P
0 g
s
.181 0 .143 r
.74732 .59335 m .74653 .63955 L .6582 .7177 L p F P
0 g
s
.106 .203 .682 r
.49136 .58841 m .53575 .6944 L .52048 .75549 L p F P
0 g
s
.668 .516 .669 r
.32203 .42767 m .21117 .4409 L .17134 .34042 L p F P
0 g
s
.668 .516 .669 r
.34918 .31796 m .32203 .42767 L p .17134 .34042 L F P
0 g
s
.668 .516 .669 r
.17134 .34042 m .25568 .26517 L .34918 .31796 L p F P
0 g
s
.161 .24 .698 r
.6582 .7177 m .70504 .82661 L .68285 .8833 L p F P
0 g
s
.629 .778 .952 r
.68285 .8833 m .70504 .82661 L p .86895 .867 L F P
0 g
s
.668 .516 .669 r
.4848 .55339 m .3712 .56588 L .32914 .4627 L p F P
0 g
s
.668 .516 .669 r
.51134 .44138 m .4848 .55339 L p .32914 .4627 L F P
0 g
s
.668 .516 .669 r
.32914 .4627 m .41477 .38652 L .51134 .44138 L p F P
0 g
s
.95 .812 .673 r
.84966 .69888 m .90771 .68479 L p .86895 .867 L F P
0 g
s
.95 .812 .673 r
.86895 .867 m .82446 .81573 L .84966 .69888 L p F P
0 g
s
.629 .778 .952 r
.70504 .82661 m .82446 .81573 L .86895 .867 L p F P
0 g
s
.669 .517 .669 r
.65221 .68269 m .53575 .6944 L .49136 .58841 L p F P
0 g
s
.669 .517 .669 r
.6781 .56831 m .65221 .68269 L p .49136 .58841 L F P
0 g
s
.669 .517 .669 r
.49136 .58841 m .57833 .51126 L .6781 .56831 L p F P
0 g
s
.669 .517 .67 r
.82446 .81573 m .70504 .82661 L .6582 .7177 L p F P
0 g
s
.669 .517 .67 r
.84966 .69888 m .82446 .81573 L p .6582 .7177 L F P
0 g
s
.669 .517 .67 r
.6582 .7177 m .74653 .63955 L .84966 .69888 L p F P
0 g
s
.25 Mabswid
.67833 0 m
.93281 .41109 L
s
.93281 .41109 m
1 .90496 L
s
1 .90496 m
.71041 .54083 L
s
.71041 .54083 m
.67833 0 L
s
.08075 .248 m
0 .76374 L
s
0 .76374 m
.71041 .54083 L
s
.71041 .54083 m
.67833 0 L
s
.67833 0 m
.08075 .248 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.10.8"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " allows polygons in three dimensions to have any number of vertices. \
However, these vertices should lie in a plane, and should form a convex \
figure. If they do not, then ",
  StyleBox["Mathematica", "TI"],
  " will break the polygon into triangles, which are planar by definition, \
before rendering it. "
}], "Text",
  CellTags->{"S2.10.8", "8.18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Cuboid[{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[TextData[{
              "a unit cube with opposite corners having coordinates ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}", "MR"],
              " and ",
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox["+1,", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox["+1,", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["+1}", "MR"],
              " "
            }]]},
          {Cell[TextData[{
              StyleBox["Cuboid[{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["min",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["},", "MR"],
              " ",
              StyleBox["{", "MR"],
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["x",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["y",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox[",", "MR"],
              " ",
              Cell[BoxData[
                  FormBox[
                    SubscriptBox[
                      StyleBox["z",
                        "TI"], 
                      StyleBox["max",
                        "TI"]], TraditionalForm]], "InlineFormula"],
              StyleBox["}]", "MR"],
              " "
            }]], 
            Cell["\<\
a cuboid (rectangular parallelepiped) with opposite \
corners having the specified coordinates \
\>"]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.8"],

Cell["Cuboid graphics elements. ", "Caption",
  CellTags->"S2.10.8"],

Cell["\<\
This draws 20 random unit cubes in three\[Hyphen]dimensional space. \
\
\>", "MathCaption",
  CellTags->{"S2.10.8", "8.19"}],

Cell[CellGroupData[{

Cell["Show[Graphics3D[ Table[Cuboid[10 rcoord], {20}] ]]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.10.8"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0666 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0489453 1.14312 -8.32125e-17 1.14312 [
[ 0 0 0 0 ]
[ 1 1.0666 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08354 .24876 m
0 .79366 L
s
0 .79366 m
.38325 1.0666 L
s
.38325 1.0666 m
.402 .57146 L
s
.402 .57146 m
.08354 .24876 L
s
.68352 0 m
.92932 .39872 L
s
.92932 .39872 m
1 .92252 L
s
1 .92252 m
.71869 .57173 L
s
.71869 .57173 m
.68352 0 L
s
.08354 .24876 m
0 .79366 L
s
0 .79366 m
.71869 .57173 L
s
.71869 .57173 m
.68352 0 L
s
.68352 0 m
.08354 .24876 L
s
.402 .57146 m
.92932 .39872 L
s
.92932 .39872 m
1 .92252 L
s
1 .92252 m
.38325 1.0666 L
s
.38325 1.0666 m
.402 .57146 L
s
0 0 m
1 0 L
1 1.0666 L
0 1.0666 L
closepath
clip
newpath
.5 Mabswid
.665 .739 .905 r
.54788 .59547 m .50061 .61032 L .47435 .58269 L p F P
0 g
s
.567 .358 .556 r
.54823 .63994 m .54788 .59547 L .50061 .61032 L p F P
0 g
s
.567 .358 .556 r
.50061 .61032 m .50031 .65459 L .54823 .63994 L p F P
0 g
s
.953 .687 .495 r
.47435 .58269 m .50061 .61032 L .50031 .65459 L p F P
0 g
s
.665 .739 .905 r
.47435 .58269 m .52216 .56735 L .54788 .59547 L p F P
0 g
s
.958 .688 .48 r
.52216 .56735 m .54788 .59547 L .54823 .63994 L p F P
0 g
s
.953 .687 .495 r
.50031 .65459 m .47367 .62733 L .47435 .58269 L p F P
0 g
s
.662 .744 .911 r
.54823 .63994 m .50031 .65459 L .47367 .62733 L p F P
0 g
s
.562 .35 .551 r
.52216 .61217 m .52216 .56735 L .47435 .58269 L p F P
0 g
s
.562 .35 .551 r
.47435 .58269 m .47367 .62733 L .52216 .61217 L p F P
0 g
s
.662 .744 .911 r
.47367 .62733 m .52216 .61217 L .54823 .63994 L p F P
0 g
s
.958 .688 .48 r
.54823 .63994 m .52216 .61217 L .52216 .56735 L p F P
0 g
s
.647 .762 .933 r
.57386 .80364 m .5229 .81761 L .49508 .79161 L p F P
0 g
s
.567 .357 .556 r
.57462 .85454 m .57386 .80364 L .5229 .81761 L p F P
0 g
s
.567 .357 .556 r
.5229 .81761 m .5229 .86822 L .57462 .85454 L p F P
0 g
s
.956 .688 .488 r
.49508 .79161 m .5229 .81761 L .5229 .86822 L p F P
0 g
s
.647 .762 .933 r
.49508 .79161 m .54668 .77714 L .57386 .80364 L p F P
0 g
s
.961 .688 .472 r
.54668 .77714 m .57386 .80364 L .57462 .85454 L p F P
0 g
s
.956 .688 .488 r
.5229 .86822 m .49467 .84275 L .49508 .79161 L p F P
0 g
s
.641 .767 .939 r
.57462 .85454 m .5229 .86822 L .49467 .84275 L p F P
0 g
s
.561 .35 .55 r
.54705 .82856 m .54668 .77714 L .49508 .79161 L p F P
0 g
s
.561 .35 .55 r
.49508 .79161 m .49467 .84275 L .54705 .82856 L p F P
0 g
s
.641 .767 .939 r
.49467 .84275 m .54705 .82856 L .57462 .85454 L p F P
0 g
s
.961 .688 .472 r
.57462 .85454 m .54705 .82856 L .54668 .77714 L p F P
0 g
s
.657 .749 .918 r
.90898 .57341 m .85294 .59012 L .83018 .559 L p F P
0 g
s
.565 .354 .554 r
.91494 .6226 m .90898 .57341 L .85294 .59012 L p F P
0 g
s
.565 .354 .554 r
.85294 .59012 m .85798 .63908 L .91494 .6226 L p F P
0 g
s
.976 .672 .344 r
.83018 .559 m .85294 .59012 L .85798 .63908 L p F P
0 g
s
.646 .762 .933 r
.53286 .75456 m .48041 .76953 L .45076 .74167 L p F P
0 g
s
.557 .343 .545 r
.53302 .80664 m .53286 .75456 L .48041 .76953 L p F P
0 g
s
.557 .343 .545 r
.48041 .76953 m .47977 .82132 L .53302 .80664 L p F P
0 g
s
.957 .688 .485 r
.45076 .74167 m .48041 .76953 L .47977 .82132 L p F P
0 g
s
.672 .729 .893 r
.7371 .21593 m .68243 .23626 L .65639 .19842 L p F P
0 g
s
.537 .314 .524 r
.74042 .25987 m .7371 .21593 L .68243 .23626 L p F P
0 g
s
.537 .314 .524 r
.68243 .23626 m .68488 .28006 L .74042 .25987 L p F P
0 g
s
.976 .677 .367 r
.65639 .19842 m .68243 .23626 L .68488 .28006 L p F P
0 g
s
.66 .745 .913 r
.50421 .4938 m .45163 .51146 L .4212 .47858 L p F P
0 g
s
.54 .319 .528 r
.50393 .54223 m .50421 .4938 L .45163 .51146 L p F P
0 g
s
.54 .319 .528 r
.45163 .51146 m .45054 .55968 L .50393 .54223 L p F P
0 g
s
.961 .688 .47 r
.4212 .47858 m .45163 .51146 L .45054 .55968 L p F P
0 g
s
.657 .749 .918 r
.83018 .559 m .88703 .54167 L .90898 .57341 L p F P
0 g
s
.973 .663 .31 r
.88703 .54167 m .90898 .57341 L .91494 .6226 L p F P
0 g
s
.646 .762 .933 r
.45076 .74167 m .50388 .72614 L .53286 .75456 L p F P
0 g
s
.962 .688 .469 r
.50388 .72614 m .53286 .75456 L .53302 .80664 L p F P
0 g
s
.637 .771 .944 r
.74336 .85515 m .68812 .86932 L .66193 .84294 L p F P
0 g
s
.568 .359 .557 r
.74682 .90952 m .74336 .85515 L .68812 .86932 L p F P
0 g
s
.568 .359 .557 r
.68812 .86932 m .69068 .92336 L .74682 .90952 L p F P
0 g
s
.97 .686 .435 r
.66193 .84294 m .68812 .86932 L .69068 .92336 L p F P
0 g
s
.976 .672 .344 r
.85798 .63908 m .83497 .60839 L .83018 .559 L p F P
0 g
s
.653 .754 .924 r
.91494 .6226 m .85798 .63908 L .83497 .60839 L p F P
0 g
s
.672 .729 .893 r
.65639 .19842 m .71181 .17733 L .7371 .21593 L p F P
0 g
s
.976 .67 .337 r
.71181 .17733 m .7371 .21593 L .74042 .25987 L p F P
0 g
s
.957 .688 .485 r
.47977 .82132 m .44964 .79399 L .45076 .74167 L p F P
0 g
s
.641 .767 .94 r
.53302 .80664 m .47977 .82132 L .44964 .79399 L p F P
0 g
s
.559 .346 .548 r
.89276 .59129 m .88703 .54167 L .83018 .559 L p F P
0 g
s
.559 .346 .548 r
.83018 .559 m .83497 .60839 L .89276 .59129 L p F P
0 g
s
.66 .745 .913 r
.4212 .47858 m .47446 .46025 L .50421 .4938 L p F P
0 g
s
.966 .687 .452 r
.47446 .46025 m .50421 .4938 L .50393 .54223 L p F P
0 g
s
.551 .334 .539 r
.50359 .77875 m .50388 .72614 L .45076 .74167 L p F P
0 g
s
.551 .334 .539 r
.45076 .74167 m .44964 .79399 L .50359 .77875 L p F P
0 g
s
.976 .677 .367 r
.68488 .28006 m .65848 .24245 L .65639 .19842 L p F P
0 g
s
.669 .733 .898 r
.74042 .25987 m .68488 .28006 L .65848 .24245 L p F P
0 g
s
.529 .304 .516 r
.7148 .22149 m .71181 .17733 L .65639 .19842 L p F P
0 g
s
.529 .304 .516 r
.65639 .19842 m .65848 .24245 L .7148 .22149 L p F P
0 g
s
.961 .688 .47 r
.45054 .55968 m .41961 .52719 L .4212 .47858 L p F P
0 g
s
.657 .75 .919 r
.50393 .54223 m .45054 .55968 L .41961 .52719 L p F P
0 g
s
.637 .771 .944 r
.66193 .84294 m .71795 .82823 L .74336 .85515 L p F P
0 g
s
.973 .684 .413 r
.71795 .82823 m .74336 .85515 L .74682 .90952 L p F P
0 g
s
.653 .754 .924 r
.83497 .60839 m .89276 .59129 L .91494 .6226 L p F P
0 g
s
.973 .663 .31 r
.91494 .6226 m .89276 .59129 L .88703 .54167 L p F P
0 g
s
.636 .771 .945 r
.9005 .84632 m .84307 .86074 L .81951 .8339 L p F P
0 g
s
.572 .364 .561 r
.90649 .90117 m .9005 .84632 L .84307 .86074 L p F P
0 g
s
.572 .364 .561 r
.84307 .86074 m .84809 .91525 L .90649 .90117 L p F P
0 g
s
.976 .678 .377 r
.81951 .8339 m .84307 .86074 L .84809 .91525 L p F P
0 g
s
.656 .751 .92 r
.20796 .55554 m .15745 .57288 L .12093 .54059 L p F P
0 g
s
.523 .295 .51 r
.20297 .60581 m .20796 .55554 L .15745 .57288 L p F P
0 g
s
.523 .295 .51 r
.15745 .57288 m .15172 .62291 L .20297 .60581 L p F P
0 g
s
.938 .685 .527 r
.12093 .54059 m .15745 .57288 L .15172 .62291 L p F P
0 g
s
.641 .767 .94 r
.44964 .79399 m .50359 .77875 L .53302 .80664 L p F P
0 g
s
.962 .688 .469 r
.53302 .80664 m .50359 .77875 L .50388 .72614 L p F P
0 g
s
.533 .308 .52 r
.4737 .50908 m .47446 .46025 L .4212 .47858 L p F P
0 g
s
.533 .308 .52 r
.4212 .47858 m .41961 .52719 L .4737 .50908 L p F P
0 g
s
.97 .686 .435 r
.69068 .92336 m .66414 .89759 L .66193 .84294 L p F P
0 g
s
.63 .776 .951 r
.74682 .90952 m .69068 .92336 L .66414 .89759 L p F P
0 g
s
.669 .733 .898 r
.65848 .24245 m .7148 .22149 L .74042 .25987 L p F P
0 g
s
.976 .67 .337 r
.74042 .25987 m .7148 .22149 L .71181 .17733 L p F P
0 g
s
.563 .351 .552 r
.72107 .88321 m .71795 .82823 L .66193 .84294 L p F P
0 g
s
.563 .351 .552 r
.66193 .84294 m .66414 .89759 L .72107 .88321 L p F P
0 g
s
.657 .75 .919 r
.41961 .52719 m .4737 .50908 L .50393 .54223 L p F P
0 g
s
.966 .687 .452 r
.50393 .54223 m .4737 .50908 L .47446 .46025 L p F P
0 g
s
.636 .771 .945 r
.81951 .8339 m .8778 .81893 L .9005 .84632 L p F P
0 g
s
.976 .673 .348 r
.8778 .81893 m .9005 .84632 L .90649 .90117 L p F P
0 g
s
.639 .769 .942 r
.43846 .80416 m .3851 .81916 L .35256 .79123 L p F P
0 g
s
.549 .331 .537 r
.43711 .85893 m .43846 .80416 L .3851 .81916 L p F P
0 g
s
.549 .331 .537 r
.3851 .81916 m .38292 .8736 L .43711 .85893 L p F P
0 g
s
.951 .687 .499 r
.35256 .79123 m .3851 .81916 L .38292 .8736 L p F P
0 g
s
.656 .751 .92 r
.12093 .54059 m .17203 .52258 L .20796 .55554 L p F P
0 g
s
.944 .686 .516 r
.17203 .52258 m .20796 .55554 L .20297 .60581 L p F P
0 g
s
.63 .776 .951 r
.66414 .89759 m .72107 .88321 L .74682 .90952 L p F P
0 g
s
.973 .684 .413 r
.74682 .90952 m .72107 .88321 L .71795 .82823 L p F P
0 g
s
.976 .678 .377 r
.84809 .91525 m .82426 .88903 L .81951 .8339 L p F P
0 g
s
.63 .777 .951 r
.90649 .90117 m .84809 .91525 L .82426 .88903 L p F P
0 g
s
.938 .685 .527 r
.15172 .62291 m .11451 .59106 L .12093 .54059 L p F P
0 g
s
.652 .756 .926 r
.20297 .60581 m .15172 .62291 L .11451 .59106 L p F P
0 g
s
.567 .357 .556 r
.88354 .8744 m .8778 .81893 L .81951 .8339 L p F P
0 g
s
.567 .357 .556 r
.81951 .8339 m .82426 .88903 L .88354 .8744 L p F P
0 g
s
.515 .283 .501 r
.16636 .57329 m .17203 .52258 L .12093 .54059 L p F P
0 g
s
.652 .756 .926 r
.11451 .59106 m .16636 .57329 L .20297 .60581 L p F P
0 g
s
.94 .685 .525 r
.13019 .59191 m .12381 .64402 L p .11952 .63258 L F P
0 g
s
.515 .283 .501 r
.12093 .54059 m .11451 .59106 L .12513 .58742 L p F P
0 g
s
.94 .685 .525 r
.09184 .55884 m .12511 .58753 L p .11952 .63258 L F P
0 g
s
.94 .685 .525 r
.12511 .58753 m .13019 .59191 L p .11952 .63258 L F P
0 g
s
.515 .283 .501 r
.12513 .58742 m .16636 .57329 L p .13012 .5472 L F P
0 g
s
.515 .283 .501 r
.12093 .54059 m .12513 .58742 L .13012 .5472 L F
.639 .769 .942 r
.35256 .79123 m .4066 .77565 L .43846 .80416 L p F P
0 g
s
.957 .688 .485 r
.4066 .77565 m .43846 .80416 L .43711 .85893 L p F P
0 g
s
.63 .777 .951 r
.82426 .88903 m .88354 .8744 L .90649 .90117 L p F P
0 g
s
.976 .673 .348 r
.90649 .90117 m .88354 .8744 L .8778 .81893 L p F P
0 g
s
.951 .687 .499 r
.38292 .8736 m .34981 .84628 L .35256 .79123 L p F P
0 g
s
.632 .775 .949 r
.43711 .85893 m .38292 .8736 L .34981 .84628 L p F P
0 g
s
.944 .686 .516 r
.20297 .60581 m .17137 .57774 L p .17621 .53382 L F P
0 g
s
.516 .285 .502 r
.1766 .62653 m .18219 .57416 L .17136 .57785 L p F P
0 g
s
.516 .285 .502 r
.17136 .57785 m .13019 .59191 L p .16681 .61923 L F P
0 g
s
.516 .285 .502 r
.16681 .61923 m .1766 .62653 L .17136 .57785 L F
.944 .686 .516 r
.16636 .57329 m .17203 .52258 L p .17621 .53382 L F P
0 g
s
.944 .686 .516 r
.17137 .57774 m .16636 .57329 L p .17621 .53382 L F P
0 g
s
.66 .747 .915 r
.47968 .45189 m .45697 .42608 L p .4942 .42928 L F P
0 g
s
.66 .747 .915 r
.53497 .43279 m .50588 .44284 L p .4942 .42928 L F P
0 g
s
.66 .747 .915 r
.50588 .44284 m .47968 .45189 L p .4942 .42928 L F P
0 g
s
.97 .686 .436 r
.48389 .38041 m .48342 .41677 L p .47509 .39698 L F P
0 g
s
.66 .747 .915 r
.47195 .42081 m .53497 .43279 L .45697 .42608 L F
.97 .686 .436 r
.45246 .34319 m .48342 .41677 L .47558 .40767 L F
.524 .296 .51 r
.48389 .38041 m .48342 .41677 L p .51281 .40644 L F P
0 g
s
.524 .296 .51 r
.51284 .39534 m .51281 .40644 L .52562 .40193 L F
.48389 .38041 m .51281 .40644 L .51284 .39534 L F
.66 .747 .915 r
.44838 .41632 m .47494 .40692 L p .48983 .42421 L F P
0 g
s
.66 .747 .915 r
.45697 .42608 m .44838 .41632 L p .47195 .42081 L F P
0 g
s
.522 .292 .508 r
.47494 .40692 m .44838 .41632 L p .46204 .42373 L F P
0 g
s
.522 .292 .508 r
.46204 .42373 m .47456 .43053 L .47474 .41926 L F
.46204 .42373 m .47474 .41926 L .47494 .40692 L F
.97 .686 .436 r
.48326 .42909 m .45129 .39222 L .45159 .37982 L p F P
0 g
s
.97 .686 .436 r
.47558 .40767 m .48326 .42909 L .45159 .37982 L F
.66 .747 .915 r
.50443 .39647 m .53497 .43279 L p .48983 .42421 L F P
0 g
s
.97 .686 .436 r
.45159 .37982 m .45246 .34319 L p .47558 .40767 L F P
0 g
s
.66 .747 .915 r
.47494 .40692 m .50443 .39647 L p .48983 .42421 L F P
0 g
s
.972 .685 .425 r
.51281 .40644 m .53497 .43279 L p .51448 .4208 L F P
0 g
s
.972 .685 .425 r
.51277 .41878 m .51448 .4208 L .51276 .4198 L F
.51281 .40644 m .51448 .4208 L .51277 .41878 L F
.524 .296 .51 r
.48326 .42909 m .51277 .41878 L p .5128 .41015 L F P
0 g
s
.97 .686 .436 r
.48342 .41677 m .48341 .41794 L p .48305 .41634 L F P
0 g
s
.97 .686 .436 r
.48341 .41794 m .48326 .42909 L p .48305 .41634 L F P
0 g
s
.97 .686 .436 r
.47558 .40767 m .48305 .41634 L .48326 .42909 L F
.524 .296 .51 r
.48342 .41677 m .48326 .42909 L p .52562 .40193 L F P
0 g
s
.659 .748 .916 r
.50435 .40884 m .50877 .41406 L .47474 .41926 L F
.48326 .42909 m .47474 .41926 L p .50877 .41406 L F P
0 g
s
.659 .748 .916 r
.51277 .41878 m .48326 .42909 L p .50877 .41406 L F P
0 g
s
.53 .304 .516 r
.53517 .4825 m .53497 .43279 L .47968 .45189 L p F P
0 g
s
.522 .292 .508 r
.50443 .39647 m .47494 .40692 L p .48211 .41667 L F P
0 g
s
.522 .292 .508 r
.50413 .44657 m .50435 .40884 L p .48211 .41667 L F P
0 g
s
.522 .292 .508 r
.50435 .40884 m .50443 .39647 L p .48211 .41667 L F P
0 g
s
.972 .685 .425 r
.50435 .40884 m .50443 .39647 L p .51213 .41803 L F P
0 g
s
.972 .685 .425 r
.50443 .39647 m .51281 .40644 L p .51277 .41878 L F P
0 g
s
.972 .685 .425 r
.50443 .39647 m .51277 .41878 L .51213 .41803 L F
.97 .686 .436 r
.45246 .34319 m .47551 .37048 L p .47509 .39698 L F P
0 g
s
.97 .686 .436 r
.47551 .37048 m .48389 .38041 L p .47509 .39698 L F P
0 g
s
.524 .296 .51 r
.5399 .4093 m .53962 .36043 L .48389 .38041 L p F P
0 g
s
.659 .748 .916 r
.45129 .39222 m .50872 .37164 L .53159 .39926 L p F P
0 g
s
.524 .296 .51 r
.52562 .40193 m .5128 .41015 L .5399 .4093 L F
.659 .748 .916 r
.53159 .39926 m .5399 .4093 L p .51609 .40471 L F P
0 g
s
.659 .748 .916 r
.45129 .39222 m .53159 .39926 L .51609 .40471 L F
.522 .292 .508 r
.47456 .43053 m .50413 .44657 L .47494 .40692 L F
.659 .748 .916 r
.47474 .41926 m .45129 .39222 L p .49789 .4012 L F P
0 g
s
.659 .748 .916 r
.49789 .4012 m .51609 .40471 L .50435 .40884 L F
.49789 .4012 m .50435 .40884 L .47474 .41926 L F
.972 .685 .425 r
.50413 .44657 m .50435 .40884 L p .51276 .4198 L F P
0 g
s
.972 .685 .425 r
.51213 .41803 m .51276 .4198 L .50435 .40884 L F
.53517 .4825 m .51265 .45643 L p .51276 .4198 L F P
0 g
s
.972 .685 .425 r
.51265 .45643 m .50413 .44657 L p .51276 .4198 L F P
0 g
s
.524 .296 .51 r
.51277 .41878 m .5399 .4093 L p .5128 .41015 L F P
0 g
s
.659 .748 .916 r
.51086 .4114 m .5399 .4093 L .50877 .41406 L F
.51609 .40471 m .5399 .4093 L .51086 .4114 L F
.51609 .40471 m .50877 .41406 L .50435 .40884 L F
.972 .685 .425 r
.51213 .41803 m .51277 .41878 L .51276 .4198 L F
.659 .748 .916 r
.5399 .4093 m .51277 .41878 L p .50877 .41406 L F P
0 g
s
.972 .685 .425 r
.51276 .4198 m .53497 .43279 L .51613 .42921 L F
.53497 .43279 m .53517 .4825 L p .51613 .42921 L F P
0 g
s
.53 .304 .516 r
.47968 .45189 m .47899 .50138 L .53517 .4825 L p F P
0 g
s
.968 .687 .446 r
.44838 .41632 m .47968 .45189 L .47899 .50138 L p F P
0 g
s
.543 .322 .53 r
.40471 .83103 m .4066 .77565 L .35256 .79123 L p F P
0 g
s
.543 .322 .53 r
.35256 .79123 m .34981 .84628 L .40471 .83103 L p F P
0 g
s
.652 .756 .926 r
.18219 .57416 m .13019 .59191 L .09184 .55884 L p F P
0 g
s
.516 .285 .502 r
.13019 .59191 m .12381 .64402 L .1766 .62653 L p F P
0 g
s
.662 .743 .91 r
.53962 .36043 m .48389 .38041 L .45246 .34319 L p F P
0 g
s
.632 .775 .949 r
.34981 .84628 m .40471 .83103 L .43711 .85893 L p F P
0 g
s
.957 .688 .485 r
.43711 .85893 m .40471 .83103 L .4066 .77565 L p F P
0 g
s
.968 .687 .446 r
.47899 .50138 m .44716 .46621 L .44838 .41632 L p F P
0 g
s
.656 .752 .92 r
.53517 .4825 m .47899 .50138 L .44716 .46621 L p F P
0 g
s
.643 .765 .937 r
.62468 .68916 m .56754 .70588 L .53745 .67474 L p F P
0 g
s
.546 .327 .534 r
.62637 .74396 m .62468 .68916 L .56754 .70588 L p F P
0 g
s
.546 .327 .534 r
.56754 .70588 m .56827 .76037 L .62637 .74396 L p F P
0 g
s
.969 .686 .439 r
.53745 .67474 m .56754 .70588 L .56827 .76037 L p F P
0 g
s
.652 .756 .926 r
.09184 .55884 m .14446 .54038 L .18219 .57416 L p F P
0 g
s
.945 .686 .514 r
.14446 .54038 m .18219 .57416 L .1766 .62653 L p F P
0 g
s
.662 .743 .91 r
.45246 .34319 m .50895 .32242 L .53962 .36043 L p F P
0 g
s
.973 .684 .414 r
.50895 .32242 m .53962 .36043 L .5399 .4093 L p F P
0 g
s
.522 .292 .508 r
.44838 .41632 m .44716 .46621 L .50413 .44657 L p F P
0 g
s
.94 .685 .525 r
.12381 .64402 m .08471 .61143 L .09184 .55884 L p F P
0 g
s
.647 .761 .933 r
.1766 .62653 m .12381 .64402 L .08471 .61143 L p F P
0 g
s
.643 .765 .937 r
.44333 .67741 m .38768 .69437 L .35379 .66276 L p F P
0 g
s
.535 .311 .522 r
.44201 .73242 m .44333 .67741 L .38768 .69437 L p F P
0 g
s
.535 .311 .522 r
.38768 .69437 m .38545 .74908 L .44201 .73242 L p F P
0 g
s
.958 .688 .48 r
.35379 .66276 m .38768 .69437 L .38545 .74908 L p F P
0 g
s
.507 .272 .492 r
.13813 .59324 m .14446 .54038 L .09184 .55884 L p F P
0 g
s
.507 .272 .492 r
.09184 .55884 m .08471 .61143 L .13813 .59324 L p F P
0 g
s
.515 .284 .501 r
.50872 .37164 m .50895 .32242 L .45246 .34319 L p F P
0 g
s
.515 .284 .501 r
.45246 .34319 m .45129 .39222 L .50872 .37164 L p F P
0 g
s
.656 .752 .92 r
.44716 .46621 m .50413 .44657 L .53517 .4825 L p F P
0 g
s
.643 .765 .937 r
.53745 .67474 m .59541 .65735 L .62468 .68916 L p F P
0 g
s
.973 .684 .418 r
.59541 .65735 m .62468 .68916 L .62637 .74396 L p F P
0 g
s
.969 .686 .439 r
.56827 .76037 m .5377 .7298 L .53745 .67474 L p F P
0 g
s
.637 .77 .944 r
.62637 .74396 m .56827 .76037 L .5377 .7298 L p F P
0 g
s
.647 .761 .933 r
.08471 .61143 m .13813 .59324 L .1766 .62653 L p F P
0 g
s
.945 .686 .514 r
.1766 .62653 m .13813 .59324 L .14446 .54038 L p F P
0 g
s
.973 .684 .414 r
.5399 .4093 m .50872 .37164 L .50895 .32242 L p F P
0 g
s
.643 .765 .937 r
.35379 .66276 m .41019 .64511 L .44333 .67741 L p F P
0 g
s
.963 .688 .464 r
.41019 .64511 m .44333 .67741 L .44201 .73242 L p F P
0 g
s
.539 .318 .527 r
.59664 .71272 m .59541 .65735 L .53745 .67474 L p F P
0 g
s
.539 .318 .527 r
.53745 .67474 m .5377 .7298 L .59664 .71272 L p F P
0 g
s
.958 .688 .48 r
.38545 .74908 m .35094 .71805 L .35379 .66276 L p F P
0 g
s
.637 .77 .944 r
.44201 .73242 m .38545 .74908 L .35094 .71805 L p F P
0 g
s
.656 .752 .92 r
.62154 .43574 m .56296 .45561 L .53199 .41858 L p F P
0 g
s
.527 .299 .513 r
.62323 .48767 m .62154 .43574 L .56296 .45561 L p F P
0 g
s
.527 .299 .513 r
.56296 .45561 m .56364 .50731 L .62323 .48767 L p F P
0 g
s
.974 .683 .409 r
.53199 .41858 m .56296 .45561 L .56364 .50731 L p F P
0 g
s
.637 .77 .944 r
.5377 .7298 m .59664 .71272 L .62637 .74396 L p F P
0 g
s
.973 .684 .418 r
.62637 .74396 m .59664 .71272 L .59541 .65735 L p F P
0 g
s
.527 .3 .514 r
.40827 .7007 m .41019 .64511 L .35379 .66276 L p F P
0 g
s
.527 .3 .514 r
.35379 .66276 m .35094 .71805 L .40827 .7007 L p F P
0 g
s
.637 .77 .944 r
.35094 .71805 m .40827 .7007 L .44201 .73242 L p F P
0 g
s
.963 .688 .464 r
.44201 .73242 m .40827 .7007 L .41019 .64511 L p F P
0 g
s
.656 .752 .92 r
.53199 .41858 m .59143 .39788 L .62154 .43574 L p F P
0 g
s
.976 .68 .384 r
.59143 .39788 m .62154 .43574 L .62323 .48767 L p F P
0 g
s
.634 .773 .947 r
.61161 .74607 m .55231 .76284 L .52067 .73159 L p F P
0 g
s
.541 .32 .529 r
.61315 .80412 m .61161 .74607 L .55231 .76284 L p F P
0 g
s
.541 .32 .529 r
.55231 .76284 m .55281 .82054 L .61315 .80412 L p F P
0 g
s
.97 .686 .437 r
.52067 .73159 m .55231 .76284 L .55281 .82054 L p F P
0 g
s
.974 .683 .409 r
.56364 .50731 m .53215 .47071 L .53199 .41858 L p F P
0 g
s
.651 .757 .927 r
.62323 .48767 m .56364 .50731 L .53215 .47071 L p F P
0 g
s
.634 .773 .947 r
.8197 .74123 m .75782 .75814 L .73026 .72663 L p F P
0 g
s
.55 .332 .538 r
.82486 .7995 m .8197 .74123 L .75782 .75814 L p F P
0 g
s
.55 .332 .538 r
.75782 .75814 m .76185 .81605 L .82486 .7995 L p F P
0 g
s
.976 .677 .369 r
.73026 .72663 m .75782 .75814 L .76185 .81605 L p F P
0 g
s
.518 .288 .504 r
.59263 .45024 m .59143 .39788 L .53199 .41858 L p F P
0 g
s
.518 .288 .504 r
.53199 .41858 m .53215 .47071 L .59263 .45024 L p F P
0 g
s
.634 .773 .947 r
.52067 .73159 m .58085 .71412 L .61161 .74607 L p F P
0 g
s
.973 .684 .416 r
.58085 .71412 m .61161 .74607 L .61315 .80412 L p F P
0 g
s
.651 .757 .927 r
.53215 .47071 m .59263 .45024 L .62323 .48767 L p F P
0 g
s
.976 .68 .384 r
.62323 .48767 m .59263 .45024 L .59143 .39788 L p F P
0 g
s
.634 .773 .947 r
.73026 .72663 m .79313 .70901 L .8197 .74123 L p F P
0 g
s
.976 .671 .339 r
.79313 .70901 m .8197 .74123 L .82486 .7995 L p F P
0 g
s
.97 .686 .437 r
.55281 .82054 m .52063 .78994 L .52067 .73159 L p F P
0 g
s
.627 .779 .954 r
.61315 .80412 m .55281 .82054 L .52063 .78994 L p F P
0 g
s
.534 .31 .521 r
.58188 .77283 m .58085 .71412 L .52067 .73159 L p F P
0 g
s
.534 .31 .521 r
.52067 .73159 m .52063 .78994 L .58188 .77283 L p F P
0 g
s
.656 .751 .92 r
.74331 .36361 m .68123 .38502 L .65159 .34511 L p F P
0 g
s
.522 .293 .508 r
.74721 .41623 m .74331 .36361 L .68123 .38502 L p F P
0 g
s
.522 .293 .508 r
.68123 .38502 m .684 .43741 L .74721 .41623 L p F P
0 g
s
.976 .672 .347 r
.65159 .34511 m .68123 .38502 L .684 .43741 L p F P
0 g
s
.976 .677 .369 r
.76185 .81605 m .7339 .7852 L .73026 .72663 L p F P
0 g
s
.627 .779 .954 r
.82486 .7995 m .76185 .81605 L .7339 .7852 L p F P
0 g
s
.543 .323 .531 r
.79793 .76795 m .79313 .70901 L .73026 .72663 L p F P
0 g
s
.543 .323 .531 r
.73026 .72663 m .7339 .7852 L .79793 .76795 L p F P
0 g
s
.627 .779 .954 r
.52063 .78994 m .58188 .77283 L .61315 .80412 L p F P
0 g
s
.973 .684 .416 r
.61315 .80412 m .58188 .77283 L .58085 .71412 L p F P
0 g
s
.656 .751 .92 r
.65159 .34511 m .71465 .32279 L .74331 .36361 L p F P
0 g
s
.974 .664 .314 r
.71465 .32279 m .74331 .36361 L .74721 .41623 L p F P
0 g
s
.627 .779 .954 r
.7339 .7852 m .79793 .76795 L .82486 .7995 L p F P
0 g
s
.976 .671 .339 r
.82486 .7995 m .79793 .76795 L .79313 .70901 L p F P
0 g
s
.976 .672 .347 r
.684 .43741 m .65389 .39792 L .65159 .34511 L p F P
0 g
s
.652 .756 .926 r
.74721 .41623 m .684 .43741 L .65389 .39792 L p F P
0 g
s
.513 .28 .499 r
.71812 .37581 m .71465 .32279 L .65159 .34511 L p F P
0 g
s
.513 .28 .499 r
.65159 .34511 m .65389 .39792 L .71812 .37581 L p F P
0 g
s
.64 .768 .941 r
.62173 .59248 m .55946 .61182 L .52642 .57577 L p F P
0 g
s
.524 .296 .51 r
.62353 .65062 m .62173 .59248 L .55946 .61182 L p F P
0 g
s
.524 .296 .51 r
.55946 .61182 m .56012 .66963 L .62353 .65062 L p F P
0 g
s
.974 .683 .408 r
.52642 .57577 m .55946 .61182 L .56012 .66963 L p F P
0 g
s
.652 .756 .926 r
.65389 .39792 m .71812 .37581 L .74721 .41623 L p F P
0 g
s
.974 .664 .314 r
.74721 .41623 m .71812 .37581 L .71465 .32279 L p F P
0 g
s
.64 .768 .941 r
.52642 .57577 m .58966 .55558 L .62173 .59248 L p F P
0 g
s
.976 .679 .382 r
.58966 .55558 m .62173 .59248 L .62353 .65062 L p F P
0 g
s
.974 .683 .408 r
.56012 .66963 m .52649 .63419 L .52642 .57577 L p F P
0 g
s
.634 .774 .947 r
.62353 .65062 m .56012 .66963 L .52649 .63419 L p F P
0 g
s
.515 .284 .501 r
.59091 .61434 m .58966 .55558 L .52642 .57577 L p F P
0 g
s
.515 .284 .501 r
.52642 .57577 m .52649 .63419 L .59091 .61434 L p F P
0 g
s
.634 .774 .947 r
.52649 .63419 m .59091 .61434 L .62353 .65062 L p F P
0 g
s
.976 .679 .382 r
.62353 .65062 m .59091 .61434 L .58966 .55558 L p F P
0 g
s
.25 Mabswid
.68352 0 m
.92932 .39872 L
s
.92932 .39872 m
1 .92252 L
s
1 .92252 m
.71869 .57173 L
s
.71869 .57173 m
.68352 0 L
s
.08354 .24876 m
0 .79366 L
s
0 .79366 m
.71869 .57173 L
s
.71869 .57173 m
.68352 0 L
s
.68352 0 m
.08354 .24876 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.8"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]= ",
  CellTags->"S2.10.8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.10.9 Three\[Hyphen]Dimensional Graphics Directives\
\>", \
"Subsection",
  CellTags->{"S2.10.9", "9.1"}],

Cell["\<\
In three dimensions, just as in two dimensions, you can give \
various graphics directives to specify how the different elements in a \
graphics object should be rendered. \
\>", "Text",
  CellTags->{"S2.10.9", "9.2"}],

Cell["\<\
All the graphics directives for two dimensions also work in three \
dimensions. There are however some additional directives in three dimensions. \
\
\>", "Text",
  CellTags->{"S2.10.9", "9.3"}],

Cell[TextData[{
  "Just as in two dimensions, you can use the directives ",
  StyleBox["PointSize", "MR"],
  ", ",
  StyleBox["Thickness", "MR"],
  " and ",
  StyleBox["Dashing", "MR"],
  " to tell ",
  StyleBox["Mathematica", "TI"],
  " how to render ",
  StyleBox["Point", "MR"],
  " and ",
  StyleBox["Line", "MR"],
  " elements. Note that in three dimensions, the lengths that appear in these \
directives are measured as fractions of the total width of the display area \
for your plot. "
}], "Text",
  CellTags->{"S2.10.9", "9.4"}],

Cell["\<\
This generates a list of 20 random points in three dimensions. \
\
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.5"}],

Cell["pts = Table[Point[Table[Random[ ], {3}]], {20}];", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.9"],

Cell["\<\
This displays the points, with each one being a circle whose \
diameter is 5% of the display area width. \
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.6"}],

Cell[CellGroupData[{

Cell["Show[Graphics3D[ { PointSize[0.05], pts } ]]", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08326 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0554539 1.16767 1.4859e-16 1.16767 [
[ 0 0 0 0 ]
[ 1 1.08326 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08171 .24016 m
0 .77813 L
s
0 .77813 m
.417 1.08326 L
s
.417 1.08326 m
.43131 .59727 L
s
.43131 .59727 m
.08171 .24016 L
s
.65859 0 m
.9338 .43476 L
s
.9338 .43476 m
1 .94671 L
s
1 .94671 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.08171 .24016 m
0 .77813 L
s
0 .77813 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.65859 0 m
.08171 .24016 L
s
.43131 .59727 m
.9338 .43476 L
s
.9338 .43476 m
1 .94671 L
s
1 .94671 m
.417 1.08326 L
s
.417 1.08326 m
.43131 .59727 L
s
0 0 m
1 0 L
1 1.08326 L
0 1.08326 L
closepath
clip
newpath
.05 w
.57938 .51056 Mdot
.63475 .61502 Mdot
.5223 .84453 Mdot
.35814 .67288 Mdot
.62942 .62632 Mdot
.91477 .57034 Mdot
.65551 .41317 Mdot
.37048 .50384 Mdot
.49773 .84322 Mdot
.93085 .77677 Mdot
.93513 .73083 Mdot
.66413 .28458 Mdot
.4403 .6895 Mdot
.95476 .91992 Mdot
.66701 .17489 Mdot
.57298 .28337 Mdot
.70249 .44539 Mdot
.3004 .47703 Mdot
.77833 .65378 Mdot
.72652 .57506 Mdot
.25 Mabswid
.65859 0 m
.9338 .43476 L
s
.9338 .43476 m
1 .94671 L
s
1 .94671 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.08171 .24016 m
0 .77813 L
s
0 .77813 m
.68569 .56207 L
s
.68569 .56207 m
.65859 0 L
s
.65859 0 m
.08171 .24016 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell[TextData[{
  "As in two dimensions, you can use ",
  StyleBox["AbsolutePointSize", "MR"],
  ", ",
  StyleBox["AbsoluteThickness", "MR"],
  " and ",
  StyleBox["AbsoluteDashing", "MR"],
  " if you want to measure length in absolute units. "
}], "Text",
  CellTags->{"S2.10.9", "9.7"}],

Cell["\<\
This generates a line through 10 random points in three dimensions. \
\
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.8"}],

Cell["line = Line[Table[Random[ ], {10}, {3}]] ;", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.9"],

Cell["\<\
This shows the line dashed, with a thickness of 2 printer's points. \
\
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.9"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics3D[ { AbsoluteThickness[2], AbsoluteDashing[{5, 5}], \
line } ]]\
\>", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.43083 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.208652 1.50056 -1.05547e-16 1.50056 [
[ 0 0 0 0 ]
[ 1 1.43083 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.09094 .18159 m
0 .98833 L
s
0 .98833 m
.55738 1.43083 L
s
.55738 1.43083 m
.55519 .7014 L
s
.55519 .7014 m
.09094 .18159 L
s
.52427 0 m
.93314 .57821 L
s
.93314 .57821 m
1 1.32866 L
s
1 1.32866 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.09094 .18159 m
0 .98833 L
s
0 .98833 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.52427 0 m
.09094 .18159 L
s
.55519 .7014 m
.93314 .57821 L
s
.93314 .57821 m
1 1.32866 L
s
1 1.32866 m
.55738 1.43083 L
s
.55738 1.43083 m
.55519 .7014 L
s
0 0 m
1 0 L
1 1.43083 L
0 1.43083 L
closepath
clip
newpath
2 Mabswid
[ 5 5 ] 0 Mabsdash
.50764 .67631 m
.30347 .36319 L
s
.30856 .4273 m
.50764 .67631 L
s
.30347 .36319 m
.80946 .99315 L
s
.65641 1.37643 m
.40962 .72556 L
s
.46595 .81082 m
.71104 .84733 L
s
.34077 1.01409 m
.46595 .81082 L
s
.28837 .3884 m
.34077 1.01409 L
s
.80946 .99315 m
.28837 .3884 L
s
.40962 .72556 m
.30856 .4273 L
s
.25 Mabswid
[ ] 0 setdash
.52427 0 m
.93314 .57821 L
s
.93314 .57821 m
1 1.32866 L
s
1 1.32866 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.09094 .18159 m
0 .98833 L
s
0 .98833 m
.52051 .82642 L
s
.52051 .82642 m
.52427 0 L
s
.52427 0 m
.09094 .18159 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell[TextData[{
  "For ",
  StyleBox["Point", "MR"],
  " and ",
  StyleBox["Line", "MR"],
  " objects, the color specification directives also work the same in three \
dimensions as in two dimensions. For ",
  StyleBox["Polygon", "MR"],
  " objects, however, they can work differently. "
}], "Text",
  CellTags->{"S2.10.9", "9.10"}],

Cell[TextData[{
  "In two dimensions, polygons are always assumed to have an intrinsic color, \
specified directly by graphics directives such as ",
  StyleBox["RGBColor", "MR"],
  ". In three dimensions, however, ",
  StyleBox["Mathematica", "TI"],
  " also provides the option of generating colors for polygons using a more \
physical approach based on simulated illumination. With the default option \
setting ",
  StyleBox["Lighting", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " for ",
  StyleBox["Graphics3D", "MR"],
  " objects, ",
  StyleBox["Mathematica", "TI"],
  " ignores explicit colors specified for polygons, and instead determines \
all polygon colors using the simulated illumination model. Even in this case, \
however, explicit colors are used for points and lines. "
}], "Text",
  CellTags->{"S2.10.9", "9.11"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["Lighting", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["False", "MR"],
              " "
            }]], Cell["intrinsic colors "]},
          {Cell[TextData[{
              StyleBox["Lighting", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["True", "MR"],
              " "
            }]], Cell["colors based on simulated illumination (default) "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.9"],

Cell["The two schemes for coloring polygons in three dimensions. ", "Caption",
  CellTags->"S2.10.9"],

Cell["This loads a package which defines various polyhedra. ", "MathCaption",
  CellTags->{"S2.10.9", "9.12"}],

Cell["<<Graphics`Polyhedra`", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.9"],

Cell["\<\
This draws an icosahedron, using the same gray level for all faces. \
\
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.13"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics3D[{GrayLevel[0.7], Icosahedron[ ]}], Lighting -> \
False]\
\>", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1504 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0844264 1.2109 6.53232e-17 1.2109 [
[ 0 0 0 0 ]
[ 1 1.1504 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08676 .24213 m
0 .87494 L
s
0 .87494 m
.38254 1.1504 L
s
.38254 1.1504 m
.40225 .57033 L
s
.40225 .57033 m
.08676 .24213 L
s
.67488 0 m
.92568 .39615 L
s
.92568 .39615 m
1 1.00617 L
s
1 1.00617 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.08676 .24213 m
0 .87494 L
s
0 .87494 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.67488 0 m
.08676 .24213 L
s
.40225 .57033 m
.92568 .39615 L
s
.92568 .39615 m
1 1.00617 L
s
1 1.00617 m
.38254 1.1504 L
s
.38254 1.1504 m
.40225 .57033 L
s
0 0 m
1 0 L
1 1.1504 L
0 1.1504 L
closepath
clip
newpath
.5 Mabswid
.7 g
.57293 .65641 m .52102 .33433 L .25726 .56891 L closepath p F P
0 g
s
.7 g
.8283 .50453 m .52102 .33433 L .57293 .65641 L closepath p F P
0 g
s
.7 g
.57293 .65641 m .25726 .56891 L .38779 .89469 L closepath p F P
0 g
s
.7 g
.8283 .50453 m .57293 .65641 L .74952 .86104 L closepath p F P
0 g
s
.7 g
.74952 .86104 m .57293 .65641 L .38779 .89469 L closepath p F P
0 g
s
.7 g
.25726 .56891 m .52102 .33433 L .27705 .33255 L closepath p F P
0 g
s
.7 g
.25726 .56891 m .27705 .33255 L .18103 .71712 L closepath p F P
0 g
s
.7 g
.38779 .89469 m .25726 .56891 L .18103 .71712 L closepath p F P
0 g
s
.7 g
.66959 .28294 m .52102 .33433 L .8283 .50453 L closepath p F P
0 g
s
.7 g
.27705 .33255 m .52102 .33433 L .66959 .28294 L closepath p F P
0 g
s
.7 g
.52102 .92577 m .74952 .86104 L .38779 .89469 L closepath p F P
0 g
s
.7 g
.52102 .92577 m .38779 .89469 L .18103 .71712 L closepath p F P
0 g
s
.7 g
.83414 .64883 m .8283 .50453 L .74952 .86104 L closepath p F P
0 g
s
.7 g
.66959 .28294 m .8283 .50453 L .83414 .64883 L closepath p F P
0 g
s
.7 g
.52102 .92577 m .83414 .64883 L .74952 .86104 L closepath p F P
0 g
s
.7 g
.27705 .33255 m .66959 .28294 L .45263 .5383 L closepath p F P
0 g
s
.7 g
.18103 .71712 m .27705 .33255 L .45263 .5383 L closepath p F P
0 g
s
.7 g
.52102 .92577 m .18103 .71712 L .45263 .5383 L closepath p F P
0 g
s
.7 g
.45263 .5383 m .66959 .28294 L .83414 .64883 L closepath p F P
0 g
s
.7 g
.52102 .92577 m .45263 .5383 L .83414 .64883 L closepath p F P
0 g
s
.25 Mabswid
.67488 0 m
.92568 .39615 L
s
.92568 .39615 m
1 1.00617 L
s
1 1.00617 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.08676 .24213 m
0 .87494 L
s
0 .87494 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.67488 0 m
.08676 .24213 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell[TextData[{
  "With the default setting ",
  StyleBox["Lighting", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", the colors of polygons are determined by the simulated illumination \
model, and explicit color specifications are ignored. "
}], "MathCaption",
  CellTags->{"S2.10.9", "9.14"}],

Cell[CellGroupData[{

Cell["Show[%, Lighting -> True]", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1504 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0844264 1.2109 6.53232e-17 1.2109 [
[ 0 0 0 0 ]
[ 1 1.1504 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08676 .24213 m
0 .87494 L
s
0 .87494 m
.38254 1.1504 L
s
.38254 1.1504 m
.40225 .57033 L
s
.40225 .57033 m
.08676 .24213 L
s
.67488 0 m
.92568 .39615 L
s
.92568 .39615 m
1 1.00617 L
s
1 1.00617 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.08676 .24213 m
0 .87494 L
s
0 .87494 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.67488 0 m
.08676 .24213 L
s
.40225 .57033 m
.92568 .39615 L
s
.92568 .39615 m
1 1.00617 L
s
1 1.00617 m
.38254 1.1504 L
s
.38254 1.1504 m
.40225 .57033 L
s
0 0 m
1 0 L
1 1.1504 L
0 1.1504 L
closepath
clip
newpath
.5 Mabswid
.755 .669 .767 r
.57293 .65641 m .52102 .33433 L .25726 .56891 L closepath p F P
0 g
s
.596 .559 .783 r
.8283 .50453 m .52102 .33433 L .57293 .65641 L closepath p F P
0 g
s
.789 .578 .614 r
.57293 .65641 m .25726 .56891 L .38779 .89469 L closepath p F P
0 g
s
.493 .35 .614 r
.8283 .50453 m .57293 .65641 L .74952 .86104 L closepath p F P
0 g
s
.635 .366 .494 r
.74952 .86104 m .57293 .65641 L .38779 .89469 L closepath p F P
0 g
s
.842 .889 .873 r
.25726 .56891 m .52102 .33433 L .27705 .33255 L closepath p F P
0 g
s
.902 .859 .413 r
.25726 .56891 m .27705 .33255 L .18103 .71712 L closepath p F P
0 g
s
.946 .618 .376 r
.38779 .89469 m .25726 .56891 L .18103 .71712 L closepath p F P
0 g
s
.298 .551 .921 r
.66959 .28294 m .52102 .33433 L .8283 .50453 L closepath p F P
0 g
s
.3 .789 .892 r
.27705 .33255 m .52102 .33433 L .66959 .28294 L closepath p F P
0 g
s
.201 0 0 r
.52102 .92577 m .74952 .86104 L .38779 .89469 L closepath p F P
0 g
s
0 .381 .824 r
.52102 .92577 m .38779 .89469 L .18103 .71712 L closepath p F P
0 g
s
0 0 .085 r
.83414 .64883 m .8283 .50453 L .74952 .86104 L closepath p F P
0 g
s
.894 .505 .062 r
.66959 .28294 m .8283 .50453 L .83414 .64883 L closepath p F P
0 g
s
.835 .977 .881 r
.52102 .92577 m .83414 .64883 L .74952 .86104 L closepath p F P
0 g
s
.595 .28 .405 r
.27705 .33255 m .66959 .28294 L .45263 .5383 L closepath p F P
0 g
s
.402 .256 .566 r
.18103 .71712 m .27705 .33255 L .45263 .5383 L closepath p F P
0 g
s
.558 .549 .801 r
.52102 .92577 m .18103 .71712 L .45263 .5383 L closepath p F P
0 g
s
.809 .574 .582 r
.45263 .5383 m .66959 .28294 L .83414 .64883 L closepath p F P
0 g
s
.767 .693 .781 r
.52102 .92577 m .45263 .5383 L .83414 .64883 L closepath p F P
0 g
s
.25 Mabswid
.67488 0 m
.92568 .39615 L
s
.92568 .39615 m
1 1.00617 L
s
1 1.00617 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.08676 .24213 m
0 .87494 L
s
0 .87494 m
.70966 .66123 L
s
.70966 .66123 m
.67488 0 L
s
.67488 0 m
.08676 .24213 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell["\<\
Explicit color directives are, however, always followed for points \
and lines. \
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.15"}],

Cell[CellGroupData[{

Cell["\<\
Show[{%, Graphics3D[{GrayLevel[0.5], Thickness[0.05], Line[{{0, 0, \
-2}, {0, 0, 2}}]}]}]\
\>", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.58159 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.282463 1.58964 -0.00804952 1.58964 [
[ 0 0 0 0 ]
[ 1 1.58159 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08405 .22511 m
0 1.29501 L
s
0 1.29501 m
.36568 1.58159 L
s
.36568 1.58159 m
.38758 .56477 L
s
.38758 .56477 m
.08405 .22511 L
s
.65755 0 m
.92326 .37918 L
s
.92326 .37918 m
1 1.42624 L
s
1 1.42624 m
.6881 1.09945 L
s
.6881 1.09945 m
.65755 0 L
s
.08405 .22511 m
0 1.29501 L
s
0 1.29501 m
.6881 1.09945 L
s
.6881 1.09945 m
.65755 0 L
s
.65755 0 m
.08405 .22511 L
s
.38758 .56477 m
.92326 .37918 L
s
.92326 .37918 m
1 1.42624 L
s
1 1.42624 m
.36568 1.58159 L
s
.36568 1.58159 m
.38758 .56477 L
s
0 0 m
1 0 L
1 1.58159 L
0 1.58159 L
closepath
clip
newpath
.5 Mabswid
.757 .673 .769 r
.56704 .84046 m .51236 .50646 L .23942 .74896 L closepath p F P
0 g
s
.59 .557 .786 r
.82621 .68369 m .51236 .50646 L .56704 .84046 L closepath p F P
0 g
s
.793 .577 .609 r
.56704 .84046 m .23942 .74896 L .37607 1.08264 L closepath p F P
0 g
s
.479 .335 .607 r
.82621 .68369 m .56704 .84046 L .74415 1.04604 L closepath p F P
0 g
s
.629 .353 .48 r
.74415 1.04604 m .56704 .84046 L .37607 1.08264 L closepath p F P
0 g
s
.845 .906 .878 r
.23942 .74896 m .51236 .50646 L .27146 .51732 L closepath p F P
0 g
s
.837 .811 .325 r
.23942 .74896 m .27146 .51732 L .17928 .89617 L closepath p F P
0 g
s
.949 .608 .333 r
.37607 1.08264 m .23942 .74896 L .17928 .89617 L closepath p F P
0 g
s
.245 .532 .92 r
.65765 .47136 m .51236 .50646 L .82621 .68369 L closepath p F P
0 g
s
.203 .731 .818 r
.27146 .51732 m .51236 .50646 L .65765 .47136 L closepath p F P
0 g
s
.5 g
.05 w
.51236 .32498 m
.51236 .48865 L
s
.5 Mabswid
.104 0 0 r
.51236 1.0959 m .74415 1.04604 L .37607 1.08264 L closepath p F P
0 g
s
.027 .437 .869 r
.51236 1.0959 m .37607 1.08264 L .17928 .89617 L closepath p F P
0 g
s
0 0 0 r
.8142 .82859 m .82621 .68369 L .74415 1.04604 L closepath p F P
0 g
s
.925 .546 .151 r
.65765 .47136 m .82621 .68369 L .8142 .82859 L closepath p F P
0 g
s
.843 .959 .885 r
.51236 1.0959 m .8142 .82859 L .74415 1.04604 L closepath p F P
0 g
s
.606 .303 .429 r
.27146 .51732 m .65765 .47136 L .44809 .72368 L closepath p F P
0 g
s
.426 .281 .579 r
.17928 .89617 m .27146 .51732 L .44809 .72368 L closepath p F P
0 g
s
.568 .552 .796 r
.51236 1.0959 m .17928 .89617 L .44809 .72368 L closepath p F P
0 g
s
.804 .575 .591 r
.44809 .72368 m .65765 .47136 L .8142 .82859 L closepath p F P
0 g
s
.764 .687 .778 r
.51236 1.0959 m .44809 .72368 L .8142 .82859 L closepath p F P
0 g
s
.5 g
.05 w
.51236 1.0959 m
.51236 1.33236 L
s
0 g
.25 Mabswid
.65755 0 m
.92326 .37918 L
s
.92326 .37918 m
1 1.42624 L
s
1 1.42624 m
.6881 1.09945 L
s
.6881 1.09945 m
.65755 0 L
s
.08405 .22511 m
0 1.29501 L
s
0 1.29501 m
.6881 1.09945 L
s
.6881 1.09945 m
.65755 0 L
s
.65755 0 m
.08405 .22511 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["EdgeForm[", "MR"],
              " ",
              StyleBox["]", "MR"],
              " "
            }]], Cell["draw no lines at the edges of polygons "]},
          {Cell[TextData[{
              StyleBox["EdgeForm[", "MR"],
              StyleBox["g", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use the graphics directives ",
              StyleBox["g", "TI"],
              " to determine how to draw lines at the edges of polygons "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.9"],

Cell["Giving graphics directives for all the edges of polygons. ", "Caption",
  CellTags->"S2.10.9"],

Cell[TextData[{
  "When you render a three\[Hyphen]dimensional graphics object in ",
  StyleBox["Mathematica", "TI"],
  ", there are two kinds of lines that can appear. The first kind are lines \
from explicit ",
  StyleBox["Line", "MR"],
  " primitives that you included in the graphics object. The second kind are \
lines that were generated as the edges of polygons. "
}], "Text",
  CellTags->{"S2.10.9", "9.16"}],

Cell[TextData[{
  "You can tell ",
  StyleBox["Mathematica", "TI"],
  " how to render all lines of the second kind by giving a list of graphics \
directives inside ",
  StyleBox["EdgeForm", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.9", "9.17"}],

Cell["\<\
This renders a dodecahedron with its edges shown as thick gray \
lines. \
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.18"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics3D[ {EdgeForm[{GrayLevel[0.5], Thickness[0.02]}], \
Dodecahedron[ ]}]]\
\>", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 3.61581e-17 1.08755 [
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.02 w
.67 .732 .896 r
.33115 .32429 m .44491 .44907 L .65615 .42467 L p F P
.5 g
s
.889 .75 .702 r
.44491 .44907 m .33115 .32429 L p .24235 .68284 L F P
.5 g
s
.889 .75 .702 r
.24235 .68284 m .39521 .65616 L .44491 .44907 L p F P
.5 g
s
.675 .526 .675 r
.44491 .44907 m .39521 .65616 L .57791 .76621 L p F P
.5 g
s
.675 .526 .675 r
.65615 .42467 m .44491 .44907 L p .57791 .76621 L F P
.5 g
s
.762 .372 .314 r
.39521 .65616 m .24235 .68284 L p .56015 .87859 L F P
.5 g
s
.762 .372 .314 r
.56015 .87859 m .57791 .76621 L .39521 .65616 L p F P
.5 g
s
.67 .732 .896 r
.48589 .20782 m .33115 .32429 L p .65615 .42467 L F P
.5 g
s
.67 .732 .896 r
.65615 .42467 m .69731 .27878 L .48589 .20782 L p F P
.5 g
s
.675 .526 .675 r
.57791 .76621 m .74263 .62049 L .65615 .42467 L p F P
.5 g
s
.273 .313 .722 r
.65615 .42467 m .74263 .62049 L .85199 .62068 L p F P
.5 g
s
.273 .313 .722 r
.69731 .27878 m .65615 .42467 L p .85199 .62068 L F P
.5 g
s
.244 0 .208 r
.57791 .76621 m .56015 .87859 L .73868 .79032 L p F P
.5 g
s
.244 0 .208 r
.74263 .62049 m .57791 .76621 L p .73868 .79032 L F P
.5 g
s
.244 0 .208 r
.73868 .79032 m .85199 .62068 L .74263 .62049 L p F P
.5 g
s
.889 .75 .702 r
.33115 .32429 m .19481 .46702 L .24235 .68284 L p F P
.5 g
s
0 0 0 r
.33115 .32429 m .48589 .20782 L p .25792 .45112 L F P
.5 g
s
0 0 0 r
.25792 .45112 m .19481 .46702 L .33115 .32429 L p F P
.5 g
s
.762 .372 .314 r
.24235 .68284 m .33664 .82736 L .56015 .87859 L p F P
.5 g
s
0 .109 .635 r
.33664 .82736 m .24235 .68284 L .19481 .46702 L p F P
.5 g
s
.273 .313 .722 r
.85199 .62068 m .82611 .39367 L .69731 .27878 L p F P
.5 g
s
.709 .208 .046 r
.69731 .27878 m .82611 .39367 L .68527 .40123 L p F P
.5 g
s
.709 .208 .046 r
.48589 .20782 m .69731 .27878 L p .68527 .40123 L F P
.5 g
s
.633 .775 .949 r
.73868 .79032 m .56015 .87859 L .33664 .82736 L p F P
.5 g
s
0 .109 .635 r
.19481 .46702 m .25792 .45112 L p .33664 .82736 L F P
.5 g
s
.939 .801 .68 r
.82611 .39367 m .85199 .62068 L .73868 .79032 L p F P
.5 g
s
.709 .208 .046 r
.68527 .40123 m .45664 .27423 L .48589 .20782 L p F P
.5 g
s
0 0 0 r
.48589 .20782 m .45664 .27423 L .25792 .45112 L p F P
.5 g
s
0 .109 .635 r
.25792 .45112 m .35521 .69402 L .33664 .82736 L p F P
.5 g
s
.633 .775 .949 r
.33664 .82736 m .35521 .69402 L p .73868 .79032 L F P
.5 g
s
.939 .801 .68 r
.68527 .40123 m .82611 .39367 L p .73868 .79032 L F P
.5 g
s
.939 .801 .68 r
.73868 .79032 m .62474 .66693 L .68527 .40123 L p F P
.5 g
s
.633 .775 .949 r
.35521 .69402 m .62474 .66693 L .73868 .79032 L p F P
.5 g
s
.666 .512 .666 r
.62474 .66693 m .35521 .69402 L .25792 .45112 L p F P
.5 g
s
.666 .512 .666 r
.68527 .40123 m .62474 .66693 L p .25792 .45112 L F P
.5 g
s
.666 .512 .666 r
.25792 .45112 m .45664 .27423 L .68527 .40123 L p F P
.5 g
s
0 g
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["FaceForm[", "MR"],
              StyleBox["gfront", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["gback", "TI"],
              StyleBox["]", "MR"],
              " "
            }]], Cell[TextData[{
              "use ",
              StyleBox["gfront", "TI"],
              " graphics directives for the front face of each polygon, and ",
              
              StyleBox["gback", "TI"],
              " for the back "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.9"],

Cell["Rendering the fronts and backs of polygons differently. ", "Caption",
  CellTags->"S2.10.9"],

Cell[TextData[{
  "An important aspect of polygons in three dimensions is that they have both \
front and back faces. ",
  StyleBox["Mathematica", "TI"],
  " uses the following convention to define the \[OpenCurlyDoubleQuote]front \
face\[CloseCurlyDoubleQuote] of a polygon: if you look at a polygon from the \
front, then the corners of the polygon will appear counterclockwise, when \
taken in the order that you specified them. "
}], "Text",
  CellTags->{"S2.10.9", "9.19"}],

Cell["This defines a dodecahedron with one face removed. ", "MathCaption",
  CellTags->{"S2.10.9", "9.20"}],

Cell["d = Drop[Dodecahedron[ ], {6}] ;", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.9"],

Cell["You can now see inside the dodecahedron. ", "MathCaption",
  CellTags->{"S2.10.9", "9.21"}],

Cell[CellGroupData[{

Cell["Show[Graphics3D[d]]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 3.61581e-17 1.08755 [
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.5 Mabswid
.67 .732 .896 r
.33115 .32429 m .44491 .44907 L .65615 .42467 L p F P
0 g
s
.889 .75 .702 r
.44491 .44907 m .33115 .32429 L p .24235 .68284 L F P
0 g
s
.889 .75 .702 r
.24235 .68284 m .39521 .65616 L .44491 .44907 L p F P
0 g
s
.675 .526 .675 r
.44491 .44907 m .39521 .65616 L .57791 .76621 L p F P
0 g
s
.675 .526 .675 r
.65615 .42467 m .44491 .44907 L p .57791 .76621 L F P
0 g
s
.762 .372 .314 r
.39521 .65616 m .24235 .68284 L p .56015 .87859 L F P
0 g
s
.762 .372 .314 r
.56015 .87859 m .57791 .76621 L .39521 .65616 L p F P
0 g
s
.67 .732 .896 r
.48589 .20782 m .33115 .32429 L p .65615 .42467 L F P
0 g
s
.67 .732 .896 r
.65615 .42467 m .69731 .27878 L .48589 .20782 L p F P
0 g
s
.675 .526 .675 r
.57791 .76621 m .74263 .62049 L .65615 .42467 L p F P
0 g
s
.273 .313 .722 r
.65615 .42467 m .74263 .62049 L .85199 .62068 L p F P
0 g
s
.273 .313 .722 r
.69731 .27878 m .65615 .42467 L p .85199 .62068 L F P
0 g
s
.244 0 .208 r
.57791 .76621 m .56015 .87859 L .73868 .79032 L p F P
0 g
s
.244 0 .208 r
.74263 .62049 m .57791 .76621 L p .73868 .79032 L F P
0 g
s
.244 0 .208 r
.73868 .79032 m .85199 .62068 L .74263 .62049 L p F P
0 g
s
.889 .75 .702 r
.33115 .32429 m .19481 .46702 L .24235 .68284 L p F P
0 g
s
0 0 0 r
.33115 .32429 m .48589 .20782 L p .25792 .45112 L F P
0 g
s
0 0 0 r
.25792 .45112 m .19481 .46702 L .33115 .32429 L p F P
0 g
s
.762 .372 .314 r
.24235 .68284 m .33664 .82736 L .56015 .87859 L p F P
0 g
s
0 .109 .635 r
.33664 .82736 m .24235 .68284 L .19481 .46702 L p F P
0 g
s
.273 .313 .722 r
.85199 .62068 m .82611 .39367 L .69731 .27878 L p F P
0 g
s
.709 .208 .046 r
.69731 .27878 m .82611 .39367 L .68527 .40123 L p F P
0 g
s
.709 .208 .046 r
.48589 .20782 m .69731 .27878 L p .68527 .40123 L F P
0 g
s
.633 .775 .949 r
.73868 .79032 m .56015 .87859 L .33664 .82736 L p F P
0 g
s
0 .109 .635 r
.19481 .46702 m .25792 .45112 L p .33664 .82736 L F P
0 g
s
.939 .801 .68 r
.82611 .39367 m .85199 .62068 L .73868 .79032 L p F P
0 g
s
.709 .208 .046 r
.68527 .40123 m .45664 .27423 L .48589 .20782 L p F P
0 g
s
0 0 0 r
.48589 .20782 m .45664 .27423 L .25792 .45112 L p F P
0 g
s
0 .109 .635 r
.25792 .45112 m .35521 .69402 L .33664 .82736 L p F P
0 g
s
.633 .775 .949 r
.33664 .82736 m .35521 .69402 L p .73868 .79032 L F P
0 g
s
.939 .801 .68 r
.68527 .40123 m .82611 .39367 L p .73868 .79032 L F P
0 g
s
.939 .801 .68 r
.73868 .79032 m .62474 .66693 L .68527 .40123 L p F P
0 g
s
.633 .775 .949 r
.35521 .69402 m .62474 .66693 L .73868 .79032 L p F P
0 g
s
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.9"]
}, Open  ]],

Cell["\<\
This makes the front (outside) face of each polygon light gray, and \
the back (inside) face dark gray. \
\>", "MathCaption",
  CellTags->{"S2.10.9", "9.22"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics3D[ {FaceForm[GrayLevel[0.8], GrayLevel[0.3]], d}], \
Lighting -> False]\
\>", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.10.9"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 3.61581e-17 1.08755 [
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.5 Mabswid
.3 g
.33115 .32429 m .44491 .44907 L .65615 .42467 L p F P
0 g
s
.3 g
.44491 .44907 m .33115 .32429 L p .24235 .68284 L F P
0 g
s
.3 g
.24235 .68284 m .39521 .65616 L .44491 .44907 L p F P
0 g
s
.3 g
.44491 .44907 m .39521 .65616 L .57791 .76621 L p F P
0 g
s
.3 g
.65615 .42467 m .44491 .44907 L p .57791 .76621 L F P
0 g
s
.3 g
.39521 .65616 m .24235 .68284 L p .56015 .87859 L F P
0 g
s
.3 g
.56015 .87859 m .57791 .76621 L .39521 .65616 L p F P
0 g
s
.3 g
.48589 .20782 m .33115 .32429 L p .65615 .42467 L F P
0 g
s
.3 g
.65615 .42467 m .69731 .27878 L .48589 .20782 L p F P
0 g
s
.3 g
.57791 .76621 m .74263 .62049 L .65615 .42467 L p F P
0 g
s
.3 g
.65615 .42467 m .74263 .62049 L .85199 .62068 L p F P
0 g
s
.3 g
.69731 .27878 m .65615 .42467 L p .85199 .62068 L F P
0 g
s
.3 g
.57791 .76621 m .56015 .87859 L .73868 .79032 L p F P
0 g
s
.3 g
.74263 .62049 m .57791 .76621 L p .73868 .79032 L F P
0 g
s
.3 g
.73868 .79032 m .85199 .62068 L .74263 .62049 L p F P
0 g
s
.3 g
.33115 .32429 m .19481 .46702 L .24235 .68284 L p F P
0 g
s
.8 g
.33115 .32429 m .48589 .20782 L p .25792 .45112 L F P
0 g
s
.8 g
.25792 .45112 m .19481 .46702 L .33115 .32429 L p F P
0 g
s
.3 g
.24235 .68284 m .33664 .82736 L .56015 .87859 L p F P
0 g
s
.8 g
.33664 .82736 m .24235 .68284 L .19481 .46702 L p F P
0 g
s
.3 g
.85199 .62068 m .82611 .39367 L .69731 .27878 L p F P
0 g
s
.8 g
.69731 .27878 m .82611 .39367 L .68527 .40123 L p F P
0 g
s
.8 g
.48589 .20782 m .69731 .27878 L p .68527 .40123 L F P
0 g
s
.8 g
.73868 .79032 m .56015 .87859 L .33664 .82736 L p F P
0 g
s
.8 g
.19481 .46702 m .25792 .45112 L p .33664 .82736 L F P
0 g
s
.8 g
.82611 .39367 m .85199 .62068 L .73868 .79032 L p F P
0 g
s
.8 g
.68527 .40123 m .45664 .27423 L .48589 .20782 L p F P
0 g
s
.8 g
.48589 .20782 m .45664 .27423 L .25792 .45112 L p F P
0 g
s
.8 g
.25792 .45112 m .35521 .69402 L .33664 .82736 L p F P
0 g
s
.8 g
.33664 .82736 m .35521 .69402 L p .73868 .79032 L F P
0 g
s
.8 g
.68527 .40123 m .82611 .39367 L p .73868 .79032 L F P
0 g
s
.8 g
.73868 .79032 m .62474 .66693 L .68527 .40123 L p F P
0 g
s
.8 g
.35521 .69402 m .62474 .66693 L .73868 .79032 L p F P
0 g
s
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.9"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.10.9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
2.10.10 Coordinate Systems for Three\[Hyphen]Dimensional Graphics\
\
\>", "Subsection",
  CellTags->{"S2.10.10", "10.1"}],

Cell[TextData[{
  "Whenever ",
  StyleBox["Mathematica", "TI"],
  " draws a three\[Hyphen]dimensional object, it always effectively puts a \
cuboidal box around the object. With the default option setting ",
  StyleBox["Boxed", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " in fact draws the edges of this box explicitly. But in general, ",
  StyleBox["Mathematica", "TI"],
  " automatically \[OpenCurlyDoubleQuote]clips\[CloseCurlyDoubleQuote] any \
parts of your object that extend outside of the cuboidal box. "
}], "Text",
  CellTags->{"S2.10.10", "10.2"}],

Cell[TextData[{
  "The option ",
  StyleBox["PlotRange", "MR"],
  " specifies the range of ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " coordinates that ",
  StyleBox["Mathematica", "TI"],
  " should include in the box. As in two dimensions the default setting is ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", which makes ",
  StyleBox["Mathematica", "TI"],
  " use an internal algorithm to try and include the \
\[OpenCurlyDoubleQuote]interesting parts\[CloseCurlyDoubleQuote] of a plot, \
but drop outlying parts. With ",
  StyleBox["PlotRange", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["All", "MR"],
  ", ",
  StyleBox["Mathematica", "TI"],
  " will include all parts. "
}], "Text",
  CellTags->{"S2.10.10", "10.3"}],

Cell["This loads a package defining various polyhedra. ", "MathCaption",
  CellTags->{"S2.10.10", "10.4"}],

Cell["<<Graphics`Polyhedra`", "Input",
  CellLabel->"In[1]:= ",
  CellTags->"S2.10.10"],

Cell["This creates a stellated icosahedron. ", "MathCaption",
  CellTags->{"S2.10.10", "10.5"}],

Cell["stel = Stellate[Icosahedron[ ]] ;", "Input",
  CellLabel->"In[2]:= ",
  CellTags->"S2.10.10"],

Cell["Here is the stellated icosahedron, drawn in a box. ", "MathCaption",
  CellTags->{"S2.10.10", "10.6"}],

Cell[CellGroupData[{

Cell["Show[Graphics3D[stel], Axes -> True]", "Input",
  CellLabel->"In[3]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 6.16911e-17 1.08755 [
[.19758 .1856 -11.4908 -9 ]
[.19758 .1856 .50925 0 ]
[.35212 .12216 -5.44839 -9 ]
[.35212 .12216 .55161 0 ]
[.5164 .05478 -5.1514 -9 ]
[.5164 .05478 .8486 0 ]
[.10066 .80545 -6.72912 0 ]
[.10066 .80545 5.27088 9 ]
[.21156 .887 -3.26269 0 ]
[.21156 .887 2.73731 9 ]
[.31085 .96001 -3.17537 0 ]
[.31085 .96001 2.82463 9 ]
[.04788 .32955 -12 -2.72392 ]
[.04788 .32955 0 6.27608 ]
[.02586 .4711 -6 -2.84609 ]
[.02586 .4711 0 6.15391 ]
[.00165 .6267 -6 -2.98166 ]
[.00165 .6267 0 6.01834 ]
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
.68538 0 L
s
.20676 .19562 m
.21134 .20064 L
s
[(-1)] .19758 .1856 .91513 1 Mshowa
.36072 .1327 m
.36502 .13796 L
s
[(0)] .35212 .12216 .81613 1 Mshowa
.52432 .06583 m
.52828 .07135 L
s
[(1)] .5164 .05478 .71713 1 Mshowa
.125 Mabswid
.23682 .18334 m
.23954 .18638 L
s
.26724 .1709 m
.26993 .17397 L
s
.29803 .15832 m
.30068 .16142 L
s
.32918 .14559 m
.3318 .14871 L
s
.39264 .11965 m
.39518 .12284 L
s
.42495 .10644 m
.42746 .10966 L
s
.45767 .09307 m
.46013 .09632 L
s
.49079 .07954 m
.49321 .08282 L
s
.17704 .20777 m
.17983 .21075 L
s
.14768 .21977 m
.15049 .22272 L
s
.11865 .23163 m
.1215 .23455 L
s
.08996 .24336 m
.09284 .24625 L
s
.55828 .05195 m
.56061 .0553 L
s
.59266 .0379 m
.59495 .04127 L
s
.62749 .02366 m
.62973 .02707 L
s
.66276 .00925 m
.66495 .01268 L
s
.25 Mabswid
0 .71646 m
.38643 1.00162 L
s
.1023 .79195 m
.10312 .7852 L
s
[(-1)] .10066 .80545 .12152 -1 Mshowa
.21274 .87345 m
.21334 .86668 L
s
[(0)] .21156 .887 .08756 -1 Mshowa
.31164 .94644 m
.31204 .93965 L
s
[(1)] .31085 .96001 .05846 -1 Mshowa
.125 Mabswid
.12541 .809 m
.12587 .80495 L
s
.14799 .82567 m
.14842 .82161 L
s
.17006 .84196 m
.17047 .8379 L
s
.19164 .85788 m
.19202 .85382 L
s
.23339 .88869 m
.23372 .88462 L
s
.25359 .90359 m
.25389 .89953 L
s
.27335 .91818 m
.27363 .91411 L
s
.2927 .93246 m
.29296 .92839 L
s
.07864 .77449 m
.07917 .77045 L
s
.05442 .75662 m
.05498 .75258 L
s
.02962 .73832 m
.0302 .73428 L
s
.0042 .71956 m
.00482 .71553 L
s
.3302 .96013 m
.33041 .95605 L
s
.34837 .97354 m
.34856 .96946 L
s
.36617 .98667 m
.36635 .9826 L
s
.38362 .99955 m
.38377 .99547 L
s
.25 Mabswid
.07192 .25073 m
0 .71646 L
s
.06052 .32456 m
.06684 .32207 L
s
[(-1)] .04788 .32955 1 -0.39468 Mshowa
.03862 .46641 m
.045 .46406 L
s
[(0)] .02586 .4711 1 -0.36754 Mshowa
.01453 .62235 m
.02097 .62018 L
s
[(1)] .00165 .6267 1 -0.33741 Mshowa
.125 Mabswid
.0563 .3519 m
.0601 .35042 L
s
.052 .37973 m
.05581 .37827 L
s
.04762 .40809 m
.05144 .40664 L
s
.04316 .43697 m
.04698 .43555 L
s
.03398 .4964 m
.03782 .49501 L
s
.02926 .52698 m
.0331 .52561 L
s
.02445 .55815 m
.0283 .5568 L
s
.01954 .58993 m
.0234 .58861 L
s
.06467 .29772 m
.06845 .29621 L
s
.06874 .27135 m
.07252 .26982 L
s
.00943 .65542 m
.0133 .65414 L
s
.00422 .68916 m
.0081 .6879 L
s
.25 Mabswid
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.5 Mabswid
.786 .442 .405 r
.44491 .44907 m .36477 .52184 L .55473 .57484 L closepath p F P
0 g
s
.37 .395 .757 r
.44491 .44907 m .55473 .57484 L .52308 .38117 L closepath p F P
0 g
s
0 0 0 r
.44491 .44907 m .52308 .38117 L .36477 .52184 L closepath p F P
0 g
s
.366 .042 .277 r
.39521 .65616 m .44391 .71565 L .55473 .57484 L closepath p F P
0 g
s
.702 .725 .868 r
.39521 .65616 m .55473 .57484 L .36477 .52184 L closepath p F P
0 g
s
0 0 .535 r
.39521 .65616 m .36477 .52184 L .44391 .71565 L closepath p F P
0 g
s
.299 .033 .331 r
.65615 .42467 m .55473 .57484 L .70544 .48388 L closepath p F P
0 g
s
.859 .738 .729 r
.65615 .42467 m .52308 .38117 L .55473 .57484 L closepath p F P
0 g
s
.641 .082 0 r
.65615 .42467 m .70544 .48388 L .52308 .38117 L closepath p F P
0 g
s
.873 .707 .674 r
.57791 .76621 m .55473 .57484 L .44391 .71565 L closepath p F P
0 g
s
.311 .298 .683 r
.57791 .76621 m .65788 .69455 L .55473 .57484 L closepath p F P
0 g
s
.6 .813 .982 r
.57791 .76621 m .44391 .71565 L .65788 .69455 L closepath p F P
0 g
s
.721 .348 .342 r
.74263 .62049 m .55473 .57484 L .65788 .69455 L closepath p F P
0 g
s
.643 .687 .876 r
.74263 .62049 m .70544 .48388 L .55473 .57484 L closepath p F P
0 g
s
.971 .845 .659 r
.74263 .62049 m .65788 .69455 L .70544 .48388 L closepath p F P
0 g
s
.698 .565 .701 r
.33115 .32429 m .36477 .52184 L .52308 .38117 L closepath p F P
0 g
s
0 0 .52 r
.33115 .32429 m .38251 .38653 L .36477 .52184 L closepath p F P
0 g
s
.608 .076 0 r
.33115 .32429 m .52308 .38117 L .38251 .38653 L closepath p F P
0 g
s
.706 .538 .659 r
.24235 .68284 m .44391 .71565 L .36477 .52184 L closepath p F P
0 g
s
0 0 0 r
.24235 .68284 m .36477 .52184 L .32852 .60768 L closepath p F P
0 g
s
.817 .41 .277 r
.19481 .46702 m .32852 .60768 L .36477 .52184 L closepath p F P
0 g
s
.712 .79 .912 r
.19481 .46702 m .36477 .52184 L .38251 .38653 L closepath p F P
0 g
s
.654 .533 .704 r
.69731 .27878 m .52308 .38117 L .70544 .48388 L closepath p F P
0 g
s
0 0 0 r
.69731 .27878 m .60797 .35949 L .52308 .38117 L closepath p F P
0 g
s
.217 .339 .774 r
.48589 .20782 m .52308 .38117 L .60797 .35949 L closepath p F P
0 g
s
.899 .805 .747 r
.48589 .20782 m .38251 .38653 L .52308 .38117 L closepath p F P
0 g
s
.559 .729 .954 r
.24235 .68284 m .32852 .60768 L .44391 .71565 L closepath p F P
0 g
s
.927 .746 .637 r
.33664 .82736 m .44391 .71565 L .32852 .60768 L closepath p F P
0 g
s
.666 .487 .633 r
.56015 .87859 m .65788 .69455 L .44391 .71565 L closepath p F P
0 g
s
.079 .258 .746 r
.56015 .87859 m .44391 .71565 L .52308 .72469 L closepath p F P
0 g
s
.145 0 0 r
.33664 .82736 m .52308 .72469 L .44391 .71565 L closepath p F P
0 g
s
.952 .764 .613 r
.69731 .27878 m .70544 .48388 L .60797 .35949 L closepath p F P
0 g
s
.633 .483 .662 r
.85199 .62068 m .70544 .48388 L .65788 .69455 L closepath p F P
0 g
s
.804 .349 .159 r
.85199 .62068 m .69976 .56825 L .70544 .48388 L closepath p F P
0 g
s
0 0 .084 r
.82611 .39367 m .70544 .48388 L .69976 .56825 L closepath p F P
0 g
s
.593 .717 .93 r
.82611 .39367 m .60797 .35949 L .70544 .48388 L closepath p F P
0 g
s
.702 .816 .936 r
.85199 .62068 m .65788 .69455 L .69976 .56825 L closepath p F P
0 g
s
.92 .834 .744 r
.56015 .87859 m .52308 .72469 L .65788 .69455 L closepath p F P
0 g
s
.67 .196 .118 r
.73868 .79032 m .65788 .69455 L .52308 .72469 L closepath p F P
0 g
s
.065 .115 .604 r
.73868 .79032 m .69976 .56825 L .65788 .69455 L closepath p F P
0 g
s
.624 .472 .656 r
.19481 .46702 m .38251 .38653 L .32852 .60768 L closepath p F P
0 g
s
.661 .476 .624 r
.48589 .20782 m .60797 .35949 L .38251 .38653 L closepath p F P
0 g
s
.635 .791 .957 r
.45664 .27423 m .38251 .38653 L .60797 .35949 L closepath p F P
0 g
s
.22 .231 .659 r
.45664 .27423 m .48535 .50673 L .38251 .38653 L closepath p F P
0 g
s
.947 .817 .683 r
.25792 .45112 m .32852 .60768 L .38251 .38653 L closepath p F P
0 g
s
.707 .293 .259 r
.25792 .45112 m .38251 .38653 L .48535 .50673 L closepath p F P
0 g
s
.628 .699 .896 r
.25792 .45112 m .48535 .50673 L .32852 .60768 L closepath p F P
0 g
s
.648 .528 .703 r
.33664 .82736 m .32852 .60768 L .52308 .72469 L closepath p F P
0 g
s
.722 .218 .033 r
.35521 .69402 m .52308 .72469 L .32852 .60768 L closepath p F P
0 g
s
.184 0 .222 r
.35521 .69402 m .32852 .60768 L .48535 .50673 L closepath p F P
0 g
s
.705 .534 .654 r
.82611 .39367 m .69976 .56825 L .60797 .35949 L closepath p F P
0 g
s
.892 .722 .664 r
.45664 .27423 m .60797 .35949 L .48535 .50673 L closepath p F P
0 g
s
0 .115 .646 r
.68527 .40123 m .60797 .35949 L .69976 .56825 L closepath p F P
0 g
s
.266 0 .159 r
.68527 .40123 m .48535 .50673 L .60797 .35949 L closepath p F P
0 g
s
.697 .564 .701 r
.73868 .79032 m .52308 .72469 L .69976 .56825 L closepath p F P
0 g
s
0 0 0 r
.62474 .66693 m .69976 .56825 L .52308 .72469 L closepath p F P
0 g
s
.296 .351 .75 r
.62474 .66693 m .52308 .72469 L .48535 .50673 L closepath p F P
0 g
s
.876 .757 .728 r
.35521 .69402 m .48535 .50673 L .52308 .72469 L closepath p F P
0 g
s
.697 .742 .886 r
.68527 .40123 m .69976 .56825 L .48535 .50673 L closepath p F P
0 g
s
.786 .409 .341 r
.62474 .66693 m .48535 .50673 L .69976 .56825 L closepath p F P
0 g
s
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.07192 .25073 m
.68538 0 L
s
.20676 .19562 m
.21134 .20064 L
s
[(-1)] .19758 .1856 .91513 1 Mshowa
.36072 .1327 m
.36502 .13796 L
s
[(0)] .35212 .12216 .81613 1 Mshowa
.52432 .06583 m
.52828 .07135 L
s
[(1)] .5164 .05478 .71713 1 Mshowa
.125 Mabswid
.23682 .18334 m
.23954 .18638 L
s
.26724 .1709 m
.26993 .17397 L
s
.29803 .15832 m
.30068 .16142 L
s
.32918 .14559 m
.3318 .14871 L
s
.39264 .11965 m
.39518 .12284 L
s
.42495 .10644 m
.42746 .10966 L
s
.45767 .09307 m
.46013 .09632 L
s
.49079 .07954 m
.49321 .08282 L
s
.17704 .20777 m
.17983 .21075 L
s
.14768 .21977 m
.15049 .22272 L
s
.11865 .23163 m
.1215 .23455 L
s
.08996 .24336 m
.09284 .24625 L
s
.55828 .05195 m
.56061 .0553 L
s
.59266 .0379 m
.59495 .04127 L
s
.62749 .02366 m
.62973 .02707 L
s
.66276 .00925 m
.66495 .01268 L
s
.25 Mabswid
0 .71646 m
.38643 1.00162 L
s
.1023 .79195 m
.10312 .7852 L
s
[(-1)] .10066 .80545 .12152 -1 Mshowa
.21274 .87345 m
.21334 .86668 L
s
[(0)] .21156 .887 .08756 -1 Mshowa
.31164 .94644 m
.31204 .93965 L
s
[(1)] .31085 .96001 .05846 -1 Mshowa
.125 Mabswid
.12541 .809 m
.12587 .80495 L
s
.14799 .82567 m
.14842 .82161 L
s
.17006 .84196 m
.17047 .8379 L
s
.19164 .85788 m
.19202 .85382 L
s
.23339 .88869 m
.23372 .88462 L
s
.25359 .90359 m
.25389 .89953 L
s
.27335 .91818 m
.27363 .91411 L
s
.2927 .93246 m
.29296 .92839 L
s
.07864 .77449 m
.07917 .77045 L
s
.05442 .75662 m
.05498 .75258 L
s
.02962 .73832 m
.0302 .73428 L
s
.0042 .71956 m
.00482 .71553 L
s
.3302 .96013 m
.33041 .95605 L
s
.34837 .97354 m
.34856 .96946 L
s
.36617 .98667 m
.36635 .9826 L
s
.38362 .99955 m
.38377 .99547 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  "With this setting for ",
  StyleBox["PlotRange", "MR"],
  ", many parts of the stellated icosahedron lie outside the box, and are \
clipped. "
}], "MathCaption",
  CellTags->{"S2.10.10", "10.7"}],

Cell[CellGroupData[{

Cell["Show[%, PlotRange -> {-1, 1}]", "Input",
  CellLabel->"In[4]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .86483 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.13272e-16 1.04494 -0.0420079 1.04494 [
[.18003 .18983 -11.7199 -9 ]
[.18003 .18983 .28011 0 ]
[.34275 .12532 -5.54389 -9 ]
[.34275 .12532 .45611 0 ]
[.51599 .05668 -5.22784 -9 ]
[.51599 .05668 .77216 0 ]
[.77667 .1047 0 -6.16938 ]
[.77667 .1047 12 2.83062 ]
[.85286 .22295 0 -6.05704 ]
[.85286 .22295 6 2.94296 ]
[.9211 .32887 0 -5.95886 ]
[.9211 .32887 6 3.04114 ]
[.0351 .26005 -12 -2.72392 ]
[.0351 .26005 0 6.27608 ]
[.02405 .33108 -24 -2.78345 ]
[.02405 .33108 0 6.21655 ]
[.01248 .40548 -6 -2.84609 ]
[.01248 .40548 0 6.15391 ]
[.00035 .48349 -18 -2.91206 ]
[.00035 .48349 0 6.08794 ]
[-0.01238 .56537 -6 -2.98166 ]
[-0.01238 .56537 0 6.01834 ]
[ 0 0 0 0 ]
[ 1 .86483 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04725 .25525 m
.69397 0 L
s
.18904 .19929 m
.19355 .20401 L
s
[(-1)] .18003 .18983 .95331 1 Mshowa
.35119 .13529 m
.35542 .14027 L
s
[(0)] .34275 .12532 .84796 1 Mshowa
.52378 .06717 m
.52767 .07241 L
s
[(1)] .51599 .05668 .74261 1 Mshowa
.125 Mabswid
.22068 .1868 m
.22335 .18966 L
s
.25271 .17416 m
.25535 .17705 L
s
.28514 .16136 m
.28774 .16429 L
s
.31796 .1484 m
.32053 .15136 L
s
.38485 .12201 m
.38734 .12502 L
s
.41892 .10856 m
.42138 .11161 L
s
.45343 .09494 m
.45585 .09802 L
s
.48838 .08114 m
.49076 .08426 L
s
.15778 .21162 m
.16051 .21443 L
s
.12689 .22382 m
.12965 .22659 L
s
.09637 .23586 m
.09916 .23861 L
s
.06621 .24777 m
.06903 .25049 L
s
.55963 .05302 m
.56193 .0562 L
s
.59596 .03868 m
.59821 .04189 L
s
.63276 .02416 m
.63496 .0274 L
s
.67004 .00944 m
.6722 .01271 L
s
.25 Mabswid
.69397 0 m
.96022 .41283 L
s
.76443 .10925 m
.7583 .11152 L
s
[(-1)] .77667 .1047 -1 .37097 Mshowa
.84052 .22723 m
.83435 .22936 L
s
[(0)] .85286 .22295 -1 .34601 Mshowa
.90867 .3329 m
.90246 .33491 L
s
[(1)] .9211 .32887 -1 .32419 Mshowa
.125 Mabswid
.78034 .13393 m
.77666 .13528 L
s
.7959 .15805 m
.79221 .15938 L
s
.81111 .18163 m
.80742 .18294 L
s
.82598 .20468 m
.82228 .20598 L
s
.85474 .24928 m
.85103 .25055 L
s
.86866 .27086 m
.86495 .27211 L
s
.88228 .29198 m
.87856 .29322 L
s
.89562 .31266 m
.89189 .31388 L
s
.74813 .08398 m
.74446 .08536 L
s
.73145 .05812 m
.72779 .05952 L
s
.71436 .03163 m
.71071 .03304 L
s
.69686 .00449 m
.69321 .00593 L
s
.92146 .35273 m
.91773 .35392 L
s
.93398 .37215 m
.93025 .37333 L
s
.94626 .39117 m
.94252 .39234 L
s
.95828 .40982 m
.95454 .41098 L
s
.25 Mabswid
.04725 .25525 m
0 .56119 L
s
.04725 .25525 m
.05332 .25285 L
s
[(-1)] .0351 .26005 1 -0.39468 Mshowa
.03625 .32643 m
.04236 .3241 L
s
[(-0.5)] .02405 .33108 1 -0.38145 Mshowa
.02474 .40098 m
.03087 .39872 L
s
[(0)] .01248 .40548 1 -0.36754 Mshowa
.01267 .47914 m
.01883 .47697 L
s
[(0.5)] .00035 .48349 1 -0.35287 Mshowa
0 .56119 m
.00619 .5591 L
s
[(1)] -0.01238 .56537 1 -0.33741 Mshowa
.125 Mabswid
.04509 .26923 m
.04874 .2678 L
s
.04291 .28333 m
.04656 .28191 L
s
.04071 .29756 m
.04437 .29615 L
s
.03849 .31193 m
.04215 .31052 L
s
.03399 .34106 m
.03766 .33967 L
s
.03171 .35583 m
.03538 .35445 L
s
.02941 .37074 m
.03308 .36937 L
s
.02709 .38578 m
.03076 .38442 L
s
.02237 .41631 m
.02606 .41497 L
s
.01998 .43179 m
.02367 .43046 L
s
.01757 .44742 m
.02126 .4461 L
s
.01513 .4632 m
.01882 .46189 L
s
.01019 .49523 m
.01388 .49394 L
s
.00768 .51148 m
.01138 .51019 L
s
.00514 .52788 m
.00885 .52661 L
s
.00258 .54445 m
.00629 .54319 L
s
.25 Mabswid
.04725 .25525 m
0 .56119 L
s
0 .56119 m
.38528 .86483 L
s
.38528 .86483 m
.39563 .58673 L
s
.39563 .58673 m
.04725 .25525 L
s
.69397 0 m
.96022 .41283 L
s
.96022 .41283 m
1 .70677 L
s
1 .70677 m
.71344 .32047 L
s
.71344 .32047 m
.69397 0 L
s
.04725 .25525 m
0 .56119 L
s
0 .56119 m
.71344 .32047 L
s
.71344 .32047 m
.69397 0 L
s
.69397 0 m
.04725 .25525 L
s
.39563 .58673 m
.96022 .41283 L
s
.96022 .41283 m
1 .70677 L
s
1 .70677 m
.38528 .86483 L
s
.38528 .86483 m
.39563 .58673 L
s
0 0 m
1 0 L
1 .86483 L
0 .86483 L
closepath
clip
newpath
.5 Mabswid
.366 .042 .277 r
.3911 .59593 m .44113 .65704 L .55498 .51238 L closepath p F P
0 g
s
.702 .725 .868 r
.3911 .59593 m .55498 .51238 L .35982 .45793 L closepath p F P
0 g
s
0 0 .535 r
.3911 .59593 m .35982 .45793 L .44113 .65704 L closepath p F P
0 g
s
.786 .442 .405 r
.55498 .51238 m .4981 .44723 L .40197 .41966 L p F P
0 g
s
.37 .395 .757 r
.4981 .44723 m .55498 .51238 L .53146 .36844 L closepath p F P
0 g
s
.299 .033 .331 r
.70982 .41893 m .6838 .38767 L .60718 .4351 L p F P
0 g
s
.299 .033 .331 r
.60718 .4351 m .55498 .51238 L .70982 .41893 L p F P
0 g
s
.859 .738 .729 r
.53146 .36844 m .55498 .51238 L .60718 .4351 L closepath p F P
0 g
s
.873 .707 .674 r
.5788 .70899 m .55498 .51238 L .44113 .65704 L closepath p F P
0 g
s
.311 .298 .683 r
.5788 .70899 m .66096 .63537 L .55498 .51238 L closepath p F P
0 g
s
.6 .813 .982 r
.5788 .70899 m .44113 .65704 L .66096 .63537 L closepath p F P
0 g
s
.721 .348 .342 r
.74803 .55928 m .55498 .51238 L .66096 .63537 L closepath p F P
0 g
s
.643 .687 .876 r
.74803 .55928 m .70982 .41893 L .55498 .51238 L closepath p F P
0 g
s
.971 .845 .659 r
.74803 .55928 m .66096 .63537 L .70982 .41893 L closepath p F P
0 g
s
.786 .442 .405 r
.40197 .41966 m .35982 .45793 L .55498 .51238 L p F P
0 g
s
0 0 0 r
.47848 .35249 m .35982 .45793 L .40197 .41966 L closepath p F P
0 g
s
.641 .082 0 r
.6838 .38767 m .70982 .41893 L .57235 .3415 L closepath p F P
0 g
s
.698 .565 .701 r
.34272 .3574 m .35982 .45793 L .47848 .35249 L closepath p F P
0 g
s
0 0 .52 r
.35982 .45793 m .34272 .3574 L .35093 .28605 L p F P
0 g
s
0 0 .52 r
.35093 .28605 m .37804 .31892 L .35982 .45793 L p F P
0 g
s
.706 .538 .659 r
.23405 .62333 m .44113 .65704 L .35982 .45793 L closepath p F P
0 g
s
0 0 0 r
.23405 .62333 m .35982 .45793 L .32258 .54611 L closepath p F P
0 g
s
.817 .41 .277 r
.18521 .40161 m .32258 .54611 L .35982 .45793 L closepath p F P
0 g
s
.712 .79 .912 r
.18521 .40161 m .35982 .45793 L .37804 .31892 L closepath p F P
0 g
s
.654 .533 .704 r
.57235 .3415 m .70982 .41893 L .70569 .31464 L closepath p F P
0 g
s
.559 .729 .954 r
.23405 .62333 m .32258 .54611 L .44113 .65704 L closepath p F P
0 g
s
.927 .746 .637 r
.38852 .71183 m .44113 .65704 L .32258 .54611 L p F P
0 g
s
.666 .487 .633 r
.44113 .65704 m .49922 .73847 L .61178 .72798 L p F P
0 g
s
.666 .487 .633 r
.61178 .72798 m .66096 .63537 L .44113 .65704 L p F P
0 g
s
.079 .258 .746 r
.49922 .73847 m .44113 .65704 L .49904 .66365 L closepath p F P
0 g
s
.145 0 0 r
.49904 .66365 m .44113 .65704 L .38852 .71183 L closepath p F P
0 g
s
.608 .076 0 r
.4855 .31482 m .37804 .31892 L .35093 .28605 L closepath p F P
0 g
s
.899 .805 .747 r
.43109 .22722 m .37804 .31892 L .4855 .31482 L closepath p F P
0 g
s
.952 .764 .613 r
.60968 .29114 m .65666 .2487 L .70569 .31464 L p F P
0 g
s
.952 .764 .613 r
.70569 .31464 m .70982 .41893 L .60968 .29114 L p F P
0 g
s
.633 .483 .662 r
.86038 .55947 m .70982 .41893 L .66096 .63537 L closepath p F P
0 g
s
.804 .349 .159 r
.86038 .55947 m .70398 .50561 L .70982 .41893 L closepath p F P
0 g
s
0 0 .084 r
.83379 .32625 m .70982 .41893 L .70398 .50561 L closepath p F P
0 g
s
.593 .717 .93 r
.83379 .32625 m .60968 .29114 L .70982 .41893 L closepath p F P
0 g
s
0 0 0 r
.65666 .2487 m .60968 .29114 L .54456 .30776 L closepath p F P
0 g
s
.217 .339 .774 r
.54456 .30776 m .60968 .29114 L .54659 .21275 L closepath p F P
0 g
s
.702 .816 .936 r
.86038 .55947 m .66096 .63537 L .70398 .50561 L closepath p F P
0 g
s
.92 .834 .744 r
.56199 .65749 m .66096 .63537 L .61178 .72798 L closepath p F P
0 g
s
.67 .196 .118 r
.70034 .68205 m .66096 .63537 L .56199 .65749 L closepath p F P
0 g
s
.065 .115 .604 r
.66096 .63537 m .70034 .68205 L .72372 .61825 L p F P
0 g
s
.065 .115 .604 r
.72372 .61825 m .70398 .50561 L .66096 .63537 L p F P
0 g
s
.624 .472 .656 r
.18521 .40161 m .37804 .31892 L .32258 .54611 L closepath p F P
0 g
s
.927 .746 .637 r
.32258 .54611 m .3267 .65765 L .38852 .71183 L p F P
0 g
s
.661 .476 .624 r
.37804 .31892 m .43109 .22722 L .54659 .21275 L p F P
0 g
s
.661 .476 .624 r
.54659 .21275 m .60968 .29114 L .37804 .31892 L p F P
0 g
s
.635 .791 .957 r
.45421 .20354 m .37804 .31892 L .60968 .29114 L closepath p F P
0 g
s
.22 .231 .659 r
.45421 .20354 m .4837 .4424 L .37804 .31892 L closepath p F P
0 g
s
.947 .817 .683 r
.25005 .38527 m .32258 .54611 L .37804 .31892 L closepath p F P
0 g
s
.707 .293 .259 r
.25005 .38527 m .37804 .31892 L .4837 .4424 L closepath p F P
0 g
s
.628 .699 .896 r
.25005 .38527 m .4837 .4424 L .32258 .54611 L closepath p F P
0 g
s
.648 .528 .703 r
.3267 .65765 m .32258 .54611 L .4676 .63333 L closepath p F P
0 g
s
.722 .218 .033 r
.4676 .63333 m .32258 .54611 L .33553 .58799 L closepath p F P
0 g
s
.184 0 .222 r
.33553 .58799 m .32258 .54611 L .4837 .4424 L p F P
0 g
s
.705 .534 .654 r
.83379 .32625 m .70398 .50561 L .60968 .29114 L closepath p F P
0 g
s
.892 .722 .664 r
.45421 .20354 m .60968 .29114 L .4837 .4424 L closepath p F P
0 g
s
0 .115 .646 r
.68909 .33402 m .60968 .29114 L .70398 .50561 L closepath p F P
0 g
s
.266 0 .159 r
.68909 .33402 m .4837 .4424 L .60968 .29114 L closepath p F P
0 g
s
.697 .564 .701 r
.57145 .62296 m .70398 .50561 L .72372 .61825 L closepath p F P
0 g
s
0 0 0 r
.66747 .55363 m .70398 .50561 L .57145 .62296 L closepath p F P
0 g
s
.697 .742 .886 r
.68909 .33402 m .70398 .50561 L .4837 .4424 L closepath p F P
0 g
s
.786 .409 .341 r
.70398 .50561 m .66747 .55363 L .55281 .52183 L p F P
0 g
s
.786 .409 .341 r
.55281 .52183 m .4837 .4424 L .70398 .50561 L p F P
0 g
s
.296 .351 .75 r
.51228 .60745 m .4837 .4424 L .55281 .52183 L closepath p F P
0 g
s
.876 .757 .728 r
.41862 .53608 m .4837 .4424 L .51228 .60745 L closepath p F P
0 g
s
.184 0 .222 r
.4837 .4424 m .41862 .53608 L .33553 .58799 L p F P
0 g
s
.25 Mabswid
.69397 0 m
.96022 .41283 L
s
.96022 .41283 m
1 .70677 L
s
1 .70677 m
.71344 .32047 L
s
.71344 .32047 m
.69397 0 L
s
.04725 .25525 m
0 .56119 L
s
0 .56119 m
.71344 .32047 L
s
.71344 .32047 m
.69397 0 L
s
.69397 0 m
.04725 .25525 L
s
.04725 .25525 m
.69397 0 L
s
.18904 .19929 m
.19355 .20401 L
s
[(-1)] .18003 .18983 .95331 1 Mshowa
.35119 .13529 m
.35542 .14027 L
s
[(0)] .34275 .12532 .84796 1 Mshowa
.52378 .06717 m
.52767 .07241 L
s
[(1)] .51599 .05668 .74261 1 Mshowa
.125 Mabswid
.22068 .1868 m
.22335 .18966 L
s
.25271 .17416 m
.25535 .17705 L
s
.28514 .16136 m
.28774 .16429 L
s
.31796 .1484 m
.32053 .15136 L
s
.38485 .12201 m
.38734 .12502 L
s
.41892 .10856 m
.42138 .11161 L
s
.45343 .09494 m
.45585 .09802 L
s
.48838 .08114 m
.49076 .08426 L
s
.15778 .21162 m
.16051 .21443 L
s
.12689 .22382 m
.12965 .22659 L
s
.09637 .23586 m
.09916 .23861 L
s
.06621 .24777 m
.06903 .25049 L
s
.55963 .05302 m
.56193 .0562 L
s
.59596 .03868 m
.59821 .04189 L
s
.63276 .02416 m
.63496 .0274 L
s
.67004 .00944 m
.6722 .01271 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  "Much as in two dimensions, you can use either \
\[OpenCurlyDoubleQuote]original\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]scaled\[CloseCurlyDoubleQuote] coordinates to specify \
the positions of elements in three\[Hyphen]dimensional objects. Scaled \
coordinates, specified as ",
  StyleBox["Scaled[{", "MR"],
  StyleBox["sx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["sy", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["sz", "TI"],
  StyleBox["}]", "MR"],
  " are taken to run from 0 to 1 in each dimension. The coordinates are set \
up to define a right\[Hyphen]handed coordinate system on the box. "
}], "Text",
  CellTags->{"S2.10.10", "10.8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["{", "MR"],
              StyleBox["x", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["y", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["z", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["original coordinates "]},
          {Cell[TextData[{
              StyleBox["Scaled[{", "MR"],
              StyleBox["sx", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sy", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["sz", "TI"],
              StyleBox["}]", "MR"],
              " "
            }]], Cell[
            "scaled coordinates, running from 0 to 1 in each dimension "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.10"],

Cell["\<\
Coordinate systems for three\[Hyphen]dimensional objects. \
\>", \
"Caption",
  CellTags->"S2.10.10"],

Cell["This puts a cuboid in one corner of the box. ", "MathCaption",
  CellTags->{"S2.10.10", "10.9"}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics3D[{stel, Cuboid[Scaled[{0, 0, 0}], Scaled[{0.2, 0.2, \
0.2}]]}]]\
\>", "Input",
  CellLabel->"In[5]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00162 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0206914 1.08755 6.16911e-17 1.08755 [
[ 0 0 0 0 ]
[ 1 1.00162 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
.40217 .57872 m
.07192 .25073 L
s
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
.40217 .57872 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.38643 1.00162 L
s
.38643 1.00162 m
.40217 .57872 L
s
0 0 m
1 0 L
1 1.00162 L
0 1.00162 L
closepath
clip
newpath
.5 Mabswid
.786 .442 .405 r
.44491 .44907 m .36477 .52184 L .55473 .57484 L closepath p F P
0 g
s
.37 .395 .757 r
.44491 .44907 m .55473 .57484 L .52308 .38117 L closepath p F P
0 g
s
0 0 0 r
.44491 .44907 m .52308 .38117 L .36477 .52184 L closepath p F P
0 g
s
.366 .042 .277 r
.39521 .65616 m .44391 .71565 L .55473 .57484 L closepath p F P
0 g
s
.702 .725 .868 r
.39521 .65616 m .55473 .57484 L .36477 .52184 L closepath p F P
0 g
s
0 0 .535 r
.39521 .65616 m .36477 .52184 L .44391 .71565 L closepath p F P
0 g
s
.299 .033 .331 r
.65615 .42467 m .55473 .57484 L .70544 .48388 L closepath p F P
0 g
s
.859 .738 .729 r
.65615 .42467 m .52308 .38117 L .55473 .57484 L closepath p F P
0 g
s
.641 .082 0 r
.65615 .42467 m .70544 .48388 L .52308 .38117 L closepath p F P
0 g
s
.873 .707 .674 r
.57791 .76621 m .55473 .57484 L .44391 .71565 L closepath p F P
0 g
s
.311 .298 .683 r
.57791 .76621 m .65788 .69455 L .55473 .57484 L closepath p F P
0 g
s
.6 .813 .982 r
.57791 .76621 m .44391 .71565 L .65788 .69455 L closepath p F P
0 g
s
.721 .348 .342 r
.74263 .62049 m .55473 .57484 L .65788 .69455 L closepath p F P
0 g
s
.643 .687 .876 r
.74263 .62049 m .70544 .48388 L .55473 .57484 L closepath p F P
0 g
s
.971 .845 .659 r
.74263 .62049 m .65788 .69455 L .70544 .48388 L closepath p F P
0 g
s
.67 .731 .895 r
.25683 .28389 m .14784 .32613 L .07192 .25073 L p F P
0 g
s
.52 .29 .506 r
.24943 .36603 m .25683 .28389 L .14784 .32613 L p F P
0 g
s
.52 .29 .506 r
.14784 .32613 m .13763 .40762 L .24943 .36603 L p F P
0 g
s
.937 .684 .531 r
.07192 .25073 m .14784 .32613 L .13763 .40762 L p F P
0 g
s
.698 .565 .701 r
.33115 .32429 m .36477 .52184 L .52308 .38117 L closepath p F P
0 g
s
0 0 .52 r
.33115 .32429 m .38251 .38653 L .36477 .52184 L closepath p F P
0 g
s
.608 .076 0 r
.33115 .32429 m .52308 .38117 L .38251 .38653 L closepath p F P
0 g
s
.706 .538 .659 r
.24235 .68284 m .44391 .71565 L .36477 .52184 L closepath p F P
0 g
s
0 0 0 r
.24235 .68284 m .36477 .52184 L .32852 .60768 L closepath p F P
0 g
s
.817 .41 .277 r
.19481 .46702 m .32852 .60768 L .36477 .52184 L closepath p F P
0 g
s
.712 .79 .912 r
.19481 .46702 m .36477 .52184 L .38251 .38653 L closepath p F P
0 g
s
.654 .533 .704 r
.69731 .27878 m .52308 .38117 L .70544 .48388 L closepath p F P
0 g
s
0 0 0 r
.69731 .27878 m .60797 .35949 L .52308 .38117 L closepath p F P
0 g
s
.217 .339 .774 r
.48589 .20782 m .52308 .38117 L .60797 .35949 L closepath p F P
0 g
s
.899 .805 .747 r
.48589 .20782 m .38251 .38653 L .52308 .38117 L closepath p F P
0 g
s
.67 .731 .895 r
.07192 .25073 m .18353 .20512 L .25683 .28389 L p F P
0 g
s
.949 .687 .505 r
.18353 .20512 m .25683 .28389 L .24943 .36603 L p F P
0 g
s
.937 .684 .531 r
.13763 .40762 m .05917 .33334 L .07192 .25073 L p F P
0 g
s
.665 .739 .905 r
.24943 .36603 m .13763 .40762 L .05917 .33334 L p F P
0 g
s
.559 .729 .954 r
.24235 .68284 m .32852 .60768 L .44391 .71565 L closepath p F P
0 g
s
.927 .746 .637 r
.33664 .82736 m .44391 .71565 L .32852 .60768 L closepath p F P
0 g
s
.666 .487 .633 r
.56015 .87859 m .65788 .69455 L .44391 .71565 L closepath p F P
0 g
s
.079 .258 .746 r
.56015 .87859 m .44391 .71565 L .52308 .72469 L closepath p F P
0 g
s
.145 0 0 r
.33664 .82736 m .52308 .72469 L .44391 .71565 L closepath p F P
0 g
s
.952 .764 .613 r
.69731 .27878 m .70544 .48388 L .60797 .35949 L closepath p F P
0 g
s
.633 .483 .662 r
.85199 .62068 m .70544 .48388 L .65788 .69455 L closepath p F P
0 g
s
.804 .349 .159 r
.85199 .62068 m .69976 .56825 L .70544 .48388 L closepath p F P
0 g
s
0 0 .084 r
.82611 .39367 m .70544 .48388 L .69976 .56825 L closepath p F P
0 g
s
.593 .717 .93 r
.82611 .39367 m .60797 .35949 L .70544 .48388 L closepath p F P
0 g
s
.5 .262 .485 r
.1737 .28833 m .18353 .20512 L .07192 .25073 L p F P
0 g
s
.5 .262 .485 r
.07192 .25073 m .05917 .33334 L .1737 .28833 L p F P
0 g
s
.702 .816 .936 r
.85199 .62068 m .65788 .69455 L .69976 .56825 L closepath p F P
0 g
s
.92 .834 .744 r
.56015 .87859 m .52308 .72469 L .65788 .69455 L closepath p F P
0 g
s
.67 .196 .118 r
.73868 .79032 m .65788 .69455 L .52308 .72469 L closepath p F P
0 g
s
.065 .115 .604 r
.73868 .79032 m .69976 .56825 L .65788 .69455 L closepath p F P
0 g
s
.665 .739 .905 r
.05917 .33334 m .1737 .28833 L .24943 .36603 L p F P
0 g
s
.949 .687 .505 r
.24943 .36603 m .1737 .28833 L .18353 .20512 L p F P
0 g
s
.624 .472 .656 r
.19481 .46702 m .38251 .38653 L .32852 .60768 L closepath p F P
0 g
s
.661 .476 .624 r
.48589 .20782 m .60797 .35949 L .38251 .38653 L closepath p F P
0 g
s
.635 .791 .957 r
.45664 .27423 m .38251 .38653 L .60797 .35949 L closepath p F P
0 g
s
.22 .231 .659 r
.45664 .27423 m .48535 .50673 L .38251 .38653 L closepath p F P
0 g
s
.947 .817 .683 r
.25792 .45112 m .32852 .60768 L .38251 .38653 L closepath p F P
0 g
s
.707 .293 .259 r
.25792 .45112 m .38251 .38653 L .48535 .50673 L closepath p F P
0 g
s
.628 .699 .896 r
.25792 .45112 m .48535 .50673 L .32852 .60768 L closepath p F P
0 g
s
.648 .528 .703 r
.33664 .82736 m .32852 .60768 L .52308 .72469 L closepath p F P
0 g
s
.722 .218 .033 r
.35521 .69402 m .52308 .72469 L .32852 .60768 L closepath p F P
0 g
s
.184 0 .222 r
.35521 .69402 m .32852 .60768 L .48535 .50673 L closepath p F P
0 g
s
.705 .534 .654 r
.82611 .39367 m .69976 .56825 L .60797 .35949 L closepath p F P
0 g
s
.892 .722 .664 r
.45664 .27423 m .60797 .35949 L .48535 .50673 L closepath p F P
0 g
s
0 .115 .646 r
.68527 .40123 m .60797 .35949 L .69976 .56825 L closepath p F P
0 g
s
.266 0 .159 r
.68527 .40123 m .48535 .50673 L .60797 .35949 L closepath p F P
0 g
s
.697 .564 .701 r
.73868 .79032 m .52308 .72469 L .69976 .56825 L closepath p F P
0 g
s
0 0 0 r
.62474 .66693 m .69976 .56825 L .52308 .72469 L closepath p F P
0 g
s
.296 .351 .75 r
.62474 .66693 m .52308 .72469 L .48535 .50673 L closepath p F P
0 g
s
.876 .757 .728 r
.35521 .69402 m .48535 .50673 L .52308 .72469 L closepath p F P
0 g
s
.697 .742 .886 r
.68527 .40123 m .69976 .56825 L .48535 .50673 L closepath p F P
0 g
s
.786 .409 .341 r
.62474 .66693 m .48535 .50673 L .69976 .56825 L closepath p F P
0 g
s
.25 Mabswid
.68538 0 m
.93948 .40631 L
s
.93948 .40631 m
1 .85355 L
s
1 .85355 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.07192 .25073 m
0 .71646 L
s
0 .71646 m
.71506 .4883 L
s
.71506 .4883 m
.68538 0 L
s
.68538 0 m
.07192 .25073 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  "Once you have specified where various graphical elements go inside a three\
\[Hyphen]dimensional box, you must then tell ",
  StyleBox["Mathematica", "TI"],
  " how to draw the box. The first step is to specify what shape the box \
should be. This is analogous to specifying the aspect ratio of a \
two\[Hyphen]dimensional plot. In three dimensions, you can use the option ",
  StyleBox["BoxRatios", "MR"],
  " to specify the ratio of side lengths for the box. For ",
  StyleBox["Graphics3D", "MR"],
  " objects, the default is ",
  StyleBox["BoxRatios", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ", specifying that the shape of the box should be determined from the \
ranges of actual coordinates for its contents. "
}], "Text",
  CellTags->{"S2.10.10", "10.10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["BoxRatios", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{", "MR"],
              StyleBox["xr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["yr", "TI"],
              StyleBox[",", "MR"],
              " ",
              StyleBox["zr", "TI"],
              StyleBox["}", "MR"],
              " "
            }]], Cell["specify the ratio of side lengths for the box "]},
          {Cell[TextData[{
              StyleBox["BoxRatios", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["Automatic", "MR"],
              " "
            }]], Cell[TextData[{
              
              "determine the ratio of side lengths from the range of actual \
coordinates (default for ",
              StyleBox["Graphics3D", "MR"],
              ") "
            }]]},
          {Cell[TextData[{
              StyleBox["BoxRatios", "MR"],
              " ",
              StyleBox["->", "MR"],
              " ",
              StyleBox["{1,", "MR"],
              " ",
              StyleBox["1,", "MR"],
              " ",
              StyleBox["0.4}", "MR"],
              " "
            }]], Cell[TextData[{
              "specify a fixed shape of box (default for ",
              StyleBox["SurfaceGraphics", "MR"],
              ") "
            }]]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.10"],

Cell["\<\
Specifying the shape of the bounding box for \
three\[Hyphen]dimensional objects. \
\>", "Caption",
  CellTags->"S2.10.10"],

Cell["This displays the stellated icosahedron in a tall box. ", "MathCaption",
  CellTags->{"S2.10.10", "10.11"}],

Cell[CellGroupData[{

Cell["Show[Graphics3D[stel], BoxRatios -> {1, 1, 5}]", "Input",
  CellLabel->"In[6]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 3.26435 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.21672 3.44396 -0.17961 3.44396 [
[ 0 0 0 0 ]
[ 1 3.26435 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08189 .20834 m
0 2.95686 L
s
0 2.95686 m
.36171 3.26435 L
s
.36171 3.26435 m
.38411 .57076 L
s
.38411 .57076 m
.08189 .20834 L
s
.63384 0 m
.92122 .37789 L
s
.92122 .37789 m
1 3.10126 L
s
1 3.10126 m
.65935 2.77808 L
s
.65935 2.77808 m
.63384 0 L
s
.08189 .20834 m
0 2.95686 L
s
0 2.95686 m
.65935 2.77808 L
s
.65935 2.77808 m
.63384 0 L
s
.63384 0 m
.08189 .20834 L
s
.38411 .57076 m
.92122 .37789 L
s
.92122 .37789 m
1 3.10126 L
s
1 3.10126 m
.36171 3.26435 L
s
.36171 3.26435 m
.38411 .57076 L
s
0 0 m
1 0 L
1 3.26435 L
0 3.26435 L
closepath
clip
newpath
.5 Mabswid
.805 .526 .515 r
.4299 .46215 m .34932 1.15023 L .54129 1.2102 L closepath p F P
0 g
s
0 0 .456 r
.4299 .46215 m .54129 1.2102 L .50526 .58191 L closepath p F P
0 g
s
.214 .017 .383 r
.4299 .46215 m .50526 .58191 L .34932 1.15023 L closepath p F P
0 g
s
.376 .178 .48 r
.64079 .43837 m .54129 1.2102 L .68434 1.11518 L closepath p F P
0 g
s
.926 .684 .554 r
.64079 .43837 m .50526 .58191 L .54129 1.2102 L closepath p F P
0 g
s
.839 .529 .465 r
.64079 .43837 m .68434 1.11518 L .50526 .58191 L closepath p F P
0 g
s
.689 .468 .582 r
.32093 .32917 m .34932 1.15023 L .50526 .58191 L closepath p F P
0 g
s
0 0 .222 r
.32093 .32917 m .37056 1.01557 L .34932 1.15023 L closepath p F P
0 g
s
.773 .476 .484 r
.32093 .32917 m .50526 .58191 L .37056 1.01557 L closepath p F P
0 g
s
.624 .417 .581 r
.66709 .28953 m .50526 .58191 L .68434 1.11518 L closepath p F P
0 g
s
.967 .704 .482 r
.66709 .28953 m .68434 1.11518 L .58055 .99327 L closepath p F P
0 g
s
.416 .182 .448 r
.66709 .28953 m .58055 .99327 L .50526 .58191 L closepath p F P
0 g
s
0 0 .225 r
.46734 .2202 m .50526 .58191 L .58055 .99327 L closepath p F P
0 g
s
.985 .758 .512 r
.46734 .2202 m .37056 1.01557 L .50526 .58191 L closepath p F P
0 g
s
.651 .42 .556 r
.46734 .2202 m .58055 .99327 L .37056 1.01557 L closepath p F P
0 g
s
.473 .249 .492 r
.37682 1.41819 m .42732 2.11089 L .54129 1.2102 L closepath p F P
0 g
s
.774 .66 .737 r
.37682 1.41819 m .54129 1.2102 L .34932 1.15023 L closepath p F P
0 g
s
.76 .482 .513 r
.73666 1.3817 m .54129 1.2102 L .64544 2.09059 L closepath p F P
0 g
s
.564 .513 .756 r
.73666 1.3817 m .68434 1.11518 L .54129 1.2102 L closepath p F P
0 g
s
.915 .659 .537 r
.5706 2.04024 m .54129 1.2102 L .42732 2.11089 L closepath p F P
0 g
s
0 0 .44 r
.5706 2.04024 m .64544 2.09059 L .54129 1.2102 L closepath p F P
0 g
s
.701 .468 .568 r
.22088 1.94134 m .42732 2.11089 L .34932 1.15023 L closepath p F P
0 g
s
.186 .015 .402 r
.22088 1.94134 m .34932 1.15023 L .31453 1.99736 L closepath p F P
0 g
s
.851 .558 .492 r
.18795 1.21249 m .31453 1.99736 L .34932 1.15023 L closepath p F P
0 g
s
.763 .567 0 r
.37682 1.41819 m .34932 1.15023 L .40339 1.81621 L p F P
0 g
s
.894 .945 .834 r
.18795 1.21249 m .34932 1.15023 L .37056 1.01557 L closepath p F P
0 g
s
.599 .384 .561 r
.18795 1.21249 m .37056 1.01557 L .31453 1.99736 L closepath p F P
0 g
s
.995 .758 .455 r
.25646 1.71513 m .31453 1.99736 L .35459 1.29541 L p F P
0 g
s
.995 .758 .455 r
.35459 1.29541 m .37056 1.01557 L .34377 1.17986 L p F P
0 g
s
.995 .758 .455 r
.34377 1.17986 m .25646 1.71513 L p .35459 1.29541 L F P
0 g
s
.763 .567 0 r
.40339 1.81621 m .42732 2.11089 L .41439 1.93358 L p F P
0 g
s
.763 .567 0 r
.41439 1.93358 m .37682 1.41819 L p .40339 1.81621 L F P
0 g
s
.995 .757 .434 r
.66876 1.90937 m .64544 2.09059 L .65736 1.79168 L p F P
0 g
s
.995 .757 .434 r
.68434 1.11518 m .73666 1.3817 L .66876 1.90937 L p F P
0 g
s
.995 .757 .434 r
.65736 1.79168 m .68434 1.11518 L p .66876 1.90937 L F P
0 g
s
.602 .39 .566 r
.83292 1.883 m .68434 1.11518 L .64544 2.09059 L closepath p F P
0 g
s
.713 .526 0 r
.67273 1.9635 m .64462 1.67709 L .59557 1.1536 L p F P
0 g
s
.713 .526 0 r
.59557 1.1536 m .58055 .99327 L .60679 1.26945 L p F P
0 g
s
.713 .526 0 r
.60679 1.26945 m .67273 1.9635 L p .59557 1.1536 L F P
0 g
s
.854 .556 .483 r
.83292 1.883 m .67273 1.9635 L .68434 1.11518 L closepath p F P
0 g
s
.213 .042 .421 r
.78467 1.15037 m .68434 1.11518 L .67273 1.9635 L closepath p F P
0 g
s
0 .323 .804 r
.78467 1.15037 m .58055 .99327 L .68434 1.11518 L closepath p F P
0 g
s
0 0 .416 r
.43944 1.04083 m .46601 1.90425 L .37056 1.01557 L closepath p F P
0 g
s
.199 0 0 r
.43944 1.04083 m .37056 1.01557 L .58055 .99327 L closepath p F P
0 g
s
.76 .479 .506 r
.25646 1.71513 m .37056 1.01557 L .46601 1.90425 L closepath p F P
0 g
s
.7 .465 .564 r
.78467 1.15037 m .67273 1.9635 L .58055 .99327 L closepath p F P
0 g
s
.919 .66 .529 r
.43944 1.04083 m .58055 .99327 L .46601 1.90425 L closepath p F P
0 g
s
.464 .236 .483 r
.64462 1.67709 m .46601 1.90425 L .58055 .99327 L closepath p F P
0 g
s
.348 0 0 r
.5706 2.04024 m .42732 2.11089 L .64544 2.09059 L closepath p F P
0 g
s
0 .191 .684 r
.22088 1.94134 m .31453 1.99736 L .42732 2.11089 L closepath p F P
0 g
s
.89 .978 .82 r
.83292 1.883 m .64544 2.09059 L .67273 1.9635 L closepath p F P
0 g
s
.963 .703 .495 r
.31663 3.00275 m .42732 2.11089 L .31453 1.99736 L closepath p F P
0 g
s
.653 .424 .56 r
.54879 3.05983 m .64544 2.09059 L .42732 2.11089 L closepath p F P
0 g
s
0 0 .169 r
.54879 3.05983 m .42732 2.11089 L .50526 2.63826 L closepath p F P
0 g
s
.43 .199 .461 r
.31663 3.00275 m .50526 2.63826 L .42732 2.11089 L closepath p F P
0 g
s
.989 .759 .495 r
.54879 3.05983 m .50526 2.63826 L .64544 2.09059 L closepath p F P
0 g
s
.772 .48 .492 r
.72207 2.96931 m .64544 2.09059 L .50526 2.63826 L closepath p F P
0 g
s
0 0 .264 r
.72207 2.96931 m .67273 1.9635 L .64544 2.09059 L closepath p F P
0 g
s
.546 .504 .76 r
.25646 1.71513 m .46601 1.90425 L .31453 1.99736 L closepath p F P
0 g
s
.621 .412 .577 r
.31663 3.00275 m .31453 1.99736 L .50526 2.63826 L closepath p F P
0 g
s
.836 .532 .475 r
.34179 2.87398 m .50526 2.63826 L .31453 1.99736 L closepath p F P
0 g
s
.361 .162 .469 r
.34179 2.87398 m .31453 1.99736 L .46601 1.90425 L closepath p F P
0 g
s
.78 .667 .739 r
.64462 1.67709 m .67273 1.9635 L .46601 1.90425 L closepath p F P
0 g
s
.688 .465 .578 r
.72207 2.96931 m .50526 2.63826 L .67273 1.9635 L closepath p F P
0 g
s
.242 .047 .404 r
.59668 2.85256 m .67273 1.9635 L .50526 2.63826 L closepath p F P
0 g
s
.807 .523 .508 r
.59668 2.85256 m .46601 1.90425 L .67273 1.9635 L closepath p F P
0 g
s
0 0 .429 r
.59668 2.85256 m .50526 2.63826 L .46601 1.90425 L closepath p F P
0 g
s
.931 .686 .545 r
.34179 2.87398 m .46601 1.90425 L .50526 2.63826 L closepath p F P
0 g
s
.25 Mabswid
.63384 0 m
.92122 .37789 L
s
.92122 .37789 m
1 3.10126 L
s
1 3.10126 m
.65935 2.77808 L
s
.65935 2.77808 m
.63384 0 L
s
.08189 .20834 m
0 2.95686 L
s
0 2.95686 m
.65935 2.77808 L
s
.65935 2.77808 m
.63384 0 L
s
.63384 0 m
.08189 .20834 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  "To produce an image of a three\[Hyphen]dimensional object, you have to \
tell ",
  StyleBox["Mathematica", "TI"],
  " from what view point you want to look at the object. You can do this \
using the option ",
  StyleBox["ViewPoint", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.10", "10.12"}],

Cell[TextData[{
  "Some common settings for this option were given in Section\
\[NonBreakingSpace]",
  ButtonBox["1.9.6",
    ButtonData:>{"1.9.6", "6.10"},
    ButtonStyle->"MainBookLink"],
  ". In general, however, you can tell ",
  StyleBox["Mathematica", "TI"],
  " to use any view point, so long as it lies outside the box. "
}], "Text",
  CellTags->{"S2.10.10", "10.13"}],

Cell[TextData[{
  "View points are specified in the form ",
  StyleBox["ViewPoint", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{", "MR"],
  StyleBox["sx", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["sy", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["sz", "TI"],
  StyleBox["}", "MR"],
  ". The values ",
  StyleBox["si", "TI"],
  " are given in a special coordinate system, in which the center of the box \
is ",
  StyleBox["{0,", "MR"],
  " ",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["0}", "MR"],
  ". The special coordinates are scaled so that the longest side of the box \
corresponds to one unit. The lengths of the other sides of the box in this \
coordinate system are determined by the setting for the ",
  StyleBox["BoxRatios", "MR"],
  " option. For a cubical box, therefore, each of the special coordinates \
runs from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)/2\)], "InlineFormula"],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`1/2\)], "InlineFormula"],
  " across the box. Note that the view point must always lie outside the box. \
"
}], "Text",
  CellTags->{"S2.10.10", "10.14"}],

Cell[TextData[{
  "This generates a picture using the default view point ",
  StyleBox["{1.3,", "MR"],
  " ",
  StyleBox["-2.4,", "MR"],
  " ",
  StyleBox["2}", "MR"],
  ". "
}], "MathCaption",
  CellTags->{"S2.10.10", "10.15"}],

Cell[CellGroupData[{

Cell["\<\
surf = Plot3D[(2 + Sin[x]) Cos[2 y], {x, -2, 2}, {y, -3, 3}, \
AxesLabel -> {\"x\", \"y\", \"z\"}]\
\>", "Input",
  CellLabel->"In[7]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.78351e-17 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.29165 .07573 -9.31117 -9.8125 ]
[.29165 .07573 .68883 0 ]
[.75679 .08071 0 -6.17777 ]
[.75679 .08071 12 2.82223 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9429 .3657 0 -5.9083 ]
[.9429 .3657 6 3.0917 ]
[.91861 .21225 0 -6.57576 ]
[.91861 .21225 10.0625 3.23674 ]
[.01868 .29919 -12 -2.77111 ]
[.01868 .29919 0 6.22889 ]
[.00705 .37208 -6 -2.83292 ]
[.00705 .37208 0 6.16708 ]
[-0.00514 .44847 -6 -2.89799 ]
[-0.00514 .44847 0 6.10201 ]
[-0.05457 .39542 -10 -3.08918 ]
[-0.05457 .39542 0 6.72332 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -70.3112 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.7445 .0853 m
.73835 .08759 L
s
[(-2)] .75679 .08071 -1 .37284 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.93037 .36962 m
.92411 .37158 L
s
[(2)] .9429 .3657 -1 .31296 Mshowa
.125 Mabswid
.7708 .12553 m
.7671 .12688 L
s
.79613 .16428 m
.79242 .1656 L
s
.82054 .20161 m
.81682 .20291 L
s
.86679 .27235 m
.86305 .2736 L
s
.88871 .30589 m
.88497 .30711 L
s
.9099 .3383 m
.90615 .3395 L
s
.71716 .04348 m
.71349 .04489 L
s
.95018 .39992 m
.94642 .40107 L
s
gsave
.91861 .21225 -61 -10.5758 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03093 .29448 m
.03705 .29213 L
s
[(-2)] .01868 .29919 1 -0.3842 Mshowa
.01935 .36752 m
.0255 .36524 L
s
[(0)] .00705 .37208 1 -0.37046 Mshowa
.00722 .44406 m
.0134 .44186 L
s
[(2)] -0.00514 .44847 1 -0.356 Mshowa
.125 Mabswid
.02808 .31242 m
.03176 .31102 L
s
.02521 .33058 m
.02889 .32919 L
s
.02229 .34894 m
.02598 .34756 L
s
.01637 .38632 m
.02007 .38496 L
s
.01336 .40534 m
.01706 .40399 L
s
.01031 .42459 m
.01401 .42325 L
s
.03374 .27674 m
.03741 .27532 L
s
.03652 .2592 m
.04018 .25777 L
s
.0041 .46378 m
.00781 .46247 L
s
.00093 .48373 m
.00465 .48244 L
s
gsave
-0.05457 .39542 -71 -7.08918 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.665 .642 .818 r
.38753 .71632 .40046 .73714 .42271 .72915 .40983 .70871 Metetra
.659 .644 .824 r
.40983 .70871 .42271 .72915 .44511 .72199 .43229 .70169 Metetra
.651 .643 .829 r
.43229 .70169 .44511 .72199 .46767 .7157 .45491 .6953 Metetra
.643 .64 .832 r
.45491 .6953 .46767 .7157 .4904 .71028 .47771 .68953 Metetra
.635 .635 .833 r
.47771 .68953 .4904 .71028 .51334 .70571 .50071 .68438 Metetra
.627 .627 .831 r
.50071 .68438 .51334 .70571 .53649 .70196 .52392 .67982 Metetra
.62 .618 .827 r
.52392 .67982 .53649 .70196 .55988 .69896 .54735 .67579 Metetra
.614 .608 .821 r
.54735 .67579 .55988 .69896 .58353 .69662 .57103 .67224 Metetra
.609 .597 .814 r
.57103 .67224 .58353 .69662 .60746 .69484 .59496 .66907 Metetra
.605 .586 .805 r
.59496 .66907 .60746 .69484 .63166 .6935 .61916 .66621 Metetra
.603 .576 .796 r
.61916 .66621 .63166 .6935 .65616 .69246 .64363 .66355 Metetra
.602 .567 .787 r
.64363 .66355 .65616 .69246 .68097 .69157 .66837 .66098 Metetra
.602 .558 .778 r
.66837 .66098 .68097 .69157 .70607 .69066 .6934 .65838 Metetra
.603 .551 .769 r
.6934 .65838 .70607 .69066 .73146 .68958 .7187 .65563 Metetra
.604 .545 .761 r
.7187 .65563 .73146 .68958 .75714 .68817 .74427 .65261 Metetra
.606 .54 .754 r
.74427 .65261 .75714 .68817 .7831 .68627 .7701 .64922 Metetra
.609 .537 .748 r
.7701 .64922 .7831 .68627 .80932 .68374 .79619 .64534 Metetra
.612 .535 .743 r
.79619 .64534 .80932 .68374 .83577 .68044 .82251 .64088 Metetra
.616 .533 .738 r
.82251 .64088 .83577 .68044 .86243 .67626 .84906 .63576 Metetra
.62 .533 .735 r
.84906 .63576 .86243 .67626 .88929 .67111 .87581 .62991 Metetra
.624 .534 .732 r
.87581 .62991 .88929 .67111 .91631 .66494 .90275 .6233 Metetra
.628 .536 .731 r
.90275 .6233 .91631 .66494 .94348 .6577 .92987 .61589 Metetra
.632 .538 .73 r
.92987 .61589 .94348 .6577 .97077 .64939 .95714 .60767 Metetra
.637 .542 .73 r
.95714 .60767 .97077 .64939 .99816 .64003 .98456 .59867 Metetra
.646 .588 .776 r
.37474 .68879 .38753 .71632 .40983 .70871 .39704 .68187 Metetra
.645 .593 .781 r
.39704 .68187 .40983 .70871 .43229 .70169 .41951 .67516 Metetra
.643 .594 .785 r
.41951 .67516 .43229 .70169 .45491 .6953 .44215 .66866 Metetra
.64 .593 .786 r
.44215 .66866 .45491 .6953 .47771 .68953 .46499 .66238 Metetra
.637 .59 .784 r
.46499 .66238 .47771 .68953 .50071 .68438 .48801 .65632 Metetra
.634 .584 .78 r
.48801 .65632 .50071 .68438 .52392 .67982 .51124 .65045 Metetra
.631 .575 .774 r
.51124 .65045 .52392 .67982 .54735 .67579 .53468 .64475 Metetra
.628 .566 .766 r
.53468 .64475 .54735 .67579 .57103 .67224 .55833 .63922 Metetra
.624 .556 .757 r
.55833 .63922 .57103 .67224 .59496 .66907 .58221 .6338 Metetra
.621 .546 .748 r
.58221 .6338 .59496 .66907 .61916 .66621 .60632 .62846 Metetra
.619 .535 .738 r
.60632 .62846 .61916 .66621 .64363 .66355 .63066 .62316 Metetra
.617 .526 .729 r
.63066 .62316 .64363 .66355 .66837 .66098 .65524 .61785 Metetra
.615 .518 .72 r
.65524 .61785 .66837 .66098 .6934 .65838 .68006 .6125 Metetra
.614 .51 .713 r
.68006 .6125 .6934 .65838 .7187 .65563 .70512 .60704 Metetra
.612 .504 .706 r
.70512 .60704 .7187 .65563 .74427 .65261 .73042 .60144 Metetra
.612 .498 .7 r
.73042 .60144 .74427 .65261 .7701 .64922 .75596 .59565 Metetra
.611 .494 .695 r
.75596 .59565 .7701 .64922 .79619 .64534 .78174 .58963 Metetra
.611 .49 .69 r
.78174 .58963 .79619 .64534 .82251 .64088 .80775 .58333 Metetra
.612 .488 .687 r
.80775 .58333 .82251 .64088 .84906 .63576 .83399 .57674 Metetra
.612 .486 .684 r
.83399 .57674 .84906 .63576 .87581 .62991 .86046 .56982 Metetra
.613 .485 .683 r
.86046 .56982 .87581 .62991 .90275 .6233 .88714 .56256 Metetra
.614 .485 .682 r
.88714 .56256 .90275 .6233 .92987 .61589 .91405 .55494 Metetra
.615 .486 .682 r
.91405 .55494 .92987 .61589 .95714 .60767 .94116 .54696 Metetra
.617 .488 .682 r
.94116 .54696 .95714 .60767 .98456 .59867 .96849 .53864 Metetra
.634 .569 .764 r
.362 .65849 .37474 .68879 .39704 .68187 .38426 .65239 Metetra
.637 .575 .768 r
.38426 .65239 .39704 .68187 .41951 .67516 .40672 .64604 Metetra
.639 .579 .771 r
.40672 .64604 .41951 .67516 .44215 .66866 .42938 .63944 Metetra
.641 .58 .771 r
.42938 .63944 .44215 .66866 .46499 .66238 .45223 .63258 Metetra
.642 .578 .768 r
.45223 .63258 .46499 .66238 .48801 .65632 .47528 .62547 Metetra
.642 .574 .763 r
.47528 .62547 .48801 .65632 .51124 .65045 .49851 .61812 Metetra
.642 .567 .756 r
.49851 .61812 .51124 .65045 .53468 .64475 .52194 .61053 Metetra
.64 .559 .747 r
.52194 .61053 .53468 .64475 .55833 .63922 .54557 .60273 Metetra
.639 .55 .738 r
.54557 .60273 .55833 .63922 .58221 .6338 .56938 .59474 Metetra
.636 .54 .729 r
.56938 .59474 .58221 .6338 .60632 .62846 .59338 .58659 Metetra
.634 .531 .72 r
.59338 .58659 .60632 .62846 .63066 .62316 .61757 .57831 Metetra
.631 .522 .711 r
.61757 .57831 .63066 .62316 .65524 .61785 .64195 .56993 Metetra
.628 .513 .704 r
.64195 .56993 .65524 .61785 .68006 .6125 .66654 .56148 Metetra
.625 .505 .696 r
.66654 .56148 .68006 .6125 .70512 .60704 .69132 .55299 Metetra
.622 .498 .69 r
.69132 .55299 .70512 .60704 .73042 .60144 .7163 .54451 Metetra
.62 .492 .685 r
.7163 .54451 .73042 .60144 .75596 .59565 .7415 .53605 Metetra
.618 .486 .68 r
.7415 .53605 .75596 .59565 .78174 .58963 .76692 .52765 Metetra
.615 .482 .676 r
.76692 .52765 .78174 .58963 .80775 .58333 .79256 .51933 Metetra
.614 .478 .673 r
.79256 .51933 .80775 .58333 .83399 .57674 .81844 .51111 Metetra
.612 .475 .671 r
.81844 .51111 .83399 .57674 .86046 .56982 .84456 .50302 Metetra
.611 .473 .67 r
.84456 .50302 .86046 .56982 .88714 .56256 .87093 .49505 Metetra
.61 .472 .669 r
.87093 .49505 .88714 .56256 .91405 .55494 .89756 .48722 Metetra
.609 .472 .669 r
.89756 .48722 .91405 .55494 .94116 .54696 .92446 .47952 Metetra
.608 .472 .67 r
.92446 .47952 .94116 .54696 .96849 .53864 .95164 .47196 Metetra
.628 .576 .776 r
.3491 .62996 .362 .65849 .38426 .65239 .37133 .62457 Metetra
.635 .584 .78 r
.37133 .62457 .38426 .65239 .40672 .64604 .39379 .61853 Metetra
.641 .59 .781 r
.39379 .61853 .40672 .64604 .42938 .63944 .41647 .61183 Metetra
.647 .593 .78 r
.41647 .61183 .42938 .63944 .45223 .63258 .43936 .60444 Metetra
.652 .593 .776 r
.43936 .60444 .45223 .63258 .47528 .62547 .46244 .59639 Metetra
.655 .59 .77 r
.46244 .59639 .47528 .62547 .49851 .61812 .48571 .5877 Metetra
.657 .585 .763 r
.48571 .5877 .49851 .61812 .52194 .61053 .50916 .57843 Metetra
.658 .578 .754 r
.50916 .57843 .52194 .61053 .54557 .60273 .53278 .56862 Metetra
.657 .57 .745 r
.53278 .56862 .54557 .60273 .56938 .59474 .55656 .55836 Metetra
.655 .561 .736 r
.55656 .55836 .56938 .59474 .59338 .58659 .5805 .54774 Metetra
.653 .551 .727 r
.5805 .54774 .59338 .58659 .61757 .57831 .60459 .53683 Metetra
.65 .542 .719 r
.60459 .53683 .61757 .57831 .64195 .56993 .62884 .52575 Metetra
.646 .533 .711 r
.62884 .52575 .64195 .56993 .66654 .56148 .65324 .5146 Metetra
.642 .524 .704 r
.65324 .5146 .66654 .56148 .69132 .55299 .67781 .50348 Metetra
.638 .516 .698 r
.67781 .50348 .69132 .55299 .7163 .54451 .70255 .4925 Metetra
.634 .509 .693 r
.70255 .4925 .7163 .54451 .7415 .53605 .72748 .48173 Metetra
.63 .502 .688 r
.72748 .48173 .7415 .53605 .76692 .52765 .75261 .47128 Metetra
.626 .496 .685 r
.75261 .47128 .76692 .52765 .79256 .51933 .77796 .46121 Metetra
.622 .491 .682 r
.77796 .46121 .79256 .51933 .81844 .51111 .80354 .45159 Metetra
.619 .487 .68 r
.80354 .45159 .81844 .51111 .84456 .50302 .82938 .44248 Metetra
.616 .484 .679 r
.82938 .44248 .84456 .50302 .87093 .49505 .85549 .43389 Metetra
.613 .482 .678 r
.85549 .43389 .87093 .49505 .89756 .48722 .8819 .42586 Metetra
.61 .48 .679 r
.8819 .42586 .89756 .48722 .92446 .47952 .90863 .41838 Metetra
.607 .479 .68 r
.90863 .41838 .92446 .47952 .95164 .47196 .93569 .41145 Metetra
.628 .616 .819 r
.3358 .60717 .3491 .62996 .37133 .62457 .35805 .60219 Metetra
.639 .626 .821 r
.35805 .60219 .37133 .62457 .39379 .61853 .38055 .59631 Metetra
.649 .632 .82 r
.38055 .59631 .39379 .61853 .41647 .61183 .40328 .58949 Metetra
.659 .636 .816 r
.40328 .58949 .41647 .61183 .43936 .60444 .42623 .58173 Metetra
.667 .638 .811 r
.42623 .58173 .43936 .60444 .46244 .59639 .44939 .57304 Metetra
.674 .637 .805 r
.44939 .57304 .46244 .59639 .48571 .5877 .47274 .56347 Metetra
.679 .633 .797 r
.47274 .56347 .48571 .5877 .50916 .57843 .49626 .55308 Metetra
.682 .628 .789 r
.49626 .55308 .50916 .57843 .53278 .56862 .51994 .54196 Metetra
.683 .621 .78 r
.51994 .54196 .53278 .56862 .55656 .55836 .54376 .53022 Metetra
.683 .613 .771 r
.54376 .53022 .55656 .55836 .5805 .54774 .56772 .51799 Metetra
.681 .604 .763 r
.56772 .51799 .5805 .54774 .60459 .53683 .59182 .50539 Metetra
.679 .595 .755 r
.59182 .50539 .60459 .53683 .62884 .52575 .61605 .49258 Metetra
.675 .586 .748 r
.61605 .49258 .62884 .52575 .65324 .5146 .64041 .47969 Metetra
.671 .577 .741 r
.64041 .47969 .65324 .5146 .67781 .50348 .66491 .46688 Metetra
.666 .568 .736 r
.66491 .46688 .67781 .50348 .70255 .4925 .68957 .45429 Metetra
.66 .56 .731 r
.68957 .45429 .70255 .4925 .72748 .48173 .7144 .44204 Metetra
.655 .552 .727 r
.7144 .44204 .72748 .48173 .75261 .47128 .73941 .43027 Metetra
.649 .545 .724 r
.73941 .43027 .75261 .47128 .77796 .46121 .76464 .41907 Metetra
.643 .539 .721 r
.76464 .41907 .77796 .46121 .80354 .45159 .7901 .40854 Metetra
.637 .533 .72 r
.7901 .40854 .80354 .45159 .82938 .44248 .81583 .39874 Metetra
.631 .528 .719 r
.81583 .39874 .82938 .44248 .85549 .43389 .84184 .38973 Metetra
.626 .524 .719 r
.84184 .38973 .85549 .43389 .8819 .42586 .86818 .38152 Metetra
.62 .521 .72 r
.86818 .38152 .8819 .42586 .90863 .41838 .89485 .37413 Metetra
.615 .519 .722 r
.89485 .37413 .90863 .41838 .93569 .41145 .92189 .36752 Metetra
.627 .709 .905 r
.32187 .59263 .3358 .60717 .35805 .60219 .34421 .58765 Metetra
.643 .716 .901 r
.34421 .58765 .35805 .60219 .38055 .59631 .36681 .58172 Metetra
.658 .721 .895 r
.36681 .58172 .38055 .59631 .40328 .58949 .38965 .57479 Metetra
.672 .725 .889 r
.38965 .57479 .40328 .58949 .42623 .58173 .41272 .56686 Metetra
.684 .728 .883 r
.41272 .56686 .42623 .58173 .44939 .57304 .436 .55796 Metetra
.695 .729 .877 r
.436 .55796 .44939 .57304 .47274 .56347 .45947 .54812 Metetra
.705 .73 .87 r
.45947 .54812 .47274 .56347 .49626 .55308 .48312 .53741 Metetra
.712 .73 .864 r
.48312 .53741 .49626 .55308 .51994 .54196 .50693 .52594 Metetra
.718 .729 .859 r
.50693 .52594 .51994 .54196 .54376 .53022 .53089 .51381 Metetra
.722 .727 .854 r
.53089 .51381 .54376 .53022 .56772 .51799 .55499 .50116 Metetra
.724 .724 .85 r
.55499 .50116 .56772 .51799 .59182 .50539 .57921 .48813 Metetra
.724 .721 .847 r
.57921 .48813 .59182 .50539 .61605 .49258 .60357 .47487 Metetra
.723 .717 .844 r
.60357 .47487 .61605 .49258 .64041 .47969 .62806 .46154 Metetra
.721 .713 .842 r
.62806 .46154 .64041 .47969 .66491 .46688 .65269 .4483 Metetra
.717 .708 .841 r
.65269 .4483 .66491 .46688 .68957 .45429 .67747 .43528 Metetra
.711 .704 .841 r
.67747 .43528 .68957 .45429 .7144 .44204 .70241 .42264 Metetra
.705 .699 .841 r
.70241 .42264 .7144 .44204 .73941 .43027 .72754 .4105 Metetra
.697 .693 .843 r
.72754 .4105 .73941 .43027 .76464 .41907 .75289 .39898 Metetra
.688 .688 .844 r
.75289 .39898 .76464 .41907 .7901 .40854 .77846 .38816 Metetra
.679 .682 .846 r
.77846 .38816 .7901 .40854 .81583 .39874 .80431 .37812 Metetra
.669 .677 .849 r
.80431 .37812 .81583 .39874 .84184 .38973 .83044 .36891 Metetra
.658 .672 .852 r
.83044 .36891 .84184 .38973 .86818 .38152 .8569 .36056 Metetra
.647 .667 .855 r
.8569 .36056 .86818 .38152 .89485 .37413 .8837 .35306 Metetra
.636 .662 .858 r
.8837 .35306 .89485 .37413 .92189 .36752 .91088 .34641 Metetra
.569 .848 .997 r
.30716 .58692 .32187 .59263 .34421 .58765 .32967 .58149 Metetra
.6 .851 .992 r
.32967 .58149 .34421 .58765 .36681 .58172 .35244 .57528 Metetra
.625 .854 .986 r
.35244 .57528 .36681 .58172 .38965 .57479 .37544 .56824 Metetra
.646 .858 .98 r
.37544 .56824 .38965 .57479 .41272 .56686 .39868 .56038 Metetra
.663 .865 .976 r
.39868 .56038 .41272 .56686 .436 .55796 .42213 .5517 Metetra
.677 .873 .973 r
.42213 .5517 .436 .55796 .45947 .54812 .44578 .54225 Metetra
.688 .884 .971 r
.44578 .54225 .45947 .54812 .48312 .53741 .46961 .53208 Metetra
.695 .897 .97 r
.46961 .53208 .48312 .53741 .50693 .52594 .49363 .52126 Metetra
.699 .911 .969 r
.49363 .52126 .50693 .52594 .53089 .51381 .51781 .5099 Metetra
.697 .925 .967 r
.51781 .5099 .53089 .51381 .55499 .50116 .54214 .49809 Metetra
.69 .939 .964 r
.54214 .49809 .55499 .50116 .57921 .48813 .56662 .48596 Metetra
.674 .949 .957 r
.56662 .48596 .57921 .48813 .60357 .47487 .59126 .47362 Metetra
.649 .954 .943 r
.59126 .47362 .60357 .47487 .62806 .46154 .61604 .46121 Metetra
.613 .951 .922 r
.61604 .46121 .62806 .46154 .65269 .4483 .64098 .44885 Metetra
.566 .937 .892 r
.64098 .44885 .65269 .4483 .67747 .43528 .66609 .43666 Metetra
.51 .913 .854 r
.66609 .43666 .67747 .43528 .70241 .42264 .69138 .42476 Metetra
.446 .878 .808 r
.69138 .42476 .70241 .42264 .72754 .4105 .71687 .41326 Metetra
.379 .836 .759 r
.71687 .41326 .72754 .4105 .75289 .39898 .74257 .40224 Metetra
.314 .792 .711 r
.74257 .40224 .75289 .39898 .77846 .38816 .76851 .39179 Metetra
.254 .748 .668 r
.76851 .39179 .77846 .38816 .80431 .37812 .79472 .38197 Metetra
.79472 .38197 .80431 .37812 .83044 .36891 .82121 .37281 Metetra
.82121 .37281 .83044 .36891 .8569 .36056 .84801 .36434 Metetra
.84801 .36434 .8569 .36056 .8837 .35306 .87514 .35656 Metetra
.87514 .35656 .8837 .35306 .91088 .34641 .90264 .34945 Metetra
.34 .82 .846 r
.29165 .58849 .30716 .58692 .32967 .58149 .31441 .58225 Metetra
.401 .854 .889 r
.31441 .58225 .32967 .58149 .35244 .57528 .3374 .57557 Metetra
.442 .874 .912 r
.3374 .57557 .35244 .57528 .37544 .56824 .36062 .56842 Metetra
.464 .885 .918 r
.36062 .56842 .37544 .56824 .39868 .56038 .38406 .56081 Metetra
.47 .889 .911 r
.38406 .56081 .39868 .56038 .42213 .5517 .40771 .55273 Metetra
.457 .885 .89 r
.40771 .55273 .42213 .5517 .44578 .54225 .43158 .54422 Metetra
.425 .87 .851 r
.43158 .54422 .44578 .54225 .46961 .53208 .45564 .5353 Metetra
.371 .836 .789 r
.45564 .5353 .46961 .53208 .49363 .52126 .47991 .526 Metetra
.296 .779 .699 r
.47991 .526 .49363 .52126 .51781 .5099 .50436 .51638 Metetra
.50436 .51638 .51781 .5099 .54214 .49809 .52901 .50649 Metetra
.52901 .50649 .54214 .49809 .56662 .48596 .55384 .49639 Metetra
.55384 .49639 .56662 .48596 .59126 .47362 .57886 .48615 Metetra
.074 0 0 r
.57886 .48615 .59126 .47362 .61604 .46121 .60408 .47582 Metetra
.143 0 0 r
.60408 .47582 .61604 .46121 .64098 .44885 .62948 .46549 Metetra
.2 0 0 r
.62948 .46549 .64098 .44885 .66609 .43666 .65509 .45521 Metetra
.244 0 .013 r
.65509 .45521 .66609 .43666 .69138 .42476 .68091 .44505 Metetra
.28 0 .061 r
.68091 .44505 .69138 .42476 .71687 .41326 .70695 .43505 Metetra
.307 0 .098 r
.70695 .43505 .71687 .41326 .74257 .40224 .73322 .42528 Metetra
.329 0 .126 r
.73322 .42528 .74257 .40224 .76851 .39179 .75974 .41578 Metetra
.346 0 .146 r
.75974 .41578 .76851 .39179 .79472 .38197 .78651 .40656 Metetra
.358 0 .159 r
.78651 .40656 .79472 .38197 .82121 .37281 .81356 .39767 Metetra
.367 0 .166 r
.81356 .39767 .82121 .37281 .84801 .36434 .8409 .38911 Metetra
.372 0 .168 r
.8409 .38911 .84801 .36434 .87514 .35656 .86855 .38087 Metetra
.375 0 .164 r
.86855 .38087 .87514 .35656 .90264 .34945 .89651 .37296 Metetra
.27547 .59402 .29165 .58849 .31441 .58225 .29853 .58675 Metetra
.237 .745 .705 r
.29853 .58675 .31441 .58225 .3374 .57557 .32179 .57948 Metetra
.26 .764 .734 r
.32179 .57948 .3374 .57557 .36062 .56842 .34525 .57222 Metetra
.258 .762 .734 r
.34525 .57222 .36062 .56842 .38406 .56081 .36891 .56496 Metetra
.23 .741 .705 r
.36891 .56496 .38406 .56081 .40771 .55273 .39278 .55771 Metetra
.39278 .55771 .40771 .55273 .43158 .54422 .41687 .55046 Metetra
.41687 .55046 .43158 .54422 .45564 .5353 .44118 .54319 Metetra
.44118 .54319 .45564 .5353 .47991 .526 .46571 .53592 Metetra
.069 0 0 r
.46571 .53592 .47991 .526 .50436 .51638 .49047 .52862 Metetra
.15 0 0 r
.49047 .52862 .50436 .51638 .52901 .50649 .51546 .52128 Metetra
.217 0 0 r
.51546 .52128 .52901 .50649 .55384 .49639 .54068 .5139 Metetra
.271 0 0 r
.54068 .5139 .55384 .49639 .57886 .48615 .56614 .50646 Metetra
.313 0 .06 r
.56614 .50646 .57886 .48615 .60408 .47582 .59185 .49895 Metetra
.345 0 .117 r
.59185 .49895 .60408 .47582 .62948 .46549 .6178 .49136 Metetra
.369 0 .161 r
.6178 .49136 .62948 .46549 .65509 .45521 .644 .48367 Metetra
.387 .01 .196 r
.644 .48367 .65509 .45521 .68091 .44505 .67046 .47587 Metetra
.401 .034 .223 r
.67046 .47587 .68091 .44505 .70695 .43505 .69716 .46795 Metetra
.411 .053 .243 r
.69716 .46795 .70695 .43505 .73322 .42528 .72412 .4599 Metetra
.419 .067 .258 r
.72412 .4599 .73322 .42528 .75974 .41578 .75134 .45171 Metetra
.424 .076 .269 r
.75134 .45171 .75974 .41578 .78651 .40656 .77882 .44338 Metetra
.427 .082 .276 r
.77882 .44338 .78651 .40656 .81356 .39767 .80656 .43489 Metetra
.428 .084 .279 r
.80656 .43489 .81356 .39767 .8409 .38911 .83457 .42625 Metetra
.427 .083 .278 r
.83457 .42625 .8409 .38911 .86855 .38087 .86283 .41745 Metetra
.424 .079 .274 r
.86283 .41745 .86855 .38087 .89651 .37296 .89137 .4085 Metetra
.285 .776 .721 r
.2589 .59902 .27547 .59402 .29853 .58675 .28226 .59072 Metetra
.302 .792 .759 r
.28226 .59072 .29853 .58675 .32179 .57948 .30579 .58287 Metetra
.295 .79 .771 r
.30579 .58287 .32179 .57948 .34525 .57222 .32949 .5755 Metetra
.265 .77 .757 r
.32949 .5755 .34525 .57222 .36891 .56496 .35338 .56859 Metetra
.211 .73 .716 r
.35338 .56859 .36891 .56496 .39278 .55771 .37747 .56215 Metetra
.37747 .56215 .39278 .55771 .41687 .55046 .40177 .55614 Metetra
.40177 .55614 .41687 .55046 .44118 .54319 .4263 .55053 Metetra
.051 0 0 r
.4263 .55053 .44118 .54319 .46571 .53592 .45108 .54527 Metetra
.141 0 0 r
.45108 .54527 .46571 .53592 .49047 .52862 .47612 .54029 Metetra
.218 0 0 r
.47612 .54029 .49047 .52862 .51546 .52128 .50144 .53552 Metetra
.278 0 0 r
.50144 .53552 .51546 .52128 .54068 .5139 .52703 .53088 Metetra
.324 0 0 r
.52703 .53088 .54068 .5139 .56614 .50646 .55292 .52628 Metetra
.358 0 .065 r
.55292 .52628 .56614 .50646 .59185 .49895 .5791 .52163 Metetra
.382 0 .118 r
.5791 .52163 .59185 .49895 .6178 .49136 .60558 .51683 Metetra
.399 0 .159 r
.60558 .51683 .6178 .49136 .644 .48367 .63236 .51179 Metetra
.411 .024 .191 r
.63236 .51179 .644 .48367 .67046 .47587 .65944 .50642 Metetra
.419 .043 .216 r
.65944 .50642 .67046 .47587 .69716 .46795 .68681 .50064 Metetra
.424 .056 .235 r
.68681 .50064 .69716 .46795 .72412 .4599 .71447 .49437 Metetra
.426 .066 .248 r
.71447 .49437 .72412 .4599 .75134 .45171 .7424 .48755 Metetra
.426 .071 .257 r
.7424 .48755 .75134 .45171 .77882 .44338 .77059 .48013 Metetra
.424 .072 .263 r
.77059 .48013 .77882 .44338 .80656 .43489 .79903 .47207 Metetra
.42 .071 .265 r
.79903 .47207 .80656 .43489 .83457 .42625 .82771 .46335 Metetra
.414 .066 .263 r
.82771 .46335 .83457 .42625 .86283 .41745 .85662 .45398 Metetra
.407 .058 .258 r
.85662 .45398 .86283 .41745 .89137 .4085 .88574 .44395 Metetra
.551 .918 .946 r
.2423 .59892 .2589 .59902 .28226 .59072 .26594 .58984 Metetra
.535 .907 .956 r
.26594 .58984 .28226 .59072 .30579 .58287 .2897 .58153 Metetra
.507 .893 .957 r
.2897 .58153 .30579 .58287 .32949 .5755 .31362 .57403 Metetra
.467 .875 .951 r
.31362 .57403 .32949 .5755 .35338 .56859 .3377 .56735 Metetra
.412 .85 .932 r
.3377 .56735 .35338 .56859 .37747 .56215 .36197 .56147 Metetra
.341 .815 .897 r
.36197 .56147 .37747 .56215 .40177 .55614 .38646 .55635 Metetra
.253 .764 .838 r
.38646 .55635 .40177 .55614 .4263 .55053 .41119 .55193 Metetra
.152 .694 .753 r
.41119 .55193 .4263 .55053 .45108 .54527 .43618 .54813 Metetra
.43618 .54813 .45108 .54527 .47612 .54029 .46145 .54484 Metetra
.054 0 0 r
.46145 .54484 .47612 .54029 .50144 .53552 .48702 .54195 Metetra
.14 0 0 r
.48702 .54195 .50144 .53552 .52703 .53088 .51291 .53933 Metetra
.209 0 0 r
.51291 .53933 .52703 .53088 .55292 .52628 .53913 .53682 Metetra
.26 0 0 r
.53913 .53682 .55292 .52628 .5791 .52163 .56569 .53428 Metetra
.297 0 0 r
.56569 .53428 .5791 .52163 .60558 .51683 .5926 .53156 Metetra
.322 0 0 r
.5926 .53156 .60558 .51683 .63236 .51179 .61984 .52849 Metetra
.338 0 0 r
.61984 .52849 .63236 .51179 .65944 .50642 .64742 .52493 Metetra
.347 0 .025 r
.64742 .52493 .65944 .50642 .68681 .50064 .67533 .52074 Metetra
.351 0 .052 r
.67533 .52074 .68681 .50064 .71447 .49437 .70354 .51579 Metetra
.35 0 .072 r
.70354 .51579 .71447 .49437 .7424 .48755 .73204 .50998 Metetra
.345 0 .084 r
.73204 .50998 .7424 .48755 .77059 .48013 .76082 .50322 Metetra
.336 0 .09 r
.76082 .50322 .77059 .48013 .79903 .47207 .78984 .49545 Metetra
.324 0 .09 r
.78984 .49545 .79903 .47207 .82771 .46335 .81909 .48664 Metetra
.309 0 .085 r
.81909 .48664 .82771 .46335 .85662 .45398 .84854 .47678 Metetra
.29 0 .073 r
.84854 .47678 .85662 .45398 .88574 .44395 .87817 .46589 Metetra
.682 .836 .957 r
.22605 .59027 .2423 .59892 .26594 .58984 .24987 .58081 Metetra
.663 .829 .963 r
.24987 .58081 .26594 .58984 .2897 .58153 .27381 .57225 Metetra
.641 .823 .97 r
.27381 .57225 .2897 .58153 .31362 .57403 .29789 .56462 Metetra
.617 .817 .977 r
.29789 .56462 .31362 .57403 .3377 .56735 .32212 .55795 Metetra
.59 .811 .984 r
.32212 .55795 .3377 .56735 .36197 .56147 .34655 .5522 Metetra
.561 .805 .99 r
.34655 .5522 .36197 .56147 .38646 .55635 .37118 .54733 Metetra
.529 .8 .995 r
.37118 .54733 .38646 .55635 .41119 .55193 .39605 .54327 Metetra
.496 .795 .998 r
.39605 .54327 .41119 .55193 .43618 .54813 .4212 .53994 Metetra
.461 .789 .999 r
.4212 .53994 .43618 .54813 .46145 .54484 .44663 .53721 Metetra
.427 .784 .996 r
.44663 .53721 .46145 .54484 .48702 .54195 .47238 .53494 Metetra
.394 .779 .99 r
.47238 .53494 .48702 .54195 .51291 .53933 .49846 .53299 Metetra
.363 .774 .981 r
.49846 .53299 .51291 .53933 .53913 .53682 .52489 .53119 Metetra
.337 .771 .969 r
.52489 .53119 .53913 .53682 .56569 .53428 .55167 .52937 Metetra
.317 .769 .956 r
.55167 .52937 .56569 .53428 .5926 .53156 .57882 .52734 Metetra
.304 .77 .942 r
.57882 .52734 .5926 .53156 .61984 .52849 .60634 .52493 Metetra
.299 .774 .928 r
.60634 .52493 .61984 .52849 .64742 .52493 .6342 .52197 Metetra
.302 .782 .917 r
.6342 .52197 .64742 .52493 .67533 .52074 .66241 .51829 Metetra
.313 .793 .908 r
.66241 .51829 .67533 .52074 .70354 .51579 .69095 .51376 Metetra
.332 .808 .902 r
.69095 .51376 .70354 .51579 .73204 .50998 .71978 .50824 Metetra
.357 .825 .899 r
.71978 .50824 .73204 .50998 .76082 .50322 .7489 .50163 Metetra
.389 .845 .9 r
.7489 .50163 .76082 .50322 .78984 .49545 .77827 .49387 Metetra
.424 .865 .903 r
.77827 .49387 .78984 .49545 .81909 .48664 .80786 .48492 Metetra
.463 .886 .909 r
.80786 .48492 .81909 .48664 .84854 .47678 .83766 .47477 Metetra
.503 .905 .916 r
.83766 .47477 .84854 .47678 .87817 .46589 .86763 .46343 Metetra
.675 .699 .865 r
.21038 .57167 .22605 .59027 .24987 .58081 .23428 .56232 Metetra
.665 .699 .872 r
.23428 .56232 .24987 .58081 .27381 .57225 .25832 .55375 Metetra
.653 .697 .878 r
.25832 .55375 .27381 .57225 .29789 .56462 .28249 .546 Metetra
.64 .693 .883 r
.28249 .546 .29789 .56462 .32212 .55795 .30684 .53907 Metetra
.627 .687 .886 r
.30684 .53907 .32212 .55795 .34655 .5522 .33137 .53294 Metetra
.614 .679 .888 r
.33137 .53294 .34655 .5522 .37118 .54733 .35611 .52758 Metetra
.602 .67 .888 r
.35611 .52758 .37118 .54733 .39605 .54327 .3811 .52292 Metetra
.592 .661 .886 r
.3811 .52292 .39605 .54327 .4212 .53994 .40635 .51887 Metetra
.583 .651 .883 r
.40635 .51887 .4212 .53994 .44663 .53721 .43188 .51535 Metetra
.577 .642 .878 r
.43188 .51535 .44663 .53721 .47238 .53494 .45772 .51222 Metetra
.574 .633 .872 r
.45772 .51222 .47238 .53494 .49846 .53299 .48388 .50936 Metetra
.572 .625 .866 r
.48388 .50936 .49846 .53299 .52489 .53119 .51039 .50661 Metetra
.573 .618 .859 r
.51039 .50661 .52489 .53119 .55167 .52937 .53724 .50383 Metetra
.576 .612 .851 r
.53724 .50383 .55167 .52937 .57882 .52734 .56444 .50085 Metetra
.581 .608 .844 r
.56444 .50085 .57882 .52734 .60634 .52493 .59201 .49752 Metetra
.587 .605 .837 r
.59201 .49752 .60634 .52493 .6342 .52197 .61991 .4937 Metetra
.594 .604 .831 r
.61991 .4937 .6342 .52197 .66241 .51829 .64816 .48923 Metetra
.602 .603 .825 r
.64816 .48923 .66241 .51829 .69095 .51376 .67674 .484 Metetra
.611 .604 .82 r
.67674 .484 .69095 .51376 .71978 .50824 .70562 .4779 Metetra
.619 .606 .815 r
.70562 .4779 .71978 .50824 .7489 .50163 .73479 .47083 Metetra
.628 .609 .811 r
.73479 .47083 .7489 .50163 .77827 .49387 .76422 .46274 Metetra
.637 .613 .809 r
.76422 .46274 .77827 .49387 .80786 .48492 .79389 .45359 Metetra
.646 .617 .806 r
.79389 .45359 .80786 .48492 .83766 .47477 .82379 .44337 Metetra
.654 .622 .805 r
.82379 .44337 .83766 .47477 .86763 .46343 .85388 .43212 Metetra
.65 .616 .802 r
.19532 .54427 .21038 .57167 .23428 .56232 .21921 .53546 Metetra
.646 .619 .808 r
.21921 .53546 .23428 .56232 .25832 .55375 .24326 .5271 Metetra
.641 .62 .813 r
.24326 .5271 .25832 .55375 .28249 .546 .26749 .51921 Metetra
.635 .617 .815 r
.26749 .51921 .28249 .546 .30684 .53907 .2919 .5118 Metetra
.629 .612 .814 r
.2919 .5118 .30684 .53907 .33137 .53294 .31651 .50485 Metetra
.623 .604 .811 r
.31651 .50485 .33137 .53294 .35611 .52758 .34134 .49833 Metetra
.616 .595 .806 r
.34134 .49833 .35611 .52758 .3811 .52292 .36641 .49222 Metetra
.611 .584 .798 r
.36641 .49222 .3811 .52292 .40635 .51887 .39173 .48645 Metetra
.606 .572 .79 r
.39173 .48645 .40635 .51887 .43188 .51535 .41733 .48096 Metetra
.602 .56 .78 r
.41733 .48096 .43188 .51535 .45772 .51222 .4432 .47568 Metetra
.598 .548 .77 r
.4432 .47568 .45772 .51222 .48388 .50936 .46937 .47053 Metetra
.596 .537 .759 r
.46937 .47053 .48388 .50936 .51039 .50661 .49585 .4654 Metetra
.595 .528 .749 r
.49585 .4654 .51039 .50661 .53724 .50383 .52264 .46022 Metetra
.594 .519 .74 r
.52264 .46022 .53724 .50383 .56444 .50085 .54975 .45488 Metetra
.594 .512 .732 r
.54975 .45488 .56444 .50085 .59201 .49752 .57718 .44929 Metetra
.594 .506 .724 r
.57718 .44929 .59201 .49752 .61991 .4937 .60494 .44335 Metetra
.595 .501 .718 r
.60494 .44335 .61991 .4937 .64816 .48923 .63301 .43699 Metetra
.597 .498 .712 r
.63301 .43699 .64816 .48923 .67674 .484 .66138 .43013 Metetra
.599 .496 .708 r
.66138 .43013 .67674 .484 .70562 .4779 .69006 .42269 Metetra
.601 .494 .705 r
.69006 .42269 .70562 .4779 .73479 .47083 .71903 .41464 Metetra
.604 .494 .702 r
.71903 .41464 .73479 .47083 .76422 .46274 .74828 .40593 Metetra
.607 .496 .701 r
.74828 .40593 .76422 .46274 .79389 .45359 .77779 .39654 Metetra
.61 .498 .701 r
.77779 .39654 .79389 .45359 .82379 .44337 .80755 .38647 Metetra
.614 .501 .701 r
.80755 .38647 .82379 .44337 .85388 .43212 .83756 .37573 Metetra
.632 .576 .773 r
.18067 .5114 .19532 .54427 .21921 .53546 .20448 .50338 Metetra
.633 .582 .779 r
.20448 .50338 .21921 .53546 .24326 .5271 .2285 .49536 Metetra
.633 .584 .782 r
.2285 .49536 .24326 .5271 .26749 .51921 .25273 .48733 Metetra
.632 .584 .782 r
.25273 .48733 .26749 .51921 .2919 .5118 .27719 .4793 Metetra
.631 .581 .78 r
.27719 .4793 .2919 .5118 .31651 .50485 .30187 .47126 Metetra
.629 .575 .775 r
.30187 .47126 .31651 .50485 .34134 .49833 .32678 .46321 Metetra
.627 .567 .768 r
.32678 .46321 .34134 .49833 .36641 .49222 .35193 .45515 Metetra
.624 .557 .759 r
.35193 .45515 .36641 .49222 .39173 .48645 .37732 .44706 Metetra
.62 .546 .749 r
.37732 .44706 .39173 .48645 .41733 .48096 .40296 .43893 Metetra
.617 .535 .739 r
.40296 .43893 .41733 .48096 .4432 .47568 .42885 .43077 Metetra
.613 .523 .729 r
.42885 .43077 .4432 .47568 .46937 .47053 .455 .42254 Metetra
.61 .513 .719 r
.455 .42254 .46937 .47053 .49585 .4654 .48141 .41424 Metetra
.607 .503 .709 r
.48141 .41424 .49585 .4654 .52264 .46022 .50808 .40586 Metetra
.604 .494 .701 r
.50808 .40586 .52264 .46022 .54975 .45488 .53502 .39738 Metetra
.602 .486 .693 r
.53502 .39738 .54975 .45488 .57718 .44929 .56224 .3888 Metetra
.6 .479 .686 r
.56224 .3888 .57718 .44929 .60494 .44335 .58973 .38009 Metetra
.598 .473 .681 r
.58973 .38009 .60494 .44335 .63301 .43699 .6175 .37124 Metetra
.597 .468 .676 r
.6175 .37124 .63301 .43699 .66138 .43013 .64555 .36225 Metetra
.596 .464 .672 r
.64555 .36225 .66138 .43013 .69006 .42269 .67389 .35311 Metetra
.595 .462 .669 r
.67389 .35311 .69006 .42269 .71903 .41464 .70252 .34381 Metetra
.595 .46 .668 r
.70252 .34381 .71903 .41464 .74828 .40593 .73143 .33433 Metetra
.595 .459 .667 r
.73143 .33433 .74828 .40593 .77779 .39654 .76064 .32469 Metetra
.595 .46 .667 r
.76064 .32469 .77779 .39654 .80755 .38647 .79014 .31487 Metetra
.596 .461 .668 r
.79014 .31487 .80755 .38647 .83756 .37573 .81993 .30488 Metetra
.622 .567 .772 r
.16601 .47766 .18067 .5114 .20448 .50338 .18971 .47045 Metetra
.627 .575 .776 r
.18971 .47045 .20448 .50338 .2285 .49536 .21369 .46277 Metetra
.632 .58 .778 r
.21369 .46277 .2285 .49536 .25273 .48733 .23793 .4546 Metetra
.636 .582 .778 r
.23793 .4546 .25273 .48733 .27719 .4793 .26243 .44594 Metetra
.639 .581 .774 r
.26243 .44594 .27719 .4793 .30187 .47126 .28719 .43679 Metetra
.64 .577 .768 r
.28719 .43679 .30187 .47126 .32678 .46321 .31219 .42718 Metetra
.641 .571 .761 r
.31219 .42718 .32678 .46321 .35193 .45515 .33744 .41713 Metetra
.64 .562 .752 r
.33744 .41713 .35193 .45515 .37732 .44706 .36291 .40668 Metetra
.638 .553 .742 r
.36291 .40668 .37732 .44706 .40296 .43893 .38862 .39588 Metetra
.635 .542 .732 r
.38862 .39588 .40296 .43893 .42885 .43077 .41454 .38479 Metetra
.632 .531 .721 r
.41454 .38479 .42885 .43077 .455 .42254 .44068 .37348 Metetra
.628 .52 .712 r
.44068 .37348 .455 .42254 .48141 .41424 .46704 .362 Metetra
.624 .51 .703 r
.46704 .362 .48141 .41424 .50808 .40586 .49361 .35043 Metetra
.62 .5 .695 r
.49361 .35043 .50808 .40586 .53502 .39738 .5204 .33883 Metetra
.616 .491 .687 r
.5204 .33883 .53502 .39738 .56224 .3888 .54741 .32727 Metetra
.612 .483 .681 r
.54741 .32727 .56224 .3888 .58973 .38009 .57465 .31582 Metetra
.608 .476 .676 r
.57465 .31582 .58973 .38009 .6175 .37124 .60214 .30454 Metetra
.604 .47 .671 r
.60214 .30454 .6175 .37124 .64555 .36225 .62987 .29346 Metetra
.601 .465 .668 r
.62987 .29346 .64555 .36225 .67389 .35311 .65787 .28264 Metetra
.598 .461 .665 r
.65787 .28264 .67389 .35311 .70252 .34381 .68614 .27211 Metetra
.595 .458 .664 r
.68614 .27211 .70252 .34381 .73143 .33433 .71472 .26189 Metetra
.593 .456 .663 r
.71472 .26189 .73143 .33433 .76064 .32469 .74361 .252 Metetra
.591 .454 .664 r
.74361 .252 .76064 .32469 .79014 .31487 .77282 .24242 Metetra
.59 .454 .665 r
.77282 .24242 .79014 .31487 .81993 .30488 .80239 .23316 Metetra
.619 .589 .798 r
.15081 .44769 .16601 .47766 .18971 .47045 .17445 .44109 Metetra
.629 .599 .801 r
.17445 .44109 .18971 .47045 .21369 .46277 .19841 .43364 Metetra
.638 .606 .801 r
.19841 .43364 .21369 .46277 .23793 .4546 .22268 .42533 Metetra
.646 .609 .799 r
.22268 .42533 .23793 .4546 .26243 .44594 .24726 .41614 Metetra
.653 .61 .794 r
.24726 .41614 .26243 .44594 .28719 .43679 .27211 .40609 Metetra
.658 .608 .788 r
.27211 .40609 .28719 .43679 .31219 .42718 .29723 .39522 Metetra
.661 .603 .78 r
.29723 .39522 .31219 .42718 .33744 .41713 .32259 .38358 Metetra
.663 .597 .771 r
.32259 .38358 .33744 .41713 .36291 .40668 .34819 .37127 Metetra
.663 .588 .761 r
.34819 .37127 .36291 .40668 .38862 .39588 .37399 .35836 Metetra
.661 .578 .751 r
.37399 .35836 .38862 .39588 .41454 .38479 .4 .34498 Metetra
.659 .568 .742 r
.4 .34498 .41454 .38479 .44068 .37348 .42619 .33125 Metetra
.655 .557 .733 r
.42619 .33125 .44068 .37348 .46704 .362 .45257 .31729 Metetra
.65 .547 .724 r
.45257 .31729 .46704 .362 .49361 .35043 .47912 .30324 Metetra
.645 .536 .716 r
.47912 .30324 .49361 .35043 .5204 .33883 .50584 .28923 Metetra
.64 .527 .709 r
.50584 .28923 .5204 .33883 .54741 .32727 .53276 .27538 Metetra
.634 .518 .703 r
.53276 .27538 .54741 .32727 .57465 .31582 .55986 .26181 Metetra
.628 .509 .698 r
.55986 .26181 .57465 .31582 .60214 .30454 .58717 .24864 Metetra
.623 .502 .694 r
.58717 .24864 .60214 .30454 .62987 .29346 .61471 .23596 Metetra
.617 .495 .691 r
.61471 .23596 .62987 .29346 .65787 .28264 .64249 .22384 Metetra
.612 .489 .689 r
.64249 .22384 .65787 .28264 .68614 .27211 .67055 .21235 Metetra
.607 .485 .688 r
.67055 .21235 .68614 .27211 .71472 .26189 .6989 .20152 Metetra
.602 .481 .687 r
.6989 .20152 .71472 .26189 .74361 .252 .72758 .19139 Metetra
.598 .478 .688 r
.72758 .19139 .74361 .252 .77282 .24242 .75662 .18195 Metetra
.594 .477 .689 r
.75662 .18195 .77282 .24242 .80239 .23316 .78603 .17319 Metetra
.623 .652 .858 r
.13458 .42509 .15081 .44769 .17445 .44109 .15824 .41871 Metetra
.637 .661 .857 r
.15824 .41871 .17445 .44109 .19841 .43364 .18226 .41131 Metetra
.65 .668 .854 r
.18226 .41131 .19841 .43364 .22268 .42533 .20661 .40285 Metetra
.662 .672 .849 r
.20661 .40285 .22268 .42533 .24726 .41614 .23129 .39332 Metetra
.673 .674 .843 r
.23129 .39332 .24726 .41614 .27211 .40609 .25627 .38275 Metetra
.682 .674 .836 r
.25627 .38275 .27211 .40609 .29723 .39522 .28153 .37118 Metetra
.688 .672 .829 r
.28153 .37118 .29723 .39522 .32259 .38358 .30704 .35869 Metetra
.693 .668 .821 r
.30704 .35869 .32259 .38358 .34819 .37127 .33279 .34538 Metetra
.697 .663 .813 r
.33279 .34538 .34819 .37127 .37399 .35836 .35874 .33136 Metetra
.698 .656 .805 r
.35874 .33136 .37399 .35836 .4 .34498 .38489 .31678 Metetra
.697 .649 .798 r
.38489 .31678 .4 .34498 .42619 .33125 .41121 .30179 Metetra
.695 .641 .791 r
.41121 .30179 .42619 .33125 .45257 .31729 .4377 .28654 Metetra
.692 .632 .785 r
.4377 .28654 .45257 .31729 .47912 .30324 .46435 .2712 Metetra
.687 .624 .779 r
.46435 .2712 .47912 .30324 .50584 .28923 .49115 .25593 Metetra
.682 .615 .774 r
.49115 .25593 .50584 .28923 .53276 .27538 .51812 .24089 Metetra
.676 .606 .77 r
.51812 .24089 .53276 .27538 .55986 .26181 .54526 .22621 Metetra
.669 .598 .767 r
.54526 .22621 .55986 .26181 .58717 .24864 .5726 .21204 Metetra
.661 .59 .764 r
.5726 .21204 .58717 .24864 .61471 .23596 .60014 .19849 Metetra
.653 .582 .763 r
.60014 .19849 .61471 .23596 .64249 .22384 .62793 .18566 Metetra
.645 .575 .762 r
.62793 .18566 .64249 .22384 .67055 .21235 .65598 .17361 Metetra
.637 .569 .762 r
.65598 .17361 .67055 .21235 .6989 .20152 .68433 .1624 Metetra
.629 .564 .762 r
.68433 .1624 .6989 .20152 .72758 .19139 .71301 .15206 Metetra
.621 .559 .764 r
.71301 .15206 .72758 .19139 .75662 .18195 .74206 .14259 Metetra
.613 .556 .766 r
.74206 .14259 .75662 .18195 .78603 .17319 .7715 .13396 Metetra
.62 .767 .95 r
.11695 .41165 .13458 .42509 .15824 .41871 .14075 .40502 Metetra
.639 .771 .943 r
.14075 .40502 .15824 .41871 .18226 .41131 .16491 .39743 Metetra
.657 .774 .935 r
.16491 .39743 .18226 .41131 .20661 .40285 .18941 .38882 Metetra
.673 .778 .929 r
.18941 .38882 .20661 .40285 .23129 .39332 .21424 .37919 Metetra
.687 .781 .922 r
.21424 .37919 .23129 .39332 .25627 .38275 .23938 .36856 Metetra
.7 .785 .917 r
.23938 .36856 .25627 .38275 .28153 .37118 .2648 .35697 Metetra
.711 .79 .913 r
.2648 .35697 .28153 .37118 .30704 .35869 .29048 .34451 Metetra
.721 .794 .909 r
.29048 .34451 .30704 .35869 .33279 .34538 .3164 .33125 Metetra
.729 .798 .907 r
.3164 .33125 .33279 .34538 .35874 .33136 .34255 .31731 Metetra
.735 .803 .906 r
.34255 .31731 .35874 .33136 .38489 .31678 .36889 .30284 Metetra
.739 .808 .906 r
.36889 .30284 .38489 .31678 .41121 .30179 .39542 .28796 Metetra
.741 .812 .908 r
.39542 .28796 .41121 .30179 .4377 .28654 .42212 .27284 Metetra
.742 .817 .91 r
.42212 .27284 .4377 .28654 .46435 .2712 .44898 .25762 Metetra
.741 .821 .914 r
.44898 .25762 .46435 .2712 .49115 .25593 .47602 .24245 Metetra
.737 .824 .918 r
.47602 .24245 .49115 .25593 .51812 .24089 .50322 .2275 Metetra
.732 .827 .924 r
.50322 .2275 .51812 .24089 .54526 .22621 .53061 .21289 Metetra
.724 .83 .93 r
.53061 .21289 .54526 .22621 .5726 .21204 .55819 .19875 Metetra
.715 .83 .937 r
.55819 .19875 .5726 .21204 .60014 .19849 .58599 .18519 Metetra
.703 .83 .943 r
.58599 .18519 .60014 .19849 .62793 .18566 .61403 .17231 Metetra
.689 .828 .95 r
.61403 .17231 .62793 .18566 .65598 .17361 .64234 .16017 Metetra
.674 .825 .956 r
.64234 .16017 .65598 .17361 .68433 .1624 .67095 .14882 Metetra
.657 .82 .961 r
.67095 .14882 .68433 .1624 .71301 .15206 .69989 .13828 Metetra
.64 .813 .966 r
.69989 .13828 .71301 .15206 .74206 .14259 .72919 .12857 Metetra
.624 .806 .97 r
.72919 .12857 .74206 .14259 .7715 .13396 .75889 .11964 Metetra
.557 .879 .991 r
.0978 .40698 .11695 .41165 .14075 .40502 .12186 .39967 Metetra
.588 .882 .992 r
.12186 .39967 .14075 .40502 .16491 .39743 .14625 .39165 Metetra
.613 .885 .99 r
.14625 .39165 .16491 .39743 .18941 .38882 .17096 .38288 Metetra
.632 .889 .987 r
.17096 .38288 .18941 .38882 .21424 .37919 .19598 .37337 Metetra
.647 .896 .984 r
.19598 .37337 .21424 .37919 .23938 .36856 .2213 .36313 Metetra
.657 .905 .98 r
.2213 .36313 .23938 .36856 .2648 .35697 .24689 .35219 Metetra
.663 .916 .977 r
.24689 .35219 .2648 .35697 .29048 .34451 .27276 .34059 Metetra
.663 .928 .972 r
.27276 .34059 .29048 .34451 .3164 .33125 .29887 .3284 Metetra
.657 .94 .964 r
.29887 .3284 .3164 .33125 .34255 .31731 .32522 .31571 Metetra
.642 .948 .951 r
.32522 .31571 .34255 .31731 .36889 .30284 .35179 .3026 Metetra
.617 .95 .929 r
.35179 .3026 .36889 .30284 .39542 .28796 .37857 .28917 Metetra
.579 .942 .897 r
.37857 .28917 .39542 .28796 .42212 .27284 .40556 .27553 Metetra
.529 .922 .852 r
.40556 .27553 .42212 .27284 .44898 .25762 .43276 .26179 Metetra
.468 .888 .795 r
.43276 .26179 .44898 .25762 .47602 .24245 .46015 .24805 Metetra
.399 .842 .73 r
.46015 .24805 .47602 .24245 .50322 .2275 .48775 .23443 Metetra
.327 .788 .66 r
.48775 .23443 .50322 .2275 .53061 .21289 .51557 .22102 Metetra
.51557 .22102 .53061 .21289 .55819 .19875 .54361 .20791 Metetra
.54361 .20791 .55819 .19875 .58599 .18519 .57189 .19518 Metetra
.57189 .19518 .58599 .18519 .61403 .17231 .60043 .18289 Metetra
.60043 .18289 .61403 .17231 .64234 .16017 .62925 .1711 Metetra
.62925 .1711 .64234 .16017 .67095 .14882 .65838 .15984 Metetra
.65838 .15984 .67095 .14882 .69989 .13828 .68783 .14913 Metetra
.68783 .14913 .69989 .13828 .72919 .12857 .71764 .13897 Metetra
.007 0 0 r
.71764 .13897 .72919 .12857 .75889 .11964 .74783 .12935 Metetra
.435 .873 .891 r
.07728 .4086 .0978 .40698 .12186 .39967 .10171 .40027 Metetra
.473 .889 .918 r
.10171 .40027 .12186 .39967 .14625 .39165 .1264 .39165 Metetra
.497 .898 .932 r
.1264 .39165 .14625 .39165 .17096 .38288 .15137 .38273 Metetra
.507 .902 .934 r
.15137 .38273 .17096 .38288 .19598 .37337 .17661 .3735 Metetra
.505 .903 .927 r
.17661 .3735 .19598 .37337 .2213 .36313 .20211 .36398 Metetra
.489 .899 .909 r
.20211 .36398 .2213 .36313 .24689 .35219 .22788 .35416 Metetra
.457 .886 .876 r
.22788 .35416 .24689 .35219 .27276 .34059 .25392 .34406 Metetra
.409 .86 .824 r
.25392 .34406 .27276 .34059 .29887 .3284 .28021 .33371 Metetra
.344 .816 .75 r
.28021 .33371 .29887 .3284 .32522 .31571 .30676 .32312 Metetra
.265 .752 .657 r
.30676 .32312 .32522 .31571 .35179 .3026 .33357 .31233 Metetra
.33357 .31233 .35179 .3026 .37857 .28917 .36063 .30137 Metetra
.36063 .30137 .37857 .28917 .40556 .27553 .38795 .29026 Metetra
.38795 .29026 .40556 .27553 .43276 .26179 .41553 .27906 Metetra
.049 0 0 r
.41553 .27906 .43276 .26179 .46015 .24805 .44337 .26778 Metetra
.104 0 0 r
.44337 .26778 .46015 .24805 .48775 .23443 .47147 .25647 Metetra
.148 0 0 r
.47147 .25647 .48775 .23443 .51557 .22102 .49984 .24515 Metetra
.183 0 0 r
.49984 .24515 .51557 .22102 .54361 .20791 .52848 .23386 Metetra
.211 0 0 r
.52848 .23386 .54361 .20791 .57189 .19518 .55741 .22262 Metetra
.232 0 .01 r
.55741 .22262 .57189 .19518 .60043 .18289 .58664 .21146 Metetra
.248 0 .031 r
.58664 .21146 .60043 .18289 .62925 .1711 .61617 .20038 Metetra
.259 0 .044 r
.61617 .20038 .62925 .1711 .65838 .15984 .64602 .1894 Metetra
.266 0 .051 r
.64602 .1894 .65838 .15984 .68783 .14913 .67619 .17853 Metetra
.269 0 .052 r
.67619 .17853 .68783 .14913 .71764 .13897 .7067 .16776 Metetra
.268 0 .047 r
.7067 .16776 .71764 .13897 .74783 .12935 .73757 .15709 Metetra
.418 .866 .844 r
.05586 .41237 .07728 .4086 .10171 .40027 .0807 .40288 Metetra
.438 .876 .871 r
.0807 .40288 .10171 .40027 .1264 .39165 .10573 .3936 Metetra
.441 .877 .883 r
.10573 .3936 .1264 .39165 .15137 .38273 .13098 .38451 Metetra
.428 .871 .88 r
.13098 .38451 .15137 .38273 .17661 .3735 .15644 .37563 Metetra
.399 .855 .861 r
.15644 .37563 .17661 .3735 .20211 .36398 .18213 .36695 Metetra
.353 .828 .823 r
.18213 .36695 .20211 .36398 .22788 .35416 .20806 .35845 Metetra
.29 .786 .762 r
.20806 .35845 .22788 .35416 .25392 .34406 .23424 .35011 Metetra
.212 .724 .678 r
.23424 .35011 .25392 .34406 .28021 .33371 .2607 .3419 Metetra
.2607 .3419 .28021 .33371 .30676 .32312 .28743 .33379 Metetra
.28743 .33379 .30676 .32312 .33357 .31233 .31445 .32573 Metetra
.041 0 0 r
.31445 .32573 .33357 .31233 .36063 .30137 .34178 .31767 Metetra
.108 0 0 r
.34178 .31767 .36063 .30137 .38795 .29026 .36942 .30958 Metetra
.162 0 0 r
.36942 .30958 .38795 .29026 .41553 .27906 .39738 .30138 Metetra
.204 0 0 r
.39738 .30138 .41553 .27906 .44337 .26778 .42567 .29305 Metetra
.237 0 0 r
.42567 .29305 .44337 .26778 .47147 .25647 .4543 .28451 Metetra
.261 0 .011 r
.4543 .28451 .47147 .25647 .49984 .24515 .48327 .27572 Metetra
.279 0 .046 r
.48327 .27572 .49984 .24515 .52848 .23386 .51257 .26665 Metetra
.292 0 .073 r
.51257 .26665 .52848 .23386 .55741 .22262 .54222 .25724 Metetra
.3 0 .093 r
.54222 .25724 .55741 .22262 .58664 .21146 .57221 .24745 Metetra
.305 0 .107 r
.57221 .24745 .58664 .21146 .61617 .20038 .60254 .23727 Metetra
.307 0 .115 r
.60254 .23727 .61617 .20038 .64602 .1894 .6332 .22668 Metetra
.305 0 .118 r
.6332 .22668 .64602 .1894 .67619 .17853 .66419 .21565 Metetra
.301 0 .117 r
.66419 .21565 .67619 .17853 .7067 .16776 .69551 .20419 Metetra
.295 0 .11 r
.69551 .20419 .7067 .16776 .73757 .15709 .72715 .19231 Metetra
.543 .921 .929 r
.03421 .41338 .05586 .41237 .0807 .40288 .05944 .40285 Metetra
.535 .913 .941 r
.05944 .40285 .0807 .40288 .10573 .3936 .0848 .39295 Metetra
.516 .903 .945 r
.0848 .39295 .10573 .3936 .13098 .38451 .1103 .38369 Metetra
.486 .89 .94 r
.1103 .38369 .13098 .38451 .15644 .37563 .13598 .3751 Metetra
.443 .871 .924 r
.13598 .3751 .15644 .37563 .18213 .36695 .16184 .36714 Metetra
.386 .844 .893 r
.16184 .36714 .18213 .36695 .20806 .35845 .18791 .35979 Metetra
.314 .804 .842 r
.18791 .35979 .20806 .35845 .23424 .35011 .21423 .35299 Metetra
.23 .748 .768 r
.21423 .35299 .23424 .35011 .2607 .3419 .24082 .34667 Metetra
.24082 .34667 .2607 .3419 .28743 .33379 .2677 .34074 Metetra
.2677 .34074 .28743 .33379 .31445 .32573 .2949 .33511 Metetra
.031 0 0 r
.2949 .33511 .31445 .32573 .34178 .31767 .32245 .32965 Metetra
.099 0 0 r
.32245 .32965 .34178 .31767 .36942 .30958 .35037 .32425 Metetra
.152 0 0 r
.35037 .32425 .36942 .30958 .39738 .30138 .37866 .31877 Metetra
.193 0 0 r
.37866 .31877 .39738 .30138 .42567 .29305 .40735 .31309 Metetra
.222 0 0 r
.40735 .31309 .42567 .29305 .4543 .28451 .43645 .30708 Metetra
.242 0 0 r
.43645 .30708 .4543 .28451 .48327 .27572 .46595 .3006 Metetra
.256 0 0 r
.46595 .3006 .48327 .27572 .51257 .26665 .49585 .29354 Metetra
.263 0 0 r
.49585 .29354 .51257 .26665 .54222 .25724 .52616 .28579 Metetra
.266 0 .005 r
.52616 .28579 .54222 .25724 .57221 .24745 .55685 .27728 Metetra
.264 0 .018 r
.55685 .27728 .57221 .24745 .60254 .23727 .58792 .26791 Metetra
.259 0 .025 r
.58792 .26791 .60254 .23727 .6332 .22668 .61934 .25765 Metetra
.25 0 .026 r
.61934 .25765 .6332 .22668 .66419 .21565 .65111 .24645 Metetra
.237 0 .021 r
.65111 .24645 .66419 .21565 .69551 .20419 .68319 .23433 Metetra
.221 0 .01 r
.68319 .23433 .69551 .20419 .72715 .19231 .71558 .22129 Metetra
.667 .895 .979 r
.01307 .40715 .03421 .41338 .05944 .40285 .0386 .39592 Metetra
.647 .884 .984 r
.0386 .39592 .05944 .40285 .0848 .39295 .06422 .38557 Metetra
.623 .876 .989 r
.06422 .38557 .0848 .39295 .1103 .38369 .08994 .37614 Metetra
.595 .868 .994 r
.08994 .37614 .1103 .38369 .13598 .3751 .11579 .36765 Metetra
.562 .861 .997 r
.11579 .36765 .13598 .3751 .16184 .36714 .14181 .36006 Metetra
.523 .853 .997 r
.14181 .36006 .16184 .36714 .18791 .35979 .16802 .35333 Metetra
.478 .844 .991 r
.16802 .35333 .18791 .35979 .21423 .35299 .19446 .3474 Metetra
.427 .83 .978 r
.19446 .3474 .21423 .35299 .24082 .34667 .22117 .34216 Metetra
.371 .812 .954 r
.22117 .34216 .24082 .34667 .2677 .34074 .24818 .3375 Metetra
.31 .787 .919 r
.24818 .3375 .2677 .34074 .2949 .33511 .27553 .33328 Metetra
.249 .756 .871 r
.27553 .33328 .2949 .33511 .32245 .32965 .30325 .32934 Metetra
.189 .721 .815 r
.30325 .32934 .32245 .32965 .35037 .32425 .33137 .32553 Metetra
.136 .683 .753 r
.33137 .32553 .35037 .32425 .37866 .31877 .35992 .32166 Metetra
.35992 .32166 .37866 .31877 .40735 .31309 .3889 .31755 Metetra
.3889 .31755 .40735 .31309 .43645 .30708 .41833 .31302 Metetra
.41833 .31302 .43645 .30708 .46595 .3006 .44822 .3079 Metetra
.44822 .3079 .46595 .3006 .49585 .29354 .47856 .30203 Metetra
.47856 .30203 .49585 .29354 .52616 .28579 .50934 .29525 Metetra
.50934 .29525 .52616 .28579 .55685 .27728 .54054 .28744 Metetra
.54054 .28744 .55685 .27728 .58792 .26791 .57215 .27849 Metetra
.57215 .27849 .58792 .26791 .61934 .25765 .60414 .26835 Metetra
.60414 .26835 .61934 .25765 .65111 .24645 .63649 .25696 Metetra
.63649 .25696 .65111 .24645 .68319 .23433 .66915 .24433 Metetra
.66915 .24433 .68319 .23433 .71558 .22129 .70212 .23047 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -70.3112 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell["\<\
This is what you get with a view point close to one of the corners \
of the box. \
\>", "MathCaption",
  CellTags->{"S2.10.10", "10.16"}],

Cell[CellGroupData[{

Cell["Show[surf, ViewPoint -> {1.2, 1.2, 1.2}]", "Input",
  CellLabel->"In[8]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .80304 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
6.96329e-17 1 -0.00925227 1 [
[.95853 .3818 0 -6.77332 ]
[.95853 .3818 12 2.22668 ]
[.87004 .3049 0 -7.03766 ]
[.87004 .3049 12 1.96234 ]
[.76811 .21634 0 -7.37156 ]
[.76811 .21634 6 1.62844 ]
[.64942 .11327 0 -7.80664 ]
[.64942 .11327 6 1.19336 ]
[.50945 -0.00818 0 -8.39711 ]
[.50945 -0.00818 6 .60289 ]
[.8208 .18272 0 -8.03705 ]
[.8208 .18272 10 1.77545 ]
[.09911 .33171 -12 -6.94297 ]
[.09911 .33171 0 2.05703 ]
[.23189 .21634 -6 -7.37156 ]
[.23189 .21634 0 1.62844 ]
[.39461 .07506 -6 -7.98253 ]
[.39461 .07506 0 1.01747 ]
[.1792 .18272 -10.0625 -8.03705 ]
[.1792 .18272 0 1.77545 ]
[.03284 .41753 -12 -6.69006 ]
[.03284 .41753 0 2.30994 ]
[.01651 .48508 -6 -6.53448 ]
[.01651 .48508 0 2.46552 ]
[-0.001 .5576 -6 -6.37001 ]
[-0.001 .5576 0 2.62999 ]
[-0.04057 .45987 -10 -7.12309 ]
[-0.04057 .45987 0 2.68941 ]
[ 0 0 0 0 ]
[ 1 .80304 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.94737 .38743 m
.5 0 L
s
.94737 .38743 m
.94179 .39025 L
s
[(-2)] .95853 .3818 -1 .50518 Mshowa
.85915 .31104 m
.85371 .31411 L
s
[(-1)] .87004 .3049 -1 .56392 Mshowa
.75758 .22307 m
.75231 .22643 L
s
[(0)] .76811 .21634 -1 .63812 Mshowa
.63934 .12068 m
.63431 .12438 L
s
[(1)] .64942 .11327 -1 .73481 Mshowa
.5 0 m
.49528 .00409 L
s
[(2)] .50945 -0.00818 -1 .86603 Mshowa
.125 Mabswid
.93067 .37297 m
.92733 .37469 L
s
.91351 .35811 m
.9102 .35986 L
s
.89589 .34285 m
.89259 .34463 L
s
.87778 .32717 m
.87449 .32898 L
s
.84 .29445 m
.83675 .29632 L
s
.82029 .27738 m
.81706 .27929 L
s
.8 .25981 m
.79679 .26175 L
s
.7791 .24171 m
.77592 .24369 L
s
.73538 .20385 m
.73225 .2059 L
s
.7125 .18403 m
.70939 .18613 L
s
.68889 .16358 m
.68581 .16572 L
s
.66452 .14248 m
.66146 .14465 L
s
.61333 .09815 m
.61034 .10041 L
s
.58644 .07486 m
.58349 .07717 L
s
.55862 .05077 m
.5557 .05312 L
s
.52982 .02583 m
.52695 .02823 L
s
gsave
.8208 .18272 -61 -12.0371 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.05263 .38743 m
.5 0 L
s
.11009 .33767 m
.11558 .34065 L
s
[(-2)] .09911 .33171 1 .54288 Mshowa
.24242 .22307 m
.24769 .22643 L
s
[(0)] .23189 .21634 1 .63812 Mshowa
.40449 .08271 m
.40944 .08654 L
s
[(2)] .39461 .07506 1 .7739 Mshowa
.125 Mabswid
.14085 .31104 m
.14411 .31288 L
s
.17308 .28312 m
.17631 .28502 L
s
.2069 .25384 m
.2101 .25579 L
s
.27979 .19071 m
.28291 .19279 L
s
.31915 .15662 m
.32222 .15877 L
s
.36066 .12068 m
.36368 .1229 L
s
.08072 .36311 m
.08404 .36485 L
s
.45087 .04255 m
.45377 .04492 L
s
gsave
.1792 .18272 -71.0625 -12.0371 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.05263 .38743 m
0 .60622 L
s
.04408 .423 m
.0497 .42573 L
s
[(-2)] .03284 .41753 1 .48668 Mshowa
.0279 .49023 m
.0336 .4928 L
s
[(0)] .01651 .48508 1 .45211 Mshowa
.01054 .5624 m
.01631 .56479 L
s
[(2)] -0.001 .5576 1 .41556 Mshowa
.125 Mabswid
.04014 .43937 m
.04352 .44099 L
s
.03613 .45603 m
.03952 .45762 L
s
.03205 .47298 m
.03546 .47455 L
s
.02368 .50778 m
.02711 .5093 L
s
.01938 .52566 m
.02282 .52715 L
s
.015 .54386 m
.01845 .54533 L
s
.04795 .40691 m
.05131 .40857 L
s
.05175 .39108 m
.0551 .39277 L
s
.006 .58128 m
.00947 .58269 L
s
.00137 .60051 m
.00486 .60189 L
s
gsave
-0.04057 .45987 -71 -11.1231 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.5 .61343 m
.5 .80304 L
s
.5 .80304 m
1 .60622 L
s
1 .60622 m
.94737 .38743 L
s
.94737 .38743 m
.5 .61343 L
s
.05263 .38743 m
.5 0 L
s
.5 0 m
.5 .24537 L
s
.5 .24537 m
0 .60622 L
s
0 .60622 m
.05263 .38743 L
s
.5 .61343 m
.5 .80304 L
s
.5 .80304 m
0 .60622 L
s
0 .60622 m
.05263 .38743 L
s
.05263 .38743 m
.5 .61343 L
s
.94737 .38743 m
.5 0 L
s
.5 0 m
.5 .24537 L
s
.5 .24537 m
1 .60622 L
s
1 .60622 m
.94737 .38743 L
s
0 0 m
1 0 L
1 .80304 L
0 .80304 L
closepath
clip
newpath
.5 Mabswid
.752 .782 .878 r
.5 .73576 .51571 .72038 .5 .71212 .48424 .72724 Metetra
.753 .798 .889 r
.48424 .72724 .5 .71212 .48401 .70431 .46821 .71937 Metetra
.757 .814 .898 r
.46821 .71937 .48401 .70431 .46772 .69697 .45186 .7122 Metetra
.763 .829 .903 r
.45186 .7122 .46772 .69697 .45111 .69012 .43518 .70574 Metetra
.772 .844 .906 r
.43518 .70574 .45111 .69012 .43414 .68373 .41814 .69998 Metetra
.783 .856 .905 r
.41814 .69998 .43414 .68373 .4168 .6778 .4007 .69489 Metetra
.796 .866 .9 r
.4007 .69489 .4168 .6778 .39906 .67228 .38284 .69041 Metetra
.81 .872 .893 r
.38284 .69041 .39906 .67228 .38091 .66712 .36453 .68649 Metetra
.824 .876 .883 r
.36453 .68649 .38091 .66712 .36231 .66224 .34574 .68302 Metetra
.837 .876 .871 r
.34574 .68302 .36231 .66224 .34325 .65755 .32646 .67989 Metetra
.849 .872 .858 r
.32646 .67989 .34325 .65755 .32371 .65297 .30667 .67698 Metetra
.859 .867 .844 r
.30667 .67698 .32371 .65297 .30368 .64839 .28634 .67415 Metetra
.867 .859 .831 r
.28634 .67415 .30368 .64839 .28314 .6437 .26548 .67124 Metetra
.872 .85 .818 r
.26548 .67124 .28314 .6437 .2621 .63877 .24408 .6681 Metetra
.876 .839 .806 r
.24408 .6681 .2621 .63877 .24054 .63349 .22214 .66456 Metetra
.878 .828 .795 r
.22214 .66456 .24054 .63349 .21848 .62774 .19968 .66046 Metetra
.878 .817 .785 r
.19968 .66046 .21848 .62774 .19591 .6214 .1767 .65566 Metetra
.877 .807 .776 r
.1767 .65566 .19591 .6214 .17284 .61438 .15322 .65 Metetra
.875 .796 .769 r
.15322 .65 .17284 .61438 .14929 .60657 .12927 .64336 Metetra
.872 .786 .763 r
.12927 .64336 .14929 .60657 .12527 .5979 .10488 .63563 Metetra
.868 .777 .759 r
.10488 .63563 .12527 .5979 .10078 .58831 .08006 .62672 Metetra
.863 .768 .756 r
.08006 .62672 .10078 .58831 .07586 .57775 .05484 .61658 Metetra
.858 .761 .754 r
.05484 .61658 .07586 .57775 .05049 .56621 .02925 .60518 Metetra
.852 .754 .754 r
.02925 .60518 .05049 .56621 .02469 .55368 .0033 .59252 Metetra
.809 .775 .821 r
.51571 .72038 .5315 .69898 .51589 .69126 .5 .71212 Metetra
.81 .787 .831 r
.5 .71212 .51589 .69126 .5 .68362 .48401 .70431 Metetra
.812 .797 .838 r
.48401 .70431 .5 .68362 .48381 .67609 .46772 .69697 Metetra
.817 .807 .841 r
.46772 .69697 .48381 .67609 .4673 .66867 .45111 .69012 Metetra
.825 .815 .841 r
.45111 .69012 .4673 .66867 .45046 .66134 .43414 .68373 Metetra
.834 .821 .836 r
.43414 .68373 .45046 .66134 .43328 .65409 .4168 .6778 Metetra
.845 .823 .827 r
.4168 .6778 .43328 .65409 .41574 .64691 .39906 .67228 Metetra
.856 .824 .816 r
.39906 .67228 .41574 .64691 .39782 .63976 .38091 .66712 Metetra
.866 .821 .802 r
.38091 .66712 .39782 .63976 .37951 .63263 .36231 .66224 Metetra
.875 .816 .787 r
.36231 .66224 .37951 .63263 .36079 .62546 .34325 .65755 Metetra
.883 .809 .772 r
.34325 .65755 .36079 .62546 .34166 .61822 .32371 .65297 Metetra
.889 .801 .757 r
.32371 .65297 .34166 .61822 .32209 .61086 .30368 .64839 Metetra
.893 .793 .743 r
.30368 .64839 .32209 .61086 .30208 .60333 .28314 .6437 Metetra
.896 .784 .73 r
.28314 .6437 .30208 .60333 .28161 .59559 .2621 .63877 Metetra
.897 .775 .718 r
.2621 .63877 .28161 .59559 .26068 .58757 .24054 .63349 Metetra
.898 .766 .708 r
.24054 .63349 .26068 .58757 .23928 .57925 .21848 .62774 Metetra
.898 .758 .699 r
.21848 .62774 .23928 .57925 .21739 .57055 .19591 .6214 Metetra
.897 .751 .691 r
.19591 .6214 .21739 .57055 .19502 .56145 .17284 .61438 Metetra
.896 .744 .686 r
.17284 .61438 .19502 .56145 .17216 .5519 .14929 .60657 Metetra
.894 .738 .681 r
.14929 .60657 .17216 .5519 .1488 .54187 .12527 .5979 Metetra
.892 .733 .678 r
.12527 .5979 .1488 .54187 .12494 .53133 .10078 .58831 Metetra
.889 .728 .676 r
.10078 .58831 .12494 .53133 .10057 .52025 .07586 .57775 Metetra
.886 .725 .676 r
.07586 .57775 .10057 .52025 .07567 .50863 .05049 .56621 Metetra
.883 .722 .676 r
.05049 .56621 .07567 .50863 .05025 .49646 .02469 .55368 Metetra
.83 .78 .804 r
.5315 .69898 .54732 .67515 .53185 .66805 .51589 .69126 Metetra
.827 .786 .813 r
.51589 .69126 .53185 .66805 .51608 .66064 .5 .68362 Metetra
.827 .791 .818 r
.5 .68362 .51608 .66064 .5 .65291 .48381 .67609 Metetra
.829 .794 .819 r
.48381 .67609 .5 .65291 .48362 .64484 .4673 .66867 Metetra
.833 .796 .816 r
.4673 .66867 .48362 .64484 .46692 .63644 .45046 .66134 Metetra
.839 .797 .81 r
.45046 .66134 .46692 .63644 .4499 .62771 .43328 .65409 Metetra
.847 .795 .8 r
.43328 .65409 .4499 .62771 .43256 .61865 .41574 .64691 Metetra
.855 .791 .788 r
.41574 .64691 .43256 .61865 .41489 .60928 .39782 .63976 Metetra
.863 .787 .774 r
.39782 .63976 .41489 .60928 .39688 .59961 .37951 .63263 Metetra
.871 .78 .759 r
.37951 .63263 .39688 .59961 .37853 .58967 .36079 .62546 Metetra
.877 .774 .744 r
.36079 .62546 .37853 .58967 .35982 .57946 .34166 .61822 Metetra
.882 .766 .729 r
.34166 .61822 .35982 .57946 .34074 .56902 .32209 .61086 Metetra
.887 .759 .716 r
.32209 .61086 .34074 .56902 .32128 .55838 .30208 .60333 Metetra
.89 .752 .703 r
.30208 .60333 .32128 .55838 .30143 .54755 .28161 .59559 Metetra
.892 .746 .693 r
.28161 .59559 .30143 .54755 .28117 .53657 .26068 .58757 Metetra
.894 .74 .683 r
.26068 .58757 .28117 .53657 .26048 .52545 .23928 .57925 Metetra
.895 .734 .675 r
.23928 .57925 .26048 .52545 .23934 .51422 .21739 .57055 Metetra
.895 .729 .668 r
.21739 .57055 .23934 .51422 .21774 .50289 .19502 .56145 Metetra
.896 .725 .663 r
.19502 .56145 .21774 .50289 .19563 .49149 .17216 .5519 Metetra
.895 .722 .659 r
.17216 .5519 .19563 .49149 .17301 .48002 .1488 .54187 Metetra
.895 .719 .657 r
.1488 .54187 .17301 .48002 .14985 .46848 .12494 .53133 Metetra
.894 .717 .655 r
.12494 .53133 .14985 .46848 .12612 .45687 .10057 .52025 Metetra
.893 .716 .655 r
.10057 .52025 .12612 .45687 .10179 .4452 .07567 .50863 Metetra
.892 .716 .656 r
.07567 .50863 .10179 .4452 .07683 .43344 .05025 .49646 Metetra
.828 .798 .823 r
.54732 .67515 .56325 .65295 .54791 .64639 .53185 .66805 Metetra
.821 .798 .83 r
.53185 .66805 .54791 .64639 .53225 .63915 .51608 .66064 Metetra
.816 .796 .833 r
.51608 .66064 .53225 .63915 .51628 .63122 .5 .65291 Metetra
.815 .794 .832 r
.5 .65291 .51628 .63122 .5 .62257 .48362 .64484 Metetra
.816 .79 .828 r
.48362 .64484 .5 .62257 .48342 .6132 .46692 .63644 Metetra
.819 .785 .821 r
.46692 .63644 .48342 .6132 .46653 .60314 .4499 .62771 Metetra
.824 .78 .811 r
.4499 .62771 .46653 .60314 .44935 .59242 .43256 .61865 Metetra
.831 .774 .798 r
.43256 .61865 .44935 .59242 .43187 .58108 .41489 .60928 Metetra
.838 .768 .785 r
.41489 .60928 .43187 .58108 .41409 .56918 .39688 .59961 Metetra
.845 .762 .77 r
.39688 .59961 .41409 .56918 .39602 .5568 .37853 .58967 Metetra
.852 .756 .756 r
.37853 .58967 .39602 .5568 .37765 .54402 .35982 .57946 Metetra
.859 .75 .742 r
.35982 .57946 .37765 .54402 .35896 .53092 .34074 .56902 Metetra
.864 .745 .729 r
.34074 .56902 .35896 .53092 .33995 .51759 .32128 .55838 Metetra
.87 .74 .717 r
.32128 .55838 .33995 .51759 .32059 .50412 .30143 .54755 Metetra
.874 .736 .706 r
.30143 .54755 .32059 .50412 .30087 .4906 .28117 .53657 Metetra
.878 .732 .697 r
.28117 .53657 .30087 .4906 .28075 .47711 .26048 .52545 Metetra
.881 .729 .689 r
.26048 .52545 .28075 .47711 .26022 .46374 .23934 .51422 Metetra
.884 .727 .683 r
.23934 .51422 .26022 .46374 .23923 .45053 .21774 .50289 Metetra
.886 .726 .678 r
.21774 .50289 .23923 .45053 .21776 .43756 .19563 .49149 Metetra
.888 .725 .674 r
.19563 .49149 .21776 .43756 .19575 .42487 .17301 .48002 Metetra
.889 .725 .672 r
.17301 .48002 .19575 .42487 .17317 .41247 .14985 .46848 Metetra
.891 .725 .671 r
.14985 .46848 .17317 .41247 .14998 .40039 .12612 .45687 Metetra
.891 .727 .671 r
.12612 .45687 .14998 .40039 .12613 .38863 .10179 .4452 Metetra
.892 .728 .672 r
.10179 .4452 .12613 .38863 .10158 .37717 .07683 .43344 Metetra
.788 .828 .883 r
.56325 .65295 .57945 .6359 .56421 .62962 .54791 .64639 Metetra
.778 .82 .886 r
.54791 .64639 .56421 .62962 .54863 .62244 .53225 .63915 Metetra
.77 .81 .885 r
.53225 .63915 .54863 .62244 .53274 .61432 .51628 .63122 Metetra
.765 .8 .881 r
.51628 .63122 .53274 .61432 .51652 .60524 .5 .62257 Metetra
.763 .79 .875 r
.5 .62257 .51652 .60524 .5 .5952 .48342 .6132 Metetra
.764 .781 .867 r
.48342 .6132 .5 .5952 .48318 .58423 .46653 .60314 Metetra
.767 .772 .857 r
.46653 .60314 .48318 .58423 .46608 .57239 .44935 .59242 Metetra
.772 .764 .846 r
.44935 .59242 .46608 .57239 .4487 .55974 .43187 .58108 Metetra
.779 .758 .834 r
.43187 .58108 .4487 .55974 .43104 .54638 .41409 .56918 Metetra
.786 .752 .822 r
.41409 .56918 .43104 .54638 .41311 .5324 .39602 .5568 Metetra
.795 .747 .809 r
.39602 .5568 .41311 .5324 .39491 .51794 .37765 .54402 Metetra
.803 .744 .798 r
.37765 .54402 .39491 .51794 .37642 .50311 .35896 .53092 Metetra
.811 .741 .787 r
.35896 .53092 .37642 .50311 .35764 .48804 .33995 .51759 Metetra
.82 .74 .776 r
.33995 .51759 .35764 .48804 .33855 .47286 .32059 .50412 Metetra
.827 .739 .767 r
.32059 .50412 .33855 .47286 .31911 .45771 .30087 .4906 Metetra
.835 .74 .759 r
.30087 .4906 .31911 .45771 .29932 .44269 .28075 .47711 Metetra
.842 .741 .752 r
.28075 .47711 .29932 .44269 .27912 .42792 .26022 .46374 Metetra
.848 .743 .747 r
.26022 .46374 .27912 .42792 .25847 .41348 .23923 .45053 Metetra
.854 .745 .743 r
.23923 .45053 .25847 .41348 .23735 .39947 .21776 .43756 Metetra
.859 .748 .74 r
.21776 .43756 .23735 .39947 .21568 .38594 .19575 .42487 Metetra
.864 .752 .738 r
.19575 .42487 .21568 .38594 .19344 .37293 .17317 .41247 Metetra
.867 .756 .738 r
.17317 .41247 .19344 .37293 .17055 .36046 .14998 .40039 Metetra
.871 .761 .739 r
.14998 .40039 .17055 .36046 .14698 .34853 .12613 .38863 Metetra
.873 .766 .741 r
.12613 .38863 .14698 .34853 .12266 .33713 .10158 .37717 Metetra
.649 .842 .974 r
.57945 .6359 .59616 .62624 .58096 .6199 .56421 .62962 Metetra
.645 .825 .97 r
.56421 .62962 .58096 .6199 .56542 .6126 .54863 .62244 Metetra
.641 .809 .963 r
.54863 .62244 .56542 .6126 .54954 .60432 .53274 .61432 Metetra
.638 .792 .956 r
.53274 .61432 .54954 .60432 .53334 .59502 .51652 .60524 Metetra
.635 .777 .949 r
.51652 .60524 .53334 .59502 .51682 .58471 .5 .5952 Metetra
.633 .762 .941 r
.5 .5952 .51682 .58471 .5 .57342 .48318 .58423 Metetra
.632 .75 .933 r
.48318 .58423 .5 .57342 .48289 .5612 .46608 .57239 Metetra
.632 .739 .925 r
.46608 .57239 .48289 .5612 .46549 .54814 .4487 .55974 Metetra
.633 .731 .918 r
.4487 .55974 .46549 .54814 .44782 .53433 .43104 .54638 Metetra
.635 .725 .913 r
.43104 .54638 .44782 .53433 .42987 .51987 .41311 .5324 Metetra
.638 .721 .908 r
.41311 .5324 .42987 .51987 .41165 .50491 .39491 .51794 Metetra
.643 .72 .904 r
.39491 .51794 .41165 .50491 .39315 .48956 .37642 .50311 Metetra
.648 .721 .902 r
.37642 .50311 .39315 .48956 .37435 .47397 .35764 .48804 Metetra
.654 .724 .9 r
.35764 .48804 .37435 .47397 .35525 .45827 .33855 .47286 Metetra
.661 .729 .9 r
.33855 .47286 .35525 .45827 .33581 .44261 .31911 .45771 Metetra
.669 .736 .901 r
.31911 .45771 .33581 .44261 .31601 .42709 .29932 .44269 Metetra
.677 .745 .902 r
.29932 .44269 .31601 .42709 .29581 .41185 .27912 .42792 Metetra
.685 .755 .905 r
.27912 .42792 .29581 .41185 .27517 .39697 .25847 .41348 Metetra
.694 .767 .908 r
.25847 .41348 .27517 .39697 .25404 .38254 .23735 .39947 Metetra
.702 .779 .911 r
.23735 .39947 .25404 .38254 .23238 .36863 .21568 .38594 Metetra
.71 .791 .915 r
.21568 .38594 .23238 .36863 .21013 .35527 .19344 .37293 Metetra
.717 .804 .919 r
.19344 .37293 .21013 .35527 .18724 .34249 .17055 .36046 Metetra
.723 .816 .923 r
.17055 .36046 .18724 .34249 .16365 .3303 .14698 .34853 Metetra
.728 .828 .927 r
.14698 .34853 .16365 .3303 .13931 .31865 .12266 .33713 Metetra
.298 .716 .973 r
.59616 .62624 .61359 .62449 .59837 .61772 .58096 .6199 Metetra
.331 .718 .983 r
.58096 .6199 .59837 .61772 .5828 .61013 .56542 .6126 Metetra
.352 .713 .986 r
.56542 .6126 .5828 .61013 .56689 .60171 .54954 .60432 Metetra
.363 .701 .984 r
.54954 .60432 .56689 .60171 .55065 .59241 .53334 .59502 Metetra
.363 .685 .98 r
.53334 .59502 .55065 .59241 .53409 .58226 .51682 .58471 Metetra
.354 .667 .974 r
.51682 .58471 .53409 .58226 .5172 .57126 .5 .57342 Metetra
.338 .646 .967 r
.5 .57342 .5172 .57126 .5 .55947 .48289 .5612 Metetra
.314 .623 .959 r
.48289 .5612 .5 .55947 .4825 .54695 .46549 .54814 Metetra
.284 .599 .95 r
.46549 .54814 .4825 .54695 .46469 .53376 .44782 .53433 Metetra
.247 .573 .941 r
.44782 .53433 .46469 .53376 .44658 .52 .42987 .51987 Metetra
.204 .545 .929 r
.42987 .51987 .44658 .52 .42818 .50578 .41165 .50491 Metetra
.157 .517 .916 r
.41165 .50491 .42818 .50578 .40946 .49119 .39315 .48956 Metetra
.105 .486 .899 r
.39315 .48956 .40946 .49119 .39042 .47635 .37435 .47397 Metetra
.05 .456 .88 r
.37435 .47397 .39042 .47635 .37105 .46138 .35525 .45827 Metetra
0 .425 .857 r
.35525 .45827 .37105 .46138 .35131 .44637 .33581 .44261 Metetra
0 .395 .832 r
.33581 .44261 .35131 .44637 .3312 .43144 .31601 .42709 Metetra
0 .367 .805 r
.31601 .42709 .3312 .43144 .31066 .41668 .29581 .41185 Metetra
0 .342 .777 r
.29581 .41185 .31066 .41668 .28968 .40217 .27517 .39697 Metetra
0 .322 .75 r
.27517 .39697 .28968 .40217 .2682 .38797 .25404 .38254 Metetra
0 .308 .726 r
.25404 .38254 .2682 .38797 .24619 .37414 .23238 .36863 Metetra
0 .301 .707 r
.23238 .36863 .24619 .37414 .22359 .36071 .21013 .35527 Metetra
0 .3 .693 r
.21013 .35527 .22359 .36071 .20036 .34771 .18724 .34249 Metetra
0 .307 .686 r
.18724 .34249 .20036 .34771 .17644 .33512 .16365 .3303 Metetra
0 .321 .685 r
.16365 .3303 .17644 .33512 .15179 .32293 .13931 .31865 Metetra
0 .448 .788 r
.61359 .62449 .63189 .62936 .61657 .62184 .59837 .61772 Metetra
0 .485 .832 r
.59837 .61772 .61657 .62184 .60093 .61382 .5828 .61013 Metetra
0 .503 .86 r
.5828 .61013 .60093 .61382 .58495 .60527 .56689 .60171 Metetra
.016 .505 .872 r
.56689 .60171 .58495 .60527 .56863 .59617 .55065 .59241 Metetra
.013 .492 .872 r
.55065 .59241 .56863 .59617 .55198 .58654 .53409 .58226 Metetra
0 .466 .861 r
.53409 .58226 .55198 .58654 .53499 .57637 .5172 .57126 Metetra
0 .428 .839 r
.5172 .57126 .53499 .57637 .51767 .56568 .5 .55947 Metetra
0 .379 .806 r
.5 .55947 .51767 .56568 .5 .55451 .4825 .54695 Metetra
0 .32 .761 r
.4825 .54695 .5 .55451 .48199 .54289 .46469 .53376 Metetra
0 .254 .706 r
.46469 .53376 .48199 .54289 .46363 .53085 .44658 .52 Metetra
0 .183 .641 r
.44658 .52 .46363 .53085 .44492 .51846 .42818 .50578 Metetra
0 .112 .57 r
.42818 .50578 .44492 .51846 .42584 .50576 .40946 .49119 Metetra
.494 0 0 r
.40946 .49119 .42584 .50576 .40639 .49281 .39042 .47635 Metetra
.557 .016 0 r
.39042 .47635 .40639 .49281 .38655 .47967 .37105 .46138 Metetra
.608 .068 0 r
.37105 .46138 .38655 .47967 .3663 .46639 .35131 .44637 Metetra
.65 .112 0 r
.35131 .44637 .3663 .46639 .34562 .45302 .3312 .43144 Metetra
.681 .147 0 r
.3312 .43144 .34562 .45302 .32448 .43961 .31066 .41668 Metetra
.704 .174 0 r
.31066 .41668 .32448 .43961 .30287 .4262 .28968 .40217 Metetra
.721 .193 0 r
.28968 .40217 .30287 .4262 .28074 .41283 .2682 .38797 Metetra
.731 .206 0 r
.2682 .38797 .28074 .41283 .25806 .39952 .24619 .37414 Metetra
.737 .213 0 r
.24619 .37414 .25806 .39952 .23481 .38628 .22359 .36071 Metetra
.738 .214 0 r
.22359 .36071 .23481 .38628 .21093 .37312 .20036 .34771 Metetra
.736 .21 0 r
.20036 .34771 .21093 .37312 .1864 .36003 .17644 .33512 Metetra
.729 .201 0 r
.17644 .33512 .1864 .36003 .16118 .347 .15179 .32293 Metetra
0 .3 .67 r
.63189 .62936 .65103 .63792 .63558 .62948 .61657 .62184 Metetra
0 .342 .716 r
.61657 .62184 .63558 .62948 .61982 .62092 .60093 .61382 Metetra
0 .365 .744 r
.60093 .61382 .61982 .62092 .60375 .61226 .58495 .60527 Metetra
0 .369 .755 r
.58495 .60527 .60375 .61226 .58735 .60348 .56863 .59617 Metetra
0 .354 .749 r
.56863 .59617 .58735 .60348 .57061 .59458 .55198 .58654 Metetra
0 .322 .725 r
.55198 .58654 .57061 .59458 .55352 .58556 .53499 .57637 Metetra
0 .274 .686 r
.53499 .57637 .55352 .58556 .53606 .57639 .51767 .56568 Metetra
0 .213 .632 r
.51767 .56568 .53606 .57639 .51823 .56708 .5 .55451 Metetra
.414 0 0 r
.5 .55451 .51823 .56708 .5 .5576 .48199 .54289 Metetra
.487 0 0 r
.48199 .54289 .5 .5576 .48137 .54794 .46363 .53085 Metetra
.556 0 0 r
.46363 .53085 .48137 .54794 .46232 .53809 .44492 .51846 Metetra
.615 .066 0 r
.44492 .51846 .46232 .53809 .44283 .52802 .42584 .50576 Metetra
.665 .123 0 r
.42584 .50576 .44283 .52802 .42289 .51772 .40639 .49281 Metetra
.704 .172 0 r
.40639 .49281 .42289 .51772 .40249 .50717 .38655 .47967 Metetra
.735 .212 0 r
.38655 .47967 .40249 .50717 .38161 .49635 .3663 .46639 Metetra
.758 .244 0 r
.3663 .46639 .38161 .49635 .36023 .48523 .34562 .45302 Metetra
.776 .27 0 r
.34562 .45302 .36023 .48523 .33834 .47381 .32448 .43961 Metetra
.789 .289 0 r
.32448 .43961 .33834 .47381 .31592 .46205 .30287 .4262 Metetra
.798 .303 0 r
.30287 .4262 .31592 .46205 .29295 .44995 .28074 .41283 Metetra
.803 .313 0 r
.28074 .41283 .29295 .44995 .26942 .43748 .25806 .39952 Metetra
.807 .318 .005 r
.25806 .39952 .26942 .43748 .24531 .42463 .23481 .38628 Metetra
.807 .32 .011 r
.23481 .38628 .24531 .42463 .2206 .41138 .21093 .37312 Metetra
.806 .318 .013 r
.21093 .37312 .2206 .41138 .19527 .39772 .1864 .36003 Metetra
.802 .312 .009 r
.1864 .36003 .19527 .39772 .16929 .38363 .16118 .347 Metetra
0 .335 .721 r
.65103 .63792 .67082 .64618 .65523 .6368 .63558 .62948 Metetra
0 .37 .751 r
.63558 .62948 .65523 .6368 .63936 .62771 .61982 .62092 Metetra
0 .389 .766 r
.61982 .62092 .63936 .62771 .6232 .61893 .60375 .61226 Metetra
0 .389 .765 r
.60375 .61226 .6232 .61893 .60673 .61046 .58735 .60348 Metetra
0 .373 .75 r
.58735 .60348 .60673 .61046 .58992 .6023 .57061 .59458 Metetra
0 .339 .718 r
.57061 .59458 .58992 .6023 .57276 .59443 .55352 .58556 Metetra
0 .29 .672 r
.55352 .58556 .57276 .59443 .55521 .5868 .53606 .57639 Metetra
.344 0 0 r
.53606 .57639 .55521 .5868 .53725 .57938 .51823 .56708 Metetra
.417 0 0 r
.51823 .56708 .53725 .57938 .51885 .57209 .5 .5576 Metetra
.488 0 0 r
.5 .5576 .51885 .57209 .5 .56488 .48137 .54794 Metetra
.553 0 0 r
.48137 .54794 .5 .56488 .48066 .55765 .46232 .53809 Metetra
.608 .045 0 r
.46232 .53809 .48066 .55765 .46081 .55032 .44283 .52802 Metetra
.654 .101 0 r
.44283 .52802 .46081 .55032 .44044 .5428 .42289 .51772 Metetra
.691 .149 0 r
.42289 .51772 .44044 .5428 .41952 .53499 .40249 .50717 Metetra
.721 .189 0 r
.40249 .50717 .41952 .53499 .39804 .52678 .38161 .49635 Metetra
.744 .222 0 r
.38161 .49635 .39804 .52678 .37599 .51808 .36023 .48523 Metetra
.762 .248 0 r
.36023 .48523 .37599 .51808 .35336 .5088 .33834 .47381 Metetra
.775 .268 0 r
.33834 .47381 .35336 .5088 .33015 .49884 .31592 .46205 Metetra
.785 .284 0 r
.31592 .46205 .33015 .49884 .30634 .48813 .29295 .44995 Metetra
.792 .295 0 r
.29295 .44995 .30634 .48813 .28194 .4766 .26942 .43748 Metetra
.797 .302 0 r
.26942 .43748 .28194 .4766 .25696 .4642 .24531 .42463 Metetra
.799 .306 0 r
.24531 .42463 .25696 .4642 .23138 .45088 .2206 .41138 Metetra
.799 .306 0 r
.2206 .41138 .23138 .45088 .2052 .43663 .19527 .39772 Metetra
.797 .303 0 r
.19527 .39772 .2052 .43663 .17844 .42143 .16929 .38363 Metetra
.05 .524 .889 r
.67082 .64618 .6909 .64994 .6752 .63981 .65523 .6368 Metetra
.072 .546 .899 r
.65523 .6368 .6752 .63981 .65926 .63027 .63936 .62771 Metetra
.079 .558 .9 r
.63936 .62771 .65926 .63027 .64305 .62135 .6232 .61893 Metetra
.069 .559 .894 r
.6232 .61893 .64305 .62135 .62654 .61307 .60673 .61046 Metetra
.043 .548 .878 r
.60673 .61046 .62654 .61307 .60971 .60541 .58992 .6023 Metetra
.001 .525 .852 r
.58992 .6023 .60971 .60541 .59253 .59834 .57276 .59443 Metetra
0 .488 .815 r
.57276 .59443 .59253 .59834 .57495 .59182 .55521 .5868 Metetra
0 .439 .766 r
.55521 .5868 .57495 .59182 .55694 .58577 .53725 .57938 Metetra
0 .38 .708 r
.53725 .57938 .55694 .58577 .53847 .58009 .51885 .57209 Metetra
.273 0 0 r
.51885 .57209 .53847 .58009 .5195 .57468 .5 .56488 Metetra
.347 0 0 r
.5 .56488 .5195 .57468 .5 .5694 .48066 .55765 Metetra
.414 0 0 r
.48066 .55765 .5 .5694 .47994 .56412 .46081 .55032 Metetra
.473 0 0 r
.46081 .55032 .47994 .56412 .45929 .55869 .44044 .5428 Metetra
.523 0 0 r
.44044 .5428 .45929 .55869 .43803 .55294 .41952 .53499 Metetra
.566 0 0 r
.41952 .53499 .43803 .55294 .41614 .54672 .39804 .52678 Metetra
.6 .03 0 r
.39804 .52678 .41614 .54672 .39362 .53986 .37599 .51808 Metetra
.629 .065 0 r
.37599 .51808 .39362 .53986 .37046 .5322 .35336 .5088 Metetra
.651 .094 0 r
.35336 .5088 .37046 .5322 .34665 .52361 .33015 .49884 Metetra
.668 .117 0 r
.33015 .49884 .34665 .52361 .32221 .51395 .30634 .48813 Metetra
.681 .134 0 r
.30634 .48813 .32221 .51395 .29715 .5031 .28194 .4766 Metetra
.69 .146 0 r
.28194 .4766 .29715 .5031 .27148 .49098 .25696 .4642 Metetra
.694 .154 0 r
.25696 .4642 .27148 .49098 .24521 .47754 .23138 .45088 Metetra
.695 .156 0 r
.23138 .45088 .24521 .47754 .21836 .46273 .2052 .43663 Metetra
.693 .153 0 r
.2052 .43663 .21836 .46273 .19095 .44656 .17844 .42143 Metetra
.427 .72 .986 r
.6909 .64994 .71085 .64593 .69512 .6354 .6752 .63981 Metetra
.431 .737 .991 r
.6752 .63981 .69512 .6354 .67917 .62557 .65926 .63027 Metetra
.429 .751 .994 r
.65926 .63027 .67917 .62557 .66296 .61648 .64305 .62135 Metetra
.422 .763 .996 r
.64305 .62135 .66296 .61648 .64648 .60815 .62654 .61307 Metetra
.41 .771 .995 r
.62654 .61307 .64648 .60815 .62968 .60055 .60971 .60541 Metetra
.392 .775 .991 r
.60971 .60541 .62968 .60055 .61252 .59367 .59253 .59834 Metetra
.369 .774 .983 r
.59253 .59834 .61252 .59367 .59498 .58744 .57495 .59182 Metetra
.34 .768 .972 r
.57495 .59182 .59498 .58744 .57701 .58177 .55694 .58577 Metetra
.307 .757 .959 r
.55694 .58577 .57701 .58177 .55856 .57657 .53847 .58009 Metetra
.271 .741 .943 r
.53847 .58009 .55856 .57657 .5396 .57171 .5195 .57468 Metetra
.233 .721 .926 r
.5195 .57468 .5396 .57171 .52009 .56703 .5 .5694 Metetra
.194 .697 .908 r
.5 .5694 .52009 .56703 .5 .5624 .47994 .56412 Metetra
.156 .672 .891 r
.47994 .56412 .5 .5624 .47929 .55762 .45929 .55869 Metetra
.119 .646 .875 r
.45929 .55869 .47929 .55762 .45795 .55251 .43803 .55294 Metetra
.085 .62 .861 r
.43803 .55294 .45795 .55251 .43595 .54689 .41614 .54672 Metetra
.054 .594 .85 r
.41614 .54672 .43595 .54689 .41328 .54058 .39362 .53986 Metetra
.027 .57 .841 r
.39362 .53986 .41328 .54058 .38993 .53338 .37046 .5322 Metetra
.004 .548 .835 r
.37046 .5322 .38993 .53338 .36591 .52513 .34665 .52361 Metetra
0 .528 .832 r
.34665 .52361 .36591 .52513 .34122 .51568 .32221 .51395 Metetra
0 .511 .831 r
.32221 .51395 .34122 .51568 .31589 .50489 .29715 .5031 Metetra
0 .496 .833 r
.29715 .5031 .31589 .50489 .28992 .49267 .27148 .49098 Metetra
0 .485 .836 r
.27148 .49098 .28992 .49267 .26334 .47895 .24521 .47754 Metetra
0 .478 .842 r
.24521 .47754 .26334 .47895 .23616 .46368 .21836 .46273 Metetra
0 .474 .849 r
.21836 .46273 .23616 .46368 .20842 .44687 .19095 .44656 Metetra
.677 .793 .936 r
.71085 .64593 .73031 .63281 .71467 .62229 .69512 .6354 Metetra
.678 .81 .946 r
.69512 .6354 .71467 .62229 .69878 .61237 .67917 .62557 Metetra
.679 .828 .955 r
.67917 .62557 .69878 .61237 .68265 .60307 .66296 .61648 Metetra
.683 .846 .961 r
.66296 .61648 .68265 .60307 .66623 .5944 .64648 .60815 Metetra
.688 .864 .965 r
.64648 .60815 .66623 .5944 .6495 .58635 .62968 .60055 Metetra
.696 .88 .967 r
.62968 .60055 .6495 .58635 .63242 .5789 .61252 .59367 Metetra
.705 .895 .966 r
.61252 .59367 .63242 .5789 .61496 .57198 .59498 .58744 Metetra
.716 .907 .963 r
.59498 .58744 .61496 .57198 .59707 .56552 .57701 .58177 Metetra
.728 .917 .958 r
.57701 .58177 .59707 .56552 .57872 .55943 .55856 .57657 Metetra
.741 .925 .952 r
.55856 .57657 .57872 .55943 .55988 .5536 .5396 .57171 Metetra
.754 .93 .946 r
.5396 .57171 .55988 .5536 .5405 .54789 .52009 .56703 Metetra
.768 .932 .939 r
.52009 .56703 .5405 .54789 .52055 .54217 .5 .5624 Metetra
.781 .931 .932 r
.5 .5624 .52055 .54217 .5 .53627 .47929 .55762 Metetra
.792 .928 .925 r
.47929 .55762 .5 .53627 .47883 .53004 .45795 .55251 Metetra
.801 .922 .918 r
.45795 .55251 .47883 .53004 .45701 .52332 .43595 .54689 Metetra
.809 .915 .911 r
.43595 .54689 .45701 .52332 .43453 .51592 .41328 .54058 Metetra
.814 .905 .904 r
.41328 .54058 .43453 .51592 .41139 .5077 .38993 .53338 Metetra
.816 .894 .898 r
.38993 .53338 .41139 .5077 .38757 .49851 .36591 .52513 Metetra
.817 .882 .892 r
.36591 .52513 .38757 .49851 .36308 .48822 .34122 .51568 Metetra
.815 .869 .887 r
.34122 .51568 .36308 .48822 .33793 .4767 .31589 .50489 Metetra
.811 .856 .882 r
.31589 .50489 .33793 .4767 .31213 .46388 .28992 .49267 Metetra
.805 .842 .879 r
.28992 .49267 .31213 .46388 .2857 .44967 .26334 .47895 Metetra
.798 .829 .876 r
.26334 .47895 .2857 .44967 .25864 .43407 .23616 .46368 Metetra
.789 .817 .874 r
.23616 .46368 .25864 .43407 .23097 .41705 .20842 .44687 Metetra
.79 .803 .863 r
.73031 .63281 .74916 .61159 .7337 .60146 .71467 .62229 Metetra
.79 .817 .874 r
.71467 .62229 .7337 .60146 .71797 .59161 .69878 .61237 Metetra
.793 .832 .882 r
.69878 .61237 .71797 .59161 .70196 .58206 .68265 .60307 Metetra
.799 .846 .886 r
.68265 .60307 .70196 .58206 .68565 .57282 .66623 .5944 Metetra
.808 .86 .887 r
.66623 .5944 .68565 .57282 .66901 .56386 .6495 .58635 Metetra
.82 .871 .883 r
.6495 .58635 .66901 .56386 .65202 .55518 .63242 .5789 Metetra
.834 .88 .876 r
.63242 .5789 .65202 .55518 .63465 .54673 .61496 .57198 Metetra
.849 .885 .865 r
.61496 .57198 .63465 .54673 .61687 .53846 .59707 .56552 Metetra
.864 .888 .851 r
.59707 .56552 .61687 .53846 .59865 .5303 .57872 .55943 Metetra
.879 .887 .835 r
.57872 .55943 .59865 .5303 .57996 .5222 .55988 .5536 Metetra
.891 .882 .818 r
.55988 .5536 .57996 .5222 .56078 .51405 .5405 .54789 Metetra
.902 .876 .801 r
.5405 .54789 .56078 .51405 .54108 .50577 .52055 .54217 Metetra
.91 .867 .784 r
.52055 .54217 .54108 .50577 .52083 .49726 .5 .53627 Metetra
.917 .858 .768 r
.5 .53627 .52083 .49726 .5 .48841 .47883 .53004 Metetra
.921 .847 .754 r
.47883 .53004 .5 .48841 .47858 .47913 .45701 .52332 Metetra
.923 .836 .741 r
.45701 .52332 .47858 .47913 .45655 .46931 .43453 .51592 Metetra
.924 .825 .73 r
.43453 .51592 .45655 .46931 .4339 .45885 .41139 .5077 Metetra
.924 .815 .72 r
.41139 .5077 .4339 .45885 .41061 .44766 .38757 .49851 Metetra
.922 .805 .713 r
.38757 .49851 .41061 .44766 .38667 .43565 .36308 .48822 Metetra
.92 .796 .707 r
.36308 .48822 .38667 .43565 .36209 .42276 .33793 .4767 Metetra
.917 .788 .703 r
.33793 .4767 .36209 .42276 .33685 .40892 .31213 .46388 Metetra
.913 .78 .701 r
.31213 .46388 .33685 .40892 .31096 .39409 .2857 .44967 Metetra
.908 .773 .7 r
.2857 .44967 .31096 .39409 .28441 .37825 .25864 .43407 Metetra
.903 .768 .702 r
.25864 .43407 .28441 .37825 .25719 .36139 .23097 .41705 Metetra
.836 .806 .822 r
.74916 .61159 .76756 .5854 .75236 .57586 .7337 .60146 Metetra
.834 .815 .832 r
.7337 .60146 .75236 .57586 .73683 .56618 .71797 .59161 Metetra
.835 .824 .838 r
.71797 .59161 .73683 .56618 .72098 .55636 .70196 .58206 Metetra
.839 .832 .84 r
.70196 .58206 .72098 .55636 .70479 .54639 .68565 .57282 Metetra
.846 .839 .838 r
.68565 .57282 .70479 .54639 .68825 .53627 .66901 .56386 Metetra
.855 .843 .832 r
.66901 .56386 .68825 .53627 .67134 .52598 .65202 .55518 Metetra
.867 .846 .821 r
.65202 .55518 .67134 .52598 .65404 .51551 .63465 .54673 Metetra
.879 .846 .807 r
.63465 .54673 .65404 .51551 .63635 .50485 .61687 .53846 Metetra
.891 .843 .79 r
.61687 .53846 .63635 .50485 .61825 .49398 .59865 .5303 Metetra
.902 .838 .772 r
.59865 .5303 .61825 .49398 .59972 .48288 .57996 .5222 Metetra
.912 .831 .753 r
.57996 .5222 .59972 .48288 .58074 .47154 .56078 .51405 Metetra
.919 .823 .735 r
.56078 .51405 .58074 .47154 .56129 .45993 .54108 .50577 Metetra
.925 .814 .717 r
.54108 .50577 .56129 .45993 .54137 .44804 .52083 .49726 Metetra
.929 .804 .701 r
.52083 .49726 .54137 .44804 .52094 .43584 .5 .48841 Metetra
.932 .795 .686 r
.5 .48841 .52094 .43584 .5 .4233 .47858 .47913 Metetra
.934 .787 .673 r
.47858 .47913 .5 .4233 .47852 .4104 .45655 .46931 Metetra
.935 .778 .663 r
.45655 .46931 .47852 .4104 .45648 .39713 .4339 .45885 Metetra
.935 .771 .654 r
.4339 .45885 .45648 .39713 .43386 .38346 .41061 .44766 Metetra
.935 .764 .647 r
.41061 .44766 .43386 .38346 .41065 .36936 .38667 .43565 Metetra
.934 .759 .642 r
.38667 .43565 .41065 .36936 .38682 .35481 .36209 .42276 Metetra
.932 .754 .638 r
.36209 .42276 .38682 .35481 .36234 .3398 .33685 .40892 Metetra
.93 .75 .636 r
.33685 .40892 .36234 .3398 .33721 .3243 .31096 .39409 Metetra
.928 .747 .636 r
.31096 .39409 .33721 .3243 .31138 .3083 .28441 .37825 Metetra
.926 .744 .638 r
.28441 .37825 .31138 .3083 .28483 .29178 .25719 .36139 Metetra
.848 .818 .82 r
.76756 .5854 .78596 .55846 .77104 .54953 .75236 .57586 Metetra
.842 .821 .828 r
.75236 .57586 .77104 .54953 .75574 .54003 .73683 .56618 Metetra
.839 .823 .833 r
.73683 .56618 .75574 .54003 .74005 .52993 .72098 .55636 Metetra
.84 .825 .833 r
.72098 .55636 .74005 .52993 .72398 .51922 .70479 .54639 Metetra
.843 .825 .83 r
.70479 .54639 .72398 .51922 .70752 .50791 .68825 .53627 Metetra
.85 .823 .822 r
.68825 .53627 .70752 .50791 .69066 .49599 .67134 .52598 Metetra
.858 .821 .811 r
.67134 .52598 .69066 .49599 .67342 .48348 .65404 .51551 Metetra
.868 .817 .797 r
.65404 .51551 .67342 .48348 .65578 .47042 .63635 .50485 Metetra
.878 .813 .78 r
.63635 .50485 .65578 .47042 .63774 .45683 .61825 .49398 Metetra
.888 .807 .762 r
.61825 .49398 .63774 .45683 .61931 .44276 .59972 .48288 Metetra
.897 .8 .744 r
.59972 .48288 .61931 .44276 .60048 .42826 .58074 .47154 Metetra
.905 .793 .726 r
.58074 .47154 .60048 .42826 .58124 .41338 .56129 .45993 Metetra
.912 .786 .709 r
.56129 .45993 .58124 .41338 .56159 .39819 .54137 .44804 Metetra
.917 .779 .693 r
.54137 .44804 .56159 .39819 .54151 .38272 .52094 .43584 Metetra
.921 .772 .679 r
.52094 .43584 .54151 .38272 .52099 .36705 .5 .4233 Metetra
.925 .766 .666 r
.5 .4233 .52099 .36705 .5 .35122 .47852 .4104 Metetra
.927 .761 .656 r
.47852 .4104 .5 .35122 .47853 .33527 .45648 .39713 Metetra
.929 .756 .647 r
.45648 .39713 .47853 .33527 .45654 .31924 .43386 .38346 Metetra
.93 .753 .64 r
.43386 .38346 .45654 .31924 .43401 .30317 .41065 .36936 Metetra
.931 .75 .635 r
.41065 .36936 .43401 .30317 .4109 .28707 .38682 .35481 Metetra
.932 .748 .631 r
.38682 .35481 .4109 .28707 .38717 .27096 .36234 .3398 Metetra
.932 .747 .63 r
.36234 .3398 .38717 .27096 .36278 .25483 .33721 .3243 Metetra
.932 .746 .63 r
.33721 .3243 .36278 .25483 .33769 .23867 .31138 .3083 Metetra
.931 .747 .632 r
.31138 .3083 .33769 .23867 .31184 .22246 .28483 .29178 Metetra
.827 .841 .858 r
.78596 .55846 .80497 .53503 .79031 .52651 .77104 .54953 Metetra
.817 .836 .864 r
.77104 .54953 .79031 .52651 .77521 .51709 .75574 .54003 Metetra
.81 .83 .866 r
.75574 .54003 .77521 .51709 .75967 .50672 .74005 .52993 Metetra
.807 .823 .864 r
.74005 .52993 .75967 .50672 .7437 .49539 .72398 .51922 Metetra
.807 .817 .859 r
.72398 .51922 .7437 .49539 .7273 .4831 .70752 .50791 Metetra
.81 .81 .851 r
.70752 .50791 .7273 .4831 .71048 .46986 .69066 .49599 Metetra
.816 .804 .84 r
.69066 .49599 .71048 .46986 .69325 .45571 .67342 .48348 Metetra
.824 .798 .827 r
.67342 .48348 .69325 .45571 .67562 .44074 .65578 .47042 Metetra
.833 .792 .813 r
.65578 .47042 .67562 .44074 .65761 .425 .63774 .45683 Metetra
.843 .787 .797 r
.63774 .45683 .65761 .425 .63922 .4086 .61931 .44276 Metetra
.853 .782 .782 r
.61931 .44276 .63922 .4086 .62046 .39164 .60048 .42826 Metetra
.863 .778 .766 r
.60048 .42826 .62046 .39164 .60134 .37423 .58124 .41338 Metetra
.872 .774 .75 r
.58124 .41338 .60134 .37423 .58185 .35648 .56159 .39819 Metetra
.88 .77 .736 r
.56159 .39819 .58185 .35648 .56198 .33852 .54151 .38272 Metetra
.888 .767 .723 r
.54151 .38272 .56198 .33852 .54173 .32045 .52099 .36705 Metetra
.895 .765 .711 r
.52099 .36705 .54173 .32045 .52108 .30237 .5 .35122 Metetra
.901 .764 .701 r
.5 .35122 .52108 .30237 .5 .28439 .47853 .33527 Metetra
.906 .763 .692 r
.47853 .33527 .5 .28439 .47846 .26656 .45654 .31924 Metetra
.91 .763 .686 r
.45654 .31924 .47846 .26656 .45641 .24897 .43401 .30317 Metetra
.914 .764 .68 r
.43401 .30317 .45641 .24897 .43383 .23166 .4109 .28707 Metetra
.917 .765 .677 r
.4109 .28707 .43383 .23166 .41065 .21466 .38717 .27096 Metetra
.92 .767 .676 r
.38717 .27096 .41065 .21466 .38682 .19797 .36278 .25483 Metetra
.922 .77 .676 r
.36278 .25483 .38682 .19797 .36228 .18159 .33769 .23867 Metetra
.923 .774 .678 r
.33769 .23867 .36228 .18159 .33698 .16548 .31184 .22246 Metetra
.743 .858 .934 r
.80497 .53503 .82526 .51833 .81078 .50991 .79031 .52651 Metetra
.733 .844 .933 r
.79031 .52651 .81078 .50991 .79582 .50041 .77521 .51709 Metetra
.725 .829 .929 r
.77521 .51709 .79582 .50041 .78039 .48979 .75967 .50672 Metetra
.72 .815 .924 r
.75967 .50672 .78039 .48979 .76449 .47803 .7437 .49539 Metetra
.718 .802 .917 r
.7437 .49539 .76449 .47803 .74814 .46512 .7273 .4831 Metetra
.718 .79 .909 r
.7273 .4831 .74814 .46512 .73134 .4511 .71048 .46986 Metetra
.72 .78 .9 r
.71048 .46986 .73134 .4511 .71412 .43602 .69325 .45571 Metetra
.725 .772 .89 r
.69325 .45571 .71412 .43602 .69649 .41997 .67562 .44074 Metetra
.731 .766 .881 r
.67562 .44074 .69649 .41997 .67847 .40304 .65761 .425 Metetra
.739 .761 .871 r
.65761 .425 .67847 .40304 .66007 .38536 .63922 .4086 Metetra
.748 .759 .861 r
.63922 .4086 .66007 .38536 .64132 .36705 .62046 .39164 Metetra
.758 .758 .852 r
.62046 .39164 .64132 .36705 .62222 .34826 .60134 .37423 Metetra
.769 .758 .844 r
.60134 .37423 .62222 .34826 .60277 .32913 .58185 .35648 Metetra
.78 .761 .836 r
.58185 .35648 .60277 .32913 .58297 .30981 .56198 .33852 Metetra
.791 .764 .829 r
.56198 .33852 .58297 .30981 .56282 .29042 .54173 .32045 Metetra
.802 .769 .822 r
.54173 .32045 .56282 .29042 .54229 .27109 .52108 .30237 Metetra
.812 .774 .817 r
.52108 .30237 .54229 .27109 .52136 .25195 .5 .28439 Metetra
.822 .78 .813 r
.5 .28439 .52136 .25195 .5 .23309 .47846 .26656 Metetra
.832 .787 .81 r
.47846 .26656 .5 .23309 .47816 .21458 .45641 .24897 Metetra
.84 .795 .808 r
.45641 .24897 .47816 .21458 .45581 .19648 .43383 .23166 Metetra
.847 .803 .807 r
.43383 .23166 .45581 .19648 .43287 .17884 .41065 .21466 Metetra
.854 .811 .808 r
.41065 .21466 .43287 .17884 .40929 .16166 .38682 .19797 Metetra
.858 .819 .809 r
.38682 .19797 .40929 .16166 .38502 .14492 .36228 .18159 Metetra
.862 .828 .812 r
.36228 .18159 .38502 .14492 .35996 .1286 .33698 .16548 Metetra
.536 .813 .997 r
.82526 .51833 .84735 .50999 .83294 .50127 .81078 .50991 Metetra
.543 .799 .992 r
.81078 .50991 .83294 .50127 .81805 .49151 .79582 .50041 Metetra
.546 .783 .986 r
.79582 .50041 .81805 .49151 .80269 .48066 .78039 .48979 Metetra
.547 .767 .979 r
.78039 .48979 .80269 .48066 .78684 .4687 .76449 .47803 Metetra
.545 .75 .972 r
.76449 .47803 .78684 .4687 .77053 .45563 .74814 .46512 Metetra
.541 .734 .964 r
.74814 .46512 .77053 .45563 .75377 .44148 .73134 .4511 Metetra
.536 .719 .957 r
.73134 .4511 .75377 .44148 .73657 .4263 .71412 .43602 Metetra
.53 .706 .952 r
.71412 .43602 .73657 .4263 .71895 .41016 .69649 .41997 Metetra
.523 .694 .947 r
.69649 .41997 .71895 .41016 .70093 .39317 .67847 .40304 Metetra
.515 .684 .943 r
.67847 .40304 .70093 .39317 .68253 .37544 .66007 .38536 Metetra
.507 .677 .941 r
.66007 .38536 .68253 .37544 .66375 .35708 .64132 .36705 Metetra
.5 .671 .94 r
.64132 .36705 .66375 .35708 .6446 .33824 .62222 .34826 Metetra
.493 .668 .941 r
.62222 .34826 .6446 .33824 .6251 .31904 .60277 .32913 Metetra
.486 .668 .944 r
.60277 .32913 .6251 .31904 .60525 .29963 .58297 .30981 Metetra
.479 .67 .947 r
.58297 .30981 .60525 .29963 .58502 .28012 .56282 .29042 Metetra
.474 .674 .952 r
.56282 .29042 .58502 .28012 .56441 .26065 .54229 .27109 Metetra
.47 .68 .957 r
.54229 .27109 .56441 .26065 .54339 .24133 .52136 .25195 Metetra
.467 .689 .963 r
.52136 .25195 .54339 .24133 .52194 .22223 .5 .23309 Metetra
.465 .7 .97 r
.5 .23309 .52194 .22223 .5 .20344 .47816 .21458 Metetra
.464 .712 .976 r
.47816 .21458 .5 .20344 .47754 .18501 .45581 .19648 Metetra
.465 .725 .982 r
.45581 .19648 .47754 .18501 .4545 .16697 .43287 .17884 Metetra
.468 .739 .987 r
.43287 .17884 .4545 .16697 .43082 .14933 .40929 .16166 Metetra
.472 .753 .991 r
.40929 .16166 .43082 .14933 .40644 .13208 .38502 .14492 Metetra
.478 .768 .995 r
.38502 .14492 .40644 .13208 .38128 .11517 .35996 .1286 Metetra
.232 .658 .958 r
.84735 .50999 .87152 .50971 .85707 .50031 .83294 .50127 Metetra
.268 .664 .968 r
.83294 .50127 .85707 .50031 .84217 .4901 .81805 .49151 Metetra
.29 .663 .971 r
.81805 .49151 .84217 .4901 .82682 .47904 .80269 .48066 Metetra
.301 .654 .97 r
.80269 .48066 .82682 .47904 .81102 .46711 .78684 .4687 Metetra
.301 .639 .966 r
.78684 .4687 .81102 .46711 .79478 .45431 .77053 .45563 Metetra
.291 .62 .959 r
.77053 .45563 .79478 .45431 .77809 .44066 .75377 .44148 Metetra
.271 .597 .95 r
.75377 .44148 .77809 .44066 .76097 .42619 .73657 .4263 Metetra
.244 .571 .94 r
.73657 .4263 .76097 .42619 .74342 .41094 .71895 .41016 Metetra
.209 .543 .928 r
.71895 .41016 .74342 .41094 .72545 .39499 .70093 .39317 Metetra
.167 .512 .914 r
.70093 .39317 .72545 .39499 .70707 .3784 .68253 .37544 Metetra
.121 .48 .898 r
.68253 .37544 .70707 .3784 .68828 .36125 .66375 .35708 Metetra
.07 .446 .879 r
.66375 .35708 .68828 .36125 .6691 .34365 .6446 .33824 Metetra
.017 .411 .858 r
.6446 .33824 .6691 .34365 .64951 .32568 .6251 .31904 Metetra
0 .377 .834 r
.6251 .31904 .64951 .32568 .62952 .30743 .60525 .29963 Metetra
0 .343 .809 r
.60525 .29963 .62952 .30743 .6091 .289 .58502 .28012 Metetra
0 .312 .782 r
.58502 .28012 .6091 .289 .58826 .27046 .56441 .26065 Metetra
0 .284 .756 r
.56441 .26065 .58826 .27046 .56696 .25189 .54339 .24133 Metetra
0 .26 .731 r
.54339 .24133 .56696 .25189 .54517 .23335 .52194 .22223 Metetra
0 .242 .708 r
.52194 .22223 .54517 .23335 .52287 .21489 .5 .20344 Metetra
0 .229 .689 r
.5 .20344 .52287 .21489 .5 .19656 .47754 .18501 Metetra
0 .222 .675 r
.47754 .18501 .5 .19656 .47653 .17835 .4545 .16697 Metetra
0 .221 .666 r
.4545 .16697 .47653 .17835 .4524 .16028 .43082 .14933 Metetra
0 .227 .662 r
.43082 .14933 .4524 .16028 .42755 .14234 .40644 .13208 Metetra
0 .239 .664 r
.40644 .13208 .42755 .14234 .40193 .12447 .38128 .11517 Metetra
.013 .503 .871 r
.87152 .50971 .89766 .51534 .88307 .50497 .85707 .50031 Metetra
.058 .526 .893 r
.85707 .50031 .88307 .50497 .8681 .49416 .84217 .4901 Metetra
.087 .536 .906 r
.84217 .4901 .8681 .49416 .85275 .4829 .82682 .47904 Metetra
.099 .535 .911 r
.82682 .47904 .85275 .4829 .83701 .47117 .81102 .46711 Metetra
.095 .523 .908 r
.81102 .46711 .83701 .47117 .82086 .45897 .79478 .45431 Metetra
.076 .501 .898 r
.79478 .45431 .82086 .45897 .80431 .4463 .77809 .44066 Metetra
.042 .471 .882 r
.77809 .44066 .80431 .4463 .78734 .43316 .76097 .42619 Metetra
0 .433 .86 r
.76097 .42619 .78734 .43316 .76994 .41955 .74342 .41094 Metetra
0 .388 .831 r
.74342 .41094 .76994 .41955 .75212 .40549 .72545 .39499 Metetra
0 .338 .796 r
.72545 .39499 .75212 .40549 .73386 .391 .70707 .3784 Metetra
0 .285 .755 r
.70707 .3784 .73386 .391 .71515 .37608 .68828 .36125 Metetra
0 .232 .71 r
.68828 .36125 .71515 .37608 .69598 .36077 .6691 .34365 Metetra
0 .179 .663 r
.6691 .34365 .69598 .36077 .67634 .34509 .64951 .32568 Metetra
0 .13 .615 r
.64951 .32568 .67634 .34509 .65622 .32905 .62952 .30743 Metetra
0 .085 .569 r
.62952 .30743 .65622 .32905 .63559 .31267 .6091 .289 Metetra
.472 0 0 r
.6091 .289 .63559 .31267 .61445 .29598 .58826 .27046 Metetra
.509 0 0 r
.58826 .27046 .61445 .29598 .59276 .27898 .56696 .25189 Metetra
.539 .013 0 r
.56696 .25189 .59276 .27898 .5705 .2617 .54517 .23335 Metetra
.562 .034 0 r
.54517 .23335 .5705 .2617 .54764 .24412 .52287 .21489 Metetra
.578 .048 0 r
.52287 .21489 .54764 .24412 .52415 .22626 .5 .19656 Metetra
.589 .056 0 r
.5 .19656 .52415 .22626 .5 .2081 .47653 .17835 Metetra
.595 .059 0 r
.47653 .17835 .5 .2081 .47514 .18963 .4524 .16028 Metetra
.595 .056 0 r
.4524 .16028 .47514 .18963 .44954 .17084 .42755 .14234 Metetra
.59 .048 0 r
.42755 .14234 .44954 .17084 .42315 .15168 .40193 .12447 Metetra
0 .454 .847 r
.89766 .51534 .92525 .52314 .91047 .51166 .88307 .50497 Metetra
.002 .479 .867 r
.88307 .50497 .91047 .51166 .89541 .50019 .8681 .49416 Metetra
.024 .492 .878 r
.8681 .49416 .89541 .50019 .88006 .48874 .85275 .4829 Metetra
.029 .492 .88 r
.85275 .4829 .88006 .48874 .86439 .47728 .83701 .47117 Metetra
.018 .481 .875 r
.83701 .47117 .86439 .47728 .84839 .46583 .82086 .45897 Metetra
0 .459 .861 r
.82086 .45897 .84839 .46583 .83203 .45434 .80431 .4463 Metetra
0 .426 .839 r
.80431 .4463 .83203 .45434 .8153 .44281 .78734 .43316 Metetra
0 .383 .809 r
.78734 .43316 .8153 .44281 .79816 .43118 .76994 .41955 Metetra
0 .333 .771 r
.76994 .41955 .79816 .43118 .78059 .41942 .75212 .40549 Metetra
0 .278 .726 r
.75212 .40549 .78059 .41942 .76256 .40748 .73386 .391 Metetra
0 .221 .676 r
.73386 .391 .76256 .40748 .74404 .39531 .71515 .37608 Metetra
0 .164 .624 r
.71515 .37608 .74404 .39531 .72501 .38284 .69598 .36077 Metetra
0 .111 .572 r
.69598 .36077 .72501 .38284 .70542 .37001 .67634 .34509 Metetra
.471 0 0 r
.67634 .34509 .70542 .37001 .68526 .35675 .65622 .32905 Metetra
.514 0 0 r
.65622 .32905 .68526 .35675 .66449 .34301 .63559 .31267 Metetra
.551 .017 0 r
.63559 .31267 .66449 .34301 .64309 .3287 .61445 .29598 Metetra
.58 .048 0 r
.61445 .29598 .64309 .3287 .62103 .31378 .59276 .27898 Metetra
.603 .072 0 r
.59276 .27898 .62103 .31378 .59828 .29817 .5705 .2617 Metetra
.621 .091 0 r
.5705 .2617 .59828 .29817 .57483 .28182 .54764 .24412 Metetra
.633 .104 0 r
.54764 .24412 .57483 .28182 .55065 .26469 .52415 .22626 Metetra
.641 .113 0 r
.52415 .22626 .55065 .26469 .52571 .24672 .5 .2081 Metetra
.645 .116 0 r
.5 .2081 .52571 .24672 .5 .22787 .47514 .18963 Metetra
.645 .115 0 r
.47514 .18963 .5 .22787 .47349 .20813 .44954 .17084 Metetra
.641 .11 0 r
.44954 .17084 .47349 .20813 .44617 .18746 .42315 .15168 Metetra
.075 .518 .9 r
.92525 .52314 .9534 .52857 .93845 .51607 .91047 .51166 Metetra
.098 .539 .911 r
.91047 .51166 .93845 .51607 .92333 .50397 .89541 .50019 Metetra
.109 .55 .915 r
.89541 .50019 .92333 .50397 .908 .4923 .88006 .48874 Metetra
.105 .552 .914 r
.88006 .48874 .908 .4923 .89244 .48106 .86439 .47728 Metetra
.087 .543 .906 r
.86439 .47728 .89244 .48106 .87662 .47023 .84839 .46583 Metetra
.056 .525 .892 r
.84839 .46583 .87662 .47023 .86051 .45978 .83203 .45434 Metetra
.012 .497 .871 r
.83203 .45434 .86051 .45978 .84407 .44966 .8153 .44281 Metetra
0 .459 .842 r
.8153 .44281 .84407 .44966 .82725 .4398 .79816 .43118 Metetra
0 .413 .806 r
.79816 .43118 .82725 .4398 .81001 .43011 .78059 .41942 Metetra
0 .362 .764 r
.78059 .41942 .81001 .43011 .7923 .42049 .76256 .40748 Metetra
0 .307 .717 r
.76256 .40748 .7923 .42049 .77408 .41082 .74404 .39531 Metetra
0 .253 .67 r
.74404 .39531 .77408 .41082 .75529 .40096 .72501 .38284 Metetra
0 .2 .622 r
.72501 .38284 .75529 .40096 .73588 .39078 .70542 .37001 Metetra
.403 0 0 r
.70542 .37001 .73588 .39078 .71581 .38013 .68526 .35675 Metetra
.446 0 0 r
.68526 .35675 .71581 .38013 .69504 .36886 .66449 .34301 Metetra
.482 0 0 r
.66449 .34301 .69504 .36886 .67352 .35682 .64309 .3287 Metetra
.512 0 0 r
.64309 .3287 .67352 .35682 .65123 .34387 .62103 .31378 Metetra
.535 0 0 r
.62103 .31378 .65123 .34387 .62813 .32987 .59828 .29817 Metetra
.553 .009 0 r
.59828 .29817 .62813 .32987 .60421 .3147 .57483 .28182 Metetra
.566 .024 0 r
.57483 .28182 .60421 .3147 .57945 .29826 .55065 .26469 Metetra
.574 .035 0 r
.55065 .26469 .57945 .29826 .55383 .28045 .52571 .24672 Metetra
.578 .04 0 r
.52571 .24672 .55383 .28045 .52734 .26122 .5 .22787 Metetra
.577 .041 0 r
.5 .22787 .52734 .26122 .5 .24052 .47349 .20813 Metetra
.572 .037 0 r
.47349 .20813 .5 .24052 .47179 .21834 .44617 .18746 Metetra
.307 .65 .969 r
.9534 .52857 .98103 .52737 .96603 .51412 .93845 .51607 Metetra
.315 .666 .974 r
.93845 .51607 .96603 .51412 .9509 .50153 .92333 .50397 Metetra
.316 .679 .977 r
.92333 .50397 .9509 .50153 .93564 .48961 .908 .4923 Metetra
.308 .686 .977 r
.908 .4923 .93564 .48961 .92022 .47837 .89244 .48106 Metetra
.293 .688 .974 r
.89244 .48106 .92022 .47837 .9046 .46781 .87662 .47023 Metetra
.269 .684 .968 r
.87662 .47023 .9046 .46781 .88873 .45788 .86051 .45978 Metetra
.236 .672 .958 r
.86051 .45978 .88873 .45788 .87257 .44851 .84407 .44966 Metetra
.197 .654 .943 r
.84407 .44966 .87257 .44851 .85607 .43962 .82725 .4398 Metetra
.151 .63 .924 r
.82725 .4398 .85607 .43962 .83916 .43109 .81001 .43011 Metetra
.102 .599 .901 r
.81001 .43011 .83916 .43109 .82179 .42277 .7923 .42049 Metetra
.05 .564 .876 r
.7923 .42049 .82179 .42277 .80389 .41453 .77408 .41082 Metetra
0 .526 .849 r
.77408 .41082 .80389 .41453 .7854 .40618 .75529 .40096 Metetra
0 .487 .821 r
.75529 .40096 .7854 .40618 .76625 .39753 .73588 .39078 Metetra
0 .448 .794 r
.73588 .39078 .76625 .39753 .74638 .38838 .71581 .38013 Metetra
0 .411 .769 r
.71581 .38013 .74638 .38838 .72575 .37854 .69504 .36886 Metetra
0 .376 .747 r
.69504 .36886 .72575 .37854 .7043 .3678 .67352 .35682 Metetra
0 .345 .728 r
.67352 .35682 .7043 .3678 .68198 .35595 .65123 .34387 Metetra
0 .318 .712 r
.65123 .34387 .68198 .35595 .65878 .34282 .62813 .32987 Metetra
0 .295 .7 r
.62813 .32987 .65878 .34282 .63465 .32823 .60421 .3147 Metetra
0 .277 .692 r
.60421 .3147 .63465 .32823 .60959 .31203 .57945 .29826 Metetra
0 .263 .688 r
.57945 .29826 .60959 .31203 .58359 .29411 .55383 .28045 Metetra
0 .254 .688 r
.55383 .28045 .58359 .29411 .55665 .27439 .52734 .26122 Metetra
0 .25 .691 r
.52734 .26122 .55665 .27439 .52879 .25282 .5 .24052 Metetra
0 .251 .698 r
.5 .24052 .52879 .25282 .5 .22938 .47179 .21834 Metetra
0 g
.25 Mabswid
.05263 .38743 m
.5 0 L
s
.5 0 m
.5 .24537 L
s
.5 .24537 m
0 .60622 L
s
0 .60622 m
.05263 .38743 L
s
.94737 .38743 m
.5 0 L
s
.5 0 m
.5 .24537 L
s
.5 .24537 m
1 .60622 L
s
1 .60622 m
.94737 .38743 L
s
.94737 .38743 m
.5 0 L
s
.94737 .38743 m
.94179 .39025 L
s
[(-2)] .95853 .3818 -1 .50518 Mshowa
.85915 .31104 m
.85371 .31411 L
s
[(-1)] .87004 .3049 -1 .56392 Mshowa
.75758 .22307 m
.75231 .22643 L
s
[(0)] .76811 .21634 -1 .63812 Mshowa
.63934 .12068 m
.63431 .12438 L
s
[(1)] .64942 .11327 -1 .73481 Mshowa
.5 0 m
.49528 .00409 L
s
[(2)] .50945 -0.00818 -1 .86603 Mshowa
.125 Mabswid
.93067 .37297 m
.92733 .37469 L
s
.91351 .35811 m
.9102 .35986 L
s
.89589 .34285 m
.89259 .34463 L
s
.87778 .32717 m
.87449 .32898 L
s
.84 .29445 m
.83675 .29632 L
s
.82029 .27738 m
.81706 .27929 L
s
.8 .25981 m
.79679 .26175 L
s
.7791 .24171 m
.77592 .24369 L
s
.73538 .20385 m
.73225 .2059 L
s
.7125 .18403 m
.70939 .18613 L
s
.68889 .16358 m
.68581 .16572 L
s
.66452 .14248 m
.66146 .14465 L
s
.61333 .09815 m
.61034 .10041 L
s
.58644 .07486 m
.58349 .07717 L
s
.55862 .05077 m
.5557 .05312 L
s
.52982 .02583 m
.52695 .02823 L
s
gsave
.8208 .18272 -61 -12.0371 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.05263 .38743 m
0 .60622 L
s
.04408 .423 m
.0497 .42573 L
s
[(-2)] .03284 .41753 1 .48668 Mshowa
.0279 .49023 m
.0336 .4928 L
s
[(0)] .01651 .48508 1 .45211 Mshowa
.01054 .5624 m
.01631 .56479 L
s
[(2)] -0.001 .5576 1 .41556 Mshowa
.125 Mabswid
.04014 .43937 m
.04352 .44099 L
s
.03613 .45603 m
.03952 .45762 L
s
.03205 .47298 m
.03546 .47455 L
s
.02368 .50778 m
.02711 .5093 L
s
.01938 .52566 m
.02282 .52715 L
s
.015 .54386 m
.01845 .54533 L
s
.04795 .40691 m
.05131 .40857 L
s
.05175 .39108 m
.0551 .39277 L
s
.006 .58128 m
.00947 .58269 L
s
.00137 .60051 m
.00486 .60189 L
s
gsave
-0.04057 .45987 -71 -11.1231 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell["\<\
As you move away from the box, the perspective effect gets smaller. \
\
\>", "MathCaption",
  CellTags->{"S2.10.10", "10.17"}],

Cell[CellGroupData[{

Cell["Show[surf, ViewPoint -> {5, 5, 5}]", "Input",
  CellLabel->"In[9]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .79979 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.03812e-17 1 -0.0787783 1 [
[.99777 .30272 0 -7.00185 ]
[.99777 .30272 12 1.99815 ]
[.88208 .22925 0 -7.08153 ]
[.88208 .22925 12 1.91847 ]
[.76245 .15327 0 -7.16645 ]
[.76245 .15327 6 1.83355 ]
[.63869 .07467 0 -7.25714 ]
[.63869 .07467 6 1.74286 ]
[.51056 -0.0067 0 -7.35422 ]
[.51056 -0.0067 6 1.64578 ]
[.81622 .12141 0 -7.81342 ]
[.81622 .12141 10 1.99908 ]
[.07893 .25401 -12 -7.05441 ]
[.07893 .25401 0 1.94559 ]
[.23755 .15327 -6 -7.16645 ]
[.23755 .15327 0 1.83355 ]
[.40353 .04787 -6 -7.28876 ]
[.40353 .04787 0 1.71124 ]
[.18378 .12141 -10.0625 -7.81342 ]
[.18378 .12141 0 1.99908 ]
[1.00009 .34251 0 -6.97845 ]
[1.00009 .34251 12 2.02155 ]
[1.00429 .41473 0 -6.93602 ]
[1.00429 .41473 6 2.06398 ]
[1.00857 .48818 0 -6.8929 ]
[1.00857 .48818 6 2.1071 ]
[1.05929 .38552 0 -7.56184 ]
[1.05929 .38552 10 2.25066 ]
[ 0 0 0 0 ]
[ 1 .79979 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.98684 .30879 m
.5 0 L
s
.98684 .30879 m
.98138 .31183 L
s
[(-2)] .99777 .30272 -1 .55597 Mshowa
.87124 .23547 m
.86582 .23858 L
s
[(-1)] .88208 .22925 -1 .57367 Mshowa
.7517 .15965 m
.74632 .16283 L
s
[(0)] .76245 .15327 -1 .59254 Mshowa
.62803 .0812 m
.6227 .08447 L
s
[(1)] .63869 .07467 -1 .6127 Mshowa
.5 0 m
.49472 .00335 L
s
[(2)] .51056 -0.0067 -1 .63427 Mshowa
.125 Mabswid
.96403 .29432 m
.96075 .29615 L
s
.94106 .27975 m
.93779 .28159 L
s
.91794 .26509 m
.91468 .26694 L
s
.89467 .25033 m
.89141 .25218 L
s
.84765 .22051 m
.8444 .22238 L
s
.82391 .20544 m
.82066 .20733 L
s
.8 .19028 m
.79676 .19217 L
s
.77593 .17502 m
.7727 .17692 L
s
.7273 .14417 m
.72408 .14609 L
s
.70274 .12859 m
.69952 .13052 L
s
.67801 .1129 m
.6748 .11484 L
s
.6531 .09711 m
.6499 .09906 L
s
.60278 .06519 m
.59959 .06716 L
s
.57735 .04906 m
.57417 .05104 L
s
.55175 .03282 m
.54857 .03481 L
s
.52596 .01647 m
.52279 .01847 L
s
gsave
.81622 .12141 -61 -11.8134 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.01316 .30879 m
.5 0 L
s
.0898 .26018 m
.09524 .26326 L
s
[(-2)] .07893 .25401 1 .56765 Mshowa
.2483 .15965 m
.25368 .16283 L
s
[(0)] .23755 .15327 1 .59254 Mshowa
.41415 .05445 m
.41947 .05774 L
s
[(2)] .40353 .04787 1 .61972 Mshowa
.125 Mabswid
.12876 .23547 m
.13202 .23733 L
s
.16816 .21048 m
.17141 .21236 L
s
.208 .1852 m
.21124 .1871 L
s
.28905 .1338 m
.29227 .13572 L
s
.33028 .10765 m
.33348 .10959 L
s
.37197 .0812 m
.37517 .08316 L
s
.05127 .28462 m
.05454 .28645 L
s
.45683 .02738 m
.46 .02938 L
s
gsave
.18378 .12141 -71.0625 -11.8134 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.98684 .30879 m
1 .53669 L
s
.98914 .34854 m
.98366 .35155 L
s
[(-2)] 1.00009 .34251 -1 .55077 Mshowa
.9933 .42068 m
.98781 .42365 L
s
[(0)] 1.00429 .41473 -1 .54134 Mshowa
.99754 .49405 m
.99202 .49699 L
s
[(2)] 1.00857 .48818 -1 .53176 Mshowa
.125 Mabswid
.99017 .36646 m
.98688 .36826 L
s
.99121 .38445 m
.98792 .38625 L
s
.99225 .40253 m
.98896 .40432 L
s
.99435 .4389 m
.99105 .44068 L
s
.99541 .45721 m
.99211 .45898 L
s
.99647 .47559 m
.99316 .47736 L
s
.98811 .33069 m
.98483 .33251 L
s
.98708 .31292 m
.9838 .31475 L
s
.99861 .51259 m
.99529 .51435 L
s
.99968 .53122 m
.99637 .53296 L
s
gsave
1.05929 .38552 -61 -11.5618 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.5 .57946 m
.5 .79979 L
s
.5 .79979 m
1 .53669 L
s
1 .53669 m
.98684 .30879 L
s
.98684 .30879 m
.5 .57946 L
s
.01316 .30879 m
.5 0 L
s
.5 0 m
.5 .23547 L
s
.5 .23547 m
0 .53669 L
s
0 .53669 m
.01316 .30879 L
s
.5 .57946 m
.5 .79979 L
s
.5 .79979 m
0 .53669 L
s
0 .53669 m
.01316 .30879 L
s
.01316 .30879 m
.5 .57946 L
s
.98684 .30879 m
.5 0 L
s
.5 0 m
.5 .23547 L
s
.5 .23547 m
1 .53669 L
s
1 .53669 m
.98684 .30879 L
s
0 0 m
1 0 L
1 .79979 L
0 .79979 L
closepath
clip
newpath
.5 Mabswid
.726 .639 .76 r
.5 .7247 .51938 .70457 .5 .69267 .4806 .71237 Metetra
.728 .644 .765 r
.4806 .71237 .5 .69267 .48052 .68139 .46111 .7009 Metetra
.731 .65 .769 r
.46111 .7009 .48052 .68139 .46094 .67075 .44151 .69031 Metetra
.734 .656 .772 r
.44151 .69031 .46094 .67075 .44126 .66075 .4218 .68061 Metetra
.738 .661 .774 r
.4218 .68061 .44126 .66075 .42145 .65138 .40197 .67178 Metetra
.742 .666 .776 r
.40197 .67178 .42145 .65138 .40153 .6426 .38201 .66377 Metetra
.747 .67 .776 r
.38201 .66377 .40153 .6426 .38149 .63436 .36193 .65652 Metetra
.751 .673 .774 r
.36193 .65652 .38149 .63436 .36132 .6266 .34171 .64993 Metetra
.755 .674 .772 r
.34171 .64993 .36132 .6266 .34102 .61922 .32134 .6439 Metetra
.759 .675 .769 r
.32134 .6439 .34102 .61922 .32058 .61214 .30084 .63829 Metetra
.762 .674 .765 r
.30084 .63829 .32058 .61214 .30002 .60525 .28019 .63295 Metetra
.764 .672 .76 r
.28019 .63295 .30002 .60525 .27931 .59843 .2594 .62774 Metetra
.766 .669 .756 r
.2594 .62774 .27931 .59843 .25848 .59157 .23847 .6225 Metetra
.767 .666 .751 r
.23847 .6225 .25848 .59157 .23751 .58454 .2174 .61706 Metetra
.767 .662 .747 r
.2174 .61706 .23751 .58454 .21642 .57723 .1962 .61126 Metetra
.766 .658 .743 r
.1962 .61126 .21642 .57723 .1952 .56954 .17488 .60495 Metetra
.766 .654 .739 r
.17488 .60495 .1952 .56954 .17387 .56134 .15343 .598 Metetra
.764 .65 .735 r
.15343 .598 .17387 .56134 .15243 .55257 .13188 .59028 Metetra
.763 .646 .733 r
.13188 .59028 .15243 .55257 .13087 .54313 .11023 .58167 Metetra
.761 .642 .73 r
.11023 .58167 .13087 .54313 .10922 .53297 .08849 .57211 Metetra
.759 .638 .728 r
.08849 .57211 .10922 .53297 .08748 .52204 .06666 .56153 Metetra
.756 .635 .727 r
.06666 .56153 .08748 .52204 .06564 .51032 .04476 .5499 Metetra
.754 .632 .725 r
.04476 .5499 .06564 .51032 .04372 .49782 .02279 .53722 Metetra
.751 .629 .725 r
.02279 .53722 .04372 .49782 .02173 .48454 .00076 .52351 Metetra
.74 .636 .744 r
.51938 .70457 .53879 .67767 .51944 .66655 .5 .69267 Metetra
.741 .64 .747 r
.5 .69267 .51944 .66655 .5 .65564 .48052 .68139 Metetra
.743 .643 .75 r
.48052 .68139 .5 .65564 .48045 .64496 .46094 .67075 Metetra
.745 .647 .752 r
.46094 .67075 .48045 .64496 .4608 .63449 .44126 .66075 Metetra
.748 .65 .752 r
.44126 .66075 .4608 .63449 .44104 .62424 .42145 .65138 Metetra
.751 .652 .751 r
.42145 .65138 .44104 .62424 .42118 .6142 .40153 .6426 Metetra
.754 .653 .75 r
.40153 .6426 .42118 .6142 .4012 .60433 .38149 .63436 Metetra
.758 .654 .747 r
.38149 .63436 .4012 .60433 .3811 .59462 .36132 .6266 Metetra
.761 .654 .743 r
.36132 .6266 .3811 .59462 .36089 .58502 .34102 .61922 Metetra
.764 .653 .739 r
.34102 .61922 .36089 .58502 .34056 .57551 .32058 .61214 Metetra
.767 .651 .735 r
.32058 .61214 .34056 .57551 .32011 .56604 .30002 .60525 Metetra
.769 .649 .73 r
.30002 .60525 .32011 .56604 .29954 .55655 .27931 .59843 Metetra
.77 .647 .726 r
.27931 .59843 .29954 .55655 .27885 .54701 .25848 .59157 Metetra
.771 .645 .722 r
.25848 .59157 .27885 .54701 .25805 .53737 .23751 .58454 Metetra
.771 .642 .719 r
.23751 .58454 .25805 .53737 .23712 .52758 .21642 .57723 Metetra
.772 .64 .716 r
.21642 .57723 .23712 .52758 .21607 .5176 .1952 .56954 Metetra
.771 .637 .713 r
.1952 .56954 .21607 .5176 .19491 .50738 .17387 .56134 Metetra
.771 .635 .711 r
.17387 .56134 .19491 .50738 .17364 .49688 .15243 .55257 Metetra
.77 .633 .709 r
.15243 .55257 .17364 .49688 .15225 .48609 .13087 .54313 Metetra
.769 .63 .707 r
.13087 .54313 .15225 .48609 .13075 .47497 .10922 .53297 Metetra
.768 .629 .706 r
.10922 .53297 .13075 .47497 .10914 .46351 .08748 .52204 Metetra
.767 .627 .705 r
.08748 .52204 .10914 .46351 .08742 .4517 .06564 .51032 Metetra
.765 .625 .705 r
.06564 .51032 .08742 .4517 .0656 .43953 .04372 .49782 Metetra
.764 .624 .705 r
.04372 .49782 .0656 .43953 .04367 .42702 .02173 .48454 Metetra
.747 .638 .74 r
.53879 .67767 .55821 .64807 .53891 .63785 .51944 .66655 Metetra
.746 .64 .742 r
.51944 .66655 .53891 .63785 .51951 .62738 .5 .65564 Metetra
.746 .641 .744 r
.5 .65564 .51951 .62738 .5 .61665 .48045 .64496 Metetra
.747 .643 .745 r
.48045 .64496 .5 .61665 .48039 .60565 .4608 .63449 Metetra
.749 .643 .744 r
.4608 .63449 .48039 .60565 .46068 .5944 .44104 .62424 Metetra
.751 .644 .742 r
.44104 .62424 .46068 .5944 .44086 .58289 .42118 .6142 Metetra
.753 .644 .74 r
.42118 .6142 .44086 .58289 .42095 .57115 .4012 .60433 Metetra
.755 .643 .737 r
.4012 .60433 .42095 .57115 .40093 .5592 .3811 .59462 Metetra
.758 .642 .733 r
.3811 .59462 .40093 .5592 .38081 .54705 .36089 .58502 Metetra
.76 .641 .729 r
.36089 .58502 .38081 .54705 .36059 .53475 .34056 .57551 Metetra
.762 .639 .725 r
.34056 .57551 .36059 .53475 .34027 .52231 .32011 .56604 Metetra
.764 .637 .721 r
.32011 .56604 .34027 .52231 .31984 .50977 .29954 .55655 Metetra
.766 .636 .717 r
.29954 .55655 .31984 .50977 .29931 .49717 .27885 .54701 Metetra
.767 .634 .713 r
.27885 .54701 .29931 .49717 .27867 .48454 .25805 .53737 Metetra
.768 .632 .71 r
.25805 .53737 .27867 .48454 .25792 .47191 .23712 .52758 Metetra
.769 .631 .708 r
.23712 .52758 .25792 .47191 .23706 .45931 .21607 .5176 Metetra
.77 .63 .705 r
.21607 .5176 .23706 .45931 .21609 .44678 .19491 .50738 Metetra
.77 .628 .703 r
.19491 .50738 .21609 .44678 .19501 .43434 .17364 .49688 Metetra
.77 .627 .702 r
.17364 .49688 .19501 .43434 .1738 .42202 .15225 .48609 Metetra
.77 .626 .701 r
.15225 .48609 .1738 .42202 .15247 .40982 .13075 .47497 Metetra
.77 .625 .7 r
.13075 .47497 .15247 .40982 .13102 .39775 .10914 .46351 Metetra
.77 .625 .7 r
.10914 .46351 .13102 .39775 .10943 .38584 .08742 .4517 Metetra
.769 .624 .699 r
.08742 .4517 .10943 .38584 .08772 .37406 .0656 .43953 Metetra
.768 .624 .7 r
.0656 .43953 .08772 .37406 .06588 .36243 .04367 .42702 Metetra
.747 .644 .746 r
.55821 .64807 .57767 .62041 .55841 .61099 .53891 .63785 Metetra
.745 .644 .748 r
.53891 .63785 .55841 .61099 .53905 .60091 .51951 .62738 Metetra
.744 .643 .748 r
.51951 .62738 .53905 .60091 .51958 .59013 .5 .61665 Metetra
.743 .642 .748 r
.5 .61665 .51958 .59013 .5 .57866 .48039 .60565 Metetra
.743 .641 .747 r
.48039 .60565 .5 .57866 .48032 .5665 .46068 .5944 Metetra
.744 .639 .744 r
.46068 .5944 .48032 .5665 .46055 .55369 .44086 .58289 Metetra
.745 .638 .741 r
.44086 .58289 .46055 .55369 .44069 .54027 .42095 .57115 Metetra
.747 .636 .738 r
.42095 .57115 .44069 .54027 .42073 .52632 .40093 .5592 Metetra
.748 .634 .734 r
.40093 .5592 .42073 .52632 .40068 .5119 .38081 .54705 Metetra
.751 .633 .73 r
.38081 .54705 .40068 .5119 .38055 .49711 .36059 .53475 Metetra
.753 .631 .726 r
.36059 .53475 .38055 .49711 .36032 .48204 .34027 .52231 Metetra
.755 .63 .722 r
.34027 .52231 .36032 .48204 .34001 .46679 .31984 .50977 Metetra
.757 .629 .719 r
.31984 .50977 .34001 .46679 .31961 .45147 .29931 .49717 Metetra
.759 .628 .715 r
.29931 .49717 .31961 .45147 .29911 .43619 .27867 .48454 Metetra
.76 .627 .713 r
.27867 .48454 .29911 .43619 .27851 .42106 .25792 .47191 Metetra
.762 .627 .71 r
.25792 .47191 .27851 .42106 .2578 .40616 .23706 .45931 Metetra
.763 .626 .708 r
.23706 .45931 .2578 .40616 .23699 .39159 .21609 .44678 Metetra
.764 .626 .707 r
.21609 .44678 .23699 .39159 .21606 .37743 .19501 .43434 Metetra
.766 .626 .705 r
.19501 .43434 .21606 .37743 .19501 .36375 .1738 .42202 Metetra
.766 .626 .704 r
.1738 .42202 .19501 .36375 .17383 .35059 .15247 .40982 Metetra
.767 .626 .704 r
.15247 .40982 .17383 .35059 .15251 .338 .13102 .39775 Metetra
.768 .626 .704 r
.13102 .39775 .15251 .338 .13105 .32598 .10943 .38584 Metetra
.768 .627 .704 r
.10943 .38584 .13105 .32598 .10944 .31455 .08772 .37406 Metetra
.768 .627 .704 r
.08772 .37406 .10944 .31455 .08767 .30368 .06588 .36243 Metetra
.74 .655 .766 r
.57767 .62041 .59722 .59885 .578 .58992 .55841 .61099 Metetra
.736 .652 .766 r
.55841 .61099 .578 .58992 .55866 .58006 .53905 .60091 Metetra
.733 .649 .765 r
.53905 .60091 .55866 .58006 .53921 .56923 .51958 .59013 Metetra
.731 .645 .763 r
.51958 .59013 .53921 .56923 .51965 .55743 .5 .57866 Metetra
.73 .642 .761 r
.5 .57866 .51965 .55743 .5 .54467 .48032 .5665 Metetra
.729 .638 .757 r
.48032 .5665 .5 .54467 .48025 .53101 .46055 .55369 Metetra
.729 .635 .754 r
.46055 .55369 .48025 .53101 .46041 .51651 .44069 .54027 Metetra
.73 .632 .75 r
.44069 .54027 .46041 .51651 .44048 .50126 .42073 .52632 Metetra
.731 .63 .746 r
.42073 .52632 .44048 .50126 .42047 .48537 .40068 .5119 Metetra
.733 .628 .742 r
.40068 .5119 .42047 .48537 .40038 .46898 .38055 .49711 Metetra
.735 .627 .739 r
.38055 .49711 .40038 .46898 .38021 .45221 .36032 .48204 Metetra
.737 .626 .735 r
.36032 .48204 .38021 .45221 .35996 .43523 .34001 .46679 Metetra
.739 .625 .732 r
.34001 .46679 .35996 .43523 .33962 .41817 .31961 .45147 Metetra
.741 .625 .73 r
.31961 .45147 .33962 .41817 .3192 .4012 .29911 .43619 Metetra
.744 .625 .727 r
.29911 .43619 .3192 .4012 .29868 .38445 .27851 .42106 Metetra
.746 .625 .725 r
.27851 .42106 .29868 .38445 .27807 .36808 .2578 .40616 Metetra
.749 .626 .724 r
.2578 .40616 .27807 .36808 .25735 .3522 .23699 .39159 Metetra
.751 .627 .723 r
.23699 .39159 .25735 .3522 .23651 .33693 .21606 .37743 Metetra
.753 .628 .722 r
.21606 .37743 .23651 .33693 .21555 .32237 .19501 .36375 Metetra
.755 .63 .721 r
.19501 .36375 .21555 .32237 .19446 .30859 .17383 .35059 Metetra
.757 .631 .721 r
.17383 .35059 .19446 .30859 .17322 .29563 .15251 .338 Metetra
.759 .633 .722 r
.15251 .338 .17322 .29563 .15183 .28353 .13105 .32598 Metetra
.76 .635 .722 r
.13105 .32598 .15183 .28353 .13029 .27228 .10944 .31455 Metetra
.762 .637 .723 r
.10944 .31455 .13029 .27228 .10857 .26187 .08767 .30368 Metetra
.715 .674 .809 r
.59722 .59885 .61694 .58601 .59773 .57713 .578 .58992 Metetra
.711 .667 .805 r
.578 .58992 .59773 .57713 .5784 .56726 .55866 .58006 Metetra
.708 .66 .8 r
.55866 .58006 .5784 .56726 .55896 .55637 .53921 .56923 Metetra
.705 .653 .795 r
.53921 .56923 .55896 .55637 .53941 .54446 .51965 .55743 Metetra
.702 .646 .791 r
.51965 .55743 .53941 .54446 .51975 .53155 .5 .54467 Metetra
.7 .64 .786 r
.5 .54467 .51975 .53155 .5 .51767 .48025 .53101 Metetra
.699 .635 .782 r
.48025 .53101 .5 .51767 .48016 .50291 .46041 .51651 Metetra
.698 .631 .779 r
.46041 .51651 .48016 .50291 .46023 .48737 .44048 .50126 Metetra
.697 .628 .776 r
.44048 .50126 .46023 .48737 .44021 .47115 .42047 .48537 Metetra
.697 .626 .773 r
.42047 .48537 .44021 .47115 .42012 .4544 .40038 .46898 Metetra
.697 .624 .771 r
.40038 .46898 .42012 .4544 .39995 .43726 .38021 .45221 Metetra
.698 .623 .769 r
.38021 .45221 .39995 .43726 .37969 .41988 .35996 .43523 Metetra
.699 .623 .768 r
.35996 .43523 .37969 .41988 .35936 .40244 .33962 .41817 Metetra
.701 .624 .768 r
.33962 .41817 .35936 .40244 .33894 .38509 .3192 .4012 Metetra
.702 .625 .768 r
.3192 .4012 .33894 .38509 .31842 .36798 .29868 .38445 Metetra
.705 .627 .768 r
.29868 .38445 .31842 .36798 .29781 .35127 .27807 .36808 Metetra
.707 .63 .769 r
.27807 .36808 .29781 .35127 .2771 .33509 .25735 .3522 Metetra
.71 .634 .77 r
.25735 .3522 .2771 .33509 .25627 .31956 .23651 .33693 Metetra
.712 .638 .772 r
.23651 .33693 .25627 .31956 .23532 .30478 .21555 .32237 Metetra
.715 .642 .775 r
.21555 .32237 .23532 .30478 .21423 .29082 .19446 .30859 Metetra
.719 .647 .777 r
.19446 .30859 .21423 .29082 .19301 .27774 .17322 .29563 Metetra
.722 .653 .78 r
.17322 .29563 .19301 .27774 .17163 .26557 .15183 .28353 Metetra
.725 .659 .784 r
.15183 .28353 .17163 .26557 .15009 .2543 .13029 .27228 Metetra
.728 .665 .788 r
.13029 .27228 .15009 .2543 .12839 .24392 .10857 .26187 Metetra
.633 .699 .893 r
.61694 .58601 .63691 .58242 .61768 .57312 .59773 .57713 Metetra
.64 .685 .877 r
.59773 .57713 .61768 .57312 .59834 .56301 .5784 .56726 Metetra
.643 .673 .864 r
.5784 .56726 .59834 .56301 .57888 .55206 .55896 .55637 Metetra
.643 .662 .854 r
.55896 .55637 .57888 .55206 .55931 .54027 .53941 .54446 Metetra
.641 .653 .846 r
.53941 .54446 .55931 .54027 .53964 .52765 .51975 .53155 Metetra
.637 .644 .841 r
.51975 .53155 .53964 .52765 .51987 .51424 .5 .51767 Metetra
.631 .637 .838 r
.5 .51767 .51987 .51424 .5 .5001 .48016 .50291 Metetra
.624 .63 .837 r
.48016 .50291 .5 .5001 .48004 .48531 .46023 .48737 Metetra
.614 .625 .838 r
.46023 .48737 .48004 .48531 .45999 .46996 .44021 .47115 Metetra
.603 .619 .84 r
.44021 .47115 .45999 .46996 .43985 .45416 .42012 .4544 Metetra
.589 .615 .845 r
.42012 .4544 .43985 .45416 .41963 .43804 .39995 .43726 Metetra
.573 .611 .852 r
.39995 .43726 .41963 .43804 .39931 .42171 .37969 .41988 Metetra
.553 .607 .861 r
.37969 .41988 .39931 .42171 .37891 .40531 .35936 .40244 Metetra
.529 .603 .872 r
.35936 .40244 .37891 .40531 .35842 .38898 .33894 .38509 Metetra
.498 .599 .885 r
.33894 .38509 .35842 .38898 .33784 .37283 .31842 .36798 Metetra
.46 .594 .899 r
.31842 .36798 .33784 .37283 .31715 .35698 .29781 .35127 Metetra
.412 .587 .913 r
.29781 .35127 .31715 .35698 .29636 .34156 .2771 .33509 Metetra
.353 .576 .925 r
.2771 .33509 .29636 .34156 .27546 .32665 .25627 .31956 Metetra
.279 .56 .931 r
.25627 .31956 .27546 .32665 .25443 .31234 .23532 .30478 Metetra
.193 .536 .925 r
.23532 .30478 .25443 .31234 .23328 .29868 .21423 .29082 Metetra
.098 .504 .904 r
.21423 .29082 .23328 .29868 .21199 .28573 .19301 .27774 Metetra
.005 .467 .868 r
.19301 .27774 .21199 .28573 .19055 .2735 .17163 .26557 Metetra
0 .431 .823 r
.17163 .26557 .19055 .2735 .16896 .262 .15009 .2543 Metetra
0 .405 .781 r
.15009 .2543 .16896 .262 .14722 .2512 .12839 .24392 Metetra
.366 .659 .97 r
.63691 .58242 .65715 .58638 .63788 .57628 .61768 .57312 Metetra
.441 .667 .958 r
.61768 .57312 .63788 .57628 .61851 .56573 .59834 .56301 Metetra
.48 .663 .942 r
.59834 .56301 .61851 .56573 .59902 .55471 .57888 .55206 Metetra
.496 .654 .93 r
.57888 .55206 .59902 .55471 .57942 .54323 .55931 .54027 Metetra
.496 .644 .922 r
.55931 .54027 .57942 .54323 .55972 .53128 .53964 .52765 Metetra
.483 .632 .919 r
.53964 .52765 .55972 .53128 .53992 .51889 .51987 .51424 Metetra
.454 .616 .919 r
.51987 .51424 .53992 .51889 .52001 .5061 .5 .5001 Metetra
.408 .596 .922 r
.5 .5001 .52001 .5061 .5 .49293 .48004 .48531 Metetra
.334 .565 .922 r
.48004 .48531 .5 .49293 .47989 .47944 .45999 .46996 Metetra
.22 .513 .912 r
.45999 .46996 .47989 .47944 .45968 .46568 .43985 .45416 Metetra
.047 .424 .867 r
.43985 .45416 .45968 .46568 .43938 .45172 .41963 .43804 Metetra
0 .277 .751 r
.41963 .43804 .43938 .45172 .41897 .43763 .39931 .42171 Metetra
.455 0 0 r
.39931 .42171 .41897 .43763 .39846 .42346 .37891 .40531 Metetra
.657 .117 0 r
.37891 .40531 .39846 .42346 .37786 .40929 .35842 .38898 Metetra
.77 .26 0 r
.35842 .38898 .37786 .40929 .35714 .39519 .33784 .37283 Metetra
.82 .35 .092 r
.33784 .37283 .35714 .39519 .33633 .38122 .31715 .35698 Metetra
.839 .405 .199 r
.31715 .35698 .33633 .38122 .3154 .36744 .29636 .34156 Metetra
.844 .438 .271 r
.29636 .34156 .3154 .36744 .29435 .35389 .27546 .32665 Metetra
.843 .459 .321 r
.27546 .32665 .29435 .35389 .27319 .34062 .25443 .31234 Metetra
.84 .472 .356 r
.25443 .31234 .27319 .34062 .2519 .32767 .23328 .29868 Metetra
.836 .479 .379 r
.23328 .29868 .2519 .32767 .23048 .31505 .21199 .28573 Metetra
.831 .482 .395 r
.21199 .28573 .23048 .31505 .20893 .30278 .19055 .2735 Metetra
.826 .482 .405 r
.19055 .2735 .20893 .30278 .18725 .29086 .16896 .262 Metetra
.821 .479 .408 r
.16896 .262 .18725 .29086 .16542 .27927 .14722 .2512 Metetra
.038 .5 .884 r
.65715 .58638 .67765 .59433 .65833 .58323 .63788 .57628 Metetra
.183 .568 .936 r
.63788 .57628 .65833 .58323 .63891 .57213 .61851 .56573 Metetra
.258 .595 .95 r
.61851 .56573 .63891 .57213 .61938 .56104 .59902 .55471 Metetra
.285 .598 .95 r
.59902 .55471 .61938 .56104 .59975 .54996 .57942 .54323 Metetra
.271 .587 .946 r
.57942 .54323 .59975 .54996 .58002 .5389 .55972 .53128 Metetra
.216 .558 .935 r
.55972 .53128 .58002 .5389 .56018 .52783 .53992 .51889 Metetra
.109 .502 .905 r
.53992 .51889 .56018 .52783 .54023 .51677 .52001 .5061 Metetra
0 .399 .83 r
.52001 .5061 .54023 .51677 .52017 .50569 .5 .49293 Metetra
0 .23 .669 r
.5 .49293 .52017 .50569 .5 .4946 .47989 .47944 Metetra
.545 0 0 r
.47989 .47944 .5 .4946 .47972 .48348 .45968 .46568 Metetra
.711 .175 0 r
.45968 .46568 .47972 .48348 .45932 .47232 .43938 .45172 Metetra
.794 .307 .049 r
.43938 .45172 .45932 .47232 .43881 .46112 .41897 .43763 Metetra
.829 .39 .19 r
.41897 .43763 .43881 .46112 .41818 .44984 .39846 .42346 Metetra
.842 .441 .284 r
.39846 .42346 .41818 .44984 .39744 .4385 .37786 .40929 Metetra
.845 .473 .348 r
.37786 .40929 .39744 .4385 .37658 .42706 .35714 .39519 Metetra
.844 .494 .392 r
.35714 .39519 .37658 .42706 .35561 .41553 .33633 .38122 Metetra
.841 .508 .424 r
.33633 .38122 .35561 .41553 .33451 .40388 .3154 .36744 Metetra
.838 .518 .447 r
.3154 .36744 .33451 .40388 .3133 .39212 .29435 .35389 Metetra
.835 .524 .463 r
.29435 .35389 .3133 .39212 .29196 .38023 .27319 .34062 Metetra
.832 .528 .475 r
.27319 .34062 .29196 .38023 .27051 .36821 .2519 .32767 Metetra
.829 .53 .483 r
.2519 .32767 .27051 .36821 .24894 .35604 .23048 .31505 Metetra
.827 .53 .488 r
.23048 .31505 .24894 .35604 .22725 .34374 .20893 .30278 Metetra
.825 .53 .49 r
.20893 .30278 .22725 .34374 .20543 .33129 .18725 .29086 Metetra
.824 .528 .489 r
.18725 .29086 .20543 .33129 .1835 .31871 .16542 .27927 Metetra
.196 .565 .937 r
.67765 .59433 .69833 .60169 .67895 .5896 .65833 .58323 Metetra
.275 .6 .951 r
.65833 .58323 .67895 .5896 .65949 .57796 .63891 .57213 Metetra
.31 .614 .955 r
.63891 .57213 .65949 .57796 .63993 .56681 .61938 .56104 Metetra
.309 .615 .956 r
.61938 .56104 .63993 .56681 .62027 .55612 .59975 .54996 Metetra
.272 .602 .952 r
.59975 .54996 .62027 .55612 .60051 .54591 .58002 .5389 Metetra
.188 .567 .936 r
.58002 .5389 .60051 .54591 .58064 .53614 .56018 .52783 Metetra
.04 .492 .885 r
.56018 .52783 .58064 .53614 .56066 .52676 .54023 .51677 Metetra
0 .352 .755 r
.54023 .51677 .56066 .52676 .54056 .51773 .52017 .50569 Metetra
.434 0 0 r
.52017 .50569 .54056 .51773 .52034 .50899 .5 .4946 Metetra
.631 .067 0 r
.5 .4946 .52034 .50899 .5 .50045 .47972 .48348 Metetra
.741 .227 0 r
.47972 .48348 .5 .50045 .47953 .49204 .45932 .47232 Metetra
.792 .33 .142 r
.45932 .47232 .47953 .49204 .45893 .48366 .43881 .46112 Metetra
.814 .395 .249 r
.43881 .46112 .45893 .48366 .4382 .47523 .41818 .44984 Metetra
.824 .437 .321 r
.41818 .44984 .4382 .47523 .41734 .46666 .39744 .4385 Metetra
.828 .466 .37 r
.39744 .4385 .41734 .46666 .39635 .45785 .37658 .42706 Metetra
.829 .485 .405 r
.37658 .42706 .39635 .45785 .37523 .44873 .35561 .41553 Metetra
.829 .499 .43 r
.35561 .41553 .37523 .44873 .35398 .4392 .33451 .40388 Metetra
.829 .509 .448 r
.33451 .40388 .35398 .4392 .33261 .4292 .3133 .39212 Metetra
.828 .516 .461 r
.3133 .39212 .33261 .4292 .31112 .41867 .29196 .38023 Metetra
.828 .521 .469 r
.29196 .38023 .31112 .41867 .28951 .40757 .27051 .36821 Metetra
.828 .524 .475 r
.27051 .36821 .28951 .40757 .26779 .39586 .24894 .35604 Metetra
.828 .525 .477 r
.24894 .35604 .26779 .39586 .24595 .38352 .22725 .34374 Metetra
.829 .525 .476 r
.22725 .34374 .24595 .38352 .22401 .37055 .20543 .33129 Metetra
.829 .524 .473 r
.20543 .33129 .22401 .37055 .20197 .35697 .1835 .31871 Metetra
.522 .654 .918 r
.69833 .60169 .71908 .60392 .69966 .59109 .67895 .5896 Metetra
.535 .663 .918 r
.67895 .5896 .69966 .59109 .68016 .57905 .65949 .57796 Metetra
.54 .671 .922 r
.65949 .57796 .68016 .57905 .66058 .56783 .63993 .56681 Metetra
.534 .678 .93 r
.63993 .56681 .66058 .56783 .6409 .55742 .62027 .55612 Metetra
.516 .683 .942 r
.62027 .55612 .6409 .55742 .62112 .54781 .60051 .54591 Metetra
.481 .686 .957 r
.60051 .54591 .62112 .54781 .60124 .53895 .58064 .53614 Metetra
.42 .68 .97 r
.58064 .53614 .60124 .53895 .58125 .53079 .56066 .52676 Metetra
.317 .656 .971 r
.56066 .52676 .58125 .53079 .56113 .52323 .54056 .51773 Metetra
.151 .589 .931 r
.54056 .51773 .56113 .52323 .54089 .51617 .52034 .50899 Metetra
0 .452 .805 r
.52034 .50899 .54089 .51617 .52051 .5095 .5 .50045 Metetra
.344 0 0 r
.5 .50045 .52051 .5095 .5 .50307 .47953 .49204 Metetra
.542 0 0 r
.47953 .49204 .5 .50307 .47935 .49675 .45893 .48366 Metetra
.661 .115 0 r
.45893 .48366 .47935 .49675 .45856 .49038 .4382 .47523 Metetra
.726 .222 .034 r
.4382 .47523 .45856 .49038 .43762 .48382 .41734 .46666 Metetra
.762 .294 .135 r
.41734 .46666 .43762 .48382 .41655 .47692 .39635 .45785 Metetra
.783 .342 .203 r
.39635 .45785 .41655 .47692 .39533 .46954 .37523 .44873 Metetra
.796 .376 .249 r
.37523 .44873 .39533 .46954 .37398 .46155 .35398 .4392 Metetra
.806 .399 .281 r
.35398 .4392 .37398 .46155 .35251 .45283 .33261 .4292 Metetra
.812 .416 .3 r
.33261 .4292 .35251 .45283 .3309 .44329 .31112 .41867 Metetra
.818 .426 .311 r
.31112 .41867 .3309 .44329 .30918 .43284 .28951 .40757 Metetra
.822 .433 .314 r
.28951 .40757 .30918 .43284 .28735 .42144 .26779 .39586 Metetra
.826 .434 .309 r
.26779 .39586 .28735 .42144 .26541 .40906 .24595 .38352 Metetra
.829 .432 .297 r
.24595 .38352 .26541 .40906 .24338 .3957 .22401 .37055 Metetra
.83 .424 .275 r
.22401 .37055 .24338 .3957 .22125 .38137 .20197 .35697 Metetra
.661 .653 .832 r
.71908 .60392 .73977 .5977 .72033 .58457 .69966 .59109 Metetra
.664 .661 .837 r
.69966 .59109 .72033 .58457 .70082 .57234 .68016 .57905 Metetra
.667 .67 .843 r
.68016 .57905 .70082 .57234 .68123 .56105 .66058 .56783 Metetra
.668 .679 .851 r
.66058 .56783 .68123 .56105 .66155 .5507 .6409 .55742 Metetra
.668 .689 .861 r
.6409 .55742 .66155 .5507 .64178 .54127 .62112 .54781 Metetra
.667 .7 .871 r
.62112 .54781 .64178 .54127 .6219 .53272 .60124 .53895 Metetra
.663 .711 .884 r
.60124 .53895 .6219 .53272 .6019 .52496 .58125 .53079 Metetra
.658 .723 .897 r
.58125 .53079 .6019 .52496 .58179 .5179 .56113 .52323 Metetra
.649 .733 .911 r
.56113 .52323 .58179 .5179 .56155 .51143 .54089 .51617 Metetra
.637 .743 .925 r
.54089 .51617 .56155 .51143 .54117 .5054 .52051 .5095 Metetra
.621 .751 .939 r
.52051 .5095 .54117 .5054 .52066 .49966 .5 .50307 Metetra
.602 .755 .952 r
.5 .50307 .52066 .49966 .5 .49405 .47935 .49675 Metetra
.58 .757 .962 r
.47935 .49675 .5 .49405 .4792 .48841 .45856 .49038 Metetra
.556 .754 .97 r
.45856 .49038 .4792 .48841 .45825 .48255 .43762 .48382 Metetra
.533 .748 .975 r
.43762 .48382 .45825 .48255 .43715 .47631 .41655 .47692 Metetra
.512 .739 .977 r
.41655 .47692 .43715 .47631 .41591 .46954 .39533 .46954 Metetra
.495 .728 .976 r
.39533 .46954 .41591 .46954 .39453 .46207 .37398 .46155 Metetra
.484 .715 .972 r
.37398 .46155 .39453 .46207 .37302 .45378 .35251 .45283 Metetra
.479 .702 .967 r
.35251 .45283 .37302 .45378 .35138 .44456 .3309 .44329 Metetra
.48 .689 .959 r
.3309 .44329 .35138 .44456 .32962 .43431 .30918 .43284 Metetra
.485 .677 .95 r
.30918 .43284 .32962 .43431 .30775 .42298 .28735 .42144 Metetra
.495 .666 .939 r
.28735 .42144 .30775 .42298 .28578 .41054 .26541 .40906 Metetra
.507 .657 .927 r
.26541 .40906 .28578 .41054 .2637 .39698 .24338 .3957 Metetra
.52 .648 .914 r
.24338 .3957 .2637 .39698 .24153 .38233 .22125 .38137 Metetra
.712 .644 .779 r
.73977 .5977 .76031 .58178 .74089 .56884 .72033 .58457 Metetra
.714 .65 .784 r
.72033 .58457 .74089 .56884 .72139 .55667 .70082 .57234 Metetra
.717 .657 .789 r
.70082 .57234 .72139 .55667 .70181 .54532 .68123 .56105 Metetra
.72 .665 .794 r
.68123 .56105 .70181 .54532 .68215 .53479 .66155 .5507 Metetra
.724 .672 .798 r
.66155 .5507 .68215 .53479 .66238 .52506 .64178 .54127 Metetra
.729 .679 .802 r
.64178 .54127 .66238 .52506 .64252 .51609 .6219 .53272 Metetra
.734 .686 .804 r
.6219 .53272 .64252 .51609 .62254 .50781 .6019 .52496 Metetra
.738 .691 .806 r
.6019 .52496 .62254 .50781 .60245 .50014 .58179 .5179 Metetra
.743 .695 .806 r
.58179 .5179 .60245 .50014 .58223 .49296 .56155 .51143 Metetra
.747 .698 .805 r
.56155 .51143 .58223 .49296 .56188 .48617 .54117 .5054 Metetra
.75 .699 .803 r
.54117 .5054 .56188 .48617 .54139 .47963 .52066 .49966 Metetra
.753 .698 .8 r
.52066 .49966 .54139 .47963 .52077 .47319 .5 .49405 Metetra
.755 .696 .796 r
.5 .49405 .52077 .47319 .5 .46671 .4792 .48841 Metetra
.756 .693 .791 r
.4792 .48841 .5 .46671 .47909 .46003 .45825 .48255 Metetra
.756 .688 .787 r
.45825 .48255 .47909 .46003 .45804 .45301 .43715 .47631 Metetra
.755 .683 .782 r
.43715 .47631 .45804 .45301 .43684 .44551 .41591 .46954 Metetra
.754 .677 .777 r
.41591 .46954 .43684 .44551 .41551 .43739 .39453 .46207 Metetra
.752 .671 .772 r
.39453 .46207 .41551 .43739 .39404 .42854 .37302 .45378 Metetra
.749 .666 .768 r
.37302 .45378 .39404 .42854 .37245 .41887 .35138 .44456 Metetra
.747 .66 .764 r
.35138 .44456 .37245 .41887 .35073 .40829 .32962 .43431 Metetra
.744 .654 .761 r
.32962 .43431 .35073 .40829 .3289 .39675 .30775 .42298 Metetra
.741 .649 .758 r
.30775 .42298 .3289 .39675 .30695 .38422 .28578 .41054 Metetra
.737 .644 .756 r
.28578 .41054 .30695 .38422 .2849 .37071 .2637 .39698 Metetra
.734 .639 .754 r
.2637 .39698 .2849 .37071 .26276 .35623 .24153 .38233 Metetra
.735 .639 .753 r
.76031 .58178 .78067 .55734 .76129 .54501 .74089 .56884 Metetra
.736 .644 .757 r
.74089 .56884 .76129 .54501 .74184 .53313 .72139 .55667 Metetra
.738 .649 .76 r
.72139 .55667 .74184 .53313 .72229 .52173 .70181 .54532 Metetra
.741 .654 .763 r
.70181 .54532 .72229 .52173 .70264 .5108 .68215 .53479 Metetra
.745 .658 .765 r
.68215 .53479 .70264 .5108 .6829 .50035 .66238 .52506 Metetra
.749 .662 .765 r
.66238 .52506 .6829 .50035 .66306 .49033 .64252 .51609 Metetra
.753 .665 .764 r
.64252 .51609 .66306 .49033 .6431 .48072 .62254 .50781 Metetra
.758 .667 .762 r
.62254 .50781 .6431 .48072 .62303 .47145 .60245 .50014 Metetra
.762 .668 .759 r
.60245 .50014 .62303 .47145 .60285 .46246 .58223 .49296 Metetra
.766 .668 .755 r
.58223 .49296 .60285 .46246 .58253 .45368 .56188 .48617 Metetra
.769 .667 .75 r
.56188 .48617 .58253 .45368 .5621 .44503 .54139 .47963 Metetra
.771 .665 .746 r
.54139 .47963 .5621 .44503 .54153 .43641 .52077 .47319 Metetra
.773 .662 .741 r
.52077 .47319 .54153 .43641 .52083 .42773 .5 .46671 Metetra
.774 .659 .736 r
.5 .46671 .52083 .42773 .5 .41891 .47909 .46003 Metetra
.774 .656 .732 r
.47909 .46003 .5 .41891 .47904 .40985 .45804 .45301 Metetra
.774 .653 .728 r
.45804 .45301 .47904 .40985 .45794 .40047 .43684 .44551 Metetra
.773 .649 .725 r
.43684 .44551 .45794 .40047 .43671 .39068 .41551 .43739 Metetra
.772 .646 .722 r
.41551 .43739 .43671 .39068 .41535 .38042 .39404 .42854 Metetra
.771 .642 .719 r
.39404 .42854 .41535 .38042 .39386 .36962 .37245 .41887 Metetra
.77 .639 .717 r
.37245 .41887 .39386 .36962 .37225 .35824 .35073 .40829 Metetra
.768 .636 .716 r
.35073 .40829 .37225 .35824 .35052 .34625 .3289 .39675 Metetra
.766 .634 .715 r
.3289 .39675 .35052 .34625 .32868 .33362 .30695 .38422 Metetra
.764 .631 .714 r
.30695 .38422 .32868 .33362 .30671 .32037 .2849 .37071 Metetra
.762 .629 .714 r
.2849 .37071 .30671 .32037 .28464 .30649 .26276 .35623 Metetra
.746 .639 .742 r
.78067 .55734 .80089 .52766 .78159 .51619 .76129 .54501 Metetra
.746 .642 .745 r
.76129 .54501 .78159 .51619 .76219 .50473 .74184 .53313 Metetra
.747 .645 .748 r
.74184 .53313 .76219 .50473 .74268 .49328 .72229 .52173 Metetra
.748 .647 .749 r
.72229 .52173 .74268 .49328 .72307 .48183 .70264 .5108 Metetra
.751 .65 .749 r
.70264 .5108 .72307 .48183 .70335 .47039 .6829 .50035 Metetra
.754 .651 .748 r
.6829 .50035 .70335 .47039 .68352 .45896 .66306 .49033 Metetra
.757 .652 .746 r
.66306 .49033 .68352 .45896 .66359 .44752 .6431 .48072 Metetra
.76 .652 .742 r
.6431 .48072 .66359 .44752 .64354 .43606 .62303 .47145 Metetra
.763 .652 .739 r
.62303 .47145 .64354 .43606 .62338 .42459 .60285 .46246 Metetra
.766 .651 .734 r
.60285 .46246 .62338 .42459 .60311 .41309 .58253 .45368 Metetra
.769 .649 .73 r
.58253 .45368 .60311 .41309 .58272 .40154 .5621 .44503 Metetra
.771 .647 .725 r
.5621 .44503 .58272 .40154 .56222 .38994 .54153 .43641 Metetra
.773 .645 .721 r
.54153 .43641 .56222 .38994 .5416 .37828 .52083 .42773 Metetra
.774 .643 .717 r
.52083 .42773 .5416 .37828 .52086 .36653 .5 .41891 Metetra
.775 .641 .714 r
.5 .41891 .52086 .36653 .5 .3547 .47904 .40985 Metetra
.775 .639 .711 r
.47904 .40985 .5 .3547 .47902 .34276 .45794 .40047 Metetra
.776 .637 .708 r
.45794 .40047 .47902 .34276 .45792 .33071 .43671 .39068 Metetra
.775 .635 .706 r
.43671 .39068 .45792 .33071 .4367 .31853 .41535 .38042 Metetra
.775 .633 .704 r
.41535 .38042 .4367 .31853 .41536 .30622 .39386 .36962 Metetra
.775 .632 .702 r
.39386 .36962 .41536 .30622 .39389 .29378 .37225 .35824 Metetra
.774 .63 .701 r
.37225 .35824 .39389 .29378 .3723 .28119 .35052 .34625 Metetra
.773 .629 .701 r
.35052 .34625 .3723 .28119 .35059 .26846 .32868 .33362 Metetra
.772 .627 .701 r
.32868 .33362 .35059 .26846 .32875 .25558 .30671 .32037 Metetra
.771 .626 .701 r
.30671 .32037 .32875 .25558 .30679 .24256 .28464 .30649 Metetra
.749 .643 .742 r
.80089 .52766 .82111 .49726 .80189 .48669 .78159 .51619 Metetra
.748 .644 .745 r
.78159 .51619 .80189 .48669 .78255 .47567 .76219 .50473 Metetra
.748 .644 .746 r
.76219 .50473 .78255 .47567 .76308 .46416 .74268 .49328 Metetra
.748 .645 .746 r
.74268 .49328 .76308 .46416 .7435 .45218 .72307 .48183 Metetra
.749 .645 .745 r
.72307 .48183 .7435 .45218 .7238 .43973 .70335 .47039 Metetra
.75 .644 .743 r
.70335 .47039 .7238 .43973 .70399 .42683 .68352 .45896 Metetra
.752 .644 .741 r
.68352 .45896 .70399 .42683 .68407 .41351 .66359 .44752 Metetra
.755 .643 .737 r
.66359 .44752 .68407 .41351 .66403 .39981 .64354 .43606 Metetra
.757 .641 .733 r
.64354 .43606 .66403 .39981 .64389 .38579 .62338 .42459 Metetra
.759 .64 .729 r
.62338 .42459 .64389 .38579 .62365 .37149 .60311 .41309 Metetra
.762 .638 .725 r
.60311 .41309 .62365 .37149 .6033 .35698 .58272 .40154 Metetra
.764 .637 .721 r
.58272 .40154 .6033 .35698 .58284 .34233 .56222 .38994 Metetra
.766 .636 .717 r
.56222 .38994 .58284 .34233 .56229 .32761 .5416 .37828 Metetra
.768 .634 .713 r
.5416 .37828 .56229 .32761 .54163 .31288 .52086 .36653 Metetra
.769 .633 .71 r
.52086 .36653 .54163 .31288 .52087 .29822 .5 .3547 Metetra
.771 .632 .707 r
.5 .3547 .52087 .29822 .5 .28368 .47902 .34276 Metetra
.772 .631 .705 r
.47902 .34276 .5 .28368 .47902 .26933 .45792 .33071 Metetra
.772 .63 .703 r
.45792 .33071 .47902 .26933 .45793 .25521 .4367 .31853 Metetra
.773 .629 .702 r
.4367 .31853 .45793 .25521 .43673 .24138 .41536 .30622 Metetra
.773 .629 .7 r
.41536 .30622 .43673 .24138 .41541 .22785 .39389 .29378 Metetra
.774 .628 .7 r
.39389 .29378 .41541 .22785 .39396 .21467 .3723 .28119 Metetra
.774 .628 .699 r
.3723 .28119 .39396 .21467 .37239 .20182 .35059 .26846 Metetra
.773 .628 .699 r
.35059 .26846 .37239 .20182 .35068 .18933 .32875 .25558 Metetra
.773 .628 .7 r
.32875 .25558 .35068 .18933 .32884 .17717 .30679 .24256 Metetra
.747 .651 .754 r
.82111 .49726 .84151 .47081 .82236 .46093 .80189 .48669 Metetra
.744 .649 .756 r
.80189 .48669 .82236 .46093 .80307 .45023 .78255 .47567 Metetra
.742 .648 .756 r
.78255 .47567 .80307 .45023 .78364 .43867 .76308 .46416 Metetra
.74 .645 .755 r
.76308 .46416 .78364 .43867 .76408 .42626 .7435 .45218 Metetra
.74 .643 .753 r
.7435 .45218 .76408 .42626 .74439 .41299 .7238 .43973 Metetra
.74 .641 .75 r
.7238 .43973 .74439 .41299 .72459 .39893 .70399 .42683 Metetra
.741 .639 .747 r
.70399 .42683 .72459 .39893 .70466 .38412 .68407 .41351 Metetra
.742 .636 .743 r
.68407 .41351 .70466 .38412 .68463 .36864 .66403 .39981 Metetra
.744 .635 .739 r
.66403 .39981 .68463 .36864 .66449 .3526 .64389 .38579 Metetra
.746 .633 .735 r
.64389 .38579 .66449 .3526 .64426 .3361 .62365 .37149 Metetra
.748 .631 .731 r
.62365 .37149 .64426 .3361 .62393 .31926 .6033 .35698 Metetra
.75 .63 .727 r
.6033 .35698 .62393 .31926 .6035 .30221 .58284 .34233 Metetra
.753 .629 .723 r
.58284 .34233 .6035 .30221 .58299 .28509 .56229 .32761 Metetra
.755 .629 .72 r
.56229 .32761 .58299 .28509 .56238 .26802 .54163 .31288 Metetra
.757 .629 .718 r
.54163 .31288 .56238 .26802 .54168 .25114 .52087 .29822 Metetra
.759 .628 .715 r
.52087 .29822 .54168 .25114 .52089 .23456 .5 .28368 Metetra
.761 .629 .713 r
.5 .28368 .52089 .23456 .5 .21841 .47902 .26933 Metetra
.763 .629 .712 r
.47902 .26933 .5 .21841 .47901 .20277 .45793 .25521 Metetra
.765 .629 .71 r
.45793 .25521 .47901 .20277 .45791 .18773 .43673 .24138 Metetra
.766 .63 .71 r
.43673 .24138 .45791 .18773 .43669 .17335 .41541 .22785 Metetra
.768 .631 .709 r
.41541 .22785 .43669 .17335 .41536 .15968 .39396 .21467 Metetra
.769 .632 .709 r
.39396 .21467 .41536 .15968 .39389 .14674 .37239 .20182 Metetra
.77 .633 .709 r
.37239 .20182 .39389 .14674 .37229 .13453 .35068 .18933 Metetra
.77 .634 .71 r
.35068 .18933 .37229 .13453 .35055 .12303 .32884 .17717 Metetra
.733 .664 .783 r
.84151 .47081 .86227 .45194 .84316 .44238 .82236 .46093 Metetra
.729 .66 .781 r
.82236 .46093 .84316 .44238 .8239 .4318 .80307 .45023 Metetra
.725 .655 .779 r
.80307 .45023 .8239 .4318 .80449 .42019 .78364 .43867 Metetra
.723 .649 .776 r
.78364 .43867 .80449 .42019 .78494 .40752 .76408 .42626 Metetra
.721 .645 .772 r
.76408 .42626 .78494 .40752 .76526 .39383 .74439 .41299 Metetra
.719 .64 .769 r
.74439 .41299 .76526 .39383 .74545 .37916 .72459 .39893 Metetra
.719 .636 .765 r
.72459 .39893 .74545 .37916 .72553 .36358 .70466 .38412 Metetra
.719 .633 .761 r
.70466 .38412 .72553 .36358 .70549 .3472 .68463 .36864 Metetra
.72 .63 .757 r
.68463 .36864 .70549 .3472 .68534 .33014 .66449 .3526 Metetra
.721 .628 .754 r
.66449 .3526 .68534 .33014 .6651 .31252 .64426 .3361 Metetra
.722 .627 .751 r
.64426 .3361 .6651 .31252 .64477 .29451 .62393 .31926 Metetra
.724 .626 .748 r
.62393 .31926 .64477 .29451 .62435 .27625 .6035 .30221 Metetra
.727 .626 .745 r
.6035 .30221 .62435 .27625 .60384 .25792 .58299 .28509 Metetra
.729 .626 .743 r
.58299 .28509 .60384 .25792 .58325 .23967 .56238 .26802 Metetra
.732 .627 .741 r
.56238 .26802 .58325 .23967 .56257 .22168 .54168 .25114 Metetra
.735 .628 .74 r
.54168 .25114 .56257 .22168 .54181 .20407 .52089 .23456 Metetra
.738 .629 .739 r
.52089 .23456 .54181 .20407 .52095 .187 .5 .21841 Metetra
.74 .631 .738 r
.5 .21841 .52095 .187 .5 .17059 .47901 .20277 Metetra
.743 .634 .738 r
.47901 .20277 .5 .17059 .47894 .15492 .45791 .18773 Metetra
.746 .636 .738 r
.45791 .18773 .47894 .15492 .45778 .1401 .43669 .17335 Metetra
.749 .639 .739 r
.43669 .17335 .45778 .1401 .43649 .12615 .41536 .15968 Metetra
.751 .642 .74 r
.41536 .15968 .43649 .12615 .41508 .11312 .39389 .14674 Metetra
.754 .645 .741 r
.39389 .14674 .41508 .11312 .39353 .10101 .37229 .13453 Metetra
.756 .649 .743 r
.37229 .13453 .39353 .10101 .37184 .08979 .35055 .12303 Metetra
.691 .684 .839 r
.86227 .45194 .88354 .44247 .86442 .43273 .84316 .44238 Metetra
.689 .674 .83 r
.84316 .44238 .86442 .43273 .84516 .42204 .8239 .4318 Metetra
.687 .665 .823 r
.8239 .4318 .84516 .42204 .82576 .41036 .80449 .42019 Metetra
.685 .656 .816 r
.80449 .42019 .82576 .41036 .80621 .39768 .78494 .40752 Metetra
.682 .649 .81 r
.78494 .40752 .80621 .39768 .78653 .38403 .76526 .39383 Metetra
.679 .642 .805 r
.76526 .39383 .78653 .38403 .76671 .36944 .74545 .37916 Metetra
.677 .636 .801 r
.74545 .37916 .76671 .36944 .74678 .35399 .72553 .36358 Metetra
.674 .631 .798 r
.72553 .36358 .74678 .35399 .72674 .33777 .70549 .3472 Metetra
.671 .627 .796 r
.70549 .3472 .72674 .33777 .70659 .3209 .68534 .33014 Metetra
.669 .624 .795 r
.68534 .33014 .70659 .3209 .68633 .3035 .6651 .31252 Metetra
.667 .622 .795 r
.6651 .31252 .68633 .3035 .66599 .28572 .64477 .29451 Metetra
.665 .621 .795 r
.64477 .29451 .66599 .28572 .64555 .26771 .62435 .27625 Metetra
.663 .621 .797 r
.62435 .27625 .64555 .26771 .62502 .24962 .60384 .25792 Metetra
.661 .622 .799 r
.60384 .25792 .62502 .24962 .60441 .23161 .58325 .23967 Metetra
.66 .623 .802 r
.58325 .23967 .60441 .23161 .58371 .21383 .56257 .22168 Metetra
.658 .626 .806 r
.56257 .22168 .58371 .21383 .56293 .19642 .54181 .20407 Metetra
.658 .63 .811 r
.54181 .20407 .56293 .19642 .54205 .17951 .52095 .187 Metetra
.657 .636 .817 r
.52095 .187 .54205 .17951 .52108 .16321 .5 .17059 Metetra
.657 .642 .823 r
.5 .17059 .52108 .16321 .5 .14763 .47894 .15492 Metetra
.657 .649 .831 r
.47894 .15492 .5 .14763 .47881 .13283 .45778 .1401 Metetra
.658 .658 .838 r
.45778 .1401 .47881 .13283 .45751 .11887 .43649 .12615 Metetra
.659 .667 .846 r
.43649 .12615 .45751 .11887 .43608 .10577 .41508 .11312 Metetra
.661 .677 .855 r
.41508 .11312 .43608 .10577 .41452 .09353 .39353 .10101 Metetra
.663 .687 .862 r
.39353 .10101 .41452 .09353 .39282 .08213 .37184 .08979 Metetra
.57 .695 .925 r
.88354 .44247 .90535 .44192 .8862 .43157 .86442 .43273 Metetra
.59 .683 .906 r
.86442 .43273 .8862 .43157 .86691 .42053 .84516 .42204 Metetra
.6 .671 .89 r
.84516 .42204 .86691 .42053 .84749 .40877 .82576 .41036 Metetra
.603 .66 .878 r
.82576 .41036 .84749 .40877 .82793 .3963 .80621 .39768 Metetra
.602 .65 .87 r
.80621 .39768 .82793 .3963 .80824 .38312 .78653 .38403 Metetra
.596 .641 .865 r
.78653 .38403 .80824 .38312 .78843 .36927 .76671 .36944 Metetra
.587 .632 .863 r
.76671 .36944 .78843 .36927 .7685 .3548 .74678 .35399 Metetra
.573 .624 .864 r
.74678 .35399 .7685 .3548 .74846 .33976 .72674 .33777 Metetra
.554 .615 .868 r
.72674 .33777 .74846 .33976 .7283 .32425 .70659 .3209 Metetra
.529 .605 .874 r
.70659 .3209 .7283 .32425 .70804 .30834 .68633 .3035 Metetra
.497 .594 .882 r
.68633 .3035 .70804 .30834 .68768 .29214 .66599 .28572 Metetra
.453 .58 .891 r
.66599 .28572 .68768 .29214 .66722 .27576 .64555 .26771 Metetra
.395 .561 .9 r
.64555 .26771 .66722 .27576 .64666 .2593 .62502 .24962 Metetra
.315 .533 .905 r
.62502 .24962 .64666 .2593 .62601 .24287 .60441 .23161 Metetra
.206 .489 .899 r
.60441 .23161 .62601 .24287 .60526 .22658 .58371 .21383 Metetra
.062 .423 .868 r
.58371 .21383 .60526 .22658 .58442 .21052 .56293 .19642 Metetra
0 .327 .796 r
.56293 .19642 .58442 .21052 .56347 .1948 .54205 .17951 Metetra
0 .207 .675 r
.54205 .17951 .56347 .1948 .54242 .17948 .52108 .16321 Metetra
.465 0 0 r
.52108 .16321 .54242 .17948 .52127 .16465 .5 .14763 Metetra
.584 .026 0 r
.5 .14763 .52127 .16465 .5 .15034 .47881 .13283 Metetra
.658 .106 0 r
.47881 .13283 .5 .15034 .47861 .1366 .45751 .11887 Metetra
.7 .159 0 r
.45751 .11887 .47861 .1366 .4571 .12344 .43608 .10577 Metetra
.72 .19 0 r
.43608 .10577 .4571 .12344 .43546 .11087 .41452 .09353 Metetra
.726 .204 0 r
.41452 .09353 .43546 .11087 .41369 .09886 .39282 .08213 Metetra
.316 .628 .961 r
.90535 .44192 .92766 .44767 .90844 .43638 .8862 .43157 Metetra
.397 .644 .956 r
.8862 .43157 .90844 .43638 .8891 .42483 .86691 .42053 Metetra
.439 .646 .945 r
.86691 .42053 .8891 .42483 .86964 .413 .84749 .40877 Metetra
.456 .641 .936 r
.84749 .40877 .86964 .413 .85007 .40089 .82793 .3963 Metetra
.454 .632 .93 r
.82793 .3963 .85007 .40089 .83038 .38851 .80824 .38312 Metetra
.435 .618 .928 r
.80824 .38312 .83038 .38851 .81058 .37586 .78843 .36927 Metetra
.396 .6 .928 r
.78843 .36927 .81058 .37586 .79066 .36297 .7685 .3548 Metetra
.332 .571 .927 r
.7685 .3548 .79066 .36297 .77063 .34984 .74846 .33976 Metetra
.231 .524 .917 r
.74846 .33976 .77063 .34984 .75048 .33652 .7283 .32425 Metetra
.076 .445 .879 r
.7283 .32425 .75048 .33652 .73023 .32302 .70804 .30834 Metetra
0 .315 .783 r
.70804 .30834 .73023 .32302 .70986 .30937 .68768 .29214 Metetra
0 .131 .599 r
.68768 .29214 .70986 .30937 .68938 .29562 .66722 .27576 Metetra
.608 .064 0 r
.66722 .27576 .68938 .29562 .66879 .2818 .64666 .2593 Metetra
.742 .22 0 r
.64666 .2593 .66879 .2818 .6481 .26793 .62601 .24287 Metetra
.808 .324 .037 r
.62601 .24287 .6481 .26793 .62728 .25406 .60526 .22658 Metetra
.838 .389 .156 r
.60526 .22658 .62728 .25406 .60636 .24022 .58442 .21052 Metetra
.849 .43 .237 r
.58442 .21052 .60636 .24022 .58533 .22643 .56347 .1948 Metetra
.851 .456 .294 r
.56347 .1948 .58533 .22643 .56417 .21273 .54242 .17948 Metetra
.85 .473 .334 r
.54242 .17948 .56417 .21273 .5429 .19913 .52127 .16465 Metetra
.847 .483 .362 r
.52127 .16465 .5429 .19913 .52151 .18565 .5 .15034 Metetra
.844 .489 .382 r
.5 .15034 .52151 .18565 .5 .17231 .47861 .1366 Metetra
.84 .492 .395 r
.47861 .1366 .5 .17231 .47836 .1591 .4571 .12344 Metetra
.837 .492 .402 r
.4571 .12344 .47836 .1591 .4566 .14604 .43546 .11087 Metetra
.833 .489 .404 r
.43546 .11087 .4566 .14604 .4347 .13311 .41369 .09886 Metetra
.217 .573 .941 r
.92766 .44767 .95029 .45552 .93098 .44318 .90844 .43638 Metetra
.303 .605 .952 r
.90844 .43638 .93098 .44318 .91158 .43105 .8891 .42483 Metetra
.346 .617 .952 r
.8891 .42483 .91158 .43105 .89209 .41915 .86964 .413 Metetra
.357 .618 .95 r
.86964 .413 .89209 .41915 .87251 .40746 .85007 .40089 Metetra
.339 .609 .948 r
.85007 .40089 .87251 .40746 .85282 .39598 .83038 .38851 Metetra
.288 .587 .944 r
.83038 .38851 .85282 .39598 .83303 .38471 .81058 .37586 Metetra
.196 .545 .929 r
.81058 .37586 .83303 .38471 .81314 .37361 .79066 .36297 Metetra
.046 .467 .882 r
.79066 .36297 .81314 .37361 .79313 .36266 .77063 .34984 Metetra
0 .331 .768 r
.77063 .34984 .79313 .36266 .77301 .35182 .75048 .33652 Metetra
.42 0 0 r
.75048 .33652 .77301 .35182 .75278 .34106 .73023 .32302 Metetra
.624 .066 0 r
.73023 .32302 .75278 .34106 .73242 .33033 .70986 .30937 Metetra
.745 .224 0 r
.70986 .30937 .73242 .33033 .71194 .31958 .68938 .29562 Metetra
.804 .328 .086 r
.68938 .29562 .71194 .31958 .69133 .30876 .66879 .2818 Metetra
.83 .394 .199 r
.66879 .2818 .69133 .30876 .6706 .29783 .6481 .26793 Metetra
.841 .437 .276 r
.6481 .26793 .6706 .29783 .64973 .28673 .62728 .25406 Metetra
.845 .465 .33 r
.62728 .25406 .64973 .28673 .62874 .27543 .60636 .24022 Metetra
.846 .484 .368 r
.60636 .24022 .62874 .27543 .60761 .26387 .58533 .22643 Metetra
.845 .497 .395 r
.58533 .22643 .60761 .26387 .58635 .25203 .56417 .21273 Metetra
.843 .506 .414 r
.56417 .21273 .58635 .25203 .56496 .23986 .5429 .19913 Metetra
.842 .511 .428 r
.5429 .19913 .56496 .23986 .54344 .22735 .52151 .18565 Metetra
.841 .515 .437 r
.52151 .18565 .54344 .22735 .52178 .21448 .5 .17231 Metetra
.839 .516 .442 r
.5 .17231 .52178 .21448 .5 .20123 .47836 .1591 Metetra
.838 .516 .443 r
.47836 .1591 .5 .20123 .47809 .18761 .4566 .14604 Metetra
.837 .514 .441 r
.4566 .14604 .47809 .18761 .45605 .17362 .4347 .13311 Metetra
.427 .633 .941 r
.95029 .45552 .97299 .46068 .95361 .44742 .93098 .44318 Metetra
.455 .645 .939 r
.93098 .44318 .95361 .44742 .93416 .43479 .91158 .43105 Metetra
.467 .652 .94 r
.91158 .43105 .93416 .43479 .91464 .4228 .89209 .41915 Metetra
.462 .655 .944 r
.89209 .41915 .91464 .4228 .89505 .41147 .87251 .40746 Metetra
.438 .653 .95 r
.87251 .40746 .89505 .41147 .87537 .40077 .85282 .39598 Metetra
.392 .644 .957 r
.85282 .39598 .87537 .40077 .8556 .39068 .83303 .38471 Metetra
.31 .621 .958 r
.83303 .38471 .8556 .39068 .83574 .38113 .81314 .37361 Metetra
.176 .567 .935 r
.81314 .37361 .83574 .38113 .81577 .37207 .79313 .36266 Metetra
0 .459 .852 r
.79313 .36266 .81577 .37207 .79569 .36339 .77301 .35182 Metetra
0 .282 .672 r
.77301 .35182 .79569 .36339 .77548 .35501 .75278 .34106 Metetra
.51 0 0 r
.75278 .34106 .77548 .35501 .75515 .34681 .73242 .33033 Metetra
.662 .108 0 r
.73242 .33033 .75515 .34681 .73468 .33868 .71194 .31958 Metetra
.744 .233 0 r
.71194 .31958 .73468 .33868 .71408 .33049 .69133 .30876 Metetra
.786 .316 .121 r
.69133 .30876 .71408 .33049 .69333 .32213 .6706 .29783 Metetra
.808 .371 .206 r
.6706 .29783 .69333 .32213 .67243 .31346 .64973 .28673 Metetra
.82 .408 .265 r
.64973 .28673 .67243 .31346 .65138 .30438 .62874 .27543 Metetra
.827 .434 .306 r
.62874 .27543 .65138 .30438 .63019 .29478 .60761 .26387 Metetra
.831 .452 .334 r
.60761 .26387 .63019 .29478 .60884 .28457 .58635 .25203 Metetra
.834 .464 .353 r
.58635 .25203 .60884 .28457 .58735 .27366 .56496 .23986 Metetra
.837 .473 .365 r
.56496 .23986 .58735 .27366 .56572 .26199 .54344 .22735 Metetra
.838 .478 .372 r
.54344 .22735 .56572 .26199 .54395 .24952 .52178 .21448 Metetra
.84 .48 .373 r
.52178 .21448 .54395 .24952 .52204 .23623 .5 .20123 Metetra
.842 .48 .368 r
.5 .20123 .52204 .23623 .5 .22211 .47809 .18761 Metetra
.843 .476 .358 r
.47809 .18761 .5 .22211 .47784 .20719 .45605 .17362 Metetra
.609 .654 .87 r
.97299 .46068 .99551 .45894 .97608 .4451 .95361 .44742 Metetra
.614 .662 .873 r
.95361 .44742 .97608 .4451 .9566 .43214 .93416 .43479 Metetra
.616 .67 .879 r
.93416 .43479 .9566 .43214 .93707 .42008 .91464 .4228 Metetra
.615 .679 .887 r
.91464 .4228 .93707 .42008 .91748 .40893 .89505 .41147 Metetra
.609 .688 .899 r
.89505 .41147 .91748 .40893 .89781 .39867 .87537 .40077 Metetra
.597 .697 .913 r
.87537 .40077 .89781 .39867 .87807 .38926 .8556 .39068 Metetra
.578 .706 .93 r
.8556 .39068 .87807 .38926 .85823 .38061 .83574 .38113 Metetra
.547 .712 .948 r
.83574 .38113 .85823 .38061 .8383 .37265 .81577 .37207 Metetra
.501 .714 .967 r
.81577 .37207 .8383 .37265 .81825 .36524 .79569 .36339 Metetra
.433 .707 .98 r
.79569 .36339 .81825 .36524 .79808 .35826 .77548 .35501 Metetra
.336 .682 .979 r
.77548 .35501 .79808 .35826 .77777 .35155 .75515 .34681 Metetra
.205 .63 .95 r
.75515 .34681 .77777 .35155 .75733 .34497 .73468 .33868 Metetra
.046 .545 .882 r
.73468 .33868 .75733 .34497 .73674 .33833 .71408 .33049 Metetra
0 .434 .778 r
.71408 .33049 .73674 .33833 .716 .33148 .69333 .32213 Metetra
0 .316 .658 r
.69333 .32213 .716 .33148 .69509 .32425 .67243 .31346 Metetra
.382 0 0 r
.67243 .31346 .69509 .32425 .67403 .31649 .65138 .30438 Metetra
.464 0 0 r
.65138 .30438 .67403 .31649 .65281 .30804 .63019 .29478 Metetra
.519 0 0 r
.63019 .29478 .65281 .30804 .63142 .29878 .60884 .28457 Metetra
.551 0 0 r
.60884 .28457 .63142 .29878 .60988 .2886 .58735 .27366 Metetra
.564 0 0 r
.58735 .27366 .60988 .2886 .58819 .27741 .56572 .26199 Metetra
.56 0 0 r
.56572 .26199 .58819 .27741 .56635 .26515 .54395 .24952 Metetra
.536 0 0 r
.54395 .24952 .56635 .26515 .54436 .2518 .52204 .23623 Metetra
.49 0 0 r
.52204 .23623 .54436 .2518 .52225 .23735 .5 .22211 Metetra
.418 0 0 r
.5 .22211 .52225 .23735 .5 .22182 .47784 .20719 Metetra
0 g
.25 Mabswid
.01316 .30879 m
.5 0 L
s
.5 0 m
.5 .23547 L
s
.5 .23547 m
0 .53669 L
s
0 .53669 m
.01316 .30879 L
s
.98684 .30879 m
.5 0 L
s
.5 0 m
.5 .23547 L
s
.5 .23547 m
1 .53669 L
s
1 .53669 m
.98684 .30879 L
s
.98684 .30879 m
.5 0 L
s
.98684 .30879 m
.98138 .31183 L
s
[(-2)] .99777 .30272 -1 .55597 Mshowa
.87124 .23547 m
.86582 .23858 L
s
[(-1)] .88208 .22925 -1 .57367 Mshowa
.7517 .15965 m
.74632 .16283 L
s
[(0)] .76245 .15327 -1 .59254 Mshowa
.62803 .0812 m
.6227 .08447 L
s
[(1)] .63869 .07467 -1 .6127 Mshowa
.5 0 m
.49472 .00335 L
s
[(2)] .51056 -0.0067 -1 .63427 Mshowa
.125 Mabswid
.96403 .29432 m
.96075 .29615 L
s
.94106 .27975 m
.93779 .28159 L
s
.91794 .26509 m
.91468 .26694 L
s
.89467 .25033 m
.89141 .25218 L
s
.84765 .22051 m
.8444 .22238 L
s
.82391 .20544 m
.82066 .20733 L
s
.8 .19028 m
.79676 .19217 L
s
.77593 .17502 m
.7727 .17692 L
s
.7273 .14417 m
.72408 .14609 L
s
.70274 .12859 m
.69952 .13052 L
s
.67801 .1129 m
.6748 .11484 L
s
.6531 .09711 m
.6499 .09906 L
s
.60278 .06519 m
.59959 .06716 L
s
.57735 .04906 m
.57417 .05104 L
s
.55175 .03282 m
.54857 .03481 L
s
.52596 .01647 m
.52279 .01847 L
s
gsave
.81622 .12141 -61 -11.8134 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell[TextData[{
              StyleBox["option name", "SO10"],
              " "
            }]], Cell[TextData[{
              StyleBox["default value", "SO10"],
              " "
            }]], Cell[""]},
          {Cell[TextData[{
              StyleBox["ViewPoint", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{1.3,", "MR"],
              " ",
              StyleBox["-2.4,", "MR"],
              " ",
              StyleBox["2}", "MR"],
              " "
            }]], 
            Cell["\<\
the point in a special scaled coordinate system from \
which to view the object \
\>"]},
          {Cell[TextData[{
              StyleBox["ViewCenter", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["Automatic", "MR"],
              " "
            }]], 
            Cell["\<\
the point in the scaled coordinate system which appears \
at the center of the final image \
\>"]},
          {Cell[TextData[{
              StyleBox["ViewVertical", "MR"],
              " "
            }]], Cell[TextData[{
              StyleBox["{0,", "MR"],
              " ",
              StyleBox["0,", "MR"],
              " ",
              StyleBox["1}", "MR"],
              " "
            }]], 
            Cell["\<\
the direction in the scaled coordinate system which \
appears as vertical in the final image \
\>"]}
          },
        ColumnAlignments->{Left}], TraditionalForm]], "DefinitionBox3Col",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->{True, False}},
  CellTags->"S2.10.10"],

Cell["\<\
Specifying the position and orientation of \
three\[Hyphen]dimensional objects. \
\>", "Caption",
  CellTags->"S2.10.10"],

Cell[TextData[{
  "In making a picture of a three\[Hyphen]dimensional object you have to \
specify more than just ",
  StyleBox["where", "TI"],
  " you want to look at the object from. You also have to specify how you \
want to \[OpenCurlyDoubleQuote]frame\[CloseCurlyDoubleQuote] the object in \
your final image. You can do this using the additional options ",
  StyleBox["ViewCenter", "MR"],
  " and ",
  StyleBox["ViewVertical", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.10", "10.18"}],

Cell[TextData[{
  StyleBox["ViewCenter", "MR"],
  " allows you to tell ",
  StyleBox["Mathematica", "TI"],
  " what point in the object should appear at the center of your final image. \
The point is specified by giving its scaled coordinates, running from 0 to 1 \
in each direction across the box. With the setting ",
  StyleBox["ViewCenter", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{1/2,", "MR"],
  " ",
  StyleBox["1/2,", "MR"],
  " ",
  StyleBox["1/2}", "MR"],
  ", the center of the box will therefore appear at the center of your final \
image. With many choices of view point, however, the box will not appear \
symmetrical, so this setting for ",
  StyleBox["ViewCenter", "MR"],
  " will not center the whole box in the final image area. You can do this by \
setting ",
  StyleBox["ViewCenter", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["Automatic", "MR"],
  ". "
}], "Text",
  CellTags->{"S2.10.10", "10.19"}],

Cell[TextData[{
  StyleBox["ViewVertical", "MR"],
  " specifies which way up the object should appear in your final image. The \
setting for ",
  StyleBox["ViewVertical", "MR"],
  " gives the direction in scaled coordinates which ends up vertical in the \
final image. With the default setting ",
  StyleBox["ViewVertical", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["{0,", "MR"],
  " ",
  StyleBox["0,", "MR"],
  " ",
  StyleBox["1}", "MR"],
  ", the ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " direction in your original coordinate system always ends up vertical in \
the final image. "
}], "Text",
  CellTags->{"S2.10.10", "10.20"}],

Cell[TextData[{
  "With this setting for ",
  StyleBox["ViewCenter", "MR"],
  ", a corner of the box appears in the center of your image. "
}], "MathCaption",
  CellTags->{"S2.10.10", "10.21"}],

Cell[CellGroupData[{

Cell["Show[surf, ViewCenter -> {1, 1, 1}]", "Input",
  CellLabel->"In[10]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[.02479 .22415 -11.2198 -9 ]
[.02479 .22415 .78021 0 ]
[.10987 .20549 -10.6128 -9 ]
[.10987 .20549 1.38715 0 ]
[.19826 .18613 -5.00296 -9 ]
[.19826 .18613 .99704 0 ]
[.29016 .16605 -4.69949 -9 ]
[.29016 .16605 1.30051 0 ]
[.38576 .14521 -4.39602 -9 ]
[.38576 .14521 1.60398 0 ]
[.16356 .13415 -8.33826 -9.8125 ]
[.16356 .13415 1.66174 0 ]
[.03685 .40504 -7.47818 0 ]
[.03685 .40504 4.52182 9 ]
[.10713 .47277 -3.60514 0 ]
[.10713 .47277 2.39486 9 ]
[.16662 .53009 -3.49883 0 ]
[.16662 .53009 2.50117 9 ]
[.09478 .53404 -6.04611 0 ]
[.09478 .53404 4.01639 9.8125 ]
[.01521 .2565 -12 -3.55093 ]
[.01521 .2565 0 5.44907 ]
[.00489 .29407 -6 -3.58635 ]
[.00489 .29407 0 5.41365 ]
[-0.00588 .33332 -6 -3.62353 ]
[-0.00588 .33332 0 5.37647 ]
[-0.05644 .30679 -10 -3.91042 ]
[-0.05644 .30679 0 5.90208 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.033 .23358 m
.39104 .15655 L
s
.033 .23358 m
.0371 .23829 L
s
[(-2)] .02479 .22415 .86996 1 Mshowa
.11749 .2154 m
.1213 .22035 L
s
[(-1)] .10987 .20549 .76881 1 Mshowa
.2052 .19653 m
.20867 .20173 L
s
[(0)] .19826 .18613 .66765 1 Mshowa
.29632 .17692 m
.2994 .18236 L
s
[(1)] .29016 .16605 .5665 1 Mshowa
.39104 .15655 m
.39367 .16221 L
s
[(2)] .38576 .14521 .46534 1 Mshowa
.125 Mabswid
.04965 .22999 m
.05208 .23285 L
s
.06642 .22639 m
.06882 .22927 L
s
.08332 .22275 m
.08568 .22566 L
s
.10034 .21909 m
.10266 .22203 L
s
.13477 .21168 m
.13702 .21468 L
s
.15218 .20793 m
.15439 .21097 L
s
.16972 .20416 m
.17189 .20722 L
s
.1874 .20036 m
.18952 .20345 L
s
.22315 .19267 m
.22519 .19581 L
s
.24123 .18878 m
.24322 .19195 L
s
.25945 .18486 m
.2614 .18806 L
s
.27781 .18091 m
.27971 .18414 L
s
.31497 .17291 m
.31676 .1762 L
s
.33376 .16887 m
.33551 .17219 L
s
.3527 .16479 m
.3544 .16814 L
s
.37179 .16069 m
.37343 .16406 L
s
gsave
.16356 .13415 -69.3383 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
0 .35429 m
.19493 .54321 L
s
.03984 .39291 m
.04134 .38684 L
s
[(-2)] .03685 .40504 .24636 -1 Mshowa
.10961 .46052 m
.11084 .45439 L
s
[(0)] .10713 .47277 .20171 -1 Mshowa
.16867 .51776 m
.16969 .51159 L
s
[(2)] .16662 .53009 .16628 -1 Mshowa
.125 Mabswid
.05844 .41093 m
.0593 .40728 L
s
.07624 .42818 m
.07705 .42452 L
s
.09327 .44469 m
.09405 .44102 L
s
.12527 .4757 m
.12598 .47202 L
s
.14031 .49028 m
.14099 .48659 L
s
.15477 .50429 m
.15541 .50059 L
s
.02038 .37405 m
.02133 .37042 L
s
.18205 .53072 m
.18263 .52702 L
s
gsave
.09478 .53404 -67.0461 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.033 .23358 m
0 .35429 L
s
.02744 .25392 m
.03355 .25263 L
s
[(-2)] .01521 .2565 1 -0.21091 Mshowa
.01714 .29159 m
.02327 .29034 L
s
[(0)] .00489 .29407 1 -0.20303 Mshowa
.00639 .33093 m
.01252 .32974 L
s
[(2)] -0.00588 .33332 1 -0.19477 Mshowa
.125 Mabswid
.0249 .26318 m
.02858 .26242 L
s
.02234 .27255 m
.02602 .27179 L
s
.01976 .28202 m
.02343 .28126 L
s
.0145 .30126 m
.01817 .30052 L
s
.01182 .31104 m
.0155 .31031 L
s
.00912 .32093 m
.0128 .32021 L
s
.02994 .24475 m
.03361 .24397 L
s
.03242 .23568 m
.03609 .23489 L
s
.00362 .34105 m
.0073 .34034 L
s
.00083 .35127 m
.00451 .35057 L
s
gsave
-0.05644 .30679 -71 -7.91042 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.033 .23358 m
0 .35429 L
s
0 .35429 m
.19493 .54321 L
s
.19493 .54321 m
.21083 .43799 L
s
.21083 .43799 m
.033 .23358 L
s
.39104 .15655 m
.5 .39071 L
s
.5 .39071 m
.5 .5 L
s
.5 .5 m
.38268 .28164 L
s
.38268 .28164 m
.39104 .15655 L
s
.033 .23358 m
0 .35429 L
s
0 .35429 m
.38268 .28164 L
s
.38268 .28164 m
.39104 .15655 L
s
.39104 .15655 m
.033 .23358 L
s
.21083 .43799 m
.5 .39071 L
s
.5 .39071 m
.5 .5 L
s
.5 .5 m
.19493 .54321 L
s
.19493 .54321 m
.21083 .43799 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.683 .669 .83 r
.19497 .49557 .20045 .50668 .21235 .50399 .20689 .49309 Metetra
.676 .669 .836 r
.20689 .49309 .21235 .50399 .22423 .50174 .21883 .49092 Metetra
.668 .668 .841 r
.21883 .49092 .22423 .50174 .23611 .49993 .23077 .48908 Metetra
.66 .664 .843 r
.23077 .48908 .23611 .49993 .24799 .49857 .24274 .48757 Metetra
.652 .658 .843 r
.24274 .48757 .24799 .49857 .25988 .49764 .25472 .48637 Metetra
.645 .651 .841 r
.25472 .48637 .25988 .49764 .27179 .49713 .26674 .48549 Metetra
.639 .642 .837 r
.26674 .48549 .27179 .49713 .28373 .49701 .27879 .48488 Metetra
.634 .632 .831 r
.27879 .48488 .28373 .49701 .29572 .49723 .2909 .48452 Metetra
.631 .622 .823 r
.2909 .48452 .29572 .49723 .30777 .49774 .30307 .48438 Metetra
.629 .613 .815 r
.30307 .48438 .30777 .49774 .31989 .49847 .31531 .48439 Metetra
.628 .603 .806 r
.31531 .48439 .31989 .49847 .33209 .49937 .32762 .48452 Metetra
.628 .595 .797 r
.32762 .48452 .33209 .49937 .34439 .50034 .34002 .48471 Metetra
.63 .588 .788 r
.34002 .48471 .34439 .50034 .35678 .50133 .35251 .4849 Metetra
.632 .582 .78 r
.35251 .4849 .35678 .50133 .36927 .50225 .3651 .48503 Metetra
.635 .577 .772 r
.3651 .48503 .36927 .50225 .38188 .50301 .37779 .48505 Metetra
.638 .573 .765 r
.37779 .48505 .38188 .50301 .3946 .50356 .39058 .4849 Metetra
.642 .571 .759 r
.39058 .4849 .3946 .50356 .40743 .50381 .40347 .48453 Metetra
.646 .57 .754 r
.40347 .48453 .40743 .50381 .42038 .5037 .41646 .4839 Metetra
.65 .569 .75 r
.41646 .4839 .42038 .5037 .43342 .50319 .42954 .48296 Metetra
.654 .57 .747 r
.42954 .48296 .43342 .50319 .44657 .50223 .44273 .4817 Metetra
.659 .571 .745 r
.44273 .4817 .44657 .50223 .45981 .50078 .456 .48007 Metetra
.663 .573 .744 r
.456 .48007 .45981 .50078 .47314 .49885 .46935 .47808 Metetra
.668 .576 .743 r
.46935 .47808 .47314 .49885 .48654 .49641 .48277 .47573 Metetra
.672 .58 .744 r
.48277 .47573 .48654 .49641 .5 .4935 .49627 .47302 Metetra
.672 .62 .789 r
.18992 .48107 .19497 .49557 .20689 .49309 .20183 .47896 Metetra
.67 .624 .794 r
.20183 .47896 .20689 .49309 .21883 .49092 .21379 .47696 Metetra
.668 .625 .797 r
.21379 .47696 .21883 .49092 .23077 .48908 .22579 .47509 Metetra
.665 .624 .798 r
.22579 .47509 .23077 .48908 .24274 .48757 .23782 .47334 Metetra
.663 .62 .796 r
.23782 .47334 .24274 .48757 .25472 .48637 .24991 .47172 Metetra
.661 .615 .792 r
.24991 .47172 .25472 .48637 .26674 .48549 .26204 .47021 Metetra
.658 .607 .786 r
.26204 .47021 .26674 .48549 .27879 .48488 .27423 .46881 Metetra
.657 .599 .778 r
.27423 .46881 .27879 .48488 .2909 .48452 .28648 .4675 Metetra
.655 .589 .769 r
.28648 .4675 .2909 .48452 .30307 .48438 .29879 .46627 Metetra
.654 .58 .76 r
.29879 .46627 .30307 .48438 .31531 .48439 .31117 .4651 Metetra
.653 .571 .75 r
.31117 .4651 .31531 .48439 .32762 .48452 .32361 .46396 Metetra
.652 .563 .741 r
.32361 .46396 .32762 .48452 .34002 .48471 .33613 .46284 Metetra
.652 .555 .733 r
.33613 .46284 .34002 .48471 .35251 .4849 .34873 .46171 Metetra
.651 .549 .725 r
.34873 .46171 .35251 .4849 .3651 .48503 .3614 .46055 Metetra
.651 .543 .718 r
.3614 .46055 .3651 .48503 .37779 .48505 .37416 .45934 Metetra
.652 .538 .712 r
.37416 .45934 .37779 .48505 .39058 .4849 .38699 .45806 Metetra
.652 .534 .707 r
.38699 .45806 .39058 .4849 .40347 .48453 .39991 .45668 Metetra
.653 .531 .703 r
.39991 .45668 .40347 .48453 .41646 .4839 .41291 .4552 Metetra
.653 .529 .7 r
.41291 .4552 .41646 .4839 .42954 .48296 .42599 .45358 Metetra
.654 .528 .697 r
.42599 .45358 .42954 .48296 .44273 .4817 .43915 .45183 Metetra
.655 .527 .696 r
.43915 .45183 .44273 .4817 .456 .48007 .45239 .44993 Metetra
.656 .527 .695 r
.45239 .44993 .456 .48007 .46935 .47808 .4657 .44788 Metetra
.657 .528 .695 r
.4657 .44788 .46935 .47808 .48277 .47573 .47909 .44568 Metetra
.659 .53 .696 r
.47909 .44568 .48277 .47573 .49627 .47302 .49255 .44333 Metetra
.663 .602 .776 r
.18503 .46514 .18992 .48107 .20183 .47896 .19691 .46345 Metetra
.665 .608 .781 r
.19691 .46345 .20183 .47896 .21379 .47696 .20887 .46166 Metetra
.667 .611 .783 r
.20887 .46166 .21379 .47696 .22579 .47509 .22091 .45976 Metetra
.669 .613 .783 r
.22091 .45976 .22579 .47509 .23782 .47334 .23303 .45774 Metetra
.67 .611 .781 r
.23303 .45774 .23782 .47334 .24991 .47172 .24522 .45563 Metetra
.671 .608 .776 r
.24522 .45563 .24991 .47172 .26204 .47021 .25748 .4534 Metetra
.672 .602 .769 r
.25748 .4534 .26204 .47021 .27423 .46881 .26981 .45109 Metetra
.672 .595 .761 r
.26981 .45109 .27423 .46881 .28648 .4675 .28221 .44869 Metetra
.672 .587 .752 r
.28221 .44869 .28648 .4675 .29879 .46627 .29467 .44621 Metetra
.671 .578 .743 r
.29467 .44621 .29879 .46627 .31117 .4651 .3072 .44367 Metetra
.67 .57 .734 r
.3072 .44367 .31117 .4651 .32361 .46396 .31979 .44109 Metetra
.668 .561 .725 r
.31979 .44109 .32361 .46396 .33613 .46284 .33243 .43848 Metetra
.667 .553 .717 r
.33243 .43848 .33613 .46284 .34873 .46171 .34514 .43586 Metetra
.665 .546 .71 r
.34514 .43586 .34873 .46171 .3614 .46055 .35791 .43325 Metetra
.663 .54 .704 r
.35791 .43325 .3614 .46055 .37416 .45934 .37073 .43065 Metetra
.662 .534 .698 r
.37073 .43065 .37416 .45934 .38699 .45806 .3836 .42809 Metetra
.66 .529 .693 r
.3836 .42809 .38699 .45806 .39991 .45668 .39654 .42558 Metetra
.659 .525 .69 r
.39654 .42558 .39991 .45668 .41291 .4552 .40954 .42314 Metetra
.657 .521 .687 r
.40954 .42314 .41291 .4552 .42599 .45358 .42259 .42077 Metetra
.656 .519 .685 r
.42259 .42077 .42599 .45358 .43915 .45183 .43571 .41848 Metetra
.655 .517 .683 r
.43571 .41848 .43915 .45183 .45239 .44993 .44889 .41627 Metetra
.654 .515 .682 r
.44889 .41627 .45239 .44993 .4657 .44788 .46214 .41416 Metetra
.653 .515 .682 r
.46214 .41416 .4657 .44788 .47909 .44568 .47547 .41214 Metetra
.652 .515 .683 r
.47547 .41214 .47909 .44568 .49255 .44333 .48886 .4102 Metetra
.656 .607 .788 r
.17993 .45001 .18503 .46514 .19691 .46345 .1918 .4487 Metetra
.661 .615 .792 r
.1918 .4487 .19691 .46345 .20887 .46166 .20377 .44709 Metetra
.667 .621 .794 r
.20377 .44709 .20887 .46166 .22091 .45976 .21586 .44515 Metetra
.673 .624 .792 r
.21586 .44515 .22091 .45976 .23303 .45774 .22806 .4429 Metetra
.678 .625 .789 r
.22806 .4429 .23303 .45774 .24522 .45563 .24035 .44034 Metetra
.682 .623 .784 r
.24035 .44034 .24522 .45563 .25748 .4534 .25274 .43747 Metetra
.685 .619 .776 r
.25274 .43747 .25748 .4534 .26981 .45109 .26521 .43434 Metetra
.687 .614 .768 r
.26521 .43434 .26981 .45109 .28221 .44869 .27776 .43096 Metetra
.688 .606 .76 r
.27776 .43096 .28221 .44869 .29467 .44621 .29038 .42738 Metetra
.688 .598 .751 r
.29038 .42738 .29467 .44621 .3072 .44367 .30306 .42364 Metetra
.687 .59 .742 r
.30306 .42364 .3072 .44367 .31979 .44109 .3158 .41979 Metetra
.685 .582 .733 r
.3158 .41979 .31979 .44109 .33243 .43848 .32858 .41587 Metetra
.683 .573 .726 r
.32858 .41587 .33243 .43848 .34514 .43586 .3414 .41193 Metetra
.68 .565 .719 r
.3414 .41193 .34514 .43586 .35791 .43325 .35426 .40804 Metetra
.677 .558 .712 r
.35426 .40804 .35791 .43325 .37073 .43065 .36715 .40423 Metetra
.674 .551 .707 r
.36715 .40423 .37073 .43065 .3836 .42809 .38009 .40056 Metetra
.671 .545 .702 r
.38009 .40056 .3836 .42809 .39654 .42558 .39305 .39707 Metetra
.668 .539 .699 r
.39305 .39707 .39654 .42558 .40954 .42314 .40606 .39379 Metetra
.664 .534 .696 r
.40606 .39379 .40954 .42314 .42259 .42077 .41911 .39076 Metetra
.661 .53 .694 r
.41911 .39076 .42259 .42077 .43571 .41848 .4322 .388 Metetra
.658 .527 .692 r
.4322 .388 .43571 .41848 .44889 .41627 .44535 .38553 Metetra
.655 .524 .692 r
.44535 .38553 .44889 .41627 .46214 .41416 .45856 .38335 Metetra
.653 .522 .692 r
.45856 .38335 .46214 .41416 .47547 .41214 .47183 .38147 Metetra
.65 .521 .693 r
.47183 .38147 .47547 .41214 .48886 .4102 .48518 .37989 Metetra
.648 .641 .83 r
.17429 .43769 .17993 .45001 .1918 .4487 .18617 .43661 Metetra
.658 .651 .832 r
.18617 .43661 .1918 .4487 .20377 .44709 .19819 .43509 Metetra
.668 .658 .831 r
.19819 .43509 .20377 .44709 .21586 .44515 .21034 .43312 Metetra
.677 .663 .828 r
.21034 .43312 .21586 .44515 .22806 .4429 .22262 .4307 Metetra
.686 .665 .824 r
.22262 .4307 .22806 .4429 .24035 .44034 .23503 .42784 Metetra
.693 .665 .818 r
.23503 .42784 .24035 .44034 .25274 .43747 .24754 .42455 Metetra
.699 .663 .811 r
.24754 .42455 .25274 .43747 .26521 .43434 .26014 .42088 Metetra
.704 .659 .803 r
.26014 .42088 .26521 .43434 .27776 .43096 .27283 .41687 Metetra
.707 .654 .795 r
.27283 .41687 .27776 .43096 .29038 .42738 .28559 .41257 Metetra
.708 .647 .786 r
.28559 .41257 .29038 .42738 .30306 .42364 .29842 .40805 Metetra
.708 .639 .778 r
.29842 .40805 .30306 .42364 .3158 .41979 .31129 .40337 Metetra
.707 .631 .771 r
.31129 .40337 .3158 .41979 .32858 .41587 .3242 .39861 Metetra
.705 .623 .763 r
.3242 .39861 .32858 .41587 .3414 .41193 .33714 .39383 Metetra
.701 .615 .757 r
.33714 .39383 .3414 .41193 .35426 .40804 .3501 .38912 Metetra
.698 .607 .751 r
.3501 .38912 .35426 .40804 .36715 .40423 .36309 .38453 Metetra
.693 .599 .746 r
.36309 .38453 .36715 .40423 .38009 .40056 .3761 .38015 Metetra
.689 .591 .742 r
.3761 .38015 .38009 .40056 .39305 .39707 .38913 .37602 Metetra
.684 .584 .738 r
.38913 .37602 .39305 .39707 .40606 .39379 .40219 .37221 Metetra
.678 .578 .735 r
.40219 .37221 .40606 .39379 .41911 .39076 .41528 .36875 Metetra
.673 .572 .733 r
.41528 .36875 .41911 .39076 .4322 .388 .4284 .36568 Metetra
.667 .567 .732 r
.4284 .36568 .4322 .388 .44535 .38553 .44157 .36303 Metetra
.662 .562 .732 r
.44157 .36303 .44535 .38553 .45856 .38335 .45479 .3608 Metetra
.657 .559 .733 r
.45479 .3608 .45856 .38335 .47183 .38147 .46807 .359 Metetra
.651 .556 .734 r
.46807 .359 .47183 .38147 .48518 .37989 .48143 .35761 Metetra
.627 .718 .912 r
.16782 .42946 .17429 .43769 .18617 .43661 .17978 .42839 Metetra
.643 .726 .909 r
.17978 .42839 .18617 .43661 .19819 .43509 .19188 .42686 Metetra
.658 .732 .904 r
.19188 .42686 .19819 .43509 .21034 .43312 .20413 .42486 Metetra
.673 .738 .899 r
.20413 .42486 .21034 .43312 .22262 .4307 .21651 .42237 Metetra
.686 .742 .894 r
.21651 .42237 .22262 .4307 .23503 .42784 .22902 .41942 Metetra
.697 .745 .889 r
.22902 .41942 .23503 .42784 .24754 .42455 .24164 .41602 Metetra
.707 .747 .883 r
.24164 .41602 .24754 .42455 .26014 .42088 .25436 .4122 Metetra
.716 .748 .878 r
.25436 .4122 .26014 .42088 .27283 .41687 .26717 .40803 Metetra
.722 .748 .873 r
.26717 .40803 .27283 .41687 .28559 .41257 .28005 .40355 Metetra
.727 .747 .868 r
.28005 .40355 .28559 .41257 .29842 .40805 .293 .39884 Metetra
.73 .745 .865 r
.293 .39884 .29842 .40805 .31129 .40337 .30599 .39396 Metetra
.731 .743 .861 r
.30599 .39396 .31129 .40337 .3242 .39861 .31902 .38899 Metetra
.73 .74 .859 r
.31902 .38899 .3242 .39861 .33714 .39383 .33208 .38401 Metetra
.728 .736 .857 r
.33208 .38401 .33714 .39383 .3501 .38912 .34516 .37909 Metetra
.725 .732 .856 r
.34516 .37909 .3501 .38912 .36309 .38453 .35827 .37432 Metetra
.72 .727 .855 r
.35827 .37432 .36309 .38453 .3761 .38015 .37139 .36976 Metetra
.714 .721 .855 r
.37139 .36976 .3761 .38015 .38913 .37602 .38453 .36547 Metetra
.707 .716 .856 r
.38453 .36547 .38913 .37602 .40219 .37221 .39769 .36151 Metetra
.698 .709 .857 r
.39769 .36151 .40219 .37221 .41528 .36875 .41088 .35793 Metetra
.689 .703 .858 r
.41088 .35793 .41528 .36875 .4284 .36568 .4241 .35477 Metetra
.679 .697 .86 r
.4241 .35477 .4284 .36568 .44157 .36303 .43737 .35204 Metetra
.668 .69 .862 r
.43737 .35204 .44157 .36303 .45479 .3608 .45069 .34976 Metetra
.657 .684 .864 r
.45069 .34976 .45479 .3608 .46807 .359 .46407 .34794 Metetra
.645 .678 .866 r
.46407 .34794 .46807 .359 .48143 .35761 .47753 .34656 Metetra
.527 .822 .999 r
.16043 .42562 .16782 .42946 .17978 .42839 .17253 .42434 Metetra
.562 .829 .996 r
.17253 .42434 .17978 .42839 .19188 .42686 .18477 .42269 Metetra
.59 .836 .991 r
.18477 .42269 .19188 .42686 .20413 .42486 .19714 .42064 Metetra
.612 .843 .987 r
.19714 .42064 .20413 .42486 .21651 .42237 .20963 .4182 Metetra
.63 .851 .984 r
.20963 .4182 .21651 .42237 .22902 .41942 .22224 .41537 Metetra
.643 .86 .982 r
.22224 .41537 .22902 .41942 .24164 .41602 .23496 .41218 Metetra
.653 .871 .981 r
.23496 .41218 .24164 .41602 .25436 .4122 .24777 .40865 Metetra
.658 .883 .981 r
.24777 .40865 .25436 .4122 .26717 .40803 .26067 .40482 Metetra
.658 .895 .981 r
.26067 .40482 .26717 .40803 .28005 .40355 .27365 .40074 Metetra
.652 .907 .981 r
.27365 .40074 .28005 .40355 .293 .39884 .28669 .39646 Metetra
.64 .917 .979 r
.28669 .39646 .293 .39884 .30599 .39396 .29978 .39204 Metetra
.619 .924 .973 r
.29978 .39204 .30599 .39396 .31902 .38899 .31292 .38754 Metetra
.589 .925 .962 r
.31292 .38754 .31902 .38899 .33208 .38401 .32609 .38304 Metetra
.548 .918 .944 r
.32609 .38304 .33208 .38401 .34516 .37909 .3393 .37858 Metetra
.495 .901 .916 r
.3393 .37858 .34516 .37909 .35827 .37432 .35254 .37423 Metetra
.434 .873 .88 r
.35254 .37423 .35827 .37432 .37139 .36976 .36581 .37006 Metetra
.365 .836 .836 r
.36581 .37006 .37139 .36976 .38453 .36547 .3791 .3661 Metetra
.294 .791 .788 r
.3791 .3661 .38453 .36547 .39769 .36151 .39243 .36242 Metetra
.225 .743 .74 r
.39243 .36242 .39769 .36151 .41088 .35793 .40579 .35904 Metetra
.162 .695 .696 r
.40579 .35904 .41088 .35793 .4241 .35477 .41919 .356 Metetra
.41919 .356 .4241 .35477 .43737 .35204 .43265 .35332 Metetra
.43265 .35332 .43737 .35204 .45069 .34976 .44616 .351 Metetra
.44616 .351 .45069 .34976 .46407 .34794 .45974 .34906 Metetra
.45974 .34906 .46407 .34794 .47753 .34656 .47339 .34748 Metetra
.258 .766 .859 r
.15219 .4254 .16043 .42562 .17253 .42434 .1645 .42373 Metetra
.325 .803 .902 r
.1645 .42373 .17253 .42434 .18477 .42269 .17691 .42185 Metetra
.369 .826 .924 r
.17691 .42185 .18477 .42269 .19714 .42064 .18942 .41976 Metetra
.392 .838 .931 r
.18942 .41976 .19714 .42064 .20963 .4182 .20204 .41746 Metetra
.397 .843 .926 r
.20204 .41746 .20963 .4182 .22224 .41537 .21474 .41495 Metetra
.382 .839 .907 r
.21474 .41495 .22224 .41537 .23496 .41218 .22754 .41223 Metetra
.346 .822 .871 r
.22754 .41223 .23496 .41218 .24777 .40865 .24043 .40934 Metetra
.288 .788 .813 r
.24043 .40934 .24777 .40865 .26067 .40482 .25339 .40628 Metetra
.207 .729 .727 r
.25339 .40628 .26067 .40482 .27365 .40074 .26643 .40308 Metetra
.26643 .40308 .27365 .40074 .28669 .39646 .27953 .39978 Metetra
.27953 .39978 .28669 .39646 .29978 .39204 .2927 .39639 Metetra
.09 0 0 r
.2927 .39639 .29978 .39204 .31292 .38754 .30593 .39295 Metetra
.175 0 0 r
.30593 .39295 .31292 .38754 .32609 .38304 .31921 .3895 Metetra
.245 0 0 r
.31921 .3895 .32609 .38304 .3393 .37858 .33255 .38606 Metetra
.3 0 0 r
.33255 .38606 .3393 .37858 .35254 .37423 .34594 .38268 Metetra
.344 0 .004 r
.34594 .38268 .35254 .37423 .36581 .37006 .35937 .37939 Metetra
.378 0 .056 r
.35937 .37939 .36581 .37006 .3791 .3661 .37286 .3762 Metetra
.405 0 .095 r
.37286 .3762 .3791 .3661 .39243 .36242 .3864 .37315 Metetra
.426 0 .125 r
.3864 .37315 .39243 .36242 .40579 .35904 .4 .37026 Metetra
.442 .022 .146 r
.4 .37026 .40579 .35904 .41919 .356 .41365 .36754 Metetra
.454 .038 .161 r
.41365 .36754 .41919 .356 .43265 .35332 .42737 .365 Metetra
.462 .049 .169 r
.42737 .365 .43265 .35332 .44616 .351 .44115 .36266 Metetra
.468 .054 .171 r
.44115 .36266 .44616 .351 .45974 .34906 .45501 .3605 Metetra
.47 .054 .167 r
.45501 .3605 .45974 .34906 .47339 .34748 .46894 .35854 Metetra
.14335 .42715 .15219 .4254 .1645 .42373 .15591 .42497 Metetra
.147 .689 .727 r
.15591 .42497 .1645 .42373 .17691 .42185 .16852 .42281 Metetra
.172 .708 .754 r
.16852 .42281 .17691 .42185 .18942 .41976 .18119 .42067 Metetra
.169 .706 .754 r
.18119 .42067 .18942 .41976 .20204 .41746 .19393 .41856 Metetra
.14 .684 .726 r
.19393 .41856 .20204 .41746 .21474 .41495 .20674 .41647 Metetra
.20674 .41647 .21474 .41495 .22754 .41223 .21961 .4144 Metetra
.21961 .4144 .22754 .41223 .24043 .40934 .23254 .41235 Metetra
.081 0 0 r
.23254 .41235 .24043 .40934 .25339 .40628 .24555 .41031 Metetra
.171 0 0 r
.24555 .41031 .25339 .40628 .26643 .40308 .25863 .40829 Metetra
.253 0 0 r
.25863 .40829 .26643 .40308 .27953 .39978 .27178 .40626 Metetra
.32 0 0 r
.27178 .40626 .27953 .39978 .2927 .39639 .28501 .40424 Metetra
.372 0 0 r
.28501 .40424 .2927 .39639 .30593 .39295 .29831 .40222 Metetra
.412 0 .058 r
.29831 .40222 .30593 .39295 .31921 .3895 .31169 .40018 Metetra
.442 .008 .117 r
.31169 .40018 .31921 .3895 .33255 .38606 .32515 .39812 Metetra
.464 .048 .164 r
.32515 .39812 .33255 .38606 .34594 .38268 .33868 .39604 Metetra
.481 .079 .2 r
.33868 .39604 .34594 .38268 .35937 .37939 .3523 .39393 Metetra
.493 .103 .228 r
.3523 .39393 .35937 .37939 .37286 .3762 .366 .39178 Metetra
.502 .121 .249 r
.366 .39178 .37286 .3762 .3864 .37315 .37979 .3896 Metetra
.509 .134 .265 r
.37979 .3896 .3864 .37315 .4 .37026 .39365 .38737 Metetra
.513 .143 .276 r
.39365 .38737 .4 .37026 .41365 .36754 .4076 .3851 Metetra
.516 .149 .283 r
.4076 .3851 .41365 .36754 .42737 .365 .42162 .38278 Metetra
.516 .151 .286 r
.42162 .38278 .42737 .365 .44115 .36266 .43574 .38041 Metetra
.516 .15 .285 r
.43574 .38041 .44115 .36266 .45501 .3605 .44993 .37799 Metetra
.513 .146 .281 r
.44993 .37799 .45501 .3605 .46894 .35854 .4642 .37552 Metetra
.196 .724 .745 r
.13432 .4286 .14335 .42715 .15591 .42497 .14712 .42592 Metetra
.215 .739 .78 r
.14712 .42592 .15591 .42497 .16852 .42281 .15994 .42348 Metetra
.209 .735 .79 r
.15994 .42348 .16852 .42281 .18119 .42067 .17278 .4213 Metetra
.177 .713 .775 r
.17278 .4213 .18119 .42067 .19393 .41856 .18564 .41937 Metetra
.121 .671 .733 r
.18564 .41937 .19393 .41856 .20674 .41647 .19854 .4177 Metetra
.19854 .4177 .20674 .41647 .21961 .4144 .21148 .41627 Metetra
.053 0 0 r
.21148 .41627 .21961 .4144 .23254 .41235 .22446 .41506 Metetra
.153 0 0 r
.22446 .41506 .23254 .41235 .24555 .41031 .23751 .41404 Metetra
.245 0 0 r
.23751 .41404 .24555 .41031 .25863 .40829 .25062 .41319 Metetra
.322 0 0 r
.25062 .41319 .25863 .40829 .27178 .40626 .26381 .41246 Metetra
.381 0 0 r
.26381 .41246 .27178 .40626 .28501 .40424 .27709 .41181 Metetra
.425 0 0 r
.27709 .41181 .28501 .40424 .29831 .40222 .29045 .41121 Metetra
.457 0 .067 r
.29045 .41121 .29831 .40222 .31169 .40018 .30392 .4106 Metetra
.479 .038 .122 r
.30392 .4106 .31169 .40018 .32515 .39812 .3175 .40994 Metetra
.495 .071 .165 r
.3175 .40994 .32515 .39812 .33868 .39604 .33118 .40919 Metetra
.505 .096 .198 r
.33118 .40919 .33868 .39604 .3523 .39393 .34498 .40829 Metetra
.512 .114 .223 r
.34498 .40829 .3523 .39393 .366 .39178 .35888 .40722 Metetra
.515 .127 .242 r
.35888 .40722 .366 .39178 .37979 .3896 .37291 .40593 Metetra
.517 .135 .255 r
.37291 .40593 .37979 .3896 .39365 .38737 .38704 .40439 Metetra
.516 .139 .264 r
.38704 .40439 .39365 .38737 .4076 .3851 .40129 .40258 Metetra
.514 .14 .27 r
.40129 .40258 .4076 .3851 .42162 .38278 .41563 .40048 Metetra
.51 .138 .271 r
.41563 .40048 .42162 .38278 .43574 .38041 .43008 .39808 Metetra
.504 .133 .269 r
.43008 .39808 .43574 .38041 .44993 .37799 .44462 .39539 Metetra
.497 .124 .263 r
.44462 .39539 .44993 .37799 .4642 .37552 .45925 .3924 Metetra
.485 .88 .96 r
.12553 .42748 .13432 .4286 .14712 .42592 .13855 .4244 Metetra
.471 .867 .967 r
.13855 .4244 .14712 .42592 .15994 .42348 .15155 .42175 Metetra
.442 .851 .967 r
.15155 .42175 .15994 .42348 .17278 .4213 .16454 .41952 Metetra
.4 .83 .958 r
.16454 .41952 .17278 .4213 .18564 .41937 .17753 .41772 Metetra
.341 .8 .939 r
.17753 .41772 .18564 .41937 .19854 .4177 .19052 .41634 Metetra
.265 .76 .903 r
.19052 .41634 .19854 .4177 .21148 .41627 .20354 .41537 Metetra
.171 .703 .844 r
.20354 .41537 .21148 .41627 .22446 .41506 .21659 .41477 Metetra
.063 .627 .759 r
.21659 .41477 .22446 .41506 .23751 .41404 .22968 .4145 Metetra
.048 0 0 r
.22968 .4145 .23751 .41404 .25062 .41319 .24285 .4145 Metetra
.153 0 0 r
.24285 .4145 .25062 .41319 .26381 .41246 .25609 .41473 Metetra
.243 0 0 r
.25609 .41473 .26381 .41246 .27709 .41181 .26942 .4151 Metetra
.313 0 0 r
.26942 .4151 .27709 .41181 .29045 .41121 .28286 .41556 Metetra
.365 0 0 r
.28286 .41556 .29045 .41121 .30392 .4106 .29642 .41602 Metetra
.401 0 0 r
.29642 .41602 .30392 .4106 .3175 .40994 .3101 .4164 Metetra
.425 0 0 r
.3101 .4164 .3175 .40994 .33118 .40919 .32392 .41664 Metetra
.44 0 0 r
.32392 .41664 .33118 .40919 .34498 .40829 .33788 .41665 Metetra
.448 0 .027 r
.33788 .41665 .34498 .40829 .35888 .40722 .35197 .41638 Metetra
.451 0 .054 r
.35197 .41638 .35888 .40722 .37291 .40593 .36621 .41575 Metetra
.449 0 .073 r
.36621 .41575 .37291 .40593 .38704 .40439 .38058 .41472 Metetra
.443 0 .085 r
.38058 .41472 .38704 .40439 .40129 .40258 .39508 .41325 Metetra
.434 0 .09 r
.39508 .41325 .40129 .40258 .41563 .40048 .40971 .41131 Metetra
.422 0 .089 r
.40971 .41131 .41563 .40048 .43008 .39808 .42444 .40888 Metetra
.406 0 .082 r
.42444 .40888 .43008 .39808 .44462 .39539 .43929 .40597 Metetra
.387 0 .068 r
.43929 .40597 .44462 .39539 .45925 .3924 .45422 .40258 Metetra
.659 .832 .966 r
.11737 .422 .12553 .42748 .13855 .4244 .13055 .41876 Metetra
.639 .823 .971 r
.13055 .41876 .13855 .4244 .15155 .42175 .14369 .41599 Metetra
.617 .814 .976 r
.14369 .41599 .15155 .42175 .16454 .41952 .15681 .41371 Metetra
.591 .806 .981 r
.15681 .41371 .16454 .41952 .17753 .41772 .16991 .41193 Metetra
.563 .797 .987 r
.16991 .41193 .17753 .41772 .19052 .41634 .18301 .41064 Metetra
.531 .787 .991 r
.18301 .41064 .19052 .41634 .20354 .41537 .19612 .40982 Metetra
.496 .778 .995 r
.19612 .40982 .20354 .41537 .21659 .41477 .20926 .40942 Metetra
.459 .767 .996 r
.20926 .40942 .21659 .41477 .22968 .4145 .22244 .4094 Metetra
.42 .757 .995 r
.22244 .4094 .22968 .4145 .24285 .4145 .23569 .4097 Metetra
.381 .746 .991 r
.23569 .4097 .24285 .4145 .25609 .41473 .24902 .41026 Metetra
.343 .736 .984 r
.24902 .41026 .25609 .41473 .26942 .4151 .26244 .411 Metetra
.308 .727 .975 r
.26244 .411 .26942 .4151 .28286 .41556 .27598 .41183 Metetra
.278 .72 .963 r
.27598 .41183 .28286 .41556 .29642 .41602 .28964 .41266 Metetra
.254 .715 .95 r
.28964 .41266 .29642 .41602 .3101 .4164 .30344 .41342 Metetra
.237 .714 .937 r
.30344 .41342 .3101 .4164 .32392 .41664 .31739 .41401 Metetra
.229 .717 .926 r
.31739 .41401 .32392 .41664 .33788 .41665 .33148 .41434 Metetra
.23 .724 .916 r
.33148 .41434 .33788 .41665 .35197 .41638 .34573 .41434 Metetra
.239 .736 .909 r
.34573 .41434 .35197 .41638 .36621 .41575 .36012 .41394 Metetra
.257 .753 .906 r
.36012 .41394 .36621 .41575 .38058 .41472 .37467 .41308 Metetra
.283 .772 .906 r
.37467 .41308 .38058 .41472 .39508 .41325 .38935 .41171 Metetra
.315 .794 .909 r
.38935 .41171 .39508 .41325 .40971 .41131 .40417 .4098 Metetra
.352 .818 .915 r
.40417 .4098 .40971 .41131 .42444 .40888 .41911 .40732 Metetra
.392 .842 .922 r
.41911 .40732 .42444 .40888 .43929 .40597 .43417 .40429 Metetra
.434 .865 .93 r
.43417 .40429 .43929 .40597 .45422 .40258 .44931 .4007 Metetra
.684 .72 .877 r
.11005 .41147 .11737 .422 .13055 .41876 .1233 .4083 Metetra
.673 .718 .883 r
.1233 .4083 .13055 .41876 .14369 .41599 .13653 .40554 Metetra
.66 .715 .889 r
.13653 .40554 .14369 .41599 .15681 .41371 .14974 .40322 Metetra
.647 .709 .893 r
.14974 .40322 .15681 .41371 .16991 .41193 .16295 .40134 Metetra
.634 .702 .895 r
.16295 .40134 .16991 .41193 .18301 .41064 .17617 .39988 Metetra
.622 .694 .896 r
.17617 .39988 .18301 .41064 .19612 .40982 .1894 .39883 Metetra
.61 .685 .896 r
.1894 .39883 .19612 .40982 .20926 .40942 .20267 .39815 Metetra
.601 .676 .894 r
.20267 .39815 .20926 .40942 .22244 .4094 .21599 .39781 Metetra
.594 .667 .89 r
.21599 .39781 .22244 .4094 .23569 .4097 .22937 .39774 Metetra
.589 .658 .885 r
.22937 .39774 .23569 .4097 .24902 .41026 .24284 .3979 Metetra
.587 .65 .879 r
.24284 .3979 .24902 .41026 .26244 .411 .2564 .39821 Metetra
.587 .643 .873 r
.2564 .39821 .26244 .411 .27598 .41183 .27007 .3986 Metetra
.59 .638 .866 r
.27007 .3986 .27598 .41183 .28964 .41266 .28386 .39899 Metetra
.594 .634 .86 r
.28386 .39899 .28964 .41266 .30344 .41342 .29779 .39931 Metetra
.601 .631 .853 r
.29779 .39931 .30344 .41342 .31739 .41401 .31185 .39948 Metetra
.608 .63 .847 r
.31185 .39948 .31739 .41401 .33148 .41434 .32606 .39942 Metetra
.616 .63 .841 r
.32606 .39942 .33148 .41434 .34573 .41434 .34042 .39907 Metetra
.625 .631 .836 r
.34042 .39907 .34573 .41434 .36012 .41394 .35492 .39836 Metetra
.635 .633 .831 r
.35492 .39836 .36012 .41394 .37467 .41308 .36956 .39724 Metetra
.644 .636 .827 r
.36956 .39724 .37467 .41308 .38935 .41171 .38435 .39568 Metetra
.653 .64 .824 r
.38435 .39568 .38935 .41171 .40417 .4098 .39926 .39364 Metetra
.663 .645 .822 r
.39926 .39364 .40417 .4098 .41911 .40732 .4143 .3911 Metetra
.671 .65 .821 r
.4143 .3911 .41911 .40732 .43417 .40429 .42944 .38807 Metetra
.68 .656 .82 r
.42944 .38807 .43417 .40429 .44931 .4007 .44468 .38455 Metetra
.675 .648 .816 r
.1035 .39643 .11005 .41147 .1233 .4083 .11675 .39355 Metetra
.67 .65 .822 r
.11675 .39355 .1233 .4083 .13653 .40554 .13002 .39092 Metetra
.664 .65 .826 r
.13002 .39092 .13653 .40554 .14974 .40322 .14331 .38855 Metetra
.658 .647 .827 r
.14331 .38855 .14974 .40322 .16295 .40134 .15662 .38645 Metetra
.653 .642 .827 r
.15662 .38645 .16295 .40134 .17617 .39988 .16997 .3846 Metetra
.647 .634 .823 r
.16997 .3846 .17617 .39988 .1894 .39883 .18336 .383 Metetra
.642 .626 .818 r
.18336 .383 .1894 .39883 .20267 .39815 .19679 .38162 Metetra
.639 .616 .811 r
.19679 .38162 .20267 .39815 .21599 .39781 .21029 .38044 Metetra
.636 .605 .802 r
.21029 .38044 .21599 .39781 .22937 .39774 .22386 .37943 Metetra
.634 .594 .792 r
.22386 .37943 .22937 .39774 .24284 .3979 .23751 .37854 Metetra
.632 .584 .782 r
.23751 .37854 .24284 .3979 .2564 .39821 .25126 .37774 Metetra
.632 .575 .772 r
.25126 .37774 .2564 .39821 .27007 .3986 .2651 .37697 Metetra
.632 .567 .763 r
.2651 .37697 .27007 .3986 .28386 .39899 .27905 .37621 Metetra
.633 .559 .754 r
.27905 .37621 .28386 .39899 .29779 .39931 .29312 .37539 Metetra
.634 .553 .746 r
.29312 .37539 .29779 .39931 .31185 .39948 .3073 .37447 Metetra
.636 .548 .738 r
.3073 .37447 .31185 .39948 .32606 .39942 .32161 .3734 Metetra
.638 .545 .732 r
.32161 .3734 .32606 .39942 .34042 .39907 .33604 .37215 Metetra
.641 .542 .727 r
.33604 .37215 .34042 .39907 .35492 .39836 .3506 .37067 Metetra
.643 .541 .723 r
.3506 .37067 .35492 .39836 .36956 .39724 .36528 .36894 Metetra
.646 .54 .72 r
.36528 .36894 .36956 .39724 .38435 .39568 .38008 .36693 Metetra
.649 .541 .718 r
.38008 .36693 .38435 .39568 .39926 .39364 .395 .36463 Metetra
.652 .542 .717 r
.395 .36463 .39926 .39364 .4143 .3911 .41002 .36201 Metetra
.656 .544 .717 r
.41002 .36201 .4143 .3911 .42944 .38807 .42516 .35909 Metetra
.659 .548 .717 r
.42516 .35909 .42944 .38807 .44468 .38455 .44038 .35588 Metetra
.663 .612 .787 r
.09744 .37853 .1035 .39643 .11675 .39355 .11065 .37608 Metetra
.663 .617 .793 r
.11065 .37608 .11675 .39355 .13002 .39092 .12392 .37364 Metetra
.663 .62 .796 r
.12392 .37364 .13002 .39092 .14331 .38855 .13727 .37123 Metetra
.662 .619 .796 r
.13727 .37123 .14331 .38855 .15662 .38645 .15068 .36884 Metetra
.661 .617 .794 r
.15068 .36884 .15662 .38645 .16997 .3846 .16416 .36647 Metetra
.66 .611 .789 r
.16416 .36647 .16997 .3846 .18336 .383 .17772 .36412 Metetra
.659 .604 .782 r
.17772 .36412 .18336 .383 .19679 .38162 .19136 .36179 Metetra
.658 .596 .774 r
.19136 .36179 .19679 .38162 .21029 .38044 .20507 .35947 Metetra
.657 .586 .764 r
.20507 .35947 .21029 .38044 .22386 .37943 .21887 .35716 Metetra
.655 .576 .754 r
.21887 .35716 .22386 .37943 .23751 .37854 .23274 .35485 Metetra
.654 .566 .744 r
.23274 .35485 .23751 .37854 .25126 .37774 .2467 .35254 Metetra
.652 .557 .734 r
.2467 .35254 .25126 .37774 .2651 .37697 .26074 .35022 Metetra
.651 .548 .725 r
.26074 .35022 .2651 .37697 .27905 .37621 .27487 .34789 Metetra
.65 .54 .716 r
.27487 .34789 .27905 .37621 .29312 .37539 .28909 .34554 Metetra
.649 .533 .709 r
.28909 .34554 .29312 .37539 .3073 .37447 .3034 .34316 Metetra
.648 .527 .702 r
.3034 .34316 .3073 .37447 .32161 .3734 .3178 .34075 Metetra
.647 .521 .696 r
.3178 .34075 .32161 .3734 .33604 .37215 .33229 .3383 Metetra
.646 .517 .692 r
.33229 .3383 .33604 .37215 .3506 .37067 .34687 .3358 Metetra
.646 .514 .688 r
.34687 .3358 .3506 .37067 .36528 .36894 .36155 .33326 Metetra
.646 .512 .686 r
.36155 .33326 .36528 .36894 .38008 .36693 .37632 .33067 Metetra
.646 .51 .684 r
.37632 .33067 .38008 .36693 .395 .36463 .39119 .32803 Metetra
.646 .51 .683 r
.39119 .32803 .395 .36463 .41002 .36201 .40614 .32534 Metetra
.646 .51 .683 r
.40614 .32534 .41002 .36201 .42516 .35909 .4212 .32259 Metetra
.647 .511 .684 r
.4212 .32259 .42516 .35909 .44038 .35588 .43634 .31978 Metetra
.654 .603 .786 r
.09139 .3601 .09744 .37853 .11065 .37608 .10454 .35808 Metetra
.658 .611 .79 r
.10454 .35808 .11065 .37608 .12392 .37364 .11782 .35585 Metetra
.662 .616 .792 r
.11782 .35585 .12392 .37364 .13727 .37123 .13121 .35339 Metetra
.666 .618 .792 r
.13121 .35339 .13727 .37123 .15068 .36884 .14473 .35071 Metetra
.669 .618 .788 r
.14473 .35071 .15068 .36884 .16416 .36647 .15836 .3478 Metetra
.672 .615 .783 r
.15836 .3478 .16416 .36647 .17772 .36412 .1721 .34468 Metetra
.674 .61 .776 r
.1721 .34468 .17772 .36412 .19136 .36179 .18594 .34137 Metetra
.675 .603 .767 r
.18594 .34137 .19136 .36179 .20507 .35947 .19988 .33789 Metetra
.675 .594 .757 r
.19988 .33789 .20507 .35947 .21887 .35716 .21391 .33426 Metetra
.674 .585 .748 r
.21391 .33426 .21887 .35716 .23274 .35485 .22802 .3305 Metetra
.673 .575 .738 r
.22802 .3305 .23274 .35485 .2467 .35254 .2422 .32667 Metetra
.671 .566 .728 r
.2422 .32667 .2467 .35254 .26074 .35022 .25646 .32277 Metetra
.668 .557 .719 r
.25646 .32277 .26074 .35022 .27487 .34789 .27078 .31886 Metetra
.666 .548 .711 r
.27078 .31886 .27487 .34789 .28909 .34554 .28516 .31497 Metetra
.663 .54 .704 r
.28516 .31497 .28909 .34554 .3034 .34316 .29959 .31113 Metetra
.66 .533 .698 r
.29959 .31113 .3034 .34316 .3178 .34075 .31409 .30737 Metetra
.657 .526 .692 r
.31409 .30737 .3178 .34075 .33229 .3383 .32864 .30373 Metetra
.654 .52 .688 r
.32864 .30373 .33229 .3383 .34687 .3358 .34325 .30023 Metetra
.652 .516 .684 r
.34325 .30023 .34687 .3358 .36155 .33326 .35792 .29689 Metetra
.649 .512 .682 r
.35792 .29689 .36155 .33326 .37632 .33067 .37266 .29372 Metetra
.647 .509 .68 r
.37266 .29372 .37632 .33067 .39119 .32803 .38746 .29075 Metetra
.645 .506 .679 r
.38746 .29075 .39119 .32803 .40614 .32534 .40235 .28797 Metetra
.643 .505 .68 r
.40235 .28797 .40614 .32534 .4212 .32259 .41731 .28539 Metetra
.641 .504 .681 r
.41731 .28539 .4212 .32259 .43634 .31978 .43236 .28299 Metetra
.646 .621 .81 r
.08482 .3435 .09139 .3601 .10454 .35808 .09795 .34181 Metetra
.655 .63 .813 r
.09795 .34181 .10454 .35808 .11782 .35585 .11124 .33972 Metetra
.663 .637 .814 r
.11124 .33972 .11782 .35585 .13121 .35339 .12471 .33721 Metetra
.671 .642 .812 r
.12471 .33721 .13121 .35339 .14473 .35071 .13833 .33428 Metetra
.678 .644 .808 r
.13833 .33428 .14473 .35071 .15836 .3478 .15211 .33094 Metetra
.684 .643 .802 r
.15211 .33094 .15836 .3478 .1721 .34468 .16602 .32721 Metetra
.689 .639 .795 r
.16602 .32721 .1721 .34468 .18594 .34137 .18006 .32312 Metetra
.692 .634 .786 r
.18006 .32312 .18594 .34137 .19988 .33789 .19422 .31871 Metetra
.694 .627 .777 r
.19422 .31871 .19988 .33789 .21391 .33426 .20846 .31404 Metetra
.695 .619 .768 r
.20846 .31404 .21391 .33426 .22802 .3305 .22279 .30915 Metetra
.694 .61 .758 r
.22279 .30915 .22802 .3305 .2422 .32667 .23719 .30411 Metetra
.692 .601 .749 r
.23719 .30411 .2422 .32667 .25646 .32277 .25165 .29899 Metetra
.689 .591 .741 r
.25165 .29899 .25646 .32277 .27078 .31886 .26615 .29385 Metetra
.686 .582 .733 r
.26615 .29385 .27078 .31886 .28516 .31497 .28069 .28876 Metetra
.682 .573 .727 r
.28069 .28876 .28516 .31497 .29959 .31113 .29527 .28379 Metetra
.678 .565 .721 r
.29527 .28379 .29959 .31113 .31409 .30737 .30987 .27899 Metetra
.673 .557 .715 r
.30987 .27899 .31409 .30737 .32864 .30373 .32451 .27442 Metetra
.668 .55 .711 r
.32451 .27442 .32864 .30373 .34325 .30023 .33917 .27014 Metetra
.664 .543 .708 r
.33917 .27014 .34325 .30023 .35792 .29689 .35387 .26617 Metetra
.659 .538 .705 r
.35387 .26617 .35792 .29689 .37266 .29372 .36861 .26255 Metetra
.654 .533 .704 r
.36861 .26255 .37266 .29372 .38746 .29075 .3834 .25931 Metetra
.65 .529 .703 r
.3834 .25931 .38746 .29075 .40235 .28797 .39826 .25646 Metetra
.645 .526 .703 r
.39826 .25646 .40235 .28797 .41731 .28539 .41318 .25398 Metetra
.641 .524 .704 r
.41318 .25398 .41731 .28539 .43236 .28299 .42818 .25189 Metetra
.637 .673 .868 r
.07726 .33057 .08482 .3435 .09795 .34181 .09043 .32902 Metetra
.65 .682 .867 r
.09043 .32902 .09795 .34181 .11124 .33972 .10379 .32697 Metetra
.663 .689 .865 r
.10379 .32697 .11124 .33972 .12471 .33721 .11735 .32441 Metetra
.675 .695 .861 r
.11735 .32441 .12471 .33721 .13833 .33428 .13109 .32133 Metetra
.686 .698 .856 r
.13109 .32133 .13833 .33428 .15211 .33094 .14501 .31775 Metetra
.696 .7 .85 r
.14501 .31775 .15211 .33094 .16602 .32721 .15908 .31369 Metetra
.704 .699 .843 r
.15908 .31369 .16602 .32721 .18006 .32312 .17329 .30918 Metetra
.71 .697 .836 r
.17329 .30918 .18006 .32312 .19422 .31871 .18762 .30429 Metetra
.715 .693 .828 r
.18762 .30429 .19422 .31871 .20846 .31404 .20205 .29906 Metetra
.717 .688 .821 r
.20205 .29906 .20846 .31404 .22279 .30915 .21657 .29358 Metetra
.718 .682 .814 r
.21657 .29358 .22279 .30915 .23719 .30411 .23115 .28793 Metetra
.718 .675 .807 r
.23115 .28793 .23719 .30411 .25165 .29899 .24578 .28217 Metetra
.716 .668 .801 r
.24578 .28217 .25165 .29899 .26615 .29385 .26046 .2764 Metetra
.713 .66 .796 r
.26046 .2764 .26615 .29385 .28069 .28876 .27516 .2707 Metetra
.709 .652 .791 r
.27516 .2707 .28069 .28876 .29527 .28379 .28988 .26514 Metetra
.704 .644 .786 r
.28988 .26514 .29527 .28379 .30987 .27899 .30461 .2598 Metetra
.698 .636 .783 r
.30461 .2598 .30987 .27899 .32451 .27442 .31936 .25476 Metetra
.692 .628 .78 r
.31936 .25476 .32451 .27442 .33917 .27014 .33413 .25006 Metetra
.685 .62 .778 r
.33413 .25006 .33917 .27014 .35387 .26617 .34892 .24576 Metetra
.677 .613 .777 r
.34892 .24576 .35387 .26617 .36861 .26255 .36374 .24189 Metetra
.67 .607 .776 r
.36374 .24189 .36861 .26255 .3834 .25931 .3786 .23849 Metetra
.662 .601 .776 r
.3786 .23849 .3834 .25931 .39826 .25646 .39352 .23556 Metetra
.654 .596 .777 r
.39352 .23556 .39826 .25646 .41318 .25398 .4085 .23311 Metetra
.646 .591 .779 r
.4085 .23311 .41318 .25398 .42818 .25189 .42355 .23112 Metetra
.606 .764 .955 r
.06841 .32225 .07726 .33057 .09043 .32902 .0817 .32059 Metetra
.626 .769 .949 r
.0817 .32059 .09043 .32902 .10379 .32697 .0952 .31847 Metetra
.644 .775 .943 r
.0952 .31847 .10379 .32697 .11735 .32441 .10889 .31585 Metetra
.661 .781 .937 r
.10889 .31585 .11735 .32441 .13109 .32133 .12276 .31274 Metetra
.676 .786 .932 r
.12276 .31274 .13109 .32133 .14501 .31775 .1368 .30915 Metetra
.69 .791 .928 r
.1368 .30915 .14501 .31775 .15908 .31369 .151 .30509 Metetra
.701 .796 .924 r
.151 .30509 .15908 .31369 .17329 .30918 .16534 .30062 Metetra
.71 .801 .922 r
.16534 .30062 .17329 .30918 .18762 .30429 .1798 .29577 Metetra
.718 .806 .92 r
.1798 .29577 .18762 .30429 .20205 .29906 .19436 .29061 Metetra
.723 .811 .919 r
.19436 .29061 .20205 .29906 .21657 .29358 .20902 .28521 Metetra
.727 .815 .92 r
.20902 .28521 .21657 .29358 .23115 .28793 .22374 .27963 Metetra
.729 .82 .921 r
.22374 .27963 .23115 .28793 .24578 .28217 .23851 .27396 Metetra
.728 .823 .924 r
.23851 .27396 .24578 .28217 .26046 .2764 .25333 .26827 Metetra
.726 .826 .927 r
.25333 .26827 .26046 .2764 .27516 .2707 .26818 .26264 Metetra
.721 .829 .932 r
.26818 .26264 .27516 .2707 .28988 .26514 .28306 .25715 Metetra
.714 .83 .936 r
.28306 .25715 .28988 .26514 .30461 .2598 .29795 .25187 Metetra
.705 .83 .942 r
.29795 .25187 .30461 .2598 .31936 .25476 .31286 .24686 Metetra
.694 .829 .948 r
.31286 .24686 .31936 .25476 .33413 .25006 .32779 .24219 Metetra
.681 .826 .953 r
.32779 .24219 .33413 .25006 .34892 .24576 .34275 .23789 Metetra
.665 .822 .959 r
.34275 .23789 .34892 .24576 .36374 .24189 .35774 .23401 Metetra
.649 .816 .964 r
.35774 .23401 .36374 .24189 .3786 .23849 .37278 .23056 Metetra
.631 .809 .968 r
.37278 .23056 .3786 .23849 .39352 .23556 .38786 .22757 Metetra
.614 .8 .971 r
.38786 .22757 .39352 .23556 .4085 .23311 .40302 .22503 Metetra
.596 .791 .973 r
.40302 .22503 .4085 .23311 .42355 .23112 .41826 .22293 Metetra
.501 .842 .997 r
.05821 .31836 .06841 .32225 .0817 .32059 .07173 .31638 Metetra
.537 .849 .998 r
.07173 .31638 .0817 .32059 .0952 .31847 .08542 .31405 Metetra
.564 .856 .997 r
.08542 .31405 .0952 .31847 .10889 .31585 .09927 .31137 Metetra
.585 .863 .995 r
.09927 .31137 .10889 .31585 .12276 .31274 .11328 .30834 Metetra
.6 .871 .993 r
.11328 .30834 .12276 .31274 .1368 .30915 .12743 .30496 Metetra
.609 .88 .991 r
.12743 .30496 .1368 .30915 .151 .30509 .14173 .30125 Metetra
.612 .89 .989 r
.14173 .30125 .151 .30509 .16534 .30062 .15616 .29724 Metetra
.609 .901 .986 r
.15616 .29724 .16534 .30062 .1798 .29577 .1707 .29296 Metetra
.599 .91 .981 r
.1707 .29296 .1798 .29577 .19436 .29061 .18534 .28845 Metetra
.579 .915 .971 r
.18534 .28845 .19436 .29061 .20902 .28521 .20007 .28376 Metetra
.548 .914 .953 r
.20007 .28376 .20902 .28521 .22374 .27963 .21488 .27894 Metetra
.504 .904 .925 r
.21488 .27894 .22374 .27963 .23851 .27396 .22975 .27405 Metetra
.449 .881 .884 r
.22975 .27405 .23851 .27396 .25333 .26827 .24469 .26913 Metetra
.382 .845 .831 r
.24469 .26913 .25333 .26827 .26818 .26264 .25967 .26425 Metetra
.307 .797 .768 r
.25967 .26425 .26818 .26264 .28306 .25715 .2747 .25947 Metetra
.23 .74 .699 r
.2747 .25947 .28306 .25715 .29795 .25187 .28977 .25482 Metetra
.28977 .25482 .29795 .25187 .31286 .24686 .30488 .25036 Metetra
.30488 .25036 .31286 .24686 .32779 .24219 .32004 .24614 Metetra
.32004 .24614 .32779 .24219 .34275 .23789 .33524 .24217 Metetra
.023 0 0 r
.33524 .24217 .34275 .23789 .35774 .23401 .35049 .2385 Metetra
.063 0 0 r
.35049 .2385 .35774 .23401 .37278 .23056 .3658 .23513 Metetra
.094 0 0 r
.3658 .23513 .37278 .23056 .38786 .22757 .38118 .23208 Metetra
.115 0 0 r
.38118 .23208 .38786 .22757 .40302 .22503 .39664 .22934 Metetra
.126 0 0 r
.39664 .22934 .40302 .22503 .41826 .22293 .41218 .22691 Metetra
.352 .82 .909 r
.04689 .31765 .05821 .31836 .07173 .31638 .06071 .31516 Metetra
.395 .839 .935 r
.06071 .31516 .07173 .31638 .08542 .31405 .07464 .31254 Metetra
.421 .85 .947 r
.07464 .31254 .08542 .31405 .09927 .31137 .08868 .3098 Metetra
.432 .855 .95 r
.08868 .3098 .09927 .31137 .11328 .30834 .10283 .30693 Metetra
.429 .856 .944 r
.10283 .30693 .11328 .30834 .12743 .30496 .11709 .30393 Metetra
.41 .851 .928 r
.11709 .30393 .12743 .30496 .14173 .30125 .13146 .30082 Metetra
.374 .836 .898 r
.13146 .30082 .14173 .30125 .15616 .29724 .14593 .29759 Metetra
.32 .808 .85 r
.14593 .29759 .15616 .29724 .1707 .29296 .1605 .29426 Metetra
.249 .761 .781 r
.1605 .29426 .1707 .29296 .18534 .28845 .17517 .29085 Metetra
.163 .695 .689 r
.17517 .29085 .18534 .28845 .20007 .28376 .18993 .28736 Metetra
.18993 .28736 .20007 .28376 .21488 .27894 .20478 .28381 Metetra
.018 0 0 r
.20478 .28381 .21488 .27894 .22975 .27405 .21971 .28023 Metetra
.099 0 0 r
.21971 .28023 .22975 .27405 .24469 .26913 .23473 .27663 Metetra
.167 0 0 r
.23473 .27663 .24469 .26913 .25967 .26425 .24982 .27302 Metetra
.223 0 0 r
.24982 .27302 .25967 .26425 .2747 .25947 .265 .26944 Metetra
.267 0 0 r
.265 .26944 .2747 .25947 .28977 .25482 .28026 .26588 Metetra
.302 0 0 r
.28026 .26588 .28977 .25482 .30488 .25036 .2956 .26237 Metetra
.329 0 0 r
.2956 .26237 .30488 .25036 .32004 .24614 .31101 .25893 Metetra
.349 0 .008 r
.31101 .25893 .32004 .24614 .33524 .24217 .32651 .25556 Metetra
.365 0 .031 r
.32651 .25556 .33524 .24217 .35049 .2385 .3421 .25228 Metetra
.376 0 .045 r
.3421 .25228 .35049 .2385 .3658 .23513 .35777 .24908 Metetra
.382 0 .053 r
.35777 .24908 .3658 .23513 .38118 .23208 .37354 .24597 Metetra
.386 0 .054 r
.37354 .24597 .38118 .23208 .39664 .22934 .3894 .24296 Metetra
.385 0 .049 r
.3894 .24296 .39664 .22934 .41218 .22691 .40536 .24003 Metetra
.331 .813 .868 r
.03492 .31799 .04689 .31765 .06071 .31516 .04907 .31492 Metetra
.354 .824 .893 r
.04907 .31492 .06071 .31516 .07464 .31254 .06327 .31198 Metetra
.358 .825 .903 r
.06327 .31198 .07464 .31254 .08868 .3098 .07751 .30917 Metetra
.344 .817 .899 r
.07751 .30917 .08868 .3098 .10283 .30693 .09181 .30649 Metetra
.313 .8 .88 r
.09181 .30649 .10283 .30693 .11709 .30393 .10617 .30394 Metetra
.262 .77 .844 r
.10617 .30394 .11709 .30393 .13146 .30082 .12059 .30152 Metetra
.193 .724 .785 r
.12059 .30152 .13146 .30082 .14593 .29759 .13509 .29921 Metetra
.108 .659 .702 r
.13509 .29921 .14593 .29759 .1605 .29426 .14967 .29699 Metetra
.14967 .29699 .1605 .29426 .17517 .29085 .16433 .29486 Metetra
.077 0 0 r
.16433 .29486 .17517 .29085 .18993 .28736 .17908 .29278 Metetra
.159 0 0 r
.17908 .29278 .18993 .28736 .20478 .28381 .19394 .29074 Metetra
.228 0 0 r
.19394 .29074 .20478 .28381 .21971 .28023 .2089 .28871 Metetra
.283 0 0 r
.2089 .28871 .21971 .28023 .23473 .27663 .22398 .28666 Metetra
.325 0 0 r
.22398 .28666 .23473 .27663 .24982 .27302 .23917 .28457 Metetra
.356 0 0 r
.23917 .28457 .24982 .27302 .265 .26944 .25448 .28241 Metetra
.379 0 .012 r
.25448 .28241 .265 .26944 .28026 .26588 .26992 .28017 Metetra
.396 0 .049 r
.26992 .28017 .28026 .26588 .2956 .26237 .28549 .27781 Metetra
.408 0 .077 r
.28549 .27781 .2956 .26237 .31101 .25893 .30119 .27531 Metetra
.415 0 .098 r
.30119 .27531 .31101 .25893 .32651 .25556 .31701 .27267 Metetra
.42 0 .112 r
.31701 .27267 .32651 .25556 .3421 .25228 .33296 .26986 Metetra
.421 0 .121 r
.33296 .26986 .3421 .25228 .35777 .24908 .34904 .26688 Metetra
.419 0 .124 r
.34904 .26688 .35777 .24908 .37354 .24597 .36523 .26373 Metetra
.415 0 .122 r
.36523 .26373 .37354 .24597 .3894 .24296 .38155 .26039 Metetra
.409 0 .114 r
.38155 .26039 .3894 .24296 .40536 .24003 .39798 .25688 Metetra
.469 .877 .949 r
.02294 .31687 .03492 .31799 .04907 .31492 .0374 .31328 Metetra
.463 .869 .958 r
.0374 .31328 .04907 .31492 .06327 .31198 .05185 .31003 Metetra
.443 .857 .959 r
.05185 .31003 .06327 .31198 .07751 .30917 .0663 .30716 Metetra
.411 .84 .953 r
.0663 .30716 .07751 .30917 .09181 .30649 .08074 .30464 Metetra
.364 .818 .936 r
.08074 .30464 .09181 .30649 .10617 .30394 .0952 .30248 Metetra
.302 .786 .905 r
.0952 .30248 .10617 .30394 .12059 .30152 .10969 .30067 Metetra
.223 .741 .856 r
.10969 .30067 .12059 .30152 .13509 .29921 .12421 .29916 Metetra
.132 .68 .783 r
.12421 .29916 .13509 .29921 .14967 .29699 .1388 .29793 Metetra
.1388 .29793 .14967 .29699 .16433 .29486 .15346 .29693 Metetra
.062 0 0 r
.15346 .29693 .16433 .29486 .17908 .29278 .16821 .29611 Metetra
.148 0 0 r
.16821 .29611 .17908 .29278 .19394 .29074 .18308 .29542 Metetra
.219 0 0 r
.18308 .29542 .19394 .29074 .2089 .28871 .19807 .29478 Metetra
.274 0 0 r
.19807 .29478 .2089 .28871 .22398 .28666 .2132 .29413 Metetra
.315 0 0 r
.2132 .29413 .22398 .28666 .23917 .28457 .22848 .29341 Metetra
.344 0 0 r
.22848 .29341 .23917 .28457 .25448 .28241 .24392 .29256 Metetra
.363 0 0 r
.24392 .29256 .25448 .28241 .26992 .28017 .25953 .2915 Metetra
.376 0 0 r
.25953 .2915 .26992 .28017 .28549 .27781 .27532 .29019 Metetra
.382 0 0 r
.27532 .29019 .28549 .27781 .30119 .27531 .29128 .28856 Metetra
.384 0 .007 r
.29128 .28856 .30119 .27531 .31701 .27267 .30741 .28658 Metetra
.382 0 .02 r
.30741 .28658 .31701 .27267 .33296 .26986 .32371 .28421 Metetra
.376 0 .026 r
.32371 .28421 .33296 .26986 .34904 .26688 .34017 .28143 Metetra
.367 0 .026 r
.34017 .28143 .34904 .26688 .36523 .26373 .35678 .27821 Metetra
.354 0 .02 r
.35678 .27821 .36523 .26373 .38155 .26039 .37354 .27457 Metetra
.338 0 .007 r
.37354 .27457 .38155 .26039 .39798 .25688 .39043 .27051 Metetra
.624 .873 .989 r
.01157 .31197 .02294 .31687 .0374 .31328 .02629 .30804 Metetra
.604 .862 .992 r
.02629 .30804 .0374 .31328 .05185 .31003 .04095 .30458 Metetra
.58 .851 .995 r
.04095 .30458 .05185 .31003 .0663 .30716 .05558 .30164 Metetra
.549 .84 .998 r
.05558 .30164 .0663 .30716 .08074 .30464 .07016 .29919 Metetra
.513 .828 1 r
.07016 .29919 .08074 .30464 .0952 .30248 .08473 .29725 Metetra
.47 .815 .998 r
.08473 .29725 .0952 .30248 .10969 .30067 .0993 .29577 Metetra
.42 .799 .992 r
.0993 .29577 .10969 .30067 .12421 .29916 .1139 .29473 Metetra
.362 .78 .978 r
.1139 .29473 .12421 .29916 .1388 .29793 .12854 .29408 Metetra
.299 .754 .954 r
.12854 .29408 .1388 .29793 .15346 .29693 .14324 .29375 Metetra
.23 .723 .919 r
.14324 .29375 .15346 .29693 .16821 .29611 .15804 .29368 Metetra
.161 .686 .873 r
.15804 .29368 .16821 .29611 .18308 .29542 .17296 .29378 Metetra
.095 .646 .818 r
.17296 .29378 .18308 .29542 .19807 .29478 .18802 .29398 Metetra
.036 .605 .758 r
.18802 .29398 .19807 .29478 .2132 .29413 .20323 .29418 Metetra
.013 0 0 r
.20323 .29418 .2132 .29413 .22848 .29341 .21861 .29429 Metetra
.051 0 0 r
.21861 .29429 .22848 .29341 .24392 .29256 .23419 .29422 Metetra
.077 0 0 r
.23419 .29422 .24392 .29256 .25953 .2915 .24996 .29388 Metetra
.093 0 0 r
.24996 .29388 .25953 .2915 .27532 .29019 .26594 .29319 Metetra
.097 0 0 r
.26594 .29319 .27532 .29019 .29128 .28856 .28212 .29208 Metetra
.093 0 0 r
.28212 .29208 .29128 .28856 .30741 .28658 .29851 .29049 Metetra
.08 0 0 r
.29851 .29049 .30741 .28658 .32371 .28421 .31509 .28836 Metetra
.059 0 0 r
.31509 .28836 .32371 .28421 .34017 .28143 .33186 .28567 Metetra
.031 0 0 r
.33186 .28567 .34017 .28143 .35678 .27821 .34882 .28239 Metetra
.34882 .28239 .35678 .27821 .37354 .27457 .36593 .27852 Metetra
.36593 .27852 .37354 .27457 .39043 .27051 .38319 .27408 Metetra
0 g
.25 Mabswid
.39104 .15655 m
.5 .39071 L
s
.5 .39071 m
.5 .5 L
s
.5 .5 m
.38268 .28164 L
s
.38268 .28164 m
.39104 .15655 L
s
.033 .23358 m
0 .35429 L
s
0 .35429 m
.38268 .28164 L
s
.38268 .28164 m
.39104 .15655 L
s
.39104 .15655 m
.033 .23358 L
s
.033 .23358 m
.39104 .15655 L
s
.033 .23358 m
.0371 .23829 L
s
[(-2)] .02479 .22415 .86996 1 Mshowa
.11749 .2154 m
.1213 .22035 L
s
[(-1)] .10987 .20549 .76881 1 Mshowa
.2052 .19653 m
.20867 .20173 L
s
[(0)] .19826 .18613 .66765 1 Mshowa
.29632 .17692 m
.2994 .18236 L
s
[(1)] .29016 .16605 .5665 1 Mshowa
.39104 .15655 m
.39367 .16221 L
s
[(2)] .38576 .14521 .46534 1 Mshowa
.125 Mabswid
.04965 .22999 m
.05208 .23285 L
s
.06642 .22639 m
.06882 .22927 L
s
.08332 .22275 m
.08568 .22566 L
s
.10034 .21909 m
.10266 .22203 L
s
.13477 .21168 m
.13702 .21468 L
s
.15218 .20793 m
.15439 .21097 L
s
.16972 .20416 m
.17189 .20722 L
s
.1874 .20036 m
.18952 .20345 L
s
.22315 .19267 m
.22519 .19581 L
s
.24123 .18878 m
.24322 .19195 L
s
.25945 .18486 m
.2614 .18806 L
s
.27781 .18091 m
.27971 .18414 L
s
.31497 .17291 m
.31676 .1762 L
s
.33376 .16887 m
.33551 .17219 L
s
.3527 .16479 m
.3544 .16814 L
s
.37179 .16069 m
.37343 .16406 L
s
gsave
.16356 .13415 -69.3383 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
0 .35429 m
.19493 .54321 L
s
.03984 .39291 m
.04134 .38684 L
s
[(-2)] .03685 .40504 .24636 -1 Mshowa
.10961 .46052 m
.11084 .45439 L
s
[(0)] .10713 .47277 .20171 -1 Mshowa
.16867 .51776 m
.16969 .51159 L
s
[(2)] .16662 .53009 .16628 -1 Mshowa
.125 Mabswid
.05844 .41093 m
.0593 .40728 L
s
.07624 .42818 m
.07705 .42452 L
s
.09327 .44469 m
.09405 .44102 L
s
.12527 .4757 m
.12598 .47202 L
s
.14031 .49028 m
.14099 .48659 L
s
.15477 .50429 m
.15541 .50059 L
s
.02038 .37405 m
.02133 .37042 L
s
.18205 .53072 m
.18263 .52702 L
s
gsave
.09478 .53404 -67.0461 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  "This setting for ",
  StyleBox["ViewVertical", "MR"],
  " makes the ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis of the box appear vertical in your image. "
}], "MathCaption",
  CellTags->{"S2.10.10", "10.22"}],

Cell[CellGroupData[{

Cell["Show[surf, ViewVertical -> {1, 0, 0}]", "Input",
  CellLabel->"In[11]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.31272 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.247857 1.42164 1.42681e-16 1.42164 [
[.95373 .14035 0 -7.01532 ]
[.95373 .14035 12 1.98468 ]
[.96823 .36293 0 -6.72118 ]
[.96823 .36293 12 2.27882 ]
[.98358 .59915 0 -6.41165 ]
[.98358 .59915 6 2.58835 ]
[.99986 .85032 0 -6.08549 ]
[.99986 .85032 6 2.91451 ]
[1.01713 1.11788 0 -5.74133 ]
[1.01713 1.11788 6 3.25867 ]
[1.06536 .56441 0 -6.99048 ]
[1.06536 .56441 10 2.82202 ]
[.86388 1.17814 -5.71761 0 ]
[.86388 1.17814 6.28239 9 ]
[.6188 1.24562 -2.94555 0 ]
[.6188 1.24562 3.05445 9 ]
[.4064 1.30409 -3.01963 0 ]
[.4064 1.30409 2.98037 9 ]
[.62041 1.33446 -4.93993 0 ]
[.62041 1.33446 5.12257 9.8125 ]
[.88762 .10627 -6.34217 -9 ]
[.88762 .10627 5.65783 0 ]
[.79577 .05985 -3.13492 -9 ]
[.79577 .05985 2.86508 0 ]
[.69952 .01119 -3.09654 -9 ]
[.69952 .01119 2.90346 0 ]
[.79108 -0.02927 -5.22441 -9.8125 ]
[.79108 -0.02927 4.77559 0 ]
[ 0 0 0 0 ]
[ 1 1.31272 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.93822 .14902 m
1 1.12261 L
s
.93822 .14902 m
.93046 .15335 L
s
[(-2)] .95373 .14035 -1 .55896 Mshowa
.95229 .37079 m
.94432 .37473 L
s
[(-1)] .96823 .36293 -1 .4936 Mshowa
.96722 .6061 m
.95905 .60958 L
s
[(0)] .98358 .59915 -1 .42481 Mshowa
.9831 .85622 m
.97472 .85918 L
s
[(1)] .99986 .85032 -1 .35233 Mshowa
1 1.12261 m
.99143 1.12497 L
s
[(2)] 1.01713 1.11788 -1 .27585 Mshowa
.125 Mabswid
.94097 .19235 m
.93629 .1949 L
s
.94375 .23618 m
.93904 .23869 L
s
.94656 .28053 m
.94183 .28299 L
s
.94941 .32539 m
.94465 .3278 L
s
.95521 .41673 m
.9504 .41904 L
s
.95816 .46322 m
.95332 .46548 L
s
.96114 .51028 m
.95629 .51247 L
s
.96416 .5579 m
.95928 .56004 L
s
.97032 .6549 m
.96539 .65692 L
s
.97345 .7043 m
.9685 .70626 L
s
.97663 .75431 m
.97165 .75621 L
s
.97984 .80495 m
.97484 .80679 L
s
.98639 .90815 m
.98134 .90985 L
s
.98973 .96074 m
.98465 .96237 L
s
.99311 1.014 m
.98801 1.01557 L
s
.99653 1.06795 m
.99141 1.06945 L
s
gsave
1.06536 .56441 -61 -10.9905 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
1 1.12261 m
.31079 1.31272 L
s
.86304 1.16039 m
.86262 1.15151 L
s
[(-2)] .86388 1.17814 -0.04707 -1 Mshowa
.61848 1.22785 m
.61831 1.21897 L
s
[(0)] .6188 1.24562 -0.01815 -1 Mshowa
.40652 1.28632 m
.40658 1.27743 L
s
[(2)] .4064 1.30409 .00654 -1 Mshowa
.125 Mabswid
.79844 1.17821 m
.79823 1.17288 L
s
.73623 1.19537 m
.73606 1.19004 L
s
.67628 1.2119 m
.67615 1.20657 L
s
.5627 1.24324 m
.56264 1.23791 L
s
.50884 1.25809 m
.50881 1.25276 L
s
.45681 1.27244 m
.45682 1.26711 L
s
.93018 1.14187 m
.92989 1.13654 L
s
.35787 1.29974 m
.35794 1.29441 L
s
gsave
.62041 1.33446 -65.9399 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.93822 .14902 m
.64267 0 L
s
.88863 .12402 m
.88914 .13289 L
s
[(-2)] .88762 .10627 .05703 1 Mshowa
.79657 .0776 m
.79697 .08648 L
s
[(0)] .79577 .05985 .04497 1 Mshowa
.70009 .02896 m
.70038 .03784 L
s
[(2)] .69952 .01119 .03218 1 Mshowa
.125 Mabswid
.86601 .11261 m
.8663 .11794 L
s
.84313 .10108 m
.84341 .1064 L
s
.81999 .08941 m
.82024 .09473 L
s
.77288 .06565 m
.7731 .07098 L
s
.7489 .05357 m
.74911 .05889 L
s
.72465 .04133 m
.72483 .04666 L
s
.91099 .13529 m
.91131 .14061 L
s
.9331 .14644 m
.93343 .15176 L
s
.67525 .01643 m
.6754 .02176 L
s
.6501 .00375 m
.65023 .00908 L
s
gsave
.79108 -0.02927 -66.2244 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.93822 .14902 m
.64267 0 L
s
.64267 0 m
.04666 .39161 L
s
.04666 .39161 m
.32523 .49165 L
s
.32523 .49165 m
.93822 .14902 L
s
1 1.12261 m
.31079 1.31272 L
s
.31079 1.31272 m
0 1.25809 L
s
0 1.25809 m
.66806 1.03719 L
s
.66806 1.03719 m
1 1.12261 L
s
.93822 .14902 m
.64267 0 L
s
.64267 0 m
.66806 1.03719 L
s
.66806 1.03719 m
1 1.12261 L
s
1 1.12261 m
.93822 .14902 L
s
.32523 .49165 m
.31079 1.31272 L
s
.31079 1.31272 m
0 1.25809 L
s
0 1.25809 m
.04666 .39161 L
s
.04666 .39161 m
.32523 .49165 L
s
0 0 m
1 0 L
1 1.31272 L
0 1.31272 L
closepath
clip
newpath
.5 Mabswid
.589 .427 .629 r
.17694 .41817 .1438 .42649 .14495 .45944 .17757 .45103 Metetra
.581 .414 .621 r
.17757 .45103 .14495 .45944 .14493 .49222 .17734 .48382 Metetra
.575 .403 .612 r
.17734 .48382 .14493 .49222 .1437 .52485 .17621 .51658 Metetra
.572 .395 .603 r
.17621 .51658 .1437 .52485 .14124 .55734 .17418 .5493 Metetra
.572 .389 .595 r
.17418 .5493 .14124 .55734 .13755 .58973 .17124 .58203 Metetra
.575 .386 .588 r
.17124 .58203 .13755 .58973 .13269 .62207 .16743 .61478 Metetra
.581 .386 .582 r
.16743 .61478 .13269 .62207 .12673 .65441 .16282 .64761 Metetra
.59 .39 .578 r
.16282 .64761 .12673 .65441 .11978 .6868 .15747 .68056 Metetra
.6 .396 .576 r
.15747 .68056 .11978 .6868 .11197 .71932 .1515 .71368 Metetra
.612 .404 .575 r
.1515 .71368 .11197 .71932 .10346 .75203 .14501 .74702 Metetra
.624 .413 .576 r
.14501 .74702 .10346 .75203 .09443 .785 .13814 .78064 Metetra
.636 .424 .578 r
.13814 .78064 .09443 .785 .08507 .81831 .13104 .81459 Metetra
.647 .434 .581 r
.13104 .81459 .08507 .81831 .07561 .85202 .12386 .84893 Metetra
.657 .445 .585 r
.12386 .84893 .07561 .85202 .06624 .8862 .11675 .88369 Metetra
.666 .455 .589 r
.11675 .88369 .06624 .8862 .0572 .9209 .10989 .91892 Metetra
.674 .465 .594 r
.10989 .91892 .0572 .9209 .04869 .95617 .10341 .95467 Metetra
.681 .474 .599 r
.10341 .95467 .04869 .95617 .04091 .99206 .09747 .99095 Metetra
.687 .482 .604 r
.09747 .99095 .04091 .99206 .03405 1.02858 .09221 1.0278 Metetra
.691 .489 .609 r
.09221 1.0278 .03405 1.02858 .02826 1.06576 .08772 1.06522 Metetra
.695 .496 .614 r
.08772 1.06522 .02826 1.06576 .02367 1.10361 .08411 1.10323 Metetra
.697 .501 .618 r
.08411 1.10323 .02367 1.10361 .02038 1.14211 .08144 1.14181 Metetra
.699 .506 .623 r
.08144 1.14181 .02038 1.14211 .01845 1.18126 .07975 1.18096 Metetra
.699 .509 .628 r
.07975 1.18096 .01845 1.18126 .01788 1.22103 .07907 1.22067 Metetra
.699 .512 .632 r
.07907 1.22067 .01788 1.22103 .01866 1.26137 .07936 1.2609 Metetra
.646 .466 .626 r
.21893 .41291 .17694 .41817 .17757 .45103 .21864 .44545 Metetra
.64 .459 .623 r
.21864 .44545 .17757 .45103 .17734 .48382 .218 .47814 Metetra
.636 .454 .62 r
.218 .47814 .17734 .48382 .17621 .51658 .217 .51097 Metetra
.635 .451 .617 r
.217 .51097 .17621 .51658 .17418 .5493 .21563 .54395 Metetra
.637 .451 .614 r
.21563 .54395 .17418 .5493 .17124 .58203 .2139 .5771 Metetra
.643 .454 .613 r
.2139 .5771 .17124 .58203 .16743 .61478 .21182 .61044 Metetra
.65 .459 .612 r
.21182 .61044 .16743 .61478 .16282 .64761 .20941 .64398 Metetra
.66 .466 .611 r
.20941 .64398 .16282 .64761 .15747 .68056 .20671 .67774 Metetra
.67 .474 .611 r
.20671 .67774 .15747 .68056 .1515 .71368 .20376 .71175 Metetra
.681 .482 .611 r
.20376 .71175 .1515 .71368 .14501 .74702 .2006 .74603 Metetra
.691 .491 .612 r
.2006 .74603 .14501 .74702 .13814 .78064 .19729 .7806 Metetra
.701 .5 .612 r
.19729 .7806 .13814 .78064 .13104 .81459 .19388 .81549 Metetra
.71 .508 .613 r
.19388 .81549 .13104 .81459 .12386 .84893 .19045 .85072 Metetra
.718 .515 .614 r
.19045 .85072 .12386 .84893 .11675 .88369 .18704 .88631 Metetra
.725 .521 .615 r
.18704 .88631 .11675 .88369 .10989 .91892 .18372 .92228 Metetra
.73 .527 .617 r
.18372 .92228 .10989 .91892 .10341 .95467 .18055 .95866 Metetra
.735 .532 .618 r
.18055 .95866 .10341 .95467 .09747 .99095 .17759 .99545 Metetra
.739 .536 .619 r
.17759 .99545 .09747 .99095 .09221 1.0278 .17489 1.03266 Metetra
.742 .54 .62 r
.17489 1.03266 .09221 1.0278 .08772 1.06522 .17249 1.0703 Metetra
.745 .543 .621 r
.17249 1.0703 .08772 1.06522 .08411 1.10323 .17043 1.10839 Metetra
.746 .545 .623 r
.17043 1.10839 .08411 1.10323 .08144 1.14181 .16873 1.14691 Metetra
.747 .547 .624 r
.16873 1.14691 .08144 1.14181 .07975 1.18096 .16741 1.18587 Metetra
.747 .548 .625 r
.16741 1.18587 .07975 1.18096 .07907 1.22067 .16647 1.22526 Metetra
.746 .548 .627 r
.16647 1.22526 .07907 1.22067 .07936 1.2609 .16591 1.26508 Metetra
.662 .473 .618 r
.26457 .40887 .21893 .41291 .21864 .44545 .26321 .44102 Metetra
.656 .469 .619 r
.26321 .44102 .21864 .44545 .218 .47814 .26209 .47353 Metetra
.653 .468 .621 r
.26209 .47353 .218 .47814 .217 .51097 .26123 .50642 Metetra
.653 .469 .623 r
.26123 .50642 .217 .51097 .21563 .54395 .26062 .53968 Metetra
.657 .473 .625 r
.26062 .53968 .21563 .54395 .2139 .5771 .26027 .5733 Metetra
.662 .479 .627 r
.26027 .5733 .2139 .5771 .21182 .61044 .26016 .60728 Metetra
.67 .487 .628 r
.26016 .60728 .21182 .61044 .20941 .64398 .26027 .64162 Metetra
.68 .495 .63 r
.26027 .64162 .20941 .64398 .20671 .67774 .26058 .6763 Metetra
.689 .504 .631 r
.26058 .6763 .20671 .67774 .20376 .71175 .26107 .71131 Metetra
.699 .512 .632 r
.26107 .71131 .20376 .71175 .2006 .74603 .26169 .74664 Metetra
.709 .52 .632 r
.26169 .74664 .2006 .74603 .19729 .7806 .2624 .78228 Metetra
.718 .527 .632 r
.2624 .78228 .19729 .7806 .19388 .81549 .26316 .81822 Metetra
.726 .534 .631 r
.26316 .81822 .19388 .81549 .19045 .85072 .26394 .85445 Metetra
.733 .539 .631 r
.26394 .85445 .19045 .85072 .18704 .88631 .26467 .89096 Metetra
.739 .544 .63 r
.26467 .89096 .18704 .88631 .18372 .92228 .26531 .92775 Metetra
.744 .548 .629 r
.26531 .92775 .18372 .92228 .18055 .95866 .26583 .9648 Metetra
.748 .551 .628 r
.26583 .9648 .18055 .95866 .17759 .99545 .26618 1.00211 Metetra
.752 .553 .627 r
.26618 1.00211 .17759 .99545 .17489 1.03266 .26632 1.0397 Metetra
.754 .555 .626 r
.26632 1.0397 .17489 1.03266 .17249 1.0703 .26623 1.07755 Metetra
.756 .556 .625 r
.26623 1.07755 .17249 1.0703 .17043 1.10839 .26588 1.11567 Metetra
.758 .556 .624 r
.26588 1.11567 .17043 1.10839 .16873 1.14691 .26525 1.15407 Metetra
.758 .556 .624 r
.26525 1.15407 .16873 1.14691 .16741 1.18587 .26433 1.19276 Metetra
.758 .555 .623 r
.26433 1.19276 .16741 1.18587 .16647 1.22526 .26311 1.23175 Metetra
.757 .554 .622 r
.26311 1.23175 .16647 1.22526 .16591 1.26508 .26161 1.27105 Metetra
.647 .454 .608 r
.30794 .40387 .26457 .40887 .26321 .44102 .30565 .43568 Metetra
.643 .454 .614 r
.30565 .43568 .26321 .44102 .26209 .47353 .30412 .46806 Metetra
.64 .457 .619 r
.30412 .46806 .26209 .47353 .26123 .50642 .30338 .50103 Metetra
.642 .462 .625 r
.30338 .50103 .26123 .50642 .26062 .53968 .30346 .53455 Metetra
.646 .47 .631 r
.30346 .53455 .26062 .53968 .26027 .5733 .30434 .56862 Metetra
.652 .479 .637 r
.30434 .56862 .26027 .5733 .26016 .60728 .30598 .60321 Metetra
.66 .489 .641 r
.30598 .60321 .26016 .60728 .26027 .64162 .30833 .63829 Metetra
.67 .498 .644 r
.30833 .63829 .26027 .64162 .26058 .6763 .3113 .67382 Metetra
.68 .508 .647 r
.3113 .67382 .26058 .6763 .26107 .71131 .31482 .70975 Metetra
.69 .517 .648 r
.31482 .70975 .26107 .71131 .26169 .74664 .31875 .74606 Metetra
.699 .525 .648 r
.31875 .74606 .26169 .74664 .2624 .78228 .32299 .78268 Metetra
.708 .532 .648 r
.32299 .78268 .2624 .78228 .26316 .81822 .32739 .81958 Metetra
.716 .538 .647 r
.32739 .81958 .26316 .81822 .26394 .85445 .33182 .85673 Metetra
.724 .543 .645 r
.33182 .85673 .26394 .85445 .26467 .89096 .33614 .89407 Metetra
.73 .546 .643 r
.33614 .89407 .26467 .89096 .26531 .92775 .34021 .9316 Metetra
.735 .549 .641 r
.34021 .9316 .26531 .92775 .26583 .9648 .34391 .96927 Metetra
.74 .551 .638 r
.34391 .96927 .26583 .9648 .26618 1.00211 .34711 1.00708 Metetra
.743 .552 .635 r
.34711 1.00708 .26618 1.00211 .26632 1.0397 .3497 1.04501 Metetra
.746 .552 .632 r
.3497 1.04501 .26632 1.0397 .26623 1.07755 .35159 1.08307 Metetra
.748 .552 .63 r
.35159 1.08307 .26623 1.07755 .26588 1.11567 .35272 1.12125 Metetra
.749 .551 .627 r
.35272 1.12125 .26588 1.11567 .26525 1.15407 .35301 1.15957 Metetra
.75 .549 .624 r
.35301 1.15957 .26525 1.15407 .26433 1.19276 .35245 1.19805 Metetra
.75 .547 .621 r
.35245 1.19805 .26433 1.19276 .26311 1.23175 .35102 1.23672 Metetra
.749 .544 .618 r
.35102 1.23672 .26311 1.23175 .26161 1.27105 .34873 1.27559 Metetra
.592 .402 .593 r
.34386 .3959 .30794 .40387 .30565 .43568 .34101 .42755 Metetra
.589 .407 .603 r
.34101 .42755 .30565 .43568 .30412 .46806 .33926 .45993 Metetra
.589 .415 .613 r
.33926 .45993 .30412 .46806 .30338 .50103 .33864 .49301 Metetra
.592 .425 .624 r
.33864 .49301 .30338 .50103 .30346 .53455 .33919 .52678 Metetra
.598 .436 .634 r
.33919 .52678 .30346 .53455 .30434 .56862 .34088 .56122 Metetra
.605 .449 .643 r
.34088 .56122 .30434 .56862 .30598 .60321 .34367 .59629 Metetra
.614 .461 .65 r
.34367 .59629 .30598 .60321 .30833 .63829 .34747 .63193 Metetra
.624 .473 .656 r
.34747 .63193 .30833 .63829 .3113 .67382 .35216 .6681 Metetra
.635 .484 .661 r
.35216 .6681 .3113 .67382 .31482 .70975 .35762 .70472 Metetra
.645 .494 .663 r
.35762 .70472 .31482 .70975 .31875 .74606 .36368 .74174 Metetra
.655 .503 .665 r
.36368 .74174 .31875 .74606 .32299 .78268 .37016 .77909 Metetra
.665 .51 .665 r
.37016 .77909 .32299 .78268 .32739 .81958 .37688 .8167 Metetra
.674 .516 .663 r
.37688 .8167 .32739 .81958 .33182 .85673 .38363 .85453 Metetra
.682 .52 .661 r
.38363 .85453 .33182 .85673 .33614 .89407 .39023 .89251 Metetra
.688 .524 .658 r
.39023 .89251 .33614 .89407 .34021 .9316 .39647 .9306 Metetra
.694 .526 .655 r
.39647 .9306 .34021 .9316 .34391 .96927 .40217 .96877 Metetra
.7 .527 .65 r
.40217 .96877 .34391 .96927 .34711 1.00708 .40717 1.00699 Metetra
.704 .526 .646 r
.40717 1.00699 .34711 1.00708 .3497 1.04501 .41131 1.04525 Metetra
.707 .525 .641 r
.41131 1.04525 .3497 1.04501 .35159 1.08307 .41447 1.08353 Metetra
.709 .523 .635 r
.41447 1.08353 .35159 1.08307 .35272 1.12125 .41654 1.12185 Metetra
.71 .52 .63 r
.41654 1.12185 .35272 1.12125 .35301 1.15957 .41745 1.16022 Metetra
.711 .516 .624 r
.41745 1.16022 .35301 1.15957 .35245 1.19805 .41716 1.19868 Metetra
.71 .512 .619 r
.41716 1.19868 .35245 1.19805 .35102 1.23672 .41564 1.23724 Metetra
.708 .506 .613 r
.41564 1.23724 .35102 1.23672 .34873 1.27559 .41291 1.27595 Metetra
.444 .274 .555 r
.36908 .38358 .34386 .3959 .34101 .42755 .3662 .41536 Metetra
.452 .292 .573 r
.3662 .41536 .34101 .42755 .33926 .45993 .36447 .44788 Metetra
.46 .31 .59 r
.36447 .44788 .33926 .45993 .33864 .49301 .36396 .48115 Metetra
.468 .327 .606 r
.36396 .48115 .33864 .49301 .33919 .52678 .36468 .51515 Metetra
.477 .344 .621 r
.36468 .51515 .33919 .52678 .34088 .56122 .3666 .54985 Metetra
.485 .36 .634 r
.3666 .54985 .34088 .56122 .34367 .59629 .36969 .5852 Metetra
.493 .374 .646 r
.36969 .5852 .34367 .59629 .34747 .63193 .37385 .62115 Metetra
.501 .386 .655 r
.37385 .62115 .34747 .63193 .35216 .6681 .37896 .65764 Metetra
.508 .397 .663 r
.37896 .65764 .35216 .6681 .35762 .70472 .38488 .69461 Metetra
.515 .406 .669 r
.38488 .69461 .35762 .70472 .36368 .74174 .39144 .73198 Metetra
.521 .413 .672 r
.39144 .73198 .36368 .74174 .37016 .77909 .39844 .76969 Metetra
.526 .418 .674 r
.39844 .76969 .37016 .77909 .37688 .8167 .40569 .80767 Metetra
.531 .421 .674 r
.40569 .80767 .37688 .8167 .38363 .85453 .41298 .84585 Metetra
.535 .423 .673 r
.41298 .84585 .38363 .85453 .39023 .89251 .4201 .88418 Metetra
.538 .422 .669 r
.4201 .88418 .39023 .89251 .39647 .9306 .42684 .92261 Metetra
.541 .42 .664 r
.42684 .92261 .39647 .9306 .40217 .96877 .43302 .9611 Metetra
.543 .417 .658 r
.43302 .9611 .40217 .96877 .40717 1.00699 .43846 .99963 Metetra
.544 .411 .65 r
.43846 .99963 .40717 1.00699 .41131 1.04525 .44299 1.03818 Metetra
.544 .405 .642 r
.44299 1.03818 .41131 1.04525 .41447 1.08353 .44648 1.07674 Metetra
.543 .396 .632 r
.44648 1.07674 .41447 1.08353 .41654 1.12185 .44882 1.11532 Metetra
.542 .387 .621 r
.44882 1.11532 .41654 1.12185 .41745 1.16022 .44994 1.15394 Metetra
.539 .377 .609 r
.44994 1.15394 .41745 1.16022 .41716 1.19868 .44979 1.19261 Metetra
.536 .366 .597 r
.44979 1.19261 .41716 1.19868 .41564 1.23724 .44834 1.23139 Metetra
.532 .354 .585 r
.44834 1.23139 .41564 1.23724 .41291 1.27595 .44562 1.27031 Metetra
.066 0 .423 r
.38292 .36648 .36908 .38358 .3662 .41536 .38056 .39867 Metetra
.113 .021 .463 r
.38056 .39867 .3662 .41536 .36447 .44788 .37913 .43154 Metetra
.147 .062 .494 r
.37913 .43154 .36447 .44788 .36396 .48115 .37869 .46508 Metetra
.168 .092 .519 r
.37869 .46508 .36396 .48115 .36468 .51515 .37926 .49927 Metetra
.178 .111 .539 r
.37926 .49927 .36468 .51515 .3666 .54985 .38081 .53409 Metetra
.177 .122 .553 r
.38081 .53409 .3666 .54985 .36969 .5852 .38331 .56951 Metetra
.165 .124 .562 r
.38331 .56951 .36969 .5852 .37385 .62115 .38668 .60549 Metetra
.143 .117 .566 r
.38668 .60549 .37385 .62115 .37896 .65764 .39083 .64197 Metetra
.11 .1 .565 r
.39083 .64197 .37896 .65764 .38488 .69461 .39564 .6789 Metetra
.065 .074 .556 r
.39564 .6789 .38488 .69461 .39144 .73198 .40097 .71623 Metetra
.009 .037 .54 r
.40097 .71623 .39144 .73198 .39844 .76969 .40668 .7539 Metetra
0 0 .515 r
.40668 .7539 .39844 .76969 .40569 .80767 .41258 .79185 Metetra
0 0 .48 r
.41258 .79185 .40569 .80767 .41298 .84585 .41853 .83003 Metetra
0 0 .434 r
.41853 .83003 .41298 .84585 .4201 .88418 .42434 .8684 Metetra
0 0 .377 r
.42434 .8684 .4201 .88418 .42684 .92261 .42985 .90692 Metetra
0 0 .312 r
.42985 .90692 .42684 .92261 .43302 .9611 .4349 .94556 Metetra
0 0 .241 r
.4349 .94556 .43302 .9611 .43846 .99963 .43934 .98429 Metetra
0 0 .17 r
.43934 .98429 .43846 .99963 .44299 1.03818 .44304 1.0231 Metetra
0 0 .101 r
.44304 1.0231 .44299 1.03818 .44648 1.07674 .44588 1.06198 Metetra
0 0 .04 r
.44588 1.06198 .44648 1.07674 .44882 1.11532 .44779 1.10095 Metetra
.738 .587 .013 r
.44779 1.10095 .44882 1.11532 .44994 1.15394 .44869 1.14002 Metetra
.764 .62 .055 r
.44869 1.14002 .44994 1.15394 .44979 1.19261 .44855 1.1792 Metetra
.777 .645 .087 r
.44855 1.1792 .44979 1.19261 .44834 1.23139 .44734 1.21854 Metetra
.779 .661 .107 r
.44734 1.21854 .44834 1.23139 .44562 1.27031 .44509 1.25806 Metetra
0 0 .129 r
.38742 .34521 .38292 .36648 .38056 .39867 .38603 .37809 Metetra
0 0 .197 r
.38603 .37809 .38056 .39867 .37913 .43154 .38514 .41146 Metetra
0 0 .243 r
.38514 .41146 .37913 .43154 .37869 .46508 .38476 .44532 Metetra
0 0 .268 r
.38476 .44532 .37869 .46508 .37926 .49927 .3849 .47968 Metetra
0 0 .273 r
.3849 .47968 .37926 .49927 .38081 .53409 .38557 .51452 Metetra
0 0 .257 r
.38557 .51452 .38081 .53409 .38331 .56951 .38672 .54982 Metetra
0 0 .22 r
.38672 .54982 .38331 .56951 .38668 .60549 .38834 .58557 Metetra
0 0 .161 r
.38834 .58557 .38668 .60549 .39083 .64197 .39037 .62173 Metetra
0 0 .083 r
.39037 .62173 .39083 .64197 .39564 .6789 .39275 .65829 Metetra
.766 .579 .008 r
.39275 .65829 .39564 .6789 .40097 .71623 .3954 .69522 Metetra
.852 .64 .1 r
.3954 .69522 .40097 .71623 .40668 .7539 .39826 .73249 Metetra
.914 .684 .185 r
.39826 .73249 .40668 .7539 .41258 .79185 .40122 .77007 Metetra
.954 .713 .258 r
.40122 .77007 .41258 .79185 .41853 .83003 .40421 .80793 Metetra
.977 .73 .316 r
.40421 .80793 .41853 .83003 .42434 .8684 .40713 .84606 Metetra
.988 .74 .362 r
.40713 .84606 .42434 .8684 .42985 .90692 .40989 .88443 Metetra
.993 .745 .397 r
.40989 .88443 .42985 .90692 .4349 .94556 .41241 .92303 Metetra
.994 .747 .425 r
.41241 .92303 .4349 .94556 .43934 .98429 .41461 .96185 Metetra
.993 .749 .447 r
.41461 .96185 .43934 .98429 .44304 1.0231 .41642 1.00089 Metetra
.991 .75 .464 r
.41642 1.00089 .44304 1.0231 .44588 1.06198 .41777 1.04014 Metetra
.99 .751 .477 r
.41777 1.04014 .44588 1.06198 .44779 1.10095 .41862 1.0796 Metetra
.989 .753 .488 r
.41862 1.0796 .44779 1.10095 .44869 1.14002 .41893 1.1193 Metetra
.988 .756 .495 r
.41893 1.1193 .44869 1.14002 .44855 1.1792 .41868 1.15924 Metetra
.988 .759 .5 r
.41868 1.15924 .44855 1.1792 .44734 1.21854 .41786 1.19945 Metetra
.989 .763 .504 r
.41786 1.19945 .44734 1.21854 .44509 1.25806 .41648 1.23994 Metetra
.733 .599 .026 r
.38697 .32138 .38742 .34521 .38603 .37809 .38682 .35509 Metetra
0 0 .021 r
.38682 .35509 .38603 .37809 .38514 .41146 .38658 .38906 Metetra
0 0 .045 r
.38658 .38906 .38514 .41146 .38476 .44532 .38625 .42329 Metetra
0 0 .042 r
.38625 .42329 .38476 .44532 .3849 .47968 .38582 .4578 Metetra
0 0 .014 r
.38582 .4578 .3849 .47968 .38557 .51452 .3853 .49258 Metetra
.736 .608 .038 r
.3853 .49258 .38557 .51452 .38672 .54982 .3847 .52765 Metetra
.807 .659 .109 r
.3847 .52765 .38672 .54982 .38834 .58557 .38401 .56301 Metetra
.876 .708 .188 r
.38401 .56301 .38834 .58557 .39037 .62173 .38324 .59867 Metetra
.932 .745 .265 r
.38324 .59867 .39037 .62173 .39275 .65829 .38241 .63464 Metetra
.969 .767 .333 r
.38241 .63464 .39275 .65829 .3954 .69522 .38153 .67094 Metetra
.989 .776 .387 r
.38153 .67094 .3954 .69522 .39826 .73249 .3806 .70757 Metetra
.997 .777 .428 r
.3806 .70757 .39826 .73249 .40122 .77007 .37966 .74454 Metetra
.997 .773 .459 r
.37966 .74454 .40122 .77007 .40421 .80793 .3787 .78187 Metetra
.994 .767 .482 r
.3787 .78187 .40421 .80793 .40713 .84606 .37775 .81955 Metetra
.989 .76 .498 r
.37775 .81955 .40713 .84606 .40989 .88443 .37682 .85761 Metetra
.984 .754 .51 r
.37682 .85761 .40989 .88443 .41241 .92303 .37594 .89605 Metetra
.979 .748 .519 r
.37594 .89605 .41241 .92303 .41461 .96185 .3751 .93487 Metetra
.974 .743 .526 r
.3751 .93487 .41461 .96185 .41642 1.00089 .37432 .97409 Metetra
.971 .739 .53 r
.37432 .97409 .41642 1.00089 .41777 1.04014 .37362 1.01372 Metetra
.968 .736 .533 r
.37362 1.01372 .41777 1.04014 .41862 1.0796 .37301 1.05374 Metetra
.967 .734 .535 r
.37301 1.05374 .41862 1.0796 .41893 1.1193 .37248 1.09418 Metetra
.966 .733 .535 r
.37248 1.09418 .41893 1.1193 .41868 1.15924 .37205 1.13504 Metetra
.966 .732 .534 r
.37205 1.13504 .41868 1.15924 .41786 1.19945 .37172 1.17631 Metetra
.967 .733 .532 r
.37172 1.17631 .41786 1.19945 .41648 1.23994 .37148 1.218 Metetra
0 0 .07 r
.38737 .29725 .38697 .32138 .38682 .35509 .38846 .3318 Metetra
0 0 .088 r
.38846 .3318 .38682 .35509 .38658 .38906 .38887 .36638 Metetra
0 0 .081 r
.38887 .36638 .38658 .38906 .38625 .42329 .38859 .40098 Metetra
0 0 .049 r
.38859 .40098 .38625 .42329 .38582 .4578 .38761 .43563 Metetra
.38761 .43563 .38582 .4578 .3853 .49258 .38592 .47036 Metetra
.744 .642 .082 r
.38592 .47036 .3853 .49258 .3847 .52765 .38357 .50518 Metetra
.822 .705 .169 r
.38357 .50518 .3847 .52765 .38401 .56301 .38058 .54014 Metetra
.892 .758 .257 r
.38058 .54014 .38401 .56301 .38324 .59867 .37704 .57527 Metetra
.945 .793 .336 r
.37704 .57527 .38324 .59867 .38241 .63464 .373 .61064 Metetra
.977 .811 .4 r
.373 .61064 .38241 .63464 .38153 .67094 .36858 .64627 Metetra
.994 .816 .447 r
.36858 .64627 .38153 .67094 .3806 .70757 .36386 .68223 Metetra
1 .812 .48 r
.36386 .68223 .3806 .70757 .37966 .74454 .35896 .71856 Metetra
.999 .804 .503 r
.35896 .71856 .37966 .74454 .3787 .78187 .35401 .7553 Metetra
.995 .794 .519 r
.35401 .7553 .3787 .78187 .37775 .81955 .34913 .7925 Metetra
.991 .784 .529 r
.34913 .7925 .37775 .81955 .37682 .85761 .34444 .8302 Metetra
.986 .774 .535 r
.34444 .8302 .37682 .85761 .37594 .89605 .34006 .86844 Metetra
.981 .765 .538 r
.34006 .86844 .37594 .89605 .3751 .93487 .3361 .90724 Metetra
.977 .757 .54 r
.3361 .90724 .3751 .93487 .37432 .97409 .33267 .94662 Metetra
.974 .751 .539 r
.33267 .94662 .37432 .97409 .37362 1.01372 .32985 .9866 Metetra
.972 .745 .537 r
.32985 .9866 .37362 1.01372 .37301 1.05374 .32772 1.02719 Metetra
.97 .74 .534 r
.32772 1.02719 .37301 1.05374 .37248 1.09418 .32633 1.06838 Metetra
.969 .736 .53 r
.32633 1.06838 .37248 1.09418 .37205 1.13504 .32571 1.11016 Metetra
.969 .733 .525 r
.32571 1.11016 .37205 1.13504 .37172 1.17631 .32587 1.15253 Metetra
.97 .731 .518 r
.32587 1.15253 .37172 1.17631 .37148 1.218 .3268 1.19546 Metetra
0 0 .367 r
.39455 .27526 .38737 .29725 .38846 .3318 .39657 .3105 Metetra
0 0 .352 r
.39657 .3105 .38846 .3318 .38887 .36638 .39749 .34559 Metetra
0 0 .322 r
.39749 .34559 .38887 .36638 .38859 .40098 .39728 .38053 Metetra
0 0 .277 r
.39728 .38053 .38859 .40098 .38761 .43563 .39592 .41534 Metetra
0 0 .215 r
.39592 .41534 .38761 .43563 .38592 .47036 .39341 .45007 Metetra
0 0 .135 r
.39341 .45007 .38592 .47036 .38357 .50518 .38979 .48476 Metetra
0 0 .04 r
.38979 .48476 .38357 .50518 .38058 .54014 .38515 .51947 Metetra
.38515 .51947 .38058 .54014 .37704 .57527 .37958 .55426 Metetra
.749 .708 .171 r
.37958 .55426 .37704 .57527 .373 .61064 .3732 .58921 Metetra
.839 .774 .267 r
.3732 .58921 .373 .61064 .36858 .64627 .36617 .6244 Metetra
.905 .816 .344 r
.36617 .6244 .36858 .64627 .36386 .68223 .35865 .65989 Metetra
.948 .838 .403 r
.35865 .65989 .36386 .68223 .35896 .71856 .35083 .69577 Metetra
.974 .845 .444 r
.35083 .69577 .35896 .71856 .35401 .7553 .34291 .73212 Metetra
.989 .843 .471 r
.34291 .73212 .35401 .7553 .34913 .7925 .33509 .769 Metetra
.996 .836 .487 r
.33509 .769 .34913 .7925 .34444 .8302 .32759 .80648 Metetra
.999 .827 .496 r
.32759 .80648 .34444 .8302 .34006 .86844 .32059 .84461 Metetra
1 .816 .5 r
.32059 .84461 .34006 .86844 .3361 .90724 .31429 .88344 Metetra
1 .805 .499 r
.31429 .88344 .3361 .90724 .33267 .94662 .30887 .92301 Metetra
.999 .795 .494 r
.30887 .92301 .33267 .94662 .32985 .9866 .30446 .96332 Metetra
.997 .784 .487 r
.30446 .96332 .32985 .9866 .32772 1.02719 .30121 1.0044 Metetra
.996 .775 .478 r
.30121 1.0044 .32772 1.02719 .32633 1.06838 .29918 1.04624 Metetra
.995 .766 .465 r
.29918 1.04624 .32633 1.06838 .32571 1.11016 .29845 1.08882 Metetra
.995 .757 .451 r
.29845 1.08882 .32571 1.11016 .32587 1.15253 .29903 1.13211 Metetra
.994 .749 .434 r
.29903 1.13211 .32587 1.15253 .3268 1.19546 .30089 1.17609 Metetra
.268 .186 .574 r
.41295 .25735 .39455 .27526 .39657 .3105 .41539 .29301 Metetra
.259 .164 .553 r
.41539 .29301 .39657 .3105 .39749 .34559 .41658 .32843 Metetra
.244 .137 .528 r
.41658 .32843 .39749 .34559 .39728 .38053 .41646 .36364 Metetra
.222 .104 .499 r
.41646 .36364 .39728 .38053 .39592 .41534 .41503 .39866 Metetra
.195 .066 .467 r
.41503 .39866 .39592 .41534 .39341 .45007 .41228 .43353 Metetra
.161 .022 .431 r
.41228 .43353 .39341 .45007 .38979 .48476 .40827 .46831 Metetra
.12 0 .393 r
.40827 .46831 .38979 .48476 .38515 .51947 .40308 .50306 Metetra
.074 0 .352 r
.40308 .50306 .38515 .51947 .37958 .55426 .39682 .53786 Metetra
.022 0 .309 r
.39682 .53786 .37958 .55426 .3732 .58921 .38964 .57279 Metetra
0 0 .266 r
.38964 .57279 .3732 .58921 .36617 .6244 .3817 .60794 Metetra
0 0 .225 r
.3817 .60794 .36617 .6244 .35865 .65989 .3732 .64339 Metetra
0 0 .187 r
.3732 .64339 .35865 .65989 .35083 .69577 .36436 .67925 Metetra
0 0 .154 r
.36436 .67925 .35083 .69577 .34291 .73212 .35539 .71559 Metetra
0 0 .127 r
.35539 .71559 .34291 .73212 .33509 .769 .34654 .75251 Metetra
0 0 .109 r
.34654 .75251 .33509 .769 .32759 .80648 .33805 .79006 Metetra
0 0 .1 r
.33805 .79006 .32759 .80648 .32059 .84461 .33013 .82832 Metetra
0 0 .1 r
.33013 .82832 .32059 .84461 .31429 .88344 .32302 .86733 Metetra
0 0 .109 r
.32302 .86733 .31429 .88344 .30887 .92301 .31692 .90715 Metetra
0 0 .127 r
.31692 .90715 .30887 .92301 .30446 .96332 .31199 .94778 Metetra
0 0 .153 r
.31199 .94778 .30446 .96332 .30121 1.0044 .30838 .98925 Metetra
0 0 .185 r
.30838 .98925 .30121 1.0044 .29918 1.04624 .3062 1.03154 Metetra
0 0 .223 r
.3062 1.03154 .29918 1.04624 .29845 1.08882 .30551 1.07465 Metetra
0 0 .265 r
.30551 1.07465 .29845 1.08882 .29903 1.13211 .30633 1.11852 Metetra
0 0 .309 r
.30633 1.11852 .29903 1.13211 .30089 1.17609 .30863 1.16313 Metetra
.513 .368 .62 r
.44431 .24445 .41295 .25735 .41539 .29301 .44656 .28017 Metetra
.503 .351 .607 r
.44656 .28017 .41539 .29301 .41658 .32843 .44772 .31572 Metetra
.494 .335 .593 r
.44772 .31572 .41658 .32843 .41646 .36364 .44773 .35112 Metetra
.487 .319 .578 r
.44773 .35112 .41646 .36364 .41503 .39866 .44659 .38639 Metetra
.483 .305 .564 r
.44659 .38639 .41503 .39866 .41228 .43353 .4443 .42157 Metetra
.48 .294 .551 r
.4443 .42157 .41228 .43353 .40827 .46831 .4409 .4567 Metetra
.481 .286 .539 r
.4409 .4567 .40827 .46831 .40308 .50306 .43647 .49185 Metetra
.484 .282 .529 r
.43647 .49185 .40308 .50306 .39682 .53786 .4311 .52709 Metetra
.49 .281 .522 r
.4311 .52709 .39682 .53786 .38964 .57279 .42493 .56249 Metetra
.499 .284 .518 r
.42493 .56249 .38964 .57279 .3817 .60794 .4181 .59813 Metetra
.509 .29 .517 r
.4181 .59813 .3817 .60794 .3732 .64339 .41078 .63409 Metetra
.52 .298 .518 r
.41078 .63409 .3732 .64339 .36436 .67925 .40316 .67045 Metetra
.532 .309 .522 r
.40316 .67045 .36436 .67925 .35539 .71559 .39544 .70728 Metetra
.544 .322 .528 r
.39544 .70728 .35539 .71559 .34654 .75251 .38783 .74467 Metetra
.555 .335 .536 r
.38783 .74467 .34654 .75251 .33805 .79006 .38053 .78268 Metetra
.566 .349 .545 r
.38053 .78268 .33805 .79006 .33013 .82832 .37374 .82136 Metetra
.576 .363 .554 r
.37374 .82136 .33013 .82832 .32302 .86733 .36767 .86077 Metetra
.585 .376 .565 r
.36767 .86077 .32302 .86733 .31692 .90715 .36246 .90093 Metetra
.592 .389 .575 r
.36246 .90093 .31692 .90715 .31199 .94778 .3583 .94188 Metetra
.598 .401 .585 r
.3583 .94188 .31199 .94778 .30838 .98925 .35528 .98361 Metetra
.603 .412 .596 r
.35528 .98361 .30838 .98925 .3062 1.03154 .35351 1.02613 Metetra
.606 .421 .606 r
.35351 1.02613 .3062 1.03154 .30551 1.07465 .35305 1.06942 Metetra
.608 .429 .615 r
.35305 1.06942 .30551 1.07465 .30633 1.11852 .3539 1.11345 Metetra
.608 .436 .624 r
.3539 1.11345 .30633 1.11852 .30863 1.16313 .35605 1.15818 Metetra
.613 .438 .621 r
.48709 .23611 .44431 .24445 .44656 .28017 .48863 .27158 Metetra
.605 .427 .615 r
.48863 .27158 .44656 .28017 .44772 .31572 .48951 .30707 Metetra
.6 .419 .608 r
.48951 .30707 .44772 .31572 .44773 .35112 .48969 .34258 Metetra
.598 .412 .602 r
.48969 .34258 .44773 .35112 .44659 .38639 .48915 .37815 Metetra
.599 .409 .595 r
.48915 .37815 .44659 .38639 .4443 .42157 .48792 .41378 Metetra
.603 .408 .59 r
.48792 .41378 .4443 .42157 .4409 .4567 .48601 .44952 Metetra
.611 .411 .586 r
.48601 .44952 .4409 .4567 .43647 .49185 .48347 .4854 Metetra
.621 .416 .583 r
.48347 .4854 .43647 .49185 .4311 .52709 .48037 .52148 Metetra
.632 .423 .581 r
.48037 .52148 .4311 .52709 .42493 .56249 .47677 .55779 Metetra
.644 .432 .581 r
.47677 .55779 .42493 .56249 .4181 .59813 .47278 .59439 Metetra
.657 .442 .581 r
.47278 .59439 .4181 .59813 .41078 .63409 .4685 .63133 Metetra
.669 .452 .582 r
.4685 .63133 .41078 .63409 .40316 .67045 .46405 .66866 Metetra
.68 .462 .584 r
.46405 .66866 .40316 .67045 .39544 .70728 .45955 .70644 Metetra
.69 .472 .586 r
.45955 .70644 .39544 .70728 .38783 .74467 .45511 .7447 Metetra
.699 .481 .588 r
.45511 .7447 .38783 .74467 .38053 .78268 .45088 .7835 Metetra
.707 .489 .591 r
.45088 .7835 .38053 .78268 .37374 .82136 .44696 .82288 Metetra
.713 .497 .594 r
.44696 .82288 .37374 .82136 .36767 .86077 .44347 .86285 Metetra
.719 .504 .598 r
.44347 .86285 .36767 .86077 .36246 .90093 .44053 .90345 Metetra
.723 .51 .601 r
.44053 .90345 .36246 .90093 .3583 .94188 .43821 .94468 Metetra
.726 .515 .604 r
.43821 .94468 .3583 .94188 .35528 .98361 .43658 .98657 Metetra
.728 .519 .608 r
.43658 .98657 .35528 .98361 .35351 1.02613 .43572 1.0291 Metetra
.729 .522 .611 r
.43572 1.0291 .35351 1.02613 .35305 1.06942 .43564 1.07228 Metetra
.73 .525 .615 r
.43564 1.07228 .35305 1.06942 .3539 1.11345 .43635 1.11608 Metetra
.729 .527 .618 r
.43635 1.11608 .3539 1.11345 .35605 1.15818 .43786 1.16049 Metetra
.651 .46 .613 r
.53696 .23063 .48709 .23611 .48863 .27158 .53749 .26565 Metetra
.644 .455 .612 r
.53749 .26565 .48863 .27158 .48951 .30707 .53793 .30095 Metetra
.641 .451 .611 r
.53793 .30095 .48951 .30707 .48969 .34258 .53829 .33654 Metetra
.64 .45 .61 r
.53829 .33654 .48969 .34258 .48915 .37815 .53856 .37243 Metetra
.643 .452 .61 r
.53856 .37243 .48915 .37815 .48792 .41378 .53873 .40861 Metetra
.649 .456 .609 r
.53873 .40861 .48792 .41378 .48601 .44952 .53883 .44511 Metetra
.658 .463 .609 r
.53883 .44511 .48601 .44952 .48347 .4854 .53885 .48194 Metetra
.668 .471 .609 r
.53885 .48194 .48347 .4854 .48037 .52148 .53879 .51909 Metetra
.679 .48 .609 r
.53879 .51909 .48037 .52148 .47677 .55779 .53868 .55658 Metetra
.69 .489 .609 r
.53868 .55658 .47677 .55779 .47278 .59439 .53852 .59443 Metetra
.701 .498 .609 r
.53852 .59443 .47278 .59439 .4685 .63133 .53833 .63264 Metetra
.712 .506 .609 r
.53833 .63264 .4685 .63133 .46405 .66866 .53812 .67123 Metetra
.721 .514 .609 r
.53812 .67123 .46405 .66866 .45955 .70644 .53791 .71021 Metetra
.73 .521 .609 r
.53791 .71021 .45955 .70644 .45511 .7447 .53771 .74959 Metetra
.737 .527 .609 r
.53771 .74959 .45511 .7447 .45088 .7835 .53755 .78937 Metetra
.743 .532 .609 r
.53755 .78937 .45088 .7835 .44696 .82288 .53742 .82958 Metetra
.748 .537 .609 r
.53742 .82958 .44696 .82288 .44347 .86285 .53736 .87021 Metetra
.753 .541 .609 r
.53736 .87021 .44347 .86285 .44053 .90345 .53737 .91128 Metetra
.756 .543 .609 r
.53737 .91128 .44053 .90345 .43821 .94468 .53747 .95279 Metetra
.758 .546 .609 r
.53747 .95279 .43821 .94468 .43658 .98657 .53765 .99476 Metetra
.76 .547 .609 r
.53765 .99476 .43658 .98657 .43572 1.0291 .53794 1.03717 Metetra
.761 .548 .609 r
.53794 1.03717 .43572 1.0291 .43564 1.07228 .53833 1.08005 Metetra
.761 .548 .61 r
.53833 1.08005 .43564 1.07228 .43635 1.11608 .53883 1.12339 Metetra
.76 .548 .61 r
.53883 1.12339 .43635 1.11608 .43786 1.16049 .53943 1.1672 Metetra
.653 .455 .603 r
.58799 .22551 .53696 .23063 .53749 .26565 .58749 .26004 Metetra
.648 .453 .607 r
.58749 .26004 .53749 .26565 .53793 .30095 .58749 .29514 Metetra
.645 .454 .611 r
.58749 .29514 .53793 .30095 .53829 .33654 .58803 .3308 Metetra
.646 .458 .615 r
.58803 .3308 .53829 .33654 .53856 .37243 .58912 .36701 Metetra
.649 .464 .619 r
.58912 .36701 .53856 .37243 .53873 .40861 .59074 .40377 Metetra
.656 .472 .623 r
.59074 .40377 .53873 .40861 .53883 .44511 .59288 .44106 Metetra
.665 .481 .626 r
.59288 .44106 .53883 .44511 .53885 .48194 .59549 .47885 Metetra
.675 .49 .628 r
.59549 .47885 .53885 .48194 .53879 .51909 .59854 .51712 Metetra
.686 .5 .629 r
.59854 .51712 .53879 .51909 .53868 .55658 .60194 .55584 Metetra
.697 .509 .63 r
.60194 .55584 .53868 .55658 .53852 .59443 .60565 .59497 Metetra
.708 .518 .63 r
.60565 .59497 .53852 .59443 .53833 .63264 .60956 .63449 Metetra
.718 .525 .629 r
.60956 .63449 .53833 .63264 .53812 .67123 .6136 .67437 Metetra
.727 .532 .628 r
.6136 .67437 .53812 .67123 .53791 .71021 .61767 .71457 Metetra
.735 .538 .626 r
.61767 .71457 .53791 .71021 .53771 .74959 .62168 .75507 Metetra
.742 .542 .624 r
.62168 .75507 .53771 .74959 .53755 .78937 .62554 .79584 Metetra
.747 .546 .622 r
.62554 .79584 .53755 .78937 .53742 .82958 .62916 .83688 Metetra
.752 .548 .62 r
.62916 .83688 .53742 .82958 .53736 .87021 .63247 .87817 Metetra
.756 .55 .618 r
.63247 .87817 .53736 .87021 .53737 .91128 .63538 .9197 Metetra
.76 .551 .615 r
.63538 .9197 .53737 .91128 .53747 .95279 .63784 .96147 Metetra
.762 .552 .613 r
.63784 .96147 .53747 .95279 .53765 .99476 .6398 1.00349 Metetra
.763 .552 .611 r
.6398 1.00349 .53765 .99476 .53794 1.03717 .64123 1.04578 Metetra
.764 .551 .609 r
.64123 1.04578 .53794 1.03717 .53833 1.08005 .64209 1.08834 Metetra
.764 .549 .607 r
.64209 1.08834 .53833 1.08005 .53883 1.12339 .64238 1.1312 Metetra
.763 .547 .605 r
.64238 1.1312 .53883 1.12339 .53943 1.1672 .64212 1.17439 Metetra
.621 .422 .591 r
.63424 .21807 .58799 .22551 .58749 .26004 .63296 .25226 Metetra
.617 .425 .6 r
.63296 .25226 .58749 .26004 .58749 .29514 .63266 .28724 Metetra
.616 .431 .609 r
.63266 .28724 .58749 .29514 .58803 .3308 .63338 .323 Metetra
.618 .439 .618 r
.63338 .323 .58803 .3308 .58912 .36701 .63514 .35953 Metetra
.623 .449 .626 r
.63514 .35953 .58912 .36701 .59074 .40377 .63792 .3968 Metetra
.631 .46 .633 r
.63792 .3968 .59074 .40377 .59288 .44106 .64167 .43478 Metetra
.64 .472 .639 r
.64167 .43478 .59288 .44106 .59549 .47885 .64634 .4734 Metetra
.65 .483 .644 r
.64634 .4734 .59549 .47885 .59854 .51712 .65181 .51262 Metetra
.661 .494 .647 r
.65181 .51262 .59854 .51712 .60194 .55584 .65798 .55237 Metetra
.673 .504 .649 r
.65798 .55237 .60194 .55584 .60565 .59497 .66469 .59259 Metetra
.683 .513 .649 r
.66469 .59259 .60565 .59497 .60956 .63449 .67179 .6332 Metetra
.694 .521 .649 r
.67179 .6332 .60956 .63449 .6136 .67437 .67911 .67416 Metetra
.703 .527 .647 r
.67911 .67416 .6136 .67437 .61767 .71457 .68648 .71538 Metetra
.711 .532 .644 r
.68648 .71538 .61767 .71457 .62168 .75507 .69372 .75682 Metetra
.719 .535 .641 r
.69372 .75682 .62168 .75507 .62554 .79584 .70067 .79844 Metetra
.725 .538 .638 r
.70067 .79844 .62554 .79584 .62916 .83688 .70716 .84019 Metetra
.73 .54 .633 r
.70716 .84019 .62916 .83688 .63247 .87817 .71304 .88206 Metetra
.735 .54 .629 r
.71304 .88206 .63247 .87817 .63538 .9197 .71818 .92401 Metetra
.738 .54 .625 r
.71818 .92401 .63538 .9197 .63784 .96147 .72246 .96605 Metetra
.74 .538 .62 r
.72246 .96605 .63784 .96147 .6398 1.00349 .72579 1.00819 Metetra
.742 .536 .615 r
.72579 1.00819 .6398 1.00349 .64123 1.04578 .72811 1.05044 Metetra
.742 .533 .611 r
.72811 1.05044 .64123 1.04578 .64209 1.08834 .72936 1.09283 Metetra
.742 .53 .606 r
.72936 1.09283 .64209 1.08834 .64238 1.1312 .72955 1.13539 Metetra
.741 .525 .602 r
.72955 1.13539 .64238 1.1312 .64212 1.17439 .72869 1.17817 Metetra
.534 .346 .572 r
.67115 .20612 .63424 .21807 .63296 .25226 .66956 .24025 Metetra
.534 .356 .586 r
.66956 .24025 .63296 .25226 .63266 .28724 .66918 .27529 Metetra
.537 .369 .6 r
.66918 .27529 .63266 .28724 .63338 .323 .67006 .31122 Metetra
.542 .383 .614 r
.67006 .31122 .63338 .323 .63514 .35953 .67222 .34804 Metetra
.55 .397 .627 r
.67222 .34804 .63514 .35953 .63792 .3968 .67564 .38569 Metetra
.558 .411 .638 r
.67564 .38569 .63792 .3968 .64167 .43478 .68026 .42415 Metetra
.567 .425 .648 r
.68026 .42415 .64167 .43478 .64634 .4734 .686 .46333 Metetra
.578 .439 .655 r
.686 .46333 .64634 .4734 .65181 .51262 .69274 .50318 Metetra
.588 .45 .661 r
.69274 .50318 .65181 .51262 .65798 .55237 .70031 .5436 Metetra
.598 .461 .665 r
.70031 .5436 .65798 .55237 .66469 .59259 .70856 .58451 Metetra
.608 .47 .668 r
.70856 .58451 .66469 .59259 .67179 .6332 .71728 .62584 Metetra
.618 .477 .668 r
.71728 .62584 .67179 .6332 .67911 .67416 .72626 .66749 Metetra
.627 .483 .667 r
.72626 .66749 .67911 .67416 .68648 .71538 .7353 .70939 Metetra
.635 .487 .665 r
.7353 .70939 .68648 .71538 .69372 .75682 .74418 .75147 Metetra
.642 .49 .661 r
.74418 .75147 .69372 .75682 .70067 .79844 .75269 .79367 Metetra
.648 .491 .657 r
.75269 .79367 .70067 .79844 .70716 .84019 .76063 .83595 Metetra
.654 .491 .651 r
.76063 .83595 .70716 .84019 .71304 .88206 .76783 .87826 Metetra
.658 .489 .644 r
.76783 .87826 .71304 .88206 .71818 .92401 .77411 .9206 Metetra
.661 .486 .637 r
.77411 .9206 .71818 .92401 .72246 .96605 .77934 .96295 Metetra
.663 .482 .63 r
.77934 .96295 .72246 .96605 .72579 1.00819 .78341 1.00531 Metetra
.664 .477 .622 r
.78341 1.00531 .72579 1.00819 .72811 1.05044 .78624 1.04772 Metetra
.664 .471 .613 r
.78624 1.04772 .72811 1.05044 .72936 1.09283 .78778 1.0902 Metetra
.663 .464 .605 r
.78778 1.0902 .72936 1.09283 .72955 1.13539 .78801 1.13279 Metetra
.66 .456 .597 r
.78801 1.13279 .72955 1.13539 .72869 1.17817 .78696 1.17556 Metetra
.33 .182 .524 r
.69649 .18843 .67115 .20612 .66956 .24025 .69517 .22285 Metetra
.348 .209 .546 r
.69517 .22285 .66956 .24025 .66918 .27529 .69499 .25816 Metetra
.363 .234 .567 r
.69499 .25816 .66918 .27529 .67006 .31122 .696 .29435 Metetra
.376 .256 .587 r
.696 .29435 .67006 .31122 .67222 .34804 .69823 .33141 Metetra
.385 .274 .604 r
.69823 .33141 .67222 .34804 .67564 .38569 .70166 .3693 Metetra
.393 .29 .618 r
.70166 .3693 .67564 .38569 .68026 .42415 .70624 .40798 Metetra
.397 .303 .631 r
.70624 .40798 .68026 .42415 .686 .46333 .71188 .44738 Metetra
.399 .312 .641 r
.71188 .44738 .686 .46333 .69274 .50318 .71846 .48743 Metetra
.399 .319 .649 r
.71846 .48743 .69274 .50318 .70031 .5436 .72584 .52807 Metetra
.397 .322 .655 r
.72584 .52807 .70031 .5436 .70856 .58451 .73387 .56919 Metetra
.393 .323 .659 r
.73387 .56919 .70856 .58451 .71728 .62584 .74234 .61074 Metetra
.387 .32 .66 r
.74234 .61074 .71728 .62584 .72626 .66749 .75108 .65262 Metetra
.379 .315 .659 r
.75108 .65262 .72626 .66749 .7353 .70939 .75987 .69476 Metetra
.37 .307 .656 r
.75987 .69476 .7353 .70939 .74418 .75147 .76851 .7371 Metetra
.359 .296 .65 r
.76851 .7371 .74418 .75147 .75269 .79367 .7768 .77958 Metetra
.347 .283 .642 r
.7768 .77958 .75269 .79367 .76063 .83595 .78456 .82215 Metetra
.335 .267 .631 r
.78456 .82215 .76063 .83595 .76783 .87826 .7916 .86479 Metetra
.321 .25 .618 r
.7916 .86479 .76783 .87826 .77411 .9206 .79779 .90746 Metetra
.308 .23 .603 r
.79779 .90746 .77411 .9206 .77934 .96295 .80298 .95017 Metetra
.295 .21 .587 r
.80298 .95017 .77934 .96295 .78341 1.00531 .80706 .99292 Metetra
.283 .189 .569 r
.80706 .99292 .78341 1.00531 .78624 1.04772 .80997 1.03573 Metetra
.272 .169 .55 r
.80997 1.03573 .78624 1.04772 .78778 1.0902 .81165 1.07863 Metetra
.263 .149 .53 r
.81165 1.07863 .78778 1.0902 .78801 1.13279 .8121 1.12167 Metetra
.256 .132 .512 r
.8121 1.12167 .78801 1.13279 .78696 1.17556 .81132 1.1649 Metetra
0 0 .394 r
.71083 .16498 .69649 .18843 .69517 .22285 .71031 .20004 Metetra
.005 0 .434 r
.71031 .20004 .69517 .22285 .69499 .25816 .71059 .23584 Metetra
.042 0 .465 r
.71059 .23584 .69499 .25816 .696 .29435 .71172 .27237 Metetra
.063 .017 .488 r
.71172 .27237 .696 .29435 .69823 .33141 .71372 .30964 Metetra
.068 .032 .504 r
.71372 .30964 .69823 .33141 .70166 .3693 .71655 .3476 Metetra
.059 .035 .513 r
.71655 .3476 .70166 .3693 .70624 .40798 .7202 .38624 Metetra
.035 .027 .515 r
.7202 .38624 .70624 .40798 .71188 .44738 .72461 .42551 Metetra
0 .007 .51 r
.72461 .42551 .71188 .44738 .71846 .48743 .72969 .46536 Metetra
0 0 .497 r
.72969 .46536 .71846 .48743 .72584 .52807 .73534 .50574 Metetra
0 0 .474 r
.73534 .50574 .72584 .52807 .73387 .56919 .74146 .54659 Metetra
0 0 .439 r
.74146 .54659 .73387 .56919 .74234 .61074 .7479 .58786 Metetra
0 0 .392 r
.7479 .58786 .74234 .61074 .75108 .65262 .75454 .6295 Metetra
0 0 .333 r
.75454 .6295 .75108 .65262 .75987 .69476 .76122 .67145 Metetra
0 0 .265 r
.76122 .67145 .75987 .69476 .76851 .7371 .76781 .71366 Metetra
0 0 .192 r
.76781 .71366 .76851 .7371 .7768 .77958 .77417 .75609 Metetra
0 0 .119 r
.77417 .75609 .7768 .77958 .78456 .82215 .78015 .79873 Metetra
.745 .531 0 r
.78015 .79873 .78456 .82215 .7916 .86479 .78564 .84153 Metetra
.797 .578 .014 r
.78564 .84153 .7916 .86479 .79779 .90746 .79053 .88449 Metetra
.837 .615 .068 r
.79053 .88449 .79779 .90746 .80298 .95017 .79471 .92761 Metetra
.866 .645 .113 r
.79471 .92761 .80298 .95017 .80706 .99292 .79811 .97089 Metetra
.886 .669 .149 r
.79811 .97089 .80706 .99292 .80997 1.03573 .80067 1.01435 Metetra
.898 .688 .177 r
.80067 1.01435 .80997 1.03573 .81165 1.07863 .80237 1.05801 Metetra
.905 .702 .196 r
.80237 1.05801 .81165 1.07863 .8121 1.12167 .80319 1.1019 Metetra
.905 .712 .208 r
.80319 1.1019 .8121 1.12167 .81132 1.1649 .80314 1.14608 Metetra
0 0 .233 r
.7174 .13705 .71083 .16498 .71031 .20004 .71808 .17302 Metetra
0 0 .277 r
.71808 .17302 .71031 .20004 .71059 .23584 .71903 .20948 Metetra
0 0 .305 r
.71903 .20948 .71059 .23584 .71172 .27237 .72026 .24642 Metetra
0 0 .317 r
.72026 .24642 .71172 .27237 .71372 .30964 .72178 .28385 Metetra
0 0 .313 r
.72178 .28385 .71372 .30964 .71655 .3476 .72359 .32177 Metetra
0 0 .293 r
.72359 .32177 .71655 .3476 .7202 .38624 .72567 .36016 Metetra
0 0 .256 r
.72567 .36016 .7202 .38624 .72461 .42551 .72801 .39902 Metetra
0 0 .202 r
.72801 .39902 .72461 .42551 .72969 .46536 .73058 .43833 Metetra
0 0 .132 r
.73058 .43833 .72969 .46536 .73534 .50574 .73335 .47808 Metetra
0 0 .052 r
.73335 .47808 .73534 .50574 .74146 .54659 .73628 .51826 Metetra
.793 .595 .031 r
.73628 .51826 .74146 .54659 .7479 .58786 .73933 .55886 Metetra
.862 .644 .109 r
.73933 .55886 .7479 .58786 .75454 .6295 .74246 .59985 Metetra
.912 .678 .178 r
.74246 .59985 .75454 .6295 .76122 .67145 .74562 .64123 Metetra
.945 .702 .235 r
.74562 .64123 .76122 .67145 .76781 .71366 .74876 .68298 Metetra
.966 .716 .282 r
.74876 .68298 .76781 .71366 .77417 .75609 .75184 .7251 Metetra
.978 .725 .318 r
.75184 .7251 .77417 .75609 .78015 .79873 .7548 .76758 Metetra
.985 .731 .346 r
.7548 .76758 .78015 .79873 .78564 .84153 .75761 .81042 Metetra
.989 .734 .368 r
.75761 .81042 .78564 .84153 .79053 .88449 .76024 .85361 Metetra
.991 .736 .385 r
.76024 .85361 .79053 .88449 .79471 .92761 .76264 .89716 Metetra
.992 .738 .398 r
.76264 .89716 .79471 .92761 .79811 .97089 .76479 .94108 Metetra
.992 .74 .407 r
.76479 .94108 .79811 .97089 .80067 1.01435 .76668 .98537 Metetra
.993 .741 .413 r
.76668 .98537 .80067 1.01435 .80237 1.05801 .76829 1.03005 Metetra
.993 .744 .416 r
.76829 1.03005 .80237 1.05801 .80319 1.1019 .76961 1.07515 Metetra
.994 .746 .416 r
.76961 1.07515 .80319 1.1019 .80314 1.14608 .77066 1.12066 Metetra
0 0 .212 r
.72151 .10701 .7174 .13705 .71808 .17302 .72354 .14402 Metetra
0 0 .235 r
.72354 .14402 .71808 .17302 .71903 .20948 .72523 .18121 Metetra
0 0 .239 r
.72523 .18121 .71903 .20948 .72026 .24642 .72656 .21859 Metetra
0 0 .225 r
.72656 .21859 .72026 .24642 .72178 .28385 .72753 .25617 Metetra
0 0 .193 r
.72753 .25617 .72178 .28385 .72359 .32177 .72814 .29397 Metetra
0 0 .143 r
.72814 .29397 .72359 .32177 .72567 .36016 .7284 .33201 Metetra
0 0 .075 r
.7284 .33201 .72567 .36016 .72801 .39902 .72834 .37033 Metetra
.72834 .37033 .72801 .39902 .73058 .43833 .72799 .40894 Metetra
.793 .645 .089 r
.72799 .40894 .73058 .43833 .73335 .47808 .7274 .44788 Metetra
.867 .695 .169 r
.7274 .44788 .73335 .47808 .73628 .51826 .72662 .48719 Metetra
.92 .73 .239 r
.72662 .48719 .73628 .51826 .73933 .55886 .7257 .52689 Metetra
.956 .75 .296 r
.7257 .52689 .73933 .55886 .74246 .59985 .7247 .56703 Metetra
.977 .76 .34 r
.7247 .56703 .74246 .59985 .74562 .64123 .72369 .60764 Metetra
.988 .763 .373 r
.72369 .60764 .74562 .64123 .74876 .68298 .72273 .64875 Metetra
.993 .762 .397 r
.72273 .64875 .74876 .68298 .75184 .7251 .7219 .69039 Metetra
.995 .759 .415 r
.7219 .69039 .75184 .7251 .7548 .76758 .72125 .73259 Metetra
.995 .754 .427 r
.72125 .73259 .7548 .76758 .75761 .81042 .72084 .77536 Metetra
.994 .75 .435 r
.72084 .77536 .75761 .81042 .76024 .85361 .72074 .81873 Metetra
.993 .746 .441 r
.72074 .81873 .76024 .85361 .76264 .89716 .72098 .8627 Metetra
.991 .742 .443 r
.72098 .8627 .76264 .89716 .76479 .94108 .7216 .90729 Metetra
.99 .739 .443 r
.7216 .90729 .76479 .94108 .76668 .98537 .72264 .95251 Metetra
.99 .736 .442 r
.72264 .95251 .76668 .98537 .76829 1.03005 .7241 .99834 Metetra
.99 .734 .438 r
.7241 .99834 .76829 1.03005 .76961 1.07515 .72601 1.0448 Metetra
.99 .732 .432 r
.72601 1.0448 .76961 1.07515 .77066 1.12066 .72834 1.09186 Metetra
0 0 .355 r
.72937 .07784 .72151 .10701 .72354 .14402 .73262 .11581 Metetra
0 0 .349 r
.73262 .11581 .72354 .14402 .72523 .18121 .73499 .15369 Metetra
0 0 .328 r
.73499 .15369 .72523 .18121 .72656 .21859 .73643 .19149 Metetra
0 0 .294 r
.73643 .19149 .72656 .21859 .72753 .25617 .73694 .22923 Metetra
0 0 .245 r
.73694 .22923 .72753 .25617 .72814 .29397 .73651 .26695 Metetra
0 0 .181 r
.73651 .26695 .72814 .29397 .7284 .33201 .73519 .3047 Metetra
0 0 .102 r
.73519 .3047 .7284 .33201 .72834 .37033 .73303 .34253 Metetra
0 0 .014 r
.73303 .34253 .72834 .37033 .72799 .40894 .73012 .38052 Metetra
.72 .639 .079 r
.73012 .38052 .72799 .40894 .7274 .44788 .72656 .41873 Metetra
.809 .703 .165 r
.72656 .41873 .7274 .44788 .72662 .48719 .72247 .45724 Metetra
.877 .749 .24 r
.72247 .45724 .72662 .48719 .7257 .52689 .71801 .49614 Metetra
.925 .776 .299 r
.71801 .49614 .7257 .52689 .7247 .56703 .71331 .5355 Metetra
.956 .79 .343 r
.71331 .5355 .7247 .56703 .72369 .60764 .70856 .5754 Metetra
.976 .794 .375 r
.70856 .5754 .72369 .60764 .72273 .64875 .7039 .6159 Metetra
.987 .792 .396 r
.7039 .6159 .72273 .64875 .7219 .69039 .69952 .65709 Metetra
.992 .787 .41 r
.69952 .65709 .7219 .69039 .72125 .73259 .69559 .69902 Metetra
.995 .781 .418 r
.69559 .69902 .72125 .73259 .72084 .77536 .69225 .74172 Metetra
.996 .773 .421 r
.69225 .74172 .72084 .77536 .72074 .81873 .68965 .78525 Metetra
.996 .765 .42 r
.68965 .78525 .72074 .81873 .72098 .8627 .68791 .82963 Metetra
.995 .757 .417 r
.68791 .82963 .72098 .8627 .7216 .90729 .68714 .87486 Metetra
.994 .75 .41 r
.68714 .87486 .7216 .90729 .72264 .95251 .68741 .92095 Metetra
.993 .742 .401 r
.68741 .92095 .72264 .95251 .7241 .99834 .68877 .96788 Metetra
.991 .735 .389 r
.68877 .96788 .7241 .99834 .72601 1.0448 .69122 1.01564 Metetra
.989 .728 .374 r
.69122 1.01564 .72601 1.0448 .72834 1.09186 .69477 1.06418 Metetra
.106 .071 .531 r
.74662 .05242 .72937 .07784 .73262 .11581 .75069 .09109 Metetra
.102 .052 .509 r
.75069 .09109 .73262 .11581 .73499 .15369 .75353 .1295 Metetra
.086 .023 .482 r
.75353 .1295 .73499 .15369 .73643 .19149 .75511 .16766 Metetra
.058 0 .449 r
.75511 .16766 .73643 .19149 .73694 .22923 .75541 .2056 Metetra
.018 0 .409 r
.75541 .2056 .73694 .22923 .73651 .26695 .75442 .24337 Metetra
0 0 .362 r
.75442 .24337 .73651 .26695 .73519 .3047 .75221 .28103 Metetra
0 0 .307 r
.75221 .28103 .73519 .3047 .73303 .34253 .74885 .31866 Metetra
0 0 .246 r
.74885 .31866 .73303 .34253 .73012 .38052 .74446 .35634 Metetra
0 0 .179 r
.74446 .35634 .73012 .38052 .72656 .41873 .73916 .39419 Metetra
0 0 .109 r
.73916 .39419 .72656 .41873 .72247 .45724 .73314 .4323 Metetra
0 0 .039 r
.73314 .4323 .72247 .45724 .71801 .49614 .72657 .47078 Metetra
.72657 .47078 .71801 .49614 .71331 .5355 .71968 .50974 Metetra
.71968 .50974 .71331 .5355 .70856 .5754 .71269 .54928 Metetra
.706 .672 .126 r
.71269 .54928 .70856 .5754 .7039 .6159 .70583 .58951 Metetra
.759 .7 .159 r
.70583 .58951 .7039 .6159 .69952 .65709 .69933 .63051 Metetra
.8 .716 .181 r
.69933 .63051 .69952 .65709 .69559 .69902 .69342 .67237 Metetra
.829 .722 .193 r
.69342 .67237 .69559 .69902 .69225 .74172 .68833 .71515 Metetra
.848 .72 .195 r
.68833 .71515 .69225 .74172 .68965 .78525 .68425 .7589 Metetra
.86 .713 .188 r
.68425 .7589 .68965 .78525 .68791 .82963 .68135 .80366 Metetra
.865 .7 .174 r
.68135 .80366 .68791 .82963 .68714 .87486 .67979 .84943 Metetra
.863 .683 .153 r
.67979 .84943 .68714 .87486 .68741 .92095 .67966 .89622 Metetra
.855 .662 .126 r
.67966 .89622 .68741 .92095 .68877 .96788 .68103 .944 Metetra
.841 .637 .093 r
.68103 .944 .68877 .96788 .69122 1.01564 .68392 .99275 Metetra
.821 .607 .053 r
.68392 .99275 .69122 1.01564 .69477 1.06418 .68831 1.0424 Metetra
0 g
.25 Mabswid
1 1.12261 m
.31079 1.31272 L
s
.31079 1.31272 m
0 1.25809 L
s
0 1.25809 m
.66806 1.03719 L
s
.66806 1.03719 m
1 1.12261 L
s
.93822 .14902 m
.64267 0 L
s
.64267 0 m
.66806 1.03719 L
s
.66806 1.03719 m
1 1.12261 L
s
1 1.12261 m
.93822 .14902 L
s
.93822 .14902 m
1 1.12261 L
s
.93822 .14902 m
.93046 .15335 L
s
[(-2)] .95373 .14035 -1 .55896 Mshowa
.95229 .37079 m
.94432 .37473 L
s
[(-1)] .96823 .36293 -1 .4936 Mshowa
.96722 .6061 m
.95905 .60958 L
s
[(0)] .98358 .59915 -1 .42481 Mshowa
.9831 .85622 m
.97472 .85918 L
s
[(1)] .99986 .85032 -1 .35233 Mshowa
1 1.12261 m
.99143 1.12497 L
s
[(2)] 1.01713 1.11788 -1 .27585 Mshowa
.125 Mabswid
.94097 .19235 m
.93629 .1949 L
s
.94375 .23618 m
.93904 .23869 L
s
.94656 .28053 m
.94183 .28299 L
s
.94941 .32539 m
.94465 .3278 L
s
.95521 .41673 m
.9504 .41904 L
s
.95816 .46322 m
.95332 .46548 L
s
.96114 .51028 m
.95629 .51247 L
s
.96416 .5579 m
.95928 .56004 L
s
.97032 .6549 m
.96539 .65692 L
s
.97345 .7043 m
.9685 .70626 L
s
.97663 .75431 m
.97165 .75621 L
s
.97984 .80495 m
.97484 .80679 L
s
.98639 .90815 m
.98134 .90985 L
s
.98973 .96074 m
.98465 .96237 L
s
.99311 1.014 m
.98801 1.01557 L
s
.99653 1.06795 m
.99141 1.06945 L
s
gsave
1.06536 .56441 -61 -10.9905 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  "When you set the options ",
  StyleBox["ViewPoint", "MR"],
  ", ",
  StyleBox["ViewCenter", "MR"],
  " and ",
  StyleBox["ViewVertical", "MR"],
  ", you can think about it as specifying how you would look at a physical \
object. ",
  StyleBox["ViewPoint", "MR"],
  " specifies where your head is relative to the object. ",
  StyleBox["ViewCenter", "MR"],
  " specifies where you are looking (the center of your gaze). And ",
  StyleBox["ViewVertical", "MR"],
  " specifies which way up your head is. "
}], "Text",
  CellTags->{"S2.10.10", "10.23"}],

Cell[TextData[{
  "In terms of coordinate systems, settings for ",
  StyleBox["ViewPoint", "MR"],
  ", ",
  StyleBox["ViewCenter", "MR"],
  " and ",
  StyleBox["ViewVertical", "MR"],
  " specify how coordinates in the three\[Hyphen]dimensional box should be \
transformed into coordinates for your image in the final display area. "
}], "Text",
  CellTags->{"S2.10.10", "10.24"}],

Cell[TextData[{
  "For some purposes, it is useful to think of the coordinates in the final \
display area as three dimensional. The ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          "TI"], TraditionalForm]], "InlineFormula"],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axes run horizontally and vertically, respectively, while the ",
  Cell[BoxData[
      FormBox[
        StyleBox["z",
          "TI"], TraditionalForm]], "InlineFormula"],
  " axis points out of the page. Positions specified in this \
\[OpenCurlyDoubleQuote]display coordinate system\[CloseCurlyDoubleQuote] \
remain fixed when you change ",
  StyleBox["ViewPoint", "MR"],
  " and so on. The positions of light sources discussed in the next section \
are defined in this display coordinate system. "
}], "Text",
  CellTags->{"S2.10.10", "10.25"}],

Cell[BoxData[
    FormBox[GridBox[{
          {Cell["Box coordinate system "], Cell[
            "measured relative to the box around your object "]},
          {Cell["Display coordinate system "], Cell[
            "measured relative to your final display area "]}
          },
        ColumnAlignments->{Right, Left}], TraditionalForm]], "DefinitionBox",
  GridBoxOptions->{RowSpacings->0.4,
  RowLines->False},
  CellTags->"S2.10.10"],

Cell["\<\
Coordinate systems for three\[Hyphen]dimensional graphics. \
\>", \
"Caption",
  CellTags->"S2.10.10"],

Cell[TextData[{
  "Once you have obtained a two\[Hyphen]dimensional image of a \
three\[Hyphen]dimensional object, there are still some issues about how this \
image should be rendered. The issues however are identical to those that \
occur for two\[Hyphen]dimensional graphics. Thus, for example, you can modify \
the final shape of your image by changing the ",
  StyleBox["AspectRatio", "MR"],
  " option. And you specify what region of your whole display area your image \
should take up by setting the ",
  StyleBox["PlotRegion", "MR"],
  " option. "
}], "Text",
  CellTags->{"S2.10.10", "10.26"}],

Cell["This modifies the aspect ratio of the final image. ", "MathCaption",
  CellTags->{"S2.10.10", "10.27"}],

Cell[CellGroupData[{

Cell["Show[surf, Axes -> False, AspectRatio -> 0.3]", "Input",
  CellLabel->"In[12]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.78351e-17 1.04977 -0.0251347 0.388261 [
[ 0 0 0 0 ]
[ 1 .3 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .09436 m
0 .18109 L
s
0 .18109 m
.39787 .3 L
s
.39787 .3 m
.40529 .22152 L
s
.40529 .22152 m
.03716 .09436 L
s
.68874 0 m
.96935 .15875 L
s
.96935 .15875 m
1 .2417 L
s
1 .2417 m
.70298 .09078 L
s
.70298 .09078 m
.68874 0 L
s
.03716 .09436 m
0 .18109 L
s
0 .18109 m
.70298 .09078 L
s
.70298 .09078 m
.68874 0 L
s
.68874 0 m
.03716 .09436 L
s
.40529 .22152 m
.96935 .15875 L
s
.96935 .15875 m
1 .2417 L
s
1 .2417 m
.39787 .3 L
s
.39787 .3 m
.40529 .22152 L
s
0 0 m
1 0 L
1 .3 L
0 .3 L
closepath
clip
newpath
.5 Mabswid
.665 .642 .818 r
.38753 .26493 .40046 .27263 .42271 .26968 .40983 .26212 Metetra
.659 .644 .824 r
.40983 .26212 .42271 .26968 .44511 .26703 .43229 .25952 Metetra
.651 .643 .829 r
.43229 .25952 .44511 .26703 .46767 .2647 .45491 .25716 Metetra
.643 .64 .832 r
.45491 .25716 .46767 .2647 .4904 .2627 .47771 .25503 Metetra
.635 .635 .833 r
.47771 .25503 .4904 .2627 .51334 .26101 .50071 .25312 Metetra
.627 .627 .831 r
.50071 .25312 .51334 .26101 .53649 .25962 .52392 .25143 Metetra
.62 .618 .827 r
.52392 .25143 .53649 .25962 .55988 .25851 .54735 .24994 Metetra
.614 .608 .821 r
.54735 .24994 .55988 .25851 .58353 .25765 .57103 .24863 Metetra
.609 .597 .814 r
.57103 .24863 .58353 .25765 .60746 .25699 .59496 .24746 Metetra
.605 .586 .805 r
.59496 .24746 .60746 .25699 .63166 .25649 .61916 .2464 Metetra
.603 .576 .796 r
.61916 .2464 .63166 .25649 .65616 .25611 .64363 .24542 Metetra
.602 .567 .787 r
.64363 .24542 .65616 .25611 .68097 .25578 .66837 .24446 Metetra
.602 .558 .778 r
.66837 .24446 .68097 .25578 .70607 .25544 .6934 .2435 Metetra
.603 .551 .769 r
.6934 .2435 .70607 .25544 .73146 .25504 .7187 .24249 Metetra
.604 .545 .761 r
.7187 .24249 .73146 .25504 .75714 .25452 .74427 .24137 Metetra
.606 .54 .754 r
.74427 .24137 .75714 .25452 .7831 .25382 .7701 .24011 Metetra
.609 .537 .748 r
.7701 .24011 .7831 .25382 .80932 .25288 .79619 .23868 Metetra
.612 .535 .743 r
.79619 .23868 .80932 .25288 .83577 .25166 .82251 .23703 Metetra
.616 .533 .738 r
.82251 .23703 .83577 .25166 .86243 .25012 .84906 .23514 Metetra
.62 .533 .735 r
.84906 .23514 .86243 .25012 .88929 .24821 .87581 .23297 Metetra
.624 .534 .732 r
.87581 .23297 .88929 .24821 .91631 .24593 .90275 .23053 Metetra
.628 .536 .731 r
.90275 .23053 .91631 .24593 .94348 .24325 .92987 .22779 Metetra
.632 .538 .73 r
.92987 .22779 .94348 .24325 .97077 .24018 .95714 .22475 Metetra
.637 .542 .73 r
.95714 .22475 .97077 .24018 .99816 .23672 .98456 .22142 Metetra
.646 .588 .776 r
.37474 .25475 .38753 .26493 .40983 .26212 .39704 .25219 Metetra
.645 .593 .781 r
.39704 .25219 .40983 .26212 .43229 .25952 .41951 .24971 Metetra
.643 .594 .785 r
.41951 .24971 .43229 .25952 .45491 .25716 .44215 .24731 Metetra
.64 .593 .786 r
.44215 .24731 .45491 .25716 .47771 .25503 .46499 .24498 Metetra
.637 .59 .784 r
.46499 .24498 .47771 .25503 .50071 .25312 .48801 .24274 Metetra
.634 .584 .78 r
.48801 .24274 .50071 .25312 .52392 .25143 .51124 .24057 Metetra
.631 .575 .774 r
.51124 .24057 .52392 .25143 .54735 .24994 .53468 .23846 Metetra
.628 .566 .766 r
.53468 .23846 .54735 .24994 .57103 .24863 .55833 .23641 Metetra
.624 .556 .757 r
.55833 .23641 .57103 .24863 .59496 .24746 .58221 .23441 Metetra
.621 .546 .748 r
.58221 .23441 .59496 .24746 .61916 .2464 .60632 .23244 Metetra
.619 .535 .738 r
.60632 .23244 .61916 .2464 .64363 .24542 .63066 .23048 Metetra
.617 .526 .729 r
.63066 .23048 .64363 .24542 .66837 .24446 .65524 .22851 Metetra
.615 .518 .72 r
.65524 .22851 .66837 .24446 .6934 .2435 .68006 .22653 Metetra
.614 .51 .713 r
.68006 .22653 .6934 .2435 .7187 .24249 .70512 .22452 Metetra
.612 .504 .706 r
.70512 .22452 .7187 .24249 .74427 .24137 .73042 .22244 Metetra
.612 .498 .7 r
.73042 .22244 .74427 .24137 .7701 .24011 .75596 .2203 Metetra
.611 .494 .695 r
.75596 .2203 .7701 .24011 .79619 .23868 .78174 .21807 Metetra
.611 .49 .69 r
.78174 .21807 .79619 .23868 .82251 .23703 .80775 .21575 Metetra
.612 .488 .687 r
.80775 .21575 .82251 .23703 .84906 .23514 .83399 .21331 Metetra
.612 .486 .684 r
.83399 .21331 .84906 .23514 .87581 .23297 .86046 .21075 Metetra
.613 .485 .683 r
.86046 .21075 .87581 .23297 .90275 .23053 .88714 .20806 Metetra
.614 .485 .682 r
.88714 .20806 .90275 .23053 .92987 .22779 .91405 .20524 Metetra
.615 .486 .682 r
.91405 .20524 .92987 .22779 .95714 .22475 .94116 .20229 Metetra
.617 .488 .682 r
.94116 .20229 .95714 .22475 .98456 .22142 .96849 .19922 Metetra
.634 .569 .764 r
.362 .24354 .37474 .25475 .39704 .25219 .38426 .24129 Metetra
.637 .575 .768 r
.38426 .24129 .39704 .25219 .41951 .24971 .40672 .23894 Metetra
.639 .579 .771 r
.40672 .23894 .41951 .24971 .44215 .24731 .42938 .2365 Metetra
.641 .58 .771 r
.42938 .2365 .44215 .24731 .46499 .24498 .45223 .23396 Metetra
.642 .578 .768 r
.45223 .23396 .46499 .24498 .48801 .24274 .47528 .23133 Metetra
.642 .574 .763 r
.47528 .23133 .48801 .24274 .51124 .24057 .49851 .22861 Metetra
.642 .567 .756 r
.49851 .22861 .51124 .24057 .53468 .23846 .52194 .22581 Metetra
.64 .559 .747 r
.52194 .22581 .53468 .23846 .55833 .23641 .54557 .22292 Metetra
.639 .55 .738 r
.54557 .22292 .55833 .23641 .58221 .23441 .56938 .21997 Metetra
.636 .54 .729 r
.56938 .21997 .58221 .23441 .60632 .23244 .59338 .21695 Metetra
.634 .531 .72 r
.59338 .21695 .60632 .23244 .63066 .23048 .61757 .21389 Metetra
.631 .522 .711 r
.61757 .21389 .63066 .23048 .65524 .22851 .64195 .21079 Metetra
.628 .513 .704 r
.64195 .21079 .65524 .22851 .68006 .22653 .66654 .20766 Metetra
.625 .505 .696 r
.66654 .20766 .68006 .22653 .70512 .22452 .69132 .20453 Metetra
.622 .498 .69 r
.69132 .20453 .70512 .22452 .73042 .22244 .7163 .20139 Metetra
.62 .492 .685 r
.7163 .20139 .73042 .22244 .75596 .2203 .7415 .19826 Metetra
.618 .486 .68 r
.7415 .19826 .75596 .2203 .78174 .21807 .76692 .19515 Metetra
.615 .482 .676 r
.76692 .19515 .78174 .21807 .80775 .21575 .79256 .19208 Metetra
.614 .478 .673 r
.79256 .19208 .80775 .21575 .83399 .21331 .81844 .18904 Metetra
.612 .475 .671 r
.81844 .18904 .83399 .21331 .86046 .21075 .84456 .18604 Metetra
.611 .473 .67 r
.84456 .18604 .86046 .21075 .88714 .20806 .87093 .1831 Metetra
.61 .472 .669 r
.87093 .1831 .88714 .20806 .91405 .20524 .89756 .1802 Metetra
.609 .472 .669 r
.89756 .1802 .91405 .20524 .94116 .20229 .92446 .17735 Metetra
.608 .472 .67 r
.92446 .17735 .94116 .20229 .96849 .19922 .95164 .17455 Metetra
.628 .576 .776 r
.3491 .23299 .362 .24354 .38426 .24129 .37133 .231 Metetra
.635 .584 .78 r
.37133 .231 .38426 .24129 .40672 .23894 .39379 .22877 Metetra
.641 .59 .781 r
.39379 .22877 .40672 .23894 .42938 .2365 .41647 .22628 Metetra
.647 .593 .78 r
.41647 .22628 .42938 .2365 .45223 .23396 .43936 .22355 Metetra
.652 .593 .776 r
.43936 .22355 .45223 .23396 .47528 .23133 .46244 .22058 Metetra
.655 .59 .77 r
.46244 .22058 .47528 .23133 .49851 .22861 .48571 .21736 Metetra
.657 .585 .763 r
.48571 .21736 .49851 .22861 .52194 .22581 .50916 .21393 Metetra
.658 .578 .754 r
.50916 .21393 .52194 .22581 .54557 .22292 .53278 .21031 Metetra
.657 .57 .745 r
.53278 .21031 .54557 .22292 .56938 .21997 .55656 .20651 Metetra
.655 .561 .736 r
.55656 .20651 .56938 .21997 .59338 .21695 .5805 .20258 Metetra
.653 .551 .727 r
.5805 .20258 .59338 .21695 .61757 .21389 .60459 .19855 Metetra
.65 .542 .719 r
.60459 .19855 .61757 .21389 .64195 .21079 .62884 .19445 Metetra
.646 .533 .711 r
.62884 .19445 .64195 .21079 .66654 .20766 .65324 .19033 Metetra
.642 .524 .704 r
.65324 .19033 .66654 .20766 .69132 .20453 .67781 .18621 Metetra
.638 .516 .698 r
.67781 .18621 .69132 .20453 .7163 .20139 .70255 .18215 Metetra
.634 .509 .693 r
.70255 .18215 .7163 .20139 .7415 .19826 .72748 .17817 Metetra
.63 .502 .688 r
.72748 .17817 .7415 .19826 .76692 .19515 .75261 .1743 Metetra
.626 .496 .685 r
.75261 .1743 .76692 .19515 .79256 .19208 .77796 .17058 Metetra
.622 .491 .682 r
.77796 .17058 .79256 .19208 .81844 .18904 .80354 .16702 Metetra
.619 .487 .68 r
.80354 .16702 .81844 .18904 .84456 .18604 .82938 .16365 Metetra
.616 .484 .679 r
.82938 .16365 .84456 .18604 .87093 .1831 .85549 .16048 Metetra
.613 .482 .678 r
.85549 .16048 .87093 .1831 .89756 .1802 .8819 .15751 Metetra
.61 .48 .679 r
.8819 .15751 .89756 .1802 .92446 .17735 .90863 .15474 Metetra
.607 .479 .68 r
.90863 .15474 .92446 .17735 .95164 .17455 .93569 .15217 Metetra
.628 .616 .819 r
.3358 .22456 .3491 .23299 .37133 .231 .35805 .22272 Metetra
.639 .626 .821 r
.35805 .22272 .37133 .231 .39379 .22877 .38055 .22055 Metetra
.649 .632 .82 r
.38055 .22055 .39379 .22877 .41647 .22628 .40328 .21802 Metetra
.659 .636 .816 r
.40328 .21802 .41647 .22628 .43936 .22355 .42623 .21515 Metetra
.667 .638 .811 r
.42623 .21515 .43936 .22355 .46244 .22058 .44939 .21194 Metetra
.674 .637 .805 r
.44939 .21194 .46244 .22058 .48571 .21736 .47274 .2084 Metetra
.679 .633 .797 r
.47274 .2084 .48571 .21736 .50916 .21393 .49626 .20456 Metetra
.682 .628 .789 r
.49626 .20456 .50916 .21393 .53278 .21031 .51994 .20045 Metetra
.683 .621 .78 r
.51994 .20045 .53278 .21031 .55656 .20651 .54376 .1961 Metetra
.683 .613 .771 r
.54376 .1961 .55656 .20651 .5805 .20258 .56772 .19158 Metetra
.681 .604 .763 r
.56772 .19158 .5805 .20258 .60459 .19855 .59182 .18692 Metetra
.679 .595 .755 r
.59182 .18692 .60459 .19855 .62884 .19445 .61605 .18218 Metetra
.675 .586 .748 r
.61605 .18218 .62884 .19445 .65324 .19033 .64041 .17741 Metetra
.671 .577 .741 r
.64041 .17741 .65324 .19033 .67781 .18621 .66491 .17268 Metetra
.666 .568 .736 r
.66491 .17268 .67781 .18621 .70255 .18215 .68957 .16802 Metetra
.66 .56 .731 r
.68957 .16802 .70255 .18215 .72748 .17817 .7144 .16349 Metetra
.655 .552 .727 r
.7144 .16349 .72748 .17817 .75261 .1743 .73941 .15914 Metetra
.649 .545 .724 r
.73941 .15914 .75261 .1743 .77796 .17058 .76464 .15499 Metetra
.643 .539 .721 r
.76464 .15499 .77796 .17058 .80354 .16702 .7901 .1511 Metetra
.637 .533 .72 r
.7901 .1511 .80354 .16702 .82938 .16365 .81583 .14748 Metetra
.631 .528 .719 r
.81583 .14748 .82938 .16365 .85549 .16048 .84184 .14414 Metetra
.626 .524 .719 r
.84184 .14414 .85549 .16048 .8819 .15751 .86818 .14111 Metetra
.62 .521 .72 r
.86818 .14111 .8819 .15751 .90863 .15474 .89485 .13837 Metetra
.615 .519 .722 r
.89485 .13837 .90863 .15474 .93569 .15217 .92189 .13593 Metetra
.627 .709 .905 r
.32187 .21919 .3358 .22456 .35805 .22272 .34421 .21734 Metetra
.643 .716 .901 r
.34421 .21734 .35805 .22272 .38055 .22055 .36681 .21515 Metetra
.658 .721 .895 r
.36681 .21515 .38055 .22055 .40328 .21802 .38965 .21259 Metetra
.672 .725 .889 r
.38965 .21259 .40328 .21802 .42623 .21515 .41272 .20966 Metetra
.684 .728 .883 r
.41272 .20966 .42623 .21515 .44939 .21194 .436 .20636 Metetra
.695 .729 .877 r
.436 .20636 .44939 .21194 .47274 .2084 .45947 .20272 Metetra
.705 .73 .87 r
.45947 .20272 .47274 .2084 .49626 .20456 .48312 .19876 Metetra
.712 .73 .864 r
.48312 .19876 .49626 .20456 .51994 .20045 .50693 .19452 Metetra
.718 .729 .859 r
.50693 .19452 .51994 .20045 .54376 .1961 .53089 .19003 Metetra
.722 .727 .854 r
.53089 .19003 .54376 .1961 .56772 .19158 .55499 .18536 Metetra
.724 .724 .85 r
.55499 .18536 .56772 .19158 .59182 .18692 .57921 .18054 Metetra
.724 .721 .847 r
.57921 .18054 .59182 .18692 .61605 .18218 .60357 .17563 Metetra
.723 .717 .844 r
.60357 .17563 .61605 .18218 .64041 .17741 .62806 .1707 Metetra
.721 .713 .842 r
.62806 .1707 .64041 .17741 .66491 .17268 .65269 .1658 Metetra
.717 .708 .841 r
.65269 .1658 .66491 .17268 .68957 .16802 .67747 .16099 Metetra
.711 .704 .841 r
.67747 .16099 .68957 .16802 .7144 .16349 .70241 .15631 Metetra
.705 .699 .841 r
.70241 .15631 .7144 .16349 .73941 .15914 .72754 .15183 Metetra
.697 .693 .843 r
.72754 .15183 .73941 .15914 .76464 .15499 .75289 .14756 Metetra
.688 .688 .844 r
.75289 .14756 .76464 .15499 .7901 .1511 .77846 .14356 Metetra
.679 .682 .846 r
.77846 .14356 .7901 .1511 .81583 .14748 .80431 .13985 Metetra
.669 .677 .849 r
.80431 .13985 .81583 .14748 .84184 .14414 .83044 .13644 Metetra
.658 .672 .852 r
.83044 .13644 .84184 .14414 .86818 .14111 .8569 .13335 Metetra
.647 .667 .855 r
.8569 .13335 .86818 .14111 .89485 .13837 .8837 .13058 Metetra
.636 .662 .858 r
.8837 .13058 .89485 .13837 .92189 .13593 .91088 .12812 Metetra
.569 .848 .997 r
.30716 .21707 .32187 .21919 .34421 .21734 .32967 .21507 Metetra
.6 .851 .992 r
.32967 .21507 .34421 .21734 .36681 .21515 .35244 .21277 Metetra
.625 .854 .986 r
.35244 .21277 .36681 .21515 .38965 .21259 .37544 .21016 Metetra
.646 .858 .98 r
.37544 .21016 .38965 .21259 .41272 .20966 .39868 .20726 Metetra
.663 .865 .976 r
.39868 .20726 .41272 .20966 .436 .20636 .42213 .20405 Metetra
.677 .873 .973 r
.42213 .20405 .436 .20636 .45947 .20272 .44578 .20055 Metetra
.688 .884 .971 r
.44578 .20055 .45947 .20272 .48312 .19876 .46961 .19679 Metetra
.695 .897 .97 r
.46961 .19679 .48312 .19876 .50693 .19452 .49363 .19279 Metetra
.699 .911 .969 r
.49363 .19279 .50693 .19452 .53089 .19003 .51781 .18859 Metetra
.697 .925 .967 r
.51781 .18859 .53089 .19003 .55499 .18536 .54214 .18422 Metetra
.69 .939 .964 r
.54214 .18422 .55499 .18536 .57921 .18054 .56662 .17973 Metetra
.674 .949 .957 r
.56662 .17973 .57921 .18054 .60357 .17563 .59126 .17517 Metetra
.649 .954 .943 r
.59126 .17517 .60357 .17563 .62806 .1707 .61604 .17058 Metetra
.613 .951 .922 r
.61604 .17058 .62806 .1707 .65269 .1658 .64098 .16601 Metetra
.566 .937 .892 r
.64098 .16601 .65269 .1658 .67747 .16099 .66609 .1615 Metetra
.51 .913 .854 r
.66609 .1615 .67747 .16099 .70241 .15631 .69138 .1571 Metetra
.446 .878 .808 r
.69138 .1571 .70241 .15631 .72754 .15183 .71687 .15284 Metetra
.379 .836 .759 r
.71687 .15284 .72754 .15183 .75289 .14756 .74257 .14877 Metetra
.314 .792 .711 r
.74257 .14877 .75289 .14756 .77846 .14356 .76851 .14491 Metetra
.254 .748 .668 r
.76851 .14491 .77846 .14356 .80431 .13985 .79472 .14127 Metetra
.79472 .14127 .80431 .13985 .83044 .13644 .82121 .13788 Metetra
.82121 .13788 .83044 .13644 .8569 .13335 .84801 .13475 Metetra
.84801 .13475 .8569 .13335 .8837 .13058 .87514 .13187 Metetra
.87514 .13187 .8837 .13058 .91088 .12812 .90264 .12924 Metetra
.34 .82 .846 r
.29165 .21765 .30716 .21707 .32967 .21507 .31441 .21535 Metetra
.401 .854 .889 r
.31441 .21535 .32967 .21507 .35244 .21277 .3374 .21287 Metetra
.442 .874 .912 r
.3374 .21287 .35244 .21277 .37544 .21016 .36062 .21023 Metetra
.464 .885 .918 r
.36062 .21023 .37544 .21016 .39868 .20726 .38406 .20742 Metetra
.47 .889 .911 r
.38406 .20742 .39868 .20726 .42213 .20405 .40771 .20443 Metetra
.457 .885 .89 r
.40771 .20443 .42213 .20405 .44578 .20055 .43158 .20128 Metetra
.425 .87 .851 r
.43158 .20128 .44578 .20055 .46961 .19679 .45564 .19798 Metetra
.371 .836 .789 r
.45564 .19798 .46961 .19679 .49363 .19279 .47991 .19454 Metetra
.296 .779 .699 r
.47991 .19454 .49363 .19279 .51781 .18859 .50436 .19098 Metetra
.50436 .19098 .51781 .18859 .54214 .18422 .52901 .18733 Metetra
.52901 .18733 .54214 .18422 .56662 .17973 .55384 .18359 Metetra
.55384 .18359 .56662 .17973 .59126 .17517 .57886 .1798 Metetra
.074 0 0 r
.57886 .1798 .59126 .17517 .61604 .17058 .60408 .17598 Metetra
.143 0 0 r
.60408 .17598 .61604 .17058 .64098 .16601 .62948 .17216 Metetra
.2 0 0 r
.62948 .17216 .64098 .16601 .66609 .1615 .65509 .16836 Metetra
.244 0 .013 r
.65509 .16836 .66609 .1615 .69138 .1571 .68091 .1646 Metetra
.28 0 .061 r
.68091 .1646 .69138 .1571 .71687 .15284 .70695 .16091 Metetra
.307 0 .098 r
.70695 .16091 .71687 .15284 .74257 .14877 .73322 .15729 Metetra
.329 0 .126 r
.73322 .15729 .74257 .14877 .76851 .14491 .75974 .15378 Metetra
.346 0 .146 r
.75974 .15378 .76851 .14491 .79472 .14127 .78651 .15037 Metetra
.358 0 .159 r
.78651 .15037 .79472 .14127 .82121 .13788 .81356 .14708 Metetra
.367 0 .166 r
.81356 .14708 .82121 .13788 .84801 .13475 .8409 .14391 Metetra
.372 0 .168 r
.8409 .14391 .84801 .13475 .87514 .13187 .86855 .14087 Metetra
.375 0 .164 r
.86855 .14087 .87514 .13187 .90264 .12924 .89651 .13794 Metetra
.27547 .2197 .29165 .21765 .31441 .21535 .29853 .21701 Metetra
.237 .745 .705 r
.29853 .21701 .31441 .21535 .3374 .21287 .32179 .21432 Metetra
.26 .764 .734 r
.32179 .21432 .3374 .21287 .36062 .21023 .34525 .21164 Metetra
.258 .762 .734 r
.34525 .21164 .36062 .21023 .38406 .20742 .36891 .20895 Metetra
.23 .741 .705 r
.36891 .20895 .38406 .20742 .40771 .20443 .39278 .20627 Metetra
.39278 .20627 .40771 .20443 .43158 .20128 .41687 .20359 Metetra
.41687 .20359 .43158 .20128 .45564 .19798 .44118 .2009 Metetra
.44118 .2009 .45564 .19798 .47991 .19454 .46571 .19821 Metetra
.069 0 0 r
.46571 .19821 .47991 .19454 .50436 .19098 .49047 .19551 Metetra
.15 0 0 r
.49047 .19551 .50436 .19098 .52901 .18733 .51546 .1928 Metetra
.217 0 0 r
.51546 .1928 .52901 .18733 .55384 .18359 .54068 .19007 Metetra
.271 0 0 r
.54068 .19007 .55384 .18359 .57886 .1798 .56614 .18732 Metetra
.313 0 .06 r
.56614 .18732 .57886 .1798 .60408 .17598 .59185 .18454 Metetra
.345 0 .117 r
.59185 .18454 .60408 .17598 .62948 .17216 .6178 .18173 Metetra
.369 0 .161 r
.6178 .18173 .62948 .17216 .65509 .16836 .644 .17889 Metetra
.387 .01 .196 r
.644 .17889 .65509 .16836 .68091 .1646 .67046 .176 Metetra
.401 .034 .223 r
.67046 .176 .68091 .1646 .70695 .16091 .69716 .17307 Metetra
.411 .053 .243 r
.69716 .17307 .70695 .16091 .73322 .15729 .72412 .1701 Metetra
.419 .067 .258 r
.72412 .1701 .73322 .15729 .75974 .15378 .75134 .16707 Metetra
.424 .076 .269 r
.75134 .16707 .75974 .15378 .78651 .15037 .77882 .16398 Metetra
.427 .082 .276 r
.77882 .16398 .78651 .15037 .81356 .14708 .80656 .16085 Metetra
.428 .084 .279 r
.80656 .16085 .81356 .14708 .8409 .14391 .83457 .15765 Metetra
.427 .083 .278 r
.83457 .15765 .8409 .14391 .86855 .14087 .86283 .1544 Metetra
.424 .079 .274 r
.86283 .1544 .86855 .14087 .89651 .13794 .89137 .15108 Metetra
.285 .776 .721 r
.2589 .22155 .27547 .2197 .29853 .21701 .28226 .21848 Metetra
.302 .792 .759 r
.28226 .21848 .29853 .21701 .32179 .21432 .30579 .21558 Metetra
.295 .79 .771 r
.30579 .21558 .32179 .21432 .34525 .21164 .32949 .21285 Metetra
.265 .77 .757 r
.32949 .21285 .34525 .21164 .36891 .20895 .35338 .21029 Metetra
.211 .73 .716 r
.35338 .21029 .36891 .20895 .39278 .20627 .37747 .20791 Metetra
.37747 .20791 .39278 .20627 .41687 .20359 .40177 .20569 Metetra
.40177 .20569 .41687 .20359 .44118 .2009 .4263 .20362 Metetra
.051 0 0 r
.4263 .20362 .44118 .2009 .46571 .19821 .45108 .20167 Metetra
.141 0 0 r
.45108 .20167 .46571 .19821 .49047 .19551 .47612 .19983 Metetra
.218 0 0 r
.47612 .19983 .49047 .19551 .51546 .1928 .50144 .19806 Metetra
.278 0 0 r
.50144 .19806 .51546 .1928 .54068 .19007 .52703 .19635 Metetra
.324 0 0 r
.52703 .19635 .54068 .19007 .56614 .18732 .55292 .19465 Metetra
.358 0 .065 r
.55292 .19465 .56614 .18732 .59185 .18454 .5791 .19292 Metetra
.382 0 .118 r
.5791 .19292 .59185 .18454 .6178 .18173 .60558 .19115 Metetra
.399 0 .159 r
.60558 .19115 .6178 .18173 .644 .17889 .63236 .18929 Metetra
.411 .024 .191 r
.63236 .18929 .644 .17889 .67046 .176 .65944 .1873 Metetra
.419 .043 .216 r
.65944 .1873 .67046 .176 .69716 .17307 .68681 .18516 Metetra
.424 .056 .235 r
.68681 .18516 .69716 .17307 .72412 .1701 .71447 .18284 Metetra
.426 .066 .248 r
.71447 .18284 .72412 .1701 .75134 .16707 .7424 .18032 Metetra
.426 .071 .257 r
.7424 .18032 .75134 .16707 .77882 .16398 .77059 .17758 Metetra
.424 .072 .263 r
.77059 .17758 .77882 .16398 .80656 .16085 .79903 .1746 Metetra
.42 .071 .265 r
.79903 .1746 .80656 .16085 .83457 .15765 .82771 .17137 Metetra
.414 .066 .263 r
.82771 .17137 .83457 .15765 .86283 .1544 .85662 .1679 Metetra
.407 .058 .258 r
.85662 .1679 .86283 .1544 .89137 .15108 .88574 .1642 Metetra
.551 .918 .946 r
.2423 .22151 .2589 .22155 .28226 .21848 .26594 .21815 Metetra
.535 .907 .956 r
.26594 .21815 .28226 .21848 .30579 .21558 .2897 .21508 Metetra
.507 .893 .957 r
.2897 .21508 .30579 .21558 .32949 .21285 .31362 .21231 Metetra
.467 .875 .951 r
.31362 .21231 .32949 .21285 .35338 .21029 .3377 .20984 Metetra
.412 .85 .932 r
.3377 .20984 .35338 .21029 .37747 .20791 .36197 .20766 Metetra
.341 .815 .897 r
.36197 .20766 .37747 .20791 .40177 .20569 .38646 .20577 Metetra
.253 .764 .838 r
.38646 .20577 .40177 .20569 .4263 .20362 .41119 .20413 Metetra
.152 .694 .753 r
.41119 .20413 .4263 .20362 .45108 .20167 .43618 .20273 Metetra
.43618 .20273 .45108 .20167 .47612 .19983 .46145 .20151 Metetra
.054 0 0 r
.46145 .20151 .47612 .19983 .50144 .19806 .48702 .20044 Metetra
.14 0 0 r
.48702 .20044 .50144 .19806 .52703 .19635 .51291 .19947 Metetra
.209 0 0 r
.51291 .19947 .52703 .19635 .55292 .19465 .53913 .19854 Metetra
.26 0 0 r
.53913 .19854 .55292 .19465 .5791 .19292 .56569 .19761 Metetra
.297 0 0 r
.56569 .19761 .5791 .19292 .60558 .19115 .5926 .1966 Metetra
.322 0 0 r
.5926 .1966 .60558 .19115 .63236 .18929 .61984 .19546 Metetra
.338 0 0 r
.61984 .19546 .63236 .18929 .65944 .1873 .64742 .19415 Metetra
.347 0 .025 r
.64742 .19415 .65944 .1873 .68681 .18516 .67533 .1926 Metetra
.351 0 .052 r
.67533 .1926 .68681 .18516 .71447 .18284 .70354 .19077 Metetra
.35 0 .072 r
.70354 .19077 .71447 .18284 .7424 .18032 .73204 .18862 Metetra
.345 0 .084 r
.73204 .18862 .7424 .18032 .77059 .17758 .76082 .18612 Metetra
.336 0 .09 r
.76082 .18612 .77059 .17758 .79903 .1746 .78984 .18324 Metetra
.324 0 .09 r
.78984 .18324 .79903 .1746 .82771 .17137 .81909 .17998 Metetra
.309 0 .085 r
.81909 .17998 .82771 .17137 .85662 .1679 .84854 .17634 Metetra
.29 0 .073 r
.84854 .17634 .85662 .1679 .88574 .1642 .87817 .17231 Metetra
.682 .836 .957 r
.22605 .21831 .2423 .22151 .26594 .21815 .24987 .21481 Metetra
.663 .829 .963 r
.24987 .21481 .26594 .21815 .2897 .21508 .27381 .21165 Metetra
.641 .823 .97 r
.27381 .21165 .2897 .21508 .31362 .21231 .29789 .20883 Metetra
.617 .817 .977 r
.29789 .20883 .31362 .21231 .3377 .20984 .32212 .20636 Metetra
.59 .811 .984 r
.32212 .20636 .3377 .20984 .36197 .20766 .34655 .20423 Metetra
.561 .805 .99 r
.34655 .20423 .36197 .20766 .38646 .20577 .37118 .20243 Metetra
.529 .8 .995 r
.37118 .20243 .38646 .20577 .41119 .20413 .39605 .20093 Metetra
.496 .795 .998 r
.39605 .20093 .41119 .20413 .43618 .20273 .4212 .1997 Metetra
.461 .789 .999 r
.4212 .1997 .43618 .20273 .46145 .20151 .44663 .19869 Metetra
.427 .784 .996 r
.44663 .19869 .46145 .20151 .48702 .20044 .47238 .19785 Metetra
.394 .779 .99 r
.47238 .19785 .48702 .20044 .51291 .19947 .49846 .19713 Metetra
.363 .774 .981 r
.49846 .19713 .51291 .19947 .53913 .19854 .52489 .19646 Metetra
.337 .771 .969 r
.52489 .19646 .53913 .19854 .56569 .19761 .55167 .19579 Metetra
.317 .769 .956 r
.55167 .19579 .56569 .19761 .5926 .1966 .57882 .19504 Metetra
.304 .77 .942 r
.57882 .19504 .5926 .1966 .61984 .19546 .60634 .19415 Metetra
.299 .774 .928 r
.60634 .19415 .61984 .19546 .64742 .19415 .6342 .19305 Metetra
.302 .782 .917 r
.6342 .19305 .64742 .19415 .67533 .1926 .66241 .19169 Metetra
.313 .793 .908 r
.66241 .19169 .67533 .1926 .70354 .19077 .69095 .19001 Metetra
.332 .808 .902 r
.69095 .19001 .70354 .19077 .73204 .18862 .71978 .18797 Metetra
.357 .825 .899 r
.71978 .18797 .73204 .18862 .76082 .18612 .7489 .18553 Metetra
.389 .845 .9 r
.7489 .18553 .76082 .18612 .78984 .18324 .77827 .18266 Metetra
.424 .865 .903 r
.77827 .18266 .78984 .18324 .81909 .17998 .80786 .17935 Metetra
.463 .886 .909 r
.80786 .17935 .81909 .17998 .84854 .17634 .83766 .17559 Metetra
.503 .905 .916 r
.83766 .17559 .84854 .17634 .87817 .17231 .86763 .1714 Metetra
.675 .699 .865 r
.21038 .21143 .22605 .21831 .24987 .21481 .23428 .20798 Metetra
.665 .699 .872 r
.23428 .20798 .24987 .21481 .27381 .21165 .25832 .20481 Metetra
.653 .697 .878 r
.25832 .20481 .27381 .21165 .29789 .20883 .28249 .20194 Metetra
.64 .693 .883 r
.28249 .20194 .29789 .20883 .32212 .20636 .30684 .19938 Metetra
.627 .687 .886 r
.30684 .19938 .32212 .20636 .34655 .20423 .33137 .19711 Metetra
.614 .679 .888 r
.33137 .19711 .34655 .20423 .37118 .20243 .35611 .19513 Metetra
.602 .67 .888 r
.35611 .19513 .37118 .20243 .39605 .20093 .3811 .1934 Metetra
.592 .661 .886 r
.3811 .1934 .39605 .20093 .4212 .1997 .40635 .19191 Metetra
.583 .651 .883 r
.40635 .19191 .4212 .1997 .44663 .19869 .43188 .1906 Metetra
.577 .642 .878 r
.43188 .1906 .44663 .19869 .47238 .19785 .45772 .18945 Metetra
.574 .633 .872 r
.45772 .18945 .47238 .19785 .49846 .19713 .48388 .18839 Metetra
.572 .625 .866 r
.48388 .18839 .49846 .19713 .52489 .19646 .51039 .18737 Metetra
.573 .618 .859 r
.51039 .18737 .52489 .19646 .55167 .19579 .53724 .18634 Metetra
.576 .612 .851 r
.53724 .18634 .55167 .19579 .57882 .19504 .56444 .18524 Metetra
.581 .608 .844 r
.56444 .18524 .57882 .19504 .60634 .19415 .59201 .18401 Metetra
.587 .605 .837 r
.59201 .18401 .60634 .19415 .6342 .19305 .61991 .1826 Metetra
.594 .604 .831 r
.61991 .1826 .6342 .19305 .66241 .19169 .64816 .18094 Metetra
.602 .603 .825 r
.64816 .18094 .66241 .19169 .69095 .19001 .67674 .17901 Metetra
.611 .604 .82 r
.67674 .17901 .69095 .19001 .71978 .18797 .70562 .17675 Metetra
.619 .606 .815 r
.70562 .17675 .71978 .18797 .7489 .18553 .73479 .17414 Metetra
.628 .609 .811 r
.73479 .17414 .7489 .18553 .77827 .18266 .76422 .17114 Metetra
.637 .613 .809 r
.76422 .17114 .77827 .18266 .80786 .17935 .79389 .16776 Metetra
.646 .617 .806 r
.79389 .16776 .80786 .17935 .83766 .17559 .82379 .16398 Metetra
.654 .622 .805 r
.82379 .16398 .83766 .17559 .86763 .1714 .85388 .15982 Metetra
.65 .616 .802 r
.19532 .2013 .21038 .21143 .23428 .20798 .21921 .19804 Metetra
.646 .619 .808 r
.21921 .19804 .23428 .20798 .25832 .20481 .24326 .19495 Metetra
.641 .62 .813 r
.24326 .19495 .25832 .20481 .28249 .20194 .26749 .19203 Metetra
.635 .617 .815 r
.26749 .19203 .28249 .20194 .30684 .19938 .2919 .18929 Metetra
.629 .612 .814 r
.2919 .18929 .30684 .19938 .33137 .19711 .31651 .18672 Metetra
.623 .604 .811 r
.31651 .18672 .33137 .19711 .35611 .19513 .34134 .18431 Metetra
.616 .595 .806 r
.34134 .18431 .35611 .19513 .3811 .1934 .36641 .18205 Metetra
.611 .584 .798 r
.36641 .18205 .3811 .1934 .40635 .19191 .39173 .17991 Metetra
.606 .572 .79 r
.39173 .17991 .40635 .19191 .43188 .1906 .41733 .17789 Metetra
.602 .56 .78 r
.41733 .17789 .43188 .1906 .45772 .18945 .4432 .17593 Metetra
.598 .548 .77 r
.4432 .17593 .45772 .18945 .48388 .18839 .46937 .17403 Metetra
.596 .537 .759 r
.46937 .17403 .48388 .18839 .51039 .18737 .49585 .17213 Metetra
.595 .528 .749 r
.49585 .17213 .51039 .18737 .53724 .18634 .52264 .17021 Metetra
.594 .519 .74 r
.52264 .17021 .53724 .18634 .56444 .18524 .54975 .16824 Metetra
.594 .512 .732 r
.54975 .16824 .56444 .18524 .59201 .18401 .57718 .16617 Metetra
.594 .506 .724 r
.57718 .16617 .59201 .18401 .61991 .1826 .60494 .16398 Metetra
.595 .501 .718 r
.60494 .16398 .61991 .1826 .64816 .18094 .63301 .16162 Metetra
.597 .498 .712 r
.63301 .16162 .64816 .18094 .67674 .17901 .66138 .15908 Metetra
.599 .496 .708 r
.66138 .15908 .67674 .17901 .70562 .17675 .69006 .15633 Metetra
.601 .494 .705 r
.69006 .15633 .70562 .17675 .73479 .17414 .71903 .15336 Metetra
.604 .494 .702 r
.71903 .15336 .73479 .17414 .76422 .17114 .74828 .15013 Metetra
.607 .496 .701 r
.74828 .15013 .76422 .17114 .79389 .16776 .77779 .14666 Metetra
.61 .498 .701 r
.77779 .14666 .79389 .16776 .82379 .16398 .80755 .14294 Metetra
.614 .501 .701 r
.80755 .14294 .82379 .16398 .85388 .15982 .83756 .13897 Metetra
.632 .576 .773 r
.18067 .18914 .19532 .2013 .21921 .19804 .20448 .18618 Metetra
.633 .582 .779 r
.20448 .18618 .21921 .19804 .24326 .19495 .2285 .18321 Metetra
.633 .584 .782 r
.2285 .18321 .24326 .19495 .26749 .19203 .25273 .18024 Metetra
.632 .584 .782 r
.25273 .18024 .26749 .19203 .2919 .18929 .27719 .17727 Metetra
.631 .581 .78 r
.27719 .17727 .2919 .18929 .31651 .18672 .30187 .1743 Metetra
.629 .575 .775 r
.30187 .1743 .31651 .18672 .34134 .18431 .32678 .17132 Metetra
.627 .567 .768 r
.32678 .17132 .34134 .18431 .36641 .18205 .35193 .16834 Metetra
.624 .557 .759 r
.35193 .16834 .36641 .18205 .39173 .17991 .37732 .16535 Metetra
.62 .546 .749 r
.37732 .16535 .39173 .17991 .41733 .17789 .40296 .16234 Metetra
.617 .535 .739 r
.40296 .16234 .41733 .17789 .4432 .17593 .42885 .15932 Metetra
.613 .523 .729 r
.42885 .15932 .4432 .17593 .46937 .17403 .455 .15628 Metetra
.61 .513 .719 r
.455 .15628 .46937 .17403 .49585 .17213 .48141 .15321 Metetra
.607 .503 .709 r
.48141 .15321 .49585 .17213 .52264 .17021 .50808 .15011 Metetra
.604 .494 .701 r
.50808 .15011 .52264 .17021 .54975 .16824 .53502 .14697 Metetra
.602 .486 .693 r
.53502 .14697 .54975 .16824 .57718 .16617 .56224 .1438 Metetra
.6 .479 .686 r
.56224 .1438 .57718 .16617 .60494 .16398 .58973 .14058 Metetra
.598 .473 .681 r
.58973 .14058 .60494 .16398 .63301 .16162 .6175 .13731 Metetra
.597 .468 .676 r
.6175 .13731 .63301 .16162 .66138 .15908 .64555 .13398 Metetra
.596 .464 .672 r
.64555 .13398 .66138 .15908 .69006 .15633 .67389 .1306 Metetra
.595 .462 .669 r
.67389 .1306 .69006 .15633 .71903 .15336 .70252 .12716 Metetra
.595 .46 .668 r
.70252 .12716 .71903 .15336 .74828 .15013 .73143 .12365 Metetra
.595 .459 .667 r
.73143 .12365 .74828 .15013 .77779 .14666 .76064 .12009 Metetra
.595 .46 .667 r
.76064 .12009 .77779 .14666 .80755 .14294 .79014 .11645 Metetra
.596 .461 .668 r
.79014 .11645 .80755 .14294 .83756 .13897 .81993 .11276 Metetra
.622 .567 .772 r
.16601 .17666 .18067 .18914 .20448 .18618 .18971 .174 Metetra
.627 .575 .776 r
.18971 .174 .20448 .18618 .2285 .18321 .21369 .17116 Metetra
.632 .58 .778 r
.21369 .17116 .2285 .18321 .25273 .18024 .23793 .16814 Metetra
.636 .582 .778 r
.23793 .16814 .25273 .18024 .27719 .17727 .26243 .16493 Metetra
.639 .581 .774 r
.26243 .16493 .27719 .17727 .30187 .1743 .28719 .16155 Metetra
.64 .577 .768 r
.28719 .16155 .30187 .1743 .32678 .17132 .31219 .15799 Metetra
.641 .571 .761 r
.31219 .15799 .32678 .17132 .35193 .16834 .33744 .15427 Metetra
.64 .562 .752 r
.33744 .15427 .35193 .16834 .37732 .16535 .36291 .15041 Metetra
.638 .553 .742 r
.36291 .15041 .37732 .16535 .40296 .16234 .38862 .14642 Metetra
.635 .542 .732 r
.38862 .14642 .40296 .16234 .42885 .15932 .41454 .14232 Metetra
.632 .531 .721 r
.41454 .14232 .42885 .15932 .455 .15628 .44068 .13813 Metetra
.628 .52 .712 r
.44068 .13813 .455 .15628 .48141 .15321 .46704 .13389 Metetra
.624 .51 .703 r
.46704 .13389 .48141 .15321 .50808 .15011 .49361 .12961 Metetra
.62 .5 .695 r
.49361 .12961 .50808 .15011 .53502 .14697 .5204 .12532 Metetra
.616 .491 .687 r
.5204 .12532 .53502 .14697 .56224 .1438 .54741 .12104 Metetra
.612 .483 .681 r
.54741 .12104 .56224 .1438 .58973 .14058 .57465 .11681 Metetra
.608 .476 .676 r
.57465 .11681 .58973 .14058 .6175 .13731 .60214 .11263 Metetra
.604 .47 .671 r
.60214 .11263 .6175 .13731 .64555 .13398 .62987 .10854 Metetra
.601 .465 .668 r
.62987 .10854 .64555 .13398 .67389 .1306 .65787 .10454 Metetra
.598 .461 .665 r
.65787 .10454 .67389 .1306 .70252 .12716 .68614 .10064 Metetra
.595 .458 .664 r
.68614 .10064 .70252 .12716 .73143 .12365 .71472 .09686 Metetra
.593 .456 .663 r
.71472 .09686 .73143 .12365 .76064 .12009 .74361 .0932 Metetra
.591 .454 .664 r
.74361 .0932 .76064 .12009 .79014 .11645 .77282 .08966 Metetra
.59 .454 .665 r
.77282 .08966 .79014 .11645 .81993 .11276 .80239 .08623 Metetra
.619 .589 .798 r
.15081 .16558 .16601 .17666 .18971 .174 .17445 .16314 Metetra
.629 .599 .801 r
.17445 .16314 .18971 .174 .21369 .17116 .19841 .16038 Metetra
.638 .606 .801 r
.19841 .16038 .21369 .17116 .23793 .16814 .22268 .15731 Metetra
.646 .609 .799 r
.22268 .15731 .23793 .16814 .26243 .16493 .24726 .15391 Metetra
.653 .61 .794 r
.24726 .15391 .26243 .16493 .28719 .16155 .27211 .15019 Metetra
.658 .608 .788 r
.27211 .15019 .28719 .16155 .31219 .15799 .29723 .14617 Metetra
.661 .603 .78 r
.29723 .14617 .31219 .15799 .33744 .15427 .32259 .14187 Metetra
.663 .597 .771 r
.32259 .14187 .33744 .15427 .36291 .15041 .34819 .13731 Metetra
.663 .588 .761 r
.34819 .13731 .36291 .15041 .38862 .14642 .37399 .13254 Metetra
.661 .578 .751 r
.37399 .13254 .38862 .14642 .41454 .14232 .4 .12759 Metetra
.659 .568 .742 r
.4 .12759 .41454 .14232 .44068 .13813 .42619 .12251 Metetra
.655 .557 .733 r
.42619 .12251 .44068 .13813 .46704 .13389 .45257 .11735 Metetra
.65 .547 .724 r
.45257 .11735 .46704 .13389 .49361 .12961 .47912 .11215 Metetra
.645 .536 .716 r
.47912 .11215 .49361 .12961 .5204 .12532 .50584 .10697 Metetra
.64 .527 .709 r
.50584 .10697 .5204 .12532 .54741 .12104 .53276 .10185 Metetra
.634 .518 .703 r
.53276 .10185 .54741 .12104 .57465 .11681 .55986 .09683 Metetra
.628 .509 .698 r
.55986 .09683 .57465 .11681 .60214 .11263 .58717 .09196 Metetra
.623 .502 .694 r
.58717 .09196 .60214 .11263 .62987 .10854 .61471 .08727 Metetra
.617 .495 .691 r
.61471 .08727 .62987 .10854 .65787 .10454 .64249 .08279 Metetra
.612 .489 .689 r
.64249 .08279 .65787 .10454 .68614 .10064 .67055 .07854 Metetra
.607 .485 .688 r
.67055 .07854 .68614 .10064 .71472 .09686 .6989 .07453 Metetra
.602 .481 .687 r
.6989 .07453 .71472 .09686 .74361 .0932 .72758 .07079 Metetra
.598 .478 .688 r
.72758 .07079 .74361 .0932 .77282 .08966 .75662 .0673 Metetra
.594 .477 .689 r
.75662 .0673 .77282 .08966 .80239 .08623 .78603 .06405 Metetra
.623 .652 .858 r
.13458 .15722 .15081 .16558 .17445 .16314 .15824 .15486 Metetra
.637 .661 .857 r
.15824 .15486 .17445 .16314 .19841 .16038 .18226 .15212 Metetra
.65 .668 .854 r
.18226 .15212 .19841 .16038 .22268 .15731 .20661 .14899 Metetra
.662 .672 .849 r
.20661 .14899 .22268 .15731 .24726 .15391 .23129 .14547 Metetra
.673 .674 .843 r
.23129 .14547 .24726 .15391 .27211 .15019 .25627 .14156 Metetra
.682 .674 .836 r
.25627 .14156 .27211 .15019 .29723 .14617 .28153 .13728 Metetra
.688 .672 .829 r
.28153 .13728 .29723 .14617 .32259 .14187 .30704 .13266 Metetra
.693 .668 .821 r
.30704 .13266 .32259 .14187 .34819 .13731 .33279 .12774 Metetra
.697 .663 .813 r
.33279 .12774 .34819 .13731 .37399 .13254 .35874 .12255 Metetra
.698 .656 .805 r
.35874 .12255 .37399 .13254 .4 .12759 .38489 .11716 Metetra
.697 .649 .798 r
.38489 .11716 .4 .12759 .42619 .12251 .41121 .11162 Metetra
.695 .641 .791 r
.41121 .11162 .42619 .12251 .45257 .11735 .4377 .10598 Metetra
.692 .632 .785 r
.4377 .10598 .45257 .11735 .47912 .11215 .46435 .1003 Metetra
.687 .624 .779 r
.46435 .1003 .47912 .11215 .50584 .10697 .49115 .09466 Metetra
.682 .615 .774 r
.49115 .09466 .50584 .10697 .53276 .10185 .51812 .08909 Metetra
.676 .606 .77 r
.51812 .08909 .53276 .10185 .55986 .09683 .54526 .08367 Metetra
.669 .598 .767 r
.54526 .08367 .55986 .09683 .58717 .09196 .5726 .07842 Metetra
.661 .59 .764 r
.5726 .07842 .58717 .09196 .61471 .08727 .60014 .07341 Metetra
.653 .582 .763 r
.60014 .07341 .61471 .08727 .64249 .08279 .62793 .06867 Metetra
.645 .575 .762 r
.62793 .06867 .64249 .08279 .67055 .07854 .65598 .06421 Metetra
.637 .569 .762 r
.65598 .06421 .67055 .07854 .6989 .07453 .68433 .06007 Metetra
.629 .564 .762 r
.68433 .06007 .6989 .07453 .72758 .07079 .71301 .05624 Metetra
.621 .559 .764 r
.71301 .05624 .72758 .07079 .75662 .0673 .74206 .05274 Metetra
.613 .556 .766 r
.74206 .05274 .75662 .0673 .78603 .06405 .7715 .04954 Metetra
.62 .767 .95 r
.11695 .15225 .13458 .15722 .15824 .15486 .14075 .1498 Metetra
.639 .771 .943 r
.14075 .1498 .15824 .15486 .18226 .15212 .16491 .14699 Metetra
.657 .774 .935 r
.16491 .14699 .18226 .15212 .20661 .14899 .18941 .1438 Metetra
.673 .778 .929 r
.18941 .1438 .20661 .14899 .23129 .14547 .21424 .14024 Metetra
.687 .781 .922 r
.21424 .14024 .23129 .14547 .25627 .14156 .23938 .13631 Metetra
.7 .785 .917 r
.23938 .13631 .25627 .14156 .28153 .13728 .2648 .13203 Metetra
.711 .79 .913 r
.2648 .13203 .28153 .13728 .30704 .13266 .29048 .12742 Metetra
.721 .794 .909 r
.29048 .12742 .30704 .13266 .33279 .12774 .3164 .12251 Metetra
.729 .798 .907 r
.3164 .12251 .33279 .12774 .35874 .12255 .34255 .11736 Metetra
.735 .803 .906 r
.34255 .11736 .35874 .12255 .38489 .11716 .36889 .11201 Metetra
.739 .808 .906 r
.36889 .11201 .38489 .11716 .41121 .11162 .39542 .1065 Metetra
.741 .812 .908 r
.39542 .1065 .41121 .11162 .4377 .10598 .42212 .10091 Metetra
.742 .817 .91 r
.42212 .10091 .4377 .10598 .46435 .1003 .44898 .09528 Metetra
.741 .821 .914 r
.44898 .09528 .46435 .1003 .49115 .09466 .47602 .08967 Metetra
.737 .824 .918 r
.47602 .08967 .49115 .09466 .51812 .08909 .50322 .08414 Metetra
.732 .827 .924 r
.50322 .08414 .51812 .08909 .54526 .08367 .53061 .07874 Metetra
.724 .83 .93 r
.53061 .07874 .54526 .08367 .5726 .07842 .55819 .07351 Metetra
.715 .83 .937 r
.55819 .07351 .5726 .07842 .60014 .07341 .58599 .06849 Metetra
.703 .83 .943 r
.58599 .06849 .60014 .07341 .62793 .06867 .61403 .06373 Metetra
.689 .828 .95 r
.61403 .06373 .62793 .06867 .65598 .06421 .64234 .05924 Metetra
.674 .825 .956 r
.64234 .05924 .65598 .06421 .68433 .06007 .67095 .05504 Metetra
.657 .82 .961 r
.67095 .05504 .68433 .06007 .71301 .05624 .69989 .05114 Metetra
.64 .813 .966 r
.69989 .05114 .71301 .05624 .74206 .05274 .72919 .04755 Metetra
.624 .806 .97 r
.72919 .04755 .74206 .05274 .7715 .04954 .75889 .04425 Metetra
.557 .879 .991 r
.0978 .15052 .11695 .15225 .14075 .1498 .12186 .14782 Metetra
.588 .882 .992 r
.12186 .14782 .14075 .1498 .16491 .14699 .14625 .14485 Metetra
.613 .885 .99 r
.14625 .14485 .16491 .14699 .18941 .1438 .17096 .14161 Metetra
.632 .889 .987 r
.17096 .14161 .18941 .1438 .21424 .14024 .19598 .13809 Metetra
.647 .896 .984 r
.19598 .13809 .21424 .14024 .23938 .13631 .2213 .1343 Metetra
.657 .905 .98 r
.2213 .1343 .23938 .13631 .2648 .13203 .24689 .13026 Metetra
.663 .916 .977 r
.24689 .13026 .2648 .13203 .29048 .12742 .27276 .12597 Metetra
.663 .928 .972 r
.27276 .12597 .29048 .12742 .3164 .12251 .29887 .12146 Metetra
.657 .94 .964 r
.29887 .12146 .3164 .12251 .34255 .11736 .32522 .11677 Metetra
.642 .948 .951 r
.32522 .11677 .34255 .11736 .36889 .11201 .35179 .11192 Metetra
.617 .95 .929 r
.35179 .11192 .36889 .11201 .39542 .1065 .37857 .10695 Metetra
.579 .942 .897 r
.37857 .10695 .39542 .1065 .42212 .10091 .40556 .10191 Metetra
.529 .922 .852 r
.40556 .10191 .42212 .10091 .44898 .09528 .43276 .09682 Metetra
.468 .888 .795 r
.43276 .09682 .44898 .09528 .47602 .08967 .46015 .09174 Metetra
.399 .842 .73 r
.46015 .09174 .47602 .08967 .50322 .08414 .48775 .0867 Metetra
.327 .788 .66 r
.48775 .0867 .50322 .08414 .53061 .07874 .51557 .08174 Metetra
.51557 .08174 .53061 .07874 .55819 .07351 .54361 .07689 Metetra
.54361 .07689 .55819 .07351 .58599 .06849 .57189 .07219 Metetra
.57189 .07219 .58599 .06849 .61403 .06373 .60043 .06764 Metetra
.60043 .06764 .61403 .06373 .64234 .05924 .62925 .06328 Metetra
.62925 .06328 .64234 .05924 .67095 .05504 .65838 .05912 Metetra
.65838 .05912 .67095 .05504 .69989 .05114 .68783 .05516 Metetra
.68783 .05516 .69989 .05114 .72919 .04755 .71764 .0514 Metetra
.007 0 0 r
.71764 .0514 .72919 .04755 .75889 .04425 .74783 .04784 Metetra
.435 .873 .891 r
.07728 .15112 .0978 .15052 .12186 .14782 .10171 .14804 Metetra
.473 .889 .918 r
.10171 .14804 .12186 .14782 .14625 .14485 .1264 .14485 Metetra
.497 .898 .932 r
.1264 .14485 .14625 .14485 .17096 .14161 .15137 .14155 Metetra
.507 .902 .934 r
.15137 .14155 .17096 .14161 .19598 .13809 .17661 .13814 Metetra
.505 .903 .927 r
.17661 .13814 .19598 .13809 .2213 .1343 .20211 .13462 Metetra
.489 .899 .909 r
.20211 .13462 .2213 .1343 .24689 .13026 .22788 .13099 Metetra
.457 .886 .876 r
.22788 .13099 .24689 .13026 .27276 .12597 .25392 .12725 Metetra
.409 .86 .824 r
.25392 .12725 .27276 .12597 .29887 .12146 .28021 .12342 Metetra
.344 .816 .75 r
.28021 .12342 .29887 .12146 .32522 .11677 .30676 .11951 Metetra
.265 .752 .657 r
.30676 .11951 .32522 .11677 .35179 .11192 .33357 .11552 Metetra
.33357 .11552 .35179 .11192 .37857 .10695 .36063 .11146 Metetra
.36063 .11146 .37857 .10695 .40556 .10191 .38795 .10735 Metetra
.38795 .10735 .40556 .10191 .43276 .09682 .41553 .10321 Metetra
.049 0 0 r
.41553 .10321 .43276 .09682 .46015 .09174 .44337 .09904 Metetra
.104 0 0 r
.44337 .09904 .46015 .09174 .48775 .0867 .47147 .09485 Metetra
.148 0 0 r
.47147 .09485 .48775 .0867 .51557 .08174 .49984 .09067 Metetra
.183 0 0 r
.49984 .09067 .51557 .08174 .54361 .07689 .52848 .08649 Metetra
.211 0 0 r
.52848 .08649 .54361 .07689 .57189 .07219 .55741 .08234 Metetra
.232 0 .01 r
.55741 .08234 .57189 .07219 .60043 .06764 .58664 .07821 Metetra
.248 0 .031 r
.58664 .07821 .60043 .06764 .62925 .06328 .61617 .07411 Metetra
.259 0 .044 r
.61617 .07411 .62925 .06328 .65838 .05912 .64602 .07005 Metetra
.266 0 .051 r
.64602 .07005 .65838 .05912 .68783 .05516 .67619 .06603 Metetra
.269 0 .052 r
.67619 .06603 .68783 .05516 .71764 .0514 .7067 .06205 Metetra
.268 0 .047 r
.7067 .06205 .71764 .0514 .74783 .04784 .73757 .0581 Metetra
.418 .866 .844 r
.05586 .15251 .07728 .15112 .10171 .14804 .0807 .14901 Metetra
.438 .876 .871 r
.0807 .14901 .10171 .14804 .1264 .14485 .10573 .14557 Metetra
.441 .877 .883 r
.10573 .14557 .1264 .14485 .15137 .14155 .13098 .14221 Metetra
.428 .871 .88 r
.13098 .14221 .15137 .14155 .17661 .13814 .15644 .13893 Metetra
.399 .855 .861 r
.15644 .13893 .17661 .13814 .20211 .13462 .18213 .13572 Metetra
.353 .828 .823 r
.18213 .13572 .20211 .13462 .22788 .13099 .20806 .13257 Metetra
.29 .786 .762 r
.20806 .13257 .22788 .13099 .25392 .12725 .23424 .12949 Metetra
.212 .724 .678 r
.23424 .12949 .25392 .12725 .28021 .12342 .2607 .12645 Metetra
.2607 .12645 .28021 .12342 .30676 .11951 .28743 .12345 Metetra
.28743 .12345 .30676 .11951 .33357 .11552 .31445 .12047 Metetra
.041 0 0 r
.31445 .12047 .33357 .11552 .36063 .11146 .34178 .11749 Metetra
.108 0 0 r
.34178 .11749 .36063 .11146 .38795 .10735 .36942 .1145 Metetra
.162 0 0 r
.36942 .1145 .38795 .10735 .41553 .10321 .39738 .11147 Metetra
.204 0 0 r
.39738 .11147 .41553 .10321 .44337 .09904 .42567 .10838 Metetra
.237 0 0 r
.42567 .10838 .44337 .09904 .47147 .09485 .4543 .10523 Metetra
.261 0 .011 r
.4543 .10523 .47147 .09485 .49984 .09067 .48327 .10198 Metetra
.279 0 .046 r
.48327 .10198 .49984 .09067 .52848 .08649 .51257 .09862 Metetra
.292 0 .073 r
.51257 .09862 .52848 .08649 .55741 .08234 .54222 .09514 Metetra
.3 0 .093 r
.54222 .09514 .55741 .08234 .58664 .07821 .57221 .09152 Metetra
.305 0 .107 r
.57221 .09152 .58664 .07821 .61617 .07411 .60254 .08776 Metetra
.307 0 .115 r
.60254 .08776 .61617 .07411 .64602 .07005 .6332 .08384 Metetra
.305 0 .118 r
.6332 .08384 .64602 .07005 .67619 .06603 .66419 .07976 Metetra
.301 0 .117 r
.66419 .07976 .67619 .06603 .7067 .06205 .69551 .07552 Metetra
.295 0 .11 r
.69551 .07552 .7067 .06205 .73757 .0581 .72715 .07112 Metetra
.543 .921 .929 r
.03421 .15289 .05586 .15251 .0807 .14901 .05944 .14899 Metetra
.535 .913 .941 r
.05944 .14899 .0807 .14901 .10573 .14557 .0848 .14533 Metetra
.516 .903 .945 r
.0848 .14533 .10573 .14557 .13098 .14221 .1103 .14191 Metetra
.486 .89 .94 r
.1103 .14191 .13098 .14221 .15644 .13893 .13598 .13873 Metetra
.443 .871 .924 r
.13598 .13873 .15644 .13893 .18213 .13572 .16184 .13579 Metetra
.386 .844 .893 r
.16184 .13579 .18213 .13572 .20806 .13257 .18791 .13307 Metetra
.314 .804 .842 r
.18791 .13307 .20806 .13257 .23424 .12949 .21423 .13055 Metetra
.23 .748 .768 r
.21423 .13055 .23424 .12949 .2607 .12645 .24082 .12822 Metetra
.24082 .12822 .2607 .12645 .28743 .12345 .2677 .12602 Metetra
.2677 .12602 .28743 .12345 .31445 .12047 .2949 .12394 Metetra
.031 0 0 r
.2949 .12394 .31445 .12047 .34178 .11749 .32245 .12192 Metetra
.099 0 0 r
.32245 .12192 .34178 .11749 .36942 .1145 .35037 .11992 Metetra
.152 0 0 r
.35037 .11992 .36942 .1145 .39738 .11147 .37866 .1179 Metetra
.193 0 0 r
.37866 .1179 .39738 .11147 .42567 .10838 .40735 .1158 Metetra
.222 0 0 r
.40735 .1158 .42567 .10838 .4543 .10523 .43645 .11357 Metetra
.242 0 0 r
.43645 .11357 .4543 .10523 .48327 .10198 .46595 .11118 Metetra
.256 0 0 r
.46595 .11118 .48327 .10198 .51257 .09862 .49585 .10857 Metetra
.263 0 0 r
.49585 .10857 .51257 .09862 .54222 .09514 .52616 .1057 Metetra
.266 0 .005 r
.52616 .1057 .54222 .09514 .57221 .09152 .55685 .10255 Metetra
.264 0 .018 r
.55685 .10255 .57221 .09152 .60254 .08776 .58792 .09909 Metetra
.259 0 .025 r
.58792 .09909 .60254 .08776 .6332 .08384 .61934 .09529 Metetra
.25 0 .026 r
.61934 .09529 .6332 .08384 .66419 .07976 .65111 .09115 Metetra
.237 0 .021 r
.65111 .09115 .66419 .07976 .69551 .07552 .68319 .08667 Metetra
.221 0 .01 r
.68319 .08667 .69551 .07552 .72715 .07112 .71558 .08185 Metetra
.667 .895 .979 r
.01307 .15058 .03421 .15289 .05944 .14899 .0386 .14643 Metetra
.647 .884 .984 r
.0386 .14643 .05944 .14899 .0848 .14533 .06422 .1426 Metetra
.623 .876 .989 r
.06422 .1426 .0848 .14533 .1103 .14191 .08994 .13912 Metetra
.595 .868 .994 r
.08994 .13912 .1103 .14191 .13598 .13873 .11579 .13597 Metetra
.562 .861 .997 r
.11579 .13597 .13598 .13873 .16184 .13579 .14181 .13317 Metetra
.523 .853 .997 r
.14181 .13317 .16184 .13579 .18791 .13307 .16802 .13068 Metetra
.478 .844 .991 r
.16802 .13068 .18791 .13307 .21423 .13055 .19446 .12848 Metetra
.427 .83 .978 r
.19446 .12848 .21423 .13055 .24082 .12822 .22117 .12655 Metetra
.371 .812 .954 r
.22117 .12655 .24082 .12822 .2677 .12602 .24818 .12482 Metetra
.31 .787 .919 r
.24818 .12482 .2677 .12602 .2949 .12394 .27553 .12326 Metetra
.249 .756 .871 r
.27553 .12326 .2949 .12394 .32245 .12192 .30325 .12181 Metetra
.189 .721 .815 r
.30325 .12181 .32245 .12192 .35037 .11992 .33137 .1204 Metetra
.136 .683 .753 r
.33137 .1204 .35037 .11992 .37866 .1179 .35992 .11897 Metetra
.35992 .11897 .37866 .1179 .40735 .1158 .3889 .11745 Metetra
.3889 .11745 .40735 .1158 .43645 .11357 .41833 .11577 Metetra
.41833 .11577 .43645 .11357 .46595 .11118 .44822 .11388 Metetra
.44822 .11388 .46595 .11118 .49585 .10857 .47856 .11171 Metetra
.47856 .11171 .49585 .10857 .52616 .1057 .50934 .1092 Metetra
.50934 .1092 .52616 .1057 .55685 .10255 .54054 .10631 Metetra
.54054 .10631 .55685 .10255 .58792 .09909 .57215 .103 Metetra
.57215 .103 .58792 .09909 .61934 .09529 .60414 .09925 Metetra
.60414 .09925 .61934 .09529 .65111 .09115 .63649 .09504 Metetra
.63649 .09504 .65111 .09115 .68319 .08667 .66915 .09036 Metetra
.66915 .09036 .68319 .08667 .71558 .08185 .70212 .08524 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .15875 L
s
.96935 .15875 m
1 .2417 L
s
1 .2417 m
.70298 .09078 L
s
.70298 .09078 m
.68874 0 L
s
.03716 .09436 m
0 .18109 L
s
0 .18109 m
.70298 .09078 L
s
.70298 .09078 m
.68874 0 L
s
.68874 0 m
.03716 .09436 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{300, 180},
  ImageCacheValid->False,
  CellTags->"S2.10.10"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[12]= ",
  CellTags->"S2.10.10"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica", "TI"],
  " usually scales the images of three\[Hyphen]dimensional objects to be as \
large as possible, given the display area you specify. Although in most cases \
this scaling is what you want, it does have the consequence that the size at \
which a particular three\[Hyphen]dimensional object is drawn may vary with \
the orientation of the object. You can set the option ",
  StyleBox["SphericalRegion", "MR"],
  " ",
  StyleBox["->", "MR"],
  " ",
  StyleBox["True", "MR"],
  " to avoid such variation. With this option setting, ",
  StyleBox["Mathematica", "TI"],
  " effectively puts a sphere around the three\[Hyphen]dimensional bounding \
box, and scales the final image so that the whole of this sphere fits inside \
the display area you specify. The sphere has its center at the center of the \
bounding box, and is drawn so that the bounding box just fits inside it. "
}], "Text",
  CellTags->{"S2.10.10", "10.28"}],

Cell["This draws a rather elongated version of the plot. ", "MathCaption",
  CellTags->{"S2.10.10", "10.29"}],

Cell[CellGroupData[{

Cell["Show[surf, BoxRatios -> {1, 5, 1}]", "Input",
  CellLabel->"In[13]:= ",
  CellTags->"S2.10.10"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.11167 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0631342 1.22138 3.08998e-17 1.22138 [
[.01029 .09481 -11.5904 -9 ]
[.01029 .09481 .40961 0 ]
[.07865 .06868 -11.4593 -9 ]
[.07865 .06868 .54067 0 ]
[.14785 .04223 -5.66414 -9 ]
[.14785 .04223 .33586 0 ]
[.21792 .01545 -5.59862 -9 ]
[.21792 .01545 .40138 0 ]
[.28888 -0.01167 -5.53309 -9 ]
[.28888 -0.01167 .46691 0 ]
[.09716 -0.01485 -9.44024 -9.8125 ]
[.09716 -0.01485 .55976 0 ]
[.13451 .51152 -12 -2.96591 ]
[.13451 .51152 0 6.03409 ]
[.40089 .77866 -6 -3.10701 ]
[.40089 .77866 0 5.89299 ]
[.63228 1.01072 -6 -3.22434 ]
[.63228 1.01072 0 5.77566 ]
[.32796 .80124 -10.0625 -3.3875 ]
[.32796 .80124 0 6.425 ]
[.00284 .15473 -12 -2.80185 ]
[.00284 .15473 0 6.19815 ]
[-0.00372 .2338 -6 -2.83315 ]
[-0.00372 .2338 0 6.16685 ]
[-0.01044 .31484 -6 -2.86527 ]
[-0.01044 .31484 0 6.13473 ]
[-0.07535 .26091 -10 -3.08918 ]
[-0.07535 .26091 0 6.72332 ]
[ 0 0 0 0 ]
[ 1 1.11167 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0207 .10598 m
.29873 0 L
s
.0207 .10598 m
.02591 .11156 L
s
[(-2)] .01029 .09481 .93173 1 Mshowa
.08892 .07997 m
.09406 .08562 L
s
[(-1)] .07865 .06868 .90989 1 Mshowa
.15799 .05365 m
.16306 .05936 L
s
[(0)] .14785 .04223 .88805 1 Mshowa
.22792 .02699 m
.23292 .03276 L
s
[(1)] .21792 .01545 .86621 1 Mshowa
.29873 0 m
.30366 .00583 L
s
[(2)] .28888 -0.01167 .84436 1 Mshowa
.125 Mabswid
.03428 .1008 m
.03739 .10416 L
s
.04789 .09562 m
.05099 .09898 L
s
.06153 .09041 m
.06463 .09379 L
s
.07521 .0852 m
.0783 .08858 L
s
.10267 .07474 m
.10574 .07813 L
s
.11644 .06948 m
.11951 .07289 L
s
.13026 .06422 m
.13332 .06763 L
s
.14411 .05894 m
.14716 .06236 L
s
.1719 .04834 m
.17494 .05178 L
s
.18586 .04303 m
.18888 .04647 L
s
.19984 .03769 m
.20286 .04114 L
s
.21386 .03235 m
.21687 .0358 L
s
.24201 .02162 m
.245 .02509 L
s
.25614 .01624 m
.25912 .01971 L
s
.2703 .01084 m
.27327 .01432 L
s
.2845 .00543 m
.28746 .00892 L
s
gsave
.09716 -0.01485 -70.4402 -13.8125 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
0 .35705 m
.75168 1.11167 L
s
.14896 .5066 m
.15619 .50414 L
s
[(-2)] .13451 .51152 1 -0.34091 Mshowa
.41547 .77415 m
.42276 .77189 L
s
[(0)] .40089 .77866 1 -0.30955 Mshowa
.64697 1.00655 m
.65431 1.00447 L
s
[(2)] .63228 1.01072 1 -0.28348 Mshowa
.125 Mabswid
.2193 .57721 m
.22364 .57576 L
s
.28707 .64525 m
.29143 .64383 L
s
.35242 .71085 m
.35679 .70947 L
s
.47634 .83526 m
.48073 .83393 L
s
.53515 .8943 m
.53954 .893 L
s
.59199 .95136 m
.59639 .95009 L
s
.07592 .43327 m
.08024 .43175 L
s
.70017 1.05996 m
.70458 1.05873 L
s
gsave
.32796 .80124 -71.0625 -7.3875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.062 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.0207 .10598 m
0 .35705 L
s
.01713 .14934 m
.02427 .14665 L
s
[(-2)] .00284 .15473 1 -0.37737 Mshowa
.0106 .2285 m
.01776 .22584 L
s
[(0)] -0.00372 .2338 1 -0.37041 Mshowa
.00391 .30962 m
.01109 .30702 L
s
[(2)] -0.01044 .31484 1 -0.36327 Mshowa
.125 Mabswid
.01551 .16895 m
.0198 .16734 L
s
.01388 .18868 m
.01817 .18707 L
s
.01225 .20853 m
.01654 .20693 L
s
.00894 .24859 m
.01324 .24701 L
s
.00728 .26881 m
.01158 .26723 L
s
.0056 .28915 m
.0099 .28758 L
s
.01873 .12985 m
.02302 .12823 L
s
.02033 .11048 m
.02461 .10885 L
s
.00221 .33022 m
.00652 .32867 L
s
.0005 .35095 m
.00481 .3494 L
s
gsave
-0.07535 .26091 -71 -7.08918 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 17.8125 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 11.250 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.0207 .10598 m
0 .35705 L
s
0 .35705 m
.75168 1.11167 L
s
.75168 1.11167 m
.74539 .88376 L
s
.74539 .88376 m
.0207 .10598 L
s
.29873 0 m
.98577 .81368 L
s
.98577 .81368 m
1 1.04412 L
s
1 1.04412 m
.2887 .25338 L
s
.2887 .25338 m
.29873 0 L
s
.0207 .10598 m
0 .35705 L
s
0 .35705 m
.2887 .25338 L
s
.2887 .25338 m
.29873 0 L
s
.29873 0 m
.0207 .10598 L
s
.74539 .88376 m
.98577 .81368 L
s
.98577 .81368 m
1 1.04412 L
s
1 1.04412 m
.75168 1.11167 L
s
.75168 1.11167 m
.74539 .88376